;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';function enumerateAll(storages,dir,options){var storageIndex=0;var ds_cursor=null;var cursor={continue:function cursor_continue(){ds_cursor.continue();}};function enumerateNextStorage(){ds_cursor=storages[storageIndex].enumerate(dir,options||{});ds_cursor.onsuccess=onsuccess;ds_cursor.onerror=onerror;};function onsuccess(e){cursor.result=e.target.result;if(!cursor.result){storageIndex++;if(storageIndex<storages.length){enumerateNextStorage();return;}}
if(cursor.onsuccess){try{cursor.onsuccess(e);}catch(err){console.warn('enumerateAll onsuccess threw',err);}}};function onerror(e){cursor.error=e.target.error;if(cursor.onerror){try{cursor.onerror(e);}catch(err){console.warn('enumerateAll onerror threw',err);}}};enumerateNextStorage();return cursor;};'use strict';var MediaDB=(function(){function MediaDB(mediaType,metadataParser,options){this.mediaType=mediaType;this.metadataParser=metadataParser;if(!options)
options={};this.indexes=options.indexes||[];this.version=options.version||1;this.mimeTypes=options.mimeTypes;this.autoscan=(options.autoscan!==undefined)?options.autoscan:true;this.state=MediaDB.OPENING;this.scanning=false;this.parsingBigFiles=false;this.updateRecord=options.updateRecord;if(options.excludeFilter&&(options.excludeFilter instanceof RegExp)){this.clientExcludeFilter=options.excludeFilter;}
this.batchHoldTime=options.batchHoldTime||100;this.batchSize=options.batchSize||0;this.dbname='MediaDB/'+this.mediaType+'/';var media=this;this.details={eventListeners:{},pendingInsertions:[],pendingDeletions:[],whenDoneProcessing:[],pendingCreateNotifications:[],pendingDeleteNotifications:[],pendingNotificationTimer:null,newestFileModTime:0};if(!this.metadataParser){this.metadataParser=function(file,callback){setTimeout(function(){callback({});},0);};}
var dbVersion=(0xFFFF&this.version)<<16|(0xFFFF&MediaDB.VERSION);var openRequest=indexedDB.open(this.dbname,dbVersion);openRequest.onerror=function(e){console.error('MediaDB():',openRequest.error.name);};openRequest.onblocked=function(e){console.error('indexedDB.open() is blocked in MediaDB()');};openRequest.onupgradeneeded=function(e){var db=openRequest.result;var transaction=e.target.transaction;var oldVersion=e.oldVersion;var oldDbVersion=0xFFFF&oldVersion;var oldClientVersion=0xFFFF&(oldVersion>>16);if(oldClientVersion===0){oldDbVersion=2;oldClientVersion=oldVersion/oldDbVersion;}
if(0==db.objectStoreNames.length){createObjectStores(db);}else{handleUpgrade(db,transaction,oldDbVersion,oldClientVersion);}};openRequest.onsuccess=function(e){media.db=openRequest.result;media.db.onerror=function(event){console.error('MediaDB: ',event.target.error&&event.target.error.name);};var cursorRequest=media.db.transaction('files','readonly').objectStore('files').index('date').openCursor(null,'prev');cursorRequest.onerror=function(){console.error('MediaDB initialization error',cursorRequest.error);};cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){media.details.newestFileModTime=cursor.value.date;}
else{media.details.newestFileModTime=0;}
initDeviceStorage();};};function createObjectStores(db){var filestore=db.createObjectStore('files',{keyPath:'name'});filestore.createIndex('date','date');media.indexes.forEach(function(indexName){if(indexName==='name'||indexName==='date')
return;filestore.createIndex(indexName,indexName);});}
function enumerateOldFiles(store,callback){var openCursorReq=store.openCursor();openCursorReq.onsuccess=function(){var cursor=openCursorReq.result;if(cursor){callback(cursor.value);cursor.continue();}};}
function handleUpgrade(db,trans,oldDbVersion,oldClientVersion){media.state=MediaDB.UPGRADING;var evtDetail={'oldMediaDBVersion':oldDbVersion,'oldClientVersion':oldClientVersion,'newMediaDBVersion':MediaDB.VERSION,'newClientVersion':media.version};dispatchEvent(media,'upgrading',evtDetail);var store=trans.objectStore('files');if(media.version!=oldClientVersion){upgradeIndexesChanges(store);}
var clientUpgradeNeeded=(media.version!=oldClientVersion)&&media.updateRecord;if((2!=oldDbVersion||3!=MediaDB.VERSION)&&!clientUpgradeNeeded){return;}
enumerateOldFiles(store,function doUpgrade(dbfile){if(2==oldDbVersion&&3==MediaDB.VERSION){upgradeDBVer2to3(store,dbfile);}
if(clientUpgradeNeeded){handleClientUpgrade(store,dbfile,oldClientVersion);}});}
function upgradeIndexesChanges(store){var dbIndexes=store.indexNames;var clientIndexes=media.indexes;var clientIndex;for(var i=0;i<dbIndexes.length;i++){if('name'===dbIndexes[i]||'date'===dbIndexes[i]){continue;}
if(clientIndexes.indexOf(dbIndexes[i])<0){store.deleteIndex(dbIndexes[i]);}}
for(i=0;i<clientIndexes.length;i++){if(!dbIndexes.contains(clientIndexes[i])){store.createIndex(clientIndexes[i],clientIndexes[i]);}}}
function upgradeDBVer2to3(store,dbfile){if(dbfile.name[0]==='/'){return;}
store.delete(dbfile.name);dbfile.name='/sdcard/'+dbfile.name;store.add(dbfile);}
function handleClientUpgrade(store,dbfile,oldClientVersion){try{dbfile.metadata=media.updateRecord(dbfile,oldClientVersion,media.version);store.put(dbfile);}catch(ex){console.warn('client app updates record, '+dbfile.name+', failed: '+ex.message);}}
function initDeviceStorage(){var details=media.details;details.storages=navigator.getDeviceStorages(mediaType);details.availability={};getStorageAvailability();function getStorageAvailability(){var next=0;getNextAvailability();function getNextAvailability(){if(next>=details.storages.length){setupHandlers();return;}
var s=details.storages[next++];var name=s.storageName;var req=s.available();req.onsuccess=function(e){details.availability[name]=req.result;getNextAvailability();};req.onerror=function(e){details.availability[name]='unavailable';getNextAvailability();};}}
function setupHandlers(){for(var i=0;i<details.storages.length;i++)
details.storages[i].addEventListener('change',changeHandler);details.dsEventListener=changeHandler;sendInitialEvent();}
function sendInitialEvent(){var state=getState(details.availability);changeState(media,state);if(media.autoscan)
scan(media);}
function getState(availability){var n=0;var a=0;var u=0;var s=0;for(var name in availability){n++;switch(availability[name]){case'available':a++;break;case'unavailable':u++;break;case'shared':s++;break;}}
if(s>0)
return MediaDB.UNMOUNTED;if(u===n)
return MediaDB.NOCARD;return MediaDB.READY;}
function changeHandler(e){switch(e.reason){case'modified':case'deleted':fileChangeHandler(e);return;case'available':case'unavailable':case'shared':volumeChangeHandler(e);return;default:return;}}
function volumeChangeHandler(e){var storageName=e.target.storageName;if(details.availability[storageName]===e.reason)
return;var oldState=media.state;details.availability[storageName]=e.reason;var newState=getState(details.availability);if(newState!==oldState){changeState(media,newState);if(newState===MediaDB.READY){if(media.autoscan)
scan(media);}
else{endscan(media);}}
else if(newState===MediaDB.READY){if(e.reason==='available'){dispatchEvent(media,'ready');if(media.autoscan)
scan(media);}
else if(e.reason==='unavailable'){dispatchEvent(media,'cardremoved');deleteAllFiles(storageName);}}}
function fileChangeHandler(e){var filename=e.path;if(ignoreName(media,filename))
return;if(e.reason==='modified')
insertRecord(media,filename);else
deleteRecord(media,filename);}
function deleteAllFiles(storageName){var storagePrefix=storageName?'/'+storageName+'/':'';var store=media.db.transaction('files').objectStore('files');var cursorRequest=store.openCursor();cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){if(cursor.value.name.startsWith(storagePrefix)){deleteRecord(media,cursor.value.name);}
cursor.continue();}};}}}
MediaDB.prototype={close:function close(){this.db.close();for(var i=0;i<this.details.storages.length;i++){var s=this.details.storages[i];s.removeEventListener('change',this.details.dsEventListener);}
changeState(this,MediaDB.CLOSED);},addEventListener:function addEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type))
this.details.eventListeners[type]=[];var listeners=this.details.eventListeners[type];if(listeners.indexOf(listener)!==-1)
return;listeners.push(listener);},removeEventListener:function removeEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type))
return;var listeners=this.details.eventListeners[type];var position=listeners.indexOf(listener);if(position===-1)
return;listeners.splice(position,1);},getFileInfo:function getFile(filename,callback,errback){if(this.state===MediaDB.OPENING)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){var msg='MediaDB.getFileInfo: unknown filename: '+filename;if(errback)
errback(msg);else
console.error(msg);};read.onsuccess=function(){if(callback)
callback(read.result);};},getFile:function getFile(filename,callback,errback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);var getRequest=storage.get(filename);getRequest.onsuccess=function(){callback(getRequest.result);};getRequest.onerror=function(){var errmsg=getRequest.error&&getRequest.error.name;if(errback)
errback(errmsg);else
console.error('MediaDB.getFile:',errmsg);};},deleteFile:function deleteFile(filename){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);storage.delete(filename).onerror=function(e){console.error('MediaDB.deleteFile(): Failed to delete',filename,'from DeviceStorage:',e.target.error);};},addFile:function addFile(filename,file){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var storage=navigator.getDeviceStorage(media.mediaType);var deletereq=storage.delete(filename);deletereq.onsuccess=deletereq.onerror=save;function save(){var request=storage.addNamed(file,filename);request.onerror=function(){console.error('MediaDB: Failed to store',filename,'in DeviceStorage:',request.error);};}},updateMetadata:function(filename,metadata,callback){if(this.state===MediaDB.OPENING)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){console.error('MediaDB.updateMetadata called with unknown filename');};read.onsuccess=function(){var fileinfo=read.result;Object.keys(metadata).forEach(function(key){fileinfo.metadata[key]=metadata[key];});var write=media.db.transaction('files','readwrite').objectStore('files').put(fileinfo);write.onerror=function(){console.error('MediaDB.updateMetadata: database write failed',write.error&&write.error.name);};if(callback){write.onsuccess=function(){callback();};}};},count:function(key,range,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);if(arguments.length===1){callback=key;range=undefined;key=undefined;}
else if(arguments.length===2){callback=range;range=key;key=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var countRequest=store.count(range||null);countRequest.onerror=function(){console.error('MediaDB.count() failed with',countRequest.error);};countRequest.onsuccess=function(e){callback(e.target.result);};},enumerate:function enumerate(key,range,direction,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var handle={state:'enumerating'};if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var cursorRequest=store.openCursor(range||null,direction||'next');cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(!cursor.value.fail)
callback(cursor.value);}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}
cursor.continue();}
else{handle.state='complete';callback(null);}};return handle;},advancedEnumerate:function(key,range,direction,index,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var handle={state:'enumerating'};var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var cursorRequest=store.openCursor(range||null,direction||'next');var isTarget=false;cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(!cursor.value.fail&&isTarget){callback(cursor.value);cursor.continue();}
else{cursor.advance(index-1);isTarget=true;}}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}}
else{handle.state='complete';callback(null);}};return handle;},enumerateAll:function enumerateAll(key,range,direction,callback){var batch=[];if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
return this.enumerate(key,range,direction,function(fileinfo){if(fileinfo!==null)
batch.push(fileinfo);else
callback(batch);});},cancelEnumeration:function cancelEnumeration(handle){if(handle.state==='enumerating')
handle.state='cancelling';},getAll:function getAll(callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var store=this.db.transaction('files').objectStore('files');var request=store.mozGetAll();request.onerror=function(){console.error('MediaDB.getAll() failed with',request.error);};request.onsuccess=function(){var all=request.result;var good=all.filter(function(fileinfo){return!fileinfo.fail;});callback(good);};},scan:function(){scan(this);},freeSpace:function freeSpace(callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);var freereq=storage.freeSpace();freereq.onsuccess=function(){callback(freereq.result);};}};MediaDB.VERSION=3;MediaDB.OPENING='opening';MediaDB.UPGRADING='upgrading';MediaDB.READY='ready';MediaDB.NOCARD='nocard';MediaDB.UNMOUNTED='unmounted';MediaDB.CLOSED='closed';function ignore(media,file){if(ignoreName(media,file.name))
return true;if(media.mimeTypes&&media.mimeTypes.indexOf(file.type)===-1)
return true;return false;}
function ignoreName(media,filename){if(media.clientExcludeFilter&&media.clientExcludeFilter.test(filename)){return true;}else{var path=filename.substring(0,filename.lastIndexOf('/')+1);return(path[0]==='.'||path.indexOf('/.')!==-1);}}
function scan(media){media.scanning=true;dispatchEvent(media,'scanstart');quickScan(media.details.newestFileModTime);function quickScan(timestamp){var cursor;if(timestamp>0){media.details.firstscan=false;cursor=enumerateAll(media.details.storages,'',{since:new Date(timestamp+1)});}
else{media.details.firstscan=true;media.details.records=[];cursor=enumerateAll(media.details.storages,'');}
cursor.onsuccess=function(){if(!media.scanning)
return;var file=cursor.result;if(file){if(!ignore(media,file))
insertRecord(media,file);cursor.continue();}
else{whenDoneProcessing(media,function(){sendNotifications(media);if(media.details.firstscan){endscan(media);}
else{fullScan();}});}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};}
function fullScan(){if(media.state!==MediaDB.READY){endscan(media);return;}
var dsfiles=[];var cursor=enumerateAll(media.details.storages,'');cursor.onsuccess=function(){if(!media.scanning)
return;var file=cursor.result;if(file){if(!ignore(media,file)){dsfiles.push(file);}
cursor.continue();}
else{getDBFiles();}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};function getDBFiles(){var store=media.db.transaction('files').objectStore('files');var getAllRequest=store.mozGetAll();getAllRequest.onsuccess=function(){if(!media.scanning)
return;var dbfiles=getAllRequest.result;compareLists(dbfiles,dsfiles);};}
function compareLists(dbfiles,dsfiles){dsfiles.sort(function(a,b){if(a.name<b.name)
return-1;else
return 1;});var dsindex=0,dbindex=0;while(true){var dsfile;if(dsindex<dsfiles.length)
dsfile=dsfiles[dsindex];else
dsfile=null;var dbfile;if(dbindex<dbfiles.length)
dbfile=dbfiles[dbindex];else
dbfile=null;if(dsfile===null&&dbfile===null)
break;if(dbfile===null){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile===null){deleteRecord(media,dbfile.name);dbindex++;continue;}
if(dsfile.name===dbfile.name){var lastModified=dsfile.lastModifiedDate;var timeDifference=lastModified.getTime()-dbfile.date;var sameTime=(timeDifference===0||((Math.abs(timeDifference)<=12*60*60*1000)&&(timeDifference%10*60*1000===0)));var sameSize=dsfile.size===dbfile.size;if(!sameTime||!sameSize){deleteRecord(media,dbfile.name);insertRecord(media,dsfile);}
dsindex++;dbindex++;continue;}
if(dsfile.name<dbfile.name){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile.name>dbfile.name){deleteRecord(media,dbfile.name);dbindex++;continue;}
console.error('Assertion failed');}
insertRecord(media,null);}}}
function endscan(media){if(media.scanning){media.scanning=false;media.parsingBigFiles=false;dispatchEvent(media,'scanend');}}
function insertRecord(media,fileOrName){var details=media.details;details.pendingInsertions.push(fileOrName);if(details.processingQueue)
return;processQueue(media);}
function deleteRecord(media,filename){var details=media.details;details.pendingDeletions.push(filename);if(details.processingQueue)
return;processQueue(media);}
function whenDoneProcessing(media,f){var details=media.details;if(details.processingQueue)
details.whenDoneProcessing.push(f);else
f();}
function processQueue(media){var details=media.details;details.processingQueue=true;next();function next(){if(details.pendingDeletions.length>0){deleteFiles();}
else if(details.pendingInsertions.length>0){insertFile(details.pendingInsertions.shift());}
else{details.processingQueue=false;if(details.whenDoneProcessing.length>0){var functions=details.whenDoneProcessing;details.whenDoneProcessing=[];functions.forEach(function(f){f();});}}}
function deleteFiles(){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');deleteNextFile();function deleteNextFile(){if(details.pendingDeletions.length===0){next();return;}
var filename=details.pendingDeletions.shift();var request=store.delete(filename);request.onerror=function(){console.warn('MediaDB: Unknown file in deleteRecord:',filename,getreq.error);deleteNextFile();};request.onsuccess=function(){queueDeleteNotification(media,filename);deleteNextFile();};}}
function insertFile(f){if(f===null){sendNotifications(media);endscan(media);next();return;}
if(typeof f==='string'){var storage=navigator.getDeviceStorage(media.mediaType);var getreq=storage.get(f);getreq.onerror=function(){console.warn('MediaDB: Unknown file in insertRecord:',f,getreq.error);next();};getreq.onsuccess=function(){if(media.mimeTypes&&ignore(media,getreq.result))
next();else
parseMetadata(getreq.result,f);};}
else{parseMetadata(f,f.name);}}
function parseMetadata(file,filename){if(!file.lastModifiedDate){console.warn('MediaDB: parseMetadata: no lastModifiedDate for',filename,'using Date.now() until #793955 is fixed');}
var fileinfo={name:filename,type:file.type,size:file.size,date:file.lastModifiedDate?file.lastModifiedDate.getTime():Date.now()};if(fileinfo.date>details.newestFileModTime)
details.newestFileModTime=fileinfo.date;media.metadataParser(file,gotMetadata,metadataError,parsingBigFile);function parsingBigFile(){media.parsingBigFiles=true;}
function metadataError(e){console.warn('MediaDB: error parsing metadata for',filename,':',e);fileinfo.fail=true;storeRecord(fileinfo);}
function gotMetadata(metadata){fileinfo.metadata=metadata;storeRecord(fileinfo);if(!media.scanning){media.parsingBigFiles=false;}}}
function storeRecord(fileinfo){if(media.details.firstscan){media.details.records.push(fileinfo);if(!fileinfo.fail){queueCreateNotification(media,fileinfo);}
next();}
else{var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');var request=store.add(fileinfo);request.onsuccess=function(){if(!fileinfo.fail)
queueCreateNotification(media,fileinfo);next();};request.onerror=function(event){if(request.error.name==='ConstraintError'){event.stopPropagation();event.preventDefault();var putrequest=store.put(fileinfo);putrequest.onsuccess=function(){queueDeleteNotification(media,fileinfo.name);if(!fileinfo.fail)
queueCreateNotification(media,fileinfo);next();};putrequest.onerror=function(){console.error('MediaDB: unexpected ConstraintError','in insertRecord for file:',fileinfo.name);next();};}
else{console.error('MediaDB: unexpected error in insertRecord:',request.error,'for file:',fileinfo.name);next();}};}}}
function queueCreateNotification(media,fileinfo){var creates=media.details.pendingCreateNotifications;creates.push(fileinfo);if(media.batchSize&&creates.length>=media.batchSize)
sendNotifications(media);else
resetNotificationTimer(media);}
function queueDeleteNotification(media,filename){var deletes=media.details.pendingDeleteNotifications;deletes.push(filename);if(media.batchSize&&deletes.length>=media.batchSize)
sendNotifications(media);else
resetNotificationTimer(media);}
function resetNotificationTimer(media){var details=media.details;if(details.pendingNotificationTimer)
clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=setTimeout(function(){sendNotifications(media);},media.batchHoldTime);}
function sendNotifications(media){var details=media.details;if(details.pendingNotificationTimer){clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=null;}
if(details.pendingDeleteNotifications.length>0){var deletions=details.pendingDeleteNotifications;details.pendingDeleteNotifications=[];dispatchEvent(media,'deleted',deletions);}
if(details.pendingCreateNotifications.length>0){var creations=details.pendingCreateNotifications;details.pendingCreateNotifications=[];if(details.firstscan&&details.records.length>0){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');for(var i=0;i<details.records.length;i++)
store.add(details.records[i]);details.records.length=0;transaction.oncomplete=function(){dispatchEvent(media,'created',creations);};}
else{dispatchEvent(media,'created',creations);}}}
function dispatchEvent(media,type,detail){var handler=media['on'+type];var listeners=media.details.eventListeners[type];if(!handler&&(!listeners||listeners.length==0))
return;var event={type:type,target:media,currentTarget:media,timestamp:Date.now(),detail:detail};if(typeof handler==='function'){try{handler.call(media,event);}
catch(e){console.warn('MediaDB: ','on'+type,'event handler threw',e,e.stack);}}
if(!listeners)
return;for(var i=0;i<listeners.length;i++){try{var listener=listeners[i];if(typeof listener==='function'){listener.call(media,event);}
else{listener.handleEvent(event);}}
catch(e){console.warn('MediaDB: ',type,'event listener threw',e,e.stack);}}}
function changeState(media,state){if(media.state!==state){media.state=state;if(state===MediaDB.READY)
dispatchEvent(media,'ready');else
dispatchEvent(media,'unavailable',state);}}
return MediaDB;}());;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var Normalizer={initAsciiNormalizer:function normalizer_init(){var equivalentChars={'a':'áăǎâäȧạȁàảȃāąåḁⱥãǽǣæ','A':'ÁĂǍÂÄȦẠȀÀẢȂĀĄÅḀȺÃǼǢÆ','b':'ḃḅɓḇƀƃ','B':'ḂḄƁḆɃƂ','c':'ćčçĉċƈȼ','C':'ĆČÇĈĊƇȻ','d':'ďḑḓḋḍɗḏđƌð','D':'ĎḐḒḊḌƊḎĐƋ','e':'éĕěȩêḙëėẹȅèẻȇēę','E':'ÉĔĚȨÊḘËĖẸȄÈẺȆĒĘ','f':'ḟƒ','F':'ḞƑ','g':'ǵğǧģĝġɠḡǥ','G':'ǴĞǦĢĜĠƓḠǤ','h':'ḫȟḩĥⱨḧḣḥħ','H':'ḪȞḨĤⱧḦḢḤĦ','i':'íĭǐîïịȉìỉȋīįɨĩḭı','I':'ÍĬǏÎÏỊȈÌỈȊĪĮƗĨḬ','j':'ĵɉ','J':'ĴɈ','k':'ḱǩķⱪꝃḳƙḵꝁ','K':'ḰǨĶⱩꝂḲƘḴꝀ','l':'ĺƚľļḽḷⱡꝉḻŀɫł','L':'ĹȽĽĻḼḶⱠꝈḺĿⱢŁ','m':'ḿṁṃɱ','M':'ḾṀṂⱮ','n':'ńňņṋṅṇǹɲṉƞñ','N':'ŃŇŅṊṄṆǸƝṈȠÑ','o':'óŏǒôöȯọőȍòỏơȏꝋꝍōǫøõœ','O':'ÓŎǑÔÖȮỌŐȌÒỎƠȎꝊꝌŌǪØÕŒ','p':'ṕṗꝓƥᵽꝑ','P':'ṔṖꝒƤⱣꝐ','q':'ꝗ','Q':'Ꝗ','r':'ŕřŗṙṛȑȓṟɍɽ','R':'ŔŘŖṘṚȐȒṞɌⱤ','s':'śšşŝșṡṣß$','S':'ŚŠŞŜȘṠṢ','t':'ťţṱțⱦṫṭƭṯʈŧ','T':'ŤŢṰȚȾṪṬƬṮƮŦ','u':'úŭǔûṷüṳụűȕùủưȗūųůũṵ','U':'ÚŬǓÛṶÜṲỤŰȔÙỦƯȖŪŲŮŨṴ','v':'ṿʋṽ','V':'ṾƲṼ','w':'ẃŵẅẇẉẁⱳ','W':'ẂŴẄẆẈẀⱲ','x':'ẍẋ','X':'ẌẊ','y':'ýŷÿẏỵỳƴỷỿȳɏỹ','Y':'ÝŶŸẎỴỲƳỶỾȲɎỸ','z':'źžẑⱬżẓȥẕƶ','Z':'ŹŽẐⱫŻẒȤẔƵ'};this._toAsciiForm={};for(var letter in equivalentChars){var accentedForms=equivalentChars[letter];for(var i=accentedForms.length-1;i>=0;i--)
this._toAsciiForm[accentedForms[i]]=letter;}},toAscii:function normalizer_toAscii(str){if(!str||typeof str!='string')
return'';if(!this._toAsciiForm)
Normalizer.initAsciiNormalizer();var result='';for(var i=0,len=str.length;i<len;i++)
result+=this._toAsciiForm[str.charAt(i)]||str.charAt(i);return result;},escapeHTML:function normalizer_escapeHTML(str,escapeQuotes){if(Array.isArray(str)){return Normalizer.escapeHTML(str.join(' '),escapeQuotes);}
if(!str||typeof str!='string')
return'';var escaped=str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');if(escapeQuotes)
return escaped.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return escaped;},escapeRegExp:function normalizer_escapeRegExp(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,'\\$&');}};;'use strict';var AVRCP={PLAY_PRESS:'media-play-button-press',PLAY_RELEASE:'media-play-button-release',PAUSE_PRESS:'media-pause-button-press',PAUSE_RELEASE:'media-pause-button-release',PLAY_PAUSE_PRESS:'media-play-pause-button-press',PLAY_PAUSE_RELEASE:'media-play-pause-button-release',STOP_PRESS:'media-stop-button-press',STOP_RELEASE:'media-stop-button-release',NEXT_PRESS:'media-next-track-button-press',NEXT_RELEASE:'media-next-track-button-release',PREVIOUS_PRESS:'media-previous-track-button-press',PREVIOUS_RELEASE:'media-previous-track-button-release',FAST_FORWARD_PRESS:'media-fast-forward-button-press',FAST_FORWARD_RELEASE:'media-fast-forward-button-release',REWIND_PRESS:'media-rewind-button-press',REWIND_RELEASE:'media-rewind-button-release'};var IAC={PLAY_PRESS:'play',PLAY_PAUSE_PRESS:'playpause',PAUSE_PRESS:'pause',STOP_PRESS:'stop',NEXT_PRESS:'nexttrack',PREVIOUS_PRESS:'prevtrack',FAST_FORWARD_PRESS:'fastforwardstart',FAST_FORWARD_RELEASE:'fastforwardend',REWIND_PRESS:'rewindstart',REWIND_RELEASE:'rewindend'};var REMOTE_CONTROLS={PLAY:'play',PLAY_PAUSE:'playpause',PAUSE:'pause',STOP:'stop',NEXT:'next',PREVIOUS:'previous',SEEK_PRESS:'seekpress',SEEK_RELEASE:'seekrelease',UPDATE_METADATA:'updatemetadata',UPDATE_PLAYSTATUS:'updateplaystatus'};function MediaRemoteControls(){this.bluetooth=navigator.mozBluetooth;this.defaultAdapter=null;this._commandListeners={};this._isSCOConnected=false;for(var command in REMOTE_CONTROLS)
this._commandListeners[REMOTE_CONTROLS[command]]=[];}
MediaRemoteControls.prototype.addCommandListener=function(command,listener){if(this._commandListeners[command])
this._commandListeners[command].push(listener);};MediaRemoteControls.prototype.removeCommandListener=function(name,listener){if(this._commandListeners[name]){var index=-1;this._commandListeners[name].forEach(function(currListener,i){if(currListener===listener)
index=i;});if(index!==-1)
this._commandListeners[name].splice(index,1);}};MediaRemoteControls.prototype.start=function(callback){var self=this;navigator.mozSetMessageHandler('media-button',this._commandHandler.bind(this));if(this.bluetooth){this.bluetooth.onadapteradded=initialDefaultAdapter;this.bluetooth.ondisabled=resetDefaultAdapter;initialDefaultAdapter();}else{console.warn('No mozBluetooth');}
function initialDefaultAdapter(){var request=self.bluetooth.getDefaultAdapter();request.onsuccess=configureAdapter;request.onerror=resetDefaultAdapter;}
function configureAdapter(event){self.defaultAdapter=event.target.result;self.defaultAdapter.onrequestmediaplaystatus=playstatusHandler;self.defaultAdapter.ona2dpstatuschanged=a2dpConnectionHandler;self.defaultAdapter.onscostatuschanged=scoConnectionHandler;if(callback)
callback();}
function playstatusHandler(){if(self._commandListeners['updateplaystatus'].length>0)
self._commandHandler(REMOTE_CONTROLS.UPDATE_PLAYSTATUS);}
function a2dpConnectionHandler(event){var isConnected=event.status;if(isConnected&&self._commandListeners['updatemetadata'].length>0)
self._commandHandler(REMOTE_CONTROLS.UPDATE_METADATA);else
self._commandHandler(AVRCP.PAUSE_PRESS);}
function scoConnectionHandler(event){self._isSCOConnected=event.status;if(self._isSCOConnected)
self._commandHandler(AVRCP.PAUSE_PRESS);else
self._commandHandler(AVRCP.PLAY_PRESS);}
function resetDefaultAdapter(){self.defaultAdapter=null;}
this._queuedMessages=[];navigator.mozApps.getSelf().onsuccess=function(){var app=this.result;if(!app.connect){this._queuedMessages=null;return;}
app.connect('mediacomms').then(function(ports){self._ports=ports;self._ports.forEach(function(port){port.onmessage=function(event){self._commandHandler(event.data.command);};self._queuedMessages.forEach(function(message){port.postMessage(message);});});self._queuedMessages=null;});};};MediaRemoteControls.prototype.getSCOStatus=function(callback){if(this.defaultAdapter){var request=this.defaultAdapter.isScoConnected();request.onsuccess=function(event){callback(event.target.result);};request.onerror=function(event){callback(false);};}else{callback(false);}};MediaRemoteControls.prototype._postMessage=function(name,value){var message={type:name,data:value};if(!this._ports){if(this._queuedMessages)
this._queuedMessages.push(message);}else{this._ports.forEach(function(port){port.postMessage(message);});}};MediaRemoteControls.prototype._commandHandler=function(message){var type='remote';var option={};switch(message){case AVRCP.PLAY_PRESS:case IAC.PLAY_PRESS:option.detail={command:REMOTE_CONTROLS.PLAY,isSCOConnected:this._isSCOConnected};break;case AVRCP.PLAY_PAUSE_PRESS:case IAC.PLAY_PAUSE_PRESS:option.detail={command:REMOTE_CONTROLS.PLAY_PAUSE,isSCOConnected:this._isSCOConnected};break;case AVRCP.PAUSE_PRESS:case IAC.PAUSE_PRESS:option.detail={command:REMOTE_CONTROLS.PAUSE,isSCOConnected:this._isSCOConnected};break;case AVRCP.STOP_PRESS:case IAC.STOP_PRESS:option.detail={command:REMOTE_CONTROLS.STOP};break;case AVRCP.NEXT_PRESS:case IAC.NEXT_PRESS:option.detail={command:REMOTE_CONTROLS.NEXT};break;case AVRCP.PREVIOUS_PRESS:case IAC.PREVIOUS_PRESS:option.detail={command:REMOTE_CONTROLS.PREVIOUS};break;case AVRCP.FAST_FORWARD_PRESS:case IAC.FAST_FORWARD_PRESS:option.detail={command:REMOTE_CONTROLS.SEEK_PRESS,direction:1};break;case AVRCP.REWIND_PRESS:case IAC.REWIND_PRESS:option.detail={command:REMOTE_CONTROLS.SEEK_PRESS,direction:-1};break;case AVRCP.FAST_FORWARD_RELEASE:case IAC.FAST_FORWARD_RELEASE:case AVRCP.REWIND_RELEASE:case IAC.REWIND_RELEASE:option.detail={command:REMOTE_CONTROLS.SEEK_RELEASE};break;case REMOTE_CONTROLS.UPDATE_METADATA:case REMOTE_CONTROLS.UPDATE_PLAYSTATUS:option.detail={command:message};break;default:return;}
var event=new CustomEvent(type,option);this._executeCommandListeners(event);};MediaRemoteControls.prototype._executeCommandListeners=function(event){if(!event.detail)
return;this._commandListeners[event.detail.command].forEach(function(listener){listener(event);});};MediaRemoteControls.prototype.notifyAppInfo=function(info){this._postMessage('appinfo',info);};MediaRemoteControls.prototype.notifyMetadataChanged=function(metadata){if(this.defaultAdapter){var request=this.defaultAdapter.sendMediaMetaData(metadata);request.onerror=function(){console.log('Sending Metadata error');};}
this._postMessage('nowplaying',metadata);};MediaRemoteControls.prototype.notifyStatusChanged=function(status){if(this.defaultAdapter){if(status==='mozinterruptbegin')
return;var request=this.defaultAdapter.sendMediaPlayStatus(status);request.onerror=function(){console.log('Sending Playstatus error');};}
this._postMessage('status',status);};;'use strict';(function(exports){if(exports.ForwardLock)
return;const mimeSubtype='vnd.mozilla.oma.drm.fl';const SECRET_SETTINGS_ID='oma.drm.forward_lock.secret.key';var secret=null;function xor(buffer,key){var words=new Uint32Array(buffer,0,buffer.byteLength>>2);for(var i=0,n=words.length;i<n;i++)
words[i]^=key;}
function lockBuffer(secret,content,type,metadata){var header='LOCKED 1 '+escape(type)+'\n';if(metadata){for(var p in metadata){header+=escape(p)+':'+escape(metadata[p])+'\n';}}
header+='\0';var buffer=new Uint8Array(new Uint8Array(content)).buffer;xor(buffer,secret);return new Blob([header,buffer],{type:type.split('/')[0]+'/'+mimeSubtype});}
function lockBlob(secret,blob,metadata,callback){var reader=new FileReader();reader.readAsArrayBuffer(blob);reader.onload=function(){callback(lockBuffer(secret,reader.result,blob.type,metadata));};}
function unlockBlob(secret,blob,callback,errorCallback){var reader=new FileReader();reader.readAsArrayBuffer(blob);reader.onload=function(){var buffer=reader.result;var bytes=new Uint8Array(buffer);var header='';var contentStart;for(var i=0;i<bytes.length;i++){if(bytes[i]===0){contentStart=i+1;break;}
header+=String.fromCharCode(bytes[i]);}
if(!header.startsWith('LOCKED'))
return error('Bad magic number');if(header.substring(6,9)!==' 1 ')
return error('Unsupported version number');if(!contentStart)
return error('No content');var eol=header.indexOf('\n');if(eol===-1)
return error('malformed header');var type=unescape(header.substring(9,eol).trim());var metadata={};var lines=header.substring(eol+1).split('\n');for(var i=0;i<lines.length;i++){var line=lines[i];if(!line)
continue;var[key,value]=line.split(':');if(!key||!value)
return error('malformed metadata');metadata[unescape(key)]=unescape(value);}
var content=buffer.slice(contentStart);xor(content,secret);var blob=new Blob([content],{type:type});try{callback(blob,metadata);}
catch(e){console.error('Exception in content callback',e);}};function error(msg){msg='LCKA.decrypt(): '+msg;if(errorCallback){try{errorCallback(msg);}
catch(e){console.error('Exception in error callback',e);}}
else{console.error(msg);}}}
function getKey(callback){try{if(secret!==null){report(secret);return;}
var lock=navigator.mozSettings.createLock();var getreq=lock.get(SECRET_SETTINGS_ID);getreq.onsuccess=function(){secret=getreq.result[SECRET_SETTINGS_ID]||null;report(secret);};getreq.onerror=function(){console.error('Error getting ForwardLock setting',getreq.error);report(null);};}
catch(e){console.error('Exception in ForwardLock.getKey():',e);report(null);}
function report(secret){if(callback){try{callback(secret);}
catch(e){console.error('Exception in ForwardLock.getKey() callback');}}}}
function getOrCreateKey(callback){getKey(function(key){if(key!==null){report(key);return;}
secret=((Math.random()*0xFFFFFFFF)|0)+1;var setting={};setting[SECRET_SETTINGS_ID]=secret;var setreq=navigator.mozSettings.createLock().set(setting);setreq.onsuccess=function(){report(secret);};setreq.onerror=function(){console.error('Failed to set key in ForwardLock.getOrCreateKey()',setreq.error.name);secret=null;};});function report(secret){if(callback){try{callback(secret);}
catch(e){console.error('Exception in ForwardLock.getOrCreateKey() callback');}}}}
exports.ForwardLock={lockBuffer:lockBuffer,lockBlob:lockBlob,unlockBlob:unlockBlob,mimeSubtype:mimeSubtype,getKey:getKey,getOrCreateKey:getOrCreateKey};}(this));;(function ScrollDetector(){'use strict';var scrollTimeout=null;const IDLE_TIME=400;var isScrolling=false;function handleScroll(e){if(!isScrolling){dispatchScrollStart();}
if(scrollTimeout){window.clearTimeout(scrollTimeout);}
scrollTimeout=window.setTimeout(dispatchScrollEnd,IDLE_TIME);}
function dispatchScrollStart(){isScrolling=true;dispatchCustomScrollEvent();}
function dispatchScrollEnd(){isScrolling=false;dispatchCustomScrollEvent();}
function dispatchCustomScrollEvent(){var eventName=isScrolling?'scrollstart':'scrollend';window.dispatchEvent(new CustomEvent(eventName));}
window.addEventListener('mozbrowserasyncscroll',handleScroll,true);window.addEventListener('scroll',handleScroll,true);})();;'use strict';function formatTime(secs){if(isNaN(secs))
return;secs=Math.floor(secs);var formatedTime;var seconds=secs%60;var minutes=Math.floor(secs/60)%60;var hours=Math.floor(secs/3600);if(hours===0){formatedTime=(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}else{formatedTime=(hours<10?'0'+hours:hours)+':'+
(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}
return formatedTime;}
function hash(str){var hash=0;if(str.length===0)return hash;for(var i=0;i<str.length;i++){var c=str.charCodeAt(i);hash=((hash<<5)-hash)+c;hash=hash&hash;}
return hash;}
function generateDefaultThumbnailURL(metadata){var infoForHash=(!metadata.album&&!metadata.artist)?metadata.title:metadata.album+metadata.artist;var hashedNumber=(Math.abs(hash(infoForHash))%10)+1;return'/style/images/AlbumArt'+hashedNumber+'_small.png';}
function getAlbumArtBlob(fileinfo,callback){var getBlob=function(url,callback){var xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.responseType='blob';xhr.onload=function(){callback(null,xhr.response);};xhr.onerror=function(){callback('error');};try{xhr.send();}catch(e){callback(e);}};if('picture'in fileinfo.metadata){getThumbnailURL(fileinfo,function(url){if(!url)
return callback(null);getBlob(url,callback);});}
else{var url=generateDefaultThumbnailURL(fileinfo.metadata);getBlob(url,callback);}};'use strict';var musicTitle;var playlistTitle;var artistTitle;var albumTitle;var songTitle;var pickerTitle;var unknownAlbum;var unknownArtist;var unknownTitle;var shuffleAllTitle;var highestRatedTitle;var recentlyAddedTitle;var mostPlayedTitle;var leastPlayedTitle;var unknownTitleL10nId='unknownTitle';var unknownArtistL10nId='unknownArtist';var unknownAlbumL10nId='unknownAlbum';var shuffleAllTitleL10nId='playlists-shuffle-all';var highestRatedTitleL10nId='playlists-highest-rated';var recentlyAddedTitleL10nId='playlists-recently-added';var mostPlayedTitleL10nId='playlists-most-played';var leastPlayedTitleL10nId='playlists-least-played';var musicdb;var pendingPick;var SETTINGS_OPTION_KEY='settings_option_key';var playerSettings;window.addEventListener('localized',function onlocalized(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;musicTitle=navigator.mozL10n.get('music');playlistTitle=navigator.mozL10n.get('playlists');artistTitle=navigator.mozL10n.get('artists');albumTitle=navigator.mozL10n.get('albums');songTitle=navigator.mozL10n.get('songs');pickerTitle=navigator.mozL10n.get('picker-title');unknownAlbum=navigator.mozL10n.get(unknownAlbumL10nId);unknownArtist=navigator.mozL10n.get(unknownArtistL10nId);unknownTitle=navigator.mozL10n.get(unknownTitleL10nId);shuffleAllTitle=navigator.mozL10n.get(shuffleAllTitleL10nId);highestRatedTitle=navigator.mozL10n.get(highestRatedTitleL10nId);recentlyAddedTitle=navigator.mozL10n.get(recentlyAddedTitleL10nId);mostPlayedTitle=navigator.mozL10n.get(mostPlayedTitleL10nId);leastPlayedTitle=navigator.mozL10n.get(leastPlayedTitleL10nId);if(!musicdb){init();TitleBar.init();TilesView.init();ListView.init();SubListView.init();SearchView.init();TabBar.init();if(document.URL.indexOf('#pick')!==-1){navigator.mozSetMessageHandler('activity',function activityHandler(a){var activityName=a.source.name;if(activityName==='pick'){pendingPick=a;}});TabBar.option='title';ModeManager.start(MODE_PICKER);}else{TabBar.option='mix';ModeManager.start(MODE_TILES);asyncStorage.getItem(SETTINGS_OPTION_KEY,function(settings){playerSettings=settings;});var doneButton=document.getElementById('title-done');doneButton.parentNode.removeChild(doneButton);}}else{ModeManager.updateTitle();}
TabBar.playlistArray.localize();});var displayingScanProgress=false;function init(){musicdb=new MediaDB('music',metadataParserWrapper,{indexes:['metadata.album','metadata.artist','metadata.title','metadata.rated','metadata.played','date'],batchSize:1,autoscan:false,version:2});function metadataParserWrapper(file,onsuccess,onerror){LazyLoader.load('js/metadata_scripts.js',function(){parseAudioMetadata(file,onsuccess,onerror);});}
musicdb.onupgrading=function(){showOverlay('upgrade');};musicdb.onunavailable=function(event){stopPlayingAndReset();var why=event.detail;if(why===MediaDB.NOCARD)
showOverlay('nocard');else if(why===MediaDB.UNMOUNTED)
showOverlay('pluggedin');};musicdb.oncardremoved=stopPlayingAndReset;function stopPlayingAndReset(){if(typeof PlayerView!=='undefined')
PlayerView.stop();if(!pendingPick){window.location.hash='#mix';TabBar.option='mix';ModeManager.start(MODE_TILES);TilesView.hideSearch();}};musicdb.onready=function(){if(currentOverlay==='nocard'||currentOverlay==='pluggedin'||currentOverlay==='upgrade')
showOverlay(null);showCurrentView(function(){document.getElementById('spinner-overlay').classList.add('hidden');musicdb.scan();if(document.URL.indexOf('#pick')===-1){MusicComms.init();}});};var filesDeletedWhileScanning=0;var filesFoundWhileScanning=0;var filesFoundBatch=0;var scanning=false;var SCAN_UPDATE_BATCH_SIZE=25;var DELETE_BATCH_TIMEOUT=500;var deleteTimer=null;var scanProgress=document.getElementById('scan-progress');var scanCount=document.getElementById('scan-count');var scanArtist=document.getElementById('scan-artist');var scanTitle=document.getElementById('scan-title');musicdb.onscanstart=function(){scanning=true;displayingScanProgress=false;filesFoundWhileScanning=0;filesFoundBatch=0;filesDeletedWhileScanning=0;};musicdb.onscanend=function(){scanning=false;if(displayingScanProgress){scanProgress.classList.add('hidden');displayingScanProgress=false;}
if(filesFoundBatch>0||filesDeletedWhileScanning>0){filesFoundWhileScanning=0;filesFoundBatch=0;filesDeletedWhileScanning=0;showCurrentView();}};musicdb.oncreated=function(event){if(scanning){var currentMode=ModeManager.currentMode;if(!displayingScanProgress&&(currentMode===MODE_TILES||currentMode===MODE_LIST||currentMode===MODE_PICKER))
{displayingScanProgress=true;scanProgress.classList.remove('hidden');}
var n=event.detail.length;filesFoundWhileScanning+=n;filesFoundBatch+=n;scanCount.textContent=filesFoundWhileScanning;var metadata=event.detail[0].metadata;scanArtist.textContent=metadata.artist||'';scanTitle.textContent=metadata.title||'';if(filesFoundBatch>SCAN_UPDATE_BATCH_SIZE){filesFoundBatch=0;showCurrentView();}}
else{showCurrentView();}};musicdb.ondeleted=function(event){if(scanning){filesDeletedWhileScanning+=event.detail.length;}
else{if(deleteTimer)
clearTimeout(deleteTimer);deleteTimer=setTimeout(function(){deleteTimer=null;showCurrentView();},DELETE_BATCH_TIMEOUT);}};document.getElementById('overlay-cancel-button').addEventListener('click',function(){if(pendingPick){pendingPick.postError('pick cancelled');}});}
var currentOverlay;function showOverlay(id){currentOverlay=id;if(id===null){document.getElementById('overlay').classList.add('hidden');return;}
var menu=document.getElementById('overlay-menu');if(pendingPick){menu.classList.remove('hidden');}else{menu.classList.add('hidden');}
var title,text;if(id==='nocard'){title=navigator.mozL10n.get('nocard2-title');text=navigator.mozL10n.get('nocard3-text');}else{title=navigator.mozL10n.get(id+'-title');text=navigator.mozL10n.get(id+'-text');}
var titleElement=document.getElementById('overlay-title');var textElement=document.getElementById('overlay-text');titleElement.textContent=title;titleElement.dataset.l10nId=id+'-title';textElement.textContent=text;textElement.dataset.l10nId=id+'-text';document.getElementById('overlay').classList.remove('hidden');}
var knownSongs=[];function showCorrectOverlay(){if(knownSongs.length>0){if(currentOverlay==='empty')
showOverlay(null);}else{showOverlay('empty');}}
var tilesHandle=null;var listHandle=null;var sublistHandle=null;var playerHandle=null;function showCurrentView(callback){LazyLoader.load('js/metadata_scripts.js',function(){function showListView(){var option=TabBar.option;var info={key:'metadata.'+option,range:null,direction:(option==='title')?'next':'nextunique',option:option};ListView.activate(info);}
if(pendingPick){showListView();knownSongs=ListView.dataSource;if(callback)
callback();return;}
if(ModeManager.currentMode===MODE_LIST&&TabBar.option!=='playlist')
showListView();tilesHandle=musicdb.enumerateAll('metadata.album',null,'nextunique',function(songs){songs.push(null);TilesView.clean();knownSongs.length=0;songs.forEach(function(song){TilesView.update(song);knownSongs.push(song);});if(callback)
callback();});});}
var MODE_TILES=1;var MODE_LIST=2;var MODE_SUBLIST=3;var MODE_PLAYER=4;var MODE_SEARCH_FROM_TILES=5;var MODE_SEARCH_FROM_LIST=6;var MODE_PICKER=7;var ModeManager={_modeStack:[],playerTitle:null,get currentMode(){return this._modeStack[this._modeStack.length-1];},start:function(mode,callback){this._modeStack=[mode];this._updateMode(callback);},push:function(mode,callback){this._modeStack.push(mode);this._updateMode(callback);},pop:function(){if(this._modeStack.length<=1)
return;this._modeStack.pop();this._updateMode();},updateTitle:function(){var title;switch(this.currentMode){case MODE_TILES:title=this.playerTitle||musicTitle;break;case MODE_LIST:case MODE_SUBLIST:switch(TabBar.option){case'playlist':title=playlistTitle;break;case'artist':title=artistTitle;break;case'album':title=albumTitle;break;case'title':title=songTitle;break;}
break;case MODE_PLAYER:title=this.playerTitle||unknownTitle;break;case MODE_PICKER:title=pickerTitle;break;}
if(title)
TitleBar.changeTitleText(title);},_updateMode:function(callback){var mode=this.currentMode;var playerLoaded=(typeof PlayerView!='undefined');this.updateTitle();if(mode===MODE_PLAYER){document.getElementById('views-player').classList.remove('hidden');LazyLoader.load('js/Player.js',function(){if(!playerLoaded){PlayerView.init();PlayerView.setOptions(playerSettings);}
if(callback)
callback();});}else{if(mode===MODE_LIST||mode===MODE_PICKER)
document.getElementById('views-list').classList.remove('hidden');else if(mode===MODE_SUBLIST)
document.getElementById('views-sublist').classList.remove('hidden');else if(mode===MODE_SEARCH_FROM_TILES||mode===MODE_SEARCH_FROM_LIST){document.getElementById('search').classList.remove('hidden');document.getElementById('views-sublist').classList.add('hidden');document.getElementById('views-player').classList.add('hidden');}
if(callback)
callback();}
if(pendingPick)
document.getElementById('title-done').hidden=(mode!==MODE_PLAYER);var modeClasses=['tiles-mode','list-mode','sublist-mode','player-mode','search-from-tiles-mode','search-from-list-mode','picker-mode'];modeClasses.forEach(function resetMode(targetClass){document.body.classList.remove(targetClass);});document.body.classList.add(modeClasses[mode-1]);if(displayingScanProgress&&(mode===MODE_SUBLIST||mode===MODE_PLAYER)){document.getElementById('scan-progress').classList.add('hidden');displayingScanProgress=false;}}};var TitleBar={get view(){delete this._view;return this._view=document.getElementById('title');},get titleText(){delete this._titleText;return this._titleText=document.getElementById('title-text');},get playerIcon(){delete this._playerIcon;return this._playerIcon=document.getElementById('title-player');},init:function tb_init(){this.view.addEventListener('click',this);},changeTitleText:function tb_changeTitleText(content){this.titleText.textContent=content;},handleEvent:function tb_handleEvent(evt){var target=evt.target;function cleanupPick(){PlayerView.stop();}
switch(evt.type){case'click':if(!target)
return;switch(target.id){case'title-back':if(pendingPick){if(ModeManager.currentMode===MODE_PICKER){pendingPick.postError('pick cancelled');return;}
cleanupPick();}
if(ModeManager.currentMode===MODE_PLAYER&&navigator.mozNfc){navigator.mozNfc.onpeerready=null;}
ModeManager.pop();break;case'title-player':if(PlayerView.dataSource.length!=0)
ModeManager.push(MODE_PLAYER);break;case'title-done':pendingPick.postResult({type:PlayerView.playingBlob.type,blob:PlayerView.playingBlob,name:PlayerView.dataSource[PlayerView.currentIndex].metadata.title||''});cleanupPick();break;}
break;default:return;}}};var TilesView={get view(){delete this._view;return this._view=document.getElementById('views-tiles');},get anchor(){delete this._anchor;return this._anchor=document.getElementById('views-tiles-anchor');},get searchBox(){delete this._searchBox;return this._searchBox=document.getElementById('views-tiles-search');},get searchInput(){delete this._searchInput;return this._searchInput=document.getElementById('views-tiles-search-input');},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;},init:function tv_init(){this.dataSource=[];this.index=0;this.view.addEventListener('click',this);this.view.addEventListener('input',this);this.view.addEventListener('touchend',this);this.searchInput.addEventListener('focus',this);},clean:function tv_clean(){if(tilesHandle)
musicdb.cancelEnumeration(tilesHandle);this.dataSource=[];this.index=0;this.anchor.innerHTML='';this.view.scrollTop=0;this.hideSearch();},hideSearch:function tv_hideSearch(){this.searchInput.value='';if(this.view.scrollTop<this.searchBox.offsetHeight)
this.view.scrollTop=this.searchBox.offsetHeight;},update:function tv_update(result){TabBar.setDisabled(!this.dataSource.length);if(result===null){showCorrectOverlay();document.getElementById('views-tiles').classList.remove('hidden');window.setTimeout(this.hideSearch.bind(this),1000);return;}
this.dataSource.push(result);var tile=document.createElement('div');tile.className='tile';var container=document.createElement('div');container.className='tile-container';var titleBar=document.createElement('div');titleBar.className='tile-title-bar';var artistName=document.createElement('div');artistName.className='tile-title-artist';var albumName=document.createElement('div');albumName.className='tile-title-album';artistName.textContent=result.metadata.artist||unknownArtist;artistName.dataset.l10nId=result.metadata.artist?'':unknownArtistL10nId;albumName.textContent=result.metadata.album||unknownAlbum;albumName.dataset.l10nId=result.metadata.album?'':unknownAlbumL10nId;titleBar.appendChild(artistName);if(this.index%6===0){tile.classList.add('main-tile');artistName.classList.add('main-tile-title');titleBar.appendChild(albumName);}else{tile.classList.add('sub-tile');artistName.classList.add('sub-tile-title');}
if(Math.floor(this.index/6)%2===0){tile.classList.add('float-left');}else{tile.classList.add('float-right');}
var NUM_INITIALLY_VISIBLE_TILES=8;var INITIALLY_HIDDEN_TILE_WAIT_TIME_MS=1000;var setTileBackgroundClosure=function(url){url=url||generateDefaultThumbnailURL(result.metadata);tile.style.backgroundImage='url('+url+')';};if(this.index<=NUM_INITIALLY_VISIBLE_TILES){getThumbnailURL(result,setTileBackgroundClosure);}else{setTimeout(function(){getThumbnailURL(result,setTileBackgroundClosure);},INITIALLY_HIDDEN_TILE_WAIT_TIME_MS);}
container.dataset.index=this.index;if(!result.metadata.picture)
container.appendChild(titleBar);tile.appendChild(container);this.anchor.appendChild(tile);this.index++;},handleEvent:function tv_handleEvent(evt){function tv_resetSearch(self){evt.preventDefault();self.searchInput.value='';SearchView.clearSearch();}
var target=evt.target;if(!target)
return;switch(evt.type){case'touchend':if(target.id==='views-tiles-search'){var id=evt.originalTarget.id;if(id&&id!=='views-tiles-search-input'&&id!=='views-tiles-search-close'){tv_resetSearch(this);return;}}
if(target.id==='views-tiles-search-clear'){tv_resetSearch(this);return;}
break;case'click':if(target.id==='views-tiles-search-close'){if(ModeManager.currentMode===MODE_SEARCH_FROM_TILES){ModeManager.pop();}
this.hideSearch();evt.preventDefault();}else if(target.dataset.index){var handler;var index=target.dataset.index;var data=this.dataSource[index];handler=tv_playAlbum.bind(this,data,index);target.addEventListener('transitionend',handler);}
break;case'focus':if(target.id==='views-tiles-search-input'){if(ModeManager.currentMode!==MODE_SEARCH_FROM_TILES){ModeManager.push(MODE_SEARCH_FROM_TILES);SearchView.search(target.value);}}
break;case'input':if(target.id==='views-tiles-search-input'){SearchView.search(target.value);}
break;default:return;}
function tv_playAlbum(data,index){var key='metadata.album';var range=IDBKeyRange.only(data.metadata.album);var direction='next';ModeManager.push(MODE_PLAYER,function(){PlayerView.clean();playerHandle=musicdb.enumerateAll(key,range,direction,function tv_enumerateAll(dataArray){PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=dataArray;if(PlayerView.shuffleOption){PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);}else{PlayerView.play(0);}});});target.removeEventListener('transitionend',handler);}}};function createListElement(option,data,index,highlight){var li=document.createElement('li');li.className='list-item';var a=document.createElement('a');a.dataset.index=index;a.dataset.option=option;li.appendChild(a);function highlightText(result,text){var textContent=result.textContent;var textLowerCased=textContent.toLocaleLowerCase();var index=Normalizer.toAscii(textLowerCased).indexOf(text);if(index>=0){var innerHTML=textContent.substring(0,index)+'<span class="search-highlight">'+
textContent.substring(index,index+text.length)+'</span>'+
textContent.substring(index+text.length);result.innerHTML=innerHTML;}}
switch(option){case'playlist':var titleSpan=document.createElement('span');titleSpan.className='list-playlist-title';if(data.metadata.l10nId){titleSpan.textContent=data.metadata.title;titleSpan.dataset.l10nId=data.metadata.l10nId;}else{titleSpan.textContent=data.metadata.title||unknownTitle;titleSpan.dataset.l10nId=data.metadata.title?'':unknownTitleL10nId;}
a.dataset.keyRange='all';a.dataset.option=data.option;li.appendChild(titleSpan);if(index===0){var shuffleIcon=document.createElement('div');shuffleIcon.className='list-playlist-icon';li.appendChild(shuffleIcon);}
break;case'artist':case'album':case'title':var setBackground=function(url){url=url||generateDefaultThumbnailURL(data.metadata);li.style.backgroundImage='url('+url+')';};getThumbnailURL(data,setBackground);if(option==='artist'){var artistSpan=document.createElement('span');artistSpan.className='list-single-title';artistSpan.textContent=data.metadata.artist||unknownArtist;artistSpan.dataset.l10nId=data.metadata.artist?'':unknownArtistL10nId;if(highlight)
highlightText(artistSpan,highlight);li.appendChild(artistSpan);}else{var albumOrTitleSpan=document.createElement('span');var artistSpan=document.createElement('span');albumOrTitleSpan.className='list-main-title';artistSpan.className='list-sub-title';if(option==='album'){albumOrTitleSpan.textContent=data.metadata.album||unknownAlbum;albumOrTitleSpan.dataset.l10nId=data.metadata.album?'':unknownAlbumL10nId;}else{albumOrTitleSpan.textContent=data.metadata.title||unknownTitle;albumOrTitleSpan.dataset.l10nId=data.metadata.title?'':unknownTitleL10nId;}
artistSpan.textContent=data.metadata.artist||unknownArtist;artistSpan.dataset.l10nId=data.metadata.artist?'':unknownArtistL10nId;if(highlight)
highlightText(albumOrTitleSpan,highlight);li.appendChild(albumOrTitleSpan);li.appendChild(artistSpan);}
a.dataset.keyRange=data.metadata[option];a.dataset.option=option;break;case'song':var songTitle=data.metadata.title||unknownTitle;var indexSpan=document.createElement('span');indexSpan.className='list-song-index';indexSpan.textContent=index+1;var titleSpan=document.createElement('span');titleSpan.className='list-song-title';titleSpan.textContent=songTitle;titleSpan.dataset.l10nId=data.metadata.title?'':unknownTitleL10nId;var lengthSpan=document.createElement('span');lengthSpan.className='list-song-length';li.appendChild(indexSpan);li.appendChild(titleSpan);li.appendChild(lengthSpan);break;}
return li;}
var LIST_BATCH_SIZE=7*5;var ListView={get view(){delete this._view;return this._view=document.getElementById('views-list');},get anchor(){delete this._anchor;return this._anchor=document.getElementById('views-list-anchor');},get searchBox(){delete this._searchBox;return this._searchBox=document.getElementById('views-list-search');},get searchInput(){delete this._searchInput;return this._searchInput=document.getElementById('views-list-search-input');},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;},init:function lv_init(){this.clean();this.view.addEventListener('click',this);this.view.addEventListener('input',this);this.view.addEventListener('touchmove',this);this.view.addEventListener('touchend',this);this.view.addEventListener('scroll',this);this.searchInput.addEventListener('focus',this);},clean:function lv_clean(){this.cancelEnumeration();this.info=null;this.dataSource=[];this.index=0;this.lastDataIndex=0;this.firstLetters=[];this.lastFirstLetter=null;this.anchor.innerHTML='';this.anchor.style.height=0;this.view.scrollTop=0;this.hideSearch();this.moveTimer=null;this.scrollTimer=null;},cancelEnumeration:function lv_cancelEnumeration(){if(listHandle)
musicdb.cancelEnumeration(listHandle);},hideSearch:function lv_hideSearch(){this.searchInput.value='';if(this.view.scrollTop<this.searchBox.offsetHeight)
this.view.scrollTop=this.searchBox.offsetHeight;},createHeader:function lv_createHeader(option,result){var firstLetter=result.metadata[option].charAt(0);var headerLi;if(this.lastFirstLetter!==firstLetter){this.lastFirstLetter=firstLetter;headerLi=document.createElement('li');headerLi.className='list-header';headerLi.textContent=this.lastFirstLetter||'?';}
return headerLi;},activate:function lv_activate(info){if(!info){this.clean();return;}
musicdb.count('metadata.'+info.option,null,function(count){this.clean();this.info=info;this.info.count=count;listHandle=musicdb.enumerate(info.key,info.range,info.direction,function(record){if(record){if(!pendingPick||!record.metadata.locked)
this.dataSource.push(record);this.lastDataIndex=this.dataSource.length;}
if(this.dataSource.length===LIST_BATCH_SIZE||!record){this.batchUpdate(info.option,LIST_BATCH_SIZE);count=record?count:null;this.adjustHeight(info.option,count);}}.bind(this));}.bind(this));},update:function lv_update(option,result){if(result===null){showCorrectOverlay();return;}
this.dataSource.push(result);if(option!=='playlist'){var header=this.createHeader(option,result);if(header){this.anchor.appendChild(header);}}
this.anchor.appendChild(createListElement(option,result,this.index));this.index++;},judgeAndUpdate:function lv_judgeAndUpdate(){if(!this.anchor.lastChild||!this.info)
return;var itemHeight=this.anchor.lastChild.offsetHeight;var scrolledHeight=this.view.scrollTop+this.view.offsetHeight;var position=Math.round(scrolledHeight/itemHeight);var last=this.anchor.children.length;var range=position+this.firstLetters.length-last;if(range>0){this.batchUpdate(TabBar.option,range+LIST_BATCH_SIZE);if(listHandle.state==='cancelled'&&this.lastDataIndex>-1){var info=this.info;var index=this.lastDataIndex+1;listHandle=musicdb.advancedEnumerate(info.key,info.range,info.direction,index,function(record){if(record){this.dataSource[index]=record;this.lastDataIndex=index;index++;}else{this.lastDataIndex=-1;}}.bind(this));}}},batchUpdate:function lv_batchUpdate(option,range){var start=this.index;var end=start+range;var fragment=document.createDocumentFragment();if(end>this.dataSource.length)
end=this.dataSource.length;for(var i=start;i<end;i++){var data=this.dataSource[i];if(data){var header=this.createHeader(option,data);if(header)
fragment.appendChild(header);fragment.appendChild(createListElement(option,data,this.index));this.index++;}}
this.anchor.appendChild(fragment);},adjustHeight:function lv_adjustHeight(option,count){if(this.dataSource.length===0)
return;if(!count){count=this.dataSource.length;this.firstLetters.length=0;var previousFirstLetter;for(var i=0;i<this.dataSource.length;i++){var metadata=this.dataSource[i].metadata;var firstLetter=metadata[option].charAt(0);if(previousFirstLetter!==firstLetter){this.firstLetters.push(firstLetter);previousFirstLetter=firstLetter;}}}else{this.firstLetters.length=26;}
var headerHeight=this.anchor.firstChild.offsetHeight;var itemHeight=this.anchor.lastChild.offsetHeight;var bottomHeight=parseInt(getComputedStyle(this.anchor.lastChild,null).getPropertyValue('margin-bottom'));this.anchor.style.height=(headerHeight*this.firstLetters.length+
itemHeight*count+
bottomHeight)+'px';},playWithShuffleAll:function lv_playWithShuffleAll(){ModeManager.push(MODE_PLAYER,function(){musicdb.count('metadata.title',null,function(count){var info={key:'metadata.title',range:null,direction:'next',option:'title',count:count};PlayerView.setSourceType(TYPE_MIX);PlayerView.dataSource=new Array(count);PlayerView.setDBInfo(info);PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);});});},playWithIndex:function lv_playWithIndex(index){ModeManager.push(MODE_PLAYER,function(){if(pendingPick)
PlayerView.setSourceType(TYPE_SINGLE);else
PlayerView.setSourceType(TYPE_MIX);this.cancelEnumeration();PlayerView.dataSource=this.dataSource;PlayerView.setDBInfo(this.info);if(PlayerView.shuffleOption){PlayerView.shuffleList(index);PlayerView.play(PlayerView.shuffledList[0]);}else{PlayerView.play(index);}}.bind(this));},activateSubListView:function lv_activateSubListView(target){var option=target.dataset.option;var index=target.dataset.index;var data=this.dataSource[index];var keyRange=(target.dataset.keyRange!='all')?IDBKeyRange.only(target.dataset.keyRange):null;var direction=(data.metadata.title===mostPlayedTitle||data.metadata.title===recentlyAddedTitle||data.metadata.title===highestRatedTitle)?'prev':'next';SubListView.activate(option,data,index,keyRange,direction,function(){ModeManager.push(MODE_SUBLIST);});},handleEvent:function lv_handleEvent(evt){function lv_resetSearch(self){evt.preventDefault();self.searchInput.value='';SearchView.clearSearch();}
var target=evt.target;if(!target)
return;switch(evt.type){case'touchend':if(target.id==='views-list-search'){var id=evt.originalTarget.id;if(id&&id!=='views-list-search-input'&&id!=='views-list-search-close'){lv_resetSearch(this);return;}}
if(target.id==='views-list-search-clear'){lv_resetSearch(this);return;}
break;case'click':if(target.id==='views-list-search-close'){if(ModeManager.currentMode===MODE_SEARCH_FROM_LIST){ModeManager.pop();}
this.hideSearch();evt.preventDefault();}else{var option=target.dataset.option;if(option==='shuffleAll')
this.playWithShuffleAll();else if(option==='title')
this.playWithIndex(target.dataset.index);else if(option)
this.activateSubListView(target);}
break;case'focus':if(target.id==='views-list-search-input'){if(ModeManager.currentMode!==MODE_SEARCH_FROM_LIST){ModeManager.push(MODE_SEARCH_FROM_LIST);SearchView.search(target.value);}}
break;case'input':if(target.id==='views-list-search-input'){SearchView.search(target.value);}
break;case'touchmove':if(this.anchor.children.length===0)
return;if(this.moveTimer)
clearTimeout(this.moveTimer);this.moveTimer=setTimeout(function(){this.judgeAndUpdate();this.moveTimer=null;}.bind(this),50);break;case'scroll':if(this.anchor.children.length===0)
return;if(this.scrollTimer)
clearTimeout(this.scrollTimer);this.scrollTimer=setTimeout(function(){this.judgeAndUpdate();this.scrollTimer=null;}.bind(this),500);break;default:return;}}};var SubListView={get view(){delete this._view;return this._view=document.getElementById('views-sublist');},get dataSource(){return this._dataSource;},get anchor(){delete this._anchor;return this._anchor=document.getElementById('views-sublist-anchor');},set dataSource(source){this._dataSource=source;this.shuffleButton.disabled=(this._dataSource.length<2);},init:function slv_init(){this.albumImage=document.getElementById('views-sublist-header-image');this.offscreenImage=new Image();this.albumName=document.getElementById('views-sublist-header-name');this.playAllButton=document.getElementById('views-sublist-controls-play');this.shuffleButton=document.getElementById('views-sublist-controls-shuffle');this.dataSource=[];this.index=0;this.view.addEventListener('click',this);},clean:function slv_clean(){if(sublistHandle)
musicdb.cancelEnumeration(sublistHandle);this.dataSource=[];this.index=0;this.offscreenImage.src='';this.anchor.innerHTML='';this.view.scrollTop=0;},setAlbumSrc:function slv_setAlbumSrc(fileinfo){if(TabBar.playlistArray.indexOf(fileinfo)!==-1)
fileinfo=this.dataSource[0];this.offscreenImage.src='';this.albumImage.classList.remove('fadeIn');getThumbnailURL(fileinfo,function(url){url=url||generateDefaultThumbnailURL(fileinfo.metadata);this.offscreenImage.addEventListener('load',slv_showImage.bind(this));this.offscreenImage.src=url;}.bind(this));function slv_showImage(evt){evt.target.removeEventListener('load',slv_showImage);var url='url('+this.offscreenImage.src+')';this.albumImage.style.backgroundImage=url;this.albumImage.classList.add('fadeIn');};},setAlbumName:function slv_setAlbumName(name,l10nId){this.albumName.textContent=name;this.albumName.dataset.l10nId=l10nId;},activate:function(option,data,index,keyRange,direction,callback){var targetOption=(option==='date')?option:'metadata.'+option;SubListView.clean();sublistHandle=musicdb.enumerateAll(targetOption,keyRange,direction,function lv_enumerateAll(dataArray){var albumName;var albumNameL10nId;if(option==='artist'){albumName=data.metadata.artist||unknownArtist;albumNameL10nId=data.metadata.artist?'':unknownArtistL10nId;}else if(option==='album'){albumName=data.metadata.album||unknownAlbum;albumNameL10nId=data.metadata.album?'':unknownAlbumL10nId;}else{albumName=data.metadata.title||unknownTitle;albumNameL10nId=data.metadata.title?'':unknownTitleL10nId;}
if(data.metadata.l10nId)
albumNameL10nId=data.metadata.l10nId;SubListView.dataSource=dataArray;SubListView.setAlbumName(albumName,albumNameL10nId);SubListView.setAlbumSrc(data);dataArray.forEach(function(songData){SubListView.update(songData);});if(callback)
callback();});},update:function slv_update(result){if(result===null)
return;this.anchor.appendChild(createListElement('song',result,this.index));this.index++;},handleEvent:function slv_handleEvent(evt){var target=evt.target;if(!target)
return;switch(evt.type){case'click':if(target===this.shuffleButton){ModeManager.push(MODE_PLAYER,function(){PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=this.dataSource;PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);}.bind(this));return;}
if(target.dataset.index||target===this.playAllButton){ModeManager.push(MODE_PLAYER,function(){PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=this.dataSource;if(target===this.playAllButton){target=this.view.querySelector('li > a[data-index="0"]');PlayerView.setShuffle(false);}
var targetIndex=parseInt(target.dataset.index);if(PlayerView.shuffleOption){PlayerView.shuffleList(targetIndex);PlayerView.play(PlayerView.shuffledList[0]);}else{PlayerView.play(targetIndex);}}.bind(this));}
break;default:return;}}};var SearchView={get view(){delete this._view;return this._view=document.getElementById('search');},get searchArtistsView(){delete this._searchArtists;return this._searchArtists=document.getElementById('views-search-artists');},get searchAlbumsView(){delete this._searchAlbums;return this._searchAlbums=document.getElementById('views-search-albums');},get searchTitlesView(){delete this._searchTitles;return this._searchTitles=document.getElementById('views-search-titles');},init:function sv_init(){this.dataSource=[];this.searchHandles={artist:null,album:null,title:null};this.view.addEventListener('click',this);},search:function sv_search(query){this.clearSearch();if(!query)
return;var queryLowerCased=query.toLocaleLowerCase();query=Normalizer.toAscii(queryLowerCased);var lists={artist:this.searchArtistsView,album:this.searchAlbumsView,title:this.searchTitlesView};var numResults={artist:0,album:0,title:0};function sv_showResult(option,result){if(result===null){this.searchHandles[option]=null;return;}
var resultLowerCased=result.metadata[option].toLocaleLowerCase();if(Normalizer.toAscii(resultLowerCased).indexOf(query)!==-1){this.dataSource.push(result);numResults[option]++;lists[option].classList.remove('hidden');lists[option].getElementsByClassName('search-result-count')[0].textContent=numResults[option];lists[option].getElementsByClassName('search-results')[0].appendChild(createListElement(option,result,this.dataSource.length-1,query));}}
if(!pendingPick){this.searchHandles.artist=musicdb.enumerate('metadata.artist',null,'nextunique',sv_showResult.bind(this,'artist'));this.searchHandles.album=musicdb.enumerate('metadata.album',null,'nextunique',sv_showResult.bind(this,'album'));}
this.searchHandles.title=musicdb.enumerate('metadata.title',sv_showResult.bind(this,'title'));},clearSearch:function sv_clearSearch(){for(var option in this.searchHandles){var handle=this.searchHandles[option];if(handle)
musicdb.cancelEnumeration(handle);}
var views=[this.searchArtistsView,this.searchAlbumsView,this.searchTitlesView];views.forEach(function(view){view.getElementsByClassName('search-results')[0].innerHTML='';view.classList.add('hidden');});this.dataSource=[];},handleEvent:function sv_handleEvent(evt){var target=evt.target;switch(evt.type){case'click':if(!target)
return;if(target.dataset.index){var handler;var index=target.dataset.index;var option=target.dataset.option;var keyRange=target.dataset.keyRange;var data=this.dataSource[index];handler=sv_openResult.bind(this,option,data,index,keyRange);target.addEventListener('transitionend',handler);}
break;default:return;}
function sv_openResult(option,data,index,keyRange){if(option==='title'){ModeManager.push(MODE_PLAYER,function(){if(pendingPick){PlayerView.setSourceType(TYPE_SINGLE);PlayerView.dataSource=this.dataSource;PlayerView.play(index);}else{PlayerView.setSourceType(TYPE_LIST);PlayerView.dataSource=[data];PlayerView.play(0);}}.bind(this));}else{SubListView.activate(option,data,index,keyRange,'next',function(){ModeManager.push(MODE_SUBLIST);});}
target.removeEventListener('transitionend',handler);}}};var TabBar={playlistArray:[{metadata:{title:shuffleAllTitle,l10nId:shuffleAllTitleL10nId},option:'shuffleAll'},{metadata:{title:highestRatedTitle,l10nId:highestRatedTitleL10nId},option:'rated'},{metadata:{title:recentlyAddedTitle,l10nId:recentlyAddedTitleL10nId},option:'date'},{metadata:{title:mostPlayedTitle,l10nId:mostPlayedTitleL10nId},option:'played'},{metadata:{title:leastPlayedTitle,l10nId:leastPlayedTitleL10nId},option:'played'},null],get view(){delete this._view;return this._view=document.getElementById('tabs');},init:function tab_init(){this.option='';this.view.addEventListener('click',this);this.playlistArray.localize=function(){this.forEach(function(playList){if(playList){var metadata=playList.metadata;if(metadata&&metadata.l10nId){metadata.title=navigator.mozL10n.get(metadata.l10nId);}}});};},setDisabled:function tab_setDisabled(option){this.disabled=option;},handleEvent:function tab_handleEvent(evt){if(this.disabled)
return;switch(evt.type){case'click':var target=evt.target;if(!target)
return;if(this.option===target.dataset.option){return;}else{this.option=target.dataset.option;}
switch(target.id){case'tabs-mix':ListView.cancelEnumeration();ModeManager.start(MODE_TILES);TilesView.hideSearch();break;case'tabs-playlists':ModeManager.start(MODE_LIST);ListView.activate();this.playlistArray.forEach(function(playlist){ListView.update(this.option,playlist);}.bind(this));break;case'tabs-artists':case'tabs-albums':case'tabs-songs':var info={key:'metadata.'+this.option,range:null,direction:(this.option==='title')?'next':'nextunique',option:this.option};ModeManager.start(MODE_LIST);ListView.activate(info);break;}
break;default:return;}}};window.addEventListener('scrollstart',function onScroll(e){var views=document.getElementById('views');views.classList.add('scrolling');});window.addEventListener('scrollend',function onScroll(e){var views=document.getElementById('views');views.classList.remove('scrolling');});;'use strict';var MusicComms={commands:{play:function(event){this.commands.playpause.call(this,event);},playpause:function(event){this._getPlayerReady(function(){var isResumedBySCO=this.isSCOEnabled;this.isSCOEnabled=event.detail.isSCOConnected;if(isResumedBySCO){if(this._statusBeforeSCO===PLAYSTATUS_PLAYING)
PlayerView.play();else
PlayerView.pause();}else{if(PlayerView.playStatus===PLAYSTATUS_STOPPED){musicdb.getAll(function remote_getAll(dataArray){PlayerView.setSourceType(TYPE_MIX);PlayerView.dataSource=dataArray;PlayerView.setShuffle(true);PlayerView.play(PlayerView.shuffledList[0]);ModeManager.push(MODE_PLAYER);});}else if(PlayerView.playStatus===PLAYSTATUS_PLAYING){PlayerView.pause();}else{PlayerView.play();}}}.bind(this));},pause:function(event){this.isSCOEnabled=event.detail.isSCOConnected;if(!this._isPlayerActivated())
return;if(this.isSCOEnabled)
this._statusBeforeSCO=PlayerView.playStatus;PlayerView.pause();},stop:function(event){if(!this._isPlayerActivated())
return;PlayerView.stop();},next:function(event){if(!this._isPlayerActivated())
return;PlayerView.next();},previous:function(event){if(!this._isPlayerActivated())
return;PlayerView.previous();},seekpress:function(event){if(!this._isPlayerActivated())
return;if(!PlayerView.isTouching)
PlayerView.startFastSeeking(event.detail.direction);},seekrelease:function(event){if(!this._isPlayerActivated())
return;PlayerView.stopFastSeeking();},updatemetadata:function(){this._getPlayerReady(function(){PlayerView.updateRemoteMetadata();});},updateplaystatus:function(){this._getPlayerReady(function(){PlayerView.updateRemotePlayStatus();});}},enabled:false,isSCOEnabled:false,_statusBeforeSCO:null,init:function(){this.mrc=new MediaRemoteControls();for(var command in this.commands)
this.mrc.addCommandListener(command,this.commands[command].bind(this));this.mrc.start(this.updateSCOStatus.bind(this));this.mrc.notifyAppInfo({origin:window.location.origin,icon:window.location.origin+'/style/icons/Music_60.png'});this.enabled=true;},_getPlayerReady:function(callback){if(typeof PlayerView==='undefined'){LazyLoader.load('js/Player.js',function(){PlayerView.init();PlayerView.setOptions(playerSettings);callback();});}else{callback();}},_isPlayerActivated:function(){return(typeof PlayerView!=='undefined'&&PlayerView.playStatus!==PLAYSTATUS_STOPPED);},notifyMetadataChanged:function(metadata){if(this.enabled)
this.mrc.notifyMetadataChanged(metadata);},notifyStatusChanged:function(info){if(this.enabled)
this.mrc.notifyStatusChanged(info);},updateSCOStatus:function(){if(this.enabled){this.mrc.getSCOStatus(function(status){this.isSCOEnabled=status;}.bind(this));}}};