(function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/FolderHierarchy", [], t) : e.ASCPHierarchy = t();
})(this, function() {
    return {
        Tags: {
            Folders: 1797,
            Folder: 1798,
            DisplayName: 1799,
            ServerId: 1800,
            ParentId: 1801,
            Type: 1802,
            Response: 1803,
            Status: 1804,
            ContentClass: 1805,
            Changes: 1806,
            Add: 1807,
            Delete: 1808,
            Update: 1809,
            SyncKey: 1810,
            FolderCreate: 1811,
            FolderDelete: 1812,
            FolderUpdate: 1813,
            FolderSync: 1814,
            Count: 1815
        },
        Enums: {
            Type: {
                Generic: "1",
                DefaultInbox: "2",
                DefaultDrafts: "3",
                DefaultDeleted: "4",
                DefaultSent: "5",
                DefaultOutbox: "6",
                DefaultTasks: "7",
                DefaultCalendar: "8",
                DefaultContacts: "9",
                DefaultNotes: "10",
                DefaultJournal: "11",
                Mail: "12",
                Calendar: "13",
                Contacts: "14",
                Tasks: "15",
                Journal: "16",
                Notes: "17",
                Unknown: "18",
                RecipientCache: "19"
            },
            Status: {
                Success: "1",
                FolderExists: "2",
                SystemFolder: "3",
                FolderNotFound: "4",
                ParentFolderNotFound: "5",
                ServerError: "6",
                InvalidSyncKey: "9",
                MalformedRequest: "10",
                UnknownError: "11",
                CodeUnknown: "12"
            }
        }
    };
}), function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/AirSync", [], t) : e.ASCPAirSync = t();
}(this, function() {
    return {
        Tags: {
            Sync: 5,
            Responses: 6,
            Add: 7,
            Change: 8,
            Delete: 9,
            Fetch: 10,
            SyncKey: 11,
            ClientId: 12,
            ServerId: 13,
            Status: 14,
            Collection: 15,
            Class: 16,
            Version: 17,
            CollectionId: 18,
            GetChanges: 19,
            MoreAvailable: 20,
            WindowSize: 21,
            Commands: 22,
            Options: 23,
            FilterType: 24,
            Truncation: 25,
            RtfTruncation: 26,
            Conflict: 27,
            Collections: 28,
            ApplicationData: 29,
            DeletesAsMoves: 30,
            NotifyGUID: 31,
            Supported: 32,
            SoftDelete: 33,
            MIMESupport: 34,
            MIMETruncation: 35,
            Wait: 36,
            Limit: 37,
            Partial: 38,
            ConversationMode: 39,
            MaxItems: 40,
            HeartbeatInterval: 41
        },
        Enums: {
            Status: {
                Success: "1",
                InvalidSyncKey: "3",
                ProtocolError: "4",
                ServerError: "5",
                ConversionError: "6",
                MatchingConflict: "7",
                ObjectNotFound: "8",
                OutOfSpace: "9",
                HierarchyChanged: "12",
                IncompleteRequest: "13",
                InvalidInterval: "14",
                InvalidRequest: "15",
                Retry: "16"
            },
            FilterType: {
                NoFilter: "0",
                OneDayBack: "1",
                ThreeDaysBack: "2",
                OneWeekBack: "3",
                TwoWeeksBack: "4",
                OneMonthBack: "5",
                ThreeMonthsBack: "6",
                SixMonthsBack: "7",
                IncompleteTasks: "8"
            },
            Conflict: {
                ClientReplacesServer: "0",
                ServerReplacesClient: "1"
            },
            MIMESupport: {
                Never: "0",
                SMIMEOnly: "1",
                Always: "2"
            },
            MIMETruncation: {
                TruncateAll: "0",
                Truncate4K: "1",
                Truncate5K: "2",
                Truncate7K: "3",
                Truncate10K: "4",
                Truncate20K: "5",
                Truncate50K: "6",
                Truncate100K: "7",
                NoTruncate: "8"
            }
        }
    };
}), function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/AirSyncBase", [], t) : e.ASCPAirSyncBase = t();
}(this, function() {
    return {
        Tags: {
            BodyPreference: 4357,
            Type: 4358,
            TruncationSize: 4359,
            AllOrNone: 4360,
            Reserved: 4361,
            Body: 4362,
            Data: 4363,
            EstimatedDataSize: 4364,
            Truncated: 4365,
            Attachments: 4366,
            Attachment: 4367,
            DisplayName: 4368,
            FileReference: 4369,
            Method: 4370,
            ContentId: 4371,
            ContentLocation: 4372,
            IsInline: 4373,
            NativeBodyType: 4374,
            ContentType: 4375,
            Preview: 4376,
            BodyPartPreference: 4377,
            BodyPart: 4378,
            Status: 4379
        },
        Enums: {
            Type: {
                PlainText: "1",
                HTML: "2",
                RTF: "3",
                MIME: "4"
            },
            Method: {
                Normal: "1",
                EmbeddedMessage: "5",
                AttachOLE: "6"
            },
            NativeBodyType: {
                PlainText: "1",
                HTML: "2",
                RTF: "3"
            },
            Status: {
                Success: "1"
            }
        }
    };
}), function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/ItemEstimate", [], t) : e.ASCPItemEstimate = t();
}(this, function() {
    return {
        Tags: {
            GetItemEstimate: 1541,
            Version: 1542,
            Collections: 1543,
            Collection: 1544,
            Class: 1545,
            CollectionId: 1546,
            DateTime: 1547,
            Estimate: 1548,
            Response: 1549,
            Status: 1550
        },
        Enums: {
            Status: {
                Success: "1",
                InvalidCollection: "2",
                NoSyncState: "3",
                InvalidSyncKey: "4"
            }
        }
    };
}), function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/Email", [], t) : e.ASCPEmail = t();
}(this, function() {
    return {
        Tags: {
            Attachment: 517,
            Attachments: 518,
            AttName: 519,
            AttSize: 520,
            Att0Id: 521,
            AttMethod: 522,
            AttRemoved: 523,
            Body: 524,
            BodySize: 525,
            BodyTruncated: 526,
            DateReceived: 527,
            DisplayName: 528,
            DisplayTo: 529,
            Importance: 530,
            MessageClass: 531,
            Subject: 532,
            Read: 533,
            To: 534,
            Cc: 535,
            From: 536,
            ReplyTo: 537,
            AllDayEvent: 538,
            Categories: 539,
            Category: 540,
            DTStamp: 541,
            EndTime: 542,
            InstanceType: 543,
            BusyStatus: 544,
            Location: 545,
            MeetingRequest: 546,
            Organizer: 547,
            RecurrenceId: 548,
            Reminder: 549,
            ResponseRequested: 550,
            Recurrences: 551,
            Recurrence: 552,
            Recurrence_Type: 553,
            Recurrence_Until: 554,
            Recurrence_Occurrences: 555,
            Recurrence_Interval: 556,
            Recurrence_DayOfWeek: 557,
            Recurrence_DayOfMonth: 558,
            Recurrence_WeekOfMonth: 559,
            Recurrence_MonthOfYear: 560,
            StartTime: 561,
            Sensitivity: 562,
            TimeZone: 563,
            GlobalObjId: 564,
            ThreadTopic: 565,
            MIMEData: 566,
            MIMETruncated: 567,
            MIMESize: 568,
            InternetCPID: 569,
            Flag: 570,
            Status: 571,
            ContentClass: 572,
            FlagType: 573,
            CompleteTime: 574,
            DisallowNewTimeProposal: 575
        },
        Enums: {
            Importance: {
                Low: "0",
                Normal: "1",
                High: "2"
            },
            InstanceType: {
                Single: "0",
                RecurringMaster: "1",
                RecurringInstance: "2",
                RecurringException: "3"
            },
            BusyStatus: {
                Free: "0",
                Tentative: "1",
                Busy: "2",
                Oof: "3"
            },
            Recurrence_Type: {
                Daily: "0",
                Weekly: "1",
                MonthlyNthDay: "2",
                Monthly: "3",
                YearlyNthDay: "5",
                YearlyNthDayOfWeek: "6"
            },
            Sensitivity: {
                Normal: "0",
                Personal: "1",
                Private: "2",
                Confidential: "3"
            },
            Status: {
                Cleared: "0",
                Complete: "1",
                Active: "2"
            }
        }
    };
}), function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/ItemOperations", [], t) : e.ASCPItemOperations = t();
}(this, function() {
    return {
        Tags: {
            ItemOperations: 5125,
            Fetch: 5126,
            Store: 5127,
            Options: 5128,
            Range: 5129,
            Total: 5130,
            Properties: 5131,
            Data: 5132,
            Status: 5133,
            Response: 5134,
            Version: 5135,
            Schema: 5136,
            Part: 5137,
            EmptyFolderContents: 5138,
            DeleteSubFolders: 5139,
            UserName: 5140,
            Password: 5141,
            Move: 5142,
            DstFldId: 5143,
            ConversationId: 5144,
            MoveAlways: 5145
        },
        Enums: {
            Status: {
                Success: "1",
                ProtocolError: "2",
                ServerError: "3",
                BadURI: "4",
                AccessDenied: "5",
                ObjectNotFound: "6",
                ConnectionFailure: "7",
                InvalidByteRange: "8",
                UnknownStore: "9",
                EmptyFile: "10",
                DataTooLarge: "11",
                IOFailure: "12",
                ConversionFailure: "14",
                InvalidAttachment: "15",
                ResourceAccessDenied: "16"
            }
        }
    };
}), define("mailapi/activesync/folder", [ "rdcommon/log", "../date", "../syncbase", "../util", "mailapi/db/mail_rep", "activesync/codepages/AirSync", "activesync/codepages/AirSyncBase", "activesync/codepages/ItemEstimate", "activesync/codepages/Email", "activesync/codepages/ItemOperations", "module", "require", "exports" ], function(e, t, n, s, o, i, r, a, c, d, l, u, h) {
    function m() {
        y = i.Enums.FilterType, v = {
            auto: null,
            "1d": y.OneDayBack,
            "3d": y.ThreeDaysBack,
            "1w": y.OneWeekBack,
            "2w": y.TwoWeeksBack,
            "1m": y.OneMonthBack,
            all: y.NoFilter
        }, _ = {
            0: "all messages",
            1: "one day",
            2: "three days",
            3: "one week",
            4: "two weeks",
            5: "one month"
        };
    }
    function p(e, t, n) {
        return function() {
            var s = Array.slice(arguments), o = s[e], i = this;
            u([ "wbxml", "mimelib", "../mailchew" ], function(e, r, a) {
                b || (b = e, C = r, w = a, m()), i._account.withConnection(o, function() {
                    t.apply(i, s);
                }, n);
            });
        };
    }
    function f(e, t, n) {
        this._account = e, this._storage = t, this._LOG = N.ActiveSyncFolderConn(this, n, t.folderId), 
        this.folderMeta = t.folderMeta, this.syncKey || (this.syncKey = "0");
    }
    function g(e, t, n) {
        this._account = e, this.folderStorage = t, this._LOG = N.ActiveSyncFolderSyncer(this, n, t.folderId), 
        this.folderConn = new f(e, t, this._LOG);
    }
    var y, v, _, b, C, w, S = 512, E = 50;
    f.prototype = {
        get syncKey() {
            return this.folderMeta.syncKey;
        },
        set syncKey(e) {
            return this.folderMeta.syncKey = e;
        },
        get serverId() {
            return this.folderMeta.serverId;
        },
        get filterType() {
            var e = this._account.accountDef.syncRange;
            if (v.hasOwnProperty(e)) {
                var t = v[e];
                return t ? t : this.folderMeta.filterType;
            }
            return console.warn("Got an invalid syncRange (" + e + ") using three days back instead"), 
            i.Enums.FilterType.ThreeDaysBack;
        },
        _getSyncKey: p(1, function(e, t) {
            var n = this, s = this._account, o = i.Tags, r = new b.Writer("1.3", 1, "UTF-8");
            r.stag(o.Sync).stag(o.Collections).stag(o.Collection), s.conn.currentVersion.lt("12.1") && r.tag(o.Class, "Email"), 
            r.tag(o.SyncKey, "0").tag(o.CollectionId, this.serverId).stag(o.Options).tag(o.FilterType, e).etag().etag().etag().etag(), 
            s.conn.postCommand(r, function(e, i) {
                if (e) return console.error(e), s._reportErrorIfNecessary(e), t("unknown"), void 0;
                n.syncKey = "0";
                var r = new b.EventParser();
                r.addEventListener([ o.Sync, o.Collections, o.Collection, o.SyncKey ], function(e) {
                    n.syncKey = e.children[0].textContent;
                }), r.onerror = function() {}, r.run(i), "0" === n.syncKey ? (console.error("Unable to get sync key for folder"), 
                t("unknown")) : t();
            });
        }),
        _getItemEstimate: p(1, function(e, t) {
            var n = a.Tags, s = i.Tags, o = this._account, r = new b.Writer("1.3", 1, "UTF-8");
            r.stag(n.GetItemEstimate).stag(n.Collections).stag(n.Collection), this._account.conn.currentVersion.gte("14.0") ? r.tag(s.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).stag(s.Options).tag(s.FilterType, e).etag() : this._account.conn.currentVersion.gte("12.0") ? r.tag(n.CollectionId, this.serverId).tag(s.FilterType, e).tag(s.SyncKey, this.syncKey) : r.tag(n.Class, "Email").tag(s.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).tag(s.FilterType, e), 
            r.etag(n.Collection).etag(n.Collections).etag(n.GetItemEstimate), o.conn.postCommand(r, function(e, s) {
                if (e) return console.error(e), o._reportErrorIfNecessary(e), t("unknown"), void 0;
                var i, r, c = new b.EventParser(), d = [ n.GetItemEstimate, n.Response ];
                c.addEventListener(d.concat(n.Status), function(e) {
                    i = e.children[0].textContent;
                }), c.addEventListener(d.concat(n.Collection, n.Estimate), function(e) {
                    r = parseInt(e.children[0].textContent, 10);
                });
                try {
                    c.run(s);
                } catch (l) {
                    return console.error("Error parsing GetItemEstimate response", l, "\n", l.stack), 
                    t("unknown"), void 0;
                }
                i !== a.Enums.Status.Success ? (console.error("Error getting item estimate:", i), 
                t("unknown")) : t(null, r);
            });
        }),
        _inferFilterType: p(0, function(e) {
            var t = this, n = i.Enums.FilterType, s = function(s, o) {
                t._getSyncKey(s, function(i) {
                    return i ? (e("unknown"), void 0) : (t._getItemEstimate(s, function(t, s) {
                        return t ? (e(null, n.ThreeDaysBack), void 0) : (o(s), void 0);
                    }), void 0);
                });
            };
            s(n.TwoWeeksBack, function(o) {
                var i, r = o / 14;
                if (0 > o) i = n.ThreeDaysBack; else if (r >= E) i = n.OneDayBack; else if (3 * r >= E) i = n.ThreeDaysBack; else if (7 * r >= E) i = n.OneWeekBack; else if (14 * r >= E) i = n.TwoWeeksBack; else {
                    if (!(30 * r >= E)) return s(n.NoFilter, function(s) {
                        var o;
                        s > E ? (o = n.OneMonthBack, t.syncKey = "0") : o = n.NoFilter, t._LOG.inferFilterType(o), 
                        e(null, o);
                    }), void 0;
                    i = n.OneMonthBack;
                }
                i !== n.TwoWeeksBack && (t.syncKey = "0"), t._LOG.inferFilterType(i), e(null, i);
            });
        }),
        _enumerateFolderChanges: p(0, function(e, t) {
            var n = this, s = this._storage;
            if (!this.filterType) return this._inferFilterType(function(s, o) {
                return s ? (e("unknown"), void 0) : (console.log("We want a filter of", _[o]), n.folderMeta.filterType = o, 
                n._enumerateFolderChanges(e, t), void 0);
            }), void 0;
            if ("0" === this.syncKey) return this._getSyncKey(this.filterType, function(s) {
                return s ? (e("aborted"), void 0) : (n._enumerateFolderChanges(e, t), void 0);
            }), void 0;
            var o = i.Tags, a = i.Enums;
            r.Tags, r.Enums;
            var c;
            0 === this._account._syncsInProgress++ && this._account._lastSyncKey === this.syncKey && this._account._lastSyncFilterType === this.filterType && this._account._lastSyncResponseWasEmpty ? c = o.Sync : (c = new b.Writer("1.3", 1, "UTF-8"), 
            c.stag(o.Sync).stag(o.Collections).stag(o.Collection), this._account.conn.currentVersion.lt("12.1") && c.tag(o.Class, "Email"), 
            c.tag(o.SyncKey, this.syncKey).tag(o.CollectionId, this.serverId).tag(o.GetChanges).stag(o.Options).tag(o.FilterType, this.filterType), 
            this._account.conn.currentVersion.lte("12.0") && c.tag(o.MIMESupport, a.MIMESupport.Never).tag(o.Truncation, a.MIMETruncation.TruncateAll), 
            c.etag().etag().etag().etag()), this._account.conn.postCommand(c, function(i, r) {
                var c, d = [], l = [], u = [], h = !1;
                if (n._account._syncsInProgress--, i) return console.error("Error syncing folder:", i), 
                n._account._reportErrorIfNecessary(i), e("aborted"), void 0;
                if (n._account._lastSyncKey = n.syncKey, n._account._lastSyncFilterType = n.filterType, 
                !r) return console.log("Sync completed with empty response"), n._account._lastSyncResponseWasEmpty = !0, 
                e(null, d, l, u), void 0;
                n._account._lastSyncResponseWasEmpty = !1;
                var m = new b.EventParser(), p = [ o.Sync, o.Collections, o.Collection ];
                m.addEventListener(p.concat(o.SyncKey), function(e) {
                    n.syncKey = e.children[0].textContent;
                }), m.addEventListener(p.concat(o.Status), function(e) {
                    c = e.children[0].textContent;
                }), m.addEventListener(p.concat(o.MoreAvailable), function() {
                    h = !0;
                }), m.addEventListener(p.concat(o.Commands, [ [ o.Add, o.Change ] ]), function(e) {
                    var t, i;
                    for (var r in Iterator(e.children)) {
                        var a = r[1];
                        switch (a.tag) {
                          case o.ServerId:
                            t = a.children[0].textContent;
                            break;

                          case o.ApplicationData:
                            try {
                                i = n._parseMessage(a, e.tag === o.Add, s);
                            } catch (c) {
                                return console.error("Failed to parse a message:", c, "\n", c.stack), void 0;
                            }
                        }
                    }
                    i.header.srvid = t;
                    var u = e.tag === o.Add ? d : l;
                    u.push(i);
                }), m.addEventListener(p.concat(o.Commands, [ [ o.Delete, o.SoftDelete ] ]), function(e) {
                    var t;
                    for (var n in Iterator(e.children)) {
                        var s = n[1];
                        switch (s.tag) {
                          case o.ServerId:
                            t = s.children[0].textContent;
                        }
                    }
                    u.push(t);
                });
                try {
                    m.run(r);
                } catch (f) {
                    return console.error("Error parsing Sync response:", f, "\n", f.stack), e("unknown"), 
                    void 0;
                }
                c === a.Status.Success ? (console.log("Sync completed: added " + d.length + ", changed " + l.length + ", deleted " + u.length), 
                e(null, d, l, u, h), h && n._enumerateFolderChanges(e, t)) : c === a.Status.InvalidSyncKey ? (console.warn("ActiveSync had a bad sync key"), 
                e("badkey")) : (console.error("Something went wrong during ActiveSync syncing and we got a status of " + c), 
                e("unknown"));
            }, null, null, function(e, n) {
                n || (n = Math.max(1e6, e)), t(.1 + .7 * e / n);
            });
        }, "aborted"),
        _parseMessage: function(e, t, n) {
            var s, i, a, d = c.Tags, l = r.Tags, u = r.Enums;
            if (t) {
                var h = n._issueNewHeaderId();
                s = {
                    id: h,
                    srvid: null,
                    suid: n.folderId + "/" + h,
                    guid: "",
                    author: null,
                    to: null,
                    cc: null,
                    bcc: null,
                    replyTo: null,
                    date: null,
                    flags: [],
                    hasAttachments: !1,
                    subject: null,
                    snippet: null
                }, i = {
                    date: null,
                    size: 0,
                    attachments: [],
                    relatedParts: [],
                    references: null,
                    bodyReps: null
                }, a = function(e, t) {
                    t && s.flags.push(e);
                };
            } else s = {
                flags: [],
                mergeInto: function(e) {
                    for (var t in Iterator(this.flags)) {
                        var n = t[1];
                        if (n[1]) e.flags.push(n[0]); else {
                            var s = e.flags.indexOf(n[0]);
                            -1 !== s && e.flags.splice(s, 1);
                        }
                    }
                    var o = [ "mergeInto", "suid", "srvid", "guid", "id", "flags" ];
                    for (var t in Iterator(this)) {
                        var i = t[0], r = t[1];
                        -1 === o.indexOf(i) && (e[i] = r);
                    }
                }
            }, i = {
                mergeInto: function(e) {
                    for (var t in Iterator(this)) {
                        var n = t[0], s = t[1];
                        "mergeInto" !== n && (e[n] = s);
                    }
                }
            }, a = function(e, t) {
                s.flags.push([ e, t ]);
            };
            var m, p;
            for (var f in Iterator(e.children)) {
                var g = f[1], y = g.children.length ? g.children[0].textContent : null;
                switch (g.tag) {
                  case d.Subject:
                    s.subject = y;
                    break;

                  case d.From:
                    s.author = C.parseAddresses(y)[0] || null;
                    break;

                  case d.To:
                    s.to = C.parseAddresses(y);
                    break;

                  case d.Cc:
                    s.cc = C.parseAddresses(y);
                    break;

                  case d.ReplyTo:
                    s.replyTo = C.parseAddresses(y);
                    break;

                  case d.DateReceived:
                    i.date = s.date = new Date(y).valueOf();
                    break;

                  case d.Read:
                    a("\\Seen", "1" === y);
                    break;

                  case d.Flag:
                    for (var v in Iterator(g.children)) {
                        var _ = v[1];
                        _.tag === d.Status && a("\\Flagged", "0" !== _.children[0].textContent);
                    }
                    break;

                  case l.Body:
                    for (var v in Iterator(g.children)) {
                        var _ = v[1];
                        switch (_.tag) {
                          case l.Type:
                            var b = _.children[0].textContent;
                            b === u.Type.HTML ? m = "html" : (b !== u.Type.PlainText && console.warn("A message had a strange body type:", b), 
                            m = "plain");
                            break;

                          case l.EstimatedDataSize:
                            p = _.children[0].textContent;
                        }
                    }
                    break;

                  case d.BodySize:
                    m = "plain", p = y;
                    break;

                  case l.Attachments:
                  case d.Attachments:
                    for (var v in Iterator(g.children)) {
                        var w = v[1];
                        if (w.tag === l.Attachment || w.tag === d.Attachment) {
                            var S = {
                                name: null,
                                contentId: null,
                                type: null,
                                part: null,
                                encoding: null,
                                sizeEstimate: null,
                                file: null
                            }, E = !1;
                            for (var N in Iterator(w.children)) {
                                var A, T, I = N[1], k = I.children.length ? I.children[0].textContent : null;
                                switch (I.tag) {
                                  case l.DisplayName:
                                  case d.DisplayName:
                                    S.name = k, A = S.name.lastIndexOf("."), T = A > 0 ? S.name.substring(A + 1).toLowerCase() : "", 
                                    S.type = C.contentTypes[T] || "application/octet-stream";
                                    break;

                                  case l.FileReference:
                                  case d.AttName:
                                    S.part = k;
                                    break;

                                  case l.EstimatedDataSize:
                                  case d.AttSize:
                                    S.sizeEstimate = parseInt(k, 10);
                                    break;

                                  case l.ContentId:
                                    S.contentId = k;
                                    break;

                                  case l.IsInline:
                                    E = "1" === k;
                                    break;

                                  case l.FileReference:
                                  case d.Att0Id:
                                    S.part = I.children[0].textContent;
                                }
                            }
                            E ? i.relatedParts.push(o.makeAttachmentPart(S)) : i.attachments.push(o.makeAttachmentPart(S));
                        }
                    }
                    s.hasAttachments = i.attachments.length > 0;
                }
            }
            return t ? (i.bodyReps = [ o.makeBodyPart({
                type: m,
                sizeEstimate: p,
                amountDownloaded: 0,
                isDownloaded: !1
            }) ], {
                header: o.makeHeaderInfo(s),
                body: o.makeBodyInfo(i)
            }) : {
                header: s,
                body: i
            };
        },
        downloadBodies: function(e, t, n) {
            function s(e) {
                e && !o && (o = e), --i || a._storage.runAfterDeferredCalls(function() {
                    n(o, r - i);
                });
            }
            if (this._account.conn.currentVersion.lt("12.0")) return this._syncBodies(e, n);
            for (var o, i = 1, r = 0, a = this, c = 0; c < e.length; c++) e[c] && null === e[c].snippet && (i++, 
            r++, this.downloadBodyReps(e[c], t, s));
            window.setZeroTimeout(s);
        },
        downloadBodyReps: p(1, function(e, t, n) {
            var s = this, o = this._account;
            if (o.conn.currentVersion.lt("12.0")) return this._syncBodies([ e ], n);
            "function" == typeof t && (n = t, t = null), t = t || {};
            var a = d.Tags, c = d.Enums, l = i.Tags;
            i.Enums;
            var u = r.Tags, h = r.Enums.Type, m = function(i) {
                if (!i) return n("unknown");
                var r, d = i.bodyReps[0], m = "html" === d.type ? h.HTML : h.PlainText;
                t.maximumBytesToFetch < d.sizeEstimate && (m = h.PlainText, r = S);
                var p = new b.Writer("1.3", 1, "UTF-8");
                p.stag(a.ItemOperations).stag(a.Fetch).tag(a.Store, "Mailbox").tag(l.CollectionId, s.serverId).tag(l.ServerId, e.srvid).stag(a.Options).stag(a.Schema).tag(u.Body).etag().stag(u.BodyPreference).tag(u.Type, m), 
                r && p.tag(u.TruncationSize, r), p.etag().etag().etag().etag(), o.conn.postCommand(p, function(t, d) {
                    if (t) return console.error(t), o._reportErrorIfNecessary(t), n("unknown"), void 0;
                    var l, h, m = new b.EventParser();
                    m.addEventListener([ a.ItemOperations, a.Status ], function(e) {
                        l = e.children[0].textContent;
                    }), m.addEventListener([ a.ItemOperations, a.Response, a.Fetch, a.Properties, u.Body, u.Data ], function(e) {
                        h = e.children[0].textContent;
                    });
                    try {
                        m.run(d);
                    } catch (p) {
                        return n("unknown");
                    }
                    return l !== c.Status.Success ? n("unknown") : (s._updateBody(e, i, h, !!r, n), 
                    void 0);
                });
            };
            this._storage.getMessageBody(e.suid, e.date, m);
        }),
        _syncBodies: function(e, t) {
            var n = i.Tags, s = i.Enums, o = c.Tags, r = this, a = this._account, d = new b.Writer("1.3", 1, "UTF-8");
            d.stag(n.Sync).stag(n.Collections).stag(n.Collection).tag(n.Class, "Email").tag(n.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).stag(n.Options).tag(n.MIMESupport, s.MIMESupport.Never).etag().stag(n.Commands);
            for (var l = 0; l < e.length; l++) d.stag(n.Fetch).tag(n.ServerId, e[l].srvid).etag();
            d.etag().etag().etag().etag(), a.conn.postCommand(d, function(i, c) {
                function d(e) {
                    e && !u && (u = e), --m || r._storage.runAfterDeferredCalls(function() {
                        t(u);
                    });
                }
                if (i) return console.error(i), a._reportErrorIfNecessary(i), t("unknown"), void 0;
                var l, u, h = 0, m = 1, p = new b.EventParser(), f = [ n.Sync, n.Collections, n.Collection ];
                return p.addEventListener(f.concat(n.SyncKey), function(e) {
                    r.syncKey = e.children[0].textContent;
                }), p.addEventListener(f.concat(n.Status), function(e) {
                    l = e.children[0].textContent;
                }), p.addEventListener(f.concat(n.Responses, n.Fetch, n.ApplicationData, o.Body), function(t) {
                    var n = e[h++], s = t.children[0].textContent;
                    m++, r._storage.getMessageBody(n.suid, n.date, function(e) {
                        r._updateBody(n, e, s, !1, d);
                    });
                }), p.run(c), l !== s.Status.Success ? d("unknown") : (d(null), void 0);
            });
        },
        _updateBody: function(e, t, n, s, o) {
            var i = t.bodyReps[0];
            n.length && "\n" === n[n.length - 1] && (n = n.slice(0, -1)), n = n.replace(/\r/g, "");
            var r = s ? "plain" : i.type, a = w.processMessageContent(n, r, !s, !0, this._LOG);
            e.snippet = a.snippet, i.isDownloaded = !s, i.amountDownloaded = n.length, s || (i.content = a.content);
            var c = {
                changeDetails: {
                    bodyReps: [ 0 ]
                }
            };
            this._storage.updateMessageHeader(e.date, e.id, !1, e, t), this._storage.updateMessageBody(e, t, {}, c), 
            this._storage.runAfterDeferredCalls(o.bind(null, null, t));
        },
        sync: p(1, function(e, t, s) {
            var o = this, i = 0, r = 0, a = 0;
            this._LOG.sync_begin(null, null, null), this._enumerateFolderChanges(function(s, c, d, l, u) {
                var h = o._storage;
                if ("badkey" === s) return o._account._recreateFolder(h.folderId, function() {
                    o._storage = null, o._LOG.sync_end(null, null, null);
                }), void 0;
                if (s) return o._LOG.sync_end(null, null, null), t(s), void 0;
                for (var m in Iterator(c)) {
                    var p = m[1];
                    h.hasMessageWithServerId(p.header.srvid) || (h.addMessageHeader(p.header, p.body), 
                    h.addMessageBody(p.header, p.body), i++);
                }
                for (var m in Iterator(d)) {
                    var p = m[1];
                    h.hasMessageWithServerId(p.header.srvid) && (h.updateMessageHeaderByServerId(p.header.srvid, !0, function(e) {
                        return p.header.mergeInto(e), !0;
                    }, null), r++);
                }
                for (var m in Iterator(l)) {
                    var f = m[1];
                    h.hasMessageWithServerId(f) && (h.deleteMessageByServerId(f), a++);
                }
                if (!u) {
                    var g = i + r + a;
                    h.runAfterDeferredCalls(function() {
                        o._LOG.sync_end(i, r, a), h.markSyncRange(n.OLDEST_SYNC_DATE, e, "XXX", e), t(null, null, g);
                    });
                }
            }, s);
        }),
        performMutation: p(1, function(e, t) {
            var n = this, s = i.Tags, o = this._account, r = new b.Writer("1.3", 1, "UTF-8");
            r.stag(s.Sync).stag(s.Collections).stag(s.Collection), o.conn.currentVersion.lt("12.1") && r.tag(s.Class, "Email"), 
            r.tag(s.SyncKey, this.syncKey).tag(s.CollectionId, this.serverId).tag(s.DeletesAsMoves, "trash" === this.folderMeta.type ? "0" : "1").tag(s.GetChanges, "0").stag(s.Commands);
            try {
                e(r);
            } catch (a) {
                return console.error("Exception in performMutation callee:", a, "\n", a.stack), 
                t("unknown"), void 0;
            }
            r.etag(s.Commands).etag(s.Collection).etag(s.Collections).etag(s.Sync), o.conn.postCommand(r, function(e, r) {
                if (e) return console.error("postCommand error:", e), o._reportErrorIfNecessary(e), 
                t("unknown"), void 0;
                var a, c, d = new b.EventParser(), l = [ s.Sync, s.Collections, s.Collection ];
                d.addEventListener(l.concat(s.SyncKey), function(e) {
                    a = e.children[0].textContent;
                }), d.addEventListener(l.concat(s.Status), function(e) {
                    c = e.children[0].textContent;
                });
                try {
                    d.run(r);
                } catch (u) {
                    return console.error("Error parsing Sync response:", u, "\n", u.stack), t("unknown"), 
                    void 0;
                }
                c === i.Enums.Status.Success ? (n.syncKey = a, t && t(null)) : (console.error("Something went wrong during ActiveSync syncing and we got a status of " + c), 
                t("status:" + c));
            });
        }),
        downloadMessageAttachments: p(2, function(e, t, n) {
            var s = this, o = d.Tags, i = d.Enums.Status, a = r.Tags, c = new b.Writer("1.3", 1, "UTF-8");
            c.stag(o.ItemOperations);
            for (var l in Iterator(t)) {
                var u = l[1];
                c.stag(o.Fetch).tag(o.Store, "Mailbox").tag(a.FileReference, u.part).etag();
            }
            c.etag(), this._account.conn.postCommand(c, function(e, r) {
                if (e) return console.error("postCommand error:", e), s._account._reportErrorIfNecessary(e), 
                n("unknown"), void 0;
                var c, d = {}, l = new b.EventParser();
                l.addEventListener([ o.ItemOperations, o.Status ], function(e) {
                    c = e.children[0].textContent;
                }), l.addEventListener([ o.ItemOperations, o.Response, o.Fetch ], function(e) {
                    var t = null, n = {};
                    for (var s in Iterator(e.children)) {
                        var i = s[1];
                        switch (i.tag) {
                          case o.Status:
                            n.status = i.children[0].textContent;
                            break;

                          case a.FileReference:
                            t = i.children[0].textContent;
                            break;

                          case o.Properties:
                            var r = null, c = null;
                            for (var l in Iterator(i.children)) {
                                var u = l[1], h = u.children[0].textContent;
                                switch (u.tag) {
                                  case a.ContentType:
                                    r = h;
                                    break;

                                  case o.Data:
                                    c = new Buffer(h, "base64");
                                }
                            }
                            r && c && (n.data = new Blob([ c ], {
                                type: r
                            }));
                        }
                        t && (d[t] = n);
                    }
                }), l.run(r);
                var u = c !== i.Success ? "unknown" : null, h = [];
                for (var m in Iterator(t)) {
                    var p = m[1];
                    d.hasOwnProperty(p.part) && d[p.part].status === i.Success ? h.push(d[p.part].data) : (u = "unknown", 
                    h.push(null));
                }
                n(u, h);
            });
        })
    }, h.ActiveSyncFolderSyncer = g, g.prototype = {
        get syncable() {
            return null !== this.folderConn.serverId;
        },
        get canGrowSync() {
            return !1;
        },
        initialSync: function(e, n, s, o, i) {
            s("sync", !0), this.folderConn.sync(t.NOW(), this.onSyncCompleted.bind(this, o, !0), i);
        },
        refreshSync: function(e, n, s, o, i, r, a) {
            this.folderConn.sync(t.NOW(), this.onSyncCompleted.bind(this, r, !1), a);
        },
        growSync: function() {
            return !1;
        },
        onSyncCompleted: function(e, t, s, o, i) {
            var r = this.folderStorage;
            return console.log("Sync Completed!", i, "messages synced"), s || r.markSyncedToDawnOfTime(), 
            this._account.__checkpointSyncCompleted(), s ? (e(s), void 0) : (t ? (r._curSyncSlice.ignoreHeaders = !1, 
            r._curSyncSlice.waitingOnData = "db", r.getMessagesInImapDateRange(0, null, n.INITIAL_FILL_SIZE, n.INITIAL_FILL_SIZE, r.onFetchDBHeaders.bind(r, r._curSyncSlice, !1, e, null))) : e(s), 
            void 0);
        },
        allConsumersDead: function() {},
        shutdown: function() {
            this.folderConn.shutdown(), this._LOG.__die();
        }
    };
    var N = h.LOGFAB = e.register(l, {
        ActiveSyncFolderConn: {
            type: e.CONNECTION,
            subtype: e.CLIENT,
            events: {
                inferFilterType: {
                    filterType: !1
                }
            },
            asyncJobs: {
                sync: {
                    newMessages: !0,
                    changedMessages: !0,
                    deletedMessages: !0
                }
            },
            errors: {
                htmlParseError: {
                    ex: e.EXCEPTION
                },
                htmlSnippetError: {
                    ex: e.EXCEPTION
                },
                textChewError: {
                    ex: e.EXCEPTION
                },
                textSnippetError: {
                    ex: e.EXCEPTION
                }
            }
        },
        ActiveSyncFolderSyncer: {
            type: e.DATABASE,
            events: {}
        }
    });
}), function(e, t) {
    "object" == typeof exports ? module.exports = t() : "function" == typeof define && define.amd ? define("activesync/codepages/Move", [], t) : e.ASCPMove = t();
}(this, function() {
    return {
        Tags: {
            MoveItems: 1285,
            Move: 1286,
            SrcMsgId: 1287,
            SrcFldId: 1288,
            DstFldId: 1289,
            Response: 1290,
            Status: 1291,
            DstMsgId: 1292
        },
        Enums: {
            Status: {
                InvalidSourceID: "1",
                InvalidDestID: "2",
                Success: "3",
                SourceIsDest: "4",
                MoveFailure: "5",
                ItemLocked: "7"
            }
        }
    };
}), define("mailapi/activesync/jobs", [ "rdcommon/log", "mix", "../jobmixins", "mailapi/drafts/jobs", "activesync/codepages/AirSync", "activesync/codepages/Email", "activesync/codepages/Move", "module", "require", "exports" ], function(e, t, n, s, o, i, r, a, c, d) {
    function l(e, t, n) {
        return function() {
            var s = Array.slice(arguments), o = s[e], i = this;
            c([ "wbxml" ], function(e) {
                h || (h = e), i.account.withConnection(o, function() {
                    t.apply(i, s);
                }, n);
            });
        };
    }
    function u(e, t, n) {
        this.account = e, this.resilientServerIds = !0, this._heldMutexReleasers = [], this._LOG = m.ActiveSyncJobDriver(this, n, this.account.id), 
        this._state = t, t.hasOwnProperty("suidToServerId") || (t.suidToServerId = {}, t.moveMap = {}), 
        this._stateDelta = {
            serverIdMap: null,
            moveMap: null
        };
    }
    var h;
    d.ActiveSyncJobDriver = u, u.prototype = {
        postJobCleanup: n.postJobCleanup,
        allJobsDone: n.allJobsDone,
        _accessFolderForMutation: function(e, t, n, s, o) {
            var i = this.account.getFolderStorageForFolderId(e), r = this;
            i.runMutexed(o, function(e) {
                r._heldMutexReleasers.push(e);
                var s = i.folderSyncer;
                if (t) r.account.withConnection(n, function() {
                    try {
                        n(s.folderConn, i);
                    } catch (e) {
                        r._LOG.callbackErr(e);
                    }
                }); else try {
                    n(s.folderConn, i);
                } catch (o) {
                    r._LOG.callbackErr(o);
                }
            });
        },
        _partitionAndAccessFoldersSequentially: n._partitionAndAccessFoldersSequentially,
        local_do_modtags: n.local_do_modtags,
        do_modtags: l(1, function(e, t, n) {
            function s(e) {
                return r && -1 !== r.indexOf(e) ? !0 : a && -1 !== a.indexOf(e) ? !1 : void 0;
            }
            var r = n ? e.removeTags : e.addTags, a = n ? e.addTags : e.removeTags, c = s("\\Seen"), d = s("\\Flagged"), l = o.Tags, u = i.Tags, h = null;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, n, s, o) {
                return n = n.filter(function(e) {
                    return !!e;
                }), n.length ? (e.performMutation(function(e) {
                    for (var t = 0; t < n.length; t++) e.stag(l.Change).tag(l.ServerId, n[t]).stag(l.ApplicationData), 
                    void 0 !== c && e.tag(u.Read, c ? "1" : "0"), void 0 !== d && e.stag(u.Flag).tag(u.Status, d ? "2" : "0").etag(), 
                    e.etag(l.ApplicationData).etag(l.Change);
                }, function(e) {
                    e && (h = e), o();
                }), void 0) : (o(), void 0);
            }, function() {
                t(h);
            }, function() {
                h = "aborted-retry";
            }, n, "modtags");
        }),
        check_modtags: function(e, t) {
            t(null, "idempotent");
        },
        local_undo_modtags: n.local_undo_modtags,
        undo_modtags: function(e, t) {
            this.do_modtags(e, t, !0);
        },
        local_do_move: n.local_do_move,
        do_move: l(1, function(e, t) {
            var n = null, s = this.account, o = this.account.getFolderStorageForFolderId(e.targetFolder), i = r.Tags;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, r, a, c) {
                if (r = r.filter(function(e) {
                    return !!e;
                }), !r.length) return c(), void 0;
                if (r = r.filter(function(e) {
                    return !!e;
                }), !r.length) return c(), void 0;
                var d = new h.Writer("1.3", 1, "UTF-8");
                d.stag(i.MoveItems);
                for (var l = 0; l < r.length; l++) d.stag(i.Move).tag(i.SrcMsgId, r[l]).tag(i.SrcFldId, t.folderMeta.serverId).tag(i.DstFldId, o.folderMeta.serverId).etag(i.Move);
                d.etag(i.MoveItems), s.conn.postCommand(d, function(e) {
                    e && (n = e, console.error("failure moving messages:", e)), c();
                });
            }, function() {
                t(n, null, !0);
            }, function() {
                n = "aborted-retry";
            }, !1, "move");
        }),
        check_move: function() {},
        local_undo_move: n.local_undo_move,
        undo_move: function() {},
        local_do_delete: n.local_do_delete,
        do_delete: l(1, function(e, t) {
            var n = null, s = o.Tags;
            i.Tags, this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, o, i, r) {
                return o = o.filter(function(e) {
                    return !!e;
                }), o.length ? (e.performMutation(function(e) {
                    for (var t = 0; t < o.length; t++) e.stag(s.Delete).tag(s.ServerId, o[t]).etag(s.Delete);
                }, function(e) {
                    e && (n = e, console.error("failure deleting messages:", e)), r();
                }), void 0) : (r(), void 0);
            }, function() {
                t(n, null, !0);
            }, function() {
                n = "aborted-retry";
            }, !1, "delete");
        }),
        check_delete: function(e, t) {
            t(null, "idempotent");
        },
        local_undo_delete: n.local_undo_delete,
        undo_delete: function(e, t) {
            t("moot");
        },
        local_do_syncFolderList: function(e, t) {
            t(null);
        },
        do_syncFolderList: l(1, function(e, t) {
            var n, s = this.account, o = s.getFirstFolderWithType("inbox");
            o && null === o.serverId && (n = s.getFolderStorageForFolderId(o.id)), s.syncFolderList(function(e) {
                e || (s.meta.lastFolderSyncAt = Date.now()), t(e ? "aborted-retry" : null, null, !e), 
                n && n.hasActiveSlices && (e || (console.log("Refreshing fake inbox"), n.resetAndRefreshActiveSlices()));
            });
        }, "aborted-retry"),
        check_syncFolderList: function(e, t) {
            t("idempotent");
        },
        local_undo_syncFolderList: function(e, t) {
            t("moot");
        },
        undo_syncFolderList: function(e, t) {
            t("moot");
        },
        local_do_downloadBodies: n.local_do_downloadBodies,
        do_downloadBodies: n.do_downloadBodies,
        check_downloadBodies: n.check_downloadBodies,
        local_do_downloadBodyReps: n.local_do_downloadBodyReps,
        do_downloadBodyReps: n.do_downloadBodyReps,
        check_downloadBodyReps: n.check_downloadBodyReps,
        local_do_download: n.local_do_download,
        do_download: n.do_download,
        check_download: n.check_download,
        local_undo_download: n.local_undo_download,
        undo_download: n.undo_download,
        local_do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        check_purgeExcessMessages: function() {
            return "idempotent";
        },
        local_undo_purgeExcessMessages: function(e, t) {
            t(null);
        },
        undo_purgeExcessMessages: function(e, t) {
            t(null);
        }
    }, t(u.prototype, s.draftsMixins);
    var m = d.LOGFAB = e.register(a, {
        ActiveSyncJobDriver: {
            type: e.DAEMON,
            events: {
                savedAttachment: {
                    storage: !0,
                    mimeType: !0,
                    size: !0
                },
                saveFailure: {
                    storage: !1,
                    mimeType: !1,
                    error: !1
                }
            },
            TEST_ONLY_events: {
                saveFailure: {
                    filename: !1
                }
            },
            errors: {
                callbackErr: {
                    ex: e.EXCEPTION
                }
            }
        }
    });
}), define("mailapi/activesync/account", [ "rdcommon/log", "../a64", "../accountmixins", "../mailslice", "../searchfilter", "activesync/codepages/FolderHierarchy", "./folder", "./jobs", "../util", "module", "require", "exports" ], function(e, t, n, s, o, i, r, a, c, d, l, u) {
    function h(e, t, n) {
        return function() {
            var s = Array.slice(arguments), o = s[e], i = this;
            this.withConnection(o, function() {
                t.apply(i, s);
            }, n);
        };
    }
    function m(e, t, n, o, c, d) {
        this.universe = e, this.id = t.id, this.accountDef = t, t.connInfo.deviceId || (t.connInfo.deviceId = u.makeUniqueDeviceId()), 
        this._db = o, this._LOG = _.ActiveSyncAccount(this, d, this.id), c ? (this.conn = c, 
        this._attachLoggerToConnection(this.conn)) : this.conn = null, this.enabled = !0, 
        this.problems = [], this._alive = !0, this.identities = t.identities, this.folders = [], 
        this._folderStorages = {}, this._folderInfos = n, this._serverIdToFolderId = {}, 
        this._deadFolderIds = null, this._syncsInProgress = 0, this._lastSyncKey = null, 
        this._lastSyncResponseWasEmpty = !1, this.meta = n.$meta, this.mutations = n.$mutations, 
        this.tzOffset = 0;
        for (var l in n) if ("$" !== l[0]) {
            var h = n[l];
            this._folderStorages[l] = new s.FolderStorage(this, l, h, this._db, r.ActiveSyncFolderSyncer, this._LOG), 
            this._serverIdToFolderId[h.$meta.serverId] = l, this.folders.push(h.$meta);
        }
        this.folders.sort(function(e, t) {
            return e.path.localeCompare(t.path);
        }), this._jobDriver = new a.ActiveSyncJobDriver(this, this._folderInfos.$mutationState);
        var m = this.getFirstFolderWithType("inbox");
        m || this._addedFolder(null, "0", "Inbox", i.Enums.Type.DefaultInbox, null, !0);
    }
    var p, f, g, y = c.bsearchForInsert, v = u.DEFAULT_TIMEOUT_MS = 3e4;
    u.makeUniqueDeviceId = function() {
        return Math.random().toString(36).substr(2);
    }, u.Account = u.ActiveSyncAccount = m, m.prototype = {
        type: "activesync",
        supportsServerFolders: !0,
        toString: function() {
            return "[ActiveSyncAccount: " + this.id + "]";
        },
        withConnection: function(e, t, n) {
            if (!p) return l([ "wbxml", "activesync/protocol", "activesync/codepages" ], function(s, o, i) {
                p = s, f = o, g = i, this.withConnection(e, t, n);
            }.bind(this)), void 0;
            if (!this.conn) {
                var s = this.accountDef;
                this.conn = new f.Connection(s.connInfo.deviceId), this._attachLoggerToConnection(this.conn), 
                this.conn.open(s.connInfo.server, s.credentials.username, s.credentials.password), 
                this.conn.timeout = v;
            }
            this.conn.connected ? t() : this.conn.connect(function(s) {
                return s ? (this._reportErrorIfNecessary(s), e(n || "unknown"), void 0) : (t(), 
                void 0);
            }.bind(this));
        },
        _reportErrorIfNecessary: function(e) {
            e && e instanceof f.HttpError && 401 === e.status && this.universe.__reportAccountProblem(this, "bad-user-or-pass");
        },
        _attachLoggerToConnection: function(e) {
            var t = _.ActiveSyncConnection(e, this._LOG, Date.now() % 1e3);
            "safe" === t.logLevel ? e.onmessage = this._onmessage_safe.bind(this, t) : "dangerous" === t.logLevel && (e.onmessage = this._onmessage_dangerous.bind(this, t));
        },
        _onmessage_safe: function(e, t, n, s, o, i, r, a) {
            "options" === t ? e.options(n, s.status, a) : e.command(t, n, s.status);
        },
        _onmessage_dangerous: function(e, t, n, s, o, i, r, a) {
            if ("options" === t) e.options(n, s.status, a); else {
                var c, d;
                if (r) try {
                    var l = new p.Reader(new Uint8Array(r), g);
                    c = l.dump();
                } catch (u) {
                    c = "parse problem";
                }
                if (a) try {
                    d = a.dump(), a.rewind();
                } catch (u) {
                    d = "parse problem";
                }
                e.command(t, n, s.status, o, i, c, d);
            }
        },
        toBridgeWire: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: this.accountDef.type,
                defaultPriority: this.accountDef.defaultPriority,
                enabled: this.enabled,
                problems: this.problems,
                syncRange: this.accountDef.syncRange,
                syncInterval: this.accountDef.syncInterval,
                notifyOnNew: this.accountDef.notifyOnNew,
                identities: this.identities,
                credentials: {
                    username: this.accountDef.credentials.username
                },
                servers: [ {
                    type: this.accountDef.type,
                    connInfo: this.accountDef.connInfo
                } ]
            };
        },
        toBridgeFolder: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: "account"
            };
        },
        get numActiveConns() {
            return 0;
        },
        checkAccount: function(e) {
            null != this.conn && (this.conn.connected && this.conn.disconnect(), this.conn = null), 
            this.withConnection(function(t) {
                e(t);
            }, function() {
                e();
            });
        },
        __checkpointSyncCompleted: function() {
            this.saveAccountState(null, null, "checkpointSync");
        },
        shutdown: function(e) {
            this._LOG.__die(), e && e();
        },
        accountDeleted: function() {
            this._alive = !1, this.shutdown();
        },
        sliceFolderMessages: function(e, t) {
            var n = this._folderStorages[e], o = new s.MailSlice(t, n, this._LOG);
            n.sliceOpenMostRecent(o);
        },
        searchFolderMessages: function(e, t, n, s) {
            var i = this._folderStorages[e], r = new o.SearchSlice(t, i, n, s, this._LOG);
            return i.sliceOpenSearch(r), r;
        },
        syncFolderList: h(0, function(e) {
            var t = this, n = g.FolderHierarchy.Tags, s = new p.Writer("1.3", 1, "UTF-8");
            s.stag(n.FolderSync).tag(n.SyncKey, this.meta.syncKey).etag(), this.conn.postCommand(s, function(s, o) {
                if (s) return t._reportErrorIfNecessary(s), e(s), void 0;
                var i = new p.EventParser(), r = [];
                i.addEventListener([ n.FolderSync, n.SyncKey ], function(e) {
                    t.meta.syncKey = e.children[0].textContent;
                }), i.addEventListener([ n.FolderSync, n.Changes, [ n.Add, n.Delete ] ], function(e) {
                    var s = {};
                    for (var o in Iterator(e.children)) {
                        var i = o[1];
                        s[i.localTagName] = i.children[0].textContent;
                    }
                    e.tag === n.Add ? t._addedFolder(s.ServerId, s.ParentId, s.DisplayName, s.Type) || r.push(s) : t._deletedFolder(s.ServerId);
                });
                try {
                    i.run(o);
                } catch (a) {
                    return console.error("Error parsing FolderSync response:", a, "\n", a.stack), e("unknown"), 
                    void 0;
                }
                for (;r.length; ) {
                    var c = [];
                    for (var d in Iterator(r)) {
                        var l = d[1];
                        t._addedFolder(l.ServerId, l.ParentId, l.DisplayName, l.Type) || c.push(l);
                    }
                    if (c.length === r.length) throw new Error("got some orphaned folders");
                    r = c;
                }
                var u = t.getFirstFolderWithType("localdrafts");
                if (!u) {
                    var h, m = t.getFirstFolderWithType("drafts") || t.getFirstFolderWithType("sent");
                    h = m ? m.parentId ? t._folderInfos[m.parentId].$meta.serverId : "0" : t.getFirstFolderWithType("inbox").serverId, 
                    t._addedFolder(null, h, "localdrafts", null, "localdrafts");
                }
                console.log("Synced folder list"), e && e(null);
            });
        }),
        _folderTypes: {
            1: "normal",
            2: "inbox",
            3: "drafts",
            4: "trash",
            5: "sent",
            6: "normal",
            12: "normal"
        },
        _addedFolder: function(e, n, o, a, c, d) {
            if (!(c || a in this._folderTypes)) return !0;
            var l = i.Enums.Type, u = o, h = null, m = 0;
            if ("0" !== n) {
                if (h = this._serverIdToFolderId[n], void 0 === h) return null;
                var p = this._folderInfos[h];
                u = p.$meta.path + "/" + u, m = p.$meta.depth + 1;
            }
            if (a === l.DefaultInbox) {
                var f = this.getFirstFolderWithType("inbox");
                if (f) return delete this._serverIdToFolderId[f.serverId], this._serverIdToFolderId[e] = f.id, 
                f.serverId = e, f.name = o, f.path = u, f.depth = m, f;
            }
            var g = this.id + "/" + t.encodeInt(this.meta.nextFolderNum++), v = this._folderInfos[g] = {
                $meta: {
                    id: g,
                    serverId: e,
                    name: o,
                    type: c || this._folderTypes[a],
                    path: u,
                    parentId: h,
                    depth: m,
                    lastSyncedAt: 0,
                    syncKey: "0"
                },
                $impl: {
                    nextId: 0,
                    nextHeaderBlock: 0,
                    nextBodyBlock: 0
                },
                accuracy: [],
                headerBlocks: [],
                bodyBlocks: [],
                serverIdHeaderBlockMapping: {}
            };
            console.log("Added folder " + o + " (" + g + ")"), this._folderStorages[g] = new s.FolderStorage(this, g, v, this._db, r.ActiveSyncFolderSyncer, this._LOG), 
            this._serverIdToFolderId[e] = g;
            var _ = v.$meta, b = y(this.folders, _, function(e, t) {
                return e.path.localeCompare(t.path);
            });
            return this.folders.splice(b, 0, _), d || this.universe.__notifyAddedFolder(this, _), 
            _;
        },
        _deletedFolder: function(e, t) {
            var n = this._serverIdToFolderId[e], s = this._folderInfos[n], o = s.$meta;
            console.log("Deleted folder " + o.name + " (" + n + ")"), delete this._serverIdToFolderId[e], 
            delete this._folderInfos[n], delete this._folderStorages[n];
            var i = this.folders.indexOf(o);
            this.folders.splice(i, 1), null === this._deadFolderIds && (this._deadFolderIds = []), 
            this._deadFolderIds.push(n), t || this.universe.__notifyRemovedFolder(this, o);
        },
        _recreateFolder: function(e, t) {
            this._LOG.recreateFolder(e);
            var n = this._folderInfos[e];
            n.$impl = {
                nextId: 0,
                nextHeaderBlock: 0,
                nextBodyBlock: 0
            }, n.accuracy = [], n.headerBlocks = [], n.bodyBlocks = [], n.serverIdHeaderBlockMapping = {}, 
            null === this._deadFolderIds && (this._deadFolderIds = []), this._deadFolderIds.push(e);
            var o = this;
            this.saveAccountState(null, function() {
                var i = new s.FolderStorage(o, e, n, o._db, r.ActiveSyncFolderSyncer, o._LOG);
                for (var a in Iterator(o._folderStorages[e]._slices)) {
                    var c = a[1];
                    c._storage = i, c.reset(), i.sliceOpenMostRecent(c);
                }
                o._folderStorages[e]._slices = [], o._folderStorages[e] = i, t(i);
            }, "recreateFolder");
        },
        createFolder: h(3, function(e, t, n, s) {
            var o = this, i = e ? this._folderInfos[e] : "0", r = g.FolderHierarchy.Tags, a = g.FolderHierarchy.Enums.Status, c = g.FolderHierarchy.Enums.Type.Mail, d = new p.Writer("1.3", 1, "UTF-8");
            d.stag(r.FolderCreate).tag(r.SyncKey, this.meta.syncKey).tag(r.ParentId, i).tag(r.DisplayName, t).tag(r.Type, c).etag(), 
            this.conn.postCommand(d, function(e, n) {
                o._reportErrorIfNecessary(e);
                var d, l, u = new p.EventParser();
                u.addEventListener([ r.FolderCreate, r.Status ], function(e) {
                    d = e.children[0].textContent;
                }), u.addEventListener([ r.FolderCreate, r.SyncKey ], function(e) {
                    o.meta.syncKey = e.children[0].textContent;
                }), u.addEventListener([ r.FolderCreate, r.ServerId ], function(e) {
                    l = e.children[0].textContent;
                });
                try {
                    u.run(n);
                } catch (h) {
                    return console.error("Error parsing FolderCreate response:", h, "\n", h.stack), 
                    s("unknown"), void 0;
                }
                if (d === a.Success) {
                    var m = o._addedFolder(l, i, t, c);
                    s(null, m);
                } else d === a.FolderExists ? s("already-exists") : s("unknown");
            });
        }),
        deleteFolder: h(1, function(e, t) {
            var n = this, s = this._folderInfos[e].$meta, o = g.FolderHierarchy.Tags, i = g.FolderHierarchy.Enums.Status;
            g.FolderHierarchy.Enums.Type.Mail;
            var r = new p.Writer("1.3", 1, "UTF-8");
            r.stag(o.FolderDelete).tag(o.SyncKey, this.meta.syncKey).tag(o.ServerId, s.serverId).etag(), 
            this.conn.postCommand(r, function(e, r) {
                n._reportErrorIfNecessary(e);
                var a, c = new p.EventParser();
                c.addEventListener([ o.FolderDelete, o.Status ], function(e) {
                    a = e.children[0].textContent;
                }), c.addEventListener([ o.FolderDelete, o.SyncKey ], function(e) {
                    n.meta.syncKey = e.children[0].textContent;
                });
                try {
                    c.run(r);
                } catch (d) {
                    return console.error("Error parsing FolderDelete response:", d, "\n", d.stack), 
                    t("unknown"), void 0;
                }
                a === i.Success ? (n._deletedFolder(s.serverId), t(null, s)) : t("unknown");
            });
        }),
        sendMessage: h(1, function(e, t) {
            var n = this;
            e.withMessageBlob({
                includeBcc: !0
            }, function(e) {
                if (this.conn.currentVersion.gte("14.0")) {
                    var s = g.ComposeMail.Tags, o = new p.Writer("1.3", 1, "UTF-8", null, "blob");
                    o.stag(s.SendMail).tag(s.ClientId, Date.now().toString() + "@mozgaia").tag(s.SaveInSentItems).stag(s.Mime).opaque(e).etag().etag(), 
                    this.conn.postCommand(o, function(e, s) {
                        return e ? (n._reportErrorIfNecessary(e), console.error(e), t("unknown"), void 0) : (null === s ? (console.log("Sent message successfully!"), 
                        t(null)) : (console.error("Error sending message. XML dump follows:\n" + s.dump()), 
                        t("unknown")), void 0);
                    });
                } else this.conn.postData("SendMail", "message/rfc822", e, function(e) {
                    return e ? (n._reportErrorIfNecessary(e), console.error(e), t("unknown"), void 0) : (console.log("Sent message successfully!"), 
                    t(null), void 0);
                }, {
                    SaveInSent: "T"
                });
            }.bind(this));
        }),
        getFolderStorageForFolderId: function(e) {
            return this._folderStorages[e];
        },
        getFolderStorageForServerId: function(e) {
            return this._folderStorages[this._serverIdToFolderId[e]];
        },
        getFolderMetaForFolderId: function(e) {
            return this._folderInfos.hasOwnProperty(e) ? this._folderInfos[e].$meta : null;
        },
        ensureEssentialFolders: function(e) {
            e && e();
        },
        scheduleMessagePurge: function(e, t) {
            t && t();
        },
        runOp: n.runOp,
        getFirstFolderWithType: n.getFirstFolderWithType,
        getFolderByPath: n.getFolderByPath,
        saveAccountState: n.saveAccountState,
        runAfterSaves: n.runAfterSaves
    };
    var _ = u.LOGFAB = e.register(d, {
        ActiveSyncAccount: {
            type: e.ACCOUNT,
            events: {
                createFolder: {},
                deleteFolder: {},
                recreateFolder: {
                    id: !1
                },
                saveAccountState: {
                    reason: !1
                },
                accountDeleted: {
                    where: !1
                }
            },
            asyncJobs: {
                runOp: {
                    mode: !0,
                    type: !0,
                    error: !1,
                    op: !1
                }
            },
            errors: {
                opError: {
                    mode: !1,
                    type: !1,
                    ex: e.EXCEPTION
                }
            }
        },
        ActiveSyncConnection: {
            type: e.CONNECTION,
            events: {
                options: {
                    special: !1,
                    status: !1,
                    result: !1
                },
                command: {
                    name: !1,
                    special: !1,
                    status: !1
                }
            },
            TEST_ONLY_events: {
                options: {},
                command: {
                    params: !1,
                    extraHeaders: !1,
                    sent: !1,
                    response: !1
                }
            }
        }
    });
}), define("mailapi/activesync/configurator", [ "rdcommon/log", "../accountcommon", "../a64", "./account", "../date", "require", "exports" ], function(e, t, n, s, o, i, r) {
    function a(e, t) {
        var n = /^https:\/\/([^:\/]+)(?::(\d+))?/.exec(e);
        if (!n) return t(null), void 0;
        var s = n[2] ? parseInt(n[2], 10) : 443, o = n[1];
        console.log("checking", o, s, "for security problem"), i([ "tls" ], function(e) {
            function n(e) {
                if (i) {
                    var n = i;
                    i = null;
                    try {
                        n.end();
                    } catch (s) {}
                    t(e);
                }
            }
            var i = e.connect(s, o);
            i.on("connect", function() {
                i.write(new Buffer("GET /images/logo.png HTTP/1.1\n\n"));
            }), i.on("error", function(e) {
                var t = null;
                e && "object" == typeof e && /^Security/.test(e.name) && (t = "bad-security"), n(t);
            }), i.on("data", function() {
                n(null);
            });
        });
    }
    r.account = s, r.configurator = {
        tryToCreateAccount: function(e, t, r, c) {
            i([ "activesync/protocol" ], function(i) {
                var d = {
                    username: r.incoming.username,
                    password: t.password
                }, l = s.makeUniqueDeviceId(), u = this, h = new i.Connection(l);
                h.open(r.incoming.server, d.username, d.password), h.timeout = s.DEFAULT_TIMEOUT_MS, 
                h.connect(function(s) {
                    if (s) {
                        var m, p = {
                            server: r.incoming.server
                        };
                        return s instanceof i.HttpError ? (401 === s.status ? m = "bad-user-or-pass" : 403 === s.status ? m = "not-authorized" : (m = "server-problem", 
                        p.status = s.status), c(m, null, p), void 0) : (a(r.incoming.server, function(e) {
                            var t;
                            t = e ? "bad-security" : "unresponsive-server", c(t, null, p);
                        }), void 0);
                    }
                    var f = n.encodeInt(e.config.nextAccountNum++), g = {
                        id: f,
                        name: t.accountName || t.emailAddress,
                        defaultPriority: o.NOW(),
                        type: "activesync",
                        syncRange: "auto",
                        syncInterval: t.syncInterval || 0,
                        notifyOnNew: t.hasOwnProperty("notifyOnNew") ? t.notifyOnNew : !0,
                        credentials: d,
                        connInfo: {
                            server: r.incoming.server,
                            deviceId: l
                        },
                        identities: [ {
                            id: f + "/" + n.encodeInt(e.config.nextIdentityNum++),
                            name: t.displayName || r.displayName,
                            address: t.emailAddress,
                            replyTo: null,
                            signature: null
                        } ]
                    };
                    u._loadAccount(e, g, h, function(e) {
                        c(null, e, null);
                    });
                });
            }.bind(this));
        },
        recreateAccount: function(e, o, i, r) {
            var a = i.def, c = {
                username: a.credentials.username,
                password: a.credentials.password
            }, d = n.encodeInt(e.config.nextAccountNum++), l = {
                id: d,
                name: a.name,
                type: "activesync",
                syncRange: a.syncRange,
                syncInterval: a.syncInterval || 0,
                notifyOnNew: a.hasOwnProperty("notifyOnNew") ? a.notifyOnNew : !0,
                credentials: c,
                connInfo: {
                    server: a.connInfo.server,
                    deviceId: a.connInfo.deviceId || s.makeUniqueDeviceId()
                },
                identities: t.recreateIdentities(e, d, a.identities)
            };
            this._loadAccount(e, l, null, function(e) {
                r(null, e, null);
            });
        },
        _loadAccount: function(e, t, n, s) {
            var o = {
                $meta: {
                    nextFolderNum: 0,
                    nextMutationNum: 0,
                    lastFolderSyncAt: 0,
                    syncKey: "0"
                },
                $mutations: [],
                $mutationState: {}
            };
            e.saveAccountDef(t, o), e._loadAccount(t, o, n, s);
        }
    };
});