;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';var NotificationHelper={_referencesArray:[],getIconURI:function nc_getIconURI(app,entryPoint){var icons=app.manifest.icons;if(entryPoint){icons=app.manifest.entry_points[entryPoint].icons;}
if(!icons)
return null;var sizes=Object.keys(icons).map(function parse(str){return parseInt(str,10);});sizes.sort(function(x,y){return y-x;});var HVGA=document.documentElement.clientWidth<480;var index=sizes[HVGA?sizes.length-1:0];return app.installOrigin+icons[index];},send:function nc_send(title,body,icon,clickCB,closeCB){if(!('mozNotification'in navigator))
return;var notification=navigator.mozNotification.createNotification(title,body,icon);notification.onclick=(function(){if(clickCB)
clickCB();this._forget(notification);}).bind(this);notification.onclose=(function(){if(closeCB)
closeCB();this._forget(notification);}).bind(this);notification.show();this._keep(notification);},_keep:function nc_keep(notification){this._referencesArray.push(notification);},_forget:function nc_forget(notification){this._referencesArray.splice(this._referencesArray.indexOf(notification),1);}};;(function(exports){'use strict';function activityDefaultError(event){console.warn('Unhandled error spawning activity: '+
event.target.error.message+'\n');}
function tryActivity(opts,onsuccess,onerror){var activity;if(typeof onerror!=='function'){onerror=activityDefaultError;}
if(window.MozActivity){activity=new MozActivity(opts);if(typeof onsuccess==='function'){activity.onsuccess=onsuccess;}
activity.onerror=onerror;}}
var ActivityPicker={url:function ap_browse(url,onsuccess,onerror){var params={name:'view',data:{type:'url',url:url}};tryActivity(params,onsuccess,onerror);}};exports.ActivityPicker=ActivityPicker;}(this));;'use strict';var ProvisioningAuthentication=(function(){var pin=null;var auth=null;function pa_isDocumentValid(userPin,authInfo){pin=userPin;auth=authInfo;var sec=auth.sec;switch(sec){case'NETWPIN':throw new Error('cp-finish-confirm-dialog-message-auth-error');case'USERPIN':return pa_userPinAuthentication();case'USERNETWPIN':return pa_userNetwPinAuthentication();case'USERPINMAC':return pa_userPinMacAuthentication();default:throw new Error('cp-finish-confirm-dialog-message-auth-unsupported-mechanism');}}
function pa_userPinAuthentication(){var mac=auth.mac;return mac===pa_sign(pin,auth.data,auth.data.length);}
function pa_userNetwPinAuthentication(){throw new Error('cp-finish-confirm-dialog-message-auth-unsupported-mechanism');}
function pa_userPinMacAuthentication(){throw new Error('cp-finish-confirm-dialog-message-auth-unsupported-mechanism');}
function pa_sign(key,data,dataLength){function bin2hex(buffer){var i,f=0,a=[],data=new Uint8Array(buffer);f=data.length;for(i=0;i<f;i++){a[i]=data[i].toString(16).replace(/^([\da-f])$/,'0$1');}
return a.join('');}
var _data=new Uint8Array(dataLength);for(var i=0;i<dataLength;i++){_data[i]=data[i];}
var hmac=CryptoJS.algo.HMAC.create(CryptoJS.algo.SHA1,key);var words=CryptoJS.enc.Hex.parse(bin2hex(_data));hmac.update(words);var hash=hmac.finalize();return hash.toString(CryptoJS.enc.Hex).toUpperCase();}
return{isDocumentValid:pa_isDocumentValid};})();;'use strict';var CpScreenHelper=(function(){var _=null;var screen=null;var quitButton=null;var cancelQuitButton=null;var acceptButton=null;var storeButton=null;var cancelStoreButton=null;var tryAgainButton=null;var finishButton=null;var title=null;var pin=null;var quitAppConfirmDialog=null;var storeConfirmDialog=null;var authFailureConfirmDialog=null;var finishConfirmDialog=null;var showPINInput=false;var authenticated=false;var isDocumentValid=false;var processed=false;var messageTag=null;var authInfo=null;var provisioningDoc=null;var apns=null;function cpsh_init(){_=navigator.mozL10n.get;processed=false;acceptButton=document.getElementById('accept');title=document.getElementById('title');quitAppConfirmDialog=document.getElementById('cp-quit-app-confirm');quitButton=quitAppConfirmDialog.querySelector('.quit');cancelQuitButton=quitAppConfirmDialog.querySelector('.cancel');storeConfirmDialog=document.getElementById('cp-store-confirm');storeButton=storeConfirmDialog.querySelector('.store');cancelStoreButton=storeConfirmDialog.querySelector('.cancel');authFailureConfirmDialog=document.getElementById('cp-auth-failure-confirm');tryAgainButton=authFailureConfirmDialog.querySelector('button');finishConfirmDialog=document.getElementById('cp-finish-confirm');finishButton=finishConfirmDialog.querySelector('button');screen=document.getElementById('cp-screen');pin=screen.querySelector('input');quitButton.addEventListener('click',cpsh_onQuit);cancelQuitButton.addEventListener('click',cpsh_onCancelQuit);acceptButton.addEventListener('click',cpsh_onAccept);storeButton.addEventListener('click',cpsh_onStore);cancelStoreButton.addEventListener('click',cpsh_onCancelStore);tryAgainButton.addEventListener('click',cpsh_onTryAgain);finishButton.addEventListener('click',cpsh_onFinish);}
function cpsh_populateScreen(message){screen.hidden=false;WapPushManager.setOnCloseCallback(cpsh_onClose);acceptButton.hidden=false;authInfo=message.provisioning.authInfo;provisioningDoc=message.provisioning.provisioningDoc;showPINInput=(message.provisioning.authInfo.sec!=='NETWPIN');authenticated=message.provisioning.authInfo.checked;isDocumentValid=message.provisioning.authInfo.pass;var help=document.getElementById('cp-accept-help');if(showPINInput){help.textContent=_('cp-accept-help-pin');pin.type='text';pin.focus();}else{help.textContent=_('cp-accept-help');pin.type='hidden';pin.blur();}
title.textContent=message.sender;messageTag=message.timestamp;}
function cpsh_onClose(evt){if(processed){WapPushManager.close();return;}
quitAppConfirmDialog.hidden=false;}
function cpsh_deleteMessage(messageTag){ParsedMessage.delete(messageTag,function cpsh_deleteSuccess(){},function cpsh_deleteError(error){console.error('Could not remove message from database: '+error);});}
function cpsh_onQuit(evt){evt.preventDefault();quitAppConfirmDialog.hidden=true;WapPushManager.clearNotifications(messageTag);cpsh_deleteMessage(messageTag);WapPushManager.close();}
function cpsh_onCancelQuit(evt){evt.preventDefault();pin.focus();quitAppConfirmDialog.hidden=true;}
function cpsh_onAccept(){var message=null;if(!authenticated){if(!pin.value){authFailureConfirmDialog.hidden=false;return;}
try{isDocumentValid=ProvisioningAuthentication.isDocumentValid(pin.value,authInfo);}catch(e){message=finishConfirmDialog.querySelector('strong');message.textContent=_(e.message);finishConfirmDialog.hidden=false;return;}
authenticated=true;if(!isDocumentValid){authenticated=false;authFailureConfirmDialog.hidden=false;return;}}
if(!showPINInput&&!isDocumentValid){message=finishConfirmDialog.querySelector('strong');message.textContent=_('cp-finish-confirm-dialog-message-invalid-doc');finishConfirmDialog.hidden=false;return;}
var parsedProvisioningDoc=ParsedProvisioningDoc.from(provisioningDoc);apns=parsedProvisioningDoc.getApns();if(apns.length===0){message=finishConfirmDialog.querySelector('strong');message.textContent=_('cp-finish-confirm-dialog-message-no-apns');finishConfirmDialog.hidden=false;return;}
var names=[];var i;for(i=0;i<apns.length;i++){names.push(apns[i].carrier);}
message=storeConfirmDialog.querySelector('.message');var msg='';for(i=0;i<names.length;i++){msg+='\n'+names[i];}
message.textContent=msg;storeConfirmDialog.hidden=false;}
function cpsh_onStore(evt){evt.preventDefault();if(authenticated&&isDocumentValid){storeConfirmDialog.hidden=true;processed=true;StoreProvisioning.provision(apns);WapPushManager.clearNotifications(messageTag);cpsh_deleteMessage(messageTag);finishConfirmDialog.hidden=false;return;}}
function cpsh_onCancelStore(evt){evt.preventDefault();pin.focus();storeConfirmDialog.hidden=true;}
function cpsh_onTryAgain(evt){evt.preventDefault();pin.focus();authFailureConfirmDialog.hidden=true;}
function cpsh_onFinish(evt){evt.preventDefault();finishConfirmDialog.hidden=true;WapPushManager.close();}
return{init:cpsh_init,populateScreen:cpsh_populateScreen};})();;var CryptoJS=CryptoJS||function(g,l){var e={},d=e.lib={},m=function(){},k=d.Base={extend:function(a){m.prototype=this;var c=new m;a&&c.mixIn(a);c.hasOwnProperty("init")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty("toString")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},p=d.WordArray=k.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=l?c:4*a.length},toString:function(a){return(a||n).stringify(this)},concat:function(a){var c=this.words,q=a.words,f=this.sigBytes;a=a.sigBytes;this.clamp();if(f%4)for(var b=0;b<a;b++)c[f+b>>>2]|=(q[b>>>2]>>>24-8*(b%4)&255)<<24-8*((f+b)%4);else if(65535<q.length)for(b=0;b<a;b+=4)c[f+b>>>2]=q[b>>>2];else c.push.apply(c,q);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<32-8*(c%4);a.length=g.ceil(c/4)},clone:function(){var a=k.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],b=0;b<a;b+=4)c.push(4294967296*g.random()|0);return new p.init(c,a)}}),b=e.enc={},n=b.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var b=[],f=0;f<a;f++){var d=c[f>>>2]>>>24-8*(f%4)&255;b.push((d>>>4).toString(16));b.push((d&15).toString(16))}return b.join("")},parse:function(a){for(var c=a.length,b=[],f=0;f<c;f+=2)b[f>>>3]|=parseInt(a.substr(f,2),16)<<24-4*(f%8);return new p.init(b,c/2)}},j=b.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var b=[],f=0;f<a;f++)b.push(String.fromCharCode(c[f>>>2]>>>24-8*(f%4)&255));return b.join("")},parse:function(a){for(var c=a.length,b=[],f=0;f<c;f++)b[f>>>2]|=(a.charCodeAt(f)&255)<<24-8*(f%4);return new p.init(b,c)}},h=b.Utf8={stringify:function(a){try{return decodeURIComponent(escape(j.stringify(a)))}catch(c){throw Error("Malformed UTF-8 data");}},parse:function(a){return j.parse(unescape(encodeURIComponent(a)))}},r=d.BufferedBlockAlgorithm=k.extend({reset:function(){this._data=new p.init;this._nDataBytes=0},_append:function(a){"string"==typeof a&&(a=h.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,b=c.words,f=c.sigBytes,d=this.blockSize,e=f/(4*d),e=a?g.ceil(e):g.max((e|0)-this._minBufferSize,0);a=e*d;f=g.min(4*a,f);if(a){for(var k=0;k<a;k+=d)this._doProcessBlock(b,k);k=b.splice(0,a);c.sigBytes-=f}return new p.init(k,f)},clone:function(){var a=k.clone.call(this);a._data=this._data.clone();return a},_minBufferSize:0});d.Hasher=r.extend({cfg:k.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){r.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,d){return(new a.init(d)).finalize(b)}},_createHmacHelper:function(a){return function(b,d){return(new s.HMAC.init(a,d)).finalize(b)}}});var s=e.algo={};return e}(Math);(function(){var g=CryptoJS,l=g.lib,e=l.WordArray,d=l.Hasher,m=[],l=g.algo.SHA1=d.extend({_doReset:function(){this._hash=new e.init([1732584193,4023233417,2562383102,271733878,3285377520])},_doProcessBlock:function(d,e){for(var b=this._hash.words,n=b[0],j=b[1],h=b[2],g=b[3],l=b[4],a=0;80>a;a++){if(16>a)m[a]=d[e+a]|0;else{var c=m[a-3]^m[a-8]^m[a-14]^m[a-16];m[a]=c<<1|c>>>31}c=(n<<5|n>>>27)+l+m[a];c=20>a?c+((j&h|~j&g)+1518500249):40>a?c+((j^h^g)+1859775393):60>a?c+((j&h|j&g|h&g)-1894007588):c+((j^h^g)-899497514);l=g;g=h;h=j<<30|j>>>2;j=n;n=c}b[0]=b[0]+n|0;b[1]=b[1]+j|0;b[2]=b[2]+h|0;b[3]=b[3]+g|0;b[4]=b[4]+l|0},_doFinalize:function(){var d=this._data,e=d.words,b=8*this._nDataBytes,g=8*d.sigBytes;e[g>>>5]|=128<<24-g%32;e[(g+64>>>9<<4)+14]=Math.floor(b/4294967296);e[(g+64>>>9<<4)+15]=b;d.sigBytes=4*e.length;this._process();return this._hash},clone:function(){var e=d.clone.call(this);e._hash=this._hash.clone();return e}});g.SHA1=d._createHelper(l);g.HmacSHA1=d._createHmacHelper(l)})();(function(){var g=CryptoJS,l=g.enc.Utf8;g.algo.HMAC=g.lib.Base.extend({init:function(e,d){e=this._hasher=new e.init;"string"==typeof d&&(d=l.parse(d));var g=e.blockSize,k=4*g;d.sigBytes>k&&(d=e.finalize(d));d.clamp();for(var p=this._oKey=d.clone(),b=this._iKey=d.clone(),n=p.words,j=b.words,h=0;h<g;h++)n[h]^=1549556828,j[h]^=909522486;p.sigBytes=b.sigBytes=k;this.reset()},reset:function(){var e=this._hasher;e.reset();e.update(this._iKey)},update:function(e){this._hasher.update(e);return this},finalize:function(e){var d=this._hasher;e=d.finalize(e);d.reset();return d.finalize(this._oKey.clone().concat(e))}})})();;(function(exports){'use strict';var inProgress=false;var LinkActionHandler={onClick:function lah_onClick(event){var dataset=event.target.dataset;var action=dataset.action;var type;event.preventDefault();if(!action){return;}
if(inProgress){return;}
inProgress=true;type=action.replace('-link','');ActivityPicker[type](dataset[type],this.reset,this.reset);},reset:function lah_reset(){inProgress=false;}};exports.LinkActionHandler=LinkActionHandler;}(this));;'use strict';var MessageDB=(function(){var DB_NAME='wappush';var DB_VERSION=1;var MESSAGE_STORE_NAME='message';var KEY_PATH='timestamp';var ID_INDEX='id';var ID_INDEX_KEYPATH='id';var db=null;function mdb_open(success,error){if(db){success(db);return;}
var indexedDB;try{indexedDB=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;}catch(e){error(e);return;}
if(!indexedDB){error('IndexedDB is not available');return;}
var req;try{req=indexedDB.open(DB_NAME,DB_VERSION);}catch(e){error(e.message);return;}
req.onsuccess=function mdb_opened(event){db=event.target.result;success(db);};req.onerror=function mdb_openError(event){error(event.target.error.name);};req.onupgradeneeded=function mdb_upgradeNeeded(event){var db=event.target.result;if(event.oldVersion===0){var store=db.createObjectStore(MESSAGE_STORE_NAME,{keyPath:KEY_PATH});store.createIndex(ID_INDEX,ID_INDEX_KEYPATH,{unique:false});}};}
function mdb_processMessage(store,message,status,error){if(message.action==='delete'){mdb_deleteById(store,message.id,error);status='discarded';}else{store.put(message);}
return status;}
function mdb_put(message,success,error){mdb_open(function mdb_putCallback(db){var status='new';var transaction=db.transaction(MESSAGE_STORE_NAME,'readwrite');transaction.oncomplete=function mdb_putComplete(event){success(status);};transaction.onerror=function mdb_putError(event){error(event.target.error.name);};var store=transaction.objectStore(MESSAGE_STORE_NAME);if(!message.id){store.put(message);return;}
if(!message.created){status=mdb_processMessage(store,message,status,error);return;}
var index=store.index(ID_INDEX);var req=index.openCursor(IDBKeyRange.only(message.id));req.onsuccess=function mdb_cursorSuccess(event){var cursor=event.target.result;if(cursor){var storedMessage=cursor.value;if(storedMessage.created){if(storedMessage.created<message.created){cursor.delete(storedMessage);status=mdb_processMessage(store,message,'updated',error);}else{status='discarded';}
return;}
cursor.continue();}else{status=mdb_processMessage(store,message,status,error);}};},error);}
function mdb_deleteById(store,id,error){var index=store.index(ID_INDEX);var req=index.openCursor(id);req.onsuccess=function mdb_openCursorSuccess(event){var cursor=event.target.result;if(cursor){cursor.delete();cursor.continue();}};req.onerror=function mdb_openCursorError(event){error(event.target.error.name);};}
function mdb_retrieve(timestamp,success,error){mdb_open(function mdb_retrieveCallback(db){var state={message:null};var transaction=db.transaction(MESSAGE_STORE_NAME,'readwrite');transaction.oncomplete=function mdb_retrieveComplete(){success(state.message);};transaction.onerror=function mdb_retrieveError(event){error(event.target.error.name);};var store=transaction.objectStore(MESSAGE_STORE_NAME);var req=store.get(timestamp.toString());req.onsuccess=function mdb_gotMessage(event){if(event.target.result){var message=event.target.result;state.message=message;if(message.type!='text/vnd.wap.connectivity-xml'){store.delete(message.timestamp);}}};},error);}
function mdb_deleteByTimestamp(timestamp,success,error){mdb_open(function mdb_deleteCallback(db){var transaction=db.transaction(MESSAGE_STORE_NAME,'readwrite');transaction.oncomplete=function mdb_deleteComplete(){success();};transaction.onerror=function mdb_deleteError(event){error(event.target.error.name);};var store=transaction.objectStore(MESSAGE_STORE_NAME);store.delete(timestamp.toString());},error);}
function mdb_clear(success,error){mdb_open(function mdb_clearCallback(db){var transaction=db.transaction(MESSAGE_STORE_NAME,'readwrite');transaction.oncomplete=function mdb_clearComplete(){success();};transaction.onerror=function mdb_clearError(event){error(event.target.error.name);};var store=transaction.objectStore(MESSAGE_STORE_NAME);store.clear();},error);}
return{put:mdb_put,retrieve:mdb_retrieve,deleteByTimestamp:mdb_deleteByTimestamp,clear:mdb_clear};})();;(function(exports){'use strict';var CONTENT_TYPE='application/xml';var AUTHTYPE_MAPPING={'PAP':'1','CHAP':'2'};var TYPE_MAPPING={'w2':'default','w4':'mms'};function ParsedProvisioningDoc(provisioningDoc){this._provisioningDoc=provisioningDoc;this._applicationNodes=null;this._napDefNodes=null;this._pxLogicalNodes=null;this._apns=[],this._proxies=[];this._apnsReady=false;}
ParsedProvisioningDoc.prototype={getPxPhysicalNodes:function pd_getPxPhysicalNodes(toProxyNode){var toProxy=toProxyNode.getAttribute('value');var pxLogicalNode=null;for(var i=0;i<this._pxLogicalNodes.length;i++){var selector='parm[name="PROXY-ID"][value="'+toProxy+'"]';pxLogicalNode=this._pxLogicalNodes[i].querySelector(selector);if(pxLogicalNode){break;}}
if(!pxLogicalNode){return null;}
return this._pxLogicalNodes[i].querySelectorAll('characteristic[type="PXPHYSICAL"]');},getNapDefNode:function pd_getNapDefNode(toNapId){for(var i=0;i<this._napDefNodes.length;i++){var selector='parm[name="NAPID"][value="'+toNapId+'"]';var napDefNode=this._napDefNodes[i].querySelector(selector);if(napDefNode){return this._napDefNodes[i];}}
return null;},parse:function pd_parse(){if(!this._provisioningDoc){return;}
function parsePxPhysicalNode(pxPhysicalNode,isMmsProxy){var obj={};var proxyKey=null,portKey=null;proxyKey=isMmsProxy?'mmsproxy':'proxy';portKey=isMmsProxy?'mmsport':'port';var pxAddrNode=pxPhysicalNode.querySelector('parm[name="PXADDR"]');if(pxAddrNode){obj[proxyKey]=pxAddrNode.getAttribute('value');}
obj['TO-NAPID']=[];var toNapIdNode=pxPhysicalNode.querySelector('parm[name="TO-NAPID"]');if(toNapIdNode){obj['TO-NAPID'].push(toNapIdNode.getAttribute('value'));}
var portNodes=pxPhysicalNode.querySelectorAll('characteristic[type="PORT"]');for(var j=0;j<portNodes.length;j++){var portNode=portNodes[j].querySelector('parm[name="PORTNBR"]');obj[portKey]=portNode.getAttribute('value');}
return obj;}
function parseNapDefNode(napDefNode){var obj={};var napIdNode=napDefNode.querySelector('parm[name="NAPID"]');if(napIdNode){obj.NAPID=napIdNode.getAttribute('value');}
var nameNode=napDefNode.querySelector('parm[name="NAME"]');if(nameNode){obj.carrier=nameNode.getAttribute('value');}
var apnNode=napDefNode.querySelector('parm[name="NAP-ADDRESS"]');if(apnNode){obj.apn=apnNode.getAttribute('value');}
var napAuthInfoNode=napDefNode.querySelector('characteristic[type="NAPAUTHINFO"]');if(napAuthInfoNode){var authTypeNode=napAuthInfoNode.querySelector('parm[name="AUTHTYPE"]');if(authTypeNode){var authType=AUTHTYPE_MAPPING[authTypeNode.getAttribute('value')];if(authType){obj.authtype=authType;}}
var authNameNode=napAuthInfoNode.querySelector('parm[name="AUTHNAME"]');if(authNameNode){obj.user=authNameNode.getAttribute('value');}
var authSecretNode=napAuthInfoNode.querySelector('parm[name="AUTHSECRET"]');if(authSecretNode){obj.password=authSecretNode.getAttribute('value');}}
return obj;}
var parser=new DOMParser();var domDocument=parser.parseFromString(this._provisioningDoc,CONTENT_TYPE);this._applicationNodes=domDocument.querySelectorAll('characteristic[type="APPLICATION"]');this._napDefNodes=domDocument.querySelectorAll('characteristic[type="NAPDEF"]');this._pxLogicalNodes=domDocument.querySelectorAll('characteristic[type="PXLOGICAL"]');if(!this._applicationNodes){return;}
var napDefNode=null;var apn=null;var type=[];var proxy=null;var applicationNode=null;for(var j=0;j<this._applicationNodes.length;j++){applicationNode=this._applicationNodes[j];var appIdNode=null,appId=null;appIdNode=applicationNode.querySelector('parm[name="APPID"]');appId=appIdNode.getAttribute('value');var toProxyNodes=null;toProxyNodes=applicationNode.querySelectorAll('parm[name="TO-PROXY"]');var toNapIdNodes=null;toNapIdNodes=applicationNode.querySelectorAll('parm[name="TO-NAPID"]');var addrNode=null,addr=null;addrNode=applicationNode.querySelector('parm[name="ADDR"]');if(addrNode){addr=addrNode.getAttribute('value');}
if(appId&&(appId!=='w2')&&(appId!=='w4')){continue;}
if(!toNapIdNodes&&!toProxyNodes){continue;}
type=[];type.push(TYPE_MAPPING[appId]);if(toProxyNodes){for(var l=0;l<toProxyNodes.length;l++){var pxPhysicalNodes=this.getPxPhysicalNodes(toProxyNodes[l]);if(!pxPhysicalNodes){continue;}
for(var m=0;m<pxPhysicalNodes.length;m++){proxy=parsePxPhysicalNode(pxPhysicalNodes[m],(TYPE_MAPPING[appId]==='mms'));this._proxies.push(proxy);for(var n=0;n<proxy['TO-NAPID'].length;n++){napDefNode=this.getNapDefNode(proxy['TO-NAPID'][n]);apn=parseNapDefNode(napDefNode);apn.type=type;if((TYPE_MAPPING[appId]==='mms')&&addr){apn.mmsc=addr;}
this._apns.push(apn);}}}}
if(toNapIdNodes){for(var o=0;o<toNapIdNodes.length;o++){var toNapId=toNapIdNodes[o].getAttribute('value');if(!toNapId){continue;}
napDefNode=this.getNapDefNode(toNapId);apn=parseNapDefNode(napDefNode);apn.type=type;this._apns.push(apn);}}}},getApns:function ppd_getApns(){function addProperties(src,dst){for(var key in src){dst[key]=src[key];}}
if(this._apnsReady){return this._apns;}
for(var i=0;i<this._proxies.length;i++){var proxy=this._proxies[i];for(var j=0;j<proxy['TO-NAPID'].length;j++){var TO_NAPID=proxy['TO-NAPID'][j];for(var k=0;k<this._apns.length;k++){var apn=this._apns[k];if(TO_NAPID===apn.NAPID){addProperties(proxy,apn);break;}}}}
this._apnsReady=true;return this._apns;}};ParsedProvisioningDoc.from=function ppd_from(provisioningDoc){var obj=new ParsedProvisioningDoc(provisioningDoc);obj.parse();return obj;};exports.ParsedProvisioningDoc=ParsedProvisioningDoc;})(window);;(function(exports){'use strict';function ParsedMessage(obj){if(obj){for(var key in obj){this[key]=obj[key];}}}
ParsedMessage.prototype={constructor:ParsedMessage,toJSON:function pm_toJSON(){var obj={type:this.type,sender:this.sender,timestamp:this.timestamp};if(this.href){obj.href=this.href;}
if(this.id){obj.id=this.id;}
if(this.created){obj.created=this.created;}
if(this.expires){obj.expires=this.expires;}
if(this.text){obj.text=this.text;}
if(this.action){obj.action=this.action;}
if(this.provisioning){obj.provisioning=this.provisioning;}
return obj;},save:function pm_save(success,error){MessageDB.put(this.toJSON(),success,error);},isExpired:function pm_isExpired(){return(this.expires&&(this.expires<Date.now()));}};ParsedMessage.from=function pm_from(message,timestamp){var parser=new DOMParser();var doc=parser.parseFromString(message.content,'text/xml');var obj=new ParsedMessage();obj.type=message.contentType;obj.sender=message.sender;obj.timestamp=timestamp.toString();if(message.contentType==='text/vnd.wap.si'){var indicationNode=doc.querySelector('indication');if(indicationNode.hasAttribute('href')){obj.href=indicationNode.getAttribute('href');}
obj.text=indicationNode.textContent;if(indicationNode.hasAttribute('si-id')){obj.id=indicationNode.getAttribute('si-id');}else if(obj.href){obj.id=obj.href;}
if(indicationNode.hasAttribute('created')){var date=new Date(indicationNode.getAttribute('created'));obj.created=date.getTime();}
if(indicationNode.hasAttribute('si-expires')){var expiresDate=new Date(indicationNode.getAttribute('si-expires'));obj.expires=expiresDate.getTime();}
if(indicationNode.hasAttribute('action')){obj.action=indicationNode.getAttribute('action');}else{obj.action='signal-medium';}
if(obj.action==='delete'&&!obj.id){return null;}}else if(message.contentType==='text/vnd.wap.sl'){var slNode=doc.querySelector('sl');obj.href=slNode.getAttribute('href');if(slNode.hasAttribute('action')){obj.action=slNode.getAttribute('action');}else{obj.action='execute-low';}}else if(message.contentType==='text/vnd.wap.connectivity-xml'){obj.provisioning=Provisioning.fromMessage(message);if(!obj.provisioning.authInfo){return null;}
obj.text='cp-message-received';}else{return null;}
return obj;};ParsedMessage.load=function pm_load(timestamp,success,error){MessageDB.retrieve(timestamp,function pm_loadSuccess(message){if(message){success(new ParsedMessage(message));}else{success(null);}},error);};ParsedMessage.delete=function pm_delete(timestamp,success,error){MessageDB.deleteByTimestamp(timestamp,success,error);};exports.ParsedMessage=ParsedMessage;})(window);;(function(exports){'use strict';function Provisioning(obj){if(obj){for(var key in obj){this[key]=obj[key];}}}
Provisioning.fromMessage=function p_fromMessage(message){var obj=new Provisioning();obj.provisioningDoc=message.content;obj.authInfo=message.authInfo;return obj;};exports.Provisioning=Provisioning;})(window);;'use strict';var SiSlScreenHelper=(function(){var screen=null;var title=null;var container=null;var text=null;var link=null;function sssh_init(){title=document.getElementById('title');screen=document.getElementById('si-sl-screen');container=screen.querySelector('.container');text=container.querySelector('p');link=container.querySelector('a');link.addEventListener('click',LinkActionHandler.onClick.bind(LinkActionHandler));}
function sssh_populateScreen(message){var _=navigator.mozL10n.get;WapPushManager.setOnCloseCallback(sssh_onClose);screen.hidden=false;if(message&&!message.isExpired()){title.textContent=message.sender;text.textContent=message.text;link.textContent=message.href;link.href=message.href;link.dataset.url=message.href;}else{title.textContent=_('wap-push-message');text.textContent=_('this-message-has-expired');link.textContent='';link.href='';link.dataset.url='';}}
function sssh_onClose(){WapPushManager.close();}
return{init:sssh_init,populateScreen:sssh_populateScreen};})();;'use strict';var StoreProvisioning=(function(){var CP_APN_KEY='ril.data.cp.apns';var MCC_KEY='operatorvariant.mcc';var MNC_KEY='operatorvariant.mnc';var mccMncCodes={mcc:'000',mnc:'00'};function sp_getMccMncCodes(callback){var settings=navigator.mozSettings;if(!settings){if(callback){callback();}
return;}
var iccCardIndex=0;var transaction=navigator.mozSettings.createLock();var mccRequest=transaction.get(MCC_KEY);mccRequest.onsuccess=function(){var mccs=mccRequest.result[MCC_KEY];if(!mccs||!Array.isArray(mccs)||!mccs[iccCardIndex]){mccMncCodes.mcc='000';}else{mccMncCodes.mcc=mccs[iccCardIndex];}
var mncRequest=transaction.get(MNC_KEY);mncRequest.onsuccess=function(){var mncs=mncRequest.result[MNC_KEY];if(!mncs||!Array.isArray(mncs)||!mncs[iccCardIndex]){mccMncCodes.mnc='00';}else{mccMncCodes.mnc=mncs[iccCardIndex];}
if(callback){callback(mccMncCodes.mcc,mccMncCodes.mnc);}};};}
function sp_provision(parameters,callback){var existingApns=null;var newApns={};var settings=navigator.mozSettings;if(!settings){if(callback){callback();}
return;}
sp_getMccMncCodes(function sp_getMccMncCodesCb(){var transaction=navigator.mozSettings.createLock();var load=transaction.get(CP_APN_KEY);load.onsuccess=function onsuccessCb(){existingApns=load.result[CP_APN_KEY];var data={},mcc=mccMncCodes.mcc,mnc=mccMncCodes.mnc;if(!existingApns){newApns[mcc]={};newApns[mcc][mnc]=parameters;data[CP_APN_KEY]=newApns;}else{if(!existingApns[mcc]){existingApns[mcc]={};}
if(!existingApns[mcc][mnc]){existingApns[mcc][mnc]=[];}
existingApns[mcc][mnc]=existingApns[mcc][mnc].concat(parameters);data[CP_APN_KEY]=existingApns;}
transaction.set(data);if(callback){callback();}};load.onerror=function onerrorCb(){if(callback){callback();}};});}
return{getMccMncCodes:sp_getMccMncCodes,provision:sp_provision};})();;(function(exports){'use strict';var Utils={deserializeParameters:function ut_deserializeParameters(input){var rparams=/([^?=&]+)(?:=([^&]*))?/g;var parsed={};input.replace(rparams,function($0,$1,$2){parsed[$1]=decodeURIComponent($2);});return parsed;}};exports.Utils=Utils;}(this));;(function(exports){'use strict';window.addEventListener('localized',function localized(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;});var WapPushManager={init:wpm_init,close:wpm_close,displayWapPushMessage:wpm_displayWapPushMessage,onVisibilityChange:wpm_onVisibilityChange,setOnCloseCallback:wpm_setOnCloseCallback,clearNotifications:wpm_clearNotifications};var wapPushEnableKey='wap.push.enabled';var wapPushEnabled=true;var closeButton=null;var onCloseCallback=null;var closeTimeout=null;var pendingMessages=0;function wpm_init(done){if('mozSettings'in navigator){var req=navigator.mozSettings.createLock().get(wapPushEnableKey);req.onsuccess=function wpm_settingsLockSuccess(){wapPushEnabled=req.result[wapPushEnableKey];window.navigator.mozSetMessageHandler('wappush-received',wpm_onWapPushReceived);if(typeof done==='function'){done();}};navigator.mozSettings.addObserver(wapPushEnableKey,wpm_onSettingsChange);}
closeButton=document.getElementById('close');SiSlScreenHelper.init();CpScreenHelper.init();closeButton.addEventListener('click',wpm_onClose);document.addEventListener('visibilitychange',wpm_onVisibilityChange);window.navigator.mozSetMessageHandler('notification',wpm_onNotification);}
function wpm_onSettingsChange(v){wapPushEnabled=v.settingValue;}
function wpm_onVisibilityChange(){if(document.hidden){wpm_close();}else{window.clearTimeout(closeTimeout);closeTimeout=null;}}
function wpm_shouldDisplayMessage(message){if(!wapPushEnabled||(message===null)){return false;}
if((message.type!=='text/vnd.wap.connectivity-xml')&&(!WhiteList.has(message.sender)||message.isExpired())){return false;}
return true;}
function wpm_onWapPushReceived(wapMessage){pendingMessages++;var message=ParsedMessage.from(wapMessage,Date.now());if(!wpm_shouldDisplayMessage(message)){wpm_finish();return;}
message.save(function wpm_saveSuccess(status){if(status==='discarded'){wpm_finish();return;}
var req=navigator.mozApps.getSelf();req.onsuccess=function wpm_gotApp(event){var _=navigator.mozL10n.get;var app=event.target.result;var iconURL=NotificationHelper.getIconURI(app);message.text=(message.type=='text/vnd.wap.connectivity-xml')?_(message.text):message.text;var text=message.text?(message.text+' '):'';text+=message.href?message.href:'';var options={icon:iconURL,body:text,tag:message.timestamp};var notification=new Notification(message.sender,options);notification.addEventListener('click',function wpm_onNotificationClick(event){app.launch();wpm_displayWapPushMessage(event.target.tag);});wpm_finish();};req.onerror=function wpm_getAppError(){wpm_finish();};},function wpm_saveError(error){console.log('Could not add a message to the database: '+error+'\n');wpm_finish();});}
function wpm_onNotification(message){if(!message.clicked){return;}
window.clearTimeout(closeTimeout);closeTimeout=null;navigator.mozApps.getSelf().onsuccess=function wpm_gotApp(event){var app=event.target.result;app.launch();wpm_displayWapPushMessage(message.tag);};}
function wpm_displayWapPushMessage(timestamp){ParsedMessage.load(timestamp,function wpm_loadSuccess(message){if(message){switch(message.type){case'text/vnd.wap.si':case'text/vnd.wap.sl':SiSlScreenHelper.populateScreen(message);wpm_clearNotifications(timestamp);break;case'text/vnd.wap.connectivity-xml':CpScreenHelper.populateScreen(message);break;}}else{SiSlScreenHelper.populateScreen();wpm_clearNotifications(timestamp);}},function wpm_loadError(error){console.log('Could not retrieve the message:'+error+'\n');});}
function wpm_clearNotifications(tag){Notification.get({tag:tag}).then(function onSuccess(notifications){for(var i=0;i<notifications.length;i++){notifications[i].close();}},function onError(reason){console.error('Notification.get() promise error: '+reason);});}
function wpm_finish(){pendingMessages--;if(document.hidden){wpm_close();}}
function wpm_close(){if(closeTimeout!==null){return;}
closeTimeout=window.setTimeout(function wpm_delayedClose(){if(pendingMessages>0){closeTimeout=window.setTimeout(wpm_delayedClose,100);return;}
closeTimeout=null;window.close();},100);}
function wpm_onClose(){if(onCloseCallback&&(typeof onCloseCallback==='function')){onCloseCallback();}}
function wpm_setOnCloseCallback(callback){onCloseCallback=callback;}
exports.WapPushManager=WapPushManager;})(this);;'use strict';var WhiteList={_whiteList:[],init:function wl_init(){var xhr=new XMLHttpRequest();xhr.overrideMimeType('application/json');xhr.open('GET','js/whitelist.json',true);xhr.send(null);xhr.onreadystatechange=(function wl_load(evt){if(xhr.readyState!==4){return;}
if(xhr.status===0||xhr.status===200){var list=JSON.parse(xhr.responseText);var whiteList=[];list.forEach(function wl_addTo(item){whiteList.push(item);});this._whiteList=whiteList;}}).bind(this);},has:function wl_has(value){if(this._whiteList.length===0){return true;}
return(this._whiteList.indexOf(value)!==-1);}};WhiteList.init();;'use strict';window.addEventListener('load',function callSetup(evt){window.removeEventListener('load',callSetup);WapPushManager.init();});