;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';(function(){var loader=LazyLoader;window.LazyL10n={_inDOM:false,_loaded:false,get:function ll10n_get(callback){if(this._loaded){callback(navigator.mozL10n.get);return;}
if(this._inDOM){this._waitForLoadAndDate(callback);return;}
loader.load(['/shared/js/l10n.js']);this._waitForLoadAndDate(function baseLoaded(){callback(navigator.mozL10n.get);});this._inDOM=true;},_waitForLoadAndDate:function ll10n_waitForLoadAndDate(callback){var finalize=this._finalize.bind(this);window.addEventListener('localized',function onLocalized(){window.removeEventListener('localized',onLocalized);loader.load('/shared/js/l10n_date.js',function(){finalize(callback);});});},_finalize:function ll10n_finalize(callback){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;this._loaded=true;callback(navigator.mozL10n.get);}};}());;'use strict';window.addEventListener('load',function dialerSetup(){window.removeEventListener('load',dialerSetup);KeypadManager.init();NavbarManager.init();setTimeout(function nextTick(){var lazyPanels=['add-contact-action-menu','confirmation-message','edit-mode','sim-picker'];var lazyPanelsElements=lazyPanels.map(function toElement(id){return document.getElementById(id);});LazyLoader.load(lazyPanelsElements);CallHandler.init();LazyL10n.get(function loadLazyFilesSet(){LazyLoader.load(['/shared/js/fb/fb_request.js','/shared/js/fb/fb_data_reader.js','/shared/js/fb/fb_reader_utils.js','/shared/style/confirm.css','/contacts/js/utilities/confirm.js','/dialer/js/newsletter_manager.js','/shared/style/edit_mode.css','/shared/style/headers.css']);lazyPanelsElements.forEach(navigator.mozL10n.translate);});});});;'use strict';var Utils={prettyDate:function ut_prettyDate(time){var _=navigator.mozL10n.get;var dtf=new navigator.mozL10n.DateTimeFormat();return dtf.localeFormat(new Date(time),_('shortTimeFormat'));},headerDate:function ut_headerDate(time){var _=navigator.mozL10n.get;var dtf=new navigator.mozL10n.DateTimeFormat();var today=_('today');var yesterday=_('yesterday');var diff=(Date.now()-time)/1000;var day_diff=Math.floor(diff/86400);if(isNaN(day_diff))
return'(incorrect date)';if(day_diff<0||diff<0){return dtf.localeFormat(new Date(time),_('shortDateTimeFormat'));}
return day_diff==0&&today||day_diff==1&&yesterday||day_diff<6&&dtf.localeFormat(new Date(time),'%A')||dtf.localeFormat(new Date(time),'%x');},getDayDate:function re_getDayDate(timestamp){var date=new Date(timestamp);var startDate=new Date(date.getFullYear(),date.getMonth(),date.getDate());return startDate.getTime();},getPhoneNumberPrimaryInfo:function ut_getPhoneNumberPrimaryInfo(matchingTel,contact){if(contact){if(contact.name&&contact.name.length&&contact.name[0]!==''){return contact.name;}else if(contact.org&&contact.org.length&&contact.org[0]!==''){return contact.org;}}
if(matchingTel){return matchingTel.value;}
return null;},toCamelCase:function ut_toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});},getPhoneNumberAdditionalInfo:function ut_getPhoneNumberAdditionalInfo(matchingTel){var number=matchingTel.number||matchingTel.value;if(!number){return;}
var carrier=matchingTel.carrier;var type=matchingTel.type;if(Array.isArray(type)){type=type[0];}
var _=navigator.mozL10n.get;var result=type?_(type):_('mobile');result=result?result:type;if(carrier){result+=', '+carrier;}else{result+=', '+number;}
return result;},addEllipsis:function ut_addEllipsis(view,fakeView,ellipsisSide){var side=ellipsisSide||'begin';LazyL10n.get(function localized(_){var localizedSide;if(navigator.mozL10n.language.direction==='rtl'){localizedSide=(side==='begin'?'right':'left');}else{localizedSide=(side==='begin'?'left':'right');}
var computedStyle=window.getComputedStyle(view,null);var currentFontSize=parseInt(computedStyle.getPropertyValue('font-size'));var viewWidth=view.getBoundingClientRect().width;fakeView.style.fontSize=currentFontSize+'px';fakeView.style.fontWeight=computedStyle.getPropertyValue('font-weight');fakeView.innerHTML=view.value?view.value:view.innerHTML;var value=fakeView.innerHTML;var counter=value.length-
(viewWidth*(fakeView.textContent.length/fakeView.getBoundingClientRect().width));var newPhoneNumber;while(fakeView.getBoundingClientRect().width>viewWidth){if(localizedSide=='left'){newPhoneNumber='\u2026'+value.substr(-value.length+counter);}else if(localizedSide=='right'){newPhoneNumber=value.substr(0,value.length-counter)+'\u2026';}
fakeView.innerHTML=newPhoneNumber;counter++;}
if(newPhoneNumber){if(view.value){view.value=newPhoneNumber;}else{view.innerHTML=newPhoneNumber;}}});},getNextFontSize:function ut_getNextFontSize(view,fakeView,maxFontSize,minFontSize,fontStep){var computedStyle=window.getComputedStyle(view,null);var fontSize=parseInt(computedStyle.getPropertyValue('font-size'));var viewWidth=view.getBoundingClientRect().width;var viewHeight=view.getBoundingClientRect().height;fakeView.style.fontSize=fontSize+'px';fakeView.innerHTML=(view.value?view.value:view.innerHTML);var rect=fakeView.getBoundingClientRect();while((rect.width<viewWidth)&&(fontSize<maxFontSize)){fontSize=Math.min(fontSize+fontStep,maxFontSize);fakeView.style.fontSize=fontSize+'px';rect=fakeView.getBoundingClientRect();}
while((rect.width>viewWidth)&&(fontSize>minFontSize)){fontSize=Math.max(fontSize-fontStep,minFontSize);fakeView.style.fontSize=fontSize+'px';rect=fakeView.getBoundingClientRect();}
return fontSize;}};;'use strict';const kMasterVolume=0.5;const kToneVolume=0.7;const kShortPressDuration=0.15;const kAttackDuration=0.025;const kDecayDuration=0.025;const kReleaseDuration=0.05;var TonePlayer={_audioElement:null,_audioContext:null,_gainNode:null,_playingNodes:[],_tonesSamples:{'/shared/resources/media/tones/tone_1.opus':[697,1209],'/shared/resources/media/tones/tone_2.opus':[697,1336],'/shared/resources/media/tones/tone_3.opus':[697,1477],'/shared/resources/media/tones/tone_4.opus':[770,1209],'/shared/resources/media/tones/tone_5.opus':[770,1336],'/shared/resources/media/tones/tone_6.opus':[770,1477],'/shared/resources/media/tones/tone_7.opus':[852,1209],'/shared/resources/media/tones/tone_8.opus':[852,1336],'/shared/resources/media/tones/tone_9.opus':[852,1477],'/shared/resources/media/tones/tone_star.opus':[941,1209],'/shared/resources/media/tones/tone_0.opus':[941,1336],'/shared/resources/media/tones/tone_hash.opus':[941,1477]},init:function tp_init(channel){this.setChannel(channel);},ensureAudio:function tp_ensureAudio(){if(this._audioContext){return;}
this._audioContext=new AudioContext(this._channel);},trashAudio:function tp_trashAudio(){this.stop();if(this._channel==='telephony'&&this._audioContext){this._audioContext.mozAudioChannelType='normal';}
this._audioContext=null;this._channel=null;},dummySound:function tp_dummySound(callback){var context=this._audioContext;var gainNode=context.createGain();gainNode.gain.value=0.001;gainNode.connect(context.destination);var oscNode=context.createOscillator();oscNode.type='sine';oscNode.frequency.value=1000;oscNode.start(0);oscNode.stop(0.005);oscNode.connect(gainNode);setTimeout(callback);},_playSample:function tp_playSample(frequencies){if(!this._audioElement){this._audioElement=new Audio();}
var sample=this._audioElement;for(var i in this._tonesSamples){if((frequencies.length===2)&&(frequencies[0]===this._tonesSamples[i][0])&&(frequencies[1]===this._tonesSamples[i][1])){sample.src=i;break;}}
sample.volume=kMasterVolume;sample.play();},_startAt:function tp_startAt(frequencies,when,duration){var context=this._audioContext;var sampleRate=context.sampleRate;var envelope=context.createBuffer(1,(duration?duration:0.05)*sampleRate,sampleRate);for(var i=0;i<envelope.length;i++){var factor=kToneVolume;var t=i/sampleRate;if(t<=kAttackDuration){factor=t/kAttackDuration;}else if(t-kAttackDuration<=kDecayDuration){factor=1.0-(1.0-kToneVolume)*(t-kAttackDuration)/kDecayDuration;}
if(!duration){factor-=kToneVolume;}else if(t>duration-kReleaseDuration){factor*=(duration-t)/kReleaseDuration;}
envelope.getChannelData(0)[i]=factor*kMasterVolume;}
var gainNode=context.createGain();gainNode.connect(context.destination);if(!duration){this._gainNode=gainNode;}
var envelopeNode=context.createBufferSource();envelopeNode.buffer=envelope;envelopeNode.start(when);envelopeNode.connect(gainNode.gain);gainNode.gain.setValueAtTime(duration?0.0:kToneVolume*kMasterVolume,0.0);for(i=0;i<frequencies.length;++i){var oscNode=this._audioContext.createOscillator();oscNode.type='sine';oscNode.frequency.value=frequencies[i];oscNode.start(when);if(duration){oscNode.stop(Math.max(when,context.currentTime+0.5)+duration);}else{this._playingNodes.push(oscNode);}
oscNode.connect(gainNode);}},start:function tp_start(frequencies,shortPress){if(shortPress){this._playSample(frequencies);}else{this._startAt(frequencies,0,shortPress?kShortPressDuration:0);}},stop:function tp_stop(){if(!this._gainNode){return;}
var context=this._audioContext;var sampleRate=context.sampleRate;var gain=this._gainNode.gain;this._gainNode=null;var ramp=context.createBuffer(1,kReleaseDuration*sampleRate,sampleRate);for(var i=0;i<ramp.length;i++){ramp.getChannelData(0)[i]=(ramp.length-i-1)/ramp.length*kToneVolume*kMasterVolume;}
var rampNode=context.createBufferSource();rampNode.buffer=ramp;rampNode.start();rampNode.connect(gain);gain.setValueAtTime(0.0,0.0);while(this._playingNodes.length){this._playingNodes.pop().stop(context.currentTime+kReleaseDuration+0.5);}},playSequence:function tp_playSequence(sequence){this.ensureAudio();this.dummySound((function(){var when=this._audioContext.currentTime+0.2;for(var index=0;index<sequence.length;++index){var step=sequence[index];var frequencies=step.slice(0,2);var duration=step[2]/1000;this._startAt(frequencies,when,duration);when+=duration;}}).bind(this));},_channel:null,setChannel:function tp_setChannel(channel){if(!channel||this._channel===channel){return;}
this.trashAudio();this._channel=channel;this.ensureAudio();}};;'use strict';var kFontStep=4;var gTonesFrequencies={'1':[697,1209],'2':[697,1336],'3':[697,1477],'4':[770,1209],'5':[770,1336],'6':[770,1477],'7':[852,1209],'8':[852,1336],'9':[852,1477],'*':[941,1209],'0':[941,1336],'#':[941,1477]};function DtmfTone(tone,short,serviceId){this.tone=tone;this.short=short;this.serviceId=serviceId;this.timer=0;}
DtmfTone.prototype={play:function dt_play(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);navigator.mozTelephony.startTone(this.tone,this.serviceId);if(this.short){this.timer=window.setTimeout(function dt_stopTone(serviceId){navigator.mozTelephony.stopTone(serviceId);},DtmfTone.kShortToneLength,this.serviceId);}},stop:function dt_stop(){clearTimeout(this.timer);navigator.mozTelephony.stopTone(this.serviceId);}};DtmfTone.kShortToneLength=120;var KeypadManager={_MAX_FONT_SIZE_DIAL_PAD:18,_MAX_FONT_SIZE_ON_CALL:16,_phoneNumber:'',_onCall:false,_keypadSoundIsEnabled:false,_shortTone:false,onValueChanged:null,get phoneNumberView(){delete this.phoneNumberView;return this.phoneNumberView=document.getElementById('phone-number-view');},get fakePhoneNumberView(){delete this.fakePhoneNumberView;return this.fakePhoneNumberView=document.getElementById('fake-phone-number-view');},get phoneNumberViewContainer(){delete this.phoneNumberViewContainer;return this.phoneNumberViewContainer=document.getElementById('phone-number-view-container');},get keypad(){delete this.keypad;return this.keypad=document.getElementById('keypad');},get callBar(){delete this.callBar;return this.callBar=document.getElementById('keypad-callbar');},get hideBar(){delete this.hideBar;return this.hideBar=document.getElementById('keypad-hidebar');},get callBarAddContact(){delete this.callBarAddContact;return this.callBarAddContact=document.getElementById('keypad-callbar-add-contact');},get callBarCallAction(){delete this.callBarCallAction;return this.callBarCallAction=document.getElementById('keypad-callbar-call-action');},get callBarCancelAction(){delete this.callBarCancelAction;return this.callBarCancelAction=document.getElementById('keypad-callbar-cancel');},get deleteButton(){delete this.deleteButton;return this.deleteButton=document.getElementById('keypad-delete');},get hideBarHangUpAction(){delete this.hideBarHangUpAction;return this.hideBarHangUpAction=document.getElementById('keypad-hidebar-hang-up-action-wrapper');},get hideBarHideAction(){delete this.hideBarHideAction;return this.hideBarHideAction=document.getElementById('keypad-hidebar-hide-keypad-action');},multiSimActionButton:null,init:function kh_init(oncall){this._onCall=!!oncall;var defaultFontSize=window.getComputedStyle(document.body,null).getPropertyValue('font-size');this.minFontSize=parseInt(parseInt(defaultFontSize)*10*0.226);this.maxFontSize=this._onCall?parseInt(parseInt(defaultFontSize)*this._MAX_FONT_SIZE_ON_CALL*0.226):parseInt(parseInt(defaultFontSize)*this._MAX_FONT_SIZE_DIAL_PAD*0.226);this.phoneNumberView.value='';this._phoneNumber='';var keyHandler=this.keyHandler.bind(this);this.keypad.addEventListener('touchstart',keyHandler,true);this.keypad.addEventListener('touchend',keyHandler,true);this.keypad.addEventListener('touchmove',keyHandler,true);this.deleteButton.addEventListener('touchstart',keyHandler);this.deleteButton.addEventListener('touchend',keyHandler);if(this.callBarAddContact){this.callBarAddContact.addEventListener('click',this.addContact.bind(this));}
if(this.callBarCallAction){if(typeof MultiSimActionButton!=='undefined'){if(navigator.mozMobileConnections&&navigator.mozMobileConnections.length>1){var self=this;LazyL10n.get(function localized(_){self.multiSimActionButton=new MultiSimActionButton(self.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',self.phoneNumber.bind(self));});}else{this.multiSimActionButton=new MultiSimActionButton(this.callBarCallAction,CallHandler.call,'ril.telephony.defaultServiceId',this.phoneNumber.bind(this));}}
this.callBarCallAction.addEventListener('click',this.fetchLastCalled.bind(this));}
if(this.callBarCancelAction){this.callBarCancelAction.addEventListener('click',function(){window.parent.LockScreen.switchPanel();});}
if(this.hideBarHideAction){this.hideBarHideAction.addEventListener('click',this.callbarBackAction);}
if(this.hideBarHangUpAction){this.hideBarHangUpAction.addEventListener('click',this.hangUpCallFromKeypad);}
TonePlayer.init('normal');var channel=this._onCall?'telephony':'normal';window.addEventListener('visibilitychange',(function(){TonePlayer.setChannel(document.mozHidden?'normal':channel);}).bind(this));this.render();LazyLoader.load(['/shared/style/action_menu.css','/dialer/js/suggestion_bar.js']);this._observePreferences();},moveCaretToEnd:function hk_util_moveCaretToEnd(el){if(typeof el.selectionStart=='number'){el.selectionStart=el.selectionEnd=el.value.length;}else if(typeof el.createTextRange!='undefined'){el.focus();var range=el.createTextRange();range.collapse(false);range.select();}},render:function hk_render(layoutType){if(layoutType=='oncall'){if(CallsHandler.activeCall){this._phoneNumber=CallsHandler.activeCall.call.number;}
this._isKeypadClicked=false;this.phoneNumberViewContainer.classList.add('keypad-visible');if(this.callBar){this.callBar.classList.add('hide');}
if(this.hideBar){this.hideBar.classList.remove('hide');}
this.deleteButton.classList.add('hide');}else{this.phoneNumberViewContainer.classList.remove('keypad-visible');if(this.callBar){this.callBar.classList.remove('hide');}
if(this.hideBar){this.hideBar.classList.add('hide');}
this.deleteButton.classList.remove('hide');}},phoneNumber:function hk_phoneNumber(){return this._phoneNumber;},fetchLastCalled:function hk_fetchLastCalled(){if(this._phoneNumber!==''){return;}
var self=this;CallLogDBManager.getGroupAtPosition(1,'lastEntryDate',true,'dialing',function hk_ggap_callback(result){if(result&&(typeof result==='object')&&result.number){self.updatePhoneNumber(result.number);}});},addContact:function hk_addContact(event){var number=this._phoneNumber;if(!number){return;}
LazyLoader.load(['/dialer/js/phone_action_menu.js'],function hk_showPhoneNumberActionMenu(){PhoneNumberActionMenu.show(null,number,['new-contact','add-to-existent']);});},callbarBackAction:function hk_callbarBackAction(event){CallScreen.hideKeypad();},hangUpCallFromKeypad:function hk_hangUpCallFromKeypad(event){CallScreen.body.classList.remove('showKeypad');CallsHandler.end();},formatPhoneNumber:function kh_formatPhoneNumber(ellipsisSide,maxFontSize){var fakeView=this.fakePhoneNumberView;var view=this.phoneNumberView;if(view.value===''){view.style.fontSize=this.maxFontSize;return;}
var newFontSize;if(maxFontSize){newFontSize=this.maxFontSize;}else{newFontSize=Utils.getNextFontSize(view,fakeView,this.maxFontSize,this.minFontSize,kFontStep);}
view.style.fontSize=newFontSize+'px';Utils.addEllipsis(view,fakeView,ellipsisSide);},_lastPressedKey:null,_dtmfTone:null,_playDtmfTone:function kh_playDtmfTone(key){var serviceId=0;if(!this._onCall){return;}
if(CallsHandler.activeCall){serviceId=CallsHandler.activeCall.call.serviceId;}else{serviceId=navigator.mozTelephony.active.calls[0].serviceId;}
if(this._dtmfTone){this._dtmfTone.stop();this._dtmfTone=null;}
this._dtmfTone=new DtmfTone(key,this._shortTone,serviceId);this._dtmfTone.play();},_stopDtmfTone:function kh_stopDtmfTone(){if(!this._dtmfTone){return;}
this._dtmfTone.stop();this._dtmfTone=null;},_touchStart:function kh_touchStart(key,voicemail){this._longPress=false;this._lastPressedKey=key;if(key!='delete'){if(this._keypadSoundIsEnabled){TonePlayer.start(gTonesFrequencies[key],!this._onCall||this._shortTone);}
this._playDtmfTone(key);}
if((key=='0'&&!this._onCall)||key=='delete'){this._holdTimer=setTimeout(function(self){if(key=='delete'){self._phoneNumber='';}else{var index=self._phoneNumber.length-1;if(index>=0&&self._phoneNumber[index]==='0'){self._phoneNumber=self._phoneNumber.substr(0,index);}
self._phoneNumber+='+';}
self._longPress=true;self._updatePhoneNumberView('begin',false);},400,this);}
if(voicemail){this._holdTimer=setTimeout(function vm_call(self){self._longPress=true;self._callVoicemail();},1500,this);}
if(key=='delete'){this._phoneNumber=this._phoneNumber.slice(0,-1);}else if(this.phoneNumberViewContainer.classList.contains('keypad-visible')){if(!this._isKeypadClicked){this._isKeypadClicked=true;this._phoneNumber=key;this.replaceAdditionalContactInfo('');}else{this._phoneNumber+=key;}}else{this._phoneNumber+=key;}
setTimeout(function(self){self._updatePhoneNumberView('begin',false);},0,this);},_touchMove:function kh_touchMove(touch){var target=document.elementFromPoint(touch.pageX,touch.pageY);var key=target.dataset?target.dataset.value:null;if(key!==this._lastPressedKey||key==='delete'){this._stopDtmfTone();this._lastPressedKey=null;}},_touchEnd:function kh_touchEnd(key){if(key!=='delete'&&key===this._lastPressedKey){this._stopDtmfTone();this._lastPressedKey=null;}
if(this._keypadSoundIsEnabled){TonePlayer.stop();}
if(this._longPress){this._longPress=false;this._holdTimer=null;return;}
if(this._holdTimer){clearTimeout(this._holdTimer);}},keyHandler:function kh_keyHandler(event){var key=event.target.dataset.value;if(!key){return;}
if(key==='#'&&this._phoneNumber==='*#06#'){this.multiSimActionButton.performAction();return;}
if(key!='delete'&&this._phoneNumber.length>=50&&!this._onCall){return;}
event.stopPropagation();switch(event.type){case'touchstart':this._touchStart(key,event.target.dataset.voicemail);break;case'touchmove':this._touchMove(event.touches[0]);break;case'touchend':this._touchEnd(key);break;}},sanitizePhoneNumber:function(number){return number.replace(/\s+/g,'');},updatePhoneNumber:function kh_updatePhoneNumber(number,ellipsisSide,maxFontSize){number=this.sanitizePhoneNumber(number);this._phoneNumber=number;this._updatePhoneNumberView(ellipsisSide,maxFontSize);},press:function(value){this._playDtmfTone(value);TonePlayer.start(gTonesFrequencies[value],true);setTimeout((function nextTick(){TonePlayer.stop();this._stopDtmfTone();}).bind(this));},_updatePhoneNumberView:function kh_updatePhoneNumberview(ellipsisSide,maxFontSize){var phoneNumber=this._phoneNumber;if(this._onCall){this.replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize);}else{var visibility;if(phoneNumber.length>0){visibility='visible';this.callBarAddContact.classList.remove('disabled');}else{visibility='hidden';this.callBarAddContact.classList.add('disabled');}
this.deleteButton.style.visibility=visibility;this.phoneNumberView.value=phoneNumber;this.moveCaretToEnd(this.phoneNumberView);this.formatPhoneNumber(ellipsisSide,maxFontSize);}
if(this.onValueChanged){this.onValueChanged(this._phoneNumber);}},replacePhoneNumber:function kh_replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.replacePhoneNumber(phoneNumber,ellipsisSide,maxFontSize);}},restorePhoneNumber:function kh_restorePhoneNumber(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restorePhoneNumber();}},replaceAdditionalContactInfo:function kh_updateAdditionalContactInfo(additionalContactInfo){var call=CallsHandler.activeCall;if(this._onCall&&call){call.replaceAdditionalContactInfo(additionalContactInfo);}},restoreAdditionalContactInfo:function kh_restoreAdditionalContactInfo(){if(this._onCall&&CallsHandler.activeCall){CallsHandler.activeCall.restoreAdditionalContactInfo();}},_callVoicemail:function(){if(navigator.mozIccManager.iccIds.length<=1){this._callVoicemailForSim(0);return;}
var self=this;var key='ril.voicemail.defaultServiceId';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function(){LazyLoader.load(['/shared/js/sim_picker.js'],function(){LazyL10n.get(function(_){SimPicker.getOrPick(req.result[key],_('voiceMail'),self._callVoicemailForSim);});});};},_callVoicemailForSim:function(cardIndex){var settings=navigator.mozSettings;if(!settings){return;}
var transaction=settings.createLock();var request=transaction.get('ril.iccInfo.mbdn');request.onsuccess=function(){var numbers=request.result['ril.iccInfo.mbdn'];var number;if(typeof numbers=='string'){number=numbers;}else{number=numbers&&numbers[cardIndex];}
var voicemail=navigator.mozVoicemail;if(!number&&voicemail){number=voicemail.getNumber();}
if(number){CallHandler.call(number,cardIndex);}};request.onerror=function(){};},_observePreferences:function kh_observePreferences(){var self=this;LazyLoader.load('/shared/js/settings_listener.js',function(){SettingsListener.observe('phone.ring.keypad',false,function(value){self._keypadSoundIsEnabled=!!value;});SettingsListener.observe('phone.dtmf.type',false,function(value){self._shortTone=(value==='short');});});}};;'use strict';var CallHandler=(function callHandler(){var COMMS_APP_ORIGIN=document.location.protocol+'//'+
document.location.host;var FB_SYNC_ERROR_PARAM='isSyncError';var screenState=null;function handleActivity(activity){if(activity.source.name!='dial')
return;var number=activity.source.data.number;if(number){KeypadManager.updatePhoneNumber(number,'begin',false);if(window.location.hash!='#keyboard-view'){window.location.hash='#keyboard-view';}}else{if(window.location.hash!='#contacts-view'){window.location.hash='#contacts-view';}}}
function deserializeParameters(input){var rparams=/([^?=&]+)(?:=([^&]*))?/g;var parsed={};input.replace(rparams,function($0,$1,$2){parsed[$1]=decodeURIComponent($2);});return parsed;}
function handleNotification(evt){if(!evt.clicked){return;}
navigator.mozApps.getSelf().onsuccess=function gotSelf(selfEvt){var app=selfEvt.target.result;app.launch('dialer');var location=document.createElement('a');location.href=evt.imageURL;if(location.search.indexOf(FB_SYNC_ERROR_PARAM)!==-1){window.location.hash='#contacts-view';}else if(location.search.indexOf('ussdMessage')!==-1){var params=deserializeParameters(evt.imageURL);Notification.get({tag:evt.tag}).then(function(notifications){for(var i=0;i<notifications.length;i++){notifications[i].close();}});MmiManager.handleMMIReceived(evt.body,true,params.cardIndex);}else{window.location.hash='#call-log-view';}};}
function sendNotification(number,serviceId){LazyLoader.load('/shared/js/dialer/utils.js',function(){Contacts.findByNumber(number,function lookup(contact,matchingTel){LazyL10n.get(function localized(_){var title;if(navigator.mozIccManager.iccIds.length>1){title=_('missedCallMultiSims',{n:serviceId+1});}else{title=_('missedCall');}
var body;if(!number){body=_('from-withheld-number');}else if(contact){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(primaryInfo){if(primaryInfo!==matchingTel.value){body=_('from-contact',{contact:primaryInfo});}else{body=_('from-number',{number:primaryInfo});}}else{body=_('from-withheld-number');}}else{body=_('from-number',{number:number});}
navigator.mozApps.getSelf().onsuccess=function getSelfCB(evt){var app=evt.target.result;var iconURL=NotificationHelper.getIconURI(app,'dialer');var clickCB=function(){app.launch('dialer');window.location.hash='#call-log-view';};var notification=new Notification(title,{body:body,icon:iconURL});notification.addEventListener('click',clickCB);};});});});}
function callEnded(data){var number=data.number;var direction=data.direction;var incoming=data.direction==='incoming';NavbarManager.ensureResources(function(){if(incoming&&!data.duration){sendNotification(number,data.serviceId);}
Voicemail.check(number,function(isVoicemailNumber){var entry={date:Date.now()-parseInt(data.duration),type:incoming?'incoming':'dialing',number:number,serviceId:data.serviceId,emergency:data.emergency||false,voicemail:isVoicemailNumber,status:(incoming&&data.duration>0)?'connected':null};CallLogDBManager.add(entry,function(logGroup){CallLog.appendGroup(logGroup);});});});}
function handleMessage(evt){if(evt.origin!==COMMS_APP_ORIGIN){return;}
var data=evt.data;if(!data.type){return;}
if(data.type==='contactsiframe'){handleContactsIframeRequest(data.message);}else if(data.type==='hide-navbar'){NavbarManager.hide();}else if(data.type==='show-navbar'){NavbarManager.show();}}
window.addEventListener('message',handleMessage);function handleContactsIframeRequest(message){switch(message){case'back':var contactsIframe=document.getElementById('iframe-contacts');contactsIframe.contentWindow.history.pushState(null,null,'/contacts/index.html');window.location.hash='#call-log-view';break;}}
function btCommandHandler(message){var command=message['command'];var isAtd=command.startsWith('ATD');if(command!=='BLDN'&&!isAtd){return;}
if(isAtd&&command[3]!=='>'){var phoneNumber=command.substring(3);CallHandler.call(phoneNumber);return;}
var position=isAtd?parseInt(command.substring(4),10):1;CallLogDBManager.getGroupAtPosition(position,'lastEntryDate',true,null,function(result){if(result&&(typeof result==='object')&&result.number){LazyLoader.load(['/shared/js/sim_settings_helper.js'],function(){SimSettingsHelper.getCardIndexFrom('outgoingCall',function(ci){if(ci===undefined||ci===null||ci==SimSettingsHelper.ALWAYS_ASK_OPTION_VALUE){ci=result.serviceId;}
CallHandler.call(result.number,ci);});});}else{console.log('Could not get the group at: '+position+'. Error: '+result);}});}
function call(number,cardIndex){if(MmiManager.isMMI(number,cardIndex)){if(number==='*#06#'){MmiManager.showImei();}else{MmiManager.send(number,cardIndex);}
KeypadManager.updatePhoneNumber('','begin',true);SuggestionBar.clear();return;}
var connected,disconnected;connected=disconnected=function clearPhoneView(){KeypadManager.updatePhoneNumber('','begin',true);};var error=function(){KeypadManager.updatePhoneNumber(number,'begin',true);};var oncall=function(){SuggestionBar.hideOverlay();SuggestionBar.clear();};LazyLoader.load(['/dialer/js/telephony_helper.js','/shared/js/sim_settings_helper.js'],function(){if(cardIndex===undefined){SimSettingsHelper.getCardIndexFrom('outgoingCall',function(ci){TelephonyHelper.call(number,ci,oncall,connected,disconnected,error);});}else{TelephonyHelper.call(number,cardIndex,oncall,connected,disconnected,error);}});}
function onUssdReceived(evt){var lock=null;var safetyId;function releaseWakeLock(){if(lock){lock.unlock();lock=null;clearTimeout(safetyId);}}
if(document.hidden){lock=navigator.requestWakeLock('high-priority');safetyId=setTimeout(releaseWakeLock,30000);document.addEventListener('visibilitychange',releaseWakeLock);}
if(document.hidden&&evt.sessionEnded){MmiManager.sendNotification(evt.message,evt.serviceId).then(releaseWakeLock);}else{MmiManager.handleMMIReceived(evt.message,evt.sessionEnded,evt.serviceId);}}
function init(){LazyLoader.load(['/shared/js/mobile_operator.js','/dialer/js/mmi.js','/dialer/js/mmi_ui.js','/shared/style/headers.css','/shared/style/input_areas.css','/shared/style/progress_activity.css','/dialer/style/mmi.css'],function(){if(window.navigator.mozSetMessageHandler){window.navigator.mozSetMessageHandler('telephony-call-ended',callEnded);window.navigator.mozSetMessageHandler('activity',handleActivity);window.navigator.mozSetMessageHandler('notification',handleNotification);window.navigator.mozSetMessageHandler('bluetooth-dialer-command',btCommandHandler);window.navigator.mozSetMessageHandler('ussd-received',onUssdReceived);}});LazyLoader.load('/shared/js/settings_listener.js',function(){SettingsListener.observe('lockscreen.locked',null,function(value){if(value){screenState='locked';}else{screenState='unlocked';}});});}
return{init:init,call:call};})();var NavbarManager={init:function nm_init(){this.update();var self=this;window.addEventListener('hashchange',function nm_hashChange(event){self.update();});var contacts=document.getElementById('option-contacts');contacts.addEventListener('click',this.contactsTabTap);},resourcesLoaded:false,ensureResources:function(cb){if(this.resourcesLoaded){if(cb&&typeof cb==='function'){cb();}
return;}
var self=this;LazyLoader.load(['/shared/js/async_storage.js','/shared/js/notification_helper.js','/shared/js/simple_phone_matcher.js','/shared/js/contact_photo_helper.js','/shared/js/dialer/contacts.js','/shared/js/dialer/voicemail.js','/dialer/js/call_log.js','/dialer/style/call_log.css'],function rs_loaded(){self.resourcesLoaded=true;if(cb&&typeof cb==='function'){cb();}});},update:function nm_update(){var recent=document.getElementById('option-recents');var contacts=document.getElementById('option-contacts');var keypad=document.getElementById('option-keypad');recent.classList.remove('toolbar-option-selected');contacts.classList.remove('toolbar-option-selected');keypad.classList.remove('toolbar-option-selected');var checkContactsTab=function(){var contactsIframe=document.getElementById('iframe-contacts');if(!contactsIframe)
return;var index=contactsIframe.src.indexOf('#add-parameters');if(index!=-1){contactsIframe.src=contactsIframe.src.substr(0,index);}};var destination=window.location.hash;switch(destination){case'#call-log-view':checkContactsTab();this.ensureResources(function(){recent.classList.add('toolbar-option-selected');CallLog.init();});break;case'#contacts-view':var frame=document.getElementById('iframe-contacts');if(!frame){var view=document.getElementById('iframe-contacts-container');frame=document.createElement('iframe');frame.src='/contacts/index.html';frame.id='iframe-contacts';frame.setAttribute('frameBorder','no');frame.classList.add('grid-wrapper');view.appendChild(frame);}
contacts.classList.add('toolbar-option-selected');break;case'#keyboard-view':checkContactsTab();keypad.classList.add('toolbar-option-selected');break;}},hide:function(){var views=document.getElementById('views');views.classList.add('hide-toolbar');},show:function(){var views=document.getElementById('views');views.classList.remove('hide-toolbar');},contactsTabTap:function(){if(window.location.hash!='#contacts-view'){return;}
var contactsIframe=document.getElementById('iframe-contacts');if(!contactsIframe){return;}
var forceHashChange=new Date().getTime();contactsIframe.src='/contacts/index.html#home?forceHashChange='+
forceHashChange;}};window.onresize=function(e){if(window.innerHeight<440){document.body.classList.add('with-keyboard');}else{document.body.classList.remove('with-keyboard');}};document.addEventListener('visibilitychange',function visibilitychanged(){if(!document.hidden){TonePlayer.ensureAudio();}else{TonePlayer.trashAudio();if(navigator.mozTelephony){navigator.mozTelephony.stopTone();}}});;'use strict';var CallLogDBManager={_db:null,_dbName:'dialerRecents',_dbRecentsStore:'dialerRecents',_dbGroupsStore:'dialerGroups',_dbVersion:5,_maxNumberOfGroups:200,_numberOfGroupsToDelete:30,_observers:{},set onupgradeneeded(callback){this._addObserver('upgradeneeded',callback);},set onupgradedone(callback){this._addObserver('upgradedone',callback);},set onupgradeprogress(callback){this._addObserver('upgradeprogress',callback);},_addObserver:function _addObserver(message,callback){if(!this._observers[message]){this._observers[message]=[];}
this._observers[message].push(callback);},_notifyObservers:function _notifyObservers(message,value){var observers=this._observers[message];if(!observers){return;}
for(var callback in observers){if(observers[callback]&&typeof observers[callback]==='function'){observers[callback](value);}}},_asyncReturn:function _asyncReturn(callback,result){if(callback&&callback instanceof Function){callback(result);}},_ensureDB:function ensureDB(callback){if(this._db){callback(null,this._db);return;}
LazyLoader.load(['/shared/js/dialer/utils.js','/shared/js/dialer/contacts.js'],(function(){try{var indexedDB=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;if(!indexedDB){callback('NO_INDEXED_DB_AVAILABLE',null);return;}
var self=this;var request=indexedDB.open(this._dbName,this._dbVersion);request.onsuccess=(function onsuccess(event){this._db=event.target.result;callback(null,this._db);}).bind(this);request.onerror=function onerror(event){callback(event.target.errorCode,null);};request.onblocked=function onblocked(){callback('DB_REQUEST_BLOCKED',null);};request.onupgradeneeded=function onupgradeneeded(event){self._notifyObservers('upgradeneeded');var db=event.target.result;var txn=event.target.transaction;var currentVersion=event.oldVersion;function update(currentVersion){var next=update.bind(self,currentVersion+1);switch(currentVersion){case 0:self._createSchema(db,next);break;case 1:self._upgradeSchemaVersion2(db,txn,next);break;case 2:self._upgradeSchemaVersion3(next);break;case 3:self._upgradeSchemaVersion4(db,txn,next);break;case 4:self._upgradeSchemaVersion5(next);break;case 5:self._notifyObservers('upgradedone');break;default:event.target.transaction.abort();break;}
currentVersion++;}
update(currentVersion);};}catch(ex){callback(ex.message,null);}}).bind(this));},_newTxn:function newTxn(txnType,objectStores,callback){if(!objectStores){objectStores=[this._dbGroupsStore];}
if(!Array.isArray(objectStores)){objectStores=[objectStores];}
this._ensureDB(function(error,db){if(error){callback(error);return;}
var txn=db.transaction(objectStores,txnType);var stores;if(objectStores.length===1){stores=txn.objectStore(objectStores[0]);}else{stores=[];for(var i=0;i<objectStores.length;i++){stores.push(txn.objectStore(objectStores[i]));}}
callback(null,txn,stores);});},close:function rbdm_close(){this._db.close();this._db=null;},_createSchema:function createSchema(db,next){var objStore=db.createObjectStore(this._dbRecentsStore,{keyPath:'date'});objStore.createIndex('number','number');next();},_upgradeSchemaVersion2:function upgradeSchemaVersion2(db,transaction,next){var groupsStore=db.createObjectStore(this._dbGroupsStore,{keyPath:'id'});var recentsStore=transaction.objectStore(this._dbRecentsStore);recentsStore.createIndex('groupId','groupId');next();},_upgradeSchemaVersion3:function upgradeSchemaVersion3(next){next();},_upgradeSchemaVersion4:function upgradeSchemaVersion4(db,transaction,next){var self=this;var waitForAsyncCall=0;var cursorDone=false;var groups={};var recentsCount=0;var groupCount=0;function onGroupsDone(){if(!cursorDone||waitForAsyncCall){return;}
if(groupCount==0){next();return;}
self._newTxn('readwrite',[self._dbGroupsStore],function(error,txn,store){if(error){console.log('Error upgrading the database '+error);return;}
for(var group in groups){store.put(groups[group]).onsuccess=function onsuccess(){groupCount--;if(groupCount==0){next();}};delete groups[group];}});}
function populateGroups(){var percent=parseInt(recentsCount*0.15);var countToProgressEvent=percent;var percent2=parseInt(recentsCount*0.25);var countToProgressEvent2=percent2;var progress=0;recentsStore.openCursor().onsuccess=function onsuccess(event){if(countToProgressEvent===0){countToProgressEvent=percent;progress+=10;self._notifyObservers('upgradeprogress',progress);}else{countToProgressEvent--;}
var cursor=event.target.result;if(!cursor){cursorDone=true;onGroupsDone();return;}
var record=cursor.value;var type='';var status;switch(record.type){case'incoming-connected':type='incoming';status='connected';break;case'incoming-refused':type='incoming';break;default:if(record.type&&record.type.indexOf('dialing')!=-1){type='dialing';}
break;}
var id=self._getGroupId({date:record.date,number:record.number,type:type,status:status});var date=new Date(record.date);var key=date.getDay()+date.getMonth()+date.getFullYear()+
record.number+type;if(status){key+=status;}
waitForAsyncCall++;Contacts.findByNumber(record.number,function(contact,matchingTel){if(countToProgressEvent2===0){countToProgressEvent2=percent2;progress+=10;self._notifyObservers('upgradeprogress',progress);}else{countToProgressEvent2--;}
if(key in groups){if(groups[key].lastEntryDate<=record.date){groups[key].lastEntryDate=record.date;}
groups[key].retryCount++;}else{var group={id:id,number:record.number,lastEntryDate:record.date,retryCount:1};if(contact&&contact!==null){group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){group.contactPhoto=photo;}
if(matchingTel){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)){primaryInfo=primaryInfo[0];}
group.contactPrimaryInfo=String(primaryInfo);if(Array.isArray(matchingTel.type)&&matchingTel.type[0]){group.contactMatchingTelType=String(matchingTel.type[0]);}
if(matchingTel.carrier){group.contactMatchingTelCarrier=String(matchingTel.carrier);}}}
groups[key]=group;groupCount++;}
waitForAsyncCall--;onGroupsDone();});cursor.continue();};}
var groupsStore=transaction.objectStore(self._dbGroupsStore);db.deleteObjectStore(self._dbGroupsStore);var groupsStore=db.createObjectStore(self._dbGroupsStore,{keyPath:'id'});groupsStore.createIndex('number','number');groupsStore.createIndex('contactId','contactId');groupsStore.createIndex('lastEntryDate','lastEntryDate');var recentsStore=transaction.objectStore(self._dbRecentsStore);recentsStore.count().onsuccess=function(event){recentsCount=event.target.result;populateGroups();};},_upgradeSchemaVersion5:function upgradeSchemaVersion5(next){next();},_getGroupId:function getGroupId(recentCall){var groupId=[Utils.getDayDate(recentCall.date),(recentCall.number||''),recentCall.type];if(recentCall.status&&recentCall.type==='incoming'){groupId.push(recentCall.status);}
return groupId;},_getGroupObject:function getGroupObject(group){if(!Array.isArray(group.id)||group.id.length<3){return null;}
var contact;if(group.contactId){contact={id:group.contactId,primaryInfo:group.contactPrimaryInfo,matchingTel:{number:group.id[1],type:group.contactMatchingTelType,carrier:group.contactMatchingTelCarrier},photo:group.contactPhoto};}
return{id:group.id.join('-'),date:group.id[0],number:group.id[1],serviceId:group.serviceId,type:group.id[2],status:group.id[3]||undefined,lastEntryDate:group.lastEntryDate,retryCount:group.retryCount,contact:contact,emergency:group.emergency,voicemail:group.voicemail};},_keepDbPrettyAndFit:function _keepDbPrettyAndFit(callback){var self=this;this._newTxn('readonly',this._dbGroupsStore,function(error,txn,store){if(error){return;}
var req=store.count();req.onsuccess=function(){var groupsToDelete=req.result-self._maxNumberOfGroups;if(groupsToDelete>0){groupsToDelete+=self._numberOfGroupsToDelete;var cursorReq=store.index('lastEntryDate').openCursor();cursorReq.onsuccess=function(){var cursor=cursorReq.result;if(!cursor||!groupsToDelete){if(callback&&callback instanceof Function){callback();}
return;}
groupsToDelete--;self.deleteGroup(null,cursor.value.id);cursor.continue();};}else if(callback&&callback instanceof Function){callback();}};});},add:function add(recentCall,callback){if(typeof recentCall!=='object'){callback('INVALID_CALL');return;}
var self=this;this._newTxn('readwrite',[this._dbRecentsStore,this._dbGroupsStore],function(error,txn,stores){if(error){self._asyncReturn(callback,error);return;}
var recentsStore=stores[0];var groupsStore=stores[1];var groupId=self._getGroupId(recentCall);groupsStore.get(groupId).onsuccess=function onsuccess(){var group=this.result;if(group){if(group.lastEntryDate<=recentCall.date){group.lastEntryDate=recentCall.date;group.serviceId=recentCall.serviceId;group.emergency=recentCall.emergency;group.voicemail=recentCall.voicemail;}
group.retryCount++;groupsStore.put(group).onsuccess=function onsuccess(){self._asyncReturn(callback,self._getGroupObject(group));};}else{group={id:groupId,number:recentCall.number,serviceId:recentCall.serviceId,lastEntryDate:recentCall.date,retryCount:1,emergency:recentCall.emergency,voicemail:recentCall.voicemail};Contacts.findByNumber(recentCall.number,function(contact,matchingTel){if(contact&&contact!==null){group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){group.contactPhoto=photo;}
if(matchingTel){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)){primaryInfo=primaryInfo[0];}
group.contactPrimaryInfo=String(primaryInfo);if(Array.isArray(matchingTel.type)&&matchingTel.type[0]){group.contactMatchingTelType=String(matchingTel.type[0]);}else{group.contactMatchingTelType=String(matchingTel.type);}
if(matchingTel.carrier){group.contactMatchingTelCarrier=String(matchingTel.carrier);}}}
self._newTxn('readwrite',[self._dbGroupsStore],function(error,txn,store){store.add(group).onsuccess=function onsuccess(){self._keepDbPrettyAndFit(function(){self._asyncReturn(callback,self._getGroupObject(group));});};});});}
recentCall.groupId=groupId;recentsStore.put(recentCall);};});},deleteGroup:function deleteGroup(group,groupId,callback){if(!groupId&&(!group||typeof group!=='object'||!group.date||!group.type)){callback('NOT_VALID_GROUP');return;}
var self=this;this._newTxn('readwrite',[this._dbGroupsStore,this._dbRecentsStore],function(error,txn,stores){if(error){self._asyncReturn(callback,error);return;}
var groupsStore=stores[0];var recentsStore=stores[1];if(!groupId){groupId=self._getGroupId(group);}
groupsStore.delete(groupId).onsuccess=function onsuccess(){var deleted=0;recentsStore.index('groupId').openCursor(groupId).onsuccess=function onsuccess(event){var cursor=event.target.result;if(cursor){cursor.delete();deleted++;cursor.continue();}else{self._asyncReturn(callback,deleted);}};};});},deleteGroupList:function deleteGroupList(groupList,callback,deletedCount){if(!deletedCount){deletedCount=0;}
var self=this;if(groupList.length>0){var itemToDelete=groupList.pop();if(typeof itemToDelete!=='object'){self._asyncReturn(callback,'INVALID_GROUP_IN_LIST');return;}
var ondeleted=function ondeleted(result){if(typeof result!=='number'){self._asyncReturn(callback,result);return;}
deletedCount+=result;self.deleteGroupList(groupList,callback,deletedCount);};self.deleteGroup(itemToDelete,null,ondeleted);}else{self._asyncReturn(callback,deletedCount);}},deleteAll:function deleteAll(callback){var self=this;this._newTxn('readwrite',[this._dbRecentsStore,this._dbGroupsStore],function(error,txn,stores){if(error){self._asyncReturn(callback,error);return;}
var recentsStore=stores[0];var groupsStore=stores[1];recentsStore.clear().onsuccess=function onsuccess(){groupsStore.clear().onsuccess=function onsuccess(){self._asyncReturn(callback);};};});},deleteDb:function deleteDb(callback){var indexedDB=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;if(!indexedDB){callback('NO_INDEXEDDB_AVAILABLE');return;}
if(this._db){this._db.close();}
var self=this;var req=indexedDB.deleteDatabase(this._dbName);req.onsuccess=function onsuccess(){self._asyncReturn(callback);};req.onerror=function onerror(){self._asyncReturn(callback,req.error.name);};},_getList:function getList(storeName,callback,sortedBy,prev,getCursor,limit){if(!callback||!callback instanceof Function){return;}
var self=this;this._newTxn('readonly',[storeName],function(error,txn,store){if(error){callback(error);return;}
var cursor=null;var direction=prev?'prev':'next';if(sortedBy&&sortedBy!==null){if(!store.indexNames.contains(sortedBy)&&sortedBy!='id'){callback('INVALID_SORTED_BY_KEY');txn.abort();return;}
cursor=store.index(sortedBy).openCursor(null,direction);}else{cursor=store.openCursor(null,direction);}
var result=[];cursor.onsuccess=function onsuccess(event){var item=event.target.result;if(item&&getCursor){if(storeName===self._dbGroupsStore){callback({value:self._getGroupObject(item.value),continue:function(){return item.continue();}});}else{callback(item);}
return;}
if(item&&(typeof limit==='undefined'||limit>0)){if(storeName===self._dbGroupsStore){result.push(self._getGroupObject(item.value));}else{result.push(item.value);}
if(limit){limit--;}
item.continue();}else{callback(result);}};cursor.onerror=function onerror(event){callback(event.target.error.name);};});},getRecentList:function getRecentList(callback,sortedBy,prev,getCursor,limit){this._getList(this._dbRecentsStore,callback,sortedBy,prev,getCursor,limit);},getGroupList:function getGroupList(callback,sortedBy,prev,getCursor,limit){if(sortedBy==='number'||sortedBy==='type'||sortedBy==='status'){sortedBy=null;}
this._getList(this._dbGroupsStore,callback,sortedBy,prev,getCursor,limit);},getGroupAtPosition:function rdbm_getGroupAtPosition(position,sortedBy,prev,type,callback){if(!callback||!callback instanceof Function){return;}
var self=this;this._newTxn('readonly',this._dbGroupsStore,function(error,txn,store){if(error){callback(error);return;}
try{var request=null;var direction=prev?'prev':'next';if(sortedBy&&sortedBy!==null){request=store.index(sortedBy).openCursor(null,direction);}else{request=store.openCursor(null,direction);}
var i=0;request.onsuccess=function(event){var cursor=event.target.result;if(!cursor){callback(null);return;}
var recentGroup=self._getGroupObject(cursor.value);var matched=!type||recentGroup.type.indexOf(type)!=-1;if(matched){i++;}
if(matched&&i==position){callback(recentGroup);}else{cursor.continue();}};request.onerror=function(event){callback(event.target.error.name);};}catch(e){callback(e);}});},getLastCall:function getLastCall(callback){if(!callback||!callback instanceof Function){return;}
this._newTxn('readonly',[this._dbRecentsStore],function(error,txn,store){if(error){callback(error);return;}
var cursor=store.openCursor(null,'prev');cursor.onsuccess=function onsuccess(event){var item=event.target.result;if(item&&item.value){callback(item.value);}else{callback(null);}};cursor.onerror=function onerror(event){callback(event.target.error.name);};});},_updateCacheRevision:function _updateCacheRevision(){Contacts.getRevision(function(contactsRevision){if(contactsRevision){window.asyncStorage.setItem('contactCacheRevision',contactsRevision);}});},updateGroupContactInfo:function updateGroupContactInfo(contact,matchingTel,callback){var self=this;this._newTxn('readwrite',[this._dbGroupsStore],function(error,txn,store){if(error){self._asyncReturn(callback,error);return;}
if(!contact){self._asyncReturn(callback,0);return;}
var count=0;var req=store.index('number').openCursor(IDBKeyRange.only(matchingTel.value));req.onsuccess=function onsuccess(event){var cursor=event.target.result;if(cursor&&cursor.value){var group=cursor.value;group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){group.contactPhoto=photo;}
if(matchingTel){var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)&&primaryInfo[0]){primaryInfo=primaryInfo[0];}
group.contactPrimaryInfo=String(primaryInfo);if(Array.isArray(matchingTel.type)&&matchingTel.type[0]){group.contactMatchingTelType=String(matchingTel.type[0]);}
if(matchingTel.carrier){group.contactMatchingTelCarrier=String(matchingTel.carrier);}}
cursor.update(group);count++;cursor.continue();}else{self._asyncReturn(callback,count);self._updateCacheRevision();}};req.onerror=function onerror(event){self._asyncReturn(callback,event.target.error.name);};});},removeGroupContactInfo:function removeGroupContactInfo(contactId,group,callback){if(!contactId&&!group){this._asyncReturn(callback,0);return;}
var self=this;this._newTxn('readwrite',[this._dbGroupsStore],function(error,txn,store){if(error){self._asyncReturn(callback,error);callback(error);return;}
var count=0;var req;if(contactId){req=store.index('contactId').openCursor(contactId);}else if(group){var groupId=self._getGroupId(group);req=store.openCursor(groupId);}
req.onsuccess=function onsuccess(event){var cursor=event.target.result;if(cursor){var group=cursor.value;if(group.contactId){delete group.contactId;}
if(group.contactPrimaryInfo){delete group.contactPrimaryInfo;}
if(group.contactMatchingTelType){delete group.contactMatchingTelType;}
if(group.contactMatchingTelCarrier){delete group.contactMatchingTelCarrier;}
if(group.contactPhoto){delete group.contactPhoto;}
cursor.update(group);count++;cursor.continue();}else{self._asyncReturn(callback,count);self._updateCacheRevision();}};req.onerror=function onerror(event){self._asyncReturn(callback,event.target.error.name);};});},invalidateContactsCache:function invalidateContactsCache(callback){var self=this;var waitForAsyncCall=0;var cursorDone=false;function onContactsUpdated(){if(!cursorDone||waitForAsyncCall){return;}
self._asyncReturn(callback);self._updateCacheRevision();}
this._newTxn('readonly',[this._dbGroupsStore],function(error,txn,store){if(error){self._asyncReturn(callback,error);return;}
var req=store.openCursor();req.onsuccess=function onsuccess(event){var cursor=event.target.result;if(!cursor){cursorDone=true;onContactsUpdated();return;}
var group=cursor.value;waitForAsyncCall++;Contacts.findByNumber(group.number,function(contact,matchingTel){var needsUpdate=false;if(!contact&&!matchingTel){if(group.contactId){needsUpdate=true;delete group.contactId;}
if(group.contactPhoto){needsUpdate=true;delete group.contactPhoto;}
if(group.contactPrimaryInfo){needsUpdate=true;delete group.contactPrimaryInfo;}
if(group.contactMatchingTelType){needsUpdate=true;delete group.contactMatchingTelType;}
if(group.contactMatchingTelCarrier){needsUpdate=true;delete group.contactMatchingTelCarrier;}}else{group.contactId=contact.id;var photo=ContactPhotoHelper.getThumbnail(contact);if(photo&&group.contactPhoto!=photo){group.contactPhoto=photo;needsUpdate=true;}
var primaryInfo=Utils.getPhoneNumberPrimaryInfo(matchingTel,contact);if(Array.isArray(primaryInfo)&&primaryInfo[0]){primaryInfo=primaryInfo[0];}
if(group.contactPrimaryInfo!=String(primaryInfo)){group.contactPrimaryInfo=String(primaryInfo);needsUpdate=true;}
if(Array.isArray(matchingTel.type)&&matchingTel.type[0]&&group.contactMatchingTelType!=String(matchingTel.type[0])){group.contactMatchingTelType=String(matchingTel.type[0]);needsUpdate=true;}
if(matchingTel.carrier&&group.contactMatchingTelCarrier!=String(matchingTel.carrier)){group.contactMatchingTelCarrier=String(matchingTel.carrier);needsUpdate=true;}}
if(needsUpdate){self._newTxn('readwrite',[self._dbGroupsStore],function(error,txn,store){if(error){return;}
store.put(group).onsuccess=function(){waitForAsyncCall--;onContactsUpdated();};});}else{waitForAsyncCall--;onContactsUpdated();}});cursor.continue();};req.onerror=function onerror(event){self._asyncReturn(callback,event.target.error.name);};});}};;'use strict';const ALWAYS_ASK_OPTION_VALUE='-1';var MultiSimActionButton=function MultiSimActionButton(button,callCallback,settingsKey,phoneNumberGetter){this._button=button;this._callCallback=callCallback;this._settingsKey=settingsKey;this._phoneNumberGetter=phoneNumberGetter;this._button.addEventListener('click',this._click.bind(this));var self=this;LazyLoader.load(['/shared/js/settings_listener.js'],function(){SettingsListener.observe(settingsKey,0,self._settingsObserver.bind(self));});if(navigator.mozIccManager&&navigator.mozIccManager.iccIds.length>1){this._button.addEventListener('contextmenu',this._contextmenu.bind(this));this._simIndication=this._button.querySelector('.js-sim-indication');var telephony=navigator.mozTelephony;if(telephony){telephony.addEventListener('callschanged',self._updateUI.bind(self));}}};MultiSimActionButton.prototype._settingsObserver=function(cardIndex){this._defaultCardIndex=cardIndex;this._updateUI();if(this._clickQueued){this._clickQueued=false;this._click();}};MultiSimActionButton.prototype._getCardIndexIfLoaded=function(){if(window.TelephonyHelper){var inUseSim=window.TelephonyHelper.getInUseSim();if(inUseSim!==null){return inUseSim;}}
return this._defaultCardIndex;};MultiSimActionButton.prototype._click=function(event){if(event){event.preventDefault();}
var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(!navigator.mozIccManager||phoneNumber===''){return;}
if(navigator.mozIccManager.iccIds.length===0){this.performAction(0);return;}
var cardIndex=this._getCardIndexIfLoaded();if(cardIndex===undefined){this._clickQueued=true;return;}
if(cardIndex==ALWAYS_ASK_OPTION_VALUE){var self=this;LazyLoader.load(['/shared/js/sim_picker.js'],function(){SimPicker.getOrPick(cardIndex,phoneNumber,self.performAction.bind(self));});}else{this.performAction(cardIndex);}};MultiSimActionButton.prototype._updateUI=function(){var cardIndex=this._getCardIndexIfLoaded();if(cardIndex>=0&&navigator.mozIccManager&&navigator.mozIccManager.iccIds.length>1){if(this._simIndication){var self=this;navigator.mozL10n.ready(function(){navigator.mozL10n.localize(self._simIndication,'sim-picker-button',{n:cardIndex+1});});}
document.body.classList.add('has-preferred-sim');}else{document.body.classList.remove('has-preferred-sim');}};MultiSimActionButton.prototype._contextmenu=function(event){var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(!navigator.mozIccManager||navigator.mozIccManager.iccIds.length===0||phoneNumber===''||event.target.disabled||(window.TelephonyHelper&&window.TelephonyHelper.getInUseSim()!==null)){return;}
if(this._getCardIndexIfLoaded()===undefined){return;}
if(event){event.preventDefault();}
var self=this;LazyLoader.load(['/shared/js/sim_picker.js'],function(){SimPicker.getOrPick(self._getCardIndexIfLoaded(),phoneNumber,self.performAction.bind(self));});};MultiSimActionButton.prototype.performAction=function(cardIndex){var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(phoneNumber===''){return;}
if(cardIndex===undefined){cardIndex=this._getCardIndexIfLoaded();}
this._callCallback(phoneNumber,cardIndex);};;'use strict';(function(window){function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();setTimeout(function(){var detail={name:name,timestamp:now};var evt=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(evt);});}
window.PerformanceTestingHelper={dispatch:dispatch};})(window);