;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';var GestureDetector=(function(){function GD(e,options){this.element=e;this.options=options||{};this.options.panThreshold=this.options.panThreshold||GD.PAN_THRESHOLD;this.options.mousePanThreshold=this.options.mousePanThreshold||GD.MOUSE_PAN_THRESHOLD;this.state=initialState;this.timers={};this.listeningForMouseEvents=true;}
GD.prototype.startDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.addEventListener(t,self);});};GD.prototype.stopDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.removeEventListener(t,self);});};GD.prototype.handleEvent=function(e){var handler=this.state[e.type];if(!handler)return;if(e.changedTouches){if(this.listeningForMouseEvents){this.listeningForMouseEvents=false;this.element.removeEventListener('mousedown',this);}
if(e.type==='touchend'&&e.changedTouches.length>1){console.warn('gesture_detector.js: spurious extra changed touch on '+'touchend. See '+'https://bugzilla.mozilla.org/show_bug.cgi?id=785554');}
for(var i=0;i<e.changedTouches.length;i++){handler(this,e,e.changedTouches[i]);handler=this.state[e.type];}}
else{handler(this,e);}};GD.prototype.startTimer=function(type,time){this.clearTimer(type);var self=this;this.timers[type]=setTimeout(function(){self.timers[type]=null;var handler=self.state[type];if(handler)
handler(self,type);},time);};GD.prototype.clearTimer=function(type){if(this.timers[type]){clearTimeout(this.timers[type]);this.timers[type]=null;}};GD.prototype.switchTo=function(state,event,touch){this.state=state;if(state.init)
state.init(this,event,touch);};GD.prototype.emitEvent=function(type,detail){if(!this.target){console.error('Attempt to emit event with no target');return;}
var event=this.element.ownerDocument.createEvent('CustomEvent');event.initCustomEvent(type,true,true,detail);this.target.dispatchEvent(event);};GD.HOLD_INTERVAL=1000;GD.PAN_THRESHOLD=20;GD.MOUSE_PAN_THRESHOLD=15;GD.DOUBLE_TAP_DISTANCE=50;GD.DOUBLE_TAP_TIME=500;GD.VELOCITY_SMOOTHING=.5;GD.SCALE_THRESHOLD=20;GD.ROTATE_THRESHOLD=22.5;GD.THRESHOLD_SMOOTHING=0.9;var abs=Math.abs,floor=Math.floor,sqrt=Math.sqrt,atan2=Math.atan2;var PI=Math.PI;var eventtypes=['touchstart','touchmove','touchend','mousedown'];function eventTime(e){var ts=e.timeStamp;if(ts>2*Date.now())
return Math.floor(ts/1000);else
return ts;}
function coordinates(e,t){return Object.freeze({screenX:t.screenX,screenY:t.screenY,clientX:t.clientX,clientY:t.clientY,timeStamp:eventTime(e)});}
function midpoints(e,t1,t2){return Object.freeze({screenX:floor((t1.screenX+t2.screenX)/2),screenY:floor((t1.screenY+t2.screenY)/2),clientX:floor((t1.clientX+t2.clientX)/2),clientY:floor((t1.clientY+t2.clientY)/2),timeStamp:eventTime(e)});}
function mouseCoordinates(e){return Object.freeze({screenX:e.screenX,screenY:e.screenY,clientX:e.clientX,clientY:e.clientY,timeStamp:eventTime(e)});}
function between(c1,c2){var r=GD.THRESHOLD_SMOOTHING;return Object.freeze({screenX:floor(c1.screenX+r*(c2.screenX-c1.screenX)),screenY:floor(c1.screenY+r*(c2.screenY-c1.screenY)),clientX:floor(c1.clientX+r*(c2.clientX-c1.clientX)),clientY:floor(c1.clientY+r*(c2.clientY-c1.clientY)),timeStamp:floor(c1.timeStamp+r*(c2.timeStamp-c1.timeStamp))});}
function touchDistance(t1,t2){var dx=t2.screenX-t1.screenX;var dy=t2.screenY-t1.screenY;return sqrt(dx*dx+dy*dy);}
function touchDirection(t1,t2){return atan2(t2.screenY-t1.screenY,t2.screenX-t1.screenX)*180/PI;}
function touchRotation(d1,d2){var angle=d2-d1;if(angle>180)
angle-=360;else if(angle<=-180)
angle+=360;return angle;}
function isDoubleTap(lastTap,thisTap){var dx=abs(thisTap.screenX-lastTap.screenX);var dy=abs(thisTap.screenY-lastTap.screenY);var dt=thisTap.timeStamp-lastTap.timeStamp;return(dx<GD.DOUBLE_TAP_DISTANCE&&dy<GD.DOUBLE_TAP_DISTANCE&&dt<GD.DOUBLE_TAP_TIME);}
var initialState={name:'initialState',init:function(d){d.target=null;d.start=d.last=null;d.touch1=d.touch2=null;d.vx=d.vy=null;d.startDistance=d.lastDistance=null;d.startDirection=d.lastDirection=null;d.lastMidpoint=null;d.scaled=d.rotated=null;},touchstart:function(d,e,t){d.switchTo(touchStartedState,e,t);},mousedown:function(d,e){d.switchTo(mouseDownState,e);}};var touchStartedState={name:'touchStartedState',init:function(d,e,t){d.target=e.target;d.touch1=t.identifier;d.start=d.last=coordinates(e,t);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},touchstart:function(d,e,t){d.clearTimer('holdtimeout');d.switchTo(transformState,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;if(abs(t.screenX-d.start.screenX)>d.options.panThreshold||abs(t.screenY-d.start.screenY)>d.options.panThreshold){d.clearTimer('holdtimeout');d.switchTo(panStartedState,e,t);}},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=coordinates(e,t);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(holdState);}};var panStartedState={name:'panStartedState',init:function(d,e,t){d.start=d.last=between(d.start,coordinates(e,t));if(e.type==='touchmove')
panStartedState.touchmove(d,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:e.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};var holdState={name:'holdState',init:function(d){d.emitEvent('holdstart',d.start);},touchmove:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},touchend:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var transformState={name:'transformState',init:function(d,e,t){d.touch2=t.identifier;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);d.startDistance=d.lastDistance=touchDistance(t1,t2);d.startDirection=d.lastDirection=touchDirection(t1,t2);d.scaled=d.rotated=false;},touchmove:function(d,e,t){if(t.identifier!==d.touch1&&t.identifier!==d.touch2)
return;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);var midpoint=midpoints(e,t1,t2);var distance=touchDistance(t1,t2);var direction=touchDirection(t1,t2);var rotation=touchRotation(d.startDirection,direction);if(!d.scaled){if(abs(distance-d.startDistance)>GD.SCALE_THRESHOLD){d.scaled=true;d.startDistance=d.lastDistance=floor(d.startDistance+
GD.THRESHOLD_SMOOTHING*(distance-d.startDistance));}
else
distance=d.startDistance;}
if(!d.rotated){if(abs(rotation)>GD.ROTATE_THRESHOLD)
d.rotated=true;else
direction=d.startDirection;}
if(d.scaled||d.rotated){d.emitEvent('transform',{absolute:{scale:distance/d.startDistance,rotate:touchRotation(d.startDirection,direction)},relative:{scale:distance/d.lastDistance,rotate:touchRotation(d.lastDirection,direction)},midpoint:midpoint});d.lastDistance=distance;d.lastDirection=direction;d.lastMidpoint=midpoint;}},touchend:function(d,e,t){if(t.identifier===d.touch2)
d.touch2=null;else if(t.identifier===d.touch1){d.touch1=d.touch2;d.touch2=null;}
else
return;if(d.scaled||d.rotated){d.emitEvent('transformend',{absolute:{scale:d.lastDistance/d.startDistance,rotate:touchRotation(d.startDirection,d.lastDirection)},relative:{scale:1,rotate:0},midpoint:d.lastMidpoint});}
d.switchTo(afterTransformState);}};var afterTransformState={name:'afterTransformState',touchstart:function(d,e,t){d.switchTo(transformState,e,t);},touchend:function(d,e,t){if(t.identifier===d.touch1)
d.switchTo(initialState);}};var mouseDownState={name:'mouseDownState',init:function(d,e){d.target=e.target;var doc=d.element.ownerDocument;doc.addEventListener('mousemove',d,true);doc.addEventListener('mouseup',d,true);d.start=d.last=mouseCoordinates(e);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},mousemove:function(d,e){if(abs(e.screenX-d.start.screenX)>d.options.mousePanThreshold||abs(e.screenY-d.start.screenY)>d.options.mousePanThreshold){d.clearTimer('holdtimeout');d.switchTo(mousePannedState,e);}},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=mouseCoordinates(e);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(mouseHoldState);}};var mouseHoldState={name:'mouseHoldState',init:function(d){d.emitEvent('holdstart',d.start);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},mouseup:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var mousePannedState={name:'mousePannedState',init:function(d,e){d.start=d.last=between(d.start,mouseCoordinates(e));if(e.type==='mousemove')
mousePannedState.mousemove(d,e);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);var current=mouseCoordinates(e);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:current.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};return GD;}());;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;'use strict';var NotificationHelper={_referencesArray:[],getIconURI:function nc_getIconURI(app,entryPoint){var icons=app.manifest.icons;if(entryPoint){icons=app.manifest.entry_points[entryPoint].icons;}
if(!icons)
return null;var sizes=Object.keys(icons).map(function parse(str){return parseInt(str,10);});sizes.sort(function(x,y){return y-x;});var HVGA=document.documentElement.clientWidth<480;var index=sizes[HVGA?sizes.length-1:0];return app.installOrigin+icons[index];},send:function nc_send(title,body,icon,clickCB,closeCB){if(!('mozNotification'in navigator))
return;var notification=navigator.mozNotification.createNotification(title,body,icon);notification.onclick=(function(){if(clickCB)
clickCB();this._forget(notification);}).bind(this);notification.onclose=(function(){if(closeCB)
closeCB();this._forget(notification);}).bind(this);notification.show();this._keep(notification);},_keep:function nc_keep(notification){this._referencesArray.push(notification);},_forget:function nc_forget(notification){this._referencesArray.splice(this._referencesArray.indexOf(notification),1);}};;;(function(){var dispatch=true;var base='';var running;function page(path,fn){if('function'==typeof fn){var route=new Route(path);for(var i=1;i<arguments.length;++i){page.callbacks.push(route.middleware(arguments[i]));}}else if('string'==typeof path){page.show(path,fn);}else{page.start(path);}}
page.callbacks=[];page.base=function(path){if(0==arguments.length)return base;base=path;};page.start=function(options){options=options||{};if(running)return;running=true;if(false===options.dispatch)dispatch=false;if(false!==options.popstate)addEventListener('popstate',onpopstate,false);if(false!==options.click)addEventListener('click',onclick,false);if(!dispatch)return;page.replace(location.pathname+location.search,null,true,dispatch);};page.stop=function(){running=false;removeEventListener('click',onclick,false);removeEventListener('popstate',onpopstate,false);};page.show=function(path,state){var ctx=new Context(path,state);page.dispatch(ctx);if(!ctx.unhandled)ctx.pushState();return ctx;};page.replace=function(path,state,init,dispatch){var ctx=new Context(path,state);ctx.init=init;if(null==dispatch)dispatch=true;if(dispatch)page.dispatch(ctx);ctx.save();return ctx;};page.dispatch=function(ctx){var i=0;function next(){var fn=page.callbacks[i++];if(!fn)return unhandled(ctx);fn(ctx,next);}
next();};function unhandled(ctx){if(window.location.pathname==ctx.canonicalPath)return;page.stop();ctx.unhandled=true;window.location=ctx.canonicalPath;}
function Context(path,state){if('/'==path[0]&&0!=path.indexOf(base))path=base+path;var i=path.indexOf('?');this.canonicalPath=path;this.path=path.replace(base,'')||'/';this.title=document.title;this.state=state||{};this.state.path=path;this.querystring=~i?path.slice(i+1):'';this.pathname=~i?path.slice(0,i):path;this.params=[];}
Context.prototype.pushState=function(){history.pushState(this.state,this.title,this.canonicalPath);};Context.prototype.save=function(){history.replaceState(this.state,this.title,this.canonicalPath);};function Route(path,options){options=options||{};this.path=path;this.method='GET';this.regexp=pathtoRegexp(path,this.keys=[],options.sensitive,options.strict);}
Route.prototype.middleware=function(fn){var self=this;return function(ctx,next){if(self.match(ctx.path,ctx.params))return fn(ctx,next);next();}};Route.prototype.match=function(path,params){var keys=this.keys,qsIndex=path.indexOf('?'),pathname=~qsIndex?path.slice(0,qsIndex):path,m=this.regexp.exec(pathname);if(!m)return false;for(var i=1,len=m.length;i<len;++i){var key=keys[i-1];var val='string'==typeof m[i]?decodeURIComponent(m[i]):m[i];if(key){params[key.name]=undefined!==params[key.name]?params[key.name]:val;}else{params.push(val);}}
return true;};function pathtoRegexp(path,keys,sensitive,strict){if(path instanceof RegExp)return path;if(path instanceof Array)path='('+path.join('|')+')';path=path.concat(strict?'':'/?').replace(/\/\(/g,'(?:/').replace(/\+/g,'__plus__').replace(/(\/)?(\.)?:(\w+)(?:(\(.*?\)))?(\?)?/g,function(_,slash,format,key,capture,optional){keys.push({name:key,optional:!!optional});slash=slash||'';return''
+(optional?'':slash)
+'(?:'
+(optional?slash:'')
+(format||'')+(capture||(format&&'([^/.]+?)'||'([^/]+?)'))+')'
+(optional||'');}).replace(/([\/.])/g,'\\$1').replace(/__plus__/g,'(.+)').replace(/\*/g,'(.*)');return new RegExp('^'+path+'$',sensitive?'':'i');};function onpopstate(e){if(e.state){var path=e.state.path;page.replace(path,e.state);}}
function onclick(e){if(e.defaultPrevented)return;var el=e.target;while(el&&'A'!=el.nodeName)el=el.parentNode;if(!el||'A'!=el.nodeName)return;var href=el.href;var path=el.pathname+el.search;if(el.hash)return;if(!sameOrigin(href))return;var orig=path;path=path.replace(base,'');if(base&&orig==path)return;e.preventDefault();page.show(orig);}
function sameOrigin(href){var origin=location.protocol+'//'+location.hostname;if(location.port)origin+=':'+location.port;return 0==href.indexOf(origin);}
if('undefined'==typeof module){window.page=page;}else{module.exports=page;}})();;(function(){var _global=this;var mathRNG,nodeRNG,whatwgRNG;var _rndBytes=new Array(16);mathRNG=function(){var r,b=_rndBytes,i=0;for(var i=0,r;i<16;i++){if((i&0x03)==0)r=Math.random()*0x100000000;b[i]=r>>>((i&0x03)<<3)&0xff;}
return b;}
try{var _rb=require('crypto').randomBytes;nodeRNG=_rb&&function(){return _rb(16);};}catch(e){}
var _rng=nodeRNG||whatwgRNG||mathRNG;var BufferClass=typeof(Buffer)=='function'?Buffer:Array;var _byteToHex=[];var _hexToByte={};for(var i=0;i<256;i++){_byteToHex[i]=(i+0x100).toString(16).substr(1);_hexToByte[_byteToHex[i]]=i;}
function parse(s,buf,offset){var i=(buf&&offset)||0,ii=0;buf=buf||[];s.toLowerCase().replace(/[0-9a-f]{2}/g,function(oct){if(ii<16){buf[i+ii++]=_hexToByte[oct];}});while(ii<16){buf[i+ii++]=0;}
return buf;}
function unparse(buf,offset){var i=offset||0,bth=_byteToHex;return bth[buf[i++]]+bth[buf[i++]]+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+
bth[buf[i++]]+bth[buf[i++]]+
bth[buf[i++]]+bth[buf[i++]];}
var _seedBytes=_rng();var _nodeId=[_seedBytes[0]|0x01,_seedBytes[1],_seedBytes[2],_seedBytes[3],_seedBytes[4],_seedBytes[5]];var _clockseq=(_seedBytes[6]<<8|_seedBytes[7])&0x3fff;var _lastMSecs=0,_lastNSecs=0;function v1(options,buf,offset){var i=buf&&offset||0;var b=buf||[];options=options||{};var clockseq=options.clockseq!=null?options.clockseq:_clockseq;var msecs=options.msecs!=null?options.msecs:new Date().getTime();var nsecs=options.nsecs!=null?options.nsecs:_lastNSecs+1;var dt=(msecs-_lastMSecs)+(nsecs-_lastNSecs)/10000;if(dt<0&&options.clockseq==null){clockseq=clockseq+1&0x3fff;}
if((dt<0||msecs>_lastMSecs)&&options.nsecs==null){nsecs=0;}
if(nsecs>=10000){throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');}
_lastMSecs=msecs;_lastNSecs=nsecs;_clockseq=clockseq;msecs+=12219292800000;var tl=((msecs&0xfffffff)*10000+nsecs)%0x100000000;b[i++]=tl>>>24&0xff;b[i++]=tl>>>16&0xff;b[i++]=tl>>>8&0xff;b[i++]=tl&0xff;var tmh=(msecs/0x100000000*10000)&0xfffffff;b[i++]=tmh>>>8&0xff;b[i++]=tmh&0xff;b[i++]=tmh>>>24&0xf|0x10;b[i++]=tmh>>>16&0xff;b[i++]=clockseq>>>8|0x80;b[i++]=clockseq&0xff;var node=options.node||_nodeId;for(var n=0;n<6;n++){b[i+n]=node[n];}
return buf?buf:unparse(b);}
function v4(options,buf,offset){var i=buf&&offset||0;if(typeof(options)=='string'){buf=options=='binary'?new BufferClass(16):null;options=null;}
options=options||{};var rnds=options.random||(options.rng||_rng)();rnds[6]=(rnds[6]&0x0f)|0x40;rnds[8]=(rnds[8]&0x3f)|0x80;if(buf){for(var ii=0;ii<16;ii++){buf[i+ii]=rnds[ii];}}
return buf||unparse(rnds);}
var uuid=v4;uuid.v1=v1;uuid.v4=v4;uuid.parse=parse;uuid.unparse=unparse;uuid.BufferClass=BufferClass;uuid.mathRNG=mathRNG;uuid.nodeRNG=nodeRNG;uuid.whatwgRNG=whatwgRNG;if(typeof(module)!='undefined'){module.exports=uuid;}else{var _previousRoot=_global.uuid;uuid.noConflict=function(){_global.uuid=_previousRoot;return uuid;}
_global.uuid=uuid;}}());;(function(window){const NEXT_TICK='calendar-next-tick';var NUMERIC=/^([0-9]+)$/;var nextTickStack=[];var hasOwnProperty=Object.prototype.hasOwnProperty;window.Calendar={ERROR:'error',ACTIVE:'active',DEBUG:false,extend:function(target,input){for(var key in input){if(hasOwnProperty.call(input,key)){target[key]=input[key];}}
return target;},nextTick:function(callback){nextTickStack.push(callback);window.postMessage(NEXT_TICK,'*');},ns:function(path,checkOnly){var parts=path.split('.');var lastPart=this;var i=0;var len=parts.length;for(;i<len;i++){var part=parts[i];if(!(part in lastPart)){if(checkOnly)
return false;lastPart[part]={};}
lastPart=lastPart[part];}
if(checkOnly)
return true;return lastPart;},log:function(){var args=Array.prototype.slice.call(arguments);args.unshift('CALENDAR:');console.error.apply(console,args);},debug:function(name){return function(){if(!Calendar.DEBUG)
return;var args=Array.prototype.slice.call(arguments);args=args.map(function(item){return JSON.stringify(item);});args.unshift('[calendar] ');args.unshift(name);console.log.apply(console,args);}},compare:function(a,b){if(a>b){return 1;}else if(a<b){return-1;}
return 0;},probablyParseInt:function(id){if(id.match&&id.match(NUMERIC)){return parseInt(id,10);}
return id;},binsearch:{find:function binsearch(list,seekVal,cmpfunc,aLow,aHigh){var low=((aLow===undefined)?0:aLow),high=((aHigh===undefined)?(list.length-1):aHigh),mid,cmpval;while(low<=high){mid=low+Math.floor((high-low)/2);cmpval=cmpfunc(seekVal,list[mid]);if(cmpval<0)
high=mid-1;else if(cmpval>0)
low=mid+1;else
return mid;}
return null;},insert:function bsearchForInsert(list,seekVal,cmpfunc){if(!list.length)
return 0;var low=0,high=list.length-1,mid,cmpval;while(low<=high){mid=low+Math.floor((high-low)/2);cmpval=cmpfunc(seekVal,list[mid]);if(cmpval<0)
high=mid-1;else if(cmpval>0)
low=mid+1;else
break;}
if(cmpval<0)
return mid;else if(cmpval>0)
return mid+1;else
return mid;}}};window.addEventListener('message',function handleNextTick(event){if(event.source===window&&event.data==NEXT_TICK){event.stopPropagation();if(nextTickStack.length){(nextTickStack.shift())();}}});}(this));;Calendar.Presets={"google":{"providerType":"Caldav","group":"remote","authenticationType":"oauth2","apiCredentials":{"tokenUrl":"https://accounts.google.com/o/oauth2/token","authorizationUrl":"https://accounts.google.com/o/oauth2/auth","user_info":{"url":"https://www.googleapis.com/oauth2/v3/userinfo","field":"email"},"client_secret":"jQTKlOhF-RclGaGJot3HIcVf","client_id":"605300196874-1ki833poa7uqabmh3hq6u1onlqlsi54h.apps.googleusercontent.com","scope":"https://www.googleapis.com/auth/calendar https://www.googleapis.com/auth/userinfo.email","redirect_uri":"https://oauth.gaiamobile.org/authenticated"},"options":{"domain":"https://apidata.googleusercontent.com","entrypoint":"/caldav/v2/","providerType":"Caldav"}},"yahoo":{"providerType":"Caldav","group":"remote","options":{"domain":"https://caldav.calendar.yahoo.com","entrypoint":"/","providerType":"Caldav","user":"@yahoo.com","usernameType":"email"}},"caldav":{"providerType":"Caldav","group":"remote","options":{"domain":"","entrypoint":"","providerType":"Caldav"}},"local":{"singleUse":true,"providerType":"Local","group":"local","options":{"providerType":"Local"}}};;Calendar.Error=(function(window){function Base(name,detail){this.message='oops... why did you throw this?';this.name=name;this.detail=detail;}
Base.prototype=Object.create(Error.prototype);function errorFactory(name,l10nID){var error=function(detail){this.name=name;this.detail=detail;this.l10nID=l10nID||name;};error.prototype=Object.create(Base.prototype);return error;}
Base.Authentication=errorFactory('authentication','unauthenticated');Base.InvalidServer=errorFactory('invalid-server','internal-server-error');Base.ServerFailure=errorFactory('server-failure','internal-server-error');return Base;}(this));;Calendar.Calc=(function(){const SECOND=1000;const MINUTE=(SECOND*60);const HOUR=MINUTE*60;var Calc={_hourDate:new Date(),startsOnMonday:false,FLOATING:'floating',ALLDAY:'allday',SECOND:SECOND,MINUTE:MINUTE,HOUR:HOUR,PAST:'past',NEXT_MONTH:'next-month',OTHER_MONTH:'other-month',PRESENT:'present',FUTURE:'future',get today(){return new Date();},formatHour:function(hour){if(hour===Calc.ALLDAY){return Calc.ALLDAY;}
var format=navigator.mozL10n.get('hour-format');format=format||'%I %p';Calc._hourDate.setHours(hour);var result=Calendar.App.dateFormat.localeFormat(Calc._hourDate,format);if(result[0]=='0'){result=result.slice(1);}
return result;},daysInWeek:function(){return 7;},dayOfWeekFromMonday:function(numeric){var day=numeric-1;if(day<0)
return 6;return day;},dayOfWeekFromSunday:function(numeric){return numeric;},isToday:function(date){return Calc.isSameDate(date,Calc.today);},compareHours:function(a,b){var result;if(a===b){return 0;}
if(a===Calc.ALLDAY){return-1;}
if(b===Calc.ALLDAY){return 1;}
return Calendar.compare(a,b);},isOnlyDate:function(date){if(date.getHours()===0&&date.getMinutes()===0&&date.getSeconds()===0){return true;}
return false;},hoursOfOccurance:function(day,start,end){var refStart=new Date(day.getFullYear(),day.getMonth(),day.getDate());var refEnd=new Date(day.getFullYear(),day.getMonth(),day.getDate()+1);refEnd.setMilliseconds(-1);var startBefore=start<=refStart;var endsAfter=end>=refEnd;if(startBefore&&endsAfter){return[Calc.ALLDAY];}
start=(startBefore)?refStart:start;end=(endsAfter)?refEnd:end;var curHour=start.getHours();var lastHour=end.getHours();var hours=[];for(;curHour<lastHour;curHour++){hours.push(curHour);}
if(end.getMinutes()||end.getSeconds()){hours.push(end.getHours());}
return hours;},hourDiff:function(start,end){start=(start instanceof Date)?start.valueOf():start;end=(end instanceof Date)?end.valueOf():end;start=start/HOUR;end=end/HOUR;return end-start;},spanOfDay:function(date,includeTime){if(typeof(includeTime)==='undefined'){date=Calc.createDay(date);}
var end=Calc.createDay(date);end.setDate(end.getDate()+1);return new Calendar.Timespan(date,end);},spanOfMonth:function(month){month=new Date(month.getFullYear(),month.getMonth(),1);var startDay=Calc.getWeekStartDate(month);var endDay=new Date(month.getFullYear(),month.getMonth()+1,1);endDay.setMilliseconds(-1);endDay=Calc.getWeekEndDate(endDay);return new Calendar.Timespan(startDay,endDay);},getUTC:function(date){return new Date(date.getUTCFullYear(),date.getUTCMonth(),date.getUTCDate(),date.getUTCHours(),date.getUTCMinutes(),date.getUTCSeconds(),date.getUTCMilliseconds());},dateFromTransport:function(transport){var utc=transport.utc;var offset=transport.offset;var zone=transport.tzid;var date=new Date(parseInt(utc)-parseInt(offset));if(zone&&zone===Calc.FLOATING){return Calendar.Calc.getUTC(date);}
return date;},dateToTransport:function(date,tzid,isDate){var result=Object.create(null);result.utc=utc;if(isDate){result.isDate=isDate;}
if(tzid){result.tzid=tzid;}
var utc=Date.UTC(date.getFullYear(),date.getMonth(),date.getDate(),date.getHours(),date.getMinutes(),date.getSeconds(),date.getMilliseconds());if(isDate||tzid&&tzid===Calc.FLOATING){result.utc=utc;result.offset=0;result.tzid=Calendar.Calc.FLOATING;}else{var localUtc=date.valueOf();var offset=utc-localUtc;result.utc=utc;result.offset=offset;}
return result;},isSameDate:function(first,second){return first.getMonth()==second.getMonth()&&first.getDate()==second.getDate()&&first.getFullYear()==second.getFullYear();},getDayId:function(date){return['d',date.getFullYear(),date.getMonth(),date.getDate()].join('-');},dateFromId:function(id){var parts=id.split('-'),date,type;if(parts.length>1){type=parts.shift();switch(type){case'd':date=new Date(parts[0],parts[1],parts[2]);break;case'm':date=new Date(parts[0],parts[1]);break;}}
return date;},getMonthId:function(date){return['m',date.getFullYear(),date.getMonth()].join('-');},createDay:function(date,day,month,year){return new Date(typeof year!=='undefined'?year:date.getFullYear(),typeof month!=='undefined'?month:date.getMonth(),typeof day!=='undefined'?day:date.getDate());},dayOfWeek:function(date){var number=date;if(typeof(date)!=='number'){number=date.getDay();}
if(Calc.startsOnMonday){return this.dayOfWeekFromMonday(number);}
return this.dayOfWeekFromSunday(number);},getWeekStartDate:function(date){var currentDay=Calc.dayOfWeek(date);var startDay=(date.getDate()-currentDay);return Calc.createDay(date,startDay);},getWeekEndDate:function(date){var start=Calc.getWeekStartDate(date);start.setDate(start.getDate()+7);start.setMilliseconds(-1);return start;},daysBetween:function(start,end,includeTime){if(start>end){var tmp=end;end=start;start=tmp;tmp=null;}
var list=[];var last=start.getDate();var cur;if(Calc.isSameDate(start,end)){if(includeTime){list.push(end);}else{list.push(this.createDay(start));}
return list;}
while(true){var next=new Date(start.getFullYear(),start.getMonth(),++last);if(next>end){throw new Error('sanity fails next is greater then end');}
if(!Calc.isSameDate(next,end)){list.push(next);continue;}
break;}
if(includeTime){list.unshift(start);list.push(end);}else{list.unshift(Calc.createDay(start));list.push(Calc.createDay(end));}
return list;},getWeeksDays:function(startDate){var weeksDayStart=Calc.getWeekStartDate(startDate);var result=[weeksDayStart];for(var i=1;i<7;i++){result.push(new Date(weeksDayStart.getFullYear(),weeksDayStart.getMonth(),weeksDayStart.getDate()+i));}
return result;},isPast:function(date){return(date.valueOf()<Calc.today.valueOf());},isFuture:function(date){return!Calc.isPast(date);},relativeState:function(day,month){var states;if(Calc.isToday(day)){return Calc.PRESENT;}
if(Calc.isPast(day)){states=Calc.PAST;}else{states=Calc.FUTURE;}
if(day.getMonth()!==month.getMonth()){states+=' '+Calc.OTHER_MONTH;}
return states;}};window.addEventListener('localized',function changeStartDay(){var startDay=navigator.mozL10n.get('weekStartsOnMonday');if(startDay&&parseInt(startDay,10)){Calc.startsOnMonday=true;}else{Calc.startsOnMonday=false;}});return Calc;}());;(function(window){var POSSIBLE_HTML=/[&<>"'`]/;var span=document.createElement('span');function create(templates){var key,result={};for(key in templates){if(templates.hasOwnProperty(key)){result[key]=new Template(templates[key]);}}
return result;}
function Template(fn){this.template=fn;}
Template.handlers={arg:function(key){if(typeof(this.data)==='undefined'){return'';}else if(typeof(this.data)!=='object'){return this.data;}
return this.data[key];},'h':function(a){var arg=this.arg(a);if(POSSIBLE_HTML.test(arg)){span.textContent=arg;return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');}else{return arg||'';}},'s':function(a){var arg=this.arg(a);return String((arg||''));},bool:function(key,onTrue){if(this.data[key]){return onTrue;}else{return'';}},'l10n':function(key,prefix){var value=this.arg(key);if(prefix){value=prefix+value;}
return navigator.mozL10n.get(value);}};Template.prototype={render:function(data){Template.handlers.data=data;return this.template.apply(Template.handlers);},renderEach:function(objects,join){var i=0,len=objects.length,result=[];for(;i<len;i++){result.push(this.render(objects[i]));}
if(typeof(join)!=='undefined'){return result.join(join);}
return result;}};Template.create=create;Calendar.Template=Template;}(this));;(function(exports){if(typeof(exports.Calendar)==='undefined'){exports.Calendar={};}
var Responder=exports.Calendar.Responder=function Responder(events){this._$events=Object.create(null);if(typeof(events)!=='undefined'){this.addEventListener(events);}};Responder.stringify=function stringify(command,data){return JSON.stringify([command,data]);};Responder.parse=function parse(json){var data;try{data=(json.forEach)?json:JSON.parse(json);}catch(e){throw new Error("Could not parse json: '"+json+'"');}
return data;};Responder.prototype={parse:Responder.parse,stringify:Responder.stringify,events:null,respond:function respond(json){var event=Responder.parse(json);var args=Array.prototype.slice.call(arguments).slice(1);this.emit.apply(this,event.concat(args));return event;},addEventListener:function addEventListener(type,callback){var event;if(typeof(callback)==='undefined'&&typeof(type)==='object'){for(event in type){if(type.hasOwnProperty(event)){this.addEventListener(event,type[event]);}}
return this;}
if(!(type in this._$events)){this._$events[type]=[];}
this._$events[type].push(callback);return this;},once:function once(type,callback){var self=this;function onceCb(){self.removeEventListener(type,onceCb);callback.apply(this,arguments);}
this.addEventListener(type,onceCb);return this;},emit:function emit(){var args=Array.prototype.slice.call(arguments),event=args.shift(),eventList,self=this;if(event in this._$events){eventList=this._$events[event];eventList.forEach(function(callback){if(typeof(callback)==='object'&&callback.handleEvent){callback.handleEvent({type:event,data:args});}else{callback.apply(self,args);}});}
return this;},removeAllEventListeners:function removeAllEventListeners(name){if(name in this._$events){this._$events[name].length=0;}
return this;},removeEventListener:function removeEventListener(name,callback){var i,length,events;if(!(name in this._$events)){return false;}
events=this._$events[name];for(i=0,length=events.length;i<length;i++){if(events[i]&&events[i]===callback){events.splice(i,1);return true;}}
return false;}};Responder.prototype.on=Responder.prototype.addEventListener;}((typeof(module)==='undefined')?this:module.exports));;(function(window){var DEFAULT_ERROR_ID='error-default';function View(options){if(typeof(options)==='undefined'){options={};}
if(typeof(options)==='string'){this.selectors={element:options};}else{var key;if(typeof(options)==='undefined'){options={};}
for(key in options){if(options.hasOwnProperty(key)){this[key]=options[key];}}}
this.hideErrors=this.hideErrors.bind(this);}
const INVALID_CSS=/([^a-zA-Z\-\_0-9])/g;View.ACTIVE='active';View.prototype={seen:false,activeClass:View.ACTIVE,errorVisible:false,get element(){return this._findElement('element');},get status(){return this._findElement('status');},get errors(){return this._findElement('errors');},idForModel:function(prefix,objectOrString){prefix+=(typeof(objectOrString)==='object')?objectOrString._id:objectOrString;return prefix;},calendarId:function(input){if(typeof(input)!=='string'){input=input.calendarId;}
input=this.cssClean(input);return'calendar-id-'+input;},delegate:function(element,type,selector,handler){if(typeof(handler)==='object'){var context=handler;handler=function(){context.handleEvent.apply(context,arguments);};}
element.addEventListener(type,function(e){var target=e.target;while(target!==element){if('mozMatchesSelector'in target&&target.mozMatchesSelector(selector)){return handler(e,target);}
target=target.parentNode;}});},cssClean:function(string){if(typeof(string)!=='string')
return string;return string.replace(INVALID_CSS,'-');},_findElement:function(name,all,element){if(typeof(all)==='object'){element=all;all=false;}
element=element||document;var cacheName;var selector;if(typeof(all)==='undefined'){all=false;}
if(name in this.selectors){cacheName='_'+name+'Element';selector=this.selectors[name];if(!this[cacheName]){if(all){this[cacheName]=element.querySelectorAll(selector);}else{this[cacheName]=element.querySelector(selector);}}
return this[cacheName];}
return null;},showErrors:function(list){var _=navigator.mozL10n.get;var errors='';if(!Array.isArray(list)){list=[list];}
var i=0;var len=list.length;for(;i<len;i++){var name=list[i].l10nID||list[i].name;errors+=_('error-'+name)||_(DEFAULT_ERROR_ID);}
this.errors.textContent=errors;this.errorVisible=true;this.status.classList.add(this.activeClass);this.status.addEventListener('animationend',this.hideErrors);},hideErrors:function(){this.status.classList.remove(this.activeClass);this.status.removeEventListener('animationend',this.hideErrors);this.errorVisible=false;},onactive:function(){if(this.errorVisible){this.hideErrors();}
if(this.seen===false){this.onfirstseen();}
if('dispatch'in this){this.dispatch.apply(this,arguments);}
this.seen=true;if(this.element){this.element.classList.add(this.activeClass);}},oninactive:function(){if(this.element){this.element.classList.remove(this.activeClass);}},onfirstseen:function(){}};Calendar.View=View;}(this));;(function(window){var COPY_METHODS=['start','stop','show'];function Router(page){var i=0;var len=COPY_METHODS.length;this.page=page;this._activeObjects=[];for(;i<len;i++){this[COPY_METHODS[i]]=this.page[COPY_METHODS[i]].bind(this.page);}
this._lastState=this._lastState.bind(this);}
Router.prototype={mangeObject:function(){var args=Array.prototype.slice.call(arguments);var object=args.shift();this._activeObjects.push(object);if('onactive'in object){object.onactive.apply(object,args);}},clearObjects:function(ctx){var item;while((item=this._activeObjects.pop())){if('oninactive'in item){item.oninactive();}}},_lastState:function(ctx){this.last=ctx;},resetState:function(){if(!this.currentPath){this.currentPath='/month/';}
this.show(this.currentPath);},state:function(path,views,options){options=options||{};if(!Array.isArray(views)){views=[views];}
var self=this;var viewObjs=[];function setPath(ctx,next){viewObjs=[];if(options.path!==false){document.body.dataset.path=ctx.canonicalPath;}
next();}
function loadAllViews(ctx,next){var len=views.length;var numViews=len;var i;for(i=0;i<numViews;i++){Calendar.App.view(views[i],function(view){viewObjs.push(view);len--;if(!len){next();}});}}
function handleViews(ctx,next){if(options.clear!==false){self.clearObjects();}
for(var i=0,view;view=viewObjs[i];i++){self.mangeObject(view,ctx);}
if(options.appPath!==false){self.currentPath=ctx.canonicalPath;}
next();}
this.page(path,setPath,loadAllViews,handleViews,this._lastState);},modifier:function(path,view,options){options=options||{};options.appPath=false;options.clear=false;this.state(path,view,options);}};Calendar.Router=Router;}(this));;(function(window){var idb=window.indexedDB;const VERSION=15;var debug=Calendar.debug('database');var store={events:'events',accounts:'accounts',calendars:'calendars',busytimes:'busytimes',settings:'settings',alarms:'alarms',icalComponents:'icalComponents'};Object.freeze(store);function Db(name){this.name=name;this._stores=Object.create(null);Calendar.Responder.call(this);this._upgradeOperations=[];}
Db.prototype={__proto__:Calendar.Responder.prototype,connection:null,getStore:function(name){if(!(name in this._stores)){try{this._stores[name]=new Calendar.Store[name](this);}catch(e){console.log('Failed to load store',name,e.stack);}}
return this._stores[name];},load:function(callback){var self=this;function setupDefaults(){if(self.oldVersion<8){self._setupDefaults(callback);}else{Calendar.nextTick(callback);}}
if(this.isOpen){return setupDefaults();}
if(!this.isOpen){this.open(VERSION,function(){setupDefaults();}.bind(this));}},open:function(version,callback){if(typeof(version)==='function'){callback=version;version=VERSION;}
var req=idb.open(this.name,version);this.version=version;var self=this;req.onsuccess=function(event){self.isOpen=true;self.connection=req.result;if(self._upgradeOperations.length){var pending=self._upgradeOperations.length;function next(){if(!(--pending)){callback(null,self);self.emit('open',self);}}
var operation;while((operation=self._upgradeOperations.shift())){operation.call(self,next);}}else{callback(null,self);self.emit('open',self);}};req.onblocked=function(error){callback(error,null);self.emit('error',error);};req.onupgradeneeded=function(event){self._handleVersionChange(req.result,event);};req.onerror=function(error){callback(error,null);self.emit('error',error);};},transaction:function(list,state){var names;var self=this;if(typeof(list)==='string'){names=[];names.push(this.store[list]||list);}else{names=list.map(function(name){return self.store[name]||name;});}
return this.connection.transaction(names,state||'readonly');},_handleVersionChange:function(db,event){var newVersion=event.newVersion;var curVersion=event.oldVersion;var transaction=event.currentTarget.transaction;this.hasUpgraded=true;this.oldVersion=curVersion;this.upgradedVersion=newVersion;for(;curVersion<newVersion;curVersion++){if(curVersion<6){var existingNames=db.objectStoreNames;for(var i=0;i<existingNames.length;i++){db.deleteObjectStore(existingNames[i]);}
curVersion=6;var busytimes=db.createObjectStore(store.busytimes,{keyPath:'_id'});busytimes.createIndex('end','end.utc',{unique:false,multiEntry:false});busytimes.createIndex('eventId','eventId',{unique:false,multiEntry:false});var events=db.createObjectStore(store.events,{keyPath:'_id'});events.createIndex('calendarId','calendarId',{unique:false,multiEntry:false});events.createIndex('parentId','parentId',{unique:false,multiEntry:false});db.createObjectStore(store.accounts,{keyPath:'_id',autoIncrement:true});db.createObjectStore(store.calendars,{keyPath:'_id',autoIncrement:true});}else if(curVersion===7){db.createObjectStore(store.settings,{keyPath:'_id'});}else if(curVersion===8){var alarms=db.createObjectStore(store.alarms,{keyPath:'_id',autoIncrement:true});alarms.createIndex('trigger','trigger.utc',{unique:false,multiEntry:false});alarms.createIndex('busytimeId','busytimeId',{unique:false,multiEntry:false});}else if(curVersion===12){var icalComponents=db.createObjectStore(store.icalComponents,{keyPath:'eventId',autoIncrement:false});icalComponents.createIndex('lastRecurrenceId','lastRecurrenceId.utc',{unique:false,multiEntry:false});}else if(curVersion===13){var calendarStore=transaction.objectStore(store.calendars);calendarStore.createIndex('accountId','accountId',{unique:false,multiEntry:false});}else if(curVersion===14){this.sanitizeEvents(transaction);}}},sanitizeEvents:function(trans){var badCalendarIdToEventIds={};var objectStore=trans.objectStore(store.events);objectStore.openCursor().onsuccess=(function(evt){var cursor=evt.target.result;if(!cursor){return this._updateXorDeleteEvents(badCalendarIdToEventIds,trans);}
var calendarId=cursor.value.calendarId;if(typeof(calendarId)==='number'){return cursor.continue();}
var eventIds=badCalendarIdToEventIds[calendarId]||[];eventIds.push(cursor.key);badCalendarIdToEventIds[calendarId]=eventIds;cursor.continue();}).bind(this);},_updateXorDeleteEvents:function(badCalendarIdToEventIds,trans){var calendarIds=Object.keys(badCalendarIdToEventIds);calendarIds.forEach(function(calendarId){calendarId=Calendar.probablyParseInt(calendarId);var eventIds=badCalendarIdToEventIds[calendarId];var calendars=trans.objectStore(store.calendars);calendars.get(calendarId).onsuccess=(function(evt){var result=evt.target.result;if(result){this._updateEvents(eventIds,calendarId,trans);}else{this._deleteEvents(eventIds,trans);}}).bind(this);},this);},_updateEvents:function(eventIds,calendarId,trans){var eventStore=trans.objectStore(store.events);var busytimeStore=trans.objectStore(store.busytimes);var busytimeStoreIndexedByEventId=busytimeStore.index('eventId');eventIds.forEach(function(eventId){eventStore.get(eventId).onsuccess=function(evt){var result=evt.target.result;result.calendarId=calendarId;eventStore.put(result);};busytimeStoreIndexedByEventId.get(eventId).onsuccess=function(evt){var result=evt.target.result;result.calendarId=calendarId;busytimeStore.put(result);};});},_deleteEvents:function(eventIds,trans){var events=this.getStore('Event');eventIds.forEach(function(eventId){events.remove(eventId,trans);});},get store(){return store;},close:function(){if(this.connection){this.isOpen=false;this.connection.close();this.connection=null;}},clearNonCredentials:function(callback){var stores=['events','busytimes'];var trans=this.transaction(stores,'readwrite');trans.addEventListener('complete',callback);stores.forEach(function(store){store=trans.objectStore(store);store.clear();});},_setupDefaults:function(callback){var calendarStore=this.getStore('Calendar');var accountStore=this.getStore('Account');var trans=calendarStore.db.transaction(['accounts','calendars'],'readwrite');if(callback){trans.addEventListener('error',function(err){callback(err);});trans.addEventListener('complete',function(){callback();});}
var account=new Calendar.Models.Account(Calendar.Presets.local.options);account.preset='local';account._id=uuid();var calendar={_id:Calendar.Provider.Local.calendarId,accountId:account._id,remote:Calendar.Provider.Local.defaultCalendar()};accountStore.persist(account,trans);calendarStore.persist(calendar,trans);},deleteDatabase:function(callback){var req=idb.deleteDatabase(this.name);req.onblocked=function(e){callback(new Error('blocked'));};req.onsuccess=function(event){callback(null,event);};req.onerror=function(event){callback(event,null);};}};Calendar.Db=Db;}(this));;Calendar.Timespan=(function(){function Timespan(startDate,endDate){this.start=startDate.valueOf();this.end=endDate.valueOf();}
Timespan.prototype={daysBetween:function(){var start=new Date(this.start);var end=new Date(this.end);return Calendar.Calc.daysBetween(start,end);},isEqual:function(inputSpan){return(this.start===inputSpan.start&&this.end===inputSpan.end);},trimOverlap:function(span){if(this.contains(span)||span.contains(this)){return null;}
var start=span.start;var end=span.end;var ourEnd=this.end;var ourStart=this.start;var overlapsBefore=start>=ourStart&&start<ourEnd;var overlapsAfter=ourStart>=start&&ourStart<end;var newStart=span.start;var newEnd=span.end;if(overlapsBefore){newStart=ourEnd+1;}
if(overlapsAfter){newEnd=ourStart-1;}
return new Calendar.Timespan(newStart,newEnd);},overlaps:function(start,end){var ourStart=this.start;var ourEnd=this.end;if(start instanceof Timespan){end=start.end;start=start.start;}else{start=(start instanceof Date)?start.valueOf():start;end=(end instanceof Date)?end.valueOf():end;}
return(start>=ourStart&&start<ourEnd||ourStart>=start&&ourStart<end);},contains:function(date){var start=this.start;var end=this.end;if(date instanceof Date){return start<=date&&end>=date;}else if(date instanceof Timespan){return start<=date.start&&end>=date.end;}else{return this.containsNumeric(date);}},containsNumeric:function(timestamp){var start=this.start;var end=this.end;return start<=timestamp&&end>=timestamp;}};return Timespan;}());;Calendar.TimeObserver=(function(){function TimeObserver(){this._timeObservers=[];}
TimeObserver.enhance=function(given){var key;var proto=TimeObserver.prototype;for(key in proto){if(proto.hasOwnProperty(key)){given[key]=proto[key];}}};TimeObserver.prototype={observeTime:function(timespan,callback){if(!(timespan instanceof Calendar.Timespan)){throw new Error('must pass an instance of Calendar.Timespan as first argument');}
this._timeObservers.push([timespan,callback]);},findTimeObserver:function(timespan,callback){var len=this._timeObservers.length;var idx=null;var field;var i=0;for(;i<len;i++){field=this._timeObservers[i];if(field[0]===timespan&&field[1]===callback){return i;}}
return-1;},removeTimeObserver:function(timespan,callback){var idx=this.findTimeObserver(timespan,callback);if(idx!==-1){this._timeObservers.splice(idx,1);return true;}else{return false;}},fireTimeEvent:function(type,start,end,data){var i=0;var len=this._timeObservers.length;var observer;var event={time:true,data:data,type:type};for(;i<len;i++){observer=this._timeObservers[i];if(observer[0].overlaps(start,end)){if(typeof(observer[1])==='object'){observer[1].handleEvent(event);}else{observer[1](event);}}}}};return TimeObserver;}());;Calendar.IntervalTree=(function(){function addOrdered(item,array){var idx=Calendar.binsearch.insert(array,item,Calendar.compare);array.splice(idx,0,item);}
const START='_startDateMS';const END='_endDateMS';function compareObjectStart(a,b){return Calendar.compare(a[START],b[START]);}
function compareObjectEnd(a,b){return Calendar.compare(a[END],b[END]);}
IntervalTree.compareObjectStart=compareObjectStart;IntervalTree.compareObjectEnd=compareObjectEnd;function buildEndpoints(item){addOrdered(item[START],this);addOrdered(item[END],this);}
function Node(){this.list=[];}
Node.prototype={left:null,right:null,list:null,median:null,max:null,traverse:function(span,fn){if(this.left&&(span.start<this.median)){this.left.traverse(span,fn);}
var i=0;var len=this.list.length;var item;for(;i<len;i++){item=this.list[i];if(item[START]>span.end){break;}
if(span.overlaps(item[START],item[END])){fn(item,this);}}
if(this.right&&span.end>this.median){this.right.traverse(span,fn);}},query:function(span){var results=[];var seen=Object.create(null);this.traverse(span,function(item){if(!seen[item._id]){results.push(item);}});return results;}};IntervalTree.Node=Node;function IntervalTree(list){if(typeof(list)==='undefined'){this.items=[];}else{this.items=list.concat([]);}
this._indexes=Object.create(null);this._indexOnAdd=[];this._indexOnRemove=[];this.byId=Object.create(null);this.synced=false;};IntervalTree.prototype={START:START,END:END,build:function(){if(!this.synced){this.rootNode=this._nodeFromList(this.items);this.synced=true;}},_getId:function(item){return item._id;},index:function(property,value){var items=this._indexes[property];if(items&&value)
return items[value];return items;},createIndex:function(property){var index=this._indexes[property]={};function addToIndex(object){var value=object[property];if(!index[value])
index[value]=[];index[value].push(object);}
function removeFromIndex(object){var value=object[property];var valueGroup=index[value];if(valueGroup){var idx=valueGroup.indexOf(object);valueGroup.splice(idx,1);if(valueGroup.length===0){delete index[value];}}}
this._indexOnAdd.push(addToIndex);this._indexOnRemove.push(removeFromIndex);},add:function(item){var id=this._getId(item);if(id in this.byId)
return;if(!item[START]&&item.startDate){item[START]=item.startDate.valueOf();}
if(!item[END]&&item.endDate){item[END]=item.endDate.valueOf();}
if(!item[START]||!item[END]){console.trace();console.log('(Calendar interval tree) invalid input skipping record',JSON.stringify(item));return;}
var idx=Calendar.binsearch.insert(this.items,item,compareObjectStart);this.items.splice(idx,0,item);this.byId[id]=item;this.synced=false;var len=this._indexOnAdd.length;for(var i=0;i<len;i++){this._indexOnAdd[i].call(this,item);}
return item;},indexOf:function(item){var query={};query[START]=item[START];var idx=Calendar.binsearch.find(this.items,query,compareObjectStart);var prevIdx;var current;if(idx!==null){if(idx>0){prevIdx=idx;while(prevIdx>-1){prevIdx--;current=this.items[prevIdx];if(current&&current[START]===item[START]){if(current===item){return prevIdx;}}else{break;}}}
current=this.items[idx];while(current){if(current===item){return idx;}
current=this.items[++idx];if(!current||current[START]!==item[START]){return null;}}}
return null;},remove:function(item){var idx=this.indexOf(item);if(idx!==null){this._removeIds(this.items[idx]);this.items.splice(idx,1);this.synced=false;return true;}
return false;},_removeIds:function(item){if(Array.isArray(item)){item.forEach(this._removeIds,this);}else{var len=this._indexOnRemove.length;for(var i=0;i<len;i++){this._indexOnRemove[i].call(this,item);}
var id=this._getId(item);delete this.byId[id];}},removeFutureIntervals:function(start){var query={};query[START]=start;var idx=Calendar.binsearch.insert(this.items,query,compareObjectStart);var max=this.items.length-1;if(!this.items[idx])
return;while(this.items[idx]&&this.items[idx][START]<=start){idx++;if(idx===max){break;}}
this.synced=false;var remove=this.items.splice(idx,this.items.length-idx);this._removeIds(remove);return remove;},removePastIntervals:function(end){var items=this.items.sort(compareObjectEnd);var endQuery={};endQuery[END]=end;var idx=Calendar.binsearch.insert(items,endQuery,compareObjectEnd);var max=items.length-1;if(!items[idx])
return;while(items[idx][END]<=end){idx++;if(idx===max){break;}}
this.synced=false;var remove=items.slice(0,idx);this.items=items.slice(idx).sort(compareObjectStart);this._removeIds(remove);return remove;},query:function(span){this.build();return this.rootNode.query(span);},_nodeFromList:function(list){var rootNode=new Node();var left=[];var right=[];var median;var endpoints=[];list.forEach(buildEndpoints,endpoints);median=rootNode.median=endpoints[Math.floor(endpoints.length/2)];list.forEach(function(item){if(item[END]<median){left.push(item);}else if(item[START]>median){right.push(item);}else{rootNode.list.push(item);}},this);if(left.length)
rootNode.left=this._nodeFromList(left);if(right.length)
rootNode.right=this._nodeFromList(right);return rootNode;}};return IntervalTree;}());;Calendar.ns('Provider').Abstract=(function(){function Abstract(options){var key;for(key in options){if(options.hasOwnProperty(key)){this[key]=options[key];}}}
Abstract.prototype={defaultColor:'#D2642A',useCredentials:false,useUrl:false,canSync:false,canExpandRecurringEvents:false,getAccount:function(account,callback){},findCalendars:function(){},syncEvents:function(account,calendar,callback){},ensureRecurrencesExpanded:function(date,callback){},updateEvent:function(event,busytime,callback){},deleteEvent:function(event,busytime,callback){},createEvent:function(event,callback){},calendarCapabilities:function(calendar){return{canCreateEvent:true,canUpdateEvent:true,canDeleteEvent:true};},eventCapabilities:function(event,callback){var caps=this.calendarCapabilities();Calendar.nextTick(function(){callback(null,{canCreate:caps.canCreateEvent,canUpdate:caps.canUpdateEvent,canDelete:caps.canDeleteEvent});});}};return Abstract;}());;Calendar.ns('Provider').Local=(function(){const LOCAL_CALENDAR_ID='local-first';function Local(){Calendar.Provider.Abstract.apply(this,arguments);this.events=this.app.store('Event');this.busytimes=this.app.store('Busytime');this.alarms=this.app.store('Alarm');}
Local.calendarId=LOCAL_CALENDAR_ID;Local.defaultCalendar=function(){var l10nId='calendar-local';var list={};var name;if('mozL10n'in window.navigator){name=window.navigator.mozL10n.get(l10nId);if(name===l10nId){name=null;}}
if(!name){name='Offline calendar';}
return{name:name,id:LOCAL_CALENDAR_ID,color:Local.prototype.defaultColor};};Local.prototype={__proto__:Calendar.Provider.Abstract.prototype,canExpandRecurringEvents:false,getAccount:function(account,callback){callback(null,{});},findCalendars:function(account,callback){var list={};list[LOCAL_CALENDAR_ID]=Local.defaultCalendar();callback(null,list);},syncEvents:function(account,calendar,cb){cb(null);},createEvent:function(event,callback){if(!event.remote.id){event.remote.id=uuid();}
var create=new Calendar.EventMutations.create({event:event});create.commit(function(err){if(err){callback(err);return;}
callback(null,create.busytime,create.event);});return create;},deleteEvent:function(event,busytime,callback){if(typeof(busytime)==='function'){callback=busytime;busytime=null;}
this.app.store('Event').remove(event._id,callback);},updateEvent:function(event,busytime,callback){if(typeof(busytime)==='function'){callback=busytime;busytime=null;}
var update=Calendar.EventMutations.update({event:event});update.commit(function(err){if(err){callback(err);return;}
callback(null,update.busytime,update.event);});return update;}};return Local;}());;Calendar.ns('Provider').Caldav=(function(){var _super=Calendar.Provider.Abstract.prototype;var CALDAV_ERROR_MAP={'caldav-authentication':'Authentication','caldav-invalid-entrypoint':'InvalidServer','caldav-server-failure':'ServerFailure'};function mapError(error,detail){var calError=CALDAV_ERROR_MAP[error.name];if(!calError){calError=new Calendar.Error(error.name,detail);}else{calError=new Calendar.Error[calError](detail);}
return calError;}
var Local=Calendar.Provider.Local.prototype;function CaldavProvider(){Calendar.Provider.Abstract.apply(this,arguments);this.service=this.app.serviceController;this.accounts=this.app.store('Account');this.busytimes=this.app.store('Busytime');this.events=this.app.store('Event');this.icalComponents=this.app.store('IcalComponent');}
CaldavProvider.prototype={__proto__:Calendar.Provider.Abstract.prototype,role:'caldav',useUrl:true,useCredentials:true,canSync:true,canExpandRecurringEvents:true,daysToSyncInPast:30,canCreateEvent:true,canUpdateEvent:true,canDeleteEvent:true,hasAccountSettings:true,_handleServiceError:function(rawErr,detail){var calendarErr=mapError(rawErr,detail);if(calendarErr instanceof Calendar.Error.Authentication||calendarErr instanceof Calendar.Error.InvalidServer){if(detail.account){if(detail.account._id){this.accounts.markWithError(detail.account,calendarErr);}}else{console.error('Permanent server error without an account!');}}
return calendarErr;},calendarCapabilities:function(calendar){var remote=calendar.remote;if(!remote.privilegeSet){return{canUpdateEvent:true,canDeleteEvent:true,canCreateEvent:true};}
var privilegeSet=remote.privilegeSet;var canWriteConent=privilegeSet.indexOf('write-content')!==-1;return{canUpdateEvent:canWriteConent,canCreateEvent:canWriteConent,canDeleteEvent:privilegeSet.indexOf('unbind')!==-1};},eventCapabilities:function(event,callback){if(event.remote.isRecurring){Calendar.nextTick(function(){callback(null,{canUpdate:false,canDelete:false,canCreate:false});});}else{var calendarStore=this.app.store('Calendar');calendarStore.get(event.calendarId,function(err,calendar){if(err){return callback(err);}
var caps=this.calendarCapabilities(calendar);callback(null,{canCreate:caps.canCreateEvent,canUpdate:caps.canUpdateEvent,canDelete:caps.canDeleteEvent});}.bind(this));}},getAccount:function(account,callback){if(this.bailWhenOffline(callback)){return;}
var self=this;this.service.request('caldav','getAccount',account,function(err,data){if(err){return callback(self._handleServiceError(err,{account:account}));}
callback(null,data);});},formatRemoteCalendar:function(calendar){if(!calendar.color)
calendar.color=this.defaultColor;return calendar;},findCalendars:function(account,callback){if(this.bailWhenOffline(callback)){return;}
var self=this;function formatCalendars(err,data){if(err){return callback(self._handleServiceError(err,{account:account}));}
if(data){for(var key in data){data[key]=self.formatRemoteCalendar(data[key]);}}
callback(err,data);}
this.service.request('caldav','findCalendars',account.toJSON(),formatCalendars);},_syncEvents:function(account,calendar,cached,callback){var startDate;if(!calendar.firstEventSyncDate){startDate=Calendar.Calc.createDay(new Date());calendar.firstEventSyncDate=new Date(startDate.valueOf());}else{startDate=new Date(calendar.firstEventSyncDate.valueOf());}
startDate.setDate(startDate.getDate()-this.daysToSyncInPast);var options={startDate:startDate,cached:cached};var stream=this.service.stream('caldav','streamEvents',account.toJSON(),calendar.remote,options);var pull=new Calendar.Provider.CaldavPullEvents(stream,{account:account,calendar:calendar});var calendarStore=this.app.store('Calendar');var syncStart=new Date();var self=this;stream.request(function(err){if(err){return callback(self._handleServiceError(err,{account:account,calendar:calendar}));}
var trans=pull.commit(function(commitErr){if(commitErr){callback(err);return;}
callback(null);});calendar.error=undefined;calendar.lastEventSyncToken=calendar.remote.syncToken;calendar.lastEventSyncDate=syncStart;calendarStore.persist(calendar,trans);});return pull;},_cachedEventsFor:function(calendar,callback){var store=this.app.store('Event');store.eventsForCalendar(calendar._id,function(err,results){if(err){callback(err);return;}
var list=Object.create(null);var i=0;var len=results.length;var item;for(;i<len;i++){item=results[i];list[item.remote.url]={syncToken:item.remote.syncToken,id:item._id};}
callback(null,list);});},syncEvents:function(account,calendar,callback){var self=this;if(this.bailWhenOffline(callback)){return;}
if(!calendar._id){throw new Error('calendar must be assigned an _id');}
if((calendar.lastEventSyncToken&&calendar.lastEventSyncToken===calendar.remote.syncToken)){Calendar.nextTick(callback);return;}
this._cachedEventsFor(calendar,function(err,results){if(err){callback(err);return;}
self._syncEvents(account,calendar,results,callback);});},ensureRecurrencesExpanded:function(maxDate,callback){var self=this;this.icalComponents.findRecurrencesBefore(maxDate,function(err,results){if(err){callback(err);return;}
if(!results.length){callback(null,false);return;}
var groups=Object.create(null);results.forEach(function(comp){var calendarId=comp.calendarId;if(!(calendarId in groups)){groups[calendarId]=[];}
groups[calendarId].push(comp);});var pullGroups=[];var pending=0;var options={maxDate:Calendar.Calc.dateToTransport(maxDate)};function next(err,pull){pullGroups.push(pull);if(!(--pending)){var trans=self.app.db.transaction(['icalComponents','alarms','busytimes'],'readwrite');trans.oncomplete=function(){callback(null,true);};trans.onerror=function(event){callback(event.result.error.name);};pullGroups.forEach(function(pull){pull.commit(trans);});}}
for(var calendarId in groups){pending++;self._expandComponents(calendarId,groups[calendarId],options,next);}});},_expandComponents:function(calendarId,comps,options,callback){var calStore=this.app.store('Calendar');calStore.ownersOf(calendarId,function(err,owners){if(err){return callback(err);}
var calendar=owners.calendar;var account=owners.account;var stream=this.service.stream('caldav','expandComponents',comps,options);var pull=new Calendar.Provider.CaldavPullEvents(stream,{account:account,calendar:calendar,app:this.app,stores:['busytimes','alarms','icalComponents']});stream.request(function(err){if(err){callback(err);return;}
callback(null,pull);});}.bind(this));},createEvent:function(event,busytime,callback){if(typeof(busytime)==='function'){callback=busytime;busytime=null;}
if(this.bailWhenOffline(callback)){return;}
this.events.ownersOf(event,fetchOwners);var self=this;var calendar;var account;function fetchOwners(err,owners){calendar=owners.calendar;account=owners.account;self.service.request('caldav','createEvent',account,calendar.remote,event.remote,handleRequest);}
function handleRequest(err,remote){if(err){return callback(self._handleServiceError(err,{account:account,calendar:calendar}));}
var event={_id:calendar._id+'-'+remote.id,calendarId:calendar._id};var component={eventId:event._id,ical:remote.icalComponent}
delete remote.icalComponent;event.remote=remote;var create=Calendar.EventMutations.create({event:event,icalComponent:component});create.commit(function(err){if(err){callback(err);return;}
callback(null,create.busytime,create.event);});}},updateEvent:function(event,busytime,callback){if(typeof(busytime)==='function'){callback=busytime;busytime=null;}
if(this.bailWhenOffline(callback)){return;}
this.events.ownersOf(event,fetchOwners);var self=this;var calendar;var account;function fetchOwners(err,owners){calendar=owners.calendar;account=owners.account;self.icalComponents.get(event._id,fetchComponent);}
function fetchComponent(err,ical){if(err){callback(err);return;}
var details={event:event.remote,icalComponent:ical.ical};self.service.request('caldav','updateEvent',account,calendar.remote,details,handleUpdate);}
var self=this;function handleUpdate(err,remote){if(err){callback(self._handleServiceError(err,{account:account,calendar:calendar}));return;}
var component={eventId:event._id,ical:remote.icalComponent}
delete remote.icalComponent;event.remote=remote;var update=Calendar.EventMutations.update({event:event,icalComponent:component});update.commit(function(err){if(err){callback(err);return;}
callback(null,update.busytime,update.event);});}},deleteEvent:function(event,busytime,callback){if(typeof(busytime)==='function'){callback=busytime;busytime=null;}
if(this.bailWhenOffline(callback)){return;}
this.events.ownersOf(event,fetchOwners);var calendar;var account;var self=this;function fetchOwners(err,owners){calendar=owners.calendar;account=owners.account;self.service.request('caldav','deleteEvent',account,calendar.remote,event.remote,handleRequest);}
var self=this;function handleRequest(err){if(err){callback(self._handleServiceError(err,{account:account,calendar:calendar}));return;}
Local.deleteEvent.call(self,event,busytime,callback);}},bailWhenOffline:function(callback){if(!this.offlineMessage&&'mozL10n'in window.navigator){this.offlineMessage=window.navigator.mozL10n.get('error-offline');}
var ret=this.app.offline()&&callback;if(ret){var error=new Error();error.name='offline';error.message=this.offlineMessage;callback(error);}
return ret;}};return CaldavProvider;}());;Calendar.ns('Provider').CaldavPullEvents=(function(){var Calc=Calendar.Calc;var debug=Calendar.debug('pull events');function PullEvents(stream,options){if(options.calendar){this.calendar=options.calendar;}else{throw new Error('.calendar option must be given');}
if(options.account){this.account=options.account;}else{throw new Error('.account option must be given');}
if(options.app){this.app=options.app;}else{this.app=Calendar.App;}
stream.on('event',this);stream.on('component',this);stream.on('occurrence',this);stream.on('missingEvents',this);this.icalQueue=[];this.eventQueue=[];this.busytimeQueue=[];this.alarmQueue=[];this._busytimeStore=this.app.store('Busytime');this._accountStore=this.app.store('Account');this._accountStore.on('remove',this._onRemoveAccount.bind(this));this._aborted=false;this._trans=null;}
PullEvents.prototype={eventQueue:null,busytimeQueue:null,busytimeIdFromRemote:function(busytime){var eventId=this.eventIdFromRemote(busytime,!busytime.isException);return busytime.start.utc+'-'+
busytime.end.utc+'-'+
eventId;},eventIdFromRemote:function(event,ignoreException){var id=event.eventId||event.id;if(!ignoreException&&event.recurrenceId){id+='-'+event.recurrenceId.utc;}
return this.calendar._id+'-'+id;},formatEvent:function(event){var id=this.eventIdFromRemote(event,true);var result=Object.create(null);result.calendarId=this.calendar._id;result.remote=event;if(event.recurrenceId){result.parentId=id;result._id=this.eventIdFromRemote(event);}else{result._id=id;}
return result;},formatBusytime:function(time){var eventId=this.eventIdFromRemote(time,!time.isException);var id=eventId+'-'+uuid.v4();var calendarId=this.calendar._id;time._id=id;time.calendarId=calendarId;time.eventId=eventId;if(time.alarms){var i=0;var len=time.alarms.length;var alarm;for(;i<len;i++){alarm=time.alarms[i];alarm.eventId=eventId;alarm.busytimeId=id;}}
return this._busytimeStore.initRecord(time);},handleOccurrenceSync:function(item){var alarms;if('alarms'in item){alarms=item.alarms;delete item.alarms;if(alarms.length){var i=0;var len=alarms.length;var now=Date.now();for(;i<len;i++){var alarm={startDate:{},eventId:item.eventId,busytimeId:item._id};for(var j in item.start){alarm.startDate[j]=item.start[j];}
alarm.startDate.utc+=(alarms[i].trigger*1000);var alarmDate=Calc.dateFromTransport(item.end);if(alarmDate.valueOf()<now){continue;}
this.alarmQueue.push(alarm);}}}
this.app.timeController.cacheBusytime(item);this.busytimeQueue.push(item);},handleComponentSync:function(component){component.eventId=this.eventIdFromRemote(component);component.calendarId=this.calendar._id;if(!component.lastRecurrenceId){delete component.lastRecurrenceId;}
this.icalQueue.push(component);},handleEventSync:function(event){var exceptions=event.remote.exceptions;delete event.remote.exceptions;var id=event._id;var token=event.remote.syncToken;this._busytimeStore.removeEvent(id);this.app.timeController.removeCachedEvent(event._id);this.app.timeController.cacheEvent(event);this.eventQueue.push(event);var component=event.remote.icalComponent;delete event.remote.icalComponent;if(!event.remote.recurrenceId){this.icalQueue.push({data:component,eventId:event._id});}
if(exceptions){for(var i=0;i<exceptions.length;i++){this.handleEventSync(this.formatEvent(exceptions[i]));}}},_onRemoveAccount:function(id){if(id===this.account._id){this.abort();}},abort:function(){if(this._aborted){return;}
this._aborted=true;if(this._trans){this._trans.abort();}},handleEvent:function(event){if(this._aborted){return;}
var data=event.data;switch(event.type){case'missingEvents':this.removeList=data[0];break;case'occurrence':var occur=this.formatBusytime(data[0]);this.handleOccurrenceSync(occur);break;case'component':this.handleComponentSync(data[0]);break;case'event':var event=this.formatEvent(data[0]);this.handleEventSync(event);break;}},commit:function(trans,callback){var eventStore=this.app.store('Event');var icalComponentStore=this.app.store('IcalComponent');var calendarStore=this.app.store('Calendar');var busytimeStore=this.app.store('Busytime');var alarmStore=this.app.store('Alarm');if(typeof(trans)==='function'){callback=trans;trans=calendarStore.db.transaction(['calendars','events','busytimes','alarms','icalComponents'],'readwrite');}
if(this._aborted){return callback&&callback(null);}
var calendar=this.calendar;var account=this.account;this._trans=trans;var self=this;this.eventQueue.forEach(function(event){debug('add event',event);eventStore.persist(event,trans);});this.icalQueue.forEach(function(ical){debug('add component',ical);icalComponentStore.persist(ical,trans);});this.busytimeQueue.forEach(function(busy){debug('add busytime',busy);busytimeStore.persist(busy,trans);});this.alarmQueue.forEach(function(alarm){debug('add alarm',alarm);alarmStore.persist(alarm,trans);});if(this.removeList){this.removeList.forEach(function(id){eventStore.remove(id,trans);});}
function handleError(e){if(e&&e.type!=='abort'){console.error('Error persisting sync results',e);}
if(e&&e.preventDefault){e.preventDefault();}
self._trans=null;callback&&callback(e);}
trans.addEventListener('error',handleError);trans.addEventListener('abort',handleError);trans.addEventListener('complete',function(){self._trans=null;callback&&callback(null);});return trans;}};return PullEvents;}());;Calendar.ns('Views').CalendarColors=(function(){function Colors(){this.colorMap=Object.create(null);this._ruleMap=Object.create(null);var sheet=document.createElement('style');sheet.type='text/css';sheet.id='_dynamic-calendar-styles';document.head.appendChild(sheet);this._styles=document.styleSheets[document.styleSheets.length-1];this._initEvents();}
Colors.prototype={__proto__:Calendar.View.prototype,_initEvents:function(){var store=Calendar.App.store('Calendar');store.on('persist',this);store.on('remove',this);store.on('preRemove',this);},handleEvent:function(e){switch(e.type){case'persist':this.updateRule(e.data[1]);break;case'preRemove':this.hideCalendar(e.data[0]);break;case'remove':this.removeRule(e.data[0]);break;}},render:function(){var calendarStore=Calendar.App.store('Calendar');calendarStore.all(function(err,calendars){if(err){console.log('Error fetch calendars in CalendarColors');}
var id;for(id in calendars){this.updateRule(calendars[id]);}
if(this.onrender){this.onrender();}}.bind(this));},getId:function(item){var id;if(item instanceof Calendar.Models.Calendar){id=item._id;}else{id=item;}
return this.calendarId(String(id));},hideCalendar:function(id){this.updateRule({_id:id,localDisplayed:false,color:'#CCC'});},updateRule:function(calendar){var id=this.getId(calendar);var styles=this.colorMap[id];var color=calendar.color;var rules=this._styles.cssRules;var map;if(id in this.colorMap){map=this._ruleMap[id];var bgStyle=map.bg.style;var displayStyle=map.display.style;bgStyle.backgroundColor=color;bgStyle.borderColor=color;if(!calendar.localDisplayed){displayStyle.setProperty('display','none');}else{displayStyle.setProperty('display','inherit','important');}}else{var ruleId=this._styles.cssRules.length;var ruleIds=[ruleId,ruleId+1];this.colorMap[id]=color;map=this._ruleMap[id]={ruleIds:ruleIds};var bgBlock='.'+id+'.calendar-color ';bgBlock+='{';bgBlock+='  background-color: '+color+';';bgBlock+='  border-color: '+color+';';bgBlock+='}';this._styles.insertRule(bgBlock,ruleId);map.bg=rules[ruleId];ruleId+=1;var displayBlock='.'+id+'.calendar-display';if(!calendar.localDisplayed){displayBlock+='{ display: none; }';}else{displayBlock+='{ display: inherit; }';}
this._styles.insertRule(displayBlock,ruleId);map.display=rules[ruleId];}},_adjustRuleIds:function(above){var key;function subtract(item){if(item>above){return item-1;}
return item;}
for(key in this._ruleMap){var map=this._ruleMap[key];map.ruleIds=map.ruleIds.map(subtract);}},removeRule:function(id){var map;var idOffset=0;id=this.getId(id);if(id in this.colorMap){delete this.colorMap[id];map=this._ruleMap[id];delete this._ruleMap[id];map.ruleIds.forEach(function(idx){this._adjustRuleIds(idx);idx=idx-idOffset;this._styles.deleteRule(idx);idOffset+=1;},this);}}};return Colors;}());;Calendar.ns('Views').TimeHeader=(function(){'use strict';var SETTINGS=/settings/;function TimeHeader(){Calendar.View.apply(this,arguments);this.controller=this.app.timeController;this.controller.on('scaleChange',this);this.settings.addEventListener('click',function settingsClick(e){e.stopPropagation();var path=window.location.pathname;if(SETTINGS.test(path)){Calendar.App.resetState();}else{Calendar.App.router.show('/settings/');}});}
TimeHeader.prototype={__proto__:Calendar.View.prototype,selectors:{element:'#time-header',title:'#time-header h1',settings:'#time-header .settings'},scales:{month:'month-view-header-format',day:'day-view-header-format',multiMonth:'multi-month-view-header-format'},handleEvent:function(e){switch(e.type){case'yearChange':case'monthChange':case'dayChange':case'weekChange':this._updateTitle();break;case'scaleChange':this._updateScale.apply(this,e.data);break;}},get settings(){return this._findElement('settings');},get title(){return this._findElement('title');},_scaleEvent:function(event){switch(event){case'month':return'monthChange';case'year':return'yearChange';case'week':return'weekChange';}
return'dayChange';},_updateScale:function(newScale,oldScale){if(oldScale){this.controller.removeEventListener(this._scaleEvent(oldScale),this);}
this.controller.addEventListener(this._scaleEvent(newScale),this);this._updateTitle();},getScale:function(type){var position=this.controller.position;if(type==='week'){var lastWeekday=this._getLastWeekday();if(position.getMonth()!==lastWeekday.getMonth()){return this._localeFormat(position,'multiMonth')+' '+
this._localeFormat(lastWeekday,'multiMonth');}
type='month';}
return this._localeFormat(position,type||'month');},_getLastWeekday:function(){var position=this.controller.position;var weekday=position.getDay();var diff=((weekday<=3)?3:6)-weekday;return new Date(position.getFullYear(),position.getMonth(),position.getDate()+diff);},_localeFormat:function(date,scale){return this.app.dateFormat.localeFormat(date,navigator.mozL10n.get(this.scales[scale]));},_updateTitle:function(){var con=this.app.timeController;var title=this.title;title.dataset.l10nDateFormat=this.scales[con.scale]||this.scales.month;title.dataset.date=con.position.toString();title.textContent=this.getScale(con.scale);},render:function(){this._updateScale(this.controller.scale);}};return TimeHeader;}());;(function(window){var Month=Calendar.Template.create({busy:function(){return'<span class="'+'busytime-'+this.h('_id')+' busy-length-'+this.h('length')+' busy-'+this.h('start')+' calendar-id-'+this.h('calendarId')+' calendar-color calendar-display'+'">'+'&nbsp;'+'</span>';},weekDaysHeader:function(){return'<header id="month-days">'+'<ol role="row">'+
this.s('value')+'</ol>'+'</header>';},weekDaysHeaderDay:function(){return'<li data-l10n-id="weekday-'+this.h('day')+'-short">'+
this.h('dayName')+'</li>';},week:function(){return'<ol role="row">'+
this.s('value')+'</ol>';},day:function(){return'<li id="'+this.s('id')+'" data-date="'+this.s('dateString')+'" class="'+this.s('state')+'">'+'<span class="day">'+this.h('date')+'</span>'+'<div class="busy-indicator">'+this.s('busy')+'</div>'+'</li>';}});Calendar.ns('Templates').Month=Month;}(this));;(function(window){var Day=Calendar.Template.create({hour:function(){var hour=this.h('hour');var l10n='';var displayHour;if(hour===Calendar.Calc.ALLDAY){l10n=' data-l10n-id="hour-allday" ';displayHour=navigator.mozL10n.get('hour-allday');}else{displayHour=this.h('displayHour');}
var classes=['hour','hour-'+hour,this.h('classes'),'calendar-display'].join(' ');return'<section class="'+classes+'" data-hour="'+hour+'">'+'<h4>'+'<span '+l10n+'class="display-hour '+hour+'">'+
displayHour+'</span>'+'</h4>'+'<div class="events">'+this.s('items')+'</div>'+'</section>';},attendee:function(){return'<span class="attendee">'+this.h('value')+'</span>';},event:function(){var calendarId=this.h('calendarId');return'<section class="event calendar-id-'+calendarId+' '+
this.h('classes')+' calendar-display" '+'data-id="'+this.h('busytimeId')+'">'+'<div class="container calendar-id-'+calendarId+' calendar-color">'+'<h5>'+this.h('title')+'</h5>'+'<span class="details">'+'<span class="location">'+
this.h('location')+'</span>'+
this.s('attendees')+'</span>'+'</div>'+'</section>';}});Day.eventSelector='.event';Day.hourEventsSelector='.events';Calendar.ns('Templates').Day=Day;}(this));;(function(window){var template=Calendar.Templates.Month;var Calc=Calendar.Calc;window.addEventListener('localized',function clearHeaderCache(){Child._dayHeaders=null;});function Child(){Calendar.View.apply(this,arguments);this.id=this.date.valueOf();this.controller=this.app.timeController;this._days=Object.create(null);this.timespan=Calc.spanOfMonth(this.date);var daysInWeek=Calc.daysInWeek();}
Child.prototype={__proto__:Calendar.View.prototype,ACTIVE:'active',hasBeenActive:false,busyPrecision:(24/12),get element(){return this._element;},set element(val){return this._element=val;},_dayId:function(date){if(date instanceof Date){date=Calc.getDayId(date);}
return'month-view-'+this.id+'-'+date;},_initEvents:function(){this.controller.observeTime(this.timespan,this);},_destroyEvents:function(){this.controller.removeTimeObserver(this.timespan,this);},handleEvent:function(event){switch(event.type){case'add':this._renderBusytime(event.data);break;case'remove':this._removeBusytimes([event.data]);break;}},_hourToBusyUnit:function(hour){return Math.ceil(hour/this.busyPrecision)||1;},_busyBlockFromRecord:function(record){var startDate=record.startDate;var endDate=record.endDate;var start;var end;var startDateDay=startDate.getDate();var endDateDay=endDate.getDate();var distance=endDateDay-startDateDay;if(distance>1){start=1;end=12;}else{start=this._hourToBusyUnit(startDate.getHours());if(distance===1){end=12;}else{}}
var out=template.busy.render({_id:this.cssClean(record._id),calendarId:record.calendarId,start:start,length:((end-start)||0)+1});return out;},_removeBusytimes:function(objects){var el=this.element;objects.forEach(function(item){var className='.busytime-'+this.cssClean(item._id);var elements=el.querySelectorAll(className);var i=0;var len=elements.length;var instance;for(;i<len;i++){instance=elements[i];instance.parentNode.removeChild(instance);}},this);},_renderDay:function _renderDay(date){var month=Calc.today.getMonth(),id=Calc.getDayId(date),state,units,busytimes=this.app.store('Busytime');state=Calc.relativeState(date,this.date);this._days[id]=null;return template.day.render({id:this._dayId(id),dateString:id,state:state,date:date.getDate()});},_renderWeek:function _renderWeek(days){var output='';for(var i=0,iLen=days.length;i<iLen;i++){output+=this._renderDay(days[i]);}
return template.week.render(output);},_renderDayHeaders:function _renderDayHeaders(){if(!Child._dayHeaders){var i=0;var days=7;var name;var html='';for(;i<days;i++){var day=i;if(Calendar.Calc.startsOnMonday){day+=1;if(day===7){day=0;}}
var l10n='weekday-'+day+'-short';name=navigator.mozL10n.get(l10n);html+=template.weekDaysHeaderDay.render({day:String(day),dayName:name});}
Child._dayHeaders=template.weekDaysHeader.render(html);return Child._dayHeaders;}
return Child._dayHeaders;},_busyElement:function(stringId){var id;var found;if(typeof(stringId)!=='string'){stringId=Calc.getDayId(stringId);}
id=this._dayId(stringId);found=this.element.querySelector('#'+id+' .busy-indicator');return this._days[stringId]=found;},_renderMonth:function _renderMonth(){var id=Calc.getDayId(this.date);var weekList=[];var week=0;var slice;var days=this.timespan.daysBetween();var daysInWeek=Calc.daysInWeek();var numberOfWeeks=days.length/daysInWeek;var html='';this.weeks=numberOfWeeks;for(week;week<=numberOfWeeks;week++){slice=days.splice(0,daysInWeek);if(slice.length)
html+=this._renderWeek(slice);}
return this._renderDayHeaders()+html;},_calculateBusytime:function(day,busytime){var startSame;var record={_id:this.cssClean(busytime._id),eventId:busytime.eventId,calendarId:busytime.calendarId};if(Calc.isSameDate(day,busytime.startDate)){startSame=true;record.start=this._hourToBusyUnit(busytime.startDate.getHours());}else{startSame=false;record.start=1;}
if(Calc.isSameDate(day,busytime.endDate)){if(!startSame&&day.valueOf()===busytime.endDate.valueOf()){return false;}
var end=this._hourToBusyUnit(busytime.endDate.getHours());record.length=((end-record.start)||0)+1;}else{record.length=12;}
return record;},_addBusytime:function(date,busytime){var element=this._busyElement(date);var data=this._calculateBusytime(date,busytime);if(data){element.insertAdjacentHTML('afterbegin',template.busy.render(data));}},_renderBusytime:function(busytime){var span=this.timespan;var start=busytime.startDate;var end=busytime.endDate;if(Calc.isSameDate(start,end)){return this._addBusytime(start,busytime);}
if(busytime.startDate.valueOf()<span.start){start=new Date(span.start);}
if(busytime.endDate.valueOf()>span.end){end=new Date(span.end);}
var days=Calc.daysBetween(start,end);var i=0;var len=days.length;var day;var dayValue;for(;i<len;i++){day=days[i];dayValue=day.valueOf();if(dayValue<this.timespan.start){continue;}
if(dayValue>this.timespan.end){break;}
this._addBusytime(day,busytime);}},activate:function(){this.element.classList.add(this.ACTIVE);if(this.hasBeenActive)
return;Calendar.nextTick(function(){this.controller.queryCache(this.timespan).forEach(this._renderBusytime,this);this._initEvents();}.bind(this));this.hasBeenActive=true;},deactivate:function(){this.element.classList.remove(this.ACTIVE);},create:function(){var html=this._renderMonth();var controller=this.controller;var element=document.createElement('section');element.classList.add('month');element.innerHTML=html;this.element=element;return element;},destroy:function(){this._destroyEvents();this._days=Object.create(null);if(this.element&&this.element.parentNode){this.element.parentNode.removeChild(this.element);this.element=undefined;}},getScrollTop:function(){},setScrollTop:function(scrollTop){}};Calendar.ns('Views').MonthChild=Child;}(this));;Calendar.ns('Utils').OrderedMap=(function(){function OrderedMap(list,compare){if(typeof(compare)==='undefined'){compare=Calendar.compare;}
this.compare=function(a,b){return compare(a[0],b[0]);};if(list){this.items=list.sort(this.compare);}else{this.items=[];}};OrderedMap.prototype={has:function(value){var idx=this.indexOf(value);return this.indexOf(value)!==null;},insertIndexOf:function(value){return Calendar.binsearch.insert(this.items,[value],this.compare);},previous:function(key){var idx=this.indexOf(key);if(idx!==null&&this.items[idx-1]){return this.items[idx-1][1];}
return null;},next:function(key){var idx=this.indexOf(key);if(idx!==null&&this.items[idx+1]){return this.items[idx+1][1];}
return null;},indexOf:function(value){return Calendar.binsearch.find(this.items,[value],this.compare);},set:function(key,value){var arr=[key,value];var idx=Calendar.binsearch.insert(this.items,arr,this.compare);var prev=this.items[idx];var remove=0;if(prev&&prev[0]===key){remove=1;}
this.items.splice(idx,remove,arr);return value;},get:function(item){if(typeof(item)==='undefined'){throw new Error('cannot search "undefined" values');}
var idx=this.indexOf(item);if(idx!==null){return this.items[idx][1];}
return null;},remove:function(key){var idx=this.indexOf(key);if(idx!==null){this.items.splice(idx,1);}},get length(){return this.items.length;}};return OrderedMap;}());;Calendar.ConflictSpan=(function(){var MIN_SPLIT_INTERVAL=5*60*1000;var _id=0;function ConflictSpan(parent){this.id=(_id++);this.parent=parent;this.startTime=null;this.endTime=null;this.all=new Calendar.IntervalTree();this.columnsByID={};this.columns=[];this.addColumn();};ConflictSpan.prototype={getIDs:function(){return Object.keys(this.all.byId);},addColumn:function(){var tree=new Calendar.IntervalTree();this.columns.push(tree);return tree;},findColumn:function(busytime,skipAdd){var column=null;var span=new Calendar.Timespan(busytime._startDateMS,busytime._endDateMS);for(var i=0;i<this.columns.length;i++){var curr=this.columns[i];if(!curr.query(span).length){column=curr;break;}}
if(!column&&!skipAdd){column=this.addColumn();}
return column;},add:function(busytime){var id=busytime._id;this.parent.conflicts[id]=this;this.all.add(busytime);var column=this.findColumn(busytime);column.add(busytime);this.columnsByID[id]=column;this._updateTimes(busytime);this._updateLayout();return this;},remove:function(busytime,skipMaintenance){var id=busytime._id;this.all.remove(busytime);var column=this.columnsByID[id];if(!column){return;}
column.remove(busytime);delete this.columnsByID[id];delete this.parent.conflicts[id];if(skipMaintenance){return this;}
this._splitIfNecessary();var boom=this._selfDestructIfNecessary();if(!boom){this._resetTimes();this._purgeEmptyColumns();this._updateLayout();}
return this;},absorb:function(otherCS){var self=this;var otherIDs=otherCS.getIDs();otherIDs.forEach(function(otherID){var otherBusytime=self.parent.tree.byId[otherID];self.add(otherBusytime);});},_updateTimes:function(busytime){var start=busytime._startDateMS;if(null===this.startTime||start<this.startTime){this.startTime=start;}
var end=busytime._endDateMS;if(null===this.endTime||end>this.endTime){this.endTime=end;}},_resetTimes:function(){this.startTime=this.endTime=null;var byId=this.all.byId;for(var k in byId){this._updateTimes(byId[k]);}},_splitIfNecessary:function(){var start=this.startTime;var end=this.endTime;var splitAt=false;var prevHits=null;for(var top=start;top<end;top+=MIN_SPLIT_INTERVAL){var span=new Calendar.Timespan(top,top+MIN_SPLIT_INTERVAL);var hits=this.all.query(span).length;if(0===prevHits&&hits>0){splitAt=top;break;}
prevHits=hits;}
if(splitAt===false){return;}
var newItems=[];var splitSpan=new Calendar.Timespan(splitAt,Infinity);var splitItems=this.all.query(splitSpan);var self=this;splitItems.forEach(function(item){self.remove(item,true);newItems.push(item);});var boom=this._selfDestructIfNecessary();if(!boom){this._resetTimes();this._purgeEmptyColumns();this._updateLayout();}
if(newItems.length==1){this.parent._clearLayout(newItems[0]);return;}
var newCS=new Calendar.ConflictSpan(this.parent);newItems.forEach(function(item){newCS.add(item);});newCS._splitIfNecessary();},_selfDestructIfNecessary:function(){var keys=this.getIDs();if(keys.length>1){return false;}
if(keys.length==1){var busytime=this.all.byId[keys[0]];this.remove(busytime,true);this.parent._clearLayout(busytime);}
return true;},_purgeEmptyColumns:function(){var newColumns=[];for(var i=0;i<this.columns.length;i++){var column=this.columns[i];if(Object.keys(column.byId).length>0){newColumns.push(column);}}
this.columns=newColumns;},_updateLayout:function(){var numCols=this.columns.length;var width=(100/numCols);for(var cIdx=0;cIdx<numCols;cIdx++){var column=this.columns[cIdx];for(var k in column.byId){var busytime=column.byId[k];var el=this.parent.getElement(busytime);el.style.width=width+'%';el.style.left=(width*cIdx)+'%';}}}};return ConflictSpan;}());Calendar.ns('Utils').Overlap=(function(){function Overlap(){this.reset();};Overlap.prototype={reset:function(){this.tree=new Calendar.IntervalTree();this.conflicts={};this.elements={};},add:function(myBusytime,element){this.tree.add(myBusytime);this.elements[myBusytime._id]=element;var related=this._findRelated(myBusytime);if(0===related.length)return;var myID=myBusytime._id;var myCS=this.conflicts[myID];var self=this;related.forEach(function(otherBusytime){var otherID=otherBusytime._id;if(otherID==myID)return;var otherCS=self.conflicts[otherID];if(!myCS&&!otherCS){myCS=new Calendar.ConflictSpan(self);myCS.add(myBusytime).add(otherBusytime);}else if(myCS&&!otherCS){myCS.add(otherBusytime);}else if(!myCS&&otherCS){myCS=otherCS.add(myBusytime);}else if(myCS&&otherCS&&myCS!=otherCS){myCS.absorb(otherCS);}});},remove:function(busytime){this._clearLayout(busytime);this.tree.remove(busytime);delete this.elements[busytime._id];var myID=busytime._id;var myCS=this.conflicts[myID];if(myCS){myCS.remove(busytime);}},getConflictSpan:function(busytime){var id=this._busytimeId(busytime);return this.conflicts[id];},getElement:function(busytime){var id=this._busytimeId(busytime);return this.elements[id];},_busytimeId:function(busytime){return(typeof(busytime)==='string')?busytime:busytime._id;},_findRelated:function(busytime){var span=new Calendar.Timespan(busytime._startDateMS,busytime._endDateMS);return this.tree.query(span);},_clearLayout:function(busytime){var el=this.elements[busytime._id];el.style.width='';el.style.left='';}};return Overlap;}());;Calendar.ns('Views').TimeParent=(function(){var XSWIPE_OFFSET=window.innerWidth/10;function TimeParent(){Calendar.View.apply(this,arguments);this.frames=new Calendar.Utils.OrderedMap();this._initEvents();}
TimeParent.prototype={__proto__:Calendar.View.prototype,maxFrames:5,get frameContainer(){return this.element;},_initEvents:function(){this.app.timeController.on('purge',this);this.element.addEventListener('swipe',this);this.gd=new GestureDetector(this.element);this.gd.startDetecting();},_onswipe:function(data){if(Math.abs(data.dy)>(Math.abs(data.dx)-XSWIPE_OFFSET)){return false;}
var dir=data.direction;var controller=this.app.timeController;if(dir==='left'){controller.move(this._nextTime(this.date));}else{controller.move(this._previousTime(this.date));}
return true;},handleEvent:function(e){switch(e.type){case'swipe':this._onswipe(e.detail);break;case'purge':this.purgeFrames(e.data[0]);break;}},_createFrame:function(date){var child=new this.childClass({app:this.app,date:date});child.create();return child;},_nextTime:function(){},_previousTime:function(){},_getId:function(date){return date.valueOf();},_trimFrames:function(){var frames=this.frames;var keep;if(frames.length>this.maxFrames){var idx=frames.indexOf(this.currentFrame.id);idx=(idx-1)||0;keep=frames.items.splice(idx,3);var deleteFrames=frames.items;idx=0;var len=deleteFrames.length;for(;idx<len;idx++){deleteFrames[idx][1].destroy();}
frames.items=keep;}},addFrame:function(date){var frame;var id=this._getId(date);var frame=this.frames.get(id);if(!frame){frame=this._createFrame(date);this.frames.set(id,frame);this.frameContainer.appendChild(frame.element);}
return frame;},changeDate:function(time){var prevScrollTop=0;if(this.currentFrame){prevScrollTop=this.currentFrame.getScrollTop();this.currentFrame.deactivate();}
this.date=time;var next=this._nextTime(time);var prev=this._previousTime(time);prev=this.addFrame(prev);var cur=this.currentFrame=this.addFrame(time);cur.activate();cur.setScrollTop(prevScrollTop);this.addFrame(next);this._trimFrames();},purgeFrames:function(span){var key;var child;var i=0;var len=this.frames.length;var offset=0;for(;i<len;i++){child=this.frames.items[i-offset][1];if(span.contains(child.timespan)){if(this.currentFrame===child){this.currentFrame=null;}
child.destroy();this.frames.items.splice(i-offset,1);offset+=1;}}},onactive:function(){Calendar.View.prototype.onactive.apply(this,arguments);if(this.app&&this.scale){this.app.timeController.scale=this.scale;}}};return TimeParent;}());;Calendar.ns('Views').DayBased=(function(){'use strict';var Calc=Calendar.Calc;var hoursOfOccurance=Calendar.Calc.hoursOfOccurance;var OrderedMap=Calendar.Utils.OrderedMap;const MINUTES_IN_HOUR=60;function DayBased(){Calendar.View.apply(this,arguments);if(!this.timespan&&this.date){this.timespan=Calc.spanOfDay(this.date);}
this._resetHourCache();this.controller=this.app.timeController;}
DayBased.prototype={__proto__:Calendar.View.prototype,_changeToken:0,classType:'day-events',outsideAllDay:true,renderAllHours:true,template:Calendar.Templates.Day,date:null,timespan:null,hours:null,_idsToHours:null,get element(){return this._element;},get events(){return this._eventsElement;},_resetHourCache:function(){this._idsToHours=Object.create(null);this.overlaps=new Calendar.Utils.Overlap();this.hours=new OrderedMap([],Calc.compareHours);},_removeTimespanObserver:function(){if(this.timespan){this.controller.removeTimeObserver(this.timespan,this);}},_loadRecords:function(busytimes){busytimes=(Array.isArray(busytimes))?busytimes:[busytimes];var token=this._changeToken;var self=this;this.controller.findAssociated(busytimes,function(err,list){if(self._changeToken!==token){return;}
list.forEach(function(record){this.add(record.busytime,record.event);},self);});},_createRecord:function(hour,busytime,record){var hourRecord=this.hours.get(hour);var id=busytime._id;if(!hourRecord){hourRecord=this.createHour(hour);}
if(!record){throw new Error('must pass a event');}
var eventRecord=true;if(id in this._idsToHours){this._idsToHours[id].push(hour);}else{this._idsToHours[id]=[hour];var html=this._renderEvent(busytime,record);var eventArea=hourRecord.element;if(this.template.hourEventsSelector){eventArea=eventArea.querySelector(this.template.hourEventsSelector);}
eventArea.insertAdjacentHTML('beforeend',html);var el=eventArea.lastChild;if(hour!==Calendar.Calc.ALLDAY){this._assignPosition(busytime,el);this.overlaps.add(busytime,el);}else{eventRecord={element:el};}}
var calendarId=this.calendarId(busytime);hourRecord.flags.push(calendarId);hourRecord.element.classList.add(calendarId);return hourRecord.records.set(id,eventRecord);},_insertElement:function(html,element,records,idx){var el;if(!element.children.length||idx===0){element.insertAdjacentHTML('afterbegin',html);el=element.firstChild;}else{var lastElement=records[idx-1][1];lastElement.element.insertAdjacentHTML('afterend',html);el=lastElement.element.nextElementSibling;}
return el;},_assignPosition:function(busytime,element){var start=busytime.startDate;var end=busytime.endDate;var startMin=0;var startHour=0;if(Calendar.Calc.isSameDate(this.date,busytime.startDate)){startMin=start.getMinutes();startHour=start.getHours();}
var endMin=59;var endHour=23;var isSameDateWithEndDate=Calendar.Calc.isSameDate(this.date,busytime.endDate);if(isSameDateWithEndDate){endHour=end.getHours();endMin=end.getMinutes();}
var offsetPercent=(startMin/MINUTES_IN_HOUR)*100;if(offsetPercent){element.style.top=String(offsetPercent)+'%';}
var hoursDuration=(endHour-startHour)+
((endMin-startMin)/MINUTES_IN_HOUR);var elementHeight=hoursDuration;if(hoursDuration<1){if(isSameDateWithEndDate){element.className+=' partial-hour';}else{elementHeight=1;}}
return this._assignHeight(element,elementHeight);},_assignHeight:function(element,hoursDuration){element.style.height=(hoursDuration*100)+'%';},_buildElement:function(){var wrapper=document.createElement('div');wrapper.classList.add('day-events-wrapper');this._eventsElement=document.createElement('section');this._element=document.createElement('section');if(!this.allDayElement){this.allDayElement=this._eventsElement;}
if(this.outsideAllDay){this.allDayElement=document.createElement('section');this.element.appendChild(this.allDayElement);this.allDayElement.classList.add(Calendar.Calc.ALLDAY);this.allDayElement.classList.add(this.classType);}
wrapper.appendChild(this._eventsElement);this.element.appendChild(wrapper);this.events.classList.add(this.classType);return this.element;},_renderEvent:function(busytime,event){},_renderHour:function(hour){return this.template.hour.render({displayHour:Calendar.Calc.formatHour(hour),hour:hour.toString()});},handleEvent:function(e){switch(e.type){case'remove':this.remove(e.data);break;case'add':this._loadRecords(e.data);break;}},removeHour:function(hour){var record=this.hours.get(hour);if(record===null){return;}
var el=record.element;if(el){el.parentNode.removeChild(el);}
this.hours.remove(hour);},createHour:function(hour){var html=this._renderHour(hour);var parent=(hour===Calendar.Calc.ALLDAY)?this.allDayElement:this.events;if(!parent){throw new Error('parent must be specified');}
var idx=this.hours.insertIndexOf(hour);var el=this._insertElement(html,parent,this.hours.items,idx);return this.hours.set(hour,{element:el,records:new OrderedMap(),flags:[]});},add:function(busytime,event){var hours=hoursOfOccurance(this.date,busytime.startDate,busytime.endDate);hours.forEach(function(hour){this._createRecord(hour,busytime,event);},this);},remove:function(busytime){var id=busytime._id;var hours=this._idsToHours[id];delete this._idsToHours[id];if(!hours){return;}
hours.forEach(function(number){var hour=this.hours.get(number);var calendarClass=this.calendarId(busytime);var flags=hour.flags;var idx=flags.indexOf(calendarClass);if(idx!==-1){flags.splice(idx,1);}
if(flags.indexOf(calendarClass)===-1){hour.element.classList.remove(calendarClass);}
if(!this.renderAllHours&&hour.records.length===1){this.removeHour(number);}
var record=hour.records.get(id);if(typeof(record)==='object'&&record.element){record.element.parentNode.removeChild(record.element);}
hour.records.remove(id);},this);var eventEl=this.overlaps.getElement(busytime);if(eventEl){eventEl.parentNode.removeChild(eventEl);this.overlaps.remove(busytime);}},changeDate:function(date,clear){this._changeToken++;var controller=this.controller;this._removeTimespanObserver();this.id=date.valueOf();this.date=Calendar.Calc.createDay(date);this.timespan=Calendar.Calc.spanOfDay(date);if(this.element){this.element.dataset.date=this.date;}
controller.observeTime(this.timespan,this);if(clear){this._resetHourCache();this.events.innerHTML='';}
var records=this.controller.queryCache(this.timespan);if(records&&records.length){this._loadRecords(records);}},create:function(){var el=this._buildElement();if(this.renderAllHours){if(this.outsideAllDay){this.createHour('allday');}
for(var hour=0;hour<24;hour++){this.createHour(hour);}}
this.changeDate(this.date);this.delegate(el,'click','section.hour',this._onHourClick.bind(this));return el;},_onHourClick:function(evt,el){if(this._clickedOnEvent(evt.target)){return;}
var hour=el.getAttribute('data-hour');if(!hour){return;}
var startDate=new Date(this.date.getTime());startDate.setHours(0);startDate.setMinutes(0);startDate.setSeconds(0);var endDate=new Date(this.date.getTime());endDate.setHours(0);endDate.setMinutes(0);endDate.setSeconds(0);var queryString={};if(hour===Calendar.Calc.ALLDAY){queryString.isAllDay=true;endDate.setDate(startDate.getDate()+1);}else{hour=parseInt(hour);startDate.setHours(hour);endDate.setHours(hour+1);}
queryString.startDate=startDate.toString();queryString.endDate=endDate.toString();this.app.go('/event/add/?'+
Calendar.QueryString.stringify(queryString));},_clickedOnEvent:function(target){var el=target;while(!el.classList.contains('events')){el=el.parentNode;if(!el||el.nodeType!==1){return false;}}
var children=el.childNodes;return children&&children.length>0;},activate:function(){this.element.classList.add(this.activeClass);},deactivate:function(){this.element.classList.remove(this.activeClass);},destroy:function(){this._removeTimespanObserver();var el=this.element;if(el&&el.parentNode){el.parentNode.removeChild(el);}},getScrollTop:function(){var scroll=this.element.querySelectorAll('.day-events')[1];var scrollTop=scroll.scrollTop;return scrollTop;},setScrollTop:function(scrollTop){var scroll=this.element.querySelectorAll('.day-events')[1];scroll.scrollTop=scrollTop;}};return DayBased;}());;Calendar.ns('Views').Month=(function(){var template=Calendar.Templates.Month;var Calc=Calendar.Calc;var Parent=Calendar.Views.TimeParent;function Month(options){Parent.apply(this,arguments);}
Month.prototype={__proto__:Parent.prototype,scale:'month',selectors:{element:'#month-view',selectedDay:'li.selected'},childClass:Calendar.Views.MonthChild,SELECTED:'selected',_onswipe:function(){var didSwipe=Parent.prototype._onswipe.apply(this,arguments);if(didSwipe){this.controller.selectedDay=this.date;}},_clearSelectedDay:function(){var day=this.element.querySelector(this.selectors.selectedDay);if(day){day.classList.remove(this.SELECTED);}},_selectDay:function(date){var el,id;this._clearSelectedDay();id=Calc.getDayId(date);id=this.currentFrame._dayId(id);el=document.getElementById(id);if(el){el.classList.add(this.SELECTED);}},_initEvents:function(){var self=this;this.controller=this.app.timeController;Parent.prototype._initEvents.apply(this,arguments);this.controller.on('selectedDayChange',this);this.controller.on('monthChange',this);this.delegate(this.element,'click','[data-date]',this);this.delegate(this.element,'dbltap','[data-date]',this);},handleEvent:function(e,target){Parent.prototype.handleEvent.apply(this,arguments);switch(e.type){case'click':var date=Calc.dateFromId(target.dataset.date);this.controller.selectedDay=date;break;case'dbltap':this.app.go('/day/');break;case'selectedDayChange':this._selectDay(e.data[0]);break;case'monthChange':this._clearSelectedDay();this.changeDate(e.data[0]);break;}},_createChild:function(time){return new Calendar.Views.MonthChild({app:this.app,date:time});},_getId:function(date){return date.valueOf();},_nextTime:function(time){return new Date(time.getFullYear(),time.getMonth()+1,time.getDate());},_previousTime:function(time){return new Date(time.getFullYear(),time.getMonth()-1,time.getDate());},render:function(){var time=this.controller.month;this.changeDate(time);}};Month.prototype.onfirstseen=Month.prototype.render;return Month;}(this));;Calendar.ns('Views').DayChild=(function(){var template=Calendar.Templates.Day;var OrderedMap=Calendar.Utils.OrderedMap;function Day(options){Calendar.Views.DayBased.apply(this,arguments);this.controller=this.app.timeController;this.hourEventsSelector=template.hourEventsSelector;}
Day.prototype={__proto__:Calendar.Views.DayBased.prototype,_renderEvent:function(busytime,event){var remote=event.remote;var attendees;var classes;if(event.remote.alarms&&event.remote.alarms.length){classes='has-alarms';}
if(event.remote.attendees){attendees=this._renderAttendees(event.remote.attendees);}
return template.event.render({classes:classes,busytimeId:busytime._id,calendarId:event.calendarId,title:event.remote.title,location:event.remote.location,attendees:attendees});},_renderAttendees:function(list){if(!(list instanceof Array)){list=[list];}
return template.attendee.renderEach(list).join(',');}};return Day;}(this));;Calendar.ns('Views').MonthsDay=(function(){var Parent=Calendar.Views.DayChild;function MonthsDay(){Parent.apply(this,arguments);}
MonthsDay.prototype={__proto__:Parent.prototype,renderAllHours:false,selectors:{element:'#months-day-view',events:'.day-events'},get element(){return this._findElement('element');},get events(){return this._findElement('events');},get allDayElement(){return this.events;},_initEvents:function(){var self=this;this.controller.on('selectedDayChange',this);this.delegate(this.events,'click','[data-id]',function(e,target){Calendar.App.router.show('/event/show/'+target.dataset.id+'/');});},handleEvent:function(e){Parent.prototype.handleEvent.apply(this,arguments);switch(e.type){case'selectedDayChange':this.changeDate(e.data[0],true);break;}},create:function(){},render:function(){this._initEvents();var date=Calendar.Calc.createDay(new Date());this.changeDate(date);}};MonthsDay.prototype.onfirstseen=MonthsDay.prototype.render;return MonthsDay;}());;(function(window){var NUMERIC=/^([0-9]+)$/;function Abstract(db){this.db=db;this._cached=Object.create(null);Calendar.Responder.call(this);}
Abstract.prototype={__proto__:Calendar.Responder.prototype,_store:null,_dependentStores:null,_createModel:function(object,id){if(typeof(id)!=='undefined'){object._id=id;}
return object;},_addToCache:function(object){this._cached[object._id]=object;},_removeFromCache:function(id){if(id in this._cached){delete this._cached[id];}},_transactionCallback:function(trans,callback){if(callback){trans.addEventListener('error',function(e){callback(e);});trans.addEventListener('complete',function(){callback(null);});}},probablyParseInt:function(id){if(id.match&&id.match(NUMERIC)){return parseInt(id,10);}
return id;},persist:function(object,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=undefined;}
if(!trans){trans=this.db.transaction(this._dependentStores||this._store,'readwrite');}
var self=this;var store=trans.objectStore(this._store);var data=this._objectData(object);var id;var model;var putReq;var reqType=this._detectPersistType(object);if(reqType==='update'){putReq=store.put(data);}else{this._assignId(data);putReq=store.add(data);}
trans.addEventListener('error',function(event){if(callback){callback(event);}});this._addDependents(object,trans);if(data._id){id=data._id;model=self._createModel(object,id);self._addToCache(model);}
trans.addEventListener('complete',function(data){if(!model){id=putReq.result;model=self._createModel(object,id);self._addToCache(model);}
if(callback){callback(null,id,model);}
self.emit(reqType,id,model);self.emit('persist',id,model);});},_allCached:function(callback){var list=this._cached;Calendar.nextTick(function(){callback(null,list);});},all:function(callback){if(this._allCallbacks){this._allCallbacks.push(callback);return;}
this._allCallbacks=[callback];var self=this;var trans=this.db.transaction(this._store);var store=trans.objectStore(this._store);function process(data){return self._addToCache(self._createModel(data));}
function fireQueue(err,value){var callback;while((callback=self._allCallbacks.shift())){callback(err,value);}}
store.mozGetAll().onsuccess=function(event){event.target.result.forEach(process);};trans.onerror=function(event){fireQueue(event.target.error.name);};trans.oncomplete=function(){fireQueue(null,self._cached);self.all=self._allCached;};},_addDependents:function(){},_removeDependents:function(trans){},_detectPersistType:function(object){return('_id'in object)?'update':'add';},_parseId:function(id){return id;},_assignId:function(obj){},removeByIndex:function(indexName,indexValue,trans,callback){var self=this;if(typeof(trans)==='function'){callback=trans;trans=undefined;}
if(!trans){trans=this.db.transaction(this._dependentStores||this._store,'readwrite');}
if(callback){trans.addEventListener('complete',function(){callback(null);});trans.addEventListener('error',function(event){callback(event);});}
var index=trans.objectStore(this._store).index(indexName);var req=index.openCursor(IDBKeyRange.only(indexValue));req.onsuccess=function(event){var cursor=event.target.result;if(cursor){self._removeDependents(cursor.primaryKey,trans);self._removeFromCache(cursor.primaryKey);cursor.delete();cursor.continue();}};return req;},get:function(id,trans,callback){var self=this;if(typeof(trans)==='function'){callback=trans;trans=null;}
if(!trans){trans=this.db.transaction(this._store);}
var store=trans.objectStore(this._store);var req=store.get(this._parseId(id));req.onsuccess=function(){var model;if(req.result){model=self._createModel(req.result);}
callback(null,model);};req.onerror=function(event){callback(e);};},remove:function(id,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=undefined;}
if(!trans){trans=this.db.transaction(this._dependentStores||this._store,'readwrite');}
var self=this;var store=trans.objectStore(this._store);id=this._parseId(id);var req=store.delete(id);this._removeDependents(id,trans);self.emit('preRemove',id);trans.addEventListener('error',function(event){if(callback){callback(event);}});trans.addEventListener('complete',function(){if(callback){callback(null,id);}
self.emit('remove',id);self._removeFromCache(id);});},count:function(callback){var trans=this.db.transaction(this._store);var store=trans.objectStore(this._store);var req=store.count();req.onsuccess=function(){callback(null,req.result);};req.onerror=function(e){callback(e);};},_objectData:function(data){if('toJSON'in data){return data.toJSON();}
return data;}};Calendar.ns('Store').Abstract=Abstract;}(this));;Calendar.ns('Store').Busytime=(function(){var binsearch=Calendar.binsearch.find;var bsearchForInsert=Calendar.binsearch.insert;function Busytime(){Calendar.Store.Abstract.apply(this,arguments);this._setupCache();}
Busytime.prototype={__proto__:Calendar.Store.Abstract.prototype,_store:'busytimes',_dependentStores:['alarms','busytimes'],_setupCache:function(){Calendar.TimeObserver.call(this);this._byEventId=Object.create(null);},_createModel:function(input,id){return this.initRecord(input,id);},initRecord:function(input,id){var _super=Calendar.Store.Abstract.prototype._createModel;var model=_super.apply(this,arguments);model.startDate=Calendar.Calc.dateFromTransport(model.start);model.endDate=Calendar.Calc.dateFromTransport(model.end);return model;},_removeDependents:function(id,trans){this.db.getStore('Alarm').removeByIndex('busytimeId',id,trans);},removeEvent:function(id,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=undefined;}
if(typeof(trans)==='undefined'){trans=this.db.transaction(this._dependentStores,'readwrite');}
var req=this.removeByIndex('eventId',id,trans);var success=req.onsuccess;var self=this;req.onsuccess=function(e){var cursor=e.target.result;if(cursor){var id=cursor.primaryKey;self.emit('remove',id);}
success(e);};this._transactionCallback(trans,callback);},_startCompare:function(aObj,bObj){var a=aObj.start.utc;var b=bObj.start.utc;return Calendar.compare(a,b);},loadSpan:function(span,callback){var trans=this.db.transaction(this._store);var store=trans.objectStore(this._store);var startPoint=Calendar.Calc.dateToTransport(new Date(span.start));var endPoint=Calendar.Calc.dateToTransport(new Date(span.end));var keyRange=IDBKeyRange.lowerBound(startPoint.utc);var index=store.index('end');var self=this;index.mozGetAll(keyRange).onsuccess=function(e){var data=e.target.result;data=data.sort(self._startCompare);var idx=Calendar.binsearch.insert(data,{start:{utc:endPoint.utc+1}},self._startCompare);data=data.slice(0,idx);if(callback)
callback(null,data.map(function(item){return self.initRecord(item);}));};},_addToCache:function(){},_removeFromCache:function(){}};return Busytime;}(this));;(function(window){function Account(){Calendar.Store.Abstract.apply(this,arguments);}
Account.prototype={__proto__:Calendar.Store.Abstract.prototype,_store:'accounts',_parseId:Calendar.Store.Abstract.prototype.probablyParseInt,_validateModel:function(model,callback){this.all(function(err,allAccounts){if(err){callback(err);return;}
for(var index in allAccounts){if(allAccounts[index].user===model.user&&allAccounts[index].fullUrl===model.fullUrl&&allAccounts[index]._id!==model._id){var dupErr=new Error('Cannot add two accounts with the same url / entry point');dupErr.name='account-exist';callback(dupErr);return;}}
callback();});},verifyAndPersist:function(model,callback){var self=this;var provider=Calendar.App.provider(model.providerType);provider.getAccount(model.toJSON(),function(err,data){if(err){callback(err);return;}
model.error=undefined;model.calendarHome=data.calendarHome;Calendar.extend(model,data);self._validateModel(model,function(err){if(err){return callback(err);}
self.persist(model,callback);});});},_dependentStores:['accounts','calendars','events','busytimes','alarms','icalComponents'],_removeDependents:function(id,trans){var store=this.db.getStore('Calendar');store.remotesByAccount(id,trans,function(err,related){if(err){console.log('Error removing deps for account: ',id);return;}
var key;for(key in related){store.remove(related[key]._id,trans);}});},sync:function(account,callback){var self=this;var provider=Calendar.App.provider(account.providerType);var calendarStore=this.db.getStore('Calendar');var persist=[];var calendars;var originalIds;function fetchExistingCalendars(err,results){if(err){return callback(err);}
calendars=results;originalIds=Object.keys(calendars);provider.findCalendars(account,persistCalendars);}
function persistCalendars(err,remoteCals){var key;if(err){callback(err);return;}
for(key in remoteCals){if(remoteCals.hasOwnProperty(key)){var cal=remoteCals[key];var idx=originalIds.indexOf(key);if(idx!==-1){originalIds.splice(idx,1);var original=calendars[key];original.remote=cal;original.error=undefined;persist.push(original);}else{persist.push(calendarStore._createModel({remote:new Object(cal),accountId:account._id}));}}}
if(persist.length||originalIds.length){var trans=self.db.transaction(self._dependentStores,'readwrite');originalIds.forEach(function(id){calendarStore.remove(calendars[id]._id,trans);});persist.forEach(function(object){calendarStore.persist(object,trans);});trans.addEventListener('error',function(err){callback(err);});trans.addEventListener('complete',function(){callback(null);});}else{callback(null);}}
calendarStore.remotesByAccount(account._id,fetchExistingCalendars);},_createModel:function(obj,id){if(!(obj instanceof Calendar.Models.Account)){obj=new Calendar.Models.Account(obj);}
if(typeof(id)!=='undefined'){obj._id=id;}
return obj;},markWithError:function(account,error,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=null;}
if(!account._id)
throw new Error('given account must be persisted');if(!account.error){account.error={name:error.name,date:new Date(),count:0};}
account.error.count++;var calendarStore=this.db.getStore('Calendar');var self=this;function fetchedCalendars(err,calendars){if(!trans){trans=self.db.transaction(self._dependentStores,'readwrite');}
if(err){console.error('Cannot fetch all calendars',err);return self.persist(account,trans,callback);}
for(var id in calendars){calendarStore.markWithError(calendars[id],error,trans);}
self.persist(account,trans);self._transactionCallback(trans,callback);}
calendarStore.remotesByAccount(account._id,fetchedCalendars);},syncableAccounts:function(callback){this.all(function(err,list){if(err)return callback(err);var results=[];for(var key in list){var account=list[key];var provider=Calendar.App.provider(account.providerType);if(provider.canSync){results.push(account);}}
callback(null,results);});},availablePresets:function(presetList,callback){var results=[];var singleUse={};var hasSingleUses=false;for(var preset in presetList){if(presetList[preset].singleUse){hasSingleUses=true;singleUse[preset]=true;}else{results.push(preset);}}
if(!hasSingleUses){return Calendar.nextTick(function(){callback(null,results);});}
this.all(function(err,list){if(err){callback(err);return;}
for(var id in list){var preset=list[id].preset;if(singleUse[preset]){delete singleUse[preset];}}
callback(null,results.concat(Object.keys(singleUse)));});}};Calendar.ns('Store').Account=Account;}(this));;(function(window){function Store(){Calendar.Store.Abstract.apply(this,arguments);}
Store.capabilities={createEvent:'canCreateEvent',updateEvent:'canUpdateEvent',deleteEvent:'canDeleteEvent'};Store.prototype={__proto__:Calendar.Store.Abstract.prototype,_store:'calendars',_dependentStores:['calendars','events','busytimes','alarms','icalComponents'],_parseId:Calendar.Store.Abstract.prototype.probablyParseInt,_addToCache:function(object){var remote=object.remote.id;this._cached[object._id]=object;},_removeFromCache:function(id){if(id in this._cached){var object=this._cached[id];var remote=object.remote.id;delete this._cached[id];}},_createModel:function(obj,id){if(!(obj instanceof Calendar.Models.Calendar)){obj=new Calendar.Models.Calendar(obj);}
if(typeof(id)!=='undefined'){obj._id=id;}
return obj;},_removeDependents:function(id,trans){var store=this.db.getStore('Event');store.removeByIndex('calendarId',id,trans);},markWithError:function(calendar,error,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=null;}
if(!calendar._id)
throw new Error('given calendar must be persisted.');calendar.error={name:error.name,date:new Date()};this.persist(calendar,trans,callback);},remotesByAccount:function(accountId,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=null;}
if(!trans){var trans=this.db.transaction(this._store);}
var store=trans.objectStore(this._store);var reqKey=IDBKeyRange.only(accountId);var req=store.index('accountId').mozGetAll(reqKey);req.onerror=function remotesError(e){callback(e.target.error);};var self=this;req.onsuccess=function remotesSuccess(e){var result=Object.create(null);e.target.result.forEach(function(calendar){result[calendar.remote.id]=self._createModel(calendar,calendar._id);});callback(null,result);};},sync:function(account,calendar,callback){var self=this;var store=this.db.getStore('Event');var provider=Calendar.App.provider(account.providerType);provider.syncEvents(account,calendar,callback);},providerFor:function(calendar,callback){this.ownersOf(calendar,function(err,owners){if(err){return callback(err);}
callback(null,Calendar.App.provider(owners.account.providerType));});},ownersOf:function(objectOrId,callback){var result={};var accountStore=this.db.getStore('Account');if(objectOrId instanceof Calendar.Models.Calendar){result.calendar=objectOrId;accountStore.get(objectOrId.accountId,fetchAccount);return;}
if(typeof(objectOrId)==='object'){objectOrId=objectOrId.calendarId;}
var calendarStore=this.db.getStore('Calendar');calendarStore.get(objectOrId,fetchCalendar);function fetchCalendar(err,calendar){if(err){return callback(err);}
result.calendar=calendar;accountStore.get(calendar.accountId,fetchAccount);}
function fetchAccount(err,account){if(err){return callback(err);}
result.account=account;callback(null,result);}}};Calendar.ns('Store').Calendar=Store;}(this));;(function(window){function Events(){Calendar.Store.Abstract.apply(this,arguments);}
Events.prototype={__proto__:Calendar.Store.Abstract.prototype,_store:'events',_dependentStores:['events','busytimes','alarms','icalComponents'],_addToCache:function(){},_removeFromCache:function(){},_createModel:function(input,id){var _super=Calendar.Store.Abstract.prototype._createModel;var model=_super.apply(this,arguments);model.remote.startDate=Calendar.Calc.dateFromTransport(model.remote.start);model.remote.endDate=Calendar.Calc.dateFromTransport(model.remote.end);return model;},_removeDependents:function(id,trans){this.removeByIndex('parentId',id,trans);var busy=this.db.getStore('Busytime');busy.removeEvent(id,trans);var component=this.db.getStore('IcalComponent');component.remove(id,trans);},_assignId:function(obj){var id=obj.calendarId+'-'+obj.remote.id;return obj._id=id;},providerFor:function(event,callback){this.ownersOf(event,function(err,owners){callback(null,Calendar.App.provider(owners.account.providerType));});},findByIds:function(ids,callback){var results={};var pending=ids.length;var self=this;function next(){if(!(--pending)){callback(null,results);}}
function success(e){var item=e.target.result;if(item){results[item._id]=self._createModel(item);}
next();}
function error(){next();}
ids.forEach(function(id){var trans=this.db.transaction('events');var store=trans.objectStore('events');var req=store.get(id);req.onsuccess=success;req.onerror=error;},this);},ownersOf:Calendar.Store.Calendar.prototype.ownersOf,eventsForCalendar:function(calendarId,callback){var trans=this.db.transaction('events');var store=trans.objectStore('events');var index=store.index('calendarId');var key=IDBKeyRange.only(calendarId);var req=index.mozGetAll(key);req.onsuccess=function(e){callback(null,e.target.result);};req.onerror=function(e){callback(e);};}};Calendar.ns('Store').Event=Events;}(this));;Calendar.ns('Store').Setting=(function(){function Setting(){Calendar.Store.Abstract.apply(this,arguments);}
Setting.prototype={__proto__:Calendar.Store.Abstract.prototype,_store:'settings',defaults:{standardAlarmDefault:-300,alldayAlarmDefault:32400,syncFrequency:15,syncAlarm:{alarmId:null,start:null,end:null},showSwipeToNavigateHint:true},_addToCache:function(){},_removeFromCache:function(){},getValue:function(key,callback){var self=this;if(key in this._cached){Calendar.nextTick(function handleCached(){callback(null,self._cached[key].value);});return;}
this.get(key,function handleStored(err,value){if(err){return callback(err);}
if(value===undefined&&self.defaults[key]!==undefined){value={value:self.defaults[key]};}
self._cached[key]=value;callback(null,value.value);});},set:function(key,value,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=null;}
var cached=this._cached[key];var record;if(cached&&cached._id){cached.value=value;cached.updatedAt=new Date();record=cached;}else{var created=new Date();this._cached[key]=record={_id:key,createdAt:created,updatedAt:created,value:value};}
this.emit(key+'Change',value,record);this.persist(record,trans,callback);}};return Setting;}());;Calendar.ns('Store').Alarm=(function(){var Calc=Calendar.Calc;var _super=Calendar.Store.Abstract.prototype;var debug=Calendar.debug('alarm store');function Alarm(){Calendar.Store.Abstract.apply(this,arguments);this._processQueue=this._processQueue.bind(this);}
Alarm.prototype={__proto__:_super,_store:'alarms',_dependentStores:['alarms'],_alarmAddThresholdHours:48,_addToCache:function(){},_removeFromCache:function(){},autoQueue:false,_processQueue:function(){this.workQueue();},_objectData:function(object){var data=_super._objectData.call(this,object);if(data.startDate){data.trigger=data.startDate;}
return data;},_addDependents:function(obj,trans){if(!this.autoQueue)
return;trans.addEventListener('complete',this._processQueue);},_moveAlarms:function(now,requiresAlarm,callback){var time=Calc.dateToTransport(now);var utc=time.utc;var minimum=utc+(this._alarmAddThresholdHours*Calc.HOUR);var pending=0;var isComplete=false;function handleAlarmSuccess(id){debug('successfully added alarm',id);if(!(--pending)&&isComplete){callback();}}
function handleAlarmError(e){debug('error adding alarm',e.target.error.name,e.target.error);if(!(--pending)&&isComplete){callback();}}
var controller=Calendar.App.alarmController;function addAlarm(data){var date=Calc.dateFromTransport(data.trigger);if(date<new Date()){return controller.handleAlarm(data);}
pending++;var type='honorTimezone';if(data.trigger.tzid===Calc.FLOATING){type='ignoreTimezone';}
debug('mozAlarm:',date,type,data);var req=navigator.mozAlarms.add(date,type,data);if(callback){req.onsuccess=handleAlarmSuccess;req.onerror=handleAlarmError;}}
var trans=this.db.transaction('alarms','readwrite');var store=trans.objectStore('alarms');var index=store.index('trigger');var req=index.openCursor();req.onerror=function(){var msg='Alarm cursor failed to open';callback(new Error(msg));};var addedFutureAlarm=false;req.onsuccess=function(event){var cursor=event.target.result;if(cursor&&((cursor.key<minimum)||(requiresAlarm&&!addedFutureAlarm))){if(cursor.key>utc){addedFutureAlarm=true;}
var record=cursor.value;addAlarm(record);delete record.trigger;cursor.update(record);cursor.continue();}else{isComplete=true;if(!pending){callback();}}};},findAllByBusytimeId:function(busytimeId,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=null;}
if(!trans){trans=this.db.transaction(this._dependentStores);}
var store=trans.objectStore(this._store);var index=store.index('busytimeId');var key=IDBKeyRange.only(busytimeId);index.mozGetAll(key).onsuccess=function(e){callback(null,e.target.result);};},workQueue:function(now,callback){if(typeof(now)==='function'){callback=now;now=null;}
now=now||new Date();var alarms=navigator.mozAlarms;if(!alarms){if(callback){callback(null);}
return;}
var self=this;var requiresAlarm=false;var req=alarms.getAll();req.onsuccess=function(e){var data=e.target.result;var len=data.length;var mozAlarm;requiresAlarm=true;for(var i=0;i<len;i++){mozAlarm=data[i].data;if(mozAlarm&&'eventId'in mozAlarm&&'trigger'in mozAlarm){requiresAlarm=false;break;}}
callback=callback||function(){};self._moveAlarms(now,requiresAlarm,callback);};req.onerror=function(){var msg='failed to get alarms';console.error('CALENDAR:',msg);if(callback){callback(new Error(msg));}};}};return Alarm;}());;Calendar.ns('Store').IcalComponent=(function(){function IcalComponent(){Calendar.Store.Abstract.apply(this,arguments);}
IcalComponent.prototype={__proto__:Calendar.Store.Abstract.prototype,_store:'icalComponents',_addToCache:function(){},_removeFromCache:function(){},_createModel:function(object){return object;},_detectPersistType:function(object){return'update';},findRecurrencesBefore:function(maxDate,callback){var trans=this.db.transaction(this._store,'readwrite');trans.onerror=function(event){callback(event.target.error.name);};var time=Calendar.Calc.dateToTransport(maxDate);var utc=time.utc;var range=IDBKeyRange.bound(0,utc);var store=trans.objectStore(this._store);var idx=store.index('lastRecurrenceId');var req=idx.mozGetAll(range);req.onsuccess=function(event){callback(null,event.target.result);};}};return IcalComponent;}());;Calendar.EventMutations=(function(){var Calc=Calendar.Calc;function createBusytime(event){return{_id:event._id+'-'+uuid.v4(),eventId:event._id,calendarId:event.calendarId,start:event.remote.start,end:event.remote.end};}
function Create(options){if(options){for(var key in options){if(options.hasOwnProperty(key)){this[key]=options[key];}}}}
Create.prototype={commit:function(callback){var alarmStore=Calendar.App.store('Alarm');var eventStore=Calendar.App.store('Event');var busytimeStore=Calendar.App.store('Busytime');var componentStore=Calendar.App.store('IcalComponent');var controller=Calendar.App.timeController;var trans=eventStore.db.transaction(eventStore._dependentStores,'readwrite');trans.oncomplete=function commitComplete(){callback(null);};trans.onerror=function commitError(e){callback(e.target.error);};eventStore.persist(this.event,trans);if(!this.busytime){this.busytime=createBusytime(this.event);}
busytimeStore.persist(this.busytime,trans);if(this.icalComponent){componentStore.persist(this.icalComponent,trans);}
controller.cacheEvent(this.event);controller.cacheBusytime(busytimeStore.initRecord(this.busytime));var alarms=this.event.remote.alarms;if(alarms&&alarms.length){var i=0;var len=alarms.length;var now=Date.now();var alarmTrans=alarmStore.db.transaction(['alarms'],'readwrite');for(;i<len;i++){var alarm={startDate:{offset:this.busytime.start.offset,utc:this.busytime.start.utc+(alarms[i].trigger*1000)},eventId:this.busytime.eventId,busytimeId:this.busytime._id};var alarmDate=Calc.dateFromTransport(this.busytime.end).valueOf();if(alarmDate<now){continue;}
alarmStore.persist(alarm,alarmTrans);}}}};function Update(){Create.apply(this,arguments);}
Update.prototype={commit:function(callback){var busytimeStore=Calendar.App.store('Busytime');var self=this;busytimeStore.removeEvent(this.event._id,function(err){if(err){callback(err);return;}
Create.prototype.commit.call(self,callback);});}};return{create:function createMutation(option){return new Create(option);},update:function updateMutation(option){return new Update(option);}};}());;Calendar.ns('Models').Account=(function(){function Account(options){var key;if(typeof(options)==='undefined'){options={};}
for(key in options){if(options.hasOwnProperty(key)){this[key]=options[key];}}}
Account.prototype={providerType:null,id:null,preset:null,domain:'',entrypoint:'',calendarHome:'',user:'',password:'',get fullUrl(){return this.domain+this.entrypoint;},set fullUrl(value){var protocolIdx=value.indexOf('://');this.domain=value;this.entrypoint='/';if(protocolIdx!==-1){protocolIdx+=3;var domainChunk=value.substr(protocolIdx);var pathIdx=domainChunk.indexOf('/');if(pathIdx!==-1){pathIdx=pathIdx+protocolIdx;this.entrypoint=value.substr(pathIdx);this.domain=value.substr(0,pathIdx);}}},toJSON:function(){var output={};var fields=['entrypoint','calendarHome','domain','password','user','providerType','preset','oauth','error'];fields.forEach(function(key){output[key]=this[key];},this);if(this._id||this._id===0){output._id=this._id;}
return output;}};return Account;}(this));;Calendar.ns('Models').Calendar=(function(){function Cal(options){var key;if(typeof(options)==='undefined'){options={};}
this.remote={};for(key in options){if(options.hasOwnProperty(key)){this[key]=options[key];}}}
Cal.prototype={remote:null,firstEventSyncDate:null,lastEventSyncToken:'',lastEventSyncDate:'',localDisplayed:true,accountId:'',updateRemote:function(provider){var data=provider;if('toJSON'in provider){data=provider.toJSON();}
this.remote=data;},eventSyncNeeded:function(){var local=this.lastEventSyncToken;var remote=this.remote.syncToken;return local!=remote;},get name(){return this.remote.name;},get color(){var color=this.remote.color;if(color){if(color.substr(0,1)==='#'){return color.substr(0,7);}}
return this.remote.color;},get description(){return this.remote.description;},toJSON:function(){var result={error:this.error,remote:this.remote,accountId:this.accountId,localDisplayed:this.localDisplayed,lastEventSyncDate:this.lastEventSyncDate,lastEventSyncToken:this.lastEventSyncToken,firstEventSyncDate:this.firstEventSyncDate};if(this._id||this._id===0){result._id=this._id;}
return result;}};return Cal;}(this));;Calendar.ns('Models').Event=(function(){function Event(data){var isNew=false;if(typeof(data)==='undefined'){isNew=true;data=Object.create(null);data.remote={};}
this.data=data;var remote=this.remote=this.data.remote;if('start'in remote&&!('startDate'in remote)){remote.startDate=Calendar.Calc.dateFromTransport(remote.start);}
if('end'in remote&&!('endDate'in remote)){remote.endDate=Calendar.Calc.dateFromTransport(remote.end);}
if(isNew){this.resetToDefaults();}
var start=this.remote.startDate;var end=this.remote.endDate;if(typeof(this._isAllDay)==='undefined'&&Calendar.Calc.isOnlyDate(start)&&Calendar.Calc.isOnlyDate(end)){this.isAllDay=true;}else{this.isAllDay=false;}}
Event.prototype={resetToDefaults:function(){var now=new Date();this.isAllDay=false;this.startDate=new Date(now.getFullYear(),now.getMonth(),now.getDate());this.endDate=new Date(now.getFullYear(),now.getMonth(),now.getDate()+1);},get _id(){return this.data._id;},_setDate:function(date,field){if(!(date instanceof Date)){throw new TypeError('must pass instance of Date');}
var allDay=this.isAllDay;if(allDay){date=new Date(date.valueOf());date.setHours(0);date.setMinutes(0);date.setSeconds(0);date.setMilliseconds(0);}
this.remote[field]=Calendar.Calc.dateToTransport(date,null,allDay);this.remote[field+'Date']=date;},get startDate(){return this.remote.startDate;},set startDate(value){this._setDate(value,'start');},get endDate(){return this.remote.endDate;},set endDate(value){this._setDate(value,'end');},set isAllDay(value){this._isAllDay=value;if(this.endDate){this.endDate=this.endDate;}
if(this.startDate){this.startDate=this.startDate;}},get isAllDay(){return this._isAllDay;},get calendarId(){return this.data.calendarId;},set calendarId(value){if(value&&typeof(value)!=='number'){value=Calendar.probablyParseInt(value);}
this.data.calendarId=value;},get syncToken(){return this.remote.syncToken;},set syncToken(value){this.remote.syncToken=value;},get title(){return this.remote.title||'';},set title(value){this.remote.title=value;},get description(){return this.remote.description||'';},set description(value){this.remote.description=value;},get location(){return this.remote.location||'';},set location(value){return this.remote.location=value;},get alarms(){return this.remote.alarms||[];},set alarms(value){return this.remote.alarms=value;},updateAttributes:function(data){var errors=this.validationErrors(data);if(errors){return errors;}
for(var field in data){this[field]=data[field];}
return true;},validationErrors:function(data){var obj=data||this;var end=obj.endDate.valueOf();var start=obj.startDate.valueOf();var errors=[];if(start>=end){errors.push({name:'start-after-end'});}
if(errors.length){return errors;}
return false;}};return Event;}());;Calendar.ns('Worker').Manager=(function(global){const IDLE_CLEANUP_TIME=5000;function Manager(){this._lastId=0;Calendar.Responder.call(this);this.roles=Object.create(null);this.workers=[];}
Manager.prototype={Worker:Worker,__proto__:Calendar.Responder.prototype,_onLog:function(e){console.log('[',e.name,']',e.message,'(',e.stack[0].trim(),')');},_formatData:function(data){if(data[1]&&data[1].stack&&data[1].constructorName){var err=data[1];var builtErr;if(global[err.constructorName]){builtErr=Object.create(global[err.constructorName].prototype);}else{builtErr=Object.create(Error.prototype);}
var key;for(key in err){if(err.hasOwnProperty(key)){builtErr[key]=err[key];}}
data[1]=builtErr;}
return data;},_onWorkerError:function(worker,err){if(/reference to undefined property/.test(err.message)){return;}
if(worker.instance){worker.instance.terminate();worker.instance=null;}
var pending=worker.pending;worker.pending=Object.create(null);for(var id in pending){if(pending[id].stream){pending[id].stream.emit('error',err);}
pending[id].callback(err);}},_onWorkerMessage:function(worker,event){var data=this._formatData(event.data);var type=data.shift(),match;if(type=='log'){this._onLog.apply(this,data);}else if(match=type.match(/^(\d+) (end|stream)$/)){var pending=worker.pending[match[1]];if(pending)
this._dispatchMessage(worker,pending,match[2],data);else
throw new Error('Message arrived for unknown consumer: '+
type+' '+JSON.stringify(data));}else{this.respond([type].concat(data));}},_dispatchMessage:function(worker,pending,type,data){if(type=='stream'){pending.stream.respond(data);}else{pending.callback.apply(null,data);delete worker.pending[pending.id];for(var _ in worker.pending)return;this._scheduleCleanup(worker);}},_addPending:function(worker,pending){worker.pending[pending.id]=pending;clearTimeout(worker.cleanup);},_scheduleCleanup:function(worker){clearTimeout(worker.cleanup);worker.cleanup=setTimeout(function(){for(var _ in worker.pending)return;if(!worker.instance)return;worker.instance.terminate();worker.instance=null;},IDLE_CLEANUP_TIME);},add:function(role,workerURL){var worker={instance:null,pending:Object.create(null),url:workerURL,cleanup:null};this.workers.push(worker);[].concat(role).forEach(function(role){if(!(role in this.roles))
this.roles[role]=[worker];else
this.roles[role].push(worker);},this);},_ensureActiveWorker:function(role){if(role in this.roles){var workers=this.roles[role];var worker=workers[Math.floor(Math.random()*workers.length)];if(worker.instance){return worker;}else{this._startWorker(worker);return worker;}}else{throw new Error('no worker with role "'+role+'" active');}},_startWorker:function(worker){worker.instance=new this.Worker(worker.url+'?time='+Date.now());worker.instance.onerror=this._onWorkerError.bind(this,worker);worker.instance.onmessage=this._onWorkerMessage.bind(this,worker);this._scheduleCleanup(worker);},request:function(role){var args=Array.prototype.slice.call(arguments,1);var callback=args.pop();try{var worker=this._ensureActiveWorker(role);}catch(e){callback(e);return;}
var data={id:this._lastId++,role:role,payload:args};this._addPending(worker,{id:data.id,callback:callback});worker.instance.postMessage(['_dispatch',data]);},stream:function(role){var args=Array.prototype.slice.call(arguments,1);var stream=new Calendar.Responder();var self=this;var data={id:this._lastId++,role:role,payload:args,type:'stream'};stream.request=function(callback){stream.request=function(){throw new Error('stream request has been sent');};try{var worker=self._ensureActiveWorker(role);}catch(e){callback(e);return;}
self._addPending(worker,{id:data.id,stream:stream,callback:callback});worker.instance.postMessage(['_dispatch',data]);};return stream;}};return Manager;}(this));;Calendar.ns('Controllers').Service=(function(){function Service(){Calendar.Worker.Manager.call(this);};Service.prototype={__proto__:Calendar.Worker.Manager.prototype,start:function(){this.add('caldav','/caldav_worker.js');}};return Service;}());;Calendar.ns('Controllers').Error=(function(){function ErrorController(app){Calendar.Responder.call(this);this.app=app;this._handlers=Object.create(null);}
ErrorController.prototype={__proto__:Calendar.Responder.prototype,accountErrorUrl:'/update-account/',dispatch:function(error){if(error instanceof Calendar.Error.Authentication||error instanceof Calendar.Error.InvalidServer){this.handleAuthenticate(error.detail.account);}
this.emit('error',error);},handleAuthenticate:function(account,callback){if(!account)
return console.error('attempting to trigger reauth without an account');if(!account.error||account.error.count!==1){return Calendar.nextTick(callback);}
var lock=navigator.requestWakeLock('cpu');var title=navigator.mozL10n.get('notification-error-sync-title');var description=navigator.mozL10n.get('notification-error-sync-description');var url=this.accountErrorUrl+account._id;this.app.loadObject('Notification',function(){Calendar.Notification.send(title,description,url,function(){callback&&callback();lock.unlock();});});}};return ErrorController;}());;Calendar.ns('Controllers').Time=(function(){function compareStart(a,b){return Calendar.compare(a.start,b.start);}
function Time(app){this.app=app;Calendar.Responder.call(this);Calendar.TimeObserver.call(this);this._timeCache=Object.create(null);this._eventsCache=Object.create(null);this._timespans=[];this._collection=new Calendar.IntervalTree();this._collection.createIndex('eventId');this.busytime=app.store('Busytime');}
Time.prototype={__proto__:Calendar.Responder.prototype,_position:null,_currentTimespan:null,_timeCache:null,_timespans:null,_maxTimespans:6,pending:0,_scale:null,_mostRecentDayType:'day',cacheLocked:false,get mostRecentDayType(){return this._mostRecentDayType;},get mostRecentDay(){if(this.mostRecentDayType==='selectedDay'){return this.selectedDay;}else{return this.position;}},get timespan(){return this._timespan;},get scale(){return this._scale;},set scale(value){var oldValue=this._scale;if(value!==oldValue){this._scale=value;this.emit('scaleChange',value,oldValue);}},get selectedDay(){return this._selectedDay;},set selectedDay(value){var day=this._selectedDay;this._mostRecentDayType='selectedDay';if(!day||!Calendar.Calc.isSameDate(day,value)){this._selectedDay=value;this.emit('selectedDayChange',value,day);}},direction:'future',observe:function(){this.on('monthChange',this._loadMonthSpan.bind(this));var sync=this.app.syncController;sync.on('syncStart',this);sync.on('syncComplete',this);var self=this;this.busytime.on('remove',function(id){self.removeCachedBusytime(id);});},moveToMostRecentDay:function(){if(this.mostRecentDayType==='selectedDay'){this.move(this.selectedDay);}},_updateCache:function(type,value){var old=this._timeCache[type];if(!old||!Calendar.Calc.isSameDate(value,old)){this._timeCache[type]=value;this.emit(type+'Change',value,old);}},purgeCache:function(){if(this.cacheLocked)
return;this._updateBusytimeCache();this._eventsCache=Object.create(null);},_updateBusytimeCache:function(){var dir=this.direction;var spans=this._timespans;var len=spans.length;var max=this._maxTimespans;if(len>max){var idx=Calendar.binsearch.find(spans,this._currentTimespan,compareStart);var isFuture=(dir==='future');var start=idx;if(isFuture){start=(idx-1);if((start+max)>len){start=start-((start+max)-len);}}else{start=(idx-max)+1;}
if(start<0){start=0;}
this._timespans=spans.splice(start,this._maxTimespans);var startPoint=this._timespans[0].start;var endPoint=this._timespans[this._timespans.length-1].end;this._collection.removePastIntervals(startPoint);this._collection.removeFutureIntervals(endPoint);spans.forEach(function(range){this.emit('purge',range);},this);}},_onLoadingComplete:function(err,records){records.forEach(this.cacheBusytime,this);if(!(--this.pending)){this.purgeCache();this.emit('loadingComplete');}},_recordSpanChange:function(span){var spans=this._timespans;var loadSpan=span;var idx=Calendar.binsearch.find(spans,span,compareStart);if(idx!==null)
return;idx=Calendar.binsearch.insert(spans,span,compareStart);spans.splice(idx,0,span);if(spans[idx-1]){loadSpan=spans[idx-1].trimOverlap(loadSpan);}
if(spans[idx+1]){loadSpan=spans[idx+1].trimOverlap(loadSpan);}
loadSpan=loadSpan||span;++this.pending;this.busytime.loadSpan(loadSpan,this._onLoadingComplete.bind(this));},_loadAroundSpan:function(date,presentSpan){var getSpan=Calendar.Calc.spanOfMonth;var pastSpan=getSpan(new Date(date.getFullYear(),date.getMonth()-1,1));var futureSpan=getSpan(new Date(date.getFullYear(),date.getMonth()+1,1));this._recordSpanChange(presentSpan);this._recordSpanChange(futureSpan);this._recordSpanChange(pastSpan);},_loadMonthSpan:function(date){var len=this._timespans.length;var spanOfMonth=Calendar.Calc.spanOfMonth;this._currentTimespan=spanOfMonth(date);var currentIdx=Calendar.binsearch.find(this._timespans,this._currentTimespan,compareStart);if(currentIdx===null){return this._loadAroundSpan(date,this._currentTimespan);}
var month=date.getMonth();var isFuture=this.direction==='future';if(isFuture){month+=1;}else{month-=1;}
var spans=this._timespans;var monthSpan=spanOfMonth(new Date(date.getFullYear(),month,1));return this._recordSpanChange(monthSpan);},handleEvent:function(event){var type;switch(event.type){case'syncStart':this.cacheLocked=true;break;case'syncComplete':this.cacheLocked=false;this.purgeCache();break;}},get month(){return this._timeCache.month;},get day(){return this._timeCache.day;},get year(){return this._timeCache.year;},get position(){return this._position;},queryCache:function(timespan){return this._collection.query(timespan);},cacheBusytime:function(busytime){var start=busytime.startDate;var end=busytime.endDate;this._collection.add(busytime);this.fireTimeEvent('add',start,end,busytime);},removeCachedBusytime:function(id){var collection=this._collection;if(id in collection.byId){var busytime=collection.byId[id];var start=busytime.startDate;var end=busytime.endDate;collection.remove(busytime);this.fireTimeEvent('remove',start,end,busytime);}},cacheEvent:function(event){this._eventsCache[event._id]=event;},removeCachedEvent:function(id){var busytimes=this._collection.index('eventId',id);if(busytimes){busytimes.forEach(function(busytime){this.removeCachedBusytime(busytime._id);},this);}
delete this._eventsCache[id];},findAssociated:function(busytimes,options,cb){if(typeof(options)==='function'){cb=options;options=null;}
var getEvent=true;var getAlarms=false;busytimes=(Array.isArray(busytimes))?busytimes:[busytimes];if(options&&('alarms'in options)){getAlarms=options.alarms;}
if(options&&('event'in options)){getEvent=options.event;}
var eventStore=this.app.store('Event');var alarmStore=this.app.store('Alarm');var list=[];var stores=['busytimes'];if(getAlarms)
stores.push('alarms');if(getEvent)
stores.push('events');var trans=eventStore.db.transaction(stores);trans.addEventListener('error',cb);var pending=0;function next(){if(!(--pending)){cb(null,list);}}
var self=this;function fetchRecords(busytime,idx){var result={busytime:busytime};list[idx]=result;if(getAlarms){pending++;alarmStore.findAllByBusytimeId(busytime._id,trans,function(err,alarm){if(alarm){result.alarms=alarm;}
next();});}
if(getEvent){var eventId=busytime.eventId;if(eventId in self._eventsCache){result.event=self._eventsCache[eventId];}else{pending++;eventStore.get(eventId,trans,function(err,event){if(event){self._eventsCache[eventId]=event;result.event=event;}
next();});}}}
function fetchBusytime(id,idx,err,record){if(!record||err){console.log('Error finding busytime',id,err);return next();}
self.cacheBusytime(record);fetchRecords(record,idx);next();}
busytimes.forEach(function(busytime,idx){if(typeof(busytime)==='string'){var record=this._collection.byId[busytime];if(!record){console.log('Cannot find busytime by id: ',JSON.stringify(busytime));pending++;return this.busytime.get(busytime,trans,fetchBusytime.bind(this,busytime,idx));}
busytime=this._collection.byId[busytime];}
fetchRecords(busytime,idx);},this);if(!pending&&cb)
cb(null,list);},move:function(date){var year=date.getFullYear();var month=date.getMonth();var day=date.getDate();var yearDate=new Date(year,0,1);var monthDate=new Date(year,month,1);var oldPosition=this._position;this._position=date;if(oldPosition){if(oldPosition<date){this.direction='future';}else if(oldPosition>date){this.direction='past';}else{this.direction='future';}}
this._mostRecentDayType='day';this._updateCache('year',yearDate);this._updateCache('month',monthDate);this._updateCache('day',date);}};Calendar.TimeObserver.enhance(Time.prototype);return Time;}());;Calendar.ns('Controllers').Sync=(function(){function handleError(err,callback){if(callback)
return callback(err);Calendar.App.errorController.dispatch(err);}
function Sync(app){this.app=app;this.pending=0;Calendar.Responder.call(this);}
Sync.prototype={__proto__:Calendar.Responder.prototype,startEvent:'syncStart',completeEvent:'syncComplete',_incrementPending:function(){if(!this.pending){this.emit('syncStart');}
this.pending++;},_resolvePending:function(){if(!(--this.pending)){this.emit('syncComplete');}
if(this.pending<0){dump('\n\n Error calendar sync .pending is < 0 \n\n');}},all:function(callback){if(callback){this.once('syncComplete',callback);}
if(this.app.offline()){this.emit('offline');this.emit('syncComplete');return;}
var account=this.app.store('Account');account.all(function(err,list){for(var key in list){this.account(list[key]);}
if(!this.pending){this.emit('syncComplete');}}.bind(this));},calendar:function(account,calendar,callback){var store=this.app.store('Calendar');var self=this;this._incrementPending();store.sync(account,calendar,function(err){self._resolvePending();handleError(err,callback);});},account:function(account,callback){var accountStore=this.app.store('Account');var calendarStore=this.app.store('Calendar');var self=this;this._incrementPending();accountStore.sync(account,function(err){if(err){self._resolvePending();return handleError(err,callback);}
var pending=0;function next(){if(!(--pending)){self._resolvePending();if(callback)
callback();}}
function fetchCalendars(err,calendars){if(err){self._resolvePending();return handleError(err,callback);}
for(var key in calendars){pending++;self.calendar(account,calendars[key],next);}}
var calendars=calendarStore.remotesByAccount(account._id,fetchCalendars);});}};return Sync;}());;Calendar.ns('Controllers').Alarm=(function(){var debug=Calendar.debug('alarm controller');function Alarm(app){this.app=app;this.store=app.store('Alarm');}
Alarm.prototype={displayURL:'/alarm-display/',observe:function(){var settings=this.app.store('Setting');var self=this;function getNextSync(err,result){if(err){console.error('Calendar failed to get _nextPeriodicSync!!!');}
self._nextPeriodicSync=result;settings.on('syncFrequencyChange',self);settings.getValue('syncFrequency',getSyncFrequency);};function getSyncFrequency(err,result){if(err){console.error('Calender failed to get sync frequency!!');}
self._resetSyncAlarm(result,false);}
settings.getValue('syncAlarm',getNextSync);if(navigator.mozSetMessageHandler){debug('set message handler');navigator.mozSetMessageHandler('alarm',function(msg){self.handleAlarmMessage(msg);});navigator.mozSetMessageHandler('notification',function(msg){self.handleNotificationMessage(msg);});}else{debug('mozSetMessageHandler is mising!');}},unobserve:function(){this.app.store('Setting').removeEventListener('syncFrequencyChange',this);},handleEvent:function(event){switch(event.type){case'syncFrequencyChange':this._resetSyncAlarm(event.data[0],false);break;}},handleAlarmMessage:function(message){debug('got message',message);switch(message.data.type){case'sync':this._handleSyncMessage();break;default:this.handleAlarm(message.data);}},handleNotificationMessage:function(message){debug('got message',message);var self=this;if(!message.clicked){return;}
navigator.mozApps.getSelf().onsuccess=function gotSelf(evt){var app=evt.target.result;var url=message.imageURL.split('?')[1];if(app!==null){app.launch();}
self.app.go(url);};},_sendAlarmNotification:function(alarm,event,busytime,callback){var now=new Date();event=new Calendar.Models.Event(event);var begins=Calendar.Calc.dateFromTransport(busytime.start);var distance=Calendar.App.dateFormat.fromNow(begins);var type=(begins>now)?'alarm-start-notice':'alarm-started-notice';var title=navigator.mozL10n.get(type,{title:event.title,distance:distance});var description=event.description;var url=this.displayURL+busytime._id;debug('send notification',title,description);Calendar.App.loadObject('Notification',function(){Calendar.Notification.send(title,description,url,callback);});},handleAlarm:function(alarm,trans,callback){if(typeof(trans)==='function'){callback=trans;trans=null;}
var lock=navigator.requestWakeLock('cpu');var self=this;this._dispatchAlarm(alarm,trans,function(){self.store.workQueue(function(){callback&&callback();lock.unlock();});});},_dispatchAlarm:function(alarm,trans,callback){if(!alarm._id||!alarm.busytimeId||!alarm.eventId){return Calendar.nextTick(callback);}
var now=new Date();var busytimeStore=this.app.store('Busytime');var eventStore=this.app.store('Event');var alarmStore=this.app.store('Alarm');var self=this;if(!trans){trans=eventStore.db.transaction(['events','busytimes','alarms']);}
var event;var busytime;var dbAlarm;trans.onerror=trans.onabort=callback;trans.oncomplete=function sendNotification(){if(!dbAlarm||!event||!busytime){debug('failed to load records',dbAlarm,event,busytime);return Calendar.nextTick(callback);}
var endDate=Calendar.Calc.dateFromTransport(busytime.end);debug('trigger?',endDate,now);if(endDate>now){self._sendAlarmNotification(alarm,event,busytime,callback);}else{callback();}};alarmStore.get(alarm._id,trans,function getAlarm(err,record){dbAlarm=record;});eventStore.get(alarm.eventId,trans,function getEvent(err,record){event=record;});busytimeStore.get(alarm.busytimeId,trans,function getBusytime
(err,record){busytime=record;});},_resetSyncAlarm:function(duration,triggered){debug('reset sync alarm: duration',duration);var settings=this.app.store('Setting');if(this._nextPeriodicSync.alarmId){navigator.mozAlarms.remove(this._nextPeriodicSync.alarmId);this._nextPeriodicSync.alarmId=null;}
if(duration===null){this._nextPeriodicSync.start=null;this._nextPeriodicSync.end=null;debug('Clear periodic sync');settings.set('syncAlarm',this._nextPeriodicSync);return;}
duration*=60*1000;var start=new Date();var end=new Date(start.getTime()+duration);if(!triggered&&this._nextPeriodicSync.end>start&&(this._nextPeriodicSync.start.getTime()+duration)>start){start=this._nextPeriodicSync.start;end=new Date(start.getTime()+duration);}
var request=navigator.mozAlarms.add(end,'ignoreTimezone',{type:'sync'});var self=this;request.onsuccess=function(e){self._nextPeriodicSync.alarmId=e.target.result;self._nextPeriodicSync.start=start;self._nextPeriodicSync.end=end;debug('schedule alarm',end.toString());settings.set('syncAlarm',self._nextPeriodicSync);};request.onerror=function(e){debug('alarm error',self._nextPeriodicSync);console.error('Error setting alarm:',e.target.error.name);};},_handleSyncMessage:function(){var self=this;var settings=this.app.store('Setting');debug('request lock');var lock=navigator.requestWakeLock('wifi');debug('sync');this.app.syncController.all(function(){debug('sync complete');lock.unlock();lock=null;});settings.getValue('syncFrequency',function(err,freq){self._resetSyncAlarm(freq,true);});}};return Alarm;}());;Calendar.App=(function(window){function PendingManager(){this.objects=[];this.pending=0;this.onstart=this.onstart.bind(this);this.onend=this.onend.bind(this);}
PendingManager.prototype={onpending:function(){},oncomplete:function(){},register:function(object){object.on(object.startEvent,this.onstart);object.on(object.completeEvent,this.onend);var wasPending=this.isPending();this.objects.push(object);if(object.pending){this.pending++;if(!wasPending){this.onpending();}}},unregister:function(object){var idx=this.objects.indexOf(object);if(idx!==-1){var object=this.objects[idx];this.objects.splice(idx,1);return true;}
return false;},isPending:function(){var len=this.objects.length;var i=0;for(;i<len;i++){if(this.objects[i].pending)
return true;}
return false;},onstart:function(){if(!this.pending){this.onpending();}
this.pending++;},onend:function(){this.pending--;if(!this.pending){this.oncomplete();}}};var DateL10n={localizeElements:function(parent){var elements=document.querySelectorAll('[data-l10n-date-format]');var len=elements.length;var i=0;for(;i<len;i++){DateL10n.localizeElement(elements[i]);}},localizeElement:function(element){var date=element.dataset.date;var formatKey=element.dataset.l10nDateFormat;var format=navigator.mozL10n.get(formatKey);if(date){element.textContent=Calendar.App.dateFormat.localeFormat(new Date(date),format);}}};var App={PendingManager:PendingManager,DateL10n:DateL10n,startingURL:window.location.href,_location:window.location,_mozTimeRefreshTimeout:3000,pendingClass:'pending-operation',configure:function(db,router){this.db=db;this.router=router;this._providers=Object.create(null);this._views=Object.create(null);this._routeViewFn=Object.create(null);this._pendingManger=new PendingManager();var self=this;this._pendingManger.oncomplete=function onpending(){document.body.classList.remove(self.pendingClass);};this._pendingManger.onpending=function oncomplete(){document.body.classList.add(self.pendingClass);};this.timeController=new Calendar.Controllers.Time(this);this.syncController=new Calendar.Controllers.Sync(this);this.serviceController=new Calendar.Controllers.Service(this);this.alarmController=new Calendar.Controllers.Alarm(this);this.errorController=new Calendar.Controllers.Error(this);this.observePendingObject(this.syncController);},observeDateLocalization:function(){window.addEventListener('localized',DateL10n.localizeElements);},observePendingObject:function(object){this._pendingManger.register(object);},isPending:function(){return this._pendingManger.isPending();},loadObject:function initializeLoadObject(name,callback){function loadObject(name,callback){this._loader.load('group',name,callback);}
if(!this._pendingObjects){this._pendingObjects=[[name,callback]];}else{this._pendingObjects.push([name,callback]);return;}
var self=this;function next(){NotAmd.nextTick=Calendar.nextTick;self._loader=NotAmd(Calendar.LoadConfig);self.loadObject=loadObject;self._pendingObjects.forEach(function(pair){loadObject.call(self,pair[0],pair[1]);});delete self._pendingObjects;}
LazyLoader.load(['/js/ext/notamd.js','/js/load_config.js'],next);},forceRestart:function(){if(!this.restartPending){this.restartPending=true;this._location.href=this.startingURL;}},go:function(url){this.router.show(url);},state:function(){this.router.state.apply(this.router,arguments);},modifier:function(){this.router.modifier.apply(this.router,arguments);},resetState:function(){this.router.resetState();},_routes:function(){this.state('/week/','Week');this.state('/day/','Day');this.state('/month/',['Month','MonthsDay']);this.modifier('/settings/','Settings',{clear:false});this.modifier('/advanced-settings/','AdvancedSettings');this.state('/alarm-display/:id','ViewEvent',{path:false});this.state('/event/add/','ModifyEvent');this.state('/event/edit/:id','ModifyEvent');this.state('/event/show/:id','ViewEvent');this.modifier('/select-preset/','CreateAccount');this.modifier('/create-account/:preset','ModifyAccount');this.modifier('/update-account/:id','ModifyAccount');this.router.start();var pathname=window.location.pathname;if(pathname==='/index.html'||pathname==='/'){this.go('/month/');}},_init:function(){var self=this;var today=document.querySelector('#view-selector .today');today.addEventListener('click',function(e){var date=new Date();self.timeController.move(date);self.timeController.selectedDay=date;e.preventDefault();});this.dateFormat=navigator.mozL10n.DateTimeFormat();this.observeDateLocalization();this.timeController.observe();this.alarmController.observe();this.store('Alarm').autoQueue=true;this.timeController.move(new Date());this.view('TimeHeader',function(header){header.render();});this.view('CalendarColors',function(colors){colors.render();});document.body.classList.remove('loading');this._routes();this.loadObject('Controllers.RecurringEvents',function(){self.recurringEventsController=new Calendar.Controllers.RecurringEvents(self);self.observePendingObject(self.recurringEventsController);self.recurringEventsController.observe();});this.view('FirstTimeUse',function(firstTimeUse){firstTimeUse.doFirstTime();});setTimeout(function nextTick(){this.view('Errors');}.bind(this),0);},init:function(){var self=this;var pending=2;function next(){pending--;if(!pending){self._init();}}
if(!this.db){this.configure(new Calendar.Db('b2g-calendar'),new Calendar.Router(page));}
this.serviceController.start(false);if(navigator.mozL10n&&(navigator.mozL10n.readyState=='interactive'||navigator.mozL10n.readyState=='complete')){next();}else{window.addEventListener('localized',function(){next();});}
this.db.load(function(){next();});},provider:function(name){if(!(name in this._providers)){this._providers[name]=new Calendar.Provider[name]({app:this});}
return this._providers[name];},_initView:function(name){this._views[name]=new Calendar.Views[name]({app:this});},view:function(name,cb){var self=this;if(!(name in this._views)){if(name in Calendar.Views){this._initView(name);if(cb){cb.call(self,self._views[name]);}}else{this.loadObject('Views.'+name,function(){self._initView(name);if(cb){cb.call(self,self._views[name]);}});}}else if(cb){Calendar.nextTick(function(){cb.call(self,self._views[name]);});}},store:function(name){return this.db.getStore(name);},offline:function(){return(navigator&&'onLine'in navigator)?!navigator.onLine:true;}};var _changeTimerId;window.addEventListener('moztimechange',function onMozTimeChange(){clearTimeout(_changeTimerId);_changeTimerId=setTimeout(function(){App.forceRestart();},App._mozTimeRefreshTimeout);});window.addEventListener('load',function onLoad(){window.removeEventListener('load',onLoad);App.init();});return App;}(this));