

/* global exports */
function customizeMaximumImageSize(customize) {
  var content =
    '//\n' +
    '// This file is automatically generated: DO NOT EDIT.\n' +
    '// To change these values, create a camera.json file in the\n' +
    '// distribution directory with content like this: \n' +
    '//\n' +
    '//   {\n' +
    '//     "maxImagePixelSize": 6000000,\n' +
    '//     "maxSnapshotPixelSize": 4000000, \n' +
    '//     "avgJpegCompressionRatio": 24 \n' +
    '//   }\n' +
    '//\n' +
    '// Optionally, you can also define variables to specify the\n' +
    '// minimum EXIF preview size that will be displayed as a\n' +
    '// full-screen preview by adding a property like this:\n' +
    '//\n' +
    '// "requiredEXIFPreviewSize": { "width": 640, "height": 480}\n' +
    '//\n' +
    '// If you do not specify this property then EXIF previews will only\n' +
    '// be used if they are big enough to fill the screen in either\n' +
    '// width or height in both landscape and portrait mode.\n' +
    '//\n' +
    'var CONFIG_MAX_IMAGE_PIXEL_SIZE = ' +
      customize.maxImagePixelSize + ';\n' +
    'var CONFIG_MAX_SNAPSHOT_PIXEL_SIZE = ' +
      customize.maxSnapshotPixelSize + ';\n' +
    'var CONFIG_AVG_JPEG_COMPRESSION_RATIO = ' +
      customize.avgJpegCompressionRatio + ';\n';

    if (customize.requiredEXIFPreviewSize) {
      content +=
        'var CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH = ' +
        customize.requiredEXIFPreviewSize.width + ';\n' +
        'var CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT = ' +
        customize.requiredEXIFPreviewSize.height + ';\n';
    } else {
      content +=
        'var CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH = 0;\n' +
        'var CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT = 0;\n';
    }
  return content;
}

exports.customizeMaximumImageSize = customizeMaximumImageSize;
