;'use strict';(function(exports){if(exports.ForwardLock)
return;const mimeSubtype='vnd.mozilla.oma.drm.fl';const SECRET_SETTINGS_ID='oma.drm.forward_lock.secret.key';var secret=null;function xor(buffer,key){var words=new Uint32Array(buffer,0,buffer.byteLength>>2);for(var i=0,n=words.length;i<n;i++)
words[i]^=key;}
function lockBuffer(secret,content,type,metadata){var header='LOCKED 1 '+escape(type)+'\n';if(metadata){for(var p in metadata){header+=escape(p)+':'+escape(metadata[p])+'\n';}}
header+='\0';var buffer=new Uint8Array(new Uint8Array(content)).buffer;xor(buffer,secret);return new Blob([header,buffer],{type:type.split('/')[0]+'/'+mimeSubtype});}
function lockBlob(secret,blob,metadata,callback){var reader=new FileReader();reader.readAsArrayBuffer(blob);reader.onload=function(){callback(lockBuffer(secret,reader.result,blob.type,metadata));};}
function unlockBlob(secret,blob,callback,errorCallback){var reader=new FileReader();reader.readAsArrayBuffer(blob);reader.onload=function(){var buffer=reader.result;var bytes=new Uint8Array(buffer);var header='';var contentStart;for(var i=0;i<bytes.length;i++){if(bytes[i]===0){contentStart=i+1;break;}
header+=String.fromCharCode(bytes[i]);}
if(!header.startsWith('LOCKED'))
return error('Bad magic number');if(header.substring(6,9)!==' 1 ')
return error('Unsupported version number');if(!contentStart)
return error('No content');var eol=header.indexOf('\n');if(eol===-1)
return error('malformed header');var type=unescape(header.substring(9,eol).trim());var metadata={};var lines=header.substring(eol+1).split('\n');for(var i=0;i<lines.length;i++){var line=lines[i];if(!line)
continue;var[key,value]=line.split(':');if(!key||!value)
return error('malformed metadata');metadata[unescape(key)]=unescape(value);}
var content=buffer.slice(contentStart);xor(content,secret);var blob=new Blob([content],{type:type});try{callback(blob,metadata);}
catch(e){console.error('Exception in content callback',e);}};function error(msg){msg='LCKA.decrypt(): '+msg;if(errorCallback){try{errorCallback(msg);}
catch(e){console.error('Exception in error callback',e);}}
else{console.error(msg);}}}
function getKey(callback){try{if(secret!==null){report(secret);return;}
var lock=navigator.mozSettings.createLock();var getreq=lock.get(SECRET_SETTINGS_ID);getreq.onsuccess=function(){secret=getreq.result[SECRET_SETTINGS_ID]||null;report(secret);};getreq.onerror=function(){console.error('Error getting ForwardLock setting',getreq.error);report(null);};}
catch(e){console.error('Exception in ForwardLock.getKey():',e);report(null);}
function report(secret){if(callback){try{callback(secret);}
catch(e){console.error('Exception in ForwardLock.getKey() callback');}}}}
function getOrCreateKey(callback){getKey(function(key){if(key!==null){report(key);return;}
secret=((Math.random()*0xFFFFFFFF)|0)+1;var setting={};setting[SECRET_SETTINGS_ID]=secret;var setreq=navigator.mozSettings.createLock().set(setting);setreq.onsuccess=function(){report(secret);};setreq.onerror=function(){console.error('Failed to set key in ForwardLock.getOrCreateKey()',setreq.error.name);secret=null;};});function report(secret){if(callback){try{callback(secret);}
catch(e){console.error('Exception in ForwardLock.getOrCreateKey() callback');}}}}
exports.ForwardLock={lockBuffer:lockBuffer,lockBlob:lockBlob,unlockBlob:unlockBlob,mimeSubtype:mimeSubtype,getKey:getKey,getOrCreateKey:getOrCreateKey};}(this));;const DEBUG=true;const OMADownloadStatus=Object.freeze({SUCCESS:'900 Success',INSUFFICIENT_MEMORY:'901 Insufficient memory',USER_CANCELLED:'902 User Cancelled',LOSS_OF_SERVICE:'903 Loss of Service',ATTRIBUTE_MISMATCH:'905 Attribute mismatch',INVALID_DESCRIPTOR:'906 Invalid descriptor',INVALID_DDVERSION:'951 Invalid DDVersion',DEVICE_ABORTED:'952 Device Aborted',NON_ACCEPTABLE_CONTENT:'953 Non-Acceptable Content',LOADER_ERROR:'954 Loader Error'});const DOWNLOAD_ERROR='download_error';const INSTALL_ERROR='install_error';const ERR_DESCRIPTOR_DOWNLOAD_FAILED='err_descriptor_download_failed';const ERR_BAD_DESCRIPTOR='err_bad_descriptor';const ERR_TOO_BIG='err_too_big';const ERR_UNSUPPORTED_TYPE='err_unsupported_type';const ERR_BAD_TYPE='err_bad_type';const ERR_CONTENT_DOWNLOAD_FAILED='err_content_download_failed';const ERR_BAD_DRM_MESSAGE='err_bad_drm_message';const ERR_BAD_IMAGE='err_bad_image';const ERR_BAD_AUDIO='err_bad_audio';const ERR_NO_SPACE='err_no_space';const ERR_NO_SDCARD='err_no_sdcard';const ERR_SDCARD_IN_USE='err_sdcard_in_use';const ERR_DB_STORE_FAILURE='err_db_store_failure';const ERR_DS_SAVE_FAILURE='err_ds_save_failure';const SUCCESS_SONG='success_song';const SUCCESS_RINGTONE='success_ringtone';const SUCCESS_WALLPAPER='success_wallpaper';const systemXHR=Object.freeze({mozSystem:true});const SupportedImageTypes=Object.freeze({'image/jpeg':true,'image/png':true,'image/gif':true,'image/bmp':true});const SupportedAudioTypes=Object.freeze({'audio/mpeg':true,'audio/mp4':true,'audio/opus':true,'audio/ogg':true});RINGTONE_KEY='dialer.ringtone';RINGTONE_NAME_KEY='dialer.ringtone.name';WALLPAPER_KEY='wallpaper.image';const SONG='song';const RINGTONE='ringtone';const WALLPAPER='wallpaper';const MAX_DOWNLOAD_SIZE=16*1024*1024;;function debug(...args){if(!DEBUG)
return;if(!debug.startTime)
debug.startTime=Date.now();args.unshift('[Locked Content]',Date.now()-debug.startTime);console.log.apply(console,args);}
function $(id){return document.getElementById(id);}
function _(id,args){return navigator.mozL10n.get(id,args);}
function showDialog(options){var dialog=document.createElement('form');dialog.setAttribute('role','dialog');dialog.dataset.type='confirm';var section=document.createElement('section');dialog.appendChild(section);if(options.title){var title=document.createElement('h1');title.textContent=options.title;section.appendChild(title);}
var msg=document.createElement('p');msg.textContent=options.message;section.appendChild(msg);if(options.details){var details=document.createElement('p');var small=document.createElement('small');small.textContent=options.details;details.appendChild(small);section.appendChild(details);}
var menu=document.createElement('menu');dialog.appendChild(menu);if(options.cancelCallback){var cancelButton=document.createElement('button');menu.appendChild(cancelButton);cancelButton.textContent=options.cancelText||_('cancel');cancelButton.onclick=function(e){close(e);options.cancelCallback();};}
if(options.okCallback){var okButton=document.createElement('button');menu.appendChild(okButton);okButton.textContent=options.okText||_('ok');if(options.danger){okButton.classList.add('danger');}
else if(!options.cancelCallback){okButton.classList.add('recommend');}
okButton.onclick=function(e){close(e);options.okCallback();};}
if(okButton&&!cancelButton)
okButton.classList.add('full');if(cancelButton&&!okButton)
cancelButton.classList.add('full');document.body.appendChild(dialog);function close(e){document.body.removeChild(dialog);e.preventDefault();e.stopPropagation();}};var objectStore=(function(){const DBNAME='LOCKEDCONTENT';const DBVERSION=1;const STORENAMES=['ringtones','wallpapers'];var db;function getStore(access,storeName,callback){if(STORENAMES.indexOf(storeName)===-1)
throw Error('unknown object store name:',storeName);if(db){callback(db.transaction(storeName,access).objectStore(storeName));}
else{initDB(function(){getStore(access,storeName,callback);});}}
function initDB(callback){var open=indexedDB.open(DBNAME,DBVERSION);open.onsuccess=function(){db=open.result;callback();};open.onupgradeneeded=function(){STORENAMES.forEach(function(storeName){open.result.createObjectStore(storeName,{autoIncrement:true,keyPath:'id'});});};open.onerror=function(){console.error('can not open database:',open.error.name);};}
return{readonly:function readonly(storeName,callback){getStore('readonly',storeName,callback);},readwrite:function readwrite(storeName,callback){getStore('readwrite',storeName,callback);}};}());;window.addEventListener('load',function(){navigator.mozL10n.ready(function(){navigator.mozSetMessageHandler('activity',function(activity){var type=activity.source.data.type;if(type==='ringtone'||(Array.isArray(type)&&type.indexOf('ringtone')!==-1)){pickRingtone(activity);}
else if(type==='wallpaper'||(Array.isArray(type)&&type.indexOf('wallpaper')!==-1)){pickWallpaper(activity);}
else{console.error('unexpected activity request',activity.source.name,JSON.stringify(activity.source.data));}});});});function pickRingtone(activity){var selectedRingtone;var player=new Audio();var currentRingtoneName;var numRingtones=0;var template=$('ringtone-template');var container=$('ringtones');container.hidden=false;$('title').textContent=_('pick-ringtone');$('back').onclick=function(){player.pause();activity.postError('cancelled');};$('done').onclick=function(){player.pause();ForwardLock.getKey(function(secret){ForwardLock.lockBlob(secret,selectedRingtone.blob,{},function(lockedBlob){activity.postResult({blob:lockedBlob,name:selectedRingtone.descriptor.name});});});};getCurrentRingtoneName(function(name){currentRingtoneName=name;enumerateAndBuildUI();});function getCurrentRingtoneName(callback){navigator.mozSettings.createLock().get(RINGTONE_NAME_KEY).onsuccess=function(e){callback(e.target.result[RINGTONE_NAME_KEY]);};}
function enumerateAndBuildUI(){objectStore.readonly('ringtones',function(ringtoneStore){var cursor=ringtoneStore.openCursor();cursor.onsuccess=function(){if(cursor.result){addRingtone(cursor.result.value);cursor.result.continue();}
else{if(numRingtones===0)
displayError(activity,'no-installed-ringtones');}};});}
function addRingtone(ringtone){numRingtones++;var name=ringtone.descriptor.name;var dom=template.content.cloneNode(true);var input=dom.querySelector('input');dom.querySelector('a').textContent=name;if(name===currentRingtoneName){selectedRingtone=ringtone;input.checked=true;}
input.onchange=function(){if(input.checked){selectedRingtone=ringtone;play(ringtone);}};container.appendChild(dom);}
function play(ringtone){if(!ringtone.url)
ringtone.url=URL.createObjectURL(ringtone.blob);player.src=ringtone.url;player.play();}}
function pickWallpaper(activity){var numWallpapers=0;var template=$('wallpaper-template');var container=$('wallpapers');container.hidden=false;$('title').textContent=_('pick-wallpaper');$('done').hidden=true;$('back').onclick=function(){activity.postError('cancelled');};objectStore.readonly('wallpapers',function(wallpaperStore){var cursor=wallpaperStore.openCursor();cursor.onsuccess=function(){if(cursor.result){addWallpaper(cursor.result.value);numWallpapers++;cursor.result.continue();}
else{if(numWallpapers===0)
displayError(activity,'no-installed-wallpaper');}};});function addWallpaper(wallpaper){var blob=wallpaper.blob;var url=URL.createObjectURL(blob);var wallpaper=template.content.cloneNode(true).firstElementChild;container.appendChild(wallpaper);wallpaper.style.backgroundImage='url('+url+')';wallpaper.onclick=function(){ForwardLock.getKey(function(secret){ForwardLock.lockBlob(secret,blob,{},function(lockedBlob){activity.postResult({blob:lockedBlob});});});};}}
function displayError(activity,id){setTimeout(function(){alert(_(id));activity.postError(id);});}