;'use strict';var PairView={_device:null,_pairMethod:null,_pairMode:'active',_passkey:'',pairView:document.getElementById('pair-view'),nameLabel:document.getElementById('label-name'),pairDescription:document.getElementById('pair-description'),pairButton:document.getElementById('button-pair'),closeButton:document.getElementById('button-close'),comfirmationItem:document.getElementById('confirmation-method'),pinInputItem:document.getElementById('pin-input-method'),passkeyInputItem:document.getElementById('passkey-input-method'),passkey:document.getElementById('passkey'),pinInput:document.getElementById('pin-input'),passkeyInput:document.getElementById('passkey-input'),show:function pv_show(){var _=navigator.mozL10n.get;this.pairButton.addEventListener('click',this);this.closeButton.addEventListener('click',this);window.addEventListener('resize',this);var truncatedDeviceName=getTruncated(this._device.name,{node:this.nameLabel,maxLine:2,ellipsisIndex:3});this.nameLabel.textContent=truncatedDeviceName;this.pairView.hidden=false;var stringName=this._pairMode+'-pair-'+this._pairMethod;this.pairDescription.textContent=_(stringName,{device:truncatedDeviceName});switch(this._pairMethod){case'confirmation':this.passkey.textContent=this._passkey;this.comfirmationItem.hidden=false;this.pinInputItem.hidden=true;this.passkeyInputItem.hidden=true;break;case'pincode':this.pinInputItem.hidden=false;this.comfirmationItem.hidden=true;this.passkeyInputItem.hidden=true;this.pinInput.focus();break;case'passkey':this.passkeyInputItem.hidden=false;this.comfirmationItem.hidden=true;this.pinInputItem.hidden=true;this.passkeyInput.focus();break;}},init:function pv_init(mode,method,device,passkey){this._pairMode=mode;this._pairMethod=method;this._device=device;if(passkey){var len=passkey.toString().length;var zeros=(len<6)?(new Array((6-len)+1)).join('0'):'';this._passkey=zeros+passkey;}
navigator.mozL10n.ready(PairView.show.bind(PairView));},close:function(){window.opener.gDeviceList.setConfirmation(this._device.address,false);window.close();},closeInput:function(){if(!this.pinInputItem.hidden){this.pinInput.blur();}
if(!this.passkeyInputItem.hidden){this.passkeyInput.blur();}},handleEvent:function pv_handleEvent(evt){var _=navigator.mozL10n.get;if(!evt.target)
return;switch(evt.type){case'click':evt.preventDefault();switch(evt.target.id){case'button-pair':this.pairDescription.textContent=_('device-status-waiting');this.pairButton.disabled=true;this.closeButton.disabled=true;switch(this._pairMethod){case'confirmation':window.opener.gDeviceList.setConfirmation(this._device.address,true);break;case'pincode':var value=this.pinInput.value;window.opener.gDeviceList.setPinCode(this._device.address,value);break;case'passkey':var value=this.passkeyInput.value;window.opener.gDeviceList.setPasskey(this._device.address,value);break;}
window.close();break;case'button-close':this.close();break;}
break;case'resize':if(window.innerHeight<200){this.close();}
break;default:break;}}};;'use strict';function reopenSettings(){navigator.mozApps.getSelf().onsuccess=function getSelfCB(evt){var app=evt.target.result;app.launch('settings');};}
function openLink(url){if(url.startsWith('tel:')){new MozActivity({name:'dial',data:{type:'webtelephony/number',number:url.substr(4)}});}else if(!url.startsWith('#')){new MozActivity({name:'view',data:{type:'url',url:url}});}}
function openDialog(dialogID,onSubmit,onReset){if('#'+dialogID==Settings.currentPanel)
return;var origin=Settings.currentPanel;Settings.currentPanel=dialogID;var dialog=document.getElementById(dialogID);var submit=dialog.querySelector('[type=submit]');if(submit){submit.onclick=function onsubmit(){if(typeof onSubmit==='function')
(onSubmit.bind(dialog))();Settings.currentPanel=origin;};}
var reset=dialog.querySelector('[type=reset]');if(reset){reset.onclick=function onreset(){if(typeof onReset==='function')
(onReset.bind(dialog))();Settings.currentPanel=origin;};}}
function loadJSON(href,callback){if(!callback)
return;var xhr=new XMLHttpRequest();xhr.onerror=function(){console.error('Failed to fetch file: '+href,xhr.statusText);};xhr.onload=function(){callback(xhr.response);};xhr.open('GET',href,true);xhr.responseType='json';xhr.send();}
var localize=navigator.mozL10n.localize;var FileSizeFormatter=(function FileSizeFormatter(fixed){function getReadableFileSize(size,digits){if(size===undefined)
return{};var units=['B','KB','MB','GB','TB','PB','EB','ZB','YB'];var i=0;while(size>=1024){size/=1024;++i;}
var sizeString=size.toFixed(digits||0);var sizeDecimal=parseFloat(sizeString);return{size:sizeDecimal.toString(),unit:units[i]};}
return{getReadableFileSize:getReadableFileSize};})();var DeviceStorageHelper=(function DeviceStorageHelper(){function getStat(type,callback){var deviceStorage=navigator.getDeviceStorage(type);if(!deviceStorage){console.error('Cannot get DeviceStorage for: '+type);return;}
deviceStorage.freeSpace().onsuccess=function(e){var freeSpace=e.target.result;deviceStorage.usedSpace().onsuccess=function(e){var usedSpace=e.target.result;callback(usedSpace,freeSpace,type);};};}
function getFreeSpace(callback){var deviceStorage=navigator.getDeviceStorage('sdcard');if(!deviceStorage){console.error('Cannot get free space size in sdcard');return;}
deviceStorage.freeSpace().onsuccess=function(e){var freeSpace=e.target.result;callback(freeSpace);};}
function showFormatedSize(element,l10nId,size){if(size===undefined||isNaN(size)){element.textContent='';return;}
var fixedDigits=(size<1024*1024)?0:1;var sizeInfo=FileSizeFormatter.getReadableFileSize(size,fixedDigits);var _=navigator.mozL10n.get;element.textContent=_(l10nId,{size:sizeInfo.size,unit:_('byteUnit-'+sizeInfo.unit)});}
return{getStat:getStat,getFreeSpace:getFreeSpace,showFormatedSize:showFormatedSize};})();var getMobileConnection=function(){var mobileConnection=navigator.mozMobileConnections&&navigator.mozMobileConnections[0];if(mobileConnection&&mobileConnection.data){return mobileConnection;}
return null;};var getBluetooth=function(){return navigator.mozBluetooth;};var getNfc=function(){if('mozNfc'in navigator){return navigator.mozNfc;}
return null;};(function(exports){var supportedNetworkTypeHelpers=[];var helperFuncReady=function(callback){if(exports.SupportedNetworkTypeHelper){if(typeof callback==='function'){callback();}}else{LazyLoader.load(['js/supported_network_type_helper.js'],function(){if(typeof callback==='function'){callback();}});}};var getMobileConnectionIndex=function(mobileConnection){return Array.prototype.indexOf.call(navigator.mozMobileConnections,mobileConnection);};var getSupportedNetworkInfo=function(mobileConnection,callback){if(!navigator.mozMobileConnections){if(typeof callback==='function'){callback();}}
helperFuncReady(function ready(){var index=getMobileConnectionIndex(mobileConnection);var supportedNetworkTypeHelper=supportedNetworkTypeHelpers[index];if(!supportedNetworkTypeHelper){supportedNetworkTypeHelpers[index]=supportedNetworkTypeHelper=SupportedNetworkTypeHelper(mobileConnection.supportedNetworkTypes);}
if(typeof callback==='function'){callback(supportedNetworkTypeHelper);}});};exports.getSupportedNetworkInfo=getSupportedNetworkInfo;})(this);function isIP(address){return/^\d+\.\d+\.\d+\.\d+$/.test(address);}
function sanitizeAddress(input){if(isIP(input)){return input.replace(/0*(\d+)/g,'$1');}else{return input;}}
function getTruncated(oldName,options){var maxLine=options.maxLine||2;var node=options.node;var ellipsisIndex=options.ellipsisIndex||3;var ellipsisCharacter=options.ellipsisCharacter||'...';if(node===null){return oldName;}
function hitsNewline(oldHeight,newHeight){return oldHeight!==newHeight;}
var newName='';var oldHeight;var newHeight;var baseHeight;var currentLine;var ellipsisAt;var hasNewEllipsisPoint=true;var nameBeforeEllipsis=[];var nameBeforeEllipsisString;var nameAfterEllipsis=oldName.slice(-ellipsisIndex);var realVisibility=node.style.visibility;var realWordBreak=node.style.wordBreak;node.style.visibility='hidden';node.style.wordBreak='break-all';node.textContent='.';baseHeight=node.clientHeight;node.textContent='';var needEllipsis=oldName.split('').some(function(character,index){nameBeforeEllipsis.push(character);nameBeforeEllipsisString=nameBeforeEllipsis.join('');oldHeight=node.clientHeight;node.textContent=nameBeforeEllipsisString+
ellipsisCharacter+nameAfterEllipsis;newHeight=node.clientHeight;if(index===0){currentLine=Math.floor(newHeight/baseHeight);}
if(hitsNewline(oldHeight,newHeight)&&index!==0){var testHeight;node.textContent=nameBeforeEllipsisString;testHeight=node.clientHeight;if(hitsNewline(oldHeight,testHeight)){hasNewEllipsisPoint=true;currentLine+=1;}else{if(hasNewEllipsisPoint){ellipsisAt=index;hasNewEllipsisPoint=false;}}}
if(currentLine>maxLine){if(index===0){console.log('Your string is in a overflowed situation, '+'please check your options');}
nameBeforeEllipsis.pop();node.textContent='';return true;}});node.style.visibility=realVisibility;node.style.wordBreak=realWordBreak;if(!needEllipsis){newName=oldName;}else{newName+=nameBeforeEllipsis.join('').slice(0,ellipsisAt);newName+=ellipsisCharacter;newName+=nameAfterEllipsis;}
return newName;}
function getIccByIndex(index){if(index===undefined){index=DsdsSettings.getIccCardIndexForCallSettings();}
var iccObj;if(navigator.mozMobileConnections[index]){var iccId=navigator.mozMobileConnections[index].iccId;if(iccId){iccObj=navigator.mozIccManager.getIccById(iccId);}}
return iccObj;}