;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media)
continue;window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;(function(exports){'use strict';function ManifestHelper_get(prop){var manifest=this;var value=manifest[prop];if(manifest.locales){var lang=navigator.mozL10n.language.code||'';[lang,lang.substr(0,lang.indexOf('-'))].some(function tryLanguage(lang){if(this[lang]&&this[lang][prop]){value=this[lang][prop];return true;}},manifest.locales);}
if(typeof value==='object'&&!(value instanceof Array)){value=new ManifestHelper(value);}
return value;}
function ManifestHelper(manifest){for(var prop in manifest){Object.defineProperty(this,prop,{get:ManifestHelper_get.bind(manifest,prop),enumerable:true});}}
exports.ManifestHelper=ManifestHelper;}(window));;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';(function(exports){var _iccManager=navigator.mozIccManager;var _iccProxy=null;Object.defineProperty(exports,'IccHelper',{configurable:true,get:function(){return _iccProxy;},set:function(value){_iccProxy=value;}});if(_iccManager&&_iccManager.getIccById){var activeIccObj=null;var eventListeners={};var cachedEventListeners={};var events=['cardstatechange','iccinfochange','stkcommand','stksessionend'];var getters=['iccInfo','cardState'];var methods=['sendStkResponse','sendStkMenuSelection','sendStkTimerExpiration','sendStkEventDownload'];var domRequests=['getCardLock','unlockCardLock','setCardLock','getCardLockRetryCount','readContacts','updateContact','iccOpenChannel','iccExchangeAPDU','iccCloseChannel'];var getterTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name];}else{return null;}};};var methodTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name].apply(activeIccObj,arguments);}};};var domRequestTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name].apply(activeIccObj,arguments);}else{throw new Error('The icc object is invalid');}};};var createIccProxy=function(){var iccProxy={addEventListener:function(eventName,callback){if(typeof callback!=='function')
return;if(events.indexOf(eventName)===-1)
return;var listeners=eventListeners[eventName];if(listeners==null){listeners=eventListeners[eventName]=[];}
if(listeners.indexOf(callback)===-1){listeners.push(callback);}},removeEventListener:function(eventName,callback){var listeners=eventListeners[eventName];if(listeners){var index=listeners.indexOf(callback);if(index!==-1){listeners.splice(index,1);}}}};getters.forEach(function(getter){Object.defineProperty(iccProxy,getter,{enumerable:true,get:getterTemplate(getter)});});methods.forEach(function(method){iccProxy[method]=methodTemplate(method);});domRequests.forEach(function(request){iccProxy[request]=methodTemplate(request);});events.forEach(function(eventName){Object.defineProperty(iccProxy,'on'+eventName,{enumerable:true,set:function(newListener){var oldListener=cachedEventListeners[eventName];if(oldListener){iccProxy.removeEventListener(eventName,oldListener);}
cachedEventListeners[eventName]=newListener;if(newListener){iccProxy.addEventListener(eventName,newListener);}},get:function(){return cachedEventListeners[eventName];}});});return iccProxy;};_iccProxy=createIccProxy();if(_iccManager.iccIds&&_iccManager.iccIds.length){activeIccObj=_iccManager.getIccById(_iccManager.iccIds[0]);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});}}
_iccManager.oniccdetected=function(event){if(_iccProxy.cardState==null){activeIccObj=_iccManager.getIccById(event.iccId);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});['cardstatechange','iccinfochange'].forEach(function(eventName){if(eventListeners[eventName]){eventListeners[eventName].forEach(function(listener){listener();});}});}}};}else{_iccProxy=_iccManager;}})(window);;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';(function(exports){var width=window.innerWidth;var height=window.innerHeight;if(!width){width=screen.width;}
if(!height){height=screen.height-20;}
function setDimensionsInternal(){width=window.innerWidth;height=window.innerHeight;}
function setDimensions(){var isPortrait='(orientation: portrait)';if(window.matchMedia(isPortrait).matches){setDimensionsInternal();}else{window.matchMedia(isPortrait).addListener(function onOrientation(evt){if(evt.matches){window.matchMedia(isPortrait).removeListener(onOrientation);setTimeout(setDimensionsInternal);}});}}
if(document.hidden){document.addEventListener('visibilitychange',function onVisible(){document.removeEventListener('visibilitychange',onVisible);setDimensions();});}else{setDimensions();}
exports.ScreenHelper={get width(){return width;},get height(){return height;}};}(window));;'use strict';var GridItemsFactory={TYPE:{APP:'app',BOOKMARK:'bookmark',COLLECTION:'collection'},create:function gif_create(params){var item=Bookmark;if(params.type===GridItemsFactory.TYPE.COLLECTION){item=Collection;}
return new item(params);}};var GridItem=function GridItem(params){this.type=GridItemsFactory.TYPE.APP;this.removable=true;if('removable'in params&&!params.removable){this.removable=false;}
this.iconable='iconable'in params?params.iconable:true;this.id=params.id||'';this.setURL(params.bookmarkURL);this.features=params.features||'';this.manifest={name:params.customName||params.name,default_locale:'en-US'};if(params.icon){this.manifest.icons={60:params.icon};}
if(params.apps){this.manifest.apps=params.apps;}
this.useAsyncPanZoom='useAsyncPanZoom'in params&&params.useAsyncPanZoom;};GridItem.prototype={launch:function gc_launch(){},uninstall:function gc_uninstall(){GridManager.uninstall(this);},getFeatures:function gc_getFeatures(){return{id:this.id,name:this.manifest.name,icon:this.manifest.icons&&this.manifest.icons['60'],remote:true,useAsyncPanZoom:this.useAsyncPanZoom,features:this.features};},setURL:function gc_setURL(url){this.url=this.origin=this.bookmarkURL=url;},setName:function gc_setName(name){this.manifest.name=name;}};var Collection=function Collection(params,cb){GridItem.call(this,params);this.iconable=false;this.type=GridItemsFactory.TYPE.COLLECTION;this.hideFromGrid=!!params.hideFromGrid;this.providerId=params.provider_id||params.id;};Collection.prototype={__proto__:GridItem.prototype,launch:function sc_launch(){var features=this.getFeatures();features.id=this.id;window.dispatchEvent(new CustomEvent('collectionlaunch',{'detail':features}));}};;'use strict';var Bookmark=function Bookmark(params){GridItem.call(this,params);var url=params.bookmarkURL.trim();this.bookmarkURL=this.generateIndex(url);this.setURL(url);this.type=GridItemsFactory.TYPE.BOOKMARK;};Bookmark.prototype={__proto__:GridItem.prototype,_INDEX_PREFIX:'bookmark:',sanitizeURL:function bookmark_sanitizeURL(url){url=url.trim();var prefix=this._INDEX_PREFIX;return url.startsWith(prefix)?url.substr(prefix.length):url;},generateIndex:function bookmark_generateIndex(url){var prefix=this._INDEX_PREFIX;return url.startsWith(prefix)?url:prefix+url;},launch:function bookmark_launch(){var features=this.getFeatures();window.open(this.url,'_blank',Object.keys(features).map(function(key){return encodeURIComponent(key)+'='+encodeURIComponent(features[key]);}).join(','));},setURL:function bookmark_setURL(url){this.url=this.origin=this.sanitizeURL(url);}};;'use strict';const HomeState=(function(){var DB_NAME='homescreen';var GRID_STORE_NAME='grid';var SV_APP_STORE_NAME='svAppsInstalled';var DB_VERSION=2;var database=null;var initQueue=[];function loadInitialState(iterator,success,error){var grid=Configurator.getSection('grid')||[];for(var i=0;i<grid.length;i++){grid[i]={index:i,icons:grid[i]};}
HomeState.saveGrid(grid,function onSaveGrid(){grid.forEach(iterator);success();},error);}
function openDB(success,error){try{var indexedDB=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;}catch(e){error(e);return;}
if(!indexedDB){error('Indexed DB is not available!!!');return;}
var request;var emptyDB=false;try{request=indexedDB.open(DB_NAME,DB_VERSION);}catch(ex){error(ex.message);return;}
request.onsuccess=function(event){database=event.target.result;success(emptyDB);};request.onerror=function(event){error('Database error: '+event.target.errorCode);};request.onupgradeneeded=function(event){var db=event.target.result;var oldVersion=event.oldVersion||0;switch(oldVersion){case 0:emptyDB=true;db.createObjectStore(GRID_STORE_NAME,{keyPath:'index'});case 1:if(!db.objectStoreNames.contains(SV_APP_STORE_NAME)){db.createObjectStore(SV_APP_STORE_NAME,{keyPath:'manifest'});}}};}
function newTxn(storeName,txn_type,callback,successCb,failureCb){if(!database){initQueue.push(newTxn.bind(null,storeName,txn_type,callback,successCb,failureCb));return;}
var txn=database.transaction([storeName],txn_type);var store=txn.objectStore(storeName);txn.oncomplete=function(event){if(successCb){successCb(event);}};txn.onerror=function(event){var target=event.target;console.warn('Caught error on transaction: '+target.error.name);if(failureCb){failureCb(target.errorCode);}};callback(txn,store);}
function saveTable(table,objectsArr,success,error){if(!database){if(error){error('Database is not available');}
return;}
newTxn(table,'readwrite',function(txn,store){store.clear();var len=objectsArr.length;for(var i=0;i<len;i++){store.put(objectsArr[i]);}
if(success){success();}});}
function loadTable(table,iterator,success,error){if(!database){if(error){error('Database is not available');}
return;}
newTxn(table,'readonly',function(txn,store){store.openCursor().onsuccess=function onsuccess(event){var cursor=event.target.result;if(!cursor)
return;iterator(cursor.value);cursor.continue();};},function(){success&&success();},error);}
return{init:function st_init(iteratorGrid,success,error,iteratorSVApps){openDB(function(emptyDB){if(emptyDB){loadInitialState(iteratorGrid,success,error);return;}
HomeState.getGrid(iteratorGrid,success,error);HomeState.getSVApps(iteratorSVApps);},error);},saveGrid:function st_saveGrid(pages,success,error){saveTable(GRID_STORE_NAME,pages,success,error);},saveSVInstalledApps:function st_saveSVInstalledApps(svApps,success,error){saveTable(SV_APP_STORE_NAME,svApps,success,error);},getGrid:function st_getGrid(iterator,success,error){loadTable(GRID_STORE_NAME,iterator,success,error);},getSVApps:function st_getSVApps(iterator,success,error){loadTable(SV_APP_STORE_NAME,iterator,success,error);}};})();;'use strict';var IconRetriever=(function(){var ongoingRequests;var pendingRequests;function retrieve(uid){if(ongoingRequests[uid]){return;}
var request=ongoingRequests[uid]=pendingRequests[uid];delete pendingRequests[uid];if(!request){return;}
var xhr=new XMLHttpRequest({mozAnon:true,mozSystem:true});var icon=request.icon;xhr.open('GET',icon,true);xhr.responseType='blob';try{xhr.send(null);}catch(evt){console.error('Got an exception when trying to load icon "'+icon+' +" falling back to cached icon. Exception is: '+evt.message);setTimeout(function(){postError(request);});return;}
xhr.onload=function onload(evt){var status=xhr.status;if(status!==0&&status!==200){console.error('Got HTTP status '+status+' trying to load icon '+
icon);postError(request,false);return;}
postSuccess(request,xhr.response);};xhr.ontimeout=xhr.onerror=function onerror(evt){console.error(evt.type,' while HTTP GET: ',icon);postError(request,true);};}
function postSuccess(request,response){var uid=request.uid;delete ongoingRequests[uid];if(typeof request.success==='function'){try{request.success(response);}catch(x){console.error('Unexpected exception ',JSON.stringify(x),' while processing: ',request.icon);}}
if(canBeDispatched(pendingRequests[uid])){retrieve(uid);}}
function postError(request,retry){var uid=request.uid;if(typeof request.error==='function'){try{request.error();}catch(x){console.error('Unexpected exception ',JSON.stringify(x),' while processing: ',request.icon);}}
if(retry){pendingRequests[uid]=pendingRequests[uid]||ongoingRequests[uid];delete ongoingRequests[uid];}}
function online(){for(var uid in pendingRequests){retrieve(uid);}}
var HTTP_PROTOCOL='http';function canBeDispatched(request){return(request&&(window.navigator.onLine||request.icon.slice(0,HTTP_PROTOCOL.length)!==HTTP_PROTOCOL));}
return{init:function IconRetriever_init(){ongoingRequests=Object.create(null);pendingRequests=Object.create(null);window.addEventListener('online',online);},get:function IconRetriever_get(request){var uid=request.uid=request.icon.getUID();pendingRequests[uid]=request;pendingRequests[uid].icon=request.icon.descriptor.icon;if(canBeDispatched(pendingRequests[uid])){retrieve(uid);}}};}());;'use strict';function Icon(descriptor,app){this.descriptor=descriptor;this.app=app;this.updateAppStatus(app);}
var SCALE_RATIO=window.devicePixelRatio;var MAX_ICON_SIZE=60;var ICON_PADDING_IN_CANVAS=4;Icon.prototype={MAX_ICON_SIZE:MAX_ICON_SIZE,FALLBACK_DRAG_STOP_DELAY:1000,DEFAULT_BOOKMARK_ICON_URL:window.location.protocol+'//'+
window.location.host+'/style/images/default_favicon.png',DEFAULT_ICON_URL:window.location.protocol+'//'+window.location.host+'/style/images/default.png',DOWNLOAD_ICON_URL:window.location.protocol+'//'+window.location.host+'/style/images/app_downloading.png',CANCELED_ICON_URL:window.location.protocol+'//'+window.location.host+'/style/images/app_paused.png',SHADOW_BLUR:5,SHADOW_OFFSET_Y:2,SHADOW_COLOR:'rgba(0,0,0,0.05)',_descriptorIdentifiers:['manifestURL','entry_point','bookmarkURL','useAsyncPanZoom','desiredPos','desiredScreen','type'],app:null,getUID:function icon_getUID(){var descriptor=this.descriptor;return(descriptor.manifestURL||descriptor.bookmarkURL)+
(descriptor.entry_point?descriptor.entry_point:'');},isOfflineReady:function icon_isOfflineReady(){return this.descriptor.type===GridItemsFactory.TYPE.COLLECTION||!(this.descriptor.isHosted&&!this.descriptor.hasOfflineCache||this.descriptor.type===GridItemsFactory.TYPE.BOOKMARK);},render:function icon_render(){var container=this.container=document.createElement('li');var dataset=container.dataset;dataset.offlineReady=this.isOfflineReady();container.className='icon';if(this.descriptor.hidden){delete this.descriptor.hidden;dataset.visible=false;}
var descriptor=this.descriptor;dataset.isIcon=true;this._descriptorIdentifiers.forEach(function(prop){var value=descriptor[prop];if(value||value===0)
dataset[prop]=value;});if(descriptor.type===GridItemsFactory.TYPE.COLLECTION){dataset.isCollection=true;dataset.collectionId=descriptor.id;dataset.collectionName=descriptor.name;}
var localizedName=this.getName();container.setAttribute('role','button');container.setAttribute('aria-label',localizedName);var icon=this.icon=document.createElement('div');var img=this.img=new Image();img.setAttribute('role','presentation');img.width=MAX_ICON_SIZE+ICON_PADDING_IN_CANVAS;img.height=MAX_ICON_SIZE+ICON_PADDING_IN_CANVAS;img.style.visibility='hidden';if(descriptor.renderedIcon){this.displayRenderedIcon();}else{this.fetchImageData();}
icon.appendChild(img);var wrapper=document.createElement('span');wrapper.className='labelWrapper';var label=this.label=document.createElement('span');label.textContent=localizedName;wrapper.appendChild(label);this.applyOverflowTextMask();icon.appendChild(wrapper);container.appendChild(icon);if(descriptor.removable===true){this.appendOptions();}
if(this.downloading){container.style.visibility='visible';icon.classList.add('loading');}},appendOptions:function icon_appendOptions(container){container=container||this.container;var options=container.querySelector('.options');if(options){return;}
options=document.createElement('span');options.className='options';options.dataset.isIcon=true;container.appendChild(options);},removeOptions:function icon_removeOptions(){var options=this.container.querySelector('.options');if(!options){return;}
this.container.removeChild(options);},applyOverflowTextMask:function icon_applyOverflowTextMask(){var label=this.label;if(TextOverflowDetective.check(label.textContent)){label.parentNode.classList.add('mask');}else{label.parentNode.classList.remove('mask');}},fetchImageData:function icon_fetchImageData(){var descriptor=this.descriptor;var icon=descriptor.icon;if(!icon){this.loadCachedIcon();return;}
this.loadCachedIcon();IconRetriever.get({icon:this,success:function(blob){this.loadImageData(blob);}.bind(this),error:function(){if(this.icon&&!this.downloading&&this.icon.classList.contains('loading')){this.icon.classList.remove('loading');this.img.src=null;}
this.loadCachedIcon();}.bind(this)});},loadCachedIcon:function icon_loadCachedImage(){var oldRenderedIcon=this.oldRenderedIcon;if(oldRenderedIcon&&oldRenderedIcon instanceof Blob){this.renderBlob(oldRenderedIcon);}else{this.loadDefaultIcon();}},loadImageData:function icon_loadImageData(blob){var self=this;var img=new Image();img.src=window.URL.createObjectURL(blob);if(this.icon&&!this.downloading){this.icon.classList.remove('loading');}
img.onload=function icon_loadSuccess(){img.onload=img.onerror=null;window.URL.revokeObjectURL(img.src);self.renderImage(img);self.isDefaultIcon=false;if(!self.app.downloading&&self.descriptor.type!==GridItemsFactory.TYPE.COLLECTION){window.dispatchEvent(new CustomEvent('appInstalled',{'detail':{'app':self.app}}));}};img.onerror=function icon_loadError(){console.error('error while loading the icon',img.src,'. Falling back '+'to default icon.');window.URL.revokeObjectURL(img.src);self.loadDefaultIcon(img);};},loadDefaultIcon:function icon_loadDefaultIcon(img){var image=img||new Image();var self=this;if(self.img&&self.img.src){image.onload=image.onerror=null;return;}
var blob=GridManager.getBlobByDefault(self.app);if(blob===null){image.src=getDefaultIcon(self.app);image.onload=function icon_defaultIconLoadSucess(){image.onload=image.onerror=null;self.renderImage(image);};}else{self.renderBlob(blob);image.onload=image.onerror=null;}
this.isDefaultIcon=true;},renderImageForBookMark:function icon_renderImageForBookmark(img){var self=this;var canvas=document.createElement('canvas');canvas.width=(MAX_ICON_SIZE+ICON_PADDING_IN_CANVAS)*SCALE_RATIO;canvas.height=(MAX_ICON_SIZE+ICON_PADDING_IN_CANVAS)*SCALE_RATIO;var ctx=canvas.getContext('2d');var background=new Image();background.src='style/images/default_background.png';background.onload=function icon_loadBackgroundSuccess(){ctx.shadowColor=self.SHADOW_COLOR;ctx.shadowBlur=self.SHADOW_BLUR;ctx.shadowOffsetY=self.SHADOW_OFFSET_Y;ctx.drawImage(background,2*SCALE_RATIO,2*SCALE_RATIO,MAX_ICON_SIZE*SCALE_RATIO,MAX_ICON_SIZE*SCALE_RATIO);ctx.shadowBlur=0;ctx.shadowOffsetY=0;ctx.mozImageSmoothingEnabled=false;ctx.drawImage(img,16*SCALE_RATIO,16*SCALE_RATIO,32*SCALE_RATIO,32*SCALE_RATIO);canvas.toBlob(self.renderBlob.bind(self));};},renderImage:function icon_renderImage(img){if(this.app&&this.app.iconable){this.renderImageForBookMark(img);return;}
var canvas=this.createCanvas(img,this.descriptor.type);canvas.toBlob(this.renderBlob.bind(this));},createCanvas:function icon_createCanvas(img,type){var canvas=document.createElement('canvas');canvas.width=(MAX_ICON_SIZE+ICON_PADDING_IN_CANVAS)*SCALE_RATIO;canvas.height=(MAX_ICON_SIZE+ICON_PADDING_IN_CANVAS)*SCALE_RATIO;var ctx=canvas.getContext('2d');ctx.clearRect(0,0,canvas.width,canvas.height);if(type!==GridItemsFactory.TYPE.COLLECTION){ctx.shadowColor=this.SHADOW_COLOR;ctx.shadowBlur=this.SHADOW_BLUR;ctx.shadowOffsetY=this.SHADOW_OFFSET_Y;}
img.width=Math.min(MAX_ICON_SIZE,Math.max(img.width,MAX_ICON_SIZE));img.height=Math.min(MAX_ICON_SIZE,Math.max(img.height,MAX_ICON_SIZE));var width=Math.min(img.width*SCALE_RATIO,canvas.width-ICON_PADDING_IN_CANVAS*SCALE_RATIO);var height=Math.min(img.width*SCALE_RATIO,canvas.height-ICON_PADDING_IN_CANVAS*SCALE_RATIO);ctx.drawImage(img,(canvas.width-width)/2,(canvas.height-height)/2,width,height);ctx.fill();return canvas;},loadRenderedIcon:function icon_loadRenderedIcon(callback){var img=this.img;var blob=this.descriptor.renderedIcon;if(!blob){blob=GridManager.getBlobByDefault(this.app);}
img.src=window.URL.createObjectURL(blob);if(callback){img.onload=img.onerror=function done(){callback(this.src);img.onload=img.onerror=null;};}},renderBlob:function icon_renderBlob(blob){this.descriptor.renderedIcon=blob;GridManager.markDirtyState();this.displayRenderedIcon();},displayRenderedIcon:function icon_displayRenderedIcon(){var self=this;this.loadRenderedIcon(function cleanup(url){self.img.style.visibility='visible';window.URL.revokeObjectURL(url);if(self.needsShow)
self.show();});},show:function icon_show(){if(!this.img.naturalWidth){this.needsShow=true;return;}
this.needsShow=false;var container=this.container;container.dataset.visible=true;container.addEventListener('animationend',function animationEnd(e){container.removeEventListener('animationend',animationEnd);delete container.dataset.visible;});},updateAppStatus:function icon_updateAppStatus(app){if(!ScreenLayout.getCurrentLayout('tiny')){MAX_ICON_SIZE=90;}
if(app){this.downloading=app.downloading;this.cancelled=(app.installState==='pending')&&!app.downloading;}else{this.downloading=false;this.cancelled=false;}},update:function icon_update(descriptor,app){this.app=app;this.updateAppStatus(app);var oldDescriptor=this.descriptor;this.descriptor=descriptor;descriptor.removable===true?this.appendOptions():this.removeOptions();this.container.dataset.offlineReady=this.isOfflineReady();if(descriptor.updateTime==oldDescriptor.updateTime&&descriptor.icon==oldDescriptor.icon){this.descriptor.renderedIcon=oldDescriptor.renderedIcon;}else{this.oldRenderedIcon=oldDescriptor.renderedIcon;this.fetchImageData();}
if(descriptor.updateTime!=oldDescriptor.updateTime||descriptor.name!=oldDescriptor.name||descriptor.localizedName!=oldDescriptor.localizedName){this.translate();}},showDownloading:function icon_showDownloading(){this.img.src=this.DOWNLOAD_ICON_URL;this.container.style.visibility='visible';this.icon.classList.add('loading');},showCancelled:function icon_showCancelled(){this.img.src=this.CANCELED_ICON_URL;this.container.style.visibility='visible';this.icon.classList.remove('loading');this.fetchImageData();},remove:function icon_remove(){this.container.parentNode.removeChild(this.container);},setName:function icon_setName(name){if(this.label.textContent===name){return;}
this.label.textContent=this.descriptor.customName=name;if(this.descriptor.type===GridItemsFactory.TYPE.BOOKMARK){this.app.setName(name);}
this.applyOverflowTextMask();GridManager.markDirtyState();},getName:function icon_getName(){var desc=this.descriptor;return desc.customName||desc.localizedName||desc.name;},getURL:function icon_getURL(){return this.app.url||this.descriptor.manifestURL;},setURL:function icon_setURL(url){var descriptor=this.descriptor;if(descriptor.type!==GridItemsFactory.TYPE.BOOKMARK||descriptor.bookmarkURL===url){return;}
GridManager.forgetIcon(this);this.app.setURL(url);this.descriptor.bookmarkURL=this.container.dataset.bookmarkURL=this.app.bookmarkURL;GridManager.rememberIcon(this);GridManager.markDirtyState();},setImage:function icon_setImage(image){this.descriptor.icon=image;this.fetchImageData();},translate:function icon_translate(){var descriptor=this.descriptor;if(descriptor.customName)
return;var app=this.app;if(!app)
return;var manifest=app.manifest||app.updateManifest;if(!manifest)
return;var localizedName=manifest.name;if(descriptor.type===GridItemsFactory.TYPE.COLLECTION){localizedName=navigator.mozL10n.get(manifest.name)||manifest.name;}else if(descriptor.type!==GridItemsFactory.TYPE.BOOKMARK){var iconsAndNameHolder=manifest;var entryPoint=descriptor.entry_point;if(entryPoint)
iconsAndNameHolder=manifest.entry_points[entryPoint];localizedName=new ManifestHelper(iconsAndNameHolder).name;}
this.label.textContent=localizedName;if(descriptor.localizedName!=localizedName){descriptor.localizedName=localizedName;GridManager.markDirtyState();}
this.applyOverflowTextMask();},onDragStart:function icon_onDragStart(x,y){this.initX=x;this.initY=y;var draggableElem=this.draggableElem=document.createElement('div');draggableElem.className='draggable';if(this.descriptor.type!==GridItemsFactory.TYPE.COLLECTION){this.savePostion(draggableElem.dataset);}
this.loadRenderedIcon();var icon=this.icon.cloneNode(true);var img=icon.querySelector('img');img.style.visibility='hidden';img.onload=img.onerror=function unhide(){img.style.visibility='visible';};draggableElem.appendChild(icon);if(this.descriptor.removable===true){this.appendOptions(icon);}
var container=this.container;container.dataset.dragging='true';var rectangle=container.getBoundingClientRect();var style=draggableElem.style;style.left=rectangle.left+'px';style.top=rectangle.top+'px';this.initXCenter=(rectangle.left+rectangle.right)/2;this.initYCenter=(rectangle.top+rectangle.bottom)/2;this.initHeight=rectangle.bottom-rectangle.top;document.body.appendChild(draggableElem);},savePostion:function icon_savePosition(obj){var page;if(this.container.parentNode===DockManager.page.olist){page=DockManager.page;obj.pageType='dock';}else{page=GridManager.pageHelper.getCurrent();obj.pageType='page';obj.pageIndex=GridManager.pageHelper.getCurrentPageNumber();}
obj.iconIndex=page.getIconIndex(this.container);},addClassToDragElement:function icon_addStyleToDragElement(className){this.draggableElem.classList.add(className);},removeClassToDragElement:function icon_addStyleToDragElement(className){this.draggableElem.classList.remove(className);},onDragStop:function icon_onDragStop(callback,tx,ty,scale){var container=this.container;var x=tx,y=ty;if(typeof x==='undefined'){var rect=container.getBoundingClientRect();x=(Math.abs(rect.left+rect.right)/2)%window.innerWidth;x-=this.initXCenter;y=(rect.top+rect.bottom)/2+
(this.initHeight-(rect.bottom-rect.top))/2;y-=this.initYCenter;}
var draggableElem=this.draggableElem;var style=draggableElem.style;style.MozTransition='-moz-transform .4s';style.MozTransform='translate('+x+'px,'+y+'px)';var finishDrag=function(){delete container.dataset.dragging;if(draggableElem){var img=draggableElem.querySelector('img');window.URL.revokeObjectURL(img.src);draggableElem.parentNode.removeChild(draggableElem);}
callback();};var fallbackID=window.setTimeout(function(){fallbackID=null;finishDrag();},this.FALLBACK_DRAG_STOP_DELAY);var content=draggableElem.querySelector('div');scale=typeof scale!=='undefined'?scale:1;content.style.MozTransform='scale('+scale+')';content.addEventListener('transitionend',function tEnd(e){e.target.removeEventListener('transitionend',tEnd);if(fallbackID!==null){window.clearTimeout(fallbackID);finishDrag();}});},getTop:function icon_getTop(){return this.container.getBoundingClientRect().top;},getLeft:function icon_getLeft(){return this.container.getBoundingClientRect().left;},getWidth:function icon_getWidth(){return this.container.getBoundingClientRect().width;},getDescriptor:function icon_getDescriptor(){if(this.isDefaultIcon){delete this.descriptor.renderedIcon;}
return this.descriptor;}};function TemplateIcon(iconable){var descriptor={name:'templateIcon',hidden:true,renderedIcon:null};var app={};if(iconable){app.iconable=true;}
Icon.call(this,descriptor,app);}
TemplateIcon.prototype={__proto__:Icon.prototype,loadDefaultIcon:function ticon_loadDefaultIcon(){var image=new Image();var self=this;image.src=getDefaultIcon(self.app);image.onload=function icon_defaultIconLoadSucess(){image.onload=null;self.renderImage(image);};},renderBlob:function ticon_renderBlob(blob){this.descriptor.renderedIcon=blob;}};function Page(container,icons,numberOfIcons){this.container=this.movableContainer=container;if(icons)
this.render(icons);this.iconsWhileDragging=[];this.maxIcons=numberOfIcons||GridManager.pageHelper.maxIconsPerPage;}
Page.prototype={ICONS_PER_ROW:4,DRAGGING_TRANSITION:'-moz-transform .3s',REARRANGE_DELAY:50,FALLBACK_READY_EVENT_DELAY:1000,DISABLE_TAP_EVENT_DELAY:500,render:function pg_render(icons){this.container.setAttribute('aria-hidden',true);this.olist=document.createElement('ol');for(var i=0,icon;icon=icons[i++];){this.appendIcon(icon);}
this.container.appendChild(this.olist);},moveByWithEffect:function pg_moveByWithEffect(scrollX,duration){var container=this.movableContainer;var style=container.style;style.MozTransform='translateX('+scrollX+'px)';style.MozTransition='-moz-transform '+duration+'ms ease';},moveBy:function pg_moveBy(scrollX){var style=this.movableContainer.style;style.MozTransform='translateX('+scrollX+'px)';style.MozTransition='';},ready:true,setReady:function pg_setReady(value){this.ready=value;if(value){this.container.dispatchEvent(new CustomEvent('onpageready'));}},drop:function pg_drop(originIcon,targetIcon){if(!this.ready||originIcon===targetIcon){return;}
this.setReady(false);var iconList=this.olist.children;if(originIcon&&targetIcon&&iconList.length>1){if(this.iconsWhileDragging.length===0)
this.iconsWhileDragging=Array.prototype.slice.call(iconList,0,iconList.length);this.animate(this.iconsWhileDragging,originIcon.container,targetIcon.container);}else{setTimeout(this.setReady.bind(this,true));}},animate:function pg_animate(children,draggableNode,targetNode){var draggableIndex=children.indexOf(draggableNode);var targetIndex=children.indexOf(targetNode);if(draggableIndex<0||targetIndex<0||targetIndex>=this.maxIcons){setTimeout(this.setReady.bind(this,true));return;}
var upward=draggableIndex<targetIndex;this.draggableNode=draggableNode;this.beforeNode=upward?targetNode.nextSibling:targetNode;this.placeIcon(draggableNode,draggableIndex,targetIndex);var self=this;targetNode.addEventListener('transitionend',function onTransitionEnd(e){e.target.removeEventListener('transitionend',onTransitionEnd);children.splice(draggableIndex,1);children.splice(targetIndex,0,draggableNode);setTimeout(self.setReady.bind(self,true));});if(upward){for(var i=draggableIndex+1;i<=targetIndex;i++)
this.placeIcon(children[i],i,i-1,this.DRAGGING_TRANSITION);}else{for(var i=targetIndex;i<draggableIndex;i++)
this.placeIcon(children[i],i,i+1,this.DRAGGING_TRANSITION);}},doDragLeave:function pg_doReArrange(callback,reflow){this.iconsWhileDragging.forEach(function reset(node){node.style.MozTransform=node.style.MozTransition='';delete node.dataset.posX;delete node.dataset.posY;});this.iconsWhileDragging=[];if(reflow&&this.olist.contains(this.draggableNode))
this.olist.insertBefore(this.draggableNode,this.beforeNode);callback();},onDragLeave:function pg_onDragLeave(callback,reflow){if(this.iconsWhileDragging.length===0){setTimeout(callback);return;}
if(!this.ready){var self=this;var ensureCallbackID=null;var onPageReady=function onPageReady(e){e.target.removeEventListener('onpageready',onPageReady);if(ensureCallbackID!==null){window.clearTimeout(ensureCallbackID);self.doDragLeave(callback,reflow);}};self.container.addEventListener('onpageready',onPageReady);ensureCallbackID=window.setTimeout(function(){ensureCallbackID=null;self.container.removeEventListener('onpageready',onPageReady);self.doDragLeave(function onfinish(){self.setReady(true);callback();},reflow);},this.FALLBACK_READY_EVENT_DELAY);return;}
this.doDragLeave(callback,reflow);},placeIcon:function pg_placeIcon(node,from,to,transition){if(!node)
return;var x=node.dataset.posX=parseInt(node.dataset.posX||0)+
((Math.floor(to%this.ICONS_PER_ROW)-
Math.floor(from%this.ICONS_PER_ROW))*100);var y=node.dataset.posY=parseInt(node.dataset.posY||0)+
((Math.floor(to/this.ICONS_PER_ROW)-
Math.floor(from/this.ICONS_PER_ROW))*100);window.mozRequestAnimationFrame(function(){node.style.MozTransform='translate('+x+'%, '+y+'%)';if(transition)
node.style.MozTransition=transition;});},tap:function pg_tap(elem,callback){if(Homescreen.isInEditMode()){if(elem.classList.contains('options')){var icon=GridManager.getIcon(elem.parentNode.dataset);if(icon.app)
Homescreen.showAppDialog(icon);}else if(elem.dataset.type===GridItemsFactory.TYPE.BOOKMARK){var icon=GridManager.getIcon(elem.dataset);if(icon.app){Homescreen.showEditBookmarkDialog(icon);}}
callback();}else if('isIcon'in elem.dataset&&this.olist===elem.parentNode&&!document.body.hasAttribute('disabled-tapping')){var icon=GridManager.getIcon(elem.dataset);if(!icon.app)
return;if(icon.descriptor.entry_point){this.disableTap(callback);icon.app.launch(icon.descriptor.entry_point);return;}
if(icon.cancelled){GridManager.showRestartDownloadDialog(icon);callback();return;}
this.disableTap(callback);icon.app.launch();}},disableTap:function pg_disableTap(callback){document.body.setAttribute('disabled-tapping',true);var disableTapTimeout=null;var enableTap=function enableTap(){document.removeEventListener('visibilitychange',enableTap);document.removeEventListener('collectionopened',enableTap);window.removeEventListener('hashchange',enableTap);if(disableTapTimeout!==null){window.clearTimeout(disableTapTimeout);disableTapTimeout=null;}
document.body.removeAttribute('disabled-tapping');callback&&callback();};document.addEventListener('visibilitychange',enableTap);document.addEventListener('collectionopened',enableTap);window.addEventListener('hashchange',enableTap);disableTapTimeout=window.setTimeout(enableTap,this.DISABLE_TAP_EVENT_DELAY);},appendIconAt:function pg_appendIconAt(icon,index){var olist=this.olist,children=this.olist.children;if(children[index]&&children[index]===icon.container){return;}
if(!icon.container){icon.render();}
if(children[index]){olist.insertBefore(icon.container,children[index]);}else{olist.appendChild(icon.container);}},prependIcon:function pg_prependIcon(icon){var olist=this.olist;if(olist.children.length>0){olist.insertBefore(icon.container,olist.firstChild);}else{olist.appendChild(icon.container);}},popIcon:function pg_popIcon(){var icon=this.getLastIcon();icon.remove();return icon;},getMisplacedIcons:function pg_getMisplacedIcons(currentScreen){var misplaced=[];var appsDesiredScreen=this.olist.querySelectorAll('li[data-desired-screen]');var numApps=appsDesiredScreen.length;for(var i=numApps-1;i>=0;i--){var desiredScreen=appsDesiredScreen[i].dataset.desiredScreen;if(desiredScreen>currentScreen){misplaced.push(GridManager.getIcon(appsDesiredScreen[i].dataset));}}
return misplaced;},insertBeforeLastIcon:function pg_insertBeforeLastIcon(icon){var olist=this.olist;if(olist.children.length>0){olist.insertBefore(icon.container,olist.lastChild);}},getLastIcon:function pg_getLastIcon(){var lastIcon=this.olist.lastChild;if(this.iconsWhileDragging.length>0)
lastIcon=this.iconsWhileDragging[this.iconsWhileDragging.length-1];if(!lastIcon)
return null;return GridManager.getIcon(lastIcon.dataset);},getLastVisibleIcon:function pg_getLastVisibleIcon(){if(this.getNumIcons()<=this.maxIcons){return this.getLastIcon();}else{var node=this.olist.children[this.maxIcons-1];if(this.iconsWhileDragging.length>0)
node=this.iconsWhileDragging[this.maxIcons-1];if(!node){return null;}
return GridManager.getIcon(node.dataset);}},getFirstIcon:function pg_getFirstIcon(){var firstIcon=this.olist.firstChild;if(this.iconsWhileDragging.length>0)
firstIcon=this.iconsWhileDragging[0];if(!firstIcon)
return null;return GridManager.getIcon(firstIcon.dataset);},_moveAhead:function pg_moveAhead(pos){var iconList=this.olist.children;var numIcons=iconList.length;for(var i=pos;i<numIcons;i++){var iconPos=iconList[i].dataset&&iconList[i].dataset.desiredPos;if(i>iconPos){this.olist.insertBefore(iconList[i],iconList[i-1]);}}},hasEmptySlot:function pg_hasEmptySlot(){return this.getNumIcons()<this.maxIcons;},_insertIcon:function pg_insertIcon(icon){var iconList=this.olist.children;var container=icon.container;if(icon.descriptor&&icon.descriptor.desiredPos!==undefined&&Configurator.isSimPresentOnFirstBoot){var desiredPos=icon.descriptor.desiredPos;var manifest=icon.descriptor.manifestURL;GridManager.addPreviouslyInstalled(manifest);var numIcons=iconList.length;for(var i=0;(i<numIcons)&&(i<=desiredPos);i++){var iconPos=iconList[i].dataset&&iconList[i].dataset.desiredPos;if((iconPos>desiredPos)||(i===desiredPos)){this.olist.insertBefore(container,iconList[i]);this._moveAhead(i+1);return;}}}
this.olist.appendChild(container);},appendIcon:function pg_appendIcon(icon){if(!icon.container){icon.render();}
this._insertIcon(icon);},appendIconVisible:function pg_appendIconVisible(icon){if(this.getNumIcons()>=this.maxIcons){this.insertBeforeLastIcon(icon);}else{this.appendIcon(icon);}},containsIcon:function pg_containsIcon(icon){return icon.container.parentNode===this.olist;},destroy:function pg_destroy(){this.container.parentNode.removeChild(this.container);},getNumIcons:function pg_getNumIcons(){return this.olist.children.length;},getIconDescriptors:function pg_getIconDescriptors(){var nodes=this.olist.children;return Array.prototype.map.call(nodes,function marshall(node){var icon=GridManager.getIcon(node.dataset);return icon.getDescriptor();});},getIndex:function pg_getIndex(){var pages=this.container.parentNode.children;pages=Array.prototype.slice.call(pages,0,pages.length);return pages.indexOf(this.container);},getIconIndex:function pg_getIconIndex(icon){var icons=this.olist.children;icons=Array.prototype.slice.call(icons,0,icons.length);return icons.indexOf(icon);}};function getDefaultIcon(app){if(app&&app.iconable){return Icon.prototype.DEFAULT_BOOKMARK_ICON_URL;}else{return Icon.prototype.DEFAULT_ICON_URL;}}
function extend(subClass,superClass){var F=function(){};F.prototype=superClass.prototype;subClass.prototype=new F();subClass.prototype.constructor=subClass;subClass.uber=superClass.prototype;}
function Dock(container,icons){Page.call(this,container,icons);}
extend(Dock,Page);var dockProto=Dock.prototype;dockProto.baseRender=Page.prototype.render;dockProto.render=function dk_render(apps,target){this.baseRender(apps,target);this.movableContainer=this.olist;};dockProto.moveByWithEffect=function dk_moveByWithEffect(scrollX,duration){var container=this.movableContainer;var style=container.style;style.MozTransform='translateX('+scrollX+'px)';style.MozTransition='-moz-transform '+duration+'ms ease';};dockProto.moveByWithDuration=function dk_moveByWithDuration(scrollX,duration){var style=this.movableContainer.style;style.MozTransform='translateX('+scrollX+'px)';style.MozTransition='-moz-transform '+duration+'ms ease';};dockProto.getLeft=function dk_getLeft(){return this.olist.getBoundingClientRect().left;};dockProto.getTransform=function dk_getTransform(){return this.movableContainer.style.MozTransform;};dockProto.getRight=function dk_getRight(){var children=this.olist.children;var lastChild=children[children.length-1];if(!lastChild){return 0;}
return lastChild.getBoundingClientRect().right;};dockProto.getWidth=function dk_getWidth(){return this.olist.clientWidth;};dockProto.placeIcon=function pg_placeIcon(node,from,to,transition){if(!node)
return;var x=node.dataset.posX=parseInt(node.dataset.posX||0)+(to-from)*100;node.style.MozTransform='translateX('+x+'%)';if(transition)
node.style.MozTransition=transition;};var TextOverflowDetective=(function(){var iconFakeWrapperWidth;var iconFakeLabel;function init(){var fakeIconName=document.querySelector('#fake-icon-name-wrapper');iconFakeWrapperWidth=fakeIconName.offsetWidth;iconFakeLabel=document.querySelector('#fake-icon-name');}
function check(text){if(!iconFakeLabel||!iconFakeWrapperWidth){init();}
iconFakeLabel.textContent=text;return iconFakeLabel.offsetWidth>=iconFakeWrapperWidth;}
return{check:check};})();;'use strict';var PaginationBar=(function(){var style,previousTotal,scroller;var dir=document.documentElement.dir==='rtl'?-100:100;return{init:function pb_init(element){scroller=(typeof element=='object')?element:document.querySelector(element);style=scroller.style;scroller.addEventListener('keypress',this);},show:function pb_show(){style.visibility='visible';},hide:function pb_hide(){style.visibility='hidden';},update:function pb_update(current,total){scroller.setAttribute('aria-valuenow',current);scroller.setAttribute('aria-valuemax',total-1);if(total&&previousTotal!==total){style.width=(100/total)+'%';scroller.getBoundingClientRect();previousTotal=total;}
style.MozTransform='translateX('+current*dir+'%)';},handleEvent:function pb_handleEvent(evt){if(evt.type!='keypress'||!evt.ctrlKey)
return;switch(evt.keyCode){case evt.DOM_VK_RIGHT:GridManager.goToNextPage();break;case evt.DOM_VK_LEFT:GridManager.goToPreviousPage();break;}}};}());;'use strict';var IconManager=(function(){var noop=function(){};var activeTimeout=null;var activeDelay=0;var removeActive=noop;function addActive(target){if('isIcon'in target.dataset){removeActive!==noop&&removeActive();removeActive=function _removeActive(){target.classList.remove('active');clearActiveTimeout();removeActive=noop;};if(activeDelay){activeTimeout=setTimeout(function(){target.classList.add('active');activeTimeout=null;},activeDelay);}else{target.classList.add('active');}}else{removeActive=noop;}}
function clearActiveTimeout(){if(activeTimeout!==null){clearTimeout(activeTimeout);activeTimeout=null;}}
return{init:function im_init(time){activeDelay=time;},addActive:function im_addActive(element){addActive(element);},removeActive:function im_removeActive(){removeActive();},cancelActive:clearActiveTimeout};}());;'use strict';var DockManager=(function(){var container,dock;var notTinyLayout=!ScreenLayout.getCurrentLayout('tiny');var MAX_NUM_ICONS=notTinyLayout?8:7;var maxNumAppInViewPort=notTinyLayout?6:4,maxOffsetLeft;var duration=300;var initialOffsetLeft,initialOffsetRight,numApps,cellWidth=0;var isPanning=false,startEvent,currentX,deltaX,tapThreshold;var isTouch='ontouchstart'in window;var touchstart=isTouch?'touchstart':'mousedown';var touchmove=isTouch?'touchmove':'mousemove';var touchend=isTouch?'touchend':'mouseup';var getX=(function getXWrapper(){return isTouch?function(e){return e.touches[0].pageX}:function(e){return e.pageX};})();function handleEvent(evt){switch(evt.type){case touchstart:evt.stopPropagation();initialOffsetLeft=dock.getLeft();initialOffsetRight=dock.getRight();numApps=dock.getNumIcons();startEvent=isTouch?evt.touches[0]:evt;attachEvents();IconManager.addActive(evt.target);break;case touchmove:deltaX=getX(evt)-startEvent.pageX;if(!isPanning){if(Math.abs(deltaX)<tapThreshold){return;}else{isPanning=true;IconManager.removeActive();}}
if(numApps<=maxNumAppInViewPort){return;}
if(deltaX<0){var windowWidth=ScreenHelper.width;if(initialOffsetRight===windowWidth){return;}
if(initialOffsetRight+deltaX<windowWidth){deltaX=windowWidth-initialOffsetRight;}}else{if(initialOffsetLeft===0){return;}
if(initialOffsetLeft+deltaX>0){deltaX=-initialOffsetLeft;}}
dock.moveBy(initialOffsetLeft+deltaX);break;case touchend:releaseEvents();if(!isPanning){IconManager.cancelActive();dock.tap(evt.target,IconManager.removeActive);}else{isPanning=false;onTouchEnd(deltaX);}
break;}}
function contextmenu(evt){if(isPanning){return;}
Homescreen.setMode('edit');IconManager.removeActive();LazyLoader.load(['style/dragdrop.css','js/dragdrop.js'],function(){DragDropManager.init();DragDropManager.start(evt,{'x':startEvent.pageX,'y':startEvent.pageY});});}
function goNextSet(){calculateDimentions(dock.getNumIcons());if(dock.getLeft()<=maxOffsetLeft){return;}
dock.moveByWithDuration(maxOffsetLeft,duration);}
function goPreviousSet(){calculateDimentions(dock.getNumIcons());if(dock.getLeft()>=0){return;}
dock.moveByWithDuration(0,duration);}
function onTouchEnd(scrollX){if(dock.getNumIcons()<=maxNumAppInViewPort||dock.getLeft()===0||dock.getRight()===ScreenHelper.width){return;}
dock.moveByWithEffect(scrollX>0?0:maxOffsetLeft,duration);container.addEventListener('transitionend',function transEnd(e){container.removeEventListener('transitionend',transEnd);});}
function releaseEvents(){window.removeEventListener(touchmove,handleEvent);window.removeEventListener(touchend,handleEvent);}
function attachEvents(){window.addEventListener(touchmove,handleEvent);window.addEventListener(touchend,handleEvent);}
function rePosition(numApps,callback){if(numApps>maxNumAppInViewPort&&dock.getLeft()<0&&dock.getRight()>ScreenHelper.width){callback&&setTimeout(callback);return;}
var beforeTransform=dock.getTransform();dock.moveByWithDuration(maxOffsetLeft/2,.5);if(beforeTransform===dock.getTransform()){callback&&callback();return;}
container.addEventListener('transitionend',function transEnd(e){container.removeEventListener('transitionend',transEnd);callback&&callback();});}
function calculateDimentions(numIcons){if(numIcons<=maxNumAppInViewPort){container.classList.remove('scrollable');}else{container.classList.add('scrollable');}
if(numIcons>0){cellWidth=dock.getFirstIcon().getWidth();}
if(cellWidth===0){cellWidth=ScreenHelper.width/maxNumAppInViewPort;}
maxOffsetLeft=ScreenHelper.width-numIcons*cellWidth;}
return{init:function dm_init(containerEl,page,pTapThreshold){tapThreshold=pTapThreshold;container=containerEl;container.addEventListener(touchstart,handleEvent);dock=this.page=page;var numIcons=dock.getNumIcons();if(numIcons>maxNumAppInViewPort){container.classList.add('scrollable');}
calculateDimentions(numIcons);if(numIcons<=maxNumAppInViewPort){dock.moveBy(maxOffsetLeft/2);}
container.removeAttribute('aria-hidden');},onDragStop:function dm_onDragStop(callback){container.addEventListener(touchstart,handleEvent);var numApps=dock.getNumIcons();if(numApps===0){callback&&setTimeout(callback);return;}
calculateDimentions(numApps);rePosition(numApps,callback);},onDragStart:function dm_onDragStart(){releaseEvents();container.removeEventListener(touchstart,handleEvent);},page:null,afterRemovingApp:function dm_afterRemovingApp(){var windowWidth=ScreenHelper.width;maxOffsetLeft=windowWidth-dock.getNumIcons()*cellWidth;var numApps=dock.getNumIcons();if(numApps>maxNumAppInViewPort&&dock.getRight()>=windowWidth){return;}
calculateDimentions(numApps);rePosition(numApps);},isFull:function dm_isFull(){return dock.getNumIcons()===MAX_NUM_ICONS;},goNextSet:goNextSet,goPreviousSet:goPreviousSet,calculateDimentions:calculateDimentions,get cellWidth(){return cellWidth;},get maxOffsetLeft(){return maxOffsetLeft;},contextmenu:contextmenu};}());;'use strict';var GridManager=(function(){var notTinyLayout=!ScreenLayout.getCurrentLayout('tiny');var PREFERRED_ICON_SIZE=(notTinyLayout?90:60)*(window.devicePixelRatio||1);var SAVE_STATE_TIMEOUT=100;var BASE_HEIGHT=460;var DEVICE_HEIGHT=ScreenHelper.height;var HIDDEN_ROLES=['system','input','homescreen','search'];var pendingInstallRequests=[];function isHiddenApp(role){if(!role){return false;}
return(HIDDEN_ROLES.indexOf(role)!==-1);}
var svPreviouslyInstalledApps=[];var launchPathBlacklist=[];var container;function getWindowWidthMinusOne(){return ScreenHelper.width-0.001;}
var swipeThreshold,swipeFriction,tapThreshold;var dragging=false;var defaultAppIcon,defaultBookmarkIcon;var kPageTransitionDuration;var pages=[];var currentPage=0;var saveStateTimeout=null;var _=navigator.mozL10n.get;var limits={left:0,right:0};var EVME_PAGE_STATE_INDEX=1;var MAX_ICONS_PER_PAGE=4*4;if(ScreenHelper.height-BASE_HEIGHT>BASE_HEIGHT/5||ScreenHelper.height/ScreenHelper.width>=1.6){MAX_ICONS_PER_PAGE+=4;}
if(notTinyLayout){MAX_ICONS_PER_PAGE=6*3;}
var MAX_ICONS_PER_EVME_PAGE=MAX_ICONS_PER_PAGE;function setMaxIconsToSearchPage(){if(!document.body.classList.contains('searchPageEnabled')){return;}
MAX_ICONS_PER_EVME_PAGE-=4;if(notTinyLayout){MAX_ICONS_PER_EVME_PAGE-=6;}}
var startEvent,isPanning=false,startX,currentX,deltaX,removePanHandler,noop=function(){};var isTouch='ontouchstart'in window;var touchstart=isTouch?'touchstart':'mousedown';var touchmove=isTouch?'touchmove':'mousemove';var touchend=isTouch?'touchend':'mouseup';var getX=(function getXWrapper(){return isTouch?function(e){return e.touches[0].pageX;}:function(e){return e.pageX;};})();var panningResolver;function createPanningResolver(){var configuration=Configurator.getSection('prediction')||{enabled:false};var lookahead,lastPrediction,x0,t0,x1,t1=0,dx,velocity;function calculateVelocity(evt){if(t1<touchStartTimestamp){x0=startX;t0=touchStartTimestamp;}else{x0=x1;t0=t1;}
x1=currentX;t1=evt.timeStamp;dx=x1-x0;velocity=dx/(t1-t0);}
var getDeltaX;if(!isTouch||!configuration.enabled){getDeltaX=function getDeltaX(evt){calculateVelocity(evt);return currentX-startX;};}else{getDeltaX=function getDeltaX(evt){calculateVelocity(evt);if(lookahead===0){return currentX-startX;}
var adjustment=velocity*lookahead;var prediction=Math.round(x1+adjustment-startX);var windowWidth=ScreenHelper.width;if(prediction>=windowWidth){prediction=windowWidth-1;}
else if(prediction<=-windowWidth){prediction=-windowWidth+1;}
if(lastPrediction!==null){var deltaP=prediction-lastPrediction;if((deltaP>0&&dx<0)||(deltaP<0&&dx>0)){lookahead=lookahead>>1;startX+=deltaP;prediction=lastPrediction;}}
lastPrediction=prediction;return prediction;};}
return{reset:function reset(){lastPrediction=null;lookahead=configuration.lookahead;t1=0;velocity=0;},getDeltaX:getDeltaX,getVelocity:function getVelocity(){return velocity;}};}
function tap(element){releaseEvents();IconManager.cancelActive();pageHelper.getCurrent().tap(element,IconManager.removeActive);}
function handleEvent(evt){switch(evt.type){case touchstart:if(currentPage)
evt.stopPropagation();touchStartTimestamp=evt.timeStamp;startEvent=isTouch?evt.touches[0]:evt;deltaX=0;attachEvents();removePanHandler=noop;isPanning=false;IconManager.addActive(evt.target);panningResolver.reset();break;case touchmove:if(evt.preventPanning===true){return;}
startX=startEvent.pageX;currentX=getX(evt);if(currentX===startX)
return;window.removeEventListener(touchmove,handleEvent);var current=pages[currentPage].container.style;var forward=deltaX<0;IconManager.removeActive();var refresh;var previous,next,pan;var windowWidthMinusOne=getWindowWidthMinusOne();if(currentPage===0){next=pages[currentPage+1].container.style;refresh=function(e){if(deltaX<=0){next.MozTransform='translateX('+(windowWidthMinusOne+deltaX)+'px)';current.MozTransform='translateX('+deltaX+'px)';}else{startX=currentX;}};}else if(currentPage===pages.length-1){previous=pages[currentPage-1].container.style;refresh=function(e){if(deltaX>=0){previous.MozTransform='translateX('+(-windowWidthMinusOne+deltaX)+'px)';current.MozTransform='translateX('+deltaX+'px)';}else{startX=currentX;}};}else{previous=pages[currentPage-1].container.style;next=pages[currentPage+1].container.style;refresh=function(e){if(deltaX>=0){previous.MozTransform='translateX('+(-windowWidthMinusOne+deltaX)+'px)';if(forward){forward=false;next.MozTransform='translateX('+windowWidthMinusOne+'px)';}}else{next.MozTransform='translateX('+(windowWidthMinusOne+deltaX)+'px)';if(!forward){forward=true;previous.MozTransform='translateX(-'+windowWidthMinusOne+'px)';}}
current.MozTransform='translateX('+deltaX+'px)';};}
pan=function(e){e.preventDefault();e.stopImmediatePropagation();currentX=getX(e);deltaX=panningResolver.getDeltaX(e);if(!isPanning&&Math.abs(deltaX)>=tapThreshold){isPanning=true;}
window.mozRequestAnimationFrame(refresh);};window.addEventListener(touchmove,pan,true);removePanHandler=function removePanHandler(e){touchEndTimestamp=e?e.timeStamp:0;window.removeEventListener(touchend,removePanHandler,true);window.removeEventListener(touchmove,pan,true);window.mozRequestAnimationFrame(function panTouchEnd(){onTouchEnd(deltaX,e);});};window.addEventListener(touchend,removePanHandler,true);window.removeEventListener(touchend,handleEvent);pan(evt);break;case touchend:tap(evt.target);break;case'wheel':if(evt.deltaMode===evt.DOM_DELTA_PAGE&&evt.deltaX){if(evt.deltaX>0&&currentPage<pages.length-1){GridManager.goToNextPage();}else if(evt.deltaX<0&&currentPage>0){GridManager.goToPreviousPage();}
evt.stopPropagation();evt.preventDefault();}
break;}}
function contextmenu(evt){if(isPanning){return;}
removePanHandler();Homescreen.setMode('edit');IconManager.removeActive();LazyLoader.load(['style/dragdrop.css','js/dragdrop.js'],function(){DragDropManager.init();DragDropManager.start(evt,{'x':startEvent.pageX,'y':startEvent.pageY});});}
function cancelPanning(){removePanHandler();}
function onTouchEnd(deltaX,evt){var page=currentPage;var velocity=panningResolver.getVelocity();var distanceToTravel=0.5*Math.abs(velocity)*velocity/swipeFriction;if(Math.abs(deltaX+distanceToTravel)>swipeThreshold||(Math.abs(deltaX)>tapThreshold&&touchEndTimestamp-touchStartTimestamp<kPageTransitionDuration)){var forward=dirCtrl.goesForward(deltaX);if(forward&&currentPage<pages.length-1){page=page+1;}else if(!forward&&page>0){page=page-1;}}else if(!isPanning&&evt){tap(evt.target);}
goToPage(page);}
function attachEvents(){window.addEventListener(touchmove,handleEvent);window.addEventListener(touchend,handleEvent);}
function releaseEvents(){window.removeEventListener(touchmove,handleEvent);window.removeEventListener(touchend,handleEvent);}
function exitFromEditMode(){markDirtyState();goToPage(currentPage);}
function ensurePanning(){container.addEventListener(touchstart,handleEvent,true);}
function markDirtyState(){if(saveStateTimeout!=null){window.clearTimeout(saveStateTimeout);}
saveStateTimeout=window.setTimeout(function saveStateTrigger(){saveStateTimeout=null;pageHelper.saveAll();HomeState.saveSVInstalledApps(GridManager.svPreviouslyInstalledApps);},SAVE_STATE_TIMEOUT);}
function goToPageCallback(index,fromPage,toPage,dispatchEvents,callback){if(dispatchEvents){fromPage.container.dispatchEvent(new CustomEvent('gridpagehideend'));toPage.container.dispatchEvent(new CustomEvent('gridpageshowend'));}
var windowWidthMinusOne=getWindowWidthMinusOne();if(index){var previous=pages[index-1].container.style;previous.MozTransition='';previous.MozTransform='translateX(-'+windowWidthMinusOne+'px)';}
if(index<pages.length-1){var next=pages[index+1].container.style;next.MozTransition='';next.MozTransform='translateX('+windowWidthMinusOne+'px)';}
var current=toPage.container.style;current.MozTransition='';current.MozTransform='translateX(0)';fromPage.container.setAttribute('aria-hidden',true);toPage.container.removeAttribute('aria-hidden');if(callback){setTimeout(callback,0);}}
var touchStartTimestamp=0;var touchEndTimestamp=0;var lastGoingPageTimestamp=0;function goToPage(index,callback){if(index<0||index>=pages.length)
return;touchEndTimestamp=touchEndTimestamp||lastGoingPageTimestamp;var delay=touchEndTimestamp-lastGoingPageTimestamp||kPageTransitionDuration;lastGoingPageTimestamp+=delay;var duration=delay<kPageTransitionDuration?delay:kPageTransitionDuration;var previousPage=pages[currentPage];var newPage=pages[index];if(index>=currentPage){var forward=1;var start=currentPage;var end=index;}else{var forward=-1;var start=index;var end=currentPage;}
currentPage=index;updatePaginationBar();var windowWidthMinusOne=getWindowWidthMinusOne();if(previousPage===newPage){if(newPage.container.getBoundingClientRect().left!==0){if(index>0){pages[index-1].moveByWithEffect(-windowWidthMinusOne,duration);}
newPage.moveByWithEffect(0,duration);if(index<pages.length-1){pages[index+1].moveByWithEffect(windowWidthMinusOne,duration);}
container.addEventListener('transitionend',function transitionEnd(e){container.removeEventListener('transitionend',transitionEnd);goToPageCallback(index,previousPage,newPage,false,callback);});}else{goToPageCallback(index,previousPage,newPage,false,callback);}
return;}
previousPage.container.dispatchEvent(new CustomEvent('gridpagehidestart'));newPage.container.dispatchEvent(new CustomEvent('gridpageshowstart'));previousPage.moveByWithEffect(-forward*windowWidthMinusOne,duration);newPage.moveByWithEffect(0,duration);container.addEventListener('transitionend',function transitionEnd(e){container.removeEventListener('transitionend',transitionEnd);goToPageCallback(index,previousPage,newPage,true,callback);});}
function goToLandingPage(){goToPage(0);}
function goToNextPage(callback){goToPage(currentPage+1,callback);}
function goToPreviousPage(callback){goToPage(currentPage-1,callback);}
function updatePaginationBar(){PaginationBar.update(currentPage,pages.length);}
function updatePageSetSize(){for(var i in pages){var container=pages[i].container;container.setAttribute('aria-setsize',pages.length);container.setAttribute('aria-posinset',Number(i)+1);}}
var dirCtrl={};function setDirCtrl(){function goesLeft(x){return(x>0);}
function goesRight(x){return(x<0);}
function limitLeft(x){return(x<limits.left);}
function limitRight(x){return(x>limits.right);}
var rtl=(document.documentElement.dir=='rtl');dirCtrl.offsetPrev=rtl?-1:1;dirCtrl.offsetNext=rtl?1:-1;dirCtrl.limitPrev=rtl?limitRight:limitLeft;dirCtrl.limitNext=rtl?limitLeft:limitRight;dirCtrl.translatePrev=rtl?'translateX(100%)':'translateX(-100%)';dirCtrl.translateNext=rtl?'translateX(-100%)':'translateX(100%)';dirCtrl.goesForward=rtl?goesLeft:goesRight;}
var haveLocale=false;function localize(){setDirCtrl();for(var manifestURL in appIcons){var iconsForApp=appIcons[manifestURL];for(var entryPoint in iconsForApp){iconsForApp[entryPoint].translate();}}
for(var bookmarkURL in bookmarkIcons){bookmarkIcons[bookmarkURL].translate();}
haveLocale=true;}
function getFirstPageWithEmptySpace(pageOffset){pageOffset=pageOffset!==null&&pageOffset?pageOffset:0;for(var i=pageOffset,page;page=pages[i++];){if(page.hasEmptySlot()){return i-1;}}
return pages.length;}
function removeEmptyPages(){var oldCurrentPage=currentPage;pages.forEach(function checkIsEmpty(page,index){if(index===0){return;}
if(page.getNumIcons()===0){pageHelper.remove(index);if(currentPage>=index)
currentPage-=1;}});if(oldCurrentPage>currentPage)
goToPage(currentPage);}
function pageOverflowed(page){return page.getNumIcons()>page.maxIcons;}
function ensurePagesOverflow(callback){ensurePageOverflow(0,callback);}
function ensurePageOverflow(index,callback){var page=pages[index];if(!page){callback();return;}
if(!pageOverflowed(page)){ensurePageOverflow(index+1,callback);return;}
var propagateIco=page.popIcon();if(index===pages.length-1){propagateIco.loadRenderedIcon(function loaded(url){pageHelper.addPage([propagateIco]);window.URL.revokeObjectURL(url);ensurePageOverflow(pageOverflowed(page)?index:index+1,callback);});}else{propagateIco.loadRenderedIcon(function loaded(url){pages[index+1].prependIcon(propagateIco);window.URL.revokeObjectURL(url);ensurePageOverflow(pageOverflowed(page)?index:index+1,callback);});}}
var pageHelper={maxIconsPerPage:MAX_ICONS_PER_PAGE,addPage:function(icons,numberOficons){var pageElement=document.createElement('div');var page=new Page(pageElement,icons,numberOficons||MAX_ICONS_PER_PAGE);pages.push(page);pageElement.className='page';pageElement.setAttribute('role','region');container.appendChild(pageElement);if(currentPage==pages.length-2){goToPage(currentPage);}
updatePaginationBar();updatePageSetSize();},remove:function gm_remove(index){pages[index].destroy();pages.splice(index,1);updatePaginationBar();updatePageSetSize();},saveAll:function(){var state=pages.slice(0);state.unshift(DockManager.page);for(var i=0;i<state.length;i++){var page=state[i];state[i]={index:i,icons:page.getIconDescriptors()};}
HomeState.saveGrid(state);},getNext:function(){return pages[currentPage+1];},getPrevious:function(){return pages[currentPage-1];},getCurrent:function(){return pages[currentPage];},getLast:function(){return pages[pages.length-1];},getCurrentPageNumber:function(){return currentPage;},getPage:function(index){return pages[index];},getTotalPagesNumber:function(){return pages.length;}};var bookmarkIcons;var appIcons;var appsByOrigin;var bookmarksByOrigin;function rememberIcon(icon){var descriptor=icon.descriptor;if(descriptor.bookmarkURL){bookmarkIcons[descriptor.bookmarkURL]=icon;return;}
var iconsForApp=appIcons[descriptor.manifestURL];if(!iconsForApp)
iconsForApp=appIcons[descriptor.manifestURL]=Object.create(null);iconsForApp[descriptor.entry_point||'']=icon;}
function forgetIcon(icon){var descriptor=icon.descriptor;if(descriptor.bookmarkURL){delete bookmarkIcons[descriptor.bookmarkURL];return;}
var iconsForApp=appIcons[descriptor.manifestURL];if(!iconsForApp)
return;delete iconsForApp[descriptor.entry_point||''];}
function getIcon(descriptor){if(descriptor.bookmarkURL)
return bookmarkIcons[descriptor.bookmarkURL];var iconsForApp=appIcons[descriptor.manifestURL];return iconsForApp&&iconsForApp[descriptor.entry_point||''];}
function getIconByOrigin(origin,entryPoint){var app=appsByOrigin[origin];return app?getIcon(buildDescriptor(app,entryPoint)):undefined;}
function getIconsForApp(app){return appIcons[app.manifestURL];}
function getIconForBookmark(bookmarkURL){return bookmarkIcons[bookmarkURL];}
function getApps(expandApps,suppressHiddenRoles){var apps=[];for(var origin in appsByOrigin){var app=appsByOrigin[origin];var manifest=app.manifest||app.updateManifest;if(!manifest||app.type===GridItemsFactory.TYPE.COLLECTION||(suppressHiddenRoles&&isHiddenApp(manifest.role))){continue;}
if(expandApps&&manifest.entry_points){var entryPoints=manifest.entry_points;for(var entryPoint in entryPoints){if(!entryPoints[entryPoint].icons){continue;}
apps.push(new Icon(buildDescriptor(app,entryPoint),app));}
continue;}
apps.push(new Icon(buildDescriptor(app),app));}
return apps;}
function getApp(origin){var app=appsByOrigin[origin]||bookmarkIcons[origin].app;if(app){return new Icon(buildDescriptor(app),app);}
return null;}
function getCollections(){var apps=[],app;for(var origin in appsByOrigin){app=appsByOrigin[origin];if(app.type===GridItemsFactory.TYPE.COLLECTION){apps.push(app);}}
return apps;}
function initUI(selector){container=document.querySelector(selector);container.addEventListener('wheel',handleEvent);ensurePanning();limits.left=container.offsetWidth*0.05;limits.right=container.offsetWidth*0.95;setDirCtrl();for(var i=0;i<container.children.length;i++){var pageElement=container.children[i];var page=new Page(pageElement,null);pages.push(page);}
panningResolver=createPanningResolver();}
function addSVEventListener(){window.addEventListener('singlevariant-ready',function svFileReady(ev){window.removeEventListener('singlevariant-ready',svFileReady);pendingInstallRequests.forEach(GridManager.install);});}
function initApps(callback){var appMgr=navigator.mozApps.mgmt;if(!appMgr){setTimeout(callback);return;}
appMgr.oninstall=function oninstall(event){if(Configurator.isSingleVariantReady){GridManager.install(event.application);}else{pendingInstallRequests.push(event.application);}};appMgr.onuninstall=function onuninstall(event){GridManager.uninstall(event.application);};appMgr.getAll().onsuccess=function onsuccess(event){var iconsByManifestURL=Object.create(null);for(var manifestURL in appIcons){iconsByManifestURL[manifestURL]=appIcons[manifestURL];}
pageHelper.addPage([]);var apps=event.target.result;apps.forEach(function eachApp(app){delete iconsByManifestURL[app.manifestURL];processApp(app,null,EVME_PAGE_STATE_INDEX);});for(var origin in bookmarksByOrigin){appsByOrigin[origin]=bookmarksByOrigin[origin];}
bookmarksByOrigin=null;for(var manifestURL in iconsByManifestURL){var iconsForApp=iconsByManifestURL[manifestURL];for(var entryPoint in iconsForApp){var icon=iconsForApp[entryPoint];if(icon){icon.remove();markDirtyState();}}}
ensurePagesOverflow(removeEmptyPages);callback();};}
function convertDescriptorsToIcons(pageState){var icons=pageState.icons;for(var i=0;i<icons.length;i++){var descriptor=icons[i];var app=null;if(descriptor.bookmarkURL&&!descriptor.type){descriptor.type=GridItemsFactory.TYPE.BOOKMARK;}
if(descriptor.type===GridItemsFactory.TYPE.BOOKMARK||descriptor.type===GridItemsFactory.TYPE.COLLECTION||descriptor.role===GridItemsFactory.TYPE.COLLECTION){if(descriptor.manifestURL){descriptor.id=descriptor.bookmarkURL=descriptor.manifestURL;descriptor.type=GridItemsFactory.TYPE.COLLECTION;}
app=GridItemsFactory.create(descriptor);if(haveLocale&&app.type===GridItemsFactory.TYPE.COLLECTION){descriptor.localizedName=_(app.manifest.name);}
bookmarksByOrigin[app.origin]=app;}
var icon=icons[i]=new Icon(descriptor,app);rememberIcon(icon);}
return icons;}
function processApp(app,callback,gridPageOffset,gridPosition){appsByOrigin[app.origin]=app;var manifest=app.manifest?app.manifest:app.updateManifest;if(!manifest)
return;var entryPoints=manifest.entry_points;if(!entryPoints||manifest.type!=='certified'){createOrUpdateIconForApp(app,null,gridPageOffset,gridPosition);return;}
for(var entryPoint in entryPoints){if(!entryPoints[entryPoint].icons)
continue;if(launchPathBlacklist.length===0){createOrUpdateIconForApp(app,entryPoint,gridPageOffset,gridPosition);continue;}
var found=false;for(var i=0,elemNum=launchPathBlacklist.length;i<elemNum;i++){if(entryPoints[entryPoint].launch_path===launchPathBlacklist[i]){found=true;break;}}
if(!found){createOrUpdateIconForApp(app,entryPoint,gridPageOffset,gridPosition);}}}
function isHosted(app){if(app.origin){return app.origin.indexOf('app://')===-1;}
return false;}
function hasOfflineCache(app){if(app.type===GridItemsFactory.TYPE.COLLECTION){return true;}else{var manifest=app?app.manifest||app.updateManifest:null;return manifest.appcache_path!=null;}}
function addPreviouslyInstalled(manifest){if(!isPreviouslyInstalled(manifest)){svPreviouslyInstalledApps.push({'manifest':manifest});}}
function isPreviouslyInstalled(manifest){for(var i=0,elemNum=svPreviouslyInstalledApps.length;i<elemNum;i++){if(svPreviouslyInstalledApps[i].manifest===manifest){return true;}}
return false;}
function getSingleVariantApp(manifestURL){var singleVariantApps=Configurator.getSingleVariantApps();if(manifestURL in singleVariantApps){var app=singleVariantApps[manifestURL];if(app.screen!==undefined&&app.location!==undefined){return app;}}}
function buildDescriptor(app,entryPoint){var manifest=app.manifest?app.manifest:app.updateManifest;if(!manifest)
return;var iconsAndNameHolder=manifest;if(entryPoint)
iconsAndNameHolder=manifest.entry_points[entryPoint];iconsAndNameHolder=new ManifestHelper(iconsAndNameHolder);var descriptor={bookmarkURL:app.bookmarkURL,manifestURL:app.manifestURL,entry_point:entryPoint,updateTime:app.updateTime,removable:app.removable,name:iconsAndNameHolder.name,icon:bestMatchingIcon(app,iconsAndNameHolder),useAsyncPanZoom:app.useAsyncPanZoom,isHosted:isHosted(app),hasOfflineCache:hasOfflineCache(app),type:app.type,id:app.id};if(haveLocale){if(app.type===GridItemsFactory.TYPE.COLLECTION){descriptor.localizedName=_(manifest.name);}else if(app.type!==GridItemsFactory.TYPE.BOOKMARK){descriptor.localizedName=iconsAndNameHolder.name;}}
return descriptor;}
function createOrUpdateIconForApp(app,entryPoint,gridPageOffset,gridPosition){if(app.type!==GridItemsFactory.TYPE.COLLECTION&&app.type!==GridItemsFactory.TYPE.BOOKMARK){app.ondownloadapplied=function ondownloadapplied(event){createOrUpdateIconForApp(event.application,entryPoint);app.ondownloadapplied=null;app.ondownloaderror=null;};app.ondownloaderror=function ondownloaderror(event){createOrUpdateIconForApp(app,entryPoint);};}
var descriptor=buildDescriptor(app,entryPoint);var existingIcon=getIcon(descriptor);if(existingIcon){if(app.manifest&&isHiddenApp(app.manifest.role)){existingIcon.remove();}else{existingIcon.update(descriptor,app);}
markDirtyState();return;}
if(app.manifest&&!app.updateManifest&&isHiddenApp(app.manifest.role)){return;}
var icon=new Icon(descriptor,app);rememberIcon(icon);var index;if(gridPosition){index=gridPosition.page||0;pages[index].appendIconAt(icon,gridPosition.index||0);}else{var svApp=getSingleVariantApp(app.manifestURL);if(svApp&&!isPreviouslyInstalled(app.manifestURL)){index=svApp.screen;icon.descriptor.desiredPos=svApp.location;if(!Configurator.isSimPresentOnFirstBoot&&index<pages.length&&!pages[index].hasEmptySlot()){index=getFirstPageWithEmptySpace(index);}else{icon.descriptor.desiredScreen=index;}}else{index=getFirstPageWithEmptySpace(gridPageOffset);}
var iconLst=[icon];while(iconLst.length>0){icon=iconLst.shift();index=icon.descriptor.desiredScreen||index;if(index<pages.length){iconLst=iconLst.concat(pages[index].getMisplacedIcons(index));pages[index].appendIcon(icon);}else{pageHelper.addPage([icon]);}}}
markDirtyState();}
function doShowRestartDownloadDialog(icon){var app=icon.app;var confirm={title:_('download'),callback:function onAccept(){app.download();app.ondownloaderror=function(evt){icon.showCancelled();icon.updateAppStatus(evt.application);};app.onprogress=function onProgress(evt){app.onprogress=null;icon.updateAppStatus(evt.application);};icon.showDownloading();ConfirmDialog.hide();},applyClass:'recommend'};var cancel={title:_('cancel'),callback:ConfirmDialog.hide};var localizedName=icon.descriptor.localizedName||icon.descriptor.name;ConfirmDialog.show(_('restart-download-title'),_('restart-download-body',{'name':localizedName}),cancel,confirm);return;}
function showRestartDownloadDialog(icon){LazyLoader.load(['shared/style/buttons.css','shared/style/headers.css','shared/style/confirm.css','style/request.css',document.getElementById('confirm-dialog'),'js/request.js'],function loaded(){doShowRestartDownloadDialog(icon);});}
function bestMatchingIcon(app,manifest){if(app.installState==='pending'){return app.downloading?Icon.prototype.DOWNLOAD_ICON_URL:Icon.prototype.CANCELED_ICON_URL;}
var icons=manifest.icons;if(!icons){return getDefaultIcon(app);}
var preferredSize=Number.MAX_VALUE;var max=0;for(var size in icons){size=parseInt(size,10);if(size>max)
max=size;if(size>=PREFERRED_ICON_SIZE&&size<preferredSize)
preferredSize=size;}
if(preferredSize===Number.MAX_VALUE)
preferredSize=max;var url=icons[preferredSize];if(!url){return getDefaultIcon(app);}
if(url.indexOf('data:')==0||url.indexOf('app://')==0||url.indexOf('http://')==0||url.indexOf('https://')==0)
return url;if(url.charAt(0)!='/'){console.warn('`'+manifest.name+'` app icon is invalid. '+'Manifest `icons` attribute should contain URLs -or- '+'absolute paths from the origin field.');return getDefaultIcon(app);}
if(app.origin.slice(-1)=='/')
return app.origin.slice(0,-1)+url;return app.origin+url;}
function calculateDefaultIcons(){defaultAppIcon=new TemplateIcon();defaultAppIcon.loadDefaultIcon();defaultBookmarkIcon=new TemplateIcon(true);defaultBookmarkIcon.loadDefaultIcon();}
var defaults={gridSelector:'.apps',dockSelector:'.dockWrapper'};function doInit(options,callback){calculateDefaultIcons();pages=[];bookmarkIcons=Object.create(null);appIcons=Object.create(null);appsByOrigin=Object.create(null);bookmarksByOrigin=Object.create(null);initUI(options.gridSelector);tapThreshold=options.tapThreshold;swipeThreshold=ScreenHelper.width*options.swipeThreshold;swipeFriction=options.swipeFriction||defaults.swipeFriction;kPageTransitionDuration=options.swipeTransitionDuration;setMaxIconsToSearchPage();IconRetriever.init();HomeState.init(function eachPage(pageState){if(pageState.index===0){var dockContainer=document.querySelector(options.dockSelector);var dock=new Dock(dockContainer,convertDescriptorsToIcons(pageState));DockManager.init(dockContainer,dock,tapThreshold);return;}
var pageIcons=convertDescriptorsToIcons(pageState),numberOfIcons=pageState.index===EVME_PAGE_STATE_INDEX?MAX_ICONS_PER_EVME_PAGE:MAX_ICONS_PER_PAGE;pageHelper.addPage(pageIcons,numberOfIcons);},function onSuccess(){initApps(callback);},function onError(error){var dockContainer=document.querySelector(options.dockSelector);var dock=new Dock(dockContainer,[]);DockManager.init(dockContainer,dock,tapThreshold);initApps(callback);},function eachSVApp(svApp){GridManager.svPreviouslyInstalledApps.push(svApp);});}
return{hiddenRoles:HIDDEN_ROLES,svPreviouslyInstalledApps:svPreviouslyInstalledApps,isPreviouslyInstalled:isPreviouslyInstalled,addPreviouslyInstalled:addPreviouslyInstalled,init:function gm_init(options,callback){addSVEventListener();for(var key in defaults){if(typeof options[key]==='undefined'){options[key]=defaults[key];}}
if('mozSettings'in navigator){var key='app.launch_path.blacklist';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function onsuccess(){launchPathBlacklist=req.result[key]||[];doInit(options,callback);};}else{doInit(options,callback);}},onDragStart:function gm_onDragSart(){releaseEvents();container.removeEventListener(touchstart,handleEvent,true);dragging=document.body.dataset.dragging=true;},onDragStop:function gm_onDragStop(){delete document.body.dataset.dragging;dragging=false;ensurePanning();ensurePagesOverflow(removeEmptyPages);},install:function gm_install(app,gridPageOffset,extra){extra=extra||{};processApp(app,null,gridPageOffset);if(extra.callback){extra.callback();}},uninstall:function gm_uninstall(app){var updateDock=false;var dock=DockManager.page;delete appsByOrigin[app.origin];if(app.type===GridItemsFactory.TYPE.COLLECTION||app.type===GridItemsFactory.TYPE.BOOKMARK){var icon=bookmarkIcons[app.bookmarkURL];updateDock=dock.containsIcon(icon);icon.remove();delete bookmarkIcons[app.bookmarkURL];}else{var iconsForApp=appIcons[app.manifestURL];if(!iconsForApp)
return;for(var entryPoint in iconsForApp){var icon=iconsForApp[entryPoint];updateDock=updateDock||dock.containsIcon(icon);icon.app.ondownloadapplied=icon.app.ondownloaderror=null;icon.remove();}
delete appIcons[app.manifestURL];}
if(app.type===GridItemsFactory.TYPE.COLLECTION){window.dispatchEvent(new CustomEvent('collectionUninstalled',{'detail':{'collection':app}}));}else{window.dispatchEvent(new CustomEvent('appUninstalled',{'detail':{'descriptor':buildDescriptor(app)}}));}
if(updateDock)
DockManager.afterRemovingApp();removeEmptyPages();markDirtyState();},markDirtyState:markDirtyState,getIcon:getIcon,getIconByOrigin:getIconByOrigin,getIconsForApp:getIconsForApp,getIconForBookmark:getIconForBookmark,getApp:getApp,getApps:getApps,getCollections:getCollections,goToPage:goToPage,goToPreviousPage:goToPreviousPage,goToNextPage:goToNextPage,goToLandingPage:goToLandingPage,localize:localize,dirCtrl:dirCtrl,pageHelper:pageHelper,getBlobByDefault:function(app){if(app&&app.iconable){return defaultBookmarkIcon.descriptor.renderedIcon;}else{return defaultAppIcon.descriptor.renderedIcon;}},showRestartDownloadDialog:showRestartDownloadDialog,exitFromEditMode:exitFromEditMode,ensurePanning:ensurePanning,ensurePagesOverflow:ensurePagesOverflow,contextmenu:contextmenu,cancelPanning:cancelPanning,get container(){return container;},forgetIcon:forgetIcon,rememberIcon:rememberIcon};})();;'use strict';var EverythingME={activated:false,pendingEvent:undefined,init:function EverythingME_init(config){this.debug=!!config.debug;var self=this;LazyLoader.load(['shared/js/settings_listener.js'],function loaded(){SettingsListener.observe('rocketbar.enabled',false,function onSettingChange(value){self.rocketbarEnabled=value;});});var footer=document.querySelector('#footer');if(footer){footer.style.MozTransition='-moz-transform .3s ease';}
var gridPage=document.querySelector('#icongrid > div:first-child');gridPage.classList.add('evmePage');var activationIcon=document.createElement('div');activationIcon.id='evme-activation-icon';activationIcon.innerHTML='<input type="text" x-inputmode="verbatim"'+' data-l10n-id="evme-searchbar-default2" />';gridPage.insertBefore(activationIcon,gridPage.firstChild);navigator.mozL10n.ready(function loadSearchbarValue(){var input=activationIcon.querySelector('input'),defaultText=navigator.mozL10n.get('evme-searchbar-default2')||'';input.setAttribute('placeholder',defaultText);});activationIcon.addEventListener('contextmenu',onContextMenu);activationIcon.addEventListener('click',triggerActivateFromInput);activationIcon.addEventListener('touchstart',searchFocus);window.addEventListener('collectionlaunch',triggerActivate);window.addEventListener('collectiondropapp',triggerActivate);window.addEventListener('suggestcollections',triggerActivate);window.addEventListener('search-focus',searchFocus);function searchFocus(e){if(self.rocketbarEnabled){e.preventDefault();e.stopPropagation();self.openRocketbar();}}
function triggerActivateFromInput(e){document.body.classList.add('evme-loading-from-input');document.body.classList.add('evme-keyboard-visible');var activationInput=activationIcon.querySelector('input');activationInput.addEventListener('blur',EverythingME.onActivationIconBlur);triggerActivate(e);}
function triggerActivate(e){EverythingME.pendingEvent=e;activationIcon.removeEventListener('click',triggerActivateFromInput);activationIcon.removeEventListener('contextmenu',onContextMenu);window.removeEventListener('collectionlaunch',triggerActivate);window.removeEventListener('collectiondropapp',triggerActivate);window.removeEventListener('suggestcollections',triggerActivate);if(e.type==='suggestcollections'){EverythingME.showLoading(loadCollectionAssets);}else{loadCollectionAssets();}}
function loadCollectionAssets(){var e=EverythingME.pendingEvent;LazyLoader.load(['shared/style/progress_activity.css','everything.me/css/common.css','everything.me/modules/Collection/Collection.css',document.getElementById('search-page')],function assetsLoaded(){window.setTimeout(function(){if(e&&e.type==='collectionlaunch'){onCollectionOpened(e.detail.id);}
EverythingME.activate();},0);});}
function onCollectionOpened(id){var appsEl=document.getElementById('icongrid'),elCollection=document.getElementById('collection'),collection=GridManager.getIconByOrigin(id),elLoader=elCollection.querySelector('.loading-more');appsEl.classList.add('evme-collection-visible');elCollection.querySelector('.title').innerHTML='<em></em>'+'<span>'+collection.getName()+'</span>';elLoader.classList.add('show');PaginationBar.hide();var closeButton=elCollection.querySelector('.close');closeButton.addEventListener('click',EverythingME.onCollectionClosed);window.addEventListener('hashchange',EverythingME.onCollectionClosed);elCollection.style.display='block';window.setTimeout(function(){elCollection.addEventListener('transitionend',function end(){elCollection.removeEventListener('transitionend',end);document.dispatchEvent(new CustomEvent('collectionopened'));});elCollection.classList.add('visible');},0);}
function onContextMenu(e){e.stopPropagation();}
gridPage.addEventListener('gridpageshowend',function onPageShow(){EvmeFacade.onShow();});gridPage.addEventListener('gridpagehideend',function onPageHide(){EvmeFacade.onHide();});EverythingME.migrateStorage();},openRocketbar:function(){LazyLoader.load(['everything.me/js/search/control.js'],function loaded(){EverythingME.SearchControl.open();});},onActivationIconBlur:function onActivationIconBlur(e){EverythingME.pendingEvent=null;e.target.removeEventListener('blur',onActivationIconBlur);document.body.classList.remove('evme-keyboard-visible');document.body.classList.remove('evme-loading-from-input');},onCollectionClosed:function onCollectionClosed(){var appsEl=document.getElementById('icongrid');appsEl.classList.remove('evme-collection-visible');var elCollection=document.getElementById('collection'),elHeader=elCollection.querySelector('.header');EverythingME.pendingEvent=undefined;elHeader.addEventListener('transitionend',function end(e){e.target.removeEventListener('transitionend',end);elCollection.style.display='none';PaginationBar.show();});elCollection.classList.remove('visible');},activate:function EverythingME_activate(){if(EverythingME.activated){return;}
EverythingME.activated=true;var searchPage=document.getElementById('search-page');LazyLoader.load(searchPage,function loaded(){document.body.classList.add('evme-loading');navigator.mozL10n.translate(searchPage);EverythingME.load();});},load:function EverythingME_load(callback){var CB=!('ontouchstart'in window),js_files=['js/Core.js','js/etmmanager.js','config/config.js','js/developer/utils.1.3.js','js/helpers/Utils.js','js/helpers/Storage.js','js/helpers/IconManager.js','js/plugins/Scroll.js','js/api/apiv2.js','js/api/DoATAPI.js','js/helpers/EventHandler.js','js/helpers/Idle.js','shared/js/icc_helper.js','shared/js/mobile_operator.js','js/plugins/Analytics.js','js/plugins/APIStatsEvents.js','js/Brain.js','modules/BackgroundImage/BackgroundImage.js','modules/Features/Features.js','modules/Helper/Helper.js','modules/Results/Result.js','modules/Results/providers/CloudApps.js','modules/Results/providers/InstalledApps.js','modules/Results/providers/MarketApps.js','modules/Results/providers/MarketSearch.js','modules/Results/providers/StaticApps.js','modules/Results/ResultManager.js','modules/Searchbar/Searchbar.js','modules/SearchHistory/SearchHistory.js','modules/Collection/Collection.js'],css_files=['shared/style/confirm.css','shared/style/status.css','shared/style/action_menu.css','css/common.css','modules/BackgroundImage/BackgroundImage.css','modules/Helper/Helper.css','modules/Results/Results.css','modules/Searchbar/Searchbar.css'];var head=document.head;var scriptLoadCount=0;var cssLoadCount=0;function onScriptLoad(event){event.target.removeEventListener('load',onScriptLoad);if(++scriptLoadCount==js_files.length){EverythingME.start();}else{loadScript(js_files[scriptLoadCount]);}}
function onCSSLoad(event){event.target.removeEventListener('load',onCSSLoad);if(++cssLoadCount===css_files.length){loadScript(js_files[scriptLoadCount]);}else{loadCSS(css_files[cssLoadCount]);}}
function loadCSS(file){var link=document.createElement('link');link.type='text/css';link.rel='stylesheet';link.href=(file.indexOf('shared/')!==-1?'':'everything.me/')+
file+(CB?'?'+Date.now():'');link.addEventListener('load',onCSSLoad);window.setTimeout(function load(){head.appendChild(link);},0);}
function loadScript(file){var script=document.createElement('script');script.type='text/javascript';script.src=(file.indexOf('shared/')!==-1?'':'everything.me/')+
file+(CB?'?'+Date.now():'');script.defer=true;script.addEventListener('load',onScriptLoad);window.setTimeout(function load(){head.appendChild(script);},0);}
loadCSS(css_files[0]);},start:function EverythingME_start(){if(document.readyState==='complete'){EverythingME.initEvme();}else{window.addEventListener('load',function onload(){window.removeEventListener('load',onload);EverythingME.initEvme();});}},initEvme:function EverythingME_initEvme(){var config=this.datastore.getConfig();config.then(function resolve(emeConfig){EverythingME.log('EVME config from storage',JSON.stringify(emeConfig));Evme.init({'deviceId':emeConfig.deviceId},EverythingME.onEvmeLoaded);EvmeFacade=Evme;},function reject(reason){EverythingME.warn('EVME config missing',reason);});},onEvmeLoaded:function onEvmeLoaded(){var page=document.getElementById('evmeContainer'),gridPage=document.querySelector('#icongrid > div:first-child'),activationIcon=document.getElementById('evme-activation-icon'),activationIconInput=activationIcon.querySelector('input'),existingQuery=activationIconInput&&activationIconInput.value,evmeInput=document.getElementById('search-q'),closeButton=document.querySelector('#collection .close');activationIconInput.removeEventListener('blur',EverythingME.onActivationIconBlur);gridPage.appendChild(page.parentNode.removeChild(page));EvmeFacade.onShow();var e=EverythingME.pendingEvent;if(e&&evmeInput&&e.target===activationIconInput){if(existingQuery){EvmeFacade.searchFromOutside(existingQuery);}
EvmeFacade.Searchbar&&EvmeFacade.Searchbar.focus&&EvmeFacade.Searchbar.focus();evmeInput.setSelectionRange(existingQuery.length,existingQuery.length);}
closeButton.removeEventListener('click',EverythingME.onCollectionClosed);window.removeEventListener('hashchange',EverythingME.onCollectionClosed);document.body.classList.remove('evme-loading');document.body.classList.remove('evme-loading-from-input');activationIcon.parentNode.removeChild(activationIcon);if(e&&e.target){e.target.dispatchEvent(e);}
if(e&&e.type==='suggestcollections'){window.addEventListener('CollectionSuggestLoadingShow',loadingShow);window.addEventListener('CollectionSuggestOffline',suggestOffline);}else{EverythingME.hideLoading();}
function loadingShow(){window.removeEventListener('CollectionSuggestLoadingShow',loadingShow);window.removeEventListener('CollectionSuggestOffline',suggestOffline);EverythingME.hideLoading();}
function suggestOffline(){window.removeEventListener('CollectionSuggestLoadingShow',loadingShow);window.removeEventListener('CollectionSuggestOffline',suggestOffline);EverythingME.hideLoading();}},destroy:function EverythingME_destroy(){var list=document.querySelectorAll('head > [href*="everything.me"]');for(var i=0;i<list.length;i++){var resource=list[i];resource.parentNode.removeChild(resource);}
var elementsId=['evmeOverlay','evmeContainer'];elementsId.forEach(function(id){var elementDom=document.getElementById(id);elementDom.parentNode.removeChild(elementDom);});},migrateStorage:function EverythingME_migrateStorage(onComplete,force){var migrationStorageKey='migrated_1.0.1_to_1.1';if(!onComplete){onComplete=function(){};}
asyncStorage.getItem(migrationStorageKey,function evmeMigration(value){if(value===true&&!force){onComplete();return;}
asyncStorage.setItem(migrationStorageKey,true);EverythingME.log('[EVME migration] migrating from 1.0.1 to 1.1...');var AUTOMATIC_KEYS={'userHistory':'evme-userHistory','localShortcuts':'evme-localShortcuts','localShortcutsIcons':'evme-localShortcutsIcons'},numberOfKeys=Object.keys(AUTOMATIC_KEYS).length,numberOfKeysDone=0;for(var key in AUTOMATIC_KEYS){EverythingME.copyStorageToDB(key,AUTOMATIC_KEYS[key],onDataMigrated);}
function onDataMigrated(){numberOfKeysDone++;if(numberOfKeysDone>=numberOfKeys){EverythingME.log('[EVME migration] complete successfully!');onComplete();}}});},copyStorageToDB:function copyStorageToDB(oldKey,newKey,onComplete){if(!onComplete){onComplete=function(){};}
EverythingME.log('[EVME migration] ['+oldKey+']: retrieving...');try{var oldValue=window.localStorage[oldKey];if(!oldValue){EverythingME.log('[EVME migration] ['+oldKey+']: no value');onComplete(false);return false;}
EverythingME.log('[EVME migration] ['+
oldKey+'] got value: '+oldValue);oldValue=JSON.parse(oldValue);if(!oldValue){EverythingME.log('[EVME migration] ['+oldKey+']: invalid json: '+
window.localStorage[oldKey]);deleteOld();onComplete(false);return false;}
var newValue={'value':oldValue._v,'expires':oldValue._e};EverythingME.log('[EVME migration] ['+
oldKey+':'+newKey+']: saving: '+JSON.stringify(newValue));asyncStorage.setItem(newKey,newValue,function onsaved(){EverythingME.log('[EVME migration] ['+oldKey+':'+newKey+']: saved, remove old data');deleteOld();onComplete(true);});}catch(ex){deleteOld();EverythingME.warn('[EVME migration] ['+oldKey+']: error: '+
oldValue+' ('+ex.message+')');onComplete(false);return false;}
function deleteOld(){window.localStorage[oldKey]=null;delete window.localStorage[oldKey];}
return true;},showLoading:function showLoading(callback){var elLoading=document.getElementById('loading-dialog');LazyLoader.load(['shared/style/progress_activity.css','shared/style/confirm.css',elLoading],function assetsLoaded(){elLoading.querySelector('button').addEventListener('click',function onCancel(e){e.target.removeEventListener('click',onCancel);EverythingME.hideLoading();EverythingME.pendingEvent=null;});navigator.mozL10n.translate(elLoading);window.setTimeout(function styleReady(){elLoading.style.display='block';callback&&callback();},0);});},hideLoading:function hideLoading(){var elLoading=document.getElementById('loading-dialog');if(elLoading){elLoading.parentNode.removeChild(elLoading);}},log:function log(){if(this.debug){console.log.apply(console,arguments);}},warn:function log(){if(this.debug){console.warn.apply(console,arguments);}}};var EvmeFacade={onShow:function onShow(){return false;},onHide:function onHide(){return false;}};(function(){'use strict';var DS_NAME='eme_store';var DS_CONFIG_ID=1;function generateDeviceId(){var url=window.URL.createObjectURL(new Blob());var id=url.replace('blob:','');window.URL.revokeObjectURL(url);return'fxos-'+id;}
function emeDataStore(){}
emeDataStore.prototype={getConfig:function getConfig(){var promise=new Promise(function done(resolve,reject){navigator.getDataStores(DS_NAME).then(function(stores){if(stores.length===1){var db=stores[0];db.get(DS_CONFIG_ID).then(function success(emeConfig){if(emeConfig){resolve(emeConfig);}else{emeConfig={'deviceId':generateDeviceId()};db.add(emeConfig,DS_CONFIG_ID).then(function success(id){resolve(emeConfig);},function error(e){reject('config creation failed');});}},function error(e){reject(e.message);});}else{reject('invalid datastore setup');}});});return promise;}};EverythingME.datastore=new emeDataStore();})();;'use strict';var Homescreen=(function(){var mode='normal';var origin=document.location.protocol+'//homescreen.'+
document.location.host.replace(/(^[\w\d]+.)?([\w\d]+.[a-z]+)/,'$2');setLocale();var iconGrid=document.getElementById('icongrid');navigator.mozL10n.ready(function localize(){setLocale();GridManager.localize();});var initialized=false;onConnectionChange(navigator.onLine);function initialize(lPage,onInit){if(initialized){return;}
PaginationBar.init('.paginationScroller');initialized=true;var swipeSection=Configurator.getSection('swipe');var options={gridSelector:'.apps',dockSelector:'.dockWrapper',tapThreshold:Configurator.getSection('tap_threshold'),swipeThreshold:swipeSection.threshold,swipeFriction:swipeSection.friction,swipeTransitionDuration:swipeSection.transition_duration};GridManager.init(options,function gm_init(){window.addEventListener('hashchange',function(){if(!window.location.hash.replace('#','')){return;}
if(Homescreen.didEvmePreventHomeButton()){}else if(Homescreen.isInEditMode()){exitFromEditMode();}else{GridManager.goToLandingPage();}
GridManager.ensurePanning();});PaginationBar.show();if(document.location.hash==='#root'){GridManager.goToLandingPage();}
document.body.addEventListener('contextmenu',onContextMenu);IconManager.init(Configurator.getSection('tap_effect_delay'));if(typeof onInit==='function'){onInit();}});}
function onContextMenu(evt){var target=evt.target;if('isIcon'in target.dataset){var manager=target.parentNode===DockManager.page.olist?DockManager:GridManager;manager.contextmenu(evt);if(Homescreen.isInEditMode()){iconGrid.addEventListener('click',onClickHandler);}}else if(!Homescreen.isInEditMode()){GridManager.cancelPanning();evt.preventDefault();var contextMenuEl=document.getElementById('contextmenu-dialog');var searchPage=Configurator.getSection('search_page');if(searchPage&&searchPage.enabled){LazyLoader.load(['style/contextmenu.css','shared/style/action_menu.css',contextMenuEl,'js/contextmenu.js'],function callContextMenu(){navigator.mozL10n.translate(contextMenuEl);ContextMenuDialog.show();});}else{LazyLoader.load(['shared/js/omadrm/fl.js','js/wallpaper.js'],function callWallpaper(){Wallpaper.contextmenu();});}}}
function onClickHandler(evt){if(!('isIcon'in evt.target.dataset)){exitFromEditMode();}}
function exitFromEditMode(){iconGrid.removeEventListener('click',onClickHandler);Homescreen.setMode('normal');GridManager.exitFromEditMode();if(typeof ConfirmDialog!=='undefined'){ConfirmDialog.hide();}
if(typeof EditDialog!=='undefined'){EditDialog.hide();}}
document.addEventListener('visibilitychange',function mozVisChange(){if(document.hidden&&Homescreen.isInEditMode()){exitFromEditMode();}
if(document.hidden==false){setTimeout(function forceRepaint(){var helper=document.getElementById('repaint-helper');helper.classList.toggle('displayed');});}});window.addEventListener('message',function hs_onMessage(event){if(event.origin===origin){var message=event.data;LazyLoader.load('js/message.js',function loaded(){switch(message.type){case Message.Type.ADD_BOOKMARK:var app=new Bookmark(message.data);GridManager.install(app);break;}});}});function setLocale(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;}
function onConnectionChange(isOnline){var mode=isOnline?'online':'offline';document.body.dataset.online=mode;}
window.addEventListener('online',function onOnline(evt){onConnectionChange(true);});window.addEventListener('offline',function onOnline(evt){onConnectionChange(false);});return{showAppDialog:function h_showAppDialog(icon){LazyLoader.load(['shared/style/buttons.css','shared/style/headers.css','shared/style/confirm.css','style/request.css',document.getElementById('confirm-dialog'),'js/request.js'],function loaded(){ConfirmDialog.showApp(icon);});},showEditBookmarkDialog:function h_showEditBookmarkDialog(icon){var dialog=document.getElementById('edit-dialog');LazyLoader.load(['style/edit_dialog.css','shared/style/headers.css','shared/style/input_areas.css','shared/js/url_helper.js',dialog,'js/edit_dialog.js'],function loaded(){navigator.mozL10n.translate(dialog);EditDialog.show(icon);});},isInEditMode:function(){return mode==='edit';},didEvmePreventHomeButton:function(){return EvmeFacade&&EvmeFacade.onHomeButtonPress&&EvmeFacade.onHomeButtonPress();},init:initialize,setMode:function(newMode){mode=document.body.dataset.mode=newMode;}};})();;'use strict';var Configurator=(function(){var mcc_mnc;var conf={};var SINGLE_VARIANT_CONF_FILE='js/singlevariantconf.json';var singleVariantApps={};var simPresentOnFirstBoot=true;var dummyProvider={init:function(){},destroy:function(){}};function onLoadInitJSON(loadedData){conf=loadedData;var searchPage=conf.search_page;if(searchPage){var provider=window[searchPage.provider]||dummyProvider;if(searchPage.enabled){document.body.classList.add('searchPageEnabled');}else{setTimeout(provider.destroy,0);}}
var homescreenInitialized=function(){if(conf.bookmarks){conf.bookmarks.forEach(function addBookmark(bookmarkData){var app=new Bookmark(bookmarkData);GridManager.install(app);});}
if(searchPage&&searchPage.enabled){provider.init(conf.search_page);}};Homescreen.init(0,homescreenInitialized);loadSingleVariantConf();}
function onErrorInitJSON(e){conf={};console.error('Failed parsing homescreen configuration file: '+e);startHomescreenByDefault();loadSingleVariantConf();}
function loadFile(file,successCallback,errorCallback){try{var xhr=new XMLHttpRequest();xhr.overrideMimeType('application/json');xhr.open('GET',file,true);xhr.send(null);xhr.onload=function _xhrOnLoadFile(evt){try{successCallback(JSON.parse(xhr.responseText));}catch(e){errorCallback&&errorCallback(e);}};xhr.onerror=function _xhrOnError(evt){errorCallback&&errorCallback('file not found');};}catch(ex){errorCallback&&errorCallback(ex);}}
function load(){loadFile('js/init.json',onLoadInitJSON,onErrorInitJSON);}
function loadSingleVariantConf(){loadSettingSIMPresent();if(!IccHelper){console.error('IccHelper isn\'t enabled. SingleVariant configuration'+' can\'t be loaded');return;}
function normalizeCode(aCode){var ncode=''+aCode;while(ncode.length<3){ncode='0'+ncode;}
return ncode;}
var getMccMnc=function getMccMnc(){if(IccHelper.iccInfo){var mcc=IccHelper.iccInfo.mcc;var mnc=IccHelper.iccInfo.mnc;if((mcc!==undefined)&&(mcc!==null)&&(mnc!==undefined)&&(mnc!==null)){return normalizeCode(mcc)+'-'+normalizeCode(mnc);}}};function dispatchSVReadyEvent(){mcc_mnc=undefined;window.dispatchEvent(new CustomEvent('singlevariant-ready'));}
function loadSVConfFileSuccess(loadedData){try{loadedData[mcc_mnc].forEach(function(app){if(app.manifestURL){singleVariantApps[app.manifestURL]=app;}});}catch(e){console.error('There was an error loading singleVariant configuration',e);}finally{dispatchSVReadyEvent();}}
function loadSVConfFileError(e){singleVariantApps={};console.error('Failed parsing singleVariant configuration file ['+
SINGLE_VARIANT_CONF_FILE+']: ',e);dispatchSVReadyEvent();}
var iccHandler=function(evt){mcc_mnc=getMccMnc();if(mcc_mnc){IccHelper.removeEventListener('iccinfochange',iccHandler);loadFile(SINGLE_VARIANT_CONF_FILE,loadSVConfFileSuccess,loadSVConfFileError);iccHandler=null;return true;}
return false;};if(!iccHandler()){IccHelper.addEventListener('iccinfochange',iccHandler);}}
function loadSettingSIMPresent(){var settings=navigator.mozSettings;if(!settings){console.log('Settings is not available');return;}
var req=settings.createLock().get('ftu.simPresentOnFirstBoot');req.onsuccess=function osv_success(e){simPresentOnFirstBoot=req.result['ftu.simPresentOnFirstBoot']===undefined||req.result['ftu.simPresentOnFirstBoot'];};req.onerror=function osv_error(e){console.error('Error retrieving ftu.simPresentOnFirstBoot. '+e);};}
function startHomescreenByDefault(){if(Homescreen){Homescreen.init(0);}}
load();return{getSection:function(section){return conf[section];},getSingleVariantApps:function(){return singleVariantApps;},get isSingleVariantReady(){return!mcc_mnc;},load:load,get isSimPresentOnFirstBoot(){return simPresentOnFirstBoot;},loadSettingSIMPresent:loadSettingSIMPresent};}());