;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;'use strict';var NotificationHelper={_referencesArray:[],getIconURI:function nc_getIconURI(app,entryPoint){var icons=app.manifest.icons;if(entryPoint){icons=app.manifest.entry_points[entryPoint].icons;}
if(!icons)
return null;var sizes=Object.keys(icons).map(function parse(str){return parseInt(str,10);});sizes.sort(function(x,y){return y-x;});var HVGA=document.documentElement.clientWidth<480;var index=sizes[HVGA?sizes.length-1:0];return app.installOrigin+icons[index];},send:function nc_send(title,body,icon,clickCB,closeCB){if(!('mozNotification'in navigator))
return;var notification=navigator.mozNotification.createNotification(title,body,icon);notification.onclick=(function(){if(clickCB)
clickCB();this._forget(notification);}).bind(this);notification.onclose=(function(){if(closeCB)
closeCB();this._forget(notification);}).bind(this);notification.show();this._keep(notification);},_keep:function nc_keep(notification){this._referencesArray.push(notification);},_forget:function nc_forget(notification){this._referencesArray.splice(this._referencesArray.indexOf(notification),1);}};;'use strict';var GestureDetector=(function(){function GD(e,options){this.element=e;this.options=options||{};this.options.panThreshold=this.options.panThreshold||GD.PAN_THRESHOLD;this.options.mousePanThreshold=this.options.mousePanThreshold||GD.MOUSE_PAN_THRESHOLD;this.state=initialState;this.timers={};this.listeningForMouseEvents=true;}
GD.prototype.startDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.addEventListener(t,self);});};GD.prototype.stopDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.removeEventListener(t,self);});};GD.prototype.handleEvent=function(e){var handler=this.state[e.type];if(!handler)return;if(e.changedTouches){if(this.listeningForMouseEvents){this.listeningForMouseEvents=false;this.element.removeEventListener('mousedown',this);}
if(e.type==='touchend'&&e.changedTouches.length>1){console.warn('gesture_detector.js: spurious extra changed touch on '+'touchend. See '+'https://bugzilla.mozilla.org/show_bug.cgi?id=785554');}
for(var i=0;i<e.changedTouches.length;i++){handler(this,e,e.changedTouches[i]);handler=this.state[e.type];}}
else{handler(this,e);}};GD.prototype.startTimer=function(type,time){this.clearTimer(type);var self=this;this.timers[type]=setTimeout(function(){self.timers[type]=null;var handler=self.state[type];if(handler)
handler(self,type);},time);};GD.prototype.clearTimer=function(type){if(this.timers[type]){clearTimeout(this.timers[type]);this.timers[type]=null;}};GD.prototype.switchTo=function(state,event,touch){this.state=state;if(state.init)
state.init(this,event,touch);};GD.prototype.emitEvent=function(type,detail){if(!this.target){console.error('Attempt to emit event with no target');return;}
var event=this.element.ownerDocument.createEvent('CustomEvent');event.initCustomEvent(type,true,true,detail);this.target.dispatchEvent(event);};GD.HOLD_INTERVAL=1000;GD.PAN_THRESHOLD=20;GD.MOUSE_PAN_THRESHOLD=15;GD.DOUBLE_TAP_DISTANCE=50;GD.DOUBLE_TAP_TIME=500;GD.VELOCITY_SMOOTHING=.5;GD.SCALE_THRESHOLD=20;GD.ROTATE_THRESHOLD=22.5;GD.THRESHOLD_SMOOTHING=0.9;var abs=Math.abs,floor=Math.floor,sqrt=Math.sqrt,atan2=Math.atan2;var PI=Math.PI;var eventtypes=['touchstart','touchmove','touchend','mousedown'];function eventTime(e){var ts=e.timeStamp;if(ts>2*Date.now())
return Math.floor(ts/1000);else
return ts;}
function coordinates(e,t){return Object.freeze({screenX:t.screenX,screenY:t.screenY,clientX:t.clientX,clientY:t.clientY,timeStamp:eventTime(e)});}
function midpoints(e,t1,t2){return Object.freeze({screenX:floor((t1.screenX+t2.screenX)/2),screenY:floor((t1.screenY+t2.screenY)/2),clientX:floor((t1.clientX+t2.clientX)/2),clientY:floor((t1.clientY+t2.clientY)/2),timeStamp:eventTime(e)});}
function mouseCoordinates(e){return Object.freeze({screenX:e.screenX,screenY:e.screenY,clientX:e.clientX,clientY:e.clientY,timeStamp:eventTime(e)});}
function between(c1,c2){var r=GD.THRESHOLD_SMOOTHING;return Object.freeze({screenX:floor(c1.screenX+r*(c2.screenX-c1.screenX)),screenY:floor(c1.screenY+r*(c2.screenY-c1.screenY)),clientX:floor(c1.clientX+r*(c2.clientX-c1.clientX)),clientY:floor(c1.clientY+r*(c2.clientY-c1.clientY)),timeStamp:floor(c1.timeStamp+r*(c2.timeStamp-c1.timeStamp))});}
function touchDistance(t1,t2){var dx=t2.screenX-t1.screenX;var dy=t2.screenY-t1.screenY;return sqrt(dx*dx+dy*dy);}
function touchDirection(t1,t2){return atan2(t2.screenY-t1.screenY,t2.screenX-t1.screenX)*180/PI;}
function touchRotation(d1,d2){var angle=d2-d1;if(angle>180)
angle-=360;else if(angle<=-180)
angle+=360;return angle;}
function isDoubleTap(lastTap,thisTap){var dx=abs(thisTap.screenX-lastTap.screenX);var dy=abs(thisTap.screenY-lastTap.screenY);var dt=thisTap.timeStamp-lastTap.timeStamp;return(dx<GD.DOUBLE_TAP_DISTANCE&&dy<GD.DOUBLE_TAP_DISTANCE&&dt<GD.DOUBLE_TAP_TIME);}
var initialState={name:'initialState',init:function(d){d.target=null;d.start=d.last=null;d.touch1=d.touch2=null;d.vx=d.vy=null;d.startDistance=d.lastDistance=null;d.startDirection=d.lastDirection=null;d.lastMidpoint=null;d.scaled=d.rotated=null;},touchstart:function(d,e,t){d.switchTo(touchStartedState,e,t);},mousedown:function(d,e){d.switchTo(mouseDownState,e);}};var touchStartedState={name:'touchStartedState',init:function(d,e,t){d.target=e.target;d.touch1=t.identifier;d.start=d.last=coordinates(e,t);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},touchstart:function(d,e,t){d.clearTimer('holdtimeout');d.switchTo(transformState,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;if(abs(t.screenX-d.start.screenX)>d.options.panThreshold||abs(t.screenY-d.start.screenY)>d.options.panThreshold){d.clearTimer('holdtimeout');d.switchTo(panStartedState,e,t);}},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=coordinates(e,t);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(holdState);}};var panStartedState={name:'panStartedState',init:function(d,e,t){d.start=d.last=between(d.start,coordinates(e,t));if(e.type==='touchmove')
panStartedState.touchmove(d,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:e.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};var holdState={name:'holdState',init:function(d){d.emitEvent('holdstart',d.start);},touchmove:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},touchend:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var transformState={name:'transformState',init:function(d,e,t){d.touch2=t.identifier;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);d.startDistance=d.lastDistance=touchDistance(t1,t2);d.startDirection=d.lastDirection=touchDirection(t1,t2);d.scaled=d.rotated=false;},touchmove:function(d,e,t){if(t.identifier!==d.touch1&&t.identifier!==d.touch2)
return;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);var midpoint=midpoints(e,t1,t2);var distance=touchDistance(t1,t2);var direction=touchDirection(t1,t2);var rotation=touchRotation(d.startDirection,direction);if(!d.scaled){if(abs(distance-d.startDistance)>GD.SCALE_THRESHOLD){d.scaled=true;d.startDistance=d.lastDistance=floor(d.startDistance+
GD.THRESHOLD_SMOOTHING*(distance-d.startDistance));}
else
distance=d.startDistance;}
if(!d.rotated){if(abs(rotation)>GD.ROTATE_THRESHOLD)
d.rotated=true;else
direction=d.startDirection;}
if(d.scaled||d.rotated){d.emitEvent('transform',{absolute:{scale:distance/d.startDistance,rotate:touchRotation(d.startDirection,direction)},relative:{scale:distance/d.lastDistance,rotate:touchRotation(d.lastDirection,direction)},midpoint:midpoint});d.lastDistance=distance;d.lastDirection=direction;d.lastMidpoint=midpoint;}},touchend:function(d,e,t){if(t.identifier===d.touch2)
d.touch2=null;else if(t.identifier===d.touch1){d.touch1=d.touch2;d.touch2=null;}
else
return;if(d.scaled||d.rotated){d.emitEvent('transformend',{absolute:{scale:d.lastDistance/d.startDistance,rotate:touchRotation(d.startDirection,d.lastDirection)},relative:{scale:1,rotate:0},midpoint:d.lastMidpoint});}
d.switchTo(afterTransformState);}};var afterTransformState={name:'afterTransformState',touchstart:function(d,e,t){d.switchTo(transformState,e,t);},touchend:function(d,e,t){if(t.identifier===d.touch1)
d.switchTo(initialState);}};var mouseDownState={name:'mouseDownState',init:function(d,e){d.target=e.target;var doc=d.element.ownerDocument;doc.addEventListener('mousemove',d,true);doc.addEventListener('mouseup',d,true);d.start=d.last=mouseCoordinates(e);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},mousemove:function(d,e){if(abs(e.screenX-d.start.screenX)>d.options.mousePanThreshold||abs(e.screenY-d.start.screenY)>d.options.mousePanThreshold){d.clearTimer('holdtimeout');d.switchTo(mousePannedState,e);}},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=mouseCoordinates(e);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(mouseHoldState);}};var mouseHoldState={name:'mouseHoldState',init:function(d){d.emitEvent('holdstart',d.start);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},mouseup:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var mousePannedState={name:'mousePannedState',init:function(d,e){d.start=d.last=between(d.start,mouseCoordinates(e));if(e.type==='mousemove')
mousePannedState.mousemove(d,e);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);var current=mouseCoordinates(e);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:current.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};return GD;}());;'use strict';function SettingsURL(){this._url=null;this._isBlob=false;}
SettingsURL.prototype={set:function(value){if(this._isBlob){window.URL.revokeObjectURL(this._url);}
if(value instanceof Blob){this._isBlob=true;this._url=window.URL.createObjectURL(value);}else{this._isBlob=false;this._url=value;}
return this._url;},get:function(){return this._url;}};;(function(exports){'use strict';var priv=new WeakMap();var rmatcher=/\$\{([^}]+)\}/g;var rentity=/[&<>"']/g;var rentities={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&apos;'};function extract(node){var nodeId;if(typeof node==='string'){nodeId=node;node=document.getElementById(node);}else if(node){nodeId=node.id;}
if(!node){console.error('Can not find the node passed to Template',nodeId);return'';}
if(!node.firstChild){console.error('Node passed to Template should have a comment node',nodeId);return'';}
node=node.firstChild;do{if(node.nodeType===Node.COMMENT_NODE){return(node.nodeValue||'').trim();}}while((node=node.nextSibling));console.error('Nodes passed to Template should have a comment node',nodeId);return'';}
function Template(idOrNode){if(!(this instanceof Template)){return new Template(idOrNode);}
priv.set(this,{tmpl:extract(idOrNode)});};Template.prototype.toString=function(){return priv.get(this).tmpl.slice();};Template.prototype.interpolate=function(data,options){options=options||{};options.safe=options.safe||[];return priv.get(this).tmpl.replace(rmatcher,function(match,property){property=property.trim();return options.safe.indexOf(property)===-1?Template.escape(data[property]):data[property];});};Template.escape=function escape(str){if(typeof str!=='string'){return'';}
return str.replace(rentity,function(s){return rentities[s];});};exports.Template=Template;}(this));;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;(function(exports){'use strict';function getThumbnail(contact){return getOnePhoto(contact,'begin');}
function getFullResolution(contact){return getOnePhoto(contact,'end');}
function getOnePhoto(contact,position){if(!contact||!contact.photo||!contact.photo.length){return null;}
if(contact.photo.length===1){return contact.photo[0];}
var photos=contact.photo;var category=contact.category;if(Array.isArray(category)&&category.indexOf('fb_linked')!==-1){if(photos.length>=4){return photos[(position=='begin')?1:0];}
return photos[0];}
photos=photosBySize(contact);var index=(position=='begin')?0:photos.length-1;return photos[index];}
function photosBySize(contact){var photos=contact.photo.slice(0);photos.sort(function(p1,p2){if(size(p1)<size(p2)){return-1;}
if(size(p1)>size(p2)){return 1;}
return 0;});return photos;}
function size(photo){if(typeof photo=='string'){return photo.length;}
return photo.size;}
exports.ContactPhotoHelper={getThumbnail:getThumbnail,getFullResolution:getFullResolution};})(window);;'use strict';var MobileOperator={BRAZIL_MCC:'724',BRAZIL_CELLBROADCAST_CHANNEL:50,userFacingInfo:function mo_userFacingInfo(mobileConnection){var network=mobileConnection.voice.network;var iccid=mobileConnection.iccId;var iccObj=navigator.mozIccManager.getIccById(iccid);var iccInfo=iccObj?iccObj.iccInfo:null;var operator=network?(network.shortName||network.longName):null;if(operator&&iccInfo&&iccInfo.isDisplaySpnRequired&&iccInfo.spn&&!mobileConnection.voice.roaming){if(iccInfo.isDisplayNetworkNameRequired&&operator!==iccInfo.spn){operator=operator+' '+iccInfo.spn;}else{operator=iccInfo.spn;}}
var carrier,region;if(this.isBrazil(mobileConnection)){var lac=mobileConnection.voice.cell.gsmLocationAreaCode%100;var carriers=MobileInfo.brazil.carriers;var regions=MobileInfo.brazil.regions;carrier=carriers[network.mnc]||(this.BRAZIL_MCC+network.mnc);region=(regions[lac]?regions[lac]+' '+lac:'');}
return{'operator':operator,'carrier':carrier,'region':region};},isBrazil:function mo_isBrazil(mobileConnection){var cell=mobileConnection.voice.cell;var net=mobileConnection.voice.network;return net?(net.mcc===this.BRAZIL_MCC&&cell&&cell.gsmLocationAreaCode):null;}};var MobileInfo={brazil:{carriers:{'00':'NEXTEL','02':'TIM','03':'TIM','04':'TIM','05':'CLARO','06':'VIVO','07':'CTBC','08':'TIM','10':'VIVO','11':'VIVO','15':'SERCOMTEL','16':'OI','23':'VIVO','24':'OI','31':'OI','32':'CTBC','33':'CTBC','34':'CTBC','37':'AEIOU'},regions:{'11':'SP','12':'SP','13':'SP','14':'SP','15':'SP','16':'SP','17':'SP','18':'SP','19':'SP','21':'RJ','22':'RJ','24':'RJ','27':'ES','28':'ES','31':'MG','32':'MG','33':'MG','34':'MG','35':'MG','37':'MG','38':'MG','41':'PR','42':'PR','43':'PR','44':'PR','45':'PR','46':'PR','47':'SC','48':'SC','49':'SC','51':'RS','53':'RS','54':'RS','55':'RS','61':'DF','62':'GO','63':'TO','64':'GO','65':'MT','66':'MT','67':'MS','68':'AC','69':'RO','71':'BA','73':'BA','74':'BA','75':'BA','77':'BA','79':'SE','81':'PE','82':'AL','83':'PB','84':'RN','85':'CE','86':'PI','87':'PE','88':'CE','89':'PI','91':'PA','92':'AM','93':'PA','94':'PA','95':'RR','96':'AP','97':'AM','98':'MA','99':'MA'}}};;'use strict';var SettingsListener={_timer:null,_lock:null,getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));settings.addObserver(name,function settingChanged(evt){callback(evt.settingValue);});}};;'use strict';(function(exports){var SimPicker={_domBuilt:false,_simPickerElt:null,getOrPick:function hk_getOrPick(defaultCardIndex,phoneNumber,simSelectedCallback){this._simSelectedCallback=simSelectedCallback;this._simPickerElt=document.getElementById('sim-picker');if(window.TelephonyHelper){var inUseSim=window.TelephonyHelper.getInUseSim();if(inUseSim!==null){simSelectedCallback(inUseSim);return;}}
this._buildDom();var self=this;navigator.mozL10n.ready(function(){var dialViaElt=document.getElementById('sim-picker-dial-via');if(phoneNumber){navigator.mozL10n.localize(dialViaElt,'sim-picker-dial-via-with-number',{phoneNumber:phoneNumber});}else{navigator.mozL10n.localize(dialViaElt,'sim-picker-select-sim');}
var simButtons=self._simPickerElt.querySelectorAll('button[data-card-index]');for(var i=0;i<simButtons.length;i++){if(simButtons[i].dataset.cardIndex==defaultCardIndex){simButtons[i].classList.add('is-default');}else{simButtons[i].classList.remove('is-default');}}
self._simPickerElt.hidden=false;self._simPickerElt.focus();});},_buildDom:function(){if(this._domBuilt){return;}
this._domBuilt=true;var self=this;navigator.mozL10n.ready(function(){var templateNode=document.getElementById('sim-picker-button-template');for(var i=0;i<navigator.mozIccManager.iccIds.length;i++){var clonedNode=templateNode.cloneNode(true);clonedNode.dataset.cardIndex=i;var button=clonedNode.querySelector('.js-sim-picker-button');navigator.mozL10n.localize(button,'sim-picker-button',{n:i+1});templateNode.parentNode.insertBefore(clonedNode,templateNode);}
templateNode.remove();self._simPickerElt.addEventListener('click',self);});},handleEvent:function(e){if(e){e.preventDefault();}
if(e.target.nodeName!=='BUTTON'){return;}
if(e.target.dataset.cardIndex){this._simSelectedCallback(e.target.dataset.cardIndex);}
document.getElementById('sim-picker').hidden=true;}};exports.SimPicker=SimPicker;})(window);;'use strict';const ALWAYS_ASK_OPTION_VALUE='-1';var MultiSimActionButton=function MultiSimActionButton(button,callCallback,settingsKey,phoneNumberGetter){this._button=button;this._callCallback=callCallback;this._settingsKey=settingsKey;this._phoneNumberGetter=phoneNumberGetter;this._button.addEventListener('click',this._click.bind(this));var self=this;LazyLoader.load(['/shared/js/settings_listener.js'],function(){SettingsListener.observe(settingsKey,0,self._settingsObserver.bind(self));});if(navigator.mozIccManager&&navigator.mozIccManager.iccIds.length>1){this._button.addEventListener('contextmenu',this._contextmenu.bind(this));this._simIndication=this._button.querySelector('.js-sim-indication');var telephony=navigator.mozTelephony;if(telephony){telephony.addEventListener('callschanged',self._updateUI.bind(self));}}};MultiSimActionButton.prototype._settingsObserver=function(cardIndex){this._defaultCardIndex=cardIndex;this._updateUI();if(this._clickQueued){this._clickQueued=false;this._click();}};MultiSimActionButton.prototype._getCardIndexIfLoaded=function(){if(window.TelephonyHelper){var inUseSim=window.TelephonyHelper.getInUseSim();if(inUseSim!==null){return inUseSim;}}
return this._defaultCardIndex;};MultiSimActionButton.prototype._click=function(event){if(event){event.preventDefault();}
var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(!navigator.mozIccManager||phoneNumber===''){return;}
if(navigator.mozIccManager.iccIds.length===0){this.performAction(0);return;}
var cardIndex=this._getCardIndexIfLoaded();if(cardIndex===undefined){this._clickQueued=true;return;}
if(cardIndex==ALWAYS_ASK_OPTION_VALUE){var self=this;LazyLoader.load(['/shared/js/sim_picker.js'],function(){SimPicker.getOrPick(cardIndex,phoneNumber,self.performAction.bind(self));});}else{this.performAction(cardIndex);}};MultiSimActionButton.prototype._updateUI=function(){var cardIndex=this._getCardIndexIfLoaded();if(cardIndex>=0&&navigator.mozIccManager&&navigator.mozIccManager.iccIds.length>1){if(this._simIndication){var self=this;navigator.mozL10n.ready(function(){navigator.mozL10n.localize(self._simIndication,'sim-picker-button',{n:cardIndex+1});});}
document.body.classList.add('has-preferred-sim');}else{document.body.classList.remove('has-preferred-sim');}};MultiSimActionButton.prototype._contextmenu=function(event){var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(!navigator.mozIccManager||navigator.mozIccManager.iccIds.length===0||phoneNumber===''||event.target.disabled||(window.TelephonyHelper&&window.TelephonyHelper.getInUseSim()!==null)){return;}
if(this._getCardIndexIfLoaded()===undefined){return;}
if(event){event.preventDefault();}
var self=this;LazyLoader.load(['/shared/js/sim_picker.js'],function(){SimPicker.getOrPick(self._getCardIndexIfLoaded(),phoneNumber,self.performAction.bind(self));});};MultiSimActionButton.prototype.performAction=function(cardIndex){var phoneNumber=this._phoneNumberGetter&&this._phoneNumberGetter();if(phoneNumber===''){return;}
if(cardIndex===undefined){cardIndex=this._getCardIndexIfLoaded();}
this._callCallback(phoneNumber,cardIndex);};;(function(exports){'use strict';function createLocalizedElement(tagName,param){var element=document.createElement(tagName);if(param.l10nId){navigator.mozL10n.localize(element,param.l10nId,param.l10nArgs);}else if(param.value.nodeType){element.appendChild(param.value);}else{element.textContent=param.value;}
return element;}
var Dialog=function(params){if(!params||!params.options||!params.options.cancel){return;}
var handlers=new WeakMap();this.form=document.createElement('form');this.form.dataset.type='confirm';this.form.setAttribute('role','dialog');this.form.tabIndex=-1;var titleDOM=createLocalizedElement('strong',params.title);var bodyDOM=createLocalizedElement('small',params.body);var infoSection=document.createElement('section');var infoContainer=document.createElement('p');infoContainer.appendChild(titleDOM);infoContainer.appendChild(bodyDOM);infoSection.appendChild(infoContainer);this.form.appendChild(infoSection);var menu=document.createElement('menu');var cancelOption=params.options.cancel;var cancelButton=createLocalizedElement('button',cancelOption.text);handlers.set(cancelButton,cancelOption);if(params.options.confirm){var confirmOption=params.options.confirm;var confirmButton=createLocalizedElement('button',confirmOption.text);confirmButton.className='recommend';handlers.set(confirmButton,confirmOption);menu.appendChild(cancelButton);if(confirmOption.position==='left'){menu.insertBefore(confirmButton,cancelButton);}else{menu.appendChild(confirmButton);}}else{cancelButton.style.width='100%';menu.appendChild(cancelButton);}
this.form.addEventListener('submit',function(event){event.preventDefault();});menu.addEventListener('click',function(event){var action=handlers.get(event.target);if(!action){return;}
var method=(action&&action.method)||function(){};method.apply(null,action.params||[]);this.hide();}.bind(this));this.form.appendChild(menu);};Dialog.prototype.show=function(){document.body.appendChild(this.form);this.form.focus();};Dialog.prototype.hide=function(){document.body.removeChild(this.form);};exports.Dialog=Dialog;var ERRORS={NoSimCardError:{prefix:'sendMissingSimCard',showRecipient:false,showDsdsStatus:false,hasHandler:false},RadioDisabledError:{prefix:'sendFlightMode',showRecipient:false,showDsdsStatus:false,hasHandler:false},FdnCheckError:{prefix:'fdnBlocked',showRecipient:true,showDsdsStatus:false,hasHandler:false},NonActiveSimCardToSendError:{prefix:'nonActiveSimToSend',showRecipient:false,showDsdsStatus:true,hasHandler:true},NonActiveSimCardError:{prefix:'nonActiveSim',showRecipient:false,showDsdsStatus:true,hasHandler:true},NoSignalError:{prefix:'sendNoSignalError',showRecipient:false,showDsdsStatus:false,hasHandler:false},NotFoundError:{prefix:'sendNotFoundError',showRecipient:false,showDsdsStatus:false,hasHandler:false},InvalidAddressError:{prefix:'sendInvalidAddressError',showRecipient:false,showDsdsStatus:false,hasHandler:false}};function errorParamsGenerator(actions,opts){var prefix=actions.prefix;var messageTitle=prefix+'Title';var messageBody=prefix+'Body';var messageBodyParams={};var buttonLabel=prefix+'BtnOk';var options={cancel:{text:{l10nId:buttonLabel}}};if(actions.showRecipient){messageBodyParams={n:opts.recipients.length,numbers:opts.recipients.join('<br />')};}
if(actions.showDsdsStatus){var mmsServiceId=Settings.mmsServiceId;if(mmsServiceId!==null){switch(mmsServiceId){case 0:messageBodyParams={active:'SIM 1',nonactive:'SIM 2'};break;case 1:messageBodyParams={active:'SIM 2',nonactive:'SIM 1'};break;default:console.error('MMS ServiceId('+mmsServiceId+') is not matched!');}}else{console.error('Settings unavailable');}}
if(opts&&opts.confirmHandler&&actions.hasHandler){options.confirm={text:{l10nId:prefix+'Confirm'},method:opts.confirmHandler};}
return{title:{l10nId:messageTitle},body:{l10nId:messageBody,l10nArgs:messageBodyParams},options:options};}
function ErrorDialog(errorName,opts){var actions=ERRORS[errorName]||{prefix:'sendGeneralError',showRecipient:false,showDsdsStatus:false,hasHandler:false};Dialog.call(this,errorParamsGenerator(actions,opts));}
ErrorDialog.prototype=Object.create(Dialog.prototype);exports.ErrorDialog=ErrorDialog;}(this));;'use strict';var BlackList=(function(){var _blackList={};function _init(){var xhr=new XMLHttpRequest();xhr.overrideMimeType('application/json');xhr.open('GET','js/blacklist.json',true);xhr.send(null);xhr.onreadystatechange=function cc_loadConfiguration(evt){if(xhr.readyState!==4){return;}
if(xhr.status===0||xhr.status===200){var list=JSON.parse(xhr.responseText);_blackList={};list.forEach(function sms_bl_addToBL(item){_blackList[item]=true;});}};}
function _has(value){return _blackList.hasOwnProperty(value);}
return{init:_init,has:_has};}());BlackList.init();;(function(exports){'use strict';var filterFns={contains:function(a,b){a=a.toLowerCase();b=b.toLowerCase();return a.contains(b);},equality:function(a,b){a=a.toLowerCase();b=b.toLowerCase();return a===b;}};function isMatch(contact,criteria,filterFn){var found={};outer:for(var i=0,ilen=criteria.terms.length;i<ilen;i++){var term=criteria.terms[i];for(var j=0,jlen=criteria.fields.length;j<jlen;j++){var field=criteria.fields[j];if(!contact[field]){continue;}
for(var k=0,klen=contact[field].length;k<klen;k++){var value=contact[field][k];if(typeof value.value!=='undefined'){value=value.value;}
if((found[term]=filterFn(value.trim(),term))){continue outer;}}}}
return Object.keys(found).every(function(key){return found[key];});}
var rspaces=/\s+/;var Contacts={findBy:function contacts_findBy(filter,callback){var lower=[];var filterValue=(filter.filterValue||'').trim();var terms,request;if(!navigator.mozContacts||!filterValue.length){setTimeout(function(){callback(typeof filter.filterValue==='undefined'?null:[],{});});return;}
terms=filterValue.split(rspaces);filter.filterValue=terms.length===1?terms[0]:terms.reduce(function(initial,term){lower.push(term.toLowerCase());return term.length>initial.length?term:initial;},'');if(filter.filterValue.length<3){filter.filterLimit=10;}
lower.splice(lower.indexOf(filter.filterValue.toLowerCase()),1);lower.push.apply(lower,terms);request=navigator.mozContacts.find(filter);request.onsuccess=function onsuccess(){var contacts=this.result.slice();var fields=['tel','givenName','familyName'];var criteria={fields:fields,terms:lower};var results=[];var contact;if(terms.length>1){while((contact=contacts.pop())){if(isMatch(contact,criteria,filterFns.contains)){results.push(contact);}}}else{results=contacts;}
callback(results,{terms:terms});};request.onerror=function onerror(){this.onsuccess=this.onerror=null;callback(null);};},findByString:function contacts_findBy(filterValue,callback){return this.findBy({filterBy:['tel','givenName','familyName'],filterOp:'contains',filterValue:filterValue},callback);},findExact:function contacts_findBy(filterValue,callback){return this.findBy({filterBy:['givenName','familyName'],filterOp:'contains',filterValue:filterValue},function(results,meta){var contact=results&&results.length?results[0]:null;var criteria={fields:['name'],terms:[filterValue]};var isExact=false;if(contact){isExact=isMatch(contact,criteria,filterFns.equality);}
callback(isExact?[contact]:[]);});},findByPhoneNumber:function contacts_findByPhone(filterValue,callback){return this.findBy({filterBy:['tel'],filterOp:'match',filterValue:filterValue.replace(/\s+/g,'')},function(results){if(results&&results.length){callback(results);return;}
fb.getContactByNumber(filterValue,function fbByPhone(contact){callback(contact?[contact]:[]);},function error_fbByPhone(err){if(err.name!=='DatastoreNotFound'){console.error('Error while retrieving fb by phone: ',err.name);}
callback(results);});});}};exports.Contacts=Contacts;}(this));;(function(exports){'use strict';var draftIndex=new Map();var isCached=false;var Drafts=exports.Drafts={List:DraftList,get size(){return draftIndex.size;},add:function(draft){var threadId;var thread;var stored;if(draft){if(!(draft instanceof Draft)){draft=new Draft(draft);}
threadId=draft.threadId||null;thread=draftIndex.get(threadId)||[];stored=thread[thread.length-1];if(threadId!==null&&thread.length){this.delete(stored);}
if(threadId===null&&thread.length){thread.some(function(d,i){if(d.id===draft.id){this.delete(d);stored=null;return true;}},this);}
thread.push(draft);draftIndex.set(threadId,thread);this.store();}
return this;},delete:function(draft){var thread;var index;if(draft){thread=draftIndex.get(draft.threadId);if(!thread){return this;}
index=thread.indexOf(draft);if(index===-1){if(thread&&typeof draft.id==='undefined'){thread.length=0;}else{if(thread){thread.some(function(stored,i){if(stored.id===draft.id){index=i;return true;}});}}}
if(index>-1){thread.splice(index,1);}}
return this;},byThreadId:function(id){return new Drafts.List(draftIndex.get(id));},get:function(id){var draft;draftIndex.forEach(function(records,threadId){if(!draft){draft=records.find(function(record){return record.id===+id;});}});return draft;},forEach:function(callback,thisArg){if(thisArg){callback=callback.bind(thisArg);}
draftIndex.forEach(function(drafts,threadId){if(threadId){var latest=drafts[drafts.length-1];callback(latest,threadId);}else{drafts.forEach(function(draft){callback(draft,null);});}});},clear:function(){draftIndex=new Map();isCached=false;return this;},store:function(){var entries=[];draftIndex.forEach(function(v,k){entries.push([k,v]);});asyncStorage.setItem('draft index',entries);},request:function(callback){function handler(){isCached=true;if(typeof callback==='function'){callback(Drafts.byThreadId(null));}}
if(isCached){setTimeout(function(){handler();});}else{asyncStorage.getItem('draft index',function(records){var rlength,drafts,dlength;if(records!==null){rlength=records.length;for(var i=0;i<rlength;i++){drafts=records[i][1];dlength=drafts.length;for(var j=0;j<dlength;j++){drafts[j]=new Draft(drafts[j]);}}}
draftIndex=new Map(records||[]);handler();});}}};var priv=new WeakMap();function DraftList(initializer){priv.set(this,initializer||[]);}
DraftList.prototype={get length(){return priv.get(this).length;},get latest(){var list=priv.get(this);return list.length?list[list.length-1]:null;},forEach:function(callback,thisArg){var drafts=priv.get(this);if(thisArg){callback=callback.bind(thisArg);}
for(var i=0;i<drafts.length;i++){callback(drafts[i]);}}};function Draft(opts){var draft=opts||{};if(draft.id&&typeof draft.id!=='number'){throw new Error('Draft id must be a number');}
this.id=draft.id||guid();this.recipients=draft.recipients||[];this.content=draft.content||[];this.subject=draft.subject||'';this.timestamp=+draft.timestamp||Date.now();this.threadId=draft.threadId||null;this.type=draft.type;this.isEdited=false;}
function guid(){return+(Date.now()+''+(Math.random()*1000|0));}
exports.Draft=Draft;}(this));;(function(exports){'use strict';var view=new WeakMap();var priv=new WeakMap();var data=new WeakMap();var events=new WeakMap();var relation=new WeakMap();var rdigit=/^\d/;const MIN_HEIGHT=45;function Recipient(opts){var number;opts=opts||{};this.name=opts.name||opts.number||'';this.number=(opts.number||'')+'';this.email=opts.email||'';this.editable=opts.editable||'true';this.source=opts.source||'manual';this.type=opts.type||'';this.separator=opts.separator||'';this.carrier=opts.carrier||'';this.className='recipient';this.isLookupable=opts.isLookupable||false;this.isInvalid=opts.isInvalid||false;this.isQuestionable=opts.isQuestionable||false;number=this.number[0]==='+'?this.number.slice(1):this.number;if(this.source==='manual'&&!rdigit.test(number)){this.isQuestionable=true;}
if(this.isQuestionable||this.isInvalid){this.className+=' attention';}}
Recipient.prototype.set=function(dict){var length=Recipient.FIELDS.length;var key;for(var i=0;i<length;i++){key=Recipient.FIELDS[i];this[key]=dict[key];}
return this;};Recipient.prototype.clone=function(){return new Recipient(this);};Recipient.FIELDS=['name','number','email','editable','source','type','separator','carrier','isQuestionable','isInvalid','isLookupable'];function Recipients(setup){if(!setup){throw new Error('`setup` missing');}
if(!setup.template){throw new Error('`setup.template` missing');}
if(!setup.outer){throw new Error('`setup.outer` missing');}
if(!setup.inner){throw new Error('`setup.inner` missing');}
var list=[];Object.defineProperties(this,{length:{get:function(){return list.length;},set:function(value){list.length=value;this.render();return value;}},list:{get:function(){return list.slice();}},numbers:{get:function(){return list.reduce(function(unique,recipient){var value=recipient.number||recipient.email;if(!recipient.isInvalid&&unique.indexOf(value)===-1){unique.push(value);}
return unique;},[]);}},inputValue:{get:function(){var node=document.getElementById(setup.inner).lastElementChild;return(node&&node.isPlaceholder)?node.textContent.trim():'';}}});data.set(this,list);view.set(this,new Recipients.View(this,setup));events.set(this,{add:[],remove:[]});}
Recipients.prototype.on=function(type,handler){var handlers=events.get(this);if(!handlers[type]){throw new Error('Invalid event type: '+type);}
handlers[type].push(handler);return this;};Recipients.prototype.off=function(type,handler){var handlers=events.get(this);if(!handlers[type]){throw new Error('Invalid event type: '+type);}
if(!handler){handlers[type].length=0;}else{handlers[type].splice(handlers[type].indexOf(handler),1);}
return this;};Recipients.prototype.emit=function(type){var handlers=events.get(this);var args=[].slice.call(arguments,1);var handler,stack;if(!handlers[type]){throw new Error('Invalid event type: '+type);}
stack=handlers[type].slice();if(stack.length){while((handler=stack.pop())){handler.apply(null,args);}}
return this;};Recipients.prototype.add=function(entry){var list=data.get(this);var added;if(entry.number===undefined){throw new Error('recipient entry missing number');}
entry.editable=entry.editable||'false';['name','number','email'].forEach(function(field){if(entry[field]){entry[field]=(entry[field]+'').trim();}});list.push(added=new Recipient(entry));this.emit('add',list.length,added.clone());this.render();return this;};Recipients.prototype.update=function(recipOrIndex,entry){var list=data.get(this);var index=typeof recipOrIndex==='number'?recipOrIndex:list.indexOf(recipOrIndex);if(index>-1){list[index].set(new Recipient(entry));}
return this.render();};Recipients.prototype.remove=function(recipOrIndex){var list=data.get(this);var index=typeof recipOrIndex==='number'?recipOrIndex:list.indexOf(recipOrIndex);if(index===-1){return this;}
list.splice(index,1);this.emit('remove',list.length);return this.render(index);};Recipients.prototype.render=function(){view.get(this).reset();return this;};Recipients.prototype.focus=function(){view.get(this).focus();return this;};Recipients.prototype.visible=function(type,opts){view.get(this).visible(type,opts||{});return this;};Recipients.View=function(owner,setup){var inner=document.getElementById(setup.inner);var outer=document.getElementById(setup.outer);var template=setup.template;var nodes=[];var clone;priv.set(this,{owner:owner,inner:inner,outer:outer,template:template,active:null,nodes:nodes,state:{isTransitioning:false,visible:'singleline'},minHeight:MIN_HEIGHT});clone=inner.cloneNode(true);clone.innerHTML=template.interpolate(new Recipient());clone.firstElementChild.innerHTML='';Object.defineProperties(this,{last:{get:function(){return nodes[nodes.length-1];}},placeholder:{get:function(){var node=clone.firstElementChild.cloneNode(true);node.isPlaceholder=true;return node;}}});['click','keypress','keyup','blur','pan'].forEach(function(type){outer.addEventListener(type,this,false);},this);new GestureDetector(outer).startDetecting();this.reset().focus();};Recipients.View.isFocusable=true;Recipients.View.prototype.reset=function(){this.clear().render();return this;};Recipients.View.prototype.clear=function(){priv.get(this).inner.textContent='';return this;};Recipients.View.prototype.render=function(opts){var view=priv.get(this);var nodes=view.nodes;var inner=view.inner;var template=view.template;var list=view.owner.list;var length=list.length;var html='';opts=opts||{};opts.addPlaceholder=opts.addPlaceholder===undefined?true:opts.addPlaceholder;if(inner.textContent){this.clear();}
for(var i=0;i<length;i++){html+=template.interpolate(list[i]);}
if(opts.editable){opts.addPlaceholder=false;html+=template.interpolate(opts.editable);}
if(html){inner.innerHTML=html;}
if(opts.addPlaceholder){inner.appendChild(this.placeholder);}
nodes.length=0;if(!list.length){nodes.push.apply(nodes,inner.children[0]);}else{nodes.push.apply(nodes,inner.children);}
nodes.forEach(function forEachNode(node,i){node.isPlaceholder=false;node.contentEditable=false;if(i===nodes.length-1){node.isPlaceholder=true;node.contentEditable=true;}else{relation.set(node,list[i]);}});if(view.state.visible==='singleline'){inner.querySelector(':last-child').scrollIntoView(false);}
return this;};Recipients.View.prototype.focus=function(node){var view=priv.get(this);var range=document.createRange();var selection=window.getSelection();if(Recipients.View.isFocusable){if(!node){node=view.inner.lastElementChild;if(!node.isPlaceholder){node=view.inner.appendChild(this.placeholder);}}
if(node&&node.isPlaceholder){node.contentEditable=true;node.focus();}
range.selectNodeContents(node);range.collapse(false);selection.removeAllRanges();selection.addRange(range);view.inner.scrollTop=view.inner.scrollHeight;}
return this;};var rtype=/^(multi|single)line$/;Recipients.View.prototype.visible=function(type,opts){var view=priv.get(this);var state=view.state;var error='visible "type" (multiline or singleline)';opts=opts||{};if(!type){throw new Error('Missing '+error);}
if(!rtype.test(type)){throw new Error('Invalid '+error);}
if(state.visible!==type){state.isTransitioning=false;}
if(state.isTransitioning){return this;}
if(state.visible===type){return this;}
view.inner.parentNode.addEventListener('transitionend',function te(){var last=view.inner.lastElementChild;var previous;if(location.hash==='#new'&&state.visible==='singleline'){while(last!==null&&last.isPlaceholder){previous=last.previousElementSibling;if(!last.textContent){last.parentNode.removeChild(last);}
last=previous;}
if(opts.refocus){opts.refocus.focus();}}
if(last!==null){last.scrollIntoView(true);}
state.isTransitioning=false;this.removeEventListener('transitionend',te,false);});state.visible=type;state.isTransitioning=true;view.outer.className=type;view.inner.className=type;return this;};Recipients.View.prototype.handleEvent=function(event){var view=priv.get(this);var owner=view.owner;var isPreventingDefault=false;var isAcceptedRecipient=false;var isEdittingRecipient=false;var isDeletingRecipient=false;var isLookupable=false;var target=event.target;var keyCode=event.keyCode;var editable='false';var lastElement=view.inner.lastElementChild;var typed,recipient,length,previous;Recipients.View.isFocusable=true;if(event.type==='keypress'||event.type==='keyup'){typed=target.textContent.trim();length=typed.length;}
switch(event.type){case'pan':if(view.state.visible==='singleline'&&view.inner.scrollHeight>view.minHeight){if(event.detail.absolute.dy>0){this.visible('multiline');}
event.preventDefault();event.stopPropagation();return;}
break;case'click':if(target.parentNode===view.inner){if(target.isPlaceholder){return;}
typed=lastElement&&lastElement.isPlaceholder?lastElement.textContent.trim():'';if(typed){owner.add({name:typed,number:typed,source:'manual'}).focus();}
recipient=relation.get(target);if(recipient){if(recipient.source==='contacts'){Recipients.View.prompts.remove(recipient,function(response){if(response.isConfirmed){owner.remove(relation.get(target));this.reset();}
Recipients.View.isFocusable=true;this.focus();}.bind(this));}else{isEdittingRecipient=true;typed=recipient.number||recipient.name;editable='true';owner.remove(recipient);target=view.inner.lastElementChild;target.textContent=typed;this.visible('singleline',{refocus:target});}}}else{if(view.state.visible!=='singleline'){this.visible('singleline',{refocus:this});}else{this.focus();}
return;}
break;case'keyup':if(typed&&(typed[length-1]===';'||typed[length-1]===',')){isAcceptedRecipient=true;isPreventingDefault=true;typed=typed.replace(/[;,]$/,'');target.textContent=typed;}
if(!isAcceptedRecipient&&(typed&&typed.length>=1)){this.visible('singleline',{refocus:target});}
if(!typed&&keyCode===event.DOM_VK_BACK_SPACE){isPreventingDefault=true;isDeletingRecipient=true;}
break;case'keypress':if(keyCode===event.DOM_VK_BACK_SPACE){previous=target.previousSibling;if(!typed&&previous){recipient=relation.get(previous);if(previous.dataset.source==='contacts'){isPreventingDefault=true;isDeletingRecipient=true;view.owner.remove(recipient);}else if(previous.dataset.source==='manual'){isEdittingRecipient=true;isPreventingDefault=true;target=previous;view.inner.removeChild(view.inner.lastElementChild);data.get(view.owner).pop();view.owner.emit('remove',data.get(view.owner).length);}}}
if((keyCode===13||keyCode===event.DOM_VK_ENTER)||(keyCode===event.DOM_VK_TAB)){if(typed){isPreventingDefault=true;if(target.parentNode===view.inner){if(keyCode!==event.DOM_VK_TAB){isAcceptedRecipient=true;isLookupable=true;target.textContent=typed;}}}}
break;}
if(isAcceptedRecipient){if(typed){view.owner.add({name:typed,number:typed,editable:editable,source:'manual',isLookupable:isLookupable});this.render().focus();}}
if(isDeletingRecipient){this.render().focus();}
if(isEdittingRecipient){target.contentEditable=true;target.isPlaceholder=true;this.focus(target);}
if(isPreventingDefault){event.preventDefault();}};Recipients.View.prompts={remove:function(recipient,callback){var response={isConfirmed:false};var handler=function(){if(typeof callback==='function'){callback(response);}};var dialogBody=document.createDocumentFragment();if(recipient.type){var typeElement=document.createElement('span');if(!navigator.mozL10n.get(recipient.type)){typeElement.textContent=recipient.type;}else{navigator.mozL10n.localize(typeElement,recipient.type);}
dialogBody.appendChild(typeElement);}
dialogBody.appendChild(document.createTextNode(recipient.separator+recipient.carrier+recipient.number));var dialog=new Dialog({title:{value:recipient.name||recipient.number},body:{value:dialogBody},options:{cancel:{text:{l10nId:'cancel'},method:handler},confirm:{text:{l10nId:'remove'},method:function(){response.isConfirmed=true;handler();},position:'left'}}});dialog.show();Recipients.View.isFocusable=false;}};exports.Recipients=Recipients;}(this));;(function(exports){'use strict';var threads=new Map();var rthread=/\bthread=(.+)$/;var currentId,lastId;function cacheId(){var matches=rthread.exec(window.location.hash);currentId=(matches&&matches.length)?+(matches[1].trim()):null;if(currentId!==null&&currentId!==lastId){lastId=currentId;}
return currentId;}
function Thread(thread){var length=Thread.FIELDS.length;var key;for(var i=0;i<length;i++){key=Thread.FIELDS[i];this[key]=thread[key];}
this.messages=[];}
Thread.FIELDS=['body','id','lastMessageSubject','lastMessageType','participants','timestamp','unreadCount'];Thread.fromMessage=function(record,options){var participants=[];if(typeof record.delivery!=='undefined'){if(record.delivery==='received'||record.delivery==='not-downloaded'){participants=[record.sender];}else{participants=record.receivers||[record.receiver];}}
return new Thread({id:record.threadId,participants:participants,body:record.body,timestamp:record.timestamp,unreadCount:(options&&options.unread)?1:0,lastMessageType:record.type||'sms'});};Thread.fromDraft=function(record,options){var participants=record.recipients&&record.recipients.length?record.recipients:[''];var body=record.content&&record.content.length?record.content.find(function(content){if(typeof content==='string'){return true;}}):'';return new Thread({id:record.threadId||record.id,participants:participants,body:body,timestamp:new Date(record.timestamp),unreadCount:(options&&options.unread)?1:0,lastMessageType:record.type||'sms'});};Thread.create=function(record,options){if(record instanceof Thread){return record;}
return record.delivery?Thread.fromMessage(record,options):Thread.fromDraft(record,options);};Thread.prototype={constructor:Thread,get drafts(){return Drafts.byThreadId(this.id);},get hasDrafts(){return!!this.drafts.length;}};var Threads=exports.Threads={registerMessage:function(message){var thread=Thread.create(message);var threadId=message.threadId;if(!this.has(threadId)){this.set(threadId,thread);}
this.get(threadId).messages.push(message);},set:function(id,thread){var old,length,key;id=+id;if(threads.has(id)){old=threads.get(id);length=Thread.FIELDS.length;for(var i=0;i<length;i++){key=Thread.FIELDS[i];old[key]=thread[key];}
return threads;}
return threads.set(id,new Thread(thread));},get:function(id){return threads.get(+id);},has:function(id){return threads.has(+id);},delete:function(id){id=+id;var thread=this.get(id);if(thread&&thread.hasDrafts){Drafts.delete({threadId:id});}
return threads.delete(id);},clear:function(){threads=new Map();},forEach:function(callback){threads.forEach(function(v,k){callback(v,k);});},get size(){if(typeof threads.size==='function'){return+threads.size();}
return+threads.size;},get currentId(){if(window.location.hash.startsWith('#thread=')){if(!currentId){currentId=cacheId();}}else{currentId=null;}
return currentId;},get lastId(){return lastId;},get active(){return threads.get(+Threads.currentId);}};exports.Thread=Thread;window.addEventListener('hashchange',cacheId);}(this));;'use strict';var MessageManager={activity:null,forward:null,init:function mm_init(callback){if(this.initialized){return;}
this.initialized=true;this._mozMobileMessage=navigator.mozMobileMessage||window.DesktopMockNavigatormozMobileMessage;this._mozMobileMessage.addEventListener('received',this.onMessageReceived.bind(this));this._mozMobileMessage.addEventListener('sending',this.onMessageSending);this._mozMobileMessage.addEventListener('sent',this.onMessageSent);this._mozMobileMessage.addEventListener('failed',this.onMessageFailed);this._mozMobileMessage.addEventListener('deliverysuccess',this.onDeliverySuccess);this._mozMobileMessage.addEventListener('readsuccess',this.onReadSuccess);window.addEventListener('hashchange',this.onHashChange.bind(this));document.addEventListener('visibilitychange',this.onVisibilityChange.bind(this));['main-wrapper','thread-messages'].forEach(function(id){this[Utils.camelCase(id)]=document.getElementById(id);},this);if(typeof callback==='function'){callback();}},onMessageSending:function mm_onMessageSending(e){var message=e.message;Threads.registerMessage(message);ThreadUI.onMessageSending(message);ThreadListUI.onMessageSending(message);},onMessageFailed:function mm_onMessageFailed(e){ThreadUI.onMessageFailed(e.message);},onDeliverySuccess:function mm_onDeliverySuccess(e){var hashInfo=window.location.hash.split('=');if(hashInfo[0]==='#report-view'&&hashInfo[1]===''+e.message.id){ReportView.refresh();}
ThreadUI.onDeliverySuccess(e.message);},onReadSuccess:function mm_onReadSuccess(e){var hashInfo=window.location.hash.split('=');if(hashInfo[0]==='#report-view'&&hashInfo[1]===''+e.message.id){ReportView.refresh();}
ThreadUI.onReadSuccess(e.message);},onMessageSent:function mm_onMessageSent(e){ThreadUI.onMessageSent(e.message);},onMessageReceived:function mm_onMessageReceived(e){var message=e.message;if(message.messageClass&&message.messageClass==='class-0'){return;}
if(message.delivery==='not-downloaded'&&message.deliveryInfo[0].deliveryStatus==='pending'){return;}
Threads.registerMessage(message);if(message.threadId===Threads.currentId){this.markMessagesRead([message.id],function(){ThreadListUI.updateThread(message);});ThreadUI.onMessageReceived(message);}else{ThreadListUI.onMessageReceived(message);}},onVisibilityChange:function mm_onVisibilityChange(e){LinkActionHandler.reset();},slide:function mm_slide(direction,callback){var wrapper=this.mainWrapper;if(wrapper.dataset.position===direction){setTimeout(callback);return;}
wrapper.dataset.position=direction;var trEndCount=0;wrapper.addEventListener('transitionend',function trWait(e){trEndCount++;if(trEndCount!=2){return;}
wrapper.removeEventListener(e.type,trWait);callback&&callback();});},launchComposer:function mm_launchComposer(callback){ThreadUI.cleanFields(true);var draft=ThreadUI.draft||Drafts.get(Threads.currentId);if(draft){draft.recipients.forEach(function(number){Contacts.findByPhoneNumber(number,function(records){if(records.length){ThreadUI.recipients.add(Utils.basicContact(number,records[0]));}else{ThreadUI.recipients.add({number:number});}});});Compose.fromDraft(draft);Drafts.delete(draft).store();}
this.threadMessages.classList.add('new');ThreadUI.onBeforeEnter();this.slide('left',function(){callback&&callback();});},handleForward:function mm_handleForward(forward){if(!forward){return;}
var request=MessageManager.getMessage(+forward.messageId);request.onsuccess=(function(){Compose.fromMessage(request.result);ThreadUI.recipients.focus();}).bind(this);request.onerror=function(){console.error('Error while forwarding.');};this.forward=null;},handleActivity:function mm_handleActivity(activity){if(!activity){return;}
var findByPhoneNumber=Contacts.findByPhoneNumber.bind(Contacts);var number=activity.number;if(activity.contact&&!number){findByPhoneNumber=function dummySource(contact,cb){cb(activity.contact);};number=activity.contact.number||activity.contact.tel[0].value;}
if(activity.contact&&number){Utils.getContactDisplayInfo(findByPhoneNumber,number,function onData(data){data.source='contacts';ThreadUI.recipients.add(data);Compose.fromMessage(activity);});}else{if(number){ThreadUI.recipients.add({number:number,source:'manual'});}
Compose.fromMessage(activity);}
this.activity=null;},onHashChange:function mm_onHashChange(e){document.activeElement.blur();GroupView.reset();ReportView.reset();ThreadUI.cancelEdit();ThreadListUI.cancelEdit();var self=this;switch(window.location.hash.split('=')[0]){case'#new':ThreadUI.inThread=false;MessageManager.launchComposer(function(){this.handleActivity(this.activity);this.handleForward(this.forward);if(ThreadUI.draft){ThreadUI.draft.isEdited=false;}
ThreadUI.recipients.focus();}.bind(this));break;case'#thread-list':ThreadUI.inThread=false;var optionsButton=document.getElementById('messages-options-icon');optionsButton.parentNode.appendChild(optionsButton);ThreadListUI.renderDrafts();if(this.threadMessages.classList.contains('new')){MessageManager.slide('right',function(){self.threadMessages.classList.remove('new');});}else{ThreadUI.container.textContent='';MessageManager.slide('right',function(){if(self.activity&&self.activity.threadId){window.location.hash='#thread='+self.activity.threadId;self.activity=null;}});}
break;case'#group-view':GroupView.show();break;case'#report-view':ReportView.show();break;default:var threadId=Threads.currentId;var willSlide=true;var finishTransition=(function finishTransition(){if(!ThreadUI.inThread){ThreadUI.inThread=true;ThreadUI.renderMessages(threadId);var thread=Threads.get(threadId);if(thread.hasDrafts){ThreadUI.draft=thread.drafts.latest;Compose.fromDraft(ThreadUI.draft);ThreadUI.draft.isEdited=false;}else{ThreadUI.draft=null;}}}).bind(this);if(this.threadMessages.classList.contains('new')){this.threadMessages.classList.remove('new');willSlide=false;}
ThreadListUI.mark(threadId,'read');Utils.closeNotificationsForThread();ThreadUI.onBeforeEnter();ThreadUI.updateHeaderData(function headerUpdated(){if(willSlide){MessageManager.slide('left',function(){finishTransition();});}else{finishTransition();}});break;}},getThreads:function mm_getThreads(options){var cursor=this._mozMobileMessage.getThreads();var each=options.each;var end=options.end;var done=options.done;cursor.onsuccess=function onsuccess(){if(this.result){Threads.set(this.result.id,this.result);if(this.result.id===Threads.currentId){ThreadUI.updateHeaderData();}
each&&each(this.result);this.continue();return;}
end&&end();done&&done();};cursor.onerror=function onerror(){console.error('Reading the database. Error: '+this.error.name);done&&done();};},getMessage:function mm_getMsg(id){return this._mozMobileMessage.getMessage(id);},retrieveMMS:function mm_retrieveMMS(id){return this._mozMobileMessage.retrieveMMS(id);},getMessages:function mm_getMgs(options){var each=options.each;var filter=options.filter;var invert=options.invert;var end=options.end;var endArgs=options.endArgs;var done=options.done;var cursor=this._mozMobileMessage.getMessages(filter,!invert);cursor.onsuccess=function onsuccess(){if(!this.done){var shouldContinue=true;if(each){shouldContinue=each(this.result);}
if(shouldContinue!==false){this.continue();}else{done&&done();}}else{end&&end(endArgs);done&&done();}};cursor.onerror=function onerror(){var msg='Reading the database. Error: '+this.error.name;console.log(msg);done&&done();};},_sanitizeServiceId:function mm_sanitizeServiceId(serviceId){if(serviceId==null||isNaN(+serviceId)){serviceId=null;}else{serviceId=+serviceId;}
return serviceId;},_getSendOptionsFromServiceId:function mm_gSOFSI(serviceId){var sendOpts;if(serviceId!=null&&Settings.hasSeveralSim()){sendOpts={serviceId:serviceId};}
return sendOpts;},sendSMS:function mm_send(opts){var recipients=opts.recipients||[],content=opts.content,serviceId=this._sanitizeServiceId(opts.serviceId),onsuccess=opts.onsuccess,onerror=opts.onerror,oncomplete=opts.oncomplete;if(!Array.isArray(recipients)){recipients=[recipients];}
var i=0;var requestResult={hasError:false,return:[]};var sendOpts=this._getSendOptionsFromServiceId(serviceId);var requests=this._mozMobileMessage.send(recipients,content,sendOpts);var numberOfRequests=requests.length;requests.forEach(function(request,idx){request.onsuccess=function onSuccess(event){onsuccess&&onsuccess(event.target.result);requestResult.return.push({success:true,result:event.target.result,recipient:recipients[idx]});if(i===numberOfRequests-1){oncomplete&&oncomplete(requestResult);}
i++;};request.onerror=function onError(event){console.error('Error Sending: '+JSON.stringify(event.target.error));onerror&&onerror(event.target.error);requestResult.hasError=true;requestResult.return.push({success:false,code:event.target.error,recipient:recipients[idx]});if(i===numberOfRequests-1){oncomplete&&oncomplete(requestResult);}
i++;};});},sendMMS:function mm_sendMMS(opts){var serviceId=opts.serviceId=this._sanitizeServiceId(opts.serviceId);if(serviceId!==null&&Settings.hasSeveralSim()&&serviceId!==Settings.mmsServiceId){Settings.switchMmsSimHandler(serviceId,this._doSendMMS.bind(this,opts));}else{this._doSendMMS(opts);}},_doSendMMS:function mm_doSendMMS(opts){var request;var recipients=opts.recipients,subject=opts.subject,content=opts.content,serviceId=opts.serviceId,onsuccess=opts.onsuccess,onerror=opts.onerror;if(!Array.isArray(recipients)){recipients=[recipients];}
var message=SMIL.generate(content);var sendOpts=this._getSendOptionsFromServiceId(serviceId);request=this._mozMobileMessage.sendMMS({receivers:recipients,subject:subject,smil:message.smil,attachments:message.attachments},sendOpts);request.onsuccess=function onSuccess(event){onsuccess&&onsuccess(event.target.result);};request.onerror=function onError(event){onerror&&onerror(event.target.error);};},resendMessage:function mm_resendMessage(message,callback){var request;var serviceId=Settings.getServiceIdByIccId(message.iccId);var sendOpts=this._getSendOptionsFromServiceId(serviceId);if(message.type==='sms'){request=this._mozMobileMessage.send(message.receiver,message.body,sendOpts);}
if(message.type==='mms'){request=this._mozMobileMessage.sendMMS({receivers:message.receivers,subject:message.subject,smil:message.smil,attachments:message.attachments},sendOpts);}
request.onsuccess=function onSuccess(evt){MessageManager.deleteMessage(message.id);if(callback){callback(null,evt.target.result);}};request.onerror=function onError(evt){MessageManager.deleteMessage(message.id);if(callback){callback(evt.target.error);}};return request;},deleteMessage:function mm_deleteMessage(id,callback){var req=this._mozMobileMessage.delete(id);req.onsuccess=function onsuccess(){callback&&callback(this.result);};req.onerror=function onerror(){var msg='Deleting in the database. Error: '+req.error.name;console.log(msg);callback&&callback(null);};},deleteMessages:function mm_deleteMessages(list,callback){this.deleteMessage(list,callback);},markThreadRead:function mm_markThreadRead(threadId,callback){var filter=new MozSmsFilter();filter.threadId=threadId;filter.read=false;var messagesUnreadIDs=[];var changeStatusOptions={each:function addUnreadMessage(message){messagesUnreadIDs.push(message.id);return true;},filter:filter,invert:true,end:function handleUnread(){MessageManager.markMessagesRead(messagesUnreadIDs);}};MessageManager.getMessages(changeStatusOptions);},markMessagesRead:function mm_markMessagesRead(list,callback){if(!this._mozMobileMessage||!list.length){return;}
var req=this._mozMobileMessage.markMessageRead(list.pop(),true,true);req.onsuccess=(function onsuccess(){if(!list.length&&callback){callback(req.result);return;}
this.markMessagesRead(list,callback);}).bind(this);req.onerror=function onerror(){if(callback){callback(null);}};}};;(function(exports){'use strict';var MIN_THUMBNAIL_WIDTH_HEIGHT=80;var MAX_THUMBNAIL_WIDTH_HEIGHT=120;var MAX_THUMBNAIL_GENERATION_SIZE=1.5*1024*1024;const ATTACHMENT_FOLDER_PATH='sms-attachments/';function Attachment(blob,options){options=options||{};this.blob=blob;this.name=blob.name||options.name||navigator.mozL10n.get('unnamed-attachment');this.isDraft=!!options.isDraft;}
Attachment.prototype={get size(){return this.blob.size;},get sizeForL10n(){var sizeKB=this.blob.size/1024;var sizeMB=sizeKB/1024;if(sizeKB<1000){return{l10nId:'attachmentSize',l10nArgs:{n:sizeKB.toFixed(1)}};}else{return{l10nId:'attachmentSizeMB',l10nArgs:{n:sizeMB.toFixed(1)}};}},get type(){return Utils.typeFromMimeType(this.blob.type);},getThumbnail:function(callback){if(typeof(callback)!=='function'){return;}
var type=this.blob.type;var img=new Image();img.src=Utils.getDownsamplingSrcUrl({url:window.URL.createObjectURL(this.blob),size:this.blob.size,type:'thumbnail'});img.onload=function onBlobLoaded(){window.URL.revokeObjectURL(img.src);var min=MIN_THUMBNAIL_WIDTH_HEIGHT;var max=MAX_THUMBNAIL_WIDTH_HEIGHT;var width,height;if(img.width<img.height){width=min;height=Math.min(img.height/img.width*min,max);}else{width=Math.min(img.width/img.height*min,max);height=min;}
var canvas=document.createElement('canvas');var ratio=Math.max(img.width/width,img.height/height);canvas.width=Math.round(img.width/ratio);canvas.height=Math.round(img.height/ratio);var context=canvas.getContext('2d',{willReadFrequently:true});context.drawImage(img,0,0,width,height);var data=canvas.toDataURL(type);callback({width:width,height:height,data:data});};img.onerror=function onBlobError(){callback({width:MIN_THUMBNAIL_WIDTH_HEIGHT,height:MIN_THUMBNAIL_WIDTH_HEIGHT,error:true});};},getAttachmentSrc:function(thumbnail,tmplID){thumbnail=thumbnail||{};var sizeL10n=this.sizeForL10n;return Template(tmplID).interpolate({type:this.type,errorClass:thumbnail.error?'corrupted':'',imgData:thumbnail.data,fileName:this.name.slice(this.name.lastIndexOf('/')+1),sizeL10nId:sizeL10n.l10nId,sizeL10nArgs:JSON.stringify(sizeL10n.l10nArgs)});},render:function(readyCallback){var container=document.createElement(this.isDraft?'iframe':'div');var setAttachmentContainerSrc=(function(thumbnail){thumbnail=thumbnail||{width:MIN_THUMBNAIL_WIDTH_HEIGHT,height:MIN_THUMBNAIL_WIDTH_HEIGHT,data:'',error:false};var hasPreview=(thumbnail.data&&!thumbnail.error);if(hasPreview){var borderWidth=1;container.style.width=(thumbnail.width+2*borderWidth)+'px';container.style.height=(thumbnail.height+2*borderWidth)+'px';}
var previewClass=hasPreview?'preview':'nopreview';var tmplID='attachment-'+previewClass+'-tmpl';container.classList.add(previewClass);if(this.isDraft){container.setAttribute('sandbox','allow-same-origin');var tmplSrc=Template('attachment-draft-tmpl').interpolate({previewClass:previewClass,baseURL:location.protocol+'//'+location.host+'/',attachmentHTML:this.getAttachmentSrc(thumbnail,tmplID)},{safe:['attachmentHTML']});container.addEventListener('load',function onload(){this.removeEventListener('load',onload);this.contentDocument.documentElement.innerHTML=tmplSrc;});container.addEventListener('load',iframeLoad);container.src='about:blank';}else{container.innerHTML=this.getAttachmentSrc(thumbnail,tmplID);}
if(readyCallback){readyCallback();}}).bind(this);container.className='attachment-container';container.dataset.attachmentType=this.type;if(this.type==='img'&&this.size<MAX_THUMBNAIL_GENERATION_SIZE){this.getThumbnail(setAttachmentContainerSrc);}else{setTimeout(setAttachmentContainerSrc);}
return container;},view:function(options){var mimetype=MimeMapper.guessTypeFromFileProperties(this.name,this.blob.type);var filename=MimeMapper.ensureFilenameMatchesType(this.name,mimetype);filename=ATTACHMENT_FOLDER_PATH+getBaseName(filename);var activity=new MozActivity({name:'open',data:{type:mimetype,filename:filename,blob:this.blob,allowSave:options&&options.allowSave}});activity.onerror=function(){var _=navigator.mozL10n.get;console.error('error with open activity',this.error.name);if(this.error.name==='NO_PROVIDER'){alert(_('attachmentOpenError'));}};}};function iframeLoad(event){var iframe=event.target;var clickOnFrame=iframe.click.bind(iframe);iframe.removeEventListener('load',iframeLoad);navigator.mozL10n.translate(iframe.contentDocument.body);iframe.contentDocument.addEventListener('click',clickOnFrame);}
function getBaseName(filePath){if(!filePath){throw new Error('Filepath is not defined!');}
return filePath.substring(filePath.lastIndexOf('/')+1);}
exports.Attachment=Attachment;}(this));;'use strict';var AttachmentMenu={init:function(id){this.el=document.getElementById(id);['view','remove','replace','cancel'].forEach(function(button){this[button+'Button']=this.el.querySelector('#attachment-options-'+button);}.bind(this));this.header=this.el.querySelector('header');},open:function(attachment){var name=attachment.name;var blob=attachment.blob;var l10n=navigator.mozL10n;var fileName=name.substr(name.lastIndexOf('/')+1);var types=['image','audio','video'];var mimeFirstPart=blob.type.substr(0,blob.type.indexOf('/'));var fileType='other';if(types.indexOf(mimeFirstPart)>-1){fileType=mimeFirstPart;}
this.header.textContent=fileName;l10n.localize(this.viewButton,'view-attachment-'+fileType);l10n.localize(this.removeButton,'remove-attachment-'+fileType);l10n.localize(this.replaceButton,'replace-attachment-'+fileType);this.el.className='';this.el.focus();},close:function(){this.el.className='hide';}};;(function(exports){'use strict';var ThreadListUI={draftLinks:null,draftRegistry:null,DRAFT_SAVED_DURATION:5000,timeouts:{onDraftSaved:null},count:0,inEditMode:false,init:function thlui_init(){this.tmpl={thread:Template('messages-thread-tmpl')};['container','no-messages','check-all-button','uncheck-all-button','delete-button','cancel-button','options-icon','edit-mode','edit-form','draft-saved-banner'].forEach(function(id){this[Utils.camelCase(id)]=document.getElementById('threads-'+id);},this);this.mainWrapper=document.getElementById('main-wrapper');this.delNumList=[];this.checkAllButton.addEventListener('click',this.toggleCheckedAll.bind(this,true));this.uncheckAllButton.addEventListener('click',this.toggleCheckedAll.bind(this,false));this.deleteButton.addEventListener('click',this.delete.bind(this));this.cancelButton.addEventListener('click',this.cancelEdit.bind(this));this.optionsIcon.addEventListener('click',this.showOptions.bind(this));this.container.addEventListener('click',this);this.editForm.addEventListener('submit',this);navigator.mozContacts.addEventListener('contactchange',this.updateContactsInfo.bind(this));this.draftLinks=new Map();ThreadListUI.draftRegistry={};this.sticky=new StickyHeader(this.container,document.getElementById('sticky'));},getAllInputs:function thlui_getAllInputs(){if(this.container){return Array.prototype.slice.call(this.container.querySelectorAll('input[type=checkbox]'));}else{return[];}},getSelectedInputs:function thlui_getSelectedInputs(){if(this.container){return Array.prototype.slice.call(this.container.querySelectorAll('input[type=checkbox]:checked'));}else{return[];}},setContact:function thlui_setContact(node){var thread=Threads.get(node.dataset.threadId);var draft=Drafts.get(node.dataset.threadId);var number,others;if(thread){number=thread.participants[0];others=thread.participants.length-1;}else if(draft){number=draft.recipients[0];others=draft.recipients.length-1;}else{console.error('This node does not look like a displayed list item: ',node.dataset.threadId);return;}
if(!number){navigator.mozL10n.localize(node.querySelector('.name'),'no-recipient');return;}
Contacts.findByPhoneNumber(number,function gotContact(contacts){var name=node.getElementsByClassName('name')[0];var photo=node.querySelector('span[data-type=img]');var title,src,details;if(contacts&&contacts.length){details=Utils.getContactDetails(number,contacts[0],{photoURL:true});title=details.title||number;src=details.photoURL||'';}else{title=number;src='';}
if(src){node.dataset.photoUrl=src;}
navigator.mozL10n.localize(name,'thread-header-text',{name:title,n:others});photo.style.backgroundImage='url('+src+')';});},handleEvent:function thlui_handleEvent(event){var draftId;switch(event.type){case'click':if(event.target.type&&event.target.type==='checkbox'){this.checkInputs();}
if((draftId=this.draftLinks.get(event.target))){ThreadUI.draft=Drafts.get(draftId);}
break;case'submit':event.preventDefault();break;}},checkInputs:function thlui_checkInputs(){var selected=ThreadListUI.selectedInputs.length;if(selected===ThreadListUI.allInputs.length){this.checkAllButton.disabled=true;}else{this.checkAllButton.disabled=false;}
if(selected){this.uncheckAllButton.disabled=false;this.deleteButton.classList.remove('disabled');navigator.mozL10n.localize(this.editMode,'selected',{n:selected});}else{this.uncheckAllButton.disabled=true;this.deleteButton.classList.add('disabled');navigator.mozL10n.localize(this.editMode,'deleteMessages-title');}},cleanForm:function thlui_cleanForm(){var inputs=this.allInputs;var length=inputs.length;for(var i=0;i<length;i++){inputs[i].checked=false;inputs[i].parentNode.parentNode.classList.remove('undo-candidate');}
this.delNumList=[];this.checkInputs();},toggleCheckedAll:function thlui_select(value){var inputs=this.container.querySelectorAll('input[type="checkbox"]'+
(value?':not(:checked)':':checked'));var length=inputs.length;for(var i=0;i<length;i++){inputs[i].checked=value;}
this.checkInputs();},removeThread:function thlui_removeThread(threadId){var li=document.getElementById('thread-'+threadId);var parent,draftId;var photoUrl=li&&li.dataset.photoUrl;if(photoUrl){window.URL.revokeObjectURL(photoUrl);}
if(li){parent=li.parentNode;li.remove();}
if((draftId=this.draftLinks.get(li))){this.draftLinks.delete(li);delete this.draftRegistry[draftId];}
if(parent&&!parent.firstElementChild){parent.previousSibling.remove();parent.remove();this.sticky.refresh();if(!this.container.querySelector('li')){this.setEmpty(true);}}},delete:function thlui_delete(){var question=navigator.mozL10n.get('deleteThreads-confirmation2');var list,length,id,threadId,filter,count;function checkDone(threadId){Threads.delete(threadId);this.removeThread(threadId);Utils.closeNotificationsForThread(threadId);if(--count===0){this.cancelEdit();Drafts.store();WaitingScreen.hide();}}
function deleteMessage(message){MessageManager.deleteMessage(message.id);return true;}
if(confirm(question)){WaitingScreen.show();list=this.selectedInputs.reduce(function(list,input){list[input.dataset.mode].push(+input.value);return list;},{drafts:[],threads:[]});if(list.drafts.length){length=list.drafts.length;for(var i=0;i<length;i++){id=list.drafts[i];Drafts.delete(Drafts.get(id));this.removeThread(id);}
Drafts.store();if(list.threads.length===0){this.cancelEdit();WaitingScreen.hide();return;}}
count=list.threads.length;while((threadId=+list.threads.pop())){filter=new MozSmsFilter();filter.threadId=threadId;MessageManager.getMessages({filter:filter,invert:true,each:deleteMessage,end:checkDone.bind(this,threadId)});}}},setEmpty:function thlui_setEmpty(empty){var addWhenEmpty=empty?'add':'remove';var removeWhenEmpty=empty?'remove':'add';ThreadListUI.noMessages.classList[removeWhenEmpty]('hide');ThreadListUI.container.classList[addWhenEmpty]('hide');},showOptions:function thlui_options(){var params={items:[{l10nId:'settings',method:function oSettings(){ActivityPicker.openSettings();}},{l10nId:'cancel',incomplete:true}]};if(ThreadListUI.noMessages.classList.contains('hide')){params.items.unshift({l10nId:'deleteMessages-label',method:this.startEdit.bind(this)});}
new OptionMenu(params).show();},startEdit:function thlui_edit(){this.inEditMode=true;this.cleanForm();this.mainWrapper.classList.toggle('edit');},cancelEdit:function thlui_cancelEdit(){this.inEditMode=false;this.mainWrapper.classList.remove('edit');},renderDrafts:function thlui_renderDrafts(){Drafts.request(function(){Drafts.forEach(function(draft,threadId){if(threadId){var el=document.getElementById('thread-'+threadId);if(el){this.updateThread(Threads.get(threadId));}}else{this.setEmpty(false);if(!this.draftRegistry[draft.id]){this.appendThread(Thread.create(draft));}}},this);this.sticky.refresh();}.bind(this));},prepareRendering:function thlui_prepareRendering(){this.container.innerHTML='';this.renderDrafts();},startRendering:function thlui_startRenderingThreads(){this.setEmpty(false);},finalizeRendering:function thlui_finalizeRendering(empty){if(empty){this.setEmpty(true);}
if(!empty){TimeHeaders.updateAll('header[data-time-update]');}
this.sticky.refresh();},renderThreads:function thlui_renderThreads(done){PerformanceTestingHelper.dispatch('will-render-threads');var hasThreads=false;var firstPanelCount=9;this.prepareRendering();function onRenderThread(thread){if(!hasThreads){hasThreads=true;this.startRendering();}
this.appendThread(thread);if(--firstPanelCount===0){PerformanceTestingHelper.dispatch('above-the-fold-ready');}}
function onThreadsRendered(){this.finalizeRendering(!(hasThreads||Drafts.size));PerformanceTestingHelper.dispatch('startup-path-done');}
var renderingOptions={each:onRenderThread.bind(this),end:onThreadsRendered.bind(this),done:done};MessageManager.getThreads(renderingOptions);},createThread:function thlui_createThread(record){var li=document.createElement('li');var timestamp=+record.timestamp;var type=record.lastMessageType;var participants=record.participants;var number=participants[0];var id=record.id;var bodyHTML=record.body;var thread=Threads.get(id);var draft,draftId;var isDraft=typeof thread==='undefined';var hasDrafts=isDraft?false:thread.hasDrafts;if(hasDrafts){draft=Drafts.byThreadId(thread.id).latest;timestamp=Math.max(draft.timestamp,timestamp);if(draft.timestamp>=record.timestamp){bodyHTML=draft.content.find(function(content){if(typeof content==='string'){return true;}});type=draft.type;}}
bodyHTML=Template.escape(bodyHTML||'');li.id='thread-'+id;li.dataset.threadId=id;li.dataset.time=timestamp;li.dataset.lastMessageType=type;if(record.unreadCount>0){li.classList.add('unread');}
if(hasDrafts||isDraft){li.classList.add('draft');if(hasDrafts){li.classList.add('has-draft');}else{li.classList.add('is-draft');}
draftId=hasDrafts?draft.id:record.id;this.draftRegistry[draftId]=true;}
li.innerHTML=this.tmpl.thread.interpolate({hash:isDraft?'#new':'#thread='+id,mode:isDraft?'drafts':'threads',id:isDraft?draftId:id,number:number,bodyHTML:bodyHTML,timestamp:String(timestamp)},{safe:['id','bodyHTML']});TimeHeaders.update(li.querySelector('time'));if(draftId){this.draftLinks.set(li.querySelector('a'),draftId);}
return li;},insertThreadContainer:function thlui_insertThreadContainer(group,timestamp){var headers=ThreadListUI.container.getElementsByTagName('header');var groupFound=false;for(var i=0;i<headers.length;i++){if(timestamp>=headers[i].dataset.time){groupFound=true;ThreadListUI.container.insertBefore(group,headers[i].parentNode);break;}}
if(!groupFound){ThreadListUI.container.appendChild(group);}},updateThread:function thlui_updateThread(record,options){var thread=Thread.create(record,options);var threadUINode=document.getElementById('thread-'+thread.id);var threadUITime=threadUINode?+threadUINode.dataset.time:NaN;var recordTime=+thread.timestamp;if(Threads.has(thread.id)){Threads.set(thread.id,thread);}
var newMessageReceived=options&&options.unread;if(newMessageReceived&&threadUITime>recordTime){this.mark(thread.id,'unread');return;}
var messagesDeleted=options&&options.deleted;if(messagesDeleted&&threadUITime===recordTime){return;}
if(threadUINode){this.removeThread(thread.id);}
this.appendThread(thread);this.setEmpty(false);this.sticky.refresh();},onMessageSending:function thlui_onMessageSending(message){this.updateThread(message);},onMessageReceived:function thlui_onMessageReceived(message){this.updateThread(message,{unread:true});},appendThread:function thlui_appendThread(thread){var timestamp=+thread.timestamp;var drafts=Drafts.byThreadId(thread.id);if(drafts.length){timestamp=Math.max(drafts.latest.timestamp,timestamp);}
var node=this.createThread(thread);this.setContact(node);var threadsContainerID='threadsContainer_'+
Utils.getDayDate(timestamp);var threadsContainer=document.getElementById(threadsContainerID);if(!threadsContainer){var threadsContainerWrapper=ThreadListUI.createThreadContainer(timestamp);threadsContainer=threadsContainerWrapper.childNodes[1];ThreadListUI.insertThreadContainer(threadsContainerWrapper,timestamp);}
var threads=threadsContainer.getElementsByTagName('li');var threadFound=false;for(var i=0,l=threads.length;i<l;i++){if(timestamp>threads[i].dataset.time){threadFound=true;threadsContainer.insertBefore(node,threads[i]);break;}}
if(!threadFound){threadsContainer.appendChild(node);}
if(this.inEditMode){this.checkInputs();}},createThreadContainer:function thlui_createThreadContainer(timestamp){var threadContainer=document.createElement('div');var headerDOM=document.createElement('header');headerDOM.id='header_'+timestamp;headerDOM.dataset.timeUpdate='repeat';headerDOM.dataset.time=timestamp;headerDOM.dataset.isThread=true;var threadsContainerDOM=document.createElement('ul');threadsContainerDOM.id='threadsContainer_'+
Utils.getDayDate(timestamp);headerDOM.innerHTML=Utils.getHeaderDate(timestamp);threadContainer.appendChild(headerDOM);threadContainer.appendChild(threadsContainerDOM);return threadContainer;},updateContactsInfo:function mm_updateContactsInfo(){if(!this.container){return;}
var threads=this.container.getElementsByTagName('li');[].forEach.call(threads,this.setContact.bind(this));},mark:function thlui_mark(id,current){var li=document.getElementById('thread-'+id);var remove='read';if(current==='read'){remove='unread';}
if(li){li.classList.remove(remove);li.classList.add(current);}},onDraftSaved:function thlui_onDraftSaved(){this.draftSavedBanner.classList.remove('hide');clearTimeout(this.timeouts.onDraftSaved);this.timeouts.onDraftSaved=null;this.timeouts.onDraftSaved=setTimeout(function hideDraftSavedBanner(){this.draftSavedBanner.classList.add('hide');}.bind(this),this.DRAFT_SAVED_DURATION);}};Object.defineProperty(ThreadListUI,'allInputs',{get:function(){return this.getAllInputs();}});Object.defineProperty(ThreadListUI,'selectedInputs',{get:function(){return this.getSelectedInputs();}});exports.ThreadListUI=ThreadListUI;}(this));;(function(global){'use strict';var attachmentMap=new WeakMap();var isEmptyOnBackspace=false;var isHoldingBackspace=false;function thui_mmsAttachmentClick(target){var attachment=attachmentMap.get(target);if(!attachment){return false;}
attachment.view({allowSave:true});return true;}
function thui_generateSmilSlides(slides,content){var length=slides.length;if(typeof content==='string'){if(!length||slides[length-1].text){slides.push({text:content});}else{slides[length-1].text=content;}}else{slides.push({blob:content.blob,name:content.name});}
return slides;}
var ThreadUI=global.ThreadUI={LAST_MESSAGES_BUFFERING_TIME:10*60*1000,CHUNK_SIZE:10,CONVERTED_MESSAGE_DURATION:3000,IMAGE_RESIZE_DURATION:3000,BANNER_DURATION:2000,UPDATE_DELAY:500,LEAVE_ACTIVITY_DELAY:3000,draft:null,recipients:null,inEditMode:false,inThread:false,isNewMessageNoticeShown:false,shouldChangePanelNextEvent:false,inActivity:false,timeouts:{update:null,subjectLengthNotice:null},multiSimActionButton:null,init:function thui_init(){var templateIds=['message','not-downloaded','recipient'];Compose.init('messages-compose-form');AttachmentMenu.init('attachment-options-menu');['container','subheader','to-field','recipients-list','recipient','input','compose-form','check-all-button','uncheck-all-button','contact-pick-button','back-button','send-button','attach-button','delete-button','cancel-button','subject-input','new-message-notice','options-icon','edit-mode','edit-form','tel-form','header-text','max-length-notice','convert-notice','resize-notice','dual-sim-information','new-message-notice','subject-max-length-notice'].forEach(function(id){this[Utils.camelCase(id)]=document.getElementById('messages-'+id);},this);this.mainWrapper=document.getElementById('main-wrapper');this._mozMobileMessage=navigator.mozMobileMessage||window.DesktopMockNavigatormozMobileMessage;window.addEventListener('resize',this.resizeHandler.bind(this));document.addEventListener('visibilitychange',this.onVisibilityChange.bind(this));Compose.on('input',this.messageComposerInputHandler.bind(this));Compose.on('type',this.onMessageTypeChange.bind(this));this.subjectInput.addEventListener('keydown',this.onSubjectKeydown.bind(this));this.subjectInput.addEventListener('keyup',this.onSubjectKeyup.bind(this));this.subjectInput.addEventListener('blur',this.onSubjectBlur.bind(this));this.toField.addEventListener('keypress',this.toFieldKeypress.bind(this),true);this.toField.addEventListener('input',this.toFieldInput.bind(this),true);this.toField.addEventListener('focus',this.toFieldInput.bind(this),true);this.sendButton.addEventListener('mousedown',function mouseDown(event){event.preventDefault();event.target.classList.add('active');});this.sendButton.addEventListener('mouseup',function mouseUp(event){event.target.classList.remove('active');});this.sendButton.addEventListener('mouseout',function mouseOut(event){event.target.classList.remove('active');});this.sendButton.addEventListener('click',this.onSendClick.bind(this));this.sendButton.addEventListener('contextmenu',this.onSendClick.bind(this));this.container.addEventListener('scroll',this.manageScroll.bind(this));this.backButton.addEventListener('click',this.back.bind(this));this.checkAllButton.addEventListener('click',this.toggleCheckedAll.bind(this,true));this.uncheckAllButton.addEventListener('click',this.toggleCheckedAll.bind(this,false));this.cancelButton.addEventListener('click',this.cancelEdit.bind(this));this.optionsIcon.addEventListener('click',this.showOptions.bind(this));this.deleteButton.addEventListener('click',this.delete.bind(this));this.headerText.addEventListener('click',this.onHeaderActivation.bind(this));this.newMessageNotice.addEventListener('click',this.onNewMessageNoticeClick.bind(this));var assimilate=this.assimilateRecipients.bind(this);this.input.addEventListener('focus',assimilate);this.input.addEventListener('click',assimilate);this.attachButton.addEventListener('click',assimilate);this.container.addEventListener('click',this.handleEvent.bind(this));this.container.addEventListener('contextmenu',this.handleEvent.bind(this));this.editForm.addEventListener('submit',this.handleEvent.bind(this));this.composeForm.addEventListener('submit',this.handleEvent.bind(this));this.contactPickButton.addEventListener('mousedown',this.requestContact.bind(this));this.contactPickButton.addEventListener('click',function onClick(event){event.stopPropagation();});navigator.mozContacts.addEventListener('contactchange',this.updateHeaderData.bind(this));this.tmpl=templateIds.reduce(function(tmpls,name){tmpls[Utils.camelCase(name)]=Template('messages-'+name+'-tmpl');return tmpls;},{});this.initRecipients();this.previousHash=null;this.multiSimActionButton=null;this.timeouts.update=null;var inputStyle=window.getComputedStyle(this.input);this.INPUT_MARGIN_TOP=parseInt(inputStyle.getPropertyValue('margin-top'),10);var INPUT_MARGIN_BOTTOM=parseInt(inputStyle.getPropertyValue('margin-bottom'),10);this.INPUT_MARGIN=this.INPUT_MARGIN_TOP+INPUT_MARGIN_BOTTOM;var subjectStyle=window.getComputedStyle(this.subjectInput);this.SUBJECT_MAX_HEIGHT=parseInt(subjectStyle.getPropertyValue('max-height'),10);this.HEADER_HEIGHT=document.querySelector('.view-header').offsetHeight;this.shouldChangePanelNextEvent=false;this.inActivity=false;ThreadUI.updateInputMaxHeight();},onVisibilityChange:function mm_onVisibilityChange(e){if(document.hidden){var hash=window.location.hash;if((hash==='#new'||hash.startsWith('#thread='))&&(!Compose.isEmpty()||ThreadUI.recipients.length)){ThreadUI.saveDraft({preserve:true,autoSave:true});Drafts.store();}}},onBeforeEnter:function thui_onBeforeEnter(){if(!this.multiSimActionButton){this.multiSimActionButton=new MultiSimActionButton(this.sendButton,this.simSelectedCallback.bind(this),Settings.SERVICE_ID_KEYS.smsServiceId);}},initRecipients:function thui_initRecipients(){var recipientsChanged=(function recipientsChanged(length,record){if(this.draft){this.draft.isEdited=true;}
var isOk=true;var strategy;if(record&&(record.isQuestionable||record.isLookupable)){if(record.isQuestionable){isOk=false;}
strategy=record.isLookupable?'searchContact':'exactContact';this[strategy](record.number,this.validateContact.bind(this,record));}
if(isOk){this.updateComposerHeader();this.enableSend();}
this.container.textContent='';}).bind(this);if(this.recipients){this.recipients.length=0;this.recipients.visible('singleline');this.recipients.focus();}else{this.recipients=new Recipients({outer:'messages-to-field',inner:'messages-recipients-list',template:this.tmpl.recipient});this.recipients.on('add',recipientsChanged);this.recipients.on('remove',recipientsChanged);}
this.container.textContent='';},initSentAudio:function thui_initSentAudio(){if(this.sentAudio){return;}
this.sentAudioKey='message.sent-sound.enabled';this.sentAudio=new Audio('/sounds/sent.ogg');this.sentAudio.mozAudioChannelType='notification';this.sentAudioEnabled=false;if(navigator.mozSettings){try{var req=navigator.mozSettings.createLock().get(this.sentAudioKey);req.onsuccess=(function onsuccess(){this.sentAudioEnabled=req.result[this.sentAudioKey];}).bind(this);navigator.mozSettings.addObserver(this.sentAudioKey,(function(e){this.sentAudioEnabled=e.settingValue;}).bind(this));}catch(e){this.sentAudioEnabled=false;}}},enableActivityRequestMode:function thui_enableActivityRequestMode(){this.inActivity=true;var domBackButtonSpan=this.backButton.querySelector('span');domBackButtonSpan.classList.remove('icon-back');domBackButtonSpan.classList.add('icon-close');},resetActivityRequestMode:function thui_resetActivityRequestMode(){this.inActivity=false;var domBackButtonSpan=this.backButton.querySelector('span');domBackButtonSpan.classList.remove('icon-close');domBackButtonSpan.classList.add('icon-back');},getAllInputs:function thui_getAllInputs(){if(this.container){return Array.prototype.slice.call(this.container.querySelectorAll('input[type=checkbox]'));}else{return[];}},getSelectedInputs:function thui_getSelectedInputs(){if(this.container){return Array.prototype.slice.call(this.container.querySelectorAll('input[type=checkbox]:checked'));}else{return[];}},messageComposerInputHandler:function thui_messageInputHandler(event){this.updateSubjectHeight();this.enableSend();if(Compose.type==='sms'){return;}
if(Compose.isResizing){this.resizeNotice.classList.remove('hide');if(this._resizeNoticeTimeout){clearTimeout(this._resizeNoticeTimeout);this._resizeNoticeTimeout=null;}}else{this.updateCounterForMms();if(this.resizeNotice.classList.contains('hide')||this._resizeNoticeTimeout){return;}
this._resizeNoticeTimeout=setTimeout(function hideResizeNotice(){this.resizeNotice.classList.add('hide');this._resizeNoticeTimeout=null;}.bind(this),this.IMAGE_RESIZE_DURATION);}},onSubjectKeydown:function thui_onSubjectKeydown(event){if(event.keyCode===event.DOM_VK_BACK_SPACE){if(!isHoldingBackspace){isEmptyOnBackspace=!this.subjectInput.value.length;}
isHoldingBackspace=true;}else{isHoldingBackspace=false;}},onSubjectKeyup:function thui_onSubjectKeyup(event){if(event.keyCode===event.DOM_VK_BACK_SPACE){if(isEmptyOnBackspace){Compose.toggleSubject();this.updateSubjectHeight();isEmptyOnBackspace=false;}}
isHoldingBackspace=false;Compose.updateType();if(this.subjectInput.value.length===Compose.subjectMaxLength){this.showSubjectMaxLengthNotice();}else{this.hideSubjectMaxLengthNotice();}},onSubjectBlur:function thui_onSubjectBlur(){this.hideSubjectMaxLengthNotice();},showMaxLengthNotice:function thui_showMaxLengthNotice(l10nKey){navigator.mozL10n.localize(this.maxLengthNotice.querySelector('p'),l10nKey);this.maxLengthNotice.classList.remove('hide');},hideMaxLengthNotice:function thui_hideMaxLengthNotice(){this.maxLengthNotice.classList.add('hide');},showSubjectMaxLengthNotice:function thui_showSubjectMaxLengthNotice(){this.subjectMaxLengthNotice.classList.remove('hide');if(this.timeouts.subjectLengthNotice){clearTimeout(this.timeouts.subjectLengthNotice);}
this.timeouts.subjectLengthNotice=setTimeout(this.hideSubjectMaxLengthNotice.bind(this),this.BANNER_DURATION);},hideSubjectMaxLengthNotice:function thui_hideSubjectMaxLengthNotice(){this.subjectMaxLengthNotice.classList.add('hide');this.timeouts.subjectLengthNotice&&clearTimeout(this.timeouts.subjectLengthNotice);},assimilateRecipients:function thui_assimilateRecipients(){var isNew=window.location.hash==='#new';var node=this.recipientsList.lastChild;var typed;if(!isNew||node===null){return;}
Recipients.View.isFocusable=false;this.recipients.visible('singleline');do{if(node.isPlaceholder){typed=node.textContent.trim();if(typed===';'){node.textContent='';break;}
if(typed){this.recipients.add({name:typed,number:typed,source:'manual'});break;}}}while((node=node.previousSibling));},onMessageTypeChange:function thui_onMessageType(event){if(Compose.type==='sms'){this.updateSmsSegmentLimit(function segmentLimitCallback(overLimit){if(overLimit){Compose.type='mms';return;}
this.messageComposerTypeHandler();}.bind(this));}else{this.messageComposerTypeHandler();}},onMessage:function onMessage(message){Threads.set(message.threadId,Thread.create(message));this.appendMessage(message);TimeHeaders.updateAll('header[data-time-update]');},onMessageReceived:function thui_onMessageReceived(message){this.onMessage(message);this.scrollViewToBottom();if(this.isScrolledManually){this.showNewMessageNotice(message);}},onMessageSending:function thui_onMessageReceived(message){if(message.threadId===Threads.currentId){this.onMessage(message);this.forceScrollViewToBottom();}else{if(this.shouldChangePanelNextEvent){window.location.hash='#thread='+message.threadId;this.shouldChangePanelNextEvent=false;}}},onNewMessageNoticeClick:function thui_onNewMessageNoticeClick(event){event.preventDefault();this.hideNewMessageNotice();this.forceScrollViewToBottom();},messageComposerTypeHandler:function thui_messageComposerTypeHandler(){this.updateCounter();var oldType=this.composeForm.dataset.messageType;var type=Compose.type;if(oldType===type){return;}
this.composeForm.dataset.messageType=type;var message='converted-to-'+type;var messageContainer=this.convertNotice.querySelector('p');navigator.mozL10n.localize(messageContainer,message);this.convertNotice.classList.remove('hide');if(this._convertNoticeTimeout){clearTimeout(this._convertNoticeTimeout);}
this._convertNoticeTimeout=setTimeout(function hideConvertNotice(){this.convertNotice.classList.add('hide');}.bind(this),this.CONVERTED_MESSAGE_DURATION);},resizeHandler:function thui_resizeHandler(){if(!this.inEditMode){this.updateInputMaxHeight();this.updateElementsHeight();}
this.scrollViewToBottom();Compose.scrollMessageContent();},requestContact:function thui_requestContact(){this.assimilateRecipients();if(typeof MozActivity==='undefined'){console.log('MozActivity unavailable');return;}
Recipients.View.isFocusable=false;var activity=new MozActivity({name:'pick',data:{type:'webcontacts/tel'}});activity.onsuccess=(function(){if(!activity.result||!activity.result.tel||!activity.result.tel.length||!activity.result.tel[0].value){console.error('The pick activity result is invalid.');return;}
Recipients.View.isFocusable=true;var data=Utils.basicContact(activity.result.tel[0].value,activity.result);data.source='contacts';this.recipients.add(data);}).bind(this);activity.onerror=(function(e){Recipients.View.isFocusable=true;console.log('WebActivities unavailable? : '+e);}).bind(this);},updateComposerHeader:function thui_updateComposerHeader(){var recipientCount=this.recipients.numbers.length;if(recipientCount>0){navigator.mozL10n.localize(this.headerText,'recipient',{n:recipientCount});}else{navigator.mozL10n.localize(this.headerText,'newMessage');}
this.enableSend();},isScrolledManually:false,manageScroll:function thui_manageScroll(oEvent){var scrollTop=this.container.scrollTop;var scrollHeight=this.container.scrollHeight;var clientHeight=this.container.clientHeight;this.isScrolledManually=((scrollTop+clientHeight)<scrollHeight);if(!this.isScrolledManually&&this.isNewMessageNoticeShown){this.hideNewMessageNotice();}
var kEdge=30;if(scrollTop<kEdge){this.showChunkOfMessages(this.CHUNK_SIZE);this.container.scrollTop=(this.container.scrollHeight-scrollHeight)+scrollTop;}},scrollViewToBottom:function thui_scrollViewToBottom(){if(!this.isScrolledManually&&this.container.lastElementChild){this.container.lastElementChild.scrollIntoView(false);}},forceScrollViewToBottom:function thui_forceScrollViewToBottom(){this.isScrolledManually=false;this.scrollViewToBottom();},showNewMessageNotice:function thui_showNewMessageNotice(message){Contacts.findByPhoneNumber(message.sender,(function gotContact(contact){var sender=message.sender;if(contact&&contact.length){var details=Utils.getContactDetails(sender,contact[0]);sender=details.title||sender;var index=sender.indexOf(' ');if(index!==-1){sender=sender.slice(0,index);}}
var notice=this.newMessageNotice;var newMessageContactNode=notice.querySelector('.contact');newMessageContactNode.textContent=sender;this.isNewMessageNoticeShown=true;notice.classList.remove('hide');}).bind(this));},hideNewMessageNotice:function thui_hideNewMessageNotice(){this.isNewMessageNoticeShown=false;this.newMessageNotice.classList.add('hide');},updateInputMaxHeight:function thui_updateInputMaxHeight(){var threadSliverHeight=30;var adjustment=this.subheader.offsetHeight+
this.INPUT_MARGIN+
this.subjectInput.offsetHeight;if(window.location.hash!=='#new'){adjustment+=threadSliverHeight;}
var availableHeight=window.innerHeight-this.HEADER_HEIGHT;var maxHeight=availableHeight-adjustment;this.input.style.maxHeight=maxHeight+'px';generateHeightRule(maxHeight);},leaveActivity:function thui_leaveActivity(){var currentActivity=ActivityHandler.currentActivity.new;if(currentActivity){currentActivity.postResult({success:true});ActivityHandler.resetActivity();}},back:function thui_back(){if(window.location.hash==='#group-view'||window.location.hash.startsWith('#report-view')){window.location.hash='#thread='+Threads.lastId;this.updateHeaderData();return;}
var goBack=(function(){this.stopRendering();var leave=(function(){this.cleanFields(true);window.location.hash='#thread-list';}).bind(this);if(this.inActivity){this.leaveActivity();return;}
this.assimilateRecipients();if(Threads.active){Threads.active.unreadCount=0;}
if(Compose.isEmpty()&&(Threads.active||this.recipients.length===0)){this.discardDraft();leave();return;}
if(this.draft&&!this.draft.isEdited){if(!Threads.currentId){this.saveDraft({autoSave:true});}else{this.draft=null;}
leave();return;}
var prompt='save-as-draft';if(this.draft){prompt='replace-draft';}
var options={items:[{l10nId:prompt,method:function onsave(){this.saveDraft();leave();}.bind(this)},{l10nId:'discard-message',method:function ondiscard(){this.discardDraft();leave();}.bind(this)},{l10nId:'cancel'}]};new OptionMenu(options).show();}).bind(this);if(this.isKeyboardDisplayed()){window.addEventListener('resize',function keyboardHidden(){window.removeEventListener('resize',keyboardHidden);window.clearTimeout(setTimer);goBack();});var setTimer=window.setTimeout(goBack,400);}else{goBack();}},isKeyboardDisplayed:function thui_isKeyboardDisplayed(){return((window.screen.height-window.innerHeight)>150);},enableSend:function thui_enableSend(){this.initSentAudio();var disableSendMessage=Compose.isEmpty()||Compose.isResizing;var messageNotLong=this.updateCounter();var recipientsValue=this.recipients.inputValue;var hasRecipients=false;if(this.recipients&&(this.recipients.numbers.length||(recipientsValue&&isFinite(recipientsValue)))){hasRecipients=true;}
disableSendMessage=disableSendMessage||!messageNotLong;disableSendMessage=disableSendMessage||(window.location.hash=='#new'&&!hasRecipients);this.sendButton.disabled=disableSendMessage;},updateSmsSegmentLimit:function thui_updateSmsSegmentLimit(callback){if(!(this._mozMobileMessage&&this._mozMobileMessage.getSegmentInfoForText)){return false;}
var value=Compose.getText();var kMaxConcatenatedMessages=10;var smsInfoRequest=this._mozMobileMessage.getSegmentInfoForText(value);smsInfoRequest.onsuccess=(function onSmsInfo(event){if(Compose.type!=='sms'){return;}
var smsInfo=event.target.result;var segments=smsInfo.segments;var availableChars=smsInfo.charsAvailableInLastSegment;this.sendButton.dataset.counter=availableChars+'/'+segments;var showCounter=(segments&&(segments>1||availableChars<=20));this.sendButton.classList.toggle('has-counter',showCounter);var overLimit=segments>kMaxConcatenatedMessages;callback(overLimit);}).bind(this);smsInfoRequest.onerror=(function onSmsInfoError(e){this.sendButton.classList.remove('has-counter');}).bind(this);},updateCounter:function thui_updateCount(){if(Compose.type==='mms'){return this.updateCounterForMms();}else{Compose.lock=false;if(this.timeouts.update===null){this.timeouts.update=setTimeout(this.updateCounterForSms.bind(this),this.UPDATE_DELAY);}
return true;}},updateCounterForSms:function thui_updateCounterForSms(){this.timeouts.update=null;this.hideMaxLengthNotice();this.updateSmsSegmentLimit((function segmentLimitCallback(overLimit){if(overLimit){Compose.type='mms';}}).bind(this));return true;},updateCounterForMms:function thui_updateCounterForMms(){this.sendButton.classList.add('has-counter');if(Compose.isResizing){return false;}
if(Settings.mmsSizeLimitation){if(Compose.size>Settings.mmsSizeLimitation){Compose.lock=true;this.showMaxLengthNotice('messages-exceeded-length-text');return false;}else if(Compose.size===Settings.mmsSizeLimitation){Compose.lock=true;this.showMaxLengthNotice('messages-max-length-text');return true;}}
Compose.lock=false;this.hideMaxLengthNotice();return true;},updateSubjectHeight:function thui_updateSubjectHeight(){this.subjectInput.style.height='';this.subjectInput.style.height=Math.min(this.subjectInput.scrollHeight,this.SUBJECT_MAX_HEIGHT)+'px';this.updateInputMaxHeight();this.updateElementsHeight();},updateElementsHeight:function thui_updateElementsHeight(){this.input.style.height='auto';var verticalMargin=this.INPUT_MARGIN;var inputMaxHeight=parseInt(this.input.style.maxHeight,10);var buttonHeight=this.sendButton.offsetHeight;var subjectHeight=this.subjectInput.offsetHeight;var availableHeight=window.innerHeight-this.HEADER_HEIGHT;var minHeight=Math.min(this.input.scrollHeight,inputMaxHeight);var composeHeight=minHeight+verticalMargin+subjectHeight;var dsdsComposeAdjustment=Math.max(buttonHeight-composeHeight,0);composeHeight+=dsdsComposeAdjustment;this.input.style.height=minHeight+'px';this.input.style.marginTop=(subjectHeight+dsdsComposeAdjustment+this.INPUT_MARGIN_TOP)+'px';this.composeForm.style.height=composeHeight+'px';this.container.style.height=(availableHeight-composeHeight)+'px';var buttonOffset=composeHeight-buttonHeight;this.sendButton.style.marginTop=buttonOffset+'px';this.scrollViewToBottom();},findNextContainer:function thui_findNextContainer(container){if(!container){return null;}
var nextContainer=container;do{nextContainer=nextContainer.nextElementSibling;}while(nextContainer&&nextContainer.tagName!=='UL');return nextContainer;},findFirstContainer:function thui_findFirstLastContainer(){var container=this.container.firstElementChild;if(container&&container.tagName!=='UL'){container=this.findNextContainer(container);}
return container;},getMessageContainer:function thui_getMessageContainer(messageTimestamp,hidden){var startOfDayTimestamp=Utils.getDayDate(messageTimestamp);var now=Date.now();var messageContainer,header;var lastMessageDelay=this.LAST_MESSAGES_BUFFERING_TIME;var isLastMessagesBlock=(messageTimestamp>=(now-lastMessageDelay));if(isLastMessagesBlock){messageContainer=document.getElementById('last-messages');if(messageContainer){var oldTimestamp=messageContainer.dataset.timestamp;var oldDayTimestamp=Utils.getDayDate(oldTimestamp);var shouldCreateNewBlock=(oldDayTimestamp!==startOfDayTimestamp)||(oldTimestamp<messageTimestamp-lastMessageDelay);if(shouldCreateNewBlock){messageContainer.id='mc_'+Utils.getDayDate(oldTimestamp);messageContainer.dataset.timestamp=oldDayTimestamp;messageContainer=null;}}}else{messageContainer=document.getElementById('mc_'+startOfDayTimestamp);}
if(messageContainer){header=messageContainer.previousElementSibling;if(messageTimestamp<header.dataset.time){header.dataset.time=messageTimestamp;}
return messageContainer;}
header=document.createElement('header');messageContainer=document.createElement('ul');messageContainer.classList.add('message-list');header.dataset.timeUpdate='repeat';header.dataset.time=messageTimestamp;if(isLastMessagesBlock){var lastContainer=this.container.lastElementChild;if(lastContainer){var lastDay=Utils.getDayDate(lastContainer.dataset.timestamp);if(lastDay===startOfDayTimestamp){header.dataset.timeOnly='true';}}
messageContainer.id='last-messages';messageContainer.dataset.timestamp=messageTimestamp;}else{messageContainer.id='mc_'+startOfDayTimestamp;messageContainer.dataset.timestamp=startOfDayTimestamp;}
if(hidden){header.classList.add('hidden');}else{TimeHeaders.update(header);}
if(isLastMessagesBlock){this.container.appendChild(header);this.container.appendChild(messageContainer);return messageContainer;}
var insertBeforeContainer;var curContainer=this.findFirstContainer();while(curContainer&&+curContainer.dataset.timestamp<startOfDayTimestamp){curContainer=this.findNextContainer(curContainer);}
insertBeforeContainer=curContainer;this.container.insertBefore(messageContainer,insertBeforeContainer?insertBeforeContainer.previousSibling:null);this.container.insertBefore(header,messageContainer);if(insertBeforeContainer){var nextContainerTimestamp=insertBeforeContainer.dataset.timestamp;if(startOfDayTimestamp===Utils.getDayDate(nextContainerTimestamp)){header=insertBeforeContainer.previousElementSibling;header.dataset.timeOnly='true';}}
return messageContainer;},updateCarrier:function thui_updateCarrier(thread,contacts,details){var carrierTag=document.getElementById('contact-carrier');var threadMessages=document.getElementById('thread-messages');var number=thread.participants[0];var wasCarrierTagShown=threadMessages.classList.contains('has-carrier');var isCarrierTagShown=false;var carrierText;if(thread.participants.length===1&&(contacts&&contacts.length)){carrierText=Utils.getCarrierTag(number,contacts[0].tel,details);if(carrierText){carrierTag.textContent=carrierText;isCarrierTagShown=true;threadMessages.classList.add('has-carrier');}else{threadMessages.classList.remove('has-carrier');}}else{threadMessages.classList.remove('has-carrier');}
if(wasCarrierTagShown!==isCarrierTagShown){this.updateInputMaxHeight();this.updateElementsHeight();}},updateHeaderData:function thui_updateHeaderData(callback){var thread,number,others;if(Threads.currentId){thread=Threads.active;}
if(!thread){if(typeof callback==='function'){callback();}
return;}
if(window.location.hash==='#group-view'){return;}
number=thread.participants[0];others=thread.participants.length-1;if(!this._mozMobileMessage&&callback){navigator.mozL10n.localize(this.headerText,'thread-header-text',{name:number,n:others});setTimeout(callback);return;}
this.headerText.dataset.number=number;Contacts.findByPhoneNumber(number,function gotContact(contacts){var details=Utils.getContactDetails(number,contacts);var contactName=details.title||number;this.headerText.dataset.isContact=!!details.isContact;this.headerText.dataset.title=contactName;navigator.mozL10n.localize(this.headerText,'thread-header-text',{name:contactName,n:others});this.updateCarrier(thread,contacts,details);if(typeof callback==='function'){callback();}}.bind(this));},initializeRendering:function thui_initializeRendering(messages,callback){this.cleanFields();this.checkInputs();this.container.innerHTML='';this.readMessages=[];this.messageIndex=0;this._stopRenderingNextStep=false;},stopRendering:function thui_stopRendering(){this._stopRenderingNextStep=true;},showFirstChunk:function thui_showFirstChunk(){ThreadUI.showChunkOfMessages(this.CHUNK_SIZE);TimeHeaders.updateAll('header[data-time-update]');ThreadUI.scrollViewToBottom();},createMmsContent:function thui_createMmsContent(dataArray){var container=document.createDocumentFragment();var scrollViewToBottom=ThreadUI.scrollViewToBottom.bind(ThreadUI);dataArray.forEach(function(messageData){if(messageData.blob){var attachment=new Attachment(messageData.blob,{name:messageData.name});var mediaElement=attachment.render(scrollViewToBottom);container.appendChild(mediaElement);attachmentMap.set(mediaElement,attachment);}
if(messageData.text){var textElement=document.createElement('span');var text=Template.escape(messageData.text);text=LinkHelper.searchAndLinkClickableData(text);textElement.innerHTML=text;container.appendChild(textElement);}});return container;},renderMessages:function thui_renderMessages(threadId,callback){var onMessagesRendered=(function messagesRendered(){if(this.messageIndex<this.CHUNK_SIZE){this.showFirstChunk();}
if(callback){callback();}}).bind(this);function onMessagesDone(){setTimeout(MessageManager.markThreadRead.bind(MessageManager,filter.threadId));}
var onRenderMessage=(function renderMessage(message){if(this._stopRenderingNextStep){return false;}
this.appendMessage(message,true);this.messageIndex++;if(this.messageIndex===this.CHUNK_SIZE){this.showFirstChunk();}
return true;}).bind(this);this.initializeRendering();var filter=new MozSmsFilter();filter.threadId=threadId;var renderingOptions={each:onRenderMessage,filter:filter,invert:false,end:onMessagesRendered,done:onMessagesDone};MessageManager.getMessages(renderingOptions);this.isScrolledManually=false;},_createNotDownloadedHTML:function thui_createNotDownloadedHTML(message,classNames){var messageL10nId='not-downloaded-mms';var downloadL10nId='download';var status=message.deliveryInfo[0].deliveryStatus;var expireFormatted=Utils.date.format.localeFormat(new Date(+message.expiryDate),navigator.mozL10n.get('dateTimeFormat_%x'));var expired=+message.expiryDate<Date.now();if(expired){classNames.push('expired');messageL10nId='expired-mms';}
if(status==='error'){classNames.push('error');}
if(status==='pending'){downloadL10nId='downloading';classNames.push('pending');}
return this.tmpl.notDownloaded.interpolate({messageL10nId:messageL10nId,messageL10nArgs:JSON.stringify({date:expireFormatted}),messageL10nDate:+message.expiryDate,messageL10nDateFormat:'dateTimeFormat_%x',downloadL10nId:downloadL10nId});},shouldShowDeliveryStatus:function thui_shouldShowDeliveryStatus(message){if(message.delivery!=='sent'){return false;}
if(message.type==='mms'){return message.deliveryInfo.every(function(info){return info.deliveryStatus==='success';});}else{return message.deliveryStatus==='success';}},shouldShowReadStatus:function thui_shouldShowReadStatus(message){if(message.delivery!=='sent'||message.type==='sms'||!message.deliveryInfo){return false;}
return message.deliveryInfo.every(function(info){return info.readStatus==='success';});},buildMessageDOM:function thui_buildMessageDOM(message,hidden){var bodyHTML='';var delivery=message.delivery;var isDelivered=this.shouldShowDeliveryStatus(message);var isRead=this.shouldShowReadStatus(message);var messageDOM=document.createElement('li');var classNames=['message',message.type,delivery];var notDownloaded=delivery==='not-downloaded';var attachments=message.attachments;var noAttachment=(message.type==='mms'&&!notDownloaded&&(attachments===null||attachments.length===0));var invalidEmptyContent=(noAttachment&&!message.subject);if(delivery==='received'||notDownloaded){classNames.push('incoming');}else{classNames.push('outgoing');}
if(isDelivered||isRead){classNames.push('delivered');}
if(hidden){classNames.push('hidden');}
if(message.type&&message.type==='mms'&&message.subject){classNames.push('has-subject');}
if(message.type&&message.type==='sms'){var escapedBody=Template.escape(message.body||'');bodyHTML=LinkHelper.searchAndLinkClickableData(escapedBody);}
if(notDownloaded){bodyHTML=this._createNotDownloadedHTML(message,classNames);}
if(invalidEmptyContent){classNames=classNames.concat(['error','invalid-empty-content']);}else if(noAttachment){classNames.push('no-attachment');}
messageDOM.className=classNames.join(' ');messageDOM.id='message-'+message.id;messageDOM.dataset.messageId=message.id;messageDOM.dataset.iccId=message.iccId;messageDOM.innerHTML=this.tmpl.message.interpolate({id:String(message.id),bodyHTML:bodyHTML,subject:String(message.subject)},{safe:['bodyHTML']});navigator.mozL10n.translate(messageDOM);var pElement=messageDOM.querySelector('p');if(invalidEmptyContent){navigator.mozL10n.localize(pElement,'no-attachment-text');}
if(message.type==='mms'&&!notDownloaded&&!noAttachment){SMIL.parse(message,function(slideArray){pElement.appendChild(ThreadUI.createMmsContent(slideArray));});}
return messageDOM;},appendMessage:function thui_appendMessage(message,hidden){var timestamp=+message.timestamp;var messageDOM=document.getElementById('message-'+message.id);if(messageDOM){this.removeMessageDOM(messageDOM);}
messageDOM=this.buildMessageDOM(message,hidden);messageDOM.dataset.timestamp=timestamp;var messageContainer=this.getMessageContainer(timestamp,hidden);if(!messageContainer.firstElementChild){messageContainer.appendChild(messageDOM);}else{var messages=messageContainer.children;var appended=false;for(var i=0,l=messages.length;i<l;i++){if(timestamp<messages[i].dataset.timestamp){messageContainer.insertBefore(messageDOM,messages[i]);appended=true;break;}}
if(!appended){messageContainer.appendChild(messageDOM);}}
if(this.mainWrapper.classList.contains('edit')){this.checkInputs();}},showChunkOfMessages:function thui_showChunkOfMessages(number){var elements=ThreadUI.container.getElementsByClassName('hidden');for(var i=elements.length-1;i>=0;i--){var element=elements[i];element.classList.remove('hidden');if(element.tagName==='HEADER'){TimeHeaders.update(element);}}},cleanForm:function thui_cleanForm(){var inputs=this.allInputs;for(var i=0;i<inputs.length;i++){inputs[i].checked=false;inputs[i].parentNode.parentNode.classList.remove('undo-candidate');}
this.checkInputs();},clear:function thui_clear(){this.initRecipients();},toggleCheckedAll:function thui_select(value){var inputs=this.container.querySelectorAll('input[type="checkbox"]'+
(value?':not(:checked)':':checked'));var length=inputs.length;for(var i=0;i<length;i++){inputs[i].checked=value;this.chooseMessage(inputs[i]);}
this.checkInputs();},showOptions:function thui_showOptions(){var params={header:navigator.mozL10n.get('message'),items:[]};params.items.push({l10nId:Compose.isSubjectVisible?'remove-subject':'add-subject',method:function tSubject(){Compose.toggleSubject();ThreadUI.updateSubjectHeight();}});if(window.location.hash!=='#new'){params.items.push({l10nId:'deleteMessages-label',method:this.startEdit.bind(this)});}
params.items.push({l10nId:'settings',method:function oSettings(){ActivityPicker.openSettings();}});params.items.push({l10nId:'cancel',incomplete:true});new OptionMenu(params).show();},startEdit:function thui_edit(){this.inEditMode=true;this.cleanForm();this.mainWrapper.classList.toggle('edit');this.container.style.height='calc(100% - '+
this.HEADER_HEIGHT+'px - '+
this.editForm.querySelector('menu').offsetHeight+'px)';},deleteUIMessages:function thui_deleteUIMessages(list,callback){if(!Array.isArray(list)){list=[list];}
for(var i=0,l=list.length;i<l;i++){ThreadUI.removeMessageDOM(document.getElementById('message-'+list[i]));}
callback=typeof callback==='function'?callback:function(){};if(!ThreadUI.container.firstElementChild){ThreadListUI.removeThread(Threads.currentId);callback();window.location.hash='#thread-list';}else{var lastMessage=ThreadUI.container.querySelector('ul:last-child li:last-child');var request=MessageManager.getMessage(+lastMessage.dataset.messageId);request.onsuccess=function(){callback();ThreadListUI.updateThread(request.result,{deleted:true});};request.onerror=function(){console.error('Error when updating the list of threads');callback();};}},delete:function thui_delete(){var question=navigator.mozL10n.get('deleteMessages-confirmation');if(window.confirm(question)){WaitingScreen.show();var delNumList=[];var inputs=ThreadUI.selectedInputs;var length=inputs.length;for(var i=0;i<length;i++){delNumList.push(+inputs[i].value);}
MessageManager.deleteMessage(delNumList,function onDeletionDone(){ThreadUI.deleteUIMessages(delNumList,function uiDeletionDone(){ThreadUI.cancelEdit();WaitingScreen.hide();});});}},cancelEdit:function thlui_cancelEdit(){if(this.inEditMode){this.inEditMode=false;this.updateElementsHeight();this.mainWrapper.classList.remove('edit');}},chooseMessage:function thui_chooseMessage(target){if(!target.checked){target.parentNode.parentNode.classList.remove('selected');}else{target.parentNode.parentNode.classList.add('selected');}},checkInputs:function thui_checkInputs(){var selected=this.selectedInputs;var allInputs=this.allInputs;if(selected.length==allInputs.length){this.checkAllButton.disabled=true;}else{this.checkAllButton.disabled=false;}
if(selected.length>0){this.uncheckAllButton.disabled=false;this.deleteButton.classList.remove('disabled');navigator.mozL10n.localize(this.editMode,'selected',{n:selected.length});}else{this.uncheckAllButton.disabled=true;this.deleteButton.classList.add('disabled');navigator.mozL10n.localize(this.editMode,'deleteMessages-title');}},handleMessageClick:function thui_handleMessageClick(evt){var currentNode=evt.target;var elems={};while(currentNode&&currentNode.classList){if(currentNode.classList.contains('bubble')){elems.bubble=currentNode;}else if(currentNode.classList.contains('message')){elems.message=currentNode;}else if(currentNode.classList.contains('pack-end')){elems.packEnd=currentNode;}
currentNode=currentNode.parentNode;}
if(!(elems.message&&elems.bubble)){return;}
if(elems.message.classList.contains('not-downloaded')){if(elems.message.classList.contains('expired')||elems.message.classList.contains('pending')){return;}
this.retrieveMMS(elems.message);return;}
if(elems.message.classList.contains('invalid-empty-content')){return;}
if(elems.message.classList.contains('error')&&elems.packEnd){if(window.confirm(navigator.mozL10n.get('resend-confirmation'))){this.resendMessage(elems.message.dataset.messageId);}
return;}},getMessageBubble:function thui_getMessageContainer(element){var node=element;var bubble;do{if(node.classList.contains('bubble')){bubble=node;}
if(bubble){if(node.dataset&&node.dataset.messageId){return{id:+node.dataset.messageId,node:bubble};}}
if(node.id==='thread-messages'){return null;}}while((node=node.parentNode));return null;},handleEvent:function thui_handleEvent(evt){switch(evt.type){case'click':if(!this.inEditMode){if(!thui_mmsAttachmentClick(evt.target)){this.handleMessageClick(evt);LinkActionHandler.onClick(evt);}
return;}
var input=evt.target.parentNode.querySelector('input');if(input){this.chooseMessage(input);this.checkInputs();}
break;case'contextmenu':evt.preventDefault();evt.stopPropagation();var messageBubble=this.getMessageBubble(evt.target);if(!messageBubble){return;}
var messageId=messageBubble.id;var params={items:[{l10nId:'forward',method:function forwardMessage(messageId){MessageManager.forward={messageId:messageId};window.location.hash='#new';},params:[messageId]},{l10nId:'view-message-report',method:function showMessageReport(messageId){window.location.href='#report-view='+messageId;},params:[messageId]},{l10nId:'delete',method:function deleteMessage(messageId){MessageManager.deleteMessage(messageId,function onDeletionDone(){ThreadUI.deleteUIMessages(messageId);});},params:[messageId]},{l10nId:'cancel'}],type:'action',header:navigator.mozL10n.get('message-options')};if(messageBubble.node.parentNode.classList.contains('error')){params.items.splice(2,0,{l10nId:'resend-message',method:this.resendMessage.bind(this),params:[messageId]});}
var options=new OptionMenu(params);options.show();break;case'submit':evt.preventDefault();break;}},cleanFields:function thui_cleanFields(forceClean){var clean=(function clean(){this.composeForm.dataset.messageType='sms';Compose.clear();this.sendButton.dataset.counter='';this.sendButton.classList.remove('has-counter');if(window.location.hash==='#new'){this.initRecipients();this.updateComposerHeader();}}).bind(this);if(this.previousHash===window.location.hash||this.previousHash==='#new'){if(forceClean){clean();}}else{clean();}
this.enableSend();this.previousHash=window.location.hash;},onSendClick:function thui_onSendClick(){if(Compose.isEmpty()){return;}
this.assimilateRecipients();this.container.classList.remove('hide');},simSelectedCallback:function thui_simSelected(phoneNumber,cardIndex){if(Compose.isEmpty()){return;}
cardIndex=+cardIndex;if(isNaN(cardIndex)){cardIndex=0;}
this.sendMessage({serviceId:cardIndex});},sendMessage:function thui_sendMessage(opts){var serviceId=opts&&opts.serviceId;var messageType=Compose.type;var inComposer=window.location.hash==='#new';var recipients;if(inComposer){if(!this.recipients.length){return;}
recipients=this.recipients.numbers;}else{recipients=Threads.active.participants;}
var next=function next(){this.doSendMessage({content:Compose.getContent(),subject:Compose.getSubject(),messageType:Compose.type,recipients:recipients,serviceId:serviceId,});}.bind(this);if(messageType==='sms'||!Settings.hasSeveralSim()||serviceId===Settings.mmsServiceId){next();}else{this.showMessageError('NonActiveSimCardToSendError',{confirmHandler:next});}},doSendMessage:function thui_sendMessage(opts){var content=opts.content,subject=opts.subject,messageType=opts.messageType,recipients=opts.recipients,serviceId=opts.serviceId===undefined?null:opts.serviceId;var inComposer=window.location.hash==='#new';this.cleanFields(true);if(this.draft){ThreadListUI.removeThread(this.draft.id);Drafts.delete(this.draft);Drafts.store();this.draft=null;}
this.updateHeaderData();this.shouldChangePanelNextEvent=inComposer;if(messageType==='sms'){MessageManager.sendSMS({recipients:recipients,content:content[0],serviceId:serviceId,oncomplete:function onComplete(requestResult){if(!requestResult.hasError){this.onMessageSendRequestCompleted();return;}
var errors={};requestResult.return.forEach(function(result){if(result.success){return;}
if(errors[result.code.name]===undefined){errors[result.code.name]=[result.recipient];}else{errors[result.code.name].push(result.recipient);}});for(var key in errors){this.showMessageError(key,{recipients:errors[key]});}}.bind(this)});if(recipients.length>1){this.shouldChangePanelNextEvent=false;window.location.hash='#thread-list';if(this.inActivity){setTimeout(this.leaveActivity.bind(this),this.LEAVE_ACTIVITY_DELAY);}}}else{var smilSlides=content.reduce(thui_generateSmilSlides,[]);var mmsOpts={recipients:recipients,subject:subject,content:smilSlides,serviceId:serviceId,onsuccess:function(){this.onMessageSendRequestCompleted();}.bind(this),onerror:function onError(error){var errorName=error.name;if(errorName==='NotFoundError'){console.info('The message was deleted or is no longer available.');return;}
this.showMessageError(errorName);}.bind(this)};MessageManager.sendMMS(mmsOpts);}},onMessageSent:function thui_onMessageSent(message){var messageDOM=document.getElementById('message-'+message.id);if(!messageDOM){return;}
messageDOM.classList.remove('sending');messageDOM.classList.add('sent');},onMessageSendRequestCompleted:function thui_onMessageSendRequestCompleted(){if(this.sentAudioEnabled){this.sentAudio.play();}},onMessageFailed:function thui_onMessageFailed(message){var messageDOM=document.getElementById('message-'+message.id);if(messageDOM){if(messageDOM.classList.contains('error')){return;}
messageDOM.classList.remove('sending');messageDOM.classList.add('error');}},onDeliverySuccess:function thui_onDeliverySuccess(message){if(!this.shouldShowDeliveryStatus(message)){return;}
var messageDOM=document.getElementById('message-'+message.id);if(!messageDOM){return;}
messageDOM.classList.add('delivered');},onReadSuccess:function thui_onReadSuccess(message){if(!this.shouldShowReadStatus(message)){return;}
var messageDOM=document.getElementById('message-'+message.id);if(!messageDOM){return;}
messageDOM.classList.add('delivered');},showMessageError:function thui_showMessageOnError(errorName,opts){var dialog=new ErrorDialog(errorName,opts);dialog.show();},removeMessageDOM:function thui_removeMessageDOM(messageDOM){var messagesContainer=messageDOM.parentNode;messagesContainer.removeChild(messageDOM);if(!messagesContainer.firstElementChild){var header=messagesContainer.previousSibling;this.container.removeChild(header);this.container.removeChild(messagesContainer);}},retrieveMMS:function thui_retrieveMMS(messageDOM){var id=+messageDOM.dataset.messageId;var iccId=messageDOM.dataset.iccId;var request=MessageManager.retrieveMMS(id);var button=messageDOM.querySelector('button');messageDOM.classList.add('pending');messageDOM.classList.remove('error');navigator.mozL10n.localize(button,'downloading');request.onsuccess=(function retrieveMMSSuccess(){this.removeMessageDOM(messageDOM);}).bind(this);request.onerror=(function retrieveMMSError(){messageDOM.classList.remove('pending');messageDOM.classList.add('error');navigator.mozL10n.localize(button,'download');var errorCode=(request.error&&request.error.name)?request.error.name:null;if(!navigator.mozSettings){console.error('Settings unavailable');return;}
if(errorCode){this.showMessageError(errorCode,{messageId:id,confirmHandler:function stateResetAndRetry(){var serviceId=Settings.getServiceIdByIccId(iccId);if(serviceId===null){this.showMessageError('NoSimCardError');return;}
messageDOM.classList.add('pending');messageDOM.classList.remove('error');navigator.mozL10n.localize(button,'downloading');Settings.switchMmsSimHandler(serviceId,this.retrieveMMS.bind(this,messageDOM));}.bind(this)});}}).bind(this);},resendMessage:function thui_resendMessage(id){id=+id;var request=MessageManager.getMessage(id);request.onsuccess=(function(){var message=request.result;var messageDOM=document.getElementById('message-'+id);this.removeMessageDOM(messageDOM);MessageManager.resendMessage(message,function(error){if(!error){this.onMessageSendRequestCompleted();}}.bind(this));}).bind(this);},toFieldKeypress:function(event){if(event.keyCode===13||event.keyCode===event.DOM_VK_ENTER){this.container.textContent='';}},toFieldInput:function(event){var typed;if(event.target.isPlaceholder){typed=event.target.textContent.trim();this.searchContact(typed,this.listContacts.bind(this));}
this.enableSend();},exactContact:function thui_searchContact(fValue,handler){Contacts.findExact(fValue,handler.bind(null,fValue));},searchContact:function thui_searchContact(fValue,handler){if(!fValue){this.container.textContent='';return;}
Contacts.findByString(fValue,handler.bind(null,fValue));},validateContact:function thui_validateContact(source,fValue,contacts){var isInvalid=true;var index=this.recipients.length-1;var last=this.recipientsList.lastElementChild;var typed=last&&last.textContent.trim();var isContact=false;var record,tel,length,number,contact;if(index<0){index=0;}
if(contacts&&contacts.length){isInvalid=false;record=contacts[0];length=record.tel.length;if(source.isLookupable&&!source.isQuestionable&&length===1){if(Utils.probablyMatches(record.tel[0].value,fValue)){isContact=true;number=record.tel[0].value;}}else{for(var i=0;i<length;i++){tel=record.tel[i];if(this.recipients.numbers.indexOf(tel.value)===-1){number=tel.value;break;}}
if(typeof number!=='undefined'){isContact=true;}else{isInvalid=true;}}}
if(isContact){this.recipients.remove(index);contact=Utils.basicContact(number,record);contact.source='contacts';this.recipients.add(contact).focus();return;}
if(isInvalid&&contacts.length>1){this.validateContact(source,fValue,contacts.slice(1));return;}
if(!source.isQuestionable&&!length){isInvalid=false;}
source.isInvalid=isInvalid;if(!typed){this.recipients.update(index,source).focus();}},listContacts:function thui_listContacts(fValue,contacts){if(!this.recipients.inputValue){return;}
this.container.textContent='';if(!contacts||!contacts.length){return;}
var ul=document.createElement('ul');ul.classList.add('contact-list');ul.addEventListener('click',function ulHandler(event){event.stopPropagation();event.preventDefault();this.recipients.add(event.target.dataset).focus();ul.removeEventListener('click',ulHandler);}.bind(this));var renderer=ContactRenderer.flavor('suggestion');contacts.forEach(function(contact){renderer.render({contact:contact,input:fValue,target:ul,skip:this.recipients.numbers});},this);this.container.appendChild(ul);},onHeaderActivation:function thui_onHeaderActivation(){var participants=Threads.active&&Threads.active.participants;if(participants&&participants.length>1){window.location.href='#group-view';return;}
if(!Threads.active&&Threads.lastId){return;}
var number=this.headerText.dataset.number;if(this.headerText.dataset.isContact==='true'){this.promptContact({number:number});}else{this.prompt({number:number,isContact:false});}},promptContact:function thui_promptContact(opts){opts=opts||{};var inMessage=opts.inMessage||false;var number=opts.number||'';Contacts.findByPhoneNumber(number,function(results){var isContact=results&&results.length;var contact=results[0];var id;var fragment;if(isContact){id=contact.id;fragment=document.createDocumentFragment();ContactRenderer.flavor('prompt').render({contact:contact,input:number,target:fragment});}
this.prompt({number:number,header:fragment||number,contactId:id,isContact:isContact,inMessage:inMessage});}.bind(this));},prompt:function thui_prompt(opt){function complete(){window.location.href='#thread='+Threads.lastId;}
var thread=Threads.get(Threads.lastId||Threads.currentId);var number=opt.number||'';var email=opt.email||'';var isContact=opt.isContact||false;var inMessage=opt.inMessage||false;var header=opt.header||number||email||'';var items=[];var params,props;params={classes:['contact-prompt'],complete:complete,header:header,items:null};if(email){items.push({l10nId:'sendEmail',method:function oEmail(param){ActivityPicker.email(param);},params:[email]});}else{items.push({l10nId:'call',method:function oCall(param){ActivityPicker.dial(param);},params:[number]});if((thread&&thread.participants.length>1)||inMessage){items.push({l10nId:'sendMessage',method:function oMessage(param){ActivityPicker.sendMessage(param);},params:[number],incomplete:true});}}
params.items=items;if(!isContact){props=[number?{tel:number}:{email:email}];params.items.push({l10nId:'createNewContact',method:function oCreate(param){ActivityPicker.createNewContact(param,ThreadUI.onCreateContact);},params:props},{l10nId:'addToExistingContact',method:function oAdd(param){ActivityPicker.addToExistingContact(param,ThreadUI.onCreateContact);},params:props});}
if(opt.contactId){props=[{id:opt.contactId}];params.items.push({l10nId:'viewContact',method:function oView(param){ActivityPicker.viewContact(param);},params:props});}
params.items.push({l10nId:'cancel',incomplete:true});new OptionMenu(params).show();},onCreateContact:function thui_onCreateContact(){ThreadListUI.updateContactsInfo();if(window.location.hash.substr(0,8)==='#thread='){ThreadUI.updateHeaderData();}},discardDraft:function thui_discardDraft(){if(this.draft){Drafts.delete(this.draft);if(Threads.active){Threads.active.timestamp=Date.now();ThreadListUI.updateThread(Threads.active);}else{ThreadListUI.removeThread(this.draft.id);}
this.draft=null;}},saveDraft:function thui_saveDraft(opts){var content,draft,recipients,subject,thread,threadId,type;content=Compose.getContent();subject=Compose.getSubject();type=Compose.type;if(Threads.active){recipients=Threads.active.participants;threadId=Threads.currentId;}else{recipients=this.recipients.numbers;}
var draftId=this.draft?this.draft.id:null;draft=new Draft({recipients:recipients,content:content,subject:subject,threadId:threadId,type:type,id:draftId});Drafts.add(draft);if(threadId){thread=Threads.active||Threads.get(threadId);thread.timestamp=draft.timestamp;ThreadListUI.updateThread(thread);}else{ThreadListUI.updateThread(draft);}
if(!opts||(opts&&!opts.preserve)){this.draft=null;}
if(!this.draft&&(opts&&opts.preserve)){this.draft=draft;}
if(!opts||(opts&&!opts.autoSave)){ThreadListUI.onDraftSaved();}}};Object.defineProperty(ThreadUI,'allInputs',{get:function(){return this.getAllInputs();}});Object.defineProperty(ThreadUI,'selectedInputs',{get:function(){return this.getSelectedInputs();}});window.confirm=window.confirm;function generateHeightRule(height){var css,index,sheet,sheets,style,tmpl;if(height===generateHeightRule.prev){return false;}
if(!generateHeightRule.sheet){style=document.createElement('style');document.head.appendChild(style);sheets=document.styleSheets;}
sheet=generateHeightRule.sheet||sheets[sheets.length-1];index=generateHeightRule.index||sheet.cssRules.length;tmpl=generateHeightRule.tmpl||Template('height-rule-tmpl');css=tmpl.interpolate({height:String(height)},{safe:['height']});if(generateHeightRule.index){sheet.deleteRule(index);}
sheet.insertRule(css,index);generateHeightRule.prev=height;generateHeightRule.index=index;generateHeightRule.sheet=sheet;generateHeightRule.tmpl=tmpl;return true;}}(this));;'use strict';var Compose=(function(){var placeholderClass='placeholder';var attachmentClass='attachment-container';var slice=Array.prototype.slice;var attachments=new WeakMap();var dom={form:null,message:null,subject:null,sendButton:null,attachButton:null};var handlers={input:[],type:[]};var state={empty:true,maxLength:null,size:null,lastScrollPosition:0,resizing:false,type:'sms'};var subject={isVisible:false,toggle:function sub_toggle(){this.isVisible?this.hide():this.show();},show:function sub_show(){dom.subject.classList.remove('hide');this.isVisible=true;dom.subject.focus();Compose.updateType();onContentChanged();},hide:function sub_hide(){dom.subject.classList.add('hide');this.isVisible=false;dom.message.focus();Compose.updateType();onContentChanged();},clear:function sub_clear(){dom.subject.value='';dom.subject.classList.add('hide');this.isVisible=false;},getContent:function sub_getContent(){return subject.isShowing?dom.subject.value.replace(/\n\s*/g,' '):'';},setContent:function sub_setContent(content){dom.subject.value=content;},getMaxLength:function sub_getMaxLength(){return dom.subject.maxLength;},get isEmpty(){return!dom.subject.value.length;},get isShowing(){return this.isVisible;}};function onContentChanged(duck){if(ThreadUI.draft){ThreadUI.draft.isEdited=true;}
if(duck instanceof Attachment&&duck.type==='img'){return imageAttachmentsHandling();}
var messageHasFrames=!!dom.message.querySelector('iframe');var isEmptyMessage=!dom.message.textContent.length&&!messageHasFrames;var isEmptySubject=subject.isEmpty;if(isEmptyMessage){var brs=dom.message.getElementsByTagName('br');if(brs.length>1){isEmptyMessage=false;}}
var placeholding=dom.message.classList.contains(placeholderClass);if(placeholding&&!isEmptyMessage){dom.message.classList.remove(placeholderClass);}
if(!placeholding&&isEmptyMessage){dom.message.classList.add(placeholderClass);}
if((isEmptyMessage&&!subject.isShowing)||(isEmptyMessage&&subject.isShowing&&isEmptySubject)){compose.disable(true);state.empty=true;}else{compose.disable(false);state.empty=false;}
compose.updateType();trigger.call(compose,'input',new CustomEvent('input'));}
function composeKeyEvents(e){if(compose.lock&&e.which!==8){e.preventDefault();}else{state.size=null;compose.lock=false;}}
function trigger(type){var fns=handlers[type];var args=slice.call(arguments,1);if(fns&&fns.length){for(var i=0;i<fns.length;i++){fns[i].apply(compose,args);}}}
function insert(item){var fragment=document.createDocumentFragment();if(!item){return null;}
state.size=null;if(item.render){var node=item.render();attachments.set(node,item);fragment.appendChild(node);}else if(item.nodeName==='IFRAME'){fragment.appendChild(item);}else if(typeof item==='string'){item.split('\n').forEach(function(line){fragment.appendChild(document.createTextNode(line));fragment.appendChild(document.createElement('br'));});fragment.lastElementChild.remove();}
return fragment;}
function imageAttachmentsHandling(){if(Compose.size<Settings.mmsSizeLimitation){onContentChanged();return;}
var nodes=dom.message.querySelectorAll('iframe');var imgNodes=[];var done=0;Array.prototype.forEach.call(nodes,function findImgNodes(node){var item=attachments.get(node);if(item.type==='img'){imgNodes.push(node);}});var images=imgNodes.length;var limit=images>2?Settings.mmsSizeLimitation*0.2:Settings.mmsSizeLimitation*0.4;function imageSized(){if(++done===images){state.resizing=false;onContentChanged();}}
state.resizing=true;imgNodes.forEach(function(node){var item=attachments.get(node);if(item.blob.size<limit){imageSized();}else{Utils.getResizedImgBlob(item.blob,limit,function(resizedBlob){state.size=null;item.blob=resizedBlob;var newNode=item.render();attachments.set(newNode,item);if(dom.message.contains(node)){dom.message.insertBefore(newNode,node);dom.message.removeChild(node);}
imageSized();});}});onContentChanged();}
var compose={init:function composeInit(formId){dom.form=document.getElementById(formId);dom.message=dom.form.querySelector('[contenteditable]');dom.subject=document.getElementById('messages-subject-input');dom.sendButton=document.getElementById('messages-send-button');dom.attachButton=document.getElementById('messages-attach-button');dom.optionsMenu=document.getElementById('attachment-options-menu');dom.message.addEventListener('input',onContentChanged);dom.subject.addEventListener('input',onContentChanged);dom.message.addEventListener('keydown',composeKeyEvents);dom.message.addEventListener('keypress',composeKeyEvents);dom.message.addEventListener('click',this.onAttachmentClick.bind(this));dom.optionsMenu.addEventListener('click',this.onAttachmentMenuClick.bind(this));dom.attachButton.addEventListener('click',this.onAttachClick.bind(this));this.clearListeners();this.clear();this.on('type',this.onTypeChange);return this;},on:function(type,handler){if(handlers[type]){handlers[type].push(handler);}
return this;},off:function(type,handler){if(handlers[type]){var index=handlers[type].indexOf(handler);if(index!==-1){handlers[type].splice(index,1);}}
return this;},clearListeners:function(){for(var type in handlers){handlers[type]=[];}},getContent:function(){var content=[];var node;for(node=dom.message.firstChild;node;node=node.nextSibling){var attachment=attachments.get(node);if(attachment){content.push(attachment);continue;}
var last=content.length-1;var text=node.textContent;if(text){text=text.replace(/\u00A0/g,' ');}
if(node.nodeName=='BR'){if(node===dom.message.lastChild){continue;}
text='\n';}
if(text.length){if(typeof content[last]==='string'){content[last]+=text;}else{content.push(text);}}}
return content;},getSubject:function(){return subject.getContent();},toggleSubject:function(){subject.toggle();},fromDraft:function(draft){this.clear();if(!draft){return;}
if(draft.subject){dom.subject.value=draft.subject;subject.toggle();}
draft.content.forEach(function(fragment){if(fragment.blob){fragment=new Attachment(fragment.blob,{isDraft:true});}
Compose.append(fragment);},Compose);this.focus();},fromMessage:function(message){this.clear();if(message.type==='mms'){if(message.subject){subject.setContent(message.subject);subject.show();}
SMIL.parse(message,function(elements){elements.forEach(function(element){if(element.blob){var attachment=new Attachment(element.blob,{name:element.name,isDraft:true});this.append(attachment);}
if(element.text){this.append(element.text);}},this);this.ignoreEvents=false;this.focus();}.bind(this));this.ignoreEvents=true;}else{this.append(message.body);this.focus();}},getText:function(){var out=this.getContent().filter(function(elem){return(typeof elem==='string');});return out.join('');},isEmpty:function(){return state.empty;},lock:false,disable:function(state){dom.sendButton.disabled=state;return this;},scrollToTarget:function(target){var targetRect=target.getBoundingClientRect();var containerRect=dom.message.getBoundingClientRect();var offset=(targetRect.top+targetRect.height/2)-
(containerRect.top+containerRect.height/2);dom.message.scrollTop+=offset;},scrollMessageContent:function(){if(document.activeElement===dom.message){var range=window.getSelection().getRangeAt(0);if(range.collapsed){range.insertNode(document.createElement('span'));this.scrollToTarget(range);range.deleteContents();}else{this.scrollToTarget(range);}
state.lastScrollPosition=dom.message.scrollTop;}else{dom.message.scrollTop=state.lastScrollPosition;}},prepend:function(item){var fragment=insert(item);if(!fragment){return this;}
if(dom.message.firstChild&&dom.message.firstChild.nodeName==='BR'){dom.message.insertBefore(fragment,dom.message.childNodes[1]);}else{dom.message.insertBefore(fragment,dom.message.childNodes[0]);}
onContentChanged(item);return this;},append:function(item){var fragment=insert(item);if(!fragment){return this;}
if(document.activeElement===dom.message){var range=window.getSelection().getRangeAt(0);var firstNodes=fragment.firstChild;range.deleteContents();range.insertNode(fragment);this.scrollToTarget(range);dom.message.focus();range.setStartAfter(firstNodes);}else{dom.message.insertBefore(fragment,dom.message.lastChild);this.scrollToTarget(dom.message.lastChild);}
onContentChanged(item);return this;},clear:function(){dom.message.innerHTML='<br>';subject.clear();state.resizing=state.full=false;state.size=0;state.empty=true;onContentChanged();return this;},focus:function(){dom.message.focus();return this;},updateType:function(){if((subject.isShowing&&!subject.isEmpty)||!!dom.message.querySelector('iframe')){this.type='mms';}else{this.type='sms';}},onAttachClick:function thui_onAttachClick(event){var request=this.requestAttachment();request.onsuccess=this.append.bind(this);request.onerror=function(err){if(err==='file too large'){alert(navigator.mozL10n.get('file-too-large'));}};},onAttachmentClick:function thui_onAttachmentClick(event){if(event.target.classList.contains(attachmentClass)&&!state.resizing){this.currentAttachmentDOM=event.target;this.currentAttachment=attachments.get(event.target);AttachmentMenu.open(this.currentAttachment);}},onAttachmentMenuClick:function thui_onAttachmentMenuClick(event){event.preventDefault();switch(event.target.id){case'attachment-options-view':this.currentAttachment.view();break;case'attachment-options-remove':attachments.delete(this.currentAttachmentDOM);dom.message.removeChild(this.currentAttachmentDOM);state.size=null;onContentChanged();AttachmentMenu.close();break;case'attachment-options-replace':var request=this.requestAttachment();request.onsuccess=(function replaceAttachmentWith(newAttachment){var fragment=insert(newAttachment);dom.message.insertBefore(fragment,this.currentAttachmentDOM);dom.message.removeChild(this.currentAttachmentDOM);onContentChanged(newAttachment);AttachmentMenu.close();}).bind(this);request.onerror=function(err){if(err==='file too large'){alert(navigator.mozL10n.get('file-too-large'));}};break;case'attachment-options-cancel':AttachmentMenu.close();break;}},onTypeChange:function c_onTypeChange(){if(this.type==='sms'){dom.message.setAttribute('x-inputmode','-moz-sms');}else{dom.message.removeAttribute('x-inputmode');}},requestAttachment:function(){var requestProxy={};var activityData={type:['image/*','audio/*','video/*']};var activity;if(Settings.mmsSizeLimitation){activityData.maxFileSizeBytes=Settings.mmsSizeLimitation;}
activity=new MozActivity({name:'pick',data:activityData});activity.onsuccess=function(){var result=activity.result;if(Settings.mmsSizeLimitation&&result.blob.size>Settings.mmsSizeLimitation&&Utils.typeFromMimeType(result.blob.type)!=='img'){if(typeof requestProxy.onerror==='function'){requestProxy.onerror('file too large');}
return;}
if(typeof requestProxy.onsuccess==='function'){requestProxy.onsuccess(new Attachment(result.blob,{name:result.name,isDraft:true}));}};activity.onerror=function(){if(typeof requestProxy.onerror==='function'){requestProxy.onerror.apply(requestProxy,arguments);}};return requestProxy;}};Object.defineProperty(compose,'type',{get:function composeGetType(){return state.type;},set:function composeSetType(value){if(!(value==='sms'||value==='mms')){return state.type;}
if(value!==state.type){var event=new CustomEvent('type');state.type=value;trigger.call(this,'type',event);}
return state.type;}});Object.defineProperty(compose,'size',{get:function composeGetSize(){if(state.size===null){state.size=this.getContent().reduce(function(sum,content){if(typeof content==='string'){return sum+content.length;}else{return sum+content.size;}},0);}
return state.size;}});Object.defineProperty(compose,'isResizing',{get:function composeGetResizeState(){return state.resizing;}});Object.defineProperty(compose,'isSubjectVisible',{get:function composeGetResizeState(){return subject.isShowing;}});Object.defineProperty(compose,'subjectMaxLength',{get:function composeGetResizeState(){return subject.getMaxLength();}});Object.defineProperty(compose,'ignoreEvents',{set:function composeIgnoreEvents(value){dom.message.classList.toggle('ignoreEvents',value);}});return compose;}());;'use strict';var WaitingScreen={get loading(){delete this.loading;return(this.loading=document.getElementById('loading'));},get loadingHeader(){delete this.loadingHeader;return(this.loadingHeader=document.getElementById('loading-header'));},show:function ws_show(){this.loading.classList.add('show-loading');},hide:function ws_hide(){this.loading.classList.remove('show-loading');}};;(function(exports){'use strict';var rdashes=/-(.)/g;var rescape=/[.?*+^$[\]\\(){}|-]/g;var rparams=/([^?=&]+)(?:=([^&]*))?/g;var rnondialablechars=/[^,#+\*\d]/g;var downsamplingRefSize={'thumbnail':1080};const l10nIdMap={other:'Other'};var Utils={date:{shared:new Date(),get format(){delete Utils.date.format;return(Utils.date.format=new navigator.mozL10n.DateTimeFormat());}},escapeRegex:function ut_escapeRegex(str){if(typeof str!=='string'){return'';}
return str.replace(rescape,'\\$&');},getFormattedHour:function ut_getFormattedHour(time){this.date.shared.setTime(+time);return this.date.format.localeFormat(this.date.shared,navigator.mozL10n.get('shortTimeFormat'));},getDayDate:function re_getDayDate(time){this.date.shared.setTime(+time);this.date.shared.setHours(0,0,0,0);return this.date.shared.getTime();},getHeaderDate:function ut_giveHeaderDate(time){var _=navigator.mozL10n.get;var today=Utils.getDayDate(Date.now());var otherDay=Utils.getDayDate(time);var dayDiff=(today-otherDay)/86400000;this.date.shared.setTime(+time);if(isNaN(dayDiff)){return _('incorrectDate');}
if(dayDiff<0){return this.date.format.localeFormat(this.date.shared,'%x');}
return dayDiff===0&&_('today')||dayDiff===1&&_('yesterday')||dayDiff<6&&this.date.format.localeFormat(this.date.shared,'%A')||this.date.format.localeFormat(this.date.shared,'%x');},getFontSize:function ut_getFontSize(){if(!this.rootFontSize){var htmlCss=window.getComputedStyle(document.documentElement,null);this.rootFontSize=parseInt(htmlCss.getPropertyValue('font-size'),10);}
return this.rootFontSize;},getContactDetails:function ut_getContactDetails(number,contacts,include){var details={};include=include||{};function updateDetails(contact){var name,phone,carrier,i,length,subscriber,org;name=contact.name[0];org=contact.org&&contact.org[0];length=contact.tel?contact.tel.length:0;phone=length&&contact.tel[0].value?contact.tel[0]:{value:'',type:'',carrier:''};carrier=phone.carrier;subscriber=number.length>7?number.substr(-8):number;for(i=0;i<length;i++){if(contact.tel[i].value.indexOf(subscriber)!==-1){phone=contact.tel[i];carrier=phone.carrier;break;}}
details.isContact=true;if(include.photoURL){var photo=ContactPhotoHelper.getThumbnail(contact);if(photo){details.photoURL=window.URL.createObjectURL(photo);}}
if(name){for(i=0;i<length;i++){var telType=contact.tel[i].type&&contact.tel[i].type.toString();var phoneType=phone.type&&phone.type.toString();if(contact.tel[i].value!==phone.value&&telType===phoneType&&contact.tel[i].carrier===phone.carrier){carrier=phone.value;}}}
details.name=name;details.carrier=carrier||phone.value||'';details.org=details.org||org;if(phone.type){details.carrier=phone.type+' | '+details.carrier;}}
if(!contacts||(Array.isArray(contacts)&&contacts.length===0)){details.title='';}else if(!Array.isArray(contacts)){updateDetails(contacts);details.title=details.name||details.org;}else{for(var i=0,l=contacts.length;i<l;i++){updateDetails(contacts[i]);if(details.name){break;}}
details.title=details.name||details.org;}
return details;},getCarrierTag:function ut_getCarrierTag(input,tels,details){var length=tels.length;var hasDetails=typeof details!=='undefined';var hasUniqueCarriers=true;var hasUniqueTypes=true;var name=hasDetails?details.name:'';var found,tel,type,carrier,value,ending;for(var i=0;i<length;i++){tel=tels[i];if(tel.value&&Utils.probablyMatches(tel.value,input)){found=tel;}
if(carrier&&carrier===tel.carrier){hasUniqueCarriers=false;}
if(type&&type===tel.type[0]){hasUniqueTypes=false;}
carrier=tel.carrier;type=(tel.type&&tel.type[0])||'';}
if(!found){return'';}
type=(found.type&&found.type[0])||'';carrier=(hasUniqueCarriers||hasUniqueTypes)?found.carrier:'';value=carrier||found.value;ending=' | '+(carrier||value);if(hasDetails&&!name&&!carrier){ending='';}
return type+ending;},removeNonDialables:function ut_removeNonDialables(input){return input.replace(rnondialablechars,'');},probablyMatches:function ut_probablyMatches(a,b){var service=navigator.mozPhoneNumberService;if(typeof a!=='string'||typeof b!=='string'){return false;}
if(service&&service.normalize){a=service.normalize(a);b=service.normalize(b);}else{a=Utils.removeNonDialables(a);b=Utils.removeNonDialables(b);}
return a===b||a.slice(-7)===b.slice(-7);},multiRecipientMatch:function ut_multiRecipientMatch(a,b){a=[].concat(a);b=[].concat(b);var blen=b.length;if(a.length!==blen){return false;}
return a.every(function(number){for(var i=0;i<blen;i++){if(Utils.probablyMatches(number,b[i])){return true;}}});},getResizedImgBlob:function ut_getResizedImgBlob(blob,limit,callback){var defaultLimit=295*1024;if(typeof limit==='function'){callback=limit;limit=defaultLimit;}
limit=limit===0?defaultLimit:Math.min(limit,defaultLimit);if(blob.size<limit){setTimeout(function blobCb(){callback(blob);});return;}
var ratio=Math.sqrt(blob.size/limit);Utils.resizeImageBlobWithRatio({blob:blob,limit:limit,ratio:ratio,callback:callback});},resizeImageBlobWithRatio:function ut_resizeImageBlobWithRatio(obj){var blob=obj.blob;var callback=obj.callback;var limit=obj.limit;var ratio=obj.ratio;var qualities=[0.75,0.5,0.25];if(blob.size<limit){setTimeout(function blobCb(){callback(blob);});return;}
var img=document.createElement('img');var url=window.URL.createObjectURL(blob);img.src=url;img.onload=function onBlobLoaded(){window.URL.revokeObjectURL(url);var imageWidth=img.width;var imageHeight=img.height;var targetWidth=imageWidth/ratio;var targetHeight=imageHeight/ratio;var canvas=document.createElement('canvas');canvas.width=targetWidth;canvas.height=targetHeight;var context=canvas.getContext('2d',{willReadFrequently:true});context.drawImage(img,0,0,targetWidth,targetHeight);var level=0;function ensureSizeLimit(resizedBlob){if(resizedBlob.size<limit){callback(resizedBlob);}else{if(level<qualities.length){canvas.toBlob(ensureSizeLimit,'image/jpeg',qualities[level++]);}else{Utils.resizeImageBlobWithRatio({blob:blob,limit:limit,ratio:ratio*2,callback:callback});}}}
canvas.toBlob(ensureSizeLimit,blob.type);};},getDownsamplingSrcUrl:function ut_getDownsamplingSrcUrl(options){var newUrl=options.url;var size=options.size;var ref=downsamplingRefSize[options.type];if(size&&ref){var ratio=Math.min(Math.sqrt(size/ref),16);if(ratio>=2){newUrl+='#-moz-samplesize='+Math.floor(ratio);}}
return newUrl;},camelCase:function ut_camelCase(str){return str.replace(rdashes,function replacer(str,p1){return p1.toUpperCase();});},typeFromMimeType:function ut_typeFromMimeType(mime){var MAX_MIME_TYPE_LENGTH=256;if(typeof mime!=='string'||mime.length>MAX_MIME_TYPE_LENGTH){return null;}
var index=mime.indexOf('/');if(index===-1){return null;}
var mainPart=mime.slice(0,index);switch(mainPart){case'image':return'img';case'video':case'audio':case'text':return mainPart;default:return null;}},params:function(input){var parsed={};input.replace(rparams,function($0,$1,$2){parsed[$1]=$2;});return parsed;},getContactDisplayInfo:function(resolver,phoneNumber,callback){resolver(phoneNumber,function onContacts(contacts){callback(Utils.basicContact(phoneNumber,contacts));});},basicContact:function(number,records,callback){var record;if(Array.isArray(records)){if(records.length>0){record=records[0];}}else if(records!==null){record=records;}
if(!record&&!number){if(typeof callback==='function'){callback(null);}
return;}
var telLength=(record&&record.tel)?record.tel.length:0;var tel;for(var i=0;i<telLength;i++){if(record.tel[i].value===number){tel=record.tel[i];break;}}
if(!tel){tel={type:[''],value:number,carrier:''};}
var details=Utils.getContactDetails(tel,record);var info=Utils.getDisplayObject(details.title||null,tel);return info;},getDisplayObject:function(theTitle,tel){var number=tel.value;var title=theTitle||number;var type=tel.type&&tel.type.length?l10nIdMap[tel.type[0]]||tel.type[0]:'';var carrier=tel.carrier?(tel.carrier+', '):'';var separator=type||carrier?' | ':'';var data={name:title,number:number,type:type,carrier:carrier,separator:separator,nameHTML:'',numberHTML:''};return data;},asyncLoadRevokeURL:function(url){setTimeout(function(){var image=new Image();image.src=url;image.onload=image.onerror=function revokePhotoURL(){window.URL.revokeObjectURL(this.src);};});},closeNotificationsForThread:function ut_closeNotificationsForThread(tid){var threadId=tid?tid:Threads.currentId;if(!threadId){return;}
var targetTag='threadId:'+threadId;return Notification.get({tag:targetTag}).then(function onSuccess(notifications){for(var i=0;i<notifications.length;i++){notifications[i].close();}}).catch(function onError(reason){console.error('Notification.get(tag: '+targetTag+'): ',reason);});}};exports.Utils=Utils;}(this));;(function(exports){'use strict';var updateTimer=null;var TimeHeaders={init:function th_init(){onvisibilityChange();document.addEventListener('visibilitychange',onvisibilityChange);},startScheduler:function th_startScheduler(){var now=Date.now(),nextTimeout=new Date(now+60000);nextTimeout.setSeconds(0);nextTimeout.setMilliseconds(0);this.stopScheduler();updateTimer=setTimeout(function(){this.updateAll('header[data-time-update=repeat]');this.startScheduler();}.bind(this),nextTimeout.getTime()-now);},stopScheduler:function th_stopScheduler(){clearTimeout(updateTimer);},updateAll:function th_updateAll(selector){selector=selector||'[data-time-update]';var elements=document.querySelectorAll(selector),length=elements.length,i;for(i=0;i<length;i++){this.update(elements[i]);}},update:function th_update(header){var ts=header.dataset.time;if(!ts){return;}
var newHeader;if(header.dataset.isThread==='true'){newHeader=Utils.getHeaderDate(ts);}else if(header.dataset.timeOnly==='true'){newHeader=Utils.getFormattedHour(ts);}else{newHeader=Utils.getHeaderDate(ts)+' '+Utils.getFormattedHour(ts);}
if(newHeader!==header.textContent){header.textContent=newHeader;}}};function onvisibilityChange(){if(document.hidden){TimeHeaders.stopScheduler();}
else{TimeHeaders.updateAll();TimeHeaders.startScheduler();}}
exports.TimeHeaders=TimeHeaders;}(this));;(function(exports){'use strict';function tryActivity(opts,onsuccess,onerror){var activity;if(typeof onerror!=='function'){onerror=function(error){console.warn('Unhandled error spawning activity; '+error.message);};}
try{activity=new MozActivity(opts);if(typeof onsuccess==='function'){activity.onsuccess=onsuccess;}
activity.onerror=onerror;}catch(e){onerror.call(activity,e);}}
var ActivityPicker={dial:function ap_call(number,onsuccess,onerror){var params={name:'dial',data:{type:'webtelephony/number',number:number}};tryActivity(params,onsuccess,onerror);},email:function ap_email(email,onsuccess,onerror){var params={name:'new',data:{type:'mail',URI:'mailto:'+email}};tryActivity(params,onsuccess,onerror);},url:function ap_browse(url,onsuccess,onerror){var params={name:'view',data:{type:'url',url:url}};tryActivity(params,onsuccess,onerror);},createNewContact:function ap_createNewContact(contactProps,onsuccess,onerror){var params={name:'new',data:{type:'webcontacts/contact',params:contactProps}};tryActivity(params,onsuccess,onerror);},addToExistingContact:function ap_addToExistingContact(contactProps,onsuccess,onerror){var params={name:'update',data:{type:'webcontacts/contact',params:contactProps}};tryActivity(params,onsuccess,onerror);},viewContact:function ap_viewContact(contactProps,onsuccess,onerror){var params={name:'open',data:{type:'webcontacts/contact',params:contactProps}};tryActivity(params,onsuccess,onerror);},sendMessage:function ap_sendMessage(number){ActivityHandler.toView({number:number});},openSettings:function ap_openSettings(onsuccess,onerror){var params={name:'configure',data:{target:'device',section:'messaging'}};tryActivity(params,onsuccess,onerror);}};exports.ActivityPicker=ActivityPicker;}(this));;'use strict';var WBMP=(function(document){function decode(arrayBuffer,callback){var bytes=new Uint8Array(arrayBuffer);var ptr=0;function readOctet(){return bytes[ptr++]&0xff;}
function readMultiByteInteger(){var result=0;while(true){if(result&0xfe000000){throw'error parsing integer';}
var b=bytes[ptr++];result=(result<<7)|(b&0x7f);if(!(b&0x80)){return result;}}}
function write(data,w,bit){var color=bit?255:0;data[w]=color;data[w+1]=color;data[w+2]=color;data[w+3]=255;}
try{if(readMultiByteInteger()!==0){return false;}
if(readOctet()!==0){return false;}
var width=readMultiByteInteger();var height=readMultiByteInteger();if(width===0||width>65535||height===0||height>65535){return false;}
var canvas=document.createElement('canvas');canvas.setAttribute('width',width);canvas.setAttribute('height',height);var ctx=canvas.getContext('2d',{willReadFrequently:true});var imageData=ctx.createImageData(width,height);var data=imageData.data;for(var y=0;y<height;++y){for(var x=0;x<width;x+=8){var bits=bytes[ptr++];var w=(y*width+x)*4;write(data,w,bits&0x80);write(data,w+4,bits&0x40);write(data,w+8,bits&0x20);write(data,w+12,bits&0x10);write(data,w+16,bits&0x08);write(data,w+20,bits&0x04);write(data,w+24,bits&0x02);write(data,w+28,bits&0x01);}}
if(ptr>bytes.length){return null;}
ctx.putImageData(imageData,0,0);canvas.toBlob(callback);}catch(e){return null;}}
return{decode:decode};})(document);;(function(){'use strict';var unsafeFilenamePattern=/[^a-zA-Z0-9_#.()?&%-]/g;var encoder=new TextEncoder('UTF-8');function SMIL_generateSlides(data,slide,slideIndex){const DURATION=5000;var id;var blobType;var media='';var text='';var name='';if(slide.blob){blobType=Utils.typeFromMimeType(slide.blob.type);if(blobType){name=slide.name.substr(slide.name.lastIndexOf('/')+1);name=name.replace(unsafeFilenamePattern,'#');name=SMIL_generateUniqueLocation(data,name);media='<'+blobType+' src="'+name+'" region="Image"/>';data.attachments.push({id:'<'+name+'>',location:name,content:slide.blob});}}
if(slide.text){id='text_'+slideIndex+'.txt';text='<text src="'+id+'" region="Text"/>';data.attachments.push({id:'<'+id+'>',location:id,content:new Blob([encoder.encode(slide.text)],{type:'text/plain'})});}
data.parts.push('<par dur="'+DURATION+'ms">'+media+text+'</par>');return data;}
function SMIL_generateUniqueLocation(data,location){var extension,name,result;var FILENAME_LIMIT=40;function SMIL_uniqueLocationMatches(attachment){return attachment.location===result;}
var index=location.lastIndexOf('.');if(index===-1){name=location;extension='';}else{extension=location.slice(index);name=location.slice(0,index);}
if(name.length+extension.length>FILENAME_LIMIT){name=name.slice(0,FILENAME_LIMIT-extension.length);}
result=name+extension;var duplicateIndex=2;while(data.attachments.some(SMIL_uniqueLocationMatches)){var truncIndex=0;result=name+'_'+duplicateIndex++ +extension;while(result.length>FILENAME_LIMIT){duplicateIndex=2;name=name.slice(0,--truncIndex);result=name+extension;}}
return result;}
window.SMIL={parse:function SMIL_parse(message,callback){var smil=message.smil;var attachments=message.attachments;var slides=[];var activeReaders=0;var attachmentsNotFound=false;var workingText=[];var doc;var parTags;function readTextBlob(blob,callback){if(!blob){return callback('');}
var textReader=new FileReader();textReader.onload=function(event){activeReaders--;callback(event,event.target.result);};textReader.onerror=function(event){console.error('Error reading text blob');activeReaders--;callback(event,'');};activeReaders++;textReader.readAsText(blob,'UTF-8');}
function exitPoint(){if(!activeReaders){setTimeout(callback.bind(null,slides));}}
function findAttachment(name){var index=0;var length=attachments.length;name=name.replace(/^cid:/,'');for(;index<length;index++){if(attachments[index].location===name||attachments[index].id==='<'+name+'>'){return attachments[index];}}
return null;}
function convertWbmpToPng(slide){var reader;slide.name=slide.name.slice(0,-5)+'.png';reader=new FileReader();reader.onload=function(event){WBMP.decode(event.target.result,function callback(blob){activeReaders--;slide.blob=blob;exitPoint();});};reader.onerror=function(event){activeReaders--;console.error('Error reading text blob');exitPoint();};activeReaders++;reader.readAsArrayBuffer(slide.blob);}
function SMIL_parseWithoutSMIL(attachment){var slide;var textIndex=workingText.length;var blob=attachment.content;if(!blob){return;}
var type=Utils.typeFromMimeType(blob.type);if(type==='text'&&blob.type==='text/plain'){workingText.push('');readTextBlob(blob,function SMIL_parseAttachmentRead(event,text){workingText[textIndex]=text;if(!activeReaders){text=workingText.join(' ');if(slides.length){slides[slides.length-1].text=text;}else{slides.push({text:text});}
exitPoint();}});}else if(type){slide={name:attachment.location,blob:attachment.content};if(slide.name&&slide.name.slice(-5)==='.wbmp'){convertWbmpToPng(slide);}
slides.push(slide);}}
function SMIL_parseHandleParTag(par,index){if(attachmentsNotFound){return;}
var mediaElements=par.querySelectorAll('img, video, audio, ref');var textElement=par.querySelector('text');var attachment,src;Array.prototype.forEach.call(mediaElements,function setSlide(element){var slide={};src=element.getAttribute('src');attachment=findAttachment(src);if(attachment){slide={name:attachment.location,blob:attachment.content};slides.push(slide);if(slide.name&&slide.name.slice(-5)==='.wbmp'){convertWbmpToPng(slide);}}else{attachmentsNotFound=true;}});if(textElement){src=textElement.getAttribute('src');attachment=findAttachment(src);if(attachment){var slide=slides[slides.length-1];if(!slide||typeof slide.text!=='undefined'){slide={};slides.push(slide);}
slide.text='';readTextBlob(attachment.content,function SMIL_parseSMILAttachmentRead(event,text){slide.text=text;exitPoint();});}else{attachmentsNotFound=true;}}}
if(smil){doc=(new DOMParser()).parseFromString(smil,'application/xml');parTags=doc.documentElement.getElementsByTagName('par');Array.prototype.forEach.call(parTags,SMIL_parseHandleParTag);}
if(!smil||attachmentsNotFound||!slides.length){slides=[];attachments.forEach(SMIL_parseWithoutSMIL);}
exitPoint();},generate:function SMIL_generate(slides){const HEADER='<head><layout>'+'<root-layout width="320px" height="480px"/>'+'<region id="Image" left="0px" top="0px"'+' width="320px" height="320px" fit="meet"/>'+'<region id="Text" left="0px" top="320px"'+' width="320px" height="160px" fit="meet"/>'+'</layout></head>';var data=slides.reduce(SMIL_generateSlides,{attachments:[],parts:[]});data.smil='<smil>'+HEADER+'<body>'+
data.parts.join('')+'</body></smil>';delete data.parts;return data;}};})();;(function(){'use strict';var KNOWN_TLDS=['aero','asia','biz','cat','com','coop','info','int','jobs','mobi','museum','name','net','org','post','pro','tel','travel','xxx','edu','gov','mil','nyc','ac','ad','ae','af','ag','ai','al','am','an','ao','aq','ar','as','at','au','aw','ax','az','ba','bb','bd','be','bf','bg','bh','bi','bj','bm','bn','bo','br','bs','bt','bv','no','bw','by','bz','ca','cc','cd','cf','cg','ch','ci','ck','cl','cm','cn','co','cr','cs','cu','cv','cx','cy','cz','dd','de','dj','dk','dm','do','dz','ec','ee','eg','eh','er','es','et','eu','fi','fj','fk','fm','fo','fr','ga','gb','gd','ge','gf','gg','gh','gi','gl','gm','gn','gp','gq','gr','gs','gt','gu','gw','gy','hk','hm','hn','hr','ht','hu','id','ie','il','im','in','io','iq','ir','is','it','je','jm','jo','jp','ke','kg','kh','ki','km','kn','kp','kr','kw','ky','kz','la','lb','lc','li','lk','lr','ls','lt','lu','lv','ly','ma','mc','md','me','mg','mh','mk','ml','mm','mn','mn','mo','mp','mq','mr','ms','mt','mu','mv','mw','mx','my','mz','na','nc','ne','nf','ng','ni','nl','no','np','nr','nu','nz','om','pa','pe','pf','pg','ph','pk','pl','pm','pn','pr','ps','pt','pw','py','qa','re','ro','rs','ru','su','рф','rw','sa','sb','sc','sd','se','sg','sh','si','sj','no','sk','sl','sm','sn','so','sr','ss','st','su','sv','sx','sy','sz','tc','td','tf','tg','th','tj','tk','tl','tp','tm','tn','to','tp','tl','tr','tt','tv','tw','tz','ua','ug','uk','us','gov','uy','uz','va','vc','ve','vg','vi','vn','vu','wf','ws','ye','yt','yu','za','zm','zw'];var ipv4part='(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)';var ipv4RegExp=new RegExp('^(?:'+ipv4part+'\\.){3}'+ipv4part+'$');var leadingDigitsRegExp=/^[+0-9]+/;function checkDomain(domain){if(ipv4RegExp.test(domain)){return true;}else{var parts=domain.split('.');var lastPart=parts[parts.length-1];return lastPart.length>1&&!isFinite(lastPart);}}
var safeStart=/[\s,:;\(>]/;const MINIMUM_DIGITS_IN_PHONE_NUMBER=5;const LEADING_DIGIT_BREAKPOINT=7;var LINK_TYPES={phone:{regexp:new RegExp(['(?:\\+\\d{1,4}[ \\t.()-]{0,3}|\\()?'+'(?:\\d{1,4}[ \\t.()-]{0,3})?'+'(?:\\d[\\d \\t.()-]{0,12}\\d)'+'\\b'].join(''),'g'),matchFilter:function phoneMatchFilter(phone,link){var onlyDigits=Utils.removeNonDialables(phone);if(onlyDigits.length<MINIMUM_DIGITS_IN_PHONE_NUMBER){return false;}
if(onlyDigits.length===MINIMUM_DIGITS_IN_PHONE_NUMBER&&phone.length!==onlyDigits.length){return false;}
var leadingDigits=leadingDigitsRegExp.exec(phone);if(leadingDigits&&leadingDigits[0].length>=LEADING_DIGIT_BREAKPOINT){link.end=link.start+leadingDigits[0].length;}
return link;},transform:function phoneTransform(phone,link){return'<a data-dial="'+phone+'" data-action="dial-link">'+phone+'</a>';}},url:{regexp:new RegExp(['(https?://)?','((?:\\.?[-\\w]){1,256})','(\\.\\w{1,10})','(?::[0-9]{1,5})?','(?:\\.?/','(?:[^\\s.,?:;!]|[.,?:;!](?!\\s|$)){0,2048}',')?'].join(''),'mgi'),matchFilter:function urlMatchFilter(url,linkSpec){var match=linkSpec.match;var scheme,tld;if(!checkDomain(match[2]+match[3])){return false;}
scheme=match[1];tld=match[3]&&match[3].slice(1);if(!scheme&&(!isFinite(tld)&&KNOWN_TLDS.indexOf(tld)===-1)){return false;}
if(url.slice(-1)===')'&&url.indexOf('(')===-1){linkSpec.end--;}
return linkSpec;},transform:function urlTransform(url,linkSpec){var href=url;if(!linkSpec.match[1]){href='http://'+href;}
return'<a data-url="'+href+'" data-action="url-link" >'+url+'</a>';}},email:{regexp:/[\w.+-]+@[\w.-]+\.[a-z.]{2,6}/mgi,transform:function emailTransform(email){return['<a data-email="','" data-action="email-link">','</a>'].join(email);}}};var LINK_TYPES_KEYS=Object.keys(LINK_TYPES);function searchForLinks(type,string){var linkSpecs=[];var spec=LINK_TYPES[type];if(!spec){return linkSpecs;}
var regexp=spec.regexp;var matchFilter=spec.matchFilter;var match,linkSpec;while((match=regexp.exec(string))){var rest=string.slice(match.index-1);if(match.index&&!safeStart.test(rest.charAt(0))){var nextSafe=safeStart.exec(rest);if(nextSafe){regexp.lastIndex=match.index+nextSafe.index;}
continue;}
linkSpec={type:type,start:match.index,length:match[0].length,end:match.index+match[0].length,match:match};if(matchFilter){linkSpec=matchFilter(match[0],linkSpec);}
if(linkSpec){linkSpecs.push(linkSpec);regexp.lastIndex=linkSpec.end;}}
return linkSpecs;}
function linkSort(a,b){return(a.start-b.start)||(b.end-a.end)||(LINK_TYPES_KEYS.indexOf(a.type)-LINK_TYPES_KEYS.indexOf(b.type));}
function removeOverlapping(linkSpecs){linkSpecs.sort(linkSort);for(var index=0;index<linkSpecs.length-1;index++){var end=linkSpecs[index].end;while(linkSpecs[index+1]&&linkSpecs[index+1].start<end){linkSpecs.splice(index+1,1);}}}
var LinkHelper=window.LinkHelper={searchAndLinkUrl:function lh_searchAndLinkUrl(inputText){return LinkHelper.searchAndLinkClickableData(inputText,{url:true});},searchAndLinkEmail:function lh_searchAndLinkEmail(inputText){return LinkHelper.searchAndLinkClickableData(inputText,{email:true});},searchAndLinkPhone:function lh_searchAndLinkPhone(inputText){return LinkHelper.searchAndLinkClickableData(inputText,{phone:true});},searchAndLinkClickableData:function lh_searchAndLinkClickableData(inputText,mode){mode=mode||LINK_TYPES;var linkSpecs=[];var type;for(type in mode){if(mode[type]&&LINK_TYPES[type]){linkSpecs=linkSpecs.concat(searchForLinks(type,inputText));}}
removeOverlapping(linkSpecs);var result='';var lastEnd=0;linkSpecs.forEach(function replaceLink(link){result+=inputText.slice(lastEnd,link.start);var replacing=inputText.slice(link.start,link.end);var replaceWith=LINK_TYPES[link.type].transform(replacing,link);result+=replaceWith;lastEnd=link.end;});result+=inputText.slice(lastEnd);return result;}};})();;'use strict';var OptionMenu=function(options){if(!options||!options.items||options.items.length===0){return;}
var handlers=new WeakMap();var items=options.items;this.form=document.createElement('form');this.form.dataset.type=options.type||'action';this.form.setAttribute('role','dialog');this.form.tabIndex=-1;var classList=this.form.classList;if(options.classes){classList.add.apply(classList,options.classes);}
if(options.header){var header=document.createElement('header');if(typeof options.header==='string'){header.textContent=options.header||'';}else{header.appendChild(options.header);}
this.form.appendChild(header);}
if(options.section){var section=document.createElement('section');if(typeof options.section==='string'){section.textContent=options.section||'';}else{section.appendChild(options.section);}
this.form.appendChild(section);}
var menu=document.createElement('menu');menu.dataset.items=items.length;items.forEach(function renderOption(item){var button=document.createElement('button');if(item.l10nId){navigator.mozL10n.localize(button,item.l10nId,item.l10nArgs);}else if(item.name&&item.name.length){button.textContent=item.name||'';}else{return;}
menu.appendChild(button);item.incomplete=item.incomplete||false;handlers.set(button,item);});this.form.addEventListener('submit',function(event){event.preventDefault();});menu.addEventListener('click',function(event){var action=handlers.get(event.target);var method;if(typeof action!=='undefined'){method=action.method||function(){};method.apply(null,action.params||[]);this.hide();if(typeof options.complete==='function'&&!action.incomplete){options.complete();}}}.bind(this));this.form.appendChild(menu);};OptionMenu.prototype.show=function(){navigator.mozL10n.translate(this.form);document.body.appendChild(this.form);this.form.focus();};OptionMenu.prototype.hide=function(){document.body.removeChild(this.form);};;(function(exports){'use strict';var inProgress=false;var LinkActionHandler={onClick:function lah_onClick(event){event.preventDefault();event.stopPropagation();var dataset=event.target.dataset;var action=dataset.action;if(!action){return;}
if(action==='email-link'){ThreadUI.prompt({email:dataset.email,inMessage:true});}
if(action==='dial-link'){ThreadUI.promptContact({number:dataset.dial,inMessage:true});}
if(action==='url-link'){if(inProgress){return;}
inProgress=true;var type=action.replace('-link','');ActivityPicker[type](dataset[type],this.reset,this.reset);}},reset:function lah_reset(){inProgress=false;}};exports.LinkActionHandler=LinkActionHandler;}(this));;'use strict';var Settings={SERVICE_ID_KEYS:{mmsServiceId:'ril.mms.defaultServiceId',smsServiceId:'ril.sms.defaultServiceId'},MMS_SIZE_OVERHEAD:5*1024,_serviceIds:null,mmsSizeLimitation:295*1024,mmsServiceId:null,smsServiceId:null,init:function settings_init(){var keyHandlerSet={'dom.mms.operatorSizeLimitation':this.initMmsSizeLimitation.bind(this)};var settings=navigator.mozSettings;var conns=navigator.mozMobileConnections;function setHandlerMap(key){var req=settings.createLock().get(key);req.onsuccess=function settings_getSizeSuccess(){var handler=keyHandlerSet[key];handler(req.result[key]);};}
this._serviceIds=[];if(!settings){return;}
if(conns&&conns.length>1){for(var prop in this.SERVICE_ID_KEYS){var setting=this.SERVICE_ID_KEYS[prop];keyHandlerSet[setting]=this.initServiceId.bind(this,setting,prop);}
for(var i=0,l=conns.length;i<l;i++){this._serviceIds.push(conns[i].iccId);}}
for(var key in keyHandlerSet){setHandlerMap(key);}},initMmsSizeLimitation:function initMmsSizeLimitation(size){if(size&&!isNaN(size)){this.mmsSizeLimitation=size-this.MMS_SIZE_OVERHEAD;}},initServiceId:function initMmsServiceId(settingName,propName,id){if(id!==undefined){Settings[propName]=id;}
navigator.mozSettings.addObserver(settingName,function(e){Settings[propName]=e.settingValue;});},setMmsSimServiceId:function setSimServiceId(id){navigator.mozSettings.createLock().set({'ril.mms.defaultServiceId':id,'ril.data.defaultServiceId':id});},switchMmsSimHandler:function switchSimHandler(targetId,callback){var conn=window.navigator.mozMobileConnections[targetId];if(conn&&conn.data.state!=='registered'){conn.addEventListener('datachange',function onDataChange(){if(conn.data.state==='registered'){conn.removeEventListener('datachange',onDataChange);callback();}});this.setMmsSimServiceId(targetId);}},isDualSimDevice:function isDualSimDevice(){return this._serviceIds&&this._serviceIds.length>1;},hasSeveralSim:function hasSeveralSim(){if(!this.isDualSimDevice()){return false;}
var simCount=this._serviceIds.reduce(function(simCount,iccId){return iccId===null?simCount:simCount+1;},0);return simCount>1;},getServiceIdByIccId:function getServiceIdByIccId(iccId){if(!this._serviceIds){return null;}
var index=this._serviceIds.indexOf(iccId);return index>-1?index:null;},getSimNameByIccId:function getSimNameByIccId(iccId){var index=this.getServiceIdByIccId(iccId);if(index===null){return'';}
var simName=navigator.mozL10n.get('sim-name',{id:index+1});return simName;},getOperatorByIccId:function getOperatorByIccId(iccId){var index=this.getServiceIdByIccId(iccId);if(index===null){return'';}
var conn=navigator.mozMobileConnections[index];return MobileOperator.userFacingInfo(conn).operator;}};;(function(exports){'use strict';function entry(key,value){settings[key]=urls[key]?urls[key].set(value):value;}
var mozSettings=navigator.mozSettings;var settings={};var urls={'notification.ringtone':new SettingsURL()};['audio.volume.notification','notification.ringtone','vibration.enabled'].forEach(function(key){if(mozSettings){var request=mozSettings.createLock().get(key);request.onsuccess=function(){entry(key,request.result[key]);};mozSettings.addObserver(key,function(event){entry(key,event.settingValue);});}});function ringtone(ringtoneFile){var ringtonePlayer=new Audio();ringtonePlayer.src=ringtoneFile;ringtonePlayer.mozAudioChannelType='notification';ringtonePlayer.play();window.setTimeout(function smsRingtoneEnder(){ringtonePlayer.pause();ringtonePlayer.removeAttribute('src');ringtonePlayer.load();},2000);}
function vibrate(){if(document.hidden){window.addEventListener('visibilitychange',function waitOn(){window.removeEventListener('visibilitychange',waitOn);navigator.vibrate([200,200,200,200]);});}else{navigator.vibrate([200,200,200,200]);}}
var Notify={ringtone:function notification_ringtone(){if(settings['audio.volume.notification']&&settings['notification.ringtone']){ringtone(settings['notification.ringtone']);}},vibrate:function notification_vibrate(){if(settings['vibration.enabled']){vibrate();}}};exports.Notify=Notify;}(this));;'use strict';var ActivityHandler={isLocked:false,currentActivity:{new:null},init:function(){if(!window.navigator.mozSetMessageHandler){return;}
window.navigator.mozSetMessageHandler('activity',this.global.bind(this));if(!window.location.hash.length){window.navigator.mozSetMessageHandler('sms-received',this.onSmsReceived.bind(this));window.navigator.mozSetMessageHandler('notification',this.onNotification.bind(this));}},global:function activityHandler(activity){var name=activity.source.name;var handler=this._handlers[name];if(typeof handler==='function'){handler.apply(this,arguments);}else{console.error('Unrecognized activity: "'+name+'"');}},_handlers:{'new':function newHandler(activity){if(this.isLocked){return;}
this.currentActivity.new=activity;this.isLocked=true;var number=activity.source.data.number;var body=activity.source.data.body;Contacts.findByPhoneNumber(number,function findContact(results){var record,details,name,contact;if(results&&results.length){record=results[0];details=Utils.getContactDetails(number,record);name=record.name.length&&record.name[0];contact={number:number,name:name,source:'contacts'};}
ActivityHandler.toView({body:body,number:number,contact:contact||null});});ThreadUI.enableActivityRequestMode();},share:function shareHandler(activity){var blobs=activity.source.data.blobs,names=activity.source.data.filenames;function insertAttachments(){window.removeEventListener('hashchange',insertAttachments);blobs.forEach(function(blob,idx){var attachment=new Attachment(blob,{name:names[idx],isDraft:true});Compose.append(attachment);});}
if(window.location.hash!=='#new'){window.addEventListener('hashchange',insertAttachments);window.location.hash='#new';}else{insertAttachments();}}},resetActivity:function ah_resetActivity(){this.currentActivity.new=null;ThreadUI.resetActivityRequestMode();},handleMessageNotification:function ah_handleMessageNotification(message){if(!message){return;}
var request=navigator.mozMobileMessage.getMessage(message.id);request.onsuccess=function onsuccess(){if(!Compose.isEmpty()){if(window.confirm(navigator.mozL10n.get('discard-new-message'))){ThreadUI.cleanFields(true);}else{return;}}
ActivityHandler.toView(message);};request.onerror=function onerror(){alert(navigator.mozL10n.get('deleted-sms'));};},displayUnsentConfirmation:function ah_displayUnsentConfirmtion(activity){var msgDiv=document.createElement('div');msgDiv.innerHTML='<h1 data-l10n-id="unsent-message-title"></h1>'+'<p data-l10n-id="unsent-message-description"></p>';var options=new OptionMenu({type:'confirm',section:msgDiv,items:[{l10nId:'unsent-message-option-edit',method:function editOptionMethod(){MessageManager.activity=null;}},{l10nId:'unsent-message-option-discard',method:this.launchComposer.bind(this),params:[activity]}]});options.show();},launchComposer:function ah_launchComposer(activity){if(location.hash==='#new'){MessageManager.handleActivity(activity);}else{MessageManager.activity=activity;window.location.hash='#new';}},triggerNewMessage:function ah_triggerNewMessage(body,number,contact){var activity={body:body||null,number:number||null,contact:contact||null};if(Compose.isEmpty()){this.launchComposer(activity);}else{ActivityHandler.displayUnsentConfirmation(activity);}},toView:function ah_toView(message){if(!message){return;}
this.isLocked=false;var threadId=message.threadId?message.threadId:null;var body=message.body?Template.escape(message.body):'';var number=message.number?message.number:'';var contact=message.contact?message.contact:null;var threadHash='#thread='+threadId;var showAction=function act_action(){var locationHash=window.location.hash;if(!threadId){ActivityHandler.triggerNewMessage(body,number,contact);return;}
switch(locationHash){case'#thread-list':case'#new':window.location.hash=threadHash;break;default:if(locationHash.indexOf('#thread=')!==-1){if(locationHash!==threadHash){MessageManager.activity={threadId:threadId};window.location.hash='#thread-list';}}else{window.location.hash=threadHash;}
break;}};if(!document.documentElement.lang){navigator.mozL10n.ready(function waitLocalized(){showAction();});}else{if(!document.hidden){showAction();return;}
document.addEventListener('visibilitychange',function waitVisibility(){document.removeEventListener('visibilitychange',waitVisibility);showAction();});}},onSmsReceived:function ah_onSmsReceived(message){var _=navigator.mozL10n.get;var wakeLock=navigator.requestWakeLock('cpu');var wakeLockReleased=false;var timeoutID=null;function releaseWakeLock(){if(timeoutID!==null){clearTimeout(timeoutID);timeoutID=null;}
if(!wakeLockReleased){wakeLockReleased=true;wakeLock.unlock();}}
timeoutID=setTimeout(releaseWakeLock,30*1000);var number=message.sender;var threadId=message.threadId;var id=message.id;if(message.messageClass==='class-0'){navigator.mozApps.getSelf().onsuccess=function(event){var app=event.target.result;var iconURL=NotificationHelper.getIconURI(app);iconURL+='?type=class0';MessageManager.deleteMessage(message.id,function(){app.launch();Notify.ringtone();Notify.vibrate();alert(number+'\n'+message.body);releaseWakeLock();});};return;}
if(BlackList.has(message.sender)){releaseWakeLock();return;}
function dispatchNotification(needManualRetrieve){if(!document.hidden){if(threadId===Threads.currentId){navigator.vibrate([200,200,200]);releaseWakeLock();return;}}
navigator.mozApps.getSelf().onsuccess=function(evt){var app=evt.target.result;var iconURL=NotificationHelper.getIconURI(app);iconURL+='?';iconURL+=['threadId='+threadId,'number='+encodeURIComponent(number),'id='+id].join('&');function goToMessage(){app.launch();ActivityHandler.handleMessageNotification(message);}
function continueWithNotification(sender,body){var title=sender;if(Settings.hasSeveralSim()&&message.iccId){var simName=Settings.getSimNameByIccId(message.iccId);title=_('dsds-notification-title-with-sim',{sim:simName,sender:sender});}
var options={icon:iconURL,body:body,tag:'threadId:'+threadId};var notification=new Notification(title,options);notification.addEventListener('click',goToMessage);releaseWakeLock();if(document.hidden&&threadId===Threads.currentId){document.addEventListener('visibilitychange',function onVisible(){document.removeEventListener('visibilitychange',onVisible);notification.close();});}}
function getTitleFromMms(callback){if(needManualRetrieve){setTimeout(function notDownloadedCb(){callback(_('notDownloaded-title'));});}
else if(message.subject){setTimeout(function subjectCb(){callback(message.subject);});}else{SMIL.parse(message,function slideCb(slideArray){var text,slidesLength=slideArray.length;for(var i=0;i<slidesLength;i++){if(!slideArray[i].text){continue;}
text=slideArray[i].text;break;}
text=text?text:_('mms-message');callback(text);});}}
Contacts.findByPhoneNumber(message.sender,function gotContact(contact){var sender=message.sender;if(!contact){console.error('We got a null contact for sender:',sender);}else if(contact.length&&contact[0].name&&contact[0].name.length&&contact[0].name[0]){sender=contact[0].name[0];}
if(message.type==='sms'){continueWithNotification(sender,message.body);}else{getTitleFromMms(function textCallback(text){continueWithNotification(sender,text);});}});};}
if(message.type==='sms'){dispatchNotification();}else{var status=message.deliveryInfo[0].deliveryStatus;if(status==='pending'){return;}
dispatchNotification(status!=='success');}},onNotification:function ah_onNotificationClick(message){var params=Utils.params(message.imageURL);if(!message.clicked){return;}
navigator.mozApps.getSelf().onsuccess=function(event){var app=event.target.result;app.launch();if(params.type==='class0'){alert(message.title+'\n'+message.body);return;}
ActivityHandler.handleMessageNotification({id:params.id,threadId:params.threadId});};}};;'use strict';(function(exports){var FLAVORS={suggestion:{renderAll:true,shouldHighlight:true,templates:{main:'contact-suggestion-tmpl'}},prompt:{renderAll:false,shouldHighlight:false,templates:{main:'contact-prompt-tmpl',photo:'contact-photo-tmpl'}},'group-view':{renderAll:false,shouldHighlight:false,templates:{main:'contact-suggestion-tmpl',photo:'contact-photo-tmpl'}}};var templates={};function getTemplate(id){if(!templates[id]){templates[id]=Template(id);}
return templates[id];}
var highlightTemplateId='contact-highlight-tmpl';function highlight(escapedData,regexpArray){var matchFound;var template=getTemplate(highlightTemplateId);function loopReplaceFn(match){matchFound=true;return template.interpolate({str:match},{safe:['str']});}
var splitData=escapedData.split(/\s+/);for(var i=0;i<splitData.length;i++){matchFound=false;for(var k=0;!matchFound&&k<regexpArray.length;k++){splitData[i]=splitData[i].replace(regexpArray[k],loopReplaceFn);}}
return splitData.join(' ');}
var ContactRenderer=exports.ContactRenderer=function constructor(opts){if(!opts){throw new Error('ContactRenderer constructor needs an options object');}
this.opts=opts;this.templates={};for(var key in opts.templates){var id=opts.templates[key];this.templates[key]=Template(id);}
if(this.templates.photo){this.opts.renderPhoto=true;}};ContactRenderer.prototype={render:function cr_render(renderOpts){var contact=renderOpts.contact;var input=renderOpts.input;input=input&&input.trim();var target=renderOpts.target;var shouldHighlight=this.opts.shouldHighlight;var renderAll=this.opts.renderAll;var renderPhoto=this.opts.renderPhoto;var skip=renderOpts.skip||[];var block=renderOpts.infoBlock;var parentSelector=renderOpts.infoBlockParentSelector;if(!contact){return false;}
if(!contact.tel||!contact.tel.length){return false;}
var escaped=Utils.escapeRegex(Template.escape(input));var escsubs=escaped.split(/\s+/);var regexps={name:escsubs.map(function(k){return new RegExp('^'+k,'gi');}),number:escsubs.map(function(k){return new RegExp(k,'ig');})};var include=renderPhoto?{photoURL:true}:null;var tels=contact.tel;var details=Utils.getContactDetails(tels[0].value,contact,include);var tempDiv=document.createElement('div');tels.forEach(function(current){if(!renderAll&&!Utils.probablyMatches(current.value,input)){return;}
if(renderAll&&skip.indexOf(current.value)>-1){return;}
var data=Utils.getDisplayObject(details.title,current);['name','number'].forEach(function(key){var escapedData=Template.escape(data[key]);if(shouldHighlight){escapedData=highlight(escapedData,regexps[key]);}
data[key+'HTML']=escapedData;});if(renderPhoto&&details.photoURL){data.photoHTML=this.templates.photo.interpolate({photoURL:details.photoURL});Utils.asyncLoadRevokeURL(details.photoURL);}else{data.photoHTML='';}
tempDiv.innerHTML=this.templates.main.interpolate(data,{safe:['nameHTML','numberHTML','srcAttr','photoHTML']});var element=tempDiv.firstElementChild;var blockParent=element.querySelector(parentSelector);if(blockParent){blockParent.appendChild(block);}
navigator.mozL10n.translate(element);target.appendChild(element);tempDiv.textContent='';},this);return true;}};ContactRenderer.flavor=function(flavor){return new ContactRenderer(FLAVORS[flavor]);};})(window);;(function(exports){'use strict';var TMPL=function createTemplate(tmpls){for(var key in tmpls){tmpls[key]=Template(tmpls[key]);}
return tmpls;}({number:'messages-number-tmpl',report:'information-report-tmpl'});function completeLocaleFormat(timestamp){return Utils.date.format.localeFormat(new Date(+timestamp),navigator.mozL10n.get('report-dateTimeFormat'));}
function l10nContainsDateSetup(element,timestamp){element.dataset.l10nDate=timestamp;element.dataset.l10nDateFormat='report-dateTimeFormat';element.textContent=completeLocaleFormat(timestamp);}
function createReportDiv(reports){var reportDiv=document.createElement('div');var data={deliveryClass:'',deliveryL10n:'',deliveryDateL10n:'',deliveryTimestamp:'',readClass:'',readL10n:'',readDateL10n:'',readTimestamp:''};switch(reports.deliveryStatus){case'pending':data.deliveryL10n='message-requested';break;case'success':data.deliveryTimestamp=''+reports.deliveryTimestamp;data.deliveryDateL10n=completeLocaleFormat(reports.deliveryTimestamp);break;case'error':data.deliveryL10n='message-status-error';break;default:data.deliveryClass='hide';}
switch(reports.readStatus){case'pending':data.readL10n='message-requested';break;case'success':data.readTimestamp=''+reports.readTimestamp;data.readDateL10n=completeLocaleFormat(reports.readTimestamp);break;case'error':data.readL10n='message-status-error';break;default:data.readClass='hide';}
reportDiv.innerHTML=TMPL.report.interpolate(data);return reportDiv;}
function showSimInfo(element,iccId){var iccManager=navigator.mozIccManager;if(!(Settings.hasSeveralSim()&&iccId&&iccManager)){return;}
var info=[];var simId=Settings.getSimNameByIccId(iccId);var operator=Settings.getOperatorByIccId(iccId);var number=iccManager.getIccById(iccId).iccInfo.msisdn;info=[simId,operator,number].filter(function(value){return value;});element.querySelector('.sim-detail').textContent=info.join(', ');element.classList.remove('hide');}
function sizeL10nParam(attachments){var l10nId,l10nArgs;var size=attachments.reduce(function(size,attachment){return(size+=attachment.content.size);},0);var sizeKB=size/1024;if(sizeKB<1000){l10nId='attachmentSize';l10nArgs={n:sizeKB.toFixed(1)};}else{l10nId='attachmentSizeMB';l10nArgs={n:(sizeKB/1024).toFixed(1)};}
return{l10nId:l10nId,l10nArgs:l10nArgs};}
function createListWithMsgInfo(message){var list=[];if(message.delivery==='received'||message.delivery==='not-downloaded'){list.push(message.sender);}else if(message.type==='mms'){message.deliveryInfo.forEach(function(info){list.push({number:info.receiver,infoBlock:createReportDiv(info)});});}else{var info={};info.deliveryStatus=message.deliveryStatus;info.deliveryTimestamp=message.deliveryTimestamp;list.push({number:message.receiver,infoBlock:createReportDiv(info)});}
return list;}
var VIEWS={group:{name:'participants',render:function renderGroup(){var lastId=Threads.lastId;var participants=lastId&&Threads.get(lastId).participants;this.renderContactList(participants);navigator.mozL10n.localize(ThreadUI.headerText,'participant',{n:participants.length});},elements:['contact-list']},report:{name:'report',render:function renderReport(){var localize=navigator.mozL10n.localize;var messageId=+window.location.hash.split('=')[1];var request=MessageManager.getMessage(messageId);request.onsuccess=(function(){var message=request.result;var type=message.type;var isIncoming=message.delivery==='received'||message.delivery==='not-downloaded';this.subject.textContent='';if(type==='sms'){localize(this.type,'message-type-sms');this.sizeBlock.classList.add('hide');}else{localize(this.type,'message-type-mms');var subject=message.subject;if(subject){this.subject.textContent=subject;}
if(message.attachments&&message.attachments.length>0){var params=sizeL10nParam(message.attachments);localize(this.size,params.l10nId,params.l10nArgs);this.sizeBlock.classList.remove('hide');}else{this.sizeBlock.classList.add('hide');}}
this.status.dataset.type=message.delivery;localize(this.status,'message-status-'+message.delivery);this.container.classList.toggle('received',isIncoming);this.container.classList.toggle('no-valid-sent-timestamp',isIncoming&&!message.sentTimestamp);localize(this.contactTitle,isIncoming?'report-from':'report-recipients');if(isIncoming){l10nContainsDateSetup(this.receivedTimeStamp,message.timestamp);l10nContainsDateSetup(this.sentTimeStamp,message.sentTimestamp);}else{l10nContainsDateSetup(this.datetime,message.timestamp);}
showSimInfo(this.simInfo,message.iccId);this.renderContactList(createListWithMsgInfo(message));}).bind(this);localize(ThreadUI.headerText,'message-report');},elements:['contact-list','status','size','size-block','sent-detail','type','subject','datetime','contact-title','received-detail','sent-timeStamp','received-timeStamp','sim-info']}};var Information=function(type){var view=VIEWS[type];var prefix='information-'+view.name;this.container=document.getElementById(prefix);this.render=view.render;this.parent=document.getElementById('thread-messages');view.elements.forEach(function(name){this[Utils.camelCase(name)]=this.container.querySelector('.'+name);},this);this.reset();if(this.contactList){this.contactList.addEventListener('click',function onListClick(event){event.stopPropagation();event.preventDefault();var target=event.target;ThreadUI.promptContact({number:target.dataset.number});});}};Information.prototype={constructor:Information,show:function(){this.parent.classList.add('information');this.render();this.container.classList.remove('hide');},refresh:function(){if(this.parent.classList.contains('information')){this.render();}},reset:function(){this.container.classList.add('hide');if(this.contactList){this.contactList.textContent='';}
this.parent.classList.remove('information');},renderContactList:function(participants){var ul=this.contactList;var renderer=ContactRenderer.flavor('group-view');ul.textContent='';participants.forEach(function(participant){var number,infoBlock,selector;if(typeof participant==='object'){number=participant.number;infoBlock=participant.infoBlock;selector='.suggestion';}else{number=participant;}
Contacts.findByPhoneNumber(number,function(results){var isContact=results!==null&&!!results.length;if(isContact){renderer.render({contact:results[0],input:number,infoBlock:infoBlock,infoBlockParentSelector:selector,target:ul});}else{var li=document.createElement('li');li.innerHTML=TMPL.number.interpolate({number:number});var parentBlock=li.querySelector(selector);if(parentBlock&&infoBlock){parentBlock.appendChild(infoBlock);navigator.mozL10n.translate(li);}
ul.appendChild(li);}});}.bind(this));}};Information.initDefaultViews=function(){exports.GroupView=new Information('group');exports.ReportView=new Information('report');};exports.Information=Information;}(this));;'use strict';var fb=this.fb||{};this.fb=fb;fb.utils=this.fb.utils||{};this.fb.utils=fb.utils;if(typeof fb.utils.Request!=='function'){fb.utils.Request=function(){this.done=function(result){this.result=result;if(typeof this.onsuccess==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onsuccess(ev);}.bind(this),0);}};this.failed=function(error){this.error=error;if(typeof this.onerror==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onerror(ev);}.bind(this),0);}};};};'use strict';var fb=this.fb||{};this.fb=fb;(function(){var contacts=fb.contacts||{};fb.contacts=contacts;var datastore;var DATASTORE_NAME='Gaia_Facebook_Friends';var INDEX_ID=1;var readyState='notInitialized';var INITIALIZE_EVENT='fb_ds_init';var revisionId;function createIndex(){return{byTel:Object.create(null),treeTel:[]};}
var index;function safeError(err){if(err&&err.name){return err;}
return{name:'UnknownError'};}
function notifyOpenSuccess(cb){readyState='initialized';if(typeof cb==='function'){window.setTimeout(cb,0);}
var ev=new CustomEvent(INITIALIZE_EVENT);document.dispatchEvent(ev);}
function initError(outRequest,error){outRequest.failed(error);}
function handleInitError(err,errorCb){readyState='error';contacts.error=err;if(typeof errorCb==='function'){window.setTimeout(function(){errorCb(err);},0);}
document.dispatchEvent(new CustomEvent(INITIALIZE_EVENT));}
function defaultError(request){return defaultErrorCb.bind(null,request);}
function defaultSuccess(request){return defaultSuccessCb.bind(null,request);}
function defaultErrorCb(request,error){request.failed(error);}
function defaultSuccessCb(request,result){request.done(result);}
function setIndex(obj){index=(obj||createIndex());}
function successGet(outReq,data){outReq.done(data);}
function errorGet(outReq,uid,err){window.console.error('Error while getting object for UID: ',uid);outReq.failed(err.name);}
Object.defineProperty(contacts,'datastore',{get:function getDataStore(){return datastore},enumerable:false,configurable:false});Object.defineProperty(contacts,'dsIndex',{get:function getIndex(){return index;},set:setIndex,enumerable:false,configurable:false});contacts.get=function(uid){var outRequest=new fb.utils.Request();window.setTimeout(function get(){contacts.init(function(){doGet(uid,outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doGet(uid,outRequest){var successCb=successGet.bind(null,outRequest);var errorCb=errorGet.bind(null,outRequest,uid);datastore.get(uid).then(successCb,errorCb);}
contacts.getByPhone=function(tel){var outRequest=new fb.utils.Request();window.setTimeout(function get_by_phone(){contacts.init(function get_by_phone(){doGetByPhone(tel,outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doGetByPhone(tel,outRequest){var dsId;var normalizedNumber=navigator.mozPhoneNumberService.normalize(tel);if(datastore.revisionId!==revisionId){window.console.info('Datastore revision id has changed!');datastore.get(INDEX_ID).then(function success(obj){setIndex(obj);revisionId=datastore.revisionId;dsId=index.byTel[normalizedNumber];if(typeof dsId!=='undefined'){datastore.get(dsId).then(function success(friend){outRequest.done(friend);},defaultError(outRequest));}
else{outRequest.done(null);}},function(err){err=safeError(err);window.console.error('The index cannot be refreshed: ',err.name);outRequest.failed(err);});}
else{dsId=index.byTel[normalizedNumber];if(typeof dsId!=='undefined'){datastore.get(dsId).then(function success(friend){outRequest.done(friend);},defaultError(outRequest));}
else{outRequest.done(null);}}}
contacts.search=function(by,number){var outRequest=new fb.utils.Request();window.setTimeout(function do_search(){contacts.init(function do_search_init(){if(by==='phone'){doSearchByPhone(number,outRequest);}},function(err){initError(outRequest,err);});},0);return outRequest;};function doSearchByPhone(number,outRequest){var normalizedNumber=navigator.mozPhoneNumberService.normalize(number);LazyLoader.load(['/shared/js/fb/fb_tel_index.js','/shared/js/binary_search.js'],function(){var toSearchNumber=normalizedNumber;if(number.charAt(0)==='+'){toSearchNumber=number.substring(1);}
if(datastore.revisionId!==revisionId){window.console.info('Datastore revision id has changed!');datastore.get(INDEX_ID).then(function success(obj){setIndex(obj);revisionId=datastore.revisionId;var results=TelIndexer.search(index.treeTel,toSearchNumber);var out=null;if(results.length>0){out=datastore.get.apply(datastore,results);}
return out;},function(err){err=safeError(err);window.console.error('The index cannot be refreshed: ',err.name);outRequest.failed(err);}).then(function success(objList){if(objList&&!Array.isArray(objList)){objList=[objList];}
else{objList=[];}
outRequest.done(objList);},function error(err){err=safeError(err);window.console.error('Error while retrieving result data: ',err.name);outRequest.failed(err);});}
else{var results=TelIndexer.search(index.treeTel,toSearchNumber);if(results.length>0){datastore.get.apply(datastore,results).then(function success(objList){if(!Array.isArray(objList)){objList=[objList];}
outRequest.done(objList);},function error(err){err=safeError(err);window.console.error('Error while retrieving result data: ',err.name);outRequest.failed(err);});}
else{outRequest.done(results);}}});}
contacts.refresh=function(){var outRequest=new fb.utils.Request();window.setTimeout(function clear(){contacts.init(function(){doRefresh(outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doRefresh(outRequest){datastore.get(INDEX_ID).then(function success(obj){setIndex(obj);outRequest.done();},defaultError(outRequest));}
contacts.getLength=function(){var retRequest=new fb.utils.Request();window.setTimeout(function(){contacts.init(function get_all(){doGetLength(retRequest);},function(err){initError(retRequest,err);});},0);return retRequest;};function doGetLength(outRequest){datastore.getLength().then(function success(length){outRequest.done(length-1);},function error(err){outRequest.failed(safeError(err));});}
contacts.restart=function(){readyState='notInitialized';};contacts.init=function(cb,errorCb){if(readyState==='initialized'){cb();return;}
if(readyState==='initializing'){document.addEventListener(INITIALIZE_EVENT,function oninitalized(){cb();document.removeEventListener(INITIALIZE_EVENT,oninitalized);});return;}
readyState='initializing';navigator.getDataStores(DATASTORE_NAME).then(function success(ds){if(ds.length<1){handleInitError({name:'DatastoreNotFound'},errorCb);return;}
datastore=ds[0];datastore.getLength().then(function(length){if(length===0&&datastore.readOnly===false){window.console.info('Adding index as length is 0');setIndex(createIndex());return datastore.add(index);}
else if(length>0){return datastore.get(INDEX_ID);}
else if(datastore.readOnly===true){window.console.warn('The datastore is empty and readonly');}
return null;}).then(function add_index_success(v){if(typeof v!=='number'){setIndex(v);}
revisionId=datastore.revisionId;notifyOpenSuccess(cb);},function add_index_error(err){err=safeError(err);window.console.error('Error while setting the index: ',err.name);handleInitError(err,errorCb);});},function error(err){err=safeError(err);window.console.error('FB: Error while opening the DataStore: ',err.name);handleInitError(err,errorCb);});};})();;'use strict';var fb=this.fb||{};this.fb=fb;if(!this.AuxFB){this.AuxFb=(function(){var CATEGORY='facebook';var NOT_LINKED='not_linked';var LINKED='fb_linked';function populate(source,target,propertyNames){propertyNames.forEach(function(property){var propertyValue=source[property];if(propertyValue){if(Array.isArray(propertyValue)){target[property]=propertyValue.slice(0,propertyValue.length);}else{target[property]=propertyValue;}}});}
function mergeFbData(dcontact,fbdata){var multipleFields=['email','tel','photo','org','adr'];multipleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=[];}
var items=fbdata[field];if(items){items.forEach(function(item){var dupList=checkDuplicates(field,item,dcontact[field],fbdata.shortTelephone);if(dupList.length===0){dcontact[field].push(item);}});}});var singleFields=['bday','anniversary'];singleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=fbdata[field];}});mergeNames(dcontact,fbdata);}
function mergeNames(devContact,fbContact){var namesChanged=false;var nameFields=['givenName','familyName'];nameFields.forEach(function(anameField){var fieldValue=devContact[anameField];var fbValue=fbContact[anameField];if((!Array.isArray(fieldValue)||fieldValue.length===0)&&Array.isArray(fbValue)&&fbValue.length>0){namesChanged=true;devContact[anameField]=(fieldValue&&fieldValue[0])||[];devContact[anameField].push(fbValue[0]);}});if(namesChanged){var givenName=devContact.givenName[0]||'';var familyName=devContact.familyName[0]||'';devContact.name=[givenName+' '+familyName];}}
function isFbContact(devContact){return(devContact&&devContact.category&&devContact.category.indexOf(CATEGORY)!==-1);}
function isFbLinked(devContact){return(devContact.category&&devContact.category.indexOf(LINKED)!==-1);}
function getData(devContact){var outReq=new fb.utils.Request();window.setTimeout(function do_getData(){var uid=getFriendUid(devContact);if(uid){var fbreq=fb.contacts.get(uid);fbreq.onsuccess=function(){var fbdata=fbreq.result;var out=mergeContact(devContact,fbdata);outReq.done(out);};fbreq.onerror=function(){outReq.failed(fbreq.error);};}
else{outReq.done(devContact);}},0);return outReq;}
function getFriendUid(devContact){var out=devContact.uid;if(!out){if(isFbLinked(devContact)){out=getLinkedTo(devContact);}
else if(devContact.category){var idx=devContact.category.indexOf(CATEGORY);if(idx!==-1){out=devContact.category[idx+2];}}}
return out;}
function getLinkedTo(devContact){var out;if(devContact.category){var idx=devContact.category.indexOf(LINKED);if(idx!==-1){out=devContact.category[idx+1];}}
return out;}
function mergeContact(devContact,fbContact){var out=devContact;if(fbContact){out=Object.create(null);out.updated=devContact.updated;out.published=devContact.published;populate(devContact,out,Object.getOwnPropertyNames(devContact));populate(devContact,out,Object.getOwnPropertyNames(Object.getPrototypeOf(devContact)));mergeFbData(out,fbContact);}
return out;}
function getContactByNumber(number,onsuccess,onerror){var req=fb.contacts.getByPhone(number);req.onsuccess=function get_by_phone_success(e){var fbData=req.result;if(fbData){fb.getMozContactByUid(fbData.uid,function merge(result){if(Array.isArray(result)&&result[0]){var finalContact=fb.mergeContact(result[0],fbData);onsuccess(finalContact);}
else{onsuccess(null);}},function error_get_mozContact(err){console.error('Error getting mozContact: ',err.name);onerror(err);});}
else{onsuccess(null);}};req.onerror=function(){onerror(req.error);};}
function checkDuplicates(field,fbItem,devContactItems,extraFbItems){var potentialDuplicatesFields=['email','tel'];var out=[];if(devContactItems&&potentialDuplicatesFields.indexOf(field)!==-1){var total=devContactItems.length;for(var i=0;i<total;i++){var localValue=devContactItems[i].value;var fbValue=fbItem.value;if(localValue){var trimedLocal=localValue.trim();if(trimedLocal===fbValue||(field==='tel'&&Array.isArray(extraFbItems)&&extraFbItems.indexOf(trimedLocal)!==-1)){out.push(trimedLocal);out.push(fbValue);}}}}
return out;}
function getMozContactByUid(uid,onsuccess,onerror){var filter={filterBy:['category'],filterValue:uid,filterOp:'contains'};var req=navigator.mozContacts.find(filter);req.onsuccess=function(){onsuccess(req.result);};req.onerror=function(){onerror(req.error);};}
return{'isFbContact':isFbContact,'isFbLinked':isFbLinked,'getData':getData,'getFriendUid':getFriendUid,'getLinkedTo':getLinkedTo,'mergeContact':mergeContact,'getContactByNumber':getContactByNumber,'getMozContactByUid':getMozContactByUid,'checkDuplicates':checkDuplicates,get CATEGORY(){return CATEGORY;},get LINKED(){return LINKED;},get NOT_LINKED(){return NOT_LINKED;}};})();var props=Object.keys(this.AuxFb);var self=this;for(var j=0,end=props.length;j<end;j++){var prop=props[j];if(typeof self.fb[prop]==='function'){self.fb[prop]=self.AuxFb[prop];}
else{Object.defineProperty(self.fb,prop,{value:(function(){return self.AuxFb[prop];})(),writable:false,enumerable:true,configurable:false});}}};'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';(function(window){function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();setTimeout(function(){var detail={name:name,timestamp:now};var evt=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(evt);});}
window.PerformanceTestingHelper={dispatch:dispatch};})(window);;function StickyHeader(scrollable,sticky){'use strict';var headers=scrollable.getElementsByTagName('header');var stickyPosition=sticky.offsetHeight+sticky.offsetTop;var stickyStyle=sticky.style;this.refresh=function(){for(var i=1,length=headers.length;i<length;i++){if(headers[i].offsetTop-scrollable.scrollTop>stickyPosition){var lookupIndex=1;var header=headers[i-lookupIndex];while(header&&header.offsetHeight===0){lookupIndex++;header=headers[i-lookupIndex];}
stickyStyle.backgroundImage='-moz-element(#'+header.id+')';break;}}};scrollable.addEventListener('scroll',this.refresh);};'use strict';window.addEventListener('localized',function localized(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;Array.prototype.forEach.call(document.querySelectorAll('iframe'),function forEachIframe(iframe){var doc=iframe.contentDocument;doc.documentElement.lang=navigator.mozL10n.language.code;doc.documentElement.dir=navigator.mozL10n.language.direction;navigator.mozL10n.translate(doc.body);});Array.prototype.forEach.call(document.getElementsByClassName('l10n-contains-date'),function(element){if(!(element.dataset.l10nDate&&element.dataset.l10nDateFormat)){return;}
var format=navigator.mozL10n.get(element.dataset.l10nDateFormat);var date=new Date(+element.dataset.l10nDate);var localeData=Utils.date.format.localeFormat(date,format);if(element.dataset.l10nId&&element.dataset.l10nArgs){var args=JSON.parse(element.dataset.l10nArgs);args.date=localeData;navigator.mozL10n.localize(element,element.dataset.l10nId,args);}else{element.textContent=localeData;}});});window.addEventListener('load',function(){PerformanceTestingHelper.dispatch('load');function initUIApp(){TimeHeaders.init();ActivityHandler.init();ThreadUI.init();ThreadListUI.init();Information.initDefaultViews();ThreadListUI.renderThreads();Settings.init();PerformanceTestingHelper.dispatch('objects-init-finished');}
if(!navigator.mozMobileMessage){var mocks=['js/desktop-only/mobilemessage.js','js/desktop-only/contacts.js'];LazyLoader.load(mocks,function(){MessageManager.init(initUIApp);});return;}
MessageManager.init(initUIApp);});