;(function(){'use strict';function dump_off(msg,optionalObject){};function dump_on(msg,optionalObject){var output=msg;if(optionalObject){output+=JSON.stringify(optionalObject);}
if(dump){var appName=document.location.hostname.replace(/\..*$/,'');dump('['+appName+'] '+output+'\n');}else{console.log(output);}}
window.DUMP=dump_off;var settings=window.navigator.mozSettings;var reqGaiaDebug=settings.createLock().get('debug.gaia.enabled');reqGaiaDebug.onsuccess=function gaiaDebug(){window.DUMP=reqGaiaDebug.result['debug.gaia.enabled']?dump_on:dump_off;};settings.addObserver('debug.gaia.enabled',function(event){window.DUMP=event.settingValue?dump_on:dump_off;dump_on(event.settingValue?'Enabling DUMP':'Disabling DUMP');});}());;'use strict';function SettingsURL(){this._url=null;this._isBlob=false;}
SettingsURL.prototype={set:function(value){if(this._isBlob){window.URL.revokeObjectURL(this._url);}
if(value instanceof Blob){this._isBlob=true;this._url=window.URL.createObjectURL(value);}else{this._isBlob=false;this._url=value;}
return this._url;},get:function(){return this._url;}};;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;'use strict';(function(window){function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();setTimeout(function(){var detail={name:name,timestamp:now};var evt=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(evt);});}
window.PerformanceTestingHelper={dispatch:dispatch};})(window);;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media)
continue;window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;'use strict';var Settings={get mozSettings(){var settings=window.navigator.mozSettings;return(settings&&typeof(settings.createLock)=='function')?settings:null;},isTabletAndLandscape:function is_tablet_and_landscape(){return ScreenLayout.getCurrentLayout('tabletAndLandscaped');},_panelsWithClass:function pane_with_class(targetClass){return document.querySelectorAll('section[role="region"].'+targetClass);},_isTabletAndLandscapeLastTime:null,rotate:function rotate(evt){var isTabletAndLandscapeThisTime=Settings.isTabletAndLandscape();var panelsWithCurrentClass;if(Settings._isTabletAndLandscapeLastTime!==isTabletAndLandscapeThisTime){panelsWithCurrentClass=Settings._panelsWithClass('current');if(panelsWithCurrentClass.length===1&&panelsWithCurrentClass[0].id==='root'){Settings.currentPanel=Settings.defaultPanelForTablet;}}
Settings._isTabletAndLandscapeLastTime=isTabletAndLandscapeThisTime;},_transit:function transit(oldPanel,newPanel,callback){if(this.isTabletAndLandscape()){this._pageTransitions.twoColumn(oldPanel,newPanel,callback);}else{this._pageTransitions.oneColumn(oldPanel,newPanel,callback);}},_pageTransitions:{_sendPanelReady:function _send_panel_ready(oldPanelHash,newPanelHash){var detail={previous:oldPanelHash,current:newPanelHash};var event=new CustomEvent('panelready',{detail:detail});window.dispatchEvent(event);},oneColumn:function one_column(oldPanel,newPanel,callback){var self=this;oldPanel.className=newPanel.className?'':'previous';newPanel.className='current';if((window.scrollX!==0)||(window.scrollY!==0)){window.scrollTo(0,0);}
newPanel.addEventListener('transitionend',function paintWait(){newPanel.removeEventListener('transitionend',paintWait);setTimeout(function nextTick(){self._sendPanelReady('#'+oldPanel.id,'#'+newPanel.id);if(oldPanel.className==='current')
return;if(callback)
callback();});});},twoColumn:function two_column(oldPanel,newPanel,callback){oldPanel.className=newPanel.className?'':'previous';newPanel.className='current';this._sendPanelReady('#'+oldPanel.id,'#'+newPanel.id);if(callback){callback();}}},defaultPanelForTablet:'#wifi',_currentPanel:'#root',_currentActivity:null,get currentPanel(){return this._currentPanel;},set currentPanel(hash){if(!hash.startsWith('#')){hash='#'+hash;}
if(hash==this._currentPanel){return;}
if(this._currentActivity!==null&&hash==='#root'){Settings.finishActivityRequest();return;}
if(hash==='#wifi'){PerformanceTestingHelper.dispatch('start');}
var oldPanelHash=this._currentPanel;var oldPanel=document.querySelector(this._currentPanel);this._currentPanel=hash;var newPanelHash=this._currentPanel;var newPanel=document.querySelector(this._currentPanel);this.lazyLoad(newPanel);this._transit(oldPanel,newPanel,function(){switch(newPanel.id){case'about-licensing':var iframe=document.getElementById('os-license');iframe.src=iframe.dataset.src;break;case'wifi':PerformanceTestingHelper.dispatch('settings-panel-wifi-visible');break;}});},preInit:function settings_preInit(){var settings=this.mozSettings;if(!settings)
return;this.getSettings(null);settings.onsettingchange=(function settingChanged(event){var key=event.settingName;var value=event.settingValue;if(this._settingsCache){this._settingsCache[key]=value;}
if(!this._initialized){return;}
var rule='[data-name="'+key+'"]:not([data-ignore])';var spanField=document.querySelector(rule);if(spanField){var options=document.querySelector('select[data-setting="'+
key+'"]');if(options){var max=options.length;for(var i=0;i<max;i++){if(options[i]&&options[i].value===value){spanField.dataset.l10nId=options[i].dataset.l10nId;spanField.textContent=options[i].textContent;}}}else{spanField.textContent=value;}}
rule='[data-show-name="'+key+'"]:not([data-ignore])';var item=document.querySelector(rule);if(item){item.hidden=!value;}
var input=document.querySelector('input[name="'+key+'"]');if(!input)
return;switch(input.type){case'checkbox':case'switch':if(input.checked==value)
return;input.checked=value;break;case'range':if(input.value==value)
return;input.value=value;break;case'select':for(var i=0;i<input.options.length;i++){if(input.options[i].value==value){input.options[i].selected=true;break;}}
break;}}).bind(this);},_initialized:false,init:function settings_init(){this._initialized=true;if(!this.mozSettings||!navigator.mozSetMessageHandler){return;}
if(!navigator.mozTelephony){var elements=['call-settings','data-connectivity','messaging-settings','simSecurity-settings'];elements.forEach(function(el){document.getElementById(el).hidden=true;});}
if(navigator.mozMobileConnections){if(navigator.mozMobileConnections.length==1){document.getElementById('simCardManager-settings').hidden=true;}else{document.getElementById('simSecurity-settings').hidden=true;}}
navigator.mozSetMessageHandler('activity',this.webActivityHandler);this.presetPanel();},loadPanel:function settings_loadPanel(panel,cb){if(!panel){return;}
this.loadPanelStylesheetsIfNeeded();LazyLoader.load([panel],this.afterPanelLoad.bind(this,panel,cb));},afterPanelLoad:function(panel,cb){navigator.mozL10n.translate(panel);var scripts=panel.getElementsByTagName('script');var scripts_src=Array.prototype.map.call(scripts,function(script){return script.getAttribute('src');});LazyLoader.load(scripts_src);var self=this;var rule='a[href^="http"], a[href^="tel"], [data-href]';var links=panel.querySelectorAll(rule);for(var i=0,il=links.length;i<il;i++){var link=links[i];if(!link.dataset.href){link.dataset.href=link.href;link.href='#';}
if(!link.dataset.href.startsWith('#')){link.onclick=function(){openLink(this.dataset.href);return false;};}else if(!link.dataset.href.endsWith('Settings')){link.onclick=function(){openDialog(this.dataset.href.substr(1));return false;};}else{link.onclick=function(){self.openDialog(this.dataset.href.substr(1));return false;};}}
if(cb){cb();}},lazyLoad:function settings_lazyLoad(panel){if(panel.dataset.rendered){return;}
panel.dataset.rendered=true;if(panel.dataset.requireSubPanels){var selector='section[id^="'+panel.id+'-"]';var subPanels=document.querySelectorAll(selector);for(var i=0,il=subPanels.length;i<il;i++){this.loadPanel(subPanels[i]);}
this.loadPanel(panel,this.panelLoaded.bind(this,panel,subPanels));}else{this.loadPanel(panel,this.panelLoaded.bind(this,panel));}},panelLoaded:function(panel,subPanels){if(panel.dataset.requireSubPanels){for(var i=0;i<subPanels.length;i++){this.presetPanel(subPanels[i]);}}
this.presetPanel(panel);},_settingsCache:null,get settingsCache(){return this._settingsCache;},_settingsCacheRequestSent:false,_pendingSettingsCallbacks:[],getSettings:function(callback){var settings=this.mozSettings;if(!settings)
return;if(this._settingsCache&&callback){callback(this._settingsCache);return;}
if(!this._settingsCacheRequestSent&&!this._settingsCache){this._settingsCacheRequestSent=true;var lock=settings.createLock();var request=lock.get('*');request.onsuccess=function(e){var result=request.result;var cachedResult={};for(var attr in result){cachedResult[attr]=result[attr];}
Settings._settingsCache=cachedResult;var cbk;while((cbk=Settings._pendingSettingsCallbacks.pop())){cbk(result);}};}
if(callback){this._pendingSettingsCallbacks.push(callback);}},presetPanel:function settings_presetPanel(panel){this.getSettings(function(result){panel=panel||document;var rule='input[type="checkbox"]:not([data-ignore])';var checkboxes=panel.querySelectorAll(rule);for(var i=0;i<checkboxes.length;i++){var key=checkboxes[i].name;if(key&&result[key]!=undefined){checkboxes[i].checked=!!result[key];}}
setTimeout(function(){for(var i=0;i<checkboxes.length;i++){if(checkboxes[i].classList.contains('initial')){checkboxes[i].classList.remove('initial');}}},0);rule='input[type="radio"]:not([data-ignore])';var radios=panel.querySelectorAll(rule);for(i=0;i<radios.length;i++){var key=radios[i].name;if(key&&result[key]!=undefined){radios[i].checked=(result[key]===radios[i].value);}}
rule='input[type="text"]:not([data-ignore])';var texts=panel.querySelectorAll(rule);for(i=0;i<texts.length;i++){var key=texts[i].name;if(key&&result[key]!=undefined){texts[i].value=result[key];}}
rule='input[type="range"]:not([data-ignore])';var ranges=panel.querySelectorAll(rule);for(i=0;i<ranges.length;i++){var key=ranges[i].name;if(key&&result[key]!=undefined){ranges[i].value=parseFloat(result[key]);}}
var selects=panel.querySelectorAll('select');for(var i=0,count=selects.length;i<count;i++){var select=selects[i];var key=select.name;if(key&&result[key]!=undefined){var value=result[key];var option='option[value="'+value+'"]';var selectOption=select.querySelector(option);if(selectOption){selectOption.selected=true;}}}
rule='[data-name]:not([data-ignore])';var spanFields=panel.querySelectorAll(rule);for(i=0;i<spanFields.length;i++){var key=spanFields[i].dataset.name;if(key&&result[key]&&result[key]!='undefined'){rule='[data-setting="'+key+'"] '+'[value="'+result[key]+'"]';var option=document.querySelector(rule);if(option){spanFields[i].dataset.l10nId=option.dataset.l10nId;spanFields[i].textContent=option.textContent;}else{spanFields[i].textContent=result[key];}}else{switch(key){case'deviceinfo.software':var _=navigator.mozL10n.get;var text=_('brandShortName')+' '+
result['deviceinfo.os'];spanFields[i].textContent=text;break;case'deviceinfo.firmware_revision':spanFields[i].parentNode.hidden=true;break;case'deviceinfo.mac':var _=navigator.mozL10n.get;spanFields[i].textContent=_('macUnavailable');break;case'deviceinfo.bt_address':var _=navigator.mozL10n.get;spanFields[i].textContent=_('bluetooth-address-unavailable');break;}}}
rule='[data-show-name]:not([data-ignore])';var hiddenItems=panel.querySelectorAll(rule);for(i=0;i<hiddenItems.length;i++){var key=hiddenItems[i].dataset.showName;hiddenItems[i].hidden=!result[key];}});},finishActivityRequest:function settings_finishActivityRequest(){if(document.hidden){this.restoreDOMFromActivty();}else{var self=this;document.addEventListener('visibilitychange',function restore(evt){if(document.hidden){document.removeEventListener('visibilitychange',restore);self.restoreDOMFromActivty();}});}
if(Settings._currentActivity!==null){Settings._currentActivity.postResult(null);Settings._currentActivity=null;}},restoreDOMFromActivty:function settings_restoreDOMFromActivity(){var currentPanel=document.querySelector('[data-dialog]');if(currentPanel!==null){delete currentPanel.dataset.dialog;}},visibilityHandler:function settings_visibilityHandler(evt){if(document.hidden){Settings.finishActivityRequest();document.removeEventListener('visibilitychange',Settings.visibilityHandler);}},webActivityHandler:function settings_handleActivity(activityRequest){var name=activityRequest.source.name;var section='root';Settings._currentActivity=activityRequest;switch(name){case'configure':section=activityRequest.source.data.section;if(!section){Settings._currentActivity=null;}
var sectionElement=document.getElementById(section);if(!sectionElement||sectionElement.tagName!=='SECTION'){var msg='Trying to open an non-existent section: '+section;console.warn(msg);activityRequest.postError(msg);return;}
setTimeout(function settings_goToSection(){Settings.currentPanel=section;});break;default:Settings._currentActivity=null;break;}
if(Settings._currentActivity!==null){var domSection=document.getElementById(section);domSection.dataset.dialog=true;document.addEventListener('visibilitychange',Settings.visibilityHandler);}},handleEvent:function settings_handleEvent(event){var input=event.target;var type=input.type;var key=input.name;var settings=window.navigator.mozSettings;if(!key||!settings||event.type!='change')
return;if(input.dataset.setting)
return;var value;switch(type){case'checkbox':case'switch':value=input.checked;break;case'range':value=parseFloat(parseFloat(input.value).toFixed(1));break;case'select-one':case'radio':case'text':case'password':value=input.value;if(input.dataset.valueType==='integer')
value=parseInt(value);break;}
var cset={};cset[key]=value;settings.createLock().set(cset);},openDialog:function settings_openDialog(dialogID){var settings=this.mozSettings;var dialog=document.getElementById(dialogID);var fields=dialog.querySelectorAll('[data-setting]:not([data-ignore])');function reset(){if(settings){var lock=settings.createLock();for(var i=0;i<fields.length;i++){(function(input){var key=input.dataset.setting;var request=lock.get(key);request.onsuccess=function(){switch(input.type){case'radio':input.checked=(input.value==request.result[key]);break;case'checkbox':input.checked=request.result[key]||false;break;case'select-one':input.value=request.result[key]||'';break;default:input.value=request.result[key]||'';break;}};})(fields[i]);}}}
function submit(){if(settings){fields=dialog.querySelectorAll('[data-setting]:not([data-ignore])');var lock=settings.createLock();for(var i=0;i<fields.length;i++){var input=fields[i];var cset={};var key=input.dataset.setting;switch(input.type){case'radio':if(input.checked)
cset[key]=input.value;break;case'checkbox':cset[key]=input.checked;break;default:cset[key]=input.value;break;}
lock.set(cset);}}}
reset();openDialog(dialogID,submit);},getSupportedLanguages:function settings_getLanguages(callback){if(!callback)
return;if(this._languages){callback(this._languages);}else{var self=this;var LANGUAGES='/shared/resources/languages.json';loadJSON(LANGUAGES,function loadLanguages(data){if(data){self._languages=data;callback(self._languages);}});}},loadPanelStylesheetsIfNeeded:function settings_loadPanelStylesheetsIN(){var self=this;if(self._panelStylesheetsLoaded){return;}
LazyLoader.load(['shared/style/action_menu.css','shared/style/buttons.css','shared/style/confirm.css','shared/style/input_areas.css','shared/style/progress_activity.css','style/apps.css','style/phone_lock.css','style/simcard.css','style/updates.css','style/downloads.css'],function callback(){self._panelStylesheetsLoaded=true;});}};window.addEventListener('load',function loadSettings(){window.removeEventListener('load',loadSettings);window.addEventListener('change',Settings);navigator.addIdleObserver({time:3,onidle:Settings.loadPanelStylesheetsIfNeeded.bind(Settings)});Settings.init();setTimeout(function nextTick(){LazyLoader.load(['js/utils.js'],startupLocale);LazyLoader.load(['shared/js/wifi_helper.js'],displayDefaultPanel);LazyLoader.load(['shared/js/airplane_mode_helper.js','js/airplane_mode.js','js/battery.js','shared/js/async_storage.js','js/storage.js','js/try_show_homescreen_section.js','shared/js/mobile_operator.js','shared/js/icc_helper.js','shared/js/settings_listener.js','shared/js/toaster.js','js/connectivity.js','js/security_privacy.js','js/icc_menu.js','js/nfc.js','js/dsds_settings.js','js/telephony_settings.js','js/telephony_items_handler.js'],function(){TelephonySettingHelper.init();});});function displayDefaultPanel(){ScreenLayout.watch('tabletAndLandscaped','(min-width: 768px) and (orientation: landscape)');window.addEventListener('screenlayoutchange',Settings.rotate);if(Settings.isTabletAndLandscape()){Settings.currentPanel=Settings.defaultPanelForTablet;}}
document.addEventListener('click',function settings_backButtonClick(e){var target=e.target;if(target.classList.contains('icon-back')){Settings.currentPanel=target.parentNode.getAttribute('href');}});document.addEventListener('click',function settings_sectionOpenClick(e){var target=e.target;var nodeName=target.nodeName.toLowerCase();if(nodeName!='a'){return;}
var href=target.getAttribute('href');if(!href||!href.startsWith('#')||href==='#'){return;}
Settings.currentPanel=href;e.preventDefault();});});window.addEventListener('keydown',function handleSpecialKeys(event){if(Settings.currentPanel!='#root'&&event.keyCode===event.DOM_VK_ESCAPE){event.preventDefault();event.stopPropagation();var dialog=document.querySelector('#dialogs .active');if(dialog){dialog.classList.remove('active');document.body.classList.remove('dialog');}else{Settings.currentPanel='#root';}}else if(event.keyCode===event.DOM_VK_RETURN){event.target.blur();event.stopPropagation();event.preventDefault();}});function startupLocale(){navigator.mozL10n.ready(function startupLocale(){initLocale();window.addEventListener('localized',initLocale);});}
function initLocale(){var lang=navigator.mozL10n.language.code;document.documentElement.lang=lang;document.documentElement.dir=navigator.mozL10n.language.direction;Settings.getSupportedLanguages(function displayLang(languages){document.getElementById('language-desc').textContent=languages[lang];});}
Settings.preInit();