;'use strict';var GestureDetector=(function(){function GD(e,options){this.element=e;this.options=options||{};this.options.panThreshold=this.options.panThreshold||GD.PAN_THRESHOLD;this.options.mousePanThreshold=this.options.mousePanThreshold||GD.MOUSE_PAN_THRESHOLD;this.state=initialState;this.timers={};this.listeningForMouseEvents=true;}
GD.prototype.startDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.addEventListener(t,self);});};GD.prototype.stopDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.removeEventListener(t,self);});};GD.prototype.handleEvent=function(e){var handler=this.state[e.type];if(!handler)return;if(e.changedTouches){if(this.listeningForMouseEvents){this.listeningForMouseEvents=false;this.element.removeEventListener('mousedown',this);}
if(e.type==='touchend'&&e.changedTouches.length>1){console.warn('gesture_detector.js: spurious extra changed touch on '+'touchend. See '+'https://bugzilla.mozilla.org/show_bug.cgi?id=785554');}
for(var i=0;i<e.changedTouches.length;i++){handler(this,e,e.changedTouches[i]);handler=this.state[e.type];}}
else{handler(this,e);}};GD.prototype.startTimer=function(type,time){this.clearTimer(type);var self=this;this.timers[type]=setTimeout(function(){self.timers[type]=null;var handler=self.state[type];if(handler)
handler(self,type);},time);};GD.prototype.clearTimer=function(type){if(this.timers[type]){clearTimeout(this.timers[type]);this.timers[type]=null;}};GD.prototype.switchTo=function(state,event,touch){this.state=state;if(state.init)
state.init(this,event,touch);};GD.prototype.emitEvent=function(type,detail){if(!this.target){console.error('Attempt to emit event with no target');return;}
var event=this.element.ownerDocument.createEvent('CustomEvent');event.initCustomEvent(type,true,true,detail);this.target.dispatchEvent(event);};GD.HOLD_INTERVAL=1000;GD.PAN_THRESHOLD=20;GD.MOUSE_PAN_THRESHOLD=15;GD.DOUBLE_TAP_DISTANCE=50;GD.DOUBLE_TAP_TIME=500;GD.VELOCITY_SMOOTHING=.5;GD.SCALE_THRESHOLD=20;GD.ROTATE_THRESHOLD=22.5;GD.THRESHOLD_SMOOTHING=0.9;var abs=Math.abs,floor=Math.floor,sqrt=Math.sqrt,atan2=Math.atan2;var PI=Math.PI;var eventtypes=['touchstart','touchmove','touchend','mousedown'];function eventTime(e){var ts=e.timeStamp;if(ts>2*Date.now())
return Math.floor(ts/1000);else
return ts;}
function coordinates(e,t){return Object.freeze({screenX:t.screenX,screenY:t.screenY,clientX:t.clientX,clientY:t.clientY,timeStamp:eventTime(e)});}
function midpoints(e,t1,t2){return Object.freeze({screenX:floor((t1.screenX+t2.screenX)/2),screenY:floor((t1.screenY+t2.screenY)/2),clientX:floor((t1.clientX+t2.clientX)/2),clientY:floor((t1.clientY+t2.clientY)/2),timeStamp:eventTime(e)});}
function mouseCoordinates(e){return Object.freeze({screenX:e.screenX,screenY:e.screenY,clientX:e.clientX,clientY:e.clientY,timeStamp:eventTime(e)});}
function between(c1,c2){var r=GD.THRESHOLD_SMOOTHING;return Object.freeze({screenX:floor(c1.screenX+r*(c2.screenX-c1.screenX)),screenY:floor(c1.screenY+r*(c2.screenY-c1.screenY)),clientX:floor(c1.clientX+r*(c2.clientX-c1.clientX)),clientY:floor(c1.clientY+r*(c2.clientY-c1.clientY)),timeStamp:floor(c1.timeStamp+r*(c2.timeStamp-c1.timeStamp))});}
function touchDistance(t1,t2){var dx=t2.screenX-t1.screenX;var dy=t2.screenY-t1.screenY;return sqrt(dx*dx+dy*dy);}
function touchDirection(t1,t2){return atan2(t2.screenY-t1.screenY,t2.screenX-t1.screenX)*180/PI;}
function touchRotation(d1,d2){var angle=d2-d1;if(angle>180)
angle-=360;else if(angle<=-180)
angle+=360;return angle;}
function isDoubleTap(lastTap,thisTap){var dx=abs(thisTap.screenX-lastTap.screenX);var dy=abs(thisTap.screenY-lastTap.screenY);var dt=thisTap.timeStamp-lastTap.timeStamp;return(dx<GD.DOUBLE_TAP_DISTANCE&&dy<GD.DOUBLE_TAP_DISTANCE&&dt<GD.DOUBLE_TAP_TIME);}
var initialState={name:'initialState',init:function(d){d.target=null;d.start=d.last=null;d.touch1=d.touch2=null;d.vx=d.vy=null;d.startDistance=d.lastDistance=null;d.startDirection=d.lastDirection=null;d.lastMidpoint=null;d.scaled=d.rotated=null;},touchstart:function(d,e,t){d.switchTo(touchStartedState,e,t);},mousedown:function(d,e){d.switchTo(mouseDownState,e);}};var touchStartedState={name:'touchStartedState',init:function(d,e,t){d.target=e.target;d.touch1=t.identifier;d.start=d.last=coordinates(e,t);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},touchstart:function(d,e,t){d.clearTimer('holdtimeout');d.switchTo(transformState,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;if(abs(t.screenX-d.start.screenX)>d.options.panThreshold||abs(t.screenY-d.start.screenY)>d.options.panThreshold){d.clearTimer('holdtimeout');d.switchTo(panStartedState,e,t);}},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=coordinates(e,t);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(holdState);}};var panStartedState={name:'panStartedState',init:function(d,e,t){d.start=d.last=between(d.start,coordinates(e,t));if(e.type==='touchmove')
panStartedState.touchmove(d,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},touchend:function(d,e,t){if(t.identifier!==d.touch1)
return;var current=coordinates(e,t);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:e.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};var holdState={name:'holdState',init:function(d){d.emitEvent('holdstart',d.start);},touchmove:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},touchend:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var transformState={name:'transformState',init:function(d,e,t){d.touch2=t.identifier;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);d.startDistance=d.lastDistance=touchDistance(t1,t2);d.startDirection=d.lastDirection=touchDirection(t1,t2);d.scaled=d.rotated=false;},touchmove:function(d,e,t){if(t.identifier!==d.touch1&&t.identifier!==d.touch2)
return;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);var midpoint=midpoints(e,t1,t2);var distance=touchDistance(t1,t2);var direction=touchDirection(t1,t2);var rotation=touchRotation(d.startDirection,direction);if(!d.scaled){if(abs(distance-d.startDistance)>GD.SCALE_THRESHOLD){d.scaled=true;d.startDistance=d.lastDistance=floor(d.startDistance+
GD.THRESHOLD_SMOOTHING*(distance-d.startDistance));}
else
distance=d.startDistance;}
if(!d.rotated){if(abs(rotation)>GD.ROTATE_THRESHOLD)
d.rotated=true;else
direction=d.startDirection;}
if(d.scaled||d.rotated){d.emitEvent('transform',{absolute:{scale:distance/d.startDistance,rotate:touchRotation(d.startDirection,direction)},relative:{scale:distance/d.lastDistance,rotate:touchRotation(d.lastDirection,direction)},midpoint:midpoint});d.lastDistance=distance;d.lastDirection=direction;d.lastMidpoint=midpoint;}},touchend:function(d,e,t){if(t.identifier===d.touch2)
d.touch2=null;else if(t.identifier===d.touch1){d.touch1=d.touch2;d.touch2=null;}
else
return;if(d.scaled||d.rotated){d.emitEvent('transformend',{absolute:{scale:d.lastDistance/d.startDistance,rotate:touchRotation(d.startDirection,d.lastDirection)},relative:{scale:1,rotate:0},midpoint:d.lastMidpoint});}
d.switchTo(afterTransformState);}};var afterTransformState={name:'afterTransformState',touchstart:function(d,e,t){d.switchTo(transformState,e,t);},touchend:function(d,e,t){if(t.identifier===d.touch1)
d.switchTo(initialState);}};var mouseDownState={name:'mouseDownState',init:function(d,e){d.target=e.target;var doc=d.element.ownerDocument;doc.addEventListener('mousemove',d,true);doc.addEventListener('mouseup',d,true);d.start=d.last=mouseCoordinates(e);if(d.options.holdEvents)
d.startTimer('holdtimeout',GD.HOLD_INTERVAL);},mousemove:function(d,e){if(abs(e.screenX-d.start.screenX)>d.options.mousePanThreshold||abs(e.screenY-d.start.screenY)>d.options.mousePanThreshold){d.clearTimer('holdtimeout');d.switchTo(mousePannedState,e);}},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=mouseCoordinates(e);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(mouseHoldState);}};var mouseHoldState={name:'mouseHoldState',init:function(d){d.emitEvent('holdstart',d.start);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},mouseup:function(d,e){var current=mouseCoordinates(e);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var mousePannedState={name:'mousePannedState',init:function(d,e){d.start=d.last=between(d.start,mouseCoordinates(e));if(e.type==='mousemove')
mousePannedState.mousemove(d,e);},mousemove:function(d,e){var current=mouseCoordinates(e);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},mouseup:function(d,e){var doc=d.element.ownerDocument;doc.removeEventListener('mousemove',d,true);doc.removeEventListener('mouseup',d,true);var current=mouseCoordinates(e);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0)
angle+=360;var direction;if(angle>=315||angle<45)
direction='right';else if(angle>=45&&angle<135)
direction='down';else if(angle>=135&&angle<225)
direction='left';else if(angle>=225&&angle<315)
direction='up';d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:current.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};return GD;}());;window.onload=function(){navigator.mozSetMessageHandler('activity',function handler(activityRequest){var activityName=activityRequest.source.name;if(activityName!=='share'&&activityName!=='setwallpaper')
return;startShare(activityRequest);});var preview=document.getElementById('preview');var cancelButton=document.getElementById('cancel');var setButton=document.getElementById('set-wallpaper');var activity;var blob;var url;var gestureDetector=new GestureDetector(preview);var posX=0;var posY=0;var limitX;var limitY;var scale;var previewImage=document.getElementById('previewImage');function startShare(request){cancelButton.addEventListener('click',cancelShare);gestureDetector.startDetecting();activity=request;blob=activity.source.data.blobs[0];url=URL.createObjectURL(blob);previewImage.onload=function(){var scalex=window.innerWidth/previewImage.width;var scaley=window.innerHeight/previewImage.height;scale=Math.max(scalex,scaley);previewImage.width=Math.round(previewImage.width*scale);limitX=window.innerWidth-previewImage.width;limitY=window.innerHeight-previewImage.height;posX=Math.round(limitX/2);posY=Math.round(limitY/2);previewImage.style.transform='translate('+posX+'px, '+posY+'px)';setButton.addEventListener('click',scaleImage);previewImage.addEventListener('pan',moveBackground);};previewImage.src=url;}
function moveBackground(evt){var positions=evt.detail.relative;posX+=positions.dx;if(posX>0){posX=0;}else if(posX<limitX){posX=limitX;}
posY+=positions.dy;if(posY>0){posY=0;}else if(posY<limitY){posY=limitY;}
previewImage.style.transform='translate('+posX+'px, '+posY+'px)';}
function scaleImage(){var canvas=document.createElement('canvas');canvas.width=window.innerWidth*window.devicePixelRatio;canvas.height=window.innerHeight*window.devicePixelRatio;var ctx=canvas.getContext('2d');var w=Math.round(window.innerWidth/scale);var h=Math.round(window.innerHeight/scale);var x=Math.round(-1*posX/scale);var y=Math.round(-1*posY/scale);if(x<0){x=0;console.error('The value of x shouldn\'t be negative.');}
if(y<0){y=0;console.error('The value of y shouldn\'t be negative.');}
ctx.drawImage(previewImage,x,y,w,h,0,0,canvas.width,canvas.height);canvas.toBlob(function(newBlob){blob=newBlob;setWallpaper();},'image/jpeg');}
function setWallpaper(){var request=navigator.mozSettings.createLock().set({'wallpaper.image':blob});request.onsuccess=function(){activity.postResult('shared');endShare();};request.onerror=function(){console.warn('error setting wallpaper.image:',request.error);activity.postError('could not set wallpaper: '+request.error);endShare();};}
function cancelShare(){activity.postError('cancelled');endShare();}
function endShare(){activity=null;window.URL.revokeObjectURL(url);window.URL.revokeObjectURL(previewImage.src);setButton.removeEventListener('click',scaleImage);cancelButton.removeEventListener('click',cancelShare);}};