;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var SettingsListener={_timer:null,_lock:null,getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));settings.addObserver(name,function settingChanged(evt){callback(evt.settingValue);});}};;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';var Format={padLeft:function(input,len,padWith){padWith=padWith||' ';var pad=len-(input+'').length;while(--pad>-1){input=padWith+input;}
return input;}};;var DEBUGGING=false;var debug=(function(){var SEQ_ID=0;var PROCESS_ID=Date.now();var DEBUG_PREFIX='CC';return function _debug(){if(!DEBUGGING){return;}
var currentWindow=window;var parents=[];while(currentWindow!==currentWindow.parent){parents.push(currentWindow.location.pathname);currentWindow=currentWindow.parent;}
parents.push(currentWindow.location.pathname);parents=parents.reverse().join('>')+':';var uId=PROCESS_ID;var message=['('+uId+'-'+(SEQ_ID++)+')',DEBUG_PREFIX,parents];for(var i=0,len=arguments.length,obj;i<len;i++){obj=arguments[i];message.push(typeof obj==='object'?JSON.stringify(obj):obj);}
if(window.dump){window.dump(message.join(' '));}else if(console&&console.log){console.log(message.join(' '));}};}());;'use strict';var _=function cc_fallbackTranslation(keystring){var r=navigator.mozL10n.get.apply(this,arguments);return r||(DEBUGGING?'!!':'')+keystring;};function toMidnight(date){date.setHours(0);date.setMinutes(0);date.setSeconds(0);date.setMilliseconds(0);return date;}
function deepCopy(object){if(object===null||!(object instanceof Object)){return object;}
var clone,constructor=object.constructor;switch(constructor){case Date:clone=new constructor(object.getTime());break;default:clone=constructor();break;}
for(var key in object){if(object.hasOwnProperty(key)){clone[key]=deepCopy(object[key]);}}
return clone;}
Object.prototype.extend=function _extend(){for(var i=0,len=arguments.length;i<len;i++){var object=arguments[i];for(var name in object){if(object.hasOwnProperty(name)){this[name]=object[name];}}}
return this;};var NOP=function(){};var Toolkit={checkEnoughDelay:function(threshold,dateA,dateB){if(!dateA){return true;}
var end=dateB||new Date();return(end.getTime()-dateA.getTime())>threshold;}};;'use strict';function formatBalance(balance){var formattedBalance='--';if(balance!==null){var splitBalance=(balance.toFixed(2)).split('.');formattedBalance='&i.&d'.replace('&i',splitBalance[0]).replace('&d',splitBalance[1]);}
return formattedBalance;}
function formatData(dataArray){return isNaN(dataArray[0])?'':_('magnitude',{value:dataArray[0],unit:dataArray[1]});}
function roundData(value,positions){positions=(typeof positions==='undefined')?2:positions;if(value<1000){return[value.toFixed(positions),_('B')];}
if(value<1000000){return[(value/1000).toFixed(positions),_('KB')];}
if(value<1000000000){return[(value/1000000).toFixed(positions),_('MB')];}
return[(value/1000000000).toFixed(positions),_('GB')];}
function getPositions(value,deltaPositions){deltaPositions=(typeof deltaPositions==='undefined')?0:deltaPositions;if(parseInt(value)===value){return 0;}
if(value<10){return 2+deltaPositions;}
if(value<100){return 1+deltaPositions;}
return 0;}
function smartRound(value,deltaPositions){deltaPositions=(typeof deltaPositions==='undefined')?0:deltaPositions;if(value<1000){return[value.toFixed(getPositions(value,deltaPositions)),_('B')];}
if(value<1000000){var kbytes=value/1000;return[kbytes.toFixed(getPositions(kbytes,deltaPositions)),_('KB')];}
if(value<1000000000){var mbytes=value/1000000;return[mbytes.toFixed(getPositions(mbytes,deltaPositions)),_('MB')];}
var gbytes=value/1000000000;return[gbytes.toFixed(getPositions(gbytes,deltaPositions)),_('GB')];}
function padData(v){var rounded=roundData(v,0);var value=rounded[0];var len=value.length;switch(len){case 1:value='00'+value;break;case 2:value='0'+value;break;}
rounded[0]=parseInt(value,10)?value:'0';return rounded;}
function computeTelephonyMinutes(activity){return Math.ceil(activity.calltime/60000);}
var Formatting=(function(){var MINUTE=60*1000;var HOUR=60*MINUTE;var DAY=24*HOUR;function getDaysOfDifference(a,b){return Math.floor((a.getTime()-b.getTime())/DAY);}
return{formatTime:function(timestamp,format){if(!timestamp){return _('never');}
var now=new Date(),then=new Date(timestamp);var dateFormatter=new navigator.mozL10n.DateTimeFormat();if(format){return dateFormatter.localeFormat(then,format);}
var date,time;var daysOfDifference=getDaysOfDifference(now,then);if(daysOfDifference===0){date=_('today');}else if(daysOfDifference===1){date=_('yesterday');}else{date=dateFormatter.localeFormat(timestamp,'%a');}
time=dateFormatter.localeFormat(timestamp,_('shortTimeFormat'));return _('day-hour-format',{day:date,time:time});},formatTimeSinceNow:function(timestamp){var now=new Date(),then=new Date(timestamp);var formattedTime=this.formatTime(timestamp);if(getDaysOfDifference(now,then)>0){return formattedTime;}
var age=now-then;if(age<MINUTE){formattedTime=_('minutes-ago-short',{value:0});}else if(age<HOUR){var minutes=Math.floor(age/MINUTE);formattedTime=_('minutes-ago-short',{value:minutes});}else if(age<DAY){var hours=Math.floor(age/HOUR);formattedTime=_('hours-ago-short',{value:hours});}
return formattedTime;}};}());;'use strict';var NetworkUsageAlarm=(function(){function _addAlarm(networkInterface,value,onsuccess,onerror){if(!networkInterface){console.error('Error, the network interface is not defined when trying '+'to add an alarm');(typeof onerror==='function')&&onerror();return;}
if(value===null||typeof value==='undefined'){console.error('Limit value is undefined, impossible add an alarm');(typeof onerror==='function')&&onerror();return;}
var request=navigator.mozNetworkStats.addAlarm(networkInterface,value);request.onsuccess=onsuccess;request.onerror=function error(e){console.error('Error, when trying to addAlarm to the interfaceId: '+
networkInterface.id+' and limit: '+value);(typeof onerror==='function')&&onerror();};}
function _clearAlarms(networkInterface,callback){if(!networkInterface){console.error('Error, the network interface is not defined when trying '+'to remove alarms');return;}
var request=navigator.mozNetworkStats.getAllAlarms(networkInterface);request.onsuccess=function success(){var alarmList=request.result;var pendingRequest=alarmList.length;function checkForCompletion(){pendingRequest--;if(pendingRequest===0){(typeof callback==='function')&&callback();}}
function _onErrorRemoveAlarm(){console.error('Error when trying to remove one alarm.');checkForCompletion();}
for(var i=0;i<alarmList.length;i++){if(alarmList[i]&&alarmList[i].alarmId){var rA=navigator.mozNetworkStats.removeAlarms(alarmList[i].alarmId);rA.onsuccess=checkForCompletion;rA.onerror=_onErrorRemoveAlarm;}}
if(pendingRequest===0){(typeof callback==='function')&&callback();}};request.onerror=function error(){console.error('Error when trying to get alarms from the API to clear it');};}
function _updateAlarm(dataInterface,value,onsuccess,onerror){if(dataInterface&&value){var addNewAlarm=_addAlarm.bind(null,dataInterface,value,onsuccess,onerror);_clearAlarms(dataInterface,addNewAlarm);}else{if(!dataInterface){console.error('Error, the network interface is not defined when '+'trying to update an alarm');}else{console.error('Error, the data limit value is not defined when '+'trying to update an alarm');}
(typeof onerror==='function')&&onerror();}}
return{updateAlarm:_updateAlarm,clearAlarms:_clearAlarms};}());;var ConfigManager=(function(){'use strict';var today=new Date();var DEFAULT_SETTINGS={'dataLimit':false,'dataLimitValue':1,'dataLimitUnit':'GB','errors':{'INCORRECT_TOPUP_CODE':false,'BALANCE_TIMEOUT':false,'TOPUP_TIMEOUT':false},'fte':true,'waitingForBalance':null,'waitingForTopUp':null,'lastBalance':null,'lastBalanceRequest':null,'lastTopUpRequest':null,'lastDataUsage':{'timestamp':today,'start':today,'end':today,'today':today,'wifi':{'total':0},'mobile':{'total':0}},'lastTelephonyActivity':{'timestamp':today,'calltime':0,'smscount':0},'lastTelephonyReset':today,'lastDataReset':today,'lastCompleteDataReset':today,'lowLimit':false,'lowLimitThreshold':false,'lowLimitNotified':false,'zeroBalanceNotified':false,'dataUsageNotified':false,'nextReset':null,'plantype':'postpaid','resetTime':1,'trackingPeriod':'monthly','isMobileChartVisible':true,'isWifiChartVisible':false};function getApplicationMode(){if(noConfigFound){return'DATA_USAGE_ONLY';}
return settings.plantype.toUpperCase();}
var configuration,configurationIndex,noConfigFound=false;function setConfig(newConfiguration){configuration=newConfiguration;debug('Provider configuration done!');}
function requestConfiguration(callback){var currentDataIcc=Common.dataSimIcc;if(!currentDataIcc||!currentDataIcc.iccInfo){console.error('No iccInfo available');return;}
function returnConfiguration(){if(typeof callback==='function'){callback(configuration);}}
if(configuration){setTimeout(function(){returnConfiguration();});return;}
if(configurationIndex){loadConfiguration(returnConfiguration);}else{loadConfigurationIndex(function onIndex(){loadConfiguration(returnConfiguration);});}}
function loadConfiguration(callback){var configFilePath=getConfigFilePath();LazyLoader.load(configFilePath,callback);}
function getConfigFilePath(){var currentDataIcc=Common.dataSimIcc;var mcc=currentDataIcc.iccInfo.mcc;var mnc=currentDataIcc.iccInfo.mnc;var key=mcc+'_'+mnc;var configDir=configurationIndex[key];if(!configDir){configDir='default';noConfigFound=true;}
return'js/config/'+configDir+'/config.js';}
function loadConfigurationIndex(callback){var xhr=new XMLHttpRequest();xhr.open('GET','/js/config/index.json',true);xhr.overrideMimeType('application/json');xhr.responseType='json';xhr.onload=function onXHRLoad(){if(xhr.status!==200){console.error('Error loading the configuration index! '+'Error code: '+xhr.status);configurationIndex={};}
configurationIndex=xhr.response;if(typeof callback==='function'){setTimeout(function(){callback();});}};xhr.send();}
Date.prototype.toJSON=function(){return{'__date__':this.toISOString()};};function settingsReviver(k,v){if(v===null||typeof v!=='object'||!v.hasOwnProperty('__date__')){return v;}
return new Date(v['__date__']);}
var NO_ICCID='NOICCID';var settings;function requestSettings(callback){var currentICCID=Common.dataSimIccId||NO_ICCID;asyncStorage.getItem(currentICCID,function _wrapGetItem(localSettings){try{settings=JSON.parse(localSettings,settingsReviver);}catch(e){}
if(settings===null){settings=deepCopy(DEFAULT_SETTINGS);debug('Storing default settings for ICCID:',currentICCID);asyncStorage.setItem(currentICCID,JSON.stringify(settings));}
if(callback){callback(settings);}});}
function requestAll(callback){requestConfiguration(function _afterConfig(configuration){requestSettings(function _afterSettings(settings){if(callback){callback(configuration,settings);}});});}
function dispatchOptionChange(name,value,oldValue,settings){var event=new CustomEvent('optionchange',{detail:{name:name,value:value,oldValue:oldValue,settings:settings}});window.dispatchEvent(event);debug('Event optionchange dispatched for',name);}
function setOption(options,callback){if(!settings){requestSettings(function _afterEnsuringSettings(){setOption(options,callback);});return;}
var formerValue={};for(var name in options){if(options.hasOwnProperty(name)){formerValue[name]=settings[name];settings[name]=options[name];}}
var currentICCID=Common.dataSimIccId||NO_ICCID;asyncStorage.setItem(currentICCID,JSON.stringify(settings),function _onSet(){requestSettings(function _onSettings(settings){for(var name in options){if(options.hasOwnProperty(name)){dispatchOptionChange(name,settings[name],formerValue[name],settings);}}});if(callback){callback();}});}
function syncOption(name,value){var oldValue=settings[name];if(value===undefined){return oldValue;}
var update={};update[name]=value;setOption(update);}
var callbacks;function callCallbacks(evt){debug('Option',evt.detail.name,'has changed!');var callbackCollection=callbacks[evt.detail.name]||[];for(var i=0,callback;callback=callbackCollection[i];i++){callback(evt.detail.value,evt.detail.oldValue,evt.detail.name,evt.detail.settings);}}
function syncObserve(name,callback,avoidInitialCall){debug('Installing observer for',name);if(callbacks===undefined){callbacks={};window.addEventListener('storage',function _onSync(evt){if(evt.key==='sync'){var name=evt.newValue.split('#')[0];var oldValue=settings?settings[name]:undefined;debug('Synchronization request for',name,'received!');requestSettings(function _onSettings(newSettings){settings=newSettings;dispatchOptionChange(name,settings[name],oldValue,settings);});}});window.addEventListener('optionchange',callCallbacks);}
if(callbacks[name]===undefined){callbacks[name]=[];}
if(callbacks[name].indexOf(callback)<0){callbacks[name].push(callback);avoidInitialCall=avoidInitialCall||false;if(!avoidInitialCall&&callback){callback(settings[name],null,name,settings);}}}
function syncRemoveObserver(name,callback){var callbackCollection=callbacks[name];if(!callbackCollection){return;}
var index=callbackCollection.indexOf(callback);if(index>-1){callbackCollection.splice(index,1);}}
function defaultValue(name){return deepCopy(DEFAULT_SETTINGS[name]);}
return{getApplicationMode:getApplicationMode,setConfig:setConfig,requestAll:requestAll,requestConfiguration:requestConfiguration,requestSettings:requestSettings,setOption:setOption,defaultValue:defaultValue,option:syncOption,observe:syncObserve,removeObserver:syncRemoveObserver,get configuration(){return configuration;}};}());;'use strict';function addAlarmTimeout(type,delay){var handlerContainer=document.getElementById('message-handler');return handlerContainer.contentWindow.addAlarmTimeout(type,delay);}
function setNextReset(when,callback){var handlerContainer=document.getElementById('message-handler');return handlerContainer?handlerContainer.contentWindow.setNextReset(when,callback):window.setNextReset(when,callback);}
function getTopUpTimeout(callback){var handlerContainer=document.getElementById('message-handler');return handlerContainer?handlerContainer.contentWindow.getTopUpTimeout(callback):window.getTopUpTimeout(callback);}
function addNetworkUsageAlarm(dataInterface,dataLimit,callback){var handlerContainer=document.getElementById('message-handler');if(handlerContainer){handlerContainer.contentWindow.addNetworkUsageAlarm(dataInterface,dataLimit,callback);}else{window.addNetworkUsageAlarm(dataInterface,dataLimit,callback);}}
function updateNextReset(trackingPeriod,value,callback){if(trackingPeriod==='never'){setNextReset(null,callback);return;}
var nextReset,today=new Date();if(trackingPeriod==='monthly'){var month,year;var monthday=parseInt(value,10);month=today.getMonth();year=today.getFullYear();if(today.getDate()>=monthday){month=(month+1)%12;if(month===0){year++;}}
nextReset=new Date(year,month,monthday);}else if(trackingPeriod==='weekly'){var oneDay=24*60*60*1000;var weekday=parseInt(value,10);var daysToTarget=weekday-today.getDay();if(daysToTarget<=0){daysToTarget=7+daysToTarget;}
nextReset=new Date();nextReset.setTime(nextReset.getTime()+oneDay*daysToTarget);toMidnight(nextReset);}
setNextReset(nextReset,callback);}
function resetData(mode,onsuccess,onerror){var currentSimcardInterface=Common.getDataSIMInterface();var wifiInterface=Common.getWifiInterface();var wifiClearRequest,mobileClearRequest;var getOnErrorFor=function(networkInterface){return function(){if(wifiClearRequest){wifiClearRequest.onerror=undefined;}
if(mobileClearRequest){mobileClearRequest.onerror=undefined;}
(typeof onerror==='function')&&onerror(networkInterface);};};if((mode==='all'||mode==='wifi')&&wifiInterface){wifiClearRequest=navigator.mozNetworkStats.clearStats(wifiInterface);wifiClearRequest.onerror=getOnErrorFor('wi-Fi');}
if((mode==='all'||mode==='mobile')&&currentSimcardInterface){mobileClearRequest=navigator.mozNetworkStats.clearStats(currentSimcardInterface);mobileClearRequest.onerror=getOnErrorFor('simcard');mobileClearRequest.onsuccess=function _restoreDataLimitAlarm(){ConfigManager.requestSettings(function _onSettings(settings){if(settings.dataLimit){addNetworkUsageAlarm(currentSimcardInterface,getDataLimit(settings),function _addNetworkUsageAlarmOK(){ConfigManager.setOption({'dataUsageNotified':false});});}});};}
if(mode==='all'){ConfigManager.setOption({lastCompleteDataReset:new Date()});}else{ConfigManager.setOption({lastDataReset:new Date()});}
if(typeof onsuccess==='function'){onsuccess();}}
function resetTelephony(callback){ConfigManager.setOption({lastTelephonyReset:new Date(),lastTelephonyActivity:{calltime:0,smscount:0,timestamp:new Date()}},callback);}
function logResetDataError(networkInterface){console.log('Error when trying to reset '+networkInterface+' interface');}
function resetAll(callback){resetData('all',thenResetTelephony,logResetDataError);function thenResetTelephony(){resetTelephony(callback);}}
function getDataLimit(settings){var multiplier=(settings.dataLimitUnit==='MB')?1000000:1000000000;return settings.dataLimitValue*multiplier;}
function formatTimeHTML(timestampA,timestampB){function timeElement(content){var time=document.createElement('time');time.textContent=content;return time;}
var fragment=document.createDocumentFragment();if(typeof timestampB==='undefined'){fragment.appendChild(timeElement(Formatting.formatTime(timestampA)));return fragment;}
var dateA=new Date(timestampA);var dateB=new Date(timestampB);if(dateA.getFullYear()===dateB.getFullYear()&&dateA.getMonth()===dateB.getMonth()&&dateA.getDay()===dateB.getDay()){return formatTimeHTML(timestampB);}
fragment.appendChild(timeElement(Formatting.formatTime(timestampA,_('short-date-format'))));fragment.appendChild(document.createTextNode(' – '));fragment.appendChild(timeElement(Formatting.formatTime(timestampB)));return fragment;}
function localizeWeekdaySelector(selector){var weekStartsOnMonday=!!parseInt(navigator.mozL10n.get('weekStartsOnMonday'),10);debug('Week starts on monday?',weekStartsOnMonday);var monday=selector.querySelector('.monday');var sunday=selector.querySelector('.sunday');var list=monday.parentNode;if(weekStartsOnMonday){debug('Monday, Tuesday...');list.insertBefore(monday,list.childNodes[0]);list.appendChild(sunday);}else{debug('Sunday, Monday...');list.insertBefore(sunday,list.childNodes[0]);list.insertBefore(monday,sunday.nextSibling);}}
var Common={COST_CONTROL_APP:'app://costcontrol.gaiamobile.org',allNetworkInterfaces:{},dataSimIccId:null,allNetworkInterfaceLoaded:false,dataSimIccIdLoaded:false,dataSimIcc:null,isValidICCID:function(iccid){return typeof iccid==='string'&&iccid.length;},waitForDOMAndMessageHandler:function(window,callback){var docState=document.readyState;var DOMAlreadyLoaded=docState==='complete'||docState==='interactive';var messagesReceived={'DOMContentLoaded':DOMAlreadyLoaded,'messagehandlerready':false};function pendingMessages(){var pending=0;!messagesReceived['DOMContentLoaded']&&pending++;!messagesReceived['messagehandlerready']&&pending++;return pending;}
debug('DOMAlreadyLoaded:',DOMAlreadyLoaded);debug('Waiting for',pendingMessages(),'events to start!');function checkReady(evt){debug(evt.type,'event received!');messagesReceived[evt.type]=true;if(pendingMessages()===0){window.removeEventListener('DOMContentLoaded',checkReady);window.removeEventListener('messagehandlerready',checkReady);debug('DOMContentLoaded and messagehandlerready received. Starting');callback();}}
window.addEventListener('DOMContentLoaded',checkReady);window.addEventListener('messagehandlerready',checkReady);},checkSIM:function(callback,onerror){var currentSIM=Common.dataSimIccId;if(currentSIM===null){console.error('Impossible: or we don\'t have SIM (so this method '+'should not be called) or the RIL is returning null '+'from time to time when checking ICCID.');if(typeof onerror==='function'){onerror();}
return;}
ConfigManager.requestSettings(function _onSettings(settings){if(settings.nextReset){setNextReset(settings.nextReset,callback);return;}
if(callback){callback();}});},startFTE:function(mode){var iframe=document.getElementById('fte_view');window.addEventListener('message',function handler(e){if(e.origin!==Common.COST_CONTROL_APP){return;}
if(e.data.type==='fte_ready'){window.removeEventListener('message',handler);iframe.classList.remove('non-ready');}});iframe.src='/fte.html'+'#'+mode;},closeFTE:function(){var iframe=document.getElementById('fte_view');iframe.classList.add('non-ready');iframe.src='';},startApp:function(){parent.postMessage({type:'fte_finished',data:''},Common.COST_CONTROL_APP);},closeApplication:function(){return setTimeout(function _close(){debug('Closing.');window.close();});},modalAlert:function(message){alert(message);},get localize(){return navigator.mozL10n.localize;},getIccInfo:function _getIccInfo(iccId){if(!iccId){return undefined;}
var iccManager=window.navigator.mozIccManager;var iccInfo=iccManager.getIccById(iccId);if(!iccInfo){console.error('Unrecognized iccID: '+iccId);return undefined;}
return iccInfo;},getInterface:function getInterface(findFunction){if(!Common.allNetworkInterfaceLoaded){debug('Network interfaces are not ready yet');var header=_('data-usage');var msg=_('loading-interface-data');this.modalAlert(header+'\n'+msg);return;}
if(Common.allNetworkInterfaces){return Common.allNetworkInterfaces.find(findFunction);}},getDataSIMInterface:function _getDataSIMInterface(){if(!this.dataSimIccIdLoaded){console.warn('Data simcard is not ready yet');return;}
var iccId=this.dataSimIccId;if(iccId){var findCurrentInterface=function(networkInterface){if(networkInterface.id===iccId){return networkInterface;}};return this.getInterface(findCurrentInterface);}
return undefined;},getWifiInterface:function _getWifiInterface(){var findWifiInterface=function(networkInterface){if(networkInterface.type===navigator.mozNetworkStats.WIFI){return networkInterface;}};return this.getInterface(findWifiInterface);},loadNetworkInterfaces:function(onsuccess,onerror){var networks=navigator.mozNetworkStats.getAvailableNetworks();networks.onsuccess=function(){Common.allNetworkInterfaces=networks.result;Common.allNetworkInterfaceLoaded=true;if(onsuccess){onsuccess();}};networks.onerror=function(){console.error('Error when trying to load network interfaces');if(onerror){onerror();}};},loadDataSIMIccId:function _loadDataSIMIccId(onsuccess,onerror){var settings=navigator.mozSettings,mobileConnections=navigator.mozMobileConnections,dataSlotId=0;var req=settings&&settings.createLock().get('ril.data.defaultServiceId');req.onsuccess=function _onsuccesSlotId(){dataSlotId=req.result['ril.data.defaultServiceId']||0;var mobileConnection=mobileConnections[dataSlotId];var iccId=mobileConnection.iccId||null;if(!iccId){console.error('The slot '+dataSlotId+', configured as the data slot, is empty');(typeof onerror==='function')&&onerror();return;}
Common.dataSimIccId=iccId;Common.dataSimIccIdLoaded=true;Common.dataSimIcc=Common.getIccInfo(iccId);if(onsuccess){onsuccess(iccId);}};req.onerror=function _onerrorSlotId(){console.warn('ril.data.defaultServiceId does not exists');var iccId=null;for(var i=0;i<mobileConnections.length&&!iccId;i++){if(mobileConnections[i]){iccId=mobileConnections[i].iccId;}}
if(!iccId){console.error('No SIM in the device');(typeof onerror==='function')&&onerror();return;}
Common.dataSimIccId=iccId;Common.dataSimIccIdLoaded=true;Common.dataSimIcc=Common.getIccInfo(iccId);if(onsuccess){onsuccess(iccId);}};}};;var CostControl=(function(){'use strict';var costcontrol;function getInstance(onready){debug('Initializing Cost Control');if(costcontrol){debug('Cost Control already ready!');onready(costcontrol);return;}
function setupCostControl(){costcontrol={request:request,isBalanceRequestSMS:isBalanceRequestSMS,getDataUsageWarning:function _getDataUsageWarning(){return 0.8;}};debug('Cost Control ready!');onready(costcontrol);}
loadAPIs();ConfigManager.requestAll(setupCostControl);}
var mobileMessageManager,connection,telephony,statistics;function loadAPIs(){if('mozMobileMessage'in window.navigator){mobileMessageManager=window.navigator.mozMobileMessage;}
if('mozMobileConnection'in window.navigator){connection=window.navigator.mozMobileConnection;}
else if('mozMobileConnections'in window.navigator){connection=window.navigator.mozMobileConnections[0];}
if('mozNetworkStats'in window.navigator){statistics=window.navigator.mozNetworkStats;}
debug('APIs loaded!');}
function isBalanceRequestSMS(message,configuration){return message.receiver===configuration.balance.destination;}
function request(requestObj,callback){ConfigManager.requestAll(function _onInfo(configuration,settings){debug('Request for:',requestObj.type);var force=requestObj.force;var result={};result.type=requestObj.type;switch(requestObj.type){case'balance':var issues=getServiceIssues(configuration,settings);var canBeIgnoredByForcing=(issues==='minimum_delay'&&force);if(issues&&!canBeIgnoredByForcing){result.status='error';result.details=issues;result.data=settings.lastBalance;if(callback){callback(result);}
return;}
var costIssues=getCostIssues(configuration);if(!force&&costIssues){result.status='error';result.details=costIssues;result.data=settings.lastBalance;if(callback){callback(result);}
return;}
var isWaiting=settings.waitingForBalance!==null;var timeout=Toolkit.checkEnoughDelay(BALANCE_TIMEOUT,settings.lastBalanceRequest);if(isWaiting&&!timeout){result.status='in_progress';result.data=settings.lastBalance;if(callback){callback(result);}
return;}
requestBalance(configuration,settings,callback,result);break;case'topup':var issues=getServiceIssues(configuration,settings);if(issues&&issues!=='minimum_delay'){result.status='error';result.details=issues;result.data=settings.lastDataUsage;if(callback){callback(result);}
return;}
var costIssues=getCostIssues(configuration);if(!force&&costIssues){result.status='error';result.details=costIssues;result.data=settings.lastBalance;if(callback){callback(result);}
return;}
var isWaiting=settings.waitingForTopUp!==null;var timeout=Toolkit.checkEnoughDelay(BALANCE_TIMEOUT,settings.lastTopUpRequest);if(isWaiting&&!timeout&&!force){result.status='in_progress';result.data=settings.lastDataUsage;if(callback){callback(result);}
return;}
var code=requestObj.data;requestTopUp(configuration,settings,code,callback,result);break;case'datausage':requestDataStatistics(configuration,settings,callback,result);break;case'telephony':result.data=settings.lastTelephonyActivity;result.status='success';if(callback){callback(result);}
break;}
return;});}
function getServiceIssues(configuration,settings){if(airplaneMode){return'airplane_mode';}
if(!connection||!connection.voice||!connection.data){return'no_service';}
var mode=ConfigManager.getApplicationMode();if(mode!=='PREPAID'){return'no_service';}
var voice=connection.voice;if(!voice.connected){return'no_service';}
if(voice.relSignalStrength===null){return'no_coverage';}
if(configuration.balance.minimum_delay){var isMinimumDelayHonored=Toolkit.checkEnoughDelay(configuration.balance.minimum_delay,settings.lastBalanceRequest);if(!isMinimumDelayHonored){return'minimum_delay';}}
return'';}
function getCostIssues(configuration){var inRoaming=connection.voice.roaming;if(inRoaming&&configuration.is_roaming_free!==true){return'non_free_in_roaming';}
if(!inRoaming&&configuration.is_free!==true){return'non_free';}
return'';}
var BALANCE_TIMEOUT=5*60*1000;function requestBalance(configuration,settings,callback,result){debug('Requesting balance...');result.data=settings.lastBalance;var newSMS=mobileMessageManager.send(configuration.balance.destination,configuration.balance.text);newSMS.onsuccess=function _onSuccess(){debug('Request SMS sent! Waiting for response.');var newAlarm=addAlarmTimeout('balanceTimeout',BALANCE_TIMEOUT);newAlarm.onsuccess=function _alarmSet(evt){var id=evt.target.result;debug('Timeout for balance (',id,') update set to:',BALANCE_TIMEOUT);ConfigManager.setOption({'waitingForBalance':id,'lastBalanceRequest':new Date()},function _onSet(){result.status='success';if(callback){callback(result);}});};newAlarm.onerror=function _alarmFailedToSet(evt){debug('Failed to set timeout for balance request!');result.status='error';result.details='timout_fail';if(callback){callback(result);}};};newSMS.onerror=function _onError(){debug('Request SMS failed! But returning stored balance.');result.status='error';result.details='request_fail';if(callback){callback(result);}};debug('Balance out of date. Requesting fresh data...');}
var TOPUP_TIMEOUT=5*60*1000;function requestTopUp(configuration,settings,code,callback,result){debug('Requesting TopUp with code',code,'...');var newSMS=mobileMessageManager.send(configuration.topup.destination,configuration.topup.text.replace(/\&code/g,code));newSMS.onsuccess=function _onSuccess(){debug('TopUp SMS sent! Waiting for response.');var newAlarm=addAlarmTimeout('topupTimeout',TOPUP_TIMEOUT);newAlarm.onsuccess=function _alarmSet(evt){var id=evt.target.result;debug('Timeout for TopUp (',id,') update set to:',TOPUP_TIMEOUT);ConfigManager.setOption({'waitingForTopUp':id,'lastTopUpRequest':new Date()},function _onSet(){result.status='success';if(callback){callback(result);}});};newAlarm.onerror=function _alarmFailedToSet(evt){debug('Failed to set timeout for TopUp request!');result.status='error';result.details='timeout_fail';if(callback){callback(result);}};};newSMS.onerror=function _onError(){debug('TopUp SMS failed!');result.status='error';result.details='request_fail';if(callback){callback(result);}};}
var DAY=24*3600*1000;function requestDataStatistics(configuration,settings,callback,result){debug('Statistics out of date. Requesting fresh data...');var maxAge=1000*statistics.maxStorageAge;var minimumStart=new Date(Date.now()-maxAge);debug('The max age for samples is '+minimumStart);var start=new Date(settings.lastCompleteDataReset||Date.now()-7*DAY);if(start<minimumStart){console.warn('Start date is surpassing the maximum age for the '+'samples. Setting to '+minimumStart);start=minimumStart;}
start=toMidnight(start);var today=toMidnight(new Date());var tomorrow=new Date();tomorrow.setTime(today.getTime()+DAY);var end=toMidnight(settings.nextReset?new Date(settings.nextReset.getTime()-DAY):tomorrow);if(start>end){console.error('Start date is higher than end date. This must not '+'happen. Maybe the clock has changed');end=new Date(start.getTime()+DAY);}
var wifiInterface=Common.getWifiInterface();var currentSimcardNetwork=Common.getDataSIMInterface();var simRequest,wifiRequest;var pendingRequests=0;function checkForCompletion(){pendingRequests--;if(pendingRequests===0){updateDataUsage();}};function updateDataUsage(){var fakeEmptyResult={data:[]};var wifiData=adaptData(wifiRequest?wifiRequest.result:fakeEmptyResult);var mobileData=adaptData(simRequest?simRequest.result:fakeEmptyResult);var lastDataUsage={timestamp:new Date(),start:start,end:end,today:today,wifi:{total:wifiData[1]},mobile:{total:mobileData[1]}};ConfigManager.setOption({'lastDataUsage':lastDataUsage},function _onSetItem(){debug('Statistics up to date and stored.');});lastDataUsage.wifi.samples=wifiData[0];lastDataUsage.mobile.samples=mobileData[0];result.status='success';result.data=lastDataUsage;debug('Returning up to date statistics.');if(callback){callback(result);}}
if(currentSimcardNetwork){pendingRequests++;simRequest=statistics.getSamples(currentSimcardNetwork,start,end);simRequest.onsuccess=checkForCompletion;}
if(wifiInterface){pendingRequests++;wifiRequest=statistics.getSamples(wifiInterface,start,end);wifiRequest.onsuccess=checkForCompletion;}
if(pendingRequests===0){updateDataUsage();}}
function adaptData(networkStatsResult){var data=networkStatsResult.data;var output=[];var totalData,accum=0;for(var i=0,item;item=data[i];i++){if(item.txBytes===undefined){output.push({date:item.date});continue;}
totalData=0;if(item.rxBytes){totalData+=item.rxBytes;}
if(item.txBytes){totalData+=item.txBytes;}
accum+=totalData;output.push({value:totalData,date:item.date});}
return[output,accum];}
var airplaneMode=false;function init(){SettingsListener.observe('ril.radio.disabled',false,function _onValue(value){airplaneMode=value;});}
return{init:init,getInstance:getInstance};}());;CostControl.init();;'use strict';function NonReadyScreen(container){this.id=container.id;this.container=container;this.activity=container.querySelector('progress');this.header=container.querySelector('h3');this.message=container.querySelector('p');this.button=container.querySelector('button');this.button.onclick=Common.closeApplication;}
NonReadyScreen.prototype.updateForState=function(cardState){switch(cardState){case null:case'absent':case'pinRequired':case'pukRequired':this.setMessageMode(cardState);break;default:this.setWaitingMode();break;}};NonReadyScreen.prototype.setMessageMode=function(cardState){this.activity.setAttribute('aria-hidden',true);[this.header,this.message,this.button.parentNode].forEach(function(el){el.setAttribute('aria-hidden',false);});var messageId=this.getMessageIdFor(cardState);if(messageId){var header=_('widget-'+messageId+'-heading');var msg=_('widget-'+messageId+'-meta');this.header.textContent=header;this.message.textContent=msg;}};NonReadyScreen.prototype.setWaitingMode=function(){this.activity.setAttribute('aria-hidden',false);[this.header,this.message,this.button.parentNode].forEach(function(el){el.setAttribute('aria-hidden',true);});};NonReadyScreen.prototype.getMessageIdFor=function(cardState){var message;if(!cardState||cardState==='absent'){message='no-sim2';}else if(cardState==='pinRequired'||cardState==='pukRequired'){message='sim-locked';}
return message;};;'use strict';var ViewManager=(function(){function ViewManager(tabs){tabs=tabs||[];this._tabs={};tabs.forEach(function _registerTab(tabItem){if(typeof tabItem!=='object'){tabItem={id:tabItem};}
this._tabs[tabItem.id]=tabItem.tab||'left';},this);this._currentView=null;this._currentTab=null;};ViewManager.prototype._isTab=function _isTab(view){return this._tabs.hasOwnProperty(view);};ViewManager.prototype.changeViewTo=function _changeViewTo(viewId,callback){if(this.isCurrentView(viewId)){return;}
var previousViewId,currentViewId;previousViewId=currentViewId=this._currentView?this._currentView.id:null;var view=document.getElementById(viewId);this.loadPanel(view);var isTab=this._isTab(viewId);if(isTab){var disposingTab=null;if(this._currentTab){disposingTab=document.getElementById(this._currentTab);}
if(disposingTab){disposingTab.dataset.viewport=this._tabs[disposingTab.id];document.getElementById(disposingTab.id+'-filter').setAttribute('aria-selected','false');}
view.dataset.viewport='';document.getElementById(view.id+'-filter').setAttribute('aria-selected','true');this._currentTab=viewId;}else{this.closeCurrentView();var previousViewId=this._currentView?this._currentView.id:'';this._currentView={id:viewId,defaultViewport:view.dataset.viewport};delete view.dataset.viewport;}
if(callback){callback(isTab,viewId,isTab?currentViewId:previousViewId);}
notifyViewChange(isTab,viewId);};function notifyViewChange(isTab,current){var type=isTab?'tabchanged':'viewchanged';var event=new CustomEvent(type,{detail:current});window.dispatchEvent(event);}
ViewManager.prototype.loadPanel=function _loadPanel(panel){if(!panel||panel.hidden===false)return;for(var i=0;i<panel.childNodes.length;i++){if(panel.childNodes[i].nodeType==document.COMMENT_NODE){panel.innerHTML=panel.childNodes[i].nodeValue;break;}}
var styles=panel.querySelectorAll('link');for(var i=0;i<styles.length;i++){var styleHref=styles[i].href;if(!document.getElementById(styleHref)){var style=document.createElement('link');style.href=style.id=styleHref;style.rel='stylesheet';style.type='text/css';style.media='all';document.head.appendChild(style);}}
navigator.mozL10n.translate(panel);var scripts=panel.querySelectorAll('script');for(var i=0;i<scripts.length;i++){var src=scripts[i].getAttribute('src');if(!document.getElementById(src)){var script=document.createElement('script');script.type='application/javascript';script.src=script.id=src;document.head.appendChild(script);}}
var closeButtons=panel.querySelectorAll('.close-dialog');[].forEach.call(closeButtons,function(closeButton){closeButton.addEventListener('click',function(){window.parent.location.hash='#';});});panel.hidden=false;};ViewManager.prototype.closeCurrentView=function _closeCurrentView(){if(!this._currentView){return;}
var view=document.getElementById(this._currentView.id);view.dataset.viewport=this._currentView.defaultViewport;this._currentView=null;};ViewManager.prototype.isCurrentView=function _isCurrentView(view){return this._currentView&&this._currentView.id===view;};ViewManager.prototype.getCurrentView=function _getCurrentView(){return this._currentView?this._currentView.id:null;};ViewManager.prototype.isCurrentTab=function _isCurrentTab(tab){return this._currentTab&&this._currentTab===tab;};ViewManager.prototype.getCurrentTab=function _getCurrentTab(){return this._currentTab;};return ViewManager;}());;var CostControlApp=(function(){'use strict';var costcontrol,initialized=false;var vmanager;function waitForSIMReady(callback){Common.loadDataSIMIccId(function _onIccId(iccid){var iccid=Common.dataSimIccId;var dataSimIccInfo=Common.dataSimIcc;var cardState=dataSimIccInfo&&dataSimIccInfo.cardState;if(cardState!=='ready'){showNonReadyScreen(cardState);debug('SIM not ready:',cardState);dataSimIccInfo.oncardstatechange=function(){waitForSIMReady(callback);};}else if(!Common.isValidICCID(iccid)){showNonReadyScreen(cardState);debug('ICC info not ready yet');dataSimIccInfo.oniccinfochange=function(){waitForSIMReady(callback);};}else{hideNotReadyScreen();debug('SIM ready. ICCID:',iccid);dataSimIccInfo.oncardstatechange=undefined;dataSimIccInfo.oniccinfochange=undefined;callback&&callback();}},function _errorNoSim(){console.warn('Error when trying to get the ICC ID');showNonReadyScreen(null);});}
var nonReadyScreen;function showNonReadyScreen(cardState){if(isApplicationLocalized){realshowNonReadyScreen(cardState);}else{window.addEventListener('localized',function _onlocalized(){window.removeEventListener('localized',_onlocalized);realshowNonReadyScreen(cardState);});}
function realshowNonReadyScreen(messageId){debug('Showing non-ready screen.');if(!nonReadyScreen){nonReadyScreen=new NonReadyScreen(document.getElementById('non-ready-screen'));}
nonReadyScreen.updateForState(cardState);vmanager.changeViewTo(nonReadyScreen.id);}}
function hideNotReadyScreen(status){debug('Hiding non-ready screen.');if(vmanager.getCurrentView()==='non-ready-screen'){vmanager.closeCurrentView();}
return;}
var tabmanager,settingsVManager;function setupCardHandler(){tabmanager=new ViewManager(['balance-tab','telephony-tab',{id:'datausage-tab',tab:'right'}]);settingsVManager=new ViewManager();window.addEventListener('hashchange',function _onHashChange(evt){var parser=document.createElement('a');parser.href=evt.oldURL;var oldHash=parser.hash.split('#');parser.href=evt.newURL;var newHash=parser.hash.split('#');if(newHash.length>3){console.error('Cost Control bad URL schema');return;}
debug('URL schema before normalizing:',newHash);var normalized=false;if(newHash[1]===''&&oldHash[1]){newHash[1]=oldHash[1];normalized=true;}
if(newHash.length===3&&newHash[2]===''){if(oldHash.length===3){newHash[2]=oldHash[2];}else{newHash=newHash.slice(0,2);}
normalized=true;}
if(normalized){debug('URL schema after normalization:',newHash);window.location.hash=newHash.join('#');return;}
if(newHash[1]){tabmanager.changeViewTo(newHash[1]);}
if(newHash.length<3){vmanager.closeCurrentView();}else{vmanager.changeViewTo(newHash[2]);}});}
function clearLastSimScenario(callback){Common.closeFTE();(typeof callback==='function')&&callback();}
function startApp(callback){function _onNoICCID(){console.error('checkSIM() failed. Impossible to ensure consistent'+'data. Aborting start up.');showSimErrorDialog('no-sim2');}
Common.checkSIM(function _onSIMChecked(){CostControl.getInstance(function _onCostControlReady(instance){if(ConfigManager.option('fte')){startFTE();return;}
costcontrol=instance;if(!initialized){setupApp(callback);}else{loadSettings();updateUI(callback);}});},_onNoICCID);}
var isApplicationLocalized=false;window.addEventListener('localized',function _onLocalize(){isApplicationLocalized=true;if(initialized){updateUI();}});function setupApp(callback){setupCardHandler();var settingsButtons=document.querySelectorAll('.settings-button');Array.prototype.forEach.call(settingsButtons,function _eachSettingsButton(button){button.addEventListener('click',function _showSettings(){window.location.hash='##settings-view';});});navigator.mozSetMessageHandler('activity',function _handleActivity(activityRequest){var name=activityRequest.source.name;switch(name){case'costcontrol/balance':window.location.hash='#balance-tab';break;case'costcontrol/telephony':window.location.hash='#telephony-tab';break;case'costcontrol/data_usage':window.location.hash='#datausage-tab';break;}});window.navigator.mozSetMessageHandler('notification',function _onNotification(notification){if(!notification.clicked){return;}
debug('Notification was clicked!');navigator.mozApps.getSelf().onsuccess=function _onAppReady(evt){var app=evt.target.result;app.launch();var type=notification.imageURL.split('?')[1];debug('Notification type:',type);handleNotification(type);};});document.addEventListener('visibilitychange',function _onVisibilityChange(evt){if(!document.hidden&&initialized){waitForSIMReady();}});updateUI(callback);ConfigManager.observe('plantype',updateUI,true);var isFirstCall=true;SettingsListener.observe('ril.data.defaultServiceId',0,function(){if(!isFirstCall){clearLastSimScenario(Common.loadDataSIMIccId.bind(null,startApp));}else{isFirstCall=false;}});initialized=true;loadSettings();}
function loadSettings(){document.getElementById('settings-view-placeholder').src='settings.html';}
function handleNotification(type){switch(type){case'topUpError':BalanceTab.topUpWithCode(true);break;case'lowBalance':case'zeroBalance':window.location.hash='#balance-tab';break;case'dataUsage':tabmanager.changeViewTo('datausage-tab');break;}}
var currentMode;function updateUI(callback){ConfigManager.requestSettings(function _onSettings(settings){var mode=ConfigManager.getApplicationMode();debug('App UI mode: ',mode);if(mode!==currentMode){currentMode=mode;if(mode==='DATA_USAGE_ONLY'){var tabs=document.getElementById('tabs');tabs.setAttribute('aria-hidden',true);var dataUsageTab=document.getElementById('datausage-tab');dataUsageTab.classList.add('standalone');window.location.hash='#datausage-tab';}else{document.getElementById('balance-tab-filter').setAttribute('aria-hidden',(mode!=='PREPAID'));document.getElementById('telephony-tab-filter').setAttribute('aria-hidden',(mode!=='POSTPAID'));if(!isDataUsageTabShown()){window.location.hash=(mode==='PREPAID')?'#balance-tab#':'#telephony-tab#';}}
setTimeout(function continueLoading(){if(typeof callback==='function'){window.setTimeout(callback,0);}
document.getElementById('main').classList.remove('non-ready');if(mode==='PREPAID'){if(typeof TelephonyTab!=='undefined'){TelephonyTab.finalize();}
if(typeof BalanceTab!=='undefined'){BalanceTab.initialize();}}else if(mode==='POSTPAID'){if(typeof BalanceTab!=='undefined'){BalanceTab.finalize();}
if(typeof TelephonyTab!=='undefined'){TelephonyTab.initialize();}}});}});}
function isDataUsageTabShown(){return window.location.hash.split('#')[1]==='datausage-tab';}
function startFTE(){window.addEventListener('message',function handler_finished(e){if(e.origin!==Common.COST_CONTROL_APP){return;}
var type=e.data.type;if(type==='fte_finished'){window.removeEventListener('message',handler_finished);document.getElementById('splash_section').setAttribute('aria-hidden','true');startApp(Common.closeFTE);}});var mode=ConfigManager.getApplicationMode();Common.startFTE(mode);}
return{init:function(){vmanager=new ViewManager();waitForSIMReady(function _onSIMReady(){document.getElementById('message-handler').src='message_handler.html';Common.waitForDOMAndMessageHandler(window,startApp);});Common.loadNetworkInterfaces();},reset:function(){costcontrol=null;initialized=false;vmanager=null;tabmanager=null;settingsVManager=null;currentMode=null;isApplicationLocalized=false;window.location.hash='';nonReadyScreen=null;},showBalanceTab:function _showBalanceTab(){window.location.hash='#balance-tab';},showDataUsageTab:function _showDataUsageTab(){window.location.hash='#datausage-tab';}};}());;'use strict';CostControlApp.init();