;'use strict';(function(exports){const kEventName='statechange';const kCommunicationKey='airplaneMode.enabled';const kStatusKey='airplaneMode.status';var AirplaneModeHelper={_mozSettings:window.navigator.mozSettings,_callbacks:[],_cachedStatus:'',ready:function(cb){if(this._cachedStatus===''){var self=this;this.addEventListener(kEventName,function onChangeEvent(){if(self._cachedStatus!==''){self.removeEventListener(kEventName,onChangeEvent);cb();}});}else{cb();}},getStatus:function(){return this._cachedStatus;},addEventListener:function(eventName,callback){if(eventName===kEventName){this._callbacks.push(callback);}},removeEventListener:function(eventName,callback){if(eventName===kEventName){var index=this._callbacks.indexOf(callback);if(index>=0){this._callbacks.splice(index,1);}}},setEnabled:function(enabled){this.ready(function(){var status=this.getStatus();if(status==='enabling'||status==='disabling'){}else{if(enabled&&status==='enabled'||!enabled&&status==='disabled'){return;}
var setObj={};setObj[kCommunicationKey]=enabled;this._mozSettings.createLock().set(setObj);}}.bind(this));},init:function(){var self=this;var lock=window.navigator.mozSettings.createLock();var req=lock.get(kStatusKey);req.onsuccess=function(){self._cachedStatus=req.result[kStatusKey];self._callbacks.forEach(function(callback){callback(self._cachedStatus);});};this._mozSettings.addObserver(kStatusKey,function(evt){var currentStatus=evt.settingValue;self._cachedStatus=currentStatus;self._callbacks.forEach(function(callback){callback(currentStatus);});});}};exports.AirplaneModeHelper=AirplaneModeHelper;AirplaneModeHelper.init();})(this);;var ConfigManager=(function(){'use strict';var today=new Date();var DEFAULT_SETTINGS={'dataLimit':false,'dataLimitValue':1,'dataLimitUnit':'GB','errors':{'INCORRECT_TOPUP_CODE':false,'BALANCE_TIMEOUT':false,'TOPUP_TIMEOUT':false},'fte':true,'waitingForBalance':null,'waitingForTopUp':null,'lastBalance':null,'lastBalanceRequest':null,'lastTopUpRequest':null,'lastDataUsage':{'timestamp':today,'start':today,'end':today,'today':today,'wifi':{'total':0},'mobile':{'total':0}},'lastTelephonyActivity':{'timestamp':today,'calltime':0,'smscount':0},'lastTelephonyReset':today,'lastDataReset':today,'lastCompleteDataReset':today,'lowLimit':false,'lowLimitThreshold':false,'lowLimitNotified':false,'zeroBalanceNotified':false,'dataUsageNotified':false,'nextReset':null,'plantype':'postpaid','resetTime':1,'trackingPeriod':'monthly','isMobileChartVisible':true,'isWifiChartVisible':false};function getApplicationMode(){if(noConfigFound){return'DATA_USAGE_ONLY';}
return settings.plantype.toUpperCase();}
var configuration,configurationIndex,noConfigFound=false;function setConfig(newConfiguration){configuration=newConfiguration;debug('Provider configuration done!');}
function requestConfiguration(callback){var currentDataIcc=Common.dataSimIcc;if(!currentDataIcc||!currentDataIcc.iccInfo){console.error('No iccInfo available');return;}
function returnConfiguration(){if(typeof callback==='function'){callback(configuration);}}
if(configuration){setTimeout(function(){returnConfiguration();});return;}
if(configurationIndex){loadConfiguration(returnConfiguration);}else{loadConfigurationIndex(function onIndex(){loadConfiguration(returnConfiguration);});}}
function loadConfiguration(callback){var configFilePath=getConfigFilePath();LazyLoader.load(configFilePath,callback);}
function getConfigFilePath(){var currentDataIcc=Common.dataSimIcc;var mcc=currentDataIcc.iccInfo.mcc;var mnc=currentDataIcc.iccInfo.mnc;var key=mcc+'_'+mnc;var configDir=configurationIndex[key];if(!configDir){configDir='default';noConfigFound=true;}
return'js/config/'+configDir+'/config.js';}
function loadConfigurationIndex(callback){var xhr=new XMLHttpRequest();xhr.open('GET','/js/config/index.json',true);xhr.overrideMimeType('application/json');xhr.responseType='json';xhr.onload=function onXHRLoad(){if(xhr.status!==200){console.error('Error loading the configuration index! '+'Error code: '+xhr.status);configurationIndex={};}
configurationIndex=xhr.response;if(typeof callback==='function'){setTimeout(function(){callback();});}};xhr.send();}
Date.prototype.toJSON=function(){return{'__date__':this.toISOString()};};function settingsReviver(k,v){if(v===null||typeof v!=='object'||!v.hasOwnProperty('__date__')){return v;}
return new Date(v['__date__']);}
var NO_ICCID='NOICCID';var settings;function requestSettings(callback){var currentICCID=Common.dataSimIccId||NO_ICCID;asyncStorage.getItem(currentICCID,function _wrapGetItem(localSettings){try{settings=JSON.parse(localSettings,settingsReviver);}catch(e){}
if(settings===null){settings=deepCopy(DEFAULT_SETTINGS);debug('Storing default settings for ICCID:',currentICCID);asyncStorage.setItem(currentICCID,JSON.stringify(settings));}
if(callback){callback(settings);}});}
function requestAll(callback){requestConfiguration(function _afterConfig(configuration){requestSettings(function _afterSettings(settings){if(callback){callback(configuration,settings);}});});}
function dispatchOptionChange(name,value,oldValue,settings){var event=new CustomEvent('optionchange',{detail:{name:name,value:value,oldValue:oldValue,settings:settings}});window.dispatchEvent(event);debug('Event optionchange dispatched for',name);}
function setOption(options,callback){if(!settings){requestSettings(function _afterEnsuringSettings(){setOption(options,callback);});return;}
var formerValue={};for(var name in options){if(options.hasOwnProperty(name)){formerValue[name]=settings[name];settings[name]=options[name];}}
var currentICCID=Common.dataSimIccId||NO_ICCID;asyncStorage.setItem(currentICCID,JSON.stringify(settings),function _onSet(){requestSettings(function _onSettings(settings){for(var name in options){if(options.hasOwnProperty(name)){dispatchOptionChange(name,settings[name],formerValue[name],settings);}}});if(callback){callback();}});}
function syncOption(name,value){var oldValue=settings[name];if(value===undefined){return oldValue;}
var update={};update[name]=value;setOption(update);}
var callbacks;function callCallbacks(evt){debug('Option',evt.detail.name,'has changed!');var callbackCollection=callbacks[evt.detail.name]||[];for(var i=0,callback;callback=callbackCollection[i];i++){callback(evt.detail.value,evt.detail.oldValue,evt.detail.name,evt.detail.settings);}}
function syncObserve(name,callback,avoidInitialCall){debug('Installing observer for',name);if(callbacks===undefined){callbacks={};window.addEventListener('storage',function _onSync(evt){if(evt.key==='sync'){var name=evt.newValue.split('#')[0];var oldValue=settings?settings[name]:undefined;debug('Synchronization request for',name,'received!');requestSettings(function _onSettings(newSettings){settings=newSettings;dispatchOptionChange(name,settings[name],oldValue,settings);});}});window.addEventListener('optionchange',callCallbacks);}
if(callbacks[name]===undefined){callbacks[name]=[];}
if(callbacks[name].indexOf(callback)<0){callbacks[name].push(callback);avoidInitialCall=avoidInitialCall||false;if(!avoidInitialCall&&callback){callback(settings[name],null,name,settings);}}}
function syncRemoveObserver(name,callback){var callbackCollection=callbacks[name];if(!callbackCollection){return;}
var index=callbackCollection.indexOf(callback);if(index>-1){callbackCollection.splice(index,1);}}
function defaultValue(name){return deepCopy(DEFAULT_SETTINGS[name]);}
return{getApplicationMode:getApplicationMode,setConfig:setConfig,requestAll:requestAll,requestConfiguration:requestConfiguration,requestSettings:requestSettings,setOption:setOption,defaultValue:defaultValue,option:syncOption,observe:syncObserve,removeObserver:syncRemoveObserver,get configuration(){return configuration;}};}());;'use strict';function addAlarmTimeout(type,delay){var handlerContainer=document.getElementById('message-handler');return handlerContainer.contentWindow.addAlarmTimeout(type,delay);}
function setNextReset(when,callback){var handlerContainer=document.getElementById('message-handler');return handlerContainer?handlerContainer.contentWindow.setNextReset(when,callback):window.setNextReset(when,callback);}
function getTopUpTimeout(callback){var handlerContainer=document.getElementById('message-handler');return handlerContainer?handlerContainer.contentWindow.getTopUpTimeout(callback):window.getTopUpTimeout(callback);}
function addNetworkUsageAlarm(dataInterface,dataLimit,callback){var handlerContainer=document.getElementById('message-handler');if(handlerContainer){handlerContainer.contentWindow.addNetworkUsageAlarm(dataInterface,dataLimit,callback);}else{window.addNetworkUsageAlarm(dataInterface,dataLimit,callback);}}
function updateNextReset(trackingPeriod,value,callback){if(trackingPeriod==='never'){setNextReset(null,callback);return;}
var nextReset,today=new Date();if(trackingPeriod==='monthly'){var month,year;var monthday=parseInt(value,10);month=today.getMonth();year=today.getFullYear();if(today.getDate()>=monthday){month=(month+1)%12;if(month===0){year++;}}
nextReset=new Date(year,month,monthday);}else if(trackingPeriod==='weekly'){var oneDay=24*60*60*1000;var weekday=parseInt(value,10);var daysToTarget=weekday-today.getDay();if(daysToTarget<=0){daysToTarget=7+daysToTarget;}
nextReset=new Date();nextReset.setTime(nextReset.getTime()+oneDay*daysToTarget);toMidnight(nextReset);}
setNextReset(nextReset,callback);}
function resetData(mode,onsuccess,onerror){var currentSimcardInterface=Common.getDataSIMInterface();var wifiInterface=Common.getWifiInterface();var wifiClearRequest,mobileClearRequest;var getOnErrorFor=function(networkInterface){return function(){if(wifiClearRequest){wifiClearRequest.onerror=undefined;}
if(mobileClearRequest){mobileClearRequest.onerror=undefined;}
(typeof onerror==='function')&&onerror(networkInterface);};};if((mode==='all'||mode==='wifi')&&wifiInterface){wifiClearRequest=navigator.mozNetworkStats.clearStats(wifiInterface);wifiClearRequest.onerror=getOnErrorFor('wi-Fi');}
if((mode==='all'||mode==='mobile')&&currentSimcardInterface){mobileClearRequest=navigator.mozNetworkStats.clearStats(currentSimcardInterface);mobileClearRequest.onerror=getOnErrorFor('simcard');mobileClearRequest.onsuccess=function _restoreDataLimitAlarm(){ConfigManager.requestSettings(function _onSettings(settings){if(settings.dataLimit){addNetworkUsageAlarm(currentSimcardInterface,getDataLimit(settings),function _addNetworkUsageAlarmOK(){ConfigManager.setOption({'dataUsageNotified':false});});}});};}
if(mode==='all'){ConfigManager.setOption({lastCompleteDataReset:new Date()});}else{ConfigManager.setOption({lastDataReset:new Date()});}
if(typeof onsuccess==='function'){onsuccess();}}
function resetTelephony(callback){ConfigManager.setOption({lastTelephonyReset:new Date(),lastTelephonyActivity:{calltime:0,smscount:0,timestamp:new Date()}},callback);}
function logResetDataError(networkInterface){console.log('Error when trying to reset '+networkInterface+' interface');}
function resetAll(callback){resetData('all',thenResetTelephony,logResetDataError);function thenResetTelephony(){resetTelephony(callback);}}
function getDataLimit(settings){var multiplier=(settings.dataLimitUnit==='MB')?1000000:1000000000;return settings.dataLimitValue*multiplier;}
function formatTimeHTML(timestampA,timestampB){function timeElement(content){var time=document.createElement('time');time.textContent=content;return time;}
var fragment=document.createDocumentFragment();if(typeof timestampB==='undefined'){fragment.appendChild(timeElement(Formatting.formatTime(timestampA)));return fragment;}
var dateA=new Date(timestampA);var dateB=new Date(timestampB);if(dateA.getFullYear()===dateB.getFullYear()&&dateA.getMonth()===dateB.getMonth()&&dateA.getDay()===dateB.getDay()){return formatTimeHTML(timestampB);}
fragment.appendChild(timeElement(Formatting.formatTime(timestampA,_('short-date-format'))));fragment.appendChild(document.createTextNode(' – '));fragment.appendChild(timeElement(Formatting.formatTime(timestampB)));return fragment;}
function localizeWeekdaySelector(selector){var weekStartsOnMonday=!!parseInt(navigator.mozL10n.get('weekStartsOnMonday'),10);debug('Week starts on monday?',weekStartsOnMonday);var monday=selector.querySelector('.monday');var sunday=selector.querySelector('.sunday');var list=monday.parentNode;if(weekStartsOnMonday){debug('Monday, Tuesday...');list.insertBefore(monday,list.childNodes[0]);list.appendChild(sunday);}else{debug('Sunday, Monday...');list.insertBefore(sunday,list.childNodes[0]);list.insertBefore(monday,sunday.nextSibling);}}
var Common={COST_CONTROL_APP:'app://costcontrol.gaiamobile.org',allNetworkInterfaces:{},dataSimIccId:null,allNetworkInterfaceLoaded:false,dataSimIccIdLoaded:false,dataSimIcc:null,isValidICCID:function(iccid){return typeof iccid==='string'&&iccid.length;},waitForDOMAndMessageHandler:function(window,callback){var docState=document.readyState;var DOMAlreadyLoaded=docState==='complete'||docState==='interactive';var messagesReceived={'DOMContentLoaded':DOMAlreadyLoaded,'messagehandlerready':false};function pendingMessages(){var pending=0;!messagesReceived['DOMContentLoaded']&&pending++;!messagesReceived['messagehandlerready']&&pending++;return pending;}
debug('DOMAlreadyLoaded:',DOMAlreadyLoaded);debug('Waiting for',pendingMessages(),'events to start!');function checkReady(evt){debug(evt.type,'event received!');messagesReceived[evt.type]=true;if(pendingMessages()===0){window.removeEventListener('DOMContentLoaded',checkReady);window.removeEventListener('messagehandlerready',checkReady);debug('DOMContentLoaded and messagehandlerready received. Starting');callback();}}
window.addEventListener('DOMContentLoaded',checkReady);window.addEventListener('messagehandlerready',checkReady);},checkSIM:function(callback,onerror){var currentSIM=Common.dataSimIccId;if(currentSIM===null){console.error('Impossible: or we don\'t have SIM (so this method '+'should not be called) or the RIL is returning null '+'from time to time when checking ICCID.');if(typeof onerror==='function'){onerror();}
return;}
ConfigManager.requestSettings(function _onSettings(settings){if(settings.nextReset){setNextReset(settings.nextReset,callback);return;}
if(callback){callback();}});},startFTE:function(mode){var iframe=document.getElementById('fte_view');window.addEventListener('message',function handler(e){if(e.origin!==Common.COST_CONTROL_APP){return;}
if(e.data.type==='fte_ready'){window.removeEventListener('message',handler);iframe.classList.remove('non-ready');}});iframe.src='/fte.html'+'#'+mode;},closeFTE:function(){var iframe=document.getElementById('fte_view');iframe.classList.add('non-ready');iframe.src='';},startApp:function(){parent.postMessage({type:'fte_finished',data:''},Common.COST_CONTROL_APP);},closeApplication:function(){return setTimeout(function _close(){debug('Closing.');window.close();});},modalAlert:function(message){alert(message);},get localize(){return navigator.mozL10n.localize;},getIccInfo:function _getIccInfo(iccId){if(!iccId){return undefined;}
var iccManager=window.navigator.mozIccManager;var iccInfo=iccManager.getIccById(iccId);if(!iccInfo){console.error('Unrecognized iccID: '+iccId);return undefined;}
return iccInfo;},getInterface:function getInterface(findFunction){if(!Common.allNetworkInterfaceLoaded){debug('Network interfaces are not ready yet');var header=_('data-usage');var msg=_('loading-interface-data');this.modalAlert(header+'\n'+msg);return;}
if(Common.allNetworkInterfaces){return Common.allNetworkInterfaces.find(findFunction);}},getDataSIMInterface:function _getDataSIMInterface(){if(!this.dataSimIccIdLoaded){console.warn('Data simcard is not ready yet');return;}
var iccId=this.dataSimIccId;if(iccId){var findCurrentInterface=function(networkInterface){if(networkInterface.id===iccId){return networkInterface;}};return this.getInterface(findCurrentInterface);}
return undefined;},getWifiInterface:function _getWifiInterface(){var findWifiInterface=function(networkInterface){if(networkInterface.type===navigator.mozNetworkStats.WIFI){return networkInterface;}};return this.getInterface(findWifiInterface);},loadNetworkInterfaces:function(onsuccess,onerror){var networks=navigator.mozNetworkStats.getAvailableNetworks();networks.onsuccess=function(){Common.allNetworkInterfaces=networks.result;Common.allNetworkInterfaceLoaded=true;if(onsuccess){onsuccess();}};networks.onerror=function(){console.error('Error when trying to load network interfaces');if(onerror){onerror();}};},loadDataSIMIccId:function _loadDataSIMIccId(onsuccess,onerror){var settings=navigator.mozSettings,mobileConnections=navigator.mozMobileConnections,dataSlotId=0;var req=settings&&settings.createLock().get('ril.data.defaultServiceId');req.onsuccess=function _onsuccesSlotId(){dataSlotId=req.result['ril.data.defaultServiceId']||0;var mobileConnection=mobileConnections[dataSlotId];var iccId=mobileConnection.iccId||null;if(!iccId){console.error('The slot '+dataSlotId+', configured as the data slot, is empty');(typeof onerror==='function')&&onerror();return;}
Common.dataSimIccId=iccId;Common.dataSimIccIdLoaded=true;Common.dataSimIcc=Common.getIccInfo(iccId);if(onsuccess){onsuccess(iccId);}};req.onerror=function _onerrorSlotId(){console.warn('ril.data.defaultServiceId does not exists');var iccId=null;for(var i=0;i<mobileConnections.length&&!iccId;i++){if(mobileConnections[i]){iccId=mobileConnections[i].iccId;}}
if(!iccId){console.error('No SIM in the device');(typeof onerror==='function')&&onerror();return;}
Common.dataSimIccId=iccId;Common.dataSimIccIdLoaded=true;Common.dataSimIcc=Common.getIccInfo(iccId);if(onsuccess){onsuccess(iccId);}};}};;'use strict';var NetworkUsageAlarm=(function(){function _addAlarm(networkInterface,value,onsuccess,onerror){if(!networkInterface){console.error('Error, the network interface is not defined when trying '+'to add an alarm');(typeof onerror==='function')&&onerror();return;}
if(value===null||typeof value==='undefined'){console.error('Limit value is undefined, impossible add an alarm');(typeof onerror==='function')&&onerror();return;}
var request=navigator.mozNetworkStats.addAlarm(networkInterface,value);request.onsuccess=onsuccess;request.onerror=function error(e){console.error('Error, when trying to addAlarm to the interfaceId: '+
networkInterface.id+' and limit: '+value);(typeof onerror==='function')&&onerror();};}
function _clearAlarms(networkInterface,callback){if(!networkInterface){console.error('Error, the network interface is not defined when trying '+'to remove alarms');return;}
var request=navigator.mozNetworkStats.getAllAlarms(networkInterface);request.onsuccess=function success(){var alarmList=request.result;var pendingRequest=alarmList.length;function checkForCompletion(){pendingRequest--;if(pendingRequest===0){(typeof callback==='function')&&callback();}}
function _onErrorRemoveAlarm(){console.error('Error when trying to remove one alarm.');checkForCompletion();}
for(var i=0;i<alarmList.length;i++){if(alarmList[i]&&alarmList[i].alarmId){var rA=navigator.mozNetworkStats.removeAlarms(alarmList[i].alarmId);rA.onsuccess=checkForCompletion;rA.onerror=_onErrorRemoveAlarm;}}
if(pendingRequest===0){(typeof callback==='function')&&callback();}};request.onerror=function error(){console.error('Error when trying to get alarms from the API to clear it');};}
function _updateAlarm(dataInterface,value,onsuccess,onerror){if(dataInterface&&value){var addNewAlarm=_addAlarm.bind(null,dataInterface,value,onsuccess,onerror);_clearAlarms(dataInterface,addNewAlarm);}else{if(!dataInterface){console.error('Error, the network interface is not defined when '+'trying to update an alarm');}else{console.error('Error, the data limit value is not defined when '+'trying to update an alarm');}
(typeof onerror==='function')&&onerror();}}
return{updateAlarm:_updateAlarm,clearAlarms:_clearAlarms};}());;var CostControl=(function(){'use strict';var costcontrol;function getInstance(onready){debug('Initializing Cost Control');if(costcontrol){debug('Cost Control already ready!');onready(costcontrol);return;}
function setupCostControl(){costcontrol={request:request,isBalanceRequestSMS:isBalanceRequestSMS,getDataUsageWarning:function _getDataUsageWarning(){return 0.8;}};debug('Cost Control ready!');onready(costcontrol);}
loadAPIs();ConfigManager.requestAll(setupCostControl);}
var mobileMessageManager,connection,telephony,statistics;function loadAPIs(){if('mozMobileMessage'in window.navigator){mobileMessageManager=window.navigator.mozMobileMessage;}
if('mozMobileConnection'in window.navigator){connection=window.navigator.mozMobileConnection;}
else if('mozMobileConnections'in window.navigator){connection=window.navigator.mozMobileConnections[0];}
if('mozNetworkStats'in window.navigator){statistics=window.navigator.mozNetworkStats;}
debug('APIs loaded!');}
function isBalanceRequestSMS(message,configuration){return message.receiver===configuration.balance.destination;}
function request(requestObj,callback){ConfigManager.requestAll(function _onInfo(configuration,settings){debug('Request for:',requestObj.type);var force=requestObj.force;var result={};result.type=requestObj.type;switch(requestObj.type){case'balance':var issues=getServiceIssues(configuration,settings);var canBeIgnoredByForcing=(issues==='minimum_delay'&&force);if(issues&&!canBeIgnoredByForcing){result.status='error';result.details=issues;result.data=settings.lastBalance;if(callback){callback(result);}
return;}
var costIssues=getCostIssues(configuration);if(!force&&costIssues){result.status='error';result.details=costIssues;result.data=settings.lastBalance;if(callback){callback(result);}
return;}
var isWaiting=settings.waitingForBalance!==null;var timeout=Toolkit.checkEnoughDelay(BALANCE_TIMEOUT,settings.lastBalanceRequest);if(isWaiting&&!timeout){result.status='in_progress';result.data=settings.lastBalance;if(callback){callback(result);}
return;}
requestBalance(configuration,settings,callback,result);break;case'topup':var issues=getServiceIssues(configuration,settings);if(issues&&issues!=='minimum_delay'){result.status='error';result.details=issues;result.data=settings.lastDataUsage;if(callback){callback(result);}
return;}
var costIssues=getCostIssues(configuration);if(!force&&costIssues){result.status='error';result.details=costIssues;result.data=settings.lastBalance;if(callback){callback(result);}
return;}
var isWaiting=settings.waitingForTopUp!==null;var timeout=Toolkit.checkEnoughDelay(BALANCE_TIMEOUT,settings.lastTopUpRequest);if(isWaiting&&!timeout&&!force){result.status='in_progress';result.data=settings.lastDataUsage;if(callback){callback(result);}
return;}
var code=requestObj.data;requestTopUp(configuration,settings,code,callback,result);break;case'datausage':requestDataStatistics(configuration,settings,callback,result);break;case'telephony':result.data=settings.lastTelephonyActivity;result.status='success';if(callback){callback(result);}
break;}
return;});}
function getServiceIssues(configuration,settings){if(airplaneMode){return'airplane_mode';}
if(!connection||!connection.voice||!connection.data){return'no_service';}
var mode=ConfigManager.getApplicationMode();if(mode!=='PREPAID'){return'no_service';}
var voice=connection.voice;if(!voice.connected){return'no_service';}
if(voice.relSignalStrength===null){return'no_coverage';}
if(configuration.balance.minimum_delay){var isMinimumDelayHonored=Toolkit.checkEnoughDelay(configuration.balance.minimum_delay,settings.lastBalanceRequest);if(!isMinimumDelayHonored){return'minimum_delay';}}
return'';}
function getCostIssues(configuration){var inRoaming=connection.voice.roaming;if(inRoaming&&configuration.is_roaming_free!==true){return'non_free_in_roaming';}
if(!inRoaming&&configuration.is_free!==true){return'non_free';}
return'';}
var BALANCE_TIMEOUT=5*60*1000;function requestBalance(configuration,settings,callback,result){debug('Requesting balance...');result.data=settings.lastBalance;var newSMS=mobileMessageManager.send(configuration.balance.destination,configuration.balance.text);newSMS.onsuccess=function _onSuccess(){debug('Request SMS sent! Waiting for response.');var newAlarm=addAlarmTimeout('balanceTimeout',BALANCE_TIMEOUT);newAlarm.onsuccess=function _alarmSet(evt){var id=evt.target.result;debug('Timeout for balance (',id,') update set to:',BALANCE_TIMEOUT);ConfigManager.setOption({'waitingForBalance':id,'lastBalanceRequest':new Date()},function _onSet(){result.status='success';if(callback){callback(result);}});};newAlarm.onerror=function _alarmFailedToSet(evt){debug('Failed to set timeout for balance request!');result.status='error';result.details='timout_fail';if(callback){callback(result);}};};newSMS.onerror=function _onError(){debug('Request SMS failed! But returning stored balance.');result.status='error';result.details='request_fail';if(callback){callback(result);}};debug('Balance out of date. Requesting fresh data...');}
var TOPUP_TIMEOUT=5*60*1000;function requestTopUp(configuration,settings,code,callback,result){debug('Requesting TopUp with code',code,'...');var newSMS=mobileMessageManager.send(configuration.topup.destination,configuration.topup.text.replace(/\&code/g,code));newSMS.onsuccess=function _onSuccess(){debug('TopUp SMS sent! Waiting for response.');var newAlarm=addAlarmTimeout('topupTimeout',TOPUP_TIMEOUT);newAlarm.onsuccess=function _alarmSet(evt){var id=evt.target.result;debug('Timeout for TopUp (',id,') update set to:',TOPUP_TIMEOUT);ConfigManager.setOption({'waitingForTopUp':id,'lastTopUpRequest':new Date()},function _onSet(){result.status='success';if(callback){callback(result);}});};newAlarm.onerror=function _alarmFailedToSet(evt){debug('Failed to set timeout for TopUp request!');result.status='error';result.details='timeout_fail';if(callback){callback(result);}};};newSMS.onerror=function _onError(){debug('TopUp SMS failed!');result.status='error';result.details='request_fail';if(callback){callback(result);}};}
var DAY=24*3600*1000;function requestDataStatistics(configuration,settings,callback,result){debug('Statistics out of date. Requesting fresh data...');var maxAge=1000*statistics.maxStorageAge;var minimumStart=new Date(Date.now()-maxAge);debug('The max age for samples is '+minimumStart);var start=new Date(settings.lastCompleteDataReset||Date.now()-7*DAY);if(start<minimumStart){console.warn('Start date is surpassing the maximum age for the '+'samples. Setting to '+minimumStart);start=minimumStart;}
start=toMidnight(start);var today=toMidnight(new Date());var tomorrow=new Date();tomorrow.setTime(today.getTime()+DAY);var end=toMidnight(settings.nextReset?new Date(settings.nextReset.getTime()-DAY):tomorrow);if(start>end){console.error('Start date is higher than end date. This must not '+'happen. Maybe the clock has changed');end=new Date(start.getTime()+DAY);}
var wifiInterface=Common.getWifiInterface();var currentSimcardNetwork=Common.getDataSIMInterface();var simRequest,wifiRequest;var pendingRequests=0;function checkForCompletion(){pendingRequests--;if(pendingRequests===0){updateDataUsage();}};function updateDataUsage(){var fakeEmptyResult={data:[]};var wifiData=adaptData(wifiRequest?wifiRequest.result:fakeEmptyResult);var mobileData=adaptData(simRequest?simRequest.result:fakeEmptyResult);var lastDataUsage={timestamp:new Date(),start:start,end:end,today:today,wifi:{total:wifiData[1]},mobile:{total:mobileData[1]}};ConfigManager.setOption({'lastDataUsage':lastDataUsage},function _onSetItem(){debug('Statistics up to date and stored.');});lastDataUsage.wifi.samples=wifiData[0];lastDataUsage.mobile.samples=mobileData[0];result.status='success';result.data=lastDataUsage;debug('Returning up to date statistics.');if(callback){callback(result);}}
if(currentSimcardNetwork){pendingRequests++;simRequest=statistics.getSamples(currentSimcardNetwork,start,end);simRequest.onsuccess=checkForCompletion;}
if(wifiInterface){pendingRequests++;wifiRequest=statistics.getSamples(wifiInterface,start,end);wifiRequest.onsuccess=checkForCompletion;}
if(pendingRequests===0){updateDataUsage();}}
function adaptData(networkStatsResult){var data=networkStatsResult.data;var output=[];var totalData,accum=0;for(var i=0,item;item=data[i];i++){if(item.txBytes===undefined){output.push({date:item.date});continue;}
totalData=0;if(item.rxBytes){totalData+=item.rxBytes;}
if(item.txBytes){totalData+=item.txBytes;}
accum+=totalData;output.push({value:totalData,date:item.date});}
return[output,accum];}
var airplaneMode=false;function init(){SettingsListener.observe('ril.radio.disabled',false,function _onValue(value){airplaneMode=value;});}
return{init:init,getInstance:getInstance};}());;CostControl.init();;'use strict';function BalanceView(balanceLabel,timestampLabel,minimumDelay){minimumDelay=minimumDelay||0;var timeHighlightColors=[{threshold:minimumDelay/3,className:'first-third'},{threshold:2*minimumDelay/3,className:'second-third'},{threshold:minimumDelay,className:'third-third'},{threshold:24*60*60*1000,className:'yesterday'},{threshold:Infinity,className:'before'}];function update(balanceResult,isUpdating){if(!balanceResult){setBalanceToNotAvailable();}else{updateBalance(balanceResult.balance,balanceResult.currency);updateTimestamp(balanceResult.timestamp,isUpdating);}}
function setBalanceToNotAvailable(){balanceLabel.textContent=_('not-available');timestampLabel.innerHTML='';}
function updateBalance(balance,currencySymbol){balanceLabel.textContent=_('currency',{value:balance,currency:currencySymbol});}
function updateTimestamp(timestamp,isUpdating){timestampLabel.innerHTML='';if(isUpdating){timestampLabel.textContent=_('updating-ellipsis');}else if(typeof timestamp!=='undefined'){var time=getTimeTagFor(timestamp);timestampLabel.appendChild(time);time.classList.add(getHighlightColor(timestamp));}}
function getTimeTagFor(timestamp){var time=document.createElement('time');time.dateTime=timestamp.toISOString();time.textContent=Formatting.formatTimeSinceNow(timestamp);return time;}
function getHighlightColor(timestamp){if(!minimumDelay){return'first-third';}
var now=new Date(),then=new Date(timestamp);var age=now-then;for(var i=0,l=timeHighlightColors.length;i<l;i++){var category=timeHighlightColors[i];if(age<category.threshold){return category.className;}}
return timeHighlightColors[l-1].className;}
this.update=update;};var Widget=(function(){'use strict';var costcontrol;function checkSIMStatus(){var mobileConnection=window.navigator.mozMobileConnections;if(!mobileConnection){console.error('No mozMobileConnection available');return;}
var iccid=Common.dataSimIccId;var dataSimIccInfo=Common.dataSimIcc;var cardState=checkCardState();if(!dataSimIccInfo||!dataSimIccInfo.iccInfo){debug('ICC info not ready yet.');dataSimIccInfo.oniccinfochange=checkSIMStatus;}else if(cardState!=='ready'){debug('SIM not ready:',dataSimIccInfo.cardState);initialized=false;dataSimIccInfo.oncardstatechange=checkSIMStatus;}else if(!Common.isValidICCID(iccid)){debug('ICC info not ready yet');dataSimIccInfo.oniccinfochange=checkSIMStatus;}else{debug('SIM ready. ICCID:',iccid);dataSimIccInfo.oncardstatechange=undefined;dataSimIccInfo.oniccinfochange=undefined;document.getElementById('message-handler').src='message_handler.html';Common.waitForDOMAndMessageHandler(window,startWidget);}}
function checkCardState(){var state,cardState;state=cardState=Common.dataSimIcc.cardState;if(!cardState||cardState==='absent'){debug('There is no SIM');showSimError('no-sim2');}else if(cardState==='pinRequired'||cardState==='pukRequired'){showSimError('sim-locked');state='locked';}
return state;}
function startWidget(){function _onNoICCID(){console.error('checkSIM() failed. Impossible to ensure consistent'+'data. Aborting start up.');showSimError('no-sim2');}
Common.checkSIM(function _onSIMChecked(){CostControl.getInstance(function _onCostControlReady(instance){costcontrol=instance;setupWidget();});},_onNoICCID);}
window.addEventListener('localized',function _onLocalize(){if(initialized){updateUI();}});var initialized,widget,leftPanel,rightPanel,fte,views={};var balanceView;function setupWidget(){widget=document.getElementById('cost-control');leftPanel=document.getElementById('left-panel');rightPanel=document.getElementById('right-panel');fte=document.getElementById('fte-view');views.dataUsage=document.getElementById('datausage-view');views.limitedDataUsage=document.getElementById('datausage-limit-view');views.telephony=document.getElementById('telephony-view');views.balance=document.getElementById('balance-view');ConfigManager.observe('lastBalance',onBalance,true);ConfigManager.observe('waitingForBalance',onErrors,true);ConfigManager.observe('errors',onErrors,true);ConfigManager.observe('lastCompleteDataReset',onReset,true);ConfigManager.observe('lastTelephonyReset',onReset,true);var balanceConfig=ConfigManager.configuration.balance;balanceView=new BalanceView(document.getElementById('balance-credit'),document.querySelector('#balance-credit + .meta'),balanceConfig?balanceConfig.minimum_delay:undefined);document.addEventListener('visibilitychange',function _onVisibilityChange(evt){if(!document.hidden&&initialized){checkCardState(Common.dataSimIccId);updateUI();}});window.addEventListener('hashchange',function _onHashChange(){if(window.location.hash.split('#')[1]==='update'){updateUI(true);}});views.balance.addEventListener('click',function _openCCBalance(){var activity=new MozActivity({name:'costcontrol/balance'});});views.telephony.addEventListener('click',function _openCCTelephony(){var activity=new MozActivity({name:'costcontrol/telephony'});});rightPanel.addEventListener('click',function _openCCDataUsage(){var activity=new MozActivity({name:'costcontrol/data_usage'});});updateUI();SettingsListener.observe('ril.data.defaultServiceId',0,function(){Common.loadDataSIMIccId(updateUI.bind(null,true));});initialized=true;}
function onBalance(balance,old,key,settings){debug('Balance received:',balance);setBalanceMode('default');updateBalance(balance,settings.lowLimit&&settings.lowLimitThreshold);debug('Balance updated!');}
function onErrors(errors,old,key,settings){if(!errors||!errors['BALANCE_TIMEOUT']){return;}
debug('Balance timeout!');setBalanceMode('warning');errors['BALANCE_TIMEOUT']=false;ConfigManager.setOption({errors:errors});}
function onReset(value,old,key,settings){updateUI();}
function showSimError(status){navigator.mozL10n.ready(function showErrorStatus(){var fte=document.getElementById('fte-view');var leftPanel=document.getElementById('left-panel');var rightPanel=document.getElementById('right-panel');fte.setAttribute('aria-hidden',false);leftPanel.setAttribute('aria-hidden',true);rightPanel.setAttribute('aria-hidden',true);var className='widget-'+status;document.getElementById('fte-icon').classList.add(className);Common.localize(fte.querySelector('p:first-child'),className+'-heading');Common.localize(fte.querySelector('p:last-child'),className+'-meta');});}
function setupFte(provider,mode){fte.setAttribute('aria-hidden',false);leftPanel.setAttribute('aria-hidden',true);rightPanel.setAttribute('aria-hidden',true);fte.addEventListener('click',function launchFte(){fte.removeEventListener('click',launchFte);var activity=new MozActivity({name:'costcontrol/balance'});});var keyLookup={PREPAID:'widget-authed-sim',POSTPAID:'widget-authed-sim',DATA_USAGE_ONLY:'widget-nonauthed-sim'};var simKey=keyLookup[mode];document.getElementById('fte-icon').className='icon '+simKey;Common.localize(fte.querySelector('p:first-child'),simKey+'-heading',{provider:provider});Common.localize(fte.querySelector('p:last-child'),simKey+'-meta');}
var hashMark=0;function updateUI(updateOnlyDataUsage){ConfigManager.requestAll(function _onInfo(configuration,settings){var mode=ConfigManager.getApplicationMode();debug('Widget UI mode:',mode);var isPrepaid=(mode==='PREPAID');var isDataUsageOnly=(mode==='DATA_USAGE_ONLY');if(settings.fte){setupFte(configuration.provider,mode);debug('Widget in FTE mode');return;}
fte.setAttribute('aria-hidden',true);leftPanel.setAttribute('aria-hidden',false);rightPanel.setAttribute('aria-hidden',false);var isLimited=settings.dataLimit;views.dataUsage.setAttribute('aria-hidden',isLimited);views.limitedDataUsage.setAttribute('aria-hidden',!isLimited);leftPanel.setAttribute('aria-hidden',isDataUsageOnly);if(isDataUsageOnly){widget.classList.add('full');}else{widget.classList.remove('full');views.balance.setAttribute('aria-hidden',!isPrepaid);views.telephony.setAttribute('aria-hidden',isPrepaid);}
var requestObj={type:'datausage'};costcontrol.request(requestObj,function _onDataStatistics(result){debug(result);var stats=result.data;var data=roundData(stats.mobile.total);if(isLimited){var leftTag=views.limitedDataUsage.querySelector('dt.start');var leftValue=views.limitedDataUsage.querySelector('dd.start');var rightTag=views.limitedDataUsage.querySelector('dt.end');var rightValue=views.limitedDataUsage.querySelector('dd.end');var progress=views.limitedDataUsage.querySelector('progress');var current=stats.mobile.total;var limit=getDataLimit(settings);debug(limit);progress.setAttribute('value',Math.min(current,limit));progress.setAttribute('max',Math.max(current,limit));views.limitedDataUsage.classList.remove('nearby-limit');views.limitedDataUsage.classList.remove('reached-limit');var limitTresspased=(current>limit);if(limitTresspased){views.limitedDataUsage.classList.add('reached-limit');}else if(current>=limit*costcontrol.getDataUsageWarning()){views.limitedDataUsage.classList.add('nearby-limit');}
var currentText=roundData(current);currentText=_('magnitude',{value:currentText[0],unit:currentText[1]});var limitText=roundData(limit);limitText=_('magnitude',{value:limitText[0],unit:limitText[1]});Common.localize(leftTag,limitTresspased?'limit-passed':'used');leftValue.textContent=limitTresspased?limitText:currentText;Common.localize(rightTag,limitTresspased?'used':'limit');rightValue.textContent=limitTresspased?currentText:limitText;}else{document.getElementById('mobile-usage-value').textContent=_('magnitude',{value:data[0],unit:data[1]});var meta=views.dataUsage.querySelector('.meta');meta.innerHTML='';meta.appendChild(formatTimeHTML(stats.timestamp));}
hashMark=1-hashMark;window.location.hash='#updateDone#'+hashMark;});if(!isDataUsageOnly&&!updateOnlyDataUsage){if(mode==='PREPAID'){updateBalance(settings.lastBalance,settings.lowLimit&&settings.lowLimitThreshold);requestObj={type:'balance'};costcontrol.request(requestObj,function _onRequest(result){debug(result);var status=result.status;var balance=result.data;setBalanceMode(status==='error'?'warning':'updating');updateBalance(balance,settings.lowLimit&&settings.lowLimitThreshold);});}else if(mode==='POSTPAID'){requestObj={type:'telephony'};costcontrol.request(requestObj,function _onRequest(result){var activity=result.data;document.getElementById('telephony-calltime').textContent=_('magnitude',{value:computeTelephonyMinutes(activity),unit:'min'});document.getElementById('telephony-smscount').textContent=_('magnitude',{value:activity.smscount,unit:'SMS'});var meta=views.telephony.querySelector('.meta');meta.innerHTML='';meta.appendChild(formatTimeHTML(activity.timestamp));});}}});}
function updateBalance(balance,limit){if(!balance){debug('Balance not available');balanceView.update();return;}
var isUpdating=views.balance.classList.contains('updating');balanceView.update(balance,isUpdating);if(balance.balance===0){views.balance.classList.add('no-credit');}else{views.balance.classList.remove('no-credit');if(limit&&balance.balance<limit){views.balance.classList.add('low-credit');}else{views.balance.classList.remove('low-credit');}}}
var lastBalanceMode;function setBalanceMode(mode){if(mode===lastBalanceMode){return;}
lastBalanceMode=mode;views.balance.classList.remove('updating');views.balance.classList.remove('warning');if(mode==='warning'){views.balance.classList.add('warning');}
if(mode==='updating'){views.balance.classList.add('updating');}}
return{init:function(){var isWaitingForIcc=false;function waitForIccAndCheckSim(){if(!isWaitingForIcc){var iccManager=window.navigator.mozIccManager;iccManager.addEventListener('iccdetected',function _oniccdetected(){isWaitingForIcc=false;iccManager.removeEventListener('iccdetected',_oniccdetected);Common.loadDataSIMIccId(checkSIMStatus);});isWaitingForIcc=true;}}
Common.loadDataSIMIccId(checkSIMStatus,function _errorNoSim(){waitForIccAndCheckSim();console.warn('Error when trying to get the ICC ID');showSimError('no-sim2');});AirplaneModeHelper.addEventListener('statechange',function _onAirplaneModeChange(state){if(state==='enabled'){waitForIccAndCheckSim();showSimError('no-sim2');}});Common.loadNetworkInterfaces();}};}());Widget.init();