;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;(function(exports){'use strict';var priv=new WeakMap();var rmatcher=/\$\{([^}]+)\}/g;var rentity=/[&<>"']/g;var rentities={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&apos;'};function extract(node){var nodeId;if(typeof node==='string'){nodeId=node;node=document.getElementById(node);}else if(node){nodeId=node.id;}
if(!node){console.error('Can not find the node passed to Template',nodeId);return'';}
if(!node.firstChild){console.error('Node passed to Template should have a comment node',nodeId);return'';}
node=node.firstChild;do{if(node.nodeType===Node.COMMENT_NODE){return(node.nodeValue||'').trim();}}while((node=node.nextSibling));console.error('Nodes passed to Template should have a comment node',nodeId);return'';}
function Template(idOrNode){if(!(this instanceof Template)){return new Template(idOrNode);}
priv.set(this,{tmpl:extract(idOrNode)});};Template.prototype.toString=function(){return priv.get(this).tmpl.slice();};Template.prototype.interpolate=function(data,options){options=options||{};options.safe=options.safe||[];return priv.get(this).tmpl.replace(rmatcher,function(match,property){property=property.trim();return options.safe.indexOf(property)===-1?Template.escape(data[property]):data[property];});};Template.escape=function escape(str){if(typeof str!=='string'){return'';}
return str.replace(rentity,function(s){return rentities[s];});};exports.Template=Template;}(this));;'use strict';function enumerateAll(storages,dir,options){var storageIndex=0;var ds_cursor=null;var cursor={continue:function cursor_continue(){ds_cursor.continue();}};function enumerateNextStorage(){ds_cursor=storages[storageIndex].enumerate(dir,options||{});ds_cursor.onsuccess=onsuccess;ds_cursor.onerror=onerror;};function onsuccess(e){cursor.result=e.target.result;if(!cursor.result){storageIndex++;if(storageIndex<storages.length){enumerateNextStorage();return;}}
if(cursor.onsuccess){try{cursor.onsuccess(e);}catch(err){console.warn('enumerateAll onsuccess threw',err);}}};function onerror(e){cursor.error=e.target.error;if(cursor.onerror){try{cursor.onerror(e);}catch(err){console.warn('enumerateAll onerror threw',err);}}};enumerateNextStorage();return cursor;};'use strict';var MediaDB=(function(){function MediaDB(mediaType,metadataParser,options){this.mediaType=mediaType;this.metadataParser=metadataParser;if(!options)
options={};this.indexes=options.indexes||[];this.version=options.version||1;this.mimeTypes=options.mimeTypes;this.autoscan=(options.autoscan!==undefined)?options.autoscan:true;this.state=MediaDB.OPENING;this.scanning=false;this.parsingBigFiles=false;this.updateRecord=options.updateRecord;if(options.excludeFilter&&(options.excludeFilter instanceof RegExp)){this.clientExcludeFilter=options.excludeFilter;}
this.batchHoldTime=options.batchHoldTime||100;this.batchSize=options.batchSize||0;this.dbname='MediaDB/'+this.mediaType+'/';var media=this;this.details={eventListeners:{},pendingInsertions:[],pendingDeletions:[],whenDoneProcessing:[],pendingCreateNotifications:[],pendingDeleteNotifications:[],pendingNotificationTimer:null,newestFileModTime:0};if(!this.metadataParser){this.metadataParser=function(file,callback){setTimeout(function(){callback({});},0);};}
var dbVersion=(0xFFFF&this.version)<<16|(0xFFFF&MediaDB.VERSION);var openRequest=indexedDB.open(this.dbname,dbVersion);openRequest.onerror=function(e){console.error('MediaDB():',openRequest.error.name);};openRequest.onblocked=function(e){console.error('indexedDB.open() is blocked in MediaDB()');};openRequest.onupgradeneeded=function(e){var db=openRequest.result;var transaction=e.target.transaction;var oldVersion=e.oldVersion;var oldDbVersion=0xFFFF&oldVersion;var oldClientVersion=0xFFFF&(oldVersion>>16);if(oldClientVersion===0){oldDbVersion=2;oldClientVersion=oldVersion/oldDbVersion;}
if(0==db.objectStoreNames.length){createObjectStores(db);}else{handleUpgrade(db,transaction,oldDbVersion,oldClientVersion);}};openRequest.onsuccess=function(e){media.db=openRequest.result;media.db.onerror=function(event){console.error('MediaDB: ',event.target.error&&event.target.error.name);};var cursorRequest=media.db.transaction('files','readonly').objectStore('files').index('date').openCursor(null,'prev');cursorRequest.onerror=function(){console.error('MediaDB initialization error',cursorRequest.error);};cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){media.details.newestFileModTime=cursor.value.date;}
else{media.details.newestFileModTime=0;}
initDeviceStorage();};};function createObjectStores(db){var filestore=db.createObjectStore('files',{keyPath:'name'});filestore.createIndex('date','date');media.indexes.forEach(function(indexName){if(indexName==='name'||indexName==='date')
return;filestore.createIndex(indexName,indexName);});}
function enumerateOldFiles(store,callback){var openCursorReq=store.openCursor();openCursorReq.onsuccess=function(){var cursor=openCursorReq.result;if(cursor){callback(cursor.value);cursor.continue();}};}
function handleUpgrade(db,trans,oldDbVersion,oldClientVersion){media.state=MediaDB.UPGRADING;var evtDetail={'oldMediaDBVersion':oldDbVersion,'oldClientVersion':oldClientVersion,'newMediaDBVersion':MediaDB.VERSION,'newClientVersion':media.version};dispatchEvent(media,'upgrading',evtDetail);var store=trans.objectStore('files');if(media.version!=oldClientVersion){upgradeIndexesChanges(store);}
var clientUpgradeNeeded=(media.version!=oldClientVersion)&&media.updateRecord;if((2!=oldDbVersion||3!=MediaDB.VERSION)&&!clientUpgradeNeeded){return;}
enumerateOldFiles(store,function doUpgrade(dbfile){if(2==oldDbVersion&&3==MediaDB.VERSION){upgradeDBVer2to3(store,dbfile);}
if(clientUpgradeNeeded){handleClientUpgrade(store,dbfile,oldClientVersion);}});}
function upgradeIndexesChanges(store){var dbIndexes=store.indexNames;var clientIndexes=media.indexes;var clientIndex;for(var i=0;i<dbIndexes.length;i++){if('name'===dbIndexes[i]||'date'===dbIndexes[i]){continue;}
if(clientIndexes.indexOf(dbIndexes[i])<0){store.deleteIndex(dbIndexes[i]);}}
for(i=0;i<clientIndexes.length;i++){if(!dbIndexes.contains(clientIndexes[i])){store.createIndex(clientIndexes[i],clientIndexes[i]);}}}
function upgradeDBVer2to3(store,dbfile){if(dbfile.name[0]==='/'){return;}
store.delete(dbfile.name);dbfile.name='/sdcard/'+dbfile.name;store.add(dbfile);}
function handleClientUpgrade(store,dbfile,oldClientVersion){try{dbfile.metadata=media.updateRecord(dbfile,oldClientVersion,media.version);store.put(dbfile);}catch(ex){console.warn('client app updates record, '+dbfile.name+', failed: '+ex.message);}}
function initDeviceStorage(){var details=media.details;details.storages=navigator.getDeviceStorages(mediaType);details.availability={};getStorageAvailability();function getStorageAvailability(){var next=0;getNextAvailability();function getNextAvailability(){if(next>=details.storages.length){setupHandlers();return;}
var s=details.storages[next++];var name=s.storageName;var req=s.available();req.onsuccess=function(e){details.availability[name]=req.result;getNextAvailability();};req.onerror=function(e){details.availability[name]='unavailable';getNextAvailability();};}}
function setupHandlers(){for(var i=0;i<details.storages.length;i++)
details.storages[i].addEventListener('change',changeHandler);details.dsEventListener=changeHandler;sendInitialEvent();}
function sendInitialEvent(){var state=getState(details.availability);changeState(media,state);if(media.autoscan)
scan(media);}
function getState(availability){var n=0;var a=0;var u=0;var s=0;for(var name in availability){n++;switch(availability[name]){case'available':a++;break;case'unavailable':u++;break;case'shared':s++;break;}}
if(s>0)
return MediaDB.UNMOUNTED;if(u===n)
return MediaDB.NOCARD;return MediaDB.READY;}
function changeHandler(e){switch(e.reason){case'modified':case'deleted':fileChangeHandler(e);return;case'available':case'unavailable':case'shared':volumeChangeHandler(e);return;default:return;}}
function volumeChangeHandler(e){var storageName=e.target.storageName;if(details.availability[storageName]===e.reason)
return;var oldState=media.state;details.availability[storageName]=e.reason;var newState=getState(details.availability);if(newState!==oldState){changeState(media,newState);if(newState===MediaDB.READY){if(media.autoscan)
scan(media);}
else{endscan(media);}}
else if(newState===MediaDB.READY){if(e.reason==='available'){dispatchEvent(media,'ready');if(media.autoscan)
scan(media);}
else if(e.reason==='unavailable'){dispatchEvent(media,'cardremoved');deleteAllFiles(storageName);}}}
function fileChangeHandler(e){var filename=e.path;if(ignoreName(media,filename))
return;if(e.reason==='modified')
insertRecord(media,filename);else
deleteRecord(media,filename);}
function deleteAllFiles(storageName){var storagePrefix=storageName?'/'+storageName+'/':'';var store=media.db.transaction('files').objectStore('files');var cursorRequest=store.openCursor();cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){if(cursor.value.name.startsWith(storagePrefix)){deleteRecord(media,cursor.value.name);}
cursor.continue();}};}}}
MediaDB.prototype={close:function close(){this.db.close();for(var i=0;i<this.details.storages.length;i++){var s=this.details.storages[i];s.removeEventListener('change',this.details.dsEventListener);}
changeState(this,MediaDB.CLOSED);},addEventListener:function addEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type))
this.details.eventListeners[type]=[];var listeners=this.details.eventListeners[type];if(listeners.indexOf(listener)!==-1)
return;listeners.push(listener);},removeEventListener:function removeEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type))
return;var listeners=this.details.eventListeners[type];var position=listeners.indexOf(listener);if(position===-1)
return;listeners.splice(position,1);},getFileInfo:function getFile(filename,callback,errback){if(this.state===MediaDB.OPENING)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){var msg='MediaDB.getFileInfo: unknown filename: '+filename;if(errback)
errback(msg);else
console.error(msg);};read.onsuccess=function(){if(callback)
callback(read.result);};},getFile:function getFile(filename,callback,errback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);var getRequest=storage.get(filename);getRequest.onsuccess=function(){callback(getRequest.result);};getRequest.onerror=function(){var errmsg=getRequest.error&&getRequest.error.name;if(errback)
errback(errmsg);else
console.error('MediaDB.getFile:',errmsg);};},deleteFile:function deleteFile(filename){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);storage.delete(filename).onerror=function(e){console.error('MediaDB.deleteFile(): Failed to delete',filename,'from DeviceStorage:',e.target.error);};},addFile:function addFile(filename,file){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var storage=navigator.getDeviceStorage(media.mediaType);var deletereq=storage.delete(filename);deletereq.onsuccess=deletereq.onerror=save;function save(){var request=storage.addNamed(file,filename);request.onerror=function(){console.error('MediaDB: Failed to store',filename,'in DeviceStorage:',request.error);};}},updateMetadata:function(filename,metadata,callback){if(this.state===MediaDB.OPENING)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){console.error('MediaDB.updateMetadata called with unknown filename');};read.onsuccess=function(){var fileinfo=read.result;Object.keys(metadata).forEach(function(key){fileinfo.metadata[key]=metadata[key];});var write=media.db.transaction('files','readwrite').objectStore('files').put(fileinfo);write.onerror=function(){console.error('MediaDB.updateMetadata: database write failed',write.error&&write.error.name);};if(callback){write.onsuccess=function(){callback();};}};},count:function(key,range,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);if(arguments.length===1){callback=key;range=undefined;key=undefined;}
else if(arguments.length===2){callback=range;range=key;key=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var countRequest=store.count(range||null);countRequest.onerror=function(){console.error('MediaDB.count() failed with',countRequest.error);};countRequest.onsuccess=function(e){callback(e.target.result);};},enumerate:function enumerate(key,range,direction,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var handle={state:'enumerating'};if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var cursorRequest=store.openCursor(range||null,direction||'next');cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(!cursor.value.fail)
callback(cursor.value);}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}
cursor.continue();}
else{handle.state='complete';callback(null);}};return handle;},advancedEnumerate:function(key,range,direction,index,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var handle={state:'enumerating'};var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var cursorRequest=store.openCursor(range||null,direction||'next');var isTarget=false;cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(!cursor.value.fail&&isTarget){callback(cursor.value);cursor.continue();}
else{cursor.advance(index-1);isTarget=true;}}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}}
else{handle.state='complete';callback(null);}};return handle;},enumerateAll:function enumerateAll(key,range,direction,callback){var batch=[];if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
return this.enumerate(key,range,direction,function(fileinfo){if(fileinfo!==null)
batch.push(fileinfo);else
callback(batch);});},cancelEnumeration:function cancelEnumeration(handle){if(handle.state==='enumerating')
handle.state='cancelling';},getAll:function getAll(callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var store=this.db.transaction('files').objectStore('files');var request=store.mozGetAll();request.onerror=function(){console.error('MediaDB.getAll() failed with',request.error);};request.onsuccess=function(){var all=request.result;var good=all.filter(function(fileinfo){return!fileinfo.fail;});callback(good);};},scan:function(){scan(this);},freeSpace:function freeSpace(callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);var freereq=storage.freeSpace();freereq.onsuccess=function(){callback(freereq.result);};}};MediaDB.VERSION=3;MediaDB.OPENING='opening';MediaDB.UPGRADING='upgrading';MediaDB.READY='ready';MediaDB.NOCARD='nocard';MediaDB.UNMOUNTED='unmounted';MediaDB.CLOSED='closed';function ignore(media,file){if(ignoreName(media,file.name))
return true;if(media.mimeTypes&&media.mimeTypes.indexOf(file.type)===-1)
return true;return false;}
function ignoreName(media,filename){if(media.clientExcludeFilter&&media.clientExcludeFilter.test(filename)){return true;}else{var path=filename.substring(0,filename.lastIndexOf('/')+1);return(path[0]==='.'||path.indexOf('/.')!==-1);}}
function scan(media){media.scanning=true;dispatchEvent(media,'scanstart');quickScan(media.details.newestFileModTime);function quickScan(timestamp){var cursor;if(timestamp>0){media.details.firstscan=false;cursor=enumerateAll(media.details.storages,'',{since:new Date(timestamp+1)});}
else{media.details.firstscan=true;media.details.records=[];cursor=enumerateAll(media.details.storages,'');}
cursor.onsuccess=function(){if(!media.scanning)
return;var file=cursor.result;if(file){if(!ignore(media,file))
insertRecord(media,file);cursor.continue();}
else{whenDoneProcessing(media,function(){sendNotifications(media);if(media.details.firstscan){endscan(media);}
else{fullScan();}});}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};}
function fullScan(){if(media.state!==MediaDB.READY){endscan(media);return;}
var dsfiles=[];var cursor=enumerateAll(media.details.storages,'');cursor.onsuccess=function(){if(!media.scanning)
return;var file=cursor.result;if(file){if(!ignore(media,file)){dsfiles.push(file);}
cursor.continue();}
else{getDBFiles();}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};function getDBFiles(){var store=media.db.transaction('files').objectStore('files');var getAllRequest=store.mozGetAll();getAllRequest.onsuccess=function(){if(!media.scanning)
return;var dbfiles=getAllRequest.result;compareLists(dbfiles,dsfiles);};}
function compareLists(dbfiles,dsfiles){dsfiles.sort(function(a,b){if(a.name<b.name)
return-1;else
return 1;});var dsindex=0,dbindex=0;while(true){var dsfile;if(dsindex<dsfiles.length)
dsfile=dsfiles[dsindex];else
dsfile=null;var dbfile;if(dbindex<dbfiles.length)
dbfile=dbfiles[dbindex];else
dbfile=null;if(dsfile===null&&dbfile===null)
break;if(dbfile===null){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile===null){deleteRecord(media,dbfile.name);dbindex++;continue;}
if(dsfile.name===dbfile.name){var lastModified=dsfile.lastModifiedDate;var timeDifference=lastModified.getTime()-dbfile.date;var sameTime=(timeDifference===0||((Math.abs(timeDifference)<=12*60*60*1000)&&(timeDifference%10*60*1000===0)));var sameSize=dsfile.size===dbfile.size;if(!sameTime||!sameSize){deleteRecord(media,dbfile.name);insertRecord(media,dsfile);}
dsindex++;dbindex++;continue;}
if(dsfile.name<dbfile.name){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile.name>dbfile.name){deleteRecord(media,dbfile.name);dbindex++;continue;}
console.error('Assertion failed');}
insertRecord(media,null);}}}
function endscan(media){if(media.scanning){media.scanning=false;media.parsingBigFiles=false;dispatchEvent(media,'scanend');}}
function insertRecord(media,fileOrName){var details=media.details;details.pendingInsertions.push(fileOrName);if(details.processingQueue)
return;processQueue(media);}
function deleteRecord(media,filename){var details=media.details;details.pendingDeletions.push(filename);if(details.processingQueue)
return;processQueue(media);}
function whenDoneProcessing(media,f){var details=media.details;if(details.processingQueue)
details.whenDoneProcessing.push(f);else
f();}
function processQueue(media){var details=media.details;details.processingQueue=true;next();function next(){if(details.pendingDeletions.length>0){deleteFiles();}
else if(details.pendingInsertions.length>0){insertFile(details.pendingInsertions.shift());}
else{details.processingQueue=false;if(details.whenDoneProcessing.length>0){var functions=details.whenDoneProcessing;details.whenDoneProcessing=[];functions.forEach(function(f){f();});}}}
function deleteFiles(){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');deleteNextFile();function deleteNextFile(){if(details.pendingDeletions.length===0){next();return;}
var filename=details.pendingDeletions.shift();var request=store.delete(filename);request.onerror=function(){console.warn('MediaDB: Unknown file in deleteRecord:',filename,getreq.error);deleteNextFile();};request.onsuccess=function(){queueDeleteNotification(media,filename);deleteNextFile();};}}
function insertFile(f){if(f===null){sendNotifications(media);endscan(media);next();return;}
if(typeof f==='string'){var storage=navigator.getDeviceStorage(media.mediaType);var getreq=storage.get(f);getreq.onerror=function(){console.warn('MediaDB: Unknown file in insertRecord:',f,getreq.error);next();};getreq.onsuccess=function(){if(media.mimeTypes&&ignore(media,getreq.result))
next();else
parseMetadata(getreq.result,f);};}
else{parseMetadata(f,f.name);}}
function parseMetadata(file,filename){if(!file.lastModifiedDate){console.warn('MediaDB: parseMetadata: no lastModifiedDate for',filename,'using Date.now() until #793955 is fixed');}
var fileinfo={name:filename,type:file.type,size:file.size,date:file.lastModifiedDate?file.lastModifiedDate.getTime():Date.now()};if(fileinfo.date>details.newestFileModTime)
details.newestFileModTime=fileinfo.date;media.metadataParser(file,gotMetadata,metadataError,parsingBigFile);function parsingBigFile(){media.parsingBigFiles=true;}
function metadataError(e){console.warn('MediaDB: error parsing metadata for',filename,':',e);fileinfo.fail=true;storeRecord(fileinfo);}
function gotMetadata(metadata){fileinfo.metadata=metadata;storeRecord(fileinfo);if(!media.scanning){media.parsingBigFiles=false;}}}
function storeRecord(fileinfo){if(media.details.firstscan){media.details.records.push(fileinfo);if(!fileinfo.fail){queueCreateNotification(media,fileinfo);}
next();}
else{var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');var request=store.add(fileinfo);request.onsuccess=function(){if(!fileinfo.fail)
queueCreateNotification(media,fileinfo);next();};request.onerror=function(event){if(request.error.name==='ConstraintError'){event.stopPropagation();event.preventDefault();var putrequest=store.put(fileinfo);putrequest.onsuccess=function(){queueDeleteNotification(media,fileinfo.name);if(!fileinfo.fail)
queueCreateNotification(media,fileinfo);next();};putrequest.onerror=function(){console.error('MediaDB: unexpected ConstraintError','in insertRecord for file:',fileinfo.name);next();};}
else{console.error('MediaDB: unexpected error in insertRecord:',request.error,'for file:',fileinfo.name);next();}};}}}
function queueCreateNotification(media,fileinfo){var creates=media.details.pendingCreateNotifications;creates.push(fileinfo);if(media.batchSize&&creates.length>=media.batchSize)
sendNotifications(media);else
resetNotificationTimer(media);}
function queueDeleteNotification(media,filename){var deletes=media.details.pendingDeleteNotifications;deletes.push(filename);if(media.batchSize&&deletes.length>=media.batchSize)
sendNotifications(media);else
resetNotificationTimer(media);}
function resetNotificationTimer(media){var details=media.details;if(details.pendingNotificationTimer)
clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=setTimeout(function(){sendNotifications(media);},media.batchHoldTime);}
function sendNotifications(media){var details=media.details;if(details.pendingNotificationTimer){clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=null;}
if(details.pendingDeleteNotifications.length>0){var deletions=details.pendingDeleteNotifications;details.pendingDeleteNotifications=[];dispatchEvent(media,'deleted',deletions);}
if(details.pendingCreateNotifications.length>0){var creations=details.pendingCreateNotifications;details.pendingCreateNotifications=[];if(details.firstscan&&details.records.length>0){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');for(var i=0;i<details.records.length;i++)
store.add(details.records[i]);details.records.length=0;transaction.oncomplete=function(){dispatchEvent(media,'created',creations);};}
else{dispatchEvent(media,'created',creations);}}}
function dispatchEvent(media,type,detail){var handler=media['on'+type];var listeners=media.details.eventListeners[type];if(!handler&&(!listeners||listeners.length==0))
return;var event={type:type,target:media,currentTarget:media,timestamp:Date.now(),detail:detail};if(typeof handler==='function'){try{handler.call(media,event);}
catch(e){console.warn('MediaDB: ','on'+type,'event handler threw',e,e.stack);}}
if(!listeners)
return;for(var i=0;i<listeners.length;i++){try{var listener=listeners[i];if(typeof listener==='function'){listener.call(media,event);}
else{listener.handleEvent(event);}}
catch(e){console.warn('MediaDB: ',type,'event listener threw',e,e.stack);}}}
function changeState(media,state){if(media.state!==state){media.state=state;if(state===MediaDB.READY)
dispatchEvent(media,'ready');else
dispatchEvent(media,'unavailable',state);}}
return MediaDB;}());;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';var MediaUtils={_:navigator.mozL10n.get,formatDate:function(timestamp){if(!timestamp||timestamp===undefined||isNaN(timestamp)){return;}
var dtf=new navigator.mozL10n.DateTimeFormat();return dtf.localeFormat(new Date(timestamp),this._('dateTimeFormat_%x'));},formatSize:function(size){if(!size||size===undefined||isNaN(size)){return;}
var units=['B','KB','MB','GB','TB','PB','EB','ZB','YB'];var i=0;while(size>=1024&&i<units.length){size/=1024;++i;}
var sizeString=size.toFixed((size<1024*1024)?0:1);var sizeDecimal=parseFloat(sizeString);return sizeDecimal+' '+this._('byteUnit-'+units[i]);},formatDuration:function(duration){function padLeft(num,length){var r=String(num);while(r.length<length){r='0'+r;}
return r;}
var minutes=Math.floor(duration/60);var seconds=Math.floor(duration%60);if(minutes<60){return padLeft(minutes,2)+':'+padLeft(seconds,2);}
var hours=Math.floor(minutes/60);minutes=Math.floor(minutes%60);return hours+':'+padLeft(minutes,2)+':'+padLeft(seconds,2);},populateMediaInfo:function(data){for(var id in data){if(data.hasOwnProperty(id)){var element=document.getElementById(id);if(element)
element.textContent=data[id];}}},binarySearch:function(array,element,comparator,from,to){if(comparator===undefined)
comparator=function(a,b){return a-b;};if(from===undefined)
return MediaUtils.binarySearch(array,element,comparator,0,array.length);if(from===to)
return from;var mid=Math.floor((from+to)/2);var result=comparator(element,array[mid]);if(result<0)
return MediaUtils.binarySearch(array,element,comparator,from,mid);else
return MediaUtils.binarySearch(array,element,comparator,mid+1,to);}};;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media)
continue;window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;(function ScrollDetector(){'use strict';var scrollTimeout=null;const IDLE_TIME=400;var isScrolling=false;function handleScroll(e){if(!isScrolling){dispatchScrollStart();}
if(scrollTimeout){window.clearTimeout(scrollTimeout);}
scrollTimeout=window.setTimeout(dispatchScrollEnd,IDLE_TIME);}
function dispatchScrollStart(){isScrolling=true;dispatchCustomScrollEvent();}
function dispatchScrollEnd(){isScrolling=false;dispatchCustomScrollEvent();}
function dispatchCustomScrollEvent(){var eventName=isScrolling?'scrollstart':'scrollend';window.dispatchEvent(new CustomEvent(eventName));}
window.addEventListener('mozbrowserasyncscroll',handleScroll,true);window.addEventListener('scroll',handleScroll,true);})();;(function(exports){'use strict';function round(x){return Math.round(x*100)/100;}
function MozSampleSize(n,scale){return Object.freeze({dimensionScale:round(scale),areaScale:round(scale*scale),toString:function(){return'#-moz-samplesize='+n;},scale:function(x){return Math.ceil(x*scale);}});}
var NONE=Object.freeze({dimensionScale:1,areaScale:1,toString:function(){return'';},scale:function(x){return x;}});var fragments=[NONE,MozSampleSize(2,1/2),MozSampleSize(3,3/8),MozSampleSize(4,1/4),MozSampleSize(8,1/8)];function sizeAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.dimensionScale<=scale){return f;}}
return fragments[fragments.length-1];}
function sizeNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.dimensionScale>=scale){return f;}}
return NONE;}
function areaAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.areaScale<=scale){return f;}}
return fragments[fragments.length-1];}
function areaNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.areaScale>=scale){return f;}}
return NONE;}
exports.Downsample={sizeAtLeast:sizeAtLeast,sizeNoMoreThan:sizeNoMoreThan,areaAtLeast:areaAtLeast,areaNoMoreThan:areaNoMoreThan,NONE:NONE,MAX_SIZE_REDUCTION:1/fragments[fragments.length-1].dimensionScale,MAX_AREA_REDUCTION:1/fragments[fragments.length-1].areaScale};}(window));;var CONFIG_MAX_IMAGE_PIXEL_SIZE=5242880;var CONFIG_MAX_SNAPSHOT_PIXEL_SIZE=5242880;var CONFIG_MAX_PICK_PIXEL_SIZE=0;var CONFIG_MAX_EDIT_PIXEL_SIZE=0;var CONFIG_MAX_IMAGE_FILE_SIZE=10485760;var CONFIG_MAX_UNKNOWN_IMAGE_FILE_SIZE=524288;var CONFIG_MAX_GIF_IMAGE_FILE_SIZE=2097152;var CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH=0;var CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT=0;;function ThumbnailItem(fileData){if(!fileData){throw new Error('fileData should not be null or undefined.');}
this.data=fileData;this.htmlNode=document.createElement('div');this.htmlNode.classList.add('thumbnail');this.imgNode=document.createElement('img');this.imgNode.alt='';this.imgNode.classList.add('thumbnailImage');this.imgNode.dataset.filename=fileData.name;var url=URL.createObjectURL(fileData.metadata.thumbnail);this.imgNode.src=url;this.htmlNode.appendChild(this.imgNode);};function ThumbnailDateGroup(item){if(!item){throw new Error('item should not be null or undefined.');}
this.thumbnails=[];this.groupID=ThumbnailDateGroup.getGroupID(item);if(!ThumbnailDateGroup.Template){throw new Error('template is required while rendering.');}
var _=navigator.mozL10n.get;var dateFormatter=new navigator.mozL10n.DateTimeFormat();var htmlText=ThumbnailDateGroup.Template.interpolate({'group-header':dateFormatter.localeFormat(new Date(item.date),_('date-group-header'))});var dummyDiv=document.createElement('DIV');dummyDiv.innerHTML=htmlText;var domNode=dummyDiv.firstElementChild;if(!domNode){throw new Error('the template is empty');}
this.htmlNode=domNode;this.container=domNode.querySelector('.thumbnail-group-container');}
ThumbnailDateGroup.getGroupID=function(item){var dateObj=new Date(item.date);var month=dateObj.getMonth()+1;return'group_'+dateObj.getFullYear()+'-'+
(month<10?'0'+month:month);};ThumbnailDateGroup.compareGroupID=function(id1,id2){return id1>id2?1:(id1<id2?-1:0);};ThumbnailDateGroup.prototype.addItem=function(item){if(!item){return;}
var self=this;function getInsertPosition(thumbnail){if(self.thumbnails.length===0||thumbnail.data.date>self.thumbnails[0].data.date){return 0;}
else if(thumbnail.data.date<self.thumbnails[self.thumbnails.length-1].data.date){return self.thumbnails.length;}
else{return MediaUtils.binarySearch(self.thumbnails,thumbnail,function(a,b){return b.data.date-a.data.date;});}}
var thumbnail=new ThumbnailItem(item);var insertPosition=getInsertPosition(thumbnail);this.container.insertBefore(thumbnail.htmlNode,this.container.children[insertPosition]);this.thumbnails.splice(insertPosition,0,thumbnail);return thumbnail;};ThumbnailDateGroup.prototype.getCount=function(){return this.thumbnails.length;};ThumbnailDateGroup.prototype.removeItem=function(thumbnail){var idx=this.thumbnails.indexOf(thumbnail);if(idx<0){return;}
this.thumbnails.splice(idx,1);URL.revokeObjectURL(thumbnail.imgNode.src);this.container.removeChild(thumbnail.htmlNode);};;function ThumbnailList(groupClass,container){if(!groupClass||!container){throw new Error('group class or container cannot be null or undefined');}
this.thumbnailMap={};this.groupMap={};this.itemGroups=[];this.count=0;this.groupClass=groupClass;this.container=container;}
ThumbnailList.prototype.addItem=function(item){if(!item){return null;}
if(this.thumbnailMap[item.name]){return this.thumbnailMap[item.name];}
var self=this;function createItemGroup(item,before){var group=new self.groupClass(item);self.container.insertBefore(group.htmlNode,before?before.htmlNode:null);return group;}
function getItemGroup(item){var groupID=self.groupClass.getGroupID(item);var i;for(i=0;i<self.itemGroups.length;i++){if(self.itemGroups[i].groupID===groupID){return self.itemGroups[i];}else if(self.groupClass.compareGroupID(self.itemGroups[i].groupID,groupID)<0){break;}}
var createdGroup=createItemGroup(item,self.itemGroups[i]);self.itemGroups.splice(i,0,createdGroup);return createdGroup;}
var group=getItemGroup(item);var thumbnail=group.addItem(item);this.groupMap[item.name]=group;this.thumbnailMap[item.name]=thumbnail;this.count++;return thumbnail;};ThumbnailList.prototype.removeItem=function(filename){if(!this.thumbnailMap[filename]){return;}
var group=this.groupMap[filename];group.removeItem(this.thumbnailMap[filename]);if(!group.getCount()){this.container.removeChild(group.htmlNode);this.itemGroups.splice(this.itemGroups.indexOf(group),1);}
this.count--;delete this.groupMap[filename];delete this.thumbnailMap[filename];};ThumbnailList.prototype.reset=function(){for(var name in this.thumbnailMap){this.groupMap[name].removeItem(this.thumbnailMap[name]);}
this.container.innerHTML='';this.thumbnailMap={};this.itemGroups=[];this.groupMap={};this.count=0;};;var Dialogs={confirm:function(options,onConfirm,onCancel){LazyLoader.load('shared/style/confirm.css',function(){var dialog=$('confirm-dialog');var msgEle=$('confirm-msg');var cancelButton=$('confirm-cancel');var confirmButton=$('confirm-ok');msgEle.textContent=options.message;cancelButton.textContent=options.cancelText||navigator.mozL10n.get('cancel');confirmButton.textContent=options.confirmText||navigator.mozL10n.get('ok');if(options.danger){confirmButton.classList.add('danger');}else{confirmButton.classList.remove('danger');}
dialog.classList.remove('hidden');var onCancelClick=function(ev){close(ev);if(onCancel){onCancel();}
return false;};var onConfirmClick=function(ev){close(ev);if(onConfirm){onConfirm();}
return false;};cancelButton.addEventListener('click',onCancelClick);confirmButton.addEventListener('click',onConfirmClick);function close(ev){dialog.classList.add('hidden');cancelButton.removeEventListener('click',onCancelClick);confirmButton.removeEventListener('click',onConfirmClick);ev.preventDefault();ev.stopPropagation();return false;}});},showOverlay:function(id){LazyLoader.load('shared/style/confirm.css',function(){$('overlay-camera-button').classList.add('hidden');$('overlay-cancel-button').classList.add('hidden');$('overlay-menu').classList.add('hidden');var title,text;var _=navigator.mozL10n.get;switch(id){case null:$('overlay').classList.add('hidden');return;case'nocard':title=_('nocard3-title');text=_('nocard4-text');if(pendingPick){$('overlay-cancel-button').classList.remove('hidden');$('overlay-menu').classList.remove('hidden');}
break;case'pluggedin':title=_('pluggedin2-title');text=_('pluggedin2-text');if(pendingPick){$('overlay-cancel-button').classList.remove('hidden');$('overlay-menu').classList.remove('hidden');}
break;case'scanning':title=_('scanning-title');text=_('scanning-text');if(pendingPick){$('overlay-cancel-button').classList.remove('hidden');$('overlay-menu').classList.remove('hidden');}
break;case'emptygallery':title=_(pendingPick?'emptygallery2-title-pick':'emptygallery2-title');text=_('emptygallery2-text');$('overlay-menu').classList.remove('hidden');if(pendingPick){$('overlay-cancel-button').classList.remove('hidden');}else{$('overlay-camera-button').classList.remove('hidden');}
break;case'upgrade':title=_('upgrade-title');text=_('upgrade-text');if(pendingPick){$('overlay-cancel-button').classList.remove('hidden');$('overlay-menu').classList.remove('hidden');}
break;default:console.warn('Reference to undefined overlay',id);if(pendingPick){$('overlay-cancel-button').classList.remove('hidden');$('overlay-menu').classList.remove('hidden');}
return;}
$('overlay-title').textContent=title;$('overlay-text').textContent=text;$('overlay').classList.remove('hidden');});}};;'use strict';var TRANSITION_FRACTION=0.25;var TRANSITION_SPEED=0.75;var PAGE_SIZE=15;function $(id){return document.getElementById(id);}
var thumbnails=$('thumbnails');var fullscreenView=$('fullscreen-view');const LAYOUT_MODE={list:'thumbnailListView',select:'thumbnailSelectView',fullscreen:'fullscreenView',edit:'editView',pick:'pickView',crop:'cropView'};var currentView;var languageDirection;ScreenLayout.watch('portrait','(orientation: portrait)');var isPortrait=ScreenLayout.getCurrentLayout('portrait');var isPhone=ScreenLayout.getCurrentLayout('tiny');var fullscreenButtonIds=['back','delete','edit','share','camera','info'];var fullscreenButtons={};for(var i=0;i<fullscreenButtonIds.length;i++){var name='fullscreen-'+fullscreenButtonIds[i]+'-button';name+=(isPhone?'-tiny':'-large');fullscreenButtons[fullscreenButtonIds[i]]=document.getElementById(name);}
var files=[];var thumbnailList;var currentFileIndex=0;var editedPhotoIndex;var selectedFileNames=[];var selectedFileNamesToBlobs={};var photodb;var videostorage;var isInitThumbnail=false;var loader=LazyLoader;var hasSaved=false;var lastFocusedThumbnail=null;var currentOverlay;navigator.mozL10n.ready(function showBody(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;document.body.classList.remove('hidden');if(!isPhone){loader.load('js/frame_scripts.js');}
if(!photodb)
init();});function init(){$('thumbnails-select-button').onclick=setView.bind(null,LAYOUT_MODE.select);$('thumbnails-cancel-button').onclick=setView.bind(null,LAYOUT_MODE.list);$('pick-back-button').onclick=cancelPick;$('crop-back-button').onclick=function(){setView(LAYOUT_MODE.pick);cleanupCrop();};fullscreenButtons.camera.onclick=launchCameraApp;$('thumbnails-camera-button').onclick=launchCameraApp;$('overlay-camera-button').onclick=launchCameraApp;$('thumbnails-delete-button').onclick=deleteSelectedItems;$('thumbnails-share-button').onclick=shareSelectedItems;$('overlay-cancel-button').onclick=function(){cancelPick();};window.onresize=resizeHandler;if(!navigator.mozHasPendingMessage('activity')){initDB();setView(LAYOUT_MODE.list);}
navigator.mozSetMessageHandler('activity',function activityHandler(a){var activityName=a.source.name;switch(activityName){case'browse':if(!photodb){initDB();setView(LAYOUT_MODE.list);}
else{if(currentView===LAYOUT_MODE.fullscreen)
setView(LAYOUT_MODE.list);}
break;case'pick':if(pendingPick)
cancelPick();pendingPick=a;if(!photodb)
initDB();startPick();break;}});}
function initDB(){photodb=new MediaDB('pictures',metadataParserWrapper,{version:2,autoscan:false,batchHoldTime:2000,batchSize:3});videostorage=navigator.getDeviceStorage('videos');var loaded=false;function metadataParserWrapper(file,onsuccess,onerror,bigFile){if(loaded){metadataParser(file,onsuccess,onerror,bigFile);return;}
loader.load(['js/metadata_scripts.js','shared/js/media/crop_resize_rotate.js'],function(){loaded=true;metadataParser(file,onsuccess,onerror,bigFile);});}
photodb.onupgrading=function(evt){showOverlay('upgrade');};photodb.onunavailable=function(event){setView(LAYOUT_MODE.list);var why=event.detail;if(why===MediaDB.NOCARD)
showOverlay('nocard');else if(why===MediaDB.UNMOUNTED)
showOverlay('pluggedin');};photodb.onready=function(){if(currentOverlay==='nocard'||currentOverlay==='pluggedin'||currentOverlay==='upgrade')
showOverlay(null);initThumbnails();};photodb.onscanstart=function onscanstart(){fullscreenButtons.edit.classList.add('disabled');$('progress').classList.remove('hidden');$('throbber').classList.add('throb');};photodb.onscanend=function onscanend(){fullscreenButtons.edit.classList.remove('disabled');if(currentOverlay==='scanning')
showOverlay('emptygallery');else if(!isPhone&&!currentFrame.displayingImage&&!currentFrame.displayingVideo){showFile(0);}
$('progress').classList.add('hidden');$('throbber').classList.remove('throb');};photodb.oncardremoved=function oncardremoved(){if(pendingPick){cancelPick();return;}
setView(LAYOUT_MODE.list);};photodb.oncreated=function(event){event.detail.forEach(fileCreated);};photodb.ondeleted=function(event){event.detail.forEach(fileDeleted);};doNotScanInBackgroundHack(photodb);}
function getVideoFile(filename,callback){var req=videostorage.get(filename);req.onsuccess=function(){callback(req.result);};req.onerror=function(){console.error('Failed to get video file',filename);};}
function compareFilesByDate(a,b){if(a.date<b.date)
return 1;else if(a.date>b.date)
return-1;return 0;}
function initThumbnails(){if(isInitThumbnail){photodb.scan();return;}
isInitThumbnail=true;ThumbnailDateGroup.Template=new Template('thumbnail-group-header');thumbnailList=new ThumbnailList(ThumbnailDateGroup,thumbnails);thumbnails.addEventListener('click',thumbnailClickHandler);var batch=[];var batchsize=PAGE_SIZE;photodb.enumerate('date',null,'prev',function(fileinfo){if(fileinfo){if(pendingPick&&fileinfo.metadata.video)
return;var metadata=fileinfo.metadata;if(metadata&&metadata.preview&&metadata.preview.filename){metadata.preview.width=Math.floor(metadata.preview.width);metadata.preview.height=Math.floor(metadata.preview.height);}
batch.push(fileinfo);if(batch.length>=batchsize){flush();batchsize*=2;}}
else{done();}});function flush(){batch.forEach(thumb);batch.length=0;}
function thumb(fileinfo){files.push(fileinfo);thumbnailList.addItem(fileinfo);}
function done(){flush();if(files.length===0){showOverlay('scanning');}
photodb.scan();}}
function getFileIndex(filename){var fileGroup=thumbnailList.groupMap[filename];if(!fileGroup){console.error('file group does not exist in thumbnail List',filename);return-1;}
var index=0;var thumbnail=thumbnailList.thumbnailMap[filename];index=fileGroup.thumbnails.indexOf(thumbnail);if(index<0){console.error('filename does not exist in thumbnail list',filename);return-1;}
for(var n=0;n<thumbnailList.itemGroups.length;n++){if(thumbnailList.itemGroups[n].groupID===fileGroup.groupID){break;}
index+=thumbnailList.itemGroups[n].getCount();}
return index;}
function fileDeleted(filename){var fileIndex=currentFileIndex;for(var n=0;n<files.length;n++){if(files[n].name===filename)
break;}
if(n>=files.length)
return;files.splice(n,1)[0];thumbnailList.removeItem(filename);if(n<fileIndex)
fileIndex--;if(fileIndex>=files.length)
fileIndex=files.length-1;if(n<editedPhotoIndex)
editedPhotoIndex--;if(files.length>0&&(currentView===LAYOUT_MODE.fullscreen)){showFile(fileIndex);}else{updateFocusThumbnail(fileIndex);}
if(files.length===0){if(currentView!==LAYOUT_MODE.pick)
setView(LAYOUT_MODE.list);showOverlay('emptygallery');}}
function deleteFile(n){if(n<0||n>=files.length)
return;var fileinfo=files[n];photodb.deleteFile(files[n].name);if(fileinfo.metadata.video){videostorage.delete(fileinfo.metadata.video);}
if(fileinfo.metadata.preview&&fileinfo.metadata.preview.filename){var pictures=navigator.getDeviceStorage('pictures');pictures.delete(fileinfo.metadata.preview.filename);}}
function fileCreated(fileinfo){if(pendingPick&&fileinfo.metadata.video)
return;photodb.getFileInfo(fileinfo.name,function(fileinfo){var insertPosition;if(currentOverlay==='emptygallery'||currentOverlay==='scanning')
showOverlay(null);var thumbnailItem=thumbnailList.addItem(fileinfo);insertPosition=getFileIndex(fileinfo.name);if(insertPosition<0)
return;files.splice(insertPosition,0,fileinfo);if(currentFileIndex>=insertPosition)
currentFileIndex++;if(editedPhotoIndex>=insertPosition)
editedPhotoIndex++;if(currentView===LAYOUT_MODE.fullscreen){if(hasSaved){showFile(0);}else{showFile(currentFileIndex);}}
hasSaved=false;});}
function scrollToShowThumbnail(n){if(!files[n])
return;var selector='li[data-filename="'+files[n].name+'"]';var thumbnail=thumbnails.querySelector(selector);if(thumbnail){var screenTop=thumbnails.scrollTop;var screenBottom=screenTop+thumbnails.clientHeight;var thumbnailTop=thumbnail.offsetTop;var thumbnailBottom=thumbnailTop+thumbnail.offsetHeight;var toolbarHeight=40;screenBottom-=toolbarHeight;if(thumbnailTop<screenTop){thumbnails.scrollTop=thumbnailTop;}
else if(thumbnailBottom>screenBottom){thumbnails.scrollTop=thumbnailBottom-thumbnails.clientHeight+toolbarHeight;}}}
function setView(view){if(currentView===view)
return;document.body.classList.remove(currentView);document.body.classList.add(view);switch(currentView){case LAYOUT_MODE.select:Array.forEach(thumbnails.querySelectorAll('.selected.thumbnailImage'),function(elt){elt.classList.remove('selected');});if(!isPhone)
showFile(currentFileIndex);break;case LAYOUT_MODE.fullscreen:if(!isPhone&&(view===LAYOUT_MODE.list)&&!isPortrait){resizeFrames();}else{clearFrames();}
break;}
switch(view){case LAYOUT_MODE.list:scrollToShowThumbnail(currentFileIndex);if(currentView===LAYOUT_MODE.fullscreen){setNFCSharing(false);}
break;case LAYOUT_MODE.fullscreen:resizeFrames();setNFCSharing(true);break;case LAYOUT_MODE.select:clearSelection();if(!isPhone&&currentFrame.video&&!isPortrait)
currentFrame.video.pause();break;case LAYOUT_MODE.edit:setNFCSharing(false);break;}
if(!isPhone){if(view!==LAYOUT_MODE.fullscreen){$('fullscreen-title').textContent=navigator.mozL10n.get('preview');}else{$('fullscreen-title').textContent=navigator.mozL10n.get('gallery');}}
currentView=view;}
function setNFCSharing(enable){if(!window.navigator.mozNfc){return;}
if(enable){window.navigator.mozNfc.onpeerready=function(event){var fileInfo=files[currentFileIndex];if(fileInfo.metadata.video){getVideoFile(fileInfo.metadata.video,function(file){navigator.mozNfc.getNFCPeer(event.detail).sendFile(file);});}else{photodb.getFile(fileInfo.name,function(file){navigator.mozNfc.getNFCPeer(event.detail).sendFile(file);});}};}else{window.navigator.mozNfc.onpeerready=null;}}
var pendingPick;var pickType;var pickWidth,pickHeight;var pickedFileInfo;var cropEditor;function startPick(){pickType=pendingPick.source.data.type;if(pendingPick.source.data.width&&pendingPick.source.data.height){pickWidth=pendingPick.source.data.width;pickHeight=pendingPick.source.data.height;}
else{pickWidth=pickHeight=0;}
setView(LAYOUT_MODE.pick);}
function cropPickedImage(fileinfo){pickedFileInfo=fileinfo;var nocrop=pendingPick.source.data.nocrop;if(nocrop){$('crop-header').textContent='';}
setView(LAYOUT_MODE.crop);var doneButton=$('crop-done-button');doneButton.disabled=true;loader.load(['js/frame_scripts.js','shared/js/media/crop_resize_rotate.js','js/ImageEditor.js'],gotScripts);function gotScripts(){photodb.getFile(pickedFileInfo.name,gotFile);}
function gotFile(pickedFile){var previewData=pickedFileInfo.metadata.preview;if(!previewData){startCrop();}
else if(previewData.filename){var storage=navigator.getDeviceStorage('pictures');var getreq=storage.get(previewData.filename);getreq.onsuccess=function(){startCrop(getreq.result);};getreq.onerror=function(){startCrop();};}
else{startCrop(pickedFile.slice(previewData.start,previewData.end,'image/jpeg'));}
function startCrop(previewBlob){var blob,metadata,outputSize,useSpinner;if(previewBlob){blob=previewBlob;metadata={width:previewData.width,height:previewData.height,rotation:pickedFileInfo.metadata.rotation,mirrored:pickedFileInfo.metadata.mirrored};outputSize=null;useSpinner=false;}
else{blob=pickedFile;metadata=pickedFileInfo.metadata;var windowSize=window.innerWidth*window.innerHeight*window.devicePixelRatio*window.devicePixelRatio;outputSize=Math.min(windowSize,CONFIG_MAX_PICK_PIXEL_SIZE||CONFIG_MAX_IMAGE_PIXEL_SIZE);useSpinner=metadata.width*metadata.height>outputSize;}
if(useSpinner){showSpinner();}
cropResizeRotate(blob,null,outputSize,null,metadata,gotRotatedBlob);}
function gotRotatedBlob(error,rotatedBlob){hideSpinner();if(error){console.error('Error while rotating image:',error);rotatedBlob=pickedFile;}
cropEditor=new ImageEditor(rotatedBlob,$('crop-frame'),{},cropEditorReady,true);}
function cropEditorReady(){doneButton.onclick=cropAndEndPick;doneButton.disabled=false;if(nocrop){cropEditor.cropRegion.left=cropEditor.cropRegion.top=0;cropEditor.cropRegion.right=cropEditor.dest.w;cropEditor.cropRegion.bottom=cropEditor.dest.h;return;}
cropEditor.showCropOverlay();if(pickWidth)
cropEditor.setCropAspectRatio(pickWidth,pickHeight);else
cropEditor.setCropAspectRatio();}
function cropAndEndPick(){if(Array.isArray(pickType)){if(pickType.indexOf(pickedFileInfo.type)!==-1){pickType=pickedFileInfo.type;}
else if(pickType.indexOf('image/jpeg')!==-1){pickType='image/jpeg';}
else if(pickType.indexOf('image/png')!==-1){pickType='image/png';}
else{pickType=null;}}
else if(pickType==='image/*'){pickType=null;}
if(pickType&&pickType!=='image/jpeg'&&pickType!=='image/png')
pickType=null;var fullImageWidth,fullImageHeight;var rotation=pickedFileInfo.metadata.rotation||0;if(rotation===90||rotation===270){fullImageWidth=pickedFileInfo.metadata.height;fullImageHeight=pickedFileInfo.metadata.width;}
else{fullImageWidth=pickedFileInfo.metadata.width;fullImageHeight=pickedFileInfo.metadata.height;}
var cropRegion;if(pendingPick.source.data.nocrop||!cropEditor.hasBeenCropped()){cropRegion=null;}
else{cropRegion=cropEditor.getCropRegion();cropRegion.left=Math.round(cropRegion.left*fullImageWidth);cropRegion.top=Math.round(cropRegion.top*fullImageHeight);cropRegion.width=Math.round(cropRegion.width*fullImageWidth);cropRegion.height=Math.round(cropRegion.height*fullImageHeight);}
var outputSize;if(pickWidth&&pickHeight){outputSize={width:pickWidth,height:pickHeight};}
else{outputSize=CONFIG_MAX_PICK_PIXEL_SIZE||CONFIG_MAX_IMAGE_PIXEL_SIZE;}
if(cropRegion!==null||typeof outputSize==='object'||outputSize<fullImageWidth*fullImageHeight||pickedFileInfo.metadata.rotation||pickedFileInfo.metadata.mirrored){showSpinner();}
cropResizeRotate(pickedFile,cropRegion,outputSize,pickType,pickedFileInfo.metadata,function(error,blob){hideSpinner();if(error){console.error('while resizing image: '+error);blob=pickedFile;}
endPick(blob);});}}}
function endPick(blob){pendingPick.postResult({type:blob.type,blob:blob});cleanupPick();}
function cancelPick(){pendingPick.postError('pick cancelled');cleanupPick();}
function cleanupCrop(){if(cropEditor){cropEditor.destroy();cropEditor=null;}}
function cleanupPick(){cleanupCrop();pendingPick=null;pickedFileInfo=null;setView(LAYOUT_MODE.list);}
window.addEventListener('visibilitychange',function(){if(document.hidden&&pendingPick)
cancelPick();});function thumbnailClickHandler(evt){var target=evt.target;if(!target||!target.classList.contains('thumbnailImage'))
return;var index=getFileIndex(target.dataset.filename);if(currentView===LAYOUT_MODE.pick&&index>=0){cropPickedImage(files[index]);}else if(currentView===LAYOUT_MODE.select){updateSelection(target);}else{loader.load('js/frame_scripts.js',function(){if(isPortrait||isPhone){setView(LAYOUT_MODE.fullscreen);}
showFile(index);});}}
function updateFocusThumbnail(n){var previousIndex=currentFileIndex;currentFileIndex=n;if(isPhone)
return;var newTarget=thumbnailList.thumbnailMap[files[currentFileIndex].name];if(newTarget)
newTarget.htmlNode.classList.add('focus');if(previousIndex===currentFileIndex)
return;var oldTarget=files[previousIndex]?thumbnailList.thumbnailMap[files[previousIndex].name]:undefined;if(oldTarget)
oldTarget.htmlNode.classList.remove('focus');}
function clearSelection(){if(!isPhone){clearFrames();}
selectedFileNames=[];selectedFileNamesToBlobs={};$('thumbnails-delete-button').classList.add('disabled');$('thumbnails-share-button').classList.add('disabled');$('thumbnails-number-selected').textContent=navigator.mozL10n.get('number-selected2',{n:0});}
function updateSelection(thumbnail){thumbnail.classList.toggle('selected');var selected=thumbnail.classList.contains('selected');var index=getFileIndex(thumbnail.dataset.filename);if(index<0)
return;var filename=files[index].name;if(selected){selectedFileNames.push(filename);updateFocusThumbnail(index);if(files[index].metadata.video){getVideoFile(files[index].metadata.video,function(file){selectedFileNamesToBlobs[filename]=file;});}
else{photodb.getFile(filename,function(file){selectedFileNamesToBlobs[filename]=file;});}
if(!isPhone)
showFile(currentFileIndex);}
else{delete selectedFileNamesToBlobs[filename];var i=selectedFileNames.indexOf(filename);if(i!==-1)
selectedFileNames.splice(i,1);if(currentFileIndex===index&&!isPhone){if(i>0){var lastSelected=selectedFileNames[i-1];var lastSelectedIndex=getFileIndex(lastSelected);updateFocusThumbnail(lastSelectedIndex);showFile(currentFileIndex);}else{clearFrames();}}}
var numSelected=selectedFileNames.length;var msg=navigator.mozL10n.get('number-selected2',{n:numSelected});$('thumbnails-number-selected').textContent=msg;if(numSelected===0){$('thumbnails-delete-button').classList.add('disabled');$('thumbnails-share-button').classList.add('disabled');}
else{$('thumbnails-delete-button').classList.remove('disabled');$('thumbnails-share-button').classList.remove('disabled');}}
function launchCameraApp(){fullscreenButtons.camera.classList.add('disabled');$('thumbnails-camera-button').classList.add('disabled');$('overlay-camera-button').classList.add('disabled');var a=new MozActivity({name:'record',data:{type:'photos'}});window.setTimeout(function(){fullscreenButtons.camera.classList.remove('disabled');$('thumbnails-camera-button').classList.remove('disabled');$('overlay-camera-button').classList.remove('disabled');},2000);}
function deleteSelectedItems(){var selected=thumbnails.querySelectorAll('.selected.thumbnailImage');if(selected.length===0)
return;Dialogs.confirm({message:navigator.mozL10n.get('delete-n-items?',{n:selected.length}),cancelText:navigator.mozL10n.get('cancel'),confirmText:navigator.mozL10n.get('delete'),danger:true},function(){for(var i=0;i<selected.length;i++){selected[i].classList.toggle('selected');deleteFile(getFileIndex(selected[i].dataset.filename));}
clearSelection();});}
function shareSelectedItems(){var blobs=selectedFileNames.map(function(name){return selectedFileNamesToBlobs[name];});share(blobs);}
function share(blobs,blobName){if(blobs.length===0)
return;var names=[],types=[],fullpaths=[];blobs.forEach(function(blob){var name=blob.name;if(!name&&blobs.length===1)
name=blobName;fullpaths.push(name);name=name.substring(name.lastIndexOf('/')+1);names.push(name);var type=blob.type;if(type)
type=type.substring(0,type.indexOf('/'));types.push(type);});var type;if(types.length===1||types.every(function(t){return t===types[0];}))
type=types[0]+'/*';else
type='multipart/mixed';var a=new MozActivity({name:'share',data:{type:type,number:blobs.length,blobs:blobs,filenames:names,filepaths:fullpaths}});a.onerror=function(e){if(a.error.name==='NO_PROVIDER'){var msg=navigator.mozL10n.get('share-noprovider');alert(msg);}
else{console.warn('share activity error:',a.error.name);}};}
function resizeHandler(){isPortrait=ScreenLayout.getCurrentLayout('portrait');if(currentView===LAYOUT_MODE.list&&isPortrait&&typeof currentFrame!=='undefined'&&currentFrame.video){currentFrame.video.pause();}
if(currentView===LAYOUT_MODE.fullscreen||(!isPhone&&!isPortrait&&(currentView===LAYOUT_MODE.list||currentView===LAYOUT_MODE.select))){resizeFrames();setFramesPosition();}}
function showOverlay(id){currentOverlay=id;Dialogs.showOverlay(id);}
$('overlay').addEventListener('click',function dummyHandler(){});window.addEventListener('scrollstart',function onScrollStart(e){thumbnails.classList.add('scrolling');});window.addEventListener('scrollend',function onScrollEnd(e){thumbnails.classList.remove('scrolling');});function showSpinner(){$('spinner').classList.remove('hidden');}
function hideSpinner(){$('spinner').classList.add('hidden');}
function doNotScanInBackgroundHack(photodb){const enoughMB=512;var memoryMB=0;window.addEventListener('visibilitychange',backgroundScanKiller);photodb.addEventListener('scanend',function(){window.removeEventListener('visibilitychange',backgroundScanKiller);});function backgroundScanKiller(){if(!document.hidden||memoryMB>=enoughMB){return;}
if(!navigator.getFeature){exit();}
else{navigator.getFeature('hardware.memory').then(function(mem){memoryMB=mem;if(memoryMB<enoughMB){exit();}});}
function exit(){if(document.hidden&&photodb.scanning){console.warn('[Gallery] exiting to avoid background scan.');setTimeout(function(){window.close();},500);}}}}