
require.config({
  baseUrl: '/js',
  paths: {
    'l10n': '../shared/js/l10n',
    'asyncStorage': '../shared/js/async_storage',
    'getVideoRotation': '../shared/js/media/get_video_rotation',
    'performanceTesting': '../shared/js/performance_testing_helper',
    'jpegMetaDataParser': '../shared/js/media/jpeg_metadata_parser',
    'downsample': '../shared/js/media/downsample',
    'getImageSize': '../shared/js/media/image_size',
    'cropResizeRotate': '../shared/js/media/crop_resize_rotate',
    'format': '../shared/js/format',
    'GestureDetector': '../shared/js/gesture_detector',
    'VideoPlayer': '../shared/js/media/video_player',
    'MediaFrame': '../shared/js/media/media_frame',
    'BlobView': '../shared/js/blobview',
    'CustomDialog': '../shared/js/custom_dialog',
    'debug': 'vendor/debug'
  },
  shim: {
    'format': {
      exports: 'Format'
    },
    'getVideoRotation': {
      deps: ['BlobView'],
      exports: 'getVideoRotation'
    },
    'MediaFrame': {
      deps: ['format', 'VideoPlayer'],
      exports: 'MediaFrame'
    },
    'BlobView': {
      exports: 'BlobView'
    },
    'asyncStorage': {
      exports: 'asyncStorage'
    },
    'performanceTesting': {
      exports: 'PerformanceTestingHelper'
    },
    'jpegMetaDataParser': {
      deps: ['BlobView'],
      exports: 'parseJPEGMetadata'
    },
    'getImageSize': {
      deps: ['BlobView', 'jpegMetaDataParser'],
      exports: 'getImageSize'
    },
    'cropResizeRotate': {
      deps: ['BlobView', 'getImageSize', 'jpegMetaDataParser', 'downsample'],
      exports: 'cropResizeRotate'
    },
    'GestureDetector': {
      exports: 'GestureDetector'
    },
    'CustomDialog': {
      exports: 'CustomDialog'
    }
  }
});

define("config/require", function(){});

//
// This file is automatically generated: DO NOT EDIT.
// To change these values, create a camera.json file in the
// distribution directory with content like this: 
//
//   {
//     "maxImagePixelSize": 6000000,
//     "maxSnapshotPixelSize": 4000000, 
//     "avgJpegCompressionRatio": 24 
//   }
//
// Optionally, you can also define variables to specify the
// minimum EXIF preview size that will be displayed as a
// full-screen preview by adding a property like this:
//
// "requiredEXIFPreviewSize": { "width": 640, "height": 480}
//
// If you do not specify this property then EXIF previews will only
// be used if they are big enough to fill the screen in either
// width or height in both landscape and portrait mode.
//
var CONFIG_MAX_IMAGE_PIXEL_SIZE = 5242880;
var CONFIG_MAX_SNAPSHOT_PIXEL_SIZE = 5242880;
var CONFIG_AVG_JPEG_COMPRESSION_RATIO = 8;
var CONFIG_REQUIRED_EXIF_PREVIEW_WIDTH = 0;
var CONFIG_REQUIRED_EXIF_PREVIEW_HEIGHT = 0;

define("config", function(){});

define('debug',['require','exports','module'],function(require, exports, module) {


/**
* Expose `debug()` as the module.
*/

module.exports = debug;

/**
* Create a debugger with the given `name`.
*
* @param {String} name
* @return {Type}
*/

function debug(name) {
  if (!debug.enabled(name)) return function() {};

  return function(fmt) {
    fmt = coerce(fmt);

    var curr = new Date;
    var ms = curr - (debug[name] || curr);
    debug[name] = curr;

    fmt = '[' + name + '] ' + fmt + ' +' + debug.humanize(ms);

    // This hackery is required for IE8
    // where `console.log` doesn't have 'apply'
    window.console && console.log &&
      Function.prototype.apply.call(console.log, console, arguments);
  }
}

/**
* The currently active debug mode names.
*/

debug.names = [];
debug.skips = [];

/**
* Enables a debug mode by name. This can include modes
* separated by a colon and wildcards.
*
* @param {String} name
*/

debug.enable = function(name) {
  try {
    localStorage.debug = name;
  } catch (e) {}

  var split = (name || '').split(/[\s,]+/);
  var len = split.length;

  for (var i = 0; i < len; i++) {
    name = split[i].replace('*', '.*?');
    if (name[0] === '-') {
      debug.skips.push(new RegExp('^' + name.substr(1) + '$'));
    }
    else {
      debug.names.push(new RegExp('^' + name + '$'));
    }
  }
};

/**
* Disable debug output.
*
*/

debug.disable = function() {
  debug.enable('');
};

/**
* Humanize the given `ms`.
*
* @param {Number} m
* @return {String}
*/

debug.humanize = function(ms) {
  var sec = 1000;
  var min = 60 * 1000;
  var hour = 60 * min;

  if (ms >= hour) return (ms / hour).toFixed(1) + 'h';
  if (ms >= min) return (ms / min).toFixed(1) + 'm';
  if (ms >= sec) return (ms / sec | 0) + 's';
  return ms + 'ms';
};

/**
* Returns true if the given mode name is enabled, false otherwise.
*
* @param {String} name
* @return {Boolean}
*/

debug.enabled = function(name) {
  for (var i = 0, len = debug.skips.length; i < len; i++) {
    if (debug.skips[i].test(name)) {
      return false;
    }
  }
  for (var i = 0, len = debug.names.length; i < len; i++) {
    if (debug.names[i].test(name)) {
      return true;
    }
  }
  return false;
};

/**
* Coerce `val`.
*/

function coerce(val) {
  if (val instanceof Error) return val.stack || val.message;
  return val;
}

// persist

try {
  if (window.localStorage) debug.enable(localStorage.debug);
} catch (e) {}

});

define('lib/bind-all',['require','exports','module'],function(require, exports, module) {


/**
 * Expose `bindAll`
 */

module.exports = bindAll;

function bindAll(object) {
  var key;
  var fn;
  for (key in object) {
    fn = object[key];
    if (typeof fn === 'function') {
      object[key] = fn.bind(object);
    }
  }
}

});


/**
 * Event
 *
 * A super lightweight
 * event emitter library.
 *
 * @version 0.3.3
 * @author Wilson Page <wilson.page@me.com>
 */

;(function() {

/**
 * Locals
 */

var proto = Events.prototype;
var slice = [].slice;

/**
 * Creates a new event emitter
 * instance, or if passed an
 * object, mixes the event logic
 * into it.
 *
 * @param  {Object} obj
 * @return {Object}
 */
function Events(obj) {
  if (!(this instanceof Events)) { return new Events(obj); }
  if (obj) { return mixin(obj, proto); }
}

/**
 * Registers a callback
 * with an event name.
 *
 * @param  {String}   name
 * @param  {Function} cb
 * @return {Event}
 */
proto.on = function(name, cb) {
  this._cbs = this._cbs || {};
  (this._cbs[name] || (this._cbs[name] = [])).push(cb);
  return this;
};

proto.once = function(name, cb) {
  this.on(name, one);
  function one() {
    cb.apply(this, arguments);
    this.off(name, one);
  }
};

/**
 * Removes a single callback,
 * or all callbacks associated
 * with the passed event name.
 *
 * @param  {String}   name
 * @param  {Function} cb
 * @return {Event}
 */
proto.off = function(name, cb) {
  this._cbs = this._cbs || {};

  if (!name) { this._cbs = {}; return; }
  if (!cb) { return delete this._cbs[name]; }

  var cbs = this._cbs[name] || [];
  var i;

  while (cbs && ~(i = cbs.indexOf(cb))) { cbs.splice(i, 1); }
  return this;
};

/**
 * Fires an event, triggering
 * all callbacks registered on this
 * event name.
 *
 * @param  {String} name
 * @return {Event}
 */
proto.fire = proto.emit = function(options) {
  var cbs = this._cbs = this._cbs || {};
  var name = options.name || options;
  var batch = (cbs[name] || []).concat(cbs['*'] || []);
  var ctx = options.ctx || this;

  if (batch.length) {
    this._fireArgs = arguments;
    var args = slice.call(arguments, 1);
    while (batch.length) {
      batch.shift().apply(ctx, args);
    }
  }

  return this;
};

proto.firer = function(name) {
  var self = this;
  return function() {
    var args = slice.call(arguments);
    args.unshift(name);
    self.fire.apply(self, args);
  };
};

/**
 * Util
 */

/**
 * Mixes in the properties
 * of the second object into
 * the first.
 *
 * @param  {Object} a
 * @param  {Object} b
 * @return {Object}
 */
function mixin(a, b) {
  for (var key in b) { a[key] = b[key]; }
  return a;
}

/**
 * Expose 'Event' (UMD)
 */

if (typeof exports === 'object') {
  module.exports = Events;
} else if (typeof define === 'function' && define.amd) {
  define('vendor/evt',[],function(){ return Events; });
} else {
  window.evt = Events;
}

})();
define('lib/mixin',['require','exports','module'],function(require, exports, module) {
  

  module.exports = function(a, b) {
    for (var key in b) { a[key] = b[key]; }
    return a;
  };
});

define('vendor/view',['require','exports','module','lib/bind-all','vendor/evt','lib/mixin'],function(require, exports, module) {
  

  /**
   * Dependencies
   */

  var bindAll = require('lib/bind-all');
  var events = require('vendor/evt');
  var mixin = require('lib/mixin');

  /**
   * Locals
   */

  var counter = 1;
  var noop = function() {};

  /**
   * Exports
   */

  module.exports = View;

  /**
   * Base view class. Accepts
   * or creates a root element
   * which we template into.
   *
   * @constructor
   */
  function View(options) {
    options = options || {};
    this.el = options.el || this.el || document.createElement(this.tag);
    this.el.id = this.el.id || ('view' + counter++);
    this.name = options.name || this.name;
    this.els = {};

    if (!this.el.className) {
      if (this.name) this.el.className = this.name;
      if (this.className) this.el.className += ' ' + this.className;
    }

    bindAll(this);
    this.initialize.apply(this, arguments);
  }

  /**
   * Base view prototype,
   * mixed in event emitter.
   *
   * @type {Object}
   */
  events(View.prototype);

  // Allow for 'emit' or
  // 'fire' to trigger events
  View.prototype.fire = View.prototype.fire || View.prototype.emit;

  /**
   * Default tagName
   *
   * @type {String}
   */
  View.prototype.tag = 'div';
  View.prototype.name = 'noname';

  /**
   * Appends the root element
   * to the given parent.
   *
   * @param  {Element} parent
   * @return {View}
   */
  View.prototype.appendTo = function(parent) {
    if (!parent) return this;
    parent.appendChild(this.el);
    this.fire('inserted');
    return this;
  };

  /**
   * Prepends the root element
   * to the given parent.
   *
   * @param  {Element} parent
   * @return {View}
   */
  View.prototype.prependTo = function(parent) {
    if (!parent) return this;
    var first = parent.firstChild;

    if (first) parent.insertBefore(this.el, first);
    else this.appendTo(parent);

    this.fire('inserted');
    return this;
  };

  /**
   * Convenient shorthand
   * querySelector.
   *
   * @param  {String} query
   * @return { Element | null}
   */
  View.prototype.find = function(query) {
    return this.el.querySelector(query);
  };

  /**
   * Removes the element from
   * its current DOM location.
   *
   * @param  {Object} options
   * @return {View}
   */
  View.prototype.remove = function(options) {
    var silent = options && options.silent;
    var parent = this.el.parentNode;
    if (!parent) return this;
    parent.removeChild(this.el);
    if (!silent) this.fire('remove');
    return this;
  };

  View.prototype.set = function(key, value) {
    value = value === undefined ? '' : value;
    this.el.setAttribute(toDashed(key), value);
  };

  /**
   * Returns a function that when called
   * will .set() the given key.
   *
   * If a value is passed to .setter(),
   * that value will always be used
   * when the returned function is called.
   * Else the value passed to the given
   * function will be used.
   *
   * Example:
   *
   * var setter = this.setter('key', 'value');
   * setter(); //=> this.set('key', 'value');
   * setter('value2'); //=> this.set('key', 'value');
   *
   * var setter = this.setter('key');
   * setter('value'); //=> this.set('key', 'value');
   * setter(); //=> this.set('key');
   *
   * @param  {String} key
   * @param  {*} value
   * @return {Function}
   */
  View.prototype.setter = function(key, forced) {
    var self = this;
    return function(passed) {
      var value = forced !== undefined ? forced : passed;
      self.set(key, value);
    };
  };

  View.prototype.enable = function(key, value) {
    switch(arguments.length) {
      case 0:
        value = true;
        key = 'enabled';
        break;
      case 1:
        if (typeof key === 'boolean') {
          value = key;
          key = 'enabled';
        } else {
          value = true;
          key = key ? key + '-enabled' : 'enabled';
        }
        break;
      default:
        key = key ? key + '-enabled' : 'enabled';
    }
    this.set(key, !!value);
  };

  View.prototype.disable = function(key) {
    this.enable(key, false);
  };

  View.prototype.enabler = function(key) {
    return (function(value) { this.enable(key, value); }).bind(this);
  };

  View.prototype.hide = function(key) {
    this.toggle(key, false);
  };

  View.prototype.show =  function(key) {
    this.toggle(key, true);
  };

  View.prototype.toggle = function(key, value) {
    if (arguments.length === 1 && typeof key === 'boolean') {
      value = key;
      key = '';
    } else {
      key = key ? key + '-' : '';
    }

    this.el.classList.toggle(key + 'hidden', !value);
    this.el.classList.toggle(key + 'visible', value);
  };

  /**
   * Removes the element from
   * it's current context, firing
   * a 'destroy' event to allow
   * views to perform cleanup.
   *
   * Then clears any internal
   * references to aid GC.
   *
   * @return {[type]} [description]
   */
  View.prototype.destroy = function(options) {
    var noRemove = options && options.noRemove;
    if (!noRemove) this.remove();
    this.fire('destroy');
    this.el = null;
  };

  View.prototype.toString = function() {
    return '[object View]';
  };

  // Overwrite as required
  View.prototype.initialize = noop;
  View.prototype.template = function() { return ''; };

  /**
   * Extends the base view
   * class with the given
   * properties.
   *
   * TODO: Pull this out to
   * standalone module.
   *
   * @param  {Object} properties
   * @return {Function}
   */
  View.extend = function(props) {
    var Parent = this;

    // The extended constructor
    // calls the parent constructor
    var Child = function() {
      Parent.apply(this, arguments);
    };

    Child.prototype = Object.create(Parent.prototype);
    Child.extend = View.extend;
    mixin(Child.prototype, props);

    return Child;
  };

  function toDashed(s) {
    return s.replace(/\W+/g, '-')
      .replace(/([a-z\d])([A-Z])/g, '$1-$2')
      .toLowerCase();
  }
});

define('views/notification',['require','exports','module','vendor/view','lib/mixin'],function(require, exports, module) {


/**
* Dependencies
*/

var View = require('vendor/view');
var mix = require('lib/mixin');

/**
 * Exports
 */

module.exports = View.extend({
  name:'notification',
  tag: 'ul',
  time: 3000,

  initialize: function() {
    this.counter = 0;
    this.hash = {};
  },

  /**
   * Display a new notification.
   *
   * Options:
   *
   *   - `text {String}`
   *   - `className {String}`
   *   - `persistent {Boolean}`
   *
   * @param  {Object} options
   * @return {Number} id for clearing
   * @public
   */
  display: function(options) {
    var item = mix({}, options);
    var id = ++this.counter;
    var self = this;

    item.el = document.createElement('li');
    item.el.className = options.className || '';
    item.el.innerHTML = '<span>' + options.text + '</span>';
    this.el.appendChild(item.el);

    // Remove last temporary
    // notification in the way
    this.clear(this.temporary);

    // Remove non-persistent
    // messages after 3s
    if (!item.persistent) {
      this.temporary = id;
      this.hide(this.persistent);
      item.clearTimeout = setTimeout(function() {
        self.clear(id);
      }, this.time);
    }

    // Remove previous persistent
    if (item.persistent) {
      this.clear(this.persistent);
      this.persistent = id;
    }

    // Store and return
    this.hash[id] = item;
    return id;
  },

  /**
   * Clear notfication by id.
   *
   * Remove the notification from the DOM,
   * clear any existing `clearTimeout` that
   * may have been installed on creation.
   *
   * @param  {Number} item
   * @public
   */
  clear: function(id) {
    var item = this.hash[id];
    if (!item || item.cleared) { return; }

    this.el.removeChild(item.el);
    clearTimeout(item.clearTimeout);
    item.cleared = true;

    // Clear references
    if (item === this.temporary) { this.temporary = null; }
    if (item === this.persistent) { this.persistent = null; }
    delete this.hash[id];

    // Show persistent notification
    // (if there still is one)
    this.show(this.persistent);
  },

  /**
   * Hide a notification.
   *
   * @param  {Number} id
   * @private
   */
  hide: function(id) {
    var item = this.hash[id];
    if (!item) { return; }
    item.el.classList.add('hidden');
  },

  /**
   * Show a hidden notification.
   *
   * @param  {Number} id
   * @private
   */
  show: function(id) {
    var item = this.hash[id];
    if (!item) { return; }
    item.el.classList.remove('hidden');
  }
});

});
define('views/loading-screen',['require','exports','module','debug','vendor/view'],function(require, exports, module) {


var debug = require('debug')('view:loading-screen');
var View = require('vendor/view');

module.exports = View.extend({
  name: 'loading-screen',
  fadeTime: 300,

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template;

    // Clean up
    delete this.template;

    debug('rendered');
    return this;
  },

  show: function(done) {
    this.reflow = this.el.offsetTop;
    View.prototype.show.call(this);
  },

  hide: function(done) {
    View.prototype.hide.call(this);
    if (done) { setTimeout(done, this.fadeTime); }
  },

  template: '<progress></progress>'
});

});
define('lib/bind',['require','exports','module'],function(require, exports, module) {


/**
 * Exports
 */

exports = module.exports = bind;

/**
 * addEventListener shorthand.
 * @param  {Element}   el
 * @param  {String}   name
 * @param  {Function} fn
 */
function bind(el, name, fn, capture) {
  el.addEventListener(name, fn, capture || false);
}

/**
 * removeEventListener shorthand.
 * @param  {Element}   el
 * @param  {String}   name
 * @param  {Function} fn
 */
exports.unbind = function(el, name, fn, capture) {
  el.removeEventListener(name, fn, capture || false);
};

});

define('lib/camera-utils',['require','debug'],function(require) {
  /*jshint maxlen:false*/
  

  var debug = require('debug')('camera-utils');

  var CameraUtils = function CameraUtils() {};

  CameraUtils.scaleSizeToFitViewport = function(viewportSize, imageSize) {
    var sw = viewportSize.width / imageSize.width,
        sh = viewportSize.height / imageSize.height,
        scale;

    // Select the smaller scale to fit image completely within the viewport
    scale = Math.min(sw, sh);

    return {
      width: imageSize.width * scale,
      height: imageSize.height * scale
    };
  };

  CameraUtils.scaleSizeToFillViewport = function(viewportSize, imageSize) {
    var sw = viewportSize.width / imageSize.width,
        sh = viewportSize.height / imageSize.height,
        scale;

    // Select the larger scale to fill and overflow viewport with image
    scale = Math.max(sw, sh);

    return {
      width: imageSize.width * scale,
      height: imageSize.height * scale
    };
  };

  /**
   * Given an array of supported preview resolutions, a photo size and
   * a viewport size, pick the best preview size. The optimum size is
   * the smallest preview that has the same aspect ratio as the photos
   * we are taking and is larger than the viewport in both dimension.
   *
   * If the viewport size is not specified, then the screen size
   * (in device pixels) is used instead.
   *
   * @param  {Array} previewSizes
   * @param  {Object} photoSize
   * @param  {Object} viewport
   * @return {Object}
   */
  CameraUtils.getOptimalPreviewSize =
    function(previewSizes, photoSize, viewport) {

      // If we don't have any preview sizes, we can't do anything
      if (!previewSizes || previewSizes.length === 0) {
        return null;
      }

      // What is the aspect ratio of the photos we are taking?
      var photoAspectRatio = photoSize.width / photoSize.height;

      // If no viewport size is specified, use the entire screen
      if (!viewport) {
        viewport = {
          width: window.innerWidth * window.devicePixelRatio,
          height: window.innerHeight * window.devicePixelRatio
        };
      }

      // Make sure the viewport is specified in landscape mode with
      // width being the longer dimension
      viewport = {
        width: Math.max(viewport.width, viewport.height),
        height: Math.min(viewport.width, viewport.height),
      };

      // How many total pixels are in the viewport?
      var viewportPixels = viewport.width * viewport.height;

      // Is this preview size big enough to fill the viewport?
      function bigEnough(preview) {
        return preview.width >= viewport.width &&
          preview.height >= viewport.height;
      }

      // Does this preview size match the aspect ratio of the photos?
      function aspectRatioMatches(preview) {
        var previewRatio = preview.width / preview.height;
        return Math.abs(previewRatio - photoAspectRatio) < 0.001;
      }

      // How well does this preview fit the viewport?
      // Larger numbers are better matches.
      // Returns Infinity for a perfect match.
      function matchQuality(preview) {
        var diff = Math.abs(preview.width * preview.height - viewportPixels);
        return viewportPixels/diff;
      }

      var bestPreview = null;
      var bestQuality = 0;
      var i, preview, quality;

      // Loop through the available preview sizes, looking for the best one
      for(i = 0; i < previewSizes.length; i++) {
        preview = previewSizes[i];

        // Only consider preview sizes that are big enough and have the
        // right aspect ratio
        if (bigEnough(preview) && aspectRatioMatches(preview)) {
          // If this preview size is closer to the viewport size than the
          // previous best preview size, then remember it as the best
          // we've seen so far.
          quality = matchQuality(preview);
          if (quality > bestQuality) {
            bestPreview = preview;
            bestQuality = quality;
          }
        }
      }

      // If we found a preview size that is big enough and has the
      // right aspect ratio, return it now.
      if (bestPreview) {
        return bestPreview;
      }
      debug('No preview size is big enough and has right aspect ratio.');

      // If we didn't find a preview size above, find a preview size
      // that has the right aspect ratio and is as close as possible
      // to the viewport size, even if it is smaller.
      for(i = 0; i < previewSizes.length; i++) {
        preview = previewSizes[i];

        if (aspectRatioMatches(preview)) {
          // If this preview size is closer to the viewport size than the
          // previous best preview size, then remember it as the best
          // we've seen so far.
          quality = matchQuality(preview);
          if (quality > bestQuality) {
            bestPreview = preview;
            bestQuality = quality;
          }
        }
      }

      // If we found something, return it.
      if (bestPreview) {
        return bestPreview;
      }
      debug('No preview size has right aspect ratio.');

      // If we still haven't found a size, then ignore aspect ratio
      // and pick the smallest size larger than the viewport
      for(i = 0; i < previewSizes.length; i++) {
        preview = previewSizes[i];

        if (bigEnough(preview)) {
          // If this preview size is closer to the viewport size than the
          // previous best preview size, then remember it as the best
          // we've seen so far.
          quality = matchQuality(preview);
          if (quality > bestQuality) {
            bestPreview = preview;
            bestQuality = quality;
          }
        }
      }

      // If we found something, return it.
      if (bestPreview) {
        return bestPreview;
      }
      debug('No preview size is big enough.');

      // And if there is still nothing, then ignore aspect ratio and
      // pick the closest size, even if it is smaller than the viewport
      for(i = 0; i < previewSizes.length; i++) {
        preview = previewSizes[i];

        // If this preview size is closer to the viewport size than the
        // previous best preview size, then remember it as the best
        // we've seen so far.
        quality = matchQuality(preview);
        if (quality > bestQuality) {
          bestPreview = preview;
          bestQuality = quality;
        }
      }

      // We're guaranteed to have found something by now.
      return bestPreview;
    };

  /**
   * Get the maximum preview size (in terms of area) from a list of
   * possible preview sizes.
   *
   * NOTE: If an `aspectRatio` value is provided, the search will be
   * constrained to only accept preview sizes matching that aspect
   * ratio.
   *
   * @param  {Array} previewSizes
   * @param  {Number} aspectRatio
   * @return {Object}
   */
  CameraUtils.getMaximumPreviewSize = function(previewSizes, aspectRatio) {

    // Use a very small tolerance because we want an exact match if we are
    // constraining to only include specific aspect ratios.
    const ASPECT_TOLERANCE = 0.001;

    var maximumArea = 0;
    var maximumPreviewSize = null;
    previewSizes.forEach(function(previewSize) {
      var area = previewSize.width * previewSize.height;

      if (aspectRatio) {
        var ratio = previewSize.width / previewSize.height;
        if (Math.abs(ratio - aspectRatio) > ASPECT_TOLERANCE) {
          return;
        }
      }

      if (area > maximumArea) {
        maximumArea = area;
        maximumPreviewSize = previewSize;
      }
    });

    return maximumPreviewSize;
  };

  CameraUtils.prototype = {
    constructor: CameraUtils
  };

  return CameraUtils;
});

define('views/viewfinder',['require','exports','module','debug','lib/bind','lib/camera-utils','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:viewfinder');
var bind = require('lib/bind');
var CameraUtils = require('lib/camera-utils');
var View = require('vendor/view');

/**
 * Locals
 */

var isZoomEnabled = false;
var scaleSizeTo = {
  fill: CameraUtils.scaleSizeToFillViewport,
  fit: CameraUtils.scaleSizeToFitViewport
};

var clamp = function(value, minimum, maximum) {
  return Math.min(Math.max(value, minimum), maximum);
};

module.exports = View.extend({
  name: 'viewfinder',
  className: 'js-viewfinder',
  fadeTime: 200,

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.frame = this.find('.js-frame');
    this.els.video = this.find('.js-video');
    this.els.videoContainer = this.find('.js-video-container');

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.el, 'click', this.onClick);
    bind(this.el, 'animationend', this.onShutterEnd);
    return this;
  },

  onClick: function(e) {
    this.emit('click');
  },

  enableZoom: function(minimumZoom, maximumZoom) {
    if (minimumZoom) {
      this._minimumZoom = minimumZoom;
    }

    if (maximumZoom) {
      this._maximumZoom = maximumZoom;
    }

    isZoomEnabled = true;
  },

  disableZoom: function() {
    this._minimumZoom = 1.0;
    this._maximumZoom = 1.0;

    this.setZoom(1.0);

    isZoomEnabled = false;
  },

  _minimumZoom: 1.0,

  setMinimumZoom: function(minimumZoom) {
    this._minimumZoom = minimumZoom;
  },

  _maximumZoom: 1.0,

  setMaximumZoom: function(maximumZoom) {
    this._maximumZoom = maximumZoom;
  },

  _zoom: 1.0,

  /**
   * Update the internal state of the view so that any future
   * pinch-to-zoom gestures can correctly adjust the current zoom
   * level in the event that the zoom level is changed outside of
   * the pinch-to-zoom gesture (e.g.: ZoomBar). This gets called
   * when the `Camera` emits a `zoomchanged` event.
   */
  setZoom: function(zoom) {
    if (!isZoomEnabled) {
      return;
    }

    this._zoom = clamp(zoom, this._minimumZoom, this._maximumZoom);
  },

  _useZoomPreviewAdjustment: false,

  enableZoomPreviewAdjustment: function() {
    this._useZoomPreviewAdjustment = true;
  },

  disableZoomPreviewAdjustment: function() {
    this._useZoomPreviewAdjustment = false;
  },

  /**
   * Adjust the scale of the <video/> tag to compensate for the inability
   * of the Camera API to zoom the preview stream beyond a certain point.
   * This gets called when the `Camera` emits a `zoomchanged` event and is
   * calculated by `Camera.prototype.getZoomPreviewAdjustment()`.
   */
  setZoomPreviewAdjustment: function(zoomPreviewAdjustment) {
    if (this._useZoomPreviewAdjustment) {
      this.els.video.style.transform = 'scale(' + zoomPreviewAdjustment + ')';
    }
  },

  stopStream: function() {
    this.els.video.mozSrcObject = null;
  },

  fadeOut: function(done) {
    this.el.classList.remove('visible');
    if (done) { setTimeout(done, this.fadeTime);}
  },

  fadeIn: function(done) {
    this.el.classList.add('visible');
    if (done) { setTimeout(done, this.fadeTime); }
  },

  /**
   * Triggers a quick shutter style animation.
   *
   * @private
   */
  shutter: function() {
    this.el.classList.add('shutter');
  },

  /**
   * Force a reflow before removing
   * the shutter class so that it
   * doesn't impact the animation.
   *
   * @private
   */
  onShutterEnd: function() {
    this.reflow = this.el.offsetTop;
    this.el.classList.remove('shutter');
  },

  /**
   * Sizes and positions the preview stream.
   *
   * @param  {Object} preview
   * @param  {Number} sensorAngle
   * @param  {Boolean} mirrored
   */
  updatePreview: function(preview, sensorAngle, mirrored) {
    var elementWidth = this.el.clientWidth;
    var elementHeight = this.el.clientHeight;
    var aspect;

    // Invert dimensions if the camera's `sensorAngle` is
    // 0 or 180 degrees.
    if (sensorAngle % 180 === 0) {
      this.container = {
        width: elementWidth,
        height: elementHeight,
        aspect: elementWidth / elementHeight
      };

      aspect = preview.height / preview.width;
    } else {
      this.container = {
        width: elementHeight,
        height: elementWidth,
        aspect: elementHeight / elementWidth
      };

      aspect = preview.width / preview.height;
    }

    var shouldFill = aspect > this.container.aspect;
    var scaleType = this.scaleType || (shouldFill ? 'fill' : 'fit');

    this.updatePreviewMetrics(preview, sensorAngle, mirrored, scaleType);
  },

  /**
   * Calculates the correct sizing
   * depending on the chosen 'scaleType'.
   *
   * 'scale-type' attribute set as a styling hook.
   *
   * @param  {Object} preview
   * @param  {Number} sensorAngle
   * @param  {Boolean} mirrored
   * @param  {String} scaleType 'fill'|'fit'
   */
  updatePreviewMetrics: function(preview, sensorAngle, mirrored, scaleType) {
    debug('update preview scaleType: %s', scaleType, preview);

    // Calculate the correct scale to apply to the
    // preview to either 'fill' or 'fit' the viewfinder
    // container (always preserving the aspect ratio).
    var landscape = scaleSizeTo[scaleType](this.container, preview);
    var portrait = { width: landscape.height, height: landscape.width };

    // Set the size of the frame to match 'portrait' dimensions
    this.els.frame.style.width = portrait.width + 'px';
    this.els.frame.style.height = portrait.height + 'px';

    var transform = '';
    if (mirrored) {
      transform += 'scale(-1, 1) ';
    }

    transform += 'rotate(' + sensorAngle + 'deg)';

    // Set the size of the video container to match the
    // 'landscape' dimensions (CSS is used to rotate
    // the 'landscape' video stream to 'portrait')
    this.els.videoContainer.style.width = landscape.width + 'px';
    this.els.videoContainer.style.height = landscape.height + 'px';
    this.els.videoContainer.style.transform = transform;

    // CSS aligns the contents slightly
    // differently depending on the scaleType
    this.set('scaleType', scaleType);

    debug('updated preview size/position', landscape);
  },

  template: function() {
    return '<div class="viewfinder-frame js-frame">' +
        '<div class="viewfinder-video-container js-video-container">' +
          '<video class="viewfinder-video js-video"></video>' +
        '</div>' +
        '<div class="viewfinder-grid">' +
          '<div class="row"></div>' +
          '<div class="row middle"></div>' +
          '<div class="row"></div>' +
          '<div class="column left">' +
            '<div class="cell top"></div>' +
            '<div class="cell middle"></div>' +
            '<div class="cell bottom"></div>' +
          '</div>' +
          '<div class="column middle">' +
            '<div class="cell top"></div>' +
            '<div class="cell middle"></div>' +
            '<div class="cell bottom"></div>' +
          '</div>' +
          '<div class="column right">' +
           '<div class="cell top"></div>' +
           '<div class="cell middle"></div>' +
           '<div class="cell bottom"></div>' +
          '</div>' +
          '</div>' +
        '</div>' +
    '</div>';
  }
});

});

define('vendor/orientation',[],function() {
  

  // The time interval is allowed between two orientation change event
  const ORIENTATION_CHANGE_INTERVAL = 300;

  // The maximum sample inter-arrival time in milliseconds. If the acceleration
  // samples are further apart than this amount in time, we reset the state of
  // the low-pass filter and orientation properties.  This helps to handle
  // boundary conditions when the app becomes invisisble, wakes from suspend or
  // there is a significant gap in samples.
  const MAX_MOTION_FILTER_TIME = 1000;

  // Filtering adds latency proportional the time constant (inversely
  // proportional to the cutoff frequency) so we don't want to make the time
  // constant too large or we can lose responsiveness.  Likewise we don't want
  // to make it too small or we do a poor job suppressing acceleration spikes.
  // Empirically, 100ms seems to be too small and 500ms is too large. Android
  // default is 200. The original version is from:
  // http://mxr.mozilla.org/mozilla-central/source/widget/gonk/
  //                                                      ProcessOrientation.cpp
  const MOTION_FILTER_TIME_CONSTANT = 200;

  var lastMotionFilteredTime = 0;
  var lastMotionData = {x: 0, y: 0, z: 0, t: 0};
  var pendingOrientation = null;
  var orientationChangeTimer = 0;
  var eventListeners = {'orientation': []};

  function applyFilter(x, y, z) {
    var now = new Date().getTime();
    var filterReset = false;
    // The motion event is too far from last filtered data, reset the data.
    // This may be the case of hide app and go back.
    if (now > lastMotionData.t + MAX_MOTION_FILTER_TIME) {
      // clear data to re-initialize it.
      lastMotionData.x = 0;
      lastMotionData.y = 0;
      lastMotionData.z = 0;
      filterReset = true;
    }
    // applying the exponential moving average to x, y, z, when we already have
    // value of it.
    if (lastMotionData.x || lastMotionData.y || lastMotionData.z) {
      // use time to calculate alpha
      var diff = now - lastMotionFilteredTime;
      var alpha = diff / (MOTION_FILTER_TIME_CONSTANT + diff);

      // weight the x, y, z with alpha
      x = alpha * (x - lastMotionData.x) + lastMotionData.x;
      y = alpha * (y - lastMotionData.y) + lastMotionData.y;
      z = alpha * (z - lastMotionData.z) + lastMotionData.z;
    }

    // update the filter state.
    lastMotionData.x = x;
    lastMotionData.y = y;
    lastMotionData.z = z;
    lastMotionData.t = now;
    return filterReset;
  }

  function calcOrientation(x, y) {
    // use atan2(-x, y) to calculate the rotation on z axis.
    var orientationAngle = (Math.atan2(-x, y) * 180 / Math.PI);
    // The value range of atan2 is [-180, 180]. To have the [0, 360] value
    // range, we need to add 360 degrees when the angle is less than 0.
    if (orientationAngle < 0) {
      orientationAngle += 360;
    }

    // find the nearest orientation.
    // If an angle is >= 45 degrees, we view it as 90 degrees. If an angle is <
    // 45, we view it as 0 degree.
    var orientation = (((orientationAngle + 45) / 90) >> 0) % 4 * 90;
    return orientation;
  }

  function handleMotionEvent(e) {
    if (!e.accelerationIncludingGravity) {
      return;
    }

    var filterReset = applyFilter(e.accelerationIncludingGravity.x,
                                  e.accelerationIncludingGravity.y,
                                  e.accelerationIncludingGravity.z);

    // We don't need to process the event when filter is reset or no data.
    if (filterReset) {
      return;
    }

    var x = lastMotionData.x;
    var y = lastMotionData.y;
    var z = lastMotionData.z;

    // We only want to measure gravity, so ignore events when there is
    // significant acceleration in addition to gravity because this means the
    // user is moving the phone.
    if ((x * x + y * y + z * z) > 110) {
      return;
    }
    // If the camera is close to horizontal (pointing up or down) then we can't
    // tell what orientation the user intends, so we just return now without
    // changing the orientation. The constant 9.2 is the force of gravity (9.8)
    // times the cosine of 20 degrees. So if the phone is within 20 degrees of
    // horizontal, we will never change the orientation.
    if (z > 9.2 || z < -9.2) {
      return;
    }

    var orientation = calcOrientation(x, y);

    if (orientation === pendingOrientation) {
      return;
    }

    // When phone keeps the same orientation for ORIENTATION_CHANGE_INTERVAL
    // time interval, we change the orientation. Otherwrise the change is
    // cancelled. This may be that user rotates phone rapidly but captured by
    // device motion.
    if (orientationChangeTimer) {
      window.clearTimeout(orientationChangeTimer);
    }

    // If we don't have any current orientation, then send an event right away
    // Otherwise, wait to make sure we're stable before sending it.
    if (pendingOrientation === null) {
      pendingOrientation = orientation;
      fireOrientationChangeEvent(pendingOrientation);
    }
    else {
      // create timer for waiting to rotate the phone
      pendingOrientation = orientation;
      orientationChangeTimer = window.setTimeout(function doOrient() {
        fireOrientationChangeEvent(pendingOrientation);
        orientationChangeTimer = 0;
      }, ORIENTATION_CHANGE_INTERVAL);
    }
  }

  function start() {
    // Reset our state so that the first devicemotion event we get
    // will always generate an orientation event.
    pendingOrientation = null;
    window.addEventListener('devicemotion', handleMotionEvent);
  }

  function stop() {
    window.removeEventListener('devicemotion', handleMotionEvent);
    if (orientationChangeTimer) {
      clearTimeout(orientationChangeTimer);
      orientationChangeTimer = 0;
    }
  }

  function addEventListener(type, listener) {
    if (eventListeners[type] && listener) {
      eventListeners[type].push(listener);
    }
  }

  function removeEventListener(type, listener) {
    if (!eventListeners[type]) {
      return;
    }
    var idx = eventListeners[type].indexOf(listener);
    if (idx > -1) {
      eventListeners.slice(idx, 1);
    }
  }

  function fireOrientationChangeEvent(orientation) {
    eventListeners.orientation.forEach(function(listener) {
      if (listener.handleEvent) {
        listener.handleEvent(orientation);
      } else if ((typeof listener) === 'function') {
        listener(orientation);
      }
    });
  }

  return {
    start: start,
    stop: stop,
    on: addEventListener,
    off: removeEventListener
  };

});

define('lib/orientation',['require','exports','module','vendor/orientation'],function(require, exports, module) {
  

  var listener = require('vendor/orientation');
  var body = document.body;
  var classes = body.classList;
  var current = 0;

  listener.on('orientation', onOrientationChange);
  listener.start();

  function onOrientationChange(degrees) {
    classes.remove('deg' + current);
    classes.add('deg' + degrees);
    current = degrees;
  }

  // Camera normally has its orientation locked to portrait mode.
  // But we unlock orientation when displaying image and video previews.
  // When orientation is unlocked, we call listener.stop().
  // We calls call stop() when recording a video, and then restart
  // when recording is done. If our app ever changes so that we can call
  // unlock while the orientation listener is in the stopped state, then
  // we would need to modify the lock() function so that it did not
  // restart the listener. That is not needed now, however and is omitted.

  function unlock() {
    screen.mozUnlockOrientation();
    listener.stop();
  }

  function lock() {
    screen.mozLockOrientation('portrait-primary');
    listener.start();
  }

  /**
   * Exports
   */

  module.exports = {
    on: listener.on,
    off: listener.off,
    start: listener.start,
    stop: listener.stop,
    unlock: unlock,
    lock: lock,
    get: function() {
      return current;
    }
  };
});

define('views/focus-ring',['require','exports','module','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'focus-ring',
  setState: function(state) {
    this.el.setAttribute('data-state', state);
  }
});

});

define('config/camera',['require','exports','module'],function(require, exports, module) {


/**
 * This file is @deprecated!
 * Please use config/settings.js instead.
 */

/**
 * Exports
 */

module.exports = {

  // The minimum available disk space to start recording a video.
  RECORD_SPACE_MIN: 1024 * 1024 * 2,

  // Number of bytes left on disk to let us stop recording.
  RECORD_SPACE_PADDING: 1024 * 1024 * 1,

  // Minimum video duration length for creating a video that contains at least
  // few samples, see bug 899864.
  MIN_RECORDING_TIME: 1000,

  // Amount of inactivity time (in milliseconds) to hide the Zoom Bar
  ZOOM_BAR_INACTIVITY_TIMEOUT: 3000,

  // Amount (%) to adjust the Zoom Bar by when tapping the min/max indicators
  ZOOM_BAR_INDICATOR_INTERVAL: 10,

  // Used to adjust sensitivity for pinch-to-zoom gesture
  // (smaller values = more sensitivity)
  ZOOM_GESTURE_SENSITIVITY: 0.425
};

});

define('views/zoom-bar',['require','exports','module','debug','vendor/view','lib/bind','config/camera','lib/orientation'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:zoom-bar');
var View = require('vendor/view');
var bind = require('lib/bind');
var constants = require('config/camera');
var orientation = require('lib/orientation');

/**
 * Locals
 */

var lastTouch = null;

var clamp = function(value, minimum, maximum) {
  return Math.min(Math.max(value, minimum), maximum);
};

module.exports = View.extend({
  name: 'zoom-bar',

  initialize: function() {
    this.render();

    this._orientation = orientation.get();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.maxIndicator = this.find('.zoom-bar-max-indicator');
    this.els.minIndicator = this.find('.zoom-bar-min-indicator');
    this.els.inner = this.find('.zoom-bar-inner');
    this.els.track = this.find('.zoom-bar-track');
    this.els.scrubber = this.find('.zoom-bar-scrubber');

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.els.scrubber, 'touchstart', this.onTouchStart);
    bind(this.els.scrubber, 'touchmove', this.onTouchMove);
    bind(this.els.scrubber, 'touchend', this.onTouchEnd);
    bind(this.els.maxIndicator, 'click', this.onIncrement);
    bind(this.els.minIndicator, 'click', this.onDecrement);
    orientation.on('orientation', this.setOrientation);
    return this;
  },

  template: function() {
    return '<div class="zoom-bar-max-indicator"></div>' +
      '<div class="zoom-bar-inner">' +
        '<div class="zoom-bar-track"></div>' +
        '<div class="zoom-bar-scrubber"></div>' +
      '</div>' +
      '<div class="zoom-bar-min-indicator"></div>';
  },

  onTouchStart: function(evt) {
    lastTouch = evt.touches[0];
    this.resetInactivityTimeout();
    this.setScrubberActive(true);
    this._innerHeight = this.els.inner.offsetHeight;

    evt.stopPropagation();
  },

  onTouchMove: function(evt) {
    if (!lastTouch) {
      return;
    }

    var touch = evt.touches[0];
    var deltaX = lastTouch.pageX - touch.pageX;
    var deltaY = lastTouch.pageY - touch.pageY;

    var scale = 100 / this._innerHeight;
    
    deltaX *= scale;
    deltaY *= scale;

    switch (this._orientation) {
      case 0:
        this.setValue(this._value + deltaY, true);
        break;
      case 90:
        this.setValue(this._value + deltaX, true);
        break;
      case 180:
        this.setValue(this._value - deltaY, true);
        break;
      case 270:
        this.setValue(this._value - deltaX, true);
        break;
    }

    lastTouch = touch;
  },

  onTouchEnd: function(evt) {
    if (!lastTouch) {
      return;
    }

    lastTouch = null;
    this.resetInactivityTimeout();
    this.setScrubberActive(false);
  },

  onIncrement: function(evt) {
    this.setValue(this._value + constants.ZOOM_BAR_INDICATOR_INTERVAL, true);
    this.flashScrubberActive();
    evt.stopPropagation();
  },

  onDecrement: function(evt) {
    this.setValue(this._value - constants.ZOOM_BAR_INDICATOR_INTERVAL, true);
    this.flashScrubberActive();
    evt.stopPropagation();
  },

  _orientation: 0,

  setOrientation: function(orientation) {
    var el = this.el;
    el.classList.remove('zooming');

    // Force ZoomBar to hide *immediately* on orientation change
    window.requestAnimationFrame(function() {
      el.style.transitionDuration = '0ms';
      window.requestAnimationFrame(function() {
        el.style.transitionDuration = '';
      });
    });

    this._orientation = orientation;
  },

  _value: 0,

  setValue: function(value, emitChange) {
    this.resetInactivityTimeout();

    var lastValue = this._value;
    this._value = clamp(value, 0, 100);
    if (this._value === lastValue) {
      return;
    }

    if (this._value === 0) {
      this.els.minIndicator.classList.add('active');
    } else {
      this.els.minIndicator.classList.remove('active');
    }

    if (this._value === 100) {
      this.els.maxIndicator.classList.add('active');
    } else {
      this.els.maxIndicator.classList.remove('active');
    }

    var self = this;
    window.requestAnimationFrame(function() {
      self.els.track.style.top = (100 - self._value) + '%';
      self.els.scrubber.style.bottom = self._value + '%';
    });

    if (emitChange) {
      this.emit('change', this._value);
    }
  },

  setScrubberActive: function(active) {
    window.clearTimeout(this._scrubberTimeout);

    if (active) {
      this.els.scrubber.classList.add('active');
    } else {
      this.els.scrubber.classList.remove('active');
    }
  },

  flashScrubberActive: function() {
    this.setScrubberActive(true);
    var self = this;
    this._scrubberTimeout = window.setTimeout(function() {
      self.setScrubberActive(false);
    }, 150);
  },

  resetInactivityTimeout: function() {
    window.clearTimeout(this._inactivityTimeout);

    this.show();

    var self = this;
    this._inactivityTimeout = window.setTimeout(function() {
      self.hide();
    }, constants.ZOOM_BAR_INACTIVITY_TIMEOUT);
  },

  show: function() {
    this.el.classList.add('zooming');
  },

  hide: function() {
    this.el.classList.remove('zooming');
  }
});

});

define('vendor/model',['require','exports','module','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var events = require('vendor/evt');

/**
 * Exports
 */

module.exports = Model;

function Model(obj) {
  if (!(this instanceof Model)) { return mix(obj, Model.prototype); }
  this.reset(obj, { silent: true });
  this.id = obj.id || obj.key;
}

Model.prototype = events({
  get: function(key) {
    var data = this._getData();
    return key ? data[key] : mix({}, data);
  },

  set: function(key, value, options) {
    options = typeof key === 'object' ? value : options;
    var silent = options && options.silent;
    var data = this._getData();
    var keys;

    switch (typeof key) {
      case 'string':
        data[key] = value;
        if (!silent) {
          this.onKeyChange(key);
          this.emit('change', [key]);
        }
        return;
      case 'object':
        mix(data, key);
        if (!silent) {
          keys = Object.keys(key);
          keys.forEach(this.onKeyChange, this);
          this.emit('change', keys);
        }
        return;
    }
  },

  setter: function(key, value1) {
    return (function(value2) { this.set(key, value1 || value2); }).bind(this);
  },

  reset: function(data, options) {
    if (!data) { return; }
    var silent = options && options.silent;
    var isArray = data instanceof Array;
    this._data = !isArray ? mix({}, data) : data;
    if (!silent) { this.emit('reset'); }
  },

  onKeyChange: function(key) {
    var data = this._getData();
    this.emit('change:' + key, data[key]);
  },

  each: function(fn) {
    var data = this._getData();
    for (var key in data) { fn(key, value); }
  },

  _getData: function() {
    this._data = this._data || {};
    return this._data;
  }
});

function mix(a, b) {
  for (var key in b) { a[key] = b[key]; }
  return a;
}

});

define('views/hud',['require','exports','module','debug','vendor/view','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:hud');
var View = require('vendor/view');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'hud',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.flash = this.find('.js-flash');
    this.els.camera = this.find('.js-camera');
    this.els.settings = this.find('.js-settings');

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.els.flash, 'click', this.onFlashClick);
    bind(this.els.camera, 'click', this.onCameraClick);
    bind(this.els.settings, 'click', this.onSettingsClick, true);
    return this;
  },

  setFlashMode: function(mode) {
    if (!mode) { return; }
    var classes = this.els.flash.classList;
    var oldIcon = this.flashMode && this.flashMode.icon;
    if (oldIcon) { classes.remove(oldIcon); }
    classes.add(mode.icon);
    this.flashMode = mode;
  },

  onFlashClick: function(event) {
    event.stopPropagation();
    this.emit('click:flash');
  },

  onCameraClick: function(event) {
    event.stopPropagation();
    this.emit('click:camera');
  },

  onSettingsClick: function(event) {
    event.stopPropagation();
    this.emit('click:settings');
  },

  template: function() {
    return '<div class="hud_btn hud_camera rotates icon-toggle-camera ' +
    'test-toggle-camera js-camera"></div>' +
    '<div class="hud_btn hud_flash rotates test-toggle-flash js-flash"></div>' +
    '<div class="hud_btn hud_settings rotates icon-settings js-settings">' +
    '</div>';
  }
});

});

define('app',['require','exports','module','views/notification','views/loading-screen','views/viewfinder','lib/orientation','views/focus-ring','views/zoom-bar','lib/bind-all','vendor/model','debug','views/hud','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var NotificationView = require('views/notification');
var LoadingView = require('views/loading-screen');
var ViewfinderView = require('views/viewfinder');
var orientation = require('lib/orientation');
var FocusRing = require('views/focus-ring');
var ZoomBarView = require('views/zoom-bar');
var bindAll = require('lib/bind-all');
var model = require('vendor/model');
var debug = require('debug')('app');
var HudView = require('views/hud');
var bind = require('lib/bind');

/**
 * Locals
 */

var unbind = bind.unbind;

// Mixin model methods
model(App.prototype);

/**
 * Exports
 */

module.exports = App;

/**
 * Initialize a new `App`
 *
 * Options:
 *
 *   - `root` The node to inject content into
 *
 * @param {Object} options
 * @constructor
 */
function App(options) {
  var self = this;
  bindAll(this);
  this.views = {};
  this.el = options.el;
  this.win = options.win;
  this.doc = options.doc;
  this.LoadingView = options.LoadingView || LoadingView; // test hook
  this.inSecureMode = (this.win.location.hash === '#secure');
  this.controllers = options.controllers;
  this.geolocation = options.geolocation;
  this.activity = options.activity;
  this.settings = options.settings;
  this.storage = options.storage;
  this.camera = options.camera;
  this.sounds = options.sounds;
  this.Pinch = options.Pinch;
  //
  // If the system app is opening an attention screen (because
  // of an incoming call or an alarm, e.g.) and if we are
  // currently recording a video then we need to stop recording
  // before the ringer or alarm starts sounding. We will be sent
  // to the background shortly after this and will stop recording
  // when that happens, but by that time it is too late and we
  // have already recorded some sound. See bugs 995540 and 1006200.
  //
  // XXX We're abusing the settings API here to allow the system app
  // to broadcast a message to any certified apps that care. There
  // ought to be a better way, but this is a quick and easy way to
  // fix a last-minute release blocker.
  //
  navigator.mozSettings.addObserver(
    'private.broadcast.attention_screen_opening',
    function(event) {
      // If event.settingValue is true, then an attention screen will
      // soon appear. If it is false, then the attention screen is
      // going away.
      if (event.settingValue) {
        self.emit('attentionscreenopened');
      }
  });
  debug('initialized');
}

/**
 * Runs all the methods
 * to boot the app.
 *
 * @public
 */
App.prototype.boot = function() {
  if (this.didBoot) { return; }
  this.initializeViews();
  this.runControllers();
  this.injectViews();
  this.bindEvents();
  this.configureL10n();
  this.showLoading();
  this.emit('boot');
  this.didBoot = true;
  debug('booted');
};

App.prototype.teardown = function() {
  this.unbindEvents();
};

/**
 * Runs controllers to glue all
 * the parts of the app together.
 *
 * @private
 */
App.prototype.runControllers = function() {
  debug('running controllers');
  this.controllers.settings(this);
  this.controllers.activity(this);
  this.controllers.timer(this);
  this.controllers.camera(this);
  this.controllers.viewfinder(this);
  this.controllers.recordingTimer(this);
  this.controllers.indicators(this);
  this.controllers.previewGallery(this);
  this.controllers.controls(this);
  this.controllers.confirm(this);
  this.controllers.overlay(this);
  this.controllers.sounds(this);
  this.controllers.hud(this);
  this.controllers.zoomBar(this);
  this.controllers.battery(this);
  debug('controllers run');
};

/**
 * Initialize views.
 *
 * @private
 */
App.prototype.initializeViews = function() {
  debug('initializing views');
  this.views.viewfinder = new ViewfinderView();
  this.views.focusRing = new FocusRing();
  this.views.hud = new HudView();
  this.views.zoomBar = new ZoomBarView();
  this.views.notification = new NotificationView();
  debug('views initialized');
};

/**
 * Put views in the DOM.
 *
 * @private
 */
App.prototype.injectViews = function() {
  debug('injecting views');
  this.views.viewfinder.appendTo(this.el);
  this.views.focusRing.appendTo(this.el);
  this.views.hud.appendTo(this.el);
  this.views.zoomBar.appendTo(this.el);
  this.views.notification.appendTo(this.el);
  debug('views injected');
};

/**
 * Attaches event handlers.
 *
 * @private
 */
App.prototype.bindEvents = function() {
  this.once('viewfinder:visible', this.clearLoading);
  this.storage.once('checked:healthy', this.geolocationWatch);
  bind(this.doc, 'visibilitychange', this.onVisibilityChange);
  bind(this.win, 'beforeunload', this.onBeforeUnload);
  bind(this.el, 'click', this.onClick);
  this.on('focus', this.onFocus);
  this.on('blur', this.onBlur);

  debug('events bound');
};

/**
 * Detaches event handlers.
 */
App.prototype.unbindEvents = function() {
  unbind(this.doc, 'visibilitychange', this.onVisibilityChange);
  unbind(this.win, 'beforeunload', this.onBeforeUnload);
  this.off('focus', this.onFocus);
  this.off('blur', this.onBlur);
  debug('events unbound');
};

/**
 * Tasks to run when the
 * app becomes visible.
 *
 * Check the storage again as users
 * may have made changes since the
 * app was minimised
 */
App.prototype.onFocus = function() {
  this.geolocationWatch();
  this.storage.check();
  orientation.start();
  debug('focus');
};

/**
 * Tasks to run when the
 * app is minimised/hidden.
 */
App.prototype.onBlur = function() {
  this.geolocation.stopWatching();
  orientation.stop();
  debug('blur');
};

App.prototype.onClick = function() {
  debug('click');
  this.emit('click');
};

/**
 * Begins watching location if not within
 * a pending activity and the app isn't
 * currently hidden.
 *
 * Watching is delayed by the `promptDelay`
 * defined in settings.
 *
 * @private
 */
App.prototype.geolocationWatch = function() {
  var delay = this.settings.geolocation.get('promptDelay');
  var shouldWatch = !this.activity.active && !this.doc.hidden;
  if (shouldWatch) { setTimeout(this.geolocation.watch, delay); }
};

/**
 * Responds to the `visibilitychange`
 * event, emitting useful app events
 * that allow us to perform relate
 * work elsewhere.
 *
 * @private
 */
App.prototype.onVisibilityChange = function() {
  this.hidden = this.doc.hidden;
  this.emit(this.hidden ? 'blur' : 'focus');
};

/**
 * Runs just before the
 * app is destroyed.
 *
 * @private
 */
App.prototype.onBeforeUnload = function() {
  this.views.viewfinder.stopStream();
  this.emit('beforeunload');
  debug('beforeunload');
};

/**
 * Initialize l10n 'localized' listener.
 *
 * Sometimes it may have completed
 * before we reach this point, meaning
 * we will have missed the 'localized'
 * event. In this case, we emit the
 * 'localized' event manually.
 *
 * @private
 */
App.prototype.configureL10n = function() {
  var complete = navigator.mozL10n.readyState === 'complete';
  bind(this.win, 'localized', this.firer('localized'));
  if (complete) { this.emit('localized'); }
};

/**
 * Shows the loading screen after the
 * number of ms defined in config.js
 *
 * @private
 */
App.prototype.showLoading = function() {
  debug('show loading');
  var ms = this.settings.loadingScreen.get('delay');
  var self = this;
  clearTimeout(this.loadingTimeout);
  this.loadingTimeout = setTimeout(function() {
    self.views.loading = new self.LoadingView();
    self.views.loading.appendTo(self.el).show();
    debug('loading shown');
  }, ms);
};

/**
 * Clears the loadings screen, or
 * any pending loading screen.
 *
 * @private
 */
App.prototype.clearLoading = function() {
  debug('clear loading');
  var view = this.views.loading;
  clearTimeout(this.loadingTimeout);
  if (!view) { return; }
  view.hide(view.destroy);
};

});



var BlobView = (function() {
  function fail(msg) {
    throw Error(msg);
  }

  // This constructor is for internal use only.
  // Use the BlobView.get() factory function or the getMore instance method
  // to obtain a BlobView object.
  function BlobView(blob, sliceOffset, sliceLength, slice,
                    viewOffset, viewLength, littleEndian)
  {
    this.blob = blob;                  // The parent blob that the data is from
    this.sliceOffset = sliceOffset;    // The start address within the blob
    this.sliceLength = sliceLength;    // How long the slice is
    this.slice = slice;                // The ArrayBuffer of slice data
    this.viewOffset = viewOffset;      // The start of the view within the slice
    this.viewLength = viewLength;      // The length of the view
    this.littleEndian = littleEndian;  // Read little endian by default?

    // DataView wrapper around the ArrayBuffer
    this.view = new DataView(slice, viewOffset, viewLength);

    // These fields mirror those of DataView
    this.buffer = slice;
    this.byteLength = viewLength;
    this.byteOffset = viewOffset;

    this.index = 0;   // The read methods keep track of the read position
  }

  // Async factory function
  BlobView.get = function(blob, offset, length, callback, littleEndian) {
    if (offset < 0)
      fail('negative offset');
    if (length < 0)
      fail('negative length');
    if (offset > blob.size)
      fail('offset larger than blob size');

    // Don't fail if the length is too big; just reduce the length
    if (offset + length > blob.size)
      length = blob.size - offset;

    var slice = blob.slice(offset, offset + length);
    var reader = new FileReader();
    reader.readAsArrayBuffer(slice);
    reader.onloadend = function() {
      var result = null;
      if (reader.result) {
        result = new BlobView(blob, offset, length, reader.result,
                              0, length, littleEndian || false);
      }
      callback(result, reader.error);
    };
  };

  BlobView.prototype = {
    constructor: BlobView,

    // This instance method is like the BlobView.get() factory method,
    // but it is here because if the current buffer includes the requested
    // range of bytes, they can be passed directly to the callback without
    // going back to the blob to read them
    getMore: function(offset, length, callback) {
      if (offset >= this.sliceOffset &&
          offset + length <= this.sliceOffset + this.sliceLength) {
        // The quick case: we already have that region of the blob
        callback(new BlobView(this.blob,
                              this.sliceOffset, this.sliceLength, this.slice,
                              offset - this.sliceOffset, length,
                              this.littleEndian));
      }
      else {
        // Otherwise, we have to do an async read to get more bytes
        BlobView.get(this.blob, offset, length, callback, this.littleEndian);
      }
    },

    // Set the default endianness for the other methods
    littleEndian: function() {
      this.littleEndian = true;
    },
    bigEndian: function() {
      this.littleEndian = false;
    },

    // These "get" methods are just copies of the DataView methods, except
    // that they honor the default endianness
    getUint8: function(offset) {
      return this.view.getUint8(offset);
    },
    getInt8: function(offset) {
      return this.view.getInt8(offset);
    },
    getUint16: function(offset, le) {
      return this.view.getUint16(offset,
                                 le !== undefined ? le : this.littleEndian);
    },
    getInt16: function(offset, le) {
      return this.view.getInt16(offset,
                                le !== undefined ? le : this.littleEndian);
    },
    getUint32: function(offset, le) {
      return this.view.getUint32(offset,
                                 le !== undefined ? le : this.littleEndian);
    },
    getInt32: function(offset, le) {
      return this.view.getInt32(offset,
                                le !== undefined ? le : this.littleEndian);
    },
    getFloat32: function(offset, le) {
      return this.view.getFloat32(offset,
                                  le !== undefined ? le : this.littleEndian);
    },
    getFloat64: function(offset, le) {
      return this.view.getFloat64(offset,
                                  le !== undefined ? le : this.littleEndian);
    },

    // These "read" methods read from the current position in the view and
    // update that position accordingly
    readByte: function() {
      return this.view.getInt8(this.index++);
    },
    readUnsignedByte: function() {
      return this.view.getUint8(this.index++);
    },
    readShort: function(le) {
      var val = this.view.getInt16(this.index,
                                   le !== undefined ? le : this.littleEndian);
      this.index += 2;
      return val;
    },
    readUnsignedShort: function(le) {
      var val = this.view.getUint16(this.index,
                                    le !== undefined ? le : this.littleEndian);
      this.index += 2;
      return val;
    },
    readInt: function(le) {
      var val = this.view.getInt32(this.index,
                                   le !== undefined ? le : this.littleEndian);
      this.index += 4;
      return val;
    },
    readUnsignedInt: function(le) {
      var val = this.view.getUint32(this.index,
                                    le !== undefined ? le : this.littleEndian);
      this.index += 4;
      return val;
    },
    readFloat: function(le) {
      var val = this.view.getFloat32(this.index,
                                     le !== undefined ? le : this.littleEndian);
      this.index += 4;
      return val;
    },
    readDouble: function(le) {
      var val = this.view.getFloat64(this.index,
                                     le !== undefined ? le : this.littleEndian);
      this.index += 8;
      return val;
    },

    // Methods to get and set the current position
    tell: function() {
      return this.index;
    },
    remaining: function() {
      return this.byteLength - this.index;
    },
    seek: function(index) {
      if (index < 0)
        fail('negative index');
      if (index > this.byteLength)
        fail('index greater than buffer size');
      this.index = index;
    },
    advance: function(n) {
      var index = this.index + n;
      if (index < 0)
        fail('advance past beginning of buffer');
      // It's usual that when we finished reading one target view,
      // the index is advanced to the start(previous end + 1) of next view,
      // and the new index will be equal to byte length(the last index + 1),
      // we will not fail on it because it means the reading is finished,
      // or do we have to warn here?
      if (index > this.byteLength)
        fail('advance past end of buffer');
      this.index = index;
    },

    // Additional methods to read other useful things
    getUnsignedByteArray: function(offset, n) {
      return new Uint8Array(this.buffer, offset + this.viewOffset, n);
    },

    // Additional methods to read other useful things
    readUnsignedByteArray: function(n) {
      var val = new Uint8Array(this.buffer, this.index + this.viewOffset, n);
      this.index += n;
      return val;
    },

    getBit: function(offset, bit) {
      var byte = this.view.getUint8(offset);
      return (byte & (1 << bit)) !== 0;
    },

    getUint24: function(offset, le) {
      var b1, b2, b3;
      if (le !== undefined ? le : this.littleEndian) {
        b1 = this.view.getUint8(offset);
        b2 = this.view.getUint8(offset + 1);
        b3 = this.view.getUint8(offset + 2);
      }
      else {    // big end first
        b3 = this.view.getUint8(offset);
        b2 = this.view.getUint8(offset + 1);
        b1 = this.view.getUint8(offset + 2);
      }

      return (b3 << 16) + (b2 << 8) + b1;
    },

    readUint24: function(le) {
      var value = this.getUint24(this.index, le);
      this.index += 3;
      return value;
    },

    // There are lots of ways to read strings.
    // ASCII, UTF-8, UTF-16.
    // null-terminated, character length, byte length
    // I'll implement string reading methods as needed

    getASCIIText: function(offset, len) {
      var bytes = new Uint8Array(this.buffer, offset + this.viewOffset, len);
      return String.fromCharCode.apply(String, bytes);
    },

    readASCIIText: function(len) {
      var bytes = new Uint8Array(this.buffer,
                                 this.index + this.viewOffset,
                                 len);
      this.index += len;
      return String.fromCharCode.apply(String, bytes);
    },

    // Replace this with the StringEncoding API when we've got it.
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=764234
    getUTF8Text: function(offset, len) {
      function fail() { throw new Error('Illegal UTF-8'); }

      var pos = offset;         // Current position in this.view
      var end = offset + len;   // Last position
      var charcode;             // Current charcode
      var s = '';               // Accumulate the string
      var b1, b2, b3, b4;       // Up to 4 bytes per charcode

      // See http://en.wikipedia.org/wiki/UTF-8
      while (pos < end) {
        var b1 = this.view.getUint8(pos);
        if (b1 < 128) {
          s += String.fromCharCode(b1);
          pos += 1;
        }
        else if (b1 < 194) {
          // unexpected continuation character...
          fail();
        }
        else if (b1 < 224) {
          // 2-byte sequence
          if (pos + 1 >= end)
            fail();
          b2 = this.view.getUint8(pos + 1);
          if (b2 < 128 || b2 > 191)
            fail();
          charcode = ((b1 & 0x1f) << 6) + (b2 & 0x3f);
          s += String.fromCharCode(charcode);
          pos += 2;
        }
        else if (b1 < 240) {
          // 3-byte sequence
          if (pos + 2 >= end)
            fail();
          b2 = this.view.getUint8(pos + 1);
          if (b2 < 128 || b2 > 191)
            fail();
          b3 = this.view.getUint8(pos + 2);
          if (b3 < 128 || b3 > 191)
            fail();
          charcode = ((b1 & 0x0f) << 12) + ((b2 & 0x3f) << 6) + (b3 & 0x3f);
          s += String.fromCharCode(charcode);
          pos += 3;
        }
        else if (b1 < 245) {
          // 4-byte sequence
          if (pos + 3 >= end)
            fail();
          b2 = this.view.getUint8(pos + 1);
          if (b2 < 128 || b2 > 191)
            fail();
          b3 = this.view.getUint8(pos + 2);
          if (b3 < 128 || b3 > 191)
            fail();
          b4 = this.view.getUint8(pos + 3);
          if (b4 < 128 || b4 > 191)
            fail();
          charcode = ((b1 & 0x07) << 18) +
            ((b2 & 0x3f) << 12) +
            ((b3 & 0x3f) << 6) +
            (b4 & 0x3f);

          // Now turn this code point into two surrogate pairs
          charcode -= 0x10000;
          s += String.fromCharCode(0xd800 + ((charcode & 0x0FFC00) >>> 10));
          s += String.fromCharCode(0xdc00 + (charcode & 0x0003FF));

          pos += 4;
        }
        else {
          // Illegal byte
          fail();
        }
      }

      return s;
    },

    readUTF8Text: function(len) {
      try {
        return this.getUTF8Text(this.index, len);
      }
      finally {
        this.index += len;
      }
    },

    // Read 4 bytes, ignore the high bit and combine them into a 28-bit
    // big-endian unsigned integer.
    // This format is used by the ID3v2 metadata.
    getID3Uint28BE: function(offset) {
      var b1 = this.view.getUint8(offset) & 0x7f;
      var b2 = this.view.getUint8(offset + 1) & 0x7f;
      var b3 = this.view.getUint8(offset + 2) & 0x7f;
      var b4 = this.view.getUint8(offset + 3) & 0x7f;
      return (b1 << 21) | (b2 << 14) | (b3 << 7) | b4;
    },

    readID3Uint28BE: function() {
      var value = this.getID3Uint28BE(this.index);
      this.index += 4;
      return value;
    },

    // Read bytes up to and including a null terminator, but never
    // more than size bytes.  And return as a Latin1 string
    readNullTerminatedLatin1Text: function(size) {
      var s = '';
      for (var i = 0; i < size; i++) {
        var charcode = this.view.getUint8(this.index + i);
        if (charcode === 0) {
          i++;
          break;
        }
        s += String.fromCharCode(charcode);
      }
      this.index += i;
      return s;
    },

    // Read bytes up to and including a null terminator, but never
    // more than size bytes.  And return as a UTF8 string
    readNullTerminatedUTF8Text: function(size) {
      for (var len = 0; len < size; len++) {
        if (this.view.getUint8(this.index + len) === 0)
          break;
      }
      var s = this.readUTF8Text(len);
      if (len < size)    // skip the null terminator if we found one
        this.advance(1);
      return s;
    },

    // Read UTF16 text.  If le is not specified, expect a BOM to define
    // endianness.  If le is true, read UTF16LE, if false, UTF16BE
    // Read until we find a null-terminator, but never more than size bytes
    readNullTerminatedUTF16Text: function(size, le) {
      if (le == null) {
        var BOM = this.readUnsignedShort();
        size -= 2;
        if (BOM === 0xFEFF)
          le = false;
        else
          le = true;
      }

      var s = '';
      for (var i = 0; i < size; i += 2) {
        var charcode = this.getUint16(this.index + i, le);
        if (charcode === 0) {
          i += 2;
          break;
        }
        s += String.fromCharCode(charcode);
      }
      this.index += i;
      return s;
    }
  };

  // We don't want users of this library to accidentally call the constructor
  // instead of using the factory function, so we return a dummy object
  // instead of the real constructor. If someone really needs to get at the
  // real constructor, the contructor property of the prototype refers to it.
  return { get: BlobView.get };
}());

define("BlobView", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.BlobView;
    };
}(this)));



//
// Given an MP4/Quicktime based video file as a blob, read through its
// atoms to find the track header "tkhd" atom and extract the rotation
// matrix from it. Convert the matrix value to rotation in degrees and
// pass that number to the specified callback function. If no value is
// found but the video file is valid, pass null to the callback. If
// any errors occur, pass an error message (a string) callback.
//
// See also:
// http://androidxref.com/4.0.4/xref/frameworks/base/media/libstagefright/MPEG4Writer.cpp
// https://developer.apple.com/library/mac/#documentation/QuickTime/QTFF/QTFFChap2/qtff2.html
//
function getVideoRotation(blob, rotationCallback) {

  // A utility for traversing the tree of atoms in an MP4 file
  function MP4Parser(blob, handlers) {
    // Start off with a 1024 chunk from the start of the blob.
    BlobView.get(blob, 0, Math.min(1024, blob.size), function(data, error) {
      // Make sure that the blob is, in fact, some kind of MP4 file
      if (data.byteLength <= 8 || data.getASCIIText(4, 4) !== 'ftyp') {
        handlers.errorHandler('not an MP4 file');
        return;
      }
      parseAtom(data);
    });

    // Call this with a BlobView object that includes the first 16 bytes of
    // an atom. It doesn't matter whether the body of the atom is included.
    function parseAtom(data) {
      var offset = data.sliceOffset + data.viewOffset; // atom position in blob
      var size = data.readUnsignedInt();               // atom length
      var type = data.readASCIIText(4);                // atom type
      var contentOffset = 8;                           // position of content

      if (size === 0) {
        // Zero size means the rest of the file
        size = blob.size - offset;
      }
      else if (size === 1) {
        // A size of 1 means the size is in bytes 8-15
        size = data.readUnsignedInt() * 4294967296 + data.readUnsignedInt();
        contentOffset = 16;
      }

      var handler = handlers[type] || handlers.defaultHandler;
      if (typeof handler === 'function') {
        // If the handler is a function, pass that function a
        // DataView object that contains the entire atom
        // including size and type.  Then use the return value
        // of the function as instructions on what to do next.
        data.getMore(data.sliceOffset + data.viewOffset, size, function(atom) {
          // Pass the entire atom to the handler function
          var rv = handler(atom);

          // If the return value is 'done', stop parsing.
          // Otherwise, continue with the next atom.
          // XXX: For more general parsing we need a way to pop some
          // stack levels.  A return value that is an atom name should mean
          // pop back up to this atom type and go on to the next atom
          // after that.
          if (rv !== 'done') {
            parseAtomAt(data, offset + size);
          }
        });
      }
      else if (handler === 'children') {
        // If the handler is this string, then assume that the atom is
        // a container atom and do its next child atom next
        var skip = (type === 'meta') ? 4 : 0; // special case for meta atoms
        parseAtomAt(data, offset + contentOffset + skip);
      }
      else if (handler === 'skip' || !handler) {
        // Skip the atom entirely and go on to the next one.
        // If there is no next one, call the eofHandler or just return
        parseAtomAt(data, offset + size);
      }
      else if (handler === 'done') {
        // Stop parsing
        return;
      }
    }

    function parseAtomAt(data, offset) {
      if (offset >= blob.size) {
        if (handlers.eofHandler)
          handlers.eofHandler();
        return;
      }
      else {
        data.getMore(offset, 16, parseAtom);
      }
    }
  }

  // We want to loop through the top-level atoms until we find the 'moov'
  // atom. Then, within this atom, there are one or more 'trak' atoms.
  // Each 'trak' should begin with a 'tkhd' atom. The tkhd atom has
  // a transformation matrix at byte 48.  The matrix is 9 32 bit integers.
  // We'll interpret those numbers as a rotation of 0, 90, 180 or 270.
  // If the video has more than one track, we expect all of them to have
  // the same rotation, so we'll only look at the first 'trak' atom that
  // we find.
  MP4Parser(blob, {
    errorHandler: function(msg) { rotationCallback(msg); },
    eofHandler: function() { rotationCallback(null); },
    defaultHandler: 'skip',  // Skip all atoms other than those listed below
    moov: 'children',        // Enumerate children of the moov atom
    trak: 'children',        // Enumerate children of the trak atom
    tkhd: function(data) {   // Pass the tkhd atom to this function
      // The matrix begins at byte 48
      data.advance(48);

      var a = data.readUnsignedInt();
      var b = data.readUnsignedInt();
      data.advance(4); // we don't care about this number
      var c = data.readUnsignedInt();
      var d = data.readUnsignedInt();

      if (a === 0 && d === 0) { // 90 or 270 degrees
        if (b === 0x00010000 && c === 0xFFFF0000)
          rotationCallback(90);
        else if (b === 0xFFFF0000 && c === 0x00010000)
          rotationCallback(270);
        else
          rotationCallback('unexpected rotation matrix');
      }
      else if (b === 0 && c === 0) { // 0 or 180 degrees
        if (a === 0x00010000 && d === 0x00010000)
          rotationCallback(0);
        else if (a === 0xFFFF0000 && d === 0xFFFF0000)
          rotationCallback(180);
        else
          rotationCallback('unexpected rotation matrix');
      }
      else {
        rotationCallback('unexpected rotation matrix');
      }
      return 'done';
    }
  });
}
;
define("getVideoRotation", ["BlobView"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.getVideoRotation;
    };
}(this)));

define('lib/get-video-meta-data',['require','exports','module','getVideoRotation'],function(require, exports, module) {


/**
 * Module Dependencies
 */

var getVideoRotation = require('getVideoRotation');

/**
 * Given the filename of a newly
 * recorded video, create a poster
 * image for it, and save that
 * poster as a jpeg file.
 *
 * When done, pass the video blob
 * and the poster blob to the
 * done function along with the
 * video dimensions and rotation.
 *
 * @param  {Blob}   blob
 * @param  {String}   filename
 * @param  {Function} done
 */
module.exports = createVideoPosterImage;


function createVideoPosterImage(blob, done) {
  var URL = window.URL;

  getVideoRotation(blob, onGotVideoRotation);

  function onGotVideoRotation(rotation) {
    if (typeof rotation !== 'number') {
      console.warn('Unexpected rotation:', rotation);
      rotation = 0;
    }

    var offscreenVideo = document.createElement('video');
    var url = URL.createObjectURL(blob);

    offscreenVideo.preload = 'metadata';
    offscreenVideo.src = url;
    offscreenVideo.onerror = onError;
    offscreenVideo.onloadedmetadata = onLoadedMetaData;

    function onLoadedMetaData() {
      var videowidth = offscreenVideo.videoWidth;
      var videoheight = offscreenVideo.videoHeight;

      // First, create a full-size
      // unrotated poster image
      var postercanvas = document.createElement('canvas');
      var postercontext = postercanvas.getContext('2d');
      postercanvas.width = videowidth;
      postercanvas.height = videoheight;
      postercontext.drawImage(offscreenVideo, 0, 0);

      // We're done with the
      // offscreen video element now
      URL.revokeObjectURL(url);
      offscreenVideo.removeAttribute('src');
      offscreenVideo.load();

      postercanvas.toBlob(function(imageBlob) {
        done(null, {
          width: videowidth,
          height: videoheight,
          rotation: rotation,
          poster: {
            blob: imageBlob
          }
        });
      }, 'image/jpeg');
    }

    function onError() {
      URL.revokeObjectURL(url);
      offscreenVideo.removeAttribute('src');
      offscreenVideo.load();
      console.warn('not a video file delete it!');
      done('error');
    }
  }
}

});

define('lib/camera',['require','exports','module','lib/camera-utils','lib/get-video-meta-data','lib/orientation','config/camera','debug','lib/bind-all','vendor/model'],function(require, exports, module) {


/**
 * Module Dependencies
 */

var CameraUtils = require('lib/camera-utils');
var getVideoMetaData = require('lib/get-video-meta-data');
var orientation = require('lib/orientation');
var constants = require('config/camera');
var debug = require('debug')('camera');
var bindAll = require('lib/bind-all');
var model = require('vendor/model');

/**
 * Locals
 */

var recordSpaceMin = constants.RECORD_SPACE_MIN;
var recordSpacePadding = constants.RECORD_SPACE_PADDING;

// More explicit names for the focus modes we care about
var MANUAL_AUTO_FOCUS = 'auto';
var CONTINUOUS_AUTO_FOCUS = 'continuous-picture';

/**
 * Locals
 */

// Mixin model methods (also events)
model(Camera.prototype);

/**
 * Exports
 */

module.exports = Camera;

/**
 * Initialize a new 'Camera'
 *
 * Options:
 *
 *   - {Element} container
 *
 * @param {Object} options
 */
function Camera(options) {
  debug('initializing');
  bindAll(this);
  options = options || {};
  this.container = options.container;
  this.mozCamera = null;
  this.cameraList = navigator.mozCameras.getListOfCameras();
  this.orientation = options.orientation || orientation;
  this.video = {
    storage: navigator.getDeviceStorage('videos'),
    filepath: null,
    minSpace: options.recordSpaceMin || recordSpaceMin,
    spacePadding : options.recordSpacePadding || recordSpacePadding
  };

  // If the hardware supports continuous auto focus, we generally want to
  // use it. But we do have a option in the settings file to disable it
  // at build time.
  if (options.cafEnabled !== undefined) {
    this.cafEnabled = options.cafEnabled;
  } else {
    // If the option is not specified at all, assume true
    this.cafEnabled = true;
  }

  debug('initialized');
}

/**
 * Plugs Video Stream into Video Element.
 *
 * @param  {Elmement} videoElement
 * @public
 */
Camera.prototype.loadStreamInto = function(videoElement) {
  debug('loading stream into element');
  if (!this.mozCamera) {
    debug('error - `mozCamera` is undefined or null');
    return;
  }

  if (!videoElement) {
    debug('error - `videoElement` is undefined or null');
    return;
  }

  // Don't load the same camera stream again
  var isCurrent = videoElement.mozSrcObject === this.mozCamera;
  if (isCurrent) { return debug('camera didn\'t change'); }

  videoElement.mozSrcObject = this.mozCamera;
  videoElement.play();
  debug('stream loaded into video');
};

/**
 * Loads the currently selected camera.
 *
 * There are cases whereby the camera
 * may still be 'releasing' its hardware.
 * If this is the case we wait for the
 * release process to finish, then attempt
 * to load again.
 *
 * @public
 */
Camera.prototype.load = function(done) {
  debug('load camera');

  var selectedCamera = this.get('selectedCamera');
  var loadingNewCamera = selectedCamera !== this.lastLoadedCamera;
  var self = this;

  this.emit('busy');

  // If hardware is still being released
  // we're not allowed to request the camera.
  if (this.releasing) {
    debug('wait for camera release');
    this.once('released', function() { self.load(done); });
    return;
  }

  // Don't re-load hardware if selected camera is the same
  if (this.mozCamera && !loadingNewCamera) {
    this.configureCamera(this.mozCamera);
    debug('camera not changed');
    done();
    return;
  }

  // If a camera is already loaded, it must be 'released' first.
  if (this.mozCamera) {
    this.release(ready);
  } else {
    ready();
  }

  function ready() {
    self.requestCamera(selectedCamera, done);
    self.lastLoadedCamera = selectedCamera;
  }
};

/**
 * Requests the mozCamera object,
 * then configures it.
 *
 * @param  {String}   camera  'front'|'back'
 * @private
 */
Camera.prototype.requestCamera = function(camera, done) {
  done = done || function() {};

  var self = this;
  navigator.mozCameras.getCamera(camera, {}, onSuccess, onError);

  function onSuccess(mozCamera) {
    debug('successfully got mozCamera');
    self.configureCamera(mozCamera);
    done();
  }

  function onError(err) {
    debug('error requesting camera');
    done(err);
  }

  debug('camera requested');
};

/**
 * Configures the newly recieved
 * mozCamera object.
 *
 * Setting the 'cababilities' key
 * triggers 'change' callback inside
 * the CameraController that sets the
 * app up for the new camera.
 *
 * @param  {MozCamera} mozCamera
 * @private
 */
Camera.prototype.configureCamera = function(mozCamera) {
  debug('configuring camera');
  var capabilities = mozCamera.capabilities;
  this.mozCamera = mozCamera;
  this.mozCamera.onShutter = this.onShutter;
  this.mozCamera.onPreviewStateChange = this.onPreviewStateChange;
  this.mozCamera.onRecorderStateChange = this.onRecorderStateChange;
  this.set('capabilities', this.formatCapabilities(capabilities));
  debug('configured camera');
};

Camera.prototype.formatCapabilities = function(capabilities) {
  var hasHDR = capabilities.sceneModes.indexOf('hdr') > -1;
  capabilities.hdr = hasHDR ? ['on', 'off'] : undefined;
  return capabilities;
};

Camera.prototype.configure = function() {
  var self = this;
  var success = function() {
    self.emit('configured');
  };

  var error = function() {
    console.log('Error configuring camera');
  };

  var previewSize = this.previewSize();
  var options = {
    mode: this.mode,
    previewSize: previewSize,
    recorderProfile: this.recorderProfile.key
  };

  debug('mozCamera configuration pw: %s, ph: %s',
    options.previewSize.width,
    options.previewSize.height);

  this.mozCamera.setConfiguration(options, success, error);
  this.configureFocus(this.mode);
  this.configureZoom(previewSize);
};

Camera.prototype.previewSizes = function() {
  return this.mozCamera.capabilities.previewSizes;
};

Camera.prototype.previewSize = function() {
  var sizes = this.previewSizes();
  var profile = this.resolution();
  var size = CameraUtils.getOptimalPreviewSize(sizes, profile);
  debug('resolution w: %s, h: %s', profile.width, profile.height);
  debug('previewSize w: %s, h: %s', size.width, size.height);
  return size;
};

Camera.prototype.resolution = function(mode) {
  switch (mode || this.mode) {
    case 'picture': return this.pictureSize;
    case 'video': return this.recorderProfile.video;
  }
};

Camera.prototype.setPictureSize = function(value) {
  this.mozCamera.pictureSize = this.pictureSize = value;
  this.setThumbnailSize();
  debug('set picture size w: %s, h: %s', value.width, value.height);
  return this;
};

Camera.prototype.setThumbnailSize = function() {
  var sizes = this.mozCamera.capabilities.thumbnailSizes;
  var pictureSize = this.mozCamera.pictureSize;
  var picked = this.pickThumbnailSize(sizes, pictureSize);
  if (picked) { this.mozCamera.thumbnailSize = picked; }
};

Camera.prototype.setRecorderProfile = function(key) {
  var recorderProfiles = this.mozCamera.capabilities.recorderProfiles;
  this.recorderProfile = recorderProfiles[key];
  this.recorderProfile.key = key;
  debug('video profile set: %s', key);
  return this;
};

/**
 * Sets the current flash mode,
 * both on the Camera instance
 * and on the cameraObj hardware.
 *
 * @param {String} key
 */
Camera.prototype.setFlashMode = function(key) {
  if (this.mozCamera) {
    // If no key was provided, set it to 'off' which is
    // a valid flash mode.
    key = key || 'off';

    this.mozCamera.flashMode = key;
    debug('flash mode set: %s', key);
  }

  return this;
};

/**
 * Releases the camera hardware.
 *
 * @param  {Function} done
 */
Camera.prototype.release = function(done) {
  done = done || function() {};
  var self = this;

  // Ignore if there is no loaded camera
  if (!this.mozCamera) {
    done();
    return;
  }

  // The hardware is not available during
  // the release process
  this.mozCamera.release(onSuccess, onError);
  this.releasing = true;
  this.mozCamera = null;

  function onSuccess() {
    self.releasing = false;
    self.emit('released');
    debug('successfully released');
    done();
  }

  function onError(err) {
    debug('failed to release hardware');
    self.releasing = false;
    done(err);
  }
};

Camera.prototype.pickThumbnailSize = function(thumbnailSizes, pictureSize) {
  var screenWidth = window.innerWidth * window.devicePixelRatio;
  var screenHeight = window.innerHeight * window.devicePixelRatio;
  var pictureAspectRatio = pictureSize.width / pictureSize.height;
  var currentThumbnailSize;
  var i;

  // Coping the array to not modify the original
  thumbnailSizes = thumbnailSizes.slice(0);
  if (!thumbnailSizes || !pictureSize) {
    return;
  }

  function imageSizeFillsScreen(pixelsWidth, pixelsHeight) {
    return ((pixelsWidth >= screenWidth || // portrait
             pixelsHeight >= screenHeight) &&
            (pixelsWidth >= screenHeight || // landscape
             pixelsHeight >= screenWidth));
  }

  // Removes the sizes with the wrong aspect ratio
  thumbnailSizes = thumbnailSizes.filter(function(thumbnailSize) {
    var thumbnailAspectRatio = thumbnailSize.width / thumbnailSize.height;
    return Math.abs(thumbnailAspectRatio - pictureAspectRatio) < 0.05;
  });

  if (thumbnailSizes.length === 0) {
    console.error('Error while selecting thumbnail size. ' +
      'There are no thumbnail sizes that match the ratio of ' +
      'the selected picture size: ' + JSON.stringify(pictureSize));
    return;
  }

  // Sorting the array from smaller to larger sizes
  thumbnailSizes.sort(function(a, b) {
    return a.width * a.height - b.width * b.height;
  });

  for (i = 0; i < thumbnailSizes.length; ++i) {
    currentThumbnailSize = thumbnailSizes[i];
    if (imageSizeFillsScreen(currentThumbnailSize.width,
                             currentThumbnailSize.height)) {
      return currentThumbnailSize;
    }
  }

  return thumbnailSizes[thumbnailSizes.length - 1];
};

/**
 * Takes a photo, or begins/ends
 * a video capture session.
 *
 * Options:
 *
 *   - `position` {Object} - geolocation to store in EXIF
 *
 * @param  {Object} options
 *  public
 */
Camera.prototype.capture = function(options) {
  switch (this.mode) {
    case 'picture': this.takePicture(options); break;
    case 'video': this.toggleRecording(options); break;
  }
};

Camera.prototype.takePicture = function(options) {
  var rotation = orientation.get();
  var selectedCamera = this.get('selectedCamera');
  var self = this;

  rotation = selectedCamera === 'front' ? -rotation : rotation;
  debug('take picture');
  this.emit('busy');
  this.focus(onFocused);

  function onFocused(err) {
    var position = options && options.position;
    var config = {
      rotation: rotation,
      dateTime: Date.now() / 1000,
      pictureSize: self.pictureSize,
      fileFormat: 'jpeg'
    };

    // If position has been
    // passed in, add it to
    // the config object.
    if (position) {
      config.position = position;
    }

    self.mozCamera.takePicture(config, onSuccess, onError);
  }

  function onError(error) {
    var title = navigator.mozL10n.get('error-saving-title');
    var text = navigator.mozL10n.get('error-saving-text');
    // if taking a picture fails because there's already
    // a picture being taken we ignore it
    if (error === 'TakePictureAlreadyInProgress') {
      complete();
    } else {
      alert(title + '. ' + text);
      debug('error taking picture');
      complete();
    }
  }

  function onSuccess(blob) {
    var image = { blob: blob };
    self.resumePreview();
    self.emit('newimage', image);
    debug('success taking picture');
    complete();
  }

  function complete() {
    // If we are in C-AF mode, we have to call resumeContinuousFocus() in
    // order to get the camera to resume focusing on what we point it at.
    if (self.mozCamera.focusMode === CONTINUOUS_AUTO_FOCUS) {
      self.mozCamera.resumeContinuousFocus();
    }

    self.set('focus', 'none');
    self.emit('ready');
  }
};

/**
 * Focus the camera, invoke the callback asynchronously when done.
 *
 * If we only have fixed focus, then we call the callback right away
 * (but still asynchronously). Otherwise, we call autoFocus to focus
 * the camera and call the callback when focus is complete. In C-AF mode
 * this process should be fast. In manual AF mode, focusing takes about
 * a second and causes a noticeable delay before the picture is taken.
 *
 * @param  {Function} done
 * @private
 */
Camera.prototype.focus = function(done) {
  var self = this;
  var focusMode = this.mozCamera.focusMode;

  if (focusMode === MANUAL_AUTO_FOCUS || focusMode === CONTINUOUS_AUTO_FOCUS) {
    //
    // In either focus mode, we call autoFocus() to ensure that the user gets
    // a sharp picture. The difference between the two modes is that if
    // C-AF is on, it is likely that the camera is already focused, so the
    // call to autoFocus() invokes its callback very quickly and we get much
    // better response time.
    //
    // In either case, the callback is passed a boolean specifying whether
    // focus was successful or not, and we display a green or red focus ring
    // then call the done callback, which takes the picture and clears
    // the focus ring.
    //
    this.set('focus', 'focusing');     // white focus ring

    this.mozCamera.autoFocus(function(success) {
      if (success) {
        self.set('focus', 'focused');  // green focus ring
        done();
      }
      else {
        self.set('focus', 'fail');     // red focus ring
        done('failed');
      }
    });
  }
  else {
    // This is fixed focus: there is nothing we can do here so we
    // should just call the callback and take the photo. No focus
    // happens so we don't display a focus ring.
    setTimeout(done);
  }
};

/**
 * Start/stop recording.
 *
 * @param  {Object} options
 */
Camera.prototype.toggleRecording = function(options) {
  var recording = this.get('recording');
  if (recording) { this.stopRecording(); }
  else { this.startRecording(options); }
};

Camera.prototype.startRecording = function(options) {
  var selectedCamera = this.get('selectedCamera');
  var frontCamera = selectedCamera === 'front';
  var rotation = this.orientation.get();
  var storage = this.video.storage;
  var video = this.video;
  var self = this;

  // Rotation is flipped for front camera
  if (frontCamera) { rotation = -rotation; }

  this.emit('busy');

  // Lock orientation during video recording
  this.orientation.stop();

  // First check if there is enough free space
  this.getFreeVideoStorageSpace(gotStorageSpace);

  function gotStorageSpace(err, freeBytes) {
    if (err) { return self.onRecordingError(); }

    var notEnoughSpace = freeBytes < self.video.minSpace;
    var remaining = freeBytes - self.video.spacePadding;
    var targetFileSize = self.get('maxFileSizeBytes');
    var maxFileSizeBytes = targetFileSize || remaining;

    // Don't continue if there
    // is not enough space
    if (notEnoughSpace) {
      self.onRecordingError('nospace2');
      return;
    }

    // TODO: Callee should
    // pass in orientation
    var config = {
      rotation: rotation,
      maxFileSizeBytes: maxFileSizeBytes
    };

    self.createVideoFilepath(function(filepath) {
      video.filepath = filepath;
      self.mozCamera.startRecording(
        config,
        storage,
        filepath,
        onSuccess,
        self.onRecordingError);
    });
  }

  function onSuccess() {
    self.set('recording', true);
    self.startVideoTimer();
    self.emit('ready');

    // User closed app while
    // recording was trying to start
    //
    // TODO: Not sure this should be here
    if (document.hidden) {
      self.stopRecording();
    }
  }
};

Camera.prototype.stopRecording = function() {
  debug('stop recording');

  var notRecording = !this.get('recording');
  var elapsedTime = Date.now() - this.get('videoStart');
  var storage = this.video.storage;
  var video = this.video;
  var self = this;
  var takenVideo;

  // Ensure we are in the middle of a recording and that the minimum video
  // duration has been exceeded. Video files will not save to the file
  // system unless they are of a certain minimum length (see Bug 899864).
  //
  // TODO: There should be a better way of handling this or a fix for
  // this should be addressed in the Gecko API.
  if (notRecording || elapsedTime < constants.MIN_RECORDING_TIME) {
    return;
  }

  this.stopVideoTimer();
  this.mozCamera.stopRecording();
  this.set('recording', false);
  this.emit('busy');

  // Unlock orientation when stopping video recording
  this.orientation.start();

  // Register a listener for writing
  // completion of current video file
  storage.addEventListener('change', onStorageChange);

  function onStorageChange(e) {
    // If the storage becomes unavailable
    // For instance when yanking the SD CARD
    if (e.reason === 'unavailable') {
      storage.removeEventListener('change', onStorageChange);
      self.emit('ready');
      return;
    }
    debug('video file ready', e.path);
    var matchesFile = e.path.indexOf(video.filepath) > -1;

    // Regard the modification as
    // video file writing completion
    // if e.path matches current video
    // filename. Note e.path is absolute path.
    if (e.reason === 'modified' && matchesFile) {
      storage.removeEventListener('change', onStorageChange);
      self.getVideoBlob(gotVideoBlob);
    }
  }

  function gotVideoBlob(blob) {
    takenVideo = {
      blob: blob,
      filepath: video.filepath
    };
    getVideoMetaData(blob, gotVideoMetaData);
  }

  function gotVideoMetaData(error, data) {
    if (error) {
      return self.onRecordingError();
    }
    takenVideo.poster = data.poster;
    takenVideo.width = data.width;
    takenVideo.height = data.height;
    takenVideo.rotation = data.rotation;
    self.emit('newvideo', takenVideo);
    self.emit('ready');
  }

};

// TODO: This is UI stuff, so
// shouldn't be handled in this file.
Camera.prototype.onRecordingError = function(id) {
  id = id && id !== 'FAILURE' ? id : 'error-recording';
  var title = navigator.mozL10n.get(id + '-title');
  var text = navigator.mozL10n.get(id + '-text');
  alert(title + '. ' + text);
  this.emit('ready');
};

/**
 * Emit useful event hook.
 *
 * @private
 */
Camera.prototype.onShutter = function() {
  this.emit('shutter');
};

/**
 * The preview state change events come
 * from the camera hardware. If 'stopped'
 * or 'paused' the camera must not be used.
 *
 * @param  {String} state
 * @private
 */
Camera.prototype.onPreviewStateChange = function(state) {
  debug('preview state change: %s', state);
  var busy = state === 'stopped' || state === 'paused';
  if (busy) { this.emit('busy'); }
  else { this.emit('ready'); }
};

/**
 * Emit useful event hook.
 *
 * @param  {String} msg
 * @private
 */
Camera.prototype.onRecorderStateChange = function(msg) {
  if (msg === 'FileSizeLimitReached') {
    this.emit('filesizelimitreached');
  }
};

/**
 * Get the number of remaining
 * bytes in video storage.
 *
 * @param  {Function} done
 * @async
 * @private
 */
Camera.prototype.getFreeVideoStorageSpace = function(done) {
  debug('get free storage space');

  var storage = this.video.storage;
  var req = storage.freeSpace();
  req.onerror = onError;
  req.onsuccess = onSuccess;

  function onSuccess() {
    var freeBytes = req.result;
    debug('%d free space found', freeBytes);
    done(null, freeBytes);
  }

  function onError() {
    done('error');
  }
};

/**
 * Get the recorded video out of storage.
 *
 * @param  {Function} done
 * @private
 * @async
 */
Camera.prototype.getVideoBlob = function(done) {
  debug('get video blob');
  var video = this.video;
  var req = video.storage.get(video.filepath);
  req.onsuccess = onSuccess;
  req.onerror = onError;

  function onSuccess() {
    debug('got video blob');
    done(req.result);
  }

  function onError() {
    console.error('failed to get \'%s\' from storage', video.filepath);
  }
};

/**
 * Get a unique video filepath
 * to record a new video to.
 *
 * Your application can overwrite
 * this method with something
 * so that you can record directly
 * to final location. We do this
 * in CameraController.
 *
 * Callback function signature used
 * so that an async override can
 * be used if you wish.
 *
 * @param  {Function} done
 */
Camera.prototype.createVideoFilepath = function(done) {
  done(Date.now() + '_tmp.3gp');
};

Camera.prototype.resumePreview = function() {
  this.mozCamera.resumePreview();
  this.emit('previewresumed');
};

/**
 * Toggles between 'picture'
 * and 'video' capture modes.
 *
 * @return {String}
 */
Camera.prototype.setMode = function(mode) {
  var recording = this.get('recording');
  if (recording) { this.stopRecording(); }
  this.mode = mode;
  return this;
};

/**
 * Sets a start time and begins
 * updating the elapsed time
 * every second.
 *
 */
Camera.prototype.startVideoTimer = function() {
  this.set('videoStart', new Date().getTime());
  this.videoTimer = setInterval(this.updateVideoElapsed, 1000);
  this.updateVideoElapsed();
};

Camera.prototype.stopVideoTimer = function() {
  clearInterval(this.videoTimer);
  this.videoTimer = null;
};

/**
 * Calculates the elapse time
 * and updateds the 'videoElapsed'
 * value.
 *
 * We listen for the 'change:'
 * event emitted elsewhere to
 * update the UI accordingly.
 *
 */
Camera.prototype.updateVideoElapsed = function() {
  var now = new Date().getTime();
  var start = this.get('videoStart');
  this.set('videoElapsed', (now - start));
};

/**
 * Set ISO value for
 * better picture
 */
Camera.prototype.setISOMode = function(value) {
  var isoModes = this.mozCamera.capabilities.isoModes;
  if (isoModes && isoModes.indexOf(value) > -1) {
    this.mozCamera.isoMode = value;
  }
};

/**
 * Set the mozCamera white-balance value.
 *
 * @param {String} value
 */
Camera.prototype.setWhiteBalance = function(value){
  var capabilities = this.mozCamera.capabilities;
  var modes = capabilities.whiteBalanceModes;
  if (modes && modes.indexOf(value) > -1) {
    this.mozCamera.whiteBalanceMode = value;
  }
};

/**
 * Set HDR mode.
 *
 * HDR is a scene mode, so we
 * transform the hdr value to
 * the appropriate scene value.
 *
 * @param {String} value
 */
Camera.prototype.setHDR = function(value){
  if (!value) { return; }
  var scene = value === 'on' ? 'hdr' : 'auto';
  this.setSceneMode(scene);
};

/**
 * Set scene mode.
 *
 * @param {String} value
 */
Camera.prototype.setSceneMode = function(value){
  var modes =  this.get('capabilities').sceneModes;
  if (modes.indexOf(value) > -1) {
    this.mozCamera.sceneMode = value;
  }
};

Camera.prototype.configureFocus = function(captureMode) {
  var focusModes = this.get('capabilities').focusModes;

  // If we're taking still pictures, and C-AF is enabled and supported
  // (and gecko supports resumeContinuousFocus) then use C-AF.
  // XXX: once bug 986024 has landed and been uplifted we can remove
  // the check for resumeContinuousFocus support
  if (captureMode === 'picture') {
    if (this.cafEnabled &&
        focusModes.indexOf(CONTINUOUS_AUTO_FOCUS) >= 0 &&
        this.mozCamera.resumeContinuousFocus) {
      this.mozCamera.focusMode = CONTINUOUS_AUTO_FOCUS;
      return;
    }
  }

  // Otherwise, we'll use 'auto' mode, if it is supported.
  // We do this for video and still pictures. For videos, this mode
  // actually does continous focus and it seems to work better than
  // the actual 'continuous-video' mode.
  if (focusModes.indexOf(MANUAL_AUTO_FOCUS) >= 0) {
    this.mozCamera.focusMode = MANUAL_AUTO_FOCUS;
  }
  else {
    // If auto mode is not supported then we presumably have a fixed focus
    // camera. Just use the first available focus mode, and don't call
    // auto focus. This happens with the front-facing camera, typically
    this.mozCamera.focusMode = focusModes[0];
  }
};

Camera.prototype.isZoomSupported = function() {
  return this.mozCamera.capabilities.zoomRatios.length > 1;
};

Camera.prototype.configureZoom = function(previewSize) {
  var maxPreviewSize =
    CameraUtils.getMaximumPreviewSize(this.previewSizes());

  // Calculate the maximum amount of zoom that the hardware will
  // perform. This calculation is determined by taking the maximum
  // supported preview size *width* and dividing by the current preview
  // size *width*.
  var maxHardwareZoom = maxPreviewSize.width / previewSize.width;
  this.set('maxHardwareZoom', maxHardwareZoom);

  this.setZoom(this.getMinimumZoom());
  this.emit('zoomconfigured');
};

Camera.prototype.getMinimumZoom = function() {
  var zoomRatios = this.mozCamera.capabilities.zoomRatios;
  if (zoomRatios.length === 0) {
    return 1.0;
  }

  return zoomRatios[0];
};

Camera.prototype.getMaximumZoom = function() {
  var zoomRatios = this.mozCamera.capabilities.zoomRatios;
  if (zoomRatios.length === 0) {
    return 1.0;
  }

  return zoomRatios[zoomRatios.length - 1];
};

Camera.prototype.getZoom = function() {
  return this.mozCamera.zoom;
};

Camera.prototype.setZoom = function(zoom) {
  this.mozCamera.zoom = zoom;
  this.emit('zoomchanged', zoom);
};

Camera.prototype.getZoomPreviewAdjustment = function() {
  var zoom = this.mozCamera.zoom;
  var maxHardwareZoom = this.get('maxHardwareZoom');
  if (zoom <= maxHardwareZoom) {
    return 1.0;
  }

  return zoom / maxHardwareZoom;
};

/**
 * Retrieves the angle of orientation of the camera hardware's
 * image sensor. This value is calculated as the angle that the
 * camera image needs to be rotated (clockwise) so that it appears
 * correctly on the display in the device's natural (portrait)
 * orientation
 *
 * Reference:
 * http://developer.android.com/reference/android/hardware/Camera.CameraInfo.html#orientation
 *
 * @return {Number}
 */
Camera.prototype.getSensorAngle = function() {
  return this.mozCamera.sensorAngle;
};

});

define('lib/sounds',['require','exports','module'],function(require, exports, module) {


/**
 * Exports
 */

module.exports = Sounds;

/**
 * Initialize a new `Sounds` interface.
 *
 * @constructor
 */
function Sounds(list) {
  this.items = {};
  (list || []).forEach(this.add, this);
}

/**
 * Add a new sound.
 *
 * Checks if this sound
 * is enabled, and sets
 * up an observer.
 *
 * @param {Object} data
 *
 */
Sounds.prototype.add = function(data) {
  var self = this;
  var sound = {
    name: data.name,
    url: data.url,
    setting: data.setting,
    enabled: false
  };

  // Prefetch audio
  sound.audio = this.createAudio(sound.url);

  this.items[data.name] = sound;
  this.isEnabled(sound, function(value) {
    self.setEnabled(sound, value);
    self.observeSetting(sound);
  });
};

/**
 * Check if a sound is
 * enabled inside mozSettings.
 *
 * This is wrapped in a setTimeout
 * to prevent expensive mozSettings
 * API from blocking other operations.
 *
 * @param  {Object}   sound
 * @param  {Function} done
 */
Sounds.prototype.isEnabled = function(sound, done) {
  setTimeout(function() {
    var mozSettings = navigator.mozSettings;
    var key = sound.setting;

    // Requires navigator.mozSettings
    if (!mozSettings) {
      return;
    }

    mozSettings
      .createLock()
      .get(key)
      .onsuccess = onSuccess;

    function onSuccess(e) {
      var result = e.target.result[key];
      done(result);
    }
  });
};

/**
 * Observe mozSettings for changes
 * on the given settings key.
 *
 * @param  {Object} sound
 *
 */
Sounds.prototype.observeSetting = function(sound) {
  var mozSettings = navigator.mozSettings;
  var key = sound.setting;
  var self = this;
  if (mozSettings) {
    mozSettings.addObserver(key, function(e) {
      self.setEnabled(sound, e.settingValue);
    });
  }
};

/**
 * Set a sounds `enabled` key.
 *
 * @param {Object} sound
 * @param {Boolean} value
 *
 */
Sounds.prototype.setEnabled = function(sound, value) {
  sound.enabled = value;
};

/**
 * Play a sound by name.
 *
 * @param  {String} name
 * @public
 */
Sounds.prototype.play = function(name) {
  this.playSound(this.items[name]);
};

/**
 * Return a function that plays
 * the given sound when called.
 *
 * @param  {String} name
 * @return {Funciton}
 * @public
 */
Sounds.prototype.player = function(name) {
  return (function() { this.play(name); }).bind(this);
};

/**
 * Play a sound.
 *
 * @param  {Object} sound
 *
 */
Sounds.prototype.playSound = function(sound) {
  if (sound.enabled) {
    // cloneNode() lets us play overlapping sounds and is needed when the
    // user takes pictures very rapidly.
    // See http://robert.ocallahan.org/2011/11/latency-of-html5-sounds.html
    sound.audio.cloneNode(true).play();
  }
};

/**
 * Create an audio element.
 *
 * @param  {String} url
 * @return {HTMLAudioElement}
 */
Sounds.prototype.createAudio = function(url) {
  var audio = new Audio(url);
  audio.mozAudioChannelType = 'notification';
  return audio;
};

});

define('lib/setting-alias',['require','exports','module','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var evt = require('vendor/evt');

/**
 * Locals
 */

var off = evt.prototype.off;
var on = evt.prototype.on;
var forwardMethods = [
  'filterOptions',
  'resetOptions',
  'supported',
  'selected',
  'select',
  'next',
  'get',
  'set'
];

/**
 * Exports
 */

module.exports = SettingAlias;

// Mixin emitter
evt(SettingAlias.prototype);

/**
 * Initialize a new `SettingsAlias`
 *
 * @param {Object} options
 */
function SettingAlias(options) {
  this.settings = options.settings;
  this.key = options.key;
  this.map = options.map || {};
  this.setting = options.get.bind(this);
  forwardMethods.forEach(this.forward, this);
  this.propagate = this.propagator();
}

/**
 * Attaches a method that forwards
 * the call onto the current
 * matching setting.
 *
 * @param  {String} method
 */
SettingAlias.prototype.forward = function(method) {
  this[method] = function() {
    var setting = this.setting();
    return setting[method].apply(setting, arguments);
  };
};

/**
 * Attach a pseudo callback that
 * fires when the same event fires
 * on the currently active setting.
 *
 * @param  {String}   name
 * @param  {Function} fn
 */
SettingAlias.prototype.on = function(name, fn) {
  on.call(this, name, fn);
  for (var key in this.map) {
    var setting = this.settings[this.map[key]];
    setting.on(name, this.propagate);
  }
};

/**
 * Remove pseudo callback.
 *
 * @param  {String}   name
 * @param  {Function} fn
 */
SettingAlias.prototype.off = function(name, fn) {
  off.call(this, name, fn);
  for (var key in this.map) {
    var setting = this.settings[this.map[key]];
    setting.off(name, this.propagate);
  }
};

/**
 * Returns a function that when
 * attached as a callback to
 * another event handler, will
 * fire the same event on itself.
 *
 * `this._fireArgs` is the original
 * list of arguments passed when the
 * event was fired.
 *
 * Access to this allows use to re-fire
 * the event on another emitter in exactly
 * the same way it was originally fired.
 *
 * @param  {String}   name
 * @param  {Function} fn
 */
SettingAlias.prototype.propagator = function() {
  var alias = this;
  return function() {
    if (this.key === alias.get().key) {
      alias.fire.apply(alias, this._fireArgs);
    }
  };
};

});

define('lib/setting',['require','exports','module','debug','vendor/model'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('setting');
var model = require('vendor/model');

/**
 * Exports
 */

module.exports = Setting;

/**
 * Mixin `Model` methods
 */

model(Setting.prototype);

/**
 * Initialize a new `Setting`.
 *
 * @param {Object} data
 */
function Setting(data) {
  this.key = data.key;
  this.storage = data.storage || localStorage;
  this.reset(data, { silent: true });
  this.select = this.select.bind(this);
  this.next = this.next.bind(this);
  this.configure(data);
  if (data.persistent) { this.on('change:selected', this.save); }
}

Setting.prototype.configure = function(data) {
  var optionsDefined = !!(data.options && data.options.length);
  this.options = { defined: optionsDefined };
  this.resetOptions(data.options);
};

Setting.prototype.resetOptions = function(list) {
  list = list || [];

  var hash = this.optionsToHash(list);
  this.options.all = hash;
  this.options.available = hash;

  this.set('options', list, { silent: true });
  this.updateSelected({ silent: true });
};

Setting.prototype.filterOptions = function(keys) {
  var available = this.options.available = {};
  var hash = this.options.all;
  var filtered = [];

  (keys || []).forEach(function(key) {
    var option = hash[key];
    if (option !== undefined) {
      filtered.push(option);
      available[key] = option;
    }
  });

  this.sortByIndex(filtered);
  this.set('options', filtered, { silent: true });
  this.updateSelected({ silent: true });
};

/**
 * Convert this Setting's `options` array as defined
 * in config/app.js into an object as key/value pairs.
 * This allows us to look up an option by its `key`.
 *
 * e.g.: [ { key: 'a', title: 'A' }, ... ] ->
 *       { a: { key: 'a', title: 'A' }, ... }
 *
 * We use this hash to validate
 * incoming options and ot mixin
 * config data with dynamic options.
 *
 * @param  {Array} options
 * @return {undefined|Object}
 */
Setting.prototype.optionsToHash = function(options) {
  var hash = {};
  options.forEach(function(option, index) {
    option.index = index;
    hash[option.key] = option;
  });
  return hash;
};

/**
 * Get the selected option,
 * or just a particular key
 * if given.
 *
 * @param  {String} key
 * @return {Object|*}
 */
Setting.prototype.selected = function(key) {
  var hash = this.options.available;
  var option = hash[this.get('selected')];
  return key ? option && option[key] : option;
};

/**
 * Select an option.
 *
 * Accepts an string key to select,
 * or an integer index relating to
 * the current options list.
 *
 * Options:
 *
 *  - {Boolean} silent
 *
 * @param {String|Number} key
 * @param {Object} opts  Model#set() options
 */
Setting.prototype.select = function(key, options) {
  var isIndex = typeof key === 'number';
  var list = this.get('options');
  var available = this.options.available;
  var selected = isIndex ? list[key] : available[key];

  // If there are no options, exit
  if (!list.length) { return; }

  // If an option was not found,
  // default to selecting the first.
  if (!selected) { return this.select(0, options); }

  // Store the new choice
  this.set('selected', selected.key, options);
};

/**
 * Sorts the current options list
 * by their originally defined
 * index in the config JSON.
 *
 * @private
 */
Setting.prototype.sortByIndex = function(list) {
  return list.sort(function(a, b) { return a.index - b.index; });
};

/**
 * Silently updates the `selected`
 * property of the Setting.
 *
 * If no selected key is present
 * we attempt to select the last
 * fetched persited selection.
 *
 * @private
 */
Setting.prototype.updateSelected = function() {
  this.select(this.get('selected') || this.fetched, { silent: true });
};

/**
 * Set the `selected` option to
 * the next option in the list.
 *
 * First option is chosen if
 * there is no next option.
 *
 * @public
 */
Setting.prototype.next = function() {
  var options = this.get('options');
  var selected = this.selected();
  var index = options.indexOf(selected);
  var newIndex = (index + 1) % options.length;
  this.select(newIndex);
  debug('set \'%s\' to index: %s', this.key, newIndex);
};

/**
 * Persists the current selection
 * to storage for retreval in the
 * next session.
 *
 * We're using localStorage as performance
 * vastly outweighed indexedBD (asyncStorage)
 * by 1ms/500ms on Hamachi device.
 *
 * @public
 */
Setting.prototype.save = function() {
  var selected = this.get('selected');
  debug('saving key: %s, selected: %s', this.key, selected);
  this.storage.setItem('setting:' + this.key, selected);
  debug('saved key: %s', selected);
};

/**
 * Fetches the persisted selection
 * from storage, updating the
 * `selected` key.
 *
 * We're using localStorage, as performance
 * vastly outweighed indexedBD (asyncStorage)
 * by 1ms/500ms on Hamachi device.
 *
 * Leaving in the `done` callback in-case
 * storage goes async again in future.
 *
 * @param  {Function} done
 * @public
 */
Setting.prototype.fetch = function() {
  if (!this.get('persistent')) { return; }
  debug('fetch value key: %s', this.key);
  this.fetched = this.storage.getItem('setting:' + this.key);
  debug('fetched %s value: %s', this.key, this.fetched);
  if (this.fetched) { this.select(this.fetched, { silent: true }); }
};

/**
 * States whether this setting
 * is currently supported.
 *
 * 'Supported' means, it's not been
 * disabled, and there are options
 * to be chosen from.
 *
 * @return {Boolean}
 */
Setting.prototype.supported = function() {
  return this.enabled() && !!this.get('options').length;
};


/**
 * Check if this setting is not
 * marked as disabled.
 *
 * @return {Boolean}
 */
Setting.prototype.enabled = function() {
  return !this.get('disabled');
};

});

define('lib/settings',['require','exports','module','./setting-alias','debug','./setting','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var SettingAlias = require('./setting-alias');
var debug = require('debug')('settings');
var Setting = require('./setting');
var evt = require('vendor/evt');

/**
 * Mixin emitter
 */

evt(Settings.prototype);

/**
 * Exports
 */

module.exports = Settings;

/**
 * Initialize a new 'Setting'
 *
 * @param {Object} items
 */
function Settings(items) {
  this.ids = {};
  this.items = [];
  this.aliases = {};
  this.SettingAlias = SettingAlias; // Test hook
  this.addEach(items);
}

Settings.prototype.addEach = function(items) {
  if (!items) { return; }
  var item;
  var key;

  for (key in items) {
    item = items[key];
    item.key = item.key || key;
    this.add(items[key]);
  }
};

Settings.prototype.add = function(data) {
  var setting = new Setting(data);
  this.items.push(setting);
  this.ids[setting.key] = this[setting.key] = setting;
  debug('added setting: %', setting.key);
};

Settings.prototype.fetch = function(done) {
  this.items.forEach(function(setting) { setting.fetch(); });
};

Settings.prototype.alias = function(key, options) {
  options.settings = this;
  options.key = key;
  var alias = new this.SettingAlias(options);
  this.aliases[key] = alias;
  this[key] = alias;
};

Settings.prototype.removeAlias = function(key) {
  // TODO: Implement
};

});

define('config/sounds',['require','exports','module'],function(require, exports, module) {



module.exports = [
  {
    name: 'shutter',
    setting: 'camera.shutter.enabled',
    url: './resources/sounds/shutter.opus'
  },
  {
    name: 'recordingStart',
    url: './resources/sounds/camcorder_start.opus',
    setting: 'camera.recordingsound.enabled'
  },
  {
    name: 'recordingEnd',
    url: './resources/sounds/camcorder_end.opus',
    setting: 'camera.recordingsound.enabled'
  }
];


});

define('config/settings',['require','exports','module'],function(require, exports, module) {


module.exports = {
  zoom: {
    disabled: false,

    // The viewfinder preview stream should automatically
    // reflect the current zoom value. However, on some
    // devices, the viewfinder needs to be scaled by the
    // application. Set this flag if the preview stream
    // does not visually reflect the zoom value properly.
    useZoomPreviewAdjustment: false
  },
  caf: {
    // Set this property to true if you want to disable continuous auto focus
    // even on hardware that supports it.
    disabled: false
  },
  previewGallery: {

    // Flag for determining if the preview should limit the
    // image size to the value of CONFIG_MAX_IMAGE_PIXEL_SIZE
    // (enable for devices with limited memory)
    limitMaxPreviewSize: true,

    // Dimensions for thumbnail image (will automatically be
    // multiplied by the devicePixelRatio)
    thumbnailWidth: 54,
    thumbnailHeight: 54
  },
  viewfinder: {
    scaleType: 'fill'
  },
  battery: {
    levels: {
      low: 15,
      verylow: 10,
      critical: 6,
      shutdown: 5,
      healthy: 100
    }
  },
  geolocation: {
    promptDelay: 2000
  },
  mode: {
    options: [
      {
        key: 'picture'
      },
      {
        key: 'video'
      }
    ],
    persistent: false
  },
  activity: {

    // Reduce the size of images returned by pick activities.
    // A pick activity can specify its own maximum size. However,
    // this setting can lower that pixel size limitation even
    // further. To prevent further limiting the pixel size for
    // pick activities, set this value to `0`.
    // (useful for devices with limited memory)
    maxPickPixelSize: 0,

    // Reduce the size of images returned by share activities.
    // To prevent resizing images that are shared, set this
    // value to `0`.
    // (useful for devices with limited memory)
    maxSharePixelSize: 0
  },
  loadingScreen: {
    delay: 600
  },
  isoModes: {
    disabled: false,
    options: [
      {
        key: 'auto'
      }
    ],
    selected:'auto'
  },

  whiteBalance: {
    disabled: false,
    options: [
      {
        key: 'auto'
      }
    ],
    selected:'auto'
  },

  cameras: {
    options: [
      {
        key: 'back'
      },
      {
        key: 'front'
      }
    ],
    persistent: false
  },

  pictureSizesFront: {
    title: 'camera-resolution',
    header: 'camera-resolution-header',
    icon: 'icon-picture-size',
    maxPixelSize: window.CONFIG_MAX_SNAPSHOT_PIXEL_SIZE,
    options: [
      // {
      //   key: '2048x1536'
      // }
    ],
    persistent: true
  },

  pictureSizesBack: {
    title: 'camera-resolution',
    header: 'camera-resolution-header',
    icon: 'icon-picture-size',
    maxPixelSize: window.CONFIG_MAX_SNAPSHOT_PIXEL_SIZE,
    options: [
      // {
      //   key: '2048x1536'
      // }
    ],
    exclude: ['1920x1088'],
    persistent: true
  },

  recorderProfilesBack: {
    title: 'video-resolution',
    header: 'video-resolution-header',
    icon: 'icon-video-size',
    options: [],
    exclude: ['high', '1080p'],
    persistent: true
  },

  recorderProfilesFront: {
    title: 'video-resolution',
    header: 'video-resolution-header',
    icon: 'icon-video-size',
    options: [],
    persistent: true
  },

  flashModesPicture: {
    title: 'flash',
    options: [
      {
        key: 'auto',
        icon: 'icon-flash-auto',
        title: 'flash-auto'
      },
      {
        key: 'on',
        icon: 'icon-flash-on',
        title: 'flash-on'
      },
      {
        key: 'off',
        icon: 'icon-flash-off',
        title: 'flash-off'
      }
    ],
    persistent: true
  },

  flashModesVideo: {
    title: 'flash',
    options: [
      {
        key: 'off',
        icon: 'icon-flash-off',
        title: 'flash-off'
      },
      {
        key: 'torch',
        icon: 'icon-flash-on',
        title: 'flash-on'
      }
    ],
    persistent: true
  },

  timer: {
    title: 'self-timer',
    header: 'self-timer-header',
    icon: 'icon-timer',
    options: [
      {
        key: 'off',
        title: 'self-timer-off',
        value: 0
      },
      {
        key: '3secs',
        value: 3,
        title: 'self-timer-3-seconds'
      },
      {
        key: '5secs',
        value: 5,
        title: 'self-timer-5-seconds'
      },
      {
        key: '10secs',
        value: 10,
        title: 'self-timer-10-seconds'
      }
    ],
    persistent: false,
  },

  hdr: {
    title: 'hdr',
    header: 'hdr-header',
    icon: 'icon-hdr-menu',
    disabled: false,
    options: [
      {
        key: 'off',
        title: 'hdr-off'
      },
      {
        key: 'on',
        title: 'hdr-on'
      }
    ],
    persistent: true
  },

  scene: {
    title: 'scene-mode',
    header: 'scene-mode-header',
    icon: 'icon-scene',
    options: [
      {
        key: 'normal',
        title: 'scene-mode-normal'
      },
      {
        key: 'pano',
        title: 'scene-mode-panorama'
      },
      {
        key: 'beauty',
        title: 'scene-mode-beauty'
      }
    ],
    persistent: true,
  },

  grid: {
    title: 'grid',
    header: 'grid-header',
    icon: 'icon-frame-grid',
    options: [
      {
        key: 'off',
        title: 'grid-off'
      },
      {
        key: 'on',
        title: 'grid-on'
      }
    ],
    selected: 'off',
    persistent: true,
  },

  settingsMenu: {
    items: [
      // {
      //   key: 'scene'
      // },
      {
        key: 'hdr'
      },
      {
        key: 'timer'
      },
      // {
      //   key: 'pictureSizes'
      // },
      // {
      //   key: 'recorderProfiles'
      // },
      {
        key: 'grid'
      }
    ]
  }
};

});

define('lib/geo-location',['require','exports','module','debug'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('geolocation');

/**
 * Locals
 */

var geolocation = navigator.geolocation;

/**
 * Exports
 */

module.exports = GeoLocation;

/**
 * Interface to the
 * geolocation API.
 *
 * @constructor
 */
function GeoLocation() {
  this.watcher = null;
  this.position = null;
  this.setPosition = this.setPosition.bind(this);
  this.watch = this.watch.bind(this);
}

/**
 * Watches device location.
 *
 * @public
 */
GeoLocation.prototype.watch = function() {
  if (!this.watcher) {
    this.watcher = geolocation.watchPosition(this.setPosition);
    debug('started watching');
  }
};

/**
 * Stops watching
 * device location.
 *
 * @public
 */
GeoLocation.prototype.stopWatching = function() {
  geolocation.clearWatch(this.watcher);
  this.watcher = null;
  debug('stopped watching');
};

/**
 * Updates the stored
 * position object.
 *
 * @private
 */
GeoLocation.prototype.setPosition = function(position) {
  this.position = {
    timestamp: position.timestamp,
    altitude: position.coords.altitude,
    latitude: position.coords.latitude,
    longitude: position.coords.longitude
  };
};

});

define('lib/activity',['require','exports','module','debug','vendor/model'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('activity');
var model = require('vendor/model');

/**
 * Mixin `Model` methods
 */

model(Activity.prototype);

/**
 * Exports
 */

module.exports = Activity;

/**
 * Initialize a new `Activity`
 *
 * @constructor
 */
function Activity() {
  this.active = false;
  this.data = {};
  this.modes = ['picture', 'video'];
  debug('initialized');
}

/**
 * Checks for a pending activity,
 * calling the given callback
 * when done.
 *
 * NOTE: The `done` callback may be called a number of times
 * over the lifespan of the app instance. When the Camera app
 * receives a `record` activity, it reuses an instance of the
 * Camera app (if one exists), therefore, this callback may
 * execute more than once.
 *
 * @param  {Function} done
 */
Activity.prototype.check = function(done) {
  var hasMessage = navigator.mozHasPendingMessage('activity');
  var self = this;

  navigator.mozSetMessageHandler('activity', onActivity);

  if (!hasMessage) {
    debug('none');
    setTimeout(done);
    return;
  }

  function onActivity(activity) {
    var source = activity.source;
    var name = source.name;
    var data = source.data;

    self.activity = activity;
    self.name = name;
    self.data = data;

    switch (name) {
      case 'pick':
        debug('Received \'pick\' activity for types: %s', data.type);
        self.active = true;
        self.modes = self.getModesForPickActivity(activity);
        self.emit('activityreceived');
        break;
      case 'record':
        debug('Received \'record\' activity for types: %s', data.type);
        self.modes = self.getModesForRecordActivity(activity);
        self.emit('activityreceived');
        break;
      default:
        debug('Received unsupported \'%s\' activity', name);
        break;
    }

    done();
  }
};

Activity.prototype.getModesForPickActivity = function(activity) {
  var source = activity.source;
  var types = [].concat(source.data.type || []);
  var modes = [];

  types.forEach(function(item) {
    var type = item.split('/')[0];
    var mode = type === 'image' ? 'picture' : type;

    if (modes.indexOf(mode) === -1) {
      modes.push(mode);
    }
  });

  if (modes.length === 0) {
    modes = ['picture', 'video'];
  }

  return modes;
};

Activity.prototype.getModesForRecordActivity = function(activity) {
  var source = activity.source;
  var type = source.data.type;
  if (type === 'videos') {
    return ['video', 'picture'];
  }

  return ['picture', 'video'];
};

/**
 * Post data back to the app
 * which spawned the activity.
 *
 * @param  {Object} data
 *
 */
Activity.prototype.postResult = function(data) {
  if (this.active) {
    this.activity.postResult(data);
  }
};

/**
 * Cancel the activity.
 *
 * This should cause the user
 * to be navigated back to the
 * app which spawned the activity.
 *
 */
Activity.prototype.cancel = function() {
  if (this.active) {
    this.activity.postError('pick cancelled');
  }
};

});

/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- /
/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */



/**
 * This file defines an asynchronous version of the localStorage API, backed by
 * an IndexedDB database.  It creates a global asyncStorage object that has
 * methods like the localStorage object.
 *
 * To store a value use setItem:
 *
 *   asyncStorage.setItem('key', 'value');
 *
 * If you want confirmation that the value has been stored, pass a callback
 * function as the third argument:
 *
 *  asyncStorage.setItem('key', 'newvalue', function() {
 *    console.log('new value stored');
 *  });
 *
 * To read a value, call getItem(), but note that you must supply a callback
 * function that the value will be passed to asynchronously:
 *
 *  asyncStorage.getItem('key', function(value) {
 *    console.log('The value of key is:', value);
 *  });
 *
 * Note that unlike localStorage, asyncStorage does not allow you to store and
 * retrieve values by setting and querying properties directly. You cannot just
 * write asyncStorage.key; you have to explicitly call setItem() or getItem().
 *
 * removeItem(), clear(), length(), and key() are like the same-named methods of
 * localStorage, but, like getItem() and setItem() they take a callback
 * argument.
 *
 * The asynchronous nature of getItem() makes it tricky to retrieve multiple
 * values. But unlike localStorage, asyncStorage does not require the values you
 * store to be strings.  So if you need to save multiple values and want to
 * retrieve them together, in a single asynchronous operation, just group the
 * values into a single object. The properties of this object may not include
 * DOM elements, but they may include things like Blobs and typed arrays.
 *
 * Unit tests are in apps/gallery/test/unit/asyncStorage_test.js
 */

this.asyncStorage = (function() {

  var DBNAME = 'asyncStorage';
  var DBVERSION = 1;
  var STORENAME = 'keyvaluepairs';
  var db = null;

  function withDatabase(f) {
    if (db) {
      f();
    } else {
      var openreq = indexedDB.open(DBNAME, DBVERSION);
      openreq.onerror = function withStoreOnError() {
        console.error("asyncStorage: can't open database:", openreq.error.name);
      };
      openreq.onupgradeneeded = function withStoreOnUpgradeNeeded() {
        // First time setup: create an empty object store
        openreq.result.createObjectStore(STORENAME);
      };
      openreq.onsuccess = function withStoreOnSuccess() {
        db = openreq.result;
        f();
      };
    }
  }

  function withStore(type, callback, oncomplete) {
    withDatabase(function() {
      var transaction = db.transaction(STORENAME, type);
      if (oncomplete) {
        transaction.oncomplete = oncomplete;
      }
      callback(transaction.objectStore(STORENAME));
    });
  }

  function getItem(key, callback) {
    var req;
    withStore('readonly', function getItemBody(store) {
      req = store.get(key);
      req.onerror = function getItemOnError() {
        console.error('Error in asyncStorage.getItem(): ', req.error.name);
      };
    }, function onComplete() {
      var value = req.result;
      if (value === undefined) {
        value = null;
      }
      callback(value);
    });
  }

  function setItem(key, value, callback) {
    withStore('readwrite', function setItemBody(store) {
      var req = store.put(value, key);
      req.onerror = function setItemOnError() {
        console.error('Error in asyncStorage.setItem(): ', req.error.name);
      };
    }, callback);
  }

  function removeItem(key, callback) {
    withStore('readwrite', function removeItemBody(store) {
      var req = store.delete(key);
      req.onerror = function removeItemOnError() {
        console.error('Error in asyncStorage.removeItem(): ', req.error.name);
      };
    }, callback);
  }

  function clear(callback) {
    withStore('readwrite', function clearBody(store) {
      var req = store.clear();
      req.onerror = function clearOnError() {
        console.error('Error in asyncStorage.clear(): ', req.error.name);
      };
    }, callback);
  }

  function length(callback) {
    var req;
    withStore('readonly', function lengthBody(store) {
      req = store.count();
      req.onerror = function lengthOnError() {
        console.error('Error in asyncStorage.length(): ', req.error.name);
      };
    }, function onComplete() {
      callback(req.result);
    });
  }

  function key(n, callback) {
    if (n < 0) {
      callback(null);
      return;
    }

    var req;
    withStore('readonly', function keyBody(store) {
      var advanced = false;
      req = store.openCursor();
      req.onsuccess = function keyOnSuccess() {
        var cursor = req.result;
        if (!cursor) {
          // this means there weren't enough keys
          return;
        }
        if (n === 0 || advanced) {
          // Either 1) we have the first key, return it if that's what they
          // wanted, or 2) we've got the nth key.
          return;
        }

        // Otherwise, ask the cursor to skip ahead n records
        advanced = true;
        cursor.advance(n);
      };
      req.onerror = function keyOnError() {
        console.error('Error in asyncStorage.key(): ', req.error.name);
      };
    }, function onComplete() {
      var cursor = req.result;
      callback(cursor ? cursor.key : null);
    });
  }

  return {
    getItem: getItem,
    setItem: setItem,
    removeItem: removeItem,
    clear: clear,
    length: length,
    key: key
  };
}());


define("asyncStorage", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.asyncStorage;
    };
}(this)));



/**
 * format.js: simple formatters and string utilities.
 */

var Format = {

  /**
   * Pads a string to the number of characters specified.
   * @param {String} input value to add padding to.
   * @param {Integer} len length to pad to.
   * @param {String} padWith char to pad with (defaults to " ").
   */
  padLeft: function(input, len, padWith) {
    padWith = padWith || ' ';

    var pad = len - (input + '').length;
    while (--pad > -1) {
      input = padWith + input;
    }
    return input;
  }
};

define("format", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.Format;
    };
}(this)));

define('lib/dcf',['require','exports','module','asyncStorage','debug','format'],function(require, exports, module) {


// This handles the logic pertaining to the naming of files according
// to the Design rule for Camera File System
// * http://en.wikipedia.org/wiki/Design_rule_for_Camera_File_system

/**
 * Dependencies
 */

var asyncStorage = require('asyncStorage');
var debug = require('debug')('dcf');
var format = require('format');

/**
 * Locals
 */

var dcfConfigLoaded = false;
var deferredArgs = null;
var defaultSeq = {file: 1, dir: 100};
var dcfConfig = {
  key: 'dcf_key',
  seq: null,
  postFix: 'MZLLA',
  prefix: {video: 'VID_', image: 'IMG_'},
  ext: {video: '3gp', image: 'jpg'}
};

exports.init = function() {
  debug('initializing');
  asyncStorage.getItem(dcfConfig.key, function(value) {
    dcfConfigLoaded = true;
    dcfConfig.seq = value ? value : defaultSeq;

    // We have a previous call to createDCFFilename that is waiting for
    // a response, fire it again
    if (deferredArgs) {
      var args = deferredArgs;
      exports.createDCFFilename(args.storage, args.type, args.callback);
      deferredArgs = null;
    }

    debug('initialized');
  });
};

exports.createDCFFilename = function(storage, type, callback) {

  // We havent loaded the current counters from indexedDB yet, defer
  // the call
  if (!dcfConfigLoaded) {
    deferredArgs = {storage: storage, type: type, callback: callback};
    return;
  }

  var dir = 'DCIM/' + dcfConfig.seq.dir + dcfConfig.postFix + '/';
  var filename = dcfConfig.prefix[type] +
    format.padLeft(dcfConfig.seq.file, 4, '0') + '.' +
    dcfConfig.ext[type];
  var filepath = dir + filename;

  // A file with this name may have been written by the user or
  // our indexeddb sequence tracker was cleared, check we wont overwrite
  // anything
  var req = storage.get(filepath);

  // A file existed, we bump the directory then try to generate a
  // new filename
  req.onsuccess = function() {
    dcfConfig.seq.file = 1;
    dcfConfig.seq.dir += 1;
    asyncStorage.setItem(dcfConfig.key, dcfConfig.seq, function() {
      exports.createDCFFilename(storage, type, callback);
    });
  };

  // No file existed, we are good to go
  req.onerror = function() {
    if (dcfConfig.seq.file < 9999) {
      dcfConfig.seq.file += 1;
    } else {
      dcfConfig.seq.file = 1;
      dcfConfig.seq.dir += 1;
    }
    asyncStorage.setItem(dcfConfig.key, dcfConfig.seq, function() {
      callback(filepath, filename, dir);
    });
  };
};

});

define('lib/storage',['require','exports','module','debug','vendor/evt','lib/dcf'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('storage');
var events = require('vendor/evt');
var dcf = require('lib/dcf');

/**
 * Locals
 */

var createFilename = dcf.createDCFFilename;

/**
 * Expose `Storage`
 */

module.exports = Storage;

// Mixin event emitter
events(Storage.prototype);

function Storage() {
  this.maxFileSize = 0;
  this.check = this.check.bind(this);
  this.onStorageChange = this.onStorageChange.bind(this);
  this.video = navigator.getDeviceStorage('videos');
  this.image = navigator.getDeviceStorage('pictures');
  this.image.addEventListener('change', this.onStorageChange);
  this.createVideoFilepath = this.createVideoFilepath.bind(this);
  dcf.init();
  debug('initialized');
}

/**
 * Save the image Blob to DeviceStorage then lookup the File reference and
 * return that in the callback as well as the resulting paths.  You always
 * want to forget about the Blob you told us about and use the File instead
 * since otherwise you are wasting precious memory.
 *
 * @param {Object} [options]
 * @param {String} options.filepath
 *   The path to save the image to.
 */
Storage.prototype.addImage = function(blob, options, done) {
  if (typeof options === 'function') {
    done = options;
    options = {};
  }

  done = done || function() {};
  var filepath = options && options.filepath;
  var self = this;
  debug('add image', filepath);

  // Create a filepath if
  // one hasn't been given.
  if (!filepath) {
    debug('creating filename');
    createFilename(this.image, 'image', onCreated);
  } else {
    onCreated(filepath);
  }

  function onCreated(filepath) {
    var req = self.image.addNamed(blob, filepath);
    req.onerror = function() { self.emit('error'); };
    req.onsuccess = function(e) {
      debug('image stored', filepath);
      var absolutePath = e.target.result;
      // addNamed does not give us a File handle so we need to get() it again.
      refetchImage(filepath, absolutePath);
    };
  }

  function refetchImage(filepath, absolutePath) {
    var req = self.image.get(filepath);
    req.onerror = function() { self.emit('error'); };
    req.onsuccess = function(e) {
      debug('image file blob handle retrieved');
      var fileBlob = e.target.result;
      done(filepath, absolutePath, fileBlob);
    };
  }
};

/**
 * Create a new video filepath.
 *
 * The CameraControl API will not
 * automatically create directories
 * for the new file if they do not
 * exist.
 *
 * So we write a dummy file to the
 * same directory via DeviceStorage
 * to ensure that the directory exists
 * before attempting to record to this
 * filepath.
 *
 * @param  {Function} done
 * @public
 */
Storage.prototype.createVideoFilepath = function(done) {
  var videoStorage = this.video;
  createFilename(this.video, 'video', function(filepath) {
    var dummyFilepath = getDir(filepath) + 'tmp.3gp';
    var blob = new Blob([''], { type: 'video/3gpp' });
    var req = videoStorage.addNamed(blob, dummyFilepath);
    req.onsuccess = function(e) {
      videoStorage.delete(e.target.result);
      done(filepath);
    };
  });
};

function getDir(filepath) {
  var index = filepath.lastIndexOf('/') + 1;
  return index ? filepath.substring(0, index) : '';
}

Storage.prototype.onStorageChange = function(e) {
  debug('state change: %s', e.reason);
  var value = e.reason;

  // Emit an `itemdeleted` event to
  // allow parts of the UI to update.
  if (value === 'deleted') {
    var filepath = this.checkFilepath(e.path);
    this.emit('itemdeleted', { path: filepath });
  } else {
    this.setState(value);
  }

  // Check storage
  // has spare capacity
  this.check();
};

Storage.prototype.checkFilepath = function(filepath) {
  var startString = filepath.indexOf('DCIM/');

  if (startString < -1) { return; }
  else if (startString > 0) {
    filepath = filepath.substr(startString);
  }

  // Check whether filepath is a video poster image or not. If filepath
  // contains 'VID' and ends with '.jpg', consider it a video poster
  // image and get the video filepath by changing '.jpg' to '.3gp'
  if (filepath.indexOf('VID') != -1 &&
      filepath.lastIndexOf('.jpg') === filepath.length - 4) {
    filepath = filepath.replace('.jpg', '.3gp');
  }
  return filepath;

};

Storage.prototype.setState = function(value) {
  this.state = value;
  debug('set state: %s', value);
  this.emit('statechange', value);
};

Storage.prototype.setMaxFileSize = function(maxFileSize) {
  this.maxFileSize = maxFileSize;
  this.check();
  debug('max file size set: %d', maxFileSize);
};

Storage.prototype.check = function(done) {
  debug('check');

  var self = this;
  done = done || function() {};

  this.getState(function(result) {
    self.setState(result);

    if (!self.available()) {
      onComplete('unhealthy');
      return;
    }

    self.isSpace(function(result) {
      if (!result) { self.setState('nospace'); }
      onComplete('healthy');
    });
  });

  function onComplete(state) {
    self.emit('checked');
    self.emit('checked:' + state);
  }
};

Storage.prototype.isSpace = function(done) {
  var maxFileSize = this.maxFileSize;
  this.image
    .freeSpace()
    .onsuccess = function(e) {
      var freeSpace = e.target.result;
      var result = freeSpace > maxFileSize;
      debug('is space: %s', result, freeSpace, maxFileSize);
      done(result);
    };
};

Storage.prototype.getState = function(done) {
  this.image
    .available()
    .onsuccess = function(e) {
      done(e.target.result);
    };
};

Storage.prototype.available = function() {
  return this.state === 'available';
};

Storage.prototype.deleteImage = function(filepath) {
  var pictureStorage = this.image;
  pictureStorage.delete(filepath).onerror = function(e) {
    console.warn('Failed to delete', filepath,
                 'from DeviceStorage:', e.target.error);
  };
};

Storage.prototype.deleteVideo = function(filepath) {
  var videoStorage = this.video;
  var pictureStorage = this.image;
  var poster = filepath.replace('.3gp', '.jpg');

  videoStorage.delete(filepath).onerror = function(e) {
    console.warn('Failed to delete', filepath,
                 'from DeviceStorage:', e.target.error);
  };

  // If this is a video file, delete its poster image as well
  pictureStorage.delete(poster).onerror = function(e) {
    console.warn('Failed to delete poster image', poster,
                 'for video', filepath, 'from DeviceStorage:',
                 e.target.error);
  };
};

});

define('lib/pinch',['require','exports','module','lib/bind','lib/bind','lib/bind-all','vendor/evt'],function(require, exports, module) {


/**
 * Dependencies
 */

var bind = require('lib/bind');
var unbind = require('lib/bind').unbind;
var bindAll = require('lib/bind-all');
var events = require('vendor/evt');

/**
 * Mixin event emitter
 */

events(Pinch.prototype);

/**
 * Exports
 */

module.exports = Pinch;

/**
 * Initialize a new `Pinch` interface.
 *
 * @constructor
 */
function Pinch(el) {
  bindAll(this);
  this.attach(el);
}

Pinch.prototype.attach = function(el) {
  this.el = el;

  bind(this.el, 'touchstart', this.onTouchStart);
  bind(window, 'touchmove', this.onTouchMove);
  bind(window, 'touchend', this.onTouchEnd);
};

Pinch.prototype.detach = function() {
  unbind(this.el, 'touchstart', this.onTouchStart);
  unbind(window, 'touchmove', this.onTouchMove);
  unbind(window, 'touchend', this.onTouchEnd);

  this.el = null;
};

Pinch.prototype.enable = function() {
  this.disabled = false;
};

Pinch.prototype.disable = function() {
  this.disabled = true;
};

Pinch.prototype.onTouchStart = function(evt) {
  if (evt.touches.length !== 2 || this.disabled) {
    return;
  }

  this.lastTouchA = evt.touches[0];
  this.lastTouchB = evt.touches[1];
  this.isPinching = true;
  this.emit('pinchstarted');
};

Pinch.prototype.onTouchMove = function(evt) {
  if (!this.isPinching || this.disabled) {
    return;
  }

  var touchA = getNewTouchA(this, evt.touches);
  var touchB = getNewTouchB(this, evt.touches);
  var deltaPinch = getDeltaPinch(this, touchA, touchB);

  this.emit('pinchchanged', deltaPinch);

  this.lastTouchA = touchA;
  this.lastTouchB = touchB;
};

Pinch.prototype.onTouchEnd = function(evt) {
  if (!this.isPinching || this.disabled) {
    return;
  }

  if (evt.touches.length < 2) {
    this.isPinching = false;
    this.emit('pinchended');
  }
};

function getNewTouchA(pinch, touches) {
  if (!pinch.lastTouchA) {
    return null;
  }

  for (var i = 0, length = touches.length, touch; i < length; i++) {
    touch = touches[i];
    if (touch.identifier === pinch.lastTouchA.identifier) {
      return touch;
    }
  }
  return null;
}

function getNewTouchB(pinch, touches) {
  if (!pinch.lastTouchB) {
    return null;
  }

  for (var i = 0, length = touches.length, touch; i < length; i++) {
    touch = touches[i];
    if (touch.identifier === pinch.lastTouchB.identifier) {
      return touch;
    }
  }
  return null;
}

function getDeltaPinch(pinch, touchA, touchB) {
  var lastTouchA = pinch.lastTouchA;
  var lastTouchB = pinch.lastTouchB;
  if (!touchA || !lastTouchA || !touchB || !lastTouchB) {
    return 0;
  }

  var oldDistance = Math.sqrt(
    Math.pow(lastTouchB.pageX - lastTouchA.pageX, 2) +
    Math.pow(lastTouchB.pageY - lastTouchA.pageY, 2));
  var newDistance = Math.sqrt(
    Math.pow(touchB.pageX - touchA.pageX, 2) +
    Math.pow(touchB.pageY - touchA.pageY, 2));
  return newDistance - oldDistance;
}

});

define('controllers/hud',['require','exports','module','debug','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:hud');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new HudController(app); };
module.exports.HudController = HudController;

/**
 * Initialize a new `HudController`
 *
 * @param {AppController} app
 * @constructor
 *
 */
function HudController(app) {
  bindAll(this);
  this.app = app;
  this.hud = app.views.hud;
  this.settings = app.settings;
  this.l10n = app.l10n || navigator.mozL10n;
  this.notification = app.views.notification;
  this.configure();
  this.bindEvents();
  debug('initialized');
}

/**
 * Initially configure state.
 *
 * @private
 */
HudController.prototype.configure = function() {
  var hasDualCamera = this.settings.cameras.get('options').length > 1;
  this.hud.enable('camera', hasDualCamera);
};

/**
 * Bind callbacks to events.
 *
 * @return {HudController} for chaining
 * @private
 */
HudController.prototype.bindEvents = function() {
  this.app.settings.flashModes.on('change:selected', this.updateFlash);
  this.app.settings.mode.on('change:selected', this.updateFlash);
  this.app.on('settings:configured', this.updateFlash);

  // View
  this.hud.on('click:settings', this.app.firer('settings:toggle'));
  this.hud.on('click:camera', this.onCameraClick);
  this.hud.on('click:flash', this.onFlashClick);

  // Camera
  this.app.on('camera:ready', this.hud.setter('camera', 'ready'));
  this.app.on('camera:busy', this.hud.setter('camera', 'busy'));
  this.app.on('change:recording', this.hud.setter('recording'));

  // Timer
  this.app.on('timer:cleared', this.hud.setter('timer', 'inactive'));
  this.app.on('timer:started', this.hud.setter('timer', 'active'));
  this.app.on('timer:ended', this.hud.setter('timer', 'inactive'));
};

HudController.prototype.onModeChange = function() {
  this.clearNotifications();
  this.updateFlash();
};

HudController.prototype.onCameraClick = function() {
  this.clearNotifications();
  this.app.settings.cameras.next();
};

HudController.prototype.clearNotifications = function() {
  this.notification.clear(this.flashNotification);
};

/**
 * Cycle to the next available flash
 * option, update the HUD view and
 * show a change notification.
 *
 * @private
 */
HudController.prototype.onFlashClick = function() {
  var setting = this.settings.flashModes;
  var ishdrOn = this.settings.hdr.selected('key') === 'on';

  setting.next();
  this.hud.set('flashMode' , setting.selected('key'));
  this.notify(setting, ishdrOn);
};

/**
 * Display a notifcation showing the
 * current state of the given setting.
 *
 * @param  {Setting} setting
 * @private
 */
HudController.prototype.notify = function(setting, hdrDeactivated) {
  var optionTitle = this.l10n.get(setting.selected('title'));
  var title = this.l10n.get(setting.get('title'));
  var html;

  // Check if the `hdr` setting is going to be deactivated as part
  // of the change in the `flashMode` setting and display a specialized
  // notification if that is the case
  if (hdrDeactivated) {
    html = title + ' ' + optionTitle + '<br/>' +
      this.l10n.get('hdr-deactivated');
  } else {
    html = title + '<br/>' + optionTitle;
  }

  this.flashNotification = this.notification.display({ text: html });
};

HudController.prototype.updateFlash = function() {
  var selected = this.settings.flashModes.selected();
  var supported = this.settings.flashModes.supported();

  this.hud.enable('flash', supported);
  this.hud.setFlashMode(selected);

  debug('updated flash enabled: %, mode: %s', supported, selected);
};

});

;(function() {


/**
 * Namespace to store
 * references under on root
 */

var ns = '_attach';

/**
 * Normalize `matchesSelector`
 */

var proto = Element.prototype;
var matches = proto.matchesSelector ||
  proto.webkitMatchesSelector ||
  proto.mozMatchesSelector ||
  proto.msMatchesSelector ||
  proto.oMatchesSelector;

/**
 * Bind an event listener
 * to the given element.
 *
 * Example:
 *
 *   attach(myEl, 'click', '.my-class', function(event, el) {
 *     // Do stuff
 *   });
 *
 * @param  {Element}  root
 * @param  {String}   type
 * @param  {String}   selector (optional)
 * @param  {Function} fn
 * @param  {Object}   ctx (optional)
 */
function attach(root, type, selector, fn, ctx) {
  if (arguments.length === 1) {
    return attach.many.apply(null, arguments);
  }

  // `selector` is optional
  if (typeof selector === 'function') {
    ctx = fn;
    fn = selector;
    selector = null;
  }

  // We use the key 'null' to
  // indicate that we are binding
  // an event handler to the root.
  selector = selector || 'null';

  var store = getStore(root);
  var master = store.master[type];
  var delegates = store.delegates[type] = (store.delegates[type] || {});

  // Add the function to the delegates
  delegates[selector] = fn;

  // Only one master event listener
  // is needed per event type.
  if (master) { return; }

  // Add the master callbak to the
  // root node and to the store.
  master = store.master[type] = callback;
  root.addEventListener(type, master);

  /**
   * The master callback passed
   * to `addEventListener`.
   *
   * @param  {Event}   event
   */
  function callback(e) {
    var el = e.target;
    var selector;
    var matched;
    var out;
    var fn;

    // Walk up the DOM tree
    // until we hit the root
    while (el) {

      // Loop over each selector
      // bound to this e type.
      for (selector in delegates) {
        fn = delegates[selector];

        // There are two types of match. A
        // 'null' selector at the root node,
        // or a selector match on the current el.
        matched = (el === root && selector === 'null') ||
          matches.call(el, selector);

        if (matched) {
          out = fn.call(ctx || el, e, el);

          // Stop propagation if the
          // user returns false from the
          // callback. Ideally we would
          // use .stopPropagation, but I
          // don't know of any way to detect
          // if this has been called.
          if (out === false) { return e.stopPropagation(); }
        }
      }

      // Don't go any higher
      // than the root element.
      if (el == root) break;

      // Move on up!
      el = el.parentNode;
    }
  }
}

attach.on = attach;

/**
 * Unbind an event attach
 * from the given root element.
 *
 * If no selector if given, all
 * callbacks for the given event
 * type are removed.
 *
 * Example:
 *
 *   // Remove one
 *   attach.off(myEl, 'click', '.my-class');
 *
 *   // Remove all
 *   attach.off(myEl, 'click');
 *
 * @param  {Element} root
 * @param  {String} type (optional)
 * @param  {String} selector (optional)
 */
attach.off = function(root, type, selector) {
  var store = getStore(root);
  var master = store.master[type];
  var delegates = store.delegates[type];

  // Remove just one
  if (type && selector) {
    delete delegates[selector];
  }

  // Remove all of type
  else if (type) {
    delete store.delegates[type];
  }

  // Remove all
  else {
    for (type in store.master) {
      attach.off(root, type);
    }
  }

  // If there aren't any callbacks
  // of this type left, remove the master.
  if (isEmpty(store.delegates[type])) {
    root.removeEventListener(type, master);
    delete store.master[type];
  }
};

/**
 * Handles Backbone style
 * shorthand event binding.
 *
 * Example:
 *
 *   attach(myElement, {
 *     'click .foo': onFooClick,
 *     'click .bar': onBarClick
 *   });
 *
 * @param  {element} root
 * @param  {Object} config
 * @param  {Object} ctx
 */
attach.many = function(root, config, ctx) {
  var parts;
  var key;

  for (key in config) {
    parts = key.split(' ');
    attach.on(
      root,
      parts[0],
      parts[1],
      config[key],
      ctx);
  }
};

/**
 * Gets the reference store
 * attached to the given node.
 *
 * If one is not found, we
 * create a fresh one.
 *
 * @param  {Element} el
 * @return {Object}
 */
function getStore(el) {
  return el[ns] || createStore(el);
}

/**
 * Creates a fresh reference
 * store on the given element.
 *
 * @param  {Element} el
 * @return {Object}
 */
function createStore(el) {
  el[ns] = { master: {}, delegates: {} };
  return el[ns];
}

/**
 * Checks if the given
 * element has no keys.
 *
 * @param  {Object}  ob
 * @return {Boolean}
 */
function isEmpty(ob) {
  for (var key in ob) { return false; }
  return true;
}

/**
 * Expose 'attach' (UMD)
 */

if (typeof exports === "object") {
  module.exports = attach;
} else if (typeof define === "function" && define.amd) {
  define('vendor/attach',[],function(){ return attach; });
} else {
  window.attach = attach;
}

})();
define('views/controls',['require','exports','module','debug','vendor/attach','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:controls');
var attach = require('vendor/attach');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'controls',
  className: 'test-controls',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.thumbnail = this.find('.js-thumbnail');

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    attach.on(this.el, 'click', '.js-btn', this.onButtonClick);
    attach.on(this.el, 'click', '.js-switch', this.onButtonClick);
    return this;
  },

  onButtonClick: function(e, el) {
    var name = el.getAttribute('name');
    e.stopPropagation();
    this.emit('click:' + name, e);
  },

  template: function() {
    /*jshint maxlen:false*/
    return '<div class="controls-left">' +
      '<div class="controls-button controls-thumbnail-button test-thumbnail js-thumbnail js-btn rotates" name="thumbnail"></div>' +
      '<div class="controls-button controls-cancel-pick-button test-cancel-pick icon-pick-cancel js-btn rotates" name="cancel"></div>' +
    '</div>' +
    '<div class="controls-middle">' +
      '<div class="capture-button test-capture js-btn rotates" name="capture">' +
        '<div class="circle outer-circle"></div>' +
        '<div class="circle inner-circle"></div>' +
        '<div class="center icon"></div>' +
      '</div>' +
    '</div>' +
    '<div class="controls-right">' +
      '<div class="mode-switch test-switch js-switch" name="switch">' +
        '<div class="mode-icon icon rotates"></div>' +
        '<div class="selected-mode">' +
          '<div class="selected-mode-icon icon rotates"></div>' +
        '</div>' +
      '</div>' +
    '</div>';
  },

  setThumbnail: function(blob) {
    if (!this.els.image) {
      this.els.image = new Image();
      this.els.thumbnail.appendChild(this.els.image);
      this.set('thumbnail', true);
    } else {
      window.URL.revokeObjectURL(this.els.image.src);
    }

    this.els.image.src = window.URL.createObjectURL(blob);
  },

  removeThumbnail: function() {
    if (this.els.image) {
      this.els.thumbnail.removeChild(this.els.image);
      window.URL.revokeObjectURL(this.els.image.src);
      this.els.image = null;
    }

    this.set('thumbnail', false);
  },

  /**
   * NOTE: The below functions are a first
   * attempt at replacing the default View
   * `.set()`, `.enable()` and `.disable()` APIs
   * to avoid having to use attributes to style
   * state in our CSS.
   */

  set: function(key, value) {
    if (typeof key !== 'string') { return; }
    if (arguments.length === 1) { value = true; }
    if (!value) { return this.unset(key); }

    var attr = 'data-' + key;
    var oldValue = this.el.getAttribute(attr);
    var oldClass = oldValue && classFrom(key, oldValue);
    var newClass = classFrom(key, value);

    if (oldClass) { this.el.classList.remove(oldClass); }
    if (newClass) { this.el.classList.add(newClass); }

    this.el.setAttribute(attr, value);
    debug('remove: %s, add: %s', oldClass, newClass);
    debug('attr key: %s, value: %s', attr, value);
  },

  unset: function(key) {
    var attr = 'data-' + key;
    var value = this.el.getAttribute(attr);
    this.el.classList.remove(classFrom(key, value));
    this.el.removeAttribute(attr);
  },

  enable: function(key) {
    this.set(key ? key + '-enabled' : 'enabled');
    this.unset(key ? key + '-disabled' : 'disabled');
  },

  disable: function(key) {
    this.set(key ? key + '-disabled' : 'disabled');
    this.unset(key ? key + '-enabled' : 'enabled');
  }
});

/**
 * Examples:
 *
 *   classFrom('recording', true); //=> 'recording'
 *   classFrom('flash', 'on'); //=> 'flash-on'
 *   classFrom('recording', false); //=> ''
 *   classFrom('recording'); //=> 'recording'
 *   classFrom('recording', 'true'); //=> 'recording'
 *   classFrom('recording', 'false'); //=> ''
 *
 * @param  {String} key
 * @param  {*} value
 * @return {String}
 */
function classFrom(key, value) {
  value = detectBooleans(value);
  if (typeof value === 'boolean') {
    return value ? key : '';
  } else if (value) {
    return key + '-' + value ;
  } else {
    return key;
  }
}

function detectBooleans(value) {
  if (typeof value === 'boolean') { return value; }
  else if (value === 'true') { return true; }
  else if (value === 'false') { return false; }
  else { return value; }
}

});

define('controllers/controls',['require','exports','module','debug','views/controls','lib/bind-all'],function(require, exports, module) {


/**
 * TODO: Controllers should create views
 */

/**
 * Dependencies
 */

var debug = require('debug')('controller:controls');
var ControlsView = require('views/controls');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new ControlsController(app); };
module.exports.ControlsController = ControlsController;

/**
 * Initialize a new `ControlsController`
 *
 * @param {App} app
 */
function ControlsController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.activity = app.activity;
  this.view = app.views.controls || new ControlsView();
  this.app.views.controls = this.view;
  this.bindEvents();
  this.configure();
  debug('initialized');
}

/**
 * Event bindings.
 *
 * @private
 */
ControlsController.prototype.bindEvents = function() {
  this.app.settings.mode.on('change:selected', this.view.setter('mode'));

  // App
  this.app.on('change:recording', this.onRecordingChange);
  this.app.on('camera:shutter', this.captureHighlightOff);
  this.app.on('camera:busy', this.view.disable);
  this.app.on('timer:started', this.onTimerStarted);
  this.app.on('newthumbnail', this.onNewThumbnail);
  this.app.on('timer:cleared', this.restore);
  this.app.on('camera:ready', this.restore);

  // View
  this.view.on('click:thumbnail', this.app.firer('preview'));
  this.view.on('click:switch', this.onSwitchButtonClick);
  this.view.on('click:cancel', this.onCancelButtonClick);
  this.view.on('click:capture', this.onCaptureClick);

  debug('events bound');
};

/**
 * Initial configuration.
 *
 * @private
 */
ControlsController.prototype.configure = function() {
  var initialMode = this.app.settings.mode.selected('key');
  var isCancellable = !!this.app.activity.active;

  // The gallery button should not
  // be shown if an activity is pending
  // or the application is in 'secure mode'.
  this.view.set('cancel', isCancellable);
  this.view.set('mode', initialMode);

  // Disable view until camera
  // 'ready' enables it.
  this.view.set('faded');
  this.view.disable();

  this.configureMode();

  // Put it in the DOM
  this.view.appendTo(this.app.el);

  debug('cancelable: %s', isCancellable);
  debug('mode: %s', initialMode);
};

ControlsController.prototype.configureMode = function() {
  var isSwitchable = this.app.settings.mode.get('options').length > 1;
  this.view.set('switchable', isSwitchable);
};

/**
 * Keep capture button pressed and
 * fire the `capture` event to allow
 * the camera to repond.
 *
 * When the 'camera:shutter' event fires
 * we remove the capture butter pressed
 * state so that it times with the
 * capture sound effect.
 *
 * @private
 */
ControlsController.prototype.onCaptureClick = function() {
  this.captureHighlightOn();
  this.app.emit('capture');
};

/**
 * Set the recording attribute on
 * the view to allow it to style
 * accordingly.
 *
 * @param  {Boolean} recording
 * @private
 */
ControlsController.prototype.onRecordingChange = function(recording) {
  this.view.set('recording', recording);
  if (!recording) { this.onRecordingEnd(); }
};

/**
 * Remove the capture highlight,
 * once recording has finished.
 *
 * @private
 */
ControlsController.prototype.onRecordingEnd = function() {
  this.captureHighlightOff();
};

/**
 * When the thumbnail changes, update it in the view.
 * This method is triggered by the 'newthumbnail' event.
 * That event is emitted by the preview gallery controller when the a new
 * photo or video is added, or when the preview is closed and the first
 * photo or video has changed (because of a file deletion).
 */
ControlsController.prototype.onNewThumbnail = function(thumbnailBlob) {
  if (thumbnailBlob) {
    this.view.setThumbnail(thumbnailBlob);
  } else {
    this.view.removeThumbnail();
  }
};

/**
 * Forces the capture button to
 * look pressed while the timer is
 * counting down and disables buttons.
 *
 * @private
 */
ControlsController.prototype.onTimerStarted = function() {
  this.captureHighlightOn();
  this.view.disable();
};

/**
 * Restores the capture button to its
 * unpressed state and re-enables buttons.
 *
 * @private
 */
ControlsController.prototype.restore = function() {
  this.captureHighlightOff();
  this.view.unset('faded');
  this.view.enable();
};

/**
 * Make the capture button
 * appear pressed.
 *
 * @private
 */
ControlsController.prototype.captureHighlightOn = function() {
  this.view.set('capture-active');
};

/**
 * Remove the pressed apperance
 * from the capture button.
 *
 * @private
 */
ControlsController.prototype.captureHighlightOff = function() {
  this.view.unset('capture-active');
};

/**
 * Switch to the next capture
 * mode: 'picture' or 'video'.
 *
 * @private
 */
ControlsController.prototype.onSwitchButtonClick = function() {
  this.view.disable();
  this.app.settings.mode.next();
};

/**
 * Cancel the current activity
 * when the cancel button is
 * pressed.
 *
 * This means the device will
 * navigate back to the app
 * that initiated the activity.
 *
 * @private
 */
ControlsController.prototype.onCancelButtonClick = function() {
  this.activity.cancel();
};

/**
 * Open the gallery app when the
 * gallery button is pressed.
 *
 * @private
 */
ControlsController.prototype.onGalleryButtonClick = function(event) {
  event.stopPropagation();
  var MozActivity = window.MozActivity;

  // Can't launch the gallery if the lockscreen is locked.
  // The button shouldn't even be visible in this case, but
  // let's be really sure here.
  if (this.app.inSecureMode) { return; }

  // Launch the gallery with an activity
  this.mozActivity = new MozActivity({
    name: 'browse',
    data: { type: 'photos' }
  });

  // Wait 2000ms before re-enabling the
  // Gallery to be launched (Bug 957709)
  this.view.disable();
  setTimeout(this.view.enable, 2000);
};

});

define('controllers/viewfinder',['require','exports','module','debug','lib/bind-all','config/camera'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:viewfinder');
var bindAll = require('lib/bind-all');
var constants = require('config/camera');

/**
 * Exports
 */

module.exports = function(app) { return new ViewfinderController(app); };
module.exports.ViewfinderController = ViewfinderController;

/**
 * Initialize a new `ViewfinderController`
 *
 * @param {App} app
 */
function ViewfinderController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.camera = app.camera;
  this.activity = app.activity;
  this.settings = app.settings;
  this.viewfinder = app.views.viewfinder;
  this.focusRing = app.views.focusRing;
  this.pinch = new app.Pinch(app.el);
  this.bindEvents();
  this.configure();
  debug('initialized');
}

/**
 * Initial configuration.
 *
 * @private
 */
ViewfinderController.prototype.configure = function() {
  this.sensitivity = constants.ZOOM_GESTURE_SENSITIVITY * window.innerWidth;

  this.configureScaleType();
  this.configureGrid();
};

/**
 * Configure the viewfinder scale type,
 * aspect fill/fit, depending on setting.
 *
 * @private
 */
ViewfinderController.prototype.configureScaleType = function() {
  var scaleType = this.app.settings.viewfinder.get('scaleType');
  this.viewfinder.scaleType = scaleType;
  debug('set scale type: %s', scaleType);
};

/**
 * Show/hide grid depending on currently
 * selected option.
 *
 * @private
 */
ViewfinderController.prototype.configureGrid = function() {
  var grid = this.app.settings.grid.selected('key');
  this.viewfinder.set('grid', grid);
};

/**
 * Hides the viewfinder frame-grid.
 *
 * @private
 */
ViewfinderController.prototype.hideGrid = function() {
  this.viewfinder.set('grid', 'off');
};

/**
 * Bind to relavant events.
 *
 * @private
 */
ViewfinderController.prototype.bindEvents = function() {
  this.app.settings.grid.on('change:selected', this.viewfinder.setter('grid'));
  this.viewfinder.on('click', this.app.firer('viewfinder:click'));
  this.camera.on('zoomchanged', this.onZoomChanged);
  this.camera.on('zoomconfigured', this.onZoomConfigured);
  this.app.on('camera:focuschanged', this.focusRing.setState);
  this.app.on('camera:configured', this.onCameraConfigured);
  this.app.on('camera:shutter', this.onShutter);
  this.app.on('camera:previewactive', this.onPreviewActive);
  this.app.on('previewgallery:opened', this.onGalleryOpened);
  this.app.on('previewgallery:closed', this.onGalleryClosed);
  this.app.on('settings:closed', this.onSettingsClosed);
  this.app.on('settings:opened', this.onSettingsOpened);
  this.pinch.on('pinchchanged', this.onPinchChanged);
};

/**
 * Perform required viewfinder configuration
 * once the camera has configured.
 *
 * @private
 */
ViewfinderController.prototype.onCameraConfigured = function() {
  var self = this;
  this.loadStream();
  this.configurePreview();

  // BUG: We have to use a 300ms timeout here
  // to conceal a Gecko rendering bug whereby the
  // video element appears not to have painted the
  // newly set dimensions before fading in.
  // https://bugzilla.mozilla.org/show_bug.cgi?id=982230
  setTimeout(function() {
    self.viewfinder.fadeIn(self.app.firer('viewfinder:visible'));
  }, 300);
};

ViewfinderController.prototype.onShutter = function() {
  this.focusRing.setState('none');
  this.viewfinder.shutter();
};

/**
 * Start the viewfinder stream flowing
 * with the current camera configuration.
 *
 * This indirectly enforces a screen wakelock,
 * meaning the device is unable to go to sleep.
 *
 * We don't want the stream to start flowing if
 * the preview-gallery is open, as this prevents
 * the device falling asleep.
 *
 * @private
 */
ViewfinderController.prototype.loadStream = function() {
  this.camera.loadStreamInto(this.viewfinder.els.video);
  debug('stream started');
};

/**
 * Stop the preview stream flowing.
 *
 * This indirectly removes the wakelock
 * that is magically enforced by the
 * flowing camera stream. Meaning the
 * device is able to go to sleep.
 *
 * @private
 */
ViewfinderController.prototype.stopStream = function() {
  this.viewfinder.stopStream();
  debug('stream stopped');
};

/**
 * Configure the size and postion
 * of the preview video stream.
 *
 * @private
 */
ViewfinderController.prototype.configurePreview = function() {
  var camera = this.app.settings.cameras.selected('key');
  var isFrontCamera = camera === 'front';
  var sensorAngle = this.camera.getSensorAngle();
  var previewSize = this.camera.previewSize();

  this.viewfinder.updatePreview(previewSize, sensorAngle, isFrontCamera);
};

/**
 * Configures the viewfinder
 * to the current camera.
 *
 * @private
 */
ViewfinderController.prototype.onZoomConfigured = function() {
  var zoomSupported = this.camera.isZoomSupported();
  var zoomEnabled = this.app.settings.zoom.enabled();
  var enableZoom = zoomSupported && zoomEnabled;

  if (!enableZoom) {
    this.viewfinder.disableZoom();
    return;
  }

  if (this.app.settings.zoom.get('useZoomPreviewAdjustment')) {
    this.viewfinder.enableZoomPreviewAdjustment();
  } else {
    this.viewfinder.disableZoomPreviewAdjustment();
  }

  var minimumZoom = this.camera.getMinimumZoom();
  var maximumZoom = this.camera.getMaximumZoom();

  this.viewfinder.enableZoom(minimumZoom, maximumZoom);
};

/**
 * Updates the zoom level on the camera
 * when the pinch changes.
 *
 * @private
 */
ViewfinderController.prototype.onPinchChanged = function(deltaPinch) {
  var zoom = this.viewfinder._zoom * (1 + (deltaPinch / this.sensitivity));
  this.viewfinder.setZoom(zoom);
  this.camera.setZoom(zoom);
};

/**
 * Responds to changes of the `zoom` value on the Camera to update the
 * view's internal state so that the pinch-to-zoom gesture can resume
 * zooming from the updated value. Also, updates the CSS scale transform
 * on the <video/> tag to compensate for zooming beyond the
 * `maxHardwareZoom` value.
 *
 * @param {Number} zoom
 */
ViewfinderController.prototype.onZoomChanged = function(zoom) {
  var zoomPreviewAdjustment = this.camera.getZoomPreviewAdjustment();
  this.viewfinder.setZoomPreviewAdjustment(zoomPreviewAdjustment);
  this.viewfinder.setZoom(zoom);
};

ViewfinderController.prototype.onSettingsOpened = function() {
  this.hideGrid();
  this.pinch.disable();
};

ViewfinderController.prototype.onSettingsClosed = function() {
  this.configureGrid();
  this.pinch.enable();
};

ViewfinderController.prototype.onGalleryOpened = function() {
  // Disables events when the gallery opens
  this.viewfinder.disable();
  this.pinch.disable();
};

ViewfinderController.prototype.onGalleryClosed = function() {
  if (this.app.hidden) {
    return;
  }

  // Renables events when the gallery closes
  this.viewfinder.enable();
  this.pinch.enable();
};

ViewfinderController.prototype.onPreviewActive = function(active) {
  if (!active) {
    this.stopStream();
  }
};

});

define('lib/format-timer',['require','exports','module','format'],function(require, exports, module) {


var format = require('format');

/**
 * Dependencies
 */

function digits(value) {
  return format.padLeft(value, 2, '0');
}

/**
 * Exports
 */

module.exports = function(ms) {
  var totalSeconds = ms / 1000;
  var seconds = Math.round(totalSeconds % 60);
  var minutes = Math.floor(totalSeconds / 60);
  var hours;

  if (minutes < 60) {
    return digits(minutes) + ':' + digits(seconds);
  } else {
    hours = Math.floor(minutes / 60);
    minutes = Math.round(minutes % 60);
    return hours + ':' + digits(minutes) + ':' + digits(seconds);
  }

  return '';
};

});

define('views/recording-timer',['require','exports','module','debug','lib/format-timer','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:recording-timer');
var formatTimer = require('lib/format-timer');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'recording-timer',

  initialize: function() {
    this.value(0);
  },

  value: function(value) {
    this.el.textContent = formatTimer(value);
    debug('set value: %s', value);
  }
});

});

define('controllers/recording-timer',['require','exports','module','debug','views/recording-timer'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:recording-timer');
var RecordingTimerView = require('views/recording-timer');

/**
 * Exports
 */

module.exports = function(app) { return new RecordingTimerController(app); };
module.exports.RecordingTimerController = RecordingTimerController;

/**
 * Initialize a new `RecordingTimerController`
 *
 * Allow `this.view` to be mocked for testing
 *
 * @param {App} app
 */
function RecordingTimerController(app) {
  debug('initializing');
  this.onRecordingChange = this.onRecordingChange.bind(this);
  this.view = app.view || new RecordingTimerView();
  this.app = app;
  this.setup();
  this.bindEvents();
  debug('initialized');
}

/**
 * Inject the view into the app.
 *
 * @private
 */
RecordingTimerController.prototype.setup = function() {
  this.view.appendTo(this.app.el);
};

/**
 * Listen to relevant events.
 *
 * Toggle the visibility when
 * recording starts/stops.
 *
 * Update the time value when camera
 * recording time updates.
 *
 * @private
 */
RecordingTimerController.prototype.bindEvents = function() {
  this.app.on('change:recording', this.onRecordingChange);
  this.app.on('camera:recorderTimeUpdate', this.view.value);
  debug('events bound');
};

/**
 * Show the view when recording,
 * hide it when not.
 *
 * @param  {Boolean} recording
 * @private
 */
RecordingTimerController.prototype.onRecordingChange = function(recording) {
  debug('recording: %s', recording);
  if (!recording) {
    this.view.hide();
    return;
  }

  this.view.value(0);
  this.view.show();
};

});

/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- /
/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */



/**
 * GestureDetector.js: generate events for one and two finger gestures.
 *
 * A GestureDetector object listens for touch and mouse events on a specified
 * element and generates higher-level events that describe one and two finger
 * gestures on the element. The hope is that this will be useful for webapps
 * that need to run on mouse (or trackpad)-based desktop browsers and also in
 * touch-based mobile devices.
 *
 * Supported events:
 *
 *  tap        like a click event
 *  dbltap     like dblclick
 *  pan        one finger motion, or mousedown followed by mousemove
 *  swipe      when a finger is released following pan events
 *  holdstart  touch (or mousedown) and hold. Must set an option to get these.
 *  holdmove   motion after a holdstart event
 *  holdend    when the finger or mouse goes up after holdstart/holdmove
 *  transform  2-finger pinch and twist gestures for scaling and rotation
 *             These are touch-only; they can't be simulated with a mouse.
 *
 * Each of these events is a bubbling CustomEvent with important details in the
 * event.detail field. The event details are not yet stable and are not yet
 * documented. See the calls to emitEvent() for details.
 *
 * To use this library, create a GestureDetector object by passing an element to
 * the GestureDetector() constructor and then calling startDetecting() on it.
 * The element will be the target of all the emitted gesture events. You can
 * also pass an optional object as the second constructor argument. If you're
 * interested in holdstart/holdmove/holdend events, pass {holdEvents:true} as
 * this second argument. Otherwise they will not be generated.
 * If you want to customize the pan threshold, pass
 * {panThreshold:X, mousePanThreshold:Y} (X and Y in pixels) in the options
 * argument.
 *
 * Implementation note: event processing is done with a simple finite-state
 * machine. This means that in general, the various kinds of gestures are
 * mutually exclusive. You won't get pan events until your finger or mouse has
 * moved more than a minimum threshold, for example, but it does, the FSM enters
 * a new state in which it can emit pan and swipe events and cannot emit hold
 * events. Similarly, if you've started a 1 finger pan/swipe gesture and
 * accidentally touch with a second finger, you'll continue to get pan events,
 * and won't suddenly start getting 2-finger transform events.
 *
 * This library never calls preventDefault() or stopPropagation on any of the
 * events it processes, so the raw touch or mouse events should still be
 * available for other code to process. It is not clear to me whether this is a
 * feature or a bug.
 */

var GestureDetector = (function() {

  //
  // Constructor
  //
  function GD(e, options) {
    this.element = e;
    this.options = options || {};
    this.options.panThreshold = this.options.panThreshold || GD.PAN_THRESHOLD;
    this.options.mousePanThreshold =
      this.options.mousePanThreshold || GD.MOUSE_PAN_THRESHOLD;
    this.state = initialState;
    this.timers = {};
    this.listeningForMouseEvents = true;
  }

  //
  // Public methods
  //

  GD.prototype.startDetecting = function() {
    var self = this;
    eventtypes.forEach(function(t) {
      self.element.addEventListener(t, self);
    });
  };

  GD.prototype.stopDetecting = function() {
    var self = this;
    eventtypes.forEach(function(t) {
      self.element.removeEventListener(t, self);
    });
  };

  //
  // Internal methods
  //

  GD.prototype.handleEvent = function(e) {
    var handler = this.state[e.type];
    if (!handler) return;

    // If this is a touch event handle each changed touch separately
    if (e.changedTouches) {
      // If we ever receive a touch event, then we know we are on a
      // touch device and we stop listening for mouse events. If we
      // don't do that, then the touchstart touchend mousedown mouseup
      // generated by a single tap gesture will cause us to output
      // tap tap dbltap, which is wrong
      if (this.listeningForMouseEvents) {
        this.listeningForMouseEvents = false;
        this.element.removeEventListener('mousedown', this);
      }

      // XXX https://bugzilla.mozilla.org/show_bug.cgi?id=785554
      // causes touchend events to list all touches as changed, so
      // warn if we see that bug
      if (e.type === 'touchend' && e.changedTouches.length > 1) {
        console.warn('gesture_detector.js: spurious extra changed touch on ' +
                     'touchend. See ' +
                     'https://bugzilla.mozilla.org/show_bug.cgi?id=785554');
      }

      for (var i = 0; i < e.changedTouches.length; i++) {
        handler(this, e, e.changedTouches[i]);
        // The first changed touch might have changed the state of the
        // FSM. We need this line to workaround the bug 785554, but it is
        // probably the right thing to have here, even once that bug is fixed.
        handler = this.state[e.type];
      }
    }
    else {    // Otherwise, just dispatch the event to the handler
      handler(this, e);
    }
  };

  GD.prototype.startTimer = function(type, time) {
    this.clearTimer(type);
    var self = this;
    this.timers[type] = setTimeout(function() {
      self.timers[type] = null;
      var handler = self.state[type];
      if (handler)
        handler(self, type);
    }, time);
  };

  GD.prototype.clearTimer = function(type) {
    if (this.timers[type]) {
      clearTimeout(this.timers[type]);
      this.timers[type] = null;
    }
  };

  // Switch to a new FSM state, and call the init() function of that
  // state, if it has one.  The event and touch arguments are optional
  // and are just passed through to the state init function.
  GD.prototype.switchTo = function(state, event, touch) {
    this.state = state;
    if (state.init)
      state.init(this, event, touch);
  };

  GD.prototype.emitEvent = function(type, detail) {
    if (!this.target) {
      console.error('Attempt to emit event with no target');
      return;
    }

    var event = this.element.ownerDocument.createEvent('CustomEvent');
    event.initCustomEvent(type, true, true, detail);
    this.target.dispatchEvent(event);
  };

  //
  // Tuneable parameters
  //
  GD.HOLD_INTERVAL = 1000;     // Hold events after 1000 ms
  GD.PAN_THRESHOLD = 20;       // 20 pixels movement before touch panning
  GD.MOUSE_PAN_THRESHOLD = 15; // Mice are more precise, so smaller threshold
  GD.DOUBLE_TAP_DISTANCE = 50;
  GD.DOUBLE_TAP_TIME = 500;
  GD.VELOCITY_SMOOTHING = .5;

  // Don't start sending transform events until the gesture exceeds a threshold
  GD.SCALE_THRESHOLD = 20;     // pixels
  GD.ROTATE_THRESHOLD = 22.5;  // degrees

  // For pans and zooms, we compute new starting coordinates that are part way
  // between the initial event and the event that crossed the threshold so that
  // the first event we send doesn't cause a big lurch. This constant must be
  // between 0 and 1 and says how far along the line between the initial value
  // and the new value we pick
  GD.THRESHOLD_SMOOTHING = 0.9;

  //
  // Helpful shortcuts and utility functions
  //

  var abs = Math.abs, floor = Math.floor, sqrt = Math.sqrt, atan2 = Math.atan2;
  var PI = Math.PI;

  // The names of events that we need to register handlers for
  var eventtypes = [
    'touchstart',
    'touchmove',
    'touchend',
    'mousedown'  // We register mousemove and mouseup manually
  ];

  // Return the event's timestamp in ms
  function eventTime(e) {
    // In gecko, synthetic events seem to be in microseconds rather than ms.
    // So if the timestamp is much larger than the current time, assue it is
    // in microseconds and divide by 1000
    var ts = e.timeStamp;
    if (ts > 2 * Date.now())
      return Math.floor(ts / 1000);
    else
      return ts;
  }


  // Return an object containg the space and time coordinates of
  // and event and touch. We freeze the object to make it immutable so
  // we can pass it in events and not worry about values being changed.
  function coordinates(e, t) {
    return Object.freeze({
      screenX: t.screenX,
      screenY: t.screenY,
      clientX: t.clientX,
      clientY: t.clientY,
      timeStamp: eventTime(e)
    });
  }

  // Like coordinates(), but return the midpoint between two touches
  function midpoints(e, t1, t2) {
    return Object.freeze({
      screenX: floor((t1.screenX + t2.screenX) / 2),
      screenY: floor((t1.screenY + t2.screenY) / 2),
      clientX: floor((t1.clientX + t2.clientX) / 2),
      clientY: floor((t1.clientY + t2.clientY) / 2),
      timeStamp: eventTime(e)
    });
  }

  // Like coordinates(), but for a mouse event
  function mouseCoordinates(e) {
    return Object.freeze({
      screenX: e.screenX,
      screenY: e.screenY,
      clientX: e.clientX,
      clientY: e.clientY,
      timeStamp: eventTime(e)
    });
  }

  // Given coordinates objects c1 and c2, return a new coordinates object
  // representing a point and time along the line between those points.
  // The position of the point is controlled by the THRESHOLD_SMOOTHING constant
  function between(c1, c2) {
    var r = GD.THRESHOLD_SMOOTHING;
    return Object.freeze({
      screenX: floor(c1.screenX + r * (c2.screenX - c1.screenX)),
      screenY: floor(c1.screenY + r * (c2.screenY - c1.screenY)),
      clientX: floor(c1.clientX + r * (c2.clientX - c1.clientX)),
      clientY: floor(c1.clientY + r * (c2.clientY - c1.clientY)),
      timeStamp: floor(c1.timeStamp + r * (c2.timeStamp - c1.timeStamp))
    });
  }

  // Compute the distance between two touches
  function touchDistance(t1, t2) {
    var dx = t2.screenX - t1.screenX;
    var dy = t2.screenY - t1.screenY;
    return sqrt(dx * dx + dy * dy);
  }

  // Compute the direction (as an angle) of the line between two touches
  // Returns a number d, -180 < d <= 180
  function touchDirection(t1, t2) {
    return atan2(t2.screenY - t1.screenY,
                 t2.screenX - t1.screenX) * 180 / PI;
  }

  // Compute the clockwise angle between direction d1 and direction d2.
  // Returns an angle a -180 < a <= 180.
  function touchRotation(d1, d2) {
    var angle = d2 - d1;
    if (angle > 180)
      angle -= 360;
    else if (angle <= -180)
      angle += 360;
    return angle;
  }

  // Determine if two taps are close enough in time and space to
  // trigger a dbltap event. The arguments are objects returned
  // by the coordinates() function.
  function isDoubleTap(lastTap, thisTap) {
    var dx = abs(thisTap.screenX - lastTap.screenX);
    var dy = abs(thisTap.screenY - lastTap.screenY);
    var dt = thisTap.timeStamp - lastTap.timeStamp;
    return (dx < GD.DOUBLE_TAP_DISTANCE &&
            dy < GD.DOUBLE_TAP_DISTANCE &&
            dt < GD.DOUBLE_TAP_TIME);
  }

  //
  // The following objects are the states of our Finite State Machine
  //

  // In this state we're not processing any gestures, just waiting
  // for an event to start a gesture and ignoring others
  var initialState = {
    name: 'initialState',
    init: function(d) {
      // When we enter or return to the initial state, clear
      // the detector properties that were tracking gestures
      // Don't clear d.lastTap here, though. We need it for dbltap events
      d.target = null;
      d.start = d.last = null;
      d.touch1 = d.touch2 = null;
      d.vx = d.vy = null;
      d.startDistance = d.lastDistance = null;
      d.startDirection = d.lastDirection = null;
      d.lastMidpoint = null;
      d.scaled = d.rotated = null;
    },

    // Switch to the touchstarted state and process the touch event there
    // Once we've started processing a touch gesture we'll ignore mouse events
    touchstart: function(d, e, t) {
      d.switchTo(touchStartedState, e, t);
    },

    // Or if we see a mouse event first, then start processing a mouse-based
    // gesture, and ignore any touch events
    mousedown: function(d, e) {
      d.switchTo(mouseDownState, e);
    }
  };

  // One finger is down but we haven't generated any event yet. We're
  // waiting to see...  If the finger goes up soon, its a tap. If the finger
  // stays down and still, its a hold. If the finger moves its a pan/swipe.
  // And if a second finger goes down, its a transform
  var touchStartedState = {
    name: 'touchStartedState',
    init: function(d, e, t) {
      // Remember the target of the event
      d.target = e.target;
      // Remember the id of the touch that started
      d.touch1 = t.identifier;
      // Get the coordinates of the touch
      d.start = d.last = coordinates(e, t);
      // Start a timer for a hold
      // If we're doing hold events, start a timer for them
      if (d.options.holdEvents)
        d.startTimer('holdtimeout', GD.HOLD_INTERVAL);
    },

    touchstart: function(d, e, t) {
      // If another finger goes down in this state, then
      // go to transform state to start 2-finger gestures.
      d.clearTimer('holdtimeout');
      d.switchTo(transformState, e, t);
    },
    touchmove: function(d, e, t) {
      // Ignore any touches but the initial one
      // This could happen if there was still a finger down after
      // the end of a previous 2-finger gesture, e.g.
      if (t.identifier !== d.touch1)
        return;

      if (abs(t.screenX - d.start.screenX) > d.options.panThreshold ||
          abs(t.screenY - d.start.screenY) > d.options.panThreshold) {
        d.clearTimer('holdtimeout');
        d.switchTo(panStartedState, e, t);
      }
    },
    touchend: function(d, e, t) {
      // Ignore any touches but the initial one
      if (t.identifier !== d.touch1)
        return;

      // If there was a previous tap that was close enough in time
      // and space, then emit a 'dbltap' event
      if (d.lastTap && isDoubleTap(d.lastTap, d.start)) {
        d.emitEvent('tap', d.start);
        d.emitEvent('dbltap', d.start);
        // clear the lastTap property, so we don't get another one
        d.lastTap = null;
      }
      else {
        // Emit a 'tap' event using the starting coordinates
        // as the event details
        d.emitEvent('tap', d.start);

        // Remember the coordinates of this tap so we can detect double taps
        d.lastTap = coordinates(e, t);
      }

      // In either case clear the timer and go back to the initial state
      d.clearTimer('holdtimeout');
      d.switchTo(initialState);
    },

    holdtimeout: function(d) {
      d.switchTo(holdState);
    }

  };

  // A single touch has moved enough to exceed the pan threshold and now
  // we're going to generate pan events after each move and a swipe event
  // when the touch ends. We ignore any other touches that occur while this
  // pan/swipe gesture is in progress.
  var panStartedState = {
    name: 'panStartedState',
    init: function(d, e, t) {
      // Panning doesn't start until the touch has moved more than a
      // certain threshold. But we don't want the pan to have a jerky
      // start where the first event is a big distance. So proceed as
      // pan actually started at a point along the path between the
      // first touch and this current touch.
      d.start = d.last = between(d.start, coordinates(e, t));

      // If we transition into this state with a touchmove event,
      // then process it with that handler. If we don't do this then
      // we can end up with swipe events that don't know their velocity
      if (e.type === 'touchmove')
        panStartedState.touchmove(d, e, t);
    },

    touchmove: function(d, e, t) {
      // Ignore any fingers other than the one we're tracking
      if (t.identifier !== d.touch1)
        return;

      // Each time the touch moves, emit a pan event but stay in this state
      var current = coordinates(e, t);
      d.emitEvent('pan', {
        absolute: {
          dx: current.screenX - d.start.screenX,
          dy: current.screenY - d.start.screenY
        },
        relative: {
          dx: current.screenX - d.last.screenX,
          dy: current.screenY - d.last.screenY
        },
        position: current
      });

      // Track the pan velocity so we can report this with the swipe
      // Use a exponential moving average for a bit of smoothing
      // on the velocity
      var dt = current.timeStamp - d.last.timeStamp;
      var vx = (current.screenX - d.last.screenX) / dt;
      var vy = (current.screenY - d.last.screenY) / dt;

      if (d.vx == null) { // first time; no average
        d.vx = vx;
        d.vy = vy;
      }
      else {
        d.vx = d.vx * GD.VELOCITY_SMOOTHING +
          vx * (1 - GD.VELOCITY_SMOOTHING);
        d.vy = d.vy * GD.VELOCITY_SMOOTHING +
          vy * (1 - GD.VELOCITY_SMOOTHING);
      }

      d.last = current;
    },
    touchend: function(d, e, t) {
      // Ignore any fingers other than the one we're tracking
      if (t.identifier !== d.touch1)
        return;

      // Emit a swipe event when the finger goes up.
      // Report start and end point, dx, dy, dt, velocity and direction
      var current = coordinates(e, t);
      var dx = current.screenX - d.start.screenX;
      var dy = current.screenY - d.start.screenY;
      // angle is a positive number of degrees, starting at 0 on the
      // positive x axis and increasing clockwise.
      var angle = atan2(dy, dx) * 180 / PI;
      if (angle < 0)
        angle += 360;

      // Direction is 'right', 'down', 'left' or 'up'
      var direction;
      if (angle >= 315 || angle < 45)
        direction = 'right';
      else if (angle >= 45 && angle < 135)
        direction = 'down';
      else if (angle >= 135 && angle < 225)
        direction = 'left';
      else if (angle >= 225 && angle < 315)
        direction = 'up';

      d.emitEvent('swipe', {
        start: d.start,
        end: current,
        dx: dx,
        dy: dy,
        dt: e.timeStamp - d.start.timeStamp,
        vx: d.vx,
        vy: d.vy,
        direction: direction,
        angle: angle
      });

      // Go back to the initial state
      d.switchTo(initialState);
    }
  };

  // We enter this state if the user touches and holds for long enough
  // without moving much.  When we enter we emit a holdstart event. Motion
  // after the holdstart generates holdmove events. And when the touch ends
  // we generate a holdend event. holdmove and holdend events can be used
  // kind of like drag and drop events in a mouse-based UI. Currently,
  // these events just report the coordinates of the touch.  Do we need
  // other details?
  var holdState = {
    name: 'holdState',
    init: function(d) {
      d.emitEvent('holdstart', d.start);
    },

    touchmove: function(d, e, t) {
      var current = coordinates(e, t);
      d.emitEvent('holdmove', {
        absolute: {
          dx: current.screenX - d.start.screenX,
          dy: current.screenY - d.start.screenY
        },
        relative: {
          dx: current.screenX - d.last.screenX,
          dy: current.screenY - d.last.screenY
        },
        position: current
      });

      d.last = current;
    },

    touchend: function(d, e, t) {
      var current = coordinates(e, t);
      d.emitEvent('holdend', {
        start: d.start,
        end: current,
        dx: current.screenX - d.start.screenX,
        dy: current.screenY - d.start.screenY
      });
      d.switchTo(initialState);
    }
  };

  // We enter this state if a second touch starts before we start
  // recoginzing any other gesture.  As the touches move we track the
  // distance and angle between them to report scale and rotation values
  // in transform events.
  var transformState = {
    name: 'transformState',
    init: function(d, e, t) {
      // Remember the id of the second touch
      d.touch2 = t.identifier;

      // Get the two Touch objects
      var t1 = e.touches.identifiedTouch(d.touch1);
      var t2 = e.touches.identifiedTouch(d.touch2);

      // Compute and remember the initial distance and angle
      d.startDistance = d.lastDistance = touchDistance(t1, t2);
      d.startDirection = d.lastDirection = touchDirection(t1, t2);

      // Don't start emitting events until we're past a threshold
      d.scaled = d.rotated = false;
    },

    touchmove: function(d, e, t) {
      // Ignore touches we're not tracking
      if (t.identifier !== d.touch1 && t.identifier !== d.touch2)
        return;

      // Get the two Touch objects
      var t1 = e.touches.identifiedTouch(d.touch1);
      var t2 = e.touches.identifiedTouch(d.touch2);

      // Compute the new midpoints, distance and direction
      var midpoint = midpoints(e, t1, t2);
      var distance = touchDistance(t1, t2);
      var direction = touchDirection(t1, t2);
      var rotation = touchRotation(d.startDirection, direction);

      // Check all of these numbers against the thresholds. Otherwise
      // the transforms are too jittery even when you try to hold your
      // fingers still.
      if (!d.scaled) {
        if (abs(distance - d.startDistance) > GD.SCALE_THRESHOLD) {
          d.scaled = true;
          d.startDistance = d.lastDistance =
            floor(d.startDistance +
                  GD.THRESHOLD_SMOOTHING * (distance - d.startDistance));
        }
        else
          distance = d.startDistance;
      }
      if (!d.rotated) {
        if (abs(rotation) > GD.ROTATE_THRESHOLD)
          d.rotated = true;
        else
          direction = d.startDirection;
      }

      // If nothing has exceeded the threshold yet, then we
      // don't even have to fire an event.
      if (d.scaled || d.rotated) {
        // The detail field for the transform gesture event includes
        // 'absolute' transformations against the initial values and
        // 'relative' transformations against the values from the last
        // transformgesture event.
        d.emitEvent('transform', {
          absolute: { // transform details since gesture start
            scale: distance / d.startDistance,
            rotate: touchRotation(d.startDirection, direction)
          },
          relative: { // transform since last gesture change
            scale: distance / d.lastDistance,
            rotate: touchRotation(d.lastDirection, direction)
          },
          midpoint: midpoint
        });

        d.lastDistance = distance;
        d.lastDirection = direction;
        d.lastMidpoint = midpoint;
      }
    },

    touchend: function(d, e, t) {
      // If either finger goes up, we're done with the gesture.
      // The user might move that finger and put it right back down
      // again to begin another 2-finger gesture, so we can't go
      // back to the initial state while one of the fingers remains up.
      // On the other hand, we can't go back to touchStartedState because
      // that would mean that the finger left down could cause a tap or
      // pan event. So we need an afterTransform state that waits for
      // a finger to come back down or the other finger to go up.
      if (t.identifier === d.touch2)
        d.touch2 = null;
      else if (t.identifier === d.touch1) {
        d.touch1 = d.touch2;
        d.touch2 = null;
      }
      else
        return; // It was a touch we weren't tracking

      // If we emitted any transform events, now we need to emit
      // a transformend event to end the series.  The details of this
      // event use the values from the last touchmove, and the
      // relative amounts will 1 and 0, but they are included for
      // completeness even though they are not useful.
      if (d.scaled || d.rotated) {
        d.emitEvent('transformend', {
          absolute: { // transform details since gesture start
            scale: d.lastDistance / d.startDistance,
            rotate: touchRotation(d.startDirection, d.lastDirection)
          },
          relative: { // nothing has changed relative to the last touchmove
            scale: 1,
            rotate: 0
          },
          midpoint: d.lastMidpoint
        });
      }

      d.switchTo(afterTransformState);
    }
  };

  // We did a tranform and one finger went up. Wait for that finger to
  // come back down or the other finger to go up too.
  var afterTransformState = {
    name: 'afterTransformState',
    touchstart: function(d, e, t) {
      d.switchTo(transformState, e, t);
    },

    touchend: function(d, e, t) {
      if (t.identifier === d.touch1)
        d.switchTo(initialState);
    }
  };

  var mouseDownState = {
    name: 'mouseDownState',
    init: function(d, e) {
      // Remember the target of the event
      d.target = e.target;

      // Register this detector as a *capturing* handler on the document
      // so we get all subsequent mouse events until we remove these handlers
      var doc = d.element.ownerDocument;
      doc.addEventListener('mousemove', d, true);
      doc.addEventListener('mouseup', d, true);

      // Get the coordinates of the mouse event
      d.start = d.last = mouseCoordinates(e);

      // Start a timer for a hold
      // If we're doing hold events, start a timer for them
      if (d.options.holdEvents)
        d.startTimer('holdtimeout', GD.HOLD_INTERVAL);
    },

    mousemove: function(d, e) {
      // If the mouse has moved more than the panning threshold,
      // then switch to the mouse panning state. Otherwise remain
      // in this state

      if (abs(e.screenX - d.start.screenX) > d.options.mousePanThreshold ||
          abs(e.screenY - d.start.screenY) > d.options.mousePanThreshold) {
        d.clearTimer('holdtimeout');
        d.switchTo(mousePannedState, e);
      }
    },

    mouseup: function(d, e) {
      // Remove the capturing event handlers
      var doc = d.element.ownerDocument;
      doc.removeEventListener('mousemove', d, true);
      doc.removeEventListener('mouseup', d, true);

      // If there was a previous tap that was close enough in time
      // and space, then emit a 'dbltap' event
      if (d.lastTap && isDoubleTap(d.lastTap, d.start)) {
        d.emitEvent('tap', d.start);
        d.emitEvent('dbltap', d.start);
        d.lastTap = null; // so we don't get another one
      }
      else {
        // Emit a 'tap' event using the starting coordinates
        // as the event details
        d.emitEvent('tap', d.start);

        // Remember the coordinates of this tap so we can detect double taps
        d.lastTap = mouseCoordinates(e);
      }

      // In either case clear the timer and go back to the initial state
      d.clearTimer('holdtimeout');
      d.switchTo(initialState);
    },

    holdtimeout: function(d) {
      d.switchTo(mouseHoldState);
    }
  };

  // Like holdState, but for mouse events instead of touch events
  var mouseHoldState = {
    name: 'mouseHoldState',
    init: function(d) {
      d.emitEvent('holdstart', d.start);
    },

    mousemove: function(d, e) {
      var current = mouseCoordinates(e);
      d.emitEvent('holdmove', {
        absolute: {
          dx: current.screenX - d.start.screenX,
          dy: current.screenY - d.start.screenY
        },
        relative: {
          dx: current.screenX - d.last.screenX,
          dy: current.screenY - d.last.screenY
        },
        position: current
      });

      d.last = current;
    },

    mouseup: function(d, e) {
      var current = mouseCoordinates(e);
      d.emitEvent('holdend', {
        start: d.start,
        end: current,
        dx: current.screenX - d.start.screenX,
        dy: current.screenY - d.start.screenY
      });
      d.switchTo(initialState);
    }
  };

  var mousePannedState = {
    name: 'mousePannedState',
    init: function(d, e) {
      // Panning doesn't start until the mouse has moved more than
      // a certain threshold. But we don't want the pan to have a jerky
      // start where the first event is a big distance. So reset the
      // starting point to a point between the start point and this
      // current point
      d.start = d.last = between(d.start, mouseCoordinates(e));

      // If we transition into this state with a mousemove event,
      // then process it with that handler. If we don't do this then
      // we can end up with swipe events that don't know their velocity
      if (e.type === 'mousemove')
        mousePannedState.mousemove(d, e);
    },
    mousemove: function(d, e) {
      // Each time the mouse moves, emit a pan event but stay in this state
      var current = mouseCoordinates(e);
      d.emitEvent('pan', {
        absolute: {
          dx: current.screenX - d.start.screenX,
          dy: current.screenY - d.start.screenY
        },
        relative: {
          dx: current.screenX - d.last.screenX,
          dy: current.screenY - d.last.screenY
        },
        position: current
      });

      // Track the pan velocity so we can report this with the swipe
      // Use a exponential moving average for a bit of smoothing
      // on the velocity
      var dt = current.timeStamp - d.last.timeStamp;
      var vx = (current.screenX - d.last.screenX) / dt;
      var vy = (current.screenY - d.last.screenY) / dt;

      if (d.vx == null) { // first time; no average
        d.vx = vx;
        d.vy = vy;
      }
      else {
        d.vx = d.vx * GD.VELOCITY_SMOOTHING +
          vx * (1 - GD.VELOCITY_SMOOTHING);
        d.vy = d.vy * GD.VELOCITY_SMOOTHING +
          vy * (1 - GD.VELOCITY_SMOOTHING);
      }

      d.last = current;
    },
    mouseup: function(d, e) {
      // Remove the capturing event handlers
      var doc = d.element.ownerDocument;
      doc.removeEventListener('mousemove', d, true);
      doc.removeEventListener('mouseup', d, true);

      // Emit a swipe event when the mouse goes up.
      // Report start and end point, dx, dy, dt, velocity and direction
      var current = mouseCoordinates(e);

      // FIXME:
      // lots of code duplicated between this state and the corresponding
      // touch state, can I combine them somehow?
      var dx = current.screenX - d.start.screenX;
      var dy = current.screenY - d.start.screenY;
      // angle is a positive number of degrees, starting at 0 on the
      // positive x axis and increasing clockwise.
      var angle = atan2(dy, dx) * 180 / PI;
      if (angle < 0)
        angle += 360;

      // Direction is 'right', 'down', 'left' or 'up'
      var direction;
      if (angle >= 315 || angle < 45)
        direction = 'right';
      else if (angle >= 45 && angle < 135)
        direction = 'down';
      else if (angle >= 135 && angle < 225)
        direction = 'left';
      else if (angle >= 225 && angle < 315)
        direction = 'up';

      d.emitEvent('swipe', {
        start: d.start,
        end: current,
        dx: dx,
        dy: dy,
        dt: current.timeStamp - d.start.timeStamp,
        vx: d.vx,
        vy: d.vy,
        direction: direction,
        angle: angle
      });

      // Go back to the initial state
      d.switchTo(initialState);
    }
  };

  return GD;
}());


define("GestureDetector", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.GestureDetector;
    };
}(this)));

define('lib/panzoom',['require','exports','module','GestureDetector'],function(require, exports, module) {


/**
 * Dependencies
 */

var GestureDetector = require('GestureDetector');

/**
 * Exports
 */

module.exports = addPanAndZoomHandlers;

/*
 * This module adds pan-and-zoom capability to images displayed by
 * shared/js/media/media_frame.js.
 * It is used by preview-gallery.js and confirm.js
 */
function addPanAndZoomHandlers(frame, swipeCallback) {
  // frame is the MediaFrame object. container is its DOM element.
  var container = frame.container;

  // Generate gesture events for the container
  var gestureDetector = new GestureDetector(container);
  gestureDetector.startDetecting();

  // When the user touches the screen and moves their finger left or
  // right, they might want to pan within a zoomed-in image, or they
  // might want to swipe between multiple items in the camera preview
  // gallery. We pass the amount of motion to the MediaFrame pan() method,
  // and it returns the amount that cannot be used to pan the displayed
  // item. We track this returned amount as how far left or right the
  // image has been swiped, and pass the number to the swipeCallback.
  var swipeAmount = 0;

  // And handle them with these listeners
  container.addEventListener('dbltap', handleDoubleTap);
  container.addEventListener('transform', handleTransform);
  container.addEventListener('pan', handlePan);
  if (swipeCallback) {
    container.addEventListener('swipe', handleSwipe);
  }

  function handleDoubleTap(e) {
    var scale;
    if (frame.fit.scale > frame.fit.baseScale) {
      scale = frame.fit.baseScale / frame.fit.scale;
    }
    else {
      scale = 2;
    }

    frame.zoom(scale, e.detail.clientX, e.detail.clientY, 200);
  }

  function handleTransform(e) {
    frame.zoom(e.detail.relative.scale,
               e.detail.midpoint.clientX, e.detail.midpoint.clientY);
  }

  function handlePan(e) {
    var dx = e.detail.relative.dx;
    var dy = e.detail.relative.dy;

    if (swipeCallback) {
      dx += swipeAmount;
      swipeAmount = frame.pan(dx, dy);
      swipeCallback(swipeAmount);
    } else {
      frame.pan(dx, dy);
    }
  }

  function handleSwipe(e) {
    if (swipeAmount !== 0) {
      swipeCallback(swipeAmount, e.detail.vx);
      swipeAmount = 0;
    }
  }
}

});



//
// Create a <video> element and  <div> containing a video player UI and
// add them to the specified container. The UI requires a GestureDetector
// to be running for the container or one of its ancestors.
//
// Some devices have only a single hardware video decoder and can only
// have one video tag playing anywhere at once. So this class is careful
// to only load content into a <video> element when the user really wants
// to play it. At other times it displays a poster image for the video.
// Initially, it displays the poster image. Pressing play starts the video.
// Pausing pauses the video but does not revert to the poster. Finishing the
// video reverts to the initial state with the poster image displayed.
// If we get a visiblitychange event saying that we've been hidden, we
// remember the playback position, pause the video take a temporary
// screenshot and display it, and unload the video. If shown again
// and if the user clicks play again, we resume the video where we left off.
//
function VideoPlayer(container) {
  if (typeof container === 'string')
    container = document.getElementById(container);

  function newelt(parent, type, classes) {
    var e = document.createElement(type);
    if (classes)
      e.className = classes;
    parent.appendChild(e);
    return e;
  }

  // This copies the controls structure of the Video app
  var poster = newelt(container, 'img', 'videoPoster');
  var player = newelt(container, 'video', 'videoPlayer');
  var controls = newelt(container, 'div', 'videoPlayerControls');
  var playbutton = newelt(controls, 'button', 'videoPlayerPlayButton');
  var footer = newelt(controls, 'div', 'videoPlayerFooter hidden');
  var pausebutton = newelt(footer, 'button', 'videoPlayerPauseButton');
  var slider = newelt(footer, 'div', 'videoPlayerSlider');
  var elapsedText = newelt(slider, 'span', 'videoPlayerElapsedText');
  var progress = newelt(slider, 'div', 'videoPlayerProgress');
  var backgroundBar = newelt(progress, 'div', 'videoPlayerBackgroundBar');
  var elapsedBar = newelt(progress, 'div', 'videoPlayerElapsedBar');
  var playHead = newelt(progress, 'div', 'videoPlayerPlayHead');
  var durationText = newelt(slider, 'span', 'videoPlayerDurationText');
  // expose fullscreen button, so that client can manipulate it directly
  var fullscreenButton = newelt(slider, 'button',
                          'videoPlayerFullscreenButton');

  this.poster = poster;
  this.player = player;
  this.controls = controls;
  this.playing = false;

  player.preload = 'metadata';
  player.mozAudioChannelType = 'content';

  var self = this;
  var controlsHidden = false;
  var dragging = false;
  var pausedBeforeDragging = false;
  var endedTimer;
  var videourl;   // the url of the video to play
  var posterurl;  // the url of the poster image to display
  var rotation;   // Do we have to rotate the video? Set by load()
  var orientation = 0; // current player orientation

  // These are the raw (unrotated) size of the poster image, which
  // must have the same size as the video.
  var videowidth, videoheight;

  var playbackTime;
  var capturedFrame;

  this.load = function(video, posterimage, width, height, rotate) {
    this.reset();
    videourl = video;
    posterurl = posterimage;
    rotation = rotate || 0;
    videowidth = width;
    videoheight = height;
    this.init();
    setPlayerSize();
  };

  this.reset = function() {
    hidePlayer();
    hidePoster();
  };

  this.init = function() {
    playbackTime = 0;
    hidePlayer();
    showPoster();
    this.pause();
  };

  function hidePlayer() {
    player.style.display = 'none';
    player.removeAttribute('src');
    player.load();
    self.playerShowing = false;
  }

  function showPlayer() {
    player.style.display = 'block';
    player.src = videourl;
    self.playerShowing = true;

    // The only place we call showPlayer() is from the play() function.
    // If play() has to show the player, call it again when we're ready to play.
    player.oncanplay = function() {
      player.oncanplay = null;
      if (playbackTime !== 0) {
        player.currentTime = playbackTime;
      }
      self.play();
    };
  }

  function hidePoster() {
    poster.style.display = 'none';
    if (capturedFrame) {
      poster.removeAttribute('src');
      URL.revokeObjectURL(capturedFrame);
      capturedFrame = null;
    }
  }

  function showPoster() {
    poster.style.display = 'block';
    if (capturedFrame)
      poster.src = capturedFrame;
    else
      poster.src = posterurl;
  }

  // Call this when the container size changes
  this.setPlayerSize = setPlayerSize;

  // Call this when phone orientation changes
  this.setPlayerOrientation = setPlayerOrientation;

  this.pause = function pause() {
    // Pause video playback
    if (self.playerShowing) {
      this.playing = false;
      player.pause();
    }

    // Hide the pause button and slider
    footer.classList.add('hidden');
    controlsHidden = true;

    // Show the big central play button
    playbutton.classList.remove('hidden');

    if (this.onpaused)
      this.onpaused();
  };

  // Set up the playing state
  this.play = function play() {
    if (!this.playerShowing) {
      // If we're displaying the poster image, we have to switch
      // to the player first. When the player is ready it wil call this
      // function again.
      hidePoster();
      showPlayer();
      return;
    }

    this.playing = true;

    // Start playing the video
    player.play();

    // Hide the play button
    playbutton.classList.add('hidden');

    // Show the controls
    footer.classList.remove('hidden');
    controlsHidden = false;

    if (this.onplaying)
      this.onplaying();
  };

  fullscreenButton.addEventListener('tap', function(e) {
    if (self.onfullscreentap) {
      // If the event propagate to controller, videoplayer will hide
      // the toolbar, so we stopPropagation here.
      e.stopPropagation();
      self.onfullscreentap();
    }
  });

  // Hook up the play button
  playbutton.addEventListener('tap', function(e) {
    // If we're not showing the player or are paused, go to the play state
    if (!self.playerShowing || player.paused) {
      self.play();
    }
    e.stopPropagation();
  });

  // Hook up the pause button
  pausebutton.addEventListener('tap', function(e) {
    self.pause();
    e.stopPropagation();
  });

  // A click anywhere else on the screen should toggle the footer
  // But only when the video is playing.
  controls.addEventListener('tap', function(e) {
    if (e.target === controls && !player.paused) {
      footer.classList.toggle('hidden');
      controlsHidden = !controlsHidden;
    }
  });

  // Set the video duration when we get metadata
  player.onloadedmetadata = function() {
    durationText.textContent = formatTime(player.duration);
    // start off in the paused state
    self.pause();
  };

  // Also resize the player on a resize event
  // (when the user rotates the phone)
  window.addEventListener('resize', function() {
    setPlayerSize();
  });

  // If we reach the end of a video, reset to beginning
  // This isn't always reliable, so we also set a timer in updateTime()
  player.onended = ended;

  function ended() {
    if (dragging)
      return;
    if (endedTimer) {
      clearTimeout(endedTimer);
      endedTimer = null;
    }
    self.pause();
    self.init();
  };

  // Update the slider and elapsed time as the video plays
  player.ontimeupdate = updateTime;

  // Set the elapsed time and slider position
  function updateTime() {
    if (!controlsHidden) {
      elapsedText.textContent = formatTime(player.currentTime);

      // We can't update a progress bar if we don't know how long
      // the video is. It is kind of a bug that the <video> element
      // can't figure this out for ogv videos.
      if (player.duration === Infinity || player.duration === 0)
        return;

      var percent = (player.currentTime / player.duration) * 100 + '%';
      elapsedBar.style.width = percent;
      playHead.style.left = percent;
    }

    // Since we don't always get reliable 'ended' events, see if
    // we've reached the end this way.
    // See: https://bugzilla.mozilla.org/show_bug.cgi?id=783512
    // If we're within 1 second of the end of the video, register
    // a timeout a half a second after we'd expect an ended event.
    if (!endedTimer) {
      if (!dragging && player.currentTime >= player.duration - 1) {
        var timeUntilEnd = (player.duration - player.currentTime + .5);
        endedTimer = setTimeout(ended, timeUntilEnd * 1000);
      }
    }
    else if (dragging && player.currentTime < player.duration - 1) {
      // If there is a timer set and we drag away from the end, cancel the timer
      clearTimeout(endedTimer);
      endedTimer = null;
    }
  }

  // Pause and unload the video if we're hidden so that other apps
  // can use the video decoder hardware.
  window.addEventListener('visibilitychange', visibilityChanged);

  function visibilityChanged() {
    if (document.hidden) {
      // If we're just showing the poster image when we're hidden
      // then we don't have to do anything special
      if (!self.playerShowing)
        return;

      self.pause();

      // If we're not at the beginning of the video, capture a
      // temporary poster image to display when we come back
      if (player.currentTime !== 0) {
        playbackTime = player.currentTime;
        captureCurrentFrame(function(blob) {
          capturedFrame = URL.createObjectURL(blob);
          hidePlayer();
          showPoster();
        });
      }
      else {
        // Even if we don't capture a frame, hide the video
        hidePlayer();
        showPoster();
      }
    }
  }

  function captureCurrentFrame(callback) {
    var canvas = document.createElement('canvas');
    canvas.width = videowidth;
    canvas.height = videoheight;
    var context = canvas.getContext('2d');
    context.drawImage(player, 0, 0);
    canvas.toBlob(callback);
  }

  // Make the video fit the container
  function setPlayerSize() {
    var containerWidth = container.clientWidth;
    var containerHeight = container.clientHeight;

    // Don't do anything if we don't know our size.
    // This could happen if we get a resize event before our metadata loads
    if (!videowidth || !videoheight)
      return;

    var width, height; // The size the video will appear, after rotation
    switch (rotation) {
    case 0:
    case 180:
      width = videowidth;
      height = videoheight;
      break;
    case 90:
    case 270:
      width = videoheight;
      height = videowidth;
    }

    var xscale = containerWidth / width;
    var yscale = containerHeight / height;
    var scale = Math.min(xscale, yscale);

    // Scale large videos down, and scale small videos up.
    // This might reduce image quality for small videos.
    width *= scale;
    height *= scale;

    var left = ((containerWidth - width) / 2);
    var top = ((containerHeight - height) / 2);

    var transform;
    switch (rotation) {
    case 0:
      transform = 'translate(' + left + 'px,' + top + 'px)';
      break;
    case 90:
      transform =
        'translate(' + (left + width) + 'px,' + top + 'px) ' +
        'rotate(90deg)';
      break;
    case 180:
      transform =
        'translate(' + (left + width) + 'px,' + (top + height) + 'px) ' +
        'rotate(180deg)';
      break;
    case 270:
      transform =
        'translate(' + left + 'px,' + (top + height) + 'px) ' +
        'rotate(270deg)';
      break;
    }

    transform += ' scale(' + scale + ')';

    poster.style.transform = transform;
    player.style.transform = transform;
  }

  // Update current player orientation
  function setPlayerOrientation(newOrientation) {
    orientation = newOrientation;
  }

  // Compute position based on player orientation
  function computePosition(panPosition, rect) {
    var position;
    switch (orientation) {
      case 0:
        position = (panPosition.clientX - rect.left) / rect.width;
        break;
      case 90:
        position = (rect.bottom - panPosition.clientY) / rect.height;
        break;
      case 180:
        position = (rect.right - panPosition.clientX) / rect.width;
        break;
      case 270:
        position = (panPosition.clientY - rect.top) / rect.height;
        break;
    }
    return position;
  }

  // handle drags on the time slider
  slider.addEventListener('pan', function pan(e) {
    e.stopPropagation();
    // We can't do anything if we don't know our duration
    if (player.duration === Infinity)
      return;

    if (!dragging) {  // Do this stuff on the first pan event only
      dragging = true;
      pausedBeforeDragging = player.paused;
      if (!pausedBeforeDragging) {
        player.pause();
      }
    }

    var rect = backgroundBar.getBoundingClientRect();
    var position = computePosition(e.detail.position, rect);
    var pos = Math.min(Math.max(position, 0), 1);
    player.currentTime = player.duration * pos;
    updateTime();
  });

  slider.addEventListener('swipe', function swipe(e) {
    e.stopPropagation();
    dragging = false;
    if (player.currentTime >= player.duration) {
      self.pause();
    } else if (!pausedBeforeDragging) {
      player.play();
    }
  });

  function formatTime(time) {
    time = Math.round(time);
    var minutes = Math.floor(time / 60);
    var seconds = time % 60;
    if (minutes < 60) {
      return Format.padLeft(minutes, 2, '0') + ':' +
        Format.padLeft(seconds, 2, '0');
    } else {
      var hours = Math.floor(minutes / 60);
      minutes = Math.round(minutes % 60);
      return hours + ':' + Format.padLeft(minutes, 2, '0') + ':' +
        Format.padLeft(seconds, 2, '0');
    }
    return '';
  }

  // pause the video player if user unplugs headphone
  var acm = navigator.mozAudioChannelManager;
  if (acm) {
    acm.addEventListener('headphoneschange', function onheadphoneschange() {
      if (!acm.headphones && self.playing) {
        self.pause();
      }
    });
  }
}

VideoPlayer.prototype.hide = function() {
  // Call reset() to hide the poster and player
  this.controls.style.display = 'none';
};

VideoPlayer.prototype.show = function() {
  // Call init() to show the poster
  this.controls.style.display = 'block';
};

define("VideoPlayer", function(){});

/*
 * media_frame.js:
 *
 * A MediaFrame displays a photo or a video. The gallery app uses
 * three side by side to support smooth panning from one item to the
 * next.  The Camera app uses one for image and video preview. The
 * Gallery app's open activity uses one of these to display the opened
 * item.
 *
 * MediaFrames have different behavior depending on whether they display
 * images or videos. Photo frames allow the user to zoom and pan on the photo.
 * Video frames allow the user to play and pause but don't allow zooming.
 *
 * When a frame is displaying a video, it handles mouse events.
 * When display a picture, however, it expects the client to handle events
 * and call the pan() and zoom() methods.
 *
 * The pan() method is a little unusual. It "uses" as much of the pan
 * event as it can, and returns a number indicating how much of the
 * horizontal motion it did not use. The gallery uses this returned
 * value for transitioning between frames.  If a frame displays a
 * photo that is not zoomed in at all, then it can't use any of the
 * pan, and returns the full amount which the gallery app turns into a
 * panning motion between frames.  But if the photo is zoomed in, then
 * the MediaFrame will just move the photo within itself, if it can, and
 * return 0.
 *
 * Much of the code in this file used to be part of the PhotoState class.
 */
function MediaFrame(container, includeVideo, maxImageSize) {
  if (typeof container === 'string')
    container = document.getElementById(container);
  this.container = container;
  this.maximumImageSize = maxImageSize || 0;
  if (includeVideo !== false) {
    this.video = new VideoPlayer(container);
    this.video.hide();
  }
  this.displayingVideo = false;
  this.displayingImage = false;
  this.imageblob = null;
  this.previewblob = null;
  this.videoblob = null;
  this.posterblob = null;
  this.url = null;

  var self = this;
}

MediaFrame.prototype.displayImage = function displayImage(blob,
                                                          width,
                                                          height,
                                                          preview,
                                                          rotation,
                                                          mirrored)
{
  var self = this;
  this.clear();  // Reset everything
  // Remember what we're displaying
  this.imageblob = blob;
  this.preview = preview;

  // Figure out if we are going to downsample the image before displaying it
  this.fullSampleSize = computeFullSampleSize(blob, width, height);
  this.fullsizeWidth = this.fullSampleSize.scale(width);
  this.fullsizeHeight = this.fullSampleSize.scale(height);

  // Note: There is a default value for orientation/mirrored since some
  // images don't have EXIF data to retrieve this information.
  this.rotation = rotation || 0;
  this.mirrored = mirrored || false;

  // Keep track of what kind of content we have
  this.displayingImage = true;

  // Determine whether we can use the preview image
  function usePreview(preview) {
    // If no preview at all, we can't use it.
    if (!preview)
      return false;

    // If we don't know the preview size, we can't use it.
    if (!preview.width || !preview.height)
      return false;

    // If there isn't a preview offset or file, we can't use it
    if (!preview.start && !preview.filename)
      return false;

    // If the aspect ratio does not match, we can't use it
    if (Math.abs(width / height - preview.width / preview.height) > 0.01)
      return false;

    // If setMinimumPreviewSize has been called, then a preview is big
    // enough if it is at least that big.
    if (self.minimumPreviewWidth && self.minimumPreviewHeight) {
      return Math.max(preview.width, preview.height) >=
        Math.max(self.minimumPreviewWidth, self.minimumPreviewHeight) &&
        Math.min(preview.width, preview.height) >=
        Math.min(self.minimumPreviewWidth, self.minimumPreviewHeight);
    }

    // Otherwise a preview is big enough if at least one dimension is >= the
    // screen size in both portait and landscape mode.
    var screenWidth = window.innerWidth * window.devicePixelRatio;
    var screenHeight = window.innerHeight * window.devicePixelRatio;

    return ((preview.width >= screenWidth ||
             preview.height >= screenHeight) && // portrait
            (preview.width >= screenHeight ||
             preview.height >= screenWidth));  // landscape
  }

  // If we have a useable preview image, use it.
  if (usePreview(preview)) {
    if (preview.start) {
      this.previewblob = blob.slice(preview.start, preview.end, 'image/jpeg');
      this.previewSampleSize = Downsample.NONE;
      this._displayImage(this.previewblob, true);
    }
    else {
      var storage = navigator.getDeviceStorage('pictures');
      var getreq = storage.get(preview.filename);
      getreq.onsuccess = function() {
        self.previewblob = getreq.result;
        self.previewSampleSize = Downsample.NONE;
        self._displayImage(self.previewblob, true);
      };
      getreq.onerror = function() {
        self.preview = null;
        self.previewblob = null;
        self.previewSampleSize = computePreviewSampleSize(blob, width, height);
        self._displayImage(blob, self.previewSampleSize !== Downsample.NONE);
      };
    }
  }
  else {
    // In this case we don't have a usable preview image
    this.preview = null;
    this.previewblob = null;

    // If the image is a JPEG, then we can use #-moz-samplesize to downsample
    // while decoding so that we can display a small preview without using
    // lots of memory.
    this.previewSampleSize = computePreviewSampleSize(blob, width, height);
    this._displayImage(blob, this.previewSampleSize !== Downsample.NONE);
  }

  // If the blob is a JPEG then we can use #-moz-samplesize to downsample
  // it while decoding. If this is a particularly large image then to avoid
  // OOMs, we may not want to allow it to ever be decoded at full size
  function computeFullSampleSize(blob, width, height) {
    if (blob.type !== 'image/jpeg') {
      // We're not using #-moz-samplesize at all
      return Downsample.NONE;
    }
    if (!self.maximumImageSize || width * height <= self.maximumImageSize) {
      return Downsample.NONE;
    }

    return Downsample.areaAtLeast(self.maximumImageSize / (width * height));
  }

  function computePreviewSampleSize(blob, width, height) {
    // If the image is not a JPEG we can't use a samplesize
    if (blob.type !== 'image/jpeg') {
      return Downsample.NONE;
    }

    //
    // Determine how much we can scale the image down and still have it
    // big enough to fill the screen in at least one dimension.
    //
    // For example, suppose we have a 1600x1200 photo and a 320x480 screen
    //
    //  portraitScale = Math.min(.2, .4) = 0.2
    //  landscapeScale = Math.min(.3, .266) = 0.266
    //  scale = 0.266
    //
    var screenWidth = window.innerWidth * window.devicePixelRatio;
    var screenHeight = window.innerHeight * window.devicePixelRatio;

    // To display the image in portrait orientation, this is how much we
    // have to scale it down to ensure that both dimensions fit
    var portraitScale = Math.min(screenWidth / width, screenHeight / height);

    // To display the image in landscape, this is we need to scale it
    // this much
    var landscapeScale = Math.min(screenHeight / width, screenWidth / height);

    // We need an image that is big enough in either orientation
    var scale = Math.max(portraitScale, landscapeScale);

    // Return the largest samplesize that still produces a big enough preview
    return Downsample.sizeNoMoreThan(scale);
  }
};

// A utility function we use to display the full-size image or the preview.
MediaFrame.prototype._displayImage = function _displayImage(blob, isPreview) {
  var self = this;

  // Get rid of any existing image and its event handlers
  this._clearImage();

  // And create a fresh new one
  this.image = document.createElement('img');
  this.image.style.transformOrigin = 'center center';
  this.image.style.display = 'none';
  this.container.appendChild(this.image);

  this.displayingPreview = isPreview;

  // Create a URL for the blob (or preview blob)
  if (this.url)
    URL.revokeObjectURL(this.url);
  this.url = URL.createObjectURL(blob);

  this.image.onerror = function(e) {
    console.error('failed to load image', self.image.url, e);
    if (self.onerror)
      self.onerror(e);
  };
  this.image.onload = function(e) {
    self.image.onload = null;

    // Switch height & width for rotated images
    if (self.rotation == 0 || self.rotation == 180) {
      self.itemWidth = self.image.width;
      self.itemHeight = self.image.height;
    } else {
      self.itemWidth = self.image.height;
      self.itemHeight = self.image.width;
    }

    self.computeFit();
    self.setPosition();
    self.image.style.display = 'block';
  };

  this.image.src = this.url +
    (isPreview ? this.previewSampleSize : this.fullSampleSize);
};

MediaFrame.prototype._switchToFullSizeImage = function _switchToFull() {
  if (!this.displayingImage || !this.displayingPreview)
    return;

  var self = this;
  this.displayingPreview = false;

  var oldimage = this.oldimage = this.image;
  var newimage = this.image = document.createElement('img');
  newimage.style.transformOrigin = 'center center';

  // If there is a separate preview blob, then we need a new url now
  if (this.previewblob) {
    URL.revokeObjectURL(this.url);
    this.url = URL.createObjectURL(this.imageblob);
  }

  newimage.src = this.url + this.fullSampleSize;

  // move onerror callback to newimage when oldimage becomes useless.
  newimage.onerror = oldimage.onerror;
  oldimage.onerror = null;

  // Add the new image to the container before the current preview image
  // Because it comes first it will be obscured by the preview
  this.container.insertBefore(newimage, oldimage);

  // Resize the preview image to be the same size as the full image.
  // It will be pixelated, but it will be ready right away.
  if (this.rotation == 0 || this.rotation == 180) {
    this.itemWidth = this.oldimage.width = this.fullsizeWidth;
    this.itemHeight = this.oldimage.height = this.fullsizeHeight;
  } else {
    this.itemWidth = this.oldimage.height = this.fullsizeHeight;
    this.itemHeight = this.oldimage.width = this.fullsizeWidth;
  }

  this.computeFit();
  this.setPosition();

  // Query the position of the two images in order to flush the changes
  // made by setPosition() above. This prevents us from accidentally
  // animating those changes when the user double taps to zoom.
  if (this.oldimage) {
    var temp = this.oldimage.clientLeft;
    temp = this.image.clientLeft;
  }

  // When the new image is loaded we can begin to remove the preview image
  newimage.onload = function imageLoaded() {
    newimage.onload = null;

    // If the image we got has a different size than what we predicted
    // then make an adjustment now. This might happen if we use a
    // #-moz-samplesize fragment and it does not do what we expect.
    if (newimage.width !== self.fullsizeWidth) {
      console.warn('#-moz-samplesize did not scale as expected',
                  newimage.width, self.fullsizeWidth);
      self.itemWidth = self.fullsizeWidth = newimage.width;
      self.itemHeight = self.fullsizeHeight = newimage.height;
    }

    // It takes quite a while for gecko to decode a 1200x1600 image once
    // it is loaded, so we wait a second here before removing the preview.
    // XXX: This is a hack. There really ought to be an event we can listen for
    // to know when the image is ready to display onscreen. See Bug 844245.
    self.imageSwitchTimeout = setTimeout(function() {
      self.imageSwitchTimeout = null;
      if (self.oldimage) {
        self.container.removeChild(self.oldimage);
        self.oldimage.onload = null;
        self.oldimage.src = '';
        self.oldimage = null;
      }
    }, 1000);
  };
};

MediaFrame.prototype._switchToPreviewImage = function _switchToPreview() {
  // If we're not displaying an image or already displaying preview
  // then there is nothing to do
  if (!this.displayingImage || this.displayingPreview)
    return;

  this._displayImage(this.previewblob || this.imageblob, true);
};

MediaFrame.prototype.displayVideo = function displayVideo(videoblob, posterblob,
                                                          width, height,
                                                          rotation)
{
  if (!this.video)
    return;

  this.clear();  // reset everything

  // Keep track of what kind of content we have
  this.displayingVideo = true;

  // Remember the blobs
  this.videoblob = videoblob;
  this.posterblob = posterblob;

  // Get new URLs for the blobs
  this.videourl = URL.createObjectURL(videoblob);
  this.posterurl = URL.createObjectURL(posterblob);

  // Display them in the video element.
  // The VideoPlayer class takes care of positioning itself, so we
  // don't have to do anything here with computeFit() or setPosition()
  this.video.load(this.videourl, this.posterurl, width, height, rotation || 0);

  // Show the player controls
  this.video.show();
};


// Get rid of the image if we have one
MediaFrame.prototype._clearImage = function _clearImage() {
  if (this.image) {
    this.container.removeChild(this.image);
    this.image.onload = null;
    this.image.onerror = null;
    this.image.src = '';
    this.image = null;
  }
};

// Reset the frame state, release any urls and and hide everything
MediaFrame.prototype.clear = function clear() {
  // Reset the saved state
  this.displayingImage = false;
  this.displayingPreview = false;
  this.displayingVideo = false;
  this.itemWidth = this.itemHeight = null;
  this.imageblob = null;
  this.previewblob = null;
  this.videoblob = null;
  this.posterblob = null;
  this.fullsizeWidth = this.fullsizeHeight = null;
  this.preview = null;
  this.fit = null;
  if (this.url) {
    URL.revokeObjectURL(this.url);
    this.url = null;
  }

  this._clearImage();

  // If we were in the middle of switching from a preview image to a
  // fullsize image, then clean up from that, too.
  if (this.imageSwitchTimeout) {
    clearTimeout(this.imageSwitchTimeout);
    this.imageSwitchTimeout = null;
  }
  if (this.oldimage) {
    this.container.removeChild(this.oldimage);
    this.oldimage.onload = null;
    this.oldimage.onerror = null;
    this.oldimage.src = '';
    this.oldimage = null;
  }

  // Hide the video player
  if (this.video) {
    this.video.reset();
    this.video.hide();
    if (this.videourl)
      URL.revokeObjectURL(this.videourl);
    if (this.posterurl)
      URL.revokeObjectURL(this.posterurl);
  }
};

// Set the item's position based on this.fit
// The VideoPlayer object fits itself to its container, and it
// can't be zoomed or panned, so we only need to do this for images
MediaFrame.prototype.setPosition = function setPosition() {
  if (!this.fit || !this.displayingImage)
    return;

  var dx = this.fit.left, dy = this.fit.top;

  // We have to adjust the translation to account for the fact that the
  // scaling is being done around the middle of the image, rather than the
  // upper-left corner.  And we have to make this adjustment differently
  // for different rotations.
  switch (this.rotation) {
  case 0:
  case 180:
    dx += (this.fit.width - this.itemWidth) / 2;
    dy += (this.fit.height - this.itemHeight) / 2;
    break;
  case 90:
  case 270:
    dx += (this.fit.width - this.itemHeight) / 2;
    dy += (this.fit.height - this.itemWidth) / 2;
    break;
  }

  var sx = this.mirrored ? -this.fit.scale : this.fit.scale;
  var sy = this.fit.scale;

  var transform =
    'translate(' + dx + 'px, ' + dy + 'px) ' +
    'scale(' + sx + ',' + sy + ')' +
    'rotate(' + this.rotation + 'deg) ';

  this.image.style.transform = transform;
  if (this.oldimage)
    this.oldimage.style.transform = transform;
};

MediaFrame.prototype.computeFit = function computeFit() {
  if (!this.displayingImage)
    return;
  this.viewportWidth = this.container.offsetWidth;
  this.viewportHeight = this.container.offsetHeight;

  var scalex = this.viewportWidth / this.itemWidth;
  var scaley = this.viewportHeight / this.itemHeight;
  var scale = Math.min(Math.min(scalex, scaley), 1);

  // Set the image size and position
  var width = Math.floor(this.itemWidth * scale);
  var height = Math.floor(this.itemHeight * scale);

  this.fit = {
    width: width,
    height: height,
    left: Math.floor((this.viewportWidth - width) / 2),
    top: Math.floor((this.viewportHeight - height) / 2),
    scale: scale,
    baseScale: scale
  };
};

MediaFrame.prototype.reset = function reset() {
  // If we're not displaying the preview image, but we have one,
  // and it is the right size, then switch to it
  if (this.displayingImage && !this.displayingPreview &&
      (this.previewblob || this.previewSampleSize !== Downsample.NONE)) {
    this._switchToPreviewImage(); // resets image size and position
    return;
  }

  // Otherwise, just resize and position the item we're already displaying
  this.computeFit();
  this.setPosition();
  // If frame is resized, the video's size also need to reset.
  if (this.displayingVideo)
    this.video.setPlayerSize();
};

// We call this from the resize handler when the user rotates the
// screen or when going into or out of fullscreen mode. If the user
// has not zoomed in, then we just fit the image to the new size (same
// as reset).  But if the user has zoomed in (and we need to stay
// zoomed for the new size) then we adjust the fit properties so that
// the pixel that was at the center of the screen before remains at
// the center now, or as close as possible
MediaFrame.prototype.resize = function resize() {
  var oldWidth = this.viewportWidth;
  var oldHeight = this.viewportHeight;
  var newWidth = this.container.offsetWidth;
  var newHeight = this.container.offsetHeight;

  var oldfit = this.fit; // The current image fit

  // If this is triggered by a resize event before the frame has computed
  // its size, then there is nothing we can do yet.
  if (!oldfit)
    return;

  // Compute the new fit.
  // This updates the the viewportWidth, viewportHeight and fit properties
  this.computeFit();

  // This is how the image would fit at the new screen size
  var newfit = this.fit;

  // If no zooming has been done (or almost no zooming), then a resize is just
  // a reset. The same is true if the new fit base scale is greater than the
  // old scale.
  // The scale is calculated with division, the value may not be accurate
  // because of IEEE 754. We use abs difference to do the equality checking.
  if (Math.abs(oldfit.scale - oldfit.baseScale) < 0.01 ||
      newfit.baseScale > oldfit.scale) {

    this.reset();
    return;
  }

  // Otherwise, just adjust the old fit as needed and use that so we
  // retain the zoom factor.
  oldfit.left += (newWidth - oldWidth) / 2;
  oldfit.top += (newHeight - oldHeight) / 2;
  oldfit.baseScale = newfit.baseScale;
  this.fit = oldfit;

  // Reposition this image without resetting the zoom
  this.setPosition();
};

// Zoom in by the specified factor, adjusting the pan amount so that
// the image pixels at (fixedX, fixedY) remain at that position.
// Assume that zoom gestures can't be done in the middle of swipes, so
// if we're calling zoom, then the swipe property will be 0.
// If time is specified and non-zero, then we set a CSS transition
// to animate the zoom.
MediaFrame.prototype.zoom = function zoom(scale, fixedX, fixedY, time) {
  // Ignore zooms if we're not displaying an image
  if (!this.displayingImage)
    return;

  // If we were displaying the preview, switch to the full-size image
  if (this.displayingPreview)
    this._switchToFullSizeImage();

  // Never zoom in farther than the native resolution of the image
  if (this.fit.scale * scale > 1) {
    scale = 1 / (this.fit.scale);
  }
  // And never zoom out to make the image smaller than it would normally be
  else if (this.fit.scale * scale < this.fit.baseScale) {
    scale = this.fit.baseScale / this.fit.scale;
  }

  this.fit.scale = this.fit.scale * scale;

  // Change the size of the photo
  this.fit.width = Math.floor(this.itemWidth * this.fit.scale);
  this.fit.height = Math.floor(this.itemHeight * this.fit.scale);

  // fixedX and fixedY are in viewport coordinates.
  // These are the photo coordinates displayed at that point in the viewport
  var photoX = fixedX - this.fit.left;
  var photoY = fixedY - this.fit.top;

  // After zooming, these are the new photo coordinates.
  // Note we just use the relative scale amount here, not this.fit.scale
  photoX = Math.floor(photoX * scale);
  photoY = Math.floor(photoY * scale);

  // To keep that point still, here are the new left and top values we need
  this.fit.left = fixedX - photoX;
  this.fit.top = fixedY - photoY;

  // Now make sure we didn't pan too much: If the image fits on the
  // screen, fixed it. If the image is bigger than the screen, then
  // make sure we haven't gone past any edges
  if (this.fit.width <= this.viewportWidth) {
    this.fit.left = (this.viewportWidth - this.fit.width) / 2;
  }
  else {
    // Don't let the left of the photo be past the left edge of the screen
    if (this.fit.left > 0)
      this.fit.left = 0;

    // Right of photo shouldn't be to the left of the right edge
    if (this.fit.left + this.fit.width < this.viewportWidth) {
      this.fit.left = this.viewportWidth - this.fit.width;
    }
  }

  if (this.fit.height <= this.viewportHeight) {
    this.fit.top = (this.viewportHeight - this.fit.height) / 2;
  }
  else {
    // Don't let the top of the photo be below the top of the screen
    if (this.fit.top > 0)
      this.fit.top = 0;

    // bottom of photo shouldn't be above the bottom of screen
    if (this.fit.top + this.fit.height < this.viewportHeight) {
      this.fit.top = this.viewportHeight - this.fit.height;
    }
  }

  // If a time was specified, set up a transition so that the
  // call to setPosition() below is animated
  if (time) {
    // If a time was specfied, animate the transformation
    var transition = 'transform ' + time + 'ms ease';
    this.image.style.transition = transition;
    if (this.oldimage)
      this.oldimage.style.transition = transition;
    var self = this;
    this.image.addEventListener('transitionend', function done() {
      self.image.removeEventListener('transitionend', done);
      self.image.style.transition = null;
    });
  }

  this.setPosition();
};

// If the item being displayed is larger than the continer, pan it by
// the specified amounts.  Return the "unused" dx amount for the gallery app
// to use for sideways swiping
MediaFrame.prototype.pan = function(dx, dy) {
  // We can only pan images, so return the entire dx amount
  if (!this.displayingImage) {
    return dx;
  }

  // Handle panning in the y direction first, since it is easier.
  // Don't pan in the y direction if we already fit on the screen
  if (this.fit.height > this.viewportHeight) {
    this.fit.top += dy;

    // Don't let the top of the photo be below the top of the screen
    if (this.fit.top > 0)
      this.fit.top = 0;

    // bottom of photo shouldn't be above the bottom of screen
    if (this.fit.top + this.fit.height < this.viewportHeight)
      this.fit.top = this.viewportHeight - this.fit.height;
  }

  // Now handle the X dimension. If we've already panned as far as we can
  // within the image (or if it isn't zoomed in) then return the "extra"
  // unused dx amount to the caller so that the caller can use them to
  // shift the frame left or right.
  var extra = 0;

  if (this.fit.width <= this.viewportWidth) {
    // In this case, the photo isn't zoomed in, so it is all extra
    extra = dx;
  }
  else {
    this.fit.left += dx;

    // If this would take the left edge of the photo past the
    // left edge of the screen, then some of the motion is extra
    if (this.fit.left > 0) {
      extra = this.fit.left;
      this.fit.left = 0;
    }

    // Or, if this would take the right edge of the photo past the
    // right edge of the screen, then we've got extra.
    if (this.fit.left + this.fit.width < this.viewportWidth) {
      extra = this.fit.left + this.fit.width - this.viewportWidth;
      this.fit.left = this.viewportWidth - this.fit.width;
    }
  }

  this.setPosition();
  return extra;
};

MediaFrame.prototype.setMinimumPreviewSize = function(w, h) {
  this.minimumPreviewWidth = w;
  this.minimumPreviewHeight = h;
};

define("MediaFrame", ["format","VideoPlayer"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.MediaFrame;
    };
}(this)));

define('views/preview-gallery',['require','debug','lib/bind','vendor/attach','vendor/view','lib/orientation','lib/panzoom','MediaFrame'],function(require) {


/**
 * Dependencies
 */

var debug = require('debug')('view:preview-gallery');
var bind = require('lib/bind');
var attach = require('vendor/attach');
var View = require('vendor/view');
var orientation = require('lib/orientation');
var addPanAndZoomHandlers = require('lib/panzoom');
var MediaFrame = require('MediaFrame');

/**
 * Constants
 */

var SWIPE_DISTANCE_THRESHOLD = window.innerWidth / 3; // pixels
var SWIPE_VELOCITY_THRESHOLD = 1.0;                   // pixels/ms

var SWIPE_DURATION = 250;   // How long to animate the swipe
var FADE_IN_DURATION = 500; // How long to animate the fade in after swipe

/**
 * Locals
 */

return View.extend({
  name: 'preview-gallery',
  className: 'offscreen',

  initialize: function() {
    debug('initialized');
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.frameContainer = this.find('.js-frame-container');
    this.els.mediaFrame = this.find('.js-media-frame');
    this.els.countText = this.find('.js-count-text');
    this.els.previewMenu = this.find('.js-preview-menu');

    // Update localization strings
    navigator.mozL10n.translate(this.el);

    // Configure the MediaFrame component
    this.configure();

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.el, 'tap', this.onTap);
    attach.on(this.els.previewMenu, 'click', '.js-btn', this.onButtonClick);
    return this;
  },

  configure: function() {
    this.currentIndex = this.lastIndex = 0;

    this.frame = new MediaFrame(this.els.mediaFrame, true, this.maxPreviewSize);
    this.frame.video.onplaying = this.handleVideoPlay;
    this.frame.video.onpaused = this.handleVideoStop;

    addPanAndZoomHandlers(this.frame, this.swipeCallback);
  },

  template: function() {
    return '<div class="frame-container js-frame-container">' +
     '<div class="media-frame js-media-frame"></div>' +
     '</div>' +
     '<div class="preview-menu js-preview-menu">' +
       '<section class="skin-dark" role="region">' +
        '<header class="js-preview-header">' +
          '<button class="js-btn" name="back">' +
            '<span class="preview-back-icon icon-back-arrow">' +
            '</span>' +
          '</button>' +
          '<menu type="toolbar">' +
            '<button class="js-btn" name="share">' +
              '<span class="preview-share-icon icon-preview-share">' +
              '</span>' +
            '</button>' +
            '<button class="js-btn" name="options" >' +
              '<span class="preview-option-icon icon-preview-options">' +
              '</span>' +
            '</button>' +
          '</menu>' +
          '<h1 data-l10n-id="preview">Preview</h1>' +
        '</header>' +
       '</section>' +
      '<div class="count-text js-count-text"></div>' +
    '</div>';
  },

  onTap: function() {
    if (this.videoPlaying) {
      return;
    }

    var isShown = this.els.previewMenu.classList.contains('visible');
    if (isShown) {
      this.previewMenuFadeOut();
    } else {
      this.previewMenuFadeIn();
    }
  },

  previewMenuFadeIn: function() {
    this.els.previewMenu.classList.add('visible');
  },

  previewMenuFadeOut: function() {
    this.els.previewMenu.classList.remove('visible');
  },

  swipeCallback: function(swipeAmount, swipeVelocity) {
    var self = this;

    if (swipeVelocity === undefined) {
      // If this is not the end of the gesture, then just move the media
      // frame left or right by the specified amount.
      this.els.frameContainer.style.transform =
        'translate(' + swipeAmount + 'px, 0)';
      return;
    }

    // If we were passed a velocity, then this is the end of the gesture
    // and we have to figure out whether we are going to go to the
    // next item, the previous item, or remain on the current item.
    var direction, translation;

    // Should we move to the previous item?
    if (swipeAmount > 0 && swipeVelocity > 0 &&     // Same sign and
        this.currentIndex > 1 &&                    // has previous item and
        (swipeAmount > SWIPE_DISTANCE_THRESHOLD ||  // distance big enough or
         swipeVelocity > SWIPE_VELOCITY_THRESHOLD)) // speed fast enough
    {
      direction = 'right';
      translation = '100%';
    }
    // Should we move to the next item?
    else if (swipeAmount <= 0 && swipeVelocity <= 0 &&
             this.currentIndex < this.lastIndex &&
             (swipeAmount < -SWIPE_DISTANCE_THRESHOLD ||
              swipeVelocity < -SWIPE_VELOCITY_THRESHOLD)) {
      direction = 'left';
      translation = '-100%';
    }

    // If we're not moving either left or right, just animate the
    // item to its starting point and we're done.
    if (!direction) {
      animate('transform', 'translate(0,0)', SWIPE_DURATION);
      return;
    }

    // If we get here, we are going to slide the current item off the screen
    // and display the next or previous item.

    // First, stop the video if there is one and it is playing.
    if (this.videoPlaying) {
      this.handleVideoStop();
    }

    // Now animate the item off the screen
    animate('transform', 'translate(' + translation + ', 0)',
            SWIPE_DURATION,
            function() {
              // Once we're off screen ask the controller to
              // switch to the new image.
              self.emit('swipe', direction);

              // On the next redraw, put the frame back on the screen
              // but make it opaque
              window.requestAnimationFrame(function() {
                // Next, make the frame invisible
                // and put it back on the screen
                self.els.frameContainer.style.opacity = 0;
                self.els.frameContainer.style.transform = 'translate(0,0)';

                // Then on the frame after that, animate the opacity to
                // make it visible again.
                window.requestAnimationFrame(function() {
                  animate('opacity', 1, FADE_IN_DURATION);
                });
              });
            });

    // A helper function to animate the specified CSS property to the
    // specified value for the specified duration. When the animation
    // is complete, reset everything and call the done callback
    function animate(property, value, duration, done) {
      var e = self.els.frameContainer;
      e.addEventListener('transitionend', onTransitionEnd);
      e.style.transitionProperty = property;
      e.style.transitionDuration = duration + 'ms';
      e.style[property] = value;

      function onTransitionEnd() {
        e.removeEventListener('transitionend', onTransitionEnd);
        delete e.style.transitionProperty;
        delete e.style.transitionDuration;
        if (done) {
          done();
        }
      }
    }
  },

  onButtonClick: function(e, el) {
    if (this.videoPlaying) { return; }

    var name = el.getAttribute('name');
    if (this.optionsMenuContainer) {
      this.hideOptionsMenu();
    }
    this.emit('click:' + name, e);
    e.stopPropagation();
  },

  open: function() {
    window.addEventListener('resize', this.onResize);
    orientation.unlock();
    this.previewMenuFadeIn();
    this.el.classList.remove('offscreen');
  },

  close: function() {
    window.removeEventListener('resize', this.onResize);
    orientation.lock();
    this.previewMenuFadeOut();
    this.el.classList.add('offscreen');
    this.frame.clear();
  },

  updateCountText: function(current, total) {
    this.currentIndex = current;
    this.lastIndex = total;
    this.els.countText.textContent = current + '/' + total;
  },

  onResize: function() {
    // And we have to resize the frame (and its video player)
    this.frame.resize();
    if (this.frame.displayingVideo) {
      this.frame.video.setPlayerSize();
    }
  },

  showImage: function(image) {
    this.frame.displayImage(
      image.blob,
      image.width,
      image.height,
      image.preview,
      image.rotation,
      image.mirrored);
  },

  showVideo: function(video) {
    this.frame.displayVideo(
      video.blob,
      video.poster.blob,
      video.width,
      video.height,
      video.rotation);
  },

  handleVideoPlay: function() {
    if (this.videoPlaying) {
      return;
    }

    this.videoPlaying = true;
    this.previewMenuFadeOut();
  },

  handleVideoStop: function() {
    if (!this.videoPlaying) {
      return;
    }

    this.videoPlaying = false;
    this.previewMenuFadeIn();
  },

  showOptionsMenu: function() {
    this.optionsMenuContainer = document.createElement('div');
    this.optionsMenuContainer.innerHTML = this.optionTemplate();
    navigator.mozL10n.translate(this.optionsMenuContainer);
    this.el.appendChild(this.optionsMenuContainer);

    this.menu = this.find('.js-menu');

    // We add the event listner for menu items and cancel buttons
    var cancelButton = this.find('.js-cancel');
    bind(cancelButton, 'click', this.hideOptionsMenu);
    if (this.menu) {
      attach.on(this.menu, 'click', '.js-btn', this.onButtonClick);
    }
  },

  hideOptionsMenu: function() {
    if (this.optionsMenuContainer) {
      this.optionsMenuContainer.parentElement.removeChild(
        this.optionsMenuContainer);
      this.optionsMenuContainer = null;
    }
  },

  optionTemplate: function() {
    return '<form class="visible" data-type="action"' +
      'role="dialog" data-z-index-level="action-menu">' +
      '<header data-l10n-id="options">Options</header>' +
      '<menu class="js-menu">' +
      '<button class="js-btn" name="gallery" data-l10n-id="open-gallery">' +
        'Open Gallery' +
      '</button>' +
      '<button class="js-btn" name="delete" data-l10n-id="delete">' +
        'Delete' +
      '</button>' +
      '<button class="js-cancel" data-action="cancel" data-l10n-id="cancel">' +
        'Cancel' +
      '</button>' +
      '</menu>' +
      '</form>';
  }
});

});



//
// This file defines a single function that asynchronously reads a
// JPEG file (or blob) to determine its width and height and find the
// location and size of the embedded preview image, if it has one. If
// it succeeds, it passes an object containing this data to the
// specified callback function. If it fails, it passes an error message
// to the specified error function instead.
//
// This function is capable of parsing and returning EXIF data for a
// JPEG file, but for speed, it ignores all EXIF data except the embedded
// preview image and the image orientation.
//
// This function requires the BlobView utility class
//
function parseJPEGMetadata(file, metadataCallback, metadataError) {
  // This is the object we'll pass to metadataCallback
  var metadata = {};

  // Start off reading a 16kb slice of the JPEG file.
  // Hopefully, this will be all we need and everything else will
  // be synchronous
  BlobView.get(file, 0, Math.min(16 * 1024, file.size), function(data) {
    if (data.byteLength < 2 ||
        data.getUint8(0) !== 0xFF ||
        data.getUint8(1) !== 0xD8) {
      metadataError('Not a JPEG file');
      return;
    }

    // Now start reading JPEG segments
    // getSegment() and segmentHandler() are defined below.
    getSegment(data, 2, segmentHandler);
  });

  // Read the JPEG segment at the specified offset and
  // pass it to the callback function.
  // Offset is relative to the current data offsets.
  // We assume that data has enough data in it that we can
  // can determine the size of the segment, and we guarantee that
  // we read extra bytes so the next call works
  function getSegment(data, offset, callback) {
    try {
      var header = data.getUint8(offset);
      if (header !== 0xFF) {
        metadataError('Malformed JPEG file: bad segment header');
        return;
      }

      var type = data.getUint8(offset + 1);
      var size = data.getUint16(offset + 2) + 2;

      // the absolute position of the segment
      var start = data.sliceOffset + data.viewOffset + offset;
      // If this isn't the last segment in the file, add 4 bytes
      // so we can read the size of the next segment
      var isLast = (start + size >= file.size);
      var length = isLast ? size : size + 4;

      data.getMore(start, length,
                   function(data) {
                     callback(type, size, data, isLast);
                   });
    }
    catch (e) {
      metadataError(e.toString() + '\n' + e.stack);
    }
  }

  // This is a callback function for getNextSegment that handles the
  // various types of segments we expect to see in a jpeg file
  function segmentHandler(type, size, data, isLastSegment) {
    try {
      switch (type) {
      case 0xC0:  // Some actual image data, including image dimensions
      case 0xC1:
      case 0xC2:
      case 0xC3:
        // Get image dimensions
        metadata.height = data.getUint16(5);
        metadata.width = data.getUint16(7);

        // We're done. All the EXIF data will come before this segment
        // So call the callback
        metadataCallback(metadata);
        break;

      case 0xE1:  // APP1 segment. Probably holds EXIF metadata
        parseAPP1(data);
        /* fallthrough */

      default:
        // A segment we don't care about, so just go on and read the next one
        if (isLastSegment) {
          metadataError('unexpected end of JPEG file');
          return;
        }
        getSegment(data, size, segmentHandler);
      }
    }
    catch (e) {
      metadataError(e.toString() + '\n' + e.stack);
    }
  }

  function parseAPP1(data) {
    if (data.getUint32(4, false) === 0x45786966) { // "Exif"
      var exif = parseEXIFData(data);

      if (exif.THUMBNAIL && exif.THUMBNAILLENGTH) {
        var start = data.sliceOffset + data.viewOffset + 10 + exif.THUMBNAIL;
        metadata.preview = {
          start: start,
          end: start + exif.THUMBNAILLENGTH
        };
      }

      // map exif orientation flags for easy transforms
      switch (exif.ORIENTATION) {
        case undefined:
        case 1:
          metadata.rotation = 0;
          metadata.mirrored = false;
          break;
        case 2:
          metadata.rotation = 0;
          metadata.mirrored = true;
          break;
        case 3:
          metadata.rotation = 180;
          metadata.mirrored = false;
          break;
        case 4:
          metadata.rotation = 180;
          metadata.mirrored = true;
          break;
        case 5:
          metadata.rotation = 90;
          metadata.mirrored = true;
          break;
        case 6:
          metadata.rotation = 90;
          metadata.mirrored = false;
          break;
        case 7:
          metadata.rotation = 270;
          metadata.mirrored = true;
          break;
        case 8:
          metadata.rotation = 270;
          metadata.mirrored = false;
          break;
        default:
          throw Error('Unknown Exif code for orientation');
      }
    }
  }

  // Parse an EXIF segment from a JPEG file and return an object
  // of metadata attributes. The argument must be a DataView object
  function parseEXIFData(data) {
    var exif = {};

    var byteorder = data.getUint8(10);
    if (byteorder === 0x4D) {  // big endian
      byteorder = false;
    } else if (byteorder === 0x49) {  // little endian
      byteorder = true;
    } else {
      throw Error('invalid byteorder in EXIF segment');
    }

    if (data.getUint16(12, byteorder) !== 42) { // magic number
      throw Error('bad magic number in EXIF segment');
    }

    var offset = data.getUint32(14, byteorder);

     // This is how we would parse all EXIF metadata more generally.
     // Especially need for iamge orientation
    parseIFD(data, offset + 10, byteorder, exif, true);

    // I'm leaving this code in as a comment in case we need other EXIF
    // data in the future.
    // if (exif.EXIFIFD) {
    //   parseIFD(data, exif.EXIFIFD + 10, byteorder, exif);
    //   delete exif.EXIFIFD;
    // }

    // if (exif.GPSIFD) {
    //   parseIFD(data, exif.GPSIFD + 10, byteorder, exif);
    //   delete exif.GPSIFD;
    // }

    // Instead of a general purpose EXIF parse, we're going to drill
    // down directly to the thumbnail image.
    // We're in IFD0 here. We want the offset of IFD1
    var ifd0entries = data.getUint16(offset + 10, byteorder);
    var ifd1 = data.getUint32(offset + 12 + 12 * ifd0entries, byteorder);
    // If there is an offset for IFD1, parse that
    if (ifd1 !== 0)
      parseIFD(data, ifd1 + 10, byteorder, exif, true);

    return exif;
  }

  function parseIFD(data, offset, byteorder, exif, onlyParseOne) {
    var numentries = data.getUint16(offset, byteorder);
    for (var i = 0; i < numentries; i++) {
      parseEntry(data, offset + 2 + 12 * i, byteorder, exif);
    }

    if (onlyParseOne)
      return;

    var next = data.getUint32(offset + 2 + 12 * numentries, byteorder);
    if (next !== 0 && next < file.size) {
      parseIFD(data, next + 10, byteorder, exif);
    }
  }

  // size, in bytes, of each TIFF data type
  var typesize = [
    0,   // Unused
    1,   // BYTE
    1,   // ASCII
    2,   // SHORT
    4,   // LONG
    8,   // RATIONAL
    1,   // SBYTE
    1,   // UNDEFINED
    2,   // SSHORT
    4,   // SLONG
    8,   // SRATIONAL
    4,   // FLOAT
    8    // DOUBLE
  ];

  // This object maps EXIF tag numbers to their names.
  // Only list the ones we want to bother parsing and returning.
  // All others will be ignored.
  var tagnames = {
    /*
     * We don't currently use any of these EXIF tags for anything.
     *
     *
     '256': 'ImageWidth',
     '257': 'ImageHeight',
     '40962': 'PixelXDimension',
     '40963': 'PixelYDimension',
     '306': 'DateTime',
     '315': 'Artist',
     '33432': 'Copyright',
     '36867': 'DateTimeOriginal',
     '33434': 'ExposureTime',
     '33437': 'FNumber',
     '34850': 'ExposureProgram',
     '34867': 'ISOSpeed',
     '37377': 'ShutterSpeedValue',
     '37378': 'ApertureValue',
     '37379': 'BrightnessValue',
     '37380': 'ExposureBiasValue',
     '37382': 'SubjectDistance',
     '37383': 'MeteringMode',
     '37384': 'LightSource',
     '37385': 'Flash',
     '37386': 'FocalLength',
     '41986': 'ExposureMode',
     '41987': 'WhiteBalance',
     '41991': 'GainControl',
     '41992': 'Contrast',
     '41993': 'Saturation',
     '41994': 'Sharpness',
    // These are special tags that we handle internally
     '34665': 'EXIFIFD',         // Offset of EXIF data
     '34853': 'GPSIFD',          // Offset of GPS data
    */
    '274' : 'ORIENTATION',
    '513': 'THUMBNAIL',         // Offset of thumbnail
    '514': 'THUMBNAILLENGTH'    // Length of thumbnail
  };

  function parseEntry(data, offset, byteorder, exif) {
    var tag = data.getUint16(offset, byteorder);
    var tagname = tagnames[tag];

    // If we don't know about this tag type or already processed it, skip it
    if (!tagname || exif[tagname])
      return;

    var type = data.getUint16(offset + 2, byteorder);
    var count = data.getUint32(offset + 4, byteorder);

    var total = count * typesize[type];
    var valueOffset = total <= 4 ? offset + 8 :
      data.getUint32(offset + 8, byteorder);
    exif[tagname] = parseValue(data, valueOffset, type, count, byteorder);
  }

  function parseValue(data, offset, type, count, byteorder) {
    if (type === 2) { // ASCII string
      var codes = [];
      for (var i = 0; i < count - 1; i++) {
        codes[i] = data.getUint8(offset + i);
      }
      return String.fromCharCode.apply(String, codes);
    } else {
      if (count == 1) {
        return parseOneValue(data, offset, type, byteorder);
      } else {
        var values = [];
        var size = typesize[type];
        for (var i = 0; i < count; i++) {
          values[i] = parseOneValue(data, offset + size * i, type, byteorder);
        }
        return values;
      }
    }
  }

  function parseOneValue(data, offset, type, byteorder) {
    switch (type) {
    case 1: // BYTE
    case 7: // UNDEFINED
      return data.getUint8(offset);
    case 2: // ASCII
      // This case is handed in parseValue
      return null;
    case 3: // SHORT
      return data.getUint16(offset, byteorder);
    case 4: // LONG
      return data.getUint32(offset, byteorder);
    case 5: // RATIONAL
      return data.getUint32(offset, byteorder) /
        data.getUint32(offset + 4, byteorder);
    case 6: // SBYTE
      return data.getInt8(offset);
    case 8: // SSHORT
      return data.getInt16(offset, byteorder);
    case 9: // SLONG
      return data.getInt32(offset, byteorder);
    case 10: // SRATIONAL
      return data.getInt32(offset, byteorder) /
        data.getInt32(offset + 4, byteorder);
    case 11: // FLOAT
      return data.getFloat32(offset, byteorder);
    case 12: // DOUBLE
      return data.getFloat64(offset, byteorder);
    }
    return null;
  }
}
;
define("jpegMetaDataParser", ["BlobView"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.parseJPEGMetadata;
    };
}(this)));

/* exported getImageSize */
/* global BlobView */
/* global parseJPEGMetadata */

/*
 * Determine the pixel dimensions of an image without actually
 * decoding the image. Passes an object of metadata to the callback
 * function on success or an error message to the error function on
 * failure. The metadata object will include type, width and height
 * properties. Supported image types are GIF, PNG and JPEG. JPEG
 * metadata may also include information about an EXIF preview image.
 *
 * Because of shortcomings in the way Gecko handles images, the
 * Gallery app will crash with an OOM error if it attempts to decode
 * and display an image that is too big. Images require 4 bytes per
 * pixel, so a 10 megapixel photograph requires 40 megabytes of image
 * memory. This function gives the gallery app a way to reject images
 * that are too large.
 *
 * Requires the BlobView class from shared/js/blobview.js and the
 * parseJPEGMetadata() function from shared/js/media/jpeg_metadata_parser.js
 */
function getImageSize(blob, callback, error) {
  

  BlobView.get(blob, 0, Math.min(1024, blob.size), function(data) {
    // Make sure we are at least 8 bytes long before reading the first 8 bytes
    if (data.byteLength <= 8) {
      error('corrupt image file');
      return;
    }
    var magic = data.getASCIIText(0, 8);
    if (magic.substring(0, 4) === 'GIF8') {
      try {
        callback({
          type: 'gif',
          width: data.getUint16(6, true),
          height: data.getUint16(8, true)
        });
      }
      catch (e) {
        error(e.toString());
      }
    }
    else if (magic.substring(0, 8) === '\x89PNG\r\n\x1A\n') {
      try {
        callback({
          type: 'png',
          width: data.getUint32(16, false),
          height: data.getUint32(20, false)
        });
      }
      catch (e) {
        error(e.toString());
      }
    }
    else if (magic.substring(0, 2) === '\xFF\xD8') {
      parseJPEGMetadata(blob,
                        function(metadata) {
                          metadata.type = 'jpeg';
                          callback(metadata);
                        },
                        error);
    }
    else {
      error('unknown image type');
    }
  });
};
define("getImageSize", ["BlobView","jpegMetaDataParser"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.getImageSize;
    };
}(this)));

// downsample.js
//
// This module defines a single global Downsample object with static
// methods that return objects representing media fragments for
// downsampling images while they are decoded. The current implementation
// is based on the #-moz-samplesize media fragment. But because of
// problems with that fragment (see bug 1004908) it seems likely that a
// new syntax or new fragment will be introduced. If that happens, we can
// just change this module and not have to change anything else that
// depends on it.
//
// The method Downsample.areaAtLeast(scale) returns an object
// representing a media fragment to use to decode an image downsampled by
// at least as much as the specified scale.  If you are trying to preview
// an 8mp image and don't want to use more than 2mp of image memory, for
// example, you would pass a scale of .25 (2mp/8mp) here, and the
// resulting media fragment could be appended to the url to make the
// image decode at a size equal to or smaller than 2mp.
//
// The method Downsample.sizeNoMoreThan(scale) returns a media fragment
// object that you can use to reduce the dimensions of an image as much
// as possible without exceeding the specified scale. If you have a
// 1600x1200 image and want to decode it to produce an image that is as
// small as possible but at least 160x120, you would pass a scale of 0.1.
//
// The returned objects have a dimensionScale property that specifies how
// they affect the dimensions of the image and an areaScale property that
// specifies how much they affect the area (number of pixels) in an
// image. (The areaScale is just the square of the scale.) To avoid
// floating-point rounding issues, the values of these scale properties
// are rounded to the nearest hundredth.
//
// The returned objects also have a scale() method that scales a
// dimension with proper rounding (it rounds up to the nearest integer
// just as libjpeg does).
//
// Each object also has a toString() method that returns the required
// media fragment (including the hash mark) so you can simply use
// string concatentation to append one of these objects to the URL of
// the image you want to decode.
//
// Downsample.NONE is a no-op media fragment object with scale set to
// 1, and a toString() method that returns the empty string.
//
(function(exports) {
  

  // Round to the nearest hundredth to combat floating point rounding errors
  function round(x) {
    return Math.round(x * 100) / 100;
  }


  //
  // A factory method for returning an object that represents a
  // #-moz-samplesize media fragment. The use of Math.ceil() in the
  // scale method is from jpeg_core_output_dimensions() in
  // media/libjpeg/jdmaster.c and jdiv_round_up() in media/libjpeg/jutils.c
  //
  function MozSampleSize(n, scale) {
    return Object.freeze({
      dimensionScale: round(scale),
      areaScale: round(scale * scale),
      toString: function() { return '#-moz-samplesize=' + n; },
      scale: function(x) { return Math.ceil(x * scale); }
    });
  }

  // A fragment object that represents no downsampling with no fragment
  var NONE = Object.freeze({
    dimensionScale: 1,
    areaScale: 1,
    toString: function() { return ''; },
    scale: function(x) { return x; }
  });

  //
  // The five possible #-moz-samplesize values.
  // The mapping from sample size to scale comes from:
  // the moz-samplesize code in /image/decoders/nsJPEGDecoder.cpp and
  // the jpeg_core_output_dimensions() function in media/libjpeg/jdmaster.c
  //
  var fragments = [
    NONE,
    MozSampleSize(2, 1 / 2), // samplesize=2 reduces size by 1/2 and area by 1/4
    MozSampleSize(3, 3 / 8), // etc.
    MozSampleSize(4, 1 / 4),
    MozSampleSize(8, 1 / 8)
  ];

  // Return the fragment object that has the largest scale and downsamples the
  // dimensions of an image at least as much as the specified scale.
  // If none of the choices scales enough, return the one that comes closest
  function sizeAtLeast(scale) {
    scale = round(scale);
    for (var i = 0; i < fragments.length; i++) {
      var f = fragments[i];
      if (f.dimensionScale <= scale) {
        return f;
      }
    }
    return fragments[fragments.length - 1];
  }

  // Return the fragment object that downsamples an image as far as possible
  // without going beyond the specified scale. This might return NONE.
  function sizeNoMoreThan(scale) {
    scale = round(scale);
    for (var i = fragments.length - 1; i >= 0; i--) {
      var f = fragments[i];
      if (f.dimensionScale >= scale) {
        return f;
      }
    }
    return NONE;
  }

  // Return the fragment object that has the largest scale and downsamples the
  // area of an image at least as much as the specified scale.
  // If none of the choices scales enough, return the one that comes closest
  function areaAtLeast(scale) {
    scale = round(scale);
    for (var i = 0; i < fragments.length; i++) {
      var f = fragments[i];
      if (f.areaScale <= scale) {
        return f;
      }
    }
    return fragments[fragments.length - 1];
  }

  // Return the fragment object that downsamples the area of an image
  // as far as possible without going beyond the specified scale. This
  // might return NONE.
  function areaNoMoreThan(scale) {
    scale = round(scale);
    for (var i = fragments.length - 1; i >= 0; i--) {
      var f = fragments[i];
      if (f.areaScale >= scale) {
        return f;
      }
    }
    return NONE;
  }

  exports.Downsample = {
    sizeAtLeast: sizeAtLeast,
    sizeNoMoreThan: sizeNoMoreThan,
    areaAtLeast: areaAtLeast,
    areaNoMoreThan: areaNoMoreThan,
    NONE: NONE,
    MAX_SIZE_REDUCTION: 1 / fragments[fragments.length - 1].dimensionScale,
    MAX_AREA_REDUCTION: 1 / fragments[fragments.length - 1].areaScale
  };
}(window));

define("downsample", function(){});

/* exported cropResizeRotate */
/* global getImageSize */
/* global Downsample */

//
// Given a blob that represents an encoded image, decode the image, crop it,
// rotate it, resize it, encode it again and pass the encoded blob to the
// callback.
//
// If the image includes EXIF orientation information, it will be
// rotated and/or mirrored so that the proper side is up and EXIF
// orientation information will not be needed in the output blob. The
// blob will not include any EXIF data.
//
// The cropRegion argument is optional. If specfied, it should be an
// object with left, top, width and height properties that specify the
// region of interest in the image. These coordinates should be
// specified as if the image has already been rotated and mirrored. If
// this argument is not specified, then no cropping is done and the
// entire image is returned.
//
// The outputSize argument specifies the desired size of the output
// image.  If not specified, then the image is returned full-size. If
// this argument is specified, then it should be an object with width
// and height properties or a single number.  If outputSize is an
// object, then the returned image will have the specified size or
// smaller. If the aspect ratio of the output size does not match the
// aspect ratio of the original image or of the crop region, then the
// largest area of the input region that fits the output size without
// letterboxing will be used. If the output size is larger than the
// crop region, then the output size is reduced to match the crop
// region.
//
// If outputSize is a number, then the #-moz-samplesize media fragment
// will be used, if necessary, to ensure that the input image is
// decoded at the specified size or smaller. Note that this media
// fragment gives only coarse control over image size, so passing a
// number for this argument can result in the image being decoded at a
// size substantially smaller than the specified value. If outputSize
// is a number and a crop region is specified, the image will
// typically be downsampled and then cropped, further reducing the
// size of the resulting image. On the other hand, if the crop region
// is small enough, then the function may be able to use the #xywh=
// media fragment to extract just the desired region of the rectangle
// without downsampling. Whichever approach requires less image memory
// is used.
//
// The outputType argument specifies the type of the output image. Legal
// values are "image/jpeg" and "image/png". If not specified, and if the
// input image does not need to be cropped resized or rotated, then it
// will be returned unchanged regardless of the type. If no output type
// is specified and a new blob needs to be created then "image/jpeg" will
// be used. If a type is explicitly specified, and does not match the type
// of the input image, then a new blob will be created even if no other
// changes to the image are necessary.
//
// The optional metadata argument provides a way to pass in image size and
// rotation metadata if you already have it. If this argument is omitted
// or null, getImageSize() will be used to compute the metadata. But if you
// have already called getImageSize() on the blob, you can provide the
// metadata you have and avoid having to reparse the blob.
//
// The callback argument should be a function that expects two arguments.
// If the image is successfully processed, the first argument will be null
// and the second will be a blob.  If there was an error, the first argument
// will be an error message and the second argument will be undefined.
//
// If no cropRegion and no outputSize are specified, if the type of the
// input blob matches the requested outputType, and if the image does not
// require any rotation, then this function will not do any work and will
// simply pass the input blob to the callback.
//
// This function requires other shared JS files:
//
//    shared/js/blobview.js
//    shared/js/media/image_size.js
//    shared/js/media/jpeg_metadata_parser.js
//    shared/js/media/downsample.js
//
function cropResizeRotate(blob, cropRegion, outputSize, outputType,
                          metadata, callback)
{
  

  const JPEG = 'image/jpeg';
  const PNG = 'image/png';

  // The 2nd, 3rd, 4th and 5th arguments are optional, so fix things up if we're
  // called with fewer than 6 args. The last argument is always the callback.
  switch (arguments.length) {
  case 2:
    callback = cropRegion;
    cropRegion = outputSize = outputType = metadata = null;
    break;

  case 3:
    callback = outputSize;
    outputSize = outputType = metadata = null;
    break;

  case 4:
    callback = outputType;
    outputType = metadata = null;
    break;

  case 5:
    callback = metadata;
    metadata = null;
    break;

  case 6:
    // everything fine. do nothing here
    break;

  default:
    throw new Error('wrong number of arguments: ' + arguments.length);
  }

  // If we were passed a metadata object, pass it to gotSize. Otherwise,
  // find the metadata object first and then pass it.
  if (metadata) {
    gotSize(metadata);
  }
  else {
    getImageSize(blob, gotSize, function(msg) { callback(msg); });
  }

  function gotSize(metadata) {
    // This is the full size of the image in the input coordiate system
    var rawImageWidth = metadata.width;
    var rawImageHeight = metadata.height;
    var fullsize = rawImageWidth * rawImageHeight;
    var rotation = metadata.rotation || 0;
    var mirrored = metadata.mirrored || false;

    // Compute the full size of the image in the output coordinate system
    // I.e. if the image is sideways, swap the width and height
    var rotatedImageWidth, rotatedImageHeight;
    if (rotation === 0 || rotation === 180) {
      rotatedImageWidth = rawImageWidth;
      rotatedImageHeight = rawImageHeight;
    }
    else {
      rotatedImageWidth = rawImageHeight;
      rotatedImageHeight = rawImageWidth;
    }

    // If there is no crop region, use the full, rotated image.
    // If there is a crop region, make sure it fits inside the image.
    if (!cropRegion) {
      cropRegion = {
        left: 0,
        top: 0,
        width: rotatedImageWidth,
        height: rotatedImageHeight
      };
    }
    else {
      if (cropRegion.left < 0 || cropRegion.top < 0 ||
          (cropRegion.left + cropRegion.width > rotatedImageWidth) ||
          (cropRegion.top + cropRegion.height > rotatedImageHeight)) {
        callback('crop region does not fit inside image');
        return;
      }
    }

    // If there is no output size, use the size of the crop region.
    // If there is an output size make sure it is smaller than the crop region
    // and then adjust the crop region as needed so that the aspect ratios
    // match
    if (outputSize === null || outputSize === undefined) {
      outputSize = {
        width: cropRegion.width,
        height: cropRegion.height
      };
    }
    else if (typeof outputSize === 'number') {
      if (outputSize <= 0) {
        callback('outputSize must be positive');
        return;
      }

      if (fullsize < outputSize) {
        // If the full size of the image is less than the image decode size
        // limit, then we can decode the image at full size and use the full
        // crop region dimensions as the output size. Note that we can't just
        // compare the size of the crop region to the output size, because
        // even if we use the #xywh media fragment when decoding the image,
        // gecko still requires memory to decode the full image.
        outputSize = {
          width: cropRegion.width,
          height: cropRegion.height
        };
      }
      else {
        // In this case we need to specify an output size that is small
        // enough that we will be forced below to use #-moz-samplesize
        // to downsample the image while decoding it.
        // Note that we base this samplesize computation on the full size
        // of the image, because we can't use the #-moz-samplesize media
        // fragment along with the #xywh media fragment, so if we're using
        // samplesize we're going to have to decode the full image.
        var ds = Downsample.areaAtLeast(outputSize / fullsize);

        // Now that we've figured out how much the full image will be
        // downsampled, scale the crop region to match.
        outputSize = {
          width: ds.scale(cropRegion.width),
          height: ds.scale(cropRegion.height)
        };
      }
    }

    if (!(outputSize.width > 0 && outputSize.height > 0)) {
      callback('outputSize width and height must be positive');
      return;
    }

    // If the outputSize is bigger than the crop region, just adjust
    // the output size to match.
    if (outputSize.width > cropRegion.width) {
      outputSize.width = cropRegion.width;
    }
    if (outputSize.height > cropRegion.height) {
      outputSize.height = cropRegion.height;
    }

    // How much do we have to scale the crop region in X and Y dimensions
    // to match the output size?
    var scaleX = outputSize.width / cropRegion.width;
    var scaleY = outputSize.height / cropRegion.height;

    // We now adjust the crop region to match the output size. For
    // example if the outputSize is 200x200 and the cropRegion is
    // 600x400, then scaleX is .33 and scaleY is .5. In this case we can
    // leave the height of the crop region alone, but we need to reduce
    // the width of the crop region and adjust the left of the crop region

    if (scaleY > scaleX) {   // adjust width of crop region
      var oldCropWidth = cropRegion.width;
      cropRegion.width = Math.round(outputSize.width / scaleY);
      cropRegion.left += (oldCropWidth - cropRegion.width) >> 1;
    }
    else if (scaleX > scaleY) { // adjust height of crop region
      var oldCropHeight = cropRegion.height;
      cropRegion.height = Math.round(outputSize.height / scaleX);
      cropRegion.top += (oldCropHeight - cropRegion.height) >> 1;
    }

    // Make sure the outputType is valid, if one was specified
    if (outputType && outputType !== JPEG && outputType !== PNG) {
      callback('unsupported outputType: ' + outputType);
      return;
    }

    // Now that we've done these computations, we can pause for a moment
    // to see if there is actually any work that needs doing here. If not
    // we can just pass the input blob unchanged through to the callback
    if (rotation === 0 &&                      // No need to rotate
        !mirrored &&                           // or to mirror the image.
        (!outputType ||                        // Don't care about output type
         blob.type === outputType) &&          // or type is unchanged.
        outputSize.width === rawImageWidth &&  // Doesn't need crop or resize.
        outputSize.height == rawImageHeight) {
      callback(null, blob);
      return;
    }

    // The crop region we've been working with so far is in the output
    // coordinate system: it assumes that any required rotation has been done.
    // In order to know exactly which pixels to extract from the image we
    // need to convert to the unrotated, unmirrored input coordinate system.
    var inputCropRegion;

    // First, handle rotation
    switch (rotation) {
      case 180:
      // The image is upside down. The width and height are the same but
      // the top and left have to change.
      inputCropRegion = {
        left: rawImageWidth - cropRegion.left - cropRegion.width,
        top: rawImageHeight - cropRegion.top - cropRegion.height,
        width: cropRegion.width,
        height: cropRegion.height
      };
      break;

      case 90:
      // sideways: swap width and height and adjust top and left
      inputCropRegion = {
        left: cropRegion.top,
        top: rawImageHeight - cropRegion.left - cropRegion.width,
        width: cropRegion.height,
        height: cropRegion.width
      };
      break;

      case 270:
      // sideways: swap width and height and adjust top and left
      inputCropRegion = {
        left: rawImageWidth - cropRegion.top - cropRegion.height,
        top: cropRegion.left,
        width: cropRegion.height,
        height: cropRegion.width
      };
      break;

      default:
      // the crop region is the same in this case
      inputCropRegion = {
        left: cropRegion.left,
        top: cropRegion.top,
        width: cropRegion.width,
        height: cropRegion.height
      };
      break;
    }

    // Next, adjust for mirroring
    if (mirrored) {
      if (rotation === 90 || rotation === 270) {
        inputCropRegion.top =
          rawImageHeight - inputCropRegion.top - inputCropRegion.height;
      }
      else {
        inputCropRegion.left =
          rawImageWidth - inputCropRegion.left - inputCropRegion.width;
      }
    }

    // In order to decode the image, we create a blob:// URL for it
    var baseURL = URL.createObjectURL(blob);

    // Decoding an image takes a lot of memory and we want to minimize
    // that.  Gecko  allows us to use media fragments with our
    // image URL to specify that we do not want it to decode all of
    // the pixels in the image. The #xywh= media fragment allows us to
    // specify a crop region.  And the #-moz-samplesize= fragment
    // allows us to specify the image should be downsampled while
    // it is decoded (but only works for jpeg images). Unfortunately
    // we can't use both, so we need to decide which one gives us the
    // best memory savings.
    var croppedsize = cropRegion.width * cropRegion.height;
    var sampledsize;
    var downsample;

    // If we decode the image with a #-moz-samplesize media fragment, both
    // the x and y dimensions are reduced by the sample size, so the total
    // number of pixels is reduced by the square of the sample size.
    if (blob.type === JPEG) {
      // What media fragment can we use to downsample the crop region
      // so that it is as small as possible without being smaller than
      // the output size? We know that the output size and crop
      // region have the same aspect ratio now, so we only have to
      // consider one dimension. If we passed in a single number outputSize
      // up above then we Downsample.areaAtLeast() to compute the outputSize.
      // We should now get the same media fragment value here.
      downsample =
        Downsample.sizeNoMoreThan(outputSize.width / cropRegion.width);

      // And if apply that media fragment to the entire image, how big is
      // the result?
      sampledsize = downsample.scale(rawImageWidth) *
        downsample.scale(rawImageHeight);
    }
    else {
      downsample = Downsample.NONE;
      sampledsize = fullsize;
    }

    // Now add the appropriate media fragments to the url
    var url;
    var croppedWithMediaFragment = false, resizedWithMediaFragment = false;

    if (sampledsize < fullsize) {
      // Use a #-moz-samplesize media fragment to downsample while decoding
      url = baseURL + downsample;
      resizedWithMediaFragment = true;
    }
    else if (croppedsize < fullsize) {
      // Use a #xywh media fragment to crop while decoding.
      // This conveniently does the cropping for us, but doesn't actually
      // save any memory because gecko still decodes the image at fullsize
      // before cropping it internally. So we only use this media fragment
      // if we were not going to do any downsampling.
      url = baseURL + '#xywh=' +
        inputCropRegion.left + ',' +
        inputCropRegion.top + ',' +
        inputCropRegion.width + ',' +
        inputCropRegion.height;

      croppedWithMediaFragment = true;
    }
    else {
      // No media fragments in this case
      url = baseURL;
    }

    // Now we've done our calculations and we have an image URL to decode
    var offscreenImage = new Image();
    offscreenImage.src = url;
    offscreenImage.onerror = function() {
      callback('error decoding image: ' + url);
    };
    offscreenImage.onload = gotImage;

    // Called when the image has loaded
    function gotImage() {
      // If we used a media fragment on the image url, we can now
      // check whether the image we got has the expected size. And if it
      // does, we need to adjust the crop region to match the cropped or
      // resized image.
      if (croppedWithMediaFragment) {
        if (offscreenImage.width === inputCropRegion.width &&
            offscreenImage.height === inputCropRegion.height) {
          // We got the cropped size we asked for, so adjust the inputCropRegion
          // so that we don't crop again
          inputCropRegion.left = inputCropRegion.top = 0;
        }
      }
      else if (resizedWithMediaFragment) {
        if (offscreenImage.width < rawImageWidth ||
            offscreenImage.height < rawImageHeight) {
          // If we got an image that is smaller than full size, then the image
          // was downsampled while decoding, but it may still need cropping.
          // We reduce the crop region proportionally to the downsampling.
          var sampleSizeX = rawImageWidth / offscreenImage.width;
          var sampleSizeY = rawImageHeight / offscreenImage.height;
          inputCropRegion.left =
            Math.round(inputCropRegion.left / sampleSizeX);
          inputCropRegion.top =
            Math.round(inputCropRegion.top / sampleSizeY);
          inputCropRegion.width =
            Math.round(inputCropRegion.width / sampleSizeX);
          inputCropRegion.height =
            Math.round(inputCropRegion.height / sampleSizeY);
        }
      }

      // We've decoded the image now, so create a canvas we can copy it into
      var canvas = document.createElement('canvas');
      var destWidth = canvas.width = outputSize.width;
      var destHeight = canvas.height = outputSize.height;

      // Since we're only using the canvas as a way to encode the image
      // we set this willReadFrequently flag as a hint so that we avoid
      // copying the image data to and from the GPU since we don't do any
      // GPU operations on it
      var context = canvas.getContext('2d', { willReadFrequently: true });

      // If the image needs to be rotated or mirrored we have to establish
      // an appropriate transform on the context
      if (rotation || mirrored) {
        // translate so we're rotating around the center
        context.translate(canvas.width / 2, canvas.height / 2);

        if (mirrored) {
          context.scale(-1, 1);
        }

        // rotate
        switch (rotation) {
        case 90:
          context.rotate(Math.PI / 2);
          destWidth = canvas.height;
          destHeight = canvas.width;
          break;
        case 180:
          context.rotate(Math.PI);
          break;
        case 270:
          context.rotate(-Math.PI / 2);
          destWidth = canvas.height;
          destHeight = canvas.width;
          break;
        }

        // And translate back
        if (rotation === 90 || rotation === 270) {
          // For the 90 and 270 case we swap width and height
          context.translate(-canvas.height / 2, -canvas.width / 2);
        }
        else {
          context.translate(-canvas.width / 2, -canvas.height / 2);
        }
      }

      try {
        // Now we copy the image into the canvas.
        // The image has been loaded, but not decoded yet. If the image file
        // appears to be valid and has valid width and height metadata, then
        // the onload event handler will fire. But if the image is corrupt
        // or too big for gecko to decode with the amount of available
        // memory, then this drawImage() call can fail with an exception.
        context.drawImage(offscreenImage,
                          // What part of the image we're drawing
                          inputCropRegion.left, inputCropRegion.top,
                          inputCropRegion.width, inputCropRegion.height,
                          // And what part of the canvas we're drawing it to
                          0, 0, destWidth, destHeight);
      }
      catch(e) {
        callback('Failed to decode image in cropResizeRotate; ' +
                 'image may be corrupt or too large: ' + e);
        return;
      }
      finally {
        // Once the image has been copied, we can release the decoded image
        // memory and the blob URL.
        offscreenImage.src = '';
        URL.revokeObjectURL(baseURL);
      }

      // Finally, encode the image into a blob
      canvas.toBlob(gotEncodedBlob, outputType || JPEG);

      function gotEncodedBlob(blob) {
        // We have the encoded image but before we pass it to the callback
        // we need to free the canvas.
        canvas.width = canvas.height = 0;
        canvas = context = null;
        callback(null, blob);
      }
    }
  }
}
;
define("cropResizeRotate", ["BlobView","getImageSize","jpegMetaDataParser","downsample"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.cropResizeRotate;
    };
}(this)));

define('lib/create-thumbnail-image',['require','exports','module','cropResizeRotate'],function(require, exports, module) {


var cropResizeRotate = require('cropResizeRotate');

/**
 * Create a thumbnail size canvas,
 * copy the <img> or <video> into it
 * cropping the edges as needed to
 * make it fit, and then extract the
 * thumbnail image as a blob and pass
 * it to the callback.
 *
 * @param  {Blob}     imageBlob     [description]
 * @param  {Object}   metadata      [description]
 * @param  {Object}   thumbnailSize [description]
 * @param  {Function} done          [description]
 */
module.exports = function(imageBlob, metadata, thumbnailSize, done) {
  cropResizeRotate(imageBlob, null, thumbnailSize, null, metadata,
    function(error, resizedBlob) {

      // If we couldn't resize or rotate it, use the original
      if (error) {
        console.error('Error while resizing image: ' + error);
        done(imageBlob);
        return;
      }

      done(resizedBlob);
    }
  );
};

});

define('lib/prepare-preview-blob',['require','exports','module','jpegMetaDataParser'],function(require, exports, module) {


/**
 * Module Dependencies
 */

var parseJpegMetadata = require('jpegMetaDataParser');

/**
 * Exports
 */

module.exports = function(blob, done) {
  parseJpegMetadata(blob, onJpegParsed);

  function onJpegParsed(metadata) {
    metadata.blob = blob;

    if (!metadata.preview) {
      done(metadata);
      return;
    }

    // If we found an EXIF preview,
    // and can determine its size, then
    // we can display it instead of the
    // big image and save memory and time.
    var start = metadata.preview.start;
    var end = metadata.preview.end;
    var previewBlob = blob.slice(start, end, 'image/jpeg');
    parseJpegMetadata(previewBlob, onSuccess, onError);

    // If we parsed the preview image, add its
    // dimensions to the metadata.preview
    // object, and then let the MediaFrame
    // object display the preview instead of
    // the full-size image.
    function onSuccess(previewMetadata) {
       metadata.preview.width = previewMetadata.width;
       metadata.preview.height = previewMetadata.height;
       done(metadata);
     }

    // If we couldn't parse the preview image,
    // just display full-size.
    function onError() {
      done(metadata);
    }
  }
};

});

define('lib/resize-image-and-save',['require','exports','module','lib/storage','cropResizeRotate'],function(require, exports, module) {


var Storage = require('lib/storage');
var cropResizeRotate = require('cropResizeRotate');

/**
 * Exports
 */

module.exports = function(options, done) {
  var blob = options.blob;
  var outputSize = options.width && options.height ?
    {
      width: options.width,
      height: options.height
    } : options.size || null;

  cropResizeRotate(blob, null, outputSize, null, function(error, resizedBlob) {

    // If we couldn't resize or rotate it, use the original
    if (error) {
      console.error('Error while resizing image: ' + error);
      done(blob);
      return;
    }

    // We need to send a file-backed blob as the result of a pick activity
    // (see bug 975599) so we'll overwrite the old blob with the new one.
    // This means that the image stored will actually match the one passed
    // to the app that initiated the pick activity. We delete the old file,
    // then save the new blob with the same name. Then we read the file and
    // pass that to the callback.
    if (resizedBlob === blob) {
      done(blob);
      return;
    }

    var storage = new Storage();
    storage.deleteImage(blob.name);
    storage.addImage(resizedBlob, {
      filepath: blob.name
    }, function(filepath, absolutePath, fileBlob) {
      done(fileBlob);
    });
  });
};

});
define('lib/string-utils',['require'],function(require) {
  

  var StringUtils = function StringUtils() {};

  StringUtils.toCamelCase = function(str) {

    // Convert SNAKE_CASE strings to hyphenated
    str = str.toLowerCase().replace(/_/g, '-');
    return str.replace(/-([a-z])/g, function(g) {
      return g[1].toUpperCase();
    });
  };

  StringUtils.toHyphenate = function(str) {
    return str.replace(/([a-z][A-Z])/g, function(g) {
      return g[0] + '-' + g[1].toLowerCase();
    });
  };

  StringUtils.lastPathComponent = function(path) {
    var pathComponents = path.split('/');
    return pathComponents[pathComponents.length - 1];
  };

  StringUtils.prototype = {
    constructor: StringUtils
  };

  return StringUtils;
});
//XXX: Waiting for the window.showModalDialog support in B2G



var CustomDialog = (function() {

  var screen = null;
  var dialog = null;
  var header = null;
  var message = null;
  var yes = null;
  var no = null;

  return {
    hide: function dialog_hide() {
      if (screen === null)
        return;

      document.body.removeChild(screen);
      screen = null;
      dialog = null;
      header = null;
      message = null;
      yes = null;
      no = null;
    },

    /**
    * Method that shows the dialog
    * @param  {String} title the title of the dialog. null or empty for
    *                  no title. or you can give a object with more options
    *                  like {icon: path or empty string, title: String}.
    * @param  {String} msg message for the dialog. give a object like the
    *                  title to enable more options:
    *                  {icon: path or empty string, message: String}.
    * @param  {Object} cancel {title, callback} object when confirm.
    * @param  {Object} confirm {title, callback} object when cancel.
    */
    show: function dialog_show(title, msg, cancel, confirm) {
      if (screen === null) {
        screen = document.createElement('form');
        screen.setAttribute('role', 'dialog');
        screen.setAttribute('data-type', 'confirm');
        screen.id = 'dialog-screen';

        dialog = document.createElement('section');
        screen.appendChild(dialog);

        // Create a reusable function to decorate elements with all
        // possible options, instead of scattering similar code about
        // everywhere.
        //
        // It's also possible to be extended with more usable decorating
        // options and elements.
        //
        // 'title'|'message' -> Object|String -> dialog -> the element
        // -> the decorated element
        var decorateWithOptions = function cd_decorateWithOptions(type, options,
                                                                  elm, dialog) {
          if ('string' === typeof options) {
            elm.textContent = options;
            return elm;
          }

          var text = options[type];
          var icon = options.icon;
          elm.textContent = text;

          if (icon && '' !== icon) {
            var iconImg = new Image();
            iconImg.src = icon;
            iconImg.classList.add('custom-dialog-' + type + '-icon');

            // Icons usually insert as the first element.
            elm.insertBefore(iconImg, elm.firstChild);
          }
          // More decorating options goes here.

          return elm;
        };

        header = document.createElement('h1');
        header.id = 'dialog-title';
        if (title && title != '') {
          header = decorateWithOptions('title', title, header, dialog);
        }
        dialog.appendChild(header);

        message = document.createElement('p');
        message.id = 'dialog-message';
        message = decorateWithOptions('message', msg, message, dialog);
        dialog.appendChild(message);

        var menu = document.createElement('menu');
        menu.dataset['items'] = 1;

        no = document.createElement('button');

        // The default type of the button element is "Submit",
        // and form submit in system app would make system app reload.
        no.type = 'button';

        var noText = document.createTextNode(cancel.title);
        no.appendChild(noText);
        no.id = 'dialog-no';
        no.addEventListener('click', clickHandler);
        menu.appendChild(no);

        if (confirm) {
          menu.dataset['items'] = 2;
          yes = document.createElement('button');

          // The default type of button element is "Submit",
          // and form submit in system app would make system app reload.
          yes.type = 'button';

          var yesText = document.createTextNode(confirm.title);
          yes.appendChild(yesText);
          yes.id = 'dialog-yes';

          //confirm can be with class "danger" or "recommend"
          //the default is "danger"
          yes.className = confirm.recommend ? 'recommend' : 'danger';

          yes.addEventListener('click', clickHandler);
          menu.appendChild(yes);
        }
        else { // 1 button, should be full.
          no.classList.add('full');
        }

        screen.appendChild(menu);

        document.body.appendChild(screen);
      }

      // Make the screen visible
      screen.classList.add('visible');

      // This is the event listener function for the buttons
      function clickHandler(evt) {

        // Hide the dialog
        screen.classList.remove('visible');

        // Call the appropriate callback, if it is defined
        if (evt.target === yes && confirm.callback) {
          confirm.callback();
        } else if (evt.target === no && cancel.callback) {
          cancel.callback();
        }
      }
    }
  };
}());


define("CustomDialog", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.CustomDialog;
    };
}(this)));

define('controllers/preview-gallery',['require','exports','module','debug','lib/bind-all','views/preview-gallery','lib/create-thumbnail-image','lib/prepare-preview-blob','lib/resize-image-and-save','lib/string-utils','CustomDialog'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:preview-gallery');
var bindAll = require('lib/bind-all');
var PreviewGalleryView = require('views/preview-gallery');
var createThumbnailImage = require('lib/create-thumbnail-image');
var preparePreview = require('lib/prepare-preview-blob');
var resizeImageAndSave = require('lib/resize-image-and-save');
var StringUtils = require('lib/string-utils');
var CustomDialog = require('CustomDialog');

/**
 * Exports
 */

module.exports = function(app) { return new PreviewGalleryController(app); };
module.exports.PreviewGalleryController = PreviewGalleryController;

function PreviewGalleryController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.settings = app.settings;
  this.storage = this.app.storage;
  this.resizeImageAndSave = resizeImageAndSave;
  this.bindEvents();
  this.configure();
  debug('initialized');
}

PreviewGalleryController.prototype.bindEvents = function() {
  this.storage.on('itemdeleted', this.onItemDeleted);
  this.app.on('preview', this.openPreview);
  this.app.on('newmedia', this.onNewMedia);
  this.app.on('blur', this.onBlur);
  debug('events bound');
};

PreviewGalleryController.prototype.configure = function() {
  this.currentItemIndex = 0;
  this.items = [];            // All the pictures and videos we know about
  this.thumbnailItem = null;  // The item that currently has a thumbnail

  var dpr = window.devicePixelRatio;
  this.thumbnailSize = {
    width: this.settings.previewGallery.get('thumbnailWidth') * dpr,
    height: this.settings.previewGallery.get('thumbnailHeight') * dpr
  };
};

PreviewGalleryController.prototype.openPreview = function() {
  // If we're handling a pick activity the preview gallery is not used
  if (this.app.activity.active) {
    return;
  }

  if (this.view) {
    return;
  }

  // Check whether the MediaFrame should limit the pixel size.
  var maxPreviewSize =
    this.settings.previewGallery.get('limitMaxPreviewSize') ?
    window.CONFIG_MAX_IMAGE_PIXEL_SIZE : 0;

  this.view = new PreviewGalleryView();
  this.view.maxPreviewSize = maxPreviewSize;
  this.view.render().appendTo(this.app.el);

  this.view.on('click:gallery', this.onGalleryButtonClick);
  this.view.on('click:share', this.shareCurrentItem);
  this.view.on('click:delete', this.deleteCurrentItem);
  this.view.on('click:back', this.closePreview);
  this.view.on('swipe', this.handleSwipe);
  this.view.on('click:options', this.onOptionsClick);

  // If lockscreen is locked, hide all control buttons
  var secureMode = this.app.inSecureMode;
  this.view.set('secure-mode', secureMode);
  this.view.open();

  this.previewItem();
  this.app.emit('previewgallery:opened');
};

PreviewGalleryController.prototype.closePreview = function() {
  // If the item that we have displayed a thumbnail for is no longer the
  // first item in the array of items, then update the thumbnail. This can
  // happen if the user deletes items after previewing them.
  if (this.thumbnailItem !== this.items[0]) {
    this.updateThumbnail();
  }

  if (this.view) {
    this.currentItemIndex = 0;
    this.view.close();
    this.view.destroy();
    this.view = null;
  }

  this.app.emit('previewgallery:closed');
};

/**
 * Open the gallery app when the
 * gallery button is pressed.
 *
 * @private
 */
PreviewGalleryController.prototype.onGalleryButtonClick = function() {
  // Can't launch the gallery if the lockscreen is locked.
  // The button shouldn't even be visible in this case, but
  // let's be really sure here.
  if (this.app.inSecureMode) {
    return;
  }

  var MozActivity = window.MozActivity;

  // Launch the gallery with an activity
  this.mozActivity = new MozActivity({
    name: 'browse',
    data: { type: 'photos' }
  });
};

PreviewGalleryController.prototype.onOptionsClick = function() {
  if (this.app.inSecureMode) {
    return;
  }

  this.view.showOptionsMenu();
};


PreviewGalleryController.prototype.shareCurrentItem = function() {
  if (this.app.inSecureMode) {
    return;
  }

  var index = this.currentItemIndex;
  var item = this.items[index];
  var type = item.isVideo ? 'video/*' : 'image/*';
  var filename = StringUtils.lastPathComponent(item.filepath);

  var launchShareActivity = function(blob) {
    var activity = new window.MozActivity({
      name: 'share',
      data: {
        type: type,
        number: 1,
        blobs: [blob],
        filenames: [filename],
        filepaths: [item.filepath] /* temporary hack for bluetooth app */
      }
    });
    activity.onerror = function(e) {
      console.warn('Share activity error:', activity.error.name);
    };
  };

  if (item.isVideo) {
    launchShareActivity(item.blob);
    return;
  }

  var self = this;

  this.stopItemDeletedEvent = true;

  // Resize the image to the maximum pixel size for share activities.
  // If no maximum is specified (value is `0`), then simply rotate
  // (if needed) and re-save the image prior to launching the activity.
  this.resizeImageAndSave({
    blob: item.blob,
    size: this.settings.activity.get('maxSharePixelSize')
  }, function(resizedBlob) {
    self.stopItemDeletedEvent = false;
    launchShareActivity(resizedBlob);
  });
};

/**
 * Delete the current item
 * when the delete button is pressed.
 * @private
 */
PreviewGalleryController.prototype.deleteCurrentItem = function() {
  // The button should be gone, but hard exit from this function
  // just in case.
  if (this.app.inSecureMode) { return; }

  var index = this.currentItemIndex;
  var item = this.items[index];
  var filepath = item.filepath;
  var msg;
  var self = this;

  if (item.isVideo) {
    msg = navigator.mozL10n.get('delete-video?');
  }
  else {
    msg = navigator.mozL10n.get('delete-photo?');
  }

  CustomDialog.show('',
                    msg,
                    { title: navigator.mozL10n.get('cancel'),
                      callback: closeDialog },
                    { title: navigator.mozL10n.get('delete'),
                      callback: deleteItem,
                      recommend: false });

  function closeDialog() {
    CustomDialog.hide();
  }

  function deleteItem() {
    CustomDialog.hide();

    self.updatePreviewGallery(index);

    // Actually delete the file
    if (item.isVideo) {
      self.storage.deleteVideo(filepath);
    } else {
      self.storage.deleteImage(filepath);
    }
  }
};

/**
 * Update the preview with the latest recent item
 * after deleting images/videos.
 *
 * @param  {String} index
 */
PreviewGalleryController.prototype.updatePreviewGallery = function(index) {
  // Remove the item from the array of items
  this.items.splice(index, 1);

    // If there are no more items, go back to the camera
  if (this.items.length === 0) {
    this.closePreview();
  }
  else {
    if (index == this.items.length) {
      this.currentItemIndex = this.items.length - 1;
    }

    var isOpened = this.view ? true : false;
    if (isOpened) {
      this.previewItem();
    }
  }
};

/**
 * To Do: Image Swipe Transition
 */
PreviewGalleryController.prototype.handleSwipe = function(direction) {
  if (direction === 'left') {
    this.next();
  }
  else if (direction === 'right') {
    this.previous();
  }
};

PreviewGalleryController.prototype.next = function() {
  if (this.currentItemIndex < this.items.length - 1) {
    this.currentItemIndex += 1;
    this.previewItem();
  }
};

PreviewGalleryController.prototype.previous = function() {
  if (this.currentItemIndex > 0) {
    this.currentItemIndex -= 1;
    this.previewItem();
  }
};

PreviewGalleryController.prototype.onNewMedia = function(item) {
  // If we're handling a pick activity the preview gallery is not used
  if (this.app.activity.active) {
    return;
  }

  var self = this;

  if (item.isVideo) {
    // If the new media is video, use it as-is
    addNewMedia(item);
  } else {
    // If it is a photo, find its EXIF preview first
    preparePreview(item.blob, function(metadata) {
      metadata.blob = item.blob;
      metadata.filepath = item.filepath;
      addNewMedia(metadata);
    });
  }

  function addNewMedia(item) {
    self.items.unshift(item);
    self.updateThumbnail();
  }
};

PreviewGalleryController.prototype.previewItem = function() {
  var index = this.currentItemIndex;
  var item = this.items[index];
  this.view.updateCountText(index + 1, this.items.length);

  if (item.isVideo) {
    this.view.showVideo(item);
  } else {
    this.view.showImage(item);
  }
};

/**
 * Delete and update items in the preview gallery
 * when images/videos are deleted by others
 *
 * @param  {Object} filepath
 */
PreviewGalleryController.prototype.onItemDeleted = function(data) {

  // Check if this event is being stopped such as in the case
  // of resizing an image for a share activity.
  if (this.stopItemDeletedEvent) {
    return;
  }

  var deleteIdx = -1;
  var deletedFilepath = data.path;

  // find the item in items
  for (var n = 0; n < this.items.length; n++) {
    if (this.items[n].filepath === deletedFilepath) {
      deleteIdx = n;
      break;
    }
  }

  // Exit when item not found
  if (n === this.items.length) { return; }

  this.updatePreviewGallery(deleteIdx);
};

/**
 * As a privacy feature, when the camera app is used from the lockscreen
 * and the lockscreen is actually locked with a passcode, we don't want
 * the camera to retain any state from one use to the next. So if the
 * camera is hidden (i.e. if the phone returns to the lockscreen) we
 * forget our state.  In practice, it appears that the system app actually
 * kills the camera when this happens, so this code is redundant.
 */
PreviewGalleryController.prototype.onBlur = function() {
  if (this.app.inSecureMode) {
    this.configure();          // Forget all stored images
    this.updateThumbnail();    // Get rid of any thumbnail
  }
  this.closePreview();
};

PreviewGalleryController.prototype.updateThumbnail = function() {
  var self = this;
  var media = this.thumbnailItem = this.items[0] || null;
  var blob;

  if (media === null) {
    this.app.emit('newthumbnail', null);
    return;
  }

  if (media.isVideo) {

    // If it is a video we can create a thumbnail from the poster image
    blob = media.poster.blob;
  } else {

    // If it is a photo we want to use the EXIF preview rather than
    // decoding the whole image if we can.
    if (media.preview) {

      // The Tarako may produce EXIF previews that have the wrong
      // aspect ratio and are distorted. Check for that, and if the
      // aspect ratio is not right, then create a thumbnail from the
      // full size image
      var fullRatio = media.width / media.height;
      var previewRatio = media.preview.width / media.preview.height;

      // If aspect ratios match, create thumbnail from EXIF preview
      if (Math.abs(fullRatio - previewRatio) < 0.01) {
        blob = media.blob.slice(media.preview.start, media.preview.end,
                                'image/jpeg');
      }
    }

    // If a thumbnail couldn't be obtained from the EXIF preview,
    // use the full image
    if (!blob) {
      blob = media.blob;
    }
  }

  createThumbnailImage(blob, media, this.thumbnailSize, gotThumbnail);

  function gotThumbnail(blob) {
    self.app.emit('newthumbnail', blob);
  }
};

});

/*global define*/

define('lib/find',['require'],function(require) {
  

  return function(query, el) {
    el = el || document;
    return el.querySelector(query);
  };
});

define('views/overlay',['require','exports','module','debug','vendor/view','lib/find','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:overlay');
var View = require('vendor/view');
var find = require('lib/find');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  className: 'overlay',

  initialize: function(options) {
    this.data('type', options.type);
    this.data('closable', options.closable);
    this.render(options.data);
  },

  render: function(data) {

    // Inject HTML
    this.el.innerHTML = this.template(data);

    // Pick out elements
    this.els.buttons = {
      close: find('.js-close-btn', this.el)
    };

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.els.buttons.close, 'click', this.onButtonClick);
    return this;
  },

  template: function(data) {
    /*jshint maxlen:false*/
    return '<form role="dialog" data-type="confirm">' +
      '<section>' +
        '<h1 class="overlay-title">' + data.title + '</h1>' +
        '<p id="overlay-text">' + data.body + '<p>' +
      '</section>' +
      '<menu class="overlay-menu-close">' +
        '<button class="full js-close-btn" type="button" name="close-btn">' +
        data.closeButtonText + '</button>' +
      '</menu>' +
    '</form>';
  },

  data: function(key, value) {
    switch (arguments.length) {
      case 1: return this.el.getAttribute('data-' + key);
      case 2: this.el.setAttribute('data-' + key, value);
    }
  },

  onButtonClick: function(event) {
    var el = event.currentTarget;
    var name = el.getAttribute('name');
    this.emit('click:' + name);
  }
});

});

define('controllers/overlay',['require','exports','module','debug','views/overlay','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:overlay');
var Overlay = require('views/overlay');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new OverlayController(app); };
module.exports.OverlayController = OverlayController;

/**
 * Initialize a new `OverlayController`
 *
 * @param {App} app
 */
function OverlayController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.activity = app.activity;
  this.storage = app.storage;
  this.batteryOverlay = null;
  this.storageOverlay = null;
  this.bindEvents();
  debug('initialized');
}

OverlayController.prototype.bindEvents = function() {
  this.storage.on('statechange', this.onStorageStateChange);
  this.app.on('change:batteryStatus', this.onBatteryStatusChange);
};

/**
 * Respond to storage `statechange`
 * events by inserting or destroying
 * overlays from the app.
 *
 * @param  {String} value  ['nospace'|'shared'|'unavailable'|'available']
 */
OverlayController.prototype.onStorageStateChange = function(value) {
  debug('storage state change: \'%s\'', value);

  if (this.storageOverlay) {
    this.storageOverlay.destroy();
    this.storageOverlay = null;
  }

  if (value !== 'available') {
    this.storageOverlay = this.createOverlay(value);
  }
};

/**
 * Respond to battery `statuschange`
 * events by inserting or destroying
 * overlays from the app.
 *
 * @param  {String} status  ['shutdown'|'critical'|'verylow'|'low']
 */
OverlayController.prototype.onBatteryStatusChange = function(status) {
  debug('battery state change: \'%s\'', status);

  if (this.batteryOverlay) {
    this.batteryOverlay.destroy();
    this.batteryOverlay = null;
  }

  if (status === 'shutdown') {
    this.batteryOverlay = this.createOverlay(status);
  }
};

OverlayController.prototype.createOverlay = function(type) {
  var data = this.getOverlayData(type);
  var activity = this.activity;

  if (!data) {
    return;
  }

  var isClosable = activity.active;
  var overlay = new Overlay({
    type: type,
    closable: isClosable,
    data: data
  });

  overlay
    .appendTo(document.body)
    .on('click:close-btn', function() {
      activity.cancel();
    });

  debug('inserted \'%s\' overlay', type);
  return overlay;
};

/**
 * Get the overlay data required
 * to render a specific type of overlay.
 *
 * @param  {String} type
 * @return {Object}
 */
OverlayController.prototype.getOverlayData = function(type) {
  var l10n = navigator.mozL10n;
  var data = {};

  switch (type) {
    case 'unavailable':
      data.title = l10n.get('nocard2-title');
      data.body = l10n.get('nocard3-text');
    break;
    case 'nospace':
      data.title = l10n.get('nospace2-title');
      data.body = l10n.get('nospace2-text');
    break;
    case 'shared':
      data.title = l10n.get('pluggedin-title');
      data.body = l10n.get('pluggedin-text');
    break;
    case 'shutdown':
      data.title = l10n.get('battery-shutdown-title');
      data.body = l10n.get('battery-shutdown-text');
    break;
    default:
      return false;
  }

  data.closeButtonText = l10n.get('close-button');

  return data;
};

});

define('views/confirm',['require','exports','module','debug','lib/panzoom','MediaFrame','vendor/view','lib/bind','lib/orientation'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:confirm');
var addPanAndZoomHandlers = require('lib/panzoom');
var MediaFrame = require('MediaFrame');
var View = require('vendor/view');
var bind = require('lib/bind');
var orientation = require('lib/orientation');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'confirm',

  initialize: function() {
    this.on('destroy', this.onDestroy);
  },

  render: function() {
    var l10n = navigator.mozL10n;

    this.el.innerHTML = this.template({
      retake: l10n.get('retake-button'),
      select: l10n.get('select-button')
    });

    // Get elements
    this.els.mediaFrame = this.find('.js-media-frame');
    this.els.retake = this.find('.js-retake');
    this.els.select = this.find('.js-select');

    // Disable buttons on this view by default
    // until an image/video is displayed
    this.disableButtons();

    // Initialize the MediaFrame component
    this.setupMediaFrame();

    // Clean up
    delete this.template;
    
    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.els.retake, 'click', this.onButtonClick);
    bind(this.els.select, 'click', this.onButtonClick);
    return this;
  },

  setupMediaFrame: function() {
    this.mediaFrame = new MediaFrame(this.els.mediaFrame, true,
                                     this.maxPreviewSize);
    addPanAndZoomHandlers(this.mediaFrame);
    window.addEventListener('resize', this.onResize);
    return this;
  },

  clearMediaFrame: function() {
    this.mediaFrame.clear();
    this.disableButtons();
  },

  hide: function() {
    this.el.classList.add('hidden');
    orientation.lock();
  },

  show: function() {
    this.el.classList.remove('hidden');
    orientation.unlock();
  },

  disableButtons: function() {
    this.els.retake.setAttribute('disabled', true);
    this.els.select.setAttribute('disabled', true);
  },

  enableButtons: function() {
    this.els.retake.removeAttribute('disabled');
    this.els.select.removeAttribute('disabled');
  },

  showImage: function(image) {
    this.enableButtons();
    this.mediaFrame.displayImage(
      image.blob,
      image.width,
      image.height,
      image.preview,
      image.rotation,
      image.mirrored);
    return this;
  },

  showVideo: function(video) {
    this.enableButtons();
    this.mediaFrame.displayVideo(
      video.blob,
      video.poster.blob,
      video.width,
      video.height,
      video.rotation);
    return this;
  },

  template: function(data) {
    /*jshint maxlen:false*/
    return '<div class="confirm-media-frame js-media-frame"></div>' +
    '<footer id="confirm-controls" class="confirm-controls">' +
      '<button class="retake-button js-retake" name="retake">' +
      data.retake + '</button>' +
      '<button class="select-button test-confirm-select js-select" name="select">' +
      data.select + '</button>' +
    '</footer>';
  },

  onButtonClick: function(event) {
    var el = event.currentTarget;
    var name = el.getAttribute('name');
    this.emit('click:' + name);
  },

  onResize: function() {
    this.mediaFrame.resize();
    if (this.mediaFrame.displayingVideo) {
      this.mediaFrame.video.setPlayerSize();
    }
  },

  onDestroy: function() {
    window.removeEventListener('resize', this.onResize);
    this.mediaFrame.clear();
  }
});

});

define('controllers/confirm',['require','exports','module','lib/prepare-preview-blob','debug','lib/resize-image-and-save','views/confirm','lib/bind-all'],function(require, exports, module) {
/*jshint laxbreak:true*/



/**
 * Module Dependencies
 */

var prepareBlob = require('lib/prepare-preview-blob');
var debug = require('debug')('controller:confirm');
var resizeImageAndSave = require('lib/resize-image-and-save');
var ConfirmView = require('views/confirm');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(options) { return new ConfirmController(options); };
module.exports.ConfirmController = ConfirmController;

/**
 * Initialize a new `ConfirmController`
 *
 * @param {Object} options
 */
function ConfirmController(app) {
  this.app = app;
  this.settings = app.settings;
  this.activity = app.activity;
  this.camera = app.camera;
  this.container = app.el;

  // Allow these dependencies
  // to be injected if need be.
  this.ConfirmView = app.ConfirmView || ConfirmView;
  this.prepareBlob = app.prepareBlob || prepareBlob;

  bindAll(this);
  this.bindEvents();
  debug('initialized');
}

ConfirmController.prototype.renderView = function() {
  if (!this.activity.active) {
    return;
  }

  if (this.confirmView) {
    this.confirmView.show();
    return;
  }

  // Check whether the MediaFrame should limit the pixel size.
  var maxPreviewSize =
    this.settings.previewGallery.get('limitMaxPreviewSize') ?
    window.CONFIG_MAX_IMAGE_PIXEL_SIZE : 0;

  this.confirmView = new this.ConfirmView();
  this.confirmView.maxPreviewSize = maxPreviewSize;
  this.confirmView.render().appendTo(this.container);

  this.confirmView.on('click:select', this.onSelectMedia);
  this.confirmView.on('click:retake', this.onRetakeMedia);
};

/**
 * Bind callbacks to required events.
 *
 */
ConfirmController.prototype.bindEvents = function() {

  // Render/Show the view on the `newimage` and `newvideo` events
  // since they are fired immediately when tapping 'Capture'/'Stop'.
  // This prevents the 'Capture'/'Stop' button from being able to be
  // triggered multiple times before the confirm view appears.
  this.camera.on('newimage', this.renderView);
  this.camera.on('newvideo', this.renderView);

  // Update the MediaFrame contents with the image/video upon
  // receiving the `newmedia` event. This event is slightly delayed
  // since it waits for the storage callback to complete.
  this.app.on('newmedia', this.onNewMedia);
};

/**
 * When inside a 'pick' activity
 * will present the user with a
 * confirm overlay where they can
 * decide to 'select' or 'retake'
 * the photo or video
 *
 * @param  {Object} data
 *
 */
ConfirmController.prototype.onNewMedia = function(newMedia) {
  if (!this.activity.active) { return; }

  this.newMedia = newMedia;
  if (newMedia.isVideo) { // Is video
    this.confirmView.showVideo(newMedia);
  } else { // Is Image
    this.prepareBlob(this.newMedia.blob, this.confirmView.showImage);
  }
};

ConfirmController.prototype.onSelectMedia = function() {
  var activity = this.activity;
  var needsResizing;
  var media = {
    blob: this.newMedia.blob
  };

  if (this.newMedia.isVideo) { // Is Video
    media.type = 'video/3gpp';
    media.poster = this.newMedia.poster.blob;
  } else { // Is Image
    media.type = 'image/jpeg';
    needsResizing = activity.data.width || activity.data.height;
    debug('needs resizing: %s', needsResizing);
    if (needsResizing) {
      resizeImageAndSave({
        blob: media.blob,
        width: activity.data.width,
        height: activity.data.height
      }, function(resizedBlob) {
        media.blob = resizedBlob;
        activity.postResult(media);
      });
      return;
    }
  }
  activity.postResult(media);
};

ConfirmController.prototype.onRetakeMedia = function() {
  this.confirmView.hide();
  this.confirmView.clearMediaFrame();
};

});

define('lib/picture-sizes/format-picture-sizes',['require','exports','module'],function(require, exports, module) {


/**
 * Returns a formatted list of picture
 * sizes ready to be set as setting options.
 *
 * Options:
 *
 *   - `maxPixelSize {Number}`
 *   - `exclude {Array}`
 *   - `mp {String}`
 *
 * @param  {Array} sizes
 * @param  {Object} options
 * @return {Array}
 */
module.exports = function(sizes, options) {
  var maxPixelSize = options && options.maxPixelSize;
  var exclude = options && options.exclude || [];
  var MP = options && options.mp || 'MP';
  var formatted = [];

  sizes.forEach(function(size) {
    var w = size.width;
    var h = size.height;
    var key = w + 'x' + h;
    var pixelSize = w * h;

    // Don't include picture size if marked as excluded
    if (exclude.indexOf(key) > -1) { return; }

    // Don't include pictureSizes above the maxPixelSize limit
    if (maxPixelSize && pixelSize > maxPixelSize) { return; }

    size.aspect = getAspect(w, h);
    size.mp = getMP(w, h);

    // Don't show 0MP
    var mp = size.mp ? size.mp + MP + ' ' : '';

    formatted.push({
      key: key,
      title: mp + w + 'x' + h + ' ' + size.aspect,
      pixelSize: pixelSize,
      data: size
    });
  });

  // Sort by pixel size
  formatted.sort(function(a, b) { return b.pixelSize - a.pixelSize; });
  return formatted;
};

/**
 * Returns rounded mega-pixel value.
 *
 * @param  {Number} w
 * @param  {Number} h
 * @return {Number}
 */
function getMP(w, h) {
  return Math.round((w * h) / 1000000);
}

/**
 * Returns aspect ratio string.
 *
 * Makes use of Euclid's GCD algorithm,
 * http://en.wikipedia.org/wiki/Euclidean_algorithm
 *
 * @param  {Number} w
 * @param  {Number} h
 * @return {String}
 */
function getAspect(w, h) {
  var gcd = function(a, b) { return (b === 0) ? a : gcd(b, a % b); };
  var divisor = gcd(w, h);
  return (w / divisor) + ':' + (h / divisor);
}

});

define('lib/format-recorder-profiles',['require','exports','module'],function(require, exports, module) {


/**
 * Returns a formatted list of recorder
 * profiles ready to be set as setting options.
 *
 * Options:
 *
 *   - `exclude {Array}`
 *
 * @param  {Object} profiles
 * @param  {Object} options
 * @return {Array}
 */
module.exports = function(profiles, options) {
  var exclude = options && options.exclude || [];
  var formatted = [];
  var pixelSize;
  var profile;
  var video;

  for (var key in profiles) {
    profile = profiles[key];
    video = profile.video;

    // Don't include profile if marked as excluded
    if (exclude.indexOf(key) > -1) { continue; }

    pixelSize = video.width * video.height;

    formatted.push({
      key: key,
      title: key + ' ' + video.width + 'x' + video.height,
      pixelSize: pixelSize,
      raw: profile
    });
  }

  formatted.sort(function(a, b) { return b.pixelSize - a.pixelSize; });
  return formatted;
};

});
define('views/setting-options',['require','exports','module','debug','vendor/attach','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:setting-options');
var attach = require('vendor/attach');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'setting-options',

  initialize: function(options) {
    this.model = options.model;
    this.l10n = options.l10n || navigator.mozL10n;
    this.on('destroy', this.onDestroy);
    attach(this.el, 'click', 'li', this.onOptionClick);
    attach(this.el, 'click', '.js-back', this.firer('click:back'));
    this.model.on('change:selected', this.onSelectedChange);
    debug('initialized');
  },

  onDestroy: function() {
    this.model.off('change:selected', this.onSelectedChange);
  },

  onOptionClick: function(event, el) {
    var key = el.getAttribute('data-key');
    this.emit('click:option', key, this.model);
  },

  onSelectedChange: function(key) {
    var next = this.els[key];
    this.els.selected.classList.remove('selected');
    next.classList.add('selected');
    this.els.selected = next;
  },

  render: function() {
    var data = this.model.get();
    this.selectedKey = data.selected;
    this.el.innerHTML = this.template(data);
    this.els.ul = this.find('.js-list');
    data.options.forEach(this.renderOption);

    // Clean up
    delete this.template;

    debug('rendered');
    return this;
  },

  renderOption: function(option) {
    var li = document.createElement('li');
    var isSelected = option.key === this.selectedKey;

    li.textContent = this.localize(option.title);
    li.setAttribute('data-key', option.key);
    li.className = 'setting-option icon-tick';
    this.els.ul.appendChild(li);
    this.els[option.key] = li;

    if (isSelected) {
      li.classList.add('selected');
      this.els.selected = li;
    }
  },

  localize: function(value) {
    return this.l10n.get(value) || value;
  },

  template: function(data) {
    return '<div class="inner">' +
      '<h2 class="settings_title icon-back-arrow js-back">' +
      this.localize(data.header) + '</h2>' +
      '<div class="settings_items"><ul class="inner js-list"></ul></div>' +
    '</div>';
  }
});

});

define('views/setting',['require','exports','module','debug','vendor/view','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:setting');
var View = require('vendor/view');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  tag: 'li',
  name: 'setting',

  initialize: function(options) {
    this.l10n = options.l10n || navigator.mozL10n;
    this.model = options.model;
    this.model.on('change', this.render);
    this.on('destroy', this.onDestroy);
    this.el.classList.add(this.model.get('icon'));
    bind(this.el, 'click', this.onClick);
  },

  onClick: function() {
    this.emit('click', this);
  },

  onDestroy: function() {
    this.model.off('change', this.render);
  },

  render: function() {
    var data = this.model.get();

    data.selected = this.model.selected();
    data.value = data.selected && data.selected.title;

    this.el.innerHTML = this.template(data);
    debug('rendered item %s', data.key);

    // Clean up
    delete this.template;

    debug('rendered');
    return this;
  },

  localize: function(value) {
    return this.l10n.get(value) || value;
  },

  template: function(data) {
    return '<div class="setting_text">' +
      '<h4 class="setting_title">' + this.localize(data.title) + '</h4>' +
      '<h5 class="setting_value">' + this.localize(data.value) + '</h5>' +
    '</div>';
  },
});

});

define('views/settings',['require','exports','module','debug','views/setting-options','views/setting','vendor/view','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:settings');
var OptionsView = require('views/setting-options');
var SettingView = require('views/setting');
var View = require('vendor/view');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'settings',

  initialize: function(options) {
    this.OptionsView = options.OptionsView || OptionsView;
    this.l10n = options.l10n || navigator.mozL10n;
    this.items = options.items;
    this.children = [];
    this.on('destroy', this.onDestroy);
    bind(this.el, 'click', this.onClick);
  },

  onClick: function(e) {
    e.stopPropagation();
  },

  onItemClick: function(view) {
    this.showSetting(view.model);
  },

  showSetting: function(model) {
    this.optionsView = new this.OptionsView({ model: model })
      .render()
      .appendTo(this.els.pane2)
      .on('click:option', this.firer('click:option'))
      .on('click:back', this.goBack);

    this.showPane(2);
  },

  onDestroy: function() {
    this.children.forEach(this.destroyChild);
    this.destroyOptionsView();
    debug('destroyed');
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.items = this.find('.js-items');
    this.els.pane2 = this.find('.js-pane-2');
    this.els.close = this.find('.js-close');
    this.items.forEach(this.addItem);

    // Clean up
    delete this.template;

    debug('rendered');
    return this.bindEvents();
  },

  bindEvents: function() {
    bind(this.els.close, 'click', this.firer('click:close'));
    return this;
  },

  goBack: function() {
    this.showPane(1);
    this.destroyOptionsView();
  },

  destroyChild: function(view) {
    view.destroy();
    debug('destroyed child');
  },

  destroyOptionsView: function() {
    if (this.optionsView) {
      this.optionsView.destroy();
      this.optionsView = null;
      debug('options view destroyed');
    }
  },

  addItem: function(model) {
    var setting = new SettingView({ model: model })
      .render()
      .appendTo(this.els.items)
      .on('click', this.onItemClick);

    this.children.push(setting);
    debug('add item key: %s', model.key);
  },

  showPane: function(name) {
    this.el.setAttribute('show-pane', 'pane-' + name);
  },

  template: function() {
    return '<div class="pane pane-1">' +
      '<div class="settings_inner">' +
        '<h2 class="settings_title">' + this.l10n.get('options') + '</h2>' +
        '<div class="settings_items"><ul class="inner js-items"></ul></div>' +
      '</div>' +
    '</div>' +
    '<div class="pane pane-2 js-pane-2"></div>' +
    '<div class="settings_close icon-settings js-close"></div>';
  }
});

});

define('controllers/settings',['require','exports','module','lib/picture-sizes/format-picture-sizes','lib/format-recorder-profiles','debug','views/settings','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var formatPictureSizes = require('lib/picture-sizes/format-picture-sizes');
var formatRecorderProfiles = require('lib/format-recorder-profiles');
var debug = require('debug')('controller:settings');
var SettingsView = require('views/settings');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new SettingsController(app); };
module.exports.SettingsController = SettingsController;

/**
 * Initialize a new `SettingsController`
 *
 * @constructor
 * @param {App} app
 */
function SettingsController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.settings = app.settings;
  this.notification = app.views.notification;

  // Allow test stubs
  this.l10n = app.l10n || navigator.mozL10n;
  this.SettingsView = app.SettingsView || SettingsView;
  this.formatPictureSizes = app.formatPictureSizes || formatPictureSizes;
  this.formatRecorderProfiles = app.formatRecorderProfiles ||
    formatRecorderProfiles;

  this.configure();
  this.bindEvents();
  debug('initialized');
}

SettingsController.prototype.configure = function() {
  this.settings.alias('recorderProfiles', this.aliases.recorderProfiles);
  this.settings.alias('pictureSizes', this.aliases.pictureSizes);
  this.settings.alias('flashModes', this.aliases.flashModes);
};

/**
 * Bind to app events.
 *
 * @private
 */
SettingsController.prototype.bindEvents = function() {
  this.app.on('change:capabilities', this.onCapabilitiesChange);
  this.app.on('settings:toggle', this.toggleSettings);
};

/**
 * Toggle the settings menu open/closed.
 *
 * @private
 */
SettingsController.prototype.toggleSettings = function() {
  if (this.view) { this.closeSettings(); }
  else { this.openSettings(); }
};

/**
 * Render and display the settings menu.
 *
 * We use settings.menu() to retrieve
 * and ordered list of settings that
 * have a `menu` property.
 *
 * @private
 */
SettingsController.prototype.openSettings = function() {
  debug('open settings');
  if (this.view) { return; }

  var items = this.menuItems();
  this.view = new this.SettingsView({ items: items })
    .render()
    .appendTo(this.app.el)
    .on('click:close', this.closeSettings)
    .on('click:option', this.onOptionTap);

  this.app.emit('settings:opened');
  debug('settings opened');
};

/**
 * Destroy the settings menu.
 *
 * @private
 */
SettingsController.prototype.closeSettings = function() {
  debug('close settings');
  if (!this.view) { return; }
  this.view.destroy();
  this.view = null;
  this.app.emit('settings:closed');
  debug('settings closed');
};

/**
 * Selects the option that was
 * clicked on the setting.
 *
 * @param  {String} key
 * @param  {Setting} setting
 * @private
 */
SettingsController.prototype.onOptionTap = function(key, setting) {
  var flashMode = this.settings.flashModesPicture.selected('key');
  var ishdrOn = setting.key === 'hdr' && key === 'on';
  var flashDeactivated = flashMode !== 'off' && ishdrOn;

  setting.select(key);
  this.closeSettings();
  this.notify(setting, flashDeactivated);
};

/**
 * Display a notifcation showing the
 * current state of the given setting.
 *
 * @param  {Setting} setting
 * @private
 */
SettingsController.prototype.notify = function(setting, flashDeactivated) {
  var optionTitle = this.localize(setting.selected('title'));
  var title = this.localize(setting.get('title'));
  var html;

  // Check if the `flashMode` setting is going to be deactivated as part
  // of the change in the `hdr` setting and display a specialized
  // notification if that is the case
  if (flashDeactivated) {
    html = title + ' ' + optionTitle + '<br/>' +
      this.l10n.get('flash-deactivated');
  } else {
    html = title + '<br/>' + optionTitle;
  }

  this.notification.display({ text: html });
};

SettingsController.prototype.localize = function(value) {
  return this.l10n.get(value) || value;
};

/**
 * When the hardware capabilities change
 * we update the available options for
 * each setting to match what is available.
 *
 * The rest of the app should listen for
 * the 'settings:configured' event as an
 * indication to update UI etc.
 *
 * @param  {Object} capabilities
 */
SettingsController.prototype.onCapabilitiesChange = function(capabilities) {
  debug('new capabilities');

  this.settings.hdr.filterOptions(capabilities.hdr);
  this.settings.flashModesPicture.filterOptions(capabilities.flashModes);
  this.settings.flashModesVideo.filterOptions(capabilities.flashModes);

  this.configurePictureSizes(capabilities.pictureSizes);
  this.configureRecorderProfiles(capabilities.recorderProfiles);

  // Let the rest of the app
  // know we're good to go.
  this.app.emit('settings:configured');
  debug('settings configured to new capabilities');
};

/**
 * Formats the raw pictureSizes into
 * a format that Setting class can
 * work with, then resets the pictureSize
 * options.
 *
 * @param  {Array} sizes
 */
SettingsController.prototype.configurePictureSizes = function(sizes) {
  var setting = this.settings.pictureSizes;
  var maxPixelSize = setting.get('maxPixelSize');
  var exclude = setting.get('exclude');
  var options = {
    exclude: exclude,
    maxPixelSize: maxPixelSize,
    mp: this.l10n.get('mp')
  };
  var formatted = this.formatPictureSizes(sizes, options);

  setting.resetOptions(formatted);
  setting.emit('configured');
};

/**
 * Formats the raw recorderProfiles
 * into a format that Setting class can
 * work with, then resets the recorderProfile
 * options.
 *
 * @param  {Array} sizes
 */
SettingsController.prototype.configureRecorderProfiles = function(sizes) {
  var setting = this.settings.recorderProfiles;
  var exclude = setting.get('exclude');
  var options = { exclude: exclude };
  var formatted = this.formatRecorderProfiles(sizes, options);

  setting.resetOptions(formatted);
  setting.emit('configured');
};

/**
 * Returns a list of settings
 * based on the `settingsMenu`
 * cofiguration.
 *
 * If any `conditions` are defined
 * they must pass to be in the list.
 *
 * @return {Array}
 */
SettingsController.prototype.menuItems = function() {
  var items = this.settings.settingsMenu.get('items');
  return items.filter(this.validMenuItem, this)
    .map(function(item) { return this.settings[item.key]; }, this);
};

/**
 * Tests if the passed `settingsMenu`
 * item is allowed in the settings menu.
 *
 * Should:
 *
 *   1. Be a currently supported setting
 *   2. Pass a defined condition
 *
 * @param  {Object} item
 * @return {Boolean}
 */
SettingsController.prototype.validMenuItem = function(item) {
  var setting = this.settings[item.key];
  return !!setting && setting.supported();
};

/**
 * Settings aliases provide
 * convenient pointers to
 * specific settings based on
 * the state of other settings.
 *
 * @type {Object}
 */
SettingsController.prototype.aliases = {
  recorderProfiles: {
    map: {
      back: 'recorderProfilesBack',
      front: 'recorderProfilesFront'
    },
    get: function() {
      var camera = this.settings.cameras.selected('key');
      return this.settings[this.map[camera]];
    }
  },
  pictureSizes: {
    map: {
      back: 'pictureSizesBack',
      front: 'pictureSizesFront'
    },
    get: function() {
      var camera = this.settings.cameras.selected('key');
      return this.settings[this.map[camera]];
    }
  },
  flashModes: {
    map: {
      video: 'flashModesVideo',
      picture: 'flashModesPicture'
    },
    get: function() {
      var mode = this.settings.mode.selected('key');
      return this.settings[this.map[mode]];
    }
  }
};

});

define('lib/picture-sizes/less-than-file-size',['require','exports','module'],function(require, exports, module) {


var estimateJpegFileSize = function(width, height, bpp) {
  bpp = bpp || 24;
  var bitmapSizeInBytes = width * height * bpp / 8;
  var compressionRatio = window.CONFIG_AVG_JPEG_COMPRESSION_RATIO || 8;
  return bitmapSizeInBytes / compressionRatio;
};

/**
 * Returns all pictureSize options,
 * with overall bytes (estimation),
 * less than the bytes given.
 *
 * @param  {Number} bytes
 * @param  {Array} sizes
 * @return {Boolean}
 */
module.exports = function(bytes, sizes) {
  return sizes.filter(function(option) {
    var size = option.data;
    var fileSize = estimateJpegFileSize(size.width, size.height);
    return fileSize <= bytes;
  });
};

});

define('lib/picture-sizes/closest-to-size',['require','exports','module'],function(require, exports, module) {


/**
 * Returns the closest matching pictureSize,
 * that is larger than the given `target`
 * pictureSize.
 *
 * @param  {Array} options
 * @param  {Object} target
 * @return {Object}
 * @public
 */
module.exports = function (target, options) {
  var width = target.width || 0;
  var height = target.height || 0;

  return options.reduce(function(result, option) {
    var resultSize = result && result.data;

    // When we format the pictureSizes from
    // the camera capabilities, we store the
    // picture size data (width, height) in
    // the `data` key of the setting model.
    var size = option.data;

    var largerThanTarget =
      size.width >= width &&
      size.height >= height;

    // If we don't yet have a result and this option
    // is larger than the target dimensions, use it.
    if (!result) { return largerThanTarget ? option : null; }

    // If it's not larger than the target,
    // this option isn't going to be appropriate.
    if (!largerThanTarget) { return result; }

    var pixels = size.width * size.height;
    var resultPixels = resultSize.width * resultSize.height;
    var smallerThanCurrent = pixels < resultPixels;

    // If the option is larger than the target, yet
    // smaller is size than the current choice, use it!
    return smallerThanCurrent ? option : result;
  }, null);
};

});

define('controllers/activity',['require','exports','module','lib/picture-sizes/less-than-file-size','lib/picture-sizes/closest-to-size','debug','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var lessThanFileSize = require('lib/picture-sizes/less-than-file-size');
var closestToSize = require('lib/picture-sizes/closest-to-size');
var debug = require('debug')('controller:activity');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new ActivityController(app); };
module.exports.ActivityController = ActivityController;

/**
 * Initialize new `ActivityController`
 *
 * @param {App} app
 */
function ActivityController(app) {
  bindAll(this);
  this.activity = app.activity;
  this.settings = app.settings;
  this.app = app;

  // Allow these methods to be overridden
  this.closestToSize = app.closestToSize || closestToSize;
  this.lessThanFileSize = app.lessThanFileSize || lessThanFileSize;

  this.configure();
  this.bindEvents();
  debug('initialized');
}

/**
 * Initial configuration.
 *
 * @private
 */
ActivityController.prototype.configure = function() {
  this.configureMode();
};

/**
 * Filter down pictureSizes and
 * recorderProfiles to match activity
 * parameters each time the settings
 * are configured.
 *
 * @private
 */
ActivityController.prototype.bindEvents = function() {
  this.activity.on('activityreceived', this.onActivityReceived);
  this.settings.recorderProfiles.on('configured', this.filterRecorderProfiles);
  this.settings.pictureSizes.on('configured', this.filterPictureSize);
};

/**
 * Set filter the capture mode options
 * @return {[type]} [description]
 */
ActivityController.prototype.configureMode = function() {
  var modes = this.activity.modes;
  this.settings.mode.filterOptions(modes);

  var mode = modes[0];
  if (mode) {
    this.settings.mode.select(mode);
  }

  debug('configured mode', modes);
};

ActivityController.prototype.onActivityReceived = function() {
  this.configure();
};

/**
 * If `maxFileSizeBytes` is specified,
 * we filter down the available picture
 * sizes to just those less than the
 * given number of bytes (estimated).
 *
 * Else, if a `width` or `height` is
 * defined by the activity, we find
 * the picture size that is closest to,
 * but still larger than, the given size.
 *
 * @private
 */
ActivityController.prototype.filterPictureSize = function() {
  var setting = this.settings.pictureSizes;
  var options = setting.get('options');
  var data = this.activity.data;
  var maxFileSize = data.maxFileSizeBytes;
  var filtered;
  var keys;

  // By file-size
  if (maxFileSize) {
    filtered = this.lessThanFileSize(maxFileSize, options);
    keys = filtered.map(function(option) { return option.key; });
    setting.filterOptions(keys);
    debug('picture sizes less than \'%s\' bytes', maxFileSize);
  }

  // By width/height
  else if (data.width || data.height) {
    filtered = this.closestToSize(data, options);
    if (filtered) { setting.filterOptions([filtered.key]); }
    debug('picked picture size', filtered);
  }
};

/**
 * If an activity has specified `maxFileSizeBytes`
 * we filter down to just the the lowest (last)
 * resolution recorder profile.
 *
 * @private
 */
ActivityController.prototype.filterRecorderProfiles = function() {
  var maxFileSize = this.activity.data.maxFileSizeBytes;
  var setting = this.settings.recorderProfiles;
  var options = setting.get('options');

  if (!maxFileSize) { return; }

  var last = options[options.length - 1];
  setting.filterOptions([last.key]);
};

});

define('controllers/camera',['require','exports','module','debug','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:camera');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

exports = module.exports = function(app) { return new CameraController(app); };
exports.CameraController = CameraController;

/**
 * Initialize a new `CameraController`
 *
 * @param {App} app
 */
function CameraController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.camera = app.camera;
  this.storage = app.storage;
  this.settings = app.settings;
  this.activity = app.activity;
  this.viewfinder = app.views.viewfinder;
  this.controls = app.views.controls;
  this.hdrDisabled = this.settings.hdr.get('disabled');
  this.configure();
  this.bindEvents();
  debug('initialized');
}

CameraController.prototype.bindEvents = function() {
  var settings = this.settings;
  var camera = this.camera;
  var app = this.app;

  // Relaying camera events means other modules
  // don't have to depend directly on camera
  camera.on('change:videoElapsed', app.firer('camera:recorderTimeUpdate'));
  camera.on('change:capabilities', this.app.setter('capabilities'));
  camera.on('change:focus', this.app.firer('camera:focuschanged'));
  camera.on('change:previewActive', this.app.firer('camera:previewactive'));
  camera.on('filesizelimitreached', this.onFileSizeLimitReached);
  camera.on('configured', app.firer('camera:configured'));
  camera.on('change:recording', app.setter('recording'));
  camera.on('shutter', app.firer('camera:shutter'));
  camera.on('loaded', app.firer('camera:loaded'));
  camera.on('ready', app.firer('camera:ready'));
  camera.on('busy', app.firer('camera:busy'));
  camera.on('newimage', this.onNewImage);
  camera.on('newvideo', this.onNewVideo);

  // App
  app.on('boot', this.camera.load);
  app.on('focus', this.camera.load);
  app.on('capture', this.capture);
  app.on('timer:ended', this.capture);
  app.on('blur', this.onBlur);
  app.on('settings:configured', this.onSettingsConfigured);
  app.on('change:batteryStatus', this.onBatteryStatusChange);
  app.on('previewgallery:opened', this.shutdownCamera);
  app.on('previewgallery:closed', this.onGalleryClosed);
  app.on('attentionscreenopened', this.camera.stopRecording);

  // Settings
  settings.recorderProfiles.on('change:selected', this.onRecorderProfileChange);
  settings.pictureSizes.on('change:selected', this.onPictureSizeChange);
  settings.flashModes.on('change:selected', this.onFlashModeChange);
  settings.flashModes.on('change:selected', this.setFlashMode);
  settings.cameras.on('change:selected', this.setCamera);
  settings.mode.on('change:selected', this.setMode);
  settings.hdr.on('change:selected', this.setHDR);
  settings.hdr.on('change:selected', this.onHDRChange);

  this.storage.on('statechange', this.onStorageStateChange);
  debug('events bound');
};

/**
 * Configure the camera with
 * initial configuration derived
 * from various startup parameters.
 *
 * @private
 */
CameraController.prototype.configure = function() {
  var settings = this.app.settings;
  var activity = this.activity;
  var camera = this.camera;

  // Configure the 'cameras' setting using the
  // cameraList data given by the camera hardware
  settings.cameras.filterOptions(camera.cameraList);

  // Give the camera a way to create video filepaths. This
  // is so that the camera can record videos directly to
  // the final location without us having to move the video
  // file from temporary, to final location at recording end.
  this.camera.createVideoFilepath = this.storage.createVideoFilepath;

  // This is set so that the video recorder can
  // automatically stop when video size limit is reached.
  camera.set('maxFileSizeBytes', activity.data.maxFileSizeBytes);
  camera.set('selectedCamera', settings.cameras.selected('key'));
  camera.setMode(settings.mode.selected('key'));
  debug('configured');
};

CameraController.prototype.onSettingsConfigured = function() {
  var settings = this.app.settings;
  var recorderProfile = settings.recorderProfiles.selected('key');
  var pictureSize = settings.pictureSizes.selected('data');
  this.setWhiteBalance();
  this.setFlashMode();
  this.setISO();
  this.setHDR(this.settings.hdr.selected('key'));
  this.camera
    .setRecorderProfile(recorderProfile)
    .setPictureSize(pictureSize)
    .configure();

  // Bug 983930 - [B2G][Camera] CameraControl API's "zoom" attribute doesn't
  // scale preview properly
  //
  // For some reason, the above calculation for `maxHardwareZoom` does not
  // work properly on Nexus 4 devices.
  var hardware = navigator.mozSettings.createLock().get('deviceinfo.hardware');
  var self = this;
  hardware.onsuccess = function(evt) {
    var device = evt.target.result['deviceinfo.hardware'];
    if (device === 'mako') {

      // Nexus 4 needs zoom preview adjustment since the viewfinder preview
      // stream does not automatically reflect the current zoom value.
      settings.zoom.set('useZoomPreviewAdjustment', true);

      if (self.camera.selectedCamera === 'front') {
        self.camera.set('maxHardwareZoom', 1);
      } else {
        self.camera.set('maxHardwareZoom', 1.25);
      }

      self.camera.emit('zoomconfigured');
    }
  };

  debug('camera configured with final settings');

  // TODO: Move to a new StorageController (or App?)
  //
  // It is very unlikely that a JPEG file will have a file size that is
  // more than half a byte per pixel. There is some fixed EXIF overhead
  // that is the same for small and large pictures, however, so we add
  // an additional 25,000 bytes of padding.
  var maxFileSize = (pictureSize.width * pictureSize.height / 2) + 25000;
  this.storage.setMaxFileSize(maxFileSize);
};

/**
 * Begins capture, first checking if
 * a countdown timer should be installed.
 *
 * @return {[type]} [description]
 */
CameraController.prototype.capture = function() {
  if (this.shouldCountdown()) {
    this.app.emit('startcountdown');
    return;
  }

  var position = this.app.geolocation.position;
  this.camera.capture({ position: position });
};

/**
 * Fires a 'startcountdown' event if:
 * A timer settings is set, no timer is
 * already active, and the camera is
 * not currently recording.
 *
 * This event triggers the TimerController
 * to begin counting down, using the TimerView
 * to communicate the remaining seconds.
 *
 * @private
 */
CameraController.prototype.shouldCountdown = function() {
  var timerSet = this.settings.timer.selected('value');
  var timerActive = this.app.get('timerActive');
  var recording = this.app.get('recording');

  return timerSet && !timerActive && !recording;
};

CameraController.prototype.onNewImage = function(image) {
  var storage = this.storage;
  var memoryBlob = image.blob;
  var self = this;

  // In either case, save the memory-backed photo blob to
  // device storage, retrieve the resulting File (blob) and
  // pass that around instead of the original memory blob.
  // This is critical for "pick" activity consumers where
  // the memory-backed Blob is either highly inefficent or
  // will almost-immediately become inaccesible, depending
  // on the state of the platform. https://bugzil.la/982779
  storage.addImage(memoryBlob, function(filepath, abspath, fileBlob) {
    debug('stored image', filepath);
    image.blob = fileBlob;
    image.filepath = filepath;

    debug('new image', image);
    self.app.emit('newmedia', image);
  });
};

/**
 * Store the poster image,
 * then emit the app 'newvideo'
 * event. This signifies the video
 * fully ready.
 *
 * We don't store the video blob like
 * we do for images, as it is recorded
 * directly to the final location.
 * This is for memory reason.
 *
 * @param  {Object} video
 */
CameraController.prototype.onNewVideo = function(video) {
  debug('new video', video);

  var storage = this.storage;
  var poster = video.poster;
  var self = this;
  video.isVideo = true;

  // Add the poster image to the image storage
  poster.filepath = video.filepath.replace('.3gp', '.jpg');

  storage.addImage(
    poster.blob, { filepath: poster.filepath },
    function(path, absolutePath, fileBlob) {
      // Replace the memory-backed Blob with the DeviceStorage file-backed File.
      // Note that "video" references "poster", so video previews will use this
      // File.
      poster.blob = fileBlob;
      debug('new video', video);
      self.app.emit('newmedia', video);
    });
};

CameraController.prototype.onPictureSizeChange = function() {
  var value = this.settings.pictureSizes.selected('data');
  this.setPictureSize(value);
};

CameraController.prototype.onRecorderProfileChange = function(key) {
  this.setRecorderProfile(key);
};

CameraController.prototype.onFileSizeLimitReached = function() {
  this.camera.stopRecording();
  this.showSizeLimitAlert();
};

CameraController.prototype.showSizeLimitAlert = function() {
  if (this.sizeLimitAlertActive) { return; }
  this.sizeLimitAlertActive = true;
  var alertText = this.activity.active ?
    'activity-size-limit-reached' :
    'storage-size-limit-reached';
  alert(navigator.mozL10n.get(alertText));
  this.sizeLimitAlertActive = false;
};

CameraController.prototype.setMode = function(mode) {
  this.setFlashMode();
  this.camera.setMode(mode);
  this.viewfinder.fadeOut(this.camera.configure);
};

CameraController.prototype.setPictureSize = function(value) {
  var pictureMode = this.settings.mode.selected('key') === 'picture';

  // Only configure in video mode
  this.camera.setPictureSize(value);
  if (pictureMode) { this.viewfinder.fadeOut(this.camera.configure); }
};

CameraController.prototype.setRecorderProfile = function(value) {
  var videoMode = this.settings.mode.selected('key') === 'video';

  // Only configure in video mode
  this.camera.setRecorderProfile(value);
  if (videoMode) { this.viewfinder.fadeOut(this.camera.configure); }
};

CameraController.prototype.setCamera = function(value) {
  this.camera.set('selectedCamera', value);
  this.viewfinder.fadeOut(this.camera.load);
};

CameraController.prototype.setFlashMode = function() {
  var flashSetting = this.settings.flashModes;
  this.camera.setFlashMode(flashSetting.selected('key'));
};

CameraController.prototype.onBlur = function() {
  this.shutdownCamera();
  debug('torn down');
};

CameraController.prototype.setISO = function() {
  if (!this.settings.isoModes.get('disabled')) {
    this.camera.setISOMode(this.settings.isoModes.selected('key'));
  }
};

CameraController.prototype.setWhiteBalance = function() {
  if (!this.settings.whiteBalance.get('disabled')) {
    this.camera.setWhiteBalance(this.settings.whiteBalance.selected('key'));
  }
};

CameraController.prototype.setHDR = function(hdr) {
  if (this.hdrDisabled) { return; }
  this.camera.setHDR(hdr);
};

CameraController.prototype.onFlashModeChange = function(flashModes) {
  if (this.hdrDisabled) { return; }
  var ishdrOn = this.settings.hdr.selected('key') === 'on';
  if (ishdrOn &&  flashModes !== 'off') {
    this.settings.hdr.select('off');
  }
};

CameraController.prototype.onHDRChange = function(hdr) {
  var flashMode = this.settings.flashModesPicture.selected('key');
  var ishdrOn = hdr === 'on';
  if (ishdrOn && flashMode !== 'off') {
    this.settings.flashModesPicture.select('off');
  }
};

CameraController.prototype.onBatteryStatusChange = function(status) {
  if (status === 'shutdown') { this.camera.stopRecording(); }
};

/**
 * Respond to storage `statechange` events.
 *
 * @param  {String} value  ['nospace'|'shared'|'unavailable'|'available']
 */
CameraController.prototype.onStorageStateChange = function(value) {
  if (this.camera.get('recording')) {
    this.camera.stopRecording();
  }
};

CameraController.prototype.shutdownCamera = function() {
  this.camera.stopRecording();
  this.camera.set('previewActive', false);
  this.camera.set('focus', 'none');
  this.camera.release();
};

CameraController.prototype.onGalleryClosed = function() {
  if (this.app.hidden) {
    return;
  }

  this.app.showLoading();
  this.camera.load(this.app.clearLoading);
};

});

define('controllers/sounds',['require','exports','module'],function(require, exports, module) {


/**
 * Exports
 */

exports = module.exports = function(app) { return new SoundsController(app); };
exports.SoundsController = SoundsController;

/**
 * Initialize a new `SoundsController`
 * @param {[type]} app [description]
 */
function SoundsController(app) {
  this.sounds = app.sounds;
  app.on('change:recording', this.onRecordingChange);
  app.on('camera:shutter', this.sounds.player('shutter'));
}

/**
 * Plays the start/end recording sound.
 *
 * @private
 */
SoundsController.prototype.onRecordingChange = function(recording) {
  if (recording) { this.sounds.play('recordingStart'); }
  else { this.sounds.play('recordingEnd'); }
};

});

define('views/timer',['require','exports','module','debug','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:timer');
var View = require('vendor/view');

/**
 * Exports
 */

/**
 * Timer
 *
 * @constructor
 */
module.exports = View.extend({
  name:'timer',
  immanent: 3,

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();
    this.els.count = this.find('.js-count');

    // Clean up
    delete this.template;

    debug('rendered');
    return this;
  },

  set: function(time) {
    var isImmanent = time <= this.immanent;

    // Update the number
    this.els.count.textContent = time;

    // Trigger the shrink animation
    this.el.classList.remove('shrink');
    this.reflow = this.el.offsetTop;
    this.el.classList.add('shrink');

    // Flag immanent & emit event
    this.el.classList.toggle('immanent', isImmanent);
    if (isImmanent) { this.emit('timer:immanent'); }

    debug('set time: %s, near: %s', time, isImmanent);
    return this;
  },

  show: function() {
    this.el.classList.remove('hidden');
    this.el.classList.add('visible');
  },

  hide: function() {
    this.el.classList.remove('visible');
    this.el.classList.add('hidden');
  },

  reset: function() {
    this.els.count.textContent = '';
    this.el.classList.remove('immanent');
  },

  template: function() {
    return '<div class="timer_circle-1"></div>' +
      '<div class="timer_circle-2"></div>' +
      '<div class="timer_count">' +
        '<div class="rotates js-count"></div>' +
      '</div>';
  }
});

});

define('controllers/timer',['require','exports','module','debug','views/timer','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:timer');
var TimerView = require('views/timer');
var bindAll = require('lib/bind-all');

/**
 * Exports
 */

module.exports = function(app) { return new TimerController(app); };
module.exports.TimerController = TimerController;

/**
 * Create a new `TimerController`
 *
 * We make the setup method async so
 * that events are not called in the
 * same synchronous turn in which they
 * are bound.
 *
 * @param {App} app [description]
 */
function TimerController(app) {
  bindAll(this);
  this.app = app;
  this.sounds = app.sounds;
  this.settings = app.settings;
  this.view = app.views.timer || new TimerView();
  this.view.appendTo(app.el);
  this.bindEvents();
}

/**
 * Connects the timer view
 * with the app via events.
 *
 * @private
 */
TimerController.prototype.bindEvents = function() {
  this.app.on('startcountdown', this.start);
  this.view.on('timer:immanent', this.beep);
  this.app.on('blur', this.clear);
};

/**
 * Start the timer counting down
 * from the currently set timer value.
 *
 * Don't allow timer to start if
 * one is already active.
 *
 * We bind to app events asynchronously
 * so that the timer isn't instantly
 * cleared by the 'click' that started it.
 *
 * @private
 */
TimerController.prototype.start = function() {
  if (this.app.get('timerActive')) { return; }

  this.seconds = this.settings.timer.selected('value');
  this.view.set(this.seconds).show();
  setTimeout(this.bindTimerEvents);
  this.scheduleTick();

  this.app.set('timerActive', true);
  this.app.emit('timer:started');

  debug('started');
};

/**
 * Schedule the next tick.
 *
 * Make sure to clear any existing
 * timeout to be absolutely sure that
 * only one timeout is ever pending.
 *
 * @private
 */
TimerController.prototype.scheduleTick = function() {
  clearTimeout(this.timeout);
  this.timeout = setTimeout(this.tick, 1000);
};

/**
 * Decrements the timer and checks
 * if its still has second left.
 *
 * If no time remains, an 'ended'
 * event is fired and the timer
 * is cleared.
 *
 * If time does remain, we update
 * the view.
 *
 * @private
 */
TimerController.prototype.tick = function() {
  if (--this.seconds <= 0) {
    this.app.emit('timer:ended');
    this._clear();
    return;
  }

  this.view.set(this.seconds);
  this.scheduleTick();
};

/**
 * Call ._clear() and fire 'cleared' event.
 *
 * @param  {Object} options
 * @private
 */
TimerController.prototype.clear = function() {
  this._clear();
  this.app.emit('timer:cleared');
};

/**
 * Clear the timer and hide
 * the view.
 *
 * @param  {Object} options
 * @private
 */
TimerController.prototype._clear = function() {
  clearTimeout(this.timeout);
  this.unbindTimerEvents();
  this.view.hide();
  this.view.reset();
  this.app.set('timerActive', false);
  debug('cleared');
};

/**
 * When the app is clicked we cancel
 * the timer. Also respond to when the
 * timer is cleared, or ends.
 *
 * These events are only bound when
 * the timer is counting to avoid complex
 * conflicts with other app interactions
 * when not needed.
 *
 * @private
 */
TimerController.prototype.bindTimerEvents = function() {
  this.app.on('click', this.clear);
};

/**
 * Unbind the timer events when
 * they are no longer needed.
 *
 * @private
 */
TimerController.prototype.unbindTimerEvents = function() {
  this.app.off('click', this.clear);
};

/**
 * Plays a beep sound.
 *
 * We don't have specific sound file for beep
 * so we are using recordingEnd sound for this.
 *
 * NOTE: Commented out until we have correct
 * sound effects in place (bug 991808).
 *
 * @private
 */
TimerController.prototype.beep = function() {
  // this.sounds.play('recordingEnd');
};

});

define('controllers/zoom-bar',['require','exports','module','debug','lib/bind-all'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:zoom-bar');
var bindAll = require('lib/bind-all');
/**
 * Exports
 */

module.exports = function(app) { return new ZoomBarController(app); };
module.exports.ZoomBarController = ZoomBarController;

/**
 * Initialize a new `ZoomBarController`
 *
 * @param {App} app
 */
function ZoomBarController(app) {
  debug('initializing');
  bindAll(this);
  this.app = app;
  this.camera = app.camera;
  this.viewfinder = app.views.viewfinder;
  this.zoomBar = app.views.zoomBar;
  this.bindEvents();
  debug('initialized');
}

ZoomBarController.prototype.bindEvents = function() {
  this.zoomBar.on('change', this.onChange);
  this.camera.on('zoomconfigured', this.onZoomConfigured);
  this.camera.on('zoomchanged', this.onZoomChanged);
  this.viewfinder.on('pinchstarted', this.onPinchStarted);
  this.viewfinder.on('pinchended', this.onPinchEnded);
};

ZoomBarController.prototype.onChange = function(value) {
  var minimumZoom = this.camera.getMinimumZoom();
  var maximumZoom = this.camera.getMaximumZoom();
  var range = maximumZoom - minimumZoom;
  var zoom = (range * value / 100) + minimumZoom;
  this.camera.setZoom(zoom);
};

ZoomBarController.prototype.onZoomConfigured = function() {
  this.zoomBar.hide();
};

ZoomBarController.prototype.onZoomChanged = function(zoom) {
  var minimumZoom = this.camera.getMinimumZoom();
  var maximumZoom = this.camera.getMaximumZoom();
  var range = maximumZoom - minimumZoom;
  var percent = (zoom - minimumZoom) / range * 100;
  this.zoomBar.setValue(percent);
};

ZoomBarController.prototype.onPinchStarted = function() {
  this.zoomBar.setScrubberActive(true);
};

ZoomBarController.prototype.onPinchEnded = function() {
  this.zoomBar.setScrubberActive(false);
};

});

define('views/indicators',['require','exports','module','debug','vendor/view'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('view:indicators');
var View = require('vendor/view');

/**
 * Exports
 */

module.exports = View.extend({
  name: 'indicators',
  tag: 'ul',

  initialize: function() {
    this.render();
  },

  render: function() {
    this.el.innerHTML = this.template();

    // Clean up
    delete this.template;

    debug('rendered');
    return this;
  },

  template: function() {
    return '<li class="indicator_timer icon-timer rotates"></li>' +
    '<li class="indicator_hdr icon-hdr rotates"></li>' +
    '<li class="indicator_geolocation icon-geolocation rotates"></li>' +
    '<li class="indicator_battery icon rotates"></li>';
  }
});

});
define('controllers/indicators',['require','exports','module','debug','views/indicators'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:indicators');
var IndicatorsView = require('views/indicators');

/**
 * Exports
 */

module.exports = function(app) { return new IndicatorsController(app); };
module.exports.IndicatorsController = IndicatorsController;

/**
 * Initialize a new `IndicatorsController`
 *
 * @param {Object} options
 */
function IndicatorsController(app) {
  debug('initializing');
  this.app = app;
  this.settings = app.settings;
  this.onSettingsConfigured = this.onSettingsConfigured.bind(this);
  this.configure();
  debug('initialized');
}

/**
 * Initial configuration. Injects
 * view and binds events.
 *
 * @private
 */
IndicatorsController.prototype.configure = function() {
  this.view = this.app.views.indicators || new IndicatorsView();
  // Indicators hidden by default until the settings are configured
  this.view.hide();
  this.view.appendTo(this.app.el);
  this.bindEvents();
  debug('events bound');
};

/**
 * Update the view when related
 * settings and app state change.
 *
 * Configure each time the settings
 * configure.
 *
 * @public
 */
IndicatorsController.prototype.bindEvents = function() {
  this.settings.timer.on('change:selected', this.view.setter('timer'));
  this.settings.hdr.on('change:selected', this.view.setter('hdr'));
  this.app.on('change:batteryStatus', this.view.setter('battery'));
  this.app.on('change:recording', this.view.setter('recording'));
  this.app.on('settings:configured', this.onSettingsConfigured);
  debug('events bound');
};

/**
 * Enables supported indicators,
 * configures initial state and
 * then shows the view.
 *
 * @private
 */
IndicatorsController.prototype.onSettingsConfigured = function() {
  debug('configuring');
  this.configureEnabled();
  this.view.set('hdr', this.settings.hdr.selected('key'));
  this.view.set('timer', this.settings.timer.selected('key'));
  this.view.show();
  debug('configured');
};

/**
 * Configures the enabling/disabling
 * of all keys in the indicator config.
 *
 * @private
 */
IndicatorsController.prototype.configureEnabled = function() {
  for (var key in this.enabled) { this.enable(key, this.enabled[key]); }
};

/**
 * Enables an indicator in the view,
 * if truthy in indicator config, and
 * not a setting, or is a 'supported'
 * setting.
 *
 * @param  {String} key
 * @param {Boolean} enabled
 * @private
 */
IndicatorsController.prototype.enable = function(key, enabled) {
  var setting = this.settings[key];
  var shouldEnable = enabled && (!setting || setting.supported());
  this.view.enable(key, shouldEnable);
  debug('enable key: %s, shouldEnable: %s', key, shouldEnable);
};

});
define('controllers/battery',['require','exports','module','debug','lib/bind-all','lib/bind'],function(require, exports, module) {


/**
 * Dependencies
 */

var debug = require('debug')('controller:battery');
var bindAll = require('lib/bind-all');
var bind = require('lib/bind');

/**
 * Exports
 */

module.exports = function(app) { return new BatteryController(app); };
module.exports.BatteryController = BatteryController;

/**
 * Initialize a new `BatteryController`
 *
 * @param {Object} options
 */
function BatteryController(app) {
  bindAll(this);
  this.app = app;
  this.battery = app.battery || navigator.battery || navigator.mozBattery;
  this.levels = app.settings.battery.get('levels');
  this.l10n = app.l10n || navigator.mozL10n;
  this.notification = app.views.notification;
  this.bindEvents();
  this.updateStatus();
  debug('initialized');
}

/**
 * Bind callbacks to required events.
 *
 * @private
 */
BatteryController.prototype.bindEvents = function() {
  bind(this.battery, 'levelchange', this.updateStatus);
  bind(this.battery, 'chargingchange', this.updateStatus);
  this.app.on('change:batteryStatus', this.onStatusChange);
};

/**
 * Map of status keys to message.
 *
 * @type {Object}
 * @private
 */
BatteryController.prototype.notifications = {
  low: {
    text: 'battery-low-text',
    className: 'icon-battery-low'
  },
  verylow: {
    text: 'battery-verylow-text',
    className: 'icon-battery-verylow'
  },
  critical: {
    text: 'battery-critical-text',
    className: 'icon-battery-verylow',
    persistent: true
  }
};

/**
 * Updates app `batteryStatus` and
 * manages battery notifications.
 *
 * @private
 */
BatteryController.prototype.updateStatus = function () {
  var previous = this.app.get('batteryStatus');
  var current = this.getStatus(this.battery);
  if (current !== previous) {
    this.app.set('batteryStatus', current);
  }
};

/**
 * Returns a status key derived
 * from the given `battery` object.
 *
 * @param  {Battery} battery
 * @return {String}
 * @private
 */
BatteryController.prototype.getStatus = function(battery) {
  var level = Math.round(battery.level * 100);
  var levels = this.levels;

  if (battery.charging) { return 'charging'; }
  else if (level <= levels.shutdown) { return 'shutdown'; }
  else if (level <= levels.critical) { return 'critical'; }
  else if (level <= levels.verylow) { return 'verylow'; }
  else if (level <= levels.low) { return 'low'; }
  else { return 'healthy'; }
};

BatteryController.prototype.onStatusChange = function(status) {
  this.clearLastNotification();
  this.displayNotification(status);
};

BatteryController.prototype.displayNotification = function(status) {
  var notification = this.notifications[status];
  if (!notification) { return; }

  this.lastNotification = this.notification.display({
    text: this.l10n.get(notification.text),
    className: notification.className,
    persistent: notification.persistent
  });
};

BatteryController.prototype.clearLastNotification = function() {
  this.notification.clear(this.lastNotification);
};

});
/* -*- Mode: js; js-indent-level: 2; indent-tabs-mode: nil -*- */
/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */



/**
 * This library exposes a `navigator.mozL10n' object to handle client-side
 * application localization. See: https://github.com/fabi1cazenave/webL10n
 */

(function(window) {
  var gL10nData = {};
  var gLanguage = '';
  var gMacros = {};
  var gReadyState = 'loading';

  // DOM element properties that may be localized with a key:value pair.
  var gNestedProps = ['style', 'dataset'];


  /**
   * Localization resources are declared in the HTML document with <link> nodes:
   *   <link rel="prefetch" type="application/l10n" href="locales.ini" />
   * Such *.ini files are multi-locale dictionaries where all supported locales
   * are listed / defined / imported, and where a fallback locale can easily be
   * defined.
   *
   * These *.ini files can also be compiled to locale-specific JSON dictionaries
   * with the `getDictionary()' method.  Such JSON dictionaries can be used:
   *  - either with a <link> node:
   *   <link rel="prefetch" type="application/l10n" href="{{locale}}.json" />
   *   (in which case, {{locale}} will be replaced by `navigator.language')
   *  - or with an inline <script> node:
   *   <script type="application/l10n" lang="fr"> ... </script>
   *   (in which case, the script matching `navigator.language' will be parsed)
   *
   * This is where `gDefaultLocale' comes in: if a JSON dictionary for the
   * current `navigator.language' value can't be found, use the one matching the
   * default locale.  Note that if the <html> element has a `lang' attribute,
   * its value becomes the default locale.
   */

  var gDefaultLocale = 'en-US';


  /**
   * Synchronously loading l10n resources significantly minimizes flickering
   * from displaying the app with non-localized strings and then updating the
   * strings. Although this will block all script execution on this page, we
   * expect that the l10n resources are available locally on flash-storage.
   *
   * As synchronous XHR is generally considered as a bad idea, we're still
   * loading l10n resources asynchronously -- but we keep this in a setting,
   * just in case... and applications using this library should hide their
   * content until the `localized' event happens.
   */

  var gAsyncResourceLoading = true; // read-only


  /**
   * Debug helpers
   *
   *   gDEBUG == 0: don't display any console message
   *   gDEBUG == 1: display only warnings, not logs
   *   gDEBUG == 2: display all console messages
   */

  var gDEBUG = 1;

  function consoleLog() {
    if (gDEBUG >= 2) {
      var args = [].slice.apply(arguments);
      args.unshift('[l10n] ');
      console.log(args.join(''));
    }
  };

  function consoleWarn() {
    if (gDEBUG) {
      var args = [].slice.apply(arguments);
      args.unshift('[l10n] ');
      console.warn(args.join(''));
    }
  };

  function consoleWarn_missingKeys(untranslatedElements, lang) {
    var len = untranslatedElements.length;
    if (!len || !gDEBUG) {
      return;
    }

    var missingIDs = [];
    for (var i = 0; i < len; i++) {
      var l10nId = untranslatedElements[i].getAttribute('data-l10n-id');
      if (missingIDs.indexOf(l10nId) < 0) {
        missingIDs.push(l10nId);
      }
    }
    console.warn('[l10n] ' +
        missingIDs.length + ' missing key(s) for [' + lang + ']: ' +
        missingIDs.join(', '));
  }


  /**
   * DOM helpers for the so-called "HTML API".
   *
   * These functions are written for modern browsers. For old versions of IE,
   * they're overridden in the 'startup' section at the end of this file.
   */

  function getL10nResourceLinks() {
    return document.querySelectorAll('link[type="application/l10n"]');
  }

  function getL10nDictionary(lang) {
    var getInlineDict = function(locale) {
      var sel = 'script[type="application/l10n"][lang="' + locale + '"]';
      return document.querySelector(sel);
    };
    // TODO: support multiple internal JSON dictionaries
    var script = getInlineDict(lang) || getInlineDict(gDefaultLocale);
    return script ? JSON.parse(script.innerHTML) : null;
  }

  function getTranslatableChildren(element) {
    return element ? element.querySelectorAll('*[data-l10n-id]') : [];
  }

  function getL10nAttributes(element) {
    if (!element) {
      return {};
    }

    var l10nId = element.getAttribute('data-l10n-id');
    var l10nArgs = element.getAttribute('data-l10n-args');
    var args = {};
    if (l10nArgs) {
      try {
        args = JSON.parse(l10nArgs);
      } catch (e) {
        consoleWarn('could not parse arguments for #', l10nId);
      }
    }
    return { id: l10nId, args: args };
  }

  function setTextContent(element, text) {
    // standard case: no element children
    if (!element.firstElementChild) {
      element.textContent = text;
      return;
    }

    // this element has element children: replace the content of the first
    // (non-blank) child textNode and clear other child textNodes
    var found = false;
    var reNotBlank = /\S/;
    for (var child = element.firstChild; child; child = child.nextSibling) {
      if (child.nodeType === 3 && reNotBlank.test(child.nodeValue)) {
        if (found) {
          child.nodeValue = '';
        } else {
          child.nodeValue = text;
          found = true;
        }
      }
    }
    // if no (non-empty) textNode is found, insert a textNode before the
    // element's first child.
    if (!found) {
      element.insertBefore(document.createTextNode(text), element.firstChild);
    }
  }

  function fireL10nReadyEvent() {
    var evtObject = document.createEvent('Event');
    evtObject.initEvent('localized', false, false);
    evtObject.language = gLanguage;
    window.dispatchEvent(evtObject);
  }


  /**
   * l10n resource parser:
   *  - reads (async XHR) the l10n resource matching `lang';
   *  - imports linked resources (synchronously) when specified;
   *  - parses the text data (fills `gL10nData');
   *  - triggers success/failure callbacks when done.
   *
   * @param {string} href
   *    URL of the l10n resource to parse.
   *
   * @param {string} lang
   *    locale (language) to parse.
   *
   * @param {Function} successCallback
   *    triggered when the l10n resource has been successully parsed.
   *
   * @param {Function} failureCallback
   *    triggered when the an error has occured.
   *
   * @return {void}
   *    fills gL10nData.
   */

  function parseResource(href, lang, successCallback, failureCallback) {
    var baseURL = href.replace(/\/[^\/]*$/, '/');

    // handle escaped characters (backslashes) in a string
    function evalString(text) {
      if (text.lastIndexOf('\\') < 0) {
        return text;
      }
      return text.replace(/\\\\/g, '\\')
                 .replace(/\\n/g, '\n')
                 .replace(/\\r/g, '\r')
                 .replace(/\\t/g, '\t')
                 .replace(/\\b/g, '\b')
                 .replace(/\\f/g, '\f')
                 .replace(/\\{/g, '{')
                 .replace(/\\}/g, '}')
                 .replace(/\\"/g, '"')
                 .replace(/\\'/g, "'");
    }

    // parse *.properties text data into an l10n dictionary
    function parseProperties(text) {
      var dictionary = [];

      // token expressions
      var reBlank = /^\s*|\s*$/;
      var reComment = /^\s*#|^\s*$/;
      var reSection = /^\s*\[(.*)\]\s*$/;
      var reImport = /^\s*@import\s+url\((.*)\)\s*$/i;
      var reSplit = /^([^=\s]*)\s*=\s*(.+)$/;
      var reUnicode = /\\u([0-9a-fA-F]{1,4})/g;
      var reMultiline = /[^\\]\\$/;

      // parse the *.properties file into an associative array
      function parseRawLines(rawText, extendedSyntax) {
        var entries = rawText.replace(reBlank, '').split(/[\r\n]+/);
        var currentLang = '*';
        var genericLang = lang.replace(/-[a-z]+$/i, '');
        var skipLang = false;
        var match = '';

        for (var i = 0; i < entries.length; i++) {
          var line = entries[i];

          // comment or blank line?
          if (reComment.test(line)) {
            continue;
          }

          // multi-line?
          while (reMultiline.test(line) && i < entries.length) {
            line = line.slice(0, line.length - 1) +
              entries[++i].replace(reBlank, '');
          }

          // the extended syntax supports [lang] sections and @import rules
          if (extendedSyntax) {
            if (reSection.test(line)) { // section start?
              match = reSection.exec(line);
              currentLang = match[1];
              skipLang = (currentLang !== '*') &&
                  (currentLang !== lang) && (currentLang !== genericLang);
              continue;
            } else if (skipLang) {
              continue;
            }
            if (reImport.test(line)) { // @import rule?
              match = reImport.exec(line);
              loadImport(baseURL + match[1]); // load the resource synchronously
            }
          }

          // key-value pair
          var tmp = line.match(reSplit);
          if (tmp && tmp.length == 3) {
            // unescape unicode char codes if needed (e.g. '\u00a0')
            var val = tmp[2].replace(reUnicode, function(match, token) {
              return unescape('%u' + '0000'.slice(token.length) + token);
            });
            dictionary[tmp[1]] = evalString(val);
          }
        }
      }

      // import another *.properties file
      function loadImport(url) {
        loadResource(url, function(content) {
          parseRawLines(content, false); // don't allow recursive imports
        }, null, false); // load synchronously
      }

      // fill the dictionary
      parseRawLines(text, true);
      return dictionary;
    }

    // load the specified resource file
    function loadResource(url, onSuccess, onFailure, asynchronous) {
      onSuccess = onSuccess || function _onSuccess(data) {};
      onFailure = onFailure || function _onFailure() {
        consoleWarn(url, ' not found.');
      };

      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, asynchronous);
      if (xhr.overrideMimeType) {
        xhr.overrideMimeType('text/plain; charset=utf-8');
      }
      xhr.onreadystatechange = function() {
        if (xhr.readyState == 4) {
          if (xhr.status == 200 || xhr.status === 0) {
            onSuccess(xhr.responseText);
          } else {
            onFailure();
          }
        }
      };
      xhr.onerror = onFailure;
      xhr.ontimeout = onFailure;

      // in Firefox OS with the app:// protocol, trying to XHR a non-existing
      // URL will raise an exception here -- hence this ugly try...catch.
      try {
        xhr.send(null);
      } catch (e) {
        onFailure();
      }
    }

    // load and parse l10n data (warning: global variables are used here)
    loadResource(href, function(response) {
      if (/\.json$/.test(href)) {
        gL10nData = JSON.parse(response); // TODO: support multiple JSON files
      } else { // *.ini or *.properties file
        var data = parseProperties(response);
        for (var key in data) {
          var id, prop, nestedProp, index = key.lastIndexOf('.');
          if (index > 0) { // a property name has been specified
            id = key.slice(0, index);
            prop = key.slice(index + 1);
            index = id.lastIndexOf('.');
            if (index > 0) { // a nested property may have been specified
              nestedProp = id.substr(index + 1);
              if (gNestedProps.indexOf(nestedProp) > -1) {
                id = id.substr(0, index);
                prop = nestedProp + '.' + prop;
              }
            }
          } else { // no property name: assuming text content by default
            index = key.lastIndexOf('[');
            if (index > 0) { // we have a macro index
              id = key.slice(0, index);
              prop = '_' + key.slice(index);
            } else {
              id = key;
              prop = '_';
            }
          }
          if (!gL10nData[id]) {
            gL10nData[id] = {};
          }
          gL10nData[id][prop] = data[key];
        }
      }

      // trigger callback
      if (successCallback) {
        successCallback();
      }
    }, failureCallback, gAsyncResourceLoading);
  };

  // load and parse all resources for the specified locale
  function loadLocale(lang, translationRequired) {
    clear();
    gReadyState = 'loading';
    gLanguage = lang;

    var untranslatedElements = [];

    // if there is an inline / pre-compiled dictionary,
    // the current HTML document can be translated right now
    var inlineDict = getL10nDictionary(lang);
    if (inlineDict) {
      gL10nData = inlineDict;
      if (translationRequired) {
        untranslatedElements = translateFragment();
      }
    }

    // translate the document if required and fire a `localized' event
    function finish() {
      if (translationRequired) {
        if (!inlineDict) {
          // no inline dictionary has been used: translate the whole document
          untranslatedElements = translateFragment();
        } else if (untranslatedElements.length) {
          // the document should have been already translated but the inline
          // dictionary didn't include all necessary l10n keys:
          // try to translate all remaining elements now
          untranslatedElements = translateElements(untranslatedElements);
        }
      }
      // tell the rest of the world we're done
      // -- note that `gReadyState' must be set before the `localized' event is
      //    fired for `localizeElement()' to work as expected
      gReadyState = 'complete';
      fireL10nReadyEvent(lang);
      consoleWarn_missingKeys(untranslatedElements, lang);
    }

    // l10n resource loader
    function l10nResourceLink(link) {
      /**
       * l10n resource links can use the following syntax for href:
       * <link type="application/l10n" href="resources/{{locale}}.json" />
       * -- in which case, {{locale}} will be replaced by `navigator.language'.
       */
      var re = /\{\{\s*locale\s*\}\}/;

      var parse = function(locale, onload, onerror) {
        var href = unescape(link.href).replace(re, locale);
        parseResource(href, locale, onload, function notFound() {
          consoleWarn(href, ' not found.');
          onerror();
        });
      };

      this.load = function(locale, onload, onerror) {
        onerror = onerror || function() {};
        parse(locale, onload, function parseFallbackLocale() {
          /**
           * For links like <link href="resources/{{locale}}.json" />,
           * there's no way to know if the resource file matching the current
           * language has been found... before trying to fetch it with XHR
           * => if something went wrong, try the default locale as fallback.
           */
          if (re.test(unescape(link.href)) && gDefaultLocale != locale) {
            consoleLog('Trying the fallback locale: ', gDefaultLocale);
            parse(gDefaultLocale, onload, onerror);
          } else {
            onerror();
          }
        });
      };
    }

    // check all <link type="application/l10n" href="..." /> nodes
    // and load the resource files
    var resourceLinks = getL10nResourceLinks();
    var resourceCount = resourceLinks.length;
    if (!resourceCount) {
      consoleLog('no resource to load, early way out');
      translationRequired = false;
      finish();
    } else {
      var onResourceCallback = function() {
        if (--resourceCount <= 0) { // <=> all resources have been XHR'ed
          finish();
        }
      };
      for (var i = 0, l = resourceCount; i < l; i++) {
        var resource = new l10nResourceLink(resourceLinks[i]);
        resource.load(lang, onResourceCallback, onResourceCallback);
      }
    }
  }

  // clear all l10n data
  function clear() {
    gL10nData = {};
    gLanguage = '';
    // TODO: clear all non predefined macros.
    // There's no such macro /yet/ but we're planning to have some...
  }


  /**
   * Get rules for plural forms (shared with JetPack), see:
   * http://unicode.org/repos/cldr-tmp/trunk/diff/supplemental/language_plural_rules.html
   * https://github.com/mozilla/addon-sdk/blob/master/python-lib/plural-rules-generator.p
   *
   * @param {string} lang
   *    locale (language) used.
   *
   * @return {Function}
   *    returns a function that gives the plural form name for a given integer:
   *       var fun = getPluralRules('en');
   *       fun(1)    -> 'one'
   *       fun(0)    -> 'other'
   *       fun(1000) -> 'other'.
   */

  var kPluralForms = ['zero', 'one', 'two', 'few', 'many', 'other'];

  function getPluralRules(lang) {
    var locales2rules = {
      'af': 3,
      'ak': 4,
      'am': 4,
      'ar': 1,
      'asa': 3,
      'az': 0,
      'be': 11,
      'bem': 3,
      'bez': 3,
      'bg': 3,
      'bh': 4,
      'bm': 0,
      'bn': 3,
      'bo': 0,
      'br': 20,
      'brx': 3,
      'bs': 11,
      'ca': 3,
      'cgg': 3,
      'chr': 3,
      'cs': 12,
      'cy': 17,
      'da': 3,
      'de': 3,
      'dv': 3,
      'dz': 0,
      'ee': 3,
      'el': 3,
      'en': 3,
      'eo': 3,
      'es': 3,
      'et': 3,
      'eu': 3,
      'fa': 0,
      'ff': 5,
      'fi': 3,
      'fil': 4,
      'fo': 3,
      'fr': 5,
      'fur': 3,
      'fy': 3,
      'ga': 8,
      'gd': 24,
      'gl': 3,
      'gsw': 3,
      'gu': 3,
      'guw': 4,
      'gv': 23,
      'ha': 3,
      'haw': 3,
      'he': 2,
      'hi': 4,
      'hr': 11,
      'hu': 0,
      'id': 0,
      'ig': 0,
      'ii': 0,
      'is': 3,
      'it': 3,
      'iu': 7,
      'ja': 0,
      'jmc': 3,
      'jv': 0,
      'ka': 0,
      'kab': 5,
      'kaj': 3,
      'kcg': 3,
      'kde': 0,
      'kea': 0,
      'kk': 3,
      'kl': 3,
      'km': 0,
      'kn': 0,
      'ko': 0,
      'ksb': 3,
      'ksh': 21,
      'ku': 3,
      'kw': 7,
      'lag': 18,
      'lb': 3,
      'lg': 3,
      'ln': 4,
      'lo': 0,
      'lt': 10,
      'lv': 6,
      'mas': 3,
      'mg': 4,
      'mk': 16,
      'ml': 3,
      'mn': 3,
      'mo': 9,
      'mr': 3,
      'ms': 0,
      'mt': 15,
      'my': 0,
      'nah': 3,
      'naq': 7,
      'nb': 3,
      'nd': 3,
      'ne': 3,
      'nl': 3,
      'nn': 3,
      'no': 3,
      'nr': 3,
      'nso': 4,
      'ny': 3,
      'nyn': 3,
      'om': 3,
      'or': 3,
      'pa': 3,
      'pap': 3,
      'pl': 13,
      'ps': 3,
      'pt': 3,
      'rm': 3,
      'ro': 9,
      'rof': 3,
      'ru': 11,
      'rwk': 3,
      'sah': 0,
      'saq': 3,
      'se': 7,
      'seh': 3,
      'ses': 0,
      'sg': 0,
      'sh': 11,
      'shi': 19,
      'sk': 12,
      'sl': 14,
      'sma': 7,
      'smi': 7,
      'smj': 7,
      'smn': 7,
      'sms': 7,
      'sn': 3,
      'so': 3,
      'sq': 3,
      'sr': 11,
      'ss': 3,
      'ssy': 3,
      'st': 3,
      'sv': 3,
      'sw': 3,
      'syr': 3,
      'ta': 3,
      'te': 3,
      'teo': 3,
      'th': 0,
      'ti': 4,
      'tig': 3,
      'tk': 3,
      'tl': 4,
      'tn': 3,
      'to': 0,
      'tr': 0,
      'ts': 3,
      'tzm': 22,
      'uk': 11,
      'ur': 3,
      've': 3,
      'vi': 0,
      'vun': 3,
      'wa': 4,
      'wae': 3,
      'wo': 0,
      'xh': 3,
      'xog': 3,
      'yo': 0,
      'zh': 0,
      'zu': 3
    };

    // utility functions for plural rules methods
    function isIn(n, list) {
      return list.indexOf(n) !== -1;
    }
    function isBetween(n, start, end) {
      return start <= n && n <= end;
    }

    // list of all plural rules methods:
    // map an integer to the plural form name to use
    var pluralRules = {
      '0': function(n) {
        return 'other';
      },
      '1': function(n) {
        if ((isBetween((n % 100), 3, 10)))
          return 'few';
        if (n === 0)
          return 'zero';
        if ((isBetween((n % 100), 11, 99)))
          return 'many';
        if (n == 2)
          return 'two';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '2': function(n) {
        if (n !== 0 && (n % 10) === 0)
          return 'many';
        if (n == 2)
          return 'two';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '3': function(n) {
        if (n == 1)
          return 'one';
        return 'other';
      },
      '4': function(n) {
        if ((isBetween(n, 0, 1)))
          return 'one';
        return 'other';
      },
      '5': function(n) {
        if ((isBetween(n, 0, 2)) && n != 2)
          return 'one';
        return 'other';
      },
      '6': function(n) {
        if (n === 0)
          return 'zero';
        if ((n % 10) == 1 && (n % 100) != 11)
          return 'one';
        return 'other';
      },
      '7': function(n) {
        if (n == 2)
          return 'two';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '8': function(n) {
        if ((isBetween(n, 3, 6)))
          return 'few';
        if ((isBetween(n, 7, 10)))
          return 'many';
        if (n == 2)
          return 'two';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '9': function(n) {
        if (n === 0 || n != 1 && (isBetween((n % 100), 1, 19)))
          return 'few';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '10': function(n) {
        if ((isBetween((n % 10), 2, 9)) && !(isBetween((n % 100), 11, 19)))
          return 'few';
        if ((n % 10) == 1 && !(isBetween((n % 100), 11, 19)))
          return 'one';
        return 'other';
      },
      '11': function(n) {
        if ((isBetween((n % 10), 2, 4)) && !(isBetween((n % 100), 12, 14)))
          return 'few';
        if ((n % 10) === 0 ||
            (isBetween((n % 10), 5, 9)) ||
            (isBetween((n % 100), 11, 14)))
          return 'many';
        if ((n % 10) == 1 && (n % 100) != 11)
          return 'one';
        return 'other';
      },
      '12': function(n) {
        if ((isBetween(n, 2, 4)))
          return 'few';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '13': function(n) {
        if ((isBetween((n % 10), 2, 4)) && !(isBetween((n % 100), 12, 14)))
          return 'few';
        if (n != 1 && (isBetween((n % 10), 0, 1)) ||
            (isBetween((n % 10), 5, 9)) ||
            (isBetween((n % 100), 12, 14)))
          return 'many';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '14': function(n) {
        if ((isBetween((n % 100), 3, 4)))
          return 'few';
        if ((n % 100) == 2)
          return 'two';
        if ((n % 100) == 1)
          return 'one';
        return 'other';
      },
      '15': function(n) {
        if (n === 0 || (isBetween((n % 100), 2, 10)))
          return 'few';
        if ((isBetween((n % 100), 11, 19)))
          return 'many';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '16': function(n) {
        if ((n % 10) == 1 && n != 11)
          return 'one';
        return 'other';
      },
      '17': function(n) {
        if (n == 3)
          return 'few';
        if (n === 0)
          return 'zero';
        if (n == 6)
          return 'many';
        if (n == 2)
          return 'two';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '18': function(n) {
        if (n === 0)
          return 'zero';
        if ((isBetween(n, 0, 2)) && n !== 0 && n != 2)
          return 'one';
        return 'other';
      },
      '19': function(n) {
        if ((isBetween(n, 2, 10)))
          return 'few';
        if ((isBetween(n, 0, 1)))
          return 'one';
        return 'other';
      },
      '20': function(n) {
        if ((isBetween((n % 10), 3, 4) || ((n % 10) == 9)) && !(
            isBetween((n % 100), 10, 19) ||
            isBetween((n % 100), 70, 79) ||
            isBetween((n % 100), 90, 99)
            ))
          return 'few';
        if ((n % 1000000) === 0 && n !== 0)
          return 'many';
        if ((n % 10) == 2 && !isIn((n % 100), [12, 72, 92]))
          return 'two';
        if ((n % 10) == 1 && !isIn((n % 100), [11, 71, 91]))
          return 'one';
        return 'other';
      },
      '21': function(n) {
        if (n === 0)
          return 'zero';
        if (n == 1)
          return 'one';
        return 'other';
      },
      '22': function(n) {
        if ((isBetween(n, 0, 1)) || (isBetween(n, 11, 99)))
          return 'one';
        return 'other';
      },
      '23': function(n) {
        if ((isBetween((n % 10), 1, 2)) || (n % 20) === 0)
          return 'one';
        return 'other';
      },
      '24': function(n) {
        if ((isBetween(n, 3, 10) || isBetween(n, 13, 19)))
          return 'few';
        if (isIn(n, [2, 12]))
          return 'two';
        if (isIn(n, [1, 11]))
          return 'one';
        return 'other';
      }
    };

    // return a function that gives the plural form name for a given integer
    var index = locales2rules[lang.replace(/-.*$/, '')];
    if (!(index in pluralRules)) {
      consoleWarn('plural form unknown for [', lang, ']');
      return function() { return 'other'; };
    }
    return pluralRules[index];
  }

  // pre-defined 'plural' macro
  gMacros.plural = function(str, param, key, prop) {
    var n = parseFloat(param);
    if (isNaN(n)) {
      return str;
    }

    var data = gL10nData[key];
    if (!data) {
      return str;
    }

    // initialize _pluralRules
    if (!gMacros._pluralRules) {
      gMacros._pluralRules = getPluralRules(gLanguage);
    }
    var index = '[' + gMacros._pluralRules(n) + ']';

    // try to find a [zero|one|two] form if it's defined
    if (n === 0 && (prop + '[zero]') in data) {
      str = data[prop + '[zero]'];
    } else if (n == 1 && (prop + '[one]') in data) {
      str = data[prop + '[one]'];
    } else if (n == 2 && (prop + '[two]') in data) {
      str = data[prop + '[two]'];
    } else if ((prop + index) in data) {
      str = data[prop + index];
    } else if ((prop + '[other]') in data) {
      str = data[prop + '[other]'];
    }

    return str;
  };


  /**
   * l10n dictionary functions
   */

  var reArgs = /\{\{\s*(.+?)\s*\}\}/;                       // arguments
  var reIndex = /\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/; // index macros

  // fetch an l10n object, warn if not found, apply `args' if possible
  function getL10nData(key, args) {
    var data = gL10nData[key];
    if (!data) {
      return null;
    }

    /**
     * This is where l10n expressions should be processed.
     * The plan is to support C-style expressions from the l20n project;
     * until then, only two kinds of simple expressions are supported:
     *   {[ index ]} and {{ arguments }}.
     */
    var rv = {};
    for (var prop in data) {
      var str = data[prop];
      str = substIndexes(str, args, key, prop);
      str = substArguments(str, args, key);
      rv[prop] = str;
    }
    return rv;
  }

  // return an array of all {{arguments}} found in a string
  function getL10nArgs(str) {
    var args = [];
    var match = reArgs.exec(str);
    while (match && match.length >= 2) {
      args.push({
        name: match[1], // name of the argument
        subst: match[0] // substring to replace (including braces and spaces)
      });
      str = str.substr(match.index + match[0].length);
      match = reArgs.exec(str);
    }
    return args;
  }

  // return a sub-dictionary sufficient to translate a given fragment
  function getSubDictionary(fragment) {
    if (!fragment) { // by default, return a clone of the whole dictionary
      return JSON.parse(JSON.stringify(gL10nData));
    }

    var dict = {};
    var elements = getTranslatableChildren(fragment);

    function checkGlobalArguments(str) {
      var match = getL10nArgs(str);
      for (var i = 0; i < match.length; i++) {
        var arg = match[i].name;
        if (arg in gL10nData) {
          dict[arg] = gL10nData[arg];
        }
      }
    }

    for (var i = 0, l = elements.length; i < l; i++) {
      var id = getL10nAttributes(elements[i]).id;
      var data = gL10nData[id];
      if (!id || !data) {
        continue;
      }

      dict[id] = data;
      for (var prop in data) {
        var str = data[prop];
        checkGlobalArguments(str);

        if (reIndex.test(str)) { // macro index
          for (var j = 0; j < kPluralForms.length; j++) {
            var key = id + '[' + kPluralForms[j] + ']';
            if (key in gL10nData) {
              dict[key] = gL10nData[key];
              checkGlobalArguments(gL10nData[key]);
            }
          }
        }
      }
    }

    return dict;
  }

  // replace {[macros]} with their values
  function substIndexes(str, args, key, prop) {
    var reMatch = reIndex.exec(str);
    if (!reMatch || !reMatch.length) {
      return str;
    }

    // an index/macro has been found
    // Note: at the moment, only one parameter is supported
    var macroName = reMatch[1];
    var paramName = reMatch[2];
    var param;
    if (args && paramName in args) {
      param = args[paramName];
    } else if (paramName in gL10nData) {
      param = gL10nData[paramName];
    }

    // there's no macro parser yet: it has to be defined in gMacros
    if (macroName in gMacros) {
      var macro = gMacros[macroName];
      str = macro(str, param, key, prop);
    }
    return str;
  }

  // replace {{arguments}} with their values
  function substArguments(str, args, key) {
    var match = getL10nArgs(str);
    for (var i = 0; i < match.length; i++) {
      var sub, arg = match[i].name;
      if (args && arg in args) {
        sub = args[arg];
      } else if (arg in gL10nData) {
        sub = gL10nData[arg]['_'];
      } else {
        consoleLog('argument {{', arg, '}} for #', key, ' is undefined.');
        return str;
      }
      if (typeof sub == 'string') {
        // dollar signs would be interpreted as replacement patterns
        sub = sub.replace(/\$/g, '$$$$');
      }
      str = str.replace(match[i].subst, sub);
    }
    return str;
  }

  // translate an HTML element
  // -- returns true if the element could be translated, false otherwise
  function translateElement(element) {
    var l10n = getL10nAttributes(element);
    if (!l10n.id) {
      return true;
    }

    // get the related l10n object
    var data = getL10nData(l10n.id, l10n.args);
    if (!data) {
      return false;
    }

    // translate element (TODO: security checks?)
    for (var k in data) {
      if (k === '_') {
        setTextContent(element, data._);
      } else {
        var idx = k.lastIndexOf('.');
        var nestedProp = k.substr(0, idx);
        if (gNestedProps.indexOf(nestedProp) > -1) {
          element[nestedProp][k.substr(idx + 1)] = data[k];
        } else if (k === 'ariaLabel') {
          element.setAttribute('aria-label', data[k]);
        } else {
          element[k] = data[k];
        }
      }
    }
    return true;
  }

  // translate an array of HTML elements
  // -- returns an array of elements that could not be translated
  function translateElements(elements) {
    var untranslated = [];
    for (var i = 0, l = elements.length; i < l; i++) {
      if (!translateElement(elements[i])) {
        untranslated.push(elements[i]);
      }
    }
    return untranslated;
  }

  // translate an HTML subtree
  // -- returns an array of elements that could not be translated
  function translateFragment(element) {
    element = element || document.documentElement;
    var untranslated = translateElements(getTranslatableChildren(element));
    if (!translateElement(element)) {
      untranslated.push(element);
    }
    return untranslated;
  }

  // localize an element as soon as mozL10n is ready
  function localizeElement(element, id, args) {
    if (!element) {
      return;
    }

    if (!id) {
      element.removeAttribute('data-l10n-id');
      element.removeAttribute('data-l10n-args');
      setTextContent(element, '');
      return;
    }

    // set the data-l10n-[id|args] attributes
    element.setAttribute('data-l10n-id', id);
    if (args && typeof args === 'object') {
      element.setAttribute('data-l10n-args', JSON.stringify(args));
    } else {
      element.removeAttribute('data-l10n-args');
    }

    // if l10n resources are ready, translate now;
    // if not, the element will be translated along with the document anyway.
    if (gReadyState === 'complete') {
      translateElement(element);
    }
  }


  /**
   * Startup & Public API
   *
   * This section is quite specific to the B2G project: old browsers are not
   * supported and the API is slightly different from the standard webl10n one.
   */

  // load the default locale on startup
  function l10nStartup() {
    gDefaultLocale = document.documentElement.lang || gDefaultLocale;
    gReadyState = 'interactive';
    consoleLog('loading [', navigator.language, '] resources, ',
        (gAsyncResourceLoading ? 'asynchronously.' : 'synchronously.'));

    // load the default locale and translate the document if required
    var translationRequired =
      (document.documentElement.lang !== navigator.language);
    loadLocale(navigator.language, translationRequired);
  }

  // the B2G build system doesn't expose any `document'...
  if (typeof(document) !== 'undefined') {
    if (document.readyState === 'complete' ||
      document.readyState === 'interactive') {
      window.setTimeout(l10nStartup);
    } else {
      document.addEventListener('DOMContentLoaded', l10nStartup);
    }
  }

  // load the appropriate locale if the language setting has changed
  if ('mozSettings' in navigator && navigator.mozSettings) {
    navigator.mozSettings.addObserver('language.current', function(event) {
      loadLocale(event.settingValue, true);
    });
  }

  // public API
  navigator.mozL10n = {
    // get a localized string
    get: function l10n_get(key, args) {
      var data = getL10nData(key, args);
      if (!data) {
        consoleWarn('#', key, ' is undefined.');
        return '';
      } else {
        return data._;
      }
    },

    // get|set the document language and direction
    get language() {
      return {
        // get|set the document language (ISO-639-1)
        get code() { return gLanguage; },
        set code(lang) { loadLocale(lang, true); },

        // get the direction (ltr|rtl) of the current language
        get direction() {
          // http://www.w3.org/International/questions/qa-scripts
          // Arabic, Hebrew, Farsi, Pashto, Urdu
          var rtlList = ['ar', 'he', 'fa', 'ps', 'ur'];
          return (rtlList.indexOf(gLanguage) >= 0) ? 'rtl' : 'ltr';
        }
      };
    },

    // translate an element or document fragment
    translate: translateFragment,

    // localize an element (= set its data-l10n-* attributes and translate it)
    localize: localizeElement,

    // get (a part of) the dictionary for the current locale
    getDictionary: getSubDictionary,

    // this can be used to prevent race conditions
    get readyState() { return gReadyState; },
    ready: function l10n_ready(callback) {
      if (!callback) {
        return;
      }
      if (gReadyState == 'complete') {
        window.setTimeout(callback);
      } else {
        window.addEventListener('localized', callback);
      }
    }
  };

  consoleLog('library loaded.');
})(this);


define("l10n", function(){});

require(['config/require', 'config'], function() {
  

  define('boot', ['require','debug','app','lib/camera','lib/sounds','lib/settings','config/sounds','config/settings','lib/geo-location','lib/activity','lib/storage','lib/pinch','controllers/hud','controllers/controls','controllers/viewfinder','controllers/recording-timer','controllers/preview-gallery','controllers/overlay','controllers/confirm','controllers/settings','controllers/activity','controllers/camera','controllers/sounds','controllers/timer','controllers/zoom-bar','controllers/indicators','controllers/battery','l10n'],function(require) {
    var debug = require('debug')('main');
    var timing = window.performance.timing;
    debug('domloaded in %s', (timing.domComplete - timing.domLoading) + 'ms');

    /**
     * Module Dependencies
     */

    var App = require('app');
    var Camera = require('lib/camera');
    var Sounds = require('lib/sounds');
    var Settings = require('lib/settings');
    var sounds = new Sounds(require('config/sounds'));
    var settings = new Settings(require('config/settings'));
    var GeoLocation = require('lib/geo-location');
    var Activity = require('lib/activity');
    var Storage = require('lib/storage');
    var Pinch = require('lib/pinch');

    var controllers = {
      hud: require('controllers/hud'),
      controls: require('controllers/controls'),
      viewfinder: require('controllers/viewfinder'),
      recordingTimer: require('controllers/recording-timer'),
      previewGallery: require('controllers/preview-gallery'),
      overlay: require('controllers/overlay'),
      confirm: require('controllers/confirm'),
      settings: require('controllers/settings'),
      activity: require('controllers/activity'),
      camera: require('controllers/camera'),
      sounds: require('controllers/sounds'),
      timer: require('controllers/timer'),
      zoomBar: require('controllers/zoom-bar'),
      indicators: require('controllers/indicators'),
      battery: require('controllers/battery')
    };

    // Attach navigator.mozL10n
    require('l10n');

    debug('required dependencies');

    var camera = new Camera({
      maxFileSizeBytes: 0,
      maxWidth: 0,
      maxHeight: 0,
      container: document.body,
      cafEnabled: settings.caf.enabled()
    });

    /**
     * Create new `App`
     */

    var app = window.app = new App({
      win: window,
      doc: document,
      el: document.body,
      geolocation: new GeoLocation(),
      activity: new Activity(),
      settings: settings,
      camera: camera,
      sounds: sounds,
      controllers: controllers,
      storage: new Storage(),
      Pinch: Pinch
    });

    debug('created app');

    // Fetch persistent settings
    app.settings.fetch();

    // Check for activities, then boot
    app.activity.check(app.boot);
  });

  require(['boot']);
});

define("main", function(){});
