define("mailapi/errbackoff", [ "./date", "rdcommon/log", "module", "exports" ], function(e, t, n, s) {
    function i(e, t, n) {
        this.state = "healthy", this._iNextBackoff = 0, this._LOG = a.BackoffEndpoint(this, n, e), 
        this._LOG.state(this.state), this._badResources = {}, this.listener = t;
    }
    var r = s.BACKOFF_DURATIONS = [ {
        fixedMS: 0,
        randomMS: 0
    }, {
        fixedMS: 800,
        randomMS: 400
    }, {
        fixedMS: 4500,
        randomMS: 1e3
    } ], o = window.setTimeout.bind(window);
    s.TEST_useTimeoutFunc = function(e) {
        o = e;
        for (var t = 0; t < r.length; t++) r[t].randomMS = 0;
    }, i.prototype = {
        _setState: function(e) {
            this.state !== e && (this.state = e, this._LOG.state(e), this.listener && this.listener.onEndpointStateChange(e));
        },
        noteConnectSuccess: function() {
            this._setState("healthy"), this._iNextBackoff = 0;
        },
        noteConnectFailureMaybeRetry: function(e) {
            return this._LOG.connectFailure(e), "shutdown" === this.state ? !1 : e ? (this._setState("broken"), 
            !1) : (this._iNextBackoff > 0 && this._setState(e ? "broken" : "unreachable"), this._iNextBackoff >= r.length ? !1 : !0);
        },
        noteBrokenConnection: function() {
            this._LOG.connectFailure(!0), this._setState("broken"), this._iNextBackoff = r.length;
        },
        scheduleConnectAttempt: function(e) {
            if ("shutdown" !== this.state) {
                if (this._iNextBackoff >= r.length) return e(), void 0;
                var t = r[this._iNextBackoff++], n = t.fixedMS + Math.floor(Math.random() * t.randomMS);
                o(e, n);
            }
        },
        noteBadResource: function(t) {
            var n = e.NOW();
            if (this._badResources.hasOwnProperty(t)) {
                var s = this._badResources[t];
                s.count++, s.last = n;
            } else this._badResources[t] = {
                count: 1,
                last: n
            };
        },
        resourceIsOkayToUse: function(t) {
            return this._badResources.hasOwnProperty(t) ? (this._badResources[t], e.NOW(), void 0) : !0;
        },
        shutdown: function() {
            this._setState("shutdown");
        }
    }, s.createEndpoint = function(e, t, n) {
        return new i(e, t, n);
    };
    var a = s.LOGFAB = t.register(n, {
        BackoffEndpoint: {
            type: t.TASK,
            subtype: t.CLIENT,
            stateVars: {
                state: !1
            },
            events: {
                connectFailure: {
                    reachable: !0
                }
            },
            errors: {}
        }
    });
}), define("mailapi/composite/incoming", [ "rdcommon/log", "../a64", "../accountmixins", "../mailslice", "../searchfilter", "../util", "require", "exports" ], function(e, t, n, s, i, r, o, a) {
    function c(e, t) {
        return e.path.localeCompare(t.path);
    }
    function d(e, t, n, i, r, o, a, c) {
        this.universe = t, this.compositeAccount = n, this.id = i, this.accountDef = n.accountDef, 
        this.enabled = !0, this._alive = !0, this._credentials = r, this._connInfo = o, 
        this._db = c;
        var d = this._folderStorages = {}, l = this.folders = [];
        this.FolderSyncer = e, this._deadFolderIds = null, this._folderInfos = a, this.meta = this._folderInfos.$meta, 
        this.mutations = this._folderInfos.$mutations;
        for (var u in a) if ("$" !== u[0]) {
            var h = a[u];
            d[u] = new s.FolderStorage(this, u, h, this._db, e, this._LOG), l.push(h.$meta);
        }
        this.folders.sort(function(e, t) {
            return e.path.localeCompare(t.path);
        });
        var p = this.getFirstFolderWithType("inbox");
        p || this._learnAboutFolder("INBOX", "INBOX", null, "inbox", "/", 0, !0);
    }
    var l = r.bsearchForInsert;
    a.CompositeIncomingAccount = d, d.prototype = {
        runOp: n.runOp,
        getFirstFolderWithType: n.getFirstFolderWithType,
        getFolderByPath: n.getFolderByPath,
        saveAccountState: n.saveAccountState,
        runAfterSaves: n.runAfterSaves,
        _learnAboutFolder: function(e, n, i, r, o, a, d) {
            var u = this.id + "/" + t.encodeInt(this.meta.nextFolderNum++), h = this._folderInfos[u] = {
                $meta: {
                    id: u,
                    name: e,
                    type: r,
                    path: n,
                    parentId: i,
                    delim: o,
                    depth: a,
                    lastSyncedAt: 0
                },
                $impl: {
                    nextId: 0,
                    nextHeaderBlock: 0,
                    nextBodyBlock: 0
                },
                accuracy: [],
                headerBlocks: [],
                bodyBlocks: [],
                serverIdHeaderBlockMapping: null
            };
            this._folderStorages[u] = new s.FolderStorage(this, u, h, this._db, this.FolderSyncer, this._LOG);
            var p = h.$meta, f = l(this.folders, p, c);
            return this.folders.splice(f, 0, p), d || this.universe.__notifyAddedFolder(this, p), 
            p;
        },
        _forgetFolder: function(e, t) {
            var n = this._folderInfos[e], s = n.$meta;
            delete this._folderInfos[e];
            var i = this._folderStorages[e];
            delete this._folderStorages[e];
            var r = this.folders.indexOf(s);
            this.folders.splice(r, 1), null === this._deadFolderIds && (this._deadFolderIds = []), 
            this._deadFolderIds.push(e), i.youAreDeadCleanupAfterYourself(), t || this.universe.__notifyRemovedFolder(this, s);
        },
        _recreateFolder: function(e, t) {
            this._LOG.recreateFolder(e);
            var n = this._folderInfos[e];
            n.$impl = {
                nextId: 0,
                nextHeaderBlock: 0,
                nextBodyBlock: 0
            }, n.accuracy = [], n.headerBlocks = [], n.bodyBlocks = [], null === this._deadFolderIds && (this._deadFolderIds = []), 
            this._deadFolderIds.push(e);
            var i = this;
            this.saveAccountState(null, function() {
                var r = new s.FolderStorage(i, e, n, i._db, i.FolderSyncer, i._LOG);
                for (var o in Iterator(i._folderStorages[e]._slices)) {
                    var a = o[1];
                    a._storage = r, a.reset(), r.sliceOpenMostRecent(a);
                }
                i._folderStorages[e]._slices = [], i._folderStorages[e] = r, t(r);
            }, "recreateFolder");
        },
        __checkpointSyncCompleted: function(e) {
            this.saveAccountState(null, e, "checkpointSync");
        },
        deleteFolder: function(e, t) {
            function n(e) {
                o = e, o.delBox(r.path, s);
            }
            function s(e) {
                e ? i("unknown") : i(null);
            }
            function i(n) {
                o && (a.__folderDoneWithConnection(o, !1, !1), o = null), n || (a._LOG.deleteFolder(r.path), 
                a._forgetFolder(e)), t && t(n, r);
            }
            if (!this._folderInfos.hasOwnProperty(e)) throw new Error("No such folder: " + e);
            if (!this.universe.online) return t && t("offline"), void 0;
            var r = this._folderInfos[e].$meta, o = null, a = this;
            this.__folderDemandsConnection(null, "deleteFolder", n);
        },
        getFolderStorageForFolderId: function(e) {
            if (this._folderStorages.hasOwnProperty(e)) return this._folderStorages[e];
            throw new Error("No folder with id: " + e);
        },
        getFolderStorageForMessageSuid: function(e) {
            var t = e.substring(0, e.lastIndexOf("/"));
            if (this._folderStorages.hasOwnProperty(t)) return this._folderStorages[t];
            throw new Error("No folder with id: " + t);
        },
        getFolderMetaForFolderId: function(e) {
            return this._folderInfos.hasOwnProperty(e) ? this._folderInfos[e].$meta : null;
        },
        sliceFolderMessages: function(e, t) {
            var n = this._folderStorages[e], i = new s.MailSlice(t, n, this._LOG);
            n.sliceOpenMostRecent(i);
        },
        searchFolderMessages: function(e, t, n, s) {
            var r = this._folderStorages[e], o = new i.SearchSlice(t, r, n, s, this._LOG);
            return r.sliceOpenSearch(o), o;
        },
        shutdownFolders: function() {
            for (var e = 0; e < this.folders.length; e++) {
                var t = this.folders[e], n = this._folderStorages[t.id];
                n.shutdown();
            }
        },
        scheduleMessagePurge: function(e, t) {
            this.universe.purgeExcessMessages(this.compositeAccount, e, t);
        },
        ensureEssentialFolders: function(e) {
            function t() {
                --s || e && e(null);
            }
            var n = {
                trash: "Trash",
                sent: "Sent"
            }, s = 1;
            for (var i in n) this.getFirstFolderWithType(i) || (s++, this.universe.createFolder(this.id, null, n[i], !1, t));
            t();
        },
        onEndpointStateChange: function(e) {
            switch (e) {
              case "healthy":
                this.universe.__removeAccountProblem(this.compositeAccount, "connection");
                break;

              case "unreachable":
              case "broken":
                this.universe.__reportAccountProblem(this.compositeAccount, "connection");
            }
        }
    }, a.LOGFAB_DEFINITION = {
        CompositeIncomingAccount: {
            type: e.ACCOUNT,
            events: {
                createFolder: {},
                deleteFolder: {},
                recreateFolder: {
                    id: !1
                },
                createConnection: {},
                reuseConnection: {},
                releaseConnection: {},
                deadConnection: {},
                unknownDeadConnection: {},
                connectionMismatch: {},
                saveAccountState: {
                    reason: !1
                },
                accountDeleted: {
                    where: !1
                },
                maximumConnsNoNew: {}
            },
            TEST_ONLY_events: {
                deleteFolder: {
                    path: !1
                },
                createConnection: {
                    label: !1
                },
                reuseConnection: {
                    label: !1
                },
                releaseConnection: {
                    label: !1
                },
                deadConnection: {},
                connectionMismatch: {}
            },
            errors: {
                connectionError: {},
                folderAlreadyHasConn: {
                    folderId: !1
                },
                opError: {
                    mode: !1,
                    type: !1,
                    ex: e.EXCEPTION
                }
            },
            asyncJobs: {
                checkAccount: {
                    err: null
                },
                runOp: {
                    mode: !0,
                    type: !0,
                    error: !1,
                    op: !1
                }
            },
            TEST_ONLY_asyncJobs: {}
        }
    };
}), define("mailapi/imap/folder", [ "rdcommon/log", "../a64", "../allback", "../date", "../syncbase", "../util", "module", "require", "exports" ], function(e, t, n, s, i, r, o, a, c) {
    function d(e) {
        for (var t = 0, n = e.length, s = 0; n > s; s++) {
            var i = e[s];
            null !== i ? t && (e[s - t] = i) : t++;
        }
        return t && e.splice(n - t, t), e;
    }
    function l(e, t, n) {
        this._account = e, this._storage = t, this._LOG = M.ImapFolderConn(this, n, t.folderId), 
        this._conn = null, this.box = null, this._deathback = null;
    }
    function u(e, t, n) {
        this._account = e, this.folderStorage = t, this._LOG = M.ImapFolderSyncer(this, n, t.folderId), 
        this._syncSlice = null, this._curSyncAccuracyStamp = null, this._curSyncDir = 1, 
        this._curSyncIsGrow = null, this._nextSyncAnchorTS = null, this._fallbackOriginTS = null, 
        this._syncThroughTS = null, this._curSyncDayStep = null, this._curSyncDoNotGrowBoundary = null, 
        this._curSyncDoneCallback = null, this.folderConn = new l(e, t, this._LOG);
    }
    function h() {}
    var p = null, f = null, m = null, g = null, _ = null, y = n.allbackMaker, v = (r.bsearchForInsert, 
    r.bsearchMaybeExists, r.cmpHeaderYoungToOld, s.DAY_MILLIS), b = s.NOW, S = (s.BEFORE, 
    s.ON_OR_BEFORE, s.SINCE), w = s.TIME_DIR_AT_OR_BEYOND, T = (s.TIME_DIR_ADD, s.TIME_DIR_DELTA, 
    s.makeDaysAgo), E = s.makeDaysBefore, A = s.quantizeDate, I = 1, C = -1, x = [ "!DELETED" ], k = 256, N = Math.pow(2, 32) - 1;
    l.prototype = {
        acquireConn: function(e, t, n, s) {
            var i = this;
            this._deathback = t, this._account.__folderDemandsConnection(this._storage.folderId, n, function(t) {
                i._conn = t, i._conn.openBox(i._storage.folderMeta.path, function(t, n) {
                    if (t) {
                        if (console.error("Problem entering folder", i._storage.folderMeta.path), i._conn = null, 
                        i._account.__folderDoneWithConnection(i._conn, !1, !0), i._deathback) {
                            var s = i._deathback;
                            i.clearErrorHandler(), s();
                        }
                    } else i.box = n, e(i, i._storage);
                });
            }, function() {
                if (i._conn = null, i._deathback) {
                    var e = i._deathback;
                    i.clearErrorHandler(), e();
                }
            }, s);
        },
        relinquishConn: function() {
            this._conn && (this.clearErrorHandler(), this._account.__folderDoneWithConnection(this._conn, !0, !1), 
            this._conn = null);
        },
        withConnection: function(e, t, n, s) {
            return this._conn ? (this._deathback = t, e(this), void 0) : (this.acquireConn(function() {
                this.withConnection(e, t, n);
            }.bind(this), t, n, s), void 0);
        },
        clearErrorHandler: function() {
            this._deathback = null;
        },
        reselectBox: function(e) {
            this._conn.openBox(this._storage.folderMeta.path, e);
        },
        _timelySyncSearch: function(e, t, n, s) {
            return this._conn ? (this._deathback = n, s && s(.1), this._account.isGmail && this._conn.noop(), 
            this._conn.search(e, function(s, i) {
                return s ? (console.error("Search error on", e, "err:", s), n(), void 0) : (t(i), 
                void 0);
            }), void 0) : (this.acquireConn(this._timelySyncSearch.bind(this, e, t, n, s), n, "sync", !0), 
            void 0);
        },
        syncDateRange: function() {
            var e = Array.slice(arguments), t = this;
            a([ "./protocol/sync" ], function(n) {
                _ = n, (t.syncDateRange = t._lazySyncDateRange).apply(t, e);
            });
        },
        _lazySyncDateRange: function(e, t, n, s, r) {
            if (e && t && S(e, t)) return this._LOG.illegalSync(e, t), s("invariant"), void 0;
            console.log("syncDateRange:", e, t);
            var o = x.concat(), a = this, c = a._storage, l = i.BISECT_DATE_AT_N_MESSAGES;
            e && o.push([ "SINCE", e ]), t && o.push([ "BEFORE", t ]);
            var u = y([ "search", "db" ], function(i) {
                var o = i.search, u = i.db, m = [], g = 0, y = a._conn._state.box.highestModSeq || "";
                if (console.log("SERVER UIDS", o.length, l), o.length > l) {
                    var S = t || A(b() + v + a._account.tzOffset), w = Math.round((S - e) / v);
                    if (console.log("BISECT CASE", o.length, "curDaysDelta", w), w > 1) {
                        a._LOG.syncDateRange_end(null, null, null, e, t, null, null);
                        var T = {
                            oldStartTS: e,
                            oldEndTS: t,
                            numHeaders: o.length,
                            curDaysDelta: w,
                            newStartTS: e,
                            newEndTS: t
                        };
                        return "abort" === s("bisect", T, null) ? (a.clearErrorHandler(), s("bisect-aborted", null), 
                        null) : a.syncDateRange(T.newStartTS, T.newEndTS, n, s, r);
                    }
                }
                r && r(.25);
                for (var E = 0; E < u.length; E++) {
                    var I = u[E], C = o.indexOf(I.srvid);
                    -1 !== C ? (o[C] = null, m.push(I.srvid)) : (c.deleteMessageHeaderAndBodyUsingHeader(I), 
                    g++, u[E] = null);
                }
                var x = d(o);
                g && d(u);
                var k = new _.Sync({
                    connection: a._conn,
                    storage: a._storage,
                    newUIDs: x,
                    knownUIDs: m,
                    knownHeaders: u
                });
                k.onprogress = r, k.oncomplete = function(i, r) {
                    a._LOG.syncDateRange_end(i, r, g, e, t, null, null), a._storage.markSyncRange(e, t, y, n), 
                    f || (f = !0, a.clearErrorHandler(), s(null, null, i + r, h, p));
                };
            }), h = e - this._account.tzOffset, p = t ? t - this._account.tzOffset : null, f = !1;
            console.log("Skewed DB lookup. Start: ", h, new Date(h).toUTCString(), "End: ", p, p ? new Date(p).toUTCString() : null), 
            this._LOG.syncDateRange_begin(null, null, null, e, t, h, p), this._timelySyncSearch(o, u.search, function() {
                f || (f = !0, this._LOG.syncDateRange_end(0, 0, 0, e, t, null, null), s("aborted"));
            }.bind(this), r), this._storage.getAllMessagesInImapDateRange(h, p, u.db);
        },
        searchDateRange: function(e, t, n) {
            var s = x.concat(n);
            t && s.push([ "SINCE", t ]), e && s.push([ "BEFORE", e ]);
        },
        downloadBodyReps: function() {
            var e = Array.slice(arguments), t = this;
            a([ "./imapchew", "./protocol/bodyfetcher", "./protocol/textparser", "./protocol/snippetparser" ], function(n, s, i, r) {
                g = n, m = s, p = i, f = r, (t.downloadBodyReps = t._lazyDownloadBodyReps).apply(t, e);
            });
        },
        _lazyDownloadBodyReps: function(e, t, n) {
            "function" == typeof t && (n = t, t = null), t = t || {};
            var s = this, i = function(i) {
                var r = g.selectSnippetBodyRep(e, i), o = t.maximumBytesToFetch, a = p.TextParser, c = [];
                if (i.bodyReps.forEach(function(t, n) {
                    if (!t.isDownloaded) {
                        var s = {
                            uid: e.srvid,
                            partInfo: t._partInfo,
                            bodyRepIndex: n,
                            createSnippet: n === r
                        }, i = Math.min(5 * t.sizeEstimate, N);
                        if (void 0 !== o) {
                            if (a = f.SnippetParser, 0 >= o) return;
                            t.sizeEstimate > o && (i = o), o -= t.sizeEstimate;
                        }
                        0 >= i && (i = 64), (void 0 !== o || t.amountDownloaded) && (s.bytes = [ t.amountDownloaded, i ]), 
                        c.push(s);
                    }
                }), !c.length) return n(null, i), void 0;
                var d = new m.BodyFetcher(s._conn, a, c);
                s._handleBodyFetcher(d, e, i, function(e) {
                    n(e, i);
                });
            };
            this._storage.getMessageBody(e.suid, e.date, i);
        },
        _downloadSnippet: function(e, t) {
            var n = this;
            this._storage.getMessageBody(e.suid, e.date, function(s) {
                var i = g.selectSnippetBodyRep(e, s);
                if (-1 === i) return t();
                var r = s.bodyReps[i], o = [ {
                    uid: e.srvid,
                    bodyRepIndex: i,
                    partInfo: r._partInfo,
                    bytes: [ 0, k ],
                    createSnippet: !0
                } ], a = new m.BodyFetcher(n._conn, f.SnippetParser, o);
                n._handleBodyFetcher(a, e, s, t);
            });
        },
        _handleBodyFetcher: function(e, t, n, s) {
            var i = {
                changeDetails: {
                    bodyReps: []
                }
            }, r = this;
            e.onparsed = function(e, s) {
                g.updateMessageWithFetch(t, n, e, s, r._LOG), t.bytesToDownloadForBodyDisplay = g.calculateBytesToDownloadForImapBodyDisplay(n), 
                r._storage.updateMessageHeader(t.date, t.id, !1, t, n), i.changeDetails.bodyReps.push(e.bodyRepIndex);
            }, e.onerror = function(e) {
                s(e);
            }, e.onend = function() {
                r._storage.updateMessageBody(t, n, {}, i), r._storage.runAfterDeferredCalls(s);
            };
        },
        _lazyDownloadBodies: function(e, t, n) {
            function s(e) {
                e && !i && (i = e), --r || a._storage.runAfterDeferredCalls(function() {
                    n(i, o - r);
                });
            }
            for (var i, r = 1, o = 0, a = this, c = 0; c < e.length; c++) e[c] && null === e[c].snippet && (r++, 
            o++, this.downloadBodyReps(e[c], t, s));
            window.setZeroTimeout(s);
        },
        downloadBodies: function() {
            var e = Array.slice(arguments), t = this;
            a([ "./imapchew", "./protocol/bodyfetcher", "./protocol/snippetparser" ], function(n, s, i) {
                g = n, m = s, f = i, (t.downloadBodies = t._lazyDownloadBodies).apply(t, e);
            });
        },
        downloadMessageAttachments: function(e, t, n) {
            a([ "mailparser/mailparser", "mailparser/streams" ], function(s, i) {
                function r(e) {
                    d._state = 2, d._remainder = "";
                    var t = d._currentNode = d._createMimeNode(null);
                    t.attachment = !0, t.checksum = l, t.content = void 0, t.meta.contentType = e.type, 
                    t.meta.transferEncoding = e.encoding, t.meta.charset = null, t.meta.textFormat = null, 
                    t.stream = "base64" === t.meta.transferEncoding ? new i.Base64Stream() : "quoted-printable" == t.meta.transferEncoding ? new i.QPStream("binary") : new i.BinaryStream(), 
                    t.stream.checksum = l, t.stream.on("data", function(e) {
                        h.push(e);
                    });
                }
                function o(e) {
                    process.immediate = !0, u += e.length, d.write(e), d._process(!1), process.immediate = !1;
                }
                var a = this._conn, c = this, d = new s.MailParser({
                    streamAttachments: !0
                }), l = {
                    update: function() {},
                    digest: function() {
                        return null;
                    }
                }, u = 0, h = [], p = null, f = 0, m = [];
                t.forEach(function(t) {
                    var s = {
                        request: {
                            struct: !1,
                            headers: !1,
                            body: t.part
                        }
                    };
                    f++;
                    var i = a.fetch(e, s);
                    r(t), i.on("error", function(e) {
                        if (p || (p = e), 0 === --f) try {
                            n(p, m);
                        } catch (t) {
                            c._LOG.callbackErr(t);
                        }
                    }), i.on("message", function(e) {
                        r(t), e.on("data", o), e.on("end", function() {
                            if (process.immediate = !0, d._process(!0), process.immediate = !1, console.log("Downloaded", u, "bytes of attachment data."), 
                            m.push(new Blob(h, {
                                type: t.type
                            })), 0 === --f) try {
                                n(p, m);
                            } catch (e) {
                                c._LOG.callbackErr(e);
                            }
                        });
                    });
                });
            }.bind(this));
        },
        shutdown: function() {
            this._LOG.__die();
        }
    }, c.ImapFolderSyncer = u, u.prototype = {
        syncable: !0,
        get canGrowSync() {
            return "localdrafts" !== this.folderStorage.folderMeta.type;
        },
        initialSync: function(e, t, n, s, r) {
            n("sync", !1), this.folderConn.withConnection(function(n) {
                var o = !1;
                n && n.box && n.box.messages.total < i.SYNC_WHOLE_FOLDER_AT_N_MESSAGES && (o = !0), 
                this._startSync(e, I, "grow", null, i.OLDEST_SYNC_DATE, null, o ? null : t, s, r);
            }.bind(this), function() {
                s("aborted");
            }, "initialSync", !0);
        },
        refreshSync: function(e, t, n, s, i, r, o) {
            this._startSync(e, t, "refresh", t === I ? s : n, t === I ? n : s, i, null, r, o);
        },
        growSync: function(e, t, n, s, r, o) {
            var a;
            a = t === I ? i.OLDEST_SYNC_DATE : null, this._startSync(e, t, "grow", n, a, null, s, r, o);
        },
        _startSync: function(e, t, n, s, i, r, o, a, c) {
            var d, l;
            this._syncSlice = e, this._curSyncAccuracyStamp = b(), this._curSyncDir = t, this._curSyncIsGrow = "grow" === n, 
            this._fallbackOriginTS = r, t === I ? (l = s, o ? this._nextSyncAnchorTS = d = l ? l - o * v : T(o, this._account.tzOffset) : (d = i, 
            this._nextSyncAnchorTS = null)) : (d = s, o ? this._nextSyncAnchorTS = l = d + o * v : (l = i, 
            this._nextSyncAnchorTS = null)), this._syncThroughTS = i, this._curSyncDayStep = o, 
            this._curSyncDoNotGrowBoundary = null, this._curSyncDoneCallback = a, this.folderConn.syncDateRange(d, l, this._curSyncAccuracyStamp, this.onSyncCompleted.bind(this), c);
        },
        _doneSync: function(e) {
            this._syncSlice.desiredHeaders = this._syncSlice.headers.length, this._curSyncDoneCallback && this._curSyncDoneCallback(e), 
            this._account.__checkpointSyncCompleted(), this._syncSlice = null, this._curSyncAccuracyStamp = null, 
            this._curSyncDir = null, this._nextSyncAnchorTS = null, this._syncThroughTS = null, 
            this._curSyncDayStep = null, this._curSyncDoNotGrowBoundary = null, this._curSyncDoneCallback = null;
        },
        onSyncCompleted: function(e, t, n, s, r) {
            if ("bisect" === e) {
                var o = t.curDaysDelta, a = t.numHeaders;
                if (this._curSyncDir === C && this._fallbackOriginTS) {
                    this.folderStorage.clearSyncedToDawnOfTime(this._fallbackOriginTS), t.oldStartTS = this._fallbackOriginTS, 
                    this._fallbackOriginTS = null;
                    var c = t.oldEndTS || A(b() + v + this._account.tzOffset);
                    o = Math.round((c - t.oldStartTS) / v), a = 1.5 * i.BISECT_DATE_AT_N_MESSAGES;
                } else o > 1e3 && (o = 30);
                var d = i.BISECT_DATE_AT_N_MESSAGES / (2 * a), l = Math.max(1, Math.min(o - 2, Math.ceil(d * o)));
                return this._curSyncDayStep = l, this._curSyncDir === I ? (t.newEndTS = t.oldEndTS, 
                this._nextSyncAnchorTS = t.newStartTS = E(t.newEndTS, l, this._account.tzOffset), 
                this._curSyncDoNotGrowBoundary = t.oldStartTS) : (t.newStartTS = t.oldStartTS, this._nextSyncAnchorTS = t.newEndTS = E(t.newStartTS, -l, this._account.tzOffset), 
                this._curSyncDoNotGrowBoundary = t.oldEndTS), void 0;
            }
            if (e) return this._doneSync(e), void 0;
            if (console.log("Sync Completed!", this._curSyncDayStep, "days", n, "messages synced"), 
            this._syncSlice.isDead) return this._doneSync(), void 0;
            var u = this.folderConn && this.folderConn.box && this.folderConn.box.messages.total, h = this.folderStorage.getKnownMessageCount(), p = this._curSyncDir === I ? s : r;
            if (console.log("folder message count", u, "dbCount", h, "syncedThrough", p, "oldest known", this.folderStorage.getOldestMessageTimestamp()), 
            this._curSyncDir === I && u === h && (!u || w(this._curSyncDir, p, this.folderStorage.getOldestMessageTimestamp()))) return this.folderStorage.markSyncedToDawnOfTime(), 
            this._doneSync(), void 0;
            if (!this._nextSyncAnchorTS || w(this._curSyncDir, this._nextSyncAnchorTS, this._syncThroughTS)) return this._doneSync(), 
            void 0;
            if (this._curSyncIsGrow && this._syncSlice.headers.length >= this._syncSlice.desiredHeaders) return console.log("SYNCDONE Enough headers retrieved.", "have", this._syncSlice.headers.length, "want", this._syncSlice.desiredHeaders, "conn knows about", this.folderConn.box.messages.total, "sync date", this._curSyncStartTS, "[oldest defined as", i.OLDEST_SYNC_DATE, "]"), 
            this._doneSync(), void 0;
            var f, m;
            n || null !== this._curSyncDoNotGrowBoundary && !w(this._curSyncDir, this._nextSyncAnchorTS, this._curSyncDoNotGrowBoundary) ? f = this._curSyncDayStep : (this._curSyncDoNotGrowBoundary = null, 
            m = (A(b() + this._account.tzOffset) - this._nextSyncAnchorTS) / v, f = Math.ceil(this._curSyncDayStep * i.TIME_SCALE_FACTOR_ON_NO_MESSAGES), 
            180 > m ? f > 45 && (f = 45) : 365 > m ? f > 90 && (f = 90) : 730 > m ? f > 120 && (f = 120) : 1825 > m ? f > 180 && (f = 180) : 3650 > m ? f > 365 && (f = 365) : f > 730 && (f = 730), 
            this._curSyncDayStep = f);
            var g, _;
            this._curSyncDir === I ? (_ = this._nextSyncAnchorTS, this._nextSyncAnchorTS = g = E(_, f, this._account.tzOffset)) : (g = this._nextSyncAnchorTS, 
            this._nextSyncAnchorTS = _ = E(g, -f, this._account.tzOffset)), this.folderConn.syncDateRange(g, _, this._curSyncAccuracyStamp, this.onSyncCompleted.bind(this));
        },
        allConsumersDead: function() {
            this.folderConn.relinquishConn();
        },
        shutdown: function() {
            this.folderConn.shutdown(), this._LOG.__die();
        }
    }, h.prototype = {};
    var M = c.LOGFAB = e.register(o, {
        ImapFolderConn: {
            type: e.CONNECTION,
            subtype: e.CLIENT,
            events: {},
            TEST_ONLY_events: {},
            errors: {
                callbackErr: {
                    ex: e.EXCEPTION
                },
                htmlParseError: {
                    ex: e.EXCEPTION
                },
                htmlSnippetError: {
                    ex: e.EXCEPTION
                },
                textChewError: {
                    ex: e.EXCEPTION
                },
                textSnippetError: {
                    ex: e.EXCEPTION
                },
                illegalSync: {
                    startTS: !1,
                    endTS: !1
                }
            },
            asyncJobs: {
                syncDateRange: {
                    newMessages: !0,
                    existingMessages: !0,
                    deletedMessages: !0,
                    start: !1,
                    end: !1,
                    skewedStart: !1,
                    skewedEnd: !1
                }
            }
        },
        ImapFolderSyncer: {
            type: e.DATABASE,
            events: {}
        }
    });
}), define("mailapi/imap/jobs", [ "rdcommon/log", "mix", "../jobmixins", "mailapi/drafts/jobs", "module", "exports" ], function(e, t, n, s, i, r) {
    function o(e, t, n) {
        this.account = e, this.resilientServerIds = !1, this._heldMutexReleasers = [], this._LOG = d.ImapJobDriver(this, n, this.account.id), 
        this._state = t, t.hasOwnProperty("suidToServerId") || (t.suidToServerId = {}, t.moveMap = {}), 
        this._stateDelta = {
            serverIdMap: null,
            moveMap: null
        };
    }
    function a() {}
    var c = "idempotent";
    r.ImapJobDriver = o, o.prototype = {
        _accessFolderForMutation: function(e, t, n, s, i) {
            var r = this.account.getFolderStorageForFolderId(e), o = this;
            r.runMutexed(i, function(e) {
                var a = r.folderSyncer, c = function() {
                    o._heldMutexReleasers.push(e);
                    try {
                        n(a.folderConn, r);
                    } catch (t) {
                        o._LOG.callbackErr(t);
                    }
                };
                t && "localdrafts" !== r.folderMeta.type ? a.folderConn.withConnection(function() {
                    o._heldMutexReleasers.push(function() {
                        a.folderConn.clearErrorHandler();
                    }), c();
                }, s, i, !0) : c();
            });
        },
        _partitionAndAccessFoldersSequentially: n._partitionAndAccessFoldersSequentially,
        _acquireConnWithoutFolder: function(e, t, n) {
            this._LOG.acquireConnWithoutFolder_begin(e);
            var s = this;
            this.account.__folderDemandsConnection(null, e, function(n) {
                s._LOG.acquireConnWithoutFolder_end(e), s._heldMutexReleasers.push(function() {
                    s.account.__folderDoneWithConnection(n, !1, !1);
                });
                try {
                    t(n);
                } catch (i) {
                    s._LOG.callbackErr(i);
                }
            }, n);
        },
        postJobCleanup: n.postJobCleanup,
        allJobsDone: n.allJobsDone,
        local_do_downloadBodies: n.local_do_downloadBodies,
        do_downloadBodies: n.do_downloadBodies,
        check_downloadBodies: n.check_downloadBodies,
        local_do_downloadBodyReps: n.local_do_downloadBodyReps,
        do_downloadBodyReps: n.do_downloadBodyReps,
        check_downloadBodyReps: n.check_downloadBodyReps,
        local_do_download: n.local_do_download,
        do_download: n.do_download,
        check_download: n.check_download,
        local_undo_download: n.local_undo_download,
        undo_download: n.undo_download,
        local_do_modtags: n.local_do_modtags,
        do_modtags: function(e, t, n) {
            var s = n ? e.removeTags : e.addTags, i = n ? e.addTags : e.removeTags, r = null;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(t, o, a, c, d) {
                function l(t) {
                    return t ? (console.error("failure modifying tags", t), r = "unknown", void 0) : (e.progress += n ? -a.length : a.length, 
                    0 === --u && d(), void 0);
                }
                for (var u = 0, h = [], p = 0; p < a.length; p++) {
                    var f = a[p];
                    f && h.push(f);
                }
                return h.length ? (s && (u++, t._conn.addFlags(h, s, l)), i && (u++, t._conn.delFlags(h, i, l)), 
                void 0) : (d(), void 0);
            }, function() {
                t(r);
            }, function() {
                r = "aborted-retry";
            }, n, "modtags");
        },
        check_modtags: function(e, t) {
            t(null, c);
        },
        local_undo_modtags: n.local_undo_modtags,
        undo_modtags: function(e, t) {
            return this.do_modtags(e, t, !0);
        },
        local_do_delete: n.local_do_delete,
        do_delete: function(e, t) {
            var n = this.account.getFirstFolderWithType("trash");
            this.do_move(e, t, n.id);
        },
        check_delete: function(e, t) {
            var n = this.account.getFirstFolderWithType("trash");
            this.check_move(e, t, n.id);
        },
        local_undo_delete: n.local_undo_delete,
        undo_delete: function() {},
        local_do_move: n.local_do_move,
        do_move: function(e, t, n) {
            var s = this._state, i = this._stateDelta, r = null;
            i.serverIdMap || (i.serverIdMap = {}), n || (n = e.targetFolder), this._partitionAndAccessFoldersSequentially(e.messages, !0, function(t, o, a, c, d) {
                function l(e, n) {
                    function o() {
                        e.reselectBox(l);
                    }
                    function l() {
                        var t = e._conn.fetch(_ + ":*", {
                            request: {
                                headers: [ "MESSAGE-ID" ],
                                struct: !1,
                                body: !1
                            }
                        });
                        t.on("message", function(e) {
                            e.on("end", h);
                        }), t.on("error", function(e) {
                            r = e, d();
                        }), t.on("end", function() {
                            if (m < c.length) {
                                if (0 === --g) return r = "aborted-retry", d(), void 0;
                                window.setTimeout(l, 500);
                            }
                        });
                    }
                    function h(e) {
                        var t = e.msg.meta.messageId;
                        if (p.hasOwnProperty(t)) {
                            m++;
                            var r = p[t];
                            i.serverIdMap[r.suid] = e.id, _ = e.id + 1;
                            var o = s.moveMap[r.suid], a = parseInt(o.substring(o.lastIndexOf("/") + 1));
                            n.updateMessageHeader(r.date, a, !1, function(t) {
                                return t ? t.srvid = e.id : console.warn("did not find header for", r.suid, o, r.date, a), 
                                0 === --f && u(), !0;
                            }, null);
                        }
                    }
                    var _ = e.box._uidnext;
                    t._conn.copy(a, n.folderMeta.path, o);
                }
                function u() {
                    t._conn.addFlags(a, [ "\\Deleted" ], h);
                }
                function h(e) {
                    e && (r = !0), d();
                }
                for (var p = {}, f = c.length, m = 0, g = 3, _ = c.length - 1; _ >= 0; _--) {
                    var y = a[_];
                    if (y) {
                        var v = c[_];
                        p[v.guid] = v;
                    } else a.splice(_, 1), c.splice(_, 1);
                }
                return 0 === a.length ? (d(), void 0) : ("localdrafts" === o.folderMeta.type ? d() : o.folderId === n ? "move" === e.type ? d() : u() : this._accessFolderForMutation(n, !0, l, function() {}, "move target"), 
                void 0);
            }.bind(this), function() {
                t(r);
            }, null, !1, "local move source");
        },
        check_move: function(e, t) {
            t(null, "moot");
        },
        local_undo_move: n.local_undo_move,
        undo_move: function(e, t) {
            t("moot");
        },
        local_do_append: function(e, t) {
            t(null);
        },
        do_append: function(e, t) {
            var n, s = this.account.getFolderStorageForFolderId(e.folderId), i = (s.folderMeta, 
            0), r = function(e) {
                return e ? (n = e, n._conn.hasCapability("MULTIAPPEND") ? a() : c(), void 0) : (l("unknown"), 
                void 0);
            }, o = function() {
                t("aborted-retry");
            }, a = function() {
                i = e.messages.length, n._conn.multiappend(e.messages, d);
            }, c = function() {
                var t = e.messages[i++];
                n._conn.append(t.messageText, t, d);
            }, d = function(t) {
                return t ? (console.error("failure appending message", t), l("unknown"), void 0) : (i < e.messages.length ? c() : l(null), 
                void 0);
            }, l = function(e) {
                n && (n = null), t(e);
            };
            this._accessFolderForMutation(e.folderId, !0, r, o, "append");
        },
        check_append: function(e, t) {
            t(null, "moot");
        },
        local_undo_append: function(e, t) {
            t(null);
        },
        undo_append: function(e, t) {
            t("moot");
        },
        local_do_syncFolderList: function(e, t) {
            t(null);
        },
        do_syncFolderList: function(e, t) {
            var n = this.account, s = !1;
            this._acquireConnWithoutFolder("syncFolderList", function(e) {
                n._syncFolderList(e, function(e) {
                    e || (n.meta.lastFolderSyncAt = Date.now()), s || t(e ? "aborted-retry" : null, null, !e), 
                    s = !0;
                });
            }, function() {
                s || t("aborted-retry"), s = !0;
            });
        },
        check_syncFolderList: function(e, t) {
            t("idempotent");
        },
        local_undo_syncFolderList: function(e, t) {
            t("moot");
        },
        undo_syncFolderList: function(e, t) {
            t("moot");
        },
        local_do_createFolder: function(e, t) {
            t(null);
        },
        do_createFolder: function(e, t) {
            function n(e) {
                u = e, u.addBox(a, s);
            }
            function s(e) {
                return e ? e.serverResponse && /\[ALREADYEXISTS\]/.test(e.serverResponse) ? (r(null), 
                void 0) : (console.error("Error creating box:", e), r("unknown"), void 0) : (u.getBoxes("", a, i), 
                void 0);
            }
            function i(e, t) {
                function n(e, t, i) {
                    for (var r in e) {
                        var o = e[r], a = t ? t + r : r;
                        if (o.children) n(o.children, a + o.delim, i + 1); else {
                            var c = h.account._determineFolderType(o, a, u);
                            s = h.account._learnAboutFolder(r, a, d, c, o.delim, i);
                        }
                    }
                }
                if (e) return console.error("Error looking up box:", e), r("unknown"), void 0;
                var s = null;
                n(t, "", 0), s ? r(null, s) : r("unknown");
            }
            function r(e, n) {
                u && (u = null), t && t(e, n);
            }
            function o() {
                t("aborted-retry");
            }
            var a, c, d = null;
            if (e.parentFolderId) {
                if (!this.account._folderInfos.hasOwnProperty(e.parentFolderId)) throw new Error("No such folder: " + e.parentFolderId);
                var l = this.account._folderInfos[e.parentFolderId];
                c = l.$meta.delim, a = l.$meta.path + c, d = l.$meta.id;
            } else a = "", c = this.account.meta.rootDelim;
            a += "string" == typeof e.folderName ? e.folderName : e.folderName.join(c), e.containOnlyOtherFolders && (a += c);
            var u = null, h = this;
            this._acquireConnWithoutFolder("createFolder", n, o);
        },
        check_createFolder: function() {},
        local_undo_createFolder: function(e, t) {
            t(null);
        },
        undo_createFolder: function(e, t) {
            t("moot");
        },
        local_do_purgeExcessMessages: function(e, t) {
            this._accessFolderForMutation(e.folderId, !1, function(e, n) {
                n.purgeExcessMessages(function(e) {
                    t(null, null, e > 0);
                });
            }, null, "purgeExcessMessages");
        },
        do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        check_purgeExcessMessages: function() {
            return c;
        },
        local_undo_purgeExcessMessages: function(e, t) {
            t(null);
        },
        undo_purgeExcessMessages: function(e, t) {
            t(null);
        }
    }, a.prototype = {
        do_xmove: function() {},
        check_xmove: function() {},
        undo_xmove: function() {},
        do_xcopy: function() {},
        check_xcopy: function() {},
        undo_xcopy: function() {}
    }, t(o.prototype, s.draftsMixins);
    var d = r.LOGFAB = e.register(i, {
        ImapJobDriver: {
            type: e.DAEMON,
            events: {
                savedAttachment: {
                    storage: !0,
                    mimeType: !0,
                    size: !0
                },
                saveFailure: {
                    storage: !1,
                    mimeType: !1,
                    error: !1
                }
            },
            TEST_ONLY_events: {
                saveFailure: {
                    filename: !1
                }
            },
            asyncJobs: {
                acquireConnWithoutFolder: {
                    label: !1
                }
            },
            errors: {
                callbackErr: {
                    ex: e.EXCEPTION
                }
            }
        }
    });
}), define("mailapi/imap/account", [ "rdcommon/log", "../a64", "../allback", "../errbackoff", "../mailslice", "../searchfilter", "../util", "../composite/incoming", "./folder", "./jobs", "module", "require", "exports" ], function(e, t, n, s, i, r, o, a, c, d, l, u, h) {
    function p(e, t, n, i, r, o, a, l, u) {
        this._LOG = _.ImapAccount(this, l, n), f.apply(this, [ c.ImapFolderSyncer ].concat(Array.slice(arguments))), 
        this._maxConnsAllowed = 3, this._pendingConn = null, this._ownedConns = [], this._demandedConns = [], 
        this._backoffEndpoint = s.createEndpoint("imap:" + this.id, this, this._LOG), u && this._reuseConnection(u), 
        this.tzOffset = t.accountDef.tzOffset, this._jobDriver = new d.ImapJobDriver(this, this._folderInfos.$mutationState, this._LOG), 
        this._TEST_doNotCloseFolder = !1;
    }
    o.bsearchForInsert, n.allbackMaker;
    var f = a.CompositeIncomingAccount;
    h.Account = h.ImapAccount = p, p.prototype = Object.create(f.prototype);
    var m = {
        type: "imap",
        supportsServerFolders: !0,
        toString: function() {
            return "[ImapAccount: " + this.id + "]";
        },
        get isGmail() {
            return -1 !== this.meta.capability.indexOf("X-GM-EXT-1");
        },
        get numActiveConns() {
            return this._ownedConns.length;
        },
        __folderDemandsConnection: function(e, t, n, s, i) {
            if (i && !this.universe.online) return window.setZeroTimeout(s), void 0;
            var r = {
                folderId: e,
                label: t,
                callback: n,
                deathback: s,
                dieOnConnectFailure: Boolean(i)
            };
            this._demandedConns.push(r), this._demandedConns.length > 1 || this._allocateExistingConnection() || this._makeConnectionIfPossible();
        },
        _killDieOnConnectFailureDemands: function() {
            for (var e = 0; e < this._demandedConns.length; e++) {
                var t = this._demandedConns[e];
                t.dieOnConnectFailure && (t.deathback.call(null), this._demandedConns.splice(e--, 1));
            }
        },
        _allocateExistingConnection: function() {
            if (!this._demandedConns.length) return !1;
            for (var e = this._demandedConns[0], t = 0; t < this._ownedConns.length; t++) {
                var n = this._ownedConns[t];
                if (e.folderId && n.folderId === e.folderId && this._LOG.folderAlreadyHasConn(e.folderId), 
                !n.inUseBy) return n.inUseBy = e, this._demandedConns.shift(), this._LOG.reuseConnection(e.folderId, e.label), 
                e.callback(n.conn), !0;
            }
            return !1;
        },
        closeUnusedConnections: function() {
            for (var e = this._ownedConns.length - 1; e >= 0; e--) {
                var t = this._ownedConns[e];
                t.inUseBy || (t.conn.die(), this._ownedConns.splice(e, 1), this._LOG.deadConnection());
            }
        },
        _makeConnectionIfPossible: function() {
            if (this._ownedConns.length >= this._maxConnsAllowed) return this._LOG.maximumConnsNoNew(), 
            void 0;
            if (!this._pendingConn) {
                this._pendingConn = !0;
                var e = this._makeConnection.bind(this);
                this._backoffEndpoint.scheduleConnectAttempt(e);
            }
        },
        _makeConnection: function(e, t, n) {
            this._pendingConn = !0, u([ "imap", "./probe" ], function(s, i) {
                this._LOG.createConnection(t, n);
                var r = {
                    host: this._connInfo.hostname,
                    port: this._connInfo.port,
                    crypto: this._connInfo.crypto,
                    username: this._credentials.username,
                    password: this._credentials.password,
                    blacklistedCapabilities: this._connInfo.blacklistedCapabilities
                };
                this._LOG && (r._logParent = this._LOG);
                var o = this._pendingConn = new s.ImapConnection(r), a = !1;
                o.on("error", function(e) {
                    a || c(e);
                });
                var c;
                o.connect(c = function(t) {
                    if (a = !0, this._pendingConn = null, t) {
                        var n = i.normalizeError(t);
                        console.error("Connect error:", n.name, "formal:", t, "on", this._connInfo.hostname, this._connInfo.port), 
                        n.reportProblem && this.universe.__reportAccountProblem(this.compositeAccount, n.name), 
                        e && e(n.name), o.die(), n.retry ? this._backoffEndpoint.noteConnectFailureMaybeRetry(n.reachable) ? this._makeConnectionIfPossible() : this._killDieOnConnectFailureDemands() : (this._backoffEndpoint.noteBrokenConnection(), 
                        this._killDieOnConnectFailureDemands());
                    } else this._bindConnectionDeathHandlers(o), this._backoffEndpoint.noteConnectSuccess(), 
                    this._ownedConns.push({
                        conn: o,
                        inUseBy: null
                    }), this._allocateExistingConnection(), e && e(null), this._demandedConns.length && this._makeConnectionIfPossible();
                }.bind(this));
            }.bind(this));
        },
        _reuseConnection: function(e) {
            e.removeAllListeners(), this._ownedConns.push({
                conn: e,
                inUseBy: null
            }), this._bindConnectionDeathHandlers(e);
        },
        _bindConnectionDeathHandlers: function(e) {
            e.on("close", function() {
                for (var t = 0; t < this._ownedConns.length; t++) {
                    var n = this._ownedConns[t];
                    if (n.conn === e) return this._LOG.deadConnection(n.inUseBy && n.inUseBy.folderId), 
                    n.inUseBy && n.inUseBy.deathback && n.inUseBy.deathback(e), n.inUseBy = null, this._ownedConns.splice(t, 1), 
                    void 0;
                }
                this._LOG.unknownDeadConnection();
            }.bind(this)), e.on("error", function(e) {
                this._LOG.connectionError(e), console.warn("Conn steady error:", e, "on", this._connInfo.hostname, this._connInfo.port);
            }.bind(this));
        },
        __folderDoneWithConnection: function(e, t, n) {
            for (var s = 0; s < this._ownedConns.length; s++) {
                var i = this._ownedConns[s];
                if (i.conn === e) return n && this._backoffEndpoint(i.inUseBy.folderId), this._LOG.releaseConnection(i.inUseBy.folderId, i.inUseBy.label), 
                i.inUseBy = null, !t || n || this._TEST_doNotCloseFolder || e.closeBox(function() {}), 
                void 0;
            }
            this._LOG.connectionMismatch();
        },
        _syncFolderList: function(e, t) {
            e.getBoxes(this._syncFolderComputeDeltas.bind(this, e, t));
        },
        _determineFolderType: function(e, t, n) {
            var s = null;
            if (-1 !== e.attribs.indexOf("NOSELECT")) s = "nomail"; else {
                for (var i = 0; i < e.attribs.length; i++) switch (e.attribs[i]) {
                  case "ALL":
                  case "ALLMAIL":
                  case "ARCHIVE":
                    s = "archive";
                    break;

                  case "DRAFTS":
                    s = "drafts";
                    break;

                  case "FLAGGED":
                    s = "starred";
                    break;

                  case "IMPORTANT":
                    s = "important";
                    break;

                  case "INBOX":
                    s = "inbox";
                    break;

                  case "JUNK":
                    s = "junk";
                    break;

                  case "SENT":
                    s = "sent";
                    break;

                  case "SPAM":
                    s = "junk";
                    break;

                  case "STARRED":
                    s = "starred";
                    break;

                  case "TRASH":
                    s = "trash";
                    break;

                  case "HASCHILDREN":
                  case "HASNOCHILDREN":
                  case "MARKED":
                  case "UNMARKED":
                  case "NOINFERIORS":                }
                if (!s) {
                    var r = n.namespaces.personal, o = r.length ? r[0].prefix : "", a = t === o + e.displayName;
                    if (a || t === e.displayName) switch (e.displayName.toUpperCase()) {
                      case "DRAFT":
                      case "DRAFTS":
                        s = "drafts";
                        break;

                      case "INBOX":
                        "INBOX" === t.toUpperCase() && (s = "inbox");
                        break;

                      case "BULK MAIL":
                      case "JUNK":
                      case "SPAM":
                        s = "junk";
                        break;

                      case "SENT":
                        s = "sent";
                        break;

                      case "TRASH":
                        s = "trash";
                        break;

                      case "UNSENT MESSAGES":
                        s = "queue";
                    }
                }
                s || (s = "normal");
            }
            return s;
        },
        _syncFolderComputeDeltas: function(e, t, n, s) {
            function i(t, n, s, o) {
                for (var c in t) {
                    var d, l = t[c], u = n ? n + c : c, h = r._determineFolderType(l, u, e);
                    "inbox" === h && (u = "INBOX"), a.hasOwnProperty(u) ? (d = a[u], d.name = l.displayName, 
                    d.delim = l.delim, a[u] = !0) : d = r._learnAboutFolder(l.displayName, u, o, h, l.delim, s), 
                    l.children && i(l.children, n + c + l.delim, s + 1, d.id);
                }
            }
            var r = this;
            if (n) return t(n), void 0;
            for (var o, a = {}, c = 0; c < this.folders.length; c++) o = this.folders[c], a[o.path] = o;
            i(s, "", 0, null);
            for (var d in a) o = a[d], o !== !0 && "localdrafts" !== o.type && this._forgetFolder(o.id);
            var l = this.getFirstFolderWithType("localdrafts");
            if (!l) {
                var u, h = this.getFirstFolderWithType("drafts") || this.getFirstFolderWithType("sent"), p = h ? h.parentId : this.getFirstFolderWithType("inbox").id;
                u = p ? this._folderInfos[p].$meta : {
                    path: "",
                    delim: "",
                    depth: -1
                };
                var f = u.path + u.delim + "localdrafts";
                this._learnAboutFolder("localdrafts", f, p, "localdrafts", u.delim, u.depth + 1);
            }
            t(null);
        },
        saveSentMessage: function(e) {
            this.isGmail || e.withMessageBlob({
                includeBcc: !0
            }, function(e) {
                var t = {
                    messageText: e,
                    flags: [ "Seen" ]
                }, n = this.getFirstFolderWithType("sent");
                n && this.universe.appendMessages(n.id, [ t ]);
            }.bind(this));
        },
        shutdown: function(e) {
            function t() {
                0 === --n && e();
            }
            f.prototype.shutdownFolders.call(this), this._backoffEndpoint.shutdown();
            for (var n = this._ownedConns.length, s = 0; s < this._ownedConns.length; s++) {
                var i = this._ownedConns[s];
                if (e) {
                    i.inUseBy = {
                        deathback: t
                    };
                    try {
                        i.conn.logout();
                    } catch (r) {
                        n--;
                    }
                } else i.conn.die();
            }
            this._LOG.__die(), !n && e && e();
        },
        checkAccount: function(e) {
            this._LOG.checkAccount_begin(null), this._makeConnection(function(t) {
                this._LOG.checkAccount_end(t), e(t);
            }.bind(this), null, "check");
        },
        accountDeleted: function() {
            this._alive = !1, this.shutdown();
        }
    };
    for (var g in m) Object.defineProperty(p.prototype, g, Object.getOwnPropertyDescriptor(m, g));
    var _ = h.LOGFAB = e.register(l, {
        ImapAccount: a.LOGFAB_DEFINITION.CompositeIncomingAccount
    });
}), define("net", [ "require", "exports", "module", "util", "events", "mailapi/worker-router" ], function(e, t) {
    function n(e, t, n) {
        var s = {
            onopen: this._onconnect.bind(this),
            onerror: this._onerror.bind(this),
            ondata: this._ondata.bind(this),
            onclose: this._onclose.bind(this)
        }, r = o.register(function(e) {
            s[e.cmd](e.args);
        });
        this._sendMessage = r.sendMessage, this._unregisterWithRouter = r.unregister;
        var a = [ t, e, {
            useSSL: n,
            useSecureTransport: n,
            binaryType: "arraybuffer"
        } ];
        this._sendMessage("open", a), i.call(this), this.destroyed = !1;
    }
    var s = e("util"), i = e("events").EventEmitter, r = e("mailapi/worker-router"), o = r.registerInstanceType("netsocket");
    t.NetSocket = n, s.inherits(n, i), n.prototype.setTimeout = function() {}, n.prototype.setKeepAlive = function() {}, 
    n.prototype.write = function(e) {
        if (e instanceof Blob) return this._sendMessage("write", [ e ]), void 0;
        if (0 !== e.byteOffset || e.length !== e.buffer.byteLength) {
            var t = e.buffer.slice(e.byteOffset, e.byteOffset + e.length);
            this._sendMessage("write", [ t, 0, t.byteLength ], [ t ]);
        } else this._sendMessage("write", [ e.buffer, e.byteOffset, e.length ]);
    }, n.prototype.upgradeToSecure = function() {
        this._sendMessage("upgradeToSecure", []);
    }, n.prototype.end = function() {
        this.destroyed || (this._sendMessage("end"), this.destroyed = !0, this._unregisterWithRouter());
    }, n.prototype._onconnect = function() {
        this.emit("connect");
    }, n.prototype._onerror = function(e) {
        this.emit("error", e);
    }, n.prototype._ondata = function(e) {
        var t = Buffer(e);
        this.emit("data", t);
    }, n.prototype._onclose = function() {
        this.emit("close"), this.emit("end");
    }, t.connect = function(e, t, s) {
        return new n(e, t, !!s);
    };
}), define("pop3/transport", [ "exports" ], function(e) {
    function t(e, t) {
        var n = new Uint8Array(e.byteLength + t.byteLength);
        return n.set(e, 0), n.set(t, e.byteLength), n;
    }
    function n() {
        this.buffer = new Uint8Array(0), this.unprocessedLines = [];
    }
    function s(e, t) {
        this.lines = e, this.isMultiline = t, this.ok = this.lines[0][0] === d, this.err = !this.ok, 
        this.request = null;
    }
    function i(e, t, n, s) {
        this.command = e, this.args = t, this.expectMultiline = n, this.onresponse = s || null;
    }
    function r() {
        this.parser = new n(), this.onsend = function() {
            throw new Error("You must implement Pop3Protocol.onsend to send data.");
        }, this.unsentRequests = [], this.pipeline = !1, this.pendingRequests = [], this.closed = !1;
    }
    window.setTimeout.bind(window), window.clearTimeout.bind(window);
    var o = "\r".charCodeAt(0), a = "\n".charCodeAt(0), c = ".".charCodeAt(0), d = "+".charCodeAt(0);
    "-".charCodeAt(0), " ".charCodeAt(0);
    var l = new TextEncoder("utf-8", {
        fatal: !1
    }), u = new TextDecoder("utf-8", {
        fatal: !1
    });
    n.prototype.push = function(e) {
        for (var n = this.buffer = t(this.buffer, e), s = 0; s < n.length - 1; s++) if (n[s] === o && n[s + 1] === a) {
            var i = s + 1;
            this.unprocessedLines.push(n.slice(0, i + 1)), n = this.buffer = n.slice(i + 1), 
            s = -1;
        }
    }, n.prototype.extractResponse = function(e) {
        if (!this.unprocessedLines.length) return null;
        if (this.unprocessedLines[0][0] !== d && (e = !1), e) {
            for (var t = -1, n = 1; n < this.unprocessedLines.length; n++) {
                var i = this.unprocessedLines[n];
                if (3 === i.byteLength && i[0] === c && i[1] === o && i[2] === a) {
                    t = n;
                    break;
                }
            }
            if (-1 === t) return null;
            var r = this.unprocessedLines.splice(0, t + 1);
            r.pop();
            for (var n = 1; t > n; n++) r[n][0] === c && (r[n] = r[n].slice(1));
            return new s(r, !0);
        }
        return new s([ this.unprocessedLines.shift() ], !1);
    }, s.prototype.getStatusLine = function() {
        return this.getLineAsString(0).replace(/^(\+OK|-ERR) /, "");
    }, s.prototype.getLineAsString = function(e) {
        return u.decode(this.lines[e]);
    }, s.prototype.getLinesAsString = function() {
        for (var e = [], t = 0; t < this.lines.length; t++) e.push(this.getLineAsString(t));
        return e;
    }, s.prototype.getDataLines = function() {
        for (var e = [], t = 1; t < this.lines.length; t++) {
            var n = this.getLineAsString(t);
            e.push(n.slice(0, n.length - 2));
        }
        return e;
    }, s.prototype.getDataAsString = function() {
        for (var e = [], t = 1; t < this.lines.length; t++) e.push(this.getLineAsString(t));
        return e.join("");
    }, s.prototype.toString = function() {
        return this.getLinesAsString().join("\r\n");
    }, e.Request = i, i.prototype.toByteArray = function() {
        return l.encode(this.command + (this.args.length ? " " + this.args.join(" ") : "") + "\r\n");
    }, i.prototype._respondWithError = function(e) {
        var t = new s([ l.encode("-ERR " + e + "\r\n") ], !1);
        t.request = this, this.onresponse(t, null);
    }, e.Response = s, e.Pop3Protocol = r, r.prototype.sendRequest = function(e, t, n, s) {
        var r;
        return r = e instanceof i ? e : new i(e, t, n, s), this.closed ? (r._respondWithError("(request sent after connection closed)"), 
        void 0) : (this.pipeline || 0 === this.pendingRequests.length ? (this.onsend(r.toByteArray()), 
        this.pendingRequests.push(r)) : this.unsentRequests.push(r), void 0);
    }, r.prototype.onreceive = function(e) {
        this.parser.push(e);
        for (var t; ;) {
            var n = this.pendingRequests[0];
            if (t = this.parser.extractResponse(n && n.expectMultiline), !t) break;
            if (!n) {
                console.error("Unsolicited response from server: " + t);
                break;
            }
            t.request = n, this.pendingRequests.shift(), this.unsentRequests.length && this.sendRequest(this.unsentRequests.shift()), 
            n.onresponse && (t.err ? n.onresponse(t, null) : n.onresponse(null, t));
        }
    }, r.prototype.onclose = function() {
        this.closed = !0;
        var e = this.pendingRequests.concat(this.unsentRequests);
        this.pendingRequests = [], this.unsentRequests = [];
        for (var t = 0; t < e.length; t++) {
            var n = e[t];
            n._respondWithError("(connection closed, no response)");
        }
    };
}), define("mailparser/datetime", [ "require", "exports", "module" ], function() {
    this.strtotime = function(e, t) {
        var n, s, i, r = "", o = "";
        if (r = e, r = r.replace(/\s{2,}|^\s|\s$/g, " "), r = r.replace(/[\t\r\n]/g, ""), 
        "now" == r) return new Date().getTime() / 1e3;
        if (!isNaN(o = Date.parse(r))) return o / 1e3;
        t = t ? new Date(1e3 * t) : new Date(), r = r.toLowerCase();
        var a = {
            day: {
                sun: 0,
                mon: 1,
                tue: 2,
                wed: 3,
                thu: 4,
                fri: 5,
                sat: 6
            },
            mon: {
                jan: 0,
                feb: 1,
                mar: 2,
                apr: 3,
                may: 4,
                jun: 5,
                jul: 6,
                aug: 7,
                sep: 8,
                oct: 9,
                nov: 10,
                dec: 11
            }
        }, c = function(e) {
            var n = e[2] && "ago" == e[2], s = (s = "last" == e[0] ? -1 : 1) * (n ? -1 : 1);
            switch (e[0]) {
              case "last":
              case "next":
                switch (e[1].substring(0, 3)) {
                  case "yea":
                    t.setFullYear(t.getFullYear() + s);
                    break;

                  case "mon":
                    t.setMonth(t.getMonth() + s);
                    break;

                  case "wee":
                    t.setDate(t.getDate() + 7 * s);
                    break;

                  case "day":
                    t.setDate(t.getDate() + s);
                    break;

                  case "hou":
                    t.setHours(t.getHours() + s);
                    break;

                  case "min":
                    t.setMinutes(t.getMinutes() + s);
                    break;

                  case "sec":
                    t.setSeconds(t.getSeconds() + s);
                    break;

                  default:
                    var i;
                    if ("undefined" != typeof (i = a.day[e[1].substring(0, 3)])) {
                        var r = i - t.getDay();
                        0 == r ? r = 7 * s : r > 0 ? "last" == e[0] && (r -= 7) : "next" == e[0] && (r += 7), 
                        t.setDate(t.getDate() + r);
                    }
                }
                break;

              default:
                if (!/\d+/.test(e[0])) return !1;
                switch (s *= parseInt(e[0], 10), e[1].substring(0, 3)) {
                  case "yea":
                    t.setFullYear(t.getFullYear() + s);
                    break;

                  case "mon":
                    t.setMonth(t.getMonth() + s);
                    break;

                  case "wee":
                    t.setDate(t.getDate() + 7 * s);
                    break;

                  case "day":
                    t.setDate(t.getDate() + s);
                    break;

                  case "hou":
                    t.setHours(t.getHours() + s);
                    break;

                  case "min":
                    t.setMinutes(t.getMinutes() + s);
                    break;

                  case "sec":
                    t.setSeconds(t.getSeconds() + s);
                }
            }
            return !0;
        };
        if (s = r.match(/^(\d{2,4}-\d{2}-\d{2})(?:\s(\d{1,2}:\d{2}(:\d{2})?)?(?:\.(\d+))?)?$/), 
        null != s) {
            s[2] ? s[3] || (s[2] += ":00") : s[2] = "00:00:00", i = s[1].split(/-/g);
            for (n in a.mon) a.mon[n] == i[1] - 1 && (i[1] = n);
            return i[0] = parseInt(i[0], 10), i[0] = i[0] >= 0 && i[0] <= 69 ? "20" + (i[0] < 10 ? "0" + i[0] : i[0] + "") : i[0] >= 70 && i[0] <= 99 ? "19" + i[0] : i[0] + "", 
            parseInt(this.strtotime(i[2] + " " + i[1] + " " + i[0] + " " + s[2]) + (s[4] ? s[4] / 1e3 : ""), 10);
        }
        var d = "([+-]?\\d+\\s(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday)|(last|next)\\s(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday))(\\sago)?";
        if (s = r.match(new RegExp(d, "gi")), null == s) return !1;
        for (n = 0; n < s.length; n++) if (!c(s[n].split(" "))) return !1;
        return t.getTime() / 1e3;
    };
}), define("mailparser/streams", [ "require", "exports", "module", "stream", "util", "mimelib", "encoding", "crypto" ], function(e, t, n) {
    function s() {
        o.call(this), this.writable = !0, this.checksum = l.createHash("md5"), this.length = 0, 
        this.current = "";
    }
    function i(e) {
        o.call(this), this.writable = !0, this.checksum = l.createHash("md5"), this.length = 0, 
        this.charset = e || "UTF-8", this.current = void 0;
    }
    function r(e) {
        o.call(this), this.writable = !0, this.checksum = l.createHash("md5"), this.length = 0, 
        this.charset = e || "UTF-8", this.current = "";
    }
    var o = e("stream").Stream, a = e("util"), c = e("mimelib"), d = e("encoding"), l = e("crypto");
    n.exports.Base64Stream = s, n.exports.QPStream = i, n.exports.BinaryStream = r, 
    a.inherits(s, o), s.prototype.write = function(e) {
        return this.handleInput(e), !0;
    }, s.prototype.end = function(e) {
        return this.handleInput(e), this.emit("end"), {
            length: this.length,
            checksum: this.checksum.digest("hex")
        };
    }, s.prototype.handleInput = function(e) {
        if (e && e.length) {
            e = (e || "").toString("utf-8");
            var t = 0;
            this.current += e.replace(/[^\w\+\/=]/g, "");
            var n = new Buffer(this.current.substr(0, this.current.length - this.current.length % 4), "base64");
            n.length && (this.length += n.length, this.checksum.update(n), this.emit("data", n)), 
            this.current = (t = this.current.length % 4) ? this.current.substr(-t) : "";
        }
    }, a.inherits(i, o), i.prototype.write = function(e) {
        return this.handleInput(e), !0;
    }, i.prototype.end = function(e) {
        return this.handleInput(e), this.flush(), this.emit("end"), {
            length: this.length,
            checksum: this.checksum.digest("hex")
        };
    }, i.prototype.handleInput = function(e) {
        e && e.length && (e = (e || "").toString("utf-8"), e.match(/^\r\n/) && (e = e.substr(2)), 
        "string" != typeof this.current ? this.current = e : this.current += "\r\n" + e);
    }, i.prototype.flush = function() {
        var e = c.decodeQuotedPrintable(this.current, !1, this.charset);
        "binary" == this.charset.toLowerCase() || (e = "utf-8" != this.charset.toLowerCase() ? d.convert(e, "utf-8", this.charset) : new Buffer(e, "utf-8")), 
        this.length += e.length, this.checksum.update(e), this.emit("data", e);
    }, a.inherits(r, o), r.prototype.write = function(e) {
        return e && e.length && (this.length += e.length, this.checksum.update(e), this.emit("data", e)), 
        !0;
    }, r.prototype.end = function(e) {
        return e && e.length && this.emit("data", e), this.emit("end"), {
            length: this.length,
            checksum: this.checksum.digest("hex")
        };
    };
}), define("mailparser/mailparser", [ "require", "exports", "module", "stream", "util", "mimelib", "./datetime", "encoding", "./streams", "crypto" ], function(e, t, n) {
    function s(e) {
        i.call(this), this.writable = !0, this.options = e || {}, this._state = u.header, 
        this._remainder = "", this.mimeTree = this._createMimeNode(), this._currentNode = this.mimeTree, 
        this._currentNode.priority = "normal", this._fileNames = {}, this._multipartTree = [], 
        this.mailData = {}, this._lineCounter = 0, this._lineFeed = !1, this._headersSent = !1;
    }
    var i = e("stream").Stream, r = e("util"), o = e("mimelib"), a = e("./datetime"), c = e("encoding"), d = e("./streams"), l = e("crypto");
    n.exports.MailParser = s;
    var u = {
        header: 1,
        body: 2,
        finished: 3
    };
    r.inherits(s, i), s.prototype.write = function(e, t) {
        return this._write(e, t) && process.nextTick(this._process.bind(this)), !0;
    }, s.prototype.end = function(e, t) {
        this._write(e, t), this.options.debug && this._remainder && console.log("REMAINDER: " + this._remainder), 
        process.nextTick(this._process.bind(this, !0));
    }, s.prototype._write = function(e, t) {
        return "string" == typeof e && (e = new Buffer(e, t)), e = e && e.toString("binary") || "", 
        this._lineFeed && "\n" === e.charAt(0) && (e = e.substr(1)), this._lineFeed = "\r" === e.substr(-1), 
        e && e.length ? (this._remainder += e, !0) : !1;
    }, s.prototype._process = function(e) {
        e = !!e;
        var t, n, s, i = this._remainder.split(/\r?\n|\r/);
        for (e || (this._remainder = i.pop(), this._remainder.length > 1048576 && (this._remainder = this._remainder.replace(/(.{1048576}(?!\r?\n|\r))/g, "$&\n"))), 
        n = 0, s = i.length; s > n; n++) t = i[n], this.options.unescapeSMTP && ".." == t.substr(0, 2) && (t = t.substr(1)), 
        this.options.debug && console.log("LINE " + ++this._lineCounter + " (" + this._state + "): " + t), 
        !(this._state == u.header && this._processStateHeader(t) === !0 || this._state == u.body && this._processStateBody(t) === !0);
        e && (this._state == u.header && this._remainder && (this._processStateHeader(this._remainder), 
        this._headersSent || (this.emit("headers", this._currentNode.parsedHeaders), this._headersSent = !0)), 
        (this._currentNode.content || this._currentNode.stream) && this._finalizeContents(), 
        this._state = u.finished, process.nextTick(this._processMimeTree.bind(this)));
    }, s.prototype._processStateHeader = function(e) {
        var t, n, s = this._currentNode.headers.length - 1, i = !1;
        return e.length ? (e.match(/^\s+/) && s >= 0 ? this._currentNode.headers[s] += " " + e.trim() : (this._currentNode.headers.push(e.trim()), 
        s >= 0 && this._processHeaderLine(s)), !1) : (s >= 0 && this._processHeaderLine(s), 
        this._headersSent || (this.emit("headers", this._currentNode.parsedHeaders), this._headersSent = !0), 
        this._state = u.body, s >= 0 && this._processHeaderLine(s), this._currentNode.parentNode || this._currentNode.meta.contentType || (this._currentNode.meta.contentType = "text/plain"), 
        i = [ "text/plain", "text/html" ].indexOf(this._currentNode.meta.contentType || "") >= 0, 
        !i || this._currentNode.meta.contentDisposition && "inline" != this._currentNode.meta.contentDisposition ? i && !([ "attachment", "inline" ].indexOf(this._currentNode.meta.contentDisposition) >= 0) || this._currentNode.meta.mimeMultipart || (this._currentNode.attachment = !0) : this._currentNode.attachment = !1, 
        this._currentNode.attachment && (this._currentNode.checksum = l.createHash("md5"), 
        this._currentNode.meta.generatedFileName = this._generateFileName(this._currentNode.meta.fileName, this._currentNode.meta.contentType), 
        n = this._currentNode.meta.generatedFileName.split(".").pop().toLowerCase(), "application/octet-stream" == this._currentNode.meta.contentType && o.contentTypes[n] && (this._currentNode.meta.contentType = o.contentTypes[n]), 
        t = this._currentNode.meta, this.options.streamAttachments ? (this._currentNode.stream = "base64" == this._currentNode.meta.transferEncoding ? new d.Base64Stream() : "quoted-printable" == this._currentNode.meta.transferEncoding ? new d.QPStream("binary") : new d.BinaryStream(), 
        t.stream = this._currentNode.stream, this.emit("attachment", t)) : this._currentNode.content = void 0), 
        !0);
    }, s.prototype._processStateBody = function(e) {
        var t, n, s, i = !1;
        if ("--" == e.substr(0, 2)) for (t = 0, n = this._multipartTree.length; n > t; t++) {
            if (e == "--" + this._multipartTree[t].boundary) {
                (this._currentNode.content || this._currentNode.stream) && this._finalizeContents(), 
                s = this._createMimeNode(this._multipartTree[t].node), this._multipartTree[t].node.childNodes.push(s), 
                this._currentNode = s, this._state = u.header, i = !0;
                break;
            }
            if (e == "--" + this._multipartTree[t].boundary + "--") {
                (this._currentNode.content || this._currentNode.stream) && this._finalizeContents(), 
                this._currentNode = this._multipartTree[t].node.parentNode ? this._multipartTree[t].node.parentNode : this._multipartTree[t].node, 
                this._state = u.body, i = !0;
                break;
            }
        }
        return i ? !0 : ([ "text/plain", "text/html" ].indexOf(this._currentNode.meta.contentType || "") >= 0 && !this._currentNode.attachment ? this._handleTextLine(e) : this._currentNode.attachment && this._handleAttachmentLine(e), 
        !1);
    }, s.prototype._processHeaderLine = function(e) {
        var t, n, s, i;
        if (e = e || 0, (i = this._currentNode.headers[e]) && "string" == typeof i) {
            switch (s = i.split(":"), t = s.shift().toLowerCase().trim(), n = s.join(":").trim(), 
            t) {
              case "content-type":
                this._parseContentType(n);
                break;

              case "mime-version":
                this._currentNode.useMIME = !0;
                break;

              case "date":
                this._currentNode.meta.date = new Date(1e3 * a.strtotime(n) || Date.now());
                break;

              case "to":
                this._currentNode.to = this._currentNode.to && this._currentNode.to.length ? this._currentNode.to.concat(o.parseAddresses(n)) : o.parseAddresses(n);
                break;

              case "from":
                this._currentNode.from = this._currentNode.from && this._currentNode.from.length ? this._currentNode.from.concat(o.parseAddresses(n)) : o.parseAddresses(n);
                break;

              case "cc":
                this._currentNode.cc = this._currentNode.cc && this._currentNode.cc.length ? this._currentNode.cc.concat(o.parseAddresses(n)) : o.parseAddresses(n);
                break;

              case "bcc":
                this._currentNode.bcc = this._currentNode.bcc && this._currentNode.bcc.length ? this._currentNode.bcc.concat(o.parseAddresses(n)) : o.parseAddresses(n);
                break;

              case "x-priority":
              case "x-msmail-priority":
              case "importance":
                n = this._parsePriority(n), this._currentNode.priority = n;
                break;

              case "message-id":
                this._currentNode.meta.messageId = this._trimQuotes(n);
                break;

              case "references":
                this._parseReferences(n);
                break;

              case "in-reply-to":
                this._parseInReplyTo(n);
                break;

              case "thread-index":
                this._currentNode.meta.threadIndex = n;
                break;

              case "content-transfer-encoding":
                this._currentNode.meta.transferEncoding = n.toLowerCase();
                break;

              case "subject":
                this._currentNode.subject = this._encodeString(n);
                break;

              case "content-disposition":
                this._parseContentDisposition(n);
                break;

              case "content-id":
                this._currentNode.meta.contentId = this._trimQuotes(n);
            }
            this._currentNode.parsedHeaders[t] ? (Array.isArray(this._currentNode.parsedHeaders[t]) || (this._currentNode.parsedHeaders[t] = [ this._currentNode.parsedHeaders[t] ]), 
            this._currentNode.parsedHeaders[t].push(this._replaceMimeWords(n))) : this._currentNode.parsedHeaders[t] = this._replaceMimeWords(n), 
            this._currentNode.headers[e] = {
                key: t,
                value: n
            };
        }
    }, s.prototype._createMimeNode = function(e) {
        var t = {
            parentNode: e || this._currentNode || null,
            headers: [],
            parsedHeaders: {},
            meta: {},
            childNodes: []
        };
        return t;
    }, s.prototype._parseHeaderLineWithParams = function(e) {
        var t, n, s = {};
        n = e.split(";"), s.defaultValue = n.shift().toLowerCase();
        for (var i = 0, r = n.length; r > i; i++) e = n[i].split("="), t = e.shift().trim().toLowerCase(), 
        e = e.join("=").trim(), e = this._trimQuotes(e), s[t] = e;
        return s;
    }, s.prototype._parseContentType = function(e) {
        var t;
        return e = this._parseHeaderLineWithParams(e), e && (e.defaultValue ? (e.defaultValue = e.defaultValue.toLowerCase(), 
        this._currentNode.meta.contentType = e.defaultValue, "multipart/" == e.defaultValue.substr(0, "multipart/".length) && (this._currentNode.meta.mimeMultipart = e.defaultValue.substr("multipart/".length))) : this._currentNode.meta.contentType = "application/octet-stream", 
        e.charset && (e.charset = e.charset.toLowerCase(), "win-" == e.charset.substr(0, 4) ? e.charset = "windows-" + e.charset.substr(4) : "ks_c_5601-1987" == e.charset ? e.charset = "cp949" : e.charset.match(/^utf\d/) ? e.charset = "utf-" + e.charset.substr(3) : e.charset.match(/^latin[\-_]?\d/) ? e.charset = "iso-8859-" + e.charset.replace(/\D/g, "") : e.charset.match(/^(us\-)?ascii$/) && (e.charset = "utf-8"), 
        this._currentNode.meta.charset = e.charset), e.format && (this._currentNode.meta.textFormat = e.format.toLowerCase()), 
        e.delsp && (this._currentNode.meta.textDelSp = e.delsp.toLowerCase()), e.boundary && (this._currentNode.meta.mimeBoundary = e.boundary), 
        !this._currentNode.meta.fileName && (t = this._detectFilename(e)) && (this._currentNode.meta.fileName = t), 
        e.boundary && (this._currentNode.meta.mimeBoundary = e.boundary, this._multipartTree.push({
            boundary: e.boundary,
            node: this._currentNode
        }))), e;
    }, s.prototype._detectFilename = function(e) {
        var t, n, s, i = "", r = 0;
        if (e.name) return this._replaceMimeWords(e.name);
        if (e.filename) return this._replaceMimeWords(e.filename);
        if (e["name*"]) i = e["name*"]; else if (e["filename*"]) i = e["filename*"]; else if (e["name*0*"]) for (;e["name*" + r + "*"]; ) i += e["name*" + r++ + "*"]; else if (e["filename*0*"]) for (;e["filename*" + r + "*"]; ) i += e["filename*" + r++ + "*"];
        return i && (t = i.split("'"), n = t.shift(), s = t.pop()) ? this._replaceMimeWords(this._replaceMimeWords("=?" + (n || "us-ascii") + "?Q?" + s.replace(/%/g, "=") + "?=")) : "";
    }, s.prototype._parseContentDisposition = function(e) {
        var t;
        e = this._parseHeaderLineWithParams(e), e && (e.defaultValue && (this._currentNode.meta.contentDisposition = e.defaultValue.trim().toLowerCase()), 
        (t = this._detectFilename(e)) && (this._currentNode.meta.fileName = t));
    }, s.prototype._parseReferences = function(e) {
        this._currentNode.references = (this._currentNode.references || []).concat((e || "").toString().trim().split(/\s+/).map(this._trimQuotes.bind(this)));
    }, s.prototype._parseInReplyTo = function(e) {
        this._currentNode.inReplyTo = (this._currentNode.inReplyTo || []).concat((e || "").toString().trim().split(/\s+/).map(this._trimQuotes.bind(this)));
    }, s.prototype._parsePriority = function(e) {
        if (e = e.toLowerCase().trim(), !isNaN(parseInt(e, 10))) return e = parseInt(e, 10) || 0, 
        3 == e ? "normal" : e > 3 ? "low" : "high";
        switch (e) {
          case "non-urgent":
          case "low":
            return "low";

          case "urgent":
          case "hight":
            return "high";
        }
        return "normal";
    }, s.prototype._handleTextLine = function(e) {
        var t = this._currentNode.meta.transferEncoding;
        "base64" === t ? "string" != typeof this._currentNode.content ? this._currentNode.content = e.trim() : this._currentNode.content += e.trim() : "quoted-printable" === t || "flowed" != this._currentNode.meta.textFormat ? "string" != typeof this._currentNode.content ? this._currentNode.content = e : this._currentNode.content += "\n" + e : "string" != typeof this._currentNode.content ? this._currentNode.content = e : this._currentNode.content.match(/[ ]{1,}$/) ? ("yes" == this._currentNode.meta.textDelSp && (this._currentNode.content = this._currentNode.content.replace(/\s+$/, "")), 
        this._currentNode.content += e) : this._currentNode.content += "\n" + e;
    }, s.prototype._handleAttachmentLine = function(e) {
        this._currentNode.attachment && (this._currentNode.stream ? this._currentNode.streamStarted ? this._currentNode.stream.write(new Buffer("\r\n" + e, "binary")) : (this._currentNode.streamStarted = !0, 
        this._currentNode.stream.write(new Buffer(e, "binary"))) : "content" in this._currentNode && ("string" != typeof this._currentNode.content ? this._currentNode.content = e : this._currentNode.content += "\r\n" + e));
    }, s.prototype._finalizeContents = function() {
        var e;
        this._currentNode.content && (this._currentNode.attachment ? (this._currentNode.content = "quoted-printable" == this._currentNode.meta.transferEncoding ? o.decodeQuotedPrintable(this._currentNode.content, !1, "binary") : "base64" == this._currentNode.meta.transferEncoding ? new Buffer(this._currentNode.content.replace(/[^\w\+\/=]/g, ""), "base64") : new Buffer(this._currentNode.content, "binary"), 
        this._currentNode.checksum.update(this._currentNode.content), this._currentNode.meta.checksum = this._currentNode.checksum.digest("hex"), 
        this._currentNode.meta.length = this._currentNode.content.length) : ("text/html" == this._currentNode.meta.contentType && (this._currentNode.meta.charset = this._detectHTMLCharset(this._currentNode.content) || this._currentNode.meta.charset || this.options.defaultCharset || "iso-8859-1"), 
        "quoted-printable" == this._currentNode.meta.transferEncoding ? (this._currentNode.content = o.decodeQuotedPrintable(this._currentNode.content, !1, this._currentNode.meta.charset || this.options.defaultCharset || "iso-8859-1"), 
        "flowed" === this._currentNode.meta.textFormat && (this._currentNode.content = "yes" === this._currentNode.meta.textDelSp ? this._currentNode.content.replace(/ \n/g, "") : this._currentNode.content.replace(/ \n/g, " "))) : this._currentNode.content = "base64" == this._currentNode.meta.transferEncoding ? o.decodeBase64(this._currentNode.content, this._currentNode.meta.charset || this.options.defaultCharset || "iso-8859-1") : this._convertStringToUTF8(this._currentNode.content))), 
        this._currentNode.stream && (e = this._currentNode.stream.end() || {}, e.checksum && (this._currentNode.meta.checksum = e.checksum), 
        e.length && (this._currentNode.meta.length = e.length));
    }, s.prototype._processMimeTree = function() {
        var e, t, n, s, i = {};
        if (this.mailData = {
            html: [],
            text: [],
            alternatives: [],
            attachments: []
        }, this.mimeTree.meta.mimeMultipart ? this._walkMimeTree(this.mimeTree) : this._processMimeNode(this.mimeTree, 0), 
        this.mailData.html.length) for (n = 0, s = this.mailData.html.length; s > n; n++) !i.html || this.mailData.html[n].level < e ? (i.html && (i.alternatives || (i.alternatives = []), 
        i.alternatives.push({
            contentType: "text/html",
            content: i.html
        })), e = this.mailData.html[n].level, i.html = this.mailData.html[n].content) : (i.alternatives || (i.alternatives = []), 
        i.alternatives.push({
            contentType: "text/html",
            content: this.mailData.html[n].content
        }));
        if (this.mailData.text.length) for (n = 0, s = this.mailData.text.length; s > n; n++) !i.text || this.mailData.text[n].level < t ? (i.text && (i.alternatives || (i.alternatives = []), 
        i.alternatives.push({
            contentType: "text/plain",
            content: i.text
        })), t = this.mailData.text[n].level, i.text = this.mailData.text[n].content) : (i.alternatives || (i.alternatives = []), 
        i.alternatives.push({
            contentType: "text/plain",
            content: this.mailData.text[n].content
        }));
        if (i.headers = this.mimeTree.parsedHeaders, this.mimeTree.subject && (i.subject = this.mimeTree.subject), 
        this.mimeTree.references && (i.references = this.mimeTree.references), this.mimeTree.inReplyTo && (i.inReplyTo = this.mimeTree.inReplyTo), 
        this.mimeTree.priority && (i.priority = this.mimeTree.priority), this.mimeTree.from && (i.from = this.mimeTree.from), 
        this.mimeTree.to && (i.to = this.mimeTree.to), this.mimeTree.cc && (i.cc = this.mimeTree.cc), 
        this.mimeTree.bcc && (i.bcc = this.mimeTree.bcc), this.mailData.attachments.length) for (i.attachments = [], 
        n = 0, s = this.mailData.attachments.length; s > n; n++) i.attachments.push(this.mailData.attachments[n].content);
        process.nextTick(this.emit.bind(this, "end", i));
    }, s.prototype._walkMimeTree = function(e, t) {
        t = t || 1;
        for (var n = 0, s = e.childNodes.length; s > n; n++) this._processMimeNode(e.childNodes[n], t, e.meta.mimeMultipart), 
        this._walkMimeTree(e.childNodes[n], t + 1);
    }, s.prototype._processMimeNode = function(e, t, n) {
        var s, i;
        if (t = t || 0, e.attachment) {
            if (e.meta = e.meta || {}, e.content && (e.meta.content = e.content), this.mailData.attachments.push({
                content: e.meta || {},
                level: t
            }), this.options.showAttachmentLinks && "mixed" == n && this.mailData.html.length) for (s = 0, 
            i = this.mailData.html.length; i > s; s++) if (this.mailData.html[s].level == t) return this._joinHTMLAttachment(this.mailData.html[s], e.meta), 
            void 0;
        } else switch (e.meta.contentType) {
          case "text/html":
            if ("mixed" == n && this.mailData.html.length) for (s = 0, i = this.mailData.html.length; i > s; s++) if (this.mailData.html[s].level == t) return this._joinHTMLNodes(this.mailData.html[s], e.content), 
            void 0;
            return this.mailData.html.push({
                content: this._updateHTMLCharset(e.content || ""),
                level: t
            }), void 0;

          case "text/plain":
            return this.mailData.text.push({
                content: e.content || "",
                level: t
            }), void 0;
        }
    }, s.prototype._joinHTMLNodes = function(e, t) {
        var n = !1;
        t = (t || "").toString("utf-8").trim(), t = t.replace(/^\s*<\!doctype( [^>]*)?>/gi, ""), 
        t = t.replace(/<head( [^>]*)?>(.*)<\/head( [^>]*)?>/gi, "").replace(/<\/?html( [^>]*)?>/gi, "").trim(), 
        t.replace(/<body(?: [^>]*)?>(.*)<\/body( [^>]*)?>/gi, function(e, n) {
            t = n.trim();
        }), e.content = (e.content || "").toString("utf-8").trim(), e.content = e.content.replace(/<\/body( [^>]*)?>/i, function(e) {
            return n = !0, "<br/>\n" + t + e;
        }), n || (e.content += "<br/>\n" + t);
    }, s.prototype._joinHTMLAttachment = function(e, t) {
        var n, s, i = !1, r = t.generatedFileName.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
        n = t.cid || (t.cid = t.generatedFileName + "@node"), s = '\n<div class="mailparser-attachment"><a href="cid:' + n + '">&lt;' + r + "&gt;</a></div>", 
        e.content = (e.content || "").toString("utf-8").trim(), e.content = e.content.replace(/<\/body( [^>]*)?>/i, function(e) {
            return i = !0, "<br/>\n" + s + e;
        }), i || (e.content += "<br/>\n" + s);
    }, s.prototype._convertString = function(e, t, n) {
        return n = (n || "utf-8").toUpperCase(), t = (t || "utf-8").toUpperCase(), e = "string" == typeof e ? new Buffer(e, "binary") : e, 
        n == t ? e : e = c.convert(e, n, t);
    }, s.prototype._convertStringToUTF8 = function(e) {
        return e = this._convertString(e, this._currentNode.meta.charset || this.options.defaultCharset || "iso-8859-1").toString("utf-8");
    }, s.prototype._encodeString = function(e) {
        return e = this._replaceMimeWords(this._convertStringToUTF8(e));
    }, s.prototype._replaceMimeWords = function(e) {
        return e.replace(/(=\?[^?]+\?[QqBb]\?[^?]+\?=)\s+(?==\?[^?]+\?[QqBb]\?[^?]+\?=)/g, "$1").replace(/\=\?[^?]+\?[QqBb]\?[^?]+\?=/g, function(e) {
            return o.decodeMimeWord(e.replace(/\s/g, ""));
        }.bind(this));
    }, s.prototype._trimQuotes = function(e) {
        return e = (e || "").trim(), ('"' == e.charAt(0) && '"' == e.charAt(e.length - 1) || "'" == e.charAt(0) && "'" == e.charAt(e.length - 1) || "<" == e.charAt(0) && ">" == e.charAt(e.length - 1)) && (e = e.substr(1, e.length - 2)), 
        e;
    }, s.prototype._generateFileName = function(e, t) {
        var n, s = "";
        return t && (s = o.contentTypesReversed[t], s = s ? "." + s : ""), e = e || "attachment" + s, 
        e = e.toString().split(/[\/\\]+/).pop().replace(/^\.+/, "") || "attachment", e in this._fileNames ? (this._fileNames[e]++, 
        n = e.substr((e.lastIndexOf(".") || 0) + 1), n == e ? e += "-" + this._fileNames[e] : e = e.substr(0, e.length - n.length - 1) + "-" + this._fileNames[e] + "." + n) : this._fileNames[e] = 0, 
        e;
    }, s.prototype._updateHTMLCharset = function(e) {
        return e = e.replace(/\n/g, "\0").replace(/<meta[^>]*>/gi, function(e) {
            return e.match(/http\-equiv\s*=\s*"?content\-type/i) ? '<meta http-equiv="content-type" content="text/html; charset=utf-8" />' : e.match(/\scharset\s*=\s*['"]?[\w\-]+["'\s>\/]/i) ? '<meta charset="utf-8"/>' : e;
        }).replace(/\u0000/g, "\n");
    }, s.prototype._detectHTMLCharset = function(e) {
        var t, n, s;
        return " string" != typeof e && (e = e.toString("ascii")), (s = e.match(/<meta\s+http-equiv=["']content-type["'][^>]*?>/i)) && (n = s[0]), 
        n && (t = n.match(/charset\s?=\s?([a-zA-Z\-_:0-9]*);?/), t && (t = (t[1] || "").trim().toLowerCase())), 
        !t && (s = e.match(/<meta\s+charset=["']([^'"<\/]*?)["']/i)) && (t = (s[1] || "").trim().toLowerCase()), 
        t;
    };
}), define("mailapi/imap/imapchew", [ "mimelib", "mailapi/db/mail_rep", "../mailchew", "exports" ], function(e, t, n, s) {
    function i(t) {
        var n = /^([^']*)'([^']*)'(.+)$/.exec(t);
        return n ? e.parseMimeWords("=?" + (n[1] || "us-ascii") + "?Q?" + n[3].replace(/%/g, "=") + "?=") : null;
    }
    function r(n) {
        function s(e) {
            var t = e.encoding.toLowerCase();
            return "base64" === t ? Math.floor(57 * e.size / 78) : "quoted-printable" === t ? e.size : e.size;
        }
        function r(n) {
            function r(e) {
                return "<" === e[0] ? e.slice(1, -1) : e;
            }
            function o(e, n) {
                return t.makeAttachmentPart({
                    name: n || "unnamed-" + ++d,
                    contentId: e.id ? r(e.id) : null,
                    type: (e.type + "/" + e.subtype).toLowerCase(),
                    part: e.partID,
                    encoding: e.encoding && e.encoding.toLowerCase(),
                    sizeEstimate: s(e),
                    file: null
                });
            }
            function u(e) {
                return t.makeBodyPart({
                    type: e.subtype,
                    part: e.partID,
                    sizeEstimate: e.size,
                    amountDownloaded: 0,
                    isDownloaded: 0 === e.size,
                    _partInfo: e.size ? e : null,
                    content: ""
                });
            }
            var h, p, f = n[0];
            if (h = f.params && f.params.name ? e.parseMimeWords(f.params.name) : f.params && f.params["name*"] ? i(f.params["name*"]) : f.disposition && f.disposition.params && f.disposition.params.filename ? e.parseMimeWords(f.disposition.params.filename) : f.disposition && f.disposition.params && f.disposition.params["filename*"] ? i(f.disposition.params["filename*"]) : null, 
            p = f.disposition ? f.disposition.type.toLowerCase() : f.id ? "inline" : h || "text" !== f.type ? "attachment" : "inline", 
            "text" !== f.type && "image" !== f.type && (p = "attachment"), "application" === f.type && ("pgp-signature" === f.subtype || "pkcs7-signature" === f.subtype)) return !0;
            if ("attachment" === p) return a.push(o(f, h)), !0;
            switch (f.type) {
              case "image":
                return l.push(o(f, h)), !0;

              case "text":
                if ("plain" === f.subtype || "html" === f.subtype) return c.push(u(f)), !0;
            }
            return !1;
        }
        function o(e) {
            var t, n = e[0];
            switch (n.subtype) {
              case "alternative":
                for (t = e.length - 1; t >= 1; t--) {
                    var s = e[t][0];
                    switch (s.type) {
                      case "text":
                        break;

                      case "multipart":
                        if (o(e[t])) return !0;
                        break;

                      default:
                        continue;
                    }
                    switch (s.subtype) {
                      case "html":
                      case "plain":
                        if (r(e[t])) return !0;
                    }
                }
                return !1;

              case "mixed":
              case "signed":
              case "related":
                for (t = 1; t < e.length; t++) e[t].length > 1 ? o(e[t]) : r(e[t]);
                return !0;

              default:
                return console.warn("Ignoring multipart type:", n.subtype), !1;
            }
        }
        var a = [], c = [], d = 0, l = [];
        return n.structure.length > 1 ? o(n.structure) : r(n.structure), {
            bodyReps: c,
            attachments: a,
            relatedParts: l
        };
    }
    s.chewHeaderAndBodyStructure = function(e, n, s) {
        var i = r(e), o = {};
        return o.header = t.makeHeaderInfo({
            id: s,
            srvid: e.id,
            suid: n + "/" + s,
            guid: e.msg.meta.messageId,
            author: e.msg.from && e.msg.from[0] || {
                address: "missing-address@example.com"
            },
            to: "to" in e.msg ? e.msg.to : null,
            cc: "cc" in e.msg ? e.msg.cc : null,
            bcc: "bcc" in e.msg ? e.msg.bcc : null,
            replyTo: "reply-to" in e.msg.parsedHeaders ? e.msg.parsedHeaders["reply-to"] : null,
            date: e.date,
            flags: e.flags,
            hasAttachments: i.attachments.length > 0,
            subject: e.msg.subject || null,
            snippet: null
        }), o.bodyInfo = t.makeBodyInfo({
            date: e.date,
            size: 0,
            attachments: i.attachments,
            relatedParts: i.relatedParts,
            references: e.msg.references,
            bodyReps: i.bodyReps
        }), o;
    }, s.updateMessageWithFetch = function(e, t, s, i, r) {
        var o = t.bodyReps[s.bodyRepIndex];
        (!s.bytes || i.bytesFetched < s.bytes[1]) && (o.isDownloaded = !0, o._partInfo = null), 
        !o.isDownloaded && i.buffer && (o._partInfo.pendingBuffer = i.buffer), o.amountDownloaded += i.bytesFetched;
        var a = n.processMessageContent(i.text, o.type, o.isDownloaded, s.createSnippet, r);
        s.createSnippet && (e.snippet = a.snippet), o.isDownloaded && (o.content = a.content);
    }, s.selectSnippetBodyRep = function(e, t) {
        if (e.snippet) return -1;
        for (var n = t.bodyReps, i = n.length, r = 0; i > r; r++) if (s.canBodyRepFillSnippet(n[r])) return r;
        return -1;
    }, s.canBodyRepFillSnippet = function(e) {
        return e && "plain" === e.type || "html" === e.type;
    }, s.calculateBytesToDownloadForImapBodyDisplay = function(e) {
        var t = 0;
        return e.bodyReps.forEach(function(e) {
            e.isDownloaded || (t += e.sizeEstimate - e.amountDownloaded);
        }), e.relatedParts.forEach(function(e) {
            e.file || (t += e.sizeEstimate);
        }), t;
    };
}), define("pop3/mime_mapper", [], function() {
    return {
        _typeToExtensionMap: {
            "image/jpeg": "jpg",
            "image/png": "png",
            "image/gif": "gif",
            "image/bmp": "bmp",
            "audio/mpeg": "mp3",
            "audio/mp4": "m4a",
            "audio/ogg": "ogg",
            "audio/webm": "webm",
            "audio/3gpp": "3gp",
            "audio/amr": "amr",
            "video/mp4": "mp4",
            "video/mpeg": "mpg",
            "video/ogg": "ogg",
            "video/webm": "webm",
            "video/3gpp": "3gp",
            "application/vcard": "vcf",
            "text/vcard": "vcf",
            "text/x-vcard": "vcf"
        },
        _extensionToTypeMap: {
            jpg: "image/jpeg",
            jpeg: "image/jpeg",
            jpe: "image/jpeg",
            png: "image/png",
            gif: "image/gif",
            bmp: "image/bmp",
            mp3: "audio/mpeg",
            m4a: "audio/mp4",
            m4b: "audio/mp4",
            m4p: "audio/mp4",
            m4r: "audio/mp4",
            aac: "audio/aac",
            opus: "audio/ogg",
            amr: "audio/amr",
            mp4: "video/mp4",
            mpeg: "video/mpeg",
            mpg: "video/mpeg",
            ogv: "video/ogg",
            ogx: "video/ogg",
            webm: "video/webm",
            "3gp": "video/3gpp",
            ogg: "video/ogg",
            vcf: "text/vcard"
        },
        _parseExtension: function(e) {
            var t = e.split(".");
            return t.length > 1 ? t.pop() : "";
        },
        isSupportedType: function(e) {
            return e in this._typeToExtensionMap;
        },
        isSupportedExtension: function(e) {
            return e in this._extensionToTypeMap;
        },
        isFilenameMatchesType: function(e, t) {
            var n = this._parseExtension(e), s = this.guessTypeFromExtension(n);
            return s == t;
        },
        guessExtensionFromType: function(e) {
            return this._typeToExtensionMap[e];
        },
        guessTypeFromExtension: function(e) {
            return this._extensionToTypeMap[e];
        },
        guessTypeFromFileProperties: function(e, t) {
            var n = this._parseExtension(e), s = this.isSupportedType(t) ? t : this.guessTypeFromExtension(n);
            return s || "";
        },
        ensureFilenameMatchesType: function(e, t) {
            if (!this.isFilenameMatchesType(e, t)) {
                var n = this.guessExtensionFromType(t);
                n && (e += "." + n);
            }
            return e;
        }
    };
}), define("pop3/pop3", [ "module", "exports", "rdcommon/log", "net", "crypto", "./transport", "mailparser/mailparser", "../mailapi/imap/imapchew", "../mailapi/syncbase", "./mime_mapper", "../mailapi/allback" ], function(e, t, n, s, i, r, o, a, c, d, l) {
    function u(e) {
        return i.createHash("md5").update(e).digest("hex").toLowerCase();
    }
    function h(e, t, n, s) {
        var i = [], r = e.meta.contentType.split("/"), o = {};
        if (o.type = r[0], o.subtype = r[1], o.params = {}, o.params.boundary = e.meta.mimeBoundary || null, 
        o.params.format = e.meta.textFormat || null, o.params.charset = e.meta.charset || null, 
        o.params.name = e.meta.fileName || null, e.meta.contentDisposition && (o.disposition = {
            type: e.meta.contentDisposition,
            params: {}
        }, e.meta.fileName && (o.disposition.params.filename = e.meta.fileName)), o.partID = t || "1", 
        o.id = e.meta.contentId, o.encoding = "binary", o.size = e.content && e.content.length || 0, 
        o.description = null, o.lines = null, o.md5 = null, null != e.content && ("text" === o.type && e.content.length && "\n" === e.content[e.content.length - 1] && (e.content = e.content.slice(0, -1), 
        o.size--), n[o.partID] = e.content, s === e && (n.partial = o.partID)), i.push(o), 
        e.childNodes.length) for (var a = 0; a < e.childNodes.length; a++) {
            var c = e.childNodes[a];
            i.push(h(c, o.partID + "." + (a + 1), n, s));
        }
        return i;
    }
    function p(e) {
        var t = "";
        if (Array.isArray(e)) return e.forEach(function(e) {
            t += p(e) + "\n";
        }), t;
        for (var n = 0; n < e.length; n++) {
            var s = String.fromCharCode(e[n]);
            t += "\r" === s ? "\\r" : "\n" === s ? "\\n" : s;
        }
        return t;
    }
    var f = window.setTimeout.bind(window), m = window.clearTimeout.bind(window);
    t.setTimeoutFuncs = function(e, t) {
        f = e, m = t;
    };
    var g = t.Pop3Client = function(e, t) {
        if (this.options = e = e || {}, e.host = e.host || null, e.username = e.username || null, 
        e.password = e.password || null, e.port = e.port || null, e.crypto = e.crypto || !1, 
        e.connTimeout = e.connTimeout || 3e4, e.debug = e.debug || !1, e.authMethods = [ "apop", "sasl", "user-pass" ], 
        this._LOG = e._logParent ? _.Pop3Client(this, e._logParent, Date.now() % 1e3) : null, 
        e.preferredAuthMethod) {
            var n = e.authMethods.indexOf(e.preferredAuthMethod);
            -1 !== n && e.authMethods.splice(n, 1), e.authMethods.unshift(e.preferredAuthMethod);
        }
        if (e.crypto === !0 ? e.crypto = "ssl" : e.crypto || (e.crypto = "plain"), !e.port && (e.port = {
            plain: 110,
            starttls: 110,
            ssl: 995
        }[e.crypto], !e.port)) throw new Error("Invalid crypto option for Pop3Client: " + e.crypto);
        this.state = "disconnected", this.authMethod = null, this.idToUidl = {}, this.uidlToId = {}, 
        this.idToSize = {}, this._messageList = null, this._greetingLine = null, this.protocol = new r.Pop3Protocol(), 
        this.socket = s.connect(e.port, e.host, "ssl" === e.crypto);
        var i = f(function() {
            this.state = "disconnected", i && (m(i), i = null), t && t({
                scope: "connection",
                request: null,
                name: "unresponsive-server",
                message: "Could not connect to " + e.host + ":" + e.port + " with " + e.crypto + " encryption."
            });
        }.bind(this), e.connTimeout);
        e.debug && this.attachDebugLogging(), this.socket.on("data", this.protocol.onreceive.bind(this.protocol)), 
        this.protocol.onsend = this.socket.write.bind(this.socket), this.socket.on("connect", function() {
            i && (m(i), i = null), this.state = "greeting";
        }.bind(this)), this.socket.on("error", function(e) {
            i && (m(i), i = null), t && t({
                scope: "connection",
                request: null,
                name: "unresponsive-server",
                message: "Socket exception: " + JSON.stringify(e),
                exception: e
            });
        }.bind(this)), this.socket.on("close", function() {
            this.protocol.onclose(), this.die();
        }.bind(this)), this.protocol.pendingRequests.push(new r.Request(null, [], !1, function(e, n) {
            return e ? (t && t({
                scope: "connection",
                request: null,
                name: "unresponsive-server",
                message: e.getStatusLine(),
                response: e
            }), void 0) : (this._greetingLine = n.getLineAsString(0), this._maybeUpgradeConnection(function(e) {
                return e ? (t && t(e), void 0) : (this._thenAuthorize(function(e) {
                    e || (this.state = "ready"), t && t(e);
                }), void 0);
            }.bind(this)), void 0);
        }.bind(this)));
    };
    g.prototype.disconnect = g.prototype.die = function() {
        "disconnected" !== this.state && (this.state = "disconnected", this.socket.end());
    }, g.prototype.attachDebugLogging = function() {
        this.socket.on("data", function(e) {
            var t = p(e), n = -1 === t.indexOf("-ERR") ? "[32m" : "[31m";
            dump("<-- " + n + t + "[0;37m\n");
        });
        var e = this.socket.write;
        this.socket.write = function(t) {
            var n = p(t);
            return n = n.replace(/(AUTH|USER|PASS|APOP)(.*?)\\r\\n/g, "$1 ***CREDENTIALS HIDDEN***\\r\\n"), 
            dump("--> [0;33m" + n + "[0;37m\n"), e.apply(this, arguments);
        }.bind(this.socket);
    }, g.prototype._getCapabilities = function() {
        this.protocol.sendRequest("CAPA", [], !0, function(e, t) {
            if (e) this.capabilities = {}; else for (var n = t.getDataLines(), s = 0; s < n.length; s++) {
                var i = n[s].split(" ");
                this.capabilities[i[0]] = i.slice(1);
            }
        }.bind(this));
    }, g.prototype._maybeUpgradeConnection = function(e) {
        "starttls" === this.options.crypto ? (this.state = "starttls", this.protocol.sendRequest("STLS", [], !1, function(t) {
            return t ? (e && e({
                scope: "connection",
                request: t.request,
                name: "bad-security",
                message: t.getStatusLine(),
                response: t
            }), void 0) : (this.socket.upgradeToSecure(), e(), void 0);
        }.bind(this))) : e();
    }, g.prototype._thenAuthorize = function(e) {
        this.state = "authorization", this.authMethod = this.options.authMethods.shift();
        var t, n = this.options.username, s = this.options.password;
        switch (this.authMethod) {
          case "apop":
            var i = /<.*?>/.exec(this._greetingLine || ""), r = i && i[0];
            r ? (t = u(r + s), this.protocol.sendRequest("APOP", [ n, t ], !1, function(t) {
                t ? (this._greetingLine = null, this._thenAuthorize(e)) : e();
            }.bind(this))) : this._thenAuthorize(e);
            break;

          case "sasl":
            t = btoa(n + "\0" + n + "\0" + s), this.protocol.sendRequest("AUTH", [ "PLAIN", t ], !1, function(t) {
                t ? this._thenAuthorize(e) : e();
            }.bind(this));
            break;

          case "user-pass":
          default:
            this.protocol.sendRequest("USER", [ n ], !1, function(t) {
                return t ? (e && e({
                    scope: "authentication",
                    request: t.request,
                    name: "bad-user-or-pass",
                    message: t.getStatusLine(),
                    response: t
                }), void 0) : (this.protocol.sendRequest("PASS", [ s ], !1, function(t) {
                    return t ? (e && e({
                        scope: "authentication",
                        request: t.request,
                        name: "bad-user-or-pass",
                        message: t.getStatusLine(),
                        response: t
                    }), void 0) : (e(), void 0);
                }.bind(this)), void 0);
            }.bind(this));
        }
    }, g.prototype.quit = function(e) {
        this.state = "disconnected", this.protocol.sendRequest("QUIT", [], !1, function(t) {
            this.disconnect(), t ? e && e({
                scope: "mailbox",
                request: t.request,
                name: "server-problem",
                message: t.getStatusLine(),
                response: t
            }) : e && e();
        }.bind(this));
    }, g.prototype._loadMessageList = function(e) {
        return this._messageList ? (e(null, this._messageList), void 0) : (this.protocol.sendRequest("UIDL", [], !0, function(t, n) {
            if (t) return e && e({
                scope: "mailbox",
                request: t.request,
                name: "server-problem",
                message: t.getStatusLine(),
                response: t
            }), void 0;
            for (var s = n.getDataLines(), i = 0; i < s.length; i++) {
                var r = s[i].split(" "), o = r[0], a = r[1];
                this.idToUidl[o] = a, this.uidlToId[a] = o;
            }
        }.bind(this)), this.protocol.sendRequest("LIST", [], !0, function(t, n) {
            if (t) return e && e({
                scope: "mailbox",
                request: t.request,
                name: "server-problem",
                message: t.getStatusLine(),
                response: t
            }), void 0;
            for (var s = n.getDataLines(), i = [], r = 0; r < s.length; r++) {
                var o = s[r].split(" "), a = o[0], c = parseInt(o[1], 10);
                this.idToSize[a] = c, i.unshift({
                    uidl: this.idToUidl[a],
                    size: c,
                    number: a
                });
            }
            this._messageList = i, e && e(null, i);
        }.bind(this)), void 0);
    }, g.prototype.listMessages = function(e, t) {
        var n = e.filter, s = e.progress, i = e.checkpointInterval || null, r = e.maxMessages || 1/0, o = e.checkpoint, a = [];
        this._loadMessageList(function(e, c) {
            if (e) return t && t(e), void 0;
            for (var d = 0, u = 0, h = [], p = 0, f = 0; f < c.length; f++) {
                var m = c[f];
                !n || n(m.uidl) ? h.length < r ? (d += m.size, h.push(m)) : a.push(m) : p++;
            }
            console.log("POP3: listMessages found " + h.length + " new, " + a.length + " overflow, and " + p + " seen messages. New UIDLs:"), 
            h.forEach(function(e) {
                console.log("POP3: " + e.size + " bytes: " + e.uidl);
            });
            var g = h.length;
            i || (i = g);
            var _ = function() {
                if (console.log("POP3: Next batch. Messages left: " + h.length), !h.length) return console.log("POP3: Sync complete. " + g + " messages synced, " + a.length + " overflow messages."), 
                t && t(null, g, a), void 0;
                var e = h.splice(0, i), n = l.latch();
                e.forEach(function(e) {
                    var t = n.defer();
                    this.downloadPartialMessageByNumber(e.number, function(n, i) {
                        u += e.size, s && s({
                            totalBytes: d,
                            bytesFetched: u,
                            size: e.size,
                            message: i
                        }), t(n);
                    });
                }.bind(this)), n.then(function() {
                    console.log("POP3: Checkpoint."), o ? o(_) : _();
                });
            }.bind(this);
            _();
        }.bind(this));
    }, g.prototype.downloadMessageByUidl = function(e, t) {
        this._loadMessageList(function(n) {
            n ? t && t(n) : this.downloadMessageByNumber(this.uidlToId[e], t);
        }.bind(this));
    }, g.prototype.downloadPartialMessageByNumber = function(e, t) {
        var n = Math.floor(c.POP3_SNIPPET_SIZE_GOAL / 80);
        this.protocol.sendRequest("TOP", [ e, n ], !0, function(n, s) {
            if (n) return t && t({
                scope: "message",
                request: n.request,
                name: "server-problem",
                message: n.getStatusLine(),
                response: n
            }), void 0;
            var i = this.idToSize[e], r = s.getDataAsString(), o = !i || r.length < i;
            t(null, this.parseMime(r, o, e));
        }.bind(this));
    }, g.prototype.downloadMessageByNumber = function(e, t) {
        this.protocol.sendRequest("RETR", [ e ], !0, function(n, s) {
            return n ? (t && t({
                scope: "message",
                request: n.request,
                name: "server-problem",
                message: n.getStatusLine(),
                response: n
            }), void 0) : (t(null, this.parseMime(s.getDataAsString(), !1, e)), void 0);
        }.bind(this));
    }, g.parseMime = function(e) {
        return g.prototype.parseMime.call(this, e);
    }, g.prototype.parseMime = function(e, t, n) {
        var s = new o.MailParser();
        s._write(e), s._process(!0);
        var i, r = s.mimeTree, l = t ? s._currentNode : null, u = n && this.idToSize[n] || e.length, p = {}, f = {
            id: n && this.idToUidl[n],
            msg: r,
            date: r.meta.date && r.meta.date.valueOf(),
            flags: [],
            structure: h(r, "1", p, l)
        }, m = a.chewHeaderAndBodyStructure(f, null, null), g = a.selectSnippetBodyRep(m.header, m.bodyInfo), _ = {}, y = 0, v = p.partial;
        for (var b in p) "partial" !== b && b !== v && (y += p[b].length, _[b] = p[b].length);
        v && (_[v] = u - y);
        for (var S = 0; S < m.bodyInfo.bodyReps.length; S++) {
            var w = m.bodyInfo.bodyReps[S];
            if (i = p[w.part], null != i) {
                var T = {
                    bytes: v === w.part ? [ -1, -1 ] : null,
                    bodyRepIndex: S,
                    createSnippet: S === g
                };
                w.size = _[w.part];
                var E = {
                    bytesFetched: i.length,
                    text: i
                };
                a.updateMessageWithFetch(m.header, m.bodyInfo, T, E, this._LOG);
            }
        }
        for (var S = 0; S < m.bodyInfo.relatedParts.length; S++) {
            var A = m.bodyInfo.relatedParts[S];
            A.sizeEstimate = _[A.part], i = p[A.part], null != i && v !== A.part && (A.file = new Blob([ i ], {
                type: A.type
            }));
        }
        for (var S = 0; S < m.bodyInfo.attachments.length; S++) {
            var I = m.bodyInfo.attachments[S];
            i = p[I.part], I.sizeEstimate = _[I.part], null != i && v !== I.part && d.isSupportedType(I.type) && (I.file = new Blob([ i ], {
                type: I.type
            }));
        }
        return t && !m.header.hasAttachments && (r.parsedHeaders["x-ms-has-attach"] || "mixed" === r.meta.mimeMultipart || u > c.POP3_INFER_ATTACHMENTS_SIZE) && (m.header.hasAttachments = !0), 
        m.bodyInfo.bodyReps.push({
            type: "fake",
            part: "fake",
            sizeEstimate: 0,
            amountDownloaded: 0,
            isDownloaded: !t,
            content: null,
            size: 0
        }), m.header.bytesToDownloadForBodyDisplay = t ? u : 0, m;
    };
    var _ = t.LOGFAB = n.register(e, {
        Pop3Client: {
            type: n.CONNECTION,
            subtype: n.CLIENT,
            events: {},
            TEST_ONLY_events: {},
            errors: {
                htmlParseError: {
                    ex: n.EXCEPTION
                },
                htmlSnippetError: {
                    ex: n.EXCEPTION
                },
                textChewError: {
                    ex: n.EXCEPTION
                },
                textSnippetError: {
                    ex: n.EXCEPTION
                }
            },
            asyncJobs: {}
        }
    });
    g._LOG = _.Pop3Client();
}), define("mailapi/pop3/sync", [ "rdcommon/log", "../util", "module", "require", "exports", "../mailchew", "../syncbase", "../date", "../jobmixins", "../allback", "pop3/pop3" ], function(e, t, n, s, i, r, o, a, c, d) {
    function l(e, t, n) {
        this._LOG = f.Pop3FolderSyncer(this, n, t.folderId), this.account = e, this.storage = t, 
        this.isInbox = "inbox" === t.folderMeta.type;
    }
    function u(e, t, n, i) {
        return function() {
            var r = Array.slice(arguments);
            s([], function() {
                var s = function() {
                    return this.isInbox ? (this.account.withConnection(function(e, n, s) {
                        var o = r[t];
                        e ? o && o(e) : (r[t] = function() {
                            s(), o && o();
                        }, i.apply(this, [ n ].concat(r)));
                    }.bind(this), n), void 0) : (i.apply(this, [ null ].concat(r)), void 0);
                }.bind(this);
                e && this.account._conn && "disconnected" !== this.account._conn.state ? this.account._conn.quit(s) : s();
            }.bind(this));
        };
    }
    function h(e) {
        for (var t = [], n = 0; e > n; n++) t.push(n);
        return t;
    }
    var p = 1;
    i.Pop3FolderSyncer = l, l.prototype = {
        syncable: !0,
        get canGrowSync() {
            return this.isInbox;
        },
        downloadBodies: u(!1, 2, "downloadBodies", function(e, t, n, s) {
            for (var i = d.latch(), r = this.storage, o = 0; o < t.length; o++) t[o] && null == t[o].snippet && this.downloadBodyReps(t[o], n, i.defer(o));
            i.then(function(e) {
                var n = null;
                for (var i in e) n = e[i][0];
                r.runAfterDeferredCalls(function() {
                    s(n, t.length);
                });
            });
        }),
        downloadBodyReps: u(!1, 2, "downloadBodyReps", function(e, t, n, s) {
            n instanceof Function && (s = n, n = {}), console.log("POP3: Downloading bodyReps for UIDL " + t.srvid), 
            e.downloadMessageByUidl(t.srvid, function(e, n) {
                if (e) return s(e), void 0;
                t.bytesToDownloadForBodyDisplay = n.header.bytesToDownloadForBodyDisplay, console.log("POP3: Storing message " + t.srvid + " with " + t.bytesToDownloadForBodyDisplay + " bytesToDownload.");
                var i = n.bodyInfo.attachments.length > 0;
                this.storeMessage(t, n.bodyInfo, {
                    flush: i
                }, function() {
                    s && s(null, n.bodyInfo, i);
                });
            }.bind(this));
        }),
        downloadMessageAttachments: function(e, t, n) {
            console.log("POP3: ERROR: downloadMessageAttachments called and POP3 shouldn't do that."), 
            n(null, null);
        },
        storeMessage: function(e, t, n, s) {
            s = s || function() {};
            var i = {
                changeDetails: {}
            }, r = this.getMessageIdForUidl(e.srvid);
            null == e.id && (e.id = null == r ? this.storage._issueNewHeaderId() : r, e.suid = this.storage.folderId + "/" + e.id, 
            e.guid = e.guid || e.srvid);
            for (var o = d.latch(), a = this, l = 0; l < t.attachments.length; l++) {
                var u = t.attachments[l];
                u.file instanceof Blob && (console.log("Saving attachment", u.file), c.saveToDeviceStorage(this._LOG, u.file, "sdcard", u.name, u, o.defer()));
            }
            o.then(function() {
                if (o = d.latch(), null == r) a.storeMessageUidlForMessageId(e.srvid, e.id), a.storage.addMessageHeader(e, t, o.defer()), 
                a.storage.addMessageBody(e, t, o.defer()); else {
                    a.storage.updateMessageHeader(e.date, e.id, !0, e, t, o.defer()), i.changeDetails.attachments = h(t.attachments.length), 
                    i.changeDetails.bodyReps = h(t.bodyReps.length);
                    var c = {};
                    n.flush && (c.flushBecause = "blobs"), a.storage.updateMessageBody(e, t, c, i, o.defer());
                }
                o.then(function() {
                    s(null, t);
                });
            });
        },
        get inboxMeta() {
            return this.inboxMeta = this.account.getFolderMetaForFolderId(this.account.getFirstFolderWithType("inbox").id);
        },
        getMessageIdForUidl: function(e) {
            return null == e ? null : (this.inboxMeta.uidlMap = this.inboxMeta.uidlMap || {}, 
            this.inboxMeta.uidlMap[e]);
        },
        storeMessageUidlForMessageId: function(e, t) {
            this.inboxMeta.uidlMap = this.inboxMeta.uidlMap || {}, this.inboxMeta.uidlMap[e] = t, 
            this.inboxMeta.overflowMap && delete this.inboxMeta.overflowMap[e];
        },
        storeOverflowMessageUidl: function(e, t) {
            this.inboxMeta.overflowMap = this.inboxMeta.overflowMap || {}, this.inboxMeta.overflowMap[e] = {
                size: t
            };
        },
        hasOverflowMessages: function() {
            if (!this.inboxMeta.overflowMap) return !1;
            for (var e in this.inboxMeta.overflowMap) return !0;
            return !1;
        },
        isUidlInOverflowMap: function(e) {
            return this.inboxMeta.overflowMap ? !!this.inboxMeta.overflowMap[e] : !1;
        },
        initialSync: function(e, t, n, s, i) {
            n("sync", !0), this.sync("initial", e, s, i);
        },
        refreshSync: function(e, t, n, s, i, r, o) {
            this.sync("refresh", e, r, o);
        },
        _performTestDeletions: function(e) {
            var t = this.storage.folderMeta, n = 1, s = d.latch();
            t._TEST_pendingHeaderDeletes && (t._TEST_pendingHeaderDeletes.forEach(function(e) {
                n++, this.storage.deleteMessageHeaderUsingHeader(e, s.defer());
            }, this), t._TEST_pendingHeaderDeletes = null), t._TEST_pendingAdds && (t._TEST_pendingAdds.forEach(function(e) {
                n++, this.storeMessage(e.header, e.bodyInfo, {}, s.defer());
            }, this), t._TEST_pendingAdds = null), s.then(function() {
                e();
            });
        },
        growSync: function(e, t, n, s, i, r) {
            return t === p && this.hasOverflowMessages() ? (this.sync("grow", e, i, r), !0) : !1;
        },
        allConsumersDead: function() {},
        shutdown: function() {
            this._LOG.__die();
        },
        sync: u(!0, 2, "sync", function(e, t, n, s, i) {
            var r = this;
            this._LOG.sync_begin();
            var c;
            c = "grow" !== t ? function(e) {
                return null == r.getMessageIdForUidl(e) && !r.isUidlInOverflowMap(e);
            } : this.isUidlInOverflowMap.bind(this);
            var l = 0, u = 0, h = d.latch();
            if (this.isInbox) {
                var p = h.defer();
                e.listMessages({
                    filter: c,
                    checkpointInterval: o.POP3_SAVE_STATE_EVERY_N_MESSAGES,
                    maxMessages: o.POP3_MAX_MESSAGES_PER_SYNC,
                    checkpoint: function(e) {
                        this.storage.runAfterDeferredCalls(function() {
                            this.account.__checkpointSyncCompleted(e);
                        }.bind(this));
                    }.bind(this),
                    progress: function(e) {
                        var t = e.totalBytes, n = e.message, s = h.defer();
                        this.storeMessage(n.header, n.bodyInfo, {}, function() {
                            l += e.size, u++, i(.1 + .7 * l / t), s();
                        });
                    }.bind(this)
                }, function(t, n, i) {
                    return e.quit(), t ? (s(t), void 0) : (i.length && (i.forEach(function(e) {
                        this.storeOverflowMessageUidl(e.uidl, e.size);
                    }, this), this._LOG.overflowMessages(i.length)), this.storage.runAfterDeferredCalls(p), 
                    void 0);
                }.bind(this));
            } else n.desiredHeaders = this._TEST_pendingAdds && this._TEST_pendingAdds.length, 
            this._performTestDeletions(h.defer());
            h.then(function() {
                this._LOG.sync_end(), this.storage.markSyncRange(o.OLDEST_SYNC_DATE + a.DAY_MILLIS + 1, a.NOW(), "XXX", a.NOW()), 
                this.hasOverflowMessages() || this.storage.markSyncedToDawnOfTime(), this.account.__checkpointSyncCompleted(), 
                "initial" === t ? (this.storage._curSyncSlice.ignoreHeaders = !1, this.storage._curSyncSlice.waitingOnData = "db", 
                this.storage.getMessagesInImapDateRange(o.OLDEST_SYNC_DATE, null, o.INITIAL_FILL_SIZE, o.INITIAL_FILL_SIZE, this.storage.onFetchDBHeaders.bind(this.storage, this.storage._curSyncSlice, !1, s, null))) : s(null, null);
            }.bind(this));
        })
    };
    var f = i.LOGFAB = e.register(n, {
        Pop3FolderSyncer: {
            type: e.CONNECTION,
            subtype: e.CLIENT,
            events: {
                savedAttachment: {
                    storage: !0,
                    mimeType: !0,
                    size: !0
                },
                saveFailure: {
                    storage: !1,
                    mimeType: !1,
                    error: !1
                },
                overflowMessages: {
                    count: !0
                }
            },
            TEST_ONLY_events: {},
            errors: {
                callbackErr: {
                    ex: e.EXCEPTION
                },
                htmlParseError: {
                    ex: e.EXCEPTION
                },
                htmlSnippetError: {
                    ex: e.EXCEPTION
                },
                textChewError: {
                    ex: e.EXCEPTION
                },
                textSnippetError: {
                    ex: e.EXCEPTION
                },
                illegalSync: {
                    startTS: !1,
                    endTS: !1
                }
            },
            asyncJobs: {
                sync: {},
                syncDateRange: {
                    newMessages: !0,
                    existingMessages: !0,
                    deletedMessages: !0,
                    start: !1,
                    end: !1,
                    skewedStart: !1,
                    skewedEnd: !1
                }
            }
        }
    });
}), define("mailapi/pop3/jobs", [ "module", "exports", "rdcommon/log", "../allback", "mix", "../jobmixins", "../drafts/jobs", "pop3/pop3" ], function(e, t, n, s, i, r, o) {
    function a(e, t, n) {
        this._LOG = c.Pop3JobDriver(this, n, e.id), this.account = e, this.resilientServerIds = !0, 
        this._heldMutexReleasers = [], this._stateDelta = {}, this._state = t, t.hasOwnProperty("suidToServerId") || (t.suidToServerId = {}, 
        t.moveMap = {});
    }
    t.Pop3JobDriver = a, a.prototype = {
        _accessFolderForMutation: function(e, t, n, s, i) {
            var r = this.account.getFolderStorageForFolderId(e);
            r.runMutexed(i, function(e) {
                this._heldMutexReleasers.push(e);
                try {
                    n(r.folderSyncer, r);
                } catch (t) {
                    this._LOG.callbackErr(t);
                }
            }.bind(this));
        },
        local_do_createFolder: function(e, t) {
            var n, s, i = null, r = 0;
            if (e.parentFolderId) {
                if (!this.account._folderInfos.hasOwnProperty(e.parentFolderId)) throw new Error("No such folder: " + e.parentFolderId);
                var o = this.account._folderInfos[e.parentFolderId];
                s = o.$meta.delim, n = o.$meta.path + s, i = o.$meta.id, r = o.depth + 1;
            } else n = "", s = this.account.meta.rootDelim;
            if (n += "string" == typeof e.folderName ? e.folderName : e.folderName.join(s), 
            e.containOnlyOtherFolders && (n += s), this.account.getFolderByPath(n)) t(null); else {
                var a = self.account._learnAboutFolder(e.folderName, n, i, "normal", s, r);
                t(null, a);
            }
        },
        local_do_purgeExcessMessages: function(e, t) {
            this._accessFolderForMutation(e.folderId, !1, function(e, n) {
                n.purgeExcessMessages(function(e) {
                    t(null, null, e > 0);
                });
            }, null, "purgeExcessMessages");
        },
        local_do_saveSentDraft: function(e, t) {
            this._accessFolderForMutation(e.folderId, !1, function(n, i) {
                var r = s.latch();
                i.addMessageHeader(e.headerInfo, e.bodyInfo, r.defer()), i.addMessageBody(e.headerInfo, e.bodyInfo, r.defer()), 
                r.then(function() {
                    t(null, null, !0);
                });
            }, null, "saveSentDraft");
        },
        do_syncFolderList: function(e, t) {
            this.account.meta.lastFolderSyncAt = Date.now(), t(null);
        },
        do_modtags: function(e, t) {
            t(null);
        },
        undo_modtags: function(e, t) {
            t(null);
        },
        local_do_modtags: r.local_do_modtags,
        local_undo_modtags: r.local_undo_modtags,
        local_do_move: r.local_do_move,
        local_undo_move: r.local_undo_move,
        local_do_delete: r.local_do_delete,
        local_undo_delete: r.local_undo_delete,
        local_do_downloadBodies: r.local_do_downloadBodies,
        do_downloadBodies: r.do_downloadBodies,
        check_downloadBodies: r.check_downloadBodies,
        check_downloadBodyReps: r.check_downloadBodyReps,
        do_downloadBodyReps: r.do_downloadBodyReps,
        local_do_downloadBodyReps: r.local_do_downloadBodyReps,
        postJobCleanup: r.postJobCleanup,
        allJobsDone: r.allJobsDone,
        _partitionAndAccessFoldersSequentially: r._partitionAndAccessFoldersSequentially
    }, i(a.prototype, o.draftsMixins);
    var c = t.LOGFAB = n.register(e, {
        Pop3JobDriver: {
            type: n.DAEMON,
            events: {
                savedAttachment: {
                    storage: !0,
                    mimeType: !0,
                    size: !0
                },
                saveFailure: {
                    storage: !1,
                    mimeType: !1,
                    error: !1
                }
            },
            TEST_ONLY_events: {
                saveFailure: {
                    filename: !1
                }
            },
            asyncJobs: {
                acquireConnWithoutFolder: {
                    label: !1
                }
            },
            errors: {
                callbackErr: {
                    ex: n.EXCEPTION
                }
            }
        }
    });
}), define("mailapi/pop3/account", [ "rdcommon/log", "../errbackoff", "../composite/incoming", "./sync", "./jobs", "../drafts/draft_rep", "module", "require", "exports" ], function(e, t, n, s, i, r, o, a, c) {
    function d(e, n, r, o, a, c, d, u, h) {
        this._LOG = p.Pop3Account(this, u, r), l.apply(this, [ s.Pop3FolderSyncer ].concat(Array.slice(arguments))), 
        this._conn = null, this._pendingConnectionRequests = [], this._backoffEndpoint = t.createEndpoint("pop3:" + this.id, this, this._LOG), 
        this.tzOffset = 0, h && (this._conn = h), [ "sent", "localdrafts", "trash" ].forEach(function(e) {
            var t = this.getFirstFolderWithType(e);
            t || this._learnAboutFolder(e, e, null, e, "/", 0, !0);
        }.bind(this)), this._jobDriver = new i.Pop3JobDriver(this, this._folderInfos.$mutationState, this._LOG);
    }
    var l = n.CompositeIncomingAccount;
    c.Account = c.Pop3Account = d, d.prototype = Object.create(l.prototype);
    var u = {
        type: "pop3",
        supportsServerFolders: !1,
        toString: function() {
            return "[Pop3Account: " + this.id + "]";
        },
        withConnection: function(e, t) {
            this._pendingConnectionRequests.push(e);
            var n = function() {
                var e = this._pendingConnectionRequests.shift();
                if (e) {
                    var s = function(t) {
                        t ? (e(t), n()) : e(null, this._conn, n);
                    }.bind(this);
                    this._conn && "disconnected" !== this._conn.state ? s() : this._makeConnection(s, t);
                }
            }.bind(this);
            1 === this._pendingConnectionRequests.length && n();
        },
        __folderDoneWithConnection: function() {},
        _makeConnection: function(e, t) {
            this._conn = !0, a([ "pop3/pop3", "./probe" ], function(n, s) {
                this._LOG.createConnection(t);
                var i = {
                    host: this._connInfo.hostname,
                    port: this._connInfo.port,
                    crypto: this._connInfo.crypto,
                    preferredAuthMethod: this._connInfo.preferredAuthMethod,
                    username: this._credentials.username,
                    password: this._credentials.password
                };
                this._LOG && (i._logParent = this._LOG);
                var r = this._conn = new n.Pop3Client(i, function(t) {
                    return t ? (console.error("Connect error:", t.name, "formal:", t, "on", this._connInfo.hostname, this._connInfo.port), 
                    t = s.analyzeError(t), t.reportProblem && this.universe.__reportAccountProblem(this.compositeAccount, t.name), 
                    e && e(t.name, null), r.die(), t.retry && this._backoffEndpoint.noteConnectFailureMaybeRetry(t.reachable) ? this._backoffEndpoint.scheduleConnectAttempt(this._makeConnection.bind(this)) : this._backoffEndpoint.noteBrokenConnection(), 
                    void 0) : (this._backoffEndpoint.noteConnectSuccess(), e && e(null, r), void 0);
                }.bind(this));
            }.bind(this));
        },
        saveSentMessage: function(e) {
            var t = this.getFirstFolderWithType("sent");
            if (t) {
                var n = this.getFolderStorageForFolderId(t.id), s = n._issueNewHeaderId(), i = n.folderId + "/" + s, o = r.cloneDraftMessageForSentFolderWithoutAttachments(e.header, e.body, {
                    id: s,
                    suid: i
                });
                this.universe.saveSentDraft(t.id, o.header, o.body);
            }
        },
        deleteFolder: function(e, t) {
            if (!this._folderInfos.hasOwnProperty(e)) throw new Error("No such folder: " + e);
            var n = this._folderInfos[e].$meta;
            self._LOG.deleteFolder(n.path), self._forgetFolder(e), t && t(null, n);
        },
        shutdown: function(e) {
            l.prototype.shutdownFolders.call(this), this._backoffEndpoint.shutdown(), this._conn && this._conn.die && this._conn.die(), 
            this._LOG.__die(), e && e();
        },
        checkAccount: function(e) {
            null != this._conn && ("disconnected" !== this._conn.state && this._conn.disconnect(), 
            this._conn = null), this._LOG.checkAccount_begin(null), this.withConnection(function(t) {
                this._LOG.checkAccount_end(t), e(t);
            }.bind(this), "checkAccount");
        },
        accountDeleted: function() {
            this._alive = !1, this.shutdown();
        }
    };
    for (var h in u) Object.defineProperty(d.prototype, h, Object.getOwnPropertyDescriptor(u, h));
    var p = c.LOGFAB = e.register(o, {
        Pop3Account: n.LOGFAB_DEFINITION.CompositeIncomingAccount
    });
}), define("mailapi/smtp/account", [ "rdcommon/log", "module", "require", "exports" ], function(e, t, n, s) {
    function i(e, t, n, s, i, o) {
        this.universe = e, this.compositeAccount = t, this.accountId = n, this.credentials = s, 
        this.connInfo = i, this._LOG = r.SmtpAccount(this, o, n), this._activeConnections = [];
    }
    s.ENABLE_SMTP_LOGGING = !1, s.Account = s.SmtpAccount = i, i.prototype = {
        type: "smtp",
        toString: function() {
            return "[SmtpAccount: " + this.id + "]";
        },
        get numActiveConns() {
            return this._activeConnections.length;
        },
        shutdown: function() {
            this._LOG.__die();
        },
        accountDeleted: function() {
            this.shutdown();
        },
        sendMessage: function(e, t) {
            console.log("smtp: requiring code"), n([ "simplesmtp/lib/client" ], function(n) {
                var i, r = !1, o = !1;
                console.log("smtp: code loaded"), i = n(this.connInfo.port, this.connInfo.hostname, {
                    crypto: this.connInfo.crypto,
                    auth: {
                        user: this.credentials.username,
                        pass: this.credentials.password
                    },
                    debug: s.ENABLE_SMTP_LOGGING
                }), this._activeConnections.push(i), i.once("idle", function() {
                    console.log("smtp: idle reached, sending envelope"), i.useEnvelope(e.getEnvelope());
                }), i.on("message", function() {
                    r || (o = !0, console.log("smtp: message reached, building message blob"), e.withMessageBlob({
                        includeBcc: !1
                    }, function(e) {
                        console.log("smtp: blob composed, writing blob"), i.socket.write(e), i._lastDataBytes[0] = 13, 
                        i._lastDataBytes[1] = 10, i.options.debug && console.log("CLIENT (DATA) blob of size:", e.size), 
                        i.end();
                    }));
                }), i.on("ready", function() {
                    console.log("smtp: send completed, closing connection"), r = !0, i.close(), t(null);
                }), i.on("rcptFailed", function(e) {
                    e.length && (console.warn("smtp: nonzero bad recipients"), r = !0, i.close(), t("bad-recipient", e));
                }), i.on("error", function(e) {
                    if (!r) {
                        var n = null;
                        switch (console.error("smtp: error:", e.name), e.name) {
                          case "Error":
                            n = o ? "bad-message" : "server-maybe-offline";
                            break;

                          case "AuthError":
                            n = "auth";
                            break;

                          case "UnknownAuthError":
                            n = "server-maybe-offline";
                            break;

                          case "TLSError":
                            n = "insecure";
                            break;

                          case "SenderError":
                            n = "bad-sender";
                            break;

                          case "RecipientError":
                            n = "bad-recipient";
                            break;

                          default:
                            n = "unknown";
                        }
                        r = !0, t(n, null);
                    }
                }), i.on("end", function() {
                    console.log("smtp: connection ended");
                    var e = this._activeConnections.indexOf(i);
                    -1 !== e ? this._activeConnections.splice(e, 1) : console.error("Dead unknown connection?"), 
                    r || (t("connection-lost", null), r = !0);
                }.bind(this));
            }.bind(this));
        }
    };
    var r = s.LOGFAB = e.register(t, {
        SmtpAccount: {
            type: e.ACCOUNT,
            events: {},
            TEST_ONLY_events: {},
            errors: {
                folderAlreadyHasConn: {
                    folderId: !1
                }
            }
        }
    });
}), define("mailapi/composite/account", [ "rdcommon/log", "../accountcommon", "../a64", "../accountmixins", "../imap/account", "../pop3/account", "../smtp/account", "exports" ], function(e, t, n, s, i, r, o, a) {
    function c(e, t, n, s, i, r) {
        this.universe = e, this.id = t.id, this.accountDef = t, this._enabled = !0, this.problems = [], 
        this._LOG = r, this.identities = t.identities, d.hasOwnProperty(t.receiveType) || this._LOG.badAccountType(t.receiveType), 
        d.hasOwnProperty(t.sendType) || this._LOG.badAccountType(t.sendType), this._receivePiece = new d[t.receiveType](e, this, t.id, t.credentials, t.receiveConnInfo, n, s, this._LOG, i), 
        this._sendPiece = new d[t.sendType](e, this, t.id, t.credentials, t.sendConnInfo, s, this._LOG), 
        this.folders = this._receivePiece.folders, this.meta = this._receivePiece.meta, 
        this.mutations = this._receivePiece.mutations, this.tzOffset = t.tzOffset;
    }
    var d = {
        imap: i.ImapAccount,
        pop3: r.Pop3Account,
        smtp: o.SmtpAccount
    };
    a.Account = a.CompositeAccount = c, c.prototype = {
        toString: function() {
            return "[CompositeAccount: " + this.id + "]";
        },
        get supportsServerFolders() {
            return this._receivePiece.supportsServerFolders;
        },
        toBridgeWire: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                type: this.accountDef.type,
                defaultPriority: this.accountDef.defaultPriority,
                enabled: this.enabled,
                problems: this.problems,
                syncRange: this.accountDef.syncRange,
                syncInterval: this.accountDef.syncInterval,
                notifyOnNew: this.accountDef.notifyOnNew,
                identities: this.identities,
                credentials: {
                    username: this.accountDef.credentials.username
                },
                servers: [ {
                    type: this.accountDef.receiveType,
                    connInfo: this.accountDef.receiveConnInfo,
                    activeConns: this._receivePiece.numActiveConns || 0
                }, {
                    type: this.accountDef.sendType,
                    connInfo: this.accountDef.sendConnInfo,
                    activeConns: this._sendPiece.numActiveConns || 0
                } ]
            };
        },
        toBridgeFolder: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: "account"
            };
        },
        get enabled() {
            return this._enabled;
        },
        set enabled(e) {
            this._enabled = this._receivePiece.enabled = e;
        },
        saveAccountState: function(e, t, n) {
            return this._receivePiece.saveAccountState(e, t, n);
        },
        get _saveAccountIsImminent() {
            return this.__saveAccountIsImminent;
        },
        set _saveAccountIsImminent(e) {
            this.___saveAccountIsImminent = this._receivePiece._saveAccountIsImminent = e;
        },
        runAfterSaves: function(e) {
            return this._receivePiece.runAfterSaves(e);
        },
        checkAccount: function(e) {
            this._receivePiece.checkAccount(e);
        },
        shutdown: function(e) {
            this._sendPiece.shutdown(), this._receivePiece.shutdown(e);
        },
        accountDeleted: function() {
            this._sendPiece.accountDeleted(), this._receivePiece.accountDeleted();
        },
        deleteFolder: function(e, t) {
            return this._receivePiece.deleteFolder(e, t);
        },
        sliceFolderMessages: function(e, t) {
            return this._receivePiece.sliceFolderMessages(e, t);
        },
        searchFolderMessages: function(e, t, n, s) {
            return this._receivePiece.searchFolderMessages(e, t, n, s);
        },
        syncFolderList: function(e) {
            return this._receivePiece.syncFolderList(e);
        },
        sendMessage: function(e, t) {
            return this._sendPiece.sendMessage(e, function(n, s) {
                n || this._receivePiece.saveSentMessage(e), t(n, s, null);
            }.bind(this));
        },
        getFolderStorageForFolderId: function(e) {
            return this._receivePiece.getFolderStorageForFolderId(e);
        },
        getFolderMetaForFolderId: function(e) {
            return this._receivePiece.getFolderMetaForFolderId(e);
        },
        runOp: function(e, t, n) {
            return this._receivePiece.runOp(e, t, n);
        },
        ensureEssentialFolders: function(e) {
            return this._receivePiece.ensureEssentialFolders(e);
        },
        getFirstFolderWithType: s.getFirstFolderWithType
    };
}), define("mailapi/composite/configurator", [ "rdcommon/log", "../accountcommon", "../a64", "../allback", "./account", "../date", "require", "exports" ], function(e, t, n, s, i, r, o, a) {
    var c = s.allbackMaker;
    a.account = i, a.configurator = {
        tryToCreateAccount: function(e, t, n, s, i) {
            var r, a, d, l;
            n && (l = "imap+smtp" === n.type ? "imap" : "pop3", r = {
                username: n.incoming.username,
                password: t.password
            }, a = {
                hostname: n.incoming.hostname,
                port: n.incoming.port,
                crypto: "string" == typeof n.incoming.socketType ? n.incoming.socketType.toLowerCase() : n.incoming.socketType
            }, "imap" === l ? a.blacklistedCapabilities = null : "pop3" === l && (a.preferredAuthMethod = null), 
            d = {
                emailAddress: t.emailAddress,
                hostname: n.outgoing.hostname,
                port: n.outgoing.port,
                crypto: "string" == typeof n.outgoing.socketType ? n.outgoing.socketType.toLowerCase() : n.outgoing.socketType
            });
            var u = this, h = c([ "incoming", "smtp" ], function(n) {
                if (null === n.incoming[0] && null === n.smtp[0]) {
                    var i = n.incoming[1];
                    if ("imap" === l) {
                        var o = n.incoming[2], c = n.incoming[3];
                        a.blacklistedCapabilities = c, u._defineImapAccount(e, t, r, a, d, i, o, s);
                    } else a.preferredAuthMethod = i.authMethod, u._definePop3Account(e, t, r, a, d, i, s);
                } else ("imap" === l || "pop3" === l) && (null === n.incoming[0] ? (n.incoming[1].die(), 
                s(n.smtp[0], null, n.smtp[1])) : s(n.incoming[0], null, n.incoming[2]));
            });
            o([ "../smtp/probe" ], function(e) {
                var t = new e.SmtpProber(r, d, i);
                t.onresult = h.smtp;
            }), "imap" === l ? o([ "../imap/probe" ], function(e) {
                var t = new e.ImapProber(r, a, i);
                t.onresult = h.incoming;
            }) : o([ "../pop3/probe" ], function(e) {
                var t = new e.Pop3Prober(r, a, i);
                t.onresult = h.incoming;
            });
        },
        recreateAccount: function(e, s, i, r) {
            var o = i.def, a = {
                username: o.credentials.username,
                password: o.credentials.password
            }, c = n.encodeInt(e.config.nextAccountNum++), d = o.type || "imap+smtp", l = {
                id: c,
                name: o.name,
                type: d,
                receiveType: d.split("+")[0],
                sendType: "smtp",
                syncRange: o.syncRange,
                syncInterval: o.syncInterval || 0,
                notifyOnNew: o.hasOwnProperty("notifyOnNew") ? o.notifyOnNew : !0,
                credentials: a,
                receiveConnInfo: {
                    hostname: o.receiveConnInfo.hostname,
                    port: o.receiveConnInfo.port,
                    crypto: o.receiveConnInfo.crypto,
                    blacklistedCapabilities: o.receiveConnInfo.blacklistedCapabilities || null,
                    preferredAuthMethod: o.receiveConnInfo.preferredAuthMethod || null
                },
                sendConnInfo: {
                    hostname: o.sendConnInfo.hostname,
                    port: o.sendConnInfo.port,
                    crypto: o.sendConnInfo.crypto
                },
                identities: t.recreateIdentities(e, c, o.identities),
                tzOffset: void 0 !== i.tzOffset ? i.tzOffset : -252e5
            };
            this._loadAccount(e, l, i.folderInfo, null, function(e) {
                r(null, e, null);
            });
        },
        _defineImapAccount: function(e, t, s, i, o, a, c, d) {
            var l = n.encodeInt(e.config.nextAccountNum++), u = {
                id: l,
                name: t.accountName || t.emailAddress,
                defaultPriority: r.NOW(),
                type: "imap+smtp",
                receiveType: "imap",
                sendType: "smtp",
                syncRange: "auto",
                syncInterval: t.syncInterval || 0,
                notifyOnNew: t.hasOwnProperty("notifyOnNew") ? t.notifyOnNew : !0,
                credentials: s,
                receiveConnInfo: i,
                sendConnInfo: o,
                identities: [ {
                    id: l + "/" + n.encodeInt(e.config.nextIdentityNum++),
                    name: t.displayName,
                    address: t.emailAddress,
                    replyTo: null,
                    signature: null
                } ],
                tzOffset: c
            };
            this._loadAccount(e, u, null, a, function(e) {
                d(null, e, null);
            });
        },
        _definePop3Account: function(e, t, s, i, o, a, c) {
            var d = n.encodeInt(e.config.nextAccountNum++), l = {
                id: d,
                name: t.accountName || t.emailAddress,
                defaultPriority: r.NOW(),
                type: "pop3+smtp",
                receiveType: "pop3",
                sendType: "smtp",
                syncRange: "auto",
                syncInterval: t.syncInterval || 0,
                notifyOnNew: t.hasOwnProperty("notifyOnNew") ? t.notifyOnNew : !0,
                credentials: s,
                receiveConnInfo: i,
                sendConnInfo: o,
                identities: [ {
                    id: d + "/" + n.encodeInt(e.config.nextIdentityNum++),
                    name: t.displayName,
                    address: t.emailAddress,
                    replyTo: null,
                    signature: null
                } ]
            };
            this._loadAccount(e, l, null, a, function(e) {
                c(null, e, null);
            });
        },
        _loadAccount: function(e, t, n, s, i) {
            var r;
            r = "imap" === t.receiveType ? {
                $meta: {
                    nextFolderNum: 0,
                    nextMutationNum: 0,
                    lastFolderSyncAt: 0,
                    capability: n && n.$meta.capability || s.capabilities,
                    rootDelim: n && n.$meta.rootDelim || s.delim
                },
                $mutations: [],
                $mutationState: {}
            } : {
                $meta: {
                    nextFolderNum: 0,
                    nextMutationNum: 0,
                    lastFolderSyncAt: 0
                },
                $mutations: [],
                $mutationState: {}
            }, e.saveAccountDef(t, r), e._loadAccount(t, r, s, i);
        }
    };
});