;'use strict';window.addEventListener('localized',function showPanel(){var _=navigator.mozL10n.get;var settings=window.navigator.mozSettings;var bluetooth=window.navigator.mozBluetooth;var defaultAdapter=null;var activity=null;var sendingFilesSchedule={};var _debug=false;navigator.mozSetMessageHandler('activity',function handler(activityRequest){activity=activityRequest;if(settings&&bluetooth&&(activity.source.name=='share')&&(activity.source.data.blobs&&activity.source.data.blobs.length>0)){isBluetoothEnabled();}else{var msg='Cannot transfer without blobs data!';cannotTransfer(msg);}});var dialogConfirmBluetooth=document.getElementById('enable-bluetooth-view');var bluetoothCancelButton=document.getElementById('enable-bluetooth-button-cancel');var bluetoothTurnOnButton=document.getElementById('enable-bluetooth-button-turn-on');var dialogAlertView=document.getElementById('alert-view');var alertOkButton=document.getElementById('alert-button-ok');function debug(msg){if(!_debug)
return;console.log('[Bluetooth APP Send File]: '+msg);}
function isBluetoothEnabled(){var req=settings.createLock().get('bluetooth.enabled');req.onsuccess=function bt_EnabledSuccess(){if(req.result['bluetooth.enabled']){initialDefaultAdapter();}else{confirmTurnBluetoothOn();}};req.onerror=function bt_EnabledOnerror(){var msg='Can not get bluetooth.enabled from setting!';cannotTransfer(msg);};}
function confirmTurnBluetoothOn(){dialogConfirmBluetooth.hidden=false;bluetoothCancelButton.addEventListener('click',cancelTransfer);bluetoothTurnOnButton.addEventListener('click',turnOnBluetooth);}
function turnOnBluetooth(evt){if(evt)
evt.preventDefault();dialogConfirmBluetooth.hidden=true;bluetooth.onadapteradded=function bt_adapterAdded(){initialDefaultAdapter();};settings.createLock().set({'bluetooth.enabled':true});}
function initialDefaultAdapter(callback){if(!bluetooth.enabled){return;}
var req=bluetooth.getDefaultAdapter();req.onsuccess=function bt_getAdapterSuccess(){defaultAdapter=req.result;if(defaultAdapter==null){settings.createLock().set({'bluetooth.enabled':false});var msg='Get null bluetooth adapter!';cannotTransfer(msg);return;}
if(callback){callback();}
defaultAdapter.ondevicefound=gDeviceList.onDeviceFound;gDeviceList.initWithAdapter(defaultAdapter,transferToDevice,cancelTransfer);gDeviceList.update(true);};req.onerror=function bt_getAdapterFailed(){settings.createLock().set({'bluetooth.enabled':false});var msg='Can not get bluetooth adapter!';cannotTransfer(msg);};}
function cancelTransfer(evt){if(evt)
evt.preventDefault();dialogConfirmBluetooth.hidden=true;gDeviceList.uninit();activity.postError('cancelled');endTransfer();}
function cannotTransfer(msg){debug(msg);dialogAlertView.hidden=false;alertOkButton.addEventListener('click',closeAlert);}
function closeAlert(){dialogAlertView.hidden=true;alertOkButton.removeEventListener('click',closeAlert);activity.postError('cancelled');endTransfer();}
function endTransfer(){bluetoothCancelButton.removeEventListener('click',cancelTransfer);bluetoothTurnOnButton.removeEventListener('click',turnOnBluetooth);activity=null;}
function transferToDevice(device){var targetDevice=device;sendingFilesSchedule={numberOfFiles:activity.source.data.blobs.length,numSuccessful:0,numUnsuccessful:0};postMessageToSystemApp(sendingFilesSchedule);var blobs=activity.source.data.blobs;var numberOfTasks=blobs.length;blobs.forEach(function(blob,index){if(blob.name){defaultAdapter.sendFile(targetDevice.address,blob);var msg='blob is sending...';debug(msg);if(--numberOfTasks===0){transferred();}}else{var filepath=activity.source.data.filepaths[index];var storage=navigator.getDeviceStorage('sdcard');var getRequest=storage.get(filepath);getRequest.onsuccess=function(){defaultAdapter.sendFile(targetDevice.address,getRequest.result);var msg='getFile succeed & file is sending...';debug(msg);if(--numberOfTasks===0){transferred();}};getRequest.onerror=function(){defaultAdapter.sendFile(targetDevice.address,blob);var msg='getFile failed so that blob is sending without filename '+
getRequest.error&&getRequest.error.name;debug(msg);if(--numberOfTasks===0){transferred();}};}});}
function transferred(){activity.postResult('transferred');endTransfer();}
function postMessageToSystemApp(sendingFilesSchedule){navigator.mozApps.getSelf().onsuccess=function gotSelf(evt){var app=evt.target.result;if(!app.connect){sendingFilesSchedule={};return;}
app.connect('bluetoothTransfercomms').then(function(ports){ports.forEach(function(port){port.postMessage(sendingFilesSchedule);var msg='post message to system app...';debug(msg);});sendingFilesSchedule={};});};}});;'use strict';var gDeviceList=null;navigator.mozL10n.ready(function deviceList(){var _=navigator.mozL10n.get;var settings=window.navigator.mozSettings;var bluetooth=window.navigator.mozBluetooth;var defaultAdapter=null;var _debug=false;if(!settings||!bluetooth){return;}
function debug(msg){if(!_debug)
return;console.log('[Bluetooth APP Device List]: '+msg);}
gDeviceList=(function deviceList(){var deviceList=document.getElementById('devices-list-view');var bluetoothSearch=document.getElementById('bluetooth-search');var searchAgainBtn=document.getElementById('search-device');var searchingItem=document.getElementById('bluetooth-searching');var exitButton=document.getElementById('cancel-activity');var pairingMode='active';var userCanceledPairing=false;var pairingAddress=null;var connectingAddress=null;var connectedAddress=null;var discoverTimeoutTime=60000;var discoverTimeout=null;var onDeviceSelectedHandler=null;var onExitBtnClickedHandler=null;var isSendingFile=false;var pairList={title:document.getElementById('bluetooth-paired-title'),list:document.getElementById('bluetooth-paired-devices'),index:[],clear:function emptyList(){while(this.list.hasChildNodes()){this.list.removeChild(this.list.lastChild);}
this.index=[];},show:function showArea(isShown){if(!isShown){this.clear();}
this.title.hidden=!isShown;this.list.hidden=!isShown;}};var openList={title:document.getElementById('bluetooth-found-title'),list:document.getElementById('bluetooth-devices'),index:[],clear:function emptyList(){while(this.list.hasChildNodes()){this.list.removeChild(this.list.lastChild);}
this.index=[];},show:function showArea(isShown){if(!isShown){this.clear();}
this.title.hidden=!isShown;this.list.hidden=!isShown;}};searchAgainBtn.onclick=function searchAgainClicked(){if(isSendingFile||pairingAddress){return;}
updateDeviceList(true);openList.clear();startDiscovery();};function newListItem(device,descL10nId){var deviceName=document.createElement('a');var aName=(device.name==='')?_('unnamed-device'):device.name;var aL10nId=(device.name==='')?'unnamed-device':'';deviceName.textContent=aName;deviceName.dataset.l10nId=aL10nId;var deviceDesc=document.createElement('small');deviceDesc.textContent=(descL10nId==='')?'':_(descL10nId);deviceDesc.dataset.l10nId=descL10nId;var pairingProgress=document.createElement('progress');pairingProgress.classList.add('overlapping-icon');pairingProgress.classList.add('hidden');var li=document.createElement('li');li.classList.add('bluetooth-device');li.classList.add('bluetooth-type-'+device.icon);li.appendChild(deviceDesc);li.appendChild(deviceName);li.appendChild(pairingProgress);return li;}
function updateDeviceList(show){bluetoothSearch.hidden=!show;if(show){openList.show(true);searchingItem.hidden=false;}}
function initial(adapter,deviceSelectedCallback,exitBtnClickedCallback){deviceList.hidden=false;exitButton.addEventListener('click',cancelActivity);defaultAdapter=adapter;defaultAdapter.onpairedstatuschanged=function bt_getPairedMessage(evt){showDevicePaired(evt.status,'Authentication Failed');};onDeviceSelectedHandler=deviceSelectedCallback;onExitBtnClickedHandler=exitBtnClickedCallback;getPairedDevice();startDiscovery();}
function uninit(){deviceList.hidden=true;defaultAdapter=null;exitButton.removeEventListener('click',cancelActivity);}
function getPairedDevice(){if(!bluetooth.enabled||!defaultAdapter)
return;var req=defaultAdapter.getPairedDevices();req.onsuccess=function bt_getPairedSuccess(){var paired=req.result.slice();var length=paired.length;if(length==0){pairList.show(false);return;}
pairList.clear();paired.sort(function(a,b){return a.name>b.name;});for(var i=0;i<length;i++){(function(device){var stateL10nId=(device.address===connectedAddress)?'device-status-connected':'';var aItem=newListItem(device,stateL10nId);aItem.onclick=function(){if(isSendingFile||pairingAddress){return;}
stopDiscovery();var small=aItem.querySelector('small');small.textContent=_('device-status-connecting');small.dataset.l10nId='device-status-connecting';readyToSendFile(device);};pairList.list.appendChild(aItem);pairList.index[device.address]=[device,aItem];})(paired[i]);}
pairList.show(true);};}
function onDeviceFound(evt){var device=evt.device;var existingDevice=openList.index[device.address]||pairList.index[device.address];if(existingDevice){var existingItem=existingDevice[1];if(device.name&&existingItem){var deviceName=existingItem.querySelector('a');if(deviceName){deviceName.dataset.l10nId='';deviceName.textContent=device.name;}}
return;}
var aItem=newListItem(device,'device-status-tap-connect');aItem.onclick=function(){stopDiscovery();if(isSendingFile||pairingAddress){return;}
var small=aItem.querySelector('small');small.textContent=_('device-status-pairing');small.dataset.l10nId='device-status-pairing';aItem.classList.add('icon-hidden');var progress=aItem.querySelector('progress');progress.classList.remove('hidden');var req=defaultAdapter.pair(device.address);pairingMode='active';pairingAddress=device.address;var msg='pairing with address = '+pairingAddress;debug(msg);req.onerror=function bt_pairError(error){showDevicePaired(false,req.error.name);};};openList.list.appendChild(aItem);openList.index[device.address]=[device,aItem];}
function showDevicePaired(paired,errorMessage){if(!pairingAddress){getPairedDevice();return;}
var workingAddress=pairingAddress;pairingAddress=null;searchAgainBtn.disabled=false;if(paired){if(openList.index[workingAddress]){var device=openList.index[workingAddress][0];var item=openList.index[workingAddress][1];openList.list.removeChild(item);delete openList.index[workingAddress];connectingAddress=workingAddress;readyToSendFile(device);}}else{if(pairingMode==='active'&&!userCanceledPairing){var msg=_('error-pair-title');if(errorMessage==='Repeated Attempts'){msg=msg+'\n'+_('error-pair-toofast');}else if(errorMessage==='Authentication Failed'){msg=msg+'\n'+_('error-pair-pincode');}
debug(msg);window.alert(msg);}
userCanceledPairing=false;if(openList.index[workingAddress]){var small=openList.index[workingAddress][1].querySelector('small');small.textContent=_('device-status-tap-connect');small.dataset.l10nId='device-status-tap-connect';var li=openList.index[workingAddress][1];li.classList.remove('icon-hidden');var progress=openList.index[workingAddress][1].querySelector('progress');progress.classList.add('hidden');}}
getPairedDevice();}
function startDiscovery(){if(!bluetooth.enabled||!defaultAdapter||discoverTimeout)
return;var req=defaultAdapter.startDiscovery();req.onsuccess=function bt_discoveryStart(){searchAgainBtn.disabled=true;if(!discoverTimeout)
discoverTimeout=setTimeout(stopDiscovery,discoverTimeoutTime);};req.onerror=function bt_discoveryFailed(){searchingItem.hidden=true;searchAgainBtn.disabled=false;};}
function stopDiscoveryWhenLeaveApp(){if(!document.hidden)
return;stopDiscovery();}
function stopDiscovery(){if(!bluetooth.enabled||!defaultAdapter||!discoverTimeout)
return;var req=defaultAdapter.stopDiscovery();req.onsuccess=function bt_discoveryStopped(){if(!pairingAddress)
searchAgainBtn.disabled=false;searchingItem.hidden=true;};req.onerror=function bt_discoveryStopFailed(){console.error('Can not stop discover nearby device');searchAgainBtn.disabled=true;searchingItem.hidden=false;};clearTimeout(discoverTimeout);discoverTimeout=null;}
function readyToSendFile(targetDevice){isSendingFile=true;if(onDeviceSelectedHandler){onDeviceSelectedHandler(targetDevice);}}
function cancelActivity(){if(onExitBtnClickedHandler){onExitBtnClickedHandler();}}
return{update:updateDeviceList,initWithAdapter:initial,uninit:uninit,startDiscovery:startDiscovery,onDeviceFound:onDeviceFound};})();});