;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::|:\/\/)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},hasScheme:function(input){return!!(rscheme.exec(input)||[])[0];},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var schemeReg=/^\w+\:\/\//;var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data\:)/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)){return true;}
if(case3Reg.test(str)){return false;}
if(!schemeReg.test(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;var DateHelper={todayStarted:function dh_todayStarted(){var now=(new Date()).valueOf();return this.getMidnight(now);},yesterdayStarted:function dh_yesterdayStarted(){var now=(new Date()).valueOf();var dayAgo=now-86400000;return this.getMidnight(dayAgo);},thisWeekStarted:function dh_thisWeekStarted(){var now=new Date();var dayOfTheWeek=now.getDay();var firstDay=new Date(now.getFullYear(),now.getMonth(),now.getDate()-dayOfTheWeek);return this.getMidnight(firstDay);},thisMonthStarted:function dh_thisMonthStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),now.getMonth(),1).valueOf());return firstDay;},lastSixMonthsStarted:function dh_lastSixMonthsStarted(){var now=new Date().valueOf();var sixMonthsAgo=now-2629743830*6;return sixMonthsAgo;},thisYearStarted:function dh_thisYearStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),0).valueOf());return firstDay;},getMidnight:function dh_getMidnight(timestamp){var day=new Date(timestamp);var midnight=(new Date(day.getFullYear(),day.getMonth(),day.getDate(),0).valueOf());return midnight;}};var NumberHelper={zfill:function nh_zfill(string,len){var s=string;while(s.length<len)s='0'+s;return s;}};var HtmlHelper={createHighlightHTML:function ut_createHighlightHTML(text,searchRegExp){if(!searchRegExp){return this.escapeHTML(text);}
searchRegExp=new RegExp(searchRegExp,'gi');var sliceStrs=text.split(searchRegExp);var patterns=text.match(searchRegExp);if(!patterns){return this.escapeHTML(text);}
var str='';for(var i=0;i<patterns.length;i++){str=str+
this.escapeHTML(sliceStrs[i])+'<span class="highlight">'+
this.escapeHTML(patterns[i])+'</span>';}
str+=this.escapeHTML(sliceStrs.pop());return str;},escapeHTML:function ut_escapeHTML(str,escapeQuotes){var span=document.createElement('span');span.textContent=str;span.innerHTML=span.innerHTML.replace(/\s/g,'&nbsp;');if(escapeQuotes)
return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return span.innerHTML;}};var StringHelper={fromUTF8:function ut_fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;}};;(function(){'use strict';var SEARCH_DELAY=600;window.Search={_port:null,exactResults:{},fuzzyResults:{},dedupeNullList:['mobile','touch'],providers:{},init:function(){var self=this;navigator.mozApps.getSelf().onsuccess=function(){var app=this.result;app.connect('search-results').then(function onConnectionAccepted(ports){ports.forEach(function(port){self._port=port;});setConnectionHandler();},function onConnectionRejected(reason){console.log('Error connecting: '+reason+'\n');});};function setConnectionHandler(){navigator.mozSetMessageHandler('connection',function(connectionRequest){var keyword=connectionRequest.keyword;var port=connectionRequest.port;if(keyword==='search'){port.onmessage=self.dispatchMessage.bind(self);port.start();}});initializeProviders();}
function initializeProviders(){for(var i in self.providers){self.providers[i].init();}}},provider:function(provider){this.providers[provider.name]=provider;},dispatchMessage:function(msg){if(typeof this[msg.data.action]==='function'){this[msg.data.action](msg);}},change:function(msg){clearTimeout(this.changeTimeout);var input=msg.data.input;var providers=this.providers;this.changeTimeout=setTimeout(function doSearch(){this.exactResults={};this.fuzzyResults={};for(var i in providers){var provider=providers[i];provider.search(input,this.collect.bind(this,provider));}}.bind(this),SEARCH_DELAY);},expandSearch:function(query){this.clear();var webProvider=this.providers.WebResults;webProvider.search(query,function onCollect(results){webProvider.render(results);});this.providers.BGImage.fetchImage(query);},collect:function(provider,results){if(!provider.dedupes){provider.render(results);return;}
var validResults=[];var exactDedupeIdCache=[];var fuzzyDedupeIdCache=[];results.forEach(function eachResult(result){var found=false;var dedupeId=result.dedupeId.toLowerCase();var host;try{host=new URL(dedupeId).host;}catch(e){host=dedupeId;}
var fuzzyDedupeIds=[host,dedupeId];var hostParts=host.split('.');for(var i in hostParts){var part=hostParts[i];if(part.length>3&&this.dedupeNullList.indexOf(part)===-1){fuzzyDedupeIds.push(part);}}
if(provider.dedupeStrategy=='exact'){if(this.exactResults[dedupeId]){found=true;}}else{fuzzyDedupeIds.forEach(function eachFuzzy(eachId){for(var i in this.fuzzyResults){if(i.indexOf(eachId)!==-1){found=true;}}},this);}
exactDedupeIdCache.push(dedupeId);fuzzyDedupeIdCache=fuzzyDedupeIdCache.concat(fuzzyDedupeIds);if(!found){validResults.push(result);}},this);exactDedupeIdCache.forEach(function eachFuzzy(eachId){this.exactResults[eachId]=true;},this);fuzzyDedupeIdCache.forEach(function eachFuzzy(eachId){this.fuzzyResults[eachId]=true;},this);provider.render(validResults);},submit:function(msg){var input=msg.data.input;if(UrlHelper.isNotURL(input)){this.expandSearch(input);return;}
var hasScheme=UrlHelper.hasScheme(input);if(!hasScheme){input='http://'+input;}
this.navigate(input);},clear:function(msg){this.abort();for(var i in this.providers){this.providers[i].clear();}},abort:function(){clearTimeout(this.changeTimeout);for(var i in this.providers){this.providers[i].abort();}},close:function(){this.abort();this._port.postMessage({'action':'hide'});},navigate:function(url,config){var features={remote:true,useAsyncPanZoom:true};config=config||{};for(var i in config){features[i]=config[i];}
var featureStr=Object.keys(features).map(function(key){return encodeURIComponent(key)+'='+
encodeURIComponent(features[key]);}).join(',');window.open(url,'_blank',featureStr);},setInput:function(input){this._port.postMessage({'input':input});this.expandSearch(input);}};window.addEventListener('load',Search.init.bind(Search));})();;(function(){'use strict';var DS_NAME='eme_store';var DS_CONFIG_ID=1;function generateDeviceId(){var url=window.URL.createObjectURL(new Blob());var id=url.replace('blob:','');window.URL.revokeObjectURL(url);return'fxos-'+id;}
window.eme={api:null,init:function init(){var config=new Promise(function done(resolve,reject){navigator.getDataStores(DS_NAME).then(function(stores){if(stores.length===1){var db=stores[0];db.get(DS_CONFIG_ID).then(function get(emeConfig){if(emeConfig){resolve(emeConfig);}else{emeConfig={'deviceId':generateDeviceId()};db.add(emeConfig,DS_CONFIG_ID).then(function success(id){resolve(emeConfig);},function error(e){reject('config creation failed');});}},function error(e){reject(e.message);});}else{reject('invalid datastore setup');}});});config.then(function resolve(emeConfig){eme.api.init(emeConfig);},function reject(reason){});this.init=function noop(){};}};})();;(function(){'use strict';function partnersAPI(eme){var OK=1;var API_URL='https://api.everything.me/partners/1.0/{resource}/';var API_KEY='79011a035b40ef3d7baeabc8f85b862f';var deviceId=null;this.init=function init(config){deviceId=config.deviceId;this.Apps=Apps();this.Search=Search();};function Apps(){var service='Apps';var MAX_QUERY_LENGTH=128;function search(options){var method='search';if(!!options.query&&options.query.length>MAX_QUERY_LENGTH){options.query=options.query.substr(0,MAX_QUERY_LENGTH);}
return apiRequest(service,method,options);}
return{search:search};}
function Search(){var service='Search';function suggestions(options){return apiRequest(service,'suggestions',options);}
function bgimage(options){return apiRequest(service,'bgimage',options);}
return{suggestions:suggestions,bgimage:bgimage};}
function apiRequest(service,method,options){var resource=service+'/'+method;var url=API_URL.replace('{resource}',resource);var payload='';options=options?options:{};options.apiKey=API_KEY;options.deviceId=deviceId;for(var k in options){var v=options[k];if(v!==null&&v!==undefined){payload+=k+'='+encodeURIComponent(options[k])+'&';}}
var httpRequest;var promise=new Promise(function done(resolve,reject){httpRequest=new XMLHttpRequest();httpRequest.open('POST',url,true);httpRequest.setRequestHeader('Content-Type','application/x-www-form-urlencoded');httpRequest.onload=function onload(e){var response=null;try{response=JSON.parse(httpRequest.responseText);}catch(ex){reject(ex);}
if(response&&response.errorCode===OK){resolve(response);}else{reject(response?'errorCode: '+response.errorCode:'invalid response');}};httpRequest.onerror=function onError(e){reject('network error');};httpRequest.withCredentials=true;httpRequest.send(payload);});promise.abort=function(){if(httpRequest.abort){httpRequest.abort();}};return promise;}}
eme.api=new partnersAPI();})(window.eme);;'use strict';function Provider(){}
Provider.prototype={name:'Provider',dedupes:false,init:function(){this.container=document.getElementById(this.name.toLowerCase());this.container.addEventListener('click',this.click.bind(this));},clear:function(){this.container.innerHTML='';},click:function(){},abort:function(){if(this.request&&this.request.abort){this.request.abort();}},render:function(results){var frag=document.createDocumentFragment();results.forEach(function(config){var result=document.createElement('div');var icon=document.createElement('img');var description=document.createElement('div');var title=document.createElement('span');var meta=document.createElement('small');result.classList.add('result');icon.classList.add('icon');description.classList.add('description');title.classList.add('title');meta.classList.add('meta');for(var i in config.dataset){result.dataset[i]=config.dataset[i];}
if(config.icon&&UrlHelper.hasScheme(config.icon)){icon.src=config.icon;}else if(config.icon){icon.src=window.URL.createObjectURL(config.icon);icon.onload=function(){window.URL.revokeObjectURL(icon.src);};}else{icon.classList.add('empty');}
title.innerHTML=config.title;if(config.meta){meta.innerHTML=config.meta;}
description.appendChild(title);description.appendChild(meta);result.appendChild(icon);result.appendChild(description);frag.appendChild(result);});this.container.appendChild(frag);}};;(function(){'use strict';const NUM_DISPLAY=4;const API='https://marketplace.firefox.com/api/v1/apps/search/rocketbar/'+'?q={q}'+'&limit='+NUM_DISPLAY+'&lang='+document.documentElement.lang;function Marketplace(){}
Marketplace.prototype={__proto__:Provider.prototype,name:'Marketplace',dedupes:true,dedupeStrategy:'exact',click:function(e){var slug=e.target.dataset.slug;var activity=new MozActivity({name:'marketplace-app',data:{slug:slug}});activity.onerror=function onerror(){Search.navigate('https://marketplace.firefox.com/app/'+slug);};},search:function(input,collect){this.clear();this.abort();if(!input){return;}
var req=new XMLHttpRequest();req.open('GET',API.replace('{q}',input),true);req.onload=(function onload(){var results=JSON.parse(req.responseText);if(!results.length){return;}
var length=Math.min(NUM_DISPLAY,results.length);var formatted=[];for(var i=0;i<length;i++){var app=results[i];formatted.push({title:navigator.mozL10n.get('install-marketplace-title',{title:app.name}),icon:app.icon,dedupeId:app.manifest_url,dataset:{slug:app.slug}});}
collect(formatted);}).bind(this);req.onerror=function onerror(){console.log('Marketplace error.');};req.ontimeout=function ontimeout(){console.log('Marketplace timeout.');};req.send();this.request=req;}};Search.provider(new Marketplace());}());;(function(){'use strict';var results={};var icons={};var urls=[];var MAX_URLS=50;var MAX_RESULTS=3;var STORE_NAME='places';var lastRevision=0;var syncing=false;var store;navigator.getDataStores(STORE_NAME).then(function(stores){store=stores[0];store.onchange=function(){doSync();};doSync();});function saveIcon(url){if(url in icons){return;}
fetchIcon(url,function(err,icon){if(err){icons[url]=null;}else{icons[url]=icon;}});}
function fetchIcon(uri,callback){var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',uri,true);xhr.responseType='blob';xhr.addEventListener('load',function(){if(!(xhr.status===200||xhr.status===0)){return callback(new Error('error_downloading'));}
var blob=xhr.response;if(blob.type.split('/')[0]!='image'){return callback(new Error('not an image'));}
if(blob.size>this.MAX_ICON_SIZE){return callback(new Error('image_to_large'));}
var img=document.createElement('img');img.src=window.URL.createObjectURL(blob);img.onload=function(){window.URL.revokeObjectURL(img.src);if(img.naturalWidth<=0){return callback(new Error('Cannot load image'));}
callback(null,blob);};img.onerror=function(){window.URL.revokeObjectURL(img.src);return callback(new Error('Cannot load image'));};});xhr.onerror=function(){return callback(new Error('Cannot load uri'));};xhr.send();}
function doSync(){if(syncing){return;}
syncing=true;var cursor=store.sync(lastRevision);function cursorResolve(task){lastRevision=task.revisionId;switch(task.operation){case'update':case'add':if(task.data.url.startsWith('app://')||task.data.url==='about:blank'){break;}
results[task.data.url]=task.data;if(task.data.iconUri){saveIcon(task.data.iconUri);}
if(!(task.data.url in urls)){urls.unshift(task.data.url);}
while(urls.length>MAX_URLS){var url=urls.pop();delete results[url];}
break;case'clear':case'remove':break;case'done':syncing=false;return;}
cursor.next().then(cursorResolve);}
cursor.next().then(cursorResolve);}
function matchesFilter(value,filter){return!filter||(value&&value.match(new RegExp(filter,'i'))!==null);}
function formatPlace(placeObj,filter){var titleText=placeObj.title||placeObj.url;var renderObj={title:HtmlHelper.createHighlightHTML(titleText,filter),meta:HtmlHelper.createHighlightHTML(placeObj.url,filter),dataset:{url:placeObj.url}};if(placeObj.iconUri in icons&&icons[placeObj.iconUri]){renderObj.icon=icons[placeObj.iconUri];}
return renderObj;}
function Places(){}
Places.prototype={__proto__:Provider.prototype,name:'Places',click:function(e){var target=e.target;window.open(target.dataset.url,'_blank','remote=true');},search:function(filter,collect){this.clear();var matched=0;var renderResults=[];for(var url in results){var result=results[url];if(!(matchesFilter(result.title,filter)||matchesFilter(result.url,filter))){continue;}
renderResults.push(formatPlace(result,filter));if(++matched>=MAX_RESULTS){break;}}
collect(renderResults);}};Search.provider(new Places());}());;(function(){'use strict';function LocalApps(){this.apps={};var mozApps=navigator.mozApps.mgmt;var self=this;mozApps.oninstall=function oninstall(e){self.apps[e.application.manifestURL]=e.application;};mozApps.onuninstall=function oninstall(e){delete self.apps[e.application.manifestURL];};mozApps.getAll().onsuccess=function r_getApps(e){e.target.result.forEach(function r_AppsForEach(app){self.apps[app.manifestURL]=app;});};}
LocalApps.prototype={__proto__:Provider.prototype,name:'LocalApps',dedupes:true,dedupeStrategy:'exact',click:function(e){var target=e.target;var manifestURL=target.dataset.manifest;if(manifestURL&&this.apps[manifestURL]){if(target.dataset.entryPoint){this.apps[manifestURL].launch(target.dataset.entryPoint);}else{this.apps[manifestURL].launch();}}},search:function(input,collect){this.clear();var results=this.find(input);var formatted=[];results.forEach(function eachResult(result){var dataset={manifest:result.manifestURL};if(result.entryPoint){dataset.entryPoint=result.entryPoint;}
var icons=result.manifest.icons||{};var imgUrl='';for(var i in icons){var eachUrl=icons[i];if(UrlHelper.hasScheme(eachUrl)){imgUrl=eachUrl;}else{var a=document.createElement('a');a.href=result.origin;imgUrl=a.protocol+'//'+a.host+eachUrl;}}
if(!imgUrl){return;}
formatted.push({title:result.manifest.name,icon:imgUrl,dedupeId:result.manifestURL,dataset:dataset});},this);collect(formatted);},find:function(query){var results=[];var manifestURLs=Object.keys(this.apps);manifestURLs.forEach(function eachManifest(manifestURL){var app=this.apps[manifestURL];var manifest=app.manifest;var HIDDEN_ROLES=['system','input','homescreen','search'];if(HIDDEN_ROLES.indexOf(manifest.role)!==-1){return;}
var appListing=[];var entryPoints=manifest.entry_points;if(entryPoints){for(var i in entryPoints){var entry=entryPoints[i];entry.entryPoint=i;appListing.push(entry);}}else{appListing.push(manifest);}
appListing.forEach(function(manifest){if(manifest.name.toLowerCase().indexOf(query.toLowerCase())!=-1){results.push({origin:app.origin,manifestURL:manifestURL,app:app,manifest:manifest,entryPoint:manifest.entryPoint});}});},this);return results;}};Search.provider(new LocalApps());}());;(function(){'use strict';var ANNOTATION_REGEX=/\[(.+?)\]/g;function deannotate(match,p1){return p1;}
function getSuggestionText(item){return item.replace(ANNOTATION_REGEX,deannotate);}
function Suggestions(eme){}
Suggestions.prototype={__proto__:Provider.prototype,name:'Suggestions',init:function(config){Provider.prototype.init.apply(this,arguments);eme.init();},click:function(e){var suggestion=e.target&&e.target.dataset.suggestion;if(suggestion){Search.setInput(suggestion);}},search:function(input){this.clear();if(!eme.api.Search){return;}
this.request=eme.api.Search.suggestions({'query':input});this.request.then((function success(data){var items=data.response;if(items&&items.length){this.render(input,items);}}).bind(this),function reject(reason){});},render:function(input,items){var ul=document.createElement('ul');items.forEach(function each(item){var text=getSuggestionText(item);if(text!==input){var li=document.createElement('li');li.dataset.suggestion=li.textContent=text;ul.appendChild(li);}});this.clear();if(ul.childNodes.length){this.container.appendChild(ul);}}};Search.provider(new Suggestions(window.eme));}());;(function(){'use strict';function formatImage(image){if(!image||typeof image!=='object'){return image;}
if(image.MIMEType==='image/url'){return image.data;}
if(!image.MIMEType||image.data.length<10){return null;}
return'data:'+image.MIMEType+';base64,'+image.data;}
function BGImage(eme){}
BGImage.prototype={__proto__:Provider.prototype,name:'BGImage',container:document.createElement('div'),init:function(){this.width=Math.floor(window.innerWidth*window.devicePixelRatio);this.height=Math.floor(window.innerHeight*window.devicePixelRatio);eme.init();},search:function(){this.abort();this.clear();},clear:function(){document.body.classList.remove('bgimage');document.body.style.backgroundImage='';},fetchImage:function(input){this.clear();if(!eme.api.Search){return;}
this.request=eme.api.Search.bgimage({query:input,width:this.width,height:this.height});this.request.then((function resolve(data){var response=data.response;document.body.classList.add('bgimage');document.body.style.backgroundImage='url('+
formatImage(response.image)+')';}).bind(this),function reject(reason){});}};Search.provider(new BGImage(window.eme));}());;(function(){'use strict';function WebResults(eme){}
WebResults.prototype={__proto__:Provider.prototype,name:'WebResults',dedupes:true,dedupeStrategy:'fuzzy',init:function(){Provider.prototype.init.apply(this,arguments);eme.init();},click:function(e){var url=e.target&&e.target.dataset.url;if(url){Search.navigate(url,{icon:e.target.dataset.icon,originUrl:url,originName:e.target.dataset.title});}},search:function(input,collect){this.clear();if(!eme.api.Apps){return;}
this.request=eme.api.Apps.search({'query':input});this.request.then((function resolve(data){var response=data.response;if(response&&response.apps&&response.apps.length){var results=response.apps.map(function each(app){return{title:app.name,icon:app.icon,dedupeId:app.appUrl,dataset:{title:app.name,url:app.appUrl,icon:app.icon}};});collect(results);}}).bind(this),function reject(reason){});}};Search.provider(new WebResults(window.eme));}());;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);