;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';const Keyboards={alternateLayout:{alt:{'0':'º','$':'€ £ ¥ R$','?':'¿','!':'¡'},keys:[[{value:'1'},{value:'2'},{value:'3'},{value:'4'},{value:'5'},{value:'6'},{value:'7'},{value:'8'},{value:'9'},{value:'0'}],[{value:'@',hidden:['email']},{value:'#'},{value:'$'},{value:'%'},{value:'&'},{value:'*'},{value:'-'},{value:'+'},{value:'('},{value:')'},{value:'_',visible:['email']}],[{value:'ALT',ratio:1.5,keyCode:KeyEvent.DOM_VK_ALT},{value:'!'},{value:'\"'},{value:"'"},{value:':'},{value:';'},{value:'/'},{value:'?'},{value:'⌫',ratio:1.5,keyCode:KeyEvent.DOM_VK_BACK_SPACE}],[{value:'&nbsp',ratio:8,keyCode:KeyboardEvent.DOM_VK_SPACE},{value:'↵',ratio:2,keyCode:KeyEvent.DOM_VK_RETURN}]]},symbolLayout:{keys:[[{value:'`'},{value:'~'},{value:'_'},{value:'^'},{value:'±'},{value:'|'},{value:'['},{value:']'},{value:'{'},{value:'}'}],[{value:'°'},{value:'²'},{value:'³'},{value:'©'},{value:'®'},{value:'§'},{value:'<'},{value:'>'},{value:'«'},{value:'»'}],[{value:'ALT',ratio:1.5,keyCode:KeyEvent.DOM_VK_ALT},{value:'¥'},{value:'€'},{value:'£'},{value:'$'},{value:'¢'},{value:'\\'},{value:'='},{value:'⌫',ratio:1.5,keyCode:KeyEvent.DOM_VK_BACK_SPACE}],[{value:'&nbsp',ratio:8,keyCode:KeyboardEvent.DOM_VK_SPACE},{value:'↵',ratio:2,keyCode:KeyEvent.DOM_VK_RETURN}]]},numberLayout:{width:9,keyClassName:'big-key special-key',keys:[[{value:'1',ratio:3},{value:'2',ratio:3},{value:'3',ratio:3}],[{value:'4',ratio:3},{value:'5',ratio:3},{value:'6',ratio:3}],[{value:'7',ratio:3},{value:'8',ratio:3},{value:'9',ratio:3}],[{value:'.',ratio:3,altNote:','},{value:'0',ratio:3,altNote:'-'},{value:'⌫',ratio:3,keyCode:KeyEvent.DOM_VK_BACK_SPACE}]],alt:{'.':',','0':'-'}},pinLayout:{width:9,keyClassName:'big-key special-key',keys:[[{value:'1',ratio:3},{value:'2',ratio:3},{value:'3',ratio:3}],[{value:'4',ratio:3},{value:'5',ratio:3},{value:'6',ratio:3}],[{value:'7',ratio:3},{value:'8',ratio:3},{value:'9',ratio:3}],[{value:'',ratio:3},{value:'0',ratio:3},{value:'⌫',ratio:3,keyCode:KeyEvent.DOM_VK_BACK_SPACE}]]},telLayout:{width:9,keyClassName:'big-key special-key',keys:[[{value:'1',ratio:3},{value:'2',ratio:3},{value:'3',ratio:3}],[{value:'4',ratio:3},{value:'5',ratio:3},{value:'6',ratio:3}],[{value:'7',ratio:3,altNote:'#'},{value:'8',ratio:3,altNote:'-'},{value:'9',ratio:3,altNote:'*'}],[{value:'(',ratio:3,altNote:')'},{value:'0',ratio:3,altNote:'+'},{value:'⌫',ratio:3,keyCode:KeyEvent.DOM_VK_BACK_SPACE}]],alt:{'7':'#','8':'-','9':'*','(':')','0':'+'}}};;'use strict';const IMERender=(function(){var ime,activeIme,menu;var getUpperCaseValue,isSpecialKey;var _menuKey,_altContainer;var layoutWidth=10;var numberOfCandidatesPerRow=8;var candidateUnitWidth;var inputMethodName;var cachedWindowHeight=-1;var cachedWindowWidth=-1;window.addEventListener('resize',function kr_onresize(){cachedWindowHeight=window.innerHeight;cachedWindowWidth=window.innerWidth;});var init=function kr_init(uppercaseFunction,keyTest){getUpperCaseValue=uppercaseFunction;isSpecialKey=keyTest;ime=document.getElementById('keyboard');menu=document.getElementById('keyboard-accent-char-menu');cachedWindowHeight=window.innerHeight;cachedWindowWidth=window.innerWidth;};var setInputMethodName=function(name){var candidatePanel=activeIme&&activeIme.querySelector('.keyboard-candidate-panel');if(candidatePanel){if(inputMethodName)
candidatePanel.classList.remove(inputMethodName);candidatePanel.classList.add(name);}
var togglebutton=activeIme&&activeIme.querySelector('.keyboard-candidate-panel-toggle-button');if(togglebutton){if(inputMethodName)
togglebutton.classList.remove(inputMethodName);togglebutton.classList.add(name);}
inputMethodName=name;};var setUpperCaseLock=function kr_setUpperCaseLock(state){var capsLockKey=activeIme.querySelector('button[data-keycode="'+KeyboardEvent.DOM_VK_CAPS_LOCK+'"]');if(!capsLockKey)
return;if(state==='locked'){capsLockKey.classList.remove('kbr-key-active');capsLockKey.classList.add('kbr-key-hold');}else if(state){capsLockKey.classList.add('kbr-key-active');capsLockKey.classList.remove('kbr-key-hold');}else{capsLockKey.classList.remove('kbr-key-active');capsLockKey.classList.remove('kbr-key-hold');}};var draw=function kr_draw(layout,flags,callback){flags=flags||{};var supportsSwitching='mozInputMethod'in navigator?navigator.mozInputMethod.mgmt.supportsSwitching():false;var keyboardClass=[layout.keyboardName,layout.altLayoutName,(''+flags.inputType).substr(0,1),(''+flags.showCandidatePanel).substr(0,1),(''+flags.uppercase).substr(0,1),supportsSwitching].join('-');var container=document.getElementsByClassName(keyboardClass)[0];if(!container){container=document.createElement('div');container.classList.add('keyboard-type-container');container.classList.add(keyboardClass);if(layout.specificCssRule){container.classList.add(layout.keyboardName);}
buildKeyboard(container,flags,layout);ime.appendChild(container);}
if(activeIme!==container){if(activeIme){activeIme.style.display='none';delete activeIme.dataset.active;}
container.style.display='block';container.dataset.active=true;activeIme=container;resizeUI(layout,callback);}
else if((ime.classList.contains('landscape')&&screenInPortraitMode())||(ime.classList.contains('portrait')&&!screenInPortraitMode())){resizeUI(layout,callback);}
else{if(callback){requestAnimationFrame(callback);}}};var buildKeyboard=function kr_build(container,flags,layout){flags=flags||{};layoutWidth=layout.width||10;var totalWidth=ime.clientWidth;var placeHolderWidth=totalWidth/layoutWidth;layout.upperCase=layout.upperCase||{};var content=document.createDocumentFragment();layout.keys.forEach((function buildKeyboardRow(row,nrow){var kbRow=document.createElement('div');var rowLayoutWidth=0;kbRow.classList.add('keyboard-row');kbRow.classList.add('row'+nrow);if(nrow===layout.keys.length-1){kbRow.classList.add('keyboard-last-row');}
row.forEach((function buildKeyboardColumns(key,ncolumn){var keyChar=key.value;if(key.hidden&&key.hidden.indexOf(flags.inputType)!==-1)
return;if(key.visible&&key.visible.indexOf(flags.inputType)===-1)
return;var upperCaseKeyChar=getUpperCaseValue(key);var code=key.keyCode||keyChar.charCodeAt(0);var upperCode=key.keyCode||getUpperCaseValue(key).charCodeAt(0);var className='';if(isSpecialKey(key)){className='special-key';}else if(layout.keyClassName){className=layout.keyClassName;}
if(key.className){className+=' '+key.className;}
var ratio=key.ratio||1;rowLayoutWidth+=ratio;var keyWidth=placeHolderWidth*ratio;var dataset=[{'key':'row','value':nrow}];dataset.push({'key':'column','value':ncolumn});dataset.push({'key':'keycode','value':code});dataset.push({'key':'keycodeUpper','value':upperCode});if(key.compositeKey){dataset.push({'key':'compositekey','value':key.compositeKey});}
var attributeList=[];if(key.disabled){attributeList.push({key:'disabled',value:'true'});}
var outputChar=flags.uppercase?upperCaseKeyChar:keyChar;kbRow.appendChild(buildKey(outputChar,className,keyWidth+'px',dataset,key.altNote,attributeList));}));kbRow.dataset.layoutWidth=rowLayoutWidth;content.appendChild(kbRow);}));container.innerHTML='';container.appendChild(content);if(flags.showCandidatePanel){container.insertBefore(candidatePanelToggleButtonCode(),container.firstChild);container.insertBefore(candidatePanelCode(),container.firstChild);container.insertBefore(pendingSymbolPanelCode(),container.firstChild);showPendingSymbols('');showCandidates([],true);container.classList.add('candidate-panel');}else{container.classList.remove('candidate-panel');}};var showIME=function hm_showIME(){delete ime.dataset.hidden;};var hideIME=function km_hideIME(){ime.dataset.hidden='true';};var highlightKey=function kr_updateKeyHighlight(key,alternativeKey){key.classList.add('highlighted');if(alternativeKey){var spanToReplace=key.querySelector('.visual-wrapper span');spanToReplace.textContent=alternativeKey;}};var unHighlightKey=function kr_unHighlightKey(key){key.classList.remove('highlighted');};var showPendingSymbols=function km_showPendingSymbols(symbols,highlightStart,highlightEnd,highlightState){if(!activeIme)
return;var HIGHLIGHT_COLOR_TABLE={'red':'keyboard-pending-symbols-highlight-red','green':'keyboard-pending-symbols-highlight-green','blue':'keyboard-pending-symbols-highlight-blue'};var pendingSymbolPanel=activeIme.querySelector('.keyboard-pending-symbol-panel');if(pendingSymbolPanel){if(typeof highlightStart==='undefined'||typeof highlightEnd==='undefined'||typeof highlightState==='undefined'){pendingSymbolPanel.textContent=symbols;return;}
var span=document.createElement('span');span.className=HIGHLIGHT_COLOR_TABLE[highlightState];span.textContent=symbols.slice(highlightStart,highlightEnd);pendingSymbolPanel.innerHTML='';pendingSymbolPanel.appendChild(span);pendingSymbolPanel.appendChild(document.createTextNode(symbols.substr(highlightEnd)));}};var toggleCandidatePanel=function(expand){var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');candidatePanel.scrollTop=candidatePanel.scrollLeft=0;if(expand){ime.classList.remove('candidate-panel');ime.classList.add('full-candidate-panel');}else{ime.classList.remove('full-candidate-panel');ime.classList.add('candidate-panel');}};var isFullCandidataPanelShown=function(){return ime.classList.contains('full-candidate-panel');};var showCandidates=function(candidates,noWindowHeightUpdate){if(!activeIme)
return;var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');var candidatePanelToggleButton=activeIme.querySelector('.keyboard-candidate-panel-toggle-button');if(candidatePanel){candidatePanel.dataset.candidateIndicator=0;var docFragment=document.createDocumentFragment();if(inputMethodName=='latin'){var dismissButton=candidatePanel.querySelector('.dismiss-suggestions-button');dismissButton.classList.add('hide');if(candidates.length>0){dismissButton.classList.remove('hide');}
var suggestContainer=candidatePanel.querySelector('.suggestions-container');suggestContainer.innerHTML='';for(var i=0;i<4;i++){suggestContainer.classList.remove('has'+i);}
suggestContainer.classList.add('has'+candidates.length);candidates.forEach(function buildCandidateEntry(candidate){if(!candidate)return;var div=document.createElement('div');suggestContainer.appendChild(div);var text,data,correction=false;if(typeof candidate==='string'){if(candidate[0]==='*'){candidate=candidate.substring(1);correction=true;}
data=text=candidate;}
else{text=candidate[0];data=candidate[1];}
var span=fitText(div,text);span.dataset.selection=true;span.dataset.data=data;if(correction)
span.classList.add('autocorrect');function fitText(container,text){container.textContent='';if(!text)
return null;var span=document.createElement('span');span.textContent=text;container.appendChild(span);var limit=.6;var scale=IMERender.getScale(span,candidates.length);if(scale<limit){var charactersReplaced=text.length%2;while(scale<limit&&charactersReplaced<text.length-2){charactersReplaced+=2;var halflen=(text.length-charactersReplaced)/2;span.textContent=text.substring(0,halflen)+'…'+
text.substring(text.length-halflen);scale=IMERender.getScale(span,candidates.length);}}
span.style.display='inline-block';if(scale<1){span.style.width=(100/scale)+'%';span.style.transformOrigin='left';span.style.transform='scale('+scale+')';}
else{span.style.width='100%';}
return span;}});}else{candidatePanel.innerHTML='';candidatePanelToggleButton.style.display='none';toggleCandidatePanel(false);docFragment=candidatesFragmentCode(1,candidates,true);candidatePanel.appendChild(docFragment);}}};var showMoreCandidates=function(rowLimit,candidates){if(!rowLimit)rowLimit=-1;if(!candidates)return;activeIme.querySelector('.keyboard-candidate-panel').appendChild(candidatesFragmentCode(rowLimit,candidates));};var getNumberOfCandidatesPerRow=function(){return numberOfCandidatesPerRow;};var candidatesFragmentCode=function(rowLimit,candidates,indentFirstRow){var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');var candidatePanelToggleButton=activeIme.querySelector('.keyboard-candidate-panel-toggle-button');var docFragment=document.createDocumentFragment();if(candidates.length==0){candidatePanel.dataset.rowCount=0;return docFragment;}
var rowDiv=document.createElement('div');rowDiv.classList.add('candidate-row');if(indentFirstRow){rowDiv.classList.add('candidate-row-first');}
var nowUnit=0;var rowCount=0;if(rowLimit<0){rowLimit=Number.Infinity;}
var candidatesLength=candidates.length;for(var i=0;i<candidatesLength;i++){var cand=candidates[i][0];var data=candidates[i][1];var span=document.createElement('span');var unit=(cand.length>>1)+1;span.textContent=cand;span.dataset.selection=true;span.dataset.data=data;span.style.width=(unit*candidateUnitWidth-2)+'px';nowUnit+=unit;var needBreak=false;if(rowCount==0&&indentFirstRow&&nowUnit==numberOfCandidatesPerRow&&i!=candidatesLength-1){needBreak=true;}
if(nowUnit>numberOfCandidatesPerRow||needBreak){if(rowCount==0){candidatePanelToggleButton.style.display='block';}
if(rowCount>=rowLimit-1){break;}
docFragment.appendChild(rowDiv);rowCount++;rowDiv=document.createElement('div');rowDiv.classList.add('candidate-row');nowUnit=unit;}
rowDiv.appendChild(span);}
if(i!=candidatesLength){candidatePanel.dataset.truncated=true;}else{delete candidatePanel.dataset.truncated;}
candidatePanel.dataset.rowCount=rowCount+1;candidatePanel.dataset.candidateIndicator=parseInt(candidatePanel.dataset.candidateIndicator)+i;docFragment.appendChild(rowDiv);rowDiv=null;return docFragment;};var showAlternativesCharMenu=function(key,altChars){var content=document.createDocumentFragment();var left=(cachedWindowWidth/2>key.offsetLeft);if(!left){menu.classList.add('kbr-menu-left');altChars=altChars.reverse();}
var keycharwidth=key.dataset.compositeKey?key.dataset.compositeKey.length:1;altChars.forEach(function(alt,index){var dataset=alt.length==1?[{'key':'keycode','value':alt.charCodeAt(0)},{'key':'keycodeUpper','value':alt.toUpperCase().charCodeAt(0)}]:[{'key':'compositekey','value':alt}];var width=0.75*key.offsetWidth/keycharwidth*alt.length;content.appendChild(buildKey(alt,'',width+'px',dataset));});menu.innerHTML='';menu.appendChild(content);_altContainer=document.createElement('div');_altContainer.style.display='inline-block';_altContainer.style.width=key.style.width;_altContainer.innerHTML=key.innerHTML;_altContainer.className=key.className;_altContainer.classList.add('kbr-menu-on');_menuKey=key;key.parentNode.replaceChild(_altContainer,key);_altContainer.querySelectorAll('.visual-wrapper > span')[0].appendChild(menu);menu.style.display='block';var alternativesLeft=getWindowLeft(menu);var alternativesRight=alternativesLeft+menu.offsetWidth;var offset;if(alternativesLeft<0||alternativesRight>cachedWindowWidth){if(left){offset=parseInt(getComputedStyle(menu).left);if(alternativesLeft<0){offset+=-alternativesLeft;}
else if(alternativesRight>cachedWindowWidth){offset-=(alternativesRight-cachedWindowWidth);}
menu.style.left=offset+'px';}
else{offset=parseInt(getComputedStyle(menu).right);if(alternativesRight>cachedWindowWidth){offset+=(alternativesRight-cachedWindowWidth);}
else if(alternativesLeft<0){offset+=alternativesLeft;}
menu.style.right=offset+'px';}}};var hideAlternativesCharMenu=function km_hideAlternativesCharMenu(){menu.style.display='none';menu.className='';menu.innerHTML='';if(_altContainer){_altContainer.parentNode.replaceChild(_menuKey,_altContainer);}
menu.style.left='';menu.style.right='';};var _keyArray=[];var resizeUI=function(layout,callback){var RESIZE_UI_TIMEOUT=0;function setKeyWidth(){var ratio,keys;for(var r=0,row;row=rows[r];r+=1){keys=row.childNodes;for(var k=0,key;key=keys[k];k+=1){ratio=layout.keys[r][k].ratio||1;key.style.width=Math.floor(placeHolderWidth*ratio)+'px';}}
setTimeout(firstAndLastKeyLarger,RESIZE_UI_TIMEOUT);}
function firstAndLastKeyLarger(){for(var r=0,row=rows[r];r<rows.length;row=rows[++r]){var rowLayoutWidth=parseInt(row.dataset.layoutWidth,10);if(rowLayoutWidth===layoutWidth){continue;}
var allKeys=row.childNodes;var keys=[allKeys[0],allKeys[allKeys.length-1]];for(var k=0,key=keys[k];k<keys.length;key=keys[++k]){var visualKey=key.querySelector('.visual-wrapper');var ratio=layout.keys[r][k].ratio||1;visualKey.style.width=visualKey.offsetWidth+'px';var newRatio=ratio+((layoutWidth-rowLayoutWidth)/2);key.style.width=Math.floor(placeHolderWidth*newRatio)+'px';key.classList.add('float-key-'+(k===0?'first':'last'));}}
setTimeout(getVisualData,RESIZE_UI_TIMEOUT);}
function getVisualData(){for(var r=0,row;row=rows[r];r++){for(var k=0,key;key=row.childNodes[k];k++){var visualKey=key.querySelector('.visual-wrapper');_keyArray.push({code:key.dataset.keycode|0,x:visualKey.offsetLeft,y:visualKey.offsetTop,width:visualKey.clientWidth,height:visualKey.clientHeight});}}
candidateUnitWidth=Math.floor(ime.clientWidth/numberOfCandidatesPerRow);[].forEach.call(ime.querySelectorAll('.candidate-row span'),function(item){var unit=(item.textContent.length>>1)+1;item.style.width=(unit*candidateUnitWidth-2)+'px';});if(callback){callback();}}
var changeScale;if(screenInPortraitMode()){changeScale=cachedWindowWidth/32;document.documentElement.style.fontSize=changeScale+'px';ime.classList.remove('landscape');ime.classList.add('portrait');}else{changeScale=cachedWindowWidth/64;document.documentElement.style.fontSize=changeScale+'px';ime.classList.remove('portrait');ime.classList.add('landscape');}
_keyArray=[];if(!layout||!activeIme){return;}
[].forEach.call(ime.querySelectorAll('.visual-wrapper[style]'),function(item){item.style.width='';});layoutWidth=layout.width||10;var totalWidth=cachedWindowWidth;var placeHolderWidth=totalWidth/layoutWidth;var rows=activeIme.querySelectorAll('.keyboard-row');setKeyWidth();};var pendingSymbolPanelCode=function(){var pendingSymbolPanel=document.createElement('div');pendingSymbolPanel.classList.add('keyboard-pending-symbol-panel');return pendingSymbolPanel;};var candidatePanelCode=function(){var candidatePanel=document.createElement('div');candidatePanel.classList.add('keyboard-candidate-panel');if(inputMethodName)
candidatePanel.classList.add(inputMethodName);var dismissButton=document.createElement('div');dismissButton.classList.add('dismiss-suggestions-button');dismissButton.classList.add('hide');candidatePanel.appendChild(dismissButton);var suggestionContainer=document.createElement('div');suggestionContainer.classList.add('suggestions-container');candidatePanel.appendChild(suggestionContainer);return candidatePanel;};var candidatePanelToggleButtonCode=function(){var toggleButton=document.createElement('span');toggleButton.classList.add('keyboard-candidate-panel-toggle-button');toggleButton.dataset.keycode=-4;if(inputMethodName){toggleButton.classList.add(inputMethodName);}
toggleButton.style.width=Math.floor(ime.clientWidth/numberOfCandidatesPerRow)+'px';return toggleButton;};var buildKey=function buildKey(label,className,width,dataset,altNote,attributeList){var altNoteNode;if(altNote){altNoteNode=document.createElement('div');altNoteNode.className='alt-note';altNoteNode.textContent=altNote;}
var contentNode=document.createElement('button');contentNode.className='keyboard-key '+className;contentNode.setAttribute('style','width: '+width+';');if(attributeList){attributeList.forEach(function(attribute){contentNode.setAttribute(attribute.key,attribute.value);});}
dataset.forEach(function(data){contentNode.dataset[data.key]=data.value;});if(contentNode.dataset.keycode!=KeyboardEvent.DOM_VK_RETURN&&contentNode.dataset.keycode!=KeyboardEvent.DOM_VK_BACK_SPACE){contentNode.setAttribute('role','key');}
var vWrapperNode=document.createElement('span');vWrapperNode.className='visual-wrapper';var labelNode=document.createElement('span');labelNode.innerHTML=label;labelNode.dataset.label=label;vWrapperNode.appendChild(labelNode);if(altNoteNode){vWrapperNode.appendChild(altNoteNode);}
contentNode.appendChild(vWrapperNode);return contentNode;};var getWidth=function getWidth(){if(!activeIme)
return 0;return cachedWindowWidth;};var getHeight=function getHeight(){if(!activeIme)
return 0;var scale=screenInPortraitMode()?cachedWindowWidth/32:cachedWindowWidth/64;var height=(activeIme.querySelectorAll('.keyboard-row').length*(5.1*scale));if(activeIme.classList.contains('candidate-panel')){if(activeIme.querySelector('.keyboard-candidate-panel').classList.contains('latin')){height+=(3.1*scale);}
else{height+=(3.2*scale);}}
return height|0;};var getKeyArray=function getKeyArray(){return _keyArray;};var getKeyWidth=function getKeyWidth(){if(!activeIme)
return 0;return Math.ceil(ime.clientWidth/layoutWidth);};var getKeyHeight=function getKeyHeight(){if(!activeIme)
return 0;var rows=activeIme.querySelectorAll('.keyboard-row');var rowCount=rows.length||3;var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');var candidatePanelHeight=candidatePanel?candidatePanel.clientHeight:0;return Math.ceil((ime.clientHeight-candidatePanelHeight)/rowCount);};var scaleContext=null;var getScale=function(element,noOfSuggestions){if(!scaleContext){scaleContext=document.createElement('canvas').getContext('2d');scaleContext.font='2rem sans-serif';}
var elementWidth=scaleContext.measureText(element.textContent).width;var cw=(cachedWindowWidth-36)/noOfSuggestions|0;cw-=6;var s=cw/elementWidth;if(s>=1)
return 1;if(s>=.8)
return.8;if(s>=.7)
return.7;if(s>=.65)
return.65;if(s>=.6)
return.6;return s;};var screenInPortraitMode=function(){return cachedWindowWidth<=cachedWindowHeight;};var _t={};function startTime(key){}
function endTime(key){}
return{'init':init,'setInputMethodName':setInputMethodName,'draw':draw,get ime(){return ime;},get menu(){return menu;},'hideIME':hideIME,'showIME':showIME,'highlightKey':highlightKey,'unHighlightKey':unHighlightKey,'showAlternativesCharMenu':showAlternativesCharMenu,'hideAlternativesCharMenu':hideAlternativesCharMenu,'setUpperCaseLock':setUpperCaseLock,'resizeUI':resizeUI,'showCandidates':showCandidates,'showPendingSymbols':showPendingSymbols,'getWidth':getWidth,'getHeight':getHeight,'getKeyArray':getKeyArray,'getKeyWidth':getKeyWidth,'getKeyHeight':getKeyHeight,'getScale':getScale,'showMoreCandidates':showMoreCandidates,'toggleCandidatePanel':toggleCandidatePanel,'isFullCandidataPanelShown':isFullCandidataPanelShown,'getNumberOfCandidatesPerRow':getNumberOfCandidatesPerRow,'candidatePanelCode':candidatePanelCode,get activeIme(){return activeIme;},set activeIme(v){activeIme=v;},get candidatePanel(){return activeIme&&activeIme.querySelector('.keyboard-candidate-panel');},setCachedWindowSize:function(width,height){cachedWindowWidth=width;cachedWindowHeight=height;}};})();;'use strict';const InputMethods={};const defaultInputMethod={click:sendKey,displaysCandidates:function(){return false;}};var inputContext=null;var keyboardName=null;var inputMethod=defaultInputMethod;const LAYOUT_PAGE_DEFAULT='Default';const LAYOUT_PAGE_SYMBOLS_I='Symbols_1';const LAYOUT_PAGE_SYMBOLS_II='Symbols_2';var layoutPage=LAYOUT_PAGE_DEFAULT;var currentLayout=null;var isWaitingForSecondTap=false;var isShowingAlternativesMenu=false;var isShowingKeyboardLayoutMenu=false;var isContinousSpacePressed=false;var isUpperCase=false;var isUpperCaseLocked=false;var currentKey=null;var touchEventsPresent=false;var touchedKeys={};var touchCount=0;var currentInputType=null;var currentInputMode=null;var menuLockedArea=null;var isKeyboardRendered=false;var currentCandidates=[];var candidatePanelScrollTimer=null;var cachedIMEDimensions={height:0,width:0};const ACCENT_CHAR_MENU_TIMEOUT=700;const REPEAT_RATE=75;const REPEAT_TIMEOUT=700;const FOCUS_CHANGE_DELAY=100;const CAPS_LOCK_TIMEOUT=450;const HIDE_KEYBOARD_TIMEOUT=500;var deleteTimeout=0;var deleteInterval=0;var menuTimeout=0;var redrawTimeout=0;var hideKeyboardTimeout=0;const BASIC_LAYOUT=-1;const ALTERNATE_LAYOUT=-2;const SWITCH_KEYBOARD=-3;const TOGGLE_CANDIDATE_PANEL=-4;const NO_OP=-5;const specialCodes=[KeyEvent.DOM_VK_BACK_SPACE,KeyEvent.DOM_VK_CAPS_LOCK,KeyEvent.DOM_VK_RETURN,KeyEvent.DOM_VK_ALT,KeyEvent.DOM_VK_SPACE];var suggestionsEnabled;var correctionsEnabled;var clickEnabled;var vibrationEnabled;var isSoundEnabled;const CLICK_SOUND='./resources/sounds/key.ogg';const SPECIAL_SOUND='./resources/sounds/special.ogg';var clicker;var specialClicker;var dimensionsObserver;var eventHandlers={'touchstart':onTouchStart,'mousedown':onMouseDown,'mouseup':onMouseUp,'mousemove':onMouseMove};var touchStartCoordinate;var toShowKeyboardFTU=false;const SWIPE_VELOCICTY_THRESHOLD=0.4;var settingsQuery={'keyboard.wordsuggestion':true,'keyboard.autocorrect':true,'keyboard.vibration':false,'keyboard.clicksound':false,'keyboard.ftu.enabled':false,'audio.volume.notification':7};getSettings(settingsQuery,function gotSettings(values){suggestionsEnabled=values['keyboard.wordsuggestion'];correctionsEnabled=values['keyboard.autocorrect'];vibrationEnabled=values['keyboard.vibration'];clickEnabled=values['keyboard.clicksound'];isSoundEnabled=!!values['audio.volume.notification'];toShowKeyboardFTU=values['keyboard.ftu.enabled'];handleKeyboardSound();initKeyboard();});function initKeyboard(){navigator.mozSettings.addObserver('keyboard.wordsuggestion',function(e){suggestionsEnabled=e.settingValue;});navigator.mozSettings.addObserver('keyboard.autocorrect',function(e){correctionsEnabled=e.settingValue;});navigator.mozSettings.addObserver('keyboard.vibration',function(e){vibrationEnabled=e.settingValue;});navigator.mozSettings.addObserver('audio.volume.notification',function(e){isSoundEnabled=!!e.settingValue;handleKeyboardSound();});navigator.mozSettings.addObserver('keyboard.clicksound',function(e){clickEnabled=e.settingValue;handleKeyboardSound();});navigator.mozSettings.addObserver('keyboard.ftu.enabled',function(e){toShowKeyboardFTU=e.settingValue;});IMERender.init(getUpperCaseValue,isSpecialKeyObj);for(var event in eventHandlers){IMERender.ime.addEventListener(event,eventHandlers[event]);}
var tipWindow=document.getElementById('confirm-dialog');function tipFocusHandler(evt){evt.preventDefault();}
tipWindow.addEventListener('mousedown',tipFocusHandler);var tipButton=document.getElementById('ftu-ok');tipButton.addEventListener('click',function(evt){evt.preventDefault();tipWindow.hidden=true;});tipButton.addEventListener('mousedown',function mouseDownHandler(evt){tipButton.classList.add('active');});var inActiveHandlers=['mouseup','mouseleave'];inActiveHandlers.forEach(function addInActiveHandler(evtName){tipButton.addEventListener(evtName,function inActiveHandler(evt){tipButton.classList.remove('active');});});dimensionsObserver=new MutationObserver(function(){updateTargetWindowHeight();});dimensionsObserver.observe(IMERender.ime,{childList:true,attributes:true,attributeFilter:['class','style','data-hidden']});window.addEventListener('hashchange',function(){var inputMethodName=window.location.hash.substring(1);setKeyboardName(inputMethodName,function(){resetKeyboard();showKeyboard();});},false);window.addEventListener('resize',onResize);window.addEventListener('mozvisibilitychange',function visibilityHandler(){var inputMethodName=window.location.hash.substring(1);setKeyboardName(inputMethodName,function(){if(!document.mozHidden&&inputContext){showKeyboard();}else{hideKeyboard();}});});window.navigator.mozInputMethod.oninputcontextchange=function(){inputContext=navigator.mozInputMethod.inputcontext;if(!document.mozHidden&&inputContext){showKeyboard();}else{hideKeyboard();}};var inputMethodName='';if(window.location.hash!==''){inputMethodName=window.location.hash.substring(1);}else{console.error('This page should never be loaded without an URL hash.');}
inputContext=navigator.mozInputMethod.inputcontext;if(!document.mozHidden&&inputContext){setKeyboardName(inputMethodName,showKeyboard);}else{setKeyboardName(inputMethodName);}}
function handleKeyboardSound(){if(clickEnabled&&isSoundEnabled){clicker=new Audio(CLICK_SOUND);specialClicker=new Audio(SPECIAL_SOUND);}else{clicker=null;specialClicker=null;}}
function deactivateInputMethod(){if(inputMethod.deactivate){inputMethod.deactivate();}}
function setKeyboardName(name,callback){var keyboard;loadLayout(name,function(layout){if(layout.imEngine){loadIMEngine(name,function(){setInputMethod(InputMethods[layout.imEngine]);});}else{setInputMethod(defaultInputMethod);}
function setInputMethod(im){if(im!==inputMethod&&inputMethod&&inputMethod.deactivate)
inputMethod.deactivate();inputMethod=im;if(callback)
callback();}});function loadLayout(name,callback){if(name in Keyboards){setLayout(name);}else{var layoutFile='js/layouts/'+name+'.js';var script=document.createElement('script');script.src=layoutFile;script.onload=function(){setLayout(name);};script.onerror=function(){console.error('Cannot load keyboard layout',layoutFile);};document.head.appendChild(script);}
function setLayout(name){keyboardName=name;keyboard=Keyboards[name];callback(keyboard);}}}
function isSpecialKeyObj(key){var hasSpecialCode=key.keyCode!==KeyEvent.DOM_VK_SPACE&&key.keyCode&&specialCodes.indexOf(key.keyCode)!==-1;return hasSpecialCode||key.keyCode<=0;}
function mapInputType(type){switch(type){case'url':case'tel':case'email':case'text':return type;break;case'password':case'search':default:return'text';break;case'number':case'range':return'number';break;}}
function modifyLayout(keyboardName){function copy(obj){var newObj={};for(var prop in obj)if(obj.hasOwnProperty(prop)){newObj[prop]=obj[prop];}
return newObj;}
var altLayoutName;switch(currentInputType){case'tel':altLayoutName='telLayout';break;case'number':altLayoutName=currentInputMode==='digit'?'pinLayout':'numberLayout';break;case'text':if(currentInputMode==='digit'){altLayoutName='pinLayout';}else if(currentInputMode==='numeric'){altLayoutName='numberLayout';}else if(isGreekSMS()){altLayoutName='el-sms';}
break;}
if(layoutPage===LAYOUT_PAGE_SYMBOLS_I){altLayoutName='alternateLayout';}else if(layoutPage===LAYOUT_PAGE_SYMBOLS_II){altLayoutName='symbolLayout';}
var layout;if(altLayoutName){layout=Keyboards[keyboardName][altLayoutName]||Keyboards[altLayoutName];}
else{layout=Keyboards[keyboardName];}
var where=false;for(var r=0,row;!where&&(row=layout.keys[r]);r+=1){for(var c=0,space;space=layout.keys[r][c];c+=1){if(space.keyCode==KeyboardEvent.DOM_VK_SPACE){where=r;break;}}}
if(where){layout=copy(layout);layout.keys=layout.keys.slice(0);row=layout.keys[where]=layout.keys[where].slice(0);space=copy(space);row[c]=space;var alternateLayoutKey='?123';if(layout['alternateLayoutKey']){alternateLayoutKey=layout['alternateLayoutKey'];}
var basicLayoutKey='ABC';if(Keyboards[keyboardName]['basicLayoutKey']){basicLayoutKey=Keyboards[keyboardName]['basicLayoutKey'];}
if(!layout['disableAlternateLayout']){space.ratio-=1.5;if(layoutPage===LAYOUT_PAGE_DEFAULT){row.splice(c,0,{keyCode:ALTERNATE_LAYOUT,value:alternateLayoutKey,ratio:1.5});}else{row.splice(c,0,{keyCode:BASIC_LAYOUT,value:basicLayoutKey,ratio:1.5});}
c+=1;}
var supportsSwitching=navigator.mozInputMethod.mgmt.supportsSwitching();if(!layout['hidesSwitchKey']&&supportsSwitching){space.ratio-=1.5;row.splice(c,0,{value:'&#x1f310;',ratio:1.5,keyCode:SWITCH_KEYBOARD});c+=1;}
if(!layout['typeInsensitive']){switch(currentInputType){case'url':space.ratio-=5;row.splice(c,1,{value:'.',ratio:1,keyCode:46},{value:'/',ratio:2,keyCode:47},{value:'.com',ratio:2+space.ratio,compositeKey:'.com'});break;case'email':space.ratio-=2;row.splice(c,0,{value:'@',ratio:1,keyCode:64});row.splice(c+2,0,{value:'.',ratio:1,keyCode:46});break;case'text':var overwrites=layout.textLayoutOverwrite||{};var next=c;if(overwrites['.']!==false){space.ratio-=1;next++;}
if(layoutPage!==LAYOUT_PAGE_DEFAULT){if(overwrites[',']!==false){space.ratio-=1;next++;}
var commaKey={value:',',keyCode:44,ratio:1};if(overwrites[',']){commaKey.value=overwrites[','];commaKey.keyCode=overwrites[','].charCodeAt(0);row.splice(c,0,commaKey);}else if(overwrites[',']!==false){row.splice(c,0,commaKey);}}
if(overwrites['.']){row.splice(next,0,{value:overwrites['.'],ratio:1,keyCode:overwrites['.'].charCodeAt(0)});}else if(overwrites['.']!==false){row.splice(next,0,{value:'.',ratio:1,keyCode:46});}
break;}}}else{console.warn('No space key found. No special keys will be added.');}
layout.keyboardName=keyboardName;layout.altLayoutName=altLayoutName;return layout;}
var _t={};function startTime(key){}
function endTime(key){}
function renderKeyboard(keyboardName,callback){startTime('BLOCKING (main) renderKeyboard');currentLayout=modifyLayout(keyboardName);function drawKeyboard(){var keyboard=Keyboards[keyboardName];IMERender.ime.classList.remove('full-candidate-panel');var needsUpperCase=currentLayout.secondLayout?(isUpperCaseLocked||isUpperCase):true;IMERender.draw(currentLayout,{uppercase:needsUpperCase,inputType:currentInputType,showCandidatePanel:needsCandidatePanel()},function(){startTime('BLOCKING (nextTick) renderKeyboard');IMERender.setUpperCaseLock(isUpperCaseLocked?'locked':isUpperCase);updateLayoutParams();IMERender.showCandidates(currentCandidates);endTime('BLOCKING (nextTick) renderKeyboard');});IMERender.setInputMethodName(keyboard.imEngine||'default');if(inputMethod.empty)
inputMethod.empty();isKeyboardRendered=true;endTime('BLOCKING (main) renderKeyboard');if(callback){callback();}}
clearTimeout(redrawTimeout);drawKeyboard();}
function setUpperCase(upperCase,upperCaseLocked){upperCaseLocked=(typeof upperCaseLocked=='undefined')?isUpperCaseLocked:upperCaseLocked;if(isUpperCase==upperCase&&isUpperCaseLocked==upperCaseLocked)
return;isUpperCaseLocked=upperCaseLocked;isUpperCase=upperCase;if(!isKeyboardRendered)
return;if(currentLayout.secondLayout){return renderKeyboard(keyboardName);}
requestAnimationFrame(function(){startTime('BLOCKING (nextTick) updateUpperCaseUI');IMERender.setUpperCaseLock(isUpperCaseLocked?'locked':isUpperCase);IMERender.showCandidates(currentCandidates);endTime('BLOCKING (nextTick) updateUpperCaseUI');});}
function resetUpperCase(){if(isUpperCase&&!isUpperCaseLocked&&layoutPage===LAYOUT_PAGE_DEFAULT){setUpperCase(false);}}
function isCapitalized(){return(isUpperCase||isUpperCaseLocked);}
function setLayoutPage(newpage){if(newpage===layoutPage)
return;layoutPage=newpage;renderKeyboard(keyboardName);if(inputMethod.setLayoutPage)
inputMethod.setLayoutPage(layoutPage);}
function updateTargetWindowHeight(hide){var imeHeight=cachedIMEDimensions.height=IMERender.getHeight()+1;var imeWidth=cachedIMEDimensions.width=IMERender.getWidth();window.resizeTo(imeWidth,imeHeight);}
function sendDelete(isRepeat){inputMethod.click(KeyboardEvent.DOM_VK_BACK_SPACE,null,isRepeat);}
function getUpperCaseValue(key){var hasSpecialCode=specialCodes.indexOf(key.keyCode)>-1;if(key.keyCode<0||hasSpecialCode||key.compositeKey)
return key.value;var upperCase=currentLayout.upperCase||{};return upperCase[key.value]||key.value.toUpperCase();}
function setMenuTimeout(target,coords,touchId){if(touchCount>1)
return;menuTimeout=window.setTimeout(function menuTimeout(){if(isShowingAlternativesMenu||touchCount>1)
return;if(currentInputType==='number'||currentInputType==='tel'){var r=target.dataset.row,c=target.dataset.column;var keyChar=currentLayout.keys[r][c].value;var altKey=currentLayout.alt[keyChar]||null;if(!altKey)
return;target.dataset.ignoreEndPress=true;var keyCode=altKey.charCodeAt(0);sendKey(keyCode);return;}
showAlternatives(target);if(isShowingAlternativesMenu)
movePress(target,coords,touchId);},ACCENT_CHAR_MENU_TIMEOUT);}
function showAlternatives(key){var alternatives,altMap,value,keyObj,uppercaseValue,needsCapitalization;var r=key?key.dataset.row:-1,c=key?key.dataset.column:-1;if(r<0||c<0||r===undefined||c===undefined)
return;keyObj=currentLayout.keys[r][c];if(keyObj.keyCode===SWITCH_KEYBOARD){showIMEList();return;}
altMap=currentLayout.alt||{};value=keyObj.value;alternatives=altMap[value]||'';if(isUpperCase||isUpperCaseLocked){uppercaseValue=getUpperCaseValue(keyObj);if(altMap[uppercaseValue]){alternatives=altMap[uppercaseValue];}
else{needsCapitalization=true;}}
if(alternatives.indexOf(' ')!=-1){alternatives=alternatives.split(' ');if(alternatives.length===2&&alternatives[1]==='')
alternatives.pop();if(needsCapitalization){for(var i=0;i<alternatives.length;i++){if(isUpperCaseLocked){alternatives[i]=alternatives[i].toLocaleUpperCase();}
else{alternatives[i]=alternatives[i][0].toLocaleUpperCase()+
alternatives[i].substring(1);}}}}else{if(needsCapitalization)
alternatives=alternatives.toLocaleUpperCase();alternatives=alternatives.split('');}
if(!alternatives.length)
return;var top=getWindowTop(key);var bottom=getWindowTop(key)+key.scrollHeight;var keybounds=key.getBoundingClientRect();IMERender.showAlternativesCharMenu(key,alternatives);isShowingAlternativesMenu=true;menuLockedArea={top:top,bottom:bottom,left:getWindowLeft(IMERender.menu),right:getWindowLeft(IMERender.menu)+IMERender.menu.scrollWidth};menuLockedArea.width=menuLockedArea.right-menuLockedArea.left;menuLockedArea.keybounds=keybounds;menuLockedArea.firstAlternative=IMERender.menu.classList.contains('kbr-menu-left')?IMERender.menu.lastElementChild:IMERender.menu.firstElementChild;menuLockedArea.boxes=[];var children=IMERender.menu.children;for(var i=0;i<children.length;i++){menuLockedArea.boxes[i]=children[i].getBoundingClientRect();}}
function hideAlternatives(){if(!isShowingAlternativesMenu)
return;IMERender.hideAlternativesCharMenu();isShowingAlternativesMenu=false;}
function isNormalKey(key){var keyCode=parseInt(key.dataset.keycode);return keyCode||key.dataset.selection||key.dataset.compositekey;}
function onTouchStart(evt){if(!IMERender.isFullCandidataPanelShown())
evt.preventDefault();touchEventsPresent=true;if(isShowingAlternativesMenu)
return;touchCount=evt.touches.length;handleTouches(evt,function handleTouchStart(touch,touchId){var target=touch.target;target.addEventListener('touchmove',onTouchMove);target.addEventListener('touchend',onTouchEnd);target.addEventListener('touchcancel',onTouchEnd);touchedKeys[touchId]={target:target,x:touch.pageX,y:touch.pageY};startPress(target,touch,touchId);touchStartCoordinate={touchId:touchId,pageX:touch.pageX,pageY:touch.pageY,timeStamp:evt.timeStamp};});}
function onTouchMove(evt){if(!IMERender.isFullCandidataPanelShown())
evt.preventDefault();handleTouches(evt,function handleTouchMove(touch,touchId){var x=Math.abs(touchedKeys[touchId].x-touch.pageX);var y=Math.abs(touchedKeys[touchId].y-touch.pageY);if(x<5&&y<5)
return;touchedKeys[touchId].x=touch.pageX;touchedKeys[touchId].y=touch.pageY;var target=document.elementFromPoint(touch.pageX,touch.pageY);movePress(target,touch,touchId);});}
function onTouchEnd(evt){if(!IMERender.isFullCandidataPanelShown())
evt.preventDefault();touchCount=evt.touches.length;handleTouches(evt,function handleTouchEnd(touch,touchId){if(touchStartCoordinate&&touchStartCoordinate.touchId==touchId){var dx=touch.pageX-touchStartCoordinate.pageX;var dy=touch.pageY-touchStartCoordinate.pageY;var dt=evt.timeStamp-touchStartCoordinate.timeStamp;var vy=dy/dt;var keyboardHeight=cachedIMEDimensions.height;var hasCandidateScrolled=(IMERender.isFullCandidataPanelShown()&&(Math.abs(dx)>3||Math.abs(dy)>3));if((dy>keyboardHeight/2&&dy>dx)&&vy>SWIPE_VELOCICTY_THRESHOLD&&!hasCandidateScrolled){if(touchedKeys[touchId]&&touchedKeys[touchId].target)
IMERender.unHighlightKey(touchedKeys[touchId].target);clearTimeout(deleteTimeout);clearInterval(deleteInterval);clearTimeout(menuTimeout);navigator.mozInputMethod.mgmt.hide();return;}}
if(!touchedKeys[touchId])
return;var target=touch.target;target.removeEventListener('touchmove',onTouchMove);target.removeEventListener('touchend',onTouchEnd);target.removeEventListener('touchcancel',onTouchEnd);endPress(touchedKeys[touchId].target,touch,touchId,hasCandidateScrolled);delete touchedKeys[touchId];});}
function handleTouches(evt,callback){for(var i=0;i<evt.changedTouches.length;i++){var touch=evt.changedTouches[i];var touchId=touch.identifier;callback(touch,touchId);}}
function onMouseDown(evt){evt.preventDefault();if(touchEventsPresent)
return;IMERender.ime.setCapture(false);currentKey=evt.target;startPress(currentKey,evt,null);}
function getKeyCodeFromTarget(target){return isUpperCase||isUpperCaseLocked?parseInt(target.dataset.keycodeUpper,10):parseInt(target.dataset.keycode,10);}
function startPress(target,coords,touchId){if(!isNormalKey(target))
return;var keyCode=getKeyCodeFromTarget(target);var isSpecialKey=specialCodes.indexOf(keyCode)>=0||keyCode<0;triggerFeedback(isSpecialKey);IMERender.highlightKey(target);setMenuTimeout(target,coords,touchId);if(keyCode===KeyEvent.DOM_VK_BACK_SPACE){sendDelete(false);deleteTimeout=window.setTimeout(function(){sendDelete(true);deleteInterval=setInterval(function(){sendDelete(true);},REPEAT_RATE);},REPEAT_TIMEOUT);}}
function inMenuLockedArea(lockedArea,coords){return(lockedArea&&coords.pageY>=lockedArea.top&&coords.pageY<=lockedArea.bottom&&coords.pageX>=lockedArea.left&&coords.pageX<=lockedArea.right);}
function onMouseMove(evt){if(touchEventsPresent)
return;movePress(evt.target,evt,null);}
function movePress(target,coords,touchId){if(isShowingAlternativesMenu&&inMenuLockedArea(menuLockedArea,coords)){if(menuLockedArea.keybounds&&coords.pageX>=menuLockedArea.keybounds.left&&coords.pageX<menuLockedArea.keybounds.right){target=menuLockedArea.firstAlternative;}
else{menuLockedArea.keybounds=null;var menuChildren=IMERender.menu.children;for(var i=0;i<menuChildren.length;i++){if(coords.pageX>=menuLockedArea.boxes[i].left&&coords.pageX<menuLockedArea.boxes[i].right){break;}}
target=menuChildren[i];}}
if(isShowingKeyboardLayoutMenu&&target.dataset&&target.dataset.keyboard){KeyboardMenuScroll.scrollKeyboardMenu(target,coords);}
var oldTarget=touchEventsPresent?touchedKeys[touchId].target:currentKey;if(!target||!oldTarget||oldTarget==target||!isNormalKey(target))
return;IMERender.unHighlightKey(oldTarget);var keyCode=getKeyCodeFromTarget(target);if(keyCode!=KeyEvent.DOM_VK_BACK_SPACE)
IMERender.highlightKey(target);setCurrentKey(target,touchId);clearTimeout(deleteTimeout);clearInterval(deleteInterval);clearTimeout(menuTimeout);if(target.parentNode!==IMERender.menu&&isShowingAlternativesMenu&&!inMenuLockedArea(menuLockedArea,coords))
hideAlternatives();setMenuTimeout(target,coords,touchId);function setCurrentKey(value,touchId){if(touchEventsPresent)
touchedKeys[touchId].target=value;else
currentKey=value;}}
function onMouseUp(evt){if(touchEventsPresent)
return;endPress(currentKey,evt,null);currentKey=null;}
function endPress(target,coords,touchId,hasCandidateScrolled){clearTimeout(deleteTimeout);clearInterval(deleteInterval);clearTimeout(menuTimeout);var wasShowingKeyboardLayoutMenu=isShowingKeyboardLayoutMenu;hideAlternatives();if(target.classList.contains('dismiss-suggestions-button')){if(inputMethod.dismissSuggestions)
inputMethod.dismissSuggestions();return;}
if(!target||!isNormalKey(target))
return;var dataset=target.dataset;if(dataset.selection){if(!hasCandidateScrolled){IMERender.toggleCandidatePanel(false);if(inputMethod.select){inputMethod.select(target.textContent,dataset.data);}}
IMERender.unHighlightKey(target);return;}
IMERender.unHighlightKey(target);if(target.dataset.ignoreEndPress){delete target.dataset.ignoreEndPress;return;}
var keyCode=getKeyCodeFromTarget(target);if(keyCode==KeyEvent.DOM_VK_BACK_SPACE)
return;if(keyCode!=KeyEvent.DOM_VK_SPACE)
isContinousSpacePressed=false;var keyStyle=getComputedStyle(target);if(keyStyle.display=='none'||keyStyle.visibility=='hidden')
return;switch(keyCode){case BASIC_LAYOUT:setLayoutPage(LAYOUT_PAGE_DEFAULT);break;case ALTERNATE_LAYOUT:setLayoutPage(LAYOUT_PAGE_SYMBOLS_I);break;case KeyEvent.DOM_VK_ALT:if(layoutPage===LAYOUT_PAGE_SYMBOLS_I){setLayoutPage(LAYOUT_PAGE_SYMBOLS_II);}else{setLayoutPage(LAYOUT_PAGE_SYMBOLS_I);}
break;case SWITCH_KEYBOARD:if(target.dataset.keyboard||!wasShowingKeyboardLayoutMenu)
switchToNextIME();break;case TOGGLE_CANDIDATE_PANEL:var candidatePanel=IMERender.candidatePanel;if(IMERender.ime.classList.contains('candidate-panel')){var doToggleCandidatePanel=function doToggleCandidatePanel(){if(candidatePanel.dataset.truncated){if(candidatePanelScrollTimer){clearTimeout(candidatePanelScrollTimer);candidatePanelScrollTimer=null;}
candidatePanel.addEventListener('scroll',candidatePanelOnScroll);}
IMERender.toggleCandidatePanel(true);};if(candidatePanel.dataset.rowCount==1){var firstPageRows=11;var numberOfCandidatesPerRow=IMERender.getNumberOfCandidatesPerRow();var candidateIndicator=parseInt(candidatePanel.dataset.candidateIndicator);if(inputMethod.getMoreCandidates){inputMethod.getMoreCandidates(candidateIndicator,firstPageRows*numberOfCandidatesPerRow+1,function getMoreCandidatesCallbackOnToggle(list){if(candidatePanel.dataset.rowCount==1){IMERender.showMoreCandidates(firstPageRows,list);doToggleCandidatePanel();}});}else{var list=currentCandidates.slice(candidateIndicator,candidateIndicator+firstPageRows*numberOfCandidatesPerRow+1);IMERender.showMoreCandidates(firstPageRows,list);doToggleCandidatePanel();}}else{doToggleCandidatePanel();}}else{if(inputMethod.getMoreCandidates){candidatePanel.removeEventListener('scroll',candidatePanelOnScroll);if(candidatePanelScrollTimer){clearTimeout(candidatePanelScrollTimer);candidatePanelScrollTimer=null;}}
IMERender.toggleCandidatePanel(false);}
break;case KeyEvent.DOM_VK_CAPS_LOCK:if(isWaitingForSecondTap){isWaitingForSecondTap=false;setUpperCase(true,true);}else{isWaitingForSecondTap=true;window.setTimeout(function(){isWaitingForSecondTap=false;},CAPS_LOCK_TIMEOUT);setUpperCase(!isUpperCase,false);}
break;default:if(target.dataset.compositekey){var compositeKey=target.dataset.compositekey;for(var i=0;i<compositeKey.length;i++){inputMethod.click(compositeKey.charCodeAt(i));}}
else{var activeKeyboard=Keyboards[keyboardName];if(activeKeyboard.imEngine=='latin'){inputMethod.click(parseInt(target.dataset.keycode,10),parseInt(target.dataset.keycodeUpper,10));}else{inputMethod.click(keyCode);}}
break;}}
function candidatePanelOnScroll(){if(candidatePanelScrollTimer){clearTimeout(candidatePanelScrollTimer);candidatePanelScrollTimer=null;}
if(this.scrollTop!=0&&this.scrollHeight-this.clientHeight-this.scrollTop<5){candidatePanelScrollTimer=setTimeout(function(){var pageRows=12;var numberOfCandidatesPerRow=IMERender.getNumberOfCandidatesPerRow();var candidatePanel=IMERender.candidatePanel;var candidateIndicator=parseInt(candidatePanel.dataset.candidateIndicator);if(inputMethod.getMoreCandidates){inputMethod.getMoreCandidates(candidateIndicator,pageRows*numberOfCandidatesPerRow+1,IMERender.showMoreCandidates.bind(IMERender,pageRows));}else{var list=currentCandidates.slice(candidateIndicator,candidateIndicator+pageRows*numberOfCandidatesPerRow+1);IMERender.showMoreCandidates(pageRows,list);}},200);}}
function getKeyCoordinateY(y){var candidatePanel=IMERender.candidatePanel;var yBias=0;if(candidatePanel)
yBias=candidatePanel.clientHeight;return y-yBias;}
function switchToNextIME(){deactivateInputMethod();var mgmt=navigator.mozInputMethod.mgmt;mgmt.next();}
function showIMEList(){clearTouchedKeys();var mgmt=navigator.mozInputMethod.mgmt;mgmt.showAll();}
function resetKeyboard(){layoutPage=LAYOUT_PAGE_DEFAULT;isUpperCase=false;isUpperCaseLocked=false;}
function sendKey(keyCode){switch(keyCode){case KeyEvent.DOM_VK_BACK_SPACE:case KeyEvent.DOM_VK_RETURN:if(inputContext){return inputContext.sendKey(keyCode,0,0);}
break;default:if(inputContext){return inputContext.sendKey(0,keyCode,0);}
break;}}
function replaceSurroundingText(text,offset,length){if(inputContext){return inputContext.replaceSurroundingText(text,offset,length);}else{console.warn('no inputContext for replaceSurroudingText');return new Promise(function(res,rej){rej();});}}
function showKeyboard(){clearTimeout(hideKeyboardTimeout);inputContext=navigator.mozInputMethod.inputcontext;resetKeyboard();if(toShowKeyboardFTU){var dialog=document.getElementById('confirm-dialog');dialog.hidden=false;toShowKeyboardFTU=false;navigator.mozSettings.createLock().set({'keyboard.ftu.enabled':false});}
if(inputContext){currentInputMode=inputContext.inputMode;currentInputType=mapInputType(inputContext.inputType);}else{currentInputMode='';currentInputType=mapInputType('text');return;}
var state={type:inputContext.inputType,inputmode:inputContext.inputMode,selectionStart:inputContext.selectionStart,selectionEnd:inputContext.selectionEnd,value:'',inputContext:inputContext};navigator.mozSettings.createLock().set({'keyboard.current':keyboardName});function doShowKeyboard(){if(inputMethod.activate){inputMethod.activate(Keyboards[keyboardName].autoCorrectLanguage,state,{suggest:suggestionsEnabled&&!isGreekSMS(),correct:correctionsEnabled&&!isGreekSMS()});}
renderKeyboard(keyboardName,function(){IMERender.showIME();});}
var promise=inputContext.getText();promise.then(function gotText(value){state.value=value;doShowKeyboard();},function failedToGetText(ex){});}
function hideKeyboard(){if(!isKeyboardRendered){clearTouchedKeys();return;}
clearTimeout(hideKeyboardTimeout);hideKeyboardTimeout=setTimeout(function(){IMERender.hideIME();},HIDE_KEYBOARD_TIMEOUT);deactivateInputMethod();isKeyboardRendered=false;navigator.mozSettings.createLock().set({'keyboard.current':undefined});clearTouchedKeys();}
function onResize(){if(IMERender.ime.dataset.hidden)
return;IMERender.resizeUI(currentLayout);updateTargetWindowHeight();updateLayoutParams();}
function loadIMEngine(name,callback){var keyboard=Keyboards[name];var sourceDir='./js/imes/';var imEngine=keyboard.imEngine;if(InputMethods[imEngine]){if(callback)
callback();return;}
var script=document.createElement('script');script.src=sourceDir+imEngine+'/'+imEngine+'.js';var glue={path:sourceDir+imEngine,sendCandidates:function kc_glue_sendCandidates(candidates){currentCandidates=candidates;IMERender.showCandidates(candidates);},setComposition:function kc_glue_setComposition(symbols,cursor){cursor=cursor||symbols.length;inputContext.setComposition(symbols,cursor);},endComposition:function kc_glue_endComposition(text){text=text||'';inputContext.endComposition(text);},sendKey:sendKey,sendString:function kc_glue_sendString(str){for(var i=0;i<str.length;i++)
sendKey(str.charCodeAt(i));},alterKeyboard:function kc_glue_alterKeyboard(keyboard){renderKeyboard(keyboard);},setLayoutPage:setLayoutPage,setUpperCase:setUpperCase,resetUpperCase:resetUpperCase,replaceSurroundingText:replaceSurroundingText,getNumberOfCandidatesPerRow:IMERender.getNumberOfCandidatesPerRow.bind(IMERender),isCapitalized:isCapitalized};script.addEventListener('load',function IMEngineLoaded(){var engine=InputMethods[imEngine];engine.init(glue);if(callback)
callback();});document.body.appendChild(script);}
function updateLayoutParams(){if(inputMethod.setLayoutParams&&layoutPage===LAYOUT_PAGE_DEFAULT){inputMethod.setLayoutParams({keyboardWidth:IMERender.getWidth(),keyboardHeight:getKeyCoordinateY(IMERender.getHeight()),keyArray:IMERender.getKeyArray(),keyWidth:IMERender.getKeyWidth(),keyHeight:IMERender.getKeyHeight()});}}
function triggerFeedback(isSpecialKey){if(vibrationEnabled){try{navigator.vibrate(50);}catch(e){}}
if(clickEnabled&&isSoundEnabled){(isSpecialKey?specialClicker:clicker).cloneNode(false).play();}}
function getWindowTop(obj){var top;top=obj.offsetTop;while(!!(obj=obj.offsetParent)){top+=obj.offsetTop;}
return top;}
function getWindowLeft(obj){var left;left=obj.offsetLeft;while(!!(obj=obj.offsetParent)){left+=obj.offsetLeft;}
return left;}
function getSettings(settings,callback){var results={};try{var lock=navigator.mozSettings.createLock();}
catch(e){console.warn('Exception in mozSettings.createLock():',e,'\nUsing default values');for(var p in settings)
results[p]=settings[p];callback(results);}
var settingNames=Object.keys(settings);var numSettings=settingNames.length;var numResults=0;for(var i=0;i<numSettings;i++){requestSetting(settingNames[i]);}
function requestSetting(name){try{var request=lock.get(name);}
catch(e){console.warn('Exception querying setting',name,':',e,'\nUsing default value');recordResult(name,settings[name]);return;}
request.onsuccess=function(){var value=request.result[name];if(value===undefined)
value=settings[name];recordResult(name,value);};request.onerror=function(evt){console.warn('Error querying setting',name,':',evt.error);recordResult(name,settings[name]);};}
function recordResult(name,value){results[name]=value;numResults++;if(numResults===numSettings){callback(results);}}}
function needsCandidatePanel(){if(isGreekSMS()){return false;}
return!!((Keyboards[keyboardName].autoCorrectLanguage||Keyboards[keyboardName].needsCandidatePanel)&&(!inputMethod.displaysCandidates||inputMethod.displaysCandidates()));}
function isGreekSMS(){return(currentInputMode==='-moz-sms'&&keyboardName==='el');}
function clearTouchedKeys(){for(var id in touchedKeys){if(!touchedKeys[id]){continue;}
var target=touchedKeys[id].target;if(target){target.removeEventListener('touchmove',onTouchMove);target.removeEventListener('touchend',onTouchEnd);target.removeEventListener('touchcancel',onTouchEnd);IMERender.unHighlightKey(target);}}
hideAlternatives();touchedKeys={};clearTimeout(deleteTimeout);clearInterval(deleteInterval);clearTimeout(menuTimeout);}
var KeyboardMenuScroll={currentCoords:null,scrollTimeout:null,reset:function kms_reset(){this.currentCoords=null;clearTimeout(this.scrollTimeout);this.scrollTimeout=null;},scrollKeyboardMenu:function kms_scrollKeyboardMenu(target,coords){var keyboardMenu=target.parentNode;var menuTop=getWindowTop(keyboardMenu);var menuBottom=menuTop+keyboardMenu.offsetHeight;var TIMEOUT_FOR_NEXT_SCROLL=30;var scrollThreshold=keyboardMenu.firstElementChild.offsetHeight;var scrollStep=scrollThreshold*5/(1000/TIMEOUT_FOR_NEXT_SCROLL);this.currentCoords=coords;function scroll(delta){if(document.hidden)
return false;var origScrollTop=keyboardMenu.scrollTop;keyboardMenu.scrollTop+=delta;return(origScrollTop!=keyboardMenu.scrollTop);}
function doScroll(){if(!this.currentCoords){return;}
var scrolled=false;if(Math.abs(this.currentCoords.pageY-menuTop)<scrollThreshold){scrolled=scroll(-scrollStep);}else if(Math.abs(this.currentCoords.pageY-menuBottom)<scrollThreshold){scrolled=scroll(scrollStep);}
if(scrolled)
this.scrollTimeout=window.setTimeout(doScroll.bind(this),TIMEOUT_FOR_NEXT_SCROLL);else
this.scrollTimeout=null;}
if(this.scrollTimeout){return;}
this.scrollTimeout=window.setTimeout(doScroll.bind(this),100);}};