;'use strict';var ActivityHandler={_currentActivity:null,_launchedAsInlineActivity:(window.location.search=='?pick'),get currentlyHandling(){return!!this._currentActivity;},get activityName(){if(!this._currentActivity){return null;}
return this._currentActivity.source.name;},get activityDataType(){if(!this._currentActivity){return null;}
return this._currentActivity.source.data.type;},launch_activity:function ah_launch(activity,action){if(this._launchedAsInlineActivity){return;}
this._currentActivity=activity;var hash=action;var param,params=[];if(activity.source&&activity.source.data&&activity.source.data.params){var originalParams=activity.source.data.params;for(var i in originalParams){param=originalParams[i];params.push(i+'='+param);}
hash+='?'+params.join('&');}
document.location.hash=hash;},handle:function ah_handle(activity){switch(activity.source.name){case'new':this.launch_activity(activity,'view-contact-form');break;case'open':this.launch_activity(activity,'view-contact-details');break;case'update':this.launch_activity(activity,'add-parameters');break;case'pick':if(!this._launchedAsInlineActivity){return;}
this._currentActivity=activity;Contacts.navigation.home();break;case'import':this.importContactsFromFile(activity);break;}
Contacts.checkCancelableActivity();},importContactsFromFile:function ah_importContactFromVcard(activity){var self=this;if(activity.source&&activity.source.data&&activity.source.data.blob){LazyLoader.load(['/contacts/js/utilities/import_from_vcard.js','/contacts/js/utilities/overlay.js'],function loaded(){utils.importFromVcard(activity.source.data.blob,function imported(id){if(id){activity.source.data.params={id:id};}
self.launch_activity(activity,'view-contact-details');});});}else{this._currentActivity.postError('wrong parameters');this._currentActivity=null;}},dataPickHandler:function ah_dataPickHandler(theContact){var type,dataSet,noDataStr;switch(this.activityDataType){case'webcontacts/tel':type='contact';dataSet=theContact.tel;noDataStr=_('no_contact_phones');break;case'webcontacts/contact':type='number';dataSet=theContact.tel;noDataStr=_('no_contact_phones');break;case'webcontacts/email':type='email';dataSet=theContact.email;noDataStr=_('no_contact_email');break;}
var hasData=dataSet&&dataSet.length;var numOfData=hasData?dataSet.length:0;var result={};result.name=theContact.name;switch(numOfData){case 0:var dismiss={title:_('ok'),callback:function(){ConfirmDialog.hide();}};Contacts.confirmDialog(null,noDataStr,dismiss);break;case 1:if(this.activityDataType=='webcontacts/tel'){result=utils.misc.toMozContact(theContact);}else{result[type]=dataSet[0].value;}
this.postPickSuccess(result);break;default:var prompt1=new ValueSelector();var data;for(var i=0;i<dataSet.length;i++){data=dataSet[i].value;var carrier=dataSet[i].carrier||'';prompt1.addToList(data+' '+carrier,data);}
prompt1.onchange=(function onchange(itemData){if(this.activityDataType=='webcontacts/tel'){result=utils.misc.toMozContact(theContact);result.tel=this.filterPhoneNumberForActivity(itemData,result.tel);}else{result[type]=itemData;}
prompt1.hide();this.postPickSuccess(result);}).bind(this);prompt1.show();}},filterPhoneNumberForActivity:function ah_filterPhoneNumberForActivity(itemData,dataSet){return dataSet.filter(function isSamePhone(item){return item.value==itemData;});},postNewSuccess:function ah_postNewSuccess(contact){this._currentActivity.postResult({contact:contact});this._currentActivity=null;},postPickSuccess:function ah_postPickSuccess(result){this._currentActivity.postResult(result);this._currentActivity=null;},postCancel:function ah_postCancel(){this._currentActivity.postError('canceled');this._currentActivity=null;}};;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;(function(exports){'use strict';function getThumbnail(contact){return getOnePhoto(contact,'begin');}
function getFullResolution(contact){return getOnePhoto(contact,'end');}
function getOnePhoto(contact,position){if(!contact||!contact.photo||!contact.photo.length){return null;}
if(contact.photo.length===1){return contact.photo[0];}
var photos=contact.photo;var category=contact.category;if(Array.isArray(category)&&category.indexOf('fb_linked')!==-1){if(photos.length>=4){return photos[(position=='begin')?1:0];}
return photos[0];}
photos=photosBySize(contact);var index=(position=='begin')?0:photos.length-1;return photos[index];}
function photosBySize(contact){var photos=contact.photo.slice(0);photos.sort(function(p1,p2){if(size(p1)<size(p2)){return-1;}
if(size(p1)>size(p2)){return 1;}
return 0;});return photos;}
function size(photo){if(typeof photo=='string'){return photo.length;}
return photo.size;}
exports.ContactPhotoHelper={getThumbnail:getThumbnail,getFullResolution:getFullResolution};})(window);;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var utils=window.utils||{};if(typeof utils.config==='undefined'){(function(){var config=utils.config={};var loading={};var loaded={};var pendingRequests={};config.load=function(resource){var outReq=new LoadRequest();var data=loaded[resource];if(data){window.setTimeout(function(){outReq.completed(data);},0);}
else{var requests=pendingRequests[resource];if(!Array.isArray(requests)){pendingRequests[resource]=requests=[];}
requests.push(outReq);var isLoading=loading[resource];if(!isLoading){loading[resource]=true;window.setTimeout(function do_load(){var xhr=new XMLHttpRequest();xhr.overrideMimeType('application/json');xhr.open('GET',resource,true);xhr.onreadystatechange=function(){if(xhr.readyState===4&&(xhr.status===200||xhr.status===0)){var response=xhr.responseText;var configuration=JSON.parse(response);loaded[resource]=configuration;delete loading[resource];requests.forEach(function(aRequest){aRequest.completed(configuration);});delete pendingRequests[resource];}
else if(xhr.readyState===4){requests.forEach(function(aRequest){aRequest.failed(xhr.status);});delete pendingRequests[resource];}};xhr.send(null);},0);}}
return outReq;};function LoadRequest(){this.completed=function(configData){if(typeof this.onload==='function'){this.onload(configData);}};this.failed=function(code){if(typeof this.onerror==='function'){this.onerror(code);}};}})();};'use strict';(function(){var utils=window.utils=window.utils||{};utils.cookie={};var COOKIE_VERSION=2;var COOKIE_DEFAULTS={order:false,viewHeight:-1,rowsPerPage:-1,fbMigrated:false};var COOKIE_PROPS=Object.keys(COOKIE_DEFAULTS);var EXPIRATION_DATE='Fri, 31 Dec 9999 23:59:59 GMT';var COOKIE_NAME='preferences';var COOKIE_NAME_EQ=COOKIE_NAME+'=';var COOKIE_NAME_LENGHT=COOKIE_NAME_EQ.length;function _parseCookie(cookie){var index=cookie.indexOf(COOKIE_NAME_EQ);if(index===-1){return null;}
var cookieVal=cookie.substring(index+COOKIE_NAME_LENGHT);if(!cookieVal){return null;}
return JSON.parse(decodeURIComponent(cookieVal));}
utils.cookie.load=function(){if(!document.cookie){return null;}
var cookie=_parseCookie(document.cookie);if(cookie&&cookie.version!==COOKIE_VERSION){_updateCookie(cookie);cookie=_parseCookie(document.cookie);}
return cookie;};utils.cookie.update=function(cfg){_updateCookie(utils.cookie.load(),cfg);};function _updateCookie(oldCookie,cfg){oldCookie=oldCookie||{};cfg=cfg||{};var newCookie={version:COOKIE_VERSION};for(var i=0,n=COOKIE_PROPS.length;i<n;++i){var prop=COOKIE_PROPS[i];if(prop in cfg){newCookie[prop]=cfg[prop];}else if(prop in oldCookie){newCookie[prop]=oldCookie[prop];}else{newCookie[prop]=COOKIE_DEFAULTS[prop];}}
document.cookie=COOKIE_NAME+'='+
encodeURIComponent(JSON.stringify(newCookie))+';expires='+EXPIRATION_DATE;}
utils.cookie.getDefault=function(prop){return COOKIE_DEFAULTS(prop);};})();;'use strict';var utils=window.utils||{};if(!utils.extractParams){utils.extractParams=function extractParams(url){if(!url){return-1;}
var ret={};var params=url.split('&');for(var i=0;i<params.length;i++){var currentParam=params[i].split('=');ret[currentParam[0]]=currentParam[1];}
return ret;};};'use strict';var utils=window.utils||{};if(!utils.misc){utils.misc={};utils.misc.toMozContact=function ut_toMozContact(contact){var outContact=contact;if(!(contact instanceof mozContact)){outContact=new mozContact(contact);outContact.id=contact.id||outContact.id;}
return outContact;};utils.misc.formatDate=function formatDate(date){var FLAG_YEAR_IGNORED=9996;var _=navigator.mozL10n.get;var dateFormat=_('dateFormat')||'%B %e';var f=new navigator.mozL10n.DateTimeFormat();var dateString=null;try{var offset=date.getTimezoneOffset()*60*1000;var normalizedDate=new Date(date.getTime()+offset);var year=normalizedDate.getFullYear();if(year===FLAG_YEAR_IGNORED){year='';}
var dayMonthString=f.localeFormat(normalizedDate,dateFormat);dateString=_('dateOutput',{dayMonthFormatted:dayMonthString,year:year});}catch(err){console.error('Error parsing date: ',err);throw err;}
return dateString;};utils.misc.parseName=function parseName(nameString){var MIN_LENGHT_SIGNIFICATIVE=3;var MIN_LENGHT_FN=2;var out={givenName:'',familyName:''};if(!nameString){return out;}
var str=nameString.trim();if(!str){return out;}
function startsWithUpper(str){var firstLetter=str.charAt(0);var capFirstLetter=firstLetter.toLocaleUpperCase();return(capFirstLetter===firstLetter);}
var tokens=nameString.split(/\s+/);var significativeTokens={};for(var j=0;j<tokens.length;j++){var token=tokens[j];if(token.length>MIN_LENGHT_SIGNIFICATIVE||startsWithUpper(token)){significativeTokens[token]=true;}}
var totalTokens=tokens.length;var lastToken=totalTokens-1;var rolePrevToken;var remainingTokens=Object.keys(significativeTokens).length;var outGivenNames=[],outFamilyNames=[];var numFns=0;while(lastToken>=0){if(significativeTokens[tokens[lastToken]]){remainingTokens--;}
var currToken=tokens[lastToken],nextToken=tokens[lastToken+1],prevToken=tokens[lastToken-1];if(!nextToken&&prevToken){outFamilyNames.push(currToken);numFns++;rolePrevToken='FN';}
else if(!prevToken){outGivenNames.push(currToken);rolePrevToken='GN';}
else if(nextToken){if(!significativeTokens[currToken]){if(rolePrevToken==='FN'){outFamilyNames.push(currToken);}
else{outGivenNames.push(currToken);}}
else if(currToken.length<MIN_LENGHT_FN){outGivenNames.push(currToken);rolePrevToken='GN';}
else{if(remainingTokens>=2&&numFns<2){outFamilyNames.push(currToken);numFns++;rolePrevToken='FN';}
else{outGivenNames.push(currToken);rolePrevToken='GN';}}}
lastToken--;}
out.givenName=outGivenNames.reverse().join(' ').trim();out.familyName=outFamilyNames.reverse().join(' ').trim();return out;};};var fb=window.fb||{};var config=window.config||{};if(typeof fb.init==='undefined'){(function(){fb.isEnabled=false;var initialized=false;fb.init=function(callback){if(initialized){callback();return;}
initialized=true;var req=utils.config.load('/contacts/config.json');req.onload=function(configData){if(configData.facebookEnabled===true){fb.isEnabled=true;}
fb.operationsTimeout=config.operationsTimeout=configData.operationsTimeout;fb.logLevel=configData.logLevel||'none';fb.syncPeriod=configData.facebookSyncPeriod||24;fb.testToken=configData.testToken;callback();};req.onerror=function(code){window.console.error('Contacts: Error while checking if FB is enabled',code);};};})();};'use strict';var utils=window.utils||{};if(!utils.listeners){(function(document){var Listeners=utils.listeners={};Listeners.add=function(config){try{for(var id in config){var handler=config[id];var nodes=document.querySelectorAll(id);for(var i=0;i<nodes.length;i++){var node=nodes[i];if(Array.isArray(handler)){handler.forEach(function handle(item){if(!item.hasOwnProperty('event')&&!item.hasOwnProperty('handler')){return;}
node.addEventListener(item.event,item.handler);});}else{node.addEventListener('click',handler);}}}}
catch(e){window.console.error('Error while registering listener for: ',id,e);}};})(document);};'use strict';function navigationStack(currentView){this.transitions={'none':{forwards:{},backwards:{}},'right-left':{forwards:{next:'app-go-left-in'},backwards:{current:'app-go-left-back-out'}},'popup':{forwards:{next:'app-go-up-in'},backwards:{current:'app-go-up-back-out'}},'go-deeper':{forwards:{current:'app-go-deeper-out',next:'app-go-deeper-in'},backwards:{current:'app-go-deeper-back-out',next:'app-go-deeper-back-in'}},'go-deeper-search':{forwards:{current:'move-left-out',next:'move-left-in'},backwards:{current:'move-right-out',next:'move-right-in'}}};var COMMS_APP_ORIGIN=location.origin;var screenshotViewId='view-screenshot';var _currentView=currentView;this.stack=[];navigationStack._zIndex=navigationStack._zIndex||0;this.stack.push({view:_currentView,transition:'popup',zIndex:++navigationStack._zIndex});var waitForAnimation=function ng_waitForAnimation(view,callback){if(!callback)
return;view.addEventListener('animationend',function ng_onAnimationEnd(){view.removeEventListener('animationend',ng_onAnimationEnd);setTimeout(callback,0);});};this.go=function go(nextView,transition){if(_currentView===nextView)
return;var parent=window.parent;if(nextView=='view-contact-form'){parent.postMessage({type:'hide-navbar'},COMMS_APP_ORIGIN);}
this.stack=this.stack.filter(function(item){return item.view!=nextView;});var current;var currentClassList;if(transition.indexOf('go-deeper')===0){current=document.getElementById(screenshotViewId);LazyLoader.load([current]);current.style.zIndex=this.stack[this.stack.length-1].zIndex;currentClassList=current.classList;if(transition.indexOf('search')!==-1){currentClassList.add('search');}else{currentClassList.add('contact-list');}
currentClassList.remove('hide');}else{current=document.getElementById(_currentView);currentClassList=current.classList;}
var forwardsClasses=this.transitions[transition].forwards;var backwardsClasses=this.transitions[transition].backwards;currentClassList.add('block-item');if(forwardsClasses.current){currentClassList.add(forwardsClasses.current);}
var next=document.getElementById(nextView);if(forwardsClasses.next){next.classList.add('block-item');next.classList.add(forwardsClasses.next);next.addEventListener('animationend',function ng_onNextBackwards(ev){next.removeEventListener('animationend',ng_onNextBackwards);next.classList.remove('block-item');});}
var zIndex=++navigationStack._zIndex;this.stack.push({view:nextView,transition:transition,zIndex:zIndex});next.style.zIndex=zIndex;_currentView=nextView;};this.back=function back(callback){var self=this;if(this.stack.length<2){if(typeof callback==='function'){setTimeout(callback,0);}
return;}
var currentView=this.stack.pop();var current=document.getElementById(currentView.view);var currentClassList=current.classList;var nextView=this.stack[this.stack.length-1];var transition=currentView.transition;var next=document.getElementById(nextView.view);var nextClassList;if(transition.indexOf('go-deeper')===0){next=document.getElementById(screenshotViewId);}else{next=document.getElementById(nextView.view);}
nextClassList=next.classList;var forwardsClasses=this.transitions[transition].forwards;var backwardsClasses=this.transitions[transition].backwards;if(currentView.view=='view-contact-form'){parent.postMessage({type:'show-navbar'},COMMS_APP_ORIGIN);}
if(backwardsClasses.current){currentClassList.add('block-item');currentClassList.add(backwardsClasses.current);current.addEventListener('animationend',function ng_onCurrentBackwards(){current.removeEventListener('animationend',ng_onCurrentBackwards);currentClassList.remove(forwardsClasses.next);currentClassList.remove(backwardsClasses.current);current.style.zIndex=null;currentClassList.remove('block-item');if(!backwardsClasses.next){nextClassList.remove('block-item');}});}else{current.style.zIndex=null;currentClassList.remove('block-item');if(!backwardsClasses.next){nextClassList.remove('block-item');}}
next.style.zIndex=nextView.zIndex;if(backwardsClasses.next){nextClassList.add(backwardsClasses.next);next.addEventListener('animationend',function ng_onNextBackwards(){next.removeEventListener('animationend',ng_onNextBackwards);nextClassList.remove(forwardsClasses.current);nextClassList.remove(backwardsClasses.next);if(transition.indexOf('go-deeper')===0){nextClassList.add('hide');nextClassList.remove('search');nextClassList.remove('contact-list');}
nextClassList.remove('block-item');});}
if(!backwardsClasses.current&&!backwardsClasses.next&&callback){setTimeout(callback,0);}else{waitForAnimation(current,callback);}
_currentView=nextView.view;navigationStack._zIndex=nextView.zIndex;};this.home=function home(callback){if(this.stack.length<2){if(typeof callback==='function'){setTimeout(callback,0);}
return;}
while(this.stack.length>1){this.back(callback);}};this.currentView=function currentView(){return _currentView!=null?_currentView:'';};};'use strict';var contacts=window.contacts||{};contacts.List=(function(){var _,groupsList,loaded=false,cancel,contactsListView,fastScroll,scrollable,settingsView,noContacts,imgLoader=null,needImgLoaderReload=false,orderByLastName=null,photoTemplate,headers={},loadedContacts={},viewHeight=-1,rowsPerPage=-1,monitor=null,loading=false,cancelLoadCB=null,photosById={},clonableSelectCheck=null,deselectAll=null,selectAll=null,selectAllPending=false,inSelectMode=false,selectForm=null,selectActionButton=null,selectMenu=null,standardMenu=null,groupList=null,searchList=null,currentlySelected=0,selectNavigationController=null,boundSelectAction4Select=null,boundSelectAction4Close=null,rowsOnScreen={},selectedContacts={},favorites=[];var ORDER_KEY='order.lastname';var ORDER_BY_FAMILY_NAME='familyName';var ORDER_BY_GIVEN_NAME='givenName';var MAX_INT=0x7fffffff;var GROUP_LETTERS={'favorites':'','und':'#'};var GROUP_ORDER=(function getGroupOrder(){var letters='ABCDEFGHIJKLMNOPQRSTUVWXYZ'+'ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩ'+'АБВГДЂЕЁЖЗИЙЈКЛЉМНЊОПРСТЋУФХЦЧЏШЩЭЮЯ';var order={'favorites':0};for(var i=0;i<letters.length;i++){order[letters[i]]=i+1;}
order['und']=i+1;return order;})();var NOP_FUNCTION=function(){};var onscreen=function(row){var id=row.dataset.uuid;var group=row.dataset.group;if(!id||!group){return;}
rowsOnScreen[id]=rowsOnScreen[id]||{};rowsOnScreen[id][group]=row;monitor&&monitor.pauseMonitoringMutations();renderLoadedContact(row,id);updateRowStyle(row,true);renderPhoto(row,id);updateSingleRowSelection(row,id);if(imgLoader&&needImgLoaderReload){needImgLoaderReload=false;imgLoader.reload();}
monitor&&monitor.resumeMonitoringMutations(false);};var renderLoadedContact=function(el,id){if(el.dataset.rendered){return;}
id=id||el.dataset.uuid;var group=el.dataset.group;var contact=loadedContacts[id]?loadedContacts[id][group]:null;if(!contact){return;}
renderContact(contact,el);clearLoadedContact(el,id,group);};var clearLoadedContact=function(el,id,group){if(!el.dataset.rendered||!el.dataset.order||!el.dataset.search)
return;id=id||el.dataset.uuid;group=group||el.dataset.group;if(loadedContacts[id])
loadedContacts[id][group]=null;};var offscreen=function(row){var id=row.dataset.uuid;var group=row.dataset.group;if(!id||!group){return;}
if(rowsOnScreen[id]){delete rowsOnScreen[id][group];}
monitor&&monitor.pauseMonitoringMutations();updateRowStyle(row,false);releasePhoto(row);monitor&&monitor.resumeMonitoringMutations(false);};var init=function load(element,reset){_=navigator.mozL10n.get;cancel=document.getElementById('cancel-search'),contactsListView=document.getElementById('view-contacts-list'),fastScroll=document.querySelector('nav[data-type="scrollbar"]'),scrollable=document.querySelector('#groups-container');settingsView=document.querySelector('#view-settings .view-body-inner');noContacts=document.querySelector('#no-contacts');groupsList=document.getElementById('groups-list');groupsList.addEventListener('click',onClickHandler);initOrder();if(reset){resetDom();}};function hide(){contactsListView.classList.add('hide');if(monitor){monitor.pauseMonitoringMutations();}}
function show(){contactsListView.classList.remove('hide');needImgLoaderReload=true;if(monitor){monitor.resumeMonitoringMutations(true);}}
var NODE_SELECTOR='section:not(#section-group-favorites) > ol > li';var searchSource={getNodes:function(){var domNodes=contactsListView.querySelectorAll(NODE_SELECTOR);return Array.prototype.slice.call(domNodes);},getFirstNode:function(){return contactsListView.querySelector(NODE_SELECTOR);},getNextNode:function(contact){var out=contact.nextElementSibling;var nextParent=contact.parentNode.parentNode.nextElementSibling;while(!out&&nextParent){out=nextParent.querySelector('ol > li:first-child');nextParent=nextParent.nextElementSibling;}
return out;},expectMoreNodes:function(){return loading;},clone:function(node){var id=node.dataset.uuid;renderLoadedContact(node,id);updateRowStyle(node,true);updateSingleRowSelection(node,id);var out=node.cloneNode(true);renderPhoto(out,id,true);return out;},getNodeById:function(id){return contactsListView.querySelector('[data-uuid="'+id+'"]');},getSearchText:function(node){renderSearchString(node);return node.dataset.search;},click:onClickHandler};var initSearch=function initSearch(callback){contacts.Search.init(searchSource,true,selectNavigationController);if(callback){callback();}};var initAlphaScroll=function initAlphaScroll(){var overlay=document.querySelector('nav[data-type="scrollbar"] p');var jumper=document.querySelector('nav[data-type="scrollbar"] ol');var params={overlay:overlay,jumper:jumper,groupSelector:'#group-',scrollToCb:scrollToCb};utils.alphaScroll.init(params);};var scrollToCb=function scrollCb(domTarget,group){if(domTarget.offsetTop>0)
scrollable.scrollTop=domTarget.offsetTop;};var load=function load(contacts,forceReset){var onError=function(){console.log('ERROR Retrieving contacts');};var complete=function complete(){initOrder(function onInitOrder(){getContactsByGroup(onError,contacts);});};if(loaded||forceReset){resetDom(complete);return;}
complete();};function getFbUid(devContact){var out;if(Array.isArray(devContact.category)){var idx=devContact.category.indexOf('facebook');if(idx!==-1){out=devContact.category[idx+2];}}
return out;}
var initOrder=function initOrder(callback){callback=callback||function(){};if(orderByLastName!==null){callback();return;}
var config=utils.cookie.load();if(config){orderByLastName=config.order;callback();return;}
var req=utils.config.load('/contacts/config.json');req.onload=function configReady(configData){orderByLastName=(configData.defaultContactsOrder===ORDER_BY_FAMILY_NAME?true:false);utils.cookie.update({order:orderByLastName});callback();};req.onerror=function configError(){window.console.error('Error while reading configuration file');orderByLastName=utils.cookie.getDefault('order');utils.cookie.update({order:orderByLastName});callback();};};var renderGroupHeader=function renderGroupHeader(group,letter){var letteredSection=document.createElement('section');letteredSection.id='section-group-'+group;letteredSection.className='group-section';var title=document.createElement('header');title.id='group-'+group;title.className='hide';var letterAbbr=document.createElement('abbr');letterAbbr.setAttribute('title','Contacts listed '+group);letterAbbr.textContent=letter;title.appendChild(letterAbbr);var contactsContainer=document.createElement('ol');contactsContainer.id='contacts-list-'+group;contactsContainer.dataset.group=group;letteredSection.appendChild(title);letteredSection.appendChild(contactsContainer);headers[group]=contactsContainer;if(groupsList.children.length===0){groupsList.appendChild(letteredSection);return;}
var order=GROUP_ORDER[group];if(typeof order!=='number'){groupsList.appendChild(letteredSection);return;}
for(var i=groupsList.children.length-1;i>=0;--i){var node=groupsList.children[i];var cmpGroup=node.lastChild.dataset.group;var cmpOrder=GROUP_ORDER[cmpGroup];if(cmpOrder<=order){var next=node.nextSibling;if(next){groupsList.insertBefore(letteredSection,next);}else{groupsList.appendChild(letteredSection);}
break;}}
if(i<0){groupsList.insertBefore(letteredSection,groupsList.firstChild);}};function getGroupList(group){var list=headers[group];if(list){return list;}
var letter=GROUP_LETTERS[group];if(typeof letter!=='string'){letter=group;}
renderGroupHeader(group,letter);return headers[group];}
var renderContact=function renderContact(contact,container){container=container||createPlaceholder(contact);var fbUid=getFbUid(contact);if(fbUid){container.dataset.fbUid=fbUid;}
container.className='contact-item';var timestampDate=contact.updated||contact.published||new Date();container.dataset.updated=timestampDate.getTime();var check=getSelectCheck(contact.id);container.appendChild(check);var display=getDisplayName(contact);var nameElement=getHighlightedName(display);container.appendChild(nameElement);renderOrg(contact,container,true);container.dataset.rendered=true;return container;};var renderSearchString=function renderSearchString(node,contact){if(node.dataset.search)
return;contact=contact||loadedContacts[node.dataset.uuid][node.dataset.group];if(!contact)
return;var display=getDisplayName(contact);node.dataset.search=getSearchString(contact,display);clearLoadedContact(node,contact.id,node.dataset.group);};var renderOrderString=function renderOrderString(node,contact){if(node.dataset.order)
return;contact=contact||loadedContacts[node.dataset.uuid][node.dataset.group];if(!contact)
return;var display=getDisplayName(contact);node.dataset.order=getStringToBeOrdered(contact,display);clearLoadedContact(node,contact.id,node.dataset.group);};var createPlaceholder=function createPlaceholder(contact,group){var ph=document.createElement('li');ph.dataset.uuid=contact.id;var group=group||getFastGroupName(contact);var order=null;if(!group){order=getStringToBeOrdered(contact);group=getGroupNameByOrderString(order);}
ph.dataset.group=group;var display=getDisplayName(contact);if(!display.modified&&order)
ph.dataset.order=order;return ph;};var getStringValue=function getStringValue(contact,field){if(contact[field]&&contact[field][0])
return String(contact[field][0]).trim();return null;};var getSearchString=function getSearchString(contact,display){var display=display||contact;var searchInfo=[];var searchable=['givenName','familyName'];searchable.forEach(function(field){var value=getStringValue(display,field);if(value){searchInfo.push(value);}});var value=getStringValue(contact,'org');if(value){searchInfo.push(value);}
if(contact.tel&&contact.tel.length){for(var i=contact.tel.length-1;i>=0;i--){var current=contact.tel[i];searchInfo.push(current.value);}}
var escapedValue=Normalizer.escapeHTML(searchInfo.join(' '),true);return Normalizer.toAscii(escapedValue);};function getHighlightedName(contact,ele){if(!ele){ele=document.createElement('p');}
ele.classList.add('contact-text');var givenName=(contact.givenName&&contact.givenName[0])||'';var familyName=(contact.familyName&&contact.familyName[0])||'';function createStrongTag(content){var fs=document.createElement('strong');fs.textContent=content;return fs;}
if(orderByLastName){ele.appendChild(document.createTextNode(givenName+' '));ele.appendChild(createStrongTag(familyName));}else{ele.appendChild(createStrongTag(givenName));ele.appendChild(document.createTextNode(' '+familyName));}
return ele;}
function buildSocialMarks(category){var marks=[];if(category.indexOf('facebook')!==-1){marks.push(markAsFb(createSocialMark()));}
if(category.indexOf('twitter')!==-1){marks.push(markAsTw(createSocialMark()));}
return marks;}
function createSocialMark(){var span=document.createElement('span');span.classList.add('icon-social');return span;}
function markAsFb(ele){ele.classList.add('icon-fb');return ele;}
function markAsTw(ele){ele.classList.add('icon-tw');return ele;}
var CHUNK_SIZE=20;var _isFirstChunk=true;function loadChunk(chunk){if(_isFirstChunk){var childNodes=document.getElementById('groups-list').childNodes;for(var i=0;i<childNodes.length;i++){if(childNodes[i].id!=='section-group-favorites'){childNodes[i].parentNode.removeChild(childNodes[i]);}}
_isFirstChunk=false;PerformanceTestingHelper.dispatch('first-chunk');}
var nodes=[];for(var i=0,n=chunk.length;i<n;++i){if(i===getRowsPerPage()){notifyAboveTheFold();}
var newNodes=appendToLists(chunk[i]);nodes.push.apply(nodes,newNodes);}
if(i<getRowsPerPage()){notifyAboveTheFold();}
if(contacts.Search&&contacts.Search.appendNodes){contacts.Search.appendNodes(nodes);}}
var notifiedAboveTheFold=false;var aboveTheFoldHTML='';function notifyAboveTheFold(){if(notifiedAboveTheFold)
return;aboveTheFoldHTML=document.getElementById('groups-list').innerHTML;localStorage.setItem('first-chunk',aboveTheFoldHTML);notifiedAboveTheFold=true;PerformanceTestingHelper.dispatch('above-the-fold-ready');var vm_file='/shared/js/tag_visibility_monitor.js';LazyLoader.load([vm_file],function(){var scrollMargin=~~(getViewHeight()*1.5);var scrollDelta=~~(scrollMargin/15);monitor=monitorTagVisibility(scrollable,'li',scrollMargin,scrollDelta,onscreen,offscreen);});}
function monitorListDomChanges(callback){var ele=document.getElementById('groups-list');var observer=new MutationObserver(function(mutations){mutations.forEach(function(m){if(m.type!=='childList'){return;}
var dirty=[m.addedNodes,m.removedNodes].some(function(nodes){return[].some.call(nodes,function(n){return n instanceof HTMLLIElement;});});if(dirty){callback();}});});function start(){observer.observe(ele,{childList:true,subtree:true});}
function stop(){observer.disconnect();}
window.addEventListener('start-batch-import',stop);window.addEventListener('finish-batch-import',function(){start();callback();});start();}
function getHtmlAboveTheFold(){var groupList=document.getElementById('groups-list');var incl=[].slice.call(groupList.querySelectorAll('li'),0,getRowsPerPage());var uuids=incl.map(function(li){return li.dataset.uuid;});var res=incl.map(function(n){return n.dataset.group;}).filter(function(value,index,self){return self.indexOf(value)===index;}).map(function(groupId){var groupNode=groupList.querySelector('#section-group-'+groupId).cloneNode(true);[].forEach.call(groupNode.querySelectorAll('li'),function(li){if(uuids.indexOf(li.dataset.uuid)===-1){li.parentNode.removeChild(li);}});return groupNode.outerHTML;}).join('');return res;}
function getViewHeight(config){if(viewHeight<0){config=config||utils.cookie.load();if(config&&config.viewHeight>-1){viewHeight=config.viewHeight;}else{viewHeight=scrollable.getBoundingClientRect().height;utils.cookie.update({viewHeight:viewHeight});}}
return viewHeight;}
function getRowsPerPage(){if(rowsPerPage<0){var config=utils.cookie.load();if(config&&config.rowsPerPage>-1){rowsPerPage=config.rowsPerPage;}}
if(rowsPerPage<0){return MAX_INT;}
return rowsPerPage;}
function setRowsPerPage(row){if(rowsPerPage>-1){return;}
var rowHeight=row.getBoundingClientRect().height;rowsPerPage=Math.ceil(getViewHeight()/rowHeight);utils.cookie.update({rowsPerPage:rowsPerPage});}
function appendToLists(contact){updatePhoto(contact);var ph=createPlaceholder(contact);if(isFavorite(contact))
favorites.push(contact);var nodes=[];ph=appendToList(contact,ph.dataset.group,ph);nodes.push(ph);ph=null;selectedContacts[contact.id]=selectAllPending;return nodes;}
function appendToList(contact,group,ph){ph=ph||createPlaceholder(contact,group);var list=getGroupList(group);if(list.children.length<getRowsPerPage()){renderContact(contact,ph);}
if(!loadedContacts[contact.id])
loadedContacts[contact.id]={};loadedContacts[contact.id][group]=contact;list.appendChild(ph);if(list.children.length===1){showGroupByList(list);setRowsPerPage(list.firstChild);}
return ph;}
var onListRendered=function onListRendered(){selectAllPending=false;notifyAboveTheFold();PerformanceTestingHelper.dispatch('startup-path-done');fb.init(function contacts_init(){if(fb.isEnabled){Contacts.loadFacebook(NOP_FUNCTION);}
lazyLoadImages();loaded=true;});monitorListDomChanges(function(){var newAboveTheFold=getHtmlAboveTheFold();if(newAboveTheFold!==aboveTheFoldHTML){aboveTheFoldHTML=newAboveTheFold;localStorage.setItem('first-chunk',aboveTheFoldHTML);}});var favGroup=document.querySelector('#section-group-favorites');if(favGroup){favGroup.parentNode.removeChild(favGroup);}
favorites.forEach(addToFavorites);favorites=[];};var addToFavorites=function addToFavorites(contactOrNode){var list=getGroupList('favorites');var cloned=contactOrNode instanceof HTMLElement?contactOrNode.cloneNode(true):renderContact(contactOrNode);cloned.dataset.group='favorites';if(!(contactOrNode instanceof HTMLElement)){if(!loadedContacts[cloned.dataset.uuid]){loadedContacts[cloned.dataset.uuid]={};}
loadedContacts[cloned.dataset.uuid]['favorites']=contactOrNode;}
addToGroup(cloned,list);};var isFavorite=function isFavorite(contact){return contact.category&&contact.category.indexOf('favorite')!=-1;};var lazyLoadImages=function lazyLoadImages(){LazyLoader.load(['/contacts/js/utilities/image_loader.js','/contacts/js/fb_resolver.js'],function(){if(!imgLoader){imgLoader=new ImageLoader('#groups-container','li');imgLoader.setResolver(fb.resolver);}
imgLoader.reload();});};var dispatchCustomEvent=function dispatchCustomEvent(eventName){var event=new CustomEvent(eventName);window.dispatchEvent(event);};var updatePhoto=function updatePhoto(contact,id){id=id||contact.id;var prevPhoto=photosById[id];var newPhoto=ContactPhotoHelper.getThumbnail(contact);if((!prevPhoto&&!newPhoto)||(prevPhoto===newPhoto)){return false;}
if(newPhoto){photosById[id]=newPhoto;}
else{delete photosById[id];}
return true;};var hasPhoto=function hasPhoto(id){return!!photosById[id];};function setImageURL(img,photo,asClone){var oldURL=img.dataset.src;if(oldURL){if(!asClone){window.URL.revokeObjectURL(oldURL);}
img.dataset.src='';}
if(photo){try{img.dataset.src=window.URL.createObjectURL(photo);}catch(err){console.warn('Failed to create URL for contacts image blob: '+photo+', error: '+err);}}}
var renderPhoto=function renderPhoto(link,id,asClone){id=id||link.dataset.uuid;var photo=photosById[id];if(!photo){return;}
var img=link.querySelector('aside > span[data-type=img]');if(img){setImageURL(img,photo,asClone);return;}
if(!photoTemplate){photoTemplate=document.createElement('aside');photoTemplate.className='pack-end';var img=document.createElement('span');img.dataset.type='img';photoTemplate.appendChild(img);}
var figure=photoTemplate.cloneNode(true);var img=figure.children[0];setImageURL(img,photo);link.insertBefore(figure,link.children[0]);return;};var releasePhoto=function releasePhoto(el){if(!imgLoader){return;}
var img=imgLoader.releaseImage(el);if(!img){return;}
setImageURL(img,null);};var renderOrg=function renderOrg(contact,link,add){if(!contact.org||!contact.org.length||contact.org[0]===''||contact.org[0]===contact.givenName){return;}
if(add){addOrgMarkup(link,contact.org[0]);return;}
var org=link.lastElementChild.querySelector('span.org');org.textContent=contact.org[0];};function renderFbData(contact,link){var meta;var elements=link.getElementsByTagName('p');if(elements.length==1){meta=addOrgMarkup(link);}else{meta=elements[1];}
var mark=markAsFb(createSocialMark());var org=meta.querySelector('span.org');meta.insertBefore(mark,org);if(!contact.org||!contact.org.length){mark.classList.add('notorg');}else{renderOrg(contact,link);}}
var addOrgMarkup=function addOrgMarkup(link,content){var span=document.createElement('span');span.className='org';if(content){span.textContent=content;}
var meta=document.createElement('p');meta.classList.add('contact-text');meta.appendChild(span);link.appendChild(meta);return meta;};var toggleNoContactsScreen=function cl_toggleNoContacs(show){if(show&&ActivityHandler.currentlyHandling){var actName=ActivityHandler.activityName;if(actName=='pick'||actName=='update'){showNoContactsAlert();return;}}
if(show&&!ActivityHandler.currentlyHandling){noContacts.classList.remove('hide');return;}
noContacts.classList.add('hide');};var showNoContactsAlert=function showNoContactsAlert(){var msg=_('noContactsActivity');var noObject={title:_('ok'),isDanger:false,callback:function onNoClicked(){ConfirmDialog.hide();ActivityHandler.postCancel();}};Contacts.confirmDialog(null,msg,noObject);};function addToFavoriteList(favorite){var container=getGroupList('favorites');container.appendChild(favorite);if(container.children.length===1){showGroupByList(container);}}
var getContactsByGroup=function gCtByGroup(errorCb,contacts){if(!Contacts.asyncScriptsLoaded){window.addEventListener('asyncScriptsLoaded',function listener(){window.removeEventListener('asyncScriptsLoaded',listener);getContactsByGroup(errorCb,contacts);});return;}
notifiedAboveTheFold=false;if(contacts){if(!contacts.length){toggleNoContactsScreen(true);dispatchCustomEvent('listRendered');return;}
toggleNoContactsScreen(false);loadChunk(contacts);onListRendered();dispatchCustomEvent('listRendered');return;}
getAllContacts(errorCb,loadChunk);};var getContactById=function(contactID,successCb,errorCb){var options={filterBy:['id'],filterOp:'equals',filterValue:contactID};var request=navigator.mozContacts.find(options);request.onsuccess=function findCallback(e){var result=e.target.result[0];if(!fb.isFbContact(result)){successCb(result);return;}
var fbContact=new fb.Contact(result);var fbReq=fbContact.getData();fbReq.onsuccess=function(){successCb(result,fbReq.result);};fbReq.onerror=successCb.bind(null,result);};if(typeof errorCb==='function'){request.onerror=errorCb;}};var getAllContacts=function cl_getAllContacts(errorCb,successCb){loading=true;initOrder(function onInitOrder(){var sortBy=(orderByLastName===true?'familyName':'givenName');var options={sortBy:sortBy,sortOrder:'ascending'};var cursor=navigator.mozContacts.getAll(options);var successCb=successCb||loadChunk;var num=0;var chunk=[];cursor.onsuccess=function onsuccess(evt){if(cancelLoadCB){loading=false;var cb=cancelLoadCB;cancelLoadCB=null;return cb();}
var contact=evt.target.result;if(contact){chunk.push(contact);if(num&&(num%CHUNK_SIZE==0)){successCb(chunk);chunk=[];}
num++;cursor.continue();}else{if(chunk.length)
successCb(chunk);var showNoContacs=(num===0);toggleNoContactsScreen(showNoContacs);onListRendered();dispatchCustomEvent('listRendered');loading=false;}};cursor.onerror=errorCb;});};var addToList=function addToList(contact){var renderedNode=renderContact(contact);renderSearchString(renderedNode,contact);renderOrderString(renderedNode,contact);if(updatePhoto(contact))
renderPhoto(renderedNode,contact.id);var list=getGroupList(renderedNode.dataset.group);addToGroup(renderedNode,list);toggleNoContactsScreen(false);if(imgLoader){needImgLoaderReload=true;}
selectedContacts[contact.id]=selectAllPending||(selectAll&&selectAll.disabled);return renderedNode;};var hasName=function hasName(contact){return(Array.isArray(contact.givenName)&&contact.givenName[0]&&contact.givenName[0].trim())||(Array.isArray(contact.familyName)&&contact.familyName[0]&&contact.familyName[0].trim());};var getDisplayName=function getDisplayName(contact){if(hasName(contact))
return{givenName:contact.givenName,familyName:contact.familyName};var givenName=[];if(contact.org&&contact.org.length>0){givenName.push(contact.org[0]);}else if(contact.tel&&contact.tel.length>0){givenName.push(contact.tel[0].value);}else if(contact.email&&contact.email.length>0){givenName.push(contact.email[0].value);}else{givenName.push(_('noName'));}
return{givenName:givenName,modified:true};};function searchNodes(nodes,name){var len=nodes.length;var begin=0;var end=len;var comp=0;var target=len;while(begin<=end){var target=~~((begin+end)/2);if(target>=len){break;}
var targetNode=nodes[target];renderOrderString(targetNode);var targetName=targetNode.dataset.order;comp=name.localeCompare(targetName);if(comp<0){end=target-1;}else if(comp>0){begin=target+1;}else{return target;}}
if(target>=len){return len;}
if(comp<=0){return target;}
return target+1;}
var addToGroup=function addToGroup(renderedNode,list){renderOrderString(renderedNode);var newLi=renderedNode;var cName=newLi.dataset.order;var liElems=list.getElementsByTagName('li');var insertAt=searchNodes(liElems,cName);if(insertAt<liElems.length){list.insertBefore(newLi,liElems[insertAt]);}else{list.appendChild(newLi);}
if(list.children.length===1){showGroupByList(list);}
return list.children.length;};var hideGroup=function hideGroup(group){var groupTitle=getGroupList(group).parentNode.children[0];groupTitle.classList.add('hide');};var showGroupByList=function showGroupByList(current){var groupTitle=current.parentNode.children[0];groupTitle.classList.remove('hide');};var remove=function remove(id){if(!(id in selectedContacts)){return;}
var items=groupsList.querySelectorAll('li[data-uuid=\"'+id+'\"]');Array.prototype.forEach.call(items,function removeItem(item){var ol=item.parentNode;ol.removeChild(item);if(ol.children.length<1){hideGroup(ol.dataset.group);}});delete photosById[id];var selector='section header:not(.hide)';var visibleElements=groupsList.querySelectorAll(selector);var showNoContacts=visibleElements.length===0;toggleNoContactsScreen(showNoContacts);delete selectedContacts[id];};var getStringToBeOrdered=function getStringToBeOrdered(contact,display){var ret=[];display=display||contact;var familyName,givenName;familyName=getStringValue(display,'familyName')||'';givenName=getStringValue(display,'givenName')||'';var first=givenName,second=familyName;if(orderByLastName){first=familyName;second=givenName;}
ret.push(first);ret.push(second);if(first!=''||second!='')
return Normalizer.toAscii(ret.join('')).toUpperCase().trim();ret.push(contact.org);ret.push(contact.tel&&contact.tel.length>0?contact.tel[0].value.trim():'');ret.push(contact.email&&contact.email.length>0?contact.email[0].value.trim():'');ret.push('#');return Normalizer.toAscii(ret.join('')).toUpperCase().trim();};var getFastGroupName=function getFastGroupName(contact){var field=orderByLastName?'familyName':'givenName';var value=contact[field]?contact[field][0]:null;if(!value||!value.length){return null;}
var ret=value.charAt(0).toUpperCase();if(!(ret in GROUP_ORDER)){return null;}
return ret;};var getGroupNameByOrderString=function getGroupNameByOrderString(order){var ret=order.charAt(0);if(!(ret in GROUP_ORDER)){ret='und';}
return ret;};var refresh=function refresh(idOrContact,callback){if(typeof(idOrContact)!=='string'){refreshContact(idOrContact,null,callback);return;}
getContactById(idOrContact,function(contact,fbData){var enrichedContact=null;if(fb.isFbContact(contact)){var fbContact=new fb.Contact(contact);enrichedContact=fbContact.merge(fbData);}
refreshContact(contact,enrichedContact,callback);});};function refreshContact(contact,enriched,callback){remove(contact.id);var node=addToList(contact,enriched);if(node&&isFavorite(contact)){addToFavorites(node);}
if(callback)
callback(contact.id);};var callbacks=[];var handleClick=function handleClick(callback){callbacks.push(callback);};var clearClickHandlers=function clearClickHandlers(){callbacks=[];};function onClickHandler(evt){var target=evt.target;var dataset=target.dataset||{};var parentDataset=target.parentNode?(target.parentNode.dataset||{}):{};var uuid=dataset.uuid||parentDataset.uuid;if(uuid){callbacks.forEach(function(callback){callback(uuid);});}
evt.preventDefault();}
var resetDom=function resetDom(cb){if(loading){cancelLoadCB=resetDom.bind(null,cb);return;}
utils.dom.removeChildNodes(groupsList);headers={};loadedContacts={};loaded=false;_isFirstChunk=true;if(cb)
cb();};var setOrderByLastName=function setOrderByLastName(value){orderByLastName=value;};var getSelectCheck=function getSelectCheck(uuid){if(clonableSelectCheck===null){clonableSelectCheck=buildSelectCheck();}
var result=clonableSelectCheck.cloneNode(true);var check=result.firstChild;check.setAttribute('value',uuid);return result;};var buildSelectCheck=function buildSelectCheck(){var label=document.createElement('label');label.classList.add('contact-checkbox');label.classList.add('pack-checkbox');var input=document.createElement('input');input.name='selectIds[]';input.type='checkbox';label.appendChild(input);var span=document.createElement('span');label.appendChild(span);return label;};var selectAction=function selectAction(action){if(action==null){exitSelectMode();return;}
var selectionPromise=createSelectPromise();if(selectAllPending){action(selectionPromise);selectionPromise.resolve();return;}
var ids=[];for(var id in selectedContacts){if(selectedContacts[id]){ids.push(id);}}
if(ids.length==0){return;}
action(selectionPromise);selectionPromise.resolve(ids);};var handleSelection=function handleSelection(evt){var action=null;if(evt){evt.preventDefault();action=evt.target.id;}
var selectAllDisabled=false;var deselectAllDisabled=false;currentlySelected=countSelectedContacts();switch(action){case'deselect-all':selectAllPending=false;deselectAllContacts();currentlySelected=0;deselectAllDisabled=true;break;case'select-all':selectAllPending=true&&!loaded;selectAllContacts();currentlySelected=contacts.List.total;selectAllDisabled=true;break;default:selectAllDisabled=currentlySelected==contacts.List.total;deselectAllDisabled=currentlySelected==0;break;}
updateRowsOnScreen();selectActionButton.disabled=currentlySelected==0;selectAll.disabled=selectAllDisabled;deselectAll.disabled=deselectAllDisabled;};var createSelectPromise=function createSelectPromise(){var promise={canceled:false,_selected:[],resolved:false,successCb:null,errorCb:null,resolve:function resolve(values){var self=this;setTimeout(function onResolve(){if(values){self._selected=values;self.resolved=true;if(self.successCb){self.successCb(values);}
return;}
var notSelectedIds={};for(var id in selectedContacts){if(!selectedContacts[id]){notSelectedIds[id]=true;}}
var notSelectedCount=Object.keys(notSelectedIds).length;var request=navigator.mozContacts.find({});request.onsuccess=function onAllContacts(){request.result.forEach(function onContact(contact){if(notSelectedCount==0||notSelectedIds[contact.id]==undefined){self._selected.push(contact.id);}});self.resolved=true;if(self.successCb){self.successCb(self._selected);}};request.onerror=function onError(){self.reject();};},0);},reject:function reject(){this.canceled=true;if(this.errorCb){this.errorCb();}},set onsuccess(callback){if(this.resolved){callback(this._selected);}else{this.successCb=callback;}},set onerror(callback){if(this.canceled){callback();}else{this.errorCb=callback;}}};return promise;};function toggleMenus(){selectMenu.classList.toggle('hide');standardMenu.classList.toggle('hide');}
var selectFromList=function selectFromList(title,action,callback,navigationController,transitionType){inSelectMode=true;selectNavigationController=navigationController;if(selectForm===null){selectForm=document.getElementById('selectable-form');selectMenu=document.getElementById('select-menu');standardMenu=document.getElementById('standard-menu');selectActionButton=document.getElementById('select-action');selectActionButton.disabled=true;selectAll=document.getElementById('select-all');selectAll.addEventListener('click',handleSelection);deselectAll=document.getElementById('deselect-all');deselectAll.addEventListener('click',handleSelection);}
scrollable.classList.add('selecting');fastScroll.classList.add('selecting');utils.alphaScroll.toggleFormat('short');toggleMenus();selectActionButton.textContent=title;selectActionButton.removeEventListener('click',boundSelectAction4Select);boundSelectAction4Select=selectAction.bind(null,action);selectActionButton.addEventListener('click',boundSelectAction4Select);selectForm.classList.remove('hide');if(groupList==null){groupList=document.getElementById('groups-list');}
groupList.classList.add('selecting');if(searchList==null){searchList=document.getElementById('search-list');}
searchList.classList.add('selecting');updateRowsOnScreen();var close=document.getElementById('cancel_activity');close.removeEventListener('click',Contacts.cancel);if(!boundSelectAction4Close){boundSelectAction4Close=selectAction.bind(null,null);}
close.addEventListener('click',boundSelectAction4Close);close.classList.remove('hide');clearClickHandlers();handleClick(function handleSelectClick(id,row){selectedContacts[id]=!selectedContacts[id];updateRowSelection([id]);handleSelection(null);if(contacts.Search&&contacts.Search.isInSearchMode()){contacts.Search.selectRow(id,selectedContacts[id]);}});if(callback){callback();}
selectNavigationController.go('view-contacts-list',transitionType);if(contacts.List.total==0){var emptyPromise=createSelectPromise();emptyPromise.resolve([]);}};var updateRowsOnScreen=function updateRowsOnScreen(){if(monitor!=null){monitor.pauseMonitoringMutations();}
var row;for(var id in rowsOnScreen){for(var group in rowsOnScreen[id]){row=rowsOnScreen[id][group];updateRowStyle(row,true);updateSingleRowSelection(row,id);}}
if(monitor!=null){monitor.resumeMonitoringMutations(false);}};var updateRowStyle=function updateRowStyle(row,onscreen){if(inSelectMode&&onscreen){if(!row.dataset.selectStyleSet){utils.dom.addClassToNodes(row,'.contact-checkbox','contact-checkbox-selecting');utils.dom.addClassToNodes(row,'.contact-text','contact-text-selecting');row.dataset.selectStyleSet=true;}}else if(row.dataset.selectStyleSet){utils.dom.removeClassFromNodes(row,'.contact-checkbox-selecting','contact-checkbox-selecting');utils.dom.removeClassFromNodes(row,'.contact-text-selecting','contact-text-selecting');delete row.dataset.selectStyleSet;}};var updateRowSelection=function updateRowSelection(idToUpdate){for(var id in rowsOnScreen){for(var group in rowsOnScreen[id]){var row=rowsOnScreen[id][group];if(idToUpdate===id){updateSingleRowSelection(row,id);}}}};var updateSingleRowSelection=function updateSingleRowSelection(row,id){var id=id||row.dataset.uuid;var check=row.querySelector('input[value="'+id+'"]');if(!check){return;}
check.checked=!!selectedContacts[id];};var selectAllContacts=function selectAllContacts(){for(var id in selectedContacts){selectedContacts[id]=true;}};var deselectAllContacts=function deselectAllContacts(){for(var id in selectedContacts){selectedContacts[id]=false;}};var countSelectedContacts=function countSelectedContacts(){var counter=0;for(var id in selectedContacts){if(selectedContacts[id]){counter++;}}
return counter;};var exitSelectMode=function exitSelectMode(canceling){inSelectMode=false;selectAllPending=false;currentlySelected=0;selectNavigationController.back();deselectAllContacts();selectForm.classList.add('hide');deselectAll.disabled=true;selectAll.disabled=false;selectActionButton.disabled=true;toggleMenus();groupList.classList.remove('selecting');searchList.classList.remove('selecting');scrollable.classList.remove('selecting');fastScroll.classList.remove('selecting');utils.alphaScroll.toggleFormat('normal');updateRowsOnScreen();clearClickHandlers();handleClick(Contacts.showContactDetail);var close=document.getElementById('cancel_activity');close.removeEventListener('click',boundSelectAction4Close);close.addEventListener('click',Contacts.cancel);close.classList.add('hide');};var refreshFb=function resfreshFb(uid){var selector='[data-fb-uid="'+uid+'"]';var node=document.querySelector(selector);if(node){if(node.dataset.uuid in rowsOnScreen){contacts.List.refresh(node.dataset.uuid);}}};return{'init':init,'load':load,'refresh':refresh,'refreshFb':refreshFb,'getContactById':getContactById,'getAllContacts':getAllContacts,'handleClick':handleClick,'hide':hide,'show':show,'initAlphaScroll':initAlphaScroll,'initSearch':initSearch,'remove':remove,'loaded':loaded,'clearClickHandlers':clearClickHandlers,'setOrderByLastName':setOrderByLastName,'renderPhoto':renderPhoto,'updatePhoto':updatePhoto,'hasPhoto':hasPhoto,'renderFbData':renderFbData,'getHighlightedName':getHighlightedName,'selectFromList':selectFromList,'exitSelectMode':exitSelectMode,'resetDom':resetDom,get chunkSize(){return CHUNK_SIZE;},get total(){return Object.keys(selectedContacts).length;},get isSelecting(){return inSelectMode;}};})();;'use strict';var _;var TAG_OPTIONS;var COMMS_APP_ORIGIN=location.origin;var asyncScriptsLoaded;var SCALE_RATIO=window.innerWidth/320;var Contacts=(function(){var navigation=new navigationStack('view-contacts-list');var goToForm=function edit(){navigation.go('view-contact-form','popup');};var contactTag,settings,settingsButton,cancelButton,addButton,appTitleElement,asyncScriptsLoaded=false;var settingsReady=false;var detailsReady=false;var formReady=false;var displayed=false;var currentContact={},currentFbContact;var contactsList;var contactsDetails;var contactsForm;var customTag,customTagReset,tagDone,tagCancel,lazyLoadedTagsDom=false;function showEditForm(facebookData,params){contactsForm.render(currentContact,goToForm,facebookData,params['fromUpdateActivity']);showApp();}
var checkUrl=function checkUrl(){var hasParams=window.location.hash.split('?');var hash=hasParams[0];var sectionId=hash.substr(1,hash.length)||'';var cList=contacts.List;var params=hasParams.length>1?utils.extractParams(hasParams[1]):-1;switch(sectionId){case'view-contact-details':initContactsList();initDetails(function onInitDetails(){if(params==-1||!('id'in params)){console.log('Param missing');return;}
var id=params['id'];cList.getContactById(id,function onSuccess(savedContact){currentContact=savedContact;contactsDetails.render(currentContact,TAG_OPTIONS);if(params['tel'])
contactsDetails.reMark('tel',params['tel']);navigation.go(sectionId,'right-left');showApp();},function onError(){console.error('Error retrieving contact');});});break;case'view-contact-form':initForm(function onInitForm(){if(params==-1||!('id'in params)){contactsForm.render(params,goToForm);showApp();}else{if('id'in params){var id=params['id'];cList.getContactById(id,function onSuccess(savedContact){currentContact=savedContact;if('extras'in params){addExtrasToContact(params['extras']);}
if(fb.isFbContact(savedContact)){var fbContact=new fb.Contact(savedContact);var req=fbContact.getDataAndValues();req.onsuccess=function(){showEditForm(req.result,params);};req.onerror=function(){console.error('Error retrieving FB information');showEditForm(null,params);};}
else{showEditForm(null,params);}},function onError(){console.error('Error retrieving contact to be edited');contactsForm.render(null,goToForm);showApp();});}}});break;case'add-parameters':initContactsList();initForm(function onInitForm(){navigation.home();if(ActivityHandler.currentlyHandling){selectList(params,true);}
showApp();});break;case'home':navigation.home();showApp();break;default:showApp();}};var showApp=function showApp(){if(displayed){return;}
document.body.classList.remove('hide');displayed=true;};var addExtrasToContact=function addExtrasToContact(extrasString){try{var extras=JSON.parse(decodeURIComponent(extrasString));for(var type in extras){var extra=extras[type];if(currentContact[type]){if(Array.isArray(currentContact[type])){var joinArray=currentContact[type].concat(extra);currentContact[type]=joinArray;}else{currentContact[type]=extra;}}else{currentContact[type]=Array.isArray(extra)?extra:[extra];}}}catch(e){console.error('Extras malformed');return null;}};var initContainers=function initContainers(){settings=document.getElementById('view-settings');settingsButton=document.getElementById('settings-button');cancelButton=document.getElementById('cancel_activity');addButton=document.getElementById('add-contact-button');appTitleElement=cancelButton.parentNode.querySelector('h1');TAG_OPTIONS={'phone-type':[{type:'mobile',value:_('mobile')},{type:'home',value:_('home')},{type:'work',value:_('work')},{type:'personal',value:_('personal')},{type:'faxHome',value:_('faxHome')},{type:'faxOffice',value:_('faxOffice')},{type:'faxOther',value:_('faxOther')},{type:'other',value:_('other')}],'email-type':[{type:'personal',value:_('personal')},{type:'home',value:_('home')},{type:'work',value:_('work')},{type:'other',value:_('other')}],'address-type':[{type:'current',value:_('current')},{type:'home',value:_('home')},{type:'work',value:_('work')}],'date-type':[{type:'birthday',value:_('birthday')},{type:'anniversary',value:_('anniversary')}]};};var onLocalized=function onLocalized(){init();addAsyncScripts();window.addEventListener('asyncScriptsLoaded',function onAsyncLoad(){asyncScriptsLoaded=true;window.removeEventListener('asyncScriptsLoaded',onAsyncLoad);if(contactsList){contactsList.initAlphaScroll();}
checkUrl();PerformanceTestingHelper.dispatch('init-finished');asyncScriptsLoaded=true;});};var init=function init(){_=navigator.mozL10n.get;initLanguages();initContainers();initEventListeners();window.addEventListener('hashchange',checkUrl);var config=utils.cookie.load();if(!config||!config.fbMigrated){LazyLoader.load('js/fb/datastore_migrator.js',function(){new DatastoreMigration().start();});}
else{window.console.info('FB Already migrated!!!');}};var initContactsList=function initContactsList(){if(contactsList)
return;contactsList=contactsList||contacts.List;var list=document.getElementById('groups-list');contactsList.init(list);getFirstContacts();contactsList.initAlphaScroll();contactsList.handleClick(contactListClickHandler);checkCancelableActivity();};var checkCancelableActivity=function cancelableActivity(){if(ActivityHandler.currentlyHandling){cancelButton.classList.remove('hide');addButton.classList.add('hide');settingsButton.classList.add('hide');var text=_('selectContact');if(appTitleElement.textContent!==text){appTitleElement.textContent=text;}}else if(contactsList&&!contactsList.isSelecting){cancelButton.classList.add('hide');addButton.classList.remove('hide');settingsButton.classList.remove('hide');var text=_('contacts');if(appTitleElement.textContent!==text){appTitleElement.textContent=text;}}};var initLanguages=function initLanguages(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;};var contactListClickHandler=function originalHandler(id){initDetails(function onDetailsReady(){contactsList.getContactById(id,function findCb(contact,fbContact){currentContact=contact;currentFbContact=fbContact;if(ActivityHandler.currentlyHandling){if(ActivityHandler.activityName=='pick'){ActivityHandler.dataPickHandler(currentFbContact||currentContact);}
return;}
contactsDetails.render(currentContact,TAG_OPTIONS,currentFbContact);if(contacts.Search&&contacts.Search.isInSearchMode()){navigation.go('view-contact-details','go-deeper-search');}else{navigation.go('view-contact-details','go-deeper');}});});};var updateContactDetail=function updateContactDetail(id){contactsList.getContactById(id,function findCallback(contact){currentContact=contact;contactsDetails.render(currentContact,TAG_OPTIONS);});};var selectList=function selectList(params,fromUpdateActivity){addButton.classList.add('hide');contactsList.clearClickHandlers();contactsList.handleClick(function addToContactHandler(id){var data={};if(params.hasOwnProperty('tel')){var phoneNumber=params['tel'];data['tel']=[{'value':phoneNumber,'carrier':null,'type':[TAG_OPTIONS['phone-type'][0].type]}];}
if(params.hasOwnProperty('email')){var email=params['email'];data['email']=[{'value':email,'type':[TAG_OPTIONS['email-type'][0].type]}];}
var hash='#view-contact-form?extras='+
encodeURIComponent(JSON.stringify(data))+'&id='+id;if(fromUpdateActivity)
hash+='&fromUpdateActivity=1';window.location.hash=hash;});};var getLength=function getLength(prop){if(!prop||!prop.length){return 0;}
return prop.length;};var updatePhoto=function updatePhoto(photo,dest){var background='';if(photo!=null){background='url('+URL.createObjectURL(photo)+')';}
dest.style.backgroundImage=background;dest.dataset.photoReady='true';};var isEmpty=function isEmpty(obj,fields){if(obj==null||typeof(obj)!='object'||!fields||!fields.length){return true;}
var attr;for(var i=0;i<fields.length;i++){attr=fields[i];if(obj[attr]){if(Array.isArray(obj[attr])){if(obj[attr].length>0){return false;}}else{return false;}}}
return true;};function showSelectTag(){var tagsList=document.getElementById('tags-list');var selectedTagType=contactTag.dataset.taglist;var options=TAG_OPTIONS[selectedTagType];var type=selectedTagType.split('-')[0];var isCustomTagVisible=(document.querySelector('[data-template]'+'.'+type+'-'+'template').dataset.custom!='false');options=ContactsTag.filterTags(type,contactTag,options);if(!customTag){customTag=document.querySelector('#custom-tag');customTag.addEventListener('keydown',handleCustomTag);customTag.addEventListener('touchend',handleCustomTag);}
if(!customTagReset){customTagReset=document.getElementById('custom-tag-reset');customTagReset.addEventListener('touchstart',handleCustomTagReset);}
if(!tagDone){tagDone=document.querySelector('#settings-done');tagDone.addEventListener('click',handleSelectTagDone);}
if(!tagCancel){tagCancel=document.querySelector('#settings-cancel');tagCancel.addEventListener('click',handleBack);}
for(var i in options){options[i].value=_(options[i].type);}
ContactsTag.setCustomTag(customTag);ContactsTag.setCustomTagVisibility(isCustomTagVisible);ContactsTag.fillTagOptions(tagsList,contactTag,options);navigation.go('view-select-tag','right-left');if(document.activeElement){document.activeElement.blur();}}
var goToSelectTag=function goToSelectTag(event){contactTag=event.currentTarget.children[0];var tagViewElement=document.getElementById('view-select-tag');if(!lazyLoadedTagsDom){LazyLoader.load(tagViewElement,function(){navigator.mozL10n.translate(tagViewElement);showSelectTag();lazyLoadedTagsDom=true;});}
else{showSelectTag();}};var sendSms=function sendSms(number){if(!ActivityHandler.currentlyHandling||ActivityHandler.activityName==='open')
SmsIntegration.sendSms(number);};var handleBack=function handleBack(){navigation.back();};var handleCancel=function handleCancel(){if(ActivityHandler.currentlyHandling){ActivityHandler.postCancel();navigation.home();}else{handleBack();}};var handleSelectTagDone=function handleSelectTagDone(){var prevValue=contactTag.textContent;ContactsTag.clickDone(function(){var valueModifiedEvent=new CustomEvent('ValueModified',{bubbles:true,detail:{prevValue:prevValue,newValue:contactTag.textContent}});contactTag.dispatchEvent(valueModifiedEvent);handleBack();});};var handleCustomTag=function handleCustomTag(ev){if(ev.keyCode===13){ev.preventDefault();}
ContactsTag.touchCustomTag();};var handleCustomTagReset=function handleCustomTagReset(ev){ev.preventDefault();if(customTag){customTag.value='';}};var sendEmailOrPick=function sendEmailOrPick(address){try{var activity=new MozActivity({name:'new',data:{type:'mail',URI:'mailto:'+address}});}catch(e){console.log('WebActivities unavailable? : '+e);}};var isUpdated=function isUpdated(contact1,contact2){return contact1.id==contact2.id&&(contact1.updated-contact2.updated)==0;};var showAddContact=function showAddContact(){showForm();};var loadFacebook=function loadFacebook(callback){if(!fbLoader.loaded){fb.init(function onInitFb(){window.addEventListener('facebookLoaded',function onFbLoaded(){window.removeEventListener('facebookLoaded',onFbLoaded);callback();});fbLoader.load();});}else{callback();}};var initForm=function c_initForm(callback){if(formReady){callback();}else{initDetails(function onDetails(){LazyLoader.load(['/contacts/js/utilities/image_thumbnail.js'],function(){Contacts.view('Form',function viewLoaded(){formReady=true;contactsForm=contacts.Form;contactsForm.init(TAG_OPTIONS);callback();});});});}};var initSettings=function c_initSettings(callback){if(settingsReady){callback();}else{Contacts.view('Settings',function viewLoaded(){LazyLoader.load(['/contacts/js/utilities/sim_dom_generator.js','/contacts/js/utilities/icc_handler.js'],function(){settingsReady=true;contacts.Settings.init();callback();});});}};var initDetails=function c_initDetails(callback){if(detailsReady){callback();}else{Contacts.view('Details',function viewLoaded(){var simPickerNode=document.getElementById('sim-picker');LazyLoader.load([simPickerNode],function(){navigator.mozL10n.translate(simPickerNode);detailsReady=true;contactsDetails=contacts.Details;contactsDetails.init();callback();});});}};var showForm=function c_showForm(edit,contact){currentContact=contact||currentContact;initForm(function onInit(){doShowForm(edit);});};var doShowForm=function c_doShowForm(edit){var contact=edit?currentContact:null;if(contact&&fb.isFbContact(contact)){var fbContact=new fb.Contact(contact);var req=fbContact.getDataAndValues();req.onsuccess=function(){contactsForm.render(contact,goToForm,req.result);};req.onerror=function(){contactsForm.render(contact,goToForm);};}
else{contactsForm.render(contact,goToForm);}};var setCurrent=function c_setCurrent(contact){currentContact=contact;};var showOverlay=function c_showOverlay(message,progressClass,textId){var out=utils.overlay.show(message,progressClass,textId);contacts.List.hide();return out;};var hideOverlay=function c_hideOverlay(){Contacts.utility('Overlay',function _loaded(){contacts.List.show();utils.overlay.hide();});};var showStatus=function c_showStatus(message){utils.status.show(message);};var showSettings=function showSettings(){initSettings(function onSettingsReady(){contacts.Settings.refresh();navigation.go('view-settings','popup');});};var stopPropagation=function stopPropagation(evt){evt.preventDefault();};var enterSearchMode=function enterSearchMode(evt){Contacts.view('Search',function viewLoaded(){contacts.List.initSearch(function onInit(){contacts.Search.enterSearchMode(evt);});});};var initEventListeners=function initEventListener(){utils.listeners.add({'#cancel_activity':handleCancel,'#add-contact-button':showAddContact,'#settings-button':showSettings,'#search-start':[{event:'click',handler:enterSearchMode}],'button[type="reset"]':stopPropagation});};var onLineChanged=function(){Contacts.view('Settings',function viewLoaded(){contacts.Settings.onLineChanged();});Contacts.view('Details',function viewLoaded(){contacts.Details.onLineChanged();});};var getFirstContacts=function c_getFirstContacts(){var onerror=function(){console.error('Error getting first contacts');};contactsList=contactsList||contacts.List;contactsList.getAllContacts(onerror);};var addAsyncScripts=function addAsyncScripts(){var lazyLoadFiles=['/contacts/js/utilities/templates.js','/contacts/js/contacts_shortcuts.js','/contacts/js/contacts_tag.js','/contacts/js/import_utils.js','/contacts/js/utilities/normalizer.js','/shared/js/text_normalizer.js','/dialer/js/telephony_helper.js','/contacts/js/sms_integration.js','/contacts/js/utilities/sdcard.js','/contacts/js/utilities/vcard_parser.js','/contacts/js/utilities/status.js','/contacts/js/utilities/dom.js'];LazyLoader.load(lazyLoadFiles,function(){var handling=ActivityHandler.currentlyHandling;if(!handling||ActivityHandler.activityName==='pick'||ActivityHandler.activityName==='update'){initContactsList();checkUrl();}else{navigator.mozContacts.oncontactchange=null;}
window.dispatchEvent(new CustomEvent('asyncScriptsLoaded'));});};var pendingChanges={};var checkPendingChanges=function checkPendingChanges(id){var changes=pendingChanges[id];if(!changes){return;}
pendingChanges[id].shift();if(pendingChanges[id].length>=1){performOnContactChange(pendingChanges[id][0]);}};navigator.mozContacts.oncontactchange=function oncontactchange(event){if(typeof pendingChanges[event.contactID]!=='undefined'){pendingChanges[event.contactID].push({contactID:event.contactID,reason:event.reason});}else{pendingChanges[event.contactID]=[{contactID:event.contactID,reason:event.reason}];}
if(pendingChanges[event.contactID].length>1){return;}
performOnContactChange(event);};var performOnContactChange=function performOnContactChange(event){initContactsList();var currView=navigation.currentView();switch(event.reason){case'update':if(currView=='view-contact-details'&&currentContact!=null&&currentContact.id==event.contactID){contactsList.getContactById(event.contactID,function success(contact,enrichedContact){currentContact=contact;if(contactsDetails){contactsDetails.render(currentContact,null,enrichedContact);}
if(contactsList){contactsList.refresh(currentContact,checkPendingChanges,event.reason);}});}else{contactsList.refresh(event.contactID,checkPendingChanges,event.reason);}
break;case'create':contactsList.refresh(event.contactID,checkPendingChanges,event.reason);break;case'remove':if(currentContact!=null&&currentContact.id==event.contactID&&(currView=='view-contact-details'||currView=='view-contact-form')){navigation.home();}
contactsList.remove(event.contactID,event.reason);currentContact={};checkPendingChanges(event.contactID);break;}};var close=function close(){window.removeEventListener('localized',initContacts);};var initContacts=function initContacts(evt){window.setTimeout(Contacts.onLocalized);window.removeEventListener('localized',initContacts);if(window.navigator.mozSetMessageHandler&&window.self==window.top){var actHandler=ActivityHandler.handle.bind(ActivityHandler);window.navigator.mozSetMessageHandler('activity',actHandler);}
window.addEventListener('online',Contacts.onLineChanged);window.addEventListener('offline',Contacts.onLineChanged);document.addEventListener('visibilitychange',function visibility(e){if(ActivityHandler.currentlyHandling&&document.hidden){ActivityHandler.postCancel();return;}
Contacts.checkCancelableActivity();if(document.hidden===false&&navigation.currentView()==='view-settings'){Contacts.view('Settings',function viewLoaded(){contacts.Settings.updateTimestamps();});}});};window.addEventListener('localized',initContacts);function loadConfirmDialog(){var args=Array.slice(arguments);Contacts.utility('Confirm',function viewLoaded(){ConfirmDialog.show.apply(ConfirmDialog,args);});}
var dependencies={views:{Settings:loadFacebook,Details:loadFacebook,Form:loadFacebook},utilities:{}};var elementMapping={details:'view-contact-details',form:'view-contact-form',settings:'settings-wrapper',search:'search-view',overlay:'loading-overlay',confirm:'confirmation-message'};function load(type,file,callback){function doLoad(){var name=file.toLowerCase();var toLoad=['js/'+type+'/'+name+'.js'];var node=document.getElementById(elementMapping[name]);if(node){toLoad.unshift(node);}
LazyLoader.load(toLoad,function(){if(node){navigator.mozL10n.translate(node);}
if(callback){callback();}});}
if(dependencies[type][file]){return dependencies[type][file](doLoad);}
doLoad();}
function loadView(view,callback){load('views',view,callback);}
function loadUtility(utility,callback){load('utilities',utility,callback);}
return{'goBack':handleBack,'cancel':handleCancel,'goToSelectTag':goToSelectTag,'sendSms':sendSms,'navigation':navigation,'sendEmailOrPick':sendEmailOrPick,'updatePhoto':updatePhoto,'checkCancelableActivity':checkCancelableActivity,'isEmpty':isEmpty,'getLength':getLength,'showForm':showForm,'setCurrent':setCurrent,'getTags':TAG_OPTIONS,'onLocalized':onLocalized,'init':init,'showOverlay':showOverlay,'hideOverlay':hideOverlay,'showContactDetail':contactListClickHandler,'updateContactDetail':updateContactDetail,'onLineChanged':onLineChanged,'showStatus':showStatus,'loadFacebook':loadFacebook,'confirmDialog':loadConfirmDialog,'close':close,'view':loadView,'utility':loadUtility,get asyncScriptsLoaded(){return asyncScriptsLoaded;}};})();;'use strict';if(!window.ImageLoader){var ImageLoader=function ImageLoader(pContainer,pItems){var container,items,itemsSelector,lastScrollTime,scrollLatency=100,scrollTimer,itemHeight,total,imgsLoading=0,loadImage=defaultLoadImage,self=this;init(pContainer,pItems);function init(pContainer,pItems){itemsSelector=pItems;container=document.querySelector(pContainer);container.addEventListener('scroll',onScroll);document.addEventListener('onupdate',onUpdate);load();}
function onUpdate(evt){evt.stopPropagation();onScroll();}
function load(){window.clearTimeout(scrollTimer);scrollTimer=null;items=container.querySelectorAll(itemsSelector);itemHeight=items[0]?items[0].offsetHeight:1;total=items.length;window.setTimeout(update,0);}
function unload(){container.removeEventListener('scroll',onScroll);document.removeEventListener('onupdate',onUpdate);window.clearTimeout(scrollTimer);scrollTimer=null;}
function setResolver(pResolver){loadImage=pResolver;}
function onScroll(){if(imgsLoading>0){window.stop();imgsLoading=0;}
lastScrollTime=Date.now();if(!scrollTimer){scrollTimer=window.setTimeout(updateFromScroll,scrollLatency);}}
function updateFromScroll(){scrollTimer=null;var deltaLatency=lastScrollTime-Date.now()+scrollLatency;if(deltaLatency>0){scrollTimer=window.setTimeout(updateFromScroll,deltaLatency);}else{update();}}
function defaultLoadImage(item){var image=item.querySelector('span[data-type=img][data-src]');if(!image){return;}
++imgsLoading;var tmp=new Image();var src=tmp.src=image.dataset.src;tmp.onload=function onload(){--imgsLoading;image.style.backgroundImage='url('+src+')';if(tmp.complete){item.dataset.visited='true';}
tmp=null;};tmp.onabort=tmp.onerror=function onerror(){--imgsLoading;item.dataset.visited='false';tmp=null;};}
function update(){if(total===0){return;}
var viewTop=container.scrollTop;var index=Math.floor(viewTop/itemHeight);var containerHeight=container.offsetHeight;for(var i=index;i>=0;i--){var item=items[i];if(item){if(item.offsetTop+itemHeight<viewTop){break;}
if(item.dataset.visited!=='true'&&item.offsetTop<=viewTop+containerHeight){loadImage(item,self);}}}
for(var j=index+1;j<total;j++){var theItem=items[j];if(!theItem){return;}
if(theItem.offsetTop>viewTop+containerHeight){return;}
if(theItem.dataset.visited!=='true'){loadImage(theItem,self);}}}
function releaseImage(item){var image=item.querySelector('span[data-type=img][data-src]');if(!image){return null;}
image.style.backgroundImage='none';item.dataset.visited='false';return image;}
this.reload=load;this.unload=unload;this.setResolver=setResolver;this.defaultLoad=defaultLoadImage;this.releaseImage=releaseImage;};};'use strict';(function(window){function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();setTimeout(function(){var detail={name:name,timestamp:now};var evt=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(evt);});}
window.PerformanceTestingHelper={dispatch:dispatch};})(window);;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;var fbLoader=(function(){var loaded=false;scriptsLoaded=0;var loadFb=function loadFb(){if(loaded)
return;loaded=true;var iframesFragment=document.createDocumentFragment();var curtain=document.createElement('iframe');curtain.id='fb-curtain';curtain.src='/facebook/curtain.html';iframesFragment.appendChild(curtain);var oauth=document.createElement('iframe');oauth.id='fb-oauth';iframesFragment.appendChild(oauth);var extensions=document.createElement('iframe');extensions.id='fb-extensions';iframesFragment.appendChild(extensions);document.body.appendChild(iframesFragment);var scripts=['/contacts/js/service_extensions.js','/contacts/oauth2/js/parameters.js','/shared/js/fb/fb_request.js','/contacts/js/fb/fb_data.js','/contacts/js/fb/fb_utils.js','/contacts/js/fb/fb_query.js','/shared/js/fb/fb_reader_utils.js','/contacts/js/fb/fb_contact_utils.js','/contacts/js/fb/fb_contact.js','/contacts/js/fb/fb_link.js','/contacts/js/fb/fb_messaging.js','/contacts/js/value_selector.js'];LazyLoader.load(scripts,function(){var event=new CustomEvent('facebookLoaded');window.dispatchEvent(event);});};return{load:loadFb,get loaded(){return loaded;}};})();