;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;'use strict';var SimpleOperatorVariantHelper={get MCC_SETTINGS_KEY(){return'operatorvariant.mcc';},get MNC_SETTINGS_KEY(){return'operatorvariant.mnc';},getOperatorVariant:function(callback){var transaction=window.navigator.mozSettings.createLock();var mccRequest=transaction.get(this.MCC_SETTINGS_KEY);mccRequest.onsuccess=(function(){var mcc=mccRequest.result[this.MCC_SETTINGS_KEY]||'0';var mncRequest=transaction.get(this.MNC_SETTINGS_KEY);mncRequest.onsuccess=(function(){var mnc=mncRequest.result[this.MNC_SETTINGS_KEY]||'0';callback(mcc,mnc);}).bind(this);}).bind(this);}};;var DateHelper={todayStarted:function dh_todayStarted(){var now=(new Date()).valueOf();return this.getMidnight(now);},yesterdayStarted:function dh_yesterdayStarted(){var now=(new Date()).valueOf();var dayAgo=now-86400000;return this.getMidnight(dayAgo);},thisWeekStarted:function dh_thisWeekStarted(){var now=new Date();var dayOfTheWeek=now.getDay();var firstDay=new Date(now.getFullYear(),now.getMonth(),now.getDate()-dayOfTheWeek);return this.getMidnight(firstDay);},thisMonthStarted:function dh_thisMonthStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),now.getMonth(),1).valueOf());return firstDay;},lastSixMonthsStarted:function dh_lastSixMonthsStarted(){var now=new Date().valueOf();var sixMonthsAgo=now-2629743830*6;return sixMonthsAgo;},thisYearStarted:function dh_thisYearStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),0).valueOf());return firstDay;},getMidnight:function dh_getMidnight(timestamp){var day=new Date(timestamp);var midnight=(new Date(day.getFullYear(),day.getMonth(),day.getDate(),0).valueOf());return midnight;}};var NumberHelper={zfill:function nh_zfill(string,len){var s=string;while(s.length<len)s='0'+s;return s;}};var HtmlHelper={createHighlightHTML:function ut_createHighlightHTML(text,searchRegExp){if(!searchRegExp){return this.escapeHTML(text);}
searchRegExp=new RegExp(searchRegExp,'gi');var sliceStrs=text.split(searchRegExp);var patterns=text.match(searchRegExp);if(!patterns){return this.escapeHTML(text);}
var str='';for(var i=0;i<patterns.length;i++){str=str+
this.escapeHTML(sliceStrs[i])+'<span class="highlight">'+
this.escapeHTML(patterns[i])+'</span>';}
str+=this.escapeHTML(sliceStrs.pop());return str;},escapeHTML:function ut_escapeHTML(str,escapeQuotes){var span=document.createElement('span');span.textContent=str;span.innerHTML=span.innerHTML.replace(/\s/g,'&nbsp;');if(escapeQuotes)
return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return span.innerHTML;}};var StringHelper={fromUTF8:function ut_fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;}};;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::|:\/\/)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},hasScheme:function(input){return!!(rscheme.exec(input)||[])[0];},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var schemeReg=/^\w+\:\/\//;var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data\:)/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)){return true;}
if(case3Reg.test(str)){return false;}
if(!schemeReg.test(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;'use strict';var NfcUtil={fromUTF8:function fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;},};const NDEF={TNF:0x07,TNF_EMPTY:0x00,TNF_WELL_KNOWN:0x01,RTD_URI:0,URIS:[],init:function ndef_init(){this.RTD_TEXT=NfcUtil.fromUTF8('T');this.RTD_URI=NfcUtil.fromUTF8('U');this.URIS[0x00]='';this.URIS[0x01]='http://www.';this.URIS[0x02]='https://www.';this.URIS[0x03]='http://';this.URIS[0x04]='https://';this.URIS[0x05]='tel:';this.URIS[0x06]='mailto:';this.URIS[0x07]='ftp://anonymous:anonymous@';this.URIS[0x08]='ftp://ftp.';this.URIS[0x09]='ftps://';this.URIS[0x0A]='sftp://';this.URIS[0x0B]='smb://';this.URIS[0x0C]='nfs://';this.URIS[0x0D]='ftp://';this.URIS[0x0E]='dav://';this.URIS[0x0F]='news:';this.URIS[0x10]='telnet://';this.URIS[0x11]='imap:';this.URIS[0x12]='rtsp://';this.URIS[0x13]='urn:';this.URIS[0x14]='pop:';this.URIS[0x15]='sip:';this.URIS[0x16]='sips:';this.URIS[0x17]='tftp:';this.URIS[0x18]='btspp://';this.URIS[0x19]='btl2cap://';this.URIS[0x1A]='btgoep://';this.URIS[0x1B]='tcpobex://';this.URIS[0x1C]='irdaobex://';this.URIS[0x1D]='file://';this.URIS[0x1E]='urn:epc:id:';this.URIS[0x1F]='urn:epc:tag:';this.URIS[0x20]='urn:epc:pat:';this.URIS[0x21]='urn:epc:raw:';this.URIS[0x22]='urn:epc:';this.URIS[0x23]='urn:nfc:';},};NDEF.init();;'use strict';var _=navigator.mozL10n.get;var Browser={currentTab:null,tabCounter:0,tabs:{},styleSheet:document.styleSheets[0],cssTranslateId:null,GO:0,REFRESH:1,STOP:2,SEARCH:3,VISIBLE:0,TRANSITIONING:1,HIDDEN:2,PAGE_SCREEN:'page-screen',TABS_SCREEN:'tabs-screen',AWESOME_SCREEN:'awesome-screen',SETTINGS_SCREEN:'settings-screen',previousScreen:null,currentScreen:'page-screen',searchEngine:{},DEVICE_RATIO:window.devicePixelRatio,UPPER_SCROLL_THRESHOLD:50,LOWER_SCROLL_THRESHOLD:5,MAX_TOP_SITES:4,MAX_THUMBNAIL_WIDTH:140,MAX_THUMBNAIL_HEIGHT:100,FIRST_TAB:'tab_0',MAX_SAVING_RETRIES:100,urlButtonMode:null,addressBarState:null,inTransition:false,waitingActivities:[],hasLoaded:false,lastScrollOffset:0,init:function browser_init(){this.getAllElements();if(window.navigator.mozNfc){window.navigator.mozNfc.onpeerready=NfcURI.handlePeerConnectivity;}
this.urlBar.addEventListener('submit',this.handleUrlFormSubmit.bind(this));this.urlInput.addEventListener('focus',this.urlFocus.bind(this));this.urlInput.addEventListener('blur',this.urlBlur.bind(this));this.urlInput.addEventListener('mouseup',this.urlMouseUp.bind(this));this.urlInput.addEventListener('keyup',this.handleUrlInputKeypress.bind(this));this.urlButton.addEventListener('click',this.handleUrlFormSubmit.bind(this));this.tabsBadge.addEventListener('click',this.handleTabsBadgeClicked.bind(this));this.urlInput.addEventListener('click',this.urlFocus.bind(this));BrowserDB.init((function(){this.selectTab(this.createTab());this.addressBarState=this.VISIBLE;BrowserDB.getSetting('defaultSearchEngine',(function(uri){if(!uri)
return;BrowserDB.getSearchEngine(uri,(function(searchEngine){if(!searchEngine)
return;this.searchEngine=searchEngine;}).bind(this));}).bind(this));}).bind(this));},toCamelCase:function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});},getAllElements:function browser_getAllElements(){var elementIDs=['toolbar-start','url-bar','url-input','url-button','awesomescreen','ssl-indicator','tabs-badge','throbber','frames','main-screen','crashscreen','bookmark-menu','bookmark-entry-sheet','startscreen','top-site-thumbnails','no-top-sites','tray','danger-dialog'];elementIDs.forEach(function createElementRef(name){this[this.toCamelCase(name)]=document.getElementById(name);},this);},loadRemaining:function browser_loadRemaining(){if(this.hasLoaded)
return;var elementsToLoad=[this.awesomescreen,this.crashscreen,this.tray,this.bookmarkMenu,this.bookmarkEntrySheet,document.getElementById('settings'),document.getElementById('modal-dialog-alert'),document.getElementById('modal-dialog-prompt'),document.getElementById('modal-dialog-confirm'),document.getElementById('modal-dialog-custom-prompt'),document.getElementById('http-authentication-dialog'),document.getElementById('danger-dialog')];var filesToLoad=['shared/style/headers.css','shared/style/buttons.css','shared/style/input_areas.css','shared/style/status.css','shared/style/confirm.css','style/modal_dialog/modal_dialog.css','style/modal_dialog/prompt.css','style/themes/default/core.css','style/themes/default/buttons.css','style/action_menu.css','style/authentication_dialog.css','style/settings.css','style/awesomescreen.css','shared/js/gesture_detector.js'];var jsFiles=['js/awesomescreen.js','js/settings.js','js/modal_dialog.js','js/authentication_dialog.js'];var domElements=['tabs-list','settings-button','close-tab','try-reloading','bookmark-menu-add','bookmark-menu-remove','bookmark-menu-cancel','bookmark-menu-edit','bookmark-entry-sheet-cancel','bookmark-entry-sheet-done','bookmark-title','bookmark-url','bookmark-previous-url','bookmark-menu-add-home','new-tab-button','danger-dialog-message','danger-dialog-cancel','danger-dialog-ok'];var loadBrowserFiles=function(){LazyLoader.load(jsFiles,function(){var mozL10n=navigator.mozL10n;mozL10n.ready(function browser_localizeElements(){elementsToLoad.forEach(function l10nElement(element){mozL10n.translate(element);});});domElements.forEach(function createElementRef(name){this[this.toCamelCase(name)]=document.getElementById(name);},this);this.initRemainingListeners();document.body.classList.add('loaded');this.hasLoaded=true;if(this.waitingActivities.length){this.waitingActivities.forEach(this.handleActivity,this);}}.bind(this));};LazyLoader.load(elementsToLoad.concat(filesToLoad),loadBrowserFiles.bind(this));},initRemainingListeners:function browser_initRemainingListeners(){this.settingsButton.addEventListener('click',Settings.show.bind(Settings));this.newTabButton.addEventListener('click',this.handleNewTab.bind(this));this.closeTab.addEventListener('click',this.handleCloseTab.bind(this));this.tryReloading.addEventListener('click',this.handleTryReloading.bind(this));this.bookmarkMenuAdd.addEventListener('click',this.addBookmark.bind(this));this.bookmarkMenuRemove.addEventListener('click',this.removeBookmark.bind(this));this.bookmarkMenuCancel.addEventListener('click',this.hideBookmarkMenu.bind(this));this.bookmarkMenuEdit.addEventListener('click',this.showBookmarkEntrySheet.bind(this));this.bookmarkMenuAddHome.addEventListener('click',this.addLinkToHome.bind(this));this.bookmarkEntrySheetCancel.addEventListener('click',this.hideBookmarkEntrySheet.bind(this));this.bookmarkEntrySheetDone.addEventListener('click',this.saveBookmark.bind(this));this.topSiteThumbnails.addEventListener('click',this.followLink.bind(this));this.tabsSwipeMngr.browser=this;['mousedown','pan','tap','swipe'].forEach(function(evt){this.tabsList.addEventListener(evt,this.tabsSwipeMngr[evt].bind(this.tabsSwipeMngr));},this);this.screenSwipeMngr.browser=this;this.screenSwipeMngr.screen=this.mainScreen;this.screenSwipeMngr.gestureDetector=new GestureDetector(this.mainScreen);['mousedown','pan','tap','swipe'].forEach(function(evt){this.mainScreen.addEventListener(evt,this.screenSwipeMngr[evt].bind(this.screenSwipeMngr));},this);document.addEventListener('visibilitychange',this.handleVisibilityChange.bind(this));Settings.init();ModalDialog.init();Awesomescreen.init();AuthenticationDialog.init(false);},getConfigurationData:function browser_getDefaultData(variant,callback){var DEFAULT_MCC='000';var DEFAULT_MNC='000';var xhr=new XMLHttpRequest();xhr.open('GET','/js/init.json',true);xhr.addEventListener('load',(function browser_defaultDataListener(){if(!(xhr.status===200|xhr.status===0)){console.error('Unknown response when getting configuration data.');return;}
var data=JSON.parse(xhr.responseText);var mccCodes=variant.mcc;var mncCodes=variant.mnc;if(!Array.isArray(variant.mcc)){mccCodes=[variant.mcc];}
if(!Array.isArray(variant.mnc)){mncCodes=[variant.mnc];}
for(var i=0;i<mccCodes.length;i++){var mccCode=NumberHelper.zfill(mccCodes[i],3);var mncCode=DEFAULT_MNC;if(i<mncCodes.length){mncCode=mncCodes[i];}
mncCode=NumberHelper.zfill(mncCode,3);if(data[mccCode+mncCode]){callback(data[mccCode+mncCode]);return;}}
if(data[DEFAULT_MCC+DEFAULT_MNC]){callback(data[DEFAULT_MCC+DEFAULT_MNC]);return;}
callback(null);console.error('No configuration data found.');}).bind(this),false);xhr.onerror=function getDefaultDataError(){callback(null);console.error('Error getting configuration data.');};xhr.send();},handlePageScreenClicked:function browser_handlePageScreenClicked(e){if(this.inTransition){return;}
if(this.currentScreen===this.TABS_SCREEN){this.showPageScreen();}},handleTryReloading:function browser_handleTryReloading(){this.reviveCrashedTab(this.currentTab);},handleCloseTab:function browser_handleCloseTab(){this.hideCrashScreen();this.deleteTab(this.currentTab.id);this.setTabVisibility(this.currentTab,true);this.updateTabsCount();},handleTabsBadgeClicked:function browser_handleTabsBadgeClicked(e){if(this.inTransition)
return;this.showTabScreen();},handleNewTab:function browserHandleNewTab(e){this.inTransition=true;var tabId=this.createTab();this.showNewTabAnimation((function browser_showNewTabAnimation(){this.selectTab(tabId);Awesomescreen.show();}).bind(this));},handleBrowserEvent:function browser_handleBrowserEvent(tab){return(function(evt){var isCurrentTab=this.currentTab.id===tab.id;switch(evt.type){case'mozbrowserloadstart':if(!tab.url||tab.crashed){return;}
if(this.addressBarState===this.HIDDEN){this.showAddressBar();}
tab.loading=true;if(isCurrentTab&&this.currentScreen===this.PAGE_SCREEN){this.throbber.classList.add('loading');this.setUrlButtonMode(this.STOP);}
tab.title=null;tab.iconUrl=null;break;case'mozbrowserloadend':if(!tab.loading){return;}
tab.loading=false;if(isCurrentTab&&this.currentScreen===this.PAGE_SCREEN){this.throbber.classList.remove('loading');this.setUrlBar(tab.title||tab.url);this.setUrlButtonMode(this.REFRESH);}
if(tab.dom.getScreenshot){tab.dom.getScreenshot(this.MAX_THUMBNAIL_WIDTH*this.DEVICE_RATIO,this.MAX_THUMBNAIL_HEIGHT*this.DEVICE_RATIO).onsuccess=(function(e){tab.screenshot=e.target.result;if(this.currentScreen===this.TABS_SCREEN){this.showTabScreen();}
BrowserDB.updateScreenshot(tab.url,tab.screenshot);}).bind(this);}
if(!tab.iconUrl){var a=document.createElement('a');a.href=tab.url;var iconUrl=a.protocol+'//'+a.hostname+'/'+'favicon.ico';BrowserDB.setAndLoadIconForPage(tab.url,iconUrl);}
this.handleScroll({detail:{top:this.lastScrollOffset}});break;case'mozbrowserlocationchange':this.lastScrollOffset=0;if(evt.detail==='about:blank'){return;}
if(!tab.url&&evt.detail&&evt.detail!==''){this.hideStartscreen();}
tab.url=evt.detail;this.updateHistory(evt.detail);if(isCurrentTab){if(this.currentScreen===this.PAGE_SCREEN){this.setUrlBar(tab.url);}}
break;case'mozbrowsertitlechange':if(evt.detail){tab.title=evt.detail;BrowserDB.setPageTitle(tab.url,tab.title);if(isCurrentTab&&!tab.loading&&this.currentScreen===this.PAGE_SCREEN){this.setUrlBar(tab.title);}
if(this.currentScreen===this.TABS_SCREEN){this.showTabScreen();}}
break;case'mozbrowsericonchange':if(evt.detail.href&&evt.detail.href!=tab.iconUrl){tab.iconUrl=evt.detail.href;BrowserDB.setAndLoadIconForPage(tab.url,tab.iconUrl);}
break;case'mozbrowsercontextmenu':if(!this.contextMenuHasCalled){this.contextMenuHasCalled=true;this.showContextMenu(evt);}
break;case'mozbrowsersecuritychange':tab.security=evt.detail;if(isCurrentTab){this.updateSecurityIcon();}
break;case'mozbrowseropenwindow':this.handleWindowOpen(evt);break;case'mozbrowserclose':this.handleWindowClose(tab.id);this.setTabVisibility(this.currentTab,true);this.updateTabsCount();if(tab.id===ModalDialog.currentOrigin){ModalDialog.hide();}else if(tab.id===AuthenticationDialog.currentOrigin){AuthenticationDialog.hide();}
break;case'mozbrowserusernameandpasswordrequired':if(!isCurrentTab){this.hideCurrentTab();this.selectTab(tab.id);}
if(this.currentScreen!==this.PAGE_SCREEN){this.showPageScreen();}
AuthenticationDialog.handleEvent(evt,tab.id);break;case'mozbrowsershowmodalprompt':if(!isCurrentTab){this.hideCurrentTab();this.selectTab(tab.id);}
if(this.currentScreen!==this.PAGE_SCREEN){this.showPageScreen();}
ModalDialog.handleEvent(evt,tab.id);break;case'mozbrowsererror':if(evt.detail.type==='fatal')
this.handleCrashedTab(tab);break;case'mozbrowserasyncscroll':this.handleScroll(evt);break;}}).bind(this);},handleScroll:function browser_handleScroll(evt){this.lastScrollOffset=evt.detail.top;if(evt.detail.top<this.LOWER_SCROLL_THRESHOLD){this.showAddressBar();}else if(evt.detail.top>this.UPPER_SCROLL_THRESHOLD){this.hideAddressBar();}},hideAddressBar:function browser_hideAddressBar(){if(this.addressBarState===this.HIDDEN||this.addressBarState===this.TRANSITIONING){return;}
if(this.currentTab.loading)
return;var addressBarHidden=(function browser_addressBarHidden(){this.addressBarState=this.HIDDEN;this.mainScreen.removeEventListener('transitionend',addressBarHidden);}).bind(this);this.urlInput.disabled=true;this.mainScreen.addEventListener('transitionend',addressBarHidden);this.addressBarState=this.TRANSITIONING;this.mainScreen.classList.add('expanded');this.mainScreen.clientTop;this.mainScreen.classList.add('address-hidden');},showAddressBar:function browser_showAddressBar(){if(this.addressBarState===null||this.addressBarState===this.VISIBLE||this.addressBarState===this.TRANSITIONING){return;}
var addressBarVisible=(function browser_addressBarVisible(){this.mainScreen.classList.remove('expanded');this.addressBarState=this.VISIBLE;this.mainScreen.removeEventListener('transitionend',addressBarVisible);}).bind(this);this.urlInput.disabled=false;this.mainScreen.addEventListener('transitionend',addressBarVisible);this.addressBarState=this.TRANSITIONING;this.mainScreen.clientTop;this.mainScreen.classList.remove('address-hidden');},handleUrlInputKeypress:function browser_handleUrlInputKeypress(evt){var input=this.urlInput.value;Awesomescreen.update(input);if(input===''){this.setUrlButtonMode(null);return;}
this.setUrlButtonMode(UrlHelper.isNotURL(input)?this.SEARCH:this.GO);},showCrashScreen:function browser_showCrashScreen(){this.crashscreen.style.display='block';},hideCrashScreen:function browser_hideCrashScreen(){this.crashscreen.style.display='none';},handleCrashedTab:function browser_handleCrashedTab(tab){if(tab.id===this.currentTab.id&&!document.hidden){this.showCrashScreen();}
tab.loading=false;tab.crashed=true;ModalDialog.clear(tab.id);AuthenticationDialog.clear(tab.id);this.frames.removeChild(tab.dom);delete tab.dom;},handleVisibilityChange:function browser_handleVisibilityChange(){if(!document.hidden&&this.currentTab.crashed)
this.reviveCrashedTab(this.currentTab);if(document.hidden){this.urlInput.blur();this.currentTab.dom.blur();}},reviveCrashedTab:function browser_reviveCrashedTab(tab){this.createTab(null,null,tab);tab.crashed=false;if(!tab.url)
return;this.setTabVisibility(tab,true);Toolbar.refreshButtons();this.navigate(tab.url);this.hideCrashScreen();},handleWindowOpen:function browser_handleWindowOpen(evt){var url=evt.detail.url;var frame=evt.detail.frameElement;var tab=this.createTab(url,frame);this.hideCurrentTab();this.selectTab(tab);this.currentTab.loading=true;this.setTabVisibility(this.currentTab,true);this.updateTabsCount();},handleWindowClose:function browser_handleWindowClose(tabId){if(!tabId)
return false;this.deleteTab(tabId);return true;},updateTabsCount:function browser_updateTabsCount(){this.tabsBadge.innerHTML=Object.keys(this.tabs).length+'<span id="more-tabs">&#x203A;</span>';},updateSecurityIcon:function browser_updateSecurityIcon(){if(!this.currentTab.security){this.sslIndicator.value='';return;}
this.sslIndicator.value=this.currentTab.security.state;},navigate:function browser_navigate(url){this.hideStartscreen();this.showPageScreen();this.currentTab.title=null;this.currentTab.url=url;this.currentTab.dom.setAttribute('src',url);this.setUrlBar(url);},getUrlFromInput:function browser_getUrlFromInput(input){var hasScheme=UrlHelper.hasScheme(input);if(UrlHelper.isNotURL(input)&&this.searchEngine.uri){var uri=this.searchEngine.uri.replace('{searchTerms}',input);return uri;}
if(!hasScheme){return'http://'+input;}
return input;},handleUrlFormSubmit:function browser_handleUrlFormSubmit(e){if(e){e.preventDefault();}
if(this.urlButtonMode===null){return;}
if(this.urlButtonMode==this.REFRESH&&this.currentTab.crashed){this.setUrlBar(this.currentTab.url);this.reviveCrashedTab(this.currentTab);return;}
if(this.urlButtonMode==this.REFRESH&&!this.currentTab.crashed){this.currentTab.dom.reload(false);return;}
if(this.urlButtonMode==this.STOP&&!this.currentTab.crashed){this.currentTab.dom.stop();return;}
var url=this.getUrlFromInput(this.urlInput.value);if(url!==this.currentTab.url){this.setUrlBar(url);this.currentTab.url=url;}
this.urlInput.blur();if(this.currentTab.crashed){this.reviveCrashedTab(this.currentTab);return;}
this.navigate(url);},goBack:function browser_goBack(){this.currentTab.dom.goBack();},goForward:function browser_goForward(){this.currentTab.dom.goForward();},addBookmark:function browser_addBookmark(e){e.preventDefault();if(!this.currentTab.url||UrlHelper.isNotURL(this.currentTab.url)){return;}
BrowserDB.addBookmark(this.currentTab.url,this.currentTab.title,Toolbar.refreshBookmarkButton.bind(Toolbar));this.hideBookmarkMenu();},removeBookmark:function browser_removeBookmark(e){e.preventDefault();if(!this.bookmarkMenuRemove.dataset.url)
return;BrowserDB.removeBookmark(this.bookmarkMenuRemove.dataset.url,function(){Toolbar.refreshBookmarkButton();Awesomescreen.refreshBookmarks();});this.hideBookmarkMenu();},showActionMenu:function browser_showActionMenu(url,from){if(!url)
return;this.bookmarkMenu.classList.remove('hidden');BrowserDB.getBookmark(url,(function(bookmark){if(bookmark){if(from&&from==='bookmarksTab'){this.bookmarkMenuAdd.parentNode.classList.add('hidden');this.bookmarkMenuRemove.dataset.url=url;this.bookmarkMenuRemove.parentNode.classList.remove('hidden');this.bookmarkMenuEdit.parentNode.classList.add('hidden');this.bookmarkMenuAddHome.parentNode.classList.add('hidden');}else{this.bookmarkMenuAdd.parentNode.classList.add('hidden');this.bookmarkMenuRemove.dataset.url=url;this.bookmarkMenuRemove.parentNode.classList.remove('hidden');this.bookmarkMenuEdit.dataset.url=url;this.bookmarkMenuEdit.parentNode.classList.remove('hidden');this.bookmarkMenuAddHome.parentNode.classList.remove('hidden');}}else{this.bookmarkMenuAdd.parentNode.classList.remove('hidden');this.bookmarkMenuRemove.parentNode.classList.add('hidden');this.bookmarkMenuEdit.parentNode.classList.add('hidden');this.bookmarkMenuAddHome.parentNode.classList.remove('hidden');}}).bind(this));},showBookmarkMenu:function browser_showBookmarkMenu(){this.showActionMenu(this.currentTab.url);},showBookmarkTabContextMenu:function browser_showBookmarkTabContextMenu(url){this.showActionMenu(url,'bookmarksTab');},hideBookmarkMenu:function browser_hideBookmarkMenu(){this.bookmarkMenu.classList.add('hidden');},showBookmarkEntrySheet:function browser_showBookmarkEntrySheet(){if(!this.currentTab.url)
return;this.hideBookmarkMenu();this.bookmarkEntrySheet.classList.remove('hidden');BrowserDB.getBookmark(this.currentTab.url,(function(bookmark){if(!bookmark){this.hideBookmarkEntrySheet();return;}
this.bookmarkTitle.value=bookmark.title;this.bookmarkUrl.value=bookmark.uri;this.bookmarkPreviousUrl.value=bookmark.uri;this.bookmarkUrl.addEventListener('keydown',(function(){if(UrlHelper.isURL(this.bookmarkUrl.value)){this.bookmarkEntrySheetDone.removeAttribute('disabled');}else{this.bookmarkEntrySheetDone.disabled='disabled';}}).bind(this),false);}).bind(this));},hideBookmarkEntrySheet:function browser_hideBookmarkEntrySheet(){this.bookmarkEntrySheet.classList.add('hidden');this.bookmarkTitle.value='';this.bookmarkUrl.value='';this.bookmarkPreviousUrl.value='';},saveBookmark:function browser_saveBookmark(){var url=this.bookmarkUrl.value;var title=this.bookmarkTitle.value;var previousUrl=this.bookmarkPreviousUrl.value;if(url!=previousUrl){BrowserDB.removeBookmark(previousUrl,Toolbar.refreshBookmarkButton.bind(Toolbar));BrowserDB.updateBookmark(url,title);}else{BrowserDB.updateBookmark(url,title);}
this.hideBookmarkEntrySheet();},addLinkToHome:function browser_addLinkToHome(){if(!this.currentTab.url||UrlHelper.isNotURL(this.currentTab.url)){return;}
BrowserDB.getPlace(this.currentTab.url,(function(place){new MozActivity({name:'save-bookmark',data:{type:'url',url:this.currentTab.url,name:this.currentTab.title,icon:place.iconUri,useAsyncPanZoom:true},onerror:function(e){console.warn('Unhandled error from save-bookmark activity: '+
e.target.error.message+'\n');}});}).bind(this));this.hideBookmarkMenu();},updateHistory:function browser_updateHistory(url){BrowserDB.addVisit(url);Toolbar.refreshButtons();},shouldFocus:false,urlMouseUp:function browser_urlMouseUp(e){if(this.shouldFocus){e.preventDefault();this.urlInput.focus();this.urlInput.select();this.shouldFocus=false;}},urlFocus:function browser_urlFocus(e){if(this.urlBar.classList.contains('focus'))
return;this.urlBar.classList.add('focus');if(this.currentScreen===this.PAGE_SCREEN){this.urlInput.value=this.currentTab.url;this.sslIndicator.value='';this.setUrlBar(this.currentTab.url);Awesomescreen.show();this.shouldFocus=true;}else if(this.currentScreen===this.AWESOME_SCREEN){this.shouldFocus=true;}},urlBlur:function browser_urlBlur(){this.urlBar.classList.remove('focus');},setUrlBar:function browser_setUrlBar(data){this.urlInput.value=data;},setUrlButtonMode:function browser_setUrlButtonMode(mode){this.urlButtonMode=mode;if(this.urlButtonMode===null){this.urlButton.style.backgroundImage='';this.urlButton.style.display='none';return;}
this.urlButton.style.display='block';switch(mode){case this.GO:this.urlButton.style.backgroundImage='url(style/images/go.png)';break;case this.REFRESH:this.urlButton.style.backgroundImage='url(style/images/refresh.png)';break;case this.STOP:this.urlButton.style.backgroundImage='url(style/images/stop.png)';break;case this.SEARCH:this.urlButton.style.backgroundImage='url(style/images/search.png)';break;}},openInNewTab:function browser_openInNewTab(url){this.createTab(url);this.updateTabsCount();},saveMedia:function browser_saveMedia(url,type){function displayMessage(message){var status=document.getElementById('save-media-status');status.firstElementChild.textContent=message;status.classList.add('visible');window.setTimeout(function(){status.classList.remove('visible');},3000);}
function storeBlob(blob,name,retryCount){var storageTypeMap={'image':'pictures','video':'videos','audio':'music'};var blobType=blob.type.split('/')[0];var storageType=storageTypeMap[blobType];if(!storageType){displayMessage(_('error-saving-'+type));return;}
var storage=navigator.getDeviceStorage(storageType);var addreq=storage.addNamed(blob,name);addreq.onsuccess=function(){displayMessage(_(type+'-saved'));};addreq.onerror=function(){if(addreq.error.name==='NoModificationAllowedError'&&retryCount!==Browser.MAX_SAVING_RETRIES){name=Date.now()+'-'+name;storeBlob(blob,name,retryCount+1);}else{displayMessage(_('error-saving-'+type));}};}
var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',url,true);xhr.responseType='blob';xhr.onload=function browser_mediaDataListener(){if(xhr.status!==200||!xhr.response){displayMessage(_('error-saving-'+type));return;}
var name=url.split('/').reverse()[0].toLowerCase().split(/[&?#]/g)[0].replace(/[^a-z0-9\.]/g,'_');var ext=MimeMapper.guessExtensionFromType(xhr.response.type);if(ext&&name.indexOf(ext)===-1){name+='.'+ext;}
storeBlob(xhr.response,name,0);};xhr.onerror=function getDefaultDataError(){displayMessage(_('error-saving-'+type));};xhr.send();},generateSystemMenuItem:function browser_generateSystemMenuItem(item){var self=this;var nodeName=item.nodeName?item.nodeName.toUpperCase():'';switch(nodeName){case'A':return{id:'open-in-new-tab',label:_('open-in-new-tab'),callback:function(){self.openInNewTab(item.data.uri);}};case'IMG':case'VIDEO':case'AUDIO':var typeMap={'IMG':'image','VIDEO':'video','AUDIO':'audio'};var type=typeMap[nodeName];if(nodeName==='VIDEO'&&!item.data.hasVideo){type='audio';}
return{label:_('save-'+type),callback:function(){self.saveMedia(item.data.uri,type);}};default:return false;}},showContextMenu:function browser_showContextMenu(evt){var menuItems=[];var menuData=evt.detail;var dialog=document.createElement('section');var menu=document.createElement('menu');var list=document.createElement('ul');var self=this;evt.detail.systemTargets.forEach(function(item){var action=this.generateSystemMenuItem(item);if(action){menuItems.push(action);}},this);var collectMenuItems=function(menu){menu.items.forEach(function(item){if(item.type==='menuitem'){menuItems.push({icon:item.icon,label:item.label,callback:function(){evt.detail.contextMenuItemSelected(item.id);}});}else if(item.type==='menu'){collectMenuItems(item);}});};if(menuData.contextmenu){collectMenuItems(menuData.contextmenu);}
if(Object.keys(menuItems).length===0){self.contextMenuHasCalled=false;return;}
evt.preventDefault();menuItems.forEach(function(menuitem){var li=document.createElement('li');li.id=menuitem.id;var button=this.createButton(menuitem.label,menuitem.icon);button.addEventListener('click',function(){document.body.removeChild(dialog);self.contextMenuHasCalled=false;menuitem.callback();});li.appendChild(button);list.appendChild(li);},this);var cancel=document.createElement('li');cancel.id='cancel';cancel.appendChild(this.createButton(_('cancel')));list.appendChild(cancel);cancel.addEventListener('click',function(e){self.contextMenuHasCalled=false;document.body.removeChild(dialog);});menu.classList.add('actions');menu.appendChild(list);dialog.setAttribute('role','dialog');dialog.appendChild(menu);document.body.appendChild(dialog);},createButton:function browser_createButton(text,image){var button=document.createElement('button');var textNode=document.createTextNode(text);if(image){var img=document.createElement('img');img.setAttribute('src',image);button.appendChild(img);}
button.appendChild(textNode);return button;},followLink:function browser_followLink(e){e.preventDefault();if(e.target.nodeName==='A'){this.navigate(e.target.getAttribute('href'));this.hideStartscreen();}},setTabVisibility:function(tab,visible){if(!tab.dom)
return;if(ModalDialog.originHasEvent(tab.id)){if(visible){ModalDialog.show(tab.id);}else{ModalDialog.hide();}}
if(AuthenticationDialog.originHasEvent(tab.id)){if(visible){AuthenticationDialog.show(tab.id);}else{AuthenticationDialog.hide();}}
this.setVisibleWrapper(tab,visible);var fun=tab.loading?'add':'remove';this.throbber.classList[fun]('loading');tab.dom.style.display=visible?'block':'none';tab.dom.style.top='0px';},setVisibleWrapper:function(tab,visible){if(tab.setVisibleTimeout){clearTimeout(tab.setVisibleTimeout);}
if(tab.dom.setVisible){tab.dom.setVisible(visible);return;}
tab.setVisibleTimeout=setTimeout(function(){if(tab.dom.setVisible)
tab.dom.setVisible(visible);});},bindBrowserEvents:function browser_bindBrowserEvents(iframe,tab){var browserEvents=['loadstart','loadend','locationchange','titlechange','iconchange','contextmenu','securitychange','openwindow','close','showmodalprompt','error','asyncscroll','usernameandpasswordrequired'];browserEvents.forEach(function attachBrowserEvent(type){iframe.addEventListener('mozbrowser'+type,this.handleBrowserEvent(tab));},this);},createTab:function browser_createTab(url,iframe,tab){if(!iframe){iframe=document.createElement('iframe');iframe.setAttribute('mozbrowser',true);iframe.setAttribute('mozallowfullscreen',true);iframe.classList.add('browser-tab');if(url){iframe.setAttribute('src',url);}}
iframe.style.top='-9999px';iframe.setAttribute('mozasyncpanzoom','true');iframe.setAttribute('remote','true');if(tab){tab.dom=iframe;}else{tab={id:'tab_'+this.tabCounter++,dom:iframe,url:url||null,title:null,loading:false,screenshot:null,security:null};}
this.setVisibleWrapper(tab,false);this.bindBrowserEvents(iframe,tab);this.tabs[tab.id]=tab;this.frames.appendChild(iframe);return tab.id;},deleteTab:function browser_deleteTab(id){var tabIds=Object.keys(this.tabs);if(this.tabs[id].dom)
this.tabs[id].dom.parentNode.removeChild(this.tabs[id].dom);delete this.tabs[id];ModalDialog.clear(id);AuthenticationDialog.clear(id);if(Object.keys(this.tabs).length==0){this.selectTab(this.createTab());this.switchScreen(this.PAGE_SCREEN);return;}
if(this.currentTab&&this.currentTab.id===id){var newTab=tabIds.indexOf(id);if(newTab===tabIds.length-1){newTab-=1;}
this.selectTab(Object.keys(this.tabs)[newTab]);}},showNewTabAnimation:function browser_showNewTab(showTabCompleteFun){var ul=this.tabsList.childNodes[0];var li=document.createElement('li');li.innerHTML='<a><img /><span>'+_('new-tab')+'</span></a>';li.style.height='0px';li.style.transition='height 0.2s ease-in';ul.insertBefore(li,ul.childNodes[0]);li.addEventListener('transitionend',function(){setTimeout(showTabCompleteFun,100);});li.clientTop;li.style.height='';},hideCurrentTab:function browser_hideCurrentTab(){var tab=this.currentTab;this.setTabVisibility(tab,false);this.throbber.classList.remove('loading');},selectTab:function browser_selectTab(id){this.currentTab=this.tabs[id];if(this.currentTab.crashed)
this.reviveCrashedTab(this.currentTab);this.setUrlBar(this.currentTab.title);this.updateSecurityIcon();Toolbar.refreshButtons();this.showAddressBar();if(this.currentTab.url==null){this.showStartscreen();}else{this.hideStartscreen();}},switchScreen:function browser_switchScreen(screen){if(this.currentScreen===this.TABS_SCREEN){this.screenSwipeMngr.gestureDetector.stopDetecting();}
if(this.currentScreen!==screen){document.body.classList.remove(this.currentScreen);this.previousScreen=this.currentScreen;this.currentScreen=screen;document.body.classList.add(this.currentScreen);}},showStartscreen:function browser_showStartscreen(){document.body.classList.add('start-page');this.startscreen.classList.remove('hidden');BrowserDB.getTopSites(this.MAX_TOP_SITES,null,function(places){this.showTopSiteThumbnails(places);this.loadRemaining();}.bind(this));Toolbar.bookmarkButton.classList.remove('bookmarked');},_topSiteThumbnailObjectURLs:[],clearTopSiteThumbnails:function browser_clearTopSiteThumbnails(){this.topSiteThumbnails.innerHTML='';this._topSiteThumbnailObjectURLs.forEach(function(url){URL.revokeObjectURL(url);});this._topSiteThumbnailObjectURLs=[];},hideStartscreen:function browser_hideStartScreen(){document.body.classList.remove('start-page');this.startscreen.classList.add('hidden');this.clearTopSiteThumbnails();},showTopSiteThumbnails:function browser_showStartscreenThumbnails(places){this.clearTopSiteThumbnails();var length=places.length;if(length==0){this.noTopSites.classList.remove('hidden');return;}else{this.noTopSites.classList.add('hidden');}
if(length%2&&length>1)
places.pop();if(length==1)
places.push({uri:'',title:''});places.forEach(function processPlace(place){var thumbnail=document.createElement('li');var link=document.createElement('a');var title=document.createElement('span');link.href=place.uri;title.textContent=place.title?place.title:place.uri;if(place.screenshot){var objectURL=URL.createObjectURL(place.screenshot);this._topSiteThumbnailObjectURLs.push(objectURL);link.style.backgroundImage='url('+objectURL+')';}
thumbnail.appendChild(link);thumbnail.appendChild(title);this.topSiteThumbnails.appendChild(thumbnail);},this);},showPageScreen:function browser_showPageScreen(){if(this.currentScreen===this.TABS_SCREEN){var switchLive=(function browser_switchLive(){this.mainScreen.removeEventListener('transitionend',switchLive,true);this.setTabVisibility(this.currentTab,true);}).bind(this);this.mainScreen.addEventListener('transitionend',switchLive,true);}else{this.setTabVisibility(this.currentTab,true);}
if(this.currentTab.loading){this.setUrlButtonMode(this.STOP);this.throbber.classList.add('loading');}else{var urlButton=this.currentTab.url?this.REFRESH:null;this.setUrlButtonMode(urlButton);this.throbber.classList.remove('loading');}
this.switchScreen(this.PAGE_SCREEN);this.setUrlBar(this.currentTab.title||this.currentTab.url);if(this.currentTab.crashed){this.showCrashScreen();}else{this.hideCrashScreen();}
this.updateTabsCount();this.inTransition=false;},_tabScreenObjectURLs:[],showTabScreen:function browser_showTabScreen(){this.hideCurrentTab();this.tabsBadge.innerHTML='';var ul=document.createElement('ul');this.tabsList.innerHTML='';this._tabScreenObjectURLs.forEach(function(url){URL.revokeObjectURL(url);});this._tabScreenObjectURLs=[];for(var tab in this.tabs){var li=this.generateTabLi(this.tabs[tab]);ul.appendChild(li);}
this.tabsList.appendChild(ul);this.switchScreen(this.TABS_SCREEN);this.screenSwipeMngr.gestureDetector.startDetecting();new GestureDetector(ul).startDetecting();this.inTransition=false;},generateTabLi:function browser_generateTabLi(tab){var title=tab.title||tab.url||_('new-tab');var a=document.createElement('a');var li=document.createElement('li');var span=document.createElement('span');var preview=document.createElement('div');var text=document.createTextNode(title);var close=document.createElement('button');close.classList.add('close');close.setAttribute('data-id',tab.id);a.appendChild(close);a.setAttribute('data-id',tab.id);preview.classList.add('preview');span.appendChild(text);a.appendChild(preview);a.appendChild(span);li.appendChild(a);if(tab.screenshot){var objectURL=URL.createObjectURL(tab.screenshot);this._tabScreenObjectURLs.push(objectURL);preview.style.backgroundImage='url('+objectURL+')';}
if(tab==this.currentTab){li.classList.add('current');}
return li;},showDangerDialog:function browser_showDangerDialog(title,btn,callback){var self=this;var msg=navigator.mozL10n.get(title);var ok=function(e){e.preventDefault();removeEventListeners();btn.setAttribute('disabled','disabled');self.dangerDialog.hidden=true;callback();};var cancel=function(e){e.preventDefault();removeEventListeners();self.dangerDialogCancel.removeEventListener('click',cancel);self.dangerDialog.hidden=true;};var removeEventListeners=function(){self.dangerDialogOk.removeEventListener('click',ok);self.dangerDialogCancel.removeEventListener('click',cancel);};this.dangerDialogMessage.textContent=msg;this.dangerDialog.hidden=false;this.dangerDialogOk.addEventListener('click',ok);this.dangerDialogCancel.addEventListener('click',cancel);},clearTabsSessionHistory:function browser_clearTabsSessionHistory(){var tabIds=Object.keys(this.tabs);tabIds.forEach(function(tabId){var tab=this.tabs[tabId];if(tab.dom.purgeHistory){tab.dom.purgeHistory().onsuccess=function(e){if(tab==this.currentTab){Toolbar.refreshButtons();}};}},this);},screenSwipeMngr:{TRANSITION_SPEED:1.8,TRANSITION_FRACTION:0.75,DEFAULT_TRANSITION:'transform 0.2s ease-in-out, height 0.2s ease-in-out',gestureDetector:null,browser:null,screen:null,winWidth:null,mousedown:function screenSwipe_mousedown(e){if(this.browser.currentScreen!==this.browser.TABS_SCREEN){return;}
e.preventDefault();this.winWidth=window.innerWidth;this.screen.style.MozTransition='none';},pan:function screenSwipe_pan(e){if(e.detail.absolute.dx<0){return;}
var leftPos=-(this.winWidth-50)+e.detail.absolute.dx;this.screen.style.transform='translate('+leftPos+'px)';},tap:function screenSwipe_tap(e){this.screen.style.MozTransition=this.DEFAULT_TRANSITION;this.browser.showPageScreen();},swipe:function screenSwipe_swipe(e){var fastenough=e.detail.vx>this.TRANSITION_SPEED;var distance=e.detail.start.screenX-e.detail.end.screenX;var farenough=Math.abs(distance)>this.winWidth*this.TRANSITION_FRACTION;this.screen.style.MozTransition=this.DEFAULT_TRANSITION;this.screen.style.transform='';if(farenough||fastenough){this.browser.showPageScreen();return;}}},tabsSwipeMngr:{TRANSITION_SPEED:1.8,TRANSITION_FRACTION:0.50,browser:null,tab:null,id:null,containerWidth:null,mousedown:function tabSwipe_mousedown(e){e.preventDefault();this.isCloseButton=e.target.nodeName==='BUTTON';this.tab=this.isCloseButton?e.target.parentNode:e.target;this.id=this.tab.getAttribute('data-id');this.containerWidth=this.tab.parentNode.clientWidth;if(this.isCloseButton){e.stopPropagation();return;}
if(this.browser.inTransition)
return;this.tab.classList.add('active');this.tab.style.MozTransition='';},pan:function tabSwipe_pan(e){if(this.browser.inTransition)
return;var movement=Math.min(this.containerWidth,Math.abs(e.detail.absolute.dx));if(movement>0){this.tab.style.opacity=1-(movement/this.containerWidth);}
this.tab.style.left=e.detail.absolute.dx+'px';},tap:function tabSwipe_tap(){if(this.browser.inTransition){return;}
if(this.isCloseButton){this.tab.style.left='0px';this.deleteTab(100,this.containerWidth);return;}
this.browser.selectTab(this.id);this.browser.showPageScreen();},swipe:function tabSwipe_swipe(e){if(this.browser.inTransition)
return;var distance=e.detail.start.screenX-e.detail.end.screenX;var fastenough=Math.abs(e.detail.vx)>this.TRANSITION_SPEED;var farenough=Math.abs(distance)>this.containerWidth*this.TRANSITION_FRACTION;if(!(farenough||fastenough)){var time=Math.abs(distance)/this.TRANSITION_SPEED;var transition='left '+time+'ms linear';this.tab.style.MozTransition=transition;this.tab.style.left='0px';this.tab.style.opacity=1;this.tab.classList.remove('active');return;}
var speed=Math.max(Math.abs(e.detail.vx),1.8);var time=(this.containerWidth-Math.abs(distance))/speed;var offset=e.detail.direction==='right'?this.containerWidth:-this.containerWidth;this.deleteTab(time,offset);},deleteTab:function tabSwipe_deleteTab(time,offset){var browser=this.browser;var id=this.id;var li=this.tab.parentNode;var self=this;this.tab.addEventListener('transitionend',function(){li.addEventListener('transitionend',function(e){browser.deleteTab(id);li.parentNode.removeChild(li);browser.updateTabsCount();},true);li.style.MozTransition='height '+100+'ms linear';li.style.height='0px';},true);this.tab.style.MozTransition='left '+time+'ms linear';this.tab.clientTop;this.tab.style.left=offset+'px';}},handleActivity:function browser_handleActivity(activity){switch(activity.source.data.type){case'url':var url=this.getUrlFromInput(activity.source.data.url);if(this.currentTab){if(this.currentTab.url){this.hideCurrentTab();this.selectTab(this.createTab(url));}else{this.navigate(url);}}
this.showPageScreen();break;}}};window.addEventListener('load',function browserOnLoad(evt){window.removeEventListener('load',browserOnLoad);Browser.init();});function actHandle(activity){if(Browser.hasLoaded){Browser.handleActivity(activity);}else{Browser.waitingActivities.push(activity);}}
if(window.navigator.mozSetMessageHandler){window.navigator.mozSetMessageHandler('activity',actHandle);};'use strict';var NfcURI={lookupUrlRecordType:function nfc_lookupUrlRecordType(uri){for(var i=1;i<NDEF.URIS.length;i++){var len=NDEF.URIS[i].length;if(uri.substring(0,len)==NDEF.URIS[i]){var uriPayload=uri.substring(len);return{'identifier':i,'uri':uriPayload};}}
return{'identifier':0,'uri':uri};},handlePeerConnectivity:function nfc_handlePeerConnectvity(event){var tnfId=NDEF.TNF_WELL_KNOWN;var rtdUri=NDEF.RTD_URI;var currentUrl;var records=[];var urlPayload=null;var abbreviate=true;currentUrl=Browser.currentTab.url;if(!currentUrl)
return null;if(abbreviate==true){var split=NfcURI.lookupUrlRecordType(currentUrl);if(split.identifier==0){urlPayload=currentUrl;}else{urlPayload=String.fromCharCode(split.identifier)+split.uri;}}else{urlPayload=currentUrl;}
if(!urlPayload)
return null;var payload=StringHelper.fromUTF8(urlPayload);var ids=new Uint8Array(0);var record=new MozNDEFRecord(tnfId,rtdUri,ids,payload);if(!record)
return null;records.push(record);var nfcdom=window.navigator.mozNfc;var nfcPeer=nfcdom.getNFCPeer(event.detail);if(!nfcPeer){return null;}
nfcPeer.sendNDEF(records);}};;'use strict';var idb=window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB||window.msIndexedDB;var BrowserDB={DEFAULT_ICON_EXPIRATION:86400000,MAX_ICON_SIZE:102400,TOP_SITE_SCREENSHOTS:4,init:function browserDB_init(callback){this.db.open(callback);},populate:function browserDB_populate(upgradeFrom,callback){console.log('Populating browser database.');SimpleOperatorVariantHelper.getOperatorVariant((function(mcc,mnc){Browser.getConfigurationData({mcc:mcc,mnc:mnc},(function(data){if(upgradeFrom<1&&data.bookmarks){data.bookmarks.forEach(function(bookmark){if(!bookmark.uri||!bookmark.title)
return;this.addBookmark(bookmark.uri,bookmark.title,callback);if(bookmark.iconUri)
this.setAndLoadIconForPage(bookmark.uri,bookmark.iconUri);},this);}
if(upgradeFrom<7&&data.searchEngines&&data.settings){var defaultSearchEngine=data.settings.defaultSearchEngine;if(defaultSearchEngine){this.updateSetting(defaultSearchEngine,'defaultSearchEngine');}
this.db.clearSearchEngines((function browserDB_addSearchEngines(){data.searchEngines.forEach(function(searchEngine){if(!searchEngine.uri||!searchEngine.title||!searchEngine.iconUri)
return;this.addSearchEngine(searchEngine,callback);if(searchEngine.uri==defaultSearchEngine){Browser.searchEngine=searchEngine;}
this.setAndLoadIconForPage(searchEngine.uri,searchEngine.iconUri);},this);}).bind(this));}}).bind(this));}).bind(this));},addPlace:function browserDB_addPlace(uri,callback){this.db.createPlace(uri,callback);},getPlace:function browserDB_getPlace(uri,callback){this.db.getPlace(uri,callback);},addVisit:function browserDB_addVisit(uri,callback){var visit={uri:uri,timestamp:new Date().getTime()};this.addPlace(uri,(function(){this.db.saveVisit(visit,(function(){this.updateFrecency(uri,callback);}).bind(this));}).bind(this));},updateFrecency:function browserDB_updateFrecency(uri,callback){this.db.updatePlaceFrecency(uri,callback);},updateScreenshot:function place_updateScreenshot(uri,screenshot,callback){var maximum=this.TOP_SITE_SCREENSHOTS;this.db.getPlaceUrisByFrecency(maximum+1,(function(topSites){if(topSites.length>maximum)
var runnerUp=topSites.pop();if(topSites.indexOf(uri)==-1)
return;this.db.updatePlaceScreenshot(uri,screenshot);if(runnerUp)
this.db.updatePlaceScreenshot(runnerUp,null);}).bind(this));},addBookmark:function browserDB_addBookmark(uri,title,callback){if(!title)
title=uri;var bookmark={uri:uri,title:title,timestamp:new Date().getTime()};this.addPlace(uri,(function(){this.db.saveBookmark(bookmark,callback);}).bind(this));},getBookmark:function browserDB_getBookmark(uri,callback){this.db.getBookmark(uri,callback);},getBookmarks:function browserDB_getBookmarks(callback){this.db.getAllBookmarks(callback);},getSearchEngines:function browserDB_getAllSearchEngines(callback){this.db.getAllSearchEngines(callback);},removeBookmark:function browserDB_removeBookmark(uri,callback){this.db.deleteBookmark(uri,callback);},updateBookmark:function browserDB_updateBookmark(uri,title,callback){this.db.getBookmark(uri,(function(bookmark){if(bookmark){bookmark.title=title;this.db.saveBookmark(bookmark,callback);}else{this.addBookmark(uri,title,callback);}}).bind(this));},setPageTitle:function browserDB_setPageTitle(uri,title,callback){this.db.updatePlaceTitle(uri,title,callback);},setPageIconUri:function browserDB_setPageIconUri(uri,iconUri,callback){this.db.updatePlaceIconUri(uri,iconUri,callback);},setIconData:function browserDB_setIconData(iconUri,data,callback,failed){var now=new Date().valueOf();var iconEntry={uri:iconUri,data:data,expiration:now+this.DEFAULT_ICON_EXPIRATION,failed:failed};this.db.saveIcon(iconEntry,callback);},setAndLoadIconForPage:function browserDB_setAndLoadIconForPage(uri,iconUri,callback){this.setPageIconUri(uri,iconUri);var now=new Date().valueOf();this.db.getIcon(iconUri,(function(icon){if(icon&&icon.expiration>now)
return;var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',iconUri,true);xhr.responseType='blob';xhr.addEventListener('load',(function(){if(!(xhr.status===200||xhr.status===0)){this.setIconData(iconUri,null,callback,true);console.log('error downloading icon: '+xhr.status);return;}
var blob=xhr.response;if(blob.type.split('/')[0]!='image'||blob.size>this.MAX_ICON_SIZE){this.setIconData(iconUri,null,callback,true);console.log('Icon was not an image or was too big');return;}
var img=document.createElement('img');var src=window.URL.createObjectURL(blob);img.src=src;img.onload=(function(){if(img.naturalWidth>0){this.setIconData(iconUri,blob,callback);}else{this.setIconData(iconUri,null,callback,true);console.log('Icon not saved because less than 1px wide');}
window.URL.revokeObjectURL(src);}).bind(this);img.onerror=(function(){this.setIconData(iconUri,null,callback,true);console.log('Icon not saved because can not be decoded');window.URL.revokeObjectURL(src);}).bind(this);}).bind(this),false);xhr.onerror=function getIconError(){console.log('Error fetching icon');};xhr.send();}).bind(this));},getTopSites:function browserDB_getTopSites(maximum,filter,callback){this.db.getPlacesByFrecency(maximum,filter,callback);},getHistory:function browserDB_getHistory(callback){this.db.getHistory(20,callback);},clearHistory:function browserDB_clearHistory(callback){this.db.getAllBookmarkUris((function(bookmarks){this.db.clearHistoryExcluding(bookmarks,callback);}).bind(this));},addSearchEngine:function browserDB_addSearchEngine(data,callback){if(!data.uri||!data.title)
return;this.db.saveSearchEngine(data,callback);},getSearchEngine:function browserDB_getSearchEngine(uri,callback){this.db.getSearchEngine(uri,callback);},updateSetting:function browserDB_updateSetting(key,value,callback){this.db.updateSetting(key,value,callback);},getSetting:function browserDB_getSetting(key,callback){this.db.getSetting(key,callback);}};BrowserDB.db={_db:null,START_PAGE_URI:document.location.protocol+'//'+document.location.host+'/start.html',upgradeFrom:-1,open:function db_open(callback){const DB_VERSION=7;const DB_NAME='browser';var request=idb.open(DB_NAME,DB_VERSION);request.onupgradeneeded=(function onUpgradeNeeded(e){console.log('Browser database upgrade needed, upgrading.');this.upgradeFrom=e.oldVersion;this._db=e.target.result;this.upgrade();}).bind(this);request.onsuccess=(function onSuccess(e){this._db=e.target.result;callback();if(this.upgradeFrom!=-1)
BrowserDB.populate(this.upgradeFrom);}).bind(this);request.onerror=(function onDatabaseError(e){console.log('Error opening browser database');}).bind(this);},upgrade:function db_upgrade(){var db=this._db;var upgradeFrom=this.upgradeFrom;if(upgradeFrom<1){var placesStore=db.createObjectStore('places',{keyPath:'uri'});placesStore.createIndex('frecency','frecency',{unique:false});var visitStore=db.createObjectStore('visits',{autoIncrement:true});visitStore.createIndex('timestamp','timestamp',{unique:false});db.createObjectStore('icons',{keyPath:'uri'});var bookmarkStore=db.createObjectStore('bookmarks',{keyPath:'uri'});bookmarkStore.createIndex('timestamp','timestamp',{unique:false});}
if(upgradeFrom<6){db.createObjectStore('settings');db.createObjectStore('search_engines',{keyPath:'uri'});}},createPlace:function db_createPlace(uri,callback){var transaction=this._db.transaction(['places'],'readwrite');var objectStore=transaction.objectStore('places');var readRequest=objectStore.get(uri);readRequest.onsuccess=function onReadSuccess(event){var place=event.target.result;if(place){if(callback)
callback();return;}else{place={uri:uri,title:uri};}
var writeRequest=objectStore.add(place);writeRequest.onsuccess=function onWriteSuccess(event){if(callback)
callback();};writeRequest.onerror=function onError(event){console.log('error writing place');};};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save place '+
uri);};},getPlace:function db_getPlace(uri,callback){var db=this._db;var request=db.transaction('places').objectStore('places').get(uri);request.onsuccess=function onSuccess(event){callback(event.target.result);};request.onerror=function onError(event){if(event.target.errorCode==IDBDatabaseException.NOT_FOUND_ERR)
callback();};},updatePlace:function db_updatePlace(place,callback){var transaction=this._db.transaction(['places'],'readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to update place: '+
place.uri);};var objectStore=transaction.objectStore('places');var request=objectStore.put(place);request.onsuccess=function onSuccess(e){if(callback)
callback();};request.onerror=function onError(e){console.log('Error while updating place in global history store: '+
place.uri);};},saveVisit:function db_saveVisit(visit,callback){var transaction=this._db.transaction(['visits'],'readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save visit');};var objectStore=transaction.objectStore('visits');var request=objectStore.add(visit);request.onerror=function onError(e){console.log('Error while adding visit to global history store');};request.onsuccess=function onSuccess(e){if(callback)
callback();};},getHistory:function db_getHistory(maximum,callback){var history=[];var db=this._db;function makeVisitProcessor(visit){return function(e){var place=e.target.result;visit.title=place.title;visit.iconUri=place.iconUri;history.push(visit);};}
var transaction=db.transaction(['visits','places']);var visitsStore=transaction.objectStore('visits');var placesStore=transaction.objectStore('places');visitsStore.openCursor(null,'prev').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor&&history.length<maximum){var visit=cursor.value;placesStore.get(visit.uri).onsuccess=makeVisitProcessor(visit);cursor.continue();}else{callback(history);}};},getPlacesByFrecency:function db_placesByFrecency(maximum,filter,callback){var topSites=[];var self=this;var transaction=self._db.transaction('places');var placesStore=transaction.objectStore('places');var frecencyIndex=placesStore.index('frecency');frecencyIndex.openCursor(null,'prev').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor&&topSites.length<maximum){var place=cursor.value;var matched=false;if(filter)
matched=self.matchesFilter(place.uri,filter)||self.matchesFilter(place.title,filter);if(matched||!filter){topSites.push(cursor.value);}
cursor.continue();}else{callback(topSites,filter);}};},matchesFilter:function db_matchesFilter(uri,filter){return uri.match(new RegExp(filter,'i'))!==null;},getPlaceUrisByFrecency:function db_getPlaceUrisByFrecency(maximum,callback){var topSites=[];var transaction=this._db.transaction('places');var placesStore=transaction.objectStore('places');var frecencyIndex=placesStore.index('frecency');frecencyIndex.openCursor(null,'prev').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor&&topSites.length<maximum){topSites.push(cursor.value.uri);cursor.continue();}else{callback(topSites);}};},clearPlaces:function db_clearPlaces(callback){var db=BrowserDB.db._db;var transaction=db.transaction('places','readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to clear places');};var objectStore=transaction.objectStore('places');var request=objectStore.clear();request.onsuccess=function onSuccess(){callback();};request.onerror=function onError(e){console.log('Error clearing places object store');};},clearVisits:function db_clearVisits(callback){var db=BrowserDB.db._db;var transaction=db.transaction('visits','readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to clear visits');};var objectStore=transaction.objectStore('visits');var request=objectStore.clear();request.onsuccess=function onSuccess(){if(callback)
callback();};request.onerror=function onError(e){console.log('Error clearing visits object store');};},clearIcons:function db_clearIcons(callback){var db=BrowserDB.db._db;var transaction=db.transaction('icons','readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to clear icons');};var objectStore=transaction.objectStore('icons');var request=objectStore.clear();request.onsuccess=function onSuccess(){callback();};request.onerror=function onError(e){console.log('Error clearing icons object store');};},clearBookmarks:function db_clearBookmarks(callback){var db=BrowserDB.db._db;var transaction=db.transaction('bookmarks','readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to clear bookmarks');};var objectStore=transaction.objectStore('bookmarks');var request=objectStore.clear();request.onsuccess=function onSuccess(){callback();};request.onerror=function onError(e){console.log('Error clearing bookmarks object store');};},saveIcon:function db_saveIcon(iconEntry,callback){var transaction=this._db.transaction(['icons'],'readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save icon');};var objectStore=transaction.objectStore('icons');var request=objectStore.put(iconEntry);request.onsuccess=function onSuccess(e){if(callback)
callback();};request.onerror=function onError(e){console.log('Error while saving icon');};},getIcon:function db_getIcon(iconUri,callback){var request=this._db.transaction('icons').objectStore('icons').get(iconUri);request.onsuccess=function onSuccess(event){callback(event.target.result);};request.onerror=function onError(event){if(event.target.errorCode==IDBDatabaseException.NOT_FOUND_ERR)
callback();};},saveBookmark:function db_saveBookmark(bookmark,callback){var transaction=this._db.transaction(['bookmarks'],'readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save bookmark');};var objectStore=transaction.objectStore('bookmarks');var request=objectStore.put(bookmark);request.onsuccess=function onSuccess(e){if(callback)
callback();};request.onerror=function onError(e){console.log('Error while saving bookmark');};},getBookmark:function db_getBookmark(uri,callback){var request=this._db.transaction('bookmarks').objectStore('bookmarks').get(uri);request.onsuccess=function onSuccess(event){callback(event.target.result);};request.onerror=function onError(event){if(event.target.errorCode==IDBDatabaseException.NOT_FOUND_ERR)
callback();};},deleteBookmark:function db_deleteBookmark(uri,callback){var transaction=this._db.transaction(['bookmarks'],'readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to delete bookmark');};var objectStore=transaction.objectStore('bookmarks');var request=objectStore.delete(uri);request.onsuccess=function onSuccess(event){if(callback)
callback();};request.onerror=function onError(e){console.log('Error while deleting bookmark');};},getAllBookmarks:function db_getAllBookmarks(callback){var bookmarks=[];var db=this._db;function makeBookmarkProcessor(bookmark){return function(e){var place=e.target.result;bookmark.iconUri=place.iconUri;bookmarks.push(bookmark);};}
var transaction=db.transaction(['bookmarks','places']);var bookmarksStore=transaction.objectStore('bookmarks');var bookmarksIndex=bookmarksStore.index('timestamp');var placesStore=transaction.objectStore('places');bookmarksIndex.openCursor(null,'prev').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor){var bookmark=cursor.value;placesStore.get(bookmark.uri).onsuccess=makeBookmarkProcessor(bookmark);cursor.continue();}};transaction.oncomplete=function db_bookmarkTransactionComplete(){callback(bookmarks);};},getAllBookmarkUris:function db_getAllBookmarks(callback){var uris=[];var db=this._db;var transaction=db.transaction('bookmarks');var objectStore=transaction.objectStore('bookmarks');objectStore.openCursor(null,'prev').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor){uris.push(cursor.value.uri);cursor.continue();}};transaction.oncomplete=function db_bookmarkTransactionComplete(){callback(uris);};},updatePlaceFrecency:function db_updatePlaceFrecency(uri,callback){if(uri==this.START_PAGE_URI){if(callback)
callback();return;}
var transaction=this._db.transaction(['places'],'readwrite');var objectStore=transaction.objectStore('places');var readRequest=objectStore.get(uri);readRequest.onsuccess=function onReadSuccess(event){var place=event.target.result;if(!place)
return;if(!place.frecency){place.frecency=1;}else{place.frecency++;}
var writeRequest=objectStore.put(place);writeRequest.onerror=function onError(){console.log('Error while saving new frecency for '+uri);};writeRequest.onsuccess=function onWriteSuccess(){if(callback)
callback();};};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to update place: '+
place.uri);};},resetPlaceFrecency:function db_resetPlaceFrecency(uri,callback){var transaction=this._db.transaction(['places'],'readwrite');var objectStore=transaction.objectStore('places');var readRequest=objectStore.get(uri);readRequest.onsuccess=function onReadSuccess(event){var place=event.target.result;if(!place)
return;place.frecency=null;var writeRequest=objectStore.put(place);writeRequest.onerror=function onError(){console.log('Error while resetting frecency for '+uri);};writeRequest.onsuccess=function onWriteSuccess(){if(callback)
callback();};};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to reset frecency: '+
place.uri);};},updatePlaceIconUri:function db_updatePlaceIconUri(uri,iconUri,callback){var transaction=this._db.transaction(['places'],'readwrite');var objectStore=transaction.objectStore('places');var readRequest=objectStore.get(uri);readRequest.onsuccess=function onReadSuccess(event){var place=event.target.result;if(place){place.iconUri=iconUri;}else{place={uri:uri,title:uri,iconUri:iconUri};}
var writeRequest=objectStore.put(place);writeRequest.onerror=function onError(){console.log('Error while saving iconUri for '+uri);};};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save iconUri for '+
place.uri);};transaction.onsuccess=function dbTransactionSuccess(e){if(callback)
callback();};},updatePlaceTitle:function db_updatePlaceTitle(uri,title,callback){var transaction=this._db.transaction(['places'],'readwrite');var objectStore=transaction.objectStore('places');var readRequest=objectStore.get(uri);readRequest.onsuccess=function onReadSuccess(event){var place=event.target.result;if(place){place.title=title;}else{place={uri:uri,title:title};}
var writeRequest=objectStore.put(place);writeRequest.onerror=function onError(){console.log('Error while saving title for '+uri);};writeRequest.onsuccess=function onWriteSuccess(){if(callback)
callback();};};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save title for '+
place.uri);};},updatePlaceScreenshot:function db_updatePlaceScreenshot(uri,screenshot,callback){var transaction=this._db.transaction(['places'],'readwrite');var objectStore=transaction.objectStore('places');var readRequest=objectStore.get(uri);readRequest.onsuccess=function onReadSuccess(event){var place=event.target.result;if(place){place.screenshot=screenshot;}else{place={uri:uri,title:uri,screenshot:screenshot};}
var writeRequest=objectStore.put(place);writeRequest.onerror=function onError(){console.log('Error while saving screenshot for '+uri);};writeRequest.onsuccess=function onWriteSuccess(){if(callback)
callback();};};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save screenshot for '+
place.uri);};},clearHistoryExcluding:function db_clearHistoryExcluding(exceptions,callback){this.clearVisits();var transaction=this._db.transaction(['places','icons'],'readwrite');var placesStore=transaction.objectStore('places');var iconStore=transaction.objectStore('icons');placesStore.openCursor(null,'prev').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor){var place=cursor.value;if(exceptions.indexOf(place.uri)==-1){placesStore.delete(place.uri);if(place.iconUri){iconStore.delete(place.iconUri);}}else{BrowserDB.db.resetPlaceFrecency(place.uri);}
cursor.continue();}};transaction.oncomplete=function db_bookmarkTransactionComplete(){if(callback)
callback();};},saveSearchEngine:function db_saveSearchEngine(data,callback){var transaction=this._db.transaction(['search_engines'],'readwrite');var objectStore=transaction.objectStore('search_engines');var request=objectStore.put(data);transaction.oncomplete=function onComplete(e){if(callback)
callback();};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to save search engine');};request.onerror=function onError(e){console.log('Error while saving search engine');};},getSearchEngine:function db_getSearchEngine(uri,callback){var transaction=this._db.transaction('search_engines');var request=transaction.objectStore('search_engines').get(uri);request.onsuccess=function onSuccess(event){callback(event.target.result);};transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to get search engine');};request.onerror=function onError(event){if(event.target.errorCode==IDBDatabaseException.NOT_FOUND_ERR)
callback();};},getAllSearchEngines:function db_getAllSearchEngines(callback){var result=[];var db=this._db;var transaction=db.transaction('search_engines');var objectStore=transaction.objectStore('search_engines');objectStore.openCursor(null,'next').onsuccess=function onSuccess(e){var cursor=e.target.result;if(cursor){result.push(cursor.value);cursor.continue();}};transaction.oncomplete=function db_bookmarkTransactionComplete(){callback(result);};},clearSearchEngines:function db_clearSearchEngines(callback){var db=BrowserDB.db._db;var transaction=db.transaction('search_engines','readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to clear search engines');};var objectStore=transaction.objectStore('search_engines');var request=objectStore.clear();request.onsuccess=function onSuccess(){callback();};request.onerror=function onError(e){console.log('Error clearing search engines object store');};},updateSetting:function db_updateSetting(value,key,callback){var transaction=this._db.transaction(['settings'],'readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to update setting');};var objectStore=transaction.objectStore('settings');var request=objectStore.put(value,key);request.onsuccess=function onSuccess(e){if(callback)
callback();};request.onerror=function onError(e){console.log('Error while updating setting');};},getSetting:function db_getSetting(key,callback){var request=this._db.transaction('settings').objectStore('settings').get(key);request.onsuccess=function onSuccess(event){callback(event.target.result);};request.onerror=function onError(event){if(event.target.errorCode==IDBDatabaseException.NOT_FOUND_ERR)
callback();};},clearSettings:function db_clearSettings(callback){var db=BrowserDB.db._db;var transaction=db.transaction('settings','readwrite');transaction.onerror=function dbTransactionError(e){console.log('Transaction error while trying to clear settings');};var objectStore=transaction.objectStore('settings');var request=objectStore.clear();request.onsuccess=function onSuccess(){callback();};request.onerror=function onError(e){console.log('Error clearing settings object store');};}};;'use strict';var Toolbar={init:function toolbar_init(){this.backButton=document.getElementById('back-button');this.forwardButton=document.getElementById('forward-button');this.shareButton=document.getElementById('share-button');this.bookmarkButton=document.getElementById('bookmark-button');this.shareButton.addEventListener('click',this.handleShareButtonClick.bind(this));this.backButton.addEventListener('click',Browser.goBack.bind(Browser));this.forwardButton.addEventListener('click',Browser.goForward.bind(Browser));this.bookmarkButton.addEventListener('click',Browser.showBookmarkMenu.bind(Browser));},refreshBookmarkButton:function toolbar_refreshBookmarkButton(){if(!Browser.currentTab.url){this.bookmarkButton.classList.remove('bookmarked');return;}
BrowserDB.getBookmark(Browser.currentTab.url,(function(bookmark){if(bookmark){this.bookmarkButton.classList.add('bookmarked');}else{this.bookmarkButton.classList.remove('bookmarked');}}).bind(this));},refreshButtons:function toolbar_refreshButtons(){if(!Browser.currentTab.dom.getCanGoBack){return;}
Browser.currentTab.dom.getCanGoBack().onsuccess=(function(e){this.backButton.disabled=!e.target.result;}).bind(this);Browser.currentTab.dom.getCanGoForward().onsuccess=(function(e){this.forwardButton.disabled=!e.target.result;}).bind(this);this.refreshBookmarkButton();},handleShareButtonClick:function toolbar_handleShareButtonClick(evt){if(this.shareButton.disabled){return;}
this.shareButton.disabled=true;var activity=new MozActivity({name:'share',data:{type:'url',url:Browser.currentTab.url}});activity.onsuccess=(function success(){this.shareButton.disabled=false;}).bind(this);activity.onerror=(function error(){this.shareButton.disabled=false;}).bind(this);}};window.addEventListener('load',function toolbarOnLoad(evt){window.removeEventListener('load',toolbarOnLoad);Toolbar.init();});