;'use strict';var BlobView=(function(){function fail(msg){throw Error(msg);}
function BlobView(blob,sliceOffset,sliceLength,slice,viewOffset,viewLength,littleEndian)
{this.blob=blob;this.sliceOffset=sliceOffset;this.sliceLength=sliceLength;this.slice=slice;this.viewOffset=viewOffset;this.viewLength=viewLength;this.littleEndian=littleEndian;this.view=new DataView(slice,viewOffset,viewLength);this.buffer=slice;this.byteLength=viewLength;this.byteOffset=viewOffset;this.index=0;}
BlobView.get=function(blob,offset,length,callback,littleEndian){if(offset<0)
fail('negative offset');if(length<0)
fail('negative length');if(offset>blob.size)
fail('offset larger than blob size');if(offset+length>blob.size)
length=blob.size-offset;var slice=blob.slice(offset,offset+length);var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){var result=null;if(reader.result){result=new BlobView(blob,offset,length,reader.result,0,length,littleEndian||false);}
callback(result,reader.error);};};BlobView.prototype={constructor:BlobView,getMore:function(offset,length,callback){if(offset>=this.sliceOffset&&offset+length<=this.sliceOffset+this.sliceLength){callback(new BlobView(this.blob,this.sliceOffset,this.sliceLength,this.slice,offset-this.sliceOffset,length,this.littleEndian));}
else{BlobView.get(this.blob,offset,length,callback,this.littleEndian);}},littleEndian:function(){this.littleEndian=true;},bigEndian:function(){this.littleEndian=false;},getUint8:function(offset){return this.view.getUint8(offset);},getInt8:function(offset){return this.view.getInt8(offset);},getUint16:function(offset,le){return this.view.getUint16(offset,le!==undefined?le:this.littleEndian);},getInt16:function(offset,le){return this.view.getInt16(offset,le!==undefined?le:this.littleEndian);},getUint32:function(offset,le){return this.view.getUint32(offset,le!==undefined?le:this.littleEndian);},getInt32:function(offset,le){return this.view.getInt32(offset,le!==undefined?le:this.littleEndian);},getFloat32:function(offset,le){return this.view.getFloat32(offset,le!==undefined?le:this.littleEndian);},getFloat64:function(offset,le){return this.view.getFloat64(offset,le!==undefined?le:this.littleEndian);},readByte:function(){return this.view.getInt8(this.index++);},readUnsignedByte:function(){return this.view.getUint8(this.index++);},readShort:function(le){var val=this.view.getInt16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readUnsignedShort:function(le){var val=this.view.getUint16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readInt:function(le){var val=this.view.getInt32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readUnsignedInt:function(le){var val=this.view.getUint32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readFloat:function(le){var val=this.view.getFloat32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readDouble:function(le){var val=this.view.getFloat64(this.index,le!==undefined?le:this.littleEndian);this.index+=8;return val;},tell:function(){return this.index;},remaining:function(){return this.byteLength-this.index;},seek:function(index){if(index<0)
fail('negative index');if(index>this.byteLength)
fail('index greater than buffer size');this.index=index;},advance:function(n){var index=this.index+n;if(index<0)
fail('advance past beginning of buffer');if(index>this.byteLength)
fail('advance past end of buffer');this.index=index;},getUnsignedByteArray:function(offset,n){return new Uint8Array(this.buffer,offset+this.viewOffset,n);},readUnsignedByteArray:function(n){var val=new Uint8Array(this.buffer,this.index+this.viewOffset,n);this.index+=n;return val;},getBit:function(offset,bit){var byte=this.view.getUint8(offset);return(byte&(1<<bit))!==0;},getUint24:function(offset,le){var b1,b2,b3;if(le!==undefined?le:this.littleEndian){b1=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b3=this.view.getUint8(offset+2);}
else{b3=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b1=this.view.getUint8(offset+2);}
return(b3<<16)+(b2<<8)+b1;},readUint24:function(le){var value=this.getUint24(this.index,le);this.index+=3;return value;},getASCIIText:function(offset,len){var bytes=new Uint8Array(this.buffer,offset+this.viewOffset,len);return String.fromCharCode.apply(String,bytes);},readASCIIText:function(len){var bytes=new Uint8Array(this.buffer,this.index+this.viewOffset,len);this.index+=len;return String.fromCharCode.apply(String,bytes);},getUTF8Text:function(offset,len){function fail(){throw new Error('Illegal UTF-8');}
var pos=offset;var end=offset+len;var charcode;var s='';var b1,b2,b3,b4;while(pos<end){var b1=this.view.getUint8(pos);if(b1<128){s+=String.fromCharCode(b1);pos+=1;}
else if(b1<194){fail();}
else if(b1<224){if(pos+1>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();charcode=((b1&0x1f)<<6)+(b2&0x3f);s+=String.fromCharCode(charcode);pos+=2;}
else if(b1<240){if(pos+2>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();b3=this.view.getUint8(pos+2);if(b3<128||b3>191)
fail();charcode=((b1&0x0f)<<12)+((b2&0x3f)<<6)+(b3&0x3f);s+=String.fromCharCode(charcode);pos+=3;}
else if(b1<245){if(pos+3>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();b3=this.view.getUint8(pos+2);if(b3<128||b3>191)
fail();b4=this.view.getUint8(pos+3);if(b4<128||b4>191)
fail();charcode=((b1&0x07)<<18)+
((b2&0x3f)<<12)+
((b3&0x3f)<<6)+
(b4&0x3f);charcode-=0x10000;s+=String.fromCharCode(0xd800+((charcode&0x0FFC00)>>>10));s+=String.fromCharCode(0xdc00+(charcode&0x0003FF));pos+=4;}
else{fail();}}
return s;},readUTF8Text:function(len){try{return this.getUTF8Text(this.index,len);}
finally{this.index+=len;}},getID3Uint28BE:function(offset){var b1=this.view.getUint8(offset)&0x7f;var b2=this.view.getUint8(offset+1)&0x7f;var b3=this.view.getUint8(offset+2)&0x7f;var b4=this.view.getUint8(offset+3)&0x7f;return(b1<<21)|(b2<<14)|(b3<<7)|b4;},readID3Uint28BE:function(){var value=this.getID3Uint28BE(this.index);this.index+=4;return value;},readNullTerminatedLatin1Text:function(size){var s='';for(var i=0;i<size;i++){var charcode=this.view.getUint8(this.index+i);if(charcode===0){i++;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;},readNullTerminatedUTF8Text:function(size){for(var len=0;len<size;len++){if(this.view.getUint8(this.index+len)===0)
break;}
var s=this.readUTF8Text(len);if(len<size)
this.advance(1);return s;},readNullTerminatedUTF16Text:function(size,le){if(le==null){var BOM=this.readUnsignedShort();size-=2;if(BOM===0xFEFF)
le=false;else
le=true;}
var s='';for(var i=0;i<size;i+=2){var charcode=this.getUint16(this.index+i,le);if(charcode===0){i+=2;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;}};return{get:BlobView.get};}());;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';function parseAudioMetadata(blob,metadataCallback,errorCallback){var filename=blob.name;if(filename){if(filename.slice(0,5)==='DCIM/'&&filename.slice(-4).toLowerCase()==='.3gp'){errorCallback('skipping 3gp video file');return;}
if(filename.slice(-4).toLowerCase()==='.m4v'){errorCallback('skipping m4v video file');return;}}
if(blob.size<128){errorCallback('file is empty or too small');return;}
var TITLE='title';var ARTIST='artist';var ALBUM='album';var TRACKNUM='tracknum';var IMAGE='picture';var RATED='rated';var PLAYED='played';var ID3V2TAGS={TIT2:TITLE,TT2:TITLE,TPE1:ARTIST,TP1:ARTIST,TALB:ALBUM,TAL:ALBUM,TRCK:TRACKNUM,TRK:TRACKNUM,APIC:IMAGE,PIC:IMAGE};var OGGTAGS={title:TITLE,artist:ARTIST,album:ALBUM,tracknumber:TRACKNUM};var MP4TAGS={'\xa9alb':ALBUM,'\xa9art':ARTIST,'\xa9ART':ARTIST,'aART':ARTIST,'\xa9nam':TITLE,'trkn':TRACKNUM,'covr':IMAGE};var MP4Types={'M4A ':true,'M4B ':true,'mp41':true,'mp42':true,'isom':true,'iso2':true};var MP4Codecs={'mp4a':true,'samr':true,'sawb':true,'sawp':true};var metadata={};metadata[ARTIST]=metadata[ALBUM]=metadata[TITLE]='';metadata[RATED]=metadata[PLAYED]=0;if(filename){var p1=filename.lastIndexOf('/');var p2=filename.lastIndexOf('.');if(p2===-1)
p2=filename.length;metadata[TITLE]=filename.substring(p1+1,p2);}
var headersize=Math.min(64*1024,blob.size);BlobView.get(blob,0,headersize,function(header,error){if(error){errorCallback(error);return;}
try{var magic=header.getASCIIText(0,12);if(magic.substring(0,9)==='LOCKED 1 '){handleLockedFile(blob);return;}
if(magic.substring(0,3)==='ID3'){parseID3v2Metadata(header);}
else if(magic.substring(0,4)==='OggS'){parseOggMetadata(header);}
else if(magic.substring(4,8)==='ftyp'){if(checkMP4Type(header,MP4Types)){parseMP4Metadata(header);}
else{errorCallback('Unknown MP4 file type');}}
else if((header.getUint16(0,false)&0xFFFE)===0xFFFA){BlobView.get(blob,blob.size-128,128,function(footer,error){if(error){errorCallback(error);return;}
try{var magic=footer.getASCIIText(0,3);if(magic==='TAG'){parseID3v1Metadata(footer);}
else{metadataCallback(metadata);}}
catch(e){errorCallback(e);}});}
else{var player=new Audio();player.mozAudioChannelType='content';var canplay=blob.type&&player.canPlayType(blob.type);if(canplay==='probably'){metadataCallback(metadata);}
else{var url=URL.createObjectURL(blob);player.src=url;player.onerror=function(){URL.revokeObjectURL(url);player.removeAttribute('src');player.load();errorCallback('Unplayable music file');};player.oncanplay=function(){URL.revokeObjectURL(url);player.removeAttribute('src');player.load();metadataCallback(metadata);};}}}
catch(e){console.error('parseAudioMetadata:',e,e.stack);errorCallback(e);}});function parseID3v1Metadata(footer){var title=footer.getASCIIText(3,30);var artist=footer.getASCIIText(33,30);var album=footer.getASCIIText(63,30);var p=title.indexOf('\0');if(p!==-1)
title=title.substring(0,p);p=artist.indexOf('\0');if(p!==-1)
artist=artist.substring(0,p);p=album.indexOf('\0');if(p!==-1)
album=album.substring(0,p);metadata[TITLE]=title||undefined;metadata[ARTIST]=artist||undefined;metadata[ALBUM]=album||undefined;var b1=footer.getUint8(125);var b2=footer.getUint8(126);if(b1===0&&b2!==0)
metadata[TRACKNUM]=b2;metadataCallback(metadata);}
function parseID3v2Metadata(header){header.index=3;var id3version=header.readUnsignedByte();if(id3version>4){console.warn('mp3 file with unknown metadata version');metadataCallback(metadata);return;}
var id3revision=header.readUnsignedByte();var id3flags=header.readUnsignedByte();var needs_unsynchronization=((id3flags&0x80)!==0);var has_extended_header=((id3flags&0x40)!==0);var length=header.readID3Uint28BE();if(needs_unsynchronization){console.warn('mp3 file uses unsynchronization. Can\'t read metadata');metadataCallback(metadata);return;}
header.getMore(header.index,length,parseID3);function parseID3(id3){if(has_extended_header){id3.advance(id3.readUnsignedInt());}
while(id3.index<id3.byteLength){var tagid,tagsize,tagflags;if(id3.getUint8(id3.index)===0)
break;switch(id3version){case 2:tagid=id3.readASCIIText(3);tagsize=id3.readUint24();tagflags=0;break;case 3:tagid=id3.readASCIIText(4);tagsize=id3.readUnsignedInt();tagflags=id3.readUnsignedShort();break;case 4:tagid=id3.readASCIIText(4);tagsize=id3.readID3Uint28BE();tagflags=id3.readUnsignedShort();break;}
var nexttag=id3.index+tagsize;var tagname=ID3V2TAGS[tagid];if(!tagname){id3.index=nexttag;continue;}
if((tagflags&0xFF)!==0){console.warn('Skipping',tagid,'tag with flags',tagflags);id3.index=nexttag;continue;}
try{var tagvalue=null;switch(tagid){case'TIT2':case'TT2':case'TPE1':case'TP1':case'TALB':case'TAL':tagvalue=readText(id3,tagsize);break;case'TRCK':case'TRK':tagvalue=parseInt(readText(id3,tagsize));break;case'APIC':case'PIC':tagvalue=readPic(id3,tagsize,tagid);break;}
if(tagvalue!==null)
metadata[tagname]=tagvalue;}
catch(e){console.warn('Error parsing mp3 metadata tag',tagid,':',e);}
id3.index=nexttag;}
handleCoverArt(metadata);}
function readPic(view,size,id){var start=view.index;var encoding=view.readUnsignedByte();var mimetype;if(id==='PIC'){mimetype=view.readASCIIText(3);if(mimetype==='JPG')
mimetype='image/jpeg';else if(mimetype==='PNG')
mimetype='image/png';}
else{mimetype=view.readNullTerminatedLatin1Text(size-1);}
var kind=view.readUnsignedByte();var desc=readText(view,size-(view.index-start),encoding);var picstart=view.sliceOffset+view.viewOffset+view.index;var piclength=size-(view.index-start);return{start:picstart,end:picstart+piclength,type:mimetype};}
function readText(view,size,encoding){if(encoding===undefined){encoding=view.readUnsignedByte();size=size-1;}
switch(encoding){case 0:return view.readNullTerminatedLatin1Text(size);case 1:return view.readNullTerminatedUTF16Text(size,undefined);case 2:return view.readNullTerminatedUTF16Text(size,false);case 3:return view.readNullTerminatedUTF8Text(size);default:throw Error('unknown text encoding');}}}
function parseOggMetadata(header){function sum(x,y){return x+y;}
var p1_num_segments=header.getUint8(26);var p1_segment_lengths=header.getUnsignedByteArray(27,p1_num_segments);var p1_length=Array.reduce(p1_segment_lengths,sum,0);var p2_header=27+p1_num_segments+p1_length;var p2_num_segments=header.getUint8(p2_header+26);var p2_segment_lengths=header.getUnsignedByteArray(p2_header+27,p2_num_segments);var p2_length=Array.reduce(p2_segment_lengths,sum,0);var p2_offset=p2_header+27+p2_num_segments;header.getMore(p2_offset,p2_length,function(page,error){if(error){errorCallback(error);return;}
var first_byte=page.readByte();var valid=false;switch(first_byte){case 3:valid=page.readASCIIText(6)==='vorbis';break;case 79:valid=page.readASCIIText(7)==='pusTags';break;}
if(!valid){errorCallback('malformed ogg comment packet');return;}
var vendor_string_length=page.readUnsignedInt(true);page.advance(vendor_string_length);var num_comments=page.readUnsignedInt(true);var seen_fields={};for(var i=0;i<num_comments;i++){if(page.remaining()<4){break;}
var comment_length=page.readUnsignedInt(true);if(comment_length>page.remaining()){break;}
var comment=page.readUTF8Text(comment_length);var equal=comment.indexOf('=');if(equal!==-1){var tag=comment.substring(0,equal).toLowerCase().replace(' ','');var propname=OGGTAGS[tag];if(propname){var value=comment.substring(equal+1);if(seen_fields.hasOwnProperty(propname)){metadata[propname]+=' '+value;}
else{metadata[propname]=value;seen_fields[propname]=true;}}}}
handleCoverArt(metadata);});}
function checkMP4Type(header,types){var majorbrand=header.getASCIIText(8,4);if(majorbrand in types){return true;}
else{var index=16;var size=header.getUint32(0);while(index<size){var compatiblebrand=header.getASCIIText(index,4);index+=4;if(compatiblebrand in types)
return true;}
return false;}}
function parseMP4Metadata(header){findMoovAtom(header);function findMoovAtom(atom){try{var offset=atom.sliceOffset+atom.viewOffset;var size=atom.readUnsignedInt();var type=atom.readASCIIText(4);if(size===0){size=atom.blob.size-offset;}
else if(size===1){size=atom.readUnsignedInt()*4294967296+atom.readUnsignedInt();}
if(type==='moov'){atom.getMore(offset,size,function(moov){try{parseMoovAtom(moov,size);handleCoverArt(metadata);return;}
catch(e){errorCallback(e);}});}
else{if(offset+size+16<=atom.blob.size){atom.getMore(offset+size,16,findMoovAtom);}
else{metadataCallback(metadata);}}}
catch(e){errorCallback(e);}}
function parseMoovAtom(data,end){data.advance(8);while(data.index<end){var size=data.readUnsignedInt();var type=data.readASCIIText(4);var nextindex=data.index+size-8;if(type==='udta'){parseUdtaAtom(data,end);data.index=nextindex;}
else if(type==='trak'){data.advance(-8);var mdia=findChildAtom(data,'mdia');if(mdia){var minf=findChildAtom(mdia,'minf');if(minf){var vmhd=searchChildAtom(minf,'vmhd');if(vmhd)
throw'Found video track in MP4 container';var smhd=searchChildAtom(minf,'smhd');if(smhd){var stbl=findChildAtom(minf,'stbl');if(stbl){var stsd=findChildAtom(stbl,'stsd');if(stsd){stsd.advance(20);var codec=stsd.readASCIIText(4);if(!(codec in MP4Codecs)){throw'Unsupported format in MP4 container: '+codec;}}}}}}
else{throw'Not enough metadata in MP4 container!';}
data.index=nextindex;}
else{data.advance(size-8);}}}
function findChildAtom(data,atom){var start=data.index;var length=data.readUnsignedInt();data.advance(4);while(data.index<start+length){var size=data.readUnsignedInt();var type=data.readASCIIText(4);if(type===atom){data.advance(-8);return data;}
else{data.advance(size-8);}}
return null;}
function searchChildAtom(data,atom){var start=data.index;var target=findChildAtom(data,atom);data.index=start;return target;}
function parseUdtaAtom(data,end){while(data.index<end){var size=data.readUnsignedInt();var type=data.readASCIIText(4);if(type==='meta'){parseMetaAtom(data,data.index+size-8);data.index=end;return;}
else{data.advance(size-8);}}}
function parseMetaAtom(data,end){data.advance(4);while(data.index<end){var size=data.readUnsignedInt();var type=data.readASCIIText(4);if(type==='ilst'){parseIlstAtom(data,data.index+size-8);data.index=end;return;}
else{data.advance(size-8);}}}
function parseIlstAtom(data,end){while(data.index<end){var size=data.readUnsignedInt();var type=data.readASCIIText(4);var next=data.index+size-8;var tagname=MP4TAGS[type];if(tagname){try{var value=getMetadataValue(data,next,type);metadata[tagname]=value;}
catch(e){console.warn('skipping',type,':',e);}}
data.index=next;}}
function getMetadataValue(data,end,tagtype){while(data.index<end){var size=data.readUnsignedInt();var type=data.readASCIIText(4);if(type!=='data'){data.advance(size-8);continue;}
var datatype=data.readUnsignedInt()&0xFFFFFF;data.advance(4);var datasize=size-16;if(tagtype==='trkn'){data.advance(2);return data.readUnsignedShort();}
switch(datatype){case 1:return data.readUTF8Text(datasize);case 13:return{start:data.sliceOffset+data.viewOffset+data.index,end:data.sliceOffset+data.viewOffset+data.index+datasize,type:'image/jpeg'};case 14:return{start:data.sliceOffset+data.viewOffset+data.index,end:data.sliceOffset+data.viewOffset+data.index+datasize,type:'image/png'};default:throw Error('unexpected type in data atom');}}
throw Error('no data atom found');}}
function handleCoverArt(metadata){var fileinfo={name:blob.name,blob:blob,metadata:metadata};getThumbnailURL(fileinfo,function(url){metadataCallback(metadata);});}
function handleLockedFile(locked){ForwardLock.getKey(function(secret){ForwardLock.unlockBlob(secret,locked,callback,errorCallback);function callback(unlocked,unlockedMetadata){parseAudioMetadata(unlocked,function(metadata){metadata.locked=true;if(unlockedMetadata.vendor)
metadata.vendor=unlockedMetadata.vendor;if(!metadata[TITLE])
metadata[TITLE]=unlockedMetadata.name;metadataCallback(metadata);},errorCallback);}});}}
var THUMBNAIL_WIDTH=300;var THUMBNAIL_HEIGHT=300;var offscreenImage=new Image();var thumbnailCache={};function getThumbnailURL(fileinfo,callback){function cacheThumbnail(key,blob,url){asyncStorage.setItem(key,blob);thumbnailCache[key]=url;}
var metadata=fileinfo.metadata;if(!metadata.picture){callback(null);return;}
var key='thumbnail';var album=metadata.album;var artist=metadata.artist;var size=metadata.picture.end-metadata.picture.start;if(album||artist){key='thumbnail.'+album+'.'+artist+'.'+size;}
else{key='thumbnail.'+(fileinfo.name||fileinfo.blob.name);}
var url=thumbnailCache[key];if(url){callback(url);return;}
asyncStorage.getItem(key,function(blob){if(blob){var url=URL.createObjectURL(blob);thumbnailCache[key]=url;callback(url);return;}
else{createAndCacheThumbnail();}});function createAndCacheThumbnail(){if(fileinfo.blob){getImage(fileinfo.blob);}
else{musicdb.getFile(fileinfo.name,function(file){getImage(file);});}
function getImage(file){var embedded=file.slice(metadata.picture.start,metadata.picture.end,metadata.picture.type);var embeddedURL=URL.createObjectURL(embedded);offscreenImage.src=embeddedURL;offscreenImage.onerror=function(){URL.revokeObjectURL(embeddedURL);offscreenImage.removeAttribute('src');console.warn('Album cover art failed to load',file.name);callback(null);};offscreenImage.onload=function(){var canvas=document.createElement('canvas');canvas.width=THUMBNAIL_WIDTH;canvas.height=THUMBNAIL_HEIGHT;var context=canvas.getContext('2d');var scalex=canvas.width/offscreenImage.width;var scaley=canvas.height/offscreenImage.height;var scale=Math.max(scalex,scaley);if(scale>=1){offscreenImage.removeAttribute('src');cacheThumbnail(key,embedded,embeddedURL);callback(embeddedURL);return;}
var w=Math.round(THUMBNAIL_WIDTH/scale);var h=Math.round(THUMBNAIL_HEIGHT/scale);var x=Math.round((offscreenImage.width-w)/2);var y=Math.round((offscreenImage.height-h)/2);context.drawImage(offscreenImage,x,y,w,h,0,0,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT);offscreenImage.removeAttribute('src');URL.revokeObjectURL(embeddedURL);canvas.toBlob(function(blob){var url=URL.createObjectURL(blob);cacheThumbnail(key,blob,url);callback(url);},'image/jpeg');};}}};'use strict';function formatTime(secs){if(isNaN(secs))
return;secs=Math.floor(secs);var formatedTime;var seconds=secs%60;var minutes=Math.floor(secs/60)%60;var hours=Math.floor(secs/3600);if(hours===0){formatedTime=(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}else{formatedTime=(hours<10?'0'+hours:hours)+':'+
(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}
return formatedTime;}
function hash(str){var hash=0;if(str.length===0)return hash;for(var i=0;i<str.length;i++){var c=str.charCodeAt(i);hash=((hash<<5)-hash)+c;hash=hash&hash;}
return hash;}
function generateDefaultThumbnailURL(metadata){var infoForHash=(!metadata.album&&!metadata.artist)?metadata.title:metadata.album+metadata.artist;var hashedNumber=(Math.abs(hash(infoForHash))%10)+1;return'/style/images/AlbumArt'+hashedNumber+'_small.png';}
function getAlbumArtBlob(fileinfo,callback){var getBlob=function(url,callback){var xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.responseType='blob';xhr.onload=function(){callback(null,xhr.response);};xhr.onerror=function(){callback('error');};try{xhr.send();}catch(e){callback(e);}};if('picture'in fileinfo.metadata){getThumbnailURL(fileinfo,function(url){if(!url)
return callback(null);getBlob(url,callback);});}
else{var url=generateDefaultThumbnailURL(fileinfo.metadata);getBlob(url,callback);}};'use strict';var TYPE_MIX='mix';var TYPE_LIST='list';var TYPE_SINGLE='single';var TYPE_BLOB='blob';var REPEAT_OFF=0;var REPEAT_LIST=1;var REPEAT_SONG=2;var PLAYSTATUS_STOPPED='STOPPED';var PLAYSTATUS_PLAYING='PLAYING';var PLAYSTATUS_PAUSED='PAUSED';var PLAYSTATUS_FWD_SEEK='FWD_SEEK';var PLAYSTATUS_REV_SEEK='REV_SEEK';var PLAYSTATUS_ERROR='ERROR';var INTERRUPT_BEGIN='mozinterruptbegin';var INTERRUPT_END='mozinterruptend';var acm=navigator.mozAudioChannelManager;if(acm){acm.addEventListener('headphoneschange',function onheadphoneschange(){if(!acm.headphones&&PlayerView.playStatus===PLAYSTATUS_PLAYING){PlayerView.pause();}});}
var PlayerView={get view(){delete this._view;return this._view=document.getElementById('views-player');},get audio(){delete this._audio;return this._audio=document.getElementById('player-audio');},get playStatus(){return this._playStatus;},set playStatus(val){this._playStatus=val;},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;if(this.sourceType){if(this.sourceType===TYPE_MIX||this.sourceType===TYPE_LIST){this.shuffleButton.disabled=(this._dataSource.length<2);TitleBar.playerIcon.hidden=(this._dataSource.length<1);}else{this.shuffleButton.disabled=true;this.repeatButton.disabled=true;this.previousControl.disabled=true;this.nextControl.disabled=true;}}},init:function pv_init(){this.artist=document.getElementById('player-cover-artist');this.album=document.getElementById('player-cover-album');this.timeoutID;this.cover=document.getElementById('player-cover');this.coverImage=document.getElementById('player-cover-image');this.offscreenImage=new Image();this.shareButton=document.getElementById('player-cover-share');this.repeatButton=document.getElementById('player-album-repeat');this.shuffleButton=document.getElementById('player-album-shuffle');this.ratings=document.getElementById('player-album-rating').children;this.seekRegion=document.getElementById('player-seek-bar');this.seekBar=document.getElementById('player-seek-bar-progress');this.seekIndicator=document.getElementById('player-seek-bar-indicator');this.seekElapsed=document.getElementById('player-seek-elapsed');this.seekRemaining=document.getElementById('player-seek-remaining');this.playControl=document.getElementById('player-controls-play');this.previousControl=document.getElementById('player-controls-previous');this.nextControl=document.getElementById('player-controls-next');this.banner=document.getElementById('info-banner');this.isTouching=false;this.isFastSeeking=false;this.playStatus=PLAYSTATUS_STOPPED;this.pausedPosition=null;this.dataSource=[];this.playingBlob=null;this.currentIndex=0;this.setSeekBar(0,0,0);this.intervalID=null;this.view.addEventListener('click',this);this.view.addEventListener('contextmenu',this);this.seekRegion.addEventListener('touchstart',this);this.seekRegion.addEventListener('touchmove',this);this.seekRegion.addEventListener('touchend',this);this.previousControl.addEventListener('touchend',this);this.nextControl.addEventListener('touchend',this);this.audio.addEventListener('play',this);this.audio.addEventListener('pause',this);this.audio.addEventListener('playing',this);this.audio.addEventListener('durationchange',this);this.audio.addEventListener('timeupdate',this);this.audio.addEventListener('ended',this);this.audio.addEventListener('mozinterruptbegin',this);this.audio.addEventListener('mozinterruptend',this);window.addEventListener('visibilitychange',this);window.addEventListener('storage',this._handleInterpageMessage.bind(this));this.endedTimer=null;},checkSCOStatus:function pv_checkSCOStatus(){if(typeof MusicComms!=='undefined'){var SCOStatus=MusicComms.isSCOEnabled;this.playControl.disabled=this.previousControl.disabled=this.nextControl.disabled=SCOStatus;this.seekRegion.parentNode.classList.toggle('disabled',SCOStatus);this.banner.classList.toggle('visible',SCOStatus);}},clean:function pv_clean(){if(typeof playerHandle!=='undefined'&&playerHandle)
musicdb.cancelEnumeration(playerHandle);this.dataSource=[];this.playingBlob=null;},setSourceType:function pv_setSourceType(type){this.sourceType=type;},setDBInfo:function pv_setDBInfo(info){this.DBInfo=info;this.dataSource.length=info.count;},showInfo:function pv_showInfo(){this.cover.classList.add('slideOut');if(this.timeoutID)
window.clearTimeout(this.timeoutID);this.timeoutID=window.setTimeout(function pv_hideInfo(){this.cover.classList.remove('slideOut');}.bind(this),5000);},setInfo:function pv_setInfo(fileinfo){var metadata=fileinfo.metadata;if(typeof ModeManager!=='undefined'){ModeManager.playerTitle=metadata.title;ModeManager.updateTitle();if(metadata.locked||pendingPick){this.shareButton.classList.add('hidden');this.artist.classList.add('hidden-cover-share');this.album.classList.add('hidden-cover-share');}else{this.shareButton.classList.remove('hidden');this.artist.classList.remove('hidden-cover-share');this.album.classList.remove('hidden-cover-share');}}else{var titleBar=document.getElementById('title-text');titleBar.textContent=metadata.title||unknownTitle;titleBar.dataset.l10nId=metadata.title?'':unknownTitleL10nId;}
this.artist.textContent=metadata.artist||unknownArtist;this.artist.dataset.l10nId=metadata.artist?'':unknownArtistL10nId;this.album.textContent=metadata.album||unknownAlbum;this.album.dataset.l10nId=metadata.album?'':unknownAlbumL10nId;this.setCoverImage(fileinfo);},setCoverImage:function pv_setCoverImage(fileinfo){this.offscreenImage.src='';this.coverImage.classList.remove('fadeIn');getThumbnailURL(fileinfo,function(url){url=url||generateDefaultThumbnailURL(fileinfo.metadata);this.offscreenImage.addEventListener('load',pv_showImage.bind(this));this.offscreenImage.src=url;}.bind(this));function pv_showImage(evt){evt.target.removeEventListener('load',pv_showImage);var url='url('+this.offscreenImage.src+')';this.coverImage.style.backgroundImage=url;this.coverImage.classList.add('fadeIn');};},setOptions:function pv_setOptions(settings){var repeatOption=(settings&&settings.repeat)?settings.repeat:REPEAT_OFF;var shuffleOption=(settings&&settings.shuffle)?settings.shuffle:false;this.setRepeat(repeatOption);this.setShuffle(shuffleOption);},setRepeat:function pv_setRepeat(value){var repeatClasses=['repeat-off','repeat-list','repeat-song'];repeatClasses.forEach(function pv_resetRepeat(targetClass){this.repeatButton.classList.remove(targetClass);}.bind(this));this.repeatOption=value;this.repeatButton.classList.add(repeatClasses[this.repeatOption]);},setShuffle:function pv_setShuffle(value,index){this.shuffleOption=value;if(this.shuffleOption){this.shuffleButton.classList.add('shuffle-on');if(arguments.length>1){this.shuffleList(this.currentIndex);}else{this.shuffleList();}}else{this.shuffleButton.classList.remove('shuffle-on');}},setRatings:function pv_setRatings(rated){for(var i=0;i<5;i++){var rating=this.ratings[i];if(i<rated){rating.classList.add('star-on');}else{rating.classList.remove('star-on');}}},shuffleList:function slv_shuffleList(index){if(this.dataSource.length===0)
return;this.shuffleIndex=0;this.shuffledList=[];for(var i=0;i<this.dataSource.length;i++)
this.shuffledList.push(i);if(arguments.length>0){var currentItem=this.shuffledList.splice(index,1);slv_shuffle(this.shuffledList);this.shuffledList=currentItem.concat(this.shuffledList);}else{slv_shuffle(this.shuffledList);}
function slv_shuffle(a){for(var i=a.length-1;i>=1;i--){var j=Math.floor(Math.random()*(i+1));if(j<i){var tmp=a[j];a[j]=a[i];a[i]=tmp;}}}},getMetadata:function pv_getMetadata(blob,callback){parseAudioMetadata(blob,pv_gotMetadata,pv_metadataError.bind(this));function pv_gotMetadata(metadata){callback(metadata);}
function pv_metadataError(e){if(this.onerror)
this.onerror(e);console.warn('parseAudioMetadata: error parsing metadata - ',e);}},setAudioSrc:function pv_setAudioSrc(file){var url=URL.createObjectURL(file);this.playingBlob=file;this.audio.removeAttribute('src');this.audio.load();this.audio.mozAudioChannelType='content';this.audio.src=url;this.audio.load();this.audio.play();this.audio.onloadeddata=function(evt){URL.revokeObjectURL(url);};this.audio.onerror=(function(evt){if(this.onerror)
this.onerror(evt);}).bind(this);this.setSeekBar(0,0,0);if(this.endedTimer){clearTimeout(this.endedTimer);this.endedTimer=null;}},updateRemoteMetadata:function pv_updateRemoteMetadata(){if(typeof MusicComms==='undefined'||this.dataSource.length===0)
return;var fileinfo=this.dataSource[this.currentIndex];var metadata=fileinfo.metadata;var notifyMetadata={title:metadata.title||unknownTitle,artist:metadata.artist||unknownArtist,album:metadata.album||unknownAlbum,duration:this.audio.duration*1000,mediaNumber:this.currentIndex+1,totalMediaCount:this.dataSource.length};if(this.audio.currentTime===0){getAlbumArtBlob(fileinfo,function(err,blob){if(!err){if(blob)
notifyMetadata.picture=blob;}else{notifyMetadata.picture=null;}
MusicComms.notifyMetadataChanged(notifyMetadata);});}
else{MusicComms.notifyMetadataChanged(notifyMetadata);}},updateRemotePlayStatus:function pv_updateRemotePlayStatus(){if(typeof MusicComms==='undefined')
return;var position=this.pausedPosition?this.pausedPosition:this.audio.currentTime;var info={playStatus:this.playStatus,duration:this.audio.duration*1000,position:position*1000};this.pausedPosition=(this.playStatus===PLAYSTATUS_PLAYING)?null:this.audio.currentTime;MusicComms.notifyStatusChanged(info);},getSongData:function pv_getSongData(index,callback){var info=this.DBInfo;var songData=this.dataSource[index];if(songData){callback(songData);}else{ListView.cancelEnumeration();var handle=musicdb.advancedEnumerate(info.key,info.range,info.direction,index,function(record){musicdb.cancelEnumeration(handle);this.dataSource[index]=record;callback(record);}.bind(this));}},getFile:function pv_getFile(songData,callback){if(!songData.metadata.locked){musicdb.getFile(songData.name,callback);return;}
musicdb.getFile(songData.name,function(locked){ForwardLock.getKey(function(secret){ForwardLock.unlockBlob(secret,locked,function(unlocked){callback(unlocked);},null,function(msg){console.error(msg);callback(null);});});});},PLAYER_IS_OCCUPIED_BY:'music-player-is-occupied-by',_handleInterpageMessage:function(evt){if(evt.key===this.PLAYER_IS_OCCUPIED_BY){if(evt.newValue&&evt.newValue!==location.href){this.pause();}}},_sendInterpageMessage:function(){window.localStorage.setItem(this.PLAYER_IS_OCCUPIED_BY,location.href);},_clearInterpageMessage:function(){var whoIsPlaying=window.localStorage.getItem(this.PLAYER_IS_OCCUPIED_BY);if(whoIsPlaying&&whoIsPlaying===window.location.href){window.localStorage.removeItem(this.PLAYER_IS_OCCUPIED_BY);}},play:function pv_play(targetIndex){this.checkSCOStatus();this._sendInterpageMessage();this.showInfo();if(arguments.length>0){this.getSongData(targetIndex,function(songData){this.currentIndex=targetIndex;this.setInfo(songData);this.setRatings(songData.metadata.rated);songData.metadata.played++;musicdb.updateMetadata(songData.name,songData.metadata);this.getFile(songData,function(file){this.setAudioSrc(file);if(this.sourceType===TYPE_SINGLE||MusicComms.isSCOEnabled)
this.pause();}.bind(this));}.bind(this));}else if(this.sourceType===TYPE_BLOB&&!this.audio.src){this.getMetadata(this.dataSource,function(metadata){this.setInfo({metadata:metadata,name:this.dataSource.name,blob:this.dataSource});this.setAudioSrc(this.dataSource);}.bind(this));}else{this.audio.play();}},pause:function pv_pause(){this.checkSCOStatus();this._clearInterpageMessage();this.audio.pause();},stop:function pv_stop(){this.pause();this.audio.removeAttribute('src');this.audio.load();this.clean();if(typeof ModeManager!=='undefined'){ModeManager.playerTitle=null;if(ModeManager.currentMode===MODE_PLAYER){ModeManager.pop();}else{ModeManager.updateTitle();}}
this.playStatus=PLAYSTATUS_STOPPED;this.updateRemotePlayStatus();},next:function pv_next(isAutomatic){if(this.sourceType===TYPE_BLOB||this.sourceType===TYPE_SINGLE){this.setAudioSrc(this.playingBlob);this.pause();return;}
if(this.repeatOption===REPEAT_SONG&&isAutomatic){this.play(this.currentIndex);return;}
var playingIndex=(this.shuffleOption)?this.shuffleIndex:this.currentIndex;if(playingIndex>=this.dataSource.length-1){if(this.repeatOption===REPEAT_LIST){if(this.shuffleOption){this.shuffleList(this.shuffledList[0]);}else{this.currentIndex=0;}}else{this.stop();return;}}else{if(this.shuffleOption){this.shuffleIndex++;}else{this.currentIndex++;}}
var realIndex=(this.shuffleOption)?this.shuffledList[this.shuffleIndex]:this.currentIndex;this.play(realIndex);},previous:function pv_previous(){if(this.audio.currentTime>3){this.play(this.currentIndex);return;}
var playingIndex=(this.shuffleOption)?this.shuffleIndex:this.currentIndex;if(playingIndex<=0){var newIndex=(this.repeatOption===REPEAT_LIST)?this.dataSource.length-1:0;if(this.shuffleOption){this.shuffleIndex=newIndex;}else{this.currentIndex=newIndex;}}else{if(this.shuffleOption){this.shuffleIndex--;}else{this.currentIndex--;}}
var realIndex=(this.shuffleOption)?this.shuffledList[this.shuffleIndex]:this.currentIndex;this.play(realIndex);},startFastSeeking:function pv_startFastSeeking(direction){this.isTouching=this.isFastSeeking=true;var offset=direction*2;this.playStatus=direction?PLAYSTATUS_FWD_SEEK:PLAYSTATUS_REV_SEEK;this.updateRemotePlayStatus();this.intervalID=window.setInterval(function(){this.seekAudio(this.audio.currentTime+offset);}.bind(this),15);},stopFastSeeking:function pv_stopFastSeeking(){this.isTouching=this.isFastSeeking=false;if(this.intervalID)
window.clearInterval(this.intervalID);},updateSeekBar:function pv_updateSeekBar(){if(this.isTouching)
return;if(typeof ModeManager==='undefined'||ModeManager.currentMode===MODE_PLAYER){this.seekAudio();}},seekAudio:function pv_seekAudio(seekTime){if(seekTime!==undefined)
this.audio.currentTime=seekTime;var startTime=this.audio.startTime;var endTime=(this.audio.duration&&this.audio.duration!='Infinity')?this.audio.duration:this.audio.buffered.end(this.audio.buffered.length-1);var currentTime=this.audio.currentTime;this.setSeekBar(startTime,endTime,currentTime);},setSeekBar:function pv_setSeekBar(startTime,endTime,currentTime){this.seekBar.min=startTime;this.seekBar.max=endTime;this.seekBar.value=currentTime;var ratio=(endTime!=0)?(currentTime/endTime):0;var x=(ratio*this.seekBar.offsetWidth-
this.seekIndicator.offsetWidth/2)+'px';this.seekIndicator.style.transform='translateX('+x+')';this.seekElapsed.textContent=formatTime(currentTime);var remainingTime=endTime-currentTime;this.seekRemaining.textContent=(remainingTime>0)?'-'+formatTime(remainingTime):'---:--';},share:function pv_shareFile(){var songData=this.dataSource[this.currentIndex];if(songData.metadata.locked)
return;musicdb.getFile(songData.name,function(file){var filename=songData.name,name=filename.substring(filename.lastIndexOf('/')+1),type=file.type;type=type.substring(0,type.indexOf('/'))+'/*';var activityData={type:type,number:1,blobs:[file],filenames:[name],filepaths:[filename],metadata:[{title:songData.metadata.title,artist:songData.metadata.artist,album:songData.metadata.album}]};if(PlayerView.playStatus!==PLAYSTATUS_PLAYING){var a=new MozActivity({name:'share',data:activityData});a.onerror=function(e){console.warn('share activity error:',a.error.name);};}
else{(function(){var hack_activity_property='_hack_hack_shut_up';var hack_setting_property='music._hack.pause_please';navigator.mozSettings.addObserver(hack_setting_property,observer);activityData[hack_activity_property]=hack_setting_property;var a=new MozActivity({name:'share',data:activityData});a.onerror=a.onsuccess=cleanup;function observer(e){PlayerView.pause();}
function cleanup(){navigator.mozSettings.removeObserver(hack_setting_property,observer);if(PlayerView.playStatus===PLAYSTATUS_PAUSED)
PlayerView.audio.play();}}());}});},handlePeerConnectivity:function nfc_handlePeerConnectivity(event){if(typeof ModeManager!=='undefined'&&navigator.mozNfc){if(ModeManager.currentMode==MODE_PLAYER){navigator.mozNfc.onpeerready=(function(event){var peer=navigator.mozNfc.getNFCPeer(event.detail);if(peer&&this.playingBlob){peer.sendFile(this.playingBlob);}}.bind(this));}else{navigator.mozNfc.onpeerready=null;}}},handleEvent:function pv_handleEvent(evt){var target=evt.target;if(!target)
return;this.handlePeerConnectivity(evt);switch(evt.type){case'click':switch(target.id){case'player-cover':case'player-cover-image':this.showInfo();break;case'player-controls-play':if(this.playStatus===PLAYSTATUS_PLAYING)
this.pause();else
this.play();break;case'player-album-repeat':this.showInfo();var newValue=++this.repeatOption%3;asyncStorage.setItem(SETTINGS_OPTION_KEY,{repeat:newValue,shuffle:this.shuffleOption});this.setRepeat(newValue);break;case'player-album-shuffle':this.showInfo();var newValue=!this.shuffleOption;asyncStorage.setItem(SETTINGS_OPTION_KEY,{repeat:this.repeatOption,shuffle:newValue});this.setShuffle(newValue,this.currentIndex);break;case'player-cover-share':this.share();break;}
if(target.dataset.rating){this.showInfo();var songData=this.dataSource[this.currentIndex];var targetRating=parseInt(target.dataset.rating);var newRating=(targetRating===songData.metadata.rated)?targetRating-1:targetRating;songData.metadata.rated=newRating;musicdb.updateMetadata(songData.name,songData.metadata);this.setRatings(newRating);}
break;case'play':this.playControl.classList.remove('is-pause');break;case'pause':this.playControl.classList.add('is-pause');this.playStatus=PLAYSTATUS_PAUSED;this.updateRemotePlayStatus();break;case'playing':this.playStatus=PLAYSTATUS_PLAYING;this.updateRemotePlayStatus();break;case'touchstart':case'touchmove':if(evt.type==='touchstart'){this.isTouching=true;this.seekIndicator.classList.add('highlight');}
if(this.isTouching&&this.audio.duration>0){var touch=evt.touches[0];var x=(touch.clientX-target.offsetLeft)/target.offsetWidth;if(x<0)
x=0;if(x>1)
x=1;this.seekTime=x*this.seekBar.max;this.setSeekBar(this.audio.startTime,this.audio.duration,this.seekTime);}
break;case'touchend':if(this.isFastSeeking){this.stopFastSeeking();}else if(target.id==='player-seek-bar'){this.seekIndicator.classList.remove('highlight');if(this.audio.duration>0&&this.isTouching){this.seekAudio(this.seekTime);this.seekTime=0;}
this.isTouching=false;}else if(target.id==='player-controls-previous'){this.previous();}else if(target.id==='player-controls-next'){this.next();}
break;case'contextmenu':if(target.id==='player-controls-next')
this.startFastSeeking(1);else if(target.id==='player-controls-previous')
this.startFastSeeking(-1);break;case'durationchange':case'timeupdate':this.updateSeekBar();if(evt.type==='durationchange'||this.audio.currentTime===0)
this.updateRemoteMetadata();if(this.audio.currentTime>=this.audio.duration-1&&this.endedTimer==null){var timeToNext=(this.audio.duration-this.audio.currentTime+1);this.endedTimer=setTimeout(function(){this.next(true);}.bind(this),timeToNext*1000);}
break;case'ended':if(!this.endedTimer)
this.next(true);break;case'visibilitychange':if(document.hidden){this.audio.removeEventListener('timeupdate',this);}else{this.audio.addEventListener('timeupdate',this);this.updateSeekBar();}
break;case'mozinterruptbegin':this.playStatus=INTERRUPT_BEGIN;this.updateRemotePlayStatus();break;case'mozinterruptend':this.playStatus=PLAYSTATUS_PLAYING;this.updateRemotePlayStatus();break;default:return;}}};;'use strict';var unknownAlbum;var unknownArtist;var unknownTitle;var unknownAlbumL10nId='unknownAlbum';var unknownArtistL10nId='unknownArtist';var unknownTitleL10nId='unknownTitle';window.addEventListener('localized',function onlocalized(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;unknownAlbum=navigator.mozL10n.get('unknownAlbum');unknownArtist=navigator.mozL10n.get('unknownArtist');unknownTitle=navigator.mozL10n.get('unknownTitle');navigator.mozSetMessageHandler('activity',handleOpenActivity);});function handleOpenActivity(request){var data=request.source.data;var blob=request.source.data.blob;var backButton=document.getElementById('title-back');var saveButton=document.getElementById('title-save');var banner=document.getElementById('banner');var message=document.getElementById('message');var storage;var saved=false;if(data.allowSave&&data.filename&&checkFilename()){getStorageIfAvailable('music',blob.size,function(ds){storage=ds;saveButton.hidden=false;});}
playBlob(blob);function playBlob(blob){PlayerView.init();PlayerView.setSourceType(TYPE_BLOB);PlayerView.dataSource=blob;PlayerView.play();PlayerView.onerror=function invalid(){alert(navigator.mozL10n.get('audioinvalid'));done();};}
backButton.addEventListener('click',done);saveButton.addEventListener('click',save);function done(){PlayerView.stop();request.postResult({saved:saved});}
function save(){saveButton.hidden=true;document.getElementById('title-text').textContent=document.getElementById('title-text').textContent;getUnusedFilename(storage,data.filename,function(filename){var savereq=storage.addNamed(blob,filename);savereq.onsuccess=function(){saved=filename;showBanner(navigator.mozL10n.get('saved',{title:document.getElementById('title-text').textContent}));};savereq.onerror=function(e){console.error('Error saving',filename,e);};});}
function checkFilename(){var dotIdx=data.filename.lastIndexOf('.'),ext,type;if(dotIdx>-1){ext=data.filename.substr(dotIdx+1);if(ext==='ogg'){return true;}else{return MimeMapper.guessTypeFromExtension(ext)===blob.type;}}else{return false;}}
function showBanner(msg){message.textContent=msg;banner.hidden=false;setTimeout(function(){banner.hidden=true;},3000);}
function baseName(filename){if(!filename)
return'';return filename.substring(filename.lastIndexOf('/')+1);}}