;'use strict';(function(window){var gL10nData={};var gLanguage='';var gMacros={};var gReadyState='loading';var gNestedProps=['style','dataset'];var gDefaultLocale='en-US';var gAsyncResourceLoading=true;var gDEBUG=1;function consoleLog(){if(gDEBUG>=2){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.log(args.join(''));}};function consoleWarn(){if(gDEBUG){var args=[].slice.apply(arguments);args.unshift('[l10n] ');console.warn(args.join(''));}};function consoleWarn_missingKeys(untranslatedElements,lang){var len=untranslatedElements.length;if(!len||!gDEBUG){return;}
var missingIDs=[];for(var i=0;i<len;i++){var l10nId=untranslatedElements[i].getAttribute('data-l10n-id');if(missingIDs.indexOf(l10nId)<0){missingIDs.push(l10nId);}}
console.warn('[l10n] '+
missingIDs.length+' missing key(s) for ['+lang+']: '+
missingIDs.join(', '));}
function getL10nResourceLinks(){return document.querySelectorAll('link[type="application/l10n"]');}
function getL10nDictionary(lang){var getInlineDict=function(locale){var sel='script[type="application/l10n"][lang="'+locale+'"]';return document.querySelector(sel);};var script=getInlineDict(lang)||getInlineDict(gDefaultLocale);return script?JSON.parse(script.innerHTML):null;}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function getL10nAttributes(element){if(!element){return{};}
var l10nId=element.getAttribute('data-l10n-id');var l10nArgs=element.getAttribute('data-l10n-args');var args={};if(l10nArgs){try{args=JSON.parse(l10nArgs);}catch(e){consoleWarn('could not parse arguments for #',l10nId);}}
return{id:l10nId,args:args};}
function setTextContent(element,text){if(!element.firstElementChild){element.textContent=text;return;}
var found=false;var reNotBlank=/\S/;for(var child=element.firstChild;child;child=child.nextSibling){if(child.nodeType===3&&reNotBlank.test(child.nodeValue)){if(found){child.nodeValue='';}else{child.nodeValue=text;found=true;}}}
if(!found){element.insertBefore(document.createTextNode(text),element.firstChild);}}
function fireL10nReadyEvent(){var evtObject=document.createEvent('Event');evtObject.initEvent('localized',false,false);evtObject.language=gLanguage;window.dispatchEvent(evtObject);}
function parseResource(href,lang,successCallback,failureCallback){var baseURL=href.replace(/\/[^\/]*$/,'/');function evalString(text){if(text.lastIndexOf('\\')<0){return text;}
return text.replace(/\\\\/g,'\\').replace(/\\n/g,'\n').replace(/\\r/g,'\r').replace(/\\t/g,'\t').replace(/\\b/g,'\b').replace(/\\f/g,'\f').replace(/\\{/g,'{').replace(/\\}/g,'}').replace(/\\"/g,'"').replace(/\\'/g,"'");}
function parseProperties(text){var dictionary=[];var reBlank=/^\s*|\s*$/;var reComment=/^\s*#|^\s*$/;var reSection=/^\s*\[(.*)\]\s*$/;var reImport=/^\s*@import\s+url\((.*)\)\s*$/i;var reSplit=/^([^=\s]*)\s*=\s*(.+)$/;var reUnicode=/\\u([0-9a-fA-F]{1,4})/g;var reMultiline=/[^\\]\\$/;function parseRawLines(rawText,extendedSyntax){var entries=rawText.replace(reBlank,'').split(/[\r\n]+/);var currentLang='*';var genericLang=lang.replace(/-[a-z]+$/i,'');var skipLang=false;var match='';for(var i=0;i<entries.length;i++){var line=entries[i];if(reComment.test(line)){continue;}
while(reMultiline.test(line)&&i<entries.length){line=line.slice(0,line.length-1)+
entries[++i].replace(reBlank,'');}
if(extendedSyntax){if(reSection.test(line)){match=reSection.exec(line);currentLang=match[1];skipLang=(currentLang!=='*')&&(currentLang!==lang)&&(currentLang!==genericLang);continue;}else if(skipLang){continue;}
if(reImport.test(line)){match=reImport.exec(line);loadImport(baseURL+match[1]);}}
var tmp=line.match(reSplit);if(tmp&&tmp.length==3){var val=tmp[2].replace(reUnicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});dictionary[tmp[1]]=evalString(val);}}}
function loadImport(url){loadResource(url,function(content){parseRawLines(content,false);},null,false);}
parseRawLines(text,true);return dictionary;}
function loadResource(url,onSuccess,onFailure,asynchronous){onSuccess=onSuccess||function _onSuccess(data){};onFailure=onFailure||function _onFailure(){consoleWarn(url,' not found.');};var xhr=new XMLHttpRequest();xhr.open('GET',url,asynchronous);if(xhr.overrideMimeType){xhr.overrideMimeType('text/plain; charset=utf-8');}
xhr.onreadystatechange=function(){if(xhr.readyState==4){if(xhr.status==200||xhr.status===0){onSuccess(xhr.responseText);}else{onFailure();}}};xhr.onerror=onFailure;xhr.ontimeout=onFailure;try{xhr.send(null);}catch(e){onFailure();}}
loadResource(href,function(response){if(/\.json$/.test(href)){gL10nData=JSON.parse(response);}else{var data=parseProperties(response);for(var key in data){var id,prop,nestedProp,index=key.lastIndexOf('.');if(index>0){id=key.slice(0,index);prop=key.slice(index+1);index=id.lastIndexOf('.');if(index>0){nestedProp=id.substr(index+1);if(gNestedProps.indexOf(nestedProp)>-1){id=id.substr(0,index);prop=nestedProp+'.'+prop;}}}else{index=key.lastIndexOf('[');if(index>0){id=key.slice(0,index);prop='_'+key.slice(index);}else{id=key;prop='_';}}
if(!gL10nData[id]){gL10nData[id]={};}
gL10nData[id][prop]=data[key];}}
if(successCallback){successCallback();}},failureCallback,gAsyncResourceLoading);};function loadLocale(lang,translationRequired){clear();gReadyState='loading';gLanguage=lang;var untranslatedElements=[];var inlineDict=getL10nDictionary(lang);if(inlineDict){gL10nData=inlineDict;if(translationRequired){untranslatedElements=translateFragment();}}
function finish(){if(translationRequired){if(!inlineDict){untranslatedElements=translateFragment();}else if(untranslatedElements.length){untranslatedElements=translateElements(untranslatedElements);}}
gReadyState='complete';fireL10nReadyEvent(lang);consoleWarn_missingKeys(untranslatedElements,lang);}
function l10nResourceLink(link){var re=/\{\{\s*locale\s*\}\}/;var parse=function(locale,onload,onerror){var href=unescape(link.href).replace(re,locale);parseResource(href,locale,onload,function notFound(){consoleWarn(href,' not found.');onerror();});};this.load=function(locale,onload,onerror){onerror=onerror||function(){};parse(locale,onload,function parseFallbackLocale(){if(re.test(unescape(link.href))&&gDefaultLocale!=locale){consoleLog('Trying the fallback locale: ',gDefaultLocale);parse(gDefaultLocale,onload,onerror);}else{onerror();}});};}
var resourceLinks=getL10nResourceLinks();var resourceCount=resourceLinks.length;if(!resourceCount){consoleLog('no resource to load, early way out');translationRequired=false;finish();}else{var onResourceCallback=function(){if(--resourceCount<=0){finish();}};for(var i=0,l=resourceCount;i<l;i++){var resource=new l10nResourceLink(resourceLinks[i]);resource.load(lang,onResourceCallback,onResourceCallback);}}}
function clear(){gL10nData={};gLanguage='';}
var kPluralForms=['zero','one','two','few','many','other'];function getPluralRules(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return start<=n&&n<=end;}
var pluralRules={'0':function(n){return'other';},'1':function(n){if((isBetween((n%100),3,10)))
return'few';if(n===0)
return'zero';if((isBetween((n%100),11,99)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'2':function(n){if(n!==0&&(n%10)===0)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'3':function(n){if(n==1)
return'one';return'other';},'4':function(n){if((isBetween(n,0,1)))
return'one';return'other';},'5':function(n){if((isBetween(n,0,2))&&n!=2)
return'one';return'other';},'6':function(n){if(n===0)
return'zero';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'7':function(n){if(n==2)
return'two';if(n==1)
return'one';return'other';},'8':function(n){if((isBetween(n,3,6)))
return'few';if((isBetween(n,7,10)))
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'9':function(n){if(n===0||n!=1&&(isBetween((n%100),1,19)))
return'few';if(n==1)
return'one';return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19)))
return'few';if((n%10)==1&&!(isBetween((n%100),11,19)))
return'one';return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14)))
return'many';if((n%10)==1&&(n%100)!=11)
return'one';return'other';},'12':function(n){if((isBetween(n,2,4)))
return'few';if(n==1)
return'one';return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14)))
return'few';if(n!=1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14)))
return'many';if(n==1)
return'one';return'other';},'14':function(n){if((isBetween((n%100),3,4)))
return'few';if((n%100)==2)
return'two';if((n%100)==1)
return'one';return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10)))
return'few';if((isBetween((n%100),11,19)))
return'many';if(n==1)
return'one';return'other';},'16':function(n){if((n%10)==1&&n!=11)
return'one';return'other';},'17':function(n){if(n==3)
return'few';if(n===0)
return'zero';if(n==6)
return'many';if(n==2)
return'two';if(n==1)
return'one';return'other';},'18':function(n){if(n===0)
return'zero';if((isBetween(n,0,2))&&n!==0&&n!=2)
return'one';return'other';},'19':function(n){if((isBetween(n,2,10)))
return'few';if((isBetween(n,0,1)))
return'one';return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)==9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99)))
return'few';if((n%1000000)===0&&n!==0)
return'many';if((n%10)==2&&!isIn((n%100),[12,72,92]))
return'two';if((n%10)==1&&!isIn((n%100),[11,71,91]))
return'one';return'other';},'21':function(n){if(n===0)
return'zero';if(n==1)
return'one';return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99)))
return'one';return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0)
return'one';return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19)))
return'few';if(isIn(n,[2,12]))
return'two';if(isIn(n,[1,11]))
return'one';return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){consoleWarn('plural form unknown for [',lang,']');return function(){return'other';};}
return pluralRules[index];}
gMacros.plural=function(str,param,key,prop){var n=parseFloat(param);if(isNaN(n)){return str;}
var data=gL10nData[key];if(!data){return str;}
if(!gMacros._pluralRules){gMacros._pluralRules=getPluralRules(gLanguage);}
var index='['+gMacros._pluralRules(n)+']';if(n===0&&(prop+'[zero]')in data){str=data[prop+'[zero]'];}else if(n==1&&(prop+'[one]')in data){str=data[prop+'[one]'];}else if(n==2&&(prop+'[two]')in data){str=data[prop+'[two]'];}else if((prop+index)in data){str=data[prop+index];}else if((prop+'[other]')in data){str=data[prop+'[other]'];}
return str;};var reArgs=/\{\{\s*(.+?)\s*\}\}/;var reIndex=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/;function getL10nData(key,args){var data=gL10nData[key];if(!data){return null;}
var rv={};for(var prop in data){var str=data[prop];str=substIndexes(str,args,key,prop);str=substArguments(str,args,key);rv[prop]=str;}
return rv;}
function getL10nArgs(str){var args=[];var match=reArgs.exec(str);while(match&&match.length>=2){args.push({name:match[1],subst:match[0]});str=str.substr(match.index+match[0].length);match=reArgs.exec(str);}
return args;}
function getSubDictionary(fragment){if(!fragment){return JSON.parse(JSON.stringify(gL10nData));}
var dict={};var elements=getTranslatableChildren(fragment);function checkGlobalArguments(str){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var arg=match[i].name;if(arg in gL10nData){dict[arg]=gL10nData[arg];}}}
for(var i=0,l=elements.length;i<l;i++){var id=getL10nAttributes(elements[i]).id;var data=gL10nData[id];if(!id||!data){continue;}
dict[id]=data;for(var prop in data){var str=data[prop];checkGlobalArguments(str);if(reIndex.test(str)){for(var j=0;j<kPluralForms.length;j++){var key=id+'['+kPluralForms[j]+']';if(key in gL10nData){dict[key]=gL10nData[key];checkGlobalArguments(gL10nData[key]);}}}}}
return dict;}
function substIndexes(str,args,key,prop){var reMatch=reIndex.exec(str);if(!reMatch||!reMatch.length){return str;}
var macroName=reMatch[1];var paramName=reMatch[2];var param;if(args&&paramName in args){param=args[paramName];}else if(paramName in gL10nData){param=gL10nData[paramName];}
if(macroName in gMacros){var macro=gMacros[macroName];str=macro(str,param,key,prop);}
return str;}
function substArguments(str,args,key){var match=getL10nArgs(str);for(var i=0;i<match.length;i++){var sub,arg=match[i].name;if(args&&arg in args){sub=args[arg];}else if(arg in gL10nData){sub=gL10nData[arg]['_'];}else{consoleLog('argument {{',arg,'}} for #',key,' is undefined.');return str;}
if(typeof sub=='string'){sub=sub.replace(/\$/g,'$$$$');}
str=str.replace(match[i].subst,sub);}
return str;}
function translateElement(element){var l10n=getL10nAttributes(element);if(!l10n.id){return true;}
var data=getL10nData(l10n.id,l10n.args);if(!data){return false;}
for(var k in data){if(k==='_'){setTextContent(element,data._);}else{var idx=k.lastIndexOf('.');var nestedProp=k.substr(0,idx);if(gNestedProps.indexOf(nestedProp)>-1){element[nestedProp][k.substr(idx+1)]=data[k];}else if(k==='ariaLabel'){element.setAttribute('aria-label',data[k]);}else{element[k]=data[k];}}}
return true;}
function translateElements(elements){var untranslated=[];for(var i=0,l=elements.length;i<l;i++){if(!translateElement(elements[i])){untranslated.push(elements[i]);}}
return untranslated;}
function translateFragment(element){element=element||document.documentElement;var untranslated=translateElements(getTranslatableChildren(element));if(!translateElement(element)){untranslated.push(element);}
return untranslated;}
function localizeElement(element,id,args){if(!element){return;}
if(!id){element.removeAttribute('data-l10n-id');element.removeAttribute('data-l10n-args');setTextContent(element,'');return;}
element.setAttribute('data-l10n-id',id);if(args&&typeof args==='object'){element.setAttribute('data-l10n-args',JSON.stringify(args));}else{element.removeAttribute('data-l10n-args');}
if(gReadyState==='complete'){translateElement(element);}}
function l10nStartup(){gDefaultLocale=document.documentElement.lang||gDefaultLocale;gReadyState='interactive';consoleLog('loading [',navigator.language,'] resources, ',(gAsyncResourceLoading?'asynchronously.':'synchronously.'));var translationRequired=(document.documentElement.lang!==navigator.language);loadLocale(navigator.language,translationRequired);}
if(typeof(document)!=='undefined'){if(document.readyState==='complete'||document.readyState==='interactive'){window.setTimeout(l10nStartup);}else{document.addEventListener('DOMContentLoaded',l10nStartup);}}
if('mozSettings'in navigator&&navigator.mozSettings){navigator.mozSettings.addObserver('language.current',function(event){loadLocale(event.settingValue,true);});}
navigator.mozL10n={get:function l10n_get(key,args){var data=getL10nData(key,args);if(!data){consoleWarn('#',key,' is undefined.');return'';}else{return data._;}},get language(){return{get code(){return gLanguage;},set code(lang){loadLocale(lang,true);},get direction(){var rtlList=['ar','he','fa','ps','ur'];return(rtlList.indexOf(gLanguage)>=0)?'rtl':'ltr';}};},translate:translateFragment,localize:localizeElement,getDictionary:getSubDictionary,get readyState(){return gReadyState;},ready:function l10n_ready(callback){if(!callback){return;}
if(gReadyState=='complete'){window.setTimeout(callback);}else{window.addEventListener('localized',callback);}}};consoleLog('library loaded.');})(this);;'use strict';navigator.mozL10n.DateTimeFormat=function(locales,options){var _=navigator.mozL10n.get;function localeFormat(d,format){var tokens=format.match(/(%E.|%O.|%.)/g);for(var i=0;tokens&&i<tokens.length;i++){var value='';switch(tokens[i]){case'%a':value=_('weekday-'+d.getDay()+'-short');break;case'%A':value=_('weekday-'+d.getDay()+'-long');break;case'%b':case'%h':value=_('month-'+d.getMonth()+'-short');break;case'%B':value=_('month-'+d.getMonth()+'-long');break;case'%Eb':value=_('month-'+d.getMonth()+'-genitive');break;case'%I':value=d.getHours()%12||12;break;case'%e':value=d.getDate();break;case'%p':value=d.getHours()<12?_('time_am'):_('time_pm');break;case'%c':case'%x':case'%X':var tmp=_('dateTimeFormat_'+tokens[i]);if(tmp&&!(/(%c|%x|%X)/).test(tmp)){value=localeFormat(d,tmp);}
break;}
format=format.replace(tokens[i],value||d.toLocaleFormat(tokens[i]));}
return format;}
function relativeParts(seconds){seconds=Math.abs(seconds);var descriptors={};var units=['years',86400*365,'months',86400*30,'weeks',86400*7,'days',86400,'hours',3600,'minutes',60];if(seconds<60){return{minutes:Math.round(seconds/60)};}
for(var i=0,uLen=units.length;i<uLen;i+=2){var value=units[i+1];if(seconds>=value){descriptors[units[i]]=Math.floor(seconds/value);seconds-=descriptors[units[i]]*value;}}
return descriptors;}
function prettyDate(time,useCompactFormat,maxDiff){maxDiff=maxDiff||86400*10;switch(time.constructor){case String:time=parseInt(time);break;case Date:time=time.getTime();break;}
var secDiff=(Date.now()-time)/1000;if(isNaN(secDiff)){return _('incorrectDate');}
if(secDiff>maxDiff){return localeFormat(new Date(time),'%x');}
var f=useCompactFormat?'-short':'-long';var parts=relativeParts(secDiff);var affix=secDiff>=0?'-ago':'-until';for(var i in parts){return _(i+affix+f,{value:parts[i]});}}
return{localeDateString:function localeDateString(d){return localeFormat(d,'%x');},localeTimeString:function localeTimeString(d){return localeFormat(d,'%X');},localeString:function localeString(d){return localeFormat(d,'%c');},localeFormat:localeFormat,fromNow:prettyDate,relativeParts:relativeParts};};;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media)
continue;window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;(function(exports){'use strict';var priv=new WeakMap();var rmatcher=/\$\{([^}]+)\}/g;var rentity=/[&<>"']/g;var rentities={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&apos;'};function extract(node){var nodeId;if(typeof node==='string'){nodeId=node;node=document.getElementById(node);}else if(node){nodeId=node.id;}
if(!node){console.error('Can not find the node passed to Template',nodeId);return'';}
if(!node.firstChild){console.error('Node passed to Template should have a comment node',nodeId);return'';}
node=node.firstChild;do{if(node.nodeType===Node.COMMENT_NODE){return(node.nodeValue||'').trim();}}while((node=node.nextSibling));console.error('Nodes passed to Template should have a comment node',nodeId);return'';}
function Template(idOrNode){if(!(this instanceof Template)){return new Template(idOrNode);}
priv.set(this,{tmpl:extract(idOrNode)});};Template.prototype.toString=function(){return priv.get(this).tmpl.slice();};Template.prototype.interpolate=function(data,options){options=options||{};options.safe=options.safe||[];return priv.get(this).tmpl.replace(rmatcher,function(match,property){property=property.trim();return options.safe.indexOf(property)===-1?Template.escape(data[property]):data[property];});};Template.escape=function escape(str){if(typeof str!=='string'){return'';}
return str.replace(rentity,function(s){return rentities[s];});};exports.Template=Template;}(this));;'use strict';function enumerateAll(storages,dir,options){var storageIndex=0;var ds_cursor=null;var cursor={continue:function cursor_continue(){ds_cursor.continue();}};function enumerateNextStorage(){ds_cursor=storages[storageIndex].enumerate(dir,options||{});ds_cursor.onsuccess=onsuccess;ds_cursor.onerror=onerror;};function onsuccess(e){cursor.result=e.target.result;if(!cursor.result){storageIndex++;if(storageIndex<storages.length){enumerateNextStorage();return;}}
if(cursor.onsuccess){try{cursor.onsuccess(e);}catch(err){console.warn('enumerateAll onsuccess threw',err);}}};function onerror(e){cursor.error=e.target.error;if(cursor.onerror){try{cursor.onerror(e);}catch(err){console.warn('enumerateAll onerror threw',err);}}};enumerateNextStorage();return cursor;};'use strict';var MediaDB=(function(){function MediaDB(mediaType,metadataParser,options){this.mediaType=mediaType;this.metadataParser=metadataParser;if(!options)
options={};this.indexes=options.indexes||[];this.version=options.version||1;this.mimeTypes=options.mimeTypes;this.autoscan=(options.autoscan!==undefined)?options.autoscan:true;this.state=MediaDB.OPENING;this.scanning=false;this.parsingBigFiles=false;this.updateRecord=options.updateRecord;if(options.excludeFilter&&(options.excludeFilter instanceof RegExp)){this.clientExcludeFilter=options.excludeFilter;}
this.batchHoldTime=options.batchHoldTime||100;this.batchSize=options.batchSize||0;this.dbname='MediaDB/'+this.mediaType+'/';var media=this;this.details={eventListeners:{},pendingInsertions:[],pendingDeletions:[],whenDoneProcessing:[],pendingCreateNotifications:[],pendingDeleteNotifications:[],pendingNotificationTimer:null,newestFileModTime:0};if(!this.metadataParser){this.metadataParser=function(file,callback){setTimeout(function(){callback({});},0);};}
var dbVersion=(0xFFFF&this.version)<<16|(0xFFFF&MediaDB.VERSION);var openRequest=indexedDB.open(this.dbname,dbVersion);openRequest.onerror=function(e){console.error('MediaDB():',openRequest.error.name);};openRequest.onblocked=function(e){console.error('indexedDB.open() is blocked in MediaDB()');};openRequest.onupgradeneeded=function(e){var db=openRequest.result;var transaction=e.target.transaction;var oldVersion=e.oldVersion;var oldDbVersion=0xFFFF&oldVersion;var oldClientVersion=0xFFFF&(oldVersion>>16);if(oldClientVersion===0){oldDbVersion=2;oldClientVersion=oldVersion/oldDbVersion;}
if(0==db.objectStoreNames.length){createObjectStores(db);}else{handleUpgrade(db,transaction,oldDbVersion,oldClientVersion);}};openRequest.onsuccess=function(e){media.db=openRequest.result;media.db.onerror=function(event){console.error('MediaDB: ',event.target.error&&event.target.error.name);};var cursorRequest=media.db.transaction('files','readonly').objectStore('files').index('date').openCursor(null,'prev');cursorRequest.onerror=function(){console.error('MediaDB initialization error',cursorRequest.error);};cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){media.details.newestFileModTime=cursor.value.date;}
else{media.details.newestFileModTime=0;}
initDeviceStorage();};};function createObjectStores(db){var filestore=db.createObjectStore('files',{keyPath:'name'});filestore.createIndex('date','date');media.indexes.forEach(function(indexName){if(indexName==='name'||indexName==='date')
return;filestore.createIndex(indexName,indexName);});}
function enumerateOldFiles(store,callback){var openCursorReq=store.openCursor();openCursorReq.onsuccess=function(){var cursor=openCursorReq.result;if(cursor){callback(cursor.value);cursor.continue();}};}
function handleUpgrade(db,trans,oldDbVersion,oldClientVersion){media.state=MediaDB.UPGRADING;var evtDetail={'oldMediaDBVersion':oldDbVersion,'oldClientVersion':oldClientVersion,'newMediaDBVersion':MediaDB.VERSION,'newClientVersion':media.version};dispatchEvent(media,'upgrading',evtDetail);var store=trans.objectStore('files');if(media.version!=oldClientVersion){upgradeIndexesChanges(store);}
var clientUpgradeNeeded=(media.version!=oldClientVersion)&&media.updateRecord;if((2!=oldDbVersion||3!=MediaDB.VERSION)&&!clientUpgradeNeeded){return;}
enumerateOldFiles(store,function doUpgrade(dbfile){if(2==oldDbVersion&&3==MediaDB.VERSION){upgradeDBVer2to3(store,dbfile);}
if(clientUpgradeNeeded){handleClientUpgrade(store,dbfile,oldClientVersion);}});}
function upgradeIndexesChanges(store){var dbIndexes=store.indexNames;var clientIndexes=media.indexes;var clientIndex;for(var i=0;i<dbIndexes.length;i++){if('name'===dbIndexes[i]||'date'===dbIndexes[i]){continue;}
if(clientIndexes.indexOf(dbIndexes[i])<0){store.deleteIndex(dbIndexes[i]);}}
for(i=0;i<clientIndexes.length;i++){if(!dbIndexes.contains(clientIndexes[i])){store.createIndex(clientIndexes[i],clientIndexes[i]);}}}
function upgradeDBVer2to3(store,dbfile){if(dbfile.name[0]==='/'){return;}
store.delete(dbfile.name);dbfile.name='/sdcard/'+dbfile.name;store.add(dbfile);}
function handleClientUpgrade(store,dbfile,oldClientVersion){try{dbfile.metadata=media.updateRecord(dbfile,oldClientVersion,media.version);store.put(dbfile);}catch(ex){console.warn('client app updates record, '+dbfile.name+', failed: '+ex.message);}}
function initDeviceStorage(){var details=media.details;details.storages=navigator.getDeviceStorages(mediaType);details.availability={};getStorageAvailability();function getStorageAvailability(){var next=0;getNextAvailability();function getNextAvailability(){if(next>=details.storages.length){setupHandlers();return;}
var s=details.storages[next++];var name=s.storageName;var req=s.available();req.onsuccess=function(e){details.availability[name]=req.result;getNextAvailability();};req.onerror=function(e){details.availability[name]='unavailable';getNextAvailability();};}}
function setupHandlers(){for(var i=0;i<details.storages.length;i++)
details.storages[i].addEventListener('change',changeHandler);details.dsEventListener=changeHandler;sendInitialEvent();}
function sendInitialEvent(){var state=getState(details.availability);changeState(media,state);if(media.autoscan)
scan(media);}
function getState(availability){var n=0;var a=0;var u=0;var s=0;for(var name in availability){n++;switch(availability[name]){case'available':a++;break;case'unavailable':u++;break;case'shared':s++;break;}}
if(s>0)
return MediaDB.UNMOUNTED;if(u===n)
return MediaDB.NOCARD;return MediaDB.READY;}
function changeHandler(e){switch(e.reason){case'modified':case'deleted':fileChangeHandler(e);return;case'available':case'unavailable':case'shared':volumeChangeHandler(e);return;default:return;}}
function volumeChangeHandler(e){var storageName=e.target.storageName;if(details.availability[storageName]===e.reason)
return;var oldState=media.state;details.availability[storageName]=e.reason;var newState=getState(details.availability);if(newState!==oldState){changeState(media,newState);if(newState===MediaDB.READY){if(media.autoscan)
scan(media);}
else{endscan(media);}}
else if(newState===MediaDB.READY){if(e.reason==='available'){dispatchEvent(media,'ready');if(media.autoscan)
scan(media);}
else if(e.reason==='unavailable'){dispatchEvent(media,'cardremoved');deleteAllFiles(storageName);}}}
function fileChangeHandler(e){var filename=e.path;if(ignoreName(media,filename))
return;if(e.reason==='modified')
insertRecord(media,filename);else
deleteRecord(media,filename);}
function deleteAllFiles(storageName){var storagePrefix=storageName?'/'+storageName+'/':'';var store=media.db.transaction('files').objectStore('files');var cursorRequest=store.openCursor();cursorRequest.onsuccess=function(){var cursor=cursorRequest.result;if(cursor){if(cursor.value.name.startsWith(storagePrefix)){deleteRecord(media,cursor.value.name);}
cursor.continue();}};}}}
MediaDB.prototype={close:function close(){this.db.close();for(var i=0;i<this.details.storages.length;i++){var s=this.details.storages[i];s.removeEventListener('change',this.details.dsEventListener);}
changeState(this,MediaDB.CLOSED);},addEventListener:function addEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type))
this.details.eventListeners[type]=[];var listeners=this.details.eventListeners[type];if(listeners.indexOf(listener)!==-1)
return;listeners.push(listener);},removeEventListener:function removeEventListener(type,listener){if(!this.details.eventListeners.hasOwnProperty(type))
return;var listeners=this.details.eventListeners[type];var position=listeners.indexOf(listener);if(position===-1)
return;listeners.splice(position,1);},getFileInfo:function getFile(filename,callback,errback){if(this.state===MediaDB.OPENING)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){var msg='MediaDB.getFileInfo: unknown filename: '+filename;if(errback)
errback(msg);else
console.error(msg);};read.onsuccess=function(){if(callback)
callback(read.result);};},getFile:function getFile(filename,callback,errback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);var getRequest=storage.get(filename);getRequest.onsuccess=function(){callback(getRequest.result);};getRequest.onerror=function(){var errmsg=getRequest.error&&getRequest.error.name;if(errback)
errback(errmsg);else
console.error('MediaDB.getFile:',errmsg);};},deleteFile:function deleteFile(filename){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);storage.delete(filename).onerror=function(e){console.error('MediaDB.deleteFile(): Failed to delete',filename,'from DeviceStorage:',e.target.error);};},addFile:function addFile(filename,file){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var storage=navigator.getDeviceStorage(media.mediaType);var deletereq=storage.delete(filename);deletereq.onsuccess=deletereq.onerror=save;function save(){var request=storage.addNamed(file,filename);request.onerror=function(){console.error('MediaDB: Failed to store',filename,'in DeviceStorage:',request.error);};}},updateMetadata:function(filename,metadata,callback){if(this.state===MediaDB.OPENING)
throw Error('MediaDB is not ready. State: '+this.state);var media=this;var read=media.db.transaction('files','readonly').objectStore('files').get(filename);read.onerror=function(){console.error('MediaDB.updateMetadata called with unknown filename');};read.onsuccess=function(){var fileinfo=read.result;Object.keys(metadata).forEach(function(key){fileinfo.metadata[key]=metadata[key];});var write=media.db.transaction('files','readwrite').objectStore('files').put(fileinfo);write.onerror=function(){console.error('MediaDB.updateMetadata: database write failed',write.error&&write.error.name);};if(callback){write.onsuccess=function(){callback();};}};},count:function(key,range,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);if(arguments.length===1){callback=key;range=undefined;key=undefined;}
else if(arguments.length===2){callback=range;range=key;key=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var countRequest=store.count(range||null);countRequest.onerror=function(){console.error('MediaDB.count() failed with',countRequest.error);};countRequest.onsuccess=function(e){callback(e.target.result);};},enumerate:function enumerate(key,range,direction,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var handle={state:'enumerating'};if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var cursorRequest=store.openCursor(range||null,direction||'next');cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(!cursor.value.fail)
callback(cursor.value);}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}
cursor.continue();}
else{handle.state='complete';callback(null);}};return handle;},advancedEnumerate:function(key,range,direction,index,callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var handle={state:'enumerating'};var store=this.db.transaction('files').objectStore('files');if(key&&key!=='name')
store=store.index(key);var cursorRequest=store.openCursor(range||null,direction||'next');var isTarget=false;cursorRequest.onerror=function(){console.error('MediaDB.enumerate() failed with',cursorRequest.error);handle.state='error';};cursorRequest.onsuccess=function(){if(handle.state==='cancelling'){handle.state='cancelled';return;}
var cursor=cursorRequest.result;if(cursor){try{if(!cursor.value.fail&&isTarget){callback(cursor.value);cursor.continue();}
else{cursor.advance(index-1);isTarget=true;}}
catch(e){console.warn('MediaDB.enumerate(): callback threw',e,e.stack);}}
else{handle.state='complete';callback(null);}};return handle;},enumerateAll:function enumerateAll(key,range,direction,callback){var batch=[];if(arguments.length===1){callback=key;key=undefined;}
else if(arguments.length===2){callback=range;range=undefined;}
else if(arguments.length===3){callback=direction;direction=undefined;}
return this.enumerate(key,range,direction,function(fileinfo){if(fileinfo!==null)
batch.push(fileinfo);else
callback(batch);});},cancelEnumeration:function cancelEnumeration(handle){if(handle.state==='enumerating')
handle.state='cancelling';},getAll:function getAll(callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var store=this.db.transaction('files').objectStore('files');var request=store.mozGetAll();request.onerror=function(){console.error('MediaDB.getAll() failed with',request.error);};request.onsuccess=function(){var all=request.result;var good=all.filter(function(fileinfo){return!fileinfo.fail;});callback(good);};},scan:function(){scan(this);},freeSpace:function freeSpace(callback){if(this.state!==MediaDB.READY)
throw Error('MediaDB is not ready. State: '+this.state);var storage=navigator.getDeviceStorage(this.mediaType);var freereq=storage.freeSpace();freereq.onsuccess=function(){callback(freereq.result);};}};MediaDB.VERSION=3;MediaDB.OPENING='opening';MediaDB.UPGRADING='upgrading';MediaDB.READY='ready';MediaDB.NOCARD='nocard';MediaDB.UNMOUNTED='unmounted';MediaDB.CLOSED='closed';function ignore(media,file){if(ignoreName(media,file.name))
return true;if(media.mimeTypes&&media.mimeTypes.indexOf(file.type)===-1)
return true;return false;}
function ignoreName(media,filename){if(media.clientExcludeFilter&&media.clientExcludeFilter.test(filename)){return true;}else{var path=filename.substring(0,filename.lastIndexOf('/')+1);return(path[0]==='.'||path.indexOf('/.')!==-1);}}
function scan(media){media.scanning=true;dispatchEvent(media,'scanstart');quickScan(media.details.newestFileModTime);function quickScan(timestamp){var cursor;if(timestamp>0){media.details.firstscan=false;cursor=enumerateAll(media.details.storages,'',{since:new Date(timestamp+1)});}
else{media.details.firstscan=true;media.details.records=[];cursor=enumerateAll(media.details.storages,'');}
cursor.onsuccess=function(){if(!media.scanning)
return;var file=cursor.result;if(file){if(!ignore(media,file))
insertRecord(media,file);cursor.continue();}
else{whenDoneProcessing(media,function(){sendNotifications(media);if(media.details.firstscan){endscan(media);}
else{fullScan();}});}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};}
function fullScan(){if(media.state!==MediaDB.READY){endscan(media);return;}
var dsfiles=[];var cursor=enumerateAll(media.details.storages,'');cursor.onsuccess=function(){if(!media.scanning)
return;var file=cursor.result;if(file){if(!ignore(media,file)){dsfiles.push(file);}
cursor.continue();}
else{getDBFiles();}};cursor.onerror=function(){console.warning('Error while scanning',cursor.error);endscan(media);};function getDBFiles(){var store=media.db.transaction('files').objectStore('files');var getAllRequest=store.mozGetAll();getAllRequest.onsuccess=function(){if(!media.scanning)
return;var dbfiles=getAllRequest.result;compareLists(dbfiles,dsfiles);};}
function compareLists(dbfiles,dsfiles){dsfiles.sort(function(a,b){if(a.name<b.name)
return-1;else
return 1;});var dsindex=0,dbindex=0;while(true){var dsfile;if(dsindex<dsfiles.length)
dsfile=dsfiles[dsindex];else
dsfile=null;var dbfile;if(dbindex<dbfiles.length)
dbfile=dbfiles[dbindex];else
dbfile=null;if(dsfile===null&&dbfile===null)
break;if(dbfile===null){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile===null){deleteRecord(media,dbfile.name);dbindex++;continue;}
if(dsfile.name===dbfile.name){var lastModified=dsfile.lastModifiedDate;var timeDifference=lastModified.getTime()-dbfile.date;var sameTime=(timeDifference===0||((Math.abs(timeDifference)<=12*60*60*1000)&&(timeDifference%10*60*1000===0)));var sameSize=dsfile.size===dbfile.size;if(!sameTime||!sameSize){deleteRecord(media,dbfile.name);insertRecord(media,dsfile);}
dsindex++;dbindex++;continue;}
if(dsfile.name<dbfile.name){insertRecord(media,dsfile);dsindex++;continue;}
if(dsfile.name>dbfile.name){deleteRecord(media,dbfile.name);dbindex++;continue;}
console.error('Assertion failed');}
insertRecord(media,null);}}}
function endscan(media){if(media.scanning){media.scanning=false;media.parsingBigFiles=false;dispatchEvent(media,'scanend');}}
function insertRecord(media,fileOrName){var details=media.details;details.pendingInsertions.push(fileOrName);if(details.processingQueue)
return;processQueue(media);}
function deleteRecord(media,filename){var details=media.details;details.pendingDeletions.push(filename);if(details.processingQueue)
return;processQueue(media);}
function whenDoneProcessing(media,f){var details=media.details;if(details.processingQueue)
details.whenDoneProcessing.push(f);else
f();}
function processQueue(media){var details=media.details;details.processingQueue=true;next();function next(){if(details.pendingDeletions.length>0){deleteFiles();}
else if(details.pendingInsertions.length>0){insertFile(details.pendingInsertions.shift());}
else{details.processingQueue=false;if(details.whenDoneProcessing.length>0){var functions=details.whenDoneProcessing;details.whenDoneProcessing=[];functions.forEach(function(f){f();});}}}
function deleteFiles(){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');deleteNextFile();function deleteNextFile(){if(details.pendingDeletions.length===0){next();return;}
var filename=details.pendingDeletions.shift();var request=store.delete(filename);request.onerror=function(){console.warn('MediaDB: Unknown file in deleteRecord:',filename,getreq.error);deleteNextFile();};request.onsuccess=function(){queueDeleteNotification(media,filename);deleteNextFile();};}}
function insertFile(f){if(f===null){sendNotifications(media);endscan(media);next();return;}
if(typeof f==='string'){var storage=navigator.getDeviceStorage(media.mediaType);var getreq=storage.get(f);getreq.onerror=function(){console.warn('MediaDB: Unknown file in insertRecord:',f,getreq.error);next();};getreq.onsuccess=function(){if(media.mimeTypes&&ignore(media,getreq.result))
next();else
parseMetadata(getreq.result,f);};}
else{parseMetadata(f,f.name);}}
function parseMetadata(file,filename){if(!file.lastModifiedDate){console.warn('MediaDB: parseMetadata: no lastModifiedDate for',filename,'using Date.now() until #793955 is fixed');}
var fileinfo={name:filename,type:file.type,size:file.size,date:file.lastModifiedDate?file.lastModifiedDate.getTime():Date.now()};if(fileinfo.date>details.newestFileModTime)
details.newestFileModTime=fileinfo.date;media.metadataParser(file,gotMetadata,metadataError,parsingBigFile);function parsingBigFile(){media.parsingBigFiles=true;}
function metadataError(e){console.warn('MediaDB: error parsing metadata for',filename,':',e);fileinfo.fail=true;storeRecord(fileinfo);}
function gotMetadata(metadata){fileinfo.metadata=metadata;storeRecord(fileinfo);if(!media.scanning){media.parsingBigFiles=false;}}}
function storeRecord(fileinfo){if(media.details.firstscan){media.details.records.push(fileinfo);if(!fileinfo.fail){queueCreateNotification(media,fileinfo);}
next();}
else{var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');var request=store.add(fileinfo);request.onsuccess=function(){if(!fileinfo.fail)
queueCreateNotification(media,fileinfo);next();};request.onerror=function(event){if(request.error.name==='ConstraintError'){event.stopPropagation();event.preventDefault();var putrequest=store.put(fileinfo);putrequest.onsuccess=function(){queueDeleteNotification(media,fileinfo.name);if(!fileinfo.fail)
queueCreateNotification(media,fileinfo);next();};putrequest.onerror=function(){console.error('MediaDB: unexpected ConstraintError','in insertRecord for file:',fileinfo.name);next();};}
else{console.error('MediaDB: unexpected error in insertRecord:',request.error,'for file:',fileinfo.name);next();}};}}}
function queueCreateNotification(media,fileinfo){var creates=media.details.pendingCreateNotifications;creates.push(fileinfo);if(media.batchSize&&creates.length>=media.batchSize)
sendNotifications(media);else
resetNotificationTimer(media);}
function queueDeleteNotification(media,filename){var deletes=media.details.pendingDeleteNotifications;deletes.push(filename);if(media.batchSize&&deletes.length>=media.batchSize)
sendNotifications(media);else
resetNotificationTimer(media);}
function resetNotificationTimer(media){var details=media.details;if(details.pendingNotificationTimer)
clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=setTimeout(function(){sendNotifications(media);},media.batchHoldTime);}
function sendNotifications(media){var details=media.details;if(details.pendingNotificationTimer){clearTimeout(details.pendingNotificationTimer);details.pendingNotificationTimer=null;}
if(details.pendingDeleteNotifications.length>0){var deletions=details.pendingDeleteNotifications;details.pendingDeleteNotifications=[];dispatchEvent(media,'deleted',deletions);}
if(details.pendingCreateNotifications.length>0){var creations=details.pendingCreateNotifications;details.pendingCreateNotifications=[];if(details.firstscan&&details.records.length>0){var transaction=media.db.transaction('files','readwrite');var store=transaction.objectStore('files');for(var i=0;i<details.records.length;i++)
store.add(details.records[i]);details.records.length=0;transaction.oncomplete=function(){dispatchEvent(media,'created',creations);};}
else{dispatchEvent(media,'created',creations);}}}
function dispatchEvent(media,type,detail){var handler=media['on'+type];var listeners=media.details.eventListeners[type];if(!handler&&(!listeners||listeners.length==0))
return;var event={type:type,target:media,currentTarget:media,timestamp:Date.now(),detail:detail};if(typeof handler==='function'){try{handler.call(media,event);}
catch(e){console.warn('MediaDB: ','on'+type,'event handler threw',e,e.stack);}}
if(!listeners)
return;for(var i=0;i<listeners.length;i++){try{var listener=listeners[i];if(typeof listener==='function'){listener.call(media,event);}
else{listener.handleEvent(event);}}
catch(e){console.warn('MediaDB: ',type,'event listener threw',e,e.stack);}}}
function changeState(media,state){if(media.state!==state){media.state=state;if(state===MediaDB.READY)
dispatchEvent(media,'ready');else
dispatchEvent(media,'unavailable',state);}}
return MediaDB;}());;'use strict';var MediaUtils={_:navigator.mozL10n.get,formatDate:function(timestamp){if(!timestamp||timestamp===undefined||isNaN(timestamp)){return;}
var dtf=new navigator.mozL10n.DateTimeFormat();return dtf.localeFormat(new Date(timestamp),this._('dateTimeFormat_%x'));},formatSize:function(size){if(!size||size===undefined||isNaN(size)){return;}
var units=['B','KB','MB','GB','TB','PB','EB','ZB','YB'];var i=0;while(size>=1024&&i<units.length){size/=1024;++i;}
var sizeString=size.toFixed((size<1024*1024)?0:1);var sizeDecimal=parseFloat(sizeString);return sizeDecimal+' '+this._('byteUnit-'+units[i]);},formatDuration:function(duration){function padLeft(num,length){var r=String(num);while(r.length<length){r='0'+r;}
return r;}
var minutes=Math.floor(duration/60);var seconds=Math.floor(duration%60);if(minutes<60){return padLeft(minutes,2)+':'+padLeft(seconds,2);}
var hours=Math.floor(minutes/60);minutes=Math.floor(minutes%60);return hours+':'+padLeft(minutes,2)+':'+padLeft(seconds,2);},populateMediaInfo:function(data){for(var id in data){if(data.hasOwnProperty(id)){var element=document.getElementById(id);if(element)
element.textContent=data[id];}}},binarySearch:function(array,element,comparator,from,to){if(comparator===undefined)
comparator=function(a,b){return a-b;};if(from===undefined)
return MediaUtils.binarySearch(array,element,comparator,0,array.length);if(from===to)
return from;var mid=Math.floor((from+to)/2);var result=comparator(element,array[mid]);if(result<0)
return MediaUtils.binarySearch(array,element,comparator,from,mid);else
return MediaUtils.binarySearch(array,element,comparator,mid+1,to);}};;'use strict';var BlobView=(function(){function fail(msg){throw Error(msg);}
function BlobView(blob,sliceOffset,sliceLength,slice,viewOffset,viewLength,littleEndian)
{this.blob=blob;this.sliceOffset=sliceOffset;this.sliceLength=sliceLength;this.slice=slice;this.viewOffset=viewOffset;this.viewLength=viewLength;this.littleEndian=littleEndian;this.view=new DataView(slice,viewOffset,viewLength);this.buffer=slice;this.byteLength=viewLength;this.byteOffset=viewOffset;this.index=0;}
BlobView.get=function(blob,offset,length,callback,littleEndian){if(offset<0)
fail('negative offset');if(length<0)
fail('negative length');if(offset>blob.size)
fail('offset larger than blob size');if(offset+length>blob.size)
length=blob.size-offset;var slice=blob.slice(offset,offset+length);var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){var result=null;if(reader.result){result=new BlobView(blob,offset,length,reader.result,0,length,littleEndian||false);}
callback(result,reader.error);};};BlobView.prototype={constructor:BlobView,getMore:function(offset,length,callback){if(offset>=this.sliceOffset&&offset+length<=this.sliceOffset+this.sliceLength){callback(new BlobView(this.blob,this.sliceOffset,this.sliceLength,this.slice,offset-this.sliceOffset,length,this.littleEndian));}
else{BlobView.get(this.blob,offset,length,callback,this.littleEndian);}},littleEndian:function(){this.littleEndian=true;},bigEndian:function(){this.littleEndian=false;},getUint8:function(offset){return this.view.getUint8(offset);},getInt8:function(offset){return this.view.getInt8(offset);},getUint16:function(offset,le){return this.view.getUint16(offset,le!==undefined?le:this.littleEndian);},getInt16:function(offset,le){return this.view.getInt16(offset,le!==undefined?le:this.littleEndian);},getUint32:function(offset,le){return this.view.getUint32(offset,le!==undefined?le:this.littleEndian);},getInt32:function(offset,le){return this.view.getInt32(offset,le!==undefined?le:this.littleEndian);},getFloat32:function(offset,le){return this.view.getFloat32(offset,le!==undefined?le:this.littleEndian);},getFloat64:function(offset,le){return this.view.getFloat64(offset,le!==undefined?le:this.littleEndian);},readByte:function(){return this.view.getInt8(this.index++);},readUnsignedByte:function(){return this.view.getUint8(this.index++);},readShort:function(le){var val=this.view.getInt16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readUnsignedShort:function(le){var val=this.view.getUint16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readInt:function(le){var val=this.view.getInt32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readUnsignedInt:function(le){var val=this.view.getUint32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readFloat:function(le){var val=this.view.getFloat32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readDouble:function(le){var val=this.view.getFloat64(this.index,le!==undefined?le:this.littleEndian);this.index+=8;return val;},tell:function(){return this.index;},remaining:function(){return this.byteLength-this.index;},seek:function(index){if(index<0)
fail('negative index');if(index>this.byteLength)
fail('index greater than buffer size');this.index=index;},advance:function(n){var index=this.index+n;if(index<0)
fail('advance past beginning of buffer');if(index>this.byteLength)
fail('advance past end of buffer');this.index=index;},getUnsignedByteArray:function(offset,n){return new Uint8Array(this.buffer,offset+this.viewOffset,n);},readUnsignedByteArray:function(n){var val=new Uint8Array(this.buffer,this.index+this.viewOffset,n);this.index+=n;return val;},getBit:function(offset,bit){var byte=this.view.getUint8(offset);return(byte&(1<<bit))!==0;},getUint24:function(offset,le){var b1,b2,b3;if(le!==undefined?le:this.littleEndian){b1=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b3=this.view.getUint8(offset+2);}
else{b3=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b1=this.view.getUint8(offset+2);}
return(b3<<16)+(b2<<8)+b1;},readUint24:function(le){var value=this.getUint24(this.index,le);this.index+=3;return value;},getASCIIText:function(offset,len){var bytes=new Uint8Array(this.buffer,offset+this.viewOffset,len);return String.fromCharCode.apply(String,bytes);},readASCIIText:function(len){var bytes=new Uint8Array(this.buffer,this.index+this.viewOffset,len);this.index+=len;return String.fromCharCode.apply(String,bytes);},getUTF8Text:function(offset,len){function fail(){throw new Error('Illegal UTF-8');}
var pos=offset;var end=offset+len;var charcode;var s='';var b1,b2,b3,b4;while(pos<end){var b1=this.view.getUint8(pos);if(b1<128){s+=String.fromCharCode(b1);pos+=1;}
else if(b1<194){fail();}
else if(b1<224){if(pos+1>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();charcode=((b1&0x1f)<<6)+(b2&0x3f);s+=String.fromCharCode(charcode);pos+=2;}
else if(b1<240){if(pos+2>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();b3=this.view.getUint8(pos+2);if(b3<128||b3>191)
fail();charcode=((b1&0x0f)<<12)+((b2&0x3f)<<6)+(b3&0x3f);s+=String.fromCharCode(charcode);pos+=3;}
else if(b1<245){if(pos+3>=end)
fail();b2=this.view.getUint8(pos+1);if(b2<128||b2>191)
fail();b3=this.view.getUint8(pos+2);if(b3<128||b3>191)
fail();b4=this.view.getUint8(pos+3);if(b4<128||b4>191)
fail();charcode=((b1&0x07)<<18)+
((b2&0x3f)<<12)+
((b3&0x3f)<<6)+
(b4&0x3f);charcode-=0x10000;s+=String.fromCharCode(0xd800+((charcode&0x0FFC00)>>>10));s+=String.fromCharCode(0xdc00+(charcode&0x0003FF));pos+=4;}
else{fail();}}
return s;},readUTF8Text:function(len){try{return this.getUTF8Text(this.index,len);}
finally{this.index+=len;}},getID3Uint28BE:function(offset){var b1=this.view.getUint8(offset)&0x7f;var b2=this.view.getUint8(offset+1)&0x7f;var b3=this.view.getUint8(offset+2)&0x7f;var b4=this.view.getUint8(offset+3)&0x7f;return(b1<<21)|(b2<<14)|(b3<<7)|b4;},readID3Uint28BE:function(){var value=this.getID3Uint28BE(this.index);this.index+=4;return value;},readNullTerminatedLatin1Text:function(size){var s='';for(var i=0;i<size;i++){var charcode=this.view.getUint8(this.index+i);if(charcode===0){i++;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;},readNullTerminatedUTF8Text:function(size){for(var len=0;len<size;len++){if(this.view.getUint8(this.index+len)===0)
break;}
var s=this.readUTF8Text(len);if(len<size)
this.advance(1);return s;},readNullTerminatedUTF16Text:function(size,le){if(le==null){var BOM=this.readUnsignedShort();size-=2;if(BOM===0xFEFF)
le=false;else
le=true;}
var s='';for(var i=0;i<size;i+=2){var charcode=this.getUint16(this.index+i,le);if(charcode===0){i+=2;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;}};return{get:BlobView.get};}());;'use strict';function getVideoRotation(blob,rotationCallback){function MP4Parser(blob,handlers){BlobView.get(blob,0,Math.min(1024,blob.size),function(data,error){if(data.byteLength<=8||data.getASCIIText(4,4)!=='ftyp'){handlers.errorHandler('not an MP4 file');return;}
parseAtom(data);});function parseAtom(data){var offset=data.sliceOffset+data.viewOffset;var size=data.readUnsignedInt();var type=data.readASCIIText(4);var contentOffset=8;if(size===0){size=blob.size-offset;}
else if(size===1){size=data.readUnsignedInt()*4294967296+data.readUnsignedInt();contentOffset=16;}
var handler=handlers[type]||handlers.defaultHandler;if(typeof handler==='function'){data.getMore(data.sliceOffset+data.viewOffset,size,function(atom){var rv=handler(atom);if(rv!=='done'){parseAtomAt(data,offset+size);}});}
else if(handler==='children'){var skip=(type==='meta')?4:0;parseAtomAt(data,offset+contentOffset+skip);}
else if(handler==='skip'||!handler){parseAtomAt(data,offset+size);}
else if(handler==='done'){return;}}
function parseAtomAt(data,offset){if(offset>=blob.size){if(handlers.eofHandler)
handlers.eofHandler();return;}
else{data.getMore(offset,16,parseAtom);}}}
MP4Parser(blob,{errorHandler:function(msg){rotationCallback(msg);},eofHandler:function(){rotationCallback(null);},defaultHandler:'skip',moov:'children',trak:'children',tkhd:function(data){data.advance(48);var a=data.readUnsignedInt();var b=data.readUnsignedInt();data.advance(4);var c=data.readUnsignedInt();var d=data.readUnsignedInt();if(a===0&&d===0){if(b===0x00010000&&c===0xFFFF0000)
rotationCallback(90);else if(b===0xFFFF0000&&c===0x00010000)
rotationCallback(270);else
rotationCallback('unexpected rotation matrix');}
else if(b===0&&c===0){if(a===0x00010000&&d===0x00010000)
rotationCallback(0);else if(a===0xFFFF0000&&d===0xFFFF0000)
rotationCallback(180);else
rotationCallback('unexpected rotation matrix');}
else{rotationCallback('unexpected rotation matrix');}
return'done';}});};(function(exports){'use strict';function ManifestHelper_get(prop){var manifest=this;var value=manifest[prop];if(manifest.locales){var lang=navigator.mozL10n.language.code||'';[lang,lang.substr(0,lang.indexOf('-'))].some(function tryLanguage(lang){if(this[lang]&&this[lang][prop]){value=this[lang][prop];return true;}},manifest.locales);}
if(typeof value==='object'&&!(value instanceof Array)){value=new ManifestHelper(value);}
return value;}
function ManifestHelper(manifest){for(var prop in manifest){Object.defineProperty(this,prop,{get:ManifestHelper_get.bind(manifest,prop),enumerable:true});}}
exports.ManifestHelper=ManifestHelper;}(window));;'use strict';var VideoStats=(function(){var startQuality;var startTime;var endQuality;var endTime;var video;function start(v){video=v;if(!video.getVideoPlaybackQuality){return;}
startQuality=video.getVideoPlaybackQuality();startTime=video.currentTime;endQuality=null;endTime=null;};function stop(){if(!video){dump('Warning: no stats have been recorded. '+'Make sure start() has been called');return;}
if(!video.getVideoPlaybackQuality){return;}
endQuality=video.getVideoPlaybackQuality();endTime=video.currentTime;};function print(){if(!video){dump('Warning: no stats have been recorded. '+'Make sure start() has been called');return;}
if(!video.getVideoPlaybackQuality){return;}
if(!startQuality||!endQuality){dump('Warning: no stats have been recorded. '+'Make sure start() and stop() have been called');return;}
var segmentDuration=(endQuality.creationTime-startQuality.creationTime)/1000;var startRendered=startQuality.totalVideoFrames-startQuality.droppedVideoFrames;var endRendered=endQuality.totalVideoFrames-endQuality.droppedVideoFrames;var segmentRendered=endRendered-startRendered;var fps=segmentRendered/segmentDuration;dump('Video statistics start');dump('Dimensions: '+video.videoWidth+'x'+video.videoHeight);dump('Complete duration: '+MediaUtils.formatDuration(video.duration));dump('Start time: '+MediaUtils.formatDuration(startTime));dump('End time: '+MediaUtils.formatDuration(endTime));dump('Total frames: '+endQuality.totalVideoFrames);dump('Decoded frames: '+
(endQuality.totalVideoFrames-endQuality.corruptedVideoFrames));dump('Corrupted frames: '+endQuality.corruptedVideoFrames);dump('Rendered frames: '+
(endQuality.totalVideoFrames-endQuality.droppedVideoFrames));dump('Dropped frames: '+endQuality.droppedVideoFrames);dump('Average rendered FPS: '+fps.toFixed(2));dump('Video statistics end');};return{start:start,stop:stop,dump:print};})();;'use strict';(function(window){function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();setTimeout(function(){var detail={name:name,timestamp:now};var evt=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(evt);});}
window.PerformanceTestingHelper={dispatch:dispatch};})(window);;var metadataQueue=[];var processingQueue=false;var stopParsingMetadataCallback=null;var noMoreWorkCallback=null;function addToMetadataQueue(fileinfo){metadataQueue.push(fileinfo);startParsingMetadata();}
function startParsingMetadata(){if(processingQueue)
return;if(metadataQueue.length===0){if(noMoreWorkCallback){noMoreWorkCallback();noMoreWorkCallback=null;}
return;}
if(document.hidden||playerShowing){return;}
processingQueue=true;showThrobber();processFirstQueuedItem();}
function stopParsingMetadata(callback){if(!processingQueue){if(callback)
callback();return;}
stopParsingMetadataCallback=callback||true;}
function processFirstQueuedItem(){if(stopParsingMetadataCallback){var callback=stopParsingMetadataCallback;stopParsingMetadataCallback=null;processingQueue=false;hideThrobber();if(callback!==true)
callback();return;}
if(metadataQueue.length===0){processingQueue=false;hideThrobber();updateDialog();if(typeof(noMoreWorkCallback)==='function'){noMoreWorkCallback();}
return;}
var fileinfo=metadataQueue.shift();videodb.getFile(fileinfo.name,function(file){getMetadata(file,function(metadata){fileinfo.metadata=metadata;videodb.updateMetadata(fileinfo.name,metadata);if(metadata.isVideo)
addVideo(fileinfo);setTimeout(processFirstQueuedItem);});},function(err){console.error('getFile error: ',fileinfo.name,err);processFirstQueuedItem();});}
function getMetadata(videofile,callback){var offscreenVideo=document.createElement('video');var metadata={};if(!offscreenVideo.canPlayType(videofile.type)){metadata.isVideo=false;callback(metadata);return;}
var url=URL.createObjectURL(videofile);offscreenVideo.preload='metadata';offscreenVideo.src=url;offscreenVideo.onerror=function(e){console.error("Can't play video",videofile.name,e);metadata.isVideo=false;unload();callback(metadata);};offscreenVideo.onloadedmetadata=function(){if(!offscreenVideo.videoWidth){metadata.isVideo=false;unload();callback(metadata);return;}
metadata.isVideo=true;metadata.title=readFromMetadata('title')||fileNameToVideoName(videofile.name);metadata.duration=offscreenVideo.duration;metadata.width=offscreenVideo.videoWidth;metadata.height=offscreenVideo.videoHeight;if(/.3gp$/.test(videofile.name)){getVideoRotation(videofile,function(rotation){if(typeof rotation==='number')
metadata.rotation=rotation;else if(typeof rotation==='string')
console.warn('Video rotation:',rotation);createThumbnail();});}else{metadata.rotation=0;createThumbnail();}};function readFromMetadata(lowerCaseKey){var tags=offscreenVideo.mozGetMetadata();for(var key in tags){if(key.toLowerCase()===lowerCaseKey){return tags[key];}}
return;}
function createThumbnail(){offscreenVideo.currentTime=Math.min(5,offscreenVideo.duration/10);var failed=false;var timeout=setTimeout(fail,10000);offscreenVideo.onerror=fail;function fail(){console.warn('Seek failed while creating thumbnail for',videofile.name,'. Ignoring corrupt file.');failed=true;clearTimeout(timeout);offscreenVideo.onerror=null;metadata.isVideo=false;unload();callback(metadata);}
offscreenVideo.onseeked=function(){if(failed)
return;clearTimeout(timeout);captureFrame(offscreenVideo,metadata,function(poster){metadata.poster=poster;unload();callback(metadata);});};}
function unload(){URL.revokeObjectURL(offscreenVideo.src);offscreenVideo.removeAttribute('src');offscreenVideo.load();}
function fileNameToVideoName(filename){filename=filename.split('/').pop().replace(/\.(webm|ogv|ogg|mp4|3gp)$/,'').replace(/[_\.]/g,' ');return filename.charAt(0).toUpperCase()+filename.slice(1);}}
function captureFrame(player,metadata,callback){try{var canvas=document.createElement('canvas');var ctx=canvas.getContext('2d');canvas.width=THUMBNAIL_WIDTH;canvas.height=THUMBNAIL_HEIGHT;var vw=player.videoWidth,vh=player.videoHeight;var tw,th;switch(metadata.rotation){case 90:ctx.translate(THUMBNAIL_WIDTH,0);ctx.rotate(Math.PI/2);tw=THUMBNAIL_HEIGHT;th=THUMBNAIL_WIDTH;break;case 180:ctx.translate(THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT);ctx.rotate(Math.PI);tw=THUMBNAIL_WIDTH;th=THUMBNAIL_HEIGHT;break;case 270:ctx.translate(0,THUMBNAIL_HEIGHT);ctx.rotate(-Math.PI/2);tw=THUMBNAIL_HEIGHT;th=THUMBNAIL_WIDTH;break;default:tw=THUMBNAIL_WIDTH;th=THUMBNAIL_HEIGHT;break;}
var scale=Math.min(tw/vw,th/vh),w=scale*vw,h=scale*vh,x=(tw-w)/2/scale,y=(th-h)/2/scale;ctx.scale(scale,scale);ctx.drawImage(player,x,y);canvas.toBlob(callback,'image/jpeg');}
catch(e){console.error('Exception in captureFrame:',e,e.stack);callback(null);}};function initDB(){videodb=new MediaDB('videos',null,{excludeFilter:/DCIM\/\d{3}MZLLA\/\.VID_\d{4}\.3gp$/});videodb.onupgrading=function(evt){storageState=MediaDB.UPGRADING;updateDialog();};videodb.onunavailable=function(event){storageState=event.detail;if(playerShowing){hidePlayer(true);}
updateDialog();};videodb.oncardremoved=function(){if(playerShowing)
hidePlayer(true);};videodb.onready=function(){storageState=false;updateDialog();enumerateDB();};videodb.onscanend=function(){firstScanEnded=true;updateDialog();updateLoadingSpinner();};videodb.oncreated=function(event){event.detail.forEach(videoCreated);};videodb.ondeleted=function(event){event.detail.forEach(videoDeleted);};}
var enumerated=false;function enumerateDB(){if(enumerated)
return;enumerated=true;var batch=[];var batchSize=4;videodb.enumerate('date',null,'prev',function(videoinfo){if(videoinfo===null){flush();return;}
var isVideo=videoinfo.metadata.isVideo;if(isVideo===false){return;}
if(isVideo===undefined){addToMetadataQueue(videoinfo);return;}
if(isVideo===true){batch.push(videoinfo);if(batch.length>=batchSize){flush();batchSize*=2;}}});function flush(){batch.forEach(addVideo);batch.length=0;}}
function addVideo(videodata){if(!videodata||!videodata.metadata.isVideo){return;}
var view=thumbnailList.addItem(videodata);view.addTapListener(thumbnailClickHandler);view.updateTitleText();if(thumbnailList.count===1){updateDialog();}}
function videoCreated(videoinfo){addToMetadataQueue(videoinfo);}
function videoDeleted(filename){if(currentVideo&&filename===currentVideo.name){resetCurrentVideo();}
thumbnailList.removeItem(filename);if(thumbnailList.count===0){updateDialog();hideSelectView();}};function ThumbnailList(groupClass,container){if(!groupClass||!container){throw new Error('group class or container cannot be null or undefined');}
this.thumbnailMap={};this.groupMap={};this.itemGroups=[];this.count=0;this.groupClass=groupClass;this.container=container;}
ThumbnailList.prototype.addItem=function(item){if(!item){return null;}
if(this.thumbnailMap[item.name]){return this.thumbnailMap[item.name];}
var _this=this;function createItemGroup(item,before){var group=new _this.groupClass(item);_this.container.insertBefore(group.htmlNode,before?before.htmlNode:null);return group;}
function getItemGroup(item){var groupID=_this.groupClass.getGroupID(item);var i;for(i=0;i<_this.itemGroups.length;i++){if(_this.itemGroups[i].groupID===groupID){return _this.itemGroups[i];}else if(_this.groupClass.compareGroupID(_this.itemGroups[i].groupID,groupID)<0){break;}}
var createdGroup=createItemGroup(item,_this.itemGroups[i]);_this.itemGroups.splice(i,0,createdGroup);return createdGroup;}
var group=getItemGroup(item);var thumbnail=group.addItem(item);this.groupMap[item.name]=group;this.thumbnailMap[item.name]=thumbnail;this.count++;return thumbnail;};ThumbnailList.prototype.removeItem=function(filename){if(!this.thumbnailMap[filename]){return;}
var group=this.groupMap[filename];group.removeItem(this.thumbnailMap[filename]);if(!group.getCount()){this.container.removeChild(group.htmlNode);this.itemGroups.splice(this.itemGroups.indexOf(group),1);}
this.count--;delete this.groupMap[filename];delete this.thumbnailMap[filename];};ThumbnailList.prototype.reset=function(){for(var name in this.thumbnailMap){this.groupMap[name].removeItem(this.thumbnailMap[name]);}
this.container.innerHTML='';this.thumbnailMap={};this.itemGroups=[];this.groupMap={};this.count=0;};ThumbnailList.prototype.isPickMode=function(){return this.container.classList.contains('pick');};ThumbnailList.prototype.setPickMode=function(pick){if(pick){this.container.classList.add('pick');}else{this.container.classList.remove('pick');}};ThumbnailList.prototype.isSelectMode=function(){return this.container.classList.contains('select');};ThumbnailList.prototype.setSelectMode=function(select){if(select){this.container.classList.add('select');}else{this.container.classList.remove('select');}};ThumbnailList.prototype.upateAllThumbnailTitle=function(){for(var key in this.thumbnailMap){this.thumbnailMap[key].updateTitleText();}};ThumbnailList.prototype.findNextThumbnail=function(filename){var currentGroup=this.groupMap[filename];if(!currentGroup){return this.itemGroups.length?this.itemGroups[0].thumbnails[0]:null;}
var currentThumbnail=this.thumbnailMap[filename];var idx;if(currentGroup.thumbnails.length===1){idx=this.itemGroups.indexOf(currentGroup);if(idx===0){if(this.itemGroups.length>1){currentThumbnail=this.itemGroups[1].thumbnails[0];}else{currentThumbnail=null;}}else{var thumbnails=this.itemGroups[idx-1].thumbnails;currentThumbnail=thumbnails[thumbnails.length-1];}}else{idx=currentGroup.thumbnails.indexOf(currentThumbnail);if(idx===0){currentThumbnail=currentGroup.thumbnails[1];}else{currentThumbnail=currentGroup.thumbnails[idx-1];}}
return currentThumbnail;};;function ThumbnailDateGroup(item){if(!item){throw new Error('item should not be null or undefined.');}
this.thumbnails=[];this.groupID=ThumbnailDateGroup.getGroupID(item);this.htmlNode=null;this.container=null;var _this=this;var _=navigator.mozL10n.get;render();function render(){if(!ThumbnailDateGroup.Template){throw new Error('template is required while rendering.');}
var dateFormatter=new navigator.mozL10n.DateTimeFormat();var htmlText=ThumbnailDateGroup.Template.interpolate({'group-header':dateFormatter.localeFormat(new Date(item.date),_('date-group-header'))});var dummyDiv=document.createElement('DIV');dummyDiv.innerHTML=htmlText;var domNode=dummyDiv.firstElementChild;if(!domNode){throw new Error('the template is empty');}
_this.htmlNode=domNode;_this.container=domNode.querySelector('.thumbnail-group-container');}}
ThumbnailDateGroup.getGroupID=function(item){var dateObj=new Date(item.date);var month=dateObj.getMonth()+1;return'group_'+dateObj.getFullYear()+'-'+
(month<10?'0'+month:month);};ThumbnailDateGroup.compareGroupID=function(id1,id2){return id1>id2?1:(id1<id2?-1:0);};ThumbnailDateGroup.prototype.addItem=function(item){if(!item){return;}
var _this=this;function getInsertPosition(thumbnail){if(_this.thumbnails.length===0||thumbnail.data.date>_this.thumbnails[0].data.date){return 0;}
else if(thumbnail.data.date<_this.thumbnails[_this.thumbnails.length-1].data.date){return _this.thumbnails.length;}
else{return MediaUtils.binarySearch(_this.thumbnails,thumbnail,function(a,b){return b.data.date-a.data.date;});}}
var thumbnail=new ThumbnailItem(item);var insertPosition=getInsertPosition(thumbnail);this.container.insertBefore(thumbnail.htmlNode,this.container.children[insertPosition]);this.thumbnails.splice(insertPosition,0,thumbnail);return thumbnail;};ThumbnailDateGroup.prototype.getCount=function(){return this.thumbnails.length;};ThumbnailDateGroup.prototype.removeItem=function(thumbnail){var idx=this.thumbnails.indexOf(thumbnail);if(idx<0){return;}
this.thumbnails.splice(idx,1);this.container.removeChild(thumbnail.htmlNode);};;function ThumbnailItem(videoData){if(!videoData){throw new Error('videoData should not be null or undefined.');}
this.posterNode=null;this.unwatchedNode=null;this.detailNode=null;this.titleNode=null;this.htmlNode=null;this.tapListeners=[];this.data=videoData;var _this=this;render();function convertToDOM(htmlText){var dummyDiv=document.createElement('div');dummyDiv.innerHTML=htmlText;var domNode=dummyDiv.firstElementChild;if(!domNode){throw new Error('the template does not contain any element');}
_this.htmlNode=domNode;_this.posterNode=domNode.querySelector('.img');_this.detailNode=domNode.querySelector('.details');_this.titleNode=domNode.querySelector('.title');_this.unwatchedNode=domNode.querySelector('.unwatched');}
function render(){if(!ThumbnailItem.Template){throw new Error('Template is needed while rendering');}
var duration='';if(isFinite(_this.data.metadata.duration)){duration=MediaUtils.formatDuration(_this.data.metadata.duration);}
var sizeText=isFinite(_this.data.size)?MediaUtils.formatSize(_this.data.size):'';var videoType='';if(_this.data.type){var pos=_this.data.type.indexOf('/');videoType=(pos>-1?_this.data.type.slice(pos+1):_this.data.type);}
var htmlText=ThumbnailItem.Template.interpolate({'title':_this.data.metadata.title,'duration-text':duration,'size-text':sizeText,'type-text':videoType});convertToDOM(htmlText);_this.updatePoster(_this.data.metadata.bookmark||_this.data.metadata.poster);_this.setWatched(_this.data.metadata.watched);if(_this.detailNode){_this.detailNode.dataset.title=_this.data.metadata.title;}
_this.htmlNode.addEventListener('click',dispatchClick);}
function dispatchClick(){_this.tapListeners.forEach(function(listener){if(listener.handleEvent){listener.handleEvent(_this.data);}else if((typeof listener)==='function'){listener(_this.data);}});}}
ThumbnailItem.titleMaxLines=2;ThumbnailItem.prototype.addTapListener=function(listener){if(!listener){return;}
this.tapListeners[this.tapListeners.length]=listener;};ThumbnailItem.prototype.removeTapListener=function(listener){if(!listener){return;}
var idx=this.tapListeners.indexOf(listener);if(idx>-1){this.tapListeners.splice(idx,1);}};ThumbnailItem.prototype.setWatched=function(watched){if(!this.unwatchedNode){return;}
this.unwatchedNode.hidden=watched;};ThumbnailItem.prototype.updatePoster=function(imageblob){if(!this.posterNode){return;}
if(this.posterNode.dataset.uri){URL.revokeObjectURL(this.posterNode.dataset.uri);}
if(imageblob){this.posterNode.classList.remove('default');var imageUri=URL.createObjectURL(imageblob);this.posterNode.dataset.uri=imageUri;this.posterNode.style.backgroundImage='url('+imageUri+')';}else{this.posterNode.classList.add('default');this.posterNode.dataset.uri='';this.posterNode.style.backgroundImage='url(style/images/default_thumbnail.png)';}};ThumbnailItem.prototype.updateTitleText=function(){this.titleNode.textContent=VideoUtils.getTruncated(this.data.metadata.title,{node:this.titleNode,maxLine:ThumbnailItem.titleMaxLines,ellipsisIndex:0});};;var VideoUtils={fitContainer:function(container,player,videoRotation){var containerWidth=container.clientWidth;var containerHeight=container.clientHeight;if(!player.videoWidth||!player.videoHeight)
return;var width,height;var rotation=videoRotation||0;switch(rotation){case 0:case 180:width=player.videoWidth;height=player.videoHeight;break;case 90:case 270:width=player.videoHeight;height=player.videoWidth;}
var xscale=containerWidth/width;var yscale=containerHeight/height;var scale=Math.min(xscale,yscale);width*=scale;height*=scale;var left=((containerWidth-width)/2);var top=((containerHeight-height)/2);var transform;switch(rotation){case 0:transform='translate('+left.toFixed(4)+'px,'+
top.toFixed(4)+'px)';break;case 90:transform='translate('+(left+width).toFixed(4)+'px,'+
top.toFixed(4)+'px) '+'rotate(90deg)';break;case 180:transform='translate('+(left+width).toFixed(4)+'px,'+
(top+height).toFixed(4)+'px) '+'rotate(180deg)';break;case 270:transform='translate('+left.toFixed(4)+'px,'+
(top+height).toFixed(4)+'px) '+'rotate(270deg)';break;}
transform+=' scale('+scale.toFixed(4)+')';player.style.transform=transform;},getTruncated:function(oldName,options){var maxLine=options.maxLine||2;var node=options.node;var ellipsisIndex=(options.ellipsisIndex||options.ellipsisIndex===0)?ellipsisIndex=options.ellipsisIndex:3;var ellipsisCharacter=options.ellipsisCharacter||'...';if(node===null){return oldName;}
function hitsNewline(oldHeight,newHeight){return oldHeight!==newHeight;}
var newName='';var oldHeight;var newHeight;var baseHeight;var currentLine;var ellipsisAt;var nameBeforeEllipsis=[];var nameBeforeEllipsisString;var nameAfterEllipsis=ellipsisIndex?oldName.slice(-ellipsisIndex):'';var realVisibility=node.style.visibility;var realWordBreak=node.style.wordBreak;node.style.visibility='hidden';node.style.wordBreak='break-all';node.textContent='.';baseHeight=node.clientHeight;node.textContent=oldName;var originalTitleHeight=node.clientHeight;var linesForOriginalTitle=(originalTitleHeight/baseHeight);if(linesForOriginalTitle<=maxLine){node.style.visibility=realVisibility;node.style.wordBreak=realWordBreak;return oldName;}
node.textContent='';var ellipseIndex;oldName.split('').some(function(character,index){ellipseIndex=index;nameBeforeEllipsis.push(character);nameBeforeEllipsisString=nameBeforeEllipsis.join('');oldHeight=node.clientHeight;node.textContent=nameBeforeEllipsisString+
ellipsisCharacter+nameAfterEllipsis;newHeight=node.clientHeight;if(index===0){currentLine=Math.floor(newHeight/baseHeight);}
if(hitsNewline(oldHeight,newHeight)&&index!==0){currentLine+=1;}
if(currentLine>maxLine){if(index===0){console.error('Your string is in a overflowed situation, '+'please check your options');}
nameBeforeEllipsis.pop();node.textContent='';newName=nameBeforeEllipsis.join('').slice(0,ellipseIndex);newName+=ellipsisCharacter;newName+=nameAfterEllipsis;return;}});node.style.visibility=realVisibility;node.style.wordBreak=realWordBreak;return newName;}};;'use strict';const LAYOUT_MODE={list:'layout-list',selection:'layout-selection',fullscreenPlayer:'layout-fullscreen-player'};var dom={};var ids=['thumbnail-list-view','thumbnails-bottom','thumbnail-list-title','thumbnails','thumbnails-video-button','thumbnails-select-button','thumbnail-select-view','thumbnails-delete-button','thumbnails-share-button','thumbnails-cancel-button','thumbnails-number-selected','player-view','fullscreen-button','spinner-overlay','thumbnails-single-delete-button','thumbnails-single-share-button','thumbnails-single-info-button','info-view','info-close-button','player','overlay','overlay-title','overlay-text','overlay-menu','overlay-action-button','video-container','videoControls','videoBar','videoActionBar','close','play','playHead','timeSlider','elapsedTime','video-title','duration-text','elapsed-text','bufferedTime','slider-wrapper','throbber','delete-video-button','picker-close','picker-title','picker-done'];ids.forEach(function createElementRef(name){dom[toCamelCase(name)]=document.getElementById(name);});dom.player.mozAudioChannelType='content';var playing=false;var playerShowing=false;var endedTimer;var controlShowing=false;var controlFadeTimeout=null;var selectedFileNames=[];var selectedFileNamesToBlobs={};var videodb;var currentVideo;var currentVideoBlob;var firstScanEnded=false;var THUMBNAIL_WIDTH;var THUMBNAIL_HEIGHT;var HAVE_NOTHING=0;var storageState;var currentOverlay;var dragging=false;var touchStartID=null;var isPausedWhileDragging;var sliderRect;var thumbnailList;var pendingPick;var restoreTime=null;var isPhone;var isPortrait;var currentLayoutMode;var pendingUpdateTitleText=false;var FROMCAMERA=/DCIM\/\d{3}MZLLA\/VID_\d{4}\.3gp$/;document.addEventListener('visibilitychange',function visibilityChange(){if(document.hidden){stopParsingMetadata();if(playing)
pause();if(playerShowing)
releaseVideo();}
else{if(playerShowing){setControlsVisibility(true);restoreVideo();}else{startParsingMetadata();}}});window.addEventListener('localized',function initLocale(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;});navigator.mozL10n.ready(function initVideo(){if(!videodb)
init();if(!isPhone){var req=navigator.mozApps.getSelf();req.onsuccess=function(){var manifest=new ManifestHelper(req.result.manifest);dom.thumbnailListTitle.textContent=manifest.name;};}});initLayout();initThumbnailSize();function init(){thumbnailList=new ThumbnailList(ThumbnailDateGroup,dom.thumbnails);ThumbnailDateGroup.Template=new Template('thumbnail-group-header');ThumbnailItem.Template=new Template('thumbnail-template');ThumbnailItem.titleMaxLines=isPhone?2:(isPortrait?4:2);initDB();if(!navigator.mozHasPendingMessage('activity')){initOptionsButtons();}
initPlayerControls();var acm=navigator.mozAudioChannelManager;if(acm){acm.addEventListener('headphoneschange',function onheadphoneschange(){if(!acm.headphones&&playing){setVideoPlaying(false);}});}
navigator.mozSetMessageHandler('activity',handleActivityEvents);dom.overlayActionButton.addEventListener('click',function(){if(pendingPick){cancelPick();}else if(currentOverlay==='empty'){launchCameraApp();}});}
function initThumbnailSize(){if(isPhone){THUMBNAIL_WIDTH=210*window.devicePixelRatio;THUMBNAIL_HEIGHT=120*window.devicePixelRatio;}else{var shortEdge=Math.min(window.innerWidth,window.innerHeight);THUMBNAIL_WIDTH=424*window.devicePixelRatio*shortEdge/800;THUMBNAIL_HEIGHT=Math.round(THUMBNAIL_WIDTH*4/7);}}
function initLayout(){ScreenLayout.watch('portrait','(orientation: portrait)');isPhone=ScreenLayout.getCurrentLayout('tiny');isPortrait=ScreenLayout.getCurrentLayout('portrait');if(isPhone||isPortrait){dom.spinnerOverlay.classList.add('hidden');dom.playerView.classList.remove('disabled');}else{dom.spinnerOverlay.classList.remove('hidden');dom.playerView.classList.add('disabled');}
window.addEventListener('screenlayoutchange',handleScreenLayoutChange);switchLayout(LAYOUT_MODE.list);}
function initPlayerControls(){dom.sliderWrapper.addEventListener('touchstart',handleSliderTouchStart);dom.sliderWrapper.addEventListener('touchmove',handleSliderTouchMove);dom.sliderWrapper.addEventListener('touchend',handleSliderTouchEnd);dom.player.addEventListener('timeupdate',timeUpdated);dom.player.addEventListener('ended',playerEnded);dom.videoControls.addEventListener('click',toggleVideoControls,true);dom.play.addEventListener('click',handlePlayButtonClick);dom.close.addEventListener('click',handleCloseButtonClick);dom.pickerDone.addEventListener('click',postPickResult);}
function initOptionsButtons(){dom.thumbnailsVideoButton.addEventListener('click',launchCameraApp);dom.thumbnailsSelectButton.addEventListener('click',showSelectView);dom.thumbnailsCancelButton.addEventListener('click',hideSelectView);dom.thumbnailsDeleteButton.addEventListener('click',deleteSelectedItems);dom.thumbnailsShareButton.addEventListener('click',shareSelectedItems);dom.infoCloseButton.addEventListener('click',hideInfoView);dom.fullscreenButton.addEventListener('click',toggleFullscreenPlayer);addEventListeners('.single-delete-button','click',deleteCurrentVideo);addEventListeners('.single-share-button','click',shareCurrentVideo);addEventListeners('.single-info-button','click',showInfoView);}
function addEventListeners(selector,type,listener){var elements=document.body.querySelectorAll(selector);for(var i=0;i<elements.length;i++){elements[i].addEventListener(type,listener);}}
function toggleFullscreenPlayer(e){if(currentLayoutMode===LAYOUT_MODE.list){switchLayout(LAYOUT_MODE.fullscreenPlayer);scheduleVideoControlsAutoHiding();}else{switchLayout(LAYOUT_MODE.list);}
VideoUtils.fitContainer(dom.videoContainer,dom.player,currentVideo.metadata.rotation||0);}
function toggleVideoControls(e){if(controlFadeTimeout){clearTimeout(controlFadeTimeout);controlFadeTimeout=null;}
if(!pendingPick){if(!controlShowing){setControlsVisibility(true);e.cancelBubble=true;}else if(e.originalTarget===dom.videoControls){setControlsVisibility(false);}}}
function handleScreenLayoutChange(){isPortrait=ScreenLayout.getCurrentLayout('portrait');if(!isPhone){if(!isPortrait&&(!firstScanEnded||processingQueue)){dom.spinnerOverlay.classList.remove('hidden');dom.playerView.classList.add('disabled');}else{dom.spinnerOverlay.classList.add('hidden');dom.playerView.classList.remove('disabled');}
if(currentLayoutMode===LAYOUT_MODE.list){if(isPortrait){hidePlayer(true);}else{showPlayer(currentVideo,false,false,true);}}
ThumbnailItem.titleMaxLines=isPortrait?4:2;}
if(currentLayoutMode!==LAYOUT_MODE.fullscreenPlayer){if(!thumbnailList){return;}
thumbnailList.upateAllThumbnailTitle();}else{pendingUpdateTitleText=true;}
if(dom.player.readyState!==HAVE_NOTHING){VideoUtils.fitContainer(dom.videoContainer,dom.player,currentVideo.metadata.rotation||0);}}
function switchLayout(mode){var oldMode=currentLayoutMode;if(oldMode){document.body.classList.remove(currentLayoutMode);}
currentLayoutMode=mode;document.body.classList.add(currentLayoutMode);if(oldMode===LAYOUT_MODE.fullscreenPlayer&&pendingUpdateTitleText){pendingUpdateTitleText=false;thumbnailList.upateAllThumbnailTitle();}}
function handleActivityEvents(a){var activityName=a.source.name;if(activityName==='pick'){pendingPick=a;showPickView();}}
function showInfoView(){var length=isFinite(currentVideo.metadata.duration)?MediaUtils.formatDuration(currentVideo.metadata.duration):'';var size=isFinite(currentVideo.size)?MediaUtils.formatSize(currentVideo.size):'';var type=currentVideo.type;if(type){var index=currentVideo.type.indexOf('/');type=index>-1?currentVideo.type.slice(index+1):currentVideo.type;}
var resolution=(currentVideo.metadata.width&&currentVideo.metadata.height)?currentVideo.metadata.width+'x'+
currentVideo.metadata.height:'';var data={'info-name':currentVideo.metadata.title,'info-length':length,'info-size':size,'info-type':type,'info-date':MediaUtils.formatDate(currentVideo.date),'info-resolution':resolution};MediaUtils.populateMediaInfo(data);dom.infoView.classList.remove('hidden');}
function hideInfoView(){dom.infoView.classList.add('hidden');}
function showSelectView(){hidePlayer(true,function(){switchLayout(LAYOUT_MODE.selection);thumbnailList.setSelectMode(true);clearSelection();});}
function hideSelectView(){clearSelection();thumbnailList.setSelectMode(false);switchLayout(LAYOUT_MODE.list);if(!isPhone&&!isPortrait&&currentVideo){showPlayer(currentVideo,false,false,true);}}
function clearSelection(){Array.forEach(selectedFileNames,function(name){thumbnailList.thumbnailMap[name].htmlNode.classList.remove('selected');});selectedFileNames=[];selectedFileNamesToBlobs={};dom.thumbnailsDeleteButton.classList.add('disabled');dom.thumbnailsShareButton.classList.add('disabled');dom.thumbnailsNumberSelected.textContent=navigator.mozL10n.get('number-selected2',{n:0});}
function updateSelection(videodata){var thumbnail=thumbnailList.thumbnailMap[videodata.name];var selected;if(thumbnail.htmlNode.classList.contains('selected')){thumbnail.htmlNode.classList.remove('selected');selected=false;}else{thumbnail.htmlNode.classList.add('selected');selected=true;}
var filename=videodata.name;if(selected){selectedFileNames.push(filename);videodb.getFile(filename,function(blob){selectedFileNamesToBlobs[filename]=blob;});}
else{delete selectedFileNamesToBlobs[filename];var i=selectedFileNames.indexOf(filename);if(i!==-1)
selectedFileNames.splice(i,1);}
var numSelected=selectedFileNames.length;dom.thumbnailsNumberSelected.textContent=navigator.mozL10n.get('number-selected2',{n:numSelected});if(numSelected===0){dom.thumbnailsDeleteButton.classList.add('disabled');dom.thumbnailsShareButton.classList.add('disabled');}
else{dom.thumbnailsDeleteButton.classList.remove('disabled');dom.thumbnailsShareButton.classList.remove('disabled');}}
function launchCameraApp(){var a=new MozActivity({name:'record',data:{type:'videos'}});}
function resetCurrentVideo(){if(!currentVideo){return;}
var currentThumbnail=thumbnailList.thumbnailMap[currentVideo.name];currentThumbnail.htmlNode.classList.remove('focused');var nextThumbnail=thumbnailList.findNextThumbnail(currentVideo.name);if(nextThumbnail){currentVideo=nextThumbnail.data;nextThumbnail.htmlNode.classList.add('focused');}else{currentVideo=null;}}
function deleteSelectedItems(){if(selectedFileNames.length===0)
return;var msg=navigator.mozL10n.get('delete-n-items?',{n:selectedFileNames.length});if(confirm(msg)){for(var i=0;i<selectedFileNames.length;i++){deleteFile(selectedFileNames[i]);}
clearSelection();}}
function deleteFile(filename){if(FROMCAMERA.test(filename)){var postername=filename.replace('.3gp','.jpg');navigator.getDeviceStorage('pictures').delete(postername);}
videodb.deleteFile(filename);}
function deleteSingleFile(file){var msg=navigator.mozL10n.get('confirm-delete');if(confirm(msg+' '+file)){deleteFile(file);return true;}
return false;}
function shareSelectedItems(){var blobs=selectedFileNames.map(function(name){return selectedFileNamesToBlobs[name];});share(blobs);}
function share(blobs){if(blobs.length===0)
return;var names=[],types=[],fullpaths=[];blobs.forEach(function(blob){var name=blob.name;fullpaths.push(name);name=name.substring(name.lastIndexOf('/')+1);names.push(name);var type=blob.type;if(type)
type=type.substring(0,type.indexOf('/'));types.push(type);});var type;if(types.length===1||types.every(function(t){return t===types[0];}))
type=types[0]+'/*';else
type='multipart/mixed';var a=new MozActivity({name:'share',data:{type:type,number:blobs.length,blobs:blobs,filenames:names,filepaths:fullpaths}});a.onerror=function(e){if(a.error.name==='NO_PROVIDER'){var msg=navigator.mozL10n.get('share-noprovider');alert(msg);}else{console.warn('share activity error:',a.error.name);}};}
function updateDialog(){if(thumbnailList.count!==0&&(!storageState||playerShowing)){showOverlay(null);}else if(storageState===MediaDB.UPGRADING){showOverlay('upgrade');}else if(storageState===MediaDB.NOCARD){showOverlay('nocard');}else if(storageState===MediaDB.UNMOUNTED){showOverlay('pluggedin');}else if(firstScanEnded&&thumbnailList.count===0&&metadataQueue.length===0){showOverlay('empty');}}
function updateLoadingSpinner(){if(processingQueue){noMoreWorkCallback=updateLoadingSpinner;}else{PerformanceTestingHelper.dispatch('scan-finished');dom.spinnerOverlay.classList.add('hidden');dom.playerView.classList.remove('disabled');if(thumbnailList.count){currentVideo=thumbnailList.itemGroups[0].thumbnails[0].data;if(!isPhone&&!isPortrait){showPlayer(currentVideo,false,false,true);}}}}
function thumbnailClickHandler(videodata){if(!isPhone&&!isPortrait){if(!firstScanEnded||processingQueue){return;}}
if(currentLayoutMode===LAYOUT_MODE.list){hidePlayer(true,function(){stopParsingMetadata(function(){var fullscreen=pendingPick||isPhone||isPortrait;showPlayer(videodata,!pendingPick,fullscreen,pendingPick);});});}
else if(currentLayoutMode===LAYOUT_MODE.selection){updateSelection(videodata);}}
function setPosterImage(dom,poster){if(dom.dataset.uri){URL.revokeObjectURL(dom.dataset.uri);}
dom.dataset.uri=URL.createObjectURL(poster);dom.style.backgroundImage='url('+dom.dataset.uri+')';}
function showOverlay(id){currentOverlay=id;if(id===null){dom.overlay.classList.add('hidden');return;}
var _=navigator.mozL10n.get;if(pendingPick||id==='empty'){dom.overlayMenu.classList.remove('hidden');dom.overlayActionButton.classList.remove('hidden');dom.overlayActionButton.textContent=_(pendingPick?'overlay-cancel-button':'overlay-camera-button');}else{dom.overlayMenu.classList.add('hidden');dom.overlayActionButton.classList.add('hidden');}
if(id==='nocard'){dom.overlayTitle.textContent=_('nocard2-title');dom.overlayText.textContent=_('nocard3-text');}else{dom.overlayTitle.textContent=_(id+'-title');dom.overlayText.textContent=_(id+'-text');}
dom.overlay.classList.remove('hidden');}
function setControlsVisibility(visible){if(isPhone||isPortrait||currentLayoutMode!==LAYOUT_MODE.list){dom.videoControls.classList[visible?'remove':'add']('hidden');controlShowing=visible;}else{controlShowing=true;}
if(controlShowing){updateVideoControlSlider();}}
function updateVideoControlSlider(){var percent=(dom.player.currentTime/dom.player.duration)*100;if(isNaN(percent)){return;}
percent+='%';dom.elapsedText.textContent=MediaUtils.formatDuration(dom.player.currentTime);dom.elapsedTime.style.width=percent;if(!dragging){dom.playHead.style.left=percent;}}
function setVideoPlaying(playing){if(playing){play();}else{pause();}}
function deleteCurrentVideo(){if(deleteSingleFile(currentVideo.name)){if(!isPhone&&!isPortrait){if(currentVideo){showPlayer(currentVideo,false,true,true);}}else{hidePlayer(false);}}}
function handlePlayButtonClick(){setVideoPlaying(dom.player.paused);}
function handleCloseButtonClick(){if(isPhone||isPortrait){hidePlayer(true);}else{toggleFullscreenPlayer();}}
function postPickResult(){pendingPick.postResult({type:currentVideoBlob.type,blob:currentVideoBlob});cleanupPick();}
function shareCurrentVideo(){videodb.getFile(currentVideo.name,function(blob){share([blob]);});}
function handleSliderTouchStart(event){if(null!=touchStartID){return;}
touchStartID=event.changedTouches[0].identifier;isPausedWhileDragging=dom.player.paused;dragging=true;sliderRect=dom.sliderWrapper.getBoundingClientRect();if(dom.player.duration===Infinity)
return;if(!isPausedWhileDragging){dom.player.pause();}
handleSliderTouchMove(event);}
function setVideoUrl(player,video,callback){if('name'in video){videodb.getFile(video.name,function(file){var url=URL.createObjectURL(file);player.onloadedmetadata=callback;player.src=url;if(pendingPick)
currentVideoBlob=file;});}else if('url'in video){player.onloadedmetadata=callback;player.src=video.url;}}
function scheduleVideoControlsAutoHiding(){controlFadeTimeout=setTimeout(function(){setControlsVisibility(false);},250);}
function showPlayer(video,autoPlay,enterFullscreen,keepControls){if(currentVideo){var old=thumbnailList.thumbnailMap[currentVideo.name];old.htmlNode.classList.remove('focused');}
currentVideo=video;var thumbnail=thumbnailList.thumbnailMap[currentVideo.name];thumbnail.htmlNode.classList.add('focused');updateDialog();dom.player.preload='metadata';function doneSeeking(){dom.player.onseeked=null;setControlsVisibility(true);if(!keepControls){scheduleVideoControlsAutoHiding();}
if(autoPlay){play();}else{pause();}
dom.player.hidden=false;}
dom.player.hidden=true;setVideoUrl(dom.player,currentVideo,function(){if(enterFullscreen){switchLayout(LAYOUT_MODE.fullscreenPlayer);}
dom.durationText.textContent=MediaUtils.formatDuration(dom.player.duration);timeUpdated();dom.play.classList.remove('paused');playerShowing=true;VideoUtils.fitContainer(dom.videoContainer,dom.player,currentVideo.metadata.rotation||0);if('metadata'in currentVideo){if(currentVideo.metadata.currentTime===dom.player.duration){currentVideo.metadata.currentTime=0;}
dom.videoTitle.textContent=currentVideo.metadata.title;dom.player.currentTime=currentVideo.metadata.currentTime||0;}else{dom.videoTitle.textContent=currentVideo.title||'';dom.player.currentTime=0;}
if(dom.player.seeking){dom.player.onseeked=doneSeeking;}else{doneSeeking();}
if(window.navigator.mozNfc){window.navigator.mozNfc.onpeerready=function(event){videodb.getFile(video.name,function(file){navigator.mozNfc.getNFCPeer(event.detail).sendFile(file);});};}});}
function hidePlayer(updateVideoMetadata,callback){if(!playerShowing){if(callback){callback();}
return;}
dom.player.pause();if(window.navigator.mozNfc){window.navigator.mozNfc.onpeerready=null;}
function completeHidingPlayer(){switchLayout(LAYOUT_MODE.list);dom.play.classList.remove('paused');playerShowing=false;updateDialog();dom.player.removeAttribute('src');dom.player.load();startParsingMetadata();if(callback){callback();}}
if(!('metadata'in currentVideo)||!updateVideoMetadata||pendingPick){completeHidingPlayer();return;}
var video=currentVideo;var thumbnail=thumbnailList.thumbnailMap[video.name];if(dom.player.currentTime===0){video.metadata.bookmark=null;updateMetadata();}
else{captureFrame(dom.player,video.metadata,function(bookmark){video.metadata.bookmark=bookmark;updateMetadata();});}
function updateMetadata(){thumbnail.updatePoster(video.metadata.bookmark||video.metadata.poster);if(!video.metadata.watched){video.metadata.watched=true;thumbnail.setWatched(true);}
video.metadata.currentTime=dom.player.currentTime;videodb.updateMetadata(video.name,video.metadata);completeHidingPlayer();}}
function playerEnded(){if(dragging){return;}
if(endedTimer){clearTimeout(endedTimer);endedTimer=null;}
dom.player.currentTime=0;pause();}
function play(){dom.play.classList.remove('paused');VideoStats.start(dom.player);dom.player.play();playing=true;}
function pause(){dom.play.classList.add('paused');dom.player.pause();playing=false;VideoStats.stop();VideoStats.dump();}
function timeUpdated(){if(controlShowing){if(dom.player.duration===Infinity||dom.player.duration===0){return;}
updateVideoControlSlider();}
if(!endedTimer){if(!dragging&&dom.player.currentTime>=dom.player.duration-1){var timeUntilEnd=(dom.player.duration-dom.player.currentTime+.5);endedTimer=setTimeout(playerEnded,timeUntilEnd*1000);}}else if(dragging&&dom.player.currentTime<dom.player.duration-1){clearTimeout(endedTimer);endedTimer=null;}}
function handleSliderTouchEnd(event){if(!event.changedTouches.identifiedTouch(touchStartID)){return;}
touchStartID=null;if(!dragging){return;}
dragging=false;dom.playHead.classList.remove('active');if(dom.player.currentTime===dom.player.duration){pause();}else if(!isPausedWhileDragging){dom.player.play();}}
function handleSliderTouchMove(event){if(!dragging){return;}
var touch=event.changedTouches.identifiedTouch(touchStartID);if(!touch){return;}
var pos=(touch.clientX-sliderRect.left)/sliderRect.width;pos=Math.max(pos,0);pos=Math.min(pos,1);var percent=pos*100+'%';dom.playHead.classList.add('active');dom.playHead.style.left=percent;dom.elapsedTime.style.width=percent;dom.player.currentTime=dom.player.duration*pos;dom.elapsedText.textContent=MediaUtils.formatDuration(dom.player.currentTime);}
function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});}
function releaseVideo(){if(dom.player.readyState>0){restoreTime=dom.player.currentTime;}
dom.player.removeAttribute('src');dom.player.load();}
function restoreVideo(){function doneRestoreSeeking(){dom.player.onseeked=null;dom.player.hidden=false;}
dom.player.hidden=true;setVideoUrl(dom.player,currentVideo,function(){VideoUtils.fitContainer(dom.videoContainer,dom.player,currentVideo.metadata.rotation||0);if(restoreTime!==null){dom.player.currentTime=restoreTime;}else{dom.player.currentTime=currentVideo.metadata.currentTime||0;}
if(dom.player.seeking){dom.player.onseeked=doneRestoreSeeking;}else{doneRestoreSeeking();}});}
function showPickView(){thumbnailList.setPickMode(true);document.body.classList.add('pick-activity');dom.pickerClose.addEventListener('click',cancelPick);if(!isPhone&&!isPortrait){thumbnailList.upateAllThumbnailTitle();}}
function cancelPick(){pendingPick.postError('pick cancelled');cleanupPick();}
function cleanupPick(){pendingPick=null;currentVideoBlob=null;hidePlayer(false);}
function showThrobber(){dom.throbber.classList.remove('hidden');dom.throbber.classList.add('throb');}
function hideThrobber(){dom.throbber.classList.add('hidden');dom.throbber.classList.remove('throb');}