;'use strict';(function(exports){var BASE_TYPES=new Set(['text','url','email','password','number','option']);var SETTINGS_KEYS={ENABLED:'keyboard.enabled-layouts',DEFAULT:'keyboard.default-layouts',THIRD_PARTY_APP_ENABLED:'keyboard.3rd-party-app.enabled'};var DEPRECATE_KEYBOARD_SETTINGS={en:'keyboard.layouts.english','en-Dvorak':'keyboard.layouts.dvorak',cs:'keyboard.layouts.czech',fr:'keyboard.layouts.french',de:'keyboard.layouts.german',hu:'keyboard.layouts.hungarian',nb:'keyboard.layouts.norwegian',my:'keyboard.layouts.myanmar',sl:'keyboard.layouts.slovak',tr:'keyboard.layouts.turkish',ro:'keyboard.layouts.romanian',ru:'keyboard.layouts.russian',ar:'keyboard.layouts.arabic',he:'keyboard.layouts.hebrew','zh-Hant-Zhuyin':'keyboard.layouts.zhuyin','zh-Hans-Pinyin':'keyboard.layouts.pinyin',el:'keyboard.layouts.greek','jp-kanji':'keyboard.layouts.japanese',pl:'keyboard.layouts.polish','pt-BR':'keyboard.layouts.portuguese',sr:'keyboard.layouts.serbian',es:'keyboard.layouts.spanish',ca:'keyboard.layouts.catalan'};var MULTI_LAYOUT_MAP={sr:['sr-Cyrl','sr-Latn']};var defaultKeyboardManifestURL='app://keyboard.gaiamobile.org/manifest.webapp';if(location.protocol==='http:'){defaultKeyboardManifestURL='http://keyboard.gaiamobile.org:8080/manifest.webapp';}
var currentSettings={defaultLayouts:{}};currentSettings.defaultLayouts[defaultKeyboardManifestURL]={en:true,number:true};currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);var enable3rdPartyKeyboardApps=true;var regExpGaiaKeyboardAppsManifestURL=/^(app|http):\/\/[\w\-]+\.gaiamobile.org(:\d+)?\/manifest\.webapp$/;function map2dIs(manifestURL,layoutId){return!!(this[manifestURL]&&this[manifestURL][layoutId]);}
function map2dSet(manifestURL,layoutId){if(!this[manifestURL]){this[manifestURL]={};}
this[manifestURL][layoutId]=true;}
function map2dUnset(manifestURL,layoutId){if(!this[manifestURL]){return;}
delete this[manifestURL][layoutId];if(!Object.keys(this[manifestURL]).length){delete this[manifestURL];}}
function map2dClone(obj){var result={};for(var key1 in obj){result[key1]={};for(var key2 in obj[key1]){result[key1][key2]=obj[key1][key2];}}
return result;}
var watchQueries=[];var currentApps;var defaultLayoutConfig;function kh_updateWatchers(reason){if(watchQueries.length){KeyboardHelper.getApps(function withApps(){watchQueries.forEach(function eachWatchQuery(watch){KeyboardHelper.getLayouts(watch.query,function withLayouts(layouts){watch.callback(layouts,reason);});});});}}
var waitingForSettings=[];var loadedSettings=new Set();function kh_loadedSetting(setting){loadedSettings.add(setting);if(loadedSettings.size>=Object.keys(SETTINGS_KEYS).length){waitingForSettings.forEach(function(callback){callback();});waitingForSettings=[];kh_updateWatchers({settings:true});}}
function kh_withSettings(callback){if(loadedSettings.size>=Object.keys(SETTINGS_KEYS).length){callback();}else{waitingForSettings.push(callback);}}
function kh_getSettings(){loadedSettings=new Set();var lock=window.navigator.mozSettings.createLock();lock.get(SETTINGS_KEYS.DEFAULT).onsuccess=kh_parseDefault;lock.get(SETTINGS_KEYS.ENABLED).onsuccess=kh_parseEnabled;lock.get(SETTINGS_KEYS.THIRD_PARTY_APP_ENABLED).onsuccess=kh_parse3rdPartyAppEnabled;}
function kh_parse3rdPartyAppEnabled(){var value=this.result[SETTINGS_KEYS.THIRD_PARTY_APP_ENABLED];if(typeof value==='boolean'){enable3rdPartyKeyboardApps=value;}else{enable3rdPartyKeyboardApps=true;}
kh_loadedSetting(SETTINGS_KEYS.THIRD_PARTY_APP_ENABLED);}
function kh_parseDefault(){var value=this.result[SETTINGS_KEYS.DEFAULT];if(value){currentSettings.defaultLayouts=value;}
kh_loadedSetting(SETTINGS_KEYS.DEFAULT);}
function kh_parseEnabled(){var value=this.result[SETTINGS_KEYS.ENABLED];var needsSave=false;if(!value){currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);needsSave=true;}else{var type=typeof value;if(type==='string'){try{currentSettings.enabledLayouts={};var oldSettings=JSON.parse(value);oldSettings.forEach(function(layout){if(layout.enabled){var manifestURL=layout.manifestURL;if(!manifestURL)
manifestURL=layout.appOrigin+'/manifest.webapp';map2dSet.call(currentSettings.enabledLayouts,manifestURL,layout.layoutId);}});}catch(e){currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);needsSave=true;}}else{currentSettings.enabledLayouts=value;}}
kh_loadedSetting(SETTINGS_KEYS.ENABLED);if(needsSave){KeyboardHelper.saveToSettings();}}
function kh_migrateDeprecatedSettings(deprecatedSettings){var settingEntry=DEPRECATE_KEYBOARD_SETTINGS['en'];if(deprecatedSettings[settingEntry]==undefined){return;}
currentSettings.enabledLayouts[defaultKeyboardManifestURL]={number:true};var hasEnabledLayout=false;for(var key in DEPRECATE_KEYBOARD_SETTINGS){settingEntry=DEPRECATE_KEYBOARD_SETTINGS[key];if(deprecatedSettings[settingEntry]){hasEnabledLayout=true;if(key in MULTI_LAYOUT_MAP){MULTI_LAYOUT_MAP[key].forEach(function enableLayout(layoutId){map2dSet.call(currentSettings.enabledLayouts,defaultKeyboardManifestURL,layoutId);});}else{map2dSet.call(currentSettings.enabledLayouts,defaultKeyboardManifestURL,key);}}}
if(!hasEnabledLayout){map2dSet.call(currentSettings.enabledLayouts,defaultKeyboardManifestURL,'en');}
var deprecatedSettingsQuery={};for(var key in DEPRECATE_KEYBOARD_SETTINGS){settingEntry=DEPRECATE_KEYBOARD_SETTINGS[key];deprecatedSettingsQuery[settingEntry]=null;}
window.navigator.mozSettings.createLock().set(deprecatedSettingsQuery);KeyboardHelper.saveToSettings();}
function kh_loadJSON(href,callback){if(!callback)
return;var xhr=new XMLHttpRequest();xhr.onerror=function(){console.error('Failed to fetch file: '+href,xhr.statusText);};xhr.onload=function(){callback(xhr.response);};xhr.open('GET',href,true);xhr.responseType='json';xhr.send();}
function kh_getMultiSettings(settings,callback){var results={};try{var lock=navigator.mozSettings.createLock();}
catch(e){console.warn('Exception in mozSettings.createLock():',e,'\nUsing default values');for(var p in settings)
results[p]=settings[p];callback(results);}
var settingNames=Object.keys(settings);var numSettings=settingNames.length;var numResults=0;for(var i=0;i<numSettings;i++){requestSetting(settingNames[i]);}
function requestSetting(name){try{var request=lock.get(name);}
catch(e){console.warn('Exception querying setting',name,':',e,'\nUsing default value');recordResult(name,settings[name]);return;}
request.onsuccess=function(){var value=request.result[name];if(value===undefined){value=settings[name];}
recordResult(name,value);};request.onerror=function(evt){console.warn('Error querying setting',name,':',evt.error);recordResult(name,settings[name]);};}
function recordResult(name,value){results[name]=value;numResults++;if(numResults===numSettings){callback(results);}}}
function KeyboardLayout(options){for(var key in options){this[key]=options[key];}}
Object.defineProperties(KeyboardLayout.prototype,{'default':{get:function kh_getLayoutIsDefault(){return map2dIs.call(currentSettings.defaultLayouts,this.app.manifestURL,this.layoutId);}},enabled:{get:function kh_getLayoutIsEnabled(){return map2dIs.call(currentSettings.enabledLayouts,this.app.manifestURL,this.layoutId);},set:function kh_setLayoutIsDefault(value){var method=value?map2dSet:map2dUnset;method.call(currentSettings.enabledLayouts,this.app.manifestURL,this.layoutId);}}});var kh_SettingsHelper={};Object.defineProperties(kh_SettingsHelper,{'default':{get:function(){return map2dClone(currentSettings.defaultLayouts);},set:function(value){currentSettings.defaultLayouts=map2dClone(value);},enumerable:true},'enabled':{get:function(){return map2dClone(currentSettings.enabledLayouts);},set:function(value){currentSettings.enabledLayouts=map2dClone(value);},enumerable:true}});var KeyboardHelper=exports.KeyboardHelper={settings:kh_SettingsHelper,init:function kh_init(){watchQueries=[];currentApps=undefined;var settings=window.navigator.mozSettings;if(settings){kh_getSettings();settings.addObserver(SETTINGS_KEYS.ENABLED,kh_getSettings);settings.addObserver(SETTINGS_KEYS.DEFAULT,kh_getSettings);var deprecatedSettingsQuery={};for(var key in DEPRECATE_KEYBOARD_SETTINGS){var settingEntry=DEPRECATE_KEYBOARD_SETTINGS[key];deprecatedSettingsQuery[settingEntry]=undefined;}
kh_getMultiSettings(deprecatedSettingsQuery,kh_migrateDeprecatedSettings);}
window.addEventListener('applicationinstall',this);window.addEventListener('applicationinstallsuccess',this);window.addEventListener('applicationuninstall',this);},handleEvent:function(event){currentApps=undefined;kh_updateWatchers({apps:true});},isKeyboardType:function kh_isKeyboardType(type){return BASE_TYPES.has(type);},setLayoutEnabled:function kh_setLayoutEnabled(manifestURL,layoutId,enabled){var method=enabled?map2dSet:map2dUnset;method.call(currentSettings.enabledLayouts,manifestURL,layoutId);},getLayoutEnabled:function kh_getLayoutEnabled(manifestURL,layoutId){return map2dIs.call(currentSettings.enabledLayouts,manifestURL,layoutId);},setLayoutIsDefault:function kh_setLayoutIsDefault(manifestURL,layoutId,enabled){var method=enabled?map2dSet:map2dUnset;method.call(currentSettings.defaultLayouts,manifestURL,layoutId);},getLayoutIsDefault:function kh_getLayoutIsDefault(manifestURL,layoutId){return map2dIs.call(currentSettings.defaultLayouts,manifestURL,layoutId);},checkDefaults:function kh_checkDefaults(callback){var layoutsEnabled=[];['text','url','number'].forEach(function eachType(type){var enabled;this.getLayouts({type:type,enabled:true},function(layouts){enabled=layouts.length;});if(!enabled){this.getLayouts({type:type,'default':true},function(layouts){if(layouts[0]){layouts[0].enabled=true;layoutsEnabled.push(layouts[0]);}});}},this);if(layoutsEnabled.length){if(callback){callback(layoutsEnabled);}}},saveToSettings:function ke_saveToSettings(){var toSet={};toSet[SETTINGS_KEYS.ENABLED]=currentSettings.enabledLayouts;toSet[SETTINGS_KEYS.DEFAULT]=currentSettings.defaultLayouts;window.navigator.mozSettings.createLock().set(toSet);},getApps:function kh_getApps(callback){if(!navigator.mozApps||!navigator.mozApps.mgmt){return;}
if(currentApps){return callback(currentApps);}
navigator.mozApps.mgmt.getAll().onsuccess=function onsuccess(event){var keyboardApps=event.target.result.filter(function filterApps(app){if(!app.manifest||'input'!==app.manifest.role){return;}
if(app.manifest.type!=='certified'&&app.manifest.type!=='privileged'){return;}
if(app.manifest.permissions&&!('input'in app.manifest.permissions)){return;}
if(!enable3rdPartyKeyboardApps&&!regExpGaiaKeyboardAppsManifestURL.test(app.manifestURL)){console.error('A 3rd-party keyboard app is installed but '+'the feature is not enabled in this build. '+'Manifest URL: '+app.manifestURL);return;}
if(app.origin==='app://system.gaiamobile.org'){return;}
if(!app.manifest.inputs){return;}
return true;});if(keyboardApps.length){Object.keys(currentSettings.enabledLayouts).concat(Object.keys(currentSettings.defaultLayouts)).forEach(function(manifestURL){if(!keyboardApps.some(function(app){return app.manifestURL===manifestURL;})){delete currentSettings.enabledLayouts[manifestURL];delete currentSettings.defaultLayouts[manifestURL];}});currentApps=keyboardApps;callback(keyboardApps);}};},getLayouts:function kh_getLayouts(options,callback){if(typeof options==='function'){callback=options;options={};}
function withApps(apps){var layouts=apps.reduce(function eachApp(result,app){var manifest=new ManifestHelper(app.manifest);for(var layoutId in manifest.inputs){var inputManifest=manifest.inputs[layoutId];if(!inputManifest.types){console.warn(app.manifestURL,layoutId,'did not declare type.');continue;}
var layout=new KeyboardLayout({app:app,manifest:manifest,inputManifest:inputManifest,layoutId:layoutId});if(options['default']&&!layout['default']){continue;}
if(options.enabled&&!layout.enabled){continue;}
if(options.type){options.type=[].concat(options.type);if(!options.type.some(function(type){return inputManifest.types.indexOf(type)!==-1;})){continue;}}
result.push(layout);}
if(options['default']){result.sort(function(a,b){return a.inputManifest.types.length-b.inputManifest.types.length;});}
return result;},[]);kh_withSettings(callback.bind(null,layouts));}
this.getApps(withApps);},stopWatching:function(){watchQueries=[];},watchLayouts:function(query,callback){if(typeof query==='function'){callback=query;query={};}
var watch={query:query,callback:callback};watchQueries.push(watch);this.getLayouts(query,function initialCall(layouts){watch.layouts=layouts;callback(layouts,{apps:true,settings:true});});},getDefaultLayoutConfig:function kh_getDefaultLayoutConfig(callback){if(!callback){return;}
if(defaultLayoutConfig){callback(defaultLayoutConfig);}else{var KEYBOARDS='/shared/resources/keyboard_layouts.json';kh_loadJSON(KEYBOARDS,function loadKeyboardLayouts(data){if(data){defaultLayoutConfig=data;callback(defaultLayoutConfig);}});}},changeDefaultLayouts:function kh_changeDefaultLayouts(language,reset){this.getDefaultLayoutConfig(function gotDefaultLayouts(keyboards){var newKbLayouts=keyboards.layout[language];var kbManifestURL=defaultKeyboardManifestURL;currentSettings.defaultLayouts={};var langIndependentLayouts=keyboards.langIndependentLayouts;for(var i=langIndependentLayouts.length-1;i>=0;i--){this.setLayoutIsDefault(kbManifestURL,langIndependentLayouts[i].layoutId,true);}
if(reset){currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);}
for(i=newKbLayouts.length-1;i>=0;i--){this.setLayoutIsDefault(kbManifestURL,newKbLayouts[i].layoutId,true);this.setLayoutEnabled(kbManifestURL,newKbLayouts[i].layoutId,true);}
this.saveToSettings();}.bind(this));}};KeyboardHelper.init();}(window));;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media)
continue;window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;'use strict';var Normalizer={initAsciiNormalizer:function normalizer_init(){var equivalentChars={'a':'áăǎâäȧạȁàảȃāąåḁⱥãǽǣæ','A':'ÁĂǍÂÄȦẠȀÀẢȂĀĄÅḀȺÃǼǢÆ','b':'ḃḅɓḇƀƃ','B':'ḂḄƁḆɃƂ','c':'ćčçĉċƈȼ','C':'ĆČÇĈĊƇȻ','d':'ďḑḓḋḍɗḏđƌð','D':'ĎḐḒḊḌƊḎĐƋ','e':'éĕěȩêḙëėẹȅèẻȇēę','E':'ÉĔĚȨÊḘËĖẸȄÈẺȆĒĘ','f':'ḟƒ','F':'ḞƑ','g':'ǵğǧģĝġɠḡǥ','G':'ǴĞǦĢĜĠƓḠǤ','h':'ḫȟḩĥⱨḧḣḥħ','H':'ḪȞḨĤⱧḦḢḤĦ','i':'íĭǐîïịȉìỉȋīįɨĩḭı','I':'ÍĬǏÎÏỊȈÌỈȊĪĮƗĨḬ','j':'ĵɉ','J':'ĴɈ','k':'ḱǩķⱪꝃḳƙḵꝁ','K':'ḰǨĶⱩꝂḲƘḴꝀ','l':'ĺƚľļḽḷⱡꝉḻŀɫł','L':'ĹȽĽĻḼḶⱠꝈḺĿⱢŁ','m':'ḿṁṃɱ','M':'ḾṀṂⱮ','n':'ńňņṋṅṇǹɲṉƞñ','N':'ŃŇŅṊṄṆǸƝṈȠÑ','o':'óŏǒôöȯọőȍòỏơȏꝋꝍōǫøõœ','O':'ÓŎǑÔÖȮỌŐȌÒỎƠȎꝊꝌŌǪØÕŒ','p':'ṕṗꝓƥᵽꝑ','P':'ṔṖꝒƤⱣꝐ','q':'ꝗ','Q':'Ꝗ','r':'ŕřŗṙṛȑȓṟɍɽ','R':'ŔŘŖṘṚȐȒṞɌⱤ','s':'śšşŝșṡṣß$','S':'ŚŠŞŜȘṠṢ','t':'ťţṱțⱦṫṭƭṯʈŧ','T':'ŤŢṰȚȾṪṬƬṮƮŦ','u':'úŭǔûṷüṳụűȕùủưȗūųůũṵ','U':'ÚŬǓÛṶÜṲỤŰȔÙỦƯȖŪŲŮŨṴ','v':'ṿʋṽ','V':'ṾƲṼ','w':'ẃŵẅẇẉẁⱳ','W':'ẂŴẄẆẈẀⱲ','x':'ẍẋ','X':'ẌẊ','y':'ýŷÿẏỵỳƴỷỿȳɏỹ','Y':'ÝŶŸẎỴỲƳỶỾȲɎỸ','z':'źžẑⱬżẓȥẕƶ','Z':'ŹŽẐⱫŻẒȤẔƵ'};this._toAsciiForm={};for(var letter in equivalentChars){var accentedForms=equivalentChars[letter];for(var i=accentedForms.length-1;i>=0;i--)
this._toAsciiForm[accentedForms[i]]=letter;}},toAscii:function normalizer_toAscii(str){if(!str||typeof str!='string')
return'';if(!this._toAsciiForm)
Normalizer.initAsciiNormalizer();var result='';for(var i=0,len=str.length;i<len;i++)
result+=this._toAsciiForm[str.charAt(i)]||str.charAt(i);return result;},escapeHTML:function normalizer_escapeHTML(str,escapeQuotes){if(Array.isArray(str)){return Normalizer.escapeHTML(str.join(' '),escapeQuotes);}
if(!str||typeof str!='string')
return'';var escaped=str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');if(escapeQuotes)
return escaped.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return escaped;},escapeRegExp:function normalizer_escapeRegExp(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,'\\$&');}};;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
callback();},load:function(files,callback){if(!Array.isArray(files))
files=[files];var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file])
delete self._isLoading[file];self._loaded[file]=true;if(--loadsRemaining===0){if(callback)
callback();}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}}};return new LazyLoader();}());;'use strict';var Basket={basketUrl:'https://basket.mozilla.org/news/subscribe/',newsletterId:'firefox-os',callback:null,xhr:null,itemId:'newsletter_email',errors:{NETWORK_FAILURE:1,INVALID_EMAIL:2,UNKNOWN_EMAIL:3,UNKNOWN_TOKEN:4,USAGE_ERROR:5,EMAIL_PROVIDER_AUTH_FAILURE:6,AUTH_ERROR:7,SSL_REQUIRED:8,INVALID_NEWSLETTER:9,INVALID_LANGUAGE:10,EMAIL_NOT_CHANGED:11,CHANGE_REQUEST_NOT_FOUND:12,UNKNOWN_ERROR:99},responseHandler:function b_responseHandler(){if(this.xhr.readyState===4){if(this.xhr.status===200){if(typeof this.callback==='function'){this.callback(null,JSON.parse(this.xhr.responseText));}}else{if(typeof this.callback==='function'){if(this.xhr.responseText){this.callback(JSON.parse(this.xhr.responseText));}else{this.callback('Unknown error');}}}}},timeoutHandler:function b_timeoutHandler(){this.callback('Timeout');},send:function b_send(email,callback){var self=this;var params='email='+encodeURIComponent(email)+'&newsletters='+self.newsletterId;self.callback=callback;self.xhr=new XMLHttpRequest({mozSystem:true});self.xhr.onreadystatechange=self.responseHandler.bind(self);self.xhr.open('POST',self.basketUrl,true);self.xhr.setRequestHeader('Content-type','application/x-www-form-urlencoded');self.xhr.setRequestHeader('Connection','close');self.xhr.timeout=5000;self.xhr.ontimeout=self.timeoutHandler.bind(self);self.getLanguage(function do_send(language){if(language){params+='&lang='+language;}
self.xhr.setRequestHeader('Content-length',params.length);self.xhr.send(params);});},store:function b_store(email,callback){window.asyncStorage.setItem(this.itemId,email,function stored(){if(callback){callback();}});},getLanguage:function b_getLanguage(callback){var settings=window.navigator.mozSettings;if(!settings||!settings.createLock){callback();return;}
var s_name='language.current';var req=settings.createLock().get(s_name);req.onsuccess=function _onsuccess(){callback(req.result[s_name]);};req.onerror=function _onerror(){console.error('Error getting setting: '+s_name);callback();};}};;'use strict';var utils=window.utils||{};if(!utils.sdcard){var SdCard=utils.sdcard={NOT_INITIALIZED:0,NOT_AVAILABLE:1,AVAILABLE:2,observers:{}};SdCard.status=SdCard.NOT_INITIALIZED;SdCard.deviceStorage=navigator.getDeviceStorage('sdcard');SdCard.updateStorageState=function sd_updateStorageState(state){switch(state){case'available':SdCard.status=SdCard.AVAILABLE;break;case'shared':case'unavailable':case'deleted':SdCard.status=SdCard.NOT_AVAILABLE;break;}
Object.keys(this.observers).forEach(function onObserver(name){if(typeof(SdCard.observers[name])==='function'){SdCard.observers[name].call(null,state);}});};if(SdCard.deviceStorage){SdCard.deviceStorage.addEventListener('change',function sd_deviceStorageChangeHandler(e){SdCard.updateStorageState(e.reason);});if(SdCard.status===SdCard.NOT_INITIALIZED){SdCard.deviceStorage.available().onsuccess=(function(e){SdCard.updateStorageState(e.target.result);});}}
SdCard.checkStorageCard=function sd_checkStorageCard(){return SdCard.status===SdCard.AVAILABLE;};SdCard.retrieveFiles=function retrieveFilesContent(mimes,exts,cb){var storage=navigator.getDeviceStorage('sdcard');var fileArray=[];var cursor=storage.enumerate();cursor.onsuccess=function(e){var file=e.target.result;if(!file){cb(null,fileArray);}else{if((mimes.indexOf(file.type)===-1)&&file.name.search(new RegExp('.('+exts.join('|')+')$'))===-1){cursor.continue();}else{fileArray.push(file);cursor.continue();}}};cursor.onerror=function(){cb(this.error.name);};};SdCard.getTextFromFiles=function(fileArray,contents,cb){contents=contents||'';if(!fileArray||!fileArray.length){return cb&&cb(null,contents);}
var reader=new FileReader();reader.onload=function onloaded(){contents+=reader.result+'\n';SdCard.getTextFromFiles(fileArray,contents,cb);};try{reader.readAsText(fileArray.shift());}
catch(ex){window.console.error('Problem reading file: ',ex.stack);SdCard.getTextFromFiles(fileArray,contents,cb);}};SdCard.subscribeToChanges=function(name,func,force){if(this.observers[name]!==undefined&&!force){return false;}
this.observers[name]=func;return true;};SdCard.unsubscribeToChanges=function(name){if(this.observers[name]){delete this.observers[name];return true;}else{return false;}};};'use strict';var utils=window.utils||{};utils.status=(function(){var STATUS_TIME=2000;var statusMsg=document.querySelector('#statusMsg');var hidingTimeout;var hideAnimationDone=function(){statusMsg.removeEventListener('transitionend',hideAnimationDone);statusMsg.classList.add('hidden');};var showAnimationDone=function(){statusMsg.removeEventListener('transitionend',showAnimationDone);hidingTimeout=setTimeout(hideStatus,STATUS_TIME);};var hideStatus=function(){statusMsg.classList.remove('opening');statusMsg.classList.remove('bannerStart');statusMsg.addEventListener('transitionend',hideAnimationDone);};var showStatus=function(text){statusMsg.removeEventListener('transitionend',showAnimationDone);statusMsg.removeEventListener('transitionend',hideAnimationDone);LazyLoader.load([statusMsg],function _loaded(){statusMsg.querySelector('p').textContent=text;if(statusMsg.classList.contains('opening')){clearTimeout(hidingTimeout);hidingTimeout=setTimeout(hideStatus,STATUS_TIME);return;}
statusMsg.classList.remove('hidden');setTimeout(function displaying(){statusMsg.classList.add('opening');statusMsg.classList.add('bannerStart');statusMsg.addEventListener('transitionend',showAnimationDone);},0);});};return{show:showStatus};})();;'use strict';var utils=window.utils||{};(function(){utils.overlay={};var overlay=document.querySelector('#loading-overlay'),statusContainer=overlay.querySelector('p[role="status"]'),progressActivity=document.querySelector('#progress-activity'),progressTitle=document.querySelector('#progress-title'),progressElement=document.querySelector('#progress-element'),progressMsg=document.querySelector('#progress-msg'),menu=document.querySelector('#loading-overlay menu'),cancelButton=document.querySelector('#cancel-overlay');function ProgressBar(pMsgId,pClass){var counter=0;var total=0;var progressTextId=pMsgId||'genericProgress';var clazz=pClass;progressElement.setAttribute('value',0);function showMessage(){progressMsg.textContent=_(progressTextId,{current:counter,total:total});}
this.update=function(value){if(value&&value<=total&&value>=counter){counter=value;progressElement.setAttribute('value',(counter*100)/total);}else{progressElement.setAttribute('value',(++counter*100)/total);}
showMessage();};this.setTotal=function(ptotal){total=ptotal;};this.setClass=function(clazzName){setClass(clazzName);clazz=clazzName;if(clazzName==='activityBar'||clazzName==='spinner'){progressMsg.textContent=null;}};this.setHeaderMsg=function(headerMsg){progressTitle.textContent=headerMsg;};}
utils.overlay.isAnimationPlaying=false;utils.overlay.isShown=false;utils.overlay._show=function _show(message,progressClass,textId){progressActivity.classList.remove('hide');progressTitle.textContent=message;progressMsg.textContent=null;if(utils.overlay.isShown){return;}
overlay.classList.remove('hide');overlay.classList.remove('fade-out');overlay.classList.add('fade-in');utils.overlay.isAnimationPlaying=true;overlay.addEventListener('animationend',function ov_onFadeIn(ev){utils.overlay.isAnimationPlaying=false;overlay.removeEventListener('animationend',ov_onFadeIn);overlay.classList.remove('no-opacity');utils.overlay.isShown=true;});};utils.overlay.show=function show(message,progressClass,textId){var out;out=new ProgressBar(textId,progressClass);setClass(progressClass);utils.overlay.hideMenu();if(!utils.overlay.isAnimationPlaying){utils.overlay._show(message,progressClass,textId);return out;}
overlay.addEventListener('animationend',function ov_showWhenFinished(ev){overlay.removeEventListener('animationend',ov_showWhenFinished);utils.overlay._show(message,progressClass,textId);});return out;};utils.overlay.showMenu=function showMenu(){menu.classList.add('showed');};utils.overlay.hideMenu=function hideMenu(){menu.classList.remove('showed');};Object.defineProperty(utils.overlay,'oncancel',{set:function(cancelCb){if(typeof cancelCb==='function'){cancelButton.onclick=function on_cancel(e){delete cancelButton.onclick;cancelCb();return false;};}}});function setAsProgress(){statusContainer.classList.remove('loading-icon');progressElement.setAttribute('max','100');progressElement.setAttribute('value','0');}
function setClass(clazzName){switch(clazzName){case'spinner':progressElement.classList.remove('pack-activity');statusContainer.classList.add('loading-icon');progressElement.removeAttribute('max');progressElement.removeAttribute('value');break;case'activityBar':case'progressActivity':progressElement.classList.add('pack-activity');setAsProgress();break;case'progressBar':progressElement.classList.remove('pack-activity');setAsProgress();break;}}
utils.overlay._hide=function ov__hide(){if(!utils.overlay.isShown){return;}
overlay.classList.remove('fade-in');overlay.classList.add('fade-out');utils.overlay.isAnimationPlaying=true;overlay.addEventListener('animationend',function ov_onFadeOut(ev){utils.overlay.isAnimationPlaying=false;overlay.removeEventListener('animationend',ov_onFadeOut);progressActivity.classList.add('hide');overlay.classList.add('no-opacity');overlay.classList.add('hide');utils.overlay.isShown=false;});};utils.overlay.hide=function ov_hide(){if(!utils.overlay.isAnimationPlaying){utils.overlay._hide();return;}
overlay.addEventListener('animationend',function ov_hideWhenFinished(ev){overlay.removeEventListener('animationend',ov_hideWhenFinished);utils.overlay._hide();});};})();;'use strict';var FTU_APP_ORIGIN=document.location.protocol+'//'+
document.location.host;var ServicesLauncher=(function(document){var extensionFrame=document.querySelector('#fb-extensions');var oauthFrame=document.querySelector('#fb-oauth');var BASE_IMPORT='/contacts/import.html?ftu=1';function getServiceURI(service){return BASE_IMPORT+'&service='+service;}
var access_token,currentURI,currentService;function open(){extensionFrame.className='opening';}
function load(targetService){currentService=targetService;currentURI=getServiceURI(targetService);window.addEventListener('message',messageHandler);oauthFrame.contentWindow.postMessage({type:'start',data:{from:'friends',service:targetService}},FTU_APP_ORIGIN);}
function unload(){window.removeEventListener('message',messageHandler);extensionFrame.src=null;}
function close(message){extensionFrame.addEventListener('transitionend',function tclose(){extensionFrame.removeEventListener('transitionend',tclose);extensionFrame.src=null;if(message){utils.status.show(message);}});extensionFrame.className='closing';window.removeEventListener('message',messageHandler);if(currentService==='facebook'){var event=new CustomEvent('fb_imported',{'detail':true});document.dispatchEvent(event);}}
function messageHandler(e){if(e.origin!==FTU_APP_ORIGIN){return;}
var data=e.data;switch(data.type){case'ready':open();break;case'abort':unload();break;case'window_close':close(data.message);break;case'authenticated':extensionFrame.src=currentURI;access_token=data.data;break;case'messaging_ready':extensionFrame.contentWindow.postMessage({type:'token',data:access_token},FTU_APP_ORIGIN);break;}}
return{start:load};})(document);;'use strict';var utils=window.utils||{};if(typeof utils.config==='undefined'){(function(){var config=utils.config={};var loading={};var loaded={};var pendingRequests={};config.load=function(resource){var outReq=new LoadRequest();var data=loaded[resource];if(data){window.setTimeout(function(){outReq.completed(data);},0);}
else{var requests=pendingRequests[resource];if(!Array.isArray(requests)){pendingRequests[resource]=requests=[];}
requests.push(outReq);var isLoading=loading[resource];if(!isLoading){loading[resource]=true;window.setTimeout(function do_load(){var xhr=new XMLHttpRequest();xhr.overrideMimeType('application/json');xhr.open('GET',resource,true);xhr.onreadystatechange=function(){if(xhr.readyState===4&&(xhr.status===200||xhr.status===0)){var response=xhr.responseText;var configuration=JSON.parse(response);loaded[resource]=configuration;delete loading[resource];requests.forEach(function(aRequest){aRequest.completed(configuration);});delete pendingRequests[resource];}
else if(xhr.readyState===4){requests.forEach(function(aRequest){aRequest.failed(xhr.status);});delete pendingRequests[resource];}};xhr.send(null);},0);}}
return outReq;};function LoadRequest(){this.completed=function(configData){if(typeof this.onload==='function'){this.onload(configData);}};this.failed=function(code){if(typeof this.onerror==='function'){this.onerror(code);}};}})();};'use strict';var VCFReader=(function _VCFReader(){var ReBasic=/^([^:]+):(.+)$/;var ReTuple=/([a-zA-Z]+)=(.+)/;var DEFAULT_PHONE_TYPE='other';var VCARD_SIMPLE_TYPES={'fax':'faxOther','faxother':'faxOther','home':'home','internet':'internet','cell':'mobile','pager':'pager','personal':'home','pref':'pref','text':'text','textphone':'textphone','voice':'voice','work':'work'};var VCARD_COMPLEX_TYPES={'fax,work':'faxOffice','fax,home':'faxHome','voice,work':'work','voice,home':'home'};function _parseTuple(p){var match=p.match(ReTuple);return match?[match[1].toLowerCase(),match[2]]:['type',p];}
function _parseLine(line){var parsed=ReBasic.exec(line);if(!parsed){return null;}
var tuples=parsed[1].split(/[;,]/);var key=tuples.shift();var meta={type:[]};var len=tuples.length;for(var i=0;i<len;i++){var tuple=_parseTuple(tuples[i]);if(tuple[0]==='type'){meta.type.push(tuple[1]);}else{meta[tuple[0]]=tuple[1];}}
var value=/[^\s;]/.test(parsed[2])?parsed[2].split(';'):[];return{key:key.toLowerCase(),data:{meta:meta,value:value}};}
var _parseEntries=function(cardArray,cb){var parsedCards=[];for(var i=0;i<cardArray.length;i++){var lines=cardArray[i];if(!lines){parsedCards.push(null);continue;}
var fields={};var len=lines.length;for(var j=0;j<len;j++){var line=lines[j];var parsedLine=_parseLine(line);if(!parsedLine){continue;}
if(!fields[parsedLine.key]){fields[parsedLine.key]=[];}
fields[parsedLine.key].push(parsedLine.data);}
if(!fields.fn&&!fields.n){parsedCards.push(null);continue;}
parsedCards.push(vcardToContact(fields));}
cb(parsedCards);};var qpRegexp=/=([a-zA-Z0-9]{2})/g;var _decodeQuoted=function(str){return decodeURIComponent(str.replace(qpRegexp,'%$1'));};function _decodeQP(metaObj,value){var isQP=metaObj&&metaObj.encoding&&(/quoted-printable/i).test(metaObj.encoding);if(isQP){value=_decodeQuoted(value);}
return value;}
var NAME_PARTS=['familyName','givenName','additionalName','honorificPrefix','honorificSuffix'];function _processName(vcardObj,contactObj){if(vcardObj.fn&&vcardObj.fn.length){var fnMeta=vcardObj.fn[0].meta;var fnValue=vcardObj.fn[0].value[0];contactObj.name=[_decodeQP(fnMeta,fnValue)];}
if(vcardObj.n&&vcardObj.n.length){var values=vcardObj.n[0].value;var meta=vcardObj.n[0].meta;for(var i=0;i<values.length;i++){var namePart=values[i];if(namePart&&NAME_PARTS[i]){contactObj[NAME_PARTS[i]]=[_decodeQP(meta,namePart)];}}
if(!contactObj.name){contactObj.name=[_decodeQP(meta,values.join(' ').trim())];}}
contactObj.givenName=contactObj.givenName||contactObj.name;return contactObj;}
var ADDR_PARTS=[null,null,'streetAddress','locality','region','postalCode','countryName'];function _processAddr(vcardObj,contactObj){if(!vcardObj.adr){return contactObj;}
contactObj.adr=[];for(var i=0;i<vcardObj.adr.length;i++){var cur={};var adr=vcardObj.adr[i];if(adr.meta&&adr.meta.type){cur.type=adr.meta.type;}
for(var j=2;j<adr.value.length;j++){cur[ADDR_PARTS[j]]=_decodeQP(adr.meta,adr.value[j]);}
contactObj.adr.push(cur);}
return contactObj;}
function _processComm(vcardObj,contactObj){contactObj.tel=[];['tel','email','url'].forEach(function field2field(field){if(!vcardObj[field]){return;}
var len=vcardObj[field].length,hasTypeMapper=function(x){return x.trim().toLowerCase();},notTypeMapper=function(v,key){return v.meta[key].trim().toLowerCase();},noType=function(field){return field!=='type';},noPref=function(field){return field!=='pref';},typeFilter=function(metaValue){return!!VCARD_SIMPLE_TYPES[metaValue];};for(var i=0;i<len;i++){var v=vcardObj[field][i];var metaValues;var cur={};if(v.meta){if(v.value){cur.value=_decodeQP(v.meta,v.value[0]);cur.value=cur.value.replace(/^tel:/i,'');}
if(v.meta.type){metaValues=([].slice.call(v.meta.type)).map(hasTypeMapper);}else{metaValues=Object.keys(v.meta).filter(noType).map(notTypeMapper.bind(null,v));}
if(metaValues.indexOf('pref')!==-1){cur.pref=true;metaValues=metaValues.filter(noPref);}
switch(metaValues.length){case 0:cur.type=[DEFAULT_PHONE_TYPE];break;case 1:cur.type=[VCARD_SIMPLE_TYPES[metaValues[0]]||DEFAULT_PHONE_TYPE];break;case 2:var complexType1=metaValues[0]+','+metaValues[1];var complexType2=metaValues[1]+','+metaValues[0];cur.type=[VCARD_COMPLEX_TYPES[complexType1]||VCARD_COMPLEX_TYPES[complexType2]||VCARD_SIMPLE_TYPES[metaValues[0]]||VCARD_SIMPLE_TYPES[metaValues[1]]||DEFAULT_PHONE_TYPE];break;default:cur.type=[VCARD_SIMPLE_TYPES[metaValues.filter(typeFilter).shift()]||DEFAULT_PHONE_TYPE];}}
if(!contactObj[field]){contactObj[field]=[];}
contactObj[field].push(cur);}});return contactObj;}
function _isValidDate(dateValue){return!isNaN(Date.parse(dateValue));}
function _processFields(vcardObj,contactObj){['org','title','bday','anniversary'].forEach(function(field){if(!vcardObj[field]){return;}
var v=vcardObj[field][0];var dateValue;if(field==='bday'){dateValue=v.value[0];if(_isValidDate(dateValue)){contactObj.bday=new Date(dateValue);}
return;}
if(field==='anniversary'){dateValue=v.value[0];if(_isValidDate(dateValue)){contactObj.anniversary=new Date(dateValue);}
return;}
if(!v){return;}
if(field==='title'){field='jobTitle';}
switch(typeof v){case'object':contactObj[field]=[_decodeQP(v.meta,v.value[0])];break;case'string':contactObj[field]=[v];break;}});return contactObj;}
var vcardToContact=function(vcard){if(!vcard){return null;}
var obj={};_processName(vcard,obj);_processAddr(vcard,obj);_processComm(vcard,obj);_processFields(vcard,obj);return utils.misc.toMozContact(obj);};var VCFReader=function(contents){this.contents=contents;this.processed=0;this.finished=false;this.currentChar=0;};VCFReader.CONCURRENCY=5;VCFReader.prototype.finish=function(){this.finished=true;};VCFReader.prototype.process=function(cb){var match=this.contents.match(/end:vcard/gi);if(!match){if(cb){cb();}
return;}
this.total=match.length;this.onread&&this.onread(this.total);this.ondone=cb;LazyLoader.load(['/shared/js/simple_phone_matcher.js','/contacts/js/utilities/misc.js','/contacts/js/contacts_matcher.js','/contacts/js/contacts_merger.js','/contacts/js/utilities/image_thumbnail.js','/contacts/js/merger_adapter.js'],function(){this.splitLines();}.bind(this));};VCFReader.prototype.onParsed=function(err,ct){this.processed+=1;this.onimported&&this.onimported(ct&&ct.name);if(this.finished||this.processed===this.total){this.ondone(this.total);return;}
var processed=this.processed;if(processed<this.total&&processed%VCFReader.CONCURRENCY===0){this.splitLines();}};VCFReader.prototype.post=function(contactObjects){var _onParsed=this.onParsed.bind(this);var cursor=0;function afterSave(ct,e){_onParsed(e,ct);cursor+=1;if(cursor<contactObjects.length){saveContact(contactObjects[cursor]);}}
function saveContact(ct){if(!ct){afterSave(null,null);return;}
var contact=utils.misc.toMozContact(ct);var afterSaveFn=afterSave.bind(null,contact);var matchCbs={onmatch:function(matches){var callbacks={success:afterSaveFn,error:afterSaveFn};contacts.adaptAndMerge(contact,matches,callbacks);},onmismatch:function(){VCFReader._save(contact,afterSaveFn);}};contacts.Matcher.match(contact,'passive',matchCbs);}
saveContact(contactObjects[cursor]);};VCFReader._save=function(item,cb){var req=navigator.mozContacts.save(utils.misc.toMozContact(item));req.onsuccess=cb;req.onerror=cb;};var reBeginCard=/begin:vcard$/i;var reEndCard=/end:vcard$/i;var reVersion=/^VERSION:/i;VCFReader.prototype.splitLines=function(){var currentLine='';var inLabel=false;var multiline=false;var cardArray=[[]];var cardsProcessed=0;var i=this.currentChar;var callPost=this.post.bind(this);for(var l=this.contents.length;i<l;i++){this.currentChar=i;var ch=this.contents[i];if(ch==='"'){inLabel=!inLabel;currentLine+=ch;continue;}
if(multiline===true){if(ch===' '||ch==='\t'||ch==='\r'||ch==='\n'){continue;}else{multiline=false;}}
var next=this.contents[i+1];if(inLabel||(ch!=='\n'&&ch!=='\r')){if(ch==='='&&next&&next.search(/(\r|\n)/)!==-1){multiline=true;continue;}
currentLine+=ch;if(i!==l-1){continue;}}
if(next&&(next===' '||next==='\t')){multiline=true;continue;}
if(reBeginCard.test(currentLine)){currentLine='';continue;}
if(reEndCard.test(currentLine)){cardsProcessed+=1;if(cardsProcessed===VCFReader.CONCURRENCY||(cardsProcessed+this.processed)===this.total){_parseEntries(cardArray,callPost);break;}
currentLine='';cardArray.push([]);continue;}
if(currentLine&&!reVersion.test(currentLine)){cardArray[cardArray.length-1].push(currentLine);}
currentLine='';}};VCFReader._decodeQuoted=_decodeQuoted;VCFReader.processAddr=_processAddr;VCFReader.processName=_processName;VCFReader.vcardToContact=vcardToContact;return VCFReader;})();;'use strict';var utils=window.utils||{};if(!utils.misc){utils.misc={};utils.misc.toMozContact=function ut_toMozContact(contact){var outContact=contact;if(!(contact instanceof mozContact)){outContact=new mozContact(contact);outContact.id=contact.id||outContact.id;}
return outContact;};utils.misc.formatDate=function formatDate(date){var FLAG_YEAR_IGNORED=9996;var _=navigator.mozL10n.get;var dateFormat=_('dateFormat')||'%B %e';var f=new navigator.mozL10n.DateTimeFormat();var dateString=null;try{var offset=date.getTimezoneOffset()*60*1000;var normalizedDate=new Date(date.getTime()+offset);var year=normalizedDate.getFullYear();if(year===FLAG_YEAR_IGNORED){year='';}
var dayMonthString=f.localeFormat(normalizedDate,dateFormat);dateString=_('dateOutput',{dayMonthFormatted:dayMonthString,year:year});}catch(err){console.error('Error parsing date: ',err);throw err;}
return dateString;};utils.misc.parseName=function parseName(nameString){var MIN_LENGHT_SIGNIFICATIVE=3;var MIN_LENGHT_FN=2;var out={givenName:'',familyName:''};if(!nameString){return out;}
var str=nameString.trim();if(!str){return out;}
function startsWithUpper(str){var firstLetter=str.charAt(0);var capFirstLetter=firstLetter.toLocaleUpperCase();return(capFirstLetter===firstLetter);}
var tokens=nameString.split(/\s+/);var significativeTokens={};for(var j=0;j<tokens.length;j++){var token=tokens[j];if(token.length>MIN_LENGHT_SIGNIFICATIVE||startsWithUpper(token)){significativeTokens[token]=true;}}
var totalTokens=tokens.length;var lastToken=totalTokens-1;var rolePrevToken;var remainingTokens=Object.keys(significativeTokens).length;var outGivenNames=[],outFamilyNames=[];var numFns=0;while(lastToken>=0){if(significativeTokens[tokens[lastToken]]){remainingTokens--;}
var currToken=tokens[lastToken],nextToken=tokens[lastToken+1],prevToken=tokens[lastToken-1];if(!nextToken&&prevToken){outFamilyNames.push(currToken);numFns++;rolePrevToken='FN';}
else if(!prevToken){outGivenNames.push(currToken);rolePrevToken='GN';}
else if(nextToken){if(!significativeTokens[currToken]){if(rolePrevToken==='FN'){outFamilyNames.push(currToken);}
else{outGivenNames.push(currToken);}}
else if(currToken.length<MIN_LENGHT_FN){outGivenNames.push(currToken);rolePrevToken='GN';}
else{if(remainingTokens>=2&&numFns<2){outFamilyNames.push(currToken);numFns++;rolePrevToken='FN';}
else{outGivenNames.push(currToken);rolePrevToken='GN';}}}
lastToken--;}
out.givenName=outGivenNames.reverse().join(' ').trim();out.familyName=outFamilyNames.reverse().join(' ').trim();return out;};};'use strict';var fb=this.fb||{};this.fb=fb;fb.utils=this.fb.utils||{};this.fb.utils=fb.utils;if(typeof fb.utils.Request!=='function'){fb.utils.Request=function(){this.done=function(result){this.result=result;if(typeof this.onsuccess==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onsuccess(ev);}.bind(this),0);}};this.failed=function(error){this.error=error;if(typeof this.onerror==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onerror(ev);}.bind(this),0);}};};};'use strict';var fb=window.fb||{};(function(){var contacts=fb.contacts||{};fb.contacts=contacts;var Reader;var readerLoaded=false;var INDEX_ID=1;var isIndexDirty=false;var READER_LOADED_EV='reader_loaded';var TEL_INDEXER_JS='/shared/js/fb/fb_tel_index.js';var PHONE_MATCHER_JS='/shared/js/simple_phone_matcher.js';var FB_READER_JS='/shared/js/fb/fb_data_reader.js';var BINARY_SEARCH_JS='/shared/js/binary_search.js';contacts.UID_NOT_FOUND='UIDNotFound';contacts.ALREADY_EXISTS='AlreadyExists';if(!contacts.init){var proxyMethods=['get','getLength','getByPhone','search','refresh','init','restart'];proxyMethods.forEach(function(aMethod){contacts[aMethod]=defaultFunction.bind(null,aMethod);});LazyLoader.load(FB_READER_JS,onreaderLoaded);}
else{onreaderLoaded();}
function onreaderLoaded(){readerLoaded=true;Reader=fb.contacts;document.dispatchEvent(new CustomEvent(READER_LOADED_EV));}
function setIndex(index){Reader.dsIndex=index;isIndexDirty=false;}
function datastore(){return Reader.datastore;}
function index(){return Reader.dsIndex;}
function defaultFunction(target){var args=[];for(var j=1;j<arguments.length;j++){args.push(arguments[j]);}
if(!readerLoaded){document.addEventListener(READER_LOADED_EV,function rd_loaded(){document.removeEventListener(READER_LOADED_EV,rd_loaded);Reader[target].apply(this,args);});}
else{Reader[target].apply(this,args);}}
function initError(outRequest,error){outRequest.failed(error);}
function safeError(err){if(err&&err.name){return err;}
return{name:'UnknownError'};}
function defaultError(request){return defaultErrorCb.bind(null,request);}
function defaultSuccess(request){return defaultSuccessCb.bind(null,request);}
function defaultErrorCb(request,error){request.failed(safeError(error));}
function defaultSuccessCb(request,result){request.done(result);}
function doSave(obj,outRequest){LazyLoader.load([TEL_INDEXER_JS,PHONE_MATCHER_JS,BINARY_SEARCH_JS],function(){var uid=obj.uid;datastore().add(obj,uid).then(function success(){indexByPhone(obj,uid);isIndexDirty=true;outRequest.done();},function error(err){if(err.name==='ConstraintError'){err={name:contacts.ALREADY_EXISTS};}
outRequest.failed(err);});});}
function indexByPhone(obj,newId){if(Array.isArray(obj.tel)){obj.tel.forEach(function(aTel){var variants=SimplePhoneMatcher.generateVariants(aTel.value);variants.forEach(function(aVariant){index().byTel[aVariant]=newId;});TelIndexer.index(index().treeTel,aTel.value.substring(1),newId);});}}
function reIndexByPhone(oldObj,newObj,dsId){removePhoneIndex(oldObj);indexByPhone(newObj,dsId);TelIndexer.orderTree(index().treeTel);}
function removePhoneIndex(deletedFriend){if(Array.isArray(deletedFriend.tel)){deletedFriend.tel.forEach(function(aTel){TelIndexer.remove(index().treeTel,aTel.value.substring(1));var variants=SimplePhoneMatcher.generateVariants(aTel.value);variants.forEach(function(aVariant){delete index().byTel[aVariant];});});}}
contacts.save=function(obj){var retRequest=new fb.utils.Request();window.setTimeout(function save(){contacts.init(function(){doSave(obj,retRequest);},function(err){initError(retRequest,err);});},0);return retRequest;};contacts.update=function(obj){var retRequest=new fb.utils.Request();window.setTimeout(function save(){contacts.init(function(){doUpdate(obj,retRequest);},function(err){initError(retRequest,err);});},0);return retRequest;};function doUpdate(obj,outRequest){LazyLoader.load([TEL_INDEXER_JS,PHONE_MATCHER_JS,BINARY_SEARCH_JS],function(){var uid=obj.uid;var successCb=successUpdate.bind(null,outRequest);var errorCb=errorUpdate.bind(null,outRequest,uid);datastore().get(uid).then(function success(oldObj){if(!oldObj){errorCb({name:contacts.UID_NOT_FOUND});return;}
reIndexByPhone(oldObj,obj,uid);datastore().put(obj,uid).then(function success(){return datastore().put(index(),INDEX_ID);},errorCb).then(successCb,errorCb);},errorCb);});}
function successUpdate(outRequest){outRequest.done();}
function errorUpdate(outRequest,uid,error){window.console.error('Error while updating datastore for: ',uid);outRequest.failed(error);}
function doRemove(uid,outRequest,forceFlush){LazyLoader.load([TEL_INDEXER_JS,PHONE_MATCHER_JS,BINARY_SEARCH_JS],function(){var errorCb=errorRemove.bind(null,outRequest,uid);var objToDelete;datastore().get(uid).then(function success_get_remove(object){objToDelete=object;if(!objToDelete){errorRemove(outRequest,uid,{name:contacts.UID_NOT_FOUND});return;}
datastore().remove(uid).then(function success_rm(removed){successRemove(outRequest,objToDelete,forceFlush,removed);},errorCb);},errorCb);});}
function successRemove(outRequest,deletedFriend,forceFlush,removed){if(removed===true){isIndexDirty=true;removePhoneIndex(deletedFriend);if(forceFlush){var flushReq=fb.contacts.flush();flushReq.onsuccess=function(){isIndexDirty=false;outRequest.done(true);};flushReq.onerror=function(){outRequest.failed(flushReq.error);};}
else{outRequest.done(true);}}
else{outRequest.done(false);}}
function errorRemove(outRequest,uid,error){error=safeError(error);window.console.error('FB Data: Error while removing ',uid,': ',error.name);outRequest.failed(error);}
contacts.remove=function(uid,flush){var hasToFlush=(flush===true?flush:false);var retRequest=new fb.utils.Request();window.setTimeout(function remove(){contacts.init(function(){doRemove(uid,retRequest,hasToFlush);},function(err){initError(retRequest,err);});},0);return retRequest;};contacts.clear=function(){var outRequest=new fb.utils.Request();window.setTimeout(function clear(){contacts.init(function(){doClear(outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doClear(outRequest){datastore().clear().then(function success(){setIndex(null);datastore().put(index(),INDEX_ID).then(defaultSuccess(outRequest),function error(err){err=safeError(err);window.console.error('Error while re-creating the index: ',err.name);outRequest.failed(err);});},defaultError(outRequest));}
contacts.flush=function(){var outRequest=new fb.utils.Request();window.setTimeout(function do_Flush(){if(!(datastore())||!isIndexDirty){window.console.warn('The datastore has not been initialized or is not dirty');outRequest.done();return;}
TelIndexer.orderTree(index().treeTel);datastore().put(index(),INDEX_ID).then(defaultSuccess(outRequest),defaultError(outRequest));},0);return outRequest;};})();;'use strict';var fb=window.fb||{};window.fb=fb;(function(document){var Utils=fb.utils||{};fb.utils=Utils;var TIMEOUT_QUERY=fb.operationsTimeout;var FRIEND_COUNT_QUERY='select friend_count from user where uid=me()';var CACHE_FRIENDS_KEY=Utils.CACHE_FRIENDS_KEY='numFacebookFriends';var LAST_UPDATED_KEY=Utils.LAST_UPDATED_KEY='lastUpdatedTime';Utils.ALARM_ID_KEY='nextAlarmId';var REDIRECT_LOGOUT_URI=window.oauthflow?oauthflow.params.facebook['redirectLogout']:'';var STORAGE_KEY=Utils.TOKEN_DATA_KEY='tokenData';Utils.setLastUpdate=function(value,cb){window.asyncStorage.setItem(LAST_UPDATED_KEY,{data:value},cb);};Utils.getLastUpdate=function(callback){window.asyncStorage.getItem(LAST_UPDATED_KEY,function(obj){var out=0;if(obj){out=obj.data||out;}
if(typeof callback==='function'){callback(out);}});};Utils.getContactData=function(cid){var outReq=new Utils.Request();var req=navigator.mozContacts.find({filterBy:['id'],filterValue:cid,filterOp:'equals'});req.onsuccess=function(e){if(e.target.result&&e.target.result.length>0){outReq.done(e.target.result[0]);}
else{outReq.done(null);}};req.onerror=function(e){outReq.failed(e.target.error);};return outReq;};Utils.getMozContact=function(uid){var outReq=new Utils.Request();window.setTimeout(function get_mozContact_ByUid(){fb.getMozContactByUid(uid,function onsuccess(result){if(Array.isArray(result)&&result.length>0){outReq.done(result[0]);}else{outReq.done(null);}},function onerror(e){outReq.failed(e.target.error);});},0);return outReq;};Utils.getNumberMozContacts=function(uid){var outReq=new Utils.Request();window.setTimeout(function get_mozContact_ByUid(){fb.getMozContactByUid(uid,function onsuccess(result){if(Array.isArray(result)){outReq.done(result.length);}else{outReq.done(0);}},function onerror(e){outReq.failed(error);});},0);return outReq;};Utils.getAllFbContacts=function(){var outReq=new Utils.Request();window.setTimeout(function get_all_fb_contacts(){var filter={filterValue:fb.CATEGORY,filterOp:'contains',filterBy:['category']};var req=navigator.mozContacts.find(filter);req.onsuccess=function(e){outReq.done(e.target.result);};req.onerror=function(e){outReq.failed(e.target.error);};},0);return outReq;};Utils.getNumFbContacts=function(){var outReq=new Utils.Request();window.setTimeout(function get_num_fb_contacts(){var req=fb.contacts.getLength();req.onsuccess=function(){outReq.done(req.result);};req.onerror=function(){outReq.failed(req.error);};},0);return outReq;};Utils.getNumFbFriends=function(callback,access_token){fb.utils.runQuery(FRIEND_COUNT_QUERY,callback,access_token);};Utils.getCachedAccessToken=function(callback){window.asyncStorage.getItem(STORAGE_KEY,function(data){var out=null;if(data){out=data.access_token||null;}
if(typeof callback==='function'){callback(out);}});};Utils.getCachedNumFbFriends=function(callback){window.asyncStorage.getItem(CACHE_FRIENDS_KEY,function(data){if(typeof callback==='function'&&typeof data==='number'){callback(data);}});};Utils.setCachedNumFriends=function(value){window.asyncStorage.setItem(CACHE_FRIENDS_KEY,value);};Utils.getImportChecked=function(callback){Utils.getCachedAccessToken(function(access_token){var out='logged-out';if(access_token){out='logged-in';}
else{Utils.getCachedNumFbFriends(function(value){if(value){out='renew-pwd';if(typeof callback==='function'){callback(out);}}});}
if(typeof callback==='function'){callback(out);}});};Utils.numFbFriendsData=function(callback){var localCb=callback.local;var remoteCb=callback.remote;Utils.getCachedNumFbFriends(localCb);function auxCallback(response){if(response.data&&response.data[0]&&response.data[0].friend_count){remoteCb(response.data[0].friend_count);}}
if(typeof remoteCb==='function'&&navigator.onLine===true){var remoteCallbacks={success:auxCallback,error:null,timeout:null};Utils.getCachedAccessToken(function(access_token){if(access_token){Utils.getNumFbFriends(remoteCallbacks,access_token);}});}};Utils.clearFbData=function(){var outReq=new Utils.Request();window.setTimeout(function do_clearFbData(){var ireq=fb.contacts.clear();ireq.onsuccess=function(){var req=Utils.getAllFbContacts();req.onsuccess=function(){var cleaner=new Utils.FbContactsCleaner(req.result,'clear');outReq.done(cleaner);window.setTimeout(cleaner.start,0);};req.onerror=function(){window.console.error('FB Clean. Error retrieving FB Contacts');outReq.failed(req.error);};};ireq.onerror=function(e){window.console.error('Error while clearing the FB Cache');outReq.failed(ireq.error);};},0);return outReq;};Utils.logout=function(){var outReq=new Utils.Request();window.setTimeout(function do_logout(){Utils.getCachedAccessToken(function getAccessToken(access_token){if(access_token){var logoutService='https://www.facebook.com/logout.php?';var params=['next'+'='+encodeURIComponent(REDIRECT_LOGOUT_URI),'access_token'+'='+access_token];var logoutParams=params.join('&');var logoutUrl=logoutService+logoutParams;var m_listen=function(e){if(e.origin!==fb.CONTACTS_APP_ORIGIN){return;}
if(e.data==='closed'){window.asyncStorage.removeItem(STORAGE_KEY);outReq.done();}
e.stopImmediatePropagation();window.removeEventListener('message',m_listen);};window.addEventListener('message',m_listen);window.open(logoutUrl);}
else{outReq.done();}});},0);return outReq;};Utils.FbContactsCleaner=function(contacts,pmode){this.lcontacts=contacts;var total=contacts.length;var next=0;var self=this;var CHUNK_SIZE=5;var numResponses=0;var mode=pmode||'update';var mustUpdate=(pmode==='update');var notifyClean=false;var mustHold=false;var holded=false;var mustFinish=false;this.start=function(){mustHold=holded=mustFinish=false;if(total>0){cleanContacts(0);}
else if(typeof self.onsuccess==='function'){window.setTimeout(self.onsuccess);}};this.hold=function(){mustHold=true;};this.finish=function(){mustFinish=true;if(holded){notifySuccess();}};this.resume=function(){mustHold=holded=mustFinish=false;window.setTimeout(function resume_clean(){cleanContacts(next);});};function successHandler(e){if(notifyClean||typeof self.oncleaned==='function'){notifyClean=true;var cleaned=e.target.number;window.setTimeout(function(){self.oncleaned(cleaned);},0);}
continueCb();}
function errorHandler(contactid,error){if(typeof self.onerror==='function'){self.onerror(contactid,error);}
continueCb();}
function cleanContacts(from){for(var idx=from;idx<(from+CHUNK_SIZE)&&idx<total;idx++){var contact=contacts[idx];var number=idx;var req;if(fb.isFbLinked(contact)){var fbContact=new fb.Contact(contact);req=fbContact.unlink('hard');}
else{if(mustUpdate){var fbContact=new fb.Contact(contact);req=fbContact.remove();}
else{var req=navigator.mozContacts.remove(utils.misc.toMozContact(contact));}}
req.number=number;req.onsuccess=successHandler;req.onerror=function(e){errorHandler(contact.id,e.target.error);};}}
function notifySuccess(){if(typeof self.onsuccess==='function'){window.setTimeout(self.onsuccess);}}
function finishHandler(){var req=fb.contacts.flush();req.onsuccess=notifySuccess;req.onerror=function cleaner_flushError(){errorHandler(null,req.error);};}
function continueCb(){next++;numResponses++;if(next<total&&numResponses===CHUNK_SIZE){numResponses=0;if(!mustHold&&!mustFinish){cleanContacts(next);}
else if(mustFinish&&!holded){finishHandler();}
if(mustHold){holded=true;}}
else if(next>=total){finishHandler();}}};})(document);;'use strict';var fb=this.fb||{};var self=this;fb.utils=this.fb.utils||{};fb.DEFAULT_TIMEOUT=30000;fb.utils.runQuery=function(query,callback,access_token){function QueryRequest(){this.cancel=function(){if(typeof this.oncancel==='function'){window.setTimeout(function(){this.oncancel();}.bind(this),0);}};}
var outReq=new QueryRequest();var queryService='https://graph.facebook.com/fql?q=';queryService+=encodeURIComponent(query);var params=['access_token'+'='+access_token,'format=json'];var queryParams=params.join('&');var remote=queryService+'&'+queryParams;var xhr=new XMLHttpRequest({mozSystem:true});outReq.xhr=xhr;outReq.oncancel=function(){this.xhr.abort();};xhr.open('GET',remote,true);xhr.responseType='json';xhr.timeout=fb.operationsTimeout||fb.DEFAULT_TIMEOUT;xhr.onload=function(e){if(xhr.status===200||xhr.status===400||xhr.status===0){if(callback&&typeof callback.success==='function')
self.setTimeout(function(){callback.success(xhr.response);},0);}
else{self.console.error('FB: HTTP error executing query. ',query,' Status: ',xhr.status);if(callback&&typeof callback.error==='function')
self.setTimeout(callback.error,0);}};xhr.ontimeout=function(e){self.console.error('FB: Timeout!!! while executing query',query);if(callback&&typeof callback.timeout==='function')
self.setTimeout(callback.timeout,0);};xhr.onerror=function(e){self.console.error('FB: Error while executing query: ',query,': ',e);if(callback&&typeof callback.error==='function')
self.setTimeout(function(){callback.error(e);},0);};xhr.send();return outReq;};fb.utils.getFriendPicture=function(uid,callback,access_token,targetPictureSize){var imgSrc='https://graph.facebook.com/'+uid+'/picture?';var params=['width='+targetPictureSize,'access_token'+'='+access_token];var imgService=imgSrc+params.join('&');var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',imgService,true);xhr.responseType='blob';xhr.timeout=fb.operationsTimeout||fb.DEFAULT_TIMEOUT;xhr.onload=function(e){if(xhr.status===200||xhr.status===0){var mblob=e.target.response;if(typeof callback==='function')
self.setTimeout(function(){callback(mblob);},0);}
else{self.console.error('FB: HTTP error retrieving img for uid: ',uid,' Status: ',xhr.status);if(typeof callback==='function')
self.setTimeout(function(){callback(null);},0);}};xhr.ontimeout=function(e){self.console.error('FB: Timeout!!! while retrieving img for uid: ',uid);if(typeof callback==='function')
self.setTimeout(function(){callback(null);},0);};xhr.onerror=function(e){self.console.error('FB: Error while retrieving img for uid: ',uid,'Error: ',e);if(typeof callback==='function'){self.setTimeout(function(){callback(null);},0);}};xhr.send();};;'use strict';var fb=this.fb||{};this.fb=fb;if(!this.AuxFB){this.AuxFb=(function(){var CATEGORY='facebook';var NOT_LINKED='not_linked';var LINKED='fb_linked';function populate(source,target,propertyNames){propertyNames.forEach(function(property){var propertyValue=source[property];if(propertyValue){if(Array.isArray(propertyValue)){target[property]=propertyValue.slice(0,propertyValue.length);}else{target[property]=propertyValue;}}});}
function mergeFbData(dcontact,fbdata){var multipleFields=['email','tel','photo','org','adr'];multipleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=[];}
var items=fbdata[field];if(items){items.forEach(function(item){var dupList=checkDuplicates(field,item,dcontact[field],fbdata.shortTelephone);if(dupList.length===0){dcontact[field].push(item);}});}});var singleFields=['bday','anniversary'];singleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=fbdata[field];}});mergeNames(dcontact,fbdata);}
function mergeNames(devContact,fbContact){var namesChanged=false;var nameFields=['givenName','familyName'];nameFields.forEach(function(anameField){var fieldValue=devContact[anameField];var fbValue=fbContact[anameField];if((!Array.isArray(fieldValue)||fieldValue.length===0)&&Array.isArray(fbValue)&&fbValue.length>0){namesChanged=true;devContact[anameField]=(fieldValue&&fieldValue[0])||[];devContact[anameField].push(fbValue[0]);}});if(namesChanged){var givenName=devContact.givenName[0]||'';var familyName=devContact.familyName[0]||'';devContact.name=[givenName+' '+familyName];}}
function isFbContact(devContact){return(devContact&&devContact.category&&devContact.category.indexOf(CATEGORY)!==-1);}
function isFbLinked(devContact){return(devContact.category&&devContact.category.indexOf(LINKED)!==-1);}
function getData(devContact){var outReq=new fb.utils.Request();window.setTimeout(function do_getData(){var uid=getFriendUid(devContact);if(uid){var fbreq=fb.contacts.get(uid);fbreq.onsuccess=function(){var fbdata=fbreq.result;var out=mergeContact(devContact,fbdata);outReq.done(out);};fbreq.onerror=function(){outReq.failed(fbreq.error);};}
else{outReq.done(devContact);}},0);return outReq;}
function getFriendUid(devContact){var out=devContact.uid;if(!out){if(isFbLinked(devContact)){out=getLinkedTo(devContact);}
else if(devContact.category){var idx=devContact.category.indexOf(CATEGORY);if(idx!==-1){out=devContact.category[idx+2];}}}
return out;}
function getLinkedTo(devContact){var out;if(devContact.category){var idx=devContact.category.indexOf(LINKED);if(idx!==-1){out=devContact.category[idx+1];}}
return out;}
function mergeContact(devContact,fbContact){var out=devContact;if(fbContact){out=Object.create(null);out.updated=devContact.updated;out.published=devContact.published;populate(devContact,out,Object.getOwnPropertyNames(devContact));populate(devContact,out,Object.getOwnPropertyNames(Object.getPrototypeOf(devContact)));mergeFbData(out,fbContact);}
return out;}
function getContactByNumber(number,onsuccess,onerror){var req=fb.contacts.getByPhone(number);req.onsuccess=function get_by_phone_success(e){var fbData=req.result;if(fbData){fb.getMozContactByUid(fbData.uid,function merge(result){if(Array.isArray(result)&&result[0]){var finalContact=fb.mergeContact(result[0],fbData);onsuccess(finalContact);}
else{onsuccess(null);}},function error_get_mozContact(err){console.error('Error getting mozContact: ',err.name);onerror(err);});}
else{onsuccess(null);}};req.onerror=function(){onerror(req.error);};}
function checkDuplicates(field,fbItem,devContactItems,extraFbItems){var potentialDuplicatesFields=['email','tel'];var out=[];if(devContactItems&&potentialDuplicatesFields.indexOf(field)!==-1){var total=devContactItems.length;for(var i=0;i<total;i++){var localValue=devContactItems[i].value;var fbValue=fbItem.value;if(localValue){var trimedLocal=localValue.trim();if(trimedLocal===fbValue||(field==='tel'&&Array.isArray(extraFbItems)&&extraFbItems.indexOf(trimedLocal)!==-1)){out.push(trimedLocal);out.push(fbValue);}}}}
return out;}
function getMozContactByUid(uid,onsuccess,onerror){var filter={filterBy:['category'],filterValue:uid,filterOp:'contains'};var req=navigator.mozContacts.find(filter);req.onsuccess=function(){onsuccess(req.result);};req.onerror=function(){onerror(req.error);};}
return{'isFbContact':isFbContact,'isFbLinked':isFbLinked,'getData':getData,'getFriendUid':getFriendUid,'getLinkedTo':getLinkedTo,'mergeContact':mergeContact,'getContactByNumber':getContactByNumber,'getMozContactByUid':getMozContactByUid,'checkDuplicates':checkDuplicates,get CATEGORY(){return CATEGORY;},get LINKED(){return LINKED;},get NOT_LINKED(){return NOT_LINKED;}};})();var props=Object.keys(this.AuxFb);var self=this;for(var j=0,end=props.length;j<end;j++){var prop=props[j];if(typeof self.fb[prop]==='function'){self.fb[prop]=self.AuxFb[prop];}
else{Object.defineProperty(self.fb,prop,{value:(function(){return self.AuxFb[prop];})(),writable:false,enumerable:true,configurable:false});}}};'use strict';var fb=this.fb||{};fb.PROPAGATED_PREFIX='fb_propagated_';fb.PROFILE_PHOTO_URI='fb_profile_photo';fb.FRIEND_URI='fb_friend';fb.DEFAULT_PHONE_TYPE='other';fb.DEFAULT_EMAIL_TYPE='other';fb.FLAG_YEAR_IGNORED=9996;fb.CONTACTS_APP_ORIGIN=location.origin;fb.isPropagated=function fcu_isPropagated(field,devContact){return(devContact.category&&devContact.category.indexOf(fb.PROPAGATED_PREFIX+field)!==-1);};fb.removePropagatedFlag=function fcu_removePropagatedFlag(field,devContact){var idx=devContact.category.indexOf(fb.PROPAGATED_PREFIX+field);if(idx!==-1){devContact.category.splice(idx,1);}};fb.setPropagatedFlag=function fcu_setPropagatedFlag(field,devContact){var idx=devContact.category.indexOf(fb.PROPAGATED_PREFIX+field);if(idx===-1){devContact.category.push(fb.PROPAGATED_PREFIX+field);}};fb.getFriendPictureUrl=function(devContact){var out;var urls=devContact.url;if(urls){for(var c=0;c<urls.length;c++){var aurl=urls[c];if(aurl.type.indexOf(fb.PROFILE_PHOTO_URI)!==-1){out=aurl.value;break;}}}
return out;};fb.setFriendPictureUrl=function(devContact,url){var urls=devContact.url||[];urls.push({type:[fb.PROFILE_PHOTO_URI],value:url});devContact.url=urls;};fb.friend2mozContact=function(f){function normalizeFbPhoneNumber(phone){var out=phone.number;if(phone.country_code&&out.indexOf('+')!==0){out='+'+phone.country_code+out;}
return out;}
if(Array.isArray(f.familyName)){return f;}
f.familyName=[f.last_name?f.last_name.trim():(f.last_name||'')];var middleName=f.middle_name?f.middle_name.trim():(f.middle_name||'');f.additionalName=middleName;var firstName=f.first_name?f.first_name.trim():(f.first_name||'');f.givenName=[(firstName+' '+middleName).trim()];delete f.last_name;delete f.middle_name;delete f.first_name;if(f.email){f.email1=f.email;f.email=[{type:[fb.DEFAULT_EMAIL_TYPE],value:f.email}];}
else{f.email1='';}
if(Array.isArray(f.phones)&&f.phones.length>0){f.tel=[];f.shortTelephone=[];f.phones.forEach(function(aphone){f.tel.push({type:[fb.DEFAULT_PHONE_TYPE],value:normalizeFbPhoneNumber(aphone)});f.shortTelephone.push(aphone.number);});}
delete f.phones;f.uid=f.uid.toString();return f;};fb.getWorksAt=function(fbdata){var out='';if(fbdata.work&&fbdata.work.length>0){out=fbdata.work[0].employer.name;}
return out;};fb.getBirthDate=function getBirthDate(sbday){var out=new Date(0);var imonth=sbday.indexOf('/');var smonth=sbday.substring(0,imonth);var iyear=sbday.lastIndexOf('/');if(iyear===imonth){iyear=sbday.length;}
var sday=sbday.substring(imonth+1,iyear);var syear=sbday.substring(iyear+1,sbday.length);out.setUTCDate(parseInt(sday,10));out.setUTCMonth(parseInt(smonth,10)-1,parseInt(sday,10));if(syear&&syear.length>0){out.setUTCFullYear(parseInt(syear,10));}
else{out.setUTCFullYear(fb.FLAG_YEAR_IGNORED);}
out.setUTCHours(0);out.setUTCMinutes(0);out.setUTCSeconds(0);out.setUTCMilliseconds(0);return out;};fb.getAddresses=function(fbdata){function fillAddress(fbAddress,type){var outAddr={};outAddr.type=[type];outAddr.locality=fbAddress.city||'';outAddr.region=fbAddress.state||'';outAddr.countryName=fbAddress.country||'';return outAddr;}
var out=[];var addrTypes={'home':'hometown_location','current':'current_location'};Object.keys(addrTypes).forEach(function onAddressType(type){var addrObj=fbdata[addrTypes[type]];if(addrObj){out.push(fillAddress(addrObj,type));}});return out;};fb.markAsUnlinked=function(devContact){var category=devContact.category;var updatedCategory=[];if(category){var idx=category.indexOf(fb.CATEGORY);if(idx!==-1){for(var c=0;c<idx;c++){updatedCategory.push(category[c]);}
for(var c=idx+3;c<category.length;c++){updatedCategory.push(category[c]);}}}
devContact.category=updatedCategory;return devContact;};;'use strict';this.asyncStorage=(function(){var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error("asyncStorage: can't open database:",openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var MobileOperator={BRAZIL_MCC:'724',BRAZIL_CELLBROADCAST_CHANNEL:50,userFacingInfo:function mo_userFacingInfo(mobileConnection){var network=mobileConnection.voice.network;var iccid=mobileConnection.iccId;var iccObj=navigator.mozIccManager.getIccById(iccid);var iccInfo=iccObj?iccObj.iccInfo:null;var operator=network?(network.shortName||network.longName):null;if(operator&&iccInfo&&iccInfo.isDisplaySpnRequired&&iccInfo.spn&&!mobileConnection.voice.roaming){if(iccInfo.isDisplayNetworkNameRequired&&operator!==iccInfo.spn){operator=operator+' '+iccInfo.spn;}else{operator=iccInfo.spn;}}
var carrier,region;if(this.isBrazil(mobileConnection)){var lac=mobileConnection.voice.cell.gsmLocationAreaCode%100;var carriers=MobileInfo.brazil.carriers;var regions=MobileInfo.brazil.regions;carrier=carriers[network.mnc]||(this.BRAZIL_MCC+network.mnc);region=(regions[lac]?regions[lac]+' '+lac:'');}
return{'operator':operator,'carrier':carrier,'region':region};},isBrazil:function mo_isBrazil(mobileConnection){var cell=mobileConnection.voice.cell;var net=mobileConnection.voice.network;return net?(net.mcc===this.BRAZIL_MCC&&cell&&cell.gsmLocationAreaCode):null;}};var MobileInfo={brazil:{carriers:{'00':'NEXTEL','02':'TIM','03':'TIM','04':'TIM','05':'CLARO','06':'VIVO','07':'CTBC','08':'TIM','10':'VIVO','11':'VIVO','15':'SERCOMTEL','16':'OI','23':'VIVO','24':'OI','31':'OI','32':'CTBC','33':'CTBC','34':'CTBC','37':'AEIOU'},regions:{'11':'SP','12':'SP','13':'SP','14':'SP','15':'SP','16':'SP','17':'SP','18':'SP','19':'SP','21':'RJ','22':'RJ','24':'RJ','27':'ES','28':'ES','31':'MG','32':'MG','33':'MG','34':'MG','35':'MG','37':'MG','38':'MG','41':'PR','42':'PR','43':'PR','44':'PR','45':'PR','46':'PR','47':'SC','48':'SC','49':'SC','51':'RS','53':'RS','54':'RS','55':'RS','61':'DF','62':'GO','63':'TO','64':'GO','65':'MT','66':'MT','67':'MS','68':'AC','69':'RO','71':'BA','73':'BA','74':'BA','75':'BA','77':'BA','79':'SE','81':'PE','82':'AL','83':'PB','84':'RN','85':'CE','86':'PI','87':'PE','88':'CE','89':'PI','91':'PA','92':'AM','93':'PA','94':'PA','95':'RR','96':'AP','97':'AM','98':'MA','99':'MA'}}};;'use strict';(function(exports){var _iccManager=navigator.mozIccManager;var _iccProxy=null;Object.defineProperty(exports,'IccHelper',{configurable:true,get:function(){return _iccProxy;},set:function(value){_iccProxy=value;}});if(_iccManager&&_iccManager.getIccById){var activeIccObj=null;var eventListeners={};var cachedEventListeners={};var events=['cardstatechange','iccinfochange','stkcommand','stksessionend'];var getters=['iccInfo','cardState'];var methods=['sendStkResponse','sendStkMenuSelection','sendStkTimerExpiration','sendStkEventDownload'];var domRequests=['getCardLock','unlockCardLock','setCardLock','getCardLockRetryCount','readContacts','updateContact','iccOpenChannel','iccExchangeAPDU','iccCloseChannel'];var getterTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name];}else{return null;}};};var methodTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name].apply(activeIccObj,arguments);}};};var domRequestTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name].apply(activeIccObj,arguments);}else{throw new Error('The icc object is invalid');}};};var createIccProxy=function(){var iccProxy={addEventListener:function(eventName,callback){if(typeof callback!=='function')
return;if(events.indexOf(eventName)===-1)
return;var listeners=eventListeners[eventName];if(listeners==null){listeners=eventListeners[eventName]=[];}
if(listeners.indexOf(callback)===-1){listeners.push(callback);}},removeEventListener:function(eventName,callback){var listeners=eventListeners[eventName];if(listeners){var index=listeners.indexOf(callback);if(index!==-1){listeners.splice(index,1);}}}};getters.forEach(function(getter){Object.defineProperty(iccProxy,getter,{enumerable:true,get:getterTemplate(getter)});});methods.forEach(function(method){iccProxy[method]=methodTemplate(method);});domRequests.forEach(function(request){iccProxy[request]=methodTemplate(request);});events.forEach(function(eventName){Object.defineProperty(iccProxy,'on'+eventName,{enumerable:true,set:function(newListener){var oldListener=cachedEventListeners[eventName];if(oldListener){iccProxy.removeEventListener(eventName,oldListener);}
cachedEventListeners[eventName]=newListener;if(newListener){iccProxy.addEventListener(eventName,newListener);}},get:function(){return cachedEventListeners[eventName];}});});return iccProxy;};_iccProxy=createIccProxy();if(_iccManager.iccIds&&_iccManager.iccIds.length){activeIccObj=_iccManager.getIccById(_iccManager.iccIds[0]);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});}}
_iccManager.oniccdetected=function(event){if(_iccProxy.cardState==null){activeIccObj=_iccManager.getIccById(event.iccId);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});['cardstatechange','iccinfochange'].forEach(function(eventName){if(eventListeners[eventName]){eventListeners[eventName].forEach(function(listener){listener();});}});}}};}else{_iccProxy=_iccManager;}})(window);;'use strict';var WifiHelper={getWifiManager:function(){return this.wifiManager;},wifiManager:function(){return navigator.mozWifiManager;}(),setPassword:function(network,password,identity,eap,phase2,certificate){var encType=this.getKeyManagement(network);switch(encType){case'WPA-PSK':network.psk=password;break;case'WPA-EAP':network.eap=eap;switch(eap){case'SIM':break;case'PEAP':case'TLS':case'TTLS':if(password&&password.length){network.password=password;}
if(identity&&identity.length){network.identity=identity;}
if(phase2!='No'){network.phase2=phase2;}
if(certificate!='none'){network.serverCertificate=certificate;}
break;default:break;}
break;case'WEP':network.wep=password;break;default:return;}
network.keyManagement=encType;},setSecurity:function(network,encryptions){network.security=encryptions;},getSecurity:function(network){return network.security;},getCapabilities:function(network){return network.capabilities===undefined?[]:network.capabilities;},getKeyManagement:function(network){var key=this.getSecurity(network)[0];if(/WEP$/.test(key))
return'WEP';if(/PSK$/.test(key))
return'WPA-PSK';if(/EAP$/.test(key))
return'WPA-EAP';return'';},isConnected:function(network){var currentNetwork=this.wifiManager.connection.network;if(!currentNetwork||!network)
return false;var key=network.ssid+'+'+this.getSecurity(network).join('+');var curkey=currentNetwork.ssid+'+'+
this.getSecurity(currentNetwork).join('+');return key===curkey;},isValidInput:function(key,password,identity,eap){function isValidWepKey(password){switch(password.length){case 5:case 13:case 16:case 29:return true;case 10:case 26:case 32:case 58:return!/[^a-fA-F0-9]/.test(password);default:return false;}}
switch(key){case'WPA-PSK':if(!password||password.length<8)
return false;break;case'WPA-EAP':switch(eap){case'SIM':break;case'PEAP':case'TLS':case'TTLS':default:if(!password||password.length<1||!identity||identity.length<1)
return false;break;}
break;case'WEP':if(!password||!isValidWepKey(password))
return false;break;}
return true;},isWpsAvailable:function(network){var capabilities=this.getCapabilities(network);for(var i=0;i<capabilities.length;i++){if(/WPS/.test(capabilities[i])){return true;}}
return false;},isOpen:function(network){return this.getKeyManagement(network)==='';},isEap:function(network){return this.getKeyManagement(network).indexOf('EAP')!==-1;},_unionOfNetworks:function(available,known){var allNetworks=available||{};var result=[];Object.keys(known).forEach(function(key){if(!allNetworks[key])
allNetworks[key]=known[key];});Object.keys(allNetworks).forEach(function(key){result.push(allNetworks[key]);});return result;},_networksArrayToObject:function(allNetworks){var self=this;var networksObject={};[].forEach.call(allNetworks,function(network){var key=network.ssid+'+'+
self.getSecurity(network).join('+');networksObject[key]=network;});return networksObject;},_onReqProxySuccess:function(reqProxy,availableNetworks,knownNetworks){reqProxy.result=this._unionOfNetworks(availableNetworks,knownNetworks);reqProxy.onsuccess();},getAvailableAndKnownNetworks:function(){var self=this;var reqProxy={onsuccess:function(){},onerror:function(){}};var knownNetworks={};var availableNetworks={};var knownNetworksReq=null;var availableNetworksReq=this.getWifiManager().getNetworks();availableNetworksReq.onsuccess=function anrOnSuccess(){availableNetworks=self._networksArrayToObject(availableNetworksReq.result);knownNetworksReq=self.getWifiManager().getKnownNetworks();knownNetworksReq.onsuccess=function knrOnSuccess(){knownNetworks=self._networksArrayToObject(knownNetworksReq.result);self._onReqProxySuccess(reqProxy,availableNetworks,knownNetworks);};knownNetworksReq.onerror=function knrOnError(){self._onReqProxySuccess(reqProxy,availableNetworks,knownNetworks);};};availableNetworksReq.onerror=function anrOnError(){reqProxy.error=availableNetworksReq.error;reqProxy.onerror();};return reqProxy;}};;'use strict';var FxAccountsIACHelper=function FxAccountsIACHelper(){var DEFAULT_CONNECTION_STRING='fxa-mgmt';var default_rules={'manifestURLs':['app://system.gaiamobile.org/manifest.webapp']};var CONNECTION_STRING=DEFAULT_CONNECTION_STRING;var rules=default_rules;var port;var callbacks={};var eventListeners={};var init=function init(options){if(!options){return;}
if(options.keyword&&typeof(options.keyword)=='string'&&options.keyword.length>0){CONNECTION_STRING=options.keyword;}
if(options.rules&&typeof(options.rules)=='object'){rules=options.rules;}};var addEventListener=function addEventListener(eventName,listener){if(!eventListeners[eventName]){eventListeners[eventName]=[];}
eventListeners[eventName].push(listener);};var removeEventListener=function removeEventListener(eventName,listener){var listeners=eventListeners[eventName];if(!listeners){return;}
var index=listeners.indexOf(listener);if(index===-1){return;}
listeners.splice(index,1);};var reset=function reset(){CONNECTION_STRING=DEFAULT_CONNECTION_STRING;rules=default_rules;eventListeners={};callbacks={};};var onMessage=function onMessage(evt){if(evt&&evt.data){var message=evt.data;if(message.eventName){var listeners=eventListeners[message.eventName];if(!listeners){return;}
for(var listener in listeners){if(listeners[listener]&&typeof listeners[listener]==='function'){listeners[listener]();}}
return;}
var cbs;if(message.methodName){cbs=callbacks[message.methodName];if(!cbs){console.warn('No callbacks for method '+message.methodName);return;}}
if(typeof message.data!=='undefined'){cbs.successCb(message.data);}else{var errorType=message.error||'Unknown';cbs.errorCb(errorType);}}else{console.error('Unknown');}};var getSelf=function getSelf(cb,error){var request=navigator.mozApps.getSelf();request.onsuccess=function onSuccess(evt){cb(evt.target.result);};request.onerror=function onError(){if(error&&typeof(error)==='function'){error();}};};var connect=function connect(callback){getSelf(function onApp(app){if(!app){return;}
app.connect(CONNECTION_STRING,rules).then(function(ports){if(!ports||ports.length!==1){return;}
port=ports[0];callback&&callback();});});};var sendMessage=function sendMessage(message,successCb,errorCb){if(port){_sendMessage(message,successCb,errorCb);return;}
connect(function(){_sendMessage(message,successCb,errorCb);});};var _sendMessage=function _sendMessage(message,successCb,errorCb){var name=message.name;if(!name){return;}
if(!callbacks[name]){callbacks[name]={};}
callbacks[name].successCb=successCb;callbacks[name].errorCb=errorCb;port.onmessage=onMessage;port.postMessage(message);};var getAccounts=function getAccounts(successCb,errorCb){sendMessage({'name':'getAccounts'},successCb,errorCb);};var openFlow=function openFlow(successCb,errorCb){sendMessage({'name':'openFlow'},successCb,errorCb);};var logout=function logout(successCb,errorCb){sendMessage({'name':'logout'},successCb,errorCb);};var refreshAuthentication=function refreshAuthentication(accountId,successCb,errorCb){sendMessage({'name':'refreshAuthentication','accountId':accountId},successCb,errorCb);};connect();return{'addEventListener':addEventListener,'getAccounts':getAccounts,'init':init,'logout':logout,'openFlow':openFlow,'refreshAuthentication':refreshAuthentication,'removeEventListener':removeEventListener,'reset':reset};}();;'use strict';var SimManager=(function(){function Icc(mozIcc){this.mozIcc=mozIcc;}
Icc.prototype={skipped:false,unlocked:false,alreadyImported:false,mozIcc:null,isLocked:function(){return!this.unlocked&&lockStates.indexOf(this.mozIcc.cardState)!==-1;}};function showRetryCount(icc,lockType,uiElement){var request=icc.mozIcc.getCardLockRetryCount(lockType);request.onsuccess=function(){var retryCount=request.result.retryCount;if(retryCount){var l10nArgs={n:retryCount};uiElement.textContent=_('inputCodeRetriesLeft',l10nArgs);uiElement.classList.remove('hidden');}};request.onerror=function(){console.error('Could not fetch CardLockRetryCount',request.error.name);};}
var _;var lockStates=['pinRequired','pukRequired','networkLocked','corporateLocked','serviceProviderLocked'];return{icc0:null,icc1:null,simSlots:window.navigator.mozMobileConnections?window.navigator.mozMobileConnections.length:0,_unlockingIcc:null,init:function sm_init(){this.mobConn=window.navigator.mozMobileConnections;if(!this.mobConn){return;}
this.iccManager=window.navigator.mozIccManager;if(!this.iccManager){return;}
this.icc0=null;this.icc1=null;if(this.iccManager.iccIds[0]){this.updateIccState(this.iccManager.iccIds[0]);}
if(this.iccManager.iccIds[1]){this.updateIccState(this.iccManager.iccIds[1]);}
this.iccManager.addEventListener('iccdetected',this.handleIccState.bind(this));_=navigator.mozL10n.get;this.alreadyImported=false;},handleUnlockError:function sm_handleUnlockError(data){var l10nArgs={n:data.retryCount};switch(data.lockType){case'pin':if(data.retryCount===0){this.showPukScreen(this._unlockingIcc);break;}
UIManager.pinInput.value='';UIManager.pinInput.classList.add('onerror');UIManager.pinError.textContent=_('pinError');UIManager.pinError.classList.remove('hidden');UIManager.pinError.textContent=_('pinAttemptMsg2',l10nArgs);UIManager.pinRetriesLeft.textContent=_('inputCodeRetriesLeft',l10nArgs);UIManager.pinRetriesLeft.classList.remove('hidden');if(data.retryCount==1){UIManager.pinError.textContent+=' '+_('pinLastChanceMsg');}
break;case'puk':UIManager.pukInput.value='';UIManager.pukInput.classList.add('onerror');UIManager.pukError.textContent=_('pukError');UIManager.pukError.classList.remove('hidden');UIManager.pukInfo.classList.add('hidden');UIManager.pukError.textContent=_('pukAttemptMsg2',l10nArgs);UIManager.pukRetriesLeft.textContent=_('inputCodeRetriesLeft',l10nArgs);UIManager.pukRetriesLeft.classList.remove('hidden');if(data.retryCount==1){UIManager.pukError.textContent+=_('pukLastChanceMsg');}
break;case'nck':case'cck':case'spck':UIManager.xckInput.value='';UIManager.xckInput.classList.add('onerror');UIManager.xckError.textContent=_('nckError');UIManager.xckError.classList.remove('hidden');UIManager.xckInfo.classList.add('hidden');UIManager.xckError.textContent=_('nckAttemptMsg2',l10nArgs);UIManager.xckRetriesLeft.textContent=_('inputCodeRetriesLeft',l10nArgs);UIManager.xckRetriesLeft.classList.remove('hidden');if(data.retryCount==1){UIManager.xckError.textContent+=_('nckLastChanceMsg');}
break;}},available:function sm_available(){var icc=this.guessIcc();return(icc&&icc.cardState==='ready');},handleIccState:function sm_handleIccState(event){this.updateIccState(event.iccId);},updateIccState:function(iccId){var iccInfo=this.iccManager.getIccById(iccId);if(!iccInfo){throw new Error('Unrecognized iccID: '+iccId);}
if(this.mobConn[0]&&iccId===this.mobConn[0].iccId){this.icc0=new Icc(iccInfo);}else if(this.mobConn[1]&&iccId===this.mobConn[1].iccId){this.icc1=new Icc(iccInfo);}else{console.warn('ICC detected in unsupported slot',iccId);}},handleCardState:function sm_handleCardState(callback,skipUnlockScreen){this._unlockingIcc=null;SimManager.checkSIMButton();if(typeof callback==='function'){this.finishCallback=callback;}
if(this.shouldShowUnlockScreen(this.icc0)&&!skipUnlockScreen){this.showUnlockScreen(this.icc0);}else if(this.shouldShowUnlockScreen(this.icc1)&&!skipUnlockScreen){this.showUnlockScreen(this.icc1);}else if(this.shouldShowSIMInfoScreen()){this.resetSkipped();this.showSIMInfoScreen();}else{this.resetSkipped();this.finish();}},finish:function(){this.hideScreen();this.hideSIMInfoScreen();var showCellData=(this.icc0&&!this.icc0.isLocked())||(this.icc1&&!this.icc1.isLocked());this.finishCallback&&this.finishCallback(showCellData);},shouldShowUnlockScreen:function sm_shouldShowLockScreen(icc){return icc&&!icc.skipped&&icc.isLocked();},shouldShowSIMInfoScreen:function sm_shouldShowSIMInfoScreen(){return(this.icc0&&this.icc1);},showUnlockScreen:function sm_showUnlockScreen(icc){if(icc.unlocked){return;}
this._unlockingIcc=icc;switch(icc.mozIcc.cardState){case'pinRequired':this.showPinScreen(icc);break;case'pukRequired':this.showPukScreen(icc);break;case'networkLocked':case'corporateLocked':case'serviceProviderLocked':this.showXckScreen(icc);break;default:throw new Error('Cannot show SIM unlock screen, unknown cardState '+
icc.mozIcc.cardState);}},voiceChangeListeners:[],updateSIMInfoText:function sm_updateSIMInfoText(icc){var iccNumber=(icc===this.icc0)?1:2;if(icc&&icc.isLocked()){UIManager['simInfo'+iccNumber].classList.add('locked');UIManager['simCarrier'+iccNumber].textContent=_('simPinLocked');UIManager['simNumber'+iccNumber].textContent='';}else{UIManager['simInfo'+iccNumber].classList.remove('locked');var mobConn=this.mobConn[iccNumber-1];var operator=MobileOperator.userFacingInfo(mobConn).operator;if(!operator&&!this.voiceChangeListeners[iccNumber-1]){this.voiceChangeListeners[iccNumber-1]=function(evt){var operator=MobileOperator.userFacingInfo(mobConn).operator;if(operator){UIManager['simCarrier'+iccNumber].textContent=operator;mobConn.removeEventListener('voicechange',this.voiceChangeListeners[iccNumber-1]);this.voiceChangeListeners[iccNumber-1]=null;}}.bind(this);mobConn.addEventListener('voicechange',this.voiceChangeListeners[iccNumber-1]);}
UIManager['simCarrier'+iccNumber].textContent=operator||_('noOperator');var number=icc.mozIcc.iccInfo.msisdn||icc.mozIcc.iccInfo.mdn||'';if(number){UIManager['simNumber'+iccNumber].textContent=number;UIManager['simInfo'+iccNumber].classList.remove('no-number');}else{UIManager['simInfo'+iccNumber].classList.add('no-number');}}},showSIMInfoScreen:function sm_showSIMInfoScreen(){this.updateSIMInfoText(this.icc0);this.updateSIMInfoText(this.icc1);UIManager.activationScreen.classList.remove('show');UIManager.simInfoScreen.classList.add('show');},hideSIMInfoScreen:function sm_hidescreen(){UIManager.simInfoScreen.classList.remove('show');UIManager.activationScreen.classList.add('show');},checkSIMButton:function sm_checkSIMButton(){if(!this.mobConn){UIManager.simImport.classList.add('hidden');return;}
var simOption=UIManager.simImportButton;if(!SimManager.alreadyImported&&SimManager.available()){simOption.removeAttribute('disabled');UIManager.noSim.classList.add('hidden');}else{simOption.setAttribute('disabled','disabled');if(!SimManager.alreadyImported){UIManager.noSim.classList.remove('hidden');}}},showPinScreen:function sm_showPinScreen(icc){showRetryCount(icc,'pin',UIManager.pinRetriesLeft);UIManager.unlockSimButton.disabled=true;UIManager.pinInput.addEventListener('input',function sm_checkInput(event){UIManager.unlockSimButton.disabled=(event.target.value.length<4);});UIManager.activationScreen.classList.remove('show');UIManager.unlockSimScreen.classList.add('show');UIManager.pincodeScreen.classList.add('show');UIManager.xckcodeScreen.classList.remove('show');UIManager.unlockSimHeader.textContent=_('pincode2');var pincodeLabel=_('type_pin');if(this.simSlots>1){var simNumber=icc===this.icc0?1:2;pincodeLabel=_('pincodeLabel',{n:simNumber});}
UIManager.pinLabel.textContent=pincodeLabel;UIManager.pinInput.focus();},showPukScreen:function sm_showPukScreen(icc){showRetryCount(icc,'puk',UIManager.pukRetriesLeft);UIManager.unlockSimScreen.classList.add('show');UIManager.activationScreen.classList.remove('show');UIManager.pincodeScreen.classList.remove('show');UIManager.pukcodeScreen.classList.add('show');UIManager.xckcodeScreen.classList.remove('show');UIManager.unlockSimHeader.textContent=_('pukcode');var pukcodeLabel=_('type_puk');if(this.simSlots>1){var simNumber=icc===this.icc0?1:2;pukcodeLabel=_('pukcodeLabel',{n:simNumber});}
UIManager.pukLabel.textContent=pukcodeLabel;UIManager.pukInput.focus();},showXckScreen:function sm_showXckScreen(icc){var lockType;switch(icc.mozIcc.cardState){case'networkLocked':lockType='nck';break;case'corporateLocked':lockType='cck';break;case'serviceProviderLocked':lockType='spck';break;default:return;}
showRetryCount(icc,lockType,UIManager.xckRetriesLeft);UIManager.unlockSimScreen.classList.add('show');UIManager.activationScreen.classList.remove('show');UIManager.pincodeScreen.classList.remove('show');UIManager.pukcodeScreen.classList.remove('show');UIManager.xckcodeScreen.classList.add('show');var simNumber=icc===this.icc0?1:2;switch(icc.mozIcc.cardState){case'networkLocked':UIManager.unlockSimHeader.textContent=_('nckcodeTitle',{n:simNumber});UIManager.xckLabel.textContent=_('nckcodeLabel',{n:simNumber});break;case'corporateLocked':UIManager.unlockSimHeader.textContent=_('cckcodeTitle',{n:simNumber});UIManager.xckLabel.textContent=_('cckcodeLabel',{n:simNumber});break;case'serviceProviderLocked':UIManager.unlockSimHeader.textContent=_('spckcodeTitle',{n:simNumber});UIManager.xckLabel.textContent=_('spckcodeLabel',{n:simNumber});break;}
UIManager.xckInput.focus();},resetForm:function sm_clearInputs(){this.clearFields();UIManager.newpinInput.value='';UIManager.confirmNewpinInput.value='';UIManager.pinInput.value='';UIManager.pukInput.value='';UIManager.pukInfo.classList.remove('hidden');UIManager.xckInput.value='';UIManager.unlockSimButton.disabled=false;},hideScreen:function sm_hideScreen(){UIManager.unlockSimScreen.classList.remove('show');UIManager.pincodeScreen.classList.remove('show');UIManager.pukcodeScreen.classList.remove('show');UIManager.xckcodeScreen.classList.remove('show');UIManager.activationScreen.classList.add('show');},skip:function sm_skip(){if(this._unlockingIcc){this._unlockingIcc.skipped=true;}
this.resetForm();this.hideScreen();this.handleCardState();},resetSkipped:function sm_resetSkipped(){if(this.icc0){this.icc0.skipped=false;}
if(this.icc1){this.icc1.skipped=false;}},back:function sm_back(){this.resetForm();this.resetSkipped();this.hideScreen();this.hideSIMInfoScreen();Navigation.back();},simUnlockBack:function sm_simUnlockBack(){if(this.icc0.skipped){this.icc0.skipped=false;this.hideScreen();this.handleCardState();}else{this.back();}},unlock:function sm_unlock(){var icc=this._unlockingIcc;if(!icc){throw new Error('Cannot unlock SIM, no current ICC');}
switch(icc.mozIcc.cardState){case'pinRequired':this.unlockPin(icc);break;case'pukRequired':this.unlockPuk(icc);break;case'networkLocked':case'corporateLocked':case'serviceProviderLocked':this.unlockXck(icc);break;}},unlockPin:function sm_unlockPin(icc){var pin=UIManager.pinInput.value;if(pin.length<4||pin.length>8){UIManager.pinError.textContent=_('pinValidation');UIManager.pinInput.classList.add('onerror');UIManager.pinError.classList.remove('hidden');UIManager.pinInput.focus();return;}else{UIManager.pinInput.classList.remove('onerror');UIManager.pinError.classList.add('hidden');}
this.attemptUnlock(icc,{lockType:'pin',pin:pin});},clearFields:function sm_clearFields(){UIManager.pukInput.classList.remove('onerror');UIManager.pukError.classList.add('hidden');UIManager.newpinInput.classList.remove('onerror');UIManager.newpinError.classList.add('hidden');UIManager.confirmNewpinInput.classList.remove('onerror');UIManager.confirmNewpinError.classList.add('hidden');UIManager.pinError.classList.add('hidden');UIManager.pinRetriesLeft.classList.add('hidden');UIManager.pukError.classList.add('hidden');UIManager.pukRetriesLeft.classList.add('hidden');UIManager.xckError.classList.add('hidden');UIManager.xckRetriesLeft.classList.add('hidden');},unlockPuk:function sm_unlockPuk(icc){this.clearFields();var pukCode=UIManager.pukInput.value;if(pukCode.length!==8){UIManager.pukError.textContent=_('pukValidation');UIManager.pukError.classList.remove('hidden');UIManager.pukInfo.classList.add('hidden');UIManager.pukInput.classList.add('onerror');UIManager.pukError.focus();return;}
var newpinCode=UIManager.newpinInput.value;var confirmNewpin=UIManager.confirmNewpinInput.value;if(newpinCode.length<4||newpinCode.length>8){UIManager.newpinError.textContent=_('pinValidation');UIManager.newpinError.classList.remove('hidden');UIManager.newpinInput.classList.add('onerror');UIManager.newpinError.focus();return;}
if(newpinCode!=confirmNewpin){UIManager.confirmNewpinError.textContent=_('newpinConfirmation');UIManager.confirmNewpinError.classList.remove('hidden');UIManager.newpinInput.classList.add('onerror');UIManager.confirmNewpinInput.classList.add('onerror');UIManager.confirmNewpinError.focus();return;}
var options={lockType:'puk',puk:pukCode,newPin:newpinCode};this.attemptUnlock(icc,options);},unlockXck:function sm_unlockXck(icc){var xck=UIManager.xckInput.value;var lockType;switch(icc.mozIcc.cardState){case'networkLocked':lockType='nck';break;case'corporateLocked':lockType='cck';break;case'serviceProviderLocked':lockType='spck';break;}
if(xck.length<8||xck.length>16){UIManager.xckInput.classList.add('onerror');UIManager.xckError.classList.remove('hidden');UIManager.xckError.textContent=_(lockType+'Validation');UIManager.xckInput.focus();return;}else{UIManager.pinInput.classList.remove('onerror');UIManager.pinError.classList.add('hidden');}
var options={lockType:lockType,pin:xck};this.attemptUnlock(icc,options);},attemptUnlock:function sm_attemptUnlock(icc,options){var req=icc.mozIcc.unlockCardLock(options);req.onsuccess=(function sm_unlockSuccess(){icc.unlocked=true;this.resetForm();this.hideScreen();this.handleCardState();}).bind(this);req.onerror=(function sm_unlockError(){this.handleUnlockError(req.error);}).bind(this);},guessIcc:function guessIcc(){var tempIcc=null;if(navigator.mozMobileConnections){for(var i=0;i<navigator.mozMobileConnections.length&&tempIcc===null;i++){if(navigator.mozMobileConnections[i]!==null&&navigator.mozMobileConnections[i].iccId!==null){tempIcc=navigator.mozIccManager.getIccById(navigator.mozMobileConnections[i].iccId);}}}else{tempIcc=navigator.mozIccManager;}
return tempIcc;},importContacts:function sm_importContacts(){var DELAY_FEEDBACK=300;UIManager.navBar.setAttribute('aria-disabled','true');var progress=utils.overlay.show(_('simContacts-reading'),'activityBar');var importButton=UIManager.simImportButton;var cancelled=false,contactsRead=false;var importer=new SimContactsImporter(SimManager.guessIcc());utils.overlay.showMenu();utils.overlay.oncancel=function oncancel(){cancelled=true;importer.finish();if(contactsRead){progress.setClass('activityBar');utils.overlay.hideMenu();progress.setHeaderMsg(_('messageCanceling'));}else{importer.onfinish();}};var importedContacts=0;importer.onread=function sim_import_read(n){contactsRead=true;if(n>0){progress.setClass('progressBar');progress.setHeaderMsg(_('simContacts-importing'));progress.setTotal(n);}};importer.onimported=function imported_contact(){importedContacts++;if(!cancelled){progress.update();}};importer.onfinish=function sim_import_finish(){window.setTimeout(function do_sim_import_finish(){UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();if(importedContacts>0){window.importUtils.setTimestamp('sim');}
if(!cancelled){SimManager.alreadyImported=true;importButton.setAttribute('disabled','disabled');utils.status.show(_('simContacts-imported3',{n:importedContacts}));}},DELAY_FEEDBACK);importer.onfinish=null;};importer.onerror=function sim_import_error(){UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();importButton.removeAttribute('disabled');var cancel={title:_('cancel'),callback:function(){ConfirmDialog.hide();}};var retry={title:_('retry'),isRecommend:true,callback:function(){ConfirmDialog.hide();importButton.click();}};ConfirmDialog.show(null,_('simContacts-error'),cancel,retry);};importer.start();}};})();;'use strict';(function(){var importUtils=window.importUtils={};var SCALE_RATIO=window.innerWidth/320;var LAST_IMPORT_TIMESTAMP_SUFFIX='_last_import_timestamp';function scale(size){return Math.round(SCALE_RATIO*size);}
importUtils.getPreferredPictureBox=function(){var imgThumbSize=oauthflow.params.facebook.imgThumbSize;var out={width:scale(imgThumbSize)};out.height=out.width;return out;};importUtils.getPreferredPictureDetail=function(){var imgDetailWidth=oauthflow.params.facebook.imgDetailWidth;return scale(imgDetailWidth);};importUtils.setTimestamp=function(type,callback){asyncStorage.setItem(type+LAST_IMPORT_TIMESTAMP_SUFFIX,Date.now(),callback);};importUtils.getTimestamp=function(type,callback){asyncStorage.getItem(type+LAST_IMPORT_TIMESTAMP_SUFFIX,callback);};})();;'use strict';var SdManager={available:function(){return utils.sdcard.checkStorageCard();},checkSDButton:function sm_checkSDButton(){var sdOption=UIManager.sdImportButton;if(!SdManager.alreadyImported&&SdManager.available()){sdOption.removeAttribute('disabled');UIManager.noMemorycard.classList.add('hidden');}else{sdOption.setAttribute('disabled','disabled');if(!SdManager.alreadyImported){UIManager.noMemorycard.classList.remove('hidden');}}},importContacts:function sm_importContacts(){var DELAY_FEEDBACK=200;var importedContacts=0;UIManager.navBar.setAttribute('aria-disabled','true');var cancelled=false;var importer=null;var progress=utils.overlay.show(_('memoryCardContacts-reading'),'activityBar');utils.overlay.showMenu();utils.overlay.oncancel=function(){cancelled=true;if(importer){importer.finish();}else{UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();}};var importButton=UIManager.sdImportButton;utils.sdcard.retrieveFiles(['text/vcard','text/directory;profile=vCard','text/directory'],['vcf','vcard'],function(err,fileArray){if(err){return import_error(err);}
if(cancelled){return;}
if(fileArray.length){utils.sdcard.getTextFromFiles(fileArray,'',onFiles);}else{import_error('No contacts were found.');}});function onFiles(err,text){if(err){return import_error(err);}
if(cancelled){return;}
importer=new VCFReader(text);if(!text||!importer){return import_error('No contacts were found.');}
importer.onread=import_read;importer.onimported=imported_contact;importer.onerror=import_error;importer.process(function import_finish(){window.setTimeout(function onfinish_import(){window.importUtils.setTimestamp('sd');UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();if(!cancelled){SdManager.alreadyImported=true;importButton.setAttribute('disabled','disabled');utils.status.show(_('memoryCardContacts-imported3',{n:importedContacts}));}},DELAY_FEEDBACK);});}
function import_read(n){progress.setClass('progressBar');progress.setHeaderMsg(_('memoryCardContacts-importing'));progress.setTotal(n);}
function imported_contact(){importedContacts++;progress.update();}
function import_error(e){UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();importButton.removeAttribute('disabled');var cancel={title:_('cancel'),callback:function(){ConfirmDialog.hide();}};var retry={title:_('retry'),isRecommend:true,callback:function(){ConfirmDialog.hide();importButton.click();}};ConfirmDialog.show(null,_('memoryCardContacts-error'),cancel,retry);}}};;'use strict';var WifiManager={init:function wn_init(){_=navigator.mozL10n.get;this.api=WifiHelper.getWifiManager();this.changeStatus();if(navigator.mozSettings){var lock=window.navigator.mozSettings.createLock();this.enable(lock);this.enableDebugging(lock);}
this.gCurrentNetwork=this.api?this.api.connection.network:null;if(this.gCurrentNetwork!==null){this.api.forget(this.gCurrentNetwork);this.gCurrentNetwork=null;}},scan:function wn_scan(callback){if(this._scanning){return;}
this._scanning=true;utils.overlay.show(_('scanningNetworks'),'spinner');var scanTimeout;var SCAN_TIMEOUT=10000;var self=this;var req=this.api?this.api.getNetworks():null;if(!req){setTimeout(function(){self._scanning=false;callback();});return;}
req.onsuccess=function onScanSuccess(){self._scanning=false;self.networks=req.result;clearTimeout(scanTimeout);callback(self.networks);};req.onerror=function onScanError(){self._scanning=false;console.error('Error reading networks: '+req.error.name);clearTimeout(scanTimeout);callback();};scanTimeout=setTimeout(function(){self._scanning=false;console.warn('Timeout while reading networks');callback();},SCAN_TIMEOUT);},enable:function wn_enable(lock){lock.set({'wifi.enabled':true});},enableDebugging:function wn_enableDebugging(lock){this._prevDebuggingValue=false;var req=lock.get('wifi.debugging.enabled');req.onsuccess=function wn_getDebuggingSuccess(){this._prevDebuggingValue=req.result['wifi.debugging.enabled'];};lock.set({'wifi.debugging.enabled':true});},finish:function wn_finish(){if(!this._prevDebuggingValue&&navigator.mozSettings){var resetLock=window.navigator.mozSettings.createLock();resetLock.set({'wifi.debugging.enabled':false});}},getNetwork:function wm_gn(ssid){var network;for(var i=0;i<this.networks.length;i++){if(this.networks[i].ssid==ssid){network=this.networks[i];break;}}
return network;},connect:function wn_connect(ssid,password,user){var network=this.getNetwork(ssid);this.ssid=ssid;WifiHelper.setPassword(network,password,user);this.gCurrentNetwork=network;this.api.associate(network);},changeStatus:function wn_cs(callback){var self=this;if(WifiManager.api){WifiManager.api.onstatuschange=function(event){WifiUI.updateNetworkStatus(self.ssid,event.status);if(event.status==='connected'){if(self.networks&&self.networks.length){WifiUI.renderNetworks(self.networks);}}};}}};var WifiUI={joinNetwork:function wui_jn(){var password=document.getElementById('wifi_password').value;var user=document.getElementById('wifi_user').value;var ssid=document.getElementById('wifi_ssid').value;WifiUI.connect(ssid,password,user);window.history.back();},joinHiddenNetwork:function wui_jhn(){var password=UIManager.hiddenWifiPassword.value;var user=UIManager.hiddenWifiIdentity.value;var ssid=UIManager.hiddenWifiSsid.value;var security=UIManager.hiddenWifiSecurity.value;if(ssid.length){if(!Array.isArray(WifiManager.networks)){WifiManager.networks=[];}
WifiManager.networks.push({ssid:ssid,capabilities:[security],relSignalStrength:0});this.renderNetworks(WifiManager.networks);WifiUI.connect(ssid,password,user);}
window.history.back();},connect:function wui_connect(ssid,password,user){var networkSelected=document.querySelector('li[data-wifi-selected]');if(networkSelected){var icon=networkSelected.querySelector('aside');networkSelected.removeAttribute('data-wifi-selected');networkSelected.classList.remove('connected');icon.classList.remove('connecting');icon.classList.remove('connected');var security=networkSelected.dataset.security;var securityLevelDOM=networkSelected.querySelectorAll('p[data-security-level]')[0];if(!security||security===''){securityLevelDOM.textContent=_('securityOpen');}else{securityLevelDOM.textContent=security;}}
var newWifi=document.getElementById(ssid);newWifi.dataset.wifiSelected=true;newWifi.querySelector('p:last-child').textContent=_('shortStatus-connecting');newWifi.querySelector('aside').classList.add('connecting');WifiManager.connect(ssid,password,user);},chooseNetwork:function wui_cn(event){var ssid=event.target.dataset.ssid;if(WifiHelper.isOpen(WifiManager.getNetwork(ssid))){WifiUI.connect(ssid);return;}
UIManager.activationScreen.classList.add('no-options');UIManager.mainTitle.textContent=ssid;var selectedNetwork=WifiManager.getNetwork(ssid);var ssidHeader=document.getElementById('wifi_ssid');var userLabel=document.getElementById('label_wifi_user');var userInput=document.getElementById('wifi_user');var passwordInput=document.getElementById('wifi_password');var showPassword=document.querySelector('input[name=show_password]');var joinButton=UIManager.wifiJoinButton;joinButton.disabled=true;passwordInput.addEventListener('keyup',function validatePassword(){joinButton.disabled=!WifiHelper.isValidInput(WifiHelper.getKeyManagement(selectedNetwork),passwordInput.value,userInput.value);});passwordInput.type='password';passwordInput.value='';showPassword.checked=false;showPassword.onchange=function togglePasswordVisibility(){passwordInput.type=this.checked?'text':'password';};passwordInput.value='';ssidHeader.value=ssid;UIManager.navBar.classList.add('secondary-menu');if(WifiHelper.isEap(WifiManager.getNetwork(ssid))){userLabel.classList.remove('hidden');userInput.classList.remove('hidden');}else{userLabel.classList.add('hidden');userInput.classList.add('hidden');}
window.location.hash='#configure_network';},addHiddenNetwork:function wui_addHiddenNetwork(){UIManager.activationScreen.classList.add('no-options');UIManager.mainTitle.textContent=_('authentication');UIManager.navBar.classList.add('secondary-menu');window.location.hash='#hidden-wifi-authentication';},handleHiddenWifiSecurity:function wui_handleSecurity(securityType){if(securityType.indexOf('EAP')!==-1){UIManager.hiddenWifiIdentityBox.classList.remove('hidden');}else{UIManager.hiddenWifiIdentityBox.classList.add('hidden');}},renderNetworks:function wui_rn(networks){var networksDOM=document.getElementById('networks');networksDOM.innerHTML='';var networksList;if(!networks){var noResult='<div id="no-result-container">'+'  <div id="no-result-message">'+'    <p>'+_('noWifiFound3')+'</p>'+'  </div>'+'</div>';networksDOM.innerHTML=noResult;}else{networksList=document.createElement('ul');networksList.id='networks-list';var networksShown=[];networks.sort(function(a,b){return b.relSignalStrength-a.relSignalStrength;});for(var i=0,max=networks.length;i<max;i++){var network=networks[i];if(networksShown.indexOf(network.ssid)===-1){var li=document.createElement('li');var icon=document.createElement('aside');var ssidp=document.createElement('p');var small=document.createElement('p');small.dataset.securityLevel=true;icon.classList.add('pack-end');icon.classList.add('wifi-icon');var level=Math.min(Math.floor(network.relSignalStrength/20),4);icon.classList.add('level-'+level);ssidp.textContent=network.ssid;li.dataset.ssid=network.ssid;var keys=WifiHelper.getSecurity(network);li.dataset.security=keys;if(keys&&keys.length){small.textContent=keys.join(', ');icon.classList.add('secured');}else{small.textContent=_('securityOpen');}
icon.classList.add('wifi-signal');if(WifiHelper.isConnected(network)){small.textContent=_('shortStatus-connected');icon.classList.add('connected');li.classList.add('connected');li.dataset.wifiSelected=true;}
networksShown.push(network.ssid);li.setAttribute('id',network.ssid);li.appendChild(icon);li.appendChild(ssidp);li.appendChild(small);if(WifiHelper.isConnected(network)){networksList.insertBefore(li,networksList.firstChild);}else{networksList.appendChild(li);}}}
networksList.dataset.type='list';networksDOM.appendChild(networksList);}
utils.overlay.hide();},updateNetworkStatus:function wui_uns(ssid,status){var element=document.getElementById(ssid);if(!element||!element.dataset.wifiSelected){return;}
element.querySelector('p:last-child').textContent=_('shortStatus-'+status);var icon=element.querySelector('aside');if(status==='connecting'||status==='associated'){icon.classList.add('connecting');}else{icon.classList.remove('connecting');}}};;'use strict';var _=navigator.mozL10n.get;var ImportIntegration={get fbExtensions(){delete this.fbExtensions;return this.fbExtensions=document.getElementById('fb-extensions');},get fbImport(){delete this.fbImport;return this.fbImport=document.getElementById('fb_import');},get fbImportButton(){delete this.fbImportButton;return this.fbImportButton=document.getElementById('fb-import-button');},get liveImportButton(){delete this.liveImportButton;return this.liveImportButton=document.getElementById('live-import-button');},get gmailImportButton(){delete this.gmailImportButton;return this.gmailImportButton=document.getElementById('gmail-import-button');},get noNetworkMsg(){delete this.noNetworkMsg;return this.noNetworkMsg=document.getElementById('no-network');},get fbImportFeedback(){delete this.fbImportFeedback;return this.fbImportFeedback=document.getElementById('fb_import_feedback');},get fbAfterImport1(){delete this.fbAfterImport1;return this.fbAfterImport1=document.getElementById('fb_after_import1');},get fbAfterImport2(){delete this.fbAfterImport2;return this.fbAfterImport2=document.getElementById('fb_after_import2');},init:function fb_init(){this.fbImportButton.addEventListener('click',this);this.liveImportButton.addEventListener('click',this);this.gmailImportButton.addEventListener('click',this);document.addEventListener('fb_imported',this);},handleEvent:function fb_he(event){switch(event.type){case'click':if(event.target===this.fbImportButton){ServicesLauncher.start('facebook');}
else if(event.target===this.liveImportButton){ServicesLauncher.start('live');}
else if(event.target===this.gmailImportButton){ServicesLauncher.start('gmail');}
break;case'fb_imported':this.toggleToImportedState();this.updateContactsNumber();break;}},checkImport:function fb_check(nextState){var fbOption=this.fbImportButton;var noNetMsg=this.noNetworkMsg;if(nextState==='disabled'){fbOption.setAttribute('disabled','disabled');this.gmailImportButton.setAttribute('disabled','disabled');this.liveImportButton.setAttribute('disabled','disabled');noNetMsg.classList.remove('hidden');}
else if(nextState==='enabled'){fbOption.removeAttribute('disabled');this.gmailImportButton.removeAttribute('disabled');this.liveImportButton.removeAttribute('disabled');noNetMsg.classList.add('hidden');}},toggleToImportedState:function fb_tg_imported(){this.fbImport.classList.add('hidden');this.fbAfterImport1.classList.remove('hidden');this.fbAfterImport2.classList.remove('hidden');this.fbImport.parentNode.classList.remove('importOption');},updateContactsNumber:function fb_ucn(){this.fbImportFeedback.textContent=_('fb-checking');var self=this;var fbUpdateTotals=function fbUpdateTotals(imported,total){if(total==null){self.fbImportFeedback.textContent=_('notImportedYet');}else{self.fbImportFeedback.textContent=_('facebook-import-msg',{'imported':imported,'total':total});}};var req=fb.utils.getNumFbContacts();req.onsuccess=function(){var friendsOnDevice=req.result;var callbackListener={'local':function localContacts(number){fbUpdateTotals(friendsOnDevice,number);},'remote':function remoteContacts(number){fbUpdateTotals(friendsOnDevice,number);}};fb.utils.numFbFriendsData(callbackListener);};req.onerror=function(){console.error('Could not get number of local contacts');};}};var FacebookConfiguration=function FacebookConfiguration(){var disableFacebook=function disableFacebook(){ImportIntegration.fbImport.classList.add('hidden');};var enableFacebook=function enableFacebook(){ImportIntegration.fbImport.classList.remove('hidden');};var req=utils.config.load('/contacts/config.json');window.config={};req.onload=function(configData){if(configData.facebookEnabled===true){enableFacebook();}else{disableFacebook();}
window.config.operationsTimeout=configData.operationsTimeout;};req.onerror=function(code){disableFacebook();};}();;'use strict';(function(exports){var rdashes=/-(.)/g;var Utils={camelCase:function ut_camelCase(str){return str.replace(rdashes,function(str,p1){return p1.toUpperCase();});}};exports.Utils=Utils;}(this));;'use strict';(function(window){var TutorialSteps={};TutorialSteps.tiny={};TutorialSteps.large={};TutorialSteps.tiny.stepsCount=6+1;TutorialSteps.large.stepsCount=4+1;for(var supportLayout in TutorialSteps){for(var stepIndex=1;stepIndex<TutorialSteps[supportLayout].stepsCount;stepIndex++){var imagePathSuffix=(supportLayout==='tiny')?'.png':'_'+supportLayout+'.png';var l10nKeySuffix=(supportLayout==='tiny')?'':'-2';TutorialSteps[supportLayout][stepIndex]={hash:'#step'+stepIndex,key:'tutorial-step'+stepIndex+'-'+supportLayout+l10nKeySuffix,image:'css/images/tutorial/'+stepIndex+imagePathSuffix};if(stepIndex===TutorialSteps[supportLayout].stepsCount-1){TutorialSteps[supportLayout][stepIndex]['setting']='edgesgesture.enabled';}}
delete TutorialSteps[supportLayout].stepsCount;}
TutorialSteps.get=function(){var layout=(ScreenLayout&&ScreenLayout.getCurrentLayout)?ScreenLayout.getCurrentLayout():'tiny';if(layout in this){return this[layout];}
return null;};window.TutorialSteps=TutorialSteps;})(this);;'use strict';var Tutorial={tutorialSteps:{},currentStep:1,imagesLoaded:[],layout:'tiny',init:function n_init(){this.layout=(ScreenLayout&&ScreenLayout.getCurrentLayout)?ScreenLayout.getCurrentLayout():'tiny';this.tutorialSteps=TutorialSteps.get();this.initElements();this.forwardTutorial.addEventListener('click',this.forward.bind(this));this.backTutorial.addEventListener('click',this.back.bind(this));this.handleHowToExit();window.addEventListener('hashchange',this);},initElements:function(){var self=this;var elementIds=['forward-tutorial','back-tutorial','tutorial-nav-bar','tutorial-screen'];for(var i=1;i<=8;i++){elementIds.push('step'+i+'Img');elementIds.push('step'+i+'Header');}
elementIds.forEach(function(elementId){self[Utils.camelCase(elementId)]=document.getElementById(elementId);});this.tutorialFinish=document.getElementById('tutorial-finish-'+this.layout);},back:function n_back(event){this.currentStep--;this.manageStep();},forward:function n_forward(event){this.currentStep++;this.manageStep();},handleEvent:function n_handleEvent(event){var step=window.location.hash.replace('#','');var headerID=step+'Header';var imageID=step+'Img';var localeKey=this.tutorialSteps[this.currentStep].key;this[headerID].innerHTML=_(localeKey);if(Tutorial.imagesLoaded.indexOf(imageID)===-1){this[imageID].classList.add('hide');this[imageID].addEventListener('load',function onLoad(){this.removeEventListener('load',onLoad);this.classList.remove('hide');Tutorial.imagesLoaded.push(imageID);});}
this[imageID].src=this.tutorialSteps[this.currentStep].image;},handleHowToExit:function(){var self=this;if(this.layout==='tiny'){this.tutorialFinish.addEventListener('click',function ftuEnd(){self.tutorialFinish.removeEventListener('click',ftuEnd);self.exit();});}},exit:function(){WifiManager.finish();window.removeEventListener('hashchange',this);window.close();},jumpTo:function jumpTo(index){if(index<=this.numTutorialSteps+1&&index>=1){this.currentStep=index;this.manageStep();}},jumpToExitStep:function jumpToLastStep(){this.jumpTo(this.numTutorialSteps+1);},getSettingValue:function(step,cb){if(step>this._countSteps){cb();return;}
var settingKey=this.tutorialSteps[step].setting;if(settingKey===undefined){this.getSettingValue(step+1,cb);return;}
if(!navigator.mozSettings){return;}
var req=navigator.mozSettings.createLock().get(settingKey);var self=this;req.onsuccess=function cb_getSettingValue(){if(!req.result[settingKey]){delete self.tutorialSteps[step];}
self.getSettingValue(step+1,cb);};req.onerror=function err_getSettingValue(){console.error('Cant retrieve',settingKey,'value');};},computeNumTutorialSteps:function computeNumTutorialSteps(cb){if(this.numTutorialSteps){cb();return;}
this._countSteps=Object.keys(this.tutorialSteps).length;this.getSettingValue(1,function(){var finalCount=Object.keys(this.tutorialSteps).length;this.numTutorialSteps=finalCount;cb();}.bind(this));},manageStep:function manageStep(){this.computeNumTutorialSteps(this.onNumStepsReady.bind(this));},onNumStepsReady:function(){if(this.currentStep>1){this.tutorialNavBar.classList.remove('forward-only');}else{this.tutorialNavBar.classList.add('forward-only');}
if(this.currentStep>this.numTutorialSteps){Tutorial.tutorialScreen.classList.remove('show');Tutorial.tutorialFinish.classList.add('show');if(this.layout!=='tiny'){navigator.mozApps.getSelf().onsuccess=function(evt){var app=evt.target.result;app.connect('ftucomms').then(function onConnAccepted(ports){ports.forEach(function(port){port.postMessage('done');});},function onConnRejected(reason){console.log('FTU is rejected');console.log(reason);});};}}else{UIManager.tutorialProgressState.style.width='calc(100% / '+this.numTutorialSteps+')';UIManager.tutorialProgressState.style.transform='translate('+((this.currentStep-1)*100)+'%)';window.location.hash=this.tutorialSteps[this.currentStep].hash;}}};;'use strict';var steps={1:{onlyForward:true,hash:'#languages',requireSIM:false},2:{onlyForward:false,hash:'#data_3g',requireSIM:true},3:{onlyForward:false,hash:'#wifi',requireSIM:false},4:{onlyForward:false,hash:'#date_and_time',requireSIM:false},5:{onlyForward:false,hash:'#geolocation',requireSIM:false},6:{onlyForward:false,hash:'#import_contacts',requireSIM:false},7:{onlyForward:false,hash:'#firefox_accounts',requireSIM:false,requireFxAEnabled:true},8:{onlyForward:false,hash:'#welcome_browser',requireSIM:false},9:{onlyForward:false,hash:'#browser_privacy',requireSIM:false}};var numSteps=Object.keys(steps).length;var _;var Navigation={currentStep:1,previousStep:1,simMandatory:false,fxaEnabled:false,init:function n_init(){_=navigator.mozL10n.get;var settings=navigator.mozSettings;var forward=document.getElementById('forward');var back=document.getElementById('back');forward.addEventListener('click',this.forward.bind(this));back.addEventListener('click',this.back.bind(this));window.addEventListener('hashchange',this);UIManager.activationScreen.addEventListener('click',this.handleExternalLinksClick.bind(this));var reqSIM=settings&&settings.createLock().get('ftu.sim.mandatory')||{};var self=this;reqSIM.onsuccess=function onSuccess(){self.simMandatory=reqSIM.result['ftu.sim.mandatory']||false;};var reqFxA=settings&&settings.createLock().get('identity.fxaccounts.ui.enabled')||{};var self=this;reqFxA.onsuccess=function onSuccess(){self.fxaEnabled=reqFxA.result['identity.fxaccounts.ui.enabled']||false;};},back:function n_back(event){var currentStep=steps[this.currentStep];var actualHash=window.location.hash;if(actualHash!=currentStep.hash){window.history.back();}else{var self=this;var goToStep=function(){self.previousStep=self.currentStep;self.currentStep--;if(self.currentStep>0){self.manageStep();}};goToStep();}},forward:function n_forward(event){var self=this;var goToStepForward=function(){self.previousStep=self.currentStep;self.currentStep++;if(self.currentStep>numSteps){UIManager.sendNewsletter(function newsletterSent(result){if(result){UIManager.activationScreen.classList.remove('show');UIManager.finishScreen.classList.add('show');Tutorial.init();}else{self.currentStep--;}});return;}
self.manageStep();};goToStepForward();},handleExternalLinksClick:function n_handleExternalLinksClick(e){var link=e.target;if(!link.mozMatchesSelector('a.external')){return;}
e.preventDefault();var href=link.href,title=link.getAttribute('title')||link.textContent;if(navigator.onLine){this.displayExternalLink(href,title);}else{UIManager.displayOfflineDialog(href,title);}},displayExternalLink:function n_displayExternalLink(href,title){window.open(href);},getProgressBarState:function n_getProgressBarState(){return(this.skipped&&this.currentStep>2)?this.currentStep-2:this.currentStep-1;},handleEvent:function n_handleEvent(event){var actualHash=window.location.hash;UIManager.progressBar.classList.remove('hidden');switch(actualHash){case'#languages':UIManager.mainTitle.innerHTML=_('language');break;case'#data_3g':UIManager.mainTitle.innerHTML=_('3g');DataMobile.getStatus(UIManager.updateDataConnectionStatus.bind(UIManager));break;case'#wifi':UIManager.mainTitle.innerHTML=_('selectNetwork');UIManager.activationScreen.classList.remove('no-options');if(UIManager.navBar.classList.contains('secondary-menu')){UIManager.navBar.classList.remove('secondary-menu');return;}
WifiManager.scan(WifiUI.renderNetworks);break;case'#date_and_time':UIManager.mainTitle.innerHTML=_('dateAndTime');break;case'#geolocation':UIManager.mainTitle.innerHTML=_('geolocation');break;case'#import_contacts':UIManager.mainTitle.innerHTML=_('importContacts3');SimManager.checkSIMButton();SdManager.checkSDButton();var fbState;if(!WifiManager.api){ImportIntegration.checkImport('enabled');return;}
fbState=window.navigator.onLine?'enabled':'disabled';ImportIntegration.checkImport(fbState);break;case'#firefox_accounts':UIManager.mainTitle.innerHTML=_('firefox-accounts');break;case'#welcome_browser':UIManager.mainTitle.innerHTML=_('aboutBrowser');break;case'#browser_privacy':UIManager.mainTitle.innerHTML=_('aboutBrowser');break;case'#SIM_mandatory':UIManager.mainTitle.innerHTML=_('SIM_mandatory');break;case'#about-your-rights':case'#about-your-privacy':case'#sharing-performance-data':UIManager.mainTitle.innerHTML=_('aboutBrowser');UIManager.progressBar.classList.add('hidden');UIManager.navBar.classList.add('back-only');break;}
UIManager.progressBarState.style.width='calc(100% / '+numSteps+')';UIManager.progressBarState.style.transform='translateX('+(this.getProgressBarState()*100)+'%)';if(this.simMandatory){UIManager.skipPinButton.classList.add('hidden');UIManager.backSimButton.classList.remove('hidden');}else{UIManager.skipPinButton.classList.remove('hidden');UIManager.backSimButton.classList.add('hidden');}
if(this.currentStep<=numSteps&&steps[this.currentStep].hash!=='#wifi'){UIManager.activationScreen.classList.add('no-options');}
if(this.currentStep<=numSteps&&steps[this.currentStep].hash===actualHash){UIManager.navBar.classList.remove('back-only');}},skipStep:function n_skipStep(callback){this.currentStep=this.currentStep+
(this.currentStep-this.previousStep);if(this.currentStep<1){this.previousStep=this.currentStep=1;}
if(this.currentStep>numSteps){this.previousStep=this.currentStep=numSteps;}
this.skipped=true;this.manageStep();},manageStep:function n_manageStep(){var self=this;if(self.currentStep>=numSteps){OperatorVariant.setSIMOnFirstBootState();}
var futureLocation=steps[self.currentStep];if(futureLocation.requireFxAEnabled&&!this.fxaEnabled){self.skipStep();return;}
if(futureLocation.hash==='#wifi'){utils.overlay.show(_('scanningNetworks'),'spinner');}
if(this.simMandatory&&!IccHelper.cardState&&futureLocation.requireSIM){futureLocation.hash='#SIM_mandatory';futureLocation.requireSIM=false;futureLocation.onlyBackward=true;}
if(steps[this.currentStep].onlyForward){UIManager.navBar.classList.add('forward-only');}else{UIManager.navBar.classList.remove('forward-only');}
var nextButton=document.getElementById('forward');if(steps[this.currentStep].onlyBackward){nextButton.setAttribute('disabled','disabled');}else{nextButton.removeAttribute('disabled');}
if(this.currentStep===numSteps){nextButton.firstChild.textContent=_('done');}else{nextButton.firstChild.textContent=_('navbar-next');}
window.location.hash=futureLocation.hash;if(futureLocation.requireSIM){var check_cardState=function(response){self.skipped=false;if(!response||(!SimManager.available()&&futureLocation.hash!=='#data_3g')){self.skipStep();}};var skipUnlockScreens=this.currentStep<this.previousStep;SimManager.handleCardState(check_cardState,skipUnlockScreens);}}};;'use strict';var DataMobile={key:'ril.data.enabled',apnRetrieved:false,init:function dm_init(){var settings=navigator.mozSettings;if(!settings){console.log('Settings is not available');return;}
this.settings=settings;},getStatus:function dm_getStatus(callback){var request=this.settings.createLock().get(this.key);var self=this;request.onsuccess=function gst_success(){var currentStatus=request.result[self.key];self.isDataAvailable=currentStatus;callback(currentStatus);};request.onerror=function gst_error(){console.log('Error retrieving ril.data.enabled');};},toggle:function dm_toggle(status,callback){var options={};options[this.key]=status;if(!this.apnRetrieved){var self=this;this.getAPN(function apn_recovered(){self.settings.createLock().set(options);self.apnRetrieved=true;self.isDataAvailable=status;if(callback){callback();}});return;}
this.settings.createLock().set(options);this.apnRetrieved=true;this.isDataAvailable=status;if(callback){callback();}},getAPN:function dm_getapn(callback){var _self=this;function ensureApnSettings(){var req=_self.settings.createLock().get('ril.data.apnSettings');req.onsuccess=function loadApn(){var apnSettings=req.result['ril.data.apnSettings'];if(apnSettings){if(callback){callback(req.result);}
_self.settings.removeObserver('ril.data.apnSettings',ensureApnSettings);}};}
ensureApnSettings();this.settings.addObserver('ril.data.apnSettings',ensureApnSettings);}};;'use strict';var TimeManager={init:function tm_init(){if(window.navigator.mozTime){this.time=window.navigator.mozTime;}else{console.log('There is no mozTime available in window');}},set:function tm_set(date){this.time.set(date);}};;'use strict';var _;var UIManager={domSelectors:['splash-screen','activation-screen','progress-bar','progress-bar-state','finish-screen','nav-bar','main-title','unlock-sim-screen','unlock-sim-header','unlock-sim-back','pincode-screen','pin-label','pin-retries-left','pin-input','back-sim-button','pin-error','skip-pin-button','unlock-sim-button','pukcode-screen','puk-label','puk-retries-left','puk-input','puk-info','puk-error','newpin-input','newpin-error','confirm-newpin-input','confirm-newpin-error','xckcode-screen','xck-label','xck-retries-left','xck-input','xck-error','sim-info-screen','sim-info-back','sim-info-forward','sim-info-1','sim-info-2','sim-number-1','sim-number-2','sim-carrier-1','sim-carrier-2','sim-import','sim-import-button','no-sim','sd-import-button','no-memorycard','fxa-create-account','networks','wifi-refresh-button','wifi-join-button','join-hidden-button','hidden-wifi-authentication','hidden-wifi-ssid','hidden-wifi-security','hidden-wifi-password','hidden-wifi-identity','hidden-wifi-identity-box','hidden-wifi-show-password','date-configuration','time-configuration','date-configuration-label','time-configuration-label','time-form','data-connection-switch','geolocation-switch','tutorial-screen','tutorial-progress','tutorial-progress-state','lets-go-button','skip-tutorial-button','share-performance','offline-error-dialog','newsletter-form','newsletter-input','newsletter-success-screen','offline-newsletter-error-dialog','invalid-email-error-dialog'],init:function ui_init(){_=navigator.mozL10n.get;this.domSelectors.forEach(function createElementRef(name){this[toCamelCase(name)]=document.getElementById(name);}.bind(this));var currentDate=new Date();var f=new navigator.mozL10n.DateTimeFormat();var format=_('shortTimeFormat');this.timeConfigurationLabel.innerHTML=f.localeFormat(currentDate,format);this.dateConfigurationLabel.innerHTML=currentDate.toLocaleFormat('%Y-%m-%d');this.simImportButton.addEventListener('click',this);this.sdImportButton.addEventListener('click',this);this.skipPinButton.addEventListener('click',this);this.backSimButton.addEventListener('click',this);this.unlockSimButton.addEventListener('click',this);this.unlockSimBack.addEventListener('click',this);this.simInfoBack.addEventListener('click',this);this.simInfoForward.addEventListener('click',this);this.dataConnectionSwitch.addEventListener('click',this);this.wifiRefreshButton.addEventListener('click',this);this.wifiJoinButton.addEventListener('click',this);this.networks.addEventListener('click',this);this.joinHiddenButton.addEventListener('click',this);this.hiddenWifiSecurity.addEventListener('change',this);this.wifiJoinButton.disabled=true;this.hiddenWifiPassword.addEventListener('keyup',function(){this.wifiJoinButton.disabled=!WifiHelper.isValidInput(this.hiddenWifiSecurity.value,this.hiddenWifiPassword.value,this.hiddenWifiIdentity.value);}.bind(this));this.hiddenWifiShowPassword.onchange=function togglePasswordVisibility(){UIManager.hiddenWifiPassword.type=this.checked?'text':'password';};this.timeConfiguration.addEventListener('input',this);this.dateConfiguration.addEventListener('input',this);this.initTZ();this.geolocationSwitch.addEventListener('click',this);this.fxaCreateAccount.addEventListener('click',this);this.timeForm.addEventListener('submit',function(event){event.preventDefault();});this.newsletterInput.addEventListener('focus',function(){window.addEventListener('resize',function resize(){window.removeEventListener('resize',resize);setTimeout(function(){var page=document.getElementById('browser_privacy');UIManager.scrollToElement(page,UIManager.newsletterInput);},30);});});var basketCallback=function(err,data){utils.overlay.hide();if(err||data.status!=='ok'){if(err.desc.indexOf('email address')>-1){this.invalidEmailErrorDialog.classList.add('visible');}else{Basket.store(this.newsletterInput.value,function stored(){UIManager.newsletterSuccessScreen.classList.add('visible');});}
return;}
window.asyncStorage.removeItem('newsletter_email');this.newsletterForm.classList.add('hidden');this.newsletterSuccessScreen.classList.add('visible');};this.offlineNewsletterErrorDialog.querySelector('button').addEventListener('click',function offlineDialogClick(){this.offlineNewsletterErrorDialog.classList.remove('visible');}.bind(this));this.invalidEmailErrorDialog.querySelector('button').addEventListener('click',function invalidEmailDialogClick(){this.invalidEmailErrorDialog.classList.remove('visible');}.bind(this));this.skipTutorialButton.addEventListener('click',function(){if(ScreenLayout.getCurrentLayout()==='tiny'){WifiManager.finish();window.close();}
else{Tutorial.jumpToExitStep();}});this.letsGoButton.addEventListener('click',function(){UIManager.activationScreen.classList.remove('show');UIManager.finishScreen.classList.remove('show');UIManager.tutorialScreen.classList.add('show');Tutorial.manageStep();});this.sharePerformance.addEventListener('click',this);var button=this.offlineErrorDialog.querySelector('button');button.addEventListener('click',this.onOfflineDialogButtonClick.bind(this));},scrollToElement:function ui_scrollToElement(container,element){container.scrollTop=element.offsetTop;},sendNewsletter:function ui_sendNewsletter(callback){var self=this;var emailValue=self.newsletterInput.value;if(emailValue===''){return callback(true);}else{utils.overlay.show(_('email-loading'),'spinner');if(self.newsletterInput.checkValidity()){if(window.navigator.onLine){Basket.send(emailValue,function emailSent(err,data){if(err){if(err.code&&err.code===Basket.errors.INVALID_EMAIL){ConfirmDialog.show(_('invalid-email-dialog-title'),_('invalid-email-dialog-text'),{title:_('cancel'),callback:function ok(){ConfirmDialog.hide();}});utils.overlay.hide();return callback(false);}else{Basket.store(emailValue);}}
utils.overlay.hide();return callback(true);});}else{Basket.store(emailValue);utils.overlay.hide();return callback(true);}}else{utils.overlay.hide();ConfirmDialog.show(_('invalid-email-dialog-title'),_('invalid-email-dialog-text'),{title:_('cancel'),callback:function ok(){ConfirmDialog.hide();}});return callback(false);}}},initTZ:function ui_initTZ(){var tzRegion=document.getElementById('tz-region');var tzCity=document.getElementById('tz-city');tzSelect(tzRegion,tzCity,this.setTimeZone,this.setTimeZone);},handleEvent:function ui_handleEvent(event){switch(event.target.id){case'skip-pin-button':SimManager.skip();break;case'back-sim-button':case'sim-info-back':SimManager.back();break;case'unlock-sim-button':Navigation.skipped=false;SimManager.unlock();break;case'unlock-sim-back':SimManager.simUnlockBack();break;case'sim-info-forward':SimManager.finish();break;case'sim-import-button':window.setTimeout(SimManager.importContacts,0);break;case'sd-import-button':window.setTimeout(SdManager.importContacts,0);break;case'data-connection-switch':var status=event.target.checked;DataMobile.toggle(status);break;case'wifi-refresh-button':WifiManager.scan(WifiUI.renderNetworks);break;case'wifi-join-button':if(window.location.hash==='#hidden-wifi-authentication'){WifiUI.joinHiddenNetwork();}else{WifiUI.joinNetwork();}
break;case'join-hidden-button':WifiUI.addHiddenNetwork();break;case'hidden-wifi-security':var securityType=event.target.value;WifiUI.handleHiddenWifiSecurity(securityType);break;case'time-configuration':this.setTime();break;case'date-configuration':this.setDate();break;case'geolocation-switch':this.updateSetting(event.target.name,event.target.checked);break;case'share-performance':this.updateSetting(event.target.name,event.target.checked);break;case'fxa-create-account':this.createFirefoxAccount();break;default:if(event.target.parentNode.id==='networks-list'){WifiUI.chooseNetwork(event);}
break;}},updateSetting:function ui_updateSetting(name,value){var settings=window.navigator.mozSettings;if(!name||!settings){return;}
var cset={};cset[name]=value;settings.createLock().set(cset);},createFirefoxAccount:function ui_createFirefoxAccount(){var fxaDescription=document.getElementById('fxa-intro');var showResponse=function ui_showResponse(response){if(response&&response.done){UIManager.newsletterInput.value=response.email;fxaDescription.innerHTML='';navigator.mozL10n.localize(fxaDescription,'fxa-logged',{email:response.email});UIManager.fxaCreateAccount.disabled=true;}};var showError=function ui_showError(response){console.error('Create FxA Error: '+JSON.stringify(response));UIManager.newsletterInput.value='';navigator.mozL10n.localize(fxaDescription,'fxa-intro');UIManager.fxaCreateAccount.disabled=false;};FxAccountsIACHelper.openFlow(showResponse,showError);},displayOfflineDialog:function ui_displayOfflineDialog(href,title){var dialog=this.offlineErrorDialog,text=_('offline-dialog-text',{url:href});dialog.querySelector('small').textContent=text;dialog.classList.add('visible');},onOfflineDialogButtonClick:function ui_onOfflineDialogButtonClick(e){this.offlineErrorDialog.classList.remove('visible');},setDate:function ui_sd(){if(!!this.lock){return;}
var now=new Date();var currentDate=this.dateConfiguration.value;var currentTime=now.toLocaleFormat('%H:%M');var timeToSet=new Date(currentDate+'T'+currentTime);TimeManager.set(timeToSet);this.dateConfigurationLabel.innerHTML=timeToSet.toLocaleFormat('%Y-%m-%d');},setTime:function ui_st(){if(!!this.lock){return;}
var timeLabel=document.getElementById('time-configuration-label');var now=new Date();var currentTime=document.getElementById('time-configuration').value;if(currentTime.indexOf(':')===1){currentTime='0'+currentTime;}
var currentDate=now.toLocaleFormat('%Y-%m-%d');var timeToSet=new Date(currentDate+'T'+currentTime);TimeManager.set(timeToSet);var f=new navigator.mozL10n.DateTimeFormat();var format=_('shortTimeFormat');timeLabel.innerHTML=f.localeFormat(timeToSet,format);},setTimeZone:function ui_stz(timezone){var utcOffset=timezone.utcOffset;document.getElementById('time_zone_overlay').className='UTC'+utcOffset.replace(/[+:]/g,'');var timezoneTitle=document.getElementById('time-zone-title');navigator.mozL10n.localize(timezoneTitle,'timezoneTitle',{utcOffset:utcOffset,region:timezone.region,city:timezone.city});document.getElementById('tz-region-label').textContent=timezone.region;document.getElementById('tz-city-label').textContent=timezone.city;var f=new navigator.mozL10n.DateTimeFormat();var now=new Date();var timeLabel=document.getElementById('time-configuration-label');timeLabel.innerHTML=f.localeFormat(now,_('shortTimeFormat'));},updateDataConnectionStatus:function ui_udcs(status){this.dataConnectionSwitch.checked=status;}};function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};'use strict';var LanguageManager={settings:window.navigator.mozSettings,init:function init(){this.getCurrentLanguage(this.buildLanguageList.bind(this));document.getElementById('languages').addEventListener('change',this);this.settings.addObserver('language.current',function updateDefaultLayouts(event){KeyboardHelper.changeDefaultLayouts(event.settingValue,true);});},handleEvent:function handleEvent(evt){if(!this.settings||evt.target.name!='language.current'){return true;}
this.settings.createLock().set({'language.current':evt.target.value});return false;},getCurrentLanguage:function settings_getCurrent(callback){var self=this;this.readSetting('language.current',function onResponse(setting){self._currentLanguage=setting;callback(setting);});},readSetting:function settings_readSetting(name,callback){var settings=window.navigator.mozSettings;if(!settings||!settings.createLock||!callback){return;}
var req=settings.createLock().get(name);req.onsuccess=function _onsuccess(){callback(req.result[name]);};req.onerror=function _onerror(){console.error('Error checking setting '+name);};},getSupportedLanguages:function settings_getSupportedLanguages(callback){if(!callback){return;}
if(this._languages){callback(this._languages);}else{var LANGUAGES='languages.json';var self=this;this.readSharedFile(LANGUAGES,function getLanguages(data){if(data){self._languages=data;callback(self._languages);}});}},readSharedFile:function settings_readSharedFile(file,callback){var URI='/shared/resources/'+file;if(!callback){return;}
var xhr=new XMLHttpRequest();xhr.onreadystatechange=function loadFile(){if(xhr.readyState===4){if(xhr.status===0||xhr.status===200){callback(xhr.response);}else{console.error('Failed to fetch file: '+file,xhr.statusText);}}};xhr.open('GET',URI,true);xhr.responseType='json';xhr.send();},buildLanguageList:function settings_buildLanguageList(uiLanguage){var container=document.querySelector('#languages ul');container.innerHTML='';this.getSupportedLanguages(function fillLanguageList(languages){for(var lang in languages){var input=document.createElement('input');input.type='radio';input.name='language.current';input.value=lang;input.checked=(lang==uiLanguage);var span=document.createElement('span');var p=document.createElement('p');var rtlList=['ar','he','fa','ps','ur'];var langDir=(rtlList.indexOf(lang)>=0)?'rtl':'ltr';var bdo=document.createElement('bdo');bdo.setAttribute('dir',langDir);bdo.textContent=languages[lang];p.appendChild(bdo);var label=document.createElement('label');label.classList.add('pack-radio');label.appendChild(input);label.appendChild(span);label.appendChild(p);var li=document.createElement('li');li.appendChild(label);container.appendChild(li);}});}};LanguageManager.init();;'use strict';var Resources={load:function r_load(url,type,onsuccess,onerror){var xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.responseType=type;var mimetype=this.getMimetype(url);if(mimetype){xhr.overrideMimeType(mimetype);}
xhr.onload=function(){if(xhr.status===200){onsuccess&&onsuccess(xhr.response);}else{console.error('Resources.js: Failed to fetch file.',xhr.statusText);onerror&&onerror(xhr.statusText);}};try{xhr.send();}catch(e){console.error('Resources.js: Failed to fetch file.',xhr.statusText);onerror&&onerror('404: due to bug 827243');}},getMimetype:function r_getMimetype(fileName){var fileExtension=fileName.split('.').pop();var mimetype=false;if(fileExtension){switch(fileExtension){case'ogg':mimetype='audio/ogg';break;case'json':mimetype='application/json';break;case'mp3':mimetype='audio/mpeg';break;case'mp4':mimetype='audio/mp4';break;}}
return mimetype;}};;'use strict';var _=navigator.mozL10n.get;var AppManager={init:function init(){this.isLocalized=true;SimManager.init();WifiManager.init();ImportIntegration.init();TimeManager.init();UIManager.init();Navigation.init();DataMobile.init();VariantManager.init();var kSplashTimeout=700;var conn=window.navigator.mozMobileConnection||window.navigator.mozMobileConnections&&window.navigator.mozMobileConnections[0];if(!conn){setTimeout(function(){window.location.hash='#';UIManager.activationScreen.classList.add('show');window.location.hash='#languages';UIManager.splashScreen.classList.remove('show');},kSplashTimeout);return;}
setTimeout(function(){Navigation.manageStep();UIManager.activationScreen.classList.add('show');UIManager.splashScreen.classList.remove('show');},kSplashTimeout);}};navigator.mozL10n.ready(function showBody(){document.documentElement.lang=navigator.mozL10n.language.code;document.documentElement.dir=navigator.mozL10n.language.direction;if(!AppManager.isLocalized){AppManager.init();}else{UIManager.initTZ();UIManager.mainTitle.innerHTML=_('language');}});;'use strict';var VariantManager={CUSTOMIZATION_FILE:'/resources/customization.json',init:function vm_init(){this.mcc_mnc=this.getMccMnc();if(this.mcc_mnc){this.iccHandler();}else{this.boundIccHandler=this.iccHandler.bind(this);IccHelper.addEventListener('iccinfochange',this.boundIccHandler);}},getVariantSettings:function vm_getVariantSettings(onsuccess,onerror){var filePath=this.CUSTOMIZATION_FILE;Resources.load(filePath,'json',function(data){onsuccess&&onsuccess(data);},onerror);},CUSTOMIZERS:['/ftu/js/customizers/customizer.js','/ftu/js/customizers/keyboard_settings_customizer.js','/ftu/js/customizers/wallpaper_customizer.js','/ftu/js/customizers/data_icon_statusbar_customizer.js','/ftu/js/customizers/ringtone_customizer.js','/ftu/js/customizers/support_contacts_customizer.js','/ftu/js/customizers/default_contacts_customizer.js','/ftu/js/customizers/power_customizer.js'],iccHandler:function vm_iccHandler(){this.mcc_mnc=this.getMccMnc();if(this.mcc_mnc){if(IccHelper){IccHelper.removeEventListener('iccinfochange',this.boundIccHandler);}
LazyLoader.load(this.CUSTOMIZERS,this.loadVariantAndCustomize.bind(this));}},loadVariantAndCustomize:function vm_loadVariantAndCustomize(){this.getVariantSettings(this.dispatchCustomizationEvents.bind(this));},dispatchCustomizationEvents:function vm_dispatchEvents(customizationList)
{var customizationSettings=customizationList[this.mcc_mnc];if(!customizationSettings){console.error('There is no variant customization available for '+
this.mcc_mnc);return;}
for(var setting in customizationSettings){if(customizationSettings.hasOwnProperty(setting)){var customizationEvent=new CustomEvent('customization',{detail:{setting:setting,value:customizationSettings[setting]}});scheduleEvent(customizationEvent);}}
function scheduleEvent(event){setTimeout(function(){window.dispatchEvent(event);},0);}},getMccMnc:function vm_getMccMnc(){var mcc=undefined;var mnc=undefined;if(IccHelper&&IccHelper.iccInfo){mcc=IccHelper.iccInfo.mcc;mnc=IccHelper.iccInfo.mnc;}else if(!IccHelper||IccHelper.cardState===null){mcc='000';mnc='000';}
if((mcc!==undefined)&&(mcc!==null)&&(mnc!==undefined)&&(mnc!==null)){return this.normalizeCode(mcc)+'-'+this.normalizeCode(mnc);}
return undefined;},normalizeCode:function vm_normalizeCode(aCode){var ncode=''+aCode;while(ncode.length<3){ncode='0'+ncode;}
return ncode;}};;'use strict';function SimContactsImporter(targetIcc){if(targetIcc===null){throw new Error('We need an icc to continue with this operation');}
var pointer=0;var CHUNK_SIZE=5;var numResponses=0;var self=this;var mustFinish=false;var loadedMatch=false;var DEFAULT_TEL_TYPE='other';var icc=targetIcc;var iccId=icc.iccInfo&&icc.iccInfo.iccid;function generateIccContactUrl(contactid){var urlValue='urn:'+'uuid:'+(iccId||'iccId')+'-'+contactid;return[{type:['source','sim'],value:urlValue}];}
function notifyFinish(){if(typeof self.onfinish==='function'){window.setTimeout(self.onfinish,0);}}
function notifyImported(){if(typeof self.onimported==='function'){window.setTimeout(self.onimported,0);}}
function continueCb(){numResponses++;pointer++;notifyImported();if(pointer<self.items.length&&numResponses===CHUNK_SIZE){numResponses=0;mustFinish?notifyFinish():importSlice(pointer);}
else if(pointer>=self.items.length){notifyFinish();}}
function startMigration(){if(!mustFinish&&Array.isArray(self.items)&&self.items.length>0){importSlice(0);}
else{notifyFinish();}}
this.start=function(){if(mustFinish){notifyFinish();return;}
LazyLoader.load(['/shared/js/simple_phone_matcher.js','/contacts/js/contacts_matcher.js','/contacts/js/contacts_merger.js','/contacts/js/utilities/image_thumbnail.js','/contacts/js/merger_adapter.js'],function loaded(){loadedMatch=true;document.dispatchEvent(new CustomEvent('matchLoaded'));});var request;if(icc&&icc.readContacts){request=icc.readContacts('adn');}
else if(navigator.mozContacts){request=navigator.mozContacts.getSimContacts('ADN');}
else{throw new Error('Not able to obtain a SIM import function from platform');}
request.onsuccess=function onsuccess(){if(mustFinish){notifyFinish();return;}
self.items=request.result;if(typeof self.onread==='function'){self.onread(self.items.length);}
if(loadedMatch){startMigration();}
else{document.addEventListener('matchLoaded',function mloaded(){document.removeEventListener('matchLoaded',mloaded);startMigration();});}};request.onerror=function error(){if(typeof self.onerror==='function'){self.onerror(request.error);}};};this.finish=function(){mustFinish=true;};function importSlice(from){for(var i=from;i<from+CHUNK_SIZE&&i<self.items.length;i++){var item=self.items[i];var parsedName=utils.misc.parseName(item.name[0]);item.givenName=[parsedName.givenName];item.familyName=[parsedName.familyName];if(Array.isArray(item.tel)){var telItems=[];for(var j=0;j<item.tel.length;j++){var aTel=item.tel[j];if(aTel.value&&aTel.value.trim()){aTel.type=[DEFAULT_TEL_TYPE];telItems.push(aTel);}}
item.tel=telItems;}
item.category=['sim'];item.url=generateIccContactUrl(item.id);delete item.id;var contact=utils.misc.toMozContact(item);var cbs={onmatch:function(results){var mergeCbs={success:continueCb,error:function(e){window.console.error('Error while merging: ',e.name);continueCb();}};contacts.adaptAndMerge(this,results,mergeCbs);}.bind(contact),onmismatch:function(){saveContact(this);}.bind(contact)};contacts.Matcher.match(item,'passive',cbs);}}
function saveContact(contact){var req=window.navigator.mozContacts.save(contact);req.onsuccess=function saveSuccess(){continueCb();};req.onerror=function saveError(){console.error('SIM Import: Error importing ',contact.id,req.error.name);continueCb();};}};'use strict';var OperatorVariant=(function(){function setIsSIMPresentOnFirstBoot(value){var result=navigator.mozSettings.createLock().set({'ftu.simPresentOnFirstBoot':value});result.onerror=function ov_error(){console.error('An error occurre setting ftu.simPresentOnFirstBoot: '+
value);};}
function setSIMOnFirstBootState(){var cardState;try{if(!IccHelper||!IccHelper.cardState){cardState=undefined;}else{cardState=IccHelper.cardState;}
var settings=navigator.mozSettings;if(!settings){console.log('Settings is not available');return;}
var req=settings.createLock().get('ftu.simPresentOnFirstBoot');req.onsuccess=function ov_onsuccess(){var currentStatus=req.result['ftu.simPresentOnFirstBoot'];if(currentStatus===undefined||currentStatus===null){setIsSIMPresentOnFirstBoot(cardState==='ready');}
cardState=null;};req.onerror=function ov_error(){console.error('Error retrieving ftu.simPresentOnFirstBoot');};}catch(e){console.error('Error setSIMOnFirstBootState. '+e);}}
return{setSIMOnFirstBootState:setSIMOnFirstBootState};})();;'use strict';var ConfirmDialog=(function(){var isAnimationPlaying=false;var isShown=false;var doc=(parent.location===window.location)?document:parent.document;var screen=doc.getElementById('confirmation-message');var titleNode=screen.querySelector('h1');var messageNode=screen.querySelector('p');var action1Node=screen.querySelector('button:nth-of-type(1)');var action1Callback;var action2Node=screen.querySelector('button:nth-of-type(2)');var action2Callback;var oldzIndex;var callBackAndPreventDefault=function callBackAndPreventDefault(ev){if(ev.target===action1Node){action1Callback();ev.preventDefault();return false;}else if(ev.target===action2Node){action2Callback();ev.preventDefault();return false;}};var _hide=function _hide(){if(!isShown){return;}
titleNode.textContent='';titleNode.className='';messageNode.textContent='';messageNode.className='';action1Node.textContent='';action1Node.className='';action1Node.onclick=null;action2Node.textContent='';action2Node.className='';action2Node.onclick=null;screen.classList.remove('fade-in');screen.classList.add('fade-out');isAnimationPlaying=true;screen.addEventListener('animationend',function cd_fadeOut(ev){isAnimationPlaying=false;screen.removeEventListener('animationend',cd_fadeOut);screen.classList.add('no-opacity');screen.classList.add('hide');isShown=false;});};var _show=function _show(title,msg,action1,action2,options){if(options&&options.zIndex){oldzIndex=screen.style.zIndex;screen.style.zIndex=options.zIndex;}
else{oldzIndex=null;}
if(title){titleNode.textContent=title;}else{titleNode.classList.add('hide');}
if(msg){messageNode.textContent=msg;}else{messageNode.classList.add('hide');}
if(action1){if(action1.title){action1Node.textContent=action1.title;}
if(action1.isDanger){action1Node.classList.add('danger');}
if(action1.isRecommend){action1Node.classList.add('recommend');}
if(action1.callback){action1Callback=action1.callback;action1Node.onclick=callBackAndPreventDefault;}
if(!action2){action2Node.classList.add('hide');action1Node.classList.add('full');}}
if(action2){if(action2.title){action2Node.textContent=action2.title;}
if(action2.isDanger){action2Node.classList.add('danger');}
if(action2.isRecommend){action2Node.classList.add('recommend');}
if(action2.callback){action2Callback=action2.callback;action2Node.onclick=callBackAndPreventDefault;}
if(!action1){action1Node.classList.add('hide');action2Node.classList.add('full');}}
if(isShown){return;}
screen.classList.remove('hide');screen.classList.remove('fade-out');screen.classList.add('fade-in');isAnimationPlaying=true;screen.addEventListener('animationend',function cd_fadeIn(ev){isAnimationPlaying=false;screen.removeEventListener('animationend',cd_fadeIn);screen.classList.remove('no-opacity');});isShown=true;};return{hide:function dialog_hide(){if(oldzIndex){screen.style.zIndex=oldzIndex;oldzIndex=null;}
if(!isAnimationPlaying){_hide();return;}
screen.addEventListener('animationend',function cd_hideWhenFinished(ev){screen.removeEventListener('animationend',cd_hideWhenFinished);_hide();});},show:function dialog_show(title,msg,action1,action2,options){if(!isAnimationPlaying){_show(title,msg,action1,action2,options);return;}
screen.addEventListener('animationend',function cd_showWhenFinished(ev){screen.removeEventListener('animationend',cd_showWhenFinished);_show(title,msg,action1,action2,options);});}};}());