;'use strict';var Format={padLeft:function(input,len,padWith){padWith=padWith||' ';var pad=len-(input+'').length;while(--pad>-1){input=padWith+input;}
return input;}};;(function(exports){'use strict';const kEventName='statechange';const kCommunicationKey='airplaneMode.enabled';const kStatusKey='airplaneMode.status';var AirplaneModeHelper={_mozSettings:window.navigator.mozSettings,_callbacks:[],_cachedStatus:'',ready:function(cb){if(this._cachedStatus===''){var self=this;this.addEventListener(kEventName,function onChangeEvent(){if(self._cachedStatus!==''){self.removeEventListener(kEventName,onChangeEvent);cb();}});}else{cb();}},getStatus:function(){return this._cachedStatus;},addEventListener:function(eventName,callback){if(eventName===kEventName){this._callbacks.push(callback);}},removeEventListener:function(eventName,callback){if(eventName===kEventName){var index=this._callbacks.indexOf(callback);if(index>=0){this._callbacks.splice(index,1);}}},setEnabled:function(enabled){this.ready(function(){var status=this.getStatus();if(status==='enabling'||status==='disabling'){}else{if(enabled&&status==='enabled'||!enabled&&status==='disabled'){return;}
var setObj={};setObj[kCommunicationKey]=enabled;this._mozSettings.createLock().set(setObj);}}.bind(this));},init:function(){var self=this;var lock=window.navigator.mozSettings.createLock();var req=lock.get(kStatusKey);req.onsuccess=function(){self._cachedStatus=req.result[kStatusKey];self._callbacks.forEach(function(callback){callback(self._cachedStatus);});};this._mozSettings.addObserver(kStatusKey,function(evt){var currentStatus=evt.settingValue;self._cachedStatus=currentStatus;self._callbacks.forEach(function(callback){callback(currentStatus);});});}};exports.AirplaneModeHelper=AirplaneModeHelper;AirplaneModeHelper.init();})(this);;'use strict';var Widget=(function(){var costcontrol,activity;function checkSIMStatus(dataSim){var dataSimIcc=dataSim.icc;var cardState=checkCardState(dataSimIcc);if(cardState!=='ready'){debug('SIM not ready:',dataSimIcc.cardState);initialized=false;dataSimIcc.oncardstatechange=checkSIMStatus.bind(null,dataSim);}else{debug('SIM ready. ICCID:',dataSim.iccId);dataSimIcc.oncardstatechange=undefined;var SCRIPTS_NEEDED_TO_START=['js/costcontrol.js','js/config/config_manager.js'];LazyLoader.load(SCRIPTS_NEEDED_TO_START,startWidget);}}
function checkCardState(dataSimIcc){var state,cardState;state=cardState=dataSimIcc.cardState;if(!cardState||cardState==='absent'){debug('There is no SIM');Widget.showSimError('no-sim2');}else if(cardState==='unknown'){debug('Unknow state fo the sim');Widget.showSimError('unknown');}else if(cardState==='pinRequired'||cardState==='pukRequired'){Widget.showSimError('sim-locked');state='locked';}
return state;}
function loadMessageHandler(){if(ConfigManager.option('nextReset')){window.addEventListener('messagehandlerready',function _setNextReset(){window.removeEventListener('messagehandlerready',_setNextReset);LazyLoader.load('js/settings/networkUsageAlarm.js',function(){Common.loadNetworkInterfaces(function(){setNextReset(ConfigManager.option('nextReset'));});});});}
document.getElementById('message-handler').src='message_handler.html';}
function startWidget(){CostControl.getInstance(function _onCostControlReady(instance){costcontrol=instance;loadMessageHandler();setupWidget();});}
var initialized,widget,leftPanel,rightPanel,fte,views={};var balanceView;function _openBalanceTab(){activity=new MozActivity({name:'costcontrol/balance'});}
function _openTelephonyTab(){activity=new MozActivity({name:'costcontrol/telephony'});}
function _openDataUsageTab(){activity=new MozActivity({name:'costcontrol/data_usage'});}
function _onVisibilityChange(evt){AirplaneModeHelper.ready(function(){if(!document.hidden&&initialized&&(AirplaneModeHelper.getStatus()==='disabled')){SimManager.requestDataSimIcc(function(dataSimIcc){checkCardState(dataSimIcc.icc);updateUI();});}});}
function _onHashChange(){if(window.location.hash.split('#')[1]==='update'){updateUI(true);}}
function _onLocalize(){if(initialized){updateUI();}}
function setupWidget(){var mode=ConfigManager.getApplicationMode();var isDataUsageOnly=(mode==='DATA_USAGE_ONLY');var isBalanceEnabled=!isDataUsageOnly;widget=document.getElementById('cost-control');leftPanel=document.getElementById('left-panel');rightPanel=document.getElementById('right-panel');fte=document.getElementById('fte-view');views.dataUsage=document.getElementById('datausage-view');views.limitedDataUsage=document.getElementById('datausage-limit-view');views.telephony=document.getElementById('telephony-view');views.balance=document.getElementById('balance-view');if(isBalanceEnabled){ConfigManager.observe('lastBalance',onBalance,true);ConfigManager.observe('waitingForBalance',onErrors,true);ConfigManager.observe('errors',onErrors,true);LazyLoader.load('js/views/BalanceView.js',function(){var balanceConfig=ConfigManager.configuration.balance;balanceView=new BalanceView(document.getElementById('balance-credit'),document.querySelector('#balance-credit + .meta'),balanceConfig?balanceConfig.minimum_delay:undefined);});views.balance.addEventListener('click',_openBalanceTab);views.telephony.addEventListener('click',_openTelephonyTab);}
ConfigManager.observe('lastCompleteDataReset',onReset,true);ConfigManager.observe('lastTelephonyReset',onReset,true);document.addEventListener('visibilitychange',_onVisibilityChange);window.addEventListener('hashchange',_onHashChange);window.addEventListener('localized',_onLocalize);leftPanel.addEventListener('click',_openDataUsageTab);LazyLoader.load(['shared/js/date_time_helper.js','js/utils/formatting.js'],function(){updateUI();});if(SimManager.isMultiSim()){window.addEventListener('dataSlotChange',function _onDataSimChange(){CostControl.reset();Widget.reset();ConfigManager.setConfig(null);SimManager.requestDataSimIcc(checkSIMStatus);});}
initialized=true;}
function onBalance(balance,old,key,settings){debug('Balance received:',balance);setBalanceMode('default');updateBalance(balance,settings.lowLimit&&settings.lowLimitThreshold);debug('Balance updated!');}
function onErrors(errors,old,key,settings){if(!errors||!errors.BALANCE_TIMEOUT){return;}
debug('Balance timeout!');setBalanceMode('warning');errors.BALANCE_TIMEOUT=false;ConfigManager.setOption({errors:errors});}
function onReset(value,old,key,settings){updateUI();}
function _showSimError(status,updateTextOnly){navigator.mozL10n.ready(function showErrorStatus(){var widget=document.getElementById('cost-control');var fte=document.getElementById('fte-view');var leftPanel=document.getElementById('left-panel');var rightPanel=document.getElementById('right-panel');if(!updateTextOnly){widget.hidden=false;fte.hidden=false;leftPanel.hidden=true;rightPanel.hidden=true;}
var className='widget-'+status;Common.localize(fte.querySelector('p:first-child'),className+'-heading');Common.localize(fte.querySelector('p:last-child'),className+'-meta');});}
function setupFte(provider,mode){widget.hidden=false;fte.hidden=false;leftPanel.hidden=true;rightPanel.hidden=true;fte.addEventListener('click',function launchFte(evt){fte.removeEventListener('click',launchFte);evt.stopImmediatePropagation();activity=new MozActivity({name:'costcontrol/balance'});});var keyLookup={PREPAID:'widget-authed-sim',POSTPAID:'widget-authed-sim',DATA_USAGE_ONLY:'widget-nonauthed-sim'};var simKey=keyLookup[mode];Common.localize(fte.querySelector('p:first-child'),simKey+'-heading',{provider:provider});Common.localize(fte.querySelector('p:last-child'),simKey+'-meta');}
var hashMark=0;function updateUI(updateOnlyDataUsage){ConfigManager.requestAll(function _onInfo(configuration,settings){var mode=ConfigManager.getApplicationMode();debug('Widget UI mode:',mode);var isPrepaid=(mode==='PREPAID');var isDataUsageOnly=(mode==='DATA_USAGE_ONLY');if(settings.fte){setupFte(configuration.provider,mode);debug('Widget in FTE mode');return;}
widget.hidden=true;fte.hidden=true;leftPanel.hidden=false;rightPanel.hidden=false;var isLimited=settings.dataLimit;views.dataUsage.hidden=isLimited;views.limitedDataUsage.hidden=!isLimited;rightPanel.hidden=isDataUsageOnly;if(isDataUsageOnly){widget.classList.add('full');widget.hidden=false;}else{widget.classList.remove('full');views.balance.hidden=!isPrepaid;views.telephony.hidden=isPrepaid;widget.hidden=false;}
var requestObj={type:'datausage'};costcontrol.request(requestObj,function _onDataStatistics(result){debug(result);var stats=result.data;var data=Formatting.roundData(stats.mobile.total);if(isLimited){var dataLimit=views.limitedDataUsage.querySelector('#data-limit');var dataAvailable=views.limitedDataUsage.querySelector('#data-available');var current=stats.mobile.total;var limit=Common.getDataLimit(settings);debug(limit);views.limitedDataUsage.classList.remove('nearby-limit');views.limitedDataUsage.classList.remove('reached-limit');var limitTrespassed=(current>limit);if(limitTrespassed){views.limitedDataUsage.classList.add('reached-limit');}else if(current>=limit*Common.DATA_USAGE_WARNING){views.limitedDataUsage.classList.add('nearby-limit');}
var limitText=Formatting.roundData(limit);limitText=_('magnitude',{value:limitText[0],unit:limitText[1]});navigator.mozL10n.setAttributes(dataLimit,'data-limit',{value:limitText});var rawValue=Math.abs(limit-current);var text=Formatting.roundData(rawValue);if(!limitTrespassed){navigator.mozL10n.setAttributes(dataAvailable,'data-available2',{value:parseFloat(text[0]),unit:text[1]});}else{navigator.mozL10n.setAttributes(dataAvailable,'over-limit',{value:parseFloat(text[0]),unit:text[1]});}}else{document.getElementById('mobile-usage-value').textContent=_('magnitude',{value:data[0],unit:data[1]});var meta=views.dataUsage.querySelector('.meta');meta.innerHTML='';meta.appendChild(Formatting.formatTimeHTML(stats.timestamp));}
hashMark=1-hashMark;window.location.hash='#updateDone#'+hashMark;});if(!isDataUsageOnly&&!updateOnlyDataUsage){if(mode==='PREPAID'){updateBalance(settings.lastBalance,settings.lowLimit&&settings.lowLimitThreshold);requestObj={type:'balance'};costcontrol.request(requestObj,function _onRequest(result){debug(result);var status=result.status;var balance=result.data;setBalanceMode(status==='error'?'warning':'updating');updateBalance(balance,settings.lowLimit&&settings.lowLimitThreshold);});}else if(mode==='POSTPAID'){requestObj={type:'telephony'};costcontrol.request(requestObj,function _onRequest(result){var dataActivity=result.data;document.getElementById('telephony-calltime').textContent=_('magnitude',{value:Formatting.computeTelephonyMinutes(dataActivity),unit:'min'});document.getElementById('telephony-smscount').textContent=_('magnitude',{value:dataActivity.smscount,unit:'SMS'});var meta=views.telephony.querySelector('.meta');meta.innerHTML='';meta.appendChild(Formatting.formatTimeHTML(dataActivity.timestamp));});}}});}
function updateBalance(balance,limit){if(!balance){debug('Balance not available');balanceView.update();return;}
var isUpdating=views.balance.classList.contains('updating');balanceView.update(balance,isUpdating);if(balance.balance===0){views.balance.classList.add('no-credit');}else{views.balance.classList.remove('no-credit');if(limit&&balance.balance<limit){views.balance.classList.add('low-credit');}else{views.balance.classList.remove('low-credit');}}}
var lastBalanceMode;function setBalanceMode(mode){if(mode===lastBalanceMode){return;}
lastBalanceMode=mode;views.balance.classList.remove('updating');views.balance.classList.remove('warning');if(mode==='warning'){views.balance.classList.add('warning');}
if(mode==='updating'){views.balance.classList.add('updating');}}
window.addEventListener('airplaneModeDisabled',function _onAirplanemodeDisabled(evt){if(evt.detail&&evt.detail.serviceId==='data'){SimManager.requestDataSimIcc(checkSIMStatus);}});function initWidget(){var isWaitingForIcc=false;function waitForIccAndCheckSim(){if(!isWaitingForIcc){var iccManager=window.navigator.mozIccManager;iccManager.addEventListener('iccdetected',function _oniccdetected(){isWaitingForIcc=false;iccManager.removeEventListener('iccdetected',_oniccdetected);if(AirplaneModeHelper.getStatus()==='disabled'){SimManager.requestDataSimIcc(checkSIMStatus);}});isWaitingForIcc=true;}}
SimManager.requestDataSimIcc(checkSIMStatus,function _errorNoSim(){AirplaneModeHelper.ready(function(){waitForIccAndCheckSim();var errorMessageId=(AirplaneModeHelper.getStatus()==='enabled')?'airplane-mode':'no-sim2';console.warn('Error when trying to get the ICC ID');Widget.showSimError(errorMessageId);});});AirplaneModeHelper.addEventListener('statechange',function _onAirplaneModeChange(state){if(state==='enabled'){Widget.showSimError('airplane-mode');}else if(isWaitingForIcc){var updateTextOnly=true;Widget.showSimError('no-sim2',updateTextOnly);}});}
return{init:function(){var SCRIPTS_NEEDED=['js/common.js','js/utils/toolkit.js'];if(!window.navigator.mozMobileConnections||!window.navigator.mozIccManager||!window.navigator.mozNetworkStats){LazyLoader.load(SCRIPTS_NEEDED,function _showError(){Widget.showSimError('no-sim2');});}else{SCRIPTS_NEEDED=['js/sim_manager.js','js/common.js','js/utils/toolkit.js','js/utils/debug.js'];LazyLoader.load(SCRIPTS_NEEDED,initWidget);}},showSimError:_showSimError,reset:function(){document.removeEventListener('visibilitychange',_onVisibilityChange);window.removeEventListener('hashchange',_onHashChange);window.removeEventListener('localized',_onLocalize);leftPanel.removeEventListener('click',_openDataUsageTab);if(views.balance){views.balance.removeEventListener('click',_openBalanceTab);}
if(views.telephony){views.telephony.removeEventListener('click',_openTelephonyTab);}}};}());Widget.init();