;'use strict';var BluetoothHelper=function(){var profiles={'HFP':0x111E,'A2DP':0x110D};var _bluetooth=window.navigator.mozBluetooth;var _isReady=false;var _callbacks=[];var _adapter=null;var _v2=true;var _ready=function(callback){if(!callback||!_bluetooth){return;}
if(_isReady){callback();}else{_callbacks.push(callback);}};var _handleRequest=function(request,callback,errorcb){request.onsuccess=function(){if(callback){callback(request.result);}};request.onerror=function(){console.log('Error handling bluetooth request');if(errorcb){errorcb();}};};var _processCallbacks=function(){if(_adapter){_isReady=true;_callbacks.forEach(function(callback){callback();});_callbacks=[];}else{console.log('BluetoothHelper(): connot get default adapter yet');}};var _fetchAdapterV2=function(){_bluetooth.onattributechanged=function onManagerAttributeChanged(evt){for(var i in evt.attrs){switch(evt.attrs[i]){case'defaultAdapter':console.log('defaultAdapter changed. address:',_bluetooth.defaultAdapter.address);_adapter=_bluetooth.defaultAdapter;_processCallbacks();break;default:break;}}};_adapter=_bluetooth.defaultAdapter;if(_adapter){_processCallbacks();}};var _fetchAdapter=function(){var req=_bluetooth.getDefaultAdapter();if(req){req.onsuccess=function(){var _oldAdapter;if(_adapter){_oldAdapter=_adapter;}
_isReady=true;_adapter=req.result;if(_oldAdapter&&_oldAdapter.onpairedstatuschanged){_adapter.onpairedstatuschanged=_oldAdapter.onpairedstatuschanged;}
_callbacks.forEach(function(callback){callback();});_callbacks=[];};req.onerror=function(){console.log('BluetoothHelper(): connot get default adapter!!!');};}};var _getAdapter=function(){if(_v2){_fetchAdapterV2();}else{_fetchAdapter();}};if(_bluetooth){if(typeof(_bluetooth.onattributechanged)==='undefined'){_v2=false;}
if(_v2){_bluetooth.onadapteradded=function onAdapterAdded(evt){_getAdapter();};}else{_bluetooth.addEventListener('enabled',_getAdapter);_bluetooth.addEventListener('adapteradded',_getAdapter);}
_getAdapter();}
return{profiles:profiles,answerWaitingCall:function(){_ready(function(){_adapter.answerWaitingCall();});},ignoreWaitingCall:function(){_ready(function(){_adapter.ignoreWaitingCall();});},toggleCalls:function(){_ready(function(){_adapter.toggleCalls();});},getConnectedDevicesByProfile:function(profileID,cb){if(_v2){console.log('getConnectedDevicesByProfile API is deprecated');return;}
_ready(function(){_handleRequest(_adapter.getConnectedDevices(profileID),cb);});},connectSco:function(cb){_ready(function(){_handleRequest(_adapter.connectSco(),cb);});},disconnectSco:function(cb){_ready(function(){_handleRequest(_adapter.disconnectSco(),cb);});},getPairedDevices:function(cb){_ready(function(){_handleRequest(_adapter.getPairedDevices(),cb);});},getAddress:function(cb){_ready(function(){var address=_adapter.address;cb(address);});},setPairingConfirmation:function(address,confirmed){if(_v2){console.log('setPairingConfirmation API is deprecated');return;}
_ready(function(){_adapter.setPairingConfirmation(address,confirmed);});},setPinCode:function(address,pincode){if(_v2){console.log('setPairingConfirmation API is deprecated');return;}
_ready(function(){_adapter.setPinCode(address,pincode);});},setPasskey:function(address,key){if(_v2){console.log('setPairingConfirmation API is deprecated');return;}
_ready(function(){_adapter.setPasskey(address,key);});},set onhfpstatuschanged(callback){_ready(function(){_adapter.onhfpstatuschanged=callback;});},set onscostatuschanged(callback){_ready(function(){_adapter.onscostatuschanged=callback;});},set onpairedstatuschanged(callback){if(_v2){console.log('onpairedstatuschanged API is deprecated');return;}
_ready(function(){_adapter.onpairedstatuschanged=callback;});},v2:_v2,enable:function(){if(_v2){_ready(function(){_adapter.enable();});}else{console.log('enable is not support in v1 API!');}},disable:function(){if(_v2){_ready(function(){_adapter.disable();});}else{console.log('disable is not support in v1 API!');}}};};;'use strict';(function(exports){var _=window.navigator.mozL10n.get;var _debug=false;var PairManager={init:function(){this.bluetoothHelper=BluetoothHelper();navigator.mozSetMessageHandler('bluetooth-pairing-request',this.onRequestPairing.bind(this));navigator.mozSetMessageHandler('bluetooth-cancel',this.onBluetoothCancel.bind(this));navigator.mozSettings.addObserver('lockscreen.locked',function gotScreenLockedChanged(event){this.showPendingPairing(event.settingValue);}.bind(this));navigator.mozBluetooth.ondisabled=this.onBluetoothDisabled.bind(this);navigator.mozSettings.addObserver('bluetooth.enabled',function gotBluetoothEnabledChanged(event){if(!event.settingValue){this.onBluetoothDisabled();}}.bind(this));},onRequestPairing:function(pairingInfo){this.debug('onRequestPairing(): pairingInfo = '+pairingInfo);var req=navigator.mozSettings.createLock().get('lockscreen.locked');var self=this;req.onsuccess=function bt_onGetLocksuccess(){if(req.result['lockscreen.locked']){self.fireNotification(pairingInfo);}else{self.cleanPendingPairing();self.showPairview(pairingInfo);}};req.onerror=function bt_onGetLockError(){self.cleanPendingPairing();self.showPairview(pairingInfo);};},fireNotification:function(pairingInfo){this.pendingPairing={showPairviewCallback:this.showPairview.bind(this,pairingInfo)};var title=_('bluetooth-pairing-request-now-title');var body=pairingInfo.name||_('unnamed-device');var iconUrl='app://bluetooth.gaiamobile.org/style/images/icon_bluetooth.png';var notificationId='pairing-request';var notification=new Notification(title,{body:body,icon:iconUrl,tag:notificationId});notification.onclick=this.pairingRequestExpiredNotificationHandler.bind(this,notification);},pairingRequestExpiredNotificationHandler:function(notification){var req=navigator.mozSettings.createLock().get('lockscreen.locked');req.onsuccess=function bt_onGetLocksuccess(){if(!req.result['lockscreen.locked']){notification.close();navigator.mozApps.getSelf().onsuccess=function(evt){var app=evt.target.result;app.launch();if(!PairExpiredDialog.isVisible){PairExpiredDialog.showConfirm(function(){window.close();});}};}};},showPendingPairing:function(screenLocked){if(!screenLocked&&this.pendingPairing){if(this.pendingPairing.showPairviewCallback){this.pendingPairing.showPairviewCallback();}
this.cleanPendingPairing();}},cleanPendingPairing:function(){this.debug('cleanPendingPairing(): has pendingPairing = '+
(this.pendingPairing));if(this.pendingPairing){this.pendingPairing=null;}
this.cleanNotifications();},cleanNotifications:function(){Notification.get().then(function(notifications){if(notifications){notifications.forEach(function(notification){if(notification.tag==='pairing-request'&&notification.close){notification.close();}});}});},showPairview:function(pairingInfo){this.debug('showPairview(): pairingInfo = '+pairingInfo);var evt=pairingInfo;var device={address:evt.address,name:evt.name||_('unnamed-device'),icon:evt.icon||'bluetooth-default'};var pairingMode='passive';var passkey=evt.passkey||null;var method=evt.method;var protocol=window.location.protocol;var host=window.location.host;this.childWindow=window.open(protocol+'//'+host+'/onpair.html','pair_screen','attention');var self=this;this.childWindow.onload=function childWindowLoaded(){self.childWindow.Pairview.init(pairingMode,method,device,passkey);};},onBluetoothCancel:function(message){this.debug('onBluetoothCancel(): event message = '+message);if(this.childWindow){this.childWindow.Pairview.closeInput();this.childWindow.close();}
if(this.pendingPairing){this.pendingPairing=null;}
if(PairExpiredDialog.isVisible){PairExpiredDialog.close();window.close();}},onBluetoothDisabled:function(){this.debug('onBluetoothDisabled():');if(this.childWindow){this.childWindow.Pairview.closeInput();this.childWindow.close();}
window.close();},setConfirmation:function(address,confirmed){this.bluetoothHelper.setPairingConfirmation(address,confirmed);window.close();},setPinCode:function(address,pincode){this.bluetoothHelper.setPinCode(address,pincode);window.close();},setPasskey:function(address,passkey){var key=parseInt(passkey,10);this.bluetoothHelper.setPasskey(address,key);window.close();},debug:function(msg){if(_debug){console.log('PairManager(): '+msg);}}};exports.PairManager=PairManager;})(window);navigator.mozL10n.once(PairManager.init.bind(PairManager));;'use strict';(function(exports){var PairExpiredDialog={init:function(){this.dialog=document.getElementById('pairing-request-timeout');this.confirmBtn=document.getElementById('incoming-pairing-timeout-confirm');},showConfirm:function(callback){var self=this;this.confirmBtn.onclick=function(){self.close();if(callback){callback();}};this.dialog.hidden=false;},get isVisible(){return(!this.dialog.hidden);},close:function(){this.dialog.hidden=true;}};exports.PairExpiredDialog=PairExpiredDialog;})(window);navigator.mozL10n.once(PairExpiredDialog.init.bind(PairExpiredDialog));