;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;'use strict';navigator.mozL10n.once(function bluetoothSettings(){var Profiles={'HFP':0x111E,'A2DP':0x110D};var _=navigator.mozL10n.get;var l10n=navigator.mozL10n;var settings=navigator.mozSettings;var bluetooth=navigator.mozBluetooth;var defaultAdapter=null;const DEVICE_CONNECTED_KEY='bluetooth.device.connected';var MAX_DEVICE_NAME_LENGTH=20;if(!settings||!bluetooth){return;}
var backToSettingsBtn=document.getElementById('settings-back');backToSettingsBtn.onclick=function backToSettings(){window.close();};var gBluetoothCheckBox=document.querySelector('#bluetooth-status input');function updateBluetoothState(value){gBluetoothCheckBox.checked=value;}
gBluetoothCheckBox.onchange=function changeBluetooth(){var req=settings.createLock().set({'bluetooth.enabled':this.checked});this.disabled=true;req.onerror=function(){gBluetoothCheckBox.disabled=false;};};function initialDefaultAdapter(){if(!bluetooth.enabled)
return;var req=bluetooth.getDefaultAdapter();req.onsuccess=function bt_getAdapterSuccess(){defaultAdapter=req.result;if(defaultAdapter==null){settings.createLock().set({'bluetooth.enabled':false});return;}
defaultAdapter.ondevicefound=gDeviceList.onDeviceFound;gMyDeviceInfo.initWithAdapter();gDeviceList.initWithAdapter();};req.onerror=function bt_getAdapterFailed(){settings.createLock().set({'bluetooth.enabled':false});};}
var gMyDeviceInfo=(function deviceInfo(){var visibleItem=document.getElementById('device-visible');var visibleName=document.getElementById('bluetooth-device-name');var visibleCheckBox=document.querySelector('#device-visible input');var bluetoothRename=document.getElementById('bluetooth-rename');var renameButton=document.getElementById('rename-device');var updateNameDialog=document.getElementById('update-device-name');var updateNameInput=document.getElementById('update-device-name-input');var updateNameCancelButton=document.getElementById('update-device-name-cancel');var updateNameConfirmButton=document.getElementById('update-device-name-confirm');var visibleTimeout=null;var visibleTimeoutTime=120000;var myName='';visibleCheckBox.onchange=function changeDiscoverable(){setDiscoverable(this.checked);};renameButton.onclick=function renameBtnClicked(){if(myName===''){myName=visibleName.textContent=defaultAdapter.name;}
updateNameInput.value=myName;updateNameDialog.hidden=false;updateNameInput.focus();var cursorPos=updateNameInput.value.length;updateNameInput.setSelectionRange(0,cursorPos);};updateNameCancelButton.onclick=function updateNameCancelClicked(evt){if(evt)
evt.preventDefault();updateNameDialog.hidden=true;};updateNameConfirmButton.onclick=function updateNameConfirmClicked(evt){if(evt)
evt.preventDefault();var nameEntered=updateNameInput.value;nameEntered=nameEntered.replace(/^\s+|\s+$/g,'');if(nameEntered.length>MAX_DEVICE_NAME_LENGTH){var wantToRetry=window.confirm(_('bluetooth-name-maxlength-alert',{length:MAX_DEVICE_NAME_LENGTH}));if(!wantToRetry){updateNameDialog.hidden=true;}
return;}
if(nameEntered===myName||!bluetooth.enabled||!defaultAdapter){updateNameDialog.hidden=true;return;}
if(nameEntered!==''){updateDeviceName(nameEntered);}
else{var deviceInfo=settings.createLock().get('deviceinfo.product_model');deviceInfo.onsuccess=function bt_getProductModel(){var productModel=deviceInfo.result['deviceinfo.product_model'];updateDeviceName(productModel);};}
updateNameDialog.hidden=true;};function updateDeviceName(nameEntered){var req=defaultAdapter.setName(nameEntered);req.onsuccess=function bt_renameSuccess(){myName=visibleName.textContent=defaultAdapter.name;};}
function updateDeviceInfo(show){bluetoothRename.hidden=!show;if(show){visibleItem.hidden=false;var req=settings.createLock().get('bluetooth.visible');req.onsuccess=function bt_getVisibleSuccess(){var visible=req.result['bluetooth.visible'];if(typeof visible==='undefined'){visible=true;}
setDiscoverable(visible);};req.onerror=function bt_getVisibleError(){visibleCheckBox.checked=true;};}else{visibleItem.hidden=true;renameButton.disabled=true;if(visibleTimeout){clearTimeout(visibleTimeout);visibleTimeout=null;}}}
function initial(){visibleCheckBox.checked=defaultAdapter.discoverable;setDiscoverable(visibleCheckBox.checked);setTimeout(function(){myName=visibleName.textContent=defaultAdapter.name;renameButton.disabled=false;},1000);}
function setDiscoverable(visible){if(!bluetooth.enabled||!defaultAdapter)
return;settings.createLock().set({'bluetooth.visible':visible});defaultAdapter.setDiscoverable(visible);if(visible){if(!visibleTimeout){visibleTimeout=setTimeout(function(){setDiscoverable(false);},visibleTimeoutTime);}}else{if(visibleTimeout){clearTimeout(visibleTimeout);visibleTimeout=null;}}
visibleCheckBox.checked=visible;}
return{update:updateDeviceInfo,initWithAdapter:initial};})();var gDeviceList=(function deviceList(){var bluetoothSearch=document.getElementById('bluetooth-search');var searchAgainBtn=document.getElementById('search-device');var searchingItem=document.getElementById('bluetooth-searching');var enableMsg=document.getElementById('bluetooth-enable-msg');var pairingAddress=null;var connectingAddress=null;var connectedAddress=null;var discoverTimeoutTime=60000;var discoverTimeout=null;var pairList={title:document.getElementById('bluetooth-paired-title'),list:document.getElementById('bluetooth-paired-devices'),index:[],clear:function emptyList(){while(this.list.hasChildNodes()){this.list.removeChild(this.list.lastChild);}
this.index=[];},show:function showArea(isShown){if(!isShown){this.clear();}
this.title.hidden=!isShown;this.list.hidden=!isShown;}};var openList={title:document.getElementById('bluetooth-found-title'),list:document.getElementById('bluetooth-devices'),index:[],clear:function emptyList(){while(this.list.hasChildNodes()){this.list.removeChild(this.list.lastChild);}
this.index=[];},show:function showArea(isShown){if(!isShown){this.clear();}
this.title.hidden=!isShown;this.list.hidden=!isShown;}};var optionMenu={menu:document.getElementById('paired-device-option'),connectOpt:document.getElementById('connect-option'),disconnectOpt:document.getElementById('disconnect-option'),unpairOpt:document.getElementById('unpair-option'),confirmDlg:document.getElementById('unpair-device'),unpairCancel:document.getElementById('unpair-device-cancel'),confirmOpt:document.getElementById('confirm-option'),showActions:function showActions(){var self=this;if(connectedAddress&&this.device.address===connectedAddress){this.connectOpt.style.display='none';this.disconnectOpt.style.display='block';this.disconnectOpt.onclick=function(){setDeviceDisconnect(self.device);};}else{this.connectOpt.style.display='block';this.disconnectOpt.style.display='none';this.connectOpt.onclick=function(){setDeviceConnect(self.device);};}
this.unpairOpt.onclick=function(){setDeviceUnpair(self.device);};this.menu.onsubmit=function closeMenu(){return self.close();};this.menu.hidden=false;},showConfirm:function showConfirm(){var self=this;this.unpairCancel.onclick=function(){return self.close();};this.confirmOpt.onclick=function(){setDeviceUnpair(self.device);return self.close();};this.confirmDlg.hidden=false;},show:function showMenu(device){this.device=device;this[this.device.icon==='audio-card'?'showActions':'showConfirm']();},close:function closeMenu(){this.menu.hidden=true;this.confirmDlg.hidden=true;return false;}};searchAgainBtn.onclick=function searchAgainClicked(){updateDeviceList(true);openList.clear();startDiscovery();};function newListItem(device,descL10nId){var deviceName=document.createElement('span');if(device.name!==''){deviceName.textContent=device.name;}else{deviceName.setAttribute('data-l10n-id','unnamed-device');}
var deviceDesc=document.createElement('small');if(descL10nId){deviceDesc.setAttribute('data-l10n-id',descL10nId);}
var a=document.createElement('a');a.appendChild(deviceName);a.appendChild(deviceDesc);var li=document.createElement('li');li.classList.add('bluetooth-device');li.classList.add('bluetooth-type-'+device.icon);li.appendChild(a);return li;}
function updateDeviceList(show){bluetoothSearch.hidden=!show;if(show){enableMsg.hidden=true;openList.show(true);searchingItem.hidden=false;document.addEventListener('visibilitychange',stopDiscoveryWhenLeaveApp);}else{openList.show(false);pairList.show(false);enableMsg.hidden=false;searchingItem.hidden=true;optionMenu.close();pairingAddress=null;connectingAddress=null;connectedAddress=null;clearTimeout(discoverTimeout);discoverTimeout=null;document.removeEventListener('visibilitychange',stopDiscoveryWhenLeaveApp);}}
function initial(){defaultAdapter.onpairedstatuschanged=function bt_getPairedMessage(evt){dispatchEvent(new CustomEvent('bluetooth-pairedstatuschanged'));showDevicePaired(evt.status,'Authentication Failed');};defaultAdapter.ondiscoverystatechanged=function bt_discoveryStateChanged(evt){if(!evt.discovering){searchAgainBtn.disabled=false;searchingItem.hidden=true;clearTimeout(discoverTimeout);discoverTimeout=null;}else{searchAgainBtn.disabled=true;searchingItem.hidden=false;}};defaultAdapter.onhfpstatuschanged=function bt_hfpStatusChanged(evt){showDeviceConnected(evt.address,evt.status,Profiles.HFP);};defaultAdapter.ona2dpstatuschanged=function bt_a2dpStatusChanged(evt){showDeviceConnected(evt.address,evt.status,Profiles.A2DP);};getPairedDevice(function(){for(var address in pairList.index){var deviceItem=pairList.index[address];if(Object.keys(deviceItem.connectedProfiles).length>0)
return;}
restoreConnection();});startDiscovery();}
function restoreConnection(){var connectedDevice=settings.createLock().get(DEVICE_CONNECTED_KEY);connectedDevice.onsuccess=function bt_getConnectedDevice(){var address=connectedDevice.result[DEVICE_CONNECTED_KEY];if(!address||!pairList.index[address])
return;var device=pairList.index[address].device;setDeviceConnect(device);};}
function getPairedDevice(callback){if(!bluetooth.enabled||!defaultAdapter)
return;var req=defaultAdapter.getPairedDevices();req.onsuccess=function bt_getPairedSuccess(){var paired=req.result.slice();var length=paired.length;if(length==0){pairList.show(false);return;}
pairList.clear();paired.sort(function(a,b){return a.name>b.name;});for(var i=0;i<length;i++){(function(device){var aItem=newListItem(device,'');aItem.onclick=function(){optionMenu.show(device);};pairList.list.appendChild(aItem);pairList.index[device.address]={device:device,item:aItem,connectedProfiles:{}};if(device.address===connectingAddress&&device.icon==='audio-card'){var small=aItem.querySelector('small');small.setAttribute('data-l10n-id','device-status-connecting');setTimeout(function(){setDeviceConnect(device);},5000);}})(paired[i]);}
getConnectedDeviceItems(function(connectedDeviceItems){if(connectedDeviceItems.length>0){connectedDeviceItems.forEach(function(item){var connectedDevice=item.device;var connectedProfiles=item.connectedProfiles;for(var profile in connectedProfiles){showDeviceConnected(connectedDevice.address,true,profile);}});}
pairList.show(true);if(callback)
callback();});};}
function getConnectedDeviceItems(callback){if(!callback)
return;if(!defaultAdapter){callback([]);return;}
var getConnectedDevicesByProfile=function(profileID,gcdCallback){if(!gcdCallback)
return;var req=defaultAdapter.getConnectedDevices(profileID);req.onsuccess=function(){gcdCallback(req.result||[]);};req.onerror=function(){gcdCallback(null);};};var connectedDeviceItemsMap={};var updateDeviceItemsMap=function(profileID,connectedDevices){if(!connectedDevices)
return;connectedDevices.forEach(function(connectedDevice){var info=connectedDeviceItemsMap[connectedDevice.address];if(info){info.connectedProfiles[profileID]=true;}else{info={'device':connectedDevice,'connectedProfiles':{}};info.connectedProfiles[profileID]=true;}
connectedDeviceItemsMap[connectedDevice.address]=info;});};getConnectedDevicesByProfile(Profiles.HFP,function(hfpResult){updateDeviceItemsMap(Profiles.HFP,hfpResult);getConnectedDevicesByProfile(Profiles.A2DP,function(a2dpResult){updateDeviceItemsMap(Profiles.A2DP,a2dpResult);var connectedDeviceItems=[];for(var i in connectedDeviceItemsMap){var item=connectedDeviceItemsMap[i];connectedDeviceItems.push(item);}
callback(connectedDeviceItems);});});}
function onDeviceFound(evt){var device=evt.device;var existingDevice=openList.index[device.address]||pairList.index[device.address];if(existingDevice){var existingItem=existingDevice.item;if(device.name&&existingItem){var deviceName=existingItem.querySelector('a > span');if(deviceName){deviceName.removeAttribute('data-l10n-id');deviceName.textContent=device.name;}}
return;}
var aItem=newListItem(device,'device-status-tap-connect');aItem.onclick=function(){if(pairingAddress)
return;var small=aItem.querySelector('small');small.setAttribute('data-l10n-id','device-status-pairing');this.setAttribute('aria-disabled',true);stopDiscovery();var req=defaultAdapter.pair(device.address);pairingAddress=device.address;req.onerror=function bt_pairError(error){showDevicePaired(false,req.error.name);};};openList.list.appendChild(aItem);openList.index[device.address]={device:device,item:aItem,connectedProfiles:{}};}
function showDevicePaired(paired,errorMessage){if(!pairingAddress){getPairedDevice();return;}
var workingAddress=pairingAddress;pairingAddress=null;if(paired){if(openList.index[workingAddress]){var device=openList.index[workingAddress].device;var item=openList.index[workingAddress].item;openList.list.removeChild(item);delete openList.index[workingAddress];connectingAddress=workingAddress;}}else{var msg=_('error-pair-title');if(errorMessage==='Repeated Attempts'){msg=msg+'\n'+_('error-pair-toofast');}else if(errorMessage==='Authentication Failed'){msg=msg+'\n'+_('error-pair-pincode');}
window.alert(msg);if(openList.index[workingAddress]){var item=openList.index[workingAddress].item;var small=item.querySelector('small');item.removeAttribute('aria-disabled');small.setAttribute('data-l10n-id','device-status-tap-connect');}}
getPairedDevice();}
function setDeviceUnpair(device){if(device.address===connectedAddress){var msg=_('unpair-title')+'\n'+_('unpair-msg');if(!window.confirm(msg))
return;connectedAddress=null;}
var req=defaultAdapter.unpair(device.address);req.onerror=function bt_pairError(){showDevicePaired(true,null);};}
function setDeviceDisconnect(device,callback){if(!bluetooth.enabled||!defaultAdapter||device.address!==connectedAddress){if(callback)
callback();return;}
var req=defaultAdapter.disconnect(device);req.onsuccess=req.onerror=function(){if(callback)
callback();};}
function setDeviceConnect(device){if(!bluetooth.enabled||!defaultAdapter||device.icon!=='audio-card'||device.address===connectedAddress){connectingAddress=null;return;}
var doConnect=function(){var connectSuccess=function bt_connectSuccess(){if(connectingAddress){connectingAddress=null;}};var connectError=function bt_connectError(){if(connectingAddress){var small=pairList.index[connectingAddress].item.querySelector('small');small.removeAttribute('data-l10n-id');small.textContent='';connectingAddress=null;window.alert(_('error-connect-msg'));}};stopDiscovery();var req=defaultAdapter.connect(device);req.onsuccess=connectSuccess;req.onerror=connectError;connectingAddress=device.address;if(!pairList.index[connectingAddress]){return;}
var small=pairList.index[connectingAddress].item.querySelector('small');small.setAttribute('data-l10n-id','device-status-connecting');};if(connectedAddress&&pairList.index[connectedAddress]){setDeviceDisconnect(pairList.index[connectedAddress].device,doConnect);}else{doConnect();}}
function showDeviceConnected(deviceAddress,connected,profile){var deviceItem=pairList.index[deviceAddress];if(!deviceItem)
return;deviceItem.connectedProfiles[profile]=connected;var existConnectedProfile=false;if(connected){existConnectedProfile=true;}else{for(var profile in deviceItem.connectedProfiles){existConnectedProfile=existConnectedProfile||deviceItem.connectedProfiles[profile];}}
if(existConnectedProfile){connectedAddress=deviceAddress;settings.createLock().set({'bluetooth.device.connected':connectedAddress});}else{if(connectedAddress===deviceAddress){connectedAddress=null;settings.createLock().set({'bluetooth.device.connected':null});}}
var l10nId='';var hfpConnected=deviceItem.connectedProfiles[Profiles.HFP];var a2dpConnected=deviceItem.connectedProfiles[Profiles.A2DP];if(hfpConnected&&a2dpConnected){l10nId='device-status-connected-phone-media';}else if(hfpConnected){l10nId='device-status-connected-phone';}else if(a2dpConnected){l10nId='device-status-connected-media';}else{l10nId=null;}
var small=pairList.index[deviceAddress].item.querySelector('small');if(l10nId){small.setAttribute('data-l10n-id',l10nId);}else{small.removeAttribute('data-l10n-id');small.textContent='';}}
function startDiscovery(){if(!bluetooth.enabled||!defaultAdapter||discoverTimeout||document.hidden){return;}
var req=defaultAdapter.startDiscovery();req.onsuccess=function bt_discoveryStart(){if(!discoverTimeout)
discoverTimeout=setTimeout(stopDiscovery,discoverTimeoutTime);};req.onerror=function bt_discoveryFailed(){console.error('Can not discover nearby device');};}
function stopDiscoveryWhenLeaveApp(){if(!document.hidden)
return;stopDiscovery();}
function stopDiscovery(){if(!bluetooth.enabled||!defaultAdapter||!discoverTimeout)
return;var req=defaultAdapter.stopDiscovery();req.onerror=function bt_discoveryStopFailed(){console.error('Can not stop discover nearby device');};clearTimeout(discoverTimeout);discoverTimeout=null;}
return{update:updateDeviceList,initWithAdapter:initial,startDiscovery:startDiscovery,onDeviceFound:onDeviceFound};})();var lastMozSettingValue=false;settings.addObserver('bluetooth.enabled',function(event){var enabled=event.settingValue;if(lastMozSettingValue==enabled)
return;gBluetoothCheckBox.disabled=true;lastMozSettingValue=enabled;updateBluetoothState(enabled);gDeviceList.update(enabled);gMyDeviceInfo.update(enabled);if(!enabled)
defaultAdapter=null;});var req=settings.createLock().get('bluetooth.enabled');req.onsuccess=function bt_getSettingsSuccess(){lastMozSettingValue=req.result['bluetooth.enabled'];if(lastMozSettingValue)
initialDefaultAdapter();updateBluetoothState(lastMozSettingValue);gDeviceList.update(lastMozSettingValue);gMyDeviceInfo.update(lastMozSettingValue);};bluetooth.addEventListener('adapteradded',function(){gBluetoothCheckBox.disabled=false;initialDefaultAdapter();dispatchEvent(new CustomEvent('bluetooth-adapter-added'));});bluetooth.addEventListener('disabled',function(){gBluetoothCheckBox.disabled=false;defaultAdapter=null;dispatchEvent(new CustomEvent('bluetooth-disabled'));});});