;'use strict';(function(exports){const NDEF={MB:1<<7,ME:1<<6,CF:1<<5,SR:1<<4,IL:1<<3,TNF:0x07,TNF_EMPTY:'empty',TNF_WELL_KNOWN:'well-known',TNF_MIME_MEDIA:'media-type',TNF_ABSOLUTE_URI:'absolute-uri',TNF_EXTERNAL_TYPE:'external',TNF_UNKNOWN:'unknown',TNF_UNCHANGED:'unchanged',RTD_TEXT:0,RTD_URI:0,RTD_SMART_POSTER:0,RTD_ALTERNATIVE_CARRIER:0,RTD_COLLISION_RESOLUTION:0,RTD_HANDOVER_CARRIER:0,RTD_HANDOVER_REQUEST:0,RTD_HANDOVER_SELECT:0,RTD_TEXT_IANA_LENGTH:0x3F,RTD_TEXT_ENCODING:0x80,RTD_TEXT_UTF8:0,RTD_TEXT_UTF16:1,CPS_INACTIVE:0,CPS_ACTIVE:1,CPS_ACTIVATING:2,CPS_UNKNOWN:3,MIME_BLUETOOTH_OOB:0,SMARTPOSTER_ACTION:0,DO_ACTION:0x00,SAVE_FOR_LATER_ACTION:0x01,OPEN_FOR_EDITING_ACTION:0x02,RFU_ACTION:0x03,URIS:[],init:function ndef_init(){var nfcUtils=new NfcUtils();this.RTD_TEXT=nfcUtils.fromUTF8('T');this.RTD_URI=nfcUtils.fromUTF8('U');this.RTD_SMART_POSTER=nfcUtils.fromUTF8('Sp');this.RTD_ALTERNATIVE_CARRIER=nfcUtils.fromUTF8('ac');this.RTD_COLLISION_RESOLUTION=nfcUtils.fromUTF8('cr');this.RTD_HANDOVER_CARRIER=nfcUtils.fromUTF8('Hc');this.RTD_HANDOVER_REQUEST=nfcUtils.fromUTF8('Hr');this.RTD_HANDOVER_SELECT=nfcUtils.fromUTF8('Hs');this.MIME_BLUETOOTH_OOB=nfcUtils.fromUTF8('application/vnd.bluetooth.ep.oob');this.MIME_VCARD_STR_ARR=['text/vcard','text/x-vCard','text/x-vcard'];this.SMARTPOSTER_ACTION=nfcUtils.fromUTF8('act');this.URIS[0x00]='';this.URIS[0x01]='http://www.';this.URIS[0x02]='https://www.';this.URIS[0x03]='http://';this.URIS[0x04]='https://';this.URIS[0x05]='tel:';this.URIS[0x06]='mailto:';this.URIS[0x07]='ftp://anonymous:anonymous@';this.URIS[0x08]='ftp://ftp.';this.URIS[0x09]='ftps://';this.URIS[0x0A]='sftp://';this.URIS[0x0B]='smb://';this.URIS[0x0C]='nfs://';this.URIS[0x0D]='ftp://';this.URIS[0x0E]='dav://';this.URIS[0x0F]='news:';this.URIS[0x10]='telnet://';this.URIS[0x11]='imap:';this.URIS[0x12]='rtsp://';this.URIS[0x13]='urn:';this.URIS[0x14]='pop:';this.URIS[0x15]='sip:';this.URIS[0x16]='sips:';this.URIS[0x17]='tftp:';this.URIS[0x18]='btspp://';this.URIS[0x19]='btl2cap://';this.URIS[0x1A]='btgoep://';this.URIS[0x1B]='tcpobex://';this.URIS[0x1C]='irdaobex://';this.URIS[0x1D]='file://';this.URIS[0x1E]='urn:epc:id:';this.URIS[0x1F]='urn:epc:tag:';this.URIS[0x20]='urn:epc:pat:';this.URIS[0x21]='urn:epc:raw:';this.URIS[0x22]='urn:epc:';this.URIS[0x23]='urn:nfc:';},payload:{decode:function decode(tnf,type,payload){var nfcUtils=new NfcUtils();var decodedPayload={type:'empty'};switch(tnf){case NDEF.TNF_WELL_KNOWN:decodedPayload=this.decodeWellKnown(type,payload);break;case NDEF.TNF_MIME_MEDIA:decodedPayload=this.decodeMIME(type,payload);break;case NDEF.TNF_ABSOLUTE_URI:case NDEF.TNF_EXTERNAL_TYPE:decodedPayload={type:nfcUtils.toUTF8(type)};break;case NDEF.TNF_UNKNOWN:decodedPayload={};break;case NDEF.TNF_UNCHANGED:decodedPayload=null;break;}
return decodedPayload;},decodeWellKnown:function decodeWellKnown(type,payload){var nfcUtils=new NfcUtils();if(nfcUtils.equalArrays(type,NDEF.RTD_TEXT)){return this.decodeText(payload);}else if(nfcUtils.equalArrays(type,NDEF.RTD_URI)){return this.decodeURI(payload);}else if(nfcUtils.equalArrays(type,NDEF.RTD_SMART_POSTER)){return this.decodeSmartPoster(payload);}
return null;},decodeText:function decodeText(payload){var nfcUtils=new NfcUtils();var decoded={type:'text'};var langLen=payload[0]&NDEF.RTD_TEXT_IANA_LENGTH;decoded.language=nfcUtils.toUTF8(payload.subarray(1,langLen+1));var encoding=(payload[0]&NDEF.RTD_TEXT_ENCODING)!==0?1:0;if(encoding===NDEF.RTD_TEXT_UTF8){decoded.text=nfcUtils.toUTF8(payload.subarray(langLen+1));decoded.encoding='UTF-8';}else if(encoding===NDEF.RTD_TEXT_UTF16){decoded.text=nfcUtils.UTF16BytesToStr(payload.subarray(langLen+
1));decoded.encoding='UTF-16';}
return decoded;},decodeURI:function decodeURI(payload){var nfcUtils=new NfcUtils();var prefix=NDEF.URIS[payload[0]];if(prefix===undefined){return null;}
var suffix=nfcUtils.toUTF8(payload.subarray(1));return{type:'uri',uri:prefix+suffix};},decodeSmartPoster:function decodeSmartPoster(payload){var nfcUtils=new NfcUtils();var buffer=new NfcBuffer(payload);var records=nfcUtils.parseNDEF(buffer);var URIRecords=records.filter(function(record){return nfcUtils.equalArrays(record.type,NDEF.RTD_URI);});if(URIRecords.length!==1){return null;}
var uriPoster={type:'smartposter',uri:NDEF.payload.decodeURI(URIRecords[0].payload).uri};return records.reduce((poster,record)=>{var typeStr=nfcUtils.toUTF8(record.type);if(nfcUtils.equalArrays(record.type,NDEF.RTD_TEXT)){poster.text=poster.text||{};var textData=NDEF.payload.decodeText(record.payload);if(poster.text[textData.language]){return null;}
poster.text[textData.language]=textData.text;}else if('act'===typeStr){poster.action=record.payload[0];}else if(NDEF.TNF_MIME_MEDIA===record.tnf){poster.icons=poster.icons||[];poster.icons.push({type:nfcUtils.toUTF8(record.type),bytes:record.payload});}
return poster;},uriPoster);},decodeMIME:function docodeMIME(type,payload){var nfcUtils=new NfcUtils();var typeStr=(typeof type==='string')?type:nfcUtils.toUTF8(type);if(NDEF.MIME_VCARD_STR_ARR.indexOf(typeStr)!==-1){return{type:'text/vcard',blob:new Blob([nfcUtils.toUTF8(payload)],{type:'text/vcard'})};}
return{type:typeStr};}}};function NfcBuffer(array){this.uint8array=new Uint8Array(array);this.offset=0;}
NfcBuffer.prototype={uint8array:null,offset:0,getOctet:function getOctet(){if(this.offset==this.uint8array.length){throw Error('NfcBuffer too small');}
return this.uint8array[this.offset++];},getOctetArray:function getOctetArray(len){if(typeof len!=='number'||len<0||this.offset+len>this.uint8array.length){throw Error('NfcBuffer too small');}
return this.uint8array.subarray(this.offset,this.offset+=len);},skip:function skip(len){if(typeof len!=='number'||len<0||this.offset+len>this.uint8array.length){throw Error('NfcBuffer too small');}
this.offset+=len;},peek:function peek(){if(this.offset===this.uint8array.length){throw Error('NfcBuffer too small');}
return this.uint8array[this.offset];}};function NfcUtils(){}
NfcUtils.prototype={fromUTF8:function fromUTF8(str){if(!str){return null;}
var enc=new TextEncoder('utf-8');return enc.encode(str);},toUTF8:function toUTF8(a){if(!a){return null;}
if(this.equalArrays(a.subarray(0,3),[0xEF,0xBB,0xBF])){a=a.subarray(3);}
var dec=new TextDecoder('utf-8');return dec.decode(a);},UTF16BytesToStr:function UTF16BytesToStr(array){if(!array){return null;}
var le=false;var possibleBom=array.subarray(0,2);if(this.equalArrays(possibleBom,[0xFF,0xFE])){array=array.subarray(2);le=true;}else if(this.equalArrays(possibleBom,[0xFE,0xFF])){array=array.subarray(2);}
var encoding=(le)?'utf-16le':'utf-16be';var dec=new TextDecoder(encoding);return dec.decode(array);},strToUTF16Bytes:function strToUTF16Bytes(str){if(!str){return null;}
var enc=new TextEncoder('utf-16be');return enc.encode(str);},equalArrays:function equalArrays(a1,a2){if(!a1||!a2){return false;}
if(a1.length!==a2.length){return false;}
for(var i=0;i<a1.length;i++){if(a1[i]!==a2[i]){return false;}}
return true;},encodeNDEF:function encodeNDEF(records){var result=[];function getTnfNum(tnfString){var tnf=[NDEF.TNF_EMPTY,NDEF.TNF_WELL_KNOWN,NDEF.TNF_MIME_MEDIA,NDEF.TNF_ABSOLUTE_URI,NDEF.TNF_EXTERNAL_TYPE,NDEF.TNF_UNKNOWN,NDEF.TNF_UNCHANGED,NDEF.TNF_RESERVED];return tnf.indexOf(tnfString);}
records.forEach((record,recordIndex)=>{record.payload=record.payload||[];record.id=record.id||[];record.type=record.type||[];var payloadLen=record.payload.length;var idLen=record.id.length;var typeLen=record.type.length;var firstOctet=getTnfNum(record.tnf)&0x07;firstOctet|=(recordIndex===0)?NDEF.MB:0;firstOctet|=(recordIndex===records.length-1)?NDEF.ME:0;firstOctet|=(idLen>0)?NDEF.IL:0;firstOctet|=(payloadLen<=0xFF)?NDEF.SR:0;result.push(firstOctet);result.push(typeLen);for(var p=(payloadLen>0xFF?3:0);p>=0;p-=1){result.push((payloadLen>>>(8*p))&0xFF);}
if(idLen>0){result.push(idLen);}
result.push.apply(result,record.type);result.push.apply(result,record.id);result.push.apply(result,record.payload);});return result;},parseNDEF:function parseNDEF(buffer){try{return this._doParseNDEF(buffer);}catch(err){console.error('[NfcUtils]: '+err);return null;}},_doParseNDEF:function doParseNDEF(buffer){var records=[];var isFirstRecord=true;var firstOctet;do{firstOctet=buffer.peek();if(isFirstRecord&&!(firstOctet&NDEF.MB)){throw Error('MB bit not set in first NDEF record');}
if(!isFirstRecord&&(firstOctet&NDEF.MB)){throw Error('MB can only be set for the first record');}
if(firstOctet&NDEF.CF){throw Error('Chunked payloads are not supported');}
records.push(this._parseNDEFRecord(buffer));isFirstRecord=false;}while(!(firstOctet&NDEF.ME));if(buffer.offset<buffer.uint8array.length){throw Error('ME bit set on non-last record');}
return records;},_parseNDEFRecord:function parseNDEFRecord(buffer){var tnfArray=[NDEF.TNF_EMPTY,NDEF.TNF_WELL_KNOWN,NDEF.TNF_MIME_MEDIA,NDEF.TNF_ABSOLUTE_URI,NDEF.TNF_EXTERNAL_TYPE,NDEF.TNF_UNKNOWN,NDEF.TNF_UNCHANGED,NDEF.TNF_RESERVED];var firstOctet=buffer.getOctet();var typeLen=buffer.getOctet();var payloadLen=buffer.getOctet();if(!(firstOctet&NDEF.SR)){for(var i=0;i<3;i++){payloadLen<<=8;payloadLen|=buffer.getOctet();}}
var idLen=0;if(firstOctet&NDEF.IL){idLen=buffer.getOctet();}
var tnf=firstOctet&NDEF.TNF;var type=buffer.getOctetArray(typeLen);var id=buffer.getOctetArray(idLen);var payload=buffer.getOctetArray(payloadLen);return new MozNDEFRecord({tnf:tnfArray[tnf],type:type||undefined,id:id||undefined,payload:payload||undefined});},parseURIString:function parseURIString(url){if(!url){return;}
var content=url;for(var i=1;i<NDEF.URIS.length;i++){var len=NDEF.URIS[i].length;if(url.substring(0,len)==NDEF.URIS[i]){var uriPayload=url.substring(len);content=String.fromCharCode(i)+uriPayload;break;}}
var payload=StringHelper.fromUTF8(content);var record=new MozNDEFRecord({tnf:NDEF.TNF_WELL_KNOWN,type:NDEF.RTD_URI,payload:payload});if(!record){return null;}
return[record];}};NDEF.init();exports.NfcBuffer=NfcBuffer;exports.NfcUtils=NfcUtils;exports.NDEF=NDEF;})(window);;'use strict';function eventSafety(obj,event,callback,timeout){var finishTimeout;function done(e){if(e&&e.type==='transitionend'&&e.target!==obj){return;}
clearTimeout(finishTimeout);obj.removeEventListener(event,done);callback.apply(this,arguments);}
obj.addEventListener(event,done);finishTimeout=setTimeout(done,timeout);};'use strict';var GestureDetector=(function(){function GD(e,options){this.element=e;this.options=options||{};this.options.panThreshold=this.options.panThreshold||GD.PAN_THRESHOLD;this.state=initialState;this.timers={};}
GD.prototype.startDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.addEventListener(t,self);});};GD.prototype.stopDetecting=function(){var self=this;eventtypes.forEach(function(t){self.element.removeEventListener(t,self);});};GD.prototype.handleEvent=function(e){var handler=this.state[e.type];if(!handler){return;}
if(e.changedTouches){if(e.type==='touchend'&&e.changedTouches.length>1){console.warn('gesture_detector.js: spurious extra changed touch on '+'touchend. See '+'https://bugzilla.mozilla.org/show_bug.cgi?id=785554');}
for(var i=0;i<e.changedTouches.length;i++){handler(this,e,e.changedTouches[i]);handler=this.state[e.type];}}
else{handler(this,e);}};GD.prototype.startTimer=function(type,time){this.clearTimer(type);var self=this;this.timers[type]=setTimeout(function(){self.timers[type]=null;var handler=self.state[type];if(handler){handler(self,type);}},time);};GD.prototype.clearTimer=function(type){if(this.timers[type]){clearTimeout(this.timers[type]);this.timers[type]=null;}};GD.prototype.switchTo=function(state,event,touch){this.state=state;if(state.init){state.init(this,event,touch);}};GD.prototype.emitEvent=function(type,detail){if(!this.target){console.error('Attempt to emit event with no target');return;}
var event=this.element.ownerDocument.createEvent('CustomEvent');event.initCustomEvent(type,true,true,detail);this.target.dispatchEvent(event);};GD.HOLD_INTERVAL=1000;GD.PAN_THRESHOLD=20;GD.DOUBLE_TAP_DISTANCE=50;GD.DOUBLE_TAP_TIME=500;GD.VELOCITY_SMOOTHING=0.5;GD.SCALE_THRESHOLD=20;GD.ROTATE_THRESHOLD=22.5;GD.THRESHOLD_SMOOTHING=0.9;var abs=Math.abs,floor=Math.floor,sqrt=Math.sqrt,atan2=Math.atan2;var PI=Math.PI;var eventtypes=['touchstart','touchmove','touchend'];function eventTime(e){var ts=e.timeStamp;if(ts>2*Date.now()){return Math.floor(ts/1000);}else{return ts;}}
function coordinates(e,t){return Object.freeze({screenX:t.screenX,screenY:t.screenY,clientX:t.clientX,clientY:t.clientY,timeStamp:eventTime(e)});}
function midpoints(e,t1,t2){return Object.freeze({screenX:floor((t1.screenX+t2.screenX)/2),screenY:floor((t1.screenY+t2.screenY)/2),clientX:floor((t1.clientX+t2.clientX)/2),clientY:floor((t1.clientY+t2.clientY)/2),timeStamp:eventTime(e)});}
function between(c1,c2){var r=GD.THRESHOLD_SMOOTHING;return Object.freeze({screenX:floor(c1.screenX+r*(c2.screenX-c1.screenX)),screenY:floor(c1.screenY+r*(c2.screenY-c1.screenY)),clientX:floor(c1.clientX+r*(c2.clientX-c1.clientX)),clientY:floor(c1.clientY+r*(c2.clientY-c1.clientY)),timeStamp:floor(c1.timeStamp+r*(c2.timeStamp-c1.timeStamp))});}
function touchDistance(t1,t2){var dx=t2.screenX-t1.screenX;var dy=t2.screenY-t1.screenY;return sqrt(dx*dx+dy*dy);}
function touchDirection(t1,t2){return atan2(t2.screenY-t1.screenY,t2.screenX-t1.screenX)*180/PI;}
function touchRotation(d1,d2){var angle=d2-d1;if(angle>180){angle-=360;}else if(angle<=-180){angle+=360;}
return angle;}
function isDoubleTap(lastTap,thisTap){var dx=abs(thisTap.screenX-lastTap.screenX);var dy=abs(thisTap.screenY-lastTap.screenY);var dt=thisTap.timeStamp-lastTap.timeStamp;return(dx<GD.DOUBLE_TAP_DISTANCE&&dy<GD.DOUBLE_TAP_DISTANCE&&dt<GD.DOUBLE_TAP_TIME);}
var initialState={name:'initialState',init:function(d){d.target=null;d.start=d.last=null;d.touch1=d.touch2=null;d.vx=d.vy=null;d.startDistance=d.lastDistance=null;d.startDirection=d.lastDirection=null;d.lastMidpoint=null;d.scaled=d.rotated=null;},touchstart:function(d,e,t){d.switchTo(touchStartedState,e,t);}};var touchStartedState={name:'touchStartedState',init:function(d,e,t){d.target=e.target;d.touch1=t.identifier;d.start=d.last=coordinates(e,t);if(d.options.holdEvents){d.startTimer('holdtimeout',GD.HOLD_INTERVAL);}},touchstart:function(d,e,t){d.clearTimer('holdtimeout');d.switchTo(transformState,e,t);},touchmove:function(d,e,t){if(t.identifier!==d.touch1){return;}
if(abs(t.screenX-d.start.screenX)>d.options.panThreshold||abs(t.screenY-d.start.screenY)>d.options.panThreshold){d.clearTimer('holdtimeout');d.switchTo(panStartedState,e,t);}},touchend:function(d,e,t){if(t.identifier!==d.touch1){return;}
if(d.lastTap&&isDoubleTap(d.lastTap,d.start)){d.emitEvent('tap',d.start);d.emitEvent('dbltap',d.start);d.lastTap=null;}
else{d.emitEvent('tap',d.start);d.lastTap=coordinates(e,t);}
d.clearTimer('holdtimeout');d.switchTo(initialState);},holdtimeout:function(d){d.switchTo(holdState);}};var panStartedState={name:'panStartedState',init:function(d,e,t){d.start=d.last=between(d.start,coordinates(e,t));if(e.type==='touchmove'){panStartedState.touchmove(d,e,t);}},touchmove:function(d,e,t){if(t.identifier!==d.touch1){return;}
var current=coordinates(e,t);d.emitEvent('pan',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});var dt=current.timeStamp-d.last.timeStamp;var vx=(current.screenX-d.last.screenX)/dt;var vy=(current.screenY-d.last.screenY)/dt;if(d.vx==null){d.vx=vx;d.vy=vy;}
else{d.vx=d.vx*GD.VELOCITY_SMOOTHING+
vx*(1-GD.VELOCITY_SMOOTHING);d.vy=d.vy*GD.VELOCITY_SMOOTHING+
vy*(1-GD.VELOCITY_SMOOTHING);}
d.last=current;},touchend:function(d,e,t){if(t.identifier!==d.touch1){return;}
var current=coordinates(e,t);var dx=current.screenX-d.start.screenX;var dy=current.screenY-d.start.screenY;var angle=atan2(dy,dx)*180/PI;if(angle<0){angle+=360;}
var direction;if(angle>=315||angle<45){direction='right';}else if(angle>=45&&angle<135){direction='down';}else if(angle>=135&&angle<225){direction='left';}else if(angle>=225&&angle<315){direction='up';}
d.emitEvent('swipe',{start:d.start,end:current,dx:dx,dy:dy,dt:e.timeStamp-d.start.timeStamp,vx:d.vx,vy:d.vy,direction:direction,angle:angle});d.switchTo(initialState);}};var holdState={name:'holdState',init:function(d){d.emitEvent('holdstart',d.start);},touchmove:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdmove',{absolute:{dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY},relative:{dx:current.screenX-d.last.screenX,dy:current.screenY-d.last.screenY},position:current});d.last=current;},touchend:function(d,e,t){var current=coordinates(e,t);d.emitEvent('holdend',{start:d.start,end:current,dx:current.screenX-d.start.screenX,dy:current.screenY-d.start.screenY});d.switchTo(initialState);}};var transformState={name:'transformState',init:function(d,e,t){d.touch2=t.identifier;var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);d.startDistance=d.lastDistance=touchDistance(t1,t2);d.startDirection=d.lastDirection=touchDirection(t1,t2);d.scaled=d.rotated=false;},touchmove:function(d,e,t){if(t.identifier!==d.touch1&&t.identifier!==d.touch2){return;}
var t1=e.touches.identifiedTouch(d.touch1);var t2=e.touches.identifiedTouch(d.touch2);var midpoint=midpoints(e,t1,t2);var distance=touchDistance(t1,t2);var direction=touchDirection(t1,t2);var rotation=touchRotation(d.startDirection,direction);if(!d.scaled){if(abs(distance-d.startDistance)>GD.SCALE_THRESHOLD){d.scaled=true;d.startDistance=d.lastDistance=floor(d.startDistance+
GD.THRESHOLD_SMOOTHING*(distance-d.startDistance));}else{distance=d.startDistance;}}
if(!d.rotated){if(abs(rotation)>GD.ROTATE_THRESHOLD){d.rotated=true;}else{direction=d.startDirection;}}
if(d.scaled||d.rotated){d.emitEvent('transform',{absolute:{scale:distance/d.startDistance,rotate:touchRotation(d.startDirection,direction)},relative:{scale:distance/d.lastDistance,rotate:touchRotation(d.lastDirection,direction)},midpoint:midpoint});d.lastDistance=distance;d.lastDirection=direction;d.lastMidpoint=midpoint;}},touchend:function(d,e,t){if(t.identifier===d.touch2){d.touch2=null;}else if(t.identifier===d.touch1){d.touch1=d.touch2;d.touch2=null;}else{return;}
if(d.scaled||d.rotated){d.emitEvent('transformend',{absolute:{scale:d.lastDistance/d.startDistance,rotate:touchRotation(d.startDirection,d.lastDirection)},relative:{scale:1,rotate:0},midpoint:d.lastMidpoint});}
d.switchTo(afterTransformState);}};var afterTransformState={name:'afterTransformState',touchstart:function(d,e,t){d.switchTo(transformState,e,t);},touchend:function(d,e,t){if(t.identifier===d.touch1){d.switchTo(initialState);}}};return GD;}());;'use strict';var SettingsListener={_timer:null,_lock:null,_observers:[],getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));var settingChanged=function settingChanged(evt){callback(evt.settingValue);};settings.addObserver(name,settingChanged);this._observers.push({name:name,callback:callback,observer:settingChanged});},unobserve:function sl_unobserve(name,callback){var settings=window.navigator.mozSettings;var that=this;this._observers.forEach(function(value,index){if(value.name===name&&value.callback===callback){settings.removeObserver(name,value.observer);that._observers.splice(index,1);}});}};;'use strict';var CustomDialog=(function(){var container=null;var screen=null;var dialog=null;var header=null;var message=null;var yes=null;var no=null;return{hide:function dialog_hide(){if(screen===null){return;}
if(!container){container=document.body;}
container.removeChild(screen);screen=null;dialog=null;header=null;message=null;yes=null;no=null;},show:function dialog_show(title,msg,cancel,confirm,containerElement){container=containerElement||document.body;if(screen===null){screen=document.createElement('form');screen.setAttribute('role','dialog');screen.setAttribute('data-type','confirm');screen.id='dialog-screen';dialog=document.createElement('section');screen.appendChild(dialog);var decorateWithOptions=function cd_decorateWithOptions(type,options,elm,dialog){if('string'===typeof options){elm.setAttribute('data-l10n-id',options);return elm;}
var icon=options.icon;var textElm=elm;if(icon&&''!==icon){textElm=document.createElement('span');var iconImg=new Image();iconImg.src=icon;iconImg.classList.add('custom-dialog-'+type+'-icon');elm.insertBefore(iconImg,elm.firstChild);elm.appendChild(textElm);}
if(options.id){navigator.mozL10n.setAttributes(textElm,options.id,options.args);}else{var text=options[type];textElm.textContent=text;}
return elm;};var setElementText=function(element,options){if('string'===typeof options){element.setAttribute('data-l10n-id',options);}
if(options.id){navigator.mozL10n.setAttributes(element,options.id,options.args);}};header=document.createElement('h1');header.id='dialog-title';if(title&&title!==''){header=decorateWithOptions('title',title,header,dialog);}
dialog.appendChild(header);message=document.createElement('p');message.id='dialog-message';message=decorateWithOptions('message',msg,message,dialog);dialog.appendChild(message);var menu=document.createElement('menu');menu.dataset.items=1;no=document.createElement('button');no.type='button';setElementText(no,cancel.title);no.id='dialog-no';no.addEventListener('click',clickHandler);menu.appendChild(no);if(confirm){menu.dataset.items=2;yes=document.createElement('button');yes.type='button';setElementText(yes,confirm.title);yes.id='dialog-yes';yes.className=confirm.recommend?'recommend':'danger';yes.addEventListener('click',clickHandler);menu.appendChild(yes);}
else{no.classList.add('full');}
screen.appendChild(menu);container.appendChild(screen);}
screen.classList.add('visible');function clickHandler(evt){screen.classList.remove('visible');if(evt.target===yes&&confirm.callback){confirm.callback();}else if(evt.target===no&&cancel.callback){cancel.callback();}}
return screen;}};}());;(function(window){'use strict';window.NotificationHelper={getIconURI:function nh_getIconURI(app,entryPoint){var icons=app.manifest.icons;if(entryPoint){icons=app.manifest.entry_points[entryPoint].icons;}
if(!icons){return null;}
var sizes=Object.keys(icons).map(function parse(str){return parseInt(str,10);});sizes.sort(function(x,y){return y-x;});var HVGA=document.documentElement.clientWidth<480;var index=sizes[HVGA?sizes.length-1:0];return app.installOrigin+icons[index];},send:function nh_send(titleL10n,options){return new Promise(function(resolve,reject){navigator.mozL10n.once(function(){var title=getL10n(titleL10n);if(options.bodyL10n){options.body=getL10n(options.bodyL10n);}
options.dir=navigator.mozL10n.language.direction;options.lang=navigator.mozL10n.language.code;var notification=new window.Notification(title,options);if(options.closeOnClick!==false){notification.addEventListener('click',function nh_click(){notification.removeEventListener('click',nh_click);notification.close();});}
resolve(notification);});});},};function getL10n(l10nAttrs){if(typeof l10nAttrs==='string'){return navigator.mozL10n.get(l10nAttrs);}
if(l10nAttrs.raw){return l10nAttrs.raw;}
return navigator.mozL10n.get(l10nAttrs.id,l10nAttrs.args);}})(this);;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var MobileInfo={brazil:{carriers:{'00':'NEXTEL','02':'TIM','03':'TIM','04':'TIM','05':'CLARO','06':'VIVO','07':'CTBC','08':'TIM','10':'VIVO','11':'VIVO','15':'SERCOMTEL','16':'OI','23':'VIVO','24':'OI','31':'OI','32':'CTBC','33':'CTBC','34':'CTBC','37':'AEIOU'},regions:{'11':'SP','12':'SP','13':'SP','14':'SP','15':'SP','16':'SP','17':'SP','18':'SP','19':'SP','21':'RJ','22':'RJ','24':'RJ','27':'ES','28':'ES','31':'MG','32':'MG','33':'MG','34':'MG','35':'MG','37':'MG','38':'MG','41':'PR','42':'PR','43':'PR','44':'PR','45':'PR','46':'PR','47':'SC','48':'SC','49':'SC','51':'RS','53':'RS','54':'RS','55':'RS','61':'DF','62':'GO','63':'TO','64':'GO','65':'MT','66':'MT','67':'MS','68':'AC','69':'RO','71':'BA','73':'BA','74':'BA','75':'BA','77':'BA','79':'SE','81':'PE','82':'AL','83':'PB','84':'RN','85':'CE','86':'PI','87':'PE','88':'CE','89':'PI','91':'PA','92':'AM','93':'PA','94':'PA','95':'RR','96':'AP','97':'AM','98':'MA','99':'MA'}}};var MobileOperator={BRAZIL_MCC:'724',BRAZIL_CELLBROADCAST_CHANNEL:50,userFacingInfo:function mo_userFacingInfo(mobileConnection){var network=mobileConnection.voice.network;var iccid=mobileConnection.iccId;var iccObj=navigator.mozIccManager.getIccById(iccid);var iccInfo=iccObj?iccObj.iccInfo:null;var operator=network?(network.shortName||network.longName):null;if(operator&&iccInfo&&iccInfo.isDisplaySpnRequired&&iccInfo.spn){if(iccInfo.isDisplayNetworkNameRequired&&operator!==iccInfo.spn){operator=operator+' '+iccInfo.spn;}else{operator=iccInfo.spn;}}
var carrier,region;if(this.isBrazil(mobileConnection)){var lac=mobileConnection.voice.cell.gsmLocationAreaCode%100;var carriers=MobileInfo.brazil.carriers;var regions=MobileInfo.brazil.regions;carrier=carriers[network.mnc]||(this.BRAZIL_MCC+network.mnc);region=(regions[lac]?regions[lac]+' '+lac:'');}
return{'operator':operator,'carrier':carrier,'region':region};},isBrazil:function mo_isBrazil(mobileConnection){var cell=mobileConnection.voice.cell;var net=mobileConnection.voice.network;return net?(net.mcc===this.BRAZIL_MCC&&cell&&cell.gsmLocationAreaCode):null;}};;(function(exports){'use strict';function ManifestHelper_get(prop){var manifest=this;var value=manifest[prop];var lang=navigator.mozL10n.language.code||'';if(lang in navigator.mozL10n.qps&&(prop==='name'||prop==='description'||prop=='short_name')){value=navigator.mozL10n.qps[navigator.language].translate(value);}else if(manifest.locales){[lang,lang.substr(0,lang.indexOf('-'))].some(function tryLanguage(lang){if(this[lang]&&this[lang][prop]){value=this[lang][prop];return true;}},manifest.locales);}
if(typeof value==='object'&&!(value instanceof Array)){value=new ManifestHelper(value);}
return value;}
function ManifestHelper(manifest){for(var prop in manifest){Object.defineProperty(this,prop,{get:ManifestHelper_get.bind(manifest,prop),enumerable:true});}}
Object.defineProperty(ManifestHelper.prototype,'displayName',{get:function displayName(){return this.short_name||this.name;}});exports.ManifestHelper=ManifestHelper;}(window));;'use strict';(function(exports){var _iccManager=navigator.mozIccManager;var _iccProxy=null;Object.defineProperty(exports,'IccHelper',{configurable:true,get:function(){return _iccProxy;},set:function(value){_iccProxy=value;}});if(_iccManager&&_iccManager.getIccById){var activeIccObj=null;var eventListeners={};var cachedEventListeners={};var events=['cardstatechange','iccinfochange','stkcommand','stksessionend'];var getters=['iccInfo','cardState'];var methods=['sendStkResponse','sendStkMenuSelection','sendStkTimerExpiration','sendStkEventDownload'];var domRequests=['getCardLock','unlockCardLock','setCardLock','getCardLockRetryCount','readContacts','updateContact','iccOpenChannel','iccExchangeAPDU','iccCloseChannel'];var getterTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name];}else{return null;}};};var methodTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name].apply(activeIccObj,arguments);}};};var createIccProxy=function(){var iccProxy={addEventListener:function(eventName,callback){if(typeof callback!=='function'){return;}
if(events.indexOf(eventName)===-1){return;}
var listeners=eventListeners[eventName];if(listeners==null){listeners=eventListeners[eventName]=[];}
if(listeners.indexOf(callback)===-1){listeners.push(callback);}},removeEventListener:function(eventName,callback){var listeners=eventListeners[eventName];if(listeners){var index=listeners.indexOf(callback);if(index!==-1){listeners.splice(index,1);}}}};getters.forEach(function(getter){Object.defineProperty(iccProxy,getter,{enumerable:true,get:getterTemplate(getter)});});methods.forEach(function(method){iccProxy[method]=methodTemplate(method);});domRequests.forEach(function(request){iccProxy[request]=methodTemplate(request);});events.forEach(function(eventName){Object.defineProperty(iccProxy,'on'+eventName,{enumerable:true,set:function(newListener){var oldListener=cachedEventListeners[eventName];if(oldListener){iccProxy.removeEventListener(eventName,oldListener);}
cachedEventListeners[eventName]=newListener;if(newListener){iccProxy.addEventListener(eventName,newListener);}},get:function(){return cachedEventListeners[eventName];}});});return iccProxy;};_iccProxy=createIccProxy();if(_iccManager.iccIds&&_iccManager.iccIds.length){activeIccObj=_iccManager.getIccById(_iccManager.iccIds[0]);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});}}
_iccManager.oniccdetected=function(event){if(_iccProxy.cardState==null){activeIccObj=_iccManager.getIccById(event.iccId);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});['cardstatechange','iccinfochange'].forEach(function(eventName){if(eventListeners[eventName]){eventListeners[eventName].forEach(function(listener){listener();});}});}}};}else{_iccProxy=_iccManager;}})(window);;'use strict';var STKHelper={getIconCanvas:function(mozStkIcon){if(!mozStkIcon||!mozStkIcon.pixels||!mozStkIcon.width||!mozStkIcon.height){return null;}
if(mozStkIcon.pixels.length<(mozStkIcon.width*mozStkIcon.height)){console.error('Not enough pixels for the required dimension: '+
mozStkIcon.width+'x'+mozStkIcon.height);return null;}
if(!mozStkIcon.codingScheme){mozStkIcon.codingScheme='basic';}
var canvas=document.createElement('canvas');canvas.setAttribute('width',mozStkIcon.width);canvas.setAttribute('height',mozStkIcon.height);var ctx=canvas.getContext('2d',{willReadFrequently:true});var imageData=ctx.createImageData(mozStkIcon.width,mozStkIcon.height);var pixel=0,pos=0;var data=imageData.data;for(var y=0;y<mozStkIcon.height;y++){for(var x=0;x<mozStkIcon.width;x++){data[pos++]=(mozStkIcon.pixels[pixel]&0xFF000000)>>>24;data[pos++]=(mozStkIcon.pixels[pixel]&0xFF0000)>>>16;data[pos++]=(mozStkIcon.pixels[pixel]&0xFF00)>>>8;data[pos++]=(mozStkIcon.pixels[pixel]&0xFF);pixel++;}}
ctx.putImageData(imageData,0,0);return canvas;},getMessageText:function(stkMessage,defaultMsgL10nId,defaultMsgL10nArgs){if(this.isIconSelfExplanatory(stkMessage)){return'';}
var text;if(stkMessage==='string'||stkMessage instanceof String){text=stkMessage;}else{text=stkMessage?stkMessage.text:'';}
if(!text&&defaultMsgL10nId){var _=navigator.mozL10n.get;text=_(defaultMsgL10nId,defaultMsgL10nArgs);}
return text;},isIconSelfExplanatory:function(stkMessage){return(stkMessage&&stkMessage.icons&&stkMessage.iconSelfExplanatory);},getFirstIconRawData:function(stkItem){return stkItem.icons&&stkItem.icons.length>0?stkItem.icons[0]:null;}};;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','video/3gpp2':'3g2','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','3g2':'video/3gpp2','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;'use strict';function SettingsURL(){this._url=null;this._isBlob=false;}
SettingsURL.prototype={set:function(value){if(this._isBlob){window.URL.revokeObjectURL(this._url);}
if(value instanceof Blob){this._isBlob=true;this._url=window.URL.createObjectURL(value);}else{this._isBlob=false;this._url=value;}
return this._url;},get:function(){return this._url;}};;'use strict';var advanced_timer={timers:{},start:function(timerId,timeout,callback){if(typeof(callback)!='function'){callback=function(){};}
var self=this;var _id=setTimeout(function advTimer(){var realUsedTime=new Date().getTime()-self.timers[timerId].timestamp;delete(self.timers[timerId]);callback(realUsedTime);},timeout);this.timers[timerId]={'timeout':timeout,'internalTimerId':_id,'timestamp':new Date().getTime()};},stop:function(timerId){var timer=this.timers[timerId];if(!timer){return 0;}
clearTimeout(timer.internalTimerId);var pendingTime=this.queryPendingTime();delete(this.timers[timerId]);return pendingTime;},queryPendingTime:function(timerId){var timer=this.timers[timerId];if(!timer){return 0;}
return timer.timeout-(new Date().getTime()-timer.timestamp);}};;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined'){return this._isOnRealDevice;}
if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name]&&this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media){continue;}
window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;'use strict';var IACHandler={_eventPrefix:'iac-',_ports:{},init:function onInit(){var self=this;window.navigator.mozSetMessageHandler('connection',function onConnected(request){var keyword=request.keyword;var port=request.port;self._ports[keyword]=port;port.onmessage=function onReceivedMessage(evt){var message=evt.data;var evtName=self._eventPrefix+keyword;var iacEvt=document.createEvent('CustomEvent');iacEvt.initCustomEvent(evtName,true,false,message);window.dispatchEvent(iacEvt);};});},getPort:function(keyword){return this._ports[keyword];}};IACHandler.init();;(function(exports){'use strict';var NETWORK_TYPES=[null,'gprs','edge','umts','is95a','is95b','1xrtt','evdo0','evdoa','hsdpa','hsupa','hspa','evdob','ehrpd','lte','hspa+','gsm'];function ah_filterByBearer(apns,type){var typeIdx=NETWORK_TYPES.indexOf(type);for(var i=0;i<apns.length;i++){var bearer=apns[i].bearer?+apns[i].bearer:0;if(bearer&&(bearer!==typeIdx)){apns.splice(i,1);}}}
function ah_getCompatible(list,mcc,mnc,type){var apns=list[mcc]?(list[mcc][mnc]||[]):[];ah_filterByBearer(apns,type);return apns;}
var ApnHelper={getCompatible:ah_getCompatible};exports.ApnHelper=ApnHelper;})(this);;'use strict';var Tagged={_entity:/[&<>"'/]/g,_entities:{'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&apos;','/':'&#x2F;'},getEntity:function(s){return Tagged._entities[s];},escapeHTML:function(strings,...values){var result='';for(var i=0;i<strings.length;i++){result+=strings[i];if(i<values.length){result+=String(values[i]).replace(Tagged._entity,Tagged.getEntity);}}
return result;}};;var DateHelper={todayStarted:function dh_todayStarted(){var now=(new Date()).valueOf();return this.getMidnight(now);},yesterdayStarted:function dh_yesterdayStarted(){var now=(new Date()).valueOf();var dayAgo=now-86400000;return this.getMidnight(dayAgo);},thisWeekStarted:function dh_thisWeekStarted(){var now=new Date();var dayOfTheWeek=now.getDay();var firstDay=new Date(now.getFullYear(),now.getMonth(),now.getDate()-dayOfTheWeek);return this.getMidnight(firstDay);},thisMonthStarted:function dh_thisMonthStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),now.getMonth(),1).valueOf());return firstDay;},lastSixMonthsStarted:function dh_lastSixMonthsStarted(){var now=new Date().valueOf();var sixMonthsAgo=now-2629743830*6;return sixMonthsAgo;},thisYearStarted:function dh_thisYearStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),0).valueOf());return firstDay;},getMidnight:function dh_getMidnight(timestamp){var day=new Date(timestamp);var midnight=(new Date(day.getFullYear(),day.getMonth(),day.getDate(),0).valueOf());return midnight;}};var NumberHelper={zfill:function nh_zfill(string,len){var s=string;while(s.length<len)s='0'+s;return s;}};var HtmlHelper={createHighlightHTML:function ut_createHighlightHTML(text,searchRegExp){if(!searchRegExp){return this.escapeHTML(text);}
searchRegExp=new RegExp(searchRegExp,'gi');var sliceStrs=text.split(searchRegExp);var patterns=text.match(searchRegExp);if(!patterns){return this.escapeHTML(text);}
var str='';for(var i=0;i<patterns.length;i++){str=str+
this.escapeHTML(sliceStrs[i])+'<span class="highlight">'+
this.escapeHTML(patterns[i])+'</span>';}
str+=this.escapeHTML(sliceStrs.pop());return str;},escapeHTML:function ut_escapeHTML(str,escapeQuotes){var span=document.createElement('span');span.textContent=str;span.innerHTML=span.innerHTML.replace(/\s/g,'&nbsp;');if(escapeQuotes)
return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return span.innerHTML;},importElements:function importElements(context){var ids=[].slice.call(arguments,1);ids.forEach(function(id){context[StringHelper.camelCase(id)]=document.getElementById(id);});}};var StringHelper={fromUTF8:function ut_fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;},camelCase:function ut_camelCase(str){var rdashes=/-(.)/g;return str.replace(rdashes,function replacer(str,p1){return p1.toUpperCase();});}};;(function(exports){'use strict';var TouchForwarder=function TouchForwarder(){this.destination=null;this._resetState();};TouchForwarder.prototype.forward=function(e){var iframe=this.destination;var touch;if(iframe.getAttribute('aria-hidden')=='true'){return;}
switch(e.type){case'touchstart':sendTouchEvent(iframe,e);touch=e.touches[0];this._startX=touch.clientX;this._startY=touch.clientY;this._shouldTap=true;break;case'touchmove':if(!this._firstMoveForwarded){sendTouchEvent(iframe,e);this._firstMoveForwarded=true;}
touch=e.touches[0];this._updateShouldTap(touch);break;case'touchend':sendTouchEvent(iframe,e);touch=e.changedTouches[0];this._updateShouldTap(touch);if(this._shouldTap){sendTapMouseEvents(iframe,touch.clientX,touch.clientY);}
this._resetState();break;}};TouchForwarder.prototype._resetState=function(){this._startX=null;this._startY=null;this._shouldTap=false;this._firstMoveForwarded=false;};TouchForwarder.prototype._updateShouldTap=function(touch){var deltaX=Math.abs(touch.clientX-this._startX);var deltaY=Math.abs(touch.clientY-this._startY);if(deltaX>5||deltaY>5){this._shouldTap=false;}};function sendTouchEvent(iframe,e){if(!iframe){return;}
iframe.sendTouchEvent.apply(iframe,unsynthetizeEvent(e));}
function sendTapMouseEvents(iframe,x,y){if(!iframe){return;}
iframe.sendMouseEvent('mousemove',x,y,0,0,0);iframe.sendMouseEvent('mousedown',x,y,0,1,0);iframe.sendMouseEvent('mouseup',x,y,0,1,0);}
function unsynthetizeEvent(e){var type=e.type;var relevantTouches=(e.type==='touchend')?e.changedTouches:e.touches;var identifiers=[];var xs=[];var ys=[];var rxs=[];var rys=[];var rs=[];var fs=[];var modifiers=0;for(var i=0;i<relevantTouches.length;i++){var t=relevantTouches[i];identifiers.push(t.identifier);xs.push(t.pageX);ys.push(t.pageY);rxs.push(t.radiusX);rys.push(t.radiusY);rs.push(t.rotationAngle);fs.push(t.force);}
return[type,identifiers,xs,ys,rxs,rys,rs,fs,xs.length,modifiers];}
exports.TouchForwarder=TouchForwarder;}(window));;'use strict';(function(exports){function Version(str){str=str||'0.0';var parts=str.split('.');this.major=parts[0];this.minor=parts[1];this.toString=function(){return''+str;};}
function InfoResult(current,previous){this.current=current;this.previous=previous;}
InfoResult.prototype.isUpgrade=function(){var prev=this.previous,curr=this.current,isUpgrade=false;if(prev&&curr){isUpgrade=curr.major>prev.major||curr.minor>prev.minor;}
return isUpgrade;};InfoResult.prototype.delta=function(){var prev=this.previous,curr=this.current;var delta='';if(prev){delta+=prev.major+'.'+prev.minor;}
delta+='..';if(curr){delta+=curr.major+'.'+curr.minor;}
return delta;};function getSetting(setting,cb,errback){var req=navigator.mozSettings.createLock().get(setting);req.onsuccess=function(){var value=req.result[setting];if(typeof cb==='function'){cb(value);}};req.onerror=function(){if(typeof errback==='function'){errback(req.error);}};}
function getCurrent(){return new Promise(function(resolve,reject){getSetting('deviceinfo.os',function(value){resolve(value?new Version(value):null);},function(err){reject(err);});});}
function getPrevious(){return new Promise(function(resolve,reject){getSetting('deviceinfo.previous_os',function(value){resolve(value?new Version(value):null);},function(err){resolve(null);});});}
function updatePrevious(str){var currentPromise=str?Promise.resolve(new Version(str)):getCurrent();var setPromise=new Promise(function(resolve,reject){currentPromise.then(function(version){if(version){var req=navigator.mozSettings.createLock().set({'deviceinfo.previous_os':version.toString()});req.onsuccess=function(){resolve(version);};req.onerror=function(){var reason=req.error;reject(reason);};}else{resolve(null);}},function(err){reject('Error getting previous version: ',err);});});return setPromise;}
function getVersionInfo(){var info=new InfoResult();var infoPromise=new Promise(function(resolve,reject){Promise.all([getCurrent().then(function(version){info.current=version;}),getPrevious().then(function(version){info.previous=version;})]).then(function(){resolve(info);},reject);});return infoPromise;}
exports.VersionHelper={updatePrevious:updatePrevious,getVersionInfo:getVersionInfo};})(window);;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;'use strict';(function(exports){var SettingsMigrator=function SettingsMigrator(){this._kLocaleTime='locale.hour12';};SettingsMigrator.prototype={start:function km_start(){var request=window.navigator.mozSettings.createLock().get('*');request.onsuccess=function(e){this.keyMigration(request.result);}.bind(this);},keyMigration:function km_keyMigration(result){if(result[this._kLocaleTime]===undefined){var _=navigator.mozL10n.get;var localeTimeFormat=_('shortTimeFormat');var is12hFormat=(localeTimeFormat.indexOf('%I')>=0);var cset={};cset[this._kLocaleTime]=is12hFormat;window.navigator.mozSettings.createLock().set(cset);}}};exports.SettingsMigrator=SettingsMigrator;}(window));;(function(){'use strict';if(window.navigator.mozHour12||window.navigator.hour12){return;}
window.navigator.mozHour12=null;var _setMozHour12=function(result){if(window.navigator.mozHour12!==result){window.navigator.mozHour12=result;window.dispatchEvent(new CustomEvent('timeformatchange'));}};var _hour12Handler=function(event){_setMozHour12(event.settingValue);};var _kLocaleTime='locale.hour12';var req=window.navigator.mozSettings.createLock().get(_kLocaleTime);req.onsuccess=function(){_setMozHour12(req.result[_kLocaleTime]);};window.navigator.mozSettings.addObserver(_kLocaleTime,_hour12Handler);})();;'use strict';(function(exports){var DEBUG=false;exports.Service={_providers:new Map(),_services:new Map(),_requestsByService:new Map(),_requestsByProvider:new Map(),request:function(service){var requestItems=service.split(':');var args=Array.prototype.slice.call(arguments,1);var self=this;this.debug(requestItems);if(requestItems.length>1){var serverName=requestItems[0];var serviceName=requestItems[1];if(this._providers.get(serverName)){this.debug('service: '+serviceName+' is online, perform the request with '+args.concat());return new Promise(function(resolve,reject){var returnValue=self._providers.get(serverName)[serviceName].apply(self._providers.get(serverName),args);self._unwrapPromise(returnValue,resolve,reject);});}else{return new Promise(function(resolve,reject){self.debug('service: '+service+' is offline, queue the task.');if(!self._requestsByProvider.has(serverName)){self._requestsByProvider.set(serverName,[]);}
self._requestsByProvider.get(serverName).push({service:serviceName,resolve:resolve,reject:reject,args:args});});}
return;}
if(this._services.has(service)){var server=this._services.get(service);this.debug('service ['+service+'] provider ['+server.name+'] is online, perform the task.');return new Promise(function(resolve,reject){var returnValue=resolve(server[service].apply(server,args));self._unwrapPromise(returnValue,resolve,reject);});}else{this.debug('service: '+service+' is offline, queue the task.');var promise=new Promise(function(resolve,reject){self.debug('storing the requests...');if(!self._requestsByService.has(service)){self._requestsByService.set(service,[]);}
self._requestsByService.get(service).push({service:service,args:args,resolve:resolve,reject:reject});});return promise;}},register:function(service,server){var self=this;if(!this._providers.has(server.name)){this._providers.set(server.name,server);}
this.debug((server.name||'(Anonymous)')+' is registering service: ['+service+']');this.debug('checking awaiting requests by server..');if(this._requestsByProvider.has(server.name)){this._requestsByProvider.get(server.name).forEach(function(request){self.debug('resolving..',server,server.name,request.service,request.args);var returnValue=(typeof(server[request.service])==='function')?server[request.service].apply(server,request.args):server[request.service];self._unwrapPromise(returnValue,request.resolve,request.reject);});this._requestsByProvider.delete(server.name);}
if(!this._services.has(service)){this._services.set(service,server);}else{console.warn('the service ['+service+'] has already been '+'registered by other server.');return;}
this.debug('checking awaiting requests by service..');if(this._requestsByService.has(service)){this._requestsByService.get(service).forEach(function(request){self.debug('resolving..',server,request.service);var returnValue=server[request.service].apply(server,request.args);self._unwrapPromise(returnValue,request.resolve,request.reject);});this._requestsByService.delete(service);}},_unwrapPromise:function(returnValue,resolve,reject){if(returnValue&&returnValue.then&&returnValue.catch){returnValue.then(function(result){resolve(result);}).catch(function(error){reject(error);});}else{resolve(returnValue);}},unregister:function(service,server){this._providers.delete(server.name);var se=this._services.get(service);if(se&&server===se){this._services.delete(service);}},_states:new Map(),_statesByState:new Map(),registerState:function(state,provider){this._states.set(provider.name,provider);this._statesByState.set(state,provider);},unregisterState:function(state,provider){this._states.delete(provider.name);var machine=this._statesByState.get(state);if(machine===provider){this._statesByState.delete(state);}},query:function(stateString){this.debug(stateString);var args=stateString.split('.');var state,provider;if(args.length>1){provider=this._states.get(args[0]);state=args[1];}else{state=args[0];provider=this._statesByState.get(state);}
if(!provider){this.debug('Provider not ready, return undefined state.');return undefined;}
if(typeof(provider[state])==='function'){return provider[state]();}else{return provider[state];}},get applicationReady(){return window.applications&&window.applications.ready;},isBusyLoading:function(){var app=this.currentApp;return app&&!app.loaded;},_start:new Date().getTime()/1000,currentTime:function(){return(new Date().getTime()/1000-this._start).toFixed(3);},debug:function sys_debug(){if(DEBUG){console.log('[System]'+'['+window.Service.currentTime()+']'+
Array.slice(arguments).concat());}},get runningFTU(){if('undefined'===typeof window.FtuLauncher){return false;}else{return window.FtuLauncher.isFtuRunning();}},get locked(){if('undefined'===typeof window.lockScreenWindowManager){return false;}else{return window.lockScreenWindowManager.isActive();}},get manifestURL(){return window.location.href.replace('index.html','manifest.webapp');},get currentApp(){if('undefined'===typeof window.appWindowManager){return null;}else{return window.appWindowManager.getActiveApp();}}};})(window);;'use strict';(function(window){var DEBUG=false;var _id=0;window.BaseUI=function BaseUI(){};BaseUI.prototype.EVENT_PREFIX='base-';BaseUI.prototype.render=function bu_render(){this.publish('willrender');this.containerElement.insertAdjacentHTML('afterbegin',this.view());this._fetchElements();this._registerEvents();if(this.element){this.element.clientTop;}
this.publish('rendered');};BaseUI.prototype._fetchElements=function bu__fetchElements(){};BaseUI.prototype._registerEvents=function bu__registerEvents(){};BaseUI.prototype.view=function bu_view(){return'<div class="'+this.CLASS_NAME+'"></div>';};BaseUI.prototype.show=function bu_show(ele){ele=ele||this.element;ele.classList.add('visible');};BaseUI.prototype.isShown=function bu_isShown(ele){ele=ele||this.element;return ele&&ele.classList.contains('visible');};BaseUI.prototype.hide=function bu_hide(ele){ele=ele||this.element;ele.classList.remove('visible');};BaseUI.prototype.broadcast=function bu_broadcast(event,detail){if(this.element){var internalEvent=new CustomEvent('_'+event,{bubbles:false,detail:detail||this});this.debug(' publishing internal event: '+event);this.element.dispatchEvent(internalEvent);}};BaseUI.prototype.publish=function bu_publish(event,detail){this.broadcast(event,detail);var evt=new CustomEvent(this.EVENT_PREFIX+event,{bubbles:true,cancelable:false,detail:detail||this});this.debug(' publishing external event: '+event);window.dispatchEvent(evt);};BaseUI.prototype.CLASS_NAME='BaseUI';BaseUI.prototype.customID=function bu_customID(){return'';};BaseUI.prototype._unregisterEvents=function bu__unregisterEvents(){};BaseUI.prototype.destroy=function bu_destroy(){this.publish('willdestroy');this._unregisterEvents();if(this.element){this.element.parentNode.removeChild(this.element);this.element=null;}
this.publish('destroyed');};BaseUI.prototype.debug=function bu_debug(msg){if(DEBUG&&('DEBUG'in this.constructor&&this.constructor.DEBUG)){console.log('['+this.CLASS_NAME+']['+this.customID()+']'+'['+Service.currentTime()+']'+
Array.slice(arguments).concat());}};}(this));;'use strict';(function(exports){const DEBOUNCE_TIME=2000;const SCREENSHOT_TIMEOUT=5000;function Places(){}
Places.prototype={STORE_NAME:'places',dataStore:null,writeInProgress:false,screenshotQueue:{},MAX_TOP_SITES:6,topSites:[],_placeChanges:{},_timeouts:{},start:function(){return new Promise(resolve=>{window.addEventListener('applocationchange',this);window.addEventListener('apptitlechange',this);window.addEventListener('appiconchange',this);window.addEventListener('apploaded',this);asyncStorage.getItem('top-sites',results=>{this.topSites=results||[];resolve();});});},getStore:function(){return new Promise(resolve=>{if(this.dataStore){return resolve(this.dataStore);}
navigator.getDataStores(this.STORE_NAME).then(stores=>{this.dataStore=stores[0];return resolve(this.dataStore);});});},handleEvent:function(evt){var app=evt.detail;if(app&&!app.isBrowser()){return;}
if(app&&app.isPrivateBrowser()){return;}
switch(evt.type){case'applocationchange':this.onLocationChange(app.config.url);break;case'apptitlechange':this.onTitleChange(app.config.url,app.title);break;case'appiconchange':this.onIconChange(app.config.url,app.favicons);break;case'apploaded':if(app.config.url in this.screenshotQueue){this.takeScreenshot(app.config.url);}
this.debouncePlaceChanges(app.config.url);break;}},screenshotRequested:function(url){var app=appWindowManager.getAppByURL(url);if(!app||app.loading){this.screenshotQueue[url]=setTimeout(()=>{this.takeScreenshot(url);},SCREENSHOT_TIMEOUT);}else{this.takeScreenshot(url);}},takeScreenshot:function(url){if(url in this.screenshotQueue){clearTimeout(this.screenshotQueue[url]);delete this.screenshotQueue[url];}
var app=appWindowManager.getAppByURL(url);if(!app){console.error('Couldnt find app for:',url);return false;}
app.getScreenshot(screenshot=>{if(screenshot){this.saveScreenshot(url,screenshot);}},null,null,null,true);},defaultPlace:function(url){return{url:url,title:url,icons:{},frecency:0,visits:[],screenshot:null};},editPlace:function(url,fun){return new Promise(resolve=>{this.getStore().then(store=>{var rev=store.revisionId;store.get(url).then(place=>{place=place||this.defaultPlace(url);fun(place,newPlace=>{if(this.writeInProgress||store.revisionId!==rev){return this.editPlace(url,fun);}
this.writeInProgress=true;store.put(newPlace,url).then(()=>{this.writeInProgress=false;resolve();});});});});});},setVisits:function(url,visits){return this.editPlace(url,(place,cb)=>{place.visits=place.visits||[];place.visits=place.visits.concat(visits);place.visits.sort((a,b)=>{return b-a;});cb(place);});},TRUNCATE_VISITS:10,addToVisited:function(place){place.visits=place.visits||[];if(!place.visits.length){place.visits.unshift(place.visited);return place;}
var lastVisit=place.visits[0];if(lastVisit>(Date.now()-60*60*24*1000)){place.visits.shift();}
place.visits.unshift(place.visited);if(place.visits.length>this.TRUNCATE_VISITS){place.visits.length=this.TRUNCATE_VISITS;}
return place;},checkTopSites:function(place){var numTopSites=this.topSites.length;var lastTopSite=this.topSites[numTopSites-1];if(numTopSites<this.MAX_TOP_SITES||place.frecency>lastTopSite.frecency){this.topSites.push(place);this.screenshotRequested(place.url);this.topSites.sort(function(a,b){return b.frecency-a.frecency;});if(this.topSites.length>this.MAX_TOP_SITES){this.topSites.length=this.MAX_TOP_SITES;}
asyncStorage.setItem('top-sites',this.topSites);}},saveScreenshot:function(url,screenshot){return this.editPlace(url,function(place,cb){place.screenshot=screenshot;cb(place);});},clear:function(){return this.getStore().then(store=>{store.clear();});},onLocationChange:function(url){this._placeChanges[url]=this._placeChanges[url]||this.defaultPlace();this._placeChanges[url].visited=Date.now();this._placeChanges[url].frecency+=1;this.debounce(url);},onTitleChange:function(url,title){this._placeChanges[url]=this._placeChanges[url]||this.defaultPlace();this._placeChanges[url].title=title;this.debounce(url);},onIconChange:function(url,icons){this._placeChanges[url]=this._placeChanges[url]||this.defaultPlace();for(var iconUri in icons){this._placeChanges[url].icons[iconUri]=icons[iconUri];}
this.debounce(url);},debounce:function(url){clearTimeout(this._timeouts[url]);this._timeouts[url]=setTimeout(()=>{this.debouncePlaceChanges(url);},DEBOUNCE_TIME);},debouncePlaceChanges:function(url){clearTimeout(this._timeouts[url]);this.editPlace(url,(place,cb)=>{var edits=this._placeChanges[url];if(!edits){return;}
if(edits.title!==url){place.title=edits.title;}
if(edits.visited){place.visited=edits.visited;}
if(!place.frecency){place.frecency=0;}
place.frecency+=edits.frecency;if(!place.icons){place.icons={};}
for(var iconUri in edits.icons){place.icons[iconUri]=edits.icons[iconUri];}
place=this.addToVisited(place);this.checkTopSites(place);delete this._placeChanges[url];cb(place);});}};exports.Places=Places;}(window));;'use strict';(function(window){window.OrientationManager={init:function om_init(){this.fetchDefaultOrientation();if(SettingsListener){SettingsListener.observe('screen.orientation.lock',false,function(value){this.globalOrientation=value?this.fetchCurrentOrientation():null;this.publish('reset-orientation');}.bind(this));}
window.addEventListener('lockscreen-appclosing',this);window.addEventListener('attentionclosed',this);window.addEventListener('sleepmenuhide',this);window.addEventListener('trusteduiclose',this);window.addEventListener('shrinking-stop',this);window.addEventListener('searchclosing',this);},handleEvent:function om_handleEvent(evt){switch(evt.type){case'attentionclosed':case'sleepmenuhide':case'trusteduiclose':case'lockscreen-appclosing':case'searchclosing':if(Service.locked){return;}
this.publish('reset-orientation');break;case'shrinking-stop':this.publish('reset-orientation');break;}},globalOrientation:null,defaultOrientation:screen.mozOrientation,isDefaultPortrait:function(){return(this.defaultOrientation==='portrait-primary');},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined')
return this._isOnRealDevice;if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},fetchDefaultOrientation:function sl_fetchDefaultOrientation(){if(!this.isOnRealDevice()){this.defaultOrientation=window.innerWidth>window.innerHeight?'landscape-primary':'portrait-primary';}else{screen.mozLockOrientation('default');this.defaultOrientation=screen.mozOrientation;}},fetchCurrentOrientation:function sl_fetchCurrentOrientation(){if(!this.isOnRealDevice()){return window.innerWidth>window.innerHeight?'landscape-primary':'portrait-primary';}else{return screen.mozOrientation;}},publish:function sl_publish(eventName,detail){var evt=document.createEvent('CustomEvent');evt.initCustomEvent(eventName,true,false,detail);window.dispatchEvent(evt);}};OrientationManager.init();}(this));;'use strict';(function(exports){function PowerSave(){}
PowerSave.prototype={_powerSaveResume:{},_powerSaveEnabled:false,_states:{'wifi.enabled':false,'ril.data.enabled':false,'bluetooth.enabled':false,'geolocation.enabled':false},_powerSaveEnabledLock:false,start:function(){SettingsListener.observe('powersave.enabled',false,value=>{var enabled=value;if(enabled){this.enablePowerSave();}else{this.disablePowerSave();}
this._powerSaveEnabled=enabled;});SettingsListener.observe('powersave.threshold',-1,value=>{this.doCheckThreshold(value);});function getState(state,value){this._states[state]=value;}
for(var j in this._states){SettingsListener.observe(j,true,getState.bind(this,j));}},setMozSettings:function(keypairs){var setlock=SettingsListener.getSettingsLock();for(var key in keypairs){if('bluetooth.enabled'!==key){var obj={};obj[key]=keypairs[key];setlock.set(obj);}}},enablePowerSave:function(){for(var j in this._states){this._powerSaveResume[j]=this._states[j];}
var settingsToSet={'wifi.enabled':false,'ril.data.enabled':false,'geolocation.enabled':false};this.setMozSettings(settingsToSet);window.dispatchEvent(new CustomEvent('request-disable-bluetooth'));this._powerSaveEnabledLock=false;},disablePowerSave:function(){var settingsToSet={};for(var state in this._powerSaveResume){if(this._powerSaveResume[state]===true){settingsToSet[state]=true;}}
if(this._powerSaveResume['bluetooth.enabled']===true){window.dispatchEvent(new CustomEvent('request-enable-bluetooth'));}
this.setMozSettings(settingsToSet);},showPowerSavingNotification:function(){var clickCB=function(){var activityRequest=new MozActivity({name:'configure',data:{target:'device',section:'battery'}});activityRequest.onsuccess=()=>{};};NotificationHelper.send('notification-powersaving-mode-on-title',{'bodyL10n':'notification-powersaving-mode-on-description','icon':'style/icons/Power_saving_mode.png','mozbehavior':{showOnlyOnce:true}}).then(function(notification){notification.addEventListener('click',clickCB);});},checkThreshold:function(){var key='powersave.threshold';var lock=navigator.mozSettings.createLock();var req=lock.get(key);req.onerror=function(e){console.error('Error while quering setting '+key+': '+e);};req.onsuccess=(function(){this.doCheckThreshold(req.result[key]||-1);}).bind(this);},doCheckThreshold:function(value){var battery=batteryOverlay._battery;if(value==-1){return;}
if(battery.level<=value&&!this._powerSaveEnabled){this.setMozSettings({'powersave.enabled':true});if(!this._powerSaveEnabledLock){this.showPowerSavingNotification();this._powerSaveEnabledLock=true;}
return;}
if(battery.level>value&&this._powerSaveEnabled){this.setMozSettings({'powersave.enabled':false});return;}},onBatteryChange:function(){var battery=batteryOverlay._battery;if(battery.charging){if(this._powerSaveEnabled){this.setMozSettings({'powersave.enabled':false});}
return;}
this.checkThreshold();}};exports.PowerSave=PowerSave;}(window));;'use strict';(function(exports){function BatteryOverlay(){this.powerSave=new PowerSave();this.powerSave.start();}
BatteryOverlay.prototype={TOASTER_TIMEOUT:5000,TRANSITION_SPEED:1.8,TRANSITION_FRACTION:0.30,AUTO_SHUTDOWN_LEVEL:0.00,EMPTY_BATTERY_LEVEL:0.1,_battery:window.navigator.battery,_notification:null,getAllElements:function bm_getAllElements(){this.screen=document.getElementById('screen');this.overlay=document.getElementById('system-overlay');this.notification=document.getElementById('battery');},checkBatteryDrainage:function bm_checkBatteryDrainage(){var battery=this._battery;if(!battery){return;}
if(battery.level<=this.AUTO_SHUTDOWN_LEVEL&&!battery.charging){window.dispatchEvent(new CustomEvent('batteryshutdown'));}},start:function bm_init(){this.getAllElements();var battery=this._battery;if(battery){window.addEventListener('homescreen-ready',this.checkBatteryDrainage.bind(this));battery.addEventListener('levelchange',this);battery.addEventListener('chargingchange',this);}
window.addEventListener('screenchange',this);this._screenOn=true;this._wasEmptyBatteryNotificationDisplayed=false;this.displayIfNecessary();},handleEvent:function bm_handleEvent(evt){var battery=this._battery;switch(evt.type){case'screenchange':this._screenOn=evt.detail.screenEnabled;this.displayIfNecessary();break;case'levelchange':if(!battery){return;}
this.checkBatteryDrainage();this.displayIfNecessary();this.powerSave.onBatteryChange();break;case'chargingchange':this.powerSave.onBatteryChange();if(battery&&battery.charging){this.hide();this._wasEmptyBatteryNotificationDisplayed=false;if(!this._screenOn){ScreenManager.turnScreenOn();}}else{this.displayIfNecessary();}
break;}},_shouldWeDisplay:function bm_shouldWeDisplay(){var battery=this._battery;if(!battery){return false;}
return(!this._wasEmptyBatteryNotificationDisplayed&&!battery.charging&&battery.level<=this.EMPTY_BATTERY_LEVEL&&this._screenOn);},displayIfNecessary:function bm_display(){if(!this._shouldWeDisplay()){return;}
this.overlay.classList.add('battery');this._wasEmptyBatteryNotificationDisplayed=true;if(this._toasterTimeout){clearTimeout(this._toasterTimeout);}
this._toasterTimeout=setTimeout(this.hide.bind(this),this.TOASTER_TIMEOUT);},hide:function bm_hide(){var overlayCss=this.overlay.classList;if(overlayCss.contains('battery')){this.overlay.classList.remove('battery');this._toasterTimeout=null;}}};exports.BatteryOverlay=BatteryOverlay;}(window));;'use strict';(function(window){var _start=Date.now();var DEBUG=false;window.SIMSlot=function SIMSlot(conn,index,card){this.index=index;this.conn=conn;if(card){this.update(card);}
this.publish('created');};SIMSlot.EVENTS=['cardstatechange','iccinfochange','stkcommand','stksessionend'];SIMSlot.METHODS=['sendStkResponse','sendStkMenuSelection','sendStkTimerExpiration','sendStkEventDownload'];SIMSlot.DOM_REQUEST_METHODS=['getCardLock','unlockCardLock','setCardLock','getCardLockRetryCount','readContacts','updateContact','iccOpenChannel','iccExchangeAPDU','iccCloseChannel'];SIMSlot.ABSENT_TYPES=['permanentBlocked'];SIMSlot.LOCK_TYPES=['pinRequired','pukRequired','networkLocked','corporateLocked','serviceProviderLocked','network1Locked','network2Locked','hrpdNetworkLocked','ruimCorporateLocked','ruimServiceProviderLocked'];SIMSlot.prototype.update=function ss_update(iccObj){this.simCard=iccObj;this.constructor.EVENTS.forEach(function iterater(evt){iccObj.addEventListener(evt,this);},this);this.constructor.DOM_REQUEST_METHODS.forEach(function iterator(domRequest){this[domRequest]=function(){return iccObj[domRequest].apply(iccObj,arguments);};},this);this.constructor.METHODS.forEach(function iterator(method){this[method]=function(){return iccObj[method].apply(iccObj,arguments);};},this);this.publish('updated');};SIMSlot.prototype.EVENT_PREFIX='simslot-';SIMSlot.prototype.CLASS_NAME='SIMSLOT';SIMSlot.prototype.publish=function ss_publish(eventName){this.debug(' publish: '+eventName);window.dispatchEvent(new CustomEvent(this.EVENT_PREFIX+eventName,{detail:this}));};SIMSlot.prototype.handleEvent=function ss_handleEvent(evt){switch(evt.type){default:this.publish(evt.type);if(this.simCard){this.debug(this.simCard.cardState);}
break;}};SIMSlot.prototype.debug=function(){if(DEBUG){console.log('['+this.CLASS_NAME+']'+'['+(this.index)+']'+'['+(new Date().getTime()/1000-_start).toFixed(3)+']'+
Array.slice(arguments).concat());}};SIMSlot.prototype.isAbsent=function ss_isAbsent(){return(!this.simCard||this.constructor.ABSENT_TYPES.indexOf(this.simCard.cardState)>=0||this.simCard&&this.simCard.iccInfo&&this.simCard.iccInfo.iccid===null);};SIMSlot.prototype.getSmsc=function ss_getSmsc(cb){var mobileMessage=window.navigator.mozMobileMessage;if(!mobileMessage){console.error('can\'t access mozMobileMessage');cb(null);}else{var req=mobileMessage.getSmscAddress(this.index);req.onsuccess=function(){var smsc=this.result.split(',')[0].replace(/"/g,'');cb(smsc);};req.onerror=function(){console.error(this.error);cb(null);};}};SIMSlot.prototype.isUnknownState=function ss_isUnknownState(){var empty=(this.simCard.cardState==='');var unknown=(this.simCard.cardState==='unknown');return!this.simCard.cardState||unknown||empty;};SIMSlot.prototype.isLocked=function ss_isLocked(){return this.constructor.LOCK_TYPES.indexOf(this.simCard.cardState)>=0;};SIMSlot.prototype.getCardState=function ss_getCardState(){return this.simCard.cardState;};}(window));;'use strict';(function(window){var IccManager=navigator.mozIccManager;window.SIMSlotManager={length:0,_instances:[],TIMEOUT_FOR_SIM2:2000,_timerForSIM2:null,ready:false,init:function ssm_init(){if(!IccManager){return;}
this._conns=Array.prototype.slice.call(navigator.mozMobileConnections);this.length=this._conns.length;if(this._conns.length===0){return;}
this._conns.forEach(function iterator(conn,index){this._instances.push(new SIMSlot(conn,index,IccManager.getIccById(conn.iccId)));},this);IccManager.addEventListener('iccdetected',this);},isMultiSIM:function(){return(this.length>1);},isSIMCardAbsent:function ssm_isSIMCardAbsent(index){var slot=this.get(index);if(slot){return slot.isAbsent();}else{return true;}},hasOnlyOneSIMCardDetected:function(){var sim0Absent=this.isSIMCardAbsent(0);var sim1Absent=this.isSIMCardAbsent(1);var hasOneSim=(sim0Absent&&!sim1Absent)||(!sim0Absent&&sim1Absent);return hasOneSim;},noSIMCardOnDevice:function ssm_noSIMCardOnDevice(){if(!IccManager||!IccManager.iccIds){return true;}
return(IccManager.iccIds.length===0);},noSIMCardConnectedToNetwork:function ssm_noSIMCardConnectedToNetwork(){if(!IccManager||!IccManager.iccIds){return true;}
return this._instances.every(function iterator(instance){return instance.conn.voice&&instance.conn.voice.emergencyCallsOnly;});},get:function ssm_get(index){if(index>this.length-1){return null;}
return this._instances[index];},getMobileConnection:function ssm_getMobileConnection(index){if(index>this.length-1){return null;}
return this._instances[index].conn;},getSlots:function ssm_getSlots(){return this._instances;},getSlotByIccId:function ssm_getSlotByIccId(iccId){var found=null;this._instances.some(function iterator(slot,index){if(slot.conn.iccId&&slot.conn.iccId===iccId){found=slot;return true;}else{return false;}},this);return found;},waitForSecondSIM:function(){var self=this;this._timerForSIM2=setTimeout(function(){clearTimeout(self._timerForSIM2);self.publishSIMSlotIsReady();},this.TIMEOUT_FOR_SIM2);},publishSIMSlotIsReady:function(){if(!this.ready){this.ready=true;window.dispatchEvent(new CustomEvent('simslotready'));}},handleEvent:function ssm_handleEvent(evt){switch(evt.type){case'iccdetected':var slot=this.getSlotByIccId(evt.iccId);if(slot){slot.update(IccManager.getIccById(evt.iccId));if(!this.isMultiSIM()){this.publishSIMSlotIsReady();}else{if(this.hasOnlyOneSIMCardDetected()){this.waitForSecondSIM();}else{clearTimeout(this._timerForSIM2);this.publishSIMSlotIsReady();}}}
break;}}};SIMSlotManager.init();}(window));;window.COMPONENTS_BASE_URL='/shared/elements/';;(function(exports){'use strict';exports.ComponentUtils={style:function(baseUrl){var style=document.createElement('style');var url=baseUrl+'style.css';var self=this;style.setAttribute('scoped','');style.innerHTML='@import url('+url+');';this.appendChild(style);this.style.visibility='hidden';style.addEventListener('load',function(){if(self.shadowRoot){self.shadowRoot.appendChild(style.cloneNode(true));}
self.style.visibility='';});}};}(window));;'use strict';window.GaiaButtons=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaButtonsBaseurl||'/shared/elements/gaia_buttons/';proto.createdCallback=function(){ComponentUtils.style.call(this,baseurl);};return document.registerElement('gaia-buttons',{prototype:proto});})(window);;'use strict';window.GaiaProgress=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaProgressBaseurl||'/shared/elements/gaia_progress/';proto.createdCallback=function(){var shadow=this.createShadowRoot();this._template=template.content.cloneNode(true);this._progress=this._template.getElementById('progress');shadow.appendChild(this._template);ComponentUtils.style.call(this,baseurl);if(this.hasAttribute('animated')){this.start();}};proto.start=function(){this.setAttribute('animated','');this._progress.classList.add('animated');};proto.stop=function(){this.removeAttribute('animated');this._progress.classList.remove('animated');};var template=document.createElement('template');template.innerHTML='<div id="progress"></div>';return document.registerElement('gaia-progress',{prototype:proto});})(window);;'use strict';window.GaiaSubheader=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaSubheaderBaseurl||'/shared/elements/gaia_subheader/';proto.createdCallback=function(){ComponentUtils.style.call(this,baseurl);};return document.registerElement('gaia-subheader',{prototype:proto});})(window);;!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.GaiaHeader=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var debug=0?console.log.bind(console):function(){};var cache={};var MIN=16;var MAX=24;var BUFFER=3;module.exports=function(config){debug('font fit',config);var space=config.space-BUFFER;var min=config.min||MIN;var max=config.max||MAX;var text=trim(config.text);var fontSize=max;var textWidth;var font;do{font=config.font.replace(/\d+px/,fontSize+'px');textWidth=getTextWidth(text,font);}while(textWidth>space&&fontSize!==min&&fontSize--);return{textWidth:textWidth,fontSize:fontSize,overflowing:textWidth>space};};function getTextWidth(text,font){var ctx=getCanvasContext(font);var width=ctx.measureText(text).width;debug('got text width',width);return width;}
function getCanvasContext(font){debug('get canvas context',font);var cached=cache[font];if(cached){return cached;}
var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1px');canvas.setAttribute('height','1px');debug('created canvas',canvas);var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=font;return cache[font]=ctx;}
function trim(text){return text.replace(/\s+/g,' ').trim();}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('font-fit',this));},{}],2:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var textContent=Object.getOwnPropertyDescriptor(Node.prototype,'textContent');var innerHTML=Object.getOwnPropertyDescriptor(Element.prototype,'innerHTML');var removeAttribute=Element.prototype.removeAttribute;var setAttribute=Element.prototype.setAttribute;var noop=function(){};exports.register=function(name,props){var baseProto=getBaseProto(props.extends);delete props.extends;if(props.template){var output=processCss(props.template,name);props.template=document.createElement('template');props.template.innerHTML=output.template;props.lightCss=output.lightCss;props.globalCss=props.globalCss||'';props.globalCss+=output.globalCss;}
injectGlobalCss(props.globalCss);delete props.globalCss;var descriptors=Object.assign(props.attrs||{},base.descriptors);props._attrs=props.attrs;delete props.attrs;var proto=createProto(baseProto,props);Object.defineProperties(proto,descriptors);try{return document.registerElement(name,{prototype:proto});}catch(e){if(e.name!=='NotSupportedError'){throw e;}}};var base={properties:{GaiaComponent:true,attributeChanged:noop,attached:noop,detached:noop,created:noop,createdCallback:function(){if(this.rtl){addDirObserver();}
injectLightCss(this);this.created();},attributeChangedCallback:function(name,from,to){var prop=toCamelCase(name);if(this._attrs&&this._attrs[prop]){this[prop]=to;}
this.attributeChanged(name,from,to);},attachedCallback:function(){this.attached();},detachedCallback:function(){this.detached();},setupShadowRoot:function(){if(!this.template){return;}
var node=document.importNode(this.template.content,true);this.createShadowRoot().appendChild(node);return this.shadowRoot;},setAttr:function(name,value){var internal=this.shadowRoot.firstElementChild;setAttribute.call(internal,name,value);setAttribute.call(this,name,value);},removeAttr:function(name){var internal=this.shadowRoot.firstElementChild;removeAttribute.call(internal,name);removeAttribute.call(this,name);}},descriptors:{textContent:{set:function(value){textContent.set.call(this,value);if(this.lightStyle){this.appendChild(this.lightStyle);}},get:textContent.get},innerHTML:{set:function(value){innerHTML.set.call(this,value);if(this.lightStyle){this.appendChild(this.lightStyle);}},get:innerHTML.get}}};var defaultPrototype=createProto(HTMLElement.prototype,base.properties);function getBaseProto(proto){if(!proto){return defaultPrototype;}
proto=proto.prototype||proto;return!proto.GaiaComponent?createProto(proto,base.properties):proto;}
function createProto(proto,props){return Object.assign(Object.create(proto),props);}
var hasShadowCSS=(function(){var div=document.createElement('div');try{div.querySelector(':host');return true;}
catch(e){return false;}})();var regex={shadowCss:/(?:\:host|\:\:content)[^{]*\{[^}]*\}/g,':host':/(?:\:host)/g,':host()':/\:host\((.+)\)(?: \:\:content)?/g,':host-context':/\:host-context\((.+)\)([^{,]+)?/g,'::content':/(?:\:\:content)/g};function processCss(template,name){var globalCss='';var lightCss='';if(!hasShadowCSS){template=template.replace(regex.shadowCss,function(match){var hostContext=regex[':host-context'].exec(match);if(hostContext){globalCss+=match.replace(regex['::content'],'').replace(regex[':host-context'],'$1 '+name+'$2').replace(/ +/g,' ');}else{lightCss+=match.replace(regex[':host()'],name+'$1').replace(regex[':host'],name).replace(regex['::content'],name);}
return'';});}
return{template:template,lightCss:lightCss,globalCss:globalCss};}
function injectGlobalCss(css){if(!css)return;var style=document.createElement('style');style.innerHTML=css.trim();headReady().then(()=>{document.head.appendChild(style)});}
function headReady(){return new Promise(resolve=>{if(document.head){return resolve();}
window.addEventListener('load',function fn(){window.removeEventListener('load',fn);resolve();});});}
function injectLightCss(el){if(hasShadowCSS){return;}
el.lightStyle=document.createElement('style');el.lightStyle.setAttribute('scoped','');el.lightStyle.innerHTML=el.lightCss;el.appendChild(el.lightStyle);}
function toCamelCase(string){return string.replace(/-(.)/g,function replacer(string,p1){return p1.toUpperCase();});}
var dirObserver;function addDirObserver(){if(dirObserver){return;}
dirObserver=new MutationObserver(onChanged);dirObserver.observe(document.documentElement,{attributeFilter:['dir'],attributes:true});function onChanged(mutations){document.dispatchEvent(new Event('dirchanged'));}}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-component',this));},{}],3:[function(require,module,exports){(function(define){define(function(require,exports,module){var base=window.GAIA_ICONS_BASE_URL||window.COMPONENTS_BASE_URL||'bower_components/';if(!document.documentElement){window.addEventListener('load',load);}else{load();}
function load(){if(isLoaded()){return;}
var link=document.createElement('link');link.rel='stylesheet';link.type='text/css';link.href=base+'gaia-icons/gaia-icons.css';document.head.appendChild(link);exports.loaded=true;}
function isLoaded(){return exports.loaded||document.querySelector('link[href*=gaia-icons]')||document.documentElement.classList.contains('gaia-icons-loaded');}});})(typeof define=='function'&&define.amd?define:(function(n,w){return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-icons',this));},{}],4:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var component=require('gaia-component');var fontFit=require('font-fit');require('gaia-icons');var debug=0?console.log.bind(console):function(){};const KNOWN_ACTIONS={menu:'menu',back:'back',close:'close'};const TITLE_FONT='italic 300 24px FiraSans';const TITLE_PADDING=10;const MINIMUM_FONT_SIZE_CENTERED=20;const MINIMUM_FONT_SIZE_UNCENTERED=16;const MAXIMUM_FONT_SIZE=23;module.exports=component.register('gaia-header',{created:function(){debug('created');this.setupShadowRoot();this.els={actionButton:this.shadowRoot.querySelector('.action-button'),buttons:this.querySelectorAll('button, a'),titles:this.querySelectorAll('h1')};this.els.actionButton.addEventListener('click',e=>this.onActionButtonClick(e));this.observer=new MutationObserver(this.onMutation.bind(this));this.titleEnd=this.getAttribute('title-end');this.titleStart=this.getAttribute('title-start');this.noFontFit=this.getAttribute('no-font-fit');this.notFlush=this.hasAttribute('not-flush');this.action=this.getAttribute('action');this.unresolved={};this.pending={};this._resizeThrottlingId=null;this.onResize=this.onResize.bind(this);},attached:function(){debug('attached');this.runFontFitSoon();this.observerStart();window.addEventListener('resize',this.onResize);},detached:function(){debug('detached');window.removeEventListener('resize',this.onResize);this.observerStop();this.clearPending();},clearPending:function(){for(var key in this.pending){this.pending[key].clear();delete this.pending[key];}
window.cancelAnimationFrame(this._resizeThrottlingId);this._resizeThrottlingId=null;},runFontFit:function(){debug('run font-fit');if(this.noFontFit){return Promise.resolve();}
var titles=this.els.titles;var space=this.getTitleSpace();var styles=[].map.call(titles,el=>this.getTitleStyle(el,space));return this.setTitleStylesSoon(styles);},runFontFitSoon:function(){debug('run font-fit soon');if(this.pending.runFontFitSoon){return;}
this.pending.runFontFitSoon=this.nextTick(()=>{delete this.pending.runFontFitSoon;this.runFontFit();});},getTitleStyle:function(el,space){debug('get el style',el,space);var text=el.textContent;var styleId=space.start+text+space.end+'#'+space.value;if(!text||!text.trim()){return debug('exit: no text');}
if(getStyleId(el)===styleId){return debug('exit: no change');}
var marginStart=this.getTitleMarginStart();var textSpace=space.value-Math.abs(marginStart);var fontFitResult=this.fontFit(text,textSpace,{min:MINIMUM_FONT_SIZE_CENTERED});var overflowing=fontFitResult.overflowing;var padding={start:0,end:0};if(overflowing){debug('title overflowing');padding.start=!space.start?TITLE_PADDING:0;padding.end=!space.end?TITLE_PADDING:0;textSpace=space.value-padding.start-padding.end;fontFitResult=this.fontFit(text,textSpace);marginStart=0;}
return{id:styleId,fontSize:fontFitResult.fontSize,marginStart:marginStart,overflowing:overflowing,padding:padding};},setTitleStylesSoon:function(styles){debug('set title styles soon',styles);var key='setStyleTitlesSoon';this._titleStyles=styles;return this.unresolved[key]=this.unresolved[key]||new Promise((resolve)=>{this.pending[key]=this.nextTick(()=>{var styles=this._titleStyles;var els=this.els.titles;[].forEach.call(els,(el,i)=>{if(!styles[i]){return debug('exit');}
this.setTitleStyle(el,styles[i]);});delete this._titleStyles;delete this.unresolved[key];delete this.pending[key];resolve();});});},setTitleStyle:function(el,style){debug('set title style',style);this.observerStop();el.style.marginLeft=style.marginStart+'px';el.style.paddingLeft=style.padding.start+'px';el.style.paddingRight=style.padding.end+'px';el.style.fontSize=style.fontSize+'px';setStyleId(el,style.id);this.observerStart();},fontFit:function(text,space,opts={}){debug('font fit:',text,space,opts);var fontFitArgs={font:TITLE_FONT,min:opts.min||MINIMUM_FONT_SIZE_UNCENTERED,max:MAXIMUM_FONT_SIZE,text:text,space:space};return fontFit(fontFitArgs);},observerStart:function(){if(this.observing){return;}
this.observer.observe(this,{childList:true,attributes:true,subtree:true});this.observing=true;debug('observer started');},observerStop:function(){if(!this.observing){return;}
this.observer.disconnect();this.observing=false;debug('observer stopped');},onResize:function(e){debug('onResize',this._resizeThrottlingId);if(this._resizeThrottlingId!==null){return;}
this._resizeThrottlingId=window.requestAnimationFrame(()=>{this._resizeThrottlingId=null;this.runFontFitSoon();});},onMutation:function(mutations){debug('on mutation',mutations);if(!this.pending.runFontFitSoon){this.runFontFit();}},getTitleSpace:function(){var start=this.titleStart;var end=this.titleEnd;var space=this.getWidth()-start-end;var result={value:space,start:start,end:end};debug('get title space',result);return result;},getWidth:function(){var value=this.notFlush?this.clientWidth:window.innerWidth;debug('get width',value);return value;},triggerAction:function(){if(this.action){this.els.actionButton.click();}},onActionButtonClick:function(){debug('action button click');var config={detail:{type:this.action}};var e=new CustomEvent('action',config);setTimeout(()=>this.dispatchEvent(e));},getTitleMarginStart:function(){var start=this.titleStart;var end=this.titleEnd;var marginStart=end-start;debug('get title margin start',marginStart);return marginStart;},getButtonsBeforeTitle:function(){var children=this.children;var l=children.length;var els=[];for(var i=0;i<l;i++){var el=children[i];if(el.tagName==='H1'){break;}
if(!contributesToLayout(el)){continue;}
els.push(el);}
if(this.action){els.push(this.els.actionButton);}
return els;},getButtonsAfterTitle:function(){var children=this.children;var els=[];for(var i=children.length-1;i>=0;i--){var el=children[i];if(el.tagName==='H1'){break;}
if(!contributesToLayout(el)){continue;}
els.push(el);}
return els;},sumButtonWidths:function(buttons){var defaultWidth=50;var sum=buttons.reduce((prev,button)=>{var isStandardButton=button===this.els.actionButton;var width=isStandardButton?defaultWidth:button.clientWidth;return prev+width;},0);debug('sum button widths',buttons,sum);return sum;},attrs:{action:{get:function(){return this._action;},set:function(value){var action=KNOWN_ACTIONS[value];if(action===this._action){return;}
this.setAttr('action',action);this._action=action;},},titleStart:{get:function(){debug('get title-start');if('_titleStart'in this){return this._titleStart;}
var buttons=this.getButtonsBeforeTitle();var value=this.sumButtonWidths(buttons);debug('get title-start',buttons,value);return value;},set:function(value){debug('set title-start',value);value=parseInt(value,10);if(value===this._titleStart||isNaN(value)){return;}
this.setAttr('title-start',value);this._titleStart=value;debug('set');}},titleEnd:{get:function(){debug('get title-end');if('_titleEnd'in this){return this._titleEnd;}
var buttons=this.getButtonsAfterTitle();return this.sumButtonWidths(buttons);},set:function(value){debug('set title-end',value);value=parseInt(value,10);if(value===this._titleEnd||isNaN(value)){return;}
this.setAttr('title-end',value);this._titleEnd=value;}},noFontFit:{get:function(){return this._noFontFit||false;},set:function(value){debug('set no-font-fit',value);value=!!(value||value==='');if(value===this.noFontFit){return;}
this._noFontFit=value;if(value){this.setAttr('no-font-fit','');}
else{this.removeAttr('no-font-fit');}}}},template:`<div class="inner">
    <button class="action-button">
      <content select=".l10n-action"></content>
    </button>
    <content></content>
  </div>

  <style>

  :host {
    display: block;
    -moz-user-select: none;

    --gaia-header-button-color:
      var(--header-button-color,
      var(--header-color,
      var(--link-color,
      inherit)));
  }

  /**
   * [hidden]
   */

  :host[hidden] {
    display: none;
  }

  /** Reset
   ---------------------------------------------------------*/

  ::-moz-focus-inner { border: 0; }

  /** Inner
   ---------------------------------------------------------*/

  .inner {
    display: flex;
    min-height: 50px;
    direction: ltr;
    -moz-user-select: none;

    background:
      var(--header-background,
      var(--background,
      #fff));
  }

  /** Action Button
   ---------------------------------------------------------*/

  /**
   * 1. Hidden by default
   */

  .action-button {
    position: relative;

    display: none; /* 1 */
    width: 50px;
    font-size: 30px;
    margin: 0;
    padding: 0;
    border: 0;
    outline: 0;

    align-items: center;
    background: none;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [action=back]
   * [action=menu]
   * [action=close]
   *
   * 1. For icon vertical-alignment
   */

  [action=back] .action-button,
  [action=menu] .action-button,
  [action=close] .action-button {
    display: flex; /* 1 */
  }

  /**
   * :active
   */

  .action-button:active {
    transition: none;
    opacity: 0.2;
  }

  /** Action Button Icon
   ---------------------------------------------------------*/

  .action-button:before {
    font-family: 'gaia-icons';
    font-style: normal;
    text-rendering: optimizeLegibility;
    font-weight: 500;
  }

  [action=close] .action-button:before { content: 'close' }
  [action=back] .action-button:before { content: 'back' }
  [action=menu] .action-button:before { content: 'menu' }

  /** Action Button Icon
   ---------------------------------------------------------*/

  /**
   * 1. To enable vertical alignment.
   */

  .action-button:before {
    display: block;
  }

  /** Action Button Text
   ---------------------------------------------------------*/

  /**
   * To provide custom localized content for
   * the action-button, we allow the user
   * to provide an element with the class
   * .l10n-action. This node is then
   * pulled inside the real action-button.
   *
   * Example:
   *
   *   <gaia-header action="back">
   *     <span class="l10n-action" aria-label="Back">Localized text</span>
   *     <h1>title</h1>
   *   </gaia-header>
   */

  ::content .l10n-action {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    font-size: 0;
  }

  /** Title
   ---------------------------------------------------------*/

  /**
   * 1. Vertically center text. We can't use flexbox
   *    here as it breaks text-overflow ellipsis
   *    without an inner div.
   */

  ::content h1 {
    flex: 1;
    margin: 0;
    padding: 0;
    overflow: hidden;

    white-space: nowrap;
    text-overflow: ellipsis;
    text-align: center;
    line-height: 50px; /* 1 */
    font-weight: 300;
    font-style: italic;
    font-size: 24px;

    color:
      var(--header-title-color,
      var(--header-color,
      var(--title-color,
      var(--text-color,
      inherit))));
  }

  /**
   * [dir=rtl]
   *
   * When the document is in RTL mode we still
   * want the <h1> text to be reversed to that
   * strings like '1 selected' become 'selected 1'.
   *
   * When we're happy for gaia-header to be fully
   * RTL responsive we won't need this rule anymore,
   * but this depends on all Gaia apps being ready.
   */

  :host-context([dir=rtl]) ::content h1 {
    direction: rtl;
  }

  /** Buttons
   ---------------------------------------------------------*/

  ::content a,
  ::content button {
    position: relative;
    z-index: 1;
    box-sizing: border-box;
    display: flex;
    width: auto;
    height: auto;
    min-width: 50px;
    margin: 0;
    padding: 0 10px;
    outline: 0;
    border: 0;

    font-size: 14px;
    line-height: 1;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    text-align: center;
    background: none;
    border-radius: 0;
    font-style: italic;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color: var(--gaia-header-button-color);
  }

  /**
   * :active
   */

  ::content a:active,
  ::content button:active {
    transition: none;
    opacity: 0.2;
  }

  /**
   * [hidden]
   */

  ::content a[hidden],
  ::content button[hidden] {
    display: none;
  }

  /**
   * [disabled]
   */

  ::content a[disabled],
  ::content button[disabled] {
    pointer-events: none;
    color: var(--header-disabled-button-color);
  }

  /** Icon Buttons
   ---------------------------------------------------------*/

  /**
   * Icons are a different color to text
   */

  ::content .icon,
  ::content [data-icon] {
    color:
      var(--header-icon-color,
      var(--gaia-header-button-color));
  }

  /**
   * If users want their action button
   * to be in the component's light-dom
   * they can add an .action class
   * to make it look like the
   * shadow action button.
   */

  ::content .action {
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [data-icon]:empty
   *
   * Icon buttons with no textContent,
   * should always be 50px.
   *
   * This is to prevent buttons being
   * larger than they should be before
   * icon-font has loaded.
   */

  ::content [data-icon]:empty {
    width: 50px;
  }

  </style>`,nextTick:nextTick});function contributesToLayout(el){return el.tagName!=='STYLE';}
function setStyleId(el,id){el._styleId=id;}
function getStyleId(el){return el._styleId;}
function nextTick(fn){var cleared;Promise.resolve().then(()=>{if(!cleared){fn();}});return{clear:function(){cleared=true;}};}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-header',this));},{"font-fit":1,"gaia-component":2,"gaia-icons":3}]},{},[4])(4)});;'use strict';(function(exports){var GLOBAL_DEBUG=false;var AVAILABLE_MODULES={};var BaseModule=function(){};BaseModule.SUB_MODULES=[];BaseModule.SUB_MODULE_PARENT=window;BaseModule.EVENTS=[];BaseModule.SETTINGS=[];BaseModule.IMPORTS=[];BaseModule.SERVICES=[];BaseModule.STATES=[];var SubmoduleMixin={_startSubModules:function(){if(!this.constructor.SUB_MODULES||this.constructor.SUB_MODULES.length===0){return;}
this.debug('lazy loading submodules: '+
this.constructor.SUB_MODULES.concat());BaseModule.lazyLoad(this.constructor.SUB_MODULES).then(function(){this.debug('lazy loaded submodules: '+
this.constructor.SUB_MODULES.concat());this.constructor.SUB_MODULES.forEach(function(module){var moduleName=BaseModule.lowerCapital(module);var parent=this.constructor.SUB_MODULE_PARENT||this;if(!parent[moduleName]){this._initialSubModule(moduleName,module);}},this);}.bind(this));},_initialSubModule:function(moduleName,module){var parent=this.constructor.SUB_MODULE_PARENT||this;var constructor=AVAILABLE_MODULES[module]||window[module];if(typeof(constructor)=='function'){this.debug('instantiating submodule: '+moduleName);parent[moduleName]=new constructor(this);if(typeof(this['_'+moduleName+'_loaded'])=='function'){this['_'+moduleName+'_loaded']();}else if(this.lifeCycleState!=='stopped'){parent[moduleName].start&&parent[moduleName].start();}}},_stopSubModules:function(){if(!this.constructor.SUB_MODULES){return;}
this.constructor.SUB_MODULES.forEach(function(module){var moduleName=BaseModule.lowerCapital(module);var parent=this.constructor.SUB_MODULE_PARENT||this;if(parent[moduleName]){this.debug('Stopping submodule: '+moduleName);parent[moduleName].stop&&parent[moduleName].stop();}},this);}};var SettingMixin={observe:function(name,value){this.debug('observing '+name+' : '+value);this._settings[name]=value;if(typeof(this['_observe_'+name])=='function'){this.debug('observer for '+name+' found, invoking.');this['_observe_'+name](value);}},_observeSettings:function(){if(!this.constructor.SETTINGS){this.debug('No settings needed, skipping.');return;}
this._settings={};this.debug('~observing following settings: '+
this.constructor.SETTINGS.concat());this.constructor.SETTINGS.forEach(function(setting){this.service.request('SettingsCore:addObserver',setting,this);},this);},_unobserveSettings:function(){if(!this.constructor.SETTINGS){return;}
this.constructor.SETTINGS.forEach(function(setting){this.service.request('SettingsCore:removeObserver',setting,this);},this);}};var EventMixin={_pre_handleEvent:function(){},_post_handleEvent:function(){},_subscribeEvents:function(){if(!this.constructor.EVENTS){this.debug('No events wanted, skipping.');return;}
this.debug('event subcribing stage..');this.constructor.EVENTS.forEach(function(event){this.debug('subscribing '+event);window.addEventListener(event,this);},this);},_unsubscribeEvents:function(){if(!this.constructor.EVENTS){return;}
this.constructor.EVENTS.forEach(function(event){window.removeEventListener(event,this);},this);},handleEvent:function(evt){if(typeof(this._pre_handleEvent)=='function'){var shouldContinue=this._pre_handleEvent(evt);if(shouldContinue===false){return;}}else{console.log('no handle event pre found. skip');}
if(typeof(this['_handle_'+evt.type])=='function'){this.debug('handling '+evt.type);this['_handle_'+evt.type](evt);}
if(typeof(this._post_handleEvent)=='function'){this._post_handleEvent(evt);}}};var ServiceMixin={_registerServices:function(){if(!this.constructor.SERVICES){return;}
this.constructor.SERVICES.forEach(function(service){this.service.register(service,this);},this);},_unregisterServices:function(){if(!this.constructor.SERVICES){return;}
this.constructor.SERVICES.forEach(function(service){this.service.unregister(service,this);},this);}};var StateMixin={_registerStates:function(){if(!this.constructor.STATES){return;}
this.constructor.STATES.forEach(function(state){this.service.registerState(state,this);},this);},_unregisterStates:function(){if(!this.constructor.STATES){return;}
this.constructor.STATES.forEach(function(state){this.service.unregisterState(state,this);},this);}};BaseModule.mixin=function(prototype,mixin){for(var prop in mixin){if(mixin.hasOwnProperty(prop)){prototype[prop]=mixin[prop];}}};BaseModule.create=function(constructor,prototype,properties){constructor.prototype=Object.create(BaseModule.prototype,properties);constructor.prototype.constructor=constructor;if(constructor.SETTINGS){BaseModule.mixin(constructor.prototype,SettingMixin);}
if(constructor.EVENTS){BaseModule.mixin(constructor.prototype,EventMixin);}
if(constructor.SERVICES){BaseModule.mixin(constructor.prototype,ServiceMixin);}
if(constructor.STATES){BaseModule.mixin(constructor.prototype,StateMixin);}
if(constructor.SUB_MODULES){BaseModule.mixin(constructor.prototype,SubmoduleMixin);}
if(prototype){BaseModule.mixin(constructor.prototype,prototype);if(prototype.name){AVAILABLE_MODULES[prototype.name]=constructor;}else{console.warn('No name give, impossible to instantiate without name.');}}
return constructor;};BaseModule.instantiate=function(moduleName){if(moduleName in AVAILABLE_MODULES){var args=Array.prototype.slice.call(arguments,1);var constructor=function(){AVAILABLE_MODULES[moduleName].apply(this,args);};constructor.prototype=AVAILABLE_MODULES[moduleName].prototype;return new constructor();}
return undefined;};BaseModule.lazyLoad=function(array){var self=this;return new Promise(function(resolve){var fileList=[];array.forEach(function(module){fileList.push(BaseModule.object2fileName(module));},self);LazyLoader.load(fileList,function(){resolve();});});};BaseModule.lowerCapital=function(str){return str.charAt(0).toLowerCase()+str.slice(1);};BaseModule.object2fileName=function(strings){var i=0;var ch='';while(i<=strings.length){var character=strings.charAt(i);if(character!==character.toLowerCase()){if(ch===''){ch+=character.toLowerCase();}else{ch+='_'+character.toLowerCase();}}else{ch+=character;}
i++;}
return'/js/'+ch+'.js';};BaseModule.prototype={service:window.Service,DEBUG:false,TRACE:false,name:'(Anonymous)',EVENT_PREFIX:'',lifeCycleState:'stopped',publish:function(event,detail,noPrefix){var prefix=noPrefix?'':this.EVENT_PREFIX;var evt=new CustomEvent(prefix+event,{bubbles:true,detail:detail||this});this.debug('publishing: '+prefix+event);window.dispatchEvent(evt);},debug:function(){if(this.DEBUG||GLOBAL_DEBUG){console.log('['+this.name+']'+'['+this.service.currentTime()+'] '+
Array.slice(arguments).concat());if(this.TRACE){console.trace();}}else if(window.DUMP){DUMP('['+this.name+']'+'['+this.service.currentTime()+'] '+
Array.slice(arguments).concat());}},info:function(){if(this.DEBUG||GLOBAL_DEBUG){console.info('['+this.name+']'+'['+this.service.currentTime()+'] '+
Array.slice(arguments).concat());}},warn:function(){if(this.DEBUG||GLOBAL_DEBUG){console.warn('['+this.name+']'+'['+this.service.currentTime()+'] '+
Array.slice(arguments).concat());}},error:function(){if(this.DEBUG||GLOBAL_DEBUG){console.error('['+this.name+']'+'['+this.service.currentTime()+'] '+
Array.slice(arguments).concat());}},writeSetting:function(settingObject){this.debug('writing '+JSON.stringify(settingObject)+' to settings db');return this.service.request('SettingsCore:set',settingObject);},readSetting:function(name){this.debug('reading '+name+' from settings db');return this.service.request('SettingsCore:get',name);},_start:function(){},_stop:function(){},start:function(){if(this.lifeCycleState!=='stopped'){this.warn('already started');return;}
this.switchLifeCycle('starting');this.imports();},__imported:function(){if(this.lifeCycleState==='stopped'){this.warn('already stopped');return;}
this._startSubModules&&this._startSubModules();this._start();this._subscribeEvents&&this._subscribeEvents();this._observeSettings&&this._observeSettings();this._registerServices&&this._registerServices();this._registerStates&&this._registerStates();this.switchLifeCycle('started');},stop:function(){if(this.lifeCycleState==='stopped'){this.warn('already stopped');return;}
this._unregisterServices&&this._unregisterServices();this._unregisterStates&&this._unregisterStates();this._stopSubModules&&this._stopSubModules();this._unsubscribeEvents&&this._unsubscribeEvents();this._unobserveSettings&&this._unobserveSettings();this._stop();this.switchLifeCycle('stopped');},switchLifeCycle:function(state){if(this.lifeCycleState===state){return;}
this.debug('life cycle state change: '+
this.lifeCycleState+' -> '+state);this.lifeCycleState=state;this.publish(state);},imports:function(){if(!this.constructor.IMPORTS||typeof(this.constructor.IMPORTS)=='undefined'||this.constructor.IMPORTS.length===0){this.__imported();return;}
this.debug(this.constructor.IMPORTS);this.debug('import loading.');LazyLoader.load(this.constructor.IMPORTS,function(){this.__imported();}.bind(this));}};exports.BaseModule=BaseModule;}(window));;'use strict';(function(exports){var Core=function(){};Core.SUB_MODULES=['HierarchyManager','AirplaneMode','NotificationsSystemMessage'];Core.SERVICES=['getAPI'];BaseModule.create(Core,{name:'Core',REGISTRY:{'mozSettings':'SettingsCore','mozBluetooth':'BluetoothCore','mozMobileConnections':'MobileConnectionCore'},getAPI:function(api){for(var key in this.REGISTRY){if(api===BaseModule.lowerCapital(key.replace('moz',''))){return navigator[key];}}
return false;},_start:function(){for(var api in this.REGISTRY){this.debug('Detecting API: '+api+' and corresponding module: '+this.REGISTRY[api]);if(navigator[api]){this.debug('API: '+api+' found, starting the handler.');this.startAPIHandler(api,this.REGISTRY[api]);}else{this.debug('API: '+api+' not found, skpping the handler.');}}},startAPIHandler:function(api,handler){return new Promise(function(resolve,reject){BaseModule.lazyLoad([handler]).then(function(){var moduleName=BaseModule.lowerCapital(handler);if(window[handler]&&typeof(window[handler])==='function'){this[moduleName]=new window[handler](navigator[api],this);}else{this[moduleName]=BaseModule.instantiate(handler,navigator[api],this);}
if(!this[moduleName]){reject();}
this[moduleName].start&&this[moduleName].start();resolve();}.bind(this));}.bind(this));},_stop:function(){for(var api in this.REGISTRY){var moduleName=this.REGISTRY[api].charAt(0).toUpperCase()+
this.REGISTRY[api].slice(1);this[moduleName]&&this[moduleName].stop();}}});}(window));;'use strict';(function(exports){var WakeLockManagerBase=function WakeLockManagerBase(){this._started=false;this.isHeld=undefined;};WakeLockManagerBase.prototype.TOPIC=undefined;WakeLockManagerBase.prototype.ACCEPT_BACKBROUND_WAKE_LOCK=true;WakeLockManagerBase.prototype.onwakelockchange=null;WakeLockManagerBase.prototype.setIsHeld=function(state){if(this.ACCEPT_BACKBROUND_WAKE_LOCK){this.isHeld=(state!=='unlocked');}else{this.isHeld=(state==='locked-foreground');}};WakeLockManagerBase.prototype.start=function(){if(!this.TOPIC){throw new Error('WakeLockManagerBase: '+'TOPIC is not set; you should not be using the base directly.');}
if(this._started){throw new Error('WakeLockManagerBase: should not be start()\'ed twice.');}
this._started=true;navigator.mozPower.addWakeLockListener(this);var state=navigator.mozPower.getWakeLockState(this.TOPIC);this.setIsHeld(state);};WakeLockManagerBase.prototype.stop=function(){if(!this._started){throw new Error('WakeLockManagerBase: '+'Instance was never start()\'ed but stop() is called.');}
this._started=false;navigator.mozPower.removeWakeLockListener(this);this._listener=null;};WakeLockManagerBase.prototype.callback=function(topic,state){if(topic!==this.TOPIC){return;}
var isPreviouslyHeld=this.isHeld;this.setIsHeld(state);if(this.isHeld!==isPreviouslyHeld&&typeof this.onwakelockchange==='function'){this.onwakelockchange(this.isHeld);}};var ScreenWakeLockManager=function ScreenWakeLockManager(){WakeLockManagerBase.apply(this,arguments);};ScreenWakeLockManager.prototype=Object.create(WakeLockManagerBase.prototype);ScreenWakeLockManager.prototype.TOPIC='screen';ScreenWakeLockManager.prototype.ACCEPT_BACKBROUND_WAKE_LOCK=false;var CpuWakeLockManager=function CpuWakeLockManager(){WakeLockManagerBase.apply(this,arguments);};CpuWakeLockManager.prototype=Object.create(WakeLockManagerBase.prototype);CpuWakeLockManager.prototype.TOPIC='cpu';var WifiWakeLockManager=function WifiWakeLockManager(){WakeLockManagerBase.apply(this,arguments);};WifiWakeLockManager.prototype=Object.create(WakeLockManagerBase.prototype);WifiWakeLockManager.prototype.TOPIC='wifi';exports.ScreenWakeLockManager=ScreenWakeLockManager;exports.CpuWakeLockManager=CpuWakeLockManager;exports.WifiWakeLockManager=WifiWakeLockManager;}(window));;'use strict';(function(exports){var CpuManager=function CpuManager(){this._wakeLockManager=null;this._started=false;};CpuManager.prototype.start=function(){if(this._started){throw new Error('CpuManager: should not be start()\'ed twice.');}
if(!navigator.mozPower){return;}
this._started=true;this._wakeLockManager=new CpuWakeLockManager();this._wakeLockManager.onwakelockchange=this._handleWakeLockChange.bind(this);this._wakeLockManager.start();};CpuManager.prototype.stop=function(){if(!this._started){throw new Error('CpuManager: '+'Instance was never start()\'ed but stop() is called.');}
this._started=false;this._wakeLockManager.stop();this._wakeLockManager=null;};CpuManager.prototype._handleWakeLockChange=function(isHeld){navigator.mozPower.cpuSleepAllowed=!isHeld;};exports.CpuManager=CpuManager;}(window));;'use strict';(function(exports){var ScreenBrightnessTransition=function ScreenBrightnessTransition(){this.isRunning=false;this._timer=undefined;};ScreenBrightnessTransition.prototype.STEP_INTERVAL_MS=20;ScreenBrightnessTransition.prototype.STEP_DELTA=0.01;ScreenBrightnessTransition.prototype.onsuccess=null;ScreenBrightnessTransition.prototype.transitionTo=function(brightness){if(this.isRunning){throw new Error('ScreenBrightnessTransition: '+'transitionTo() is called again during transition.');}
this.isRunning=true;var currentBrightness=navigator.mozPower.screenBrightness;this._timer=setInterval(function brightnessTransitionTick(){var delta=this.STEP_DELTA*((currentBrightness>brightness)?-1:1);currentBrightness+=delta;if((delta<0&&currentBrightness<brightness)||(delta>0&&currentBrightness>brightness)){navigator.mozPower.screenBrightness=brightness;clearTimeout(this._timer);this.isRunning=false;if(typeof this.onsuccess==='function'){this.onsuccess();}
return;}else{navigator.mozPower.screenBrightness=currentBrightness;}}.bind(this),this.STEP_INTERVAL_MS);};ScreenBrightnessTransition.prototype.abort=function(){if(!this.isRunning){throw new Error('ScreenBrightnessTransition: '+'abort() is called but it is not currently in transition.');}
clearTimeout(this._timer);this.isRunning=false;};exports.ScreenBrightnessTransition=ScreenBrightnessTransition;}(window));;'use strict';var ScreenManager={screenEnabled:false,_unlocking:false,_inTransition:false,_deviceLightEnabled:true,_userBrightness:1,_savedBrightness:1,AUTO_BRIGHTNESS_MINIMUM:0.1,AUTO_BRIGHTNESS_CONSTANT:0.27,AUTO_BRIGHTNESS_MIN_DELTA:10,_previousLux:undefined,_screenBrightnessTransition:null,LOCKING_TIMEOUT:10,_dimNotice:10*1000,_idleTimeout:0,_idleTimerId:0,_screenOffBy:null,_screenOffTimeout:0,_cpuWakeLock:null,init:function scm_init(){window.addEventListener('attentionopening',this);window.addEventListener('attentionopened',this);window.addEventListener('sleep',this);window.addEventListener('wake',this);window.addEventListener('nfc-tech-discovered',this);window.addEventListener('nfc-tech-lost',this);window.addEventListener('requestshutdown',this);window.addEventListener('unlocking-start',this);window.addEventListener('unlocking-stop',this);window.addEventListener('secure-appopened',this);window.addEventListener('secure-appterminated',this);window.addEventListener('accessibility-action',this);this.screen=document.getElementById('screen');this._screenBrightnessTransition=new ScreenBrightnessTransition();var self=this;var power=navigator.mozPower;this._wakeLockManager=new ScreenWakeLockManager();this._wakeLockManager.onwakelockchange=this._reconfigScreenTimeout.bind(this);this._wakeLockManager.start();this._firstOn=false;SettingsListener.observe('screen.timeout',60,function screenTimeoutChanged(value){if(typeof value!=='number'){value=parseInt(value);}
self._idleTimeout=value;self._setIdleTimeout(self._idleTimeout);if(!self._firstOn){self._firstOn=true;power.screenBrightness=0.5;self.turnScreenOn(false);}});SettingsListener.observe('screen.automatic-brightness',true,function deviceLightSettingChanged(value){self.setDeviceLightEnabled(value);});SettingsListener.observe('screen.brightness',1,function brightnessSettingChanged(value){self._userBrightness=value;self.setScreenBrightness(value,false);});var telephony=window.navigator.mozTelephony;if(telephony){telephony.addEventListener('callschanged',this);}},autoAdjustBrightness:function scm_adjustBrightness(lux){if(lux<1){lux=1;}
if(this._previousLux!==undefined){var brightnessDelta=Math.abs(this._previousLux-lux);if(brightnessDelta<=this.AUTO_BRIGHTNESS_MIN_DELTA){return;}}
this._previousLux=lux;var computedBrightness=Math.log10(lux)*this.AUTO_BRIGHTNESS_CONSTANT;var clampedBrightness=Math.max(this.AUTO_BRIGHTNESS_MINIMUM,Math.min(1.0,computedBrightness));this.setScreenBrightness(clampedBrightness,false);},handleEvent:function scm_handleEvent(evt){var telephony=window.navigator.mozTelephony;var call;switch(evt.type){case'attentionopening':case'attentionopened':if(!this.enabled){this.turnScreenOn();}
break;case'devicelight':if(!this._deviceLightEnabled||!this.screenEnabled||this._inTransition){return;}
this.autoAdjustBrightness(evt.value);break;case'sleep':this.turnScreenOff(true,'powerkey');break;case'wake':this.turnScreenOn();break;case'accessibility-action':this._reconfigScreenTimeout();break;case'nfc-tech-discovered':case'nfc-tech-lost':if(this._inTransition){this.turnScreenOn();}else{this._reconfigScreenTimeout();}
break;case'unlocking-start':this._setUnlocking();break;case'secure-appopened':case'secure-appterminated':this._reconfigScreenTimeout();break;case'unlocking-stop':this._resetUnlocking();break;case'userproximity':if(Bluetooth.isProfileConnected(Bluetooth.Profiles.SCO)||telephony.speakerEnabled||StatusBar.headphonesActive){if(this._screenOffBy=='proximity'){this.turnScreenOn();}
break;}
if(evt.near){this.turnScreenOff(true,'proximity');}else{this.turnScreenOn();}
break;case'callschanged':if(!telephony.calls.length&&!(telephony.conferenceGroup&&telephony.conferenceGroup.calls.length)){this.turnScreenOn();window.removeEventListener('userproximity',this);if(this._cpuWakeLock){this._cpuWakeLock.unlock();this._cpuWakeLock=null;}
break;}
if(this._cpuWakeLock){break;}
call=telephony.calls[0];call.addEventListener('statechange',this);break;case'statechange':call=evt.target;if(['connected','alerting','dialing'].indexOf(call.state)===-1){break;}
call.removeEventListener('statechange',this);this._cpuWakeLock=navigator.requestWakeLock('cpu');window.addEventListener('userproximity',this);break;case'lockscreen-appclosing':case'lockpanelchange':window.removeEventListener('lockscreen-appclosing',this);window.removeEventListener('lockpanelchange',this);this._setIdleTimeout(this._idleTimeout,false);break;case'requestshutdown':this.turnScreenOn();if(evt.detail&&evt.detail.startPowerOff){evt.detail.startPowerOff(false);}
break;}},toggleScreen:function scm_toggleScreen(){if(this.screenEnabled){this.turnScreenOff(true,'toggle');}else{this.turnScreenOn();}},turnScreenOff:function scm_turnScreenOff(instant,reason){if(!this.screenEnabled){return false;}
var self=this;if(reason){this._screenOffBy=reason;}
self._savedBrightness=navigator.mozPower.screenBrightness;if(this._cpuWakeLock!=null&&this._screenOffBy=='powerkey'){window.removeEventListener('userproximity',this);this._cpuWakeLock.unlock();this._cpuWakeLock=null;}
var screenOff=function scm_screenOff(){self._setIdleTimeout(0);if(self._deviceLightEnabled){window.removeEventListener('devicelight',self);}
window.removeEventListener('lockscreen-appclosing',self);window.removeEventListener('lockpanelchange',self);self.screenEnabled=false;self._inTransition=false;self.screen.classList.add('screenoff');clearTimeout(self._screenOffTimeout);self._screenOffTimeout=setTimeout(function realScreenOff(){self.setScreenBrightness(0,true);self.screenEnabled=false;navigator.mozPower.screenEnabled=false;},20);self.fireScreenChangeEvent();};if(instant){screenOff();return true;}
this.setScreenBrightness(0.1,false);this._inTransition=true;setTimeout(function noticeTimeout(){if(!self._inTransition){return;}
screenOff();},self._dimNotice);return true;},turnScreenOn:function scm_turnScreenOn(instant){clearTimeout(this._screenOffTimeout);if(this.screenEnabled){if(this._inTransition){this._inTransition=false;this.setScreenBrightness(this._savedBrightness,true);this._reconfigScreenTimeout();}
return false;}
var power=navigator.mozPower;if(power){power.screenEnabled=true;}
this.screenEnabled=true;this.setScreenBrightness(this._savedBrightness,instant);var telephony=window.navigator.mozTelephony;var ongoingConference=telephony&&telephony.conferenceGroup&&telephony.conferenceGroup.calls.length;if(!this._cpuWakeLock&&telephony&&(telephony.calls.length||ongoingConference)){var connected=telephony.calls.some(function checkCallConnection(call){if(call.state=='connected'){return true;}
return false;});if(connected||ongoingConference){this._cpuWakeLock=navigator.requestWakeLock('cpu');window.addEventListener('userproximity',this);}}
this.screen.classList.remove('screenoff');if(this._deviceLightEnabled){window.addEventListener('devicelight',this);}
this._reconfigScreenTimeout();this.fireScreenChangeEvent();return true;},_reconfigScreenTimeout:function scm_reconfigScreenTimeout(){if(this._wakeLockManager.isHeld||!Service.currentApp){this._setIdleTimeout(0);}else if(!this._unlocking){if(window.Service.locked&&!window.secureWindowManager.isActive()){this._setIdleTimeout(this.LOCKING_TIMEOUT,true);window.addEventListener('lockscreen-appclosing',this);window.addEventListener('lockpanelchange',this);}else{this._setIdleTimeout(this._idleTimeout,false);}}},_setUnlocking:function scm_setUnlocking(){this._unlocking=true;window.clearIdleTimeout(this._idleTimerId);},_resetUnlocking:function scm_resetUnlocking(){this._unlocking=false;this._reconfigScreenTimeout();},setScreenBrightness:function scm_setScreenBrightness(brightness,instant){this._targetBrightness=brightness;var power=navigator.mozPower;if(!power){return;}
if(this._screenBrightnessTransition.isRunning){this._screenBrightnessTransition.abort();}
if(typeof instant!=='boolean'){instant=true;}
if(instant){power.screenBrightness=brightness;return;}
this._screenBrightnessTransition.transitionTo(this._targetBrightness);},setDeviceLightEnabled:function scm_setDeviceLightEnabled(enabled){if(!enabled&&this._deviceLightEnabled){this.setScreenBrightness(this._userBrightness,false);}
this._deviceLightEnabled=enabled;this._previousLux=undefined;if(!this.screenEnabled){return;}
if(enabled){window.addEventListener('devicelight',this);}else{window.removeEventListener('devicelight',this);}},_setIdleTimeout:function scm_setIdleTimeout(time,instant){window.clearIdleTimeout(this._idleTimerId);this._idled=false;if(time===0){return;}
var self=this;var idleCallback=function idle_proxy(){self.turnScreenOff(instant,'idle_timeout');};var activeCallback=function active_proxy(){self.turnScreenOn(true);};var finalTimeout=instant?time*1000:(time*1000)-this._dimNotice;this._idleTimerId=window.setIdleTimeout(idleCallback,activeCallback,finalTimeout);},fireScreenChangeEvent:function scm_fireScreenChangeEvent(){var detail={screenEnabled:this.screenEnabled};detail.screenOffBy=this._screenOffBy;var evt=new CustomEvent('screenchange',{bubbles:true,cancelable:false,detail:detail});window.dispatchEvent(evt);}};ScreenManager.init();;'use strict';(function(exports){function Activities(){window.addEventListener('mozChromeEvent',this);window.addEventListener('appopened',this);this.actionMenu=null;}
Activities.prototype={handleEvent:function(evt){switch(evt.type){case'mozChromeEvent':var detail=evt.detail;switch(detail.type){case'activity-choice':this.chooseActivity(detail);break;}
break;case'appopened':if(this.actionMenu){this.actionMenu.hide();this.actionMenu=null;}
break;}},chooseActivity:function(detail){this._id=detail.id;var choices=detail.choices;this.publish('activityrequesting');if(choices.length===1){this.choose('0');}else{if(detail.name==='view'){var flAppIndex=choices.findIndex(function(choice){var matchingRegex=/^(http|https|app)\:\/\/fl\.gaiamobile\.org\//;return matchingRegex.test(choice.manifest);});if(flAppIndex!==-1){this.choose(flAppIndex.toString(10));return;}}
setTimeout((function nextTick(){window.dispatchEvent(new CustomEvent('activitymenuwillopen'));var activityNameL10nId='activity-'+detail.name;if(!this.actionMenu){this.actionMenu=new ActionMenu(this._listItems(choices),activityNameL10nId,this.choose.bind(this),this.cancel.bind(this));this.actionMenu.start();}}).bind(this));}},choose:function(choice){this.actionMenu=null;var returnedChoice={id:this._id,type:'activity-choice',value:choice};this._sendEvent(returnedChoice);delete this._id;},cancel:function(){this.actionMenu=null;var returnedChoice={id:this._id,type:'activity-choice',value:-1};this._sendEvent(returnedChoice);delete this._id;},publish:function(eventName){var event=new CustomEvent(eventName);window.dispatchEvent(event);},_sendEvent:function(value){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,value);window.dispatchEvent(event);},_listItems:function(choices){var items=[];choices.forEach(function(choice,index){var app=applications.getByManifestURL(choice.manifest);if(!app){return;}
items.push({label:new ManifestHelper(app.manifest).name,icon:choice.icon,value:index});});return items;}};exports.Activities=Activities;}(window));;'use strict';(function(exports){const DEBUG=false;var debug=function(str){console.log('usb_storage: '+str);};function UsbStorage(){this._mode=this.automounterDisable;this.bindUsbStorageChanged=this._usbStorageChanged.bind(this);this.start();}
UsbStorage.prototype={automounterDisable:0,automounterUmsEnable:1,automounterDisableWhenUnplugged:2,automounterMtpEnable:3,protocolUMS:'0',protocolMTP:'1',umsEnabled:'ums.enabled',umsMode:'ums.mode',usbTransferProtocol:'usb.transfer',_mode:undefined,_enabled:undefined,_protocol:undefined,start:function(){DEBUG&&debug('UsbStorage.start called');window.addEventListener('lockscreen-appopened',this);window.addEventListener('lockscreen-appclosed',this);SettingsListener.observe(this.umsEnabled,false,this.bindUsbStorageChanged);},stop:function(){DEBUG&&debug('UsbStorage.stop called');window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('lockscreen-appclosed',this);SettingsListener.unobserve(this.umsEnabled,this.bindUsbStorageChanged);},_protocolStr:function(protocol){if(protocol==this.protocolUMS){return'UMS';}
if(protocol==this.protocolMTP){return'MTP';}
return'???';},_modeStr:function(mode){if(mode==this.automounterDisable){return'Disabled';}
if(mode==this.automounterUmsEnable){return'Enable-UMS';}
if(mode==this.automounterDisableWhenUnplugged){return'DisabledWhenUnplugged';}
if(mode==this.automounterMtpEnable){return'Enable-MTP';}
return'???';},_usbStorageChanged:function(enabled){this._enabled=enabled;DEBUG&&debug('USB Storage Changed: '+enabled);this._getUsbProtocol();},_getUsbProtocol:function(){var req=navigator.mozSettings.createLock().get(this.usbTransferProtocol);req.onsuccess=function(){var protocol=this._keyMigration(req.result[this.usbTransferProtocol]);this._protocol=protocol;DEBUG&&debug('_getUsbProtocol: '+this._protocolStr(protocol));this._updateMode();}.bind(this);},_keyMigration:function(protocol){if(protocol===undefined){var cset={};cset[this.usbTransferProtocol]=this.protocolUMS;navigator.mozSettings.createLock().set(cset);return this.protocolUMS;}
return protocol;},_updateMode:function(){if(typeof(this._enabled)=='undefined'){DEBUG&&debug('_updateMode: _enabled not yet set - ignoring');return;}
var mode=this.automounterDisable;if(this._enabled&&!Service.locked){if(this._protocol==this.protocolMTP){mode=this.automounterMtpEnable;}else{mode=this.automounterUmsEnable;}}else{if(this._mode!=this.automounterDisable&&(this._protocol==this.protocolUMS||this._enabled)){mode=this.automounterDisableWhenUnplugged;}}
this._setMode(mode);},_setMode:function(mode){if(mode!=this._mode){this._mode=mode;var param={};param[this.umsMode]=mode;SettingsListener.getSettingsLock().set(param);}},handleEvent:function(e){switch(e.type){case'lockscreen-appopened':case'lockscreen-appclosed':this._updateMode();break;default:return;}}};exports.UsbStorage=UsbStorage;}(window));;'use strict';(function(exports){function ExternalStorageMonitor(){var storages=navigator.getDeviceStorages('sdcard');if(storages.length>1){storages.some(function(storage){if(storage.storageName!='sdcard'&&storage.canBeMounted){this._storage=storage;}}.bind(this));}else{this._storage=storages[0];}}
const RESET_JUST_ENTER_IDLE_STATUS_MILLISECONDS=1000;ExternalStorageMonitor.prototype={statusStack:[],'Init':-1,'NoMedia':0,'Idle':1,'Pending':2,'Checking':3,'Mounted':4,'Unmounting':5,'Formatting':6,'Shared':7,'Mount-Fail':9,actionRecognised:/02134$/,actionUnrecognised:/39$/,actionRemoved:/4510$/,actionUnrecognisedStorageRemoved:/90$/,justEnterIdleLessThanOneSecond:null,resetJustEnterIdleFlagTimer:null,_storage:null,start:function(){if(!this._storage){return;}
var statusReq=this._storage.storageStatus();statusReq.onsuccess=statusReq.onerror=(evt)=>{var curStorageStatus=evt.target.result;this.enableStorageUnrecognised(curStorageStatus==='Mount-Fail');this._storage.addEventListener('storage-state-change',this);var msg='[ExternalStorageMonitor] initEvent(): '+'monitor external storage name = '+
this._storage.storageName+', canBeMounted = '+
this._storage.canBeMounted;this.debug(msg);};},pushStatus:function(status){this.statusStack.push(this[status]);},clearStatus:function(){this.statusStack=[this.statusStack.pop()];var actionsFlags=this.statusStack.join('');var msg='[ExternalStorageMonitor] clearStatus(): '+'actionsFlags = '+actionsFlags;this.debug(msg);},enableEnterIdleStateTimer:function(){this.justEnterIdleLessThanOneSecond=true;if(this.resetJustEnterIdleFlagTimer){clearTimeout(this.resetJustEnterIdleFlagTimer);}
this.resetJustEnterIdleFlagTimer=setTimeout(function(){this.justEnterIdleLessThanOneSecond=false;}.bind(this),RESET_JUST_ENTER_IDLE_STATUS_MILLISECONDS);},recogniseStorageActions:function(){var actionsFlags=this.statusStack.join('');var msg='[ExternalStorageMonitor] recogniseStorageActions(): '+'actionsFlags = '+actionsFlags;this.debug(msg);if(actionsFlags.match(this.actionRecognised)){this.clearStatus();this.enableStorageUnrecognised(false);this.createMessage('detected-recognised');}else if(actionsFlags.match(this.actionUnrecognised)){this.clearStatus();this.enableStorageUnrecognised(true);this.createMessage('detected-unrecognised');}else if(actionsFlags.match(this.actionRemoved)){this.clearStatus();this.enableStorageUnrecognised(false);if(!this.justEnterIdleLessThanOneSecond){this.createMessage('normally-removed');}else{this.createMessage('unexpectedly-removed');}}else if(actionsFlags.match(this.actionUnrecognisedStorageRemoved)){this.clearStatus();this.enableStorageUnrecognised(false);}},enableStorageUnrecognised:function(enabled){var setRequest=navigator.mozSettings.createLock().set({'volume.external.unrecognised':enabled});setRequest.onerror=function(){var msg='[ExternalStorageMonitor] set settings key error:'+
setRequest.error.name;this.debug(msg);}.bind(this);setRequest.onsuccess=function(){var msg='[ExternalStorageMonitor] set settings key onsuccess';this.debug(msg);}.bind(this);},createMessage:function(action){var msg='[ExternalStorageMonitor] createMessage(): action = '+action;this.debug(msg);var _=navigator.mozL10n.get;var title,body;switch(action){case'detected-recognised':this.getTotalSpace(function(totalSpace){title=_('sdcard-detected-title');body=_('sdcard-total-size-body',{size:totalSpace.size,unit:totalSpace.unit});this.fireNotification(title,body,true);}.bind(this));break;case'detected-unrecognised':title=_('sdcard-detected-title');body=_('sdcard-unknown-size-then-tap-to-format-body');this.fireNotification(title,body,true);break;case'normally-removed':title=_('sdcard-removed-title');body=_('sdcard-removed-ejected-successfully');this.fireNotification(title,body);break;case'unexpectedly-removed':title=_('sdcard-removed-title');body=_('sdcard-removed-not-ejected-properly');this.fireNotification(title,body);break;}},fireNotification:function(title,body,openSettings){var iconUrl=window.location.origin+'/style/storage_status/'+'notification_sd_card.png';var notificationId='sdcard-storage-status';var options={body:body,icon:iconUrl,tag:notificationId};var notification=new Notification(title,options);notification.onclick=this.notificationHandler.bind(this,notification,openSettings);},notificationHandler:function(notification,openSettings){notification.close();if(!openSettings){return;}
var activityReq=new MozActivity({name:'configure',data:{target:'device',section:'mediaStorage'}});activityReq.onerror=function(e){var msg='[ExternalStorageMonitor] configure activity error:'+
activityReq.error.name;this.debug(msg);}.bind(this);activityReq.onsuccess=function(e){var msg='[ExternalStorageMonitor] configure activity onsuccess';this.debug(msg);}.bind(this);},handleEvent:function(e){switch(e.type){case'storage-state-change':var storageStatus=e.reason;var msg='[ExternalStorageMonitor] received '+'"storage-state-change" event '+'storageStatus = '+storageStatus;this.debug(msg);this.pushStatus(storageStatus);if(storageStatus==='Idle'){this.enableEnterIdleStateTimer();}
this.recogniseStorageActions();break;}},getTotalSpace:function(callback){var usedSpace,freeSpace;var self=this;this._storage.usedSpace().onsuccess=function(e){usedSpace=e.target.result;self._storage.freeSpace().onsuccess=function(e){freeSpace=e.target.result;var totalSpace=self.formatSize(usedSpace+freeSpace);if(callback){callback(totalSpace);}};};},formatSize:function(size){if(size===undefined||isNaN(size)){return;}
var units=['B','KB','MB','GB','TB','PB','EB','ZB','YB'];var i=0;while(size>=1024&&i<(units.length)-1){size/=1024;++i;}
var sizeDecimal=i<2?Math.round(size):Math.round(size*10)/10;var _=navigator.mozL10n.get;return{size:sizeDecimal,unit:_('byteUnit-'+units[i])};},_debug:false,debug:function(msg){if(this._debug){console.log(msg);}}};exports.ExternalStorageMonitor=ExternalStorageMonitor;}(window));;(function(exports){'use strict';function handleOpenUrl(url,isPrivate){var config=new BrowserConfigHelper({url:url});config.oop=true;config.isPrivate=isPrivate;var newApp=new AppWindow(config);newApp.requestOpen();}
function Browser(){}
Browser.prototype={start:function(){window.addEventListener('new-private-window',this.newPrivateWindow.bind(this));window.navigator.mozSetMessageHandler('activity',this.handleActivity.bind(this));},handleActivity:function(activity){var data=activity.source.data;switch(data.type){case'url':handleOpenUrl(UrlHelper.getUrlFromInput(data.url),data.isPrivate);break;}},newPrivateWindow:function(){var privateBrowserUrl=location.origin+'/private_browser.html';var config=new BrowserConfigHelper({url:privateBrowserUrl});config.oop=true;config.isPrivate=true;var newApp=new AppWindow(config);newApp.requestOpen();}};exports.Browser=Browser;}(window));;(function(exports){'use strict';function BrowserSettings(){}
BrowserSettings.prototype.addRemoteRequestSetting=function(key,requestFunction){function observer(setting){var isRequested=setting.settingValue;if(!isRequested){return;}
requestFunction();var lock=navigator.mozSettings.createLock();var falseSetting={};falseSetting[key]=false;lock.set(falseSetting);}
navigator.mozSettings.addObserver(key,observer);var getRequest=navigator.mozSettings.createLock().get(key);getRequest.onsuccess=function(){observer({settingName:key,settingValue:getRequest.result[key]});};};BrowserSettings.prototype.start=function(){this.addRemoteRequestSetting('clear.browser.history',function clearHistory(){window.places.clear();});this.addRemoteRequestSetting('clear.browser.private-data',function clearPrivateData(){var request=navigator.mozApps.getSelf();request.onsuccess=function(){request.result.clearBrowserData();};});};exports.BrowserSettings=BrowserSettings;})(window);;'use strict';var Shortcuts={init:function rm_init(){window.addEventListener('keyup',this);},handleEvent:function rm_handleEvent(evt){if(!ScreenManager.screenEnabled||evt.keyCode!==evt.DOM_VK_F6){return;}
document.location.reload();}};window.addEventListener('load',function startup(){function registerGlobalEntries(){KeyboardManager.init();TrustedUIManager.start();window.appWindowManager=new AppWindowManager();window.inputWindowManager=new window.InputWindowManager();window.inputWindowManager.start();window.activityWindowManager=new ActivityWindowManager();window.activityWindowManager.start();window.secureWindowManager=window.secureWindowManager||new SecureWindowManager();window.secureWindowFactory=new SecureWindowFactory();if(window.SuspendingAppPriorityManager){window.suspendingAppPriorityManager=new SuspendingAppPriorityManager();}
window.systemDialogManager=window.systemDialogManager||new SystemDialogManager();window.lockScreenWindowManager=new window.LockScreenWindowManager();window.lockScreenWindowManager.start();window.appWindowManager.start();window.textSelectionDialog=new TextSelectionDialog();}
function safelyLaunchFTU(){window.addEventListener('homescreen-ready',function onHomescreenReady(){window.removeEventListener('homescreen-ready',onHomescreenReady);FtuLauncher.retrieve();});if(!window.homescreenLauncher){window.homescreenLauncher=new HomescreenLauncher();}
window.homescreenLauncher.start();}
if(applications.ready){registerGlobalEntries();safelyLaunchFTU();}else{window.addEventListener('applicationready',function appListReady(event){window.removeEventListener('applicationready',appListReady);registerGlobalEntries();safelyLaunchFTU();});}
function doneWithFTU(){window.removeEventListener('ftudone',doneWithFTU);window.removeEventListener('ftuskip',doneWithFTU);var lock=window.navigator.mozSettings.createLock();lock.set({'gaia.system.checkForUpdates':true});window.settingsMigrator=new SettingsMigrator();window.settingsMigrator.start();}
window.addEventListener('ftudone',doneWithFTU);window.addEventListener('ftuskip',doneWithFTU);Shortcuts.init();ScreenManager.turnScreenOn();window.homescreenWindowManager=new HomescreenWindowManager();window.homescreenWindowManager.start();window.activities=new Activities();window.accessibility=new Accessibility();window.accessibility.start();window.appMigrator=new AppMigrator();window.appMigrator.start();window.appUsageMetrics=new AppUsageMetrics();window.appUsageMetrics.start();window.appWindowFactory=new AppWindowFactory();window.appWindowFactory.start();window.batteryOverlay=new BatteryOverlay();window.batteryOverlay.start();window.cellBroadcastSystem=new CellBroadcastSystem();window.cellBroadcastSystem.start();window.cpuManager=new CpuManager();window.cpuManager.start();window.developerHUD=new DeveloperHUD();window.developerHUD.start();window.attentionWindowManager=new window.AttentionWindowManager();window.attentionWindowManager.start();window.globalOverlayWindowManager=new window.GlobalOverlayWindowManager();window.globalOverlayWindowManager.start();window.dialerAgent=new DialerAgent();window.dialerAgent.start();window.edgeSwipeDetector=new EdgeSwipeDetector();window.edgeSwipeDetector.start();window.externalStorageMonitor=new ExternalStorageMonitor();window.externalStorageMonitor.start();window.homeGesture=new HomeGesture();window.homeGesture.start();if(!window.homescreenLauncher){window.homescreenLauncher=new HomescreenLauncher();}
window.lockScreenPasscodeValidator=new LockScreenPasscodeValidator();window.lockScreenPasscodeValidator.start();window.layoutManager=new LayoutManager();window.layoutManager.start();window.nfcUtils=new NfcUtils();window.nfcManager=new NfcManager();window.nfcManager.start();window.permissionManager=new PermissionManager();window.permissionManager.start();window.places=new Places();window.places.start();window.remoteDebugger=new RemoteDebugger();window.rocketbar=new Rocketbar();window.sleepMenu=new SleepMenu();window.sleepMenu.start();window.softwareButtonManager=new SoftwareButtonManager();window.softwareButtonManager.start();window.sourceView=new SourceView();window.taskManager=new TaskManager();window.taskManager.start();window.ttlView=new TTLView();window.visibilityManager=new VisibilityManager();window.visibilityManager.start();window.wallpaperManager=new window.WallpaperManager();window.wallpaperManager.start();if(navigator.mozL10n){navigator.mozL10n.once(function l10n_ready(){window.mediaRecording=new MediaRecording();window.mediaRecording.start();window.quickSettings=new QuickSettings();window.quickSettings.start();});}
window.focus();var evt=new CustomEvent('mozContentEvent',{bubbles:true,cancelable:false,detail:{type:'system-message-listener-ready'}});window.dispatchEvent(evt);window.performance.mark('loadEnd');window.core=BaseModule.instantiate('Core');window.core&&window.core.start();});window.usbStorage=new UsbStorage();window.addEventListener('wallpaperchange',function(evt){document.getElementById('screen').style.backgroundImage='linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.1)),'+'url('+evt.detail.url+')';});window.browser=new Browser();window.browser.start();window.browserSettings=new BrowserSettings();window.browserSettings.start();function cancelHomeTouchstart(e){if(e.touches[0].pageX===0&&e.touches[0].pageY===0){e.preventDefault();e.stopImmediatePropagation();}}
function cancelHomeTouchend(e){if(e.changedTouches[0].pageX===0&&e.changedTouches[0].pageY===0){e.preventDefault();e.stopImmediatePropagation();}}
function cancelHomeClick(e){if(e.pageX===0&&e.pageY===0){e.preventDefault();e.stopImmediatePropagation();}}
window.addEventListener('touchstart',cancelHomeTouchstart,true);window.addEventListener('touchend',cancelHomeTouchend,true);window.addEventListener('mousedown',cancelHomeClick,true);window.addEventListener('mouseup',cancelHomeClick,true);;'use strict';(function(exports){function Screenshot(){this._started=false;}
Screenshot.prototype={MAX_SCREENSHOT_SIZE:window.innerWidth*window.devicePixelRatio*window.innerHeight*window.devicePixelRatio*4+4096,start:function(){if(this._started){throw'Instance should not be start()\'ed twice.';}
this._started=true;Service.request('handleSystemMessageNotification','screenshot',this);window.addEventListener('volumedown+sleep',this);window.addEventListener('mozChromeEvent',this);},stop:function(){if(!this._started){throw'Instance was never start()\'ed but stop() is called.';}
this._started=false;Service.request('unhandleSystemMessageNotification','screenshot',this);window.removeEventListener('volumedown+sleep',this);window.removeEventListener('mozChromeEvent',this);},handleEvent:function(evt){switch(evt.type){case'volumedown+sleep':this.takeScreenshot();break;case'mozChromeEvent':if(evt.detail.type==='take-screenshot-success'){this.handleTakeScreenshotSuccess(evt.detail.file);}else if(evt.detail.type==='take-screenshot-error'){this._notify('screenshotFailed',evt.detail.error);}
break;default:console.debug('Unhandled event: '+evt.type);break;}},handleSystemMessageNotification:function(message){this.openImage(message.body);this.closeSystemMessageNotification(message);},closeSystemMessageNotification:function(msg){Notification.get({tag:msg.tag}).then(notifs=>{notifs.forEach(notif=>{if(notif.tag){if(notif.tag===msg.tag){notif.close&&notif.close();}}else{if(notif.body===msg.body){notif.close&&notif.close();}}});});},takeScreenshot:function(){navigator.vibrate(100);this._getDeviceStorage(function(){var screenshotProps={detail:{type:'take-screenshot'}};window.dispatchEvent(new CustomEvent('mozContentEvent',screenshotProps));});},openImage:function(filename){this._getDeviceStorage(function(storage){var request=storage.get(filename);request.onsuccess=function(){var imgblob=this.result;new MozActivity({name:'open',data:{type:imgblob.type,filename:filename,blob:imgblob,exitWhenHidden:true}});};});},handleTakeScreenshotSuccess:function(file){try{this._getDeviceStorage(function(storage){var d=new Date();d=new Date(d.getTime()-d.getTimezoneOffset()*60000);var filename='screenshots/'+
d.toISOString().slice(0,-5).replace(/[:T]/g,'-')+'.png';var saveRequest=storage.addNamed(file,filename);saveRequest.onsuccess=(function ss_onsuccess(){navigator.vibrate(100);this._notify('screenshotSaved',filename,null,this.openImage.bind(this,filename));}).bind(this);saveRequest.onerror=(function ss_onerror(){this._notify('screenshotFailed',saveRequest.error.name);}).bind(this);});}catch(e){console.log('exception in screenshot handler',e);this._notify('screenshotFailed',e.toString());}},_getDeviceStorage:function(callback){var storage=navigator.getDeviceStorage('pictures');var availreq=storage.available();availreq.onsuccess=(function(){var state=availreq.result;if(state==='unavailable'){this._notify('screenshotFailed',null,'screenshotNoSDCard');}
else if(state==='shared'){this._notify('screenshotFailed',null,'screenshotSDCardInUse');}
else if(state==='available'){var freereq=storage.freeSpace();freereq.onsuccess=(function(){if(freereq.result<this.MAX_SCREENSHOT_SIZE){this._notify('screenshotFailed',null,'screenshotSDCardLow');}else{callback.call(this,storage);}}).bind(this);freereq.onerror=(function(){this._notify('screenshotFailed',freereq.error&&freereq.error.name);}).bind(this);}}).bind(this);availreq.onerror=(function(){this._notify('screenshotFailed',availreq.error&&availreq.error.name);}).bind(this);},_notify:function notify(titleid,body,bodyid,onClick){var title=navigator.mozL10n.get(titleid)||titleid;body=body||navigator.mozL10n.get(bodyid);var notification=new window.Notification(title,{body:body,icon:'/style/icons/Gallery.png',tag:'screenshot:'+(new Date().getTime()),data:{systemMessageTarget:'screenshot'}});notification.onclick=function(){notification.close();if(onClick){onClick();}};}};exports.Screenshot=Screenshot;exports.screenshot=new Screenshot();exports.screenshot.start();}(window));;'use strict';(function(exports){var AsyncSemaphore=function as_contructor(){if(!this instanceof AsyncSemaphore){return new AsyncSemaphore();}
this._init();};AsyncSemaphore.prototype={_init:function as_init(){this.pendingTasks=[];this.semaphore=0;},_execute:function as_execute(){var task,context;if(this.semaphore<=0){while(this.pendingTasks.length>0){task=this.pendingTasks.shift();context=task.context||this;if(task&&task.callback&&typeof task.callback==='function'){task.callback.call(context,task.args);}}}},v:function as_v(num){if(!num){num=1;}
this.semaphore+=num;},p:function as_p(){this.semaphore-=1;if(this.semaphore<0){this.semaphore=0;}
this._execute();},wait:function as_wait(callback,context,args){this.pendingTasks.push({callback:callback,context:context,args:args});this._execute();},getValue:function as_getValue(){return this.semaphore;},getTasksLength:function as_getTasksLength(){return this.pendingTasks.length;}};exports.AsyncSemaphore=AsyncSemaphore;}(window));;(function(exports){'use strict';function SoundManager(){}
SoundManager.VIBRATION_SETTINGS_KEY='vibration.enabled';SoundManager.VIBRATION_USER_PREF_KEY='preference.vibration.enabled';SoundManager.CE_RESET_TIME=72000000;SoundManager.TIME_ONE_MINUTE=60000;SoundManager.CACHE_CETIMES='CE_ACCTIME';SoundManager.MAX_VOLUME={'alarm':15,'notification':15,'telephony':5,'content':15,'bt_sco':15};SoundManager.prototype.currentChannel='none';SoundManager.prototype.vibrationEnabled=true;SoundManager.prototype.defaultVolumeControlChannel='unknown';SoundManager.prototype.isHeadsetConnected=false;SoundManager.prototype.muteState='OFF';SoundManager.prototype.vibrationUserPrefEnabled=true;SoundManager.prototype.cachedVolume={'content':-1,'notification':-1};SoundManager.prototype.cachedChannels=['content','notification'];SoundManager.prototype.CEAccumulatorID=null;SoundManager.prototype.CEWarningVol=11;SoundManager.prototype.CEAccumulatorTime=0;SoundManager.prototype.CETimestamp=0;SoundManager.prototype.currentVolume={'alarm':15,'notification':15,'telephony':5,'content':15,'bt_sco':15};SoundManager.prototype.pendingRequest=new AsyncSemaphore();SoundManager.prototype.homescreenVisible=true;SoundManager.prototype.setVibrationEnabledCount=0;SoundManager.prototype.volumeFetched=false;SoundManager.prototype.activeTimerID=0;SoundManager.prototype.start=function sm_start(){window.addEventListener('volumeup',this);window.addEventListener('volumedown',this);window.addEventListener('mute',this);window.addEventListener('unmute',this);window.addEventListener('mozChromeEvent',this);window.addEventListener('unload',this);window.addEventListener('appopen',this);window.addEventListener('ftudone',this);window.addEventListener('holdhome',this);window.addEventListener('homescreenopening',this);window.addEventListener('homescreenopened',this);this.initVibrationUserPref();this.bindVolumeSettingsHandlers();var self=this;SettingsListener.observe('audio.volume.cemaxvol',11,function(volume){self.CEWarningVol=volume;});window.asyncStorage.getItem(SoundManager.CACHE_CETIMES,function getCETime(value){if(!value){return;}else{self.CEAccumulatorTime=value;}});};SoundManager.prototype.stop=function sm_stop(){window.removeEventListener('volumeup',this);window.removeEventListener('volumedown',this);window.removeEventListener('mute',this);window.removeEventListener('unmute',this);window.removeEventListener('mozChromeEvent',this);window.removeEventListener('unload',this);window.removeEventListener('appopen',this);window.removeEventListener('ftudone',this);window.removeEventListener('holdhome',this);window.removeEventListener('homescreenopening',this);window.removeEventListener('homescreenopened',this);};SoundManager.prototype.handleEvent=function sm_handleEvent(e){switch(e.type){case'volumeup':this.handleVolumeKey(1);break;case'volumedown':this.handleVolumeKey(-1);break;case'mute':this.setMute(true);break;case'unmute':this.setMute(false);break;case'mozChromeEvent':switch(e.detail.type){case'bluetooth-volumeset':this.changeVolume(e.detail.value-this.currentVolume.bt_sco,'bt_sco');break;case'audio-channel-changed':this.currentChannel=e.detail.channel;this.ceAccumulator();break;case'headphones-status-changed':this.isHeadsetConnected=(e.detail.state!=='off');this.ceAccumulator();break;case'default-volume-channel-changed':this.defaultVolumeControlChannel=e.detail.channel;break;}
break;case'unload':this.stopAccumulator();break;case'appopen':this.homescreenVisible=false;break;case'ftudone':this.homescreenVisible=true;break;case'holdhome':CustomDialog.hide();break;case'homescreenopening':case'homescreenopened':this.homescreenVisible=true;CustomDialog.hide();break;}};SoundManager.prototype.handleVolumeKey=function sm_handleVolumeKey(offset){if(!ScreenManager.screenEnabled&&this.currentChannel==='none'){return;}
if(Bluetooth.isProfileConnected(Bluetooth.Profiles.SCO)&&this.isOnCall()){this.changeVolume(offset,'bt_sco');}else if(this.isHeadsetConnected&&offset>0){this.headsetVolumeup();}else{this.changeVolume(offset);}};SoundManager.prototype.setMute=function sm_setMute(mute){if(mute){this.setVibrationEnabled(false);this.enterSilentMode('notification');}else{this.setVibrationEnabled(true);this.leaveSilentMode('notification');this.leaveSilentMode('content');}};SoundManager.prototype.getChannel=function sm_getChannel(){if(this.isOnCall()){return'telephony';}
switch(this.currentChannel){case'normal':case'content':return'content';case'telephony':return'telephony';case'alarm':return'alarm';case'notification':case'ringer':return'notification';default:if(this.defaultVolumeControlChannel!=='unknown'){return this.defaultVolumeControlChannel;}else{return this.homescreenVisible||(Service.locked)||FtuLauncher.isFtuRunning()?'notification':'content';}}};SoundManager.prototype.initVibrationUserPref=function sm_initVUserPref(){var self=this;window.asyncStorage.getItem(SoundManager.VIBRATION_USER_PREF_KEY,function onok(value){if(value===null){var r=SettingsListener.getSettingsLock().get(SoundManager.VIBRATION_SETTINGS_KEY);r.onsuccess=function get_onsuccess(){self.writeVibrationUserPref(r.result[SoundManager.VIBRATION_SETTINGS_KEY]);};r.onerror=function get_onerror(){self.writeVibrationUserPref(true);};}else{self.vibrationUserPrefEnabled=value;}});SettingsListener.observe(SoundManager.VIBRATION_SETTINGS_KEY,true,function(vibration){var setBySelf=false;var toggleVibrationEnabled=function toggle_vibration_enabled(){if(!setBySelf){self.writeVibrationUserPref(vibration);}
self.vibrationEnabled=vibration;};if(self.setVibrationEnabledCount>0){self.setVibrationEnabledCount--;setBySelf=true;}
self.pendingRequest.wait(toggleVibrationEnabled,self);});};SoundManager.prototype.writeVibrationUserPref=function sm_writeUP(value){if(this.vibrationUserPrefEnabled===value){return;}
if(value===null||typeof(value)==='undefined'){value=true;}
var self=this;window.asyncStorage.setItem(SoundManager.VIBRATION_USER_PREF_KEY,value,function set_onsuccess(){self.vibrationUserPrefEnabled=value;});};SoundManager.prototype.ceAccumulator=function sm_ceAccumulator(){if(this.isHeadsetConnected&&this.getChannel()==='content'&&this.currentVolume[this.currentChannel]>=this.CEWarningVol){if(this.CEAccumulatorTime===0){this.showCEWarningDialog();}else{this.startAccumulator();}}else{this.stopAccumulator();}};SoundManager.prototype.headsetVolumeup=function sm_headsetVolumeup(){if((this.currentVolume[this.getChannel()]+1)>=this.CEWarningVol&&this.getChannel()==='content'){if(this.CEAccumulatorTime===0){var self=this;var okfn=function(){self.changeVolume(1);self.startAccumulator();};this.showCEWarningDialog(okfn);}else{this.startAccumulator();this.changeVolume(1);}}else{this.changeVolume(1);}};SoundManager.prototype.showCEWarningDialog=function sm_showCEDialog(okfn){var ceTitle={'icon':'/style/sound_manager/images/icon_Volumewarning.png','id':'ceWarningtitle'};var ceMsg='ceWarningcontent';var cancel={'title':'ok'};var self=this;var screen=document.getElementById('screen');if(okfn instanceof Function){cancel.callback=function onCancel(){okfn();CustomDialog.hide();};}else{cancel.callback=function onCancel(){self.startAccumulator();CustomDialog.hide();};}
CustomDialog.show(ceTitle,ceMsg,cancel,null,screen).setAttribute('data-z-index-level','system-dialog');};SoundManager.prototype.startAccumulator=function sm_startAccumulator(){if(this.CEAccumulatorID===null){if(this.CEAccumulatorTime===0){this.CEAccumulatorTime=1;this.CETimestamp=parseInt(new Date().getTime(),10);}
var self=this;this.CEAccumulatorID=window.setInterval(function ceCounter(){self.CEAccumulatorTime+=SoundManager.TIME_ONE_MINUTE;self.CETimestamp=parseInt(new Date().getTime(),10);if(self.CEAccumulatorTime>SoundManager.CE_RESET_TIME){self.CEAccumulatorTime=0;self.CETimestamp=0;self.stopAccumulator();self.showCEWarningDialog();}},SoundManager.TIME_ONE_MINUTE);}};SoundManager.prototype.stopAccumulator=function sm_stopAccumulator(){if(this.CEAccumulatorID!==null){window.clearInterval(this.CEAccumulatorID);this.CEAccumulatorID=null;if(this.CETimestamp!==0){this.CEAccumulatorTime=this.CEAccumulatorTime+
(parseInt(new Date().getTime(),10)-this.CETimestamp);}
window.asyncStorage.setItem(SoundManager.CACHE_CETIMES,this.CEAccumulatorTime);}};SoundManager.prototype.isOnCall=function sm_isOnCall(){if(this.currentChannel=='telephony'){return true;}
var telephony=window.navigator.mozTelephony;if(!telephony){return false;}
return telephony.calls.some(function callIterator(call){return(call.state=='connected');});};SoundManager.prototype.bindVolumeSettingsHandlers=function sm_bindHdlers(){var callsMade=0;var callbacksReceived=0;var self=this;function observeSettingsVolumeChange(channel){var setting='audio.volume.'+channel;SettingsListener.observe(setting,5,function onChange(volume){var settingsChange=function settings_change(){var max=SoundManager.MAX_VOLUME[channel];self.currentVolume[channel]=parseInt(Math.max(0,Math.min(max,volume)),10);if(channel==='content'&&self.volumeFetched&&volume>0){self.leaveSilentMode('content',true);}else if(channel==='notification'&&volume>0){self.leaveSilentMode('notification',true);}else if(channel==='notification'&&volume===0){self.enterSilentMode('notification');}
if(!self.volumeFetched&&++callbacksReceived===callsMade){self.fetchCachedVolume();}};self.pendingRequest.wait(settingsChange,self);});}
for(var channel in this.currentVolume){callsMade++;observeSettingsVolumeChange(channel);}};SoundManager.prototype.fetchCachedVolume=function sm_fetchCachedVolume(){if(this.volumeFetched){return;}
this.volumeFetched=true;this.pendingRequest.v(this.cachedChannels.length);var self=this;this.cachedChannels.forEach(function iterator(channel){window.asyncStorage.getItem('content.volume',function onGettingCachedVolume(value){if(!value){self.pendingRequest.p();return;}
self.cachedVolume[channel]=value;self.pendingRequest.p();});});};SoundManager.prototype.calculateVolume=function sm_calVol(curVolume,delta,channel){var volume=curVolume;if(channel==='notification'){if(volume===0&&!this.vibrationEnabled){volume=-1;}
volume+=delta;}else{volume+=delta;}
return volume;};SoundManager.prototype.getVibrationAndMuteState=function sm_getState(curVolume,delta,channel){if(channel==='notification'){var state;var volume=curVolume;if(volume===0&&!this.vibrationEnabled){volume=-1;}
volume+=delta;if(volume<0){state='MUTE';this.vibrationEnabled=false;}else if(volume===0){state='MUTE';this.vibrationEnabled=true;}else{if(curVolume<=0){this.vibrationEnabled=this.vibrationUserPrefEnabled;}
state='OFF';}
if(volume===0&&this.vibrationEnabled){this.notifyByVibrating();}
return state;}else{if(curVolume+delta<=0){return'MUTE';}else{return'OFF';}}};SoundManager.prototype.notifyByVibrating=function sm_notifyByVibrating(){window.navigator.vibrate(200);};SoundManager.prototype.enterSilentMode=function sm_enterSlient(channel){if(!channel){channel='content';}
if(this.currentVolume[channel]===0){return;}
var isCachedAlready=(this.cachedVolume[channel]===this.currentVolume[channel]);this.cachedVolume[channel]=this.currentVolume[channel];this.pendingRequest.v();var settingObject={};settingObject['audio.volume.'+channel]=0;var req=SettingsListener.getSettingsLock().set(settingObject);var self=this;req.onsuccess=function onSuccess(){self.pendingRequest.p();if(!isCachedAlready){window.asyncStorage.setItem(channel+'.volume',self.cachedVolume[channel]);}};req.onerror=function onError(){self.pendingRequest.p();};};SoundManager.prototype.leaveSilentMode=function sm_leaveSlient(channel,skip_restore){if(!channel){channel='content';}
if(!skip_restore&&(this.cachedVolume[channel]>0||this.currentVolume[channel]===0)){var req;var settingObject={};var self=this;settingObject['audio.volume.'+channel]=(this.cachedVolume[channel]>0)?this.cachedVolume[channel]:1;this.pendingRequest.v();req=SettingsListener.getSettingsLock().set(settingObject);req.onsuccess=function onSuccess(){self.pendingRequest.p();};req.onerror=function onError(){self.pendingRequest.p();};}
this.cachedVolume[channel]=-1;};SoundManager.prototype.changeVolume=function sm_changeVolume(delta,channel){channel=channel?channel:this.getChannel();var vibrationEnabledOld=this.vibrationEnabled;var volume=this.calculateVolume(this.currentVolume[channel],delta,channel);this.muteState=this.getVibrationAndMuteState(this.currentVolume[channel],delta,channel);if(volume<=0&&delta<0&&channel=='notification'){this.enterSilentMode('content');}else if(volume==1&&delta>0&&channel=='notification'&&this.cachedVolume.content>=0){this.leaveSilentMode('content');this.leaveSilentMode('notification',true);}
this.currentVolume[channel]=volume=Math.max(0,Math.min(SoundManager.MAX_VOLUME[channel],volume));var overlay=document.getElementById('system-overlay');var notification=document.getElementById('volume');var overlayClasses=overlay.classList;var classes=notification.classList;switch(this.muteState){case'OFF':classes.remove('mute');break;case'MUTE':classes.add('mute');break;}
if(this.vibrationEnabled){classes.add('vibration');}else{classes.remove('vibration');}
if(vibrationEnabledOld!=this.vibrationEnabled){this.setVibrationEnabled(this.vibrationEnabled);}
var steps=Array.prototype.slice.call(notification.querySelectorAll('div'),0);var maxVolumeStep=(channel=='telephony'||channel=='bt_sco')?volume+1:volume;for(var i=0;i<steps.length;i++){var step=steps[i];if(i<maxVolumeStep){step.classList.add('active');}else{step.classList.remove('active');}}
overlayClasses.add('volume');classes.add('visible');window.clearTimeout(this.activeTimerID);this.activeTimerID=window.setTimeout(function hideSound(){overlayClasses.remove('volume');classes.remove('visible');},1500);if(!window.navigator.mozSettings){return;}
this.pendingRequest.v();notification.dataset.channel=channel;var settingObject={};settingObject['audio.volume.'+channel]=volume;var req=SettingsListener.getSettingsLock().set(settingObject);var self=this;req.onsuccess=function onSuccess(){self.pendingRequest.p();};req.onerror=function onError(){self.pendingRequest.p();};};SoundManager.prototype.setVibrationEnabled=function sm_enableVib(enabled){this.setVibrationEnabledCount++;SettingsListener.getSettingsLock().set({'vibration.enabled':enabled});};exports.SoundManager=SoundManager;exports.soundManager=new SoundManager();if(navigator.mozL10n){navigator.mozL10n.once(function(){exports.soundManager.start();});}})(window);;'use strict';(function(exports){var toggleEventHandler;var hideEventHandler;function SourceView(){var self=this;toggleEventHandler=function(){self.toggle();};hideEventHandler=function(){self.hide();};}
SourceView.prototype={get viewer(){return document.getElementById('appViewsource');},get active(){return!this.viewer?false:this.viewer.style.visibility==='visible';}};SourceView.prototype.start=function sv_start(){window.addEventListener('home+volume',toggleEventHandler);window.addEventListener('locked',hideEventHandler);return this;};SourceView.prototype.stop=function sv_stop(){window.removeEventListener('home+volume',toggleEventHandler);window.removeEventListener('locked',hideEventHandler);if(this.viewer){this.viewer.parentElement.removeChild(this.viewer);}};SourceView.prototype.show=function sv_show(){var viewsource=this.viewer;if(!viewsource){var style='#appViewsource { '+'  position: absolute;'+'  top: calc(10%);'+'  left: calc(10%);'+'  width: calc(80% - 2 * 1.5rem);'+'  height: calc(80% - 2 * 1.5rem);'+'  visibility: hidden;'+'  margin: 1.5rem;'+'  background-color: white;'+'  opacity: 0.92;'+'  color: black;'+'  z-index: 9999;'+'}';document.styleSheets[0].insertRule(style,0);viewsource=document.createElement('iframe');viewsource.id='appViewsource';document.body.appendChild(viewsource);}
var url=Service.currentApp.origin;if(!url){url=window.location.toString();}
viewsource.src='view-source: '+url;viewsource.style.visibility='visible';};SourceView.prototype.hide=function sv_hide(){var viewsource=this.viewer;if(viewsource){viewsource.style.visibility='hidden';viewsource.src='about:blank';}};SourceView.prototype.toggle=function sv_toggle(){if(ScreenManager.screenEnabled){this.active?this.hide():this.show();}};exports.SourceView=SourceView;}(window));;'use strict';(function(exports){var BrowserKeyEventManager=function BrowserKeyEventManager(){};BrowserKeyEventManager.prototype={KEY_EVENTS:Object.freeze(['mozbrowserbeforekeydown','mozbrowserbeforekeyup','mozbrowserafterkeydown','mozbrowserafterkeyup','keydown','keyup']),SYSTEM_ONLY_KEYS:Object.freeze(['power','home','mozhomescreen','exit']),APP_CANCELLED_KEYS:Object.freeze(['volumeup','volumedown']),HOME_KEY_ALIAS:Object.freeze(['home','mozhomescreen','exit']),TRANSLATION_TABLE:Object.freeze({'power':'sleep-button','exit':'home-button','home':'home-button','mozhomescreen':'home-button','volumeup':'volume-up-button','volumedown':'volume-down-button'}),_getLowerCaseKeyName:function bkem_getLowerCaseKeyName(event){return event.key&&event.key.toLowerCase();},_isSystemOnlyKey:function bkem_isSystemOnlyKey(event){var key=this._getLowerCaseKeyName(event);return(this.SYSTEM_ONLY_KEYS.indexOf(key)>-1);},_isAppCancelledKey:function bkem_isAppCancelledKey(event){var key=this._getLowerCaseKeyName(event);return(this.APP_CANCELLED_KEYS.indexOf(key)>-1);},_isBeforeEvent:function bkem_isBeforeEvent(event){return event.type==='mozbrowserbeforekeyup'||event.type==='mozbrowserbeforekeydown';},_isAfterEvent:function bkem_isAfterEvent(event){return event.type==='mozbrowserafterkeyup'||event.type==='mozbrowserafterkeydown';},_isKeyEvent:function bkem_isKeyEvent(event){return event.type==='keyup'||event.type==='keydown';},_targetToIframe:function bkem_targetToIframe(event){return(event.target instanceof HTMLIFrameElement);},_applyPolicy:function bkem_applyPolicy(event){var needTranslation=false;if(this._isSystemOnlyKey(event)&&(this._isBeforeEvent(event)||this._isKeyEvent(event))){event.preventDefault();needTranslation=true;}else if(this._isAppCancelledKey(event)&&this._isAfterEvent(event)){needTranslation=!event.embeddedCancelled;}else if(this._isKeyEvent(event)&&!this._targetToIframe(event)){needTranslation=true;}
return needTranslation;},isHomeKey:function bkem_isHomeKey(event){var key=this._getLowerCaseKeyName(event);return(this.HOME_KEY_ALIAS.indexOf(key)>-1);},isHardwareKeyEvent:function bkem_isHardwareKeyEvent(type){return(this.KEY_EVENTS.indexOf(type)>-1);},getButtonEventType:function bkem_getButtonEventType(event){var translatedType;var key;var suffix;var needTranslation=this.isHardwareKeyEvent(event.type)?this._applyPolicy(event):false;if(needTranslation){key=this._getLowerCaseKeyName(event);suffix=(event.type.indexOf('keyup')>-1)?'-release':'-press';translatedType=this.TRANSLATION_TABLE[key]&&this.TRANSLATION_TABLE[key]+suffix;}
return translatedType;}};exports.BrowserKeyEventManager=BrowserKeyEventManager;}(window));;'use strict';(function(exports){var HardwareButtonsBaseState;var HardwareButtonsHomeState;var HardwareButtonsSleepState;var HardwareButtonsVolumeState;var HardwareButtonsWakeState;var HardwareButtonsScreenshotState;var HardwareButtons=function HardwareButtons(){this._started=false;this._softwareHome=false;};HardwareButtons.STATES={};HardwareButtons.prototype.HOLD_INTERVAL=750;HardwareButtons.prototype.REPEAT_DELAY=700;HardwareButtons.prototype.REPEAT_INTERVAL=100;HardwareButtons.prototype.start=function hb_start(){if(this._started){throw'Instance should not be start()\'ed twice.';}
this._started=true;this.state=new HardwareButtonsBaseState(this);this.browserKeyEventManager=new BrowserKeyEventManager();window.addEventListener('softwareButtonEvent',this);window.addEventListener('mozbrowserbeforekeydown',this);window.addEventListener('mozbrowserbeforekeyup',this);window.addEventListener('mozbrowserafterkeydown',this);window.addEventListener('mozbrowserafterkeyup',this);window.addEventListener('keydown',this);window.addEventListener('keyup',this);SettingsListener.observe('software-button.enabled',false,function(value){this._softwareHome=value;}.bind(this));};HardwareButtons.prototype.stop=function hb_stop(){if(!this._started){throw'Instance was never start()\'ed but stop() is called.';}
this._started=false;if(this.state&&this.state.exit){this.state.exit();}
this.state=null;window.removeEventListener('softwareButtonEvent',this);window.removeEventListener('mozbrowserbeforekeydown',this);window.removeEventListener('mozbrowserbeforekeyup',this);window.removeEventListener('mozbrowserafterkeydown',this);window.removeEventListener('mozbrowserafterkeyup',this);window.removeEventListener('keydown',this);window.removeEventListener('keyup',this);};HardwareButtons.prototype.publish=function hb_publish(type){window.dispatchEvent(new CustomEvent(type,{bubbles:type==='home'}));};HardwareButtons.prototype.setState=function hb_setState(s,type){if(this.state&&this.state.exit){this.state.exit(type);}
this.state=new HardwareButtons.STATES[s](this);if(this.state&&this.state.enter){this.state.enter(type);}};HardwareButtons.prototype.handleEvent=function hb_handleEvent(evt){var hardwareHomeEvent=(this.browserKeyEventManager.isHardwareKeyEvent(evt.type))&&this.browserKeyEventManager.isHomeKey(evt);if(this._softwareHome&&hardwareHomeEvent){return;}
if(evt.type==='softwareButtonEvent'){var type=evt.detail.type;switch(type){case'home-button-press':case'home-button-release':case'sleep-button-press':case'sleep-button-release':case'volume-up-button-press':case'volume-up-button-release':case'volume-down-button-press':case'volume-down-button-release':this.state.process(type);break;}}else{var buttonEventType=this.browserKeyEventManager.getButtonEventType(evt);if(!buttonEventType){return;}
this.state.process(buttonEventType);}};HardwareButtonsBaseState=HardwareButtons.STATES.base=function HardwareButtonsBaseState(hb){this.hardwareButtons=hb;};HardwareButtonsBaseState.prototype.process=function(type){switch(type){case'home-button-press':if(!ScreenManager.screenEnabled){this.hardwareButtons.publish('wake');this.hardwareButtons.setState('wake',type);}else{this.hardwareButtons.setState('home',type);}
return;case'sleep-button-press':if(!ScreenManager.screenEnabled){this.hardwareButtons.publish('wake');this.hardwareButtons.setState('wake',type);}else{this.hardwareButtons.setState('sleep',type);}
return;case'volume-up-button-press':case'volume-down-button-press':this.hardwareButtons.setState('volume',type);return;case'home-button-release':case'sleep-button-release':case'volume-up-button-release':case'volume-down-button-release':return;}
console.error('Unexpected hardware key: ',type);};HardwareButtonsHomeState=HardwareButtons.STATES.home=function HardwareButtonsHomeState(hb){this.hardwareButtons=hb;this.timer=undefined;};HardwareButtonsHomeState.prototype.enter=function(){this.timer=setTimeout(function(){this.hardwareButtons.publish('holdhome');navigator.vibrate(50);this.hardwareButtons.setState('base');}.bind(this),this.hardwareButtons.HOLD_INTERVAL);};HardwareButtonsHomeState.prototype.exit=function(){if(this.timer){clearTimeout(this.timer);this.timer=undefined;}};HardwareButtonsHomeState.prototype.process=function(type){switch(type){case'home-button-release':this.hardwareButtons.publish('home');navigator.vibrate(50);this.hardwareButtons.setState('base',type);return;case'volume-up-button-press':case'volume-down-button-press':case'sleep-button-press':this.hardwareButtons.setState('base',type);return;}
console.error('Unexpected hardware key: ',type);this.hardwareButtons.setState('base',type);};HardwareButtonsSleepState=HardwareButtons.STATES.sleep=function HardwareButtonsSleepState(hb){this.hardwareButtons=hb;this.timer=undefined;};HardwareButtonsSleepState.prototype.enter=function(){this.timer=setTimeout(function(){this.hardwareButtons.publish('holdsleep');this.hardwareButtons.setState('base');}.bind(this),this.hardwareButtons.HOLD_INTERVAL);};HardwareButtonsSleepState.prototype.exit=function(){if(this.timer){clearTimeout(this.timer);this.timer=undefined;}};HardwareButtonsSleepState.prototype.process=function(type){switch(type){case'sleep-button-release':this.hardwareButtons.publish('sleep');this.hardwareButtons.setState('base',type);return;case'volume-down-button-press':this.hardwareButtons.setState('screenshot',type);return;case'volume-up-button-press':this.hardwareButtons.setState('volume',type);this.hardwareButtons.setState('base',type);return;case'home-button-press':this.hardwareButtons.setState('base',type);return;}
console.error('Unexpected hardware key: ',type);this.hardwareButtons.setState('base',type);};HardwareButtonsVolumeState=HardwareButtons.STATES.volume=function HardwareButtonsVolumeState(hb){this.hardwareButtons=hb;this.timer=undefined;this.repeating=false;};HardwareButtonsVolumeState.prototype.repeat=function(){this.repeating=true;if(this.direction==='volume-up-button-press'){this.hardwareButtons.publish('volumeup');}else{this.hardwareButtons.publish('volumedown');}
this.timer=setTimeout(this.repeat.bind(this),this.hardwareButtons.REPEAT_INTERVAL);};HardwareButtonsVolumeState.prototype.enter=function(type){this.direction=type;this.repeating=false;this.timer=setTimeout(this.repeat.bind(this),this.hardwareButtons.REPEAT_DELAY);};HardwareButtonsVolumeState.prototype.exit=function(){if(this.timer){clearTimeout(this.timer);this.timer=undefined;}};HardwareButtonsVolumeState.prototype.process=function(type){switch(type){case'home-button-press':this.hardwareButtons.setState('base',type);return;case'sleep-button-press':if(this.direction==='volume-down-button-press'){this.hardwareButtons.setState('screenshot',type);return;}
this.hardwareButtons.setState('sleep',type);return;case'volume-up-button-release':if(this.direction==='volume-up-button-press'){if(!this.repeating){this.hardwareButtons.publish('volumeup');}
this.hardwareButtons.setState('base',type);return;}
break;case'volume-down-button-release':if(this.direction==='volume-down-button-press'){if(!this.repeating){this.hardwareButtons.publish('volumedown');}
this.hardwareButtons.setState('base',type);return;}
break;default:return;}
console.error('Unexpected hardware key: ',type);this.hardwareButtons.setState('base',type);};HardwareButtonsWakeState=HardwareButtons.STATES.wake=function HardwareButtonsWakeState(hb){this.hardwareButtons=hb;this.timer=undefined;this.delegateState=null;};HardwareButtonsWakeState.prototype.enter=function(type){if(type==='home-button-press'){this.delegateState=new HardwareButtonsHomeState(this.hardwareButtons);}else{this.delegateState=new HardwareButtonsSleepState(this.hardwareButtons);}
this.timer=setTimeout(function(){if(type==='home-button-press'){this.hardwareButtons.publish('holdhome');}else if(type==='sleep-button-press'){this.hardwareButtons.publish('holdsleep');}
this.hardwareButtons.setState('base',type);}.bind(this),this.hardwareButtons.HOLD_INTERVAL);};HardwareButtonsWakeState.prototype.exit=function(){if(this.timer){clearTimeout(this.timer);this.timer=null;}};HardwareButtonsWakeState.prototype.process=function(type){switch(type){case'home-button-release':case'sleep-button-release':this.hardwareButtons.setState('base',type);return;default:this.delegateState.process(type);return;}};HardwareButtonsScreenshotState=HardwareButtons.STATES.screenshot=function HardwareButtonsScreenshotState(hb){this.hardwareButtons=hb;this.timer=undefined;};HardwareButtonsScreenshotState.prototype.enter=function(){this.timer=setTimeout(function(){this.hardwareButtons.publish('volumedown+sleep');this.hardwareButtons.setState('base');}.bind(this),this.hardwareButtons.HOLD_INTERVAL);};HardwareButtonsScreenshotState.prototype.exit=function(){if(this.timer){clearTimeout(this.timer);this.timer=undefined;}};HardwareButtonsScreenshotState.prototype.process=function(type){this.hardwareButtons.setState('base',type);};exports.hardwareButtons=new HardwareButtons();exports.hardwareButtons.start();exports.HardwareButtons=HardwareButtons;}(window));;'use strict';(function(exports){function SystemBanner(){}
SystemBanner.prototype={_banner:null,_clicked:false,_clickCallback:null,get banner(){if(!this._banner){this._banner=document.createElement('section');this._banner.className='banner generic-dialog';this._banner.setAttribute('role','dialog');this._banner.dataset.zIndexLevel='system-notification-banner';this._banner.dataset.button='false';this._banner.innerHTML='<p></p><button></button>';document.getElementById('screen').appendChild(this._banner);}
return this._banner;},show:function(message,buttonParams){var banner=this.banner;banner.firstElementChild.textContent=message;var button=banner.querySelector('button');if(buttonParams){banner.dataset.button=true;button.textContent=buttonParams.label;this._clickCallback=function(){this._clicked=true;buttonParams.callback();}.bind(this);button.addEventListener('click',this._clickCallback);}
banner.addEventListener('animationend',function animationend(){banner.removeEventListener('animationend',animationend);banner.classList.remove('visible');if(buttonParams){if(buttonParams.dismiss&&!this._clicked){buttonParams.dismiss();}
banner.dataset.button=false;button.removeEventListener('click',this._clickCallback);button.classList.remove('visible');this.banner.parentNode.removeChild(this.banner);}}.bind(this));banner.classList.add('visible');}};exports.SystemBanner=SystemBanner;}(window));;'use strict';(function(exports){function HomeGesture(){this.isTablet=!ScreenLayout.getCurrentLayout('tiny');this.hasHardwareHomeButton=ScreenLayout.getCurrentLayout('hardwareHomeButton');this.homeBar=document.getElementById('bottom-panel');}
HomeGesture.prototype={enabled:false,_moving:false,_multiTouch:false,_startY1:0,MINUMUM_DISTANCE:50,start:function(){window.addEventListener('software-button-enabled',this);window.addEventListener('software-button-disabled',this);this.homeBar.addEventListener('touchstart',this,true);this.homeBar.addEventListener('touchend',this,true);this.homeBar.addEventListener('click',this,true);if(!this.hasHardwareHomeButton&&this.isTablet){this.toggle(true);}else{SettingsListener.observe('homegesture.enabled',false,function onObserve(value){this.toggle(value);}.bind(this));}},toggle:function(enable){if(enable===this.enabled){return;}
if(enable){this.publish('homegesture-enabled');window.addEventListener('lockscreen-appclose',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('utilitytrayshow',this);window.addEventListener('utilitytrayhide',this);this.homeBar.classList.add('visible');}else{this.publish('homegesture-disabled');window.removeEventListener('lockscreen-appclose',this);window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('utilitytrayshow',this);window.removeEventListener('utilitytrayhide',this);this.homeBar.classList.remove('visible');}
this.enabled=enable;},handleEvent:function(evt){switch(evt.type){case'touchstart':evt.preventDefault();this._moving=true;this._startY1=evt.changedTouches[0].pageY;if(evt.touches.length>1){this._multiTouch=true;}
break;case'touchend':var progress=Math.abs(this._startY1-evt.changedTouches[0].pageY);if(this._moving&&(progress>=this.MINUMUM_DISTANCE)){if(this._multiTouch){window.dispatchEvent(new CustomEvent('holdhome'));}else{window.dispatchEvent(new CustomEvent('home'));}}
this._multiTouch=false;this._moving=false;break;case'lockscreen-appopened':case'utilitytrayshow':this.homeBar.classList.remove('visible');break;case'lockscreen-appclose':case'utilitytrayhide':this.homeBar.classList.add('visible');break;case'software-button-disabled':if(!this.hasHardwareHomeButton&&!this.enabled){SettingsListener.getSettingsLock().set({'homegesture.enabled':true});}
break;case'software-button-enabled':if(this.enabled){SettingsListener.getSettingsLock().set({'homegesture.enabled':false});}
break;}},publish:function(type){window.dispatchEvent(new CustomEvent(type));}};exports.HomeGesture=HomeGesture;}(window));;'use strict';(function(exports){const WALLPAPER_KEY='wallpaper.image';const WALLPAPER_VALID_KEY='wallpaper.image.valid';const DEFAULT_WALLPAPER_URL='resources/images/backgrounds/default.png';function WallpaperManager(){this._started=false;this._blobURL=null;}
WallpaperManager.prototype={start:function(){if(this._started){throw'Instance should not be start()\'ed twice.';}
this._started=true;debug('started');var lock=navigator.mozSettings.createLock();var query=lock.get(WALLPAPER_KEY);query.onsuccess=function(){var wallpaper=query.result[WALLPAPER_KEY];if(!wallpaper){debug('no wallpaper found at startup; using default');this._setWallpaper(DEFAULT_WALLPAPER_URL);}
else if(wallpaper instanceof Blob){var query2=lock.get(WALLPAPER_VALID_KEY);query2.onsuccess=function(){var valid=query2.result[WALLPAPER_VALID_KEY];this._setWallpaper(wallpaper,valid);}.bind(this);}
else{this._setWallpaper(wallpaper);}}.bind(this);this.observer=function(e){this._setWallpaper(e.settingValue);}.bind(this);navigator.mozSettings.addObserver(WALLPAPER_KEY,this.observer);},stop:function(){if(!this._started){return;}
navigator.mozSettings.removeObserver(WALLPAPER_KEY,this.observer);this._started=false;},getBlobURL:function(){if(!this._started){return;}
return this._blobURL;},_setWallpaper:function(value,valid){if(!this._started){return;}
if(value instanceof Blob&&value.size===this.savedBlobSize){this.savedBlobSize=false;return;}
debug('new wallpaper',valid?'size already validated':'');if(typeof value==='string'){this._toBlob(value);}
else if(value instanceof Blob){if(valid){this._publish(value);}
else{this._checkSize(value);}}
else{debug('Invalid wallpaper value in settings;','reverting to default wallpaper.');this._toBlob(DEFAULT_WALLPAPER_URL);}},_toBlob:function(url){if(!this._started){return;}
debug('converting wallpaper url to blob');this.tryingDefaultWallpaper=(url===DEFAULT_WALLPAPER_URL);var xhr=new XMLHttpRequest();xhr.open('GET',url);xhr.responseType='blob';xhr.send();xhr.onload=function(){this._checkSize(xhr.response,true);}.bind(this);xhr.onerror=function(){if(!this.tryingDefaultWallpaper){debug('corrupt wallpaper url in settings;','reverting to default wallpaper');this._toBlob(DEFAULT_WALLPAPER_URL);}
else{console.error('Cannot load wallpaper from',url);}}.bind(this);},_checkSize:function(blob,needsToBeSaved){if(!this._started){return;}
debug('resizing wallpaper if needed');var screenWidth,screenHeight;if(OrientationManager&&!OrientationManager.isDefaultPortrait()){screenWidth=Math.max(screen.width,screen.height);screenHeight=Math.min(screen.width,screen.height);}else{screenWidth=Math.min(screen.width,screen.height);screenHeight=Math.max(screen.width,screen.height);}
screenWidth=Math.ceil(screenWidth*window.devicePixelRatio);screenHeight=Math.ceil(screenHeight*window.devicePixelRatio);LazyLoader.load('shared/js/image_utils.js',function(){ImageUtils.resizeAndCropToCover(blob,screenWidth,screenHeight,ImageUtils.PNG).then(function resolve(resizedBlob){if(resizedBlob!==blob||needsToBeSaved){this._save(resizedBlob);}
else{this._validate();}
this._publish(resizedBlob);}.bind(this),function reject(error){if(!this.tryingDefaultWallpaper){debug('Corrupt wallpaper image in settings;','reverting to default wallpaper.');this._toBlob(DEFAULT_WALLPAPER_URL);}
else{console.error('Default wallpaper image is invalid');}}.bind(this));}.bind(this));},_validate:function(){if(!this._started){return;}
debug('marking wallpaper as valid');var settings={};settings[WALLPAPER_VALID_KEY]=true;navigator.mozSettings.createLock().set(settings);},_save:function(blob){if(!this._started){return;}
debug('saving converted or resized wallpaper to settings');this.savedBlobSize=blob.size;var settings={};settings[WALLPAPER_KEY]=blob;settings[WALLPAPER_VALID_KEY]=true;navigator.mozSettings.createLock().set(settings);},_publish:function(blob){if(!this._started){return;}
debug('publishing wallpaperchange event');if(this._blobURL){URL.revokeObjectURL(this._blobURL);}
this._blobURL=URL.createObjectURL(blob);var evt=new CustomEvent('wallpaperchange',{bubbles:true,cancelable:false,detail:{url:this._blobURL}});window.dispatchEvent(evt);}};function debug(...args){if(WallpaperManager.DEBUG){args.unshift('[WallpaperManager]');console.log.apply(console,args);}}
WallpaperManager.DEBUG=false;exports.WallpaperManager=WallpaperManager;}(window));;'use strict';(function(exports){var AppMigrator=function AppMigrator(){};AppMigrator.prototype={start:function(){if(this.migrating){return;}
var self=this;VersionHelper.getVersionInfo().then(function(versionInfo){if(versionInfo.isUpgrade()){LazyLoader.load('js/migrators/browser_migrator.js',(function loaded(){var bm=new BrowserMigrator();bm.runMigration();}));self.migrating=true;}});}};exports.AppMigrator=AppMigrator;})(window);;'use strict';(function(exports){var targets=['homescreen','app','activity'];function TTLView(){SettingsListener.observe('debug.ttl.enabled',false,function(value){!!value?this.show():this.hide();}.bind(this));}
TTLView.prototype={element:null,get visible(){return this.element&&this.element.style.display==='block';},hide:function(){if(this.element){this.element.style.visibility='hidden';}
targets.forEach(function listen(target){window.removeEventListener(target+'opening',this);window.removeEventListener(target+'loadtime',this);},this);},show:function(){if(!this.element){this.createElement();}
this.element.style.visibility='visible';targets.forEach(function listen(target){window.addEventListener(target+'opening',this);window.addEventListener(target+'loadtime',this);},this);},createElement:function(){var element=document.createElement('div');element.id='debug-ttl';element.innerHTML='00000';element.dataset.zIndexLevel='debug-ttl';this.element=element;document.getElementById('screen').appendChild(element);},handleEvent:function(evt){switch(evt.type){case'homescreenloadtime':case'apploadtime':case'activityloadtime':this.updateLoadtime(evt.detail.time,evt.detail.type);break;case'homescreenopening':case'appopening':case'activityopening':this.resetLoadtime();break;}},resetLoadtime:function(){if(!this.element){this.createElement();}
this.element.innerHTML='00000';},updateLoadtime:function(time,type){if(!this.element){this.createElement();}
this.element.innerHTML=time+' ['+type+']';},toggle:function(){this.visible?this.hide():this.show();}};exports.TTLView=TTLView;}(window));;'use strict';(function(exports){function Accessibility(){}
Accessibility.prototype={REPEAT_INTERVAL:600000,REPEAT_BUTTON_PRESS:15000000,TOGGLE_SCREEN_READER_COUNT:6,CONTRAST_CAP:0.6,HINTS_TIMEOUT:2000,counter:0,expectedEvent:{type:'volumeup',timeStamp:0},expectedCompleteTimeStamp:0,settings:{'accessibility.screenreader':false,'accessibility.screenreader-volume':1,'accessibility.screenreader-rate':0,'accessibility.screenreader-captions':false,'accessibility.colors.enable':false,'accessibility.colors.invert':false,'accessibility.colors.grayscale':false,'accessibility.colors.contrast':'0.0'},sounds:{clickedAudio:null,vcKeyAudio:null,vcMoveAudio:null,noMoveAudio:null},soundURLs:{clickedAudio:'./resources/sounds/screen_reader_clicked.ogg',vcKeyAudio:'./resources/sounds/screen_reader_virtual_cursor_key.ogg',vcMoveAudio:'./resources/sounds/screen_reader_virtual_cursor_move.ogg',noMoveAudio:'./resources/sounds/screen_reader_no_move.ogg'},start:function ar_init(){this.screen=document.getElementById('screen');this.speechSynthesizer=speechSynthesizer;window.addEventListener('mozChromeEvent',this);window.addEventListener('volumeup',this);window.addEventListener('volumedown',this);window.addEventListener('logohidden',this);window.addEventListener('screenchange',this);Object.keys(this.settings).forEach(function attach(settingKey){SettingsListener.observe(settingKey,this.settings[settingKey],function observe(aValue){this.settings[settingKey]=aValue;switch(settingKey){case'accessibility.screenreader':if(aValue){SettingsListener.getSettingsLock().set({'accessibility.screenreader-show-settings':true});}
this.screen.classList.toggle('screenreader',aValue);break;case'accessibility.colors.enable':SettingsListener.getSettingsLock().set({'layers.effect.invert':aValue?this.settings['accessibility.colors.invert']:false,'layers.effect.grayscale':aValue?this.settings['accessibility.colors.grayscale']:false,'layers.effect.contrast':aValue?this.settings['accessibility.colors.contrast']*this.CONTRAST_CAP:'0.0'});break;case'accessibility.screenreader-captions':this.speechSynthesizer.captions=aValue;if(!aValue){this.speechSynthesizer.hideSpeech(true);}
break;case'accessibility.colors.invert':case'accessibility.colors.grayscale':case'accessibility.colors.contrast':if(this.settings['accessibility.colors.enable']){var effect=settingKey.split('.').pop();var gfxSetting={};if(effect==='contrast'){gfxSetting['layers.effect.contrast']=aValue*this.CONTRAST_CAP;}else{gfxSetting['layers.effect.'+effect]=aValue;}
SettingsListener.getSettingsLock().set(gfxSetting);}
break;}}.bind(this));},this);},reset:function ar_resetEvent(){this.expectedEvent={type:'volumeup',timeStamp:0};this.counter=0;},resetSpeaking:function ar_resetSpeaking(aExpectedCompleteTimeStamp){this.isSpeaking=false;this.expectedCompleteTimeStamp=aExpectedCompleteTimeStamp||0;},handleVolumeButtonPress:function ar_handleVolumeButtonPress(aEvent){var type=aEvent.type;var timeStamp=aEvent.timeStamp;var expectedEvent=this.expectedEvent;if(type!==expectedEvent.type||timeStamp>expectedEvent.timeStamp){this.reset();if(type!=='volumeup'){return;}}
this.expectedEvent={type:type==='volumeup'?'volumedown':'volumeup',timeStamp:timeStamp+this.REPEAT_INTERVAL};if(++this.counter<this.TOGGLE_SCREEN_READER_COUNT){return;}
this.reset();if(!this.isSpeaking&&timeStamp>this.expectedCompleteTimeStamp){this.cancelSpeech();this.announceScreenReader(function onEnd(){this.resetSpeaking(timeStamp+this.REPEAT_BUTTON_PRESS);}.bind(this));return;}
this.cancelSpeech();this.resetSpeaking();SettingsListener.getSettingsLock().set({'accessibility.screenreader':!this.settings['accessibility.screenreader']});},_playSound:function ar__playSound(aSoundKey){if(!this.sounds[aSoundKey]){this.sounds[aSoundKey]=new Audio(this.soundURLs[aSoundKey]);this.sounds[aSoundKey].load();}
var audio=this.sounds[aSoundKey].cloneNode(false);audio.volume=this.volume;audio.play();},get volume(){return this.settings['accessibility.screenreader-volume'];},get rate(){var rate=this.settings['accessibility.screenreader-rate'];return rate>=0?rate+1:1/(Math.abs(rate)+1);},setHintsTimeout:function ar_setHintsTimeout(aHints){clearTimeout(this.hintsTimer);this.hintsTimer=setTimeout(function onHintsTimeout(){this.isSpeakingHints=true;this.speak(aHints,function onSpeakHintsEnd(){this.isSpeakingHints=false;}.bind(this),{enqueue:true});}.bind(this),this.HINTS_TIMEOUT);},handleAccessFuOutput:function ar_handleAccessFuOutput(aDetails){this.cancelHints();var options=aDetails.options||{};window.dispatchEvent(new CustomEvent('accessibility-action'));switch(aDetails.eventType){case'vc-change':navigator.vibrate(options.pattern);this._playSound(options.isKey?'vcKeyAudio':'vcMoveAudio');break;case'action':if(aDetails.data[0].string==='clickAction'){this._playSound('clickedAudio');return;}
break;case'no-move':this._playSound('noMoveAudio');return;}
this.speak(aDetails.data,function hintsCallback(){if(options.hints){this.setHintsTimeout(options.hints);}}.bind(this),{enqueue:options.enqueue});},handleAccessFuControl:function ar_handleAccessFuControls(aDetails){this.cancelHints();if(aDetails.eventType==='quicknav-menu'){if(!this.quicknav){this.quicknav=new AccessibilityQuicknavMenu();}
this.quicknav.show();}},handleScreenChange:function ar_handleScreenChange(aDetail){if(!aDetail.screenEnabled){this.cancelHints();}},activateScreen:function ar_activateScreen(){this.screen.removeAttribute('aria-hidden');window.removeEventListener('logohidden',this);},handleEvent:function ar_handleEvent(aEvent){switch(aEvent.type){case'screenchange':this.handleScreenChange(aEvent.detail);break;case'logohidden':this.activateScreen();break;case'mozChromeEvent':switch(aEvent.detail.type){case'accessibility-output':this.handleAccessFuOutput(JSON.parse(aEvent.detail.details));break;case'accessibility-control':this.handleAccessFuControl(JSON.parse(aEvent.detail.details));break;}
break;case'volumeup':case'volumedown':this.handleVolumeButtonPress(aEvent);break;}},cancelHints:function ar_cancelHints(){clearTimeout(this.hintsTimer);if(this.isSpeakingHints){this.cancelSpeech();this.isSpeakingHints=false;}},announceScreenReader:function ar_announceScreenReader(aCallback){var enabled=this.settings['accessibility.screenreader'];this.isSpeaking=true;this.speak({string:enabled?'disableScreenReaderSteps':'enableScreenReaderSteps'},aCallback,{enqueue:false});},speak:function ar_speak(aData,aCallback,aOptions={}){this.speechSynthesizer.speak(aData,aOptions,this.rate,this.volume,aCallback);},cancelSpeech:function ar_cancelSpeech(){this.speechSynthesizer.cancel();}};var speechSynthesizer={CAPTIONS_DELAY:1500,captions:false,get screen(){delete this.screen;this.screen=document.getElementById('screen');return this.screen;},get speech(){delete this.speech;if(!window.speechSynthesis||window.speechSynthesis.getVoices().length===0){this.speech=null;}
this.speech=window.speechSynthesis;return this.speech;},get utterance(){delete this.utterance;this.utterance=window.SpeechSynthesisUtterance;return this.utterance;},cancel:function ss_cancel(){if(this.speech){this.speech.cancel();}},localize:function ss_localize(aDetails){if(!aDetails||typeof aDetails==='string'){return aDetails;}
var string=aDetails.string;var data={count:aDetails.count};if(!string){return'';}else{string='accessibility-'+string;}
if(aDetails.args){data=aDetails.args.reduce(function(aData,val,index){aData[index]=val;return aData;},data);}
return navigator.mozL10n.get(string,data);},buildUtterance:function ss_buildUtterance(aData){if(!Array.isArray(aData)){aData=[aData];}
var words=[],localize=this.localize;aData.reduce(function(words,details){var localized=localize(details);if(localized){var word=localized.trim();if(word){words.push(word);}}
return words;},words);return words.join(' ');},showSpeech:function ar_showSpeech(aUtterance){if(!this.captionsBox){this.captionsBox=document.createElement('div');this.captionsBox.id='accessibility-captions-box';this.captionsBox.setAttribute('data-z-index-level','accessibility-captions');this.captionsBox.setAttribute('aria-hidden',true);this.screen.appendChild(this.captionsBox);}
window.clearTimeout(this.captionsHideTimeout);this.captionsHideTimeout=null;this.captionsBox.textContent=aUtterance;this.captionsBox.classList.add('visible');},hideSpeech:function ar_hideSpeech(aImmediately){if(!this.captionsBox){return;}
if(aImmediately){this.captionsBox.classList.remove('visible');}else{this.captionsHideTimeout=window.setTimeout(function(){this.captionsBox.classList.remove('visible');}.bind(this),this.CAPTIONS_DELAY);}},speak:function ss_speak(aData,aOptions,aRate,aVolume,aCallback){if(!this.speech||!this.utterance){if(aCallback){aCallback();}
return;}
if(!aOptions.enqueue){this.cancel();}
var sentence=this.buildUtterance(aData);if(!sentence){if(aCallback){aCallback();}
return;}
var utterance=new this.utterance(sentence);utterance.volume=aVolume;utterance.rate=aRate;utterance.addEventListener('end',function(){if(this.captions){this.hideSpeech();}
if(aCallback){aCallback();}}.bind(this));if(this.captions){this.showSpeech(sentence);}
this.speech.speak(utterance);}};exports.Accessibility=Accessibility;}(window));;'use strict';(function(exports){function AccessibilityQuicknavMenu(){SettingsListener.observe('accessibility.screenreader_quicknav_modes','',function observe(aValue){this.updateModes(aValue.split(','));}.bind(this));SettingsListener.observe('accessibility.screenreader_quicknav_index',0,function observe(aValue){this.updateCurrentMode(aValue);}.bind(this));this.render();}
AccessibilityQuicknavMenu.prototype={container:null,currentMode:0,modes:[],render:function render(){this.element=document.createElement('div');this.element.id='accessibility-quicknav';this.element.dataset.zIndexLevel='accessibility-quicknav-menu';this.element.dataset.type='value-selector';this.element.setAttribute('role','dialog');this.element.addEventListener('click',this);this.element.innerHTML=`<div id="accessibility-quicknav-container">
          <section>
            <ul role="listbox">
            </ul>
          </section>
        </div>`;if(this.modes.length){this.updateModes(this.modes);}
var screen=document.getElementById('screen');screen.appendChild(this.element);},updateModes:function updateModes(aModes){this.modes=aModes;if(!this.element){return;}
var ul=this.element.querySelector('ul');ul.innerHTML='';for(var i in aModes){var li=document.createElement('li');li.setAttribute('role','option');if(i==this.currentMode){li.setAttribute('aria-selected',true);}
li.setAttribute('aria-moz-quick-activate',true);li.dataset.quicknavIndex=i;var label=document.createElement('label');label.setAttribute('role','presentation');li.appendChild(label);var span=document.createElement('span');span.dataset.l10nId='accessibility-quicknav_'+aModes[i];label.appendChild(span);ul.appendChild(li);}},updateCurrentMode:function updateCurrentMode(aCurrentMode){this.currentMode=aCurrentMode;if(!this.element){return;}
var item=this.element.querySelector('li[aria-selected=true]');if(item){item.removeAttribute('aria-selected');}
item=this.element.querySelectorAll('li[role=option]')[aCurrentMode];if(item){item.setAttribute('aria-selected',true);}},show:function show(){this.element.classList.add('visible');},hide:function hide(){this.element.classList.remove('visible');},handleEvent:function quicknavMenu_handleEvent(aEvent){var index=Number(aEvent.target.dataset.quicknavIndex);SettingsListener.getSettingsLock().set({'accessibility.screenreader_quicknav_index':index});this.hide();}};exports.AccessibilityQuicknavMenu=AccessibilityQuicknavMenu;}(window));;'use strict';(function(exports){function SleepMenu(){}
SleepMenu.prototype={isFlightModeEnabled:false,isDeveloperMenuEnabled:false,developerOptions:{},isSilentModeEnabled:false,elements:{},get visible(){return this.elements.overlay.classList.contains('visible');},getAllElements:function sm_getAllElements(){this.elements.overlay=document.getElementById('sleep-menu');this.elements.container=document.querySelector('#sleep-menu-container ul');this.elements.cancel=document.querySelector('#sleep-menu button');},start:function sm_init(){this.getAllElements();window.addEventListener('holdsleep',this.show.bind(this));window.addEventListener('click',this,true);window.addEventListener('screenchange',this,true);window.addEventListener('home',this);window.addEventListener('batteryshutdown',this);window.addEventListener('cardviewbeforeshow',this);window.addEventListener('attentionopened',this);this.elements.cancel.addEventListener('click',this);var self=this;SettingsListener.observe('ril.radio.disabled',false,function(value){self.isFlightModeEnabled=value;});SettingsListener.observe('developer.menu.enabled',false,function(value){self.isDeveloperMenuEnabled=value;});for(var option in this.developerOptions){(function attachListenerToDeveloperOption(opt){SettingsListener.observe(opt.setting,opt.value,function(value){opt.value=value;});})(this.developerOptions[option]);}
SettingsListener.observe('audio.volume.notification',7,function(value){self.isSilentModeEnabled=(value===0);});},generateItems:function sm_generateItems(){var items=[];var _=navigator.mozL10n.get;var options={airplane:{label:_('airplane'),value:'airplane'},airplaneOff:{label:_('airplaneOff'),value:'airplane'},silent:{label:_('silent'),value:'silent'},silentOff:{label:_('normal'),value:'silentOff'},restart:{label:_('restart'),value:'restart'},power:{label:_('power'),value:'power'}};if(this.isFlightModeEnabled){items.push(options.airplaneOff);}else{items.push(options.airplane);}
if(navigator.mozTelephony){if(!this.isSilentModeEnabled){items.push(options.silent);}else{items.push(options.silentOff);}}
items.push(options.restart);items.push(options.power);if(this.isDeveloperMenuEnabled){for(var option in this.developerOptions){if(this.developerOptions[option].value){items.push(options[option]);}else{items.push(options[option+'Off']);}}}
return items;},show:function sm_show(){this.elements.container.innerHTML='';this.buildMenu(this.generateItems());this.elements.overlay.classList.add('visible');screen.mozLockOrientation(OrientationManager.defaultOrientation);},buildMenu:function sm_buildMenu(items){items.forEach(function traveseItems(item){var item_li=document.createElement('li');item_li.dataset.value=item.value;item_li.textContent=item.label;item_li.setAttribute('role','menuitem');this.elements.container.appendChild(item_li);},this);},hide:function lm_hide(){if(!this.elements.overlay.classList.contains('visible')){return;}
this.elements.overlay.classList.remove('visible');window.dispatchEvent(new Event('sleepmenuhide'));},handleEvent:function sm_handleEvent(evt){switch(evt.type){case'cardviewbeforeshow':this.hide();break;case'batteryshutdown':window.dispatchEvent(new CustomEvent('requestshutdown',{detail:this}));break;case'screenchange':if(!evt.detail.screenEnabled){this.hide();}
break;case'click':if(!this.visible){return;}
if(evt.currentTarget===this.elements.cancel){this.hide();return;}
var action=evt.target.dataset.value;if(!action){return;}
this.clickHandler(action);break;case'home':case'attentionopened':if(this.visible){this.hide();}
break;default:break;}},publish:function(evtName){window.dispatchEvent(new CustomEvent(evtName));},clickHandler:function sm_clickHandler(action){switch(action){case'airplane':this.hide();this.publish(this.isFlightModeEnabled?'request-airplane-mode-disable':'request-airplane-mode-enable');break;case'silent':this.hide();window.dispatchEvent(new Event('mute'));this.isSilentModeEnabled=true;break;case'silentOff':this.hide();window.dispatchEvent(new Event('unmute'));this.isSilentModeEnabled=false;break;case'restart':this.startPowerOff(true);break;case'power':this.startPowerOff(false);break;default:break;}},startPowerOff:function sm_startPowerOff(reboot){this.publish('will-shutdown');var power=navigator.mozPower;var self=this;if(!power){return;}
if(document.getElementById('poweroff-splash')){return;}
var div=document.createElement('div');div.dataset.zIndexLevel='poweroff-splash';div.id='poweroff-splash';var logoLoader=new LogoLoader(CustomLogoPath.poweroff);logoLoader.onload=function customizedAnimation(elem){div.appendChild(elem);div.className='step1';if(elem.tagName.toLowerCase()=='video'&&!elem.ended){elem.onended=function(){elem.classList.add('hide');elem.removeAttribute('src');elem.load();};elem.play();}else{div.addEventListener('animationend',function(){elem.classList.add('hide');if(elem.tagName.toLowerCase()=='video'){elem.removeAttribute('src');elem.load();}});}
elem.addEventListener('transitionend',function(){self._actualPowerOff(reboot);});document.getElementById('screen').appendChild(div);};logoLoader.onnotfound=function defaultAnimation(){var inner;for(var i=1;i<=3;i++){var outer=document.createElement('span');outer.className='poweroff-ring';outer.id='poweroff-ring-'+i;div.appendChild(outer);inner=document.createElement('span');outer.appendChild(inner);}
div.className='step1';var nextAnimation=function nextAnimation(e){if(e.target==div){div.className='step2';}
if(e.target!=inner){return;}
self._actualPowerOff(reboot);};div.addEventListener('animationend',nextAnimation);document.getElementById('screen').appendChild(div);};},_actualPowerOff:function sm_actualPowerOff(isReboot){var power=navigator.mozPower;if(isReboot){power.reboot();}else{power.powerOff();}}};exports.SleepMenu=SleepMenu;}(window));;'use strict';(function(exports){var IMESwitcher=function(){this._utilityTrayContainer=null;this._notificationContainer=null;this._notificationTitle=null;this._notificationTip=null;this.ontap=undefined;};IMESwitcher.prototype.start=function is_start(){this._utilityTrayContainer=document.getElementById('keyboard-show-ime-list');this._notificationContainer=this._utilityTrayContainer.querySelector('.fake-notification');this._notificationTitle=this._notificationContainer.querySelector('.title-container');this._notificationTip=this._notificationContainer.querySelector('.detail');this._notificationContainer.addEventListener('mousedown',this);};IMESwitcher.prototype.stop=function is_stop(){this._notificationContainer.removeEventListener('mousedown',this);this._utilityTrayContainer=null;this._notificationContainer=null;this._notificationTitle=null;this._notificationTip=null;this.ontap=undefined;};IMESwitcher.prototype.show=function is_show(appName,imeName){window.dispatchEvent(new CustomEvent('keyboardimeswitchershow'));navigator.mozL10n.setAttributes(this._notificationTitle,'ime-switching-title',{appName:appName,name:imeName});this._notificationTip.setAttribute('data-l10n-id','ime-switching-tip');this._notificationContainer.classList.add('activated');};IMESwitcher.prototype.hide=function is_hide(){this._notificationContainer.classList.remove('activated');window.dispatchEvent(new CustomEvent('keyboardimeswitcherhide'));};IMESwitcher.prototype.handleEvent=function is_handleEvent(evt){evt.preventDefault();if(typeof this.ontap==='function'){this.ontap();}};exports.IMESwitcher=IMESwitcher;})(window);;'use strict';(function(exports){var InputWindowManager=function(){this.isOutOfProcessEnabled=false;this._totalMemory=0;this._getMemory();this._oopSettingCallbackBind=null;this._inputWindows={};this._currentWindow=null;this._lastWindow=null;this._onDebug=false;};InputWindowManager.prototype._debug=function iwm__debug(msg){if(this._onDebug){console.log('[InputWindowManager] '+msg);}};InputWindowManager.prototype.start=function iwm_start(){this._oopSettingCallbackBind=this._oopSettingCallback.bind(this);SettingsListener.observe('keyboard.3rd-party-app.enabled',true,this._oopSettingCallbackBind);window.addEventListener('input-appopened',this);window.addEventListener('input-appclosing',this);window.addEventListener('input-appclosed',this);window.addEventListener('input-apprequestclose',this);window.addEventListener('input-appready',this);window.addEventListener('input-appheightchanged',this);window.addEventListener('input-appterminated',this);window.addEventListener('activityrequesting',this);window.addEventListener('activityopening',this);window.addEventListener('activityclosing',this);window.addEventListener('attentionrequestopen',this);window.addEventListener('attentionrecovering',this);window.addEventListener('attentionopening',this);window.addEventListener('attentionopened',this);window.addEventListener('attentionclosing',this);window.addEventListener('attentionclosed',this);window.addEventListener('notification-clicked',this);window.addEventListener('applicationsetupdialogshow',this);window.addEventListener('sheets-gesture-begin',this);window.addEventListener('cardviewbeforeshow',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('mozmemorypressure',this);};InputWindowManager.prototype.stop=function iwm_stop(){SettingsListener.unobserve('keyboard.3rd-party-app.enabled',this._oopSettingCallbackBind);this._oopSettingCallbackBind=null;window.removeEventListener('input-appopened',this);window.removeEventListener('input-appclosing',this);window.removeEventListener('input-appclosed',this);window.removeEventListener('input-apprequestclose',this);window.removeEventListener('input-appready',this);window.removeEventListener('input-appheightchanged',this);window.removeEventListener('input-appterminated',this);window.removeEventListener('activityrequesting',this);window.removeEventListener('activityopening',this);window.removeEventListener('activityclosing',this);window.removeEventListener('attentionrequestopen',this);window.removeEventListener('attentionrecovering',this);window.removeEventListener('attentionopening',this);window.removeEventListener('attentionopened',this);window.removeEventListener('attentionclosing',this);window.removeEventListener('attentionclosed',this);window.removeEventListener('notification-clicked',this);window.removeEventListener('applicationsetupdialogshow',this);window.removeEventListener('sheets-gesture-begin',this);window.removeEventListener('cardviewbeforeshow',this);window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('mozmemorypressure',this);};InputWindowManager.prototype.handleEvent=function iwm_handleEvent(evt){var inputWindow;var manifestURL;if(evt.type.startsWith('input-app')){inputWindow=evt.detail;}
this._debug('handleEvent: '+evt.type);switch(evt.type){case'input-appopened':case'input-appheightchanged':if(inputWindow===this._currentWindow){this._kbPublish('keyboardchange',inputWindow.height);}
break;case'input-appready':if(inputWindow===this._currentWindow){KeyboardManager._onKeyboardReady();}
if(this._lastWindow){if(!this._lastWindow.isDead()){this._lastWindow.close('immediate');}
this._lastWindow=null;}
break;case'input-appclosing':if(!this._currentWindow){this._kbPublish('keyboardhide',undefined);}
break;case'input-appclosed':this._debug('inputWindow pendingReady: '+inputWindow._pendingReady);if(inputWindow._pendingReady){return;}
inputWindow._setAsActiveInput(false);if(!this._currentWindow){this._kbPublish('keyboardhidden',undefined);}
break;case'input-appterminated':manifestURL=inputWindow.manifestURL;this._removeInputApp(manifestURL);if(this._currentWindow&&this._currentWindow.manifestURL===manifestURL){KeyboardManager._onKeyboardKilled(manifestURL);}
break;case'activityrequesting':case'activityopening':case'activityclosing':case'attentionrequestopen':case'attentionrecovering':case'attentionopening':case'attentionclosing':case'attentionopened':case'attentionclosed':case'notification-clicked':case'applicationsetupdialogshow':this.hideInputWindowImmediately();break;case'lockscreen-appopened':case'sheets-gesture-begin':case'cardviewbeforeshow':if(this._hasActiveInputApp()){var app=Service.currentApp;app&&app.blur();navigator.mozInputMethod.removeFocus();}
break;case'mozmemorypressure':this._debug('mozmemorypressure event');if(!this.isOutOfProcessEnabled&&!this._hasActiveInputApp()){this.getLoadedManifestURLs().forEach(manifestURL=>{this._removeInputApp(manifestURL);});this._debug('mozmemorypressure event; keyboards removed');}
break;}};InputWindowManager.prototype._getMemory=function iwm_getMemory(){if('getFeature'in navigator){navigator.getFeature('hardware.memory').then(mem=>{this._totalMemory=mem;},()=>{console.error('InputWindowManager: '+'Failed to retrieve total memory of the device.');});}};InputWindowManager.prototype._oopSettingCallback=function iwm_oopSettingCallback(value){this.isOutOfProcessEnabled=value;};InputWindowManager.prototype._onInputLayoutsRemoved=function iwm_onInputLayoutsRemoved(manifestURLs){var currentWindowRemoved=false;manifestURLs.forEach(manifestURL=>{if(this._currentWindow&&this._currentWindow.manifestURL===manifestURL){this.hideInputWindow();currentWindowRemoved=true;}
this._removeInputApp(manifestURL);});return currentWindowRemoved;};InputWindowManager.prototype._removeInputApp=function iwm_removeInputApp(manifestURL){if(!this._inputWindows[manifestURL]){return;}
for(var pathInitial in this._inputWindows[manifestURL]){this._inputWindows[manifestURL][pathInitial].destroy();delete this._inputWindows[manifestURL][pathInitial];}
delete this._inputWindows[manifestURL];};InputWindowManager.prototype.getHeight=function iwm_getHeight(){return this._currentWindow?this._currentWindow.height:0;};InputWindowManager.prototype._hasActiveInputApp=function iwm_hasActiveInputApp(){return!!this._currentWindow;};InputWindowManager.prototype._extractLayoutConfigs=function iwm_extractLayoutConfigs(layout){var manifestURL=layout.manifestURL;var path=layout.path;var id=layout.id;var origin=layout.origin;var pathInitial;var hash;if(path.indexOf('#')===-1){pathInitial=path;hash='';}else{pathInitial=path.substring(0,path.indexOf('#'));hash=path.substring(path.indexOf('#'));}
var app=applications.getByManifestURL(manifestURL);return{manifest:app.manifest,manifestURL:manifestURL,path:path,id:id,pathInitial:pathInitial,hash:hash,origin:origin};};InputWindowManager.prototype._makeInputWindow=function iwm_makeInputWindow(configs){var isCertifiedApp=(configs.manifest.type==='certified');if(0===this._totalMemory){console.warn('InputWindowManager: totalMemory is 0');}
if(this.isOutOfProcessEnabled&&(!isCertifiedApp||this._totalMemory>=512)){this._debug('=== Enable keyboard: '+
configs.origin+' run as OOP ===');configs.oop=true;}else{configs.oop=false;}
var inputWindow=new InputWindow(configs);this._inputWindows[configs.manifestURL]=this._inputWindows[configs.manifestURL]||{};this._inputWindows[configs.manifestURL][configs.pathInitial]=inputWindow;return inputWindow;};InputWindowManager.prototype.preloadInputWindow=function iwm_preloadInputWindow(layout){var configs=this._extractLayoutConfigs(layout);configs.stayBackground=true;this._makeInputWindow(configs);};InputWindowManager.prototype.showInputWindow=function iwm_showInputWindow(layout){var configs=this._extractLayoutConfigs(layout);var nextWindow=this._inputWindows[configs.manifestURL]?this._inputWindows[configs.manifestURL][configs.pathInitial]:undefined;if(!nextWindow){nextWindow=this._makeInputWindow(configs);}
if(this._currentWindow&&nextWindow!==this._currentWindow){this._lastWindow=this._currentWindow;configs.immediateOpen=true;nextWindow.open(configs);}else{nextWindow.open(configs);}
this._currentWindow=nextWindow;};InputWindowManager.prototype.hideInputWindow=function iwm_hideInputWindow(){if(!this._currentWindow){return;}
var windowToClose=this._currentWindow;this._currentWindow=null;windowToClose.close();};InputWindowManager.prototype.hideInputWindowImmediately=function iwm_hideInputWindowImmediately(){if(!this._currentWindow){return;}
var windowToClose=this._currentWindow;this._currentWindow=null;this._kbPublish('keyboardhide',undefined);windowToClose.close('immediate');};InputWindowManager.prototype.getLoadedManifestURLs=function iwm_getLoadedManifestURLs(){return Object.keys(this._inputWindows);};InputWindowManager.prototype._kbPublish=function iwm_kbPublish(type,height){var eventInitDict={bubbles:true,cancelable:true,detail:{height:height}};var evt=new CustomEvent(type,eventInitDict);document.body.dispatchEvent(evt);};exports.InputWindowManager=InputWindowManager;})(window);;'use strict';(function(exports){var InputLayouts=function(keyboardManager,TYPE_GROUP_MAPPING){this._keyboardManager=keyboardManager;this._groupToTypeTable={};this.layouts={};this._layoutToGroupMapping={};this._enabledApps=null;Object.keys(TYPE_GROUP_MAPPING).forEach(function(type){var group=TYPE_GROUP_MAPPING[type];this._groupToTypeTable[group]=this._groupToTypeTable[group]||[];this._groupToTypeTable[group].push(type);},this);this._currentActiveLayouts={};this._promise=null;};InputLayouts.prototype.start=function il_start(){this._getSettings();};InputLayouts.prototype.stop=function il_stop(){this._promise=null;};InputLayouts.prototype.SETTINGS_KEY_CURRENT_ACTIVE='keyboard.current-active-layouts';InputLayouts.prototype._transformLayout=function il_transformLayout(layout){var transformedLayout={id:layout.layoutId,origin:layout.app.origin,manifestURL:layout.app.manifestURL,path:layout.inputManifest.launch_path};var getName=function(){return this.name;};Object.defineProperties(transformedLayout,{name:{get:getName.bind(layout.inputManifest),enumerable:true},appName:{get:getName.bind(layout.manifest),enumerable:true}});return transformedLayout;};InputLayouts.prototype._insertLayouts=function il_insertLayouts(appLayouts){appLayouts.forEach(function(layout){this._enabledApps.add(layout.app.manifestURL);layout.inputManifest.types.filter(KeyboardHelper.isKeyboardType).forEach(function(group){this.layouts[group]=this.layouts[group]||[];this.layouts[group].push(this._transformLayout(layout));},this);},this);};InputLayouts.prototype._insertFallbackLayouts=function il_insertFallbackLayouts(){Object.keys(KeyboardHelper.fallbackLayouts).filter(grp=>!(grp in this.layouts)).forEach(function(group){var layout=KeyboardHelper.fallbackLayouts[group];this._enabledApps.add(layout.app.manifestURL);this.layouts[group]=[this._transformLayout(layout)];},this);};InputLayouts.prototype._emitLayoutsCount=function il_emitLayoutsCount(){var countLayouts={};Object.keys(this.layouts).forEach(function(group){var types=this._groupToTypeTable[group];types.forEach(function(type){countLayouts[type]=this.layouts[group].length;},this);},this);var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,{type:'inputmethod-update-layouts',layouts:countLayouts});window.dispatchEvent(event);};InputLayouts.prototype._generateToGroupMapping=function il_generateToGroupMapping(){Object.keys(this.layouts).forEach(group=>{this.layouts[group].forEach((layout,index)=>{var key=layout.manifestURL+'/'+layout.id;this._layoutToGroupMapping[key]=this._layoutToGroupMapping[key]||[];this._layoutToGroupMapping[key].push({group:group,index:index});});});};InputLayouts.prototype.processLayouts=function il_processLayouts(appLayouts){this.layouts={};this._enabledApps=new Set();this._insertLayouts(appLayouts);this._insertFallbackLayouts();this._generateToGroupMapping();for(var group in this.layouts){this.layouts[group]._activeLayoutIdx=undefined;}
this._emitLayoutsCount();return this._enabledApps;};InputLayouts.prototype._getSettings=function il_getSettings(){if(!navigator.mozSettings){throw'InputLayouts: No mozSettings?';}
if(!this._promise){this._promise=navigator.mozSettings.createLock().get(this.SETTINGS_KEY_CURRENT_ACTIVE).then(result=>{var value=result[this.SETTINGS_KEY_CURRENT_ACTIVE];if(value){this._currentActiveLayouts=value;}
return this._currentActiveLayouts;}).catch(e=>{this._promise=null;throw e;});}
return this._promise;};InputLayouts.prototype.getGroupCurrentActiveLayoutIndexAsync=function il_getGroupCurrentActiveLayoutIndexAsync(group){return this._getSettings().then(currentActiveLayouts=>{var currentActiveLayout=currentActiveLayouts[group];var currentActiveLayoutIdx;if(currentActiveLayout&&this.layouts[group]){this.layouts[group].every((layout,index)=>{if(layout.manifestURL===currentActiveLayout.manifestURL&&layout.id===currentActiveLayout.id){currentActiveLayoutIdx=index;return false;}
return true;});}
return currentActiveLayoutIdx;});};InputLayouts.prototype.saveGroupsCurrentActiveLayout=function il_saveGroupsCurrentActiveLayout(layout){var supportedGroups=[];this._layoutToGroupMapping[layout.manifestURL+'/'+layout.id].forEach(groupInfo=>{this.layouts[groupInfo.group]._activeLayoutIdx=groupInfo.index;supportedGroups.push(groupInfo.group);});supportedGroups.forEach(group=>{var curr=this._currentActiveLayouts[group];if(curr&&curr.id===layout.id&&curr.manifestURL===layout.manifestURL){return;}
this._currentActiveLayouts[group]={id:layout.id,manifestURL:layout.manifestURL};});var toSet={};toSet[this.SETTINGS_KEY_CURRENT_ACTIVE]=this._currentActiveLayouts;var req=navigator.mozSettings.createLock().set(toSet);req.onerror=()=>console.error('Error while seaving currentActiveLayout',req.error);};exports.InputLayouts=InputLayouts;})(window);;'use strict';const IGNORED_INPUT_TYPES={'select-one':true,'select-multiple':true,'date':true,'time':true,'datetime':true,'datetime-local':true};const TYPE_GROUP_MAPPING={'text':'text','textarea':'text','url':'url','email':'email','password':'password','search':'text','number':'number','tel':'number','select-one':'option','select-multiple':'option','time':'option','week':'option','month':'option','date':'option','datetime':'option','datetime-local':'option','color':'option'};const SWITCH_CHANGE_DELAY=20;window.KeyboardManager={_showingInputGroup:null,_switchChangeTimeout:0,_onDebug:false,_debug:function km_debug(msg){if(this._onDebug){console.log('[Keyboard Manager] '+msg);}},init:function km_init(){this.imeSwitcher=new IMESwitcher();this.imeSwitcher.ontap=this._showImeMenu.bind(this);this.imeSwitcher.start();window.addEventListener('keyboardhide',this);window.addEventListener('mozChromeEvent',this);this.inputLayouts=new InputLayouts(this,TYPE_GROUP_MAPPING);this.inputLayouts.start();LazyLoader.load(['js/dynamic_input_registry.js','shared/js/input_mgmt/input_app_list.js','shared/js/keyboard_helper.js'],function(){this.dynamicInputRegistry=new DynamicInputRegistry();this.dynamicInputRegistry.start();KeyboardHelper.watchLayouts({enabled:true},this._updateLayouts.bind(this));}.bind(this));},_tryLaunchOnBoot:function km_launchOnBoot(){if(inputWindowManager.getLoadedManifestURLs().length){return;}
var LAUNCH_ON_BOOT_KEY='keyboard.launch-on-boot';var req=navigator.mozSettings.createLock().get(LAUNCH_ON_BOOT_KEY);req.onsuccess=req.onerror=(function(){var launchOnBoot=req.result&&req.result[LAUNCH_ON_BOOT_KEY];if(typeof launchOnBoot!=='boolean'){launchOnBoot=true;}
if(launchOnBoot&&!inputWindowManager.getLoadedManifestURLs().length){this._preloadKeyboard();}}).bind(this);},_updateLayouts:function km_updateLayouts(layouts){var enabledApps=this.inputLayouts.processLayouts(layouts);var manifestURLsToRemove=inputWindowManager.getLoadedManifestURLs().filter(manifestURL=>!enabledApps.has(manifestURL));var currentLayoutRemoved=inputWindowManager._onInputLayoutsRemoved(manifestURLsToRemove);if(currentLayoutRemoved){this._showingInputGroup=null;}
this._tryLaunchOnBoot();},_onKeyboardKilled:function km_onKeyboardKilled(manifestURL){this._setKeyboardToShow(this._showingInputGroup);},_onKeyboardReady:function km_onKeyboardReady(){this._showIMESwitcher();},_activateKeyboard:function km_activateKeyboard(group){if(!this.inputLayouts.layouts[group]){KeyboardHelper.checkDefaults(function changedDefaults(){KeyboardHelper.getLayouts({enabled:true},this._updateLayouts.bind(this));KeyboardHelper.saveToSettings();}.bind(this));}
if(!this.inputLayouts.layouts[group]){group='text';}
if(this.inputLayouts.layouts[group]._activeLayoutIdx!==undefined){this._setKeyboardToShow(group);}else{this.inputLayouts.getGroupCurrentActiveLayoutIndexAsync(group).then(currentActiveLayoutIdx=>{this._setKeyboardToShow(group,currentActiveLayoutIdx);}).catch(e=>{console.error(`KeyboardManager: failed to retrieve
                         currentActiveLayoutIdx`,e);this._setKeyboardToShow(group);});}},_inputFocusChange:function km_inputFocusChange(evt){var type=evt.detail.inputType;if(!type||type in IGNORED_INPUT_TYPES){inputWindowManager.hideInputWindow();return;}
if('blur'===type){this._debug('get blur event');inputWindowManager.hideInputWindow();this.imeSwitcher.hide();}else{var group=TYPE_GROUP_MAPPING[type];this._debug('get focus event '+type);this._activateKeyboard(group);}},handleEvent:function km_handleEvent(evt){switch(evt.type){case'mozChromeEvent':switch(evt.detail.type){case'inputmethod-showall':this._showImeMenu();break;case'inputmethod-next':this._switchToNext();break;case'inputmethod-contextchange':this._inputFocusChange(evt);break;}
break;case'keyboardhide':this._showingInputGroup=null;break;}},_preloadKeyboard:function km_preloadKeyboard(){if(!this.inputLayouts.layouts.text){console.warn('trying to preload \'text\' layout while it\'s unavailable');return;}
this._debug('preloading a keyboard');inputWindowManager.preloadInputWindow(this.inputLayouts.layouts.text[0]);},_setKeyboardToShow:function km_setKeyboardToShow(group,index){if(!this.inputLayouts.layouts[group]){console.warn('trying to set a layout group to show that doesnt exist');return;}
if(undefined===index){index=this.inputLayouts.layouts[group]._activeLayoutIdx||0;}
this._debug('set layout to display: group='+group+' index='+index);var layout=this.inputLayouts.layouts[group][index];inputWindowManager.showInputWindow(layout);this.inputLayouts.saveGroupsCurrentActiveLayout(layout);this._showingInputGroup=group;},_showIMESwitcher:function km_showIMESwitcher(){var showedGroup=this._showingInputGroup;if(!this.inputLayouts.layouts[showedGroup]){return;}
var showedIndex=this.inputLayouts.layouts[showedGroup]._activeLayoutIdx;var current=this.inputLayouts.layouts[showedGroup][showedIndex];this.imeSwitcher.show(current.appName,current.name);},_waitForSwitchTimeout:function km_waitForSwitchTimeout(callback){clearTimeout(this._switchChangeTimeout);this._switchChangeTimeout=setTimeout(callback,SWITCH_CHANGE_DELAY);},_switchToNext:function km_switchToNext(){var showedGroup=this._showingInputGroup;this._waitForSwitchTimeout(function keyboardSwitchLayout(){if(!this.inputLayouts.layouts[showedGroup]){showedGroup='text';}
var showedIndex=this.inputLayouts.layouts[showedGroup]._activeLayoutIdx;var length=this.inputLayouts.layouts[showedGroup].length;var index=(showedIndex+1)%length;this._setKeyboardToShow(showedGroup,index);}.bind(this));},_imeMenuCallback:function km_imeMenuCallback(showedGroup,selectedIndex){if(typeof selectedIndex==='number'){this._setKeyboardToShow(showedGroup,selectedIndex);window.dispatchEvent(new CustomEvent('keyboardchanged'));}else{this._setKeyboardToShow(showedGroup);window.dispatchEvent(new CustomEvent('keyboardchangecanceled'));}},_showImeMenu:function km_showImeMenu(){var showedGroup=this._showingInputGroup;var activeLayoutIdx=this.inputLayouts.layouts[showedGroup]._activeLayoutIdx;var actionMenuTitle=navigator.mozL10n.get('choose-option');this._waitForSwitchTimeout(function listLayouts(){var items=this.inputLayouts.layouts[showedGroup].map(function(layout,index){return{layoutName:layout.name,appName:layout.appName,value:index,selected:(index===activeLayoutIdx)};});inputWindowManager.hideInputWindow();var menu=new ImeMenu(items,actionMenuTitle,this._imeMenuCallback.bind(this,showedGroup),this._imeMenuCallback.bind(this,showedGroup));menu.start();}.bind(this));}};;'use strict';window.UtilityTray={name:'UtilityTray',shown:false,showing:false,active:false,overlay:document.getElementById('utility-tray'),notifications:document.getElementById('utility-tray-notifications'),statusbar:document.getElementById('statusbar'),statusbarIcons:document.getElementById('statusbar-icons'),topPanel:document.getElementById('top-panel'),ambientIndicator:document.getElementById('ambient-indicator'),softwareButtons:document.getElementById('software-buttons'),grippy:document.getElementById('utility-tray-grippy'),container:document.getElementById('desktop-notifications-container'),notificationTitle:document.getElementById('notification-some'),screen:document.getElementById('screen'),EVENT_PREFIX:'utilitytray',publish:function(evtName){window.dispatchEvent(new CustomEvent(this.EVENT_PREFIX+evtName,{detail:this}));},isActive:function(){return this.shown;},focus:function(){},blur:function(){},init:function ut_init(){var touchEvents=['touchstart','touchmove','touchend','mousedown'];touchEvents.forEach(function bindEvents(name){this.overlay.addEventListener(name,this);this.statusbarIcons.addEventListener(name,this);this.grippy.addEventListener(name,this);this.topPanel.addEventListener(name,this);this.softwareButtons.addEventListener(name,this);},this);window.addEventListener('screenchange',this);window.addEventListener('emergencyalert',this);window.addEventListener('home',this);window.addEventListener('attentionopened',this);window.addEventListener('attentionwill-become-active',this);window.addEventListener('launchapp',this);window.addEventListener('displayapp',this);window.addEventListener('appopening',this);window.addEventListener('activityopening',this);window.addEventListener('resize',this);window.addEventListener('cardviewbeforeshow',this);window.addEventListener('sheets-gesture-begin',this);window.addEventListener('sheets-gesture-end',this);window.addEventListener('mozChromeEvent',this);window.addEventListener('keyboardimeswitchershow',this);window.addEventListener('keyboardimeswitcherhide',this);window.addEventListener('imemenushow',this);window.addEventListener('simlockshow',this);window.addEventListener('keyboardchanged',this);window.addEventListener('keyboardchangecanceled',this);window.addEventListener('statusbarwheel',this);this.grippy.addEventListener('wheel',this);this.overlay.addEventListener('transitionend',this);window.addEventListener('software-button-enabled',this);window.addEventListener('software-button-disabled',this);this.animationTime=this.DEFAULT_ANIMATION_TIME;Service.request('registerHierarchy',this);Service.register('makeAmbientIndicatorActive',this);Service.register('makeAmbientIndicatorInactive',this);},MAX_SWIPE_AGE:50,MINIMUM_ANIMATION_TIME:0.05,DEFAULT_ANIMATION_TIME:0.2,startY:undefined,lastDelta:undefined,lastMove:0,lastMoveTime:0,animationTime:0,isTap:false,screenWidth:0,screenHeight:0,grippyHeight:0,ambientHeight:0,hideStartCallback:null,_handle_home:function(){if(this.isActive()){this.hide();return false;}
return true;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}else{return true;}},handleEvent:function ut_handleEvent(evt){var target=evt.target;var detail=evt.detail;switch(evt.type){case'mousedown':if(this._shouldPrevent(target)){evt.preventDefault();}
break;case'cardviewbeforeshow':this.hide(true);break;case'attentionopened':case'attentionwill-become-active':case'home':if(this.showing){this.hide();if(evt.type=='home'){evt.stopImmediatePropagation();}}
break;case'emergencyalert':case'displayapp':case'keyboardchanged':case'keyboardchangecanceled':case'simlockshow':case'appopening':case'activityopening':if(this.showing){this.hide();}
break;case'sheets-gesture-begin':this.overlay.classList.add('on-edge-gesture');break;case'sheets-gesture-end':this.overlay.classList.remove('on-edge-gesture');break;case'launchapp':if(detail&&detail.stayBackground){return;}
var findMyDevice=window.location.origin.replace('system','findmydevice');var blacklist=[findMyDevice];var isBlockedApp=blacklist.some(function(blockedApp){return blockedApp===detail.origin;});if(!isBlockedApp&&this.showing){this.hide();}
break;case'imemenushow':this.hide();break;case'keyboardimeswitchershow':this.overlay.addEventListener('mousedown',this._pdIMESwitcherShow);this.statusbar.addEventListener('mousedown',this._pdIMESwitcherShow);break;case'keyboardimeswitcherhide':this.overlay.removeEventListener('mousedown',this._pdIMESwitcherShow);this.statusbar.removeEventListener('mousedown',this._pdIMESwitcherShow);break;case'screenchange':if(this.showing&&!this.active&&!evt.detail.screenEnabled){this.hide(true);}
break;case'touchstart':if(window.Service.locked||window.Service.runningFTU){return;}
if(target===this.softwareButtons&&!this.showing){return;}
if(target!==this.grippy&&target!==this.softwareButtons&&this.showing){return;}
if(target!==this.overlay&&target!==this.grippy&&evt.currentTarget!==this.statusbarIcons&&evt.currentTarget!==this.topPanel&&evt.currentTarget!==this.softwareButtons){return;}
if(this._shouldPrevent(target)){evt.preventDefault();}
this.onTouchStart(evt.touches[0]);break;case'touchmove':if(this._shouldPrevent(target)){evt.preventDefault();}
this.onTouchMove(evt.touches[0],evt.timeStamp);break;case'touchend':if(this._shouldPrevent(target)){evt.preventDefault();}
evt.stopImmediatePropagation();var touch=evt.changedTouches[0];if(!this.active){return;}
this.onTouchEnd(touch,evt.timeStamp);break;case'statusbarwheel':this.show(true);break;case'wheel':if(evt.deltaMode===evt.DOM_DELTA_PAGE&&evt.deltaY&&evt.deltaY>0){this.hide(true);}
break;case'transitionend':this.showing?this.afterShow():this.afterHide();break;case'resize':this.validateCachedSizes(true);break;case'mozChromeEvent':if(evt.detail.type!=='accessibility-control'){break;}
var eventType=JSON.parse(evt.detail.details).eventType;if(eventType==='edge-swipe-down'&&!window.Service.locked&&!window.Service.runningFTU){this[this.showing?'hide':'show'](true);}
break;case'software-button-enabled':case'software-button-disabled':this.validateCachedSizes(true);break;}},validateCachedSizes:function(refresh){var screenRect;if(refresh||!this.screenHeight||!this.screenWidth){screenRect=this.overlay.getBoundingClientRect();}
if(refresh||!this.ambientHeight){this.ambientHeight=this.ambientIndicator.clientHeight||0;}
if(refresh||!this.screenWidth){this.screenWidth=screenRect.width||0;}
if(refresh||!this.screenHeight){this.screenHeight=(screenRect.height-this.ambientHeight)||0;}
if(refresh||!this.grippyHeight){this.grippyHeight=this.grippy.clientHeight||0;}},onTouchStart:function ut_onTouchStart(touch){if(this.active){return;}
this.validateCachedSizes();this.active=true;this.startY=touch.pageY;if(!this.screen.classList.contains('utility-tray')){var app=Service.currentApp;if(app&&app.config&&app.config.oop){app.iframe.sendTouchEvent('touchcancel',[touch.identifier],[touch.pageX],[touch.pageY],[touch.radiusX],[touch.radiusY],[touch.rotationAngle],[touch.force],1,0);}}
this.isTap=true;if(this.shown){window.dispatchEvent(new CustomEvent('utilitytraywillhide'));}else{window.dispatchEvent(new CustomEvent('utilitytraywillshow'));}},onTouchMove:function ut_onTouchMove(touch,timestamp){if(!this.active){return;}
this.validateCachedSizes();this.overlay.classList.add('visible');var screenHeight=this.screenHeight;var y=touch.pageY;var dy=-(this.startY-y);var move=dy-this.lastDelta;if(Math.abs(move)>0){this.lastMoveTime=timestamp;this.lastMove=move;}
this.lastDelta=dy;if(dy>5&&this.isTap){this.publish('-overlayopening');this.isTap=false;}
if(this.shown){dy+=screenHeight;}
dy=Math.max(0,dy);dy=Math.min(screenHeight,dy);if(dy>=this.grippyHeight){this.screen.classList.add('utility-tray');}else{this.screen.classList.remove('utility-tray');}
var style=this.overlay.style;style.transition='';style.transform='translateY('+dy+'px)';this.notifications.style.transition='';this.notifications.style.transform='translateY('+(this.screenHeight-dy)+'px)';},onTouchEnd:function ut_onTouchEnd(touch,timestamp){if(window.Service.locked){this.hide(true);}else{var timeDelta=timestamp-this.lastMoveTime;var significant=(Math.abs(this.lastDelta)>(this.screenHeight/5));var shouldOpen=significant?!this.shown:this.shown;if(significant&&timeDelta<=this.MAX_SWIPE_AGE&&(this.lastMove<0)===this.shown){var velocity=(timeDelta/1000)/Math.abs(this.lastMove);this.animationTime=Math.min(this.DEFAULT_ANIMATION_TIME,Math.max(this.MINIMUM_ANIMATION_TIME,velocity*(this.shown?this.screenHeight+this.lastDelta:this.screenHeight-this.lastDelta)));}
shouldOpen?this.show():this.hide();}
var corner;if(document.documentElement.dir=='rtl'){corner=touch&&(touch.target===this.topPanel)&&(touch.pageX>(window.innerWidth/2));}else{corner=touch&&(touch.target===this.topPanel)&&(touch.pageX<(window.innerWidth/2));}
if(this.isTap&&corner){if(this.showing){this.hide();}
var app=Service.currentApp&&Service.currentApp.getTopMostWindow();var combinedView=app.appChrome&&app.appChrome.useCombinedChrome();var isTransitioning=app.isTransitioning();if(!isTransitioning&&combinedView&&!app.appChrome.isMaximized()){app.appChrome.titleClicked();}}
this.active=false;this.startY=undefined;this.lastDelta=undefined;this.isTap=false;},hide:function ut_hide(instant=false){if(!this.active){window.dispatchEvent(new CustomEvent('utilitytraywillhide'));}
this.validateCachedSizes();var style=this.overlay.style;style.transition=instant?'':'transform linear '+this.animationTime+'s';this.notifications.style.transition=style.transition;this.animationTime=this.DEFAULT_ANIMATION_TIME;this.showing=false;if(instant||style.transform===''){this.afterHide();}else if(this.hideStartCallback===null){this.hideStartCallback=setTimeout(()=>{this.hideStartCallback=null;this.screen.classList.remove('utility-tray');},20);}
style.transform='';var offset=this.grippyHeight-this.ambientHeight;var notifTransform='calc(100% + '+offset+'px)';this.notifications.style.transform='translateY('+notifTransform+')';if(!this.shown){window.dispatchEvent(new CustomEvent('utility-tray-abortopen'));}},afterHide:function ut_after_hide(){if(this.hideStartCallback){clearTimeout(this.hideStartCallback);this.hideStartCallback=null;}
this.screen.classList.remove('utility-tray');this.overlay.classList.remove('visible');if(!this.shown){return;}
this.shown=false;window.dispatchEvent(new CustomEvent('utility-tray-overlayclosed'));var evt=document.createEvent('CustomEvent');evt.initCustomEvent('utilitytrayhide',true,true,null);window.dispatchEvent(evt);this.publish('-deactivated');},show:function ut_show(instant=false){if(!this.active){window.dispatchEvent(new CustomEvent('utilitytraywillshow'));}
var transition=instant?'':'transform linear '+this.animationTime+'s';this.animationTime=this.DEFAULT_ANIMATION_TIME;this.validateCachedSizes();var translate=this.ambientHeight+'px';var style=this.overlay.style;style.transition=transition;style.transform='translateY(calc(100% - '+translate+'))';this.notifications.style.transition=transition;this.notifications.style.transform='';this.showing=true;if(instant){this.afterShow();}
if(this.shown){window.dispatchEvent(new CustomEvent('utility-tray-abortclose'));}},afterShow:function ut_after_show(){this.screen.classList.add('utility-tray');this.overlay.classList.add('visible');if(this.shown){return;}
this.shown=true;window.dispatchEvent(new CustomEvent('utility-tray-overlayopened'));var evt=document.createEvent('CustomEvent');evt.initCustomEvent('utilitytrayshow',true,true,null);window.dispatchEvent(evt);this.publish('-activated');},updateNotificationCount:function ut_updateNotificationCount(){var count=this.notifications.querySelectorAll('#desktop-notifications-container .notification, '+'.fake-notification.displayed').length;navigator.mozL10n.setAttributes(this.notificationTitle,'statusbarNotifications',{n:count});},makeAmbientIndicatorActive:function ut_makeAmbientIndicatorActive(){this.ambientIndicator.classList.add('active');},makeAmbientIndicatorInactive:function ut_makeAmbientIndicatorInactive(){this.ambientIndicator.classList.remove('active');},_pdIMESwitcherShow:function ut_pdIMESwitcherShow(evt){if(evt.target.id!=='rocketbar-input'){evt.preventDefault();}},_shouldPrevent:function ut_shouldPrevent(currentTarget){var targeted=[this.grippy,this.statusbarIcons,this.topPanel];return targeted.some(function(target){return target===currentTarget;});}};;'use strict';(function(exports){function ActionMenu(listItems,titleL10nId,successCb,cancelCb,preventFocusChange){this.onselected=successCb||function(){};this.oncancel=cancelCb||function(){};this.listItems=listItems;this.titleL10nId=titleL10nId;Service.request('registerHierarchy',this);}
ActionMenu.prototype={get visible(){return this.container.classList.contains('visible');},start:function(){this.container=document.createElement('form');this.container.dataset.type='action';this.container.setAttribute('role','dialog');this.container.setAttribute('data-z-index-level','action-menu');this.header=document.createElement('header');if(this.titleL10nId!==undefined){this.header.setAttribute('data-l10n-id',this.titleL10nId);}
this.container.appendChild(this.header);this.cancel=document.createElement('button');this.cancel.setAttribute('data-l10n-id','cancel');this.cancel.dataset.action='cancel';this.menu=document.createElement('menu');this.container.appendChild(this.menu);var screen=document.getElementById('screen');screen.appendChild(this.container);screen.classList.add('action-menu');this.buildMenu(this.listItems);this.container.addEventListener('submit',this);this.menu.addEventListener('click',this);window.addEventListener('attentionopened',this,true);window.addEventListener('screenchange',this,true);window.addEventListener('home',this);window.addEventListener('holdhome',this);window.addEventListener('sheets-gesture-begin',this);if(this.preventFocusChange){this.menu.addEventListener('mousedown',this.preventFocusChange);}
window.requestAnimationFrame(()=>{window.requestAnimationFrame(()=>{this.container.classList.add('visible');this.active=true;this.publish('-activated');});});},EVENT_PREFIX:'actionmenu',publish:function(eventName){var event=new CustomEvent(this.EVENT_PREFIX+eventName);window.dispatchEvent(event);},isActive:function(){return this.active;},setHierarchy:function(){return true;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;},stop:function(){var screen=document.getElementById('screen');screen.removeChild(this.container);screen.classList.remove('action-menu');window.removeEventListener('attentionopened',this,true);window.removeEventListener('screenchange',this,true);window.removeEventListener('home',this);window.removeEventListener('holdhome',this);window.removeEventListener('sheets-gesture-begin',this);if(this.preventFocusChange){this.menu.removeEventListener('mousedown',this.preventFocusChange);}
Service.request('unregisterHierarchy',this);},buildMenu:function(items){this.menu.innerHTML='';items.forEach(function traveseItems(item){var action=document.createElement('button');action.dataset.value=item.value;action.textContent=item.label;if(item.icon){action.classList.add(item.iconClass||'icon');action.style.backgroundImage='url('+item.icon+')';}
this.menu.appendChild(action);},this);this.menu.appendChild(this.cancel);},hide:function(callback){var self=this;this.container.addEventListener('transitionend',function doHide(e){self.container.removeEventListener('transitionend',doHide);self.active=false;self.publish('-deactivated');self.stop();});this.container.classList.remove('visible');if(callback&&typeof callback==='function'){setTimeout(callback);}},preventFocusChange:function(evt){evt.preventDefault();},handleEvent:function(evt){var target=evt.target;var type=evt.type;switch(type){case'submit':evt.preventDefault();break;case'screenchange':if(!this.visible){return;}
if(!evt.detail.screenEnabled){this.hide();this.oncancel();}
break;case'click':evt.preventDefault();var action=target.dataset.action;if(action&&action==='cancel'){this.hide();this.oncancel();return;}
var value=target.dataset.value;if(!value){return;}
value=parseInt(value);this.hide(this.onselected.bind(this,value));break;case'home':case'holdhome':case'sheets-gesture-begin':if(!this.visible){return;}
this.hide();this.oncancel();break;case'attentionopened':this.hide();this.oncancel();break;}}};exports.ActionMenu=ActionMenu;}(window));;'use strict';(function(exports){function ImeMenu(listItems,title,successCb,cancelCb){this.onselected=successCb||function(){};this.oncancel=cancelCb||function(){};this.listItems=listItems;this.title=title;}
ImeMenu.prototype={start:function(){LazyLoader.load('shared/js/template.js',this.initUI.bind(this));},initUI:function(){var dummy=document.createElement('div');var _=navigator.mozL10n?navigator.mozL10n.get:function(){};dummy.innerHTML=Template('ime-menu-template').interpolate({title:this.title,cancelLabel:_('cancel'),settingsLabel:_('ime-settings')});this.container=dummy.firstElementChild;this.menu=this.container.querySelector('.ime-menu-list');this.buildMenu(this.listItems);document.getElementById('screen').appendChild(this.container);this.container.addEventListener('submit',this);this.container.addEventListener('click',this);window.addEventListener('attentionopened',this,true);window.addEventListener('screenchange',this,true);window.addEventListener('home',this);window.addEventListener('holdhome',this);this.container.addEventListener('mousedown',this.preventFocusChange);window.dispatchEvent(new CustomEvent('imemenushow'));},stop:function(){document.getElementById('screen').removeChild(this.container);window.removeEventListener('attentionopened',this,true);window.removeEventListener('screenchange',this,true);window.removeEventListener('home',this);window.removeEventListener('holdhome',this);this.container.removeEventListener('mousedown',this.preventFocusChange);},buildMenu:function(items){this.menu.innerHTML='';var itemTemplate=new Template('ime-menu-item-template');items.forEach(function traveseItems(item){this.menu.innerHTML+=itemTemplate.interpolate({layoutName:item.layoutName,appName:item.appName,layoutId:item.value.toString(),selected:item.selected?'true':'false'});},this);},hide:function(callback){this.stop();if(callback&&typeof callback==='function'){setTimeout(callback);}},preventFocusChange:function(evt){evt.preventDefault();},handleEvent:function(evt){var target=evt.target;var type=evt.type;switch(type){case'submit':evt.preventDefault();break;case'screenchange':if(!evt.detail.screenEnabled){this.hide();this.oncancel();}
break;case'click':evt.preventDefault();var action=target.dataset.action;if(action){if(action==='cancel'){this.hide();this.oncancel();return;}
if(action==='settings'){this.hide();this.launchSettings();return;}}
var id=target.dataset.id;if(!id){return;}
id=parseInt(id);this.hide(this.onselected.bind(this,id));break;case'home':case'holdhome':this.hide();this.oncancel();break;case'attentionopened':this.hide();break;}},launchSettings:function(){var activity=new MozActivity({name:'configure',data:{target:'device',section:'keyboard'}});activity.onerror=function(){console.error('Failed to invoke keyboard settings.');};}};exports.ImeMenu=ImeMenu;}(window));;'use strict';(function(exports){function Clock(){this.timeoutID=null;this.timerID=null;this.start=function cl_start(refresh){var date=new Date();var self=this;refresh(date);if(this.timeoutID==null){this.timeoutID=window.setTimeout(function cl_setClockInterval(){refresh(new Date());if(self.timerID==null){self.timerID=window.setInterval(function cl_clockInterval(){refresh(new Date());},60000);}},(60-date.getSeconds())*1000);}};this.stop=function cl_stop(){if(this.timeoutID!=null){window.clearTimeout(this.timeoutID);this.timeoutID=null;}
if(this.timerID!=null){window.clearInterval(this.timerID);this.timerID=null;}};}
exports.Clock=Clock;})(window);;'use strict';var StatusBar={ELEMENTS:['emergency-cb-notification','time','connections','battery','wifi','data','flight-mode','network-activity','tethering','alarm','debugging','bluetooth','mute','headphones','bluetooth-headphones','bluetooth-transferring','recording','sms','geolocation','usb','label','system-downloads','call-forwardings','playing','nfc'],PRIORITIES:[['emergency-cb-notification',16+4],['battery',25+4],['recording',16+4],['flight-mode',16+4],['wifi',16+4],['connections',null],['time',null],['debugging',16+4],['system-downloads',16+4],['geolocation',16+4],['network-activity',16+4],['tethering',16+4],['bluetooth-transferring',16+4],['bluetooth',16+4],['nfc',16+4],['usb',16+4],['alarm',16+4],['bluetooth-headphones',16+4],['mute',16+4],['call-forwardings',null],['playing',16+4],['headphones',16+4],['label',null]],kActiveIndicatorTimeout:5*1000,active:true,_inLockScreenMode:false,settingValues:{},icons:{},mobileDataIconTypes:{'lte':'4G','ehrpd':'4G','hspa+':'H+','hsdpa':'H','hsupa':'H','hspa':'H','evdo0':'Ev','evdoa':'Ev','evdob':'Ev','umts':'3G','edge':'E','gprs':'2G','1xrtt':'1x','is95a':'1x','is95b':'1x'},dataExclusiveCDMATypes:{'evdo0':true,'evdoa':true,'evdob':true,'1xrtt':true,'is95a':true,'is95b':true},settings:{'ril.radio.disabled':['signal','data'],'airplaneMode.status':['flightMode'],'ril.data.enabled':['data'],'wifi.enabled':['wifi'],'bluetooth.enabled':['bluetooth'],'tethering.usb.enabled':['tethering'],'tethering.wifi.enabled':['tethering'],'tethering.wifi.connectedClients':['tethering'],'tethering.usb.connectedClients':['tethering'],'audio.volume.notification':['mute'],'alarm.enabled':['alarm'],'vibration.enabled':['vibration'],'ril.cf.enabled':['callForwarding'],'operatorResources.data.icon':['iconData'],'statusbar.network-activity.disabled':['networkActivity'],'statusbar.show-am-pm':['time'],'debugger.remote-mode':['debugging']},observedSettings:{},geolocationActive:false,geolocationTimer:null,recordingActive:false,recordingTimer:null,nfcActive:false,umsActive:false,headphonesActive:false,listeningCallschanged:false,playingActive:false,systemDownloadsCount:0,systemDownloads:{},_minimizedStatusBarWidth:window.innerWidth,clock:new Clock(),get height(){var current=Service.currentApp&&Service.currentApp.getTopMostWindow();if(document.mozFullScreen||(current&&current.isFullScreen())){return 0;}else{return this._cacheHeight||(this._cacheHeight=this.element.getBoundingClientRect().height);}},init:function sb_init(){this.getAllElements();this._cacheHeight=this.element.getBoundingClientRect().height;this.listeningCallschanged=false;window.addEventListener('ftudone',this);window.addEventListener('ftuskip',this);window.addEventListener('ftuopen',this);window.addEventListener('apptitlestatechanged',this);window.addEventListener('activitytitlestatechanged',this);window.addEventListener('appchromecollapsed',this);window.addEventListener('appchromeexpanded',this);window.addEventListener('emergencycallbackstatechanged',this);},addSettingsListener:function sb_addSettingsListener(settingKey){if(this.observedSettings[settingKey]){return;}
this.observedSettings[settingKey]=true;SettingsListener.observe(settingKey,false,(value)=>{this.settingValues[settingKey]=value;this.settings[settingKey].forEach((name)=>this.update[name].call(this));});this.settingValues[settingKey]=false;},addConnectionsListeners:function(){var conns=window.navigator.mozMobileConnections;if(conns){Array.from(conns).forEach((conn)=>{conn.addEventListener('voicechange',this);conn.addEventListener('datachange',this);this.update.signal.call(this);this.update.data.call(this);});}},removeConnectionsListeners:function(){var conns=window.navigator.mozMobileConnections;if(conns){Array.from(conns).forEach((conn)=>{conn.removeEventListener('voicechange',this);conn.removeEventListener('datachange',this);});}},finishInit:function(){this.createConnectionsElements();this.createCallForwardingsElements();this.toggleTimeLabel(true);for(var key in this.settings){this.addSettingsListener(key);}
window.addEventListener('attentionopened',this);window.addEventListener('attentionclosed',this);window.addEventListener('sheets-gesture-begin',this);window.addEventListener('sheets-gesture-end',this);window.addEventListener('utilitytraywillshow',this);window.addEventListener('utilitytraywillhide',this);window.addEventListener('utility-tray-overlayopened',this);window.addEventListener('utility-tray-overlayclosed',this);window.addEventListener('utility-tray-abortopen',this);window.addEventListener('utility-tray-abortclose',this);window.addEventListener('cardviewshown',this);window.addEventListener('cardviewclosed',this);window.addEventListener('rocketbar-deactivated',this);window.addEventListener('screenchange',this);var acm=navigator.mozAudioChannelManager;if(acm){this.headphonesActive=acm.headphones;this.update.headphones.call(this);}
window.addEventListener('mozChromeEvent',this);window.addEventListener('recordingEvent',this);window.addEventListener('nfc-state-changed',this);window.addEventListener('bluetoothconnectionchange',this);window.addEventListener('bluetoothprofileconnectionchange',this);window.addEventListener('moztimechange',this);window.addEventListener('timeformatchange',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('lockscreen-appclosing',this);window.addEventListener('lockpanelchange',this);window.addEventListener('system-resize',this);window.addEventListener('attentionopened',this);window.addEventListener('appopening',this);window.addEventListener('appopened',this);window.addEventListener('hierarchytopmostwindowchanged',this);window.addEventListener('activityopened',this);window.addEventListener('activitydestroyed',this);window.addEventListener('homescreenopening',this);window.addEventListener('homescreenopened',this);window.addEventListener('stackchanged',this);window.addEventListener('updatepromptshown',this);window.addEventListener('updateprompthidden',this);var mozDownloadManager=navigator.mozDownloadManager;if(mozDownloadManager){mozDownloadManager.addEventListener('downloadstart',this);}
var events=['touchstart','touchmove','touchend','mousedown','mousemove','mouseup'];events.forEach(function bindEvents(name){this.topPanel.addEventListener(name,this.panelHandler.bind(this));},this);this.statusbarIcons.addEventListener('wheel',this);this.systemDownloadsCount=0;this.setActive(true);UtilityTray.init();},handleEvent:function sb_handleEvent(evt){switch(evt.type){case'emergencycallbackstatechanged':this.updateEmergencyCbNotification(evt.detail);break;case'screenchange':this.setActive(evt.detail.screenEnabled);this._updateIconVisibility();break;case'lockscreen-appopened':this.toggleTimeLabel(false);this._updateIconVisibility();this._inLockScreenMode=true;this.setAppearance();break;case'lockscreen-appclosing':this.toggleTimeLabel(true);this._updateIconVisibility();this._inLockScreenMode=false;this.setAppearance();break;case'attentionopened':this.toggleTimeLabel(true);this.element.classList.add('maximized');this.element.classList.remove('light');break;case'attentionclosed':this.toggleTimeLabel(!this.isLocked());break;case'sheets-gesture-begin':this.element.classList.add('hidden');this.pauseUpdate(evt.type);break;case'utilitytraywillshow':case'utilitytraywillhide':case'cardviewshown':this.pauseUpdate(evt.type);break;case'utility-tray-overlayopened':case'utility-tray-overlayclosed':case'utility-tray-abortopen':case'utility-tray-abortclose':case'cardviewclosed':this.resumeUpdate(evt.type);break;case'lockpanelchange':if(this.screen.classList.contains('locked')){var isHidden=(evt.detail.panel!=='emergency-call');this.toggleTimeLabel(!isHidden);}
break;case'chargingchange':case'levelchange':case'statuschange':this.update.battery.call(this);break;case'voicechange':this.update.signal.call(this);this.update.label.call(this);break;case'cardstatechange':this.update.signal.call(this);this.update.label.call(this);this.update.data.call(this);break;case'callschanged':this.update.signal.call(this);this.update.data.call(this);break;case'simslot-iccinfochange':this.update.label.call(this);break;case'wifi-statuschange':this.update.wifi.call(this);break;case'datachange':this.update.data.call(this);break;case'bluetoothconnectionchange':this.update.bluetooth.call(this);break;case'bluetoothprofileconnectionchange':this.update.bluetoothProfiles.call(this);break;case'timeformatchange':case'moztimechange':navigator.mozL10n.ready((function _updateTime(){this.toggleTimeLabel(false);this.toggleTimeLabel(true);this.toggleTimeLabel(!this.isLocked());}).bind(this));break;case'recordingEvent':switch(evt.detail.type){case'recording-state-changed':this.recordingActive=evt.detail.active;this.update.recording.call(this);break;}
break;case'nfc-state-changed':this.setActiveNfc(evt.detail.active);break;case'mozChromeEvent':switch(evt.detail.type){case'geolocation-status':this.geolocationActive=evt.detail.active;this.update.geolocation.call(this);break;case'volume-state-changed':this.umsActive=evt.detail.active;this.update.usb.call(this);break;case'headphones-status-changed':this.headphonesActive=(evt.detail.state!='off');this.update.headphones.call(this);break;case'audio-channel-changed':var active=evt.detail.channel==='content'&&!this.recordingActive;if(this.playingActive===active){break;}
this.playingActive=active;this.update.playing.call(this);break;}
break;case'moznetworkupload':case'moznetworkdownload':this.update.networkActivity.call(this);break;case'ftuopen':if(FtuLauncher.isFtuUpgrading()){this.finishInit();}else{this.setActiveBattery(true);this._updateIconVisibility();window.addEventListener('iac-ftucomms',this);}
break;case'ftudone':window.removeEventListener('iac-ftucomms',this);this.finishInit();break;case'ftuskip':this.finishInit();break;case'iac-ftucomms':if(evt.detail.type==='step'){this.handleFtuStep(evt.detail.hash);}
break;case'wheel':if(evt.deltaMode===evt.DOM_DELTA_PAGE&&evt.deltaY&&evt.deltaY<0&&!this.isLocked()){window.dispatchEvent(new CustomEvent('statusbarwheel'));}
break;case'system-resize':this._updateMinimizedStatusBarWidth();break;case'homescreenopening':case'appopening':this.element.classList.add('hidden');break;case'sheets-gesture-end':this.element.classList.remove('hidden');this.resumeUpdate(evt.type);break;case'stackchanged':case'rocketbar-deactivated':this.setAppearance();this.element.classList.remove('hidden');break;case'appchromecollapsed':this.setAppearance();this._updateMinimizedStatusBarWidth();break;case'appopened':case'hierarchytopmostwindowchanged':case'appchromeexpanded':this.setAppearance();this.element.classList.remove('hidden');this._updateMinimizedStatusBarWidth();break;case'activityopened':this._updateMinimizedStatusBarWidth();case'apptitlestatechanged':case'activitytitlestatechanged':this.setAppearance();if(!this.isPaused()){this.element.classList.remove('hidden');}
break;case'homescreenopened':this.setAppearance();this.resumeUpdate(evt.type);this.element.classList.remove('hidden');this.element.classList.remove('fullscreen');this.element.classList.remove('fullscreen-layout');break;case'activitydestroyed':this._updateMinimizedStatusBarWidth();break;case'downloadstart':this.addSystemDownloadListeners(evt.download);break;case'updatepromptshown':this.element.classList.remove('light');break;case'updateprompthidden':this.setAppearance(Service.currentApp);break;}},addSystemDownloadListeners:function(download){var handler=function handleDownloadStateChange(downloadEvent){var download=downloadEvent.download;switch(download.state){case'downloading':if(!this.systemDownloads[download.id]){this.incSystemDownloads();this.systemDownloads[download.id]=true;}
break;case'finalized':download.removeEventListener('statechange',handler);break;case'stopped':case'succeeded':if(this.systemDownloads[download.id]){this.decSystemDownloads();delete this.systemDownloads[download.id];}
break;default:console.warn('Unexpected download state = ',download.state);}}.bind(this);download.addEventListener('statechange',handler);},setAppearance:function(){if(this._inLockScreenMode){this.element.classList.add('maximized');return;}
var app=Service.query('getTopMostWindow');if(!app){return;}
var topWindow=app.getTopMostWindow();if(topWindow){this.element.classList.toggle('light',!!(topWindow.appChrome&&topWindow.appChrome.useLightTheming()));this.element.classList.toggle('fullscreen',topWindow.isFullScreen());this.element.classList.toggle('fullscreen-layout',topWindow.isFullScreenLayout());}
this.element.classList.toggle('maximized',app.isHomescreen||app.isAttentionWindow||!!(app.appChrome&&app.appChrome.isMaximized()));},_getMaximizedStatusBarWidth:function sb_getMaximizedStatusBarWidth(){return Math.round(layoutManager.width-(3*2));},_updateMinimizedStatusBarWidth:function sb_updateMinimizedStatusBarWidth(){var app=Service.currentApp;app=app&&app.getTopMostWindow();var appChrome=app&&app.appChrome;if(appChrome&&appChrome.isMaximized()){this._updateIconVisibility();return;}
var element=appChrome&&appChrome.element&&appChrome.element.querySelector('.urlbar .chrome-title-container');if(element){this._minimizedStatusBarWidth=Math.round(layoutManager.width-
element.getBoundingClientRect().width-
5-3);}else{this._minimizedStatusBarWidth=this._getMaximizedStatusBarWidth();}
this._updateIconVisibility();},_paused:0,_eventGroupStates:{utilitytrayopening:false,utilitytrayclosing:false,cardview:false,sheetsgesture:false,marionette:false},pauseUpdate:function sb_pauseUpdate(evtType){var eventGroup=this._eventTypeToEventGroup(evtType);if(this._eventGroupStates[eventGroup]){return;}
this._eventGroupStates[eventGroup]=true;this._paused++;},resumeUpdate:function sb_resumeUpdate(evtType){var eventGroup=this._eventTypeToEventGroup(evtType);if(!this._eventGroupStates[eventGroup]){return;}
this._eventGroupStates[eventGroup]=false;this._paused--;if(!this.isPaused()){this._updateIconVisibility();}},_eventTypeToEventGroup:function sb_eventTypeToEventGroup(evtType){switch(evtType){case'utilitytraywillshow':case'utility-tray-overlayopened':case'utility-tray-abortopen':return'utilitytrayopening';case'utilitytraywillhide':case'utility-tray-overlayclosed':case'utility-tray-abortclose':return'utilitytrayclosing';case'cardviewshown':case'cardviewclosed':return'cardview';case'sheets-gesture-begin':case'sheets-gesture-end':case'homescreenopened':return'sheetsgesture';}
return evtType;},isPaused:function sb_isPaused(){return this._paused>0;},_updateIconVisibility:function sb_updateIconVisibility(){if(this.isPaused()){return;}
this.cloneStatusbar();var maximizedStatusBarWidth=this._getMaximizedStatusBarWidth();var minimizedStatusBarWidth=this._minimizedStatusBarWidth;this.PRIORITIES.forEach(function sb_updateIconVisibilityForEach(iconObj){var iconId=iconObj[0];var icon=this.icons[this.toCamelCase(iconId)];if(!icon||icon.hidden){return;}
var className='sb-hide-'+iconId;if(maximizedStatusBarWidth<0){this.statusbarIcons.classList.add(className);return;}
this.statusbarIcons.classList.remove(className);this.statusbarIconsMin.classList.remove(className);var iconWidth=this._getIconWidth(iconObj);maximizedStatusBarWidth-=iconWidth;if(maximizedStatusBarWidth<0){this.statusbarIcons.classList.add(className);return;}
minimizedStatusBarWidth-=iconWidth;if(minimizedStatusBarWidth<0){this.statusbarIconsMin.classList.add(className);}}.bind(this));},_getIconWidth:function sb_getIconWidth(iconObj){var iconWidth=iconObj[1];if(!iconWidth){var icon=this.icons[this.toCamelCase(iconObj[0])];iconWidth=this._getWidthFromDomElementWidth(icon);}
return iconWidth;},_getWidthFromDomElementWidth:function sb_getWidthFromDomElementWidth(icon){var style=window.getComputedStyle(icon);var iconWidth=icon.clientWidth+
parseInt(style.marginLeft,10)+
parseInt(style.marginRight,10);return iconWidth;},_getTimeFormat:function sb_getTimeFormat(timeFormat){if(this.settingValues['statusbar.show-am-pm']){timeFormat=timeFormat.replace('%p','<span>%p</span>');}else{timeFormat=timeFormat.replace('%p','').trim();}
return timeFormat;},panelHandler:function sb_panelHandler(evt){if(FtuLauncher.isFtuRunning()){return;}
if(UtilityTray.active){return;}
var app=Service.query('getTopMostWindow');app&&app.handleStatusbarTouch(evt,this._cacheHeight);},handleFtuStep:function sb_handleFtuStep(stepHash){switch(stepHash){case'#languages':this.createConnectionsElements();this._updateIconVisibility();this.addConnectionsListeners();this.addSettingsListener('ril.data.enabled');break;case'#wifi':this.setActiveWifi(true);this.addSettingsListener('wifi.enabled');this._updateIconVisibility();break;case'#date_and_time':this.toggleTimeLabel(true);this._updateIconVisibility();break;}},setActive:function sb_setActive(active){this.active=active;this.setActiveBattery(active);if(active){this.setActiveNfc(nfcManager.isActive());this.addConnectionsListeners();window.addEventListener('simslot-iccinfochange',this);window.addEventListener('wifi-statuschange',this);this.setActiveWifi(true);window.addEventListener('moznetworkupload',this);window.addEventListener('moznetworkdownload',this);this.refreshCallListener();this.toggleTimeLabel(!this.isLocked());}else{this.removeConnectionsListeners();window.removeEventListener('simslot-iccinfochange',this);window.removeEventListener('wifi-statuschange',this);window.removeEventListener('moznetworkupload',this);window.removeEventListener('moznetworkdownload',this);this.removeCallListener();this.toggleTimeLabel(false);}},setActiveBattery:function sb_setActiveBattery(active){var battery=window.navigator.battery;if(!battery){return;}
if(active){battery.addEventListener('chargingchange',this);battery.addEventListener('levelchange',this);battery.addEventListener('statuschange',this);this.update.battery.call(this);}else{battery.removeEventListener('chargingchange',this);battery.removeEventListener('levelchange',this);battery.removeEventListener('statuschange',this);}},setActiveWifi:function sb_setActiveWifi(active){if(active){var wifiManager=window.navigator.mozWifiManager;if(wifiManager){wifiManager.connectionInfoUpdate=this.update.wifi.bind(this);}
this.update.wifi.call(this);}},setActiveNfc:function sb_setActiveNfc(active){this.nfcActive=active;this.update.nfc.call(this);},update:{iconData:function sb_updateIconData(aData){var dataIconValues=this.settingValues['operatorResources.data.icon'];if(!dataIconValues){return;}
for(var key in dataIconValues){if(this.mobileDataIconTypes[key]){this.mobileDataIconTypes[key]=dataIconValues[key];}}},label:function sb_updateLabel(){var conns=window.navigator.mozMobileConnections;var conn;if(conns&&conns.length==1){conn=conns[0];}
var self=this;var label=this.icons.label;var previousLabelContent=label.textContent;var l10nArgs=JSON.parse(label.dataset.l10nArgs||'{}');if(!conn||!conn.voice||!conn.voice.connected||conn.voice.emergencyCallsOnly){delete l10nArgs.operator;label.dataset.l10nArgs=JSON.stringify(l10nArgs);label.dataset.l10nId='';label.textContent=l10nArgs.date;if(previousLabelContent!==label.textContent){updateLabelWidth();}
return;}
var operatorInfos=MobileOperator.userFacingInfo(conn);l10nArgs.operator=operatorInfos.operator;if(operatorInfos.region){l10nArgs.operator+=' '+operatorInfos.region;}
label.dataset.l10nArgs=JSON.stringify(l10nArgs);label.dataset.l10nId='statusbarLabel';label.textContent=navigator.mozL10n.get('statusbarLabel',l10nArgs);if(previousLabelContent!==label.textContent){updateLabelWidth();}
function updateLabelWidth(){self.PRIORITIES.some(function(iconObj){if(iconObj[0]==='label'){iconObj[1]=self._getWidthFromDomElementWidth(label);return true;}
return false;});}},time:function sb_updateTime(now){now=now||new Date();var _=navigator.mozL10n.get;var f=new navigator.mozL10n.DateTimeFormat();var timeFormat=window.navigator.mozHour12?_('shortTimeFormat12'):_('shortTimeFormat24');timeFormat=this._getTimeFormat(timeFormat);var formatted=f.localeFormat(now,timeFormat);this.icons.time.innerHTML=formatted;var label=this.icons.label;var l10nArgs=JSON.parse(label.dataset.l10nArgs||'{}');l10nArgs.date=f.localeFormat(now,_('statusbarDateFormat'));label.dataset.l10nArgs=JSON.stringify(l10nArgs);this.update.label.call(this);this._updateIconVisibility();},battery:function sb_updateBattery(){var battery=window.navigator.battery;if(!battery){return;}
var icon=this.icons.battery;var previousLevel=parseInt(icon.dataset.level,10);var previousCharging=icon.dataset.charging==='true';icon.dataset.charging=battery.charging;var level=Math.floor(battery.level*10)*10;if(previousLevel!==level||previousCharging!==battery.charging){icon.dataset.level=level;navigator.mozL10n.setAttributes(icon,battery.charging?'statusbarBatteryCharging':'statusbarBattery',{level:level});this.previousCharging=battery.charging;this.cloneStatusbar();}},networkActivity:function sb_updateNetworkActivity(){var icon=this.icons.networkActivity;clearTimeout(this._networkActivityTimer);this._networkActivityTimer=setTimeout(function hideNetActivityIcon(){icon.hidden=true;this._updateIconVisibility();}.bind(this),500);if(icon.hidden){icon.hidden=false;this._updateIconVisibility();}},flightMode:function sb_flightMode(){var flightModeIcon=this.icons.flightMode;var status=this.settingValues['airplaneMode.status'];if(status==='enabled'){flightModeIcon.hidden=false;}else if(status==='disabled'){flightModeIcon.hidden=true;}
this._updateIconVisibility();},signal:function sb_updateSignal(){var simSlots=SIMSlotManager.getSlots();var isDirty=false;for(var index=0;index<simSlots.length;index++){var simslot=simSlots[index];var conn=simslot.conn;var voice=conn.voice;var data=conn.data;var icon=this.icons.signals[index];var roaming=this.icons.roaming[index];var _=navigator.mozL10n.get;if(!voice){continue;}
var previousHiddenState=icon.hidden;var previousActiveState=icon.dataset.inactive;var previousSearchingState=icon.dataset.searching;var previousRoamingHiddenState=roaming.hidden;if(this.settingValues['ril.radio.disabled']){icon.hidden=true;if(previousHiddenState!==icon.hidden){isDirty=true;}
continue;}
icon.hidden=false;icon.dataset.inactive=false;if(simslot.isAbsent()){delete icon.dataset.level;delete icon.dataset.searching;roaming.hidden=true;icon.hidden=true;icon.dataset.inactive=true;icon.setAttribute('aria-label',_('noSimCard'));}else if(data&&data.connected&&data.type.startsWith('evdo')){this.updateSignalIcon(icon,data);}else if(voice.connected||this.hasActiveCall()&&navigator.mozTelephony.active.serviceId===index){this.updateSignalIcon(icon,voice);}else if(simslot.isLocked()){icon.hidden=true;}else{icon.dataset.level=-1;icon.dataset.searching=(voice.state==='searching');roaming.hidden=true;icon.setAttribute('aria-label',_(icon.dataset.searching?'statusbarSignalNoneSearching':'emergencyCallsOnly'));}
if(previousHiddenState!==icon.hidden||previousActiveState!==icon.dataset.inactive||previousSearchingState!==icon.dataset.searching||previousRoamingHiddenState!==roaming.hidden){isDirty=true;}}
this.updateConnectionsVisibility();this.refreshCallListener();if(isDirty){this._updateIconVisibility();}},data:function sb_updateSignal(){var conns=window.navigator.mozMobileConnections;if(!conns){this.updateConnectionsVisibility();return;}
var isDirty=false;for(var index=0;index<conns.length;index++){var conn=conns[index];var data=conn.data;var icon=this.icons.data[index];if(!data){continue;}
var previousHiddenState=icon.hidden;if(this.settingValues['ril.radio.disabled']||!this.settingValues['ril.data.enabled']||!this.icons.wifi.hidden||!data.connected){icon.hidden=true;if(previousHiddenState!==icon.hidden){isDirty=true;}
continue;}
var type=this.mobileDataIconTypes[data.type];icon.hidden=false;icon.textContent='';icon.classList.remove('sb-icon-data-circle');if(type){if(this.dataExclusiveCDMATypes[data.type]){var telephony=window.navigator.mozTelephony;if(telephony.calls&&telephony.calls.length>0){icon.textContent='';}else{icon.textContent=type;}}else{icon.textContent=type;}}else{icon.classList.add('sb-icon-data-circle');}
icon.setAttribute('aria-hidden',!!icon.textContent);if(previousHiddenState!==icon.hidden){isDirty=true;}}
this.updateConnectionsVisibility();this.refreshCallListener();if(isDirty){this._updateIconVisibility();}},wifi:function sb_updateWifi(){var wifiManager=window.navigator.mozWifiManager;if(!wifiManager){return;}
var icon=this.icons.wifi;var wasHidden=icon.hidden;if(!this.settingValues['wifi.enabled']){icon.hidden=true;if(!wasHidden){this.update.data.call(this);}
return;}
switch(wifiManager.connection.status){case'disconnected':icon.hidden=true;break;case'connecting':case'associated':icon.hidden=false;icon.dataset.connecting=true;icon.dataset.level=0;icon.setAttribute('aria-label',navigator.mozL10n.get('statusbarWiFiConnecting'));break;case'connected':icon.hidden=false;if(icon.dataset.connecting){delete icon.dataset.connecting;}
var level=Math.min(Math.floor(wifiManager.connectionInformation.relSignalStrength/20),4);icon.dataset.level=level;icon.setAttribute('aria-label',navigator.mozL10n.get('statusbarWiFiConnected',{level:level}));break;}
if(icon.hidden!==wasHidden){this.update.data.call(this);}
this._updateIconVisibility();},tethering:function sb_updateTethering(){var icon=this.icons.tethering;icon.hidden=!(this.settingValues['tethering.usb.enabled']||this.settingValues['tethering.wifi.enabled']);icon.dataset.active=(this.settingValues['tethering.wifi.connectedClients']!==0)||(this.settingValues['tethering.usb.connectedClients']!==0);this.updateIconLabel(icon,'tethering',icon.dataset.active);this._updateIconVisibility();},bluetooth:function sb_updateBluetooth(){var icon=this.icons.bluetooth;icon.hidden=!this.settingValues['bluetooth.enabled'];icon.dataset.active=Bluetooth.connected;this.updateIconLabel(icon,'bluetooth',icon.dataset.active);this._updateIconVisibility();},bluetoothProfiles:function sv_updateBluetoothProfiles(){var bluetoothHeadphoneIcon=this.icons.bluetoothHeadphones;var bluetoothTransferringIcon=this.icons.bluetoothTransferring;bluetoothHeadphoneIcon.hidden=!Bluetooth.isProfileConnected(Bluetooth.Profiles.A2DP);bluetoothTransferringIcon.hidden=!Bluetooth.isProfileConnected(Bluetooth.Profiles.OPP);this._updateIconVisibility();},alarm:function sb_updateAlarm(){this.icons.alarm.hidden=!this.settingValues['alarm.enabled'];this._updateIconVisibility();},mute:function sb_updateMute(){var icon=this.icons.mute;icon.hidden=(this.settingValues['audio.volume.notification']!==0);this.updateIconLabel(icon,(this.settingValues['vibration.enabled']===true)?'vibration':'mute');this._updateIconVisibility();},vibration:function sb_vibration(){var icon=this.icons.mute;var vibrate=(this.settingValues['vibration.enabled']===true);if(vibrate){icon.classList.add('vibration');this.updateIconLabel(icon,'vibration');}else{icon.classList.remove('vibration');this.updateIconLabel(icon,'mute');}},recording:function sb_updateRecording(){clearTimeout(this.recordingTimer);var icon=this.icons.recording;icon.dataset.active=this.recordingActive;if(this.recordingActive){icon.hidden=false;this._updateIconVisibility();return;}
this.recordingTimer=setTimeout(function hideRecordingIcon(){icon.hidden=true;this._updateIconVisibility();}.bind(this),this.kActiveIndicatorTimeout);this.cloneStatusbar();},sms:function sb_updateSms(){},geolocation:function sb_updateGeolocation(){clearTimeout(this.geolocationTimer);var icon=this.icons.geolocation;icon.dataset.active=this.geolocationActive;if(this.geolocationActive){icon.hidden=false;this._updateIconVisibility();return;}
this.geolocationTimer=setTimeout(function hideGeolocationIcon(){icon.hidden=true;this._updateIconVisibility();}.bind(this),this.kActiveIndicatorTimeout);this.cloneStatusbar();},usb:function sb_updateUsb(){var icon=this.icons.usb;icon.hidden=!this.umsActive;this._updateIconVisibility();},headphones:function sb_updateHeadphones(){var icon=this.icons.headphones;icon.hidden=!this.headphonesActive;this._updateIconVisibility();},systemDownloads:function sb_updatesystemDownloads(){var icon=this.icons.systemDownloads;icon.hidden=(this.systemDownloadsCount===0);this._updateIconVisibility();},callForwarding:function sb_updateCallForwarding(){var icons=this.icons.callForwardingsElements;var states=this.settingValues['ril.cf.enabled'];if(states){states.forEach(function(state,index){icons[index].hidden=!state;});}
this.updateCallForwardingsVisibility();this._updateIconVisibility();},playing:function sb_updatePlaying(){var icon=this.icons.playing;icon.hidden=!this.playingActive;this._updateIconVisibility();},nfc:function sb_updateNfc(){var icon=this.icons.nfc;icon.hidden=!this.nfcActive;this._updateIconVisibility();},debugging:function sb_updateDebugging(){var icon=this.icons.debugging;icon.hidden=this.settingValues['debugger.remote-mode']=='disabled';this._updateIconVisibility();}},updateConnectionsVisibility:function sb_updateConnectionsVisibility(){var conns=window.navigator.mozMobileConnections;if(!conns||!this.icons.signals){return;}
var icons=this.icons;icons.connections.hidden=false;icons.connections.dataset.multiple=(conns.length>1);for(var index=0;index<conns.length;index++){if(icons.signals[index].dataset.inactive==='false'){return;}}
icons.connections.dataset.multiple=false;icons.signals[0].hidden=false;},updateCallForwardingsVisibility:function sb_updateCallFwdingsVisibility(){var conns=window.navigator.mozMobileConnections;if(!conns){return;}
var icons=this.icons;for(var index=0;index<conns.length;index++){if(!icons.callForwardingsElements[index].hidden){icons.callForwardings.hidden=false;return;}}
icons.callForwardings.hidden=true;},hasActiveCall:function sb_hasActiveCall(){var telephony=navigator.mozTelephony;return!!(telephony&&telephony.active);},updateIconLabel:function sb_updateIconLabel(icon,type,active){if(icon.hidden){return;}
icon.setAttribute('aria-label',navigator.mozL10n.get((active?'statusbarIconOnActive-':'statusbarIconOn-')+type));},updateSignalIcon:function sb_updateSignalIcon(icon,connInfo){icon.dataset.level=Math.ceil(connInfo.relSignalStrength/20);var slotIndex=icon.dataset.index?(icon.dataset.index-1):0;var roaming=this.icons.roaming[slotIndex];roaming.hidden=!connInfo.roaming;delete icon.dataset.searching;icon.setAttribute('aria-label',navigator.mozL10n.get(connInfo.roaming?'statusbarSignalRoaming':'statusbarSignal',{level:icon.dataset.level,operator:connInfo.network&&connInfo.network.shortName}));},refreshCallListener:function sb_refreshCallListener(){var conns=window.navigator.mozMobileConnections;if(!conns){return;}
var emergencyCallsOnly=false;var cdmaConnection=false;var self=this;Array.prototype.slice.call(conns).forEach(function(conn){emergencyCallsOnly=emergencyCallsOnly||(conn&&conn.voice&&conn.voice.emergencyCallsOnly);cdmaConnection=cdmaConnection||(conn&&conn.data&&!!self.dataExclusiveCDMATypes[conn.data.type]);});if(emergencyCallsOnly||cdmaConnection){this.addCallListener();}else{this.removeCallListener();}},addCallListener:function sb_addCallListener(){var telephony=navigator.mozTelephony;if(telephony&&!this.listeningCallschanged){this.listeningCallschanged=true;telephony.addEventListener('callschanged',this);}},removeCallListener:function sb_addCallListener(){var telephony=navigator.mozTelephony;if(telephony){this.listeningCallschanged=false;telephony.removeEventListener('callschanged',this);}},toggleTimeLabel:function sb_toggleTimeLabel(enable){var icon=this.icons.time;if(enable){this.clock.start(this.update.time.bind(this));}else{this.clock.stop();}
icon.hidden=!enable;},updateEmergencyCbNotification:function sb_updateEmergencyCbNotification(show){var icon=this.icons.emergencyCbNotification;if(!show){icon.hidden=true;return;}
icon.hidden=false;},incSystemDownloads:function sb_incSystemDownloads(){this.systemDownloadsCount++;this.update.systemDownloads.call(this);},decSystemDownloads:function sb_decSystemDownloads(){if(--this.systemDownloadsCount<0){this.systemDownloadsCount=0;}
this.update.systemDownloads.call(this);},createConnectionsElements:function sb_createConnectionsElements(){if(this.icons.signals){return;}
var conns=window.navigator.mozMobileConnections;if(conns){var multipleSims=SIMSlotManager.isMultiSIM();this.icons.connections.dataset.multiple=multipleSims;this.icons.signals={};this.icons.data={};this.icons.roaming={};for(var i=conns.length-1;i>=0;i--){var signal=document.createElement('div');var data=document.createElement('div');var roaming=document.createElement('div');signal.className='sb-icon sb-icon-signal statusbar-signal';signal.dataset.level='5';if(multipleSims){signal.dataset.index=i+1;}
signal.setAttribute('role','listitem');signal.hidden=true;data.setAttribute('role','listitem');data.className='sb-icon statusbar-data';data.hidden=true;roaming.setAttribute('role','listitem');roaming.className='sb-icon sb-icon-roaming';roaming.hidden=true;signal.appendChild(data);this.icons.connections.appendChild(signal);this.icons.connections.appendChild(roaming);this.icons.signals[i]=signal;this.icons.data[i]=data;this.icons.roaming[i]=roaming;}
this.updateConnectionsVisibility();}},createCallForwardingsElements:function sb_createCallForwardingsElements(){if(this.icons.callForwardingsElements){return;}
var conns=window.navigator.mozMobileConnections;if(conns){var multipleSims=SIMSlotManager.isMultiSIM();var sbCallForwardings=document.getElementById('statusbar-call-forwardings');sbCallForwardings.dataset.multiple=multipleSims;this.icons.callForwardingsElements={};for(var idx=conns.length-1;idx>=0;idx--){var callForwarding=document.createElement('div');callForwarding.className='sb-icon sb-icon-call-forwarding';if(multipleSims){callForwarding.dataset.index=idx+1;}
callForwarding.setAttribute('role','listitem');callForwarding.setAttribute('aria-label','statusbarForwarding');callForwarding.hidden=true;this.icons.callForwardings.appendChild(callForwarding);this.icons.callForwardingsElements[idx]=callForwarding;}
this.updateCallForwardingsVisibility();}},getAllElements:function sb_getAllElements(){this.icons={};var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};this.ELEMENTS.forEach((function createElementRef(name){this.icons[toCamelCase(name)]=document.getElementById('statusbar-'+name);}).bind(this));this.element=document.getElementById('statusbar');this.background=document.getElementById('statusbar-background');this.statusbarIcons=document.getElementById('statusbar-icons');this.statusbarIconsMax=document.getElementById('statusbar-maximized');this.screen=document.getElementById('screen');this.topPanel=document.getElementById('top-panel');this.statusbarIconsMin=document.createElement('div');this.statusbarIcons.appendChild(this.statusbarIconsMin);this.cloneStatusbar();},cloneStatusbar:function(){var className=this.statusbarIconsMin.className;this.statusbarIcons.removeChild(this.statusbarIconsMin);this.statusbarIconsMin=this.statusbarIconsMax.parentNode.cloneNode(true);this.statusbarIconsMin.setAttribute('id','statusbar-minimized-wrapper');this.statusbarIconsMin.firstElementChild.setAttribute('id','statusbar-minimized');this.statusbarIconsMin.className=className;this.statusbarIcons.appendChild(this.statusbarIconsMin);},isLocked:function(){return Service.locked;},toCamelCase:function sb_toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});}};if(navigator.mozL10n){navigator.mozL10n.once(function(){StatusBar.init();});};'use strict';(function(exports){function SoftwareButtonManager(){this.isMobile=ScreenLayout.getCurrentLayout('tiny');this.isOnRealDevice=ScreenLayout.isOnRealDevice();this.hasHardwareHomeButton=ScreenLayout.getCurrentLayout('hardwareHomeButton');this.enabled=!this.hasHardwareHomeButton&&this.isMobile;this.element=document.getElementById('software-buttons');this.fullscreenLayoutElement=document.getElementById('software-buttons-fullscreen-layout');this.homeButtons=[document.getElementById('software-home-button'),document.getElementById('fullscreen-software-home-button'),document.getElementById('fullscreen-layout-software-home-button')];this.screenElement=document.getElementById('screen');this._fullscreenTapFunction=this._fullscreenTapFunction.bind(this);}
SoftwareButtonManager.prototype={hasHardwareHomeButton:true,enabled:false,overrideFlag:false,_cacheHeight:null,get height(){if(!this.enabled||!this._currentOrientation.contains('portrait')){return 0;}
return this._cacheHeight||(this._cacheHeight=this.element.getBoundingClientRect().height);},_cacheWidth:null,get width(){if(!this.enabled||!this._currentOrientation.contains('landscape')){return 0;}
return this._cacheWidth||(this._cacheWidth=this.element.getBoundingClientRect().width);},_buttonRect:null,_updateButtonRect:function(){var isFullscreen=!!document.mozFullScreenElement;var activeApp=Service.currentApp;var isFullscreenLayout=activeApp&&activeApp.isFullScreenLayout();var button;if(isFullscreenLayout){button=this.homeButtons[2];}else if(isFullscreen){button=this.homeButtons[1];}else{button=this.homeButtons[0];}
this._buttonRect=button.getBoundingClientRect();},_currentOrientation:null,start:function(){if(this.isMobile){if(!this.hasHardwareHomeButton&&this.isOnRealDevice){this.overrideFlag=true;var lock=SettingsListener.getSettingsLock();var req=lock.get('homegesture.enabled');req.onsuccess=function sbm_getHomeGestureEnabled(){var gestureEnabled=req.result['homegesture.enabled'];lock.set({'software-button.enabled':!gestureEnabled});};}
SettingsListener.observe('software-button.enabled',false,function onObserve(value){if(this.overrideFlag){this.overrideFlag=false;return;}
this.enabled=value;this.toggle();this.resizeAndDispatchEvent();}.bind(this));}else{this.enabled=false;this.toggle();}
this._currentOrientation=OrientationManager.fetchCurrentOrientation();window.screen.addEventListener('mozorientationchange',this);window.addEventListener('orientationchange',this);window.addEventListener('mozfullscreenchange',this);window.addEventListener('homegesture-enabled',this);window.addEventListener('homegesture-disabled',this);window.addEventListener('system-resize',this._updateButtonRect.bind(this));window.addEventListener('edge-touch-redispatch',this);window.addEventListener('hierachychanged',this);},resizeAndDispatchEvent:function(){if(this.enabled===this.element.classList.contains('visible')){return;}
var element=this.element;if(this.enabled){element.addEventListener('transitionend',function trWait(){element.removeEventListener('transitionend',trWait);window.dispatchEvent(new Event('software-button-enabled'));});element.classList.add('visible');}else{element.classList.remove('visible');window.dispatchEvent(new Event('software-button-disabled'));}},publish:function(type){this.element.dispatchEvent(new CustomEvent('softwareButtonEvent',{bubbles:true,detail:{type:type}}));},toggle:function(){delete this._cacheHeight;delete this._cacheWidth;if(this.enabled){this.screenElement.classList.add('software-button-enabled');this.screenElement.classList.remove('software-button-disabled');this.element.addEventListener('mousedown',this._preventFocus);this.homeButtons.forEach(function sbm_addTouchListeners(b){b.addEventListener('touchstart',this);b.addEventListener('mousedown',this);b.addEventListener('touchend',this);}.bind(this));window.addEventListener('mozfullscreenchange',this);}else{this.screenElement.classList.remove('software-button-enabled');this.screenElement.classList.add('software-button-disabled');this.element.removeEventListener('mousedown',this._preventFocus);this.homeButtons.forEach(function sbm_removeTouchListeners(b){b.removeEventListener('touchstart',this);b.removeEventListener('mousedown',this);b.removeEventListener('touchend',this);}.bind(this));window.removeEventListener('mozfullscreenchange',this);}},handleEvent:function(evt){switch(evt.type){case'mousedown':evt.preventDefault();break;case'touchstart':this.press();break;case'touchend':this.release();break;case'edge-touch-redispatch':this.handleRedispatchedTouch(evt);break;case'homegesture-disabled':if(!this.hasHardwareHomeButton&&!this.enabled){SettingsListener.getSettingsLock().set({'software-button.enabled':true});}
break;case'homegesture-enabled':if(this.enabled){SettingsListener.getSettingsLock().set({'software-button.enabled':false});}
break;case'mozfullscreenchange':if(!this.enabled){return;}
window.clearTimeout(this._fullscreenTimerId);this._fullscreenTimerId=0;if(document.mozFullScreenElement){this.fullscreenLayoutElement.classList.add('hidden');this._fullscreenElement=document.mozFullScreenElement;this._fullscreenElement.addEventListener('touchstart',this._fullscreenTapFunction);this._fullscreenElement.addEventListener('touchend',this._fullscreenTapFunction);}else if(this._fullscreenElement){this.fullscreenLayoutElement.classList.remove('hidden');this._fullscreenElement.removeEventListener('touchstart',this._fullscreenTapFunction);this._fullscreenElement.removeEventListener('touchend',this._fullscreenTapFunction);this._fullscreenElement=null;}
this._updateButtonRect();break;case'mozorientationchange':var isPortrait=this._currentOrientation.contains('portrait');var newOrientation=OrientationManager.fetchCurrentOrientation();if(isPortrait&&newOrientation.contains('landscape')){this.element.style.right=this.element.style.bottom;this.element.style.bottom=null;}else if(!isPortrait&&newOrientation.contains('portrait')){this.element.style.bottom=this.element.style.right;this.element.style.right=null;}
this._currentOrientation=newOrientation;this.element.classList.add('no-transition');break;case'orientationchange':this.element.classList.remove('no-transition');break;case'hierachychanged':if(this.enabled&&Service.query('getTopMostWindow')){this.element.classList.toggle('attention-lockscreen',Service.query('getTopMostWindow').CLASS_NAME==='LockScreenWindow');}
break;}},_preventFocus:function(evt){evt.preventDefault();},_fullscreenTimerId:0,_fullscreenElement:null,_fullscreenTouchStart:null,_fullscreenTapFunction:function(evt){switch(evt.type){case'touchstart':this._fullscreenTouchStart=evt.touches[0];break;case'touchend':var touch=evt.changedTouches[0];var xDistance=Math.abs(touch.pageX-this._fullscreenTouchStart.pageX);var yDistance=Math.abs(touch.pageY-this._fullscreenTouchStart.pageY);var swipeThreshold=10;if(xDistance<swipeThreshold&&yDistance<swipeThreshold){window.clearTimeout(this._fullscreenTimerId);if(this.fullscreenLayoutElement.classList.contains('hidden')){this.fullscreenLayoutElement.classList.remove('hidden');this._fullscreenTimerId=window.setTimeout(function sbm_fullscreenHideTimer(){this.fullscreenLayoutElement.classList.add('hidden');}.bind(this),3000);}else{this._fullscreenTimerId=window.setTimeout(function sbm_fullscreenHideTimer(){this.fullscreenLayoutElement.classList.add('hidden');}.bind(this),100);}}
break;}},press:function(){this.homeButtons.forEach(function sbm_addActive(b){b.classList.add('active');});this.publish('home-button-press');},release:function(){this.homeButtons.forEach(function sbm_removeActive(b){b.classList.remove('active');});this.publish('home-button-release');},_pressedByRedispatch:false,handleRedispatchedTouch:function(evt){var type=evt.detail.type;if(!this._onButton(evt)){if(type!=='touchstart'&&this._pressedByRedispatch){this._pressedByRedispatch=false;this.release();}
return;}
evt.preventDefault();switch(type){case'touchstart':this.press();this._pressedByRedispatch=true;break;case'touchend':this._pressedByRedispatch=false;this.release();break;}},_onButton:function(e){var type=e.detail.type;var touch=(type==='touchend')?e.detail.changedTouches[0]:e.detail.touches[0];var x=touch.pageX;var y=touch.pageY;var radius=4;var rect=this._buttonRect;var leftBound=rect.left-radius;var rightBound=rect.right+radius;var topBound=rect.top-radius;var bottomBound=rect.bottom+radius;return(x>=leftBound&&x<=rightBound&&y>=topBound&&y<=bottomBound);}};exports.SoftwareButtonManager=SoftwareButtonManager;}(window));;'use strict';var FtuLauncher={_ftu:null,_ftuManifestURL:'',_ftuOrigin:'',_ftuPing:null,_isRunningFirstTime:false,_isUpgrading:false,_bypassHomeEvent:false,isFtuRunning:function fl_isFtuRunning(){return this._isRunningFirstTime;},isFtuUpgrading:function fl_isFtuUpgrading(){return this._isUpgrading;},getFtuOrigin:function fl_getFtuOrigin(){return this._ftuOrigin;},getFtuPing:function fl_getFtuPing(){return this._ftuPing;},setBypassHome:function fl_setBypassHome(value){this._bypassHomeEvent=value;},init:function fl_init(){window.addEventListener('iac-ftucomms',this);window.addEventListener('appterminated',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('appopened',this);Service.registerState('isFtuUpgrading',this);Service.registerState('isFtuRunning',this);},_handle_home:function(){if(this._isRunningFirstTime){if(!this._bypassHomeEvent){return false;}else{var killEvent=document.createEvent('CustomEvent');killEvent.initCustomEvent('killapp',true,false,{origin:this._ftuOrigin});window.dispatchEvent(killEvent);}}
return true;},_handle_holdhome:function(){if(this._isRunningFirstTime){return false;}
return true;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;},handleEvent:function fl_init(evt){switch(evt.type){case'appopened':if(evt.detail.origin==this._ftuOrigin&&this._isRunningFirstTime){var ftuopenEvt=document.createEvent('CustomEvent');ftuopenEvt.initCustomEvent('ftuopen',true,false,{});window.dispatchEvent(ftuopenEvt);}
break;case'iac-ftucomms':var message=evt.detail;if(message==='done'){this.setBypassHome(true);}
break;case'appterminated':if(evt.detail.origin==this._ftuOrigin){this.close();}
break;}},close:function fl_close(){this._isRunningFirstTime=false;this._isUpgrading=false;window.asyncStorage.setItem('ftu.enabled',false);VersionHelper.updatePrevious();var evt=document.createEvent('CustomEvent');evt.initCustomEvent('ftudone',true,false,{});window.dispatchEvent(evt);},launch:function fl_launch(){var self=this;var req=navigator.mozSettings.createLock().get('ftu.manifestURL');req.onsuccess=function(){var manifestURL=req.result['ftu.manifestURL'];self._ftuManifestURL=manifestURL;if(!manifestURL){dump('FTU manifest cannot be found, skipping.\n');self.skip();return;}
var ftu=self._ftu=applications.getByManifestURL(manifestURL);if(!ftu){dump('Opps, bogus FTU manifest.\n');self.skip();return;}
self._isRunningFirstTime=true;self._ftuOrigin=ftu.origin;ftu.launch();};req.onerror=function(){dump('Couldn\'t get the ftu manifestURL.\n');self.skip();};},skip:function fl_skip(){this._isRunningFirstTime=false;this._isUpgrading=false;var evt=document.createEvent('CustomEvent');evt.initCustomEvent('ftuskip',true,false,{});window.dispatchEvent(evt);},retrieve:function fl_retrieve(){var self=this;if(!this._ftuPing){this._ftuPing=new FtuPing();}
this._ftuPing.ensurePing();VersionHelper.getVersionInfo().then(function(versionInfo){if(versionInfo.isUpgrade()){self._isUpgrading=true;self.launch();}else{window.asyncStorage.getItem('ftu.enabled',function getItem(shouldFTU){self._isUpgrading=false;if(shouldFTU!==false){self.launch();}else{self.skip();}});}},function(err){dump('VersionHelper failed to lookup version settings, skipping.\n');self.skip();});}};FtuLauncher.init();;(function(){var _global=this;var mathRNG,nodeRNG,whatwgRNG;var _rndBytes=new Array(16);mathRNG=function(){var r,b=_rndBytes,i=0;for(var i=0,r;i<16;i++){if((i&0x03)==0)r=Math.random()*0x100000000;b[i]=r>>>((i&0x03)<<3)&0xff;}
return b;}
try{var _rb=require('crypto').randomBytes;nodeRNG=_rb&&function(){return _rb(16);};}catch(e){}
var _rng=nodeRNG||whatwgRNG||mathRNG;var BufferClass=typeof(Buffer)=='function'?Buffer:Array;var _byteToHex=[];var _hexToByte={};for(var i=0;i<256;i++){_byteToHex[i]=(i+0x100).toString(16).substr(1);_hexToByte[_byteToHex[i]]=i;}
function parse(s,buf,offset){var i=(buf&&offset)||0,ii=0;buf=buf||[];s.toLowerCase().replace(/[0-9a-f]{2}/g,function(oct){if(ii<16){buf[i+ii++]=_hexToByte[oct];}});while(ii<16){buf[i+ii++]=0;}
return buf;}
function unparse(buf,offset){var i=offset||0,bth=_byteToHex;return bth[buf[i++]]+bth[buf[i++]]+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+'-'+
bth[buf[i++]]+bth[buf[i++]]+
bth[buf[i++]]+bth[buf[i++]]+
bth[buf[i++]]+bth[buf[i++]];}
var _seedBytes=_rng();var _nodeId=[_seedBytes[0]|0x01,_seedBytes[1],_seedBytes[2],_seedBytes[3],_seedBytes[4],_seedBytes[5]];var _clockseq=(_seedBytes[6]<<8|_seedBytes[7])&0x3fff;var _lastMSecs=0,_lastNSecs=0;function v1(options,buf,offset){var i=buf&&offset||0;var b=buf||[];options=options||{};var clockseq=options.clockseq!=null?options.clockseq:_clockseq;var msecs=options.msecs!=null?options.msecs:new Date().getTime();var nsecs=options.nsecs!=null?options.nsecs:_lastNSecs+1;var dt=(msecs-_lastMSecs)+(nsecs-_lastNSecs)/10000;if(dt<0&&options.clockseq==null){clockseq=clockseq+1&0x3fff;}
if((dt<0||msecs>_lastMSecs)&&options.nsecs==null){nsecs=0;}
if(nsecs>=10000){throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');}
_lastMSecs=msecs;_lastNSecs=nsecs;_clockseq=clockseq;msecs+=12219292800000;var tl=((msecs&0xfffffff)*10000+nsecs)%0x100000000;b[i++]=tl>>>24&0xff;b[i++]=tl>>>16&0xff;b[i++]=tl>>>8&0xff;b[i++]=tl&0xff;var tmh=(msecs/0x100000000*10000)&0xfffffff;b[i++]=tmh>>>8&0xff;b[i++]=tmh&0xff;b[i++]=tmh>>>24&0xf|0x10;b[i++]=tmh>>>16&0xff;b[i++]=clockseq>>>8|0x80;b[i++]=clockseq&0xff;var node=options.node||_nodeId;for(var n=0;n<6;n++){b[i+n]=node[n];}
return buf?buf:unparse(b);}
function v4(options,buf,offset){var i=buf&&offset||0;if(typeof(options)=='string'){buf=options=='binary'?new BufferClass(16):null;options=null;}
options=options||{};var rnds=options.random||(options.rng||_rng)();rnds[6]=(rnds[6]&0x0f)|0x40;rnds[8]=(rnds[8]&0x3f)|0x80;if(buf){for(var ii=0;ii<16;ii++){buf[i+ii]=rnds[ii];}}
return buf||unparse(rnds);}
var uuid=v4;uuid.v1=v1;uuid.v4=v4;uuid.parse=parse;uuid.unparse=unparse;uuid.BufferClass=BufferClass;uuid.mathRNG=mathRNG;uuid.nodeRNG=nodeRNG;uuid.whatwgRNG=whatwgRNG;if(typeof(module)!='undefined'){module.exports=uuid;}else{var _previousRoot=_global.uuid;uuid.noConflict=function(){_global.uuid=_previousRoot;return uuid;}
_global.uuid=uuid;}}());;'use strict';(function(exports){const DEFAULT_URL='https://fxos.telemetry.mozilla.org/submit/telemetry';const DEFAULT_APPNAME='FirefoxOS';const UNKNOWN='unknown';const TR=TelemetryRequest;TR.DEBUG=false;function TelemetryRequest(args,info){if(!args){throw new Error('No arguments');}
if(!args.reason){throw new Error('No reason given');}
if(!args.deviceID){throw new Error('No deviceID given');}
this.info=info?JSON.parse(JSON.stringify(info)):{};this.packet={ver:args.ver||1,info:this.info};this.info.reason=args.reason;this.info.appName=args.appName||DEFAULT_APPNAME;this.info.appUpdateChannel=args.appUpdateChannel||UNKNOWN;this.info.appBuildID=args.appBuildID||UNKNOWN;this.info.appVersion=args.appVersion||UNKNOWN;var uriParts=[args.url||DEFAULT_URL,encodeURIComponent(args.deviceID),encodeURIComponent(this.info.reason),encodeURIComponent(this.info.appName),encodeURIComponent(this.info.appVersion),encodeURIComponent(this.info.appUpdateChannel),encodeURIComponent(this.info.appBuildID)];this.url=uriParts.join('/');}
function debug(...args){if(TR.DEBUG){args.unshift('[Telemetry]');console.log.apply(console,args);}}
TelemetryRequest.prototype.send=function(xhrAttrs){var xhr=new XMLHttpRequest({mozSystem:true,mozAnon:true});xhr.open('POST',this.url);debug(this.url);if(xhrAttrs&&xhrAttrs.timeout){xhr.timeout=xhrAttrs.timeout;}
xhr.setRequestHeader('Content-type','application/json');xhr.responseType='text';var data=JSON.stringify(this.packet);xhr.send(data);debug(data);if(xhrAttrs){xhr.onload=xhrAttrs.onload;xhr.onerror=xhrAttrs.onerror;xhr.onabort=xhrAttrs.onabort;xhr.ontimeout=xhrAttrs.ontimeout;}
return xhr;};exports.TelemetryRequest=TelemetryRequest;}(window));;'use strict';(function(exports){var DEBUG=false;const FTU_PING_ACTIVATION='ftu.pingActivation';const FTU_PING_ENABLED='ftu.pingEnabled';const FTU_PING_ID='ftu.pingID';const FTU_PING_MAX_NETWORK_FAILS='ftu.pingMaxNetworkFails';const FTU_PING_NETWORK_FAIL_COUNT='ftu.pingNetworkFailCount';const FTU_PING_URL='ftu.pingURL';const FTU_PING_TIMEOUT='ftu.pingTimeout';const FTU_PING_TRY_INTERVAL='ftu.pingTryInterval';const DEFAULT_TRY_INTERVAL=60*60*1000;const DEFAULT_MAX_NETWORK_FAILS=24;const DEFAULT_PING_TIMEOUT=60*1000;const TELEMETRY_VERSION=1;const TELEMETRY_REASON='ftu';const OBSERVE_SETTINGS=['deviceinfo.os','deviceinfo.software','deviceinfo.product_model','deviceinfo.firmware_revision','deviceinfo.hardware'];const URL_SETTINGS=['deviceinfo.platform_build_id','deviceinfo.platform_version','app.update.channel'];function FtuPing(){}
FtuPing.prototype={_pingReady:false,_pingReadyCallback:null,_pingTimer:null,_tryInterval:DEFAULT_TRY_INTERVAL,_pingURL:null,_pingEnabled:true,_maxNetworkFails:DEFAULT_MAX_NETWORK_FAILS,_networkFailCount:0,_pingData:{},_infoData:{},_pingTimeout:DEFAULT_PING_TIMEOUT,_settingObserver:null,debug:function fp_debug(msg){if(DEBUG){dump('[FtuPing] '+msg+'\n');}},reset:function fp_reset(){this._pingReady=false;this._pingReadyCallback=null;this._pingTimer=null;this._tryInterval=DEFAULT_TRY_INTERVAL;this._pingTimeout=DEFAULT_PING_TIMEOUT;this._settingObserver=null;this._pingURL=null;this._pingEnabled=true;this._maxNetworkFails=DEFAULT_MAX_NETWORK_FAILS;this._networkFailCount=0;this._pingData={};},initSettings:function fp_initSettings(){var self=this;return new Promise(function(resolve,reject){self.reset();self._pingData.screenHeight=window.screen.height;self._pingData.screenWidth=window.screen.width;self._pingData.devicePixelRatio=window.devicePixelRatio;self._pingData.locale=window.navigator.language;self.getAsyncStorageItems([FTU_PING_ID,FTU_PING_ACTIVATION,FTU_PING_ENABLED,FTU_PING_NETWORK_FAIL_COUNT],function(items){self._pingData.pingID=items[FTU_PING_ID];self._pingData.activationTime=items[FTU_PING_ACTIVATION];self._pingEnabled=items[FTU_PING_ENABLED];if(!self._pingData.pingID){self._pingData.pingID=uuid();window.asyncStorage.setItem(FTU_PING_ID,self._pingData.pingID);}
if(!self._pingData.activationTime){self._pingData.activationTime=Date.now();window.asyncStorage.setItem(FTU_PING_ACTIVATION,self._pingData.activationTime);}
if(self._pingEnabled===null){self._pingEnabled=true;}
if(typeof(items[FTU_PING_NETWORK_FAIL_COUNT])==='number'){self._networkFailCount=items[FTU_PING_NETWORK_FAIL_COUNT];}
var allSettings=[FTU_PING_URL,FTU_PING_TRY_INTERVAL,FTU_PING_TIMEOUT,FTU_PING_MAX_NETWORK_FAILS].concat(OBSERVE_SETTINGS);allSettings=allSettings.concat(URL_SETTINGS);self.getSettings(allSettings,function(settings){self._pingURL=settings[FTU_PING_URL];self._tryInterval=settings[FTU_PING_TRY_INTERVAL]||self._tryInterval;self._pingTimeout=settings[FTU_PING_TIMEOUT]||self._pingTimeout;self._maxNetworkFails=settings[FTU_PING_MAX_NETWORK_FAILS]||self._maxNetworkFails;var mozSettings=window.navigator.mozSettings;if(!self._settingObserver){self._settingObserver=self.onSettingChanged.bind(self);}
OBSERVE_SETTINGS.forEach(function(observeSetting){self._pingData[observeSetting]=settings[observeSetting];mozSettings.addObserver(observeSetting,self._settingObserver);});URL_SETTINGS.forEach(function(urlSetting){self._infoData[urlSetting]=settings[urlSetting];mozSettings.addObserver(urlSetting,self._settingObserver);});resolve();});});});},initPreinstalledApps:function fp_initPreinstalledApps(callback){var preinstalled=this._pingData.preinstalled={};var self=this;return new Promise(function(resolve,reject){window.navigator.mozApps.mgmt.getAll().onsuccess=function(evt){var apps=evt.target.result;apps.forEach(function(app){var url;try{url=new URL(app.manifestURL);}catch(e){}
if(!url||url.hostname.indexOf('gaiamobile.org')===-1){preinstalled[app.manifestURL]=app.manifest.name;}});self.debug(self._pingData.preinstalled);resolve();};});},getAsyncStorageItems:function fp_getAsyncStorageItems(itemKeys,callback){var itemsLeft=itemKeys.length;var items={};itemKeys.forEach(function(key){window.asyncStorage.getItem(key,function(value){itemsLeft--;items[key]=value;if(itemsLeft===0&&callback){callback(items);}});});},getSettings:function fp_getSettings(settingKeys,callback){var settingsLeft=settingKeys.length;var settings={};var lock=window.navigator.mozSettings.createLock();settingKeys.forEach(function(key){var request=lock.get(key);request.onsuccess=function(evt){var value=request.result[key];settingsLeft--;settings[key]=value;if(settingsLeft===0&&callback){callback(settings);}};});},ensurePing:function fp_ensurePing(){var initPromises=[this.initSettings(),this.initPreinstalledApps()];Promise.all(initPromises).then(this.startPing.bind(this));},onSettingChanged:function fp_onSettingChanged(evt){this._pingData[evt.settingName]=evt.settingValue;},startPing:function fp_startPing(){if(this._pingEnabled===false){this.debug('FTU ping disabled');return;}
if(!this._pingURL){this.debug('No FTU ping URL');return;}
if(this._pingTimer!==null){return;}
this.debug('Starting FTU ping');this._pingTimer=setInterval(this.tryPing.bind(this),this._tryInterval);},maybeThrowNetworkFailure:function fp_maybeThrowNetworkFailure(message){this._networkFailCount++;window.asyncStorage.setItem(FTU_PING_NETWORK_FAIL_COUNT,this._networkFailCount);if(this._networkFailCount<this._maxNetworkFails){throw message+' ('+this._networkFailCount+' of '+
this._maxNetworkFails+' failures)';}else{this.debug('Warning: '+message);}},checkMobileNetwork:function fp_checkMobileNetwork(){if(SIMSlotManager.noSIMCardConnectedToNetwork()){this.maybeThrowNetworkFailure('No SIM cards connected to a network');}
var conns=window.navigator.mozMobileConnections;if(!conns||conns.length===0){this.maybeThrowNetworkFailure('No mobile connections');return;}
var slots=SIMSlotManager.getSlots().filter(function(slot){return!slot.isAbsent()&&!slot.isLocked();});if(slots.length===0){this.maybeThrowNetworkFailure('No unlocked or active SIM cards found');return;}
var conn=slots[0].conn;var iccObj=navigator.mozIccManager.getIccById(conn.iccId);var iccInfo=iccObj?iccObj.iccInfo:null;var voiceNetwork=conn.voice?conn.voice.network:null;if(!iccInfo&&!voiceNetwork){this.maybeThrowNetworkFailure('No voice network or ICC info');return;}
this._pingData.network=MobileOperator.userFacingInfo(conn);if(voiceNetwork){this._pingData.network.mnc=voiceNetwork.mnc;this._pingData.network.mcc=voiceNetwork.mcc;}
if(iccInfo){this._pingData.icc={mnc:iccInfo.mnc,mcc:iccInfo.mcc,spn:iccInfo.spn};}},tryPing:function fp_tryPing(){try{this.checkMobileNetwork();if(this._networkFailCount>=this._maxNetworkFails){this.debug('Max voice network failures reached, pinging anyway!');if(this._pingData.network===undefined){this._pingData.network=null;}
if(this._pingData.icc===undefined){this._pingData.icc=null;}}
if(!this._pingData['deviceinfo.os']){this.debug('No OS information, holding off');return false;}
this.ping();return true;}catch(e){this.debug('Error while trying FTU ping: '+e);return false;}},ping:function fp_ping(){this._pingData.pingTime=Date.now();var request=new TelemetryRequest({reason:TELEMETRY_REASON,deviceID:this._pingData.pingID,ver:TELEMETRY_VERSION,url:this._pingURL,appUpdateChannel:this._infoData['app.update.channel'],appVersion:this._infoData['deviceinfo.platform_version'],appBuildID:this._infoData['deviceinfo.platform_build_id']},this._pingData);var self=this;request.send({timeout:this._pingTimeout,onload:function(){self.pingSuccess(this.responseText);},ontimeout:function(){self.pingError('Timed out');},onerror:function(){self.pingError(this.statusText);}});},pingSuccess:function fp_pingSuccess(result){if(result!=='OK'){this.debug('Ping response unexpected: '+result);return;}
this._pingEnabled=false;window.asyncStorage.setItem(FTU_PING_ENABLED,false);var settings=window.navigator.mozSettings;OBSERVE_SETTINGS.forEach(function(setting){settings.removeObserver(setting,this._settingObserver);},this);URL_SETTINGS.forEach(function(setting){settings.removeObserver(setting,this._settingObserver);},this);clearInterval(this._pingTimer);},pingError:function fp_pingError(message){this.debug('Ping error: '+message);},isEnabled:function fp_isEnabled(){return this._pingEnabled;},getPingURL:function fp_getPingURL(){return this._pingURL;},getPingData:function fp_getPingData(){return this._pingData;},getInfoData:function fp_getInfoData(){return this._infoData;},getNetworkFailCount:function fp_getNetworkFailCount(){return this._networkFailCount;},getTryInterval:function fp_getTryInterval(){return this._tryInterval;},getPingTimeout:function fp_getPingTimeout(){return this._pingTimeout;},getMaxNetworkFails:function fp_getMaxNetworkFails(){return this._maxNetworkFails;}};exports.FtuPing=FtuPing;}(window));;(function(exports){'use strict';const PERSISTENCE_KEY='metrics.app_usage.data.v2';const DEVICE_ID_KEY='metrics.app_usage.deviceID.v2';const APPOPENED='appopened';const HOMESCREEN='homescreenopened';const ACTIVITY='activitycreated';const LOCKED='lockscreen-appopened';const UNLOCKED='lockscreen-appclosed';const SCREENCHANGE='screenchange';const INSTALL='applicationinstall';const UNINSTALL='applicationuninstall';const ONLINE='online';const OFFLINE='offline';const TIMECHANGE='moztimechange';const ATTENTIONOPENED='attentionopened';const ATTENTIONCLOSED='attentionclosed';const IDLE='idle';const ACTIVE='active';const IACMETRICS='iac-app-metrics';const EVENT_TYPES=[APPOPENED,HOMESCREEN,ACTIVITY,LOCKED,UNLOCKED,SCREENCHANGE,INSTALL,UNINSTALL,ONLINE,OFFLINE,TIMECHANGE,ATTENTIONOPENED,ATTENTIONCLOSED,IACMETRICS];const MARKETPLACE_ORIGINS=['https://marketplace.firefox.com'];function AppUsageMetrics(){}
const AUM=AppUsageMetrics;AUM.UsageData=UsageData;AUM.DEBUG=false;function debug(...args){if(AUM.DEBUG){args.unshift('[AppUsage]');console.log.apply(console,args);}}
AUM.TELEMETRY_ENABLED_KEY='debug.performance_data.shared';AUM.REPORT_URL='https://fxos.telemetry.mozilla.org/submit/telemetry';AUM.REPORT_INTERVAL=14*24*60*60*1000;AUM.REPORT_TIMEOUT=20*1000;AUM.RETRY_INTERVAL=60*60*1000;AUM.IDLE_TIME=5;AUM.TELEMETRY_VERSION=1;AUM.TELEMETRY_REASON='appusage';AUM.TELEMETRY_APP_NAME='FirefoxOS';AUM.prototype.start=function start(){this.reset();this.metricsEnabledListener=function metricsEnabledListener(enabled){if(enabled){this.startCollecting();}
else{this.stopCollecting();}}.bind(this);SettingsListener.observe(AUM.TELEMETRY_ENABLED_KEY,false,this.metricsEnabledListener);};AUM.prototype.stop=function stop(){this.stopCollecting();SettingsListener.unobserve(AUM.TELEMETRY_ENABLED_KEY,this.metricsEnabledListener);};AUM.prototype.reset=function(){this.collecting=false;this.metrics=null;this.deviceID=null;this.idle=false;this.locked=false;this.lockscreenApp=null;this.attentionWindows=[];this.lastFailedTransmission=0;this.currentApp=null;this.currentAppStartTime=performance.now();};AUM.prototype.getTopAttentionWindow=function getTopAttentionWindow(){return this.attentionWindows?this.attentionWindows[this.attentionWindows.length-1]:undefined;};AUM.prototype.getCurrentApp=function(){return!this.attentionWindows||this.attentionWindows.length===0?this.currentApp:this.getTopAttentionWindow().app;};AUM.prototype.getCurrentStartTime=function(){return!this.attentionWindows||this.attentionWindows.length===0?this.currentAppStartTime:this.getTopAttentionWindow().startTime;};AUM.prototype.setCurrentStartTime=function(time){if(!this.attentionWindows||this.attentionWindows.length===0){this.currentAppStartTime=time;}else{this.getTopAttentionWindow().startTime=time;}};AUM.prototype.startCollecting=function startCollecting(done){var self=this;debug('starting app usage metrics collection');if(this.collecting){return;}
this.collecting=true;loadData();function loadData(){UsageData.load(function(loadedMetrics){self.metrics=loadedMetrics;getDeviceID();});}
function getDeviceID(){asyncStorage.getItem(DEVICE_ID_KEY,function(value){if(value){self.deviceID=value;}
else{self.deviceID=uuid();asyncStorage.setItem(DEVICE_ID_KEY,self.deviceID);}
getConfigurationSettings();});}
function getConfigurationSettings(){var query={'ftu.pingURL':AUM.REPORT_URL,'metrics.appusage.reportURL':null,'metrics.appusage.reportInterval':AUM.REPORT_INTERVAL,'metrics.appusage.reportTimeout':AUM.REPORT_TIMEOUT,'metrics.appusage.retryInterval':AUM.RETRY_INTERVAL};AUM.getSettings(query,function(result){AUM.REPORT_URL=result['metrics.appusage.reportURL']||result['ftu.pingURL'];AUM.REPORT_INTERVAL=result['metrics.appusage.reportInterval'];AUM.REPORT_TIMEOUT=result['metrics.appusage.reportTimeout'];AUM.RETRY_INTERVAL=result['metrics.appusage.retryInterval'];waitForApplicationsReady();});}
function waitForApplicationsReady(){if(applications.ready){registerHandlers();return;}
debug('Waiting for applications to be ready');window.addEventListener('applicationready',function onAppsReady(evt){window.removeEventListener(onAppsReady);registerHandlers();});}
function registerHandlers(){EVENT_TYPES.forEach(function(type){window.addEventListener(type,self);});self.idleObserver={time:AUM.IDLE_TIME,onidle:function(){self.handleEvent(new CustomEvent(IDLE));},onactive:function(){self.handleEvent(new CustomEvent(ACTIVE));}};navigator.addIdleObserver(self.idleObserver);if(done){done();}}};AUM.prototype.stopCollecting=function stopCollecting(){debug('stopping app usage data collection and deleting stored data');if(!this.collecting){return;}
this.collecting=false;asyncStorage.removeItem(PERSISTENCE_KEY);asyncStorage.removeItem(DEVICE_ID_KEY);navigator.removeIdleObserver(this.idleObserver);this.idleObserver=null;var self=this;EVENT_TYPES.forEach(function(type){window.removeEventListener(type,self);});this.reset();};AUM.prototype.handleEvent=function handleEvent(e){var now=performance.now();debug('got an event: ',e.type);switch(e.type){case APPOPENED:case HOMESCREEN:this.metrics.recordInvocation(this.getCurrentApp(),now-this.getCurrentStartTime());this.attentionWindows=[];this.currentApp=e.detail;this.currentAppStartTime=now;break;case ATTENTIONOPENED:this.metrics.recordInvocation(this.getCurrentApp(),now-this.getCurrentStartTime());this.attentionWindows.push({app:e.detail,startTime:now});break;case ACTIVITY:this.metrics.recordActivity(this.currentApp,e.detail.url);break;case LOCKED:this.metrics.recordInvocation(this.getCurrentApp(),now-this.getCurrentStartTime());this.setCurrentStartTime(now);this.locked=true;this.lockscreenApp=e.detail;break;case UNLOCKED:if(this.locked&&this.lockscreenApp){this.metrics.recordInvocation(this.lockscreenApp,now-this.currentAppStartTime);this.setCurrentStartTime(now);}
this.locked=false;break;case SCREENCHANGE:if(e.detail.screenOffBy==='proximity'){return;}
if(e.detail.screenEnabled){this.setCurrentStartTime(now);}
else{var app=this.locked?this.lockscreenApp:this.getCurrentApp();this.metrics.recordInvocation(app,now-this.getCurrentStartTime());}
break;case ATTENTIONCLOSED:var attentionWindow=this.getTopAttentionWindow();if(attentionWindow&&attentionWindow.app&&attentionWindow.app.manifestURL===e.detail.manifestURL){this.metrics.recordInvocation(e.detail,now-attentionWindow.startTime);this.attentionWindows.pop();}else{debug('Unexpected attention window closed! '+e.detail.manifestURL);}
this.setCurrentStartTime(now);break;case INSTALL:this.metrics.recordInstall(e.detail.application);break;case UNINSTALL:this.metrics.recordUninstall(e.detail.application);break;case IDLE:this.idle=true;break;case ACTIVE:this.idle=false;break;case TIMECHANGE:if(this.metrics.relativeStartTime!==undefined){var deltaT=performance.now()-this.metrics.relativeStartTime;var oldStartTime=this.metrics.data.start;var newStartTime=Date.now()-Math.round(deltaT);this.metrics.data.start=newStartTime;this.metrics.save(true);debug('System time change; converted batch start time from:',new Date(oldStartTime).toString(),'to:',new Date(newStartTime).toString());}
break;case IACMETRICS:if(e.detail.action==='websearch'){debug('got a search event for provider: ',e.detail.data);this.metrics.recordSearch(e.detail.data);}
break;}
if(this.idle){this.metrics.save();}
if(!this.metrics.isEmpty()&&this.idle&&navigator.onLine){var absoluteTime=Date.now();if(this.lastFailedTransmission>this.metrics.startTime()){if(absoluteTime-this.lastFailedTransmission>AUM.RETRY_INTERVAL){this.transmit();}}
else if(absoluteTime-this.metrics.startTime()>AUM.REPORT_INTERVAL){this.transmit();}}};AUM.prototype.transmit=function transmit(){var self=this;if(!this.collecting){return;}
var data=JSON.parse(JSON.stringify(this.metrics.data));var oldMetrics=this.metrics;this.metrics=new UsageData();this.metrics.save(true);data.stop=Date.now();data.deviceID=this.deviceID;data.locale=navigator.language;data.screen={width:screen.width,height:screen.height,devicePixelRatio:window.devicePixelRatio};var deviceInfoQuery={'developer.menu.enabled':false,'deviceinfo.hardware':'unknown','deviceinfo.os':'unknown','deviceinfo.product_model':'unknown','deviceinfo.software':'unknown'};var urlInfoQuery={'deviceinfo.platform_build_id':'unknown','deviceinfo.platform_version':'unknown','app.update.channel':'unknown'};AUM.getSettings(deviceInfoQuery,function(deviceInfo){data.deviceinfo=deviceInfo;data.simInfo=getSIMInfo();});AUM.getSettings(urlInfoQuery,function(urlInfoResponse){send(data,urlInfoResponse);});function getSIMInfo(){var simInfo={network:null,icc:null};if(SIMSlotManager.noSIMCardConnectedToNetwork()){return simInfo;}
var slots=SIMSlotManager.getSlots().filter(function(slot){return!slot.isAbsent()&&!slot.isLocked();});if(slots.length===0){return simInfo;}
var conn=slots[0].conn;if(!conn){return simInfo;}
var iccObj=navigator.mozIccManager.getIccById(conn.iccId);var iccInfo=iccObj?iccObj.iccInfo:null;var voiceNetwork=conn.voice?conn.voice.network:null;if(!iccInfo&&!voiceNetwork){return simInfo;}
simInfo.network=MobileOperator.userFacingInfo(conn);if(voiceNetwork){simInfo.network.mnc=voiceNetwork.mnc;simInfo.network.mcc=voiceNetwork.mcc;}
if(iccInfo){simInfo.icc={mnc:iccInfo.mnc,mcc:iccInfo.mcc,spn:iccInfo.spn};}
return simInfo;}
function send(data,urlInfo){var request=new TelemetryRequest({reason:AUM.TELEMETRY_REASON,deviceID:self.deviceID,ver:AUM.TELEMETRY_VERSION,url:AUM.REPORT_URL,appUpdateChannel:urlInfo['app.update.channel'],appVersion:urlInfo['deviceinfo.platform_version'],appBuildID:urlInfo['deviceinfo.platform_build_id']},data);function onload(){debug('Transmitted app usage data to',request.url);}
function retry(e){debug('App usage metrics transmission failure:',e.type);self.lastFailedTransmission=Date.now();oldMetrics.merge(self.metrics);self.metrics=oldMetrics;self.metrics.save(true);}
request.send({timeout:AUM.REPORT_TIMEOUT,onload:onload,onerror:retry,onabort:retry,ontimeout:retry});}};function UsageData(){this.data={start:Date.now(),apps:{},searches:{}};this.needsSave=false;this.relativeStartTime=performance.now();}
UsageData.prototype.getAppUsage=function(manifestURL,dayKey){var usage=this.data.apps[manifestURL];dayKey=dayKey||this.getDayKey();if(!usage){this.data.apps[manifestURL]=usage={};}
var dayUsage=usage[dayKey];if(!dayUsage){dayUsage=usage[dayKey]={usageTime:0,invocations:0,installs:0,uninstalls:0,activities:{}};this.data.apps[manifestURL]=usage;}
return dayUsage;};UsageData.prototype.getDayKey=function(date){date=date||new Date();var dayKey=date.toISOString().substring(0,10);return dayKey.replace(/-/g,'');};UsageData.prototype.getSearchCounts=function(provider){var search=this.data.searches[provider];var dayKey=this.getDayKey();if(!search){this.data.searches[provider]=search={};debug('creating new object for provider',provider);}
var daySearch=search[dayKey];if(!daySearch){daySearch=search[dayKey]={count:0};}
return daySearch;};UsageData.prototype.startTime=function(){return this.data.start;};UsageData.prototype.isEmpty=function(){return Object.keys(this.data.apps).length===0;};UsageData.prototype.shouldTrackApp=function(app){if(!app){return false;}
if(typeof app.isPrivateBrowser==='function'&&app.isPrivateBrowser()){return false;}
var cachedApp=applications.getByManifestURL(app.manifestURL);var manifest=app.manifest||app.updateManifest;if(!manifest&&cachedApp){manifest=cachedApp.manifest||cachedApp.updateManifest;}
var installOrigin=app.installOrigin;if(!installOrigin&&cachedApp){installOrigin=cachedApp.installOrigin;}
var type=manifest?manifest.type:'unknown';if(type==='certified'){return true;}
if(MARKETPLACE_ORIGINS.indexOf(installOrigin)>=0){return true;}
try{var url=new URL(app.manifestURL);return url.hostname.indexOf('gaiamobile.org')>=0;}catch(e){return false;}};UsageData.prototype.recordInvocation=function(app,time){if(!this.shouldTrackApp(app)){return false;}
time=Math.round(time/1000);if(time>0){var usage=this.getAppUsage(app.manifestURL);usage.invocations++;usage.usageTime+=time;this.needsSave=true;debug(app,'ran for',time);}
return time>0;};UsageData.prototype.recordSearch=function(provider){debug('recordSearch',provider);if(provider==null){return;}
if(navigator.onLine){var search=this.getSearchCounts(provider);search.count++;debug('Search Count for: '+provider+': ',search.count);this.needsSave=true;}};UsageData.prototype.recordInstall=function(app){if(!this.shouldTrackApp(app)){return false;}
var usage=this.getAppUsage(app.manifestURL);usage.installs++;this.needsSave=true;debug(app,'installed');return true;};UsageData.prototype.recordUninstall=function(app){if(!this.shouldTrackApp(app)){return false;}
var usage=this.getAppUsage(app.manifestURL);usage.uninstalls++;this.needsSave=true;debug(app,'uninstalled');return true;};UsageData.prototype.recordActivity=function(app,url){if(!this.shouldTrackApp(app)){return false;}
var usage=this.getAppUsage(app.manifestURL);var count=usage.activities[url]||0;usage.activities[url]=++count;this.needsSave=true;debug(app,'invoked activity',url);return true;};UsageData.prototype.merge=function(newbatch){if(!newbatch||newbatch.isEmpty()){return;}
for(var app in newbatch.data.apps){var newdays=newbatch.data.apps[app];for(var day in newdays){var newusage=newdays[day];var oldusage=this.getAppUsage(app,day);oldusage.usageTime+=newusage.usageTime;oldusage.invocations+=newusage.invocations;oldusage.installs+=newusage.installs;oldusage.uninstalls+=newusage.uninstalls;for(var url in newusage.activities){var newcount=newusage.activities[url];var oldcount=oldusage.activities[url]||0;oldusage.activities[url]=oldcount+newcount;}}}
for(var provider in newbatch.data.searches){var newsearch=newbatch.data.searches[provider];var oldsearch=this.data.searches[provider];if(!oldsearch){this.data.searches[provider]={};debug('creating new object for provider',provider);}
for(var daykey in newsearch){var daySearch=oldsearch[daykey];if(!daySearch){oldsearch[daykey]=newsearch[daykey];}else{var newsearchcount=newsearch[daykey].count;var oldsearchcount=oldsearch[daykey].count||0;oldsearch[daykey].count=oldsearchcount+newsearchcount;}}}};UsageData.prototype.save=function(force){if(force||this.needsSave){asyncStorage.setItem(PERSISTENCE_KEY,this.data);this.needsSave=false;debug('Saved app usage data');}};UsageData.load=function(callback){asyncStorage.getItem(PERSISTENCE_KEY,function(data){var usage=new UsageData();if(data){usage.data=data;if(typeof usage.data.searches==='undefined'){usage.data.searches={};}
delete usage.relativeStartTime;}
callback(usage);});};AUM.getSettings=function getSettings(settingKeysAndDefaults,callback){var pendingQueries=0;var results={};var lock=window.navigator.mozSettings.createLock();for(var key in settingKeysAndDefaults){var defaultValue=settingKeysAndDefaults[key];query(key,defaultValue);pendingQueries++;}
function query(key,defaultValue){var request=lock.get(key);request.onsuccess=function(){var value=request.result[key];if(value===undefined||value===null){value=defaultValue;}
results[key]=value;pendingQueries--;if(pendingQueries===0){callback(results);}};}};exports.AppUsageMetrics=AppUsageMetrics;}(window));;'use strict';var Basket={DATASTORE_NAME:'Basket_Newsletter',basketUrl:'https://basket.mozilla.org/news/subscribe/',newsletterId:'firefox-os',callback:null,xhr:null,errors:{NETWORK_FAILURE:1,INVALID_EMAIL:2,UNKNOWN_EMAIL:3,UNKNOWN_TOKEN:4,USAGE_ERROR:5,EMAIL_PROVIDER_AUTH_FAILURE:6,AUTH_ERROR:7,SSL_REQUIRED:8,INVALID_NEWSLETTER:9,INVALID_LANGUAGE:10,EMAIL_NOT_CHANGED:11,CHANGE_REQUEST_NOT_FOUND:12,UNKNOWN_ERROR:99},responseHandler:function b_responseHandler(){if(this.xhr.readyState===4){if(this.xhr.status===200){if(typeof this.callback==='function'){this.callback(null,JSON.parse(this.xhr.responseText));}}else{if(typeof this.callback==='function'){if(this.xhr.responseText){this.callback(JSON.parse(this.xhr.responseText));}else{this.callback('Unknown error');}}}}},timeoutHandler:function b_timeoutHandler(){this.callback('Timeout');},send:function b_send(email,callback){var self=this;var params='email='+encodeURIComponent(email)+'&newsletters='+self.newsletterId;self.callback=callback;self.xhr=new XMLHttpRequest({mozSystem:true});self.xhr.onreadystatechange=self.responseHandler.bind(self);self.xhr.open('POST',self.basketUrl,true);self.xhr.setRequestHeader('Content-type','application/x-www-form-urlencoded');self.xhr.setRequestHeader('Connection','close');self.xhr.timeout=5000;self.xhr.ontimeout=self.timeoutHandler.bind(self);self.getLanguage(function do_send(language){if(language){params+='&lang='+language;}
self.xhr.setRequestHeader('Content-length',params.length);self.xhr.send(params);});},getDataStore:function(){var self=this;return new Promise(function(resolve,reject){navigator.getDataStores(self.DATASTORE_NAME).then(function(stores){if(!stores.length){reject(new Error('DataStore not loaded'));}else{var dataStore=stores[0];if(dataStore.owner==='app://ftu.gaiamobile.org/manifest.webapp'){resolve(dataStore);}else{reject(new Error('Wrong DataStore'));}}});});},store:function b_store(email,callback){this.getDataStore().then(function loaded(store){store.add({'newsletter_email':email}).then(function(id){if(callback){callback(false,id);}});}).catch(function error(err){console.error('Something went wrong: '+err);callback(err);});},getLanguage:function b_getLanguage(callback){var settings=window.navigator.mozSettings;if(!settings||!settings.createLock){callback();return;}
var s_name='language.current';var req=settings.createLock().get(s_name);req.onsuccess=function _onsuccess(){callback(req.result[s_name]);};req.onerror=function _onerror(){console.error('Error getting setting: '+s_name);callback();};}};;'use strict';var NewsletterManager={start:function(){return new Promise(function(resolve,reject){LazyLoader.load('/shared/js/basket_client.js',function basketLoaded(){Basket.getDataStore().then(function gotDS(store){store.get(1).then(function(itemRetrieved){if(typeof itemRetrieved==='undefined'||itemRetrieved.emailSent){resolve();}else{sendWhenOnline(itemRetrieved.newsletter_email).then(function(){resolve();}).catch(function(){reject();});}});}).catch(function promiseFailed(error){var errMsg='Something failed: '+error;console.error(errMsg);reject(new Error(errMsg));});});});},sendNewsletter:function(emailAddress){return new Promise(function(resolve,reject){LazyLoader.load('/shared/js/basket_client.js',function basketLoaded(){Basket.send(emailAddress,function itemSent(err,data){if(err){var errMsg='Error sending data: '+err;console.error(errMsg);reject(new Error(errMsg));}
if(data&&data.status==='ok'){Basket.getDataStore().then(function gotDS(store){var newObj={'emailSent':true};store.put(newObj,1);resolve();}).catch(function error(err){var errMsg='Error getting the datastore: '+err;console.error(errMsg);reject(new Error(errMsg));});}else{reject(new Error('Error on server answer: '+JSON.stringify(data)));}});});});}};function sendWhenOnline(email){return new Promise(function(resolve,reject){if(navigator.onLine){NewsletterManager.sendNewsletter(email).then(resolve).catch(reject);}else{window.addEventListener('online',function online(){window.removeEventListener('online',online);NewsletterManager.sendNewsletter(email);});reject();}});}
var idleObserver={time:10,onidle:function(){if(FtuLauncher.isFtuRunning()){return;}
navigator.removeIdleObserver(idleObserver);NewsletterManager.start();}};if(navigator.mozL10n){navigator.mozL10n.once(function loadWhenIdle(){navigator.addIdleObserver(idleObserver);});};'use strict';var icc_events={downloadEvent:function icc_events_downloadEvent(message,eventObject){DUMP('icc_events_downloadEvent: Downloading event:',eventObject);(icc.getIcc(message.iccId)).sendStkEventDownload(eventObject);},handleLocationStatus:function icc_events_handleLocationStatus(message,evt){if(evt.type!='voicechange'){return;}
var conn=icc.getConnection(message.iccId);if(!conn){DUMP(' STK handleLocationStatus - No connection found for this iccId'+
message.iccId);return;}
DUMP(' STK Location changed to MCC='+conn.voice.network.mcc+' MNC='+conn.voice.network.mnc+' LAC='+conn.voice.cell.gsmLocationAreaCode+' CellId='+conn.voice.cell.gsmCellId+' Status/Connected='+conn.voice.connected+' Status/Emergency='+conn.voice.emergencyCallsOnly);var status=icc._iccManager.STK_SERVICE_STATE_UNAVAILABLE;if(conn.voice.connected){status=icc._iccManager.STK_SERVICE_STATE_NORMAL;}else if(conn.voice.emergencyCallsOnly){status=icc._iccManager.STK_SERVICE_STATE_LIMITED;}
this.downloadEvent(message,{eventType:icc._iccManager.STK_EVENT_TYPE_LOCATION_STATUS,locationStatus:status,locationInfo:{mcc:conn.voice.network.mcc,mnc:conn.voice.network.mnc,gsmLocationAreaCode:conn.voice.cell.gsmLocationAreaCode,gsmCellId:conn.voice.cell.gsmCellId}});},handleCallsChanged:function icc_events_handleCallsChanged(evt){if(evt.type!='callschanged'){return;}
DUMP(' STK Communication changed : '+evt.type);var self=this;window.navigator.mozTelephony.calls.forEach(function callIterator(call){DUMP(' STK:CALLS State change: '+call.state);var outgoing=call.state=='incoming';var iccMan=icc._iccManager,serviceId=call.serviceId,iccId=window.navigator.mozMobileConnections[serviceId].iccId,iccEventSet=self.eventSet[iccId];if(call.state=='incoming'&&iccEventSet&&iccEventSet[iccMan.STK_EVENT_TYPE_MT_CALL]){self.downloadEvent(iccEventSet[iccMan.STK_EVENT_TYPE_MT_CALL],{eventType:icc._iccManager.STK_EVENT_TYPE_MT_CALL,number:call.id.number,isIssuedByRemote:outgoing,error:null});}
call.addEventListener('error',function callError(err){if(iccEventSet&&iccEventSet[iccMan.STK_EVENT_TYPE_CALL_DISCONNECTED]){self.downloadEvent(iccEventSet[iccMan.STK_EVENT_TYPE_CALL_DISCONNECTED],{eventType:icc._iccManager.STK_EVENT_TYPE_CALL_DISCONNECTED,number:call.id?call.id.number:call.number,error:err});}});call.addEventListener('statechange',function callStateChange(){DUMP(' STK:CALL State Change: '+call.state);switch(call.state){case'connected':if(iccEventSet&&iccEventSet[iccMan.STK_EVENT_TYPE_CALL_CONNECTED]){self.downloadEvent(iccEventSet[iccMan.STK_EVENT_TYPE_CALL_CONNECTED],{eventType:icc._iccManager.STK_EVENT_TYPE_CALL_CONNECTED,number:call.id?call.id.number:call.number,isIssuedByRemote:outgoing});}
break;case'disconnected':call.removeEventListener('statechange',callStateChange);if(iccEventSet&&iccEventSet[iccMan.STK_EVENT_TYPE_CALL_DISCONNECTED]){self.downloadEvent(iccEventSet[iccMan.STK_EVENT_TYPE_CALL_DISCONNECTED],{eventType:icc._iccManager.STK_EVENT_TYPE_CALL_DISCONNECTED,number:call.id?call.id.number:call.number,isIssuedByRemote:outgoing,error:null});}
break;}});});},handleLanguageSelectionEvent:function icc_events_handleLanguageSelectionEvent(message,evt){DUMP(' STK Language selection = '+evt.settingValue);this.downloadEvent(message,{eventType:icc._iccManager.STK_EVENT_TYPE_LANGUAGE_SELECTION,language:evt.settingValue.substring(0,2)});},handleBrowserTerminationEvent:function icc_events_handleBrowserTerminationEvent(message,evt){DUMP(' STK Browser termination');this.downloadEvent(message,{eventType:icc._iccManager.STK_EVENT_TYPE_BROWSER_TERMINATION,terminationCause:icc._iccManager.STK_BROWSER_TERMINATION_CAUSE_USER});},handleUserActivityEvent:function icc_events_handleUserActivity(message){DUMP(' STK User Activity');this.downloadEvent(message,{eventType:icc._iccManager.STK_EVENT_TYPE_USER_ACTIVITY});if(this.stkUserActivity){navigator.removeIdleObserver(this.stkUserActivity);}},handleIdleScreenAvailableEvent:function icc_events_handleIdleScreenAvailableEvent(message){DUMP(' STK IDLE screen available');this.downloadEvent(message,{eventType:icc._iccManager.STK_EVENT_TYPE_IDLE_SCREEN_AVAILABLE});window.removeEventListener('homescreenopened',this.register_icc_event_idlescreen);},registerCallChanged:function(message,stkEvent){DUMP('icc_events_registerCallChanged message: '+message);DUMP('icc_events_registerCallChanged stkEvent: '+stkEvent);var self=this;if(!self.eventSet){DUMP('icc_events create eventList');var comm=window.navigator.mozTelephony;comm.addEventListener('callschanged',function(teleEvent){self.handleCallsChanged(teleEvent);});}
self.eventSet={};if(!self.eventSet[message.iccId]){DUMP('icc_events create eventList for '+message.iccId);self.eventSet[message.iccId]={};}
if(!self.eventSet[message.iccId][stkEvent]){DUMP('icc_events create eventList for '+
message.iccId+' EVT: '+stkEvent);self.eventSet[message.iccId][stkEvent]=message;DUMP('icc_events '+self.eventSet[message.iccId]);}},register:function icc_events_register(message,eventList){DUMP('icc_events_register fpr card '+message.iccId+' - Events list:',eventList);var conn=icc.getConnection(message.iccId);conn.removeEventListener('voicechange',this.register_icc_event_voicechange);if(this.stkUserActivity){navigator.removeIdleObserver(this.stkUserActivity);}
window.removeEventListener('homescreenopened',this.register_icc_event_idlescreen);if(this.icc_events_languageChanged){window.navigator.mozSettings.removeObserver('language.current',this.icc_events_languageChanged);}
window.removeEventListener('appterminated',this.icc_events_browsertermination);for(var evt in eventList){DUMP('icc_events_register - Registering event:',eventList[evt]);switch(eventList[evt]){case icc._iccManager.STK_EVENT_TYPE_MT_CALL:case icc._iccManager.STK_EVENT_TYPE_CALL_CONNECTED:case icc._iccManager.STK_EVENT_TYPE_CALL_DISCONNECTED:DUMP('icc_events_register - Communications changes event');DUMP('icc_events_register message: '+message);DUMP('icc_events_register events: '+eventList);icc_events.registerCallChanged(message,eventList[evt]);break;case icc._iccManager.STK_EVENT_TYPE_LOCATION_STATUS:DUMP('icc_events_register - Location changes event');this.register_icc_event_voicechange=function(evt){icc_events.handleLocationStatus(message,evt);};conn.addEventListener('voicechange',this.register_icc_event_voicechange);break;case icc._iccManager.STK_EVENT_TYPE_USER_ACTIVITY:DUMP('icc_events_register - User activity event');this.stkUserActivity={time:1,onidle:function(){DUMP('STK Event - User activity - Going to idle');},onactive:function(){DUMP('STK Event - User activity - Going to active');icc_events.handleUserActivityEvent(message);}};navigator.addIdleObserver(this.stkUserActivity);break;case icc._iccManager.STK_EVENT_TYPE_IDLE_SCREEN_AVAILABLE:DUMP('icc_events_register - Idle screen available event');this.register_icc_event_idlescreen=function(){icc_events.handleIdleScreenAvailableEvent(message);};window.addEventListener('homescreenopened',this.register_icc_event_idlescreen);break;case icc._iccManager.STK_EVENT_TYPE_CARD_READER_STATUS:DUMP('icc_events_register - TODO event: ',eventList[evt]);break;case icc._iccManager.STK_EVENT_TYPE_LANGUAGE_SELECTION:DUMP('icc_events_register - Language selection event');this.icc_events_languageChanged=function(e){icc_events.handleLanguageSelectionEvent(message,e);};window.navigator.mozSettings.addObserver('language.current',this.icc_events_languageChanged);break;case icc._iccManager.STK_EVENT_TYPE_BROWSER_TERMINATION:DUMP('icc_events_register - Browser termination event');this.icc_events_browsertermination=function(e){var app=applications.getByManifestURL(e.detail.origin+'/manifest.webapp');if(!app){return;}
if(app.manifest.name==='Browser'){icc_events.handleBrowserTerminationEvent(message,e);}};window.addEventListener('appterminated',this.icc_events_browsertermination);break;case icc._iccManager.STK_EVENT_TYPE_DATA_AVAILABLE:case icc._iccManager.STK_EVENT_TYPE_CHANNEL_STATUS:case icc._iccManager.STK_EVENT_TYPE_SINGLE_ACCESS_TECHNOLOGY_CHANGED:case icc._iccManager.STK_EVENT_TYPE_DISPLAY_PARAMETER_CHANGED:case icc._iccManager.STK_EVENT_TYPE_LOCAL_CONNECTION:case icc._iccManager.STK_EVENT_TYPE_NETWORK_SEARCH_MODE_CHANGED:case icc._iccManager.STK_EVENT_TYPE_BROWSING_STATUS:case icc._iccManager.STK_EVENT_TYPE_FRAMES_INFORMATION_CHANGED:DUMP('icc_events_register - TODO event: ',eventList[evt]);break;}}}};;'use strict';var icc_worker={idleTextNotifications:{},iccApplicationsMenu:{},dummy:function icc_worker_dummy(message){DUMP('STK Command not implemented yet');icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});},'0x1':function STK_CMD_REFRESH(message){DUMP('STK_CMD_REFRESH',message.command.options);if(this.idleTextNotifications[message.iccId]){this.idleTextNotifications[message.iccId].close();}},'0x3':function STK_CMD_POLL_INTERVAL(message){DUMP('STK_CMD_POLL_INTERVAL',message.command.options);icc_worker.dummy(message);},'0x4':function STK_CMD_POLL_OFF(message){DUMP('STK_CMD_POLL_OFF',message.command.options);icc_worker.dummy(message);},'0x5':function STK_CMD_SET_UP_EVENT_LIST(message){DUMP('STK_CMD_SET_UP_EVENT_LIST:',message.command.options);icc_events.register(message,message.command.options.eventList);icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});},'0x10':function STK_CMD_SET_UP_CALL(message){function stkSetupCall(confirmed,postMessage){icc.responseSTKCommand(message,{hasConfirmed:confirmed,resultCode:icc._iccManager.STK_RESULT_OK});if(confirmed&&postMessage){window.navigator.mozSettings.createLock().set({'icc.callmessage':callMessage});}}
DUMP('STK_CMD_SET_UP_CALL:',message.command.options);var options=message.command.options;var confirmMessage=STKHelper.getMessageText(options.confirmMessage,'icc-confirmCall-defaultmessage',{'number':options.address});var callMessage=STKHelper.getMessageText(options.callMessage);icc.discardCurrentMessageIfNeeded(message);if(confirmMessage){if(STKHelper.isIconSelfExplanatory(options.confirmMessage)){confirmMessage='';}
var icons=options.confirmMessage?options.confirmMessage.icons:null;icc.asyncConfirm(message,confirmMessage,icons,function(confirmed){stkSetupCall(confirmed,callMessage);});}else{stkSetupCall(true,callMessage);}},'0x11':function STK_CMD_SEND_SS(message){DUMP('STK_CMD_SEND_SS:',message.command.options);var options=message.command.options;icc.discardCurrentMessageIfNeeded(message);var text=STKHelper.getMessageText(options,'icc-alertMessage-defaultmessage');icc.alert(message,text,options.icons);},'0x12':function STK_CMD_SEND_USSD(message){DUMP('STK_CMD_SEND_USSD:',message.command.options);this['0x13'](message);},'0x13':function STK_CMD_SEND_SMS(message){DUMP('STK_CMD_SEND_SMS:',message.command.options);var options=message.command.options;icc.discardCurrentMessageIfNeeded(message);var text=options.text;if(text){text=STKHelper.getMessageText(options);icc.confirm(message,text,options.icons);}else if(text!==undefined){text=STKHelper.getMessageText(options,'icc-alertMessage-defaultmessage');icc.alert(message,text,options.icons);}},'0x14':function STK_CMD_SEND_DTMF(message){DUMP('STK_CMD_SEND_DTMF:',message.command.options);var options=message.command.options;icc.discardCurrentMessageIfNeeded(message);var text=STKHelper.getMessageText(options,'icc-confirmMessage-defaultmessage');icc.alert(message,text,options.icons);},'0x15':function STK_CMD_LAUNCH_BROWSER(message){DUMP('STK_CMD_LAUNCH_BROWSER:',message.command.options);var options=message.command.options;if(options.confirmMessage){icc.discardCurrentMessageIfNeeded(message);}
icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});var text='';if(!STKHelper.isIconSelfExplanatory(options.confirmMessage)){text=STKHelper.getMessageText(options.confirmMessage);}
var icons=options.confirmMessage?options.confirmMessage.icons:null;icc.showURL(message,options.url,icons,text);},'0x20':function STK_CMD_PLAY_TONE(message){function getPhoneSound(toneCode){toneCode=typeof(toneCode)=='string'?toneCode.charCodeAt(0):toneCode;switch(toneCode){case icc._iccManager.STK_TONE_TYPE_DIAL_TONE:return'resources/dtmf_tones/350Hz+440Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_CALLED_SUBSCRIBER_BUSY:return'resources/dtmf_tones/480Hz+620Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_CONGESTION:return'resources/dtmf_tones/425Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_RADIO_PATH_ACK:case icc._iccManager.STK_TONE_TYPE_RADIO_PATH_NOT_AVAILABLE:return'resources/dtmf_tones/425Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_ERROR:return'resources/dtmf_tones/950Hz+1400Hz+1800Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_CALL_WAITING_TONE:case icc._iccManager.STK_TONE_TYPE_RINGING_TONE:return'resources/dtmf_tones/425Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_GENERAL_BEEP:return'resources/dtmf_tones/400Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_POSITIVE_ACK_TONE:return'resources/dtmf_tones/425Hz_200ms.ogg';case icc._iccManager.STK_TONE_TYPE_NEGATIVE_ACK_TONE:return'resources/dtmf_tones/300Hz+400Hz+500Hz_400ms.ogg';default:return'resources/dtmf_tones/350Hz+440Hz_200ms.ogg';}}
DUMP('STK_CMD_PLAY_TONE:',message.command.options);var options=message.command.options;if(options.text){icc.discardCurrentMessageIfNeeded(message);}
var tonePlayer=new Audio();tonePlayer.src=getPhoneSound(options.tone);tonePlayer.loop=true;var timeout=0;var duration=options.duration;if(duration&&duration.timeUnit!==undefined&&duration.timeInterval!==undefined){timeout=icc.calculateDurationInMS(duration.timeUnit,duration.timeInterval);}else if(options.timeUnit!==undefined&&options.timeInterval!==undefined){timeout=icc.calculateDurationInMS(options.timUnit,options.timeInterval);}else{timeout=icc._toneDefaultTimeout;}
timeout&&DUMP('Tone stop in (ms): ',timeout);if(options.text){var text=STKHelper.getMessageText(options);icc.confirm(message,text,options.icons,timeout,function(userCleared){tonePlayer.pause();if(userCleared==null){return;}
icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});});}else{icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});setTimeout(function _iccTonePlayerStop(){tonePlayer.pause();},timeout);}
if(options.isVibrate){window.navigator.vibrate([200]);}
tonePlayer.play();},'0x21':function STK_CMD_DISPLAY_TEXT(message){DUMP('STK_CMD_DISPLAY_TEXT:',message.command.options);var options=message.command.options;icc.discardCurrentMessageIfNeeded(message);var activeApp=Service.currentApp;var settingsOrigin=window.location.origin.replace('system','settings');if(!options.isHighPriority&&activeApp&&!activeApp.isHomescreen&&activeApp.origin!==settingsOrigin){DUMP('Do not display the text because normal priority.');icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_TERMINAL_CRNTLY_UNABLE_TO_PROCESS,additionalInformation:0x01});return;}
var text=STKHelper.getMessageText(options);var timeout=icc._displayTextTimeout;var duration=options.duration;if(duration&&duration.timeUnit!==undefined&&duration.timeInterval!==undefined){timeout=icc.calculateDurationInMS(duration.timeUnit,duration.timeInterval);}
if(options.responseNeeded){icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});icc.confirm(message,text,options.icons,timeout,null);}else{icc.confirm(message,text,options.icons,timeout,function(userCleared){if(userCleared==null){return;}
DUMP('STK_CMD_DISPLAY_TEXT callback for ',message.command);if(options.userClear&&!userCleared){DUMP('No response from user (Timeout)');icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_NO_RESPONSE_FROM_USER});}else{DUMP('Alert closed');icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});}});}},'0x22':function STK_CMD_GET_INKEY(message){DUMP('STK_CMD_GET_INKEY:',message.command.options);this['0x23'](message);},'0x23':function STK_CMD_GET_INPUT(message){DUMP('STK_CMD_GET_INPUT:',message.command.options);var options=message.command.options;icc.discardCurrentMessageIfNeeded(message);DUMP('STK Input title: '+options.text);var duration=options.duration;var timeout=(duration&&icc.calculateDurationInMS(duration.timeUnit,duration.timeInterval))||icc._inputTimeout;var text=STKHelper.getMessageText(options);icc.input(message,text,options.icons,timeout,options,function(response,value){if(response==null){return;}
if(!response){DUMP('STK_CMD_GET_INPUT: No response from user (Timeout)');icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_NO_RESPONSE_FROM_USER});}else{DUMP('STK_CMD_GET_INPUT: Response = ',value);if(typeof value==='boolean'){icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK,isYesNo:value});}else{icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK,input:value});}}});},'0x24':function STK_CMD_SELECT_ITEM(message){var application=document.location.protocol+'//'+
document.location.host.replace('system','settings');DUMP('STK_CMD_SET_UP_MENU. Transferring to '+application+': ',message.command);var reqIccData=window.navigator.mozSettings.createLock().set({'icc.data':JSON.stringify(message)});reqIccData.onsuccess=function icc_getIccData(){if(window.appWindowManager.getApp(application)){return DUMP('Settings is running. Ignoring');}
navigator.mozApps.mgmt.getAll().onsuccess=function gotApps(evt){var apps=evt.target.result;apps.forEach(function appIterator(app){if(app.origin!=application){return;}
DUMP('Launching ',app.origin);app.launch();},this);};};},'0x25':function STK_CMD_SET_UP_MENU(message){DUMP('STK_CMD_SET_UP_MENU:',message.command.options);var settings=window.navigator.mozSettings;this.iccApplicationsMenu[icc.getSIMNumber(message.iccId)||0]={iccId:message.iccId,entries:message.command.options};var reqApplications=settings.createLock().set({'icc.applications':JSON.stringify(this.iccApplicationsMenu)});var self=this;reqApplications.onsuccess=function icc_getApplications(){DUMP('STK: Cached - ',self.iccApplicationsMenu);icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});};},'0x26':function STK_CMD_PROVIDE_LOCAL_INFO(message){var conn=icc.getConnection(message.iccId);DUMP('STK_CMD_PROVIDE_LOCAL_INFO:',message.command.options);switch(message.command.options.localInfoType){case icc._iccManager.STK_LOCAL_INFO_LOCATION_INFO:DUMP('cell of connection - '+conn.voice.cell);if(conn.voice.cell){icc.responseSTKCommand(message,{localInfo:{locationInfo:{mcc:IccHelper.iccInfo.mcc,mnc:IccHelper.iccInfo.mnc,gsmLocationAreaCode:conn.voice.cell.gsmLocationAreaCode,gsmCellId:conn.voice.cell.gsmCellId}},resultCode:icc._iccManager.STK_RESULT_OK});}else{icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_PRFRMD_LIMITED_SERVICE});}
break;case icc._iccManager.STK_LOCAL_INFO_IMEI:navigator.mozTelephony.dial('*#06#').then(function(call){return call.result.then(function getIMEI(result){if(result.success&&(result.serviceCode==='scImei')&&result.statusMessage){return result.statusMessage;}else{return 0;}});}).then(function(imei){icc.responseSTKCommand(message,{localInfo:{imei:imei},resultCode:imei?icc._iccManager.STK_RESULT_OK:icc._iccManager.STK_RESULT_REQUIRED_VALUES_MISSING});});break;case icc._iccManager.STK_LOCAL_INFO_DATE_TIME_ZONE:icc.responseSTKCommand(message,{localInfo:{date:new Date()},resultCode:icc._iccManager.STK_RESULT_OK});break;case icc._iccManager.STK_LOCAL_INFO_LANGUAGE:var reqLanguage=window.navigator.mozSettings.createLock().get('language.current');reqLanguage.onsuccess=function icc_getLanguage(){icc.responseSTKCommand(message,{localInfo:{language:reqLanguage.result['language.current'].substring(0,2)},resultCode:icc._iccManager.STK_RESULT_OK});};reqLanguage.onerror=function icc_getLanguageFailed(){icc.responseSTKCommand(message,{localInfo:{language:'en'},resultCode:icc._iccManager.STK_RESULT_REQUIRED_VALUES_MISSING});};break;}},'0x27':function STK_CMD_TIMER_MANAGEMENT(message){DUMP('STK_CMD_TIMER_MANAGEMENT:',message.command.options);var a_timer=advanced_timer;var options=message.command.options;var pendingTime=0;switch(options.timerAction){case icc._iccManager.STK_TIMER_START:a_timer.start(options.timerId,options.timerValue*1000,function(realUsedTimeMs){DUMP('Timer expiration - '+options.timerId+' - real used time '+realUsedTimeMs);(icc.getIcc(message.iccId)).sendStkTimerExpiration({'timerId':options.timerId,'timerValue':realUsedTimeMs/1000});});icc.responseSTKCommand(message,{timer:{'timerId':options.timerId,'timerValue':options.timerValue,'timerAction':icc._iccManager.STK_TIMER_START},resultCode:icc._iccManager.STK_RESULT_OK});break;case icc._iccManager.STK_TIMER_DEACTIVATE:if(a_timer.queryPendingTime(options.timerId)===0){icc.responseSTKCommand(message,{timer:{'timerId':options.timerId},resultCode:icc._iccManager.STK_RESULT_ACTION_CONTRADICTION_TIMER_STATE});}else{pendingTime=a_timer.stop(options.timerId)/1000;icc.responseSTKCommand(message,{timer:{'timerId':options.timerId,'timerValue':pendingTime,'timerAction':icc._iccManager.STK_TIMER_DEACTIVATE},resultCode:icc._iccManager.STK_RESULT_OK});}
break;case icc._iccManager.STK_TIMER_GET_CURRENT_VALUE:pendingTime=a_timer.queryPendingTime(options.timerId)/1000;if(pendingTime===0){icc.responseSTKCommand(message,{timer:{'timerId':options.timerId},resultCode:icc._iccManager.STK_RESULT_ACTION_CONTRADICTION_TIMER_STATE});}else{icc.responseSTKCommand(message,{timer:{'timerId':options.timerId,'timerValue':pendingTime,'timerAction':icc._iccManager.STK_TIMER_GET_CURRENT_VALUE},resultCode:icc._iccManager.STK_RESULT_OK});}
break;}},'0x28':function STK_CMD_SET_UP_IDLE_MODE_TEXT(message){DUMP('STK_CMD_SET_UP_IDLE_MODE_TEXT:',message.command.options);var options=message.command.options;return NotificationHelper.send({id:'icc-notification-title',args:{id:icc.getSIMNumber(message.iccId)}},{body:options.text,icon:'style/icons/system.png',tag:'stkNotification_'+message.iccId,mozbehavior:{showOnlyOnce:true}}).then((notification)=>{this.idleTextNotifications[message.iccId]=notification;notification.onclick=function onClickSTKNotification(){icc.discardCurrentMessageIfNeeded(message);var text=STKHelper.getMessageText(options);icc.alert(message,text,options.icons);};notification.onshow=function onShowSTKNotification(){icc.responseSTKCommand(message,{resultCode:icc._iccManager.STK_RESULT_OK});};});}};;'use strict';var icc={_displayTextTimeout:40000,_defaultURL:null,_inputTimeout:40000,_toneDefaultTimeout:5000,_screen:null,_currentMessage:null,checkPlatformCompatibility:function icc_checkPlatformCompat(){if(!('STK_RESULT_ACTION_CONTRADICTION_TIMER_STATE'in this._iccManager)){this._iccManager.STK_RESULT_ACTION_CONTRADICTION_TIMER_STATE=0x24;}},init:function icc_init(){this._iccManager=window.navigator.mozIccManager;if(!this._iccManager){return;}
this._screen=document.getElementById('screen');this.checkPlatformCompatibility();var self=this;this.clearMenuCache(function(){window.navigator.mozSetMessageHandler('icc-stkcommand',function callHandleSTKCommand(message){if(self._iccManager&&self._iccManager.getIccById){self.handleSTKCommand(message);}});});window.addEventListener('home',this);this.hideViews();this.protectForms();this.getIccInfo();var self=this;var reqDisplayTimeout=window.navigator.mozSettings.createLock().get('icc.displayTextTimeout');reqDisplayTimeout.onsuccess=function icc_getDisplayTimeout(){self._displayTextTimeout=reqDisplayTimeout.result['icc.displayTextTimeout'];};window.navigator.mozSettings.addObserver('icc.displayTextTimeout',function(e){self._displayTextTimeout=e.settingValue;});var reqInputTimeout=window.navigator.mozSettings.createLock().get('icc.inputTextTimeout');reqInputTimeout.onsuccess=function icc_getInputTimeout(){self._inputTimeout=reqInputTimeout.result['icc.inputTextTimeout'];};window.navigator.mozSettings.addObserver('icc.inputTextTimeout',function(e){self._inputTimeout=e.settingValue;});var reqToneDefaultTimeout=window.navigator.mozSettings.createLock().get('icc.toneDefaultTimeout');reqToneDefaultTimeout.onsuccess=function icc_getToneDefaultTimeout(){self._toneDefaultTimeout=reqToneDefaultTimeout.result['icc.toneDefaultTimeout'];};window.navigator.mozSettings.addObserver('icc.toneDefaultTimeout',function(e){self._toneDefaultTimeout=e.settingValue;});window.addEventListener('iac-settingsstk',function(evt){var message=evt.detail;DUMP('STK_System IAC!!!!');if(message==='StkMenuHidden'){window.dispatchEvent(new CustomEvent('stkMenuHidden'));}});window.addEventListener('desktop-notification-resend',self.clearIdleTextNotification);},clearIdleTextNotification:function icc_clearIdleTextNotification(){Notification.get().then(function(notifications){for(var i=0;i<notifications.length;i++){if(notifications[i].tag.indexOf('stkNotification_')===0){notifications[i].close();}}});},getIccInfo:function icc_getIccInfo(){var self=this;var url='/resources/icc.json';LazyLoader.getJSON(url).then(function(json){self._defaultURL=json.defaultURL;DUMP('ICC default URL: ',self._defaultURL);},function(error){DUMP('Failed to fetch file: '+url+','+error);});},getIcc:function icc_getIcc(iccId){DUMP('ICC Getting ICC for '+iccId);return this._iccManager.getIccById(iccId);},getConnection:function icc_getConnection(iccId){DUMP('ICC Getting Connection for '+iccId);for(var i=0;i<window.navigator.mozMobileConnections.length;i++){if(window.navigator.mozMobileConnections[i].iccId===iccId){DUMP('ICC Connection '+i+' found for '+iccId);return window.navigator.mozMobileConnections[i];}}
return null;},getSIMNumber:function icc_getSIMNumber(iccId){DUMP('ICC Getting SIM Number for '+iccId);for(var i=0;i<window.navigator.mozMobileConnections.length;i++){if(window.navigator.mozMobileConnections[i].iccId===iccId){return i+1;}}
return'';},clearMenuCache:function icc_clearMenuCache(callback){if(typeof callback!='function'){callback=function(){};}
var resetApplications=window.navigator.mozSettings.createLock().set({'icc.applications':'{}'});resetApplications.onsuccess=function icc_resetApplications(){DUMP('STK Cache Reseted');callback();};},handleSTKCommand:function icc_handleSTKCommand(message){if(!message||!message.iccId||!message.command||!message.command.typeOfCommand||!message.command.options){return DUMP('STK Proactive Command bad formed: ',message);}
DUMP('STK Proactive Command for SIM '+message.iccId+': ',message.command);if(FtuLauncher.isFtuRunning()){var self=this;window.addEventListener('ftudone',function ftudone(){DUMP('FTU is done!... processing STK message:',message);self.handleSTKCommand(message);});return DUMP('FTU is running, delaying STK...');}
var cmdId;if(typeof message.command.typeOfCommand==='string'){cmdId=message.command.typeOfCommand;}else{cmdId='0x'+message.command.typeOfCommand.toString(16);}
if(icc_worker[cmdId]){this.resize();return icc_worker[cmdId](message);}
DUMP('STK Command not recognized ! - ',message);},handleEvent:function icc_handleEvent(evt){switch(evt.type){case'home':if(this.icc_view.classList.contains('visible')){this.hideViews();}
break;}},responseSTKCommand:function icc_responseSTKCommand(message,response){DUMP('sendStkResponse to message: ',message);DUMP('STK sendStkResponse -- # response = ',response);var _icc=icc.getIcc(message.iccId);_icc&&_icc.sendStkResponse(message.command,response);message.response=true;},terminateResponse:function(message){DUMP('STK Sending STK_RESULT_UICC_SESSION_TERM_BY_USER to card '+
message.iccId);this.responseSTKCommand(message,{resultCode:this._iccManager.STK_RESULT_UICC_SESSION_TERM_BY_USER});},backResponse:function(message){DUMP('STK Sending STK_RESULT_BACKWARD_MOVE_BY_USER to card '+
message.iccId);this.responseSTKCommand(message,{resultCode:this._iccManager.STK_RESULT_BACKWARD_MOVE_BY_USER});},protectForms:function(){var protect=function(event){if(!event){return;}
event.preventDefault();};if(!this.icc_view){return;}
var forms=this.icc_view.getElementsByTagName('form');if(!forms){return;}
for(var i=0;i<forms.length;i++){var form=forms[i];form.onsubmit=protect;}},calculateDurationInMS:function icc_calculateDurationInMS(timeUnit,timeInterval){var timeout=timeInterval;switch(timeUnit){case this._iccManager.STK_TIME_UNIT_MINUTE:timeout*=60000;break;case this._iccManager.STK_TIME_UNIT_SECOND:timeout*=1000;break;case this._iccManager.STK_TIME_UNIT_TENTH_SECOND:timeout*=100;break;}
return timeout;},hideViews:function icc_hideViews(){if(!this.icc_view){this.icc_view=document.getElementById('icc-view');}
this._screen.classList.remove('icc');this.icc_view.classList.remove('visible');var icc_view_boxes=this.icc_view.children;for(var i=0;i<icc_view_boxes.length;i++){icc_view_boxes[i].classList.remove('visible');}
window.removeEventListener('keyboardchange',this.keyboardChangedEvent);window.removeEventListener('keyboardhide',this.keyboardChangedEvent);this._currentMessage=null;},setupView:function icc_setupView(viewId){if(viewId.getElementsByTagName('form').length>0){this.keyboardChangedEvent(viewId);window.addEventListener('keyboardchange',this.keyboardChangedEvent.bind(undefined,viewId,false));window.addEventListener('keyboardhide',this.keyboardChangedEvent.bind(undefined,viewId,true));}},keyboardChangedEvent:function(viewId,hidden){var keyboardHeight=0;if(!hidden){keyboardHeight=inputWindowManager.getHeight();}
var form=viewId.getElementsByTagName('form');var height=(window.innerHeight-keyboardHeight-StatusBar.height);height-=softwareButtonManager.height;viewId.style.height=height+'px';if(form&&viewId.clientHeight>0){var input=viewId.getElementsByTagName('input')[0];var header=viewId.getElementsByTagName('gaia-header')[0];var headerSubtitle=viewId.getElementsByTagName('gaia-subheader')[0];var menu=viewId.getElementsByTagName('menu')[0];var formHeight=viewId.clientHeight;formHeight-=(header.clientHeight+headerSubtitle.clientHeight);formHeight-=menu.clientHeight;formHeight-=softwareButtonManager.height;form[0].style.height=formHeight+'px';input.scrollIntoView();}},resize:function(){this.icc_view.style.top=StatusBar.height+'px';var height=window.layoutManager.height-StatusBar.height;this.icc_view.style.height=height+'px';},alert:function icc_alert(stkMessage,message,icons){if(!this.icc_alert){this.icc_alert=document.getElementById('icc-alert');this.icc_alert_subtitle=document.getElementById('icc-alert-subtitle');this.icc_alert_icons=document.getElementById('icc-alert-icons');this.icc_alert_msg=document.getElementById('icc-alert-msg');this.icc_alert_btn=document.getElementById('icc-alert-btn');this.setupView(this.icc_alert);}
this.icc_alert_icons.innerHTML='';navigator.mozL10n.setAttributes(this.icc_alert_subtitle,'icc-message-subtitle',{'id':this.getSIMNumber(stkMessage.iccId)});var self=this;this.icc_alert_btn.onclick=function closeICCalert(){self.hideViews();};if(icons&&icons.length>0){this.icc_alert.dataset.icons=true;this.drawMessageIcons(this.icc_alert_icons,icons);}else{delete this.icc_alert.dataset.icons;}
this.icc_alert_msg.textContent=message;this._screen.classList.add('icc');this.icc_alert.classList.add('visible');this.icc_view.classList.add('visible');},confirm:function(stkMessage,message,icons,timeout,callback){if(!this.icc_confirm){this.icc_confirm=document.getElementById('icc-confirm');this.icc_confirm_subtitle=document.getElementById('icc-confirm-subtitle');this.icc_confirm_icons=document.getElementById('icc-confirm-icons');this.icc_confirm_msg=document.getElementById('icc-confirm-msg');this.icc_confirm_btn=document.getElementById('icc-confirm-btn');this.icc_confirm_header=document.getElementById('icc-confirm-header');this.icc_confirm_btn_close=document.getElementById('icc-confirm-btn_close');this.setupView(this.icc_confirm);}
this.icc_confirm_icons.innerHTML='';if(typeof callback!='function'){callback=function(){};}
navigator.mozL10n.setAttributes(this.icc_confirm_subtitle,'icc-message-subtitle',{'id':this.getSIMNumber(stkMessage.iccId)});var self=this;this.icc_confirm_header.addEventListener('action',function(){clearTimeout(timeoutId);self.hideViews();self.backResponse(stkMessage);callback(null);});this.icc_confirm_btn_close.onclick=function(){clearTimeout(timeoutId);self.hideViews();self.terminateResponse(stkMessage);callback(null);};if(timeout){var timeoutId=setTimeout(function(){self.hideViews();callback(false);},timeout);}
this.icc_confirm_btn.onclick=function(){clearTimeout(timeoutId);self.hideViews();callback(true);};if(icons&&icons.length>0){this.icc_confirm.dataset.icons=true;this.drawMessageIcons(this.icc_confirm_icons,icons);}else{delete this.icc_confirm.dataset.icons;}
this.icc_confirm_msg.textContent=message;this._screen.classList.add('icc');this.icc_confirm.classList.add('visible');this.icc_view.classList.add('visible');},asyncConfirm:function(stkMessage,message,icons,callback){if(typeof callback!='function'){callback=function(){};}
if(!this.icc_asyncconfirm){this.icc_asyncconfirm=document.getElementById('icc-asyncconfirm');this.icc_asyncconfirm_subtitle=document.getElementById('icc-asyncconfirm-subtitle');this.icc_asyncconfirm_icons=document.getElementById('icc-asyncconfirm-icons');this.icc_asyncconfirm_msg=document.getElementById('icc-asyncconfirm-msg');this.icc_asyncconfirm_btn_no=document.getElementById('icc-asyncconfirm-btn-no');this.icc_asyncconfirm_btn_yes=document.getElementById('icc-asyncconfirm-btn-yes');this.setupView(this.icc_asyncconfirm);}
this.icc_asyncconfirm_icons.innerHTML='';navigator.mozL10n.setAttributes(this.icc_asyncconfirm_subtitle,'icc-message-subtitle',{'id':this.getSIMNumber(stkMessage.iccId)});var self=this;function stkMenuHiddenHandler(event){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);self.hideViews();callback(false);}
window.addEventListener('stkMenuHidden',stkMenuHiddenHandler);this.icc_asyncconfirm_btn_no.onclick=function rejectConfirm(){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);self.hideViews();callback(false);};this.icc_asyncconfirm_btn_yes.onclick=function acceptConfirm(){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);self.hideViews();callback(true);};if(icons&&icons.length>0){this.icc_asyncconfirm.dataset.icons=true;this.drawMessageIcons(this.icc_asyncconfirm_icons,icons);}else{delete this.icc_asyncconfirm.dataset.icons;}
this.icc_asyncconfirm_msg.textContent=message;this._screen.classList.add('icc');this.icc_asyncconfirm.classList.add('visible');this.icc_view.classList.add('visible');},showURL:function(stkMessage,url,icons,confirmMessage){function openURL(url){if(url.search('^https?://')==-1){url='http://'+url;}
new MozActivity({name:'view',data:{type:'url',url:url}});}
if(url==null||url.length==0){url=this._defaultURL;}
DUMP('Final URL to open: '+url);if(url!=null||url.length!=0){if(icons||confirmMessage){this.asyncConfirm(stkMessage,confirmMessage,icons,function(res){if(res){openURL(url);}});}else{openURL(url);}}},input:function(stkMessage,message,icons,timeout,options,callback){var self=this;var timeoutId=null;function checkInputLengthValid(inputLen,minLen,maxLen){var charactersLeft=maxLen-inputLen;navigator.mozL10n.setAttributes(self.icc_input_btn,'okCharsLeft',{n:charactersLeft});if(charactersLeft===0){self.icc_input_box.classList.add('full');navigator.vibrate([500]);}else{self.icc_input_box.classList.remove('full');}
return(inputLen>=minLen)&&(inputLen<=maxLen);}
function clearInputTimeout(){if(timeoutId){DUMP('clearing previous STK INPUT timeout');clearTimeout(timeoutId);timeoutId=null;}}
function stkMenuHiddenHandler(event){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);clearInputTimeout();self.hideViews();self.terminateResponse(stkMessage);callback(null);}
function setInputTimeout(){DUMP('setting new STK INPUT timeout to - ',timeout);if(timeout){clearInputTimeout();timeoutId=setTimeout(function(){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);self.hideViews();callback(false);self.icc_input_header.removeEventListener('action',actionHandler);},timeout);}}
if(!this.icc_input){this.icc_input=document.getElementById('icc-input');this.icc_input_maintitle=document.getElementById('icc-input-maintitle');this.icc_input_subtitle=document.getElementById('icc-input-subtitle');this.icc_input_icons=document.getElementById('icc-input-icons');this.icc_input_msg=document.getElementById('icc-input-msg');this.icc_input_box=document.getElementById('icc-input-box');this.icc_input_btn=document.getElementById('icc-input-btn');this.icc_input_btn_yes=document.getElementById('icc-input-btn_yes');this.icc_input_btn_no=document.getElementById('icc-input-btn_no');this.icc_input_header=document.getElementById('icc-input-header');this.icc_input_btn_close=document.getElementById('icc-input-btn_close');this.icc_input_btn_help=document.getElementById('icc-input-btn_help');this.setupView(this.icc_input);}
this.icc_input_icons.innerHTML='';if(typeof callback!='function'){callback=function(){};}
setInputTimeout();this.icc_input_maintitle.setAttribute('data-l10n-id','icc-message-maintitle');navigator.mozL10n.setAttributes(this.icc_input_subtitle,'icc-message-subtitle',{'id':this.getSIMNumber(stkMessage.iccId)});this.icc_input_btn_help.disabled=!options.isHelpAvailable;if(!options.isYesNoRequested){this.icc_input.classList.remove('yesnomode');setTimeout(function workaround_bug818270(){self.icc_input_box.maxLength=options.maxLength;self.icc_input_box.value=options.defaultText||'';self.icc_input_btn.disabled=!checkInputLengthValid(self.icc_input_box.value.length,options.minLength,options.maxLength);},500);this.icc_input_box.placeholder=message;this.icc_input_box.type=options.isAlphabet?'text':'tel';if(options.hideInput){this.icc_input_box.type='password';}
if(options.hidden){this.icc_input_box.type='hidden';}
this.icc_input_btn.disabled=!checkInputLengthValid(this.icc_input_box.value.length,options.minLength,options.maxLength);this.icc_input_box.onkeyup=function(event){setInputTimeout();if(self.icc_input_box.type==='tel'){self.icc_input_box.value=self.icc_input_box.value.replace(/[()-]/g,'');}
self.icc_input_btn.disabled=!checkInputLengthValid(self.icc_input_box.value.length,options.minLength,options.maxLength);};this.icc_input_btn.onclick=function(){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);clearInputTimeout();self.hideViews();callback(true,self.icc_input_box.value);self.icc_input_header.removeEventListener('action',actionHandler);};this.icc_input_box.focus();}else{this.icc_input.classList.add('yesnomode');this.icc_input_box.type='hidden';this.icc_input_btn_yes.onclick=function(event){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);clearInputTimeout();self.hideViews();callback(true,true);self.icc_input_header.removeEventListener('action',actionHandler);};this.icc_input_btn_no.onclick=function(event){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);clearInputTimeout();self.hideViews();callback(true,false);self.icc_input_header.removeEventListener('action',actionHandler);};}
if(icons&&icons.length>0){this.icc_input.dataset.icons=true;this.drawMessageIcons(this.icc_input_icons,icons);}else{delete this.icc_input.dataset.icons;}
this.icc_input_box.value='';this.icc_input_msg.classList.toggle('stk-no-text',!message);this.icc_input_msg.textContent=message;this._screen.classList.add('icc');this.icc_input.classList.add('visible');this.icc_view.classList.add('visible');var actionHandler=function(){clearInputTimeout();self.hideViews();self.backResponse(stkMessage);callback(null);self.icc_input_header.removeEventListener('action',actionHandler);window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);};window.addEventListener('stkMenuHidden',stkMenuHiddenHandler);this.icc_input_header.addEventListener('action',actionHandler);this.icc_input_btn_close.onclick=function(){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);clearInputTimeout();self.hideViews();self.terminateResponse(stkMessage);callback(null);self.icc_input_header.removeEventListener('action',actionHandler);};this.icc_input_btn_help.onclick=function(){window.removeEventListener('stkMenuHidden',stkMenuHiddenHandler);clearInputTimeout();self.hideViews();self.responseSTKCommand(stkMessage,{resultCode:self._iccManager.STK_RESULT_HELP_INFO_REQUIRED});callback(null);self.icc_input_header.removeEventListener('action',actionHandler);};},discardCurrentMessageIfNeeded:function(new_message){var _currentMessage=this._currentMessage;if(_currentMessage&&_currentMessage!==new_message){this.hideViews();if(!_currentMessage.response){DUMP('New message received, discarding previous message...');this.responseSTKCommand(_currentMessage,{resultCode:icc._iccManager.STK_RESULT_TERMINAL_CRNTLY_UNABLE_TO_PROCESS});}}
this._currentMessage=new_message;},drawMessageIcons:function(container,icons){for(var i=0;i<icons.length;i++){container.appendChild(STKHelper.getIconCanvas(icons[i]));}}};icc.init();;'use strict';(function(exports){var LockScreenAgent=function(frame){this.configs={listens:['lockscreen-notification-request-append','lockscreen-notification-request-clear','emergency-call-leave','screenchange','timeformatchange','iac-mediacomms','appterminated','bluetoothprofileconnectionchange','lockscreen-request-mediacommand','lockscreen-appclosed']};this.frame=frame;};LockScreenAgent.prototype.start=function(){this.startEventListeners();};LockScreenAgent.prototype.startEventListeners=function(){this.configs.listens.forEach((ename)=>{window.addEventListener(ename,this);});};LockScreenAgent.prototype.handleEvent=function(event){if('lockscreen-request-mediacommand'===event.type){var port=IACHandler.getPort('mediacomms');if(!port){console.error('No port for MediaPlaybackWidget');return;}
port.postMessage({command:event.detail});return;}};LockScreenAgent.prototype.stop=function(){this.configs.listens.forEach((ename)=>{window.removeEventListener(ename,this);});};exports.LockScreenAgent=LockScreenAgent;})(window);;'use strict';(function(exports){var LockScreenSlide=function(opts){this.initialize(opts);};var LockScreenSlidePrototype={canvas:null,layout:'',useNewStyle:false,track:{length:{tiny:'280',large:'410'},color:'rgba(255, 255, 255, 0.4)',backgroundColor:'rgba(0, 0, 0, 0)',from:0,to:0,radius:0,width:0},trackNew:{length:{tiny:'276',large:'406'},strokeColorTop:'rgba(0, 0, 0, 0.2)',strokeColorBottom:'rgba(0, 0, 0, 0)',fillColorTop:'rgba(0, 0, 0, 0.2)',fillColorBottom:'rgba(0, 0, 0, 0)',backColor:'rgba(51, 51, 51, 0.15)',from:0,to:0,radius:0,width:0},arrows:{left:null,right:null,ldraw:{x:null,y:null},rdraw:{x:null,y:null}},iconBG:{radius:20,left:{color:'rgba(255, 255, 255, 0.25)'},right:{color:'rgba(255, 255, 255, 0.25)'}},slides:{left:null,right:null},areas:{left:null,right:null},area:null,overlay:null,width:0,height:80,center:{x:null,y:null},handle:{autoExpand:{accState:'normal',accFactor:1.02,sentinelOffset:40,sentinelWidth:0},bounceBackTime:200,radius:28,lineWidth:1.6,maxWidth:0,touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239',color:'255, 255, 255',backgroundColor:'255, 255, 255',backgroundAlpha:0},handleNew:{autoExpand:{accState:'normal',accFactor:1.02,sentinelOffset:40,sentinelWidth:0},bounceBackTime:200,radius:30,innerRadius:15,outerColor:'rgba(255, 255, 255, 0.9)',innerColor:'rgba(0, 0, 0, 0.05)',lineWidth:1.6,maxWidth:0,towardLeft:false,touchedColor:'0, 170, 204',touchedColorStop:'178, 229, 239'},colors:{left:{touchedColor:'255, 255, 255',touchedColorStop:'255, 255, 255'},right:{touchedColor:'255, 255, 255',touchedColorStop:'255, 255, 255'}},states:{initialized:false,sliding:false,slideReachEnd:false,slidingColorful:false,slidingColorGradientEnd:false,touch:{id:'',touched:false,initX:-1,pageX:-1,pageY:-1,tx:-1,prevX:-1,deltaX:0}},IDs:{overlay:'lockscreen',area:'lockscreen-area',canvas:'lockscreen-canvas',areas:{left:'lockscreen-area-camera',right:'lockscreen-area-unlock'}},resources:{larrow:'/lockscreen/style/images/larrow.png',rarrow:'/lockscreen/style/images/rarrow.png'},resourcesNew:{larrow:'/lockscreen/style/images/lockscreen_toggle_arrow_left.png',rarrow:'/lockscreen/style/images/lockscreen_toggle_arrow_right.png'}};LockScreenSlidePrototype.initialize=function(opts){if(opts){this._overwriteSettings(opts);}
if(opts.useNewStyle){this.track=this.trackNew;this.handle=this.handleNew;this.resources=this.resourcesNew;}
this._initializeCanvas();this.publish('lockscreenslide-unlocker-initializer');this.states.initialized=true;};LockScreenSlidePrototype.reset=function lss_reset(){this._clearCanvas();this._drawTrack();this._resetHandle();this._resetArrows();this._drawIconBG();};LockScreenSlidePrototype._overwriteSettings=function(options){var iterate=function _iterate(opts,settings){for(var property in opts){if(opts.hasOwnProperty(property)){if('object'===typeof opts[property]){iterate(opts[property],settings[property]);}
else{settings[property]=opts[property];}}}};iterate(options,this);};LockScreenSlidePrototype.handleEvent=function(evt){switch(evt.type){case'screenchange':if(evt.detail.screenOffBy=='proximity'){break;}
this._clearCanvas();this._drawTrack();this._resetHandle();this._resetArrows();this._drawIconBG();break;case'touchstart':evt.preventDefault();if(evt.target!==this.area||evt.touches.length>1){return;}
this.states.touch.id=evt.touches[0].identifier;this._onSlideBegin(this._dpx(evt.touches[0].pageX));window.addEventListener('touchend',this);window.addEventListener('touchmove',this);break;case'touchmove':if(evt.touches.length>1){this._endGesture();return;}
this._onTouchMove(this._dpx(evt.touches[0].pageX),this._dpx(evt.touches[0].pageY));if(this.states.sliding){this._onSliding(this._dpx(evt.touches[0].pageX));}
break;case'touchend':if(evt.changedTouches[0].identifier!==this.states.touch.id){return;}
this._endGesture();break;case'click':if(evt.mozInputSource===0){evt.preventDefault();if(this.areas.left===evt.target){this.publish('lockscreenslide-activate-left');}else if(this.areas.right===evt.target){this.publish('lockscreenslide-activate-right');}}
break;}};LockScreenSlidePrototype._initializeCanvas=function lss_initializeCanvas(){this.overlay=document.getElementById(this.IDs.overlay);this.area=document.getElementById(this.IDs.area);this.canvas=document.getElementById(this.IDs.canvas);this.areas.left=document.getElementById(this.IDs.areas.left);this.areas.right=document.getElementById(this.IDs.areas.right);this.area.addEventListener('touchstart',this);this.areas.left.addEventListener('click',this);this.areas.right.addEventListener('click',this);this.layout=(ScreenLayout&&ScreenLayout.getCurrentLayout&&ScreenLayout.getCurrentLayout())?ScreenLayout.getCurrentLayout():'tiny';var center=this.center;this.arrows.left=new Image();this.arrows.right=new Image();var larrow=this.arrows.left;var rarrow=this.arrows.right;larrow.src=this.resources.larrow;rarrow.src=this.resources.rarrow;larrow.onload=(function(){var offset=this.useNewStyle?(this.arrows.left.width+this.handle.radius):(this.arrows.left.width<<1);this.arrows.ldraw.x=center.x-offset;this.arrows.ldraw.y=center.y-(this.arrows.left.height>>1);var ctx=this.canvas.getContext('2d');ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);}).bind(this);rarrow.onload=(function(){var offset=this.useNewStyle?this.handle.radius:this.arrows.right.width;this.arrows.rdraw.x=center.x+offset;this.arrows.rdraw.y=center.y-(this.arrows.right.height>>1);var ctx=this.canvas.getContext('2d');ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);}).bind(this);this.width=this._dpx(window.innerWidth);this.height=this._dpx(80);this.canvas.width=this.width;this.canvas.height=this.height;this.canvas.style.width=window.innerWidth+'px';this.canvas.style.height=80+'px';this.center.x=this.canvas.offsetLeft+this.canvas.width>>1;this.center.y=this.canvas.offsetTop+this.canvas.height>>1;this.handle.radius=this._dpx(this.handle.radius);if(this.useNewStyle){this.handle.innerRadius=this._dpx(this.handle.innerRadius);}
this.track.radius=this.handle.radius+this._dpx(this.useNewStyle?2:1);this.handle.lineWidth=this._dpx(this.handle.lineWidth);this.handle.autoExpand.sentinelOffset=this._dpx(this.handle.autoExpand.sentinelOffset);this.iconBG.radius=this._dpx(this.iconBG.radius);this.canvas.getContext('2d').save();this.canvas.getContext('2d',this.handle.radius<<1,0);var trackLength='tiny'===this.layout?this.track.length.tiny:this.track.length.large;trackLength=this._dpx(trackLength);var maxWidth=(trackLength-
(this.handle.radius<<1))>>1;maxWidth-=2;this.handle.maxWidth=maxWidth;this.handle.autoExpand.sentinelWidth=maxWidth-this.handle.autoExpand.sentinelOffset;this.track.width=trackLength;this.track.from=this.center.x-maxWidth;this.track.to=this.center.x+maxWidth;this.track.y=this.center.y;this._drawTrack();this._drawIconBG();this._resetHandle();this._resetTouchStates();};LockScreenSlidePrototype._finalizeCanvas=function lss_finalizeCanvas(){this.states.slidingColorful=false;this.states.slidingColorGradientEnd=false,this._clearCanvas();};LockScreenSlidePrototype._onSliding=function lss_onSliding(tx){var mtx=this._mapCoord(tx,0)[0];var isLeft=tx-this.center.x<0;this._clearCanvas();var expandSentinelR=this.center.x+
this.handle.autoExpand.sentinelWidth;var expandSentinelL=this.center.x-
this.handle.autoExpand.sentinelWidth;var center=this.center;var radius=this.handle.radius;var ctx=this.canvas.getContext('2d');if(tx>expandSentinelR||tx<expandSentinelL){var prevState=this.handle.autoExpand.accState;this.handle.autoExpand.accState='accelerating';var currentState=this.handle.autoExpand.accState;var slow=false;if(isLeft){slow=this.states.touch.deltaX>0;if(prevState!==currentState)
this.publish('lockscreenslide-near-left',{'currentState':currentState,'prevState':prevState});}else{slow=this.states.touch.deltaX<0;if(prevState!==currentState)
this.publish('lockscreenslide-near-right',{'currentState':currentState,'prevState':prevState});}}else{var prevState=this.handle.autoExpand.accState;this.handle.autoExpand.accState='normal';var currentState=this.handle.autoExpand.accState;if(prevState!==currentState){if(isLeft){if(prevState!==currentState)
this.publish('lockscreenslide-near-left',{'currentState':currentState,'prevState':prevState});}else{if(prevState!==currentState)
this.publish('lockscreenslide-near-right',{'currentState':currentState,'prevState':prevState});}}}
mtx=this._accelerateSlide(tx);this._drawTrack();this._drawArrowsTo(mtx);this._drawIconBG();this._drawSlideTo(mtx);};LockScreenSlidePrototype._onSlideBegin=function lss_onSlideBegin(tx){var canvasCenterX=this.canvas.clientWidth>>1;var center=this.center;var boundaryR=center.x+this.handle.radius;var boundaryL=center.x-this.handle.radius;if(tx>boundaryR||tx<boundaryL){this.states.sliding=false;return;}
this.publish('lockscreenslide-unlocking-start');this.states.touch.initX=tx;this.states.sliding=true;this._lightIcons();};LockScreenSlidePrototype._endGesture=function lss_endGesture(){window.removeEventListener('touchmove',this);window.removeEventListener('touchend',this);this.states.sliding=false;this._onSlideEnd();this._resetTouchStates();this.overlay.classList.remove('touched');this.states.slideReachEnd=false;};LockScreenSlidePrototype._onSlideEnd=function lss_onSlideEnd(){var isLeft=this.states.touch.pageX-this.center.x<0;if(false===this.states.slideReachEnd){this._bounceBack(this.states.touch.pageX);}else{var intention=isLeft?'lockscreenslide-activate-left':'lockscreenslide-activate-right';this.publish(intention);}
this.publish('lockscreenslide-unlocking-stop');this._darkIcons();};LockScreenSlidePrototype._onTouchMove=function ls_handleMove(pageX,pageY){var touch=this.states.touch;if(!touch.touched){if(!this.states.sliding)
return;touch.touched=true;touch.initX=pageX;var overlay=this.overlay;overlay.classList.add('touched');}
touch.tx=pageX-touch.initX;touch.pageX=pageX;if(-1!==touch.pageX){touch.deltaX=pageX-touch.prevX;}
touch.prevX=pageX;};LockScreenSlidePrototype._accelerateSlide=function lss_accelerateSlide(tx){var isLeft=tx-this.center.x<0;var dx=Math.abs(tx-this.center.x);var accFactor=this.handle.autoExpand.accFactor;var acc=Math.pow(dx,accFactor);var accTx=tx+acc;if(isLeft)
accTx=tx-acc;if(accTx<0)
accTx=0;return accTx;};LockScreenSlidePrototype._clearCanvas=function lss_clearCanvas(){var canvas=this.canvas;var ctx=canvas.getContext('2d');ctx.clearRect(0,0,canvas.width,canvas.height);};LockScreenSlidePrototype._bounceBack=function lss_bounceBack(tx,cb){var canvas=this.canvas;var ctx=canvas.getContext('2d');var duration=this.handle.bounceBackTime;var center=this.center;var nextTx=tx;var tsBegin=null;var mspf=0;var interval=1;var isLeft=tx-center.x<0;var drawIt=(function _drawIt(ts){if(null===tsBegin)
tsBegin=ts;if(ts-tsBegin<duration){if(0===mspf)
mspf=ts-tsBegin;interval=Math.abs(center.x-tx)/(duration/mspf);nextTx=isLeft?nextTx+interval:nextTx-interval;if((isLeft&&nextTx<center.x)||(!isLeft&&nextTx>=center.x)){this._clearCanvas();this._drawTrack();this._drawArrowsTo(nextTx);this._drawIconBG();this._drawSlideTo(nextTx);}
requestAnimationFrame(drawIt);}else{this._clearCanvas();this._drawTrack();this._drawArrowsTo(center.x);this._drawIconBG();this._drawSlideTo(center.x);if(cb)
cb();}}).bind(this);requestAnimationFrame(drawIt);};LockScreenSlidePrototype._darkIcons=function lss_darkIcons(){this.areas.left.classList.add('dark');this.areas.right.classList.add('dark');};LockScreenSlidePrototype._drawArrowsTo=function lss_drawArrows(tx){var canvas=this.canvas;var ctx=canvas.getContext('2d');var radius=this.handle.radius;var center=this.center;var offset=tx-center.x;var isLeft=offset<0;var alpha=1-Math.min(1,Math.abs(offset)/this._dpx(30));if(this.handle.maxWidth<Math.abs(offset)){this.states.slideReachEnd=true;return;}
this.states.slideReachEnd=false;if(isLeft){var position=this.useNewStyle?(tx-this.arrows.left.width-this.handle.radius):(tx-(this.arrows.left.width<<1));var oldAlpha=ctx.globalAlpha;ctx.globalAlpha=alpha;ctx.drawImage(this.arrows.left,position,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);ctx.globalAlpha=oldAlpha;ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);}else{var position=this.useNewStyle?(tx+this.handle.radius):(tx+this.arrows.right.width);var oldAlpha=ctx.globalAlpha;ctx.globalAlpha=alpha;ctx.drawImage(this.arrows.right,position,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);ctx.globalAlpha=oldAlpha;ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);}};LockScreenSlidePrototype._drawTrack=function lss_drawTrack(){var canvas=this.canvas;var ctx=canvas.getContext('2d');var radius=this.track.radius;if(this.useNewStyle){var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var draw=(function(fillStyle,strokeStyle){ctx.beginPath();ctx.fillStyle=fillStyle;ctx.strokeStyle=strokeStyle;ctx.lineWidth=this.handle.lineWidth;ctx.moveTo(this.track.from,this.track.y-radius);ctx.lineTo(this.track.to,this.track.y-radius);ctx.arc(this.track.to,this.track.y,radius,startAngle,endAngle,false);ctx.lineTo(this.track.from,this.track.y+radius);ctx.arc(this.track.from,this.track.y,radius,endAngle,startAngle,false);ctx.fill();ctx.closePath();ctx.stroke();}).bind(this);draw(this.track.backColor,'transparent');var gradientStroke=ctx.createLinearGradient(this.track.from-radius,this.track.y-radius,this.track.from-radius,this.track.y+radius);var gradientFill=ctx.createLinearGradient(this.track.from-radius,this.track.y-radius,this.track.from-radius,this.track.y+radius);gradientStroke.addColorStop(0,this.track.strokeColorTop);gradientStroke.addColorStop(1,this.track.strokeColorBottom);gradientFill.addColorStop(0,this.track.fillColorTop);gradientFill.addColorStop(1,this.track.fillColorBottom);draw(gradientFill,gradientStroke);}else{var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var strokeStyle=this.track.color;ctx.fillStyle=this.track.backgroundColor;ctx.lineWidth=this.handle.lineWidth;ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(this.track.from,this.track.y,radius,endAngle,startAngle,false);ctx.lineTo(this.track.from,this.track.y-radius);ctx.lineTo(this.track.to,this.track.y-radius);ctx.arc(this.track.to,this.track.y,radius,startAngle,endAngle,false);ctx.lineTo(this.track.from,this.track.y+radius);ctx.fill();ctx.stroke();ctx.closePath();}};LockScreenSlidePrototype._drawSlideTo=function lss_drawSlideTo(tx){var canvas=this.canvas;var ctx=canvas.getContext('2d');var maxWidth=this.handle.maxWidth;var offset=tx;var radius=this.handle.radius;var center=this.center;var rw=offset-center.x;var urw=Math.abs(rw);if(this.handle.maxWidth<urw){offset=rw>0?center.x+maxWidth:center.x-maxWidth;}
var counterclock=false;if(offset-center.x<0){counterclock=true;}
var isLeft=counterclock;var isLeft=counterclock;var isRight=offset-center.x>0;if(isLeft){this.handle.touchedColor=this.colors.left.touchedColor;this.handle.touchedColorStop=this.colors.left.touchedColorStop;}else if(isRight){this.handle.touchedColor=this.colors.right.touchedColor;this.handle.touchedColorStop=this.colors.right.touchedColorStop;}
var startAngle=1.5*Math.PI;var endAngle=0.5*Math.PI;var fillAlpha=0.0;var strokeStyle='white';const GRADIENT_LENGTH=50;if(this.useNewStyle){if(0===urw){ctx.beginPath();ctx.arc(center.x,center.y,radius,0,2*Math.PI,false);ctx.fillStyle=this.handle.outerColor;ctx.closePath();ctx.fill();ctx.beginPath();ctx.arc(center.x,center.y,this.handle.innerRadius,0,2*Math.PI,false);ctx.fillStyle=this.handle.innerColor;ctx.closePath();ctx.fill();}else{fillAlpha=0.9-Math.min(0.7,(urw/this.handle.maxWidth)*0.7);strokeStyle='transparent';ctx.fillStyle='rgba('+this.handle.touchedColor+', '+
fillAlpha+')';ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(center.x,center.y,radius,endAngle,startAngle,counterclock);ctx.lineTo(center.x,center.y-radius);ctx.lineTo(center.x+(offset-center.x),center.y-radius);ctx.arc(offset,center.y,radius,startAngle,endAngle,counterclock);ctx.lineTo(center.x,center.y+radius);ctx.fill();ctx.stroke();ctx.closePath();}}else{var fillColor;var strokeColor;if(urw>15&&true!==this.states.slidingColorful){fillAlpha=(urw-15)/GRADIENT_LENGTH;if(fillAlpha>1.0){fillAlpha=1.0;this.states.slidingColorGradientEnd=true;}
var borderAlpha=1.0-fillAlpha;strokeStyle='rgba('+this.handle.touchedColorStop+','+borderAlpha+')';this.states.slidingColorful=true;}else{if(0===urw){fillAlpha=this.handle.backgroundAlpha;strokeColor=this.handle.color;fillColor=this.handle.backgroundColor;}else{fillAlpha=(urw-15)/GRADIENT_LENGTH;if(fillAlpha>1.0){fillAlpha=1.0;}
strokeColor=this.handle.touchedColorStop;fillColor=this.handle.touchedColor;}
var borderAlpha=1.0-fillAlpha;strokeStyle='rgba('+strokeColor+','+borderAlpha+')';}
ctx.fillStyle='rgba('+fillColor+','+fillAlpha+')';ctx.lineWidth=this.handle.lineWidth;ctx.strokeStyle=strokeStyle;ctx.beginPath();ctx.arc(center.x,center.y,radius,endAngle,startAngle,counterclock);ctx.lineTo(center.x,center.y-radius);ctx.lineTo(center.x+(offset-center.x),center.y-radius);ctx.arc(offset,center.y,radius,startAngle,endAngle,counterclock);ctx.lineTo(center.x,center.y+radius);ctx.fill();ctx.stroke();ctx.closePath();}};LockScreenSlidePrototype._drawIconBG=function lss_dibg(){if(!this.useNewStyle)
return;var canvas=this.canvas;var ctx=canvas.getContext('2d');ctx.fillStyle=this.iconBG.left.color;ctx.strokeStyle='transparent';ctx.beginPath();ctx.arc(this.track.from,this.track.y,this.iconBG.radius,0,2*Math.PI,false);ctx.stroke();ctx.closePath();ctx.fill();ctx.fillStyle=this.iconBG.right.color;ctx.beginPath();ctx.arc(this.track.to,this.track.y,this.iconBG.radius,0,2*Math.PI,false);ctx.fill();ctx.stroke();ctx.closePath();};LockScreenSlidePrototype._dpx=function lss_dpx(px){return px*window.devicePixelRatio;};LockScreenSlidePrototype._lightIcons=function lss_lightIcons(){this.areas.left.classList.remove('dark');this.areas.right.classList.remove('dark');};LockScreenSlidePrototype._mapCoord=function lss_mapCoord(x,y){var cw=this.canvas.clientWidth;var ch=this.canvas.clientHeight;return[cw*x/window.innerWidth,ch*y/window.innerHeight];};LockScreenSlidePrototype._resetArrows=function lss_restoreArrows(){var canvas=this.canvas;var ctx=canvas.getContext('2d');var center=this.center;ctx.drawImage(this.arrows.left,this.arrows.ldraw.x,this.arrows.ldraw.y,this.arrows.left.width,this.arrows.left.height);ctx.drawImage(this.arrows.right,this.arrows.rdraw.x,this.arrows.rdraw.y,this.arrows.right.width,this.arrows.right.height);};LockScreenSlidePrototype._resetHandle=function lss_resetHandle(){this.states.slidingColorful=false;this.states.slidingColorGradientEnd=false;var canvas=this.canvas;var centerx=this.center.x;this._drawSlideTo(centerx);};LockScreenSlidePrototype._resetTouchStates=function lss_resetTouchStates(){this.states.touch={id:null,touched:false,initX:this.center.x,pageX:this.center.x,pageY:this.center.y,tx:0,prevX:this.center.x,deltaX:0};};LockScreenSlidePrototype.publish=function lss_publish(type,detail){window.dispatchEvent(new CustomEvent(type,{'detail':detail}));};LockScreenSlidePrototype._stop=function lss_stop(){if(this._stopped){return;}
window.removeEventListener('touchmove',this);window.removeEventListener('touchend',this);this.area.removeEventListener('touchstart',this);this._stopped=true;};LockScreenSlidePrototype._start=function lss_stop(){if(!this._stopped){return;}
window.addEventListener('touchmove',this);window.addEventListener('touchend',this);this.area.addEventListener('touchstart',this);this._stopped=false;};LockScreenSlide.prototype=LockScreenSlidePrototype;exports.LockScreenSlide=LockScreenSlide;})(window);;'use strict';(function(exports){var _lockedStateMsgMap={'unknown':'emergencyCallsOnly-unknownSIMState','pinRequired':'emergencyCallsOnly-pinRequired','pukRequired':'emergencyCallsOnly-pukRequired','networkLocked':'emergencyCallsOnly-networkLocked','serviceProviderLocked':'emergencyCallsOnly-serviceProviderLocked','corporateLocked':'emergencyCallsOnly-corporateLocked','network1Locked':'emergencyCallsOnly-network1Locked','network2Locked':'emergencyCallsOnly-network2Locked','hrpdNetworkLocked':'emergencyCallsOnly-hrpdNetworkLocked','ruimCorporateLocked':'emergencyCallsOnly-ruimCorporateLocked','ruimServiceProviderLocked':'emergencyCallsOnly-ruimServiceProviderLocked'};var _NETWORKS_2G=['gsm','gprs','edge'];var LockScreenConnInfoManager=function(root){if(root){this._initialize(root);}};var LockScreenConnInfoManagerPrototype={_connStates:null,_settings:null,_cellbroadcastLabel:null,_telephonyDefaultServiceId:0,_airplaneMode:false};LockScreenConnInfoManagerPrototype._initialize=function lscs_initialize(root){this._connStates=root;this._settings=navigator.mozSettings;this._connStates.hidden=false;SIMSlotManager.getSlots().forEach(function(simslot,index){this._connStates.appendChild(this._createConnStateElement());simslot.conn.addEventListener('voicechange',(function(index){this.updateConnState(simslot);}).bind(this));},this);navigator.mozL10n.ready(this.updateConnStates.bind(this));window.addEventListener('simslot-cardstatechange',(function(evt){this.updateConnState(evt.detail);}).bind(this));window.addEventListener('simslot-iccinfochange',(function(evt){this.updateConnState(evt.detail);}).bind(this));window.addEventListener('cellbroadcastmsgchanged',(function(evt){this._cellbroadcastLabel=evt.detail;this.updateConnStates();}).bind(this));this._settings.addObserver('ril.radio.disabled',(function(evt){this._airplaneMode=evt.settingValue;this.updateConnStates();}).bind(this));this._settings.addObserver('ril.telephony.defaultServiceId',(function(evt){this._telephonyDefaultServiceId=evt.settingValue;this.updateConnStates();}).bind(this));var req=SettingsListener.getSettingsLock().get('ril.radio.disabled');req.onsuccess=(function(){this._airplaneMode=!!req.result['ril.radio.disabled'];var req2=SettingsListener.getSettingsLock().get('ril.telephony.defaultServiceId');req2.onsuccess=(function(){this._telephonyDefaultServiceId=req2.result['ril.telephony.defaultServiceId']||0;this.updateConnStates();}).bind(this);}).bind(this);};LockScreenConnInfoManagerPrototype._createConnStateElement=function lscs_createConnStateElement(){var div=document.createElement('div');var span=document.createElement('span');var line1=document.createElement('span');var line2=document.createElement('span');line1.className=line2.className='connstate-line';div.appendChild(span);div.appendChild(line1);div.appendChild(line2);return div;};LockScreenConnInfoManagerPrototype.updateConnStates=function lscs_updateConnStates(){SIMSlotManager.getSlots().forEach((function(simslot){this.updateConnState(simslot);}).bind(this));};function lineText(node,l10nId,l10nArgs,text){if(!l10nId&&!text){node.setAttribute('data-content',true);}else{node.removeAttribute('data-content');}
if(l10nId){navigator.mozL10n.setAttributes(node,l10nId,l10nArgs);}else{node.removeAttribute('data-l10n-id');if(text){node.textContent=text;}else{node.textContent='';}}}
LockScreenConnInfoManagerPrototype.updateConnState=function lscs_updateConnState(simslot){var conn=simslot.conn;var index=simslot.index;var connstate=this._connStates.children[index];var simIDLine=connstate.children[0];var connstateLines=Array.prototype.slice.call(connstate.querySelectorAll('.connstate-line'));var iccObj=simslot.simCard;var voice=conn.voice;connstate.hidden=false;if(SIMSlotManager.isMultiSIM()){simIDLine.hidden=false;lineText(simIDLine,'lockscreen-sim-id',{n:(index+1)});}else{simIDLine.hidden=true;}
connstateLines.forEach(function(line){lineText(line);});var nextLine=function(){for(var i=0;i<connstateLines.length;i++){var line=connstateLines[i];if(line.hasAttribute('data-content')){return line;}}
return connstateLines[connstateLines.length-1];};if(this._airplaneMode){if(index===0){lineText(nextLine(),'airplaneMode');}else{connstate.hidden=true;}
simIDLine.hidden=true;return;}
if(SIMSlotManager.noSIMCardOnDevice()){if(index===0){if(voice.emergencyCallsOnly){lineText(nextLine(),'emergencyCallsOnly');lineText(nextLine(),'emergencyCallsOnly-noSIM');}else{lineText(nextLine(),'emergencyCallsOnly-noSIM');}}
simIDLine.hidden=true;return;}else if(SIMSlotManager.noSIMCardConnectedToNetwork()){if(index===0){lineText(nextLine(),'emergencyCallsOnly');}
simIDLine.hidden=true;return;}
if(SIMSlotManager.isMultiSIM()&&navigator.mozIccManager.iccIds.length==1&&simslot.isAbsent()){connstate.hidden=true;return;}
if(voice&&'state'in voice&&voice.state=='notSearching'){lineText(nextLine(),'noNetwork');return;}
if(!voice.connected&&!voice.emergencyCallsOnly){lineText(nextLine(),'searching');return;}
if(voice.emergencyCallsOnly){if(this._telephonyDefaultServiceId==index){lineText(nextLine(),'emergencyCallsOnly');lineText(nextLine(),_lockedStateMsgMap[iccObj.cardState]);}else{connstate.hidden=true;}
return;}
var operatorInfos=MobileOperator.userFacingInfo(conn);var operator=operatorInfos.operator;var is2G=_NETWORKS_2G.some(function checkConnectionType(elem){return(conn.voice.type==elem);});var l10nArgs;if(voice.roaming){l10nArgs={operator:operator};lineText(nextLine(),'roaming',l10nArgs);}else{lineText(nextLine(),null,null,operator);}
if(this._cellbroadcastLabel&&is2G){lineText(nextLine(),null,null,this._cellbroadcastLabel);}else if(operatorInfos.carrier){l10nArgs={carrier:operatorInfos.carrier,region:operatorInfos.region};lineText(nextLine(),'operator-info',l10nArgs);}};LockScreenConnInfoManager.prototype=LockScreenConnInfoManagerPrototype;exports.LockScreenConnInfoManager=LockScreenConnInfoManager;})(window);;'use strict';(function(exports){var LockScreenPasscodeValidator=function(){};LockScreenPasscodeValidator.prototype.start=function lspv_start(){this.states={passcode:'0000'};this.configs={listens:['lockscreen-request-passcode-validate']};this.observers={};this.configs.listens.forEach((ename)=>{window.addEventListener(ename,this);});this.observeSettings();};LockScreenPasscodeValidator.prototype.observeSettings=function lspv_observeSettings(){this.observers.passcodeChanged=this.onPasscodeChanged.bind(this);window.SettingsListener.observe('lockscreen.passcode-lock.code','0000',this.observers.passcodeChanged);};LockScreenPasscodeValidator.prototype.handleEvent=function lspv_handleEvent(evt){switch(evt.type){case'lockscreen-request-passcode-validate':this.onValidateRequest(evt.detail);break;}};LockScreenPasscodeValidator.prototype.onValidateRequest=function lspv_onValidateRequest(request){if(this.states.passcode!==request.passcode){request.onerror();}else{request.onsuccess();}};LockScreenPasscodeValidator.prototype.onPasscodeChanged=function lspv_onPasscodeChanged(value){this.states.passcode=value;};LockScreenPasscodeValidator.prototype.unobserveSettings=function lspv_observeSettings(){this.observers.passcodeChanged=window.SettingsListener.unobserve('lockscreen.passcode-lock.code',this.observers.passcodeChanged);};LockScreenPasscodeValidator.prototype.stop=function lspv_stop(){this.configs.listens.forEach((ename)=>{window.removeEventListener(ename,this);});this.unobserveSettings();};exports.LockScreenPasscodeValidator=LockScreenPasscodeValidator;})(window);;;'use strict';var ModalDialog={prefix:'modal-dialog-',elements:{},getAllElements:function md_getAllElements(){var elementsID=['alert','alert-ok','alert-message','prompt','prompt-ok','prompt-cancel','prompt-input','prompt-message','confirm','confirm-ok','confirm-cancel','confirm-message','select-one','select-one-cancel','select-one-menu','select-one-title','alert-title','confirm-title','prompt-title'];var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};elementsID.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=document.getElementById(this.prefix+name);},this);this.screen=document.getElementById('screen');this.overlay=document.getElementById('dialog-overlay');},currentEvents:{},get eventForCurrentOrigin(){var originEvents=this.currentEvents[this.currentOrigin];if(originEvents&&originEvents.length){return originEvents[0];}
return null;},init:function md_init(){this.getAllElements();var elements=this.elements;window.addEventListener('appwillclose',this);window.addEventListener('appterminated',this);window.addEventListener('resize',this);window.addEventListener('keyboardchange',this);window.addEventListener('keyboardhide',this);window.addEventListener('home',this);window.addEventListener('holdhome',this);for(var id in elements){var tagName=elements[id].tagName.toLowerCase();if(tagName=='button'||tagName=='ul'){elements[id].addEventListener('click',this);}}},handleEvent:function md_handleEvent(evt){var elements=this.elements;switch(evt.type){case'click':if(evt.currentTarget===elements.confirmCancel||evt.currentTarget===elements.promptCancel||evt.currentTarget===elements.selectOneCancel){this.cancelHandler();}else if(evt.currentTarget===elements.selectOneMenu){this.selectOneHandler(evt.target);}else{this.confirmHandler();}
break;case'appopen':this.show(evt.target,evt.detail.origin);break;case'home':case'holdhome':if(this.isVisible()){this.cancelHandler();}
break;case'appwillclose':if(evt.detail.origin!==this.currentOrigin){return;}
this.hide();break;case'appterminated':if(this.currentEvents[evt.detail.origin]){delete this.currentEvents[evt.detail.origin];}
break;case'resize':case'keyboardhide':if(!this.currentOrigin){return;}
if(this.isVisible()){this.updateHeight();}
break;case'keyboardchange':if(this.isVisible()){this.updateHeight();}
break;}},processNextEvent:function md_processNextEvent(){var originEvents=this.currentEvents[this.currentOrigin];originEvents.splice(0,1);if(originEvents.length){this.show(null,this.currentOrigin);return;}
delete this.currentEvents[this.currentOrigin];},updateHeight:function sd_updateHeight(){var height=window.layoutManager.height-StatusBar.height;this.overlay.style.height=height+'px';},show:function md_show(target,origin){if(!(origin in this.currentEvents)){return;}
this.currentOrigin=origin;var evt=this.eventForCurrentOrigin;var message=evt.detail.message||'';var title=evt.detail.title||'';var elements=this.elements;this.screen.classList.add('modal-dialog');var type=evt.detail.promptType||evt.detail.type;if(target&&target.dataset.frameType==='window'){title='';}
function localizeElement(node,payload){if(typeof payload==='string'){node.setAttribute('data-l10n-id',payload);return;}
if(typeof payload==='object'){if(payload.raw){node.removeAttribute('data-l10n-id');node.textContent=payload.raw;return;}
if(payload.id){navigator.mozL10n.setAttributes(node,payload.id,payload.args);return;}}}
switch(type){case'alert':localizeElement(elements.alertMessage,message);elements.alert.classList.add('visible');this.setTitle('alert',title);elements.alertOk.setAttribute('data-l10n-id',evt.yesText?evt.yesText:'ok');elements.alert.focus();break;case'prompt':elements.prompt.classList.add('visible');elements.promptInput.value=evt.detail.initialValue;localizeElement(elements.promptMessage,message);this.setTitle('prompt',title);elements.promptOk.setAttribute('data-l10n-id',evt.yesText?evt.yesText:'ok');elements.promptCancel.setAttribute('data-l10n-id',evt.noText?evt.noText:'cancel');elements.prompt.focus();break;case'confirm':elements.confirm.classList.add('visible');localizeElement(elements.confirmMessage,message);this.setTitle('confirm',title);elements.confirmOk.setAttribute('data-l10n-id',evt.yesText?evt.yesText:'ok');elements.confirmCancel.setAttribute('data-l10n-id',evt.noText?evt.noText:'cancel');elements.confirm.focus();break;case'selectone':this.buildSelectOneDialog(message);elements.selectOne.classList.add('visible');elements.selectOne.focus();break;}
this.updateHeight();},hide:function md_hide(){var evt=this.eventForCurrentOrigin;var type=evt.detail.promptType;if(type=='prompt'){this.elements.promptInput.blur();}
this.currentOrigin=null;this.screen.classList.remove('modal-dialog');this.elements[type].classList.remove('visible');},setTitle:function md_setTitle(type,title){this.elements[type+'Title'].setAttribute('data-l10n-id',title);},confirmHandler:function md_confirmHandler(){this.screen.classList.remove('modal-dialog');var elements=this.elements;var evt=this.eventForCurrentOrigin;var type=evt.detail.promptType||evt.detail.type;switch(type){case'alert':elements.alert.classList.remove('visible');break;case'prompt':evt.detail.returnValue=elements.promptInput.value;elements.prompt.classList.remove('visible');break;case'confirm':evt.detail.returnValue=true;elements.confirm.classList.remove('visible');break;}
if(evt.isPseudo&&evt.callback){evt.callback(evt.detail.returnValue);}
if(evt.detail.unblock){evt.detail.unblock();}
this.processNextEvent();},cancelHandler:function md_cancelHandler(){var evt=this.eventForCurrentOrigin;this.screen.classList.remove('modal-dialog');var elements=this.elements;var type=evt.detail.promptType||evt.detail.type;switch(type){case'alert':elements.alert.classList.remove('visible');break;case'prompt':evt.detail.returnValue=null;elements.prompt.classList.remove('visible');break;case'confirm':evt.detail.returnValue=false;elements.confirm.classList.remove('visible');break;case'selectone':evt.detail.returnValue=null;elements.selectOne.classList.remove('visible');break;}
if(evt.isPseudo&&evt.cancelCallback){evt.cancelCallback(evt.detail.returnValue);}
if(evt.detail.unblock){evt.detail.unblock();}
this.processNextEvent();},selectOneHandler:function md_confirmHandler(target){this.screen.classList.remove('modal-dialog');var elements=this.elements;var evt=this.eventForCurrentOrigin;evt.detail.returnValue=target.id;elements.selectOne.classList.remove('visible');if(evt.isPseudo&&evt.callback){evt.callback(evt.detail.returnValue);}
if(evt.detail.unblock){evt.detail.unblock();}
this.processNextEvent();},buildSelectOneDialog:function md_buildSelectOneDialog(data){var elements=this.elements;elements.selectOneTitle.textContent=data.title;elements.selectOneMenu.innerHTML='';if(!data.options){return;}
var itemsHTML=[];for(var i=0;i<data.options.length;i++){itemsHTML.push('<li><button id="');itemsHTML.push(data.options[i].id);itemsHTML.push('">');itemsHTML.push(data.options[i].text);itemsHTML.push('</button></li>');}
elements.selectOneMenu.innerHTML=itemsHTML.join('');},alert:function md_alert(title,text,confirm){this.showWithPseudoEvent({type:'alert',text:text,callback:confirm.callback,title:title,yesText:confirm.title});},confirm:function md_confirm(title,text,confirm,cancel){this.showWithPseudoEvent({type:'confirm',text:text,callback:confirm.callback,cancel:cancel.callback,title:title,yesText:confirm.title,noText:cancel.title});},prompt:function md_prompt(title,text,default_value,confirm,cancel){this.showWithPseudoEvent({type:'prompt',text:text,initialValue:default_value,callback:confirm.callback,cancel:cancel.callback,title:title,yesText:confirm.title,noText:cancel.title});},selectOne:function md_selectOne(data,callback){this.showWithPseudoEvent({type:'selectone',text:data,callback:callback});},showWithPseudoEvent:function md_showWithPseudoEvent(config){var pseudoEvt={isPseudo:true,detail:{unblock:null}};pseudoEvt.detail.title=config.title;pseudoEvt.detail.message=config.text;pseudoEvt.callback=config.callback;pseudoEvt.detail.promptType=config.type;pseudoEvt.cancelCallback=config.cancel;pseudoEvt.yesText=config.yesText;pseudoEvt.noText=config.noText;if(config.type=='prompt'){pseudoEvt.detail.initialValue=config.initialValue;}
if(!this.currentEvents.system){this.currentEvents.system=[];}
this.currentEvents.system.push(pseudoEvt);this.show(null,'system');},isVisible:function md_isVisible(){return this.screen?this.screen.classList.contains('modal-dialog'):false;}};ModalDialog.init();;'use strict';var CarrierInfoNotifier={_sound:'style/notifications/ringtones/notifier_firefox.opus',_notificationId:6000+Math.floor(Math.random()*999),init:function cin_init(){navigator.mozSetMessageHandler('cdma-info-rec-received',this.showCDMA.bind(this));},showCDMA:function cin_showCDMA(message){if(message.display){this.show(message.display,'cdma-record-info');}
if(message.extendedDisplay){var text=message.extendedDisplay.records.map(function(elem){return elem.content;}).join(' ');this.show(text,'cdma-record-info');}},show:function cin_show(message,title){var showDialog=function cin_showDialog(){ModalDialog.showWithPseudoEvent({title:title,text:{raw:message},type:'alert'});};if(!window.Service.locked){this.dispatchEvent('emergencyalert');this.playNotification();showDialog();return;}
var notificationId=++this._notificationId;var notification=NotificationScreen.addNotification({id:notificationId,title:title,text:message});notification.addEventListener('tap',function showDialogAndDismiss(){showDialog();NotificationScreen.removeNotification(notificationId);});},playNotification:function cin_playNotification(){var ringtonePlayer=new Audio();ringtonePlayer.src=this._sound;ringtonePlayer.mozAudioChannelType='notification';ringtonePlayer.play();window.setTimeout(function smsRingtoneEnder(){ringtonePlayer.pause();ringtonePlayer.src='';},2000);},dispatchEvent:function cin_dispatchEvent(name,detail){var evt=document.createEvent('CustomEvent');evt.initCustomEvent(name,true,true,detail);window.dispatchEvent(evt);}};CarrierInfoNotifier.init();;'use strict';(function(exports){function CellBroadcastSystem(){}
CellBroadcastSystem.prototype={_settingsDisabled:[],_settingsKey:'ril.cellbroadcast.disabled',start:function cbs_start(){var self=this;if(navigator&&navigator.mozCellBroadcast){navigator.mozCellBroadcast.onreceived=this.show.bind(this);}
var settings=window.navigator.mozSettings;var req=settings.createLock().get(this._settingsKey);req.onsuccess=function(){self._settingsDisabled=req.result[self._settingsKey];};settings.addObserver(this._settingsKey,this.settingsChangedHandler.bind(this));},settingsChangedHandler:function cbs_settingsChangedHandler(event){this._settingsDisabled=event.settingValue;if(this._hasCBSDisabled()){var evt=new CustomEvent('cellbroadcastmsgchanged',{detail:null});window.dispatchEvent(evt);}},show:function cbs_show(event){var msg=event.message;var serviceId=msg.serviceId||0;var conn=window.navigator.mozMobileConnections[serviceId];var id=msg.messageId;if(id>=4370&&id<4400){return;}
if(conn&&conn.voice.network.mcc===MobileOperator.BRAZIL_MCC&&id===MobileOperator.BRAZIL_CELLBROADCAST_CHANNEL){var evt=new CustomEvent('cellbroadcastmsgchanged',{detail:msg.body});window.dispatchEvent(evt);return;}
var body=msg.body;if(msg.etws&&(!body||(body=='undefined'))){body=navigator.mozL10n.get('cb-etws-warningType-'+
(msg.etws.warningType?msg.etws.warningType:'other'));}
CarrierInfoNotifier.show(body,navigator.mozL10n.get('cb-channel',{channel:id}));},_hasCBSDisabled:function cbs__getDisabledCBSIndex(){var index=this._settingsDisabled.findIndex(disabled=>(disabled===true));return(index>=0);}};exports.CellBroadcastSystem=CellBroadcastSystem;}(window));;var ValuePicker=(function(){function VP(e,unitStyle){this.element=e;this.container=e.parentNode;this._valueDisplayedText=unitStyle.valueDisplayedText;this._unitClassName=unitStyle.className;this._top=0;this._lower=0;this._upper=unitStyle.valueDisplayedText.length-1;this._range=unitStyle.valueDisplayedText.length;this._currentIndex=0;this._unitHeight=0;this.init();}
VP.prototype.getSelectedIndex=function(){var selectedIndex=this._currentIndex;return selectedIndex;};VP.prototype.getSelectedDisplayedText=function(){var displayedText=this._valueDisplayedText[this._currentIndex];return displayedText;};VP.prototype.setSelectedIndex=function(tunedIndex,ignorePicker){if((tunedIndex%1)>0.5){tunedIndex=Math.floor(tunedIndex)+1;}else{tunedIndex=Math.floor(tunedIndex);}
if(tunedIndex<this._lower){tunedIndex=this._lower;}
if(tunedIndex>this._upper){tunedIndex=this._upper;}
var beforeIndex=this._currentIndex;if(this._currentIndex!=tunedIndex){this._currentIndex=tunedIndex;this.onselectedindexchange(this._currentIndex);}
this.updateUI(tunedIndex,ignorePicker);var elementChildren=this.element.children;elementChildren[beforeIndex].classList.remove('selected');elementChildren[this._currentIndex].classList.add('selected');return tunedIndex;};VP.prototype.setSelectedIndexByDisplayedText=function(displayedText){var newIndex=this._valueDisplayedText.indexOf(displayedText);if(newIndex!=-1){if(this._currentIndex!=newIndex){this.setSelectedIndex(newIndex);}}};VP.prototype.setRange=function(lower,upper){if(lower!==null){this._lower=lower;}else{this._lower=0;}
if(upper!==null){this._upper=upper;}else{this._upper=unitStyle.valueDisplayedText.length-1;}
var unitElement=this.element.firstElementChild;var index=0;while(unitElement){unitElement.dataset.disabled=(index<this._lower||index>this._upper);unitElement=unitElement.nextElementSibling;index++;}
this.container.setAttribute('aria-valuemin',this._lower);this.container.setAttribute('aria-valuemax',this._upper);this._range=this._upper-this._lower+1;this.setSelectedIndex(this._currentIndex);};VP.prototype.init=function(){this.initUI();this.setSelectedIndex(0);this.keypressHandler=vp_keypress.bind(this);this.touchstartHandler=vp_touchstart.bind(this);this.touchmoveHandler=vp_touchmove.bind(this);this.touchendHandler=vp_touchend.bind(this);this.addEventListeners();};VP.prototype.initUI=function(){this.container.setAttribute('role','spinbutton');this.container.setAttribute('aria-valuemin',this._lower);this.container.setAttribute('aria-valuemax',this._upper);var unitCount=this._valueDisplayedText.length;for(var i=0;i<unitCount;++i){this.addPickerUnit(i);}};VP.prototype.addPickerUnit=function(index){var content=this._valueDisplayedText[index];var unit=document.createElement('div');unit.className=this._unitClassName;unit.textContent=content;this.element.appendChild(unit);};VP.prototype.updateUI=function(index,ignorePicker){if(true!==ignorePicker){if(this._unitHeight===0){this._unitHeight=this.element.firstChild.clientHeight*this.element.children.length/this._range;}
this._top=-index*this._unitHeight;this.element.style.transform='translateY('+this._top+'px)';this.container.setAttribute('aria-valuenow',index);this.container.setAttribute('aria-valuetext',this._valueDisplayedText[index]);}};VP.prototype.addEventListeners=function(){this.container.addEventListener('keypress',this.keypressHandler,false);this.element.addEventListener('touchstart',this.touchstartHandler,false);};VP.prototype.removeEventListeners=function(){this.element.removeEventListener('touchend',this.touchendHandler,false);this.element.removeEventListener('touchmove',this.touchmoveHandler,false);};VP.prototype.uninit=function(){this._top=0;this.element.removeEventListener('touchstart',this.touchstartHandler,false);this.element.removeEventListener('touchend',this.touchendHandler,false);this.element.removeEventListener('touchmove',this.touchmoveHandler,false);this.element.style.transform='translateY(0px)';this.container.removeEventListener('keypress',this.keypressHandler,false);this.container.removeAttribute('role');this.container.removeAttribute('aria-valuemin');this.container.removeAttribute('aria-valuemax');this.container.removeAttribute('aria-valuenow');this.container.removeAttribute('aria-valuetext');this.onselectedindexchange=null;empty(this.element);};VP.prototype.onselectedindexchange=function(index){};function cloneEvent(evt){return{x:evt.touches[0].pageX,y:evt.touches[0].pageY,timestamp:evt.timeStamp};}
function empty(element){while(element.hasChildNodes()){element.removeChild(element.lastChild);}
element.innerHTML='';}
var SPEED_THRESHOLD=0.1;var currentEvent,startEvent,currentSpeed;var tunedIndex=0;function toFixed(value){return parseFloat(value.toFixed(1));}
function calcSpeed(){var movingSpace=startEvent.y-currentEvent.y;var deltaTime=currentEvent.timestamp-startEvent.timestamp;var speed=movingSpace/deltaTime;currentSpeed=parseFloat(speed.toFixed(2));}
function calcTargetIndex(space){return tunedIndex-getMovingSpace()/space;}
function getMovingSpace(){var movingSpace=currentEvent.y-startEvent.y;var reValue=Math.abs(currentSpeed)>SPEED_THRESHOLD?movingSpace:movingSpace/4;return reValue;}
function vp_touchmove(event){event.stopPropagation();event.target.setCapture(true);currentEvent=cloneEvent(event);calcSpeed();this._top=this._top+getMovingSpace();this.element.style.transform='translateY('+this._top+'px)';tunedIndex=calcTargetIndex(this._unitHeight);var roundedIndex=Math.round(tunedIndex*10)/10;if(roundedIndex!=this._currentIndex){this.setSelectedIndex(toFixed(roundedIndex),true);}
startEvent=currentEvent;}
function vp_touchend(event){event.stopPropagation();this.removeEventListeners();this.element.classList.add('animation-on');if(Math.abs(currentSpeed)>SPEED_THRESHOLD){var direction=currentSpeed>0?1:-1;tunedIndex+=Math.min(Math.abs(currentSpeed)*5,5)*direction;}
tunedIndex=this.setSelectedIndex(toFixed(tunedIndex));currentSpeed=0;}
function vp_touchstart(event){event.stopPropagation();this.element.classList.remove('animation-on');startEvent=currentEvent=cloneEvent(event);tunedIndex=this._currentIndex;this.removeEventListeners();this.element.addEventListener('touchmove',this.touchmoveHandler,false);this.element.addEventListener('touchend',this.touchendHandler,false);}
function vp_keypress(event){if(event.keyCode==KeyEvent.DOM_VK_DOWN){this.setSelectedIndex(this._currentIndex-1);}else{this.setSelectedIndex(this._currentIndex+1);}}
return VP;}());;var SpinDatePicker=(function SpinDatePicker(){'use strict';var GLOBAL_MIN_YEAR=1900;var GLOBAL_MAX_YEAR=2099;var DateRange=(function DateRange(min,max){var _minYear=min.getFullYear();var _maxYear=max.getFullYear();var _minMonth=min.getMonth();var _maxMonth=max.getMonth();var _minDate=min.getDate();var _maxDate=max.getDate();return{get min(){return min;},get max(){return max;},get minYear(){return _minYear;},get maxYear(){return _maxYear;},get minMonth(){return _minMonth;},get maxMonth(){return _maxMonth;},get minDate(){return _minDate;},get maxDate(){return _maxDate;}};});var _dateRange=new DateRange(new Date(GLOBAL_MIN_YEAR,0,1),new Date(GLOBAL_MAX_YEAR,11,31));function getYearText(){var yearText=[];var dateTimeFormat=navigator.mozL10n.DateTimeFormat();for(var i=GLOBAL_MIN_YEAR;i<=GLOBAL_MAX_YEAR;i++){var date=new Date(i,0,1);yearText.push(dateTimeFormat.localeFormat(date,'%Y'));}
return yearText;}
function getMonthText(){var monthText=[];var date=new Date(1970,0,1);var dateTimeFormat=navigator.mozL10n.DateTimeFormat();for(var i=0;i<12;i++){date.setMonth(i);monthText.push(dateTimeFormat.localeFormat(date,'%B'));}
return monthText;}
function getDateText(){var dateText=[];var date=new Date(1970,0,1);var dateTimeFormat=navigator.mozL10n.DateTimeFormat();for(var i=1;i<=31;i++){date.setDate(i);dateText.push(dateTimeFormat.localeFormat(date,'%d'));}
return dateText;}
function getDaysInMonth(year,month){var date=new Date(year,month+1,0);return date.getDate();}
function getDateComponentOrder(){var format=navigator.mozL10n.get('dateTimeFormat_%x');var order='';var tokens=format.match(/(%E.|%O.|%.)/g);if(tokens){tokens.forEach(function(token){switch(token){case'%Y':case'%y':case'%Oy':case'Ey':case'EY':order+='Y';break;case'%B':case'%b':case'%m':case'%Om':order+='M';break;case'%d':case'%e':case'%Od':case'%Oe':order+='D';break;}});}
if(order.length!=3)
order='DMY';return order;}
function SpinDatePicker(element,minDate,maxDate){this.element=element;this.yearPicker=null;this.monthPicker=null;this.datePicker=null;var pickerContainer=element.querySelector('.picker-container');var yearPickerContainer=element.querySelector('.value-picker-year');var monthPickerContainer=element.querySelector('.value-picker-month');var datePickerContainer=element.querySelector('.value-picker-date');var updateCurrentValue=(function spd_updateCurrentValue(){var selectedYear=this.yearPicker.getSelectedIndex()+GLOBAL_MIN_YEAR;var selectedMonth=this.monthPicker.getSelectedIndex();var days=getDaysInMonth(selectedYear,selectedMonth);var selectedDate=this.datePicker.getSelectedIndex()+1;this._value=new Date(selectedYear,selectedMonth,selectedDate);}).bind(this);var updatePickersRange=(function spd_updatePickersRange(){var selectedYear=this.yearPicker.getSelectedIndex()+GLOBAL_MIN_YEAR;var selectedMonth=this.monthPicker.getSelectedIndex();var minMonth=0;var maxMonth=11;var minDate=1;var maxDate=31;if(selectedYear===_dateRange.minYear){minMonth=_dateRange.minMonth;if(selectedMonth===_dateRange.minMonth)
minDate=_dateRange.minDate;}
if(selectedYear===_dateRange.maxYear){maxMonth=_dateRange.maxMonth;if(selectedMonth===_dateRange.maxMonth)
maxDate=_dateRange.maxDate;}
var days=getDaysInMonth(this.yearPicker.getSelectedIndex()+
GLOBAL_MIN_YEAR,this.monthPicker.getSelectedIndex());minDate=Math.min(minDate,days);maxDate=Math.min(maxDate,days);this.monthPicker.setRange(minMonth,maxMonth);this.datePicker.setRange(minDate-1,maxDate-1);}).bind(this);var onvaluechangeInternal=(function spd_onvaluechangeInternal(newDateValue){this.yearPicker.setSelectedIndex(newDateValue.getFullYear()-GLOBAL_MIN_YEAR);this.monthPicker.setSelectedIndex(newDateValue.getMonth());this.datePicker.setSelectedIndex(newDateValue.getDate()-1);updatePickersRange.apply(this);updateCurrentValue.apply(this);}).bind(this);var onSelectedYearChanged=function spd_onSelectedYearChanged(selectedYear){updatePickersRange.apply(this);updateCurrentValue.apply(this);};var onSelectedMonthChanged=function spd_onSelectedMonthChanged(selectedMonth){updatePickersRange.apply(this);updateCurrentValue.apply(this);};var onSelectedDateChanged=function spd_onSelectedDateChanged(selectedDate){updateCurrentValue.apply(this);};var unitClassName='picker-unit';var yearUnitStyle={valueDisplayedText:getYearText(),className:unitClassName};if(this.yearPicker)
this.yearPicker.uninit();this.yearPicker=new ValuePicker(yearPickerContainer,yearUnitStyle);this.yearPicker.onselectedindexchange=onSelectedYearChanged.bind(this);var monthUnitStyle={valueDisplayedText:getMonthText(),className:unitClassName};if(this.monthPicker)
this.monthPicker.uninit();this.monthPicker=new ValuePicker(monthPickerContainer,monthUnitStyle);this.monthPicker.onselectedindexchange=onSelectedMonthChanged.bind(this);var dateUnitStyle={valueDisplayedText:getDateText(),className:unitClassName};if(this.datePicker)
this.datePicker.uninit();this.datePicker=new ValuePicker(datePickerContainer,dateUnitStyle);this.datePicker.onselectedindexchange=onSelectedDateChanged.bind(this);var dateComponentOrder=getDateComponentOrder();var pickerClassList=pickerContainer.classList;pickerClassList.remove('YMD');pickerClassList.remove('DMY');pickerClassList.remove('MDY');pickerClassList.add(dateComponentOrder);this.pickerElements=[monthPickerContainer,yearPickerContainer,datePickerContainer];this.pickerElements.forEach((function pickerElements_forEach(picker){picker.addEventListener('mousedown',this);}).bind(this));this.onvaluechangeInternal=onvaluechangeInternal.bind(this);}
SpinDatePicker.prototype={_value:null,get value(){return this._value;},set value(value){var old=this._value;if(old!==value){this._value=value;this.onvaluechangeInternal(value);}},get year(){return this._value.getFullYear();},get month(){return this._value.getMonth();},get date(){return this._value.getDate();},handleEvent:function vs_handleEvent(evt){switch(evt.type){case'mousedown':evt.preventDefault();break;}},setRange:function vs_setRange(minDate,maxDate){if(!minDate)
minDate=new Date(GLOBAL_MIN_YEAR,0,1);if(!maxDate)
maxDate=new Date(GLOBAL_MAX_YEAR,11,31);_dateRange=new DateRange(minDate,maxDate);this.yearPicker.setRange(minDate.getFullYear()-GLOBAL_MIN_YEAR,maxDate.getFullYear()-GLOBAL_MIN_YEAR);},uninit:function(){if(this.yearPicker)
this.yearPicker.uninit();if(this.monthPicker)
this.monthPicker.uninit();if(this.datePicker)
this.datePicker.uninit();this.pickerElements.forEach((function pickerElements_forEach(picker){picker.removeEventListener('mousedown',this);}).bind(this));},onvaluechangeInternal:function(date){}};return SpinDatePicker;}());;'use strict';(function(exports){var _id=0;function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});}
exports.ValueSelector=function(app){this.app=app;this.containerElement=app.element;this.instanceID=_id++;this._currentPickerType=null;this._currentInputType=null;this._currentDatetimeValue='';this._injected=false;this._datePicker=null;this._timePicker=null;app.element.addEventListener('_opening',this);app.element.addEventListener('_closing',this);app.element.addEventListener('_closed',this);app.element.addEventListener('_inputmethod-contextchange',this);app.element.addEventListener('_localized',this);window.addEventListener('timeformatchange',this);};ValueSelector.prototype=Object.create(BaseUI.prototype);ValueSelector.prototype.CLASS_NAME='ValueSelector';ValueSelector.prototype.ELEMENT_PREFIX='value-selector-';ValueSelector.prototype.EVENT_PREFIX='value-selector-';ValueSelector.prototype.customID=function vs_customID(){if(this.app){return'['+this.app.origin+']';}else{return'';}};ValueSelector.prototype._im=navigator.mozInputMethod;ValueSelector.prototype.destroy=function(){window.removeEventListener('timeformatchange',this);};ValueSelector.prototype.handleEvent=function vs_handleEvent(evt){this.app.debug('handling '+evt.type);var target=evt.target;switch(evt.type){case'submit':case'mousedown':evt.preventDefault();break;case'click':if(target.dataset.type==='cancel'){this.cancel();}else if(target.dataset.type==='ok'){this.confirm();}else{this.handleSelect(target);}
break;case'_opening':case'_closing':case'_closed':if(this._injected){this.hide();}
break;case'_localized':if(this._datePicker){this._datePicker.uninit();this._datePicker=null;}
if(this._timePicker){this._timePicker.uninit();this._timePicker=null;}
break;case'timeformatchange':if(this._timePicker){this._timePicker.uninit();this._timePicker=null;}
break;case'_inputmethod-contextchange':var typesToHandle=['select-one','select-multiple','date','time','datetime','datetime-local','blur'];if(typesToHandle.indexOf(evt.detail.inputType)<0){return;}
if(this._injected){this.show(evt.detail);}else{this.render(function afterRender(){window.requestAnimationFrame(()=>{window.requestAnimationFrame(()=>{this.show(evt.detail);});});}.bind(this));}
break;case'transitionend':this.element.classList.remove('transitioning');break;}};ValueSelector.prototype.render=function vs_render(callback){this.publish('willrender');LazyLoader.load('shared/js/template.js',function onTemplateLoaded(){this.containerElement.insertAdjacentHTML('beforeend',this.view());this._fetchElements();this._registerEvents();this._injected=true;this.publish('rendered');callback();}.bind(this));};ValueSelector.prototype._fetchElements=function vs__fetchElements(){this.element=document.getElementById(this.CLASS_NAME+this.instanceID);this.elements={};this.elementClasses=['select-option-popup','container','options-container','options-title','select-options-buttons','time-picker-popup','time-picker','time-picker-container','time-picker-buttons','spin-date-picker-popup','spin-date-picker','spin-date-picker-buttons'];this.elementClasses.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=this.element.querySelector('.'+this.ELEMENT_PREFIX+name);},this);};ValueSelector.prototype.view=function vs_view(){var template=new Template('value-selector-template');return template.interpolate({id:this.CLASS_NAME+this.instanceID});};ValueSelector.prototype._registerEvents=function vs__registerEvents(){this.elements.container.addEventListener('click',this);this.elements.selectOptionPopup.addEventListener('submit',this);this.element.addEventListener('mousedown',this);this.element.addEventListener('transitionend',this);['selectOptionsButtons','timePickerButtons','spinDatePickerButtons'].forEach(function(elementId){this.elements[elementId].addEventListener('click',this);},this);};ValueSelector.prototype._format=function vs__format(date,format){if(!date){return'';}
date=new Date(date);return date.toLocaleFormat(format);};ValueSelector.prototype.show=function vs_show(detail){var currentInputType=detail.inputType;var currentValue=detail.value;this._currentDatetimeValue=currentValue;this._currentInputType=currentInputType;if(currentInputType==='blur'){this.hide();return;}
this.publish('shown');var min=detail.min;var max=detail.max;if(detail.choices){detail.choices=JSON.parse(detail.choices);}
this.app._setVisibleForScreenReader(false);if(this.element.hidden){this.element.classList.add('transitioning');this.element.hidden=false;}
switch(currentInputType){case'select-one':case'select-multiple':this.app.debug('select triggered'+JSON.stringify(detail));this._currentPickerType=currentInputType;this.showOptions(detail);break;case'date':this.showDatePicker(currentValue,min,max);break;case'time':this.showTimePicker(currentValue);break;case'datetime':case'datetime-local':this.showDatePicker(this._format(currentValue,'%Y-%m-%d'),min,max);break;}};ValueSelector.prototype.showPanel=function vs_showPanel(type){['selectOptionPopup','timePickerPopup','spinDatePickerPopup'].forEach(function(elementId){this.elements[elementId].hidden=(type!==elementId);},this);},ValueSelector.prototype.hide=function vs_hide(){this.app._setVisibleForScreenReader(true);if(this.element.hidden){return;}
this.element.blur();this.element.classList.add('transitioning');this.element.hidden=true;if(this.app.getBottomMostWindow().isActive()&&this.app.isActive()){this.app.focus();}
this.publish('hidden');};ValueSelector.prototype.handleSelect=function vs_handleSelect(target){if(target.dataset===undefined||(target.dataset.optionIndex===undefined&&target.dataset.optionValue===undefined)){return;}
var selectee;if(this._currentPickerType==='select-one'){selectee=this.elements.container.querySelectorAll('[aria-selected="true"]');for(var i=0;i<selectee.length;i++){selectee[i].removeAttribute('aria-selected');}
target.setAttribute('aria-selected','true');}else if(target.getAttribute('aria-selected')==='true'){target.removeAttribute('aria-selected');}else{target.setAttribute('aria-selected','true');}
var singleOptionIndex;var optionIndices=[];selectee=this.elements.container.querySelectorAll('[aria-selected="true"]');if(this._currentPickerType==='select-one'){if(selectee.length>0){singleOptionIndex=selectee[0].dataset.optionIndex;}
this._im.setSelectedOption(singleOptionIndex);}else if(this._currentPickerType==='select-multiple'){for(var i=0;i<selectee.length;i++){var index=parseInt(selectee[i].dataset.optionIndex);optionIndices.push(index);}
this._im.setSelectedOptions(optionIndices);}};ValueSelector.prototype.cancel=function vs_cancel(){this.app.debug('cancel invoked');this._im.removeFocus();this.hide();};ValueSelector.prototype.confirm=function vs_confirm(){var currentInputType=this._currentInputType;switch(currentInputType){case'time':var timeValue=this._timePicker.getTimeValue();this.app.debug('output value: '+timeValue);this._im.setValue(timeValue);break;case'date':var dateValue=this._format(this._datePicker.value,'%Y-%m-%d');this.app.debug('output value: '+dateValue);this._im.setValue(dateValue);break;case'datetime':case'datetime-local':var currentDatetimeValue=this._currentDatetimeValue;if(this._currentPickerType==='date'){this.showTimePicker(this._format(currentDatetimeValue,'%H:%M'));return;}else if(this._currentPickerType==='time'){var selectedDate=this._datePicker.value;var hour=this._timePicker.getHour();var minute=this._timePicker.minute.getSelectedDisplayedText();var second='';var millisecond='';var date=null;if(currentDatetimeValue!==''){date=new Date(this._currentDatetimeValue);}else{date=new Date();}
second=date.getSeconds();millisecond=date.getMilliseconds();selectedDate.setHours(hour);selectedDate.setMinutes(minute);selectedDate.setSeconds(second);selectedDate.setMilliseconds(millisecond);var datetimeValue='';if(currentInputType==='datetime'){datetimeValue=selectedDate.toISOString();}else{datetimeValue=selectedDate.toLocaleFormat('%Y-%m-%dT%H:%M:%S.')+
selectedDate.getMilliseconds();}
this.app.debug('output value: '+datetimeValue);this._im.setValue(datetimeValue);}
break;}
this._im.removeFocus();this.hide();};ValueSelector.prototype.showOptions=function vs_showOptions(detail){var options=null;if(detail.choices&&detail.choices.choices){options=detail.choices.choices;}
if(options){this.buildOptions(options);}
this.showPanel('selectOptionPopup');};ValueSelector.prototype.buildOptions=function(options){if(this.elements.optionsContainer){this.elements.optionsContainer.innerHTML='';}else{return;}
var groupTemplate=new Template('value-selector-groupoption-template');var template=new Template('value-selector-option-template');this.elements.optionsContainer.setAttribute('aria-multiselectable',this._currentPickerType!=='select-one');options.forEach(function(option){if(option.group){this.elements.optionsContainer.insertAdjacentHTML('beforeend',groupTemplate.interpolate({text:option.text}));}else{this.elements.optionsContainer.insertAdjacentHTML('beforeend',template.interpolate({index:option.optionIndex.toString(10),checked:option.selected.toString(),for:'gaia-option-'+option.optionIndex,text:option.text}));}},this);this.elements.container.classList.toggle('scrollable',options.length>5);var titleL10nId=this._currentPickerType==='select-one'?'choose-option':'choose-options';if(this.elements.optionsTitle){this.elements.optionsTitle.dataset.l10nId=titleL10nId;this.elements.optionsTitle.textContent=navigator.mozL10n.get(titleL10nId);}};ValueSelector.prototype.showTimePicker=function vs_showTimePicker(currentValue){this._currentPickerType='time';this.showPanel('timePickerPopup');if(!this._timePicker){this._timePicker=new TimePicker(this.elements.timePickerContainer);}
var time;if(!currentValue){var now=new Date();time={hours:now.getHours(),minutes:now.getMinutes()};}else{time=InputParser.importTime(currentValue);}
if(this._timePicker.is12hFormat){var hour=(time.hours%12);hour=(hour===0)?12:hour;var hour24State=(time.hours>=12)?1:0;this._timePicker.hour.setSelectedIndexByDisplayedText(hour);this._timePicker.hour24State.setSelectedIndex(hour24State);}else{this._timePicker.hour.setSelectedIndex(time.hours);}
this._timePicker.minute.setSelectedIndex(time.minutes);};ValueSelector.prototype._str2Date=function vs__str2Date(str){if(!str){return null;}
var dcs=str.split('-');var date=new Date(dcs[0],parseInt(dcs[1])-1,dcs[2]);if(isNaN(date.getTime())){date=null;}
return date;};ValueSelector.prototype.showDatePicker=function vs_showDatePicker(currentValue,min,max){this._currentPickerType='date';this.showPanel('spinDatePickerPopup');var minDate=null;var maxDate=null;minDate=this._str2Date(min);maxDate=this._str2Date(max);if(!this._datePicker){this._datePicker=new SpinDatePicker(this.elements.spinDatePicker);}
this._datePicker.setRange(minDate,maxDate);var date=new Date();if(currentValue){date=InputParser.formatInputDate(currentValue,'');}
this._datePicker.value=date;};function TimePicker(element){this.element=element;this._fetchElements();var _=navigator.mozL10n.get;var is12hFormat=navigator.mozHour12;var localeTimeFormat=is12hFormat?_('shortTimeFormat12'):_('shortTimeFormat24');var startHour=is12hFormat?1:0;var endHour=is12hFormat?(startHour+12):(startHour+12*2);var unitClassName='picker-unit';this.is12hFormat=is12hFormat;this.hour=new ValuePicker(this.elements.valuePickerHours,{valueDisplayedText:this._setDisplayedText(startHour,endHour),className:unitClassName});this.minute=new ValuePicker(this.elements.valuePickerMinutes,{valueDisplayedText:this._setDisplayedText(0,60,function(value){return(value<10)?'0'+value:value;}),className:unitClassName});if(is12hFormat){this.hour24State=new ValuePicker(this.elements.valuePickerHour24State,{valueDisplayedText:[_('time_am'),_('time_pm')],className:unitClassName});}
var separator=':';var minutesPosition=localeTimeFormat.indexOf('%M');if(minutesPosition>0){separator=localeTimeFormat.substr(minutesPosition-1,1);}
this.elements.hoursMinutesSeparator.textContent=separator;this.setTimePickerStyle();this._registerEvents();}
TimePicker.prototype={_fetchElements:function tp__fetchElements(){this.elements={};this.elementClasses=['value-picker-hours','value-picker-minutes','value-picker-hour24-state','hours-minutes-separator'];this.elementClasses.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=this.element.querySelector('.'+name);},this);},_registerEvents:function tp__registerEvents(){['valuePickerHours','valuePickerMinutes','valuePickerHour24State'].forEach(function(elementId){this.elements[elementId].addEventListener('mousedown',this);},this);},handleEvent:function tp_handleEvent(evt){evt.preventDefault();},_unregisterEvents:function tp__unregisterEvents(){['valuePickerHours','valuePickerMinutes','valuePickerHour24State'].forEach(function(elementId){this.elements[elementId].removeEventListener('mousedown',this);},this);},_setDisplayedText:function tp__setDisplayedText(min,max,format){var list=[];for(var i=min;i<max;++i){list.push(format?format(i):i);}
return list;},uninit:function tp_uninit(){this._unregisterEvents();this.minute.uninit();this.hour.uninit();if(this.hour24State){this.hour24State.uninit();}},setTimePickerStyle:function tp_setTimePickerStyle(){var style='format24h';if(this.is12hFormat){var localeTimeFormat=navigator.mozL10n.get('shortTimeFormat12');var reversedPeriod=(localeTimeFormat.indexOf('%p')<localeTimeFormat.indexOf('%M'));style=(reversedPeriod)?'format12hrev':'format12h';if('format12h'===style){this.element.classList.remove('format12hhrev');this.element.classList.remove('format24h');if(!this.element.classList.contains(style)){this.element.classList.add(style);}}else{this.element.classList.remove('format12h');this.element.classList.remove('format24h');if(!this.element.classList.contains(style)){this.element.classList.add(style);}}}
if('format24h'===style){this.element.classList.remove('format12h');this.element.classList.remove('format12hrev');if(!this.element.classList.contains(style)){this.element.classList.add(style);}}},getHour:function tp_getHours(){var hour=0;if(this.is12hFormat){var hour24Offset=12*this.hour24State.getSelectedIndex();hour=this.hour.getSelectedDisplayedText();hour=(hour==12)?0:hour;hour=hour+hour24Offset;}else{hour=this.hour.getSelectedIndex();}
return hour;},getTimeValue:function tp_getTimeValue(){var hour=this.getHour();var minute=this.minute.getSelectedDisplayedText();return(hour<10?'0':'')+hour+':'+minute;}};})(window);;'use strict';var InputParser=(function(){var InputParser={_dateParts:['year','month','date'],_timeParts:['hours','minutes','seconds'],importTime:function(value){var result={hours:0,minutes:0,seconds:0};if(typeof(value)!=='string'){return result;}
var parts=value.split(':');var part;var partName;var i=0;var len=InputParser._timeParts.length;for(;i<len;i++){partName=InputParser._timeParts[i];part=parts[i];if(part){result[partName]=parseInt(part.slice(0,2),10)||0;}}
return result;},exportTime:function(value){var hour=value.getHours();var minute=value.getMinutes();var second=value.getSeconds();var result='';result+=InputParser.padNumber(hour)+':';result+=InputParser.padNumber(minute)+':';result+=InputParser.padNumber(second);return result;},importDate:function(value){var result={year:0,month:0,date:0};var parts=value.split('-');var part;var partName;var i=0;var len=InputParser._dateParts.length;for(;i<len;i++){partName=InputParser._dateParts[i];part=parts[i];if(part){result[partName]=parseInt(part,10);}}
if(result.month>0){result.month=result.month-1;}
result.date=result.date||1;return result;},exportDate:function(value){var year=value.getFullYear();var month=value.getMonth()+1;var date=value.getDate();var result='';result+=InputParser.padNumber(year)+'-';result+=InputParser.padNumber(month)+'-';result+=InputParser.padNumber(date);return result;},formatInputDate:function(date,time){time=InputParser.importTime(time);date=InputParser.importDate(date);return new Date(date.year,date.month,date.date,time.hours,time.minutes,time.seconds);},padNumber:function(numeric){var value=String(numeric);if(numeric<10){return'0'+value;}
return value;}};return InputParser;}());;'use strict';(function(exports){function TrustedUiValueSelector(context){this.element=context.element;this.screen=document.getElementById('screen');}
exports.TrustedUiValueSelector=TrustedUiValueSelector;TrustedUiValueSelector.prototype=Object.create(window.BaseUI.prototype);TrustedUiValueSelector.prototype.start=function(){window.addEventListener('mozChromeEvent',this);this.active=false;this.render();};TrustedUiValueSelector.prototype.stop=function(){window.removeEventListener('mozChromeEvent',this);this.active=false;};TrustedUiValueSelector.prototype.render=function(){this.valueSelector=new ValueSelector(this);};TrustedUiValueSelector.prototype.handleEvent=function(evt){switch(evt.type){case'mozChromeEvent':if(!this.active||!evt.detail||evt.detail.type!=='inputmethod-contextchange'){return;}
var typesToHandle=['select-one','select-multiple','date','time','datetime','datetime-local','blur'];if(typesToHandle.indexOf(evt.detail.inputType)<0){return;}
evt.stopImmediatePropagation();this.debug('broadcast: for value selector');this.broadcast('inputmethod-contextchange',evt.detail);if(evt.detail.inputType==='blur'){this.screen.classList.remove('dialog');}else{this.screen.classList.add('dialog');}
break;}};TrustedUiValueSelector.prototype._setVisibleForScreenReader=function vso__setVisibleForScreenReader(visible){if(this.trustedUiFrame){this.debug('aria-hidden on TrustedUiFrame:'+!visible);this.trustedUiFrame.setAttribute('aria-hidden',!visible);}};TrustedUiValueSelector.prototype.activate=function(frame){this.active=true;this.trustedUiFrame=frame;};TrustedUiValueSelector.prototype.deactivate=function(){this.active=false;this.trustedUiFrame=null;};}(window));;'use strict';var TrustedUIManager={get currentStack(){if(!this._dialogStacks[this._lastDisplayedApp.origin]){this._dialogStacks[this._lastDisplayedApp.origin]=[];}
return this._dialogStacks[this._lastDisplayedApp.origin];},_dialogStacks:{},_lastDisplayedApp:{},overlay:document.getElementById('dialog-overlay'),popupContainer:document.getElementById('trustedui-container'),popupContainerInner:document.getElementById('trustedui-inner'),container:document.getElementById('trustedui-frame-container'),dialogTitle:document.getElementById('trustedui-title'),screen:document.getElementById('screen'),loadingIcon:document.getElementById('statusbar-loading'),throbber:document.getElementById('trustedui-throbber'),header:document.getElementById('trustedui-header'),errorTitle:document.getElementById('trustedui-error-title'),errorMessage:document.getElementById('trustedui-error-message'),errorClose:document.getElementById('trustedui-error-close'),hasTrustedUI:function trui_hasTrustedUI(origin){return(this._dialogStacks[origin]&&this._dialogStacks[origin].length);},getDialogFromOrigin:function trui_getDialogFromOrigin(origin){if(!origin||!this.hasTrustedUI(origin))
return false;var stack=this._dialogStacks[origin];return stack[stack.length-1];},start:function trui_start(){window.addEventListener('home',this);window.addEventListener('holdhome',this);window.addEventListener('appwillopen',this);window.addEventListener('appopen',this);window.addEventListener('appwillclose',this);window.addEventListener('appcreated',this);window.addEventListener('appterminated',this);window.addEventListener('keyboardhide',this);window.addEventListener('keyboardchange',this);this.header.addEventListener('action',this);this.errorClose.addEventListener('click',this);var context={element:document.getElementById('dialog-overlay')};this.valueSelector=new TrustedUiValueSelector(context);this.valueSelector.start();},stop:function trui_stop(){window.removeEventListener('home',this);window.removeEventListener('holdhome',this);window.removeEventListener('appwillopen',this);window.removeEventListener('appopen',this);window.removeEventListener('appwillclose',this);window.removeEventListener('appcreated',this);window.removeEventListener('appterminated',this);window.removeEventListener('keyboardhide',this);window.removeEventListener('keyboardchange',this);this.header.removeEventListener('action',this);this.errorClose.removeEventListener('click',this);},open:function trui_open(name,frame,chromeEventId,onCancelCB){screen.mozLockOrientation('portrait');this._hideAllFrames();if(this.currentStack.length){this._makeDialogHidden(this._getTopDialog());return this._pushNewDialog(name,frame,chromeEventId,onCancelCB);}else{this.popupContainer.classList.add('up');this.popupContainer.classList.remove('closing');return this._hideCallerApp(this._lastDisplayedApp).then((function(){this.popupContainer.classList.remove('up');return this._pushNewDialog(name,frame,chromeEventId,onCancelCB);}).bind(this));}},close:function trui_close(chromeEventId,callback,origin){var stackSize=origin?this._dialogStacks[origin].length:this.currentStack.length;this._restoreOrientation();if(callback){callback();}
if(stackSize===0){return;}else if(stackSize===1){var self=this;var container=this.popupContainer;if(!taskManager.isShown()){if(!origin){this._restoreCallerApp(this._lastDisplayedApp);}
container.addEventListener('transitionend',function wait(event){this.removeEventListener('transitionend',wait);self._closeDialog(chromeEventId,origin);});}else{if(!origin){this._restoreCallerApp(this._lastDisplayedApp);}
this._closeDialog(chromeEventId,origin);}
this._hide();window.focus();}else{this._closeDialog(chromeEventId,origin);}},isVisible:function trui_show(){return this.screen.classList.contains('trustedui');},_hideTrustedApp:function trui_hideTrustedApp(){var self=this;this.popupContainer.classList.add('closing');this.popupContainer.addEventListener('transitionend',function hide(){this.removeEventListener('transitionend',hide);self._hide();});},_reopenTrustedApp:function trui_reopenTrustedApp(){this._hideAllFrames();var dialog=this._getTopDialog();this._makeDialogVisible(dialog);this.popupContainer.classList.add('closing');this._show();this.popupContainer.classList.remove('closing');},_hideCallerApp:function trui_hideCallerApp(app){return new Promise((function(resolve){this.publish('trusteduishow',{origin:app.origin});var frame=app.frame;frame.classList.add('back');frame.classList.remove('restored');frame.addEventListener('transitionend',function execCallback(){frame.style.visibility='hidden';frame.removeEventListener('transitionend',execCallback);resolve();});}).bind(this));},publish:function trui_publish(evtName,detail){var evt=new CustomEvent(evtName,{bubbles:true,cancelable:true,detail:detail});window.dispatchEvent(evt);},_restoreCallerApp:function trui_restoreCallerApp(app){var frame=app.frame;frame.style.visibility='visible';frame.classList.remove('back');if(!Service.currentApp.isHomescreen){this.publish('trusteduihide',{origin:app.origin});}
if(Service.currentApp.origin==app.origin){frame.classList.add('restored');frame.addEventListener('transitionend',function removeRestored(){frame.removeEventListener('transitionend',removeRestored);frame.classList.remove('restored');});}},_dispatchCloseEvent:function dispatchCloseEvent(eventId){if(!eventId){return;}
var event=document.createEvent('customEvent');var details={id:eventId,type:'cancel',errorMsg:'DIALOG_CLOSED_BY_USER'};event.initCustomEvent('mozContentEvent',true,true,details);window.dispatchEvent(event);},_getTopDialog:function trui_getTopDialog(origin){if(origin){var stack=this._dialogStacks[origin];return stack[stack.length-1];}
return this.currentStack[this.currentStack.length-1];},_pushNewDialog:function trui_PushNewDialog(name,frame,chromeEventId,onCancelCB){return new Promise((function(resolve){var dataset=frame.dataset;dataset.frameType='popup';dataset.frameName=frame.name;dataset.frameOrigin=this._lastDisplayedApp.origin;this.mozBrowserEventHandler=this.handleBrowserEvent.bind(this);frame.addEventListener('mozbrowsererror',this.mozBrowserEventHandler);frame.addEventListener('mozbrowserclose',this.mozBrowserEventHandler);frame.addEventListener('mozbrowserloadstart',this.mozBrowserEventHandler);frame.addEventListener('mozbrowserloadend',this.mozBrowserEventHandler);var dialog={name:name,frame:frame,chromeEventId:chromeEventId,onCancelCB:onCancelCB};this.currentStack.push(dialog);this.dialogTitle.textContent=dialog.name;this.container.appendChild(dialog.frame);resolve();this._makeDialogVisible(dialog);}).bind(this));},_makeDialogVisible:function trui_makeDialogVisible(dialog){this.popupContainer.classList.remove('closing');this._show();dialog.frame.classList.add('selected');this.dialogTitle.textContent=dialog.name;},_makeDialogHidden:function trui_makeDialogHidden(dialog){if(!dialog)
return;this._restoreOrientation();dialog.frame.classList.remove('selected');},_restoreOrientation:function trui_restoreOrientation(){window.dispatchEvent(new Event('trusteduiclose'));},_closeDialog:function trui_closeDialog(chromeEventId,origin){var stack=origin?this._dialogStacks[origin]:this.currentStack;if(stack.length===0){return;}
var found=false;for(var i=0;i<stack.length;i++){if(stack[i].chromeEventId===chromeEventId){var frame=stack.splice(i,1)[0].frame;frame.removeEventListener('mozbrowserloadstart',this.mozBrowserEventHandler);frame.removeEventListener('mozbrowserloadend',this.mozBrowserEventHandler);frame.removeEventListener('mozbrowsererror',this.mozBrowserEventHandler);frame.removeEventListener('mozbrowserclose',this.mozBrowserEventHandler);this.container.removeChild(frame);found=true;break;}}
if(found&&stack.length){this._makeDialogVisible(this._getTopDialog());}},_hide:function trui_hide(){this.screen.classList.remove('trustedui');this.valueSelector.deactivate();},_show:function trui_show(){this.screen.classList.add('trustedui');var topFrame=this._getTopDialog().frame;this.valueSelector.activate(topFrame);},_setHeight:function trui_setHeight(height){if(this.isVisible()){this.overlay.style.height=height+'px';}},_destroyDialog:function trui_destroyDialog(origin){var stack=this.currentStack;if(origin){stack=this._dialogStacks[origin];}
if(stack.length===0)
return;for(var i=0,toClose=stack.length;i<toClose;i++){var dialog=this._getTopDialog(origin);this._dispatchCloseEvent(dialog.chromeEventId);this.close(dialog.chromeEventId,dialog.onCancelCB,origin);}
this._hide();this.popupContainer.classList.remove('closing');},_hideAllFrames:function trui_hideAllFrames(){var selectedFrames=this.container.querySelectorAll('iframe.selected');for(var i=0;i<selectedFrames.length;i++){selectedFrames[i].classList.remove('selected');}},_showError:function trui_showError(errorProperty){var dialog=this._getTopDialog();var frame=dialog.frame;if(!('error'in frame.dataset)){this.container.classList.remove('error');return;}
var name=dialog.name;navigator.mozL10n.setAttributes(this.errorTitle,'error-title',{name:name});navigator.mozL10n.setAttributes(this.errorTitle,errorProperty,{name:name});this.container.classList.add('error');},handleEvent:function trui_handleEvent(evt){switch(evt.type){case'home':case'holdhome':if(!this.isVisible()){return;}
this._hideTrustedApp();break;case'action':case'click':this.container.classList.remove('error');this._destroyDialog();break;case'appterminated':this._destroyDialog(evt.detail.origin);break;case'appcreated':if(!this._dialogStacks[evt.detail.origin]){this._dialogStacks[evt.detail.origin]=[];}
break;case'appwillopen':var app=evt.detail;if(this.isVisible()){this._hideTrustedApp();}
if(app.isHomescreen){return;}
this._lastDisplayedApp=app;if(this.currentStack.length){this.popupContainer.classList.remove('up');this._makeDialogVisible(this._getTopDialog());this._hideCallerApp(this._lastDisplayedApp);this._reopenTrustedApp();}
break;case'appopen':if(this.currentStack.length){screen.mozLockOrientation('portrait');}
break;case'appwillclose':if(this.isVisible())
return;var dialog=this._getTopDialog();this._makeDialogHidden(dialog);this._hide();break;case'keyboardchange':var keyboardHeight=inputWindowManager.getHeight();this._setHeight(window.innerHeight-StatusBar.height-keyboardHeight);break;case'keyboardhide':this._setHeight(window.innerHeight-StatusBar.height);break;}},handleBrowserEvent:function trui_handleBrowserEvent(evt){switch(evt.type){case'mozbrowserloadstart':TrustedUIManager.throbber.classList.add('loading');break;case'mozbrowserloadend':TrustedUIManager.throbber.classList.remove('loading');break;case'mozbrowsererror':this._getTopDialog().frame.dataset.error=true;this._showError('crash-banner-app');break;case'mozbrowserclose':this.container.classList.remove('error');this._destroyDialog();break;}}};;'use strict';(function(exports){function PermissionManager(){}
PermissionManager.prototype={currentOrigin:undefined,permissionType:undefined,currentPermissions:undefined,currentChoices:{},isFullscreenRequest:false,isVideo:false,isAudio:false,isCamSelector:false,responseStatus:undefined,pending:[],currentRequestId:undefined,start:function pm_start(){this.overlay=document.getElementById('permission-screen');this.dialog=document.getElementById('permission-dialog');this.title=document.getElementById('permission-title');this.message=document.getElementById('permission-message');this.moreInfo=document.getElementById('permission-more-info');this.moreInfoLink=document.getElementById('permission-more-info-link');this.hideInfoLink=document.getElementById('permission-hide-info-link');this.moreInfoBox=document.getElementById('permission-more-info-box');this.buttons=document.getElementById('permission-buttons');this.yes=document.getElementById('permission-yes');this.no=document.getElementById('permission-no');this.remember=document.getElementById('permission-remember-checkbox');this.rememberSection=document.getElementById('permission-remember-section');this.deviceSelector=document.getElementById('permission-device-selector');this.devices=document.getElementById('permission-devices');var self=this;this.rememberSection.addEventListener('click',function onLabelClick(){self.remember.checked=!self.remember.checked;});window.addEventListener('mozChromeEvent',this);window.addEventListener('attentionopening',this);window.addEventListener('attentionopened',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('screenchange',this);this.discardPermissionRequest=this.discardPermissionRequest.bind(this);window.addEventListener('home',this.discardPermissionRequest);window.addEventListener('holdhome',this.discardPermissionRequest);window.addEventListener('appterminated',(function(evt){if(evt.detail.origin==this.currentOrigin){this.discardPermissionRequest();}}).bind(this));this.overlay.addEventListener('mousedown',function onMouseDown(evt){evt.preventDefault();});},getStrings:function getStrings(detail){var _=navigator.mozL10n.get;if(this.isFullscreenRequest){var fullscreenMessage=_('fullscreen-request',{'origin':detail.fullscreenorigin})||'';return{message:fullscreenMessage,moreInfoText:null};}
var permissionID='perm-'+this.permissionType.replace(':','-');var app=applications.getByManifestURL(detail.manifestURL);var message='';if(detail.isApp){var appName=new ManifestHelper(app.manifest).name;message=_(permissionID+'-appRequest',{'app':appName});}else{message=_(permissionID+'-webRequest',{'site':detail.origin});}
var moreInfoText=_(permissionID+'-more-info')||null;return{message:message,moreInfoText:moreInfoText};},stop:function pm_stop(){this.currentOrigin=null;this.permissionType=null;this.currentPermissions=null;this.currentChoices={};this.fullscreenRequest=null;this.isVideo=false;this.isAudio=false;this.isCamSelector=false;this.responseStatus=null;this.pending=[];this.currentRequestId=null;this.overlay=null;this.dialog=null;this.title=null;this.message=null;this.moreInfo=null;this.moreInfoLink=null;this.moreInfoBox=null;this.remember=null;this.rememberSection=null;this.deviceSelector=null;this.devices=null;this.buttons=null;this.yes=null;this.no=null;window.removeEventListener('mozChromeEvent',this);window.removeEventListener('attentionopening',this);window.removeEventListener('attentionopened',this);window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('screenchange',this);window.removeEventListener('home',this.discardPermissionRequest);window.removeEventListener('holdhome',this.discardPermissionRequest);},cleanDialog:function pm_cleanDialog(){delete this.overlay.dataset.type;this.permissionType=undefined;this.currentPermissions=undefined;this.currentChoices={};this.isVideo=false;this.isAudio=false;this.isCamSelector=false;if(this.message.classList.contains('hidden')){this.message.classList.remove('hidden');}
if(!this.moreInfoBox.classList.contains('hidden')){this.moreInfoBox.classList.add('hidden');}
this.devices.innerHTML='';if(!this.deviceSelector.classList.contains('hidden')){this.deviceSelector.classList.add('hidden');}
this.buttons.dataset.items=2;this.no.style.display='inline';},queuePrompt:function(detail){this.pending.push(detail);},handleEvent:function pm_handleEvent(evt){var detail=evt.detail;switch(detail.type){case'permission-prompt':if(!!this.currentRequestId){this.queuePrompt(detail);return;}
this.handlePermissionPrompt(detail);break;case'cancel-permission-prompt':this.discardPermissionRequest();break;case'fullscreenoriginchange':delete this.overlay.dataset.type;this.cleanDialog();this.handleFullscreenOriginChange(detail);break;}
switch(evt.type){case'attentionopened':case'attentionopening':if(this.currentOrigin!==evt.detail.origin){this.discardPermissionRequest();}
break;case'lockscreen-appopened':if(this.currentRequestId=='fullscreen'){this.discardPermissionRequest();}
break;case'screenchange':if(Service.locked&&!detail.screenEnabled){this.discardPermissionRequest();}
break;}},optionClickhandler:function pm_optionClickhandler(evt){var link=evt.target;if(!link){return;}
if(link.classList.contains('input-enable')){if(link.checked){this.currentChoices['video-capture']=link.id;}
var items=this.devices.querySelectorAll('input[type="checkbox"]');for(var i=0;i<items.length;i++){if(items[i].id!==link.id){items[i].checked=false;items[i].disabled=false;}else{link.disabled=true;}}}},handleFullscreenOriginChange:function pm_handleFullscreenOriginChange(detail){if(this.isFullscreenRequest){this.cancelRequest(this.currentRequestId);this.isFullscreenRequest=false;}
if(detail.fullscreenorigin!==Service.currentApp.origin){this.isFullscreenRequest=true;detail.id='fullscreen';this.showPermissionPrompt(detail,function foo(){},function(){document.mozCancelFullScreen();});}},handlePermissionPrompt:function pm_handlePermissionPrompt(detail){this.cleanDialog();this.isFullscreenRequest=false;this.currentOrigin=detail.origin;this.currentRequestId=detail.id;if(detail.permissions){if('video-capture'in detail.permissions){this.isVideo=true;LazyLoader.load('shared/js/template.js');if(detail.isApp&&detail.isGranted&&detail.permissions['video-capture'].length>1){this.isCamSelector=true;}}
if('audio-capture'in detail.permissions){this.isAudio=true;}}else{if(detail.permission){this.permissionType=detail.permission;if('video-capture'===detail.permission){this.isVideo=true;LazyLoader.load('shared/js/template.js');}
if('audio-capture'===detail.permission){this.isAudio=true;}}}
if(this.isVideo&&this.isAudio){this.permissionType='media-capture';}else{if(detail.permission){this.permissionType=detail.permission;}else if(detail.permissions){this.permissionType=Object.keys(detail.permissions)[0];}}
this.overlay.dataset.type=this.permissionType;if(this.isAudio||this.isVideo){if(!detail.isApp){this.rememberSection.style.display='none';}else{this.rememberSection.style.display='block';}
this.currentPermissions=detail.permissions;for(var permission2 in detail.permissions){if(detail.permissions.hasOwnProperty(permission2)){if(detail.permissions[permission2].length>0){this.currentChoices[permission2]=detail.permissions[permission2][0];}}}}
if((this.isAudio||this.isVideo)&&!detail.isApp&&!this.isCamSelector){this.remember.checked=false;}else{this.remember.checked=detail.remember?true:false;}
if(detail.isApp){var app=applications.getByManifestURL(detail.manifestURL);if(this.isCamSelector){this.title.setAttribute('data-l10n-id','title-cam');}else{this.title.setAttribute('data-l10n-id','title-app');}
navigator.mozL10n.setAttributes(this.deviceSelector,'perm-camera-selector-appRequest',{'app':new ManifestHelper(app.manifest).name});}else{this.title.setAttribute('data-l10n-id','title-web');navigator.mozL10n.setAttributes(this.deviceSelector,'perm-camera-selector-webRequest',{'site':detail.origin});}
var self=this;this.showPermissionPrompt(detail,function pm_permYesCB(){self.dispatchResponse(detail.id,'permission-allow',self.remember.checked);},function pm_permNoCB(){self.dispatchResponse(detail.id,'permission-deny',self.remember.checked);});},dispatchResponse:function pm_dispatchResponse(id,type,remember){if(this.isCamSelector){remember=true;}
this.responseStatus=type;var response={id:id,type:type,remember:remember};if(this.isVideo||this.isAudio||this.isCamSelector){response.choices=this.currentChoices;}
var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,response);window.dispatchEvent(event);},hidePermissionPrompt:function pm_hidePermissionPrompt(){this.overlay.classList.remove('visible');this.devices.removeEventListener('click',this);this.devices.classList.remove('visible');this.currentRequestId=undefined;this.yes.removeEventListener('click',this.yesHandler);this.yes.callback=null;this.no.removeEventListener('click',this.noHandler);this.no.callback=null;this.moreInfo.classList.add('hidden');this.moreInfoLink.removeEventListener('click',this.moreInfoHandler);this.hideInfoLink.removeEventListener('click',this.hideInfoHandler);if(!this.hideInfoLink.classList.contains('hidden')){this.toggleInfo();}
this.publish('permissiondialoghide');},publish:function(eventName,detail){var event=document.createEvent('CustomEvent');event.initCustomEvent(eventName,true,true,detail);window.dispatchEvent(event);},showNextPendingRequest:function pm_showNextPendingRequest(){if(this.pending.length===0){return;}
var request=this.pending.shift();if((this.currentOrigin===request.origin)&&(this.permissionType===Object.keys(request.permissions)[0])){this.dispatchResponse(request.id,this.responseStatus,this.remember.checked);this.showNextPendingRequest();return;}
this.handlePermissionPrompt(request);},clickHandler:function pm_clickHandler(evt){var callback=null;if(evt.target===this.yes&&this.yes.callback){callback=this.yes.callback;this.responseStatus='permission-allow';}else if(evt.target===this.no&&this.no.callback){callback=this.no.callback;this.responseStatus='permission-deny';}else if(evt.target===this.moreInfoLink||evt.target===this.hideInfoLink){this.toggleInfo();return;}
this.hidePermissionPrompt();if(callback){window.setTimeout(callback,0);}
this.showNextPendingRequest();},toggleInfo:function pm_toggleInfo(){this.moreInfoLink.classList.toggle('hidden');this.hideInfoLink.classList.toggle('hidden');this.moreInfoBox.classList.toggle('hidden');},listDeviceOptions:function pm_listDeviceOptions(){var _=navigator.mozL10n.get;var self=this;var template=new Template('device-list-item-tmpl');var checked;this.deviceSelector.classList.remove('hidden');this.currentPermissions['video-capture'].forEach(function(option){checked=(self.currentChoices['video-capture']===option)?'checked=true disabled=true':'';if(checked){self.currentChoices['video-capture']=option;}
var item_li=document.createElement('li');item_li.className='device-cell';item_li.innerHTML=template.interpolate({id:option,checked:checked,label:_('device-'+option)});self.devices.appendChild(item_li);});this.devices.addEventListener('click',this.optionClickhandler.bind(this));this.devices.classList.add('visible');},showPermissionPrompt:function pm_showPermissionPrompt(detail,yescallback,nocallback){var text=this.getStrings(detail);this.message.textContent=text.message;if(text.moreInfoText&&text.moreInfoText&&text.moreInfoText.length>0){this.moreInfo.classList.remove('hidden');this.moreInfoHandler=this.clickHandler.bind(this);this.hideInfoHandler=this.clickHandler.bind(this);this.moreInfoLink.addEventListener('click',this.moreInfoHandler);this.hideInfoLink.addEventListener('click',this.hideInfoHandler);this.moreInfoBox.textContent=text.moreInfoText;}
this.currentRequestId=detail.id;if(this.isVideo&&this.currentPermissions['video-capture'].length>1){this.listDeviceOptions();}
var isSharedPermission=this.isVideo||this.isAudio||this.permissionType==='geolocation';this.yes.setAttribute('data-l10n-id',isSharedPermission?'share-'+this.permissionType:'allow');this.yesHandler=this.clickHandler.bind(this);this.yes.addEventListener('click',this.yesHandler);this.yes.callback=yescallback;this.no.setAttribute('data-l10n-id',isSharedPermission?'dontshare-'+this.permissionType:'dontallow');this.noHandler=this.clickHandler.bind(this);this.no.addEventListener('click',this.noHandler);this.no.callback=nocallback;if(this.isCamSelector){this.message.classList.add('hidden');this.rememberSection.style.display='none';this.buttons.dataset.items=1;this.no.style.display='none';this.yes.setAttribute('data-l10n-id','ok');}
this.overlay.classList.add('visible');},cancelRequest:function pm_cancelRequest(id){if(this.currentRequestId===id){this.hidePermissionPrompt();this.showNextPendingRequest();}else{for(var i=0;i<this.pending.length;i++){if(this.pending[i].id===id){this.pending.splice(i,1);break;}}}},discardPermissionRequest:function pm_discardPermissionRequest(){if(this.currentRequestId===undefined||this.currentRequestId===null){return;}
if(this.currentRequestId=='fullscreen'){if(this.no.callback){this.no.callback();}
this.isFullscreenRequest=false;}else{this.dispatchResponse(this.currentRequestId,'permission-deny',false);}
this.hidePermissionPrompt();this.pending=[];}};exports.PermissionManager=PermissionManager;})(window);;'use strict';var AppInstallManager={mapDownloadErrorsToMessage:{'NETWORK_ERROR':'download-failed','DOWNLOAD_ERROR':'download-failed','MISSING_MANIFEST':'install-failed','INVALID_MANIFEST':'install-failed','INSTALL_FROM_DENIED':'install-failed','INVALID_SECURITY_LEVEL':'install-failed','INVALID_PACKAGE':'install-failed','APP_CACHE_DOWNLOAD_ERROR':'download-failed'},init:function ai_init(){this.systemBanner=new SystemBanner();this.dialog=document.getElementById('app-install-dialog');this.msg=document.getElementById('app-install-message');this.size=document.getElementById('app-install-size');this.authorName=document.getElementById('app-install-author-name');this.authorUrl=document.getElementById('app-install-author-url');this.installButton=document.getElementById('app-install-install-button');this.cancelButton=document.getElementById('app-install-cancel-button');this.imeLayoutDialog=document.getElementById('ime-layout-dialog');this.imeListTemplate=document.getElementById('ime-list-template');this.imeList=document.getElementById('ime-list');this.imeCancelButton=document.getElementById('ime-cancel-button');this.imeConfirmButton=document.getElementById('ime-confirm-button');this.setupCancelButton=document.getElementById('setup-cancel-button');this.setupConfirmButton=document.getElementById('setup-confirm-button');this.installCancelDialog=document.getElementById('app-install-cancel-dialog');this.downloadCancelDialog=document.getElementById('app-download-cancel-dialog');this.setupInstalledAppDialog=document.getElementById('setup-installed-app-dialog');this.confirmCancelButton=document.getElementById('app-install-confirm-cancel-button');this.setupAppName=document.getElementById('setup-app-name');this.setupAppDescription=document.getElementById('setup-app-description');this.resumeButton=document.getElementById('app-install-resume-button');this.notifContainer=document.getElementById('install-manager-notification-container');this.appInfos={};this.setupQueue=[];this.isSetupInProgress=false;window.addEventListener('mozChromeEvent',(function ai_handleChromeEvent(e){if(e.detail.type=='webapps-ask-install'){this.handleAppInstallPrompt(e.detail);}
if(e.detail.type=='webapps-ask-uninstall'){this.handleAppUninstallPrompt(e.detail);}}).bind(this));window.addEventListener('applicationinstall',this.handleApplicationInstall.bind(this));window.addEventListener('applicationuninstall',this.handleApplicationUninstall.bind(this));this.installButton.onclick=this.handleInstall.bind(this);this.cancelButton.onclick=this.showInstallCancelDialog.bind(this);this.confirmCancelButton.onclick=this.handleInstallCancel.bind(this);this.resumeButton.onclick=this.hideInstallCancelDialog.bind(this);this.notifContainer.onclick=this.showDownloadCancelDialog.bind(this);this.downloadCancelDialog.querySelector('.confirm').onclick=this.handleConfirmDownloadCancel.bind(this);this.downloadCancelDialog.querySelector('.cancel').onclick=this.handleCancelDownloadCancel.bind(this);this.setupCancelButton.onclick=this.handleSetupCancelAction.bind(this);this.setupConfirmButton.onclick=this.handleSetupConfirmAction.bind(this);this.imeCancelButton.onclick=this.hideIMEList.bind(this);this.imeConfirmButton.onclick=this.handleImeConfirmAction.bind(this);LazyLoader.load(['shared/js/template.js','shared/js/homescreens/confirm_dialog_helper.js']);['handleDownloadSuccess','handleDownloadError','handleProgress','handleApplicationReady'].forEach(function(name){this[name]=this[name].bind(this);},this);window.addEventListener('applicationready',this.handleApplicationReady);window.addEventListener('home',this.cancelInstallation.bind(this));window.addEventListener('holdhome',this.cancelInstallation.bind(this));},cancelInstallation:function ai_cancelInstallation(){this.dialog.classList.remove('visible');this.dispatchPromptEvent('hidden');this.handleInstallCancel();if(this.setupInstalledAppDialog.classList.contains('visible')){this.handleSetupCancelAction();}
if(this.imeLayoutDialog.classList.contains('visible')){this.hideIMEList();}},handleApplicationReady:function ai_handleApplicationReady(e){window.removeEventListener('applicationready',this.handleApplicationReady);var apps=e.detail.applications;Object.keys(apps).filter(function(key){ return apps[key].installState==='pending';}).map(function(key){return apps[key];}).forEach(this.prepareForDownload,this);},handleApplicationInstall:function ai_handleApplicationInstallEvent(e){var app=e.detail.application;if(app.installState==='installed'){this.handleInstallSuccess(app);return;}
this.prepareForDownload(app);},handleApplicationUninstall:function ai_handleApplicationUninstall(e){var app=e.detail.application;this.onDownloadStop(app);this.onDownloadFinish(app);},handleAppInstallPrompt:function ai_handleInstallPrompt(detail){var _=navigator.mozL10n.get;var app=detail.app;var manifest=app.manifest?app.manifest:app.updateManifest;if(!manifest){return;}
this.dialog.classList.add('visible');this.dispatchPromptEvent('shown');var id=detail.id;if(manifest.size){this.size.textContent=this.humanizeSize(manifest.size);}else{this.size.textContent=_('size-unknown');}
manifest=new ManifestHelper(manifest);var msg=_('install-app',{'name':manifest.displayName});this.msg.textContent=msg;if(manifest.developer){this.authorName.textContent=manifest.developer.name||_('author-unknown');this.authorUrl.textContent=manifest.developer.url||'';}else{this.authorName.textContent=_('author-unknown');this.authorUrl.textContent='';}
this.installCallback=(function ai_installCallback(){this.dispatchResponse(id,'webapps-install-granted');}).bind(this);this.installCancelCallback=(function ai_cancelCallback(){this.dispatchResponse(id,'webapps-install-denied');}).bind(this);},handleInstall:function ai_handleInstall(evt){if(evt){evt.preventDefault();}
if(this.installCallback){this.installCallback();}
this.installCallback=null;this.dialog.classList.remove('visible');this.dispatchPromptEvent('hidden');},handleAppUninstallPrompt:function ai_handleUninstallPrompt(detail){var app=detail.app;var id=detail.id;var manifest=app.manifest?app.manifest:app.updateManifest;if(!manifest){return;}
manifest=new ManifestHelper(manifest);var unrecoverable=app.installState==='pending'&&!app.downloadAvailable&&!app.readyToApplyDownload;var dialogConfig;if(unrecoverable){dialogConfig={type:'unrecoverable',title:'unrecoverable-error-title',body:'unrecoverable-error-body',confirm:{title:'unrecoverable-error-action',cb:()=>{this.dispatchResponse(id,'webapps-uninstall-granted');}}};}else{var nameObj={name:manifest.displayName};dialogConfig={type:'remove',title:{id:'delete-title',args:nameObj},body:{id:'delete-body',args:nameObj},cancel:{title:'cancel',cb:()=>{this.dispatchResponse(id,'webapps-uninstall-denied');}},confirm:{title:'delete',type:'danger',cb:()=>{this.dispatchResponse(id,'webapps-uninstall-granted');}}};}
var dialog=new ConfirmDialogHelper(dialogConfig);dialog.show(document.getElementById('app-uninstall-dialog'));},prepareForDownload:function ai_prepareForDownload(app){var manifestURL=app.manifestURL;this.appInfos[manifestURL]={};app.ondownloadsuccess=this.handleDownloadSuccess;app.ondownloaderror=this.handleDownloadError;app.onprogress=this.handleProgress;},configurations:{'input':{fnName:'showIMEList'}},handleInstallSuccess:function ai_handleInstallSuccess(app){var manifest=app.manifest||app.updateManifest;var role=manifest.role;if(role==='input'&&!inputWindowManager.isOutOfProcessEnabled){navigator.mozApps.mgmt.uninstall(app);return;}
if(this.configurations[role]){this.setupQueue.push(app);this.checkSetupQueue();}else{this.showInstallSuccess(app);}
var evt=new CustomEvent('applicationinstallsuccess',{detail:{application:app}});window.dispatchEvent(evt);},showInstallSuccess:function ai_showInstallSuccess(app){if(FtuLauncher.isFtuRunning()){return;}
var manifest=app.manifest||app.updateManifest;var appManifest=new ManifestHelper(manifest);var name=appManifest.displayName;var l10nId=appManifest.role==='langpack'?'langpack-install-success2':'app-install-success';this.systemBanner.show(navigator.mozL10n.get(l10nId,{appName:name}));},checkSetupQueue:function ai_checkSetupQueue(){if(this.setupQueue.length&&!(this.isSetupInProgress)){this.isSetupInProgress=true;this.showSetupDialog();}},completedSetupTask:function ai_completedSetupTask(){this.setupQueue.shift();this.isSetupInProgress=false;this.checkSetupQueue();},hideSetupDialog:function ai_hideSetupDialog(){this.setupAppName.textContent='';this.setupAppDescription.textContent='';this.setupInstalledAppDialog.classList.remove('visible');this.dispatchPromptEvent('hidden');},showSetupDialog:function ai_showSetupDialog(){var app=this.setupQueue[0];var manifest=app.manifest;var appManifest=new ManifestHelper(manifest);var appName=appManifest.displayName;var appDescription=appManifest.description;this.setupAppDescription.textContent=appDescription;navigator.mozL10n.setAttributes(this.setupAppName,'app-install-success',{appName:appName});this.setupInstalledAppDialog.classList.add('visible');this.dispatchPromptEvent('shown');window.dispatchEvent(new CustomEvent('applicationsetupdialogshow'));},handleSetupCancelAction:function ai_handleSetupCancelAction(){this.hideSetupDialog();this.completedSetupTask();},handleSetupConfirmAction:function ai_handleSetupConfirmAction(){var fnName=this.configurations[this.setupQueue[0].manifest.role].fnName;this[fnName].call(this);this.hideSetupDialog();},showIMEList:function ai_showIMEList(){var app=this.setupQueue[0];var inputs=app.manifest.inputs;if(typeof inputs!=='object'){console.error('inputs must be an object for '+'third-party keyboard layouts');this.completedSetupTask();return;}
var hasInputPermission=(app.manifest.type==='certified'||app.manifest.type==='privileged')&&(app.manifest.permissions&&'input'in app.manifest.permissions);if(!hasInputPermission){console.error('third-party IME does not have correct input permission');this.completedSetupTask();return;}
var listHtml='';var imeListWrap=Template(this.imeListTemplate);for(var name in inputs){var displayIMEName=new ManifestHelper(inputs[name]).displayName;listHtml+=imeListWrap.interpolate({imeName:name,displayName:displayIMEName});}
this.imeList.innerHTML=listHtml;this.imeLayoutDialog.classList.add('visible');this.dispatchPromptEvent('shown');},hideIMEList:function ai_hideIMEList(){this.imeLayoutDialog.classList.remove('visible');this.dispatchPromptEvent('hidden');this.imeList.innerHTML='';this.completedSetupTask();},handleImeConfirmAction:function ai_handleImeConfirmAction(){var manifestURL=this.setupQueue[0].manifestURL;var keyboards=this.imeList.getElementsByTagName('input');for(var i=0,l=keyboards.length;i<l;i++){var keyboardIME=keyboards[i];if(keyboardIME.checked){KeyboardHelper.setLayoutEnabled(manifestURL,keyboardIME.value,true);KeyboardHelper.saveToSettings();}}
this.hideIMEList();},handleDownloadSuccess:function ai_handleDownloadSuccess(evt){var app=evt.application;this.handleInstallSuccess(app);this.onDownloadStop(app);this.onDownloadFinish(app);},handleDownloadError:function ai_handleDownloadError(evt){var app=evt.application;var _=navigator.mozL10n.get;var manifest=app.manifest||app.updateManifest;var name=new ManifestHelper(manifest).displayName;var errorName=app.downloadError.name;switch(errorName){case'INSUFFICIENT_STORAGE':var title='not-enough-space',buttonText='ok',message='not-enough-space-message';ModalDialog.alert(title,message,{title:buttonText});break;default:console.info('downloadError event, error code is',errorName);var key=this.mapDownloadErrorsToMessage[errorName]||'generic-error';var msg=_('app-install-'+key,{appName:name});this.systemBanner.show(msg);}
this.onDownloadStop(app);},onDownloadStart:function ai_onDownloadStart(app){if(!this.hasNotification(app)){StatusBar.incSystemDownloads();this.addNotification(app);this.requestWifiLock(app);}},onDownloadStop:function ai_onDownloadStop(app){if(this.hasNotification(app)){StatusBar.decSystemDownloads();this.removeNotification(app);this.releaseWifiLock(app);}},hasNotification:function ai_hasNotification(app){var appInfo=this.appInfos[app.manifestURL];return appInfo&&!!appInfo.installNotification;},onDownloadFinish:function ai_onDownloadFinish(app){delete this.appInfos[app.manifestURL];if(app.ondownloadsuccess===this.handleDownloadSuccess){app.ondownloadsuccess=null;}
if(app.ondownloaderror===this.handleDownloadError){app.ondownloaderror=null;}
if(app.onprogress===this.handleProgress){app.onprogress=null;}},addNotification:function ai_addNotification(app){var manifestURL=app.manifestURL,appInfo=this.appInfos[manifestURL];if(appInfo.installNotification){return;}
var newNotif=`<div class="fake-notification" role="link">
        <div data-icon="rocket" class="alert"></div>
        <div class="title-container"></div>
        <progress></progress>
      </div>`;this.notifContainer.insertAdjacentHTML('afterbegin',newNotif);var newNode=this.notifContainer.firstElementChild;newNode.dataset.manifest=manifestURL;var manifest=app.manifest||app.updateManifest;navigator.mozL10n.setAttributes(newNode.querySelector('.title-container'),'downloadingAppMessage',{appName:new ManifestHelper(manifest).displayName});var progressNode=newNode.querySelector('progress');if(app.updateManifest&&app.updateManifest.size){progressNode.max=app.updateManifest.size;appInfo.hasMax=true;}
appInfo.installNotification=newNode;NotificationScreen.addUnreadNotification(manifestURL);},getNotificationProgressNode:function ai_getNotificationProgressNode(app){var appInfo=this.appInfos[app.manifestURL];var progressNode=appInfo&&appInfo.installNotification&&appInfo.installNotification.querySelector('progress');return progressNode||null;},handleProgress:function ai_handleProgress(evt){var app=evt.application,appInfo=this.appInfos[app.manifestURL];this.onDownloadStart(app);var progressNode=this.getNotificationProgressNode(app);var message;if(isNaN(app.progress)||app.progress==null){message={id:'downloadingAppProgressIndeterminate',args:null};progressNode.removeAttribute('value');}else if(appInfo.hasMax){message={id:'downloadingAppProgress',args:{progress:this.humanizeSize(app.progress),max:this.humanizeSize(progressNode.max)}};progressNode.value=app.progress;}else{message={id:'downloadingAppProgressNoMax',args:{progress:this.humanizeSize(app.progress)}};}
navigator.mozL10n.setAttributes(progressNode,message.id,message.args);},removeNotification:function ai_removeNotification(app){var manifestURL=app.manifestURL,appInfo=this.appInfos[manifestURL],node=appInfo.installNotification;if(!node){return;}
node.parentNode.removeChild(node);delete appInfo.installNotification;NotificationScreen.removeUnreadNotification(manifestURL);},requestWifiLock:function ai_requestWifiLock(app){var appInfo=this.appInfos[app.manifestURL];if(!appInfo.wifiLock){appInfo.wifiLock=navigator.requestWakeLock('wifi');}},releaseWifiLock:function ai_releaseWifiLock(app){var appInfo=this.appInfos[app.manifestURL];if(appInfo.wifiLock){try{appInfo.wifiLock.unlock();}catch(e){console.error('error during unlock',e);}
delete appInfo.wifiLock;}},dispatchResponse:function ai_dispatchResponse(id,type){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,{id:id,type:type});window.dispatchEvent(event);},humanizeSize:function ai_humanizeSize(bytes){var _=navigator.mozL10n.get;var units=['bytes','kB','MB','GB','TB','PB'];if(!bytes){return'0.00 '+_(units[0]);}
var e=Math.floor(Math.log(bytes)/Math.log(1024));return(bytes/Math.pow(1024,Math.floor(e))).toFixed(2)+' '+
_(units[e]);},showInstallCancelDialog:function ai_showInstallCancelDialog(evt){if(evt){evt.preventDefault();}
this.installCancelDialog.classList.add('visible');this.dialog.classList.remove('visible');},hideInstallCancelDialog:function ai_hideInstallCancelDialog(evt){if(evt){evt.preventDefault();}
this.dialog.classList.add('visible');this.installCancelDialog.classList.remove('visible');},showDownloadCancelDialog:function ai_showDownloadCancelDialog(e){var currentNode=e.target;if(!currentNode.classList.contains('fake-notification')){return;}
var manifestURL=currentNode.dataset.manifest,app=applications.getByManifestURL(manifestURL),manifest=app.manifest||app.updateManifest,dialog=this.downloadCancelDialog;var title=dialog.querySelector('h1');navigator.mozL10n.setAttributes(title,'stopDownloading',{app:new ManifestHelper(manifest).displayName});dialog.classList.add('visible');this.dispatchPromptEvent('shown');dialog.dataset.manifest=manifestURL;UtilityTray.hide();},handleInstallCancel:function ai_handleInstallCancel(){if(this.installCancelCallback){this.installCancelCallback();}
this.installCancelCallback=null;this.installCancelDialog.classList.remove('visible');this.dispatchPromptEvent('hidden');},handleConfirmDownloadCancel:function ai_handleConfirmDownloadCancel(e){e&&e.preventDefault();var dialog=this.downloadCancelDialog,manifestURL=dialog.dataset.manifest;if(manifestURL){var app=applications.getByManifestURL(manifestURL);app&&app.cancelDownload();}
this.hideDownloadCancelDialog();},handleCancelDownloadCancel:function ai_handleCancelDownloadCancel(e){e&&e.preventDefault();this.hideDownloadCancelDialog();},hideDownloadCancelDialog:function(){var dialog=this.downloadCancelDialog;dialog.classList.remove('visible');this.dispatchPromptEvent('hidden');delete dialog.dataset.manifest;},dispatchPromptEvent:function(state){window.dispatchEvent(new CustomEvent('installprompt'+state));}};AppInstallManager.init();;'use strict';(function(exports){function QuickSettings(){}
QuickSettings.prototype={geolocationEnabled:false,WIFI_STATUSCHANGE_TIMEOUT:2000,ELEMENTS:['wifi','data','bluetooth','airplane-mode','full-app'],WARNING_DIALOG_ENABLED_KEY:'ril.data.roaming_enabled.warningDialog.enabled',DATA_KEY:'ril.data.enabled',DATA_ROAMING_KEY:'ril.data.roaming_enabled',start:function qs_init(){var settings=window.navigator.mozSettings;if(!settings){return;}
this.getAllElements();this.monitorDataChange();(function initNetworkSprite(){var networkTypeSetting=SettingsHelper('operatorResources.data.icon',{});networkTypeSetting.get(function gotNS(networkTypeValues){if(!networkTypeValues){return;}
var sprite=networkTypeValues.data_sprite;if(sprite){document.getElementById('quick-settings-data').style.backgroundImage='url("'+sprite+'")';}});})();this.overlay.addEventListener('click',this);window.addEventListener('utilitytrayshow',this);this.monitorBluetoothChange();this.monitorWifiChange();this.monitorGeoChange();this.monitorAirplaneModeChange();},monitorDataChange:function(){var conns=window.navigator.mozMobileConnection||window.navigator.mozMobileConnections;if(!conns){this.overlay.classList.add('non-mobile');}else{var LABEL_TO_ICON={'4G':'4g','H+':'hspa-plus','H':'hspa','3G':'3g','E':'edge','2G':'2g','undefined':'data'};var label={'lte':'4G','ehrpd':'4G','hspa+':'H+','hsdpa':'H','hsupa':'H','hspa':'H','evdo0':'3G','evdoa':'3G','evdob':'3G','1xrtt':'3G','umts':'3G','edge':'E','is95a':'2G','is95b':'2G','gprs':'2G'};for(var i=0;i<conns.length;i++){var conn=conns[i];conn.addEventListener('datachange',function qs_onDataChange(){var dataType;for(var j=0;j<conns.length;j++){dataType=label[conns[j].data.type]||dataType;}
this.data.dataset.network=dataType;this.data.dataset.icon=LABEL_TO_ICON[String(dataType)];this.setAccessibilityAttributes(this.data,'dataButton',dataType);}.bind(this));}
SettingsListener.observe('ril.data.enabled',true,function(value){if(value){this.data.dataset.enabled='true';}else{delete this.data.dataset.enabled;}
this.setAccessibilityAttributes(this.data,'dataButton',this.data.dataset.network);}.bind(this));}},monitorBluetoothChange:function(){var self=this;var btFirstSet=true;SettingsListener.observe('bluetooth.enabled',true,function(value){if((self.bluetooth.dataset.enabled&&value)||(self.bluetooth.dataset.enabled===undefined&&!value)){return;}
if(value){self.bluetooth.dataset.enabled='true';}else{delete self.bluetooth.dataset.enabled;}
if(!btFirstSet){self.bluetooth.dataset.initializing='true';}
btFirstSet=false;self.setAccessibilityAttributes(self.bluetooth,'bluetoothButton');});window.addEventListener('bluetooth-adapter-added',this);window.addEventListener('bluetooth-disabled',this);},monitorWifiChange:function(){var self=this;var wifiFirstSet=true;SettingsListener.observe('wifi.enabled',true,function(value){if((self.wifi.dataset.enabled&&value)||(self.wifi.dataset.enabled===undefined&&!value)){return;}
if(value){self.wifi.dataset.enabled='true';}else{delete self.wifi.dataset.enabled;}
if(!wifiFirstSet){self.wifi.dataset.initializing='true';}
wifiFirstSet=false;self.setAccessibilityAttributes(self.wifi,'wifiButton');});window.addEventListener('wifi-enabled',this);window.addEventListener('wifi-disabled',this);window.addEventListener('wifi-statuschange',this);},monitorGeoChange:function(){var self=this;SettingsListener.observe('geolocation.enabled',true,function(value){self.geolocationEnabled=value;});},monitorAirplaneModeChange:function(){var self=this;SettingsListener.observe('airplaneMode.status',false,function(value){delete self.airplaneMode.dataset.enabling;delete self.airplaneMode.dataset.disabling;self.data.dataset.airplaneMode=(value==='enabled');switch(value){case'enabled':self.data.classList.add('quick-settings-airplane-mode');self.airplaneMode.dataset.enabled='true';break;case'disabled':self.data.classList.remove('quick-settings-airplane-mode');delete self.airplaneMode.dataset.enabled;break;case'enabling':self.airplaneMode.dataset.enabling='true';break;case'disabling':self.airplaneMode.dataset.disabling='true';break;}
self.setAccessibilityAttributes(self.airplaneMode,'airplaneMode');});},handleEvent:function qs_handleEvent(evt){evt.preventDefault();var enabled=false;switch(evt.type){case'click':switch(evt.target){case this.wifi:if(this.wifi.dataset.initializing){return;}
enabled=!!this.wifi.dataset.enabled;SettingsListener.getSettingsLock().set({'wifi.enabled':!enabled});SettingsListener.getSettingsLock().set({'wifi.connect_via_settings':!enabled});if(!enabled){this.toggleAutoConfigWifi=true;}
break;case this.data:if(this.data.dataset.airplaneMode!=='true'){enabled=!!this.data.dataset.enabled;if(enabled){var cset={};cset[this.DATA_KEY]=!enabled;this.setMozSettings(cset);}else{this.showDataRoamingEnabledPromptIfNeeded();}}
break;case this.bluetooth:if(this.bluetooth.dataset.initializing){return;}
enabled=!!this.bluetooth.dataset.enabled;if(enabled){window.dispatchEvent(new CustomEvent('request-disable-bluetooth'));}else{window.dispatchEvent(new CustomEvent('request-enable-bluetooth'));}
break;case this.airplaneMode:var toggle=this.airplaneMode.dataset.enabled?'request-airplane-mode-disable':'request-airplane-mode-enable';window.dispatchEvent(new CustomEvent(toggle));break;case this.fullApp:var host=document.location.host;var domain=host.replace(/(^[\w\d]+\.)?([\w\d]+\.[a-z]+)/,'$2');var protocol=document.location.protocol+'//';applications.getByManifestURL(protocol+'settings.'+
domain+'/manifest.webapp').launch();UtilityTray.hide();break;}
break;case'utilitytrayshow':break;case'bluetooth-adapter-added':case'bluetooth-disabled':delete this.bluetooth.dataset.initializing;this.setAccessibilityAttributes(this.bluetooth,'bluetoothButton');break;case'wifi-enabled':delete this.wifi.dataset.initializing;this.wifi.dataset.enabled='true';this.setAccessibilityAttributes(this.wifi,'wifiButton');if(this.toggleAutoConfigWifi){this.wifiStatusTimer=setTimeout(this.autoConfigWifi.bind(this),this.WIFI_STATUSCHANGE_TIMEOUT);}
break;case'wifi-disabled':delete this.wifi.dataset.initializing;delete this.wifi.dataset.enabled;this.setAccessibilityAttributes(this.wifi,'wifiButton');if(this.toggleAutoConfigWifi){clearTimeout(this.wifiStatusTimer);this.wifiStatusTimer=null;this.toggleAutoConfigWifi=false;}
break;case'wifi-statuschange':if(this.toggleAutoConfigWifi&&!this.wifi.dataset.initializing){this.autoConfigWifi();}
break;}},getAllElements:function qs_getAllElements(){var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};this.ELEMENTS.forEach(function createElementRef(name){this[toCamelCase(name)]=document.getElementById('quick-settings-'+name);},this);this.overlay=document.getElementById('quick-settings');},setMozSettings:function qs_setter(keypairs){var setlock=SettingsListener.getSettingsLock();for(var key in keypairs){var obj={};obj[key]=keypairs[key];setlock.set(obj);}},setAccessibilityAttributes:function(button,label,type){label+=button.dataset.enabled===undefined?'-off':'-on';if(button.dataset.initializing!==undefined){label+='-initializing';}
button.setAttribute('aria-label',navigator.mozL10n.get(label,{type:type||''}));button.setAttribute('aria-pressed',button.dataset.enabled!==undefined);},autoConfigWifi:function qs_autoConfigWifi(){clearTimeout(this.wifiStatusTimer);this.wifiStatusTimer=null;this.toggleAutoConfigWifi=false;var wifiManager=window.navigator.mozWifiManager;var status=wifiManager.connection.status;if(status=='disconnected'){SettingsListener.getSettingsLock().set({'wifi.connect_via_settings':false});var activity=new MozActivity({name:'configure',data:{target:'device',section:'wifi'}});return activity;}else if(status=='connectingfailed'){SettingsListener.getSettingsLock().set({'wifi.connect_via_settings':false});}},checkDataRoaming:function qs_checkDataRoaming(){var lock=SettingsListener.getSettingsLock();var reqSetting=lock.get(this.DATA_ROAMING_KEY);var self=this;return new Promise(function(resolve,reject){reqSetting.onerror=function(){resolve(true);};reqSetting.onsuccess=function(){resolve(reqSetting.result[self.DATA_ROAMING_KEY]);};});},showDataRoamingEnabledPromptIfNeeded:function qs_showDataRoamingEnabledPromptIfNeeded(){var dialog=document.querySelector('#quick-setting-data-enabled-dialog'),enableBtn=document.querySelector('.quick-setting-data-ok-btn'),cancelBtn=document.querySelector('.quick-setting-data-cancel-btn');var self=this;var connections=window.navigator.mozMobileConnections;var dataType;var sim;if(!connections){return;}
for(var i=0;i<connections.length&&!dataType;i++){dataType=connections[i].data.type;sim=connections[i];}
if(!dataType){return;}
this.checkDataRoaming().then(function(roaming){if(!roaming&&sim.data.roaming){disabledDefaultDialogIfNeeded();}else{var cset={};cset[self.DATA_KEY]=true;self.setMozSettings(cset);return;}});var disabledDefaultDialogIfNeeded=function(){self.getDataRoamingWarning().then(function(warningEnabled){if(warningEnabled===null||warningEnabled){var cset={};cset[self.WARNING_DIALOG_ENABLED_KEY]=false;self.setMozSettings(cset);}
enableDialog(true);});};var enableSetting=function(){var cset={};cset[self.DATA_KEY]=true;cset[self.DATA_ROAMING_KEY]=true;self.setMozSettings(cset);enableDialog(false);};var cancel=function(){enableDialog(false);};function enableDialog(enabled){if(enabled){UtilityTray.hide();enableBtn.addEventListener('click',enableSetting);cancelBtn.addEventListener('click',cancel);dialog.classList.add('visible');}else{enableBtn.removeEventListener('click',enableSetting);cancelBtn.removeEventListener('click',cancel);dialog.classList.remove('visible');}}},getDataRoamingWarning:function qs_getDataRoamingWarning(){var lock=SettingsListener.getSettingsLock();var reqSetting=lock.get(this.WARNING_DIALOG_ENABLED_KEY);var self=this;return new Promise(function(resolve,reject){reqSetting.onerror=function(){resolve(true);};reqSetting.onsuccess=function(){resolve(reqSetting.result[self.WARNING_DIALOG_ENABLED_KEY]);};});}};exports.QuickSettings=QuickSettings;}(window));;'use strict';function MediaPlaybackWidget(container,options){this.container=container;this.nowPlaying=container.querySelector('.media-playback-nowplaying');this.controls=container.querySelector('.media-playback-controls');this.track=container.querySelector('.track');this.previousButton=container.querySelector('.previous');this.playPauseButton=container.querySelector('.play-pause');this.nextButton=container.querySelector('.next');this.previousButton.addEventListener('contextmenu',this.handleContextmenu.bind(this));this.nextButton.addEventListener('contextmenu',this.handleContextmenu.bind(this));this.container.addEventListener('touchend',this.handleTouchend.bind(this));this.isFastSeeking=false;window.addEventListener('iac-mediacomms',this.handleMessage.bind(this));window.addEventListener('bluetoothprofileconnectionchange',this.handleBluetoothChange.bind(this));var acm=navigator.mozAudioChannelManager;if(acm){acm.addEventListener('headphoneschange',this.handleHeadphonesChange.bind(this));}
this.audioRouting='speaker';if(options&&options.nowPlayingAction==='openapp'){this.nowPlaying.addEventListener('click',this.openMediaApp.bind(this));}
window.addEventListener('appterminated',function(event){if(event.detail.origin===this.origin){this.hidden=true;}}.bind(this));}
MediaPlaybackWidget.prototype={get hidden(){return this.container.hidden;},set hidden(value){this.container.hidden=value;},handleMessage:function mpw_handleMessage(event){var message=event.detail;switch(message.type){case'appinfo':this.updateAppInfo(message.data);break;case'nowplaying':this.updateNowPlaying(message.data);break;case'status':this.updatePlaybackStatus(message.data);break;}},handleHeadphonesChange:function mpw_handleHeadphonesChange(event){this.handleAudioRouteChange(event,'wired');},handleBluetoothChange:function mpw_handleBluetoothChange(event){var name=event.detail.name;var connected=event.detail.connected;if(name===Bluetooth.Profiles.SCO){this.container.classList.toggle('disabled',connected);}else if(name===Bluetooth.Profiles.A2DP){this.handleAudioRouteChange(event,'bluetooth');}},handleAudioRouteChange:function mpw_handleAudioRouteChange(event,reason){var isWiredHeadphonesConnected=false;var isBluetoothHeadsetConnected=false;if(reason==='wired'){isWiredHeadphonesConnected=event.target.headphones;}else{isBluetoothHeadsetConnected=event.detail.connected;}
if(isWiredHeadphonesConnected||isBluetoothHeadsetConnected){this.audioRouting=isWiredHeadphonesConnected?'wired':'bluetooth';}else{if(reason===this.audioRouting){this.sendCommand('pause');}else if(reason!=='wired'&&reason!=='bluetooth'){throw Error('Not audio route changed from wired or bluetooth!');}
isWiredHeadphonesConnected=navigator.mozAudioChannelManager&&navigator.mozAudioChannelManager.headphones;isBluetoothHeadsetConnected=Bluetooth.isProfileConnected(Bluetooth.Profiles.A2DP);if(isWiredHeadphonesConnected){this.audioRouting='wired';}else if(isBluetoothHeadsetConnected){this.audioRouting='bluetooth';}else{this.audioRouting='speaker';}}},updateAppInfo:function mpw_updateAppInfo(info){if(!info){return;}
this.origin=info.origin;},updateNowPlaying:function mpw_updateNowPlaying(metadata){if(!metadata){return;}
var title=metadata.title.trim();var artist=metadata.artist.trim();if(title||artist){this.track.removeAttribute('data-l10n-id');this.track.textContent='';if(title){var titleNode=document.createTextNode(title);this.track.appendChild(titleNode);}
if(title&&artist){var emDashNode=document.createTextNode(' — ');var artistNode=document.createTextNode(artist);var artistBdiNode=document.createElement('bdi');this.track.appendChild(emDashNode);artistBdiNode.appendChild(artistNode);this.track.appendChild(artistBdiNode);}
else if(artist){this.track.appendChild(document.createTextNode(artist));}}else{this.track.setAttribute('data-l10n-id','UnknownTrack');}},updatePlaybackStatus:function mp_updatePlaybackStatus(status){switch(status.playStatus){case'PLAYING':this.hidden=false;this.playPauseButton.dataset.icon='pause';this.playPauseButton.setAttribute('data-l10n-id','mediaPlaybackPause');break;case'PAUSED':this.hidden=false;this.playPauseButton.dataset.icon='play';this.playPauseButton.setAttribute('data-l10n-id','mediaPlaybackPlay');break;case'STOPPED':this.hidden=true;break;case'mozinterruptbegin':this.hidden=true;break;}},openMediaApp:function mp_openMediaApp(event){if(this.origin){var evt=new CustomEvent('displayapp',{bubbles:true,cancelable:true,detail:appWindowManager.getApp(this.origin)});window.dispatchEvent(evt);}},sendCommand:function mp_sendCommand(command){var port=IACHandler.getPort('mediacomms');if(port){port.postMessage({command:command});}},handleContextmenu:function mp_handleContextmenu(event){var command=null;switch(event.target){case this.previousButton:command='rewindstart';break;case this.nextButton:command='fastforwardstart';break;}
if(command){this.isFastSeeking=true;this.sendCommand(command);}},handleTouchend:function mp_handleTouchend(event){var command=null;switch(event.target){case this.previousButton:if(this.isFastSeeking){this.isFastSeeking=false;command='rewindend';}else{command='prevtrack';}
break;case this.nextButton:if(this.isFastSeeking){this.isFastSeeking=false;command='fastforwardend';}else{command='nexttrack';}
break;case this.playPauseButton:event.target.classList.toggle('is-paused');command='playpause';break;}
if(command){this.sendCommand(command);}}};;'use strict';var NotificationScreen={TOASTER_TIMEOUT:3500,TRANSITION_FRACTION:0.30,TAP_THRESHOLD:10,SCROLL_THRESHOLD:10,CLEAR_DELAY:80,_notification:null,_containerWidth:null,_touchStartX:0,_touchStartY:0,_touchPosX:0,_touching:false,_isTap:false,_toasterTimeout:null,lockscreenPreview:true,silent:false,vibrates:true,isResending:false,resendReceived:0,resendExpecting:0,PRIORITY_APPLICATIONS:[window.location.origin.replace('system.','network-alerts.')+'/manifest.webapp'],SILENT_APPLICATIONS:[window.location.origin.replace('system.','network-alerts.')+'/manifest.webapp'],getLockScreenContainer:function ns_getLockScreenContainer(){if(window.lockScreenWindowManager&&window.lockScreenWindowManager.getInstance()&&window.lockScreenWindowManager.getInstance().getNotificationContainer()){return window.lockScreenWindowManager.getInstance().getNotificationContainer();}},init:function ns_init(){window.addEventListener('mozChromeNotificationEvent',this);this.notificationsContainer=document.getElementById('notifications-container');this.container=document.getElementById('desktop-notifications-container');this.lockScreenContainer=this.getLockScreenContainer();this.toaster=document.getElementById('notification-toaster');this.ambientIndicator=document.getElementById('ambient-indicator');this.toasterIcon=document.getElementById('toaster-icon');this.toasterTitle=document.getElementById('toaster-title');this.toasterDetail=document.getElementById('toaster-detail');this.clearAllButton=document.getElementById('notification-clear');['tap','touchstart','touchmove','touchend','touchcancel','wheel'].forEach(function(evt){this.container.addEventListener(evt,this);this.toaster.addEventListener(evt,this);},this);this.clearAllButton.addEventListener('click',this.clearAll.bind(this));this.externalNotificationsCount=0;this.unreadNotifications=[];window.addEventListener('utilitytrayshow',this);window.addEventListener('lockscreen-appclosed',this);window.addEventListener('visibilitychange',this);window.addEventListener('ftuopen',this);window.addEventListener('ftudone',this);window.addEventListener('desktop-notification-resend',this);this._sound='style/notifications/ringtones/notifier_firefox.opus';this.ringtoneURL=new SettingsURL();if(typeof MediaPlaybackWidget!=='undefined'){this.mediaPlaybackWidget=new MediaPlaybackWidget(document.getElementById('media-playback-container'),{nowPlayingAction:'openapp'});}
var self=this;SettingsListener.observe('notification.ringtone','',function(value){self._sound=self.ringtoneURL.set(value);});VersionHelper.getVersionInfo().then(function(versionInfo){if(versionInfo.isUpgrade()){LazyLoader.load('js/tone_upgrader.js',function(){toneUpgrader.perform('alerttone');});}},function(err){console.error('VersionHelper failed to lookup version settings.');});},handleEvent:function ns_handleEvent(evt){switch(evt.type){case'mozChromeNotificationEvent':var detail=evt.detail;switch(detail.type){case'desktop-notification':this.addNotification(detail);if(this.isResending){this.resendReceived++;this.isResending=(this.resendReceived<this.resendExpecting);}
break;case'desktop-notification-close':this.removeNotification(detail.id);break;}
break;case'tap':var target=evt.target;this.tap(target);break;case'touchstart':this.touchstart(evt);break;case'touchmove':this.touchmove(evt);break;case'touchend':this.touchend(evt);break;case'touchcancel':this.touchcancel(evt);break;case'wheel':this.wheel(evt);case'utilitytrayshow':this.updateTimestamps();this.hideNotificationIndicator();break;case'visibilitychange':if(!document.hidden){this.updateTimestamps();}
break;case'ftuopen':this.toaster.removeEventListener('tap',this);break;case'ftudone':this.toaster.addEventListener('tap',this);break;case'desktop-notification-resend':this.resendExpecting=evt.detail.number;if(this.resendExpecting){this.isResending=true;}
break;case'lockscreen-appclosed':setTimeout((function(){this.clearLockScreen();}).bind(this),400);break;}},cancelSwipe:function ns_cancelSwipe(){var notification=this._notification;this._notification=null;if(this._touchPosX){notification.addEventListener('transitionend',function trListener(){notification.removeEventListener('transitionend',trListener);notification.classList.remove('snapback');});notification.classList.add('snapback');}
notification.style.transform='';},touchstart:function ns_touchstart(evt){if(evt.touches.length!==1){if(this._touching){this._touching=false;this.cancelSwipe();}
return;}
var target=evt.touches[0].target;if(!target.dataset.notificationId)
return;this._notification=target;this._containerWidth=this.container.clientWidth;this._touchStartX=evt.touches[0].pageX;this._touchStartY=evt.touches[0].pageY;this._touchPosX=0;this._touching=true;this._isTap=true;},touchmove:function ns_touchmove(evt){if(!this._touching){return;}
var touchDiffY=evt.touches[0].pageY-this._touchStartY;if(this._notification.classList.contains('displayed')){this._touching=false;if(touchDiffY<0)
this.closeToast();return;}
if(evt.touches.length!==1||(this._isTap&&Math.abs(touchDiffY)>=this.SCROLL_THRESHOLD)){this._touching=false;this.cancelSwipe();return;}
this._touchPosX=evt.touches[0].pageX-this._touchStartX;if(Math.abs(this._touchPosX)>=this.TAP_THRESHOLD){this._isTap=false;}
if(!this._isTap){evt.preventDefault();this._notification.style.transform='translateX('+this._touchPosX+'px)';}},touchend:function ns_touchend(evt){if(!this._touching){return;}
evt.preventDefault();this._touching=false;if(this._isTap){var event=new CustomEvent('tap',{bubbles:true,cancelable:true});this._notification.dispatchEvent(event);this._notification=null;return;}
if(Math.abs(this._touchPosX)>this._containerWidth*this.TRANSITION_FRACTION){if(this._touchPosX<0){this._notification.classList.add('left');}
this.swipeCloseNotification();}else{this.cancelSwipe();}},touchcancel:function ns_touchcancel(evt){if(this._touching){evt.preventDefault();this._touching=false;this.cancelSwipe();}},wheel:function ns_wheel(evt){if(evt.deltaMode===evt.DOM_DELTA_PAGE&&evt.deltaX){this._notification=evt.target;this.swipeCloseNotification();}},tap:function ns_tap(node){var notificationId=node.dataset.notificationId;var notificationNode=this.container.querySelector('[data-notification-id="'+notificationId+'"]');var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentNotificationEvent',true,true,{type:'desktop-notification-click',id:notificationId});window.dispatchEvent(event);window.dispatchEvent(new CustomEvent('notification-clicked',{detail:{id:notificationId}}));if(notificationNode&&notificationNode.dataset.type==='desktop-notification'&&notificationNode.dataset.obsoleteAPI==='true'){this.closeNotification(notificationNode);}
if(node==this.toaster){this.closeToast();}else{UtilityTray.hide();}},updateTimestamps:function ns_updateTimestamps(){var timestamps=document.getElementsByClassName('timestamp');for(var i=0,l=timestamps.length;i<l;i++){timestamps[i].textContent=this.prettyDate(new Date(timestamps[i].dataset.timestamp));}},prettyDate:function prettyDate(time){var date;if(navigator.mozL10n){date=navigator.mozL10n.DateTimeFormat().fromNow(time,true);}else{date=time.toLocaleFormat();}
return date;},updateToaster:function ns_updateToaster(detail,type,dir){if(detail.icon){this.toasterIcon.src=detail.icon;this.toasterIcon.hidden=false;}else{this.toasterIcon.hidden=true;}
this.toaster.dataset.notificationId=detail.id;this.toaster.dataset.type=type;this.toaster.lang=detail.lang;this.toaster.dir=dir;this.toasterTitle.textContent=detail.title;this.toasterDetail.textContent=detail.text;},addNotification:function ns_addNotification(detail){this.lockScreenContainer=this.getLockScreenContainer();var manifestURL=detail.manifestURL||'';var behavior=detail.mozbehavior||{};var isPriorityNotification=this.PRIORITY_APPLICATIONS.indexOf(manifestURL)!==-1;var notificationContainer=(isPriorityNotification)?this.container.querySelector('.priority-notifications'):this.container.querySelector('.other-notifications');var dir=(detail.bidi==='auto'||typeof detail.bidi==='undefined')?document.documentElement.dir:detail.bidi;this.addUnreadNotification(detail.id,true);var notificationNode=document.createElement('div');notificationNode.classList.add('notification');notificationNode.setAttribute('role','link');notificationNode.dataset.notificationId=detail.id;notificationNode.dataset.noClear=behavior.noclear?'true':'false';notificationNode.lang=detail.lang;notificationNode.dataset.predefinedDir=detail.bidi;notificationNode.dataset.obsoleteAPI='false';if(typeof detail.id==='string'&&detail.id.indexOf('app-notif-')===0){notificationNode.dataset.obsoleteAPI='true';}
var type=detail.type||'desktop-notification';notificationNode.dataset.type=type;notificationNode.dataset.manifestURL=manifestURL;if(detail.icon){var icon=document.createElement('img');icon.src=detail.icon;icon.setAttribute('role','presentation');notificationNode.appendChild(icon);}
var titleContainer=document.createElement('div');titleContainer.classList.add('title-container');var title=document.createElement('div');title.classList.add('title');title.textContent=detail.title;title.setAttribute('dir','auto');titleContainer.appendChild(title);var time=document.createElement('span');var timestamp=detail.timestamp?new Date(detail.timestamp):new Date();time.classList.add('timestamp');time.dataset.timestamp=timestamp;time.textContent=this.prettyDate(timestamp);titleContainer.appendChild(time);notificationNode.appendChild(titleContainer);var message=document.createElement('div');message.classList.add('detail');var messageContent=document.createElement('div');messageContent.classList.add('detail-content');messageContent.textContent=detail.text;messageContent.setAttribute('dir','auto');message.appendChild(messageContent);notificationNode.appendChild(message);var notifSelector='[data-notification-id="'+detail.id+'"]';var oldNotif=notificationContainer.querySelector(notifSelector);if(oldNotif){oldNotif.replaceChild(titleContainer,oldNotif.querySelector('.title-container'));oldNotif.replaceChild(message,oldNotif.querySelector('.detail'));var oldIcon=oldNotif.querySelector('img');if(icon){oldIcon?oldIcon.src=icon.src:oldNotif.insertBefore(icon,oldNotif.firstChild);}else if(oldIcon){oldNotif.removeChild(oldIcon);}
oldNotif.dataset.type=type;oldNotif.lang=detail.lang;oldNotif.dataset.predefinedDir=detail.bidi;notificationNode=oldNotif;}else{notificationContainer.insertBefore(notificationNode,notificationContainer.firstElementChild);}
var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentNotificationEvent',true,true,{type:'desktop-notification-show',id:detail.id});window.dispatchEvent(event);if(!behavior.noscreen&&typeof(ScreenManager)!=='undefined'&&!ScreenManager.screenEnabled){ScreenManager.turnScreenOn();}
var notify=!('noNotify'in detail)&&(this.SILENT_APPLICATIONS.indexOf(manifestURL)===-1);if(notify){this.updateToaster(detail,type,dir);if(this.lockscreenPreview||!window.Service.locked){this.toaster.classList.add('displayed');if(this._toasterTimeout){clearTimeout(this._toasterTimeout);}
this._toasterTimeout=setTimeout((function(){this.closeToast();this._toasterTimeout=null;}).bind(this),this.TOASTER_TIMEOUT);}}
if(Service.locked&&this.lockscreenPreview){this.addLockScreenNotification(detail.id,notificationNode.cloneNode(true));}
if(notify&&!this.isResending){if(!this.silent){var ringtonePlayer=new Audio();var telephony=window.navigator.mozTelephony;ringtonePlayer.src=behavior.soundFile||this._sound;if(telephony&&telephony.active){ringtonePlayer.mozAudioChannelType='telephony';ringtonePlayer.volume=0.3;}else{ringtonePlayer.mozAudioChannelType='notification';}
ringtonePlayer.play();window.setTimeout(function smsRingtoneEnder(){ringtonePlayer.pause();ringtonePlayer.removeAttribute('src');ringtonePlayer.load();},2000);}
if(this.vibrates){var pattern=[200,200,200];if(behavior.vibrationPattern&&behavior.vibrationPattern.length&&behavior.vibrationPattern[0]>0){pattern=behavior.vibrationPattern;}
if(document.hidden){if(type.indexOf('download-notification-downloading')===-1&&manifestURL.indexOf('email.gaiamobile.org')===-1){window.addEventListener('visibilitychange',function waitOn(){window.removeEventListener('visibilitychange',waitOn);navigator.vibrate(pattern);});}}else{navigator.vibrate(pattern);}}}
this.clearAllButton.disabled=false;return notificationNode;},addLockScreenNotification:function ns_addLockScreenNotification(id,node){window.dispatchEvent(new window.CustomEvent('lockscreen-notification-request-append',{detail:{id:id,node:node}}));},swipeCloseNotification:function ns_swipeCloseNotification(){var notification=this._notification;this._notification=null;var toaster=this.toaster;var self=this;notification.addEventListener('transitionend',function trListener(){notification.removeEventListener('transitionend',trListener);self.closeNotification(notification);if(notification!=toaster){return;}
toaster.style.display='none';setTimeout(function nextLoop(){toaster.style.MozTransition='';toaster.style.MozTransform='';toaster.classList.remove('displayed');toaster.classList.remove('disappearing');setTimeout(function nextLoop(){toaster.style.display='block';});});});notification.classList.add('disappearing');notification.style.transform='';},addUnreadNotification:function ns_addUnreadNotification(id,skipUpdate){if(UtilityTray.shown){return;}
this.unreadNotifications.push(id);if(!skipUpdate){this.updateNotificationIndicator();}},removeUnreadNotification:function ns_removeUnreadNotification(id){var notifIndex=this.unreadNotifications.indexOf(id);if(notifIndex>-1){this.unreadNotifications.splice(notifIndex,1);}
this.updateNotificationIndicator();},hideNotificationIndicator:function ns_hideNotificationIndicator(){if(this.unreadNotifications.length>0){this.unreadNotifications=[];}
this.updateNotificationIndicator();},updateNotificationIndicator:function ns_updateNotificationIndicator(){if(this.unreadNotifications.length){this.ambientIndicator.classList.add('unread');navigator.mozL10n.setAttributes(this.ambientIndicator,'statusbarNotifications-unread',{n:this.unreadNotifications.length});}else{this.ambientIndicator.classList.remove('unread');this.ambientIndicator.removeAttribute('aria-label');}
UtilityTray.updateNotificationCount();},closeToast:function ns_closeToast(){this.toaster.classList.remove('displayed');this.updateNotificationIndicator();},closeNotification:function ns_closeNotification(notificationNode){var notificationId=notificationNode.dataset.notificationId;this.removeNotification(notificationId);},removeLockScreenNotification:function ns_removeLockScreenNotification(notificationId){var notifSelector='[data-notification-id="'+notificationId+'"]';this.lockScreenContainer=this.getLockScreenContainer();if(this.lockScreenContainer){var lockScreenNotificationNode=this.lockScreenContainer.querySelector(notifSelector);}
if(lockScreenNotificationNode){var lockScreenNotificationParentNode=lockScreenNotificationNode.parentNode;lockScreenNotificationParentNode.removeChild(lockScreenNotificationNode);window.dispatchEvent(new window.CustomEvent('lockscreen-notification-request-remove',{containerEmpty:!lockScreenNotificationParentNode.firstElementChild}));}},removeNotification:function ns_removeNotification(notificationId){var notifSelector='[data-notification-id="'+notificationId+'"]';var notificationNode=this.container.querySelector(notifSelector);if(notificationNode){notificationNode.remove();}
var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentNotificationEvent',true,true,{type:'desktop-notification-close',id:notificationId});window.dispatchEvent(event);setTimeout((function(){this.removeLockScreenNotification(notificationId);}).bind(this),400);this.removeUnreadNotification(notificationId);if(!this.container.querySelector('.notification')){this.clearAllButton.disabled=true;}},clearAll:function ns_clearAll(){var notifications=this.container.querySelectorAll('.notification');var clearable=[].slice.apply(notifications).filter(function isClearable(notification){return notification.dataset.noClear!=='true';});var notification;this.clearAllButton.disabled=true;this.clearAllButton.blur();if(!clearable.length){return;}
var lastClearable=clearable[clearable.length-1];var removeAll=(function removeAll(){lastClearable.removeEventListener('transitionend',removeAll);for(var notification of clearable){this.closeNotification(notification);}}).bind(this);lastClearable.addEventListener('transitionend',removeAll);for(var index=0,max=clearable.length;index<max;index++){notification=clearable[index];notification.style.transitionDelay=(this.CLEAR_DELAY*index)+'ms';notification.classList.add('disappearing-via-clear-all');notification.style.transform='';}},clearLockScreen:function ns_clearLockScreen(){if(!this.lockScreenContainer){return;}
while(this.lockScreenContainer.firstElementChild){var element=this.lockScreenContainer.firstElementChild;this.lockScreenContainer.removeChild(element);}
window.dispatchEvent(new window.CustomEvent('lockscreen-notification-request-clear'));}};window.addEventListener('load',function(){window.removeEventListener('load',this);if('mozSettings'in navigator&&navigator.mozSettings){var key='notifications.resend';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function onsuccess(){var resendEnabled=req.result[key]||false;if(!resendEnabled){return;}
var resendCallback=(function(number){window.dispatchEvent(new CustomEvent('desktop-notification-resend',{detail:{number:number}}));}).bind(this);if('mozChromeNotifications'in navigator){navigator.mozChromeNotifications.mozResendAllNotifications(resendCallback);}};}});NotificationScreen.init();SettingsListener.observe('lockscreen.notifications-preview.enabled',true,function(value){NotificationScreen.lockscreenPreview=value;});SettingsListener.observe('audio.volume.notification',7,function(value){NotificationScreen.silent=(value==0);});SettingsListener.observe('vibration.enabled',true,function(value){NotificationScreen.vibrates=value;});;'use strict';var DownloadManager=(function(){var mozDownloadManager=navigator.mozDownloadManager;if(!mozDownloadManager){console.error('navigator.mozDownloadManager not supported!');return;}
mozDownloadManager.clearAllDone();var notifications={};var started=false;function onDownloadStart(ev){if(started){createDownloadNotification(ev.download);}else{LazyLoader.load(['shared/js/download/download_formatter.js','shared/js/download/download_ui.js','shared/js/download/download_store.js','shared/js/download/download_helper.js','js/download/download_notification.js'],function(){started=true;createDownloadNotification(ev.download);window.addEventListener('notification-clicked',handleEvent);window.addEventListener('will-shutdown',function onShutdown(){ev.download.pause();});});}}
mozDownloadManager.addEventListener('downloadstart',onDownloadStart);function createDownloadNotification(download){var id=DownloadFormatter.getUUID(download);notifications[id]=new DownloadNotification(download);}
function handleEvent(evt){var detail=evt.detail;if(!detail||!detail.id){return;}
var id=detail.id;var notification=notifications[id];if(notification){notification.onClick(function onRemovedNotification(){notifications[id]=null;});}}}());;'use strict';var NDEFUtils={DEBUG:false,_debug:function _debug(msg,optObject){if(this.DEBUG){this._logVisibly(msg,optObject);}},_logVisibly:function _logVisibly(msg,optObject){var output='[NDEFUtils]: '+msg;if(optObject){output+=JSON.stringify(optObject);}
console.log(output);},parseHandoverNDEF:function parseHandoverNDEF(ndefMsg){try{return this._doParseHandoverNDEF(ndefMsg);}catch(err){this._logVisibly(err);return null;}},_doParseHandoverNDEF:function doParseHandoverNDEF(msg){var nfcUtils=new NfcUtils();var hRecordBuffer=new NfcBuffer(msg[0].payload);var version=hRecordBuffer.getOctet();var h={majorVersion:version>>>4,minorVersion:version&0x0f,type:nfcUtils.toUTF8(msg[0].type),ac:[]};if(msg[0].tnf!==NDEF.TNF_WELL_KNOWN){throw Error('Expected Well Known TNF in Hs/Hr record');}
if(['Hs','Hr'].indexOf(h.type)<0){throw Error('Record "'+h.type+'" not supported.');}
var hRecord=nfcUtils.parseNDEF(hRecordBuffer);if(!hRecord){throw Error('Could not parse embedded NDEF in Hr/Hs record');}
if(hRecordBuffer.offset<msg[0].payload.length){throw Error('Embedded NDEF payload contains extraneous bytes');}
for(var i=0;i<hRecord.length;i+=1){var type=nfcUtils.toUTF8(hRecord[i].type);if('ac'===type){h.ac.push(this._parseAlternativeCarrier(hRecord[i].payload,msg));}else if('cr'===type){h.cr=this._parseCollisionResolution(hRecord[i].payload);}}
if('Hr'===h.type&&!h.cr){throw Error('Collision resolution record missing');}
return h;},_parseAlternativeCarrier:function _parseAlternativeCarrier(bytes,msg){var nfcUtils=new NfcUtils();var b=new NfcBuffer(bytes);var ac={cps:b.getOctet()&0x03};var recordId=b.getOctetArray(b.getOctet());ac.cdr=msg.filter(function(record){return nfcUtils.equalArrays(record.id,recordId);}.bind(this))[0];if(!ac.cdr){throw Error('Could not find record with given id');}
return ac;},_parseCollisionResolution:function _parseCollisionResolution(bytes){if(bytes.length!==2){throw Error('Expected random number in Collision Resolution Record');}
return(bytes[0]<<8)|bytes[1];},searchForBluetoothAC:function searchForBluetoothAC(h){var nfcUtils=new NfcUtils();for(var i=0;i<h.ac.length;i++){var cdr=h.ac[i].cdr;if(cdr.tnf===NDEF.TNF_MIME_MEDIA){if(nfcUtils.equalArrays(cdr.type,NDEF.MIME_BLUETOOTH_OOB)){return cdr;}}}
return null;},parseBluetoothSSP:function parseBluetoothSSP(cdr){var nfcUtils=new NfcUtils();if(!cdr||!cdr.payload||cdr.payload.length<8){return null;}
var btssp={};var buf=new NfcBuffer(cdr.payload);var btsspLen=buf.getOctet()|(buf.getOctet()<<8);if(cdr.payload.length!==btsspLen){this._debug('Invalid BT SSP record. Length indicated:'+
btsspLen+', actual length: '+cdr.payload.length);return null;}
btssp.mac=this.formatMAC(buf.getOctetArray(6));while(buf.offset!=cdr.payload.length){var len=buf.getOctet()-1;var type=buf.getOctet();if(buf.offset+len>buf.uint8array.length){this._debug('EIR field '+type+' indicated length='+
len+', but only '+(buf.uint8array.length-buf.offset)+' characters left in buffer.');return null;}
switch(type){case 0x08:case 0x09:var n=buf.getOctetArray(len);btssp.localName=nfcUtils.toUTF8(n);break;default:buf.skip(len);break;}}
return btssp;},formatMAC:function formatMAC(mac){if(!mac||mac.length!==6){return null;}
var res=[];for(var i=0;i<6;i+=1){var m=mac[i].toString(16);res.unshift(m.length===1?'0'+m:m);}
return res.join(':').toUpperCase();},parseMAC:function parseMAC(mac){if(!mac||!/^([0-9A-F]{2}:){6}$/i.test(mac+':')){return null;}
var macVals=mac.split(':');var m=[];for(var i=5;i>=0;i-=1){m.push(parseInt(macVals[i],16));}
return m;},validateCPS:function validateCPS(cps){var allowedValues=[NDEF.CPS_INACTIVE,NDEF.CPS_ACTIVE,NDEF.CPS_ACTIVATING,NDEF.CPS_UNKNOWN];return(allowedValues.indexOf(cps)>=0);},encodeHandoverRequest:function encodeHandoverRequest(mac,cps){var nfcUtils=new NfcUtils();var m=this.parseMAC(mac);if(!m){this._debug('Invalid BT MAC address: '+mac);return null;}
if(!this.validateCPS(cps)){this._debug('Invalid CPS: '+cps);return null;}
var rndMSB=Math.floor(Math.random()*0xff)&0xff;var rndLSB=Math.floor(Math.random()*0xff)&0xff;var OOBLength=2+m.length;var OOB=[OOBLength,0].concat(m);var pid=nfcUtils.fromUTF8('0');var hr=[new MozNDEFRecord({tnf:NDEF.TNF_WELL_KNOWN,type:NDEF.RTD_HANDOVER_REQUEST,payload:new Uint8Array([0x12,0x91,0x02,0x02,0x63,0x72,rndMSB,rndLSB,0x51,0x02,0x04,0x61,0x63,cps,0x01,pid[0],0x00])}),new MozNDEFRecord({tnf:NDEF.TNF_MIME_MEDIA,type:NDEF.MIME_BLUETOOTH_OOB,id:pid,payload:new Uint8Array(OOB)})];return hr;},encodeHandoverSelect:function encodeHandoverSelect(mac,cps,btDeviceName){var nfcUtils=new NfcUtils();var m=this.parseMAC(mac);if(!m){this._debug('Invalid BT MAC address: '+mac);return null;}
if(!this.validateCPS(cps)){this._debug('Invalid CPS: '+cps);return null;}
var OOBLength=2+m.length;var OOB=[OOBLength,0].concat(m);if(btDeviceName){var EIRLength=1+btDeviceName.length;OOB[0]+=EIRLength+1;OOB=OOB.concat(EIRLength,0x09,Array.apply([],btDeviceName));}
var pid=nfcUtils.fromUTF8('0');var hs=[new MozNDEFRecord({tnf:NDEF.TNF_WELL_KNOWN,type:NDEF.RTD_HANDOVER_SELECT,payload:new Uint8Array([0x12,0xD1,0x02,0x04,0x61,0x63,cps,0x01,pid[0],0x00])}),new MozNDEFRecord({tnf:NDEF.TNF_MIME_MEDIA,type:NDEF.MIME_BLUETOOTH_OOB,id:pid,payload:new Uint8Array(OOB)})];return hs;},encodeEmptyHandoverSelect:function encodeEmptyHandoverSelect(){var hs=[new MozNDEFRecord({tnf:NDEF.TNF_WELL_KNOWN,type:NDEF.RTD_HANDOVER_SELECT,payload:new Uint8Array([0x12])})];return hs;}};;'use strict';var NfcHandoverManager={DEBUG:false,settings:null,bluetooth:null,nfc:null,defaultAdapter:null,actionQueue:[],sendFileQueue:[],responseTimeoutMillis:9000,responseTimeoutFunction:null,incomingFileTransferInProgress:false,bluetoothStatusSaved:false,bluetoothAutoEnabled:false,settingsNotified:false,_debug:function _debug(msg,optObject){if(this.DEBUG){this._logVisibly(msg,optObject);}},_logVisibly:function _logVisibly(msg,optObject){var output='[NfcHandoverManager]: '+msg;if(optObject){output+=JSON.stringify(optObject);}
console.log(output);},init:function init(){var self=this;this.settings=navigator.mozSettings;this.bluetooth=navigator.mozBluetooth;this.nfc=navigator.mozNfc;this.incomingFileTransferInProgress=false;this.bluetoothStatusSaved=false;this.bluetoothAutoEnabled=false;if(this.bluetooth.enabled){this._debug('Bluetooth already enabled on boot');var req=this.bluetooth.getDefaultAdapter();req.onsuccess=function bt_getAdapterSuccess(){self.defaultAdapter=req.result;self._debug('MAC address: '+self.defaultAdapter.address);self._debug('MAC name: '+self.defaultAdapter.name);};req.onerror=function bt_getAdapterError(){self._logVisibly('init: Failed to get bluetooth adapter');};}
window.addEventListener('bluetooth-adapter-added',function(){self._debug('bluetooth-adapter-added');var req=self.bluetooth.getDefaultAdapter();req.onsuccess=function bt_getAdapterSuccess(){self.settingsNotified=false;self.defaultAdapter=req.result;self._debug('MAC address: '+self.defaultAdapter.address);self._debug('MAC name: '+self.defaultAdapter.name);for(var i=0;i<self.actionQueue.length;i++){var action=self.actionQueue[i];action.callback.apply(self,action.args);}
self.actionQueue=[];};req.onerror=function bt_getAdapterError(){self._logVisibly('event listner: Failed to get bluetooth adater');};});window.addEventListener('bluetooth-disabled',function(){self._debug('bluetooth-disabled');self._clearBluetoothStatus();});window.navigator.mozSetMessageHandler('nfc-manager-send-file',function(msg){self._debug('In New event nfc-manager-send-file'+JSON.stringify(msg));self.handleFileTransfer(msg.peer,msg.blob,msg.requestId);});SettingsListener.observe('nfc.debugging.enabled',false,(enabled)=>{this.DEBUG=enabled;});window.addEventListener('nfc-transfer-started',this._transferStarted.bind(this));},_saveBluetoothStatus:function _saveBluetoothStatus(){if(!this.bluetoothStatusSaved){this.bluetoothStatusSaved=true;this.bluetoothAutoEnabled=!this.bluetooth.enabled;}},_restoreBluetoothStatus:function _restoreBluetoothStatus(){if(!this.isHandoverInProgress()&&BluetoothTransfer.isSendFileQueueEmpty){if(this.bluetoothAutoEnabled){this._debug('Disabling Bluetooth');this.settings.createLock().set({'bluetooth.enabled':false});this.bluetoothAutoEnabled=false;}
this.bluetoothStatusSaved=false;}},_clearBluetoothStatus:function _clearBluetoothStatus(){this.bluetoothStatusSaved=false;},_doAction:function _doAction(action){if(!this.bluetooth.enabled){this._debug('Bluetooth: not yet enabled');this.actionQueue.push(action);if(this.settingsNotified===false){this.settings.createLock().set({'bluetooth.enabled':true});this.settingsNotified=true;}}else{action.callback.apply(this,action.args);}},_getBluetoothSSP:function _getBluetoothSSP(ndef){var handover=NDEFUtils.parseHandoverNDEF(ndef);if(handover==null){this._debug('Bad handover messsage');return null;}
var btsspRecord=NDEFUtils.searchForBluetoothAC(handover);if(btsspRecord==null){this._debug('No BT AC');return null;}
return NDEFUtils.parseBluetoothSSP(btsspRecord);},_findPairedDevice:function _findPairedDevice(mac,foundCb,notFoundCb){this._debug('_findPairedDevice');if(this.defaultAdapter==null){this._debug('No defaultAdapter');return;}
var req=this.defaultAdapter.getPairedDevices();req.onsuccess=()=>{var devices=req.result;this._debug('# devices: '+devices.length);for(var i=0;i<devices.length;i++){var device=devices[i];this._debug('Address: '+device.address);this._debug('Connected: '+device.connected);if(device.address.toLowerCase()===mac.toLowerCase()){this._debug('Found device '+mac);foundCb(device);return;}}
if(notFoundCb){notFoundCb();}};req.onerror=()=>{this._logVisibly('Cannot get paired devices from adapter.');};},_doConnect:function _doConnect(device){this._debug('doConnect with: '+device.address);var req=this.defaultAdapter.connect(device);req.onsuccess=()=>{this._debug('Connect succeeded');};req.onerror=()=>{this._debug('Connect failed');};},_doPairing:function _doPairing(mac){this._debug('doPairing: '+mac);var alreadyPaired=(device)=>{this.defaultAdapter.connect(device);};var notYetPaired=()=>{this._debug('Device not yet paired');var req=this.defaultAdapter.pair(mac);req.onsuccess=()=>{this._debug('Pairing succeeded');this._clearBluetoothStatus();this._findPairedDevice(mac,(device)=>{this.defaultAdapter.connect(device);});};req.onerror=()=>{this._logVisibly('Pairing failed');this._restoreBluetoothStatus();};};this._findPairedDevice(mac,alreadyPaired,notYetPaired);},_showFailedNotification:function _showFailedNotification(title,msg){var body=(msg!==undefined)?msg:'';var icon='style/bluetooth_transfer/images/icon_bluetooth.png';NotificationHelper.send(title,{body:body,icon:icon});},_showTryAgainNotification:function _showTryAgainNotification(){var _=navigator.mozL10n.get;this._showFailedNotification('transferFinished-sentFailed-title',_('transferFinished-try-again-description'));},_cancelSendFileTransfer:function _cancelSendFileTransfer(){this._debug('_cancelSendFileTransfer');this.responseTimeoutFunction=null;var job=this.sendFileQueue.pop();job.onerror();this._showFailedNotification('transferFinished-sentFailed-title',job.blob.name);this._restoreBluetoothStatus();},_cancelIncomingFileTransfer:function _cancelIncomingFileTransfer(){this._debug('_cancelIncomingFileTransfer');this.responseTimeoutFunction=null;this.incomingFileTransferInProgress=false;this._showFailedNotification('transferFinished-receivedFailed-title');this._restoreBluetoothStatus();},_doFileTransfer:function _doFileTransfer(mac){this._debug('doFileTransfer');if(this.sendFileQueue.length===0){this._debug('sendFileQueue empty');return;}
this._debug('Send blob to '+mac);var blob=this.sendFileQueue[0].blob;BluetoothTransfer.sendFileViaHandover(mac,blob);},_doHandoverRequest:function _doHandoverRequest(ndef,nfcPeer){this._debug('doHandoverRequest');if(this._getBluetoothSSP(ndef)==null){return;}
if(nfcPeer.isLost){this._logVisibly('NFC peer went away during doHandoverRequest');this._showFailedNotification('transferFinished-receivedFailed-title');this._restoreBluetoothStatus();return;}
var cps=this.bluetooth.enabled?NDEF.CPS_ACTIVE:NDEF.CPS_ACTIVATING;var mac=this.defaultAdapter.address;var hs=NDEFUtils.encodeHandoverSelect(mac,cps);var promise=nfcPeer.sendNDEF(hs);promise.then(()=>{this._debug('sendNDEF(hs) succeeded');this.incomingFileTransferInProgress=true;}).catch(e=>{this._logVisibly('sendNDEF(hs) failed : '+e);this._clearTimeout();this._restoreBluetoothStatus();});this._clearTimeout();this.responseTimeoutFunction=setTimeout(this._cancelIncomingFileTransfer.bind(this),this.responseTimeoutMillis);},_initiateFileTransfer:function _initiateFileTransfer(nfcPeer,blob,requestId){this._debug('initiateFileTransfer');var self=this;var onsuccess=function(){self._dispatchSendFileStatus(0,requestId);};var onerror=function(){self._dispatchSendFileStatus(1,requestId);};if(nfcPeer.isLost){this._logVisibly('NFC peer went away during initiateFileTransfer');onerror();this._restoreBluetoothStatus();this._showFailedNotification('transferFinished-sentFailed-title',blob.name);return;}
var job={nfcPeer:nfcPeer,blob:blob,requestId:requestId,onsuccess:onsuccess,onerror:onerror};this.sendFileQueue.push(job);var cps=this.bluetooth.enabled?NDEF.CPS_ACTIVE:NDEF.CPS_ACTIVATING;var mac=this.defaultAdapter.address;var hr=NDEFUtils.encodeHandoverRequest(mac,cps);var promise=nfcPeer.sendNDEF(hr);promise.then(()=>{this._debug('sendNDEF(hr) succeeded');}).catch(e=>{this._debug('sendNDEF(hr) failed : '+e);onerror();this.sendFileQueue.pop();this._clearTimeout();this._restoreBluetoothStatus();this._showFailedNotification('transferFinished-sentFailed-title',blob.name);});this._clearTimeout();this.responseTimeoutFunction=setTimeout(this._cancelSendFileTransfer.bind(this),this.responseTimeoutMillis);},_clearTimeout:function _clearTimeout(){this._debug('_clearTimeout');if(this.responseTimeoutFunction!=null){this._debug('clearing timeout');clearTimeout(this.responseTimeoutFunction);this.responseTimeoutFunction=null;}},_dispatchSendFileStatus:function _dispatchSendFileStatus(status,requestId){this._debug('In dispatchSendFileStatus '+status);navigator.mozNfc.notifySendFileStatus(status,requestId);},_onRequestConnect:function _onRequestConnect(btssp){var self=this;var onconfirm=function(){self._debug('Connect confirmed');self._doAction({callback:self._doPairing,args:[btssp.mac]});};var onabort=function(){self._debug('Connect aborted');};if(!this.nfcConnectSystemDialog){this.nfcConnectSystemDialog=new NfcConnectSystemDialog();}
this.nfcConnectSystemDialog.show(btssp.localName,onconfirm,onabort);},_checkConnected:function _checkConnected(btssp){if(!this.bluetooth.enabled){this._onRequestConnect(btssp);return;}
this._findPairedDevice(btssp.mac,(device)=>{if(!device.connected){this._onRequestConnect(btssp);}},()=>{this._onRequestConnect(btssp);});},_handleSimplifiedPairingRecord:function _handleSimplifiedPairingRecord(ndef){this._debug('_handleSimplifiedPairingRecord');var pairingRecord=ndef[0];var btssp=NDEFUtils.parseBluetoothSSP(pairingRecord);this._debug('Simplified pairing with: '+btssp.mac);this._checkConnected(btssp);},_handleHandoverSelect:function _handleHandoverSelect(ndef){this._debug('_handleHandoverSelect');this._clearTimeout();var btssp=this._getBluetoothSSP(ndef);if(btssp==null){if(this.sendFileQueue.length!==0){this._debug('Other device is transferring file. Aborting');var job=this.sendFileQueue.shift();job.onerror();this._showTryAgainNotification();}
this._restoreBluetoothStatus();return;}
if(this.sendFileQueue.length!==0){this._doAction({callback:this._doFileTransfer,args:[btssp.mac]});}else{this._checkConnected(btssp);}},_handleHandoverRequest:function _handleHandoverRequest(ndef,nfcPeer){this._debug('_handleHandoverRequest');if(BluetoothTransfer.isFileTransferInProgress){this._debug('This device is currently transferring a file. '+'Aborting via empty Hs');var hs=NDEFUtils.encodeEmptyHandoverSelect();nfcPeer.sendNDEF(hs);return;}
this._saveBluetoothStatus();this._doAction({callback:this._doHandoverRequest,args:[ndef,nfcPeer]});},tryHandover:function(ndefMsg,nfcPeer){this._debug('tryHandover: ',ndefMsg);var nfcUtils=new NfcUtils();if(!Array.isArray(ndefMsg)||!ndefMsg.length){return false;}
var record=ndefMsg[0];if(record.tnf===NDEF.TNF_WELL_KNOWN){if(nfcUtils.equalArrays(record.type,NDEF.RTD_HANDOVER_SELECT)){this._handleHandoverSelect(ndefMsg);return true;}else if(nfcUtils.equalArrays(record.type,NDEF.RTD_HANDOVER_REQUEST)){this._handleHandoverRequest(ndefMsg,nfcPeer);return true;}}else if((record.tnf===NDEF.TNF_MIME_MEDIA)&&nfcUtils.equalArrays(record.type,NDEF.MIME_BLUETOOTH_OOB)){this._handleSimplifiedPairingRecord(ndefMsg);return true;}
return false;},handleFileTransfer:function handleFileTransfer(nfcPeer,blob,requestId){this._debug('handleFileTransfer');if(BluetoothTransfer.isFileTransferInProgress){this._debug('This device is already transferring a file. Aborting');this._dispatchSendFileStatus(1,requestId);this._showTryAgainNotification();return;}
this._saveBluetoothStatus();this._doAction({callback:this._initiateFileTransfer,args:[nfcPeer,blob,requestId]});},isHandoverInProgress:function isHandoverInProgress(){return(this.sendFileQueue.length!==0)||(this.incomingFileTransferInProgress===true);},_transferStarted:function bt__transferStarted(){this._clearTimeout();},transferComplete:function transferComplete(details){this._debug('transferComplete: '+JSON.stringify(details));if(!details.received&&details.viaHandover){var job=this.sendFileQueue.shift();if(details.success){job.onsuccess();}else{job.onerror();}}
if(details.received){this.incomingFileTransferInProgress=false;}
this._restoreBluetoothStatus();}};;'use strict';(function(exports){var DEBUG=false;var NfcManager=function(){};NfcManager.prototype={NFC_HW_STATE:{DISABLING:'nfcDisabling',OFF:'nfcOff',ENABLING:'nfcEnabling',ON:'nfcOn',ENABLE_DISCOVERY:'nfcEnableDiscovery',DISABLE_DISCOVERY:'nfcDisableDiscovery'},_hwState:null,start:function nm_start(){this._debug('Starting NFC Manager');this._hwState=this.NFC_HW_STATE.OFF;window.navigator.mozSetMessageHandler('nfc-manager-tech-discovered',(msg)=>this._handleTechDiscovered(msg));window.navigator.mozSetMessageHandler('nfc-manager-tech-lost',(msg)=>this._handleTechLost(msg));window.addEventListener('screenchange',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('lockscreen-appclosed',this);this._onSettingsChanged=(enabled)=>this._nfcSettingsChanged(enabled);SettingsListener.observe('nfc.enabled',false,this._onSettingsChanged);this._onDebugChanged=(enabled)=>{DEBUG=enabled;};SettingsListener.observe('nfc.debugging.enabled',false,this._onDebugChanged);SettingsListener.getSettingsLock().set({'nfc.status':'disabled'});},stop:function nm_stop(){this._debug('Stopping NFC Manager');window.navigator.mozSetMessageHandler('nfc-manager-tech-discovered',null);window.navigator.mozSetMessageHandler('nfc-manager-tech-lost',null);window.removeEventListener('screenchange',this);window.removeEventListener('activeappchanged',this);window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('lockscreen-appclosed',this);SettingsListener.unobserve('nfc.enabled',this._onSettingsChanged);SettingsListener.unobserve('nfc.debugging.enabled',this._onDebugChanged);},isActive:function nm_isActive(){return this._hwState===this.NFC_HW_STATE.ON||this._hwState===this.NFC_HW_STATE.ENABLE_DISCOVERY||this._hwState===this.NFC_HW_STATE.DISABLE_DISCOVERY;},isInTransition:function nm_isInTransition(){return this._hwState===this.NFC_HW_STATE.ENABLING||this._hwState===this.NFC_HW_STATE.DISABLING;},_handleTechDiscovered:function nm_handleTechDiscovered(msg){this._debug('Technology Discovered: '+JSON.stringify(msg));msg=msg||{};msg.records=Array.isArray(msg.records)?msg.records:[];window.dispatchEvent(new CustomEvent('nfc-tech-discovered'));window.navigator.vibrate([25,50,125]);if(NfcHandoverManager.tryHandover(msg.records,msg.peer)){return;}
if(msg.records.length){this._fireNDEFDiscovered(msg.records);}else if(msg.peer){this.checkP2PRegistration();}else{this._logVisibly('Got tag without NDEF records, ignoring.');}},_handleTechLost:function nm_handleTechLost(msg){this._debug('Technology Lost: '+JSON.stringify(msg));window.navigator.vibrate([125,50,25]);window.dispatchEvent(new CustomEvent('nfc-tech-lost'));window.removeEventListener('shrinking-sent',this);window.dispatchEvent(new CustomEvent('shrinking-stop'));},handleEvent:function nm_handleEvent(evt){var state;switch(evt.type){case'lockscreen-appopened':case'lockscreen-appclosed':case'screenchange':if(!this.isActive()){return;}
state=(ScreenManager.screenEnabled&&!Service.locked)?this.NFC_HW_STATE.ENABLE_DISCOVERY:this.NFC_HW_STATE.DISABLE_DISCOVERY;if(state===this._hwState){return;}
this._changeHardwareState(state);break;case'shrinking-sent':window.removeEventListener('shrinking-sent',this);this.dispatchP2PUserResponse();window.dispatchEvent(new CustomEvent('shrinking-stop'));break;}},_nfcSettingsChanged:function nm_nfcSettingsChanged(enabled){this._debug('_nfcSettingsChanged, nfc.enabled: '+enabled);if(this.isActive()===enabled||this.isInTransition()){this._debug('_nfcSettingsChanged ignoring settings change');return;}
var state=!enabled?this.NFC_HW_STATE.DISABLING:(Service.locked?this.NFC_HW_STATE.DISABLE_DISCOVERY:this.NFC_HW_STATE.ENABLING);this._changeHardwareState(state);},_changeHardwareState:function nm_changeHardwareState(state){this._debug('_changeHardwareState - state : '+state);this._hwState=state;var nfcdom=window.navigator.mozNfc;if(!nfcdom){return;}
var promise;switch(state){case this.NFC_HW_STATE.DISABLING:promise=nfcdom.powerOff();SettingsListener.getSettingsLock().set({'nfc.status':'disabling'});break;case this.NFC_HW_STATE.DISABLE_DISCOVERY:promise=nfcdom.stopPoll();break;case this.NFC_HW_STATE.ENABLING:promise=nfcdom.startPoll();SettingsListener.getSettingsLock().set({'nfc.status':'enabling'});break;case this.NFC_HW_STATE.ENABLE_DISCOVERY:promise=nfcdom.startPoll();break;}
promise.then(()=>{this._debug('_changeHardwareState '+state+' success');if(this.isInTransition()){this._handleNFCOnOff(this._hwState===this.NFC_HW_STATE.ENABLING);}}).catch(e=>{this._logVisibly('_changeHardwareState '+state+' error '+e);if(this.isInTransition()){this._handleNFCOnOff(this._hwState!==this.NFC_HW_STATE.ENABLING);}});},_handleNFCOnOff:function nm_handleNFCOnOff(isOn){this._debug('_handleNFCOnOf is on:'+isOn);this._hwState=(isOn)?this.NFC_HW_STATE.ON:this.NFC_HW_STATE.OFF;SettingsListener.getSettingsLock().set({'nfc.status':(isOn)?'enabled':'disabled'});var event=new CustomEvent('nfc-state-changed',{detail:{active:isOn}});window.dispatchEvent(event);},_triggerP2PUI:function nm_triggerP2PUI(){var evt=new CustomEvent('check-p2p-registration-for-active-app',{bubbles:true,cancelable:false,detail:this});window.dispatchEvent(evt);},checkP2PRegistration:function nm_checkP2PRegistration(){var nfcdom=window.navigator.mozNfc;if(!nfcdom){return;}
var activeApp=window.Service.currentApp;var manifestURL=activeApp.getTopMostWindow().manifestURL||window.Service.manifestURL;if(activeApp.isPrivateBrowser()&&activeApp.config.url.startsWith('app://')){return;}
var promise=nfcdom.checkP2PRegistration(manifestURL);promise.then(result=>{if(result){if(activeApp.isTransitioning()||activeApp.isSheetTransitioning()){return;}
window.dispatchEvent(new CustomEvent('shrinking-start'));window.addEventListener('shrinking-sent',this);}else{this._logVisibly('CheckP2PRegistration failed');window.removeEventListener('shrinking-sent',this);window.dispatchEvent(new CustomEvent('shrinking-stop'));}});},dispatchP2PUserResponse:function nm_dispatchP2PUserResponse(){var nfcdom=window.navigator.mozNfc;if(!nfcdom){return;}
var activeApp=window.Service.currentApp;var manifestURL=activeApp.getTopMostWindow().manifestURL||window.Service.manifestURL;nfcdom.notifyUserAcceptedP2P(manifestURL);},_fireNDEFDiscovered:function nm_fireNDEFDiscovered(records){this._debug('_fireNDEFDiscovered: '+JSON.stringify(records));var smartPoster=this._getSmartPoster(records);var record=smartPoster||records[0]||{tnf:NDEF.TNF_EMPTY};var data=NDEF.payload.decode(record.tnf,record.type,record.payload);var options=this._createNDEFActivityOptions(data);if(data!==null){options.data.records=records;}
this._debug('_fireNDEFDiscovered activity options: ',options);var activity=new MozActivity(options);activity.onerror=()=>{this._logVisibly('Firing nfc-ndef-discovered activity failed');};},_getSmartPoster:function nm_getSmartPoster(records){var nfcUtils=new NfcUtils();if(!Array.isArray(records)||!records.length){return null;}
var smartPosters=records.filter(function isSmartPoster(r){return nfcUtils.equalArrays(r.type,NDEF.RTD_SMART_POSTER);});if(smartPosters.length&&records[0].tnf===NDEF.TNF_WELL_KNOWN&&(nfcUtils.equalArrays(records[0].type,NDEF.RTD_URI)||nfcUtils.equalArrays(records[0].type,NDEF.RTD_SMART_POSTER))){return smartPosters[0];}
return null;},_createNDEFActivityOptions:function nm_createNDEFActivityOptions(payload){var options={name:'nfc-ndef-discovered',data:{}};if(payload===null){return options;}
if(payload.type==='uri'){if(payload.uri.indexOf('tel:')===0){options.name='dial';options.data.type='webtelephony/number';options.data.number=payload.uri.substring(4);options.data.uri=payload.uri;}else if(payload.uri.indexOf('mailto:')===0){options.name='new';options.data.type='mail';options.data.url=payload.uri;}else if(payload.uri.indexOf('http://')===0||payload.uri.indexOf('https://')===0||payload.uri.indexOf('data:text/html')===0){options.name='view';options.data.type='url';options.data.url=payload.uri;}else{options.data=payload;}}else if(payload.type==='smartposter'&&(payload.uri.indexOf('http://')===0||payload.uri.indexOf('https://')===0)){options.name='view';options.data=payload;options.data.type='url';options.data.url=payload.uri;delete options.data.uri;}else if(payload.type==='text/vcard'){options.name='import';options.data=payload;}else{options.data=payload;}
if(options.name!=='nfc-ndef-discovered'){options.data.src='nfc';}
return options;},_debug:function nm_debug(msg,optObject){if(DEBUG){this._logVisibly(msg,optObject);}},_logVisibly:function nm_logVisibly(msg,optObject){var output='[NfcManager]: '+msg;if(optObject){output+=JSON.stringify(optObject);}
console.log(output);}};exports.NfcManager=NfcManager;}(window));;'use strict';(function(exports){var NfcHandler=function(appWindowManager){this.appWindowManager=appWindowManager;};NfcHandler.prototype={start:function nh_start(){if(window.navigator.mozNfc){window.navigator.mozNfc.onpeerready=this.handleEvent.bind(this);}},stop:function ng_stop(){if(window.navigator.mozNfc){window.navigator.mozNfc.onpeerready=null;}},handleEvent:function nh_handleEvent(evt){var nfcUtils=new NfcUtils();if(evt.type!=='peerready'){return;}
var currentApp=this.appWindowManager.getActiveApp();if(currentApp&&currentApp.isBrowser()&&currentApp.config.url){var ndefUri=nfcUtils.parseURIString(currentApp.config.url);this.sendNDEFMessageToNFCPeer(ndefUri,evt);}},sendNDEFMessageToNFCPeer:function nh_sendNDEFMessageToNFCPeer(message,nfcEvent){if(!message){return;}
var nfcPeer=nfcEvent.peer;if(!nfcPeer){return null;}
nfcPeer.sendNDEF(message);}};exports.NfcHandler=NfcHandler;}(window));;'use strict';(function(exports){var HVGA;function isHVGA(){if(undefined===HVGA){HVGA=document.documentElement.clientWidth<480;}
return HVGA;}
function getIconURIForApp(app){if(!app){return null;}
var icons=app.manifest&&app.manifest.icons;var iconPath;if(icons){var sizes=Object.keys(icons).map(function parse(str){return parseInt(str,10);});sizes.sort(function(x,y){return y-x;});var index=sizes[(HVGA)?sizes.length-1:0];iconPath=icons[index];}else{iconPath=app.icon;}
if(!iconPath){return null;}
if(iconPath.charAt(0)==='/'){var base=new URL(app.origin);var port=base.port?(':'+base.port):'';iconPath=base.protocol+'//'+base.hostname+port+iconPath;}
return iconPath;}
function getOffOrigin(src,origin){src=src||origin;var cacheKey=JSON.stringify(Array.prototype.slice.call(arguments));if(!getOffOrigin.cache[cacheKey]){var native=new URL(origin);var current=new URL(src);if(current.protocol=='http:'){getOffOrigin.cache[cacheKey]=current.protocol+'//'+
current.hostname;}else if(native.protocol==current.protocol&&native.hostname==current.hostname&&native.port==current.port){getOffOrigin.cache[cacheKey]='';}else if(current.protocol=='app:'){getOffOrigin.cache[cacheKey]='';}else{getOffOrigin.cache[cacheKey]=current.protocol+'//'+
current.hostname;}}
return getOffOrigin.cache[cacheKey];}
getOffOrigin.cache={};function escapeHTML(str,escapeQuotes){var stringHTML=str;stringHTML=stringHTML.replace(/</g,'&#60;');stringHTML=stringHTML.replace(/(\r\n|\n|\r)/gm,'<br/>');stringHTML=stringHTML.replace(/\s\s/g,' &nbsp;');if(escapeQuotes){return stringHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');}
return stringHTML;}
exports.CardsHelper={getIconURIForApp:getIconURIForApp,getOffOrigin:getOffOrigin,escapeHTML:escapeHTML,isHVGA:isHVGA};})(window);;'use strict';(function(exports){var _id=0;function Card(config){if(config){for(var key in config){this[key]=config[key];}}
this.instanceID=_id++;return this;}
Card.prototype=Object.create(BaseUI.prototype);Card.prototype.constructor=Card;Card.prototype.EVENT_PREFIX='card-';Card.prototype.containerElement=null;Card.prototype.CLASS_NAME='Card';Card.prototype.element=null;Card.prototype.closeButtonVisibility='hidden';Card.prototype.favoriteButtonVisibility='hidden';Card.prototype.toString=function(){return'['+this.CLASS_NAME+' '+
this.position+':'+this.title+']';};Card.prototype.getScreenshotPreviewsSetting=function(){return this.manager.useAppScreenshotPreviews;};Card.prototype.template=function(){return Tagged.escapeHTML`<div class="titles">
     <h1 id="${this.titleId}" dir="auto" class="title">${this.title}</h1>
     <p class="subtitle">
      <span class="subtitle-url">${this.subTitle}</span>
     </p>
    </div>

    <div class="screenshotView bb-button" data-l10n-id="openCard"
      role="link"></div>
    <div class="privateOverlay"></div>
    <div class="appIconView" style="background-image:${this.iconValue}"></div>

    <footer class="card-tray">
     <button class="appIcon" data-l10n-id="openCard"
       data-button-action="select" aria-hidden="true"></button>
     <menu class="buttonbar">
       <button class="close-button bb-button" data-l10n-id="closeCard"
         data-button-action="close" role="button"
         style="visibility: ${this.closeButtonVisibility}"></button>
      <button class="favorite-button bb-button"
        data-button-action="favorite" role="button"
        style="visibility: ${this.favoriteButtonVisibility}"></button>
     </menu>
    </footer>`;};Card.prototype.view=function c_view(){return this.template();};Card.prototype._populateViewData=function(){var app=this.app;this.title=(app.isBrowser()&&app.title)?app.title:app.shortName||app.name;this.sslState=app.getSSLState();this.subTitle='';this.iconValue='';this.closeButtonVisibility='visible';this.viewClassList=['card','appIconPreview'];this.titleId='card-title-'+this.instanceID;if(app.isPrivate){this.viewClassList.push('private');}
var iconURI=CardsHelper.getIconURIForApp(this.app);if(iconURI){this.iconValue='url('+iconURI+')';}
var origin=app.origin;var popupFrame;var frameForScreenshot=app.getFrameForScreenshot();var displayUrl='';if(app.isBrowser()){displayUrl=app.config.url||origin;if(displayUrl.startsWith('app://')){displayUrl=false;}}else if(frameForScreenshot&&CardsHelper.getOffOrigin(frameForScreenshot.src,origin)){displayUrl=CardsHelper.getOffOrigin(frameForScreenshot.src,origin);}
if(displayUrl){this.subTitle=this.getDisplayURLString(displayUrl);this.viewClassList.push('show-subtitle');}
if(TrustedUIManager.hasTrustedUI(app.origin)){popupFrame=TrustedUIManager.getDialogFromOrigin(app.origin);this.title=CardsHelper.escapeHTML(popupFrame.name||'',true);this.viewClassList.push('trustedui');}else if(!this.app.killable()){this.closeButtonVisibility='hidden';}};Card.prototype.move=function(deltaX,deltaY){deltaX=deltaX||0;deltaY=deltaY||0;var windowWidth=this.manager.windowWidth||window.innerWidth;var offset=this.position-this.manager.position;var positionX=deltaX+offset*(windowWidth*0.55);this.element.dataset.positionX=positionX;var style={transform:''};if(deltaX||offset){style.transform='translateX('+positionX+'px)';}
if(deltaY){style.transform='translateY('+deltaY+'px)';}
this.applyStyle(style);};Card.prototype.render=function(){this.publish('willrender');var elem=this.element||(this.element=document.createElement('li'));elem.dataset.position=this.position;elem.dataset.appInstanceId=this.app.instanceID;elem.dataset.origin=this.app.origin;this._populateViewData();elem.innerHTML=this.view();elem.setAttribute('aria-labelledby',this.titleId);elem.setAttribute('role','group');if(this.sslState){elem.dataset.ssl=this.sslState;}
elem.setAttribute('aria-labelledby',this.titleId);this.viewClassList.forEach(function(cls){elem.classList.add(cls);});if(this.containerElement){this.containerElement.appendChild(elem);}
this._fetchElements();this._updateDisplay();this.publish('rendered');return elem;};Card.prototype.applyStyle=function(nameValues){var style=this.element.style;for(var property in nameValues){if(undefined===nameValues[property]){delete style[[property]];}else{style[property]=nameValues[property];}}};Card.prototype.setVisibleForScreenReader=function(visible){this.element.setAttribute('aria-hidden',!visible);};Card.prototype.killApp=function(){this.app.kill();};Card.prototype.destroy=function(){this.publish('willdestroy');var element=this.element;if(element&&element.parentNode){element.parentNode.removeChild(element);}
this.element=this.manager=this.app=null;this.publish('destroyed');};Card.prototype._updateDisplay=function c_updateDisplay(){var elem=this.element;var app=this.app;if(app.isBrowser()){elem.classList.add('browser');}
var screenshotView=this.screenshotView;var isIconPreview=!this.getScreenshotPreviewsSetting();if(isIconPreview){elem.classList.add('appIconPreview');}else{elem.classList.remove('appIconPreview');if(screenshotView.style.backgroundImage){return;}}
if(this.iconValue){this.iconButton.style.backgroundImage=this.iconValue;}
if(isIconPreview){return;}
var cachedLayer;if(app.isActive()){cachedLayer=app.requestScreenshotURL();screenshotView.classList.toggle('fullscreen',app.isFullScreen());if(app.appChrome){screenshotView.classList.toggle('maximized',app.appChrome.isMaximized());}}
screenshotView.style.backgroundImage=(cachedLayer?'url('+cachedLayer+')':'none')+','+'-moz-element(#'+this.app.instanceID+')';};Card.prototype._fetchElements=function c__fetchElements(){this.screenshotView=this.element.querySelector('.screenshotView');this.titleNode=this.element.querySelector('h1.title');this.iconButton=this.element.querySelector('.appIcon');};Card.prototype.getDisplayURLString=function(url){var anURL;try{anURL=this.app?new URL(url,this.app.origin):new URL(url);}catch(e){return url;}
var displayString=url.substring(url.indexOf(anURL.host));return displayString;};return(exports.Card=Card);})(window);;(function(exports){'use strict';var DEBUG=false;function TaskManager(){this.stack=null;this.cardsByAppID={};}
TaskManager.prototype=Object.create({SCREENSHOT_PREVIEWS_SETTING_KEY:'app.cards_view.screenshots.enabled',DURATION:200,SWIPE_UP_THRESHOLD:100,SWITCH_CARD_THRESHOLD:30,useAppScreenshotPreviews:true,position:0,_shouldGoBackHome:false,_active:false,windowWidth:window.innerWidth,windowHeight:window.innerHeight},{currentCard:{get:function cs_getCurrentCard(){return this.getCardAtIndex(this.position);}}});TaskManager.prototype.EVENT_PREFIX='taskmanager';TaskManager.prototype.name='TaskManager';TaskManager.prototype.start=function(){this._fetchElements();this._registerEvents();this._appClosedHandler=this._appClosed.bind(this);Service.request('registerHierarchy',this);};TaskManager.prototype.stop=function(){this._unregisterEvents();Service.request('unregisterHierarchy',this);};TaskManager.prototype._fetchElements=function(){this.element=document.getElementById('cards-view'),this.cardsList=document.getElementById('cards-list');this.screenElement=document.getElementById('screen');};TaskManager.prototype._registerEvents=function(){window.addEventListener('taskmanagershow',this);this.onPreviewSettingsChange=function(settingValue){this.useAppScreenshotPreviews=settingValue;}.bind(this);SettingsListener.observe(this.SCREENSHOT_PREVIEWS_SETTING_KEY,this.useAppScreenshotPreviews,this.onPreviewSettingsChange);};TaskManager.prototype._unregisterEvents=function(){window.removeEventListener('taskmanagershow',this);SettingsListener.unobserve(this.SCREENSHOT_PREVIEWS_SETTING_KEY,this.onPreviewSettingsChange);};TaskManager.prototype._appClosed=function cs_appClosed(evt){window.removeEventListener('appclosed',this._appClosedHandler);window.removeEventListener('homescreenclosed',this._appClosedHandler);this.screenElement.classList.add('cards-view');this.element.classList.remove('from-home');};TaskManager.prototype.show=function cs_showCardSwitcher(filterName){if(this.isShown()){return;}
if(document.mozFullScreen){document.mozCancelFullScreen();}
this.calculateDimensions();this.newStackPosition=null;this._registerShowingEvents();if(this.filter(filterName)){this.element.classList.add('filtered');}
var stack=this.stack;stack.forEach(function(app,position){this.addCard(position,app);},this);this.unfilteredStack.forEach(function(app,position){app.enterTaskManager();});this._placeCards();this.setActive(true);var screenElement=this.screenElement;var activeApp=Service.currentApp;if(!activeApp){screenElement.classList.add('cards-view');return;}
if(activeApp.isHomescreen){activeApp.close('home-to-cardview');this.element.classList.add('from-home');window.addEventListener('homescreenclosed',this._appClosedHandler);}else{window.addEventListener('appclosed',this._appClosedHandler);}};TaskManager.prototype.hide=function cs_hideCardSwitcher(){if(!this.isActive()){return;}
this._unregisterShowingEvents();this._removeCards();this.setActive(false);window.removeEventListener('appclosed',this._appClosedHandler);window.removeEventListener('homescreenclosed',this._appClosedHandler);this.screenElement.classList.remove('cards-view');var detail;if(!isNaN(this.newStackPosition)){detail={'detail':{'newStackPosition':this.newStackPosition}};}
this.publishNextTick('cardviewclosed',detail);};TaskManager.prototype._showingEventsRegistered=false;TaskManager.prototype._registerShowingEvents=function(){if(this._showingEventsRegistered){return;}
this._showingEventsRegistered=true;window.addEventListener('lockscreen-appopened',this);window.addEventListener('attentionopened',this);window.addEventListener('appopen',this);window.addEventListener('appterminated',this);window.addEventListener('wheel',this);window.addEventListener('resize',this);this.element.addEventListener('touchstart',this);this.element.addEventListener('touchmove',this);this.element.addEventListener('touchend',this);};TaskManager.prototype._unregisterShowingEvents=function(){if(!this._showingEventsRegistered){return;}
window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('attentionopened',this);window.removeEventListener('appopen',this);window.removeEventListener('appterminated',this);window.removeEventListener('wheel',this);window.removeEventListener('resize',this);if(this.element){this.element.removeEventListener('touchstart',this);this.element.removeEventListener('touchmove',this);this.element.removeEventListener('touchend',this);}
this._showingEventsRegistered=false;};TaskManager.prototype.isShown=function(){return this.isActive();};TaskManager.prototype.isActive=function(){return this._active;};TaskManager.prototype.setActive=function(active){if(active==this._active){return;}
this._active=active;if(active){this.publish(this.EVENT_PREFIX+'-activated');}else{this.publish(this.EVENT_PREFIX+'-deactivated');}
this.element.classList.toggle('active',active);this.element.classList.toggle('empty',!this.stack.length&&active);this.publishNextTick(active?'cardviewshown':'cardviewbeforeclose');};TaskManager.prototype.filter=function cs_filterCardStack(filterName){var unfilteredStack=this.unfilteredStack=StackManager.snapshot();var noRecentWindows=document.getElementById('cards-no-recent-windows');switch(filterName){case'browser-only':this.stack=unfilteredStack.filter(function(app){return app.isBrowser()||(app.manifest&&app.manifest.role==='search');});navigator.mozL10n.setAttributes(noRecentWindows,'no-recent-browser-windows');break;case'apps-only':this.stack=unfilteredStack.filter(function(app){return!app.isBrowser();});navigator.mozL10n.setAttributes(noRecentWindows,'no-recent-app-windows');break;default:this.stack=unfilteredStack;break;}
this.position=this.stack.indexOf(unfilteredStack[StackManager.position]);if(this.position===-1||StackManager.outOfStack()){this.position=this.stack.length-1;this._shouldGoBackHome=true;}else{this._shouldGoBackHome=false;}
return this.stack!==unfilteredStack;};TaskManager.prototype.addCard=function cs_addCard(position,app){var config={manager:this,position:position,app:app,windowWidth:this.windowWidth,windowHeight:this.windowHeight};var card=new Card(config);this.cardsByAppID[app.instanceID]=card;this.cardsList.appendChild(card.render());if(position<=this.position-2||position>=this.position+2){card.element.style.visibility='hidden';}};TaskManager.prototype.removeCard=function cs_removeCard(card){var element=card.element;var position=element.dataset.position;delete this.cardsByAppID[card.app.instanceID];card.destroy();element=null;this.stack.splice(position,1);var cardNodes=this.cardsList.childNodes;for(var i=position,remainingCard=null;i<cardNodes.length;i++){remainingCard=this.getCardForElement(cardNodes[i]);if(remainingCard){remainingCard.position=i;cardNodes[i].dataset.position=i;}}
var cardsLength=cardNodes.length;if(!cardsLength){var homescreen=homescreenLauncher.getHomescreen(true);this.exitToApp(homescreen);}
if(cardsLength===this.position){this.position--;}
this.alignCurrentCard();};TaskManager.prototype._removeCards=function cs_removeCards(){this.stack.forEach(function(app,idx){var card=this.cardsByAppID[app.instanceID];card&&card.destroy();},this);this.unfilteredStack.forEach(function(app,position){app.leaveTaskManager();});this.cardsByAppID={};this.element.classList.remove('filtered');this.cardsList.innerHTML='';};TaskManager.prototype.cardAction=function cs_cardAction(card,actionName){switch(actionName){case'close':card.killApp();break;case'favorite':debug('cardAction: TODO: favorite '+card.element.dataset.origin);break;case'select':if(this.position!=card.position){this.position=card.position;this.alignCurrentCard();}
var self=this;this.currentCard.element.addEventListener('transitionend',function afterTransition(e){e.target.removeEventListener('transitionend',afterTransition);self.exitToApp(card.app);});this.currentCard.element.classList.add('select');break;}};TaskManager.prototype.exitToApp=function(app){this.screenElement.classList.remove('cards-view');this._unregisterShowingEvents();if(this._shouldGoBackHome){app=app||homescreenLauncher.getHomescreen(true);}else if(!app){app=this.stack?this.stack[this.position]:homescreenLauncher.getHomescreen(true);}
var position=this.unfilteredStack?this.unfilteredStack.indexOf(app):-1;if(position!==StackManager.position){this.newStackPosition=position;}
setTimeout(()=>{var finish=()=>{this.element.classList.remove('to-home');this.hide();};eventSafety(app.element,'_opened',finish,400);if(app.isHomescreen){this.element.classList.add('to-home');app.open('home-from-cardview');}else{app.open('from-cardview');}},100);};TaskManager.prototype.handleWheel=function cs_handleWheel(evt){if(evt.deltaMode!==evt.DOM_DELTA_PAGE||evt.deltaY<0){return;}
if(evt.deltaY>0){var card=this.currentCard;if(card.app.killable()){card.killApp();}else{card.applyStyle({MozTransform:''});}}else if(evt.deltaX>0&&this.position<this.cardsList.childNodes.length-1){this.position++;}else if(evt.deltaX<0&&this.position>0){this.position--;}
this.alignCurrentCard();};TaskManager.prototype.respondToHierarchyEvent=function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;};TaskManager.prototype._handle_home=function(){if(this.isActive()){this._shouldGoBackHome=true;this.exitToApp();return false;}
return true;};TaskManager.prototype._handle_holdhome=function(evt){if(this.isShown()){return true;}
var filter=null;if(evt.type==='taskmanagershow'){filter=(evt.detail&&evt.detail.filter)||null;}
var currOrientation=OrientationManager.fetchCurrentOrientation();var shouldResize=(OrientationManager.defaultOrientation.split('-')[0]!=currOrientation.split('-')[0]);var shouldHideKeyboard=layoutManager.keyboardEnabled;this.publish('cardviewbeforeshow');var finish=()=>{if(shouldHideKeyboard){window.addEventListener('keyboardhidden',function kbHidden(){window.removeEventListener('keyboardhidden',kbHidden);shouldHideKeyboard=false;setTimeout(finish);});return;}
screen.mozLockOrientation(OrientationManager.defaultOrientation);if(shouldResize){window.addEventListener('resize',function resized(){window.removeEventListener('resize',resized);shouldResize=false;setTimeout(finish);});return;}
var app=Service.currentApp;if(app&&!app.isHomescreen){app.getScreenshot(function onGettingRealtimeScreenshot(){this.show(filter);}.bind(this),0,0,300);}else{this.show(filter);}};finish();};TaskManager.prototype.handleTap=function cs_handleTap(evt){var targetNode=evt.target;var cardElem=null;var tmpNode=targetNode;while(tmpNode){if(tmpNode.classList&&tmpNode.classList.contains('card')){cardElem=tmpNode;break;}
tmpNode=tmpNode.parentNode;}
var card=this.getCardForElement(cardElem);if(!card){return;}
if('buttonAction'in targetNode.dataset){this.cardAction(card,targetNode.dataset.buttonAction);return;}
if(('position'in targetNode.dataset)||card){this.cardAction(card,'select');return;}};TaskManager.prototype.calculateDimensions=function cv_calculateDimensions(evt){this.windowWidth=window.innerWidth;this.windowHeight=window.innerHeight;};TaskManager.prototype.handleEvent=function cv_handleEvent(evt){var app;switch(evt.type){case'touchstart':this.onTouchStart(evt);evt.preventDefault();evt.stopPropagation();break;case'touchmove':this.onTouchMove(evt);evt.stopPropagation();evt.preventDefault();break;case'touchend':this.onTouchEnd(evt);evt.stopPropagation();evt.preventDefault();break;case'resize':this.calculateDimensions();this.alignCurrentCard();break;case'wheel':this.handleWheel(evt);break;case'lockscreen-appopened':case'attentionopened':this.exitToApp();break;case'taskmanagershow':this._handle_holdhome(evt);break;case'taskmanagerhide':case'appopen':this.hide();break;case'appterminated':app=evt.detail;var card=app&&this.cardsByAppID[app.instanceID];if(card&&card.app&&app.instanceID===card.app.instanceID){this.removeCard(card);}
break;}};TaskManager.prototype.publish=function tm_publish(type,detail){var event=new CustomEvent(type,detail||null);window.dispatchEvent(event);};TaskManager.prototype.publishNextTick=function tm_publish(type,detail){var event=new CustomEvent(type,detail||null);setTimeout(function nextTick(){window.dispatchEvent(event);});};TaskManager.prototype.getCardAtIndex=function(idx){if(this.stack&&idx>-1&&idx<this.stack.length){var app=this.stack[idx];var card=app&&this.cardsByAppID[app.instanceID];if(card){return card;}}
debug('getCardAtIndex, no card at idx: '+idx);return null;};TaskManager.prototype.getCardForElement=function(element){return element&&this.cardsByAppID[element.dataset.appInstanceId];};TaskManager.prototype._setAccessibilityAttributes=function(){this.stack.forEach(function(app,idx){var card=this.cardsByAppID[app.instanceID];if(!card){return;}
card.setVisibleForScreenReader(idx===this.position);card.element.setAttribute('aria-setsize',this.stack.length);card.element.setAttribute('aria-posinset',idx+1);},this);};TaskManager.prototype._placeCards=function(){this.stack.forEach(function(app,idx){var card=this.cardsByAppID[app.instanceID];if(!card){return;}
card.move(0,0);card.element.classList.toggle('current',(idx==this.position));}.bind(this));this._setAccessibilityAttributes();};TaskManager.prototype.alignCurrentCard=function(duration,callback){this._setupCardsTransition(duration||this.DURATION);this._placeCards();};TaskManager.prototype.moveCards=function(){var deltaX=this.deltaX;var sign=(deltaX>0)?-1:1;if(this.onExtremity()){deltaX/=1.5;}
var current=this.position;this.stack.forEach(function(app,idx){var card=this.cardsByAppID[app.instanceID];if(idx>=current-2&&idx<=current+2){card.move(Math.abs(deltaX)*sign);}},this);};TaskManager.prototype.onExtremity=function(){var sign=(this.deltaX>0)?-1:1;return(this.position===0&&sign===1||this.position===this.stack.length-1&&sign===-1);};TaskManager.prototype.onTouchMoveForDeleting=function(evt){var dx=this.deltaX;var dy=this.deltaY;if(dy>0){var card=this.getCardForElement(evt.target);if(!card){return;}
if('function'==typeof card.move){card.move(dx,-dy);}else{card.applyStyle({transform:'translateY('+(-dy)+'px)'});}}};TaskManager.prototype.onTouchStart=function cs_onTouchStart(evt){if(this.element.classList.contains('empty')){var homescreen=homescreenLauncher.getHomescreen(true);this.exitToApp(homescreen);return;}
this._dragPhase='';this.deltaX=0;this.deltaY=0;this.startTouchPosition=[evt.touches[0].pageX,evt.touches[0].pageY];this.startTouchDate=Date.now();this._resetCardsTransition();};TaskManager.prototype.onTouchEnd=function cs_onTouchEnd(evt){this.deltaX=evt.changedTouches[0].pageX-this.startTouchPosition[0];this.deltaY=evt.changedTouches[0].pageY-this.startTouchPosition[1];if(this._dragPhase=='cross-slide'){var element=evt.target;var card=this.getCardForElement(element);if(!card){return;}
if(-this.deltaY>this.SWIPE_UP_THRESHOLD&&card.app.killable()){card.killApp();}else{card.applyStyle({transform:''});}
this.alignCurrentCard();return;}
if(Math.abs(this.deltaX)<=1){this.handleTap(evt);return;}
var speed=this.deltaX/(Date.now()-this.startTouchDate);var inertia=speed*250;var boosted=this.deltaX+inertia;var progress=Math.abs(boosted)/this.windowWidth;if(progress>0.5){progress-=0.5;}
var switching=Math.abs(boosted)>=this.SWITCH_CARD_THRESHOLD;if(switching){if(this.deltaX<0&&this.position<this.cardsList.childNodes.length-1){this.position++;}else if(this.deltaX>0&&this.position>0){this.position--;}}
var durationLeft=Math.max(50,(1-progress)*this.DURATION);this.alignCurrentCard(durationLeft);};TaskManager.prototype.onTouchMove=function cs_onTouchMove(evt){this.deltaX=this.startTouchPosition[0]-evt.touches[0].pageX;this.deltaY=this.startTouchPosition[1]-evt.touches[0].pageY;switch(this._dragPhase){case'':if(this.deltaY>this.SWIPE_UP_THRESHOLD&&evt.target.classList.contains('card')){this._dragPhase='cross-slide';this.onTouchMoveForDeleting(evt);}else{if(Math.abs(this.deltaX)>this.SWITCH_CARD_THRESHOLD){this._dragPhase='scrolling';}
this.moveCards();}
break;case'cross-slide':this.onTouchMoveForDeleting(evt);break;case'scrolling':this.moveCards();break;}};TaskManager.prototype._setupCardsTransition=function(duration){var position=this.position;var self=this;this.stack.forEach(function(app,idx){var card=self.cardsByAppID[app.instanceID];if(idx<position-2||idx>position+2){card.element.style.visibility='hidden';return;}
card.element.style.visibility='';var style={transition:'transform '+duration+'ms linear'};card.applyStyle(style);});};TaskManager.prototype._resetCardsTransition=function(){var zeroTransitionStyle={transition:''};this.stack.forEach(function(app,idx){var card=this.cardsByAppID[app.instanceID];card.applyStyle(zeroTransitionStyle);},this);};exports.TaskManager=TaskManager;function debug(message){if(DEBUG){console.log('TaskManager > \n  ',message);}}})(window);;'use strict';var Bluetooth={name:'Bluetooth',get Profiles(){return{HFP:'hfp',OPP:'opp',A2DP:'a2dp',SCO:'sco'};},_setProfileConnected:function bt_setProfileConnected(profile,connected){var value=this['_'+profile+'Connected'];if(value!=connected){this['_'+profile+'Connected']=connected;var evt=document.createEvent('CustomEvent');evt.initCustomEvent('bluetoothprofileconnectionchange',true,false,{name:profile,connected:connected});window.dispatchEvent(evt);}},getCurrentProfiles:function bt_getCurrentProfiles(){var profiles=this.Profiles;var connectedProfiles=[];for(var name in profiles){var profile=profiles[name];if(this.isProfileConnected(profile)){connectedProfiles.push(profile);}}
return connectedProfiles;},isProfileConnected:function bt_isProfileConnected(profile){var isConnected=this['_'+profile+'Connected'];if(isConnected===undefined){return false;}else{return isConnected;}},defaultAdapter:null,connected:false,init:function bt_init(){if(!window.navigator.mozSettings||!window.navigator.mozBluetooth){return;}
var bluetooth=window.navigator.mozBluetooth;var self=this;SettingsListener.observe('bluetooth.enabled',true,function(value){if(!bluetooth){if(value){SettingsListener.getSettingsLock().set({'bluetooth.enabled':false});}
return;}});bluetooth.onadapteradded=function bt_onAdapterAdded(){var evt=document.createEvent('CustomEvent');evt.initCustomEvent('bluetooth-adapter-added',true,false,null);window.dispatchEvent(evt);self.initDefaultAdapter();};this.initDefaultAdapter();bluetooth.ondisabled=function bt_onDisabled(){var evt=document.createEvent('CustomEvent');evt.initCustomEvent('bluetooth-disabled',true,false,null);window.dispatchEvent(evt);};navigator.mozSetMessageHandler('bluetooth-opp-transfer-start',function bt_fileTransferUpdate(transferInfo){self._setProfileConnected(self.Profiles.OPP,true);self.updateConnected();var evt=document.createEvent('CustomEvent');evt.initCustomEvent('bluetooth-opp-transfer-start',true,false,{transferInfo:transferInfo});window.dispatchEvent(evt);});navigator.mozSetMessageHandler('bluetooth-opp-transfer-complete',function bt_fileTransferUpdate(transferInfo){self._setProfileConnected(self.Profiles.OPP,false);self.updateConnected();var evt=document.createEvent('CustomEvent');evt.initCustomEvent('bluetooth-opp-transfer-complete',true,false,{transferInfo:transferInfo});window.dispatchEvent(evt);});window.addEventListener('request-enable-bluetooth',this);window.addEventListener('request-disable-bluetooth',this);Service.registerState('isEnabled',this);},handleEvent:function bt_handleEvent(evt){switch(evt.type){case'request-enable-bluetooth':SettingsListener.getSettingsLock().set({'bluetooth.enabled':true});break;case'request-disable-bluetooth':SettingsListener.getSettingsLock().set({'bluetooth.enabled':false});break;}},initDefaultAdapter:function bt_initDefaultAdapter(){var bluetooth=window.navigator.mozBluetooth;var self=this;if(!bluetooth||!bluetooth.enabled||!('getDefaultAdapter'in bluetooth)){return;}
var req=bluetooth.getDefaultAdapter();req.onsuccess=function bt_gotDefaultAdapter(evt){self.defaultAdapter=req.result;self.initWithAdapter(self.defaultAdapter);};},initWithAdapter:function bt_initWithAdapter(adapter){var self=this;adapter.onhfpstatuschanged=function bt_hfpStatusChanged(evt){self._setProfileConnected(self.Profiles.HFP,evt.status);self.updateConnected();};adapter.ona2dpstatuschanged=function bt_a2dpStatusChanged(evt){self._setProfileConnected(self.Profiles.A2DP,evt.status);self.updateConnected();};adapter.onscostatuschanged=function bt_scoStatusChanged(evt){self._setProfileConnected(self.Profiles.SCO,evt.status);};},updateConnected:function bt_updateConnected(){var bluetooth=window.navigator.mozBluetooth;if(!bluetooth){return;}
var wasConnected=this.connected;this.connected=this.isProfileConnected(this.Profiles.HFP)||this.isProfileConnected(this.Profiles.A2DP)||this.isProfileConnected(this.Profiles.OPP);if(wasConnected!==this.connected){var evt=document.createEvent('CustomEvent');evt.initCustomEvent('bluetoothconnectionchange',true,false,{deviceConnected:this.connected});window.dispatchEvent(evt);}},getAdapter:function bt_getAdapter(){return this.defaultAdapter;},get isEnabled(){return window.navigator.mozBluetooth.enabled;}};;'use strict';var BluetoothTransfer={_sendingFilesQueue:[],_debug:false,get _deviceStorage(){return navigator.getDeviceStorage('sdcard');},get transferStatusList(){var transferStatusList=document.getElementById('bluetooth-transfer-status-list');delete this.transferStatusList;this.transferStatusList=transferStatusList;return transferStatusList;},init:function bt_init(){window.addEventListener('iac-bluetoothTransfercomms',this._onFilesSending.bind(this));navigator.mozSetMessageHandler('bluetooth-opp-receiving-file-confirmation',this.onReceivingFileConfirmation.bind(this));window.addEventListener('bluetooth-opp-transfer-start',this._onUpdateProgress.bind(this,'start'));navigator.mozSetMessageHandler('bluetooth-opp-update-progress',this._onUpdateProgress.bind(this,'progress'));window.addEventListener('bluetooth-opp-transfer-complete',this._onTransferComplete.bind(this));},getDeviceName:function bt_getDeviceName(address){return new Promise(function(resolve){var _=navigator.mozL10n.get;var adapter=Bluetooth.getAdapter();if(adapter==null){var msg='Since cannot get Bluetooth adapter, '+'resolve with an unknown device.';this.debug(msg);resolve(_('unknown-device'));}
var self=this;var serviceUuid='0x1105';var req=adapter.getConnectedDevices(serviceUuid);req.onsuccess=function bt_gotConnectedDevices(){if(req.result){var connectedList=req.result;var length=connectedList.length;for(var i=0;i<length;i++){if(connectedList[i].address==address){resolve(connectedList[i].name);}}}else{resolve(_('unknown-device'));}};req.onerror=function(){var msg='Can not check is device connected from adapter.';self.debug(msg);resolve(_('unknown-device'));};}.bind(this));},debug:function bt_debug(msg){if(!this._debug){return;}
console.log('[System Bluetooth Transfer]: '+msg);},humanizeSize:function bt_humanizeSize(bytes){var _=navigator.mozL10n.get;var units=['B','KB','MB','GB','TB','PB','EB','ZB','YB'];var size,e;if(bytes){e=Math.floor(Math.log(bytes)/Math.log(1024));size=(bytes/Math.pow(1024,e)).toFixed(2);}else{e=0;size='0.00';}
return _('fileSize',{size:size,unit:_('byteUnit-'+units[e])});},_onFilesSending:function bt__onFilesSending(evt){var icon='style/bluetooth_transfer/images/transfer.png';NotificationHelper.send('transfer-has-started-title',{'bodyL10n':'transfer-has-started-description','icon':icon}).then(function(notification){notification.addEventListener('click',UtilityTray.show.bind(UtilityTray));});var sendingFilesSchedule=evt.detail;this._sendingFilesQueue.push(sendingFilesSchedule);var msg='push sending files request in queue, queued length = '+
this._sendingFilesQueue.length;this.debug(msg);},onReceivingFileConfirmation:function bt_onReceivingFileConfirmation(evt){if(NfcHandoverManager.isHandoverInProgress()){this.debug('Incoming file via NFC Handover. Bypassing confirm dialog');window.dispatchEvent(new CustomEvent('nfc-transfer-started'));this.acceptReceive(evt);return;}
var address=evt.address;var self=this;var icon='style/bluetooth_transfer/images/icon_bluetooth.png';this.getDeviceName(address).then(function(deviceName){var title={id:'transfer-confirmation-title',args:{deviceName:deviceName}};var body='transfer-confirmation-description';NotificationHelper.send(title,{'bodyL10n':body,'icon':icon}).then(function(notification){notification.addEventListener('click',function(){UtilityTray.hide();self.showReceivePrompt(evt);});});});},showReceivePrompt:function bt_showReceivePrompt(evt){var address=evt.address;var fileName=evt.fileName;var fileSize=this.humanizeSize(evt.fileLength);var cancel={title:'deny',callback:this.declineReceive.bind(this,address)};var confirm={title:'transfer',callback:this.acceptReceive.bind(this,evt),recommend:true};var screen=document.getElementById('screen');this.getDeviceName(address).then(function(deviceName){CustomDialog.show('acceptFileTransfer',{id:'wantToReceiveFile',args:{deviceName:deviceName,fileName:fileName,fileSize:fileSize}},cancel,confirm,screen).setAttribute('data-z-index-level','system-dialog');});},declineReceive:function bt_declineReceive(address){CustomDialog.hide();var adapter=Bluetooth.getAdapter();if(adapter!=null){adapter.confirmReceivingFile(address,false);}else{var msg='Cannot get adapter from system Bluetooth monitor.';this.debug(msg);}},acceptReceive:function bt_acceptReceive(evt){CustomDialog.hide();var address=evt.address;var fileSize=evt.fileLength;var self=this;this.checkStorageSpace(fileSize,function checkStorageSpaceComplete(isStorageAvailable,errorMessage){var adapter=Bluetooth.getAdapter();var option=(isStorageAvailable)?true:false;if(adapter){adapter.confirmReceivingFile(address,option);}else{var msg='Cannot get adapter from system Bluetooth monitor.';self.debug(msg);}
if(!isStorageAvailable){self.showStorageUnavaliablePrompt(errorMessage);}});},showStorageUnavaliablePrompt:function bt_showStorageUnavaliablePrompt(msg){var confirm={title:'confirm',callback:function(){CustomDialog.hide();}};var body=msg;var screen=document.getElementById('screen');CustomDialog.show('cannotReceiveFile',body,confirm,null,screen).setAttribute('data-z-index-level','system-dialog');},checkStorageSpace:function bt_checkStorageSpace(fileSize,callback){if(!callback){return;}
var storage=this._deviceStorage;var availreq=storage.available();availreq.onsuccess=function(e){switch(availreq.result){case'available':break;case'unavailable':callback(false,'sdcard-not-exist2');return;case'shared':callback(false,'sdcard-in-use');return;default:callback(false,'unknown-error');return;}
var freereq=storage.freeSpace();freereq.onsuccess=function(){if(freereq.result>=fileSize){callback(true,'');}else{callback(false,'sdcard-no-space2');}};freereq.onerror=function(){callback(false,'cannotGetStorageState');};};availreq.onerror=function(e){callback(false,'cannotGetStorageState');};},get isSendFileQueueEmpty(){return this._sendingFilesQueue.length===0;},get isFileTransferInProgress(){var jobs=this.transferStatusList.querySelector('div');return jobs!=null;},sendFileViaHandover:function bt_sendFileViaHandover(mac,blob){var adapter=Bluetooth.getAdapter();if(adapter!=null){var sendingFilesSchedule={viaHandover:true,numberOfFiles:1,numSuccessful:0,numUnsuccessful:0};this._onFilesSending({detail:sendingFilesSchedule});var waitConnectionReadyTimeoutTime=3000;setTimeout(function(){adapter.sendFile(mac,blob);},waitConnectionReadyTimeoutTime);}else{var msg='Cannot get adapter from system Bluetooth monitor.';this.debug(msg);}},_onUpdateProgress:function bt__onUpdateProgress(mode,evt){switch(mode){case'start':var transferInfo=evt.detail.transferInfo;this.initProgress(transferInfo);break;case'progress':var processedLength=evt.processedLength;var fileLength=evt.fileLength;var progress=0;if(fileLength===0){}else if(processedLength>fileLength){}else{progress=processedLength/fileLength;}
this.updateProgress(progress,evt);break;}},initProgress:function bt_initProgress(evt){var _=navigator.mozL10n.get;var address=evt.address;var transferMode=(evt.received===true)?_('bluetooth-receiving-progress'):_('bluetooth-sending-progress');var content=`<div data-icon="bluetooth-transfer-circle"></div>
      <div class="title-container">${transferMode}</div>
      <progress value="0" max="1"></progress>`;var transferTask=document.createElement('div');transferTask.id='bluetooth-transfer-status';transferTask.className='fake-notification';transferTask.setAttribute('data-id',address);transferTask.setAttribute('role','link');transferTask.innerHTML=content;transferTask.addEventListener('click',this.onCancelTransferTask.bind(this));this.transferStatusList.appendChild(transferTask);},updateProgress:function bt_updateProgress(value,evt){var address=evt.address;var id='div[data-id="'+address+'"] progress';var progressEl=this.transferStatusList.querySelector(id);progressEl.value=value;},removeProgress:function bt_removeProgress(evt){var address=evt.address;var id='div[data-id="'+address+'"]';var finishedTask=this.transferStatusList.querySelector(id);if(finishedTask==null){return;}
finishedTask.removeEventListener('click',this.onCancelTransferTask.bind(this));this.transferStatusList.removeChild(finishedTask);},onCancelTransferTask:function bt_onCancelTransferTask(evt){var id=evt.target.dataset.id;UtilityTray.hide();this.showCancelTransferPrompt(id);},showCancelTransferPrompt:function bt_showCancelTransferPrompt(address){var cancel={title:'continueFileTransfer',callback:this.continueTransfer.bind(this)};var confirm={title:'cancel',callback:this.cancelTransfer.bind(this,address)};var screen=document.getElementById('screen');CustomDialog.show('cancelFileTransfer','cancelFileTransfer',cancel,confirm,screen).setAttribute('data-z-index-level','system-dialog');},continueTransfer:function bt_continueTransfer(){CustomDialog.hide();},cancelTransfer:function bt_cancelTransfer(address){CustomDialog.hide();var adapter=Bluetooth.getAdapter();if(adapter!=null){adapter.stopSendingFile(address);}else{var msg='Cannot get adapter from system Bluetooth monitor.';this.debug(msg);}},_onTransferComplete:function bt__onTransferComplete(evt){var transferInfo=evt.detail.transferInfo;this.removeProgress(transferInfo);var icon='style/bluetooth_transfer/images/icon_bluetooth.png';var nData={titleL10n:null,icon:icon,onclick:null};if(transferInfo.success===true){if(transferInfo.received){nData.titleL10n='transferFinished-receivedSuccessful-title';nData.onclick=this.openReceivedFile.bind(this,transferInfo);}else{nData.titleL10n='transferFinished-sentSuccessful-title';}}else{if(transferInfo.received){nData.titleL10n='transferFinished-receivedFailed-title';}else{nData.titleL10n='transferFinished-sentFailed-title';}}
var l10nArgs={icon:nData.icon};if(transferInfo.fileName){l10nArgs.body=transferInfo.fileName;}else{l10nArgs.bodyL10n='unknown-file';}
var promise=NotificationHelper.send(nData.titleL10n,l10nArgs);if(nData.onclick){promise.then(function(notification){notification.addEventListener('click',nData.onclick);});}
var viaHandover=false;if(this._sendingFilesQueue.length>0){viaHandover=this._sendingFilesQueue[0].viaHandover||false;}
this.summarizeSentFilesReport(transferInfo);var details={received:transferInfo.received,success:transferInfo.success,viaHandover:viaHandover};NfcHandoverManager.transferComplete(details);},summarizeSentFilesReport:function bt_summarizeSentFilesReport(transferInfo){if(transferInfo.received){return;}
var msg='remove the finished sending task from queue, queue length = ';var successful=transferInfo.success;var sendingFilesSchedule=this._sendingFilesQueue[0];var numberOfFiles=sendingFilesSchedule.numberOfFiles;if(numberOfFiles==1){this._sendingFilesQueue.shift();msg+=this._sendingFilesQueue.length;this.debug(msg);}else{if(successful){this._sendingFilesQueue[0].numSuccessful++;}else{this._sendingFilesQueue[0].numUnsuccessful++;}
var numSuccessful=this._sendingFilesQueue[0].numSuccessful;var numUnsuccessful=this._sendingFilesQueue[0].numUnsuccessful;if((numSuccessful+numUnsuccessful)==numberOfFiles){NotificationHelper.send('transferReport-title',{'bodyL10n':{id:'transferReport-description',args:{numSuccessful:numSuccessful,numUnsuccessful:numUnsuccessful}},'icon':'style/bluetooth_transfer/images/icon_bluetooth.png'});this._sendingFilesQueue.shift();msg+=this._sendingFilesQueue.length;this.debug(msg);}}},openReceivedFile:function bt_openReceivedFile(evt){var filePath='Download/Bluetooth/'+evt.fileName;var contentType=evt.contentType;var storageType='sdcard';var self=this;var storage=navigator.getDeviceStorage(storageType);var getreq=storage.get(filePath);getreq.onerror=function(){var msg='failed to get file:'+
filePath+getreq.error.name+
getreq.error.name;self.debug(msg);};getreq.onsuccess=function(){var file=getreq.result;var fileName=file.name;var extension=fileName.split('.').pop();var originalType=file.type||contentType;var mappedType=(MimeMapper.isSupportedType(originalType))?originalType:MimeMapper.guessTypeFromExtension(extension);var a=new MozActivity({name:mappedType=='text/vcard'?'import':'open',data:{type:mappedType,blob:file,filename:fileName}});a.onerror=function(e){var msg='open activity error:'+a.error.name;self.debug(msg);switch(a.error.name){case'NO_PROVIDER':UtilityTray.hide();self.showUnknownMediaPrompt(fileName);return;case'ActivityCanceled':return;case'USER_ABORT':return;default:return;}};a.onsuccess=function(e){var msg='open activity onsuccess';self.debug(msg);};};},showUnknownMediaPrompt:function bt_showUnknownMediaPrompt(fileName){var confirm={title:'confirm',callback:function(){CustomDialog.hide();}};var screen=document.getElementById('screen');var body={id:'unknownMediaTypeToOpenFile',args:{fileName:fileName}};CustomDialog.show('cannotOpenFile',body,confirm,null,screen).setAttribute('data-z-index-level','system-dialog');}};;'use strict';var Wifi={wifiEnabled:true,wifiDisabledByWakelock:false,screenOffTimeout:0,wifiSleepMode:false,kScanInterval:20*1000,_scanTimer:null,init:function wf_init(){if(!window.navigator.mozSettings)
return;if(!window.navigator.mozWifiManager)
return;window.addEventListener('screenchange',this);var battery=window.navigator.battery;battery.addEventListener('chargingchange',this);var name='wifi.disabled_by_wakelock';var req=SettingsListener.getSettingsLock().get(name);req.onsuccess=function gotWifiDisabledByWakelock(){if(!req.result[name])
return;var lock=navigator.mozSettings.createLock();lock.set({'wifi.enabled':true});lock.set({'wifi.disabled_by_wakelock':false});};this._wakeLockManager=new WifiWakeLockManager();this._wakeLockManager.onwakelockchange=this.maybeToggleWifi.bind(this);this._wakeLockManager.start();var self=this;var wifiManager=window.navigator.mozWifiManager;wifiManager.onenabled=function onWifiEnabled(){var evt=document.createEvent('CustomEvent');evt.initCustomEvent('wifi-enabled',true,false,null);window.dispatchEvent(evt);};wifiManager.ondisabled=function onWifiDisabled(){var evt=document.createEvent('CustomEvent');evt.initCustomEvent('wifi-disabled',true,false,null);window.dispatchEvent(evt);};wifiManager.onstatuschange=function onWifiDisabled(){var evt=document.createEvent('CustomEvent');evt.initCustomEvent('wifi-statuschange',true,false,null);window.dispatchEvent(evt);};SettingsListener.observe('wifi.screen_off_timeout',600000,function(value){self.screenOffTimeout=value;});SettingsListener.observe('wifi.sleepMode',true,function(value){self.wifiSleepMode=value;});SettingsListener.observe('wifi.enabled',true,function(value){if(!wifiManager&&value){self.wifiEnabled=false;if(value){SettingsListener.getSettingsLock().set({'wifi.enabled':false});}
return;}
self.wifiEnabled=value;clearTimeout(self._scanTimer);if(!value)
return;self._scanTimer=setInterval(function wifi_scan(){if(wifiManager.connection.status=='disconnected')
wifiManager.getNetworks();});});},handleEvent:function wifi_handleEvent(evt){this.maybeToggleWifi();},maybeToggleWifi:function wifi_maybeToggleWifi(){var cpuLock=navigator.requestWakeLock('cpu');var releaseCpuLock=function(){if(cpuLock){cpuLock.unlock();cpuLock=null;}
if(timeoutId){window.clearTimeout(timeoutId);timeoutId=0;}};var timeoutId=window.setTimeout(releaseCpuLock,30000);if(!this.screenOffTimeout){releaseCpuLock();return;}
var battery=window.navigator.battery;var wifiManager=window.navigator.mozWifiManager;if(!battery||!wifiManager||(!this.wifiEnabled&&!this.wifiDisabledByWakelock)){releaseCpuLock();return;}
var lock=SettingsListener.getSettingsLock();if(!ScreenManager.screenEnabled&&!battery.charging){if(this.wifiEnabled){wifiManager.setPowerSavingMode(true);}
if(!this.wifiEnabled&&this._wakeLockManager.isHeld){lock.set({'wifi.enabled':true});window.addEventListener('wifi-enabled',function(){wifiManager.setPowerSavingMode(true);releaseCpuLock();});return;}
if(!navigator.mozAlarms){console.warn('Turning off wifi without sleep timer because'+' Alarm API is not available');this.sleep();releaseCpuLock();return;}
this.setSystemMessageHandler();if(this.wifiSleepMode==true){var date=new Date(Date.now()+this.screenOffTimeout);var self=this;var req=navigator.mozAlarms.add(date,'ignoreTimezone','wifi-off');req.onsuccess=function wifi_offAlarmSet(){self._alarmId=req.result;releaseCpuLock();};req.onerror=function wifi_offAlarmSetFailed(){console.warn('Fail to set wifi sleep timer on Alarm API. '+'Turn off wifi immediately.');self.sleep();releaseCpuLock();};}
else{return;}}
else{if(this._alarmId){navigator.mozAlarms.remove(this._alarmId);this._alarmId=null;}
if(this.wifiEnabled){wifiManager.setPowerSavingMode(false);}
if(this.wifiEnabled&&wifiManager.connection.status=='disconnected'){wifiManager.getNetworks();}
if(!this.wifiDisabledByWakelock){releaseCpuLock();return;}
this.wifiDisabledByWakelock=false;if(this.wifiEnabled){wifiManager.setPowerSavingMode(false);releaseCpuLock();return;}
lock.set({'wifi.enabled':true});lock.set({'wifi.disabled_by_wakelock':false});window.addEventListener('wifi-enabled',function(){releaseCpuLock();});}},sleep:function wifi_sleep(){var wakeLockForWifi=navigator.requestWakeLock('cpu');var releaseWakeLockForWifi=function(){if(wakeLockForWifi){wakeLockForWifi.unlock();wakeLockForWifi=null;}
if(timeoutId){window.clearTimeout(timeoutId);timeoutId=0;}};var timeoutId=window.setTimeout(releaseWakeLockForWifi,30000);this.wifiDisabledByWakelock=true;var request=null;if(this._wakeLockManager.isHeld){var wifiManager=window.navigator.mozWifiManager;if(wifiManager){request=wifiManager.setPowerSavingMode(true);request.onsuccess=releaseWakeLockForWifi;request.onerror=releaseWakeLockForWifi;return;}}
var lock=SettingsListener.getSettingsLock();var wakeLockForSettings=navigator.requestWakeLock('cpu');lock.set({'wifi.enabled':false});window.addEventListener('wifi-disabled',releaseWakeLockForWifi);request=lock.set({'wifi.disabled_by_wakelock':true});request.onsuccess=function(){wakeLockForSettings.unlock()};request.onerror=request.onsuccess;},setSystemMessageHandler:function wifi_setSystemMessageHandler(){if(this._systemMessageHandlerRegistered)
return;this._systemMessageHandlerRegistered=true;var self=this;navigator.mozSetMessageHandler('alarm',function gotAlarm(message){if(message.data!=='wifi-off')
return;self.sleep();});}};Wifi.init();;'use strict';function AppUpdatable(app){this._mgmt=navigator.mozApps.mgmt;this.app=app;var manifest=app.manifest?app.manifest:app.updateManifest;this.name=new ManifestHelper(manifest).name;this.nameL10nId='';this.size=app.downloadSize;this.progress=null;UpdateManager.addToUpdatableApps(this);app.ondownloadavailable=this.availableCallBack.bind(this);if(app.downloadAvailable){this.availableCallBack();}
if(app.readyToApplyDownload){this.applyUpdate();}}
AppUpdatable.prototype.download=function(){UpdateManager.addToDownloadsQueue(this);this.progress=0;this.app.download();};AppUpdatable.prototype.cancelDownload=function(){this.app.cancelDownload();};AppUpdatable.prototype.uninit=function(){this.app.ondownloadavailable=null;this.clean();};AppUpdatable.prototype.clean=function(){this.app.ondownloaderror=null;this.app.ondownloadsuccess=null;this.app.ondownloadapplied=null;this.app.onprogress=null;this.progress=null;};AppUpdatable.prototype.availableCallBack=function(){this.size=this.app.downloadSize;if(this.app.installState==='installed'){UpdateManager.addToUpdatesQueue(this);this.app.ondownloaderror=this.errorCallBack.bind(this);this.app.ondownloadsuccess=this.successCallBack.bind(this);this.app.ondownloadapplied=this.appliedCallBack.bind(this);this.app.onprogress=this.progressCallBack.bind(this);}};AppUpdatable.prototype.successCallBack=function(){var app=this.app;if(Service.currentApp&&Service.currentApp.origin!==app.origin){this.applyUpdate();}else{var self=this;window.addEventListener('appwillclose',function waitClose(){window.removeEventListener('appwillclose',waitClose);self.applyUpdate();});}
UpdateManager.downloaded(this);UpdateManager.removeFromDownloadsQueue(this);UpdateManager.removeFromUpdatesQueue(this);};AppUpdatable.prototype.applyUpdate=function(){appWindowManager.kill(this.app.origin);this._mgmt.applyDownload(this.app);};AppUpdatable.prototype.appliedCallBack=function(){this.clean();};AppUpdatable.prototype.errorCallBack=function(e){var app=e.application;var errorName=app.downloadError.name;console.info('downloadError event, error code is',errorName);UpdateManager.requestErrorBanner();UpdateManager.removeFromDownloadsQueue(this);if(!app.downloadAvailable){UpdateManager.removeFromUpdatesQueue(this);}
this.progress=null;};AppUpdatable.prototype.progressCallBack=function(){if(this.progress===null){UpdateManager.addToDownloadsQueue(this);this.progress=0;}
var delta=this.app.progress-this.progress;this.progress=this.app.progress;UpdateManager.downloadProgressed(delta);};function SystemUpdatable(){this.nameL10nId='systemUpdate';this.size=0;this.downloading=false;this.paused=false;this.showingApplyPrompt=false;this.checkKnownUpdate(UpdateManager.checkForUpdates.bind(UpdateManager));window.addEventListener('mozChromeEvent',this);}
SystemUpdatable.KNOWN_UPDATE_FLAG='known-sysupdate';SystemUpdatable.prototype.download=function(){if(this.downloading){return;}
this.downloading=true;this.paused=false;UpdateManager.addToDownloadsQueue(this);this.progress=0;this._dispatchEvent('update-available-result','download');};SystemUpdatable.prototype.cancelDownload=function(){this._dispatchEvent('update-download-cancel');this.downloading=false;this.paused=false;};SystemUpdatable.prototype.uninit=function(){window.removeEventListener('mozChromeEvent',this);};SystemUpdatable.prototype.handleEvent=function(evt){if(evt.type!=='mozChromeEvent')
return;var detail=evt.detail;if(!detail.type)
return;switch(detail.type){case'update-error':this.errorCallBack();break;case'update-download-started':this.paused=false;break;case'update-download-progress':var delta=detail.progress-this.progress;this.progress=detail.progress;UpdateManager.downloadProgressed(delta);break;case'update-download-stopped':this.paused=detail.paused;if(!this.paused){UpdateManager.startedUncompressing();}
break;case'update-downloaded':this.downloading=false;UpdateManager.downloaded(this);this.showApplyPrompt();break;case'update-prompt-apply':this.showApplyPrompt();break;}};SystemUpdatable.prototype.errorCallBack=function(){UpdateManager.requestErrorBanner();UpdateManager.removeFromDownloadsQueue(this);this.downloading=false;};SystemUpdatable.prototype.showApplyPrompt=function(){var batteryLevel=window.navigator.battery.level*100;this.getBatteryPercentageThreshold().then(function(threshold){this.showingApplyPrompt=true;if(batteryLevel<threshold){this.showApplyPromptBatteryNok(threshold);}else{this.showApplyPromptBatteryOk();}}.bind(this));};SystemUpdatable.prototype.BATTERY_FALLBACK_THRESHOLD=25;SystemUpdatable.prototype.getBatteryPercentageThreshold=function(){var fallbackThreshold=this.BATTERY_FALLBACK_THRESHOLD;var isCharging=window.navigator.battery.charging;var batteryThresholdKey='app.update.battery-threshold.'+(isCharging?'plugged':'unplugged');var settings=window.navigator.mozSettings;var getRequest=settings.createLock().get(batteryThresholdKey);return new Promise(function(resolve,reject){getRequest.onerror=function(){resolve(fallbackThreshold);};getRequest.onsuccess=function(){var threshold=getRequest.result[batteryThresholdKey];if(typeof threshold!=='number'){threshold=fallbackThreshold;}
if(threshold<0||threshold>100){threshold=fallbackThreshold;}
resolve(threshold);};});};SystemUpdatable.prototype.showApplyPromptBatteryNok=function(minBattery){var ok={title:'ok',callback:this.declineInstallBattery.bind(this)};var screen=document.getElementById('screen');UtilityTray.hide();CustomDialog.show('systemUpdateReady',{id:'systemUpdateLowBatteryThreshold',args:{threshold:minBattery}},ok,null,screen).setAttribute('data-z-index-level','system-dialog');};SystemUpdatable.prototype.showApplyPromptBatteryOk=function(){this.forgetKnownUpdate();var cancel={title:'later',callback:this.declineInstallWait.bind(this)};var confirm={title:'installNow',callback:this.acceptInstall.bind(this),recommend:true};var screen=document.getElementById('screen');UtilityTray.hide();CustomDialog.show('systemUpdateReady','wantToInstallNow',cancel,confirm,screen).setAttribute('data-z-index-level','system-dialog');};SystemUpdatable.prototype.declineInstall=function(reason){this.showingApplyPrompt=false;CustomDialog.hide();this._dispatchEvent('update-prompt-apply-result',reason);UpdateManager.removeFromDownloadsQueue(this);};SystemUpdatable.prototype.declineInstallBattery=function(){this.declineInstall('low-battery');};SystemUpdatable.prototype.declineInstallWait=function(){this.declineInstall('wait');};SystemUpdatable.prototype.acceptInstall=function(){CustomDialog.hide();var splash=document.createElement('form');splash.id='system-update-splash';['label','divider','icon'].forEach(function(name){var child=document.createElement('div');child.id=name;splash.appendChild(child);});splash.firstChild.setAttribute('data-l10n-id','systemUpdate');var screen=document.getElementById('screen');screen.appendChild(splash);this._dispatchEvent('update-prompt-apply-result','restart');};SystemUpdatable.prototype.rememberKnownUpdate=function(){asyncStorage.setItem(SystemUpdatable.KNOWN_UPDATE_FLAG,true);};SystemUpdatable.prototype.checkKnownUpdate=function(callback){if(typeof callback!=='function'){return;}
asyncStorage.getItem(SystemUpdatable.KNOWN_UPDATE_FLAG,function(value){callback(!!value);});};SystemUpdatable.prototype.forgetKnownUpdate=function(){asyncStorage.removeItem(SystemUpdatable.KNOWN_UPDATE_FLAG);};SystemUpdatable.prototype._dispatchEvent=function(type,result){var event=document.createEvent('CustomEvent');var data={type:type};if(result){data.result=result;}
event.initCustomEvent('mozContentEvent',true,true,data);window.dispatchEvent(event);};;'use strict';var UpdateManager={_mgmt:null,_downloading:false,_uncompressing:false,_downloadedBytes:0,_errorTimeout:null,_wifiLock:null,_systemUpdateDisplayed:false,_startedDownloadUsingDataConnection:false,_settings:null,UPDATE_NOTIF_ID:'update-notification',NOTIFICATION_BUFFERING_TIMEOUT:30*1000,TOASTER_TIMEOUT:1200,UPDATE_2G_SETT:'update.2g.enabled',UPDATE_2G:false,ROAMING_SETTING_KEY:'ril.data.roaming_enabled',DATA_TYPES_NO_ALLOWED:['edge','gprs','1xrtt','is95a','is95b'],WIFI_PRIORITIZED:true,WIFI_PRIORITIZED_KEY:'app.update.wifi-prioritized',connection2G:false,container:null,message:null,toaster:null,toasterMessage:null,laterButton:null,notnowButton:null,downloadButton:null,downloadViaDataConnectionButton:null,downloadDialog:null,downloadViaDataConnectionTitle:null,downloadViaDataConnectionDialog:null,downloadViaDataConnectionMessage:null,downloadDialogTitle:null,downloadDialogList:null,lastUpdatesAvailable:0,_notificationTimeout:null,updatableApps:[],systemUpdatable:null,updatesQueue:[],downloadsQueue:[],init:function um_init(){if(!this._mgmt){this._mgmt=navigator.mozApps.mgmt;}
this._mgmt.getAll().onsuccess=(function gotAll(evt){var apps=evt.target.result;apps.forEach(function appIterator(app){new AppUpdatable(app);});}).bind(this);this._settings=navigator.mozSettings;this.systemUpdatable=new SystemUpdatable();this.container=document.getElementById('update-manager-container');this.message=this.container.querySelector('.title-container');this.toaster=document.getElementById('update-manager-toaster');this.toasterMessage=this.toaster.querySelector('.message');this.laterButton=document.getElementById('updates-later-button');this.notnowButton=document.getElementById('updates-viaDataConnection-notnow-button');this.downloadButton=document.getElementById('updates-download-button');this.downloadViaDataConnectionButton=document.getElementById('updates-viaDataConnection-download-button');this.downloadDialog=document.getElementById('updates-download-dialog');this.downloadDialogTitle=this.downloadDialog.querySelector('h1');this.downloadDialogList=this.downloadDialog.querySelector('ul');this.downloadViaDataConnectionDialog=document.getElementById('updates-viaDataConnection-dialog');this.downloadViaDataConnectionMessage=this.downloadViaDataConnectionDialog.querySelector('p');this.downloadViaDataConnectionTitle=this.downloadViaDataConnectionDialog.querySelector('h1');this.container.onclick=this.containerClicked.bind(this);this.toaster.onclick=this.toasterClicked.bind(this);this.laterButton.onclick=this.cancelPrompt.bind(this);this.downloadButton.onclick=this.requestDownloads.bind(this);this.downloadDialogList.onchange=this.updateDownloadButton.bind(this);this.notnowButton.onclick=this.cancelDataConnectionUpdatesPrompt.bind(this);this.downloadViaDataConnectionButton.onclick=this.requestDownloads.bind(this);window.addEventListener('mozChromeEvent',this);window.addEventListener('applicationinstall',this);window.addEventListener('applicationuninstall',this);window.addEventListener('online',this);window.addEventListener('offline',this);window.addEventListener('lockscreen-appopened',this);SettingsListener.observe('gaia.system.checkForUpdates',false,this.checkForUpdates.bind(this));window.addEventListener('wifi-statuschange',this);this.updateWifiStatus();this.updateOnlineStatus();},requestDownloads:function um_requestDownloads(evt){evt.preventDefault();if(evt.target==this.downloadViaDataConnectionButton){this._startedDownloadUsingDataConnection=true;this.startDownloads();}else{this.promptOrDownload();}},startDownloads:function um_startDownloads(){this.downloadViaDataConnectionDialog.classList.remove('visible');this._closeDownloadDialog();UtilityTray.show();var checkValues={};var dialog=this.downloadDialogList;var checkboxes=dialog.querySelectorAll('input[type="checkbox"]');for(var i=0;i<checkboxes.length;i++){var checkbox=checkboxes[i];checkValues[checkbox.dataset.position]=checkbox.checked;}
this.updatesQueue.forEach(function(updatable,index){if(updatable.app&&!checkValues[index]){return;}
updatable.download();});this._downloadedBytes=0;this.render();},cancelAllDownloads:function um_cancelAllDownloads(){CustomDialog.hide();while(this.downloadsQueue.length){var updatable=this.downloadsQueue[0];updatable.cancelDownload();this.removeFromDownloadsQueue(updatable);}},requestErrorBanner:function um_requestErrorBanner(){if(this._errorTimeout)
return;var _=navigator.mozL10n.get;var self=this;this._errorTimeout=setTimeout(function waitForMore(){var systemBanner=new SystemBanner();systemBanner.show(_('downloadError'));self._errorTimeout=null;},this.NOTIFICATION_BUFFERING_TIMEOUT);},promptOrDownload:function um_promptOrDownload(){var self=this;if(self.downloadDialog.dataset.online=='false'){self.showPromptNoConnection();return;}
if(self._wifiAvailable()){self._startedDownloadUsingDataConnection=false;self.startDownloads();return;}
var wifiPrioritized=self.getWifiPrioritized();var update2GEnabled=self.getUpdate2GEnabled();var conns=window.navigator.mozMobileConnections;if(!conns){if(navigator.onLine){self.startDownloads();return;}
console.error('mozMobileConnections is not available we can '+'not update the phone.');self.showPromptNoConnection();return;}
var dataType;for(var i=0;i<conns.length&&!dataType;i++){dataType=conns[i].data.type;}
if(!dataType){console.error('There are not wifi connection nor data '+'connection. We can not download update');self.showForbiddenDownload();return;}
if(self.DATA_TYPES_NO_ALLOWED.indexOf(dataType)>=0){self.connection2G=true;}else{self.connection2G=false;}
Promise.all([wifiPrioritized,update2GEnabled]).then(function(values){var prioritized=values[0];var update2G=values[1];if(update2G){if(prioritized){self.showPromptWifiPrioritized();}else{self.showPrompt3GAdditionalCostIfNeeded();}
return;}
if(self.connection2G&&self._systemUpdateDisplayed){self.showForbiddenDownload();return;}
if(prioritized){self.showPromptWifiPrioritized();}else{self.showPrompt3GAdditionalCostIfNeeded();}});},containerClicked:function um_containerClicker(){var _=navigator.mozL10n.get;if(this._downloading){if(this._uncompressing){return;}
var cancel={title:'no',callback:this.cancelPrompt.bind(this)};var confirm={title:'yes',callback:this.cancelAllDownloads.bind(this)};var screen=document.getElementById('screen');CustomDialog.show('cancelAllDownloads','wantToCancelAll',cancel,confirm,screen).setAttribute('data-z-index-level','system-dialog');}else{this.showDownloadPrompt();}
UtilityTray.hide();},toasterClicked:function um_toasterClicked(){if(this._downloading){return;}
this.showDownloadPrompt();UtilityTray.hide();},showForbiddenDownload:function um_showForbiddenDownload(){CustomDialog.hide();var ok={title:'ok',callback:this.cancelPrompt.bind(this)};var screen=document.getElementById('screen');window.dispatchEvent(new CustomEvent('updatepromptshown'));CustomDialog.show('systemUpdate','downloadUpdatesVia2GForbidden3',ok,null,screen).setAttribute('data-z-index-level','system-dialog');},showPromptNoConnection:function um_showPromptNoConnection(){CustomDialog.hide();var ok={title:'ok',callback:this.cancelPrompt.bind(this)};var screen=document.getElementById('screen');window.dispatchEvent(new CustomEvent('updatepromptshown'));CustomDialog.show('systemUpdate','downloadOfflineWarning2',ok,null,screen).setAttribute('data-z-index-level','system-dialog');},showDownloadPrompt:function um_showDownloadPrompt(){var _localize=navigator.mozL10n.setAttributes;this._systemUpdateDisplayed=false;_localize(this.downloadDialogTitle,'numberOfUpdates',{n:this.updatesQueue.length});var updateList='';this.updatesQueue.sort(function sortUpdates(updatable,otherUpdatable){if(!updatable.app)
return-1;if(!otherUpdatable.app)
return 1;if(updatable.name<otherUpdatable.name)
return-1;if(updatable.name>otherUpdatable.name)
return 1;return 0;});this.downloadDialogList.innerHTML='';this.updatesQueue.forEach(function updatableIterator(updatable,index){var listItem=document.createElement('li');var checkContainer=document.createElement('label');if(updatable instanceof SystemUpdatable){_localize(checkContainer,'required');checkContainer.classList.add('required');this._systemUpdateDisplayed=true;}else{var checkbox=document.createElement('input');checkbox.type='checkbox';checkbox.dataset.position=index;checkbox.checked=true;var span=document.createElement('span');checkContainer.classList.add('pack-checkbox');checkContainer.appendChild(checkbox);checkContainer.appendChild(span);}
listItem.appendChild(checkContainer);var name=document.createElement('div');name.classList.add('name');if(updatable.nameL10nId){_localize(name,updatable.nameL10nId);}else{name.textContent=updatable.name;}
listItem.appendChild(name);if(updatable.size){var sizeItem=document.createElement('div');sizeItem.textContent=this._humanizeSize(updatable.size);listItem.appendChild(sizeItem);}else{listItem.classList.add('nosize');}
this.downloadDialogList.appendChild(listItem);},this);window.dispatchEvent(new CustomEvent('updatepromptshown'));this.downloadDialog.classList.add('visible');this.updateDownloadButton();},updateDownloadButton:function(){if(this._systemUpdateDisplayed){this.downloadButton.disabled=false;return;}
var disabled=true;var dialog=this.downloadDialogList;var checkboxes=dialog.querySelectorAll('input[type="checkbox"]');for(var i=0;i<checkboxes.length;i++){if(checkboxes[i].checked){disabled=false;break;}}
this.downloadButton.disabled=disabled;},cancelPrompt:function um_cancelPrompt(){CustomDialog.hide();this._closeDownloadDialog();},cancelDataConnectionUpdatesPrompt:function um_cancelDCUpdatesPrompt(){CustomDialog.hide();this.downloadViaDataConnectionDialog.classList.remove('visible');this._closeDownloadDialog();},getWifiPrioritized:function um_getWifiPrioritized(){var wifiPrioritized=this.WIFI_PRIORITIZED;var settings=window.navigator.mozSettings;var self=this;var getRequest=settings.createLock().get(this.WIFI_PRIORITIZED_KEY);return new Promise(function(resolve,reject){getRequest.onerror=function(){resolve(wifiPrioritized);};getRequest.onsuccess=function(){var prioritized=getRequest.result[self.WIFI_PRIORITIZED_KEY];if(typeof prioritized!=='boolean'){prioritized=wifiPrioritized;}
resolve(prioritized);};});},getUpdate2GEnabled:function um_getUpdate2GEnabled(){var update2G=this.UPDATE_2G;var settings=window.navigator.mozSettings;var self=this;var getRequest=settings.createLock().get(this.UPDATE_2G_SETT);return new Promise(function(resolve,reject){getRequest.onerror=function(){resolve(update2G);};getRequest.onsuccess=function(){var setting=getRequest.result[self.UPDATE_2G_SETT];if(typeof setting!=='boolean'){setting=update2G;}
resolve(setting);};});},showPrompt3GAdditionalCostIfNeeded:function um_showPrompt3GAdditionalCostIfNeeded(){this._openDownloadViaDataDialog();CustomDialog.hide();},showPromptWifiPrioritized:function um_showPromptWifiPrioritized(downloadCallback){if(!downloadCallback){downloadCallback=this.showPrompt3GAdditionalCostIfNeeded;}
var notNow={title:'notNow',callback:this.cancelPrompt.bind(this)};var download={title:'download',recommend:true,callback:downloadCallback.bind(this)};var messageL10n=this.connection2G?'downloadWifiPrioritizedUsing2G':'downloadWifiPrioritized3';this._closeDownloadDialog();var screen=document.getElementById('screen');window.dispatchEvent(new CustomEvent('updatepromptshown'));UtilityTray.hide();CustomDialog.show('systemUpdate',messageL10n,notNow,download,screen).setAttribute('data-z-index-level','system-dialog');},downloadProgressed:function um_downloadProgress(bytes){if(bytes>0){this._downloadedBytes+=bytes;this.render();}},downloaded:function um_downloaded(udatable){if(this._startedDownloadUsingDataConnection){this._startedDownloadUsingDataConnection=false;}},startedUncompressing:function um_startedUncompressing(){this._uncompressing=true;this.render();},render:function um_render(){var _localize=navigator.mozL10n.setAttributes;_localize(this.toasterMessage,'updateAvailableInfo',{n:this.updatesQueue.length-this.lastUpdatesAvailable});if(this._downloading){if(this._uncompressing&&this.downloadsQueue.length===1){_localize(this.message,'uncompressingMessage');}else{_localize(this.message,'downloadingUpdateMessage',{progress:this._humanizeSize(this._downloadedBytes)});}}else{_localize(this.message,'updateAvailableInfo',{n:this.updatesQueue.length});}
var css=this.container.classList;this._downloading?css.add('downloading'):css.remove('downloading');},addToUpdatableApps:function um_addtoUpdatableapps(updatableApp){this.updatableApps.push(updatableApp);},removeFromAll:function um_removeFromAll(updatableApp){var removeIndex=this.updatableApps.indexOf(updatableApp);if(removeIndex===-1)
return;var removedApp=this.updatableApps[removeIndex];this.removeFromUpdatesQueue(removedApp);removedApp.uninit();this.updatableApps.splice(removeIndex,1);},addToUpdatesQueue:function um_addToUpdatesQueue(updatable){if(this._downloading){return;}
if(updatable.app&&updatable.app.installState!=='installed'){return;}
if(updatable.app&&this.updatableApps.indexOf(updatable)===-1){return;}
var alreadyThere=this.updatesQueue.some(function lookup(u){return(u.app===updatable.app);});if(alreadyThere){return;}
this.updatesQueue.push(updatable);if(this._notificationTimeout===null){this._notificationTimeout=setTimeout(this.displayNotificationAndToaster.bind(this),this.NOTIFICATION_BUFFERING_TIMEOUT);}
this.render();},displayNotificationAndToaster:function um_displayNotificationAndToaster(){this._notificationTimeout=null;if(this.updatesQueue.length&&!this._downloading){this.lastUpdatesAvailable=this.updatesQueue.length;this.displayNotificationIfHidden();this.toaster.classList.add('displayed');var self=this;setTimeout(function waitToHide(){self.toaster.classList.remove('displayed');},this.TOASTER_TIMEOUT);}},removeFromUpdatesQueue:function um_removeFromUpdatesQueue(updatable){var removeIndex=this.updatesQueue.indexOf(updatable);if(removeIndex===-1)
return;this.updatesQueue.splice(removeIndex,1);this.lastUpdatesAvailable=this.updatesQueue.length;if(this.updatesQueue.length===0){this.hideNotificationIfDisplayed();}
this.render();},addToDownloadsQueue:function um_addToDownloadsQueue(updatable){if(updatable.app&&this.updatableApps.indexOf(updatable)===-1){return;}
var alreadyThere=this.downloadsQueue.some(function lookup(u){return(u.app===updatable.app);});if(alreadyThere){return;}
this.downloadsQueue.push(updatable);if(this.downloadsQueue.length===1){this._downloading=true;StatusBar.incSystemDownloads();this._wifiLock=navigator.requestWakeLock('wifi');this.displayNotificationIfHidden();this.render();}},removeFromDownloadsQueue:function um_removeFromDownloadsQueue(updatable){var removeIndex=this.downloadsQueue.indexOf(updatable);if(removeIndex===-1)
return;this.downloadsQueue.splice(removeIndex,1);if(this.downloadsQueue.length===0){this._downloading=false;StatusBar.decSystemDownloads();this._uncompressing=false;this._downloadedBytes=0;this.checkStatuses();if(this._wifiLock){try{this._wifiLock.unlock();}catch(e){console.error('error during unlock',e);}
this._wifiLock=null;}
this.render();}},hideNotificationIfDisplayed:function(){if(this.container.classList.contains('displayed')){this.container.classList.remove('displayed');NotificationScreen.removeUnreadNotification(this.UPDATE_NOTIF_ID);}},displayNotificationIfHidden:function(){if(!this.container.classList.contains('displayed')){this.container.classList.add('displayed');NotificationScreen.addUnreadNotification(this.UPDATE_NOTIF_ID);}},checkStatuses:function um_checkStatuses(){this.updatableApps.forEach(function(updatableApp){var app=updatableApp.app;if(app.downloadAvailable){this.addToUpdatesQueue(updatableApp);}},this);},oninstall:function um_oninstall(evt){var app=evt.application;var updatableApp=new AppUpdatable(app);},onuninstall:function um_onuninstall(evt){this.updatableApps.some(function appIterator(updatableApp,index){if(updatableApp.app.manifestURL===evt.application.manifestURL){this.removeFromAll(updatableApp);return true;}
return false;},this);},handleEvent:function um_handleEvent(evt){if(!evt.type)
return;switch(evt.type){case'applicationinstall':this.oninstall(evt.detail);break;case'applicationuninstall':this.onuninstall(evt.detail);break;case'offline':this.updateOnlineStatus();break;case'online':this.updateOnlineStatus();break;case'wifi-statuschange':this.updateWifiStatus();break;case'lockscreen-appopened':if(this.systemUpdatable.showingApplyPrompt){this.systemUpdatable.declineInstallWait();}
this.downloadViaDataConnectionDialog.classList.remove('visible');this._closeDownloadDialog();CustomDialog.hide();break;}
if(evt.type!=='mozChromeEvent')
return;var detail=evt.detail;if(detail.type&&detail.type==='update-available'){this.systemUpdatable.size=detail.size;this.systemUpdatable.rememberKnownUpdate();this.addToUpdatesQueue(this.systemUpdatable);}},updateOnlineStatus:function su_updateOnlineStatus(){var online=(navigator&&'onLine'in navigator)?navigator.onLine:true;this.downloadDialog.dataset.online=online;},_wifiAvailable:function su_wifiAvailable(){var wifiManager=window.navigator.mozWifiManager;if(!wifiManager){return;}
return wifiManager.connection.status=='connected';},updateWifiStatus:function su_updateWifiStatus(){this.downloadDialog.dataset.nowifi=!this._wifiAvailable();},checkForUpdates:function su_checkForUpdates(shouldCheck){if(!shouldCheck){return;}
this._dispatchEvent('force-update-check');if(!this._settings){return;}
var lock=this._settings.createLock();lock.set({'gaia.system.checkForUpdates':false});},_openDownloadViaDataDialog:function um_downloadViaDataDialog(){var _=navigator.mozL10n.setAttributes;var connections=window.navigator.mozMobileConnections;var dataType;var sim;if(!connections){this.showForbiddenDownload();return;}
for(var i=0;i<connections.length&&!dataType;i++){dataType=connections[i].data.type;sim=connections[i];}
if(!dataType){self.showForbiddenDownload();return;}
var dataRoamingSettingPromise=this._getDataRoamingSetting();dataRoamingSettingPromise.then(function(roaming){if(roaming&&sim.data.roaming){_(this.downloadViaDataConnectionTitle,'downloadUpdatesViaDataRoamingConnection');_(this.downloadViaDataConnectionMessage,'downloadUpdatesViaDataRoamingConnectionMessage');window.dispatchEvent(new CustomEvent('updatepromptshown'));this.downloadViaDataConnectionDialog.classList.add('visible');return;}
this._startedDownloadUsingDataConnection=true;this.startDownloads();}.bind(this));},_getDataRoamingSetting:function um_getDataRoamingSetting(){var lock=this._settings.createLock();var reqDataRoaming=lock.get(this.ROAMING_SETTING_KEY);var dataRoamingSettingPromise;var self=this;dataRoamingSettingPromise=new Promise(function(resolve,reject){reqDataRoaming.onsuccess=function(){resolve(reqDataRoaming.result[self.ROAMING_SETTING_KEY]);};reqDataRoaming.onerror=function(){resolve(false);};});return dataRoamingSettingPromise;},_dispatchEvent:function um_dispatchEvent(type,result){var event=document.createEvent('CustomEvent');var data={type:type};if(result){data.result=result;}
event.initCustomEvent('mozContentEvent',true,true,data);window.dispatchEvent(event);},_humanizeSize:function um_humanizeSize(bytes){var _=navigator.mozL10n.get;var units=['bytes','kB','MB','GB','TB','PB'];if(!bytes)
return'0.00 '+_(units[0]);var e=Math.floor(Math.log(bytes)/Math.log(1024));return(bytes/Math.pow(1024,Math.floor(e))).toFixed(2)+' '+
_(units[e]);},_closeDownloadDialog:function um_closeDownloadDialog(){window.dispatchEvent(new CustomEvent('updateprompthidden'));this.downloadDialog.classList.remove('visible');}};if(navigator.mozL10n){navigator.mozL10n.once(UpdateManager.init.bind(UpdateManager));};(function(exports){'use strict';function MediaRecording(){}
MediaRecording.prototype={isRecording:false,messages:[],start:function mr_start(){this.container=document.getElementById('media-recording-status-list');window.addEventListener('mozChromeEvent',this);},stop:function mr_stop(){this.isRecording=false;this.messages=[];this.container=null;window.removeEventListener('mozChromeEvent',this);},createItem:function mr_createItem(detail){var isAudio=detail.isAudio;var isVideo=detail.isVideo;var icon;var message;if(isAudio&&isVideo){icon='video-mic';message='media-is-on';}else if(isAudio){icon='mic';message='microphone-is-on';}else if(isVideo){icon='video';message='camera-is-on';}
return{isApp:detail.isApp,requestURL:detail.requestURL,isAudio:isAudio,isVideo:isVideo,origin:this.getOrigin(detail),icon:icon,message:message,timestamp:new Date()};},getOrigin:function mr_getOrigin(detail){var origin;if(detail.isApp){var app=applications.getByManifestURL(detail.requestURL);origin=new ManifestHelper(app.manifest).name;}else{var pathArray=detail.requestURL.split('/');origin=pathArray[0]+'//'+pathArray[2];}
return origin;},handleEvent:function mr_handleEvent(evt){if(evt.detail.type!=='recording-status'){return;}
if(evt.detail.active){this.isRecording=true;var isAlreadyActive=this.messages.some(function(message){if(message.requestURL===evt.detail.requestURL&&message.isApp===evt.detail.isApp){return true;}},this);if(!isAlreadyActive){this.addMessage(evt.detail);}}else{this.removeMessage(evt.detail);}},addMessage:function mr_addMessage(detail){var item=this.createItem(detail);this.messages.push(item);var panelElement,iconElement,titleContainerElement,originElement,messageElement,timerElement;panelElement=document.createElement('div');panelElement.className='media-recording-status fake-notification';panelElement.setAttribute('role','listitem');iconElement=document.createElement('div');iconElement.dataset.icon=item.icon;iconElement.className='alert';panelElement.appendChild(iconElement);titleContainerElement=document.createElement('div');titleContainerElement.className='title-container';panelElement.appendChild(titleContainerElement);originElement=document.createElement('div');originElement.className='title';originElement.textContent=item.origin;titleContainerElement.appendChild(originElement);timerElement=document.createElement('div');timerElement.className='timestamp';timerElement.dataset.timestamp=item.timestamp;titleContainerElement.appendChild(timerElement);panelElement.appendChild(titleContainerElement);messageElement=document.createElement('div');messageElement.className='message detail';messageElement.setAttribute('data-l10n-id',item.message);panelElement.appendChild(messageElement);item.element=panelElement;this.container.appendChild(panelElement);this.updateRecordingStatus();},removeMessage:function mr_removeMessage(detail){var self=this;this.messages.some(function(message,index){if(message.requestURL===detail.requestURL&&message.isApp===detail.isApp){self.messages.splice(index,1);if(message.element){message.element.parentNode.removeChild(message.element);}
self.updateRecordingStatus();return true;}});},updateRecordingStatus:function mr_updateRecordingStatus(){if(this.messages.length){if(!this.container.classList.contains('displayed')){this.container.classList.add('displayed');}}else{this.isRecording=false;if(this.container.classList.contains('displayed')){this.container.classList.remove('displayed');}}
var event=new CustomEvent('recordingEvent',{detail:{type:'recording-state-changed',active:this.isRecording}});window.dispatchEvent(event);},getFormattedTimeString:function mr_getFormattedTimeString(now){var _=navigator.mozL10n.get;var f=new navigator.mozL10n.DateTimeFormat();var timeFormat=window.navigator.mozHour12?_('shortTimeFormat12'):_('shortTimeFormat24');timeFormat=timeFormat.replace('%p','<span>%p</span>');var formatted=f.localeFormat(now,timeFormat);return formatted;}};exports.MediaRecording=MediaRecording;})(window);;'use strict';const kPaymentConfirmationScreen='../payment.html';var Payment={chromeEventId:null,trustedUILayers:{},init:function init(){window.addEventListener('mozChromeEvent',this);},handleEvent:function onMozChromeEvent(e){this.chromeEventId=e.detail.id;if(!this.chromeEventId)
return;var requestId=e.detail.requestId;switch(e.detail.type){case'open-payment-confirmation-dialog':var requests=e.detail.paymentRequests;if(!requests)
return;var returnSelection=(function returnSelection(selection){if(!selection)
return;this._dispatchEvent({id:this.chromeEventId,userSelection:selection});}).bind(this);if(requests.length==1){returnSelection(requests[0].type);return;}
var frame=document.createElement('iframe');frame.setAttribute('mozbrowser','true');frame.setAttribute('remote',true);frame.classList.add('screen');frame.src=kPaymentConfirmationScreen;frame.addEventListener('mozbrowserloadend',function addReqs(evt){var frame=evt.target;if(!frame||!requests)
return;var frameDocument=frame.contentWindow.document;var requestsList=frameDocument.getElementById('requests').getElementsByTagName('ul')[0];for(var i in requests){var requestElement=frameDocument.createElement('li');var button=frameDocument.createElement('button');button.setAttribute('value',requests[i].type);var requestText='Pay with '+requests[i].providerName+'\n'+
requests[i].productName+'\n'+
requests[i].productDescription+'\n'+
requests[i].productPrice[0].amount+' '+
requests[i].productPrice[0].currency;button.appendChild(frameDocument.createTextNode(requestText));button.onclick=function selectRequest(){returnSelection(this.getAttribute('value'));};requestElement.appendChild(button);requestsList.appendChild(requestElement);}});this._openTrustedUI(frame);break;case'open-payment-flow-dialog':this.trustedUILayers[requestId]=this.chromeEventId;var frame=document.createElement('iframe');frame.setAttribute('mozbrowser','true');frame.classList.add('screen');this._openTrustedUI(frame).then((function(){this._dispatchEvent({id:this.chromeEventId,frame:frame});}).bind(this));break;case'close-payment-flow-dialog':TrustedUIManager.close(this.trustedUILayers[requestId],(function dialogClosed(){this._dispatchEvent({id:this.chromeEventId});delete this.trustedUILayers[requestId];}).bind(this));break;}},_openTrustedUI:function _openTrustedUI(frame){var title=Service.currentApp.name;title=title?title:navigator.mozL10n.get('payment-flow');return TrustedUIManager.open(title,frame,this.chromeEventId);},_dispatchEvent:function _dispatchEvent(obj){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,obj);window.dispatchEvent(event);}};if(navigator.mozL10n){navigator.mozL10n.once(Payment.init.bind(Payment));};'use strict';const kIdentityScreen='/sign_in#NATIVE';const kIdentityFrame='/communication_iframe';var Identity=(function(){var iframe;return{trustedUILayers:{},init:function(){window.addEventListener('mozChromeEvent',this);},handleEvent:function onMozChromeEvent(e){var chromeEventId=e.detail.id;var personaUri=e.detail.uri;var requestId=e.detail.requestId;switch(e.detail.type){case'id-dialog-open':if(!chromeEventId)
return;this.trustedUILayers[requestId]=chromeEventId;if(!e.detail.showUI&&iframe){this._dispatchEvent({id:chromeEventId,frame:iframe});return;}
var frame=document.createElement('iframe');frame.setAttribute('mozbrowser','true');frame.setAttribute('remote',true);frame.classList.add('screen');frame.src=personaUri+
(e.detail.showUI?kIdentityScreen:kIdentityFrame);frame.dataset.url=frame.src;frame.addEventListener('mozbrowserloadstart',function loadStart(evt){this._dispatchEvent({id:chromeEventId,frame:evt.target});}.bind(this));if(e.detail.showUI){TrustedUIManager.open(navigator.mozL10n.get('persona-signin'),frame,this.trustedUILayers[requestId]);}else{var container=document.getElementById('screen');container.appendChild(frame);frame.classList.add('communication-frame');iframe=frame;}
break;case'id-dialog-done':if(e.detail.showUI){TrustedUIManager.close(this.trustedUILayers[requestId],(function dialogClosed(){delete this.trustedUILayers[requestId];}).bind(this));}
this._dispatchEvent({id:chromeEventId});break;case'id-dialog-close-iframe':if(iframe){iframe.parentNode.removeChild(iframe);iframe=null;}
break;}},_dispatchEvent:function su_dispatchEvent(obj){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,obj);window.dispatchEvent(event);}};})();if(navigator.mozL10n){navigator.mozL10n.once(Identity.init.bind(Identity));};'use strict';function OperatorVariantHelper(iccId,iccCardIndex,listener,persistKey,checkNow){var errMsg=null;var iccManager=window.navigator.mozIccManager;if(!iccManager){errMsg='Expected mozIccManager to be present.';console.error(errMsg);throw new Error(errMsg);}
var settings=window.navigator.mozSettings;if(!settings){errMsg='Expected mozSettings to be present.';console.error(errMsg);throw new Error(errMsg);}
if((iccId==='0')||(iccCardIndex<0)){throw new Error('iccId and iccCardIndex arguments must have a value!');}
this._iccId=iccId;this._iccCardIndex=iccCardIndex;if(listener===undefined||typeof listener!=='function'){throw new Error('listener argument must be a function!');}
this._listener=listener;if(persistKey===undefined||typeof persistKey!=='string'){throw new Error('persistKey argument must be a string!');}
this._persistKey=persistKey;if(!!checkNow){this.customize();}}
OperatorVariantHelper.prototype={_listener:null,_addedListener:null,_iccCard:null,_iccSettings:{mcc:'',mnc:'',iccId:''},_persistKey:null,_disableAll:false,get ICCID_SETTINGS_KEY(){return'operatorvariant.iccId';},get MCC_SETTINGS_KEY(){return'operatorvariant.mcc';},get MNC_SETTINGS_KEY(){return'operatorvariant.mnc';},get OPERATOR_VARIANT_DISABLE_ALL_KEY(){return'operatorvariant.disableAll';},get settings(){return window.navigator.mozSettings;},getICCSettings:function(){var transaction=this.settings.createLock();var mccRequest=transaction.get(this.MCC_SETTINGS_KEY);mccRequest.onsuccess=(function(){var mccs=mccRequest.result[this.MCC_SETTINGS_KEY];if(!mccs){this._iccSettings.mcc='000';}else if(!Array.isArray(mccs)){this._iccSettings.mcc=mccs;}else if(!mccs[this._iccCardIndex]){this._iccSettings.mcc='000';}else{this._iccSettings.mcc=mccs[this._iccCardIndex];}
var mncRequest=transaction.get(this.MNC_SETTINGS_KEY);mncRequest.onsuccess=(function(){var mncs=mncRequest.result[this.MNC_SETTINGS_KEY];if(!mncs){this._iccSettings.mnc='00';}else if(!Array.isArray(mncs)){this._iccSettings.mnc=mncs;}else if(!mncs[this._iccCardIndex]){this._iccSettings.mnc='00';}else{this._iccSettings.mnc=mncs[this._iccCardIndex];}
var iccIdsRequest=transaction.get(this.ICCID_SETTINGS_KEY);iccIdsRequest.onsuccess=(function(){var iccIds=iccIdsRequest.result[this.ICCID_SETTINGS_KEY];this._iccSettings.iccId=iccIds&&iccIds[this._iccCardIndex];this.checkICCInfo();}).bind(this);}).bind(this);}).bind(this);},checkICCInfo:function(){var iccManager=window.navigator.mozIccManager;this._iccCard=iccManager.getIccById(this._iccId);if(!this._iccCard){return;}
if(!this._iccCard.iccInfo||this._iccCard.cardState!=='ready'){return;}
var mcc=this._iccCard.iccInfo.mcc||'000';var mnc=this._iccCard.iccInfo.mnc||'00';var iccId=this._iccId;if(mcc==='000'){return;}
if(this._iccSettings.iccId===''){return;}
if(iccId!==this._iccSettings.iccId){if(this._addedListener){try{this._listener(mcc,mnc);}
catch(e){console.error('Listener threw an error!',e);}
this.listen(false);}}else{var transaction=this.settings.createLock();var persistKeyGetRequest=transaction.get(this._persistKey);persistKeyGetRequest.onsuccess=(function persistKeyGetRequestCb(){if(!persistKeyGetRequest.result[this._persistKey]){if(this._addedListener){try{this._listener(mcc,mnc,true);}
catch(e){console.error('Listener threw an error!',e);}}}
this.listen(false);}).bind(this);}
var transaction=this.settings.createLock();var mccRequest=transaction.get(this.MCC_SETTINGS_KEY);mccRequest.onsuccess=(function(){var mccs=mccRequest.result[this.MCC_SETTINGS_KEY];if(!mccs||!Array.isArray(mccs)){mccs=['000','000'];}
mccs[this._iccCardIndex]=mcc;var mccSettings={};mccSettings[this.MCC_SETTINGS_KEY]=mccs;transaction.set(mccSettings);var mncRequest=transaction.get(this.MNC_SETTINGS_KEY);mncRequest.onsuccess=(function(){var mncs=mncRequest.result[this.MNC_SETTINGS_KEY];if(!mncs||!Array.isArray(mncs)){mncs=['00','00'];}
mncs[this._iccCardIndex]=mnc;var mncSettings={};mncSettings[this.MNC_SETTINGS_KEY]=mncs;transaction.set(mncSettings);var iccIdsRequest=transaction.get(this.ICCID_SETTINGS_KEY);iccIdsRequest.onsuccess=(function(){var iccIds=iccIdsRequest.result[this.ICCID_SETTINGS_KEY];if(!iccIds||!Array.isArray(iccIds)){iccIds=[null,null];}
iccIds[this._iccCardIndex]=iccId;var iccIdSettings={};iccIdSettings[this.ICCID_SETTINGS_KEY]=iccIds;transaction.set(iccIdSettings);this._iccSettings.mcc=mcc;this._iccSettings.mnc=mnc;this._iccSettings.iccId=iccId;}).bind(this);}).bind(this);}).bind(this);},applied:function(){var transaction=this.settings.createLock();var item={};item[this._persistKey]=true;var opVariantReq=transaction.set(item);if(opVariantReq===undefined){return;}
opVariantReq.onerror=(function(event){console.error('Failed to set',this._persistKey,'to true.','Customizations may run again!');}).bind(this);},revert:function(){var transaction=this.settings.createLock();var item={};item[this._persistKey]=false;var opVariantReq=transaction.set(item);if(opVariantReq===undefined){return;}
opVariantReq.onerror=(function(event){console.error('Failed to set',this._persistKey,'to false.','Customizations will not be able to be applied again.');}).bind(this);},customize:function(){this.getICCSettings();},listen:function(listenForChange){if(listenForChange===undefined){listenForChange=true;}
if(listenForChange){this._addedListener=this.customize.bind(this);var iccManager=window.navigator.mozIccManager;this._iccCard=iccManager.getIccById(this._iccId);if(this._iccCard){this._iccCard.addEventListener('iccinfochange',this._addedListener);this._iccCard.addEventListener('cardstatechange',this._addedListener);}else{iccManager.oniccdetected=(function iccDetectedHandler(evt){if(this._iccId!==evt.iccId){return;}
this._iccCard=iccManager.getIccById(this._iccId);this._iccCard.addEventListener('iccinfochange',this._addedListener);this._iccCard.addEventListener('cardstatechange',this._addedListener);}).bind(this);}
return;}
if(this._addedListener){var iccManager=window.navigator.mozIccManager;this._iccCard=iccManager.getIccById(this._iccId);if(this._iccCard){this._iccCard.removeEventListener('iccinfochange',this._addedListener);this._iccCard.removeEventListener('cardstatechange',this._addedListener);}
this._addedListener=null;}}};;'use strict';var Voicemail={icon:null,notifications:{},tagPrefix:'voicemailNotification:',init:function vm_init(){var voicemail=window.navigator.mozVoicemail;if(!voicemail){return;}
this.icon=window.location.protocol+'//'+
window.location.hostname+'/style/icons/voicemail.png';this.voiceMailNumberHelper=SettingsHelper('ril.iccInfo.mbdn',null);return this.setupNotifications();},handleEvent:function vm_handleEvent(evt){var voicemailStatus=evt.status;if(voicemailStatus){this.updateNotification(voicemailStatus);}},updateNotification:function vm_updateNotification(status){var _=window.navigator.mozL10n.get;var title=status.returnMessage;var showCount=status.hasMessages&&status.messageCount>0;if(!title){title=showCount?_('newVoicemails',{n:status.messageCount}):_('newVoicemailsUnknown');}
var text=title;var settings=navigator.mozSettings;if(!settings){return;}
this.voiceMailNumberHelper.get(function gotVMNumbers(numbers){var voicemail=navigator.mozVoicemail;var number=numbers&&numbers[status.serviceId];if(!number&&voicemail){number=voicemail.getNumber(status.serviceId);}
if(number){number='\u200E'+number;text=_('dialNumber',{number:number});}
if(status.hasMessages){Voicemail.showNotification(title,text,number,status.serviceId);}else{Voicemail.hideNotification(status.serviceId);}});},showNotification:function vm_showNotification(title,text,voicemailNumber,serviceId){if(!('Notification'in window)){return;}
serviceId=serviceId||0;if(!SIMSlotManager.hasOnlyOneSIMCardDetected()){var _=window.navigator.mozL10n.get;title=_('voicemailNotificationMultiSim',{n:serviceId+1,title:title});}
var notifOptions={body:text,icon:this.icon,tag:this.tagPrefix+serviceId,mozbehavior:{showOnlyOnce:true}};var notification=new Notification(title,notifOptions);var callVoicemail=function vmNotificationCall_onClick(event){var telephony=window.navigator.mozTelephony;if(!telephony){return;}
var openLines=telephony.calls.length+
((telephony.conferenceGroup&&telephony.conferenceGroup.calls.length)?1:0);if(openLines>=2){return;}
telephony.dial(voicemailNumber,serviceId);};var showNoVoicemail=(function vmNotificationNoCall_onClick(event){var voicemailDialog={title:'voicemailNoNumberTitle',text:'voicemailNoNumberText',confirm:{title:'voicemailNoNumberSettings',callback:this.showVoicemailSettings},cancel:{title:'voicemailNoNumberCancel',callback:function(){}}};ModalDialog.confirm(voicemailDialog.title,voicemailDialog.text,voicemailDialog.confirm,voicemailDialog.cancel);}).bind(this);notification.addEventListener('click',voicemailNumber?callVoicemail:showNoVoicemail);notification.addEventListener('close',(function vm_closeNotification(evt){this.notifications[serviceId]=null;}).bind(this));this.notifications[serviceId]=notification;},hideNotification:function vm_hideNotification(serviceId){if(!this.notifications[serviceId]){return;}
this.notifications[serviceId].close();},setupNotifications:function vm_setupNotifications(){this.notifications={};var prefix=this.tagPrefix;var promise=Notification.get();return promise.then(function(notifications){notifications.forEach(function(notification){if(!notification){return;}
if(!notification.tag||!notification.tag.startsWith(prefix)){return;}
notification.close();});}).then((function(){var voicemail=window.navigator.mozVoicemail;voicemail.addEventListener('statuschanged',this);}).bind(this));},showVoicemailSettings:function vm_showVoicemailSettings(){var activity=new window.MozActivity({name:'configure',data:{target:'device',section:'call'}});activity.onerror=function(){console.warn('Configure activity error:',activity.error.name);};}};Voicemail.init();;'use strict';var CrashReporter=(function(){var _=navigator.mozL10n.get;var settings=navigator.mozSettings;var screen=document.getElementById('screen');var crashedAppName=null;var showReportButton=false;SettingsListener.observe('app.reportCrashes','ask',function handleCrashSetting(value){showReportButton=(value!='always'&&value!='never');});function showDialog(crashID,isChrome){var elem=document.getElementById('crash-dialog-title');if(isChrome){navigator.mozL10n.setAttributes(elem,'crash-dialog-os2');}else{navigator.mozL10n.setAttributes(elem,'crash-dialog-app',{name:crashedAppName||_('crash-dialog-app-noname')});}
var noButton=document.getElementById('dont-send-report');noButton.addEventListener('click',function onNoButtonClick(){settings.createLock().set({'app.reportCrashes':'never'});removeDialog();});var yesButton=document.getElementById('send-report');yesButton.addEventListener('click',function onYesButtonClick(){submitCrash(crashID);if(checkbox.checked){settings.createLock().set({'app.reportCrashes':'always'});}
removeDialog();});var checkbox=document.getElementById('always-send');checkbox.addEventListener('click',function onCheckboxClick(){noButton.disabled=this.checked;});var crashInfoLink=document.getElementById('crash-info-link');crashInfoLink.addEventListener('click',function onLearnMoreClick(){var dialog=document.getElementById('crash-dialog');document.getElementById('crash-reports-header').addEventListener('action',function onAction(){this.removeEventListener('click',onAction);dialog.classList.remove('learn-more');});dialog.classList.add('learn-more');});screen.classList.add('crash-dialog');}
function removeDialog(){screen.classList.remove('crash-dialog');var dialog=document.getElementById('crash-dialog');dialog.parentNode.removeChild(dialog);}
function showBanner(crashID,isChrome){var appName=crashedAppName||_('crash-dialog-app-noname');var message=isChrome?_('crash-banner-os2'):_('crash-banner-app',{name:appName});var button=null;if(showReportButton){button={label:_('crash-banner-report'),callback:function reportCrash(){submitCrash(crashID);},dismiss:function dismissCrash(){deleteCrash(crashID);}};}
var systemBanner=new SystemBanner();systemBanner.show(message,button);}
function deleteCrash(crashID){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,{type:'delete-crash',crashID:crashID});window.dispatchEvent(event);}
function submitCrash(crashID){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,{type:'submit-crash',crashID:crashID});window.dispatchEvent(event);}
function handleCrash(crashID,isChrome){var dialogReq=settings.createLock().get('crashReporter.dialogShown');dialogReq.onsuccess=function dialogShownSuccess(){var dialogShown=dialogReq.result['crashReporter.dialogShown'];if(!dialogShown){settings.createLock().set({'crashReporter.dialogShown':true});showDialog(crashID,isChrome);}else{showBanner(crashID,isChrome);}};}
function setAppName(name){crashedAppName=name;}
window.addEventListener('mozChromeEvent',function handleChromeEvent(e){if(e.detail.type=='handle-crash'){handleCrash(e.detail.crashID,e.detail.chrome);}});function handleAppCrash(e){var app=e.detail;if(app.isActive()){setAppName(app.name);}}
window.addEventListener('appcrashed',handleAppCrash);window.addEventListener('activitycrashed',handleAppCrash);window.addEventListener('homescreencrashed',handleAppCrash);window.addEventListener('searchcrashed',handleAppCrash);return{handleCrash:handleCrash,handleAppCrash:handleAppCrash,setAppName:setAppName};})();;'use strict';(function(window){var isOutOfProcessDisabled=false;window.BrowserConfigHelper=function(config){var app=config.manifestURL&&applications.getByManifestURL(config.manifestURL);this.url=config.url;if(app){var manifest=app.manifest;var name=new ManifestHelper(manifest).name;var origin=app.origin;var entryPoints=manifest.entry_points;if(entryPoints&&manifest.type=='certified'){manifest=JSON.parse(JSON.stringify(manifest));var givenPath=this.url.substr(origin.length);for(var ep in entryPoints){var currentEp=entryPoints[ep];var path=givenPath;if(path.indexOf('?')!=-1){path=path.substr(0,path.indexOf('?'));}
if(path.indexOf('/'+ep)===0&&(currentEp.launch_path===path)){origin=origin+currentEp.launch_path;name=new ManifestHelper(currentEp).name;for(var key in currentEp){if(key!=='locale'&&key!=='name'){manifest[key]=currentEp[key];}}}}}
var host=document.location.host;var domain=host.replace(/(^[\w\d]+\.)?([\w\d]+\.[a-z]+)/,'$2');var protocol=document.location.protocol+'//';var browserManifestUrl=protocol+'browser.'+domain+'/manifest.webapp';var outOfProcessBlackList=[browserManifestUrl];if(!isOutOfProcessDisabled&&outOfProcessBlackList.indexOf(config.manifestURL)===-1){this.oop=true;}
this.name=name;this.manifestURL=config.manifestURL;this.origin=origin;this.manifest=manifest;}else{this.iframe=config.iframe;this.isPrivate=config.isPrivate;this.name=config.name||'';this.origin=config.url;this.manifestURL='';this.manifest=null;}};})(this);;'use strict';(function(window){var nextId=0;window.BrowserFrame=function BrowserFrame(){this.element=null;this._id=nextId++;createFrame.apply(this,arguments);return this;};BrowserFrame.prototype.CLASS_NAME='browser';function createFrame(config,frame){var browser=frame||document.createElement('iframe');browser.setAttribute('mozbrowser','true');browser.name=config.window_name||'main';if(config.oop){browser.setAttribute('remote','true');}
if(config.isPrivate){browser.setAttribute('mozprivatebrowsing','true');}
if(config.manifestURL){browser.setAttribute('mozapp',config.manifestURL);if(config.isSystemMessage){browser.setAttribute('expecting-system-message','expecting-system-message');}}
if(config.parentApp){browser.setAttribute('parentapp',config.parentApp);}
if(config.isInputMethod){browser.setAttribute('mozpasspointerevents','true');browser.setAttribute('ignoreuserfocus','true');}else{browser.setAttribute('mozallowfullscreen','true');}
setMozAppType(browser,config);if(config.url){browser.src=config.url;browser.dataset.url=config.url;}
browser.id=this.CLASS_NAME+this._id;browser.classList.add(this.CLASS_NAME);this.config=config;this.element=browser;};function setMozAppType(iframe,config){if(config.url.startsWith(window.location.protocol+'//callscreen.gaiamobile.org')||config.url.startsWith(window.location.protocol+'//clock.gaiamobile.org')){iframe.setAttribute('mozapptype','critical');}else if(config.isHomescreen){iframe.setAttribute('mozapptype','homescreen');}else if(config.isSearch){iframe.setAttribute('mozapptype','search');}else if(config.isInputMethod){iframe.setAttribute('mozapptype','inputmethod');}}}(this));;'use strict';var CaptivePortal={eventId:null,settings:null,notification:null,notificationPrefix:'captivePortal:',captiveNotification_onClick:null,handleLogin:function cp_handleLogin(id,url){var wifiManager=window.navigator.mozWifiManager;var _=window.navigator.mozL10n.get;var settings=window.navigator.mozSettings;var icon=window.location.protocol+'//'+window.location.hostname+'/style/icons/captivePortal.png';this.eventId=id;var currentNetwork=wifiManager.connection.network;var networkName=(currentNetwork&&currentNetwork.ssid)?currentNetwork.ssid:'';var message=_('captive-wifi-available',{networkName:networkName});if(FtuLauncher.isFtuRunning()){settings.createLock().set({'wifi.connect_via_settings':false});this.entrySheet=new EntrySheet(document.getElementById('screen'),'\u200E'+url,new BrowserFrame({url:url}));this.entrySheet.open();return;}
this.captiveNotification_onClick=(function(){this.notification.removeEventListener('click',this.captiveNotification_onClick);this.captiveNotification_onClick=null;var activity=new MozActivity({name:'view',data:{type:'url',url:url}});this.notification.close();activity.onerror=function(){console.error('CaptivePortal Activity error: '+this.error);};}).bind(this);var options={body:message,icon:icon,tag:this.notificationPrefix+networkName,mozbehavior:{showOnlyOnce:true}};this.notification=new Notification('',options);this.notification.addEventListener('click',this.captiveNotification_onClick);this.notification.addEventListener('close',(function(){this.notification=null;}).bind(this));},dismissNotification:function dismissNotification(id){if(id===this.eventId){if(this.notification){if(this.captiveNotification_onClick){this.notification.removeEventListener('click',this.captiveNotification_onClick);this.captiveNotification_onClick=null;}
this.notification.close();}
if(this.entrySheet){this.entrySheet.close();this.entrySheet=null;}}},handleLoginAbort:function handleLoginAbort(id){this.dismissNotification(id);},handleLoginSuccess:function handleLoginSuccess(id){this.dismissNotification(id);},handleEvent:function cp_handleEvent(evt){switch(evt.detail.type){case'captive-portal-login':this.handleLogin(evt.detail.id,evt.detail.url);break;case'captive-portal-login-abort':this.handleLoginAbort(evt.detail.id);break;case'captive-portal-login-success':this.handleLoginSuccess(evt.detail.id);break;}},init:function cp_init(){var promise=Notification.get();var prefix=this.notificationPrefix;promise.then(function(notifications){notifications.forEach(function(notification){if(!notification){return;}
if(!notification.tag||!notification.tag.startsWith(prefix)){return;}
notification.close();});}).then((function(){window.addEventListener('mozChromeEvent',this);}).bind(this));return promise;}};if(navigator.mozL10n){navigator.mozL10n.once(CaptivePortal.init.bind(CaptivePortal));};'use strict';(function(exports){var ShrinkingUI=function(foregroundElement,backgroundElement){this.elements.foregroundElement=foregroundElement;this.elements.backgroundElement=backgroundElement;};ShrinkingUI.prototype={DEBUG:false,THRESHOLD:50,SUSPEND_INTERVAL:100,state:{shrinking:false,ending:false,tilting:false,overThreshold:false,toward:'TOP',touch:{initY:-1,prevY:-1},slideTransitionCb:null,tiltTransitionCb:null},elements:{},configs:{degreeLandscape:'2.7deg',degreePortrait:'0.65deg',overDegreeLandscape:'2.9deg',overDegreePortrait:'0.9deg'},tip:null,cover:null};ShrinkingUI.prototype.debug=function su_debug(msg,optObject){if(this.DEBUG){var output='[DEBUG] ShrinkingUI: '+msg;if(optObject){output+=JSON.stringify(optObject);}
dump(output);}};ShrinkingUI.prototype.start=function su_start(){window.addEventListener('shrinking-receiving',this);this.startTilt();};ShrinkingUI.prototype.stop=function su_stop(){if(this.isActive()){this.stopTilt();}
window.removeEventListener('shrinking-receiving',this);};ShrinkingUI.prototype.handleEvent=function su_handleEvent(evt){switch(evt.type){case'shrinking-receiving':this._receivingEffects();break;case'touchstart':this._handleSendingStart(evt);break;case'touchmove':this._handleSendingSlide(evt);break;case'touchend':this._handleSendingOut(evt);break;}};ShrinkingUI.prototype.respondToHierarchyEvent=function su_respondToHierarchyEvent(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;};ShrinkingUI.prototype._handle_holdhome=function su__handle_holdhome(evt){return this.isActive();};ShrinkingUI.prototype._handle_home=function su__handle_home(evt){return this.isActive();};ShrinkingUI.prototype.startTilt=function su_startTilt(){if(this.isActive()){return;}
if(!this.elements.backgroundElement||!this.elements.foregroundElement){return;}
this.state.shrinking=true;this.state.tilting=true;var afterTilt=()=>{this.elements.foregroundElement.classList.add('hidden');this.state.tilting=false;};this._setTip();this._setState(true);screen.mozLockOrientation(screen.mozOrientation);this._shrinkingTilt(afterTilt);};ShrinkingUI.prototype._setTip=function su_setTip(){var backgroundElement=this.elements.backgroundElement;if(!this.tip){this.tip=this._slidingTip();backgroundElement.appendChild(this.tip);}
this.tip.classList.remove('hide');};ShrinkingUI.prototype.stopTilt=function su_stopTilt(){if(!this.state.shrinking||this.state.ending){return;}
if(this.state.tilting){this.state.tilting=false;}
this.state.shrinking=false;this.state.ending=true;var afterTiltBack=(()=>{this.elements.foregroundElement.classList.remove('hidden');this._cleanEffects().then(()=>{this.state.ending=false;});});this.tip.remove();this.tip=null;this._shrinkingTiltBack(true,afterTiltBack);};ShrinkingUI.prototype.isActive=function su_isActive(){if(this.state.shrinking||this.state.tilting||this.state.ending){return true;}
return false;};ShrinkingUI.prototype._setState=function su_shrinking(state){var foregroundElement=this.elements.foregroundElement;foregroundElement.setAttribute('data-shrinking-state',state.toString());this.debug('Setting shrink state to: '+state);};ShrinkingUI.prototype._updateSlideTransition=function su_updateSlideTransition(cb){if(this.tip&&this.state.slideTransitionCb){this.elements.foregroundElement.style.transitionDuration='0s';this.tip.removeEventListener('transitionend',this.state.slideTransitionCb);}
this.state.slideTransitionCb=cb;};ShrinkingUI.prototype._updateTiltTransition=function su_updateTiltTransition(cb){var foregroundElement=this.elements.foregroundElement;if(foregroundElement&&this.state.tiltTransitionCb){foregroundElement.removeEventListener('transitionend',this.state.tiltTransitionCb);}
this.state.tiltTransitionCb=cb;};ShrinkingUI.prototype._receivingEffects=function su_receivingEffects(){var foregroundElement=this.elements.foregroundElement;foregroundElement.style.opacity='0';var afterTop=(function(){foregroundElement.style.opacity='';foregroundElement.style.transition='transform 0.5s ease';this._sendingSlideTo('BOTTOM',(function doTiltBack(){this._shrinkingTiltBack(false,this._cleanEffects);}).bind(this));}).bind(this);var afterTilt=(function(){foregroundElement.style.transition='transform 0.05s ease';this._sendingSlideTo('TOP',afterTop);}).bind(this);this._shrinkingTilt(afterTilt);};ShrinkingUI.prototype._sendingSlideTo=function su_sendingSlideTo(y,callback){var foregroundElement=this.elements.foregroundElement;var cbDone=(function on_cbDone(evt){foregroundElement.removeEventListener('transitionend',cbDone);this.elements.foregroundElement.style.transitionDuration='0s';if('undefined'!==typeof callback){callback();}}).bind(this);if('TOP'===y){foregroundElement.style.transitionDuration='0.3s';y=foregroundElement.parentElement.clientHeight;}else if('BOTTOM'===y){if(this.state.touch.prevY<=0){cbDone();}else{foregroundElement.style.transitionDuration='0.3s';}
y=0;}else if(y<0){y=0;}
foregroundElement.addEventListener('transitionend',cbDone);this._updateTiltTransition(cbDone);foregroundElement.style.transform='rotateX('+this._getTiltingDegree()+') '+'translateY(-'+y+'px)';};ShrinkingUI.prototype._slidingCover=function slidingCover(){var cover=document.createElement('div');cover.id='shrinking-cover';cover.style.width='100%';cover.style.height='100%';cover.style.position='relative';cover.style.zIndex='2';cover.addEventListener('touchstart',this);cover.addEventListener('touchmove',this);cover.addEventListener('touchend',this);return cover;};ShrinkingUI.prototype._slidingTip=function slidingTip(){var tip=document.createElement('div');var tipArrow=document.createElement('div');var tipText=document.createElement('div');tip.id='shrinking-tip';tipArrow.id='shrinking-tip-arrow';tipText.id='shrinking-text';tipArrow.textContent='\u00A0';tipText.setAttribute('data-l10n-id','shrinking-tip');tip.appendChild(tipText);tip.appendChild(tipArrow);return tip;};ShrinkingUI.prototype._disableSlidingCover=function su_disableSlidingCover(){this.cover.removeEventListener('touchstart',this);this.cover.removeEventListener('touchmove',this);this.cover.removeEventListener('touchend',this);};ShrinkingUI.prototype._shrinkingTilt=function su_shrinkingTilt(cb){var foregroundElement=this.elements.foregroundElement;var backgroundElement=this.elements.backgroundElement;if(null===this.cover){this.cover=this._slidingCover();var anchor=foregroundElement.firstElementChild;foregroundElement.insertBefore(this.cover,anchor);}
backgroundElement.classList.add('shrinking-wrapper');foregroundElement.style.transition='transform 0.5s ease';var bounceBack=(function on_bounceBack(evt){if(evt.target!==foregroundElement){return;}
foregroundElement.removeEventListener('transitionend',bounceBack);foregroundElement.addEventListener('transitionend',bounceBackEnd);this._updateTiltTransition(bounceBackEnd);foregroundElement.style.transition='transform ease';foregroundElement.style.transform='rotateX('+this._getTiltingDegree()+') ';}).bind(this);var bounceBackEnd=(function on_bounceBackEnd(evt){if(evt.target!==foregroundElement){return;}
foregroundElement.removeEventListener('transitionend',bounceBackEnd);foregroundElement.style.transition='transform 0.5s ease 0s';if(cb){cb();}}).bind(this);foregroundElement.addEventListener('transitionend',bounceBack);this._updateTiltTransition(bounceBack);foregroundElement.style.transformOrigin='50% 100% 0';foregroundElement.style.transform='rotateX('+this._getOverTiltingDegree()+')';};ShrinkingUI.prototype._shrinkingTiltBack=function su_shrinkingTiltBack(instant,callback){var foregroundElement=this.elements.foregroundElement;if(!instant){var tsEnd=(function _tsEnd(evt){foregroundElement.removeEventListener('transitionend',tsEnd);if(callback){callback();}}).bind(this);foregroundElement.style.transition='transform 0.3s ease';foregroundElement.addEventListener('transitionend',tsEnd);this._updateTiltTransition(tsEnd);foregroundElement.style.transform='rotateX(0.0deg)';}else{foregroundElement.style.transition='';foregroundElement.style.transform='rotateX(0.0deg)';if(callback){callback();}}};ShrinkingUI.prototype._handleSendingStart=function su_handleSendingStart(evt){this.state.touch.initY=evt.touches[0].pageY;this.debug('_handleSendingStart(): ',this.isActive());evt.stopImmediatePropagation();var tsEnd=(function _tsEnd(){this.tip.removeEventListener('transitionend',tsEnd);}).bind(this);this.tip.classList.add('hide');this.tip.addEventListener('transitionend',tsEnd);this._updateSlideTransition(tsEnd);return false;};ShrinkingUI.prototype._handleSendingSlide=function su_handleSendingSlide(evt){var pgy=evt.touches[0].pageY;var slideY=this.state.touch.initY-pgy;if('undefined'===typeof this.state.touch.initY){this.state.touch.initY=slideY;}
if('undefined'===typeof this.state.touch.prevY){this.state.touch.prevY=slideY;}
this.state.toward=(this.state.touch.prevY<slideY)?'TOP':'BOTTOM';this._sendingSlideTo(slideY);this.state.touch.prevY=slideY;this.state.overThreshold=(slideY>this.THRESHOLD)?true:false;};ShrinkingUI.prototype._handleSendingOut=function su_handleSendingOut(evt){this.debug('_handleSendingOut(): ',this.isActive());if(this.state.overThreshold&&'TOP'===this.state.toward){this._sendingSlideTo('TOP',(function(){this._disableSlidingCover();window.dispatchEvent(new CustomEvent('shrinking-sent'));}).bind(this));}else{this._sendingSlideTo('BOTTOM',(function resumeSending(){this._setTip();}).bind(this));}};ShrinkingUI.prototype._cleanEffects=function su_cleanEffects(){var foregroundElement=this.elements.foregroundElement;var backgroundElement=this.elements.backgroundElement;return new Promise((resolve,rejected)=>{this.debug('_cleanEffects(): ',this.isActive());this._disableSlidingCover();foregroundElement.style.transition='';foregroundElement.style.transform='';foregroundElement.style.transformOrigin='50% 50% 0';this._setState(false);this._updateTiltTransition(null);this._updateSlideTransition(null);backgroundElement.classList.remove('shrinking-wrapper');this.cover.remove();this.cover=null;resolve();});};ShrinkingUI.prototype._getTiltingDegree=function su_getTiltingDegree(){return(window.OrientationManager?window.OrientationManager.fetchCurrentOrientation().indexOf('landscape')!==-1:window.innerHeight<window.innerWidth)?this.configs.degreeLandscape:this.configs.degreePortrait;};ShrinkingUI.prototype._getOverTiltingDegree=function su_getOverTiltingDegree(){return(window.OrientationManager?window.OrientationManager.fetchCurrentOrientation().indexOf('landscape')!==-1:window.innerHeight<window.innerWidth)?this.configs.overDegreeLandscape:this.configs.overDegreePortrait;};exports.ShrinkingUI=ShrinkingUI;})(window);;'use strict';(function(window){var DEBUG=false;var _id=0;window.BaseUI=function BaseUI(){};BaseUI.prototype.EVENT_PREFIX='base-';BaseUI.prototype.render=function bu_render(){this.publish('willrender');this.containerElement.insertAdjacentHTML('afterbegin',this.view());this._fetchElements();this._registerEvents();if(this.element){this.element.clientTop;}
this.publish('rendered');};BaseUI.prototype._fetchElements=function bu__fetchElements(){};BaseUI.prototype._registerEvents=function bu__registerEvents(){};BaseUI.prototype.view=function bu_view(){return'<div class="'+this.CLASS_NAME+'"></div>';};BaseUI.prototype.show=function bu_show(ele){ele=ele||this.element;ele.classList.add('visible');};BaseUI.prototype.isShown=function bu_isShown(ele){ele=ele||this.element;return ele&&ele.classList.contains('visible');};BaseUI.prototype.hide=function bu_hide(ele){ele=ele||this.element;ele.classList.remove('visible');};BaseUI.prototype.broadcast=function bu_broadcast(event,detail){if(this.element){var internalEvent=new CustomEvent('_'+event,{bubbles:false,detail:detail||this});this.debug(' publishing internal event: '+event);this.element.dispatchEvent(internalEvent);}};BaseUI.prototype.publish=function bu_publish(event,detail){this.broadcast(event,detail);var evt=new CustomEvent(this.EVENT_PREFIX+event,{bubbles:true,cancelable:false,detail:detail||this});this.debug(' publishing external event: '+event);window.dispatchEvent(evt);};BaseUI.prototype.CLASS_NAME='BaseUI';BaseUI.prototype.customID=function bu_customID(){return'';};BaseUI.prototype._unregisterEvents=function bu__unregisterEvents(){};BaseUI.prototype.destroy=function bu_destroy(){this.publish('willdestroy');this._unregisterEvents();if(this.element){this.element.parentNode.removeChild(this.element);this.element=null;}
this.publish('destroyed');};BaseUI.prototype.debug=function bu_debug(msg){if(DEBUG&&('DEBUG'in this.constructor&&this.constructor.DEBUG)){console.log('['+this.CLASS_NAME+']['+this.customID()+']'+'['+Service.currentTime()+']'+
Array.slice(arguments).concat());}};}(this));;(function(window){'use strict';var _=navigator.mozL10n.get;var _id=0;var BrowserContextMenu=window.BrowserContextMenu=function(app){this.app=app;this.containerElement=app.element;this.instanceID=_id++;this._injected=false;this.app.element.addEventListener('mozbrowsercontextmenu',this);return this;};BrowserContextMenu.prototype=Object.create(window.BaseUI.prototype);BrowserContextMenu.prototype.CLASS_NAME='BrowserContextMenu';BrowserContextMenu.prototype.ELEMENT_PREFIX='contextmenu-';BrowserContextMenu.prototype.customID=function am_customID(){if(this.app){return'['+this.app.origin+']';}else{return'';}};BrowserContextMenu.prototype.handleEvent=function bcm_handleEvent(evt){switch(evt.type){case'mozbrowsercontextmenu':this.show(evt);break;}};BrowserContextMenu.prototype._fetchElements=function bcm__fetchElements(){this.element=document.getElementById(this.CLASS_NAME+this.instanceID);this.elements={};var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};this.elementClasses=['header','list'];this.elementClasses.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=this.element.querySelector('.'+this.ELEMENT_PREFIX+name);},this);var cancel=document.createElement('button');cancel.id='ctx-cancel-button';cancel.dataset.action='cancel';cancel.setAttribute('data-l10n-id','cancel');this.elements.cancel=cancel;};BrowserContextMenu.prototype._registerEvents=function(){this.elements.cancel.addEventListener('click',this.hide.bind(this));};BrowserContextMenu.prototype.view=function(){var id=this.CLASS_NAME+this.instanceID;var content=`<form class="contextmenu" role="dialog" tabindex="-1"
              data-type="action" id="${id}">
              <header class="contextmenu-header"></header>
              <menu class="contextmenu-list"></menu>
            </form>`;return content;};BrowserContextMenu.prototype.kill=function(){this.containerElement.removeChild(this.element);};BrowserContextMenu.prototype.show=function(evt){var detail=evt.detail;var hasContextMenu=detail.contextmenu&&detail.contextmenu.items.length>0;var hasSystemTargets=detail.systemTargets&&detail.systemTargets.length>0;if(!hasSystemTargets&&!hasContextMenu){return;}
if(!hasContextMenu&&hasSystemTargets&&this.app.isCertified()){return;}
var items=this._listItems(detail);if(!items.length){return;}
evt.preventDefault();evt.stopPropagation();this.showMenu(items);};BrowserContextMenu.prototype.showMenu=function(menu){if(!this._injected){this.render();}
this._injected=true;this.buildMenu(menu);this.app&&this.app.blur();this.element.classList.add('visible');},BrowserContextMenu.prototype.buildMenu=function(items){var self=this;this.elements.list.innerHTML='';items.forEach(function traveseItems(item){var action=document.createElement('button');action.dataset.id=item.id;action.dataset.value=item.value;action.textContent=item.label;if(item.icon){action.classList.add(item.iconClass||'icon');action.style.backgroundImage='url('+item.icon+')';}
action.addEventListener('click',function(evt){self.hide(evt);item.callback();});this.elements.list.appendChild(action);},this);this.elements.list.appendChild(this.elements.cancel);};BrowserContextMenu.prototype._listItems=function(detail){var items=[];if(detail.contextmenu&&detail.contextmenu.items.length){detail.contextmenu.items.forEach(function(choice,index){items.push({label:choice.label,icon:choice.icon,callback:function(){detail.contextMenuItemSelected(choice.id);}});});}
if(detail.systemTargets){detail.systemTargets.forEach(function(item){this.generateSystemMenuItem(item).forEach(function(menuItem){items.push(menuItem);});},this);}
return items;};BrowserContextMenu.prototype.isVisible=function(){return this.element&&this.element.classList.contains('visible');};BrowserContextMenu.prototype.hide=function(evt){if(!this.element){return;}
if(evt){evt.preventDefault();}
this.element.blur();this.element.classList.remove('visible');if(this.app){this.app.focus();}};BrowserContextMenu.prototype.openUrl=function(url,isPrivate){new MozActivity({name:'view',data:{type:'url',url:url,isPrivate:isPrivate}});};BrowserContextMenu.prototype.shareUrl=function(url){new MozActivity({name:'share',data:{type:'url',url:url}});};BrowserContextMenu.prototype.bookmarkUrl=function(url,name){var favicons=this.app.favicons;var data={type:'url',url:url,name:name,iconable:false};LazyLoader.load('shared/js/icons_helper.js',(()=>{IconsHelper.getIcon(url,null,{icons:favicons}).then(icon=>{if(icon){data.icon=icon;}
new MozActivity({name:'save-bookmark',data:data});});}));};BrowserContextMenu.prototype.newWindow=function(manifest,isPrivate){if(isPrivate){window.dispatchEvent(new CustomEvent('new-private-window'));return;}
var newTabApp=applications.getByManifestURL(manifest);newTabApp.launch();};BrowserContextMenu.prototype.showWindows=function(manifest){window.dispatchEvent(new CustomEvent('taskmanagershow',{detail:{filter:'browser-only'}}));};BrowserContextMenu.prototype.generateSystemMenuItem=function(item){var nodeName=item.nodeName.toUpperCase();var uri=item.data.uri;var text=item.data.text;switch(nodeName){case'A':return[{id:'open-in-new-window',label:_('open-in-new-window'),callback:this.openUrl.bind(this,uri)},{id:'open-in-new-private-window',label:_('open-in-new-private-window'),callback:this.openUrl.bind(this,uri,true)},{id:'bookmark-link',label:_('add-link-to-home-screen'),callback:this.bookmarkUrl.bind(this,uri,text)},{id:'save-link',label:_('save-link'),callback:this.app.browser.element.download.bind(this.app.browser.element,uri)},{id:'share-link',label:_('share-link'),callback:this.shareUrl.bind(this,uri)}];case'IMG':case'VIDEO':case'AUDIO':var typeMap={'IMG':'image','VIDEO':'video','AUDIO':'audio'};var type=typeMap[nodeName];if(nodeName==='VIDEO'&&!item.data.hasVideo){type='audio';}
return[{id:'save-'+type,label:_('save-'+type),callback:this.app.browser.element.download.bind(this.app.browser.element,uri)},{id:'share-'+type,label:_('share-'+type),callback:this.shareUrl.bind(this,uri)}];default:return[];}};BrowserContextMenu.prototype.showDefaultMenu=function(manifest,name){return new Promise((resolve)=>{var config=this.app.config;var menuData=[];var finish=()=>{this.showMenu(menuData);resolve();};menuData.push({id:'new-window',label:_('new-window'),callback:this.newWindow.bind(this,manifest)});menuData.push({id:'new-private-window',label:_('new-private-window'),callback:this.newWindow.bind(this,manifest,true)});menuData.push({id:'show-windows',label:_('show-windows'),callback:this.showWindows.bind(this)});if(config.url.startsWith('app')){finish();return;}
BookmarksDatabase.get(config.url).then((result)=>{if(!result){menuData.push({id:'add-to-homescreen',label:_('add-to-home-screen'),callback:this.bookmarkUrl.bind(this,config.url,name)});}
menuData.push({id:'share',label:_('share'),callback:this.shareUrl.bind(this,config.url)});finish();});});};}(this));;'use strict';(function(exports){var ENABLE_IN_APP_SHEET=false;SettingsListener.observe('in-app-sheet.enabled',false,function(value){ENABLE_IN_APP_SHEET=value;});var ChildWindowFactory=function ChildWindowFactory(app){this.app=app;this.app.element.addEventListener('mozbrowseropenwindow',this);this.app.element.addEventListener('_launchactivity',this.createActivityWindow.bind(this));};ChildWindowFactory.prototype.handleEvent=function cwf_handleEvent(evt){if(evt.detail&&evt.detail.instanceID&&evt.detail.instanceID!==this.app.instanceID){if(this['_handle_child_'+evt.type]){this['_handle_child_'+evt.type](evt);}
return;}
if(this.isHomescreen){return;}
if(evt.detail.name=='_blank'&&!window.Service.runningFTU&&evt.detail.features!=='attention'&&evt.detail.features!=='global-clickthrough-overlay'){this.createNewWindow(evt);evt.stopPropagation();return;}
if(evt.detail.isApp){this.app.publish('openwindow',{manifestURL:evt.detail.name,url:evt.detail.url,timestamp:Date.now()});evt.stopPropagation();return;}
var caught=false;switch(evt.detail.features){case'dialog':if(/^(app|http|https):\/\//i.test(evt.detail.url)){caught=this.createPopupWindow(evt);}else{caught=this.launchActivity(evt);}
break;case'attention':if(!this.createAttentionWindow(evt)){this.createPopupWindow(evt);}
break;case'global-clickthrough-overlay':this.createGlobalOverlayWindow(evt);break;case'mozhaidasheet':caught=this.createChildWindow(evt);break;default:if(ENABLE_IN_APP_SHEET){caught=this.createChildWindow(evt);}else{caught=this.createPopupWindow(evt);}
break;}
if(caught){evt.stopPropagation();}};ChildWindowFactory.prototype.createPopupWindow=function(evt){if(this.app.frontWindow&&(this.app.frontWindow.isTransitioning()||this.app.frontWindow.isActive())){return false;}
var configObject={url:evt.detail.url,name:this.app.name,iframe:evt.detail.frameElement,origin:this.app.origin,rearWindow:this.app};var childWindow=new PopupWindow(configObject);childWindow.element.addEventListener('_closing',this);childWindow.open();return true;};ChildWindowFactory.prototype._sameOrigin=function(url1,url2){var a=url1.split('/');var b=url2.split('/');return(a[0]===b[0]&&a[2]===b[2]);};ChildWindowFactory.prototype.createNewWindow=function(evt){if(!this.app.isActive()||this.app.isTransitioning()){return false;}
var configObject={url:evt.detail.url,name:evt.detail.name,iframe:evt.detail.frameElement,isPrivate:this.app.isPrivateBrowser()};window.dispatchEvent(new CustomEvent('openwindow',{detail:configObject}));return true;};ChildWindowFactory.prototype.createChildWindow=function(evt){if(!this.app.isActive()||this.app.isTransitioning()){return false;}
var configObject={url:evt.detail.url,name:this.app.name,iframe:evt.detail.frameElement,origin:this.app.origin,isPrivate:this.app.isPrivateBrowser()};if(this._sameOrigin(this.app.origin,evt.detail.url)){configObject.manifestURL=this.app.manifestURL;configObject.previousWindow=this.app;}else{configObject.name='';configObject.origin=evt.detail.url;}
var childWindow=new AppWindow(configObject);childWindow.requestOpen();return true;};ChildWindowFactory.prototype.createAttentionWindow=function(evt){if(!this.app||!this.app.hasPermission('attention')){console.error('Cannot create attention window. '+'Invalid of underprivileged app');return false;}
if(document.mozFullScreen){document.mozCancelFullScreen();}
var attentionFrame=evt.detail.frameElement;var attention=new AttentionWindow({iframe:attentionFrame,url:evt.detail.url,name:evt.detail.name,manifestURL:this.app.manifestURL,origin:this.app.origin,parentWindow:this.app});this.app.attentionWindow=attention;attention.requestOpen();return true;};ChildWindowFactory.prototype.createGlobalOverlayWindow=function(evt){if(!this.app||!this.app.hasPermission('global-clickthrough-overlay')){console.error('Cannot create global overlay window. '+'Invalid of underprivileged app');return false;}
var overlayFrame=evt.detail.frameElement;var overlay=new GlobalOverlayWindow({iframe:overlayFrame,url:evt.detail.url,name:evt.detail.name,manifestURL:this.app.manifestURL,origin:this.app.origin,parentWindow:this.app});this.app.overlayWindow=overlay;overlay.requestOpen();return true;};ChildWindowFactory.prototype._handle_child__closing=function(evt){if(!this.app.isVisible()||this.app._killed){return;}
this.app.setOrientation();this.app.requestForeground();evt.detail.rearWindow._setVisibleForScreenReader(true);evt.detail.rearWindow.focus();};ChildWindowFactory.prototype.createActivityWindow=function(evt){var configuration=evt.detail;var top=this.app.getTopMostWindow();if(top.manifestURL==configuration.manifestURL&&top.url==configuration.url){return;}
top.setNFCFocus(false);var activity=new ActivityWindow(configuration,top);activity.element.addEventListener('_closing',this);activity.open();top._setVisibleForScreenReader(false);};ChildWindowFactory.prototype.launchActivity=function(evt){var activity=new MozActivity({name:'view',data:{type:'url',url:evt.detail.url}});activity.onerror=function(){this.app.debug('view activity error:'+activity.error.name+evt.detail.url);};return true;};exports.ChildWindowFactory=ChildWindowFactory;}(window));;'use strict';(function(exports){var _=navigator.mozL10n.get;var _id=0;exports.AppModalDialog=function AppModalDialog(app){this.app=app;this.containerElement=app.element;this.events=[];this.instanceID=_id++;this._injected=false;this._visible=false;app.element.addEventListener('mozbrowsershowmodalprompt',this);return this;};AppModalDialog.prototype=Object.create(BaseUI.prototype);AppModalDialog.prototype.CLASS_NAME='AppModalDialog';AppModalDialog.prototype.ELEMENT_PREFIX='modal-dialog-';AppModalDialog.prototype.customID=function amd_customID(){if(this.app){return'['+this.app.origin+']';}else{return'';}};AppModalDialog.prototype.handleEvent=function amd_handleEvent(evt){this.app.debug('handling '+evt.type);evt.preventDefault();evt.stopPropagation();this.events.push(evt);this.menuHeight=0;if(!this._injected){this.render();}
this.show();this._injected=true;};AppModalDialog.prototype.isVisible=function amd_isVisible(){return this._visible;};AppModalDialog.prototype._fetchElements=function amd__fetchElements(){this.element=document.getElementById(this.CLASS_NAME+this.instanceID);this.elements={};var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};this.elementClasses=['alert','alert-ok','alert-message','prompt','prompt-ok','prompt-cancel','prompt-input','prompt-message','confirm','confirm-ok','confirm-cancel','confirm-message','select-one','select-one-cancel','select-one-menu','select-one-title','alert-title','confirm-title','prompt-title','custom-prompt','custom-prompt-message','custom-prompt-buttons','custom-prompt-checkbox'];this.elementClasses.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=this.element.querySelector('.'+this.ELEMENT_PREFIX+name);},this);this.elements.menu=this.element.querySelector('menu');};AppModalDialog.prototype._registerEvents=function amd__registerEvents(){var elements=this.elements;for(var id in elements){var tagName=elements[id].tagName.toLowerCase();if(tagName=='button'||tagName=='ul'){if(elements[id].classList.contains('confirm')){elements[id].addEventListener('click',this.confirmHandler.bind(this));}else if(elements[id].classList.contains('cancel')){elements[id].addEventListener('click',this.cancelHandler.bind(this));}}}};AppModalDialog.prototype.view=function amd_view(){var id=this.CLASS_NAME+this.instanceID;return`<div class="modal-dialog" id="${id}">
            <form class="modal-dialog-alert generic-dialog"
            role="dialog" tabindex="-1">
            <div class="modal-dialog-message-container inner">
              <h3 class="modal-dialog-alert-title"></h3>
              <p>
                <span class="modal-dialog-alert-message"></span>
              </p>
            </div>
            <menu>
              <button class="modal-dialog-alert-ok confirm affirmative"
              data-l10n-id="ok"></button>
            </menu>
          </form>
          <form class="modal-dialog-confirm generic-dialog"
          role="dialog" tabindex="-1">
            <div class="modal-dialog-message-container inner">
              <h3 class="modal-dialog-confirm-title"></h3>
              <p>
                <span class="modal-dialog-confirm-message"></span>
              </p>
            </div>
            <menu data-items="2">
              <button class="modal-dialog-confirm-cancel cancel"
              data-l10n-id="cancel"></button>
              <button class="modal-dialog-confirm-ok confirm affirmative"
              data-l10n-id="ok"></button>
            </menu>
          </form>
          <form class="modal-dialog-prompt generic-dialog"
            role="dialog" tabindex="-1">
            <div class="modal-dialog-message-container inner">
              <h3 class="modal-dialog-prompt-title"></h3>
              <p>
                <span class="modal-dialog-prompt-message"></span>
                <input class="modal-dialog-prompt-input" />
              </p>
            </div>
            <menu data-items="2">
              <button class="modal-dialog-prompt-cancel cancel"
               data-l10n-id="cancel"></button>
              <button class="modal-dialog-prompt-ok confirm affirmative"
              data-l10n-id="ok"></button>
            </menu>
          </form>
          <form class="modal-dialog-select-one generic-dialog"
            role="dialog" tabindex="-1">
            <div class="modal-dialog-message-container inner">
              <h3 class="modal-dialog-select-one-title"></h3>
              <ul class="modal-dialog-select-one-menu"></ul>
            </div>
            <menu>
              <button class="modal-dialog-select-one-cancel cancel"
              data-l10n-id="cancel"></button>
            </menu>
          </form>
          <form class="modal-dialog-custom-prompt generic-dialog"
            role="dialog" tabindex="-1">
            <div class="modal-dialog-message-container inner">
              <h3 class="modal-dialog-custom-prompt-title"></h3>
              <p class="modal-dialog-custom-prompt-message"></p>
              <label class="pack-checkbox">
                <input class="modal-dialog-custom-prompt-checkbox"
                type="checkbox"/>
                <span></span>
              </label>
            </div>
            <menu class="modal-dialog-custom-prompt-buttons"></menu>
          </form>
        </div>`;};AppModalDialog.prototype.processNextEvent=function amd_processNextEvent(){this.events.splice(0,1);if(this.events.length){this.show();}else{this.hide();}};AppModalDialog.prototype.kill=function amd_kill(){this._visible=false;this.containerElement.removeChild(this.element);};AppModalDialog.prototype.show=function amd_show(){if(!this.events.length){return;}
this._visible=true;var evt=this.events[0];var message=evt.detail.message||'';var title=this._getTitle(evt.detail.title);var elements=this.elements;var type=evt.detail.promptType||evt.detail.type;switch(type){case'alert':elements.alertTitle.textContent=title;elements.alertMessage.textContent=message;elements.alert.classList.add('visible');elements.alertOk.textContent=evt.yesText?evt.yesText:_('ok');elements.alert.focus();this.updateMaxHeight();break;case'prompt':elements.prompt.classList.add('visible');elements.promptInput.value=evt.detail.initialValue;elements.promptTitle.textContent=title;elements.promptMessage.textContent=message;elements.promptOk.textContent=evt.yesText?evt.yesText:_('ok');elements.promptCancel.textContent=evt.noText?evt.noText:_('cancel');elements.prompt.focus();break;case'confirm':elements.confirm.classList.add('visible');elements.confirmTitle.textContent=title;elements.confirmMessage.textContent=message;elements.confirmOk.textContent=evt.yesText?evt.yesText:_('ok');elements.confirmCancel.textContent=evt.noText?evt.noText:_('cancel');elements.confirm.focus();break;case'selectone':this.buildSelectOneDialog(message);elements.selectOne.classList.add('visible');elements.selectOne.focus();break;case'custom-prompt':var customPrompt=evt.detail;elements.customPrompt.classList.add('visible');elements.customPromptMessage.textContent=customPrompt.message;elements.customPromptButtons.innerHTML='';elements.customPromptButtons.setAttribute('data-items',customPrompt.buttons.length);var domElement=null;for(var i=customPrompt.buttons.length-1;i>=0;i--){var button=customPrompt.buttons[i];domElement=document.createElement('button');domElement.dataset.buttonIndex=i;if(button.messageType==='builtin'){domElement.setAttribute('data-l10n-id',button.message);}else if(button.messageType==='custom'){domElement.textContent=button.message;}else{console.error('Unexpected button type : '+button.messageType);continue;}
domElement.addEventListener('click',this.confirmHandler.bind(this));elements.customPromptButtons.appendChild(domElement);}
domElement.classList.add('affirmative');var checkbox=elements.customPromptCheckbox;if(customPrompt.showCheckbox){if(customPrompt.checkboxCheckedByDefault){checkbox.setAttribute('checked','true');}else{checkbox.removeAttribute('checked');}
checkbox.nextElementSibling.textContent=customPrompt.checkboxMessage;}else{checkbox.parentNode.classList.add('hidden');}
elements.customPrompt.focus();break;}
this.app.browser.element.setAttribute('aria-hidden',true);this.element.classList.add('visible');};AppModalDialog.prototype.hide=function amd_hide(){this._visible=false;this.element.blur();this.app.browser.element.removeAttribute('aria-hidden');this.element.classList.remove('visible');if(this.app){this.app.focus();}
if(!this.events.length){return;}
var evt=this.events[0];var type=evt.detail.promptType||evt.detail.type;if(type==='prompt'){this.elements.promptInput.blur();}
this.elements[type].classList.remove('visible');};AppModalDialog.prototype.confirmHandler=function amd_confirmHandler(clickEvt){if(!this.events.length){return;}
clickEvt.preventDefault();var elements=this.elements;var evt=this.events[0];var type=evt.detail.promptType||evt.detail.type;switch(type){case'alert':elements.alert.classList.remove('visible');break;case'prompt':evt.detail.returnValue=elements.promptInput.value;elements.prompt.classList.remove('visible');break;case'confirm':evt.detail.returnValue=true;elements.confirm.classList.remove('visible');break;case'custom-prompt':var returnValue={selectedButton:clickEvt.target.dataset.buttonIndex};if(evt.detail.showCheckbox){returnValue.checked=elements.customPromptCheckbox.checked;}
evt.detail.returnValue=returnValue;elements.customPrompt.classList.remove('visible');break;}
if(evt.detail.unblock){evt.detail.unblock();}
this.processNextEvent();};AppModalDialog.prototype.cancelHandler=function amd_cancelHandler(clickEvt){if(!this.events.length){return;}
clickEvt.preventDefault();var evt=this.events[0];var elements=this.elements;var type=evt.detail.promptType||evt.detail.type;switch(type){case'alert':elements.alert.classList.remove('visible');break;case'prompt':evt.detail.returnValue=null;elements.prompt.classList.remove('visible');break;case'confirm':evt.detail.returnValue=false;elements.confirm.classList.remove('visible');break;case'selectone':evt.detail.returnValue=null;elements.selectOne.classList.remove('visible');break;}
if(evt.detail.unblock){evt.detail.unblock();}
this.processNextEvent();};AppModalDialog.prototype.selectOneHandler=function amd_selectOneHandler(target){if(!this.events.length){return;}
var elements=this.elements;var evt=this.events[0];evt.detail.returnValue=target.id;elements.selectOne.classList.remove('visible');if(evt.detail.unblock){evt.detail.unblock();}
this.processNextEvent();};AppModalDialog.prototype.updateMaxHeight=function(){this.menuHeight=this.menuHeight||this.elements.menu.offsetHeight;var messageHeight=this.element.offsetHeight-this.menuHeight;messageHeight-=this.elements.alertTitle.offsetHeight;var margin=window.getComputedStyle(this.elements.alertTitle).marginBottom;var messageContainer=this.elements.alert.querySelector('.inner p');var calc='calc('+messageHeight+'px - '+margin+')';messageContainer.style.maxHeight=calc;};AppModalDialog.prototype._getTitle=function amd__getTitle(title){if(!title||title.contains('app://')){return this.app.name||'';}
return title;};}(window));;'use strict';(function(exports){var _id=0;var _=navigator.mozL10n.get;var newTabManifestURL=null;SettingsListener.observe('rocketbar.newTabAppURL','',function(url){newTabManifestURL=url?url.match(/(^.*?:\/\/.*?\/)/)[1]+'manifest.webapp':'';});var AppChrome=function AppChrome(app){this.app=app;this.instanceID=_id++;this.containerElement=app.element;this._recentTitle=false;this._titleTimeout=null;this.scrollable=app.browserContainer;this.render();if(this.app.themeColor){this.setThemeColor(this.app.themeColor);}
var chrome=this.app.config.chrome;if(!this.app.isBrowser()&&chrome&&!chrome.scrollable){this._fixedTitle=true;this.title.dataset.l10nId='search-the-web';}else if(!this.app.isBrowser()&&this.app.name){this._gotName=true;this.setFreshTitle(this.app.name);}
this.reConfig();};AppChrome.prototype=Object.create(window.BaseUI.prototype);AppChrome.prototype.CLASS_NAME='AppChrome';AppChrome.prototype.EVENT_PREFIX='chrome';AppChrome.prototype.FRESH_TITLE=500;AppChrome.prototype.LOCATION_COALESCE=250;AppChrome.prototype._DEBUG=false;AppChrome.prototype.reConfig=function(){var chrome=this.app.config.chrome;if(!chrome){return;}
if(this.isSearchApp()){this.app.element.classList.add('search-app');this.title.setAttribute('data-l10n-id','search-or-enter-address');}else{this.app.element.classList.remove('search-app');}
if(chrome.bar){this.app.element.classList.add('bar');this.bar.classList.add('visible');}
if(chrome.scrollable){this.app.element.classList.add('collapsible');if(this.app.isPrivateBrowser()){this.element.classList.add('private');}else{this.app.element.classList.add('light');}
this.scrollable.scrollgrab=true;}
if(chrome.maximized){this.element.classList.add('maximized');if(!this.app.isBrowser()){this.app.element.classList.add('scrollable');}}};AppChrome.prototype.combinedView=function an_combinedView(){var className=this.CLASS_NAME+this.instanceID;return`<div class="chrome chrome-combined" id="${className}">
              <gaia-progress></gaia-progress>
              <div class="controls">
                <button type="button" class="back-button"
                        data-l10n-id="back-button" disabled></button>
                <button type="button" class="forward-button"
                        data-l10n-id="forward-button" disabled></button>
                <div class="urlbar js-chrome-ssl-information">
                  <span class="pb-icon"></span>
                  <div class="chrome-ssl-indicator chrome-title-container">
                    <span class="title" dir="auto"></span>
                  </div>
                  <button type="button" class="reload-button"
                          data-l10n-id="reload-button" disabled></button>
                  <button type="button" class="stop-button"
                          data-l10n-id="stop-button"></button>
                </div>
                <button type="button" class="menu-button" alt="Menu"></button>
                <button type="button" class="windows-button"
                        data-l10n-id="windows-button"></button>
              </div>
            </div>`;};AppChrome.prototype.view=function an_view(){var className=this.CLASS_NAME+this.instanceID;return`<div class="chrome chrome-plain" id="${className}">
            <gaia-progress></gaia-progress>
            <section role="region" class="bar">
              <gaia-header action="close" class='js-chrome-ssl-information'>
                <div class="chrome-ssl-indicator chrome-ssl-indicator-ltr">
                </div>
                <h1 class="chrome-title-container">
                  <bdi dir="auto" class="title"></bdi>
                </h1>
                <div class="chrome-ssl-indicator chrome-ssl-indicator-rtl">
                </div>
              </gaia-header>
            </section>
          </div>`;};AppChrome.prototype.overflowMenuView=function an_overflowMenuView(){var template=`<gaia-overflow-menu>

     <button id="new-window" data-l10n-id="new-window">
     </button>

     <button id="new-private-window" data-l10n-id="new-private-window">
     </button>

     <button id="add-to-home" data-l10n-id="add-to-home-screen" hidden>
     </button>

     <button id="share" data-l10n-id="share">
     </button>

    </gaia-overflow-menu>`;return template;};AppChrome.prototype.__defineGetter__('height',function ac_getHeight(){if(this._height){return this._height;}
this._height=this.element.getBoundingClientRect().height;return this._height;});AppChrome.prototype._fetchElements=function ac__fetchElements(){this.element=this.containerElement.querySelector('.chrome');this.progress=this.element.querySelector('gaia-progress');this.reloadButton=this.element.querySelector('.reload-button');this.forwardButton=this.element.querySelector('.forward-button');this.stopButton=this.element.querySelector('.stop-button');this.backButton=this.element.querySelector('.back-button');this.menuButton=this.element.querySelector('.menu-button');this.windowsButton=this.element.querySelector('.windows-button');this.title=this.element.querySelector('.chrome-title-container > .title');this.sslIndicator=this.element.querySelector('.js-chrome-ssl-information');this.bar=this.element.querySelector('.bar');if(this.bar){this.header=this.element.querySelector('gaia-header');}
if(this.reloadButton){this.reloadButton.disabled=!this.hasNavigation();}};AppChrome.prototype.handleEvent=function ac_handleEvent(evt){switch(evt.type){case'rocketbar-overlayclosed':this.collapse();break;case'click':this.handleClickEvent(evt);break;case'action':this.handleActionEvent(evt);break;case'scroll':this.handleScrollEvent(evt);break;case'_loading':this.show(this.progress);this.progress.start();break;case'_loaded':this.hide(this.progress);this.progress.stop();break;case'mozbrowserloadstart':this.handleLoadStart(evt);break;case'mozbrowserloadend':this.handleLoadEnd(evt);break;case'mozbrowsererror':this.handleError(evt);break;case'mozbrowserlocationchange':this.handleLocationChanged(evt);break;case'mozbrowserscrollareachanged':this.handleScrollAreaChanged(evt);break;case'_securitychange':this.handleSecurityChanged(evt);break;case'mozbrowsertitlechange':this.handleTitleChanged(evt);break;case'mozbrowsermetachange':this.handleMetaChange(evt);break;case'_namechanged':this.handleNameChanged(evt);break;}};AppChrome.prototype.handleClickEvent=function ac_handleClickEvent(evt){switch(evt.target){case this.reloadButton:this.app.reload();break;case this.stopButton:this.app.stop();break;case this.backButton:this.app.back();break;case this.forwardButton:this.app.forward();break;case this.title:this.titleClicked();break;case this.menuButton:this.showOverflowMenu();break;case this.windowsButton:this.showWindows();break;case this.newWindowButton:evt.stopImmediatePropagation();this.onNewWindow();break;case this.newPrivateWinButton:evt.stopImmediatePropagation();this.onNewPrivateWindow();break;case this.addToHomeButton:evt.stopImmediatePropagation();this.onAddToHome();break;case this.shareButton:evt.stopImmediatePropagation();this.onShare();break;}};AppChrome.prototype.titleClicked=function ac_titleClicked(){var contextMenu=this.app.contextmenu&&this.app.contextmenu.isVisible();var locked=Service&&Service.locked;if(locked||contextMenu){return;}
window.dispatchEvent(new CustomEvent('global-search-request'));};AppChrome.prototype.handleActionEvent=function ac_handleActionEvent(evt){if(evt.detail.type==='close'){this.app.kill();}};AppChrome.prototype.handleScrollEvent=function ac_handleScrollEvent(evt){if(!this.containerElement.classList.contains('scrollable')){return;}
var element=this.element;if(this.scrollable.scrollTop>=this.scrollable.scrollTopMax-1){element.classList.remove('maximized');}else{element.classList.add('maximized');}
if(this.app.isActive()){this.app.publish('titlestatechanged');}};AppChrome.prototype._registerEvents=function ac__registerEvents(){if(this.useCombinedChrome()){LazyLoader.load('shared/js/bookmarks_database.js',function(){this.updateAddToHomeButton();}.bind(this));LazyLoader.load('shared/elements/gaia_overflow_menu/script.js');this.stopButton.addEventListener('click',this);this.reloadButton.addEventListener('click',this);this.backButton.addEventListener('click',this);this.forwardButton.addEventListener('click',this);this.title.addEventListener('click',this);this.scrollable.addEventListener('scroll',this);this.menuButton.addEventListener('click',this);this.windowsButton.addEventListener('click',this);}else{this.header.addEventListener('action',this);}
this.app.element.addEventListener('mozbrowserloadstart',this);this.app.element.addEventListener('mozbrowserloadend',this);this.app.element.addEventListener('mozbrowsererror',this);this.app.element.addEventListener('mozbrowserlocationchange',this);this.app.element.addEventListener('mozbrowsertitlechange',this);this.app.element.addEventListener('mozbrowsermetachange',this);this.app.element.addEventListener('mozbrowserscrollareachanged',this);this.app.element.addEventListener('_securitychange',this);this.app.element.addEventListener('_loading',this);this.app.element.addEventListener('_loaded',this);this.app.element.addEventListener('_namechanged',this);var element=this.element;var animEnd=function(evt){if(evt&&evt.target!==element){return;}
var publishEvent=this.isMaximized()?'expanded':'collapsed';this.app.publish('chrome'+publishEvent);}.bind(this);element.addEventListener('transitionend',animEnd);};AppChrome.prototype._unregisterEvents=function ac__unregisterEvents(){if(this.useCombinedChrome()){this.stopButton.removeEventListener('click',this);this.menuButton.removeEventListener('click',this);this.windowsButton.removeEventListener('click',this);this.reloadButton.removeEventListener('click',this);this.backButton.removeEventListener('click',this);this.forwardButton.removeEventListener('click',this);this.title.removeEventListener('click',this);this.scrollable.removeEventListener('scroll',this);if(this.newWindowButton){this.newWindowButton.removeEventListener('click',this);}
if(this.addToHomeButton){this.addToHomeButton.removeEventListener('click',this);}
if(this.shareButton){this.shareButton.removeEventListener('click',this);}}else{this.header.removeEventListener('action',this);}
if(!this.app){return;}
this.app.element.removeEventListener('mozbrowserloadstart',this);this.app.element.removeEventListener('mozbrowserloadend',this);this.app.element.removeEventListener('mozbrowsererror',this);this.app.element.removeEventListener('mozbrowserlocationchange',this);this.app.element.removeEventListener('mozbrowsertitlechange',this);this.app.element.removeEventListener('mozbrowsermetachange',this);this.app.element.removeEventListener('_loading',this);this.app.element.removeEventListener('_loaded',this);this.app.element.removeEventListener('_namechanged',this);this.app=null;};AppChrome.prototype.handleNameChanged=function ac_handleNameChanged(evt){this.title.textContent=this.app.name;this._gotName=true;};AppChrome.prototype.setFreshTitle=function ac_setFreshTitle(title){if(this.isSearchApp()){return;}
this.title.textContent=title;clearTimeout(this._titleTimeout);this._recentTitle=true;this._titleTimeout=setTimeout((function(){this._recentTitle=false;}).bind(this),this.FRESH_TITLE);};AppChrome.prototype.handleScrollAreaChanged=function(evt){if(this.containerElement.classList.contains('scrollable')){return;}
if(evt.detail.height>=this.containerElement.clientHeight){this.containerElement.classList.add('scrollable');}};AppChrome.prototype.handleSecurityChanged=function(evt){var sslState=this.app.getSSLState();this.sslIndicator.dataset.ssl=sslState;this.sslIndicator.classList.toggle('chrome-has-ssl-indicator',sslState==='broken'||sslState==='secure');};AppChrome.prototype.handleTitleChanged=function(evt){if(this._gotName||this._fixedTitle){return;}
this.setFreshTitle(evt.detail||this._currentURL);this._titleChanged=true;};AppChrome.prototype.handleMetaChange=function ac__handleMetaChange(evt){var detail=evt.detail;if(detail.name!=='theme-color'||!detail.type){return;}
var color='';if(detail.type!=='removed'){color=detail.content;}
this.setThemeColor(color);};AppChrome.prototype.setThemeColor=function ac_setThemColor(color){if(this.app.isPrivateBrowser()){return;}
var bottomApp=this.app.getBottomMostWindow();if(this.app.CLASS_NAME==='PopupWindow'&&bottomApp&&bottomApp.themeColor){color=bottomApp.themeColor;}
this.app.themeColor=color;this.element.style.backgroundColor=color;if(!this.app.isHomescreen){this.scrollable.style.backgroundColor=color;}
if(color==='transparent'||color===''){this.app.element.classList.remove('light');this.app.publish('titlestatechanged');return;}
var self=this;var finishedFade=false;var endBackgroundFade=function(evt){if(evt&&evt.propertyName!='background-color'){return;}
finishedFade=true;self.element.removeEventListener('transitionend',endBackgroundFade);};eventSafety(this.element,'transitionend',endBackgroundFade,1000);window.requestAnimationFrame(function updateAppColor(){if(finishedFade||!self.element){return;}
var computedColor=window.getComputedStyle(self.element).backgroundColor;var colorCodes=/rgb\((\d+), (\d+), (\d+)\)/.exec(computedColor);if(!colorCodes||colorCodes.length===0){return;}
var r=parseInt(colorCodes[1]);var g=parseInt(colorCodes[2]);var b=parseInt(colorCodes[3]);var brightness=Math.sqrt((r*r)*0.241+(g*g)*0.691+(b*b)*0.068);var wasLight=self.app.element.classList.contains('light');var isLight=brightness>200;if(wasLight!=isLight){self.app.element.classList.toggle('light',isLight);self.app.publish('titlestatechanged');}
window.requestAnimationFrame(updateAppColor);});};AppChrome.prototype.render=function(){this.publish('willrender');var view=this.useCombinedChrome()?this.combinedView():this.view();this.app.element.insertAdjacentHTML('afterbegin',view);this._fetchElements();this._registerEvents();this.publish('rendered');};AppChrome.prototype.useLightTheming=function ac_useLightTheming(){if(this.app.CLASS_NAME=='PopupWindow'&&this.app.rearWindow&&this.app.rearWindow.appChrome){return this.app.rearWindow.appChrome.useLightTheming();}
return this.app.element.classList.contains('light');};AppChrome.prototype.useCombinedChrome=function ac_useCombinedChrome(evt){return this.app.config.chrome&&!this.app.config.chrome.bar;};AppChrome.prototype._updateLocation=function ac_updateTitle(title){if(this._titleChanged||this._gotName||this._recentTitle||this._fixedTitle){return;}
this.title.textContent=title;};AppChrome.prototype.updateAddToHomeButton=function ac_updateAddToHomeButton(){if(!this.addToHomeButton||!BookmarksDatabase){return;}
BookmarksDatabase.get(this._currentURL).then(function resolve(result){this.addToHomeButton.hidden=!!result;}.bind(this),function reject(){this.addToHomeButton.hidden=true;}.bind(this));};AppChrome.prototype.handleLocationChanged=function ac_handleLocationChange(evt){if(!this.app){return;}
var anchorChange=false;if(this._currentURL&&evt.detail){anchorChange=this._currentURL.replace(/#.*/g,'')===evt.detail.replace(/#.*/g,'');}
setTimeout(this._updateLocation.bind(this,evt.detail),this.LOCATION_COALESCE);this._currentURL=evt.detail;if(this.backButton&&this.forwardButton){this.app.canGoForward(function forwardSuccess(result){if(!this.hasNavigation()){return;}
this.forwardButton.disabled=!result;}.bind(this));this.app.canGoBack(function backSuccess(result){if(!this.hasNavigation()){return;}
this.backButton.disabled=!result;}.bind(this));}
this.updateAddToHomeButton();if(!this.app.isBrowser()){return;}
this._gotName=false;if(!anchorChange){this.containerElement.classList.remove('scrollable');if(!this.isMaximized()){this.element.classList.add('maximized');}
this.scrollable.scrollTop=0;}
if(this.app.isPrivateBrowser()&&this.app.config.url.startsWith('app:')){this._gotName=true;this.title.dataset.l10nId='search-or-enter-address';}};AppChrome.prototype.handleLoadStart=function ac_handleLoadStart(evt){this.containerElement.classList.add('loading');this._titleChanged=false;};AppChrome.prototype.handleLoadEnd=function ac_handleLoadEnd(evt){this.containerElement.classList.remove('loading');};AppChrome.prototype.handleError=function ac_handleError(evt){if(evt.detail&&evt.detail.type==='fatal'){return;}
if(this.useCombinedChrome()&&this.app.config.chrome.scrollable){this.element.classList.add('maximized');this.containerElement.classList.remove('scrollable');}};AppChrome.prototype.maximize=function ac_maximize(callback){var element=this.element;element.classList.add('maximized');window.addEventListener('rocketbar-overlayclosed',this);if(!callback){return;}
eventSafety(element,'transitionend',callback,250);};AppChrome.prototype.collapse=function ac_collapse(){window.removeEventListener('rocketbar-overlayclosed',this);this.element.classList.remove('maximized');};AppChrome.prototype.isMaximized=function ac_isMaximized(){return this.element.classList.contains('maximized');};AppChrome.prototype.isSearch=function ac_isSearch(){var dataset=this.app.config;return dataset.searchURL&&this._currentURL===dataset.searchURL;};AppChrome.prototype.isSearchApp=function(){return this.app.config.manifest&&this.app.config.manifest.role==='search';};AppChrome.prototype.hasNavigation=function ac_hasNavigation(evt){return this.app.isBrowser()||(this.app.config.chrome&&this.app.config.chrome.navigation);};AppChrome.prototype.addBookmark=function ac_addBookmark(){var dataset=this.app.config;var favicons=this.app.favicons;var name;if(this.isSearch()){name=dataset.searchName;}else{name=this.title.textContent;}
var url=this._currentURL;LazyLoader.load('shared/js/icons_helper.js',(function(){IconsHelper.getIcon(url,null,{icons:favicons}).then(icon=>{var activity=new MozActivity({name:'save-bookmark',data:{type:'url',url:url,name:name,icon:icon,iconable:false}});if(this.addToHomeButton){activity.onsuccess=function onsuccess(){this.addToHomeButton.hidden=true;}.bind(this);}});}).bind(this));};AppChrome.prototype.onAddBookmark=function ac_onAddBookmark(){var self=this;function selected(value){if(value){self.addBookmark();}}
var data={title:_('add-to-home-screen'),options:[]};if(this.isSearch()){var dataset=this.app.config;data.options.push({id:'search',text:dataset.searchName});}else{data.options.push({id:'origin',text:this.title.textContent});}
ModalDialog.selectOne(data,selected);};AppChrome.prototype.showWindows=function ac_showWindows(){window.dispatchEvent(new CustomEvent('taskmanagershow',{detail:{filter:'browser-only'}}));};AppChrome.prototype.__defineGetter__('overflowMenu',function ac_getOverflowMenu(){if(!this._overflowMenu&&this.useCombinedChrome()&&window.GaiaOverflowMenu){this.app.element.insertAdjacentHTML('afterbegin',this.overflowMenuView());this._overflowMenu=this.containerElement.querySelector('gaia-overflow-menu');this.newWindowButton=this._overflowMenu.querySelector('#new-window');this.newPrivateWinButton=this._overflowMenu.querySelector('#new-private-window');this.addToHomeButton=this._overflowMenu.querySelector('#add-to-home');this.shareButton=this._overflowMenu.querySelector('#share');this.newWindowButton.addEventListener('click',this);this.newPrivateWinButton.addEventListener('click',this);this.addToHomeButton.addEventListener('click',this);this.shareButton.addEventListener('click',this);this.updateAddToHomeButton();}
return this._overflowMenu;});AppChrome.prototype.showOverflowMenu=function ac_showOverflowMenu(){this.overflowMenu.show();};AppChrome.prototype.hideOverflowMenu=function ac_hideOverflowMenu(){this.overflowMenu.hide();};AppChrome.prototype.showOverflowMenu=function ac_showOverflowMenu(){if(this.app.contextmenu){var name=this.isSearch()?this.app.config.searchName:this.title.textContent;this.app.contextmenu.showDefaultMenu(newTabManifestURL,name);}};exports.AppChrome=AppChrome;}(window));;'use strict';(function(exports){var toasterEvents=['init','open','complete','terminate','close'];var toasterStateTable={'uninit':['closed',null,null,null,null],'closed':[null,'opening',null,'uninit',null],'opening':[null,null,'opened','uninit',null],'opened':[null,null,null,'uninit','closing'],'closing':[null,'opening','closed','uninit',null]};var AttentionToaster=function(app){this.app=app;};AttentionToaster.prototype={_currentToasterState:'uninit',TOASTER_TIMEOUT:5000,RESPAWN_TIMEOUT:45000,start:function(){this.app.element.addEventListener('_closed',this);this.app.element.addEventListener('_requestopen',this);this.app.element.addEventListener('transitionend',this);this.app.element.addEventListener('_secure-appclosed',this);this.app.element.addEventListener('_secure-appopened',this);this.app.element.addEventListener('_lockscreen-appclosed',this);this.app.element.addEventListener('_lockscreen-appopened',this);},stop:function(){this.app.element.removeEventListener('_closed',this);this.app.element.removeEventListener('_requestopen',this);this.app.element.removeEventListener('transitionend',this);this.app.element.removeEventListener('_secure-appclosed',this);this.app.element.removeEventListener('_secure-appopened',this);this.app.element.removeEventListener('_lockscreen-appclosed',this);this.app.element.removeEventListener('_lockscreen-appopened',this);},shouldProcess:function(){return this.app&&this.app.element&&!this.app.isHidden()&&!this.app.isActive()&&!this.app.isDead();},handleEvent:function(evt){if(!this.shouldProcess()){this.app.debug('should not process');return;}
switch(evt.type){case'_lockscreen-appclosed':case'_secure-appopened':this.processStateChange('close',evt.type);break;case'_requestopen':this.processStateChange('terminate',evt.type);break;case'transitionend':if(evt.target!==this.app.element){return;}
this.processStateChange('complete',evt.type);break;case'_closed':this.processStateChange('init',evt.type);break;case'_lockscreen-appopened':case'_secure-appclosed':this.processStateChange('open',evt.type);break;}},processStateChange:function(event,reason){if(!this.shouldProcess()){this.app.debug('should not process '+event);return;}
var eventIndex=toasterEvents.indexOf(event);var nextState=toasterStateTable[this._currentToasterState][eventIndex];this.app.debug(this._currentToasterState+' -> '+nextState);if(!nextState){return;}
this.app.debug('[toaster] '+
this._currentToasterState+'->'+nextState+':'+event+','+reason);this._currentToasterState=nextState;this.app.element.setAttribute('toaster-transition-state',this._currentToasterState);if(typeof(this['_enter_'+nextState])=='function'){this['_enter_'+nextState](event);}},_enter_closing:function(){if(!this.app||!this.app.element||(Service&&Service.locked&&!Service.query('getTopMostWindow').isFullScreen())){return;}
this.app.element.classList.remove('displayed');},_enter_closed:function(evt){if(!this.app||!this.app.element){return;}
if(evt=='init'){this.becomeToaster();this.app.tryWaitForFullRepaint(function(){this.processStateChange('open','repainted');}.bind(this));}else if(evt=='complete'){this.app&&this.app.setVisible(false);this.respawnTimer=window.setTimeout(function(){this.processStateChange('open','respawn');}.bind(this),this.RESPAWN_TIMEOUT);}},_enter_opened:function(){if(!this.app||!this.app.element){return;}
this.app&&this.app.setVisible(true);this._toasterTimer=window.setTimeout(function(){if(Service&&Service.locked&&!Service.query('getTopMostWindow').isFullScreen()){return;}
this.processStateChange('close','timeout');}.bind(this),this.TOASTER_TIMEOUT);},_enter_opening:function(){if(!this.app||!this.app.element){return;}
window.clearTimeout(this.respawnTimer);this.respawnTimer=null;this.app.setVisible(true);this.app.element.classList.add('displayed');},_enter_uninit:function(){if(!this.app||!this.app.element){return;}
if(this._toasterTimer){window.clearTimeout(this._toasterTimer);this._toasterTimer=null;}
this.recoverLayout();},recoverLayout:function(){if(this.app&&this.app.resized){this.app.element.classList.remove('displayed');this.app.element.classList.remove('toaster-mode');this.app.resized=false;this.app.publish('recovering');this.app._resize();}},becomeToaster:function(){if(!this.shouldProcess()){return;}
this.app.element.style.height=this.app.closedHeight+'px';this.app.element.classList.add('toaster-mode');this.app.resized=true;}};exports.AttentionToaster=AttentionToaster;}(window));;'use strict';(function(exports){var AppStatusbar=function(app){this.app=app;this.containerElement=app.element;this.render();this._fetchAllElements();this._touchForwarder=new TouchForwarder();this._touchForwarder.destination=this.app.browser.element;this.app.element.addEventListener('_suspended',this);this.app.element.addEventListener('_resumed',this);};AppStatusbar.prototype=Object.create(BaseUI.prototype);AppStatusbar.prototype.constructor=AppStatusbar;AppStatusbar.prototype.EVENT_PREFIX='appstatusbar';AppStatusbar.prototype.DEBUG=false;AppStatusbar.prototype.view=function(){var content=`<div class="titlebar">
             <div class="notifications-shadow"></div>
             <div class="statusbar-shadow titlebar-maximized"></div>
             <div class="statusbar-shadow titlebar-minimized"></div>
           </div>`;return content;};AppStatusbar.prototype.RELEASE_TIMEOUT=5000;AppStatusbar.prototype.screen=document.getElementById('screen');AppStatusbar.prototype._fetchAllElements=function(first_argument){this.titleBar=this.containerElement.querySelector('.titlebar');};AppStatusbar.prototype.handleEvent=function(evt){switch(evt.type){case'_resumed':this._touchForwarder.destination=this.app.browser.element;break;case'_suspended':this._touchForwarder.destination=null;break;}};AppStatusbar.prototype.handleStatusbarTouch=function(evt,barHeight){this.app.debug('preprocessing touch event...',evt.type);var touch;var cacheHeight=barHeight;if(!this.chromeBar){this.chromeBar=this.app.element.querySelector('.chrome');}
if(this._dontStopEvent){return;}
if(!this.app||!this.app.isFullScreen()){return;}
this.app.debug('processing touch event...',evt.type);evt.stopImmediatePropagation();evt.preventDefault();switch(evt.type){case'touchstart':clearTimeout(this._releaseTimeout);this._touchStart=evt;this._shouldForwardTap=true;touch=evt.changedTouches[0];this._startX=touch.clientX;this._startY=touch.clientY;this.chromeBar.style.transition='transform';this.titleBar.style.transition='transform';this.chromeBar.classList.add('dragging');break;case'touchmove':touch=evt.touches[0];var height=cacheHeight;var deltaX=touch.clientX-this._startX;var deltaY=touch.clientY-this._startY;if(Math.abs(deltaX)>5||Math.abs(deltaY)>5){this._shouldForwardTap=false;}
var translate=Math.min(deltaY,height);var heightThreshold=height;if(this.app&&this.app.isFullScreen()&&this.app.config.chrome&&this.app.config.chrome.navigation){translate=Math.min(deltaY,this.app.appChrome.height);heightThreshold=this.app.appChrome.height;this.titleBar.style.transform='translateY(calc('+
(translate-this.app.appChrome.height)+'px)';}else{this.titleBar.style.transform='translateY(calc('+translate+'px - 100%)';}
this.chromeBar.style.transform='translateY(calc('+translate+'px - 100%)';this.app.debug(translate,heightThreshold);if(translate>=heightThreshold){if(this._touchStart){this._touchForwarder.forward(this._touchStart);this._touchStart=null;}
this._touchForwarder.forward(evt);}
break;case'touchend':clearTimeout(this._releaseTimeout);if(this._touchStart){if(this._shouldForwardTap){this._touchForwarder.forward(this._touchStart);this._touchForwarder.forward(evt);this._touchStart=null;}
this._releaseBar();}else{this._dontStopEvent=true;this._touchForwarder.forward(evt);this._releaseAfterTimeout();}
break;}};AppStatusbar.prototype._releaseBar=function(){this.app.debug('releasing statusbar');this._dontStopEvent=false;var titleBar=this.titleBar;var chromeBar=this.chromeBar;chromeBar.classList.remove('dragged');chromeBar.classList.remove('dragging');chromeBar.style.transform='';chromeBar.style.transition='';titleBar.classList.remove('dragged');titleBar.style.transform='';titleBar.style.transition='';this.screen.classList.remove('minimized-tray');clearTimeout(this._releaseTimeout);this._releaseTimeout=null;};AppStatusbar.prototype._releaseAfterTimeout=function(){this.app.debug('stay until 5s');this.screen.classList.add('minimized-tray');var chromeBar=this.chromeBar;var titleBar=this.titleBar;var self=this;titleBar.style.transform='';titleBar.style.transition='';titleBar.classList.add('dragged');chromeBar.style.transform='';chromeBar.style.transition='';chromeBar.classList.add('dragged');chromeBar.classList.remove('dragging');self._releaseTimeout=setTimeout(function(){self._releaseBar();window.removeEventListener('touchstart',closeOnTap);},this.RELEASE_TIMEOUT);function closeOnTap(evt){if(evt.target!=self._touchForwarder.destination){return;}
window.removeEventListener('touchstart',closeOnTap);self.app.debug('user interaction, will release statusbar.');self._releaseBar(titleBar);}
window.addEventListener('touchstart',closeOnTap);};exports.AppStatusbar=AppStatusbar;}(window));;'use strict';(function(exports){var TransitionEvents=['open','close','complete','timeout','immediate-open','immediate-close'];var TransitionStateTable={'closed':['opening',null,null,null,'opened',null],'opened':[null,'closing',null,null,null,'closed'],'opening':[null,'closing','opened','opened','opened','closed'],'closing':['opened',null,'closed','closed','opened','closed']};var appTransitionSetting='app-transition.enabled';var transitionEnabled=SettingsListener.getSettingsLock().get(appTransitionSetting);SettingsListener.observe(appTransitionSetting,true,function(value){transitionEnabled=value;});var AppTransitionController=function AppTransitionController(app){if(!app||!app.element){return;}
this.app=app;this.app.debug('default animation:',this.app.openAnimation,this.app.closeAnimation);if(this.app.openAnimation){this.openAnimation=this.app.openAnimation;}
if(this.app.closeAnimation){this.closeAnimation=this.app.closeAnimation;}
if(this.app.CLASS_NAME=='AppWindow'){this.OPENING_TRANSITION_TIMEOUT=2500;}
this.app.element.addEventListener('_opening',this);this.app.element.addEventListener('_closing',this);this.app.element.addEventListener('_opened',this);this.app.element.addEventListener('_closed',this);this.app.element.addEventListener('_opentransitionstart',this);this.app.element.addEventListener('_closetransitionstart',this);this.app.element.addEventListener('_loaded',this);this.app.element.addEventListener('_openingtimeout',this);this.app.element.addEventListener('_closingtimeout',this);this.app.element.addEventListener('animationend',this);};AppTransitionController.prototype.destroy=function(){if(!this.app||!this.app.element){return;}
this.app.element.removeEventListener('_opening',this);this.app.element.removeEventListener('_closing',this);this.app.element.removeEventListener('_opened',this);this.app.element.removeEventListener('_closed',this);this.app.element.removeEventListener('_opentransitionstart',this);this.app.element.removeEventListener('_closetransitionstart',this);this.app.element.removeEventListener('_loaded',this);this.app.element.removeEventListener('_openingtimeout',this);this.app.element.removeEventListener('_closingtimeout',this);this.app.element.removeEventListener('animationend',this);this.app=null;};AppTransitionController.prototype._transitionState='closed';AppTransitionController.prototype._waitingForLoad=false;AppTransitionController.prototype.openAnimation='enlarge';AppTransitionController.prototype.closeAnimation='reduce';AppTransitionController.prototype.OPENING_TRANSITION_TIMEOUT=350;AppTransitionController.prototype.CLOSING_TRANSITION_TIMEOUT=350;AppTransitionController.prototype.SLOW_TRANSITION_TIMEOUT=3500;AppTransitionController.prototype.changeTransitionState=function atc_changeTransitionState(evt){var currentState=this._transitionState;var evtIndex=TransitionEvents.indexOf(evt);var state=TransitionStateTable[currentState][evtIndex];if(!state){return;}
this.app.debug(currentState,state,'::',evt);this.switchTransitionState(state);this.resetTransition();this['_do_'+state]();this.app.publish(state);if(!this.app){return;}
if(state=='opening'){this.app.publish('willopen');}else if(state=='closing'){this.app.publish('willclose');}else if(state=='opened'){this.app.publish('open');}else if(state=='closed'){this.app.publish('close');}};AppTransitionController.prototype._do_closing=function atc_do_closing(){this.app.debug('timer to ensure closed does occur.');this._closingTimeout=window.setTimeout(()=>{if(!this.app){return;}
this.app.broadcast('closingtimeout');},AppWindowManager.slowTransition?this.SLOW_TRANSITION_TIMEOUT:this.CLOSING_TRANSITION_TIMEOUT);if(!this.app||!this.app.element){return;}
this.app.element.classList.add('transition-closing');this.app.element.classList.add(this.getAnimationName('close'));};AppTransitionController.prototype._do_closed=function atc_do_closed(){};AppTransitionController.prototype.getAnimationName=function(type){if(transitionEnabled){return this.currentAnimation||this[type+'Animation']||type;}else{return'immediate';}};AppTransitionController.prototype._do_opening=function atc_do_opening(){this.app.debug('timer to ensure opened does occur.');this._openingTimeout=window.setTimeout(function(){this.app&&this.app.broadcast('openingtimeout');}.bind(this),AppWindowManager.slowTransition?this.SLOW_TRANSITION_TIMEOUT:this.OPENING_TRANSITION_TIMEOUT);this._waitingForLoad=false;this.app.element.classList.add('transition-opening');this.app.element.classList.add(this.getAnimationName('open'));this.app.debug(this.app.element.classList);};AppTransitionController.prototype._do_opened=function atc_do_opened(){};AppTransitionController.prototype.switchTransitionState=function atc_switchTransitionState(state){this._transitionState=state;if(!this.app){return;}
this.app._changeState('transition',this._transitionState);};AppTransitionController.prototype.handle_closing=function atc_handle_closing(){if(!this.app||!this.app.element){return;}
this.switchTransitionState('closing');};AppTransitionController.prototype.handle_closed=function atc_handle_closed(){if(!this.app||!this.app.element){return;}
this.resetTransition();if(!this.app.isAttentionWindow&&!this.app.isCallscreenWindow&&!this.app.isInputMethod){this.app.setVisible(false);}
this.app.setNFCFocus(false);this.app.element.classList.remove('active');};AppTransitionController.prototype.handle_opening=function atc_handle_opening(){if(!this.app||!this.app.element){return;}
if(this.app.loaded){var self=this;this.app.element.addEventListener('_opened',function onopen(){self.app.element.removeEventListener('_opened',onopen);self.app.publish('loadtime',{time:parseInt(Date.now()-self.app.launchTime),type:'w',src:self.app.config.url});});}
this.app.reviveBrowser();this.app.launchTime=Date.now();this.app.fadeIn();this.app.requestForeground();if(this.app.isHomescreen||this.app.isCallscreenWindow){this.app.setOrientation();}};AppTransitionController.prototype.handle_opened=function atc_handle_opened(){if(!this.app||!this.app.element){return;}
this.app.reviveBrowser();this.resetTransition();this.app.element.removeAttribute('aria-hidden');this.app.show();this.app.element.classList.add('active');this.app.requestForeground();if(!this.app.isCallscreenWindow){this.app.setOrientation();}
this.focusApp();};AppTransitionController.prototype.focusApp=function(){if(!this.app){return;}
if(this._shouldFocusApp()){this.app.debug('focusing this app.');this.app.focus();this.app.setNFCFocus(true);}};AppTransitionController.prototype._shouldFocusApp=function(){var bottomWindow=this.app.getBottomMostWindow();return(this.app.CLASS_NAME!=='SearchWindow'&&this._transitionState=='opened'&&Service.query('getTopMostWindow')===this.app&&Service.query('getTopMostUI').name===bottomWindow.HIERARCHY_MANAGER);};AppTransitionController.prototype.requireOpen=function(animation){this.currentAnimation=animation||this.openAnimation;this.app.debug('open with '+this.currentAnimation);if(this.currentAnimation=='immediate'){this.changeTransitionState('immediate-open');}else{this.changeTransitionState('open');}};AppTransitionController.prototype.requireClose=function(animation){this.currentAnimation=animation||this.closeAnimation;this.app.debug('close with '+this.currentAnimation);if(this.currentAnimation=='immediate'){this.changeTransitionState('immediate-close');}else{this.changeTransitionState('close');}};AppTransitionController.prototype.resetTransition=function atc_resetTransition(){if(this._openingTimeout){window.clearTimeout(this._openingTimeout);this._openingTimeout=null;}
if(this._closingTimeout){window.clearTimeout(this._closingTimeout);this._closingTimeout=null;}
this.clearTransitionClasses();};AppTransitionController.prototype.clearTransitionClasses=function atc_removeTransitionClasses(){if(!this.app||!this.app.element){return;}
var classes=['enlarge','reduce','to-cardview','from-cardview','invoking','invoked','zoom-in','zoom-out','fade-in','fade-out','transition-opening','transition-closing','immediate','fadeout','slideleft','slideright','in-from-left','out-to-right','will-become-active','will-become-inactive','slide-to-top','slide-from-top','slide-to-bottom','slide-from-bottom','home-from-cardview','home-to-cardview'];classes.forEach(function iterator(cls){this.app.element.classList.remove(cls);},this);};AppTransitionController.prototype.handleEvent=function atc_handleEvent(evt){switch(evt.type){case'_opening':this.handle_opening();break;case'_opened':this.handle_opened();break;case'_closed':this.handle_closed();break;case'_closing':this.handle_closing();break;case'_closingtimeout':case'_openingtimeout':this.changeTransitionState('timeout',evt.type);break;case'_loaded':if(this._waitingForLoad){this._waitingForLoad=false;this.changeTransitionState('complete');}
break;case'animationend':evt.stopPropagation();this.app.element.classList.remove('transition-opening');if(Service.isBusyLoading()){this._waitingForLoad=true;if(this.app.isHomescreen&&this._transitionState=='opening'){this.app.focus();}
return;}
this.app.debug(evt.animationName+' has been ENDED!');this.changeTransitionState('complete',evt.type);break;}};exports.AppTransitionController=AppTransitionController;}(window));;'use strict';(function(exports){var _id=0;function AppAuthenticationDialog(app){this.app=app;this._event=null;this.containerElement=app.element;this.instanceID=_id++;this._injected=false;this.app.element.addEventListener('mozbrowserusernameandpasswordrequired',this);}
AppAuthenticationDialog.prototype=Object.create(window.BaseUI.prototype);AppAuthenticationDialog.prototype.CLASS_NAME='AuthenticationDialog';AppAuthenticationDialog.prototype.EVENT_PREFIX='authdialog';AppAuthenticationDialog.prototype.ELEMENT_PREFIX='authentication-dialog-';AppAuthenticationDialog.prototype.elements=null;AppAuthenticationDialog.prototype._event=null;AppAuthenticationDialog.prototype._fetchElements=function aad__fetchElements(){this.element=document.getElementById(this.CLASS_NAME+this.instanceID);this.elements={};var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};this.elementClasses=['http-username-input','http-password-input','http-authentication-message','http-authentication-ok','http-authentication-cancel','http-authentication-header'];this.elementClasses.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=this.element.querySelector('.'+this.ELEMENT_PREFIX+name);},this);};AppAuthenticationDialog.prototype.view=function aad_view(){var id=this.CLASS_NAME+this.instanceID;return`<section class="authentication-dialog skin-organic" id="${id}"
      role="region">
      <gaia-header action="close"
        class="authentication-dialog-http-authentication-header">
        <button class="authentication-dialog-http-authentication-cancel">
        </button>
        <h1 data-l10n-id="sign-in-to-website"></h1>
        <button class="authentication-dialog-http-authentication-ok"
        data-l10n-id="login"></button>
      </gaia-header>
      <span class="authentication-dialog-http-authentication-message">
      </span>
      <label>
        <span data-l10n-id="username"></span>
        <input type="text" class="authentication-dialog-http-username-input" />
      </label>
      <label>
        <span data-l10n-id="password"></span>
        <input type="password"
               class="authentication-dialog-http-password-input" />
      </label>
    </section>`;};AppAuthenticationDialog.prototype.handleEvent=function(evt){this.debug(' AAD>> got event: '+evt.type);evt.preventDefault();evt.stopPropagation();this._event=evt;if(!this._injected){this.render();}
this.show();this._injected=true;};AppAuthenticationDialog.prototype._registerEvents=function aad__registerEvents(){this.elements.httpAuthenticationOk.addEventListener('click',this.confirmHandler.bind(this));this.elements.httpAuthenticationHeader.addEventListener('action',this.cancelHandler.bind(this));};AppAuthenticationDialog.prototype._unregisterEvents=function aad__unregisterEvents(){this.app.element.removeEventListener('mozbrowserusernameandpasswordrequired',this);};AppAuthenticationDialog.prototype.show=function aad_show(){var evt=this._event;var elements=this.elements;this.element.classList.add('visible');this.debug(' AAD>> showing');navigator.mozL10n.setAttributes(elements.httpAuthenticationMessage,'http-authentication-message2',{host:evt.detail.host});elements.httpUsernameInput.value='';elements.httpPasswordInput.value='';};AppAuthenticationDialog.prototype.hide=function aad_hide(){this.elements.httpUsernameInput.blur();this.elements.httpPasswordInput.blur();this.element.classList.remove('visible');this.debug(' AAD>> hided');};AppAuthenticationDialog.prototype.confirmHandler=function aad_confirmHandler(){var elements=this.elements;var evt=this._event;this.hide();evt.detail.authenticate(elements.httpUsernameInput.value,elements.httpPasswordInput.value);this._event=null;};AppAuthenticationDialog.prototype.cancelHandler=function aad_cancelHandler(){var evt=this._event;this.hide();evt.detail.cancel();this._event=null;};exports.AppAuthenticationDialog=AppAuthenticationDialog;}(window));;'use strict';(function(exports){var DEBUG=false;var TextSelectionDialog=function(){this.containerElement=document.getElementById('text-selection-dialog-root');this.event=null;this._enabled=false;this._hideTimeout=null;this._injected=false;this._hasCutOrCopied=false;this._ignoreSelectionChange=false;this._isCommandSendable=false;this._transitionState='closed';this._scrolling=false;this._isSelectionVisible=true;this.textualmenuDetail=null;SettingsListener.observe('copypaste.enabled',true,function onObserve(value){if(value){this.start();}else{this.stop();}}.bind(this));};TextSelectionDialog.prototype=Object.create(window.BaseUI.prototype);TextSelectionDialog.prototype.TEXTDIALOG_HEIGHT=52;TextSelectionDialog.prototype.TEXTDIALOG_WIDTH=54;TextSelectionDialog.prototype.SHORTCUT_TIMEOUT=3000;TextSelectionDialog.prototype.RESET_CUT_OR_PASTE_TIMEOUT=15000;TextSelectionDialog.prototype.DISTANCE_FROM_MENUBOTTOM_TO_SELECTEDAREA=12;TextSelectionDialog.prototype.DISTANCE_FROM_SELECTEDAREA_TO_MENUTOP=43;TextSelectionDialog.prototype.DISTANCE_FROM_BOUNDARY=5;TextSelectionDialog.prototype.ID_NAME='TextSelectionDialog';TextSelectionDialog.prototype.ELEMENT_PREFIX='textselection-dialog-';TextSelectionDialog.prototype.start=function tsd_start(){if(this._enabled){return;}
this._enabled=true;window.addEventListener('hierachychanged',this);window.addEventListener('activeappchanged',this);window.addEventListener('home',this);window.addEventListener('mozChromeEvent',this);window.addEventListener('value-selector-shown',this);window.addEventListener('value-selector-hidden',this);};TextSelectionDialog.prototype.stop=function tsd_stop(){if(!this._enabled){return;}
this._enabled=false;window.removeEventListener('hierachychanged',this);window.removeEventListener('activeappchanged',this);window.removeEventListener('home',this);window.removeEventListener('mozChromeEvent',this);window.removeEventListener('value-selector-shown',this);window.removeEventListener('value-selector-hidden',this);};TextSelectionDialog.prototype.debug=function tsd_debug(msg){if(DEBUG||this._DEBUG){console.log('[Dump: '+this.ID_NAME+']'+
JSON.stringify(msg));}};TextSelectionDialog.prototype.handleEvent=function tsd_handleEvent(evt){switch(evt.type){case'home':case'activeappchanged':case'hierachychanged':this.close();break;case'value-selector-shown':this._ignoreSelectionChange=true;break;case'value-selector-hidden':this._ignoreSelectionChange=false;break;case'mozChromeEvent':switch(evt.detail.type){case'selectionstatechanged':if(this._ignoreSelectionChange){return;}
evt.preventDefault();evt.stopPropagation();var detail=evt.detail.detail;if(!detail){return;}
this.debug('on receive selection change event');this.debug(JSON.stringify(detail));this._isSelectionVisible=detail.visible;if(detail.isCollapsed){this._onCollapsedMode(detail);}else{this._onSelectionMode(detail);}
break;case'scrollviewchange':this.debug('scrollviewchange');this.debug(JSON.stringify(evt.detail.detail));if(evt.detail.detail.state==='started'&&this._transitionState==='opened'){this._changeTransitionState('closed');this._scrolling=true;}else if(evt.detail.detail.state==='stopped'&&this._scrolling===true){this._scrolling=false;if(this._isSelectionVisible){this.updateDialogPosition();}}
break;case'touchcarettap':this.debug('touchcarettap');this.show(this.textualmenuDetail);this._triggerShortcutTimeout();break;}}};TextSelectionDialog.prototype._onCollapsedMode=function tsd__onCollapsedMode(detail){var states=detail.states;var commands=detail.commands;this.textualmenuDetail=detail;if(states.indexOf('taponcaret')!==-1||(states.indexOf('mouseup')!==-1&&this._hasCutOrCopied)||(this._transitionState==='opened'&&states.indexOf('updateposition')!==-1)){commands.canSelectAll=false;this.show(detail);this._triggerShortcutTimeout();}else{this.hide();}};TextSelectionDialog.prototype._onSelectionMode=function tsd__onSelectionMode(detail){var rect=detail.rect;var states=detail.states;var commands=detail.commands;var rectHeight=rect.top-rect.bottom;var rectWidth=rect.right-rect.left;if(!this._isSelectionVisible){this.hide();return;}
if(states.indexOf('blur')!==-1){this.hide();return;}
if(states.indexOf('collapsetoend')!==-1){this.hide();return;}
if(states.indexOf('mouseup')!==-1&&rectHeight===0&&rectWidth===0){this.hide();return;}
if(states.length===0||(rectHeight===0&&rectWidth===0)||!(commands.canPaste||commands.canCut||commands.canSelectAll||commands.canCopy)){return;}
if(!this._injected){this.render();this._injected=true;}
if(states.indexOf('selectall')!==-1||states.indexOf('mouseup')!==-1||(states.indexOf('updateposition')!==-1&&this.textualmenuDetail!=null)){this.show(detail);return;}
this.hide();};TextSelectionDialog.prototype._triggerShortcutTimeout=function tsd__triggerShortcutTimeout(){window.clearTimeout(this._hideTimeout);this._hideTimeout=window.setTimeout(function(){this.close();}.bind(this),this.SHORTCUT_TIMEOUT);};TextSelectionDialog.prototype._fetchElements=function tsd__fetchElements(){this.element=document.getElementById(this.ID_NAME);this.elements={};var toCamelCase=function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};this.elementClasses=['copy','cut','paste','selectall'];this.elementClasses.forEach(function createElementRef(name){this.elements[toCamelCase(name)]=this.element.querySelector('.'+this.ELEMENT_PREFIX+name);},this);};TextSelectionDialog.prototype._registerEvents=function tsd__registerEvents(){var elements=this.elements;for(var ele in elements){elements[ele].addEventListener('mousedown',this._elementEventHandler.bind(this));elements[ele].addEventListener('mouseout',this._elementEventHandler.bind(this));elements[ele].addEventListener('click',this._elementEventHandler.bind(this));}
this.element.addEventListener('transitionend',this._elementEventHandler.bind(this));};TextSelectionDialog.prototype._elementEventHandler=function tsd__elementEventHandler(evt){switch(evt.type){case'mousedown':this._isCommandSendable=true;evt.preventDefault();break;case'transitionend':if(this._transitionState==='closing'){this._changeTransitionState('closed');}
break;case'click':this[evt.target.dataset.action+'Handler']&&this[evt.target.dataset.action+'Handler'](evt);break;case'mouseout':this._isCommandSendable=false;break;}};TextSelectionDialog.prototype._changeTransitionState=function tsd__changeTransitionState(state){if(!this.element){return;}
switch(state){case'opened':this.element.classList.add('active');this.element.classList.add('visible');break;case'closing':this.element.classList.remove('visible');break;case'closed':this.element.classList.remove('active');break;}
this._transitionState=state;};TextSelectionDialog.prototype._doCommand=function tsd_doCommand(evt,cmd){if(!this._isCommandSendable){return;}
var props={detail:{type:'do-command',cmd:cmd}};this.debug(JSON.stringify(props));window.dispatchEvent(new CustomEvent('mozContentEvent',props));this.close();evt.preventDefault();};TextSelectionDialog.prototype.copyHandler=function tsd_copyHandler(evt){this._doCommand(evt,'copy');this._resetCutOrCopiedTimer();this._hasCutOrCopied=true;};TextSelectionDialog.prototype.cutHandler=function tsd_cutHandler(evt){this._doCommand(evt,'cut');this._resetCutOrCopiedTimer();this._hasCutOrCopied=true;};TextSelectionDialog.prototype.pasteHandler=function tsd_pasteHandler(evt){this._doCommand(evt,'paste');this._hasCutOrCopied=false;window.clearTimeout(this._resetCutOrCopiedTimeout);};TextSelectionDialog.prototype.selectallHandler=function tsd_selectallHandler(evt){this._doCommand(evt,'selectall');};TextSelectionDialog.prototype.view=function tsd_view(){var temp=`<div class="textselection-dialog" id="${this.ID_NAME}">
              <div data-action="selectall"
                class="textselection-dialog-selectall"></div>
              <div data-action="cut" class="textselection-dialog-cut"></div>
              <div data-action="copy" class="textselection-dialog-copy">
                </div>
              <div data-action="paste" class="textselection-dialog-paste">
                </div>
            </div>`;return temp;};TextSelectionDialog.prototype._resetCutOrCopiedTimer=function tsd_resetCutOrCopiedTimer(){window.clearTimeout(this._resetCutOrCopiedTimeout);this._resetCutOrCopiedTimeout=window.setTimeout(function(){this._hasCutOrCopied=false;}.bind(this),this.RESET_CUT_OR_PASTE_TIMEOUT);};TextSelectionDialog.prototype.show=function tsd_show(detail){clearTimeout(this._hideTimeout);var numOfSelectOptions=0;var options=['Paste','Copy','Cut','SelectAll'];var lastVisibleOption;options.forEach(function(option){if(detail.commands['can'+option]){numOfSelectOptions++;lastVisibleOption=this.elements[option.toLowerCase()];lastVisibleOption.classList.remove('hidden','last-option');}else{this.elements[option.toLowerCase()].classList.add('hidden');}},this);this.numOfSelectOptions=numOfSelectOptions;this.textualmenuDetail=detail;lastVisibleOption.classList.add('last-option');this.updateDialogPosition();};TextSelectionDialog.prototype.updateDialogPosition=function tsd_updateDialogPosition(){var pos=this.calculateDialogPostion();this.debug(pos);this.element.style.top=pos.top+'px';this.element.style.left=pos.left+'px';this._changeTransitionState('opened');};TextSelectionDialog.prototype.calculateDialogPostion=function tsd_calculateDialogPostion(){var numOfSelectOptions=this.numOfSelectOptions;var detail=this.textualmenuDetail;var frameHeight=layoutManager.height;var frameWidth=layoutManager.width;var selectOptionWidth=this.TEXTDIALOG_WIDTH;var selectOptionHeight=this.TEXTDIALOG_HEIGHT;var selectDialogTop=(detail.rect.top)*detail.zoomFactor;var selectDialogBottom=(detail.rect.bottom)*detail.zoomFactor;var selectDialogLeft=(detail.rect.left)*detail.zoomFactor;var selectDialogRight=(detail.rect.right)*detail.zoomFactor;var distanceFromBottom=this.DISTANCE_FROM_SELECTEDAREA_TO_MENUTOP;var distanceFromTop=this.DISTANCE_FROM_MENUBOTTOM_TO_SELECTEDAREA;var posTop=selectDialogTop-selectOptionHeight-distanceFromTop;var posLeft=(selectDialogLeft+selectDialogRight-
numOfSelectOptions*selectOptionWidth)/2;if(posTop<0){posTop=selectDialogBottom+distanceFromBottom;}
if(posTop>=(frameHeight-distanceFromBottom-selectOptionHeight)){posTop=(((selectDialogTop>=0)?selectDialogTop:0)+
((selectDialogBottom>=frameHeight)?frameHeight:selectDialogBottom)-selectOptionHeight)/2;}
if(posLeft<this.DISTANCE_FROM_BOUNDARY){posLeft=this.DISTANCE_FROM_BOUNDARY;}
if((posLeft+numOfSelectOptions*selectOptionWidth+
this.DISTANCE_FROM_BOUNDARY)>frameWidth){posLeft=frameWidth-numOfSelectOptions*selectOptionWidth-
this.DISTANCE_FROM_BOUNDARY;}
return{top:posTop+detail.offsetY,left:posLeft+detail.offsetX};};TextSelectionDialog.prototype.hide=function tsd_hide(){if(!this.element){return;}
this._changeTransitionState('closing');};TextSelectionDialog.prototype.close=function tsd_close(){if(this._transitionState!=='opened'){return;}
this.hide();this.element.blur();this.textualmenuDetail=null;clearTimeout(this._hideTimeout);};exports.TextSelectionDialog=TextSelectionDialog;}(window));;'use strict';(function(exports){var DEBUG=false;var TRACE=false;var _id=0;var AppWindow=function AppWindow(configuration){this.reConfig(configuration);this.render();this.publish('created');if(DEBUG||this._DEBUG){this.constructor[this.instanceID]=this;}
this.launchTime=Date.now();return this;};AppWindow.SUSPENDING_ENABLED=false;SettingsListener.observe('app-suspending.enabled',false,function(value){AppWindow.SUSPENDING_ENABLED=!!value;});AppWindow.prototype.CLASS_LIST='appWindow';AppWindow.prototype._DEBUG=false;AppWindow.prototype.HIERARCHY_MANAGER='AppWindowManager';AppWindow.prototype.generateID=function(){if(!this.instanceID){this.instanceID=this.CLASS_NAME+'_'+_id;_id++;}};AppWindow.prototype.reConfig=function aw_reConfig(configuration){for(var key in configuration){this[key]=configuration[key];}
this.browser_config=configuration;this.config=configuration;this.config.chrome=(this.manifest&&this.manifest.chrome)?this.manifest.chrome:this.config.chrome;if(!this.config.chrome){this.config.chrome={scrollable:this.isBrowser(),maximized:this.isBrowser()};}else if(this.config.chrome.navigation){this.config.chrome.scrollable=!this.isFullScreen();this.config.chrome.maximized=true;}
if(this.manifest){this.shortName=new ManifestHelper(this.manifest).short_name;}
if(!this.manifest&&this.config&&this.config.title){this.updateName(this.config.title);}else{this.name=new ManifestHelper(this.manifest).name;}
this.getIconForSplash();this.generateID();this.groupID=this.getRootWindow().instanceID;if(this.previousWindow){this.previousWindow.setNextWindow(this);}else if(this.rearWindow){this.rearWindow.setFrontWindow(this);}};AppWindow.prototype.updateName=function aw_updateName(name){if(this.config&&this.config.title){this.config.title=name;}
this.name=name;};AppWindow.prototype._visibilityState='foreground';AppWindow.prototype.rotatingDegree=0;AppWindow.prototype._dump=function aw__dump(){console.log('======================');try{throw new Error('e');}catch(e){this.debug(e.stack);}
console.log('======================');};AppWindow.prototype.setActive=function(enable){this.getTopMostWindow()._setActive(enable);};AppWindow.prototype.setVisible=function aw_setVisible(visible){this.debug('set visibility -> ',visible);this.setVisibleForScreenReader(visible);this._setActive(visible);if(visible){this._showFrame();}else{this._hideFrame();}
if(this.frontWindow){this.frontWindow.setVisible(visible);}};AppWindow.prototype.setVisibleForScreenReader=function aw_setVisibleForScreenReader(visible){if(!this.element){return;}
this.element.setAttribute('aria-hidden',!visible);};AppWindow.prototype._showFrame=function aw__showFrame(){this.debug('before showing frame');this.reviveBrowser();if(!this.browser.element.classList.contains('hidden')){return;}
this.browser.element.classList.remove('hidden');this._setVisible(true);if(this.isHomescreen){return;}
if(this.screenshotOverlay&&this.screenshotOverlay.classList.contains('visible')){this.tryWaitForFullRepaint(this._hideScreenshotOverlay.bind(this));}};AppWindow.prototype._hideFrame=function aw__hideFrame(){this.debug('before hiding frame');if(!this.browser||this.browser.element.classList.contains('hidden')){return;}
this._setVisible(false);this.browser.element.classList.add('hidden');};AppWindow.prototype.isActive=function aw_isActive(){if(!this.element){return false;}
if(this.element.classList.contains('will-become-active')){return true;}
if(this.element.classList.contains('will-become-inactive')){return false;}
if(this.transitionController){return(this.transitionController._transitionState=='opened'||this.transitionController._transitionState=='opening');}else{return false;}};AppWindow.prototype.shouldResize=function aw_shouldResize(){if(this.element.classList.contains('will-become-inactive')){return true;}
return this.isActive();};AppWindow.prototype.isSheetTransitioning=function aw_isSheetTransitioning(){return this.element.classList.contains('inside-edges');};AppWindow.prototype.isTransitioning=function aw_isTransitioning(){if(this.transitionController){return(this.transitionController._transitionState=='opening'||this.transitionController._transitionState=='closing');}else{return(this.element.classList.contains('transition-opening')||this.element.classList.contains('transition-closing'));}};AppWindow.prototype.suspended=false;AppWindow.prototype.reviveBrowser=function(){if(this.browser){return;}
this.debug(' ...revived!');this.browser=new BrowserFrame(this.browser_config);this.browserContainer.appendChild(this.browser.element);this.iframe=this.browser.element;this.launchTime=Date.now();this.suspended=false;this.element.classList.remove('suspended');this.browser.element.classList.add('hidden');this._setVisible(false);this.publish('resumed');};AppWindow.prototype.destroyBrowser=function(){if(!this.browser){return;}
this.loading=false;this.loaded=false;this.suspended=true;this.element.classList.add('suspended');this.browserContainer.removeChild(this.browser.element);this.browser=null;this.iframe=null;this._sslState='';this.publish('suspended');};AppWindow.prototype.kill=function aw_kill(evt){if(this._killed){return;}
if(!this.isHomescreen){this._killed=true;}
if(DEBUG||this._DEBUG){this.constructor[this.instanceID]=null;}
if(this.callerWindow){this.callerWindow.calleeWindow=null;this.callerWindow=null;}
if(this.calleeWindow){this.calleeWindow.callerWindow=null;this.calleeWindow=null;}
if(this.frontWindow){this.frontWindow.kill();this.frontWindow=null;}
if(this.nextWindow){this.nextWindow.kill();this.nextWindow=null;}
if(this.attentionWindow){this.attentionWindow.kill();this.attentionWindow=null;}
if(this.isActive()&&this.getBottomMostWindow().isActive()&&!this.isHomescreen){var onClosed=function(){this.element.removeEventListener('_closed',onClosed);this.destroy();}.bind(this);this.element.addEventListener('_closed',onClosed);if(this.previousWindow){this.previousWindow.getBottomMostWindow().open('in-from-left');this.close('out-to-right');}else{if(this.transitionController){setTimeout(this.close.bind(this,'immediate'),this.transitionController.CLOSING_TRANSITION_TIMEOUT);}
this.requestClose();}}else{this.destroy();}
this.publish('terminated');};AppWindow.prototype.isDead=function aw_isDead(){return(this._killed||!this.element);};AppWindow.prototype.destroy=function aw_destroy(){if(this.previousWindow){this.previousWindow.unsetNextWindow();this.previousWindow=null;}
if(this.rearWindow){this.rearWindow.unsetFrontWindow();this.rearWindow=null;}
if(this.parentWindow){this.parentWindow.unsetAttentionWindow();this.parentWindow=null;}
this.publish('willdestroy');this.uninstallSubComponents();if(this.element){if(this.element.parentNode){this.element.parentNode.removeChild(this.element);}
this.element=null;}
this.publish('destroyed');};AppWindow.prototype.containerElement=document.getElementById('windows');AppWindow.prototype.view=function aw_view(){return`<div class="${this.CLASS_LIST}" id="${this.instanceID}"
              transition-state="closed">
              <div class="identification-overlay">
                <div>
                  <div class="icon"></div>
                  <span class="title"></span>
                </div>
              </div>
              <div class="fade-overlay"></div>
              <div class="touch-blocker"></div>
              <div class="browser-container">
               <div class="screenshot-overlay"></div>
              </div>
           </div>`;};AppWindow.prototype._render=function aw__render(){if(this.element){return;}
this.publish('willrender');var range=document.createRange();var fragment=range.createContextualFragment(this.view());if(this.iframe){this.browser={element:this.iframe};}else{this.browser=new BrowserFrame(this.browser_config);}
this.element=fragment.getElementById(this.instanceID);this.element.dataset.manifestName=this.manifest?this.manifest.name:'';this.frame=this.element;this.iframe=this.browser.element;this.iframe.dataset.frameType='window';this.iframe.dataset.frameOrigin=this.origin;this.iframe.dataset.url=this.config.url;if(this.isFullScreen()){this.element.classList.add('fullscreen-app');}
if(this.isBrowser()){this.element.classList.add('browser');}
if(this.isPrivateBrowser()){this.element.classList.add('private');}
this.browserContainer=this.element.querySelector('.browser-container');this.browserContainer.appendChild(this.browser.element);this.containerElement.appendChild(fragment);this.screenshotOverlay=this.element.querySelector('.screenshot-overlay');this.fadeOverlay=this.element.querySelector('.fade-overlay');var overlay='.identification-overlay';this.identificationOverlay=this.element.querySelector(overlay);var icon='.identification-overlay .icon';this.identificationIcon=this.element.querySelector(icon);var title='.identification-overlay .title';this.identificationTitle=this.element.querySelector(title);if(this.config.stayBackground||this.isHomescreen){this.setVisible(false);}
this.publish('rendered');this._rendered=true;setTimeout(this.setFrameBackground.bind(this));};AppWindow.prototype.render=function aw_render(){this._render();this._registerEvents();this.installSubComponents();this.determineRotationDegree();};AppWindow.prototype.isBrowser=function aw_isbrowser(){return!this.manifestURL;};AppWindow.prototype.isPrivateBrowser=function aw_isprivate(){return!!this.browser_config.isPrivate;};AppWindow.prototype.isCertified=function aw_iscertified(){return this.config.manifest&&'certified'===this.config.manifest.type;};AppWindow.prototype.navigate=function aw_isbrowser(url){var appIsSearch=this.manifest&&this.manifest.role==='search';if(!this.isBrowser()&&!appIsSearch){console.warn('Tried to navigate an illegal app window.');return;}
if(this.frontWindow){this.frontWindow.kill();this.frontWindow=null;}
if(!this.isBrowser()){this.manifestURL=null;this.manifest=null;this.element.classList.add('browser');this.reConfig({url:url,title:url,oop:true});this.browserContainer.removeChild(this.browser.element);this.browser=new BrowserFrame(this.browser_config);this.browserContainer.appendChild(this.browser.element);this.iframe=this.browser.element;this.launchTime=Date.now();this.appChrome&&this.appChrome.reConfig();}
this.browser.element.src=url;};AppWindow.REGISTERED_EVENTS=['mozbrowserclose','mozbrowsererror','mozbrowservisibilitychange','mozbrowserloadend','mozbrowseractivitydone','mozbrowserloadstart','mozbrowsertitlechange','mozbrowserlocationchange','mozbrowsermetachange','mozbrowsericonchange','mozbrowserasyncscroll','mozbrowsersecuritychange','_localized','_swipein','_swipeout','_kill_suspended','_orientationchange','_focus','_blur','_hidewindow','_sheetdisplayed','_sheetsgestureend','_cardviewbeforeshow','_cardviewclosed','_cardviewshown','_closed','_shrinkingstart','_shrinkingstop'];AppWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'modalDialog':window.AppModalDialog,'valueSelector':window.ValueSelector,'authDialog':window.AppAuthenticationDialog,'contextmenu':window.BrowserContextMenu,'childWindowFactory':window.ChildWindowFactory,'statusbar':window.AppStatusbar};AppWindow.prototype.openAnimation='enlarge';AppWindow.prototype.closeAnimation='reduce';AppWindow.prototype.installSubComponents=function aw_installSubComponents(){this.debug('installing sub components...');for(var componentName in this.constructor.SUB_COMPONENTS){if(this.constructor.SUB_COMPONENTS[componentName]){this[componentName]=new this.constructor.SUB_COMPONENTS[componentName](this);this[componentName].start&&this[componentName].start();}}
if(this.isInputMethod){return;}
if(this.manifest){var that=this;that.element.addEventListener('_opened',function onOpened(){that.element.removeEventListener('_opened',onOpened);that.appChrome=new AppChrome(that);if(that.inError){that.appChrome.handleEvent({type:'mozbrowsererror'});}
if(that.loading){that.appChrome.handleEvent({type:'mozbrowserloadstart'});that.appChrome.handleEvent({type:'_loading'});}});}else{this.appChrome=new AppChrome(this);}};AppWindow.prototype.uninstallSubComponents=function aw_uninstallSubComponents(){for(var componentName in this.constructor.SUB_COMPONENTS){if(this[componentName]&&this[componentName].destroy){this[componentName].destroy();}
this[componentName]=null;}
if(this.appChrome){this.appChrome.destroy();this.appChrome=null;}};AppWindow.prototype._handle__localized=function aw__handle__localized(){if(!this.manifest){return;}
this.name=new ManifestHelper(this.manifest).name;this.shortName=new ManifestHelper(this.manifest).short_name;if(this.identificationTitle){this.identificationTitle.textContent=this.name;}
this.element.dataset.localizedName=this.name;this.publish('namechanged');};AppWindow.prototype._handle__orientationchange=function(evt){if(this.isActive()){this.frontWindow&&this.frontWindow.broadcast('orientationchange');if(!this.isHomescreen){this._resize(evt.detail);return;}else if(Service.currentApp&&Service.currentApp===this){this.lockOrientation();}}
var width=layoutManager.width;var height=layoutManager.getHeightFor(this);this.element.style.width=width+'px';this.element.style.height=height+'px';if(this.isHomescreen){return;}
if(this.width!=width){this.screenshotOverlay.style.visibility='hidden';}else{this.screenshotOverlay.style.visibility='';}};AppWindow.prototype._handle_mozbrowservisibilitychange=function aw__handle_mozbrowservisibilitychange(evt){var type=evt.detail.visible?'foreground':'background';this.publish(type);};AppWindow.prototype._handle_mozbrowseractivitydone=function aw__handle_mozbrowseractivitydone(evt){if(this.isActive()&&this.callerWindow){var caller=this.callerWindow;var callerBottom=caller.getBottomMostWindow();var calleeBottom=this.getBottomMostWindow();caller.calleeWindow=null;this.callerWindow=null;if(callerBottom!==calleeBottom){callerBottom.open('in-from-left');calleeBottom.close('out-to-right');}}};AppWindow.prototype._handle_mozbrowserclose=function aw__handle_mozbrowserclose(evt){this.kill();};AppWindow.prototype._handle_mozbrowsererror=function aw__handle_mozbrowsererror(evt){if(evt.detail.type!=='fatal'){this.inError=true;return;}
this.publish('crashed');if(this.constructor.SUSPENDING_ENABLED&&!this.isActive()){this.debug(' ..sleep! I will come back.');this.destroyBrowser();if(this.frontWindow){this.frontWindow.kill();}}else{this.kill(evt);}};AppWindow.prototype._handle_mozbrowserloadstart=function aw__handle_mozbrowserloadstart(evt){this.loading=true;this.inError=false;this._changeState('loading',true);this.publish('loading');};AppWindow.prototype._handle_mozbrowsertitlechange=function aw__handle_handle_mozbrowsertitlechange(evt){this.title=evt.detail;this.publish('titlechange');if(this.identificationTitle&&!this.manifest&&(!this.isPrivateBrowser()||this.config.url.startsWith('app:'))){this.identificationTitle.textContent=this.title;}};AppWindow.prototype._handle_mozbrowserloadend=function aw__handle_mozbrowserloadend(evt){if(!this.loaded){this.publish('loadtime',{time:parseInt(Date.now()-this.launchTime),timestamp:this.timestamp,type:'c',src:this.config.url});}
this.loading=false;this.loaded=true;this.element.classList.add('render');this.browserContainer.classList.add('render');this.element.style.backgroundImage='none';this._changeState('loading',false);this.publish('loaded');var backgroundColor=evt.detail.backgroundColor;this.debug('bgcolor= ',backgroundColor);if(backgroundColor&&backgroundColor.indexOf('rgb(')!=-1&&!this.isHomescreen){this.debug('setting background color..');this.browser.element.style.backgroundColor=backgroundColor;}};AppWindow.prototype._handle_mozbrowserlocationchange=function aw__handle_mozbrowserlocationchange(evt){this.favicons={};this.config.url=evt.detail;this.browser.element.dataset.url=evt.detail;this.publish('locationchange');};AppWindow.prototype._handle_mozbrowsericonchange=function aw__handle_mozbrowsericonchange(evt){var href=evt.detail.href;var sizes=evt.detail.sizes;if(!('favicons'in this)){this.favicons={};}
if(!(href in this.favicons)){this.favicons[href]={sizes:[]};}
if(sizes&&this.favicons[href].sizes.indexOf(sizes)===-1){this.favicons[href].sizes.push(sizes);}
if(this.identificationIcon&&!this.isPrivateBrowser()){this.identificationIcon.style.backgroundImage='url("'+evt.detail.href+'")';}
this.publish('iconchange');};AppWindow.prototype._handle_mozbrowserasyncscroll=function aw__handle_mozbrowserasyncscroll(evt){if(this.manifest){return;}
this.scrollPosition=evt.detail.top;this.publish('scroll');};AppWindow.prototype._handle_mozbrowsermetachange=function aw__handle_mozbrowsermetachange(evt){var detail=evt.detail;switch(detail.name){case'theme-color':if(!detail.type){return;}
var color='';if(detail.type!=='removed'){color=detail.content;}
this.themeColor=color;this.publish('themecolorchange');break;case'application-name':if(!this.isBrowser()){return;}
this.updateName(detail.content);this.publish('namechanged');break;}};AppWindow.prototype._registerEvents=function aw__registerEvents(){if(this.element===null){this._dump();return;}
this.constructor.REGISTERED_EVENTS.forEach(function iterator(evt){this.debug('adding '+evt+' event handler ...');this.element.addEventListener(evt,this);},this);};AppWindow.prototype.handleEvent=function aw_handleEvent(evt){if(this.rearWindow&&evt.type.startsWith('mozbrowser')){evt.stopPropagation();}
this.debug(' Handling '+evt.type+' event...');if(this['_handle_'+evt.type]){this['_handle_'+evt.type](evt);}};AppWindow.prototype._screenshotBlob=undefined;AppWindow.prototype.CLASS_NAME='AppWindow';AppWindow.prototype.debug=function aw_debug(msg){if(DEBUG||this._DEBUG){console.log('['+this.CLASS_NAME+']'+'['+(this.name||this.origin)+']'+'['+this.instanceID+']'+'['+Service.currentTime()+'] '+
Array.slice(arguments).concat());if(TRACE){console.trace();}}else if(window.DUMP){DUMP('['+this.CLASS_NAME+']'+'['+(this.name||this.origin)+']'+'['+this.instanceID+']'+'['+Service.currentTime()+'] '+
Array.slice(arguments).concat());}};AppWindow.prototype.forceDebug=function aw_debug(msg){console.log('[Dump:'+this.CLASS_NAME+']'+'['+(this.name||this.origin)+']'+'['+Service.currentTime()+']'+
Array.slice(arguments).concat());};AppWindow.prototype.show=function aw_show(){if(!this.element||!this.element.classList.contains('hidden')){return;}
this.element.classList.remove('hidden');this.publish('shown');};AppWindow.prototype.hide=function aw_hide(){if(!this.element||this.element.classList.contains('hidden')){return;}
this.debug('hidden the entire app window.');this.element.classList.add('hidden');this.publish('hidden');};AppWindow.prototype.queueShow=function aw_queueShow(){this.element.classList.add('will-become-active');this.publish('will-become-active');};AppWindow.prototype.cancelQueuedShow=function aw_cancelQueuedShow(){this.element.classList.remove('will-become-active');};AppWindow.prototype.queueHide=function aw_queueHide(){this.element.classList.add('will-become-inactive');this.publish('will-become-inactive');};AppWindow.prototype.tryWaitForFullRepaint=function onTWFRepaint(callback){if(!callback){return;}
if(this.isHomescreen){setTimeout(callback);return;}
this.debug('trying wait for full repaint by screenshot enforcing..');this.getScreenshot(function(){setTimeout(callback);},1,1,400);};AppWindow.prototype.requestScreenshotURL=function aw__requestScreenshotURL(){if(this.frontWindow){return this.frontWindow.requestScreenshotURL();}
if(!this._screenshotBlob){this.debug('requestScreenshotURL, no _screenshotBlob');return null;}
var screenshotURL=URL.createObjectURL(this._screenshotBlob);setTimeout(function onTimeout(){if(screenshotURL){URL.revokeObjectURL(screenshotURL);screenshotURL=null;}},200);return screenshotURL;};AppWindow.prototype._showScreenshotOverlay=function aw__showScreenshotOverlay(){if(this.frontWindow&&this.frontWindow.isActive()){return this.frontWindow._showScreenshotOverlay();}
if(!this.screenshotOverlay||this.screenshotOverlay.classList.contains('visible')){return Promise.resolve();}
if(this.identificationOverlay){this.element.classList.add('overlay');}
this.screenshotOverlay.classList.add('visible');var screenshotURL=this.requestScreenshotURL();var promise=new Promise((resolve)=>{var image=document.createElement('img');image.onload=function(){resolve();}.bind(this);image.src=screenshotURL;});this.screenshotOverlay.style.backgroundImage=screenshotURL?'url('+screenshotURL+')':'none';this.element.classList.toggle('no-screenshot',!screenshotURL);return promise;};AppWindow.prototype._hideScreenshotOverlay=function aw__hideScreenshotOverlay(){if(this.frontWindow&&this.frontWindow.isActive()){this.frontWindow._hideScreenshotOverlay();}
if(!this.screenshotOverlay||!this.screenshotOverlay.classList.contains('visible')){return;}
this.screenshotOverlay.classList.remove('visible');this.screenshotOverlay.style.backgroundImage='';this.element.classList.remove('no-screenshot');if(this.identificationOverlay){var element=this.element;setTimeout(function nextTick(){element.classList.remove('overlay');});}};AppWindow.prototype.getCachedScreenshotBlob=function aw_getCachedScreenshotBlob(){return this._screenshotBlob;};AppWindow.prototype.renewCachedScreenshotBlob=function aw_renewScreenshot(screenshotBlob){this._screenshotBlob=screenshotBlob;};AppWindow.prototype.eventPrefix='app';AppWindow.prototype.publish=function(event,detail){this.broadcast(event,detail);var evt=new CustomEvent(this.eventPrefix+event,{bubbles:true,detail:detail||this});this.debug('publishing external event: '+event+
(detail?JSON.stringify(detail):''));if(this.rearWindow&&this.element){this.element.dispatchEvent(evt);}else{window.dispatchEvent(evt);}
window.dispatchEvent(new CustomEvent('window'+event,{bubbles:true,detail:this}));};AppWindow.prototype.broadcast=function aw_broadcast(event,detail){if(this.element){var internalEvent=new CustomEvent('_'+event,{bubbles:false,detail:detail||this});this.debug('publishing internal event: '+event);this.element.dispatchEvent(internalEvent);}};var OrientationRotationArray=['portrait-primary','portrait-secondary','portrait','landscape-primary','landscape-secondary','landscape','default'];var OrientationRotationTable={'portrait-primary':[0,180,0,90,270,90,OrientationManager.isDefaultPortrait()?0:90],'landscape-primary':[270,90,270,0,180,0,OrientationManager.isDefaultPortrait()?270:0],'portrait-secondary':[180,0,180,270,90,270,OrientationManager.isDefaultPortrait()?180:270],'landscape-secondary':[90,270,90,180,0,180,OrientationManager.isDefaultPortrait()?180:90]};AppWindow.prototype.determineRotationDegree=function aw__determineRotationDegree(){if(!this.manifest){return 0;}
var appOrientation=this.manifest.orientation;var orientation=this.determineOrientation(appOrientation);var table=OrientationRotationTable[OrientationManager.defaultOrientation];var degree=table[OrientationRotationArray.indexOf(orientation)];this.rotatingDegree=degree;if(degree==90||degree==270){this.element.classList.add('perpendicular');}
return degree;};AppWindow.prototype.determineClosingRotationDegree=function aw__determineClosingRotationDegree(){if(!this.manifest){return 0;}
var homeOrientation=OrientationManager.defaultOrientation;var currentOrientation=OrientationManager.fetchCurrentOrientation();this.debug(currentOrientation);var table=OrientationRotationTable[homeOrientation];var degree=table[OrientationRotationArray.indexOf(currentOrientation)];return Math.abs(360-degree)%360;};AppWindow.prototype.isFullScreen=function aw_isFullScreen(){if(typeof(this._fullScreen)!=='undefined'){return this._fullScreen;}
this._fullScreen=!!(this.manifest&&('fullscreen'in this.manifest?this.manifest.fullscreen:false))||this.isFullScreenLayout();return this._fullScreen;};AppWindow.prototype.isFullScreenLayout=function aw_isFullScreenLayout(){if(typeof(this._fullScreenLayout)!=='undefined'){return this._fullScreenLayout;}
this._fullScreenLayout=!!(this.manifest&&('fullscreen_layout'in this.manifest?this.manifest.fullscreen_layout:false));return this._fullScreenLayout;};AppWindow.prototype._defaultOrientation=null;AppWindow.prototype.determineOrientation=function aw_determineOrientation(orientation){if(this._defaultOrientation){return this._defaultOrientation;}else if(!orientation){this._defaultOrientation='default';return this._defaultOrientation;}
if(!Array.isArray(orientation)){orientation=[orientation];}
this._defaultOrientation=orientation[0];return this._defaultOrientation;};AppWindow.prototype._resize=function aw__resize(ignoreKeyboard){var height,width;this.debug('force RESIZE...');if(!ignoreKeyboard&&layoutManager.keyboardEnabled){this.broadcast('withkeyboard');}else{this.broadcast('withoutkeyboard');}
height=layoutManager.getHeightFor(this,ignoreKeyboard);width=layoutManager.width;if(this.element.style.width===width+'px'&&this.element.style.height===height+'px'){return;}
this.width=width;this.height=height;this.element.style.width=width+'px';this.element.style.height=height+'px';this.reviveBrowser();this.resized=true;if(this.screenshotOverlay){this.screenshotOverlay.style.visibility='';}
if(this.modalDialog&&this.modalDialog.isVisible()){this.modalDialog.updateMaxHeight();}
this.publish('resize');this.debug('W:',width,'H:',height);};AppWindow.prototype.resize=function aw_resize(){if(this.isDead()){return;}
this.debug('request RESIZE...active? ',this.isActive());var bottom=this.getBottomMostWindow();if(!bottom.shouldResize()||this.isTransitioning()){return;}
if(this.frontWindow){this._resize();this.frontWindow.resize();}else{this.debug(' will resize... ');this._resize();}};AppWindow.prototype.getTopMostWindow=function(){var win=this;while(win.frontWindow){win=win.frontWindow;}
return win;};AppWindow.prototype.getBottomMostWindow=function(){var win=this;while(win.rearWindow){win=win.rearWindow;}
return win;};AppWindow.prototype.lockOrientation=function(){var manifest=this.manifest||this.config.manifest;var orientation=manifest?(manifest.orientation||OrientationManager.globalOrientation):OrientationManager.globalOrientation;if(orientation){var rv=screen.mozLockOrientation(orientation);if(rv===false){console.warn('screen.mozLockOrientation() returned false for',this.origin,'orientation',orientation);}else{this.debug(' locking screen orientation to '+orientation);}}else{screen.mozUnlockOrientation();this.debug(' Unlocking screen orientation..');}};AppWindow.prototype.setOrientation=function aw_setOrientation(){if(!this.getBottomMostWindow().isActive()){return;}
if(this.frontWindow&&this.frontWindow.isActive()){this.frontWindow.setOrientation();}else{this.lockOrientation();}};AppWindow.prototype.fadeOut=function aw__fadeout(){if(!this.isActive()&&this.element){this.element.classList.add('fadeout');this.debug(' fade out >>>> ');}};AppWindow.prototype.fadeIn=function aw__fadein(){if(this.isActive()){this.element.classList.remove('fadeout');this.debug(' fade in <<<<< ');}};AppWindow.prototype.setCalleeWindow=function aw_setCalleeWindow(callee){this.calleeWindow=callee;callee.callerWindow=this;};AppWindow.prototype.unsetCalleeWindow=function aw_unsetCalleeWindow(){if(this.calleeWindow.callerWindow){this.calleeWindow.callerWindow=null;}
this.calleeWindow=null;};AppWindow.prototype.unsetAttentionWindow=function aw_unsetAttentionWindow(){this.attentionWindow=null;};AppWindow.prototype._changeState=function aw__changeState(type,state){if(this.element){this.element.setAttribute(type+'-state',state.toString());}};AppWindow.addMixin=function AW_addMixin(mixin){for(var prop in mixin){if(mixin.hasOwnProperty(prop)){if(!this.prototype.hasOwnProperty(prop)){this.prototype[prop]=mixin[prop];}}}};AppWindow.prototype.preloadSplash=function aw_preloadSplash(){if(this._splash||this.config.icon){if(this.config.icon){this._splash=this.config.icon;}else{var url=this.config.origin.split('/');var origin=url[0]+'//'+url[2];this._splash=origin+this._splash;}
var img=new Image();img.src=this._splash;}};AppWindow.prototype.SPLASH_ICON_SIZE_TINY=60;AppWindow.prototype.SPLASH_ICON_SIZE_NOT_TINY=90;AppWindow.prototype.getIconForSplash=function aw_getIconForSplash(manifest){if(this.isPrivate){var privateIconPath='/style/icons/pb_icon.png';this._splash=privateIconPath;this.preloadSplash();return privateIconPath;}
var icons=this.manifest?('icons'in this.manifest?this.manifest.icons:null):null;if(!icons){return null;}
var targetedPixelSize=2*(ScreenLayout.getCurrentLayout('tiny')?this.SPLASH_ICON_SIZE_TINY:this.SPLASH_ICON_SIZE_NOT_TINY)*Math.ceil(window.devicePixelRatio||1);var preferredSize=Number.MAX_VALUE;var max=0;for(var size in icons){size=parseInt(size,10);if(size>max){max=size;}
if(size>=targetedPixelSize&&size<preferredSize){preferredSize=size;}}
if(preferredSize===Number.MAX_VALUE){preferredSize=max;}
this._splash=icons[preferredSize];this.preloadSplash();return icons[preferredSize];};AppWindow.prototype.setFrameBackground=function aw_setFrameBackground(){if(!this.isHomescreen&&!this.loaded&&!this.splashed&&this.element){if(this._splash){this.splashed=true;this.element.style.backgroundImage='url("'+this._splash+'")';var iconCSSSize=2*(ScreenLayout.getCurrentLayout('tiny')?this.SPLASH_ICON_SIZE_TINY:this.SPLASH_ICON_SIZE_NOT_TINY);this.element.style.backgroundSize=iconCSSSize+'px '+iconCSSSize+'px';if(this.identificationIcon){this.identificationIcon.style.backgroundImage='url("'+this._splash+'")';}}
if(this.identificationTitle){this.identificationTitle.textContent=this.name;}}};AppWindow.prototype.requestOpen=function aw_requestOpen(){this.publish('requestopen');};AppWindow.prototype.requestClose=function aw_requestClose(){this.publish('requestclose');};AppWindow.prototype.modifyURLatBackground=function aw_changeURL(url){if(!this.isActive()){var iframe=this.browser.element;if(iframe.src!==url){iframe.src=url;}}};AppWindow.prototype.ready=function aw_ready(callback){if(!this.element){return;}
if(this._screenshotBlob){this._showScreenshotOverlay();}
this.debug('requesting to open');if(!this.loaded||(this.screenshotOverlay&&this.screenshotOverlay.classList.contains('visible'))){this.debug('loaded yet');setTimeout(callback);return;}else{var invoked=false;this.waitForNextPaint(function(){if(invoked){return;}
invoked=true;setTimeout(callback);});if(this.isHomescreen){this.setVisible(true);return;}
this.tryWaitForFullRepaint(function(){if(invoked){return;}
invoked=true;setTimeout(callback);});}};AppWindow.prototype.open=function aw_open(animation){if(this.transitionController){this.transitionController.requireOpen(animation);}};AppWindow.prototype.close=function aw_close(animation){if(this.transitionController){this.transitionController.requireClose(animation);}};AppWindow.prototype._handle__swipein=function aw_swipein(){this.reviveBrowser();if(this.transitionController){this.transitionController.switchTransitionState('opened');this.publish('opened');}};AppWindow.prototype._handle__swipeout=function aw_swipeout(){if(this.transitionController){this.transitionController.switchTransitionState('closed');this.publish('closed');}};AppWindow.prototype._handle__sheetdisplayed=function aw_sheetdisplayed(){if(this.isActive()){this.debug('no screenshot for active app during sheetdisplayed');return;}
this.debug('showing screenshot during sheetdisplayed');this._showScreenshotOverlay();};AppWindow.prototype._handle__sheetsgestureend=function aw_sgend(){this.debug('hiding screenshot on sheetsgestureend');this._hideScreenshotOverlay();};AppWindow.prototype._handle__cardviewbeforeshow=function aw_cvbeforeshow(){this.debug('showing screenshot for cardsview.');this._showScreenshotOverlay();};AppWindow.prototype._handle__cardviewshown=function aw_cvshown(){if(this.element&&this.element.classList.contains('no-screenshot')&&this._screenshotBlob){this.element.classList.remove('no-screenshot');}};AppWindow.prototype._handle__cardviewclosed=function aw_cvclosed(){this.debug('hiding screenshot after cardsview closed.');this._hideScreenshotOverlay();};AppWindow.prototype._handle__closed=function aw_closed(){if(!this.loaded||(Service.isBusyLoading()&&this.getBottomMostWindow().isHomescreen)){return;}
this.getScreenshot();};AppWindow.prototype._handle__kill_suspended=function aw(){if(this.suspended){this.kill();}};AppWindow.prototype._handle__shrinkingstart=function aw_shrinkingstart(){this.broadcast('blur');this.getScreenshot(()=>{this._showScreenshotOverlay().then(()=>{this.setVisible(false);});});};AppWindow.prototype._handle__shrinkingstop=function aw_shrinkingstop(){this.setVisible(true);this.broadcast('focus');};AppWindow.prototype.setNextWindow=function aw_setNextWindow(nextWindow){if(this.nextWindow){console.warn('There is already alive child window, killing...',this.nextWindow.instanceID);this.nextWindow.kill();}
this.nextWindow=nextWindow;};AppWindow.prototype.unsetNextWindow=function aw_unsetNextWindow(){if(this.nextWindow){this.nextWindow=null;}};AppWindow.prototype.setFrontWindow=function aw_setFrontWindow(frontWindow){if(this.frontWindow){console.warn('There is already alive child window, killing...',this.frontWindow.instanceID);this.frontWindow.kill();}
this.frontWindow=frontWindow;};AppWindow.prototype.unsetFrontWindow=function aw_unsetFrontWindow(){if(this.frontWindow){this.frontWindow=null;}};AppWindow.prototype.getPrev=function(){var current=this.getActiveWindow();if(current){return current.previousWindow;}else{return null;}};AppWindow.prototype.getNext=function(){var current=this.getActiveWindow();if(current){return current.nextWindow;}else{return null;}};AppWindow.prototype.getActiveWindow=function(){var app=this;while(app){if(app.isActive()){return app;}
app=app.nextWindow;}
return null;};AppWindow.prototype.getRootWindow=function(){var app=this;while(app.previousWindow){app=app.previousWindow;}
return app;};AppWindow.prototype.getLeafWindow=function(){var app=this;while(app.nextWindow){app=app.nextWindow;}
return app;};AppWindow.prototype.getFrameForScreenshot=function(){var top=this.getTopMostWindow();return top.browser?top.browser.element:null;};AppWindow.prototype.isVisible=function(){var bottomMostWindow=this.getBottomMostWindow();return bottomMostWindow.isActive()&&this.isActive();};AppWindow.prototype.enterTaskManager=function aw_enterTaskManager(){this._dirtyStyleProperties={};if(this.element&&this.transitionController){this.element.classList.add('in-task-manager');this.close(this.isActive()?'to-cardview':'immediate');}};AppWindow.prototype.leaveTaskManager=function aw_leaveTaskManager(){if(this.element){this.element.classList.remove('in-task-manager');if(this._dirtyStyleProperties){this.unapplyStyle(this._dirtyStyleProperties);this._dirtyStyleProperties=null;}}};AppWindow.prototype.transform=function(nameValues){var strFunctions=Object.keys(nameValues).map(function(key){return key+'('+nameValues[key]+')';},this).join(' ');this.applyStyle({MozTransform:strFunctions});};AppWindow.prototype.applyStyle=function(nameValues){var dirty=this._dirtyStyleProperties||(this._dirtyStyleProperties={});var style=this.element.style;for(var property in nameValues){if(undefined===nameValues[property]){delete style[[property]];}else{style[property]=nameValues[property];}
dirty[property]=true;}};AppWindow.prototype.unapplyStyle=function(nameValues){var style=this.element.style;for(var pname in nameValues){style[pname]='';delete style[pname];}};AppWindow.prototype.showDefaultContextMenu=function(){if(this.contextmenu){this.contextmenu.showDefaultMenu();}};AppWindow.prototype.hideContextMenu=function(){if(this.contextmenu){this.contextmenu.hide();}};AppWindow.prototype._handle__blur=function(){var win=this;while(win.frontWindow&&win.frontWindow.isActive()){win=win.frontWindow;}
win.blur();};AppWindow.prototype._handle__focus=function(){var win=this;while(win.frontWindow&&win.frontWindow.isActive()){win=win.frontWindow;}
win.focus();};AppWindow.prototype.requestForeground=function aw_requestForeground(){this.publish('requestforeground');};AppWindow.prototype.killable=function(){if(this.attentionWindow||this.isHomescreen){return false;}else{return true;}};AppWindow.prototype.hasPermission=function aw_hasPermission(name){if(typeof(this._hasPermission)!=='undefined'&&this._hasPermission[name]){return this._hasPermission[name];}
var mozPerms=navigator.mozPermissionSettings;if(!mozPerms||!this.manifestURL){return false;}
var value=mozPerms.get(name,this.manifestURL,this.origin,false);if(!this._hasPermission){this._hasPermission={};}
this._hasPermission[name]=(value==='allow');return this._hasPermission[name];};AppWindow.prototype.isHidden=function(){return!this.element||this.element.classList.contains('hidden');};AppWindow.prototype._handle__hidewindow=function(evt){var attention=evt.detail;if(attention.parentWindow&&attention.parentWindow.instanceID===this.instanceID){return;}
if(!this.isActive()){return;}
this.setVisible(false);};AppWindow.prototype._sslState='';AppWindow.prototype._handle_mozbrowsersecuritychange=function aw__handle_mozbrowsersecuritychange(evt){var state=this._sslState=evt.detail.state;this.publish('securitychange',state);};AppWindow.prototype.getSSLState=function(){return this._sslState;};AppWindow.prototype.handleStatusbarTouch=function(evt,barHeight){if(this.statusbar){this.statusbar.handleStatusbarTouch(evt,barHeight);}};exports.AppWindow=AppWindow;}(window));;'use strict';(function(exports){var PopupWindow=function(configs){if(configs&&configs.rearWindow){this.containerElement=configs.rearWindow.element;}
configs.chrome={bar:true};AppWindow.call(this,configs);if(!this.rearWindow){return;}
this.themeColor=this.rearWindow.themeColor;if(this.rearWindow.appChrome){this.element.classList.toggle('light',this.rearWindow.appChrome.useLightTheming());this.statusbar.titleBar.style.backgroundColor=this.rearWindow.appChrome.element.style.backgroundColor;}};PopupWindow.prototype=Object.create(AppWindow.prototype);PopupWindow.REGISTERED_EVENTS=['mozbrowserclose','mozbrowsererror','mozbrowservisibilitychange','mozbrowserloadend','mozbrowseractivitydone','mozbrowserloadstart','mozbrowsertitlechange','mozbrowserlocationchange','mozbrowsericonchange'];PopupWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'modalDialog':window.AppModalDialog,'valueSelector':window.ValueSelector,'authDialog':window.AppAuthenticationDialog,'contextmenu':window.BrowserContextMenu,'childWindowFactory':window.ChildWindowFactory,'statusbar':window.AppStatusbar};PopupWindow.prototype.eventPrefix='popup';PopupWindow.prototype.openAnimation='slide-from-bottom';PopupWindow.prototype.closeAnimation='slide-to-bottom';PopupWindow.prototype.CLASS_LIST='appWindow popupWindow';PopupWindow.prototype._DEBUG=false;PopupWindow.prototype.CLASS_NAME='PopupWindow';PopupWindow.prototype.requestOpen=function(){this.open();};PopupWindow.prototype.requestClose=function(){this.close();};exports.PopupWindow=PopupWindow;})(window);;'use strict';(function(window){window.BrowserMixin={reload:function bm_reload(){if(this.browser.element){this.browser.element.reload();}},NEXTPAINT_TIMEOUT:500,waitForNextPaint:function bm_waitForNextPaint(callback){if(!this.browser||!this.browser.element){if(callback){callback();}
return;}
var iframe=this.browser.element;var nextPaintTimer;var self=this;var onNextPaint=function aw_onNextPaint(){self.debug(' nextpainted.');iframe.removeNextPaintListener(onNextPaint);clearTimeout(nextPaintTimer);callback();};nextPaintTimer=setTimeout(function ifNextPaintIsTooLate(){self.debug(' nextpaint is timeouted.');iframe.removeNextPaintListener(onNextPaint);callback();},this.NEXTPAINT_TIMEOUT);iframe.addNextPaintListener(onNextPaint);},setNFCFocus:function(enable){if(!this.browser||!this.browser.element||this._nfcActive===enable||(this.CLASS_NAME!=='AppWindow'&&this.CLASS_NAME!=='ActivityWindow'&&this.CLASS_NAME!=='PopupWindow')&&this.CLASS_NAME!=='HomescreenWindow'){return;}
this.debug(this.name+':'+this.instanceID+' is setting nfc active to: '+enable);try{this._nfcActive=enable;this.browser.element.setNFCFocus(enable);}catch(err){this.debug('set nfc active is not implemented');}},getScreenshot:function bm_getScreenshot(callback,width,height,timeout,ignoreFront){if(!this.browser||!this.browser.element){if(callback){callback();}
return;}
var self=this;var invoked=false;var timer;ignoreFront=(typeof ignoreFront==='undefined')?false:ignoreFront;if(!ignoreFront&&this.frontWindow){this.frontWindow.getScreenshot(callback,width,height,timeout);return;}
if(timeout){timer=window.setTimeout(function(){if(invoked){return;}
self.debug('getScreenshot timeout!');invoked=true;callback();},timeout);}
var type=this.isHomescreen?'image/png':'image/jpeg';var req=this.iframe.getScreenshot(width||this.width||layoutManager.width,height||this.height||layoutManager.height,type);var success=function(result){if(!width){self._screenshotBlob=result;}
self.debug('getScreenshot succeed!');if(invoked){return;}
self.debug('get screenshot success!!!!');invoked=true;if(timer){window.clearTimeout(timer);}
if(callback){callback(result);}};var error=function(){self.debug('getScreenshot failed!');if(invoked){return;}
invoked=true;if(timer){window.clearTimeout(timer);}
if(callback){callback();}};if(req.then){req.then(success,error);}else{req.onsuccess=function(evt){success(evt.target.result);};req.onerror=error;}},focus:function bm_focus(){if(this.browser&&this.browser.element&&!(this.contextmenu&&this.contextmenu.isShown())){this.browser.element.focus();}},blur:function bm_blur(){if(this.browser.element){this.browser.element.blur();}},back:function bm_back(){if(this.browser.element){this.browser.element.goBack();}},forward:function bm_forward(){if(this.browser.element){this.browser.element.goForward();}},stop:function bm_stop(){if(this.browser.element){this.browser.element.stop();}},_setVisible:function bm__setVisible(visible){if(this.browser&&this.browser.element&&'setVisible'in this.browser.element){this.debug('setVisible on browser element:'+visible);this.browser.element.setVisible(visible);}},_setActive:function bm__setActive(active){if(this.browser&&this.browser.element&&'setActive'in this.browser.element){this.debug('setActive on browser element:'+active);this.browser.element.setActive(active);var topMostUI=Service.query('getTopMostUI');}},_setVisibleForScreenReader:function bm__setVisibleForScreenReader(visible){if(this.browser&&this.browser.element){this.debug('aria-hidden on browser element:'+!visible);this.browser.element.setAttribute('aria-hidden',!visible);}},canGoBack:function bm_cangoback(callback){var self=this;if(this.browser.element){var r=this.browser.element.getCanGoBack();var success=function(result){self._backable=result;if(callback){callback(result);}};var error=function(){if(callback){callback();}};if(r.then){r.then(success,error);}else{r.onsuccess=function(evt){success(evt.target.result);};r.onerror=error;}}else{if(callback){callback();}}},canGoForward:function bm_cangoforward(callback){var self=this;if(this.browser.element){var r=this.browser.element.getCanGoForward();var success=function(result){self._forwardable=result;if(callback){callback(result);}};var error=function(){if(callback){callback();}};if(r.then){r.then(success,error);}else{r.onsuccess=function(evt){success(evt.target.result);};r.onerror=error;}}else{if(callback)
callback();}},isOOP:function bm_isOOP(){return(this.browser_config&&this.browser_config.oop);}};AppWindow.addMixin(BrowserMixin);}(this));;'use strict';(function(window){var WrapperFactory={init:function wf_init(){window.addEventListener('mozbrowseropenwindow',this,true);},uninit:function(){window.removeEventListener('mozbrowseropenwindow',this,true);},isLaunchingWindow:function(){return!!this._launchingApp;},forgetLastLaunchingWindow:function(){if(this._launchingApp&&this._launchingApp.element){this._launchingApp.element.removeEventListener('_opened',this);this._launchingApp.element.removeEventListener('_terminated',this);}
this._launchingApp=null;},handleEvent:function wf_handleEvent(evt){if(evt.type==='_opened'||evt.type==='_terminated'){if(this._launchingApp===evt.detail){this.forgetLastLaunchingWindow();}
return;}
var detail=evt.detail;if(typeof detail.features!=='string'){return;}
var features=detail.features.split(',').reduce(function(acc,feature){feature=feature.split('=').map(function(featureElem){return featureElem.trim();});if(feature.length!==2){return acc;}
acc[decodeURIComponent(feature[0])]=decodeURIComponent(feature[1]);return acc;},{});if(!('remote'in features)||features.remote!=='true'){return;}
var callerOrigin;if(evt.target!==window){var callerIframe=evt.target;var manifestURL=callerIframe.getAttribute('mozapp');var callerApp=applications.getByManifestURL(manifestURL);if(!this.hasPermission(callerApp,'open-remote-window')){return;}
callerOrigin=callerApp.origin;}else{callerOrigin=location.origin;}
evt.stopImmediatePropagation();var name=detail.name;var url=detail.url;var app;var origin=null;if(name=='_blank'){var activeApp=Service.currentApp;var isSearchApp=(activeApp.manifest&&activeApp.manifest.role==='search');if(activeApp&&(activeApp.isBrowser()||isSearchApp)){activeApp.navigate(url);return;}
origin=url;app=appWindowManager.getApp(origin);if(app&&app.windowName=='_blank'){this.publish('launchapp',{origin:origin});}}else{origin='window:'+name+',source:'+callerOrigin;app=appWindowManager.getApp(origin);if(app&&app.windowName===name){if(app.iframe.src===url){this.publish('launchapp',{origin:origin});return;}else{this.publish('killapp',{origin:origin});}}}
var browser_config=this.generateBrowserConfig(features);browser_config.url=url;browser_config.origin=origin;browser_config.windowName=name;if(!browser_config.title){browser_config.title=url;}
this.launchWrapper(browser_config);},launchWrapper:function wf_launchWrapper(config){var app=appWindowManager.getApp(config.origin);if(!app){config.chrome={scrollable:true};this.forgetLastLaunchingWindow();this.trackLauchingWindow(config);}else{app.updateName(config.title);}
this.publish('launchapp',{origin:config.origin});},trackLauchingWindow:function(config){this._launchingApp=new AppWindow(config);this._launchingApp.element.addEventListener('_opened',this);this._launchingApp.element.addEventListener('_terminated',this);},hasPermission:function wf_hasPermission(app,permission){var mozPerms=navigator.mozPermissionSettings;if(!mozPerms){return false;}
var value=mozPerms.get(permission,app.manifestURL,app.origin,false);return(value==='allow');},generateBrowserConfig:function wf_generateBrowserConfig(features){var config={};config.title=features.name;config.icon=features.icon||'';if('originName'in features){config.originName=features.originName;config.originURL=features.originUrl;}
if('searchName'in features){config.searchName=features.searchName;config.searchURL=features.searchUrl;}
if('remote'in features){config.oop=true;}
return config;},publish:function wf_publish(event,detail){var evt=new CustomEvent(event,{detail:detail});window.dispatchEvent(evt);}};window.WrapperFactory=WrapperFactory;WrapperFactory.init();}(window));;'use strict';(function(exports){var HomescreenWindow=function HomescreenWindow(manifestURL){this.instanceID='homescreen';this.setBrowserConfig(manifestURL);this.render();this.publish('created');this.createdTime=this.launchTime=Date.now();return this;};HomescreenWindow.prototype=Object.create(AppWindow.prototype);HomescreenWindow.prototype.constructor=HomescreenWindow;HomescreenWindow.prototype._DEBUG=false;HomescreenWindow.prototype.CLASS_NAME='HomescreenWindow';HomescreenWindow.prototype.setBrowserConfig=function hw_setBrowserConfig(manifestURL){var app=window.applications.getByManifestURL(manifestURL);this.origin=app.origin;this.manifestURL=app.manifestURL;this.url=app.origin+'/index.html#root';this.browser_config=new BrowserConfigHelper({url:this.origin,manifestURL:this.manifestURL});this.name=this.browser_config.name;this.manifest=this.browser_config.manifest;this.browser_config.url=this.url;this.browser_config.isHomescreen=true;this.config=this.browser_config;this.isHomescreen=true;};HomescreenWindow.REGISTERED_EVENTS=AppWindow.REGISTERED_EVENTS;HomescreenWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'modalDialog':window.AppModalDialog,'valueSelector':window.ValueSelector,'authDialog':window.AppAuthenticationDialog,'childWindowFactory':window.ChildWindowFactory,'statusbar':window.AppStatusbar};HomescreenWindow.prototype.openAnimation='zoom-out';HomescreenWindow.prototype.closeAnimation='zoom-in';HomescreenWindow.prototype._handle__opening=function hw__handle__opening(){this.ensure();};HomescreenWindow.prototype._handle_mozbrowserclose=function hw__handle_mozbrowserclose(evt){this.restart();};HomescreenWindow.prototype._handle_mozbrowsererror=function hw__handle_mozbrowsererror(evt){if(evt.detail.type=='fatal'){this.loaded=false;this.publish('crashed');this.restart();}};HomescreenWindow.prototype.restart=function hw_restart(){if(this.isActive()){this.kill();setTimeout(function(){if(this.element){return;}
this.render();this.open();}.bind(this));}else{this.kill();}};HomescreenWindow.prototype.view=function hw_view(){var content=`<div class="appWindow homescreen" id="homescreen">
              <div class="fade-overlay"></div>
              <div class="browser-container"></div>
           </div>`;return content;};HomescreenWindow.prototype.eventPrefix='homescreen';HomescreenWindow.prototype.toggle=function hw_toggle(visible){this.ensure();if(this.browser.element){this.setVisible(visible);}};HomescreenWindow.prototype.ensure=function hw_ensure(reset){this.debug('ensuring homescreen...',this.frontWindow);if(!this.element){this.render();}else if(reset){if(this.frontWindow){this.frontWindow.kill();}else{var urlWithoutHash=this.browser_config.url.split('#')[0];this.browser.element.src=urlWithoutHash+'#'+Date.now();}}
return this.element;};HomescreenWindow.prototype.resize=function aw_resize(){this.debug('request RESIZE...');this.debug(' will resize... ');this._resize();};HomescreenWindow.prototype.hideFadeOverlay=function hw_hideFadeOverlay(){this.fadeOverlay.classList.add('hidden');};HomescreenWindow.prototype.showFadeOverlay=function hw_showFadeOverlay(){this.fadeOverlay.classList.remove('hidden');};exports.HomescreenWindow=HomescreenWindow;}(window));;'use strict';(function(exports){var HomescreenLauncher=function(){};HomescreenLauncher.prototype={_currentManifestURL:'',_instance:undefined,_started:false,_ready:false,get ready(){return this._ready;},get origin(){return'homescreen';},get manifestURL(){return this._currentManifestURL;},_fetchSettings:function hl_fetchSettings(){var that=this;SettingsListener.observe('homescreen.manifestURL','',function onRetrievingHomescreenManifestURL(value){var previousManifestURL=that._currentManifestURL;that._currentManifestURL=value;if(typeof(that._instance)!=='undefined'){if(previousManifestURL!==''&&previousManifestURL!==that._currentManifestURL){that._instance.kill();that._instance=new HomescreenWindow(value);window.dispatchEvent(new CustomEvent('homescreen-changed'));}else{that._instance.ensure();}}
that._ready=true;window.dispatchEvent(new CustomEvent('homescreen-ready'));});},_onAppReady:function hl_onAppReady(){window.removeEventListener('applicationready',this._onAppReady);this._fetchSettings();},start:function hl_start(){if(this._started){return;}
this._started=true;if(applications.ready){this._fetchSettings();}else{window.addEventListener('applicationready',this._onAppReady.bind(this));}
window.addEventListener('trusteduishow',this);window.addEventListener('trusteduihide',this);window.addEventListener('appopening',this);window.addEventListener('appopened',this);window.addEventListener('keyboardchange',this);window.addEventListener('shrinking-start',this);window.addEventListener('shrinking-stop',this);window.addEventListener('software-button-enabled',this);window.addEventListener('software-button-disabled',this);},stop:function hl_stop(){if(typeof(this._instance)!=='undefined'){this._instance.kill();this._instance=undefined;}
this._currentManifestURL='';window.removeEventListener('appopening',this);window.removeEventListener('trusteduihide',this);window.removeEventListener('trusteduishow',this);window.removeEventListener('applicationready',this._onAppReady);window.removeEventListener('shrinking-start',this);window.removeEventListener('shrinking-stop',this);window.removeEventListener('software-button-enabled',this);window.removeEventListener('software-button-disabled',this);this._started=false;},handleEvent:function hl_handleEvent(evt){switch(evt.type){case'trusteduishow':this.getHomescreen(true).toggle(true);this.getHomescreen(true).fadeIn();break;case'trusteduihide':this.getHomescreen().toggle(false);break;case'appopening':if(evt.detail.rotatingDegree===90||evt.detail.rotatingDegree===270){this.getHomescreen().fadeOut();}
break;case'appopened':if(!TrustedUIManager.hasTrustedUI(evt.detail.origin)){this.getHomescreen().fadeOut();}
break;case'keyboardchange':this.getHomescreen().fadeOut();break;case'shrinking-start':this.getHomescreen().hideFadeOverlay();break;case'shrinking-stop':this.getHomescreen().showFadeOverlay();break;case'software-button-enabled':case'software-button-disabled':var homescreen=this.getHomescreen();homescreen&&homescreen.resize();break;}},getHomescreen:function hl_getHomescreen(ensure){if(this._currentManifestURL===''){console.warn('HomescreenLauncher: not ready right now.');return null;}
if(typeof this._instance=='undefined'){this._instance=new HomescreenWindow(this._currentManifestURL);return this._instance;}else{if(ensure){this._instance.ensure();}
return this._instance;}}};exports.HomescreenLauncher=HomescreenLauncher;}(window));;'use strict';(function(exports){function HomescreenWindowManager(){}
HomescreenWindowManager.prototype={DEBUG:false,CLASS_NAME:'HomescreenWindowManager',get ready(){return homescreenLauncher.ready;},debug:function hwm_debug(){if(this.DEBUG){console.log('['+this.CLASS_NAME+']'+'['+Service.currentTime()+']'+
Array.slice(arguments).concat());}},start:function hwm_start(){window.addEventListener('appswitching',this);window.addEventListener('ftuskip',this);window.addEventListener('open-app',this);window.addEventListener('webapps-launch',this);},stop:function hwm_stop(){window.removeEventListener('appswitching',this);window.removeEventListener('ftuskip',this);window.removeEventListener('open-app',this);window.removeEventListener('webapps-launch',this);},handleEvent:function hwm_handleEvent(evt){switch(evt.type){case'appswitching':this.getHomescreen().fadeOut();break;case'ftuskip':if(Service.locked){this.getHomescreen().setVisible(false);}
break;case'open-app':case'webapps-launch':var detail=evt.detail;if(detail.manifestURL===homescreenLauncher.manifestURL){this.getHomescreen();evt.stopImmediatePropagation();}
break;}},getHomescreen:function getHomescreen(isHomeEvent){if(!exports.homescreenLauncher||!exports.homescreenLauncher.ready){return null;}
var home=homescreenLauncher.getHomescreen(true);if(isHomeEvent){home.ensure(true);}
return home;}};exports.HomescreenWindowManager=HomescreenWindowManager;}(window));;'use strict';(function(exports){var _id=0;var ActivityWindow=function ActivityWindow(config,caller){this.config=config;for(var key in config){this[key]=config[key];}
if(caller){caller.setFrontWindow(this);this.rearWindow=caller;if(caller.element){this.containerElement=caller.element;}}
this.publish('creating');this.render();this.publish('created');};ActivityWindow.prototype=Object.create(AppWindow.prototype);ActivityWindow.prototype.constructor=ActivityWindow;ActivityWindow.prototype.eventPrefix='activity';ActivityWindow.prototype.CLASS_NAME='ActivityWindow';ActivityWindow.prototype._DEBUG=false;ActivityWindow.prototype.openAnimation='fade-in';ActivityWindow.prototype.closeAnimation='fade-out';ActivityWindow.prototype.isFullScreen=function acw_isFullScreen(){if(typeof(this._fullscreen)!=='undefined'){return this._fullscreen;}
this._fullscreen=(this.manifest&&!!this.manifest.fullscreen)?!!this.manifest.fullscreen:this.rearWindow?this.rearWindow.isFullScreen():false;return this._fullscreen;};ActivityWindow.prototype.lockOrientation=function acw_lockOrientation(noCapture){if(this.isActive()){var orientation1=(this.manifest)?this.manifest.orientation:null;var orientation2=(this.config.manifest)?this.config.manifest.orientation:null;var orientation3=(this.rearWindow.manifest)?this.rearWindow.manifest.orientation:null;var orientation4=OrientationManager.globalOrientation;var orientation=orientation1||orientation2||orientation3||orientation4;if(orientation){var rv=false;if('lockOrientation'in screen){rv=screen.lockOrientation(orientation);}else if('mozLockOrientation'in screen){rv=screen.mozLockOrientation(orientation);}
if(rv===false){console.warn('screen.mozLockOrientation() returned false for',this.origin,'orientation',orientation);}}else{if('unlockOrientation'in screen){screen.unlockOrientation();}else if('mozUnlockOrientation'in screen){screen.mozUnlockOrientation();}}}};ActivityWindow.prototype.view=function acw_view(){this.instanceID=this.CLASS_NAME+'_'+_id;_id++;return`<div id="${this.instanceID}"
            class="appWindow activityWindow inline-activity">
            <div class="fade-overlay"></div>
            <div class="browser-container">
             <div class="screenshot-overlay"></div>
            </div>
            </div>`;};ActivityWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'modalDialog':window.AppModalDialog,'valueSelector':window.ValueSelector,'authDialog':window.AppAuthenticationDialog,'contextmenu':window.BrowserContextMenu,'childWindowFactory':window.ChildWindowFactory,'statusbar':window.AppStatusbar};ActivityWindow.REGISTERED_EVENTS=AppWindow.REGISTERED_EVENTS;ActivityWindow.prototype._handle_mozbrowseractivitydone=function aw__handle_mozbrowseractivitydone(){this.kill();};ActivityWindow.prototype.render=function acw_render(){this.publish('willrender');this.containerElement.insertAdjacentHTML('beforeend',this.view());this.browser_config={parentApp:this.parentApp,origin:this.origin,url:this.url,name:this.name,manifest:this.manifest,manifestURL:this.manifestURL,window_name:'inline'+this.instanceID,oop:true};this.browser=new BrowserFrame(this.browser_config);this.element=document.getElementById(this.instanceID);this.browserContainer=this.element.querySelector('.browser-container');this.browserContainer.appendChild(this.browser.element);this.frame=this.element;this.iframe=this.browser.element;this.screenshotOverlay=this.element.querySelector('.screenshot-overlay');this.fadeOverlay=this.element.querySelector('.fade-overlay');if(this.isFullScreen()){this.element.classList.add('fullscreen-app');}
this._registerEvents();this.installSubComponents();this.publish('rendered');};ActivityWindow.prototype.containerElement=document.getElementById('windows');ActivityWindow.prototype.requestOpen=function acw_requestOpen(){if(this.rearWindow){this.rearWindow.requestOpen();}};ActivityWindow.prototype.requestClose=function acw_requestOpen(){this.close();};exports.ActivityWindow=ActivityWindow;}(window));;'use strict';(function(exports){function ActivityWindowManager(){}
ActivityWindowManager.prototype={_activities:[],start:function acwf_start(){if(this._started){return;}
this._started=true;this.activityPool=new Map();window.addEventListener('activityopened',this);window.addEventListener('popupopened',this);window.addEventListener('appopened',this);window.addEventListener('activityrequesting',this);window.addEventListener('activitycreated',this);window.addEventListener('activityterminated',this);},stop:function acwf_stop(){if(!this._started){return;}
this._started=false;this.activityPool=null;window.removeEventListener('activityopened',this);window.removeEventListener('popupopened',this);window.removeEventListener('appopened',this);window.removeEventListener('activityrequesting',this);window.removeEventListener('activitycreated',this);window.removeEventListener('activityterminated',this);},activityPool:null,handleEvent:function acwf_handleEvent(evt){switch(evt.type){case'popupopened':case'activityopened':case'appopened':var app=evt.detail;var parent=app.callerWindow||app.bottomWindow||app.previousWindow;if(parent&&this.activityPool.has(parent.instanceID)){this.activityPool.set(app.instanceID,true);}
break;case'popupterminated':case'appterminated':this.activityPool.delete(app.instanceID);break;case'activityrequesting':var caller=Service.currentApp.getTopMostWindow();if(!this.activityPool.size){this.activityPool.set(caller.instanceID,true);}else{if(!this.activityPool.has(caller.instanceID)){this._activities.forEach(function iterator(activity,index){if(!activity.getBottomMostWindow().isActive()||!activity.isActive()){activity.kill();}},this);this.activityPool.clear();this.activityPool.set(caller.instanceID,true);}}
break;case'activityterminated':this._activities.some(function iterator(activity,index){if(activity.instanceID===evt.detail.instanceID){this._activities.splice(index,1);return true;}},this);this.activityPool.delete(evt.detail.instanceID);break;case'activitycreated':this._activities.push(evt.detail);break;}}};exports.ActivityWindowManager=ActivityWindowManager;}(window));;'use strict';(function(exports){function AppWindowFactory(){this.preHandleEvent=this.preHandleEvent.bind(this);}
AppWindowFactory.prototype={_started:false,start:function awf_start(){if(this._started){return;}
this._started=true;window.addEventListener('webapps-launch',this.preHandleEvent);window.addEventListener('webapps-close',this.preHandleEvent);window.addEventListener('open-app',this.preHandleEvent);window.addEventListener('openwindow',this.preHandleEvent);window.addEventListener('appopenwindow',this.preHandleEvent);window.addEventListener('applicationready',(function appReady(e){window.removeEventListener('applicationready',appReady);this._handlePendingEvents();}).bind(this));},stop:function awf_stop(){if(!this._started){return;}
this._started=false;window.removeEventListener('webapps-launch',this.preHandleEvent);window.removeEventListener('webapps-close',this.preHandleEvent);window.removeEventListener('open-app',this.preHandleEvent);window.removeEventListener('openwindow',this.preHandleEvent);window.removeEventListener('appopenwindow',this.preHandleEvent);},_queueEvents:[],_queuePendingEvent:function(evt){this._queueEvents.push(evt);},_handlePendingEvents:function(){this._queueEvents.forEach((function(evt){this.handleEvent(evt);}).bind(this));this._queueEvents=[];},preHandleEvent:function(evt){if(applications.ready){this.handleEvent(evt);}else{this._queuePendingEvent(evt);}},handleEvent:function awf_handleEvent(evt){var detail=evt.detail;if(evt.type==='_opened'||evt.type==='_terminated'){if(this._launchingApp===detail){this.forgetLastLaunchingWindow();}
return;}
if(!detail.url&&!detail.manifestURL){return;}
var config=new BrowserConfigHelper(detail);config.evtType=evt.type;switch(evt.type){case'openwindow':case'appopenwindow':case'webapps-launch':config.timestamp=detail.timestamp;this.launch(config);break;case'open-app':config.isSystemMessage=true;if(detail.isActivity){config.isActivity=true;if(detail.target.disposition&&detail.target.disposition=='inline'){config.inline=true;}}
config.changeURL=!detail.onlyShowApp;config.stayBackground=!detail.showApp;if(detail.extra&&detail.extra.manifestURL){config.parentApp=detail.extra.manifestURL;}
this.launch(config);break;case'webapps-close':this.publish('killapp',config);break;}},launch:function awf_launch(config){if(config.url===window.location.href){return;}
if(config.isActivity&&config.inline){this.publish('launchactivity',config);return;}
if(config.manifest&&config.manifest.role==='search'&&config.url.indexOf('newtab.html')===-1){return;}
var app=window.appWindowManager.getApp(config.origin,config.manifestURL);if(app){if(config.evtType=='appopenwindow'){app.browser.element.src=config.url;}
app.reviveBrowser();}else{this.forgetLastLaunchingWindow();this.trackLauchingWindow(config);}
this.publish('launchapp',config);},trackLauchingWindow:function(config){var app=new AppWindow(config);if(config.stayBackground){return;}
this._launchingApp=app;this._launchingApp.element.addEventListener('_opened',this);this._launchingApp.element.addEventListener('_terminated',this);},forgetLastLaunchingWindow:function(){if(this._launchingApp&&this._launchingApp.element){this._launchingApp.element.removeEventListener('_opened',this);this._launchingApp.element.removeEventListener('_terminated',this);}
this._launchingApp=null;},isLaunchingWindow:function(){return!!this._launchingApp;},publish:function awf_publish(event,detail,scope){scope=scope||window;var evt=document.createEvent('CustomEvent');evt.initCustomEvent(event,true,false,detail);scope.dispatchEvent(evt);}};exports.AppWindowFactory=AppWindowFactory;}(window));;'use strict';(function(exports){var AttentionWindow=function AttentionWindow(config){this.reConfig(config);this.render();if(this._DEBUG){AttentionWindow[this.instanceID]=this;}
this.makeNotification();this.publish('created');};AttentionWindow.prototype=Object.create(AppWindow.prototype);AttentionWindow.prototype.constructor=AttentionWindow;AttentionWindow.prototype.eventPrefix='attention';AttentionWindow.prototype.CLASS_NAME='AttentionWindow';AttentionWindow.prototype.CLASS_LIST='appWindow attentionWindow';AttentionWindow.prototype.HIERARCHY_MANAGER='AttentionWindowManager';AttentionWindow.prototype._DEBUG=false;AttentionWindow.prototype.closedHeight=40;AttentionWindow.prototype.openAnimation='immediate';AttentionWindow.prototype.closeAnimation='immediate';AttentionWindow.prototype.isAttentionWindow=true;AttentionWindow.prototype.view=function attw_view(){this.debug('intance id: '+this.instanceID);return`<div class="${this.CLASS_LIST}" id="${this.instanceID}">
            <div class="browser-container"></div>
            <div class="screenshot-overlay"></div>
            </div>`;};AttentionWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'modalDialog':window.AppModalDialog,'authDialog':window.AppAuthenticationDialog,'attentionToaster':window.AttentionToaster,'stautsbar':window.AppStatusbar};AttentionWindow.REGISTERED_EVENTS=['mozbrowserclose','mozbrowsererror','mozbrowservisibilitychange','mozbrowserloadend','mozbrowserloadstart','_localized','click','_willdestroy','_languagechange'];AttentionWindow.prototype.render=function attw_render(){this.publish('willrender');this.containerElement.insertAdjacentHTML('beforeend',this.view());this.browser={element:this.config.iframe};this.element=document.getElementById(this.instanceID);this.browserContainer=this.element.querySelector('.browser-container');this.browserContainer.insertBefore(this.browser.element,null);this.frame=this.element;this.iframe=this.browser.element;this.screenshotOverlay=this.element.querySelector('.screenshot-overlay');this._registerEvents();this.installSubComponents();this.publish('rendered');};AttentionWindow.prototype._handle_click=function attw__handle_click(evt){this.publish('will-become-active');this.requestOpen();};AttentionWindow.prototype.ready=function attw_ready(callback){if(!this.element){return;}
var self=this;if(!this.loaded){this.element.addEventListener('_loaded',function onLoaded(){self.element.removeEventListener('_loaded',onLoaded);setTimeout(callback);});}else{this.tryWaitForFullRepaint(function(){setTimeout(callback);});}};AttentionWindow.prototype.requestOpen=function(){this.element.classList.remove('fake-notification');this.element.classList.remove('notification-disappearing');AppWindow.prototype.requestOpen.apply(this);};AttentionWindow.prototype.makeNotification=function(){var manifestURL=this.manifestURL;if(this.notification||!manifestURL){return;}
var manifest=applications.getByManifestURL(manifestURL).manifest;this.manifest=this.config.manifest=manifest;var iconSrc=manifestURL.replace('/manifest.webapp',manifest.icons[Object.keys(manifest.icons)[0]]);var notification=document.createElement('div');notification.id='notification-'+this.instanceID;notification.classList.add('notification');notification.classList.add('attention-notification');var icon=document.createElement('img');icon.src=iconSrc;icon.classList.add('icon');notification.appendChild(icon);var message=document.createElement('div');this.notificationTitle=document.createTextNode(manifest.name);message.appendChild(this.notificationTitle);message.classList.add('title-container');notification.appendChild(message);var tip=document.createElement('div');tip.setAttribute('data-l10n-id','attentionScreen-tapToShow');tip.classList.add('detail');notification.appendChild(tip);var container=document.getElementById('attention-window-notifications-container');container.insertBefore(notification,null);notification.addEventListener('click',function(evt){this._handle_click(evt);}.bind(this));this.notification=notification;this.notification.style.display='none';this.translateNotification();};AttentionWindow.prototype.translateNotification=function(){if(!this.notification){return;}
var manifest=this.manifest;var title=this.notificationTitle;navigator.mozL10n.once(function(){var helper=new ManifestHelper(manifest);title.textContent=helper.name;});};AttentionWindow.prototype.show=function(){if(this.notification){this.translateNotification();this.notification.style.display='block';}
this._resize();this.element.style.width='';AppWindow.prototype.show.call(this);};AttentionWindow.prototype.hide=function(){if(this.notification){this.notification.style.display='none';}
AppWindow.prototype.hide.call(this);};AttentionWindow.prototype._handle__willdestroy=function(){if(this.notification){this.notification.parentNode.removeChild(this.notification);this.notification=null;}};AttentionWindow.prototype._handle__languagechange=function(){this.translateNotification();};AttentionWindow.prototype.promote=function(){this.element&&this.element.classList.add('top-most');};AttentionWindow.prototype.demote=function(){this.element&&this.element.classList.remove('top-most');};AttentionWindow.prototype.containerElement=document.getElementById('windows');exports.AttentionWindow=AttentionWindow;}(window));;'use strict';(function(exports){var GlobalOverlayWindow=function GlobalOverlayWindow(config){this.reConfig(config);this.render();if(this._DEBUG){GlobalOverlayWindow[this.instanceID]=this;}
this.publish('created');};GlobalOverlayWindow.prototype=Object.create(AppWindow.prototype);GlobalOverlayWindow.prototype.constructor=GlobalOverlayWindow;GlobalOverlayWindow.prototype.eventPrefix='globaloverlay';GlobalOverlayWindow.prototype.CLASS_NAME='GlobalOverlayWindow';GlobalOverlayWindow.prototype.CLASS_LIST='appWindow globalOverlayWindow';GlobalOverlayWindow.prototype.HIERARCHY_MANAGER='GlobalOverlayWindowManager';GlobalOverlayWindow.prototype._DEBUG=false;GlobalOverlayWindow.prototype.openAnimation='immediate';GlobalOverlayWindow.prototype.closeAnimation='immediate';GlobalOverlayWindow.prototype.view=function ow_view(){this.debug('intance id: '+this.instanceID);return'<div class="'+this.CLASS_LIST+'"   id="'+this.instanceID+'">'+'<button id="'+this.instanceID+'-close" '+'class="close-global-overlay">Close</button>'+'<div class="browser-container"></div>'+'</div>';};GlobalOverlayWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'modalDialog':window.AppModalDialog};GlobalOverlayWindow.REGISTERED_EVENTS=['mozbrowserclose','mozbrowsererror','mozbrowservisibilitychange','mozbrowserloadend','mozbrowserloadstart','_localized','_willdestroy'];GlobalOverlayWindow.prototype.render=function ow_render(){this.publish('willrender');this.containerElement.insertAdjacentHTML('beforeend',this.view());this.browser={element:this.config.iframe};this.element=document.getElementById(this.instanceID);this.browserContainer=this.element.querySelector('.browser-container');this.browserContainer.insertBefore(this.browser.element,null);this.frame=this.element;this.iframe=this.browser.element;this.registerEvents();this.installSubComponents();this.publish('rendered');};GlobalOverlayWindow.prototype.registerEvents=function ow_registerEvents(){var self=this;document.getElementById(this.instanceID+'-close').addEventListener('click',function(){self.kill();});GlobalOverlayWindow.prototype._registerEvents.apply(this);};GlobalOverlayWindow.prototype.ready=function ow_ready(callback){if(!this.element){return;}
var self=this;if(!this.loaded){this.element.addEventListener('_loaded',function onLoaded(){self.element.removeEventListener('_loaded',onLoaded);self.browser.element.setAttribute('mozpasspointerevents','true');setTimeout(callback);});}else{this.tryWaitForFullRepaint(function(){setTimeout(callback);});}};GlobalOverlayWindow.prototype.containerElement=document.getElementById('global-overlays');exports.GlobalOverlayWindow=GlobalOverlayWindow;})(window);;'use strict';(function(exports){var CSORIGIN=window.location.origin.replace('system','callscreen')+'/';var CallscreenWindow=function CallscreenWindow(){this.config={manifestURL:CSORIGIN+'manifest.webapp',url:CSORIGIN+'index.html',origin:CSORIGIN};this.isCallscreenWindow=true;this.reConfig(this.config);this.render();if(this._DEBUG){CallscreenWindow[this.instanceID]=this;}
this.publish('created');};CallscreenWindow.prototype=Object.create(AttentionWindow.prototype);CallscreenWindow.prototype.constructor=CallscreenWindow;CallscreenWindow.prototype._DEBUG=false;CallscreenWindow.prototype.CLASS_LIST='appWindow attentionWindow callscreenWindow';CallscreenWindow.prototype.CLASS_NAME='CallscreenWindow';CallscreenWindow.prototype.openAnimation='slide-from-top';CallscreenWindow.prototype.closeAnimation='slide-to-top';CallscreenWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'attentionToaster':window.AttentionToaster};CallscreenWindow.REGISTERED_EVENTS=AttentionWindow.REGISTERED_EVENTS;CallscreenWindow.prototype.render=function cw_render(){this.publish('willrender');this.containerElement.insertAdjacentHTML('beforeend',this.view());this.element=document.getElementById(this.instanceID);var iframe=document.createElement('iframe');iframe.setAttribute('name','call_screen');iframe.setAttribute('mozbrowser','true');iframe.setAttribute('remote','false');iframe.setAttribute('mozapp',this.config.manifestURL);iframe.src=this.config.url;this.browser={element:iframe};this.browserContainer=this.element.querySelector('.browser-container');this.browserContainer.insertBefore(this.browser.element,null);this.frame=this.element;this.iframe=this.browser.element;this.screenshotOverlay=this.element.querySelector('.screenshot-overlay');this._registerEvents();this.installSubComponents();this.publish('rendered');};CallscreenWindow.prototype.ensure=function(){if(!this.browser||!this.browser.element){return;}
var timestamp=new Date().getTime();var src=this.config.url+'#'+
(Service.locked?'locked':'');src=src+'&timestamp='+timestamp;this.browser.element.src=src;this._terminated=false;this.show();};CallscreenWindow.prototype._handle_mozbrowserclose=function(){if(this._terminated){return;}
this._terminated=true;this.publish('terminated');if(this.isActive()){var self=this;this.element.addEventListener('_closed',function onclosed(){self.element.removeEventListener('_closed',onclosed);self.hide();self.reloadWindow();});this.requestClose();}else{this.hide();this.reloadWindow();}
if(document.activeElement===this.browser.element){document.activeElement.blur();}};CallscreenWindow.prototype.reloadWindow=function(){var src=this.browser.element.src.split('#')[0];this.browser.element.src='';setTimeout(function nextTick(){this.browser.element.src=src;}.bind(this));this.setVisible(false);};CallscreenWindow.prototype.free=function(){if(this.browser.element){this.browser.element.src='';}};exports.CallscreenWindow=CallscreenWindow;}(window));;'use strict';(function(exports){var DialerAgent=function DialerAgent(){var telephony=navigator.mozTelephony;if(!telephony){return;}
this._telephony=telephony;this._started=false;this._shouldRing=null;this._shouldVibrate=true;this._alerting=false;this._vibrateInterval=null;var player=new Audio();this._player=player;player.mozAudioChannelType='ringer';player.preload='metadata';player.loop=true;this.freeCallscreenWindow=this.freeCallscreenWindow.bind(this);this.makeFakeNotification=this.makeFakeNotification.bind(this);};DialerAgent.prototype.freeCallscreenWindow=function(){var numOpenLines=this._telephony.calls.length+
(this._telephony.conferenceGroup.calls.length?1:0);if(this._callscreenWindow&&(numOpenLines===0)&&!this._callscreenWindow.isVisible()){this._callscreenWindow.free();}};DialerAgent.prototype.start=function da_start(){if(!this._telephony){return;}
if(this._started){throw'Instance should not be start()\'ed twice.';}
this._started=true;SettingsListener.observe('audio.volume.notification',7,function(value){this._shouldRing=!!value;if(this._shouldRing&&this._alerting){this._player.play();}}.bind(this));SettingsListener.observe('dialer.ringtone','',function(value){var phoneSoundURL=new SettingsURL();this._player.pause();this._player.src=phoneSoundURL.set(value);if(this._shouldRing&&this._alerting){this._player.play();}}.bind(this));VersionHelper.getVersionInfo().then(function(versionInfo){if(versionInfo.isUpgrade()){LazyLoader.load('js/tone_upgrader.js',function(){toneUpgrader.perform('ringtone');});}},function(err){console.error('VersionHelper failed to lookup version settings.');});SettingsListener.observe('vibration.enabled',true,function(value){this._shouldVibrate=!!value;}.bind(this));this._telephony.addEventListener('callschanged',this);window.addEventListener('sleep',this);window.addEventListener('volumedown',this);window.addEventListener('mozmemorypressure',this.freeCallscreenWindow);this._callscreenWindow=new CallscreenWindow();this._callscreenWindow.hide();if(applications&&applications.ready){this.makeFakeNotification();}else{window.addEventListener('applicationready',this.makeFakeNotification);}
return this;};DialerAgent.prototype.makeFakeNotification=function(){window.removeEventListener('applicationready',this.makeFakeNotification);this._callscreenWindow&&this._callscreenWindow.makeNotification();};DialerAgent.prototype.stop=function da_stop(){if(!this._started){return;}
this._started=false;this._telephony.removeEventListener('callschanged',this);window.removeEventListener('sleep',this);window.removeEventListener('volumedown',this);window.removeEventListener('mozmemorypressure',this.freeCallscreenWindow);};DialerAgent.prototype.handleEvent=function da_handleEvent(evt){if(evt.type==='sleep'||evt.type==='volumedown'){this._stopAlerting();return;}
if(evt.type!=='callschanged'){return;}
var calls=this._telephony.calls;if(calls.length===0){return;}
var calling=calls.some(function(call){if(call.state==='incoming'||call.state==='dialing'){return true;}});if(calling){this.openCallscreen();}
if(this._alerting||calls[0].state!=='incoming'){return;}
var incomingCall=calls[0];var self=this;self._startAlerting();incomingCall.addEventListener('statechange',function callStateChange(){incomingCall.removeEventListener('statechange',callStateChange);self._stopAlerting();});};DialerAgent.prototype._startAlerting=function da_startAlerting(){this._alerting=true;if('vibrate'in navigator&&this._shouldVibrate){this._vibrateInterval=window.setInterval(function vibrate(){navigator.vibrate([200]);},600);navigator.vibrate([200]);}
if(this._shouldRing){this._player.play();}};DialerAgent.prototype._stopAlerting=function da_stopAlerting(){var player=this._player;this._alerting=false;if(player&&player.readyState>player.HAVE_NOTHING){player.pause();player.currentTime=0;}
window.clearInterval(this._vibrateInterval);};DialerAgent.prototype.openCallscreen=function(){if(this._callscreenWindow){this._callscreenWindow.ensure();this._callscreenWindow.requestOpen();}};exports.DialerAgent=DialerAgent;}(window));;'use strict';(function(exports){var AttentionWindowManager=function(){};AttentionWindowManager.prototype={DEBUG:false,TRACE:false,name:'AttentionWindowManager',_openedInstances:null,EVENT_PREFIX:'attentionwindowmanager',publish:function vm_publish(eventName,detail){this.debug('publishing: ',eventName);var evt=new CustomEvent(this.EVENT_PREFIX+eventName,{detail:detail});window.dispatchEvent(evt);},debug:function aw_debug(){if(this.DEBUG){console.log('['+this.name+']'+'['+Service.currentTime()+'] '+
Array.slice(arguments).concat());if(this.TRACE){console.trace();}}},isActive:function(){return this.hasActiveWindow();},hasActiveWindow:function attwm_hasActiveWindow(){return(this._openedInstances.size!==0);},getActiveWindow:function(){return this.getTopMostWindow();},getTopMostWindow:function attwm_hasActiveWindow(){return this._topMostWindow;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}else{return true;}},_handle_home:function(evt){if(!this.hasActiveWindow()){return true;}
this._topMostWindow=null;var nextApp=homescreenLauncher.getHomescreen();if(Service.locked){this.closeAllAttentionWindows();}else if(nextApp&&!nextApp.isDead()){nextApp.ready(this.closeAllAttentionWindows.bind(this));}else{this.closeAllAttentionWindows();}
return true;},'_handle_system-resize':function(){if(this._topMostWindow){this._topMostWindow.resize();return false;}
return true;},_handle_holdhome:function(){if(this.isActive()){this._topMostWindow=null;this.closeAllAttentionWindows();}
return true;},getInstances:function(){return this._instances;},screen:document.getElementById('screen'),start:function attwm_start(){this._instances=[];this._openedInstances=new Map();window.addEventListener('attentioncreated',this);window.addEventListener('attentionterminated',this);window.addEventListener('attentionshown',this);window.addEventListener('attentionopening',this);window.addEventListener('attentionopened',this);window.addEventListener('attentionclosed',this);window.addEventListener('attentionclosing',this);window.addEventListener('attentionrequestopen',this);window.addEventListener('attentionrequestclose',this);window.addEventListener('emergencyalert',this);window.addEventListener('launchapp',this);window.addEventListener('lockscreen-appclosed',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('secure-appclosed',this);window.addEventListener('secure-appopened',this);window.addEventListener('rocketbar-overlayopened',this);window.addEventListener('languagechange',this);Service.request('registerHierarchy',this);},stop:function attwm_stop(){this._instances=null;this._openedInstances=null;window.removeEventListener('attentioncreated',this);window.removeEventListener('attentionterminated',this);window.removeEventListener('attentionshow',this);window.removeEventListener('attentionopening',this);window.removeEventListener('attentionopened',this);window.removeEventListener('attentionclosed',this);window.removeEventListener('attentionclosing',this);window.removeEventListener('attentionrequestopen',this);window.removeEventListener('attentionrequestclose',this);window.removeEventListener('emergencyalert',this);window.removeEventListener('launchapp',this);window.removeEventListener('lockscreen-appclosed',this);window.removeEventListener('lockscreen-appopened',this);window.removeEventListener('secure-appclosed',this);window.removeEventListener('secure-appopened',this);window.removeEventListener('rocketbar-overlayopened',this);window.removeEventListener('languagechange',this);Service.request('unregisterHierarchy',this);},handleEvent:function attwm_handleEvent(evt){this.debug('handling '+evt.type);var attention=evt.detail;switch(evt.type){case'attentioncreated':this._instances.push(attention);break;case'attentionopening':case'attentionopened':this._openedInstances.set(attention,attention);this.updateAttentionIndicator();this.publish('-activated');this.updateClassState();break;case'attentionrequestclose':window.SettingsListener&&SettingsListener.getSettingsLock().set({'private.broadcast.attention_screen_opening':false});this._openedInstances.delete(attention);if(this._topMostWindow!==attention){attention.close();break;}
var candidate=null;if(this._openedInstances.size===0){this._topMostWindow=null;candidate=Service.currentApp;}else{this._openedInstances.forEach(function(instance){candidate=instance;});this._topMostWindow=candidate;}
if(!candidate){attention.close();break;}
candidate.ready(function(){attention.close();});break;case'attentionclosing':case'attentionclosed':this._openedInstances.delete(attention);if(this._topMostWindow){this._topMostWindow.promote();this._topMostWindow.setVisible(true);}
attention.demote();if(this._openedInstances.size===0){this.publish('-deactivated');}
this.updateAttentionIndicator();this.updateClassState();break;case'attentionrequestopen':window.SettingsListener&&SettingsListener.getSettingsLock().set({'private.broadcast.attention_screen_opening':true});this._topMostWindow=attention;attention.ready(function(){if(document.mozFullScreen){document.mozCancelFullScreen();}
this._openedInstances.forEach(function(opened){if(opened!==attention){opened.demote();opened.setVisible(false);}});attention.promote();attention.setVisible(true);attention.open();}.bind(this));break;case'attentionshown':if(this._instances.indexOf(attention)<0){this._instances.push(attention);}
break;case'attentionterminated':var index=this._instances.indexOf(attention);if(index>=0){this._instances.splice(index,1);}
this._openedInstances.delete(attention);this.updateAttentionIndicator();this.updateClassState();break;case'launchapp':if(evt.detail&&evt.detail.stayBackground){break;}
case'emergencyalert':case'rocketbar-overlayopened':this._topMostWindow=null;this.closeAllAttentionWindows();break;case'lockscreen-appclosed':case'lockscreen-appopened':case'secure-appopened':case'secure-appclosed':case'languagechange':this._instances.forEach(function(instance){instance.broadcast(evt.type);});break;}},getShownWindowCount:function(){var count=this._instances.length;this._instances.forEach(function(attention){if(attention.isHidden()){count--;}});return count;},updateAttentionIndicator:function(){if(this._openedInstances.size==this.getShownWindowCount()){Service.request('makeAmbientIndicatorInactive');}else{Service.request('makeAmbientIndicatorActive');}},updateClassState:function(){if(this._openedInstances.size!==0){this.screen.classList.add('attention');}else{this.screen.classList.remove('attention');}},closeAllAttentionWindows:function(){this._openedInstances.forEach(function(value){value.close();});}};exports.AttentionWindowManager=AttentionWindowManager;}(window));;'use strict';(function(exports){var GlobalOverlayWindowManager=function(){};GlobalOverlayWindowManager.prototype={DEBUG:false,TRACE:false,CLASS_NAME:'GlobalOverlayWindowManager',EVENT_PREFIX:'globaloverlaywindowmanager',_instance:null,publish:function(eventName,detail){this.debug('publishing: ',eventName);var evt=new CustomEvent(this.EVENT_PREFIX+eventName,{detail:detail});window.dispatchEvent(evt);},debug:function(){if(this.DEBUG){console.log('['+this.CLASS_NAME+']'+'['+Service.currentTime()+'] '+
Array.slice(arguments).concat());if(this.TRACE){console.trace();}}},screen:document.getElementById('screen'),start:function owm_start(){window.addEventListener('globaloverlaycreated',this);window.addEventListener('globaloverlayrequestopen',this);window.addEventListener('globaloverlayopening',this);window.addEventListener('globaloverlayopened',this);window.addEventListener('globaloverlayrequestclose',this);window.addEventListener('globaloverlayclosing',this);window.addEventListener('globaloverlayclosed',this);window.addEventListener('globaloverlayterminated',this);window.addEventListener('system-resize',this);Service.request('registerHierarchy',this);},stop:function owm_stop(){this._instance=null;window.removeEventListener('globaloverlaycreated',this);window.removeEventListener('globaloverlayrequestopen',this);window.removeEventListener('globaloverlayopening',this);window.removeEventListener('globaloverlayopened',this);window.removeEventListener('globaloverlayrequestclose',this);window.removeEventListener('globaloverlayclosing',this);window.removeEventListener('globaloverlayclosed',this);window.removeEventListener('globaloverlayterminated',this);window.removeEventListener('system-resize',this);Service.request('unregisterHierarchy',this);},handleEvent:function owm_handleEvent(evt){this.debug('handling '+evt.type);var overlay=evt.detail;if(!this._instance&&evt.type!='globaloverlaycreated'){return;}
switch(evt.type){case'globaloverlaycreated':if(this._instance){console.error('We can only have one global overlay at a time');overlay.kill();return;}
this._instance=overlay;break;case'globaloverlayopening':case'globaloverlayopened':if(this._instance==overlay){this.publish('-activated');}
break;case'globaloverlayrequestopen':if(this._instance!=overlay){return;}
this._instance.ready(function(){this._instance.setVisible(true);this._instance.open();}.bind(this));break;case'globaloverlayrequestclose':if(this._instance==overlay){this._instance.close();}
break;case'globaloverlayclosing':case'globaloverlayclosed':if(this._instance==overlay){this.publish('-deactivated');}
break;case'globaloverlayterminated':if(this._instance==overlay){this._instance=null;}
break;case'system-resize':if(this._instance!=overlay){return;}
this._instance.resize();break;}},isActive:function owm_isActive(){return this._instance!=null;},getActiveWindow:function owm_getActiveWindow(){return this.getTopMostWindow();},getTopMostWindow:function owm_getTopMostWindow(){return this._instance;},};exports.GlobalOverlayWindowManager=GlobalOverlayWindowManager;}(window));;'use strict';(function(exports){var AppWindowManager=function(){};AppWindowManager.prototype={DEBUG:false,name:'AppWindowManager',EVENT_PREFIX:'appwindowmanager',continuousTransition:false,slowTransition:false,element:document.getElementById('windows'),screen:document.getElementById('screen'),isActive:function(){return(!!this._activeApp&&!window.taskManager.isActive());},setHierarchy:function(active){if(!this._activeApp){this.debug('No active app.');return;}
if(active){if(!appWindowFactory.isLaunchingWindow()&&!WrapperFactory.isLaunchingWindow()){this.focus();}}else if(!UtilityTray.shown){this._activeApp.blur();this._activeApp.setNFCFocus(false);}else{this._activeApp.setNFCFocus(false);}
this._activeApp.setVisibleForScreenReader(active);},focus:function(){if(!this._activeApp){return;}
this.debug('focusing '+this._activeApp.name);this._activeApp.focus();this._activeApp.setNFCFocus(true);},isRunning:function awm_isRunning(config){if(config.manifestURL&&this.getApp(config.origin)){return true;}else{return false;}},getActiveWindow:function(){return this.getActiveApp();},getActiveApp:function awm_getActiveApp(){return this._activeApp||(window.homescreenWindowManager?window.homescreenWindowManager.getHomescreen():null);},getApp:function awm_getApp(origin,manifestURL){for(var id in this._apps){var app=this._apps[id];if(app.origin===origin&&(!manifestURL||app.manifestURL===manifestURL)&&(!app.isBrowser()||app.config.url===origin)){return app;}}
return null;},getAppByURL:function awm_getAppByURL(url){for(var id in this._apps){var app=this._apps[id];if(app.config.url===url){return app;}}
return null;},getApps:function awm_getApps(){return this._apps;},_activeApp:null,_apps:{},_settingsObserveHandler:null,_nfcHandler:null,display:function awm_display(newApp,openAnimation,closeAnimation,eventType){this._dumpAllWindows();var appCurrent=this._activeApp,appNext=newApp||homescreenWindowManager.getHomescreen('home'===eventType);if(!appNext){this.debug('no next app.');return;}
while(appNext.nextWindow){appNext=appNext.nextWindow;}
this.debug(' current is '+(appCurrent?appCurrent.url:'none')+'; next is '+(appNext?appNext.url:'none'));if(appCurrent&&appCurrent.instanceID==appNext.instanceID){this.debug('the app has been displayed.');return;}
if(document.mozFullScreen){document.mozCancelFullScreen();}
this.screen.classList.remove('fullscreen-app');var switching=appCurrent&&!appCurrent.isHomescreen&&!appNext.isHomescreen;this._updateActiveApp(appNext.instanceID);var that=this;if(appCurrent&&layoutManager.keyboardEnabled){this.sendStopRecordingRequest();window.addEventListener('keyboardhidden',function onhiddenkeyboard(){window.removeEventListener('keyboardhidden',onhiddenkeyboard);that.switchApp(appCurrent,appNext,switching);});if(this.continuousTransition){inputWindowManager.hideInputWindow();}else{inputWindowManager.hideInputWindowImmediately();}}else if(rocketbar.active){window.addEventListener('rocketbar-overlayclosed',function onClose(){window.removeEventListener('rocketbar-overlayclosed',onClose);that.switchApp(appCurrent,appNext,switching);});}else{this.sendStopRecordingRequest(function(){this.switchApp(appCurrent,appNext,switching,openAnimation,closeAnimation);}.bind(this));}},switchApp:function awm_switchApp(appCurrent,appNext,switching,openAnimation,closeAnimation){this.debug('before ready check'+appCurrent+appNext);appNext.ready(function(){if(appNext.isDead()){if(!appNext.isHomescreen){this._updateActiveApp(appCurrent.instanceID);return;}else{appNext=homescreenWindowManager.getHomescreen();appNext.ensure(true);}}
appNext.reviveBrowser();this.debug('ready to open/close'+switching);if(switching){this.publish('appswitching');}
this._updateActiveApp(appNext.instanceID);var immediateTranstion=false;if(appNext.rotatingDegree===90||appNext.rotatingDegree===270){immediateTranstion=true;}else if(appCurrent){var degree=appCurrent.determineClosingRotationDegree();if(degree===90||degree===270){immediateTranstion=true;}}else if(appNext.isHomescreen){immediateTranstion=true;}
if(appNext.resized&&!layoutManager.match(appNext.width,appNext.height)){immediateTranstion=true;}
appNext.open(immediateTranstion?'immediate':((switching===true)?'invoked':openAnimation));if(appCurrent&&appCurrent.instanceID!==appNext.instanceID){appCurrent.close(immediateTranstion?'immediate':((switching===true)?'invoking':closeAnimation));}else{this.debug('No current running app!');}}.bind(this));},start:function awm_start(){this.activated=false;if(this.slowTransition){this.element.classList.add('slow-transition');}else{this.element.classList.remove('slow-transition');}
window.addEventListener('cardviewbeforeshow',this);window.addEventListener('cardviewshown',this);window.addEventListener('cardviewclosed',this);window.addEventListener('launchapp',this);window.addEventListener('appcreated',this);window.addEventListener('appterminated',this);window.addEventListener('ftuskip',this);window.addEventListener('appopened',this);window.addEventListener('apprequestopen',this);window.addEventListener('apprequestclose',this);window.addEventListener('shrinking-start',this);window.addEventListener('shrinking-stop',this);window.addEventListener('homescreenopened',this);window.addEventListener('reset-orientation',this);window.addEventListener('homescreencreated',this);window.addEventListener('homescreen-changed',this);window.addEventListener('killapp',this);window.addEventListener('displayapp',this);window.addEventListener('applicationuninstall',this);window.addEventListener('hidewindow',this);window.addEventListener('showwindow',this);window.addEventListener('hidewindowforscreenreader',this);window.addEventListener('showwindowforscreenreader',this);window.addEventListener('attentionopened',this);window.addEventListener('homegesture-enabled',this);window.addEventListener('homegesture-disabled',this);window.addEventListener('orientationchange',this);window.addEventListener('sheets-gesture-begin',this);window.addEventListener('sheets-gesture-end',this);window.addEventListener('permissiondialoghide',this);window.addEventListener('appopening',this);window.addEventListener('localized',this);window.addEventListener('taskmanager-activated',this);window.addEventListener('hierarchytopmostwindowchanged',this);this._settingsObserveHandler={'continuous-transition.enabled':{defaultValue:null,callback:function(value){if(!value){return;}
this.continuousTransition=!!value;}.bind(this)},'app-suspending.enabled':{defaultValue:false,callback:function(value){if(!value){this.broadcastMessage('kill_suspended');}}.bind(this)},'nfc.enabled':{defaultValue:false,callback:(value)=>{if(!this._nfcHandler){this._nfcHandler=new NfcHandler(this);}
if(value){this._nfcHandler.start();}else{this._nfcHandler.stop();}}}};for(var name in this._settingsObserveHandler){SettingsListener.observe(name,this._settingsObserveHandler[name].defaultValue,this._settingsObserveHandler[name].callback);}
Service.request('registerHierarchy',this);},stop:function awm_stop(){window.removeEventListener('cardviewbeforeshow',this);window.removeEventListener('cardviewshown',this);window.removeEventListener('cardviewclosed',this);window.removeEventListener('launchapp',this);window.removeEventListener('appcreated',this);window.removeEventListener('appterminated',this);window.removeEventListener('ftuskip',this);window.removeEventListener('appopened',this);window.removeEventListener('apprequestopen',this);window.removeEventListener('apprequestclose',this);window.removeEventListener('homescreenopened',this);window.removeEventListener('reset-orientation',this);window.removeEventListener('homescreencreated',this);window.removeEventListener('homescreen-changed',this);window.removeEventListener('killapp',this);window.removeEventListener('displayapp',this);window.removeEventListener('applicationuninstall',this);window.removeEventListener('hidewindow',this);window.removeEventListener('showwindow',this);window.removeEventListener('hidewindowforscreenreader',this);window.removeEventListener('showwindowforscreenreader',this);window.removeEventListener('attentionopened',this);window.removeEventListener('homegesture-enabled',this);window.removeEventListener('homegesture-disabled',this);window.removeEventListener('orientationchange',this);window.removeEventListener('sheets-gesture-begin',this);window.removeEventListener('sheets-gesture-end',this);window.removeEventListener('permissiondialoghide',this);window.removeEventListener('appopening',this);window.removeEventListener('localized',this);window.removeEventListener('shrinking-start',this);window.removeEventListener('shrinking-stop',this);window.removeEventListener('taskmanager-activated',this);window.removeEventListener('hierarchytopmostwindowchanged',this);for(var name in this._settingsObserveHandler){SettingsListener.unobserve(name,this._settingsObserveHandler[name].callback);}
this._settingsObserveHandler=null;Service.request('unregisterHierarchy',this);},'_handle_system-resize':function(){if(this._activeApp){this.debug(' Resizing '+this._activeApp.name);if(!this._activeApp.isTransitioning()){this._activeApp.resize();return false;}}
return true;},_handle_home:function(evt){if(this.shrinkingUI&&this.shrinkingUI.respondToHierarchyEvent(evt)){return false;}
if(FtuLauncher.respondToHierarchyEvent(evt)){if(!homescreenWindowManager.ready||(window.taskManager&&window.taskManager.isActive())){return true;}
this.display(null,null,null,'home');return false;}else{return false;}},_handle_holdhome:function(evt){if(this.shrinkingUI&&this.shrinkingUI.respondToHierarchyEvent(evt)){return false;}
var ret=FtuLauncher.respondToHierarchyEvent(evt);return ret;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;},handleEvent:function awm_handleEvent(evt){this.debug('handling '+evt.type);var activeApp=this._activeApp;var detail=evt.detail;switch(evt.type){case'hierarchytopmostwindowchanged':if(Service.query('getTopMostUI')!==this){return;}
this._activeApp&&this._activeApp.getTopMostWindow().setNFCFocus(true);break;case'shrinking-start':if(this.shrinkingUI&&this.shrinkingUI.isActive()){return;}
if(Service.query('getTopMostUI')!==this){return;}
var bottomMost=this._activeApp.getBottomMostWindow();this.shrinkingUI=new ShrinkingUI(bottomMost.element,bottomMost.element.parentNode);this.shrinkingUI.start();activeApp&&activeApp.broadcast('shrinkingstart');break;case'shrinking-stop':if(this.shrinkingUI&&this.shrinkingUI.isActive()){activeApp&&activeApp.broadcast('shrinkingstop');this.shrinkingUI.stop();}
break;case'permissiondialoghide':activeApp&&activeApp.broadcast('focus');break;case'orientationchange':this.broadcastMessage(evt.type,Service.query('getTopMostUI')===this);break;case'homegesture-disabled':case'homegesture-enabled':this.broadcastMessage(evt.type);break;case'appcreated':var app=evt.detail;this._apps[evt.detail.instanceID]=app;break;case'appterminated':var app=evt.detail;var instanceID=evt.detail.instanceID;if(activeApp&&app.instanceID===activeApp.instanceID){activeApp=null;}
delete this._apps[instanceID];break;case'reset-orientation':if(activeApp){activeApp.setOrientation();}
break;case'ftuskip':if(!Service.locked){this.display();}
break;case'appopening':case'appopened':case'homescreenopened':this._updateActiveApp(evt.detail.instanceID);break;case'homescreencreated':this._apps[evt.detail.instanceID]=evt.detail;break;case'homescreen-changed':this.display();break;case'killapp':this.kill(evt.detail.origin);break;case'displayapp':case'apprequestopen':this.display(evt.detail);break;case'apprequestclose':if(evt.detail.isActive()){this.display();}
break;case'applicationuninstall':this.kill(evt.detail.application.origin);break;case'hidewindow':activeApp&&activeApp.broadcast('hidewindow',evt.detail);break;case'hidewindowforscreenreader':activeApp.setVisibleForScreenReader(false);break;case'showwindowforscreenreader':activeApp.setVisibleForScreenReader(true);break;case'showwindow':this.onShowWindow(detail);break;case'attentionopened':if(activeApp){if(!activeApp.isOOP()){activeApp.setVisible(false,true);}else{activeApp.blur();}}
break;case'launchapp':var config=evt.detail;this.debug('launching'+config.origin);this.launch(config);break;case'cardviewbeforeshow':if(this._activeApp){this._activeApp.getTopMostWindow().blur();}
this.broadcastMessage('cardviewbeforeshow');break;case'cardviewshown':this.broadcastMessage('cardviewshown');break;case'cardviewclosed':this.broadcastMessage('cardviewclosed');break;case'sheets-gesture-begin':if(document.mozFullScreen){document.mozCancelFullScreen();}
activeApp&&activeApp.setVisibleForScreenReader(false);this.broadcastMessage('sheetsgesturebegin');break;case'sheets-gesture-end':activeApp&&activeApp.setVisibleForScreenReader(true);this.broadcastMessage('sheetsgestureend');break;case'localized':this.broadcastMessage('localized');break;case'taskmanager-activated':this.activated=false;this.publish(this.EVENT_PREFIX+'-deactivated');break;}},_handle_launchactivity:function(evt){if(evt.detail.isActivity&&evt.detail.inline&&this._activeApp){this._activeApp.broadcast('launchactivity',evt.detail);return false;}
return true;},'_handle_mozChromeEvent':function(evt){if(!evt.detail||evt.detail.type!=='inputmethod-contextchange'){return true;}
if(this._activeApp){this._activeApp.getTopMostWindow().broadcast('inputmethod-contextchange',evt.detail);return false;}
return true;},_dumpAllWindows:function(){if(!this.DEBUG){return;}
console.log('=====DUMPING APP WINDOWS BEGINS=====');for(var id in this._apps){var app=this._apps[id];if(app.previousWindow){continue;}
this._dumpWindow(app);while(app.nextWindow){this._dumpWindow(app,'->child:');app=app.nextWindow;}}
console.log('=====END OF DUMPING APP WINDOWS=====');},_dumpWindow:function(app,prefix){console.log((prefix?prefix:'')+'['+app.instanceID+']'+
(app.name||app.title||'ANONYMOUS')+' ('+app.url+')');if(app.calleeWindow){console.log('==>activity:['+app.instanceID+']'+
(app.name||app.title||'ANONYMOUS')+' ('+app.url+')');}},launch:function awm_launch(config){if(config.changeURL&&this.getApp(config.origin)){this.getApp(config.origin).modifyURLatBackground(config.url);}
if(config.stayBackground){return;}else{if(config.isActivity&&this._activeApp){this.linkWindowActivity(config);}
this.display(this.getApp(config.origin));}},linkWindowActivity:function awm_linkWindowActivity(config){var caller;var callee=this.getApp(config.origin);caller=this._activeApp.getTopMostWindow();if(caller.getBottomMostWindow()===callee){callee.frontWindow&&callee.frontWindow.kill();}else{callee.callerWindow=caller;caller.calleeWindow=callee;}},debug:function awm_debug(){if(this.DEBUG){console.log('['+this.name+']'+'['+Service.currentTime()+']'+
Array.slice(arguments).concat());}},kill:function awm_kill(origin,manifestURL){for(var id in this._apps){if(this._apps[id].origin===origin&&(!manifestURL||this._apps[id].manifestURL===manifestURL)){this._apps[id].kill();}}},publish:function awm_publish(event,detail){var evt=document.createEvent('CustomEvent');evt.initCustomEvent(event,true,false,detail||this);this.debug('publish: '+event);window.dispatchEvent(evt);},_updateActiveApp:function awm__changeActiveApp(instanceID){var appHasChanged=(this._activeApp!==this._apps[instanceID]);this.debug(appHasChanged,this.activated,this._activeApp);var activated=false;if(!this.activated&&appHasChanged&&!this._activeApp){activated=true;}else if(!appHasChanged&&this._activeApp&&!this.activated){activated=true;}
this._activeApp=this._apps[instanceID];if(!this._activeApp){this.debug('no active app alive: '+instanceID);return;}
var fullScreenLayout=this._activeApp.isFullScreenLayout();this.screen.classList.toggle('fullscreen-layout-app',fullScreenLayout);this._activeApp.resize();if(appHasChanged){if(this.shrinkingUI&&this.shrinkingUI.isActive()){this.shrinkingUI.stop();}
this.publish('activeappchanged');}
this.debug('=== Active app now is: ',(this._activeApp.name||this._activeApp.origin),'===');if(activated){this.publish(this.EVENT_PREFIX+'-activated');}},broadcastMessage:function awm_broadcastMessage(message,detail){for(var id in this._apps){this._apps[id].broadcast(message,detail);}},onShowWindow:function awm_onShowWindow(detail){var activeApp=this._activeApp;var launchHomescreen=()=>{var home=homescreenWindowManager.getHomescreen();if(home){if(home.isActive()){home.setVisible(true);}else{this.display();}}};detail=detail?detail:{};var{activity,notificationId}=detail;if(activity||notificationId){if(activeApp&&!activeApp.isHomescreen){activeApp.setVisible(true);if(activity){this.fireActivity(activity);}else if(notificationId){this.fireNotificationClicked(notificationId);}}else{if(activity){this.fireActivity(activity);}else if(notificationId){launchHomescreen();this.fireNotificationClicked(notificationId);}}}else{if(activeApp&&!activeApp.isHomescreen){activeApp.setVisible(true);}else{launchHomescreen();}}},fireActivity:function awm_fireActivity(activityContent){var a=new window.MozActivity(activityContent);a.onerror=function ls_activityError(){console.log('MozActivity: activity error.');};},fireNotificationClicked:function awm_fireNotificationClicked(notificationId){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentNotificationEvent',true,true,{type:'desktop-notification-click',id:notificationId});window.dispatchEvent(event);window.dispatchEvent(new CustomEvent('notification-clicked',{detail:{id:notificationId}}));},sendStopRecordingRequest:function sendStopRecordingRequest(callback){if(!window.mediaRecording.isRecording){if(callback){callback();}
return;}
var setRequest=navigator.mozSettings.createLock().set({'private.broadcast.stop_recording':true});setRequest.onerror=function(){if(callback){callback();}};setRequest.onsuccess=function(){navigator.mozSettings.createLock().set({'private.broadcast.stop_recording':false});if(callback){callback();}};}};exports.AppWindowManager=AppWindowManager;}(window));;'use strict';(function(exports){var AppWindow=self.AppWindow;var SecureWindow=function(configs){AppWindow.call(this,configs);};SecureWindow.prototype=Object.create(AppWindow.prototype);SecureWindow.prototype.eventPrefix='secure-app';SecureWindow.prototype.openAnimation='fade-in';SecureWindow.prototype.closeAnimation='fade-out';SecureWindow.prototype.CLASS_LIST='appWindow secureAppWindow';SecureWindow.prototype.softKill=function sw_softKill(delay){if(delay===0){this.kill();return;}
if(this.isSoftKillPending()){return;}
delay=delay||5000;this.close();var self=this;this.softKillTimeout=setTimeout(function(){console.log('[SecureWindow] softKill() - Killing now: '+
self.manifestURL);self.kill();delete self.softKillTimeout;},delay);console.log('[SecureWindow] softKill() - Scheduled for kill in '+
delay+'ms: '+this.manifestURL);};SecureWindow.prototype.cancelSoftKill=function sw_cancelSoftKill(){if(this.softKillTimeout){clearTimeout(this.softKillTimeout);delete this.softKillTimeout;console.log('[SecureWindow] cancelSoftKill() - Cancelled kill: '+
this.manifestURL);}};SecureWindow.prototype.isSoftKillPending=function sw_isSoftKillPending(){return!!this.softKillTimeout;};exports.SecureWindow=SecureWindow;})(self);;'use strict';(function(exports){var SecureWindowFactory=function(){this.initEvents();};SecureWindowFactory.prototype={states:{apps:{}},configs:{listens:['secure-launchapp','secure-appterminated','secure-modeon','secure-modeoff']}};SecureWindowFactory.prototype.initEvents=function swf_initEvents(){this.configs.listens.forEach((function _initEvent(type){self.addEventListener(type,this);}).bind(this));};SecureWindowFactory.prototype.suspendEvents=function swf_suspendEvents(){this.configs.listens.forEach((function _unbind(ename){self.removeEventListener(ename,this);}).bind(this));};SecureWindowFactory.prototype.suspend=function swf_suspend(){this.suspendEvents();self.addEventListener('secure-modeon',this);for(var origin in this.states.apps){this.unregisterApp(this.states.apps[origin]);}};SecureWindowFactory.prototype.resume=function swf_resume(){this.initEvents();self.removeEventListener('secure-modeon',this);};SecureWindowFactory.prototype.handleEvent=function(evt){switch(evt.type)
{case'secure-launchapp':var{appURL,appManifestURL}=evt.detail;this.create(appURL,appManifestURL);break;case'secure-appterminated':var app=evt.detail;this.unregisterApp(app);break;case'secure-modeoff':this.suspend();break;case'secure-modeon':this.resume();break;}};SecureWindowFactory.prototype.create=function(url,manifestURL){var config=new self.BrowserConfigHelper({url:url,manifestURL:manifestURL});for(var instanceID in this.states.apps){var secureWindow=this.states.apps[instanceID];if(config.manifestURL===secureWindow.manifestURL){secureWindow.cancelSoftKill();secureWindow.open();return;}}
var app=new self.SecureWindow(config);app.open();this.registerApp(app);};SecureWindowFactory.prototype.registerApp=function(app){this.states.apps[app.instanceID]=app;};SecureWindowFactory.prototype.unregisterApp=function(app){delete this.states.apps[app.instanceID];};exports.SecureWindowFactory=SecureWindowFactory;})(self);;'use strict';(function(exports){var SecureWindowManager=function(){this.initElements();this.initEvents();Service.request('registerHierarchy',this);};SecureWindowManager.prototype={name:'SecureWindowManager',elements:{windows:null,screen:null},states:{activeApp:null,runningApps:{},killMode:false},configs:{killAnimation:'immediate',listens:['secure-killapps','secure-closeapps','secure-appcreated','secure-appopened','secure-appterminated','secure-apprequestclose']}};SecureWindowManager.prototype.HIERARCHY_MANAGER='SecureWindowManager';SecureWindowManager.prototype.setHierarchy=function(active){if(!this.states.activeApp){return;}
if(active){this.states.activeApp.focus();}
this.states.activeApp.setVisibleForScreenReader(active);};SecureWindowManager.prototype.getActiveWindow=function(){return this.isActive()?this.states.activeApp:null;};SecureWindowManager.prototype._handle_home=function(){if(0!==Object.keys(this.states.runningApps).length){this.elements.screen.classList.remove('secure-app');this.softKillApps();}
return true;};SecureWindowManager.prototype.respondToHierarchyEvent=function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}else{return true;}};SecureWindowManager.prototype.handleEvent=function swm_handleEvent(evt){var app=null;switch(evt.type){case'secure-killapps':if(0!==Object.keys(this.states.runningApps).length){this.states.killMode=true;this.killApps();}
break;case'secure-closeapps':if(0!==Object.keys(this.states.runningApps).length){this.softKillApps();}
break;case'secure-appcreated':app=evt.detail;if(this.allowed(app.config)){this.registerApp(app);this.activateApp(app);}else{console.error('Disallowed app: ',app.instanceID);}
break;case'secure-appopened':this.elements.screen.classList.add('secure-app');break;case'secure-appterminated':app=evt.detail;this.unregisterApp(app);this.deactivateApp();if(0===Object.keys(this.states.runningApps).length){this.states.killMode=false;}
break;case'secure-apprequestclose':app=evt.detail;app.close(this.states.killMode?this.configs.killAnimation:null);this.elements.screen.classList.remove('secure-app');break;}};SecureWindowManager.prototype.initElements=function swm_initElements(){var selectors={windows:'windows',screen:'screen'};for(var name in selectors){var id=selectors[name];this.elements[name]=document.getElementById(id);}};SecureWindowManager.prototype.initEvents=function swm_initEvents(){this.configs.listens.forEach((function _initEvent(type){self.addEventListener(type,this);}).bind(this));};SecureWindowManager.prototype.killApps=function swm_killApps(){for(var origin in this.states.runningApps){this.states.runningApps[origin].kill();}};SecureWindowManager.prototype.softKillApps=function swm_softKillApps(){for(var origin in this.states.runningApps){this.states.runningApps[origin].softKill();}};SecureWindowManager.prototype.publish=function swm_publish(ne,source){if('string'===typeof ne){ne=new CustomEvent(ne);}
if(!source){source=window;}
source.dispatchEvent(ne);};SecureWindowManager.prototype.registerApp=function swm_registerApp(app){this.states.runningApps[app.instanceID]=app;};SecureWindowManager.prototype.unregisterApp=function swm_unregisterApp(app){delete this.states.runningApps[app.instanceID];};SecureWindowManager.prototype.activateApp=function swm_activateApp(app){this.states.activeApp=app;if(app.isFullScreen()){this.elements.screen.classList.add('fullscreen-app');}else{this.elements.screen.classList.remove('fullscreen-app');}};SecureWindowManager.prototype.deactivateApp=function swm_deactivateApp(){if(this.states.activeApp.isFullScreen()){this.elements.screen.classList.remove('fullscreen-app');}
this.states.activeApp=null;};SecureWindowManager.prototype.allowed=function swm_allowed(config){if('certified'!==config.manifest.type){return false;}
return true;};SecureWindowManager.prototype.isActive=function swm_isActive(){if(!this.states.activeApp){return false;}else{return this.states.activeApp.isActive();}};exports.SecureWindowManager=SecureWindowManager;})(window);;'use strict';(function(exports){var SystemDialog=function SystemDialog(options){this.options=options||{};this.render();this.publish('created');};SystemDialog.prototype=Object.create(window.BaseUI.prototype);SystemDialog.prototype.CLASS_NAME='SystemDialog';SystemDialog.prototype.containerElement=document.getElementById('dialog-overlay');SystemDialog.prototype.EVENT_PREFIX='system-dialog-';SystemDialog.prototype.customID=function sd_customID(){return'';};SystemDialog.prototype.SUB_COMPONENTS={'valueSelector':window.ValueSelector};SystemDialog.prototype.installSubComponents=function sd_installSubComponents(){this.debug('installing sub components...');for(var componentName in this.SUB_COMPONENTS){if(this.SUB_COMPONENTS[componentName]){this[componentName]=new this.SUB_COMPONENTS[componentName](this);}}};SystemDialog.prototype.uninstallSubComponents=function sd_uninstallSubComponents(){for(var componentName in this.SUB_COMPONENTS){if(this[componentName]){this[componentName].destroy();this[componentName]=null;}}};SystemDialog.prototype._setVisibleForScreenReader=function sd__setVisibleForScreenReader(visible){if(this.browser&&this.browser.element){this.debug('aria-hidden on browser element:'+!visible);this.browser.element.setAttribute('aria-hidden',!visible);}};SystemDialog.prototype.focus=function sd_focus(){if(this.browser&&this.browser.element){this.browser.element.focus();}};SystemDialog.prototype.view=function sd_view(){return'';};SystemDialog.prototype.render=function sd_render(){this.generateID();this.containerElement.insertAdjacentHTML('beforeend',this.view());this._fetchElements();this._registerEvents();this.element=document.getElementById(this.instanceID);this.installSubComponents();};SystemDialog.prototype.destroy=function sd_destroy(){this.publish('willdestroy');this._unregisterEvents();this.uninstallSubComponents();if(this.element){this.element.parentNode.removeChild(this.element);this.element=null;}
this.publish('destroyed');};SystemDialog.prototype.resize=function sd_resize(){this.updateHeight();};SystemDialog.prototype.updateHeight=function sd_updateHeight(){var height=window.layoutManager.height-StatusBar.height;this.containerElement.style.height=height+'px';this.debug('updateHeight: new height = '+height);};SystemDialog.prototype.show=function sd_show(){this.publish('opening');this.element.hidden=false;this.element.classList.add(this.customID);this.onShow();this.updateHeight();this.publish('show');};SystemDialog.prototype.hide=function sd_hide(reason,isManagerRequest){this.publish('closing');this.element.hidden=true;this.element.classList.remove(this.customID);this.onHide(reason);if(!isManagerRequest){this.publish('hide');}};SystemDialog.prototype.onShow=function sd_onShow(reason){if(typeof(this.options.onShow)=='function'){this.options.onShow(reason);}};SystemDialog.prototype.onHide=function sd_onHide(reason){if(typeof(this.options.onHide)=='function'){this.options.onHide(reason);}};SystemDialog.prototype.generateID=function sd_generateID(){if(!this.instanceID){this.instanceID=this.customID;}};exports.SystemDialog=SystemDialog;}(window));;'use strict';(function(exports){var DEBUG=false;var SystemDialogManager=function SystemDialogManager(){this.init();};SystemDialogManager.prototype={elements:{windows:null,screen:null,containerElement:document.getElementById('dialog-overlay')},states:{activeDialog:null,runningDialogs:{}},configs:{listens:['system-dialog-created','simlockcreated','system-dialog-show','system-dialog-hide','simlockshow','simlockhide','system-dialog-requestfocus','simlockrequestfocus','home','holdhome','hierarchytopmostwindowchanged']}};SystemDialogManager.prototype.isActive=function(){return!!this.states.activeDialog;};SystemDialogManager.prototype.setHierarchy=function(active){if(!this.states.activeDialog){return;}
if(active){this.states.activeDialog.focus();}
this.states.activeDialog._setVisibleForScreenReader(active);};SystemDialogManager.prototype.name='SystemDialogManager';SystemDialogManager.prototype.EVENT_PREFIX='systemdialogmanager';SystemDialogManager.prototype.publish=function(evtName){this.debug('publishing '+evtName);window.dispatchEvent(new CustomEvent(this.EVENT_PREFIX+evtName,{detail:this}));};SystemDialogManager.prototype['_handle_system-resize']=function(){if(this.states.activeDialog){this.states.activeDialog.resize();return false;}
return true;};SystemDialogManager.prototype._handle_mozChromeEvent=function(evt){if(!this.states.activeDialog||!evt.detail||evt.detail.type!=='inputmethod-contextchange'){return true;}
var typesToHandle=['select-one','select-multiple','date','time','datetime','datetime-local','blur'];if(typesToHandle.indexOf(evt.detail.inputType)<0){return true;}
this.states.activeDialog.broadcast('inputmethod-contextchange',evt.detail);return false;};SystemDialogManager.prototype._handle_home=function(evt){if(this.states.activeDialog){this.deactivateDialog(this.states.activeDialog,evt.type);}
return true;};SystemDialogManager.prototype._handle_holdhome=function(evt){if(this.states.activeDialog){this.deactivateDialog(this.states.activeDialog,evt.type);}
return true;};SystemDialogManager.prototype.respondToHierarchyEvent=function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;};SystemDialogManager.prototype.handleEvent=function sdm_handleEvent(evt){var dialog=null;switch(evt.type){case'hierarchytopmostwindowchanged':var appWindow=evt.detail.getTopMostWindow();var isFullScreen=appWindow&&appWindow.isFullScreen();var container=this.elements.containerElement;container.classList.toggle('fullscreen',isFullScreen);if(this.states.activeDialog){this.states.activeDialog.resize();}
break;case'system-dialog-requestfocus':case'simlockrequestfocus':if(evt.detail!==this.states.activeDialog){return;}
Service.request('focus',this);break;case'simlockcreated':case'system-dialog-created':dialog=evt.detail;this.registerDialog(dialog);break;case'simlockshow':case'system-dialog-show':dialog=evt.detail;this.activateDialog(dialog);break;case'simlockhide':case'system-dialog-hide':dialog=evt.detail;this.deactivateDialog(dialog);break;}};SystemDialogManager.prototype.init=function sdm_init(){this.initElements();this.start();this.debug('init:');};SystemDialogManager.prototype.initElements=function sdm_initElements(){var selectors={windows:'windows',screen:'screen',containerElement:'dialog-overlay'};for(var name in selectors){var id=selectors[name];this.elements[name]=document.getElementById(id);}};SystemDialogManager.prototype.start=function sdm_start(){this.configs.listens.forEach((function _initEvent(type){self.addEventListener(type,this);}).bind(this));Service.request('registerHierarchy',this);};SystemDialogManager.prototype.registerDialog=function sdm_registerDialog(dialog){this.states.runningDialogs[dialog.instanceID]=dialog;};SystemDialogManager.prototype.unregisterDialog=function sdm_unregisterDialog(dialog){delete this.states.runningDialogs[dialog.instanceID];};SystemDialogManager.prototype.activateDialog=function sdm_activateDialog(dialog){this.debug('activateDialog: dialog.instanceID = '+dialog.instanceID);if(this.states.activeDialog&&dialog.instanceID!=this.states.activeDialog.instanceID){this.states.activeDialog.hide('interrupted',true);}
this.states.activeDialog=dialog;if(!this.elements.screen.classList.contains('dialog')){this.elements.screen.classList.add('dialog');this.publish('-activated');}};SystemDialogManager.prototype.deactivateDialog=function sdm_deactivateDialog(dialog,reason){this.debug('deactivateDialog: dialog.instanceID = '+dialog.instanceID);if(this.states.activeDialog&&dialog.instanceID==this.states.activeDialog.instanceID){if(reason){this.states.activeDialog.hide(reason,true);}else{}
this.elements.screen.classList.remove('dialog');this.states.activeDialog=null;this.publish('-deactivated');}else{}};SystemDialogManager.prototype.debug=function sd_debug(){if(DEBUG){console.log('[SystemDialogManager]'+'['+Service.currentTime()+']'+'['+Array.slice(arguments).concat()+']');}};exports.SystemDialogManager=SystemDialogManager;}(window));;'use strict';(function(exports){var NfcConnectSystemDialog=function NfcConnectSystemDialog(options){this.options=options||{};this.render();this.publish('created');};NfcConnectSystemDialog.prototype=Object.create(window.SystemDialog.prototype);NfcConnectSystemDialog.prototype.customID='nfc-connect-dialog';NfcConnectSystemDialog.prototype.DEBUG=false;NfcConnectSystemDialog.prototype.setMessage=function ncsd_setMessage(name){var enabled=Service.query('Bluetooth.isEnabled');var l10nArgs={deviceName:name};var msgId;var okayId;var cancelId;if(enabled&&!name){msgId='confirmNFCConnectBTenabledNameUnknown';}else if(!enabled&&!name){msgId='confirmNFCConnectBTdisabledNameUnknown';}else if(enabled&&name){msgId='confirmNFCConnectBTenabledNameKnown';}else{msgId='confirmNFCConnectBTdisabledNameKnown';}
if(enabled){okayId='yes';cancelId='no';}else{okayId='confirmNFCConnectBTdisabled';cancelId='dismissNFCConnectBTdisabled';}
this.buttonOK.setAttribute('data-l10n-id',okayId);this.buttonCancel.setAttribute('data-l10n-id',cancelId);navigator.mozL10n.setAttributes(this.confirmNFCConnectMsg,msgId,l10nArgs);};NfcConnectSystemDialog.prototype.hide=function ncsd_hide(reason){if(reason!==undefined&&typeof(this.onabort)=='function'){this.onabort();}
window.SystemDialog.prototype.hide.call(this);};NfcConnectSystemDialog.prototype.show=function ncsd_show(localName,onconfirm,onabort){this.onconfirm=onconfirm;this.onabort=onabort;this.setMessage(localName);this.element.hidden=false;this.publish('show');this.resize();};NfcConnectSystemDialog.prototype.view=function ncsd_view(){return`<div id="${this.instanceID}" role="dialog"
                class="generic-dialog"
                data-z-index-level="nfc-connect-dialog">
             <div class="modal-dialog-message-container inner">
               <h3 data-l10n-id="confirmation"></h3>
               <p>
                 <span id="confirm-nfc-connect-msg"></span>
               </p>
             </div>
             <menu data-items="2">
               <button type="cancel"></button>
               <button type="ok"></button>
             </menu>
           </div>`;};NfcConnectSystemDialog.prototype._fetchElements=function ncsd_fetchElements(){this.confirmNFCConnectTitle=document.querySelector('#nfc-connect-dialog h3');this.confirmNFCConnectMsg=document.getElementById('confirm-nfc-connect-msg');this.buttonOK=document.querySelector('#nfc-connect-dialog button[type="ok"]');this.buttonCancel=document.querySelector('#nfc-connect-dialog button[type="cancel"]');};NfcConnectSystemDialog.prototype._registerEvents=function ncsd_registerEvents(){this.buttonOK.onclick=this.okHandler.bind(this);this.buttonCancel.onclick=this.cancelHandler.bind(this);};NfcConnectSystemDialog.prototype.okHandler=function ncsd_okHandler(){this.hide();this.onconfirm();return true;};NfcConnectSystemDialog.prototype.cancelHandler=function ncsd_cancelHandler(){this.hide();this.onabort();return true;};exports.NfcConnectSystemDialog=NfcConnectSystemDialog;}(window));;'use strict';(function(exports){var FxAccountsDialog=function FxAccountsDialog(options){if(options){this.options=options;}
this.render();this.publish('created');};FxAccountsDialog.prototype=Object.create(window.SystemDialog.prototype);FxAccountsDialog.prototype.customID='fxa-dialog';FxAccountsDialog.prototype.DEBUG=false;FxAccountsDialog.prototype.view=function fxad_view(){return`<div id="${this.instanceID}" role="dialog"
           class="generic-dialog" data-z-index-level="system-dialog"
           hidden></div>`;};FxAccountsDialog.prototype.getView=function fxad_view(){return document.getElementById(this.instanceID);};FxAccountsDialog.prototype._fetchElements=function fxad__fetchElements(){};FxAccountsDialog.prototype._registerEvents=function fxad__registerEvents(){};exports.FxAccountsDialog=FxAccountsDialog;}(window));;'use strict';(function(exports){var AppWindow=window.AppWindow;var LockScreenWindow=function(){this.configs={url:window.location.href,manifest:{orientation:['default']},name:'Lockscreen',manifestURL:window.location.href.replace('system','lockscreen')+'/manifest.webapp',origin:window.location.origin.replace('system','lockscreen'),inputWindow:{resizeMode:false}};this.iframe=this.createFrame();this.lockScreenAgent=new LockScreenAgent(this.iframe);this.lockScreenAgent.start();AppWindow.call(this,this.configs);window.dispatchEvent(new CustomEvent('lockscreen-frame-bootstrap'));};LockScreenWindow.prototype=Object.create(AppWindow.prototype);LockScreenWindow.prototype.constructor=LockScreenWindow;LockScreenWindow.SUB_COMPONENTS={'transitionController':window.AppTransitionController,'statusbar':window.AppStatusbar};LockScreenWindow.REGISTERED_EVENTS=AppWindow.REGISTERED_EVENTS;LockScreenWindow.prototype.lockscreen=null;LockScreenWindow.prototype.HIERARCHY_MANAGER='LockScreenWindowManager';LockScreenWindow.prototype.eventPrefix='lockscreen-app';LockScreenWindow.prototype.openAnimation='immediate';LockScreenWindow.prototype.closeAnimation='fade-out';LockScreenWindow.prototype._DEBUG=false;LockScreenWindow.prototype.CLASS_LIST='appWindow lockScreenWindow';LockScreenWindow.prototype.CLASS_NAME='LockScreenWindow';LockScreenWindow.prototype._resize=function aw__resize(){var height,width;height=self.layoutManager.height;width=self.layoutManager.width;this.width=width;this.height=height;this.element.style.width=this.width+'px';this.element.style.height=this.height+'px';this.resized=true;this.publish('resize');};LockScreenWindow.prototype.createFrame=function lsw_createFrame(){var frame=document.getElementById('lockscreen-frame');frame.setVisible=function(){};frame.addNextPaintListener=function(cb){cb();};frame.removeNextPaintListener=function(){};frame.getScreenshot=function(){return{get onsuccess(){return null;},set onsuccess(cb){var mockEvent={target:{result:null}};cb(mockEvent);}};};frame.removeAttribute('hidden');return frame;};LockScreenWindow.prototype.getNotificationContainer=function lsw_getNotificationContainer(){return document.getElementById('notifications-lockscreen-container');};LockScreenWindow.prototype._resize=function lsw__resize(){var height,width;this.debug('force RESIZE...');if(this.inputWindow.isActive()){this.broadcast('withkeyboard');}else{this.broadcast('withoutkeyboard');}
height=this.layoutHeight();width=this.layoutWidth();this.width=width;this.height=height;this.element.style.width=this.width+'px';this.element.style.height=this.height+'px';this.browser.element.style.width='';this.browser.element.style.height='';this.resized=true;if(this.screenshotOverlay){this.screenshotOverlay.style.visibility='';}
this.publish('resize');this.debug('W:',this.width,'H:',this.height);};LockScreenWindow.prototype.layoutHeight=function lwm_layoutHeight(){if(!this.configs.inputWindow.resizeMode){return window.innerHeight;}
var softwareButtonHeight=this.isActive()?0:softwareButtonManager.height;var inputWindowHeight=0;if(this.states.instance&&this.states.instance.inputWindow.isActive()){inputWindowHeight=this.configs.inputWindow.height;}
var height=window.innerHeight-
inputWindowHeight-
softwareButtonHeight;var dpx=window.devicePixelRatio;if((height*dpx)%1!==0){height=Math.ceil(height*dpx)/dpx;}
return height;};LockScreenWindow.prototype.layoutWidth=function(){return window.innerWidth;};LockScreenWindow.prototype.lockOrientation=function(){var tryLockOrientation=()=>{if(screen.mozLockOrientation('portrait-primary')){if(!this.orientationLockID){throw new Error('No orientation ID. This function should only'+'be invoked as a interval callback');}
window.clearInterval(this.orientationLockID);this.orientationLockID=null;}};if(OrientationManager.isOnRealDevice()){if(this.orientationLockID){return;}
this.orientationLockID=window.setInterval(tryLockOrientation,4);}};exports.LockScreenWindow=LockScreenWindow;})(window);;'use strict';(function(exports){var LockScreenInputWindow=function(){var configs={url:window.location.href,manifest:{orientation:['default']},name:'LockscreenInputPad',manifestURL:window.location.href.replace('system','lockscreen-inputapp')+'/manifest.webapp',origin:window.location.origin.replace('system','lockscreen')};this.iframe=this.createFrame();AppWindow.call(this,configs);this.element.setAttribute('aria-hidden',true);window.dispatchEvent(new CustomEvent('lockscreen-inputpad-frame-bootstrap'));};LockScreenInputWindow.prototype=Object.create(AppWindow.prototype);LockScreenInputWindow.prototype._DEBUG=false;LockScreenInputWindow.prototype.eventPrefix='lockscreen-inputapp';LockScreenInputWindow.prototype.openAnimation='slide-from-bottom';LockScreenInputWindow.prototype.closeAnimation='slide-to-bottom';LockScreenInputWindow.prototype.CLASS_LIST='appWindow lockScreenInputWindow';LockScreenInputWindow.prototype.CLASS_NAME='LockScreenInputWindow';LockScreenInputWindow.prototype.createFrame=function(){var frame=document.getElementById('lockscreen-inputpad-frame');frame.setVisible=function(){};frame.addNextPaintListener=function(cb){cb();};frame.removeNextPaintListener=function(){};frame.getScreenshot=function(){return{get onsuccess(){return null;},set onsuccess(cb){var mockEvent={target:{result:null}};cb(mockEvent);}};};frame.removeAttribute('hidden');return frame;};exports.LockScreenInputWindow=LockScreenInputWindow;})(window);;'use strict';(function(exports){var LockScreenWindowManager=function(){};LockScreenWindowManager.prototype.setup=function lswm_setup(){this.elements={windows:null,screen:null};this.states={ready:false,FTUOccurs:false,enabled:true,instance:null,windowCreating:false};this.configs={inputWindow:{resizeMode:false,get height(){return 300;}},listens:['lockscreen-request-unlock','lockscreen-appcreated','lockscreen-appterminated','lockscreen-appclose','screenchange','system-resize','ftuopen','ftudone','overlaystart','showlockscreenwindow','secure-appclosed','lockscreen-request-inputpad-open','lockscreen-request-inputpad-close']};};LockScreenWindowManager.prototype.name='LockScreenWindowManager';LockScreenWindowManager.prototype.EVENT_PREFIX='lockscreenwindowmanager';LockScreenWindowManager.prototype.getActiveWindow=function(){return this.isActive()?this.states.instance:null;};LockScreenWindowManager.prototype.start=function lwm_start(){this.setup();this.startEventListeners();this.startObserveSettings();this.initElements();this.initWindow();Service.register('unlock',this);Service.register('lock',this);Service.request('registerHierarchy',this);};LockScreenWindowManager.prototype._handle_home=function(){if(this.isActive()){window.dispatchEvent(new CustomEvent('lockscreen-notify-homepressed'));return false;}
return true;};LockScreenWindowManager.prototype._handle_holdhome=function(){if(this.isActive()){return false;}
return true;};LockScreenWindowManager.prototype.respondToHierarchyEvent=function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}else{return true;}};LockScreenWindowManager.prototype.handleEvent=function lwm_handleEvent(evt){var app=null;switch(evt.type){case'overlaystart':if(this.isActive()){this.states.instance.setVisible(false);}
break;case'showlockscreenwindow':if(this.isActive()){this.states.instance.setVisible(true);}
break;case'ftuopen':this.states.FTUOccurs=true;this.closeApp(true);break;case'ftudone':this.states.FTUOccurs=false;break;case'lockscreen-request-unlock':this.responseUnlock(evt.detail);break;case'lockscreen-appcreated':app=evt.detail;this.registerApp(app);break;case'lockscreen-appterminated':app=evt.detail;this.unregisterApp(app);break;case'secure-appclosed':this.states.instance.lockOrientation();break;case'system-resize':if(this.states.instance&&this.states.instance.isActive()){this.states.instance.resize();}
break;case'screenchange':if('proximity'!==evt.detail.screenOffBy&&!this.states.FTUOccurs&&this.states.ready){this.openApp();if(evt.detail.screenEnabled&&this.states.instance&&this.isActive()&&!secureWindowManager.isActive()){this.states.instance.lockOrientation();}}
break;case'lockscreen-request-inputpad-open':this.onInputpadOpen();break;case'lockscreen-request-inputpad-close':this.onInputpadClose();break;}};LockScreenWindowManager.prototype.initElements=function lwm_initElements(){var selectors={windows:'windows',screen:'screen'};for(var name in selectors){var id=selectors[name];this.elements[name]=document.getElementById(id);}};LockScreenWindowManager.prototype.startObserveSettings=function lwm_startObserveSettings(){var enabledListener=(val)=>{this.states.ready=true;if('false'===val||false===val){this.states.enabled=false;}else if('true'===val||true===val){this.states.enabled=true;if(!this.states.instance){this.createWindow();}}};var lockListener=(event)=>{if(true===event.settingValue){this.openApp();}};window.SettingsListener.observe('lockscreen.enabled',true,enabledListener);navigator.mozSettings.addObserver('lockscreen.lock-immediately',lockListener);};LockScreenWindowManager.prototype.startEventListeners=function lwm_startEventListeners(){this.configs.listens.forEach((function _initEvent(type){self.addEventListener(type,this);}).bind(this));};LockScreenWindowManager.prototype.stopEventListeners=function lwm_stopEventListeners(){this.configs.listens.forEach((function _unbind(ename){self.removeEventListener(ename,this);}).bind(this));};LockScreenWindowManager.prototype.closeApp=function lwm_closeApp(instant){if(!this.states.enabled||!this.isActive()){return;}
this.states.instance.close(instant?'immediate':undefined);this.elements.screen.classList.remove('locked');this.toggleLockedSetting(false);this.publish(this.EVENT_PREFIX+'-deactivated',this);};LockScreenWindowManager.prototype.openApp=function lwm_openApp(){if(!this.states.enabled){return;}
if(!this.states.instance){var app=this.createWindow();app.open();}else{this.states.instance.open();}
this.elements.screen.classList.add('locked');this.toggleLockedSetting(true);this.publish(this.EVENT_PREFIX+'-activated',this);};LockScreenWindowManager.prototype.publish=function lwm_publish(ne,detail){var event=new CustomEvent(ne,{detail:detail});window.dispatchEvent(event);};LockScreenWindowManager.prototype.registerApp=function lwm_registerApp(app){this.states.instance=app;};LockScreenWindowManager.prototype.unregisterApp=function lwm_unregisterApp(app){this.states.instance=null;};LockScreenWindowManager.prototype.createWindow=function lwm_createWindow(){if(this.states.windowCreating){return false;}
this.states.windowCreating=true;var app=new LockScreenWindow();app.inputWindow=new LockScreenInputWindow();this.states.windowCreating=false;return app;};LockScreenWindowManager.prototype.initWindow=function lwm_initWindow(){var req=window.SettingsListener.getSettingsLock().get('lockscreen.enabled');req.onsuccess=()=>{this.states.ready=true;if(true===req.result['lockscreen.enabled']||'true'===req.result['lockscreen.enabled']){this.states.enabled=true;}else if(false===req.result['lockscreen.enabled']||'false'===req.result['lockscreen.enabled']){this.states.enabled=false;}
this.openApp();};};LockScreenWindowManager.prototype.unlock=function lwm_unlock(detail){this.publish('lockscreen-request-unlock',detail);};LockScreenWindowManager.prototype.responseUnlock=function lwm_responseUnlock(detail){var forcibly=(detail&&detail.forcibly)?true:false;this.closeApp(forcibly);};LockScreenWindowManager.prototype.lock=function lwm_lock(detail){this.openApp();};LockScreenWindowManager.prototype.getInstance=function lwm_getInstance(){return this.states.instance;};LockScreenWindowManager.prototype.isActive=function lwm_isActive(){if(null===this.states.instance){return false;}else{return this.states.instance.isActive();}};LockScreenWindowManager.prototype.onInputpadOpen=function lwm_onInputpadOpen(){this.states.instance.inputWindow.open();this.states.instance.resize();};LockScreenWindowManager.prototype.onInputpadClose=function lwm_onInputpadClose(){this.states.instance.inputWindow.close();this.states.instance.resize();};LockScreenWindowManager.prototype.toggleLockedSetting=function lswm_toggleLockedSetting(value){if(!window.navigator.mozSettings){return;}
window.SettingsListener.getSettingsLock().set({'lockscreen.locked':value});};exports.LockScreenWindowManager=LockScreenWindowManager;})(window);;'use strict';(function(exports){var VisibilityManager=function VisibilityManager(){this._normalAudioChannelActive=false;this._deviceLockedTimer=0;this.overlayEvents=['lockscreen-appopened','lockscreen-request-unlock','attentionwindowmanager-deactivated','attentionopened','mozChromeEvent','appclosing','homescreenopened','searchrequestforeground','apprequestforeground','lockscreen-apprequestforeground','secure-apprequestforeground','homescreenrequestforeground'];};VisibilityManager.prototype.DEBUG=false;VisibilityManager.prototype.CLASS_NAME='VisibilityManager';VisibilityManager.prototype.start=function start(){this.overlayEvents.forEach(function overlayEventIterator(event){window.addEventListener(event,this);},this);};VisibilityManager.prototype.handleEvent=function vm_handleEvent(evt){this.debug('handling '+evt.type+' event..');switch(evt.type){case'searchrequestforeground':case'homescreenrequestforeground':case'lockscreen-apprequestforeground':case'secure-apprequestforeground':if(!attentionWindowManager.hasActiveWindow()){evt.detail.setVisible(true);}
break;case'apprequestforeground':if(!Service.locked&&!attentionWindowManager.hasActiveWindow()){evt.detail.setVisible(true);}
break;case'appclosing':case'homescreenopened':this._normalAudioChannelActive=false;break;case'attentionwindowmanager-deactivated':if(window.Service.locked){this.publish('showlockscreenwindow');return;}
this.publish('showwindow',{type:evt.type});this._resetDeviceLockedTimer();break;case'lockscreen-request-unlock':var detail=evt.detail,activity=null,notificationId=null;if(detail){activity=detail.activity;notificationId=detail.notificationId;}
if(!attentionWindowManager.hasActiveWindow()){this.publish('showwindow',{activity:activity,notificationId:notificationId});}
this._resetDeviceLockedTimer();break;case'lockscreen-appopened':this.debug('locking, hide the whole windows',this._normalAudioChannelActive);if(!this._normalAudioChannelActive){this.publish('hidewindow',{screenshoting:false,type:evt.type});}
this._resetDeviceLockedTimer();break;case'attentionopened':if(!Service.locked){this.publish('hidewindow',{type:evt.type});}
break;case'mozChromeEvent':if(evt.detail.type=='visible-audio-channel-changed'){this._resetDeviceLockedTimer();if(this._normalAudioChannelActive&&evt.detail.channel!=='normal'&&window.Service.locked){this._deviceLockedTimer=setTimeout(function setVisibility(){if(window.Service.locked){this.publish('hidewindow',{screenshoting:false,type:evt.type});}}.bind(this),3000);}
this._normalAudioChannelActive=(evt.detail.channel==='normal');this.debug('Normal AudioChannel changes to ',evt.detail.channel,this._normalAudioChannelActive);}
break;}};VisibilityManager.prototype._resetDeviceLockedTimer=function vm_resetDeviceLockedTimer(){if(this._deviceLockedTimer){clearTimeout(this._deviceLockedTimer);this._deviceLockedTimer=0;}};VisibilityManager.prototype.publish=function vm_publish(eventName,detail){this.debug('publishing: ',eventName);var evt=new CustomEvent(eventName,{detail:detail});window.dispatchEvent(evt);};VisibilityManager.prototype.debug=function vm_debug(){if(this.DEBUG){console.log('['+this.CLASS_NAME+']'+'['+Service.currentTime()+']'+
Array.slice(arguments).concat());}};exports.VisibilityManager=VisibilityManager;}(window));;'use strict';(function(exports){var LayoutManager=function LayoutManager(){};LayoutManager.prototype={DEBUG:false,CLASS_NAME:'LayoutManager',get clientWidth(){if(this._clientWidth){return this._clientWidth;}
this._clientWidth=document.documentElement.clientWidth;return this._clientWidth;},get height(){var activeApp=Service.currentApp;var isFullScreenLayout=activeApp&&activeApp.isFullScreenLayout();var softwareButtonHeight=Service.locked||isFullScreenLayout?0:softwareButtonManager.height;var keyboardHeight=this.keyboardEnabled?inputWindowManager.getHeight():0;var height=window.innerHeight-keyboardHeight-softwareButtonHeight;var dpx=window.devicePixelRatio;if((height*dpx)%1!==0){height=Math.ceil(height*dpx)/dpx;}
return height;},get width(){return window.innerWidth-
((Service.currentApp&&Service.currentApp.isFullScreenLayout())?0:softwareButtonManager.width);},getHeightFor:function(currentWindow,ignoreKeyboard){if(currentWindow instanceof AttentionWindow){var keyboardHeight=this.keyboardEnabled&&!ignoreKeyboard?inputWindowManager.getHeight():0;var height=window.innerHeight-keyboardHeight-
softwareButtonManager.height;var dpx=window.devicePixelRatio;if((height*dpx)%1!==0){height=Math.ceil(height*dpx)/dpx;}
return height;}
if(ignoreKeyboard){return this.height+inputWindowManager.getHeight();}else{return this.height;}},match:function lm_match(width,height){return(this.width===width&&this.height===height);},keyboardEnabled:false,_lastOrientation:undefined,start:function lm_start(){window.addEventListener('resize',this);window.addEventListener('keyboardchange',this);window.addEventListener('keyboardhide',this);window.addEventListener('mozfullscreenchange',this);window.addEventListener('software-button-enabled',this);window.addEventListener('software-button-disabled',this);window.addEventListener('attentionwindowmanager-deactivated',this);window.addEventListener('lockscreen-appclosed',this);this._lastOrientation=screen.mozOrientation;},handleEvent:function lm_handleEvent(evt){this.debug('resize event got: ',evt.type);switch(evt.type){case'keyboardchange':if(document.mozFullScreen){document.mozCancelFullScreen();}
this.keyboardEnabled=true;this.publish('system-resize');break;case'resize':if(!(screen.mozOrientation!==this._lastOrientation&&this.keyboardEnabled)){this.publish('system-resize');}
this.publish('orientationchange');this._lastOrientation=screen.mozOrientation;break;case'lockscreen-appclosed':if(softwareButtonManager.enabled){this.publish('system-resize');}
break;default:if(evt.type==='keyboardhide'){this.keyboardEnabled=false;}
this.publish('system-resize');break;}},publish:function lm_publish(event,detail){var evt=document.createEvent('CustomEvent');evt.initCustomEvent(event,true,false,detail||this);this.debug('publish: '+event);window.dispatchEvent(evt);},debug:function lm_debug(){if(this.DEBUG){console.log('['+this.CLASS_NAME+']'+'['+Service.currentTime()+'] '+
Array.slice(arguments).concat());}}};exports.LayoutManager=LayoutManager;}(window));;'use strict';(function(window){var SuspendingAppPriorityManager=function(){this.init();};SuspendingAppPriorityManager.prototype.init=function(){window.addEventListener('appsuspended',this);window.addEventListener('appresumed',this);};SuspendingAppPriorityManager.prototype.suspendedCount=0;SuspendingAppPriorityManager.prototype.MAXIMUM_SUSPENDED_COUNT=10;SuspendingAppPriorityManager.prototype._DEBUG=false;SuspendingAppPriorityManager.prototype.handleEvent=function(evt){switch(evt.type){case'appsuspended':this.suspendedCount++;this.debug('suspending app count increases to '+this.suspendedCount);this._handleSuspendingAppCountChanged();break;case'appresumed':this.suspendedCount--;this.debug('suspending app count decreases to '+this.suspendedCount);break;}};SuspendingAppPriorityManager.prototype._handleSuspendingAppCountChanged=function(){if(this.suspendedCount>this.MAXIMUM_SUSPENDED_COUNT){this.debug('exceed maximum suspending count, find someone to kill..');var stack=self.StackManager._stack;var current=self.StackManager._current;this.debug(stack.length,current);for(var i=current;i<current+stack.length;i++){var index=i%stack.length;var candidate=stack[index];this.debug(index,candidate.name,candidate.suspended);if(candidate.suspended){this.debug('killing zombie app: '+candidate.name);candidate.kill();return;}}}};SuspendingAppPriorityManager.prototype.debug=function(){if(this._DEBUG){console.log('[SuspendingAppPriorityManager]'+'['+self.Service.currentTime()+'] '+
Array.slice(arguments).concat());}};window.SuspendingAppPriorityManager=SuspendingAppPriorityManager;}(self));;'use strict';(function(exports){var InputWindow=function(configs){configs.isInputMethod=true;configs.name='InputMethods';configs.url=configs.origin+configs.path;this.splashed=true;this._pendingReady=false;AppWindow.call(this,configs);this.transitionController.OPENING_TRANSITION_TIMEOUT=5000;this.transitionController.CLOSING_TRANSITION_TIMEOUT=5000;this.browser.element.dataset.frameName=configs.id;};InputWindow.prototype=Object.create(AppWindow.prototype);InputWindow.prototype.constructor=InputWindow;InputWindow.REGISTERED_EVENTS=['mozbrowsererror'];InputWindow.SUB_COMPONENTS={'transitionController':AppTransitionController};InputWindow.prototype.containerElement=document.getElementById('keyboards');InputWindow.prototype.view=function iw_view(){return`<div class="${this.CLASS_LIST}" id="${this.instanceID}"
            transition-state="closed">
              <div class="browser-container"></div>
           </div>`;};InputWindow.prototype.eventPrefix='input-app';InputWindow.prototype.openAnimation='slide-from-bottom';InputWindow.prototype.closeAnimation='slide-to-bottom';InputWindow.prototype._DEBUG=false;InputWindow.prototype.CLASS_LIST='inputWindow';InputWindow.prototype.CLASS_NAME='InputWindow';InputWindow.prototype._handle_mozbrowserresize=function iw_handle_mozbrowserresize(evt){var height=evt.detail.height;this._setHeight(height);this.publish('ready');if('opened'===this.transitionController._transitionState){this.publish('heightchanged');}
evt.stopPropagation();};InputWindow.prototype._handle__ready=function iw_handle__ready(evt){this.element.removeEventListener('_ready',this);this._pendingReady=false;this._setHeight(evt.detail.height);AppWindow.prototype.open.call(this,this.immediateOpen?'immediate':undefined);};InputWindow.prototype._setHeight=function iw_setHeight(height){var dpx=window.devicePixelRatio;if((height*dpx)%1!==0){height=Math.floor(height*dpx)/dpx;}
this.height=height;};InputWindow.prototype._setAsActiveInput=function iw_setAsActiveInput(active){this.debug('setAsActiveInput: '+this.manifestURL+this.path+', active: '+active);this.setVisible(active);if(this.browser.element.setInputMethodActive){this.browser.element.setInputMethodActive(active);}else{console.warn('setInputMethodActive is not available');}
if(active){this.browser.element.addEventListener('mozbrowserresize',this,true);this.element.classList.add('top-most');}else{this.browser.element.removeEventListener('mozbrowserresize',this,true);this.element.classList.remove('top-most');this.height=0;}};InputWindow.prototype.lockOrientation=function iw_setOrientation(){};InputWindow.prototype.setOrientation=function iw_setOrientation(){};InputWindow.prototype.close=function iw_close(immediate){this.element.removeEventListener('_ready',this);AppWindow.prototype.close.call(this,immediate);};InputWindow.prototype.open=function iw_open(configs){var hashChanged=false;if(configs.hash!==this.hash){this.browser.element.src=this.origin+this.pathInitial+configs.hash;this.debug(this.browser.element.frameName+' is overwritten: '+
this.browser.element.src);this.browser.element.dataset.frameName=configs.id;this.hash=configs.hash;hashChanged=true;}
this.immediateOpen=configs.immediateOpen;this.element.addEventListener('_ready',this);this._pendingReady=true;this._setAsActiveInput(true);if(!hashChanged&&'closing'===this.transitionController._transitionState){this.immediateOpen=true;this.publish('ready');}};exports.InputWindow=InputWindow;})(window);;'use strict';var StackManager={init:function sm_init(){window.addEventListener('appcreated',this);window.addEventListener('launchapp',this);window.addEventListener('appopening',this);window.addEventListener('appopened',this);window.addEventListener('appterminated',this);window.addEventListener('homescreenopened',this);window.addEventListener('cardviewclosed',this);},getCurrent:function sm_getCurrent(){if(this.position<0){return undefined;}
var app=this._currentFromStack();if(!app){app=Service.currentApp;}
return app;},_currentFromStack:function sm_currentInStack(){return this._stack[this.position].getActiveWindow();},outOfStack:function sm_outOfStack(){return(this._currentFromStack()!==this.getCurrent());},getPrev:function sm_getPrev(){if(this.outOfStack()){return undefined;}
var inGroupPrev=this._currentFromStack().getPrev();if(inGroupPrev){return inGroupPrev;}
var previousGroup=this._stack[this.position-1];if(previousGroup){return previousGroup.getLeafWindow();}
return undefined;},getNext:function sm_getNext(){if(this.outOfStack()){return undefined;}
var inGroupNext=this._currentFromStack().getNext();if(inGroupNext){return inGroupNext;}
var nextGroup=this._stack[this.position+1];if(nextGroup){return nextGroup.getRootWindow();}
return undefined;},goPrev:function sm_goPrev(){var oldApp=this.getCurrent();var newApp=this.getPrev();if(!oldApp||!newApp){return;}
this._queueBroadcast(newApp,oldApp);if(newApp.groupID!==oldApp.groupID){this.position--;}},goNext:function sm_goNext(){var oldApp=this.getCurrent();var newApp=this.getNext();if(!oldApp||!newApp){return;}
this._queueBroadcast(newApp,oldApp);if(newApp.groupID!==oldApp.groupID){this.position++;}},commit:function sm_commit(){if(this._didntMove){window.dispatchEvent(new CustomEvent('sheets-gesture-end'));var current=this.getCurrent();current&&current.setNFCFocus(true);}
if(!this._broadcastTimeout){this._broadcast();}},commitClose:function sm_commitClose(){clearTimeout(this._broadcastTimeout);this._broadcastTimeout=null;if(this._appIn){this._appIn.broadcast('closed');}
if(this._appOut){this._appOut.transitionController.clearTransitionClasses();}
this._cleanUp();},snapshot:function sm_snapshot(){return this._stack.slice(0);},get length(){return this._stack.length;},get position(){return this._current;},get _didntMove(){return(!this._appIn&&!this._appOut)||(!!this._appIn&&this._appIn===this._appOut);},set position(position){var _position=parseInt(position);if(_position<-1||_position>=this._stack.length){console.warn('bad stack position. requested position = ',_position,'; stack length = ',this._stack.length);return;}
this._current=_position;},_stack:[],_current:-1,handleEvent:function sm_handleEvent(e){switch(e.type){case'appcreated':var app=e.detail;if(app.manifest&&app.manifest.role=='system'){return;}
if(app.name=='FTU'){return;}
if(app.previousWindow){return;}
if(app.stayBackground){this._insertBelow(app);}else{this._moveToTop(this.position);this._insertOnTop(app);}
break;case'launchapp':var config=e.detail;if(!config.stayBackground){this._moveToTop(this.position);var idx=this._indexOfURL(config.url);if(idx!==undefined){this._moveToTop(idx);}}
break;case'appopening':case'appopened':var app=e.detail;var root=app.getRootWindow();var id=this._indexOfInstanceID(root.instanceID);if(id!==undefined&&id!==this._current){this._current=id;}
break;case'homescreenopened':if(window.taskManager&&window.taskManager.isShown()){return;}
this._moveToTop(this.position);this.position=-1;this.commitClose();break;case'appterminated':var instanceID=e.detail.instanceID;this._remove(instanceID);break;case'cardviewclosed':if(e.detail&&e.detail.newStackPosition){this.position=e.detail.newStackPosition;}
break;}
this._stackChanged();},_insertBelow:function sm_insertBelow(app){this._stack.splice(0,0,app);if(this._stack.length>1){this.position++;}else{this.position=0;}},_insertOnTop:function sm_insertOnTop(app){this.position=this._stack.push(app)-1;},_moveToTop:function sm_moveToTop(index){if(index===-1||index>=this._stack.length){return;}
var sheet=this._stack.splice(index,1)[0];this.position=this._stack.push(sheet)-1;},_indexOfURL:function sm_indexOfURL(url){var result;this._stack.some(function(app,idx){if(app.url==url){result=idx;return true;}
return false;});return result;},_indexOfInstanceID:function sm_indexOfIntanceID(instanceID){var result;this._stack.some(function(app,idx){if(app.instanceID==instanceID){result=idx;return true;}false;});return result;},_remove:function sm_remove(instanceID){for(var i=(this._stack.length-1);i>=0;i--){var sConfig=this._stack[i];if(sConfig.instanceID==instanceID){this._stack.splice(i,1);if(i<=this.position&&this.position>=0){this.position--;}
return;}}},_stackChanged:function sm_stackChanged(){var details={position:this.position,sheets:this._stack};var evt=new CustomEvent('stackchanged',{detail:details});window.dispatchEvent(evt);},_broadcastTimeout:null,_appIn:null,_appOut:null,_queueBroadcast:function sm_queueBroadcast(appIn,appOut){if(this._appIn){this._appIn.cancelQueuedShow();}
this._appIn=appIn;appIn.queueShow();if(!this._appOut){this._appOut=appOut;appOut.queueHide();}
if(this._broadcastTimeout===null){appWindowManager.sendStopRecordingRequest();}
clearTimeout(this._broadcastTimeout);this._broadcastTimeout=setTimeout(this._broadcast.bind(this),800);},_broadcast:function sm_broadcast(close){clearTimeout(this._broadcastTimeout);this._broadcastTimeout=null;if(SheetsTransition.transitioning){return;}
if(this._didntMove){this._appIn&&this._appIn.transitionController.clearTransitionClasses();this._cleanUp();return;}
window.dispatchEvent(new CustomEvent('sheets-gesture-end'));if(this._appIn){this._appIn.broadcast('swipein');}
if(this._appOut){this._appOut.broadcast('swipeout');}
this._cleanUp();this._stackChanged();},_cleanUp:function sm_cleanUp(){this._appIn=null;this._appOut=null;},_dump:function sm_dump(){var prefix='StackManager';for(var i=0;i<this._stack.length;i++){var separator=(i==this.position)?' * ':' - ';console.log(prefix+separator+i+' -> '+this._stack[i].name+'/'+this._stack[i].instanceID);var child=this._stack[i].nextWindow;while(child){var separator2=(child.isActive())?' @ ':' = ';console.log(prefix+separator2+i+' ---> '+this._stack[i].name+'/'+this._stack[i].instanceID);child=child.nextWindow;}}},__clearAll:function sm_clearAll(){this._stack=[];this.position=0;}};StackManager.init();;'use strict';var SheetsTransition={transitioning:false,_current:null,_new:null,init:function st_init(){SettingsListener.observe('edgesgesture.enabled',false,this._settingUpdate.bind(this));},begin:function st_begin(direction){this.transitioning=true;this._cleanupPreviousTransitions();var home=homescreenLauncher.getHomescreen();home&&home.fadeOut();var currentApp=StackManager.getCurrent();var newApp=(direction=='ltr')?StackManager.getPrev():StackManager.getNext();newApp&&newApp.broadcast('sheetdisplayed');this._current=currentApp?currentApp.element:null;this._new=newApp?newApp.element:null;if(this._current){this._setDuration(this._current,0);this._current.classList.add('inside-edges');currentApp&&currentApp.setNFCFocus(false);}
if(this._new){this._setDuration(this._new,0);this._new.classList.toggle('outside-edges-left',(direction=='ltr'));this._new.classList.toggle('outside-edges-right',(direction=='rtl'));}
window.dispatchEvent(new CustomEvent('sheets-gesture-begin'));},_lastProgress:null,moveInDirection:function st_moveInDirection(direction,progress){var overflowing=!this._new;if(overflowing&&(progress>0.20)){progress=0.20+(progress-0.20)/(2+progress);}
this._lastProgress=progress;var factor=(direction=='ltr')?1:-1;var offset=(direction=='ltr')?'- 2rem':'+ 2rem';this._setTranslate(this._current,progress*factor*100);this._setTranslate(this._new,(progress-1)*factor*100,offset);},end:function st_end(){var commited=false;this.transitioning=false;var sheets=[this._current,this._new];sheets.forEach(function(sheet){if(!sheet){return;}
function finish(){sheet.classList.remove('inside-edges');sheet.classList.remove('outside-edges-left');sheet.classList.remove('outside-edges-right');sheet.style.transition='';if(!commited){commited=true;StackManager.commit();}}
if(!sheet.style.transform){finish();return;}
sheet.style.transform='';sheet.addEventListener('transitionend',function trWait(evt){if(evt.propertyName!='transform'){return;}
sheet.removeEventListener('transitionend',trWait);finish();});});this._current=null;this._new=null;},snapInPlace:function st_snapInPlace(){var TIMEOUT=300;var duration=TIMEOUT-(TIMEOUT*(1-this._lastProgress));duration=Math.max(duration,90);this._setDuration(this._current,duration);this._setDuration(this._new,duration);this.end();},snapBack:function st_snapBack(speed){this._snapAway(speed,'outside-edges-right');},snapForward:function st_snapForward(speed){this._snapAway(speed,'outside-edges-left');},_snapAway:function st_snapAway(speed,outClass){if(!this._new){this.snapInPlace();return;}
var durationLeft=(1-this._lastProgress)/speed;durationLeft/=1.2;var duration=Math.min(durationLeft,((1-this._lastProgress)*300));this._setDuration(this._current,duration);this._setDuration(this._new,duration);if(this._current){this._current.classList.remove('inside-edges');this._current.classList.add(outClass);}
if(this._new){this._new.classList.remove('outside-edges-right');this._new.classList.remove('outside-edges-left');this._new.classList.add('inside-edges');}
this.end();},_setTranslate:function st_setTranslate(sheet,percentage,offset){if(!sheet){return;}
var transform;if(offset){transform='translateX(calc('+percentage+'% '+offset+'))';}else{transform='translateX('+percentage+'%)';}
sheet.style.transform=transform;},_setDuration:function st_setDuration(sheet,ms){if(!sheet){return;}
sheet.style.transition='transform '+ms+'ms linear';},_cleanupPreviousTransitions:function st_cleanUpPreviousTransitions(){var sheets=[this._current,this._new];sheets.forEach(function(sheet){if(sheet){sheet.style.transform='';sheet.classList.remove('inside-edges');sheet.classList.remove('outside-edges-left');sheet.classList.remove('outside-edges-right');sheet.style.transition='';}});},_edgesEnabled:false,_settingUpdate:function st_settingUpdate(enabled){this._edgesEnabled=enabled;}};SheetsTransition.init();;'use strict';(function(exports){const kEdgeIntertia=250;const kEdgeThreshold=0.3;const kEdgeAngleThreshold=Math.PI/6;const kSignificant=5*window.devicePixelRatio;function EdgeSwipeDetector(){}
EdgeSwipeDetector.prototype={previous:document.getElementById('left-panel'),next:document.getElementById('right-panel'),screen:document.getElementById('screen'),_touchForwarder:null,start:function esd_init(){window.addEventListener('homescreenopened',this);window.addEventListener('appopened',this);window.addEventListener('cardviewclosed',this);window.addEventListener('mozChromeEvent',this);window.addEventListener('updatepromptshown',this);window.addEventListener('updateprompthidden',this);window.addEventListener('installpromptshown',this);window.addEventListener('installprompthidden',this);window.addEventListener('rocketbar-activating',this);window.addEventListener('rocketbar-deactivated',this);window.addEventListener('shrinking-start',this);window.addEventListener('shrinking-stop',this);['touchstart','touchmove','touchend','mousedown','mousemove','mouseup'].forEach(function(e){this.previous.addEventListener(e,this);this.next.addEventListener(e,this);},this);this._touchForwarder=new TouchForwarder();SettingsListener.observe('edgesgesture.enabled',false,this.settingUpdate.bind(this));SettingsListener.observe('edgesgesture.debug',false,this.debugUpdate.bind(this));},_settingEnabled:false,settingUpdate:function esd_settingUpdate(enabled){this._settingEnabled=enabled;this._updateEnabled();},debugUpdate:function esd_debugUpdate(enabled){this.screen.classList.toggle('edges-debug',enabled);},_lifecycleEnabled:false,get lifecycleEnabled(){return this._lifecycleEnabled;},set lifecycleEnabled(enable){this._lifecycleEnabled=enable;this._updateEnabled();},handleEvent:function esd_handleEvent(e){switch(e.type){case'mousedown':case'mousemove':case'mouseup':e.preventDefault();break;case'touchstart':e.preventDefault();this._touchStart(e);break;case'touchmove':e.preventDefault();this._touchMove(e);break;case'touchend':e.preventDefault();this._touchEnd(e);break;case'appopened':var app=e.detail;if(!app.stayBackground){this.lifecycleEnabled=(app.origin!==FtuLauncher.getFtuOrigin());}
break;case'homescreenopened':case'rocketbar-activating':case'shrinking-start':this.lifecycleEnabled=false;break;case'cardviewclosed':if(e.detail&&e.detail.newStackPosition){this.lifecycleEnabled=true;}
break;case'mozChromeEvent':if(e.detail.type!=='accessibility-control'){break;}
var details=JSON.parse(e.detail.details);switch(details.eventType){case'edge-swipe-right':this.autoSwipe('ltr');break;case'edge-swipe-left':this.autoSwipe('rtl');break;}
break;case'updatepromptshown':case'installpromptshown':this.lifecycleEnabled=false;break;case'updateprompthidden':case'installprompthidden':case'rocketbar-deactivated':case'shrinking-stop':if(Service.currentApp&&!Service.currentApp.isHomescreen){this.lifecycleEnabled=true;}
break;}},_updateEnabled:function esd_updateEnabled(){var enabled=this._lifecycleEnabled&&this._settingEnabled;this.previous.classList.toggle('disabled',!enabled);this.next.classList.toggle('disabled',!enabled);if(!enabled&&this._touchStartEvt){this._touchStartEvt=null;SheetsTransition.snapInPlace();}},_touchStartEvt:null,_startDate:null,_startX:null,_deltaX:null,_startY:null,_deltaY:null,_forwardTimeout:null,_progress:null,_winWidth:null,_beganTransition:null,_moved:null,_direction:null,_forwarding:null,_redispatching:null,_touchStart:function esd_touchStart(e){this._winWidth=window.innerWidth;this._direction=(e.target==this.next)?'rtl':'ltr';this._touchStartEvt=e;this._startDate=Date.now();var iframe=StackManager.getCurrent().getTopMostWindow().iframe;this._touchForwarder.destination=iframe;var touch=e.changedTouches[0];this._startX=touch.clientX;this._startY=touch.clientY;this._deltaX=0;this._deltaY=0;this._beganTransition=false;this._moved=false;this._forwarding=false;this._redispatching=false;this._clearForwardTimeout();this._forwardTimeout=setTimeout((function longTouch(){this._forwardTimeout=null;this._forwarding=true;this._forward(this._touchStartEvt);}).bind(this),300);},_touchMove:function esd_touchMove(e){if(!this._touchStartEvt){return;}
var touch=e.touches[0];this._updateProgress(touch);var delta=Math.max(Math.abs(this._deltaX),Math.abs(this._deltaY));if(this._forwarding){this._forward(e);return;}
if(e.touches.length>1){this._startForwarding(e);return;}
if(delta>kSignificant&&!this._horizontalGesture()){this._startForwarding(e);return;}
if(!this._beganTransition){SheetsTransition.begin(this._direction);this._clearForwardTimeout();this._beganTransition=true;}
if((this._deltaX<kSignificant||this._outsideApp(e))&&!this._moved){return;}
SheetsTransition.moveInDirection(this._direction,this._progress);this._moved=true;},_touchEnd:function esd_touchEnd(e){if(!this._touchStartEvt){return;}
var touches=e.touches.length+e.changedTouches.length;if(touches>1&&!this._forwarding){this._touchStartEvt=null;SheetsTransition.snapInPlace();return;}
var touch=e.changedTouches[0];this._updateProgress(touch);if(this._forwarding){this._forward(e);}else if((this._deltaX<5)&&(this._deltaY<5)){setTimeout(function(self,touchstart,touchend){self._forward(touchstart);setTimeout(function(){self._forward(touchend);},100);},0,this,this._touchStartEvt,e);this._forwarding=true;}
this._clearForwardTimeout();var deltaT=Date.now()-this._startDate;var speed=this._progress/deltaT;var inertia=speed*kEdgeIntertia;var adjustedProgress=(this._progress+inertia);if(adjustedProgress<kEdgeThreshold||this._forwarding){SheetsTransition.snapInPlace();return;}
var direction=this._direction;if(direction=='ltr'){SheetsTransition.snapBack(speed);StackManager.goPrev();}else{SheetsTransition.snapForward(speed);StackManager.goNext();}},_updateProgress:function esd_updateProgress(touch){this._deltaX=touch.clientX-this._startX;this._deltaY=touch.clientY-this._startY;if(this._direction=='rtl'){this._deltaX*=-1;this._deltaY*=-1;}
this._progress=this._deltaX/this._winWidth;},_horizontalGesture:function esd_horizontalGesture(){var angle=Math.atan2(this._deltaX,this._deltaY);var horizontalAngle=Math.PI/2;return Math.abs(angle-horizontalAngle)<kEdgeAngleThreshold;},_clearForwardTimeout:function esd_clearForwardTimeout(){if(this._forwardTimeout){clearTimeout(this._forwardTimeout);this._forwardTimeout=null;}},_startForwarding:function esd_startForwarding(e){this._clearForwardTimeout();this._forwarding=true;this._forward(this._touchStartEvt);this._forward(e);if(this._beganTransition){SheetsTransition.snapInPlace();}},_forward:function esd_forward(e){if(this._moved){return;}
if(this._outsideApp(e)||this._redispatching){window.dispatchEvent(new CustomEvent('edge-touch-redispatch',{bubbles:true,detail:e}));this._redispatching=true;}else{this._touchForwarder.forward(e);}},_outsideApp:function esd_outsideApp(e){var touch=(e.type==='touchend')?e.changedTouches[0]:e.touches[0];var x=touch.pageX;var y=touch.pageY;var softwareButtonOverlayed=Service.currentApp&&Service.currentApp.isFullScreenLayout();if(softwareButtonOverlayed){return x>(layoutManager.width-softwareButtonManager.width)||y>(layoutManager.height-softwareButtonManager.height);}
return(x>layoutManager.width||y>layoutManager.height);},autoSwipe:function esd_autoSwipe(direction){if(!this._lifecycleEnabled){return;}
SheetsTransition.begin(direction);if(direction==='ltr'){SheetsTransition.snapBack(1);StackManager.goPrev();}else{SheetsTransition.snapForward(1);StackManager.goNext();}}};exports.EdgeSwipeDetector=EdgeSwipeDetector;}(window));;'use strict';var EntrySheet=(function invocation(){function EntrySheet(){render.apply(this,arguments);}
EntrySheet.className='entrySheet';EntrySheet.prototype.setTitle=function(title){this.titleElement.textContent=title;};EntrySheet.prototype.open=function(){setTimeout(function(){this.element.classList.add('active');}.bind(this));};EntrySheet.prototype.close=function(){this.element.addEventListener('transitionend',function onTransitionend(){this.element.removeEventListener('transitionend',onTransitionend);this.element.classList.remove('disappearing');this.element.classList.remove('active');this.container.removeChild(this.element);}.bind(this));this.element.classList.add('disappearing');};function view(){return`<div class="${EntrySheet.className}">
      <section role="region" class="skin-organic header">
        <gaia-header action="close">
          <h1 class="title">
            <bdi class="${EntrySheet.className}-title"></bdi>
          </h1>
        </gaia-header>
        <div class="throbber"></div>
      </section>
      <div class="content">
      </div>
    </div>`;}
function render(container,title,content){this.container=container;this.title=title;this.container.insertAdjacentHTML('beforeend',view.apply(this));this.header=this.container.querySelector('.'+EntrySheet.className+' gaia-header');this.titleElement=this.container.querySelector('.'+EntrySheet.className+'-title');this.throbberElement=this.container.querySelector('.'+EntrySheet.className+' .throbber');this.content=this.container.querySelector('.'+EntrySheet.className+' .content');this.element=this.container.querySelector('.'+EntrySheet.className);this.element.dataset.zIndexLevel='dialog-overlay';var self=this;if(typeof(BrowserFrame)!='undefined'&&content instanceof BrowserFrame){content.element.addEventListener('mozbrowserloadstart',function onLoadStart(){self.throbberElement.dataset.loading=true;});content.element.addEventListener('mozbrowserloadend',function onLoadEnd(){delete self.throbberElement.dataset.loading;});this.content.appendChild(content.element);}else if(content&&content.nodeType==1){this.content.appendChild(content);}
this.setTitle(this.title);this.header.addEventListener('action',function(){self.close();});}
return EntrySheet;}());;'use strict';(function(exports){function RemoteDebugger(){window.addEventListener('mozChromeEvent',this);}
RemoteDebugger.prototype={handleEvent:function(e){if(e.detail.type!=='remote-debugger-prompt'){return;}
if(!ScreenManager.screenEnabled){ScreenManager.turnScreenOn();}
ModalDialog.showWithPseudoEvent({text:'remoteDebuggerMessage',type:'confirm',callback:this._dispatchEvent.bind(this,true),cancel:this._dispatchEvent.bind(this,false)});},_dispatchEvent:function(value){var event=document.createEvent('CustomEvent');event.initCustomEvent('mozContentEvent',true,true,{type:'remote-debugger-prompt',value:value});window.dispatchEvent(event);}};exports.RemoteDebugger=RemoteDebugger;}(window));;(function(exports){'use strict';function LogShake(){}
function debug(str){dump('LogShake: '+str+'\n');}
LogShake.prototype={start:function(){this.startCaptureLogsListener();},startCaptureLogsListener:function(){debug('starting captureLogs listener');window.addEventListener('capture-logs-start',this);window.addEventListener('capture-logs-success',this);window.addEventListener('capture-logs-error',this);},stopCaptureLogsListener:function(){debug('stopping captureLogs listener');window.removeEventListener('capture-logs-start',this);window.removeEventListener('capture-logs-success',this);window.removeEventListener('capture-logs-error',this);},handleEvent:function(event){debug('handling event '+event.type);switch(event.type){case'capture-logs-start':this.handleCaptureLogsStart(event);break;case'capture-logs-success':this.handleCaptureLogsSuccess(event);break;case'capture-logs-error':this.handleCaptureLogsError(event);break;}},handleCaptureLogsStart:function(event){debug('handling capture-logs-start');this._notify('logsSaving','');},handleCaptureLogsSuccess:function(event){debug('handling capture-logs-success');navigator.vibrate(100);this._notify('logsSaved',event.detail.logPrefix,function(){var logFilenames=event.detail.logFilenames;var logFiles=[];var storage=navigator.getDeviceStorage('sdcard');var requestsRemaining=logFilenames.length;var self=this;function onSuccess(){logFiles.push(this.result);requestsRemaining-=1;if(requestsRemaining===0){var logNames=logFiles.map(function(file){var pathComponents=file.name.split('/');return pathComponents[pathComponents.length-1];});new MozActivity({name:'new',data:{type:'mail',blobs:logFiles,filenames:logNames}});}}
function onError(){self.handleCaptureLogsError({detail:{error:this.error}});}
for(var logFilename of logFilenames){var req=storage.get(logFilename);req.onsuccess=onSuccess;req.onerror=onError;}});},ERRNO_TO_MSG:{0:'logsGenericError',30:'logsSDCardMaybeShared'},handleCaptureLogsError:function(event){debug('handling capture logs error');var error='';if(event){error=event.detail.error;}
var moreInfos;if(typeof error==='object'){if('operation'in error&&'unixErrno'in error){var errno=error.unixErrno;debug('errno: '+errno);if(!this.ERRNO_TO_MSG[errno]){errno=0;}
error=navigator.mozL10n.get('logsOperationFailed',{operation:error.operation});moreInfos=(function(){ModalDialog.alert('logsSaveError',this.ERRNO_TO_MSG[errno],{title:'ok'});}).bind(this);}}
this._notify('logsSaveError',error,moreInfos);},_notify:function(titleId,body,onclick){var title=navigator.mozL10n.get(titleId)||titleId;var notification=new window.Notification(title,{body:body,tag:'logshake'});if(onclick){notification.onclick=onclick;}},stop:function(){this.stopCaptureLogsListener();}};exports.LogShake=LogShake;exports.logshake=new LogShake();exports.logshake.start();})(window);;(function(exports){'use strict';function DeveloperHUD(){SettingsListener.observe('devtools.overlay.system',false,this.toggleSystemHUD.bind(this));}
DeveloperHUD.prototype={start:function(){window.addEventListener('developer-hud-update',this);},stop:function(){window.removeEventListener('developer-hud-update',this);},_showSystemHUD:false,toggleSystemHUD:function(enabled){if(!enabled){this.display(window,{});}
this._showSystemHUD=enabled;},handleEvent:function(e){this.display(e.target,e.detail);e.preventDefault();},display:function(target,data){if(!target){return;}
var appwindow=target.parentElement;if(!appwindow){if(target===window&&this._showSystemHUD){appwindow=document.getElementById('screen');}else{return;}}
var overlay=appwindow.querySelector(':scope > .developer-hud');if(!overlay){overlay=document.createElement('div');overlay.classList.add('developer-hud');appwindow.appendChild(overlay);}
if(!data.metrics||data.metrics.length<1){overlay.remove();return;}
var canvas=overlay.querySelector('.widgets');if(!canvas){canvas=document.createElement('canvas');canvas.classList.add('widgets');canvas.height=30;overlay.appendChild(canvas);}
canvas.width=window.innerWidth;var ctx=canvas.getContext('2d');ctx.font='18px sans-serif';ctx.textBaseline='top';ctx.save();ctx.translate(canvas.width,0);data.metrics.reverse().forEach((function(metric){var widget=this.widget(metric);if(!widget){return;}
var textWidth=ctx.measureText(widget.value).width;var widgetWidth=Math.max(30,textWidth)+(5*2);ctx.translate(-widgetWidth,0);ctx.fillStyle=widget.color;ctx.fillRect(0,0,widgetWidth,canvas.height);ctx.fillStyle='white';ctx.fillText(widget.value,(widgetWidth-textWidth)/2,canvas.height/4);}).bind(this));ctx.restore();},widget:function(metric){var value=metric.value;if(!value){return null;}
var color;switch(metric.name){case'warnings':color='orange';break;case'errors':color='red';break;case'security':color='black';break;case'reflows':color='purple';break;case'jank':color='cornflowerblue';value+='ms';break;case'uss':color='dimgrey';value=this.formatMemory(value);break;case'memory':color='lightslategrey';value=this.formatMemory(value);break;default:color=this.colorHash(metric.name);break;}
return{'color':color,'value':value};},colorHash:function(name){var hue=0;for(var i=0;i<name.length;i++){hue+=name.charCodeAt(i);}
return'hsl('+(hue%360)+', 75%, 50%)';},formatMemory:function(bytes){var prefix=['','K','M','G','T','P','E','Z','Y'];var i=0;for(;bytes>1024&&i<prefix.length;++i){bytes/=1024;}
return(Math.round(bytes*100)/100)+' '+prefix[i]+'B';}};exports.DeveloperHUD=DeveloperHUD;}(window));;'use strict';var DeviceStorageWatcher={LOW_DISK_NOTIF_ID:'low-disk-space',init:function dsw_init(){this._lowDeviceStorage=false;this._=navigator.mozL10n.get;this._appStorage=navigator.getDeviceStorage('apps');this._appStorage.addEventListener('change',this);this._container=document.getElementById('storage-watcher-container');this._container.onclick=this.containerClicked;this._message=this._container.querySelector('.title-container');this._availableSpace=this._container.querySelector('.detail');},containerClicked:function dsw_containerClicked(){new MozActivity({name:'configure',data:{section:'appPermissions'}});},hideNotification:function dsw_hideNotification(){this._lowDeviceStorage=false;if(this._container.classList.contains('displayed')){this._container.classList.remove('displayed');NotificationScreen.removeUnreadNotification(this.LOW_DISK_NOTIF_ID);}},displayNotification:function dsw_displayNotification(){this._lowDeviceStorage=true;if(!this._container.classList.contains('displayed')){this._container.classList.add('displayed');NotificationScreen.addUnreadNotification(this.LOW_DISK_NOTIF_ID);}},lowDiskSpaceNotification:function dsw_lowDiskSpaceNotification(space){var msg=this._('low-device-storage');var notification;if(space&&typeof space.size!=='undefined'&&space.unit){notification=msg+this._('free-space',{value:space.size,unit:space.unit});}else{notification=msg+this._('unknown-free-space');}
var systemBanner=new SystemBanner();systemBanner.show(notification);this._message.textContent=msg;this.updateAvailableSpace(space);this.displayNotification();},updateAvailableSpace:function dsw_updateAvailableSpace(space){if(space&&typeof space.size!=='undefined'&&space.unit){navigator.mozL10n.setAttributes(this._availableSpace,'free-space',{value:space.size,unit:space.unit});}else{this._availableSpace.setAttribute('data-l10n-id','unknown-free-space');}},formatSize:function dsw_formatSize(size){if(size===undefined||isNaN(size)){return;}
var units=['B','KB','MB','GB','TB','PB','EB','ZB','YB'];var i=0;while(size>=1024&&i<(units.length)-1){size/=1024;++i;}
var sizeDecimal=i<2?Math.round(size):Math.round(size*10)/10;return{size:sizeDecimal,unit:this._('byteUnit-'+units[i])};},handleEvent:function dsw_handleEvent(evt){if(evt.type!=='change'){return;}
switch(evt.reason){case'low-disk-space':var self=this;var req=self._appStorage.freeSpace();req.onsuccess=function onsuccess(){var free;if(typeof req.result!=='undefined'){free=self.formatSize(req.result);}
if(self._lowDeviceStorage){self.updateAvailableSpace(free);return;}
self.lowDiskSpaceNotification(free);};req.onerror=function onerror(){self.lowDiskSpaceNotification();};break;case'available-disk-space':this.hideNotification();break;}}};if(navigator.mozL10n){navigator.mozL10n.once(DeviceStorageWatcher.init.bind(DeviceStorageWatcher));};'use strict';(function(exports){function Rocketbar(){this.enabled=false;this.focused=false;this.active=false;this._port=null;this._wasClicked=false;this._pendingMessage=null;this.body=document.body;this.screen=document.getElementById('screen');this.rocketbar=document.getElementById('rocketbar');this.form=document.getElementById('rocketbar-form');this.input=document.getElementById('rocketbar-input');this.cancel=document.getElementById('rocketbar-cancel');this.clearBtn=document.getElementById('rocketbar-clear');this.results=document.getElementById('rocketbar-results');this.backdrop=document.getElementById('rocketbar-backdrop');this.start();}
Rocketbar.prototype={EVENT_PREFIX:'rocketbar',name:'Rocketbar',isClosing:false,publish:function(name){window.dispatchEvent(new CustomEvent(this.EVENT_PREFIX+name,{detail:this}));},isActive:function(){return this.active;},getActiveWindow:function(){return this.isActive()?this.searchWindow:null;},setHierarchy:function(active){if(active){this.focus();}
this.searchWindow&&this.searchWindow.setVisibleForScreenReader(active);},start:function(){this.addEventListeners();this.enabled=true;Service.request('registerHierarchy',this);},activate:function(){if(this.isClosing){return Promise.reject();}
this._activateCall=new Promise(resolve=>{if(this.active){resolve();return;}
this.active=true;this.rocketbar.classList.add('active');this.form.classList.remove('hidden');this.screen.classList.add('rocketbar-focused');var searchLoaded=false;var transitionEnded=false;var waitOver=()=>{if(searchLoaded&&transitionEnded){resolve();this._activateCall=null;this.publish('-activated');}};var backdrop=this.backdrop;var finishTransition=()=>{window.dispatchEvent(new CustomEvent('rocketbar-overlayopened'));transitionEnded=true;waitOver();};backdrop.classList.remove('hidden');eventSafety(backdrop,'transitionend',finishTransition,300);this.loadSearchApp().then(()=>{if(this.input.value.length){this.handleInput();}
searchLoaded=true;waitOver();});this.publish('-activating');});if(UtilityTray.active||UtilityTray.shown){this._activateCall.then(this._closeSearch.bind(this));}
return this._activateCall;},deactivate:function(){if(!this.active){return;}
this.active=false;this.isClosing=true;var backdrop=this.backdrop;var self=this;var finish=()=>{this.form.classList.add('hidden');this.rocketbar.classList.remove('active');this.screen.classList.remove('rocketbar-focused');backdrop.classList.add('hidden');eventSafety(backdrop,'transitionend',()=>{window.dispatchEvent(new CustomEvent('rocketbar-overlayclosed'));self.publish('-deactivated');self.isClosing=false;},300);};if(this.focused){eventSafety(window,'keyboardhidden',finish,1000);this.blur();}else{finish();}
this.publish('-deactivating');},addEventListeners:function(){window.addEventListener('apploading',this);window.addEventListener('appforeground',this);window.addEventListener('apptitlechange',this);window.addEventListener('lockscreen-appopened',this);window.addEventListener('appopened',this);window.addEventListener('launchapp',this);window.addEventListener('searchterminated',this);window.addEventListener('permissiondialoghide',this);window.addEventListener('global-search-request',this);window.addEventListener('attentionopening',this);window.addEventListener('attentionopened',this);window.addEventListener('activityrequesting',this);window.addEventListener('searchopened',this);window.addEventListener('searchclosed',this);window.addEventListener('utilitytray-overlayopening',this);window.addEventListener('utility-tray-overlayopened',this);window.addEventListener('simlockrequestfocus',this);window.addEventListener('cardviewbeforeshow',this);this.input.addEventListener('focus',this);this.input.addEventListener('blur',this);this.input.addEventListener('input',this);this.cancel.addEventListener('click',this);this.clearBtn.addEventListener('click',this);this.form.addEventListener('submit',this);this.backdrop.addEventListener('click',this);window.addEventListener('iac-search-results',this);},'_handle_system-resize':function(){if(this.isActive()){this.searchWindow&&this.searchWindow.frontWindow&&this.searchWindow.frontWindow.resize();return false;}
return true;},respondToHierarchyEvent:function(evt){if(this['_handle_'+evt.type]){return this['_handle_'+evt.type](evt);}
return true;},handleEvent:function(e){switch(e.type){case'searchopened':window.addEventListener('open-app',this);break;case'searchclosed':window.removeEventListener('open-app',this);break;case'apploading':case'launchapp':var detail=e.detail;if(detail&&detail.stayBackground){return;}
this._closeSearch();break;case'open-app':if(this.searchWindow&&this.searchWindow.frontWindow){return;}
if(e.detail&&!e.detail.showApp){return;}
case'attentionopening':case'attentionopened':case'appforeground':case'appopened':case'utilitytray-overlayopening':case'utility-tray-overlayopened':case'simlockrequestfocus':case'cardviewbeforeshow':case'activityrequesting':this._closeSearch();break;case'lockscreen-appopened':this.handleLock(e);break;case'focus':this.handleFocus(e);break;case'blur':this.handleBlur(e);break;case'input':this.handleInput(e);break;case'click':if(e.target==this.cancel){this.handleCancel(e);}else if(e.target==this.clearBtn){this.clear();}else if(e.target==this.backdrop){this._closeSearch();}
break;case'searchterminated':this.handleSearchTerminated(e);break;case'submit':this.handleSubmit(e);break;case'iac-search-results':this.handleSearchMessage(e);break;case'permissiondialoghide':if(this.active){this.focus();}
break;case'global-search-request':var app=Service.currentApp;var afterActivate;if(app&&!app.isActive()){return;}
if(app&&!app.isBrowser()){afterActivate=this.focus.bind(this);}else{if(app.config.url.startsWith('app://system.gaiamobile.org')){this.setInput('');}else{this.setInput(app.config.url);}
afterActivate=()=>{this.hideResults();setTimeout(()=>{this.focus();this.selectAll();});};}
if(app&&app.appChrome&&!app.appChrome.isMaximized()){app.appChrome.maximize(()=>{this.activate().then(afterActivate);});}else{this.activate().then(afterActivate);}
break;}},setSearchAppURL:function(url){this._searchAppURL=url;this._searchManifestURL=url?url.match(/(^.*?:\/\/.*?\/)/)[1]+'manifest.webapp':'';},setInput:function(input){this.input.value=input;this.rocketbar.classList.toggle('has-text',input.length);},showResults:function(){if(this.searchWindow&&!this.searchWindow.isDead()){this.searchWindow.open();}
this.results.classList.remove('hidden');this.backdrop.classList.add('results-shown');},hideResults:function(){if(this.searchWindow){this.searchWindow.close();this.searchWindow.hideContextMenu();}
this.results.classList.add('hidden');this.backdrop.classList.remove('results-shown');if(this._port){this._port.postMessage({action:'clear'});}},clear:function(){this.setInput('');this.hideResults();},enableNavigation:function(){this.rocketbar.classList.add('navigation');},disableNavigation:function(){this.rocketbar.classList.remove('navigation');},focus:function(){if(this.active){this.input.focus();}},selectAll:function(){this.input.setSelectionRange(0,this.input.value.length,'forward');},handleFocus:function(){this.focused=true;},_handle_home:function(){this._closeSearch();return true;},blur:function(){this.input.blur();},handleBlur:function(){this.focused=false;},handleLock:function(){this._closeSearch();},'_handle_mozChromeEvent':function(evt){if(!evt.detail||evt.detail.type!=='inputmethod-contextchange'){return true;}
if(this.searchWindow){this.searchWindow.getTopMostWindow().broadcast('inputmethod-contextchange',evt.detail);return false;}
return true;},_handle_launchactivity:function(e){if(e.detail.isActivity&&e.detail.inline&&this.searchWindow&&this.searchWindow.manifestURL===e.detail.parentApp){this.searchWindow.broadcast('launchactivity',e.detail);return false;}
return true;},_closeSearch:function(){var hideAndDeactivate=()=>{this.hideResults();this.deactivate();};if(this._activateCall){this._activateCall.then(hideAndDeactivate);}else{hideAndDeactivate();}},handleInput:function(){var input=this.input.value;this.rocketbar.classList.toggle('has-text',input.length);if(UtilityTray.active||UtilityTray.shown){this._closeSearch();return;}
if(!input&&!this.results.classList.contains('hidden')){this.hideResults();return;}
if(this.results.classList.contains('hidden')){this.showResults();}
if(this._port){this._port.postMessage({action:'change',input:input,isPrivateBrowser:Service.currentApp.isPrivateBrowser()});}},handleCancel:function(e){this.setInput('');this._closeSearch();},handleSubmit:function(e){e.preventDefault();if(this.results.classList.contains('hidden')){this.showResults();}
this._port.postMessage({action:'submit',input:this.input.value});if(Service.currentApp.isPrivateBrowser()){this.setInput('');}},loadSearchApp:function(){if(!this.searchWindow){this.searchWindow=new SearchWindow();}
return this.initSearchConnection();},handleSearchTerminated:function(e){if(!this.searchWindow){return;}
this._closeSearch();this.searchWindow=null;this._port=null;},initSearchConnection:function(){if(this.pendingInitConnection){return this.pendingInitConnection;}
this.pendingInitConnection=new Promise((resolve,reject)=>{navigator.mozApps.getSelf().onsuccess=(event)=>{var app=event.target.result;if(!app){reject();return;}
app.connect('search').then(ports=>{ports.forEach(port=>{this._port=port;});if(this._pendingMessage){this.handleSearchMessage(this._pendingMessage);delete this._pendingMessage;}
delete this.pendingInitConnection;resolve();},reject);};});return this.pendingInitConnection;},handleSearchMessage:function(e){if(!this._port){this._pendingMessage=e;this.initSearchConnection();return;}
switch(e.detail.action){case'private-window':window.dispatchEvent(new CustomEvent('new-private-window'));break;case'render':this.activate().then(this.focus.bind(this));break;case'focus':this.focus();break;case'input':this.setInput(e.detail.input);this.focus();this.handleInput();break;case'request-screenshot':places.screenshotRequested(e.detail.url);break;case'hide':this._closeSearch();break;}},updateSearchIndex:function(){if(this._port){this._port.postMessage({action:'syncPlaces'});}}};exports.Rocketbar=Rocketbar;}(window));;'use strict';(function(exports){function SearchWindow(){this.instanceID='search';this.publish('created');this._setBrowserConfig=this.setBrowserConfig.bind(this);SettingsListener.observe('rocketbar.searchAppURL','',this._setBrowserConfig);return this;}
SearchWindow.REGISTERED_EVENTS=['mozbrowsererror'];SearchWindow.SUB_COMPONENTS={'childWindowFactory':window.ChildWindowFactory,'contextmenu':window.BrowserContextMenu,'transitionController':window.AppTransitionController,'valueSelector':window.ValueSelector};SearchWindow.prototype=Object.create(AppWindow.prototype);SearchWindow.prototype.constructor=SearchWindow;SearchWindow.SUSPENDING_ENABLED=false;SearchWindow.prototype._DEBUG=false;SearchWindow.prototype.CLASS_NAME='SearchWindow';SearchWindow.prototype.CLASS_LIST='appWindow searchWindow';SearchWindow.prototype.HIERARCHY_MANAGER='Rocketbar';SearchWindow.prototype.openAnimation='immediate';SearchWindow.prototype.closeAnimation='immediate';SearchWindow.prototype.eventPrefix='search';SearchWindow.prototype.containerElement=document.getElementById('rocketbar-results');SearchWindow.prototype.view=function aw_view(){return`<div class="${this.CLASS_LIST}" id="${this.instanceID}"
             transition-state="closed">
             <div class="browser-container"></div>
           </div>`;};SearchWindow.prototype.lockOrientation=function(){var currentApp=Service.currentApp;currentApp.setOrientation();};SearchWindow.prototype.requestClose=function(){this.close();};SearchWindow.prototype.destroy=function(){SettingsListener.unobserve('rocketbar.searchAppURL',this._setBrowserConfig);AppWindow.prototype.destroy.call(this);};SearchWindow.prototype.setBrowserConfig=function(url){var manifestURL=url?url.match(/(^.*?:\/\/.*?\/)/)[1]+'manifest.webapp':'';this.manifestURL=manifestURL;this.searchAppURL=url;var app=applications.getByManifestURL(manifestURL);this.origin=app.origin;this.manifestURL=app.manifestURL;this.url=app.origin+'/index.html';this.browser_config=new BrowserConfigHelper({url:this.origin,manifestURL:this.manifestURL});this.manifest=this.browser_config.manifest;this.browser_config.url=this.url;this.browser_config.isSearch=true;this.config=this.browser_config;this.isSearch=true;this.name=this.manifest.name;this.render();this.open();};exports.SearchWindow=SearchWindow;}(window));;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::(?:\/\/)?)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},_getScheme:function(input){return(rscheme.exec(input)||[])[0];},hasScheme:function(input){return!!this._getScheme(input);},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data|view-source)\:/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)||this._getScheme(str)===str){return true;}
if(case3Reg.test(str)){return false;}
if(!this.hasScheme(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;'use strict';var FxAccountsUI={dialog:null,panel:null,iframe:null,onerrorCb:null,onsuccessCb:null,init:function init(){var dialogOptions={onHide:this.reset.bind(this)};if(!this.dialog){this.dialog=new FxAccountsDialog(dialogOptions);}
this.panel=this.dialog.getView();this.iframe=document.createElement('iframe');this.iframe.id='fxa-iframe';},login:function fxa_ui_login(onsuccess,onerror){this.onsuccessCb=onsuccess;this.onerrorCb=onerror;this.loadFlow('login');},logout:function fxa_ui_logout(onsuccess,onerror){this.onsuccessCb=onsuccess;this.onerrorCb=onerror;this.loadFlow('logout');},delete:function fxa_ui_delete(onsuccess,onerror){this.onsuccessCb=onsuccess;this.onerrorCb=onerror;this.loadFlow('delete');},refreshAuthentication:function fxa_ui_refreshAuth(email,onsuccess,onerror){this.onsuccessCb=onsuccess;this.onerrorCb=onerror;this.loadFlow('refresh_auth',['email='+email]);},close:function fxa_ui_close(){var self=this;this.panel.addEventListener('animationend',function closeAnimationEnd(){self.panel.removeEventListener('animationend',closeAnimationEnd,false);self.panel.classList.remove('closing');self.dialog.hide();},false);this.panel.classList.add('closing');},reset:function fxa_ui_reset(reason){this.panel.removeChild(this.iframe);this.dialog.browser=null;if(reason=='home'||reason=='holdhome'){this.onerrorCb&&this.onerrorCb('DIALOG_CLOSED_BY_USER');}
this.onerrorCb=null;this.onsuccessCb=null;},loadFlow:function fxa_ui_loadFlow(flow,params){var url='../fxa/fxa_module.html#'+flow;if(FtuLauncher.isFtuRunning()){params=params||[];params.push('isftu=true');}
if(params&&Array.isArray(params)){url+='?'+params.join('&');}
this.iframe.setAttribute('src',url);this.panel.appendChild(this.iframe);this.dialog.browser={element:this.iframe};this.dialog.show();},done:function fxa_ui_done(data){this.onsuccessCb&&this.onsuccessCb(data);this.close();},error:function fxa_ui_error(error){this.onerrorCb&&this.onerrorCb(error);this.close();}};navigator.mozL10n.once(FxAccountsUI.init.bind(FxAccountsUI));;'use strict';var FxAccountsManager={init:function fxa_mgmt_init(){window.addEventListener('iac-fxa-mgmt',this.onPortMessage);window.addEventListener('mozFxAccountsUnsolChromeEvent',this);},sendPortMessage:function fxa_mgmt_sendPortMessage(message){var port=IACHandler.getPort('fxa-mgmt');if(port){port.postMessage(message);}},onPortMessage:function fxa_mgmt_onPortMessage(event){if(!event||!event.detail){console.error('Wrong event');return;}
var self=FxAccountsManager;var methodName=event.detail.name;switch(methodName){case'getAccounts':case'logout':(function(methodName){LazyLoader.load('js/fxa_client.js',function(){FxAccountsClient[methodName](function(data){self.sendPortMessage({methodName:methodName,data:data});},function(error){self.sendPortMessage({methodName:methodName,error:error});});});})(methodName);break;case'resendVerificationEmail':(function(methodName){var email=event.detail.email;if(!email){self.sendPortMessage({methodName:methodName,error:'NO_VALID_EMAIL'});return;}
LazyLoader.load('js/fxa_client.js',function(){FxAccountsClient[methodName](email,function(data){self.sendPortMessage({methodName:methodName,data:data});},function(error){self.sendPortMessage({methodName:methodName,error:error});});});})(methodName);break;case'openFlow':(function(methodName){FxAccountsUI.login(function(data){self.sendPortMessage({methodName:methodName,data:data});},function(error){self.sendPortMessage({methodName:methodName,error:error});});})(methodName);break;case'refreshAuthentication':(function(methodName){var email=event.detail.email;if(!email){self.sendPortMessage({methodName:methodName,error:'NO_VALID_EMAIL'});return;}
FxAccountsUI.refreshAuthentication(email,function(data){self.sendPortMessage({methodName:methodName,data:data});},function(error){self.sendPortMessage({methodName:methodName,error:error});});})(methodName);break;}},_sendContentEvent:function fxa_mgmt_sendContentEvent(msg){var event=new CustomEvent('mozFxAccountsRPContentEvent',{detail:msg});window.dispatchEvent(event);},handleEvent:function fxa_mgmt_handleEvent(event){if(!event||!event.detail){console.error('Wrong event');return;}
var message=event.detail;switch(message.eventName){case'openFlow':FxAccountsUI.login(function(result){this._sendContentEvent({id:message.id,result:result});}.bind(this),function(error){this._sendContentEvent({id:message.id,error:error});}.bind(this));break;case'refreshAuthentication':var email=message.data.email;if(!email){console.error('No account id specified');return;}
FxAccountsUI.refreshAuthentication(email,function(result){this._sendContentEvent({id:message.id,result:result});}.bind(this),function(error){this._sendContentEvent({id:message.id,error:error});}.bind(this));break;case'onlogin':case'onverified':case'onlogout':FxAccountsManager.sendPortMessage({eventName:message.eventName});break;}}};FxAccountsManager.init();;'use strict';const IAC_API_WAKEUP_REASON_ENABLED_CHANGED=0;const IAC_API_WAKEUP_REASON_STALE_REGISTRATION=1;const IAC_API_WAKEUP_REASON_LOGIN=2;const IAC_API_WAKEUP_REASON_LOGOUT=3;const IAC_API_WAKEUP_REASON_TRY_DISABLE=4;const IAC_API_WAKEUP_REASON_LOCKSCREEN_CLOSED=5;function wakeUpFindMyDevice(reason){navigator.mozApps.getSelf().onsuccess=function(){var app=this.result;app.connect('findmydevice-wakeup').then(function(ports){ports[0].postMessage(reason);});};};'use strict';const FMD_MAX_REGISTRATION_RETRIES=5;const FMD_ENABLE_FAILURE_NOTIFICATION_TAG='findmydevice.enable-failed';var FMDOpenSettings=function(){var activity=new MozActivity({name:'configure',data:{target:'device',section:'findmydevice'}});activity.onerror=function(e){DUMP('There was a problem opening settings: '+e);};};function FMDNotifications(){}
FMDNotifications.prototype={handleSystemMessageNotification:function(message){FMDOpenSettings();this.closeSystemMessageNotification(message);},closeSystemMessageNotification:function(msg){Notification.get({tag:msg.tag}).then(notifs=>{notifs.forEach(notif=>{if(notif.tag){if(notif.tag===msg.tag){notif.close&&notif.close();}}else{if(notif.body===msg.body){notif.close&&notif.close();}}});});},};var FMDNotificationsHandler=new FMDNotifications();function FMDInit(){Service.request('handleSystemMessageNotification','findmydevice',FMDNotificationsHandler);navigator.mozSettings.addObserver('findmydevice.enabled',function(event){wakeUpFindMyDevice(IAC_API_WAKEUP_REASON_ENABLED_CHANGED);});var fmdEnabledHelper=SettingsHelper('findmydevice.enabled');navigator.mozSettings.addObserver('findmydevice.retry-count',function(event){if(event.settingValue>=FMD_MAX_REGISTRATION_RETRIES){fmdEnabledHelper.set(false);var _=navigator.mozL10n.get;var icon='style/find_my_device/images/findMyDevice.png';var title=_('unable-to-connect');var body=_('tap-to-check-settings');var notification=new Notification(title,{body:body,icon:icon,tag:FMD_ENABLE_FAILURE_NOTIFICATION_TAG,data:{systemMessageTarget:'findmydevice'}});notification.onclick=function(evt){FMDOpenSettings();notification.close();};}});navigator.mozSettings.addObserver('geolocation.enabled',function(event){wakeUpFindMyDevice(IAC_API_WAKEUP_REASON_STALE_REGISTRATION);});var lockMessageHelper=SettingsHelper('lockscreen.lock-message');window.addEventListener('lockscreen-request-unlock',function(event){if(event.detail&&event.detail.activity&&'record'===event.detail.activity.name){return;}
lockMessageHelper.set('');wakeUpFindMyDevice(IAC_API_WAKEUP_REASON_LOCKSCREEN_CLOSED);});var loggedInHelper=SettingsHelper('findmydevice.logged-in');window.addEventListener('mozFxAccountsUnsolChromeEvent',function(event){if(!event||!event.detail){return;}
var eventName=event.detail.eventName;DUMP('findmydevice received '+eventName+' FxA event in the System app');if(eventName==='onlogin'||eventName==='onverified'){loggedInHelper.set(true);wakeUpFindMyDevice(IAC_API_WAKEUP_REASON_LOGIN);}else if(eventName==='onlogout'){loggedInHelper.set(false);wakeUpFindMyDevice(IAC_API_WAKEUP_REASON_LOGOUT);}});}
window.addEventListener('load',function fmdlauncher_load(){window.removeEventListener('load',fmdlauncher_load);FMDInit();});;'use strict';const CONTENT_EVENT='mozMobileIdContentEvent';const CHROME_EVENT='mozMobileIdChromeEvent';const UNSOLICITED_EVENT='mozMobileIdUnsolContentEvent';var MobileIdManager={dialog:null,init:function mobileid_init(){window.addEventListener(CHROME_EVENT,this.onChromeEvent.bind(this));},onChromeEvent:function mobileid_onChromeEvent(event){if(!event||!event.detail){console.error('Wrong event');return;}
var message=event.detail;var params=message.data;if(message.id){this.chromeEventId=message.id;}
switch(message.eventName){case'onpermissionrequest':if(this.dialog){return;}
this.openDialog(params);break;default:if(!this.dialog){return;}
this.dialog.dispatchEvent(message.eventName,params);break;}},cleanup:function mobileid_cleanup(){if(this.dialog){this.dialog.reset();this.dialog=null;}
if(this.chromeEventId){this.sendContentEvent(CONTENT_EVENT,{id:this.chromeEventId,error:'DIALOG_CLOSED_BY_USER'});this.chromeEventId=null;}},cancel:function mobileid_cancel(isVerificationDone){this.cleanup();if(!isVerificationDone){this.sendContentEvent(UNSOLICITED_EVENT,{eventName:'cancel'});}},close:function mobileid_close(isVerificationDone){if(!this.dialog){return;}
this.dialog.close(this.cancel.bind(this,isVerificationDone));},sendMsisdn:function mobileid_close(msisdnSelected){this.sendContentEvent(CONTENT_EVENT,{id:this.chromeEventId||null,result:msisdnSelected});},sendVerificationCode:function mobileid_sendVerificationCode(code){this.sendContentEvent(CONTENT_EVENT,{id:this.chromeEventId||null,result:{verificationCode:code||''}});},requestNewCode:function mobileid_askForNewCode(){this.sendContentEvent(UNSOLICITED_EVENT,{eventName:'resendcode'});},sendContentEvent:function mobileid_sendContentEvent(eventName,msg){var event=new CustomEvent(eventName,{detail:msg});window.dispatchEvent(event);},openDialog:function mobileid_openDialog(params){var app=applications.getByManifestURL(params.manifestURL);if(!app){this.cancel(false);console.error('App is not available when requesting Mobile ID');return;}
var dialogOptions={onHide:this.cleanup.bind(this),onLoaded:function onLoaded(){this.dialog.dispatchEvent('init',{appName:app.manifest.name,candidates:params.phoneNumberInfo});}.bind(this)};this.dialog=new MobileIdDialog(dialogOptions);}};MobileIdManager.init();;'use strict';(function(exports){var MobileIdDialog=function MobileIdDialog(options){this.options=options||{};this.render();this.createIframe();this.publish('created');};MobileIdDialog.prototype=Object.create(window.SystemDialog.prototype);MobileIdDialog.prototype.customID='mobileid-dialog';MobileIdDialog.prototype.DEBUG=false;MobileIdDialog.prototype.panel=null;MobileIdDialog.prototype.iframe=null;MobileIdDialog.prototype.view=function mobileid_view(){return'<div id="'+this.instanceID+'" role="dialog"></div>';};MobileIdDialog.prototype.createIframe=function mobileid_getIFrame(onLoaded){this.iframe=document.createElement('iframe');this.iframe.id='mobileid-iframe';this.iframe.src='/mobile_id/index.html';this.iframe.style.width='100%';this.iframe.style.height='100%';this.getView().appendChild(this.iframe);this.iframe.onload=function onLoaded(){if(typeof this.options.onLoaded==='function'){this.options.onLoaded();}
this.open(function onOpened(){this.dispatchEvent('shown');}.bind(this));}.bind(this);return this.iframe;};MobileIdDialog.prototype.dispatchEvent=function mobileid_dispatchEvent(eventName,params){if(!this.iframe){return;}
var event=new CustomEvent(eventName,{detail:params});this.iframe.contentWindow.dispatchEvent(event);};MobileIdDialog.prototype.getView=function mobileid_getIFrame(){return document.getElementById(this.instanceID);};MobileIdDialog.prototype.open=function mobileid_open(onOpened){this.panel=this.getView();this.show();var onTransitionEnd=function onOpenedAnimation(){this.panel.classList.remove('opening');this.panel.removeEventListener('animationend',onTransitionEnd);if(typeof onOpened==='function'){onOpened();}}.bind(this);this.panel.addEventListener('animationend',onTransitionEnd);this.panel.classList.add('opening');};MobileIdDialog.prototype.close=function mobileid_close(onClosed){var onTransitionEnd=function onClosedAnimation(){this.panel.removeEventListener('animationend',onTransitionEnd);this.panel.innerHTML='';this.panel.classList.remove('closing');this.panel.classList.remove('opening');this.reset();if(typeof onClosed==='function'){onClosed();}
this.hide();}.bind(this);this.panel.addEventListener('animationend',onTransitionEnd);this.panel.classList.add('closing');};MobileIdDialog.prototype.reset=function mobileid_reset(){if(!this.panel){return;}
this.panel.parentNode.removeChild(this.panel);this.panel=null;};exports.MobileIdDialog=MobileIdDialog;}(window));