/* exported BluetoothCore */
/* global BaseModule, Bluetooth, BluetoothTransfer, NfcHandoverManager */
'use strict';

(function() {
  var BluetoothCore = function(bluetooth) {
    this.bluetooth = bluetooth;
  };

  /**
   * BluetoothCore handle bluetooth related function and bootstrap
   * modules for v1/v2 API.
   *
   * @class BluetoothCore
   */
  BaseModule.create(BluetoothCore, {
    name: 'BluetoothCore',

    start: function() {
      // init Bluetooth module
      if (typeof(window.navigator.mozBluetooth.onattributechanged) ===
        'undefined') { // APIv1
          Bluetooth.init();
          BluetoothTransfer.init();
          NfcHandoverManager.init();
      }
    }
  });
}());
