;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,rawValue,ast){var pos,v;var value=rawValue.indexOf('{{')>-1?this.parseString(rawValue):rawValue;if(rawValue.indexOf('<')>-1||rawValue.indexOf('&')>-1){value={$o:value};}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;var nonLatin1=/[^\x01-\xFF]/;var FSI='\u2068';var PDI='\u2069';function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v!==undefined?node.$v:null,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
return{id:id,value:node.$v||(node!==undefined?node:null),index:node.$x||null,env:env,dirty:false};}
function format(args,entity){var locals={overlay:false};if(typeof entity==='string'){return[locals,entity];}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var rv;try{rv=resolveValue(locals,args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return rv;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return[{},env['__'+id]];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return[{},args[id]];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(locals,args,env,id){var res;try{res=resolveIdentifier(args,env,id);}catch(err){return[{error:err},'{{ '+id+' }}'];}
var value=res[1];if(typeof value==='number'){return res;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
if(locals.contextIsNonLatin1||value.match(nonLatin1)){res[1]=FSI+value+PDI;}
return res;}
return[{},'{{ '+id+' }}'];}
function interpolate(locals,args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return[prev[0],prev[1]+cur];}else if(cur.t==='idOrVar'){var placeable=subPlaceable(locals,args,env,cur.v);if(placeable[0].overlay){prev[0].overlay=true;}
return[prev[0],prev[1]+placeable[1]];}},[locals,'']);}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName)[1];if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1])[1]:undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(locals,args,env,expr,index){if(!expr){return[locals,expr];}
if(expr.$o){expr=expr.$o;locals.overlay=true;}
if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'){return[locals,expr];}
if(Array.isArray(expr)){locals.contextIsNonLatin1=expr.some(function($_){return typeof($_)==='string'&&$_.match(nonLatin1);});return interpolate(locals,args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(locals,args,env,expr[selector]);}}
if('other'in expr){return resolveValue(locals,args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;key=keys[i];i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function makeAccented(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\})/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return makeAccented(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO_STRATEGIES={'qps-ploc':new Pseudo('qps-ploc','Accented English',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Mirrored English',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.isPseudo=PSEUDO_STRATEGIES.hasOwnProperty(id);this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo?this.ctx.defaultLocale:id);}
var bindingsIO={extra:function(id,ver,path,type,callback,errback,sync){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo?ctx.defaultLocale:this.id;var source=navigator.mozL10n._config.localeSources[this.id]||'app';var appVersion=navigator.mozL10n._config.appVersion;for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO_STRATEGIES[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0;i<ast.length;i++){this.entries[ast[i].$i]=createEntry(ast[i],this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatTuple(args,entity){try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);var locals={error:err};return[locals,entity.id];}}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
return formatTuple.call(this,args,entity)[1];}
function formatEntity(args,entity){var rv=formatTuple.call(this,args,entity);var locals=rv[0];var value=rv[1];var formatted={value:value,attrs:null,overlay:locals.overlay};if(entity.attrs){formatted.attrs=Object.create(null);}
for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){if(available.indexOf(requested[0])===-1||requested[0]===defaultLocale){return[defaultLocale];}else{return[requested[0],defaultLocale];}}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var reqPseudo=requested.filter(function(loc){return loc in PSEUDO_STRATEGIES;});var supported=negotiate(this.availableLocales.concat(reqPseudo),requested,this.defaultLocale);freeze.call(this,supported);};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var allowed={elements:['a','em','strong','small','s','cite','q','dfn','abbr','data','time','code','var','samp','kbd','sub','sup','i','b','u','mark','ruby','rt','rp','bdi','bdo','span','br','wbr'],attributes:{global:['title','aria-label','aria-valuetext','aria-moz-hint'],a:['download'],area:['download','alt'],input:['alt','placeholder'],menuitem:['label'],menu:['label'],optgroup:['label'],option:['label'],track:['label'],img:['alt'],textarea:['placeholder'],th:['abbr']}};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO_STRATEGIES,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=!PSEUDO_STRATEGIES.hasOwnProperty(navigator.language)&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(pretranslate){initResources.call(navigator.mozL10n);}else{initObserver();window.setTimeout(initResources.bind(navigator.mozL10n));}}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function camelCaseToDashed(string){if(string==='ariaValueText'){return'aria-valuetext';}
return string.replace(/[A-Z]/g,function(match){return'-'+match.toLowerCase();}).replace(/^-/,'');}
function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(typeof entity.value==='string'){if(!entity.overlay){element.textContent=entity.value;}else{var translation=element.ownerDocument.createElement('template');translation.innerHTML=entity.value;overlayElement(element,translation.content);}}
for(var key in entity.attrs){if(key==='innerHTML'){element.innerHTML=entity.attrs[key];continue;}
var attrName=camelCaseToDashed(key);if(isAttrAllowed({name:attrName},element)){element.setAttribute(attrName,entity.attrs[key]);}}}
function overlayElement(sourceElement,translationElement){var result=translationElement.ownerDocument.createDocumentFragment();var k,attr;var childElement;while((childElement=translationElement.childNodes[0])){translationElement.removeChild(childElement);if(childElement.nodeType===Node.TEXT_NODE){result.appendChild(childElement);continue;}
var index=getIndexOfType(childElement);var sourceChild=getNthElementOfType(sourceElement,childElement,index);if(sourceChild){overlayElement(sourceChild,childElement);result.appendChild(sourceChild);continue;}
if(isElementAllowed(childElement)){const sanitizedChild=childElement.ownerDocument.createElement(childElement.nodeName);overlayElement(sanitizedChild,childElement);result.appendChild(sanitizedChild);continue;}
result.appendChild(document.createTextNode(childElement.textContent));}
sourceElement.textContent='';sourceElement.appendChild(result);if(translationElement.attributes){for(k=0,attr;(attr=translationElement.attributes[k]);k++){if(isAttrAllowed(attr,sourceElement)){sourceElement.setAttribute(attr.name,attr.value);}}}}
function isElementAllowed(element){return allowed.elements.indexOf(element.tagName.toLowerCase())!==-1;}
function isAttrAllowed(attr,element){var attrName=attr.name.toLowerCase();var tagName=element.tagName.toLowerCase();if(allowed.attributes.global.indexOf(attrName)!==-1){return true;}
if(!allowed.attributes[tagName]){return false;}
if(allowed.attributes[tagName].indexOf(attrName)!==-1){return true;}
if(tagName==='input'&&attrName==='value'){var type=element.type.toLowerCase();if(type==='submit'||type==='button'||type==='reset'){return true;}}
return false;}
function getNthElementOfType(context,element,index){var nthOfType=0;for(var i=0,child;child=context.children[i];i++){if(child.nodeType===Node.ELEMENT_NODE&&child.tagName===element.tagName){if(nthOfType===index){return child;}
nthOfType++;}}
return null;}
function getIndexOfType(element){var index=0;var child;while((child=element.previousElementSibling)){if(child.tagName===element.tagName){index++;}}
return index;}})(this);;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;'use strict';var SettingsListener={_timer:null,_lock:null,_observers:[],getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));var settingChanged=function settingChanged(evt){callback(evt.settingValue);};settings.addObserver(name,settingChanged);this._observers.push({name:name,callback:callback,observer:settingChanged});},unobserve:function sl_unobserve(name,callback){var settings=window.navigator.mozSettings;var that=this;this._observers.forEach(function(value,index){if(value.name===name&&value.callback===callback){settings.removeObserver(name,value.observer);that._observers.splice(index,1);}});}};;;'use strict';(function(exports){var datastore;var DATASTORE_NAME='collections_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('collections-ds-initialized',function oninitalized(){document.removeEventListener('collections-ds-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Collection store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Collection store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('collections-ds-initialized'));resolve();},reject);});}
function doGetAll(resolve,reject){var result=Object.create(null);var cursor=datastore.sync();function cursorResolve(task){switch(task.operation){case'update':case'add':result[task.data.id]=task.data;break;case'remove':delete result[task.data.id];break;case'clear':result=Object.create(null);break;case'done':resolve(result);return;}
cursor.next().then(cursorResolve,reject);}
cursor.next().then(cursorResolve,reject);}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function getAll(){return new Promise(function doGet(resolve,reject){init().then(doGetAll.bind(null,resolve,reject),reject);});}
function getAllCategories(){return new Promise(function doGet(resolve,reject){getAll().then(function(collections){var categories=[];for(var id in collections){var collection=collections[id];if(collection.categoryId){categories.push(collection.categoryId);}}
resolve(categories);},reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:result||event});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function add(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){var id=data.id||uuid();Object.defineProperty(data,'id',{enumerable:true,configurable:false,writable:false,value:id});datastore.add(data,id).then(function add_success(){resolve(true);},function add_error(){datastore.put(data,id).then(function put_success(){resolve();},reject);});},reject);});}
function getRevisionId(){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){resolve(datastore.revisionId);},reject);});}
function put(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(data,data.id).then(function success(){resolve();},reject);},reject);});}
function remove(id){return new Promise(function doRemove(resolve,reject){init().then(function onInitialized(){datastore.remove(id).then(resolve,reject);},reject);});}
exports.CollectionsDatabase={get:get,getAll:getAll,getAllCategories:getAllCategories,getRevisionId:getRevisionId,addEventListener:addEventListener,removeEventListener:removeEventListener,add:add,put:put,remove:remove};}(window));;'use strict';(function(exports){var datastore;var DATASTORE_NAME='bookmarks_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('ds-initialized',function oninitalized(){document.removeEventListener('ds-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Bookmark store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Bookmark store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('ds-initialized'));resolve();},reject);});}
function doGetAll(resolve,reject){var result=Object.create(null);var cursor=datastore.sync();function cursorResolve(task){switch(task.operation){case'update':case'add':result[task.data.id]=task.data;break;case'remove':delete result[task.data.id];break;case'clear':result=Object.create(null);break;case'done':resolve(result);return;}
cursor.next().then(cursorResolve,reject);}
cursor.next().then(cursorResolve,reject);}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function getAll(){return new Promise(function doGet(resolve,reject){init().then(doGetAll.bind(null,resolve,reject),reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:result||event});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function add(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){var id=data.url;Object.defineProperty(data,'id',{enumerable:true,configurable:false,writable:false,value:id});datastore.add(data,id).then(function add_success(){resolve(true);},function add_error(){datastore.put(data,id).then(function put_success(){resolve();},reject);});},reject);});}
function getRevisionId(){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){resolve(datastore.revisionId);},reject);});}
function put(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(data,data.id).then(function success(){resolve();},reject);},reject);});}
function remove(id){return new Promise(function doRemove(resolve,reject){init().then(function onInitialized(){datastore.remove(id).then(resolve,reject);},reject);});}
function clear(){return new Promise(function doClear(resolve,reject){init().then(function onInitialized(){datastore.clear().then(resolve,reject);},reject);});}
exports.BookmarksDatabase={get:get,getAll:getAll,getRevisionId:getRevisionId,addEventListener:addEventListener,removeEventListener:removeEventListener,add:add,put:put,remove:remove,clear:clear};}(window));;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';(function(exports){const MIN_SEGMENT_SIGNIFICANT_LENGTH=6;function SearchDedupe(){}
SearchDedupe.prototype={exactResults:{},fuzzyResults:{},dedupeNullList:['mobile','touch'],reduce:function(results,strategy){var validResults=[];var exactDedupeIdCache=[];var fuzzyDedupeIdCache=[];results.forEach(function eachResult(result){var found=false;var dedupeId=result.dedupeId.toLowerCase();var host;try{host=new URL(dedupeId).host;}catch(e){host=dedupeId;}
var fuzzyDedupeIds=[host,dedupeId];var hostParts=host.split('.');for(var i in hostParts){var part=hostParts[i];if(part.length>MIN_SEGMENT_SIGNIFICANT_LENGTH&&this.dedupeNullList.indexOf(part)===-1){fuzzyDedupeIds.push(part);}}
if(strategy=='exact'){dedupeId=dedupeId.replace(/(\?.*)/g,'');if(this.exactResults[dedupeId]){found=true;}}else{fuzzyDedupeIds.forEach(function eachFuzzy(eachId){for(var i in this.fuzzyResults){if(i.indexOf(eachId)!==-1){found=true;}}},this);}
exactDedupeIdCache.push(dedupeId);fuzzyDedupeIdCache=fuzzyDedupeIdCache.concat(fuzzyDedupeIds);if(!found){validResults.push(result);}},this);exactDedupeIdCache.forEach(function eachFuzzy(eachId){this.exactResults[eachId]=true;},this);fuzzyDedupeIdCache.forEach(function eachFuzzy(eachId){this.fuzzyResults[eachId]=true;},this);return validResults;},reset:function(){this.exactResults={};this.fuzzyResults={};}};exports.SearchDedupe=SearchDedupe;}(window));;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::(?:\/\/)?)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},_getScheme:function(input){return(rscheme.exec(input)||[])[0];},hasScheme:function(input){return!!this._getScheme(input);},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data|view-source)\:/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)||this._getScheme(str)===str){return true;}
if(case3Reg.test(str)){return false;}
if(!this.hasScheme(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;(function(exports){'use strict';exports.ComponentUtils={style:function(baseUrl){var style=document.createElement('style');var url=baseUrl+'style.css';var self=this;style.setAttribute('scoped','');style.innerHTML='@import url('+url+');';this.appendChild(style);this.style.visibility='hidden';style.addEventListener('load',function(){if(self.shadowRoot){self.shadowRoot.appendChild(style.cloneNode(true));}
self.style.visibility='';});}};}(window));;'use strict';(function(exports){const APP_LAUNCH_TIMEOUT=3000;function GridView(config){this.config=config;this.clickIcon=this.clickIcon.bind(this);this.onVisibilityChange=this.onVisibilityChange.bind(this);this.onCollectionLaunch=this.onCollectionLaunch.bind(this);this.onCollectionClose=this.onCollectionClose.bind(this);if(config.features.zoom){this.zoom=new GridZoom(this);}
this.layout=new GridLayout(this);if(config.element.hasAttribute('cols')){this.layout.cols=parseInt(config.element.getAttribute('cols'),10);}
this.start();}
GridView.prototype={icons:{},items:[],get element(){return this.config.element;},set cols(value){this.layout.cols=value;},_launchingApp:false,_collectionOpen:false,add:function(item,insertTo,expandGroup){if(!item){return;}
if(item.identifier){if(this.icons[item.identifier]){console.log('Error, duplicate identifier: ',item.identifier,new Error().stack);return;}
this.icons[item.identifier]=item;}else if(item.detail.type!=='divider'&&item.detail.type!=='placeholder'){console.log('Error, could not load identifier for object: ',JSON.stringify(item.detail));return;}
if(!isNaN(parseFloat(insertTo))&&isFinite(insertTo)){this.items.splice(insertTo,0,item);}else{insertTo=this.items.length;this.items.push(item);}
if(expandGroup){for(var i=insertTo+1,iLen=this.items.length;i<iLen;i++){var divider=this.items[i];if(divider.detail.type==='divider'){if(divider.detail.collapsed){divider.expand();}
break;}}}},getNearestItemIndex:function(x,y,isRow){var foundIndex=null;var leastDistance=null;var itemMiddleOffset=this.layout.gridItemWidth/2;for(var i=0,iLen=this.items.length;i<iLen;i++){var item=this.items[i];if(!item.isDraggable()){continue;}
if(this.config.features.disableSections&&item.detail.type==='divider'){continue;}
if(item.detail.type!=='divider'&&item.element.classList.contains('collapsed')){continue;}
var middleX=item.x+itemMiddleOffset;var middleY=item.y+item.pixelHeight/2;var xDistance=(isRow||item.detail.type==='divider')?0:x-middleX;var yDistance=y-middleY;var distance=Math.sqrt(xDistance*xDistance+
yDistance*yDistance);if(leastDistance===null||distance<leastDistance){leastDistance=distance;foundIndex=i;}}
return foundIndex;},start:function(){this.element.addEventListener('click',this.clickIcon);this.element.addEventListener('collection-launch',this.onCollectionLaunch);this.element.addEventListener('collection-close',this.onCollectionClose);window.addEventListener('visibilitychange',this.onVisibilityChange);},stop:function(){this.element.removeEventListener('click',this.clickIcon);this.element.removeEventListener('collection-launch',this.onCollectionLaunch);this.element.removeEventListener('collection-close',this.onCollectionClose);window.removeEventListener('visibilitychange',this.onVisibilityChange);},findItemFromElement:function(element,excludeCollapsedIcons){while(element&&element.parentNode!==this.element){element=element.parentNode;}
if(!element){return null;}
var i,iLen=this.items.length;var identifier=element.dataset.identifier;var icon=this.icons[identifier];if(!icon){for(i=0;i<iLen;i++){if(this.items[i].element===element){icon=this.items[i];break;}}}
if(icon&&excludeCollapsedIcons){if(icon.detail.type!=='divider'&&icon.detail.type!=='placeholder'&&icon.element.classList.contains('collapsed')){for(i=icon.detail.index+1;i<iLen;i++){if(this.items[i].detail.type==='divider'){return this.items[i];}}
console.warn('Collapsed icon found with no group');icon=null;}}
return icon;},onVisibilityChange:function(){this._launchingApp=false;},onCollectionLaunch:function(){this._collectionOpen=true;},onCollectionClose:function(){this._collectionOpen=false;},clickIcon:function(e){e.preventDefault();var inEditMode=this.dragdrop&&this.dragdrop.inEditMode;var action='launch';if(e.target.classList.contains('remove')){action='remove';}
var icon=this.findItemFromElement(e.target);if(!icon){return;}
if(action==='launch'){if(inEditMode&&e.target.classList.contains('icon')){if(!icon.isEditable()){return;}
action='edit';}else{if(!icon[action]){return;}
icon.element.classList.add('launching');var returnTimeout=500;setTimeout(function stateReturn(){if(icon.element){icon.element.classList.remove('launching');}},returnTimeout);}}
if((icon.detail.type==='app'||icon.detail.type==='bookmark')&&this._launchingApp){return;}
if((icon.detail.type==='app'&&icon.appState==='ready')||icon.detail.type==='bookmark'){this._launchingApp=true;if(this._launchingTimeout){window.clearTimeout(this._launchingTimeout);this._launchingTimeout=null;}
this._launchingTimeout=window.setTimeout(function(){this._launchingTimeout=null;this._launchingApp=false;}.bind(this),APP_LAUNCH_TIMEOUT);}
icon[action](e.target);},cleanItems:function(skipDivider){var appCount=0;var toRemove=[];this.items.forEach(function(item,idx){if(item instanceof GaiaGrid.Divider){if(appCount===0){toRemove.push(idx);}
appCount=0;}else{appCount++;}},this);toRemove.reverse();toRemove.forEach(function(idx){var removed=this.items.splice(idx,1)[0];removed.remove();},this);if(skipDivider){return;}
var lastItem=this.items[this.items.length-1];if(!lastItem||!(lastItem instanceof GaiaGrid.Divider)){this.items.push(new GaiaGrid.Divider());}},removeAllPlaceholders:function(){var toSplice=[];var previousItem;this.items.forEach(function(item,idx){if(item instanceof GaiaGrid.Placeholder){if((!previousItem||(previousItem&&previousItem instanceof GaiaGrid.Divider))&&this.dragdrop&&this.dragdrop.inDragAction){return;}
toSplice.push(idx);}
previousItem=item;},this);toSplice.reverse().forEach(function(idx){this.items.splice(idx,1)[0].remove();},this);},clear:function(){for(var i=0,iLen=this.items.length;i<iLen;i++){var item=this.items[i];if(item.element){this.element.removeChild(item.element);item.element=null;item.lastX=null;item.lastY=null;item.lastScale=null;}}
this.items=[];this.icons={};},createPlaceholders:function(coordinates,idx,count){var isRTL=(document.documentElement.dir==='rtl');for(var i=0;i<count;i++){var item=new GaiaGrid.Placeholder();this.items.splice(idx+i,0,item);item.setPosition(idx+i);var xPosition=(coordinates[0]+i)*this.layout.gridItemWidth;if(isRTL){xPosition=(this.layout.constraintSize-this.layout.gridItemWidth)-
xPosition;}
item.setCoordinates(xPosition,this.layout.offsetY);item.render();}},render:function(options){var self=this;options=options||{};this.removeAllPlaceholders();this.cleanItems(options.skipDivider);var oldHeight=this.layout.offsetY;this.layout.offsetY=0;var x=0;var y=0;function step(item){var pixelHeight=item.pixelHeight;self.layout.stepYAxis(pixelHeight);x=0;y++;}
var pendingCachedIcons=0;var onCachedIconRendered=()=>{if(--pendingCachedIcons<=0){this.element.removeEventListener('cached-icon-rendered',onCachedIconRendered);this.element.dispatchEvent(new CustomEvent('cached-icons-rendered'));}};this.element.addEventListener('cached-icon-rendered',onCachedIconRendered);var nextDivider=null;var oddDivider=true;var isRTL=(document.documentElement.dir==='rtl');for(var idx=0;idx<=this.items.length-1;idx++){var item=this.items[idx];if(options.rerender&&item.element){this.element.removeChild(item.element);item.element=null;}
if(item.detail.type==='divider'){nextDivider=null;}else{if(!nextDivider){for(var i=idx+1;i<this.items.length;i++){if(this.items[i].detail.type==='divider'){nextDivider=this.items[i];oddDivider=!oddDivider;break;}}
if(nextDivider&&!nextDivider.detail.collapsed){this.layout.offsetY+=nextDivider.headerHeight;}}
if(nextDivider&&nextDivider.detail.collapsed){item.setPosition(idx);continue;}}
if(x>0&&item.gridWidth>1&&x+item.gridWidth>=this.layout.cols){var remaining=this.layout.cols-x;this.createPlaceholders([x,y],idx,remaining);idx+=remaining;item=this.items[idx];var lastItemInRow=this.items[idx-1];step(lastItemInRow);}
item.setPosition(idx);if(!options.skipItems){item.hasCachedIcon&&++pendingCachedIcons;var xPosition=x*this.layout.gridItemWidth;if(isRTL){xPosition=(this.layout.constraintSize-this.layout.gridItemWidth)-
xPosition;}
item.setCoordinates(xPosition,this.layout.offsetY);if(!item.active){item.render();}
if(item.detail.type==='divider'){if(oddDivider){item.element.classList.add('odd');}else{item.element.classList.remove('odd');}}}
x+=item.gridWidth;if(x>=this.layout.cols){step(item);}}
if(this.layout.offsetY!=oldHeight){if(this.dragdrop&&this.dragdrop.inDragAction){this.layout.offsetY=oldHeight;}else{this.element.dispatchEvent(new CustomEvent('gaiagrid-resize',{detail:this.layout.offsetY}));}}
this.element.setAttribute('cols',this.layout.cols);pendingCachedIcons===0&&onCachedIconRendered();this.loadDragDrop();},loadDragDrop:function(){if(!this.dragdrop&&this.config.features.dragdrop){LazyLoader.load('shared/elements/gaia_grid/js/grid_dragdrop.js',()=>{if(this.dragdrop){return;}
this.dragdrop=new GridDragDrop(this);});}}};exports.GridView=GridView;}(window));;'use strict';(function(exports){const ICON_BLOB_DECORATED_EVENT='iconblobdecorated';const ICON_BLOB_ERROR_EVENT='gaiagrid-iconbloberror';const FETCH_XHR_TIMEOUT=10000;function fetchBlob(uri){return new Promise(function(accept,reject){var xhr=new XMLHttpRequest({mozAnon:true,mozSystem:true});xhr.open('GET',uri,true);xhr.responseType='blob';xhr.timeout=FETCH_XHR_TIMEOUT;xhr.send();xhr.onload=function(){var status=xhr.status;if(status!==0&&status!==200){reject(new Error('Got HTTP status '+status+' trying to load '+uri));return;}
accept(xhr.response);};xhr.onerror=xhr.ontimeout=function(){reject(new Error('Error while HTTP GET: ',uri));};});}
function GridItem(){this.detail={};}
GridItem.prototype={x:0,y:0,pixelHeight:0,gridWidth:1,scale:1,persistToDB:true,lastX:null,lastY:null,lastScale:null,get hasCachedIcon(){return this.detail&&this.detail.decoratedIconBlob;},renderer:GridIconRenderer.TYPE.STANDARD,iconState:'none',get defaultIcon(){return'/shared/elements/gaia_grid/images/default_icon.png';},get grid(){return document.getElementsByTagName('gaia-grid')[0]._grid;},isRemovable:function(){return false;},isEditable:function(){return false;},isDraggable:function(){return true;},isIconFromOrigin:function(){return this.icon.startsWith('http')||this.icon.startsWith('app:');},setPosition:function(position){this.detail.index=position;},setCoordinates:function(x,y){this.x=x;this.y=y;},requestAttention:function(){var rect={x:this.x,y:this.y,width:this.gridWidth*this.grid.layout.gridItemWidth,height:this.pixelHeight};this.grid.element.dispatchEvent(new CustomEvent('gaiagrid-attention',{detail:rect}));},closestIconFromList:function(choices){if(!choices){return this.defaultIcon;}
var list=Object.keys(choices).map(function(size){return size;}).sort(function(a,b){return b-a;});var length=list.length;if(length===0){return this.defaultIcon;}
var maxSize=this.grid.layout.gridMaxIconSize;var accurateSize=list[0];for(var i=0;i<length;i++){var size=list[i];if(size<maxSize){break;}
accurateSize=size;}
var icon=choices[accurateSize];if(!UrlHelper.hasScheme(icon)){icon=this.app.origin+icon;}
return icon;},renderIconFromSrc:function(url){var background=new Image();background.src=url;background.onload=this._decorateIcon.bind(this,background);},renderIconFromBlob:function(blob){var background=new Image();background.src=URL.createObjectURL(blob);background.onload=()=>{this._decorateIcon(background);URL.revokeObjectURL(background.src);};background.onerror=()=>{URL.revokeObjectURL(background.src);if(this.hasCachedIcon){this._stampElementWithIcon('blobcache');this._displayDecoratedIcon(this.detail.decoratedIconBlob,true);return;}
this.renderIconFromSrc(this.defaultIcon);this._stampElementWithIcon(this.defaultIcon);};},_decorateIcon:function(img){var strategy=this.detail.renderer||this.renderer;this.rendererInstance=new GridIconRenderer(this);this.rendererInstance[strategy](img).then(this._displayDecoratedIcon.bind(this));},_displayDecoratedIcon:function(blob,isCachedIcon){if(!this.element){return;}
var style=this.element.style;if(!style.backgroundSize){style.height=this.grid.layout.gridItemHeight+'px';var backgroundHeight=((this.grid.layout.gridIconSize*(1/this.grid.layout.percent))+
GridIconRenderer.prototype.unscaledCanvasPadding);if(this.grid.layout.gridItemHeight>backgroundHeight){style.backgroundSize=backgroundHeight+'px';}else{style.backgroundSize=style.height;}}
if(isCachedIcon){var url=URL.createObjectURL(blob);style.backgroundImage='url('+url+')';this.element.dataset.backgroundImage=url;var img=new Image();img.onload=img.onerror=()=>{this.grid.element.dispatchEvent(new CustomEvent('cached-icon-rendered'));};img.src=url;return;}
this._compareBlobs(blob,this.detail.decoratedIconBlob).then((equal)=>{if(equal){return;}
style.backgroundImage='url('+URL.createObjectURL(blob)+')';this.detail.decoratedIconBlob=blob;this.grid.element.dispatchEvent(new CustomEvent(ICON_BLOB_DECORATED_EVENT,{detail:this}));var bgImg=this.element.dataset.backgroundImage;bgImg&&URL.revokeObjectURL(bgImg);});},_compareBlobs:function(blob1,blob2){return new Promise(function(resolve){if(!blob1||!blob2||blob1.type!==blob2.type||blob1.size!==blob2.size){resolve(false);return;}
var startBytes=127;var bytesHash=16;var reader=new FileReader();reader.onloadend=function(){var result1=reader.result;reader=new FileReader();reader.onloadend=reader.onerror=function(){resolve(result1===reader.result);};reader.readAsDataURL(blob2.slice(startBytes,startBytes+bytesHash));};reader.onerror=function(){resolve(false);};reader.readAsDataURL(blob1.slice(startBytes,startBytes+bytesHash));});},fetchIconBlob:function(){return fetchBlob(this.icon);},_stampElementWithIcon:function(uri){if(!this.element||uri.startsWith('data:')){return;}
if(uri.length>255){uri=uri.slice(0,255);}
this.element.dataset.testIcon=uri;},renderIcon:function(renderCachedIcon){var icon=this.icon;this.iconState='pending';if(renderCachedIcon&&this.hasCachedIcon){this._displayDecoratedIcon(this.detail.decoratedIconBlob,true);var resolveIcon=()=>{this.grid.element.removeEventListener('cached-icons-rendered',resolveIcon);this.doRenderIcon(icon);};this.grid.element.addEventListener('cached-icons-rendered',resolveIcon);}else{this.doRenderIcon(icon);}},doRenderIcon:function(icon){if(!this.isIconFromOrigin()){this._stampElementWithIcon(icon);this.renderIconFromSrc(icon);this.iconState='success';return Promise.resolve();}
var eventTarget=this.grid.element;var blobNotFound=()=>{this.iconState='error';if(!this.hasCachedIcon){this.renderIconFromSrc(this.defaultIcon);this._stampElementWithIcon(this.defaultIcon);}else{this._stampElementWithIcon('blobcache');}
eventTarget.dispatchEvent(new CustomEvent(ICON_BLOB_ERROR_EVENT,{detail:this}));};return this.fetchIconBlob().then((blob)=>{if(!blob){return blobNotFound();}
this.renderIconFromBlob(blob);this.iconState='success';this._stampElementWithIcon(icon);}).catch((err)=>{blobNotFound();});},removeFromGrid:function(){var idx=this.grid.items.indexOf(this);if(idx===-1){console.error('Attempting to remove self before item has been added!');return;}
this.grid.items.splice(idx,1);delete this.grid.icons[this.identifier];if(this.element){this.element.parentNode.removeChild(this.element);}
this.grid.render({from:idx-1});},remove:function(){this.grid.element.dispatchEvent(new CustomEvent('removeitem',{detail:this}));},render:function(){var scale=this.grid.layout.percent*this.scale;if(!this.element){var tile=document.createElement('div');tile.className='icon';tile.dataset.identifier=this.identifier;tile.dataset.isDraggable=this.isDraggable();tile.setAttribute('role','link');tile.style.width=(this.grid.layout.constraintSize/3)+'px';var nameContainerEl=document.createElement('p');nameContainerEl.style.marginTop=((this.grid.layout.gridIconSize*(1/this.grid.layout.percent))+
(GridIconRenderer.prototype.unscaledCanvasPadding/2))+'px';tile.appendChild(nameContainerEl);var nameEl=document.createElement('span');nameEl.className='title';nameEl.setAttribute('dir','auto');nameContainerEl.appendChild(nameEl);if(this.isRemovable()){var removeEl=document.createElement('span');removeEl.className='remove';tile.appendChild(removeEl);}
this.element=tile;this.updateTitle();this.renderIcon(true);this.grid.element.appendChild(tile);}
this.transform(this.x,this.y,scale);},transform:function(x,y,scale,element){scale=scale||1;if(!element){if(x===this.lastX&&y===this.lastY&&scale===this.lastScale){return;}
element=this.element;this.lastX=x;this.lastY=y;this.lastScale=scale;}
element.style.transform='translate('+x+'px,'+y+'px) scale('+scale+')';},setActive:function(active){if(active){this.element.classList.add('active');this.active=true;}else{this.element.classList.remove('active');this.active=false;}},updateTitle:function(){if(!this.element){return;}
var nameEl=this.element.querySelector('.title');if(this.asyncName){this.asyncName().then(function(name){nameEl.textContent=name;});}else{nameEl.textContent=this.name;}},updateFromDatastore:function(record){var iconChanged=record.icon!==this.icon;var nameChanged=record.name!==this.name;var type=this.detail.type;var lastIcon=this.icon;record.type=type;this.detail=record;if(nameChanged){this.updateTitle();}
if(iconChanged&&record.icon){this.renderIcon();}else if(!record.icon){this.detail.icon=lastIcon;}}};exports.GaiaGrid.GridItem=GridItem;}(window));;'use strict';(function(exports){const TYPE='bookmark';function Bookmark(record,features){this.detail=record;this.features=features||{};this.detail.type=TYPE;}
Bookmark.prototype={__proto__:GaiaGrid.GridItem.prototype,renderer:GridIconRenderer.TYPE.FAVICON,get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){return this.detail.name;},get icon(){return this.detail.icon||this.defaultIcon;},get identifier(){return this.detail.id;},update:GaiaGrid.GridItem.prototype.updateFromDatastore,isEditable:function(){return this.features&&this.features.isEditable!==false;},isRemovable:function(){return this.features&&this.features.isRemovable!==false;},isDraggable:function(){return this.features&&this.features.isDraggable!==false;},render:function(){GaiaGrid.GridItem.prototype.render.call(this);this.element.classList.add('bookmark');if(this.isEditable()){this.element.classList.add('editable');}},launch:function(){var features={name:this.name,icon:this.icon,remote:true};var url=this.detail.url;if(this.features.search){features.searchName=this.name;features.searchUrl=url;}
window.open(url,'_blank',Object.keys(features).map(function eachFeature(key){return encodeURIComponent(key)+'='+
encodeURIComponent(features[key]);}).join(','));},edit:function(){new MozActivity({name:'save-bookmark',data:{type:'url',url:this.detail.id}});}};exports.GaiaGrid.Bookmark=Bookmark;}(window));;'use strict';(function(exports){function Divider(){this.detail={type:'divider',index:0};}
Divider.prototype={__proto__:GaiaGrid.GridItem.prototype,x:0,y:0,headerHeight:0,get pixelHeight(){return(this.grid.layout.cols>3)?50:60;},gridWidth:4,scale:1,render:function(){if(!this.element){var divider=this.element=document.createElement('section');divider.className='divider';var span=document.createElement('span');span.className='spacer';divider.appendChild(span);this.grid.element.appendChild(divider);}
this.element.style.transform='translate(0 ,'+this.y+'px)';},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}},isDraggable:function(){return false;}};exports.GaiaGrid.Divider=Divider;}(window));;'use strict';(function(exports){const IDENTIFIER_SEP='-';var MOZAPP_EVENTS=['downloadsuccess','downloaderror','downloadavailable','downloadapplied','progress'];var APP_LOADING='loading';var APP_ERROR='error';var APP_UNRECOVERABLE='unrecoverable';var APP_PAUSED='paused';var APP_READY='ready';function localizeString(str){var userLang=document.documentElement.lang;if(navigator.mozL10n&&userLang in navigator.mozL10n.qps){return navigator.mozL10n.qps[userLang].translate(str);}
return str;}
function Mozapp(app,entryPoint,details){this.app=app;this.entryPoint=entryPoint;this.detail={type:'app',manifestURL:app.manifestURL,entryPoint:entryPoint,index:0,decoratedIconBlob:details&&details.decoratedIconBlob};MOZAPP_EVENTS.forEach(function(type){this.app['on'+type]=this.handleEvent.bind(this);},this);this.setAppState(this._determineState(app));}
Mozapp.HIDDEN_ROLES=['system','input','homescreen','search','addon','langpack'];Mozapp.prototype={__proto__:GaiaGrid.GridItem.prototype,_isHiddenRole:function(){var manifest=this.app.manifest;if(!manifest||!manifest.role){return null;}
return Mozapp.HIDDEN_ROLES.indexOf(manifest.role)!==-1;},_determineState:function(app){if(app.installState==='pending'&&!app.downloadAvailable&&!app.readyToApplyDownload){return APP_UNRECOVERABLE;}
if(app.downloading){return APP_LOADING;}
if(app.downloadError&&app.downloadError.name){if(app.downloadError.name==='DOWNLOAD_CANCELED'){return APP_PAUSED;}
return APP_ERROR;}
if(app.installState==='pending'){return APP_PAUSED;}
return APP_READY;},handleEvent:function(event){switch(event.type){case'progress':case'downloaderror':case'downloadsuccess':this.setAppState(this._determineState(this.app));break;case'downloadapplied':if(this._isHiddenRole()){console.warn('Removing hidden app from the grid',this.name);return this.removeFromGrid();}
delete this._accurateIcon;this.setAppState(this._determineState(this.app));this.renderIcon();window.dispatchEvent(new CustomEvent('downloadapplied',{detail:{id:this.app.manifestURL}}));break;}},get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){var userLang=document.documentElement.lang;if(navigator.mozL10n&&userLang in navigator.mozL10n.qps){return navigator.mozL10n.qps[userLang].translate(this.descriptor.short_name||this.descriptor.name);}
var locales=this.descriptor.locales;var localized=locales&&locales[userLang]&&(locales[userLang].short_name||locales[userLang].name);return localized||this.descriptor.short_name||this.descriptor.name;},asyncName:function(){var userLang=document.documentElement.lang;var ep=this.entryPoint||undefined;return this.app.getLocalizedValue('short_name',userLang,ep).then(shortName=>localizeString(shortName),this.app.getLocalizedValue.bind(this.app,'name',userLang,ep)).then(name=>localizeString(name),()=>this.name);},get icon(){var icon=this._accurateIcon;if(!icon){icon=this._accurateIcon=this.closestIconFromList(this.descriptor.icons);}
return icon;},get descriptor(){var manifest=this.app.manifest||this.app.updateManifest;if(this.entryPoint&&manifest.entry_points&&manifest.entry_points[this.entryPoint]){return manifest.entry_points[this.entryPoint];}
return manifest;},identifierSeparator:IDENTIFIER_SEP,get identifier(){var identifier=[this.app.manifestURL];if(this.entryPoint){identifier.push(this.entryPoint);}
return identifier.join(IDENTIFIER_SEP);},isRemovable:function(){return this.app.removable;},unrecoverableError:function(){navigator.mozApps.mgmt.uninstall(this.app);},cancel:function(){var dialog=new ConfirmDialogHelper({type:'pause',title:{id:'gaia-grid-stop-download-title',args:{name:this.name}},body:'gaia-grid-stop-download-body',cancel:{title:'gaia-grid-cancel'},confirm:{title:'gaia-grid-stop-download-action',type:'danger',cb:()=>this.app.cancelDownload()}});dialog.show(document.body);},resume:function(){var dialog=new ConfirmDialogHelper({type:'resume',title:'gaia-grid-resume-download-title',body:{id:'gaia-grid-resume-download-body',args:{name:this.name}},cancel:{title:'gaia-grid-cancel'},confirm:{title:'gaia-grid-resume-download-action',cb:()=>{this.setAppState(APP_LOADING);this.app.download();}}});dialog.show(document.body);},setAppState:function(state){this.appState=state;if(this.element){this.element.dataset.appState=state;}},render:function(){var needsStateSet=!this.element;GaiaGrid.GridItem.prototype.render.apply(this,arguments);if(needsStateSet){this.setAppState(this.appState);}},launch:function(){var app=this.app;switch(this._determineState(app)){case APP_UNRECOVERABLE:return this.unrecoverableError();case APP_ERROR:case APP_PAUSED:return this.resume();case APP_LOADING:return this.cancel();}
var appContext=app.manifestURL.replace('app://','').replace('/manifest.webapp','');window.performance.mark('appLaunch@'+appContext);if(this.entryPoint){return app.launch(this.entryPoint);}
return app.launch();}};exports.GaiaGrid.Mozapp=Mozapp;}(window));;'use strict';(function(exports){function Placeholder(){this.detail={type:'placeholder',index:0};}
Placeholder.prototype={__proto__:GaiaGrid.GridItem.prototype,get pixelHeight(){return this.grid.layout.gridItemHeight;},createsGroupOnDrop:false,gridWidth:1,persistToDB:false,get name(){return'';},render:function(){if(!this.element){var tile=document.createElement('div');tile.className='icon placeholder';tile.style.height=this.pixelHeight+'px';this.element=tile;this.grid.element.appendChild(tile);}
this.transform(this.x,this.y,this.grid.layout.percent);},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}}};exports.GaiaGrid.Placeholder=Placeholder;}(window));;'use strict';(function(exports){const maxIconsPerRow=4;const iconScaleFactorMaxIconsPerRow=5;const minIconsPerRow=3;const iconScaleFactorMinIconsPerRow=3.8;const distanceBetweenIconsWithMinIconsPerRow=36;const distanceBetweenIconsWithMaxIconsPerRow=38;const eachTextRowHeight=20;var constraintSize;function GridLayout(gridView){this.gridView=gridView;if(window.verticalPreferences){verticalPreferences.get('grid.cols').then(value=>{this.cols=value;this.onReady();},this.onReady);verticalPreferences.addEventListener('updated',this);}else{this.onReady();}}
GridLayout.prototype={minIconsPerRow:minIconsPerRow,maxIconsPerRow:maxIconsPerRow,_cols:minIconsPerRow,_offsetY:0,_percent:1,_dividerLineHeight:0,get percent(){return this._percent;},get cols(){return this._cols;},set cols(value){if(!value||value===this._cols){return;}
if(window.verticalPreferences){verticalPreferences.put('grid.cols',value);}
this._offsetY=0;this._percent=value==minIconsPerRow?1:minIconsPerRow/maxIconsPerRow;this._cols=value;},get constraintSize(){if(!constraintSize){this.calculateSize();}
return constraintSize;},get gridItemHeight(){var height=this.gridIconSize+
(this._cols===minIconsPerRow?distanceBetweenIconsWithMinIconsPerRow:distanceBetweenIconsWithMaxIconsPerRow);var defaultTextRows=2;var definedRows=parseInt(this.gridView.element.getAttribute('text-rows'),10);if(definedRows>defaultTextRows){height+=(definedRows-defaultTextRows)*eachTextRowHeight;}
return height;},get gridItemWidth(){return this.constraintSize/this._cols;},get gridMaxIconSize(){var baseSize=(this.constraintSize/iconScaleFactorMinIconsPerRow);return baseSize*devicePixelRatio;},get gridIconSize(){var numCols=this._cols;var size=this.constraintSize/numCols;if(numCols===minIconsPerRow){size=this.constraintSize/iconScaleFactorMinIconsPerRow;}else if(numCols===maxIconsPerRow){size=this.constraintSize/iconScaleFactorMaxIconsPerRow;}
return Math.floor(size);},get offsetY(){return this._offsetY;},set offsetY(value){this._offsetY=value;},stepYAxis:function(value){this._offsetY+=value;},handleEvent:function(e){switch(e.type){case'updated':var prop=e.target;if(prop.name==='grid.cols'){this.cols=parseInt(prop.value,10);this.gridView.render();}
break;}},calculateSize:function(){constraintSize=Math.min(window.screen.width,window.screen.height);},onReady:function(){window.dispatchEvent(new CustomEvent('gaiagrid-layout-ready'));}};exports.GridLayout=GridLayout;}(window));;'use strict';(function(exports){const ACTIVE_SCALE=1.4;const COLLECTION_DROP_SCALE=0.5;const EDIT_LONG_PRESS_DELAY=200;const EDIT_LONG_PRESS_THRESHOLD=4*devicePixelRatio;const REARRANGE_DELAY=30;const EDGE_PAGE_THRESHOLD=50;const REARRANGE_COLLECTION_DELAY=500;const TOUCH_END_FINISH_DELAY=20;const REARRANGE_FREQUENCY=100;const REARRANGE_COOLDOWN=750;const SCREEN_HEIGHT=window.innerHeight;const scrollStep=Math.round(SCREEN_HEIGHT/EDGE_PAGE_THRESHOLD);const maxScrollStepFactor=5;function DragDrop(gridView){this.gridView=gridView;this.container=gridView.element;this.scrollable=document.documentElement;this.container.addEventListener('touchstart',this);this.container.addEventListener('touchmove',this);this.container.addEventListener('touchend',this);window.addEventListener('touchcancel',this);this.container.addEventListener('click',this);this.container.addEventListener('contextmenu',this);}
DragDrop.prototype={target:null,longPressTimeout:null,touchStart:{x:0,y:0,screenX:0,screenY:0},dirty:false,inEditMode:false,hoverItem:null,hoverGroup:null,collectionsPort:null,editHeaderElement:null,rearrangeGridTimeout:null,lastRepositionTime:0,get activeScale(){return ACTIVE_SCALE;},get inDragAction(){return this.target&&this.target.classList.contains('active');},get touchEndFinishDelay(){return TOUCH_END_FINISH_DELAY;},begin:function(e){this.gridView.stop();window.dispatchEvent(new CustomEvent('gaiagrid-dragdrop-begin'));this.hoverItem=null;this.rearrangeDelay=null;this.doRearrange=null;this.enterEditMode();this.container.classList.add('dragging');this.icon.scale=ACTIVE_SCALE;this.icon.setActive(true);this.container.parentNode.style.overflow='hidden';this.initialPageX=(typeof e.pageX==='undefined')?this.icon.x:e.pageX;this.initialPageY=(typeof e.pageY==='undefined')?this.icon.y:e.pageY;this.currentTouch={pageX:this.initialPageX,pageY:this.initialPageY};var items=this.gridView.items;var lastElement=items[items.length-1];this.maxScroll=lastElement.y+lastElement.pixelHeight+
(this.icon.pixelHeight*ACTIVE_SCALE);var itemIndex=this.icon.detail.index;if(this.icon.detail.type==='divider'){this.icon.element.classList.add('invalid-drop');if(itemIndex>0){for(var i=itemIndex-1;i>=0;i--){var item=items[i];if(item.detail.type==='divider'){item.element.classList.add('invalid-drop');break;}}}}else{var itemBefore=itemIndex?items[itemIndex-1]:null;var itemAfter=items[itemIndex+1];if((itemAfter.detail.type==='placeholder'||itemAfter.detail.type==='divider')&&(!itemBefore||itemBefore.detail.type==='divider')){if(itemBefore){itemBefore.element.classList.add('invalid-drop');}
var group,groupIndex=itemIndex;do{group=items[++groupIndex];}while(group.detail.type!=='divider');group.element.classList.add('invalid-drop');}}
this.updateIconPosition();this.rearrangeGrid();},finish:function(){if(this.rearrangeGridTimeout!==null){this.rearrangeGrid();}
this.icon.element.addEventListener('transitionend',this);this.currentTouch=null;if(this.doRearrange!==null){if(this.rearrangeDelay){clearTimeout(this.rearrangeDelay);}
if(this.hoverItem&&this.hoverItem.detail.type==='collection'){window.dispatchEvent(new CustomEvent('gaiagrid-add-to-collection',{detail:{'collectionId':this.hoverItem.detail.id,'identifier':this.icon.identifier}}));var scale=this.gridView.layout.percent*COLLECTION_DROP_SCALE;var scaleAdjustX=((this.gridView.layout.gridItemWidth*this.icon.scale)-
(this.gridView.layout.gridItemWidth*scale))/2;var scaleAdjustY=((this.gridView.layout.gridItemHeight*this.icon.scale)-
(this.gridView.layout.gridItemHeight*scale))/2;var clone=this.icon.element.cloneNode(true);clone.classList.add('dropped');this.icon.element.parentNode.appendChild(clone);clone.clientWidth;var destroyOnTransitionEnd=function(){this.parentNode.removeChild(this);this.removeEventListener('transitionend',destroyOnTransitionEnd);}.bind(clone);clone.addEventListener('transitionend',destroyOnTransitionEnd);clone.style.opacity=0;this.icon.transform(this.hoverItem.x+scaleAdjustX,this.hoverItem.y+scaleAdjustY,scale,clone);this.icon.transform(this.icon.x+scaleAdjustX,this.icon.y+scaleAdjustY,scale);this.icon.element.clientWidth;}else{this.doRearrange.call(this);}}else{this.icon.requestAttention();}
this.icon.scale=1;this.icon.setActive(false);this.icon.element.classList.remove('hovering');this.target=null;this.gridView.render();if(this.dirty){window.dispatchEvent(new CustomEvent('gaiagrid-saveitems'));}
this.dirty=false;setTimeout(function nextTick(){this.gridView.start();window.dispatchEvent(new CustomEvent('gaiagrid-dragdrop-finish'));}.bind(this));},finalize:function(){this.container.parentNode.style.overflow='';this.container.classList.remove('dragging');this.container.classList.remove('hover-over-top');if(this.icon){this.icon.element.removeEventListener('transitionend',this);this.icon=null;}
if(this.hoverItem){this.hoverItem.element.classList.remove('hovered');this.hoverItem=null;}
if(this.hoverGroup){this.hoverGroup.element.classList.remove('drop-target');this.hoverGroup=null;}
for(var i=0,iLen=this.gridView.items.length;i<iLen;i++){var item=this.gridView.items[i];item.element.classList.remove('invalid-drop');}},getScrollStep:function(distanceToEdge){var factor=maxScrollStepFactor;if(distanceToEdge>0){factor*=((EDGE_PAGE_THRESHOLD-distanceToEdge)/EDGE_PAGE_THRESHOLD);}
return Math.round(scrollStep*factor);},positionAndScrollIfNeeded:function(){var touch=this.currentTouch;if(!touch||!this.inDragAction){this.isScrolling=false;return;}
var scrollStep;var docScroll=this.scrollable.scrollTop;var distanceFromTop=Math.abs(touch.pageY-docScroll);var distanceFromHeader=distanceFromTop-
(this.editHeaderElement?this.editHeaderElement.clientHeight:0);this.isScrolling=true;if(distanceFromTop>SCREEN_HEIGHT-EDGE_PAGE_THRESHOLD){var maxY=this.maxScroll;scrollStep=this.getScrollStep(SCREEN_HEIGHT-distanceFromTop);if(touch.pageY>=maxY||maxY-touch.pageY<scrollStep){this.isScrolling=false;}}else if(touch.pageY>0&&distanceFromHeader<EDGE_PAGE_THRESHOLD){scrollStep=-this.getScrollStep(distanceFromHeader);scrollStep=Math.max(scrollStep,-this.scrollable.scrollTop);if(scrollStep>=0){this.isScrolling=false;}}else{this.isScrolling=false;}
if(!this.isScrolling){this.updateIconPosition();this.deferredRearrangeGrid();return;}
this.updateIconPosition();this.scrollable.scrollTop+=scrollStep;touch.pageY+=scrollStep;exports.requestAnimationFrame(this.positionAndScrollIfNeeded.bind(this));},highlightGroup:function(index){for(var i=index,iLen=this.gridView.items.length;i<iLen;i++){var item=this.gridView.items[i];if(item.detail.type==='divider'){if(this.hoverGroup!=item){if(this.hoverGroup){this.hoverGroup.element.classList.remove('drop-target');}
this.hoverGroup=item;item.element.classList.add('drop-target');}
break;}}},inFirstGroup:function(index){for(var i=index;i>=0;i--){if(this.gridView.items[i].detail.type==='divider'){return false;}}
return true;},updateIconPosition:function(){var oldX=this.icon.x;var oldY=this.icon.y;var newX=this.currentTouch.pageX-(this.initialPageX-this.icon.x);var newY=this.currentTouch.pageY-(this.initialPageY-this.icon.y);if(this.icon.detail.type!=='divider'){newX=newX-((this.icon.scale*this.gridView.layout.gridItemWidth)-
this.gridView.layout.gridItemWidth)/2;newY=newY-((this.icon.scale*this.icon.pixelHeight)-
this.icon.pixelHeight)/2;}
this.icon.setCoordinates(newX,newY);this.icon.render();this.icon.setCoordinates(oldX,oldY);},deferredRearrangeGrid:function(){if(this.rearrangeGridTimeout!==null){return;}
var delay=Math.max(REARRANGE_FREQUENCY,REARRANGE_COOLDOWN-
Math.max(0,Date.now()-this.lastRepositionTime));this.rearrangeGridTimeout=setTimeout(()=>{this.rearrangeGridTimeout=null;this.rearrangeGrid();},delay);},rearrangeGrid:function(){if(this.rearrangeGridTimeout!==null){clearTimeout(this.rearrangeGridTimeout);this.rearrangeGridTimeout=null;}
if(this.isScrolling){return;}
var iconIsDivider=this.icon.detail.type==='divider';var pageX=this.currentTouch.pageX-(this.initialPageX-this.icon.x);var pageY=this.currentTouch.pageY-(this.initialPageY-this.icon.y);var foundIndex=0;var insertDividerAtTop=!this.gridView.config.features.disableSections;pageX+=this.gridView.layout.gridItemWidth/2;pageY+=this.icon.pixelHeight/2;if(pageY>=0){foundIndex=this.gridView.getNearestItemIndex(pageX,pageY,iconIsDivider);if(!(iconIsDivider&&foundIndex===0)){this.container.classList.remove('hover-over-top');insertDividerAtTop=false;}}
this.doRearrange=null;if(this.rearrangeDelay){clearTimeout(this.rearrangeDelay);this.rearrangeDelay=null;}
if(this.hoverItem){this.hoverItem.element.classList.remove('hovered');this.hoverItem=null;}
if(foundIndex!==null){this.icon.element.classList.add('hovering');}else{this.icon.element.classList.remove('hovering');}
if(!insertDividerAtTop&&(foundIndex===null||foundIndex===this.icon.detail.index)){if(!iconIsDivider){this.highlightGroup(this.icon.detail.index);}
return;}
var foundItem=this.gridView.items[foundIndex];if(iconIsDivider&&foundIndex>0&&foundItem.detail.type!=='divider'){this.icon.element.classList.remove('hovering');return;}
if(!insertDividerAtTop&&(foundItem.detail.type!=='collection'||(this.icon.detail.type!=='collection'&&!iconIsDivider))){this.hoverItem=foundItem;this.hoverItem.element.classList.add('hovered');}
var rearrangeAfterDelay=!iconIsDivider;var createDivider=insertDividerAtTop;if(!insertDividerAtTop&&!iconIsDivider&&(foundItem.detail.type==='divider')){if(foundItem.detail.collapsed&&pageY<=foundItem.y+(foundItem.pixelHeight*2/3)){rearrangeAfterDelay=false;foundItem.element.classList.remove('hovered');if(this.icon.detail.index<foundIndex){foundItem=this.gridView.items[foundIndex-1];}}else{createDivider=true;}}
if(createDivider){if(this.hoverGroup){this.hoverGroup.element.classList.remove('drop-target');this.hoverGroup=null;}
var redundantRearrange=false;if(insertDividerAtTop){if(iconIsDivider){redundantRearrange=this.inFirstGroup(this.icon.detail.index-1);}else{redundantRearrange=(this.icon.detail.index===0&&this.gridView.items[1].detail.type==='placeholder');}}else{redundantRearrange=this.gridView.items[foundIndex].element.classList.contains('invalid-drop');}
if(redundantRearrange){if(this.hoverItem){this.hoverItem.element.classList.remove('hovered');this.hoverItem=null;}
return;}else if(insertDividerAtTop){this.container.classList.add('hover-over-top');}
this.doRearrange=this.createNewDivider.bind(this,insertDividerAtTop?null:foundItem);}else{if(!iconIsDivider){this.highlightGroup(foundIndex);}
this.doRearrange=this.rearrange.bind(this,foundItem);if(rearrangeAfterDelay){this.rearrangeDelay=setTimeout(this.doRearrange.bind(this),this.hoverItem&&this.hoverItem.detail.type==='collection'?REARRANGE_COLLECTION_DELAY:REARRANGE_DELAY);}}},createNewDivider:function(tDivider){var items=this.gridView.items;var tIndex=tDivider?items.indexOf(tDivider)+1:0;var newDivider=new GaiaGrid.Divider();items.splice(tIndex,0,newDivider);var sIndex=items.indexOf(this.icon);this.rearrange(sIndex>=tIndex?newDivider:tDivider);newDivider.requestAttention();},rearrange:function(tItem){this.doRearrange=null;this.rearrangeDelay=null;var sIndex=this.gridView.items.indexOf(this.icon);var tIndex=this.gridView.items.indexOf(tItem);var eIndex=sIndex;if(this.icon.detail.type==='divider'){for(;sIndex>0&&this.gridView.items[sIndex-1].detail.type!=='divider';sIndex--){}
if(this.gridView.items[tIndex].detail.type==='divider'){tIndex++;}else{tIndex=0;}
if(sIndex===tIndex){return;}}else if(sIndex<tIndex){tIndex++;}
tItem=this.gridView.items[tIndex];var lastItemOffset=eIndex-sIndex;var toInsert=this.gridView.items.splice(sIndex,lastItemOffset+1);toInsert.unshift(tItem?this.gridView.items.indexOf(tItem):this.gridView.items.length,0);this.rearrangeDelay=null;this.dirty=true;this.gridView.items.splice.apply(this.gridView.items,toInsert);var oldX=this.icon.x;var oldY=this.icon.y;this.gridView.render();this.initialPageX-=oldX-this.icon.x;this.initialPageY-=oldY-this.icon.y;this.lastRepositionTime=Date.now();},enterEditMode:function(){this.inEditMode=true;this.container.classList.add('edit-mode');document.body.classList.add('edit-mode');this.gridView.element.dispatchEvent(new CustomEvent('editmode-start'));document.addEventListener('visibilitychange',this);this.container.addEventListener('collection-close',this);this.gridView.render();},exitEditMode:function(){if(this.icon){this.finish();this.finalize();}
this.inEditMode=false;this.cancelLongPressTimeout();this.container.classList.remove('edit-mode');document.body.classList.remove('edit-mode');this.gridView.element.dispatchEvent(new CustomEvent('editmode-end'));document.removeEventListener('visibilitychange',this);this.container.removeEventListener('collection-close',this);this.gridView.render();},cancelLongPressTimeout:function(){if(this.longPressTimeout!==null){clearTimeout(this.longPressTimeout);this.longPressTimeout=null;}},inLongPressThreshold:function(x,y){return(Math.abs(x-this.touchStart.screenX)<EDIT_LONG_PRESS_THRESHOLD&&Math.abs(y-this.touchStart.screenY)<EDIT_LONG_PRESS_THRESHOLD);},handleEvent:function(e){switch(e.type){case'collection-close':this.exitEditMode();break;case'visibilitychange':if(document.hidden){this.exitEditMode();}
break;case'touchstart':this.cancelLongPressTimeout();if(e.touches.length>1){if(this.inDragAction){this.finish();}
return;}
if(this.inEditMode){this.touchStart.x=e.touches[0].pageX;this.touchStart.y=e.touches[0].pageY;this.touchStart.screenX=e.touches[0].screenX;this.touchStart.screenY=e.touches[0].screenY;this.longPressTimeout=setTimeout(()=>{this.longPressTimeout=null;this.handleEvent({type:'contextmenu',target:e.target,pageX:this.touchStart.x,pageY:this.touchStart.y,preventDefault:function(){},stopImmediatePropagation:function(){}});},EDIT_LONG_PRESS_DELAY);}
break;case'contextmenu':this.cancelLongPressTimeout();if(this.gridView._collectionOpen||this.icon){e.stopImmediatePropagation();e.preventDefault();return;}
if(e.defaultPrevented){return;}
if(!e.target){return;}
this.icon=this.gridView.findItemFromElement(e.target,true);if(!this.icon||!this.icon.element||!this.icon.isDraggable()||this.icon.detail.type==='placeholder'){this.icon=null;return;}
e.stopImmediatePropagation();e.preventDefault();this.target=this.icon.element;this.begin(e);break;case'touchmove':var touch=e.touches[0];if(this.inDragAction){this.currentTouch={pageX:touch.pageX,pageY:touch.pageY};if(!this.isScrolling){this.positionAndScrollIfNeeded();}}else if(this.longPressTimeout!==null&&!this.inLongPressThreshold(touch.screenX,touch.screenY)){this.cancelLongPressTimeout();}
break;case'click':case'touchcancel':if(this.inDragAction){this.finish();this.finalize();}
this.cancelLongPressTimeout();break;case'touchend':if(this.inDragAction){e.stopImmediatePropagation();e.preventDefault();setTimeout(()=>{this.finish();},TOUCH_END_FINISH_DELAY);}
this.cancelLongPressTimeout();break;case'transitionend':this.finalize();break;}}};exports.GridDragDrop=DragDrop;}(window));;'use strict';(function(exports){const pinchThreshold=Math.round(window.innerWidth/12);function GridZoom(gridView){this.gridView=gridView;this.touches=0;this.zoomStartTouches=[];this.zoomStartDistance=0;this.container=document.getElementById('zoom');this.arrows=this.container.querySelector('.arrows');this.curtain=this.container.querySelector('.curtain');this.indicator=this.container.querySelector('.indicator');this.start();window.addEventListener('gaiagrid-dragdrop-begin',this.stop.bind(this));window.addEventListener('gaiagrid-dragdrop-finish',this.start.bind(this));}
GridZoom.prototype={start:function(){window.addEventListener('touchstart',this);},stop:function(){window.removeEventListener('touchstart',this);},_attachGestureListeners:function(){window.addEventListener('touchmove',this);window.addEventListener('touchend',this);},_stopGestureListeners:function(){window.removeEventListener('touchmove',this);window.removeEventListener('touchend',this);},_resetState:function(){this.zoomInProgress=false;this.container.hidden=true;this.indicator.classList.remove('active');this.arrows.classList.remove('zooming','grow','shrink');this.arrows.style.transform='';},handleEvent:function(e){if(e.type==='touchend'&&this.zoomStartTouches){if(!this.zoomInProgress){this._resetState();}
this._stopGestureListeners();return;}
if(!e.touches||e.touches.length!==2){return;}
var touches=[e.touches[0],e.touches[1]].sort(function(a,b){return a.pageX-b.pageX;});var touchDistance=Math.sqrt((touches[0].pageX-touches[1].pageX)*(touches[0].pageX-touches[1].pageX)+
(touches[0].pageY-touches[1].pageY)*(touches[0].pageY-touches[1].pageY));var layout=this.gridView.layout;switch(e.type){case'touchstart':this.container.hidden=false;this.zoomStartTouches=touches;this.zoomStartDistance=touchDistance;if(layout.cols<layout.maxIconsPerRow){this.arrows.classList.add('grow');}else{this.arrows.classList.add('shrink');}
this.indicator.dataset.cols=layout.cols;this._attachGestureListeners();break;case'touchmove':if(layout.cols<layout.maxIconsPerRow&&touchDistance<this.zoomStartDistance&&Math.abs(touchDistance-this.zoomStartDistance)>pinchThreshold){this.gridView.cols=layout.maxIconsPerRow;this.zoomInProgress=true;}else if(layout.cols>layout.minIconsPerRow&&touchDistance>this.zoomStartDistance&&Math.abs(touchDistance-this.zoomStartDistance)>pinchThreshold){this.gridView.cols=layout.minIconsPerRow;this.zoomInProgress=true;}else{return;}
this._stopGestureListeners();var ontransitionend=function(){this.arrows.removeEventListener('transitionend',ontransitionend);this.indicator.classList.add('active');this.gridView.render();var zoomHideTime=400;setTimeout(this._resetState.bind(this),zoomHideTime);}.bind(this);this.arrows.addEventListener('transitionend',ontransitionend);this.indicator.dataset.cols=layout.cols;this.arrows.classList.add('zooming');document.body.clientHeight;var scaleTransform='scale(1)';if(this.zoomInProgress&&touchDistance<this.zoomStartDistance){scaleTransform='scale(0.4)';}
this.arrows.style.transform=scaleTransform;break;}}};exports.GridZoom=GridZoom;}(window));;window.GaiaGrid=(function(win){'use strict';var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaGridBaseurl||'/shared/elements/gaia_grid/';proto.createdCallback=function(){var shadow=this.createShadowRoot();this._template=template.content.cloneNode(true);this._styleHack();this._grid=new GridView({element:this,features:{dragdrop:this.getAttribute('dragdrop')!==null,zoom:this.getAttribute('zoom')!==null,disableSections:this.getAttribute('disable-sections')!==null}});shadow.appendChild(this._template);};proto.add=function(){this._grid.add.apply(this._grid,arguments);};proto.clear=function(){this._grid.clear.apply(this._grid,arguments);};proto.render=function(){this._grid.layout.calculateSize();this._grid.render.apply(this._grid,arguments);};proto.start=function(){this._grid.start.apply(this._grid,arguments);};proto.stop=function(){this._grid.stop.apply(this._grid,arguments);};proto.getIcons=function(){return this._grid.icons;};proto.getItems=function(){return this._grid.items;};proto.getIcon=function(identifier){return this._grid.icons[identifier];};proto.removeIconByIdentifier=function(identifier){delete this._grid.icons[identifier];};proto.removeItemByIndex=function(itemIndex){this._grid.items.splice(itemIndex,1);};proto.popDivider=function(){var items=this._grid.items;if(items.length&&items[items.length-1].detail.type==='divider'){return items.pop();}
return null;};proto.appendItem=function(item){var items=this._grid.items;var lastIndex=items.length-1;if(items[lastIndex].detail.type==='divider'){this.add(item,lastIndex);}else{this.add(item);}};proto.appendItemToExpandedGroup=function(item){var items=this._grid.items;var lastIndex=items.length-1;if(items[lastIndex].detail.type==='divider'&&items[lastIndex].detail.collapsed){items[lastIndex].expand();}
this.appendItem(item);};proto.setEditHeaderElement=function(element){if(this._grid.dragdrop){this._grid.dragdrop.editHeaderElement=element;}};Object.defineProperty(proto,'maxIconSize',{get:function(){return this._grid.layout.gridMaxIconSize;}});proto.getIndexLastIcon=function(){var items=this._grid.items;for(var i=this._grid.items.length-1;i>=0;i--){if(items[i]instanceof GaiaGrid.Mozapp){return i;}}};proto.removeNonVisualElements=function(){var nonVisualElements=[GaiaGrid.Placeholder];function isNonVisual(elem){var retVal=false;for(var i=0,iLen=nonVisualElements.length;i<iLen&&!retVal;i++){retVal=elem instanceof nonVisualElements[i];}
return retVal;}
var i=0;var iLen=this._grid.items.length;while(i<iLen){this._grid.items[i].detail.index=i;if(isNonVisual(this._grid.items[i])){this._grid.items.splice(i,1);iLen-=1;}else{i+=1;}}};proto.moveTo=function(orig,dst){this._grid.items.splice(dst,0,this._grid.items.splice(orig,1)[0]);};proto._styleHack=function(){var style=this._template.querySelector('style');this.appendChild(style.cloneNode(true));};var stylesheet=baseurl+'style.css';var template=document.createElement('template');template.innerHTML=`<style scoped>
    @import url(${stylesheet});</style>
    <content></content>`;return document.registerElement('gaia-grid',{prototype:proto});})(window);;'use strict';window.GaiaMenu=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaMenuBaseurl||'/shared/elements/gaia_menu/';proto.createdCallback=function(){var shadow=this.createShadowRoot();this._template=template.content.cloneNode(true);var cancelButton=this._template.querySelector('.gaia-menu-cancel');cancelButton.addEventListener('click',function(){this.hide();this.dispatchEvent(new CustomEvent('gaiamenu-cancel'));}.bind(this));shadow.appendChild(this._template);ComponentUtils.style.call(this,baseurl);navigator.mozL10n.ready(this.localize.bind(this));};proto.localize=function(){this.shadowRoot.querySelector('button').setAttribute('data-l10n-id','gaia-menu-cancel');};proto.show=function(){this.removeAttribute('hidden');};proto.hide=function(){this.setAttribute('hidden','hidden');};var template=document.createElement('template');template.innerHTML=`<form role="dialog" data-type="action">
      <content select="header"></content>
      <menu>
        <content select="button"></content>
        <button class="gaia-menu-cancel">Cancel</button>
      </menu>
    </form>`;return document.registerElement('gaia-menu',{prototype:proto});})(window);;'use strict';(function(exports){const mozSettings=navigator.mozSettings;const DEBUG=true;var initPromise=null;var slice=Function.call.bind(Array.prototype.slice);exports.eme={config:{apiUrl:null},init:function init(){if(initPromise){return initPromise;}
initPromise=this.readSettings().then(function success(settings){if(settings['appsearch.url']){this.config.apiUrl=settings['appsearch.url'];}
return this.device.init(settings);}.bind(this),function error(e){eme.log('fatal error accessing device settings',e);}).catch(function(e){eme.log('init failed',e);});this.init=function noop(){eme.log('init: noop');return initPromise;};return initPromise;},readSettings:function readSettings(){return new Promise(function ready(resolve,reject){var lock=mozSettings.createLock();var request=lock.get('*');request.onsuccess=function onsuccess(){resolve(request.result);};request.onerror=function onerror(){reject(request.error);};}.bind(this));},log:function log(){if(DEBUG){var args=slice(arguments);args.unshift('evme');console.log.apply(console,args);}},warn:function warn(){var args=slice(arguments);args.unshift('evme','WARNING');console.warn.apply(console,args);},error:function error(){var args=slice(arguments);args.unshift('evme','ERROR');console.error.apply(console,args);}};})(window);;'use strict';(function(eme){var PREFIX='eme-cache';var slice=Function.call.bind(Array.prototype.slice);function Cache(){}
Cache.prototype={generateKey:function cache_generateKey(){return slice(arguments).map(JSON.stringify).join('|');},add:function cache_add(key,value){return new Promise(function ready(resolve,reject){asyncStorage.setItem(PREFIX+key,value);});},get:function cache_get(key){return new Promise(function ready(resolve,reject){asyncStorage.getItem(PREFIX+key,function onValue(value){if(value===null){reject(null);}else{resolve(value);}});});},addRequest:function cache_addRequest(service,method,options,response){this.add(this.generateKey(service,method,options),response);},getRequest:function cache_getRequest(service,method,options){return this.get(this.generateKey(service,method,options));}};eme.Cache=new Cache();})(window.eme);;'use strict';(function(eme){const NETWORK_ERROR='network error';const API_KEY='79011a035b40ef3d7baeabc8f85b862f';const ICON_FORMAT=20;var device=eme.device;function getCtx(){var w=device.screen.width;var h=device.screen.height;return{lc:device.language||undefined,tz:device.timezone||undefined,v:device.osVersion||undefined,dn:device.deviceName||undefined,cr:device.carrier||undefined,ct:device.dataConnectionType||undefined,mcc:device.mcc||undefined,mnc:device.mnc||undefined,sr:(w&&h)?[w,h].join('x'):undefined};}
function Request(service,method,options){if(!eme.config.apiUrl){return new Promise(function(resolve,reject){reject('eme.config.apiUrl not defined');});}
var resource=service+'/'+method;var url=eme.config.apiUrl.replace('{resource}',resource);var payload='';options=options?options:{};options.apiKey=API_KEY;options.deviceId=eme.device.deviceId;options.ctx=getCtx();for(var opt in options){var value=options[opt];if(value!==null&&value!==undefined){if(typeof value==='object'){value=JSON.stringify(value);}
payload+=opt+'='+encodeURIComponent(value)+'&';}}
eme.log('API request:',decodeURIComponent(url+'?'+payload));var httpRequest;var promise=new Promise(function done(resolve,reject){httpRequest=new XMLHttpRequest({mozSystem:true});httpRequest.open('POST',url,true);httpRequest.setRequestHeader('Content-Type','application/x-www-form-urlencoded');httpRequest.onload=function onload(e){var response=null;try{response=JSON.parse(httpRequest.responseText);}catch(ex){reject(ex);}
if(response&&response.errorCode>0){resolve(response);}else{reject(response?'errorCode: '+response.errorCode:'invalid response');}};httpRequest.onerror=function onError(e){reject(NETWORK_ERROR);};httpRequest.send(payload);});promise.abort=function(){if(httpRequest.abort){httpRequest.abort();}};return promise;}
function SanitizeAppSearch(result){return new Promise(function(resolve,reject){var apps=result.response.apps;if(apps.length){var a=document.createElement('a');for(var i=0,iLen=apps.length;i<iLen;i++){a.href=apps[i].appUrl;apps[i].appUrl=a.href;}}
resolve(result);});}
function PartnersAPI(){this.Apps={MAX_QUERY_LENGTH:128,nativeInfo:function nativeInfo(options){if(options.guids&&options.guids.length){options.guids=JSON.stringify(options.guids);}
return Request('Apps','nativeInfo',options);},search:function search(options){if(!!options.query&&options.query.length>this.MAX_QUERY_LENGTH){options.query=options.query.substr(0,this.MAX_QUERY_LENGTH);}
options.iconFormat=ICON_FORMAT;return Request('Apps','search',options).then(SanitizeAppSearch);}};this.Search={suggestions:function suggestions(options){return Request('Search','suggestions',options);},bgimage:function bgimage(options){options.width=Math.ceil(options.width||eme.device.screen.width);options.height=Math.ceil(options.height||eme.device.screen.height);return Request('Search','bgimage',options);}};this.Categories={list:function list(options){var request=Request('Categories','list',options);return request.then(response=>{eme.Cache.addRequest('Categories','list',options,response);return response;},()=>{return eme.Cache.getRequest('Categories','list',options).then(response=>{eme.log('using cached response (Categories/list)');return response;}).catch(()=>Promise.reject(NETWORK_ERROR));});}};}
eme.api=new PartnersAPI();})(window.eme);;'use strict';(function(exports){function chooseBackgroundRatio(pixelRatio){var backgroundOptions=[1,1.5,2,2.25];return Math.max.apply(null,backgroundOptions.filter((r)=>pixelRatio>=r));}
const backgroundRatio=chooseBackgroundRatio(window.devicePixelRatio);const suffix=backgroundRatio===1?'.jpg':('@'+backgroundRatio+'x.jpg');const mozCdnPath='/collection/background/{categoryId}'+suffix;const APPS_IN_ICON=3;function Common(){}
Common.prototype={cdnHost:null,APPS_IN_ICON:APPS_IN_ICON,chooseBackgroundRatio:chooseBackgroundRatio,b64toBlob:function b64toBlob(b64){return new Promise((resolve,reject)=>{var img=new Image();img.onload=function onload(){var canvas=document.createElement('canvas');canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext('2d');ctx.drawImage(img,0,0,canvas.width,canvas.height);canvas.toBlob(resolve);};img.onerror=reject;img.src=b64;});},getMozBackground:function getMozBackground(collection){if(!collection.categoryId){return Promise.reject('no categoryId');}
if(this.cdnHost){return this._fetchMozBackground(collection);}
return new Promise((resolve,reject)=>{var req=navigator.mozSettings.createLock().get('cdn.url');req.onsuccess=()=>{this.cdnHost=req.result['cdn.url'];resolve();};}).then(this._fetchMozBackground.bind(this,collection));},_fetchMozBackground:function(collection){var url=this.cdnHost+mozCdnPath.replace('{categoryId}',collection.categoryId);var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',url,true);xhr.responseType='blob';return new Promise((resolve,reject)=>{xhr.onload=function onload(){if(xhr.status===200){var blob=new Blob([xhr.response],{type:'image/jpg'});eme.log('getMozBackground','success',url);resolve({blob:blob,source:url,checksum:'mozilla'});}else{reject('xhr.status '+xhr.status);}};xhr.onerror=function onerror(){reject('xhr error');};xhr.send();});},getEmeBackground:function getEmeBackground(collection,size){var checksum;var options={width:size||undefined,height:size||undefined};if(collection.categoryId){options.categoryId=collection.categoryId;}
else{options.query=collection.query;}
if(collection.background){checksum=collection.background.checksum;if(collection.background.blob){options._checksum=checksum;}}
return eme.api.Search.bgimage(options).then((response)=>{if(checksum&&checksum===response.checksum){eme.log('background didn\'t change (checksum match)');return collection.background;}else{var b64;var image=response.response.image;if(image){b64=image.data;if(/image\//.test(image.MIMEType)){b64='data:'+image.MIMEType+';base64,'+image.data;}}
return this.b64toBlob(b64).then(function toBg(blob){return{blob:blob,source:response.response.source,checksum:response.checksum||null};});}});},getBackground:function getBackground(collection,size){return this.getMozBackground(collection).catch(function(e){eme.log('getBackground',e,'trying e.me background');return this.getEmeBackground(collection,size);}.bind(this)).catch(function(e){eme.log('getBackground','failed',e);});},getWebIcons:function getWebIcons(collection){var options=(collection.categoryId)?{categoryId:collection.categoryId}:{query:collection.query};options.limit=APPS_IN_ICON;return eme.api.Apps.search(options).then(response=>{var webicons=response.response.apps.slice(0,APPS_IN_ICON).map(app=>app.icon);return webicons;});},prepareAssets:function prepareAssets(collection){var ready=Promise.resolve(null);var backgroundPromise=collection.backgroundReady?ready:this.getBackground(collection);var iconsPromise=collection.iconsReady?ready:this.getWebIcons(collection);return Promise.all([iconsPromise,backgroundPromise]).then((results)=>{collection.webicons=results[0]||collection.webicons;collection.background=results[1]||collection.background;return collection;});}};exports.Common=new Common();}(window));;'use strict';(function(exports){const APPS_IN_ICON=Common.APPS_IN_ICON;function WebResult(data,gridItemFeatures){data.emeId=data.id;data.url=data.id=data.appUrl;data.renderer=GridIconRenderer.TYPE.CLIP;return{identifier:data.appUrl,type:'webResult',data:data,features:gridItemFeatures};}
function PinnedHomeIcon(identifier){return{identifier:identifier,type:'homeIcon'};}
function BaseCollection(props){this.id=props.id||null;this.name=props.name||'';this.nonTranslatable=props.nonTranslatable||null;this.icon=props.icon||null;this.pinned=props.pinned||[];this.webResults=[];this.webicons=props.webicons||[];this.background=props.background||{};this.originalProps={pinned:props.pinned?props.pinned.slice():[],background:props.background||{}};if(window.SearchDedupe){this.dedupe=new SearchDedupe();}}
BaseCollection.create=function create(data){if(data.categoryId){return new CategoryCollection(data);}else if(data.query){return new QueryCollection(data);}
return null;};BaseCollection.prototype={get iconsReady(){return this.pinned.length+this.webicons.length>=APPS_IN_ICON;},get backgroundReady(){return this.background&&this.background.blob;},get localizedName(){if(this.nonTranslatable){return this.name;}
var l10nId='collection-categoryId-'+this.categoryId;return navigator.mozL10n.get(l10nId)||this.name;},refresh:function refresh(){return CollectionsDatabase.get(this.id).then(function create(fresh){this.pinned=fresh.pinned||[];}.bind(this));},rename:function rename(name){this.name=name;this.nonTranslatable=true;return this.write();},save:function save(method){if(this.iconDirty){return this.renderIcon().then(()=>this.write(method),()=>this.write(method));}else{return this.write(method);}},write:function write(method){method=method||'put';var toSave={id:this.id,name:this.name,nonTranslatable:this.nonTranslatable,query:this.query,categoryId:this.categoryId,cName:this.cName,webicons:this.webicons,pinned:this.pinned,background:this.background,icon:this.icon};this.originalProps=toSave;return CollectionsDatabase[method](toSave).then(()=>{this.id=toSave.id;eme.log(this.name,'saved to CollectionsDatabase');});},get iconDirty(){var original=this.originalProps;try{if((original.background&&original.background.blob)!==(this.background&&this.background.blob)){return true;}
var first=this.pinned.concat(this.webResults).slice(0,APPS_IN_ICON);var oFirst=original.pinned.concat(original.webResults).slice(0,APPS_IN_ICON);if(first.length!==oFirst.length){return true;}
for(var i=0;i<APPS_IN_ICON;i++){var item=first[i];var oItem=oFirst[i];if((item&&item.identifier)!==(oItem&&oItem.identifier)){return true;}}}catch(e){eme.error('icon dirty checking failed',e);}
return false;},pin:function pin(){var arg=arguments[0];var items=Array.isArray(arg)?arg:[arg];var newItems=items.filter(this.isNotPinned.bind(this));if(newItems.length){this.pinned=this.pinned.concat(newItems);this.save().then(()=>eme.log(newItems.length,'new pinned to',this.name));}},pinHomeIcons:function pinHomeIcons(identifiers){var items=identifiers.map(function each(identifier){return new PinnedHomeIcon(identifier);});this.pin(items);},dropHomeIcon:function dropHomeIcon(identifier){var newPinned=new PinnedHomeIcon(identifier);for(var i=0,iLen=this.pinned.length;i<iLen;i++){if(this.pinned[i].identifier===identifier){this.pinned.splice(i,1);break;}}
this.pinned.unshift(newPinned);this.save().then(()=>eme.log(identifier,'dropped into',this.name));},pinWebResult:function pinWebResult(data){this.pin(new WebResult(data));},unpin:function unpin(identifier){var idx=this.pinnedIdentifiers.indexOf(identifier);if(idx!==-1){this.pinned.splice(idx,1);return this.save().then(()=>eme.log('removed pinned item',identifier));}},addWebResults:function addWebResult(arrayOfData){var results=arrayOfData.map(function each(data){return new WebResult(data,{isDraggable:false,isRemovable:false});});this.webResults=results;this.webicons=arrayOfData.slice(0,APPS_IN_ICON).map(app=>app.icon);},isPinned:function isPinned(item){return this.pinnedIdentifiers.indexOf(item.identifier)>-1;},isNotPinned:function isNotPinned(item){return!this.isPinned(item);},setPinned:function setPinned(identifiers){this.pinned=identifiers.slice(0,this.pinned.length).map(function(identifier){var idx=this.pinnedIdentifiers.indexOf(identifier);return this.pinned[idx];}.bind(this));this.save();},get pinnedIdentifiers(){return this.pinned.map(function each(item){return item.identifier;});},removeBookmark:function removeBookmark(identifier){window.dispatchEvent(new CustomEvent('collection-remove-webresult',{detail:{identifier:identifier}}));},toGridObject:function(item){var icon;if(item.type==='homeIcon'){if(!HomeIcons.ready){eme.warn('HomeIcons not ready, pinned apps may not render properly');}
icon=HomeIcons.get(item.identifier);}else if(item.type==='webResult'){item.features=item.features||{};item.features.isEditable=false;item.features.search=true;icon=new GaiaGrid.Bookmark(item.data,item.features);if(icon.isRemovable){icon.remove=()=>this.removeBookmark(item.identifier);}}
if(!icon){eme.error(item.identifier,'home icon not found');}
return icon;},addToGrid:function addToGrid(items,grid){items.forEach(function eachResult(item){item.dedupeId=item.identifier;});items=this.dedupe.reduce(items,'fuzzy');items.forEach(function render(item){if(!item||!item.identifier){return;}
var icon=this.toGridObject(item);if(icon){grid.add(icon);}},this);},addItemToGrid:function addItemToGrid(item,grid,position){this.pinned.splice(position,1,new PinnedHomeIcon(item.identifier));grid.add(this.toGridObject(item),position);if(this.pinned.length===1){grid.add(new GaiaGrid.Divider(),1);}
grid.render();this.renderIcon();},renderWebResults:function render(grid){if(!this.webResults.length){return;}
grid.add(new GaiaGrid.Divider());this.addToGrid(this.webResults,grid);grid.render({from:this.pinned.length});},render:function render(grid){this.dedupe.reset();grid.clear();this.addToGrid(this.pinned,grid);if(this.webResults.length){grid.add(new GaiaGrid.Divider());this.addToGrid(this.webResults,grid);}
grid.render();},renderIcon:function renderIcon(){eme.log('rendering icon for',this.name);return Common.prepareAssets(this).then(()=>this.doRenderIcon(),()=>this.doRenderIcon()).catch((e)=>{eme.error('icon rendering failed',e);});},doRenderIcon:function doRenderIcon(){var iconSrcs=this.pinned.slice(0,APPS_IN_ICON).map((item)=>this.toGridObject(item).icon);if(iconSrcs.length<APPS_IN_ICON){var moreIcons=this.webicons.filter((webicon)=>iconSrcs.indexOf(webicon)===-1).slice(0,APPS_IN_ICON-iconSrcs.length);iconSrcs=iconSrcs.concat(moreIcons);}
var bgSrc=(this.background&&this.background.blob)?URL.createObjectURL(this.background.blob):null;var icon=new CollectionIcon({iconSrcs:iconSrcs,bgSrc:bgSrc});return icon.render().then((canvas)=>{this.icon=canvas.toDataURL();});}};function CategoryCollection(props){BaseCollection.call(this,props);this.categoryId=props.categoryId;this.cName=props.cName;}
CategoryCollection.prototype={__proto__:BaseCollection.prototype};CategoryCollection.fromResponse=function cc_fromResponse(categoryIds,responseData){function getIcon(iconId){return responseData.icons[iconId];}
var collections=[];var categories=responseData.categories.filter(function _filter(cat){return categoryIds.indexOf(cat.categoryId)>-1;});for(var i=0,l=categories.length;i<l;i++){var cat=categories[i];var collection=new CategoryCollection({name:cat.query,categoryId:cat.categoryId,cName:cat.canonicalName,webicons:cat.appIds.map(getIcon)});collections.push(collection);}
return collections;};function QueryCollection(props){BaseCollection.call(this,props);this.query=props.query;if(!this.name){this.name=this.query;}}
QueryCollection.prototype={__proto__:BaseCollection.prototype};exports.BaseCollection=BaseCollection;exports.CategoryCollection=CategoryCollection;exports.PinnedHomeIcon=PinnedHomeIcon;exports.QueryCollection=QueryCollection;exports.WebResult=WebResult;})(window);;'use strict';(function(exports){const l10nKey='collection-categoryId-';var _=navigator.mozL10n.get;var map=Array.prototype.map;function Suggestions(){this.el=document.getElementById('collections-select');this.el.addEventListener('blur',this);window.addEventListener('visibilitychange',this);this.hide();this.load=function suggestions_load(categories){this.clear();var deviceLocale=this.toLocaleCode(navigator.mozL10n.language.code);return new Promise(function done(resolve,reject){this.resolve=resolve;this.reject=reject;var frag=document.createDocumentFragment();var localeCategories=[];categories.forEach(function each(category){var id=category.categoryId;var localeName=_(l10nKey+id);if(!localeName){var categoryLocale=this.toLocaleCode(category.locale);if(categoryLocale===deviceLocale){localeName=category.query;}else{eme.warn('suggestion ignored (wrong locale '+categoryLocale+')',id,category.query);}}
if(localeName){localeCategories.push({id:id,name:localeName});}},this);localeCategories.sort(function sort(a,b){return a.name>b.name;});localeCategories.forEach(function each(category){var el=document.createElement('option');el.value=el.textContent=category.name;el.dataset.categoryId=category.id;frag.appendChild(el);});this.el.appendChild(frag);if(localeCategories.length<1){alert(_('no-available-collections'));this.hide();this.reject('cancelled');}else{this.show();}}.bind(this));};}
Suggestions.prototype={handleEvent:function suggestions_handleEvent(e){switch(e.type){case'visibilitychange':if(document.hidden){window.close();}
break;case'blur':this.hide();var selected=map.call(this.el.querySelectorAll('option:checked'),function getId(opt){return Number(opt.dataset.categoryId);});if(selected.length){this.resolve(selected);}else{this.reject('cancelled');}
break;}},clear:function suggestions_clear(){this.el.innerHTML='';},show:function suggestions_show(){this.el.style.display='block';this.el.focus();},hide:function suggestions_hide(){this.el.blur();},toLocaleCode:function toLocaleCode(s){return s?s.substr(0,2):undefined;}};exports.Suggestions=new Suggestions();})(window);;'use strict';(function(exports){function Contextmenu(collection){this.collection=collection;this.menu=document.getElementById('cloud-menu');this.grid=document.getElementById('grid');this.bookmarkButton=this.menu.querySelector('#bookmark-cloudapp');this.pinButton=this.menu.querySelector('#pin-cloudapp');this.grid.addEventListener('contextmenu',this,true);this.icon=null;this.menu.addEventListener('gaiamenu-cancel',function(){this.icon=null;});this.bookmarkButton.addEventListener('click',function bookmark(){var icon=this.icon;new MozActivity({name:'save-bookmark',data:{type:'url',url:icon.detail.url,name:icon.name,icon:icon.icon}});this.icon=null;this.menu.hide();}.bind(this));this.pinButton.addEventListener('click',function pin(){if(this.icon){var icon=this.icon;collection.pinWebResult(icon.detail);icon.isRemovable=()=>{return true;};icon.isDraggable=()=>{return true;};icon.element.dataset.isDraggable=true;var removeEl=document.createElement('span');removeEl.className='remove';icon.element.appendChild(removeEl);this.grid.removeIconByIdentifier(this.identifier);this.grid.removeItemByIndex(icon.detail.index);this.grid.add(icon,collection.pinned.length-1);if(collection.pinned.length===1){this.grid.add(new GaiaGrid.Divider(),1);}
this.grid.render();collection.renderIcon().then(()=>{collection.save();});}
this.icon=null;this.menu.hide();}.bind(this));}
Contextmenu.prototype={isPinned:function(identifier){return this.collection.isPinned({identifier:identifier});},show:function(){this.menu.show();setTimeout(function nextTick(){this.grid.start();}.bind(this));},handleEvent:function(e){switch(e.type){case'contextmenu':var identifier=this.identifier=e.target.dataset.identifier;if(!identifier){return;}
if(!this.isPinned(identifier)){this.grid.stop();e.preventDefault();var icon=this.icon=this.grid.getIcon(identifier);return BookmarksDatabase.get(icon.detail.url).then((bookmark)=>{this.bookmarkButton.hidden=bookmark?true:false;},()=>{this.bookmarkButton.hidden=false;}).then(this.show.bind(this));}
break;}}};exports.Contextmenu=Contextmenu;}(window));;'use strict';(function(exports){var Activities={'update-collection':function(activity){CollectionEditor.init({data:activity.source.data,onsaved:function(){activity.postResult('updated');},oncancelled:function(){activity.postError('cancelled');}});}};navigator.mozSetMessageHandler('activity',function onActivity(activity){var name=activity.source.name;Activities[name](activity);});exports.Activities=Activities;}(window));;'use strict';(function(exports){var eme=exports.eme;function HandleCreate(activity){const APPS_IN_ICON=Common.APPS_IN_ICON;var request;var loading=document.getElementById('loading');var cancel=document.getElementById('cancel');var maxIconSize=activity.source.data.maxIconSize;CollectionIcon.init(maxIconSize);function getWebIcons(query){return eme.api.Apps.search({query:query,limit:APPS_IN_ICON}).then(response=>response.response.apps.slice(0,APPS_IN_ICON).map(app=>app.icon));}
function generateIcons(collections){var iconTasks=collections.map(collection=>{Common.getBackground(collection,maxIconSize).then(bgObject=>{collection.background=bgObject;return collection.renderIcon();},()=>{return collection.renderIcon();});});return Promise.all(iconTasks).then(()=>collections);}
function saveAll(collections){var trxs=collections.map(collection=>{return collection.save('add');});return Promise.all(trxs).then(()=>collections);}
function populateNativeInfo(collections){var nativeTasks=[];collections.forEach(collection=>{nativeTasks.push(NativeInfo.processCollection(collection));});return Promise.all(nativeTasks).then(()=>collections);}
function postResultIds(collections){collections=collections||[];var ids=collections.map(c=>c.id);activity.postResult(ids);}
function createCollections(selected,data){var dataReady;eme.log('resolved with',selected);document.querySelector('menu').style.display='none';loading.style.display='inline';if(Array.isArray(selected)){dataReady=Promise.resolve(CategoryCollection.fromResponse(selected,data));}else{dataReady=getWebIcons(selected).then(webicons=>{var collection=new QueryCollection({query:selected,webicons:webicons});return[collection];}).catch(e=>{eme.log('noIcons',e);return[new QueryCollection({query:selected})];});}
dataReady.then(generateIcons).then(saveAll).then(collections=>{return populateNativeInfo(collections).then(generateIcons).then(saveAll).catch(()=>{eme.error('NativeInfo task failed');return collections;});}).then(postResultIds).catch((ex)=>{eme.error('caught exception',ex);postResultIds();});}
var handlerPromise=CollectionsDatabase.getAllCategories().then(function doRequest(installed){request=eme.api.Categories.list().then(function success(response){loading.style.display='none';var data=response.response;var categories=data.categories.filter(function filter(category){return installed.indexOf(category.categoryId)===-1;});Suggestions.load(categories).then(selected=>{createCollections(selected,data);},reason=>{eme.log('rejected with',reason);activity.postResult(false);});},function error(reason){eme.log('create-collection: error',reason);if(reason==='network error'){alert(navigator.mozL10n.get('network-error-message'));}
activity.postResult(false);}).catch(function fail(ex){eme.log('create-collection: failed',ex);activity.postResult(false);});return request;},activity.postResult.bind(null,false));cancel.addEventListener('click',function(){request.abort&&request.abort();activity.postResult(false);});document.body.dataset.testReady=true;return handlerPromise;}
navigator.mozSetMessageHandler('activity',function onActivity(activity){if(activity.source.name==='create-collection'){eme.init().then(function ready(){HandleCreate(activity);});}});exports.HandleCreate=HandleCreate;}(window));;'use strict';(function(exports){var elements={header:document.getElementById('header'),close:document.getElementById('close'),name:document.getElementById('name')};function updateTitle(element,collection){element.textContent=collection.localizedName;}
function HandleView(activity){loading();var data=activity.source.data;var collection=BaseCollection.create(data);var l10nUpdateHander=updateTitle.bind(this,elements.name,collection);navigator.mozL10n.ready(l10nUpdateHander);window.addEventListener('localized',l10nUpdateHander);elements.header.addEventListener('action',function close(){activity.postResult('close');});loading(false);new Contextmenu(collection);new ViewApps(collection);new ViewBgImage(collection);new ViewEditMode(collection);}
navigator.mozSetMessageHandler('activity',function onActivity(activity){if(activity.source.name==='view-collection'){navigator.mozSetMessageHandler('activity',null);HandleView(activity);}});function loading(should){document.body.dataset.loading=should!==false;}
exports.HandleView=HandleView;}(window));;'use strict';(function(exports){const HIDDEN_ROLES=['system','input','homescreen','addon','langpack'];var appMgr=navigator.mozApps.mgmt;var initPromise;function HomeIcons(){this.ready=false;this.gridItemsByIdentifier={};this.recordsByManifestUrl={};this.recordsByBookmarkUrl={};}
HomeIcons.prototype={init:function init(force){if(!initPromise||force){initPromise=Promise.all([this.collectBookmarkURLs(),this.collectManifestURLs()]).then(()=>this.ready=true);}
return initPromise;},collectBookmarkURLs:function collectBookmarkURLs(){return new Promise((resolve)=>{BookmarksDatabase.getAll().then((systemBookmarks)=>{for(var id in systemBookmarks){this.processBookmark(systemBookmarks[id]);}
resolve();});});},collectManifestURLs:function collectManifestURLs(){return new Promise(function ready(resolve){appMgr.getAll().onsuccess=function onsuccess(event){for(var i=0,iLen=event.target.result.length;i<iLen;i++){this.processMozApp(event.target.result[i]);}
resolve();}.bind(this);}.bind(this));},processBookmark:function(eachBookmark){var features={isEditable:false,search:true};var bookmark=new GaiaGrid.Bookmark(eachBookmark,features);this.gridItemsByIdentifier[bookmark.identifier]=bookmark;this.recordsByBookmarkUrl[eachBookmark.bookmarkURL]=eachBookmark;},processMozApp:function(eachApp){var manifest=eachApp.manifest||eachApp.updateManifest;var features={isRemovable:true};if(HIDDEN_ROLES.indexOf(manifest.role)!==-1){return;}
function eachIcon(icon){if(!icon.icon){return;}
icon.isRemovable=()=>true;this.gridItemsByIdentifier[icon.identifier]=icon;}
this.recordsByManifestUrl[eachApp.manifestURL]=eachApp;if(manifest.entry_points){for(var i in manifest.entry_points){eachIcon.call(this,new GaiaGrid.Mozapp(eachApp,i,features));}}else{eachIcon.call(this,new GaiaGrid.Mozapp(eachApp,undefined,features));}},get:function get(identifier){return this.gridItemsByIdentifier[identifier];},getIdentifier:function getIdentifier(guid){var gridItem=this.gridItemsByIdentifier[guid];return gridItem?gridItem.identifier:null;},get bookmarkURLs(){return Object.keys(this.recordsByBookmarkUrl);},get manifestURLs(){return Object.keys(this.recordsByManifestUrl);}};exports.HomeIcons=new HomeIcons();}(window));;'use strict';(function(exports){const SETUP_KEY='NativeInfo-setup';function onerror(e){eme.error('NativeInfo error',e&&(e.name||e.message||e));}
function NativeInfo(){}
NativeInfo.prototype={getInfo:function getInfo(guids){if(!navigator.onLine){return Promise.reject();}
return eme.api.Apps.nativeInfo({guids:guids}).then(function success(response){var emeInfo=response.response||{};var guidsByCname={};function each(guid,cName){guidsByCname[cName]=guidsByCname[cName]||[];guidsByCname[cName].push(guid);}
for(var key in emeInfo){var info=emeInfo[key];var cNames=info.experiences||[];cNames.forEach(each.bind(null,info.guid));}
return guidsByCname;});},addToCollections:function addToCollections(guidsByCname){return CollectionsDatabase.getAll().then(function(collections){for(var id in collections){var collection=collections[id];collection=BaseCollection.create(collection);if(collection.cName){var guids=guidsByCname[collection.cName]||[];if(guids.length){var identifiers=guids;eme.log('NativeInfo',identifiers.length,'matches for',collection.cName,JSON.stringify(identifiers));collection.pinHomeIcons(identifiers);}}}});},removeFromCollections:function removeFromCollections(identifier){if(!identifier){return Promise.reject();}
return CollectionsDatabase.getAll().then(function(collections){for(var id in collections){var collection=BaseCollection.create(collections[id]);collection.unpin(identifier);}});},processApp:function processApp(action,id){if(action==='install'){return HomeIcons.init(true).then(()=>this.getInfo([id])).then(this.addToCollections).catch(onerror);}else if(action==='uninstall'){return HomeIcons.init(true).then(()=>this.removeFromCollections(id)).catch(onerror);}},processCollection:function processCollection(collection){return this.collectGuids().then(this.getInfo).then(function addToCollection(guidsByCname){var key=collection.cName||collection.query;var guids=guidsByCname[key]||[];if(guids.length){var identifiers=guids;eme.log('NativeInfo',identifiers);collection.pinHomeIcons(identifiers);}});},collectGuids:function collectGuids(){return HomeIcons.init().then(function success(){var manifestURLs=HomeIcons.manifestURLs;var bookmarkURLs=HomeIcons.bookmarkURLs;eme.log('NativeInfo found',manifestURLs.length,'apps');eme.log('NativeInfo found',bookmarkURLs.length,'bookmarks');return manifestURLs.concat(bookmarkURLs);});},doSetup:function doSetup(){eme.init().then(this.collectGuids).then(this.getInfo).then(this.addToCollections).then(function neverAgain(){eme.Cache.add(SETUP_KEY,true);}).catch(onerror);},setup:function setup(){return eme.Cache.get(SETUP_KEY).then(function skip(){eme.log('NativeInfo','skipping setup');},this.doSetup.bind(this));}};exports.NativeInfo=new NativeInfo();}(window));;'use strict';(function(){eme.init().then(function(){NativeInfo.setup();});var activity={source:{data:{categoryId:207,name:'Games'}},postResult:function(){},postError:function(){}};document.getElementById('clear').addEventListener('click',function(){document.getElementById('collections-select').innerHTML='';document.getElementById('icons').innerHTML='';document.getElementById('bgimage').src='.';});document.getElementById('create-collection').addEventListener('click',function(){activity.source.name='create-collection';HandleCreate(activity);});document.getElementById('view-collection').addEventListener('click',function(){activity.source.name='view-collection';HandleView(activity);});})();