define([ "require", "cards", "confirm_dialog", "form_navigation", "tmpl!./tng/plain_socket_warning.html", "./base", "template!./setup_manual_config.html", "./setup_account_error_mixin" ], function(e) {
    var t = e("cards"), n = e("confirm_dialog"), i = e("form_navigation"), o = e("tmpl!./tng/plain_socket_warning.html");
    return [ e("./base")(e("template!./setup_manual_config.html")), e("./setup_account_error_mixin"), {
        onArgs: function(e) {
            this.formItems = {
                common: {
                    displayName: this._fromClass("sup-info-name"),
                    emailAddress: this._fromClass("sup-info-email"),
                    password: this._fromClass("sup-info-password"),
                    passwordWrapper: this._fromClass("sup-manual-password-wrapper")
                },
                composite: {
                    hostname: this._fromClass("sup-manual-composite-hostname"),
                    port: this._fromClass("sup-manual-composite-port"),
                    socket: this._fromClass("sup-manual-composite-socket"),
                    username: this._fromClass("sup-manual-composite-username"),
                    password: this._fromClass("sup-manual-composite-password")
                },
                smtp: {
                    hostname: this._fromClass("sup-manual-smtp-hostname"),
                    port: this._fromClass("sup-manual-smtp-port"),
                    socket: this._fromClass("sup-manual-smtp-socket"),
                    username: this._fromClass("sup-manual-smtp-username"),
                    password: this._fromClass("sup-manual-smtp-password")
                },
                activeSync: {
                    hostname: this._fromClass("sup-manual-activesync-hostname"),
                    username: this._fromClass("sup-manual-activesync-username")
                }
            };
            var t = t || "", n = this.formItems.common;
            n.displayName.value = e.displayName, n.emailAddress.value = e.emailAddress, n.password.value = t;
            var o = this.formItems.composite;
            o.username.value = e.emailAddress, o.password.value = t;
            var s = this.formItems.smtp;
            s.username.value = e.emailAddress, s.password.value = t, this.changeIfSame(n.emailAddress, [ o.username, s.username ]), 
            this.changeIfSame(o.username, [ s.username ]), this.changeIfSame(o.password, [ s.password, n.password ]);
            for (var a in this.formItems) for (var r in this.formItems[a]) "INPUT" === this.formItems[a][r].tagName && this.formItems[a][r].addEventListener("input", this.onInfoInput.bind(this));
            this.requireFields("composite", !0), this.requireFields("smtp", !0), this.requireFields("activeSync", !1), 
            o.socket.addEventListener("change", this.onChangeCompositeSocket.bind(this)), s.socket.addEventListener("change", this.onChangeSmtpSocket.bind(this)), 
            this.onChangeAccountType({
                target: this.accountTypeNode
            }), this._formNavigation = new i({
                formElem: this.formNode,
                onLast: this.onNext.bind(this)
            });
        },
        _fromClass: function(e) {
            return this.getElementsByClassName(e)[0];
        },
        onBack: function() {
            t.removeCardAndSuccessors(this, "animate", 1);
        },
        onNext: function(e) {
            e.preventDefault();
            var t = {
                type: this.accountTypeNode.value
            };
            "imap+smtp" === t.type || "pop3+smtp" === t.type ? (t.incoming = {
                hostname: this.formItems.composite.hostname.value,
                port: this.formItems.composite.port.value,
                socketType: this.formItems.composite.socket.value,
                username: this.formItems.composite.username.value,
                password: this.formItems.composite.password.value,
                authentication: "password-cleartext"
            }, t.outgoing = {
                hostname: this.formItems.smtp.hostname.value,
                port: this.formItems.smtp.port.value,
                socketType: this.formItems.smtp.socket.value,
                username: this.formItems.smtp.username.value,
                password: this.formItems.smtp.password.value,
                authentication: "password-cleartext"
            }) : t.incoming = {
                server: "https://" + this.formItems.activeSync.hostname.value,
                username: this.formItems.activeSync.username.value
            }, this.pushSetupCard(t);
        },
        pushSetupCard: function(e) {
            var n;
            n = "activesync" === this.accountTypeNode.value ? this.formItems.common.password.value : this.formItems.composite.password.value, 
            t.pushCard("setup_progress", "animate", {
                displayName: this.formItems.common.displayName.value,
                emailAddress: this.formItems.common.emailAddress.value,
                password: n,
                outgoingPassword: e.outgoing && e.outgoing.password,
                configInfo: e,
                callingCard: this
            }, "right");
        },
        onInfoInput: function() {
            this.nextButton.disabled = !this.formNode.checkValidity();
        },
        changeIfSame: function(e, t) {
            e._previousValue = e.value, e.addEventListener("input", function(n) {
                for (var i = 0; i < t.length; i++) {
                    var o = t[i];
                    o.value === n.target._previousValue && (o.value = o._previousValue = n.target.value);
                }
                e._previousValue = n.target.value, this.onInfoInput();
            }.bind(this));
        },
        onChangeAccountType: function(e) {
            var t = "imap+smtp" === e.target.value || "pop3+smtp" === e.target.value, n = "imap+smtp" === e.target.value;
            t ? (this.compositeSection.classList.remove("collapsed"), this.activeSyncSection.classList.add("collapsed"), 
            this.manualImapTitle.classList.toggle("collapsed", !n), this.manualPop3Title.classList.toggle("collapsed", n)) : (this.compositeSection.classList.add("collapsed"), 
            this.activeSyncSection.classList.remove("collapsed")), this.formItems.common.passwordWrapper.classList.toggle("collapsed", t), 
            this.requireFields("composite", t), this.requireFields("smtp", t), this.requireFields("activeSync", !t), 
            this.onChangeCompositeSocket({
                target: this.formItems.composite.socket
            });
        },
        onChangeCompositeSocket: function(e) {
            var t = "imap+smtp" === this.accountTypeNode.value, n = t ? "993" : "995", i = t ? "143" : "110", o = e.target.value;
            "PLAIN" === o && this.showPlainSocketWarning();
            var s = this.formItems.composite.port;
            "SSL" === o ? s.value = n : ("STARTTLS" === o || "PLAIN" === o) && (s.value = i);
        },
        onChangeSmtpSocket: function(e) {
            const t = "465", n = "587", i = "25";
            var o = e.target.value, s = this.formItems.smtp.port;
            "PLAIN" == o && this.showPlainSocketWarning(), "SSL" !== o || s.value !== n && s.value !== i ? "STARTTLS" != o || s.value != t && s.value != i ? "PLAIN" != o || s.value != t && s.value != n || (s.value = i) : s.value = n : s.value = t;
        },
        requireFields: function(e, t) {
            for (var n in this.formItems[e]) {
                var i = this.formItems[e][n];
                i.hasAttribute("data-maybe-required") && (t ? i.setAttribute("required", "") : i.removeAttribute("required"));
            }
        },
        showPlainSocketWarning: function() {
            var e = o.cloneNode(!0), t = e.querySelector(".tng-plain-socket-learn-more");
            t.addEventListener("click", function(e) {
                e.preventDefault(), e.stopPropagation(), new MozActivity({
                    name: "view",
                    data: {
                        type: "url",
                        url: t.dataset.href
                    }
                });
            }), n.show(e, {
                id: "tng-plain-socket-warning-ok",
                handler: function() {}
            });
        },
        die: function() {
            this._formNavigation = null;
        }
    } ];
});