define([ "require", "api", "cards", "cards/oauth2/fetch", "./base", "template!./setup_progress.html" ], function(e) {
    var t = e("api"), n = e("cards"), i = e("cards/oauth2/fetch");
    return [ e("./base")(e("template!./setup_progress.html")), {
        onArgs: function(e) {
            this.args = e, this.callingCard = e.callingCard, this.creationInProcess = !0, this.pushedSecondaryCard = !1, 
            this.cardHasBeenShown = !1;
        },
        extraClasses: [ "anim-fade", "anim-overlay" ],
        cancelCreation: function() {
            !this.creationInProcess;
        },
        onCardVisible: function() {
            this.cardHasBeenShown ? this.pushedSecondaryCard && setTimeout(this.onBack.bind(this), 100) : (this.cardHasBeenShown = !0, 
            this.args.password ? this.tryCreate() : this.learnAbout());
        },
        onBack: function(e) {
            e && e.preventDefault(), this.cancelCreation(), n.removeCardAndSuccessors(this, "animate", 1);
        },
        learnAbout: function() {
            t.learnAboutAccount({
                emailAddress: this.args.emailAddress
            }, function(e) {
                var t = this.args;
                t.configInfo = e.configInfo;
                var o = e.result;
                "need-oauth2" === o ? i(e.configInfo.oauth2Settings, {
                    login_hint: t.emailAddress
                }).then(function(e) {
                    "cancel" === e.status ? this.onBack() : "success" === e.status ? (t.configInfo.oauth2Secrets = e.secrets, 
                    t.configInfo.oauth2Tokens = e.tokens, this.tryCreate()) : (console.error("Unknown oauthFetch status: " + e.status), 
                    this._divertToManualConfig());
                }.bind(this), this.onCreationError.bind(this)) : "need-password" === o ? (this.pushedSecondaryCard = !0, 
                n.pushCard("setup_account_password", "animate", {
                    displayName: t.displayName,
                    emailAddress: t.emailAddress
                }, "right")) : this._divertToManualConfig();
            }.bind(this));
        },
        _divertToManualConfig: function() {
            this.pushedSecondaryCard = !0, n.pushCard("setup_manual_config", "animate", {
                displayName: this.args.displayName,
                emailAddress: this.args.emailAddress
            }, "right");
        },
        tryCreate: function() {
            var e = this.args, n = {
                displayName: e.displayName,
                emailAddress: e.emailAddress,
                password: e.password,
                outgoingPassword: e.outgoingPassword
            };
            t.tryToCreateAccount(n, e.configInfo || null, function(e, t, n) {
                this.creationInProcess = !1, e ? this.onCreationError(e, t) : this.onCreationSuccess(n);
            }.bind(this));
        },
        onCreationError: function(e, t) {
            this.callingCard.showError(e, t), n.removeCardAndSuccessors(this, "animate", 1);
        },
        onCreationSuccess: function(e) {
            n.pushCard("setup_account_prefs", "animate", {
                account: e
            });
        },
        die: function() {
            this.cancelCreation();
        }
    } ];
});