define("activesync/folder", [ "rdcommon/log", "../date", "../syncbase", "../allback", "../db/mail_rep", "activesync/codepages/AirSync", "activesync/codepages/AirSyncBase", "activesync/codepages/ItemEstimate", "activesync/codepages/Email", "activesync/codepages/ItemOperations", "safe-base64", "mimetypes", "module", "require", "exports" ], function(e, t, n, o, s, i, r, a, c, d, l, u, h, p, f) {
    function m() {
        v = i.Enums.FilterType, b = {
            auto: null,
            "1d": v.OneDayBack,
            "3d": v.ThreeDaysBack,
            "1w": v.OneWeekBack,
            "2w": v.TwoWeeksBack,
            "1m": v.OneMonthBack,
            all: v.NoFilter
        }, S = {
            0: "all messages",
            1: "one day",
            2: "three days",
            3: "one week",
            4: "two weeks",
            5: "one month"
        };
    }
    function g(e, t, n) {
        return function() {
            var o = Array.slice(arguments), s = o[e], i = this;
            p([ "wbxml", "addressparser", "../mailchew" ], function(e, r, a) {
                T || (T = e, w = r.parse.bind(r), E = a, m()), i._account.withConnection(s, function() {
                    t.apply(i, o);
                }, n);
            });
        };
    }
    function _(e, t, n) {
        this._account = e, this._storage = t, this._LOG = A.ActiveSyncFolderConn(this, n, t.folderId), 
        this.folderMeta = t.folderMeta, this.syncKey || (this.syncKey = "0");
    }
    function y(e, t, n) {
        this._account = e, this.folderStorage = t, this._LOG = A.ActiveSyncFolderSyncer(this, n, t.folderId), 
        this.folderConn = new _(e, t, this._LOG);
    }
    var v, b, S, T, w, E, I = 512, C = 50;
    _.prototype = {
        get syncKey() {
            return this.folderMeta.syncKey;
        },
        set syncKey(e) {
            return this.folderMeta.syncKey = e;
        },
        get serverId() {
            return this.folderMeta.serverId;
        },
        get filterType() {
            var e = this._account.accountDef.syncRange;
            if (b.hasOwnProperty(e)) {
                var t = b[e];
                return t ? t : this.folderMeta.filterType;
            }
            return console.warn("Got an invalid syncRange (" + e + ") using three days back instead"), 
            i.Enums.FilterType.ThreeDaysBack;
        },
        _getSyncKey: g(1, function(e, t) {
            var n = this, o = this._account, s = i.Tags, r = new T.Writer("1.3", 1, "UTF-8");
            r.stag(s.Sync).stag(s.Collections).stag(s.Collection), o.conn.currentVersion.lt("12.1") && r.tag(s.Class, "Email"), 
            r.tag(s.SyncKey, "0").tag(s.CollectionId, this.serverId).stag(s.Options).tag(s.FilterType, e).etag().etag().etag().etag(), 
            o.conn.postCommand(r, function(e, i) {
                if (e) return console.error(e), o._reportErrorIfNecessary(e), t("unknown"), void 0;
                n.syncKey = "0";
                var r = new T.EventParser();
                r.addEventListener([ s.Sync, s.Collections, s.Collection, s.SyncKey ], function(e) {
                    n.syncKey = e.children[0].textContent;
                }), r.onerror = function() {}, r.run(i), "0" === n.syncKey ? (console.error("Unable to get sync key for folder"), 
                t("unknown")) : t();
            });
        }),
        _getItemEstimate: g(1, function(e, t) {
            var n = a.Tags, o = i.Tags, s = this._account, r = new T.Writer("1.3", 1, "UTF-8");
            r.stag(n.GetItemEstimate).stag(n.Collections).stag(n.Collection), this._account.conn.currentVersion.gte("14.0") ? r.tag(o.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).stag(o.Options).tag(o.FilterType, e).etag() : this._account.conn.currentVersion.gte("12.0") ? r.tag(n.CollectionId, this.serverId).tag(o.FilterType, e).tag(o.SyncKey, this.syncKey) : r.tag(n.Class, "Email").tag(o.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).tag(o.FilterType, e), 
            r.etag(n.Collection).etag(n.Collections).etag(n.GetItemEstimate), s.conn.postCommand(r, function(e, o) {
                if (e) return console.error(e), s._reportErrorIfNecessary(e), t("unknown"), void 0;
                var i, r, c = new T.EventParser(), d = [ n.GetItemEstimate, n.Response ];
                c.addEventListener(d.concat(n.Status), function(e) {
                    i = e.children[0].textContent;
                }), c.addEventListener(d.concat(n.Collection, n.Estimate), function(e) {
                    r = parseInt(e.children[0].textContent, 10);
                });
                try {
                    c.run(o);
                } catch (l) {
                    return console.error("Error parsing GetItemEstimate response", l, "\n", l.stack), 
                    t("unknown"), void 0;
                }
                i !== a.Enums.Status.Success ? (console.error("Error getting item estimate:", i), 
                t("unknown")) : t(null, r);
            });
        }),
        _inferFilterType: g(0, function(e) {
            var t = this, n = i.Enums.FilterType, o = function(o, s) {
                t._getSyncKey(o, function(i) {
                    return i ? (e("unknown"), void 0) : (t._getItemEstimate(o, function(t, o) {
                        return t ? (e(null, n.ThreeDaysBack), void 0) : (s(o), void 0);
                    }), void 0);
                });
            };
            o(n.TwoWeeksBack, function(s) {
                var i, r = s / 14;
                if (0 > s) i = n.ThreeDaysBack; else if (r >= C) i = n.OneDayBack; else if (3 * r >= C) i = n.ThreeDaysBack; else if (7 * r >= C) i = n.OneWeekBack; else if (14 * r >= C) i = n.TwoWeeksBack; else {
                    if (!(30 * r >= C)) return o(n.NoFilter, function(o) {
                        var s;
                        o > C ? (s = n.OneMonthBack, t.syncKey = "0") : s = n.NoFilter, t._LOG.inferFilterType(s), 
                        e(null, s);
                    }), void 0;
                    i = n.OneMonthBack;
                }
                i !== n.TwoWeeksBack && (t.syncKey = "0"), t._LOG.inferFilterType(i), e(null, i);
            });
        }),
        _enumerateFolderChanges: g(0, function(e, t) {
            var n = this, o = this._storage;
            if (!this.filterType) return this._inferFilterType(function(o, s) {
                return o ? (e("unknown"), void 0) : (console.log("We want a filter of", S[s]), n.folderMeta.filterType = s, 
                n._enumerateFolderChanges(e, t), void 0);
            }), void 0;
            if ("0" === this.syncKey) return this._getSyncKey(this.filterType, function(o) {
                return o ? (e("aborted"), void 0) : (n._enumerateFolderChanges(e, t), void 0);
            }), void 0;
            var s = i.Tags, a = i.Enums;
            r.Tags, r.Enums;
            var c;
            0 === this._account._syncsInProgress++ && this._account._lastSyncKey === this.syncKey && this._account._lastSyncFilterType === this.filterType && this._account._lastSyncResponseWasEmpty ? c = s.Sync : (c = new T.Writer("1.3", 1, "UTF-8"), 
            c.stag(s.Sync).stag(s.Collections).stag(s.Collection), this._account.conn.currentVersion.lt("12.1") && c.tag(s.Class, "Email"), 
            c.tag(s.SyncKey, this.syncKey).tag(s.CollectionId, this.serverId).tag(s.GetChanges).stag(s.Options).tag(s.FilterType, this.filterType), 
            this._account.conn.currentVersion.lte("12.0") && c.tag(s.MIMESupport, a.MIMESupport.Never).tag(s.Truncation, a.MIMETruncation.TruncateAll), 
            c.etag().etag().etag().etag()), this._account.conn.postCommand(c, function(i, r) {
                var c, d = [], l = [], u = [], h = !1;
                if (n._account._syncsInProgress--, i) return console.error("Error syncing folder:", i), 
                n._account._reportErrorIfNecessary(i), e("aborted"), void 0;
                if (n._account._lastSyncKey = n.syncKey, n._account._lastSyncFilterType = n.filterType, 
                !r) return console.log("Sync completed with empty response"), n._account._lastSyncResponseWasEmpty = !0, 
                e(null, d, l, u), void 0;
                n._account._lastSyncResponseWasEmpty = !1;
                var p = new T.EventParser(), f = [ s.Sync, s.Collections, s.Collection ];
                p.addEventListener(f.concat(s.SyncKey), function(e) {
                    n.syncKey = e.children[0].textContent;
                }), p.addEventListener(f.concat(s.Status), function(e) {
                    c = e.children[0].textContent;
                }), p.addEventListener(f.concat(s.MoreAvailable), function() {
                    h = !0;
                }), p.addEventListener(f.concat(s.Commands, [ [ s.Add, s.Change ] ]), function(e) {
                    var t, i;
                    for (var r in Iterator(e.children)) {
                        var a = r[1];
                        switch (a.tag) {
                          case s.ServerId:
                            t = a.children[0].textContent;
                            break;

                          case s.ApplicationData:
                            try {
                                i = n._parseMessage(a, e.tag === s.Add, o);
                            } catch (c) {
                                return console.error("Failed to parse a message:", c, "\n", c.stack), void 0;
                            }
                        }
                    }
                    i.header.srvid = t;
                    var u = e.tag === s.Add ? d : l;
                    u.push(i);
                }), p.addEventListener(f.concat(s.Commands, [ [ s.Delete, s.SoftDelete ] ]), function(e) {
                    var t;
                    for (var n in Iterator(e.children)) {
                        var o = n[1];
                        switch (o.tag) {
                          case s.ServerId:
                            t = o.children[0].textContent;
                        }
                    }
                    u.push(t);
                });
                try {
                    p.run(r);
                } catch (m) {
                    return console.error("Error parsing Sync response:", m, "\n", m.stack), e("unknown"), 
                    void 0;
                }
                c === a.Status.Success ? (console.log("Sync completed: added " + d.length + ", changed " + l.length + ", deleted " + u.length), 
                e(null, d, l, u, h), h && n._enumerateFolderChanges(e, t)) : c === a.Status.InvalidSyncKey ? (console.warn("ActiveSync had a bad sync key"), 
                e("badkey")) : (console.error("Something went wrong during ActiveSync syncing and we got a status of " + c), 
                e("unknown"));
            }, null, null, function(e, n) {
                n || (n = Math.max(1e6, e)), t(.1 + .7 * e / n);
            });
        }, "aborted"),
        _parseMessage: function(e, t, n) {
            var o, i, a, d = c.Tags, l = r.Tags, h = r.Enums;
            if (t) {
                var p = n._issueNewHeaderId();
                o = {
                    id: p,
                    srvid: null,
                    suid: n.folderId + "/" + p,
                    guid: "",
                    author: null,
                    to: null,
                    cc: null,
                    bcc: null,
                    replyTo: null,
                    date: null,
                    flags: [],
                    hasAttachments: !1,
                    subject: null,
                    snippet: null
                }, i = {
                    date: null,
                    size: 0,
                    attachments: [],
                    relatedParts: [],
                    references: null,
                    bodyReps: null
                }, a = function(e, t) {
                    t && o.flags.push(e);
                };
            } else o = {
                flags: [],
                mergeInto: function(e) {
                    for (var t in Iterator(this.flags)) {
                        var n = t[1];
                        if (n[1]) e.flags.push(n[0]); else {
                            var o = e.flags.indexOf(n[0]);
                            -1 !== o && e.flags.splice(o, 1);
                        }
                    }
                    var s = [ "mergeInto", "suid", "srvid", "guid", "id", "flags" ];
                    for (var t in Iterator(this)) {
                        var i = t[0], r = t[1];
                        -1 === s.indexOf(i) && (e[i] = r);
                    }
                }
            }, i = {
                mergeInto: function(e) {
                    for (var t in Iterator(this)) {
                        var n = t[0], o = t[1];
                        "mergeInto" !== n && (e[n] = o);
                    }
                }
            }, a = function(e, t) {
                o.flags.push([ e, t ]);
            };
            var f, m;
            for (var g in Iterator(e.children)) {
                var _ = g[1], y = _.children.length ? _.children[0].textContent : null;
                switch (_.tag) {
                  case d.Subject:
                    o.subject = y;
                    break;

                  case d.From:
                    o.author = w(y)[0] || null;
                    break;

                  case d.To:
                    o.to = w(y);
                    break;

                  case d.Cc:
                    o.cc = w(y);
                    break;

                  case d.ReplyTo:
                    o.replyTo = w(y);
                    break;

                  case d.DateReceived:
                    i.date = o.date = new Date(y).valueOf();
                    break;

                  case d.Read:
                    a("\\Seen", "1" === y);
                    break;

                  case d.Flag:
                    for (var v in Iterator(_.children)) {
                        var b = v[1];
                        b.tag === d.Status && a("\\Flagged", "0" !== b.children[0].textContent);
                    }
                    break;

                  case l.Body:
                    for (var v in Iterator(_.children)) {
                        var b = v[1];
                        switch (b.tag) {
                          case l.Type:
                            var S = b.children[0].textContent;
                            S === h.Type.HTML ? f = "html" : (S !== h.Type.PlainText && console.warn("A message had a strange body type:", S), 
                            f = "plain");
                            break;

                          case l.EstimatedDataSize:
                            m = b.children[0].textContent;
                        }
                    }
                    break;

                  case d.BodySize:
                    f = "plain", m = y;
                    break;

                  case l.Attachments:
                  case d.Attachments:
                    for (var v in Iterator(_.children)) {
                        var T = v[1];
                        if (T.tag === l.Attachment || T.tag === d.Attachment) {
                            var E = {
                                name: null,
                                contentId: null,
                                type: null,
                                part: null,
                                encoding: null,
                                sizeEstimate: null,
                                file: null
                            }, I = !1;
                            for (var C in Iterator(T.children)) {
                                var A, O, k = C[1], M = k.children.length ? k.children[0].textContent : null;
                                switch (k.tag) {
                                  case l.DisplayName:
                                  case d.DisplayName:
                                    E.name = M, A = E.name.lastIndexOf("."), O = A > 0 ? E.name.substring(A + 1).toLowerCase() : "", 
                                    E.type = u.detectMimeType(O);
                                    break;

                                  case l.FileReference:
                                  case d.AttName:
                                    E.part = M;
                                    break;

                                  case l.EstimatedDataSize:
                                  case d.AttSize:
                                    E.sizeEstimate = parseInt(M, 10);
                                    break;

                                  case l.ContentId:
                                    E.contentId = M;
                                    break;

                                  case l.IsInline:
                                    I = "1" === M;
                                    break;

                                  case l.FileReference:
                                  case d.Att0Id:
                                    E.part = k.children[0].textContent;
                                }
                            }
                            I ? i.relatedParts.push(s.makeAttachmentPart(E)) : i.attachments.push(s.makeAttachmentPart(E));
                        }
                    }
                    o.hasAttachments = i.attachments.length > 0;
                }
            }
            return t ? (i.bodyReps = [ s.makeBodyPart({
                type: f,
                sizeEstimate: m,
                amountDownloaded: 0,
                isDownloaded: !1
            }) ], {
                header: s.makeHeaderInfo(o),
                body: s.makeBodyInfo(i)
            }) : {
                header: o,
                body: i
            };
        },
        downloadBodies: function(e, t, n) {
            if (this._account.conn.currentVersion.lt("12.0")) return this._syncBodies(e, n);
            for (var s = 0, i = o.latch(), r = 0; r < e.length; r++) {
                var a = e[r];
                a && null === a.snippet && (s++, this.downloadBodyReps(a, t, i.defer(a.suid)));
            }
            i.then(function(e) {
                n(o.extractErrFromCallbackArgs(e), s);
            });
        },
        downloadBodyReps: g(1, function(e, t, n) {
            var o = this, s = this._account;
            if (s.conn.currentVersion.lt("12.0")) return this._syncBodies([ e ], n);
            "function" == typeof t && (n = t, t = null), t = t || {};
            var a = d.Tags, c = d.Enums, l = i.Tags;
            i.Enums;
            var u = r.Tags, h = r.Enums.Type, p = function(i) {
                if (!i) return n("unknown");
                var r, d = i.bodyReps[0], p = "html" === d.type ? h.HTML : h.PlainText;
                t.maximumBytesToFetch < d.sizeEstimate && (p = h.PlainText, r = I);
                var f = new T.Writer("1.3", 1, "UTF-8");
                f.stag(a.ItemOperations).stag(a.Fetch).tag(a.Store, "Mailbox").tag(l.CollectionId, o.serverId).tag(l.ServerId, e.srvid).stag(a.Options).stag(a.Schema).tag(u.Body).etag().stag(u.BodyPreference).tag(u.Type, p), 
                r && f.tag(u.TruncationSize, r), f.etag().etag().etag().etag(), s.conn.postCommand(f, function(t, d) {
                    if (t) return console.error(t), s._reportErrorIfNecessary(t), n("unknown"), void 0;
                    var l, h, p = new T.EventParser();
                    p.addEventListener([ a.ItemOperations, a.Status ], function(e) {
                        l = e.children[0].textContent;
                    }), p.addEventListener([ a.ItemOperations, a.Response, a.Fetch, a.Properties, u.Body, u.Data ], function(e) {
                        h = e.children[0].textContent;
                    });
                    try {
                        p.run(d);
                    } catch (f) {
                        return n("unknown");
                    }
                    return l !== c.Status.Success ? n("unknown") : (o._updateBody(e, i, h, !!r, n), 
                    void 0);
                });
            };
            this._storage.getMessageBody(e.suid, e.date, p);
        }),
        _syncBodies: function(e, t) {
            var n = i.Tags, s = i.Enums, r = c.Tags, a = this, d = this._account, l = new T.Writer("1.3", 1, "UTF-8");
            l.stag(n.Sync).stag(n.Collections).stag(n.Collection).tag(n.Class, "Email").tag(n.SyncKey, this.syncKey).tag(n.CollectionId, this.serverId).stag(n.Options).tag(n.MIMESupport, s.MIMESupport.Never).etag().stag(n.Commands);
            for (var u = 0; u < e.length; u++) l.stag(n.Fetch).tag(n.ServerId, e[u].srvid).etag();
            l.etag().etag().etag().etag(), d.conn.postCommand(l, function(i, c) {
                if (i) return console.error(i), d._reportErrorIfNecessary(i), t("unknown"), void 0;
                var l = o.latch(), u = 0, h = new T.EventParser(), p = [ n.Sync, n.Collections, n.Collection ];
                h.addEventListener(p.concat(n.SyncKey), function(e) {
                    a.syncKey = e.children[0].textContent;
                }), h.addEventListener(p.concat(n.Status), function(e) {
                    var t = e.children[0].textContent;
                    t !== s.Status.Success && l.defer("status")("unknown");
                }), h.addEventListener(p.concat(n.Responses, n.Fetch, n.ApplicationData, r.Body), function(t) {
                    var n = e[u++], o = t.children[0].textContent, s = l.defer(n.suid);
                    a._storage.getMessageBody(n.suid, n.date, function(e) {
                        a._updateBody(n, e, o, !1, s);
                    });
                }), h.run(c), l.then(function(e) {
                    t(o.extractErrFromCallbackArgs(e));
                });
            });
        },
        _activeSyncHeaderIsSeen: function(e) {
            for (var t = 0; t < e.flags.length; t++) if ("\\Seen" === e.flags[t][0] && e.flags[t][1]) return !0;
            return !1;
        },
        _updateBody: function(e, t, n, s, i) {
            var r = t.bodyReps[0];
            n = n.replace(/\r/g, "");
            var a = s ? "plain" : r.type, c = E.processMessageContent(n, a, !s, !0, this._LOG);
            e.snippet = c.snippet, r.isDownloaded = !s, r.amountDownloaded = n.length, s || (r.content = c.content);
            var d = {
                changeDetails: {
                    bodyReps: [ 0 ]
                }
            }, l = o.latch();
            this._storage.updateMessageHeader(e.date, e.id, !1, e, t, l.defer("header")), this._storage.updateMessageBody(e, t, {}, d, l.defer("body")), 
            l.then(i.bind(null, null, t, !1));
        },
        sync: g(1, function(e, t, s) {
            var i = this, r = 0, a = 0, c = 0;
            this._LOG.sync_begin(null, null, null);
            var d = this;
            this._enumerateFolderChanges(function(s, l, u, h, p) {
                var f = i._storage;
                if ("badkey" === s) return i._account._recreateFolder(f.folderId, function() {
                    i._storage = null, i._LOG.sync_end(null, null, null);
                }), void 0;
                if (s) return i._LOG.sync_end(null, null, null), t(s), void 0;
                var m = o.latch();
                for (var g in Iterator(l)) {
                    var _ = g[1];
                    f.hasMessageWithServerId(_.header.srvid) || (f.addMessageHeader(_.header, _.body, m.defer()), 
                    f.addMessageBody(_.header, _.body, m.defer()), r++);
                }
                for (var g in Iterator(u)) {
                    var _ = g[1];
                    f.hasMessageWithServerId(_.header.srvid) && (f.updateMessageHeaderByServerId(_.header.srvid, !0, function(e, t) {
                        return !d._activeSyncHeaderIsSeen(t) && d._activeSyncHeaderIsSeen(e.header) ? f.folderMeta.unreadCount-- : d._activeSyncHeaderIsSeen(t) && !d._activeSyncHeaderIsSeen(e.header) && f.folderMeta.unreadCount++, 
                        e.header.mergeInto(t), !0;
                    }.bind(null, _), null, m.defer()), a++);
                }
                for (var g in Iterator(h)) {
                    var y = g[1];
                    f.hasMessageWithServerId(y) && (f.deleteMessageByServerId(y, m.defer()), c++);
                }
                if (!p) {
                    var v = r + a + c;
                    m.then(function() {
                        i._LOG.sync_end(r, a, c), f.markSyncRange(n.OLDEST_SYNC_DATE, e, "XXX", e), t(null, null, v);
                    });
                }
            }, s);
        }),
        performMutation: g(1, function(e, t) {
            var n = this, o = i.Tags, s = this._account, r = new T.Writer("1.3", 1, "UTF-8");
            r.stag(o.Sync).stag(o.Collections).stag(o.Collection), s.conn.currentVersion.lt("12.1") && r.tag(o.Class, "Email"), 
            r.tag(o.SyncKey, this.syncKey).tag(o.CollectionId, this.serverId).tag(o.DeletesAsMoves, "trash" === this.folderMeta.type ? "0" : "1").tag(o.GetChanges, "0").stag(o.Commands);
            try {
                e(r);
            } catch (a) {
                return console.error("Exception in performMutation callee:", a, "\n", a.stack), 
                t("unknown"), void 0;
            }
            r.etag(o.Commands).etag(o.Collection).etag(o.Collections).etag(o.Sync), s.conn.postCommand(r, function(e, r) {
                if (e) return console.error("postCommand error:", e), s._reportErrorIfNecessary(e), 
                t("unknown"), void 0;
                var a, c, d = new T.EventParser(), l = [ o.Sync, o.Collections, o.Collection ];
                d.addEventListener(l.concat(o.SyncKey), function(e) {
                    a = e.children[0].textContent;
                }), d.addEventListener(l.concat(o.Status), function(e) {
                    c = e.children[0].textContent;
                });
                try {
                    d.run(r);
                } catch (u) {
                    return console.error("Error parsing Sync response:", u, "\n", u.stack), t("unknown"), 
                    void 0;
                }
                c === i.Enums.Status.Success ? (n.syncKey = a, t && t(null)) : (console.error("Something went wrong during ActiveSync syncing and we got a status of " + c), 
                t("status:" + c));
            });
        }),
        downloadMessageAttachments: g(2, function(e, t, n) {
            var o = this, s = d.Tags, i = d.Enums.Status, a = r.Tags, c = new T.Writer("1.3", 1, "UTF-8");
            c.stag(s.ItemOperations);
            for (var u in Iterator(t)) {
                var h = u[1];
                c.stag(s.Fetch).tag(s.Store, "Mailbox").tag(a.FileReference, h.part).etag();
            }
            c.etag(), this._account.conn.postCommand(c, function(e, r) {
                if (e) return console.error("postCommand error:", e), o._account._reportErrorIfNecessary(e), 
                n("unknown"), void 0;
                var c, d = {}, u = new T.EventParser();
                u.addEventListener([ s.ItemOperations, s.Status ], function(e) {
                    c = e.children[0].textContent;
                }), u.addEventListener([ s.ItemOperations, s.Response, s.Fetch ], function(e) {
                    var t = null, n = {};
                    for (var o in Iterator(e.children)) {
                        var i = o[1];
                        switch (i.tag) {
                          case s.Status:
                            n.status = i.children[0].textContent;
                            break;

                          case a.FileReference:
                            t = i.children[0].textContent;
                            break;

                          case s.Properties:
                            var r = null, c = null;
                            for (var u in Iterator(i.children)) {
                                var h = u[1], p = h.children[0].textContent;
                                switch (h.tag) {
                                  case a.ContentType:
                                    r = p;
                                    break;

                                  case s.Data:
                                    c = l.decode(p);
                                }
                            }
                            r && c && (n.data = new Blob([ c ], {
                                type: r
                            }));
                        }
                        t && (d[t] = n);
                    }
                }), u.run(r);
                var h = c !== i.Success ? "unknown" : null, p = [];
                for (var f in Iterator(t)) {
                    var m = f[1];
                    d.hasOwnProperty(m.part) && d[m.part].status === i.Success ? p.push(d[m.part].data) : (h = "unknown", 
                    p.push(null));
                }
                n(h, p);
            });
        })
    }, f.ActiveSyncFolderSyncer = y, y.prototype = {
        get syncable() {
            return null !== this.folderConn.serverId;
        },
        get canGrowSync() {
            return !1;
        },
        initialSync: function(e, n, o, s, i) {
            o("sync", !0), this.folderConn.sync(t.NOW(), this.onSyncCompleted.bind(this, s, !0), i);
        },
        refreshSync: function(e, n, o, s, i, r, a) {
            this.folderConn.sync(t.NOW(), this.onSyncCompleted.bind(this, r, !1), a);
        },
        growSync: function() {
            return !1;
        },
        onSyncCompleted: function(e, t, o, s, i) {
            var r = this.folderStorage;
            console.log("Sync Completed!", i, "messages synced"), o || r.markSyncedToDawnOfTime(), 
            this._account.__checkpointSyncCompleted(function() {
                o ? e(o) : t ? (r._curSyncSlice.ignoreHeaders = !1, r._curSyncSlice.waitingOnData = "db", 
                r.getMessagesInImapDateRange(0, null, n.INITIAL_FILL_SIZE, n.INITIAL_FILL_SIZE, r.onFetchDBHeaders.bind(r, r._curSyncSlice, !1, e, null))) : e(o);
            });
        },
        allConsumersDead: function() {},
        shutdown: function() {
            this.folderConn.shutdown(), this._LOG.__die();
        }
    };
    var A = f.LOGFAB = e.register(h, {
        ActiveSyncFolderConn: {
            type: e.CONNECTION,
            subtype: e.CLIENT,
            events: {
                inferFilterType: {
                    filterType: !1
                }
            },
            asyncJobs: {
                sync: {
                    newMessages: !0,
                    changedMessages: !0,
                    deletedMessages: !0
                }
            },
            errors: {
                htmlParseError: {
                    ex: e.EXCEPTION
                },
                htmlSnippetError: {
                    ex: e.EXCEPTION
                },
                textChewError: {
                    ex: e.EXCEPTION
                },
                textSnippetError: {
                    ex: e.EXCEPTION
                }
            }
        },
        ActiveSyncFolderSyncer: {
            type: e.DATABASE,
            events: {}
        }
    });
}), define("activesync/jobs", [ "rdcommon/log", "mix", "../jobmixins", "../drafts/jobs", "activesync/codepages/AirSync", "activesync/codepages/Email", "activesync/codepages/Move", "module", "require", "exports" ], function(e, t, n, o, s, i, r, a, c, d) {
    function l(e, t, n) {
        return function() {
            var o = Array.slice(arguments), s = o[e], i = this;
            c([ "wbxml" ], function(e) {
                h || (h = e), i.account.withConnection(s, function() {
                    t.apply(i, o);
                }, n);
            });
        };
    }
    function u(e, t, n) {
        this.account = e, this.resilientServerIds = !0, this._heldMutexReleasers = [], this._LOG = p.ActiveSyncJobDriver(this, n, this.account.id), 
        this._state = t, t.hasOwnProperty("suidToServerId") || (t.suidToServerId = {}, t.moveMap = {}), 
        this._stateDelta = {
            serverIdMap: null,
            moveMap: null
        };
    }
    var h;
    d.ActiveSyncJobDriver = u, u.prototype = {
        postJobCleanup: n.postJobCleanup,
        allJobsDone: n.allJobsDone,
        _accessFolderForMutation: function(e, t, n, o, s) {
            var i = this.account.getFolderStorageForFolderId(e), r = this;
            i.runMutexed(s, function(e) {
                r._heldMutexReleasers.push(e);
                var o = i.folderSyncer;
                if (t) r.account.withConnection(n, function() {
                    try {
                        n(o.folderConn, i);
                    } catch (e) {
                        r._LOG.callbackErr(e);
                    }
                }); else try {
                    n(o.folderConn, i);
                } catch (s) {
                    r._LOG.callbackErr(s);
                }
            });
        },
        _partitionAndAccessFoldersSequentially: n._partitionAndAccessFoldersSequentially,
        local_do_modtags: n.local_do_modtags,
        do_modtags: l(1, function(e, t, n) {
            function o(e) {
                return r && -1 !== r.indexOf(e) ? !0 : a && -1 !== a.indexOf(e) ? !1 : void 0;
            }
            var r = n ? e.removeTags : e.addTags, a = n ? e.addTags : e.removeTags, c = o("\\Seen"), d = o("\\Flagged"), l = s.Tags, u = i.Tags, h = null;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, n, o, s) {
                return n = n.filter(function(e) {
                    return !!e;
                }), n.length ? (e.performMutation(function(e) {
                    for (var t = 0; t < n.length; t++) e.stag(l.Change).tag(l.ServerId, n[t]).stag(l.ApplicationData), 
                    void 0 !== c && e.tag(u.Read, c ? "1" : "0"), void 0 !== d && e.stag(u.Flag).tag(u.Status, d ? "2" : "0").etag(), 
                    e.etag(l.ApplicationData).etag(l.Change);
                }, function(e) {
                    e && (h = e), s();
                }), void 0) : (s(), void 0);
            }, function() {
                t(h);
            }, function() {
                h = "aborted-retry";
            }, n, "modtags");
        }),
        check_modtags: function(e, t) {
            t(null, "idempotent");
        },
        local_undo_modtags: n.local_undo_modtags,
        undo_modtags: function(e, t) {
            this.do_modtags(e, t, !0);
        },
        local_do_move: n.local_do_move,
        do_move: l(1, function(e, t) {
            var n = null, o = this.account, s = this.account.getFolderStorageForFolderId(e.targetFolder), i = r.Tags;
            this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, r, a, c) {
                if (r = r.filter(function(e) {
                    return !!e;
                }), !r.length) return c(), void 0;
                if (r = r.filter(function(e) {
                    return !!e;
                }), !r.length) return c(), void 0;
                var d = new h.Writer("1.3", 1, "UTF-8");
                d.stag(i.MoveItems);
                for (var l = 0; l < r.length; l++) d.stag(i.Move).tag(i.SrcMsgId, r[l]).tag(i.SrcFldId, t.folderMeta.serverId).tag(i.DstFldId, s.folderMeta.serverId).etag(i.Move);
                d.etag(i.MoveItems), o.conn.postCommand(d, function(e) {
                    e && (n = e, console.error("failure moving messages:", e)), c();
                });
            }, function() {
                t(n, null, !0);
            }, function() {
                n = "aborted-retry";
            }, !1, "move");
        }),
        check_move: function() {},
        local_undo_move: n.local_undo_move,
        undo_move: function() {},
        local_do_delete: n.local_do_delete,
        do_delete: l(1, function(e, t) {
            var n = null, o = s.Tags;
            i.Tags, this._partitionAndAccessFoldersSequentially(e.messages, !0, function(e, t, s, i, r) {
                return s = s.filter(function(e) {
                    return !!e;
                }), s.length ? (e.performMutation(function(e) {
                    for (var t = 0; t < s.length; t++) e.stag(o.Delete).tag(o.ServerId, s[t]).etag(o.Delete);
                }, function(e) {
                    e && (n = e, console.error("failure deleting messages:", e)), r();
                }), void 0) : (r(), void 0);
            }, function() {
                t(n, null, !0);
            }, function() {
                n = "aborted-retry";
            }, !1, "delete");
        }),
        check_delete: function(e, t) {
            t(null, "idempotent");
        },
        local_undo_delete: n.local_undo_delete,
        undo_delete: function(e, t) {
            t("moot");
        },
        local_do_syncFolderList: function(e, t) {
            t(null);
        },
        do_syncFolderList: l(1, function(e, t) {
            var n, o = this.account, s = o.getFirstFolderWithType("inbox");
            s && null === s.serverId && (n = o.getFolderStorageForFolderId(s.id)), o.syncFolderList(function(e) {
                e || (o.meta.lastFolderSyncAt = Date.now()), t(e ? "aborted-retry" : null, null, !e), 
                n && n.hasActiveSlices && (e || (console.log("Refreshing fake inbox"), n.resetAndRefreshActiveSlices()));
            });
        }, "aborted-retry"),
        check_syncFolderList: function(e, t) {
            t(null, "coherent-notyet");
        },
        local_undo_syncFolderList: function(e, t) {
            t("moot");
        },
        undo_syncFolderList: function(e, t) {
            t("moot");
        },
        local_do_downloadBodies: n.local_do_downloadBodies,
        do_downloadBodies: n.do_downloadBodies,
        check_downloadBodies: n.check_downloadBodies,
        local_do_downloadBodyReps: n.local_do_downloadBodyReps,
        do_downloadBodyReps: n.do_downloadBodyReps,
        check_downloadBodyReps: n.check_downloadBodyReps,
        local_do_download: n.local_do_download,
        do_download: n.do_download,
        check_download: n.check_download,
        local_undo_download: n.local_undo_download,
        undo_download: n.undo_download,
        local_do_sendOutboxMessages: n.local_do_sendOutboxMessages,
        do_sendOutboxMessages: n.do_sendOutboxMessages,
        check_sendOutboxMessages: n.check_sendOutboxMessages,
        local_undo_sendOutboxMessages: n.local_undo_sendOutboxMessages,
        undo_sendOutboxMessages: n.undo_sendOutboxMessages,
        local_do_setOutboxSyncEnabled: n.local_do_setOutboxSyncEnabled,
        local_do_upgradeDB: n.local_do_upgradeDB,
        local_do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        do_purgeExcessMessages: function(e, t) {
            t(null);
        },
        check_purgeExcessMessages: function() {
            return "idempotent";
        },
        local_undo_purgeExcessMessages: function(e, t) {
            t(null);
        },
        undo_purgeExcessMessages: function(e, t) {
            t(null);
        }
    }, t(u.prototype, o.draftsMixins);
    var p = d.LOGFAB = e.register(a, {
        ActiveSyncJobDriver: {
            type: e.DAEMON,
            events: {
                savedAttachment: {
                    storage: !0,
                    mimeType: !0,
                    size: !0
                },
                saveFailure: {
                    storage: !1,
                    mimeType: !1,
                    error: !1
                }
            },
            TEST_ONLY_events: {
                saveFailure: {
                    filename: !1
                }
            },
            errors: {
                callbackErr: {
                    ex: e.EXCEPTION
                }
            }
        }
    });
}), define("activesync/account", [ "rdcommon/log", "../a64", "../accountmixins", "../mailslice", "../searchfilter", "activesync/codepages/FolderHierarchy", "./folder", "./jobs", "../util", "../db/folder_info_rep", "module", "require", "exports" ], function(e, t, n, o, s, i, r, a, c, d, l, u, h) {
    function p(e, t, n) {
        return function() {
            var o = Array.slice(arguments), s = o[e], i = this;
            this.withConnection(s, function() {
                t.apply(i, o);
            }, n);
        };
    }
    function f(e, t, s, i, c, d) {
        this.universe = e, this.id = t.id, this.accountDef = t, t.connInfo.deviceId || (t.connInfo.deviceId = h.makeUniqueDeviceId()), 
        this._db = i, this._LOG = S.ActiveSyncAccount(this, d, this.id), c ? (this.conn = c, 
        this._attachLoggerToConnection(this.conn)) : this.conn = null, this.enabled = !0, 
        this.problems = [], this._alive = !0, this.identities = t.identities, this.folders = [], 
        this._folderStorages = {}, this._folderInfos = s, this._serverIdToFolderId = {}, 
        this._deadFolderIds = null, this._syncsInProgress = 0, this._lastSyncKey = null, 
        this._lastSyncResponseWasEmpty = !1, this.meta = s.$meta, this.mutations = s.$mutations;
        for (var l in s) if ("$" !== l[0]) {
            var u = s[l];
            this._folderStorages[l] = new o.FolderStorage(this, l, u, this._db, r.ActiveSyncFolderSyncer, this._LOG), 
            this._serverIdToFolderId[u.$meta.serverId] = l, this.folders.push(u.$meta);
        }
        this.folders.sort(function(e, t) {
            return e.path.localeCompare(t.path);
        }), this._jobDriver = new a.ActiveSyncJobDriver(this, this._folderInfos.$mutationState), 
        this.ensureEssentialOfflineFolders(), n.accountConstructorMixin.call(this, this, this);
    }
    var m, g, _, y = c.bsearchForInsert, v = i.Enums.Type, b = h.DEFAULT_TIMEOUT_MS = 3e4;
    h.makeUniqueDeviceId = function() {
        return Math.random().toString(36).substr(2);
    }, h.Account = h.ActiveSyncAccount = f, f.prototype = {
        type: "activesync",
        supportsServerFolders: !0,
        toString: function() {
            return "[ActiveSyncAccount: " + this.id + "]";
        },
        withConnection: function(e, t, n) {
            if (!m) return u([ "wbxml", "activesync/protocol", "activesync/codepages" ], function(o, s, i) {
                m = o, g = s, _ = i, this.withConnection(e, t, n);
            }.bind(this)), void 0;
            if (!this.conn) {
                var o = this.accountDef;
                this.conn = new g.Connection(o.connInfo.deviceId), this._attachLoggerToConnection(this.conn), 
                this.conn.open(o.connInfo.server, o.credentials.username, o.credentials.password), 
                this.conn.timeout = b;
            }
            this.conn.connected ? t() : this.conn.connect(function(o) {
                return o ? (this._reportErrorIfNecessary(o), this._isBadUserOrPassError(o) && !n && (n = "bad-user-or-pass"), 
                e(n || "unknown"), void 0) : (t(), void 0);
            }.bind(this));
        },
        _isBadUserOrPassError: function(e) {
            return e && e instanceof g.HttpError && 401 === e.status;
        },
        _reportErrorIfNecessary: function(e) {
            e && this._isBadUserOrPassError(e) && this.universe.__reportAccountProblem(this, "bad-user-or-pass", "incoming");
        },
        _attachLoggerToConnection: function(e) {
            var t = S.ActiveSyncConnection(e, this._LOG, Date.now() % 1e3);
            "safe" === t.logLevel ? e.onmessage = this._onmessage_safe.bind(this, t) : "dangerous" === t.logLevel && (e.onmessage = this._onmessage_dangerous.bind(this, t));
        },
        _onmessage_safe: function(e, t, n, o, s, i, r, a) {
            "options" === t ? e.options(n, o.status, a) : e.command(t, n, o.status);
        },
        _onmessage_dangerous: function(e, t, n, o, s, i, r, a) {
            if ("options" === t) e.options(n, o.status, a); else {
                var c, d;
                if (r) try {
                    var l = new m.Reader(new Uint8Array(r), _);
                    c = l.dump();
                } catch (u) {
                    c = "parse problem";
                }
                if (a) try {
                    d = a.dump(), a.rewind();
                } catch (u) {
                    d = "parse problem";
                }
                e.command(t, n, o.status, s, i, c, d);
            }
        },
        toBridgeWire: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: this.accountDef.type,
                defaultPriority: this.accountDef.defaultPriority,
                enabled: this.enabled,
                problems: this.problems,
                syncRange: this.accountDef.syncRange,
                syncInterval: this.accountDef.syncInterval,
                notifyOnNew: this.accountDef.notifyOnNew,
                playSoundOnSend: this.accountDef.playSoundOnSend,
                identities: this.identities,
                credentials: {
                    username: this.accountDef.credentials.username
                },
                servers: [ {
                    type: this.accountDef.type,
                    connInfo: this.accountDef.connInfo
                } ]
            };
        },
        toBridgeFolder: function() {
            return {
                id: this.accountDef.id,
                name: this.accountDef.name,
                path: this.accountDef.name,
                type: "account"
            };
        },
        get numActiveConns() {
            return 0;
        },
        checkAccount: function(e) {
            null != this.conn && (this.conn.connected && this.conn.disconnect(), this.conn = null), 
            this.withConnection(function(t) {
                e(t);
            }, function() {
                e();
            });
        },
        __checkpointSyncCompleted: function(e, t) {
            this.saveAccountState(null, e, t || "checkpointSync");
        },
        shutdown: function(e) {
            this._LOG.__die(), e && e();
        },
        accountDeleted: function() {
            this._alive = !1, this.shutdown();
        },
        sliceFolderMessages: function(e, t) {
            var n = this._folderStorages[e], s = new o.MailSlice(t, n, this._LOG);
            n.sliceOpenMostRecent(s);
        },
        searchFolderMessages: function(e, t, n, o) {
            var i = this._folderStorages[e], r = new s.SearchSlice(t, i, n, o, this._LOG);
            return i.sliceOpenSearch(r), r;
        },
        syncFolderList: p(0, function(e) {
            var t = this, n = _.FolderHierarchy.Tags, o = new m.Writer("1.3", 1, "UTF-8");
            o.stag(n.FolderSync).tag(n.SyncKey, this.meta.syncKey).etag(), this.conn.postCommand(o, function(o, s) {
                if (o) return t._reportErrorIfNecessary(o), e(o), void 0;
                var i = new m.EventParser(), r = [];
                i.addEventListener([ n.FolderSync, n.SyncKey ], function(e) {
                    t.meta.syncKey = e.children[0].textContent;
                }), i.addEventListener([ n.FolderSync, n.Changes, [ n.Add, n.Delete ] ], function(e) {
                    var o = {};
                    for (var s in Iterator(e.children)) {
                        var i = s[1];
                        o[i.localTagName] = i.children[0].textContent;
                    }
                    e.tag === n.Add ? t._addedFolder(o.ServerId, o.ParentId, o.DisplayName, o.Type) || r.push(o) : t._deletedFolder(o.ServerId);
                });
                try {
                    i.run(s);
                } catch (a) {
                    return console.error("Error parsing FolderSync response:", a, "\n", a.stack), e("unknown"), 
                    void 0;
                }
                for (;r.length; ) {
                    var c = [];
                    for (var d in Iterator(r)) {
                        var l = d[1];
                        t._addedFolder(l.ServerId, l.ParentId, l.DisplayName, l.Type) || c.push(l);
                    }
                    if (c.length === r.length) throw new Error("got some orphaned folders");
                    r = c;
                }
                t.ensureEssentialOnlineFolders(), t.normalizeFolderHierarchy(), console.log("Synced folder list"), 
                e && e(null);
            });
        }),
        _folderTypes: {
            1: "normal",
            2: "inbox",
            3: "drafts",
            4: "trash",
            5: "sent",
            6: "normal",
            12: "normal"
        },
        _junkFolderNames: [ "bulk mail", "correo no deseado", "courrier indésirable", "istenmeyen", "istenmeyen e-posta", "junk", "levélszemét", "nevyžiadaná pošta", "nevyžádaná pošta", "no deseado", "posta indesiderata", "pourriel", "roskaposti", "skräppost", "spam", "spamowanie", "søppelpost", "thư rác", "спам", "דואר זבל", "الرسائل العشوائية", "هرزنامه", "สแปม", "垃圾郵件", "垃圾邮件", "垃圾電郵" ],
        _addedFolder: function(e, n, s, i, a, c) {
            if (!(a || i in this._folderTypes)) return !0;
            var l = s, u = null, h = 0;
            if ("0" !== n) {
                if (u = this._serverIdToFolderId[n], void 0 === u) return null;
                var p = this._folderInfos[u];
                l = p.$meta.path + "/" + l, h = p.$meta.depth + 1;
            }
            var f = this._folderTypes[i];
            if (2 > h) {
                var m = s.toLowerCase();
                -1 !== this._junkFolderNames.indexOf(m) && (f = "junk");
            }
            if (a && (f = a), i === v.DefaultInbox) {
                var g = this.getFirstFolderWithType("inbox");
                if (g) return delete this._serverIdToFolderId[g.serverId], this._serverIdToFolderId[e] = g.id, 
                g.serverId = e, g.name = s, g.path = l, g.depth = h, g;
            }
            var _ = this.id + "/" + t.encodeInt(this.meta.nextFolderNum++), b = this._folderInfos[_] = {
                $meta: d.makeFolderMeta({
                    id: _,
                    serverId: e,
                    name: s,
                    type: f,
                    path: l,
                    parentId: u,
                    depth: h,
                    lastSyncedAt: 0,
                    syncKey: "0",
                    version: o.FOLDER_DB_VERSION
                }),
                $impl: {
                    nextId: 0,
                    nextHeaderBlock: 0,
                    nextBodyBlock: 0
                },
                accuracy: [],
                headerBlocks: [],
                bodyBlocks: [],
                serverIdHeaderBlockMapping: {}
            };
            console.log("Added folder " + s + " (" + _ + ")"), this._folderStorages[_] = new o.FolderStorage(this, _, b, this._db, r.ActiveSyncFolderSyncer, this._LOG), 
            this._serverIdToFolderId[e] = _;
            var S = b.$meta, T = y(this.folders, S, function(e, t) {
                return e.path.localeCompare(t.path);
            });
            return this.folders.splice(T, 0, S), c || this.universe.__notifyAddedFolder(this, S), 
            S;
        },
        _deletedFolder: function(e, t) {
            var n = this._serverIdToFolderId[e], o = this._folderInfos[n], s = o.$meta;
            console.log("Deleted folder " + s.name + " (" + n + ")"), delete this._serverIdToFolderId[e], 
            delete this._folderInfos[n], delete this._folderStorages[n];
            var i = this.folders.indexOf(s);
            this.folders.splice(i, 1), null === this._deadFolderIds && (this._deadFolderIds = []), 
            this._deadFolderIds.push(n), t || this.universe.__notifyRemovedFolder(this, s);
        },
        _recreateFolder: function(e, t) {
            this._LOG.recreateFolder(e);
            var n = this._folderInfos[e];
            n.$impl = {
                nextId: 0,
                nextHeaderBlock: 0,
                nextBodyBlock: 0
            }, n.accuracy = [], n.headerBlocks = [], n.bodyBlocks = [], n.serverIdHeaderBlockMapping = {}, 
            null === this._deadFolderIds && (this._deadFolderIds = []), this._deadFolderIds.push(e);
            var s = this;
            this.saveAccountState(null, function() {
                var i = new o.FolderStorage(s, e, n, s._db, r.ActiveSyncFolderSyncer, s._LOG);
                for (var a in Iterator(s._folderStorages[e]._slices)) {
                    var c = a[1];
                    c._storage = i, c.reset(), i.sliceOpenMostRecent(c);
                }
                s._folderStorages[e]._slices = [], s._folderStorages[e] = i, t(i);
            }, "recreateFolder");
        },
        createFolder: p(3, function(e, t, n, o) {
            var s = this, i = e ? this._folderInfos[e] : "0", r = _.FolderHierarchy.Tags, a = _.FolderHierarchy.Enums.Status, c = _.FolderHierarchy.Enums.Type.Mail, d = new m.Writer("1.3", 1, "UTF-8");
            d.stag(r.FolderCreate).tag(r.SyncKey, this.meta.syncKey).tag(r.ParentId, i).tag(r.DisplayName, t).tag(r.Type, c).etag(), 
            this.conn.postCommand(d, function(e, n) {
                s._reportErrorIfNecessary(e);
                var d, l, u = new m.EventParser();
                u.addEventListener([ r.FolderCreate, r.Status ], function(e) {
                    d = e.children[0].textContent;
                }), u.addEventListener([ r.FolderCreate, r.SyncKey ], function(e) {
                    s.meta.syncKey = e.children[0].textContent;
                }), u.addEventListener([ r.FolderCreate, r.ServerId ], function(e) {
                    l = e.children[0].textContent;
                });
                try {
                    u.run(n);
                } catch (h) {
                    return console.error("Error parsing FolderCreate response:", h, "\n", h.stack), 
                    o("unknown"), void 0;
                }
                if (d === a.Success) {
                    var p = s._addedFolder(l, i, t, c);
                    o(null, p);
                } else d === a.FolderExists ? o("already-exists") : o("unknown");
            });
        }),
        deleteFolder: p(1, function(e, t) {
            var n = this, o = this._folderInfos[e].$meta, s = _.FolderHierarchy.Tags, i = _.FolderHierarchy.Enums.Status;
            _.FolderHierarchy.Enums.Type.Mail;
            var r = new m.Writer("1.3", 1, "UTF-8");
            r.stag(s.FolderDelete).tag(s.SyncKey, this.meta.syncKey).tag(s.ServerId, o.serverId).etag(), 
            this.conn.postCommand(r, function(e, r) {
                n._reportErrorIfNecessary(e);
                var a, c = new m.EventParser();
                c.addEventListener([ s.FolderDelete, s.Status ], function(e) {
                    a = e.children[0].textContent;
                }), c.addEventListener([ s.FolderDelete, s.SyncKey ], function(e) {
                    n.meta.syncKey = e.children[0].textContent;
                });
                try {
                    c.run(r);
                } catch (d) {
                    return console.error("Error parsing FolderDelete response:", d, "\n", d.stack), 
                    t("unknown"), void 0;
                }
                a === i.Success ? (n._deletedFolder(o.serverId), t(null, o)) : t("unknown");
            });
        }),
        sendMessage: p(1, function(e, t) {
            var n = this;
            e.withMessageBlob({
                includeBcc: !0
            }, function(o) {
                if (this.conn.currentVersion.gte("14.0")) {
                    var s = _.ComposeMail.Tags, i = new m.Writer("1.3", 1, "UTF-8", null, "blob");
                    i.stag(s.SendMail).tag(s.ClientId, Date.now().toString() + "@mozgaia").tag(s.SaveInSentItems).stag(s.Mime).opaque(o).etag().etag(), 
                    this.conn.postCommand(i, function(e, o) {
                        return e ? (n._reportErrorIfNecessary(e), console.error(e), t("unknown"), void 0) : (null === o ? (console.log("Sent message successfully!"), 
                        t(null)) : (console.error("Error sending message. XML dump follows:\n" + o.dump()), 
                        t("unknown")), void 0);
                    }, null, null, function() {
                        e.renewSmartWakeLock("ActiveSync XHR Progress");
                    });
                } else this.conn.postData("SendMail", "message/rfc822", o, function(e) {
                    return e ? (n._reportErrorIfNecessary(e), console.error(e), t("unknown"), void 0) : (console.log("Sent message successfully!"), 
                    t(null), void 0);
                }, {
                    SaveInSent: "T"
                }, null, function() {
                    e.renewSmartWakeLock("ActiveSync XHR Progress");
                });
            }.bind(this));
        }),
        getFolderStorageForFolderId: function(e) {
            return this._folderStorages[e];
        },
        getFolderStorageForServerId: function(e) {
            return this._folderStorages[this._serverIdToFolderId[e]];
        },
        getFolderMetaForFolderId: function(e) {
            return this._folderInfos.hasOwnProperty(e) ? this._folderInfos[e].$meta : null;
        },
        ensureEssentialOfflineFolders: function() {
            [ {
                type: "inbox",
                displayName: "Inbox",
                typeNum: v.DefaultInbox
            }, {
                type: "outbox",
                displayName: "outbox",
                typeNum: v.Unknown
            }, {
                type: "localdrafts",
                displayName: "localdrafts",
                typeNum: v.Unknown
            } ].forEach(function(e) {
                this.getFirstFolderWithType(e.type) || this._addedFolder(null, "0", e.displayName, e.typeNum, e.type, !0);
            }, this);
        },
        ensureEssentialOnlineFolders: function(e) {
            e && e();
        },
        normalizeFolderHierarchy: n.normalizeFolderHierarchy,
        scheduleMessagePurge: function(e, t) {
            t && t();
        },
        upgradeFolderStoragesIfNeeded: n.upgradeFolderStoragesIfNeeded,
        runOp: n.runOp,
        getFirstFolderWithType: n.getFirstFolderWithType,
        getFolderByPath: n.getFolderByPath,
        saveAccountState: n.saveAccountState,
        runAfterSaves: n.runAfterSaves,
        allOperationsCompleted: function() {}
    };
    var S = h.LOGFAB = e.register(l, {
        ActiveSyncAccount: {
            type: e.ACCOUNT,
            events: {
                createFolder: {},
                deleteFolder: {},
                recreateFolder: {
                    id: !1
                },
                accountDeleted: {
                    where: !1
                }
            },
            asyncJobs: {
                runOp: {
                    mode: !0,
                    type: !0,
                    error: !0,
                    op: !1
                },
                saveAccountState: {
                    reason: !0,
                    folderSaveCount: !0
                }
            },
            errors: {
                opError: {
                    mode: !1,
                    type: !1,
                    ex: e.EXCEPTION
                }
            }
        },
        ActiveSyncConnection: {
            type: e.CONNECTION,
            events: {
                options: {
                    special: !1,
                    status: !1,
                    result: !1
                },
                command: {
                    name: !1,
                    special: !1,
                    status: !1
                }
            },
            TEST_ONLY_events: {
                options: {},
                command: {
                    params: !1,
                    extraHeaders: !1,
                    sent: !1,
                    response: !1
                }
            }
        }
    });
}), define("activesync/configurator", [ "rdcommon/log", "slog", "../accountcommon", "../a64", "./account", "../date", "tcp-socket", "require", "exports" ], function(e, t, n, o, s, i, r, a, c) {
    function d(e, t) {
        function n(e) {
            if (a) {
                var n = a;
                a = null;
                try {
                    n.close();
                } catch (o) {}
                t(e);
            }
        }
        var o = /^https:\/\/([^:\/]+)(?::(\d+))?/.exec(e);
        if (!o) return t(null), void 0;
        var s = o[2] ? parseInt(o[2], 10) : 443, i = o[1];
        console.log("checking", i, s, "for security problem");
        var a = r.open(i, s);
        a.onopen = function() {
            a.send(new TextEncoder("utf-8").encode("GET /images/logo.png HTTP/1.1\n\n"));
        }, a.onerror = function(e) {
            var t = null;
            e && "object" == typeof e && /^Security/.test(e.name) && (t = "bad-security"), n(t);
        }, a.ondata = function() {
            n(null);
        };
    }
    c.account = s, c.configurator = {
        timeout: 3e4,
        _getFullDetailsFromAutodiscover: function(e, n, o, s) {
            t.log("activesync.configurator.autodiscover:begin", {
                url: o
            }), e.raw_autodiscover(o, n.emailAddress, n.password, self.timeout, !1, function(n, i) {
                if (n) {
                    var r = "no-config-info", a = {};
                    return n instanceof e.HttpError ? 401 === n.status ? r = "bad-user-or-pass" : 403 === n.status ? r = "not-authorized" : a.status = n.status : n instanceof e.AutodiscoverDomainError && t.log("activesync.configurator.autodiscover.error", {
                        message: n.message
                    }), t.log("activesync.configurator.autodiscover:end", {
                        url: o,
                        err: r
                    }), s(r, null, a), void 0;
                }
                t.log("activesync.configurator.autodiscover:end", {
                    url: o,
                    server: i.mobileSyncServer.url
                });
                var c = {
                    type: "activesync",
                    displayName: i.user.name,
                    incoming: {
                        server: i.mobileSyncServer.url,
                        username: i.user.email
                    }
                };
                s(null, c, null);
            });
        },
        tryToCreateAccount: function(e, t, n, o, s) {
            a([ "activesync/protocol" ], function(i) {
                return n.incoming.autodiscoverEndpoint ? (this._getFullDetailsFromAutodiscover(i, t, n.incoming.autodiscoverEndpoint, function(n, r, a) {
                    return n ? (o(n, r, a), void 0) : (this._createAccountUsingFullInfo(e, t, r, o, i, s), 
                    void 0);
                }.bind(this)), void 0) : (this._createAccountUsingFullInfo(e, t, n, o, i, s), void 0);
            }.bind(this));
        },
        _createAccountUsingFullInfo: function(e, n, r, a, c) {
            t.log("activesync.configurator.create:begin", {
                server: r.incoming.server
            });
            var l = {
                username: r.incoming.username,
                password: n.password
            }, u = s.makeUniqueDeviceId(), h = this, p = new c.Connection(u);
            p.open(r.incoming.server, l.username, l.password), p.timeout = s.DEFAULT_TIMEOUT_MS, 
            p.connect(function(s) {
                if (s) {
                    var f, m = {
                        server: r.incoming.server
                    };
                    return s instanceof c.HttpError ? (401 === s.status ? f = "bad-user-or-pass" : 403 === s.status ? f = "not-authorized" : (f = "server-problem", 
                    m.status = s.status), t.log("activesync.configurator.create:end", {
                        server: r.incoming.server,
                        err: f
                    }), a(f, null, m), void 0) : (d(r.incoming.server, function(e) {
                        var t;
                        t = e ? "bad-security" : "unresponsive-server", a(t, null, m);
                    }), void 0);
                }
                var g = o.encodeInt(e.config.nextAccountNum++), _ = {
                    id: g,
                    name: n.accountName || n.emailAddress,
                    defaultPriority: i.NOW(),
                    type: "activesync",
                    syncRange: "auto",
                    syncInterval: n.syncInterval || 0,
                    notifyOnNew: n.hasOwnProperty("notifyOnNew") ? n.notifyOnNew : !0,
                    playSoundOnSend: n.hasOwnProperty("playSoundOnSend") ? n.playSoundOnSend : !0,
                    credentials: l,
                    connInfo: {
                        server: r.incoming.server,
                        deviceId: u
                    },
                    identities: [ {
                        id: g + "/" + o.encodeInt(e.config.nextIdentityNum++),
                        name: n.displayName || r.displayName,
                        address: n.emailAddress,
                        replyTo: null,
                        signature: null
                    } ]
                };
                t.log("activesync.configurator.create:end", {
                    server: r.incoming.server,
                    id: g
                }), h._loadAccount(e, _, p, function(e) {
                    a(null, e, null);
                });
            });
        },
        recreateAccount: function(e, t, i, r) {
            var a = i.def, c = {
                username: a.credentials.username,
                password: a.credentials.password
            }, d = o.encodeInt(e.config.nextAccountNum++), l = {
                id: d,
                name: a.name,
                type: "activesync",
                syncRange: a.syncRange,
                syncInterval: a.syncInterval || 0,
                notifyOnNew: a.hasOwnProperty("notifyOnNew") ? a.notifyOnNew : !0,
                playSoundOnSend: a.hasOwnProperty("playSoundOnSend") ? a.playSoundOnSend : !0,
                credentials: c,
                connInfo: {
                    server: a.connInfo.server,
                    deviceId: a.connInfo.deviceId || s.makeUniqueDeviceId()
                },
                identities: n.recreateIdentities(e, d, a.identities)
            };
            this._loadAccount(e, l, null, function(e) {
                r(null, e, null);
            });
        },
        _loadAccount: function(e, t, n, o) {
            var s = {
                $meta: {
                    nextFolderNum: 0,
                    nextMutationNum: 0,
                    lastFolderSyncAt: 0,
                    syncKey: "0"
                },
                $mutations: [],
                $mutationState: {}
            };
            e.saveAccountDef(t, s), e._loadAccount(t, s, n, o);
        }
    };
});