var MimeMapper = {
    _typeToExtensionMap: {
        "image/jpeg": "jpg",
        "image/png": "png",
        "image/gif": "gif",
        "image/bmp": "bmp",
        "audio/mpeg": "mp3",
        "audio/mp4": "m4a",
        "audio/ogg": "ogg",
        "audio/webm": "webm",
        "audio/3gpp": "3gp",
        "audio/amr": "amr",
        "video/mp4": "mp4",
        "video/mpeg": "mpg",
        "video/ogg": "ogg",
        "video/webm": "webm",
        "video/3gpp": "3gp",
        "video/3gpp2": "3g2",
        "application/vcard": "vcf",
        "text/vcard": "vcf",
        "text/x-vcard": "vcf"
    },
    _extensionToTypeMap: {
        jpg: "image/jpeg",
        jpeg: "image/jpeg",
        jpe: "image/jpeg",
        png: "image/png",
        gif: "image/gif",
        bmp: "image/bmp",
        mp3: "audio/mpeg",
        m4a: "audio/mp4",
        m4b: "audio/mp4",
        m4p: "audio/mp4",
        m4r: "audio/mp4",
        aac: "audio/aac",
        opus: "audio/ogg",
        amr: "audio/amr",
        mp4: "video/mp4",
        mpeg: "video/mpeg",
        mpg: "video/mpeg",
        ogv: "video/ogg",
        ogx: "video/ogg",
        webm: "video/webm",
        "3gp": "video/3gpp",
        "3g2": "video/3gpp2",
        ogg: "video/ogg",
        vcf: "text/vcard"
    },
    _parseExtension: function(e) {
        var t = e.split(".");
        return t.length > 1 ? t.pop() : "";
    },
    isSupportedType: function(e) {
        return e in this._typeToExtensionMap;
    },
    isSupportedExtension: function(e) {
        return e in this._extensionToTypeMap;
    },
    isFilenameMatchesType: function(e, t) {
        var n = this._parseExtension(e), i = this.guessTypeFromExtension(n);
        return i == t;
    },
    guessExtensionFromType: function(e) {
        return this._typeToExtensionMap[e];
    },
    guessTypeFromExtension: function(e) {
        return this._extensionToTypeMap[e];
    },
    guessTypeFromFileProperties: function(e, t) {
        var n = this._parseExtension(e), i = this.isSupportedType(t) ? t : this.guessTypeFromExtension(n);
        return i || "";
    },
    ensureFilenameMatchesType: function(e, t) {
        if (!this.isFilenameMatchesType(e, t)) {
            var n = this.guessExtensionFromType(t);
            n && (e += "." + n);
        }
        return e;
    }
};