;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;'use strict';var MimeMapper={_typeToExtensionMap:{'image/jpeg':'jpg','image/png':'png','image/gif':'gif','image/bmp':'bmp','audio/mpeg':'mp3','audio/mp4':'m4a','audio/ogg':'ogg','audio/webm':'webm','audio/3gpp':'3gp','audio/amr':'amr','video/mp4':'mp4','video/mpeg':'mpg','video/ogg':'ogg','video/webm':'webm','video/3gpp':'3gp','video/3gpp2':'3g2','application/vcard':'vcf','text/vcard':'vcf','text/x-vcard':'vcf'},_extensionToTypeMap:{'jpg':'image/jpeg','jpeg':'image/jpeg','jpe':'image/jpeg','png':'image/png','gif':'image/gif','bmp':'image/bmp','mp3':'audio/mpeg','m4a':'audio/mp4','m4b':'audio/mp4','m4p':'audio/mp4','m4r':'audio/mp4','aac':'audio/aac','opus':'audio/ogg','amr':'audio/amr','mp4':'video/mp4','mpeg':'video/mpeg','mpg':'video/mpeg','ogv':'video/ogg','ogx':'video/ogg','webm':'video/webm','3gp':'video/3gpp','3g2':'video/3gpp2','ogg':'video/ogg','vcf':'text/vcard'},_parseExtension:function(filename){var array=filename.split('.');return array.length>1?array.pop():'';},isSupportedType:function(mimetype){return(mimetype in this._typeToExtensionMap);},isSupportedExtension:function(extension){return(extension in this._extensionToTypeMap);},isFilenameMatchesType:function(filename,mimetype){var extension=this._parseExtension(filename);var guessedType=this.guessTypeFromExtension(extension);return(guessedType==mimetype);},guessExtensionFromType:function(mimetype){return this._typeToExtensionMap[mimetype];},guessTypeFromExtension:function(extension){return this._extensionToTypeMap[extension];},guessTypeFromFileProperties:function(filename,mimetype){var extension=this._parseExtension(filename);var type=this.isSupportedType(mimetype)?mimetype:this.guessTypeFromExtension(extension);return type||'';},ensureFilenameMatchesType:function(filename,mimetype){if(!this.isFilenameMatchesType(filename,mimetype)){var guessedExt=this.guessExtensionFromType(mimetype);if(guessedExt){filename+='.'+guessedExt;}}
return filename;}};;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;(function(exports){'use strict';var ImageUtils=exports.ImageUtils={};const JPEG='image/jpeg';const PNG='image/png';const GIF='image/gif';const BMP='image/bmp';ImageUtils.JPEG=JPEG;ImageUtils.PNG=PNG;ImageUtils.GIF=GIF;ImageUtils.BMP=BMP;ImageUtils.getSizeAndType=function getSizeAndType(imageBlob){if(!(imageBlob instanceof Blob)){return Promise.reject(new TypeError('argument is not a Blob'));}
return new Promise(function(resolve,reject){if(imageBlob.size<=16){reject('corrupt image file');return;}
var bytesToRead=32*1024;if(imageBlob.type===PNG||imageBlob.type===GIF||imageBlob.type===BMP){bytesToRead=512;}
findSizeAndType(imageBlob,bytesToRead,success,tryagain);function success(data){resolve(data);}
function tryagain(data){if(data.type===JPEG){findSizeAndType(imageBlob,imageBlob.size,success,failure);}
else{reject(data.error);}}
function failure(data){reject(data.error);}});function findSizeAndType(imageBlob,amountToRead,success,failure){var slice=imageBlob.slice(0,Math.min(amountToRead,imageBlob.size));var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){parseImageData(reader.result);};function parseImageData(buffer){var header=new Uint8Array(buffer,0,16);var view=new DataView(buffer);if(header[0]===0x89&&header[1]===0x50&&header[2]===0x4e&&header[3]===0x47&&header[4]===0x0d&&header[5]===0x0a&&header[6]===0x1A&&header[7]===0x0a&&header[12]===0x49&&header[13]===0x48&&header[14]===0x44&&header[15]===0x52)
{try{success({type:PNG,width:view.getUint32(16,false),height:view.getUint32(20,false)});}
catch(ex){failure({error:ex.toString()});}}
else if(header[0]===0x47&&header[1]===0x49&&header[2]===0x46&&header[3]===0x38&&(header[4]===0x37||header[4]===0x39)&&header[5]===0x61)
{try{success({type:GIF,width:view.getUint16(6,true),height:view.getUint16(8,true)});}
catch(ex){failure({error:ex.toString()});}}
else if(header[0]===0x42&&header[1]===0x4D&&view.getUint32(2,true)===imageBlob.size)
{try{var width,height;if(view.getUint16(14,true)===12){width=view.getUint16(18,true);height=view.getUint16(20,true);}
else{width=view.getUint32(18,true);height=view.getUint32(22,true);}
success({type:BMP,width:width,height:height});}
catch(ex){failure({error:ex.toString()});}}
else if(header[0]===0xFF&&header[1]===0xD8){var value={type:JPEG};try{var offset=2;for(;;){if(view.getUint8(offset)!==0xFF){failure({error:'corrupt JPEG file'});}
var segmentType=view.getUint8(offset+1);var segmentSize=view.getUint16(offset+2)+2;if((segmentType>=0xC0&&segmentType<=0xC3)||(segmentType>=0xC5&&segmentType<=0xC7)||(segmentType>=0xC9&&segmentType<=0xCB)||(segmentType>=0xCD&&segmentType<=0xCF))
{value.height=view.getUint16(offset+5,false);value.width=view.getUint16(offset+7,false);success(value);break;}
offset+=segmentSize;if(offset+9>view.byteLength){value.error='corrupt JPEG file';failure(value);break;}}}
catch(ex){failure({error:ex.toString()});}}
else{failure({error:'unknown image type'});}}}};ImageUtils.resizeAndCropToCover=function(inputImageBlob,outputWidth,outputHeight,outputType,encoderOptions)
{if(!outputWidth||!isFinite(outputWidth)||outputWidth<=0||!outputHeight||!isFinite(outputHeight)||outputHeight<=0){return Promise.reject(new TypeError('invalid output dimensions'));}
outputWidth=Math.round(outputWidth);outputHeight=Math.round(outputHeight);return ImageUtils.getSizeAndType(inputImageBlob).then(function resolve(data){var inputWidth=data.width;var inputHeight=data.height;if(inputWidth===outputWidth&&inputHeight===outputHeight){return inputImageBlob;}
return resize(data);},function reject(error){return resize({});});function resize(data){var inputType=data.type;var inputWidth=data.width;var inputHeight=data.height;if(outputType&&outputType!==JPEG&&outputType!==PNG){console.warn('Ignoring unsupported outputType',outputType);outputType=undefined;}
if(!outputType){if(inputType===JPEG||inputType===PNG){outputType=inputType;}
else{outputType=PNG;}}
var url=URL.createObjectURL(inputImageBlob);var mediaFragment;if(inputType===JPEG&&inputWidth>outputWidth&&inputHeight>outputHeight){var reduction=Math.max(outputWidth/inputWidth,outputHeight/inputHeight);mediaFragment=ImageUtils.Downsample.sizeNoMoreThan(reduction);}
else{mediaFragment='';}
return new Promise(function(resolve,reject){var offscreenImage=new Image();offscreenImage.src=url+mediaFragment;offscreenImage.onerror=function(e){cleanupImage();reject('failed to decode image');};offscreenImage.onload=function(){var actualWidth=offscreenImage.width;var actualHeight=offscreenImage.height;var widthScale=outputWidth/actualWidth;var heightScale=outputHeight/actualHeight;var scale=Math.max(widthScale,heightScale);var cropWidth=Math.round(outputWidth/scale);var cropHeight=Math.round(outputHeight/scale);var cropLeft=Math.floor((actualWidth-cropWidth)/2);var cropTop=Math.floor((actualHeight-cropHeight)/2);var canvas=document.createElement('canvas');canvas.width=outputWidth;canvas.height=outputHeight;var context=canvas.getContext('2d',{willReadFrequently:true});context.drawImage(offscreenImage,cropLeft,cropTop,cropWidth,cropHeight,0,0,outputWidth,outputHeight);cleanupImage();canvas.toBlob(function(blob){canvas.width=0;resolve(blob);},outputType,encoderOptions);};function cleanupImage(){offscreenImage.onerror=offscreenImage.onload='';offscreenImage.src='';URL.revokeObjectURL(url);}});}};(function(exports){'use strict';function round(x){return Math.round(x*100)/100;}
function MozSampleSize(n,scale){return Object.freeze({dimensionScale:round(scale),areaScale:round(scale*scale),toString:function(){return'#-moz-samplesize='+n;},scale:function(x){return Math.ceil(x*scale);}});}
var NONE=Object.freeze({dimensionScale:1,areaScale:1,toString:function(){return'';},scale:function(x){return x;}});var fragments=[NONE,MozSampleSize(2,1/2),MozSampleSize(3,3/8),MozSampleSize(4,1/4),MozSampleSize(8,1/8)];function sizeAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.dimensionScale<=scale){return f;}}
return fragments[fragments.length-1];}
function sizeNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.dimensionScale>=scale){return f;}}
return NONE;}
function areaAtLeast(scale){scale=round(scale);for(var i=0;i<fragments.length;i++){var f=fragments[i];if(f.areaScale<=scale){return f;}}
return fragments[fragments.length-1];}
function areaNoMoreThan(scale){scale=round(scale);for(var i=fragments.length-1;i>=0;i--){var f=fragments[i];if(f.areaScale>=scale){return f;}}
return NONE;}
exports.Downsample={sizeAtLeast:sizeAtLeast,sizeNoMoreThan:sizeNoMoreThan,areaAtLeast:areaAtLeast,areaNoMoreThan:areaNoMoreThan,NONE:NONE,MAX_SIZE_REDUCTION:1/fragments[fragments.length-1].dimensionScale,MAX_AREA_REDUCTION:1/fragments[fragments.length-1].areaScale};}(exports.ImageUtils));})(window);;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.GaiaHeader=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var debug=0?console.log.bind(console):function(){};var cache={};var MIN=16;var MAX=24;var BUFFER=3;module.exports=function(config){debug('font fit',config);var space=config.space-BUFFER;var min=config.min||MIN;var max=config.max||MAX;var text=trim(config.text);var fontSize=max;var textWidth;var font;do{font=config.font.replace(/\d+px/,fontSize+'px');textWidth=getTextWidth(text,font);}while(textWidth>space&&fontSize!==min&&fontSize--);return{textWidth:textWidth,fontSize:fontSize,overflowing:textWidth>space};};function getTextWidth(text,font){var ctx=getCanvasContext(font);var width=ctx.measureText(text).width;debug('got text width',width);return width;}
function getCanvasContext(font){debug('get canvas context',font);var cached=cache[font];if(cached){return cached;}
var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1px');canvas.setAttribute('height','1px');debug('created canvas',canvas);var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=font;return cache[font]=ctx;}
function trim(text){return text.replace(/\s+/g,' ').trim();}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('font-fit',this));},{}],2:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var textContent=Object.getOwnPropertyDescriptor(Node.prototype,'textContent');var innerHTML=Object.getOwnPropertyDescriptor(Element.prototype,'innerHTML');var removeAttribute=Element.prototype.removeAttribute;var setAttribute=Element.prototype.setAttribute;var noop=function(){};exports.register=function(name,props){var baseProto=getBaseProto(props.extends);delete props.extends;if(props.template){var output=processCss(props.template,name);props.template=document.createElement('template');props.template.innerHTML=output.template;props.lightCss=output.lightCss;props.globalCss=props.globalCss||'';props.globalCss+=output.globalCss;}
injectGlobalCss(props.globalCss);delete props.globalCss;var descriptors=Object.assign(props.attrs||{},base.descriptors);props._attrs=props.attrs;delete props.attrs;var proto=createProto(baseProto,props);Object.defineProperties(proto,descriptors);try{return document.registerElement(name,{prototype:proto});}catch(e){if(e.name!=='NotSupportedError'){throw e;}}};var base={properties:{GaiaComponent:true,attributeChanged:noop,attached:noop,detached:noop,created:noop,createdCallback:function(){if(this.rtl){addDirObserver();}
injectLightCss(this);this.created();},attributeChangedCallback:function(name,from,to){var prop=toCamelCase(name);if(this._attrs&&this._attrs[prop]){this[prop]=to;}
this.attributeChanged(name,from,to);},attachedCallback:function(){this.attached();},detachedCallback:function(){this.detached();},setupShadowRoot:function(){if(!this.template){return;}
var node=document.importNode(this.template.content,true);this.createShadowRoot().appendChild(node);return this.shadowRoot;},setAttr:function(name,value){var internal=this.shadowRoot.firstElementChild;setAttribute.call(internal,name,value);setAttribute.call(this,name,value);},removeAttr:function(name){var internal=this.shadowRoot.firstElementChild;removeAttribute.call(internal,name);removeAttribute.call(this,name);}},descriptors:{textContent:{set:function(value){textContent.set.call(this,value);if(this.lightStyle){this.appendChild(this.lightStyle);}},get:textContent.get},innerHTML:{set:function(value){innerHTML.set.call(this,value);if(this.lightStyle){this.appendChild(this.lightStyle);}},get:innerHTML.get}}};var defaultPrototype=createProto(HTMLElement.prototype,base.properties);function getBaseProto(proto){if(!proto){return defaultPrototype;}
proto=proto.prototype||proto;return!proto.GaiaComponent?createProto(proto,base.properties):proto;}
function createProto(proto,props){return Object.assign(Object.create(proto),props);}
var hasShadowCSS=(function(){var div=document.createElement('div');try{div.querySelector(':host');return true;}
catch(e){return false;}})();var regex={shadowCss:/(?:\:host|\:\:content)[^{]*\{[^}]*\}/g,':host':/(?:\:host)/g,':host()':/\:host\((.+)\)(?: \:\:content)?/g,':host-context':/\:host-context\((.+)\)([^{,]+)?/g,'::content':/(?:\:\:content)/g};function processCss(template,name){var globalCss='';var lightCss='';if(!hasShadowCSS){template=template.replace(regex.shadowCss,function(match){var hostContext=regex[':host-context'].exec(match);if(hostContext){globalCss+=match.replace(regex['::content'],'').replace(regex[':host-context'],'$1 '+name+'$2').replace(/ +/g,' ');}else{lightCss+=match.replace(regex[':host()'],name+'$1').replace(regex[':host'],name).replace(regex['::content'],name);}
return'';});}
return{template:template,lightCss:lightCss,globalCss:globalCss};}
function injectGlobalCss(css){if(!css)return;var style=document.createElement('style');style.innerHTML=css.trim();headReady().then(()=>{document.head.appendChild(style)});}
function headReady(){return new Promise(resolve=>{if(document.head){return resolve();}
window.addEventListener('load',function fn(){window.removeEventListener('load',fn);resolve();});});}
function injectLightCss(el){if(hasShadowCSS){return;}
el.lightStyle=document.createElement('style');el.lightStyle.setAttribute('scoped','');el.lightStyle.innerHTML=el.lightCss;el.appendChild(el.lightStyle);}
function toCamelCase(string){return string.replace(/-(.)/g,function replacer(string,p1){return p1.toUpperCase();});}
var dirObserver;function addDirObserver(){if(dirObserver){return;}
dirObserver=new MutationObserver(onChanged);dirObserver.observe(document.documentElement,{attributeFilter:['dir'],attributes:true});function onChanged(mutations){document.dispatchEvent(new Event('dirchanged'));}}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-component',this));},{}],3:[function(require,module,exports){(function(define){define(function(require,exports,module){var base=window.GAIA_ICONS_BASE_URL||window.COMPONENTS_BASE_URL||'bower_components/';if(!document.documentElement){window.addEventListener('load',load);}else{load();}
function load(){if(isLoaded()){return;}
var link=document.createElement('link');link.rel='stylesheet';link.type='text/css';link.href=base+'gaia-icons/gaia-icons.css';document.head.appendChild(link);exports.loaded=true;}
function isLoaded(){return exports.loaded||document.querySelector('link[href*=gaia-icons]')||document.documentElement.classList.contains('gaia-icons-loaded');}});})(typeof define=='function'&&define.amd?define:(function(n,w){return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-icons',this));},{}],4:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var component=require('gaia-component');var fontFit=require('font-fit');require('gaia-icons');var debug=0?console.log.bind(console):function(){};const KNOWN_ACTIONS={menu:'menu',back:'back',close:'close'};const TITLE_FONT='italic 300 24px FiraSans';const TITLE_PADDING=10;const MINIMUM_FONT_SIZE_CENTERED=20;const MINIMUM_FONT_SIZE_UNCENTERED=16;const MAXIMUM_FONT_SIZE=23;module.exports=component.register('gaia-header',{created:function(){debug('created');this.setupShadowRoot();this.els={actionButton:this.shadowRoot.querySelector('.action-button'),buttons:this.querySelectorAll('button, a'),titles:this.querySelectorAll('h1')};this.els.actionButton.addEventListener('click',e=>this.onActionButtonClick(e));this.observer=new MutationObserver(this.onMutation.bind(this));this.titleEnd=this.getAttribute('title-end');this.titleStart=this.getAttribute('title-start');this.noFontFit=this.getAttribute('no-font-fit');this.notFlush=this.hasAttribute('not-flush');this.action=this.getAttribute('action');this.unresolved={};this.pending={};this._resizeThrottlingId=null;this.onResize=this.onResize.bind(this);},attached:function(){debug('attached');this.runFontFitSoon();this.observerStart();window.addEventListener('resize',this.onResize);},detached:function(){debug('detached');window.removeEventListener('resize',this.onResize);this.observerStop();this.clearPending();},clearPending:function(){for(var key in this.pending){this.pending[key].clear();delete this.pending[key];}
window.cancelAnimationFrame(this._resizeThrottlingId);this._resizeThrottlingId=null;},runFontFit:function(){debug('run font-fit');if(this.noFontFit){return Promise.resolve();}
var titles=this.els.titles;var space=this.getTitleSpace();var styles=[].map.call(titles,el=>this.getTitleStyle(el,space));return this.setTitleStylesSoon(styles);},runFontFitSoon:function(){debug('run font-fit soon');if(this.pending.runFontFitSoon){return;}
this.pending.runFontFitSoon=this.nextTick(()=>{delete this.pending.runFontFitSoon;this.runFontFit();});},getTitleStyle:function(el,space){debug('get el style',el,space);var text=el.textContent;var styleId=space.start+text+space.end+'#'+space.value;if(!text||!text.trim()){return debug('exit: no text');}
if(getStyleId(el)===styleId){return debug('exit: no change');}
var marginStart=this.getTitleMarginStart();var textSpace=space.value-Math.abs(marginStart);var fontFitResult=this.fontFit(text,textSpace,{min:MINIMUM_FONT_SIZE_CENTERED});var overflowing=fontFitResult.overflowing;var padding={start:0,end:0};if(overflowing){debug('title overflowing');padding.start=!space.start?TITLE_PADDING:0;padding.end=!space.end?TITLE_PADDING:0;textSpace=space.value-padding.start-padding.end;fontFitResult=this.fontFit(text,textSpace);marginStart=0;}
return{id:styleId,fontSize:fontFitResult.fontSize,marginStart:marginStart,overflowing:overflowing,padding:padding};},setTitleStylesSoon:function(styles){debug('set title styles soon',styles);var key='setStyleTitlesSoon';this._titleStyles=styles;return this.unresolved[key]=this.unresolved[key]||new Promise((resolve)=>{this.pending[key]=this.nextTick(()=>{var styles=this._titleStyles;var els=this.els.titles;[].forEach.call(els,(el,i)=>{if(!styles[i]){return debug('exit');}
this.setTitleStyle(el,styles[i]);});delete this._titleStyles;delete this.unresolved[key];delete this.pending[key];resolve();});});},setTitleStyle:function(el,style){debug('set title style',style);this.observerStop();el.style.marginLeft=style.marginStart+'px';el.style.paddingLeft=style.padding.start+'px';el.style.paddingRight=style.padding.end+'px';el.style.fontSize=style.fontSize+'px';setStyleId(el,style.id);this.observerStart();},fontFit:function(text,space,opts={}){debug('font fit:',text,space,opts);var fontFitArgs={font:TITLE_FONT,min:opts.min||MINIMUM_FONT_SIZE_UNCENTERED,max:MAXIMUM_FONT_SIZE,text:text,space:space};return fontFit(fontFitArgs);},observerStart:function(){if(this.observing){return;}
this.observer.observe(this,{childList:true,attributes:true,subtree:true});this.observing=true;debug('observer started');},observerStop:function(){if(!this.observing){return;}
this.observer.disconnect();this.observing=false;debug('observer stopped');},onResize:function(e){debug('onResize',this._resizeThrottlingId);if(this._resizeThrottlingId!==null){return;}
this._resizeThrottlingId=window.requestAnimationFrame(()=>{this._resizeThrottlingId=null;this.runFontFitSoon();});},onMutation:function(mutations){debug('on mutation',mutations);if(!this.pending.runFontFitSoon){this.runFontFit();}},getTitleSpace:function(){var start=this.titleStart;var end=this.titleEnd;var space=this.getWidth()-start-end;var result={value:space,start:start,end:end};debug('get title space',result);return result;},getWidth:function(){var value=this.notFlush?this.clientWidth:window.innerWidth;debug('get width',value);return value;},triggerAction:function(){if(this.action){this.els.actionButton.click();}},onActionButtonClick:function(){debug('action button click');var config={detail:{type:this.action}};var e=new CustomEvent('action',config);setTimeout(()=>this.dispatchEvent(e));},getTitleMarginStart:function(){var start=this.titleStart;var end=this.titleEnd;var marginStart=end-start;debug('get title margin start',marginStart);return marginStart;},getButtonsBeforeTitle:function(){var children=this.children;var l=children.length;var els=[];for(var i=0;i<l;i++){var el=children[i];if(el.tagName==='H1'){break;}
if(!contributesToLayout(el)){continue;}
els.push(el);}
if(this.action){els.push(this.els.actionButton);}
return els;},getButtonsAfterTitle:function(){var children=this.children;var els=[];for(var i=children.length-1;i>=0;i--){var el=children[i];if(el.tagName==='H1'){break;}
if(!contributesToLayout(el)){continue;}
els.push(el);}
return els;},sumButtonWidths:function(buttons){var defaultWidth=50;var sum=buttons.reduce((prev,button)=>{var isStandardButton=button===this.els.actionButton;var width=isStandardButton?defaultWidth:button.clientWidth;return prev+width;},0);debug('sum button widths',buttons,sum);return sum;},attrs:{action:{get:function(){return this._action;},set:function(value){var action=KNOWN_ACTIONS[value];if(action===this._action){return;}
this.setAttr('action',action);this._action=action;},},titleStart:{get:function(){debug('get title-start');if('_titleStart'in this){return this._titleStart;}
var buttons=this.getButtonsBeforeTitle();var value=this.sumButtonWidths(buttons);debug('get title-start',buttons,value);return value;},set:function(value){debug('set title-start',value);value=parseInt(value,10);if(value===this._titleStart||isNaN(value)){return;}
this.setAttr('title-start',value);this._titleStart=value;debug('set');}},titleEnd:{get:function(){debug('get title-end');if('_titleEnd'in this){return this._titleEnd;}
var buttons=this.getButtonsAfterTitle();return this.sumButtonWidths(buttons);},set:function(value){debug('set title-end',value);value=parseInt(value,10);if(value===this._titleEnd||isNaN(value)){return;}
this.setAttr('title-end',value);this._titleEnd=value;}},noFontFit:{get:function(){return this._noFontFit||false;},set:function(value){debug('set no-font-fit',value);value=!!(value||value==='');if(value===this.noFontFit){return;}
this._noFontFit=value;if(value){this.setAttr('no-font-fit','');}
else{this.removeAttr('no-font-fit');}}}},template:`<div class="inner">
    <button class="action-button">
      <content select=".l10n-action"></content>
    </button>
    <content></content>
  </div>

  <style>

  :host {
    display: block;
    -moz-user-select: none;

    --gaia-header-button-color:
      var(--header-button-color,
      var(--header-color,
      var(--link-color,
      inherit)));
  }

  /**
   * [hidden]
   */

  :host[hidden] {
    display: none;
  }

  /** Reset
   ---------------------------------------------------------*/

  ::-moz-focus-inner { border: 0; }

  /** Inner
   ---------------------------------------------------------*/

  .inner {
    display: flex;
    min-height: 50px;
    direction: ltr;
    -moz-user-select: none;

    background:
      var(--header-background,
      var(--background,
      #fff));
  }

  /** Action Button
   ---------------------------------------------------------*/

  /**
   * 1. Hidden by default
   */

  .action-button {
    position: relative;

    display: none; /* 1 */
    width: 50px;
    font-size: 30px;
    margin: 0;
    padding: 0;
    border: 0;
    outline: 0;

    align-items: center;
    background: none;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [action=back]
   * [action=menu]
   * [action=close]
   *
   * 1. For icon vertical-alignment
   */

  [action=back] .action-button,
  [action=menu] .action-button,
  [action=close] .action-button {
    display: flex; /* 1 */
  }

  /**
   * :active
   */

  .action-button:active {
    transition: none;
    opacity: 0.2;
  }

  /** Action Button Icon
   ---------------------------------------------------------*/

  .action-button:before {
    font-family: 'gaia-icons';
    font-style: normal;
    text-rendering: optimizeLegibility;
    font-weight: 500;
  }

  [action=close] .action-button:before { content: 'close' }
  [action=back] .action-button:before { content: 'back' }
  [action=menu] .action-button:before { content: 'menu' }

  /** Action Button Icon
   ---------------------------------------------------------*/

  /**
   * 1. To enable vertical alignment.
   */

  .action-button:before {
    display: block;
  }

  /** Action Button Text
   ---------------------------------------------------------*/

  /**
   * To provide custom localized content for
   * the action-button, we allow the user
   * to provide an element with the class
   * .l10n-action. This node is then
   * pulled inside the real action-button.
   *
   * Example:
   *
   *   <gaia-header action="back">
   *     <span class="l10n-action" aria-label="Back">Localized text</span>
   *     <h1>title</h1>
   *   </gaia-header>
   */

  ::content .l10n-action {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    font-size: 0;
  }

  /** Title
   ---------------------------------------------------------*/

  /**
   * 1. Vertically center text. We can't use flexbox
   *    here as it breaks text-overflow ellipsis
   *    without an inner div.
   */

  ::content h1 {
    flex: 1;
    margin: 0;
    padding: 0;
    overflow: hidden;

    white-space: nowrap;
    text-overflow: ellipsis;
    text-align: center;
    line-height: 50px; /* 1 */
    font-weight: 300;
    font-style: italic;
    font-size: 24px;

    color:
      var(--header-title-color,
      var(--header-color,
      var(--title-color,
      var(--text-color,
      inherit))));
  }

  /**
   * [dir=rtl]
   *
   * When the document is in RTL mode we still
   * want the <h1> text to be reversed to that
   * strings like '1 selected' become 'selected 1'.
   *
   * When we're happy for gaia-header to be fully
   * RTL responsive we won't need this rule anymore,
   * but this depends on all Gaia apps being ready.
   */

  :host-context([dir=rtl]) ::content h1 {
    direction: rtl;
  }

  /** Buttons
   ---------------------------------------------------------*/

  ::content a,
  ::content button {
    position: relative;
    z-index: 1;
    box-sizing: border-box;
    display: flex;
    width: auto;
    height: auto;
    min-width: 50px;
    margin: 0;
    padding: 0 10px;
    outline: 0;
    border: 0;

    font-size: 14px;
    line-height: 1;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    text-align: center;
    background: none;
    border-radius: 0;
    font-style: italic;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color: var(--gaia-header-button-color);
  }

  /**
   * :active
   */

  ::content a:active,
  ::content button:active {
    transition: none;
    opacity: 0.2;
  }

  /**
   * [hidden]
   */

  ::content a[hidden],
  ::content button[hidden] {
    display: none;
  }

  /**
   * [disabled]
   */

  ::content a[disabled],
  ::content button[disabled] {
    pointer-events: none;
    color: var(--header-disabled-button-color);
  }

  /** Icon Buttons
   ---------------------------------------------------------*/

  /**
   * Icons are a different color to text
   */

  ::content .icon,
  ::content [data-icon] {
    color:
      var(--header-icon-color,
      var(--gaia-header-button-color));
  }

  /**
   * If users want their action button
   * to be in the component's light-dom
   * they can add an .action class
   * to make it look like the
   * shadow action button.
   */

  ::content .action {
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [data-icon]:empty
   *
   * Icon buttons with no textContent,
   * should always be 50px.
   *
   * This is to prevent buttons being
   * larger than they should be before
   * icon-font has loaded.
   */

  ::content [data-icon]:empty {
    width: 50px;
  }

  </style>`,nextTick:nextTick});function contributesToLayout(el){return el.tagName!=='STYLE';}
function setStyleId(el,id){el._styleId=id;}
function getStyleId(el){return el._styleId;}
function nextTick(fn){var cleared;Promise.resolve().then(()=>{if(!cleared){fn();}});return{clear:function(){cleared=true;}};}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-header',this));},{"font-fit":1,"gaia-component":2,"gaia-icons":3}]},{},[4])(4)});;'use strict';var BlobView=(function(){function fail(msg){throw Error(msg);}
function BlobView(blob,sliceOffset,sliceLength,slice,viewOffset,viewLength,littleEndian)
{this.blob=blob;this.sliceOffset=sliceOffset;this.sliceLength=sliceLength;this.slice=slice;this.viewOffset=viewOffset;this.viewLength=viewLength;this.littleEndian=littleEndian;this.view=new DataView(slice,viewOffset,viewLength);this.buffer=slice;this.byteLength=viewLength;this.byteOffset=viewOffset;this.index=0;}
BlobView.get=function(blob,offset,length,callback,littleEndian){if(offset<0){fail('negative offset');}
if(length<0){fail('negative length');}
if(offset>blob.size){fail('offset larger than blob size');}
if(offset+length>blob.size){length=blob.size-offset;}
var slice=blob.slice(offset,offset+length);var reader=new FileReader();reader.readAsArrayBuffer(slice);reader.onloadend=function(){var result=null;if(reader.result){result=new BlobView(blob,offset,length,reader.result,0,length,littleEndian||false);}
callback(result,reader.error);};};BlobView.getFromArrayBuffer=function(buffer,offset,length,littleEndian){return new BlobView(null,offset,length,buffer,offset,length,littleEndian);};BlobView.prototype={constructor:BlobView,getMore:function(offset,length,callback){if(!this.blob)
fail('no blob backing this BlobView');if(offset>=this.sliceOffset&&offset+length<=this.sliceOffset+this.sliceLength){callback(new BlobView(this.blob,this.sliceOffset,this.sliceLength,this.slice,offset-this.sliceOffset,length,this.littleEndian));}
else{BlobView.get(this.blob,offset,length,callback,this.littleEndian);}},littleEndian:function(){this.littleEndian=true;},bigEndian:function(){this.littleEndian=false;},getUint8:function(offset){return this.view.getUint8(offset);},getInt8:function(offset){return this.view.getInt8(offset);},getUint16:function(offset,le){return this.view.getUint16(offset,le!==undefined?le:this.littleEndian);},getInt16:function(offset,le){return this.view.getInt16(offset,le!==undefined?le:this.littleEndian);},getUint32:function(offset,le){return this.view.getUint32(offset,le!==undefined?le:this.littleEndian);},getInt32:function(offset,le){return this.view.getInt32(offset,le!==undefined?le:this.littleEndian);},getFloat32:function(offset,le){return this.view.getFloat32(offset,le!==undefined?le:this.littleEndian);},getFloat64:function(offset,le){return this.view.getFloat64(offset,le!==undefined?le:this.littleEndian);},readByte:function(){return this.view.getInt8(this.index++);},readUnsignedByte:function(){return this.view.getUint8(this.index++);},readShort:function(le){var val=this.view.getInt16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readUnsignedShort:function(le){var val=this.view.getUint16(this.index,le!==undefined?le:this.littleEndian);this.index+=2;return val;},readInt:function(le){var val=this.view.getInt32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readUnsignedInt:function(le){var val=this.view.getUint32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readFloat:function(le){var val=this.view.getFloat32(this.index,le!==undefined?le:this.littleEndian);this.index+=4;return val;},readDouble:function(le){var val=this.view.getFloat64(this.index,le!==undefined?le:this.littleEndian);this.index+=8;return val;},tell:function(){return this.index;},remaining:function(){return this.byteLength-this.index;},seek:function(index){if(index<0){fail('negative index');}
if(index>this.byteLength){fail('index greater than buffer size');}
this.index=index;},advance:function(n){var index=this.index+n;if(index<0){fail('advance past beginning of buffer');}
if(index>this.byteLength){fail('advance past end of buffer');}
this.index=index;},getUnsignedByteArray:function(offset,n){return new Uint8Array(this.buffer,offset+this.viewOffset,n);},readUnsignedByteArray:function(n){var val=new Uint8Array(this.buffer,this.index+this.viewOffset,n);this.index+=n;return val;},getBit:function(offset,bit){var byte=this.view.getUint8(offset);return(byte&(1<<bit))!==0;},getUint24:function(offset,le){var b1,b2,b3;if(le!==undefined?le:this.littleEndian){b1=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b3=this.view.getUint8(offset+2);}
else{b3=this.view.getUint8(offset);b2=this.view.getUint8(offset+1);b1=this.view.getUint8(offset+2);}
return(b3<<16)+(b2<<8)+b1;},readUint24:function(le){var value=this.getUint24(this.index,le);this.index+=3;return value;},getASCIIText:function(offset,len){var bytes=new Uint8Array(this.buffer,offset+this.viewOffset,len);return String.fromCharCode.apply(String,bytes);},readASCIIText:function(len){var bytes=new Uint8Array(this.buffer,this.index+this.viewOffset,len);this.index+=len;return String.fromCharCode.apply(String,bytes);},getUTF8Text:function(offset,len){function fail(){throw new Error('Illegal UTF-8');}
var pos=offset;var end=offset+len;var charcode;var s='';var b1,b2,b3,b4;while(pos<end){var b1=this.view.getUint8(pos);if(b1<128){s+=String.fromCharCode(b1);pos+=1;}
else if(b1<194){fail();}
else if(b1<224){if(pos+1>=end){fail();}
b2=this.view.getUint8(pos+1);if(b2<128||b2>191){fail();}
charcode=((b1&0x1f)<<6)+(b2&0x3f);s+=String.fromCharCode(charcode);pos+=2;}
else if(b1<240){if(pos+2>=end){fail();}
b2=this.view.getUint8(pos+1);if(b2<128||b2>191){fail();}
b3=this.view.getUint8(pos+2);if(b3<128||b3>191){fail();}
charcode=((b1&0x0f)<<12)+((b2&0x3f)<<6)+(b3&0x3f);s+=String.fromCharCode(charcode);pos+=3;}
else if(b1<245){if(pos+3>=end){fail();}
b2=this.view.getUint8(pos+1);if(b2<128||b2>191){fail();}
b3=this.view.getUint8(pos+2);if(b3<128||b3>191){fail();}
b4=this.view.getUint8(pos+3);if(b4<128||b4>191){fail();}
charcode=((b1&0x07)<<18)+
((b2&0x3f)<<12)+
((b3&0x3f)<<6)+
(b4&0x3f);charcode-=0x10000;s+=String.fromCharCode(0xd800+((charcode&0x0FFC00)>>>10));s+=String.fromCharCode(0xdc00+(charcode&0x0003FF));pos+=4;}
else{fail();}}
return s;},readUTF8Text:function(len){try{return this.getUTF8Text(this.index,len);}
finally{this.index+=len;}},getUTF16Text:function(offset,len,le){if(len%2){fail('len must be a multiple of two');}
if(le===null||le===undefined){var BOM=this.getUint16(offset);len-=2;offset+=2;if(BOM===0xFEFF)
le=false;else
le=true;}
var s='';for(var i=0;i<len;i+=2)
s+=String.fromCharCode(this.getUint16(offset+i,le));return s;},readUTF16Text:function(len,le){var value=this.getUTF16Text(this.index,len,le);this.index+=len;return value;},getID3Uint28BE:function(offset){var b1=this.view.getUint8(offset)&0x7f;var b2=this.view.getUint8(offset+1)&0x7f;var b3=this.view.getUint8(offset+2)&0x7f;var b4=this.view.getUint8(offset+3)&0x7f;return(b1<<21)|(b2<<14)|(b3<<7)|b4;},readID3Uint28BE:function(){var value=this.getID3Uint28BE(this.index);this.index+=4;return value;},readNullTerminatedLatin1Text:function(size){var s='';for(var i=0;i<size;i++){var charcode=this.view.getUint8(this.index+i);if(charcode===0){i++;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;},readNullTerminatedUTF8Text:function(size){for(var len=0;len<size;len++){if(this.view.getUint8(this.index+len)===0){break;}}
var s=this.readUTF8Text(len);if(len<size){this.advance(1);}
return s;},readNullTerminatedUTF16Text:function(size,le){if(size%2){fail('size must be a multiple of two');}
if(le===null||le===undefined){var BOM=this.readUnsignedShort();size-=2;if(BOM===0xFEFF){le=false;}else{le=true;}}
var s='';for(var i=0;i<size;i+=2){var charcode=this.getUint16(this.index+i,le);if(charcode===0){i+=2;break;}
s+=String.fromCharCode(charcode);}
this.index+=i;return s;}};return{get:BlobView.get,getFromArrayBuffer:BlobView.getFromArrayBuffer};}());'use strict';var MetadataFormats=(function(){var formats=[{file:'js/metadata/forward_lock.js',get module(){return ForwardLockMetadata;},match:function(header){return header.getASCIIText(0,9)==='LOCKED 1 ';}},{file:'js/metadata/id3v2.js',get module(){return ID3v2Metadata;},match:function(header){return header.getASCIIText(0,3)==='ID3';}},{file:'js/metadata/ogg.js',get module(){return OggMetadata;},match:function(header){return header.getASCIIText(0,4)==='OggS';}},{file:'js/metadata/flac.js',get module(){return FLACMetadata;},match:function(header){return header.getASCIIText(0,4)==='fLaC';}},{file:'js/metadata/mp4.js',get module(){return MP4Metadata;},match:function(header){return header.getASCIIText(4,4)==='ftyp';}},{file:'js/metadata/id3v1.js',get module(){return ID3v1Metadata;},match:function(header){return(header.getUint16(0,false)&0xFFFE)===0xFFFA;}}];function MetadataParser(formatInfo){this._formatInfo=formatInfo;}
MetadataParser.prototype={parse:function(header,metadata){var info=this._formatInfo;return new Promise(function(resolve,reject){LazyLoader.load(info.file,function(){resolve(info.module.parse(header,metadata));});});}};function findParser(header){for(var i=0;i<formats.length;i++){if(formats[i].match(header)){return new MetadataParser(formats[i]);}}
return null;}
return{findParser:findParser};})();'use strict';var AudioMetadata=(function(){var pictureStorage=navigator.getDeviceStorage('pictures');var externalCoverCache={};var savedCoverCache=new Set();function parse(blob){var filename=blob.name;if(filename){if(filename.slice(0,5)==='DCIM/'&&filename.slice(-4).toLowerCase()==='.3gp'){return Promise.reject('skipping 3gp video file');}}
if(blob.size<128){return Promise.reject('file is empty or too small');}
var metadata={};metadata.artist=metadata.album=metadata.title='';metadata.rated=metadata.played=0;if(filename){var p1=filename.lastIndexOf('/');var p2=filename.lastIndexOf('.');if(p2<=p1){p2=filename.length;}
metadata.title=filename.substring(p1+1,p2);}
return new Promise(function(resolve,reject){var headersize=Math.min(64*1024,blob.size);BlobView.get(blob,0,headersize,function(header,error){if(error){reject(error);return;}
try{var parser=MetadataFormats.findParser(header);if(parser){resolve(parser.parse(header,metadata).then(function(metadata){return handleCoverArt(blob,metadata);}));}else{resolve(checkPlayability(blob).then(function(){return metadata;}));}}catch(e){console.error('AudioMetadata.parse:',e,e.stack);reject(e);}});});}
function checkPlayability(blob){var player=new Audio();player.mozAudioChannelType='content';var canplay=blob.type&&player.canPlayType(blob.type);if(canplay==='probably'){return Promise.resolve();}else{return new Promise(function(resolve,reject){var url=URL.createObjectURL(blob);player.src=url;player.onerror=function(){URL.revokeObjectURL(url);player.removeAttribute('src');player.load();reject('Unplayable music file');};player.oncanplay=function(){URL.revokeObjectURL(url);player.removeAttribute('src');player.load();resolve();};});}}
function handleCoverArt(blob,metadata){var filename=blob.name;if(!filename){return Promise.resolve(metadata);}
if(!metadata.picture){var lastSlash=filename.lastIndexOf('/');var dirName=filename.substring(0,lastSlash+1);if(dirName in externalCoverCache){metadata.picture=externalCoverCache[dirName];return Promise.resolve(metadata);}
return new Promise(function(resolve,reject){var possibleFilenames=['folder.jpg','cover.jpg','front.jpg'];var tryFetchExternalCover=function(index){if(index===possibleFilenames.length){externalCoverCache[dirName]=null;resolve(metadata);return;}
var externalCoverFilename=dirName+possibleFilenames[index];var getcoverrequest=pictureStorage.get(externalCoverFilename);getcoverrequest.onsuccess=function(){metadata.picture={flavor:'external',filename:externalCoverFilename};externalCoverCache[dirName]=metadata.picture;resolve(metadata);};getcoverrequest.onerror=function(){tryFetchExternalCover(index+1);};};tryFetchExternalCover(0);});}else if(metadata.picture.blob){var albumKey;if(metadata.artist||metadata.album){var artist=(metadata.artist||'').substr(0,64);var album=(metadata.album||'').substr(0,64);albumKey=artist+'.'+album;}else{albumKey=filename.substr(-128);}
var coverBlob=metadata.picture.blob;delete metadata.picture.blob;var extension=coverBlob.type==='image/jpeg'?'.jpg':'.png';var imageFilename=vfatEscape(albumKey)+'.'+coverBlob.size+
extension;var storageName=getStorageName(filename);return checkSaveCover(coverBlob,imageFilename,storageName).then(function(savedFile){metadata.picture.filename=savedFile;return metadata;},function(err){delete metadata.picture;return metadata;});}else{return Promise.resolve(metadata);}}
function vfatEscape(str){return str.replace(/["*\/:<>?\|]/g,'_');}
function getStorageName(filename){if(filename[0]==='/'){var slashIndex=filename.indexOf('/',1);if(slashIndex<0){var err=Error('handleCoverArt: Bad filename: "'+filename+'"');console.error(err);return Promise.reject(err);}
return filename.substring(0,slashIndex+1);}
return'';}
function checkSaveCover(coverBlob,imageFilename,storageName){var imageAbsPath=storageName+'.music/covers/'+imageFilename;if(savedCoverCache.has(imageAbsPath)){return Promise.resolve(imageAbsPath);}
return new Promise(function(resolve,reject){var getrequest=pictureStorage.get(imageAbsPath);getrequest.onsuccess=function(){savedCoverCache.add(imageAbsPath);resolve(imageAbsPath);};getrequest.onerror=function(){var saverequest=pictureStorage.addNamed(coverBlob,imageAbsPath);saverequest.onerror=function(){console.error('Could not save cover image',imageFilename);};savedCoverCache.add(imageAbsPath);resolve(imageAbsPath);};});}
return{parse:parse,pictureStorage:pictureStorage};})();;'use strict';var AlbumArt=(function(){var THUMBNAIL_WIDTH=300;var THUMBNAIL_HEIGHT=300;var L1Cache={};function getCoverURL(fileinfo,noPlaceholder){if(!fileinfo.metadata.picture){return Promise.resolve(noPlaceholder?null:getDefaultCoverURL(fileinfo));}
var cacheKey=makeCacheKey(fileinfo);if(cacheKey&&cacheKey in L1Cache){return Promise.resolve(L1Cache[cacheKey]);}
return checkL2Cache(cacheKey).then(function(cachedBlob){return cachedBlob||createThumbnail(cacheKey,fileinfo);}).then(function(blob){return makeURL(cacheKey,blob);});}
function getCoverBlob(fileinfo,noPlaceholder){if(!fileinfo.metadata.picture){if(noPlaceholder){return Promise.resolve(null);}
return getBlobFromURL(getDefaultCoverURL(fileinfo));}
var cacheKey=makeCacheKey(fileinfo);return checkL2Cache(cacheKey).then(function(cachedBlob){return cachedBlob||createThumbnail(cacheKey,fileinfo);});}
function getDefaultCoverURL(fileinfo){var metadata=fileinfo.metadata;var infoForHash=(!metadata.album&&!metadata.artist)?metadata.title:metadata.album+metadata.artist;var hashedNumber=(Math.abs(hash(infoForHash))%10)+1;return'/style/images/AlbumArt'+hashedNumber+'_small.png';}
function hash(str){var hashCode=0;if(str.length===0){return hashCode;}
for(var i=0;i<str.length;i++){var c=str.charCodeAt(i);hashCode=((hashCode<<5)-hashCode)+c;hashCode=hashCode&hashCode;}
return hashCode;}
function makeCacheKey(fileinfo){var metadata=fileinfo.metadata;if(metadata.picture.filename){return'external.'+metadata.picture.filename;}else if(metadata.picture.flavor==='embedded'){var album=metadata.album;var artist=metadata.artist;var size=metadata.picture.end-metadata.picture.start;if(album||artist){return'thumbnail.'+album+'.'+artist+'.'+size;}else{return'thumbnail.'+(fileinfo.name||fileinfo.blob.name);}}
return null;}
function checkL2Cache(cacheKey){if(!cacheKey){return Promise.resolve(null);}else{return new Promise(function(resolve,reject){asyncStorage.getItem(cacheKey,function(blob){resolve(blob);});});}}
function makeURL(cacheKey,blob){var url=URL.createObjectURL(blob);if(cacheKey){L1Cache[cacheKey]=url;}
return url;}
function createThumbnail(cacheKey,fileinfo){return getAlbumArtBlob(fileinfo).then(function(blob){return ImageUtils.resizeAndCropToCover(blob,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT);}).then(function(thumbnailBlob){if(cacheKey){asyncStorage.setItem(cacheKey,thumbnailBlob);}
return thumbnailBlob;});}
function getAlbumArtBlob(fileinfo){var picture=fileinfo.metadata.picture;return new Promise(function(resolve,reject){if(picture.blob){resolve(picture.blob);}else if(picture.filename){var getreq=AudioMetadata.pictureStorage.get(picture.filename);getreq.onsuccess=function(){resolve(this.result);};getreq.onerror=function(){reject(this.error);};}else if(picture.start){getSongBlob(fileinfo).then(function(blob){var embedded=blob.slice(picture.start,picture.end,picture.type);resolve(embedded);}).catch(reject);}else{var err=new Error('unknown picture flavor: '+picture.flavor);console.error(err);reject(err);}});}
function getSongBlob(fileinfo){return new Promise(function(resolve,reject){if(fileinfo.blob){resolve(fileinfo.blob);}else{musicdb.getFile(fileinfo.name,function(file){if(file){resolve(file);}else{reject('unable to get file: '+fileinfo.name);}});}});}
function getBlobFromURL(url){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.responseType='blob';xhr.onload=function(){resolve(xhr.response);};xhr.onerror=function(){reject(null);};xhr.send();});}
return{getCoverURL:getCoverURL,getCoverBlob:getCoverBlob};})();;'use strict';function formatTime(secs){if(isNaN(secs)){return;}
secs=Math.floor(secs);var formatedTime;var seconds=secs%60;var minutes=Math.floor(secs/60)%60;var hours=Math.floor(secs/3600);if(hours===0){formatedTime=(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}else{formatedTime=(hours<10?'0'+hours:hours)+':'+
(minutes<10?'0'+minutes:minutes)+':'+
(seconds<10?'0'+seconds:seconds);}
return formatedTime;}
function createListElement(option,data,index,highlight){var li=document.createElement('li');li.className='list-item';li.setAttribute('role','presentation');var a=document.createElement('a');a.dataset.index=index;a.dataset.option=option;a.setAttribute('role','option');var titleBdi;li.appendChild(a);function highlightText(result,text){var textContent=result.textContent;var textLowerCased=textContent.toLocaleLowerCase();var index=Normalizer.toAscii(textLowerCased).indexOf(text);if(index>=0){var innerHTML=textContent.substring(0,index)+'<span class="search-highlight">'+
textContent.substring(index,index+text.length)+'</span>'+
textContent.substring(index+text.length);result.innerHTML=innerHTML;}}
switch(option){case'playlist':titleBdi=document.createElement('bdi');titleBdi.className='list-playlist-title';if(data.metadata.l10nId){titleBdi.textContent=navigator.mozL10n.get(data.metadata.l10nId);titleBdi.dataset.l10nId=data.metadata.l10nId;}else{titleBdi.textContent=data.metadata.title||navigator.mozL10n.get('unknownTitle');titleBdi.dataset.l10nId=data.metadata.title?'':'unknownTitle';}
a.dataset.keyRange='all';a.dataset.option=data.option;a.appendChild(titleBdi);if(index===0){var shuffleIcon=document.createElement('div');shuffleIcon.className='list-playlist-icon';shuffleIcon.dataset.icon='shuffle';a.appendChild(shuffleIcon);}
break;case'artist':case'album':case'title':var artistBdi;var albumImg;albumImg=document.createElement('img');albumImg.className='list-album-art';li.appendChild(albumImg);AlbumArt.getCoverURL(data).then(function(url){showImage(albumImg,url);});if(option==='artist'){artistBdi=document.createElement('bdi');artistBdi.className='list-single-title';artistBdi.textContent=data.metadata.artist||navigator.mozL10n.get('unknownArtist');artistBdi.dataset.l10nId=data.metadata.artist?'':'unknownArtist';if(highlight){highlightText(artistBdi,highlight);}
a.appendChild(artistBdi);}else{var albumOrTitleBdi=document.createElement('bdi');artistBdi=document.createElement('bdi');albumOrTitleBdi.className='list-main-title';artistBdi.className='list-sub-title';if(option==='album'){albumOrTitleBdi.textContent=data.metadata.album||navigator.mozL10n.get('unknownAlbum');albumOrTitleBdi.dataset.l10nId=data.metadata.album?'':'unknownAlbum';}else{albumOrTitleBdi.textContent=data.metadata.title||navigator.mozL10n.get('unknownTitle');albumOrTitleBdi.dataset.l10nId=data.metadata.title?'':'unknownTitle';}
artistBdi.textContent=data.metadata.artist||navigator.mozL10n.get('unknownArtist');artistBdi.dataset.l10nId=data.metadata.artist?'':'unknownArtist';if(highlight){highlightText(albumOrTitleBdi,highlight);}
a.appendChild(albumOrTitleBdi);a.appendChild(artistBdi);}
a.dataset.keyRange=data.metadata[option];a.dataset.option=option;break;case'song':case'song-index':var songTitle=data.metadata.title||navigator.mozL10n.get('unknownTitle');var indexBdi=document.createElement('bdi');indexBdi.className='list-song-index';if(option==='song-index'){indexBdi.textContent=index+1;}else{var trackNum=data.metadata.tracknum;if(data.metadata.discnum&&data.multidisc){trackNum=data.metadata.discnum+'.'+
(trackNum<10?'0'+trackNum:trackNum);}
indexBdi.textContent=trackNum;}
titleBdi=document.createElement('bdi');titleBdi.className='list-song-title';titleBdi.textContent=songTitle;titleBdi.dataset.l10nId=data.metadata.title?'':'unknownTitle';var lengthBdi=document.createElement('bdi');lengthBdi.className='list-song-length';a.appendChild(indexBdi);a.appendChild(titleBdi);a.appendChild(lengthBdi);break;}
return li;}
function showImage(image,url,option){image.classList.remove(option);image.src='';if(option==='fadeIn'){image.style.opacity=0;}
image.addEventListener('load',handler);function handler(evt){evt.target.removeEventListener('load',handler);image.classList.add(option);}
image.src=url;};'use strict';var TYPE_MIX='mix';var TYPE_LIST='list';var TYPE_SINGLE='single';var TYPE_BLOB='blob';var REPEAT_OFF=0;var REPEAT_LIST=1;var REPEAT_SONG=2;var PLAYSTATUS_STOPPED='STOPPED';var PLAYSTATUS_PLAYING='PLAYING';var PLAYSTATUS_PAUSED='PAUSED';var PLAYSTATUS_FWD_SEEK='FWD_SEEK';var PLAYSTATUS_REV_SEEK='REV_SEEK';var INTERRUPT_BEGIN='mozinterruptbegin';var PlayerView={get view(){return document.getElementById('views-player');},get audio(){return document.getElementById('player-audio');},get playStatus(){return this._playStatus;},set playStatus(val){this._playStatus=val;},get dataSource(){return this._dataSource;},set dataSource(source){this._dataSource=source;if(this.sourceType){if(this.sourceType===TYPE_MIX||this.sourceType===TYPE_LIST){this.shuffleButton.disabled=(this._dataSource.length<2);TitleBar.playerIcon.hidden=(this._dataSource.length<1);}else{this.shuffleButton.disabled=true;this.repeatButton.disabled=true;this.previousControl.disabled=true;this.nextControl.disabled=true;}}},init:function pv_init(){this.artist=document.getElementById('player-cover-artist');this.album=document.getElementById('player-cover-album');this.artistText=document.querySelector('#player-cover-artist bdi');this.albumText=document.querySelector('#player-cover-album bdi');this.timeoutID;this.cover=document.getElementById('player-cover');this.coverImage=document.getElementById('player-cover-image');this.offscreenImage=new Image();this.shareButton=document.getElementById('player-cover-share');this.repeatButton=document.getElementById('player-album-repeat');this.shuffleButton=document.getElementById('player-album-shuffle');this.ratings=document.getElementById('player-album-rating').children;this.seekRegion=document.getElementById('player-seek-bar');this.seekBar=document.getElementById('player-seek-bar-progress');this.seekIndicator=document.getElementById('player-seek-bar-indicator');this.seekElapsed=document.getElementById('player-seek-elapsed');this.seekRemaining=document.getElementById('player-seek-remaining');this.playControl=document.getElementById('player-controls-play');this.previousControl=document.getElementById('player-controls-previous');this.nextControl=document.getElementById('player-controls-next');this.banner=document.getElementById('info-banner');this.isTouching=false;this.isFastSeeking=false;this.playStatus=PLAYSTATUS_STOPPED;this.pausedPosition=null;this.handle=null;this.dataSource=[];this.playingBlob=null;this.currentIndex=0;this.setSeekBar(0,0,0);this.intervalID=null;this.view.addEventListener('click',this);this.view.addEventListener('contextmenu',this);this.seekRegion.addEventListener('touchstart',this);this.seekRegion.addEventListener('touchmove',this);this.seekRegion.addEventListener('touchend',this);this.previousControl.addEventListener('touchend',this);this.nextControl.addEventListener('touchend',this);this.audio.addEventListener('play',this);this.audio.addEventListener('pause',this);this.audio.addEventListener('playing',this);this.audio.addEventListener('durationchange',this);this.audio.addEventListener('timeupdate',this);this.audio.addEventListener('ended',this);this.audio.addEventListener('mozinterruptbegin',this);this.audio.addEventListener('mozinterruptend',this);window.addEventListener('visibilitychange',this);window.addEventListener('storage',this._handleInterpageMessage.bind(this));this.endedTimer=null;navigator.mozL10n.ready(this.updateL10n.bind(this));},checkSCOStatus:function pv_checkSCOStatus(){if(typeof MusicComms!=='undefined'&&MusicComms.enabled){var SCOStatus=MusicComms.isSCOEnabled;this.playControl.disabled=this.previousControl.disabled=this.nextControl.disabled=SCOStatus;this.seekRegion.parentNode.classList.toggle('disabled',SCOStatus);this.banner.classList.toggle('visible',SCOStatus);}},clean:function pv_clean(){if(this.handle){musicdb.cancelEnumeration(this.handle);}
this.dataSource=[];this.playingBlob=null;},setSourceType:function pv_setSourceType(type){this.sourceType=type;},setDBInfo:function pv_setDBInfo(info){this.DBInfo=info;this.dataSource.length=info.count;},showInfo:function pv_showInfo(){this.cover.classList.add('slideOut');if(this.timeoutID){window.clearTimeout(this.timeoutID);}
this.timeoutID=window.setTimeout(function pv_hideInfo(){this.cover.classList.remove('slideOut');}.bind(this),5000);},setInfo:function pv_setInfo(fileinfo){var metadata=fileinfo.metadata;if(typeof ModeManager!=='undefined'){ModeManager.playerTitle=metadata.title;ModeManager.updateTitle();if(metadata.locked||App.pendingPick){this.shareButton.classList.add('hidden');this.artist.classList.add('hidden-cover-share');this.album.classList.add('hidden-cover-share');}else{this.shareButton.classList.remove('hidden');this.artist.classList.remove('hidden-cover-share');this.album.classList.remove('hidden-cover-share');}}else{var titleBar=document.querySelector('#title-text bdi');titleBar.textContent=metadata.title||navigator.mozL10n.get('unknownTitle');titleBar.dataset.l10nId=metadata.title?'':'unknownTitle';}
this.artistText.textContent=metadata.artist||navigator.mozL10n.get('unknownArtist');this.artistText.dataset.l10nId=metadata.artist?'':'unknownArtist';this.albumText.textContent=metadata.album||navigator.mozL10n.get('unknownAlbum');this.albumText.dataset.l10nId=metadata.album?'':'unknownAlbum';this.setCoverImage(fileinfo);},setCoverImage:function pv_setCoverImage(fileinfo){this.offscreenImage.src='';this.coverImage.classList.remove('fadeIn');AlbumArt.getCoverURL(fileinfo).then(function(url){this.offscreenImage.addEventListener('load',pv_showImage.bind(this));this.offscreenImage.src=url;}.bind(this));function pv_showImage(evt){evt.target.removeEventListener('load',pv_showImage);var url='url('+this.offscreenImage.src+')';this.coverImage.style.backgroundImage=url;this.coverImage.classList.add('fadeIn');}},setOptions:function pv_setOptions(settings){var repeatOption=(settings&&settings.repeat)?settings.repeat:REPEAT_OFF;var shuffleOption=(settings&&settings.shuffle)?settings.shuffle:false;this.setRepeat(repeatOption);this.setShuffle(shuffleOption);},setRepeat:function pv_setRepeat(value){var repeatModes=['repeat-off','repeat-list','repeat-song'];repeatModes.forEach(function pv_resetRepeat(targetClass){this.repeatButton.classList.remove(targetClass);}.bind(this));this.repeatOption=value;this.repeatButton.classList.add(repeatModes[this.repeatOption]);this.repeatButton.setAttribute('data-l10n-id',repeatModes[this.repeatOption]);},setShuffle:function pv_setShuffle(value,index){this.shuffleOption=value;if(this.shuffleOption){this.shuffleButton.classList.add('shuffle-on');if(arguments.length>1){this.shuffleList(this.currentIndex);}else{this.shuffleList();}}else{this.shuffleButton.classList.remove('shuffle-on');}
this.shuffleButton.setAttribute('aria-pressed',this.shuffleOption);},setRatings:function pv_setRatings(rated){for(var i=0;i<5;i++){var rating=this.ratings[i];if(i===rated-1){rating.setAttribute('aria-checked',true);}else{rating.setAttribute('aria-checked',false);}
if(i<rated){rating.classList.add('star-on');}else{rating.classList.remove('star-on');}}},shuffleList:function slv_shuffleList(index){if(this.dataSource.length===0){return;}
this.shuffleIndex=0;this.shuffledList=[];for(var i=0;i<this.dataSource.length;i++){this.shuffledList.push(i);}
if(arguments.length>0){var currentItem=this.shuffledList.splice(index,1);slv_shuffle(this.shuffledList);this.shuffledList=currentItem.concat(this.shuffledList);}else{slv_shuffle(this.shuffledList);}
function slv_shuffle(a){for(var i=a.length-1;i>=1;i--){var j=Math.floor(Math.random()*(i+1));if(j<i){var tmp=a[j];a[j]=a[i];a[i]=tmp;}}}},getMetadata:function pv_getMetadata(blob,callback){AudioMetadata.parse(blob).then(pv_gotMetadata,pv_metadataError.bind(this));function pv_gotMetadata(metadata){callback(metadata);}
function pv_metadataError(e){console.warn('parseAudioMetadata: error parsing metadata - ',e);if(this.onerror){this.onerror(e);}}},setAudioSrc:function pv_setAudioSrc(file){var url=URL.createObjectURL(file);this.playingBlob=file;this.audio.removeAttribute('src');this.audio.load();this.audio.mozAudioChannelType='content';this.audio.src=url;this.audio.load();this.audio.play();this.audio.onloadeddata=function(evt){URL.revokeObjectURL(url);};this.audio.onerror=(function(evt){if(this.onerror){this.onerror(evt);}}).bind(this);this.setSeekBar(0,0,0);if(this.endedTimer){clearTimeout(this.endedTimer);this.endedTimer=null;}},updateRemoteMetadata:function pv_updateRemoteMetadata(){if(typeof MusicComms==='undefined'||this.dataSource.length===0){return;}
var fileinfo=this.dataSource[this.currentIndex];var metadata=fileinfo.metadata;var notifyMetadata={title:metadata.title||navigator.mozL10n.get('unknownTitle'),artist:metadata.artist||navigator.mozL10n.get('unknownArtist'),album:metadata.album||navigator.mozL10n.get('unknownAlbum'),duration:this.audio.duration*1000,mediaNumber:this.currentIndex+1,totalMediaCount:this.dataSource.length};if(this.audio.currentTime===0){AlbumArt.getCoverBlob(fileinfo).then(function(blob){notifyMetadata.picture=blob;MusicComms.notifyMetadataChanged(notifyMetadata);});}
else{MusicComms.notifyMetadataChanged(notifyMetadata);}},updateRemotePlayStatus:function pv_updateRemotePlayStatus(){if(typeof MusicComms==='undefined'){return;}
var position=this.pausedPosition?this.pausedPosition:this.audio.currentTime;var info={playStatus:this.playStatus,duration:this.audio.duration*1000,position:position*1000};this.pausedPosition=(this.playStatus===PLAYSTATUS_PLAYING)?null:this.audio.currentTime;MusicComms.notifyStatusChanged(info);},getSongData:function pv_getSongData(index,callback){var info=this.DBInfo;var songData=this.dataSource[index];if(songData){callback(songData);}else{ListView.cancelEnumeration();var handle=musicdb.advancedEnumerate(info.key,info.range,info.direction,index,function(record){musicdb.cancelEnumeration(handle);this.dataSource[index]=record;callback(record);}.bind(this));}},getFile:function pv_getFile(songData,callback){if(!songData.metadata.locked){musicdb.getFile(songData.name,callback);return;}
musicdb.getFile(songData.name,function(locked){ForwardLock.getKey(function(secret){ForwardLock.unlockBlob(secret,locked,function(unlocked){callback(unlocked);},null,function(msg){console.error(msg);callback(null);});});});},PLAYER_IS_OCCUPIED_BY:'music-player-is-occupied-by',_handleInterpageMessage:function(evt){if(evt.key===this.PLAYER_IS_OCCUPIED_BY){if(evt.newValue&&evt.newValue!==location.href){this.pause();}}},_sendInterpageMessage:function(){window.localStorage.setItem(this.PLAYER_IS_OCCUPIED_BY,location.href);},_clearInterpageMessage:function(){var whoIsPlaying=window.localStorage.getItem(this.PLAYER_IS_OCCUPIED_BY);if(whoIsPlaying&&whoIsPlaying===window.location.href){window.localStorage.removeItem(this.PLAYER_IS_OCCUPIED_BY);}},play:function pv_play(targetIndex){this.checkSCOStatus();this._sendInterpageMessage();this.showInfo();if(arguments.length>0){this.getSongData(targetIndex,function(songData){this.currentIndex=targetIndex;this.setInfo(songData);this.setRatings(songData.metadata.rated);songData.metadata.played++;musicdb.updateMetadata(songData.name,songData.metadata);this.getFile(songData,function(file){this.setAudioSrc(file);if(this.sourceType===TYPE_SINGLE||MusicComms.isSCOEnabled){this.pause();}}.bind(this));}.bind(this));}else if(this.sourceType===TYPE_BLOB&&!this.audio.src){this.getMetadata(this.dataSource,function(metadata){this.setInfo({metadata:metadata,name:this.dataSource.name,blob:this.dataSource});this.setAudioSrc(this.dataSource);}.bind(this));}else{this.audio.play();}},pause:function pv_pause(){this.checkSCOStatus();this._clearInterpageMessage();this.audio.pause();},stop:function pv_stop(){this.pause();this.audio.removeAttribute('src');this.audio.load();this.clean();if(typeof ModeManager!=='undefined'){ModeManager.playerTitle=null;if(ModeManager.currentMode===MODE_PLAYER){ModeManager.pop();}else{ModeManager.updateTitle();}}
this.playStatus=PLAYSTATUS_STOPPED;this.updateRemotePlayStatus();},next:function pv_next(isAutomatic){if(this.sourceType===TYPE_BLOB||this.sourceType===TYPE_SINGLE){this.setAudioSrc(this.playingBlob);this.pause();return;}
if(this.repeatOption===REPEAT_SONG&&isAutomatic){this.play(this.currentIndex);return;}
var playingIndex=(this.shuffleOption)?this.shuffleIndex:this.currentIndex;if(playingIndex>=this.dataSource.length-1){if(this.repeatOption===REPEAT_LIST){if(this.shuffleOption){this.shuffleList(this.shuffledList[0]);}else{this.currentIndex=0;}}else{this.stop();return;}}else{if(this.shuffleOption){this.shuffleIndex++;}else{this.currentIndex++;}}
var realIndex=(this.shuffleOption)?this.shuffledList[this.shuffleIndex]:this.currentIndex;this.play(realIndex);},previous:function pv_previous(){if(this.audio.currentTime>3){this.play(this.currentIndex);return;}
var playingIndex=(this.shuffleOption)?this.shuffleIndex:this.currentIndex;if(playingIndex<=0){var newIndex=(this.repeatOption===REPEAT_LIST)?this.dataSource.length-1:0;if(this.shuffleOption){this.shuffleIndex=newIndex;}else{this.currentIndex=newIndex;}}else{if(this.shuffleOption){this.shuffleIndex--;}else{this.currentIndex--;}}
var realIndex=(this.shuffleOption)?this.shuffledList[this.shuffleIndex]:this.currentIndex;this.play(realIndex);},startFastSeeking:function pv_startFastSeeking(direction){this.isTouching=this.isFastSeeking=true;var offset=direction*2;this.prevPlayStatus=this.playStatus;this.playStatus=direction?PLAYSTATUS_FWD_SEEK:PLAYSTATUS_REV_SEEK;this.updateRemotePlayStatus();this.intervalID=window.setInterval(function(){this.seekAudio(this.audio.currentTime+offset);}.bind(this),15);},stopFastSeeking:function pv_stopFastSeeking(){this.isTouching=this.isFastSeeking=false;if(this.intervalID){window.clearInterval(this.intervalID);}
this.playStatus=this.prevPlayStatus;this.prevPlayStatus=null;this.updateRemotePlayStatus();},updateSeekBar:function pv_updateSeekBar(){if(this.isTouching){return;}
if(typeof ModeManager==='undefined'||ModeManager.currentMode===MODE_PLAYER){this.seekAudio();}},seekAudio:function pv_seekAudio(seekTime){if(seekTime!==undefined){this.audio.currentTime=Math.floor(seekTime);}
var startTime=this.audio.startTime;var endTime;if(isNaN(this.audio.duration)){endTime=0;}else if(this.audio.duration===Infinity){endTime=(this.audio.buffered.length>0)?this.audio.buffered.end(this.audio.buffered.length-1):0;}else{endTime=this.audio.duration;}
var currentTime=this.audio.currentTime;this.setSeekBar(startTime,endTime,currentTime);},setSeekBar:function pv_setSeekBar(startTime,endTime,currentTime){this.seekBar.min=startTime;this.seekBar.max=endTime;this.seekBar.value=currentTime;var ratio=(endTime!==0)?(currentTime/endTime):0;var x=(ratio*this.seekBar.offsetWidth-
this.seekIndicator.offsetWidth/2);if(this.isLTR){x=x+'px';}else{if(x<0){x=Math.abs(x)+'px';}else{x='-'+x+'px';}}
this.seekIndicator.style.transform='translateX('+x+')';this.seekElapsed.textContent=formatTime(currentTime);var remainingTime=endTime-currentTime;this.seekRemaining.textContent=(remainingTime>0)?'-'+formatTime(remainingTime):'---:--';},share:function pv_shareFile(){var songData=this.dataSource[this.currentIndex];if(songData.metadata.locked){return;}
musicdb.getFile(songData.name,function(file){AlbumArt.getCoverBlob(songData).then(function(pictureBlob){var filename=songData.name,name=filename.substring(filename.lastIndexOf('/')+1);var activityData={type:'audio/*',number:1,blobs:[file],filenames:[name],filepaths:[filename],metadata:[{title:songData.metadata.title,artist:songData.metadata.artist,album:songData.metadata.album,picture:pictureBlob}]};if(PlayerView.playStatus!==PLAYSTATUS_PLAYING){var a=new MozActivity({name:'share',data:activityData});a.onerror=function(e){console.warn('share activity error:',a.error.name);};}
else{(function(){var hack_activity_property='_hack_hack_shut_up';var hack_setting_property='music._hack.pause_please';navigator.mozSettings.addObserver(hack_setting_property,observer);activityData[hack_activity_property]=hack_setting_property;var a=new MozActivity({name:'share',data:activityData});a.onerror=a.onsuccess=cleanup;function observer(e){PlayerView.pause();}
function cleanup(){navigator.mozSettings.removeObserver(hack_setting_property,observer);if(PlayerView.playStatus===PLAYSTATUS_PAUSED){PlayerView.play();}}}());}});});},handleEvent:function pv_handleEvent(evt){var target=evt.target;if(!target){return;}
switch(evt.type){case'click':switch(target.id){case'player-cover':case'player-cover-image':this.showInfo();break;case'player-controls-play':if(this.playControl.classList.contains('is-pause')){this.play();}else{this.pause();}
break;case'player-album-repeat':this.showInfo();var newValue=++this.repeatOption%3;asyncStorage.setItem(SETTINGS_OPTION_KEY,{repeat:newValue,shuffle:this.shuffleOption});this.setRepeat(newValue);break;case'player-album-shuffle':this.showInfo();asyncStorage.setItem(SETTINGS_OPTION_KEY,{repeat:this.repeatOption,shuffle:!this.shuffleOption});this.setShuffle(!this.shuffleOption,this.currentIndex);break;case'player-cover-share':this.share();break;}
if(target.dataset.rating){this.showInfo();var songData=this.dataSource[this.currentIndex];var targetRating=parseInt(target.dataset.rating,10);var newRating=(targetRating===songData.metadata.rated)?targetRating-1:targetRating;songData.metadata.rated=newRating;musicdb.updateMetadata(songData.name,songData.metadata);this.setRatings(newRating);}
break;case'play':this.playControl.classList.remove('is-pause');this.playStatus=PLAYSTATUS_PLAYING;this.playControl.setAttribute('data-l10n-id','playbackPause');this.updateRemotePlayStatus();break;case'pause':this.playControl.classList.add('is-pause');this.playStatus=PLAYSTATUS_PAUSED;this.playControl.setAttribute('data-l10n-id','playbackPlay');this.updateRemotePlayStatus();break;case'touchstart':case'touchmove':if(evt.type==='touchstart'){this.isTouching=true;this.seekIndicator.classList.add('highlight');}
if(this.isTouching&&this.audio.duration>0){var touch=evt.touches[0];var x=(touch.clientX-target.offsetLeft)/target.offsetWidth;if(x<0){x=0;}
if(x>1){x=1;}
if(this.isLTR){this.seekTime=x*this.seekBar.max;}else{this.seekTime=this.audio.duration-x*this.seekBar.max;}
this.setSeekBar(this.audio.startTime,this.audio.duration,this.seekTime);}
break;case'touchend':if(this.isFastSeeking){this.stopFastSeeking();}else if(target.id==='player-seek-bar'){this.seekIndicator.classList.remove('highlight');if(this.audio.duration>0&&this.isTouching){this.seekAudio(this.seekTime);this.seekTime=0;}
this.isTouching=false;}else if(target.id==='player-controls-previous'){this.previous();}else if(target.id==='player-controls-next'){this.next();}
break;case'contextmenu':if(target.id==='player-controls-next'){this.startFastSeeking(1);}else if(target.id==='player-controls-previous'){this.startFastSeeking(-1);}
break;case'durationchange':case'timeupdate':this.updateSeekBar();if(evt.type==='durationchange'||this.audio.currentTime===0){this.updateRemoteMetadata();}
if(this.audio.currentTime>=this.audio.duration-1&&this.endedTimer==null){var timeToNext=(this.audio.duration-this.audio.currentTime+1);this.endedTimer=setTimeout(function(){this.next(true);}.bind(this),timeToNext*1000);}
break;case'ended':if(!this.endedTimer){this.next(true);}
break;case'visibilitychange':if(document.hidden){this.audio.removeEventListener('timeupdate',this);}else{this.audio.addEventListener('timeupdate',this);this.updateSeekBar();}
break;case'mozinterruptbegin':this.playStatus=INTERRUPT_BEGIN;this.updateRemotePlayStatus();break;case'mozinterruptend':this.playStatus=PLAYSTATUS_PLAYING;this.updateRemotePlayStatus();break;default:return;}},updateL10n:function pv_updateL10n(){this.isLTR=navigator.mozL10n.language.direction==='ltr'?true:false;}};;'use strict';navigator.mozL10n.once(function onLocalizationInit(){navigator.mozSetMessageHandler('activity',handleOpenActivity);});function handleOpenActivity(request){var data=request.source.data;var blob=request.source.data.blob;var header=document.getElementById('header');var saveButton=document.getElementById('title-save');var banner=document.getElementById('banner');var message=document.getElementById('message');var storage;var saved=false;if(data.allowSave&&data.filename&&checkFilename()){saveButton.hidden=false;saveButton.disabled=true;header.runFontFit();getStorageIfAvailable('music',blob.size,function(ds){storage=ds;saveButton.disabled=false;});}
playBlob(blob);function playBlob(blob){PlayerView.init();PlayerView.stop();PlayerView.setSourceType(TYPE_BLOB);PlayerView.dataSource=blob;PlayerView.play();PlayerView.onerror=function invalid(){alert(navigator.mozL10n.get('audioinvalid'));done();};}
header.addEventListener('action',done);saveButton.addEventListener('click',save);window.addEventListener('visibilitychange',function onVisibilityChanged(){if(document.hidden){done();}});function done(){PlayerView.stop();request.postResult({saved:saved});}
function save(){saveButton.hidden=true;document.getElementById('title-text').textContent=document.getElementById('title-text').textContent;getUnusedFilename(storage,data.filename,function(filename){var savereq=storage.addNamed(blob,filename);savereq.onsuccess=function(){saved=filename;showBanner(navigator.mozL10n.get('saved',{title:document.getElementById('title-text').textContent}));};savereq.onerror=function(e){console.error('Error saving',filename,e);};});}
function checkFilename(){var dotIdx=data.filename.lastIndexOf('.'),ext;if(dotIdx>-1){ext=data.filename.substr(dotIdx+1);if(ext==='ogg'){return true;}else{return MimeMapper.guessTypeFromExtension(ext)===blob.type;}}else{return false;}}
function showBanner(msg){message.textContent=msg;banner.hidden=false;setTimeout(function(){banner.hidden=true;},3000);}}