;'use strict';(function(window){window.mozPerformance={timing:{}};function dispatch(name){if(!window.mozPerfHasListener){return;}
var now=window.performance.now();var epoch=Date.now();setTimeout(function(){var detail={name:name,timestamp:now,epoch:epoch};var event=new CustomEvent('x-moz-perf',{detail:detail});window.dispatchEvent(event);});}
['moz-chrome-dom-loaded','moz-chrome-interactive','moz-app-visually-complete','moz-content-interactive','moz-app-loaded'].forEach(function(eventName){window.addEventListener(eventName,function mozPerfLoadHandler(){dispatch(eventName);},false);});window.PerformanceTestingHelper={dispatch:dispatch};})(window);;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,rawValue,ast){var pos,v;var value=rawValue.indexOf('{{')>-1?this.parseString(rawValue):rawValue;if(rawValue.indexOf('<')>-1||rawValue.indexOf('&')>-1){value={$o:value};}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;var nonLatin1=/[^\x01-\xFF]/;var FSI='\u2068';var PDI='\u2069';function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v!==undefined?node.$v:null,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
return{id:id,value:node.$v||(node!==undefined?node:null),index:node.$x||null,env:env,dirty:false};}
function format(args,entity){var locals={overlay:false};if(typeof entity==='string'){return[locals,entity];}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var rv;try{rv=resolveValue(locals,args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return rv;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return[{},env['__'+id]];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return[{},args[id]];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(locals,args,env,id){var res;try{res=resolveIdentifier(args,env,id);}catch(err){return[{error:err},'{{ '+id+' }}'];}
var value=res[1];if(typeof value==='number'){return res;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
if(locals.contextIsNonLatin1||value.match(nonLatin1)){res[1]=FSI+value+PDI;}
return res;}
return[{},'{{ '+id+' }}'];}
function interpolate(locals,args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return[prev[0],prev[1]+cur];}else if(cur.t==='idOrVar'){var placeable=subPlaceable(locals,args,env,cur.v);if(placeable[0].overlay){prev[0].overlay=true;}
return[prev[0],prev[1]+placeable[1]];}},[locals,'']);}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName)[1];if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1])[1]:undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(locals,args,env,expr,index){if(!expr){return[locals,expr];}
if(expr.$o){expr=expr.$o;locals.overlay=true;}
if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'){return[locals,expr];}
if(Array.isArray(expr)){locals.contextIsNonLatin1=expr.some(function($_){return typeof($_)==='string'&&$_.match(nonLatin1);});return interpolate(locals,args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(locals,args,env,expr[selector]);}}
if('other'in expr){return resolveValue(locals,args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;key=keys[i];i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function makeAccented(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\})/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return makeAccented(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO_STRATEGIES={'qps-ploc':new Pseudo('qps-ploc','Accented English',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Mirrored English',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.isPseudo=PSEUDO_STRATEGIES.hasOwnProperty(id);this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo?this.ctx.defaultLocale:id);}
var bindingsIO={extra:function(id,ver,path,type,callback,errback,sync){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo?ctx.defaultLocale:this.id;var source=navigator.mozL10n._config.localeSources[this.id]||'app';var appVersion=navigator.mozL10n._config.appVersion;for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO_STRATEGIES[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0;i<ast.length;i++){this.entries[ast[i].$i]=createEntry(ast[i],this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatTuple(args,entity){try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);var locals={error:err};return[locals,entity.id];}}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
return formatTuple.call(this,args,entity)[1];}
function formatEntity(args,entity){var rv=formatTuple.call(this,args,entity);var locals=rv[0];var value=rv[1];var formatted={value:value,attrs:null,overlay:locals.overlay};if(entity.attrs){formatted.attrs=Object.create(null);}
for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){if(available.indexOf(requested[0])===-1||requested[0]===defaultLocale){return[defaultLocale];}else{return[requested[0],defaultLocale];}}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var reqPseudo=requested.filter(function(loc){return loc in PSEUDO_STRATEGIES;});var supported=negotiate(this.availableLocales.concat(reqPseudo),requested,this.defaultLocale);freeze.call(this,supported);};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var allowed={elements:['a','em','strong','small','s','cite','q','dfn','abbr','data','time','code','var','samp','kbd','sub','sup','i','b','u','mark','ruby','rt','rp','bdi','bdo','span','br','wbr'],attributes:{global:['title','aria-label','aria-valuetext','aria-moz-hint'],a:['download'],area:['download','alt'],input:['alt','placeholder'],menuitem:['label'],menu:['label'],optgroup:['label'],option:['label'],track:['label'],img:['alt'],textarea:['placeholder'],th:['abbr']}};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO_STRATEGIES,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=!PSEUDO_STRATEGIES.hasOwnProperty(navigator.language)&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(pretranslate){initResources.call(navigator.mozL10n);}else{initObserver();window.setTimeout(initResources.bind(navigator.mozL10n));}}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function camelCaseToDashed(string){if(string==='ariaValueText'){return'aria-valuetext';}
return string.replace(/[A-Z]/g,function(match){return'-'+match.toLowerCase();}).replace(/^-/,'');}
function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(typeof entity.value==='string'){if(!entity.overlay){element.textContent=entity.value;}else{var translation=element.ownerDocument.createElement('template');translation.innerHTML=entity.value;overlayElement(element,translation.content);}}
for(var key in entity.attrs){if(key==='innerHTML'){element.innerHTML=entity.attrs[key];continue;}
var attrName=camelCaseToDashed(key);if(isAttrAllowed({name:attrName},element)){element.setAttribute(attrName,entity.attrs[key]);}}}
function overlayElement(sourceElement,translationElement){var result=translationElement.ownerDocument.createDocumentFragment();var k,attr;var childElement;while((childElement=translationElement.childNodes[0])){translationElement.removeChild(childElement);if(childElement.nodeType===Node.TEXT_NODE){result.appendChild(childElement);continue;}
var index=getIndexOfType(childElement);var sourceChild=getNthElementOfType(sourceElement,childElement,index);if(sourceChild){overlayElement(sourceChild,childElement);result.appendChild(sourceChild);continue;}
if(isElementAllowed(childElement)){const sanitizedChild=childElement.ownerDocument.createElement(childElement.nodeName);overlayElement(sanitizedChild,childElement);result.appendChild(sanitizedChild);continue;}
result.appendChild(document.createTextNode(childElement.textContent));}
sourceElement.textContent='';sourceElement.appendChild(result);if(translationElement.attributes){for(k=0,attr;(attr=translationElement.attributes[k]);k++){if(isAttrAllowed(attr,sourceElement)){sourceElement.setAttribute(attr.name,attr.value);}}}}
function isElementAllowed(element){return allowed.elements.indexOf(element.tagName.toLowerCase())!==-1;}
function isAttrAllowed(attr,element){var attrName=attr.name.toLowerCase();var tagName=element.tagName.toLowerCase();if(allowed.attributes.global.indexOf(attrName)!==-1){return true;}
if(!allowed.attributes[tagName]){return false;}
if(allowed.attributes[tagName].indexOf(attrName)!==-1){return true;}
if(tagName==='input'&&attrName==='value'){var type=element.type.toLowerCase();if(type==='submit'||type==='button'||type==='reset'){return true;}}
return false;}
function getNthElementOfType(context,element,index){var nthOfType=0;for(var i=0,child;child=context.children[i];i++){if(child.nodeType===Node.ELEMENT_NODE&&child.tagName===element.tagName){if(nthOfType===index){return child;}
nthOfType++;}}
return null;}
function getIndexOfType(element){var index=0;var child;while((child=element.previousElementSibling)){if(child.tagName===element.tagName){index++;}}
return index;}})(this);;'use strict';(function(exports){var blacklist=['app://privacy-panel.gaiamobile.org'];var appMgr=navigator.mozApps.mgmt;var apps=null;window.performance.mark('homescreenStart@system.gaiamobile.org');appMgr.getAll().onsuccess=function onsuccess(event){apps=event.target.result;window.dispatchEvent(new CustomEvent('navigator-mozapps-ready'));};function ApplicationSource(store){this.store=store;this.entries=[];this.entriesByManifestUrl={};this.svPreviouslyInstalledApps=[];var pendingInstallRequests=[];function addSVEventListener(){window.addEventListener('singlevariant-ready',function svFileReady(ev){window.removeEventListener('singlevariant-ready',svFileReady);for(var i=0;i<pendingInstallRequests;i++){pendingInstallRequests[i]();}});}
function addMozAppListener(){window.addEventListener('downloadapplied',function onDownloadApplied(e){appManager.sendEventToCollectionApp('install',{id:e.detail.id});});}
addSVEventListener();addMozAppListener();var self=this;function addIcons(){window.removeEventListener('navigator-mozapps-ready',addIcons);for(var i=0,iLen=apps.length;i<iLen;i++){self.makeIcons(apps[i]);}
apps=null;}
apps?addIcons():window.addEventListener('navigator-mozapps-ready',addIcons);function install(application){var manifest=application.manifest||application.updateManifest;if(manifest.role&&app.HIDDEN_ROLES.indexOf(manifest.role)!==-1){return;}
this.addIconToGrid(application);var svApp=configurator.getSingleVariantApp(application.manifestURL);var lastElem=app.grid.getIndexLastIcon();if(configurator.isSimPresentOnFirstBoot&&svApp&&svApp.location<lastElem&&!this.isPreviouslyInstalled(application.manifestURL)){app.grid.popDivider();app.grid.removeNonVisualElements();lastElem=app.grid.getIndexLastIcon();app.grid.moveTo(lastElem,svApp.location);_moveAhead(svApp.location+1);this.addPreviouslyInstalledSvApp(application.manifestURL);app.itemStore.savePrevInstalledSvApp(this.svPreviouslyInstalledApps);}
app.grid.render();app.itemStore.deferredSave(app.grid.getItems());if(application.installState==='installed'){appManager.sendEventToCollectionApp('install',{id:application.manifestURL});}}
function _moveAhead(startPos){var elems=app.grid.getItems();for(var i=startPos,iLen=elems.length;i<iLen;i++){var item=elems[i];if(item instanceof GaiaGrid.Mozapp){var svApp=configurator.getSingleVariantApp(elems[i].identifier);if(svApp&&i>svApp.location){app.grid.moveTo(i,i-1);}}}}
appMgr.oninstall=function oninstall(event){if(configurator.isSingleVariantReady){install.bind(this)(event.application);}else{pendingInstallRequests.push(install.bind(this,event.application));}}.bind(this);appMgr.onuninstall=function onuninstall(event){var application=event.application;var manifest=application.updateManifest||application.manifest;this.removeIconFromGrid(application.manifestURL);app.itemStore.deferredSave(app.grid.getItems());if(app.HIDDEN_ROLES.indexOf(manifest.role)!==-1){return;}
appManager.sendEventToCollectionApp('uninstall',{id:application.manifestURL});}.bind(this);}
ApplicationSource.prototype={synchronize:function(){var storeItems=this.store._allItems;var toAdd=[];var appIconsByManifestUrl={};for(var i=0,iLen=storeItems.length;i<iLen;i++){var item=storeItems[i];if(!(item instanceof GaiaGrid.Mozapp)){continue;}
appIconsByManifestUrl[item.detail.manifestURL]=item;}
for(i=0,iLen=this.entries.length;i<iLen;i++){var entry=this.entries[i];var manifest=entry.app.updateManifest||entry.app.manifest;if(!appIconsByManifestUrl[entry.detail.manifestURL]&&!manifest.entry_points){toAdd.push(entry);}else{delete appIconsByManifestUrl[entry.detail.manifestURL];}}
for(i in appIconsByManifestUrl){this.removeIconFromGrid(i);}
toAdd.forEach(function _toAdd(newApp){if(blacklist.indexOf(newApp.app.origin)!==-1){return;}
this.addIconToGrid(newApp.app);},this);app.itemStore.deferredSave(app.grid.getItems());},addIconToGrid:function(application){this.makeIcons(application);var appObject=this.mapToApp({manifestURL:application.manifestURL});app.grid.appendItemToExpandedGroup(appObject);app.grid.render();},removeIconFromGrid:function(manifestURL){var icons=app.grid.getIcons();var appObject=icons[manifestURL];if(appObject){appObject.removeFromGrid();}},populate:function(success){success(this.entries);},makeIcons:function(eachApp){var manifest=eachApp.manifest||eachApp.updateManifest;if(app.HIDDEN_ROLES.indexOf(manifest.role)!==-1){return;}
function eachIcon(icon){if(!icon.icon){return;}
icon.setPosition(this.store.getNextPosition());this.entries.push(icon);}
this.entriesByManifestUrl[eachApp.manifestURL]=eachApp;if(manifest.entry_points){for(var i in manifest.entry_points){eachIcon.call(this,new GaiaGrid.Mozapp(eachApp,i));}}else{eachIcon.call(this,new GaiaGrid.Mozapp(eachApp));}},mapToApp:function(entry){var app=this.entriesByManifestUrl[entry.manifestURL];app=app||{manifestURL:entry.manifestURL,manifest:{name:'',icons:[]}};return new GaiaGrid.Mozapp(app,entry.entryPoint,{decoratedIconBlob:entry.decoratedIconBlob});},addPreviouslyInstalledSvApp:function(manifest){this.svPreviouslyInstalledApps.push({manifestURL:manifest});},isPreviouslyInstalled:function(manifest){for(var i=0,elemNum=this.svPreviouslyInstalledApps.length;i<elemNum;i++){if(this.svPreviouslyInstalledApps[i].manifestURL===manifest){return true;}}
return false;}};exports.ApplicationSource=ApplicationSource;}(window));;'use strict';(function(exports){function AppManager(){var grid=document.querySelector('gaia-grid');var self=this;navigator.mozApps.getSelf().onsuccess=function(evt){self.app=evt.target.result;window.dispatchEvent(new CustomEvent('appmanager-ready'));};window.addEventListener('gaiagrid-add-to-collection',this);grid.addEventListener('removeitem',this);}
AppManager.prototype={get self(){return this.app;},handleItemRemoval:function(item){function errorLogger(err){console.error('Error while trying to remove',item.name,err);}
switch(item.detail.type){case'bookmark':BookmarksDatabase.remove(item.identifier).catch(errorLogger);break;case'collection':CollectionsDatabase.remove(item.identifier).catch(errorLogger);break;default:console.error('Cannot handle remove for item type ',item.detail.type);}},handleEvent:function(e){var nameObj={name:e.detail&&e.detail.name};switch(e.type){case'removeitem':if(e.detail.detail.type=='app'){var request=navigator.mozApps.mgmt.uninstall(e.detail.app);request.onsuccess=()=>{e.detail.removeFromGrid();};request.onerror=()=>{console.error('Error while trying to remove',e.detail.name,request.error);};break;}
var dialog=new ConfirmDialogHelper({type:'remove',title:{id:'delete-title',args:nameObj},body:{id:'delete-body',args:nameObj},cancel:{title:'cancel'},confirm:{title:'delete',type:'danger',cb:()=>{e.detail.removeFromGrid();this.handleItemRemoval(e.detail);}}});dialog.show(document.body);break;case'gaiagrid-add-to-collection':this.sendEventToCollectionApp('add-to-collection',e.detail);break;}},sendEventToCollectionApp:function(eventName,message){var onAppReady=function(app){app.connect(eventName).then(function onConnectionAccepted(ports){ports.forEach(function(port){port.postMessage(message);});},function onConnectionRejected(){console.error('Cannot connect to collection app');});};if(!this.app){window.addEventListener('appmanager-ready',function onReady(){window.removeEventListener('appmanager-ready',onReady);onAppReady(this.app);}.bind(this));}else{onAppReady(this.app);}},};exports.appManager=new AppManager();}(window));;'use strict';(function(exports){const APPEARANCE={OPAQUE:'opaque',SEMI_TRANSPARENT:'semi-transparent'};function StatusBar(){this.threshold=document.getElementById('search').clientHeight;if(!appManager.app){window.addEventListener('appmanager-ready',function onReady(){window.removeEventListener('appmanager-ready',onReady);this.onAppReady();}.bind(this));}else{this.onAppReady();}}
StatusBar.prototype={handleEvent:function(e){switch(e.type){case'collection-launch':case'collections-create-begin':this.setAppearance(APPEARANCE.OPAQUE);break;case'editmode-start':window.removeEventListener('context-menu-open',this);window.removeEventListener('context-menu-close',this);window.removeEventListener('gaia-confirm-open',this);window.removeEventListener('gaia-confirm-close',this);case'context-menu-open':case'gaia-confirm-open':window.removeEventListener('scroll',this);this.setAppearance(APPEARANCE.OPAQUE);break;case'editmode-end':window.addEventListener('context-menu-open',this);window.addEventListener('context-menu-close',this);window.addEventListener('gaia-confirm-open',this);window.addEventListener('gaia-confirm-close',this);case'context-menu-close':case'gaia-confirm-close':window.addEventListener('scroll',this);case'collection-close':case'collections-create-return':case'scroll':this.setAppearance(this.calculateAppearance());break;case'visibilitychange':if(document.hidden){break;}
this.appearance=null;this.setAppearance(this.calculateAppearance());break;}},onAppReady:function(){var grid=app.grid;window.addEventListener('scroll',this);grid.addEventListener('collection-launch',this);grid.addEventListener('collection-close',this);grid.addEventListener('editmode-start',this);grid.addEventListener('editmode-end',this);window.addEventListener('collections-create-begin',this);window.addEventListener('collections-create-return',this);window.addEventListener('context-menu-close',this);window.addEventListener('context-menu-open',this);window.addEventListener('gaia-confirm-open',this);window.addEventListener('gaia-confirm-close',this);window.addEventListener('visibilitychange',this);this.setAppearance(APPEARANCE.SEMI_TRANSPARENT);},calculateAppearance:function(){return window.scrollY>this.threshold?APPEARANCE.OPAQUE:APPEARANCE.SEMI_TRANSPARENT;},setAppearance:function(value){if(this.appearance===value){return;}
this.appearance=value;var meta=document.head.querySelector('meta[name="theme-color"]');if(value==APPEARANCE.OPAQUE){meta.content='black';}else{meta.content='transparent';}}};exports.statusBar=new StatusBar();}(window));;'use strict';(function(exports){var datastore;var DATASTORE_NAME='vertical_preferences_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('vps-initialized',function oninitalized(){document.removeEventListener('vps-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Preferences store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Preferences store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('vps-initialized'));resolve();},reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:{name:event.id,value:result}});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function put(id,value){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(value,id).then(function success(){resolve();},reject);},reject);});}
exports.verticalPreferences={get:get,put:put,addEventListener:addEventListener,removeEventListener:removeEventListener};}(window));;'use strict';(function(exports){var datastore;var DATASTORE_NAME='bookmarks_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('ds-initialized',function oninitalized(){document.removeEventListener('ds-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Bookmark store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Bookmark store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('ds-initialized'));resolve();},reject);});}
function doGetAll(resolve,reject){var result=Object.create(null);var cursor=datastore.sync();function cursorResolve(task){switch(task.operation){case'update':case'add':result[task.data.id]=task.data;break;case'remove':delete result[task.data.id];break;case'clear':result=Object.create(null);break;case'done':resolve(result);return;}
cursor.next().then(cursorResolve,reject);}
cursor.next().then(cursorResolve,reject);}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function getAll(){return new Promise(function doGet(resolve,reject){init().then(doGetAll.bind(null,resolve,reject),reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:result||event});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function add(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){var id=data.url;Object.defineProperty(data,'id',{enumerable:true,configurable:false,writable:false,value:id});datastore.add(data,id).then(function add_success(){resolve(true);},function add_error(){datastore.put(data,id).then(function put_success(){resolve();},reject);});},reject);});}
function getRevisionId(){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){resolve(datastore.revisionId);},reject);});}
function put(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(data,data.id).then(function success(){resolve();},reject);},reject);});}
function remove(id){return new Promise(function doRemove(resolve,reject){init().then(function onInitialized(){datastore.remove(id).then(resolve,reject);},reject);});}
function clear(){return new Promise(function doClear(resolve,reject){init().then(function onInitialized(){datastore.clear().then(resolve,reject);},reject);});}
exports.BookmarksDatabase={get:get,getAll:getAll,getRevisionId:getRevisionId,addEventListener:addEventListener,removeEventListener:removeEventListener,add:add,put:put,remove:remove,clear:clear};}(window));;'use strict';(function(exports){var datastore;var DATASTORE_NAME='collections_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('collections-ds-initialized',function oninitalized(){document.removeEventListener('collections-ds-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Collection store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Collection store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('collections-ds-initialized'));resolve();},reject);});}
function doGetAll(resolve,reject){var result=Object.create(null);var cursor=datastore.sync();function cursorResolve(task){switch(task.operation){case'update':case'add':result[task.data.id]=task.data;break;case'remove':delete result[task.data.id];break;case'clear':result=Object.create(null);break;case'done':resolve(result);return;}
cursor.next().then(cursorResolve,reject);}
cursor.next().then(cursorResolve,reject);}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function getAll(){return new Promise(function doGet(resolve,reject){init().then(doGetAll.bind(null,resolve,reject),reject);});}
function getAllCategories(){return new Promise(function doGet(resolve,reject){getAll().then(function(collections){var categories=[];for(var id in collections){var collection=collections[id];if(collection.categoryId){categories.push(collection.categoryId);}}
resolve(categories);},reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:result||event});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function add(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){var id=data.id||uuid();Object.defineProperty(data,'id',{enumerable:true,configurable:false,writable:false,value:id});datastore.add(data,id).then(function add_success(){resolve(true);},function add_error(){datastore.put(data,id).then(function put_success(){resolve();},reject);});},reject);});}
function getRevisionId(){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){resolve(datastore.revisionId);},reject);});}
function put(data){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(data,data.id).then(function success(){resolve();},reject);},reject);});}
function remove(id){return new Promise(function doRemove(resolve,reject){init().then(function onInitialized(){datastore.remove(id).then(resolve,reject);},reject);});}
exports.CollectionsDatabase={get:get,getAll:getAll,getAllCategories:getAllCategories,getRevisionId:getRevisionId,addEventListener:addEventListener,removeEventListener:removeEventListener,add:add,put:put,remove:remove};}(window));;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::(?:\/\/)?)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},_getScheme:function(input){return(rscheme.exec(input)||[])[0];},hasScheme:function(input){return!!this._getScheme(input);},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data|view-source)\:/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)||this._getScheme(str)===str){return true;}
if(case3Reg.test(str)){return false;}
if(!this.hasScheme(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;'use strict';(function(exports){var eventTypesToListenFor=['added','updated','removed'];function BookmarkSource(store){this.store=store;this.entries=[];eventTypesToListenFor.forEach(function iterateTypes(type){BookmarksDatabase.addEventListener(type,this);},this);}
BookmarkSource.prototype={synchronize:function(){var allAppBookmarks={};var toAdd=[];var icons=app.grid.getIcons();for(var i in icons){var icon=icons[i];if(icon.detail.type!=='bookmark'){continue;}
allAppBookmarks[icon.detail.url]=icon;}
for(var j=0,jLen=this.entries.length;j<jLen;j++){var entry=this.entries[j];if(!allAppBookmarks[entry.detail.url]){toAdd.push(entry);}else{delete allAppBookmarks[entry.detail.url];}}
for(i in allAppBookmarks){this.removeIconFromGrid(allAppBookmarks[i].detail.url);}
for(i=0;i<toAdd.length;i++){this.addIconToGrid(toAdd[i].detail);}
app.itemStore.deferredSave(app.grid.getItems());},populate:function(success){var self=this;BookmarksDatabase.getAll().then(function(systemBookmarks){Object.keys(systemBookmarks).forEach(function(id){self.entries.push(new GaiaGrid.Bookmark(systemBookmarks[id]));});success(self.entries);},success);},handleEvent:function(e){switch(e.type){case'added':case'updated':this.addIconToGrid(e.target);app.itemStore.deferredSave(app.grid.getItems());break;case'removed':var id=e.target.id;this.removeIconFromGrid(id);break;}},addIconToGrid:function(detail){var icons=app.grid.getIcons();var existing=icons[detail.id];if(existing){existing.update(detail);app.grid.render();return;}
var bookmark=new GaiaGrid.Bookmark(detail);bookmark.setPosition(this.store.getNextPosition());this.entries.push(bookmark);app.grid.appendItemToExpandedGroup(bookmark);app.grid.render();},removeIconFromGrid:function(url){var icons=app.grid.getIcons();var appObject=icons[url];if(appObject){appObject.removeFromGrid();}
appManager.sendEventToCollectionApp('uninstall',{id:url});}};exports.BookmarkSource=BookmarkSource;}(window));;'use strict';(function(exports){var eventTypesToListenFor=['added','updated','removed'];function CollectionSource(store){this.store=store;this.entries=[];}
CollectionSource.prototype={_setListeners:function(){eventTypesToListenFor.forEach(function iterateTypes(type){CollectionsDatabase.addEventListener(type,this);},this);window.addEventListener('context-menu-open',this);window.addEventListener('collections-create-begin',this);window.addEventListener('collections-create-return',this);this._setListeners=function(){};},inCreateActivity:false,pendingIds:[],pendingCollections:{},insertPosition:null,synchronize:function(){var allCollections={};var toAdd=[];var icons=app.grid.getIcons();for(var i in icons){var icon=icons[i];if(icon.detail.type!=='collection'){continue;}
allCollections[icon.identifier]=icon;}
for(var j=0,jLen=this.entries.length;j<jLen;j++){var entry=this.entries[j];if(!allCollections[entry.identifier]){toAdd.push(entry);}else{delete allCollections[entry.identifier];}}
for(i in allCollections){this.removeIconFromGrid(allCollections[i].identifier);}
for(i=0;i<toAdd.length;i++){this.addIconToGrid(toAdd[i].detail);}
app.itemStore.deferredSave(app.grid.getItems());this._setListeners();},populate:function(success){var self=this;var entriesByDefault=configurator.getItems('collection');CollectionsDatabase.getAll().then(function(systemCollections){Object.keys(systemCollections).forEach(function(id){self.entries.push(new GaiaGrid.Collection(systemCollections[id]));delete entriesByDefault[id];});Object.keys(entriesByDefault).forEach(function(id){self.entries.push(new GaiaGrid.Collection(entriesByDefault[id]));});self._setListeners();success(self.entries);},success);},handleEvent:function(e){switch(e.type){case'added':case'updated':this.addIconToGrid(e.target);app.grid.render();app.itemStore.deferredSave(app.grid.getItems());break;case'removed':this.removeIconFromGrid(e.target.id);app.itemStore.deferredSave(app.grid.getItems());break;case'context-menu-open':this.insertPosition=e.detail.nearestIndex;break;case'collections-create-begin':this.inCreateActivity=true;break;case'collections-create-return':this.inCreateActivity=false;this.pendingIds=this.pendingIds.concat(e.detail.ids||[]);if(this.isPendingFulfilled()){this.processPending();}
break;}},addIconToGrid:function(detail){var icons=app.grid.getIcons();var existing=icons[detail.id];if(existing){existing.update(detail);app.grid.render();return;}
this.maybeAddToPending(detail);if(this.isPendingFulfilled()){this.processPending();return;}else if(this.inCreateActivity||this.pendingIds.length){return;}
var collection=new GaiaGrid.Collection(detail);collection.setPosition(this.store.getNextPosition());this.entries.push(collection);if(this.insertPosition){app.grid.add(collection,this.insertPosition,true);}else{app.grid.appendItemToExpandedGroup(collection);}},removeIconFromGrid:function(url){var icons=app.grid.getIcons();var appObject=icons[url];if(appObject){appObject.removeFromGrid();}},isPendingFulfilled:function(){if(!this.pendingIds.length){return false;}
for(var i=0;i<this.pendingIds.length;i++){var id=this.pendingIds[i];if(!this.pendingCollections[id]){return false;}}
return!this.inCreateActivity;},maybeAddToPending:function(collection){if(this.inCreateActivity||this.pendingIds.indexOf(collection.id)!==-1){this.pendingCollections[collection.id]=collection;}},processPending:function(){var ordered=[];var id;while((id=this.pendingIds.shift())){ordered.push(this.pendingCollections[id]);delete this.pendingCollections[id];}
ordered.forEach(item=>{this.addIconToGrid(item);this.insertPosition++;});this.insertPosition=null;for(var i in this.pendingCollections){this.addIconToGrid(this.pendingCollections[i]);delete this.pendingCollections[i];}
app.grid.render();}};exports.CollectionSource=CollectionSource;}(window));;'use strict';(function(exports){const DB_VERSION=1;const DB_NAME='verticalhome';const DB_ITEM_STORE='items';const DB_SV_APP_STORE_NAME='svAppsInstalled';var db;function sort(entries,order){if(!order||!order.length){return entries;}
var newEntries=[];function isEqual(lookFor,compareWith){if(!compareWith.detail||!lookFor){return false;}
if(compareWith instanceof GaiaGrid.Mozapp){if(!lookFor.manifestURL||!compareWith.detail.manifestURL){return false;}
if(compareWith.detail.entryPoint){return lookFor.manifestURL===compareWith.detail.manifestURL&&lookFor.entry_point===compareWith.detail.entryPoint;}else{return lookFor.manifestURL===compareWith.detail.manifestURL;}}else if(compareWith instanceof GaiaGrid.Collection||compareWith instanceof GaiaGrid.Bookmark){if(!lookFor.id||!compareWith.detail.id){return false;}
return lookFor.id===compareWith.detail.id;}}
for(var i=0,iLen=order.length;i<iLen;i++){for(var j=0,jLen=order[i].length;j<jLen;j++){var ind=entries.findIndex(isEqual.bind(null,order[i][j]));if(ind>=0){newEntries.push(entries.splice(ind,1)[0]);}}
if(i<iLen-1){newEntries.push(new GaiaGrid.Divider());}}
if(entries.length>0){if(configurator.isSimPresentOnFirstBoot){sortUnclassifiedApps(newEntries,entries);}else{newEntries.push(new GaiaGrid.Divider());newEntries=newEntries.concat(entries);}}
for(i=0,iLen=newEntries.length;i<iLen;i++){if(newEntries[i].detail){newEntries[i].detail.index=i;}}
return newEntries;}
function sortUnclassifiedApps(dstEntries,orgEntries){function compareApps(appA,appB){var svAppA=null;var svAppB=null;if(appA){svAppA=configurator.getSingleVariantApp(appA.detail.manifestURL);}
if(appB){svAppB=configurator.getSingleVariantApp(appB.detail.manifestURL);}
var locA=svAppA&&svAppA.location!==undefined&&svAppA.location||Number.MAX_VALUE;var locB=svAppB&&svAppB.location!==undefined&&svAppB.location||Number.MAX_VALUE;var relPos=locA-locB;return relPos?(relPos>0?1:-1):0;}
orgEntries.sort(compareApps);if(!configurator.getSingleVariantApp(orgEntries[0].detail.manifestURL)){dstEntries.push(new GaiaGrid.Divider());dstEntries=dstEntries.concat(orgEntries);}else{var sepAdded=false;for(var i=0,iLen=orgEntries.length;i<iLen;i++){var app=orgEntries[i];var svApp=configurator.getSingleVariantApp(app.detail.manifestURL);if(!svApp){if(!sepAdded){dstEntries.push(new GaiaGrid.Divider());sepAdded=true;}
dstEntries.push(app);}else{if(svApp.location!==undefined){dstEntries.splice(svApp.location,0,app);}else{dstEntries.push(app);}}}}}
function loadTable(table,indexName,iterator,aNext){newTxn(table,'readonly',function(txn,store){var index=store.index(indexName);index.openCursor().onsuccess=function onsuccess(event){var cursor=event.target.result;if(!cursor){return;}
iterator(cursor.value);cursor.continue();};},aNext);}
function newTxn(storeName,txnType,withTxnAndStore,successCb){var txn=db.transaction([storeName],txnType);var store=txn.objectStore(storeName);txn.oncomplete=function(event){if(successCb){successCb(event);}};txn.onerror=function(event){console.warn('Error during transaction.');};withTxnAndStore(txn,store);}
function ItemStore(onsuccess){var self=this;this.applicationSource=new ApplicationSource(this);this.bookmarkSource=new BookmarkSource(this);this.collectionSource=new CollectionSource(this);this.sources=[this.applicationSource,this.bookmarkSource,this.collectionSource];this.ready=false;var isEmpty=false;self.gridOrder=null;var request=window.indexedDB.open(DB_NAME,DB_VERSION);request.onupgradeneeded=function _onupgradeneeded(event){var db=event.target.result;var oldVersion=event.oldVersion||0;switch(oldVersion){case 0:var objectStore=db.createObjectStore(DB_ITEM_STORE,{keyPath:'index'});objectStore.createIndex('index','index',{unique:true});isEmpty=true;var objectSV=db.createObjectStore(DB_SV_APP_STORE_NAME,{keyPath:'manifestURL'});objectSV.createIndex('indexSV','indexSV',{unique:true});}};request.onsuccess=function _onsuccess(){onsuccess&&onsuccess(isEmpty);db=request.result;var cb=self.fetch.bind(self,self.synchronize.bind(self));if(isEmpty){window.addEventListener('configuration-ready',function onReady(){window.removeEventListener('configuration-ready',onReady);self.gridOrder=configurator.getGrid();self.populate(cb);});}else{self.initSources(cb);}};window.addEventListener('gaiagrid-cached-icons-rendered',this);}
ItemStore.prototype={_renderedOnce:false,_deferredSaveArgs:[],_allItems:[],nextPosition:0,all:function(success){if(!this.ready){window.addEventListener('databaseready',this.all.bind(this,success));return;}
success(this._allItems);},saveTable:function(table,objArr,column,checkPersist,aNext){newTxn(table,'readwrite',function(txn,store){store.clear();for(var i=0,iLen=objArr.length;i<iLen;i++){if(!checkPersist||(checkPersist&&objArr[i].persistToDB)){store.put(column?objArr[i][column]:objArr[i]);}}
if(typeof aNext==='function'){aNext();}});},saveItem:function(object,callback){if(object.index==null){console.error('Attempting to save object without `index`');return;}
newTxn(DB_ITEM_STORE,'readwrite',function(txn,store){store.put(object);},callback);},deferredSave:function(){var args=Array.slice(arguments);if(this._renderedOnce){return this.save.apply(this,args);}
this._deferredSaveArgs=args;},save:function(entries,aNext){entries=sort(entries,this.gridOrder);this.gridOrder=null;this.saveTable(DB_ITEM_STORE,entries,'detail',true,aNext);},savePrevInstalledSvApp:function(svApps,aNext){this.saveTable(DB_SV_APP_STORE_NAME,svApps,null,false,aNext);},fetch:function(callback){var cached={};var collected=[];function iterator(value){collected.push(value);}
function iteratorSV(value){this.applicationSource.addPreviouslyInstalledSvApp(value.manifestURL);}
loadTable(DB_SV_APP_STORE_NAME,'indexSV',iteratorSV.bind(this));loadTable(DB_ITEM_STORE,'index',iterator,finish.bind(this));function addIfUnique(item){if(!cached[item.identifier]){cached[item.identifier]=true;this._allItems.push(item);}}
function finish(){for(var i=0,iLen=collected.length;i<iLen;i++){var thisItem=collected[i];if(thisItem.type==='app'){var itemObj=this.applicationSource.mapToApp(thisItem);addIfUnique.call(this,itemObj);}else if(thisItem.type==='divider'){var divider=new GaiaGrid.Divider(thisItem);this._allItems.push(divider);}else if(thisItem.type==='bookmark'){var bookmark=new GaiaGrid.Bookmark(thisItem);addIfUnique.call(this,bookmark);}else if(thisItem.type==='collection'){var collection=new GaiaGrid.Collection(thisItem);addIfUnique.call(this,collection);}}
this.notifyReady();if(callback&&typeof callback==='function'){callback();}}},synchronize:function(){this.sources.forEach(function eachSource(source){source.synchronize();});},initSources:function(callback){var pending=this.sources.length;var allEntries=[];var self=this;var current=0;function handleSource(){var source=self.sources[current];current++;source.populate(next);}
handleSource();function next(entries){allEntries=allEntries.concat(entries);if(!(--pending)){callback(allEntries);}else{handleSource();}}},populate:function(callback){this.initSources(function(entries){this.deferredSave(entries,callback);}.bind(this));},notifyReady:function(){this.ready=true;dispatchEvent(new CustomEvent('databaseready'));},getNextPosition:function(){var nextPosition=this.nextPosition;this.nextPosition++;return nextPosition;},handleEvent:function(e){switch(e.type){case'gaiagrid-cached-icons-rendered':this._renderedOnce=true;window.removeEventListener('gaiagrid-cached-icons-rendered',this);if(this._deferredSaveArgs.length){this.save.apply(this,this._deferredSaveArgs);}
break;}}};exports.ItemStore=ItemStore;}(window));;'use strict';(function(exports){const maxIconsPerRow=4;const iconScaleFactorMaxIconsPerRow=5;const minIconsPerRow=3;const iconScaleFactorMinIconsPerRow=3.8;const distanceBetweenIconsWithMinIconsPerRow=36;const distanceBetweenIconsWithMaxIconsPerRow=38;const eachTextRowHeight=20;var constraintSize;function GridLayout(gridView){this.gridView=gridView;if(window.verticalPreferences){verticalPreferences.get('grid.cols').then(value=>{this.cols=value;this.onReady();},this.onReady);verticalPreferences.addEventListener('updated',this);}else{this.onReady();}}
GridLayout.prototype={minIconsPerRow:minIconsPerRow,maxIconsPerRow:maxIconsPerRow,_cols:minIconsPerRow,_offsetY:0,_percent:1,_dividerLineHeight:0,get percent(){return this._percent;},get cols(){return this._cols;},set cols(value){if(!value||value===this._cols){return;}
if(window.verticalPreferences){verticalPreferences.put('grid.cols',value);}
this._offsetY=0;this._percent=value==minIconsPerRow?1:minIconsPerRow/maxIconsPerRow;this._cols=value;},get constraintSize(){if(!constraintSize){this.calculateSize();}
return constraintSize;},get gridItemHeight(){var height=this.gridIconSize+
(this._cols===minIconsPerRow?distanceBetweenIconsWithMinIconsPerRow:distanceBetweenIconsWithMaxIconsPerRow);var defaultTextRows=2;var definedRows=parseInt(this.gridView.element.getAttribute('text-rows'),10);if(definedRows>defaultTextRows){height+=(definedRows-defaultTextRows)*eachTextRowHeight;}
return height;},get gridItemWidth(){return this.constraintSize/this._cols;},get gridMaxIconSize(){var baseSize=(this.constraintSize/iconScaleFactorMinIconsPerRow);return baseSize*devicePixelRatio;},get gridIconSize(){var numCols=this._cols;var size=this.constraintSize/numCols;if(numCols===minIconsPerRow){size=this.constraintSize/iconScaleFactorMinIconsPerRow;}else if(numCols===maxIconsPerRow){size=this.constraintSize/iconScaleFactorMaxIconsPerRow;}
return Math.floor(size);},get offsetY(){return this._offsetY;},set offsetY(value){this._offsetY=value;},stepYAxis:function(value){this._offsetY+=value;},handleEvent:function(e){switch(e.type){case'updated':var prop=e.target;if(prop.name==='grid.cols'){this.cols=parseInt(prop.value,10);this.gridView.render();}
break;}},calculateSize:function(){constraintSize=Math.min(window.screen.width,window.screen.height);},onReady:function(){window.dispatchEvent(new CustomEvent('gaiagrid-layout-ready'));}};exports.GridLayout=GridLayout;}(window));;'use strict';(function(exports){const SHADOW_BLUR=1;const SHADOW_OFFSET_Y=1;const SHADOW_OFFSET_X=1;const SHADOW_COLOR='rgba(0, 0, 0, 0.2)';const DEFAULT_BACKGROUND_COLOR='rgb(228, 234, 238)';const UNSCALED_CANVAS_PADDING=2;const CANVAS_PADDING=UNSCALED_CANVAS_PADDING*devicePixelRatio;function IconRenderer(icon){this._icon=icon;}
IconRenderer.TYPE={CLIP:'clip',FAVICON:'favicon',STANDARD:'standard',};IconRenderer.prototype={unscaledCanvasPadding:UNSCALED_CANVAS_PADDING*2,get _maxSize(){return this._icon.grid.layout.gridMaxIconSize;},_createCanvas:function(){var canvas=document.createElement('canvas');canvas.width=this._maxSize+(CANVAS_PADDING*2);canvas.height=this._maxSize+(CANVAS_PADDING*2);return canvas;},_decorateShadowCanvas:function(canvas){var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.shadowColor=SHADOW_COLOR;ctx.shadowBlur=SHADOW_BLUR;ctx.shadowOffsetY=SHADOW_OFFSET_Y;ctx.shadowOffsetX=SHADOW_OFFSET_X;return ctx;},clip:function(img){return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);var clipCanvas=this._createCanvas();var clipCtx=clipCanvas.getContext('2d',{willReadFrequently:true});clipCtx.beginPath();clipCtx.arc(clipCanvas.width/2,clipCanvas.height/2,clipCanvas.height/2,0,2*Math.PI);clipCtx.clip();clipCtx.drawImage(img,0,0,clipCanvas.width,clipCanvas.height);shadowCtx.drawImage(clipCanvas,CANVAS_PADDING,CANVAS_PADDING,this._maxSize,this._maxSize);shadowCanvas.toBlob(resolve);});},favicon:function(img){if(img.width>this._icon.grid.layout.gridIconSize/2){return this.clip(img);}
return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);var iconWidth;var iconHeight;shadowCtx.beginPath();shadowCtx.arc(shadowCanvas.width/2,shadowCanvas.height/2,shadowCanvas.height/2-CANVAS_PADDING,0,2*Math.PI,false);shadowCtx.fillStyle=DEFAULT_BACKGROUND_COLOR;shadowCtx.fill();iconWidth=iconHeight=this._maxSize*0.55;shadowCtx.shadowBlur=0;shadowCtx.shadowOffsetY=0;shadowCtx.mozImageSmoothingEnabled=false;shadowCtx.drawImage(img,(shadowCanvas.width-iconWidth)/2,(shadowCanvas.height-iconHeight)/2,iconWidth,iconHeight);shadowCanvas.toBlob(resolve);});},standard:function(img){return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);shadowCtx.drawImage(img,CANVAS_PADDING,CANVAS_PADDING,this._maxSize,this._maxSize);shadowCanvas.toBlob(resolve);});}};exports.GridIconRenderer=IconRenderer;}(window));;'use strict';(function(exports){const APP_LAUNCH_TIMEOUT=3000;function GridView(config){this.config=config;this.clickIcon=this.clickIcon.bind(this);this.onVisibilityChange=this.onVisibilityChange.bind(this);this.onCollectionLaunch=this.onCollectionLaunch.bind(this);this.onCollectionClose=this.onCollectionClose.bind(this);if(config.features.zoom){this.zoom=new GridZoom(this);}
this.layout=new GridLayout(this);if(config.element.hasAttribute('cols')){this.layout.cols=parseInt(config.element.getAttribute('cols'),10);}
this.start();}
GridView.prototype={icons:{},items:[],get element(){return this.config.element;},set cols(value){this.layout.cols=value;},_launchingApp:false,_collectionOpen:false,add:function(item,insertTo,expandGroup){if(!item){return;}
if(item.identifier){if(this.icons[item.identifier]){console.log('Error, duplicate identifier: ',item.identifier,new Error().stack);return;}
this.icons[item.identifier]=item;}else if(item.detail.type!=='divider'&&item.detail.type!=='placeholder'){console.log('Error, could not load identifier for object: ',JSON.stringify(item.detail));return;}
if(!isNaN(parseFloat(insertTo))&&isFinite(insertTo)){this.items.splice(insertTo,0,item);}else{insertTo=this.items.length;this.items.push(item);}
if(expandGroup){for(var i=insertTo+1,iLen=this.items.length;i<iLen;i++){var divider=this.items[i];if(divider.detail.type==='divider'){if(divider.detail.collapsed){divider.expand();}
break;}}}},getNearestItemIndex:function(x,y,isRow){var foundIndex=null;var leastDistance=null;var itemMiddleOffset=this.layout.gridItemWidth/2;for(var i=0,iLen=this.items.length;i<iLen;i++){var item=this.items[i];if(!item.isDraggable()){continue;}
if(this.config.features.disableSections&&item.detail.type==='divider'){continue;}
if(item.detail.type!=='divider'&&item.element.classList.contains('collapsed')){continue;}
var middleX=item.x+itemMiddleOffset;var middleY=item.y+item.pixelHeight/2;var xDistance=(isRow||item.detail.type==='divider')?0:x-middleX;var yDistance=y-middleY;var distance=Math.sqrt(xDistance*xDistance+
yDistance*yDistance);if(leastDistance===null||distance<leastDistance){leastDistance=distance;foundIndex=i;}}
return foundIndex;},start:function(){this.element.addEventListener('click',this.clickIcon);this.element.addEventListener('collection-launch',this.onCollectionLaunch);this.element.addEventListener('collection-close',this.onCollectionClose);window.addEventListener('visibilitychange',this.onVisibilityChange);},stop:function(){this.element.removeEventListener('click',this.clickIcon);this.element.removeEventListener('collection-launch',this.onCollectionLaunch);this.element.removeEventListener('collection-close',this.onCollectionClose);window.removeEventListener('visibilitychange',this.onVisibilityChange);},findItemFromElement:function(element,excludeCollapsedIcons){while(element&&element.parentNode!==this.element){element=element.parentNode;}
if(!element){return null;}
var i,iLen=this.items.length;var identifier=element.dataset.identifier;var icon=this.icons[identifier];if(!icon){for(i=0;i<iLen;i++){if(this.items[i].element===element){icon=this.items[i];break;}}}
if(icon&&excludeCollapsedIcons){if(icon.detail.type!=='divider'&&icon.detail.type!=='placeholder'&&icon.element.classList.contains('collapsed')){for(i=icon.detail.index+1;i<iLen;i++){if(this.items[i].detail.type==='divider'){return this.items[i];}}
console.warn('Collapsed icon found with no group');icon=null;}}
return icon;},onVisibilityChange:function(){this._launchingApp=false;},onCollectionLaunch:function(){this._collectionOpen=true;},onCollectionClose:function(){this._collectionOpen=false;},clickIcon:function(e){e.preventDefault();var inEditMode=this.dragdrop&&this.dragdrop.inEditMode;var action='launch';if(e.target.classList.contains('remove')){action='remove';}
var icon=this.findItemFromElement(e.target);if(!icon){return;}
if(action==='launch'){if(inEditMode&&e.target.classList.contains('icon')){if(!icon.isEditable()){return;}
action='edit';}else{if(!icon[action]){return;}
icon.element.classList.add('launching');var returnTimeout=500;setTimeout(function stateReturn(){if(icon.element){icon.element.classList.remove('launching');}},returnTimeout);}}
if((icon.detail.type==='app'||icon.detail.type==='bookmark')&&this._launchingApp){return;}
if((icon.detail.type==='app'&&icon.appState==='ready')||icon.detail.type==='bookmark'){this._launchingApp=true;if(this._launchingTimeout){window.clearTimeout(this._launchingTimeout);this._launchingTimeout=null;}
this._launchingTimeout=window.setTimeout(function(){this._launchingTimeout=null;this._launchingApp=false;}.bind(this),APP_LAUNCH_TIMEOUT);}
icon[action](e.target);},cleanItems:function(skipDivider){var appCount=0;var toRemove=[];this.items.forEach(function(item,idx){if(item instanceof GaiaGrid.Divider){if(appCount===0){toRemove.push(idx);}
appCount=0;}else{appCount++;}},this);toRemove.reverse();toRemove.forEach(function(idx){var removed=this.items.splice(idx,1)[0];removed.remove();},this);if(skipDivider){return;}
var lastItem=this.items[this.items.length-1];if(!lastItem||!(lastItem instanceof GaiaGrid.Divider)){this.items.push(new GaiaGrid.Divider());}},removeAllPlaceholders:function(){var toSplice=[];var previousItem;this.items.forEach(function(item,idx){if(item instanceof GaiaGrid.Placeholder){if((!previousItem||(previousItem&&previousItem instanceof GaiaGrid.Divider))&&this.dragdrop&&this.dragdrop.inDragAction){return;}
toSplice.push(idx);}
previousItem=item;},this);toSplice.reverse().forEach(function(idx){this.items.splice(idx,1)[0].remove();},this);},clear:function(){for(var i=0,iLen=this.items.length;i<iLen;i++){var item=this.items[i];if(item.element){this.element.removeChild(item.element);item.element=null;item.lastX=null;item.lastY=null;item.lastScale=null;}}
this.items=[];this.icons={};},createPlaceholders:function(coordinates,idx,count){var isRTL=(document.documentElement.dir==='rtl');for(var i=0;i<count;i++){var item=new GaiaGrid.Placeholder();this.items.splice(idx+i,0,item);item.setPosition(idx+i);var xPosition=(coordinates[0]+i)*this.layout.gridItemWidth;if(isRTL){xPosition=(this.layout.constraintSize-this.layout.gridItemWidth)-
xPosition;}
item.setCoordinates(xPosition,this.layout.offsetY);item.render();}},render:function(options){var self=this;options=options||{};this.removeAllPlaceholders();this.cleanItems(options.skipDivider);var oldHeight=this.layout.offsetY;this.layout.offsetY=0;var x=0;var y=0;function step(item){var pixelHeight=item.pixelHeight;self.layout.stepYAxis(pixelHeight);x=0;y++;}
var pendingCachedIcons=0;var onCachedIconRendered=()=>{if(--pendingCachedIcons<=0){this.element.removeEventListener('cached-icon-rendered',onCachedIconRendered);this.element.dispatchEvent(new CustomEvent('cached-icons-rendered'));}};this.element.addEventListener('cached-icon-rendered',onCachedIconRendered);var nextDivider=null;var oddDivider=true;var isRTL=(document.documentElement.dir==='rtl');for(var idx=0;idx<=this.items.length-1;idx++){var item=this.items[idx];if(options.rerender&&item.element){this.element.removeChild(item.element);item.element=null;}
if(item.detail.type==='divider'){nextDivider=null;}else{if(!nextDivider){for(var i=idx+1;i<this.items.length;i++){if(this.items[i].detail.type==='divider'){nextDivider=this.items[i];oddDivider=!oddDivider;break;}}
if(nextDivider&&!nextDivider.detail.collapsed){this.layout.offsetY+=nextDivider.headerHeight;}}
if(nextDivider&&nextDivider.detail.collapsed){item.setPosition(idx);continue;}}
if(x>0&&item.gridWidth>1&&x+item.gridWidth>=this.layout.cols){var remaining=this.layout.cols-x;this.createPlaceholders([x,y],idx,remaining);idx+=remaining;item=this.items[idx];var lastItemInRow=this.items[idx-1];step(lastItemInRow);}
item.setPosition(idx);if(!options.skipItems){item.hasCachedIcon&&++pendingCachedIcons;var xPosition=x*this.layout.gridItemWidth;if(isRTL){xPosition=(this.layout.constraintSize-this.layout.gridItemWidth)-
xPosition;}
item.setCoordinates(xPosition,this.layout.offsetY);if(!item.active){item.render();}
if(item.detail.type==='divider'){if(oddDivider){item.element.classList.add('odd');}else{item.element.classList.remove('odd');}}}
x+=item.gridWidth;if(x>=this.layout.cols){step(item);}}
if(this.layout.offsetY!=oldHeight){if(this.dragdrop&&this.dragdrop.inDragAction){this.layout.offsetY=oldHeight;}else{this.element.dispatchEvent(new CustomEvent('gaiagrid-resize',{detail:this.layout.offsetY}));}}
this.element.setAttribute('cols',this.layout.cols);pendingCachedIcons===0&&onCachedIconRendered();this.loadDragDrop();},loadDragDrop:function(){if(!this.dragdrop&&this.config.features.dragdrop){LazyLoader.load('shared/elements/gaia_grid/js/grid_dragdrop.js',()=>{if(this.dragdrop){return;}
this.dragdrop=new GridDragDrop(this);});}}};exports.GridView=GridView;}(window));;window.GaiaGrid=(function(win){'use strict';var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaGridBaseurl||'/shared/elements/gaia_grid/';proto.createdCallback=function(){var shadow=this.createShadowRoot();this._template=template.content.cloneNode(true);this._styleHack();this._grid=new GridView({element:this,features:{dragdrop:this.getAttribute('dragdrop')!==null,zoom:this.getAttribute('zoom')!==null,disableSections:this.getAttribute('disable-sections')!==null}});shadow.appendChild(this._template);};proto.add=function(){this._grid.add.apply(this._grid,arguments);};proto.clear=function(){this._grid.clear.apply(this._grid,arguments);};proto.render=function(){this._grid.layout.calculateSize();this._grid.render.apply(this._grid,arguments);};proto.start=function(){this._grid.start.apply(this._grid,arguments);};proto.stop=function(){this._grid.stop.apply(this._grid,arguments);};proto.getIcons=function(){return this._grid.icons;};proto.getItems=function(){return this._grid.items;};proto.getIcon=function(identifier){return this._grid.icons[identifier];};proto.removeIconByIdentifier=function(identifier){delete this._grid.icons[identifier];};proto.removeItemByIndex=function(itemIndex){this._grid.items.splice(itemIndex,1);};proto.popDivider=function(){var items=this._grid.items;if(items.length&&items[items.length-1].detail.type==='divider'){return items.pop();}
return null;};proto.appendItem=function(item){var items=this._grid.items;var lastIndex=items.length-1;if(items[lastIndex].detail.type==='divider'){this.add(item,lastIndex);}else{this.add(item);}};proto.appendItemToExpandedGroup=function(item){var items=this._grid.items;var lastIndex=items.length-1;if(items[lastIndex].detail.type==='divider'&&items[lastIndex].detail.collapsed){items[lastIndex].expand();}
this.appendItem(item);};proto.setEditHeaderElement=function(element){if(this._grid.dragdrop){this._grid.dragdrop.editHeaderElement=element;}};Object.defineProperty(proto,'maxIconSize',{get:function(){return this._grid.layout.gridMaxIconSize;}});proto.getIndexLastIcon=function(){var items=this._grid.items;for(var i=this._grid.items.length-1;i>=0;i--){if(items[i]instanceof GaiaGrid.Mozapp){return i;}}};proto.removeNonVisualElements=function(){var nonVisualElements=[GaiaGrid.Placeholder];function isNonVisual(elem){var retVal=false;for(var i=0,iLen=nonVisualElements.length;i<iLen&&!retVal;i++){retVal=elem instanceof nonVisualElements[i];}
return retVal;}
var i=0;var iLen=this._grid.items.length;while(i<iLen){this._grid.items[i].detail.index=i;if(isNonVisual(this._grid.items[i])){this._grid.items.splice(i,1);iLen-=1;}else{i+=1;}}};proto.moveTo=function(orig,dst){this._grid.items.splice(dst,0,this._grid.items.splice(orig,1)[0]);};proto._styleHack=function(){var style=this._template.querySelector('style');this.appendChild(style.cloneNode(true));};var stylesheet=baseurl+'style.css';var template=document.createElement('template');template.innerHTML=`<style scoped>
    @import url(${stylesheet});</style>
    <content></content>`;return document.registerElement('gaia-grid',{prototype:proto});})(window);;'use strict';(function(exports){const ICON_BLOB_DECORATED_EVENT='iconblobdecorated';const ICON_BLOB_ERROR_EVENT='gaiagrid-iconbloberror';const FETCH_XHR_TIMEOUT=10000;function fetchBlob(uri){return new Promise(function(accept,reject){var xhr=new XMLHttpRequest({mozAnon:true,mozSystem:true});xhr.open('GET',uri,true);xhr.responseType='blob';xhr.timeout=FETCH_XHR_TIMEOUT;xhr.send();xhr.onload=function(){var status=xhr.status;if(status!==0&&status!==200){reject(new Error('Got HTTP status '+status+' trying to load '+uri));return;}
accept(xhr.response);};xhr.onerror=xhr.ontimeout=function(){reject(new Error('Error while HTTP GET: ',uri));};});}
function GridItem(){this.detail={};}
GridItem.prototype={x:0,y:0,pixelHeight:0,gridWidth:1,scale:1,persistToDB:true,lastX:null,lastY:null,lastScale:null,get hasCachedIcon(){return this.detail&&this.detail.decoratedIconBlob;},renderer:GridIconRenderer.TYPE.STANDARD,iconState:'none',get defaultIcon(){return'/shared/elements/gaia_grid/images/default_icon.png';},get grid(){return document.getElementsByTagName('gaia-grid')[0]._grid;},isRemovable:function(){return false;},isEditable:function(){return false;},isDraggable:function(){return true;},isIconFromOrigin:function(){return this.icon.startsWith('http')||this.icon.startsWith('app:');},setPosition:function(position){this.detail.index=position;},setCoordinates:function(x,y){this.x=x;this.y=y;},requestAttention:function(){var rect={x:this.x,y:this.y,width:this.gridWidth*this.grid.layout.gridItemWidth,height:this.pixelHeight};this.grid.element.dispatchEvent(new CustomEvent('gaiagrid-attention',{detail:rect}));},closestIconFromList:function(choices){if(!choices){return this.defaultIcon;}
var list=Object.keys(choices).map(function(size){return size;}).sort(function(a,b){return b-a;});var length=list.length;if(length===0){return this.defaultIcon;}
var maxSize=this.grid.layout.gridMaxIconSize;var accurateSize=list[0];for(var i=0;i<length;i++){var size=list[i];if(size<maxSize){break;}
accurateSize=size;}
var icon=choices[accurateSize];if(!UrlHelper.hasScheme(icon)){icon=this.app.origin+icon;}
return icon;},renderIconFromSrc:function(url){var background=new Image();background.src=url;background.onload=this._decorateIcon.bind(this,background);},renderIconFromBlob:function(blob){var background=new Image();background.src=URL.createObjectURL(blob);background.onload=()=>{this._decorateIcon(background);URL.revokeObjectURL(background.src);};background.onerror=()=>{URL.revokeObjectURL(background.src);if(this.hasCachedIcon){this._stampElementWithIcon('blobcache');this._displayDecoratedIcon(this.detail.decoratedIconBlob,true);return;}
this.renderIconFromSrc(this.defaultIcon);this._stampElementWithIcon(this.defaultIcon);};},_decorateIcon:function(img){var strategy=this.detail.renderer||this.renderer;this.rendererInstance=new GridIconRenderer(this);this.rendererInstance[strategy](img).then(this._displayDecoratedIcon.bind(this));},_displayDecoratedIcon:function(blob,isCachedIcon){if(!this.element){return;}
var style=this.element.style;if(!style.backgroundSize){style.height=this.grid.layout.gridItemHeight+'px';var backgroundHeight=((this.grid.layout.gridIconSize*(1/this.grid.layout.percent))+
GridIconRenderer.prototype.unscaledCanvasPadding);if(this.grid.layout.gridItemHeight>backgroundHeight){style.backgroundSize=backgroundHeight+'px';}else{style.backgroundSize=style.height;}}
if(isCachedIcon){var url=URL.createObjectURL(blob);style.backgroundImage='url('+url+')';this.element.dataset.backgroundImage=url;var img=new Image();img.onload=img.onerror=()=>{this.grid.element.dispatchEvent(new CustomEvent('cached-icon-rendered'));};img.src=url;return;}
this._compareBlobs(blob,this.detail.decoratedIconBlob).then((equal)=>{if(equal){return;}
style.backgroundImage='url('+URL.createObjectURL(blob)+')';this.detail.decoratedIconBlob=blob;this.grid.element.dispatchEvent(new CustomEvent(ICON_BLOB_DECORATED_EVENT,{detail:this}));var bgImg=this.element.dataset.backgroundImage;bgImg&&URL.revokeObjectURL(bgImg);});},_compareBlobs:function(blob1,blob2){return new Promise(function(resolve){if(!blob1||!blob2||blob1.type!==blob2.type||blob1.size!==blob2.size){resolve(false);return;}
var startBytes=127;var bytesHash=16;var reader=new FileReader();reader.onloadend=function(){var result1=reader.result;reader=new FileReader();reader.onloadend=reader.onerror=function(){resolve(result1===reader.result);};reader.readAsDataURL(blob2.slice(startBytes,startBytes+bytesHash));};reader.onerror=function(){resolve(false);};reader.readAsDataURL(blob1.slice(startBytes,startBytes+bytesHash));});},fetchIconBlob:function(){return fetchBlob(this.icon);},_stampElementWithIcon:function(uri){if(!this.element||uri.startsWith('data:')){return;}
if(uri.length>255){uri=uri.slice(0,255);}
this.element.dataset.testIcon=uri;},renderIcon:function(renderCachedIcon){var icon=this.icon;this.iconState='pending';if(renderCachedIcon&&this.hasCachedIcon){this._displayDecoratedIcon(this.detail.decoratedIconBlob,true);var resolveIcon=()=>{this.grid.element.removeEventListener('cached-icons-rendered',resolveIcon);this.doRenderIcon(icon);};this.grid.element.addEventListener('cached-icons-rendered',resolveIcon);}else{this.doRenderIcon(icon);}},doRenderIcon:function(icon){if(!this.isIconFromOrigin()){this._stampElementWithIcon(icon);this.renderIconFromSrc(icon);this.iconState='success';return Promise.resolve();}
var eventTarget=this.grid.element;var blobNotFound=()=>{this.iconState='error';if(!this.hasCachedIcon){this.renderIconFromSrc(this.defaultIcon);this._stampElementWithIcon(this.defaultIcon);}else{this._stampElementWithIcon('blobcache');}
eventTarget.dispatchEvent(new CustomEvent(ICON_BLOB_ERROR_EVENT,{detail:this}));};return this.fetchIconBlob().then((blob)=>{if(!blob){return blobNotFound();}
this.renderIconFromBlob(blob);this.iconState='success';this._stampElementWithIcon(icon);}).catch((err)=>{blobNotFound();});},removeFromGrid:function(){var idx=this.grid.items.indexOf(this);if(idx===-1){console.error('Attempting to remove self before item has been added!');return;}
this.grid.items.splice(idx,1);delete this.grid.icons[this.identifier];if(this.element){this.element.parentNode.removeChild(this.element);}
this.grid.render({from:idx-1});},remove:function(){this.grid.element.dispatchEvent(new CustomEvent('removeitem',{detail:this}));},render:function(){var scale=this.grid.layout.percent*this.scale;if(!this.element){var tile=document.createElement('div');tile.className='icon';tile.dataset.identifier=this.identifier;tile.dataset.isDraggable=this.isDraggable();tile.setAttribute('role','link');tile.style.width=(this.grid.layout.constraintSize/3)+'px';var nameContainerEl=document.createElement('p');nameContainerEl.style.marginTop=((this.grid.layout.gridIconSize*(1/this.grid.layout.percent))+
(GridIconRenderer.prototype.unscaledCanvasPadding/2))+'px';tile.appendChild(nameContainerEl);var nameEl=document.createElement('span');nameEl.className='title';nameEl.setAttribute('dir','auto');nameContainerEl.appendChild(nameEl);if(this.isRemovable()){var removeEl=document.createElement('span');removeEl.className='remove';tile.appendChild(removeEl);}
this.element=tile;this.updateTitle();this.renderIcon(true);this.grid.element.appendChild(tile);}
this.transform(this.x,this.y,scale);},transform:function(x,y,scale,element){scale=scale||1;if(!element){if(x===this.lastX&&y===this.lastY&&scale===this.lastScale){return;}
element=this.element;this.lastX=x;this.lastY=y;this.lastScale=scale;}
element.style.transform='translate('+x+'px,'+y+'px) scale('+scale+')';},setActive:function(active){if(active){this.element.classList.add('active');this.active=true;}else{this.element.classList.remove('active');this.active=false;}},updateTitle:function(){if(!this.element){return;}
var nameEl=this.element.querySelector('.title');if(this.asyncName){this.asyncName().then(function(name){nameEl.textContent=name;});}else{nameEl.textContent=this.name;}},updateFromDatastore:function(record){var iconChanged=record.icon!==this.icon;var nameChanged=record.name!==this.name;var type=this.detail.type;var lastIcon=this.icon;record.type=type;this.detail=record;if(nameChanged){this.updateTitle();}
if(iconChanged&&record.icon){this.renderIcon();}else if(!record.icon){this.detail.icon=lastIcon;}}};exports.GaiaGrid.GridItem=GridItem;}(window));;'use strict';(function(exports){const TYPE='bookmark';function Bookmark(record,features){this.detail=record;this.features=features||{};this.detail.type=TYPE;}
Bookmark.prototype={__proto__:GaiaGrid.GridItem.prototype,renderer:GridIconRenderer.TYPE.FAVICON,get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){return this.detail.name;},get icon(){return this.detail.icon||this.defaultIcon;},get identifier(){return this.detail.id;},update:GaiaGrid.GridItem.prototype.updateFromDatastore,isEditable:function(){return this.features&&this.features.isEditable!==false;},isRemovable:function(){return this.features&&this.features.isRemovable!==false;},isDraggable:function(){return this.features&&this.features.isDraggable!==false;},render:function(){GaiaGrid.GridItem.prototype.render.call(this);this.element.classList.add('bookmark');if(this.isEditable()){this.element.classList.add('editable');}},launch:function(){var features={name:this.name,icon:this.icon,remote:true};var url=this.detail.url;if(this.features.search){features.searchName=this.name;features.searchUrl=url;}
window.open(url,'_blank',Object.keys(features).map(function eachFeature(key){return encodeURIComponent(key)+'='+
encodeURIComponent(features[key]);}).join(','));},edit:function(){new MozActivity({name:'save-bookmark',data:{type:'url',url:this.detail.id}});}};exports.GaiaGrid.Bookmark=Bookmark;}(window));;'use strict';(function(exports){const l10nKey='collection-categoryId-';var _=navigator.mozL10n.get;function Collection(collection,entryPoint){this.collection=collection;this.detail={type:'collection',name:collection.name,id:collection.id,categoryId:collection.categoryId,cName:collection.cName,query:collection.query,icon:collection.icon,pinned:collection.pinned,decoratedIconBlob:collection.decoratedIconBlob,nonTranslatable:collection.nonTranslatable};window.addEventListener('localized',this.updateTitle.bind(this));}
Collection.prototype={__proto__:GaiaGrid.GridItem.prototype,renderer:GridIconRenderer.TYPE.CLIP,get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){if(this.detail.nonTranslatable){return this.detail.name;}
return _(l10nKey+this.detail.categoryId)||this.detail.name;},get icon(){return this.detail.icon||this.defaultIcon;},get identifier(){return this.detail.id;},update:GaiaGrid.GridItem.prototype.updateFromDatastore,render:function(){var setClassName=!this.element;GaiaGrid.GridItem.prototype.render.call(this);if(setClassName){this.element.classList.add('collection');this.isEditable()&&this.element.classList.add('editable');}},isEditable:function(){return true;},isRemovable:function(){return true;},launch:function(){this.grid.element.dispatchEvent(new CustomEvent('collection-launch'));var activity=new MozActivity({name:'view-collection',data:this.detail});activity.onsuccess=activity.onerror=()=>{this.grid.element.dispatchEvent(new CustomEvent('collection-close'));};},edit:function(){new MozActivity({name:'update-collection',data:this.detail});}};exports.GaiaGrid.Collection=Collection;}(window));;'use strict';(function(exports){function Divider(){this.detail={type:'divider',index:0};}
Divider.prototype={__proto__:GaiaGrid.GridItem.prototype,x:0,y:0,headerHeight:0,get pixelHeight(){return(this.grid.layout.cols>3)?50:60;},gridWidth:4,scale:1,render:function(){if(!this.element){var divider=this.element=document.createElement('section');divider.className='divider';var span=document.createElement('span');span.className='spacer';divider.appendChild(span);this.grid.element.appendChild(divider);}
this.element.style.transform='translate(0 ,'+this.y+'px)';},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}},isDraggable:function(){return false;}};exports.GaiaGrid.Divider=Divider;}(window));;'use strict';(function(exports){const IDENTIFIER_SEP='-';var MOZAPP_EVENTS=['downloadsuccess','downloaderror','downloadavailable','downloadapplied','progress'];var APP_LOADING='loading';var APP_ERROR='error';var APP_UNRECOVERABLE='unrecoverable';var APP_PAUSED='paused';var APP_READY='ready';function localizeString(str){var userLang=document.documentElement.lang;if(navigator.mozL10n&&userLang in navigator.mozL10n.qps){return navigator.mozL10n.qps[userLang].translate(str);}
return str;}
function Mozapp(app,entryPoint,details){this.app=app;this.entryPoint=entryPoint;this.detail={type:'app',manifestURL:app.manifestURL,entryPoint:entryPoint,index:0,decoratedIconBlob:details&&details.decoratedIconBlob};MOZAPP_EVENTS.forEach(function(type){this.app['on'+type]=this.handleEvent.bind(this);},this);this.setAppState(this._determineState(app));}
Mozapp.HIDDEN_ROLES=['system','input','homescreen','search','addon','langpack'];Mozapp.prototype={__proto__:GaiaGrid.GridItem.prototype,_isHiddenRole:function(){var manifest=this.app.manifest;if(!manifest||!manifest.role){return null;}
return Mozapp.HIDDEN_ROLES.indexOf(manifest.role)!==-1;},_determineState:function(app){if(app.installState==='pending'&&!app.downloadAvailable&&!app.readyToApplyDownload){return APP_UNRECOVERABLE;}
if(app.downloading){return APP_LOADING;}
if(app.downloadError&&app.downloadError.name){if(app.downloadError.name==='DOWNLOAD_CANCELED'){return APP_PAUSED;}
return APP_ERROR;}
if(app.installState==='pending'){return APP_PAUSED;}
return APP_READY;},handleEvent:function(event){switch(event.type){case'progress':case'downloaderror':case'downloadsuccess':this.setAppState(this._determineState(this.app));break;case'downloadapplied':if(this._isHiddenRole()){console.warn('Removing hidden app from the grid',this.name);return this.removeFromGrid();}
delete this._accurateIcon;this.setAppState(this._determineState(this.app));this.renderIcon();window.dispatchEvent(new CustomEvent('downloadapplied',{detail:{id:this.app.manifestURL}}));break;}},get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){var userLang=document.documentElement.lang;if(navigator.mozL10n&&userLang in navigator.mozL10n.qps){return navigator.mozL10n.qps[userLang].translate(this.descriptor.short_name||this.descriptor.name);}
var locales=this.descriptor.locales;var localized=locales&&locales[userLang]&&(locales[userLang].short_name||locales[userLang].name);return localized||this.descriptor.short_name||this.descriptor.name;},asyncName:function(){var userLang=document.documentElement.lang;var ep=this.entryPoint||undefined;return this.app.getLocalizedValue('short_name',userLang,ep).then(shortName=>localizeString(shortName),this.app.getLocalizedValue.bind(this.app,'name',userLang,ep)).then(name=>localizeString(name),()=>this.name);},get icon(){var icon=this._accurateIcon;if(!icon){icon=this._accurateIcon=this.closestIconFromList(this.descriptor.icons);}
return icon;},get descriptor(){var manifest=this.app.manifest||this.app.updateManifest;if(this.entryPoint&&manifest.entry_points&&manifest.entry_points[this.entryPoint]){return manifest.entry_points[this.entryPoint];}
return manifest;},identifierSeparator:IDENTIFIER_SEP,get identifier(){var identifier=[this.app.manifestURL];if(this.entryPoint){identifier.push(this.entryPoint);}
return identifier.join(IDENTIFIER_SEP);},isRemovable:function(){return this.app.removable;},unrecoverableError:function(){navigator.mozApps.mgmt.uninstall(this.app);},cancel:function(){var dialog=new ConfirmDialogHelper({type:'pause',title:{id:'gaia-grid-stop-download-title',args:{name:this.name}},body:'gaia-grid-stop-download-body',cancel:{title:'gaia-grid-cancel'},confirm:{title:'gaia-grid-stop-download-action',type:'danger',cb:()=>this.app.cancelDownload()}});dialog.show(document.body);},resume:function(){var dialog=new ConfirmDialogHelper({type:'resume',title:'gaia-grid-resume-download-title',body:{id:'gaia-grid-resume-download-body',args:{name:this.name}},cancel:{title:'gaia-grid-cancel'},confirm:{title:'gaia-grid-resume-download-action',cb:()=>{this.setAppState(APP_LOADING);this.app.download();}}});dialog.show(document.body);},setAppState:function(state){this.appState=state;if(this.element){this.element.dataset.appState=state;}},render:function(){var needsStateSet=!this.element;GaiaGrid.GridItem.prototype.render.apply(this,arguments);if(needsStateSet){this.setAppState(this.appState);}},launch:function(){var app=this.app;switch(this._determineState(app)){case APP_UNRECOVERABLE:return this.unrecoverableError();case APP_ERROR:case APP_PAUSED:return this.resume();case APP_LOADING:return this.cancel();}
var appContext=app.manifestURL.replace('app://','').replace('/manifest.webapp','');window.performance.mark('appLaunch@'+appContext);if(this.entryPoint){return app.launch(this.entryPoint);}
return app.launch();}};exports.GaiaGrid.Mozapp=Mozapp;}(window));;'use strict';(function(exports){const COLLAPSE_RATIO=0.33;const COLLAPSED_GROUP_SIZE=6;const COLLAPSED_GROUP_MARGIN_LEFT=23;const COLLAPSED_GROUP_MARGIN_RIGHT=53;const TOGGLE_TIMEOUT=250;function Group(detail){this.detail=detail||{};this.detail.type='divider';this.detail.index=0;this.pendingCollapse=this.detail.collapsed=!!this.detail.collapsed;}
Group.prototype={__proto__:GaiaGrid.GridItem.prototype,gridWidth:4,get headerHeight(){return this.detail.collapsed?20:30;},pendingCollapse:false,pendingCollapseTimeout:null,backgroundHeight:0,lastBackgroundHeight:null,separatorHeight:0,collapseRatio:COLLAPSE_RATIO,get pixelHeight(){return this.detail.collapsed?this.backgroundHeight:this.separatorHeight;},get size(){var size=0;for(var i=this.detail.index-1,items=this.grid.items;i>=0&&items[i].detail.type!=='divider';i--){size++;}
return size;},_createElement:function(){var group=this.element=document.createElement('section');group.className='divider group newly-created';var span=document.createElement('span');span.className='background';group.appendChild(span);this.backgroundSpanElement=span;span=document.createElement('span');span.className='shadow';group.appendChild(span);this.shadowSpanElement=span;span=document.createElement('span');span.className='header';group.appendChild(span);this.headerSpanElement=span;span=document.createElement('span');span.className='gripper';this.headerSpanElement.appendChild(span);var button=document.createElement('button');button.className='toggle';button.dataset.l10nId='gaia-grid-toggle-expanded';this.headerSpanElement.appendChild(button);this.toggleElement=button;span=document.createElement('span');span.className='separator';group.appendChild(span);this.dividerSpanElement=span;this.dividerSpanElement.appendChild(document.createElement('span'));this.grid.element.appendChild(group);this.separatorHeight=this.dividerSpanElement.clientHeight;this.lastBackgroundHeight=null;},_renderChildren:function(nApps){var isRTL=(document.documentElement.dir==='rtl');if(!this.detail.collapsed){this.element.classList.remove('collapsed');return;}
this.element.classList.add('collapsed');var y=this.y;var index=this.detail.index;var width=Math.round((this.grid.layout.constraintSize-
COLLAPSED_GROUP_MARGIN_LEFT-COLLAPSED_GROUP_MARGIN_RIGHT)/COLLAPSED_GROUP_SIZE);var x=isRTL?(this.grid.layout.constraintSize-COLLAPSED_GROUP_MARGIN_RIGHT):COLLAPSED_GROUP_MARGIN_LEFT;y+=this.headerHeight;var maxGridItemWidth=this.grid.layout.constraintSize/this.grid.layout.minIconsPerRow;this.collapseRatio=(maxGridItemWidth/this.grid.layout.gridItemWidth)*COLLAPSE_RATIO;for(var i=index-nApps;i<index;i++){var item=this.grid.items[i];if(this.detail.collapsed){item.scale=this.collapseRatio;var itemVisible=(i-(index-nApps))<COLLAPSED_GROUP_SIZE;if(!itemVisible){item.setCoordinates(isRTL?x+width:x-width,y);}else{item.setCoordinates(x,y);x+=isRTL?-width:width;}
item.render();item.element.classList.add('collapsed');if(!itemVisible){item.element.classList.add('hidden');}}}},getRealYPosition:function(nApps){if(this.detail.collapsed){return this.y;}
return this.grid.items[this.detail.index-nApps].y-
this.headerHeight;},render:function(){var createdElements=false;if(!this.element){createdElements=true;this._createElement();}
var nApps=this.size;this._renderChildren(nApps);var y=this.getRealYPosition(nApps);if(y!==this.lastY){this.headerSpanElement.style.transform='translate(0px, '+y+'px)';}
if(this.toggleElement){var toggleLabel=this.detail.collapsed?'collapsed':'expanded';this.toggleElement.dataset.l10nId='gaia-grid-toggle-'+toggleLabel;}
if(this.detail.collapsed){this.backgroundHeight=Math.round(this.collapseRatio*this.grid.layout.gridIconSize*1.5);}else{var height=Math.ceil(nApps/this.grid.layout.cols);this.backgroundHeight=(height||1)*this.grid.layout.gridItemHeight;}
this.backgroundHeight+=this.headerHeight;if(y!=this.lastY||this.backgroundHeight!==this.lastBackgroundHeight){this.backgroundSpanElement.style.transform='translate(0px, '+y+'px) scale(1, '+this.backgroundHeight+')';this.shadowSpanElement.style.transform='translateY('+y+'px)';this.shadowSpanElement.style.height=this.backgroundHeight+'px';this.dividerSpanElement.style.transform='translate(0px, '+(y+this.backgroundHeight)+'px)';}
this.lastBackgroundHeight=this.backgroundHeight;this.lastY=y;this.backgroundHeight+=this.separatorHeight;if(createdElements){this.element.clientTop;this.element.classList.remove('newly-created');}},forEachItem:function(callback){var nApps=this.size;var index=this.detail.index;for(var i=index-nApps;i<index;i++){callback(this.grid.items[i]);}},setActive:function(active){GaiaGrid.GridItem.prototype.setActive.call(this,active);this.collapse();var callback=active?function(item){item.element.classList.add('active');}:function(item){item.element.classList.remove('active');};this.forEachItem(callback);},_rerenderOnToggle:function(){if(this.pendingCollapseTimeout){clearTimeout(this.pendingCollapseTimeout);this.pendingCollapseTimeout=null;}
if(this.toggleElement){this.toggleElement.classList.add('toggling');setTimeout(()=>{this.toggleElement.classList.remove('toggling');},TOGGLE_TIMEOUT);}
this.pendingCollapseTimeout=setTimeout(()=>{this.detail.collapsed=this.pendingCollapse;this.pendingCollapseTimeout=null;if(!this.detail.collapsed){this.forEachItem(function(item){item.scale=1;if(item.element){item.element.classList.remove('collapsed');item.element.classList.remove('hidden');}});}
if(this.active){this.render();}
this.grid.render();var dragging=this.grid.dragdrop&&this.grid.dragdrop.inDragAction;if(dragging){this.grid.dragdrop.updateIconPosition();}else{window.dispatchEvent(new CustomEvent('gaiagrid-saveitems'));this.requestAttention();}},20);},collapse:function(){if(this.detail.collapsed){return;}
this.pendingCollapse=true;this._rerenderOnToggle();},expand:function(){if(!this.detail.collapsed){return;}
this.pendingCollapse=false;this._rerenderOnToggle();},launch:function(target){if(target!==this.toggleElement){return;}
if(this.detail.collapsed){this.expand();}else{this.collapse();}},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}},isDraggable:function(){return true;},requestAttention:function(){var rect={x:0,y:this.getRealYPosition(this.size),width:this.gridWidth*this.grid.layout.gridItemWidth,height:this.backgroundHeight};this.grid.element.dispatchEvent(new CustomEvent('gaiagrid-attention',{detail:rect}));}};exports.GaiaGrid.Divider=Group;}(window));;'use strict';(function(exports){function Placeholder(){this.detail={type:'placeholder',index:0};}
Placeholder.prototype={__proto__:GaiaGrid.GridItem.prototype,get pixelHeight(){return this.grid.layout.gridItemHeight;},createsGroupOnDrop:false,gridWidth:1,persistToDB:false,get name(){return'';},render:function(){if(!this.element){var tile=document.createElement('div');tile.className='icon placeholder';tile.style.height=this.pixelHeight+'px';this.element=tile;this.grid.element.appendChild(tile);}
this.transform(this.x,this.y,this.grid.layout.percent);},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}}};exports.GaiaGrid.Placeholder=Placeholder;}(window));;window.COMPONENTS_BASE_URL='/shared/elements/';;'use strict';(function(exports){const HIDDEN_ROLES=['system','input','homescreen','theme','addon','langpack'];const EDIT_MODE_TRANSITION_STYLE='transform 0.25s ease 0s, height 0s ease 0.5s';function App(){window.performance.mark('navigationLoaded');window.dispatchEvent(new CustomEvent('moz-chrome-dom-loaded'));this.grid=document.getElementById('icons');this.grid.addEventListener('iconblobdecorated',this);this.grid.addEventListener('gaiagrid-iconbloberror',this);this.grid.addEventListener('gaiagrid-attention',this);this.grid.addEventListener('gaiagrid-resize',this);this.grid.addEventListener('cached-icons-rendered',this);this.grid.addEventListener('edititem',this);this.grid.addEventListener('editmode-start',this);this.grid.addEventListener('editmode-end',this);window.addEventListener('hashchange',this);window.addEventListener('gaiagrid-saveitems',this);window.addEventListener('online',this.retryFailedIcons.bind(this));var editModeDone=document.getElementById('exit-edit-mode');editModeDone.addEventListener('click',this.exitEditMode);window.addEventListener('gaiagrid-dragdrop-begin',this);window.addEventListener('gaiagrid-dragdrop-finish',this);window.addEventListener('context-menu-open',this);window.addEventListener('context-menu-close',this);this.layoutReady=false;window.addEventListener('gaiagrid-layout-ready',this);this._iconsToRetry=[];window.performance.mark('navigationInteractive');window.dispatchEvent(new CustomEvent('moz-chrome-interactive'));}
App.prototype={HIDDEN_ROLES:HIDDEN_ROLES,EDIT_MODE_TRANSITION_STYLE:EDIT_MODE_TRANSITION_STYLE,retryFailedIcons:function(){if(!this._iconsToRetry.length){return;}
var icons=this.grid.getIcons();var iconId;while((iconId=this._iconsToRetry.shift())){var icon=icons[iconId];if(!icon){continue;}
icon.renderIcon();}},init:function(){this.itemStore=new ItemStore((firstTime)=>{if(!firstTime){return;}
LazyLoader.load(['shared/js/icc_helper.js','shared/js/version_helper.js','js/configurator.js'],function onLoad(){exports.configurator=new Configurator();});});this.itemStore.all(function _all(results){results.forEach(function _eachResult(result){this.grid.add(result);},this);if(this.layoutReady){this.renderGrid();}else{window.addEventListener('gaiagrid-layout-ready',function onReady(){window.removeEventListener('gaiagrid-layout-ready',onReady);this.renderGrid();}.bind(this));}
window.performance.mark('visuallyLoaded');window.dispatchEvent(new CustomEvent('moz-app-visually-complete'));window.performance.mark('contentInteractive');window.dispatchEvent(new CustomEvent('moz-content-interactive'));window.addEventListener('localized',this.onLocalized.bind(this));LazyLoader.load(['shared/elements/gaia-header/dist/gaia-header.js','js/contextmenu_handler.js','/shared/js/homescreens/confirm_dialog_helper.js'],function(){window.performance.mark('fullyLoaded');window.dispatchEvent(new CustomEvent('moz-app-loaded'));});}.bind(this));},renderGrid:function(){this.grid.setEditHeaderElement(document.getElementById('edit-header'));this.grid.render();},start:function(){this.grid.start();},stop:function(){this.grid.stop();},onLocalized:function(){var items=this.grid.getItems();items.forEach(function eachItem(item){if(!item.name){return;}
item.updateTitle();});this.renderGrid();},exitEditMode:function(e){e.preventDefault();window.dispatchEvent(new CustomEvent('hashchange'));},handleEvent:function(e){switch(e.type){case'cached-icons-rendered':window.dispatchEvent(new CustomEvent('gaiagrid-cached-icons-rendered'));break;case'iconblobdecorated':var item=e.detail;this.itemStore.saveItem(item.detail,()=>{item.element.classList.add('test-icon-cached');});break;case'edititem':var icon=e.detail;if(icon.detail.type!='divider'){return;}
LazyLoader.load('js/edit_group.js',()=>{groupEditor.edit(icon);});break;case'gaiagrid-iconbloberror':this._iconsToRetry.push(e.detail.identifier);break;case'gaiagrid-attention':var offsetTop=this.grid.offsetTop;var scrollTop=window.scrollY;var gridHeight=document.body.clientHeight;if(this.grid._grid.dragdrop.inEditMode){gridHeight-=offsetTop;}else{scrollTop-=offsetTop;}
var rect=e.detail;if(scrollTop+gridHeight<rect.y+rect.height){scrollTop=(rect.y+rect.height)-gridHeight;}
if(scrollTop>rect.y){scrollTop=rect.y;}
if(!this.grid._grid.dragdrop.inEditMode){scrollTop+=offsetTop;}
if(scrollTop!==window.scrollY){document.body.style.overflow='';requestAnimationFrame(()=>{requestAnimationFrame(()=>{window.scrollTo({left:0,top:scrollTop,behavior:'smooth'});});});}
break;case'gaiagrid-resize':var height=e.detail;var oldHeight=this.grid.clientHeight;if(this.gridResizeTimeout!==null){clearTimeout(this.gridResizeTimeout);this.gridResizeTimeout=null;}
if(height<oldHeight){var viewHeight=document.body.clientHeight;var scrollBottom=window.scrollY+viewHeight;var padding=window.getComputedStyle?parseInt(window.getComputedStyle(this.grid).paddingBottom):0;var maxScrollBottom=height+this.grid.offsetTop+padding;if(scrollBottom>=maxScrollBottom){requestAnimationFrame(()=>{requestAnimationFrame(()=>{window.scrollTo({left:0,top:maxScrollBottom-viewHeight,behavior:'smooth'});});});}}
if(height===oldHeight){break;}
this.grid.style.height=height+'px';break;case'gaiagrid-saveitems':this.itemStore.save(this.grid.getItems());break;case'gaiagrid-dragdrop-begin':case'context-menu-open':window.removeEventListener('hashchange',this);break;case'gaiagrid-dragdrop-finish':case'context-menu-close':window.addEventListener('hashchange',this);break;case'gaiagrid-layout-ready':this.layoutReady=true;window.removeEventListener('gaiagrid-layout-ready',this);break;case'editmode-start':this.grid.style.transition=this.EDIT_MODE_TRANSITION_STYLE;break;case'editmode-end':this.grid.style.transition='';break;case'hashchange':var editor=exports.groupEditor;if(editor&&!editor.hidden){return;}
var _grid=this.grid._grid;if(_grid.dragdrop&&_grid.dragdrop.inEditMode){_grid.dragdrop.exitEditMode();return;}
if(document.hidden){return;}
window.scrollTo({left:0,top:0,behavior:'smooth'});}}};exports.configurator={getSingleVariantApp:function(){return{};},get isSingleVariantReady(){return true;},get isSimPresentOnFirstBoot(){return false;},getItems:function(role){return{};}};exports.app=new App();exports.app.init();}(window));;(function(exports){'use strict';function Search(){this._port=null;this.connected=false;this.pendingRender=false;if(!appManager.app){window.addEventListener('appmanager-ready',function onReady(){window.removeEventListener('appmanager-ready',onReady);this.onAppReady();}.bind(this));}else{this.onAppReady();}
var input=document.getElementById('search');input.addEventListener('click',this.open.bind(this));input.addEventListener('contextmenu',(e)=>{e.stopPropagation();});}
Search.prototype={onAppReady:function onAppReady(){appManager.app.connect('search-results').then(function onConnectionAccepted(ports){ports.forEach(function(port){this._port=port;}.bind(this));this.connected=true;if(this.pendingRender){this.open();}}.bind(this),function onConnectionRejected(){});},open:function openRocketbar(e){window.scrollTo(0,0);e.stopPropagation();e.preventDefault();if(!this.connected){this.pendingRender=true;return;}
this._port.postMessage({action:'render'});}};exports.search=new Search();})(window);