;'use strict';(function(exports){var InputAppListSettings=function(){this._values={enable3rdPartyApps:undefined,dynamicInputs:undefined};this._bindCallback=null;this.ready=false;this._promise=null;};InputAppListSettings.prototype.onchange=null;InputAppListSettings.prototype.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED='keyboard.3rd-party-app.enabled';InputAppListSettings.prototype.SETTINGS_KEY_DYNAMIC_INPUTS='keyboard.dynamic-inputs';InputAppListSettings.prototype.start=function(){if(navigator.mozSettings){this._bindCallback=this.callback.bind(this);navigator.mozSettings.addObserver(this.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED,this._bindCallback);navigator.mozSettings.addObserver(this.SETTINGS_KEY_DYNAMIC_INPUTS,this._bindCallback);}
this.getSettings().then(function(){this.ready=true;}.bind(this));};InputAppListSettings.prototype.getSettings=function(){if(this.ready){return this.getSettingsSync();}
return this.getSettingsAsync();};InputAppListSettings.prototype.getSettingsSync=function(){if(!this.ready){console.warn('getSettingsSync: getSettingsSync called before ready.');}
return this._values;};InputAppListSettings.prototype.getSettingsAsync=function(){if(this._promise){return this._promise;}
var lock=navigator.mozSettings.createLock();var p=this._promise=Promise.all([lock.get(this.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED),lock.get(this.SETTINGS_KEY_DYNAMIC_INPUTS)]).then(function(values){this._values.enable3rdPartyApps=values[0][this.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED];this._values.dynamicInputs=values[1][this.SETTINGS_KEY_DYNAMIC_INPUTS];return this._values;}.bind(this)).catch(function(e){console.error('InputAppListSettings: Fail to get setting.',e);this._promise=null;this._values.enable3rdPartyApps=false;this._values.dynamicInputs={};return this._values;}.bind(this));return p;};InputAppListSettings.prototype.callback=function(obj){switch(obj.settingName){case this.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED:this._values.enable3rdPartyApps=obj.settingValue;break;case this.SETTINGS_KEY_DYNAMIC_INPUTS:this._values.dynamicInputs=obj.settingValue;break;}
if(typeof this.onchange==='function'){this.onchange(this._values);}};InputAppListSettings.prototype.stop=function(){this._values={enable3rdPartyApps:undefined,dynamicInputs:undefined};this.ready=false;this._promise=null;if(navigator.mozSettings){navigator.mozSettings.removeObserver(this.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED,this._bindCallback);navigator.mozSettings.removeObserver(this.SETTINGS_KEY_DYNAMIC_INPUTS,this._bindCallback);this._bindCallback=null;}};var InputAppList=function(){this.ready=false;this._inputApps=null;this.settings=null;this._getListPromise=null;};InputAppList.prototype.onready=null;InputAppList.prototype.onupdate=null;InputAppList.prototype.SETTINGS_KEY_THIRD_PARTY_APP_ENABLED='keyboard.3rd-party-app.enabled';InputAppList.prototype.start=function(){if(navigator.mozApps&&navigator.mozApps.mgmt){navigator.mozApps.mgmt.addEventListener('install',this);navigator.mozApps.mgmt.addEventListener('uninstall',this);}
this.settings=new InputAppListSettings();this.settings.onchange=this._refresh.bind(this);this.settings.start();this.getList().then(function(){this.ready=true;if(typeof this.onready==='function'){return this.onready(this._inputApps);}}.bind(this)).catch(function(e){console.error(e);});};InputAppList.prototype.getList=function(){if(this._getListPromise){return this._getListPromise;}
var p=this._getListPromise=Promise.all([this.settings.getSettings(),this._getAllApps()]).then(this._setInputApps.bind(this)).then(function(){return this._inputApps;}.bind(this)).catch(function(e){this._getListPromise=null;console.error(e);}.bind(this));return p;};InputAppList.prototype.getListSync=function(){if(!this.ready){console.warn('InputAppList: getListSync called when list is not ready.');}
return this._inputApps;};InputAppList.prototype.handleEvent=function(evt){var updated=false;switch(evt.type){case'install':var app=evt.application;if(app.downloading){app.addEventListener('downloadsuccess',this);return;}
updated=this._addInputApp(app);break;case'downloadsuccess':updated=this._addInputApp(evt.target);break;case'uninstall':updated=this._removeInputApp(evt.application);break;}
if(updated&&typeof this.onupdate==='function'){this.onupdate(this._inputApps);}};InputAppList.prototype.stop=function(){this.ready=false;this._inputApps=null;this.settings=null;this._getListPromise=null;if(navigator.mozApps&&navigator.mozApps.mgmt){navigator.mozApps.mgmt.removeEventListener('install',this);navigator.mozApps.mgmt.removeEventListener('uninstall',this);}};InputAppList.prototype._getAllApps=function(){if(!navigator.mozApps||!navigator.mozApps.mgmt){console.error('InputAppList: mozApps.mgmt not available.');return[];}
return Promise.resolve(navigator.mozApps.mgmt.getAll()).catch(function(e){console.error('InputAppList: Fail to get app list.',e);return[];});};InputAppList.prototype._setInputApps=function(values){var apps=values[1];var dynamicInputs=this.settings.getSettingsSync().dynamicInputs||{};var inputApps=apps.filter(this._isInputApp,this).map(function(inputApp){Object.keys(inputApp.manifest.inputs).forEach(function(inputId){if(inputApp.manifest.inputs[inputId].isDynamic){delete inputApp.manifest.inputs[inputId];}});if(inputApp.manifestURL in dynamicInputs){Object.keys(dynamicInputs[inputApp.manifestURL]).forEach(function(inputId){if(inputId in inputApp.manifest.inputs){return;}
inputApp.manifest.inputs[inputId]=dynamicInputs[inputApp.manifestURL][inputId];inputApp.manifest.inputs[inputId].isDynamic=true;});}
return inputApp;});if(inputApps.length===0){console.error('InputAppList: No input apps installed?');}
this._inputApps=inputApps;};InputAppList.prototype._addInputApp=function(app){if(!this._isInputApp(app)){return false;}
this._inputApps.push(app);return true;};InputAppList.prototype._removeInputApp=function(app){var index=this._inputApps.findIndex(function(appInList){return(appInList.manifestURL===app.manifestURL);});if(index===-1){return false;}
this._inputApps.splice(index,1);return true;};InputAppList.prototype._isInputApp=function(app){if(!app.manifest||'input'!==app.manifest.role){return false;}
if(app.manifest.type!=='certified'&&app.manifest.type!=='privileged'){return false;}
var settingValues=this.settings.getSettingsSync();if(!settingValues.enable3rdPartyApps&&app.manifest.type!=='certified'){console.warn('InputAppList: '+'A 3rd-party input app is installed but the feature is not enabled.',app.manifestURL);return false;}
if(app.manifest.permissions&&(typeof app.manifest.permissions.input!=='object')){return false;}
if(typeof app.manifest.inputs!=='object'){return false;}
return true;};InputAppList.prototype._refresh=function(){this._getListPromise=null;this.getList().then(function(){if(typeof this.onupdate==='function'){return this.onupdate(this._inputApps);}}.bind(this)).catch(function(e){console.error(e);});};exports.InputAppListSettings=InputAppListSettings;exports.InputAppList=InputAppList;}(window));;'use strict';(function(exports){var BASE_TYPES=new Set(['text','url','email','password','number','option']);var SETTINGS_KEYS={ENABLED:'keyboard.enabled-layouts',DEFAULT:'keyboard.default-layouts'};var DEPRECATE_KEYBOARD_SETTINGS={en:'keyboard.layouts.english','en-Dvorak':'keyboard.layouts.dvorak',cs:'keyboard.layouts.czech',fr:'keyboard.layouts.french',de:'keyboard.layouts.german',hu:'keyboard.layouts.hungarian',nb:'keyboard.layouts.norwegian',my:'keyboard.layouts.myanmar',sl:'keyboard.layouts.slovak',tr:'keyboard.layouts.turkish',ro:'keyboard.layouts.romanian',ru:'keyboard.layouts.russian',ar:'keyboard.layouts.arabic',he:'keyboard.layouts.hebrew','zh-Hant-Zhuyin':'keyboard.layouts.zhuyin','zh-Hans-Pinyin':'keyboard.layouts.pinyin',el:'keyboard.layouts.greek','jp-kanji':'keyboard.layouts.japanese',pl:'keyboard.layouts.polish','pt-BR':'keyboard.layouts.portuguese',sr:'keyboard.layouts.serbian',es:'keyboard.layouts.spanish',ca:'keyboard.layouts.catalan'};var MULTI_LAYOUT_MAP={sr:['sr-Cyrl','sr-Latn']};var defaultKeyboardManifestURL='app://keyboard.gaiamobile.org/manifest.webapp';var currentSettings={defaultLayouts:{}};currentSettings.defaultLayouts[defaultKeyboardManifestURL]={en:true,number:true};currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);function map2dIs(manifestURL,layoutId){return!!(this[manifestURL]&&this[manifestURL][layoutId]);}
function map2dSet(manifestURL,layoutId){if(!this[manifestURL]){this[manifestURL]={};}
this[manifestURL][layoutId]=true;}
function map2dUnset(manifestURL,layoutId){if(!this[manifestURL]){return;}
delete this[manifestURL][layoutId];if(!Object.keys(this[manifestURL]).length){delete this[manifestURL];}}
function map2dClone(obj){var result={};for(var key1 in obj){result[key1]={};for(var key2 in obj[key1]){result[key1][key2]=obj[key1][key2];}}
return result;}
var watchQueries=[];var defaultLayoutConfig;function kh_updateWatchers(reason){if(watchQueries.length){KeyboardHelper.getApps(function withApps(){watchQueries.forEach(function eachWatchQuery(watch){KeyboardHelper.getLayouts(watch.query,function withLayouts(layouts){watch.callback(layouts,reason);});});});}}
var waitingForSettings=[];var loadedSettings=new Set();function kh_loadedSetting(setting){loadedSettings.add(setting);if(loadedSettings.size>=Object.keys(SETTINGS_KEYS).length){waitingForSettings.forEach(function(callback){callback();});waitingForSettings=[];kh_updateWatchers({settings:true});}}
function kh_withSettings(callback){if(loadedSettings.size>=Object.keys(SETTINGS_KEYS).length){callback();}else{waitingForSettings.push(callback);}}
function kh_getSettings(){loadedSettings=new Set();var lock=window.navigator.mozSettings.createLock();lock.get(SETTINGS_KEYS.DEFAULT).onsuccess=kh_parseDefault;lock.get(SETTINGS_KEYS.ENABLED).onsuccess=kh_parseEnabled;}
function kh_parseDefault(){var value=this.result[SETTINGS_KEYS.DEFAULT];if(value){currentSettings.defaultLayouts=value;}
kh_loadedSetting(SETTINGS_KEYS.DEFAULT);}
function kh_parseEnabled(){var value=this.result[SETTINGS_KEYS.ENABLED];var needsSave=false;if(!value){currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);needsSave=true;}else{var type=typeof value;if(type==='string'){try{currentSettings.enabledLayouts={};var oldSettings=JSON.parse(value);oldSettings.forEach(function(layout){if(layout.enabled){var manifestURL=layout.manifestURL;if(!manifestURL)
manifestURL=layout.appOrigin+'/manifest.webapp';map2dSet.call(currentSettings.enabledLayouts,manifestURL,layout.layoutId);}});}catch(e){currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);needsSave=true;}}else{currentSettings.enabledLayouts=value;}}
kh_loadedSetting(SETTINGS_KEYS.ENABLED);if(needsSave){KeyboardHelper.saveToSettings();}}
function kh_migrateDeprecatedSettings(deprecatedSettings){var settingEntry=DEPRECATE_KEYBOARD_SETTINGS['en'];if(deprecatedSettings[settingEntry]==undefined){return;}
currentSettings.enabledLayouts[defaultKeyboardManifestURL]={number:true};var hasEnabledLayout=false;for(var key in DEPRECATE_KEYBOARD_SETTINGS){settingEntry=DEPRECATE_KEYBOARD_SETTINGS[key];if(deprecatedSettings[settingEntry]){hasEnabledLayout=true;if(key in MULTI_LAYOUT_MAP){MULTI_LAYOUT_MAP[key].forEach(function enableLayout(layoutId){map2dSet.call(currentSettings.enabledLayouts,defaultKeyboardManifestURL,layoutId);});}else{map2dSet.call(currentSettings.enabledLayouts,defaultKeyboardManifestURL,key);}}}
if(!hasEnabledLayout){map2dSet.call(currentSettings.enabledLayouts,defaultKeyboardManifestURL,'en');}
var deprecatedSettingsQuery={};for(var key in DEPRECATE_KEYBOARD_SETTINGS){settingEntry=DEPRECATE_KEYBOARD_SETTINGS[key];deprecatedSettingsQuery[settingEntry]=null;}
window.navigator.mozSettings.createLock().set(deprecatedSettingsQuery);KeyboardHelper.saveToSettings();}
function kh_loadJSON(href,callback){if(!callback)
return;var xhr=new XMLHttpRequest();xhr.onerror=function(){console.error('Failed to fetch file: '+href,xhr.statusText);};xhr.onload=function(){callback(xhr.response);};xhr.open('GET',href,true);xhr.responseType='json';xhr.send();}
function kh_getMultiSettings(settings,callback){var results={};try{var lock=navigator.mozSettings.createLock();}
catch(e){console.warn('Exception in mozSettings.createLock():',e,'\nUsing default values');for(var p in settings)
results[p]=settings[p];callback(results);}
var settingNames=Object.keys(settings);var numSettings=settingNames.length;var numResults=0;for(var i=0;i<numSettings;i++){requestSetting(settingNames[i]);}
function requestSetting(name){try{var request=lock.get(name);}
catch(e){console.warn('Exception querying setting',name,':',e,'\nUsing default value');recordResult(name,settings[name]);return;}
request.onsuccess=function(){var value=request.result[name];if(value===undefined){value=settings[name];}
recordResult(name,value);};request.onerror=function(evt){console.warn('Error querying setting',name,':',evt.error);recordResult(name,settings[name]);};}
function recordResult(name,value){results[name]=value;numResults++;if(numResults===numSettings){callback(results);}}}
function KeyboardLayout(options){for(var key in options){this[key]=options[key];}}
Object.defineProperties(KeyboardLayout.prototype,{'default':{get:function kh_getLayoutIsDefault(){return map2dIs.call(currentSettings.defaultLayouts,this.app.manifestURL,this.layoutId);}},enabled:{get:function kh_getLayoutIsEnabled(){return map2dIs.call(currentSettings.enabledLayouts,this.app.manifestURL,this.layoutId);},set:function kh_setLayoutIsDefault(value){var method=value?map2dSet:map2dUnset;method.call(currentSettings.enabledLayouts,this.app.manifestURL,this.layoutId);}}});var kh_SettingsHelper={};Object.defineProperties(kh_SettingsHelper,{'default':{get:function(){return map2dClone(currentSettings.defaultLayouts);},set:function(value){currentSettings.defaultLayouts=map2dClone(value);},enumerable:true},'enabled':{get:function(){return map2dClone(currentSettings.enabledLayouts);},set:function(value){currentSettings.enabledLayouts=map2dClone(value);},enumerable:true}});var KeyboardHelper=exports.KeyboardHelper={settings:kh_SettingsHelper,fallbackLayoutNames:{password:'en'},fallbackLayouts:{},inputAppList:null,init:function kh_init(){watchQueries=[];this.inputAppList=new InputAppList();this.inputAppList.onupdate=kh_updateWatchers.bind(undefined,{apps:true});this.inputAppList.start();var settings=window.navigator.mozSettings;if(settings){kh_getSettings();settings.addObserver(SETTINGS_KEYS.ENABLED,kh_getSettings);settings.addObserver(SETTINGS_KEYS.DEFAULT,kh_getSettings);var deprecatedSettingsQuery={};for(var key in DEPRECATE_KEYBOARD_SETTINGS){var settingEntry=DEPRECATE_KEYBOARD_SETTINGS[key];deprecatedSettingsQuery[settingEntry]=undefined;}
kh_getMultiSettings(deprecatedSettingsQuery,kh_migrateDeprecatedSettings);}
window.addEventListener('applicationinstallsuccess',this);},handleEvent:function(event){kh_updateWatchers({apps:true});},isKeyboardType:function kh_isKeyboardType(type){return BASE_TYPES.has(type);},setLayoutEnabled:function kh_setLayoutEnabled(manifestURL,layoutId,enabled){var method=enabled?map2dSet:map2dUnset;method.call(currentSettings.enabledLayouts,manifestURL,layoutId);},getLayoutEnabled:function kh_getLayoutEnabled(manifestURL,layoutId){return map2dIs.call(currentSettings.enabledLayouts,manifestURL,layoutId);},setLayoutIsDefault:function kh_setLayoutIsDefault(manifestURL,layoutId,enabled){var method=enabled?map2dSet:map2dUnset;method.call(currentSettings.defaultLayouts,manifestURL,layoutId);},getLayoutIsDefault:function kh_getLayoutIsDefault(manifestURL,layoutId){return map2dIs.call(currentSettings.defaultLayouts,manifestURL,layoutId);},checkDefaults:function kh_checkDefaults(callback){var layoutsEnabled=[];var missingTypes=[];['text','url','number'].forEach(function eachType(type){var enabled;this.getLayouts({type:type,enabled:true},function(layouts){enabled=layouts.length;});if(!enabled){missingTypes.push(type);this.getLayouts({type:type,'default':true},function(layouts){if(layouts[0]){layouts[0].enabled=true;layoutsEnabled.push(layouts[0]);}});}},this);if(layoutsEnabled.length){if(callback){callback(layoutsEnabled,missingTypes);}}},saveToSettings:function ke_saveToSettings(){var toSet={};toSet[SETTINGS_KEYS.ENABLED]=currentSettings.enabledLayouts;toSet[SETTINGS_KEYS.DEFAULT]=currentSettings.defaultLayouts;window.navigator.mozSettings.createLock().set(toSet);},getApps:function kh_getApps(callback){var cleanupSettings=function(inputApps){Object.keys(currentSettings.enabledLayouts).concat(Object.keys(currentSettings.defaultLayouts)).forEach(function(manifestURL){if(!inputApps.some(function(app){return app.manifestURL===manifestURL;})){delete currentSettings.enabledLayouts[manifestURL];delete currentSettings.defaultLayouts[manifestURL];}});};if(this.inputAppList.ready){var inputApps=this.inputAppList.getListSync();cleanupSettings(inputApps);callback(inputApps);return;}
this.inputAppList.getList().then(function(inputApps){cleanupSettings(inputApps);callback(inputApps);})['catch'](function(e){console.error(e);});},getLayouts:function kh_getLayouts(options,callback){if(typeof options==='function'){callback=options;options={};}
function withApps(apps){var fallbackLayoutNames={};for(var group in this.fallbackLayoutNames){fallbackLayoutNames[group]=this.fallbackLayoutNames[group];}
this.fallbackLayouts={};var layouts=apps.reduce(function eachApp(result,app){var manifest=new ManifestHelper(app.manifest);for(var layoutId in manifest.inputs){var inputManifest=manifest.inputs[layoutId];if(!inputManifest.types){console.warn(app.manifestURL,layoutId,'did not declare type.');continue;}
var layout=new KeyboardLayout({app:app,manifest:manifest,inputManifest:inputManifest,layoutId:layoutId});if(app.manifestURL===defaultKeyboardManifestURL){for(var group in fallbackLayoutNames){if(layoutId===fallbackLayoutNames[group]){this.fallbackLayouts[group]=layout;delete fallbackLayoutNames[group];}}}
if(options['default']&&!layout['default']){continue;}
if(options.enabled&&!layout.enabled){continue;}
if(options.type){options.type=[].concat(options.type);if(!options.type.some(function(type){return inputManifest.types.indexOf(type)!==-1;})){continue;}}
result.push(layout);}
if(options['default']){result.sort(function(a,b){return a.inputManifest.types.length-b.inputManifest.types.length;});}
return result;}.bind(this),[]);kh_withSettings(callback.bind(null,layouts));}
this.getApps(withApps.bind(this));},stopWatching:function(){watchQueries=[];},watchLayouts:function(query,callback){if(typeof query==='function'){callback=query;query={};}
var watch={query:query,callback:callback};watchQueries.push(watch);this.getLayouts(query,function initialCall(layouts){watch.layouts=layouts;callback(layouts,{apps:true,settings:true});});},getDefaultLayoutConfig:function kh_getDefaultLayoutConfig(callback){if(!callback){return;}
if(defaultLayoutConfig){callback(defaultLayoutConfig);}else{var KEYBOARDS='/shared/resources/keyboard_layouts.json';kh_loadJSON(KEYBOARDS,function loadKeyboardLayouts(data){if(data){defaultLayoutConfig=data;callback(defaultLayoutConfig);}});}},changeDefaultLayouts:function kh_changeDefaultLayouts(language,reset){this.getDefaultLayoutConfig(function gotDefaultLayouts(keyboards){var newKbLayouts=keyboards.layout[language];var kbManifestURL=defaultKeyboardManifestURL;currentSettings.defaultLayouts={};var langIndependentLayouts=keyboards.langIndependentLayouts;for(var i=langIndependentLayouts.length-1;i>=0;i--){this.setLayoutIsDefault(kbManifestURL,langIndependentLayouts[i].layoutId,true);}
if(reset){currentSettings.enabledLayouts=map2dClone(currentSettings.defaultLayouts);}
for(i=newKbLayouts.length-1;i>=0;i--){this.setLayoutIsDefault(kbManifestURL,newKbLayouts[i].layoutId,true);this.setLayoutEnabled(kbManifestURL,newKbLayouts[i].layoutId,true);}
this.saveToSettings();}.bind(this));}};KeyboardHelper.init();}(window));;'use strict';(function(exports){var LOCALES_FILE='/shared/resources/languages.json';function readFile(file,callback){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest();xhr.onreadystatechange=function loadFile(){if(xhr.readyState===4){if(xhr.status===0||xhr.status===200){resolve(xhr.response);}else{reject(xhr.statusText);}}};xhr.open('GET',file,true);xhr.responseType='json';xhr.send();});}
function onError(name){console.error('Error checking setting '+name);}
function readSetting(name,callback){var settings=window.navigator.mozSettings;if(!settings||!settings.createLock){return callback(null);}
return settings.createLock().get(name).then(function(res){return res[name];},onError.bind(null,name));}
exports.LanguageList={_languages:null,_readFile:readFile,_readSetting:readSetting,_extendPseudo:function(languages,currentLang,qpsEnabled){if(!navigator.mozL10n){return languages;}
for(var lang in navigator.mozL10n.qps){var isCurrent=(lang===currentLang);if(isCurrent||qpsEnabled){languages[lang]=navigator.mozL10n.qps[lang].name;}}
return languages;},_extendAdditional:function(languages,ver,additional){for(var lang in additional){for(var i=0,locale;locale=additional[lang][i];i++){if(locale.target===ver){languages[lang]=locale.name;break;}}}
return languages;},_parseVersion:function(ver){return ver.split('.').slice(0,2).join('.');},_build:function(){return Promise.all([this._languages||(this._languages=this._readFile(LOCALES_FILE)),this._readSetting('deviceinfo.os'),this._readSetting('language.current'),this._readSetting('devtools.qps.enabled'),navigator.mozApps.getAdditionalLanguages()]).then(function([langsFromFile,ver,current,qpsEnabled,addl]){var langs=Object.create(langsFromFile);this._extendPseudo(langs,current,qpsEnabled);this._extendAdditional(langs,this._parseVersion(ver),addl);return[langs,current];}.bind(this));},get:function(callback){if(!callback){return;}
this._build().then(Function.prototype.apply.bind(callback,null));},wrapBidi:function(langCode,langName){var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var lEmbedBegin=(rtlList.indexOf(langCode)>=0)?'\u202b':'\u202a';var lEmbedEnd='\u202c';return lEmbedBegin+langName+lEmbedEnd;}};}(window));;'use strict';(function(exports){function Version(str){str=str||'0.0';var parts=str.split('.');this.major=parts[0];this.minor=parts[1];this.toString=function(){return''+str;};}
function InfoResult(current,previous){this.current=current;this.previous=previous;}
InfoResult.prototype.isUpgrade=function(){var prev=this.previous,curr=this.current,isUpgrade=false;if(prev&&curr){isUpgrade=curr.major>prev.major||curr.minor>prev.minor;}
return isUpgrade;};InfoResult.prototype.delta=function(){var prev=this.previous,curr=this.current;var delta='';if(prev){delta+=prev.major+'.'+prev.minor;}
delta+='..';if(curr){delta+=curr.major+'.'+curr.minor;}
return delta;};function getSetting(setting,cb,errback){var req=navigator.mozSettings.createLock().get(setting);req.onsuccess=function(){var value=req.result[setting];if(typeof cb==='function'){cb(value);}};req.onerror=function(){if(typeof errback==='function'){errback(req.error);}};}
function getCurrent(){return new Promise(function(resolve,reject){getSetting('deviceinfo.os',function(value){resolve(value?new Version(value):null);},function(err){reject(err);});});}
function getPrevious(){return new Promise(function(resolve,reject){getSetting('deviceinfo.previous_os',function(value){resolve(value?new Version(value):null);},function(err){resolve(null);});});}
function updatePrevious(str){var currentPromise=str?Promise.resolve(new Version(str)):getCurrent();var setPromise=new Promise(function(resolve,reject){currentPromise.then(function(version){if(version){var req=navigator.mozSettings.createLock().set({'deviceinfo.previous_os':version.toString()});req.onsuccess=function(){resolve(version);};req.onerror=function(){var reason=req.error;reject(reason);};}else{resolve(null);}},function(err){reject('Error getting previous version: ',err);});});return setPromise;}
function getVersionInfo(){var info=new InfoResult();var infoPromise=new Promise(function(resolve,reject){Promise.all([getCurrent().then(function(version){info.current=version;}),getPrevious().then(function(version){info.previous=version;})]).then(function(){resolve(info);},reject);});return infoPromise;}
exports.VersionHelper={updatePrevious:updatePrevious,getVersionInfo:getVersionInfo};})(window);;'use strict';var utils=window.utils||{};utils.status=(function(){var STATUS_TIME=2000;var statusMsg=document.querySelector('#statusMsg');var hidingTimeout;var transitionEndTimeout;var additionalLine;var hideAnimationDone=function(){statusMsg.removeEventListener('transitionend',hideAnimationDone);statusMsg.classList.add('hidden');};var showAnimationDone=function(){if(transitionEndTimeout){clearTimeout(transitionEndTimeout);}
statusMsg.removeEventListener('transitionend',showAnimationDone);hidingTimeout=setTimeout(utils.status.hide,STATUS_TIME);};var hideStatus=function(){statusMsg.addEventListener('transitionend',hideAnimationDone);statusMsg.classList.remove('opening');statusMsg.classList.remove('bannerStart');statusMsg.querySelector('p').removeAttribute('data-l10n-id');if(additionalLine){statusMsg.removeChild(additionalLine);additionalLine=null;}};var setL10nAttributes=function(node,l10n){if(l10n&&l10n.id){navigator.mozL10n.setAttributes(node,l10n.id,l10n.args);return true;}else{console.error('Status arguments must be objects');return false;}};var showStatus=function(mainMessage,extra){statusMsg.removeEventListener('transitionend',showAnimationDone);statusMsg.removeEventListener('transitionend',hideAnimationDone);LazyLoader.load([statusMsg],function _loaded(){if(!setL10nAttributes(statusMsg.querySelector('p'),mainMessage)){return;}
if(extra){additionalLine=document.createElement('p');statusMsg.appendChild(additionalLine);setL10nAttributes(additionalLine,extra);}
if(statusMsg.classList.contains('opening')){clearTimeout(hidingTimeout);hidingTimeout=setTimeout(hideStatus,STATUS_TIME);return;}
statusMsg.classList.remove('hidden');statusMsg.addEventListener('transitionend',showAnimationDone);setTimeout(function displaying(){statusMsg.classList.add('opening');statusMsg.classList.add('bannerStart');transitionEndTimeout=setTimeout(showAnimationDone,STATUS_TIME);},10);});};return{show:showStatus,hide:hideStatus};})();;'use strict';var utils=window.utils||{};(function(){utils.overlay={};var overlay=document.querySelector('#loading-overlay'),statusContainer=overlay.querySelector('p[role="status"]'),progressActivity=document.querySelector('#progress-activity'),progressTitle=document.querySelector('#progress-title'),progressElement=document.querySelector('#progress-element'),progressMsg=document.querySelector('#progress-msg'),menu=document.querySelector('#loading-overlay menu'),cancelButton=document.querySelector('#cancel-overlay');function ProgressBar(pMsgId,pClass){var counter=0;var total=0;var progressTextId=pMsgId||'genericProgress';var clazz=pClass;progressElement.setAttribute('value',0);function showMessage(){navigator.mozL10n.setAttributes(progressMsg,progressTextId,{current:counter,total:total});}
this.update=function(value){if(value&&value<=total&&value>=counter){counter=value;}else{counter++;}
progressElement.setAttribute('value',((counter*100)/total).toFixed());showMessage();};this.setTotal=function(ptotal){total=ptotal;};this.setClass=function(clazzName){setClass(clazzName);clazz=clazzName;if(clazzName==='activityBar'||clazzName==='spinner'){progressMsg.removeAttribute('data-l10n-id');}};this.setHeaderMsg=function(headerMsgId){progressTitle.setAttribute('data-l10n-id',headerMsgId);};}
utils.overlay.isAnimationPlaying=false;utils.overlay.isShown=false;utils.overlay._show=function _show(messageId,progressClass,textId){progressActivity.classList.remove('hide');if(typeof messageId==='string'){progressTitle.setAttribute('data-l10n-id',messageId);}else{navigator.mozL10n.setAttributes(progressTitle,messageId.id,messageId.args);}
progressMsg.textContent=null;progressMsg.removeAttribute('data-l10n-id');if(utils.overlay.isShown){return;}
overlay.classList.remove('hide');overlay.classList.remove('fade-out');overlay.classList.add('fade-in');utils.overlay.isAnimationPlaying=true;window.dispatchEvent(new CustomEvent('loadingoverlayshowing'));overlay.addEventListener('animationend',function ov_onFadeIn(ev){utils.overlay.isAnimationPlaying=false;overlay.removeEventListener('animationend',ov_onFadeIn);overlay.classList.remove('no-opacity');utils.overlay.isShown=true;});};utils.overlay.show=function show(messageId,progressClass,textId){var out;out=new ProgressBar(textId,progressClass);setClass(progressClass);utils.overlay.hideMenu();if(!utils.overlay.isAnimationPlaying){utils.overlay._show(messageId,progressClass,textId);return out;}
overlay.addEventListener('animationend',function ov_showWhenFinished(ev){overlay.removeEventListener('animationend',ov_showWhenFinished);utils.overlay._show(messageId,progressClass,textId);});return out;};utils.overlay.showMenu=function showMenu(){menu.classList.add('showed');};utils.overlay.hideMenu=function hideMenu(){menu.classList.remove('showed');};Object.defineProperty(utils.overlay,'oncancel',{set:function(cancelCb){if(typeof cancelCb==='function'){cancelButton.disabled=false;cancelButton.onclick=function on_cancel(e){delete cancelButton.onclick;cancelCb();return false;};}}});function setAsProgress(){statusContainer.classList.remove('loading-icon');progressElement.setAttribute('max','100');progressElement.setAttribute('value','0');}
function setClass(clazzName){switch(clazzName){case'spinner':progressElement.classList.remove('pack-activity');statusContainer.classList.add('loading-icon');progressElement.removeAttribute('max');progressElement.removeAttribute('value');break;case'activityBar':case'progressActivity':progressElement.classList.add('pack-activity');setAsProgress();break;case'progressBar':progressElement.classList.remove('pack-activity');setAsProgress();break;}}
utils.overlay._hide=function ov__hide(){if(!utils.overlay.isShown){return;}
overlay.classList.remove('fade-in');overlay.classList.add('fade-out');utils.overlay.isAnimationPlaying=true;window.dispatchEvent(new CustomEvent('loadingoverlayhiding'));overlay.addEventListener('animationend',function ov_onFadeOut(ev){utils.overlay.isAnimationPlaying=false;overlay.removeEventListener('animationend',ov_onFadeOut);progressActivity.classList.add('hide');overlay.classList.add('no-opacity');overlay.classList.add('hide');utils.overlay.isShown=false;});};utils.overlay.hide=function ov_hide(){if(!utils.overlay.isAnimationPlaying){utils.overlay._hide();return;}
overlay.addEventListener('animationend',function ov_hideWhenFinished(ev){overlay.removeEventListener('animationend',ov_hideWhenFinished);utils.overlay._hide();});};})();;'use strict';var utils=window.utils||{};if(typeof utils.config==='undefined'){(function(){var configs={};var initializing={};var initialized={};var EVENT_INITIALIZED='config_initialized';utils.config=utils.config||{};utils.config.reset=function(){configs={};initializing={};initialized={};};function onLoad(xhr,file,resolveCb){configs[file]=xhr.response;delete initializing[file];initialized[file]=true;document.dispatchEvent(new CustomEvent(EVENT_INITIALIZED,{detail:{file:file,success:true}}));resolveCb(configs[file]);}
utils.config.load=function(file){return new Promise(function(resolve,reject){var isInitialized=initialized[file];if(isInitialized===true){resolve(configs[file]);return;}
var isInitializing=initializing[file];if(isInitializing){var handler=function(expectedFile,e){document.removeEventListener(EVENT_INITIALIZED,handler);var file=e.detail.file;if(expectedFile!==file){return;}
if(e.detail.success){resolve(configs[file]);}
else{reject();}}.bind(null,file);document.addEventListener(EVENT_INITIALIZED,handler);return;}
initializing[file]=true;var xhr=new XMLHttpRequest();xhr.open('GET',file,true);xhr.responseType='json';xhr.onload=function(){var resolvedCb=resolve;if(xhr.status!==200){resolvedCb=reject;}
onLoad(xhr,file,resolvedCb);};xhr.onerror=function(){document.dispatchEvent(new CustomEvent(EVENT_INITIALIZED,{detail:{file:file,success:false}}));delete initializing[file];reject(xhr.error);};try{xhr.send(null);}
catch(e){console.error('Error while loading config file: ',e.message);onLoad({status:404},file,reject);}});};})();};'use strict';var utils=window.utils||{};var SCALE_RATIO=window.devicePixelRatio||1;var LAST_IMPORT_TIMESTAMP_SUFFIX='_last_import_timestamp';function scale(size){return Math.round(SCALE_RATIO*size);}
if(!utils.misc){utils.misc={};utils.misc.toMozContact=function(contact){var outContact=contact;if(!(contact instanceof mozContact)){outContact=new mozContact(contact);outContact.id=contact.id||outContact.id;}
return outContact;};const FLAG_YEAR_IGNORED=9996;utils.misc.FLAG_YEAR_IGNORED=FLAG_YEAR_IGNORED;utils.misc.formatDate=function(date){var _=navigator.mozL10n.get;var dateFormat=_('dateFormat')||'%B %e';var f=new navigator.mozL10n.DateTimeFormat();var dateString=null;try{var offset=date.getTimezoneOffset()*60*1000;var normalizedDate=new Date(date.getTime()+offset);var year=normalizedDate.getFullYear();if(year===FLAG_YEAR_IGNORED){year='';}
var dayMonthString=f.localeFormat(normalizedDate,dateFormat);dateString=_('dateOutput',{dayMonthFormatted:dayMonthString,year:year});}catch(err){console.error('Error parsing date: ',err);throw err;}
return dateString;};utils.misc.parseName=function(nameString){var MIN_LENGHT_SIGNIFICATIVE=3;var MIN_LENGHT_FN=2;var out={givenName:'',familyName:''};if(!nameString){return out;}
var str=nameString.trim();if(!str){return out;}
function startsWithUpper(str){var firstLetter=str.charAt(0);var capFirstLetter=firstLetter.toLocaleUpperCase();return(capFirstLetter===firstLetter);}
var tokens=nameString.split(/\s+/);var significativeTokens={};for(var j=0;j<tokens.length;j++){var token=tokens[j];if(token.length>MIN_LENGHT_SIGNIFICATIVE||startsWithUpper(token)){significativeTokens[token]=true;}}
var totalTokens=tokens.length;var lastToken=totalTokens-1;var rolePrevToken;var remainingTokens=Object.keys(significativeTokens).length;var outGivenNames=[],outFamilyNames=[];var numFns=0;while(lastToken>=0){if(significativeTokens[tokens[lastToken]]){remainingTokens--;}
var currToken=tokens[lastToken],nextToken=tokens[lastToken+1],prevToken=tokens[lastToken-1];if(!nextToken&&prevToken){outFamilyNames.push(currToken);numFns++;rolePrevToken='FN';}
else if(!prevToken){outGivenNames.push(currToken);rolePrevToken='GN';}
else if(nextToken){if(!significativeTokens[currToken]){if(rolePrevToken==='FN'){outFamilyNames.push(currToken);}
else{outGivenNames.push(currToken);}}
else if(currToken.length<MIN_LENGHT_FN){outGivenNames.push(currToken);rolePrevToken='GN';}
else{if(remainingTokens>=2&&numFns<2){outFamilyNames.push(currToken);numFns++;rolePrevToken='FN';}
else{outGivenNames.push(currToken);rolePrevToken='GN';}}}
lastToken--;}
out.givenName=outGivenNames.reverse().join(' ').trim();out.familyName=outFamilyNames.reverse().join(' ').trim();return out;};utils.misc.getPreferredPictureBox=function(){var imgThumbSize=oauthflow.params.facebook.imgThumbSize;var out={width:scale(imgThumbSize)};out.height=out.width;return out;};utils.misc.getPreferredPictureDetail=function(){var imgDetailWidth=oauthflow.params.facebook.imgDetailWidth;return scale(imgDetailWidth);};utils.misc.setTimestamp=function(type,callback){ImportStatusData.put(type+LAST_IMPORT_TIMESTAMP_SUFFIX,Date.now()).then(callback);};utils.misc.getTimestamp=function(type,callback){ImportStatusData.get(type+LAST_IMPORT_TIMESTAMP_SUFFIX).then(callback);};};'use strict';var utils=window.utils||{};if(!utils.sdcard){var SdCard=utils.sdcard={NOT_INITIALIZED:0,NOT_AVAILABLE:1,AVAILABLE:2,SHARED:3,observers:{}};SdCard.status=SdCard.NOT_INITIALIZED;SdCard.deviceStorages=navigator.getDeviceStorages('sdcard');SdCard.deviceStorage=Array.isArray(SdCard.deviceStorages)&&SdCard.deviceStorages[0];SdCard._toStatus=function toStatus(state){switch(state){case'available':SdCard.status=SdCard.AVAILABLE;break;case'shared':SdCard.status=SdCard.SHARED;break;case'unavailable':case'deleted':SdCard.status=SdCard.NOT_AVAILABLE;break;}};SdCard.updateStorageState=function sd_updateStorageState(state){SdCard._toStatus(state);Object.keys(this.observers).forEach(function onObserver(name){if(typeof(SdCard.observers[name])==='function'){SdCard.observers[name].call(null,state);}});};if(SdCard.deviceStorage){SdCard.deviceStorage.addEventListener('change',function sd_deviceStorageChangeHandler(e){SdCard.updateStorageState(e.reason);});if(SdCard.status===SdCard.NOT_INITIALIZED){SdCard.deviceStorage.available().onsuccess=(function(e){SdCard.updateStorageState(e.target.result);});}}
SdCard.checkStorageCard=function sd_checkStorageCard(){return SdCard.status===SdCard.AVAILABLE;};SdCard.getStatus=function(cb){if(!SdCard.deviceStorage){SdCard._toStatus('unavailable');cb(SdCard.status);return;}
var req=SdCard.deviceStorage.available();req.onsuccess=function(){SdCard._toStatus(req.result);cb(SdCard.status);};req.onerror=function(){console.error('Error while determining SD Status',req.error.name);cb(SdCard.status);};};SdCard.retrieveFiles=function retrieveFilesContent(mimes,exts,cb){var fileArray=[];var storages=navigator.getDeviceStorages('sdcard');var numberOfStorages=storages.length;var currentStorage=0;var cursorOnError=function(){cb(this.error.name);};var cursorOnSuccess=function(e){var file=e.target.result;if(!file){if(++currentStorage<numberOfStorages){cursor=storages[currentStorage].enumerate();cursor.onsuccess=cursorOnSuccess;cursor.onerror=cursorOnError;}else{cb(null,fileArray);}}else{if((mimes.indexOf(file.type)===-1)&&file.name.search(new RegExp('.('+exts.join('|')+')$'))===-1){cursor.continue();}else{fileArray.push(file);cursor.continue();}}};var cursor=storages[currentStorage].enumerate();cursor.onsuccess=cursorOnSuccess;cursor.onerror=cursorOnError;};SdCard.getTextFromFiles=function(fileArray,contents,cb){contents=contents||'';if(!fileArray||!fileArray.length){return cb&&cb(null,contents);}
var reader=new FileReader();reader.onload=function onloaded(){contents+=reader.result+'\n';SdCard.getTextFromFiles(fileArray,contents,cb);};try{reader.readAsText(fileArray.shift());}
catch(ex){window.console.error('Problem reading file: ',ex.stack);SdCard.getTextFromFiles(fileArray,contents,cb);}};SdCard.subscribeToChanges=function(name,func,force){if(this.observers[name]!==undefined&&!force){return false;}
this.observers[name]=func;return true;};SdCard.unsubscribeToChanges=function(name){if(this.observers[name]){delete this.observers[name];return true;}else{return false;}};};'use strict';function parseDataUri(str){var re=/^data:(.+);(charset=([^;]+))?;?base64,(.*)$/;var matches=re.exec(str);if(matches){return{mime:matches[1],charset:matches[3],value:matches[4]};}
return null;}
function ensureMimeType(type){type=type.toLowerCase();if(!MimeMapper.isSupportedType(type)){type=MimeMapper.guessTypeFromExtension(type)||type;}
return type||'';}
function b64toBlob(b64Data,contentType,sliceSize){if(!b64Data){console.error('No b64 data provided to convert to blob.');return;}
contentType=contentType||'';sliceSize=sliceSize||1024;function charCodeFromCharacter(c){return c.charCodeAt(0);}
var blob;try{var byteCharacters=atob(b64Data);var byteArrays=[];for(var offset=0;offset<byteCharacters.length;offset+=sliceSize){var slice=byteCharacters.slice(offset,offset+sliceSize);var byteNumbers=[];for(var i=0,l=slice.length;i<l;i++){byteNumbers.push(charCodeFromCharacter(slice[i]));}
var byteArray=new Uint8Array(byteNumbers);byteArrays.push(byteArray);}
blob=new Blob(byteArrays,{type:contentType});}catch(e){console.error('Error parsing base64 data');}
return blob;}
var VCFReader=(function _VCFReader(){var ReBasic=/^([^:]+):(.+)$/;var ReTuple=/([a-zA-Z]+)=(.+)/;var WHITE_SPACE=' ';var DEFAULT_PHONE_TYPE='other';var VCARD_SIMPLE_TYPES={'fax':'faxOther','faxother':'faxOther','home':'home','internet':'internet','cell':'mobile','pager':'pager','personal':'home','pref':'pref','text':'text','textphone':'textphone','voice':'voice','work':'work'};var VCARD_COMPLEX_TYPES={'fax,work':'faxOffice','fax,home':'faxHome','voice,work':'work','voice,home':'home'};var REST_TIMEOUT=5000;function _parseTuple(p){var match=p.match(ReTuple);return match?[match[1].toLowerCase(),match[2]]:['type',p];}
function _parseLine(line){var parsed=ReBasic.exec(line);if(!parsed){return null;}
var tuples=parsed[1].split(/[;,]/);var fieldName=tuples.shift().toLowerCase();var fieldValue=/[^\s;]/.test(parsed[2])?parsed[2].split(';'):[];var meta={type:[]};var len=tuples.length;for(var i=0;i<len;i++){var tuple=_parseTuple(tuples[i]);if(tuple[0]==='type'){meta.type.push(tuple[1]);}else{meta[tuple[0]]=tuple[1];}}
if(fieldName==='photo'){if(meta.type.length){meta.type=ensureMimeType(meta.type[0]);}
fieldValue=parsed[2];if(meta.encoding&&(meta.encoding.toLowerCase()==='b'||meta.encoding.toLowerCase()==='base64')){meta.encoding='base64';}else{var parsedUri=parseDataUri(fieldValue);if(parsedUri){meta.type=ensureMimeType(parsedUri.mime);meta.encoding='base64';fieldValue=parsedUri.value;}}}
return{key:fieldName,data:{meta:meta,value:fieldValue}};}
var _parseEntries=function(cardArray,cb){var parsedCards=[];function sendIfFinished(contactObj){parsedCards.push(contactObj);if(parsedCards.length===cardArray.length){cb(parsedCards);}}
for(var i=0;i<cardArray.length;i++){var lines=cardArray[i];if(!lines){sendIfFinished(null);continue;}
var fields={};var len=lines.length;for(var j=0;j<len;j++){var line=lines[j];var parsedLine=_parseLine(line);if(!parsedLine){continue;}
if(!fields[parsedLine.key]){fields[parsedLine.key]=[];}
fields[parsedLine.key].push(parsedLine.data);}
if(!fields.fn&&!fields.n){sendIfFinished(null);continue;}
vcardToContact(fields,sendIfFinished);}};var qpRegexp=/=([a-zA-Z0-9]{2})/g;var _decodeQuoted=function(str){return decodeURIComponent(str.replace(qpRegexp,'%$1'));};function _decodeQP(metaObj,value){var isQP=metaObj&&metaObj.encoding&&(/quoted-printable/i).test(metaObj.encoding);if(isQP){value=_decodeQuoted(value);}
return value;}
var NAME_PARTS=['familyName','givenName','additionalName','honorificPrefix','honorificSuffix'];function _processName(vcardObj,contactObj){if(vcardObj.fn&&vcardObj.fn.length){var fnMeta=vcardObj.fn[0].meta;var fnValue=vcardObj.fn[0].value[0];contactObj.name=[_decodeQP(fnMeta,fnValue)];}
if(vcardObj.n&&vcardObj.n.length){var values=vcardObj.n[0].value;var meta=vcardObj.n[0].meta;for(var i=0;i<values.length;i++){var namePart=values[i];if(namePart&&NAME_PARTS[i]){contactObj[NAME_PARTS[i]]=_decodeQP(meta,namePart).split(',');}}
if(!contactObj.name){contactObj.name=[_decodeQP(meta,values.join(' ').trim())];}}
contactObj.givenName=contactObj.givenName||contactObj.name;return contactObj;}
var ADDR_PARTS=[null,null,'streetAddress','locality','region','postalCode','countryName'];function _processAddr(vcardObj,contactObj){if(!vcardObj.adr){return contactObj;}
contactObj.adr=[];for(var i=0;i<vcardObj.adr.length;i++){var cur={};var adr=vcardObj.adr[i];if(adr.meta&&adr.meta.type){cur.type=adr.meta.type;}
for(var j=2;j<adr.value.length;j++){var decoded=_decodeQP(adr.meta,adr.value[j]);if(decoded!==''){cur[ADDR_PARTS[j]]=decoded;}}
contactObj.adr.push(cur);}
return contactObj;}
function _processComm(vcardObj,contactObj){contactObj.tel=[];['tel','email','url'].forEach(function field2field(field){if(!vcardObj[field]){return;}
var len=vcardObj[field].length;var hasTypeMapper=function(x){return x.trim().toLowerCase();};var notTypeMapper=function(v,key){return v.meta[key].trim().toLowerCase();};var noType=function(field){return field!=='type';};var noPref=function(field){return field!=='pref';};var typeFilter=function(metaValue){return!!VCARD_SIMPLE_TYPES[metaValue];};for(var i=0;i<len;i++){var v=vcardObj[field][i];var metaValues;var cur={};if(v.meta){if(v.value){cur.value=_decodeQP(v.meta,v.value[0]);cur.value=cur.value.replace(/^tel:/i,'');}
if(v.meta.type){metaValues=([].slice.call(v.meta.type)).map(hasTypeMapper);}else{metaValues=Object.keys(v.meta).filter(noType).map(notTypeMapper.bind(null,v));}
if(metaValues.indexOf('pref')!==-1){cur.pref=true;metaValues=metaValues.filter(noPref);}
switch(metaValues.length){case 0:cur.type=[DEFAULT_PHONE_TYPE];break;case 1:cur.type=[VCARD_SIMPLE_TYPES[metaValues[0]]||DEFAULT_PHONE_TYPE];break;case 2:var complexType1=metaValues[0]+','+metaValues[1];var complexType2=metaValues[1]+','+metaValues[0];cur.type=[VCARD_COMPLEX_TYPES[complexType1]||VCARD_COMPLEX_TYPES[complexType2]||VCARD_SIMPLE_TYPES[metaValues[0]]||VCARD_SIMPLE_TYPES[metaValues[1]]||DEFAULT_PHONE_TYPE];break;default:cur.type=[VCARD_SIMPLE_TYPES[metaValues.filter(typeFilter).shift()]||DEFAULT_PHONE_TYPE];}}
if(!contactObj[field]){contactObj[field]=[];}
contactObj[field].push(cur);}});return contactObj;}
function _isValidDate(dateValue){return!isNaN(Date.parse(dateValue));}
function _processFields(vcardObj,contactObj){['org','title','bday','anniversary'].forEach(function(field){if(!vcardObj[field]){return;}
var v=vcardObj[field][0];var dateValue;if(field==='bday'){dateValue=v.value[0];if(_isValidDate(dateValue)){contactObj.bday=new Date(dateValue);}
return;}
if(field==='anniversary'){dateValue=v.value[0];if(_isValidDate(dateValue)){contactObj.anniversary=new Date(dateValue);}
return;}
if(!v){return;}
if(field==='title'){field='jobTitle';}
switch(typeof v){case'object':contactObj[field]=[_decodeQP(v.meta,v.value[0])];break;case'string':contactObj[field]=[v];break;}});return contactObj;}
function _processPhoto(vcardObj,contactObj,cb){if(!Array.isArray(vcardObj.photo)||vcardObj.photo.length===0||!vcardObj.photo[0]||!vcardObj.photo[0].value){return cb(contactObj);}
var photo=vcardObj.photo[0];var photoContents=photo.value.trim();if(!photoContents){return cb(contactObj);}
if(photoContents&&photo.meta&&photo.meta.encoding==='base64'){var blob=b64toBlob(photoContents,photo.meta.type);if(blob){utils.thumbnailImage(blob,function gotThumbnail(thumbnail){if(blob!==thumbnail){contactObj.photo=[blob,thumbnail];}else{contactObj.photo=[blob];}
cb(contactObj);});}else{cb(contactObj);}}
else{var callbacks={success:function(blobPic){if(blobPic){contactObj.photo=[blobPic];}
cb(contactObj);},error:function(){console.error('Error getting photo for contact');cb(contactObj);},timeout:function(){console.error('Timeout getting photo for contact');cb(contactObj);}};Rest.get(photoContents,callbacks,{responseType:'blob',operationsTimeout:REST_TIMEOUT});}}
var vcardToContact=function(vcard,cb){if(!vcard){return null;}
var obj={};_processName(vcard,obj);_processAddr(vcard,obj);_processComm(vcard,obj);_processFields(vcard,obj);_processPhoto(vcard,obj,function(contactObj){cb(utils.misc.toMozContact(contactObj));});};var VCFReader=function(contents){this.contents=contents;this.processed=0;this.finished=false;this.currentChar=0;this.numDupsMerged=0;};VCFReader.CONCURRENCY=5;VCFReader.prototype.finish=function(){this.finished=true;};VCFReader.prototype.process=function(cb){var self=this;var match=this.contents.match(/end:vcard/gi);if(!match){if(cb){cb();}
return;}
this.importedContacts=[];this.total=match.length;this.onread&&this.onread(this.total);this.ondone=function(numImported){cb(numImported,self.numDupsMerged);};LazyLoader.load(['/shared/js/simple_phone_matcher.js','/shared/js/mime_mapper.js','/shared/js/contact_photo_helper.js','/shared/js/contacts/import/utilities/misc.js','/shared/js/contacts/contacts_matcher.js','/shared/js/contacts/contacts_merger.js','/shared/js/contacts/utilities/image_thumbnail.js','/shared/js/contacts/merger_adapter.js','/shared/js/contacts/utilities/http_rest.js'],function(){this.splitLines();}.bind(this));};VCFReader.prototype.onParsed=function(err,ct){this.processed+=1;this.importedContacts.push(ct);this.onimported&&this.onimported(ct&&ct.name);if(this.finished||this.processed===this.total){this.ondone(this.importedContacts);return;}
var processed=this.processed;if(processed<this.total&&processed%VCFReader.CONCURRENCY===0){this.splitLines();}};VCFReader.prototype.post=function(contactObjects){var _onParsed=this.onParsed.bind(this);var cursor=0;var self=this;function afterSave(ct,e){_onParsed(e,ct);cursor+=1;if(cursor<contactObjects.length){saveContact(contactObjects[cursor]);}}
function saveContact(ct){if(!ct){afterSave(null,null);return;}
var contact=utils.misc.toMozContact(ct);var afterSaveFn=afterSave.bind(null,contact);var matchCbs={onmatch:function(matches){var callbacks={success:function(mergedContact){self.numDupsMerged++;afterSave(mergedContact,null);},error:afterSaveFn};contacts.adaptAndMerge(contact,matches,callbacks);},onmismatch:function(){VCFReader._save(contact,afterSaveFn);}};contacts.Matcher.match(contact,'passive',matchCbs);}
saveContact(contactObjects[cursor]);};VCFReader._save=function(item,cb){var req=navigator.mozContacts.save(utils.misc.toMozContact(item));req.onsuccess=cb;req.onerror=cb;};var reBeginCard=/begin:vcard$/i;var reEndCard=/end:vcard$/i;var reVersion=/^VERSION:([\d\.]*)/i;VCFReader.prototype.splitLines=function(){var currentLine='';var currentVersion=0;var inLabel=false;var multiline=false;var cardArray=[[]];var cardsProcessed=0;var i=this.currentChar;var callPost=this.post.bind(this);for(var l=this.contents.length;i<l;i++){this.currentChar=i;var ch=this.contents[i];if(currentVersion>=4&&ch==='"'){inLabel=!inLabel;currentLine+=ch;continue;}
if(multiline===true){if((/[\r\t\s\n]/).test(ch)){continue;}else{multiline=false;}}
var next=this.contents[i+1];if(inLabel||(ch!=='\n'&&ch!=='\r')){if(!(/^PHOTO/i).test(currentLine)&&ch==='='&&next&&next.search(/(\r|\n)/)!==-1){multiline=true;continue;}
currentLine+=ch;if(i!==l-1){continue;}}
var firstCharNextLine=this.contents[i+2];if((firstCharNextLine===WHITE_SPACE)&&(/[\r\t\s\n]/).test(next)&&(/^PHOTO/i).test(currentLine)){multiline=true;continue;}
if(next&&(next===WHITE_SPACE||next==='\t')){multiline=true;continue;}
if(reBeginCard.test(currentLine)){currentLine='';currentVersion=0;continue;}
if(reEndCard.test(currentLine)){cardsProcessed+=1;if(cardsProcessed===VCFReader.CONCURRENCY||(cardsProcessed+this.processed)===this.total){_parseEntries(cardArray,callPost);break;}
currentLine='';cardArray.push([]);continue;}
if(currentLine){var matches=reVersion.exec(currentLine);if(matches===null){cardArray[cardArray.length-1].push(currentLine);}else{currentVersion=parseFloat(matches[1]||'0');}}
currentLine='';}};VCFReader._decodeQuoted=_decodeQuoted;VCFReader.processAddr=_processAddr;VCFReader.processName=_processName;VCFReader.vcardToContact=vcardToContact;VCFReader.utils={parseDataUri:parseDataUri,b64toBlob:b64toBlob};return VCFReader;})();;'use strict';var utils=window.utils||{};utils.importFromVcard=function(file,callback){var MERGE_DEPENDENCIES=['/shared/js/simple_phone_matcher.js','/shared/js/contacts/merger_adapter.js','/shared/js/contacts/contacts_merger.js','/shared/js/contacts/contacts_matcher.js'];Contacts.utility('Overlay',function(){LazyLoader.load(MERGE_DEPENDENCIES,_loaded);},Contacts.SHARED_UTILITIES);function _loaded(){var importedContacts=0;var cancelled=false;var importer=null;var text=null;var progress=utils.overlay.show('memoryCardContacts-reading','activityBar');utils.overlay.showMenu();utils.overlay.oncancel=function oncancel(){cancelled=true;if(importer){importer.finish();}else{utils.overlay.hide();}};readVCard(function(vcardText){if(vcardText){processTextFromFile(vcardText);}else{callback();}});function readVCard(cb){var reader;if(typeof file==='string'){cb(file);}else{reader=new FileReader();reader.onloadend=function(){text=reader.result;if(text){cb(text);}};try{reader.readAsText(file);}
catch(ex){console.error('Error reading the file '+ex.message);import_error();cb();}}}
function processTextFromFile(textFromFile){if(cancelled){return;}
var reader=new VCardReader(textFromFile);var match=textFromFile&&textFromFile.match(/END:VCARD/g);var cursor=reader.getAll();var numContacts=match?match.length:0;var numDupsMerged=0;var firstContact=null;var _doContinue=function(savedContact){if(savedContact){if(!firstContact){firstContact=savedContact;}
imported_contact();}
if(!cancelled){cursor.continue();}};cursor.onsuccess=function(evt){if(evt.target.result){var contact=evt.target.result;contacts.Matcher.match(contact,'passive',{onmatch:function(matches){var callbacks={success:function(mergedContact){numDupsMerged++;_doContinue(mergedContact);},error:_doContinue};contacts.adaptAndMerge(contact,matches,callbacks);},onmismatch:function(){var req=navigator.mozContacts.save(contact);req.onsuccess=function(){_doContinue(contact);};}});}else{utils.overlay.hide();if(!cancelled){var msgImported={id:'memoryCardContacts-imported3',args:{n:importedContacts}};var msgDupsMerged=numDupsMerged?{id:'contactsMerged',args:{numDups:numDupsMerged}}:null;utils.status.show(msgImported,msgDupsMerged);}
if(importedContacts>0){callback(importedContacts,firstContact.id);}else{callback(importedContacts);}}};import_read(numContacts);}
function import_read(n){progress.setClass('progressBar');progress.setHeaderMsg('memoryCardContacts-importing');progress.setTotal(n);}
function imported_contact(){importedContacts++;if(!cancelled){progress.update();}}
function import_error(e){console.error('Error importing from vcard: '+e.message);var cancel={title:'cancel',callback:function(){ConfirmDialog.hide();}};var retry={title:'retry',isRecommend:true,callback:function(){ConfirmDialog.hide();processTextFromFile(text);}};Contacts.confirmDialog(null,'memoryCardContacts-error',cancel,retry);utils.overlay.hide();}}};;'use strict';function SimContactsImporter(targetIcc){if(targetIcc===null){throw new Error('We need an icc to continue with this operation');}
var pointer=0;var CHUNK_SIZE=5;var numResponses=0;var self=this;var mustFinish=false;var loadedMatch=false;var DEFAULT_TEL_TYPE='other';var icc=targetIcc;var iccId=icc.iccInfo&&icc.iccInfo.iccid;var numDupsMerged=0;function generateIccContactUrl(contactid){var urlValue='urn:'+'uuid:'+(iccId||'iccId')+'-'+contactid;return[{type:['source','sim'],value:urlValue}];}
function notifyFinish(){if(typeof self.onfinish==='function'){window.setTimeout(self.onfinish,0,numDupsMerged,iccId);}}
function notifyImported(){if(typeof self.onimported==='function'){window.setTimeout(self.onimported,0);}}
function continueCb(){numResponses++;pointer++;notifyImported();if(pointer<self.items.length&&numResponses===CHUNK_SIZE){numResponses=0;mustFinish?notifyFinish():importSlice(pointer);}
else if(pointer>=self.items.length){notifyFinish();}}
function startMigration(){if(!mustFinish&&Array.isArray(self.items)&&self.items.length>0){importSlice(0);}
else{notifyFinish();}}
function onContactsReadyForImport(){if(typeof self.onread==='function'){self.onread(self.items.length);}
if(loadedMatch){startMigration();}
else{document.addEventListener('matchLoaded',function mloaded(){document.removeEventListener('matchLoaded',mloaded);startMigration();});}}
this.start=function(){numDupsMerged=0;if(mustFinish){notifyFinish();return;}
LazyLoader.load(['/shared/js/simple_phone_matcher.js','/shared/js/contacts/contacts_matcher.js','/shared/js/contacts/contacts_merger.js','/shared/js/contacts/utilities/image_thumbnail.js','/shared/js/contacts/merger_adapter.js'],function loaded(){loadedMatch=true;document.dispatchEvent(new CustomEvent('matchLoaded'));});var requestAdn,requestSdn;if(icc&&icc.readContacts){requestAdn=icc.readContacts('adn');}else{throw new Error('Not able to obtain a SIM import function from platform');}
requestAdn.onsuccess=function onsuccess(){if(mustFinish){notifyFinish();return;}
self.items=requestAdn.result||[];requestSdn=icc.readContacts('sdn');requestSdn.onsuccess=function onsuccess(){if(mustFinish){notifyFinish();return;}
if(Array.isArray(requestSdn.result)){self.items=self.items.concat(requestSdn.result);}
onContactsReadyForImport();};requestSdn.onerror=function error(){if(mustFinish){notifyFinish();return;}
console.warn('Could not read SDN Contacts from SIM Card',error.name);onContactsReadyForImport();};};requestAdn.onerror=function error(){if(typeof self.onerror==='function'){self.onerror(requestAdn.error);}};};this.finish=function(){mustFinish=true;};function importSlice(from){for(var i=from;i<from+CHUNK_SIZE&&i<self.items.length;i++){var item=self.items[i];var parsedName=utils.misc.parseName(item.name[0]);item.givenName=[parsedName.givenName];item.familyName=[parsedName.familyName];if(Array.isArray(item.tel)){var telItems=[];for(var j=0;j<item.tel.length;j++){var aTel=item.tel[j];if(aTel.value&&aTel.value.trim()){aTel.type=[DEFAULT_TEL_TYPE];telItems.push(aTel);}}
item.tel=telItems;}
item.category=['sim'];item.url=generateIccContactUrl(item.id);var contact=item;var cbs={onmatch:function(results){var mergeCbs={success:function(){numDupsMerged++;continueCb();},error:function(e){window.console.error('Error while merging: ',e.name);continueCb();}};contacts.adaptAndMerge(this,results,mergeCbs);}.bind(contact),onmismatch:function(){saveContact(this);}.bind(contact)};contacts.Matcher.match(item,'passive',cbs);}}
function saveContact(contact){var req=window.navigator.mozContacts.save(new mozContact(contact));req.onsuccess=function saveSuccess(){continueCb();};req.onerror=function saveError(){console.error('SIM Import: Error importing ',contact.id,req.error.name);continueCb();};}};'use strict';var ScreenLayout={defaultQueries:{tiny:'(max-width: 767px)',small:'(min-width: 768px) and (max-width: 991px)',medium:'(min-width: 992px) and (max-width: 1200px)',large:'(min-width: 1201px)',hardwareHomeButton:'(-moz-physical-home-button)'},init:function sl_init(){this.queries=(function(qs){var result={};for(var key in qs){result[key]=window.matchMedia(qs[key]);}
return result;})(this.defaultQueries);},_isOnRealDevice:undefined,isOnRealDevice:function sl_isOnRealDevice(){if(typeof(this._isOnRealDevice)!=='undefined'){return this._isOnRealDevice;}
if(window.innerWidth===screen.availWidth){this._isOnRealDevice=true;}else{this._isOnRealDevice=false;}
return this._isOnRealDevice;},getCurrentLayout:function sl_getCurrentLayout(type){if(type===undefined){for(var name in this.defaultQueries){if(this.queries[name]&&this.queries[name].matches){return name;}}}
if(typeof this.queries[type]!=='undefined'){return this.queries[type].matches;}
return false;},watch:function sl_watch(name,media){var mediaString=media||this.queries[name].media;if(!mediaString){return;}
this.unwatch(name);this.queries[name]=window.matchMedia(mediaString);this.boundHandleChange=this.handleChange.bind(this);this.queries[name].addListener(this.boundHandleChange);},unwatch:function sl_unwatch(name){if(this.queries[name]){this.queries[name].removeListener(this.boundHandleChange);}},handleChange:function sl_handleChange(evt){for(var key in this.queries){if(this.queries[key].media!==evt.media){continue;}
window.dispatchEvent(new CustomEvent('screenlayoutchange',{detail:{name:key,status:evt.matches}}));}}};ScreenLayout.init();;'use strict';var Normalizer={initAsciiNormalizer:function normalizer_init(){var equivalentChars={'a':'áăǎâäȧạȁàảȃāąåḁⱥãǽǣæ','A':'ÁĂǍÂÄȦẠȀÀẢȂĀĄÅḀȺÃǼǢÆ','b':'ḃḅɓḇƀƃ','B':'ḂḄƁḆɃƂ','c':'ćčçĉċƈȼ','C':'ĆČÇĈĊƇȻ','d':'ďḑḓḋḍɗḏđƌð','D':'ĎḐḒḊḌƊḎĐƋ','e':'éĕěȩêḙëėẹȅèẻȇēę','E':'ÉĔĚȨÊḘËĖẸȄÈẺȆĒĘ','f':'ḟƒ','F':'ḞƑ','g':'ǵğǧģĝġɠḡǥ','G':'ǴĞǦĢĜĠƓḠǤ','h':'ḫȟḩĥⱨḧḣḥħ','H':'ḪȞḨĤⱧḦḢḤĦ','i':'íĭǐîïịȉìỉȋīįɨĩḭı','I':'ÍĬǏÎÏỊȈÌỈȊĪĮƗĨḬ','j':'ĵɉ','J':'ĴɈ','k':'ḱǩķⱪꝃḳƙḵꝁ','K':'ḰǨĶⱩꝂḲƘḴꝀ','l':'ĺƚľļḽḷⱡꝉḻŀɫł','L':'ĹȽĽĻḼḶⱠꝈḺĿⱢŁ','m':'ḿṁṃɱ','M':'ḾṀṂⱮ','n':'ńňņṋṅṇǹɲṉƞñ','N':'ŃŇŅṊṄṆǸƝṈȠÑ','o':'óŏǒôöȯọőȍòỏơȏꝋꝍōǫøõœ','O':'ÓŎǑÔÖȮỌŐȌÒỎƠȎꝊꝌŌǪØÕŒ','p':'ṕṗꝓƥᵽꝑ','P':'ṔṖꝒƤⱣꝐ','q':'ꝗ','Q':'Ꝗ','r':'ŕřŗṙṛȑȓṟɍɽ','R':'ŔŘŖṘṚȐȒṞɌⱤ','s':'śšşŝșṡṣß$','S':'ŚŠŞŜȘṠṢ','t':'ťţṱțⱦṫṭƭṯʈŧ','T':'ŤŢṰȚȾṪṬƬṮƮŦ','u':'úŭǔûṷüṳụűȕùủưȗūųůũṵ','U':'ÚŬǓÛṶÜṲỤŰȔÙỦƯȖŪŲŮŨṴ','v':'ṿʋṽ','V':'ṾƲṼ','w':'ẃŵẅẇẉẁⱳ','W':'ẂŴẄẆẈẀⱲ','x':'ẍẋ','X':'ẌẊ','y':'ýŷÿẏỵỳƴỷỿȳɏỹ','Y':'ÝŶŸẎỴỲƳỶỾȲɎỸ','z':'źžẑⱬżẓȥẕƶ','Z':'ŹŽẐⱫŻẒȤẔƵ'};this._toAsciiForm={};for(var letter in equivalentChars){var accentedForms=equivalentChars[letter];for(var i=accentedForms.length-1;i>=0;i--){this._toAsciiForm[accentedForms[i]]=letter;}}},toAscii:function normalizer_toAscii(str){if(!str||typeof str!='string'){return'';}
if(!this._toAsciiForm){Normalizer.initAsciiNormalizer();}
var result='';for(var i=0,len=str.length;i<len;i++){result+=this._toAsciiForm[str.charAt(i)]||str.charAt(i);}
return result;},escapeHTML:function normalizer_escapeHTML(str,escapeQuotes){if(Array.isArray(str)){return Normalizer.escapeHTML(str.join(' '),escapeQuotes);}
if(!str||typeof str!='string'){return'';}
var escaped=str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');if(escapeQuotes){return escaped.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');}
return escaped;},escapeRegExp:function normalizer_escapeRegExp(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,'\\$&');}};;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;(function(exports){'use strict';const HEADER_SIZES=[16,17,18,19,20,21,22,23];var FontSizeUtils={_cachedContexts:{},_getCachedContext:function(fontSize,fontFamily,fontStyle){fontStyle=fontStyle||'italic';var cache=this._cachedContexts;var ctx=cache[fontSize]&&cache[fontSize][fontFamily]?cache[fontSize][fontFamily][fontStyle]:null;if(!ctx){var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1');canvas.setAttribute('height','1');ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=fontStyle+' '+fontSize+'px '+fontFamily;if(!cache[fontSize]){cache[fontSize]={};}
if(!cache[fontSize][fontFamily]){cache[fontSize][fontFamily]={};}
cache[fontSize][fontFamily][fontStyle]=ctx;}
return ctx;},resetCache:function(){this._cachedContexts={};},_textChangeObserver:null,_handleTextChanges:function(mutations){for(var i=0;i<mutations.length;i++){this._reformatHeaderText(mutations[i].target);}},_getTextChangeObserver:function(){if(!this._textChangeObserver){this._textChangeObserver=new MutationObserver(this._handleTextChanges.bind(this));}
return this._textChangeObserver;},_observeHeaderChanges:function(element){var observer=this._getTextChangeObserver();observer.observe(element,{childList:true});},_reformatHeaderText:function(header){if(header.textContent.trim()===''){return;}
this.resetCentering(header);var style=this.getStyleProperties(header);style.textWidth=this.autoResizeElement(header,style);this.centerTextToScreen(header,style);},_registerHeadersInSubtree:function(domNode){if(!domNode){return;}
var headers=domNode.querySelectorAll('header > h1');for(var i=0;i<headers.length;i++){window.requestAnimationFrame(function(header){this._reformatHeaderText(header);this._observeHeaderChanges(header);}.bind(this,headers[i]));}},getFontWidth:function(string,fontSize,fontFamily,fontStyle){var ctx=this._getCachedContext(fontSize,fontFamily,fontStyle);return ctx.measureText(string).width;},getMaxFontSizeInfo:function(string,allowedSizes,fontFamily,maxWidth){var fontSize;var resultWidth;var i=allowedSizes.length-1;do{fontSize=allowedSizes[i];resultWidth=this.getFontWidth(string,fontSize,fontFamily);i--;}while(resultWidth>maxWidth&&i>=0);return{fontSize:fontSize,overflow:resultWidth>maxWidth,textWidth:resultWidth};},getOverflowCount:function(string,fontSize,fontFamily,maxWidth){var substring;var resultWidth;var overflowCount=-1;do{overflowCount++;substring=string.substr(0,string.length-overflowCount);resultWidth=this.getFontWidth(substring,fontSize,fontFamily);}while(substring.length>0&&resultWidth>maxWidth);return overflowCount;},getAllowedSizes:function(element){if(element.tagName==='H1'&&element.parentNode.tagName==='HEADER'){return HEADER_SIZES;}
return[];},getContentWidth:function(style){var width=parseInt(style.width,10);if(style.boxSizing==='border-box'){width-=(parseInt(style.paddingRight,10)+
parseInt(style.paddingLeft,10));}
return width;},getStyleProperties:function(element){var style=window.getComputedStyle(element);var contentWidth=this.getContentWidth(style);if(isNaN(contentWidth)){contentWidth=0;}
return{fontFamily:style.fontFamily,contentWidth:contentWidth,paddingRight:parseInt(style.paddingRight,10),paddingLeft:parseInt(style.paddingLeft,10),offsetLeft:element.offsetLeft};},autoResizeElement:function(element,styleOptions){var allowedSizes=this.getAllowedSizes(element);if(allowedSizes.length===0){return 0;}
var contentWidth=styleOptions.contentWidth||this.getContentWidth(element);var fontFamily=styleOptions.fontFamily||getComputedStyle(element).fontFamily;var info=this.getMaxFontSizeInfo(element.textContent.trim(),allowedSizes,fontFamily,contentWidth);element.style.fontSize=info.fontSize+'px';return info.textWidth;},resetCentering:function(element){element.style.marginLeft=element.style.marginRight='0';},centerTextToScreen:function(element,styleOptions){var minHeaderWidth=styleOptions.textWidth+styleOptions.paddingRight+
styleOptions.paddingLeft;var sideSpaceLeft=styleOptions.offsetLeft;var sideSpaceRight=this.getWindowWidth()-sideSpaceLeft-
styleOptions.contentWidth-styleOptions.paddingRight-
styleOptions.paddingLeft;if(sideSpaceLeft===sideSpaceRight){return;}
var margin=Math.max(sideSpaceLeft,sideSpaceRight);if(minHeaderWidth+(margin*2)<this.getWindowWidth()-1){element.style.marginLeft=element.style.marginRight=margin+'px';}},_initHeaderFormatting:function(){if(navigator.mozL10n){navigator.mozL10n.once(function(){this._registerHeadersInSubtree(document.body);}.bind(this));}else{this._registerHeadersInSubtree(document.body);}},init:function(){window.addEventListener('lazyload',function(evt){this._registerHeadersInSubtree(evt.detail);}.bind(this));if(document.readyState==='loading'){window.addEventListener('DOMContentLoaded',function(){this._initHeaderFormatting();}.bind(this));}else{this._initHeaderFormatting();}},getWindowWidth:function(){return window.innerWidth;}};FontSizeUtils.init();exports.FontSizeUtils=FontSizeUtils;}(this));;'use strict';var Basket={DATASTORE_NAME:'Basket_Newsletter',basketUrl:'https://basket.mozilla.org/news/subscribe/',newsletterId:'firefox-os',callback:null,xhr:null,errors:{NETWORK_FAILURE:1,INVALID_EMAIL:2,UNKNOWN_EMAIL:3,UNKNOWN_TOKEN:4,USAGE_ERROR:5,EMAIL_PROVIDER_AUTH_FAILURE:6,AUTH_ERROR:7,SSL_REQUIRED:8,INVALID_NEWSLETTER:9,INVALID_LANGUAGE:10,EMAIL_NOT_CHANGED:11,CHANGE_REQUEST_NOT_FOUND:12,UNKNOWN_ERROR:99},responseHandler:function b_responseHandler(){if(this.xhr.readyState===4){if(this.xhr.status===200){if(typeof this.callback==='function'){this.callback(null,JSON.parse(this.xhr.responseText));}}else{if(typeof this.callback==='function'){if(this.xhr.responseText){this.callback(JSON.parse(this.xhr.responseText));}else{this.callback('Unknown error');}}}}},timeoutHandler:function b_timeoutHandler(){this.callback('Timeout');},send:function b_send(email,callback){var self=this;var params='email='+encodeURIComponent(email)+'&newsletters='+self.newsletterId;self.callback=callback;self.xhr=new XMLHttpRequest({mozSystem:true});self.xhr.onreadystatechange=self.responseHandler.bind(self);self.xhr.open('POST',self.basketUrl,true);self.xhr.setRequestHeader('Content-type','application/x-www-form-urlencoded');self.xhr.setRequestHeader('Connection','close');self.xhr.timeout=5000;self.xhr.ontimeout=self.timeoutHandler.bind(self);self.getLanguage(function do_send(language){if(language){params+='&lang='+language;}
self.xhr.setRequestHeader('Content-length',params.length);self.xhr.send(params);});},getDataStore:function(){var self=this;return new Promise(function(resolve,reject){navigator.getDataStores(self.DATASTORE_NAME).then(function(stores){if(!stores.length){reject(new Error('DataStore not loaded'));}else{var dataStore=stores[0];if(dataStore.owner==='app://ftu.gaiamobile.org/manifest.webapp'){resolve(dataStore);}else{reject(new Error('Wrong DataStore'));}}});});},store:function b_store(email,callback){this.getDataStore().then(function loaded(store){store.add({'newsletter_email':email}).then(function(id){if(callback){callback(false,id);}});}).catch(function error(err){console.error('Something went wrong: '+err);callback(err);});},getLanguage:function b_getLanguage(callback){var settings=window.navigator.mozSettings;if(!settings||!settings.createLock){callback();return;}
var s_name='language.current';var req=settings.createLock().get(s_name);req.onsuccess=function _onsuccess(){callback(req.result[s_name]);};req.onerror=function _onerror(){console.error('Error getting setting: '+s_name);callback();};}};;'use strict';var FTU_APP_ORIGIN=document.location.protocol+'//'+
document.location.host;var ServicesLauncher=(function(document){var extensionFrame=document.querySelector('#fb-extensions');var oauthFrame=document.querySelector('#fb-oauth');var BASE_IMPORT='/shared/pages/import/import.html?ftu=1';function getServiceURI(service){return BASE_IMPORT+'&service='+service;}
var access_token,currentURI,currentService;function open(){extensionFrame.className='opening';}
function load(targetService){currentService=targetService;currentURI=getServiceURI(targetService);window.addEventListener('message',messageHandler);oauthFrame.contentWindow.postMessage({type:'start',data:{from:'friends',service:targetService}},FTU_APP_ORIGIN);}
function unload(){window.removeEventListener('message',messageHandler);extensionFrame.src=null;}
function close(messageId){extensionFrame.addEventListener('transitionend',function tclose(){extensionFrame.removeEventListener('transitionend',tclose);extensionFrame.src=null;if(messageId){utils.status.show(messageId);}});extensionFrame.className='closing';window.removeEventListener('message',messageHandler);if(currentService==='facebook'){var event=new CustomEvent('fb_imported',{'detail':true});document.dispatchEvent(event);}}
function messageHandler(e){if(e.origin!==FTU_APP_ORIGIN){return;}
var data=e.data;switch(data.type){case'ready':open();break;case'abort':unload();break;case'window_close':close(data.messageId);break;case'authenticated':extensionFrame.src=currentURI;access_token=data.data;break;case'messaging_ready':extensionFrame.contentWindow.postMessage({type:'token',data:access_token},FTU_APP_ORIGIN);break;}}
return{start:load};})(document);;'use strict';var fb=this.fb||{};this.fb=fb;fb.utils=this.fb.utils||{};this.fb.utils=fb.utils;if(typeof fb.utils.Request!=='function'){fb.utils.Request=function(){this.done=function(result){this.result=result;if(typeof this.onsuccess==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onsuccess(ev);}.bind(this),0);}};this.failed=function(error){this.error=error;if(typeof this.onerror==='function'){var ev={};ev.target=this;window.setTimeout(function(){this.onerror(ev);}.bind(this),0);}};};};'use strict';var fb=window.fb||{};(function(){var contacts=fb.contacts||{};fb.contacts=contacts;var Reader;var readerLoaded=false;var INDEX_ID=1;var isIndexDirty=false;var READER_LOADED_EV='reader_loaded';var TEL_INDEXER_JS='/shared/js/fb/fb_tel_index.js';var PHONE_MATCHER_JS='/shared/js/simple_phone_matcher.js';var FB_READER_JS='/shared/js/fb/fb_data_reader.js';var BINARY_SEARCH_JS='/shared/js/binary_search.js';contacts.UID_NOT_FOUND='UIDNotFound';contacts.ALREADY_EXISTS='AlreadyExists';if(!contacts.init){var proxyMethods=['get','getLength','getByPhone','search','refresh','init','restart'];proxyMethods.forEach(function(aMethod){contacts[aMethod]=defaultFunction.bind(null,aMethod);});LazyLoader.load(FB_READER_JS,onreaderLoaded);}
else{onreaderLoaded();}
function onreaderLoaded(){readerLoaded=true;Reader=fb.contacts;document.dispatchEvent(new CustomEvent(READER_LOADED_EV));}
function setIndex(index){Reader.dsIndex=index;isIndexDirty=false;}
function datastore(){return Reader.datastore;}
function index(){return Reader.dsIndex;}
function defaultFunction(target){var args=[];for(var j=1;j<arguments.length;j++){args.push(arguments[j]);}
if(!readerLoaded){document.addEventListener(READER_LOADED_EV,function rd_loaded(){document.removeEventListener(READER_LOADED_EV,rd_loaded);Reader[target].apply(this,args);});}
else{Reader[target].apply(this,args);}}
function initError(outRequest,error){outRequest.failed(error);}
function safeError(err){if(err&&err.name){return err;}
return{name:'UnknownError'};}
function defaultError(request){return defaultErrorCb.bind(null,request);}
function defaultSuccess(request){return defaultSuccessCb.bind(null,request);}
function defaultErrorCb(request,error){request.failed(safeError(error));}
function defaultSuccessCb(request,result){request.done(result);}
function doSave(obj,outRequest){LazyLoader.load([TEL_INDEXER_JS,PHONE_MATCHER_JS,BINARY_SEARCH_JS],function(){var uid=obj.uid;datastore().add(obj,uid).then(function success(){indexByPhone(obj,uid);isIndexDirty=true;outRequest.done();},function error(err){if(err.name==='ConstraintError'){err={name:contacts.ALREADY_EXISTS};}
outRequest.failed(err);});});}
function indexByPhone(obj,newId){if(Array.isArray(obj.tel)){obj.tel.forEach(function(aTel){var variants=SimplePhoneMatcher.generateVariants(aTel.value);variants.forEach(function(aVariant){index().byTel[aVariant]=newId;});TelIndexer.index(index().treeTel,aTel.value.substring(1),newId);});}}
function reIndexByPhone(oldObj,newObj,dsId){removePhoneIndex(oldObj);indexByPhone(newObj,dsId);TelIndexer.orderTree(index().treeTel);}
function removePhoneIndex(deletedFriend){if(Array.isArray(deletedFriend.tel)){deletedFriend.tel.forEach(function(aTel){TelIndexer.remove(index().treeTel,aTel.value.substring(1));var variants=SimplePhoneMatcher.generateVariants(aTel.value);variants.forEach(function(aVariant){delete index().byTel[aVariant];});});}}
contacts.save=function(obj){var retRequest=new fb.utils.Request();window.setTimeout(function save(){contacts.init(function(){doSave(obj,retRequest);},function(err){initError(retRequest,err);});},0);return retRequest;};contacts.update=function(obj){var retRequest=new fb.utils.Request();window.setTimeout(function save(){contacts.init(function(){doUpdate(obj,retRequest);},function(err){initError(retRequest,err);});},0);return retRequest;};function doUpdate(obj,outRequest){LazyLoader.load([TEL_INDEXER_JS,PHONE_MATCHER_JS,BINARY_SEARCH_JS],function(){var uid=obj.uid;var successCb=successUpdate.bind(null,outRequest);var errorCb=errorUpdate.bind(null,outRequest,uid);datastore().get(uid).then(function success(oldObj){if(!oldObj){errorCb({name:contacts.UID_NOT_FOUND});return;}
reIndexByPhone(oldObj,obj,uid);datastore().put(obj,uid).then(function success(){return datastore().put(index(),INDEX_ID);},errorCb).then(successCb,errorCb);},errorCb);});}
function successUpdate(outRequest){outRequest.done();}
function errorUpdate(outRequest,uid,error){window.console.error('Error while updating datastore for: ',uid);outRequest.failed(error);}
function doRemove(uid,outRequest,forceFlush){LazyLoader.load([TEL_INDEXER_JS,PHONE_MATCHER_JS,BINARY_SEARCH_JS],function(){var errorCb=errorRemove.bind(null,outRequest,uid);var objToDelete;datastore().get(uid).then(function success_get_remove(object){objToDelete=object;if(!objToDelete){errorRemove(outRequest,uid,{name:contacts.UID_NOT_FOUND});return;}
datastore().remove(uid).then(function success_rm(removed){successRemove(outRequest,objToDelete,forceFlush,removed);},errorCb);},errorCb);});}
function successRemove(outRequest,deletedFriend,forceFlush,removed){if(removed===true){isIndexDirty=true;removePhoneIndex(deletedFriend);if(forceFlush){var flushReq=fb.contacts.flush();flushReq.onsuccess=function(){isIndexDirty=false;outRequest.done(true);};flushReq.onerror=function(){outRequest.failed(flushReq.error);};}
else{outRequest.done(true);}}
else{outRequest.done(false);}}
function errorRemove(outRequest,uid,error){error=safeError(error);window.console.error('FB Data: Error while removing ',uid,': ',error.name);outRequest.failed(error);}
contacts.remove=function(uid,flush){var hasToFlush=(flush===true?flush:false);var retRequest=new fb.utils.Request();window.setTimeout(function remove(){contacts.init(function(){doRemove(uid,retRequest,hasToFlush);},function(err){initError(retRequest,err);});},0);return retRequest;};contacts.clear=function(){var outRequest=new fb.utils.Request();window.setTimeout(function clear(){contacts.init(function(){doClear(outRequest);},function(err){initError(outRequest,err);});},0);return outRequest;};function doClear(outRequest){datastore().clear().then(function success(){setIndex(null);datastore().put(index(),INDEX_ID).then(defaultSuccess(outRequest),function error(err){err=safeError(err);window.console.error('Error while re-creating the index: ',err.name);outRequest.failed(err);});},defaultError(outRequest));}
contacts.flush=function(){var outRequest=new fb.utils.Request();window.setTimeout(function do_Flush(){if(!(datastore())||!isIndexDirty){window.console.warn('The datastore has not been initialized or is not dirty');outRequest.done();return;}
TelIndexer.orderTree(index().treeTel);datastore().put(index(),INDEX_ID).then(defaultSuccess(outRequest),defaultError(outRequest));},0);return outRequest;};})();;'use strict';var fb=window.fb||{};window.fb=fb;(function(document){var Utils=fb.utils||{};fb.utils=Utils;var FRIEND_COUNT_QUERY='select friend_count from user where uid=me()';var CACHE_FRIENDS_KEY=Utils.CACHE_FRIENDS_KEY='numFacebookFriends';var LAST_UPDATED_KEY=Utils.LAST_UPDATED_KEY='lastUpdatedTime';Utils.ALARM_ID_KEY='nextAlarmId';Utils.SCHEDULE_SYNC_KEY='facebookShouldHaveScheduledAt';var REDIRECT_LOGOUT_URI=window.oauthflow?oauthflow.params.facebook.redirectLogout:'';var STORAGE_KEY=Utils.TOKEN_DATA_KEY='tokenData';Utils.setLastUpdate=function(value,cb){window.asyncStorage.setItem(LAST_UPDATED_KEY,{data:value},cb);};Utils.getLastUpdate=function(callback){window.asyncStorage.getItem(LAST_UPDATED_KEY,function(obj){var out=0;if(obj){out=obj.data||out;}
if(typeof callback==='function'){callback(out);}});};Utils.getNonCacheableUrl=function(url){if(url.indexOf('?')===-1){url+='?';}
return url+'&burst_cache='+Date.now();};Utils.getContactData=function(cid){var outReq=new Utils.Request();var req=navigator.mozContacts.find({filterBy:['id'],filterValue:cid,filterOp:'equals'});req.onsuccess=function(e){if(e.target.result&&e.target.result.length>0){outReq.done(e.target.result[0]);}
else{outReq.done(null);}};req.onerror=function(e){outReq.failed(e.target.error);};return outReq;};Utils.getMozContact=function(uid){var outReq=new Utils.Request();window.setTimeout(function get_mozContact_ByUid(){fb.getMozContactByUid(uid,function onsuccess(result){if(Array.isArray(result)&&result.length>0){outReq.done(result[0]);}else{outReq.done(null);}},function onerror(e){outReq.failed(e.target.error);});},0);return outReq;};Utils.getNumberMozContacts=function(uid){var outReq=new Utils.Request();window.setTimeout(function get_mozContact_ByUid(){fb.getMozContactByUid(uid,function onsuccess(result){if(Array.isArray(result)){outReq.done(result.length);}else{outReq.done(0);}},function onerror(error){outReq.failed(error);});},0);return outReq;};Utils.getAllFbContacts=function(){var outReq=new Utils.Request();window.setTimeout(function get_all_fb_contacts(){var filter={filterValue:fb.CATEGORY,filterOp:'contains',filterBy:['category']};var req=navigator.mozContacts.find(filter);req.onsuccess=function(e){outReq.done(e.target.result);};req.onerror=function(e){outReq.failed(e.target.error);};},0);return outReq;};Utils.getNumFbContacts=function(){var outReq=new Utils.Request();window.setTimeout(function get_num_fb_contacts(){var req=fb.contacts.getLength();req.onsuccess=function(){outReq.done(req.result);};req.onerror=function(){outReq.failed(req.error);};},0);return outReq;};Utils.getNumFbFriends=function(callback,access_token){fb.utils.runQuery(FRIEND_COUNT_QUERY,callback,access_token);};Utils.getCachedAccessToken=function(callback){ImportStatusData.get(STORAGE_KEY).then(function(data){var out=null;if(data){out=data.access_token||null;}
if(typeof callback==='function'){callback(out);}});};Utils.setCachedAccessToken=function(data,callback){ImportStatusData.put(STORAGE_KEY,data).then(function done(){if(typeof callback==='function'){callback();}},function error(){console.error('Error while saving access token');if(typeof callback==='function'){callback();}});};Utils.getCachedNumFbFriends=function(callback){ImportStatusData.get(CACHE_FRIENDS_KEY).then(function(data){if(typeof callback==='function'&&typeof data==='number'){callback(data);}});};Utils.setCachedNumFriends=function(value,cb){ImportStatusData.put(CACHE_FRIENDS_KEY,value).then(cb);};Utils.removeCachedNumFriends=function(callback){ImportStatusData.remove(CACHE_FRIENDS_KEY).then(function(){typeof callback==='function'&&callback();});};Utils.getImportChecked=function(callback){Utils.getCachedAccessToken(function(access_token){var out='logged-out';if(access_token){out='logged-in';}
else{Utils.getCachedNumFbFriends(function(value){if(value){out='renew-pwd';if(typeof callback==='function'){callback(out);}}});}
if(typeof callback==='function'){callback(out);}});};Utils.numFbFriendsData=function(callback){var localCb=callback.local;var remoteCb=callback.remote;Utils.getCachedNumFbFriends(localCb);function auxCallback(response){if(response.data&&response.data[0]&&response.data[0].friend_count){remoteCb(response.data[0].friend_count);}}
if(typeof remoteCb==='function'&&navigator.onLine===true){var remoteCallbacks={success:auxCallback,error:null,timeout:null};Utils.getCachedAccessToken(function(access_token){if(access_token){Utils.getNumFbFriends(remoteCallbacks,access_token);}});}};Utils.clearFbData=function(){var outReq=new Utils.Request();window.setTimeout(function do_clearFbData(){var ireq=fb.contacts.clear();ireq.onsuccess=function(){var req=Utils.getAllFbContacts();req.onsuccess=function(){var cleaner=new Utils.FbContactsCleaner(req.result,'clear');outReq.done(cleaner);window.setTimeout(cleaner.start,0);};req.onerror=function(){window.console.error('FB Clean. Error retrieving FB Contacts');outReq.failed(req.error);};};ireq.onerror=function(e){window.console.error('Error while clearing the FB Cache');outReq.failed(ireq.error);};},0);return outReq;};Utils.logout=function(){var outReq=new Utils.Request();var WINDOW_TIMER_INTERVAL=500;var LOGOUT_TIMEOUT=5000;var MAX_TIMER_TICKS=LOGOUT_TIMEOUT/WINDOW_TIMER_INTERVAL;window.setTimeout(function do_logout(){Utils.getCachedAccessToken(function getAccessToken(access_token){if(access_token){var logoutService='https://www.facebook.com/logout.php?';var params=['next'+'='+encodeURIComponent(REDIRECT_LOGOUT_URI),'access_token'+'='+access_token];var logoutParams=params.join('&');var logoutUrl=logoutService+logoutParams;var loggedOut=false;var m_listen=function(e){if(e.origin!==fb.CONTACTS_APP_ORIGIN){return;}
if(e.data==='closed'){loggedOut=true;ImportStatusData.remove(STORAGE_KEY);outReq.done();}
e.stopImmediatePropagation();window.removeEventListener('message',m_listen);};window.addEventListener('message',m_listen);var logoutWindow=window.open(logoutUrl,'','dialog');var timerTicks=0;var timerId=window.setInterval(function(){timerTicks++;var closed=(logoutWindow.closed===true);var timedOut=(timerTicks>=MAX_TIMER_TICKS);if(loggedOut||closed||timedOut){window.clearInterval(timerId);window.removeEventListener('message',m_listen);}
if(closed&&!loggedOut){outReq.failed('UserCancelled');}
else if(timedOut&&!loggedOut){outReq.failed('Timeout');}},WINDOW_TIMER_INTERVAL);}
else{outReq.done();}});},0);return outReq;};Utils.FbContactsCleaner=function(contacts,pmode){this.lcontacts=contacts;var total=contacts.length;var next=0;var self=this;var CHUNK_SIZE=5;var numResponses=0;var mustUpdate=(pmode==='update');var notifyClean=false;var mustHold=false;var holded=false;var mustFinish=false;this.start=function(){mustHold=holded=mustFinish=false;if(total>0){cleanContacts(0);}
else if(typeof self.onsuccess==='function'){window.setTimeout(self.onsuccess);}};this.hold=function(){mustHold=true;};this.finish=function(){mustFinish=true;if(holded){notifySuccess();}};this.resume=function(){mustHold=holded=mustFinish=false;window.setTimeout(function resume_clean(){cleanContacts(next);});};function successHandler(e){if(notifyClean||typeof self.oncleaned==='function'){notifyClean=true;var cleaned=e.target.number;window.setTimeout(function(){self.oncleaned(cleaned);},0);}
continueCb();}
function errorHandler(contactid,error){if(typeof self.onerror==='function'){self.onerror(contactid,error);}
continueCb();}
function cleanContacts(from){for(var idx=from;idx<(from+CHUNK_SIZE)&&idx<total;idx++){var contact=contacts[idx];var number=idx;var req,fbContact;if(fb.isFbLinked(contact)){if(mustUpdate){fbContact=new fb.Contact(contact);req=fbContact.unlink('hard');}
else{fb.unlinkClearAll(contact);req=navigator.mozContacts.save(utils.misc.toMozContact(contact));}}
else{if(mustUpdate){fbContact=new fb.Contact(contact);req=fbContact.remove();}
else{req=navigator.mozContacts.remove(utils.misc.toMozContact(contact));}}
req.number=number;req.onsuccess=successHandler;req.onerror=function(e){errorHandler(contact.id,e.target.error);};}}
function notifySuccess(){if(typeof self.onsuccess==='function'){window.setTimeout(self.onsuccess);}}
function finishHandler(){var req=fb.contacts.flush();req.onsuccess=notifySuccess;req.onerror=function cleaner_flushError(){errorHandler(null,req.error);};}
function continueCb(){next++;numResponses++;if(next<total&&numResponses===CHUNK_SIZE){numResponses=0;if(!mustHold&&!mustFinish){cleanContacts(next);}
else if(mustFinish&&!holded){finishHandler();}
if(mustHold){holded=true;}}
else if(next>=total){finishHandler();}}};})(document);;'use strict';var fb=this.fb||{};var self=this;fb.utils=this.fb.utils||{};fb.DEFAULT_TIMEOUT=30000;fb.utils.runQuery=function(query,callback,access_token){function QueryRequest(){this.cancel=function(){if(typeof this.oncancel==='function'){window.setTimeout(function(){this.oncancel();}.bind(this),0);}};}
var outReq=new QueryRequest();var queryService='https://graph.facebook.com/fql?q=';queryService+=encodeURIComponent(query);var params=['access_token'+'='+access_token,'format=json'];var queryParams=params.join('&');var remote=queryService+'&'+queryParams;var xhr=new XMLHttpRequest({mozSystem:true});outReq.xhr=xhr;outReq.oncancel=function(){this.xhr.abort();};xhr.open('GET',remote,true);xhr.responseType='json';xhr.timeout=fb.operationsTimeout||fb.DEFAULT_TIMEOUT;xhr.onload=function(e){if(xhr.status===200||xhr.status===400||xhr.status===0){if(callback&&typeof callback.success==='function'){self.setTimeout(function(){callback.success(xhr.response);},0);}}
else{self.console.error('FB: HTTP error executing query. ',query,' Status: ',xhr.status);if(callback&&typeof callback.error==='function'){self.setTimeout(callback.error,0);}}};xhr.ontimeout=function(e){self.console.error('FB: Timeout!!! while executing query',query);if(callback&&typeof callback.timeout==='function'){self.setTimeout(callback.timeout,0);}};xhr.onerror=function(e){self.console.error('FB: Error while executing query: ',query,': ',e);if(callback&&typeof callback.error==='function'){self.setTimeout(function(){callback.error(e);},0);}};xhr.send();return outReq;};fb.utils.getFriendPicture=function(uid,callback,access_token,targetPictureSize){var imgSrc='https://graph.facebook.com/'+uid+'/picture?';var params=['width='+targetPictureSize,'access_token='+access_token,'t='+Date.now()];var imgService=imgSrc+params.join('&');var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',imgService,true);xhr.responseType='blob';xhr.timeout=fb.operationsTimeout||fb.DEFAULT_TIMEOUT;xhr.onload=function(e){if(xhr.status===200||xhr.status===0){var mblob=e.target.response;if(typeof callback==='function'){self.setTimeout(function(){callback(mblob);},0);}}
else{self.console.error('FB: HTTP error retrieving img for uid: ',uid,' Status: ',xhr.status);if(typeof callback==='function'){self.setTimeout(function(){callback(null);},0);}}};xhr.ontimeout=function(e){self.console.error('FB: Timeout!!! while retrieving img for uid: ',uid);if(typeof callback==='function'){self.setTimeout(function(){callback(null);},0);}};xhr.onerror=function(e){self.console.error('FB: Error while retrieving img for uid: ',uid,'Error: ',e);if(typeof callback==='function'){self.setTimeout(function(){callback(null);},0);}};xhr.send();};;'use strict';var fb=this.fb||{};this.fb=fb;if(!this.AuxFB){this.AuxFb=(function(){var CATEGORY='facebook';var NOT_LINKED='not_linked';var LINKED='fb_linked';function populate(source,target,propertyNames){propertyNames.forEach(function(property){var propertyValue=source[property];if(propertyValue){if(Array.isArray(propertyValue)){target[property]=propertyValue.slice(0,propertyValue.length);}else{target[property]=propertyValue;}}});}
function mergeFbData(dcontact,fbdata){var multipleFields=['email','tel','photo','org','adr'];multipleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=[];}
var items=fbdata[field];if(items){items.forEach(function(item){var dupList=checkDuplicates(field,item,dcontact[field],fbdata.shortTelephone);if(dupList.length===0){dcontact[field].push(item);}});}});var singleFields=['bday','anniversary'];singleFields.forEach(function(field){if(!dcontact[field]){dcontact[field]=fbdata[field];}});mergeNames(dcontact,fbdata);}
function mergeNames(devContact,fbContact){var namesChanged=false;var nameFields=['givenName','familyName'];nameFields.forEach(function(anameField){var fieldValue=devContact[anameField];var fbValue=fbContact[anameField];if((!Array.isArray(fieldValue)||fieldValue.length===0)&&Array.isArray(fbValue)&&fbValue.length>0){namesChanged=true;devContact[anameField]=(fieldValue&&fieldValue[0])||[];devContact[anameField].push(fbValue[0]);}});if(namesChanged){var givenName=devContact.givenName[0]||'';var familyName=devContact.familyName[0]||'';devContact.name=[givenName+' '+familyName];}}
function isFbContact(devContact){return(devContact&&devContact.category&&devContact.category.indexOf(CATEGORY)!==-1);}
function isFbLinked(devContact){return(devContact&&devContact.category&&devContact.category.indexOf(LINKED)!==-1);}
function getData(devContact){var outReq=new fb.utils.Request();window.setTimeout(function do_getData(){var uid=getFriendUid(devContact);if(uid){var fbreq=fb.contacts.get(uid);fbreq.onsuccess=function(){var fbdata=fbreq.result;var out=mergeContact(devContact,fbdata);outReq.done(out);};fbreq.onerror=function(){outReq.failed(fbreq.error);};}
else{outReq.done(devContact);}},0);return outReq;}
function getFriendUid(devContact){var out=devContact.uid;if(!out){if(isFbLinked(devContact)){out=getLinkedTo(devContact);}
else if(devContact.category){var idx=devContact.category.indexOf(CATEGORY);if(idx!==-1){out=devContact.category[idx+2];}}}
return out;}
function getLinkedTo(devContact){var out;if(devContact.category){var idx=devContact.category.indexOf(LINKED);if(idx!==-1){out=devContact.category[idx+1];}}
return out;}
function mergeContact(devContact,fbContact){var out=devContact;if(fbContact){out=Object.create(null);out.updated=devContact.updated;out.published=devContact.published;populate(devContact,out,Object.getOwnPropertyNames(devContact));populate(devContact,out,Object.getOwnPropertyNames(Object.getPrototypeOf(devContact)));mergeFbData(out,fbContact);}
return out;}
function getContactByNumber(number,onsuccess,onerror){var req=fb.contacts.getByPhone(number);req.onsuccess=function get_by_phone_success(e){var fbData=req.result;if(fbData){fb.getMozContactByUid(fbData.uid,function merge(result){if(Array.isArray(result)&&result[0]){var finalContact=fb.mergeContact(result[0],fbData);onsuccess(finalContact);}
else{onsuccess(null);}},function error_get_mozContact(err){console.error('Error getting mozContact: ',err.name);onerror(err);});}
else{onsuccess(null);}};req.onerror=function(){onerror(req.error);};}
function checkDuplicates(field,fbItem,devContactItems,extraFbItems){var potentialDuplicatesFields=['email','tel'];var out=[];if(devContactItems&&potentialDuplicatesFields.indexOf(field)!==-1){var total=devContactItems.length;for(var i=0;i<total;i++){var localValue=devContactItems[i].value;var fbValue=fbItem.value;if(localValue){var trimedLocal=localValue.trim();if(trimedLocal===fbValue||(field==='tel'&&Array.isArray(extraFbItems)&&extraFbItems.indexOf(trimedLocal)!==-1)){out.push(trimedLocal);out.push(fbValue);}}}}
return out;}
function getMozContactByUid(uid,onsuccess,onerror){var filter={filterBy:['category'],filterValue:uid,filterOp:'contains'};var req=navigator.mozContacts.find(filter);req.onsuccess=function(){onsuccess(req.result);};req.onerror=function(){onerror(req.error);};}
return{'isFbContact':isFbContact,'isFbLinked':isFbLinked,'getData':getData,'getFriendUid':getFriendUid,'getLinkedTo':getLinkedTo,'mergeContact':mergeContact,'getContactByNumber':getContactByNumber,'getMozContactByUid':getMozContactByUid,'checkDuplicates':checkDuplicates,get CATEGORY(){return CATEGORY;},get LINKED(){return LINKED;},get NOT_LINKED(){return NOT_LINKED;}};})();var props=Object.keys(this.AuxFb);var self=this;for(var j=0,end=props.length;j<end;j++){var prop=props[j];if(typeof self.fb[prop]==='function'){self.fb[prop]=self.AuxFb[prop];}
else{Object.defineProperty(self.fb,prop,{value:(function(){return self.AuxFb[prop];})(),writable:false,enumerable:true,configurable:false});}}};'use strict';var fb=this.fb||{};fb.PROPAGATED_PREFIX='fb_propagated_';fb.PROFILE_PHOTO_URI='fb_profile_photo';fb.FRIEND_URI='fb_friend';fb.DEFAULT_PHONE_TYPE='other';fb.DEFAULT_EMAIL_TYPE='other';fb.FLAG_YEAR_IGNORED=9996;fb.CONTACTS_APP_ORIGIN=location.origin;fb.isPropagated=function fcu_isPropagated(field,devContact){return(devContact.category&&devContact.category.indexOf(fb.PROPAGATED_PREFIX+field)!==-1);};fb.removePropagatedFlag=function fcu_removePropagatedFlag(field,devContact){var idx=devContact.category.indexOf(fb.PROPAGATED_PREFIX+field);if(idx!==-1){devContact.category.splice(idx,1);}};fb.setPropagatedFlag=function fcu_setPropagatedFlag(field,devContact){var idx=devContact.category.indexOf(fb.PROPAGATED_PREFIX+field);if(idx===-1){devContact.category.push(fb.PROPAGATED_PREFIX+field);}};fb.getFriendPictureUrl=function(devContact){var out;var urls=devContact.url;if(urls){for(var c=0;c<urls.length;c++){var aurl=urls[c];if(aurl.type.indexOf(fb.PROFILE_PHOTO_URI)!==-1){out=aurl.value;break;}}}
return out;};fb.setFriendPictureUrl=function(devContact,url){var urls=devContact.url||[];urls.push({type:[fb.PROFILE_PHOTO_URI],value:url});devContact.url=urls;};fb.friend2mozContact=function(f){function normalizeFbPhoneNumber(phone){var out=phone.number;if(phone.country_code&&out.indexOf('+')!==0){out='+'+phone.country_code+out;}
return out;}
if(Array.isArray(f.familyName)){return f;}
f.familyName=[f.last_name?f.last_name.trim():(f.last_name||'')];var middleName=f.middle_name?f.middle_name.trim():(f.middle_name||'');f.additionalName=middleName;var firstName=f.first_name?f.first_name.trim():(f.first_name||'');f.givenName=[(firstName+' '+middleName).trim()];delete f.last_name;delete f.middle_name;delete f.first_name;if(f.email){f.email1=f.email;f.email=[{type:[fb.DEFAULT_EMAIL_TYPE],value:f.email}];}
else{f.email1='';}
if(Array.isArray(f.phones)&&f.phones.length>0){f.tel=[];f.shortTelephone=[];f.phones.forEach(function(aphone){f.tel.push({type:[fb.DEFAULT_PHONE_TYPE],value:normalizeFbPhoneNumber(aphone)});f.shortTelephone.push(aphone.number);});}
delete f.phones;f.uid=f.uid.toString();return f;};fb.getWorksAt=function(fbdata){var out='';if(fbdata.work&&fbdata.work.length>0){out=fbdata.work[0].employer.name;}
return out;};fb.getBirthDate=function getBirthDate(sbday){var out=new Date(0);var imonth=sbday.indexOf('/');var smonth=sbday.substring(0,imonth);var iyear=sbday.lastIndexOf('/');if(iyear===imonth){iyear=sbday.length;}
var sday=sbday.substring(imonth+1,iyear);var syear=sbday.substring(iyear+1,sbday.length);out.setUTCDate(parseInt(sday,10));out.setUTCMonth(parseInt(smonth,10)-1,parseInt(sday,10));if(syear&&syear.length>0){out.setUTCFullYear(parseInt(syear,10));}
else{out.setUTCFullYear(fb.FLAG_YEAR_IGNORED);}
out.setUTCHours(0);out.setUTCMinutes(0);out.setUTCSeconds(0);out.setUTCMilliseconds(0);return out;};fb.getAddresses=function(fbdata){function fillAddress(fbAddress,type){var outAddr={};outAddr.type=[type];outAddr.locality=fbAddress.city||'';outAddr.region=fbAddress.state||'';outAddr.countryName=fbAddress.country||'';return outAddr;}
var out=[];var addrTypes={'home':'hometown_location','current':'current_location'};Object.keys(addrTypes).forEach(function onAddressType(type){var addrObj=fbdata[addrTypes[type]];if(addrObj){out.push(fillAddress(addrObj,type));}});return out;};fb.markAsUnlinked=function(devContact){var category=devContact.category;var updatedCategory=[];if(category){var idx=category.indexOf(fb.CATEGORY);if(idx!==-1){for(var c=0;c<idx;c++){updatedCategory.push(category[c]);}
for(c=idx+3;c<category.length;c++){updatedCategory.push(category[c]);}}}
devContact.category=updatedCategory;return devContact;};fb.unlinkClearAll=function(devContact){fb.resetNames(devContact);fb.markAsUnlinked(devContact);};fb.resetNames=function resetNames(dContact){if(fb.isPropagated('givenName',dContact)){dContact.givenName=[''];fb.removePropagatedFlag('givenName',dContact);}
if(fb.isPropagated('familyName',dContact)){dContact.familyName=[''];fb.removePropagatedFlag('familyName',dContact);}
dContact.name=[dContact.givenName[0]+' '+dContact.familyName[0]];};fb.markFbCleaningInProgress=function(value){utils.cookie.update({fbCleaningInProgress:value});};;'use strict';if(!window.ImportStatusData){var ImportStatusData=(function(){var store=null;var DS_NAME='Import_Status_Data';var datastoreLoading=false;var datastoreLoaded=false;var DS_LOADED_EVENT='datastore_loaded';var getDatastore=function getDatastore(){return new Promise(function(resolve,reject){if(!navigator.getDataStores){reject({name:'DatastoreNotEnabled'});return;}
if(datastoreLoaded){resolve(store);return;}
if(datastoreLoading){document.addEventListener(DS_LOADED_EVENT,function loadedHandler(){document.removeEventListener(DS_LOADED_EVENT,loadedHandler);resolve(store);});}
datastoreLoading=true;navigator.getDataStores(DS_NAME).then(function(stores){store=stores[0];},reject).then(function(){datastoreLoading=false;datastoreLoaded=true;document.dispatchEvent(new CustomEvent(DS_LOADED_EVENT));resolve(store);},reject);});};var put=function put(key,obj){return new Promise(function(resolve,reject){getDatastore().then(function success(store){store.put(obj,key).then(resolve,reject);},reject);});};var remove=function remove(key){return new Promise(function(resolve,reject){getDatastore().then(function success(store){store.remove(key).then(resolve,reject);},reject);});};var get=function get(key){return new Promise(function(resolve,reject){getDatastore().then(function success(store){store.get(key).then(resolve,reject);},reject);});};var clear=function clear(){return new Promise(function(resolve,reject){getDatastore().then(function success(store){store.clear().then(resolve,reject);},reject);});};return{put:put,remove:remove,get:get,clear:clear};})();};this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var MobileInfo={brazil:{carriers:{'00':'NEXTEL','02':'TIM','03':'TIM','04':'TIM','05':'CLARO','06':'VIVO','07':'CTBC','08':'TIM','10':'VIVO','11':'VIVO','15':'SERCOMTEL','16':'OI','23':'VIVO','24':'OI','31':'OI','32':'CTBC','33':'CTBC','34':'CTBC','37':'AEIOU'},regions:{'11':'SP','12':'SP','13':'SP','14':'SP','15':'SP','16':'SP','17':'SP','18':'SP','19':'SP','21':'RJ','22':'RJ','24':'RJ','27':'ES','28':'ES','31':'MG','32':'MG','33':'MG','34':'MG','35':'MG','37':'MG','38':'MG','41':'PR','42':'PR','43':'PR','44':'PR','45':'PR','46':'PR','47':'SC','48':'SC','49':'SC','51':'RS','53':'RS','54':'RS','55':'RS','61':'DF','62':'GO','63':'TO','64':'GO','65':'MT','66':'MT','67':'MS','68':'AC','69':'RO','71':'BA','73':'BA','74':'BA','75':'BA','77':'BA','79':'SE','81':'PE','82':'AL','83':'PB','84':'RN','85':'CE','86':'PI','87':'PE','88':'CE','89':'PI','91':'PA','92':'AM','93':'PA','94':'PA','95':'RR','96':'AP','97':'AM','98':'MA','99':'MA'}}};var MobileOperator={BRAZIL_MCC:'724',BRAZIL_CELLBROADCAST_CHANNEL:50,userFacingInfo:function mo_userFacingInfo(mobileConnection){var network=mobileConnection.voice.network;var iccid=mobileConnection.iccId;var iccObj=navigator.mozIccManager.getIccById(iccid);var iccInfo=iccObj?iccObj.iccInfo:null;var operator=network?(network.shortName||network.longName):null;if(operator&&iccInfo&&iccInfo.isDisplaySpnRequired&&iccInfo.spn){if(iccInfo.isDisplayNetworkNameRequired&&operator!==iccInfo.spn){operator=operator+' '+iccInfo.spn;}else{operator=iccInfo.spn;}}
var carrier,region;if(this.isBrazil(mobileConnection)){var lac=mobileConnection.voice.cell.gsmLocationAreaCode%100;var carriers=MobileInfo.brazil.carriers;var regions=MobileInfo.brazil.regions;carrier=carriers[network.mnc]||(this.BRAZIL_MCC+network.mnc);region=(regions[lac]?regions[lac]+' '+lac:'');}
return{'operator':operator,'carrier':carrier,'region':region};},isBrazil:function mo_isBrazil(mobileConnection){var cell=mobileConnection.voice.cell;var net=mobileConnection.voice.network;return net?(net.mcc===this.BRAZIL_MCC&&cell&&cell.gsmLocationAreaCode):null;}};;'use strict';(function(exports){var _iccManager=navigator.mozIccManager;var _iccProxy=null;Object.defineProperty(exports,'IccHelper',{configurable:true,get:function(){return _iccProxy;},set:function(value){_iccProxy=value;}});if(_iccManager&&_iccManager.getIccById){var activeIccObj=null;var eventListeners={};var cachedEventListeners={};var events=['cardstatechange','iccinfochange','stkcommand','stksessionend'];var getters=['iccInfo','cardState'];var methods=['sendStkResponse','sendStkMenuSelection','sendStkTimerExpiration','sendStkEventDownload'];var domRequests=['getCardLock','unlockCardLock','setCardLock','getCardLockRetryCount','readContacts','updateContact','iccOpenChannel','iccExchangeAPDU','iccCloseChannel'];var getterTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name];}else{return null;}};};var methodTemplate=function(name){return function(){if(activeIccObj){return activeIccObj[name].apply(activeIccObj,arguments);}};};var createIccProxy=function(){var iccProxy={addEventListener:function(eventName,callback){if(typeof callback!=='function'){return;}
if(events.indexOf(eventName)===-1){return;}
var listeners=eventListeners[eventName];if(listeners==null){listeners=eventListeners[eventName]=[];}
if(listeners.indexOf(callback)===-1){listeners.push(callback);}},removeEventListener:function(eventName,callback){var listeners=eventListeners[eventName];if(listeners){var index=listeners.indexOf(callback);if(index!==-1){listeners.splice(index,1);}}}};getters.forEach(function(getter){Object.defineProperty(iccProxy,getter,{enumerable:true,get:getterTemplate(getter)});});methods.forEach(function(method){iccProxy[method]=methodTemplate(method);});domRequests.forEach(function(request){iccProxy[request]=methodTemplate(request);});events.forEach(function(eventName){Object.defineProperty(iccProxy,'on'+eventName,{enumerable:true,set:function(newListener){var oldListener=cachedEventListeners[eventName];if(oldListener){iccProxy.removeEventListener(eventName,oldListener);}
cachedEventListeners[eventName]=newListener;if(newListener){iccProxy.addEventListener(eventName,newListener);}},get:function(){return cachedEventListeners[eventName];}});});return iccProxy;};_iccProxy=createIccProxy();if(_iccManager.iccIds&&_iccManager.iccIds.length){activeIccObj=_iccManager.getIccById(_iccManager.iccIds[0]);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});}}
_iccManager.oniccdetected=function(event){if(_iccProxy.cardState==null){activeIccObj=_iccManager.getIccById(event.iccId);if(activeIccObj){events.forEach(function(eventName){activeIccObj.addEventListener(eventName,function(event){var listeners=eventListeners[eventName];if(listeners){listeners.forEach(function(listener){listener(event);});}});});['cardstatechange','iccinfochange'].forEach(function(eventName){if(eventListeners[eventName]){eventListeners[eventName].forEach(function(listener){listener();});}});}}};}else{_iccProxy=_iccManager;}})(window);;'use strict';var WifiHelper={getWifiManager:function(){return this.wifiManager;},wifiManager:function(){return navigator.mozWifiManager;}(),setPassword:function(network,password,identity,eap,phase2,certificate){var encType=this.getKeyManagement(network);switch(encType){case'WPA-PSK':network.psk=password;break;case'WPA-EAP':network.eap=eap;switch(eap){case'SIM':break;case'PEAP':case'TLS':case'TTLS':if(password&&password.length){network.password=password;}
if(identity&&identity.length){network.identity=identity;}
if(phase2!='No'){network.phase2=phase2;}
if(certificate!='none'){network.serverCertificate=certificate;}
break;default:break;}
break;case'WEP':network.wep=password;break;default:return;}
network.keyManagement=encType;},setSecurity:function(network,encryptions){network.security=encryptions;},getSecurity:function(network){return network.security;},getCapabilities:function(network){return network.capabilities===undefined||network.capabilities===null?[]:network.capabilities;},getKeyManagement:function(network){var key=this.getSecurity(network)[0];if(/WEP$/.test(key)){return'WEP';}
if(/PSK$/.test(key)){return'WPA-PSK';}
if(/EAP$/.test(key)){return'WPA-EAP';}
return'';},isConnected:function(network){var currentNetwork=this.wifiManager.connection.network;if(!currentNetwork||!network){return false;}
var key=network.ssid+'+'+this.getSecurity(network).join('+');var curkey=currentNetwork.ssid+'+'+
this.getSecurity(currentNetwork).join('+');return key===curkey;},isValidInput:function(key,password,identity,eap){function isValidWepKey(password){switch(password.length){case 5:case 13:case 16:case 29:return true;case 10:case 26:case 32:case 58:return!/[^a-fA-F0-9]/.test(password);default:return false;}}
switch(key){case'WPA-PSK':if(!password||password.length<8){return false;}
break;case'WPA-EAP':switch(eap){case'SIM':break;case'PEAP':case'TLS':case'TTLS':default:if(!password||password.length<1||!identity||identity.length<1){return false;}
break;}
break;case'WEP':if(!password||!isValidWepKey(password)){return false;}
break;}
return true;},isWpsAvailable:function(network){var capabilities=this.getCapabilities(network);for(var i=0;i<capabilities.length;i++){if(/WPS/.test(capabilities[i])){return true;}}
return false;},isOpen:function(network){return this.getKeyManagement(network)==='';},isEap:function(network){return this.getKeyManagement(network).indexOf('EAP')!==-1;},_unionOfNetworks:function(available,known){var allNetworks=available||{};var result=[];Object.keys(known).forEach(function(key){if(!allNetworks[key]){allNetworks[key]=known[key];}});Object.keys(allNetworks).forEach(function(key){result.push(allNetworks[key]);});return result;},_networksArrayToObject:function(allNetworks){var self=this;var networksObject={};[].forEach.call(allNetworks,function(network){var key=network.ssid+'+'+
self.getSecurity(network).join('+');networksObject[key]=network;});return networksObject;},_onReqProxySuccess:function(reqProxy,availableNetworks,knownNetworks){reqProxy.result=this._unionOfNetworks(availableNetworks,knownNetworks);reqProxy.onsuccess();},getAvailableAndKnownNetworks:function(){var self=this;var reqProxy={onsuccess:function(){},onerror:function(){}};var knownNetworks={};var availableNetworks={};var knownNetworksReq=null;var availableNetworksReq=this.getWifiManager().getNetworks();availableNetworksReq.onsuccess=function anrOnSuccess(){availableNetworks=self._networksArrayToObject(availableNetworksReq.result);knownNetworksReq=self.getWifiManager().getKnownNetworks();knownNetworksReq.onsuccess=function knrOnSuccess(){knownNetworks=self._networksArrayToObject(knownNetworksReq.result);self._onReqProxySuccess(reqProxy,availableNetworks,knownNetworks);};knownNetworksReq.onerror=function knrOnError(){self._onReqProxySuccess(reqProxy,availableNetworks,knownNetworks);};};availableNetworksReq.onerror=function anrOnError(){reqProxy.error=availableNetworksReq.error;reqProxy.onerror();};return reqProxy;}};;'use strict';var FxAccountsIACHelper=function FxAccountsIACHelper(){var DEFAULT_CONNECTION_STRING='fxa-mgmt';var default_rules={'manifestURLs':['app://system.gaiamobile.org/manifest.webapp']};var CONNECTION_STRING=DEFAULT_CONNECTION_STRING;var rules=default_rules;var port;var callbacks={};var eventListeners={};var init=function init(options){if(!options){return;}
if(options.keyword&&typeof(options.keyword)=='string'&&options.keyword.length>0){CONNECTION_STRING=options.keyword;}
if(options.rules&&typeof(options.rules)=='object'){rules=options.rules;}};var addEventListener=function addEventListener(eventName,listener){if(!eventListeners[eventName]){eventListeners[eventName]=[];}
eventListeners[eventName].push(listener);};var removeEventListener=function removeEventListener(eventName,listener){var listeners=eventListeners[eventName];if(!listeners){return;}
var index=listeners.indexOf(listener);if(index===-1){return;}
listeners.splice(index,1);};var reset=function reset(){CONNECTION_STRING=DEFAULT_CONNECTION_STRING;rules=default_rules;eventListeners={};callbacks={};port=null;};var onMessage=function onMessage(evt){if(evt&&evt.data){var message=evt.data;if(message.eventName){var listeners=eventListeners[message.eventName];if(!listeners){return;}
for(var listener in listeners){if(listeners[listener]&&typeof listeners[listener]==='function'){listeners[listener]();}}
return;}
var cbs,cb;if(message.methodName){cbs=callbacks[message.methodName];if(!cbs||!cbs.length){console.warn('No callbacks for method '+message.methodName);return;}
while(cbs.length){cb=cbs.shift();if(!message.error){cb.successCb(message.data);}else{cb.errorCb(message.error);}}}}else{console.error('Unknown');}};var getSelf=function getSelf(cb,error){var request=navigator.mozApps.getSelf();request.onsuccess=function onSuccess(evt){cb(evt.target.result);};request.onerror=function onError(){if(error&&typeof(error)==='function'){error();}};};var requestQueue=[];var isConnecting=false;var connect=function connect(cb){if(isConnecting){return requestQueue.push(cb);}
isConnecting=true;_connect(function onConnect(err){var next;isConnecting=false;if(typeof cb==='function'){cb(err);}
while(next=requestQueue.shift()){next&&next(err);}});};var _connect=function _connect(callback){getSelf(function onApp(app){if(!app){return;}
app.connect(CONNECTION_STRING,rules).then(function(ports){if(!ports||ports.length!==1){return;}
port=ports[0];callback&&callback();});});};var sendMessage=function sendMessage(message,successCb,errorCb){if(port){_sendMessage(message,successCb,errorCb);return;}
connect(function(){_sendMessage(message,successCb,errorCb);});};var _sendMessage=function _sendMessage(message,successCb,errorCb){var name=message.name;if(!name){return;}
if(!callbacks[name]){callbacks[name]=[];}
callbacks[name].push({successCb:successCb,errorCb:errorCb});port.onmessage=onMessage;port.postMessage(message);};var getAccounts=function getAccounts(successCb,errorCb){sendMessage({'name':'getAccounts'},successCb,errorCb);};var openFlow=function openFlow(successCb,errorCb){sendMessage({'name':'openFlow'},successCb,errorCb);};var logout=function logout(successCb,errorCb){sendMessage({'name':'logout'},successCb,errorCb);};var refreshAuthentication=function refreshAuthentication(email,successCb,errorCb){sendMessage({'name':'refreshAuthentication','email':email},successCb,errorCb);};var resendVerificationEmail=function resendVerificationEmail(email,successCb,errorCb){sendMessage({'name':'resendVerificationEmail','email':email},successCb,errorCb);};connect();return{'addEventListener':addEventListener,'getAccounts':getAccounts,'init':init,'logout':logout,'openFlow':openFlow,'refreshAuthentication':refreshAuthentication,'removeEventListener':removeEventListener,'resendVerificationEmail':resendVerificationEmail,'reset':reset};}();;'use strict';var SimManager=(function(){function Icc(mozIcc){this.mozIcc=mozIcc;}
Icc.prototype={skipped:false,unlocked:false,alreadyImported:false,mozIcc:null,isLocked:function(){return!this.unlocked&&lockStates.indexOf(this.mozIcc.cardState)!==-1;}};function showRetryCount(icc,lockType,uiElement){var request=icc.mozIcc.getCardLockRetryCount(lockType);request.onsuccess=function(){var retryCount=request.result.retryCount;if(retryCount){var l10nArgs={n:retryCount};navigator.mozL10n.setAttributes(uiElement,'inputCodeRetriesLeft',l10nArgs);uiElement.classList.remove('hidden');}};request.onerror=function(){console.error('Could not fetch CardLockRetryCount',request.error.name);};}
var lockStates=['pinRequired','pukRequired','networkLocked','corporateLocked','serviceProviderLocked','network1Locked','network2Locked','hrpdNetworkLocked','ruimCorporateLocked','ruimServiceProviderLocked'];return{icc0:null,icc1:null,simSlots:window.navigator.mozMobileConnections?window.navigator.mozMobileConnections.length:0,_unlockingIcc:null,init:function sm_init(){this.mobConn=window.navigator.mozMobileConnections;if(!this.mobConn){return;}
this.iccManager=window.navigator.mozIccManager;if(!this.iccManager){return;}
this.icc0=null;this.icc1=null;if(this.iccManager.iccIds[0]){this.updateIccState(this.iccManager.iccIds[0]);}
if(this.iccManager.iccIds[1]){this.updateIccState(this.iccManager.iccIds[1]);}
this.iccManager.addEventListener('iccdetected',this.handleIccState.bind(this));this.alreadyImported=false;},handleUnlockError:function sm_handleUnlockError(lockType,retryCount){var l10nArgs={n:retryCount};switch(lockType){case'pin':if(retryCount===0){this.showPukScreen(this._unlockingIcc);break;}
UIManager.pinInput.value='';UIManager.pinInput.classList.add('onerror');UIManager.pinError.classList.remove('hidden');navigator.mozL10n.setAttributes(UIManager.pinRetriesLeft,'inputCodeRetriesLeft',l10nArgs);UIManager.pinRetriesLeft.classList.remove('hidden');if(retryCount===1){UIManager.pinError.querySelector('.lastchance').classList.remove('hidden');}else{navigator.mozL10n.setAttributes(UIManager.pinError.querySelector('.main'),'pinAttemptMsg2',l10nArgs);UIManager.pinError.querySelector('.main').classList.remove('hidden');}
break;case'puk':UIManager.pukInput.value='';UIManager.pukInput.classList.add('onerror');UIManager.pukError.classList.remove('hidden');UIManager.pukInfo.classList.add('hidden');navigator.mozL10n.setAttributes(UIManager.pukRetriesLeft,'inputCodeRetriesLeft',l10nArgs);UIManager.pukRetriesLeft.classList.remove('hidden');if(retryCount===1){UIManager.pukError.querySelector('.lastchance').classList.remove('hidden');}else{navigator.mozL10n.setAttributes(UIManager.pukError.querySelector('.main'),'pukAttemptMsg2',l10nArgs);UIManager.pukError.querySelector('.main').classList.remove('hidden');}
break;case'nck':case'cck':case'spck':UIManager.xckInput.value='';UIManager.xckInput.classList.add('onerror');UIManager.xckError.classList.remove('hidden');UIManager.xckInfo.classList.add('hidden');navigator.mozL10n.setAttributes(UIManager.xckRetriesLeft,'inputCodeRetriesLeft',l10nArgs);UIManager.xckRetriesLeft.classList.remove('hidden');if(retryCount==1){UIManager.xckError.querySelector('.lastchance').classList.remove('hidden');}else{navigator.mozL10n.setAttributes(UIManager.xckError.querySelector('.main'),'nckAttemptMsg2',l10nArgs);UIManager.xckError.querySelector('.main').classList.remove('hidden');}
break;}},available:function sm_available(){var icc=this.guessIcc();return(icc&&icc.cardState==='ready');},handleIccState:function sm_handleIccState(event){this.updateIccState(event.iccId);},updateIccState:function(iccId){var iccInfo=this.iccManager.getIccById(iccId);if(!iccInfo){throw new Error('Unrecognized iccID: '+iccId);}
if(this.mobConn[0]&&iccId===this.mobConn[0].iccId){this.icc0=new Icc(iccInfo);}else if(this.mobConn[1]&&iccId===this.mobConn[1].iccId){this.icc1=new Icc(iccInfo);}else{console.warn('ICC detected in unsupported slot',iccId);}},handleCardState:function sm_handleCardState(callback,skipUnlockScreen){this._unlockingIcc=null;SimManager.checkSIMButton();if(typeof callback==='function'){this.finishCallback=callback;}
if(this.shouldShowUnlockScreen(this.icc0)&&!skipUnlockScreen){this.showUnlockScreen(this.icc0);}else if(this.shouldShowUnlockScreen(this.icc1)&&!skipUnlockScreen){this.showUnlockScreen(this.icc1);}else if(this.shouldShowSIMInfoScreen()){this.resetSkipped();this.showSIMInfoScreen();}else{this.resetSkipped();this.finish();}},finish:function(){this.hideScreen();this.hideSIMInfoScreen();var showCellData=(this.icc0&&!this.icc0.isLocked())||(this.icc1&&!this.icc1.isLocked());this.finishCallback&&this.finishCallback(showCellData);},shouldShowUnlockScreen:function sm_shouldShowLockScreen(icc){return icc&&!icc.skipped&&icc.isLocked();},shouldShowSIMInfoScreen:function sm_shouldShowSIMInfoScreen(){return(this.icc0&&this.icc1);},showUnlockScreen:function sm_showUnlockScreen(icc){if(icc.unlocked){return;}
this._unlockingIcc=icc;switch(icc.mozIcc.cardState){case'pinRequired':this.showPinScreen(icc);break;case'pukRequired':this.showPukScreen(icc);break;case'networkLocked':case'corporateLocked':case'serviceProviderLocked':case'network1Locked':case'network2Locked':case'hrpdNetworkLocked':case'ruimCorporateLocked':case'ruimServiceProviderLocked':this.showXckScreen(icc);break;default:throw new Error('Cannot show SIM unlock screen, unknown cardState '+
icc.mozIcc.cardState);}},voiceChangeListeners:[],updateSIMInfoText:function sm_updateSIMInfoText(icc){var iccNumber=(icc===this.icc0)?1:2;if(icc&&icc.isLocked()){UIManager['simInfo'+iccNumber].classList.add('locked');UIManager['simCarrier'+iccNumber].setAttribute('data-l10n-id','simPinLocked');UIManager['simNumber'+iccNumber].removeAttribute('data-l10n-id');UIManager['simNumber'+iccNumber].textContent='';}else{UIManager['simInfo'+iccNumber].classList.remove('locked');var mobConn=this.mobConn[iccNumber-1];var operator=MobileOperator.userFacingInfo(mobConn).operator;if(!operator&&!this.voiceChangeListeners[iccNumber-1]){this.voiceChangeListeners[iccNumber-1]=function(evt){var operator=MobileOperator.userFacingInfo(mobConn).operator;if(operator){UIManager['simCarrier'+iccNumber].removeAttribute('data-l10n-id');UIManager['simCarrier'+iccNumber].textContent=operator;mobConn.removeEventListener('voicechange',this.voiceChangeListeners[iccNumber-1]);this.voiceChangeListeners[iccNumber-1]=null;}}.bind(this);mobConn.addEventListener('voicechange',this.voiceChangeListeners[iccNumber-1]);}
if(operator){UIManager['simCarrier'+iccNumber].removeAttribute('data-l10n-id');UIManager['simCarrier'+iccNumber].textContent=operator;}else{UIManager['simCarrier'+iccNumber].setAttribute('data-l10n-id','searchingOperator');}
var number=icc.mozIcc.iccInfo.msisdn||icc.mozIcc.iccInfo.mdn||'';if(number){UIManager['simNumber'+iccNumber].textContent=number;UIManager['simInfo'+iccNumber].classList.remove('no-number');}else{UIManager['simInfo'+iccNumber].classList.add('no-number');}}},showSIMInfoScreen:function sm_showSIMInfoScreen(){this.updateSIMInfoText(this.icc0);this.updateSIMInfoText(this.icc1);UIManager.activationScreen.classList.remove('show');UIManager.simInfoScreen.classList.add('show');},hideSIMInfoScreen:function sm_hidescreen(){UIManager.simInfoScreen.classList.remove('show');UIManager.activationScreen.classList.add('show');},checkSIMButton:function sm_checkSIMButton(){if(!this.mobConn){UIManager.simImport.classList.add('hidden');return;}
var simOption=UIManager.simImportButton;if(!SimManager.alreadyImported&&SimManager.available()){simOption.removeAttribute('disabled');UIManager.noSim.classList.add('hidden');}else{simOption.setAttribute('disabled','disabled');if(!SimManager.alreadyImported){UIManager.noSim.classList.remove('hidden');}}},showPinScreen:function sm_showPinScreen(icc){showRetryCount(icc,'pin',UIManager.pinRetriesLeft);UIManager.unlockSimButton.disabled=true;UIManager.pinInput.addEventListener('input',function sm_checkInput(event){UIManager.unlockSimButton.disabled=(event.target.value.length<4);});UIManager.activationScreen.classList.remove('show');UIManager.unlockSimScreen.classList.add('show');UIManager.pincodeScreen.classList.add('show');UIManager.xckcodeScreen.classList.remove('show');UIManager.unlockSimHeader.setAttribute('data-l10n-id','pincode2');if(this.simSlots>1){var simNumber=icc===this.icc0?1:2;navigator.mozL10n.setAttributes(UIManager.pinLabel,'pincodeLabel',{n:simNumber});}else{UIManager.pinLabel.setAttribute('data-l10n-id','type_pin');}
UIManager.pinInput.focus();},showPukScreen:function sm_showPukScreen(icc){showRetryCount(icc,'puk',UIManager.pukRetriesLeft);UIManager.unlockSimScreen.classList.add('show');UIManager.activationScreen.classList.remove('show');UIManager.pincodeScreen.classList.remove('show');UIManager.pukcodeScreen.classList.add('show');UIManager.xckcodeScreen.classList.remove('show');UIManager.unlockSimHeader.setAttribute('data-l10n-id','pukcode');if(this.simSlots>1){var simNumber=icc===this.icc0?1:2;navigator.mozL10n.setAttributes(UIManager.pukLabel,'pukcodeLabel',{n:simNumber});}else{UIManager.pukLabel.setAttribute('data-l10n-id','type_puk');}
UIManager.pukInput.focus();},showXckScreen:function sm_showXckScreen(icc){var lockType;switch(icc.mozIcc.cardState){case'networkLocked':lockType='nck';break;case'corporateLocked':lockType='cck';break;case'serviceProviderLocked':lockType='spck';break;case'network1Locked':lockType='nck1';break;case'network2Locked':lockType='nck2';break;case'hrpdNetworkLocked':lockType='hnck';break;case'ruimCorporateLocked':lockType='rcck';break;case'ruimServiceProviderLocked':lockType='rspck';break;default:return;}
showRetryCount(icc,lockType,UIManager.xckRetriesLeft);UIManager.unlockSimScreen.classList.add('show');UIManager.activationScreen.classList.remove('show');UIManager.pincodeScreen.classList.remove('show');UIManager.pukcodeScreen.classList.remove('show');UIManager.xckcodeScreen.classList.add('show');var simNumber=icc===this.icc0?1:2;switch(icc.mozIcc.cardState){case'networkLocked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'nckcodeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'nckcodeLabel',{n:simNumber});break;case'corporateLocked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'cckcodeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'cckcodeLabel',{n:simNumber});break;case'serviceProviderLocked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'spckcodeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'spckcodeLabel',{n:simNumber});break;case'network1Locked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'nck1codeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'nck1codeLabel',{n:simNumber});break;case'network2Locked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'nck2codeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'nck2codeLabel',{n:simNumber});break;case'hrpdNetworkLocked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'hnckcodeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'hnckcodeLabel',{n:simNumber});break;case'ruimCorporateLocked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'rcckcodeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'rcckcodeLabel',{n:simNumber});break;case'ruimServiceProviderLocked':navigator.mozL10n.setAttributes(UIManager.unlockSimHeader,'rspckcodeTitle',{n:simNumber});navigator.mozL10n.setAttributes(UIManager.xckLabel,'rspckcodeLabel',{n:simNumber});break;}
UIManager.xckInput.focus();},resetForm:function sm_clearInputs(){this.clearFields();UIManager.newpinInput.value='';UIManager.confirmNewpinInput.value='';UIManager.pinInput.value='';UIManager.pukInput.value='';UIManager.pukInfo.classList.remove('hidden');UIManager.xckInput.value='';UIManager.unlockSimButton.disabled=false;},hideScreen:function sm_hideScreen(){UIManager.unlockSimScreen.classList.remove('show');UIManager.pincodeScreen.classList.remove('show');UIManager.pukcodeScreen.classList.remove('show');UIManager.xckcodeScreen.classList.remove('show');UIManager.activationScreen.classList.add('show');},skip:function sm_skip(){if(this._unlockingIcc){this._unlockingIcc.skipped=true;}
this.resetForm();this.hideScreen();this.handleCardState();},resetSkipped:function sm_resetSkipped(){if(this.icc0){this.icc0.skipped=false;}
if(this.icc1){this.icc1.skipped=false;}},back:function sm_back(){this.resetForm();this.resetSkipped();this.hideScreen();this.hideSIMInfoScreen();Navigation.back();},simUnlockBack:function sm_simUnlockBack(){if(this.icc0&&this.icc0.skipped){this.icc0.skipped=false;this.hideScreen();this.handleCardState();}else{this.back();}},unlock:function sm_unlock(){var icc=this._unlockingIcc;if(!icc){throw new Error('Cannot unlock SIM, no current ICC');}
this.clearFields();switch(icc.mozIcc.cardState){case'pinRequired':this.unlockPin(icc);break;case'pukRequired':this.unlockPuk(icc);break;case'networkLocked':case'corporateLocked':case'serviceProviderLocked':case'network1Locked':case'network2Locked':case'hrpdNetworkLocked':case'ruimCorporateLocked':case'ruimServiceProviderLocked':this.unlockXck(icc);break;}},unlockPin:function sm_unlockPin(icc){var pin=UIManager.pinInput.value;if(pin.length<4||pin.length>8){UIManager.pinError.querySelector('.main').setAttribute('data-l10n-id','pinValidation');UIManager.pinInput.classList.add('onerror');UIManager.pinError.classList.remove('hidden');UIManager.pinInput.focus();return;}else{UIManager.pinInput.classList.remove('onerror');UIManager.pinError.classList.add('hidden');}
this.attemptUnlock(icc,{lockType:'pin',pin:pin});},clearFields:function sm_clearFields(){UIManager.pukInput.classList.remove('onerror');UIManager.pukError.classList.add('hidden');UIManager.newpinInput.classList.remove('onerror');UIManager.newpinError.classList.add('hidden');UIManager.confirmNewpinInput.classList.remove('onerror');UIManager.confirmNewpinError.classList.add('hidden');UIManager.pinError.classList.add('hidden');UIManager.pinError.querySelector('.main').classList.add('hidden');UIManager.pinError.querySelector('.lastchance').classList.add('hidden');UIManager.pinRetriesLeft.classList.add('hidden');UIManager.pukError.classList.add('hidden');UIManager.pukError.querySelector('.main').classList.add('hidden');UIManager.pukError.querySelector('.lastchance').classList.add('hidden');UIManager.pukRetriesLeft.classList.add('hidden');UIManager.xckError.classList.add('hidden');UIManager.xckError.querySelector('.main').classList.add('hidden');UIManager.xckError.querySelector('.lastchance').classList.add('hidden');UIManager.xckRetriesLeft.classList.add('hidden');},unlockPuk:function sm_unlockPuk(icc){var pukCode=UIManager.pukInput.value;if(pukCode.length!==8){UIManager.pukError.querySelector('.main').setAttribute('data-l10n-id','pukValidation');UIManager.pukError.classList.remove('hidden');UIManager.pukInfo.classList.add('hidden');UIManager.pukInput.classList.add('onerror');UIManager.pukError.focus();return;}
var newpinCode=UIManager.newpinInput.value;var confirmNewpin=UIManager.confirmNewpinInput.value;if(newpinCode.length<4||newpinCode.length>8){UIManager.newpinError.setAttribute('data-l10n-id','pinValidation');UIManager.newpinError.classList.remove('hidden');UIManager.newpinInput.classList.add('onerror');UIManager.newpinError.focus();return;}
if(newpinCode!=confirmNewpin){UIManager.confirmNewpinError.setAttribute('data-l10n-id','newpinConfirmation');UIManager.confirmNewpinError.classList.remove('hidden');UIManager.newpinInput.classList.add('onerror');UIManager.confirmNewpinInput.classList.add('onerror');UIManager.confirmNewpinError.focus();return;}
var options={lockType:'puk',puk:pukCode,newPin:newpinCode};this.attemptUnlock(icc,options);},unlockXck:function sm_unlockXck(icc){var xck=UIManager.xckInput.value;var lockType;switch(icc.mozIcc.cardState){case'networkLocked':lockType='nck';break;case'corporateLocked':lockType='cck';break;case'serviceProviderLocked':lockType='spck';break;case'network1Locked':lockType='nck1';break;case'network2Locked':lockType='nck2';break;case'hrpdNetworkLocked':lockType='hnck';break;case'ruimCorporateLocked':lockType='rcck';break;case'ruimServiceProviderLocked':lockType='rspck';break;}
if(xck.length<8||xck.length>16){UIManager.xckInput.classList.add('onerror');UIManager.xckError.classList.remove('hidden');UIManager.xckError.querySelector('.main').setAttribute('data-l10n-id',lockType+'Validation');UIManager.xckInput.focus();return;}else{UIManager.pinInput.classList.remove('onerror');UIManager.pinError.classList.add('hidden');}
var options={lockType:lockType,pin:xck};this.attemptUnlock(icc,options);},attemptUnlock:function sm_attemptUnlock(icc,options){var req=icc.mozIcc.unlockCardLock(options);req.onsuccess=(function sm_unlockSuccess(){icc.unlocked=true;this.resetForm();this.hideScreen();this.handleCardState();}).bind(this);req.onerror=(function sm_unlockError(){this.handleUnlockError(options.lockType,req.error.retryCount);}).bind(this);},guessIcc:function guessIcc(){var tempIcc=null;if(navigator.mozMobileConnections){for(var i=0;i<navigator.mozMobileConnections.length&&tempIcc===null;i++){if(navigator.mozMobileConnections[i]!==null&&navigator.mozMobileConnections[i].iccId!==null){tempIcc=navigator.mozIccManager.getIccById(navigator.mozMobileConnections[i].iccId);}}}else{tempIcc=navigator.mozIccManager;}
return tempIcc;},importContacts:function sm_importContacts(){var DELAY_FEEDBACK=300;UIManager.navBar.setAttribute('aria-disabled','true');var progress=utils.overlay.show('simContacts-reading','activityBar');var importButton=UIManager.simImportButton;var cancelled=false,contactsRead=false;var importer=new SimContactsImporter(SimManager.guessIcc());utils.overlay.showMenu();utils.overlay.oncancel=function oncancel(){cancelled=true;importer.finish();if(contactsRead){progress.setClass('activityBar');utils.overlay.hideMenu();progress.setHeaderMsg('messageCanceling');}else{importer.onfinish();}};var importedContacts=0;importer.onread=function sim_import_read(n){contactsRead=true;if(n>0){progress.setClass('progressBar');progress.setHeaderMsg('simContacts-importing');progress.setTotal(n);}};importer.onimported=function imported_contact(){importedContacts++;if(!cancelled){progress.update();}};importer.onfinish=function sim_import_finish(numDupsMerged,iccId){window.setTimeout(function do_sim_import_finish(){UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();if(importedContacts>0){utils.misc.setTimestamp('sim-'+iccId);}
if(!cancelled){SimManager.alreadyImported=true;importButton.setAttribute('disabled','disabled');utils.status.show({id:'simContacts-imported3',args:{n:importedContacts}});}},DELAY_FEEDBACK);importer.onfinish=null;};importer.onerror=function sim_import_error(){UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();importButton.removeAttribute('disabled');var cancel={title:'cancel',callback:function(){ConfirmDialog.hide();}};var retry={title:'retry',isRecommend:true,callback:function(){ConfirmDialog.hide();importButton.click();}};ConfirmDialog.show(null,'simContacts-error',cancel,retry);};importer.start();}};})();;'use strict';var SdManager={available:function(){return utils.sdcard.checkStorageCard();},checkSDButton:function sm_checkSDButton(){var sdOption=UIManager.sdImportButton;if(!SdManager.alreadyImported&&SdManager.available()){sdOption.removeAttribute('disabled');UIManager.noMemorycard.classList.add('hidden');}else{sdOption.setAttribute('disabled','disabled');if(!SdManager.alreadyImported){UIManager.noMemorycard.classList.remove('hidden');}}},importContacts:function sm_importContacts(){var DELAY_FEEDBACK=200;var importedContacts=0;UIManager.navBar.setAttribute('aria-disabled','true');var cancelled=false;var importer=null;var progress=utils.overlay.show('memoryCardContacts-reading','activityBar');utils.overlay.showMenu();utils.overlay.oncancel=function(){cancelled=true;if(importer){importer.finish();}else{UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();}};var importButton=UIManager.sdImportButton;utils.sdcard.retrieveFiles(['text/vcard','text/directory;profile=vCard','text/directory'],['vcf','vcard'],function(err,fileArray){if(err){return import_error(err);}
if(cancelled){return;}
if(fileArray.length){utils.sdcard.getTextFromFiles(fileArray,'',onFiles);}else{import_error('No contacts were found.');}});function onFiles(err,text){if(err){return import_error(err);}
if(cancelled){return;}
importer=new VCFReader(text);if(!text||!importer){return import_error('No contacts were found.');}
importer.onread=import_read;importer.onimported=imported_contact;importer.onerror=import_error;importer.process(function import_finish(){window.setTimeout(function onfinish_import(){utils.misc.setTimestamp('sd');UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();if(!cancelled){SdManager.alreadyImported=true;importButton.setAttribute('disabled','disabled');utils.status.show({id:'memoryCardContacts-imported3',args:{n:importedContacts}});}},DELAY_FEEDBACK);});}
function import_read(n){progress.setClass('progressBar');progress.setHeaderMsg('memoryCardContacts-importing');progress.setTotal(n);}
function imported_contact(){importedContacts++;progress.update();}
function import_error(e){UIManager.navBar.removeAttribute('aria-disabled');utils.overlay.hide();importButton.removeAttribute('disabled');var cancel={title:'cancel',callback:function(){ConfirmDialog.hide();}};var retry={title:'retry',isRecommend:true,callback:function(){ConfirmDialog.hide();importButton.click();}};ConfirmDialog.show(null,'memoryCardContacts-error',cancel,retry);}}};;'use strict';var WifiManager={init:function wn_init(){this.api=WifiHelper.getWifiManager();this.changeStatus();if(navigator.mozSettings){var lock=window.navigator.mozSettings.createLock();this.enable(lock);this.enableDebugging(lock);}
this.gCurrentNetwork=this.api?this.api.connection.network:null;if(this.gCurrentNetwork!==null){this.api.forget(this.gCurrentNetwork);this.gCurrentNetwork=null;}},getNetworks:function wn_getNetworks(callback){this.networks?callback(this.networks):this.scan(callback);},scan:function wn_scan(callback){if(this._scanning){return;}
this._scanning=true;utils.overlay.show('scanningNetworks','spinner');var SCAN_TIMEOUT=10000;var self=this;self.onScan=callback;var req=this.api?this.api.getNetworks():null;if(!req){setTimeout(function(){self._scanning=false;callback();});return;}
var handleRequest=function handleRequest(){self._scanning=false;clearTimeout(self.scanTimeout);self.scanTimeout=null;self.onScan(self.networks);self.onScan=null;};req.onsuccess=function onScanSuccess(){self.networks=req.result;handleRequest();};req.onerror=function onScanError(){console.error('Error reading networks: '+req.error.name);self.networks=[];handleRequest();};if(!self.scanTimeout){self.scanTimeout=setTimeout(function(){self._scanning=false;console.warn('Timeout while reading networks');self.onScan();},SCAN_TIMEOUT);}},enable:function wn_enable(lock){lock.set({'wifi.enabled':true});},enableDebugging:function wn_enableDebugging(lock){this._prevDebuggingValue=false;var req=lock.get('wifi.debugging.enabled');req.onsuccess=function wn_getDebuggingSuccess(){this._prevDebuggingValue=req.result['wifi.debugging.enabled'];};lock.set({'wifi.debugging.enabled':true});},finish:function wn_finish(){if(!this._prevDebuggingValue&&navigator.mozSettings){var resetLock=window.navigator.mozSettings.createLock();resetLock.set({'wifi.debugging.enabled':false});}},getNetwork:function wm_gn(ssid){var network;for(var i=0;i<this.networks.length;i++){if(this.networks[i].ssid==ssid){network=this.networks[i];break;}}
return network;},connect:function wn_connect(ssid,password,user){var network=this.getNetwork(ssid);this.ssid=ssid;WifiHelper.setPassword(network,password,user,'PEAP');this.gCurrentNetwork=network;this.api.associate(network);},changeStatus:function wn_cs(callback){var self=this;if(WifiManager.api){WifiManager.api.onstatuschange=function(event){if(event.status==='disconnected'&&self.onScan){self.scan(self.onScan);}else{WifiUI.updateNetworkStatus(event.network.ssid,event.status);}};}}};var WifiUI={joinNetwork:function wui_jn(){var password=document.getElementById('wifi_password').value;var user=document.getElementById('wifi_user').value;var ssid=document.getElementById('wifi_ssid').value;WifiUI.connect(ssid,password,user);window.history.back();},joinHiddenNetwork:function wui_jhn(){var password=UIManager.hiddenWifiPassword.value;var user=UIManager.hiddenWifiIdentity.value;var ssid=UIManager.hiddenWifiSsid.value;var security=UIManager.hiddenWifiSecurity.value;var network;if(ssid.length){if(!Array.isArray(WifiManager.networks)){WifiManager.networks=[];}
network=new window.MozWifiNetwork({ssid:ssid,capabilities:[],security:[security],relSignalStrength:0,hidden:true});WifiManager.networks.push(network);this.renderNetworks(WifiManager.networks);WifiUI.connect(ssid,password,user);}
window.history.back();},connect:function wui_connect(ssid,password,user){var networkSelected=document.querySelector('li[data-wifi-selected]');if(networkSelected){var icon=networkSelected.querySelector('aside');networkSelected.removeAttribute('data-wifi-selected');networkSelected.classList.remove('connected');icon.classList.remove('connecting');icon.classList.remove('connected');var security=networkSelected.dataset.security;var securityLevelDOM=networkSelected.querySelectorAll('p[data-security-level]')[0];if(!security||security===''){securityLevelDOM.setAttribute('data-l10n-id','securityOpen');}else{securityLevelDOM.setAttribute('data-l10n-id',security);}}
var newWifi=document.getElementById(ssid);newWifi.dataset.wifiSelected=true;newWifi.querySelector('p[data-security-level]').setAttribute('data-l10n-id','shortStatus-connecting');newWifi.querySelector('aside').classList.add('connecting');WifiManager.connect(ssid,password,user);},chooseNetwork:function wui_cn(event){var ssid=event.target.dataset.ssid;if(WifiHelper.isOpen(WifiManager.getNetwork(ssid))){WifiUI.connect(ssid);return;}
UIManager.activationScreen.classList.add('no-options');UIManager.mainTitle.textContent=ssid;var selectedNetwork=WifiManager.getNetwork(ssid);var ssidHeader=document.getElementById('wifi_ssid');var userLabel=document.getElementById('label_wifi_user');var userInput=document.getElementById('wifi_user');var passwordInput=document.getElementById('wifi_password');var showPassword=document.querySelector('input[name=show_password]');var joinButton=UIManager.wifiJoinButton;joinButton.disabled=true;passwordInput.addEventListener('keyup',function validatePassword(){joinButton.disabled=!WifiHelper.isValidInput(WifiHelper.getKeyManagement(selectedNetwork),passwordInput.value,userInput.value);});passwordInput.type='password';passwordInput.value='';showPassword.checked=false;showPassword.onchange=function togglePasswordVisibility(){passwordInput.type=this.checked?'text':'password';};passwordInput.value='';ssidHeader.value=ssid;UIManager.navBar.classList.add('secondary-menu');if(WifiHelper.isEap(WifiManager.getNetwork(ssid))){userInput.parentNode.classList.remove('hidden');}else{userInput.parentNode.classList.add('hidden');}
window.location.hash='#configure_network';},addHiddenNetwork:function wui_addHiddenNetwork(){UIManager.activationScreen.classList.add('no-options');UIManager.mainTitle.setAttribute('data-l10n-id','authentication');UIManager.navBar.classList.add('secondary-menu');UIManager.wifiJoinButton.disabled=true;window.location.hash='#hidden-wifi-authentication';},handleHiddenWifiSecurity:function wui_handleSecurity(securityType){if(securityType.indexOf('EAP')!==-1){UIManager.hiddenWifiIdentityBox.classList.remove('hidden');}else{UIManager.hiddenWifiIdentityBox.classList.add('hidden');}},renderNetworks:function wui_rn(networks){var networksDOM=document.getElementById('networks');networksDOM.innerHTML='';var networksList;if(!networks||networks.length===0){var noResult='<div id="no-result-container">'+'  <div id="no-result-message">'+'    <p data-l10n-id="noWifiFound3"></p>'+'  </div>'+'</div>';networksDOM.innerHTML=noResult;}else{networksList=document.createElement('ul');networksList.id='networks-list';networksList.setAttribute('role','listbox');networksList.setAttribute('data-l10n-id','networksList');var networksShown=[];networks.sort(function(a,b){return b.relSignalStrength-a.relSignalStrength;});for(var i=0,max=networks.length;i<max;i++){var network=networks[i];if(networksShown.indexOf(network.ssid)===-1){var li=document.createElement('li');var icon=document.createElement('aside');var ssidp=document.createElement('p');ssidp.setAttribute('dir','auto');var small=document.createElement('p');small.dataset.securityLevel=true;icon.classList.add('pack-end');icon.classList.add('wifi-icon');var level=Math.min(Math.floor(network.relSignalStrength/20),4);icon.classList.add('level-'+level);navigator.mozL10n.setAttributes(icon,'wifiLevel',{level:level});icon.setAttribute('role','presentation');ssidp.textContent=network.ssid;li.dataset.ssid=network.ssid;var keys=WifiHelper.getSecurity(network);li.dataset.security=keys;if(keys&&keys.length){small.textContent=keys.join(', ');icon.classList.add('secured');}else{small.setAttribute('data-l10n-id','securityOpen');}
icon.classList.add('wifi-signal');if(WifiHelper.isConnected(network)){small.setAttribute('data-l10n-id','shortStatus-connected');small.removeAttribute('aria-label');icon.classList.add('connected');li.classList.add('connected');li.dataset.wifiSelected=true;}
networksShown.push(network.ssid);li.setAttribute('id',network.ssid);li.setAttribute('role','option');li.setAttribute('aria-live',true);li.setAttribute('aria-relevant','text');li.appendChild(ssidp);li.appendChild(small);li.appendChild(icon);if(WifiHelper.isConnected(network)){networksList.insertBefore(li,networksList.firstChild);}else{networksList.appendChild(li);}}}
networksList.dataset.type='list';networksDOM.appendChild(networksList);}
utils.overlay.hide();},updateNetworkStatus:function wui_uns(ssid,status){var element=document.getElementById(ssid);if(!element){return;}
if(status!=='disconnected'){element.querySelector('p[data-security-level]').setAttribute('data-l10n-id','shortStatus-'+status);}else{var security=element.dataset.security;if(security===''){security='Open';}
element.querySelector('p[data-security-level]').setAttribute('data-l10n-id','security'+security);element.classList.remove('connected');}
var icon=element.querySelector('aside');if(status==='connecting'||status==='associated'){icon.classList.add('connecting');}else{icon.classList.remove('connecting');if(status==='connected'){var networksList=document.getElementById('networks-list');icon.classList.add('connected');element.classList.add('connected');networksList.removeChild(element);networksList.insertBefore(element,networksList.firstChild);}}}};;'use strict';var _=navigator.mozL10n.get;var ImportIntegration={get fbExtensions(){delete this.fbExtensions;return(this.fbExtensions=document.getElementById('fb-extensions'));},get fbImport(){delete this.fbImport;return(this.fbImport=document.getElementById('fb_import'));},get fbImportButton(){delete this.fbImportButton;return(this.fbImportButton=document.getElementById('fb-import-button'));},get liveImportButton(){delete this.liveImportButton;return(this.liveImportButton=document.getElementById('live-import-button'));},get gmailImportButton(){delete this.gmailImportButton;return(this.gmailImportButton=document.getElementById('gmail-import-button'));},get noNetworkMsg(){delete this.noNetworkMsg;return(this.noNetworkMsg=document.getElementById('no-network'));},get fbImportFeedback(){delete this.fbImportFeedback;return(this.fbImportFeedback=document.getElementById('fb_import_feedback'));},get fbAfterImport1(){delete this.fbAfterImport1;return(this.fbAfterImport1=document.getElementById('fb_after_import1'));},get fbAfterImport2(){delete this.fbAfterImport2;return(this.fbAfterImport2=document.getElementById('fb_after_import2'));},init:function fb_init(){this.fbImportButton.addEventListener('click',this);this.liveImportButton.addEventListener('click',this);this.gmailImportButton.addEventListener('click',this);document.addEventListener('fb_imported',this);},handleEvent:function fb_he(event){switch(event.type){case'click':if(event.target===this.fbImportButton){ServicesLauncher.start('facebook');}
else if(event.target===this.liveImportButton){ServicesLauncher.start('live');}
else if(event.target===this.gmailImportButton){ServicesLauncher.start('gmail');}
break;case'fb_imported':this.toggleToImportedState();this.updateContactsNumber();ImportStatusData.put(fb.utils.SCHEDULE_SYNC_KEY,Date.now());break;}},checkImport:function fb_check(nextState){var fbOption=this.fbImportButton;var noNetMsg=this.noNetworkMsg;if(nextState==='disabled'){fbOption.setAttribute('disabled','disabled');this.gmailImportButton.setAttribute('disabled','disabled');this.liveImportButton.setAttribute('disabled','disabled');noNetMsg.classList.remove('hidden');}
else if(nextState==='enabled'){fbOption.removeAttribute('disabled');this.gmailImportButton.removeAttribute('disabled');this.liveImportButton.removeAttribute('disabled');noNetMsg.classList.add('hidden');}},toggleToImportedState:function fb_tg_imported(){this.fbImport.classList.add('hidden');this.fbAfterImport1.classList.remove('hidden');this.fbAfterImport2.classList.remove('hidden');this.fbImport.parentNode.classList.remove('importOption');},updateContactsNumber:function fb_ucn(cb){this.fbImportFeedback.setAttribute('data-l10n-id','fb-checking');var self=this;var fbUpdateTotals=function fbUpdateTotals(imported,total){if(total==null){self.fbImportFeedback.setAttribute('data-l10n-id','notImportedYet');}else{self.fbImportFeedback.textContent=_('facebook-import-msg',{'imported':imported,'total':total});}};var req=fb.utils.getNumFbContacts();req.onsuccess=function(){var friendsOnDevice=req.result;var callbackListener={'local':function localContacts(number){fbUpdateTotals(friendsOnDevice,number);window.setTimeout(cb,0,friendsOnDevice,number);},'remote':function remoteContacts(number){fbUpdateTotals(friendsOnDevice,number);window.setTimeout(cb,0,friendsOnDevice,number);}};fb.utils.numFbFriendsData(callbackListener);};req.onerror=function(){console.error('Could not get number of local contacts');};}};var FacebookConfiguration=function FacebookConfiguration(){var disableFacebook=function disableFacebook(){ImportIntegration.fbImport.classList.add('hidden');};var enableFacebook=function enableFacebook(){ImportIntegration.fbImport.classList.remove('hidden');};window.config={};utils.config.load('/config.json').then(function cReady(configData){if(configData.facebookEnabled===true){enableFacebook();}else{disableFacebook();}
window.config.operationsTimeout=configData.operationsTimeout;},function configError(code){disableFacebook();});}();;(function(exports){'use strict';var rdashes=/-(.)/g;var Utils={camelCase:function ut_camelCase(str){return str.replace(rdashes,function(str,p1){return p1.toUpperCase();});}};exports.Utils=Utils;}(this));;(function(exports){'use strict';var currentLayout='tiny';var elementIDs=['tutorialFinished','enjoyYourPhone','enjoyYourPhoneUpdated'];var dom={};var initialized=false;var FinishScreen={init:function(isUpgrade){if(initialized){return;}
if(ScreenLayout.getCurrentLayout()!=='tiny'){currentLayout='large';}
var panelSelector='tutorial-finish-'+currentLayout;var finishPanel=document.getElementById(panelSelector);finishPanel.classList.add('show');elementIDs.forEach(function(name){dom[Utils.camelCase(name)]=document.getElementById(name);},this);if(isUpgrade){dom.enjoyYourPhone.hidden=true;dom.enjoyYourPhoneUpdated.hidden=false;}
if(currentLayout==='tiny'){dom.tutorialFinished.addEventListener('click',function ftuEnd(){window.close();});}else{navigator.mozApps.getSelf().onsuccess=function(evt){var app=evt.target.result;app.connect('ftucomms').then(function onConnAccepted(ports){ports.forEach(function(port){port.postMessage('done');});},function onConnRejected(reason){console.warn('FTU is rejected due to '+reason);});};}
initialized=true;}};exports.FinishScreen=FinishScreen;}(this));;(function(exports){'use strict';var currentLayout='tiny';var dom={};function _loadMedia(mediaElement,src){var isVideo=(mediaElement.nodeName==='VIDEO');return new Promise(function(resolve,reject){function onMediaLoadOrError(evt){evt.target.removeEventListener('error',onMediaLoadOrError);if(isVideo){evt.target.removeEventListener('canplay',onMediaLoadOrError);}else{evt.target.removeEventListener('load',onMediaLoadOrError);}
if(evt.type==='error'){console.error('Failed to load tutorial media: '+src);}
resolve(evt);}
function onVideoUnloaded(evt){mediaElement.removeEventListener('emptied',onVideoUnloaded);mediaElement.removeEventListener('abort',onVideoUnloaded);mediaElement.addEventListener('canplay',onMediaLoadOrError);mediaElement.src=src;mediaElement.load();}
if(isVideo){mediaElement.addEventListener('error',onMediaLoadOrError);if(mediaElement.src){mediaElement.addEventListener('emptied',onVideoUnloaded,false);mediaElement.addEventListener('abort',onVideoUnloaded,false);mediaElement.removeAttribute('src');mediaElement.load();}else{onVideoUnloaded();}}else{mediaElement.addEventListener('load',onMediaLoadOrError,false);mediaElement.addEventListener('error',onMediaLoadOrError,false);mediaElement.src=src;}});}
var elementIDs=['tutorial','tutorial-step-title','tutorial-step-media','tutorial-step-image','tutorial-step-video','forward-tutorial','back-tutorial'];var Tutorial={config:null,_stepsConfig:{},_stepsKey:'',_currentStep:1,_initialized:false,init:function(stepsKey,onLoaded){if(this._initialized||this._initialization){return;}
var initTasks=this._initialization=new Sequence(this.loadConfig.bind(this),this._initWithConfig.bind(this,stepsKey));initTasks.onabort=this._onAbortInitialization.bind(this);initTasks.oncomplete=this._onCompleteInitialization.bind(this,onLoaded);elementIDs.forEach(function(name){dom[Utils.camelCase(name)]=document.getElementById(name);if(!dom[Utils.camelCase(name)]){console.error('Cache DOM elements: couldnt cache: '+name);}},this);initTasks.next();},start:function(onReady){var sequence;var initInProgress=false;if(this._initialization){sequence=this._initialization;initInProgress=true;}else{this._initialization=sequence=new Sequence();sequence.onabort=this._onAbortInitialization.bind(this);sequence.oncomplete=this._onCompleteInitialization.bind(this);}
sequence.push(function setInitialStep(){return this._setStep();}.bind(this));sequence.push(function showTutorialAndFinishInit(){dom.tutorial.classList.add('show');window.dispatchEvent(new CustomEvent('tutorialinitialized'));});if(typeof onReady==='function'){sequence.push(onReady);}
if(!initInProgress){sequence.next();}},_initWithConfig:function(stepsKey){stepsKey=stepsKey||'default';this._stepsKey=stepsKey;this._stepsConfig=this.config[stepsKey]||this.config['default'];dom.forwardTutorial.addEventListener('click',this);dom.backTutorial.addEventListener('click',this);this._currentStep=1;},_onAbortInitialization:function(){this._initialization=null;},_onCompleteInitialization:function(onReady){this._initialization=null;this._initialized=true;if(typeof onReady==='function'){onReady();}},_setStep:function(value){value=(typeof value==='number')?value:this._currentStep;var stepIndex=value-1;if(stepIndex>=this._stepsConfig.steps.length){return Promise.resolve().then(function(){Tutorial.done();});}
var stepData=this._stepsConfig.steps[stepIndex];if(!stepData){return Promise.reject('No data for step: '+value);}
dom.tutorial.dataset.step=this._currentStep;navigator.mozL10n.setAttributes(dom.tutorialStepTitle,stepData.l10nKey);var imgElement=dom.tutorialStepImage,videoElement=dom.tutorialStepVideo;var stepPromise;if(stepData.video){stepPromise=_loadMedia(videoElement,stepData.video).then(function(){videoElement.play();});videoElement.hidden=false;imgElement.hidden=true;}else{imgElement.hidden=false;stepPromise=_loadMedia(imgElement,stepData.image);imgElement.hidden=false;videoElement.hidden=true;}
return stepPromise;},handleEvent:function(evt){if(evt.type==='click'){switch(evt.target){case dom.forwardTutorial:this.next(evt);break;case dom.backTutorial:this.back(evt);break;}}},next:function(){return this._setStep(++this._currentStep);},back:function(){return this._setStep(--this._currentStep);},done:function(){var isUpgrade=this._stepsKey&&this._stepsKey!=='default';FinishScreen.init(isUpgrade);dom.tutorial.classList.remove('show');dom.tutorialStepVideo.removeAttribute('src');dom.tutorialStepImage.removeAttribute('src');},loadConfig:function(){if(!this._configPromise){currentLayout=ScreenLayout.getCurrentLayout()==='tiny'?'tiny':'large';var configUrl='/config/'+currentLayout+'.json';this._configPromise=LazyLoader.getJSON(configUrl).then(function(json){Tutorial.config=json;return Tutorial.config;},function(){return new Error('Tutorial config failed to load from: '+configUrl);});}
return this._configPromise;},reset:function(){if(this._initialization){this._initialization.abort();this._initialization=null;}
this._configPromise=null;this._currentStep=1;this._stepsConfig=this.config=null;if(this._initialized){dom.tutorial.classList.remove('show');this._initialized=false;}}};function Sequence(){var sequence=Array.slice(arguments);var aborted=false;sequence.abort=function(){aborted=true;this.length=0;if(typeof this.onabort==='function'){this.onabort();}};sequence.complete=function(result){if(!aborted&&typeof this.oncomplete==='function'){this.oncomplete(result);}};sequence.fail=function(reason){this.complete(reason);};sequence.next=function(previousTaskResult){var result,exception;if(aborted){return;}
var task=this.shift();if(task){try{result=task.apply(null,arguments);}catch(e){exception=e;}
if(exception){this.fail(exception);}else if(result&&typeof result.then==='function'){result.then(this.next.bind(this),this.fail.bind(this));}else{this.next(result);}}else{this.complete(previousTaskResult);}};return sequence;}
exports.Tutorial=Tutorial;})(this);;'use strict';function getLocalizedLink(key){var refs={'learn-more-telemetry':{href:'https://www.mozilla.org/telemetry',textContent:'www.mozilla.org/telemetry',className:'external'},'learn-more-information':{href:'https://www.mozilla.org/privacy',textContent:'www.mozilla.org/privacy',className:'external'},'learn-more-privacy':{href:'https://www.mozilla.org/privacy/firefox-os',l10nId:'learn-more-privacy-link',className:'external'},'htmlWelcome':{href:'#about-your-rights',l10nId:'htmlWelcome-link'},'helpImprove':{href:'https://www.mozilla.org/privacy/firefox-os',l10nId:'helpImprove-link',className:'external'}};var linkRef=refs[key];var dataL10nAttrs={};var _=navigator.mozL10n.get;for(var prop in linkRef){if(prop=='l10nId'){dataL10nAttrs.textContent=_(linkRef.l10nId);}else{dataL10nAttrs[prop]=linkRef[prop];}}
if(!dataL10nAttrs.hasOwnProperty('className')){dataL10nAttrs.className='';}
return dataL10nAttrs;};'use strict';var steps={1:{onlyForward:true,hash:'#languages',requireSIM:false},2:{onlyForward:false,hash:'#data_3g',requireSIM:true},3:{onlyForward:false,hash:'#wifi',requireSIM:false},4:{onlyForward:false,hash:'#date_and_time',requireSIM:false},5:{onlyForward:false,hash:'#geolocation',requireSIM:false},6:{onlyForward:false,hash:'#import_contacts',requireSIM:false},7:{onlyForward:false,hash:'#firefox_accounts',requireSIM:false},8:{onlyForward:false,hash:'#welcome_browser',requireSIM:false},9:{onlyForward:false,hash:'#browser_privacy',requireSIM:false}};var numSteps=Object.keys(steps).length;var Navigation={currentStep:1,previousStep:1,totalSteps:numSteps,simMandatory:false,skipMobileDataScreen:false,skipDateTimeScreen:false,tzInitialized:false,init:function n_init(){var settings=navigator.mozSettings;var forward=document.getElementById('forward');var back=document.getElementById('back');forward.addEventListener('click',this.forward.bind(this));back.addEventListener('click',this.back.bind(this));window.addEventListener('hashchange',this);UIManager.activationScreen.addEventListener('click',this.handleExternalLinksClick.bind(this));var self=this;var reqSIM=settings&&settings.createLock().get('ftu.sim.mandatory')||{};reqSIM.onsuccess=function onSuccess(){self.simMandatory=reqSIM.result['ftu.sim.mandatory']||false;};navigator.mozApps.getSelf().onsuccess=function(evt){var app=evt.target.result;app.connect('ftucomms').then(function onConnAccepted(ports){self.ports=ports;},function onConnRejected(reason){console.warn('FTU navigation cannot use IAC: '+reason);});};},back:function n_back(event){var currentStep=steps[this.currentStep];var actualHash=window.location.hash;if(actualHash!=currentStep.hash){window.history.back();}else{var self=this;var goToStep=function(){self.previousStep=self.currentStep;self.currentStep--;if(self.currentStep>0){self.manageStep();}};goToStep();}},forward:function n_forward(event){var self=this;var goToStepForward=function(){self.previousStep=self.currentStep;self.currentStep++;if(self.currentStep>numSteps){UIManager.sendNewsletter(function newsletterSent(result){if(result){UIManager.activationScreen.classList.remove('show');UIManager.changeStatusBarColor(UIManager.DARK_THEME);UIManager.finishScreen.classList.add('show');UIManager.hideActivationScreenFromScreenReader();}else{self.currentStep--;}});return;}
self.manageStep();};goToStepForward();},handleExternalLinksClick:function n_handleExternalLinksClick(e){var link=e.target;if(!link.mozMatchesSelector('a.external')){return;}
e.preventDefault();var href=link.href,title=link.getAttribute('title')||link.textContent;if(navigator.onLine){this.displayExternalLink(href,title);}else{UIManager.displayOfflineDialog(href,title);}},displayExternalLink:function n_displayExternalLink(href,title){window.open(href,'','dialog');},ensureTZInitialized:function(){if(!this.tzInitialized){return UIManager.initTZ().then(()=>{this.skipDateTimeScreen=!UIManager.timeZoneNeedsConfirmation;this.tzInitialized=true;});}else{return Promise.resolve();}},handleEvent:function n_handleEvent(event){var actualHash=window.location.hash;switch(actualHash){case'#languages':UIManager.mainTitle.setAttribute('data-l10n-id','language');break;case'#data_3g':UIManager.mainTitle.setAttribute('data-l10n-id','3g');DataMobile.getStatus(UIManager.updateDataConnectionStatus.bind(UIManager));break;case'#wifi':DataMobile.removeSVStatusObserver();UIManager.mainTitle.setAttribute('data-l10n-id','selectNetwork');UIManager.activationScreen.classList.remove('no-options');if(UIManager.navBar.classList.contains('secondary-menu')){UIManager.navBar.classList.remove('secondary-menu');return;}
WifiManager.getNetworks(networks=>{this.ensureTZInitialized().then(()=>{WifiUI.renderNetworks(networks);});});break;case'#date_and_time':UIManager.mainTitle.setAttribute('data-l10n-id','dateAndTime');break;case'#geolocation':UIManager.mainTitle.setAttribute('data-l10n-id','geolocation');break;case'#import_contacts':UIManager.mainTitle.setAttribute('data-l10n-id','importContacts3');SimManager.checkSIMButton();SdManager.checkSDButton();var fbState;if(!WifiManager.api){ImportIntegration.checkImport('enabled');break;}
fbState=window.navigator.onLine?'enabled':'disabled';ImportIntegration.checkImport(fbState);break;case'#firefox_accounts':UIManager.mainTitle.setAttribute('data-l10n-id','firefox-accounts');break;case'#welcome_browser':UIManager.mainTitle.setAttribute('data-l10n-id','aboutBrowser');var welcome=document.getElementById('browser_os_welcome');navigator.mozL10n.setAttributes(welcome,'htmlWelcome2',getLocalizedLink('htmlWelcome'));var improve=document.getElementById('browser_os_improve');navigator.mozL10n.setAttributes(improve,'helpImprove2',getLocalizedLink('helpImprove'));var sharePerformance=document.getElementById('share-performance');var settingName=sharePerformance.name;var settings=navigator.mozSettings;var req=settings&&settings.createLock().get(settingName);if(req){req.onsuccess=function(){sharePerformance.checked=req.result[settingName]||false;};}
break;case'#browser_privacy':UIManager.mainTitle.setAttribute('data-l10n-id','aboutBrowser');var linkPrivacy=document.getElementById('external-link-privacy');navigator.mozL10n.setAttributes(linkPrivacy,'learn-more-privacy2',getLocalizedLink('learn-more-privacy'));break;case'#SIM_mandatory':UIManager.mainTitle.setAttribute('data-l10n-id','SIM_mandatory');break;case'#about-your-rights':case'#about-your-privacy':UIManager.mainTitle.setAttribute('data-l10n-id','aboutBrowser');UIManager.navBar.classList.add('back-only');break;case'#sharing-performance-data':UIManager.mainTitle.setAttribute('data-l10n-id','aboutBrowser');UIManager.navBar.classList.add('back-only');var linkTelemetry=document.getElementById('external-link-telemetry');navigator.mozL10n.setAttributes(linkTelemetry,'learn-more-telemetry2',getLocalizedLink('learn-more-telemetry'));var linkInfo=document.getElementById('external-link-information');navigator.mozL10n.setAttributes(linkInfo,'learn-more-information2',getLocalizedLink('learn-more-information'));break;}
if(this.simMandatory){UIManager.skipPinButton.classList.add('hidden');UIManager.backSimButton.classList.remove('hidden');}else{UIManager.skipPinButton.classList.remove('hidden');UIManager.backSimButton.classList.add('hidden');}
if(this.currentStep<=numSteps&&(steps[this.currentStep].hash!=='#wifi')){UIManager.activationScreen.classList.add('no-options');}
if(this.currentStep<=numSteps&&steps[this.currentStep].hash===actualHash){UIManager.navBar.classList.remove('back-only');}},postStepMessage:function n_postStepMessage(stepNumber){if(!this.ports){return;}
this.ports.forEach(function(port){port.postMessage({type:'step',hash:steps[stepNumber].hash});});},skipStep:function n_skipStep(){this.currentStep=this.currentStep+
(this.currentStep-this.previousStep);if(this.currentStep<1){this.previousStep=this.currentStep=1;}
if(this.currentStep>numSteps){this.previousStep=this.currentStep=numSteps;}
this.manageStep();},manageStep:function n_manageStep(){var self=this;if(self.currentStep>self.previousStep){self.postStepMessage(self.previousStep);}
if(self.currentStep>=numSteps){OperatorVariant.setSIMOnFirstBootState();}
if(self.currentStep==1){self.totalSteps=numSteps;self.skipMobileDataScreen=false;}
var futureLocation=steps[self.currentStep];if(this.simMandatory&&!IccHelper.cardState&&futureLocation.requireSIM){futureLocation.hash='#SIM_mandatory';futureLocation.requireSIM=false;futureLocation.onlyBackward=true;}
if(steps[this.currentStep].onlyForward){UIManager.navBar.classList.add('forward-only');}else{UIManager.navBar.classList.remove('forward-only');}
var nextButton=document.getElementById('forward');if(steps[this.currentStep].onlyBackward){nextButton.setAttribute('disabled','disabled');}else{nextButton.removeAttribute('disabled');}
if(this.currentStep===numSteps){nextButton.setAttribute('data-l10n-id','done');}else{nextButton.setAttribute('data-l10n-id','navbar-next');}
if(futureLocation.hash==='#firefox_accounts'){nextButton.setAttribute('data-l10n-id','skip');}
window.location.hash=futureLocation.hash;if(futureLocation.requireSIM){var check_cardState=function(response){if(!response||(!SimManager.available()&&futureLocation.hash!=='#data_3g')){self.skipStep();if(self.currentStep>self.previousStep){self.skipMobileDataScreen=true;self.totalSteps--;}}};var skipUnlockScreens=this.currentStep<this.previousStep;SimManager.handleCardState(check_cardState,skipUnlockScreens);}
if(steps[self.currentStep].hash==='#date_and_time'){if(!self.tzInitialized){self.skipDateTimeScreen=!UIManager.timeZoneNeedsConfirmation;}
if(self.skipDateTimeScreen){self.postStepMessage(self.currentStep);if(navigator.onLine){UIManager.updateSetting('time.timezone.automatic-update.enabled',true);UIManager.updateSetting('time.clock.automatic-update.enabled',true);}
self.skipStep();}}
if((futureLocation.hash==='#firefox_accounts'&&!navigator.onLine)||(futureLocation.hash==='#firefox_accounts'&&UIManager.skipFxA)){self.postStepMessage(self.currentStep);self.skipStep();}}};;'use strict';var DataMobile={key:'ril.data.enabled',keySV:'ftu.ril.data.enabled',STEP_DATA_3G:2,apnRetrieved:false,init:function dm_init(){var settings=navigator.mozSettings;if(!settings){console.log('Settings is not available');return;}
this.settings=settings;},removeSVStatusObserver:function dm_removeSVStatusObserver(){this.settings.removeObserver(this.keySV,this.getStatus);},getStatus:function dm_getStatus(aCallback){var self=this;var reqSV=this.settings.createLock().get(this.keySV);reqSV.onsuccess=function gst_svsuccess(){var svStatus=reqSV.result[self.keySV];if(svStatus!==undefined&&!UIManager.dataConnectionChangedByUsr){self.settings.removeObserver(self.keySV,self.getStatus);if(Navigation.currentStep===self.STEP_DATA_3G){self.toggle(svStatus);if(typeof aCallback==='function'){aCallback(svStatus);}}else{self.getRealStatus(aCallback);}}else{self.getRealStatus(aCallback);}};reqSV.onerror=function gst_error(){console.log('Error retrieving '+self.keySV);};this.settings.addObserver(this.keySV,this.getStatus.bind(this,aCallback));},getRealStatus:function dm_getRealStatus(callback){var request=this.settings.createLock().get(this.key);var self=this;request.onsuccess=function gst_success(){var currentStatus=request.result[self.key];self.isDataAvailable=currentStatus;callback(currentStatus);};request.onerror=function gst_error(){console.log('Error retrieving '+self.key);};},toggle:function dm_toggle(status,callback){var options={};options[this.key]=status;if(!this.apnRetrieved){var self=this;this.getAPN(function apn_recovered(){self.settings.createLock().set(options);self.apnRetrieved=true;self.isDataAvailable=status;if(callback){callback();}});return;}
this.settings.createLock().set(options);this.apnRetrieved=true;this.isDataAvailable=status;if(callback){callback();}},getAPN:function dm_getapn(callback){var _self=this;function ensureApnSettings(){var req=_self.settings.createLock().get('ril.data.apnSettings');req.onsuccess=function loadApn(){var apnSettings=req.result['ril.data.apnSettings'];if(apnSettings){if(callback){callback(req.result);}
_self.settings.removeObserver('ril.data.apnSettings',ensureApnSettings);}};}
ensureApnSettings();this.settings.addObserver('ril.data.apnSettings',ensureApnSettings);}};;'use strict';var TimeManager={elementIDs:['tz-region','tz-city','date-configuration','time-configuration'],init:function tm_init(){if(window.navigator.mozTime){this.time=window.navigator.mozTime;}else{console.log('There is no mozTime available in window');}
this.elementIDs.forEach(function(elementID){document.getElementById(elementID+'-button').addEventListener('click',function(evt){evt.preventDefault();var input=document.getElementById(elementID);setTimeout(input.focus.bind(input),10);});});},set:function tm_set(date){this.time.set(date);}};;'use strict';var _;var UIManager={domSelectors:['container','splash-screen','activation-screen','finish-screen','update-screen','nav-bar','main-title','unlock-sim-screen','unlock-sim-header','unlock-sim-action','pincode-screen','pin-label','pin-retries-left','pin-input','back-sim-button','pin-error','skip-pin-button','unlock-sim-button','pukcode-screen','puk-label','puk-retries-left','puk-input','puk-info','puk-error','newpin-input','newpin-error','confirm-newpin-input','confirm-newpin-error','xckcode-screen','xck-label','xck-retries-left','xck-input','xck-error','sim-info-screen','sim-info-back','sim-info-forward','sim-info-1','sim-info-2','sim-number-1','sim-number-2','sim-carrier-1','sim-carrier-2','sim-import','sim-import-button','no-sim','sd-import-button','no-memorycard','fxa-create-account','fxa-intro','networks','wifi-refresh-button','wifi-join-button','join-hidden-button','hidden-wifi-authentication','hidden-wifi-ssid','hidden-wifi-security','hidden-wifi-password','hidden-wifi-identity','hidden-wifi-identity-box','hidden-wifi-show-password','date-configuration','time-configuration','date-configuration-label','time-configuration-label','time-form','data-connection-checkbox','geolocation-checkbox','lets-go-button','update-lets-go-button','skip-tutorial-button','update-skip-tutorial-button','share-performance','offline-error-dialog','newsletter-form','newsletter-input','newsletter-success-screen','offline-newsletter-error-dialog','invalid-email-error-dialog'],dataConnectionChangedByUsr:false,timeZoneNeedsConfirmation:true,DARK_THEME:'#242d33',LIGHT_THEME:'#eeeeee',init:function ui_init(){_=navigator.mozL10n.get;this.domSelectors.forEach(function createElementRef(name){this[toCamelCase(name)]=document.getElementById(name);}.bind(this));var currentDate=new Date();var f=new navigator.mozL10n.DateTimeFormat();var format=_('shortTimeFormat');this.timeConfigurationLabel.innerHTML=f.localeFormat(currentDate,format);this.dateConfigurationLabel.innerHTML=currentDate.toLocaleFormat('%Y-%m-%d');this.simImportButton.addEventListener('click',this);this.sdImportButton.addEventListener('click',this);this.skipPinButton.addEventListener('click',this);this.backSimButton.addEventListener('click',this);this.unlockSimButton.addEventListener('click',this);this.unlockSimAction.addEventListener('action',this);this.simInfoBack.addEventListener('click',this);this.simInfoForward.addEventListener('click',this);this.dataConnectionCheckbox.addEventListener('change',this);this.wifiRefreshButton.addEventListener('click',this);this.wifiJoinButton.addEventListener('click',this);this.networks.addEventListener('click',this);this.joinHiddenButton.addEventListener('click',this);this.hiddenWifiSecurity.addEventListener('change',this);this.wifiJoinButton.disabled=true;this.hiddenWifiPassword.addEventListener('keyup',function(){this.wifiJoinButton.disabled=!WifiHelper.isValidInput(this.hiddenWifiSecurity.value,this.hiddenWifiPassword.value,this.hiddenWifiIdentity.value);}.bind(this));this.hiddenWifiShowPassword.onchange=function togglePasswordVisibility(){UIManager.hiddenWifiPassword.type=this.checked?'text':'password';};this.timeConfiguration.addEventListener('input',this);this.dateConfiguration.addEventListener('input',this);this.geolocationCheckbox.addEventListener('change',this);this.fxaCreateAccount.addEventListener('click',this);this.timeForm.addEventListener('submit',function(event){event.preventDefault();});this.newsletterInput.addEventListener('focus',function(){window.addEventListener('resize',function resize(){window.removeEventListener('resize',resize);setTimeout(function(){var page=document.getElementById('browser_privacy');UIManager.scrollToElement(page,UIManager.newsletterInput);},30);});});this.offlineNewsletterErrorDialog.querySelector('button').addEventListener('click',function offlineDialogClick(){this.offlineNewsletterErrorDialog.classList.remove('visible');}.bind(this));this.invalidEmailErrorDialog.querySelector('button').addEventListener('click',function invalidEmailDialogClick(){this.invalidEmailErrorDialog.classList.remove('visible');}.bind(this));var skipTutorialAction=function(){WifiManager.finish();if(ScreenLayout.getCurrentLayout()==='tiny'){window.close();}else{FinishScreen.init();}};var startTutorialAction=function(evt){WifiManager.finish();Tutorial.start(function onTutorialLoaded(){UIManager.activationScreen.classList.remove('show');UIManager.updateScreen.classList.remove('show');UIManager.finishScreen.classList.remove('show');});};this.skipTutorialButton.addEventListener('click',skipTutorialAction);this.updateSkipTutorialButton.addEventListener('click',skipTutorialAction);this.letsGoButton.addEventListener('click',startTutorialAction);this.updateLetsGoButton.addEventListener('click',startTutorialAction);this.sharePerformance.addEventListener('click',this);var button=this.offlineErrorDialog.querySelector('button');button.addEventListener('click',this.onOfflineDialogButtonClick.bind(this));['confirmdialogshowing','loadingoverlayshowing','tutorialinitialized'].forEach(function(event){window.addEventListener(event,this.hideActivationScreenFromScreenReader.bind(this));},this);['confirmdialoghiding','loadingoverlayhiding'].forEach(function(event){window.addEventListener(event,this.showActivationScreenToScreenReader.bind(this));},this);this.checkInitialFxAStatus();},scrollToElement:function ui_scrollToElement(container,element){container.scrollTop=element.offsetTop;},sendNewsletter:function ui_sendNewsletter(callback){var self=this;var emailValue=self.newsletterInput.value;if(emailValue===''){return callback(true);}else{utils.overlay.show('email-loading','spinner');if(self.newsletterInput.checkValidity()){if(window.navigator.onLine){Basket.send(emailValue,function emailSent(err,data){if(err){if(err.code&&err.code===Basket.errors.INVALID_EMAIL){ConfirmDialog.show('invalid-email-dialog-title','invalid-email-dialog-text',{title:'cancel',callback:function ok(){ConfirmDialog.hide();}});utils.overlay.hide();return callback(false);}else{Basket.store(emailValue);}}
utils.overlay.hide();return callback(true);});}else{Basket.store(emailValue,function stored(errorStoring){utils.overlay.hide();return callback(!errorStoring);});}}else{utils.overlay.hide();ConfirmDialog.show('invalid-email-dialog-title','invalid-email-dialog-text',{title:'cancel',callback:function ok(){ConfirmDialog.hide();}});return callback(false);}}},initTZ:function ui_initTZ(){var self=this;var tzRegion=document.getElementById('tz-region');var tzCity=document.getElementById('tz-city');return new Promise(function(resolve){var onchange=self.setTimeZone.bind(self);var onload=function(){self.setTimeZone.apply(self,arguments);resolve();};tzSelect(tzRegion,tzCity,onchange,onload);});},handleEvent:function ui_handleEvent(event){switch(event.target.id){case'skip-pin-button':SimManager.skip();break;case'back-sim-button':case'sim-info-back':SimManager.back();break;case'unlock-sim-button':SimManager.unlock();break;case'unlock-sim-action':SimManager.simUnlockBack();break;case'sim-info-forward':SimManager.finish();break;case'sim-import-button':window.setTimeout(SimManager.importContacts,0);break;case'sd-import-button':window.setTimeout(SdManager.importContacts,0);break;case'data-connection-checkbox':this.dataConnectionChangedByUsr=true;DataMobile.toggle(event.target.checked);break;case'wifi-refresh-button':WifiManager.scan(WifiUI.renderNetworks);break;case'wifi-join-button':if(window.location.hash==='#hidden-wifi-authentication'){WifiUI.joinHiddenNetwork();}else{WifiUI.joinNetwork();}
break;case'join-hidden-button':WifiUI.addHiddenNetwork();break;case'hidden-wifi-security':var securityType=event.target.value;WifiUI.handleHiddenWifiSecurity(securityType);break;case'time-configuration':this.setTime();break;case'date-configuration':this.setDate();break;case'geolocation-checkbox':this.updateSetting(event.target.name,event.target.checked);break;case'share-performance':this.updateSetting(event.target.name,event.target.checked);break;case'fxa-create-account':this.createFirefoxAccount();break;default:if(event.target.parentNode.id==='networks-list'){WifiUI.chooseNetwork(event);}
break;}},updateSetting:function ui_updateSetting(name,value){var settings=window.navigator.mozSettings;if(!name||!settings){return;}
var cset={};cset[name]=value;settings.createLock().set(cset);},setForwardButtonLabel:function ui_setForwardButtonLabel(label){var nextButton=document.getElementById('forward');nextButton.setAttribute('data-l10n-id',label);},checkInitialFxAStatus:function ui_checkInitialFxAStatus(){this.skipFxA=true;FxAccountsIACHelper.getAccounts((account)=>{this.skipFxA=false;this.onFxALogin(account);},()=>{FxAccountsIACHelper.logout(()=>{this.skipFxA=false;});});},createFirefoxAccount:function ui_createFirefoxAccount(){FxAccountsIACHelper.openFlow(UIManager.onFxAFlowDone,UIManager.onFxAError);},onFxAFlowDone:function ui_onFxAFlowDone(){FxAccountsIACHelper.getAccounts((account)=>{if(!account){return;}
UIManager.onFxALogin(account);UIManager.setForwardButtonLabel('navbar-next');},UIManager.onFxAError);},onFxALogin:function ui_onFxALogin(account){if(!account){return;}
UIManager.newsletterInput.value=account.email;UIManager.fxaIntro.innerHTML='';navigator.mozL10n.setAttributes(UIManager.fxaIntro,account.verified?'fxa-signed-in':'fxa-email-sent',{email:account.email});UIManager.fxaCreateAccount.disabled=true;},onFxAError:function ui_onFxAError(response){console.error('Create FxA Error: '+JSON.stringify(response));UIManager.newsletterInput.value='';navigator.mozL10n.setAttributes(UIManager.fxaIntro,'fxa-upsell');UIManager.fxaCreateAccount.disabled=false;UIManager.setForwardButtonLabel('skip');},displayOfflineDialog:function ui_displayOfflineDialog(href,title){var dialog=this.offlineErrorDialog;navigator.mozL10n.setAttributes(dialog.querySelector('small'),'offline-dialog-text',{url:href});dialog.classList.add('visible');this.hideActivationScreenFromScreenReader();},onOfflineDialogButtonClick:function ui_onOfflineDialogButtonClick(e){this.offlineErrorDialog.classList.remove('visible');this.showActivationScreenToScreenReader();},hideActivationScreenFromScreenReader:function ui_hideActivationScreenFromScreenReader(){this.activationScreen.setAttribute('aria-hidden',true);},showActivationScreenToScreenReader:function ui_showActivationScreenToScreenReader(){this.activationScreen.setAttribute('aria-hidden',false);},setDate:function ui_sd(){if(!!this.lock){return;}
var now=new Date();var currentDate=this.dateConfiguration.value;var currentTime=now.toLocaleFormat('%H:%M');var timeToSet=new Date(currentDate+'T'+currentTime);TimeManager.set(timeToSet);this.dateConfigurationLabel.innerHTML=timeToSet.toLocaleFormat('%Y-%m-%d');},setTime:function ui_st(){if(!!this.lock){return;}
var timeLabel=document.getElementById('time-configuration-label');var now=new Date();var currentTime=document.getElementById('time-configuration').value;if(currentTime.indexOf(':')===1){currentTime='0'+currentTime;}
var currentDate=now.toLocaleFormat('%Y-%m-%d');var timeToSet=new Date(currentDate+'T'+currentTime);TimeManager.set(timeToSet);var f=new navigator.mozL10n.DateTimeFormat();var format=_('shortTimeFormat');timeLabel.innerHTML=f.localeFormat(timeToSet,format);},setTimeZone:function ui_stz(timezone,needsConfirmation){this.timeZoneNeedsConfirmation=!!needsConfirmation;var utcOffset=timezone.utcOffset;document.getElementById('time_zone_overlay').className='UTC'+utcOffset.replace(/[+:]/g,'');var timezoneTitle=document.getElementById('time-zone-title');navigator.mozL10n.setAttributes(timezoneTitle,'timezoneTitle',{utcOffset:utcOffset,region:timezone.region,city:timezone.city});document.getElementById('tz-region-label').textContent=timezone.region;document.getElementById('tz-city-label').textContent=timezone.city;var f=new navigator.mozL10n.DateTimeFormat();var now=new Date();var timeLabel=document.getElementById('time-configuration-label');timeLabel.innerHTML=f.localeFormat(now,_('shortTimeFormat'));},updateDataConnectionStatus:function ui_udcs(status){this.dataConnectionCheckbox.checked=status;},changeStatusBarColor:function ui_csbc(color){var themeMeta=document.head.querySelector('meta[name="theme-color"]');themeMeta.setAttribute('content',color);}};function toCamelCase(str){return str.replace(/\-(.)/g,function replacer(str,p1){return p1.toUpperCase();});};'use strict';var LanguageManager={settings:window.navigator.mozSettings,init:function init(){this.buildLanguageList();document.getElementById('languages').addEventListener('change',this);this.settings.addObserver('language.current',function updateDefaultLayouts(event){KeyboardHelper.changeDefaultLayouts(event.settingValue,true);});window.addEventListener('localized',this.localizedEventListener.bind(this));},handleEvent:function handleEvent(evt){if(!this.settings||evt.target.name!='language.current'){return true;}
this.setLanguage(evt.target.value);return false;},setLanguage:function settings_setLanguage(language){this.settings.createLock().set({'language.current':language});},localizedEventListener:function settings_localizedEventListener(){var localeTimeFormat=navigator.mozL10n.get('shortTimeFormat');var is12hFormat=(localeTimeFormat.indexOf('%I')>=0);this.settings.createLock().set({'locale.hour12':is12hFormat});},buildLanguageList:function settings_buildLanguageList(){var container=document.querySelector('#languages ul');container.innerHTML='';LanguageList.get(function fillLanguageList(allLanguages,currentLanguage){for(var lang in allLanguages){var input=document.createElement('input');input.type='radio';input.name='language.current';input.value=lang;input.checked=(lang===currentLanguage);var span=document.createElement('span');var p=document.createElement('p');p.textContent=LanguageList.wrapBidi(lang,allLanguages[lang]);var label=document.createElement('label');label.classList.add('pack-radio');label.appendChild(input);label.appendChild(span);label.appendChild(p);var li=document.createElement('li');li.dataset.value=lang;li.appendChild(label);container.appendChild(li);}});}};;'use strict';function notifyCollection(){navigator.mozApps.getSelf().onsuccess=function(evt){var app=evt.target.result;if(app.connect){app.connect('setup').then(function onConnAccepted(ports){var message={txt:'setup'};ports.forEach(function(port){port.postMessage(message);});},function onConnRejected(reason){console.error('Cannot notify collection: ',reason);});}else{console.error('mozApps does not have a connect method. '+'Cannot launch the collection preload process.');}};}
var AppManager={init:function init(versionInfo){this.isInitialized=true;LanguageManager.init();UIManager.init();Navigation.init();notifyCollection();UIManager.splashScreen.addEventListener('transitionend',function onEnd(){UIManager.splashScreen.removeEventListener('transitionend',onEnd);UIManager.container.removeAttribute('aria-hidden');});if(versionInfo&&versionInfo.isUpgrade()){var stepsKey=versionInfo.delta();UIManager.splashScreen.classList.remove('show');UIManager.activationScreen.classList.remove('show');UIManager.updateScreen.classList.add('show');Tutorial.init(stepsKey,function(){Tutorial.start();});return;}
SimManager.init();WifiManager.init();ImportIntegration.init();TimeManager.init();DataMobile.init();Tutorial.init();var kSplashTimeout=700;var conn=window.navigator.mozMobileConnections&&window.navigator.mozMobileConnections[0];if(!conn){setTimeout(function(){window.location.hash='#';UIManager.activationScreen.classList.add('show');window.location.hash='#languages';UIManager.splashScreen.classList.remove('show');},kSplashTimeout);return;}
setTimeout(function(){Navigation.manageStep();UIManager.activationScreen.classList.add('show');UIManager.splashScreen.classList.remove('show');},kSplashTimeout);}};navigator.mozL10n.ready(function showBody(){VersionHelper.getVersionInfo().then(function(versionInfo){if(!AppManager.isInitialized){AppManager.init(versionInfo);}else{UIManager.initTZ();if(!UIManager.mainTitle.hasAttribute('data-l10n-id')){UIManager.mainTitle.setAttribute('data-l10n-id','language');}}});});;'use strict';var OperatorVariant=(function(){var NO_SIM='000-000';function setSIMOnFirstBootState(){var cardValue;function normalizeCode(aCode){var ncode=''+aCode;while(ncode.length<3){ncode='0'+ncode;}
return ncode;}
try{if(!IccHelper||!IccHelper.cardState){cardValue=NO_SIM;}else{var mcc=IccHelper.iccInfo.mcc;var mnc=IccHelper.iccInfo.mnc;if((mcc!==undefined)&&(mcc!==null)&&(mnc!==undefined)&&(mnc!==null)){cardValue=normalizeCode(mcc)+'-'+normalizeCode(mnc);}else{cardValue=NO_SIM;}}
var settings=navigator.mozSettings;if(!settings){console.log('Settings is not available');return;}
var req=settings.createLock().get('ftu.simPresentOnFirstBoot');req.onsuccess=function ov_onsuccess(){var currentStatus=req.result['ftu.simPresentOnFirstBoot'];if(currentStatus===undefined||currentStatus===null){var result=navigator.mozSettings.createLock().set({'ftu.simPresentOnFirstBoot':cardValue});result.onerror=function ov_error(){console.error('An error occurre setting '+'ftu.simPresentOnFirstBoot: '+cardValue);};}
cardValue=null;};req.onerror=function ov_error(){console.error('Error retrieving ftu.simPresentOnFirstBoot');};}catch(e){console.error('Error setSIMOnFirstBootState. '+e);}}
return{setSIMOnFirstBootState:setSIMOnFirstBootState};})();;'use strict';var ConfirmDialog=(function(){var isAnimationPlaying=false;var isShown=false;var doc=(parent.location===window.location)?document:parent.document;var screen=doc.getElementById('confirmation-message');var titleNode=screen.querySelector('h1');var messageNode=screen.querySelector('p');var action1Node=screen.querySelector('button:nth-of-type(1)');var action1Callback;var action2Node=screen.querySelector('button:nth-of-type(2)');var action2Callback;var oldzIndex;var callBackAndPreventDefault=function callBackAndPreventDefault(ev){if(ev.target===action1Node){action1Callback();ev.preventDefault();return false;}else if(ev.target===action2Node){action2Callback();ev.preventDefault();return false;}};var _hide=function _hide(){if(!isShown){return;}
titleNode.removeAttribute('data-l10n-id');titleNode.className='';messageNode.removeAttribute('data-l10n-id');messageNode.className='';action1Node.removeAttribute('data-l10n-id');action1Node.onclick=null;action2Node.removeAttribute('data-l10n-id');action2Node.onclick=null;screen.classList.remove('fade-in');screen.classList.add('fade-out');isAnimationPlaying=true;window.dispatchEvent(new CustomEvent('confirmdialoghiding'));screen.addEventListener('animationend',function cd_fadeOut(ev){action1Node.className='';action2Node.className='';isAnimationPlaying=false;screen.removeEventListener('animationend',cd_fadeOut);screen.classList.add('no-opacity');screen.classList.add('hide');isShown=false;});};var _show=function _show(title,msg,action1,action2,options){var setL10nAttributes=function(element,options){if('string'===typeof options){navigator.mozL10n.setAttributes(element,options);}
if(options.id){navigator.mozL10n.setAttributes(element,options.id,options.args);}};if(options&&options.zIndex){oldzIndex=screen.style.zIndex;screen.style.zIndex=options.zIndex;}
else{oldzIndex=null;}
if(title){setL10nAttributes(titleNode,title);}else{titleNode.classList.add('hide');}
if(msg){setL10nAttributes(messageNode,msg);}else{messageNode.classList.add('hide');}
if(action1){if(action1.title){setL10nAttributes(action1Node,action1.title);}
if(action1.isDanger){action1Node.classList.add('danger');}
if(action1.isRecommend){action1Node.classList.add('recommend');}
if(action1.callback){action1Callback=action1.callback;action1Node.onclick=callBackAndPreventDefault;}
if(!action2){action2Node.classList.add('hide');action1Node.classList.add('full');}}
if(action2){if(action2.title){setL10nAttributes(action2Node,action2.title);}
if(action2.isDanger){action2Node.classList.add('danger');}
if(action2.isRecommend){action2Node.classList.add('recommend');}
if(action2.callback){action2Callback=action2.callback;action2Node.onclick=callBackAndPreventDefault;}
if(!action1){action1Node.classList.add('hide');action2Node.classList.add('full');}}
if(isShown){return;}
screen.classList.remove('hide');screen.classList.remove('fade-out');screen.classList.add('fade-in');isAnimationPlaying=true;window.dispatchEvent(new CustomEvent('confirmdialogshowing'));screen.addEventListener('animationend',function cd_fadeIn(ev){isAnimationPlaying=false;screen.removeEventListener('animationend',cd_fadeIn);screen.classList.remove('no-opacity');isShown=true;});};return{hide:function dialog_hide(){if(oldzIndex){screen.style.zIndex=oldzIndex;oldzIndex=null;}
if(!isAnimationPlaying){_hide();return;}
screen.addEventListener('animationend',function cd_hideWhenFinished(ev){screen.removeEventListener('animationend',cd_hideWhenFinished);_hide();});},show:function dialog_show(title,msg,action1,action2,options){if(!isAnimationPlaying){_show(title,msg,action1,action2,options);return;}
screen.addEventListener('animationend',function cd_showWhenFinished(ev){screen.removeEventListener('animationend',cd_showWhenFinished);_show(title,msg,action1,action2,options);});}};}());;(function(exports){'use strict';exports.ComponentUtils={style:function(baseUrl){var style=document.createElement('style');var url=baseUrl+'style.css';var self=this;style.setAttribute('scoped','');style.innerHTML='@import url('+url+');';this.appendChild(style);this.style.visibility='hidden';style.addEventListener('load',function(){if(self.shadowRoot){self.shadowRoot.appendChild(style.cloneNode(true));}
self.style.visibility='';});}};}(window));;'use strict';window.GaiaButtons=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaButtonsBaseurl||'/shared/elements/gaia_buttons/';proto.createdCallback=function(){ComponentUtils.style.call(this,baseurl);};return document.registerElement('gaia-buttons',{prototype:proto});})(window);;'use strict';window.GaiaSubheader=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaSubheaderBaseurl||'/shared/elements/gaia_subheader/';proto.createdCallback=function(){ComponentUtils.style.call(this,baseurl);};return document.registerElement('gaia-subheader',{prototype:proto});})(window);;window.COMPONENTS_BASE_URL='/shared/elements/';;!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.GaiaHeader=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var debug=0?console.log.bind(console):function(){};var cache={};var MIN=16;var MAX=24;var BUFFER=3;module.exports=function(config){debug('font fit',config);var space=config.space-BUFFER;var min=config.min||MIN;var max=config.max||MAX;var text=trim(config.text);var fontSize=max;var textWidth;var font;do{font=config.font.replace(/\d+px/,fontSize+'px');textWidth=getTextWidth(text,font);}while(textWidth>space&&fontSize!==min&&fontSize--);return{textWidth:textWidth,fontSize:fontSize,overflowing:textWidth>space};};function getTextWidth(text,font){var ctx=getCanvasContext(font);var width=ctx.measureText(text).width;debug('got text width',width);return width;}
function getCanvasContext(font){debug('get canvas context',font);var cached=cache[font];if(cached){return cached;}
var canvas=document.createElement('canvas');canvas.setAttribute('moz-opaque','true');canvas.setAttribute('width','1px');canvas.setAttribute('height','1px');debug('created canvas',canvas);var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.font=font;return cache[font]=ctx;}
function trim(text){return text.replace(/\s+/g,' ').trim();}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('font-fit',this));},{}],2:[function(require,module,exports){;(function(define){define(function(require,exports,module){'use strict';var textContent=Object.getOwnPropertyDescriptor(Node.prototype,'textContent');var innerHTML=Object.getOwnPropertyDescriptor(Element.prototype,'innerHTML');var removeAttribute=Element.prototype.removeAttribute;var setAttribute=Element.prototype.setAttribute;var noop=function(){};exports.register=function(name,props){var baseProto=getBaseProto(props.extends);delete props.extends;if(props.template){var output=processCss(props.template,name);props.template=document.createElement('template');props.template.innerHTML=output.template;props.lightCss=output.lightCss;props.globalCss=props.globalCss||'';props.globalCss+=output.globalCss;}
injectGlobalCss(props.globalCss);delete props.globalCss;var descriptors=Object.assign(props.attrs||{},base.descriptors);props._attrs=props.attrs;delete props.attrs;var proto=createProto(baseProto,props);Object.defineProperties(proto,descriptors);try{return document.registerElement(name,{prototype:proto});}catch(e){if(e.name!=='NotSupportedError'){throw e;}}};var base={properties:{GaiaComponent:true,attributeChanged:noop,attached:noop,detached:noop,created:noop,createdCallback:function(){if(this.rtl){addDirObserver();}
injectLightCss(this);this.created();},attributeChangedCallback:function(name,from,to){var prop=toCamelCase(name);if(this._attrs&&this._attrs[prop]){this[prop]=to;}
this.attributeChanged(name,from,to);},attachedCallback:function(){this.attached();},detachedCallback:function(){this.detached();},setupShadowRoot:function(){if(!this.template){return;}
var node=document.importNode(this.template.content,true);this.createShadowRoot().appendChild(node);return this.shadowRoot;},setAttr:function(name,value){var internal=this.shadowRoot.firstElementChild;setAttribute.call(internal,name,value);setAttribute.call(this,name,value);},removeAttr:function(name){var internal=this.shadowRoot.firstElementChild;removeAttribute.call(internal,name);removeAttribute.call(this,name);}},descriptors:{textContent:{set:function(value){textContent.set.call(this,value);if(this.lightStyle){this.appendChild(this.lightStyle);}},get:textContent.get},innerHTML:{set:function(value){innerHTML.set.call(this,value);if(this.lightStyle){this.appendChild(this.lightStyle);}},get:innerHTML.get}}};var defaultPrototype=createProto(HTMLElement.prototype,base.properties);function getBaseProto(proto){if(!proto){return defaultPrototype;}
proto=proto.prototype||proto;return!proto.GaiaComponent?createProto(proto,base.properties):proto;}
function createProto(proto,props){return Object.assign(Object.create(proto),props);}
var hasShadowCSS=(function(){var div=document.createElement('div');try{div.querySelector(':host');return true;}
catch(e){return false;}})();var regex={shadowCss:/(?:\:host|\:\:content)[^{]*\{[^}]*\}/g,':host':/(?:\:host)/g,':host()':/\:host\((.+)\)(?: \:\:content)?/g,':host-context':/\:host-context\((.+)\)([^{,]+)?/g,'::content':/(?:\:\:content)/g};function processCss(template,name){var globalCss='';var lightCss='';if(!hasShadowCSS){template=template.replace(regex.shadowCss,function(match){var hostContext=regex[':host-context'].exec(match);if(hostContext){globalCss+=match.replace(regex['::content'],'').replace(regex[':host-context'],'$1 '+name+'$2').replace(/ +/g,' ');}else{lightCss+=match.replace(regex[':host()'],name+'$1').replace(regex[':host'],name).replace(regex['::content'],name);}
return'';});}
return{template:template,lightCss:lightCss,globalCss:globalCss};}
function injectGlobalCss(css){if(!css)return;var style=document.createElement('style');style.innerHTML=css.trim();headReady().then(()=>{document.head.appendChild(style)});}
function headReady(){return new Promise(resolve=>{if(document.head){return resolve();}
window.addEventListener('load',function fn(){window.removeEventListener('load',fn);resolve();});});}
function injectLightCss(el){if(hasShadowCSS){return;}
el.lightStyle=document.createElement('style');el.lightStyle.setAttribute('scoped','');el.lightStyle.innerHTML=el.lightCss;el.appendChild(el.lightStyle);}
function toCamelCase(string){return string.replace(/-(.)/g,function replacer(string,p1){return p1.toUpperCase();});}
var dirObserver;function addDirObserver(){if(dirObserver){return;}
dirObserver=new MutationObserver(onChanged);dirObserver.observe(document.documentElement,{attributeFilter:['dir'],attributes:true});function onChanged(mutations){document.dispatchEvent(new Event('dirchanged'));}}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-component',this));},{}],3:[function(require,module,exports){(function(define){define(function(require,exports,module){var base=window.GAIA_ICONS_BASE_URL||window.COMPONENTS_BASE_URL||'bower_components/';if(!document.documentElement){window.addEventListener('load',load);}else{load();}
function load(){if(isLoaded()){return;}
var link=document.createElement('link');link.rel='stylesheet';link.type='text/css';link.href=base+'gaia-icons/gaia-icons.css';document.head.appendChild(link);exports.loaded=true;}
function isLoaded(){return exports.loaded||document.querySelector('link[href*=gaia-icons]')||document.documentElement.classList.contains('gaia-icons-loaded');}});})(typeof define=='function'&&define.amd?define:(function(n,w){return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-icons',this));},{}],4:[function(require,module,exports){;(function(define){'use strict';define(function(require,exports,module){var component=require('gaia-component');var fontFit=require('font-fit');require('gaia-icons');var debug=0?console.log.bind(console):function(){};const KNOWN_ACTIONS={menu:'menu',back:'back',close:'close'};const TITLE_FONT='italic 300 24px FiraSans';const TITLE_PADDING=10;const MINIMUM_FONT_SIZE_CENTERED=20;const MINIMUM_FONT_SIZE_UNCENTERED=16;const MAXIMUM_FONT_SIZE=23;module.exports=component.register('gaia-header',{created:function(){debug('created');this.setupShadowRoot();this.els={actionButton:this.shadowRoot.querySelector('.action-button'),buttons:this.querySelectorAll('button, a'),titles:this.querySelectorAll('h1')};this.els.actionButton.addEventListener('click',e=>this.onActionButtonClick(e));this.observer=new MutationObserver(this.onMutation.bind(this));this.titleEnd=this.getAttribute('title-end');this.titleStart=this.getAttribute('title-start');this.noFontFit=this.getAttribute('no-font-fit');this.notFlush=this.hasAttribute('not-flush');this.action=this.getAttribute('action');this.unresolved={};this.pending={};this._resizeThrottlingId=null;this.onResize=this.onResize.bind(this);},attached:function(){debug('attached');this.runFontFitSoon();this.observerStart();window.addEventListener('resize',this.onResize);},detached:function(){debug('detached');window.removeEventListener('resize',this.onResize);this.observerStop();this.clearPending();},clearPending:function(){for(var key in this.pending){this.pending[key].clear();delete this.pending[key];}
window.cancelAnimationFrame(this._resizeThrottlingId);this._resizeThrottlingId=null;},runFontFit:function(){debug('run font-fit');if(this.noFontFit){return Promise.resolve();}
var titles=this.els.titles;var space=this.getTitleSpace();var styles=[].map.call(titles,el=>this.getTitleStyle(el,space));return this.setTitleStylesSoon(styles);},runFontFitSoon:function(){debug('run font-fit soon');if(this.pending.runFontFitSoon){return;}
this.pending.runFontFitSoon=this.nextTick(()=>{delete this.pending.runFontFitSoon;this.runFontFit();});},getTitleStyle:function(el,space){debug('get el style',el,space);var text=el.textContent;var styleId=space.start+text+space.end+'#'+space.value;if(!text||!text.trim()){return debug('exit: no text');}
if(getStyleId(el)===styleId){return debug('exit: no change');}
var marginStart=this.getTitleMarginStart();var textSpace=space.value-Math.abs(marginStart);var fontFitResult=this.fontFit(text,textSpace,{min:MINIMUM_FONT_SIZE_CENTERED});var overflowing=fontFitResult.overflowing;var padding={start:0,end:0};if(overflowing){debug('title overflowing');padding.start=!space.start?TITLE_PADDING:0;padding.end=!space.end?TITLE_PADDING:0;textSpace=space.value-padding.start-padding.end;fontFitResult=this.fontFit(text,textSpace);marginStart=0;}
return{id:styleId,fontSize:fontFitResult.fontSize,marginStart:marginStart,overflowing:overflowing,padding:padding};},setTitleStylesSoon:function(styles){debug('set title styles soon',styles);var key='setStyleTitlesSoon';this._titleStyles=styles;return this.unresolved[key]=this.unresolved[key]||new Promise((resolve)=>{this.pending[key]=this.nextTick(()=>{var styles=this._titleStyles;var els=this.els.titles;[].forEach.call(els,(el,i)=>{if(!styles[i]){return debug('exit');}
this.setTitleStyle(el,styles[i]);});delete this._titleStyles;delete this.unresolved[key];delete this.pending[key];resolve();});});},setTitleStyle:function(el,style){debug('set title style',style);this.observerStop();el.style.marginLeft=style.marginStart+'px';el.style.paddingLeft=style.padding.start+'px';el.style.paddingRight=style.padding.end+'px';el.style.fontSize=style.fontSize+'px';setStyleId(el,style.id);this.observerStart();},fontFit:function(text,space,opts={}){debug('font fit:',text,space,opts);var fontFitArgs={font:TITLE_FONT,min:opts.min||MINIMUM_FONT_SIZE_UNCENTERED,max:MAXIMUM_FONT_SIZE,text:text,space:space};return fontFit(fontFitArgs);},observerStart:function(){if(this.observing){return;}
this.observer.observe(this,{childList:true,attributes:true,subtree:true});this.observing=true;debug('observer started');},observerStop:function(){if(!this.observing){return;}
this.observer.disconnect();this.observing=false;debug('observer stopped');},onResize:function(e){debug('onResize',this._resizeThrottlingId);if(this._resizeThrottlingId!==null){return;}
this._resizeThrottlingId=window.requestAnimationFrame(()=>{this._resizeThrottlingId=null;this.runFontFitSoon();});},onMutation:function(mutations){debug('on mutation',mutations);if(!this.pending.runFontFitSoon){this.runFontFit();}},getTitleSpace:function(){var start=this.titleStart;var end=this.titleEnd;var space=this.getWidth()-start-end;var result={value:space,start:start,end:end};debug('get title space',result);return result;},getWidth:function(){var value=this.notFlush?this.clientWidth:window.innerWidth;debug('get width',value);return value;},triggerAction:function(){if(this.action){this.els.actionButton.click();}},onActionButtonClick:function(){debug('action button click');var config={detail:{type:this.action}};var e=new CustomEvent('action',config);setTimeout(()=>this.dispatchEvent(e));},getTitleMarginStart:function(){var start=this.titleStart;var end=this.titleEnd;var marginStart=end-start;debug('get title margin start',marginStart);return marginStart;},getButtonsBeforeTitle:function(){var children=this.children;var l=children.length;var els=[];for(var i=0;i<l;i++){var el=children[i];if(el.tagName==='H1'){break;}
if(!contributesToLayout(el)){continue;}
els.push(el);}
if(this.action){els.push(this.els.actionButton);}
return els;},getButtonsAfterTitle:function(){var children=this.children;var els=[];for(var i=children.length-1;i>=0;i--){var el=children[i];if(el.tagName==='H1'){break;}
if(!contributesToLayout(el)){continue;}
els.push(el);}
return els;},sumButtonWidths:function(buttons){var defaultWidth=50;var sum=buttons.reduce((prev,button)=>{var isStandardButton=button===this.els.actionButton;var width=isStandardButton?defaultWidth:button.clientWidth;return prev+width;},0);debug('sum button widths',buttons,sum);return sum;},attrs:{action:{get:function(){return this._action;},set:function(value){var action=KNOWN_ACTIONS[value];if(action===this._action){return;}
this.setAttr('action',action);this._action=action;},},titleStart:{get:function(){debug('get title-start');if('_titleStart'in this){return this._titleStart;}
var buttons=this.getButtonsBeforeTitle();var value=this.sumButtonWidths(buttons);debug('get title-start',buttons,value);return value;},set:function(value){debug('set title-start',value);value=parseInt(value,10);if(value===this._titleStart||isNaN(value)){return;}
this.setAttr('title-start',value);this._titleStart=value;debug('set');}},titleEnd:{get:function(){debug('get title-end');if('_titleEnd'in this){return this._titleEnd;}
var buttons=this.getButtonsAfterTitle();return this.sumButtonWidths(buttons);},set:function(value){debug('set title-end',value);value=parseInt(value,10);if(value===this._titleEnd||isNaN(value)){return;}
this.setAttr('title-end',value);this._titleEnd=value;}},noFontFit:{get:function(){return this._noFontFit||false;},set:function(value){debug('set no-font-fit',value);value=!!(value||value==='');if(value===this.noFontFit){return;}
this._noFontFit=value;if(value){this.setAttr('no-font-fit','');}
else{this.removeAttr('no-font-fit');}}}},template:`<div class="inner">
    <button class="action-button">
      <content select=".l10n-action"></content>
    </button>
    <content></content>
  </div>

  <style>

  :host {
    display: block;
    -moz-user-select: none;

    --gaia-header-button-color:
      var(--header-button-color,
      var(--header-color,
      var(--link-color,
      inherit)));
  }

  /**
   * [hidden]
   */

  :host[hidden] {
    display: none;
  }

  /** Reset
   ---------------------------------------------------------*/

  ::-moz-focus-inner { border: 0; }

  /** Inner
   ---------------------------------------------------------*/

  .inner {
    display: flex;
    min-height: 50px;
    direction: ltr;
    -moz-user-select: none;

    background:
      var(--header-background,
      var(--background,
      #fff));
  }

  /** Action Button
   ---------------------------------------------------------*/

  /**
   * 1. Hidden by default
   */

  .action-button {
    position: relative;

    display: none; /* 1 */
    width: 50px;
    font-size: 30px;
    margin: 0;
    padding: 0;
    border: 0;
    outline: 0;

    align-items: center;
    background: none;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [action=back]
   * [action=menu]
   * [action=close]
   *
   * 1. For icon vertical-alignment
   */

  [action=back] .action-button,
  [action=menu] .action-button,
  [action=close] .action-button {
    display: flex; /* 1 */
  }

  /**
   * :active
   */

  .action-button:active {
    transition: none;
    opacity: 0.2;
  }

  /** Action Button Icon
   ---------------------------------------------------------*/

  .action-button:before {
    font-family: 'gaia-icons';
    font-style: normal;
    text-rendering: optimizeLegibility;
    font-weight: 500;
  }

  [action=close] .action-button:before { content: 'close' }
  [action=back] .action-button:before { content: 'back' }
  [action=menu] .action-button:before { content: 'menu' }

  /** Action Button Icon
   ---------------------------------------------------------*/

  /**
   * 1. To enable vertical alignment.
   */

  .action-button:before {
    display: block;
  }

  /** Action Button Text
   ---------------------------------------------------------*/

  /**
   * To provide custom localized content for
   * the action-button, we allow the user
   * to provide an element with the class
   * .l10n-action. This node is then
   * pulled inside the real action-button.
   *
   * Example:
   *
   *   <gaia-header action="back">
   *     <span class="l10n-action" aria-label="Back">Localized text</span>
   *     <h1>title</h1>
   *   </gaia-header>
   */

  ::content .l10n-action {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    font-size: 0;
  }

  /** Title
   ---------------------------------------------------------*/

  /**
   * 1. Vertically center text. We can't use flexbox
   *    here as it breaks text-overflow ellipsis
   *    without an inner div.
   */

  ::content h1 {
    flex: 1;
    margin: 0;
    padding: 0;
    overflow: hidden;

    white-space: nowrap;
    text-overflow: ellipsis;
    text-align: center;
    line-height: 50px; /* 1 */
    font-weight: 300;
    font-style: italic;
    font-size: 24px;

    color:
      var(--header-title-color,
      var(--header-color,
      var(--title-color,
      var(--text-color,
      inherit))));
  }

  /**
   * [dir=rtl]
   *
   * When the document is in RTL mode we still
   * want the <h1> text to be reversed to that
   * strings like '1 selected' become 'selected 1'.
   *
   * When we're happy for gaia-header to be fully
   * RTL responsive we won't need this rule anymore,
   * but this depends on all Gaia apps being ready.
   */

  :host-context([dir=rtl]) ::content h1 {
    direction: rtl;
  }

  /** Buttons
   ---------------------------------------------------------*/

  ::content a,
  ::content button {
    position: relative;
    z-index: 1;
    box-sizing: border-box;
    display: flex;
    width: auto;
    height: auto;
    min-width: 50px;
    margin: 0;
    padding: 0 10px;
    outline: 0;
    border: 0;

    font-size: 14px;
    line-height: 1;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    text-align: center;
    background: none;
    border-radius: 0;
    font-style: italic;
    cursor: pointer;
    transition: opacity 200ms 280ms;
    color: var(--gaia-header-button-color);
  }

  /**
   * :active
   */

  ::content a:active,
  ::content button:active {
    transition: none;
    opacity: 0.2;
  }

  /**
   * [hidden]
   */

  ::content a[hidden],
  ::content button[hidden] {
    display: none;
  }

  /**
   * [disabled]
   */

  ::content a[disabled],
  ::content button[disabled] {
    pointer-events: none;
    color: var(--header-disabled-button-color);
  }

  /** Icon Buttons
   ---------------------------------------------------------*/

  /**
   * Icons are a different color to text
   */

  ::content .icon,
  ::content [data-icon] {
    color:
      var(--header-icon-color,
      var(--gaia-header-button-color));
  }

  /**
   * If users want their action button
   * to be in the component's light-dom
   * they can add an .action class
   * to make it look like the
   * shadow action button.
   */

  ::content .action {
    color:
      var(--header-action-button-color,
      var(--header-icon-color,
      var(--gaia-header-button-color)));
  }

  /**
   * [data-icon]:empty
   *
   * Icon buttons with no textContent,
   * should always be 50px.
   *
   * This is to prevent buttons being
   * larger than they should be before
   * icon-font has loaded.
   */

  ::content [data-icon]:empty {
    width: 50px;
  }

  </style>`,nextTick:nextTick});function contributesToLayout(el){return el.tagName!=='STYLE';}
function setStyleId(el,id){el._styleId=id;}
function getStyleId(el){return el._styleId;}
function nextTick(fn){var cleared;Promise.resolve().then(()=>{if(!cleared){fn();}});return{clear:function(){cleared=true;}};}});})(typeof define=='function'&&define.amd?define:(function(n,w){'use strict';return typeof module=='object'?function(c){c(require,exports,module);}:function(c){var m={exports:{}};c(function(n){return w[n];},m.exports,m);w[n]=m.exports;};})('gaia-header',this));},{"font-fit":1,"gaia-component":2,"gaia-icons":3}]},{},[4])(4)});