;'use strict';(function(exports){var L10nLoader=function(){this.loadStarted=false;};L10nLoader.prototype.SCRIPT_URL='/shared/js/l10n.js';L10nLoader.prototype.load=function(){if(this.loadStarted){return;}
this.loadStarted=true;document.documentElement.lang='x-untranslated';var script=document.createElement('script');script.src=this.SCRIPT_URL;document.body.appendChild(script);};exports.L10nLoader=L10nLoader;})(window);;'use strict';(function(exports){var UserPress=function(obj,coords){this.target=obj;this.updateCoords(coords,false);};UserPress.prototype.updateCoords=function(coords,moved){this.moved=moved;this.clientX=coords.clientX;this.clientY=coords.clientY;};var UserPressManager=function(app){this._started=false;this._ignoreMouseEvents=false;this.presses=new Map();this.touchstartCounts=new WeakMap();this.app=app;};UserPressManager.prototype.onpressstart=null;UserPressManager.prototype.onpressmove=null;UserPressManager.prototype.onpressend=null;UserPressManager.prototype.MOVE_LIMIT=5;UserPressManager.prototype.start=function(){this.app.console.log('UserPressManager.start()');if(this._started){throw new Error('UserPressManager: '+'Instance should not be start()\'ed twice.');}
this._started=true;this._container=this.app.getContainer();this._container.addEventListener('touchstart',this);this._container.addEventListener('mousedown',this);this._container.addEventListener('contextmenu',this);};UserPressManager.prototype.stop=function(){this.app.console.log('UserPressManager.stop()');if(!this._started){throw new Error('UserPressManager: '+'Instance was never start()\'ed but stop() is called.');}
this._started=false;this._container.removeEventListener('touchstart',this);this._container.removeEventListener('mousedown',this);this._container.removeEventListener('mousemove',this);this._container.removeEventListener('mouseup',this);this._container.removeEventListener('mouseleave',this);this._container.removeEventListener('contextmenu',this);};UserPressManager.prototype.handleEvent=function(evt){var touch,touchId,el,i,touchstartCount;switch(evt.type){case'contextmenu':evt.preventDefault();break;case'touchstart':this._ignoreMouseEvents=true;touchstartCount=this.touchstartCounts.get(evt.target)||0;touchstartCount++;this.touchstartCounts.set(evt.target,touchstartCount);evt.target.addEventListener('touchmove',this);evt.target.addEventListener('touchend',this);evt.target.addEventListener('touchcancel',this);for(i=0;i<evt.changedTouches.length;i++){touch=evt.changedTouches[i];touchId=touch.identifier;el=touch.target;this._handleNewPress(el,touch,touchId);}
break;case'touchmove':for(i=0;i<evt.changedTouches.length;i++){touch=evt.changedTouches[i];touchId=touch.identifier;if(!this._distanceReachesLimit(touchId,touch)){continue;}
el=document.elementFromPoint(touch.clientX,touch.clientY);this._handleChangedPress(el,touch,touchId);}
break;case'touchend':case'touchcancel':touchstartCount=this.touchstartCounts.get(evt.target);touchstartCount--;if(touchstartCount){this.touchstartCounts.set(evt.target,touchstartCount);}else{evt.target.removeEventListener('touchmove',this);evt.target.removeEventListener('touchend',this);evt.target.removeEventListener('touchcancel',this);this.touchstartCounts.delete(evt.target);}
if(!this._started){return;}
for(i=0;i<evt.changedTouches.length;i++){touch=evt.changedTouches[i];touchId=touch.identifier;el=document.elementFromPoint(touch.clientX,touch.clientY);this._handleFinishPress(el,touch,touchId);}
break;case'mousedown':evt.preventDefault();if(this._ignoreMouseEvents){return;}
this._container.addEventListener('mousemove',this);this._container.addEventListener('mouseup',this);this._container.addEventListener('mouseleave',this);this._handleNewPress(evt.target,evt,'_mouse');break;case'mousemove':if(!this._distanceReachesLimit('_mouse',evt)){return;}
this._handleChangedPress(evt.target,evt,'_mouse');break;case'mouseup':case'mouseleave':this._container.removeEventListener('mousemove',this);this._container.removeEventListener('mouseup',this);this._container.removeEventListener('mouseleave',this);this._handleFinishPress(evt.target,evt,'_mouse');break;}};UserPressManager.prototype._handleNewPress=function(el,coords,id){this.app.console.info('UserPressManager._handleNewPress()');var press=new UserPress(this.app.layoutRenderingManager.getTargetObject(el),coords);this.presses.set(id,press);if(typeof this.onpressstart==='function'){this.onpressstart(press,id);}};UserPressManager.prototype._handleChangedPress=function(el,coords,id){this.app.console.info('UserPressManager._handleChangedPress()');var press=this.presses.get(id);press.target=this.app.layoutRenderingManager.getTargetObject(el);press.updateCoords(coords,true);if(typeof this.onpressmove==='function'){this.onpressmove(press,id);}};UserPressManager.prototype._handleFinishPress=function(el,coords,id){this.app.console.info('UserPressManager._handleFinishPress()');var press=this.presses.get(id);press.target=this.app.layoutRenderingManager.getTargetObject(el);press.updateCoords(coords,press.moved||this._distanceReachesLimit(id,coords));if(typeof this.onpressend==='function'){this.onpressend(press,id);}
this.presses.delete(id);};UserPressManager.prototype._distanceReachesLimit=function(id,newCoord){var press=this.presses.get(id);var dx=press.clientX-newCoord.clientX;var dy=press.clientY-newCoord.clientY;var limit=this.MOVE_LIMIT;return(dx>=limit||dx<=-limit||dy>=limit||dy<=-limit);};exports.UserPress=UserPress;exports.UserPressManager=UserPressManager;})(window);;'use strict';(function(exports){var HandwritingPadsManager=function(app){this._started=false;this._timeOutId=undefined;this._strokeWidth=5;this._responseTime=200;this._strokePoints=[];this._currentTarget=null;this._cleared=false;this.app=app;};HandwritingPadsManager.prototype.MAX_RESPONSE_TIME=600;HandwritingPadsManager.prototype.start=function(){if(this._started){throw new Error('HandwritingPadsManager: '+'Instance should not be start()\'ed twice.');}
this.handwritingPadSettings=new HandwritingPadSettings();this.handwritingPadSettings.promiseManager=this.app.settingsPromiseManager;this.handwritingPadSettings.onsettingchange=this._handleSettingsChange.bind(this);this.handwritingPadSettings.initSettings().then(this._handleSettingsChange.bind(this),function rejected(){console.error('Fatal Error! Failed to get initial '+'handwriting pad settings.');});this._started=true;};HandwritingPadsManager.prototype.stop=function(){if(!this._started){throw new Error('HandwritingPadsManager: '+'Instance was never start()\'ed but stop() is called.');}
this.handwritingPadSettings=null;this._started=false;};HandwritingPadsManager.prototype._handleSettingsChange=function(values){this._strokeWidth=values.strokeWidth;this._responseTime=values.responseTime;};HandwritingPadsManager.prototype.handlePressStart=function(press){clearTimeout(this._timeOutId);if(!this._currentTarget){this._currentTarget=press.target;}else if(this._currentTarget!=press.target&&!this._cleared){this.app.layoutRenderingManager.clearHandwritingPad(this._currentTarget);this._strokePoints=[];this._currentTarget=press.target;}
this._cleared=false;var point=this.app.layoutRenderingManager.drawHandwritingPad(press,true,this._strokeWidth);this._strokePoints.push(point.posX,point.posY);};HandwritingPadsManager.prototype.handlePressMove=function(press){var point=this.app.layoutRenderingManager.drawHandwritingPad(press,false,this._strokeWidth);this._strokePoints.push(point.posX,point.posY);};HandwritingPadsManager.prototype.handlePressEnd=function(){this._timeOutId=setTimeout(this._sendStrokePoints.bind(this),this.MAX_RESPONSE_TIME-this._responseTime);this._strokePoints.push(-1,0);};HandwritingPadsManager.prototype._sendStrokePoints=function(){if(this._strokePoints.length<=1){return;}
var ime=this.app.inputMethodManager.currentIMEngine;if(ime.sendStrokePoints){ime.sendStrokePoints(this._strokePoints);}};HandwritingPadsManager.prototype.clear=function(){this.app.layoutRenderingManager.clearHandwritingPad(this._currentTarget);this._strokePoints=[];this._cleared=true;};exports.HandwritingPadsManager=HandwritingPadsManager;})(window);;'use strict';(function(exports){var AlternativesCharMenuManager=function(app){this.app=app;this.isShown=false;this._originalTarget=null;this._menuAreaTop=this._menuAreaLeft=this._menuAreaRight=this._menuAreaBottom=0;};AlternativesCharMenuManager.prototype.start=function(){this._currentMenuView=null;};AlternativesCharMenuManager.prototype.stop=function(){this._currentMenuView=null;};AlternativesCharMenuManager.prototype.show=function(target){var alternatives=this._getAlternativesForTarget(target);if(!alternatives){return;}
var targetRect=IMERender.getView(target).element.getBoundingClientRect();this._currentMenuView=IMERender.showAlternativesCharMenu(target,alternatives);this.isShown=true;this._originalTarget=target;var menuRect=this._currentMenuView.getBoundingClientRect();this._menuAreaTop=menuRect.top;this._menuAreaLeft=Math.min(targetRect.left,menuRect.left);this._menuAreaLeft-=targetRect.width;this._menuAreaBottom=targetRect.bottom;this._menuAreaRight=Math.max(targetRect.right,menuRect.right);this._menuAreaRight+=targetRect.width;};AlternativesCharMenuManager.prototype._getAlternativesForTarget=function _getAlternativesForTarget(key){var alternatives;var altMap=this.app.layoutManager.currentPage.alt;var origKey=null;if(this.app.upperCaseStateManager.isUpperCaseLocked){origKey=key.uppercaseValue;alternatives=altMap[origKey]&&(altMap[origKey].upperCaseLocked||altMap[origKey]);}else if(this.app.upperCaseStateManager.isUpperCase){origKey=key.uppercaseValue;alternatives=altMap[origKey];}else{origKey=key.lowercaseValue;alternatives=altMap[origKey];}
if(!alternatives||!alternatives.length){return false;}
return[].concat(origKey,alternatives);};AlternativesCharMenuManager.prototype.hide=function(){if(!this.isShown){return;}
IMERender.hideAlternativesCharMenu();this.isShown=false;this._originalTarget=null;this._menuAreaTop=this._menuAreaLeft=this._menuAreaRight=this._menuAreaBottom=0;this._currentMenuView=null;};AlternativesCharMenuManager.prototype.isMenuTarget=function(target){if(!this._currentMenuView){return false;}
return this._currentMenuView.isMenuTarget(target);};AlternativesCharMenuManager.prototype.getMenuTarget=function(press){if(!this.isShown){throw new Error('AlternativesCharMenuManager: '+'getMenuTarget called but menu is not shown');}
return this._currentMenuView.getMenuTarget(press.clientX,press.clientY);};AlternativesCharMenuManager.prototype.isInMenuArea=function(press){if(!this.isShown){return false;}
return(press.clientY>=this._menuAreaTop&&press.clientY<=this._menuAreaBottom&&press.clientX>=this._menuAreaLeft&&press.clientX<=this._menuAreaRight);};exports.AlternativesCharMenuManager=AlternativesCharMenuManager;})(window);;'use strict';(function(exports){var VisualHighlightManager=function(app){this.app=app;this.highlightDelayTimers=new Map();};VisualHighlightManager.prototype.HIGHTLIGHT_DELAY_MS=85;VisualHighlightManager.prototype.start=function(){};VisualHighlightManager.prototype.stop=function(){};VisualHighlightManager.prototype.show=function(target){this.highlightDelayTimers.forEach(function(timer,target){clearTimeout(timer);this.highlightDelayTimers.delete(target);IMERender.unHighlightKey(target);},this);IMERender.highlightKey(target);};VisualHighlightManager.prototype.hide=function(target){if(this.highlightDelayTimers.has(target)){clearTimeout(this.highlightDelayTimers.get(target));}
var timer=setTimeout(function(){this.highlightDelayTimers.delete(target);IMERender.unHighlightKey(target);}.bind(this),this.HIGHTLIGHT_DELAY_MS);this.highlightDelayTimers.set(target,timer);};exports.VisualHighlightManager=VisualHighlightManager;})(window);;'use strict';(function(exports){var DefaultTargetHandler=function(target,app){this.target=target;this.app=app;this.ignoreCommitActions=false;};DefaultTargetHandler.prototype.activate=function(){this.app.console.log('DefaultTargetHandler.activate()');this.app.feedbackManager.triggerFeedback(this.target);this.app.visualHighlightManager.show(this.target);};DefaultTargetHandler.prototype.longPress=function(){this.app.console.log('DefaultTargetHandler.longPress()');if(!('longPressValue'in this.target)){return;}
this.ignoreCommitActions=true;var keyCode=this.target.longPressKeyCode;var promise=Promise.resolve(this.app.inputMethodManager.currentIMEngine.click(keyCode));this.app.visualHighlightManager.hide(this.target);return promise;};DefaultTargetHandler.prototype.moveOut=function(){this.app.console.log('DefaultTargetHandler.moveOut()');this.app.visualHighlightManager.hide(this.target);};DefaultTargetHandler.prototype.moveIn=function(){this.app.console.log('DefaultTargetHandler.moveIn()');this.app.visualHighlightManager.show(this.target);};DefaultTargetHandler.prototype.commit=function(){this.app.console.log('DefaultTargetHandler.commit()');if(this.ignoreCommitActions){this.app.console.log('DefaultTargetHandler.commit()::return early');return;}
var keyCode=this.target.keyCode;var keyCodeUpper=this.target.keyCodeUpper;var engine=this.app.inputMethodManager.currentIMEngine;var promise;if(this.app.layoutManager.currentPage.imEngine==='latin'){this.app.console.log('DefaultTargetHandler.commit()::latin::engine.click',keyCode,keyCodeUpper);promise=Promise.resolve(engine.click(keyCode,keyCodeUpper));}else{var code=this.app.upperCaseStateManager.isUpperCase?keyCodeUpper:keyCode;this.app.console.log('DefaultTargetHandler.commit()::engine.click',code);promise=Promise.resolve(engine.click(code));}
this.app.visualHighlightManager.hide(this.target);return promise;};DefaultTargetHandler.prototype.cancel=function(){this.app.console.log('DefaultTargetHandler.cancel()');this.app.visualHighlightManager.hide(this.target);};DefaultTargetHandler.prototype.doubleTap=function(){this.app.console.log('DefaultTargetHandler.doubleTap()');return this.commit();};DefaultTargetHandler.prototype.newTargetActivate=function(){this.commit();this.ignoreCommitActions=true;};DefaultTargetHandler.prototype.move=function(){};var NullTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};NullTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);NullTargetHandler.prototype.activate=NullTargetHandler.prototype.moveIn=NullTargetHandler.prototype.moveOut=NullTargetHandler.prototype.commit=NullTargetHandler.prototype.cancel=NullTargetHandler.prototype.doubleTap=function(){};var SpaceKeyTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};SpaceKeyTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);SpaceKeyTargetHandler.prototype.longPress=function(){this.app.targetHandlersManager.activeTargetsManager.clearAllTargets();navigator.mozInputMethod.mgmt.hide();this.app.visualHighlightManager.hide(this.target);};var CandidateSelectionTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};CandidateSelectionTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);CandidateSelectionTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){this.app.console.log('CandidateSelectionTargetHandler.commit()::return early');return;}
this.app.candidatePanelManager.hideFullPanel();var engine=this.app.inputMethodManager.currentIMEngine;if(typeof engine.select==='function'){engine.select(this.target.text,this.target.data);}
this.app.visualHighlightManager.hide(this.target);};var BackspaceTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);this.deleteTimeout=undefined;this.deleteInterval=undefined;this.ignoreCommitActions=false;};BackspaceTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);BackspaceTargetHandler.prototype.REPEAT_RATE=50;BackspaceTargetHandler.prototype.REPEAT_TIMEOUT=500;BackspaceTargetHandler.prototype._sendDelete=function(isRepeat){var engine=this.app.inputMethodManager.currentIMEngine;engine.click(KeyEvent.DOM_VK_BACK_SPACE,null,isRepeat);};BackspaceTargetHandler.prototype.activate=function(){this.app.feedbackManager.triggerFeedback(this.target);this.app.visualHighlightManager.show(this.target);this.deleteTimeout=setTimeout(function(){this._sendDelete(true);this.deleteInterval=setInterval(function(){this._sendDelete(true);}.bind(this),this.REPEAT_RATE);}.bind(this),this.REPEAT_TIMEOUT);};BackspaceTargetHandler.prototype.moveOut=function(){this.app.visualHighlightManager.hide(this.target);clearTimeout(this.deleteTimeout);clearInterval(this.deleteInterval);};BackspaceTargetHandler.prototype.moveIn=function(){this.ignoreCommitActions=true;};BackspaceTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){this.app.console.log('BackspaceTargetHandler.commit()::return early');return;}
clearTimeout(this.deleteTimeout);clearInterval(this.deleteInterval);this._sendDelete(false);this.app.visualHighlightManager.hide(this.target);};BackspaceTargetHandler.prototype.cancel=function(){clearTimeout(this.deleteTimeout);clearInterval(this.deleteInterval);this.app.visualHighlightManager.hide(this.target);};var CompositeTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};CompositeTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);CompositeTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){this.app.console.log('CompositeTargetHandler.commit()::return early');return;}
var promise=Promise.resolve();var compositeString=this.target.compositeKey;var engine=this.app.inputMethodManager.currentIMEngine;for(var i=0;i<compositeString.length;i++){var sendKeyPromise=Promise.resolve(engine.click(compositeString.charCodeAt(i)));promise=promise.then(sendKeyPromise,sendKeyPromise);}
this.app.visualHighlightManager.hide(this.target);return promise;};var PageSwitchingTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};PageSwitchingTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);PageSwitchingTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){this.app.console.log('PageSwitchingTargetHandler.commit()::return early');return;}
var page=this.target.targetPage;this.app.setLayoutPage(page);this.app.visualHighlightManager.hide(this.target);var currentIMEngine=this.app.inputMethodManager.currentIMEngine;if(typeof currentIMEngine.empty==='function'){currentIMEngine.empty();}};var CapsLockTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);this.isPreviouslyUpperCase=undefined;};CapsLockTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);CapsLockTargetHandler.prototype.isNewTargetActivated=false;CapsLockTargetHandler.prototype.activate=function(){this.isPreviouslyUpperCase=this.app.upperCaseStateManager.isUpperCase;this.app.upperCaseStateManager.switchUpperCaseState({isUpperCaseLocked:true});this.app.feedbackManager.triggerFeedback(this.target);this.app.visualHighlightManager.show(this.target);};CapsLockTargetHandler.prototype.commit=function(){if(this.isNewTargetActivated){this.app.upperCaseStateManager.switchUpperCaseState({isUpperCase:false,isUpperCaseLocked:false});}else{this.app.upperCaseStateManager.switchUpperCaseState({isUpperCase:!this.isPreviouslyUpperCase,isUpperCaseLocked:false});}
this.app.visualHighlightManager.hide(this.target);};CapsLockTargetHandler.prototype.doubleTap=function(){this.app.upperCaseStateManager.switchUpperCaseState({isUpperCaseLocked:true});this.app.visualHighlightManager.hide(this.target);};CapsLockTargetHandler.prototype.newTargetActivate=function(){this.isNewTargetActivated=true;};var SwitchKeyboardTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};SwitchKeyboardTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);SwitchKeyboardTargetHandler.prototype.longPress=function(){this.ignoreCommitActions=true;this.app.targetHandlersManager.activeTargetsManager.clearAllTargets();navigator.mozInputMethod.mgmt.showAll();this.app.visualHighlightManager.hide(this.target);};SwitchKeyboardTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){return;}
this.app.targetHandlersManager.activeTargetsManager.clearAllTargets();navigator.mozInputMethod.mgmt.next();this.app.visualHighlightManager.hide(this.target);};var ToggleCandidatePanelTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};ToggleCandidatePanelTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);ToggleCandidatePanelTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){this.app.console.log('ToggleCandidatePanelTargetHandler.commit()::return early');return;}
this.app.candidatePanelManager.toggleFullPanel();this.app.visualHighlightManager.hide(this.target);};var DismissSuggestionsTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};DismissSuggestionsTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);DismissSuggestionsTargetHandler.prototype.commit=function(){if(this.ignoreCommitActions){this.app.console.log('DismissSuggestionsTargetHandler.commit()::return early');return;}
var engine=this.app.inputMethodManager.currentIMEngine;if(typeof engine.dismissSuggestions==='function'){engine.dismissSuggestions();}
this.app.visualHighlightManager.hide(this.target);};var HandwritingPadTargetHandler=function(target,app){DefaultTargetHandler.apply(this,arguments);};HandwritingPadTargetHandler.prototype=Object.create(DefaultTargetHandler.prototype);HandwritingPadTargetHandler.prototype.activate=function(press){this.app.handwritingPadsManager.handlePressStart(press);};HandwritingPadTargetHandler.prototype.move=function(press){this.app.handwritingPadsManager.handlePressMove(press);};HandwritingPadTargetHandler.prototype.moveOut=function(press){};HandwritingPadTargetHandler.prototype.moveIn=function(press){this.app.handwritingPadsManager.handlePressStart(press);};HandwritingPadTargetHandler.prototype.commit=function(){this.app.handwritingPadsManager.handlePressEnd();};HandwritingPadTargetHandler.prototype.newTargetActivate=function(){};exports.DefaultTargetHandler=DefaultTargetHandler;exports.NullTargetHandler=NullTargetHandler;exports.SpaceKeyTargetHandler=SpaceKeyTargetHandler;exports.CandidateSelectionTargetHandler=CandidateSelectionTargetHandler;exports.BackspaceTargetHandler=BackspaceTargetHandler;exports.CompositeTargetHandler=CompositeTargetHandler;exports.PageSwitchingTargetHandler=PageSwitchingTargetHandler;exports.CapsLockTargetHandler=CapsLockTargetHandler;exports.SwitchKeyboardTargetHandler=SwitchKeyboardTargetHandler;exports.ToggleCandidatePanelTargetHandler=ToggleCandidatePanelTargetHandler;exports.DismissSuggestionsTargetHandler=DismissSuggestionsTargetHandler;exports.HandwritingPadTargetHandler=HandwritingPadTargetHandler;})(window);;'use strict';(function(exports){var TargetHandlersManager=function(app){this.handlers=undefined;this.activeTargetsManager=null;this.app=app;this.promiseQueue=Promise.resolve();};TargetHandlersManager.prototype.start=function(){this.app.console.log('TargetHandlersManager.start()');this.handlers=new WeakMap();var activeTargetsManager=this.activeTargetsManager=new ActiveTargetsManager(this.app);activeTargetsManager.ontargetactivated=this._callTargetAction.bind(this,'activate',true,false);activeTargetsManager.ontargetlongpressed=this._callTargetAction.bind(this,'longPress',false,false);activeTargetsManager.ontargetmoved=this._callTargetAction.bind(this,'move',false,false);activeTargetsManager.ontargetmovedout=this._callTargetAction.bind(this,'moveOut',false,true);activeTargetsManager.ontargetmovedin=this._callTargetAction.bind(this,'moveIn',true,false);activeTargetsManager.ontargetcommitted=this._callTargetAction.bind(this,'commit',false,true);activeTargetsManager.ontargetcancelled=this._callTargetAction.bind(this,'cancel',false,true);activeTargetsManager.ontargetdoubletapped=this._callTargetAction.bind(this,'doubleTap',false,true);activeTargetsManager.onnewtargetwillactivate=this._callTargetAction.bind(this,'newTargetActivate',false,false);activeTargetsManager.start();};TargetHandlersManager.prototype.stop=function(){this.app.console.log('TargetHandlersManager.stop()');this.handlers=null;this.activeTargetsManager.stop();this.activeTargetsManager=null;};TargetHandlersManager.prototype._callTargetAction=function(action,setHandler,deleteHandler,target,press){this.app.console.log('TargetHandlersManager._callTargetAction()',action,setHandler,deleteHandler,target);this._preprocessActions(action,target);var handler;if(this.handlers.has(target)){handler=this.handlers.get(target);if(setHandler){console.warn('TargetHandlersManager: '+'calling targetHandler.'+action+'() on existing handler.');}
if(deleteHandler){this.handlers.delete(target);}}else{handler=this._createHandlerForTarget(target);if(!setHandler){console.warn('TargetHandlersManager: '+'calling targetHandler.'+action+'() on non-existing handler.');}
if(!deleteHandler){this.handlers.set(target,handler);}}
this.promiseQueue=this.promiseQueue.then(function(){handler[action](press);}).catch(function(e){console.warn('TargetHandlersManager: '+'Error occurred for '+action+': ',e);});};TargetHandlersManager.prototype._createHandlerForTarget=function(target){this.app.console.log('TargetHandlersManager._createHandlerForTarget()');var handler;if('isDismissSuggestionsButton'in target){handler=new DismissSuggestionsTargetHandler(target,this.app);}else if('selection'in target){handler=new CandidateSelectionTargetHandler(target,this.app);}else if('compositeKey'in target){handler=new CompositeTargetHandler(target,this.app);}else if(target.isHandwritingPad){handler=new HandwritingPadTargetHandler(target,this.app);}else if('keyCode'in target){switch(target.keyCode){case KeyEvent.DOM_VK_BACK_SPACE:handler=new BackspaceTargetHandler(target,this.app);break;case KeyEvent.DOM_VK_SPACE:handler=new SpaceKeyTargetHandler(target,this.app);break;case KeyEvent.DOM_VK_ALT:handler=new PageSwitchingTargetHandler(target,this.app);break;case this.app.layoutManager.KEYCODE_SWITCH_KEYBOARD:handler=new SwitchKeyboardTargetHandler(target,this.app);break;case this.app.layoutManager.KEYCODE_TOGGLE_CANDIDATE_PANEL:handler=new ToggleCandidatePanelTargetHandler(target,this.app);break;case KeyEvent.DOM_VK_CAPS_LOCK:handler=new CapsLockTargetHandler(target,this.app);break;default:handler=new DefaultTargetHandler(target,this.app);break;}}else{handler=new NullTargetHandler(target,this.app);}
return handler;};TargetHandlersManager.prototype._preprocessActions=function(action,target){switch(action){case'activate':case'moveIn':if(target.isHandwritingPad){this.activeTargetsManager.blockNewUserPress=true;this.activeTargetsManager.blockTargetMovedOut=true;}
break;case'commit':case'doubleTap':if(target.isHandwritingPad){this.activeTargetsManager.blockNewUserPress=false;this.activeTargetsManager.blockTargetMovedOut=false;}
break;}};exports.TargetHandlersManager=TargetHandlersManager;})(window);;'use strict';(function(exports){var ActiveTargetsManager=function(app){this.app=app;this.activeTargets=null;this.blockNewUserPress=false;this.blockTargetMovedOut=false;this.userPressManager=null;this.alternativesCharMenuManager=null;this.longPressTimer=undefined;this.doubleTapTimer=undefined;this.doubleTapPreviousTarget=null;};ActiveTargetsManager.prototype.ontargetactivated=null;ActiveTargetsManager.prototype.ontargetlongpressed=null;ActiveTargetsManager.prototype.ontargetmoved=null;ActiveTargetsManager.prototype.ontargetmovedout=null;ActiveTargetsManager.prototype.ontargetmovedin=null;ActiveTargetsManager.prototype.ontargetcommitted=null;ActiveTargetsManager.prototype.ontargetcancelled=null;ActiveTargetsManager.prototype.ontargetdoubletapped=null;ActiveTargetsManager.prototype.onnewtargetwillactivate=null;ActiveTargetsManager.prototype.LONG_PRESS_TIMEOUT=700;ActiveTargetsManager.prototype.DOUBLE_TAP_TIMEOUT=450;ActiveTargetsManager.prototype.start=function(){this.app.console.log('ActiveTargetsManager.start()');this.activeTargets=new Map();var userPressManager=this.userPressManager=new UserPressManager(this.app);userPressManager.onpressstart=this._handlePressStart.bind(this);userPressManager.onpressmove=this._handlePressMove.bind(this);userPressManager.onpressend=this._handlePressEnd.bind(this);userPressManager.start();this.alternativesCharMenuManager=new AlternativesCharMenuManager(this.app);this.alternativesCharMenuManager.start();};ActiveTargetsManager.prototype.stop=function(){this.app.console.log('ActiveTargetsManager.stop()');this.activeTargets=null;this.userPressManager.stop();this.userPressManager=null;this.alternativesCharMenuManager.stop();this.alternativesCharMenuManager=null;clearTimeout(this.longPressTimer);this.doubleTapTimer=undefined;this.doubleTapPreviousTarget=null;};ActiveTargetsManager.prototype.clearAllTargets=function(){this.app.console.log('ActiveTargetsManager.clearAllTargets()');if(this.activeTargets.size){console.warn('ActiveTargetsManager: clear '+
this.activeTargets.size+' active target(s).');}
this.activeTargets.forEach(function(target,id){if(typeof this.ontargetcancelled==='function'){this.ontargetcancelled(target);}},this);this.activeTargets.clear();this.alternativesCharMenuManager.hide();clearTimeout(this.longPressTimer);};ActiveTargetsManager.prototype._handlePressStart=function(press,id){this.app.console.log('ActiveTargetsManager._handlePressStart()');if(this.blockNewUserPress||this.alternativesCharMenuManager.isShown){return;}
if(typeof this.onnewtargetwillactivate==='function'){this.activeTargets.forEach(function(target,id){this.onnewtargetwillactivate(target);},this);}
var target=press.target;this.activeTargets.set(id,target);if(typeof this.ontargetactivated==='function'){this.ontargetactivated(target,press);}
clearTimeout(this.longPressTimer);if(this.activeTargets.size===1){this.longPressTimer=setTimeout(this._handleLongPress.bind(this,press,id),this.LONG_PRESS_TIMEOUT);}};ActiveTargetsManager.prototype._handlePressMove=function(press,id){this.app.console.log('ActiveTargetsManager._handlePressMove()');if(!this.activeTargets.has(id)){return;}
var target=press.target;if(this.alternativesCharMenuManager.isShown&&this.alternativesCharMenuManager.isInMenuArea(press)){target=this.alternativesCharMenuManager.getMenuTarget(press);}
if(!target){return;}
var oldTarget=this.activeTargets.get(id);if(press.moved&&('selection'in oldTarget)){this.activeTargets.delete(id);this.ontargetcancelled(oldTarget);this.alternativesCharMenuManager.hide();clearTimeout(this.longPressTimer);return;}
if(target===oldTarget){if(typeof this.ontargetmoved==='function'){this.ontargetmoved(target,press);}
return;}
if(this.blockTargetMovedOut){return;}
this.activeTargets.set(id,target);if(typeof this.ontargetmovedout==='function'){this.ontargetmovedout(oldTarget,press);}
if(typeof this.ontargetmovedin==='function'){this.ontargetmovedin(target,press);}
if(!this.alternativesCharMenuManager.isMenuTarget(target)&&!this.alternativesCharMenuManager.isInMenuArea(press)){this.alternativesCharMenuManager.hide();}
clearTimeout(this.longPressTimer);if(this.activeTargets.size===1){this.longPressTimer=setTimeout(this._handleLongPress.bind(this,press,id),this.LONG_PRESS_TIMEOUT);}};ActiveTargetsManager.prototype._handleLongPress=function(press,id){this.app.console.log('ActiveTargetsManager._handleLongPress()');if(!this.activeTargets.has(id)){return;}
var target=this.activeTargets.get(id);if(typeof this.ontargetlongpressed==='function'){this.ontargetlongpressed(target);}
this.alternativesCharMenuManager.show(target);if(this.alternativesCharMenuManager.isShown){this._handlePressMove(press,id);}};ActiveTargetsManager.prototype._handlePressEnd=function(press,id){this.app.console.log('ActiveTargetsManager._handlePressEnd()');if(!this.activeTargets.has(id)){return;}
var target=this.activeTargets.get(id);this.activeTargets.delete(id);this.alternativesCharMenuManager.hide();clearTimeout(this.longPressTimer);if(this.doubleTapTimer&&this.doubleTapPreviousTarget===target){window.clearTimeout(this.doubleTapTimer);this.doubleTapTimer=undefined;if(typeof this.ontargetdoubletapped==='function'){this.ontargetdoubletapped(target);}}else{this.doubleTapTimer=window.setTimeout(function(){this.doubleTapTimer=undefined;this.doubleTapPreviousTarget=null;}.bind(this),this.DOUBLE_TAP_TIMEOUT);this.doubleTapPreviousTarget=target;if(typeof this.ontargetcommitted==='function'){this.ontargetcommitted(target);}}};exports.ActiveTargetsManager=ActiveTargetsManager;})(window);;'use strict';(function(exports){var Keyboards={};Keyboards.defaultLayout={pages:[{},{alt:{'1':['¹'],'2':['²'],'3':['³'],'4':['⁴'],'5':['⁵'],'6':['⁶'],'7':['⁷'],'8':['⁸'],'9':['⁹'],'0':['⁰','º'],'$':['€','£','¢','¥'],'"':['“','”'],'\'':['‘','’'],'?':['¿'],'!':['¡'],'+':['-','×','÷','±']},keys:[[{value:'1'},{value:'2'},{value:'3'},{value:'4'},{value:'5'},{value:'6'},{value:'7'},{value:'8'},{value:'9'},{value:'0'}],[{value:'@'},{value:'#'},{value:'$',className:'alternate-indicator'},{value:'&'},{value:'*'},{value:'-'},{value:'_'},{value:'/'},{value:'('},{value:')'}],[{value:'Alt',ratio:1.5,keyCode:KeyboardEvent.DOM_VK_ALT,className:'page-switch-key',targetPage:2},{value:'+',supportsSwitching:{value:','}},{value:':'},{value:';'},{value:'"'},{value:'\''},{value:'!'},{value:'?'},{value:'⌫',ratio:1.5,keyCode:KeyboardEvent.DOM_VK_BACK_SPACE}],[{value:'&nbsp',ratio:8,keyCode:KeyboardEvent.DOM_VK_SPACE},{value:'↵',ratio:2,keyCode:KeyboardEvent.DOM_VK_RETURN}]]},{alt:{'+':['-','×','÷','±'],'®':['™']},keys:[[{value:'€'},{value:'£'},{value:'¢'},{value:'¥'},{value:'%'},{value:'©'},{value:'®'},{value:'·'},{value:'|'},{value:'\\'}],[{value:'~'},{value:'℃'},{value:'℉'},{value:'°'},{value:'<'},{value:'>'},{value:'['},{value:']'},{value:'{'},{value:'}'}],[{value:'Alt',ratio:1.5,keyCode:KeyboardEvent.DOM_VK_ALT,className:'page-switch-key',targetPage:1},{value:'+'},{value:'='},{value:'`'},{value:'^'},{value:'§'},{value:'«'},{value:'»'},{value:'⌫',ratio:1.5,keyCode:KeyboardEvent.DOM_VK_BACK_SPACE}],[{value:'&nbsp',ratio:8,keyCode:KeyboardEvent.DOM_VK_SPACE},{value:'↵',ratio:2,keyCode:KeyboardEvent.DOM_VK_RETURN}]]}]};Keyboards.numberLayout={width:3,keyClassName:'big-key special-key',keys:[[{value:'1'},{value:'2'},{value:'3'}],[{value:'4'},{value:'5'},{value:'6'}],[{value:'7'},{value:'8'},{value:'9'}],[{value:'.',longPressValue:','},{value:'0',longPressValue:'-'},{value:'⌫',keyCode:KeyboardEvent.DOM_VK_BACK_SPACE}]]};Keyboards.pinLayout={width:3,keyClassName:'big-key special-key bottom-symbol',keys:[[{value:'1'},{value:'2'},{value:'3'}],[{value:'4'},{value:'5'},{value:'6'}],[{value:'7'},{value:'8'},{value:'9'}],[{value:''},{value:'0'},{value:'⌫',keyCode:KeyboardEvent.DOM_VK_BACK_SPACE}]]};Keyboards.telLayout={width:3,keyClassName:'big-key special-key bottom-symbol',keys:[[{value:'1',longPressValue:'('},{value:'2',longPressValue:')'},{value:'3',longPressValue:'/'}],[{value:'4',longPressValue:'-'},{value:'5',longPressValue:'_'},{value:'6',longPressValue:','}],[{value:'7',longPressValue:':'},{value:'8',longPressValue:'.'},{value:'9',longPressValue:';'}],[{value:'*',longPressValue:'#'},{value:'0',longPressValue:'+'},{value:'⌫',keyCode:KeyboardEvent.DOM_VK_BACK_SPACE}]]};var LayoutLoader=function(app){this.app=app;};LayoutLoader.prototype.SOURCE_DIR='./js/layouts/';LayoutLoader.prototype.start=function(){this._initializedLayouts={};this._layoutsPromises={};this.initLayouts();};LayoutLoader.prototype.initLayouts=function(){var Keyboards=exports.Keyboards;exports.Keyboards={};var layoutName;for(layoutName in Keyboards){if(this._initializedLayouts[layoutName]){console.warn('LayoutLoader: '+layoutName+' is overwritten.');}
var layoutNormalizer=new LayoutNormalizer(Keyboards[layoutName]);layoutNormalizer.normalize();this._initializedLayouts[layoutName]=layoutNormalizer.normalizedLayout;if(!this._layoutsPromises[layoutName]){this._layoutsPromises[layoutName]=Promise.resolve(this._initializedLayouts[layoutName]);}}};LayoutLoader.prototype.getLayout=function(layoutName){return this._initializedLayouts[layoutName];};LayoutLoader.prototype.getLayoutAsync=function(layoutName){if(this._layoutsPromises[layoutName]){return this._layoutsPromises[layoutName];}
var p=new Promise(function(resolve,reject){var script=document.createElement('script');script.onload=function(){this.initLayouts();resolve(this._initializedLayouts[layoutName]);}.bind(this);script.onerror=function(){this._layoutsPromises[layoutName]=null;console.error('LayoutLoader: unable to load '+layoutName+'.');reject();}.bind(this);script.src=this.SOURCE_DIR+layoutName+'.js';document.body.appendChild(script);}.bind(this));this._layoutsPromises[layoutName]=p;return p;};exports.Keyboards=Keyboards;exports.LayoutLoader=LayoutLoader;})(window);;'use strict';(function(exports){var LayoutManager=function(app){this.app=app;this._typeGenericLayoutName=undefined;this.currentPage=null;this.currentPageIndex=this.PAGE_INDEX_DEFAULT;};LayoutManager.prototype.start=function(){this.loader=new LayoutLoader();this.loader.start();};LayoutManager.prototype.KEYCODE_SWITCH_KEYBOARD=-3;LayoutManager.prototype.KEYCODE_TOGGLE_CANDIDATE_PANEL=-4;LayoutManager.prototype.DEFAULT_LAYOUT_NAME='defaultLayout';LayoutManager.prototype.PAGE_INDEX_DEFAULT=0;LayoutManager.prototype.switchCurrentLayout=function(layoutName){var loaderPromise=this.loader.getLayoutAsync(layoutName);var p=loaderPromise.then(function(layout){this._typeGenericLayoutName=layoutName;this.currentPageIndex=this.PAGE_INDEX_DEFAULT;this._updateCurrentPage();}.bind(this));return p;};LayoutManager.prototype.updateLayoutPage=function(page){this.currentPageIndex=page;this._updateCurrentPage();};LayoutManager.prototype._updateCurrentPage=function(){if(!this.app.inputContext||!this._typeGenericLayoutName){console.warn('LayoutManager: '+'calling _updateCurrentPage() when there is no '+'inputContext or _typeGenericLayoutName.');this.currentPage=null;return;}
var inputMode=this.app.inputContext.inputMode;var basicInputType=this.app.getBasicInputType();var supportsSwitching=this.app.supportsSwitching();var typeSpecificLayoutName=this._typeSpecificLayoutName(basicInputType,inputMode);var layout=this.loader.getLayout(typeSpecificLayoutName||this._typeGenericLayoutName);if(!layout){console.error('LayoutManager: Can\'t load the layout.','typeSpecificLayoutName=',typeSpecificLayoutName,'typeGenericLayoutName=',this._typeGenericLayoutName,'currentPageIndex=',this.currentPageIndex);this.currentPage=null;return;}
var page=layout.pages[this.currentPageIndex];if(!page){var defaultLayout=this.loader.getLayout(this.DEFAULT_LAYOUT_NAME);page=defaultLayout.pages[this.currentPageIndex];}
if(!page){console.error('LayoutManager: Can\'t load the page from layout.','typeSpecificLayoutName=',typeSpecificLayoutName,'typeGenericLayoutName=',this._typeGenericLayoutName,'currentPageIndex=',this.currentPageIndex);this.currentPage=null;return;}
page=this.currentPage=Object.create(page);var keyNormalizer=new LayoutKeyNormalizer(page);['imEngine','autoCorrectLanguage','autoCorrectPunctuation','needsCandidatePanel'].forEach(function(prop){if(prop in layout){page[prop]=layout[prop];}});page.layoutName=typeSpecificLayoutName||this._typeGenericLayoutName;page.pageIndex=this.currentPageIndex;var spaceKeyFindResult=this._findKey(page,KeyboardEvent.DOM_VK_SPACE);var spaceKeyRowCount=spaceKeyFindResult.keyRowCount;var spaceKeyCount=spaceKeyFindResult.keyCount;if(!spaceKeyFindResult.keyFound){console.warn('LayoutManager:'+'No space key found. No special keys will be added.');return;}
page.keys=[].concat(page.keys);var copiedRows=[];var spaceKeyRow=page.keys[spaceKeyRowCount]=[].concat(page.keys[spaceKeyRowCount]);copiedRows.push(spaceKeyRowCount);var spaceKeyObject=page.keys[spaceKeyRowCount][spaceKeyCount]=Object.create(page.keys[spaceKeyRowCount][spaceKeyCount]);var enterKeyFindResult=this._findKey(page,KeyboardEvent.DOM_VK_RETURN);var enterKeyCount=enterKeyFindResult.keyCount;var enterKeyObject=page.keys[spaceKeyRowCount][enterKeyCount]=Object.create(page.keys[spaceKeyRowCount][enterKeyCount]);var pageSwitchingKeyObject=null;if(!layout.disableAlternateLayout){spaceKeyObject.ratio-=2;pageSwitchingKeyObject={keyCode:KeyboardEvent.DOM_VK_ALT,ratio:2,className:'page-switch-key'};if(this.currentPageIndex===this.PAGE_INDEX_DEFAULT){Object.assign(pageSwitchingKeyObject,{value:layout.alternateLayoutKey||'12&',ariaLabel:'alternateLayoutKey2',targetPage:1});}else{Object.assign(pageSwitchingKeyObject,{value:layout.basicLayoutKey||'ABC',ariaLabel:'basicLayoutKey2',targetPage:this.PAGE_INDEX_DEFAULT});}
pageSwitchingKeyObject=keyNormalizer.normalizeKey(pageSwitchingKeyObject,false);spaceKeyRow.splice(spaceKeyCount,0,pageSwitchingKeyObject);spaceKeyCount++;}
var needsSwitchingKey=supportsSwitching&&!layout.hidesSwitchKey;if(needsSwitchingKey){var imeSwitchKey={value:'&#x1f310;',uppercaseValue:'&#x1f310;',keyCode:this.KEYCODE_SWITCH_KEYBOARD,className:'switch-key',isSpecialKey:true};if(layout.shortLabel){imeSwitchKey.value=layout.shortLabel;imeSwitchKey.uppercaseValue=layout.shortLabel;imeSwitchKey.className+=' alternate-indicator';}
spaceKeyObject.ratio-=1;spaceKeyRow.splice(spaceKeyCount,0,imeSwitchKey);spaceKeyCount++;var r=page.keys.length,c,row,key;while(r--){row=page.keys[r];c=row.length;while(c--){key=row[c];if(key.supportsSwitching){if(copiedRows.indexOf(r)===-1){page.keys[r]=[].concat(page.keys[r]);copiedRows.push(r);}
page.keys[r][c]=Object.create(key.supportsSwitching);}}}}
if(!page.typeInsensitive){var periodKey=keyNormalizer.normalizeKey({value:'.'},!!(page.alt&&page.alt['.']));var modifyType='default';if(this.currentPageIndex===this.PAGE_INDEX_DEFAULT){switch(basicInputType){case'url':modifyType='url';break;case'email':modifyType='email';break;case'text':modifyType='default';break;case'search':modifyType='search';break;}}else{if('search'===basicInputType){modifyType='search';}else{modifyType='default';}}
switch(modifyType){case'url':spaceKeyObject.ratio-=2.0;spaceKeyRow.splice(spaceKeyCount,0,keyNormalizer.normalizeKey({value:'/'},false));spaceKeyCount++;spaceKeyRow.splice(spaceKeyCount+1,0,periodKey);break;case'email':spaceKeyObject.ratio-=2;spaceKeyRow.splice(spaceKeyCount,0,keyNormalizer.normalizeKey({value:'@'},false));spaceKeyCount++;spaceKeyRow.splice(spaceKeyCount+1,0,periodKey);break;case'search':if(enterKeyObject){enterKeyObject.className='search-icon';}
case'default':var overwrites=page.textLayoutOverwrite||{};if(overwrites[',']!==false&&(!needsSwitchingKey||page.needsCommaKey)){var commaKey;if(overwrites[',']){commaKey=overwrites[','];}else{commaKey=keyNormalizer.normalizeKey({value:','},!!(page.alt&&page.alt[',']));}
spaceKeyObject.ratio-=1;spaceKeyRow.splice(spaceKeyCount,0,commaKey);spaceKeyCount++;}
if(overwrites['.']!==false){if(overwrites['.']){periodKey=overwrites['.'];}
spaceKeyObject.ratio-=1;spaceKeyRow.splice(spaceKeyCount+1,0,periodKey);}
break;}}
var keyCount=page.width?page.width:10;if(!layout.disableAlternateLayout){if(spaceKeyCount==3&&keyCount==10){if(enterKeyObject){enterKeyObject.ratio=2.5;}
pageSwitchingKeyObject.ratio=1.5;}}};LayoutManager.prototype._typeSpecificLayoutName=function(basicInputType,inputMode){switch(basicInputType){case'tel':return'telLayout';case'number':switch(inputMode){case'digit':return'pinLayout';default:return'numberLayout';}
break;case'text':switch(inputMode){case'digit':return'pinLayout';case'numeric':return'numberLayout';case'-moz-sms':var smsLayoutName=this._typeGenericLayoutName+'-sms';if(this.loader.getLayout(smsLayoutName)){return smsLayoutName;}}
break;}
return'';};LayoutManager.prototype._findKey=function(page,keyCode){var r=page.keys.length,c,row,key;while(r--){row=page.keys[r];c=row.length;while(c--){key=row[c];if(key.keyCode==keyCode){return{keyFound:true,keyRowCount:r,keyCount:c};}}}
return{keyFound:false,keyRowCount:-1,keyCount:-1};};exports.SWITCH_KEYBOARD=LayoutManager.prototype.KEYCODE_SWITCH_KEYBOARD;exports.TOGGLE_CANDIDATE_PANEL=LayoutManager.prototype.KEYCODE_TOGGLE_CANDIDATE_PANEL;exports.PAGE_INDEX_DEFAULT=LayoutManager.prototype.PAGE_INDEX_DEFAULT;exports.LayoutManager=LayoutManager;})(window);;'use strict';(function(exports){var LayoutKeyNormalizer=function(page){this._page=page;};LayoutKeyNormalizer.prototype._isSpecialKey=function(key){var SPECIAL_CODES=[KeyEvent.DOM_VK_BACK_SPACE,KeyEvent.DOM_VK_CAPS_LOCK,KeyEvent.DOM_VK_RETURN,KeyEvent.DOM_VK_ALT];var hasSpecialCode=key.keyCode&&(SPECIAL_CODES.indexOf(key.keyCode)!==-1);return hasSpecialCode||key.keyCode<=0;};LayoutKeyNormalizer.prototype._getUpperCaseValue=function(key){if(KeyEvent.DOM_VK_SPACE===key.keyCode||this._isSpecialKey(key)||key.compositeKey){return key.value;}
var upperCase=this._page.upperCase||{};return upperCase[key.value]||key.value.toUpperCase();};LayoutKeyNormalizer.prototype.normalizeKey=function(key,showAlternatesIndicator){var keyChar=key.value;var upperCaseKeyChar=this._getUpperCaseValue(key);var code=key.keyCode||keyChar.charCodeAt(0);var upperCode=key.keyCode||upperCaseKeyChar.charCodeAt(0);key.keyCode=code;key.keyCodeUpper=upperCode;key.lowercaseValue=keyChar;key.uppercaseValue=upperCaseKeyChar;key.isSpecialKey=this._isSpecialKey(key);if(showAlternatesIndicator){key.className='alternate-indicator';}
if(key.longPressValue){var longPressKeyCode=key.longPressKeyCode||key.longPressValue.charCodeAt(0);key.longPressKeyCode=longPressKeyCode;}
if(key.supportsSwitching){this.normalizeKey(key.supportsSwitching,false);}
if(KeyboardEvent.DOM_VK_ALT===code&&!('targetPage'in key)){console.error('LayoutNormalizer: no targetPage for switching key.');}
return key;};var LayoutNormalizer=function(layout){this._layout=layout;this._normalizedLayout=null;};LayoutNormalizer.prototype._hasAlternativeKeys=function(key,page){var alt=page.alt||{};return key in alt;};LayoutNormalizer.prototype._normalizePageKeys=function(page){var keyRows=page.keys||[];var keyNormalizer=new LayoutKeyNormalizer(page);page.keys=keyRows.map(function(keyRow){return keyRow.map(function(key){return keyNormalizer.normalizeKey(key,false);},this);},this);var overwrites=page.textLayoutOverwrite||{};page.textLayoutOverwrite=Object.keys(overwrites).reduce(function(result,overwrittenKey){if(false===overwrites[overwrittenKey]){result[overwrittenKey]=false;}else{var hasAlternativeKeys=this._hasAlternativeKeys(overwrites[overwrittenKey],page);result[overwrittenKey]=keyNormalizer.normalizeKey({value:overwrites[overwrittenKey]},hasAlternativeKeys);}
return result;}.bind(this),{});};LayoutNormalizer.prototype._normalizePageAltKeys=function(page){var alt=page.alt=page.alt||{};var upperCase=page.upperCase=page.upperCase||{};var altKeys=Object.keys(alt);altKeys.forEach(function(key){var alternatives=alt[key];if(!Array.isArray(alternatives)){if(alternatives.indexOf(' ')!==-1){alternatives=alternatives.split(' ');if(alternatives.length===2&&alternatives[1]===''){alternatives.pop();}}else{alternatives=alternatives.split('');}}
alt[key]=alternatives;var upperCaseKey=upperCase[key]||key.toUpperCase();if(!alt[upperCaseKey]){var needDifferentUpperCaseLockedAlternatives=false;alt[upperCaseKey]=alternatives.map(function(key){if(key.length===1){return key.toUpperCase();}
needDifferentUpperCaseLockedAlternatives=needDifferentUpperCaseLockedAlternatives||(key.substr(1).toUpperCase()!==key.substr(1));return key[0].toUpperCase()+key.substr(1);});if(needDifferentUpperCaseLockedAlternatives){alt[upperCaseKey].upperCaseLocked=alternatives.map(function(key){return key.toUpperCase();});}}},this);};LayoutNormalizer.prototype.normalize=function(){var pages;if('pages'in this._layout){pages=this._layout.pages;}else{pages=this._layout.pages=[];}
if(!pages[0]){pages[0]={};['alt','keys','upperCase','width','keyClassName','typeInsensitive','textLayoutOverwrite','needsCommaKey','secondLayout','specificCssRule'].forEach(function(prop){if(this._layout[prop]){pages[0][prop]=this._layout[prop];delete this._layout[prop];}},this);}
pages.forEach(function(page){this._normalizePageKeys(page);this._normalizePageAltKeys(page);},this);this._normalizedLayout=this._layout;};Object.defineProperty(LayoutNormalizer.prototype,'normalizedLayout',{configurable:true,get:function ln_getNormalizedLayout(){if(!this._normalizedLayout){throw Error('Tried to get normalized layout before calling normalize()');}
return this._normalizedLayout;}});exports.LayoutKeyNormalizer=LayoutKeyNormalizer;exports.LayoutNormalizer=LayoutNormalizer;})(window);;'use strict';var IMERender=(function(){var ime,activeIme;var alternativesCharMenu=null;var _menuKey=null;var renderingManager=null;var viewMap=null;var targetObjDomMap=null;var layoutWidth=10;var numberOfCandidatesPerRow=8;var candidateUnitWidth;var inputMethodName;var cachedWindowHeight=-1;var cachedWindowWidth=-1;var pageViews=null;var currentPageView=null;window.addEventListener('resize',function kr_onresize(){cachedWindowHeight=window.innerHeight;cachedWindowWidth=window.innerWidth;});var init=function kr_init(layoutRenderingManager){ime=document.getElementById('keyboard');renderingManager=layoutRenderingManager;cachedWindowHeight=window.innerHeight;cachedWindowWidth=window.innerWidth;targetObjDomMap=new WeakMap();viewMap=new WeakMap();pageViews=new Map();};var setInputMethodName=function(name){var candidatePanel=activeIme&&activeIme.querySelector('.keyboard-candidate-panel');if(candidatePanel){if(inputMethodName)
candidatePanel.classList.remove(inputMethodName);candidatePanel.classList.add(name);}
var togglebutton=activeIme&&activeIme.querySelector('.keyboard-candidate-panel-toggle-button');if(togglebutton){if(inputMethodName)
togglebutton.classList.remove(inputMethodName);togglebutton.classList.add(name);}
inputMethodName=name;};var setUpperCaseLock=function kr_setUpperCaseLock(state){if(!currentPageView){console.error('No current page view!');return;}
currentPageView.setUpperCaseLock(state);};var draw=function kr_draw(layout,flags,callback){flags=flags||{};var supportsSwitching='mozInputMethod'in navigator?navigator.mozInputMethod.mgmt.supportsSwitching():false;var pageId=[layout.layoutName,layout.pageIndex,(''+flags.inputType).substr(0,1),(''+flags.showCandidatePanel).substr(0,1),supportsSwitching].join('-');var pageView=pageViews.get(pageId);var container=null;if(pageView){container=pageView.element;}else{var options={classNames:['keyboard-type-container'],totalWidth:ime.clientWidth};pageView=new LayoutPageView(layout,options,IMERender);pageViews.set(pageId,pageView);pageView.render();ime.appendChild(pageView.element);container=pageView.element;if(flags.showCandidatePanel){container.insertBefore(candidatePanelToggleButtonCode(),container.firstChild);container.insertBefore(candidatePanelCode(),container.firstChild);showCandidates([]);container.classList.add('candidate-panel');}else{container.classList.remove('candidate-panel');}}
pageView.setUpperCaseLock({isUpperCase:flags.uppercase,isUpperCaseLocked:false});if(currentPageView!==pageView){if(currentPageView){currentPageView.hide();}
pageView.show();currentPageView=pageView;activeIme=container;resizeUI(layout,callback);}
else if((ime.classList.contains('landscape')&&screenInPortraitMode())||(ime.classList.contains('portrait')&&!screenInPortraitMode())){resizeUI(layout,callback);}
else{if(callback){window.requestAnimationFrame(callback);}}};var drawHandwritingPad=function kr_drawHandwritingPad(press,start,strokeWidth){var handwritingPadView=viewMap.get(press.target);return handwritingPadView.drawHandwritingPad(press,start,strokeWidth);};var clearHandwritingPad=function kr_clearHandwritingPad(target){var handwritingPadView=viewMap.get(target);return handwritingPadView.clearHandwritingPad();};var highlightKey=function kr_updateKeyHighlight(target){var keyElement=targetObjDomMap.get(target);if(keyElement){keyElement.classList.add('highlighted');return;}
if(!currentPageView){console.error('No current page view!');return;}
currentPageView.highlightKey(target);};var unHighlightKey=function kr_unHighlightKey(target){var keyElement=targetObjDomMap.get(target);if(keyElement){keyElement.classList.remove('highlighted');return;}
if(!currentPageView){console.error('No current page view!');return;}
currentPageView.unHighlightKey(target);};var toggleCandidatePanel=function(expand){var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');candidatePanel.scrollTop=candidatePanel.scrollLeft=0;toggleCandidatePanelWithoutResetScroll(expand);};var toggleCandidatePanelWithoutResetScroll=function(expand){if(expand){ime.classList.remove('candidate-panel');ime.classList.add('full-candidate-panel');}else{ime.classList.remove('full-candidate-panel');ime.classList.add('candidate-panel');}};var isFullCandidataPanelShown=function(){return ime.classList.contains('full-candidate-panel');};var showCandidates=function(candidates){if(!activeIme)
return;if(inputMethodName=='vietnamese'&&candidates.length){numberOfCandidatesPerRow=candidates.length;candidateUnitWidth=Math.floor(ime.clientWidth/numberOfCandidatesPerRow);}
var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');var candidatePanelToggleButton=activeIme.querySelector('.keyboard-candidate-panel-toggle-button');if(candidatePanel){candidatePanel.dataset.candidateIndicator=0;var docFragment=document.createDocumentFragment();if(inputMethodName=='latin'){var dismissButton=candidatePanel.querySelector('.dismiss-suggestions-button');dismissButton.classList.add('hide');if(candidates.length>0){dismissButton.classList.remove('hide');}
var suggestContainer=candidatePanel.querySelector('.suggestions-container');suggestContainer.innerHTML='';for(var i=0;i<4;i++){suggestContainer.classList.remove('has'+i);}
suggestContainer.classList.add('has'+candidates.length);candidates.forEach(function buildCandidateEntry(candidate){if(!candidate)return;var div=document.createElement('div');div.setAttribute('role','presentation');suggestContainer.appendChild(div);var text,data,correction=false;if(typeof candidate==='string'){if(candidate[0]==='*'){candidate=candidate.substring(1);correction=true;}
data=text=candidate;}
else{text=candidate[0];data=candidate[1];}
var span=fitText(div,text);span.setAttribute('role','option');setDomElemTargetObject(span,{selection:true,text:span.textContent,data:data});span.dataset.data=data;if(correction)
span.classList.add('autocorrect');function fitText(container,text){container.textContent='';if(!text)
return null;var span=document.createElement('span');span.textContent=text;container.appendChild(span);var limit=.6;var scale=IMERender.getScale(span,candidates.length);if(scale<limit){var charactersReplaced=text.length%2;while(scale<limit&&charactersReplaced<text.length-2){charactersReplaced+=2;var halflen=(text.length-charactersReplaced)/2;span.textContent=text.substring(0,halflen)+'…'+
text.substring(text.length-halflen);scale=IMERender.getScale(span,candidates.length);}}
span.style.display='inline-block';if(scale<1){span.style.width=(100/scale)+'%';span.style.transformOrigin='left';span.style.transform='scale('+scale+')';}
else{span.style.width='100%';}
return span;}});}else{candidatePanel.innerHTML='';candidatePanelToggleButton.style.display='none';toggleCandidatePanelWithoutResetScroll(false);docFragment=candidatesFragmentCode(1,candidates,true);candidatePanel.appendChild(docFragment);}}};var showMoreCandidates=function(rowLimit,candidates){if(!rowLimit)rowLimit=-1;if(!candidates)return;activeIme.querySelector('.keyboard-candidate-panel').appendChild(candidatesFragmentCode(rowLimit,candidates));};var getNumberOfCandidatesPerRow=function(){return numberOfCandidatesPerRow;};var candidatesFragmentCode=function(rowLimit,candidates,indentFirstRow){var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');var candidatePanelToggleButton=activeIme.querySelector('.keyboard-candidate-panel-toggle-button');var docFragment=document.createDocumentFragment();if(candidates.length==0){candidatePanel.dataset.rowCount=0;return docFragment;}
var rowDiv=document.createElement('div');rowDiv.classList.add('candidate-row');if(indentFirstRow){rowDiv.classList.add('candidate-row-first');}
var nowUnit=0;var rowCount=0;if(rowLimit<0){rowLimit=Number.Infinity;}
var candidatesLength=candidates.length;for(var i=0;i<candidatesLength;i++){var cand,data;if(typeof candidates[i]=='string'){cand=data=candidates[i];}else{cand=candidates[i][0];data=candidates[i][1];}
var unit=(cand.length>>1)+1;if(inputMethodName=='vietnamese'){unit=1;}
var span=document.createElement('span');span.textContent=cand;setDomElemTargetObject(span,{selection:true,text:span.textContent,data:data});span.style.width=(unit*candidateUnitWidth-2)+'px';span.dataset.data=data;nowUnit+=unit;var needBreak=false;if(rowCount==0&&indentFirstRow&&nowUnit==numberOfCandidatesPerRow&&i!=candidatesLength-1){needBreak=true;}
if(nowUnit>numberOfCandidatesPerRow||needBreak){if(rowCount==0){candidatePanelToggleButton.style.display='block';}
if(rowCount>=rowLimit-1){break;}
docFragment.appendChild(rowDiv);rowCount++;rowDiv=document.createElement('div');rowDiv.classList.add('candidate-row');nowUnit=unit;}
rowDiv.appendChild(span);}
if(i!=candidatesLength){candidatePanel.dataset.truncated=true;}else{delete candidatePanel.dataset.truncated;}
candidatePanel.dataset.rowCount=rowCount+1;candidatePanel.dataset.candidateIndicator=parseInt(candidatePanel.dataset.candidateIndicator)+i;docFragment.appendChild(rowDiv);rowDiv=null;return docFragment;};var showAlternativesCharMenu=function(key,altChars){var options={keyWidth:(cachedWindowWidth/layoutWidth)|0,screenInPortraitMode:screenInPortraitMode};alternativesCharMenu=new AlternativesCharMenuView(activeIme,altChars,options,IMERender);var keyElement=viewMap.get(key).element;alternativesCharMenu.show(keyElement);_menuKey=key;return alternativesCharMenu;};var hideAlternativesCharMenu=function km_hideAlternativesCharMenu(){alternativesCharMenu.hide();};var _keyArray=[];var resizeUI=function(layout,callback){var changeScale;if(screenInPortraitMode()){changeScale=cachedWindowWidth/32;document.documentElement.style.fontSize=changeScale+'px';ime.classList.remove('landscape');ime.classList.add('portrait');}else{changeScale=cachedWindowWidth/64;document.documentElement.style.fontSize=changeScale+'px';ime.classList.remove('portrait');ime.classList.add('landscape');}
if(!layout||!activeIme){return;}
currentPageView.resize(cachedWindowWidth);candidateUnitWidth=Math.floor(ime.clientWidth/numberOfCandidatesPerRow);[].forEach.call(ime.querySelectorAll('.candidate-row span'),function(item){var unit=(item.textContent.length>>1)+1;if(inputMethodName=='vietnamese'){unit=1;}
item.style.width=(unit*candidateUnitWidth-2)+'px';});window.requestAnimationFrame(function(){_keyArray=currentPageView.getVisualData();if(callback){callback();}});};var candidatePanelCode=function(){var candidatePanel=document.createElement('div');candidatePanel.setAttribute('role','group');candidatePanel.dataset.l10nId='wordSuggestions2';candidatePanel.classList.add('keyboard-candidate-panel');if(inputMethodName)
candidatePanel.classList.add(inputMethodName);var dismissButton=document.createElement('div');dismissButton.classList.add('dismiss-suggestions-button');dismissButton.classList.add('hide');dismissButton.setAttribute('role','button');dismissButton.dataset.l10nId='dismiss2';candidatePanel.appendChild(dismissButton);var suggestionContainer=document.createElement('div');suggestionContainer.classList.add('suggestions-container');suggestionContainer.setAttribute('role','listbox');candidatePanel.appendChild(suggestionContainer);setDomElemTargetObject(dismissButton,{isDismissSuggestionsButton:true});return candidatePanel;};var candidatePanelToggleButtonCode=function(){var toggleButton=document.createElement('span');toggleButton.classList.add('keyboard-candidate-panel-toggle-button');var KEYCODE_TOGGLE_CANDIDATE_PANEL=-4;setDomElemTargetObject(toggleButton,{keyCode:KEYCODE_TOGGLE_CANDIDATE_PANEL});if(inputMethodName){toggleButton.classList.add(inputMethodName);}
toggleButton.style.width=Math.floor(ime.clientWidth/numberOfCandidatesPerRow)+'px';return toggleButton;};var getWidth=function getWidth(){if(!activeIme)
return 0;return cachedWindowWidth;};var getHeight=function getHeight(){if(!activeIme)
return 0;var scale=screenInPortraitMode()?cachedWindowWidth/32:cachedWindowWidth/64;var height=(activeIme.querySelectorAll('.keyboard-row').length*(5.1*scale));if(activeIme.classList.contains('candidate-panel')){if(activeIme.querySelector('.keyboard-candidate-panel').classList.contains('latin')){height+=(3.1*scale);}
else{height+=(3.2*scale);}}
return height|0;};var getKeyArray=function getKeyArray(){return _keyArray;};var getKeyWidth=function getKeyWidth(){if(!activeIme)
return 0;return Math.ceil(ime.clientWidth/layoutWidth);};var getKeyHeight=function getKeyHeight(){if(!activeIme)
return 0;var rows=activeIme.querySelectorAll('.keyboard-row');var rowCount=rows.length||3;var candidatePanel=activeIme.querySelector('.keyboard-candidate-panel');var candidatePanelHeight=candidatePanel?candidatePanel.clientHeight:0;return Math.ceil((ime.clientHeight-candidatePanelHeight)/rowCount);};var setDomElemTargetObject=function setDomElemTargetObject(elem,obj){var objRef=Object.freeze(Object.create(obj));renderingManager.domObjectMap.set(elem,objRef);targetObjDomMap.set(objRef,elem);};var registerView=function registerView(target,view){renderingManager.domObjectMap.set(view.element,target);viewMap.set(target,view);};var scaleContext=null;var getScale=function(element,noOfSuggestions){if(!scaleContext){scaleContext=document.createElement('canvas').getContext('2d',{willReadFrequently:true});scaleContext.font='2rem sans-serif';}
var elementWidth=scaleContext.measureText(element.textContent).width;var cw=(cachedWindowWidth-36)/noOfSuggestions|0;cw-=6;var s=cw/elementWidth;if(s>=1)
return 1;if(s>=.8)
return.8;if(s>=.7)
return.7;if(s>=.65)
return.65;if(s>=.6)
return.6;return s;};var screenInPortraitMode=function(){return cachedWindowWidth<=cachedWindowHeight;};var _t={};function startTime(key){}
function endTime(key){}
return{'init':init,'setInputMethodName':setInputMethodName,'draw':draw,'drawHandwritingPad':drawHandwritingPad,'clearHandwritingPad':clearHandwritingPad,get ime(){return ime;},'highlightKey':highlightKey,'unHighlightKey':unHighlightKey,'showAlternativesCharMenu':showAlternativesCharMenu,'hideAlternativesCharMenu':hideAlternativesCharMenu,'setUpperCaseLock':setUpperCaseLock,'resizeUI':resizeUI,'showCandidates':showCandidates,'getWidth':getWidth,'getHeight':getHeight,'getKeyArray':getKeyArray,'getKeyWidth':getKeyWidth,'getKeyHeight':getKeyHeight,'getScale':getScale,'setDomElemTargetObject':setDomElemTargetObject,'showMoreCandidates':showMoreCandidates,'toggleCandidatePanel':toggleCandidatePanel,'isFullCandidataPanelShown':isFullCandidataPanelShown,'getNumberOfCandidatesPerRow':getNumberOfCandidatesPerRow,'candidatePanelCode':candidatePanelCode,'registerView':registerView,'getView':function getView(target){return viewMap.get(target);},get activeIme(){return activeIme;},set activeIme(v){activeIme=v;},get candidatePanel(){return activeIme&&activeIme.querySelector('.keyboard-candidate-panel');},setCachedWindowSize:function(width,height){cachedWindowWidth=width;cachedWindowHeight=height;}};})();;'use strict';(function(exports){function AlternativesCharMenuView(rootElement,altChars,options,viewManager){this.rootElement=rootElement;this.altChars=altChars;this.keyWidth=options.keyWidth;this.screenInPortraitMode=options.screenInPortraitMode;this.menu=null;this._rowCount=0;this.altKeyTargets=[];this.viewManager=viewManager;}
exports.AlternativesCharMenuView=AlternativesCharMenuView;AlternativesCharMenuView.prototype.MENU_LINE_HEIGHT=6;AlternativesCharMenuView.prototype.show=function(keyElem){var content=document.createDocumentFragment();var cachedWindowWidth=window.innerWidth;var left=(cachedWindowWidth/2>keyElem.offsetLeft);this._direction=left?'left':'right';var menu=document.createElement('div');menu.id='keyboard-accent-char-menu';if(!left){menu.classList.add('kbr-menu-left');}
var widthRatio=0;if(this.altChars.length>5){widthRatio=Math.ceil(this.altChars.length/2);menu.style.top=(keyElem.offsetTop-this.getLineHeight()*2)+'px';this._columnCount=widthRatio;this._rowCount=2;menu.style.width=this.keyWidth*widthRatio+'px';menu.classList.add('multi-row');}else{menu.style.top=(keyElem.offsetTop-this.getLineHeight()+4)+'px';this._rowCount=1;this._columnCount=this.altChars.length;}
if(left){var keyRight=keyElem.offsetLeft+keyElem.offsetWidth;var posLeft=keyRight-this.keyWidth;menu.style.left=posLeft+'px';if(posLeft===0){menu.classList.add('left-edge');}}else{var menuRight=keyElem.offsetLeft+this.keyWidth;var posRight=cachedWindowWidth-menuRight;menu.style.right=posRight+'px';if(posRight===0){menu.classList.add('right-edge');}}
this.altChars.forEach(function(alt,index){var altKeyTarget=alt.length==1?{value:alt,keyCode:alt.charCodeAt(0),keyCodeUpper:alt.toUpperCase().charCodeAt(0)}:{'compositeKey':alt,value:alt};var width=this.keyWidth;if(alt.length>1&&this._rowCount===1){width=this._getCharWidth(alt)+10;width=Math.max(width,this.keyWidth);}
var altKey=new KeyView(altKeyTarget,{keyWidth:width},this.viewManager);altKey.render();content.appendChild(altKey.element);this.altKeyTargets.push(altKeyTarget);}.bind(this));menu.appendChild(content);this.rootElement.appendChild(menu);this.menu=menu;};AlternativesCharMenuView.prototype.hide=function(){this.rootElement.removeChild(this.menu);};AlternativesCharMenuView.prototype.getRowCount=function(){return this._rowCount;};AlternativesCharMenuView.prototype.getMenuContainer=function(){return this.menu;};AlternativesCharMenuView.prototype.getBoundingClientRect=function(){return this.menu.getBoundingClientRect();};AlternativesCharMenuView.prototype.getLineHeight=function(){var scale=parseFloat(document.documentElement.style.fontSize);return this.MENU_LINE_HEIGHT*scale;};AlternativesCharMenuView.prototype._getCharWidth=function(textContent){var scaleContext=document.createElement('canvas').getContext('2d',{willReadFrequently:true});var fontSize=this.screenInPortraitMode()?'2.4rem':'2.8rem';scaleContext.font=fontSize+' sans-serif';return scaleContext.measureText(textContent).width;};AlternativesCharMenuView.prototype.getMenuTarget=function(x,y){var menuRect=this.getBoundingClientRect();if(x<=menuRect.left){x=menuRect.left+1;}else if(x>=menuRect.right){x=menuRect.right-1;}
var xOffset=0;if(this._direction==='left'){xOffset=x-menuRect.left;}else{xOffset=menuRect.right-x;}
y=y-this.getLineHeight();if(y<=menuRect.top){y=menuRect.top+1;}
var columnCount=this._columnCount;var targetIndex=Math.floor(xOffset/menuRect.width*columnCount);if((menuRect.bottom-y)>this.getLineHeight()){targetIndex+=columnCount;}
if(targetIndex>=this.altKeyTargets.length){targetIndex=this.altKeyTargets.length-1;}
return this.altKeyTargets[targetIndex];};AlternativesCharMenuView.prototype.isMenuTarget=function(target){return(this.altKeyTargets.indexOf(target)!==-1);};})(window);;'use strict';(function(exports){var HandwritingPadView=function(target,options,viewManager){this.target=target;this.options=options;this.viewManager=viewManager;this.element=null;this.lastX=this.lastY=0;};HandwritingPadView.prototype.render=function render(){this.element=document.createElement('canvas');this.element.className='handwriting-pad';if(this.viewManager){this.viewManager.registerView(this.target,this);}};HandwritingPadView.prototype.drawHandwritingPad=function drawHandwritingPad(press,start,strokeWidth){var ctx=this.element.getContext('2d');ctx.strokeStyle='#df4b26';ctx.lineJoin='round';ctx.lineWidth=strokeWidth;var point=this._getPressPoint(press);ctx.beginPath();if(start){this.lastX=point.posX-1;this.lastY=point.posY;}
ctx.moveTo(this.lastX,this.lastY);ctx.lineTo(point.posX,point.posY);ctx.closePath();ctx.stroke();this.lastX=point.posX;this.lastY=point.posY;return point;};HandwritingPadView.prototype.clearHandwritingPad=function clearHandwritingPad(){var ctx=this.element.getContext('2d');var width=this.element.width;var height=this.element.height;ctx.clearRect(0,0,width,height);};HandwritingPadView.prototype._getPressPoint=function getPressPoint(press){var canvasRect=this.element.getBoundingClientRect();var posTop=canvasRect.top-document.body.clientTop;var posLeft=canvasRect.left-document.body.clientLeft;var posX=press.clientX-posLeft;var posY=press.clientY-posTop;posX*=window.devicePixelRatio;posY*=window.devicePixelRatio;return{posX:posX,posY:posY};};HandwritingPadView.prototype.resize=function resize(width,height){var canvas=this.element;canvas.width=width*window.devicePixelRatio;canvas.style.width=width+'px';canvas.height=height*window.devicePixelRatio;canvas.style.height=height+'px';};exports.HandwritingPadView=HandwritingPadView;})(window);;'use strict';(function(exports){function KeyView(target,options,viewManager){this.target=target;this.attributeList=options.attributeList||[];this.classNames=['keyboard-key'];if(target.isSpecialKey){this.classNames.push('special-key');}else{this.attributeList.push({key:'role',value:'key'});if(options.classNames){this.classNames=this.classNames.concat(options.classNames);}}
if(target.className){this.classNames=this.classNames.concat(target.className.split(' '));}
if(target.disabled){this.attributeList.push({key:'disabled',value:'true'});}
var ARIA_LABELS=this.ARIA_LABELS||{};if(target.ariaLabel||ARIA_LABELS[target.value]){this.attributeList.push({key:'data-l10n-id',value:target.ariaLabel||ARIA_LABELS[target.value]});}else{this.attributeList.push({key:'aria-label',value:target.ariaLabel||target.value});}
this.outputChar=(options.outputChar)||target.value;this.altOutputChar=options.altOutputChar;this.innerRatio=options.innerRatio;this.outerRatio=options.outerRatio;this.width=options.keyWidth;this.viewManager=viewManager;}
KeyView.prototype.ARIA_LABELS={'⇪':'upperCaseKey2','⌫':'backSpaceKey2','&nbsp':'spaceKey2','↵':'returnKey2','.':'periodKey2',',':'commaKey2',':':'colonKey2',';':'semicolonKey2','?':'questionMarkKey2','!':'exclamationPointKey2','(':'leftBracketKey2',')':'rightBracketKey2','"':'doubleQuoteKey2','«':'leftDoubleAngleQuoteKey2','»':'rightDoubleAngleQuoteKey2'};KeyView.prototype.render=function render(){var contentNode=document.createElement('button');if(this.classNames){contentNode.classList.add.apply(contentNode.classList,this.classNames);}
if(this.outerRatio!=1){contentNode.style.flex=this.outerRatio;}
if(this.width){contentNode.style.width=this.width+'px';}
if(this.attributeList){this.attributeList.forEach(function(attribute){contentNode.setAttribute(attribute.key,attribute.value);});}
var vWrapperNode=document.createElement('span');vWrapperNode.className='visual-wrapper';if(this.outerRatio!==this.innerRatio){vWrapperNode.style.width=100*this.innerRatio/this.outerRatio+'%';}
var labelNode=document.createElement('span');labelNode.innerHTML=this.outputChar;labelNode.className='key-element';labelNode.dataset.label=this.outputChar;vWrapperNode.appendChild(labelNode);if(this.altOutputChar){labelNode=document.createElement('span');labelNode.innerHTML=this.altOutputChar;labelNode.className='key-element lowercase';labelNode.dataset.label=this.altOutputChar;vWrapperNode.appendChild(labelNode);}
labelNode=document.createElement('span');labelNode.innerHTML=this.outputChar;labelNode.className='uppercase popup';vWrapperNode.appendChild(labelNode);labelNode=document.createElement('span');labelNode.innerHTML=this.target.lowercaseValue;labelNode.className='lowercase popup';vWrapperNode.appendChild(labelNode);if(this.target.longPressValue){var altNoteNode=document.createElement('div');altNoteNode.className='alt-note';altNoteNode.textContent=this.target.longPressValue;vWrapperNode.appendChild(altNoteNode);}
contentNode.appendChild(vWrapperNode);contentNode.dataset.keycode=this.target.keyCode;contentNode.dataset.keycodeUpper=this.target.keyCodeUpper;if('targetPage'in this.target){contentNode.dataset.targetPage=this.target.targetPage;}
this.element=contentNode;if(this.viewManager){this.viewManager.registerView(this.target,this);}};KeyView.prototype.highlight=function highlight(options){options=options||{};if(options.upperCase){this.element.classList.add('uppercase-popup');}else{this.element.classList.add('lowercase-popup');}
this.element.classList.add('highlighted');};KeyView.prototype.unHighlight=function unHighlight(){this.element.classList.remove('highlighted');this.element.classList.remove('uppercase-popup');this.element.classList.remove('lowercase-popup');};exports.KeyView=KeyView;})(window);;'use strict';(function(exports){function LayoutPageView(layout,options,viewManager){this.layout=layout;this.options=options;this.viewManager=viewManager;this.isUpperCase=undefined;this.rows=new Map();}
LayoutPageView.prototype.render=function render(){var layout=this.layout;var content=document.createDocumentFragment();var container=document.createElement('div');if(this.options.classNames){container.classList.add.apply(container.classList,this.options.classNames);}
if(layout.specificCssRule){container.classList.add(layout.layoutName);}
if('handwritingPadOptions'in layout){var target={isHandwritingPad:true};var handwritingPadView=new HandwritingPadView(target,null,this.viewManager);handwritingPadView.render();content.appendChild(handwritingPadView.element);this.handwritingPadView=handwritingPadView;}
layout.keys.forEach((function buildKeyboardRow(row,nrow){var kbRow=document.createElement('div');var rowLayoutWidth=0;kbRow.classList.add('keyboard-row');kbRow.classList.add('row'+nrow);if(nrow===layout.keys.length-1){kbRow.classList.add('keyboard-last-row');}
var keyCount=0;var keyMap=new Map();row.forEach(function calcRowRatio(key,keyIndex){var ratio=key.ratio||1;rowLayoutWidth+=ratio;});if('handwritingPadOptions'in layout&&nrow<layout.handwritingPadOptions.rowspan){rowLayoutWidth+=layout.handwritingPadOptions.ratio;}
row.forEach((function buildKeyboardColumns(key,keyIndex){var ratio=key.ratio||1;var target=Object.freeze(Object.create(key));var options={classNames:[],outputChar:key.uppercaseValue,outerRatio:ratio,innerRatio:ratio};if(layout.keyClassName){options.classNames=options.classNames.concat(layout.keyClassName.split(' '));}
var layoutWidth=layout.width||10;if(layoutWidth!=rowLayoutWidth&&(keyIndex===0||keyIndex===row.length-1)){options.outerRatio=ratio+((layoutWidth-rowLayoutWidth)/2);}
if(layout.secondLayout){options.altOutputChar=key.value;}
var keyView=new KeyView(target,options,this.viewManager);keyView.render();kbRow.appendChild(keyView.element);keyMap.set(keyCount,keyView);keyCount++;}.bind(this)));this.rows.set(nrow,{element:kbRow,keys:keyMap});content.appendChild(kbRow);}).bind(this));if(!layout.secondLayout){container.classList.add('uppercase-only');}
container.appendChild(content);this.element=container;};LayoutPageView.prototype.setUpperCaseLock=function setUpperCaseLock(state){this.isUpperCase=(state.isUpperCase||state.isUpperCaseLocked);var container=this.element;container.classList.toggle('lowercase',!this.isUpperCase);var capsLockKey=container.querySelector('button:not([disabled])'+'[data-keycode="'+KeyboardEvent.DOM_VK_CAPS_LOCK+'"]');if(!capsLockKey){return;}
if(state.isUpperCaseLocked){capsLockKey.classList.remove('kbr-key-active');capsLockKey.classList.add('kbr-key-hold');}else if(state.isUpperCase){capsLockKey.classList.add('kbr-key-active');capsLockKey.classList.remove('kbr-key-hold');}else{capsLockKey.classList.remove('kbr-key-active');capsLockKey.classList.remove('kbr-key-hold');}
capsLockKey.setAttribute('aria-pressed',state.isUpperCaseLocked||state.isUpperCase);};LayoutPageView.prototype.hide=function hide(){delete this.element.dataset.active;};LayoutPageView.prototype.show=function show(){this.element.dataset.active=true;};LayoutPageView.prototype.highlightKey=function highlightKey(target){var keyView=this.viewManager.getView(target);keyView.highlight({upperCase:this.isUpperCase});};LayoutPageView.prototype.unHighlightKey=function unHighlightKey(target){var keyView=this.viewManager.getView(target);keyView.unHighlight();};LayoutPageView.prototype.resize=function resize(totalWidth){if(this.handwritingPadView){var placeHolderWidth=totalWidth/(this.layout.width||10);var width=Math.floor(placeHolderWidth*this.layout.handwritingPadOptions.ratio);var height=this.rows.get(0).element.clientHeight*this.layout.handwritingPadOptions.rowspan;this.handwritingPadView.resize(width,height);}};LayoutPageView.prototype.getVisualData=function getVisualData(){var keyArray=[];this.rows.forEach(function(row){row.keys.forEach(function(keyView){var visualKey=keyView.element.querySelector('.visual-wrapper');keyArray.push({code:keyView.target.keyCode,x:visualKey.offsetLeft,y:visualKey.offsetTop,width:visualKey.clientWidth,height:visualKey.clientHeight});});});return keyArray;};exports.LayoutPageView=LayoutPageView;})(window);;'use strict';(function(exports){var KeyboardConsole=function KeyboardConsole(){this._timers=null;};KeyboardConsole.prototype.start=function(){var timers=this._timers=new Map();timers.set('domLoading',performance.timing.domLoading);this._startTime=Date.now();};KeyboardConsole.prototype.LOG_LEVEL=0;KeyboardConsole.prototype.trace=function(){if(this.LOG_LEVEL<3){return;}
console.trace.apply(console,arguments);};KeyboardConsole.prototype.time=function(timerName){if(this.LOG_LEVEL<2){return;}
console.time(timerName);};KeyboardConsole.prototype.timeEnd=function(timerName){if(this.LOG_LEVEL<2){return;}
if(this._timers.has(timerName)){console.log(timerName+': '+
(Date.now()-this._timers.get(timerName))+'ms');return;}
console.timeEnd(timerName);};KeyboardConsole.prototype.log=function(){if(this.LOG_LEVEL<2){return;}
console.log.apply(console,arguments);};KeyboardConsole.prototype.info=function(){if(this.LOG_LEVEL<1){return;}
console.info.apply(console,arguments);};exports.KeyboardConsole=KeyboardConsole;})(window);;'use strict';(function(exports){var InputMethods={};InputMethods['default']={init:function(glue){this._glue=glue;},click:function(keyCode,isRepeat){this._glue.sendKey(keyCode,isRepeat);},displaysCandidates:function(){return false;}};var InputMethodGlue=function InputMethodGlue(){this.app=null;};InputMethodGlue.prototype.SOURCE_DIR='./js/imes/';InputMethodGlue.prototype.init=function(app,imEngineName){this.app=app;this.imEngineName=imEngineName;this.path=this.SOURCE_DIR+imEngineName;};InputMethodGlue.prototype.sendCandidates=function(candidates){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call sendCandidates() when '+'inputContext does not exist.');return;}
this.app.candidatePanelManager.updateCandidates(candidates);};InputMethodGlue.prototype.setComposition=function(symbols,cursor){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call setComposition() when '+'inputContext does not exist.');return;}
cursor=cursor||symbols.length;this.app.console.info('inputContext.setComposition()');this.app.inputContext.setComposition(symbols,cursor).catch(function(e){console.warn('InputMethodGlue: setComposition() rejected with error',e);this.app.console.log(symbols,cursor);return Promise.reject(e);}.bind(this));};InputMethodGlue.prototype.endComposition=function(text){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call endComposition() when '+'inputContext does not exist.');return;}
text=text||'';this.app.console.info('inputContext.endComposition()');return this.app.inputContext.endComposition(text).catch(function(e){console.warn('InputMethodGlue: endComposition() rejected with error',e);this.app.console.log(text);return Promise.reject(e);}.bind(this));};InputMethodGlue.prototype.sendKey=function(keyCode,isRepeat){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call sendKey() when '+'inputContext does not exist.');return Promise.reject();}
var promise;this.app.console.info('inputContext.sendKey()');switch(keyCode){case KeyEvent.DOM_VK_BACK_SPACE:promise=this.app.inputContext.sendKey(keyCode,0,0,isRepeat);break;case KeyEvent.DOM_VK_RETURN:promise=this.app.inputContext.sendKey(keyCode,0,0);break;default:promise=this.app.inputContext.sendKey(0,keyCode,0);break;}
return promise.catch(function(e){console.warn('InputMethodGlue: sendKey() rejected with error',e);this.app.console.log(keyCode,isRepeat);return Promise.reject(e);}.bind(this));};InputMethodGlue.prototype.sendString=function(str){this.app.console.trace();for(var i=0;i<str.length;i++){this.sendKey(str.charCodeAt(i));}};InputMethodGlue.prototype.setLayoutPage=function(newpage){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call setLayoutPage() when '+'inputContext does not exist.');return;}
if(newpage!==this.app.layoutManager.PAGE_INDEX_DEFAULT){throw new Error('InputMethodGlue: '+'imEngine is only allowed to switch to default page');}
this.app.setLayoutPage(newpage);};InputMethodGlue.prototype.setUpperCase=function(state){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call setUpperCase() when '+'inputContext does not exist.');return;}
this.app.upperCaseStateManager.switchUpperCaseState(state);};InputMethodGlue.prototype.isCapitalized=function(){this.app.console.trace();return this.app.upperCaseStateManager.isUpperCase;};InputMethodGlue.prototype.replaceSurroundingText=function(text,offset,length){this.app.console.trace();if(!this.app.inputContext){console.warn('InputMethodGlue: call replaceSurroundingText() when '+'inputContext does not exist.');return Promise.reject();}
this.app.console.info('inputContext.replaceSurroundingText()');var p=this.app.inputContext.replaceSurroundingText(text,offset,length);p.catch(function(e){console.warn('InputMethodGlue: '+'replaceSurroundingText() rejected with error',e);this.app.console.log(text,offset,length);return Promise.reject(e);}.bind(this));return p;};InputMethodGlue.prototype.getNumberOfCandidatesPerRow=function(){return this.app.getNumberOfCandidatesPerRow();};InputMethodGlue.prototype.getData=function(dataPath){return this.app.inputMethodDatabaseLoader.load(this.imEngineName,dataPath);};var InputMethodLoader=function(app){this.app=app;};InputMethodLoader.prototype.SOURCE_DIR='./js/imes/';InputMethodLoader.prototype.start=function(){this._initializedIMEngines={};this._imEnginesPromises={};this.initPreloadedInputMethod();};InputMethodLoader.prototype.initPreloadedInputMethod=function(){var imEngineName;var InputMethods=exports.InputMethods;for(imEngineName in InputMethods){this.initInputMethod(imEngineName);this._imEnginesPromises[imEngineName]=Promise.resolve(this._initializedIMEngines[imEngineName]);}};InputMethodLoader.prototype.getInputMethod=function(imEngineName){return this._initializedIMEngines[imEngineName];};InputMethodLoader.prototype.getInputMethodAsync=function(imEngineName){if(this._imEnginesPromises[imEngineName]){return this._imEnginesPromises[imEngineName];}
var p=new Promise(function(resolve,reject){var script=document.createElement('script');script.onload=function(){this.initInputMethod(imEngineName);resolve(this._initializedIMEngines[imEngineName]);}.bind(this);script.onerror=function(){this._imEnginesPromises[imEngineName]=null;console.error('InputMethodLoader: unable to load '+imEngineName+'.');reject();}.bind(this);script.src=this.SOURCE_DIR+imEngineName+'/'+imEngineName+'.js';document.body.appendChild(script);}.bind(this));this._imEnginesPromises[imEngineName]=p;return p;};InputMethodLoader.prototype.initInputMethod=function(imEngineName){var InputMethods=exports.InputMethods;if(!(imEngineName in InputMethods)){throw new Error('InputMethodLoader: '+imEngineName+' did not expose itself correctly.');}
var imEngine=InputMethods[imEngineName];var glue=new InputMethodGlue();glue.init(this.app,imEngineName);this._initializedIMEngines[imEngineName]=InputMethods[imEngineName];InputMethods[imEngineName]=null;imEngine.init(glue);};var InputMethodManager=function InputMethodManager(app){this._targetIMEngineName=null;this.currentIMEngine=null;this.app=app;};InputMethodManager.prototype.start=function(){this.loader=new InputMethodLoader(this.app);this.loader.start();this.imEngineSettings=new IMEngineSettings();this.imEngineSettings.promiseManager=this.app.settingsPromiseManager;this.imEngineSettings.initSettings().catch(function rejected(){console.error('Fatal Error! Failed to get initial imEngine settings.');});this.currentIMEngine=this.loader.getInputMethod('default');this._inputContextData=null;};InputMethodManager.prototype.updateInputContextData=function(){this.app.console.log('InputMethodManager.updateInputContextData()');if(!this.app.inputContext){return;}
var inputContext=this.app.inputContext;var p=inputContext.getText().then(function(value){this.app.console.log('updateInputContextData:promise resolved');return{type:inputContext.inputType,inputmode:inputContext.inputMode,selectionStart:inputContext.selectionStart,selectionEnd:inputContext.selectionEnd,value:value};}.bind(this),function(error){console.warn('InputMethodManager: inputcontext.getText() was rejected.');return{type:inputContext.inputType,inputmode:inputContext.inputMode,selectionStart:inputContext.selectionStart,selectionEnd:inputContext.selectionEnd,value:''};}.bind(this));this._inputContextData=p;};InputMethodManager.prototype.switchCurrentIMEngine=function(imEngineName){this.app.console.log('InputMethodManager.switchCurrentIMEngine()',imEngineName);var dataPromise=this._inputContextData;if(!dataPromise&&imEngineName!=='default'){console.warn('InputMethodManager: switchCurrentIMEngine() called '+'without calling updateInputContextData() first.');}
if(this.currentIMEngine&&this.currentIMEngine.deactivate){this.app.console.log('InputMethodManager::currentIMEngine.deactivate()');this.currentIMEngine.deactivate();}
if(this.app.inputContext){this.app.inputContext.removeEventListener('selectionchange',this);this.app.inputContext.removeEventListener('surroundingtextchange',this);}
this.currentIMEngine=this.loader.getInputMethod('default');var loaderPromise=this.loader.getInputMethodAsync(imEngineName);var settingsPromise=this.imEngineSettings.initSettings();var p=Promise.all([loaderPromise,dataPromise,settingsPromise]).then(function(values){var imEngine=values[0];if(typeof imEngine.activate==='function'){var dataValues=values[1];var settingsValues=values[2];var currentPage=this.app.layoutManager.currentPage;var lang=this.app.layoutManager.currentPage.autoCorrectLanguage||this.app.layoutManager.currentPage.handwritingLanguage;var correctPunctuation='autoCorrectPunctuation'in currentPage?currentPage.autoCorrectPunctuation:true;this.app.console.log('InputMethodManager::currentIMEngine.activate()');imEngine.activate(lang,dataValues,{suggest:settingsValues.suggestionsEnabled,correct:settingsValues.correctionsEnabled,correctPunctuation:correctPunctuation});}
if(typeof imEngine.selectionChange==='function'){this.app.inputContext.addEventListener('selectionchange',this);}
if(typeof imEngine.surroundingtextChange==='function'){this.app.inputContext.addEventListener('surroundingtextchange',this);}
this.currentIMEngine=imEngine;this._inputContextData=null;}.bind(this));return p;};InputMethodManager.prototype.handleEvent=function(evt){this.app.console.info('InputMethodManager.handleEvent()',evt);switch(evt.type){case'selectionchange':this.app.console.log('InputMethodManager::currentIMEngine.selectionChange()',evt.detail);this.currentIMEngine.selectionChange(evt.detail);break;case'surroundingtextchange':this.app.console.log('InputMethodManager::currentIMEngine.surroundingtextChange()',evt.detail);this.currentIMEngine.surroundingtextChange(evt.detail);break;}};exports.InputMethods=InputMethods;exports.InputMethodGlue=InputMethodGlue;exports.InputMethodLoader=InputMethodLoader;exports.InputMethodManager=InputMethodManager;})(window);;'use strict';(function(exports){var InputMethodDatabaseLoader=function InputMethodDatabaseLoader(){};InputMethodDatabaseLoader.prototype.SOURCE_DIR='./js/imes/';InputMethodDatabaseLoader.prototype.start=function(){};InputMethodDatabaseLoader.prototype.stop=function(){};InputMethodDatabaseLoader.prototype.load=function(imEngineName,dataPath){return new Promise(function(resolve,reject){var url=this.SOURCE_DIR+imEngineName+'/'+dataPath;var xhr=new XMLHttpRequest();xhr.open('GET',url,true);xhr.responseType='arraybuffer';xhr.onload=function(){if(xhr.status!==404&&xhr.response&&xhr.response.byteLength){resolve(xhr.response);}else{reject(xhr.statusText);}};xhr.send();}.bind(this)).catch(function(e){console.error('InputMethodDatabaseLoader: XHR failed to load data.','imEngineName=',imEngineName,'dataPath=',dataPath,'error=',e);throw e;});};exports.InputMethodDatabaseLoader=InputMethodDatabaseLoader;})(window);;'use strict';(function(exports){var SettingsPromiseManager=function SettingsPromiseManager(){this._readLock=null;this._writeLock=null;};SettingsPromiseManager.prototype._cleanLock=function(type){var propName;switch(type){case'read':propName='_readLock';break;case'write':propName='_writeLock';break;default:throw new Error('SettingsPromiseManager: Not such type.');}
if(this[propName]&&this[propName].closed){this[propName]=null;}};SettingsPromiseManager.prototype._getLock=function(type){var propName;switch(type){case'read':propName='_readLock';break;case'write':propName='_writeLock';break;default:throw new Error('SettingsPromiseManager: Not such type.');}
if(this[propName]&&!this[propName].closed){return this[propName];}
var settings=window.navigator.mozSettings;this[propName]=settings.createLock();return this[propName];};SettingsPromiseManager.prototype._getReadLock=function(){return this._getLock('read');};SettingsPromiseManager.prototype._getWriteLock=function(){return this._getLock('write');};SettingsPromiseManager.prototype.get=function(obj){if(typeof obj==='string'){return this.getOne(obj);}
if(typeof obj!=='object'){throw new Error('SettingsPromiseManager.get: '+'require object, array, or string.');}
var arr=Array.isArray(obj)?obj:Object.keys(obj);var promise=Promise.all(arr.map(function(key){return this.getOne(key);},this));return promise;};SettingsPromiseManager.prototype.getOne=function(key){var promise=new Promise(function(resolve,reject){var req=this._getReadLock().get(key);req.onsuccess=function(){this._cleanLock('read');resolve(req.result[key]);}.bind(this);req.onerror=function(){this._cleanLock('read');reject();}.bind(this);}.bind(this));return promise;};SettingsPromiseManager.prototype.set=function(obj,value){if(typeof obj==='string'){return this.setOne(obj,value);}
if(typeof obj!=='object'){throw new Error('SettingsPromiseManager.set: require object.');}
var promise=new Promise(function(resolve,reject){var req=this._getWriteLock().set(obj);req.onsuccess=function(){this._cleanLock('write');resolve();}.bind(this);req.onerror=function(){this._cleanLock('write');reject();}.bind(this);}.bind(this));return promise;};SettingsPromiseManager.prototype.setOne=function(key,value){var obj={};obj[key]=value;return this.set(obj);};var SettingsManagerBase=function(){this.initialized=false;this._callbacks=null;this._values={};this._initPromise=null;};SettingsManagerBase.prototype.onsettingchange=null;SettingsManagerBase.prototype.KEYS=[];SettingsManagerBase.prototype.PROPERTIES=[];SettingsManagerBase.prototype.getSettingsSync=function(){return this._values;};SettingsManagerBase.prototype.initSettings=function(){if(this._initPromise){return this._initPromise;}
var promise=this.promiseManager.get(this.KEYS).then(function(results){results.forEach(function(value,i){this._values[this.PROPERTIES[i]]=value;},this);this.startObserve();this.initialized=true;return this._values;}.bind(this),function(error){this._initPromise=null;return Promise.reject(error);}.bind(this));this._initPromise=promise;return promise;};SettingsManagerBase.prototype.startObserve=function(){if(this._callbacks){return;}
var callbacks=this._callbacks=[];this.KEYS.forEach(function(key,i){var callback=function(e){this._values[this.PROPERTIES[i]]=e.settingValue;if(typeof this.onsettingchange==='function'){this.onsettingchange(this._values);}}.bind(this);navigator.mozSettings.addObserver(key,callback);callbacks.push(callback);},this);};SettingsManagerBase.prototype.stopObserve=function(){if(!this._callbacks){return;}
var callbacks=this._callbacks;this.KEYS.forEach(function(key,i){navigator.mozSettings.removeObserver(key,callbacks[i]);},this);this._callbacks=null;};var SoundFeedbackSettings=function(){};SoundFeedbackSettings.prototype=new SettingsManagerBase();SoundFeedbackSettings.prototype.KEYS=['keyboard.clicksound','audio.volume.notification'];SoundFeedbackSettings.prototype.PROPERTIES=['clickEnabled','isSoundEnabled'];var VibrationFeedbackSettings=function(){};VibrationFeedbackSettings.prototype=new SettingsManagerBase();VibrationFeedbackSettings.prototype.KEYS=['keyboard.vibration'];VibrationFeedbackSettings.prototype.PROPERTIES=['vibrationEnabled'];var IMEngineSettings=function(){};IMEngineSettings.prototype=new SettingsManagerBase();IMEngineSettings.prototype.KEYS=['keyboard.wordsuggestion','keyboard.autocorrect'];IMEngineSettings.prototype.PROPERTIES=['suggestionsEnabled','correctionsEnabled'];var HandwritingPadSettings=function(){};HandwritingPadSettings.prototype=new SettingsManagerBase();HandwritingPadSettings.prototype.KEYS=['keyboard.handwriting.strokeWidth','keyboard.handwriting.responseTime'];HandwritingPadSettings.prototype.PROPERTIES=['strokeWidth','responseTime'];exports.SettingsPromiseManager=SettingsPromiseManager;exports.SettingsManagerBase=SettingsManagerBase;exports.SoundFeedbackSettings=SoundFeedbackSettings;exports.VibrationFeedbackSettings=VibrationFeedbackSettings;exports.IMEngineSettings=IMEngineSettings;exports.HandwritingPadSettings=HandwritingPadSettings;})(window);;'use strict';(function(exports){var SoundFeedbackPlayer=function(){this._audioCtx=null;this._clickerAudioBuf=null;this._specialClickerAudioBuf=null;};SoundFeedbackPlayer.prototype.CLICK_SOUND_URL='./resources/sounds/key.wav';SoundFeedbackPlayer.prototype.SPECIAL_SOUND_URL='./resources/sounds/special.wav';SoundFeedbackPlayer.prototype.activate=function(){if(this._audioCtx){return;}
this._audioCtx=new AudioContext();};SoundFeedbackPlayer.prototype.deactivate=function(){this._audioCtx=null;};SoundFeedbackPlayer.prototype.prepare=function(){if(typeof AudioContext==='undefined'||typeof OfflineAudioContext==='undefined'){console.error('SoundFeedbackPlayer: No Web Audio API on this platform.');return;}
var clickerPromise=this._getAudioFileAsArrayBuffer(this.CLICK_SOUND_URL).then(this._decodeAudioData.bind(this)).then(function(audioBuffer){this._clickerAudioBuf=audioBuffer;}.bind(this));var specialClickerPromise=this._getAudioFileAsArrayBuffer(this.SPECIAL_SOUND_URL).then(this._decodeAudioData.bind(this)).then(function(audioBuffer){this._specialClickerAudioBuf=audioBuffer;}.bind(this));return Promise.all([clickerPromise,specialClickerPromise]).catch(function(e){console.error(e);throw e;});};SoundFeedbackPlayer.prototype._getAudioFileAsArrayBuffer=function(url){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest();xhr.open('GET',url);xhr.responseType='arraybuffer';xhr.onload=function(){if(!xhr.response){reject('SoundFeedbackPlayer: Cannot load file: '+url);return;}
resolve(xhr.response);};xhr.send();});};SoundFeedbackPlayer.prototype._decodeAudioData=function(arrayBuffer){return new Promise(function(resolve,reject){var ctx=new OfflineAudioContext(2,1,44100);ctx.decodeAudioData(arrayBuffer,function(audioBuffer){resolve(audioBuffer);},function(){reject('SoundFeedbackPlayer: decodeAudioData failed.');});}.bind(this));};SoundFeedbackPlayer.prototype.play=function(isSpecialKey){if(!this._clickerAudioBuf||!this._specialClickerAudioBuf){console.warn('SoundFeedbackPlayer: '+'Sound feedback needed but audio buffer is not available yet.');return;}
if(!this._audioCtx){console.error('SoundFeedbackPlayer: play() is called but not activated?');return;}
var ctx=this._audioCtx;var source=ctx.createBufferSource();source.buffer=isSpecialKey?this._specialClickerAudioBuf:this._clickerAudioBuf;source.connect(ctx.destination);source.start(0);};exports.SoundFeedbackPlayer=SoundFeedbackPlayer;})(window);;'use strict';(function(exports){var VibrationFeedback=function(app){this.app=app;this.settings=null;};VibrationFeedback.prototype.VIBRATE_MS=50;VibrationFeedback.prototype.start=function(){var settings=this.settings=new VibrationFeedbackSettings();settings.promiseManager=this.app.settingsPromiseManager;settings.initSettings().catch(function rejected(){console.warn('VibrationFeedback: Failed to get initial settings.');});};VibrationFeedback.prototype.stop=function(){this.settings=null;};VibrationFeedback.prototype.triggerFeedback=function(){if(!this.settings.initialized){console.warn('VibrationFeedback: '+'Sound feedback needed but settings is not available yet.');return;}
if(typeof window.navigator.vibrate!=='function'){console.warn('VibrationFeedback: '+'No navigator.vibrate() on this platform.');return;}
var vibrationFeedbackSettingsValues=this.settings.getSettingsSync();if(!vibrationFeedbackSettingsValues.vibrationEnabled){return;}
window.navigator.vibrate(this.VIBRATE_MS);};var SoundFeedback=function(app){this.app=app;this.activated=false;this.settings=null;this.clicker=null;this.specialClicker=null;};SoundFeedback.prototype.start=function(){var settings=this.settings=new SoundFeedbackSettings();settings.promiseManager=this.app.settingsPromiseManager;settings.onsettingchange=this._handleSettingsChange.bind(this);settings.initSettings().then(this._handleSettingsChange.bind(this),function rejected(){console.warn('SoundFeedback: Failed to get initial settings.');});};SoundFeedback.prototype.stop=function(){this.settings=null;this.player=null;};SoundFeedback.prototype.activate=function(){this.activated=true;if(this.player){this.player.activate();}};SoundFeedback.prototype.deactivate=function(){this.activated=false;if(this.player){this.player.deactivate();}};SoundFeedback.prototype._handleSettingsChange=function(settings){if(settings.clickEnabled&&!!settings.isSoundEnabled){this.player=new SoundFeedbackPlayer();this.player.prepare();if(this.activated){this.player.activate();}}else{this.player=null;}};SoundFeedback.prototype.triggerFeedback=function(target){if(!this.settings.initialized){console.warn('SoundFeedback: '+'Sound feedback needed but settings is not available yet.');return;}
if(!this.player){return;}
this.player.play(target.isSpecialKey);};var FeedbackManager=function(app){this.app=app;this.vibrationFeedback=null;this.soundFeedback=null;};FeedbackManager.prototype.start=function(){this.vibrationFeedback=new VibrationFeedback(this.app);this.vibrationFeedback.start();this.soundFeedback=new SoundFeedback(this.app);this.soundFeedback.start();};FeedbackManager.prototype.stop=function(){this.settings=null;this.vibrationFeedback.stop();this.soundFeedback.stop();this.vibrationFeedback=null;this.soundFeedback=null;};FeedbackManager.prototype.activate=function(){this.soundFeedback.activate();};FeedbackManager.prototype.deactivate=function(){this.soundFeedback.deactivate();};FeedbackManager.prototype.triggerFeedback=function(target){this.vibrationFeedback.triggerFeedback(target);this.soundFeedback.triggerFeedback(target);};exports.VibrationFeedback=VibrationFeedback;exports.SoundFeedback=SoundFeedback;exports.FeedbackManager=FeedbackManager;})(window);;'use strict';(function(exports){var UpperCaseStateManager=function(){this.isUpperCase=undefined;this.isUpperCaseLocked=undefined;};UpperCaseStateManager.prototype.onstatechange=null;UpperCaseStateManager.prototype.start=UpperCaseStateManager.prototype.reset=function(){this.isUpperCase=false;this.isUpperCaseLocked=false;};UpperCaseStateManager.prototype.stop=function(){this.isUpperCase=undefined;this.isUpperCaseLocked=undefined;};UpperCaseStateManager.prototype.switchUpperCaseState=function(state){if(!state){return;}
var newIsUpperCase=(typeof state.isUpperCase==='boolean')?state.isUpperCase:this.isUpperCase;var newIsUpperCaseLocked=(typeof state.isUpperCaseLocked==='boolean')?state.isUpperCaseLocked:this.isUpperCaseLocked;if(newIsUpperCaseLocked){newIsUpperCase=true;}
var statechanged=(this.isUpperCase!==newIsUpperCase)||(this.isUpperCaseLocked!==newIsUpperCaseLocked);if(!statechanged){return;}
this.isUpperCase=newIsUpperCase;this.isUpperCaseLocked=newIsUpperCaseLocked;if(typeof this.onstatechange==='function'){this.onstatechange();}};exports.UpperCaseStateManager=UpperCaseStateManager;})(window);;'use strict';(function(exports){var CandidatePanelScrollingMonitor=function(app){this.app=app;this.scrollTimer=undefined;};CandidatePanelScrollingMonitor.prototype.SCROLL_END_WAIT_MS=200;CandidatePanelScrollingMonitor.prototype.onneedcandidates=null;CandidatePanelScrollingMonitor.prototype.start=function(){};CandidatePanelScrollingMonitor.prototype.stop=function(){clearTimeout(this.scrollTimer);if(IMERender.candidatePanel){IMERender.candidatePanel.removeEventListener('scroll',this);}};CandidatePanelScrollingMonitor.prototype.handleEvent=function(evt){var panel=evt.target;clearTimeout(this.scrollTimer);if(panel.scrollTop===0||(panel.scrollHeight-panel.clientHeight-panel.scrollTop)>=5){return;}
this.scrollTimer=setTimeout(function(){if(typeof this.onneedcandidates==='function'){this.onneedcandidates();}}.bind(this),this.SCROLL_END_WAIT_MS);};CandidatePanelScrollingMonitor.prototype.startMonitoring=function(){if('truncated'in IMERender.candidatePanel.dataset){IMERender.candidatePanel.addEventListener('scroll',this);}};CandidatePanelScrollingMonitor.prototype.stopMonitoring=function(){clearTimeout(this.scrollTimer);IMERender.candidatePanel.removeEventListener('scroll',this);};var CandidatePanelManager=function(app){this.app=app;this.currentCandidates=null;this.isFullPanelShown=undefined;this.scrollingMonitor=null;};CandidatePanelManager.prototype.FIRST_PAGE_ROWS=11;CandidatePanelManager.prototype.PAGE_ROWS=12;CandidatePanelManager.prototype.oncandidateschange=null;CandidatePanelManager.prototype.start=function(){this.currentCandidates=[];this.isFullPanelShown=false;this.scrollingMonitor=new CandidatePanelScrollingMonitor(this.app);this.scrollingMonitor.start();this.scrollingMonitor.onneedcandidates=this.showNextCandidatePage.bind(this);};CandidatePanelManager.prototype.stop=function(){this.scrollingMonitor.stop();this.scrollingMonitor=null;this.isFullPanelShown=undefined;};CandidatePanelManager.prototype.showNextCandidatePage=function(){var numberOfCandidatesPerRow=IMERender.getNumberOfCandidatesPerRow();var candidatePanel=IMERender.candidatePanel;var candidateIndicator=parseInt(candidatePanel.dataset.candidateIndicator,10);var engine=this.app.inputMethodManager.currentIMEngine;if(typeof engine.getMoreCandidates==='function'){engine.getMoreCandidates(candidateIndicator,this.PAGE_ROWS*numberOfCandidatesPerRow+1,IMERender.showMoreCandidates.bind(IMERender,this.PAGE_ROWS));}else{var list=this.currentCandidates.slice(candidateIndicator,candidateIndicator+this.PAGE_ROWS*numberOfCandidatesPerRow+1);IMERender.showMoreCandidates(this.PAGE_ROWS,list);}};CandidatePanelManager.prototype.toggleFullPanel=function(fullPanel){if(this.isFullPanelShown){this.hideFullPanel();}else{this.showFullPanel();}};CandidatePanelManager.prototype.showFullPanel=function(){if(this.isFullPanelShown){return;}
this.isFullPanelShown=true;var candidatePanel=IMERender.candidatePanel;if(candidatePanel.dataset.rowCount==1){var numberOfCandidatesPerRow=IMERender.getNumberOfCandidatesPerRow();var candidateIndicator=parseInt(candidatePanel.dataset.candidateIndicator,10);var engine=this.app.inputMethodManager.currentIMEngine;if(typeof engine.getMoreCandidates==='function'){engine.getMoreCandidates(candidateIndicator,this.FIRST_PAGE_ROWS*numberOfCandidatesPerRow+1,function gotMoreCandidates(list){if(candidatePanel.dataset.rowCount!=1){return;}
IMERender.showMoreCandidates(this.FIRST_PAGE_ROWS,list);this.scrollingMonitor.startMonitoring();IMERender.toggleCandidatePanel(true);}.bind(this));}else{var list=this.currentCandidates.slice(candidateIndicator,candidateIndicator+
this.FIRST_PAGE_ROWS*numberOfCandidatesPerRow+1);IMERender.showMoreCandidates(this.FIRST_PAGE_ROWS,list);this.scrollingMonitor.startMonitoring();IMERender.toggleCandidatePanel(true);}}else{this.scrollingMonitor.startMonitoring();IMERender.toggleCandidatePanel(true);}};CandidatePanelManager.prototype.hideFullPanel=function(){if(!this.isFullPanelShown){return;}
this.isFullPanelShown=false;this.scrollingMonitor.stopMonitoring();IMERender.toggleCandidatePanel(false);};CandidatePanelManager.prototype.reset=function(){this.hideFullPanel();this.currentCandidates=[];};CandidatePanelManager.prototype.updateCandidates=function(candidates){this.currentCandidates=candidates;if(typeof this.oncandidateschange==='function'){this.oncandidateschange();}};exports.CandidatePanelScrollingMonitor=CandidatePanelScrollingMonitor;exports.CandidatePanelManager=CandidatePanelManager;})(window);;'use strict';(function(exports){var LayoutRenderingManager=function(app){this.app=app;this._currentRenderingPage=null;this._resizeListenerTimer=undefined;this.domObjectMap=null;};LayoutRenderingManager.prototype.start=function(){this.app.console.log('LayoutRenderingManager.start()');this._resizeListenerTimer=setTimeout(function attachResizeListener(){this.app.console.log('LayoutRenderingManager.attachResizeListener()');window.addEventListener('resize',this);}.bind(this),2000);this.domObjectMap=new WeakMap();};LayoutRenderingManager.prototype.stop=function(){clearTimeout(this._resizeListenerTimer);this._resizeListenerTimer=undefined;window.removeEventListener('resize',this);this.domObjectMap=null;};LayoutRenderingManager.prototype.handleEvent=function(){this.app.console.log('LayoutRenderingManager.handleEvent()');if(document.hidden){this.app.console.log('LayoutRenderingManager: Ignore resizing call since '+'document is hidden.');return;}
if(this._currentRenderingPage!==this.app.layoutManager.currentPage){this.app.console.log('LayoutRenderingManager: Ignore resizing call since '+'layout is not ready yet.');return;}
IMERender.resizeUI(this.app.layoutManager.currentPage);this._updateHeight();this._updateLayoutParams();};LayoutRenderingManager.prototype.updateCandidatesRendering=function(){if(this._currentRenderingPage!==this.app.layoutManager.currentPage){this.app.console.log('LayoutRenderingManager: Ignore updateCandidatesRendering() call since '+'layout is not ready yet.');return;}
IMERender.showCandidates(this.app.candidatePanelManager.currentCandidates);};LayoutRenderingManager.prototype.updateUpperCaseRendering=function(){this.app.console.log('LayoutRenderingManager.updateUpperCaseRendering()');if(this._currentRenderingPage!==this.app.layoutManager.currentPage){this.app.console.log('LayoutRenderingManager: Ignore updateUpperCaseRendering() call since '+'layout is not ready yet.');return;}
window.requestAnimationFrame(function(){this.app.console.log('LayoutRenderingManager.updateUpperCaseRendering()::'+'requestAnimationFrame');IMERender.setUpperCaseLock(this.app.upperCaseStateManager);}.bind(this));};LayoutRenderingManager.prototype.updateLayoutRendering=function(){this.app.console.log('LayoutRenderingManager.updateLayoutRendering()');this.app.console.time('LayoutRenderingManager.updateLayoutRendering()');var currentPage=this._currentRenderingPage=this.app.layoutManager.currentPage;var currentIMEngine=this.app.inputMethodManager.currentIMEngine;this.app.console.log('needsCandidatePanel',currentPage.autoCorrectLanguage,currentPage.needsCandidatePanel,typeof currentIMEngine.displaysCandidates!=='function',(currentIMEngine.displaysCandidates&&currentIMEngine.displaysCandidates()));var needsCandidatePanel=!!((currentPage.autoCorrectLanguage||currentPage.needsCandidatePanel)&&((typeof currentIMEngine.displaysCandidates!=='function')||currentIMEngine.displaysCandidates()));var p=new Promise(function(resolve){IMERender.draw(currentPage,{uppercase:this.app.upperCaseStateManager.isUpperCase,inputType:this.app.getBasicInputType(),showCandidatePanel:needsCandidatePanel},resolve);}.bind(this)).then(this._afterRenderDrew.bind(this));p.catch(function(e){console.error(e);});IMERender.setInputMethodName(this.app.layoutManager.currentPage.imEngine||'default');this.app.console.timeEnd('LayoutRenderingManager.updateLayoutRendering()');return p;};LayoutRenderingManager.prototype.drawHandwritingPad=function(press,start,strokeWidth){return IMERender.drawHandwritingPad(press,start,strokeWidth);};LayoutRenderingManager.prototype.clearHandwritingPad=function(target){IMERender.clearHandwritingPad(target);};LayoutRenderingManager.prototype._afterRenderDrew=function(){this.app.console.log('LayoutRenderingManager._afterRenderDrew()');this.app.console.time('LayoutRenderingManager._afterRenderDrew()');IMERender.setUpperCaseLock(this.app.upperCaseStateManager);IMERender.showCandidates(this.app.candidatePanelManager.currentCandidates);this._updateLayoutParams();this._updateHeight();this.app.console.timeEnd('LayoutRenderingManager._afterRenderDrew()');};LayoutRenderingManager.prototype._updateLayoutParams=function(){this.app.console.log('LayoutRenderingManager._updateLayoutParams()');var currentIMEngine=this.app.inputMethodManager.currentIMEngine;var layoutManager=this.app.layoutManager;if((typeof currentIMEngine.setLayoutParams!=='function')||layoutManager.currentPageIndex!==layoutManager.PAGE_INDEX_DEFAULT){return;}
var candidatePanel=IMERender.candidatePanel;var yBias=candidatePanel?candidatePanel.clientHeight:0;currentIMEngine.setLayoutParams({keyboardWidth:IMERender.getWidth(),keyboardHeight:(IMERender.getHeight()-yBias),keyArray:IMERender.getKeyArray(),keyWidth:IMERender.getKeyWidth(),keyHeight:IMERender.getKeyHeight()});};LayoutRenderingManager.prototype._updateHeight=function(){this.app.console.log('LayoutRenderingManager._updateHeight()');this.app.console.time('LayoutRenderingManager._updateHeight()');var imeHeight=IMERender.getHeight()+1;var imeWidth=IMERender.getWidth();this.app.console.timeEnd('LayoutRenderingManager._updateHeight()');this.app.console.timeEnd('activate');this.app.console.timeEnd('domLoading');window.resizeTo(imeWidth,imeHeight);};LayoutRenderingManager.prototype.getTargetObject=function(elem){this.app.console.log('LayoutRenderingManager.getTargetObject()',elem);if(!elem){return{};}
var target=this.domObjectMap.get(elem);this.app.console.log('target=',target,'prototype=',target&&Object.getPrototypeOf(target));return target||{};};exports.LayoutRenderingManager=LayoutRenderingManager;})(window);;'use strict';(function(exports){var AbortablePromiseQueueError=function(currentId,expectedId){this.currentId=currentId;this.expectedId=expectedId;};AbortablePromiseQueueError.prototype.name='AbortablePromiseQueueError';AbortablePromiseQueueError.prototype.message='The current task group ID does not match.';var AbortablePromiseQueue=function AbortablePromiseQueue(){this._started=false;this._taskGroupId=0;this._queuedTasks=null;};AbortablePromiseQueue.prototype.start=function(){if(this._started){throw new Error('AbortablePromiseQueue: Should not be start()\'ed twice.');}
this._started=true;this._queuedTasks=Promise.resolve();};AbortablePromiseQueue.prototype.stop=function(){if(!this._started){throw new Error('AbortablePromiseQueue: '+'Was not start()\'ed but stop() is called.');}
this._started=false;this.abort();this._queuedTasks=null;this._taskGroupId=0;};AbortablePromiseQueue.prototype.run=function(tasks){this.abort();var idCheck=this._getIdCheckFunction();tasks.forEach(function(task){this._queuedTasks=this._queuedTasks.then(idCheck).then(task);},this);this._queuedTasks=this._queuedTasks.catch(function(e){if(e instanceof AbortablePromiseQueueError){return;}
(e!==undefined)&&console.error(e);});return this._queuedTasks;};AbortablePromiseQueue.prototype.abort=function(){this._taskGroupId++;};AbortablePromiseQueue.prototype._getIdCheckFunction=function(){var id=this._taskGroupId;return function __taskGroupIdCheck(value){if(id!==this._taskGroupId){return Promise.reject(new AbortablePromiseQueueError(this._taskGroupId,id));}
return value;}.bind(this);};exports.AbortablePromiseQueue=AbortablePromiseQueue;})(window);;'use strict';(function(exports){var StateManager=function(app){this.app=app;this._started=false;this._isActive=undefined;this._layoutName=undefined;};StateManager.prototype.start=function(){this.app.console.log('StateManager.start()');if(this._started){throw new Error('StateManager: Should not be start()\'ed twice.');}
this._started=true;this._isActive=false;this._queue=new AbortablePromiseQueue();this._queue.start();window.addEventListener('hashchange',this);window.addEventListener('visibilitychange',this);navigator.mozInputMethod.addEventListener('inputcontextchange',this);this.app.setInputContext(navigator.mozInputMethod.inputcontext);this._layoutName=window.location.hash.substr(1);var active=(!document.hidden&&!!this.app.inputContext);if(!active){this._queue.run([this._preloadLayout.bind(this),this._preloadInputMethod.bind(this),this.app.l10nLoader.load.bind(this.app.l10nLoader)]);}
this._updateActiveState(active);};StateManager.prototype.stop=function(){this.app.console.log('StateManager.stop()');if(!this._started){throw new Error('StateManager: Was not start()\'ed but stop() is called.');}
this._started=false;this._queue.stop();this._queue=null;window.removeEventListener('hashchange',this);window.removeEventListener('visibilitychange',this);navigator.mozInputMethod.removeEventListener('inputcontextchange',this);this._isActive=undefined;this._layoutName=undefined;};StateManager.prototype.handleEvent=function(evt){var active=(!document.hidden&&!!navigator.mozInputMethod.inputcontext);this.app.console.info('StateManager.handleEvent()',evt,active);switch(evt.type){case'hashchange':this._layoutName=window.location.hash.substr(1);if(!active){this._queue.run([this._preloadLayout.bind(this),this._preloadInputMethod.bind(this)]);}
break;case'visibilitychange':break;case'inputcontextchange':this.app.setInputContext(navigator.mozInputMethod.inputcontext);break;}
this._updateActiveState(active);};StateManager.prototype._updateActiveState=function(active){this.app.console.log('StateManager._updateActiveState()',active);if(active){this.app.console.time('activate');this._queue.run([function(){this.app.inputMethodManager.updateInputContextData();this.app.candidatePanelManager.hideFullPanel();this.app.candidatePanelManager.updateCandidates([]);this.app.feedbackManager.activate();}.bind(this),this.app.layoutManager.switchCurrentLayout.bind(this.app.layoutManager,this._layoutName),this._switchCurrentIMEngine.bind(this),this.app.layoutRenderingManager.updateLayoutRendering.bind(this.app.layoutRenderingManager),this.app.l10nLoader.load.bind(this.app.l10nLoader),this.app.settingsPromiseManager.set.bind(this.app.settingsPromiseManager,{'keyboard.current':this._layoutName})]);}else{if(active===this._isActive){return;}
this._queue.run([function(){this.app.candidatePanelManager.hideFullPanel();this.app.candidatePanelManager.updateCandidates([]);this.app.targetHandlersManager.activeTargetsManager.clearAllTargets();this.app.feedbackManager.deactivate();}.bind(this),this.app.inputMethodManager.switchCurrentIMEngine.bind(this.app.inputMethodManager,'default'),this.app.settingsPromiseManager.set.bind(this.app.settingsPromiseManager,{'keyboard.current':undefined})]);}
this._isActive=active;};StateManager.prototype._preloadLayout=function(){this.app.console.log('StateManager._preloadLayout()');var layoutLoader=this.app.layoutManager.loader;return layoutLoader.getLayoutAsync(this._layoutName);};StateManager.prototype._preloadInputMethod=function(layout){this.app.console.log('StateManager._preloadInputMethod()');var imEngineName=layout.imEngine;var imEngineLoader=this.app.inputMethodManager.loader;if(imEngineName){var p=imEngineLoader.getInputMethodAsync(imEngineName);return p;}};StateManager.prototype._switchCurrentIMEngine=function(){this.app.console.log('StateManager._switchCurrentIMEngine()');var page=this.app.layoutManager.currentPage;var imEngineName=page.imEngine||'default';this.app.upperCaseStateManager.reset();this.app.candidatePanelManager.reset();var p=this.app.inputMethodManager.switchCurrentIMEngine(imEngineName);return p;};exports.StateManager=StateManager;})(window);;'use strict';(function(exports){var KeyboardApp=function(){this.console=null;this.inputMethodManager=null;this.inputMethodDatabaseLoader=null;this.layoutManager=null;this.settingsPromiseManager=null;this.l10nLoader=null;this.targetHandlersManager=null;this.handwritingPadsManager=null;this.feedbackManager=null;this.visualHighlightManager=null;this.candidatePanelManager=null;this.upperCaseStateManager=null;this.layoutRenderingManager=null;this.stateManager=null;this.inputContext=null;};KeyboardApp.prototype.CONATINER_ELEMENT_ID='keyboard';KeyboardApp.prototype.start=function(){this._startComponents();};KeyboardApp.prototype._startComponents=function(){this.console=new KeyboardConsole();this.console.start();this.console.log('KeyboardApp._startComponents()');this.console.trace();this.console.time('KeyboardApp._startComponents()');this.settingsPromiseManager=new SettingsPromiseManager();this.inputMethodManager=new InputMethodManager(this);this.inputMethodManager.start();this.inputMethodDatabaseLoader=new InputMethodDatabaseLoader(this);this.inputMethodDatabaseLoader.start();this.layoutManager=new LayoutManager(this);this.layoutManager.start();this.l10nLoader=new L10nLoader();this.targetHandlersManager=new TargetHandlersManager(this);this.targetHandlersManager.start();this.handwritingPadsManager=new HandwritingPadsManager(this);this.handwritingPadsManager.start();this.feedbackManager=new FeedbackManager(this);this.feedbackManager.start();this.visualHighlightManager=new VisualHighlightManager(this);this.visualHighlightManager.start();var renderingManager=this.layoutRenderingManager=new LayoutRenderingManager(this);renderingManager.start();this.upperCaseStateManager=new UpperCaseStateManager();this.upperCaseStateManager.onstatechange=renderingManager.updateUpperCaseRendering.bind(renderingManager);this.upperCaseStateManager.start();this.candidatePanelManager=new CandidatePanelManager(this);this.candidatePanelManager.oncandidateschange=renderingManager.updateCandidatesRendering.bind(renderingManager);this.candidatePanelManager.start();IMERender.init(this.layoutRenderingManager);this.stateManager=new StateManager(this);this.stateManager.start();this.console.timeEnd('KeyboardApp._startComponents()');};KeyboardApp.prototype.stop=function(){this.console.log('KeyboardApp.stop()');this._stopComponents();this.inputContext=null;};KeyboardApp.prototype._stopComponents=function(){this.console=null;this.inputMethodManager=null;this.inputMethodDatabaseLoader.stop();this.inputMethodDatabaseLoader=null;this.layoutManager=null;this.settingsPromiseManager=null;this.l10nLoader=null;this.targetHandlersManager.stop();this.targetHandlersManager=null;this.handwritingPadsManager.stop();this.handwritingPadsManager=null;this.feedbackManager.stop();this.feedbackManager=null;this.visualHighlightManager.stop();this.visualHighlightManager=null;this.candidatePanelManager.stop();this.candidatePanelManager=null;this.upperCaseStateManager.onstatechange=null;this.upperCaseStateManager.stop();this.upperCaseStateManager=null;this.layoutRenderingManager.stop();this.layoutRenderingManager=null;this.stateManager.stop();this.stateManager=null;};KeyboardApp.prototype.getContainer=function(){return document.getElementById(this.CONATINER_ELEMENT_ID);};KeyboardApp.prototype.setInputContext=function(inputContext){this.console.log('KeyboardApp.setInputContext()',inputContext);this.inputContext=inputContext;};KeyboardApp.prototype.getBasicInputType=function(){if(!this.inputContext){return'text';}
var type=this.inputContext.inputType;switch(type){case'url':case'tel':case'email':case'text':case'search':break;case'password':default:type='text';break;case'number':case'range':type='number';break;}
return type;};KeyboardApp.prototype.supportsSwitching=function(){return navigator.mozInputMethod.mgmt.supportsSwitching();};KeyboardApp.prototype.setLayoutPage=function setLayoutPage(page){this.console.log('KeyboardApp.setLayoutPage()',page);this.layoutManager.updateLayoutPage(page);this.layoutRenderingManager.updateLayoutRendering();var engine=this.inputMethodManager.currentIMEngine;if(typeof engine.setLayoutPage==='function'){engine.setLayoutPage(this.layoutManager.currentPageIndex);}};KeyboardApp.prototype.getNumberOfCandidatesPerRow=function(){return IMERender.getNumberOfCandidatesPerRow();};exports.KeyboardApp=KeyboardApp;})(window);;'use strict';(function(exports){var app=new KeyboardApp();app.start();exports.app=app;})(window);