// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');

(function(Module) {
// We need to put this library in Web Workers so we can't acess the 'document'
// object in this file. In fact, this library doesn't really need the 'document'
// object for our purpose, so we create a dummy object for it.
var document = { addEventListener: function() {} };

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function(filename) { return Module['read'](filename, true) };
  Module['load'] = function(f) {
    globalEval(read(f));
  };
  Module['arguments'] = process['argv'].slice(2);
  module.exports = Module;
}
if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  Module['read'] = read;
  Module['readBinary'] = function(f) {
    return read(f, 'binary');
  };
  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  this['Module'] = Module;
}
if (ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER) {
  Module['print'] = function(x) {
    console.log(x);
  };
  Module['printErr'] = function(x) {
    console.log(x);
  };
  this['Module'] = Module;
}
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
}
if (ENVIRONMENT_IS_WORKER) {
  // We can do very little here...
  var TRY_USE_DUMP = false;
  Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
    dump(x);
  }) : (function(x) {
    // self.postMessage(x); // enable this if you want stdout to be sent as messages
  }));
  Module['load'] = importScripts;
}
if (!ENVIRONMENT_IS_WORKER && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_SHELL) {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] && Module['read']) {
  Module['load'] = function(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      var logg = log2(quantum);
      return '((((' +target + ')+' + (quantum-1) + ')>>' + logg + ')<<' + logg + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type, quantumSize) {
    if (Runtime.QUANTUM_SIZE == 1) return 1;
    var size = {
      '%i1': 1,
      '%i8': 1,
      '%i16': 2,
      '%i32': 4,
      '%i64': 8,
      "%float": 4,
      "%double": 8
    }['%'+type]; // add '%' since float and double confuse Closure compiler as keys, and also spidermonkey as a compiler will remove 's from '_i8' etc
    if (!size) {
      if (type.charAt(type.length-1) == '*') {
        size = Runtime.QUANTUM_SIZE; // A pointer
      } else if (type[0] == 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 == 0);
        size = bits/8;
      }
    }
    return size;
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          alignSize = type.alignSize || QUANTUM_SIZE;
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else {
        throw 'Unclear type in struct: ' + field + ', in ' + type.name_ + ' :: ' + dump(Types.types[type.name_]);
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2 + 2*i;
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xff;
      if (needed) {
        buffer.push(code);
        needed--;
      }
      if (buffer.length == 0) {
        if (code < 128) return String.fromCharCode(code);
        buffer.push(code);
        if (code > 191 && code < 224) {
          needed = 1;
        } else {
          needed = 2;
        }
        return '';
      }
      if (needed > 0) return '';
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var ret;
      if (c1 > 191 && c1 < 224) {
        ret = String.fromCharCode(((c1 & 31) << 6) | (c2 & 63));
      } else {
        ret = String.fromCharCode(((c1 & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = ((((STACKTOP)+7)>>3)<<3); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = ((((STATICTOP)+7)>>3)<<3); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = ((((DYNAMICTOP)+7)>>3)<<3); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+(((low)>>>(0))))+((+(((high)>>>(0))))*(+(4294967296)))) : ((+(((low)>>>(0))))+((+(((high)|(0))))*(+(4294967296))))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length+1);
      writeStringToMemory(value, ret);
      return ret;
    } else if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,((Math.min((+(Math.floor((value)/(+(4294967296))))), (+(4294967295))))|0)>>>0],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return ((x+4095)>>12)<<12;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value, or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 131072;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 4194304;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(!!Int32Array && !!Float64Array && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyTracking = {};
var calledInit = false, calledRun = false;
var runDependencyWatcher = null;
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
    if (!calledRun && shouldRunNow) run();
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
function loadMemoryInitializer(filename) {
  function applyData(data) {
    HEAPU8.set(data, STATIC_BASE);
  }
  // always do this asynchronously, to keep shell and web as similar as possible
  addOnPreRun(function() {
    if (ENVIRONMENT_IS_NODE || ENVIRONMENT_IS_SHELL) {
      applyData(Module['readBinary'](filename));
    } else {
      Browser.asyncLoad(filename, function(data) {
        applyData(data);
      }, function(data) {
        throw 'could not load memory initializer ' + filename;
      });
    }
  });
}
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 47432;
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } });
var _stderr;
var ___progname;
var __ZTVN10__cxxabiv120__si_class_type_infoE;
var __ZTVN10__cxxabiv119__pointer_type_infoE;
var __ZTVN10__cxxabiv117__class_type_infoE;
var __ZTIy;
var __ZTIx;
var __ZTIt;
var __ZTIs;
var __ZTIm;
var __ZTIl;
var __ZTIj;
var __ZTIi;
var __ZTIh;
var __ZTIf;
var __ZTIe;
var __ZTId;
var __ZTIc;
var __ZTIa;
var __ZN10ime_pinyin11DictBuilderC1Ev;
var __ZN10ime_pinyin11DictBuilderD1Ev;
var __ZN10ime_pinyin8DictTrieC1Ev;
var __ZN10ime_pinyin8DictTrieD1Ev;
var __ZN10ime_pinyin12MatrixSearchC1Ev;
var __ZN10ime_pinyin12MatrixSearchD1Ev;
var __ZN10ime_pinyin5NGramC1Ev;
var __ZN10ime_pinyin5NGramD1Ev;
var __ZN10ime_pinyin12SpellingTrieC1Ev;
var __ZN10ime_pinyin12SpellingTrieD1Ev;
var __ZN10ime_pinyin4SyncC1Ev;
var __ZN10ime_pinyin4SyncD1Ev;
var __ZN10ime_pinyin8DictListC1Ev;
var __ZN10ime_pinyin8DictListD1Ev;
var __ZN10ime_pinyin8LpiCacheC1Ev;
var __ZN10ime_pinyin8LpiCacheD1Ev;
var __ZN10ime_pinyin13SpellingTableC1Ev;
var __ZN10ime_pinyin13SpellingTableD1Ev;
var __ZN10ime_pinyin14SpellingParserC1Ev;
var __ZN10ime_pinyin8UserDictC1Ev;
var __ZN10ime_pinyin8UserDictD1Ev;
var __ZN10ime_pinyin11Utf16ReaderC1Ev;
var __ZN10ime_pinyin11Utf16ReaderD1Ev;
var __ZNSt9type_infoD1Ev;
var __ZNSt8bad_castC1Ev;
var __ZNSt8bad_castD1Ev;
var __ZNSt10bad_typeidC1Ev;
var __ZNSt10bad_typeidD1Ev;
var __ZN10__cxxabiv116__shim_type_infoD1Ev;
var __ZN10__cxxabiv123__fundamental_type_infoD1Ev;
var __ZN10__cxxabiv123__fundamental_type_infoD2Ev;
var __ZN10__cxxabiv117__array_type_infoD1Ev;
var __ZN10__cxxabiv117__array_type_infoD2Ev;
var __ZN10__cxxabiv120__function_type_infoD1Ev;
var __ZN10__cxxabiv120__function_type_infoD2Ev;
var __ZN10__cxxabiv116__enum_type_infoD1Ev;
var __ZN10__cxxabiv116__enum_type_infoD2Ev;
var __ZN10__cxxabiv117__class_type_infoD1Ev;
var __ZN10__cxxabiv117__class_type_infoD2Ev;
var __ZN10__cxxabiv120__si_class_type_infoD1Ev;
var __ZN10__cxxabiv120__si_class_type_infoD2Ev;
var __ZN10__cxxabiv121__vmi_class_type_infoD1Ev;
var __ZN10__cxxabiv121__vmi_class_type_infoD2Ev;
var __ZN10__cxxabiv117__pbase_type_infoD1Ev;
var __ZN10__cxxabiv117__pbase_type_infoD2Ev;
var __ZN10__cxxabiv119__pointer_type_infoD1Ev;
var __ZN10__cxxabiv119__pointer_type_infoD2Ev;
var __ZN10__cxxabiv129__pointer_to_member_type_infoD1Ev;
var __ZN10__cxxabiv129__pointer_to_member_type_infoD2Ev;
var __ZNSt9bad_allocC1Ev;
var __ZNSt9bad_allocD1Ev;
var __ZNSt20bad_array_new_lengthC1Ev;
var __ZNSt20bad_array_new_lengthD1Ev;
var __ZNSt20bad_array_new_lengthD2Ev;
var _err;
var _errx;
var _warn;
var _warnx;
var _verr;
var _verrx;
var _vwarn;
var _vwarnx;
var _stderr = _stderr=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,248,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTVN10__cxxabiv119__pointer_type_infoE=allocate([0,0,0,0,24,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,56,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIy=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIx=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIt=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIs=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIm=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIl=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIj=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIi=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIh=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIf=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIe=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTId=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIc=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTIa=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* memory initializer */ allocate([45,44,32,0,0,0,0,0,45,44,32,0,0,0,0,0,45,44,32,0,0,0,0,0,45,44,32,0,0,0,0,0,45,44,32,0,0,0,0,0,91,114,111,111,116,32,105,115,32,108,97,121,101,114,32,45,49,93,0,0,0,0,0,0,10,45,45,45,45,45,45,45,45,45,45,45,45,83,84,65,84,32,73,78,70,79,45,45,45,45,45,45,45,45,45,45,45,45,45,0,0,0,0,0,111,112,116,105,111,110,32,114,101,113,117,105,114,101,115,32,97,110,32,97,114,103,117,109,101,110,116,32,45,45,32,37,115,0,0,0,0,0,0,0,111,112,116,105,111,110,32,114,101,113,117,105,114,101,115,32,97,110,32,97,114,103,117,109,101,110,116,32,45,45,32,37,99,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,89,64,0,0,0,0,0,136,195,64,0,0,0,0,132,215,151,65,0,128,224,55,121,195,65,67,23,110,5,181,181,184,147,70,245,249,63,233,3,79,56,77,50,29,48,249,72,119,130,90,60,191,115,127,221,79,21,117,64,181,0,0,0,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,0,0,0,0,111,112,116,105,111,110,32,100,111,101,115,110,39,116,32,116,97,107,101,32,97,110,32,97,114,103,117,109,101,110,116,32,45,45,32,37,46,42,115,0,117,110,107,110,111,119,110,32,111,112,116,105,111,110,32,45,45,32,37,115,0,0,0,0,117,110,107,110,111,119,110,32,111,112,116,105,111,110,32,45,45,32,37,99,0,0,0,0,255,255,255,255,0,0,0,0,97,109,98,105,103,117,111,117,115,32,111,112,116,105,111,110,32,45,45,32,37,46,42,115,0,0,0,0,0,0,0,0,32,77,105,108,101,83,116,111,110,101,58,32,37,120,44,32,37,120,10,0,0,0,0,0,78,85,76,76,32,33,61,32,100,101,112,32,38,38,32,102,114,111,109,95,104,97,110,100,108,101,32,62,32,48,32,38,38,32,102,114,111,109,95,104,97,110,100,108,101,32,60,32,109,105,108,101,95,115,116,111,110,101,115,95,112,111,115,95,0,0,0,0,0,0,0,0,37,115,58,32,0,0,0,0,102,111,117,110,100,95,110,117,109,32,43,32,49,32,60,32,109,97,120,95,115,112,108,105,100,115,0,0,0,0,0,0,83,104,0,0,0,0,0,0,108,109,97,95,102,114,101,113,95,105,100,120,95,0,0,0,100,108,95,115,117,99,99,101,115,115,0,0,0,0,0,0,45,45,45,37,100,10,0,0,115,111,110,45,62,115,112,108,95,105,100,120,32,62,61,32,105,100,95,115,116,97,114,116,32,38,38,32,115,111,110,45,62,115,112,108,95,105,100,120,32,60,32,105,100,95,115,116,97,114,116,32,43,32,105,100,95,110,117,109,0,0,0,0,78,85,76,76,32,33,61,32,104,122,95,102,111,117,110,100,32,38,38,32,104,97,110,122,105,32,61,61,32,42,104,122,95,102,111,117,110,100,0,0,67,104,0,0,0,0,0,0,102,114,101,113,95,99,111,100,101,115,95,0,0,0,0,0,48,32,33,61,32,110,117,109,0,0,0,0,0,0,0,0,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,37,100,39,116,104,32,68,77,73,32,110,111,100,101,32,98,101,103,105,110,45,45,45,45,45,45,45,45,45,45,45,62,10,0,0,0,0,0,0,49,32,61,61,32,110,111,100,101,45,62,115,111,110,95,49,115,116,95,111,102,102,0,0,104,122,115,95,108,101,110,32,60,61,32,107,77,97,120,80,114,101,100,105,99,116,83,105,122,101,32,38,38,32,104,122,115,95,108,101,110,32,62,32,48,0,0,0,0,0,0,0,37,115,0,0,0,0,0,0,102,114,101,113,95,99,111,100,101,115,95,100,102,95,0,0,49,32,61,61,32,115,112,108,95,105,100,120,95,110,117,109,0,0,0,0,0,0,0,0,115,112,108,95,105,100,95,102,114,32,60,61,32,107,77,97,120,76,101,109,109,97,83,105,122,101,0,0,0,0,0,0,78,85,76,76,32,33,61,32,100,101,112,32,38,38,32,48,32,61,61,32,102,114,111,109,95,104,97,110,100,108,101,0,105,100,95,110,117,109,32,61,61,32,115,116,97,114,116,95,105,100,95,91,107,77,97,120,76,101,109,109,97,83,105,122,101,93,0,0,0,0,0,0,115,111,110,95,112,111,115,32,43,32,49,32,61,61,32,110,117,109,95,111,102,95,115,111,110,0,0,0,0,0,0,0,102,114,101,113,115,91,112,111,115,93,32,62,32,48,0,0,117,116,102,49,54,95,115,116,114,108,101,110,40,116,111,107,101,110,41,32,60,61,32,107,77,97,120,80,105,110,121,105,110,83,105,122,101,0,0,0,116,109,112,32,61,61,32,108,109,97,95,108,101,110,0,0,48,32,61,61,32,100,101,112,45,62,115,112,108,105,100,115,95,101,120,116,101,110,100,101,100,0,0,0,0,0,0,0,46,46,47,115,104,97,114,101,47,109,97,116,114,105,120,115,101,97,114,99,104,46,99,112,112,0,0,0,0,0,0,0,80,79,83,73,88,76,89,95,67,79,82,82,69,67,84,0,99,117,114,114,101,110,116,95,112,111,115,32,61,61,32,115,116,97,114,116,95,112,111,115,95,91,107,77,97,120,76,101,109,109,97,83,105,122,101,93,0,0,0,0,0,0,0,0,105,115,95,118,97,108,105,100,95,115,112,108,95,99,104,97,114,40,99,104,97,114,95,99,117,114,114,101,110,116,41,0,105,100,120,95,110,111,119,32,43,32,49,32,61,61,32,110,101,120,116,95,105,100,120,95,117,110,117,115,101,100,0,0,78,85,76,76,32,33,61,32,116,111,107,101,110,0,0,0,99,95,112,104,114,97,115,101,95,46,108,101,110,103,116,104,32,62,32,48,32,38,38,32,99,95,112,121,95,108,101,110,32,61,61,32,99,95,112,104,114,97,115,101,95,46,115,112,108,95,115,116,97,114,116,91,99,95,112,104,114,97,115,101,95,46,115,117,98,108,109,97,95,115,116,97,114,116,91,99,95,112,104,114,97,115,101,95,46,115,117,98,108,109,97,95,110,117,109,93,93,0,0,0,114,98,0,0,0,0,0,0,115,99,105,115,95,110,117,109,95,32,61,61,32,115,99,105,115,95,110,117,109,0,0,0,40,99,104,97,114,95,102,111,114,95,110,111,100,101,32,62,61,32,39,65,39,41,32,38,38,32,40,99,104,97,114,95,102,111,114,95,110,111,100,101,32,60,61,32,39,90,39,32,124,124,32,39,104,39,32,61,61,32,99,104,97,114,95,102,111,114,95,110,111,100,101,41,0,0,0,0,0,0,0,0,108,101,109,109,97,95,97,114,114,91,112,111,115,93,46,105,100,120,95,98,121,95,104,122,32,61,61,32,105,100,120,95,110,111,119,0,0,0,0,0,109,111,118,101,95,112,111,115,32,62,32,48,0,0,0,0,98,95,97,99,95,116,109,112,0,0,0,0,0,0,0,0,119,98,0,0,0,0,0,0,46,46,32,116,111,116,97,108,32,108,101,109,109,97,32,110,111,100,101,32,110,117,109,98,101,114,58,32,37,108,100,10,0,0,0,0,0,0,0,0,115,116,97,116,105,99,95,99,97,115,116,60,115,105,122,101,95,116,62,40,115,112,108,105,100,32,45,32,107,70,117,108,108,83,112,108,73,100,83,116,97,114,116,41,32,60,32,98,117,102,95,115,105,122,101,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,109,97,120,32,115,121,115,116,101,109,32,98,121,116,101,115,32,61,32,37,49,48,108,117,10,0,0,0,0,0,0,0,46,46,32,115,111,110,32,98,117,102,32,97,108,108,111,99,97,116,105,111,110,32,110,117,109,98,101,114,32,119,105,116,104,32,109,111,114,101,32,116,104,97,110,32,49,32,115,111,110,58,32,37,108,100,10,0,102,97,108,115,101,0,0,0,78,85,76,76,32,33,61,32,105,110,115,116,97,110,99,101,95,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,0,0,99,117,114,114,101,110,116,95,104,122,95,108,101,110,32,62,61,32,108,97,115,116,95,104,122,95,108,101,110,0,0,0,46,46,32,115,111,110,32,98,117,102,32,97,108,108,111,99,97,116,105,111,110,32,110,117,109,98,101,114,32,119,105,116,104,32,111,110,108,121,32,49,32,115,111,110,58,32,37,108,100,10,0,0,0,0,0,0,121,109,95,105,100,32,62,32,48,0,0,0,0,0,0,0,105,116,101,109,95,110,117,109,91,99,111,100,101,93,32,62,32,48,0,0,0,0,0,0,46,46,32,116,111,116,97,108,95,104,111,109,111,95,110,117,109,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,48,44,32,0,0,0,0,0,114,98,0,0,0,0,0,0,46,46,32,116,111,116,97,108,95,110,111,100,101,95,105,110,95,115,111,110,98,117,102,95,97,108,108,110,111,115,111,110,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,0,42,102,111,117,110,100,32,61,61,32,104,122,0,0,0,0,108,109,97,95,98,117,102,91,114,101,109,97,105,110,95,110,117,109,32,45,32,49,93,46,104,97,110,122,105,32,61,61,32,108,109,97,95,98,117,102,91,112,111,115,93,46,104,97,110,122,105,0,0,0,0,0,119,43,0,0,0,0,0,0,46,46,32,116,111,116,97,108,95,115,111,110,98,117,102,95,97,108,108,110,111,115,111,110,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,0,114,101,109,97,105,110,95,110,117,109,32,62,32,48,0,0,46,46,32,116,111,116,97,108,95,115,111,110,98,117,102,95,110,117,109,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,0,0,0,0,0,0,108,112,115,105,95,110,117,109,32,62,32,110,117,109,0,0,46,46,32,116,111,116,97,108,95,110,111,100,101,95,104,97,115,115,111,110,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,49,44,32,0,0,78,85,76,76,32,33,61,32,109,116,114,120,95,110,100,0,46,46,47,115,104,97,114,101,47,115,112,101,108,108,105,110,103,116,97,98,108,101,46,99,112,112,0,0,0,0,0,0,46,46,32,116,111,116,97,108,95,115,111,110,95,110,117,109,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,0,100,109,105,95,99,95,112,104,114,97,115,101,95,0,0,0,108,109,97,95,115,116,97,114,116,95,91,102,105,120,101,100,95,108,109,97,115,95,93,32,61,61,32,102,105,120,101,100,95,104,122,115,95,0,0,0,46,46,47,115,104,97,114,101,47,108,112,105,99,97,99,104,101,46,99,112,112,0,0,0,115,112,108,95,116,114,105,101,95,45,62,105,115,95,104,97,108,102,95,105,100,40,115,112,108,105,100,41,0,0,0,0,46,46,32,109,97,120,95,104,111,109,111,98,117,102,95,108,101,110,32,112,101,114,32,108,97,121,101,114,58,10,32,32,32,45,44,32,0,0,0,0,108,109,97,95,105,100,95,110,117,109,95,32,43,32,102,105,120,101,100,95,108,109,97,115,95,32,45,32,112,111,115,32,45,32,49,32,62,61,32,112,111,115,0,0,0,0,0,0,108,109,97,95,110,111,100,101,95,110,117,109,95,108,101,48,95,32,60,61,32,98,117,102,95,115,105,122,101,0,0,0,37,115,58,32,0,0,0,0,105,110,32,117,115,101,32,98,121,116,101,115,32,32,32,32,32,61,32,37,49,48,108,117,10,0,0,0,0,0,0,0,46,46,47,115,104,97,114,101,47,117,115,101,114,100,105,99,116,46,99,112,112,0,0,0,112,104,114,97,115,101,95,108,101,110,32,62,32,48,0,0,97,118,101,114,97,103,101,95,115,99,111,114,101,32,60,61,32,50,53,53,0,0,0,0,78,85,76,76,32,33,61,32,108,112,105,95,99,97,99,104,101,95,108,101,110,95,0,0,108,101,109,109,97,95,97,114,114,91,48,93,46,105,100,120,95,98,121,95,104,122,32,61,61,32,49,0,0,0,0,0,37,115,10,0,0,0,0,0,37,108,100,44,32,0,0,0,112,104,114,97,115,101,95,108,101,110,32,61,61,32,108,109,97,95,115,116,97,114,116,95,91,102,105,120,101,100,95,108,109,97,115,95,93,0,0,0,115,117,99,101,115,115,0,0,46,46,47,115,104,97,114,101,47,100,105,99,116,108,105,115,116,46,99,112,112,0,0,0,99,98,95,110,101,119,0,0,37,115,10,0,0,0,0,0,46,46,32,109,97,120,95,115,111,110,98,117,102,95,108,101,110,32,112,101,114,32,108,97,121,101,114,40,102,114,111,109,32,108,97,121,101,114,32,48,41,58,10,32,32,32,0,0,108,109,97,95,108,101,110,32,61,61,32,108,109,97,95,115,116,97,114,116,95,91,112,111,115,32,43,32,49,93,32,45,32,108,109,97,95,115,116,97,114,116,95,91,112,111,115,93,0,0,0,0,0,0,0,0,42,110,117,109,32,62,61,32,49,0,0,0,0,0,0,0,111,108,100,114,111,119,32,62,61,32,100,109,105,45,62,115,112,108,115,116,114,95,108,101,110,0,0,0,0,0,0,0,100,101,112,95,45,62,105,100,95,110,117,109,32,62,32,48,0,0,0,0,0,0,0,0,99,97,110,100,95,115,112,108,105,100,115,95,116,104,105,115,32,62,32,48,0,0,0,0,37,115,58,32,0,0,0,0,115,111,110,95,112,111,115,32,43,32,49,32,61,61,32,112,97,114,101,110,116,95,115,111,110,95,110,117,109,0,0,0,48,32,61,61,32,112,114,101,118,95,105,100,115,95,110,117,109,0,0,0,0,0,0,0,40,33,97,114,103,95,118,97,108,105,100,32,38,38,32,115,112,108,105,100,115,95,109,97,120,32,62,61,32,108,109,97,95,108,101,110,41,32,124,124,32,108,109,97,95,108,101,110,32,61,61,32,115,112,108,105,100,115,95,109,97,120,0,0,104,111,109,111,95,110,117,109,32,60,61,32,50,53,53,0,78,85,76,76,32,33,61,32,101,110,100,95,110,111,100,101,0,0,0,0,0,0,0,0,110,111,100,101,95,115,111,110,45,62,115,112,108,95,105,100,120,32,62,61,32,105,100,95,115,116,97,114,116,32,38,38,32,110,111,100,101,95,115,111,110,45,62,115,112,108,95,105,100,120,32,60,32,105,100,95,115,116,97,114,116,32,43,32,105,100,95,110,117,109,0,0,104,111,109,111,95,110,117,109,32,60,61,32,54,53,53,51,53,0,0,0,0,0,0,0,46,46,47,115,104,97,114,101,47,115,112,101,108,108,105,110,103,116,114,105,101,46,99,112,112,0,0,0,0,0,0,0,98,0,0,0,0,0,0,0,110,111,100,101,32,61,61,32,114,111,111,116,95,32,38,38,32,49,32,61,61,32,110,111,100,101,95,102,114,95,110,117,109,0,0,0,0,0,0,0,115,112,108,95,115,116,97,114,116,95,91,102,105,120,101,100,95,104,122,115,95,93,32,61,61,32,102,105,120,101,100,95,99,104,95,112,111,115,0,0,37,115,58,32,0,0,0,0,112,97,114,101,110,116,95,115,111,110,95,110,117,109,32,60,61,32,50,53,53,0,0,0,115,116,101,112,95,116,111,95,100,109,105,95,102,114,32,33,61,32,115,116,97,116,105,99,95,99,97,115,116,60,80,111,111,108,80,111,115,84,121,112,101,62,40,45,49,41,0,0,105,100,95,110,117,109,32,62,32,48,0,0,0,0,0,0,98,97,100,95,97,114,114,97,121,95,110,101,119,95,108,101,110,103,116,104,0,0,0,0,112,97,114,101,110,116,95,115,111,110,95,110,117,109,32,60,61,32,54,53,53,51,53,0,99,97,110,100,95,108,101,110,32,62,32,48,0,0,0,0,46,46,47,115,104,97,114,101,47,100,105,99,116,116,114,105,101,46,99,112,112,0,0,0,110,111,100,101,95,103,101,49,45,62,115,111,110,95,49,115,116,95,111,102,102,95,108,32,62,32,48,32,124,124,32,110,111,100,101,95,103,101,49,45,62,115,111,110,95,49,115,116,95,111,102,102,95,104,32,62,32,48,0,0,0,0,0,0,115,121,115,116,101,109,32,98,121,116,101,115,32,32,32,32,32,61,32,37,49,48,108,117,10,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,116,121,112,101,105,100,0,108,101,118,101,108,32,60,32,107,77,97,120,76,101,109,109,97,83,105,122,101,0,0,0,114,98,0,0,0,0,0,0,115,99,111,114,101,32,62,61,32,48,0,0,0,0,0,0,60,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,37,100,39,116,104,32,68,77,73,32,110,111,100,101,32,101,110,100,45,45,45,45,45,45,45,45,45,45,45,45,45,45,10,10,0,0,0,0,0,78,85,76,76,32,33,61,32,108,112,105,95,99,97,99,104,101,95,0,0,0,0,0,0,110,111,100,101,95,108,101,48,45,62,115,111,110,95,49,115,116,95,111,102,102,32,60,61,32,108,109,97,95,110,111,100,101,95,110,117,109,95,103,101,49,95,0,0,0,0,0,0,78,85,76,76,32,33,61,32,115,116,114,0,0,0,0,0,108,97,115,116,95,104,122,95,108,101,110,32,62,32,48,0,46,46,47,115,104,97,114,101,47,110,103,114,97,109,46,99,112,112,0,0,0,0,0,0,102,111,117,110,100,0,0,0,58,32,0,0,0,0,0,0,32,84,111,116,97,108,32,80,105,110,121,105,110,32,76,101,110,58,32,37,100,10,0,0,104,50,102,95,110,117,109,95,91,42,115,112,108,105,100,93,32,62,32,48,0,0,0,0,110,111,100,101,45,62,115,111,110,95,49,115,116,95,111,102,102,95,108,32,62,32,48,32,124,124,32,110,111,100,101,45,62,115,111,110,95,49,115,116,95,111,102,102,95,104,32,62,32,48,0,0,0,0,0,0,115,116,97,116,105,99,95,99,97,115,116,60,115,105,122,101,95,116,62,40,102,111,117,110,100,32,45,32,98,117,102,95,41,32,62,61,32,115,116,97,114,116,95,112,111,115,95,91,115,116,114,95,108,101,110,32,45,32,49,93,0,0,0,0,105,116,101,109,95,110,117,109,0,0,0,0,0,0,0,0,58,32,0,0,0,0,0,0,78,85,76,76,32,33,61,32,100,105,99,116,95,116,114,105,101,45,62,108,109,97,95,105,100,120,95,98,117,102,95,0,32,83,112,101,108,108,105,110,103,32,58,32,37,115,44,32,37,100,10,0,0,0,0,0,110,111,100,101,45,62,115,111,110,95,49,115,116,95,111,102,102,32,60,61,32,108,109,97,95,110,111,100,101,95,110,117,109,95,103,101,49,95,0,0,102,111,117,110,100,32,62,32,98,117,102,95,0,0,0,0,90,104,0,0,0,0,0,0,78,85,76,76,32,33,61,32,100,105,99,116,95,116,114,105,101,45,62,114,111,111,116,95,0,0,0,0,0,0,0,0,46,46,47,115,104,97,114,101,47,100,105,99,116,98,117,105,108,100,101,114,46,99,112,112,0,0,0,0,0,0,0,0,114,98,0,0,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,83,112,101,108,108,105,110,103,84,114,105,101,58,58,105,102,95,118,97,108,105,100,95,105,100,95,117,112,100,97,116,101,40,117,105,110,116,49,54,32,42,41,32,99,111,110,115,116,0,0,0,0,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,85,115,101,114,68,105,99,116,58,58,114,101,99,108,97,105,109,40,41,0,0,0,0,105,109,101,95,112,105,110,121,105,110,58,58,76,112,105,67,97,99,104,101,58,58,76,112,105,67,97,99,104,101,40,41,0,0,0,0,0,0,0,0,115,116,97,116,105,99,32,105,109,101,95,112,105,110,121,105,110,58,58,76,112,105,67,97,99,104,101,32,38,105,109,101,95,112,105,110,121,105,110,58,58,76,112,105,67,97,99,104,101,58,58,103,101,116,95,105,110,115,116,97,110,99,101,40,41,0,0,0,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,108,111,97,100,95,100,105,99,116,40,70,73,76,69,32,42,41,0,0,0,0,118,105,114,116,117,97,108,32,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,103,101,116,95,108,112,105,115,40,99,111,110,115,116,32,117,105,110,116,49,54,32,42,44,32,117,105,110,116,49,54,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,41,0,0,0,0,0,118,105,114,116,117,97,108,32,117,105,110,116,49,54,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,103,101,116,95,108,101,109,109,97,95,115,112,108,105,100,115,40,76,101,109,109,97,73,100,84,121,112,101,44,32,117,105,110,116,49,54,32,42,44,32,117,105,110,116,49,54,44,32,98,111,111,108,41,0,0,0,0,0,0,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,101,120,116,101,110,100,95,100,105,99,116,50,40,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,44,32,99,111,110,115,116,32,68,105,99,116,69,120,116,80,97,114,97,32,42,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,32,42,41,0,0,0,0,0,0,0,0,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,101,120,116,101,110,100,95,100,105,99,116,49,40,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,44,32,99,111,110,115,116,32,68,105,99,116,69,120,116,80,97,114,97,32,42,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,32,42,41,0,0,0,0,0,0,0,0,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,101,120,116,101,110,100,95,100,105,99,116,48,40,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,44,32,99,111,110,115,116,32,68,105,99,116,69,120,116,80,97,114,97,32,42,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,32,42,41,0,0,0,0,0,0,0,0,118,105,114,116,117,97,108,32,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,101,120,116,101,110,100,95,100,105,99,116,40,77,105,108,101,83,116,111,110,101,72,97,110,100,108,101,44,32,99,111,110,115,116,32,68,105,99,116,69,120,116,80,97,114,97,32,42,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,32,42,41,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,58,58,116,114,121,95,101,120,116,101,110,100,40,99,111,110,115,116,32,117,105,110,116,49,54,32,42,44,32,117,105,110,116,49,54,44,32,76,101,109,109,97,73,100,84,121,112,101,41,0,0,0,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,102,105,108,108,95,115,99,105,115,40,99,111,110,115,116,32,105,109,101,95,112,105,110,121,105,110,58,58,83,105,110,103,108,101,67,104,97,114,73,116,101,109,32,42,44,32,115,105,122,101,95,116,41,0,0,0,0,0,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,102,105,108,108,95,108,105,115,116,40,99,111,110,115,116,32,105,109,101,95,112,105,110,121,105,110,58,58,76,101,109,109,97,69,110,116,114,121,32,42,44,32,115,105,122,101,95,116,41,0,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,112,114,101,100,105,99,116,40,99,111,110,115,116,32,99,104,97,114,49,54,32,42,44,32,117,105,110,116,49,54,44,32,78,80,114,101,100,105,99,116,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,41,0,0,0,0,117,105,110,116,49,54,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,103,101,116,95,115,112,108,105,100,115,95,102,111,114,95,104,97,110,122,105,40,99,104,97,114,49,54,44,32,117,105,110,116,49,54,44,32,117,105,110,116,49,54,32,42,44,32,117,105,110,116,49,54,41,0,0,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,99,111,110,118,101,114,116,95,116,111,95,115,99,105,115,95,105,100,115,40,99,104,97,114,49,54,32,42,44,32,117,105,110,116,49,54,41,0,0,0,0,0,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,99,111,110,118,101,114,116,95,116,111,95,104,97,110,122,105,115,40,99,104,97,114,49,54,32,42,44,32,117,105,110,116,49,54,41,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,99,97,108,99,117,108,97,116,101,95,115,105,122,101,40,99,111,110,115,116,32,105,109,101,95,112,105,110,121,105,110,58,58,76,101,109,109,97,69,110,116,114,121,32,42,44,32,115,105,122,101,95,116,41,0,0,0,0,0,76,101,109,109,97,73,100,84,121,112,101,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,76,105,115,116,58,58,103,101,116,95,108,101,109,109,97,95,105,100,40,99,111,110,115,116,32,99,104,97,114,49,54,32,42,44,32,117,105,110,116,49,54,41,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,78,71,114,97,109,58,58,98,117,105,108,100,95,117,110,105,103,114,97,109,40,105,109,101,95,112,105,110,121,105,110,58,58,76,101,109,109,97,69,110,116,114,121,32,42,44,32,115,105,122,101,95,116,44,32,76,101,109,109,97,73,100,84,121,112,101,41,0,0,0,0,100,111,117,98,108,101,32,105,109,101,95,112,105,110,121,105,110,58,58,114,101,99,97,108,99,117,108,97,116,101,95,107,101,114,110,101,108,40,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,100,111,117,98,108,101,32,42,44,32,67,79,68,69,66,79,79,75,95,84,89,80,69,32,42,41,0,0,0,0,0,0,99,111,110,115,116,32,99,104,97,114,32,42,105,109,101,95,112,105,110,121,105,110,58,58,83,112,101,108,108,105,110,103,84,97,98,108,101,58,58,97,114,114,97,110,103,101,40,115,105,122,101,95,116,32,42,44,32,115,105,122,101,95,116,32,42,41,0,0,0,0,0,0,105,109,101,95,112,105,110,121,105,110,58,58,83,112,101,108,108,105,110,103,78,111,100,101,32,42,105,109,101,95,112,105,110,121,105,110,58,58,83,112,101,108,108,105,110,103,84,114,105,101,58,58,99,111,110,115,116,114,117,99,116,95,115,112,101,108,108,105,110,103,115,95,115,117,98,115,101,116,40,115,105,122,101,95,116,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,44,32,105,109,101,95,112,105,110,121,105,110,58,58,83,112,101,108,108,105,110,103,78,111,100,101,32,42,41,0,0,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,83,112,101,108,108,105,110,103,84,114,105,101,58,58,98,117,105,108,100,95,121,109,95,105,110,102,111,40,41,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,100,101,108,115,101,97,114,99,104,40,115,105,122,101,95,116,44,32,98,111,111,108,44,32,98,111,111,108,41,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,103,101,116,95,108,112,105,115,40,99,111,110,115,116,32,117,105,110,116,49,54,32,42,44,32,115,105,122,101,95,116,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,99,111,110,115,116,32,99,104,97,114,49,54,32,42,44,32,98,111,111,108,41,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,99,104,111,111,115,101,40,115,105,122,101,95,116,41,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,97,100,100,95,108,109,97,95,116,111,95,117,115,101,114,100,105,99,116,40,117,105,110,116,49,54,44,32,117,105,110,116,49,54,44,32,102,108,111,97,116,41,0,0,0,0,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,99,97,110,99,101,108,95,108,97,115,116,95,99,104,111,105,99,101,40,41,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,109,101,114,103,101,95,102,105,120,101,100,95,108,109,97,115,40,115,105,122,101,95,116,41,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,103,101,116,95,115,112,108,95,115,116,97,114,116,95,105,100,40,41,0,0,0,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,97,100,100,95,99,104,97,114,95,113,119,101,114,116,121,40,41,0,0,0,0,0,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,101,120,116,101,110,100,95,109,116,114,120,95,110,100,40,77,97,116,114,105,120,78,111,100,101,32,42,44,32,76,109,97,80,115,98,73,116,101,109,32,42,44,32,115,105,122,101,95,116,44,32,80,111,111,108,80,111,115,84,121,112,101,44,32,115,105,122,101,95,116,41,0,0,0,0,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,114,101,115,101,116,95,115,101,97,114,99,104,40,115,105,122,101,95,116,44,32,98,111,111,108,44,32,98,111,111,108,44,32,98,111,111,108,41,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,101,120,116,101,110,100,95,100,109,105,95,99,40,68,105,99,116,69,120,116,80,97,114,97,32,42,44,32,68,105,99,116,77,97,116,99,104,73,110,102,111,32,42,41,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,77,97,116,114,105,120,83,101,97,114,99,104,58,58,101,120,116,101,110,100,95,100,109,105,40,68,105,99,116,69,120,116,80,97,114,97,32,42,44,32,68,105,99,116,77,97,116,99,104,73,110,102,111,32,42,41,0,0,0,0,0,99,104,97,114,49,54,32,42,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,114,101,97,100,95,118,97,108,105,100,95,104,97,110,122,105,115,40,99,111,110,115,116,32,99,104,97,114,32,42,44,32,115,105,122,101,95,116,32,42,41,0,0,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,104,122,95,105,110,95,104,97,110,122,105,115,95,108,105,115,116,40,99,111,110,115,116,32,99,104,97,114,49,54,32,42,44,32,115,105,122,101,95,116,44,32,99,104,97,114,49,54,41,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,99,111,110,115,116,114,117,99,116,95,115,117,98,115,101,116,40,118,111,105,100,32,42,44,32,105,109,101,95,112,105,110,121,105,110,58,58,76,101,109,109,97,69,110,116,114,121,32,42,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,44,32,115,105,122,101,95,116,41,0,0,0,0,0,0,0,0,118,111,105,100,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,103,101,116,95,116,111,112,95,108,101,109,109,97,115,40,41,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,114,101,97,100,95,114,97,119,95,100,105,99,116,40,99,111,110,115,116,32,99,104,97,114,32,42,44,32,99,111,110,115,116,32,99,104,97,114,32,42,44,32,115,105,122,101,95,116,41,0,0,0,0,0,0,0,115,105,122,101,95,116,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,98,117,105,108,100,95,115,99,105,115,40,41,0,0,0,0,98,111,111,108,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,66,117,105,108,100,101,114,58,58,98,117,105,108,100,95,100,105,99,116,40,99,111,110,115,116,32,99,104,97,114,32,42,44,32,99,111,110,115,116,32,99,104,97,114,32,42,44,32,105,109,101,95,112,105,110,121,105,110,58,58,68,105,99,116,84,114,105,101,32,42,41,0,0,0,0,32,183,0,0,0,0,0,0,0,0,0,0,200,38,0,0,62,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,38,0,0,38,0,0,0,84,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,38,0,0,98,0,0,0,50,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,38,0,0,38,0,0,0,82,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,39,0,0,26,0,0,0,78,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,41,0,0,30,0,0,0,2,0,0,0,2,0,0,0,14,0,0,0,12,0,0,0,2,0,0,0,2,0,0,0,10,0,0,0,20,0,0,0,4,0,0,0,8,0,0,0,2,0,0,0,6,0,0,0,8,0,0,0,30,0,0,0,16,0,0,0,48,0,0,0,16,0,0,0,10,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,41,0,0,68,0,0,0,12,0,0,0,12,0,0,0,8,0,0,0,18,0,0,0,10,0,0,0,4,0,0,0,6,0,0,0,14,0,0,0,12,0,0,0,6,0,0,0,8,0,0,0,18,0,0,0,10,0,0,0,42,0,0,0,4,0,0,0,28,0,0,0,6,0,0,0,8,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,41,0,0,74,0,0,0,34,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,41,0,0,88,0,0,0,60,0,0,0,94,0,0,0,22,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,41,0,0,88,0,0,0,24,0,0,0,94,0,0,0,22,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,41,0,0,88,0,0,0,106,0,0,0,94,0,0,0,22,0,0,0,10,0,0,0,4,0,0,0,4,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,42,0,0,88,0,0,0,46,0,0,0,94,0,0,0,22,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,42,0,0,88,0,0,0,70,0,0,0,94,0,0,0,22,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,42,0,0,88,0,0,0,20,0,0,0,94,0,0,0,22,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,42,0,0,88,0,0,0,72,0,0,0,94,0,0,0,22,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,42,0,0,88,0,0,0,100,0,0,0,94,0,0,0,22,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,119,0,0,0,0,0,0,0,118,0,0,0,0,0,0,0,116,0,0,0,0,0,0,0,115,0,0,0,0,0,0,0,109,0,0,0,0,0,0,0,108,0,0,0,0,0,0,0,106,0,0,0,0,0,0,0,105,0,0,0,0,0,0,0,104,0,0,0,0,0,0,0,102,0,0,0,0,0,0,0,101,0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,99,0,0,0,0,0,0,0,98,0,0,0,0,0,0,0,97,0,0,0,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,83,116,56,98,97,100,95,99,97,115,116,0,0,0,0,0,83,116,50,48,98,97,100,95,97,114,114,97,121,95,110,101,119,95,108,101,110,103,116,104,0,0,0,0,0,0,0,0,83,116,49,48,98,97,100,95,116,121,112,101,105,100,0,0,80,121,0,0,0,0,0,0,80,120,0,0,0,0,0,0,80,119,0,0,0,0,0,0,80,118,0,0,0,0,0,0,80,116,0,0,0,0,0,0,80,115,0,0,0,0,0,0,80,109,0,0,0,0,0,0,80,108,0,0,0,0,0,0,80,106,0,0,0,0,0,0,80,105,0,0,0,0,0,0,80,104,0,0,0,0,0,0,80,102,0,0,0,0,0,0,80,101,0,0,0,0,0,0,80,100,0,0,0,0,0,0,80,99,0,0,0,0,0,0,80,98,0,0,0,0,0,0,80,97,0,0,0,0,0,0,80,75,121,0,0,0,0,0,80,75,120,0,0,0,0,0,80,75,119,0,0,0,0,0,80,75,118,0,0,0,0,0,80,75,116,0,0,0,0,0,80,75,115,0,0,0,0,0,80,75,109,0,0,0,0,0,80,75,108,0,0,0,0,0,80,75,106,0,0,0,0,0,80,75,105,0,0,0,0,0,80,75,104,0,0,0,0,0,80,75,102,0,0,0,0,0,80,75,101,0,0,0,0,0,80,75,100,0,0,0,0,0,80,75,99,0,0,0,0,0,80,75,98,0,0,0,0,0,80,75,97,0,0,0,0,0,80,75,68,115,0,0,0,0,80,75,68,110,0,0,0,0,80,75,68,105,0,0,0,0,80,68,115,0,0,0,0,0,80,68,110,0,0,0,0,0,80,68,105,0,0,0,0,0,78,49,48,105,109,101,95,112,105,110,121,105,110,56,85,115,101,114,68,105,99,116,69,0,78,49,48,105,109,101,95,112,105,110,121,105,110,56,68,105,99,116,84,114,105,101,69,0,78,49,48,105,109,101,95,112,105,110,121,105,110,49,50,65,116,111,109,68,105,99,116,66,97,115,101,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,57,95,95,112,111,105,110,116,101,114,95,116,111,95,109,101,109,98,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,51,95,95,102,117,110,100,97,109,101,110,116,97,108,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,102,117,110,99,116,105,111,110,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,97,114,114,97,121,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,101,110,117,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,68,115,0,0,0,0,0,0,68,110,0,0,0,0,0,0,68,105,0,0,0,0,0,0,56,33,0,0,96,34,0,0,56,33,0,0,104,34,0,0,56,33,0,0,200,34,0,0,0,0,0,0,216,34,0,0,0,0,0,0,232,34,0,0,0,0,0,0,248,34,0,0,208,38,0,0,0,0,0,0,0,0,0,0,8,35,0,0,208,38,0,0,0,0,0,0,0,0,0,0,24,35,0,0,216,38,0,0,0,0,0,0,0,0,0,0,56,35,0,0,208,38,0,0,0,0,0,0,0,0,0,0,72,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,35,0,0,0,0,0,0,176,38,0,0,0,0,0,0,96,35,0,0,0,0,0,0,184,38,0,0,0,0,0,0,104,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,35,0,0,0,0,0,0,0,0,0,0].concat([0,0,0,0,192,35,0,0,0,0,0,0,192,38,0,0,0,0,0,0,200,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,35,0,0,1,0,0,0,0,0,0,0,0,0,0,0,216,35,0,0,1,0,0,0,0,0,0,0,0,0,0,0,224,35,0,0,1,0,0,0,176,38,0,0,0,0,0,0,232,35,0,0,1,0,0,0,184,38,0,0,0,0,0,0,240,35,0,0,1,0,0,0,0,0,0,0,0,0,0,0,248,35,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,8,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,16,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,24,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,32,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,40,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,48,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,56,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,64,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,72,36,0,0,1,0,0,0,192,38,0,0,0,0,0,0,80,36,0,0,1,0,0,0,0,0,0,0,0,0,0,0,88,36,0,0,1,0,0,0,120,42,0,0,0,0,0,0,96,36,0,0,1,0,0,0,128,42,0,0,0,0,0,0,104,36,0,0,1,0,0,0,136,42,0,0,0,0,0,0,112,36,0,0,0,0,0,0,120,42,0,0,0,0,0,0,120,36,0,0,0,0,0,0,128,42,0,0,0,0,0,0,128,36,0,0,0,0,0,0,136,42,0,0,0,0,0,0,136,36,0,0,192,41,0,0,0,0,0,0,96,33,0,0,160,36,0,0,0,0,0,0,1,0,0,0,192,41,0,0,0,0,0,0,0,0,0,0,184,36,0,0,0,0,0,0,216,36,0,0,40,42,0,0,0,0,0,0,0,0,0,0,8,37,0,0,88,42,0,0,0,0,0,0,0,0,0,0,48,37,0,0,56,42,0,0,0,0,0,0,0,0,0,0,88,37,0,0,56,42,0,0,0,0,0,0,0,0,0,0,128,37,0,0,88,42,0,0,0,0,0,0,0,0,0,0,168,37,0,0,40,42,0,0,0,0,0,0,0,0,0,0,208,37,0,0,88,42,0,0,0,0,0,0,0,0,0,0,248,37,0,0,88,42,0,0,0,0,0,0,0,0,0,0,32,38,0,0,88,42,0,0,0,0,0,0,0,0,0,0,72,38,0,0,200,38,0,0,0,0,0,0,0,0,0,0,112,38,0,0,88,42,0,0,0,0,0,0,56,33,0,0,152,38,0,0,56,33,0,0,160,38,0,0,56,33,0,0,168,38,0,0,72,77,0,0,0,0,0,72,78,71,0,0,0,0,78,71,0,0,0,0,0,0,0,0,48,65,66,67,99,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,115,84,85,86,87,88,89,90,122,0,0,2,1,1,1,2,1,1,1,0,1,1,1,1,1,2,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0,128,48,0,0,128,32,14,0,128,32,200,3,128,32,8,250,128,32,8,130,0,0,192,224,240,248,252,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  function ___gxx_personality_v0() {
    }
  Module["_strcpy"] = _strcpy;
  function _llvm_umul_with_overflow_i32(x, y) {
      x = x>>>0;
      y = y>>>0;
      return ((asm["setTempRet0"](x*y > 4294967295),(x*y)>>>0)|0);
    }
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i32=_memset;
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:35,EIDRM:36,ECHRNG:37,EL2NSYNC:38,EL3HLT:39,EL3RST:40,ELNRNG:41,EUNATCH:42,ENOCSI:43,EL2HLT:44,EDEADLK:45,ENOLCK:46,EBADE:50,EBADR:51,EXFULL:52,ENOANO:53,EBADRQC:54,EBADSLT:55,EDEADLOCK:56,EBFONT:57,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:74,ELBIN:75,EDOTDOT:76,EBADMSG:77,EFTYPE:79,ENOTUNIQ:80,EBADFD:81,EREMCHG:82,ELIBACC:83,ELIBBAD:84,ELIBSCN:85,ELIBMAX:86,ELIBEXEC:87,ENOSYS:88,ENMFILE:89,ENOTEMPTY:90,ENAMETOOLONG:91,ELOOP:92,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:106,EPROTOTYPE:107,ENOTSOCK:108,ENOPROTOOPT:109,ESHUTDOWN:110,ECONNREFUSED:111,EADDRINUSE:112,ECONNABORTED:113,ENETUNREACH:114,ENETDOWN:115,ETIMEDOUT:116,EHOSTDOWN:117,EHOSTUNREACH:118,EINPROGRESS:119,EALREADY:120,EDESTADDRREQ:121,EMSGSIZE:122,EPROTONOSUPPORT:123,ESOCKTNOSUPPORT:124,EADDRNOTAVAIL:125,ENETRESET:126,EISCONN:127,ENOTCONN:128,ETOOMANYREFS:129,EPROCLIM:130,EUSERS:131,EDQUOT:132,ESTALE:133,ENOTSUP:134,ENOMEDIUM:135,ENOSHARE:136,ECASECLASH:137,EILSEQ:138,EOVERFLOW:139,ECANCELED:140,ENOTRECOVERABLE:141,EOWNERDEAD:142,ESTRPIPE:143};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  var __impure_ptr=allocate(1, "i32*", ALLOC_STATIC);var FS={currentPath:"/",nextInode:2,streams:[null],ignorePermissions:true,createFileHandle:function (stream, fd) {
        if (typeof stream === 'undefined') {
          stream = null;
        }
        if (!fd) {
          if (stream && stream.socket) {
            for (var i = 1; i < 64; i++) {
              if (!FS.streams[i]) {
                fd = i;
                break;
              }
            }
            assert(fd, 'ran out of low fds for sockets');
          } else {
            fd = Math.max(FS.streams.length, 64);
            for (var i = FS.streams.length; i < fd; i++) {
              FS.streams[i] = null; // Keep dense
            }
          }
        }
        // Close WebSocket first if we are about to replace the fd (i.e. dup2)
        if (FS.streams[fd] && FS.streams[fd].socket && FS.streams[fd].socket.close) {
          FS.streams[fd].socket.close();
        }
        FS.streams[fd] = stream;
        return fd;
      },removeFileHandle:function (fd) {
        FS.streams[fd] = null;
      },joinPath:function (parts, forceRelative) {
        var ret = parts[0];
        for (var i = 1; i < parts.length; i++) {
          if (ret[ret.length-1] != '/') ret += '/';
          ret += parts[i];
        }
        if (forceRelative && ret[0] == '/') ret = ret.substr(1);
        return ret;
      },absolutePath:function (relative, base) {
        if (typeof relative !== 'string') return null;
        if (base === undefined) base = FS.currentPath;
        if (relative && relative[0] == '/') base = '';
        var full = base + '/' + relative;
        var parts = full.split('/').reverse();
        var absolute = [''];
        while (parts.length) {
          var part = parts.pop();
          if (part == '' || part == '.') {
            // Nothing.
          } else if (part == '..') {
            if (absolute.length > 1) absolute.pop();
          } else {
            absolute.push(part);
          }
        }
        return absolute.length == 1 ? '/' : absolute.join('/');
      },analyzePath:function (path, dontResolveLastLink, linksVisited) {
        var ret = {
          isRoot: false,
          exists: false,
          error: 0,
          name: null,
          path: null,
          object: null,
          parentExists: false,
          parentPath: null,
          parentObject: null
        };
        path = FS.absolutePath(path);
        if (path == '/') {
          ret.isRoot = true;
          ret.exists = ret.parentExists = true;
          ret.name = '/';
          ret.path = ret.parentPath = '/';
          ret.object = ret.parentObject = FS.root;
        } else if (path !== null) {
          linksVisited = linksVisited || 0;
          path = path.slice(1).split('/');
          var current = FS.root;
          var traversed = [''];
          while (path.length) {
            if (path.length == 1 && current.isFolder) {
              ret.parentExists = true;
              ret.parentPath = traversed.length == 1 ? '/' : traversed.join('/');
              ret.parentObject = current;
              ret.name = path[0];
            }
            var target = path.shift();
            if (!current.isFolder) {
              ret.error = ERRNO_CODES.ENOTDIR;
              break;
            } else if (!current.read) {
              ret.error = ERRNO_CODES.EACCES;
              break;
            } else if (!current.contents.hasOwnProperty(target)) {
              ret.error = ERRNO_CODES.ENOENT;
              break;
            }
            current = current.contents[target];
            if (current.link && !(dontResolveLastLink && path.length == 0)) {
              if (linksVisited > 40) { // Usual Linux SYMLOOP_MAX.
                ret.error = ERRNO_CODES.ELOOP;
                break;
              }
              var link = FS.absolutePath(current.link, traversed.join('/'));
              ret = FS.analyzePath([link].concat(path).join('/'),
                                   dontResolveLastLink, linksVisited + 1);
              return ret;
            }
            traversed.push(target);
            if (path.length == 0) {
              ret.exists = true;
              ret.path = traversed.join('/');
              ret.object = current;
            }
          }
        }
        return ret;
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },createObject:function (parent, name, properties, canRead, canWrite) {
        if (!parent) parent = '/';
        if (typeof parent === 'string') parent = FS.findObject(parent);
        if (!parent) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent path must exist.');
        }
        if (!parent.isFolder) {
          ___setErrNo(ERRNO_CODES.ENOTDIR);
          throw new Error('Parent must be a folder.');
        }
        if (!parent.write && !FS.ignorePermissions) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent folder must be writeable.');
        }
        if (!name || name == '.' || name == '..') {
          ___setErrNo(ERRNO_CODES.ENOENT);
          throw new Error('Name must not be empty.');
        }
        if (parent.contents.hasOwnProperty(name)) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          throw new Error("Can't overwrite object.");
        }
        parent.contents[name] = {
          read: canRead === undefined ? true : canRead,
          write: canWrite === undefined ? false : canWrite,
          timestamp: Date.now(),
          inodeNumber: FS.nextInode++
        };
        for (var key in properties) {
          if (properties.hasOwnProperty(key)) {
            parent.contents[name][key] = properties[key];
          }
        }
        return parent.contents[name];
      },createFolder:function (parent, name, canRead, canWrite) {
        var properties = {isFolder: true, isDevice: false, contents: {}};
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createPath:function (parent, path, canRead, canWrite) {
        var current = FS.findObject(parent);
        if (current === null) throw new Error('Invalid parent.');
        path = path.split('/').reverse();
        while (path.length) {
          var part = path.pop();
          if (!part) continue;
          if (!current.contents.hasOwnProperty(part)) {
            FS.createFolder(current, part, canRead, canWrite);
          }
          current = current.contents[part];
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        properties.isFolder = false;
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createDataFile:function (parent, name, data, canRead, canWrite) {
        if (typeof data === 'string') {
          var dataArray = new Array(data.length);
          for (var i = 0, len = data.length; i < len; ++i) dataArray[i] = data.charCodeAt(i);
          data = dataArray;
        }
        var properties = {
          isDevice: false,
          contents: data.subarray ? data.subarray(0) : data // as an optimization, create a new array wrapper (not buffer) here, to help JS engines understand this object
        };
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          var LazyUint8Array = function() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile) {
        Browser.init();
        var fullname = FS.joinPath([parent, name], true);
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },createLink:function (parent, name, target, canRead, canWrite) {
        var properties = {isDevice: false, link: target};
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createDevice:function (parent, name, input, output) {
        if (!(input || output)) {
          throw new Error('A device must have at least one callback defined.');
        }
        var ops = {isDevice: true, input: input, output: output};
        return FS.createFile(parent, name, ops, Boolean(input), Boolean(output));
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },staticInit:function () {
        // The main file system tree. All the contents are inside this.
        FS.root = {
          read: true,
          write: true,
          isFolder: true,
          isDevice: false,
          timestamp: Date.now(),
          inodeNumber: 1,
          contents: {}
        };
        // Create the temporary folder, if not already created
        try {
          FS.createFolder('/', 'tmp', true, true);
        } catch(e) {}
        FS.createFolder('/', 'dev', true, true);
      },init:function (input, output, error) {
        // Make sure we initialize only once.
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        input = input || Module['stdin'];
        output = output || Module['stdout'];
        error = error || Module['stderr'];
        // Default handlers.
        var stdinOverridden = true, stdoutOverridden = true, stderrOverridden = true;
        if (!input) {
          stdinOverridden = false;
          input = function() {
            if (!input.cache || !input.cache.length) {
              var result;
              if (typeof window != 'undefined' &&
                  typeof window.prompt == 'function') {
                // Browser.
                result = window.prompt('Input: ');
                if (result === null) result = String.fromCharCode(0); // cancel ==> EOF
              } else if (typeof readline == 'function') {
                // Command line.
                result = readline();
              }
              if (!result) result = '';
              input.cache = intArrayFromString(result + '\n', true);
            }
            return input.cache.shift();
          };
        }
        var utf8 = new Runtime.UTF8Processor();
        function createSimpleOutput() {
          var fn = function (val) {
            if (val === null || val === 10) {
              fn.printer(fn.buffer.join(''));
              fn.buffer = [];
            } else {
              fn.buffer.push(utf8.processCChar(val));
            }
          };
          return fn;
        }
        if (!output) {
          stdoutOverridden = false;
          output = createSimpleOutput();
        }
        if (!output.printer) output.printer = Module['print'];
        if (!output.buffer) output.buffer = [];
        if (!error) {
          stderrOverridden = false;
          error = createSimpleOutput();
        }
        if (!error.printer) error.printer = Module['printErr'];
        if (!error.buffer) error.buffer = [];
        // Create the I/O devices.
        var stdin = FS.createDevice('/dev', 'stdin', input);
        stdin.isTerminal = !stdinOverridden;
        var stdout = FS.createDevice('/dev', 'stdout', null, output);
        stdout.isTerminal = !stdoutOverridden;
        var stderr = FS.createDevice('/dev', 'stderr', null, error);
        stderr.isTerminal = !stderrOverridden;
        FS.createDevice('/dev', 'tty', input, output);
        FS.createDevice('/dev', 'null', function(){}, function(){});
        // Create default streams.
        FS.streams[1] = {
          path: '/dev/stdin',
          object: stdin,
          position: 0,
          isRead: true,
          isWrite: false,
          isAppend: false,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[2] = {
          path: '/dev/stdout',
          object: stdout,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[3] = {
          path: '/dev/stderr',
          object: stderr,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          error: false,
          eof: false,
          ungotten: []
        };
        // TODO: put these low in memory like we used to assert on: assert(Math.max(_stdin, _stdout, _stderr) < 15000); // make sure these are low, we flatten arrays with these
        HEAP32[((_stdin)>>2)]=1;
        HEAP32[((_stdout)>>2)]=2;
        HEAP32[((_stderr)>>2)]=3;
        // Other system paths
        FS.createPath('/', 'dev/shm/tmp', true, true); // temp files
        // Newlib initialization
        for (var i = FS.streams.length; i < Math.max(_stdin, _stdout, _stderr) + 4; i++) {
          FS.streams[i] = null; // Make sure to keep FS.streams dense
        }
        FS.streams[_stdin] = FS.streams[1];
        FS.streams[_stdout] = FS.streams[2];
        FS.streams[_stderr] = FS.streams[3];
        allocate([ allocate(
          [0, 0, 0, 0, _stdin, 0, 0, 0, _stdout, 0, 0, 0, _stderr, 0, 0, 0],
          'void*', ALLOC_NORMAL) ], 'void*', ALLOC_NONE, __impure_ptr);
      },quit:function () {
        if (!FS.init.initialized) return;
        // Flush any partially-printed lines in stdout and stderr. Careful, they may have been closed
        if (FS.streams[2] && FS.streams[2].object.output.buffer.length > 0) FS.streams[2].object.output(10);
        if (FS.streams[3] && FS.streams[3].object.output.buffer.length > 0) FS.streams[3].object.output(10);
      },standardizePath:function (path) {
        if (path.substr(0, 2) == './') path = path.substr(2);
        return path;
      },deleteFile:function (path) {
        path = FS.analyzePath(path);
        if (!path.parentExists || !path.exists) {
          throw 'Invalid path ' + path;
        }
        delete path.parentObject.contents[path.name];
      }};
      Module['FS'] = FS;
  var ___dirent_struct_layout={__size__:1040,d_ino:0,d_name:4,d_off:1028,d_reclen:1032,d_type:1036};function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      // NOTE: This implementation tries to mimic glibc rather than strictly
      // following the POSIX standard.
      var mode = HEAP32[((varargs)>>2)];
      // Simplify flags.
      var accessMode = oflag & 3;
      var isWrite = accessMode != 0;
      var isRead = accessMode != 1;
      var isCreate = Boolean(oflag & 512);
      var isExistCheck = Boolean(oflag & 2048);
      var isTruncate = Boolean(oflag & 1024);
      var isAppend = Boolean(oflag & 8);
      // Verify path.
      var origPath = path;
      path = FS.analyzePath(Pointer_stringify(path));
      if (!path.parentExists) {
        ___setErrNo(path.error);
        return -1;
      }
      var target = path.object || null;
      var finalPath;
      // Verify the file exists, create if needed and allowed.
      if (target) {
        if (isCreate && isExistCheck) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          return -1;
        }
        if ((isWrite || isTruncate) && target.isFolder) {
          ___setErrNo(ERRNO_CODES.EISDIR);
          return -1;
        }
        if (isRead && !target.read || isWrite && !target.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        }
        if (isTruncate && !target.isDevice) {
          target.contents = [];
        } else {
          if (!FS.forceLoadFile(target)) {
            ___setErrNo(ERRNO_CODES.EIO);
            return -1;
          }
        }
        finalPath = path.path;
      } else {
        if (!isCreate) {
          ___setErrNo(ERRNO_CODES.ENOENT);
          return -1;
        }
        if (!path.parentObject.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        }
        target = FS.createDataFile(path.parentObject, path.name, [],
                                   mode & 0x100, mode & 0x80);  // S_IRUSR, S_IWUSR.
        finalPath = path.parentPath + '/' + path.name;
      }
      // Actually create an open stream.
      var id;
      if (target.isFolder) {
        var entryBuffer = 0;
        if (___dirent_struct_layout) {
          entryBuffer = _malloc(___dirent_struct_layout.__size__);
        }
        var contents = [];
        for (var key in target.contents) contents.push(key);
        id = FS.createFileHandle({
          path: finalPath,
          object: target,
          // An index into contents. Special values: -2 is ".", -1 is "..".
          position: -2,
          isRead: true,
          isWrite: false,
          isAppend: false,
          error: false,
          eof: false,
          ungotten: [],
          // Folder-specific properties:
          // Remember the contents at the time of opening in an array, so we can
          // seek between them relying on a single order.
          contents: contents,
          // Each stream has its own area for readdir() returns.
          currentEntry: entryBuffer
        });
      } else {
        id = FS.createFileHandle({
          path: finalPath,
          object: target,
          position: 0,
          isRead: isRead,
          isWrite: isWrite,
          isAppend: isAppend,
          error: false,
          eof: false,
          ungotten: []
        });
      }
      return id;
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 512;
        flags |= 1024;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 512;
        flags |= 8;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var ret = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return (ret == -1) ? 0 : ret;
    }
  function _recv(fd, buf, len, flags) {
      var info = FS.streams[fd];
      if (!info) return -1;
      if (!info.hasData()) {
        ___setErrNo(ERRNO_CODES.EAGAIN); // no data, and all sockets are nonblocking, so this is the right behavior
        return -1;
      }
      var buffer = info.inQueue.shift();
      if (len < buffer.length) {
        if (info.stream) {
          // This is tcp (reliable), so if not all was read, keep it
          info.inQueue.unshift(buffer.subarray(len));
        }
        buffer = buffer.subarray(0, len);
      }
      HEAPU8.set(buffer, buf);
      return buffer.length;
    }
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else if (offset >= stream.object.contents.length) {
        return 0;
      } else {
        var bytesRead = 0;
        var contents = stream.object.contents;
        var size = Math.min(contents.length - offset, nbyte);
        assert(size >= 0);
        if (contents.subarray) { // typed array
          HEAPU8.set(contents.subarray(offset, offset+size), buf);
        } else
        if (contents.slice) { // normal array
          for (var i = 0; i < size; i++) {
            HEAP8[(((buf)+(i))|0)]=contents[offset + i]
          }
        } else {
          for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
            HEAP8[(((buf)+(i))|0)]=contents.get(offset + i)
          }
        }
        bytesRead += size;
        return bytesRead;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (stream && ('socket' in stream)) {
        return _recv(fildes, buf, nbyte, 0);
      } else if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead;
        if (stream.object.isDevice) {
          if (stream.object.input) {
            bytesRead = 0;
            for (var i = 0; i < nbyte; i++) {
              try {
                var result = stream.object.input();
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
              if (result === undefined && bytesRead === 0) {
                ___setErrNo(ERRNO_CODES.EAGAIN);
                return -1;
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              HEAP8[(((buf)+(i))|0)]=result
            }
            return bytesRead;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          bytesRead = _pread(fildes, buf, nbyte, stream.position);
          assert(bytesRead >= -1);
          if (bytesRead != -1) {
            stream.position += bytesRead;
          }
          return bytesRead;
        }
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) {
        return 0;
      }
      var bytesRead = 0;
      var streamObj = FS.streams[stream];
      while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[((ptr++)|0)]=streamObj.ungotten.pop()
        bytesToRead--;
        bytesRead++;
      }
      var err = _read(stream, ptr, bytesToRead);
      if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      }
      bytesRead += err;
      if (bytesRead < bytesToRead) streamObj.eof = true;
      return Math.floor(bytesRead / size);
    }
  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      if (FS.streams[fildes]) {
        if (FS.streams[fildes].currentEntry) {
          _free(FS.streams[fildes].currentEntry);
        }
        FS.streams[fildes] = null;
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      if (FS.streams[fildes]) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      _fsync(stream);
      return _close(stream);
    }
  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      if (FS.streams[fildes] && !FS.streams[fildes].object.isDevice) {
        var stream = FS.streams[fildes];
        var position = offset;
        if (whence === 1) {  // SEEK_CUR.
          position += stream.position;
        } else if (whence === 2) {  // SEEK_END.
          position += stream.object.contents.length;
        }
        if (position < 0) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        } else {
          stream.ungotten = [];
          stream.position = position;
          return position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var ret = _lseek(stream, offset, whence);
      if (ret == -1) {
        return -1;
      } else {
        FS.streams[stream].eof = false;
        return 0;
      }
    }
  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      if (FS.streams[stream]) {
        stream = FS.streams[stream];
        if (stream.object.isDevice) {
          ___setErrNo(ERRNO_CODES.ESPIPE);
          return -1;
        } else {
          return stream.position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  function ___assert_func(filename, line, func, condition) {
      throw 'Assertion failed: ' + (condition ? Pointer_stringify(condition) : 'unknown condition') + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + new Error().stack;
    }
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }function __ZSt9terminatev() {
      _exit(-1234);
    }
  Module["_strlen"] = _strlen;
  function _send(fd, buf, len, flags) {
      var info = FS.streams[fd];
      if (!info) return -1;
      info.sender(HEAPU8.subarray(buf, buf+len));
      return len;
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var contents = stream.object.contents;
        while (contents.length < offset) contents.push(0);
        for (var i = 0; i < nbyte; i++) {
          contents[offset + i] = HEAPU8[(((buf)+(i))|0)];
        }
        stream.object.timestamp = Date.now();
        return i;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (stream && ('socket' in stream)) {
          return _send(fildes, buf, nbyte, 0);
      } else if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        if (stream.object.isDevice) {
          if (stream.object.output) {
            for (var i = 0; i < nbyte; i++) {
              try {
                stream.object.output(HEAP8[(((buf)+(i))|0)]);
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
            }
            stream.object.timestamp = Date.now();
            return i;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var bytesWritten = _pwrite(fildes, buf, nbyte, stream.position);
          if (bytesWritten != -1) stream.position += bytesWritten;
          return bytesWritten;
        }
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (flagAlwaysSigned) {
                if (currArg < 0) {
                  prefix = '-' + prefix;
                } else {
                  prefix = '+' + prefix;
                }
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (flagAlwaysSigned && currArg >= 0) {
                  argText = '+' + argText;
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }function _printf(format, varargs) {
      // int printf(const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var stdout = HEAP32[((_stdout)>>2)];
      return _fprintf(stdout, format, varargs);
    }
  var _llvm_memset_p0i8_i64=_memset;
  function _fputs(s, stream) {
      // int fputs(const char *restrict s, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputs.html
      return _write(stream, s, _strlen(s));
    }
  function _fputc(c, stream) {
      // int fputc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputc.html
      var chr = unSign(c & 0xFF);
      HEAP8[((_fputc.ret)|0)]=chr
      var ret = _write(stream, _fputc.ret, 1);
      if (ret == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return -1;
      } else {
        return chr;
      }
    }function _puts(s) {
      // int puts(const char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/puts.html
      // NOTE: puts() always writes an extra newline.
      var stdout = HEAP32[((_stdout)>>2)];
      var ret = _fputs(s, stdout);
      if (ret < 0) {
        return ret;
      } else {
        var newlineRet = _fputc(10, stdout);
        return (newlineRet < 0) ? -1 : ret + 1;
      }
    }
  function _putchar(c) {
      // int putchar(int c);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/putchar.html
      return _fputc(c, HEAP32[((_stdout)>>2)]);
    }
  function _fdopen(fildes, mode) {
      // FILE *fdopen(int fildes, const char *mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fdopen.html
      if (FS.streams[fildes]) {
        var stream = FS.streams[fildes];
        mode = Pointer_stringify(mode);
        if ((mode.indexOf('w') != -1 && !stream.isWrite) ||
            (mode.indexOf('r') != -1 && !stream.isRead) ||
            (mode.indexOf('a') != -1 && !stream.isAppend) ||
            (mode.indexOf('+') != -1 && (!stream.isRead || !stream.isWrite))) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return 0;
        } else {
          stream.error = false;
          stream.eof = false;
          return fildes;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0;
      }
    }
  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }

  function _qsort2(base, num, size, cmp) {
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var keys = [];

      for (var i = 0; i < num; i++) {
        keys.push(HEAP32[(base + i * size) >> 2]);
      }

      keys.sort(function(a, b) {
        return a - b;
      });

      // apply the sort
      for (var i = 0; i < num; i++) {
        HEAP32[(base+i*size >> 2)] = keys[i];
      }
    }

  function _qsort(base, num, size, cmp) {
      if (num == 0 || size == 0) return;
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var keys = [];
      for (var i = 0; i < num; i++) keys.push(i);
      keys.sort(function(a, b) {
        return Module['dynCall_iii'](cmp, base+a*size, base+b*size);
      });
      // apply the sort
      var temp = _malloc(num*size);
      _memcpy(temp, base, num*size);
      for (var i = 0; i < num; i++) {
        if (keys[i] == i) continue; // already in place
        _memcpy(base+i*size, temp+keys[i]*size, size);
      }
      _free(temp);
    }
  var _fabs=Math.abs;
  var _log=Math.log;
  function _strncmp(px, py, n) {
      var i = 0;
      while (i < n) {
        var x = HEAPU8[(((px)+(i))|0)];
        var y = HEAPU8[(((py)+(i))|0)];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
      return 0;
    }function _strcmp(px, py) {
      return _strncmp(px, py, TOTAL_MEMORY);
    }
  function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }
  function _strdup(ptr) {
      var len = _strlen(ptr);
      var newStr = _malloc(len + 1);
      (_memcpy(newStr, ptr, len)|0);
      HEAP8[(((newStr)+(len))|0)]=0;
      return newStr;
    }
  function _bsearch(key, base, num, size, compar) {
      var cmp = function(x, y) {
        return Module['dynCall_iii'](compar, x, y);
      };
      var left = 0;
      var right = num;
      var mid, test, addr;
      while (left < right) {
        mid = (left + right) >>> 1;
        addr = base + (mid * size);
        test = cmp(key, addr);
        if (test < 0) {
          right = mid;
        } else if (test > 0) {
          left = mid + 1;
        } else {
          return addr;
        }
      }
      return 0;
    }
  var _sqrt=Math.sqrt;
  Module["_strncpy"] = _strncpy;
  function _gettimeofday(ptr) {
      // %struct.timeval = type { i32, i32 }
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  Module["_memcmp"] = _memcmp;
  function _unlink(path) {
      // int unlink(const char *path);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/unlink.html
      path = Pointer_stringify(path);
      path = FS.analyzePath(path, true);
      if (!path.parentExists || !path.exists) {
        ___setErrNo(path.error);
        return -1;
      } else if (path.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EPERM);
        return -1;
      } else if (!path.parentObject.write) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else {
        delete path.parentObject.contents[path.name];
        return 0;
      }
    }
  function _ferror(stream) {
      // int ferror(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ferror.html
      return Number(FS.streams[stream] && FS.streams[stream].error);
    }
  function _feof(stream) {
      // int feof(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/feof.html
      return Number(FS.streams[stream] && FS.streams[stream].eof);
    }
  function _truncate(path, length) {
      // int truncate(const char *path, off_t length);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/truncate.html
      // NOTE: The path argument may be a string, to simplify ftruncate().
      if (length < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        if (typeof path !== 'string') path = Pointer_stringify(path);
        var target = FS.findObject(path);
        if (target === null) return -1;
        if (target.isFolder) {
          ___setErrNo(ERRNO_CODES.EISDIR);
          return -1;
        } else if (target.isDevice) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        } else if (!target.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        } else {
          var contents = target.contents;
          if (length < contents.length) contents.length = length;
          else while (length > contents.length) contents.push(0);
          target.timestamp = Date.now();
          return 0;
        }
      }
    }function _ftruncate(fildes, length) {
      // int ftruncate(int fildes, off_t length);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftruncate.html
      if (FS.streams[fildes] && FS.streams[fildes].isWrite) {
        return _truncate(FS.streams[fildes].path, length);
      } else if (FS.streams[fildes]) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  Module["_memmove"] = _memmove;var _llvm_memmove_p0i8_p0i8_i32=_memmove;
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  function _abort() {
      Module['abort']();
    }
  function ___errno_location() {
      return ___errno_state;
    }var ___errno=___errno_location;
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 8: return PAGE_SIZE;
        case 54:
        case 56:
        case 21:
        case 61:
        case 63:
        case 22:
        case 67:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 69:
        case 28:
        case 101:
        case 70:
        case 71:
        case 29:
        case 30:
        case 199:
        case 75:
        case 76:
        case 32:
        case 43:
        case 44:
        case 80:
        case 46:
        case 47:
        case 45:
        case 48:
        case 49:
        case 42:
        case 82:
        case 33:
        case 7:
        case 108:
        case 109:
        case 107:
        case 112:
        case 119:
        case 121:
          return 200809;
        case 13:
        case 104:
        case 94:
        case 95:
        case 34:
        case 35:
        case 77:
        case 81:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 91:
        case 94:
        case 95:
        case 110:
        case 111:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 120:
        case 40:
        case 16:
        case 79:
        case 19:
          return -1;
        case 92:
        case 93:
        case 5:
        case 72:
        case 6:
        case 74:
        case 92:
        case 93:
        case 96:
        case 97:
        case 98:
        case 99:
        case 102:
        case 103:
        case 105:
          return 1;
        case 38:
        case 66:
        case 50:
        case 51:
        case 4:
          return 1024;
        case 15:
        case 64:
        case 41:
          return 32;
        case 55:
        case 37:
        case 17:
          return 2147483647;
        case 18:
        case 1:
          return 47839;
        case 59:
        case 57:
          return 99;
        case 68:
        case 58:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 14: return 32768;
        case 73: return 32767;
        case 39: return 16384;
        case 60: return 1000;
        case 106: return 700;
        case 52: return 256;
        case 62: return 255;
        case 2: return 100;
        case 65: return 64;
        case 36: return 20;
        case 100: return 16;
        case 20: return 6;
        case 53: return 4;
        case 10: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }
  function ___resumeException(ptr) {
      if (HEAP32[((_llvm_eh_exception.buf)>>2)] == 0) HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr;
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }function ___cxa_find_matching_catch(thrown, throwntype) {
      if (thrown == -1) thrown = HEAP32[((_llvm_eh_exception.buf)>>2)];
      if (throwntype == -1) throwntype = HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)];
      var typeArray = Array.prototype.slice.call(arguments, 2);
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  function ___cxa_call_unexpected(exception) {
      Module.printErr('Unexpected exception thrown, this is not properly supported - aborting');
      ABORT = true;
      throw exception;
    }
  function ___cxa_begin_catch(ptr) {
      __ZSt18uncaught_exceptionv.uncaught_exception--;
      return ptr;
    }
  function ___cxa_free_exception(ptr) {
      try {
        return _free(ptr);
      } catch(e) { // XXX FIXME
      }
    }function ___cxa_end_catch() {
      if (___cxa_end_catch.rethrown) {
        ___cxa_end_catch.rethrown = false;
        return;
      }
      // Clear state flag.
      asm['setThrew'](0);
      // Clear type.
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=0
      // Call destructor if one is registered then clear it.
      var ptr = HEAP32[((_llvm_eh_exception.buf)>>2)];
      var destructor = HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)];
      if (destructor) {
        Runtime.dynCall('vi', destructor, [ptr]);
        HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=0
      }
      // Free ptr if it isn't null.
      if (ptr) {
        ___cxa_free_exception(ptr);
        HEAP32[((_llvm_eh_exception.buf)>>2)]=0
      }
    }
  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = 'root';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/emscripten';
        ENV['LANG'] = 'en_US.UTF-8';
        ENV['_'] = './this.program';
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        for (var j = 0; j < line.length; j++) {
          HEAP8[(((poolPtr)+(j))|0)]=line.charCodeAt(j);
        }
        HEAP8[(((poolPtr)+(j))|0)]=0;
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }
  function _strchr(ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = HEAP8[(ptr)];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }
  var _llvm_va_start=undefined;
  function _llvm_va_end() {}
  function _vfprintf(s, f, va_arg) {
      return _fprintf(s, f, HEAP32[((va_arg)>>2)]);
    }
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"No message of desired type",36:"Identifier removed",37:"Channel number out of range",38:"Level 2 not synchronized",39:"Level 3 halted",40:"Level 3 reset",41:"Link number out of range",42:"Protocol driver not attached",43:"No CSI structure available",44:"Level 2 halted",45:"Deadlock condition",46:"No record locks available",50:"Invalid exchange",51:"Invalid request descriptor",52:"Exchange full",53:"No anode",54:"Invalid request code",55:"Invalid slot",56:"File locking deadlock error",57:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",74:"Multihop attempted",75:"Inode is remote (not really error)",76:"Cross mount point (not really error)",77:"Trying to read unreadable message",79:"Inappropriate file type or format",80:"Given log. name not unique",81:"f.d. invalid for this operation",82:"Remote address changed",83:"Can\t access a needed shared lib",84:"Accessing a corrupted shared lib",85:".lib section in a.out corrupted",86:"Attempting to link in too many libs",87:"Attempting to exec a shared library",88:"Function not implemented",89:"No more files",90:"Directory not empty",91:"File or path name too long",92:"Too many symbolic links",95:"Operation not supported on transport endpoint",96:"Protocol family not supported",104:"Connection reset by peer",105:"No buffer space available",106:"Address family not supported by protocol family",107:"Protocol wrong type for socket",108:"Socket operation on non-socket",109:"Protocol not available",110:"Can't send after socket shutdown",111:"Connection refused",112:"Address already in use",113:"Connection aborted",114:"Network is unreachable",115:"Network interface is not configured",116:"Connection timed out",117:"Host is down",118:"Host is unreachable",119:"Connection already in progress",120:"Socket already connected",121:"Destination address required",122:"Message too long",123:"Unknown protocol",124:"Socket type not supported",125:"Address not available",126:"ENETRESET",127:"Socket is already connected",128:"Socket is not connected",129:"TOOMANYREFS",130:"EPROCLIM",131:"EUSERS",132:"EDQUOT",133:"ESTALE",134:"Not supported",135:"No medium (in tape drive)",136:"No such host or network path",137:"Filename exists with different case",138:"EILSEQ",139:"Value too large for defined data type",140:"Operation canceled",141:"State not recoverable",142:"Previous owner died",143:"Streams pipe error"};function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          for (var i = 0; i < msg.length; i++) {
            HEAP8[(((strerrbuf)+(i))|0)]=msg.charCodeAt(i)
          }
          HEAP8[(((strerrbuf)+(i))|0)]=0
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }
  function _isspace(chr) {
      switch(chr) {
        case 32:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:
          return true;
        default:
          return false;
      };
    }
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : console.log("warning: cannot create object URLs");
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        var imagePlugin = {};
        imagePlugin['canHandle'] = function(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule) {
        var ctx;
        try {
          if (useWebGL) {
            ctx = canvas.getContext('experimental-webgl', {
              alpha: false
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function (func) {
        if (!window.requestAnimationFrame) {
          window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                         window['mozRequestAnimationFrame'] ||
                                         window['webkitRequestAnimationFrame'] ||
                                         window['msRequestAnimationFrame'] ||
                                         window['oRequestAnimationFrame'] ||
                                         window['setTimeout'];
        }
        window.requestAnimationFrame(func);
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x = event.clientX - (window.scrollX + rect.left);
          var y = event.clientY - (window.scrollY + rect.top);
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        // check if SDL is available
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        // check if SDL is available
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      }};
FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
___buildEnvironment(ENV);
Module["requestFullScreen"] = function(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function(func) { Browser.requestAnimationFrame(func) };
  Module["pauseMainLoop"] = function() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function() { Browser.getUserMedia() }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 131072;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
 var ctlz_i8 = allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_DYNAMIC);
 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);
var Math_min = Math.min;
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'use asm';
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);
  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;
  var ctlz_i8=env.ctlz_i8|0;
  var __ZTIy=env.__ZTIy|0;
  var __ZTIx=env.__ZTIx|0;
  var __ZTIt=env.__ZTIt|0;
  var __ZTIs=env.__ZTIs|0;
  var __ZTIm=env.__ZTIm|0;
  var __ZTIl=env.__ZTIl|0;
  var __ZTIi=env.__ZTIi|0;
  var __ZTIh=env.__ZTIh|0;
  var __ZTIj=env.__ZTIj|0;
  var __ZTIe=env.__ZTIe|0;
  var __ZTId=env.__ZTId|0;
  var __ZTVN10__cxxabiv117__class_type_infoE=env.__ZTVN10__cxxabiv117__class_type_infoE|0;
  var __ZTIf=env.__ZTIf|0;
  var __ZTIa=env.__ZTIa|0;
  var __ZTIc=env.__ZTIc|0;
  var __ZTVN10__cxxabiv120__si_class_type_infoE=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;
  var _stderr=env._stderr|0;
  var ___progname=env.___progname|0;
  var __ZTVN10__cxxabiv119__pointer_type_infoE=env.__ZTVN10__cxxabiv119__pointer_type_infoE|0;
  var NaN=+env.NaN;
  var Infinity=+env.Infinity;
  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;
  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var abort=env.abort;
  var assert=env.assert;
  var asmPrintInt=env.asmPrintInt;
  var asmPrintFloat=env.asmPrintFloat;
  var Math_min=env.min;
  var invoke_viiiii=env.invoke_viiiii;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_iiiiiii=env.invoke_iiiiiii;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_ii=env.invoke_ii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_viii=env.invoke_viii;
  var invoke_v=env.invoke_v;
  var invoke_viiiiii=env.invoke_viiiiii;
  var invoke_iii=env.invoke_iii;
  var invoke_iiiiii=env.invoke_iiiiii;
  var invoke_viiii=env.invoke_viiii;
  var _strncmp=env._strncmp;
  var _lseek=env._lseek;
  var ___cxa_call_unexpected=env.___cxa_call_unexpected;
  var _snprintf=env._snprintf;
  var ___cxa_free_exception=env.___cxa_free_exception;
  var ___cxa_throw=env.___cxa_throw;
  var _fread=env._fread;
  var _fclose=env._fclose;
  var _strerror=env._strerror;
  var ___cxa_pure_virtual=env.___cxa_pure_virtual;
  var _fprintf=env._fprintf;
  var _sqrt=env._sqrt;
  var _llvm_va_end=env._llvm_va_end;
  var _pread=env._pread;
  var _close=env._close;
  var _feof=env._feof;
  var _fopen=env._fopen;
  var _open=env._open;
  var _strchr=env._strchr;
  var _fputc=env._fputc;
  var ___buildEnvironment=env.___buildEnvironment;
  var _log=env._log;
  var _puts=env._puts;
  var _abort=env._abort;
  var ___setErrNo=env.___setErrNo;
  var _recv=env._recv;
  var _fseek=env._fseek;
  var _qsort2=env._qsort2;
  var _qsort=env._qsort;
  var _send=env._send;
  var _write=env._write;
  var _fputs=env._fputs;
  var _ftell=env._ftell;
  var _llvm_umul_with_overflow_i32=env._llvm_umul_with_overflow_i32;
  var _exit=env._exit;
  var ___cxa_find_matching_catch=env.___cxa_find_matching_catch;
  var _strdup=env._strdup;
  var ___cxa_allocate_exception=env.___cxa_allocate_exception;
  var _ferror=env._ferror;
  var _printf=env._printf;
  var _sysconf=env._sysconf;
  var _sbrk=env._sbrk;
  var _truncate=env._truncate;
  var _read=env._read;
  var ___cxa_is_number_type=env.___cxa_is_number_type;
  var __reallyNegative=env.__reallyNegative;
  var _time=env._time;
  var __formatString=env.__formatString;
  var ___cxa_does_inherit=env.___cxa_does_inherit;
  var _getenv=env._getenv;
  var __ZSt9terminatev=env.__ZSt9terminatev;
  var _gettimeofday=env._gettimeofday;
  var _llvm_eh_exception=env._llvm_eh_exception;
  var _vfprintf=env._vfprintf;
  var ___cxa_begin_catch=env.___cxa_begin_catch;
  var _unlink=env._unlink;
  var ___assert_func=env.___assert_func;
  var __ZSt18uncaught_exceptionv=env.__ZSt18uncaught_exceptionv;
  var _pwrite=env._pwrite;
  var _putchar=env._putchar;
  var _fabs=env._fabs;
  var _fsync=env._fsync;
  var _strerror_r=env._strerror_r;
  var ___errno_location=env.___errno_location;
  var ___gxx_personality_v0=env.___gxx_personality_v0;
  var _isspace=env._isspace;
  var _fdopen=env._fdopen;
  var _bsearch=env._bsearch;
  var _fwrite=env._fwrite;
  var _ftruncate=env._ftruncate;
  var __exit=env.__exit;
  var ___resumeException=env.___resumeException;
  var _strcmp=env._strcmp;
  var ___cxa_end_catch=env.___cxa_end_catch;
// EMSCRIPTEN_START_FUNCS
function stackAlloc(size) {
 size = size | 0;
 var ret = 0;
 ret = STACKTOP;
 STACKTOP = STACKTOP + size | 0;
 STACKTOP = STACKTOP + 7 >> 3 << 3;
 return ret | 0;
}
function stackSave() {
 return STACKTOP | 0;
}
function stackRestore(top) {
 top = top | 0;
 STACKTOP = top;
}
function setThrew(threw, value) {
 threw = threw | 0;
 value = value | 0;
 if ((__THREW__ | 0) == 0) {
  __THREW__ = threw;
  threwValue = value;
 }
}
function copyTempFloat(ptr) {
 ptr = ptr | 0;
 HEAP8[tempDoublePtr] = HEAP8[ptr];
 HEAP8[tempDoublePtr + 1 | 0] = HEAP8[ptr + 1 | 0];
 HEAP8[tempDoublePtr + 2 | 0] = HEAP8[ptr + 2 | 0];
 HEAP8[tempDoublePtr + 3 | 0] = HEAP8[ptr + 3 | 0];
}
function copyTempDouble(ptr) {
 ptr = ptr | 0;
 HEAP8[tempDoublePtr] = HEAP8[ptr];
 HEAP8[tempDoublePtr + 1 | 0] = HEAP8[ptr + 1 | 0];
 HEAP8[tempDoublePtr + 2 | 0] = HEAP8[ptr + 2 | 0];
 HEAP8[tempDoublePtr + 3 | 0] = HEAP8[ptr + 3 | 0];
 HEAP8[tempDoublePtr + 4 | 0] = HEAP8[ptr + 4 | 0];
 HEAP8[tempDoublePtr + 5 | 0] = HEAP8[ptr + 5 | 0];
 HEAP8[tempDoublePtr + 6 | 0] = HEAP8[ptr + 6 | 0];
 HEAP8[tempDoublePtr + 7 | 0] = HEAP8[ptr + 7 | 0];
}
function setTempRet0(value) {
 value = value | 0;
 tempRet0 = value;
}
function setTempRet1(value) {
 value = value | 0;
 tempRet1 = value;
}
function setTempRet2(value) {
 value = value | 0;
 tempRet2 = value;
}
function setTempRet3(value) {
 value = value | 0;
 tempRet3 = value;
}
function setTempRet4(value) {
 value = value | 0;
 tempRet4 = value;
}
function setTempRet5(value) {
 value = value | 0;
 tempRet5 = value;
}
function setTempRet6(value) {
 value = value | 0;
 tempRet6 = value;
}
function setTempRet7(value) {
 value = value | 0;
 tempRet7 = value;
}
function setTempRet8(value) {
 value = value | 0;
 tempRet8 = value;
}
function setTempRet9(value) {
 value = value | 0;
 tempRet9 = value;
}
function runPostSets() {
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 8 >> 2] = 88;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 12 >> 2] = 108;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 16 >> 2] = 94;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 20 >> 2] = 22;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 24 >> 2] = 10;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 28 >> 2] = 6;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 32 >> 2] = 2;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 36 >> 2] = 4;
 HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE + 8 >> 2] = 88;
 HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE + 12 >> 2] = 96;
 HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE + 16 >> 2] = 94;
 HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE + 20 >> 2] = 22;
 HEAP32[__ZTVN10__cxxabiv119__pointer_type_infoE + 24 >> 2] = 12;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 8 >> 2] = 88;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 12 >> 2] = 86;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 16 >> 2] = 94;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 20 >> 2] = 22;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 24 >> 2] = 10;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 28 >> 2] = 2;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 32 >> 2] = 6;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 36 >> 2] = 2;
 HEAP32[__ZTIy >> 2] = 8504;
 HEAP32[__ZTIy + 4 >> 2] = 8784;
 HEAP32[__ZTIx >> 2] = 8504;
 HEAP32[__ZTIx + 4 >> 2] = 8792;
 HEAP32[__ZTIt >> 2] = 8504;
 HEAP32[__ZTIt + 4 >> 2] = 8816;
 HEAP32[__ZTIs >> 2] = 8504;
 HEAP32[__ZTIs + 4 >> 2] = 8824;
 HEAP32[__ZTIm >> 2] = 8504;
 HEAP32[__ZTIm + 4 >> 2] = 8832;
 HEAP32[__ZTIl >> 2] = 8504;
 HEAP32[__ZTIl + 4 >> 2] = 8840;
 HEAP32[__ZTIj >> 2] = 8504;
 HEAP32[__ZTIj + 4 >> 2] = 8848;
 HEAP32[__ZTIi >> 2] = 8504;
 HEAP32[__ZTIi + 4 >> 2] = 8856;
 HEAP32[__ZTIh >> 2] = 8504;
 HEAP32[__ZTIh + 4 >> 2] = 8864;
 HEAP32[__ZTIf >> 2] = 8504;
 HEAP32[__ZTIf + 4 >> 2] = 8872;
 HEAP32[__ZTIe >> 2] = 8504;
 HEAP32[__ZTIe + 4 >> 2] = 8880;
 HEAP32[__ZTId >> 2] = 8504;
 HEAP32[__ZTId + 4 >> 2] = 8888;
 HEAP32[__ZTIc >> 2] = 8504;
 HEAP32[__ZTIc + 4 >> 2] = 8896;
 HEAP32[__ZTIa >> 2] = 8504;
 HEAP32[__ZTIa + 4 >> 2] = 8912;
 HEAP32[2482] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2484] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2486] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2490] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2494] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2498] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2502] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2505] = __ZTIy;
 HEAP32[2506] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2509] = __ZTIx;
 HEAP32[2510] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2514] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2518] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2521] = __ZTIt;
 HEAP32[2522] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2525] = __ZTIs;
 HEAP32[2526] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2529] = __ZTIm;
 HEAP32[2530] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2533] = __ZTIl;
 HEAP32[2534] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2537] = __ZTIj;
 HEAP32[2538] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2541] = __ZTIi;
 HEAP32[2542] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2545] = __ZTIh;
 HEAP32[2546] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2549] = __ZTIf;
 HEAP32[2550] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2553] = __ZTIe;
 HEAP32[2554] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2557] = __ZTId;
 HEAP32[2558] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2561] = __ZTIc;
 HEAP32[2562] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2566] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2569] = __ZTIa;
 HEAP32[2570] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2573] = __ZTIy;
 HEAP32[2574] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2577] = __ZTIx;
 HEAP32[2578] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2582] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2586] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2589] = __ZTIt;
 HEAP32[2590] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2593] = __ZTIs;
 HEAP32[2594] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2597] = __ZTIm;
 HEAP32[2598] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2601] = __ZTIl;
 HEAP32[2602] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2605] = __ZTIj;
 HEAP32[2606] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2609] = __ZTIi;
 HEAP32[2610] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2613] = __ZTIh;
 HEAP32[2614] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2617] = __ZTIf;
 HEAP32[2618] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2621] = __ZTIe;
 HEAP32[2622] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2625] = __ZTId;
 HEAP32[2626] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2629] = __ZTIc;
 HEAP32[2630] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2634] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2637] = __ZTIa;
 HEAP32[2638] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2642] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2646] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2650] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2654] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2658] = __ZTVN10__cxxabiv119__pointer_type_infoE + 8;
 HEAP32[2662] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2672] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2674] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2678] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2682] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2686] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2690] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2694] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2698] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2702] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2706] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2710] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2714] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
}
function __ZN10ime_pinyin14compare_char16EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $retval_0 = 0;
 $1 = HEAP16[$p1 >> 1] | 0;
 $3 = HEAP16[$p2 >> 1] | 0;
 if (($1 & 65535) < ($3 & 65535)) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $retval_0 = ($1 & 65535) > ($3 & 65535) | 0;
 return $retval_0 | 0;
}
function _im_get_spl_start_at($id) {
 $id = $id | 0;
 return HEAP16[(HEAP32[2818] | 0) + ($id << 1) >> 1] | 0;
}
function _im_get_predict_at($pos) {
 $pos = $pos | 0;
 var $retval_0 = 0;
 if ($pos >>> 0 > 499) {
  $retval_0 = 0;
 } else {
  $retval_0 = 11280 + ($pos * 48 | 0) | 0;
 }
 return $retval_0 | 0;
}
function __ZN10ime_pinyin22cmp_scis_hz_splid_freqEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $5 = 0, $bf_clear = 0, $7 = 0, $bf_clear12 = 0, $8 = 0, $9 = 0, $10 = 0.0, $11 = 0.0, $retval_0 = 0;
 $1 = HEAP16[$p1 + 4 >> 1] | 0;
 $3 = HEAP16[$p2 + 4 >> 1] | 0;
 do {
  if (($1 & 65535) < ($3 & 65535)) {
   $retval_0 = -1;
  } else {
   if (($1 & 65535) > ($3 & 65535)) {
    $retval_0 = 1;
    break;
   }
   $5 = HEAP16[$p1 + 6 >> 1] | 0;
   $bf_clear = $5 & 31;
   $7 = HEAP16[$p2 + 6 >> 1] | 0;
   $bf_clear12 = $7 & 31;
   if (($bf_clear & 65535) < ($bf_clear12 & 65535)) {
    $retval_0 = -1;
    break;
   }
   if (($bf_clear & 65535) > ($bf_clear12 & 65535)) {
    $retval_0 = 1;
    break;
   }
   $8 = ($5 & 65535) >>> 5;
   $9 = ($7 & 65535) >>> 5;
   if (($8 & 65535) < ($9 & 65535)) {
    $retval_0 = -1;
    break;
   }
   if (($8 & 65535) > ($9 & 65535)) {
    $retval_0 = 1;
    break;
   }
   $10 = +HEAPF32[$p1 >> 2];
   $11 = +HEAPF32[$p2 >> 2];
   if ($10 > $11) {
    $retval_0 = -1;
    break;
   }
   $retval_0 = $10 < $11 | 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin17cmp_scis_hz_splidEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $5 = 0, $bf_clear = 0, $7 = 0, $bf_clear12 = 0, $8 = 0, $9 = 0, $retval_0 = 0;
 $1 = HEAP16[$p1 + 4 >> 1] | 0;
 $3 = HEAP16[$p2 + 4 >> 1] | 0;
 do {
  if (($1 & 65535) < ($3 & 65535)) {
   $retval_0 = -1;
  } else {
   if (($1 & 65535) > ($3 & 65535)) {
    $retval_0 = 1;
    break;
   }
   $5 = HEAP16[$p1 + 6 >> 1] | 0;
   $bf_clear = $5 & 31;
   $7 = HEAP16[$p2 + 6 >> 1] | 0;
   $bf_clear12 = $7 & 31;
   if (($bf_clear & 65535) < ($bf_clear12 & 65535)) {
    $retval_0 = -1;
    break;
   }
   if (($bf_clear & 65535) > ($bf_clear12 & 65535)) {
    $retval_0 = 1;
    break;
   }
   $8 = ($5 & 65535) >>> 5;
   $9 = ($7 & 65535) >>> 5;
   if (($8 & 65535) < ($9 & 65535)) {
    $retval_0 = -1;
    break;
   }
   $retval_0 = ($8 & 65535) > ($9 & 65535) | 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function _im_open_decoder($fn_sys_dict, $fn_usr_dict) {
 $fn_sys_dict = $fn_sys_dict | 0;
 $fn_usr_dict = $fn_usr_dict | 0;
 var $0 = 0, $call = 0, $6 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) != 0) {
  __ZN10ime_pinyin12MatrixSearchD2Ev($0);
  __ZdlPv($0 | 0);
 }
 $call = __Znwj(12504) | 0;
 $6 = $call;
 __ZN10ime_pinyin12MatrixSearchC2Ev($6);
 HEAP32[10830] = $6;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch4initEPKcS2_($6, $fn_sys_dict, $fn_usr_dict) | 0;
 return $retval_0 | 0;
}
function _im_open_decoder_fd($sys_fd, $start_offset, $length, $fn_usr_dict) {
 $sys_fd = $sys_fd | 0;
 $start_offset = $start_offset | 0;
 $length = $length | 0;
 $fn_usr_dict = $fn_usr_dict | 0;
 var $0 = 0, $call = 0, $6 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) != 0) {
  __ZN10ime_pinyin12MatrixSearchD2Ev($0);
  __ZdlPv($0 | 0);
 }
 $call = __Znwj(12504) | 0;
 $6 = $call;
 __ZN10ime_pinyin12MatrixSearchC2Ev($6);
 HEAP32[10830] = $6;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch7init_fdEillPKc($6, $sys_fd, $start_offset, $length, $fn_usr_dict) | 0;
 return $retval_0 | 0;
}
function _im_close_decoder() {
 var $0 = 0, $1 = 0;
 $0 = HEAP32[10830] | 0;
 do {
  if (($0 | 0) != 0) {
   __ZN10ime_pinyin12MatrixSearch5closeEv($0);
   $1 = HEAP32[10830] | 0;
   if (($1 | 0) == 0) {
    break;
   }
   __ZN10ime_pinyin12MatrixSearchD2Ev($1);
   __ZdlPv($1 | 0);
  }
 } while (0);
 HEAP32[10830] = 0;
 return;
}
function _im_set_max_lens($max_sps_len, $max_hzs_len) {
 $max_sps_len = $max_sps_len | 0;
 $max_hzs_len = $max_hzs_len | 0;
 var $0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  return;
 }
 __ZN10ime_pinyin12MatrixSearch12set_max_lensEjj($0, $max_sps_len, $max_hzs_len);
 return;
}
function _im_flush_cache() {
 var $0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  return;
 }
 __ZN10ime_pinyin12MatrixSearch11flush_cacheEv($0);
 return;
}
function _im_search($pybuf, $pylen) {
 $pybuf = $pybuf | 0;
 $pylen = $pylen | 0;
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin12MatrixSearch6searchEPKcj($0, $pybuf, $pylen) | 0;
 $retval_0 = __ZN10ime_pinyin12MatrixSearch17get_candidate_numEv(HEAP32[10830] | 0) | 0;
 return $retval_0 | 0;
}
function _im_delsearch($pos, $is_pos_in_splid, $clear_fixed_this_step) {
 $pos = $pos | 0;
 $is_pos_in_splid = $is_pos_in_splid | 0;
 $clear_fixed_this_step = $clear_fixed_this_step | 0;
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin12MatrixSearch9delsearchEjbb($0, $pos, $is_pos_in_splid, $clear_fixed_this_step) | 0;
 $retval_0 = __ZN10ime_pinyin12MatrixSearch17get_candidate_numEv(HEAP32[10830] | 0) | 0;
 return $retval_0 | 0;
}
function _im_reset_search() {
 var $0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  return;
 }
 __ZN10ime_pinyin12MatrixSearch12reset_searchEv($0) | 0;
 return;
}
function _im_get_sps_str($decoded_len) {
 $decoded_len = $decoded_len | 0;
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch9get_pystrEPj($0, $decoded_len) | 0;
 return $retval_0 | 0;
}
function _im_get_candidate($cand_id, $cand_str, $max_len) {
 $cand_id = $cand_id | 0;
 $cand_str = $cand_str | 0;
 $max_len = $max_len | 0;
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch13get_candidateEjPtj($0, $cand_id, $cand_str, $max_len) | 0;
 return $retval_0 | 0;
}
function _toUTF8($src, $length) {
 $src = $src | 0;
 $length = $length | 0;
 var $utf16Start = 0, $utf8Start = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $utf16Start = sp | 0;
 $utf8Start = sp + 8 | 0;
 HEAP32[$utf16Start >> 2] = $src;
 HEAP32[$utf8Start >> 2] = 43328;
 _ConvertUTF16toUTF8($utf16Start, $src + ($length << 1) | 0, $utf8Start, 44352, 0) | 0;
 STACKTOP = sp;
 return 43328 | 0;
}
function _toUTF16($src, $length) {
 $src = $src | 0;
 $length = $length | 0;
 var $utf8Start = 0, $utf16Start = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $utf8Start = sp | 0;
 $utf16Start = sp + 8 | 0;
 HEAP32[$utf8Start >> 2] = $src;
 HEAP32[$utf16Start >> 2] = 44352;
 _ConvertUTF8toUTF16($utf8Start, $src + $length | 0, $utf16Start, 46400, 0) | 0;
 STACKTOP = sp;
 return 44352 | 0;
}
function _im_get_candidate_char($cand_id) {
 $cand_id = $cand_id | 0;
 var $0 = 0, $arraydecay = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128 | 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $arraydecay = sp | 0;
 __ZN10ime_pinyin12MatrixSearch13get_candidateEjPtj($0, $cand_id, $arraydecay, 64) | 0;
 _toUTF8($arraydecay, 64) | 0;
 $retval_0 = 43328;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function _im_get_spl_start() {
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch13get_spl_startERPKt($0, 11272) | 0;
 return $retval_0 | 0;
}
function _im_choose($choice_id) {
 $choice_id = $choice_id | 0;
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch6chooseEj($0, $choice_id) | 0;
 return $retval_0 | 0;
}
function _im_cancel_last_choice() {
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch18cancel_last_choiceEv($0) | 0;
 return $retval_0 | 0;
}
function _im_get_fixed_len() {
 var $0 = 0, $retval_0 = 0;
 $0 = HEAP32[10830] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch12get_fixedlenEv($0) | 0;
 return $retval_0 | 0;
}
function _im_get_predicts_utf8($buf, $pre_buf) {
 $buf = $buf | 0;
 $pre_buf = $pre_buf | 0;
 var $call5 = 0, $idx_09 = 0, $arraydecay = 0, $inc = 0, $retval_0 = 0;
 if (($buf | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 _toUTF16($buf, 64) | 0;
 _utf16_strlen(44352) | 0;
 $call5 = __ZN10ime_pinyin12MatrixSearch12get_predictsEPKtPA8_tj(HEAP32[10830] | 0, 44352, 35280, 500) | 0;
 HEAP32[$pre_buf >> 2] = 11280;
 $idx_09 = 0;
 while (1) {
  $arraydecay = (HEAP32[$pre_buf >> 2] | 0) + ($idx_09 * 48 | 0) | 0;
  _toUTF8(35280 + ($idx_09 << 4) | 0, 8) | 0;
  _strcpy($arraydecay | 0, 43328 | 0) | 0;
  $inc = $idx_09 + 1 | 0;
  if ($inc >>> 0 < 500) {
   $idx_09 = $inc;
  } else {
   $retval_0 = $call5;
   break;
  }
 }
 return $retval_0 | 0;
}
function _im_get_predicts($his_buf, $pre_buf) {
 $his_buf = $his_buf | 0;
 $pre_buf = $pre_buf | 0;
 var $retval_0 = 0;
 if (($his_buf | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 _utf16_strlen($his_buf) | 0;
 HEAP32[$pre_buf >> 2] = 35280;
 $retval_0 = __ZN10ime_pinyin12MatrixSearch12get_predictsEPKtPA8_tj(HEAP32[10830] | 0, $his_buf, 35280, 500) | 0;
 return $retval_0 | 0;
}
function _im_enable_shm_as_szm($enable) {
 $enable = $enable | 0;
 __ZN10ime_pinyin12SpellingTrie14szm_enable_shmEb(__ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0, $enable);
 return;
}
function _im_enable_ym_as_szm($enable) {
 $enable = $enable | 0;
 __ZN10ime_pinyin12SpellingTrie13szm_enable_ymEb(__ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0, $enable);
 return;
}
function __ZN10ime_pinyin19cmp_lemma_entry_hzsEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $arraydecay = 0, $call = 0, $arraydecay2 = 0, $call3 = 0, $retval_0 = 0;
 $arraydecay = $p1 + 8 | 0;
 $call = _utf16_strlen($arraydecay) | 0;
 $arraydecay2 = $p2 + 8 | 0;
 $call3 = _utf16_strlen($arraydecay2) | 0;
 if ($call >>> 0 < $call3 >>> 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 if ($call >>> 0 > $call3 >>> 0) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $retval_0 = _utf16_strcmp($arraydecay, $arraydecay2) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin10compare_pyEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $call = 0, $retval_0 = 0;
 $call = _utf16_strcmp($p1 + 42 | 0, $p2 + 42 | 0) | 0;
 if (($call | 0) != 0) {
  $retval_0 = $call;
  return $retval_0 | 0;
 }
 $retval_0 = ~~+HEAPF32[$p2 + 120 >> 2] - ~~+HEAPF32[$p1 + 120 >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin22cmp_lemma_entry_hzspysEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $arraydecay = 0, $call = 0, $arraydecay2 = 0, $call3 = 0, $call11 = 0, $retval_0 = 0;
 $arraydecay = $p1 + 8 | 0;
 $call = _utf16_strlen($arraydecay) | 0;
 $arraydecay2 = $p2 + 8 | 0;
 $call3 = _utf16_strlen($arraydecay2) | 0;
 if ($call >>> 0 < $call3 >>> 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 if ($call >>> 0 > $call3 >>> 0) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $call11 = _utf16_strcmp($arraydecay, $arraydecay2) | 0;
 if (($call11 | 0) != 0) {
  $retval_0 = $call11;
  return $retval_0 | 0;
 }
 $retval_0 = _utf16_strcmp($p1 + 42 | 0, $p2 + 42 | 0) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin14compare_splid2EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strcmp($p1 + 42 | 0, $p2 + 42 | 0) | 0;
}
function __ZN10ime_pinyin11DictBuilderC2Ev($this) {
 $this = $this | 0;
 _memset($this | 0, 0, 60);
 return;
}
function __ZN10ime_pinyin11DictBuilderD2Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
 return;
}
function __ZN10ime_pinyin11DictBuilder13free_resourceEv($this) {
 $this = $this | 0;
 var $lemma_arr_ = 0, $0 = 0, $scis_ = 0, $2 = 0, $lma_nodes_le0_ = 0, $4 = 0, $6 = 0, $8 = 0, $spl_table_ = 0, $10 = 0, $spl_parser_ = 0, $14 = 0;
 $lemma_arr_ = $this | 0;
 $0 = HEAP32[$lemma_arr_ >> 2] | 0;
 if (($0 | 0) != 0) {
  __ZdaPv($0);
 }
 $scis_ = $this + 8 | 0;
 $2 = HEAP32[$scis_ >> 2] | 0;
 if (($2 | 0) != 0) {
  __ZdaPv($2);
 }
 $lma_nodes_le0_ = $this + 16 | 0;
 $4 = HEAP32[$lma_nodes_le0_ >> 2] | 0;
 if (($4 | 0) != 0) {
  __ZdaPv($4);
 }
 $6 = HEAP32[$this + 20 >> 2] | 0;
 if (($6 | 0) != 0) {
  __ZdaPv($6);
 }
 $8 = HEAP32[$this + 32 >> 2] | 0;
 if (($8 | 0) != 0) {
  __ZdaPv($8);
 }
 $spl_table_ = $this + 52 | 0;
 $10 = HEAP32[$spl_table_ >> 2] | 0;
 if (($10 | 0) != 0) {
  __ZN10ime_pinyin13SpellingTableD2Ev($10);
  __ZdlPv($10 | 0);
 }
 $spl_parser_ = $this + 56 | 0;
 $14 = HEAP32[$spl_parser_ >> 2] | 0;
 if (($14 | 0) != 0) {
  __ZdlPv($14);
 }
 HEAP32[$lemma_arr_ >> 2] = 0;
 HEAP32[$scis_ >> 2] = 0;
 HEAP32[$spl_table_ >> 2] = 0;
 HEAP32[$spl_parser_ >> 2] = 0;
 HEAP32[$this + 4 >> 2] = 0;
 _memset($lma_nodes_le0_ | 0, 0, 28);
 return;
}
function __ZN10ime_pinyin11DictBuilder14alloc_resourceEj($this, $lma_num) {
 $this = $this | 0;
 $lma_num = $lma_num | 0;
 var $lemma_num_ = 0, $0$0 = 0, $lemma_arr_ = 0, $top_lmas_ = 0, $mul = 0, $scis_num_ = 0, $7$0 = 0, $scis_ = 0, $lma_nodes_le0_ = 0, $14$0 = 0, $lma_nodes_ge1_ = 0, $20$0 = 0, $homo_idx_buf_ = 0, $25 = 0, $spl_table_ = 0, $call13 = 0, $26 = 0, $27 = 0, $53 = 0, $retval_0 = 0;
 if (($lma_num | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
 $lemma_num_ = $this + 4 | 0;
 HEAP32[$lemma_num_ >> 2] = $lma_num;
 $0$0 = _llvm_umul_with_overflow_i32($lma_num | 0, 124) | 0;
 $lemma_arr_ = $this | 0;
 HEAP32[$lemma_arr_ >> 2] = __Znaj(tempRet0 ? -1 : $0$0) | 0;
 HEAP32[$this + 48 >> 2] = 0;
 $top_lmas_ = $this + 44 | 0;
 HEAP32[$top_lmas_ >> 2] = __Znaj(1240) | 0;
 $mul = HEAP32[$lemma_num_ >> 2] << 3;
 $scis_num_ = $this + 12 | 0;
 HEAP32[$scis_num_ >> 2] = $mul;
 $7$0 = _llvm_umul_with_overflow_i32($mul | 0, 8) | 0;
 $scis_ = $this + 8 | 0;
 HEAP32[$scis_ >> 2] = __Znaj(tempRet0 ? -1 : $7$0) | 0;
 HEAP32[$this + 24 >> 2] = 0;
 $lma_nodes_le0_ = $this + 16 | 0;
 HEAP32[$lma_nodes_le0_ >> 2] = __Znaj(7728) | 0;
 HEAP32[$this + 28 >> 2] = 0;
 $14$0 = _llvm_umul_with_overflow_i32(HEAP32[$lemma_num_ >> 2] | 0, 10) | 0;
 $lma_nodes_ge1_ = $this + 20 | 0;
 HEAP32[$lma_nodes_ge1_ >> 2] = __Znaj(tempRet0 ? -1 : $14$0) | 0;
 $20$0 = _llvm_umul_with_overflow_i32(HEAP32[$lemma_num_ >> 2] | 0, 4) | 0;
 $homo_idx_buf_ = $this + 32 | 0;
 HEAP32[$homo_idx_buf_ >> 2] = __Znaj(tempRet0 ? -1 : $20$0) | 0;
 $25 = __Znwj(56) | 0;
 __ZN10ime_pinyin13SpellingTableC2Ev($25);
 $spl_table_ = $this + 52 | 0;
 HEAP32[$spl_table_ >> 2] = $25;
 $call13 = __Znwj(4) | 0;
 $26 = $call13;
 __ZN10ime_pinyin14SpellingParserC2Ev($26);
 HEAP32[$this + 56 >> 2] = $26;
 $27 = HEAP32[$lemma_arr_ >> 2] | 0;
 do {
  if (($27 | 0) != 0) {
   if ((HEAP32[$top_lmas_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$scis_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$spl_table_ >> 2] | 0) == 0 | ($call13 | 0) == 0) {
    break;
   }
   if ((HEAP32[$lma_nodes_le0_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$lma_nodes_ge1_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$homo_idx_buf_ >> 2] | 0) == 0) {
    break;
   }
   _memset($27 | 0, 0, (HEAP32[$lemma_num_ >> 2] | 0) * 124 | 0 | 0);
   _memset(HEAP32[$scis_ >> 2] | 0, 0, HEAP32[$scis_num_ >> 2] << 3 | 0);
   _memset(HEAP32[$lma_nodes_le0_ >> 2] | 0, 0, 7728);
   _memset(HEAP32[$lma_nodes_ge1_ >> 2] | 0, 0, (HEAP32[$lemma_num_ >> 2] | 0) * 10 | 0 | 0);
   _memset(HEAP32[$homo_idx_buf_ >> 2] | 0, 0, HEAP32[$lemma_num_ >> 2] << 2 | 0);
   $53 = HEAP32[$spl_table_ >> 2] | 0;
   __ZN10ime_pinyin13SpellingTable10init_tableEjjb($53, 6, 2e3, 1) | 0;
   $retval_0 = 1;
   return $retval_0 | 0;
  }
 } while (0);
 __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11DictBuilder17read_valid_hanzisEPKcPj($this, $fn_validhzs, $num) {
 $this = $this | 0;
 $fn_validhzs = $fn_validhzs | 0;
 $num = $num | 0;
 var $utf16header = 0, $call = 0, $cmp7 = 0, $div = 0, $sub = 0, $2$0 = 0, $call16 = 0, $call22 = 0, $cmp23 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $utf16header = sp | 0;
 if (($fn_validhzs | 0) == 0 | ($num | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP32[$num >> 2] = 0;
 $call = _fopen($fn_validhzs | 0, 4440) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $cmp7 = (_fread($utf16header | 0, 2, 1, $call | 0) | 0) == 1;
 if (!($cmp7 & (HEAP16[$utf16header >> 1] | 0) == -257)) {
  _fclose($call | 0) | 0;
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _fseek($call | 0, 0, 2) | 0;
 $div = (_ftell($call | 0) | 0) >>> 1;
 HEAP32[$num >> 2] = $div;
 if (($div | 0) == 0) {
  ___assert_func(4408, 240, 7456, 3040);
  return 0;
 }
 $sub = $div - 1 | 0;
 HEAP32[$num >> 2] = $sub;
 $2$0 = _llvm_umul_with_overflow_i32($sub | 0, 2) | 0;
 $call16 = __Znaj(tempRet0 ? -1 : $2$0) | 0;
 if (($call16 | 0) == 0) {
  _fclose($call | 0) | 0;
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _fseek($call | 0, 2, 0) | 0;
 $call22 = _fread($call16 | 0, 2, HEAP32[$num >> 2] | 0, $call | 0) | 0;
 $cmp23 = ($call22 | 0) == (HEAP32[$num >> 2] | 0);
 _fclose($call | 0) | 0;
 if ($cmp23) {
  __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($call16, HEAP32[$num >> 2] | 0, 2, 24);
  $retval_0 = $call16;
  STACKTOP = sp;
  return $retval_0 | 0;
 } else {
  __ZdaPv($call16);
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin11DictBuilder19format_spelling_strEPc($this, $spl_str) {
 $this = $this | 0;
 $spl_str = $spl_str | 0;
 var $0 = 0, $1 = 0, $arrayidx21 = 0, $pos_020 = 0, $4 = 0;
 if (($spl_str | 0) == 0) {
  return;
 }
 $0 = HEAP8[$spl_str] | 0;
 if ($0 << 24 >> 24 == 0) {
  return;
 } else {
  $pos_020 = 0;
  $arrayidx21 = $spl_str;
  $1 = $0;
 }
 do {
  if (($1 - 97 & 255) < 26) {
   HEAP8[$arrayidx21] = $1 - 32 & 255;
  }
  do {
   if ($pos_020 << 16 >> 16 == 1) {
    if ((HEAP8[$arrayidx21] | 0) != 72) {
     break;
    }
    $4 = HEAP8[$spl_str] | 0;
    if (!(($4 << 24 >> 24 | 0) == 67 | ($4 << 24 >> 24 | 0) == 83 | ($4 << 24 >> 24 | 0) == 90)) {
     break;
    }
    HEAP8[$arrayidx21] = 104;
   }
  } while (0);
  $pos_020 = $pos_020 + 1 & 65535;
  $arrayidx21 = $spl_str + ($pos_020 & 65535) | 0;
  $1 = HEAP8[$arrayidx21] | 0;
 } while ($1 << 24 >> 24 != 0);
 return;
}
function __ZN10ime_pinyin11DictBuilder18str_in_hanzis_listEPKtjS2_j($this, $hzs, $hzs_len, $str, $str_len) {
 $this = $this | 0;
 $hzs = $hzs | 0;
 $hzs_len = $hzs_len | 0;
 $str = $str | 0;
 $str_len = $str_len | 0;
 var $pos_0 = 0, $retval_0 = 0, label = 0;
 if (($hzs | 0) == 0 | ($str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $pos_0 = 0;
 }
 while (1) {
  if ($pos_0 >>> 0 >= $str_len >>> 0) {
   $retval_0 = 1;
   label = 227;
   break;
  }
  if (__ZN10ime_pinyin11DictBuilder17hz_in_hanzis_listEPKtjt(0, $hzs, $hzs_len, HEAP16[$str + ($pos_0 << 1) >> 1] | 0) | 0) {
   $pos_0 = $pos_0 + 1 | 0;
  } else {
   $retval_0 = 0;
   label = 226;
   break;
  }
 }
 if ((label | 0) == 226) {
  return $retval_0 | 0;
 } else if ((label | 0) == 227) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin11DictBuilder17sort_lemmas_by_hzEv($this) {
 $this = $this | 0;
 var $lemma_arr_ = 0, $0 = 0, $lemma_num_ = 0, $1 = 0, $i_09 = 0, $idx_max_08 = 0, $5 = 0, $inc23 = 0, $phitmp = 0, $retval_0 = 0;
 $lemma_arr_ = $this | 0;
 $0 = HEAP32[$lemma_arr_ >> 2] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lemma_num_ = $this + 4 | 0;
 $1 = HEAP32[$lemma_num_ >> 2] | 0;
 if (($1 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($0, $1, 124, 22);
 HEAP32[(HEAP32[$lemma_arr_ >> 2] | 0) + 4 >> 2] = 1;
 if ((HEAP32[$lemma_num_ >> 2] | 0) >>> 0 > 1) {
  $idx_max_08 = 2;
  $i_09 = 1;
 } else {
  $retval_0 = 2;
  return $retval_0 | 0;
 }
 while (1) {
  $5 = HEAP32[$lemma_arr_ >> 2] | 0;
  _utf16_strcmp($5 + ($i_09 * 124 | 0) + 8 | 0, $5 + (($i_09 - 1 | 0) * 124 | 0) + 8 | 0) | 0;
  HEAP32[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_09 * 124 | 0) + 4 >> 2] = $idx_max_08;
  $inc23 = $i_09 + 1 | 0;
  $phitmp = $idx_max_08 + 1 | 0;
  if ($inc23 >>> 0 < (HEAP32[$lemma_num_ >> 2] | 0) >>> 0) {
   $idx_max_08 = $phitmp;
   $i_09 = $inc23;
  } else {
   $retval_0 = $phitmp;
   break;
  }
 }
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11DictBuilder17hz_in_hanzis_listEPKtjt($this, $hzs, $hzs_len, $hz) {
 $this = $this | 0;
 $hzs = $hzs | 0;
 $hzs_len = $hzs_len | 0;
 $hz = $hz | 0;
 var $hz_addr = 0, $call = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $hz_addr = sp | 0;
 HEAP16[$hz_addr >> 1] = $hz;
 if (($hzs | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin9mybsearchEPKvS1_jjPFiS1_S1_E($hz_addr, $hzs, $hzs_len, 2, 24) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if ((HEAP16[$call >> 1] | 0) == (HEAP16[$hz_addr >> 1] | 0)) {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 } else {
  ___assert_func(4408, 273, 7536, 2128);
  return 0;
 }
 return 0;
}
function __ZN10ime_pinyin11DictBuilder14get_top_lemmasEv($this) {
 $this = $this | 0;
 var $top_lmas_num_ = 0, $lemma_arr_ = 0, $lemma_num_ = 0, $top_lmas_ = 0, $top_lmas_13 = 0, $pos_016 = 0, $2 = 0, $5 = 0, $6 = 0, $7 = 0, $arrayidx11 = 0, $9 = 0, $cmp19 = 0, $move_pos_0_in = 0, $move_pos_0 = 0, $12 = 0, $sub30 = 0, $13 = 0, $14 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $inc = 0, label = 0;
 $top_lmas_num_ = $this + 48 | 0;
 HEAP32[$top_lmas_num_ >> 2] = 0;
 $lemma_arr_ = $this | 0;
 if ((HEAP32[$lemma_arr_ >> 2] | 0) == 0) {
  return;
 }
 $lemma_num_ = $this + 4 | 0;
 if ((HEAP32[$lemma_num_ >> 2] | 0) == 0) {
  return;
 }
 $top_lmas_ = $this + 44 | 0;
 $top_lmas_13 = $this + 44 | 0;
 $pos_016 = 0;
 L275 : while (1) {
  $2 = HEAP32[$top_lmas_num_ >> 2] | 0;
  do {
   if (($2 | 0) == 0) {
    $5 = HEAP32[$top_lmas_ >> 2] | 0;
    $6 = (HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_016 * 124 | 0) | 0;
    _memcpy($5 | 0, $6 | 0, 124) | 0;
    HEAP32[$top_lmas_num_ >> 2] = 1;
   } else {
    $7 = HEAP32[$lemma_arr_ >> 2] | 0;
    $arrayidx11 = $7 + ($pos_016 * 124 | 0) | 0;
    $9 = HEAP32[$top_lmas_13 >> 2] | 0;
    $cmp19 = $2 >>> 0 < 10;
    if (+HEAPF32[$7 + ($pos_016 * 124 | 0) + 120 >> 2] <= +HEAPF32[$9 + (($2 - 1 | 0) * 124 | 0) + 120 >> 2]) {
     if (!$cmp19) {
      break;
     }
     $23 = $9 + ($2 * 124 | 0) | 0;
     $24 = $arrayidx11;
     _memcpy($23 | 0, $24 | 0, 124) | 0;
     HEAP32[$top_lmas_num_ >> 2] = (HEAP32[$top_lmas_num_ >> 2] | 0) + 1;
     break;
    }
    if ($cmp19) {
     HEAP32[$top_lmas_num_ >> 2] = $2 + 1;
    }
    $move_pos_0_in = HEAP32[$top_lmas_num_ >> 2] | 0;
    while (1) {
     $move_pos_0 = $move_pos_0_in - 1 | 0;
     if (($move_pos_0 | 0) == 0) {
      label = 258;
      break L275;
     }
     $12 = HEAP32[$top_lmas_13 >> 2] | 0;
     $sub30 = $move_pos_0_in - 2 | 0;
     $13 = $12 + ($move_pos_0 * 124 | 0) | 0;
     $14 = $12 + ($sub30 * 124 | 0) | 0;
     _memcpy($13 | 0, $14 | 0, 124) | 0;
     if (($sub30 | 0) == 0) {
      break;
     }
     if (+HEAPF32[(HEAP32[$top_lmas_13 >> 2] | 0) + (($move_pos_0_in - 3 | 0) * 124 | 0) + 120 >> 2] > +HEAPF32[(HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_016 * 124 | 0) + 120 >> 2]) {
      break;
     } else {
      $move_pos_0_in = $move_pos_0;
     }
    }
    $21 = (HEAP32[$top_lmas_13 >> 2] | 0) + ($sub30 * 124 | 0) | 0;
    $22 = (HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_016 * 124 | 0) | 0;
    _memcpy($21 | 0, $22 | 0, 124) | 0;
   }
  } while (0);
  $inc = $pos_016 + 1 | 0;
  if ($inc >>> 0 < (HEAP32[$lemma_num_ >> 2] | 0) >>> 0) {
   $pos_016 = $inc;
  } else {
   label = 264;
   break;
  }
 }
 if ((label | 0) == 258) {
  ___assert_func(4408, 315, 7728, 1616);
 } else if ((label | 0) == 264) {
  return;
 }
}
function __ZN10ime_pinyin11DictBuilder13read_raw_dictEPKcS2_j($this, $fn_raw, $fn_validhzs, $max_item) {
 $this = $this | 0;
 $fn_raw = $fn_raw | 0;
 $fn_validhzs = $fn_validhzs | 0;
 $max_item = $max_item | 0;
 var $utf16_reader = 0, $read_buf = 0, $valid_hzs_num = 0, $token_size = 0, $to_tokenize = 0, $call11 = 0, $arraydecay = 0, $lemma_arr_ = 0, $cmp66 = 0, $spl_table_ = 0, $i_045 = 0, $call19 = 0, $call27 = 0, $arraydecay35 = 0, $call41 = 0, $call49 = 0.0, $call61 = 0, $call65 = 0, $8 = 0, $9 = 0, $hz_pos_0 = 0, $call95 = 0, $17 = 0, $spelling_not_support_0_off0 = 0, $i_1 = 0, $inc143 = 0, $lemma_num_0 = 0, $retval_0 = 0, $retval_1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1072 | 0;
 $utf16_reader = sp | 0;
 $read_buf = sp + 24 | 0;
 $valid_hzs_num = sp + 1048 | 0;
 $token_size = sp + 1056 | 0;
 $to_tokenize = sp + 1064 | 0;
 if (($fn_raw | 0) == 0) {
  $retval_1 = 0;
  STACKTOP = sp;
  return $retval_1 | 0;
 }
 __ZN10ime_pinyin11Utf16ReaderC2Ev($utf16_reader);
 L301 : do {
  if (__ZN10ime_pinyin11Utf16Reader4openEPKcj($utf16_reader, $fn_raw, 5120) | 0) {
   if (!(__ZN10ime_pinyin11DictBuilder14alloc_resourceEj($this, 24e4) | 0)) {
    __ZN10ime_pinyin11Utf16Reader5closeEv($utf16_reader) | 0;
   }
   HEAP32[$valid_hzs_num >> 2] = 0;
   $call11 = __ZN10ime_pinyin11DictBuilder17read_valid_hanzisEPKcPj(0, $fn_validhzs, $valid_hzs_num) | 0;
   L308 : do {
    if (($max_item | 0) == 0) {
     $lemma_num_0 = 24e4;
    } else {
     $arraydecay = $read_buf | 0;
     $lemma_arr_ = $this | 0;
     $cmp66 = ($call11 | 0) == 0;
     $spl_table_ = $this + 52 | 0;
     $i_045 = 0;
     L310 : while (1) {
      if ((__ZN10ime_pinyin11Utf16Reader8readlineEPtj($utf16_reader, $arraydecay, 512) | 0) == 0) {
       $lemma_num_0 = $i_045;
       break L308;
      }
      HEAP32[$to_tokenize >> 2] = $arraydecay;
      $call19 = _utf16_strtok($arraydecay, $token_size, $to_tokenize) | 0;
      if (($call19 | 0) == 0) {
       label = 284;
       break;
      }
      $call27 = _utf16_strlen($call19) | 0;
      L317 : do {
       if ($call27 >>> 0 > 8) {
        $i_1 = $i_045 - 1 | 0;
       } else {
        if ($call27 >>> 0 > 4) {
         $i_1 = $i_045 - 1 | 0;
         break;
        }
        $arraydecay35 = (HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 8 | 0;
        _utf16_strcpy($arraydecay35, $call19) | 0;
        HEAP8[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 116 | 0] = HEAP32[$token_size >> 2] & 255;
        $call41 = _utf16_strtok(HEAP32[$to_tokenize >> 2] | 0, $token_size, $to_tokenize) | 0;
        if (($call41 | 0) == 0) {
         label = 294;
         break L310;
        }
        $call49 = +_utf16_atof($call41);
        HEAPF32[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 120 >> 2] = $call49;
        do {
         if ($call27 >>> 0 > 1) {
          if (+HEAPF32[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 120 >> 2] >= 60.0) {
           break;
          }
          $i_1 = $i_045 - 1 | 0;
          break L317;
         }
        } while (0);
        $call61 = _utf16_strtok(HEAP32[$to_tokenize >> 2] | 0, $token_size, $to_tokenize) | 0;
        if (($call61 | 0) == 0) {
         label = 302;
         break L310;
        }
        $call65 = _utf16_atoi($call61) | 0;
        do {
         if ($cmp66) {
          label = 307;
         } else {
          $8 = HEAP32[$valid_hzs_num >> 2] | 0;
          if (($8 | 0) == 0) {
           label = 307;
           break;
          }
          $9 = HEAP32[$lemma_arr_ >> 2] | 0;
          if (__ZN10ime_pinyin11DictBuilder18str_in_hanzis_listEPKtjS2_j(0, $call11, $8, $9 + ($i_045 * 124 | 0) + 8 | 0, HEAPU8[$9 + ($i_045 * 124 | 0) + 116 | 0] | 0) | 0) {
           $hz_pos_0 = 0;
           break;
          }
          $i_1 = $i_045 - 1 | 0;
          break L317;
         }
        } while (0);
        do {
         if ((label | 0) == 307) {
          label = 0;
          if (($call65 | 0) == 0) {
           $hz_pos_0 = 0;
           break;
          }
          $i_1 = $i_045 - 1 | 0;
          break L317;
         }
        } while (0);
        while (1) {
         if ($hz_pos_0 >>> 0 >= (HEAPU8[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 116 | 0] | 0) >>> 0) {
          $spelling_not_support_0_off0 = 1;
          break;
         }
         $call95 = _utf16_strtok(HEAP32[$to_tokenize >> 2] | 0, $token_size, $to_tokenize) | 0;
         if (($call95 | 0) == 0) {
          label = 315;
          break L310;
         }
         if ((_utf16_strlen($call95) | 0) >>> 0 >= 7) {
          label = 319;
          break L310;
         }
         _utf16_strcpy_tochar((HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 60 + ($hz_pos_0 * 7 | 0) | 0, $call95) | 0;
         __ZN10ime_pinyin11DictBuilder19format_spelling_strEPc(0, (HEAP32[$lemma_arr_ >> 2] | 0) + ($i_045 * 124 | 0) + 60 + ($hz_pos_0 * 7 | 0) | 0);
         $17 = HEAP32[$lemma_arr_ >> 2] | 0;
         if (__ZN10ime_pinyin13SpellingTable12put_spellingEPKcd(HEAP32[$spl_table_ >> 2] | 0, $17 + ($i_045 * 124 | 0) + 60 + ($hz_pos_0 * 7 | 0) | 0, +HEAPF32[$17 + ($i_045 * 124 | 0) + 120 >> 2]) | 0) {
          $hz_pos_0 = $hz_pos_0 + 1 | 0;
         } else {
          $spelling_not_support_0_off0 = 0;
          break;
         }
        }
        $i_1 = (($spelling_not_support_0_off0 & (_utf16_strtok(HEAP32[$to_tokenize >> 2] | 0, $token_size, $to_tokenize) | 0) == 0 ^ 1) << 31 >> 31) + $i_045 | 0;
       }
      } while (0);
      $inc143 = $i_1 + 1 | 0;
      if ($inc143 >>> 0 < $max_item >>> 0) {
       $i_045 = $inc143;
      } else {
       $lemma_num_0 = 24e4;
       break L308;
      }
     }
     if ((label | 0) == 294) {
      __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
      __ZN10ime_pinyin11Utf16Reader5closeEv($utf16_reader) | 0;
      $retval_0 = 0;
      break L301;
     } else if ((label | 0) == 284) {
      __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
      __ZN10ime_pinyin11Utf16Reader5closeEv($utf16_reader) | 0;
      $retval_0 = 0;
      break L301;
     } else if ((label | 0) == 302) {
      ___assert_func(4408, 448, 7776, 1344);
      return 0;
     } else if ((label | 0) == 315) {
      __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
      __ZN10ime_pinyin11Utf16Reader5closeEv($utf16_reader) | 0;
      $retval_0 = 0;
      break L301;
     } else if ((label | 0) == 319) {
      ___assert_func(4408, 475, 7776, 1096);
      return 0;
     }
    }
   } while (0);
   if (($call11 | 0) != 0) {
    __ZdaPv($call11);
   }
   __ZN10ime_pinyin11Utf16Reader5closeEv($utf16_reader) | 0;
   $retval_0 = $lemma_num_0;
  } else {
   $retval_0 = 0;
  }
 } while (0);
 __ZN10ime_pinyin11Utf16ReaderD2Ev($utf16_reader);
 $retval_1 = $retval_0;
 STACKTOP = sp;
 return $retval_1 | 0;
}
function __ZN10ime_pinyin11DictBuilder10build_dictEPKcS2_PNS_8DictTrieE($this, $fn_raw, $fn_validhzs, $dict_trie) {
 $this = $this | 0;
 $fn_raw = $fn_raw | 0;
 $fn_validhzs = $fn_validhzs | 0;
 $dict_trie = $dict_trie | 0;
 var $spl_item_size = 0, $spl_num = 0, $is_pre = 0, $call = 0, $lemma_num_ = 0, $spl_table_ = 0, $call7 = 0, $call11 = 0, $1 = 0, $2 = 0, $call13 = 0.0, $lemma_arr_ = 0, $spl_parser_ = 0, $arraydecay34 = 0, $arraydecay35 = 0, $i_049 = 0, $hz_pos_047 = 0, $8 = 0, $arraydecay = 0, $scis_num_ = 0, $17 = 0, $lemma_arr_63 = 0, $call69 = 0, $23 = 0, $24 = 0, $lma_nds_used_num_le0_ = 0, $lma_nodes_le0_ = 0, $call80 = 0, $34$0 = 0, $root_ = 0, $lma_nds_used_num_ge1_ = 0, $40$0 = 0, $nodes_ge1_ = 0, $homo_idx_num_eq1_ = 0, $homo_idx_num_gt1_ = 0, $top_lmas_num_ = 0, $add89 = 0, $mul = 0, $call90 = 0, $lma_idx_buf_ = 0, $53 = 0, $55 = 0, $mul109 = 0, $58 = 0, $60 = 0, $mul112 = 0, $homo_idx_buf_ = 0, $add116_lcssa = 0, $top_lmas_ = 0, $pos_043 = 0, $inc123 = 0, $add116 = 0, $pos125_040 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 40 | 0;
 $spl_item_size = sp | 0;
 $spl_num = sp + 8 | 0;
 $is_pre = sp + 32 | 0;
 if (($fn_raw | 0) == 0 | ($dict_trie | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin11DictBuilder13read_raw_dictEPKcS2_j($this, $fn_raw, $fn_validhzs, 24e4) | 0;
 $lemma_num_ = $this + 4 | 0;
 HEAP32[$lemma_num_ >> 2] = $call;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $spl_table_ = $this + 52 | 0;
 $call7 = __ZN10ime_pinyin13SpellingTable7arrangeEPjS1_(HEAP32[$spl_table_ >> 2] | 0, $spl_item_size, $spl_num) | 0;
 if (($call7 | 0) == 0) {
  __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $call11 = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $1 = HEAP32[$spl_item_size >> 2] | 0;
 $2 = HEAP32[$spl_num >> 2] | 0;
 $call13 = +__ZN10ime_pinyin13SpellingTable19get_score_amplifierEv(HEAP32[$spl_table_ >> 2] | 0);
 if (!(__ZN10ime_pinyin12SpellingTrie9constructEPKcjjfh($call11, $call7, $1, $2, $call13, __ZN10ime_pinyin13SpellingTable17get_average_scoreEv(HEAP32[$spl_table_ >> 2] | 0) | 0) | 0)) {
  __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 L386 : do {
  if ((HEAP32[$lemma_num_ >> 2] | 0) != 0) {
   $lemma_arr_ = $this | 0;
   $spl_parser_ = $this + 56 | 0;
   $arraydecay34 = sp + 16 | 0;
   $arraydecay35 = sp + 24 | 0;
   $i_049 = 0;
   L388 : while (1) {
    if ((HEAP8[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_049 * 124 | 0) + 116 | 0] | 0) != 0) {
     $hz_pos_047 = 0;
     do {
      HEAP8[$is_pre] = 1;
      $8 = HEAP32[$spl_parser_ >> 2] | 0;
      $arraydecay = (HEAP32[$lemma_arr_ >> 2] | 0) + ($i_049 * 124 | 0) + 60 + ($hz_pos_047 * 7 | 0) | 0;
      if ((__ZN10ime_pinyin14SpellingParser14splstr_to_idxsEPKctPtS3_tRb($8, $arraydecay, (_strlen($arraydecay | 0) | 0) & 65535, $arraydecay34, $arraydecay35, 2, $is_pre) | 0) << 16 >> 16 != 1) {
       label = 346;
       break L388;
      }
      if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt($call11, HEAP16[$arraydecay34 >> 1] | 0) | 0) {
       if ((__ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt($call11, HEAP16[$arraydecay34 >> 1] | 0, $arraydecay34) | 0) << 16 >> 16 == 0) {
        label = 349;
        break L388;
       }
      }
      HEAP16[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_049 * 124 | 0) + 42 + ($hz_pos_047 << 1) >> 1] = HEAP16[$arraydecay34 >> 1] | 0;
      $hz_pos_047 = $hz_pos_047 + 1 | 0;
     } while ($hz_pos_047 >>> 0 < (HEAPU8[(HEAP32[$lemma_arr_ >> 2] | 0) + ($i_049 * 124 | 0) + 116 | 0] | 0) >>> 0);
    }
    $i_049 = $i_049 + 1 | 0;
    if ($i_049 >>> 0 >= (HEAP32[$lemma_num_ >> 2] | 0) >>> 0) {
     break L386;
    }
   }
   if ((label | 0) == 349) {
    ___assert_func(4408, 556, 7912, 752);
    return 0;
   } else if ((label | 0) == 346) {
    ___assert_func(4408, 552, 7912, 920);
    return 0;
   }
  }
 } while (0);
 __ZN10ime_pinyin11DictBuilder17sort_lemmas_by_hzEv($this) | 0;
 $scis_num_ = $this + 12 | 0;
 HEAP32[$scis_num_ >> 2] = __ZN10ime_pinyin11DictBuilder10build_scisEv($this) | 0;
 $17 = __Znwj(128) | 0;
 __ZN10ime_pinyin8DictListC2Ev($17);
 HEAP32[$dict_trie + 4 >> 2] = $17;
 $lemma_arr_63 = $this | 0;
 if (!(__ZN10ime_pinyin8DictList9init_listEPKNS_14SingleCharItemEjPKNS_10LemmaEntryEj($17, HEAP32[$this + 8 >> 2] | 0, HEAP32[$scis_num_ >> 2] | 0, HEAP32[$lemma_arr_63 >> 2] | 0, HEAP32[$lemma_num_ >> 2] | 0) | 0)) {
  ___assert_func(4408, 572, 7912, 600);
  return 0;
 }
 $call69 = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 $23 = HEAP32[$lemma_arr_63 >> 2] | 0;
 $24 = HEAP32[$lemma_num_ >> 2] | 0;
 __ZN10ime_pinyin5NGram13build_unigramEPNS_10LemmaEntryEjj($call69, $23, $24, (HEAP32[$23 + (($24 - 1 | 0) * 124 | 0) + 4 >> 2] | 0) + 1 | 0) | 0;
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E(HEAP32[$lemma_arr_63 >> 2] | 0, HEAP32[$lemma_num_ >> 2] | 0, 124, 6);
 __ZN10ime_pinyin11DictBuilder14get_top_lemmasEv($this);
 __ZN10ime_pinyin11DictBuilder9stat_initEv($this);
 $lma_nds_used_num_le0_ = $this + 24 | 0;
 HEAP32[$lma_nds_used_num_le0_ >> 2] = 1;
 $lma_nodes_le0_ = $this + 16 | 0;
 $call80 = __ZN10ime_pinyin11DictBuilder16construct_subsetEPvPNS_10LemmaEntryEjjj($this, HEAP32[$lma_nodes_le0_ >> 2] | 0, HEAP32[$lemma_arr_63 >> 2] | 0, 0, HEAP32[$lemma_num_ >> 2] | 0, 0) | 0;
 if (!$call80) {
  __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $34$0 = _llvm_umul_with_overflow_i32(HEAP32[$lma_nds_used_num_le0_ >> 2] | 0, 16) | 0;
 $root_ = $dict_trie + 12 | 0;
 HEAP32[$root_ >> 2] = __Znaj(tempRet0 ? -1 : $34$0) | 0;
 $lma_nds_used_num_ge1_ = $this + 28 | 0;
 $40$0 = _llvm_umul_with_overflow_i32(HEAP32[$lma_nds_used_num_ge1_ >> 2] | 0, 10) | 0;
 $nodes_ge1_ = $dict_trie + 16 | 0;
 HEAP32[$nodes_ge1_ >> 2] = __Znaj(tempRet0 ? -1 : $40$0) | 0;
 $homo_idx_num_eq1_ = $this + 36 | 0;
 $homo_idx_num_gt1_ = $this + 40 | 0;
 $top_lmas_num_ = $this + 48 | 0;
 $add89 = (HEAP32[$homo_idx_num_gt1_ >> 2] | 0) + (HEAP32[$homo_idx_num_eq1_ >> 2] | 0) + (HEAP32[$top_lmas_num_ >> 2] | 0) | 0;
 $mul = $add89 * 3 | 0;
 $call90 = __Znaj($mul) | 0;
 $lma_idx_buf_ = $dict_trie + 32 | 0;
 HEAP32[$lma_idx_buf_ >> 2] = $call90;
 if ((HEAP32[$root_ >> 2] | 0) == 0) {
  ___assert_func(4408, 606, 7912, 4376);
  return 0;
 }
 if (($call90 | 0) == 0) {
  ___assert_func(4408, 607, 7912, 4256);
  return 0;
 }
 HEAP32[$dict_trie + 24 >> 2] = HEAP32[$lma_nds_used_num_le0_ >> 2];
 HEAP32[$dict_trie + 28 >> 2] = HEAP32[$lma_nds_used_num_ge1_ >> 2];
 HEAP32[$dict_trie + 36 >> 2] = $mul;
 HEAP32[$dict_trie + 44 >> 2] = HEAP32[$top_lmas_num_ >> 2];
 $53 = HEAP32[$root_ >> 2] | 0;
 $55 = HEAP32[$lma_nodes_le0_ >> 2] | 0;
 $mul109 = HEAP32[$lma_nds_used_num_le0_ >> 2] << 4;
 _memcpy($53 | 0, $55 | 0, $mul109) | 0;
 $58 = HEAP32[$nodes_ge1_ >> 2] | 0;
 $60 = HEAP32[$this + 20 >> 2] | 0;
 $mul112 = (HEAP32[$lma_nds_used_num_ge1_ >> 2] | 0) * 10 | 0;
 _memcpy($58 | 0, $60 | 0, $mul112) | 0;
 if ((HEAP32[$homo_idx_num_gt1_ >> 2] | 0) == (-(HEAP32[$homo_idx_num_eq1_ >> 2] | 0) | 0)) {
  $add116_lcssa = 0;
 } else {
  $homo_idx_buf_ = $this + 32 | 0;
  $pos_043 = 0;
  while (1) {
   __ZN10ime_pinyin11DictBuilder13id_to_charbufEPhj(0, (HEAP32[$lma_idx_buf_ >> 2] | 0) + ($pos_043 * 3 | 0) | 0, HEAP32[(HEAP32[$homo_idx_buf_ >> 2] | 0) + ($pos_043 << 2) >> 2] | 0);
   $inc123 = $pos_043 + 1 | 0;
   $add116 = (HEAP32[$homo_idx_num_gt1_ >> 2] | 0) + (HEAP32[$homo_idx_num_eq1_ >> 2] | 0) | 0;
   if ($inc123 >>> 0 < $add116 >>> 0) {
    $pos_043 = $inc123;
   } else {
    $add116_lcssa = $add116;
    break;
   }
  }
 }
 if ($add116_lcssa >>> 0 < $add89 >>> 0) {
  $top_lmas_ = $this + 44 | 0;
  $pos125_040 = $add116_lcssa;
  do {
   __ZN10ime_pinyin11DictBuilder13id_to_charbufEPhj(0, (HEAP32[$lma_idx_buf_ >> 2] | 0) + ($pos125_040 * 3 | 0) | 0, HEAP32[(HEAP32[$top_lmas_ >> 2] | 0) + (($pos125_040 - (HEAP32[$homo_idx_num_eq1_ >> 2] | 0) - (HEAP32[$homo_idx_num_gt1_ >> 2] | 0) | 0) * 124 | 0) + 4 >> 2] | 0);
   $pos125_040 = $pos125_040 + 1 | 0;
  } while ($pos125_040 >>> 0 < $add89 >>> 0);
 }
 __ZN10ime_pinyin11DictBuilder13free_resourceEv($this);
 $retval_0 = $call80;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11DictBuilder13id_to_charbufEPhj($this, $buf, $id) {
 $this = $this | 0;
 $buf = $buf | 0;
 $id = $id | 0;
 if (($buf | 0) == 0) {
  return;
 }
 HEAP8[$buf] = $id & 255;
 HEAP8[$buf + 1 | 0] = $id >>> 8 & 255;
 HEAP8[$buf + 2 | 0] = $id >>> 16 & 255;
 return;
}
function __ZN10ime_pinyin11DictBuilder14set_son_offsetEPNS_10LmaNodeGE1Ej($this, $node, $offset) {
 $this = $this | 0;
 $node = $node | 0;
 $offset = $offset | 0;
 HEAP16[$node >> 1] = $offset & 65535;
 HEAP8[$node + 8 | 0] = $offset >>> 16 & 255;
 return;
}
function __ZN10ime_pinyin11DictBuilder22set_homo_id_buf_offsetEPNS_10LmaNodeGE1Ej($this, $node, $offset) {
 $this = $this | 0;
 $node = $node | 0;
 $offset = $offset | 0;
 HEAP16[$node + 2 >> 1] = $offset & 65535;
 HEAP8[$node + 9 | 0] = $offset >>> 16 & 255;
 return;
}
function __ZN10ime_pinyin11DictBuilder9stat_initEv($this) {
 $this = $this | 0;
 _memset($this + 60 | 0, 0, 268);
 return;
}
function __ZN10ime_pinyin11DictBuilder10build_scisEv($this) {
 $this = $this | 0;
 var $key = 0, $scis_ = 0, $lemma_num_ = 0, $scis_num_ = 0, $call = 0, $6 = 0, $10 = 0, $lemma_arr_ = 0, $pos_049 = 0, $15 = 0, $conv = 0, $cmp42 = 0, $hzpos_047 = 0, $24 = 0, $call36 = 0, $36 = 0, $pos63_044 = 0, $unique_scis_num_043 = 0, $52 = 0, $sub = 0, $61 = 0, $62 = 0, $63 = 0, $64$1 = 0, $call99 = 0, $70 = 0, $unique_scis_num_1 = 0, $inc106 = 0, $unique_scis_num_0_lcssa = 0, $lemma_arr_115 = 0, $hz127 = 0, $76 = 0, $77 = 0, $pos109_040 = 0, $79 = 0, $conv118 = 0, $hzpos119_038 = 0, $83 = 0, $bf_value138 = 0, $call140 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $key = sp | 0;
 $scis_ = $this + 8 | 0;
 if ((HEAP32[$scis_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $lemma_num_ = $this + 4 | 0;
 $scis_num_ = $this + 12 | 0;
 if (HEAP32[$lemma_num_ >> 2] << 3 >>> 0 > (HEAP32[$scis_num_ >> 2] | 0) >>> 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 HEAPF32[HEAP32[$scis_ >> 2] >> 2] = 0.0;
 HEAP16[(HEAP32[$scis_ >> 2] | 0) + 4 >> 1] = 0;
 $6 = (HEAP32[$scis_ >> 2] | 0) + 6 | 0;
 HEAP16[$6 >> 1] = HEAP16[$6 >> 1] & 31;
 $10 = (HEAP32[$scis_ >> 2] | 0) + 6 | 0;
 HEAP16[$10 >> 1] = HEAP16[$10 >> 1] & -32;
 HEAP32[$scis_num_ >> 2] = 1;
 if ((HEAP32[$lemma_num_ >> 2] | 0) != 0) {
  $lemma_arr_ = $this | 0;
  $pos_049 = 0;
  do {
   $15 = HEAP8[(HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_049 * 124 | 0) + 116 | 0] | 0;
   $conv = $15 & 255;
   if ($15 << 24 >> 24 != 0) {
    $cmp42 = $15 << 24 >> 24 == 1;
    $hzpos_047 = 0;
    do {
     HEAP16[(HEAP32[$scis_ >> 2] | 0) + (HEAP32[$scis_num_ >> 2] << 3) + 4 >> 1] = HEAP16[(HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_049 * 124 | 0) + 8 + ($hzpos_047 << 1) >> 1] | 0;
     $24 = (HEAP32[$scis_ >> 2] | 0) + (HEAP32[$scis_num_ >> 2] << 3) + 6 | 0;
     HEAP16[$24 >> 1] = HEAP16[$24 >> 1] & 31 | HEAP16[(HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_049 * 124 | 0) + 42 + ($hzpos_047 << 1) >> 1] << 5;
     $call36 = __ZNK10ime_pinyin12SpellingTrie12full_to_halfEt($call, (HEAPU16[(HEAP32[$scis_ >> 2] | 0) + (HEAP32[$scis_num_ >> 2] << 3) + 6 >> 1] | 0) >>> 5) | 0;
     $36 = (HEAP32[$scis_ >> 2] | 0) + (HEAP32[$scis_num_ >> 2] << 3) + 6 | 0;
     HEAP16[$36 >> 1] = HEAP16[$36 >> 1] & -32 | $call36 & 31;
     if ($cmp42) {
      HEAPF32[(HEAP32[$scis_ >> 2] | 0) + (HEAP32[$scis_num_ >> 2] << 3) >> 2] = +HEAPF32[(HEAP32[$lemma_arr_ >> 2] | 0) + ($pos_049 * 124 | 0) + 120 >> 2];
     } else {
      HEAPF32[(HEAP32[$scis_ >> 2] | 0) + (HEAP32[$scis_num_ >> 2] << 3) >> 2] = 9.999999974752427e-7;
     }
     HEAP32[$scis_num_ >> 2] = (HEAP32[$scis_num_ >> 2] | 0) + 1;
     $hzpos_047 = $hzpos_047 + 1 | 0;
    } while ($hzpos_047 >>> 0 < $conv >>> 0);
   }
   $pos_049 = $pos_049 + 1 | 0;
  } while ($pos_049 >>> 0 < (HEAP32[$lemma_num_ >> 2] | 0) >>> 0);
 }
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E(HEAP32[$scis_ >> 2] | 0, HEAP32[$scis_num_ >> 2] | 0, 8, 50);
 if ((HEAP32[$scis_num_ >> 2] | 0) >>> 0 > 1) {
  $unique_scis_num_043 = 1;
  $pos63_044 = 1;
  while (1) {
   $52 = HEAP32[$scis_ >> 2] | 0;
   $sub = $pos63_044 - 1 | 0;
   if ((HEAP16[$52 + ($pos63_044 << 3) + 4 >> 1] | 0) == (HEAP16[$52 + ($sub << 3) + 4 >> 1] | 0)) {
    if ((HEAPU16[$52 + ($pos63_044 << 3) + 6 >> 1] | 0) >>> 5 << 16 >> 16 == (HEAPU16[$52 + ($sub << 3) + 6 >> 1] | 0) >>> 5 << 16 >> 16) {
     $unique_scis_num_1 = $unique_scis_num_043;
    } else {
     label = 398;
    }
   } else {
    label = 398;
   }
   if ((label | 0) == 398) {
    label = 0;
    $61 = HEAP32[$scis_ >> 2] | 0;
    $62 = $61 + ($pos63_044 << 3) | 0;
    $63 = $61 + ($unique_scis_num_043 << 3) | 0;
    $64$1 = HEAP32[$62 + 4 >> 2] | 0;
    HEAP32[$63 >> 2] = HEAP32[$62 >> 2];
    HEAP32[$63 + 4 >> 2] = $64$1;
    $call99 = __ZNK10ime_pinyin12SpellingTrie12full_to_halfEt($call, (HEAPU16[(HEAP32[$scis_ >> 2] | 0) + ($pos63_044 << 3) + 6 >> 1] | 0) >>> 5) | 0;
    $70 = (HEAP32[$scis_ >> 2] | 0) + ($unique_scis_num_043 << 3) + 6 | 0;
    HEAP16[$70 >> 1] = HEAP16[$70 >> 1] & -32 | $call99 & 31;
    $unique_scis_num_1 = $unique_scis_num_043 + 1 | 0;
   }
   $inc106 = $pos63_044 + 1 | 0;
   if ($inc106 >>> 0 < (HEAP32[$scis_num_ >> 2] | 0) >>> 0) {
    $unique_scis_num_043 = $unique_scis_num_1;
    $pos63_044 = $inc106;
   } else {
    $unique_scis_num_0_lcssa = $unique_scis_num_1;
    break;
   }
  }
 } else {
  $unique_scis_num_0_lcssa = 1;
 }
 HEAP32[$scis_num_ >> 2] = $unique_scis_num_0_lcssa;
 L465 : do {
  if ((HEAP32[$lemma_num_ >> 2] | 0) != 0) {
   $lemma_arr_115 = $this | 0;
   $hz127 = $key + 4 | 0;
   $76 = $key + 6 | 0;
   $77 = $key;
   $pos109_040 = 0;
   L467 : while (1) {
    $79 = HEAP8[(HEAP32[$lemma_arr_115 >> 2] | 0) + ($pos109_040 * 124 | 0) + 116 | 0] | 0;
    $conv118 = $79 & 255;
    if ($79 << 24 >> 24 != 0) {
     $hzpos119_038 = 0;
     do {
      HEAP16[$hz127 >> 1] = HEAP16[(HEAP32[$lemma_arr_115 >> 2] | 0) + ($pos109_040 * 124 | 0) + 8 + ($hzpos119_038 << 1) >> 1] | 0;
      $83 = HEAP16[(HEAP32[$lemma_arr_115 >> 2] | 0) + ($pos109_040 * 124 | 0) + 42 + ($hzpos119_038 << 1) >> 1] | 0;
      HEAP16[$76 >> 1] = HEAP16[$76 >> 1] & 31 | $83 << 5;
      $bf_value138 = (__ZNK10ime_pinyin12SpellingTrie12full_to_halfEt($call, $83 & 2047) | 0) & 31;
      HEAP16[$76 >> 1] = HEAP16[$76 >> 1] & -32 | $bf_value138;
      $call140 = __ZN10ime_pinyin9mybsearchEPKvS1_jjPFiS1_S1_E($77, HEAP32[$scis_ >> 2] | 0, $unique_scis_num_0_lcssa, 8, 34) | 0;
      if (($call140 | 0) == 0) {
       break L467;
      }
      HEAP16[(HEAP32[$lemma_arr_115 >> 2] | 0) + ($pos109_040 * 124 | 0) + 26 + ($hzpos119_038 << 1) >> 1] = ($call140 - (HEAP32[$scis_ >> 2] | 0) | 0) >>> 3 & 65535;
      HEAP16[(HEAP32[$lemma_arr_115 >> 2] | 0) + ($pos109_040 * 124 | 0) + 42 + ($hzpos119_038 << 1) >> 1] = (HEAPU16[$call140 + 6 >> 1] | 0) >>> 5;
      $hzpos119_038 = $hzpos119_038 + 1 | 0;
     } while ($hzpos119_038 >>> 0 < $conv118 >>> 0);
    }
    $pos109_040 = $pos109_040 + 1 | 0;
    if ($pos109_040 >>> 0 >= (HEAP32[$lemma_num_ >> 2] | 0) >>> 0) {
     break L465;
    }
   }
   ___assert_func(4408, 763, 7864, 4048);
   return 0;
  }
 } while (0);
 $retval_0 = HEAP32[$scis_num_ >> 2] | 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11DictBuilder16construct_subsetEPvPNS_10LemmaEntryEjjj($this, $parent, $lemma_arr, $item_start, $item_end, $level) {
 $this = $this | 0;
 $parent = $parent | 0;
 $lemma_arr = $lemma_arr | 0;
 $item_start = $item_start | 0;
 $item_end = $item_end | 0;
 $level = $level | 0;
 var $lemma_arr_ = 0, $add = 0, $parent_son_num_0192 = 0, $spl_idx_node_0191 = 0, $i_0190 = 0, $2 = 0, $parent_son_num_0_inc = 0, $inc11 = 0, $parent_son_num_0_lcssa = 0, $inc12 = 0, $arrayidx14 = 0, $arrayidx20 = 0, $arrayidx22 = 0, $sonbufs_num1_ = 0, $sonbufs_numgt1_ = 0, $total_lma_node_num_ = 0, $cmp30 = 0, $lma_nds_used_num_le0_ = 0, $10 = 0, $11 = 0, $lma_nds_used_num_ge1_ = 0, $14 = 0, $15 = 0, $lma_nds_used_num_ge1_56 = 0, $19 = 0, $20 = 0, $son_1st_le0_0 = 0, $son_1st_ge1_0 = 0, $22 = 0, $23 = 0, $add74 = 0, $_ = 0, $homo_num_1_neg171 = 0, $homo_idx_num_eq1_ = 0, $homo_idx_num_gt1_ = 0, $arrayidx170 = 0, $homo_idx_buf_ = 0, $homo_idx_num_eq1_123 = 0, $homo_idx_num_gt1_125 = 0, $arrayidx153 = 0, $arrayidx159 = 0, $homo_idx_num_eq1_115 = 0, $homo_idx_num_gt1_116 = 0, $homo_num_1_neg183 = 0, $spl_idx_node_2182 = 0, $i81_0180 = 0, $item_start_next_0177 = 0, $homo_num_1175 = 0, $son_pos_0174 = 0, $allson_noson_0_off0173 = 0, $25 = 0, $26 = 0, $add_ptr107 = 0, $add_ptr113 = 0, $node_cur_le0_0 = 0, $node_cur_ge1_0 = 0, $34 = 0, $35 = 0, $36 = 0, $add_ptr126_sum = 0, $homo_pos_0155 = 0, $next_parent_0 = 0, $add168 = 0, $allson_noson_1_off0 = 0, $allson_noson_2_off0 = 0, $son_pos_1 = 0, $homo_num_3 = 0, $item_start_next_1 = 0, $spl_idx_node_3 = 0, $inc183 = 0, $homo_num_1_neg = 0, $homo_num_1_neg_lcssa = 0, $spl_idx_node_2_lcssa = 0, $item_start_next_0_lcssa = 0, $homo_num_1_lcssa = 0, $son_pos_0_lcssa = 0, $allson_noson_0_off0_lcssa = 0, $add_ptr189 = 0, $homo_idx_num_eq1_191 = 0, $add_ptr199 = 0, $homo_idx_num_gt1_202 = 0, $node_cur_le0185_0 = 0, $node_cur_ge1186_0 = 0, $51 = 0, $52 = 0, $53 = 0, $add_ptr214_sum = 0, $homo_pos233_0153 = 0, $arrayidx245 = 0, $arrayidx252 = 0, $next_parent258_0 = 0, $add263 = 0, $arrayidx267 = 0, $arrayidx271 = 0, $arrayidx273 = 0, $retval_0 = 0, label = 0;
 if (!($level >>> 0 < 8 & $item_end >>> 0 > $item_start >>> 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lemma_arr_ = $this | 0;
 $add = $item_start + 1 | 0;
 if ($add >>> 0 < $item_end >>> 0) {
  $i_0190 = $add;
  $spl_idx_node_0191 = HEAP16[(HEAP32[$lemma_arr_ >> 2] | 0) + ($item_start * 124 | 0) + 42 + ($level << 1) >> 1] | 0;
  $parent_son_num_0192 = 0;
  while (1) {
   $2 = HEAP16[$lemma_arr + ($i_0190 * 124 | 0) + 42 + ($level << 1) >> 1] | 0;
   $parent_son_num_0_inc = ($2 << 16 >> 16 != $spl_idx_node_0191 << 16 >> 16) + $parent_son_num_0192 | 0;
   $inc11 = $i_0190 + 1 | 0;
   if ($inc11 >>> 0 < $item_end >>> 0) {
    $i_0190 = $inc11;
    $spl_idx_node_0191 = $2;
    $parent_son_num_0192 = $parent_son_num_0_inc;
   } else {
    $parent_son_num_0_lcssa = $parent_son_num_0_inc;
    break;
   }
  }
 } else {
  $parent_son_num_0_lcssa = 0;
 }
 $inc12 = $parent_son_num_0_lcssa + 1 | 0;
 if ($level >>> 0 >= 8) {
  ___assert_func(4408, 803, 7616, 3816);
  return 0;
 }
 $arrayidx14 = $this + 60 + ($level << 2) | 0;
 if ($inc12 >>> 0 > (HEAP32[$arrayidx14 >> 2] | 0) >>> 0) {
  HEAP32[$arrayidx14 >> 2] = $inc12;
 }
 $arrayidx20 = $this + 124 + ($level << 2) | 0;
 HEAP32[$arrayidx20 >> 2] = (HEAP32[$arrayidx20 >> 2] | 0) + $inc12;
 $arrayidx22 = $this + 188 + ($level << 2) | 0;
 HEAP32[$arrayidx22 >> 2] = (HEAP32[$arrayidx22 >> 2] | 0) + 1;
 if (($parent_son_num_0_lcssa | 0) == 0) {
  $sonbufs_num1_ = $this + 316 | 0;
  HEAP32[$sonbufs_num1_ >> 2] = (HEAP32[$sonbufs_num1_ >> 2] | 0) + 1;
 } else {
  $sonbufs_numgt1_ = $this + 320 | 0;
  HEAP32[$sonbufs_numgt1_ >> 2] = (HEAP32[$sonbufs_numgt1_ >> 2] | 0) + 1;
 }
 $total_lma_node_num_ = $this + 324 | 0;
 HEAP32[$total_lma_node_num_ >> 2] = (HEAP32[$total_lma_node_num_ >> 2] | 0) + $inc12;
 $cmp30 = ($level | 0) == 0;
 do {
  if ($cmp30) {
   $lma_nds_used_num_le0_ = $this + 24 | 0;
   HEAP32[$parent >> 2] = HEAP32[$lma_nds_used_num_le0_ >> 2];
   $10 = HEAP32[$this + 16 >> 2] | 0;
   $11 = HEAP32[$lma_nds_used_num_le0_ >> 2] | 0;
   HEAP32[$lma_nds_used_num_le0_ >> 2] = $11 + $inc12;
   if ($inc12 >>> 0 < 65536) {
    HEAP16[$parent + 10 >> 1] = $inc12 & 65535;
    $son_1st_ge1_0 = 0;
    $son_1st_le0_0 = $10 + ($11 << 4) | 0;
    break;
   } else {
    ___assert_func(4408, 827, 7616, 3640);
    return 0;
   }
  } else {
   if (($level | 0) == 1) {
    $lma_nds_used_num_ge1_ = $this + 28 | 0;
    HEAP32[$parent >> 2] = HEAP32[$lma_nds_used_num_ge1_ >> 2];
    $14 = HEAP32[$this + 20 >> 2] | 0;
    $15 = HEAP32[$lma_nds_used_num_ge1_ >> 2] | 0;
    HEAP32[$lma_nds_used_num_ge1_ >> 2] = $15 + $inc12;
    if ($inc12 >>> 0 < 65536) {
     HEAP16[$parent + 10 >> 1] = $inc12 & 65535;
     $son_1st_ge1_0 = $14 + ($15 * 10 | 0) | 0;
     $son_1st_le0_0 = 0;
     break;
    } else {
     ___assert_func(4408, 836, 7616, 3640);
     return 0;
    }
   } else {
    $lma_nds_used_num_ge1_56 = $this + 28 | 0;
    __ZN10ime_pinyin11DictBuilder14set_son_offsetEPNS_10LmaNodeGE1Ej(0, $parent, HEAP32[$lma_nds_used_num_ge1_56 >> 2] | 0);
    $19 = HEAP32[$this + 20 >> 2] | 0;
    $20 = HEAP32[$lma_nds_used_num_ge1_56 >> 2] | 0;
    HEAP32[$lma_nds_used_num_ge1_56 >> 2] = $20 + $inc12;
    if ($inc12 >>> 0 < 256) {
     HEAP8[$parent + 6 | 0] = $inc12 & 255;
     $son_1st_ge1_0 = $19 + ($20 * 10 | 0) | 0;
     $son_1st_le0_0 = 0;
     break;
    } else {
     ___assert_func(4408, 845, 7616, 3528);
     return 0;
    }
   }
  }
 } while (0);
 $22 = HEAP32[$lemma_arr_ >> 2] | 0;
 $23 = HEAP16[$22 + ($item_start * 124 | 0) + 42 + ($level << 1) >> 1] | 0;
 $add74 = $level + 1 | 0;
 $_ = (HEAP16[$22 + ($item_start * 124 | 0) + 42 + ($add74 << 1) >> 1] | 0) == 0 | 0;
 $homo_num_1_neg171 = -$_ | 0;
 L512 : do {
  if ($add >>> 0 < $item_end >>> 0) {
   $homo_idx_num_eq1_ = $this + 36 | 0;
   $homo_idx_num_gt1_ = $this + 40 | 0;
   $arrayidx170 = $this + 156 + ($level << 2) | 0;
   $homo_idx_buf_ = $this + 32 | 0;
   $homo_idx_num_eq1_123 = $this + 36 | 0;
   $homo_idx_num_gt1_125 = $this + 40 | 0;
   $arrayidx153 = $this + 92 + ($level << 2) | 0;
   $arrayidx159 = $this + 284 + ($level << 2) | 0;
   $homo_idx_num_eq1_115 = $this + 36 | 0;
   $homo_idx_num_gt1_116 = $this + 40 | 0;
   $allson_noson_0_off0173 = 1;
   $son_pos_0174 = 0;
   $homo_num_1175 = $_;
   $item_start_next_0177 = $item_start;
   $i81_0180 = $add;
   $spl_idx_node_2182 = $23;
   $homo_num_1_neg183 = $homo_num_1_neg171;
   while (1) {
    $25 = HEAP32[$lemma_arr_ >> 2] | 0;
    $26 = HEAP16[$25 + ($i81_0180 * 124 | 0) + 42 + ($level << 1) >> 1] | 0;
    if ($26 << 16 >> 16 == $spl_idx_node_2182 << 16 >> 16) {
     $spl_idx_node_3 = $spl_idx_node_2182;
     $item_start_next_1 = $item_start_next_0177;
     $homo_num_3 = ((HEAP16[$25 + ($i81_0180 * 124 | 0) + 42 + ($add74 << 1) >> 1] | 0) == 0) + $homo_num_1175 | 0;
     $son_pos_1 = $son_pos_0174;
     $allson_noson_2_off0 = $allson_noson_0_off0173;
    } else {
     if ($cmp30) {
      $add_ptr107 = $son_1st_le0_0 + ($son_pos_0174 << 4) | 0;
      HEAP16[$son_1st_le0_0 + ($son_pos_0174 << 4) + 8 >> 1] = $spl_idx_node_2182;
      HEAP32[$son_1st_le0_0 + ($son_pos_0174 << 4) + 4 >> 2] = (HEAP32[$homo_idx_num_gt1_ >> 2] | 0) + (HEAP32[$homo_idx_num_eq1_ >> 2] | 0);
      HEAP32[$add_ptr107 >> 2] = 0;
      HEAP32[$homo_idx_num_eq1_ >> 2] = (HEAP32[$homo_idx_num_eq1_ >> 2] | 0) + $homo_num_1175;
      $node_cur_ge1_0 = 0;
      $node_cur_le0_0 = $add_ptr107;
     } else {
      $add_ptr113 = $son_1st_ge1_0 + ($son_pos_0174 * 10 | 0) | 0;
      HEAP16[$son_1st_ge1_0 + ($son_pos_0174 * 10 | 0) + 4 >> 1] = $spl_idx_node_2182;
      __ZN10ime_pinyin11DictBuilder22set_homo_id_buf_offsetEPNS_10LmaNodeGE1Ej(0, $add_ptr113, (HEAP32[$homo_idx_num_gt1_116 >> 2] | 0) + (HEAP32[$homo_idx_num_eq1_115 >> 2] | 0) | 0);
      __ZN10ime_pinyin11DictBuilder14set_son_offsetEPNS_10LmaNodeGE1Ej(0, $add_ptr113, 0);
      HEAP32[$homo_idx_num_gt1_116 >> 2] = (HEAP32[$homo_idx_num_gt1_116 >> 2] | 0) + $homo_num_1175;
      $node_cur_ge1_0 = $add_ptr113;
      $node_cur_le0_0 = 0;
     }
     if (($homo_num_1175 | 0) != 0) {
      $34 = HEAP32[$homo_idx_buf_ >> 2] | 0;
      $35 = HEAP32[$homo_idx_num_eq1_123 >> 2] | 0;
      $36 = HEAP32[$homo_idx_num_gt1_125 >> 2] | 0;
      if ($cmp30) {
       if ($homo_num_1175 >>> 0 >= 65536) {
        label = 444;
        break;
       }
       HEAP16[$node_cur_le0_0 + 12 >> 1] = $homo_num_1175 & 65535;
      } else {
       if ($homo_num_1175 >>> 0 >= 256) {
        label = 447;
        break;
       }
       HEAP8[$node_cur_ge1_0 + 7 | 0] = $homo_num_1175 & 255;
      }
      if (($homo_num_1175 | 0) != 0) {
       $add_ptr126_sum = $35 + $homo_num_1_neg183 + $36 | 0;
       $homo_pos_0155 = 0;
       do {
        HEAP32[$34 + ($add_ptr126_sum + $homo_pos_0155 << 2) >> 2] = HEAP32[(HEAP32[$lemma_arr_ >> 2] | 0) + (($homo_pos_0155 + $item_start_next_0177 | 0) * 124 | 0) + 4 >> 2];
        $homo_pos_0155 = $homo_pos_0155 + 1 | 0;
       } while ($homo_pos_0155 >>> 0 < $homo_num_1175 >>> 0);
      }
      if ($homo_num_1175 >>> 0 > (HEAP32[$arrayidx153 >> 2] | 0) >>> 0) {
       HEAP32[$arrayidx153 >> 2] = $homo_num_1175;
      }
      HEAP32[$arrayidx159 >> 2] = (HEAP32[$arrayidx159 >> 2] | 0) + $homo_num_1175;
     }
     if (($i81_0180 - $item_start_next_0177 | 0) >>> 0 > $homo_num_1175 >>> 0) {
      if ($cmp30) {
       $next_parent_0 = $node_cur_le0_0;
      } else {
       $next_parent_0 = $node_cur_ge1_0;
      }
      $add168 = $item_start_next_0177 + $homo_num_1175 | 0;
      __ZN10ime_pinyin11DictBuilder16construct_subsetEPvPNS_10LemmaEntryEjjj($this, $next_parent_0, $lemma_arr, $add168, $i81_0180, $add74) | 0;
      HEAP32[$arrayidx170 >> 2] = (HEAP32[$arrayidx170 >> 2] | 0) + 1;
      $allson_noson_1_off0 = 0;
     } else {
      $allson_noson_1_off0 = $allson_noson_0_off0173;
     }
     $spl_idx_node_3 = $26;
     $item_start_next_1 = $i81_0180;
     $homo_num_3 = (HEAP16[$25 + ($i81_0180 * 124 | 0) + 42 + ($add74 << 1) >> 1] | 0) == 0 | 0;
     $son_pos_1 = $son_pos_0174 + 1 | 0;
     $allson_noson_2_off0 = $allson_noson_1_off0;
    }
    $inc183 = $i81_0180 + 1 | 0;
    $homo_num_1_neg = -$homo_num_3 | 0;
    if ($inc183 >>> 0 < $item_end >>> 0) {
     $allson_noson_0_off0173 = $allson_noson_2_off0;
     $son_pos_0174 = $son_pos_1;
     $homo_num_1175 = $homo_num_3;
     $item_start_next_0177 = $item_start_next_1;
     $i81_0180 = $inc183;
     $spl_idx_node_2182 = $spl_idx_node_3;
     $homo_num_1_neg183 = $homo_num_1_neg;
    } else {
     $allson_noson_0_off0_lcssa = $allson_noson_2_off0;
     $son_pos_0_lcssa = $son_pos_1;
     $homo_num_1_lcssa = $homo_num_3;
     $item_start_next_0_lcssa = $item_start_next_1;
     $spl_idx_node_2_lcssa = $spl_idx_node_3;
     $homo_num_1_neg_lcssa = $homo_num_1_neg;
     break L512;
    }
   }
   if ((label | 0) == 444) {
    ___assert_func(4408, 893, 7616, 3376);
    return 0;
   } else if ((label | 0) == 447) {
    ___assert_func(4408, 896, 7616, 3264);
    return 0;
   }
  } else {
   $allson_noson_0_off0_lcssa = 1;
   $son_pos_0_lcssa = 0;
   $homo_num_1_lcssa = $_;
   $item_start_next_0_lcssa = $item_start;
   $spl_idx_node_2_lcssa = $23;
   $homo_num_1_neg_lcssa = $homo_num_1_neg171;
  }
 } while (0);
 if ($cmp30) {
  $add_ptr189 = $son_1st_le0_0 + ($son_pos_0_lcssa << 4) | 0;
  HEAP16[$son_1st_le0_0 + ($son_pos_0_lcssa << 4) + 8 >> 1] = $spl_idx_node_2_lcssa;
  $homo_idx_num_eq1_191 = $this + 36 | 0;
  HEAP32[$son_1st_le0_0 + ($son_pos_0_lcssa << 4) + 4 >> 2] = (HEAP32[$this + 40 >> 2] | 0) + (HEAP32[$homo_idx_num_eq1_191 >> 2] | 0);
  HEAP32[$add_ptr189 >> 2] = 0;
  HEAP32[$homo_idx_num_eq1_191 >> 2] = (HEAP32[$homo_idx_num_eq1_191 >> 2] | 0) + $homo_num_1_lcssa;
  $node_cur_ge1186_0 = 0;
  $node_cur_le0185_0 = $add_ptr189;
 } else {
  $add_ptr199 = $son_1st_ge1_0 + ($son_pos_0_lcssa * 10 | 0) | 0;
  HEAP16[$son_1st_ge1_0 + ($son_pos_0_lcssa * 10 | 0) + 4 >> 1] = $spl_idx_node_2_lcssa;
  $homo_idx_num_gt1_202 = $this + 40 | 0;
  __ZN10ime_pinyin11DictBuilder22set_homo_id_buf_offsetEPNS_10LmaNodeGE1Ej(0, $add_ptr199, (HEAP32[$homo_idx_num_gt1_202 >> 2] | 0) + (HEAP32[$this + 36 >> 2] | 0) | 0);
  __ZN10ime_pinyin11DictBuilder14set_son_offsetEPNS_10LmaNodeGE1Ej(0, $add_ptr199, 0);
  HEAP32[$homo_idx_num_gt1_202 >> 2] = (HEAP32[$homo_idx_num_gt1_202 >> 2] | 0) + $homo_num_1_lcssa;
  $node_cur_ge1186_0 = $add_ptr199;
  $node_cur_le0185_0 = 0;
 }
 if (($homo_num_1_lcssa | 0) != 0) {
  $51 = HEAP32[$this + 32 >> 2] | 0;
  $52 = HEAP32[$this + 36 >> 2] | 0;
  $53 = HEAP32[$this + 40 >> 2] | 0;
  do {
   if ($cmp30) {
    if ($homo_num_1_lcssa >>> 0 < 65536) {
     HEAP16[$node_cur_le0185_0 + 12 >> 1] = $homo_num_1_lcssa & 65535;
     break;
    } else {
     ___assert_func(4408, 962, 7616, 3376);
     return 0;
    }
   } else {
    if ($homo_num_1_lcssa >>> 0 < 256) {
     HEAP8[$node_cur_ge1186_0 + 7 | 0] = $homo_num_1_lcssa & 255;
     break;
    } else {
     ___assert_func(4408, 965, 7616, 3264);
     return 0;
    }
   }
  } while (0);
  if (($homo_num_1_lcssa | 0) != 0) {
   $add_ptr214_sum = $52 + $homo_num_1_neg_lcssa + $53 | 0;
   $homo_pos233_0153 = 0;
   do {
    HEAP32[$51 + ($add_ptr214_sum + $homo_pos233_0153 << 2) >> 2] = HEAP32[$lemma_arr + (($homo_pos233_0153 + $item_start_next_0_lcssa | 0) * 124 | 0) + 4 >> 2];
    $homo_pos233_0153 = $homo_pos233_0153 + 1 | 0;
   } while ($homo_pos233_0153 >>> 0 < $homo_num_1_lcssa >>> 0);
  }
  $arrayidx245 = $this + 92 + ($level << 2) | 0;
  if ($homo_num_1_lcssa >>> 0 > (HEAP32[$arrayidx245 >> 2] | 0) >>> 0) {
   HEAP32[$arrayidx245 >> 2] = $homo_num_1_lcssa;
  }
  $arrayidx252 = $this + 284 + ($level << 2) | 0;
  HEAP32[$arrayidx252 >> 2] = (HEAP32[$arrayidx252 >> 2] | 0) + $homo_num_1_lcssa;
 }
 do {
  if (($item_end - $item_start_next_0_lcssa | 0) >>> 0 > $homo_num_1_lcssa >>> 0) {
   if ($cmp30) {
    $next_parent258_0 = $node_cur_le0185_0;
   } else {
    $next_parent258_0 = $node_cur_ge1186_0;
   }
   $add263 = $item_start_next_0_lcssa + $homo_num_1_lcssa | 0;
   __ZN10ime_pinyin11DictBuilder16construct_subsetEPvPNS_10LemmaEntryEjjj($this, $next_parent258_0, $lemma_arr, $add263, $item_end, $add74) | 0;
   $arrayidx267 = $this + 156 + ($level << 2) | 0;
   HEAP32[$arrayidx267 >> 2] = (HEAP32[$arrayidx267 >> 2] | 0) + 1;
  } else {
   if (!$allson_noson_0_off0_lcssa) {
    break;
   }
   $arrayidx271 = $this + 220 + ($level << 2) | 0;
   HEAP32[$arrayidx271 >> 2] = (HEAP32[$arrayidx271 >> 2] | 0) + 1;
   $arrayidx273 = $this + 252 + ($level << 2) | 0;
   HEAP32[$arrayidx273 >> 2] = (HEAP32[$arrayidx273 >> 2] | 0) + $inc12;
  }
 } while (0);
 if (($son_pos_0_lcssa + 1 | 0) == ($inc12 | 0)) {
  $retval_0 = 1;
  return $retval_0 | 0;
 } else {
  ___assert_func(4408, 1003, 7616, 3144);
  return 0;
 }
 return 0;
}
function __ZN10ime_pinyin12AtomDictBaseC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8368;
 return;
}
function __ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, $id_offset) {
 $this = $this | 0;
 $id_offset = $id_offset | 0;
 var $mul = 0, $0 = 0;
 $mul = $id_offset * 3 | 0;
 $0 = HEAP32[$this + 32 >> 2] | 0;
 return HEAPU8[(HEAP32[$this + 32 >> 2] | 0) + $mul | 0] | 0 | (HEAPU8[$0 + ($mul + 1) | 0] | 0 | (HEAPU8[$0 + ($mul + 2) | 0] | 0) << 8) << 8 | 0;
}
function __ZN10ime_pinyin11DictBuilder10stat_printEv($this) {
 $this = $this | 0;
 var sp = 0;
 sp = STACKTOP;
 _puts(72) | 0;
 _puts(48) | 0;
 _printf(2936, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 60 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 64 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 68 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 72 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 76 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 80 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 84 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 88 >> 2], tempInt) | 0) | 0;
 _puts(40) | 0;
 _printf(2552, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 92 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 96 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 100 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 104 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 108 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 112 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 116 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 120 >> 2], tempInt) | 0) | 0;
 _putchar(10) | 0;
 _printf(2408, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 124 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 128 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 132 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 136 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 140 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 144 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 148 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 152 >> 2], tempInt) | 0) | 0;
 _puts(32) | 0;
 _printf(2320, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 156 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 160 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 164 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 168 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 172 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 176 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 180 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 184 >> 2], tempInt) | 0) | 0;
 _putchar(10) | 0;
 _printf(2264, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 188 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 192 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 196 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 200 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 204 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 208 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 212 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 216 >> 2], tempInt) | 0) | 0;
 _puts(24) | 0;
 _printf(2208, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 220 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 224 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 228 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 232 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 236 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 240 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 244 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 248 >> 2], tempInt) | 0) | 0;
 _puts(16) | 0;
 _printf(2080, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 252 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 256 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 260 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 264 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 268 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 272 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 276 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 280 >> 2], tempInt) | 0) | 0;
 _puts(8) | 0;
 _printf(2032, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 284 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 288 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 292 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 296 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 300 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 304 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 308 >> 2], tempInt) | 0) | 0;
 _printf(2840, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 312 >> 2], tempInt) | 0) | 0;
 _putchar(10) | 0;
 _printf(1936, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 316 >> 2], tempInt) | 0) | 0;
 _printf(1800, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP32[$this + 320 >> 2], tempInt) | 0) | 0;
 _printf(1656, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = (HEAP32[$this + 324 >> 2] | 0) + 1, tempInt) | 0) | 0;
 STACKTOP = sp;
 return;
}
function __ZN10ime_pinyin8DictTrieC2Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin12AtomDictBaseC2Ev($this | 0);
 HEAP32[$this >> 2] = 8272;
 HEAP32[$this + 8 >> 2] = __ZN10ime_pinyin12SpellingTrie14get_cpinstanceEv() | 0;
 HEAP32[$this + 4 >> 2] = 0;
 HEAP32[$this + 56 >> 2] = 0;
 _memset($this + 12 | 0, 0, 40);
 FUNCTION_TABLE_viii[HEAP32[(HEAP32[$this >> 2] | 0) + 20 >> 2] & 15]($this, 0, 1);
 return;
}
function __ZN10ime_pinyin8DictTrieD0Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin8DictTrieD2Ev($this);
 __ZdlPv($this);
 return;
}
function __ZN10ime_pinyin8DictTrieD2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8272;
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 1);
 return;
}
function __ZN10ime_pinyin8DictTrie13free_resourceEb($this, $free_dict_list) {
 $this = $this | 0;
 $free_dict_list = $free_dict_list | 0;
 var $root_ = 0, $0 = 0, $splid_le0_index_ = 0, $2 = 0, $nodes_ge1_ = 0, $4 = 0, $dict_list_ = 0, $6 = 0, $parsing_marks_ = 0, $10 = 0, $mile_stones_ = 0, $12 = 0, $14 = 0, $vtable = 0, $vfn = 0, $15 = 0;
 $root_ = $this + 12 | 0;
 $0 = HEAP32[$root_ >> 2] | 0;
 if (($0 | 0) != 0) {
  _free($0);
 }
 HEAP32[$root_ >> 2] = 0;
 $splid_le0_index_ = $this + 20 | 0;
 $2 = HEAP32[$splid_le0_index_ >> 2] | 0;
 if (($2 | 0) != 0) {
  _free($2);
 }
 HEAP32[$splid_le0_index_ >> 2] = 0;
 $nodes_ge1_ = $this + 16 | 0;
 $4 = HEAP32[$nodes_ge1_ >> 2] | 0;
 if (($4 | 0) != 0) {
  _free($4);
 }
 HEAP32[$nodes_ge1_ >> 2] = 0;
 if ($free_dict_list) {
  $dict_list_ = $this + 4 | 0;
  $6 = HEAP32[$dict_list_ >> 2] | 0;
  if (($6 | 0) != 0) {
   __ZN10ime_pinyin8DictListD2Ev($6);
   __ZdlPv($6 | 0);
  }
  HEAP32[$dict_list_ >> 2] = 0;
 }
 $parsing_marks_ = $this + 48 | 0;
 $10 = HEAP32[$parsing_marks_ >> 2] | 0;
 if (($10 | 0) != 0) {
  __ZdaPv($10 | 0);
 }
 HEAP32[$parsing_marks_ >> 2] = 0;
 $mile_stones_ = $this + 56 | 0;
 $12 = HEAP32[$mile_stones_ >> 2] | 0;
 if (($12 | 0) == 0) {
  HEAP32[$mile_stones_ >> 2] = 0;
  $14 = $this;
  $vtable = HEAP32[$14 >> 2] | 0;
  $vfn = $vtable + 20 | 0;
  $15 = HEAP32[$vfn >> 2] | 0;
  FUNCTION_TABLE_viii[$15 & 15]($this, 0, 1);
  return;
 }
 __ZdaPv($12);
 HEAP32[$mile_stones_ >> 2] = 0;
 $14 = $this;
 $vtable = HEAP32[$14 >> 2] | 0;
 $vfn = $vtable + 20 | 0;
 $15 = HEAP32[$vfn >> 2] | 0;
 FUNCTION_TABLE_viii[$15 & 15]($this, 0, 1);
 return;
}
function __ZN10ime_pinyin8DictTrie10build_dictEPKcS2_($this, $fn_raw, $fn_validhzs) {
 $this = $this | 0;
 $fn_raw = $fn_raw | 0;
 $fn_validhzs = $fn_validhzs | 0;
 var $0 = 0;
 $0 = __Znwj(328) | 0;
 __ZN10ime_pinyin11DictBuilderC2Ev($0);
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 1);
 return __ZN10ime_pinyin11DictBuilder10build_dictEPKcS2_PNS_8DictTrieE($0, $fn_raw, $fn_validhzs, $this) | 0;
}
function __ZN10ime_pinyin8DictTrie9save_dictEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $lma_node_num_le0_ = 0, $lma_node_num_ge1_ = 0, $lma_idx_buf_len_ = 0, $call18 = 0, $call24 = 0, $call30 = 0, $retval_0 = 0;
 if (($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_node_num_le0_ = $this + 24 | 0;
 if ((_fwrite($lma_node_num_le0_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_node_num_ge1_ = $this + 28 | 0;
 if ((_fwrite($lma_node_num_ge1_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_idx_buf_len_ = $this + 36 | 0;
 if ((_fwrite($lma_idx_buf_len_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($this + 44 | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call18 = _fwrite(HEAP32[$this + 12 >> 2] | 0, 16, HEAP32[$lma_node_num_le0_ >> 2] | 0, $fp | 0) | 0;
 if (($call18 | 0) != (HEAP32[$lma_node_num_le0_ >> 2] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call24 = _fwrite(HEAP32[$this + 16 >> 2] | 0, 10, HEAP32[$lma_node_num_ge1_ >> 2] | 0, $fp | 0) | 0;
 if (($call24 | 0) != (HEAP32[$lma_node_num_ge1_ >> 2] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call30 = _fwrite(HEAP32[$this + 32 >> 2] | 0, 1, HEAP32[$lma_idx_buf_len_ >> 2] | 0, $fp | 0) | 0;
 $retval_0 = ($call30 | 0) == (HEAP32[$lma_idx_buf_len_ >> 2] | 0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictTrie9save_dictEPKc($this, $filename) {
 $this = $this | 0;
 $filename = $filename | 0;
 var $dict_list_ = 0, $call = 0, $call6 = 0, $call7 = 0, $retval_0 = 0;
 if (($filename | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 12 >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $dict_list_ = $this + 4 | 0;
 if ((HEAP32[$dict_list_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $call6 = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 $call7 = _fopen($filename | 0, 1648) | 0;
 if (($call7 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 do {
  if (__ZN10ime_pinyin12SpellingTrie13save_spl_trieEP7__sFILE($call, $call7) | 0) {
   if (!(__ZN10ime_pinyin8DictList9save_listEP7__sFILE(HEAP32[$dict_list_ >> 2] | 0, $call7) | 0)) {
    break;
   }
   if (!(__ZN10ime_pinyin8DictTrie9save_dictEP7__sFILE($this, $call7) | 0)) {
    break;
   }
   if (!(__ZN10ime_pinyin5NGram10save_ngramEP7__sFILE($call6, $call7) | 0)) {
    break;
   }
   _fclose($call7 | 0) | 0;
   $retval_0 = 1;
   return $retval_0 | 0;
  }
 } while (0);
 _fclose($call7 | 0) | 0;
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictTrie9load_dictEPKcjj($this, $filename, $start_id, $end_id) {
 $this = $this | 0;
 $filename = $filename | 0;
 $start_id = $start_id | 0;
 $end_id = $end_id | 0;
 var $call = 0, $call6 = 0, $0 = 0, $dict_list_ = 0, $call12 = 0, $call13 = 0, $retval_0 = 0;
 if (!(($filename | 0) != 0 & $end_id >>> 0 > $start_id >>> 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call = _fopen($filename | 0, 1464) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 1);
 $call6 = __Znwj(128) | 0;
 $0 = $call6;
 __ZN10ime_pinyin8DictListC2Ev($0);
 $dict_list_ = $this + 4 | 0;
 HEAP32[$dict_list_ >> 2] = $0;
 if (($call6 | 0) == 0) {
  _fclose($call | 0) | 0;
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call12 = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $call13 = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 do {
  if (__ZN10ime_pinyin12SpellingTrie13load_spl_trieEP7__sFILE($call12, $call) | 0) {
   if (!(__ZN10ime_pinyin8DictList9load_listEP7__sFILE(HEAP32[$dict_list_ >> 2] | 0, $call) | 0)) {
    break;
   }
   if (!(__ZN10ime_pinyin8DictTrie9load_dictEP7__sFILE($this, $call) | 0)) {
    break;
   }
   if (!(__ZN10ime_pinyin5NGram10load_ngramEP7__sFILE($call13, $call) | 0)) {
    break;
   }
   if ((HEAP32[$this + 40 >> 2] | 0) >>> 0 > (1 - $start_id + $end_id | 0) >>> 0) {
    break;
   }
   _fclose($call | 0) | 0;
   $retval_0 = 1;
   return $retval_0 | 0;
  }
 } while (0);
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 1);
 _fclose($call | 0) | 0;
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictTrie12load_dict_fdEilljj($this, $sys_fd, $start_offset, $length, $start_id, $end_id) {
 $this = $this | 0;
 $sys_fd = $sys_fd | 0;
 $start_offset = $start_offset | 0;
 $length = $length | 0;
 $start_id = $start_id | 0;
 $end_id = $end_id | 0;
 var $call = 0, $call13 = 0, $0 = 0, $dict_list_ = 0, $call19 = 0, $call20 = 0, $retval_0 = 0;
 if (!(($length | 0) > 0 & ($start_offset | 0) > -1 & $end_id >>> 0 > $start_id >>> 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call = _fdopen($sys_fd | 0, 1464) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fseek($call | 0, $start_offset | 0, 0) | 0) == -1) {
  _fclose($call | 0) | 0;
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 1);
 $call13 = __Znwj(128) | 0;
 $0 = $call13;
 __ZN10ime_pinyin8DictListC2Ev($0);
 $dict_list_ = $this + 4 | 0;
 HEAP32[$dict_list_ >> 2] = $0;
 if (($call13 | 0) == 0) {
  _fclose($call | 0) | 0;
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call19 = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $call20 = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 do {
  if (__ZN10ime_pinyin12SpellingTrie13load_spl_trieEP7__sFILE($call19, $call) | 0) {
   if (!(__ZN10ime_pinyin8DictList9load_listEP7__sFILE(HEAP32[$dict_list_ >> 2] | 0, $call) | 0)) {
    break;
   }
   if (!(__ZN10ime_pinyin8DictTrie9load_dictEP7__sFILE($this, $call) | 0)) {
    break;
   }
   if (!(__ZN10ime_pinyin5NGram10load_ngramEP7__sFILE($call20, $call) | 0)) {
    break;
   }
   if ((_ftell($call | 0) | 0) < ($length + $start_offset | 0)) {
    break;
   }
   if ((HEAP32[$this + 40 >> 2] | 0) >>> 0 > (1 - $start_id + $end_id | 0) >>> 0) {
    break;
   }
   _fclose($call | 0) | 0;
   $retval_0 = 1;
   return $retval_0 | 0;
  }
 } while (0);
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 1);
 _fclose($call | 0) | 0;
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictTrie15fill_lpi_bufferEPNS_10LmaPsbItemEjPNS_10LmaNodeLE0E($this, $lpi_items, $lpi_max, $node) {
 $this = $this | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $node = $node | 0;
 var $call = 0, $homo_idx_buf_off = 0, $num_of_homo = 0, $lpi_num_0 = 0, $bf_value = 0, $2 = 0, $inc = 0, $lpi_num_1 = 0, label = 0;
 $call = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 $homo_idx_buf_off = $node + 4 | 0;
 $num_of_homo = $node + 12 | 0;
 $lpi_num_0 = 0;
 while (1) {
  if ($lpi_num_0 >>> 0 >= (HEAPU16[$num_of_homo >> 1] | 0) >>> 0) {
   $lpi_num_1 = $lpi_num_0;
   label = 602;
   break;
  }
  $bf_value = (__ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, (HEAP32[$homo_idx_buf_off >> 2] | 0) + $lpi_num_0 | 0) | 0) & 16777215;
  $2 = $lpi_items + ($lpi_num_0 << 3) | 0;
  HEAP32[$2 >> 2] = $bf_value | HEAP32[$2 >> 2] & -268435456 | 16777216;
  HEAP16[$lpi_items + ($lpi_num_0 << 3) + 4 >> 1] = ~~+__ZN10ime_pinyin5NGram11get_uni_psbEj($call, $bf_value);
  $inc = $lpi_num_0 + 1 | 0;
  if ($inc >>> 0 < $lpi_max >>> 0) {
   $lpi_num_0 = $inc;
  } else {
   $lpi_num_1 = $inc;
   label = 601;
   break;
  }
 }
 if ((label | 0) == 602) {
  return $lpi_num_1 | 0;
 } else if ((label | 0) == 601) {
  return $lpi_num_1 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie9load_dictEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $lma_node_num_le0_ = 0, $lma_node_num_ge1_ = 0, $lma_idx_buf_len_ = 0, $top_lmas_num_ = 0, $root_ = 0, $nodes_ge1_ = 0, $lma_idx_buf_ = 0, $call29 = 0, $add = 0, $splid_le0_index_ = 0, $parsing_marks_ = 0, $mile_stones_ = 0, $18 = 0, $call57 = 0, $call64 = 0, $call71 = 0, $i_034 = 0, $last_pos_033_off0 = 0, $last_splid_032 = 0, $36 = 0, $last_pos_0_lcssa = 0, $last_splid_0_lcssa = 0, $conv10624 = 0, $add107 = 0, $conv117 = 0, $splid_030 = 0, $inc = 0, $39 = 0, $_lcssa = 0, $42 = 0, $inc99 = 0, $conv10627 = 0, $splid101_026 = 0, $sub111 = 0, $splid101_0 = 0, $conv106 = 0, $retval_0 = 0, label = 0;
 if (($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_node_num_le0_ = $this + 24 | 0;
 if ((_fread($lma_node_num_le0_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_node_num_ge1_ = $this + 28 | 0;
 if ((_fread($lma_node_num_ge1_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_idx_buf_len_ = $this + 36 | 0;
 if ((_fread($lma_idx_buf_len_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $top_lmas_num_ = $this + 44 | 0;
 if ((_fread($top_lmas_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$top_lmas_num_ >> 2] | 0) >>> 0 >= (HEAP32[$lma_idx_buf_len_ >> 2] | 0) >>> 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 0);
 $root_ = $this + 12 | 0;
 HEAP32[$root_ >> 2] = _malloc(HEAP32[$lma_node_num_le0_ >> 2] << 4) | 0;
 $nodes_ge1_ = $this + 16 | 0;
 HEAP32[$nodes_ge1_ >> 2] = _malloc((HEAP32[$lma_node_num_ge1_ >> 2] | 0) * 10 | 0) | 0;
 $lma_idx_buf_ = $this + 32 | 0;
 HEAP32[$lma_idx_buf_ >> 2] = _malloc(HEAP32[$lma_idx_buf_len_ >> 2] | 0) | 0;
 HEAP32[$this + 40 >> 2] = ((HEAP32[$lma_idx_buf_len_ >> 2] | 0) >>> 0) / 3 | 0;
 $call29 = __ZN10ime_pinyin12SpellingTrie16get_spelling_numEv(__ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0) | 0;
 $add = $call29 + 1 | 0;
 if ((HEAP32[$lma_node_num_le0_ >> 2] | 0) >>> 0 > $add >>> 0) {
  ___assert_func(3680, 196, 4672, 2640);
  return 0;
 }
 $splid_le0_index_ = $this + 20 | 0;
 HEAP32[$splid_le0_index_ >> 2] = _malloc($add << 1) | 0;
 $parsing_marks_ = $this + 48 | 0;
 HEAP32[$parsing_marks_ >> 2] = __Znaj(2400) | 0;
 $mile_stones_ = $this + 56 | 0;
 HEAP32[$mile_stones_ >> 2] = __Znaj(400) | 0;
 FUNCTION_TABLE_viii[HEAP32[(HEAP32[$this >> 2] | 0) + 20 >> 2] & 15]($this, 0, 1);
 $18 = HEAP32[$root_ >> 2] | 0;
 do {
  if (($18 | 0) != 0) {
   if ((HEAP32[$nodes_ge1_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$lma_idx_buf_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$splid_le0_index_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$parsing_marks_ >> 2] | 0) == 0) {
    break;
   }
   if ((HEAP32[$mile_stones_ >> 2] | 0) == 0) {
    break;
   }
   $call57 = _fread($18 | 0, 16, HEAP32[$lma_node_num_le0_ >> 2] | 0, $fp | 0) | 0;
   if (($call57 | 0) != (HEAP32[$lma_node_num_le0_ >> 2] | 0)) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $call64 = _fread(HEAP32[$nodes_ge1_ >> 2] | 0, 10, HEAP32[$lma_node_num_ge1_ >> 2] | 0, $fp | 0) | 0;
   if (($call64 | 0) != (HEAP32[$lma_node_num_ge1_ >> 2] | 0)) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $call71 = _fread(HEAP32[$lma_idx_buf_ >> 2] | 0, 1, HEAP32[$lma_idx_buf_len_ >> 2] | 0, $fp | 0) | 0;
   if (($call71 | 0) != (HEAP32[$lma_idx_buf_len_ >> 2] | 0)) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   if ((HEAP32[$lma_node_num_le0_ >> 2] | 0) >>> 0 > 1) {
    $last_splid_032 = 30;
    $last_pos_033_off0 = 0;
    $i_034 = 1;
    while (1) {
     $36 = HEAP16[(HEAP32[$root_ >> 2] | 0) + ($i_034 << 4) + 8 >> 1] | 0;
     if (($last_splid_032 & 65535) < ($36 & 65535)) {
      $splid_030 = $last_splid_032;
      while (1) {
       HEAP16[(HEAP32[$splid_le0_index_ >> 2] | 0) + (($splid_030 & 65535) - 30 << 1) >> 1] = $last_pos_033_off0;
       $inc = $splid_030 + 1 & 65535;
       $39 = HEAP16[(HEAP32[$root_ >> 2] | 0) + ($i_034 << 4) + 8 >> 1] | 0;
       if (($inc & 65535) < ($39 & 65535)) {
        $splid_030 = $inc;
       } else {
        $_lcssa = $39;
        break;
       }
      }
     } else {
      $_lcssa = $36;
     }
     HEAP16[(HEAP32[$splid_le0_index_ >> 2] | 0) + (($_lcssa & 65535) - 30 << 1) >> 1] = $i_034 & 65535;
     $42 = HEAP16[(HEAP32[$root_ >> 2] | 0) + ($i_034 << 4) + 8 >> 1] | 0;
     $inc99 = $i_034 + 1 | 0;
     if ($inc99 >>> 0 < (HEAP32[$lma_node_num_le0_ >> 2] | 0) >>> 0) {
      $last_splid_032 = $42;
      $last_pos_033_off0 = $i_034 & 65535;
      $i_034 = $inc99;
     } else {
      break;
     }
    }
    $last_splid_0_lcssa = $42 + 1 & 65535;
    $last_pos_0_lcssa = $i_034;
   } else {
    $last_splid_0_lcssa = 31;
    $last_pos_0_lcssa = 0;
   }
   $conv10624 = $last_splid_0_lcssa & 65535;
   $add107 = $call29 + 31 | 0;
   if ($conv10624 >>> 0 >= $add107 >>> 0) {
    $retval_0 = 1;
    return $retval_0 | 0;
   }
   $conv117 = $last_pos_0_lcssa + 1 & 65535;
   $splid101_026 = $last_splid_0_lcssa;
   $conv10627 = $conv10624;
   while (1) {
    $sub111 = $conv10627 - 30 | 0;
    if ($sub111 >>> 0 >= $add >>> 0) {
     label = 629;
     break;
    }
    HEAP16[(HEAP32[$splid_le0_index_ >> 2] | 0) + ($sub111 << 1) >> 1] = $conv117;
    $splid101_0 = $splid101_026 + 1 & 65535;
    $conv106 = $splid101_0 & 65535;
    if ($conv106 >>> 0 < $add107 >>> 0) {
     $splid101_026 = $splid101_0;
     $conv10627 = $conv106;
    } else {
     $retval_0 = 1;
     label = 642;
     break;
    }
   }
   if ((label | 0) == 629) {
    ___assert_func(3680, 238, 4672, 1696);
    return 0;
   } else if ((label | 0) == 642) {
    return $retval_0 | 0;
   }
  }
 } while (0);
 __ZN10ime_pinyin8DictTrie13free_resourceEb($this, 0);
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictTrie16reset_milestonesEtt($this, $from_step, $from_handle) {
 $this = $this | 0;
 $from_step = $from_step | 0;
 $from_handle = $from_handle | 0;
 var $mile_stones_pos_5 = 0;
 if ($from_step << 16 >> 16 == 0) {
  HEAP16[$this + 52 >> 1] = 0;
  HEAP16[$this + 60 >> 1] = 1;
  return;
 }
 if ($from_handle << 16 >> 16 == 0) {
  return;
 }
 $mile_stones_pos_5 = $this + 60 | 0;
 if ((HEAPU16[$mile_stones_pos_5 >> 1] | 0) <= ($from_handle & 65535)) {
  return;
 }
 HEAP16[$mile_stones_pos_5 >> 1] = $from_handle;
 HEAP16[$this + 52 >> 1] = HEAP16[(HEAP32[$this + 56 >> 2] | 0) + (($from_handle & 65535) << 2) >> 1] | 0;
 return;
}
function __ZN10ime_pinyin8DictTrie23get_homo_idx_buf_offsetEPKNS_10LmaNodeGE1E($this, $node) {
 $this = $this | 0;
 $node = $node | 0;
 return (HEAPU8[$node + 9 | 0] | 0) << 16 | (HEAPU16[$node + 2 >> 1] | 0) | 0;
}
function __ZN10ime_pinyin8DictTrie14get_son_offsetEPKNS_10LmaNodeGE1E($this, $node) {
 $this = $this | 0;
 $node = $node | 0;
 return (HEAPU8[$node + 8 | 0] | 0) << 16 | (HEAPU16[$node >> 1] | 0) | 0;
}
function __ZN10ime_pinyin8DictTrie15fill_lpi_bufferEPNS_10LmaPsbItemEjjPNS_10LmaNodeGE1Et($this, $lpi_items, $lpi_max, $homo_buf_off, $node, $lma_len) {
 $this = $this | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $homo_buf_off = $homo_buf_off | 0;
 $node = $node | 0;
 $lma_len = $lma_len | 0;
 var $call = 0, $num_of_homo = 0, $0 = 0, $lpi_num_0 = 0, $bf_value = 0, $2 = 0, $inc = 0, $lpi_num_1 = 0, label = 0;
 $call = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 $num_of_homo = $node + 7 | 0;
 $0 = ($lma_len & 65535) << 24 & 251658240;
 $lpi_num_0 = 0;
 while (1) {
  if ($lpi_num_0 >>> 0 >= (HEAPU8[$num_of_homo] | 0) >>> 0) {
   $lpi_num_1 = $lpi_num_0;
   label = 661;
   break;
  }
  $bf_value = (__ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, $lpi_num_0 + $homo_buf_off | 0) | 0) & 16777215;
  $2 = $lpi_items + ($lpi_num_0 << 3) | 0;
  HEAP32[$2 >> 2] = $bf_value | $0 | HEAP32[$2 >> 2] & -268435456;
  HEAP16[$lpi_items + ($lpi_num_0 << 3) + 4 >> 1] = ~~+__ZN10ime_pinyin5NGram11get_uni_psbEj($call, $bf_value);
  $inc = $lpi_num_0 + 1 | 0;
  if ($inc >>> 0 < $lpi_max >>> 0) {
   $lpi_num_0 = $inc;
  } else {
   $lpi_num_1 = $inc;
   label = 660;
   break;
  }
 }
 if ((label | 0) == 660) {
  return $lpi_num_1 | 0;
 } else if ((label | 0) == 661) {
  return $lpi_num_1 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie11extend_dictEtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) {
 $this = $this | 0;
 $from_handle = $from_handle | 0;
 $dep = $dep | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $lpi_num = $lpi_num | 0;
 var $0 = 0, $retval_0 = 0;
 if (($dep | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $0 = HEAP16[$dep + 80 >> 1] | 0;
 if ($from_handle << 16 >> 16 == 0) {
  if ($0 << 16 >> 16 != 0) {
   ___assert_func(3680, 375, 5296, 1152);
   return 0;
  }
  $retval_0 = __ZN10ime_pinyin8DictTrie12extend_dict0EtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) | 0;
  return $retval_0 | 0;
 }
 if ($0 << 16 >> 16 == 1) {
  $retval_0 = __ZN10ime_pinyin8DictTrie12extend_dict1EtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) | 0;
  return $retval_0 | 0;
 } else {
  $retval_0 = __ZN10ime_pinyin8DictTrie12extend_dict2EtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) | 0;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie12extend_dict0EtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) {
 $this = $this | 0;
 $from_handle = $from_handle | 0;
 $dep = $dep | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $lpi_num = $lpi_num | 0;
 var $1 = 0, $2 = 0, $3 = 0, $call5 = 0, $root_ = 0, $conv6 = 0, $5 = 0, $conv8 = 0, $conv10 = 0, $add = 0, $conv14 = 0, $son_1st_off = 0, $mile_stones_pos_ = 0, $parsing_marks_pos_ = 0, $parsing_marks_ = 0, $8 = 0, $mile_stones_ = 0, $sub87 = 0, $spl_trie_ = 0, $son_pos_0 = 0, $ret_handle_0 = 0, $10 = 0, $add_ptr = 0, $spl_idx = 0, $11 = 0, $14 = 0, $call44 = 0, $18 = 0, $20 = 0, $26 = 0, $35 = 0, $ret_handle_1 = 0, $ret_handle_2 = 0, label = 0;
 if (!(($dep | 0) != 0 & $from_handle << 16 >> 16 == 0)) {
  ___assert_func(3680, 391, 5168, 976);
  return 0;
 }
 HEAP32[$lpi_num >> 2] = 0;
 $1 = HEAP16[$dep + (HEAPU16[$dep + 80 >> 1] << 1) >> 1] | 0;
 $2 = HEAP16[$dep + 88 >> 1] | 0;
 $3 = HEAP16[$dep + 90 >> 1] | 0;
 $call5 = __ZN10ime_pinyin8LpiCache9is_cachedEt(__ZN10ime_pinyin8LpiCache12get_instanceEv() | 0, $1) | 0;
 $root_ = $this + 12 | 0;
 $conv6 = $2 & 65535;
 $5 = HEAP32[$this + 20 >> 2] | 0;
 $conv8 = HEAPU16[$5 + ($conv6 - 30 << 1) >> 1] | 0;
 $conv10 = $3 & 65535;
 $add = $conv10 + $conv6 | 0;
 $conv14 = HEAPU16[$5 + ($add - 30 << 1) >> 1] | 0;
 $son_1st_off = HEAP32[$root_ >> 2] | 0;
 $mile_stones_pos_ = $this + 60 | 0;
 $parsing_marks_pos_ = $this + 52 | 0;
 $parsing_marks_ = $this + 48 | 0;
 $8 = $conv10 << 24;
 $mile_stones_ = $this + 56 | 0;
 $sub87 = $add - 1 | 0;
 $spl_trie_ = $this + 8 | 0;
 $ret_handle_0 = 0;
 $son_pos_0 = $conv8;
 while (1) {
  if ($son_pos_0 >>> 0 >= $conv14 >>> 0) {
   $ret_handle_2 = $ret_handle_0;
   label = 693;
   break;
  }
  if ((HEAP32[$son_1st_off >> 2] | 0) != 1) {
   label = 680;
   break;
  }
  $10 = HEAP32[$root_ >> 2] | 0;
  $add_ptr = $10 + ($son_pos_0 << 4) | 0;
  $spl_idx = $10 + ($son_pos_0 << 4) + 8 | 0;
  $11 = HEAP16[$spl_idx >> 1] | 0;
  if (!(($11 & 65535) >= ($2 & 65535) & ($11 & 65535 | 0) < ($add | 0))) {
   label = 682;
   break;
  }
  do {
   if (!$call5) {
    if ((HEAP32[$lpi_num >> 2] | 0) >>> 0 >= $lpi_max >>> 0) {
     break;
    }
    if (!(($son_pos_0 | 0) == ($conv8 | 0) | (__ZNK10ime_pinyin12SpellingTrie16is_half_id_yunmuEt(HEAP32[$spl_trie_ >> 2] | 0, $1) | 0) ^ 1)) {
     break;
    }
    $14 = HEAP32[$lpi_num >> 2] | 0;
    $call44 = __ZN10ime_pinyin8DictTrie15fill_lpi_bufferEPNS_10LmaPsbItemEjPNS_10LmaNodeLE0E($this, $lpi_items + ($14 << 3) | 0, $lpi_max - $14 | 0, $add_ptr) | 0;
    HEAP32[$lpi_num >> 2] = (HEAP32[$lpi_num >> 2] | 0) + $call44;
   }
  } while (0);
  do {
   if ((HEAP16[$spl_idx >> 1] | 0) == $2 << 16 >> 16) {
    if ((HEAPU16[$mile_stones_pos_ >> 1] | 0) >= 100) {
     $ret_handle_1 = $ret_handle_0;
     break;
    }
    $18 = HEAP16[$parsing_marks_pos_ >> 1] | 0;
    if (($18 & 65535) >= 600) {
     $ret_handle_1 = $ret_handle_0;
     break;
    }
    $20 = (HEAP32[$parsing_marks_ >> 2] | 0) + (($18 & 65535) << 2) | 0;
    HEAP32[$20 >> 2] = HEAP32[$20 >> 2] & -16777216 | $son_pos_0 & 16777215;
    $26 = (HEAP32[$parsing_marks_ >> 2] | 0) + (HEAPU16[$parsing_marks_pos_ >> 1] << 2) | 0;
    HEAP32[$26 >> 2] = HEAP32[$26 >> 2] & 16777215 | $8;
    HEAP16[(HEAP32[$mile_stones_ >> 2] | 0) + (HEAPU16[$mile_stones_pos_ >> 1] << 2) >> 1] = HEAP16[$parsing_marks_pos_ >> 1] | 0;
    HEAP16[(HEAP32[$mile_stones_ >> 2] | 0) + (HEAPU16[$mile_stones_pos_ >> 1] << 2) + 2 >> 1] = 1;
    $35 = HEAP16[$mile_stones_pos_ >> 1] | 0;
    HEAP16[$parsing_marks_pos_ >> 1] = (HEAP16[$parsing_marks_pos_ >> 1] | 0) + 1 & 65535;
    HEAP16[$mile_stones_pos_ >> 1] = (HEAP16[$mile_stones_pos_ >> 1] | 0) + 1 & 65535;
    $ret_handle_1 = $35;
   } else {
    $ret_handle_1 = $ret_handle_0;
   }
  } while (0);
  if ((HEAPU16[$spl_idx >> 1] | 0) < ($sub87 | 0)) {
   $ret_handle_0 = $ret_handle_1;
   $son_pos_0 = $son_pos_0 + 1 | 0;
  } else {
   $ret_handle_2 = $ret_handle_1;
   label = 694;
   break;
  }
 }
 if ((label | 0) == 680) {
  ___assert_func(3680, 408, 5168, 824);
  return 0;
 } else if ((label | 0) == 682) {
  ___assert_func(3680, 410, 5168, 624);
  return 0;
 } else if ((label | 0) == 693) {
  return $ret_handle_2 | 0;
 } else if ((label | 0) == 694) {
  return $ret_handle_2 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie12extend_dict1EtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) {
 $this = $this | 0;
 $from_handle = $from_handle | 0;
 $dep = $dep | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $lpi_num = $lpi_num | 0;
 var $conv = 0, $mile_stones_pos_ = 0, $1 = 0, $2 = 0, $mile_stones_ = 0, $3 = 0, $mark_num = 0, $mark_start = 0, $parsing_marks_ = 0, $root_ = 0, $lma_node_num_ge1_ = 0, $nodes_ge1_ = 0, $conv37 = 0, $sub60 = 0, $add44 = 0, $parsing_marks_pos_ = 0, $ret_val_045 = 0, $h_pos_044 = 0, $p_mark_sroa_0_0_copyload = 0, $8 = 0, $bf_clear21 = 0, $conv1741 = 0, $ret_val_140 = 0, $ext_pos_039 = 0, $9 = 0, $add_ptr22_sum = 0, $num_of_son = 0, $son_1st_off = 0, $found_start_0 = 0, $found_num_0 = 0, $son_pos_0 = 0, $11 = 0, $13 = 0, $add_ptr34_sum = 0, $add_ptr35 = 0, $spl_idx = 0, $14 = 0, $15 = 0, $call49 = 0, $found_start_2 = 0, $found_num_1 = 0, $20 = 0, $23 = 0, $29 = 0, $ret_val_2 = 0, $inc103 = 0, $conv17 = 0, $ret_val_1_lcssa = 0, $inc106 = 0, $41 = 0, $ret_handle_0 = 0, label = 0;
 if (($dep | 0) == 0) {
  ___assert_func(3680, 450, 5040, 464);
  return 0;
 }
 $conv = $from_handle & 65535;
 if ($from_handle << 16 >> 16 == 0) {
  ___assert_func(3680, 450, 5040, 464);
  return 0;
 }
 $mile_stones_pos_ = $this + 60 | 0;
 if ((HEAPU16[$mile_stones_pos_ >> 1] | 0) <= ($from_handle & 65535)) {
  ___assert_func(3680, 450, 5040, 464);
  return 0;
 }
 $1 = HEAP16[$dep + 88 >> 1] | 0;
 $2 = HEAP16[$dep + 90 >> 1] | 0;
 $mile_stones_ = $this + 56 | 0;
 $3 = HEAP32[$mile_stones_ >> 2] | 0;
 $mark_num = $3 + ($conv << 2) + 2 | 0;
 if ((HEAP16[$mark_num >> 1] | 0) == 0) {
  $ret_handle_0 = 0;
  return $ret_handle_0 | 0;
 }
 $mark_start = $3 + ($conv << 2) | 0;
 $parsing_marks_ = $this + 48 | 0;
 $root_ = $this + 12 | 0;
 $lma_node_num_ge1_ = $this + 28 | 0;
 $nodes_ge1_ = $this + 16 | 0;
 $conv37 = $1 & 65535;
 $sub60 = $conv37 - 1 + ($2 & 65535) | 0;
 $add44 = ($2 & 65535) + $conv37 | 0;
 $parsing_marks_pos_ = $this + 52 | 0;
 $h_pos_044 = 0;
 $ret_val_045 = 0;
 L852 : while (1) {
  $p_mark_sroa_0_0_copyload = HEAP32[(HEAP32[$parsing_marks_ >> 2] | 0) + ((HEAPU16[$mark_start >> 1] | 0) + ($h_pos_044 & 65535) << 2) >> 2] | 0;
  $8 = $p_mark_sroa_0_0_copyload >>> 24;
  if (($8 | 0) == 0) {
   $ret_val_1_lcssa = $ret_val_045;
  } else {
   $bf_clear21 = $p_mark_sroa_0_0_copyload & 16777215;
   $ext_pos_039 = 0;
   $ret_val_140 = $ret_val_045;
   $conv1741 = 0;
   while (1) {
    $9 = HEAP32[$root_ >> 2] | 0;
    $add_ptr22_sum = $conv1741 + $bf_clear21 | 0;
    $num_of_son = $9 + ($add_ptr22_sum << 4) + 10 | 0;
    $son_1st_off = $9 + ($add_ptr22_sum << 4) | 0;
    $son_pos_0 = 0;
    $found_num_0 = 0;
    $found_start_0 = 0;
    while (1) {
     if ($son_pos_0 >>> 0 >= (HEAPU16[$num_of_son >> 1] | 0) >>> 0) {
      $ret_val_2 = $ret_val_140;
      break;
     }
     $11 = HEAP32[$son_1st_off >> 2] | 0;
     if ($11 >>> 0 > (HEAP32[$lma_node_num_ge1_ >> 2] | 0) >>> 0) {
      label = 706;
      break L852;
     }
     $13 = HEAP32[$nodes_ge1_ >> 2] | 0;
     $add_ptr34_sum = $11 + $son_pos_0 | 0;
     $add_ptr35 = $13 + ($add_ptr34_sum * 10 | 0) | 0;
     $spl_idx = $13 + ($add_ptr34_sum * 10 | 0) + 4 | 0;
     $14 = HEAP16[$spl_idx >> 1] | 0;
     if (($14 & 65535) >= ($1 & 65535) & ($14 & 65535 | 0) < ($add44 | 0)) {
      $15 = HEAP32[$lpi_num >> 2] | 0;
      if ($15 >>> 0 < $lpi_max >>> 0) {
       $call49 = __ZN10ime_pinyin8DictTrie15fill_lpi_bufferEPNS_10LmaPsbItemEjjPNS_10LmaNodeGE1Et($this, $lpi_items + ($15 << 3) | 0, $lpi_max - $15 | 0, __ZN10ime_pinyin8DictTrie23get_homo_idx_buf_offsetEPKNS_10LmaNodeGE1E(0, $add_ptr35) | 0, $add_ptr35, 2) | 0;
       HEAP32[$lpi_num >> 2] = (HEAP32[$lpi_num >> 2] | 0) + $call49;
      }
      $found_num_1 = $found_num_0 + 1 | 0;
      $found_start_2 = ($found_num_0 | 0) == 0 ? $son_pos_0 : $found_start_0;
     } else {
      $found_num_1 = $found_num_0;
      $found_start_2 = $found_start_0;
     }
     if ((HEAPU16[$spl_idx >> 1] | 0) >= ($sub60 | 0)) {
      label = 713;
      break;
     }
     if (($son_pos_0 | 0) == ((HEAPU16[$num_of_son >> 1] | 0) - 1 | 0)) {
      label = 713;
      break;
     } else {
      $son_pos_0 = $son_pos_0 + 1 | 0;
      $found_num_0 = $found_num_1;
      $found_start_0 = $found_start_2;
     }
    }
    do {
     if ((label | 0) == 713) {
      label = 0;
      if (($found_num_1 | 0) == 0) {
       $ret_val_2 = $ret_val_140;
       break;
      }
      do {
       if ((HEAPU16[$mile_stones_pos_ >> 1] | 0) < 100) {
        $20 = HEAP16[$parsing_marks_pos_ >> 1] | 0;
        if (($20 & 65535) >= 600) {
         break;
        }
        $23 = (HEAP32[$parsing_marks_ >> 2] | 0) + (($20 & 65535) << 2) | 0;
        HEAP32[$23 >> 2] = HEAP32[$23 >> 2] & -16777216 | (HEAP32[$son_1st_off >> 2] | 0) + $found_start_2 & 16777215;
        $29 = (HEAP32[$parsing_marks_ >> 2] | 0) + (HEAPU16[$parsing_marks_pos_ >> 1] << 2) | 0;
        HEAP32[$29 >> 2] = HEAP32[$29 >> 2] & 16777215 | $found_num_1 << 24;
        if (($ret_val_140 | 0) == 0) {
         HEAP16[(HEAP32[$mile_stones_ >> 2] | 0) + (HEAPU16[$mile_stones_pos_ >> 1] << 2) >> 1] = HEAP16[$parsing_marks_pos_ >> 1] | 0;
        }
        HEAP16[$parsing_marks_pos_ >> 1] = (HEAP16[$parsing_marks_pos_ >> 1] | 0) + 1 & 65535;
       }
      } while (0);
      $ret_val_2 = $ret_val_140 + 1 | 0;
     }
    } while (0);
    $inc103 = $ext_pos_039 + 1 & 65535;
    $conv17 = $inc103 & 65535;
    if ($conv17 >>> 0 < $8 >>> 0) {
     $ext_pos_039 = $inc103;
     $ret_val_140 = $ret_val_2;
     $conv1741 = $conv17;
    } else {
     $ret_val_1_lcssa = $ret_val_2;
     break;
    }
   }
  }
  $inc106 = $h_pos_044 + 1 & 65535;
  if (($inc106 & 65535) < (HEAPU16[$mark_num >> 1] | 0)) {
   $h_pos_044 = $inc106;
   $ret_val_045 = $ret_val_1_lcssa;
  } else {
   break;
  }
 }
 if ((label | 0) == 706) {
  ___assert_func(3680, 472, 5040, 4312);
  return 0;
 }
 if (($ret_val_1_lcssa | 0) == 0) {
  $ret_handle_0 = 0;
  return $ret_handle_0 | 0;
 }
 HEAP16[(HEAP32[$mile_stones_ >> 2] | 0) + (HEAPU16[$mile_stones_pos_ >> 1] << 2) + 2 >> 1] = $ret_val_1_lcssa & 65535;
 $41 = HEAP16[$mile_stones_pos_ >> 1] | 0;
 HEAP16[$mile_stones_pos_ >> 1] = $41 + 1 & 65535;
 $ret_handle_0 = $41;
 return $ret_handle_0 | 0;
}
function __ZN10ime_pinyin8DictTrie12extend_dict2EtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) {
 $this = $this | 0;
 $from_handle = $from_handle | 0;
 $dep = $dep | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $lpi_num = $lpi_num | 0;
 var $conv = 0, $mile_stones_pos_ = 0, $1 = 0, $2 = 0, $mile_stones_ = 0, $3 = 0, $mark_num = 0, $mark_start = 0, $parsing_marks_ = 0, $nodes_ge1_ = 0, $conv40 = 0, $sub67 = 0, $add47 = 0, $splids_extended = 0, $parsing_marks_pos_ = 0, $ret_val_046 = 0, $h_pos_045 = 0, $p_mark_sroa_0_0_copyload = 0, $8 = 0, $bf_clear21 = 0, $conv1742 = 0, $ret_val_141 = 0, $ext_pos_040 = 0, $9 = 0, $add_ptr22_sum = 0, $add_ptr24 = 0, $num_of_son = 0, $son_1st_off_l = 0, $son_1st_off_h = 0, $found_start_0 = 0, $found_num_0 = 0, $son_pos_0 = 0, $13 = 0, $add_ptr37_sum = 0, $add_ptr38 = 0, $spl_idx = 0, $14 = 0, $15 = 0, $call51 = 0, $call56 = 0, $found_start_2 = 0, $found_num_1 = 0, $21 = 0, $add85 = 0, $23 = 0, $29 = 0, $ret_val_2 = 0, $inc111 = 0, $conv17 = 0, $ret_val_1_lcssa = 0, $inc114 = 0, $41 = 0, $ret_handle_0 = 0, label = 0;
 if (($dep | 0) == 0) {
  ___assert_func(3680, 528, 4912, 464);
  return 0;
 }
 $conv = $from_handle & 65535;
 if ($from_handle << 16 >> 16 == 0) {
  ___assert_func(3680, 528, 4912, 464);
  return 0;
 }
 $mile_stones_pos_ = $this + 60 | 0;
 if ((HEAPU16[$mile_stones_pos_ >> 1] | 0) <= ($from_handle & 65535)) {
  ___assert_func(3680, 528, 4912, 464);
  return 0;
 }
 $1 = HEAP16[$dep + 88 >> 1] | 0;
 $2 = HEAP16[$dep + 90 >> 1] | 0;
 $mile_stones_ = $this + 56 | 0;
 $3 = HEAP32[$mile_stones_ >> 2] | 0;
 $mark_num = $3 + ($conv << 2) + 2 | 0;
 if ((HEAP16[$mark_num >> 1] | 0) == 0) {
  $ret_handle_0 = 0;
  return $ret_handle_0 | 0;
 }
 $mark_start = $3 + ($conv << 2) | 0;
 $parsing_marks_ = $this + 48 | 0;
 $nodes_ge1_ = $this + 16 | 0;
 $conv40 = $1 & 65535;
 $sub67 = $conv40 - 1 + ($2 & 65535) | 0;
 $add47 = ($2 & 65535) + $conv40 | 0;
 $splids_extended = $dep + 80 | 0;
 $parsing_marks_pos_ = $this + 52 | 0;
 $h_pos_045 = 0;
 $ret_val_046 = 0;
 L901 : while (1) {
  $p_mark_sroa_0_0_copyload = HEAP32[(HEAP32[$parsing_marks_ >> 2] | 0) + ((HEAPU16[$mark_start >> 1] | 0) + ($h_pos_045 & 65535) << 2) >> 2] | 0;
  $8 = $p_mark_sroa_0_0_copyload >>> 24;
  if (($8 | 0) == 0) {
   $ret_val_1_lcssa = $ret_val_046;
  } else {
   $bf_clear21 = $p_mark_sroa_0_0_copyload & 16777215;
   $ext_pos_040 = 0;
   $ret_val_141 = $ret_val_046;
   $conv1742 = 0;
   while (1) {
    $9 = HEAP32[$nodes_ge1_ >> 2] | 0;
    $add_ptr22_sum = $conv1742 + $bf_clear21 | 0;
    $add_ptr24 = $9 + ($add_ptr22_sum * 10 | 0) | 0;
    $num_of_son = $9 + ($add_ptr22_sum * 10 | 0) + 6 | 0;
    $son_1st_off_l = $add_ptr24 | 0;
    $son_1st_off_h = $9 + ($add_ptr22_sum * 10 | 0) + 8 | 0;
    $son_pos_0 = 0;
    $found_num_0 = 0;
    $found_start_0 = 0;
    while (1) {
     if ($son_pos_0 >>> 0 >= (HEAPU8[$num_of_son] | 0) >>> 0) {
      $ret_val_2 = $ret_val_141;
      break;
     }
     if ((HEAP16[$son_1st_off_l >> 1] | 0) == 0) {
      if ((HEAP8[$son_1st_off_h] | 0) == 0) {
       label = 743;
       break L901;
      }
     }
     $13 = HEAP32[$nodes_ge1_ >> 2] | 0;
     $add_ptr37_sum = (__ZN10ime_pinyin8DictTrie14get_son_offsetEPKNS_10LmaNodeGE1E(0, $add_ptr24) | 0) + $son_pos_0 | 0;
     $add_ptr38 = $13 + ($add_ptr37_sum * 10 | 0) | 0;
     $spl_idx = $13 + ($add_ptr37_sum * 10 | 0) + 4 | 0;
     $14 = HEAP16[$spl_idx >> 1] | 0;
     if (($14 & 65535) >= ($1 & 65535) & ($14 & 65535 | 0) < ($add47 | 0)) {
      $15 = HEAP32[$lpi_num >> 2] | 0;
      if ($15 >>> 0 < $lpi_max >>> 0) {
       $call51 = __ZN10ime_pinyin8DictTrie23get_homo_idx_buf_offsetEPKNS_10LmaNodeGE1E(0, $add_ptr38) | 0;
       $call56 = __ZN10ime_pinyin8DictTrie15fill_lpi_bufferEPNS_10LmaPsbItemEjjPNS_10LmaNodeGE1Et($this, $lpi_items + ($15 << 3) | 0, $lpi_max - $15 | 0, $call51, $add_ptr38, (HEAP16[$splids_extended >> 1] | 0) + 1 & 65535) | 0;
       HEAP32[$lpi_num >> 2] = (HEAP32[$lpi_num >> 2] | 0) + $call56;
      }
      $found_num_1 = $found_num_0 + 1 | 0;
      $found_start_2 = ($found_num_0 | 0) == 0 ? $son_pos_0 : $found_start_0;
     } else {
      $found_num_1 = $found_num_0;
      $found_start_2 = $found_start_0;
     }
     if ((HEAPU16[$spl_idx >> 1] | 0) >= ($sub67 | 0)) {
      label = 750;
      break;
     }
     if (($son_pos_0 | 0) == ((HEAPU8[$num_of_son] | 0) - 1 | 0)) {
      label = 750;
      break;
     } else {
      $son_pos_0 = $son_pos_0 + 1 | 0;
      $found_num_0 = $found_num_1;
      $found_start_0 = $found_start_2;
     }
    }
    do {
     if ((label | 0) == 750) {
      label = 0;
      if (($found_num_1 | 0) == 0) {
       $ret_val_2 = $ret_val_141;
       break;
      }
      do {
       if ((HEAPU16[$mile_stones_pos_ >> 1] | 0) < 100) {
        $21 = HEAP16[$parsing_marks_pos_ >> 1] | 0;
        if (($21 & 65535) >= 600) {
         break;
        }
        $add85 = (__ZN10ime_pinyin8DictTrie14get_son_offsetEPKNS_10LmaNodeGE1E(0, $add_ptr24) | 0) + $found_start_2 | 0;
        $23 = (HEAP32[$parsing_marks_ >> 2] | 0) + (($21 & 65535) << 2) | 0;
        HEAP32[$23 >> 2] = HEAP32[$23 >> 2] & -16777216 | $add85 & 16777215;
        $29 = (HEAP32[$parsing_marks_ >> 2] | 0) + (HEAPU16[$parsing_marks_pos_ >> 1] << 2) | 0;
        HEAP32[$29 >> 2] = HEAP32[$29 >> 2] & 16777215 | $found_num_1 << 24;
        if (($ret_val_141 | 0) == 0) {
         HEAP16[(HEAP32[$mile_stones_ >> 2] | 0) + (HEAPU16[$mile_stones_pos_ >> 1] << 2) >> 1] = HEAP16[$parsing_marks_pos_ >> 1] | 0;
        }
        HEAP16[$parsing_marks_pos_ >> 1] = (HEAP16[$parsing_marks_pos_ >> 1] | 0) + 1 & 65535;
       }
      } while (0);
      $ret_val_2 = $ret_val_141 + 1 | 0;
     }
    } while (0);
    $inc111 = $ext_pos_040 + 1 & 65535;
    $conv17 = $inc111 & 65535;
    if ($conv17 >>> 0 < $8 >>> 0) {
     $ext_pos_040 = $inc111;
     $ret_val_141 = $ret_val_2;
     $conv1742 = $conv17;
    } else {
     $ret_val_1_lcssa = $ret_val_2;
     break;
    }
   }
  }
  $inc114 = $h_pos_045 + 1 & 65535;
  if (($inc114 & 65535) < (HEAPU16[$mark_num >> 1] | 0)) {
   $h_pos_045 = $inc114;
   $ret_val_046 = $ret_val_1_lcssa;
  } else {
   break;
  }
 }
 if ((label | 0) == 743) {
  ___assert_func(3680, 551, 4912, 4112);
  return 0;
 }
 if (($ret_val_1_lcssa | 0) == 0) {
  $ret_handle_0 = 0;
  return $ret_handle_0 | 0;
 }
 HEAP16[(HEAP32[$mile_stones_ >> 2] | 0) + (HEAPU16[$mile_stones_pos_ >> 1] << 2) + 2 >> 1] = $ret_val_1_lcssa & 65535;
 $41 = HEAP16[$mile_stones_pos_ >> 1] | 0;
 HEAP16[$mile_stones_pos_ >> 1] = $41 + 1 & 65535;
 $ret_handle_0 = $41;
 return $ret_handle_0 | 0;
}
function __ZN10ime_pinyin8DictTrie10try_extendEPKttj($this, $splids, $splid_num, $id_lemma) {
 $this = $this | 0;
 $splids = $splids | 0;
 $splid_num = $splid_num | 0;
 $id_lemma = $id_lemma | 0;
 var $str = 0, $4 = 0, $nodes_ge1_52 = 0, $lma_node_num_ge1_ = 0, $nodes_ge1_ = 0, $conv650 = 0, $node_049 = 0, $pos_048 = 0, $node_son_047 = 0, $node_son35_046 = 0, $5 = 0, $6 = 0, $son_1st_off = 0, $arrayidx23 = 0, $son_pos_0 = 0, $node_son_1 = 0, $7 = 0, $9 = 0, $add_ptr19_sum = 0, $add_ptr21 = 0, $node_son_2 = 0, $13 = 0, $14 = 0, $conv41 = 0, $son_1st_off_l = 0, $16 = 0, $arrayidx59 = 0, $son_pos36_0 = 0, $node_son35_1 = 0, $conv38 = 0, $19 = 0, $add_ptr53_sum = 0, $add_ptr55 = 0, $node_son35_2 = 0, $node_son35_3 = 0, $node_son_3 = 0, $node_1_in = 0, $node_1 = 0, $inc76 = 0, $node_0_lcssa = 0, $conv83 = 0, $25 = 0, $26 = 0, $arraydecay = 0, $homo_pos_0 = 0, $call87 = 0, $29 = 0, $conv99 = 0, $homo_pos100_0 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $str = sp | 0;
 if ($splid_num << 16 >> 16 == 0 | ($splids | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $4 = (HEAP32[$this + 12 >> 2] | 0) + (HEAPU16[(HEAP32[$this + 20 >> 2] | 0) + ((HEAPU16[$splids >> 1] | 0) - 30 << 1) >> 1] << 4) | 0;
 L943 : do {
  if (($splid_num & 65535) > 1) {
   $nodes_ge1_52 = $this + 16 | 0;
   $lma_node_num_ge1_ = $this + 28 | 0;
   $nodes_ge1_ = $this + 16 | 0;
   $node_son35_046 = 0;
   $node_son_047 = 0;
   $pos_048 = 1;
   $node_049 = $4;
   $conv650 = 1;
   L945 : while (1) {
    if ($pos_048 << 16 >> 16 == 1) {
     $5 = $node_049 + 10 | 0;
     $6 = HEAP16[$5 >> 1] | 0;
     $son_1st_off = $node_049;
     $arrayidx23 = $splids + ($conv650 << 1) | 0;
     $node_son_1 = $node_son_047;
     $son_pos_0 = 0;
     while (1) {
      if (($son_pos_0 & 65535) >= ($6 & 65535)) {
       $node_son_2 = $node_son_1;
       break;
      }
      $7 = HEAP32[$son_1st_off >> 2] | 0;
      if ($7 >>> 0 > (HEAP32[$lma_node_num_ge1_ >> 2] | 0) >>> 0) {
       label = 775;
       break L945;
      }
      $9 = HEAP32[$nodes_ge1_ >> 2] | 0;
      $add_ptr19_sum = $7 + ($son_pos_0 & 65535) | 0;
      $add_ptr21 = $9 + ($add_ptr19_sum * 10 | 0) | 0;
      if ((HEAP16[$9 + ($add_ptr19_sum * 10 | 0) + 4 >> 1] | 0) == (HEAP16[$arrayidx23 >> 1] | 0)) {
       $node_son_2 = $add_ptr21;
       break;
      } else {
       $node_son_1 = $add_ptr21;
       $son_pos_0 = $son_pos_0 + 1 & 65535;
      }
     }
     if (($son_pos_0 & 65535) < (HEAPU16[$5 >> 1] | 0)) {
      $node_1_in = $node_son_2;
      $node_son_3 = $node_son_2;
      $node_son35_3 = $node_son35_046;
     } else {
      $retval_0 = 0;
      label = 794;
      break;
     }
    } else {
     $13 = $node_049;
     $14 = $node_049 + 6 | 0;
     $conv41 = HEAPU8[$14] | 0;
     $son_1st_off_l = $node_049;
     $16 = $node_049 + 8 | 0;
     $arrayidx59 = $splids + ($conv650 << 1) | 0;
     $node_son35_1 = $node_son35_046;
     $son_pos36_0 = 0;
     while (1) {
      $conv38 = $son_pos36_0 & 65535;
      if ($conv38 >>> 0 >= $conv41 >>> 0) {
       $node_son35_2 = $node_son35_1;
       break;
      }
      if ((HEAP16[$son_1st_off_l >> 1] | 0) == 0) {
       if ((HEAP8[$16] | 0) == 0) {
        label = 782;
        break L945;
       }
      }
      $19 = HEAP32[$nodes_ge1_52 >> 2] | 0;
      $add_ptr53_sum = (__ZN10ime_pinyin8DictTrie14get_son_offsetEPKNS_10LmaNodeGE1E(0, $13) | 0) + $conv38 | 0;
      $add_ptr55 = $19 + ($add_ptr53_sum * 10 | 0) | 0;
      if ((HEAP16[$19 + ($add_ptr53_sum * 10 | 0) + 4 >> 1] | 0) == (HEAP16[$arrayidx59 >> 1] | 0)) {
       $node_son35_2 = $add_ptr55;
       break;
      } else {
       $node_son35_1 = $add_ptr55;
       $son_pos36_0 = $son_pos36_0 + 1 & 65535;
      }
     }
     if ($conv38 >>> 0 < (HEAPU8[$14] | 0) >>> 0) {
      $node_1_in = $node_son35_2;
      $node_son_3 = $node_son_047;
      $node_son35_3 = $node_son35_2;
     } else {
      $retval_0 = 0;
      label = 796;
      break;
     }
    }
    $node_1 = $node_1_in;
    $inc76 = $pos_048 + 1 & 65535;
    if (($inc76 & 65535) < ($splid_num & 65535)) {
     $node_son35_046 = $node_son35_3;
     $node_son_047 = $node_son_3;
     $pos_048 = $inc76;
     $node_049 = $node_1;
     $conv650 = $inc76 & 65535;
    } else {
     $node_0_lcssa = $node_1;
     break L943;
    }
   }
   if ((label | 0) == 796) {
    STACKTOP = sp;
    return $retval_0 | 0;
   } else if ((label | 0) == 794) {
    STACKTOP = sp;
    return $retval_0 | 0;
   } else if ((label | 0) == 775) {
    ___assert_func(3680, 616, 5424, 3944);
    return 0;
   } else if ((label | 0) == 782) {
    ___assert_func(3680, 632, 5424, 3704);
    return 0;
   }
  } else {
   $node_0_lcssa = $4;
  }
 } while (0);
 if ($splid_num << 16 >> 16 == 1) {
  $conv83 = HEAPU16[$node_0_lcssa + 12 >> 1] | 0;
  $25 = $node_0_lcssa + 4 | 0;
  $26 = $this;
  $arraydecay = $str | 0;
  $homo_pos_0 = 0;
  while (1) {
   if ($homo_pos_0 >>> 0 >= $conv83 >>> 0) {
    $retval_0 = 0;
    label = 797;
    break;
   }
   $call87 = __ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, (HEAP32[$25 >> 2] | 0) + $homo_pos_0 | 0) | 0;
   FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$26 >> 2] | 0) + 32 >> 2] & 31]($this, $call87, $arraydecay, 2) | 0;
   if (($call87 | 0) == ($id_lemma | 0)) {
    $retval_0 = 1;
    label = 798;
    break;
   } else {
    $homo_pos_0 = $homo_pos_0 + 1 | 0;
   }
  }
  if ((label | 0) == 797) {
   STACKTOP = sp;
   return $retval_0 | 0;
  } else if ((label | 0) == 798) {
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 } else {
  $29 = $node_0_lcssa;
  $conv99 = HEAPU8[$node_0_lcssa + 7 | 0] | 0;
  $homo_pos100_0 = 0;
  while (1) {
   if ($homo_pos100_0 >>> 0 >= $conv99 >>> 0) {
    $retval_0 = 0;
    label = 799;
    break;
   }
   if ((__ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, (__ZN10ime_pinyin8DictTrie23get_homo_idx_buf_offsetEPKNS_10LmaNodeGE1E(0, $29) | 0) + $homo_pos100_0 | 0) | 0) == ($id_lemma | 0)) {
    $retval_0 = 1;
    label = 800;
    break;
   } else {
    $homo_pos100_0 = $homo_pos100_0 + 1 | 0;
   }
  }
  if ((label | 0) == 799) {
   STACKTOP = sp;
   return $retval_0 | 0;
  } else if ((label | 0) == 800) {
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie10close_dictEv($this) {
 $this = $this | 0;
 return 1;
}
function __ZN10ime_pinyin8DictTrie16number_of_lemmasEv($this) {
 $this = $this | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie9put_lemmaEPtS1_tt($this, $lemma_str, $splids, $lemma_len, $count) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 $count = $count | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie12update_lemmaEjsb($this, $lemma_id, $delta_count, $selected) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 $delta_count = $delta_count | 0;
 $selected = $selected | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie12get_lemma_idEPtS1_t($this, $lemma_str, $splids, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie15get_lemma_scoreEj($this, $lemma_id) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie15get_lemma_scoreEPtS1_t($this, $lemma_str, $splids, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie12remove_lemmaEj($this, $lemma_id) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie21get_total_lemma_countEv($this) {
 $this = $this | 0;
 return 0;
}
function __ZN10ime_pinyin8DictTrie11flush_cacheEv($this) {
 $this = $this | 0;
 return;
}
function __ZN10ime_pinyin12AtomDictBaseD1Ev($this) {
 $this = $this | 0;
 return;
}
function __ZN10ime_pinyin12MatrixSearch22reset_pointers_to_nullEv($this) {
 $this = $this | 0;
 HEAP32[$this + 12 >> 2] = 0;
 HEAP32[$this + 16 >> 2] = 0;
 HEAP32[$this + 20 >> 2] = 0;
 HEAP32[$this + 76 >> 2] = 0;
 HEAP32[$this + 80 >> 2] = 0;
 HEAP32[$this + 88 >> 2] = 0;
 HEAP32[$this + 96 >> 2] = 0;
 HEAP32[$this + 100 >> 2] = 0;
 HEAP32[$this + 104 >> 2] = 0;
 return;
}
function __ZN10ime_pinyin8DictTrie13get_lemma_strEjPtt($this, $id_lemma, $str_buf, $str_max) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $str_buf = $str_buf | 0;
 $str_max = $str_max | 0;
 return __ZN10ime_pinyin8DictList13get_lemma_strEjPtt(HEAP32[$this + 4 >> 2] | 0, $id_lemma, $str_buf, $str_max) | 0;
}
function __ZN10ime_pinyin8DictTrie31set_total_lemma_count_of_othersEj($this, $count) {
 $this = $this | 0;
 $count = $count | 0;
 __ZN10ime_pinyin5NGram23set_total_freq_none_sysEj(__ZN10ime_pinyin5NGram12get_instanceEv() | 0, $count);
 return;
}
function __ZN10ime_pinyin8DictTrie17convert_to_hanzisEPtt($this, $str, $str_len) {
 $this = $this | 0;
 $str = $str | 0;
 $str_len = $str_len | 0;
 __ZN10ime_pinyin8DictList17convert_to_hanzisEPtt(HEAP32[$this + 4 >> 2] | 0, $str, $str_len);
 return;
}
function __ZN10ime_pinyin8DictTrie19convert_to_scis_idsEPtt($this, $str, $str_len) {
 $this = $this | 0;
 $str = $str | 0;
 $str_len = $str_len | 0;
 __ZN10ime_pinyin8DictList19convert_to_scis_idsEPtt(HEAP32[$this + 4 >> 2] | 0, $str, $str_len);
 return;
}
function __ZN10ime_pinyin8DictTrie12get_lemma_idEPKtt($this, $lemma_str, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $lemma_len = $lemma_len | 0;
 var $retval_0 = 0;
 if (($lemma_str | 0) == 0 | ($lemma_len & 65535) > 8) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin8DictList12get_lemma_idEPKtt(HEAP32[$this + 4 >> 2] | 0, $lemma_str, $lemma_len) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictTrie16predict_top_lmasEjPNS_12NPredictItemEjj($this, $his_len, $npre_items, $npre_max, $b4_used) {
 $this = $this | 0;
 $his_len = $his_len | 0;
 $npre_items = $npre_items | 0;
 $npre_max = $npre_max | 0;
 $b4_used = $b4_used | 0;
 var $call = 0, $top_lmas_num_ = 0, $sub = 0, $dict_list_ = 0, $conv10 = 0, $arraydecay20 = 0, $_in = 0, $item_num_0_ph18 = 0, $top_lmas_pos_0_ph17 = 0, $2 = 0, $top_lmas_pos_0 = 0, $call4 = 0, $inc = 0, $item_num_0_ph14 = 0, label = 0;
 $call = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 $top_lmas_num_ = $this + 44 | 0;
 $sub = (((HEAP32[$this + 36 >> 2] | 0) >>> 0) / 3 | 0) - (HEAP32[$top_lmas_num_ >> 2] | 0) | 0;
 $dict_list_ = $this + 4 | 0;
 if (($npre_max | 0) == 0) {
  $item_num_0_ph14 = 0;
  return $item_num_0_ph14 | 0;
 }
 $conv10 = $his_len & 65535;
 $top_lmas_pos_0_ph17 = 0;
 $item_num_0_ph18 = 0;
 $_in = $npre_items;
 $arraydecay20 = $npre_items + 4 | 0;
 L1009 : while (1) {
  $2 = $_in;
  $top_lmas_pos_0 = $top_lmas_pos_0_ph17;
  do {
   if ($top_lmas_pos_0 >>> 0 >= (HEAP32[$top_lmas_num_ >> 2] | 0) >>> 0) {
    $item_num_0_ph14 = $item_num_0_ph18;
    label = 829;
    break L1009;
   }
   _memset($2 | 0, 0, 20);
   $call4 = __ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, $sub + $top_lmas_pos_0 | 0) | 0;
   $top_lmas_pos_0 = $top_lmas_pos_0 + 1 | 0;
  } while ((__ZN10ime_pinyin8DictList13get_lemma_strEjPtt(HEAP32[$dict_list_ >> 2] | 0, $call4, $arraydecay20, 7) | 0) << 16 >> 16 == 0);
  HEAPF32[$_in >> 2] = +__ZN10ime_pinyin5NGram11get_uni_psbEj($call, $call4);
  HEAP16[$npre_items + ($item_num_0_ph18 * 20 | 0) + 18 >> 1] = $conv10;
  $inc = $item_num_0_ph18 + 1 | 0;
  if ($inc >>> 0 < $npre_max >>> 0) {
   $top_lmas_pos_0_ph17 = $top_lmas_pos_0;
   $item_num_0_ph18 = $inc;
   $_in = $npre_items + ($inc * 20 | 0) | 0;
   $arraydecay20 = $npre_items + ($inc * 20 | 0) + 4 | 0;
  } else {
   $item_num_0_ph14 = $inc;
   label = 831;
   break;
  }
 }
 if ((label | 0) == 829) {
  return $item_num_0_ph14 | 0;
 } else if ((label | 0) == 831) {
  return $item_num_0_ph14 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie7predictEPKttPNS_12NPredictItemEjj($this, $last_hzs, $hzs_len, $npre_items, $npre_max, $b4_used) {
 $this = $this | 0;
 $last_hzs = $last_hzs | 0;
 $hzs_len = $hzs_len | 0;
 $npre_items = $npre_items | 0;
 $npre_max = $npre_max | 0;
 $b4_used = $b4_used | 0;
 return __ZN10ime_pinyin8DictList7predictEPKttPNS_12NPredictItemEjj(HEAP32[$this + 4 >> 2] | 0, $last_hzs, $hzs_len, $npre_items, $npre_max, $b4_used) | 0;
}
function __ZN10ime_pinyin12AtomDictBaseD0Ev($this) {
 $this = $this | 0;
 __ZdlPv($this);
 return;
}
function __ZN10ime_pinyin12MatrixSearchC2Ev($this) {
 $this = $this | 0;
 HEAP8[$this | 0] = 0;
 HEAP32[$this + 4 >> 2] = __ZN10ime_pinyin12SpellingTrie14get_cpinstanceEv() | 0;
 __ZN10ime_pinyin12MatrixSearch22reset_pointers_to_nullEv($this);
 HEAP32[$this + 72 >> 2] = 0;
 HEAP16[$this + 84 >> 1] = 0;
 HEAP16[$this + 92 >> 1] = 0;
 HEAP8[$this + 8 | 0] = 1;
 HEAP8[$this + 728 | 0] = 0;
 HEAP32[$this + 24 >> 2] = 39;
 HEAP32[$this + 28 >> 2] = 40;
 return;
}
function __ZN10ime_pinyin12MatrixSearchD2Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin12MatrixSearch13free_resourceEv($this);
 return;
}
function __ZN10ime_pinyin12MatrixSearch13free_resourceEv($this) {
 $this = $this | 0;
 var $0 = 0, $3 = 0, $6 = 0, $8 = 0;
 $0 = HEAP32[$this + 12 >> 2] | 0;
 if (($0 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[$0 >> 2] | 0) + 4 >> 2] & 127]($0);
 }
 $3 = HEAP32[$this + 16 >> 2] | 0;
 if (($3 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[$3 >> 2] | 0) + 4 >> 2] & 127]($3);
 }
 $6 = HEAP32[$this + 20 >> 2] | 0;
 if (($6 | 0) != 0) {
  __ZdlPv($6);
 }
 $8 = HEAP32[$this + 76 >> 2] | 0;
 if (($8 | 0) == 0) {
  __ZN10ime_pinyin12MatrixSearch22reset_pointers_to_nullEv($this);
  return;
 }
 __ZdaPv($8);
 __ZN10ime_pinyin12MatrixSearch22reset_pointers_to_nullEv($this);
 return;
}
function __ZN10ime_pinyin8DictTrie8get_lpisEPKttPNS_10LmaPsbItemEj($this, $splid_str, $splid_str_len, $lma_buf, $max_lma_buf) {
 $this = $this | 0;
 $splid_str = $splid_str | 0;
 $splid_str_len = $splid_str_len | 0;
 $lma_buf = $lma_buf | 0;
 $max_lma_buf = $max_lma_buf | 0;
 var $node_buf1 = 0, $id_start = 0, $conv = 0, $root_ = 0, $0 = 0, $spl_trie_ = 0, $splid_le0_index_ = 0, $lma_node_num_ge1_ = 0, $nodes_ge1_ = 0, $nodes_ge1_165 = 0, $node_fr_le0_0_ph203 = 0, $node_to_le0_0_ph202 = 0, $node_fr_ge1_0_ph201 = 0, $node_to_ge1_0_ph200 = 0, $node_fr_num_0_ph199 = 0, $spl_pos_0_ph198 = 0, $node_fr_le0_0195 = 0, $node_to_le0_0194 = 0, $node_to_ge1_0193 = 0, $node_fr_num_0192 = 0, $spl_pos_0191 = 0, $arrayidx9 = 0, $call14 = 0, $id_num_0 = 0, $add191 = 0, $conv177 = 0, $cmp24 = 0, $conv32 = 0, $add = 0, $add66 = 0, $add125 = 0, $conv111 = 0, $node_to_num_1140 = 0, $node_fr_pos_0139 = 0, $8 = 0, $conv28 = 0, $11 = 0, $conv36 = 0, $son_1st_off = 0, $son_pos_0 = 0, $node_to_num_2 = 0, $15 = 0, $spl_idx = 0, $16 = 0, $17 = 0, $node_to_num_3 = 0, $node_to_num_4 = 0, $inc73 = 0, $inc75 = 0, $node_to_num_5134 = 0, $node_fr_pos83_0133 = 0, $21 = 0, $num_of_son = 0, $son_1st_off94 = 0, $son_pos89_0 = 0, $node_to_num_6 = 0, $23 = 0, $25 = 0, $add_ptr101_sum = 0, $add_ptr102 = 0, $spl_idx103 = 0, $26 = 0, $27 = 0, $node_to_num_7 = 0, $node_to_num_8 = 0, $inc134 = 0, $inc136 = 0, $spl_pos_0_ph_be = 0, $node_fr_num_0_ph_be = 0, $node_to_ge1_0_ph_be = 0, $node_to_le0_0_ph_be = 0, $node_fr_le0_0_ph_be = 0, $node_to_num_9145 = 0, $node_fr_pos144_0144 = 0, $31 = 0, $num_of_son152 = 0, $son_1st_off_l = 0, $son_1st_off_h = 0, $son_pos150_0 = 0, $node_to_num_10 = 0, $35 = 0, $add_ptr167_sum = 0, $add_ptr168 = 0, $spl_idx169 = 0, $36 = 0, $37 = 0, $node_to_num_11 = 0, $node_to_num_12 = 0, $inc200 = 0, $inc202 = 0, $spl_pos_2 = 0, $node_to_num_14 = 0, $call215 = 0, $node_to_num_15 = 0, $cmp228 = 0, $sub246 = 0, $42 = 0, $sub278 = 0, $lma_num_0 = 0, $node_pos_0 = 0, $43 = 0, $conv232 = 0, $homo_idx_buf_off = 0, $homo_pos_0 = 0, $add236 = 0, $bf_value = 0, $46 = 0, $51 = 0, $conv256 = 0, $homo_pos257_0 = 0, $add262 = 0, $bf_value267 = 0, $53 = 0, $num_of_homo_0 = 0, $add286 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1608 | 0;
 $node_buf1 = sp | 0;
 $id_start = sp + 1600 | 0;
 $conv = $splid_str_len & 65535;
 if (($splid_str_len & 65535) > 8) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $root_ = $this + 12 | 0;
 $0 = HEAP32[$root_ >> 2] | 0;
 HEAP32[$node_buf1 >> 2] = $0;
 if (($0 | 0) == 0 | $splid_str_len << 16 >> 16 == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $spl_trie_ = $this + 8 | 0;
 $splid_le0_index_ = $this + 20 | 0;
 $lma_node_num_ge1_ = $this + 28 | 0;
 $nodes_ge1_ = $this + 16 | 0;
 $nodes_ge1_165 = $this + 16 | 0;
 $spl_pos_0_ph198 = 0;
 $node_fr_num_0_ph199 = 1;
 $node_to_ge1_0_ph200 = 0;
 $node_fr_ge1_0_ph201 = 0;
 $node_to_le0_0_ph202 = sp + 800 | 0;
 $node_fr_le0_0_ph203 = $node_buf1;
 L1043 : while (1) {
  $spl_pos_0191 = $spl_pos_0_ph198;
  $node_fr_num_0192 = $node_fr_num_0_ph199;
  $node_to_ge1_0193 = $node_to_ge1_0_ph200;
  $node_to_le0_0194 = $node_to_le0_0_ph202;
  $node_fr_le0_0195 = $node_fr_le0_0_ph203;
  while (1) {
   $arrayidx9 = $splid_str + ($spl_pos_0191 << 1) | 0;
   HEAP16[$id_start >> 1] = HEAP16[$arrayidx9 >> 1] | 0;
   if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$arrayidx9 >> 1] | 0) | 0) {
    $call14 = __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$arrayidx9 >> 1] | 0, $id_start) | 0;
    if ($call14 << 16 >> 16 == 0) {
     label = 853;
     break L1043;
    } else {
     $id_num_0 = $call14;
    }
   } else {
    $id_num_0 = 1;
   }
   if (($spl_pos_0191 | 0) == 1) {
    label = 859;
    break;
   } else if (($spl_pos_0191 | 0) != 0) {
    label = 855;
    break;
   }
   if (($node_fr_num_0192 | 0) == 0) {
    $retval_0 = 0;
    label = 920;
    break L1043;
   }
   $cmp24 = ($node_fr_num_0192 | 0) == 1;
   $conv32 = $id_num_0 & 65535;
   $add = $conv32 - 30 | 0;
   $add66 = $conv32 - 1 | 0;
   $node_fr_pos_0139 = 0;
   $node_to_num_1140 = 0;
   while (1) {
    $8 = HEAP32[$node_fr_le0_0195 + ($node_fr_pos_0139 << 2) >> 2] | 0;
    if (!(($8 | 0) == (HEAP32[$root_ >> 2] | 0) & $cmp24)) {
     label = 862;
     break L1043;
    }
    $conv28 = HEAPU16[$id_start >> 1] | 0;
    $11 = HEAP32[$splid_le0_index_ >> 2] | 0;
    $conv36 = HEAPU16[$11 + ($add + $conv28 << 1) >> 1] | 0;
    $son_1st_off = $8 | 0;
    $node_to_num_2 = $node_to_num_1140;
    $son_pos_0 = HEAPU16[$11 + ($conv28 - 30 << 1) >> 1] | 0;
    while (1) {
     if ($son_pos_0 >>> 0 >= $conv36 >>> 0) {
      $node_to_num_4 = $node_to_num_2;
      break;
     }
     if ((HEAP32[$son_1st_off >> 2] | 0) != 1) {
      label = 866;
      break L1043;
     }
     $15 = HEAP32[$root_ >> 2] | 0;
     $spl_idx = $15 + ($son_pos_0 << 4) + 8 | 0;
     $16 = HEAP16[$spl_idx >> 1] | 0;
     $17 = HEAP16[$id_start >> 1] | 0;
     if (($16 & 65535) < ($17 & 65535)) {
      label = 914;
      break L1043;
     }
     if (($16 & 65535 | 0) >= (($17 & 65535) + $conv32 | 0)) {
      label = 915;
      break L1043;
     }
     if ($node_to_num_2 >>> 0 < 200) {
      HEAP32[$node_to_le0_0194 + ($node_to_num_2 << 2) >> 2] = $15 + ($son_pos_0 << 4);
      $node_to_num_3 = $node_to_num_2 + 1 | 0;
     } else {
      $node_to_num_3 = $node_to_num_2;
     }
     if ((HEAPU16[$spl_idx >> 1] | 0) < ($add66 + (HEAPU16[$id_start >> 1] | 0) | 0)) {
      $node_to_num_2 = $node_to_num_3;
      $son_pos_0 = $son_pos_0 + 1 | 0;
     } else {
      $node_to_num_4 = $node_to_num_3;
      break;
     }
    }
    $inc73 = $node_fr_pos_0139 + 1 | 0;
    if ($inc73 >>> 0 < $node_fr_num_0192 >>> 0) {
     $node_fr_pos_0139 = $inc73;
     $node_to_num_1140 = $node_to_num_4;
    } else {
     break;
    }
   }
   $inc75 = $spl_pos_0191 + 1 | 0;
   if ($inc75 >>> 0 >= $conv >>> 0 | ($node_to_num_4 | 0) == 0) {
    $node_to_num_14 = $node_to_num_4;
    $spl_pos_2 = $inc75;
    label = 899;
    break L1043;
   }
   if ($inc75 >>> 0 < $conv >>> 0) {
    $spl_pos_0191 = $inc75;
    $node_fr_num_0192 = $node_to_num_4;
    $node_to_ge1_0193 = $node_fr_le0_0195;
    $node_fr_le0_0195 = $node_to_le0_0194;
    $node_to_le0_0194 = 0;
   } else {
    $retval_0 = 0;
    label = 922;
    break L1043;
   }
  }
  if ((label | 0) == 855) {
   label = 0;
   if (($node_fr_num_0192 | 0) == 0) {
    $retval_0 = 0;
    label = 916;
    break;
   }
   $add191 = ($id_num_0 & 65535) - 1 | 0;
   $conv177 = $id_num_0 & 65535;
   $node_fr_pos144_0144 = 0;
   $node_to_num_9145 = 0;
   while (1) {
    $31 = HEAP32[$node_fr_ge1_0_ph201 + ($node_fr_pos144_0144 << 2) >> 2] | 0;
    $num_of_son152 = $31 + 6 | 0;
    $son_1st_off_l = $31 | 0;
    $son_1st_off_h = $31 + 8 | 0;
    $node_to_num_10 = $node_to_num_9145;
    $son_pos150_0 = 0;
    while (1) {
     if ($son_pos150_0 >>> 0 >= (HEAPU8[$num_of_son152] | 0) >>> 0) {
      $node_to_num_12 = $node_to_num_10;
      break;
     }
     if ((HEAP16[$son_1st_off_l >> 1] | 0) == 0) {
      if ((HEAP8[$son_1st_off_h] | 0) == 0) {
       label = 892;
       break L1043;
      }
     }
     $35 = HEAP32[$nodes_ge1_165 >> 2] | 0;
     $add_ptr167_sum = (__ZN10ime_pinyin8DictTrie14get_son_offsetEPKNS_10LmaNodeGE1E(0, $31) | 0) + $son_pos150_0 | 0;
     $add_ptr168 = $35 + ($add_ptr167_sum * 10 | 0) | 0;
     $spl_idx169 = $35 + ($add_ptr167_sum * 10 | 0) + 4 | 0;
     $36 = HEAP16[$spl_idx169 >> 1] | 0;
     $37 = HEAP16[$id_start >> 1] | 0;
     do {
      if (($36 & 65535) < ($37 & 65535)) {
       $node_to_num_11 = $node_to_num_10;
      } else {
       if (!(($36 & 65535 | 0) < (($37 & 65535) + $conv177 | 0) & $node_to_num_10 >>> 0 < 200)) {
        $node_to_num_11 = $node_to_num_10;
        break;
       }
       HEAP32[$node_to_ge1_0193 + ($node_to_num_10 << 2) >> 2] = $add_ptr168;
       $node_to_num_11 = $node_to_num_10 + 1 | 0;
      }
     } while (0);
     if ((HEAPU16[$spl_idx169 >> 1] | 0) < ($add191 + (HEAPU16[$id_start >> 1] | 0) | 0)) {
      $node_to_num_10 = $node_to_num_11;
      $son_pos150_0 = $son_pos150_0 + 1 | 0;
     } else {
      $node_to_num_12 = $node_to_num_11;
      break;
     }
    }
    $inc200 = $node_fr_pos144_0144 + 1 | 0;
    if ($inc200 >>> 0 < $node_fr_num_0192 >>> 0) {
     $node_fr_pos144_0144 = $inc200;
     $node_to_num_9145 = $node_to_num_12;
    } else {
     break;
    }
   }
   $inc202 = $spl_pos_0191 + 1 | 0;
   if ($inc202 >>> 0 >= $conv >>> 0 | ($node_to_num_12 | 0) == 0) {
    $node_to_num_14 = $node_to_num_12;
    $spl_pos_2 = $inc202;
    label = 899;
    break;
   } else {
    $node_fr_le0_0_ph_be = $node_fr_le0_0195;
    $node_to_le0_0_ph_be = $node_to_le0_0194;
    $node_to_ge1_0_ph_be = $node_fr_ge1_0_ph201;
    $node_fr_num_0_ph_be = $node_to_num_12;
    $spl_pos_0_ph_be = $inc202;
   }
  } else if ((label | 0) == 859) {
   label = 0;
   if (($node_fr_num_0192 | 0) == 0) {
    $retval_0 = 0;
    label = 921;
    break;
   }
   $add125 = ($id_num_0 & 65535) - 1 | 0;
   $conv111 = $id_num_0 & 65535;
   $node_fr_pos83_0133 = 0;
   $node_to_num_5134 = 0;
   while (1) {
    $21 = HEAP32[$node_fr_le0_0195 + ($node_fr_pos83_0133 << 2) >> 2] | 0;
    $num_of_son = $21 + 10 | 0;
    $son_1st_off94 = $21 | 0;
    $node_to_num_6 = $node_to_num_5134;
    $son_pos89_0 = 0;
    while (1) {
     if ($son_pos89_0 >>> 0 >= (HEAPU16[$num_of_son >> 1] | 0) >>> 0) {
      $node_to_num_8 = $node_to_num_6;
      break;
     }
     $23 = HEAP32[$son_1st_off94 >> 2] | 0;
     if ($23 >>> 0 > (HEAP32[$lma_node_num_ge1_ >> 2] | 0) >>> 0) {
      label = 879;
      break L1043;
     }
     $25 = HEAP32[$nodes_ge1_ >> 2] | 0;
     $add_ptr101_sum = $23 + $son_pos89_0 | 0;
     $add_ptr102 = $25 + ($add_ptr101_sum * 10 | 0) | 0;
     $spl_idx103 = $25 + ($add_ptr101_sum * 10 | 0) + 4 | 0;
     $26 = HEAP16[$spl_idx103 >> 1] | 0;
     $27 = HEAP16[$id_start >> 1] | 0;
     do {
      if (($26 & 65535) < ($27 & 65535)) {
       $node_to_num_7 = $node_to_num_6;
      } else {
       if (!(($26 & 65535 | 0) < (($27 & 65535) + $conv111 | 0) & $node_to_num_6 >>> 0 < 200)) {
        $node_to_num_7 = $node_to_num_6;
        break;
       }
       HEAP32[$node_to_ge1_0193 + ($node_to_num_6 << 2) >> 2] = $add_ptr102;
       $node_to_num_7 = $node_to_num_6 + 1 | 0;
      }
     } while (0);
     if ((HEAPU16[$spl_idx103 >> 1] | 0) < ($add125 + (HEAPU16[$id_start >> 1] | 0) | 0)) {
      $node_to_num_6 = $node_to_num_7;
      $son_pos89_0 = $son_pos89_0 + 1 | 0;
     } else {
      $node_to_num_8 = $node_to_num_7;
      break;
     }
    }
    $inc134 = $node_fr_pos83_0133 + 1 | 0;
    if ($inc134 >>> 0 < $node_fr_num_0192 >>> 0) {
     $node_fr_pos83_0133 = $inc134;
     $node_to_num_5134 = $node_to_num_8;
    } else {
     break;
    }
   }
   $inc136 = $spl_pos_0191 + 1 | 0;
   if ($inc136 >>> 0 >= $conv >>> 0 | ($node_to_num_8 | 0) == 0) {
    $node_to_num_14 = $node_to_num_8;
    $spl_pos_2 = $inc136;
    label = 899;
    break;
   }
   $node_fr_le0_0_ph_be = 0;
   $node_to_le0_0_ph_be = 0;
   $node_to_ge1_0_ph_be = $node_fr_le0_0195;
   $node_fr_num_0_ph_be = $node_to_num_8;
   $spl_pos_0_ph_be = $inc136;
  }
  if ($spl_pos_0_ph_be >>> 0 < $conv >>> 0) {
   $spl_pos_0_ph198 = $spl_pos_0_ph_be;
   $node_fr_num_0_ph199 = $node_fr_num_0_ph_be;
   $node_to_ge1_0_ph200 = $node_to_ge1_0_ph_be;
   $node_fr_ge1_0_ph201 = $node_to_ge1_0193;
   $node_to_le0_0_ph202 = $node_to_le0_0_ph_be;
   $node_fr_le0_0_ph203 = $node_fr_le0_0_ph_be;
  } else {
   $retval_0 = 0;
   label = 919;
   break;
  }
 }
 if ((label | 0) == 866) {
  ___assert_func(3680, 708, 4720, 824);
  return 0;
 } else if ((label | 0) == 862) {
  ___assert_func(3680, 703, 4720, 3440);
  return 0;
 } else if ((label | 0) == 892) {
  ___assert_func(3680, 768, 4720, 4112);
  return 0;
 } else if ((label | 0) == 853) {
  ___assert_func(3680, 696, 4720, 3600);
  return 0;
 } else if ((label | 0) == 879) {
  ___assert_func(3680, 737, 4720, 4312);
  return 0;
 } else if ((label | 0) == 899) {
  if (($node_to_num_14 | 0) == 0) {
   $retval_0 = 0;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
  $call215 = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
  do {
   if ($splid_str_len << 16 >> 16 == 1) {
    if (!(__ZNK10ime_pinyin12SpellingTrie16is_half_id_yunmuEt(HEAP32[$this + 8 >> 2] | 0, HEAP16[$splid_str >> 1] | 0) | 0)) {
     $node_to_num_15 = $node_to_num_14;
     break;
    }
    $node_to_num_15 = ($node_to_num_14 | 0) != 0 | 0;
   } else {
    $node_to_num_15 = $node_to_num_14;
   }
  } while (0);
  $cmp228 = $spl_pos_2 >>> 0 < 2;
  $sub246 = $max_lma_buf - 1 | 0;
  $42 = $conv << 24 & 251658240;
  $sub278 = $max_lma_buf - 1 | 0;
  $node_pos_0 = 0;
  $lma_num_0 = 0;
  while (1) {
   if ($node_pos_0 >>> 0 >= $node_to_num_15 >>> 0) {
    $retval_0 = $lma_num_0;
    label = 924;
    break;
   }
   L1117 : do {
    if ($cmp228) {
     $43 = HEAP32[$node_to_le0_0194 + ($node_pos_0 << 2) >> 2] | 0;
     $conv232 = HEAPU16[$43 + 12 >> 1] | 0;
     $homo_idx_buf_off = $43 + 4 | 0;
     $homo_pos_0 = 0;
     while (1) {
      if ($homo_pos_0 >>> 0 >= $conv232 >>> 0) {
       $num_of_homo_0 = $conv232;
       break L1117;
      }
      $add236 = $homo_pos_0 + $lma_num_0 | 0;
      $bf_value = (__ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, (HEAP32[$homo_idx_buf_off >> 2] | 0) + $homo_pos_0 | 0) | 0) & 16777215;
      $46 = $lma_buf + ($add236 << 3) | 0;
      HEAP32[$46 >> 2] = $bf_value | HEAP32[$46 >> 2] & -268435456 | 16777216;
      HEAP16[$lma_buf + ($add236 << 3) + 4 >> 1] = ~~+__ZN10ime_pinyin5NGram11get_uni_psbEj($call215, $bf_value);
      if ($add236 >>> 0 < $sub246 >>> 0) {
       $homo_pos_0 = $homo_pos_0 + 1 | 0;
      } else {
       $num_of_homo_0 = $conv232;
       break;
      }
     }
    } else {
     $51 = HEAP32[$node_to_ge1_0193 + ($node_pos_0 << 2) >> 2] | 0;
     $conv256 = HEAPU8[$51 + 7 | 0] | 0;
     $homo_pos257_0 = 0;
     while (1) {
      if ($homo_pos257_0 >>> 0 >= $conv256 >>> 0) {
       $num_of_homo_0 = $conv256;
       break L1117;
      }
      $add262 = $homo_pos257_0 + $lma_num_0 | 0;
      $bf_value267 = (__ZN10ime_pinyin8DictTrie12get_lemma_idEj($this, (__ZN10ime_pinyin8DictTrie23get_homo_idx_buf_offsetEPKNS_10LmaNodeGE1E(0, $51) | 0) + $homo_pos257_0 | 0) | 0) & 16777215;
      $53 = $lma_buf + ($add262 << 3) | 0;
      HEAP32[$53 >> 2] = $bf_value267 | $42 | HEAP32[$53 >> 2] & -268435456;
      HEAP16[$lma_buf + ($add262 << 3) + 4 >> 1] = ~~+__ZN10ime_pinyin5NGram11get_uni_psbEj($call215, $bf_value267);
      if ($add262 >>> 0 < $sub278 >>> 0) {
       $homo_pos257_0 = $homo_pos257_0 + 1 | 0;
      } else {
       $num_of_homo_0 = $conv256;
       break;
      }
     }
    }
   } while (0);
   $add286 = $num_of_homo_0 + $lma_num_0 | 0;
   if ($add286 >>> 0 < $max_lma_buf >>> 0) {
    $node_pos_0 = $node_pos_0 + 1 | 0;
    $lma_num_0 = $add286;
   } else {
    $retval_0 = $max_lma_buf;
    label = 925;
    break;
   }
  }
  if ((label | 0) == 924) {
   STACKTOP = sp;
   return $retval_0 | 0;
  } else if ((label | 0) == 925) {
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 } else if ((label | 0) == 914) {
  ___assert_func(3680, 711, 4720, 3304);
  return 0;
 } else if ((label | 0) == 915) {
  ___assert_func(3680, 711, 4720, 3304);
  return 0;
 } else if ((label | 0) == 916) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 919) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 920) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 921) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 922) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictTrie16get_lemma_splidsEjPttb($this, $id_lemma, $splids, $splids_max, $arg_valid) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $splids = $splids | 0;
 $splids_max = $splids_max | 0;
 $arg_valid = $arg_valid | 0;
 var $lma_str = 0, $spl_mtrx = 0, $spl_start = 0, $call = 0, $spl_trie_ = 0, $_in43 = 0, $try_num_0_lcssa = 0, $cmp6344 = 0, $conv652 = 0, $pos_051 = 0, $try_num_050 = 0, $arrayidx11 = 0, $cond_off0 = 0, $9 = 0, $call37 = 0, $cand_splids_this_0 = 0, $inc = 0, $phitmp = 0, $try_pos_0 = 0, $conv6147 = 0, $pos59_046 = 0, $mod_045 = 0, $12 = 0, $sub72 = 0, $mul86 = 0, $inc89 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128 | 0;
 $lma_str = sp | 0;
 $spl_mtrx = sp + 24 | 0;
 $spl_start = sp + 104 | 0;
 $call = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$this >> 2] | 0) + 32 >> 2] & 31]($this, $id_lemma, $lma_str | 0, 9) | 0;
 if (!($call << 16 >> 16 == $splids_max << 16 >> 16 | (($call & 65535) > ($splids_max & 65535) | $arg_valid) ^ 1)) {
  ___assert_func(3680, 861, 4816, 3200);
  return 0;
 }
 HEAP16[$spl_start >> 1] = 0;
 L1141 : do {
  if ($call << 16 >> 16 == 0) {
   $try_num_0_lcssa = 1;
  } else {
   $spl_trie_ = $this + 8 | 0;
   $_in43 = $this + 4 | 0;
   $try_num_050 = 1;
   $pos_051 = 0;
   $conv652 = 0;
   while (1) {
    do {
     if ($arg_valid) {
      $arrayidx11 = $splids + ($conv652 << 1) | 0;
      if (__ZNK10ime_pinyin12SpellingTrie10is_full_idEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$arrayidx11 >> 1] | 0) | 0) {
       HEAP16[$spl_mtrx + ((HEAPU16[$spl_start + ($conv652 << 1) >> 1] | 0) << 1) >> 1] = HEAP16[$arrayidx11 >> 1] | 0;
       $cand_splids_this_0 = 1;
       break;
      } else {
       $cond_off0 = HEAP16[$splids + ($conv652 << 1) >> 1] | 0;
       label = 935;
       break;
      }
     } else {
      $cond_off0 = 0;
      label = 935;
     }
    } while (0);
    if ((label | 0) == 935) {
     label = 0;
     $9 = HEAP16[$spl_start + ($conv652 << 1) >> 1] | 0;
     $call37 = __ZN10ime_pinyin8DictList20get_splids_for_hanziEttPtt(HEAP32[$_in43 >> 2] | 0, HEAP16[$lma_str + ($conv652 << 1) >> 1] | 0, $cond_off0, $spl_mtrx + (($9 & 65535) << 1) | 0, 40 - $9 & 65535) | 0;
     if ($call37 << 16 >> 16 == 0) {
      break;
     } else {
      $cand_splids_this_0 = $call37;
     }
    }
    HEAP16[$spl_start + ($conv652 + 1 << 1) >> 1] = (HEAP16[$spl_start + ($conv652 << 1) >> 1] | 0) + $cand_splids_this_0 & 65535;
    $inc = $pos_051 + 1 & 65535;
    $phitmp = (Math_imul($cand_splids_this_0 & 65535, $try_num_050) | 0) & 65535;
    if (($inc & 65535) < ($call & 65535)) {
     $try_num_050 = $phitmp;
     $pos_051 = $inc;
     $conv652 = $inc & 65535;
    } else {
     $try_num_0_lcssa = $phitmp;
     break L1141;
    }
   }
   ___assert_func(3680, 877, 4816, 3112);
   return 0;
  }
 } while (0);
 $cmp6344 = $call << 16 >> 16 == 0;
 $try_pos_0 = 0;
 while (1) {
  if (($try_pos_0 & 65535) >>> 0 >= $try_num_0_lcssa >>> 0) {
   $retval_0 = 0;
   label = 944;
   break;
  }
  if (!$cmp6344) {
   $mod_045 = 1;
   $pos59_046 = 0;
   $conv6147 = 0;
   while (1) {
    $12 = HEAP16[$spl_start + ($conv6147 << 1) >> 1] | 0;
    $sub72 = (HEAP16[$spl_start + ($conv6147 + 1 << 1) >> 1] | 0) - $12 & 65535;
    HEAP16[$splids + ($conv6147 << 1) >> 1] = HEAP16[$spl_mtrx + (((((($try_pos_0 & 65535) / ($mod_045 & 65535) | 0) & 65535) % ($sub72 & 65535) | 0) & 65535) + ($12 & 65535) << 1) >> 1] | 0;
    $mul86 = Math_imul($sub72, $mod_045) | 0;
    $inc89 = $pos59_046 + 1 & 65535;
    if (($inc89 & 65535) < ($call & 65535)) {
     $mod_045 = $mul86;
     $pos59_046 = $inc89;
     $conv6147 = $inc89 & 65535;
    } else {
     break;
    }
   }
  }
  if (__ZN10ime_pinyin8DictTrie10try_extendEPKttj($this, $splids, $call, $id_lemma) | 0) {
   $retval_0 = $call;
   label = 943;
   break;
  } else {
   $try_pos_0 = $try_pos_0 + 1 & 65535;
  }
 }
 if ((label | 0) == 944) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 943) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12MatrixSearch12set_max_lensEjj($this, $max_sps_len, $max_hzs_len) {
 $this = $this | 0;
 $max_sps_len = $max_sps_len | 0;
 $max_hzs_len = $max_hzs_len | 0;
 if (($max_sps_len | 0) != 0) {
  HEAP32[$this + 24 >> 2] = $max_sps_len;
 }
 if (($max_hzs_len | 0) == 0) {
  return;
 }
 HEAP32[$this + 28 >> 2] = $max_hzs_len;
 return;
}
function __ZN10ime_pinyin12MatrixSearch16set_xi_an_switchEb($this, $xi_an_enabled) {
 $this = $this | 0;
 $xi_an_enabled = $xi_an_enabled | 0;
 HEAP8[$this + 8 | 0] = $xi_an_enabled & 1;
 return;
}
function __ZN10ime_pinyin12MatrixSearch16get_xi_an_switchEv($this) {
 $this = $this | 0;
 return (HEAP8[$this + 8 | 0] & 1) != 0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch14alloc_resourceEv($this) {
 $this = $this | 0;
 var $0 = 0, $dict_trie_ = 0, $call2 = 0, $user_dict_ = 0, $3 = 0, $spl_parser_ = 0, $div = 0, $div10 = 0, $div12 = 0, $add = 0, $add15 = 0, $add16 = 0, $4$0 = 0, $call17 = 0, $share_buf_ = 0, $retval_0 = 0;
 __ZN10ime_pinyin12MatrixSearch13free_resourceEv($this);
 $0 = __Znwj(64) | 0;
 __ZN10ime_pinyin8DictTrieC2Ev($0);
 $dict_trie_ = $this + 12 | 0;
 HEAP32[$dict_trie_ >> 2] = $0;
 $call2 = __Znwj(1132) | 0;
 __ZN10ime_pinyin8UserDictC2Ev($call2);
 $user_dict_ = $this + 16 | 0;
 HEAP32[$user_dict_ >> 2] = $call2;
 $3 = __Znwj(4) | 0;
 __ZN10ime_pinyin14SpellingParserC2Ev($3);
 $spl_parser_ = $this + 20 | 0;
 HEAP32[$spl_parser_ >> 2] = $3;
 $div = (__ZN10ime_pinyin15align_to_size_tEj(3200) | 0) >>> 2;
 $div10 = (__ZN10ime_pinyin15align_to_size_tEj(9600) | 0) >>> 2;
 $div12 = (__ZN10ime_pinyin15align_to_size_tEj(480) | 0) >>> 2;
 $add = $div10 + $div | 0;
 $add15 = $add + $div12 | 0;
 $add16 = $add15 + ((__ZN10ime_pinyin15align_to_size_tEj(92) | 0) >>> 2) | 0;
 $4$0 = _llvm_umul_with_overflow_i32($add16 | 0, 4) | 0;
 $call17 = __Znaj(tempRet0 ? -1 : $4$0) | 0;
 $share_buf_ = $this + 76 | 0;
 HEAP32[$share_buf_ >> 2] = $call17;
 if ((HEAP32[$dict_trie_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$user_dict_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$spl_parser_ >> 2] | 0) == 0 | ($call17 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP32[$this + 80 >> 2] = $call17;
 HEAP32[$this + 88 >> 2] = (HEAP32[$share_buf_ >> 2] | 0) + ($div << 2);
 HEAP32[$this + 96 >> 2] = (HEAP32[$share_buf_ >> 2] | 0) + ($add << 2);
 HEAP32[$this + 100 >> 2] = (HEAP32[$share_buf_ >> 2] | 0) + ($add15 << 2);
 HEAP32[$this + 104 >> 2] = HEAP32[$share_buf_ >> 2];
 HEAP32[$this + 108 >> 2] = ($add16 << 2 >>> 0) / 20 | 0;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch4initEPKcS2_($this, $fn_sys_dict, $fn_usr_dict) {
 $this = $this | 0;
 $fn_sys_dict = $fn_sys_dict | 0;
 $fn_usr_dict = $fn_usr_dict | 0;
 var $0 = 0, $user_dict_ = 0, $3 = 0, $call10 = 0, $6 = 0, $retval_0 = 0;
 if (($fn_sys_dict | 0) == 0 | ($fn_usr_dict | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin12MatrixSearch14alloc_resourceEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $0 = HEAP32[$this + 12 >> 2] | 0;
 if (!(FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$0 >> 2] | 0) + 8 >> 2] & 31]($0, $fn_sys_dict, 1, 5e5) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $user_dict_ = $this + 16 | 0;
 $3 = HEAP32[$user_dict_ >> 2] | 0;
 $call10 = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$3 >> 2] | 0) + 8 >> 2] & 31]($3, $fn_usr_dict, 500001, 6e5) | 0;
 $6 = HEAP32[$user_dict_ >> 2] | 0;
 if ($call10) {
  FUNCTION_TABLE_vii[HEAP32[(HEAP32[$6 >> 2] | 0) + 72 >> 2] & 15]($6, 1e8);
 } else {
  if (($6 | 0) != 0) {
   FUNCTION_TABLE_vi[HEAP32[(HEAP32[$6 >> 2] | 0) + 4 >> 2] & 127]($6);
  }
  HEAP32[$user_dict_ >> 2] = 0;
 }
 __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) | 0;
 HEAP8[$this | 0] = 1;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) {
 $this = $this | 0;
 var $mtrx_nd_pool_used_ = 0, $matrix_ = 0, $6 = 0, $conv10 = 0, $add_ptr = 0, $12 = 0, $17 = 0, $21 = 0, $24 = 0, $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP32[$this + 72 >> 2] = 0;
 $mtrx_nd_pool_used_ = $this + 84 | 0;
 HEAP16[$mtrx_nd_pool_used_ >> 1] = 0;
 HEAP16[$this + 92 >> 1] = 0;
 $matrix_ = $this + 96 | 0;
 HEAP16[HEAP32[$matrix_ >> 2] >> 1] = HEAP16[$mtrx_nd_pool_used_ >> 1] | 0;
 HEAP16[(HEAP32[$matrix_ >> 2] | 0) + 4 >> 1] = 1;
 HEAP16[$mtrx_nd_pool_used_ >> 1] = (HEAP16[$mtrx_nd_pool_used_ >> 1] | 0) + 1 & 65535;
 $6 = HEAP32[$this + 80 >> 2] | 0;
 $conv10 = HEAPU16[HEAP32[$matrix_ >> 2] >> 1] | 0;
 $add_ptr = $6 + ($conv10 << 4) | 0;
 HEAP32[$add_ptr >> 2] = 0;
 HEAPF32[$6 + ($conv10 << 4) + 4 >> 2] = 0.0;
 HEAP32[$6 + ($conv10 << 4) + 8 >> 2] = 0;
 HEAP16[$6 + ($conv10 << 4) + 14 >> 1] = 0;
 HEAP16[$6 + ($conv10 << 4) + 12 >> 1] = -1;
 HEAP16[(HEAP32[$matrix_ >> 2] | 0) + 2 >> 1] = 0;
 $12 = (HEAP32[$matrix_ >> 2] | 0) + 6 | 0;
 HEAP16[$12 >> 1] = HEAP16[$12 >> 1] & -32768;
 $17 = (HEAP32[$matrix_ >> 2] | 0) + 6 | 0;
 HEAP16[$17 >> 1] = HEAP16[$17 >> 1] | -32768;
 HEAP32[(HEAP32[$matrix_ >> 2] | 0) + 8 >> 2] = $add_ptr;
 HEAP16[$this + 116 >> 1] = 0;
 HEAP32[$this + 356 >> 2] = 0;
 HEAP16[$this + 736 >> 1] = 0;
 HEAP32[$this + 896 >> 2] = 0;
 $21 = HEAP32[$this + 12 >> 2] | 0;
 FUNCTION_TABLE_viii[HEAP32[(HEAP32[$21 >> 2] | 0) + 20 >> 2] & 15]($21, 0, 0);
 $24 = HEAP32[$this + 16 >> 2] | 0;
 if (($24 | 0) == 0) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 FUNCTION_TABLE_viii[HEAP32[(HEAP32[$24 >> 2] | 0) + 20 >> 2] & 15]($24, 0, 0);
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch7init_fdEillPKc($this, $sys_fd, $start_offset, $length, $fn_usr_dict) {
 $this = $this | 0;
 $sys_fd = $sys_fd | 0;
 $start_offset = $start_offset | 0;
 $length = $length | 0;
 $fn_usr_dict = $fn_usr_dict | 0;
 var $user_dict_ = 0, $1 = 0, $call7 = 0, $4 = 0, $retval_0 = 0;
 if (($fn_usr_dict | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin12MatrixSearch14alloc_resourceEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8DictTrie12load_dict_fdEilljj(HEAP32[$this + 12 >> 2] | 0, $sys_fd, $start_offset, $length, 1, 5e5) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $user_dict_ = $this + 16 | 0;
 $1 = HEAP32[$user_dict_ >> 2] | 0;
 $call7 = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$1 >> 2] | 0) + 8 >> 2] & 31]($1, $fn_usr_dict, 500001, 6e5) | 0;
 $4 = HEAP32[$user_dict_ >> 2] | 0;
 if ($call7) {
  FUNCTION_TABLE_vii[HEAP32[(HEAP32[$4 >> 2] | 0) + 72 >> 2] & 15]($4, 1e8);
 } else {
  if (($4 | 0) != 0) {
   FUNCTION_TABLE_vi[HEAP32[(HEAP32[$4 >> 2] | 0) + 4 >> 2] & 127]($4);
  }
  HEAP32[$user_dict_ >> 2] = 0;
 }
 __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) | 0;
 HEAP8[$this | 0] = 1;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch5closeEv($this) {
 $this = $this | 0;
 __ZN10ime_pinyin12MatrixSearch11flush_cacheEv($this);
 __ZN10ime_pinyin12MatrixSearch13free_resourceEv($this);
 HEAP8[$this | 0] = 0;
 return;
}
function __ZN10ime_pinyin12MatrixSearch11flush_cacheEv($this) {
 $this = $this | 0;
 var $0 = 0;
 $0 = HEAP32[$this + 16 >> 2] | 0;
 if (($0 | 0) == 0) {
  return;
 }
 FUNCTION_TABLE_vi[HEAP32[(HEAP32[$0 >> 2] | 0) + 76 >> 2] & 127]($0);
 return;
}
function __ZN10ime_pinyin12MatrixSearch12reset_searchEv($this) {
 $this = $this | 0;
 var $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch10del_in_pysEjj($this, $start, $len) {
 $this = $this | 0;
 $start = $start | 0;
 $len = $len | 0;
 var $sub = 0, $start_addr_07 = 0, $arrayidx = 0, $inc = 0, label = 0;
 $sub = 40 - $len | 0;
 if ($sub >>> 0 > $start >>> 0) {
  $start_addr_07 = $start;
 } else {
  return;
 }
 while (1) {
  $arrayidx = $this + 32 + $start_addr_07 | 0;
  if ((HEAP8[$arrayidx] | 0) == 0) {
   label = 1022;
   break;
  }
  HEAP8[$arrayidx] = HEAP8[$start_addr_07 + $len + ($this + 32) | 0] | 0;
  $inc = $start_addr_07 + 1 | 0;
  if ($inc >>> 0 < $sub >>> 0) {
   $start_addr_07 = $inc;
  } else {
   label = 1020;
   break;
  }
 }
 if ((label | 0) == 1020) {
  return;
 } else if ((label | 0) == 1022) {
  return;
 }
}
function __ZN10ime_pinyin12MatrixSearch8add_charEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 var $retval_0 = 0;
 if (!(__ZN10ime_pinyin12MatrixSearch16prepare_add_charEc($this, $ch) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch15add_char_qwertyEv($this) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch6searchEPKcj($this, $py, $py_len) {
 $this = $this | 0;
 $py = $py | 0;
 $py_len = $py_len | 0;
 var $_py_len = 0, $pys_decoded_len_ = 0, $2 = 0, $ch_pos_0 = 0, $3 = 0, $add_ptr = 0, $add_ptr21 = 0, $sub = 0, $ch_pos_1 = 0, $spl_id_num_ = 0, $py_len_addr_124 = 0, $retval_0 = 0, label = 0;
 if ((HEAP8[$this | 0] & 1) == 0 | ($py | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $_py_len = $py_len >>> 0 > 39 ? 39 : $py_len;
 $pys_decoded_len_ = $this + 72 | 0;
 $2 = HEAP32[$pys_decoded_len_ >> 2] | 0;
 $ch_pos_0 = 0;
 while (1) {
  if ($ch_pos_0 >>> 0 >= $2 >>> 0) {
   break;
  }
  $3 = HEAP8[$py + $ch_pos_0 | 0] | 0;
  if ($3 << 24 >> 24 == 0) {
   break;
  }
  if ($3 << 24 >> 24 == (HEAP8[$this + 32 + $ch_pos_0 | 0] | 0)) {
   $ch_pos_0 = $ch_pos_0 + 1 | 0;
  } else {
   break;
  }
 }
 __ZN10ime_pinyin12MatrixSearch12reset_searchEjbbb($this, $ch_pos_0, ($ch_pos_0 | 0) != (HEAP32[$pys_decoded_len_ >> 2] | 0), 0, 0) | 0;
 $add_ptr = $this + 32 + $ch_pos_0 | 0;
 $add_ptr21 = $py + $ch_pos_0 | 0;
 $sub = $_py_len - $ch_pos_0 | 0;
 _memcpy($add_ptr | 0, $add_ptr21 | 0, $sub) | 0;
 HEAP8[$this + 32 + $_py_len | 0] = 0;
 $ch_pos_1 = $ch_pos_0;
 while (1) {
  if ((HEAP8[$this + 32 + $ch_pos_1 | 0] | 0) == 0) {
   break;
  }
  if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, HEAP8[$py + $ch_pos_1 | 0] | 0) | 0) {
   $ch_pos_1 = $ch_pos_1 + 1 | 0;
  } else {
   label = 1036;
   break;
  }
 }
 if ((label | 0) == 1036) {
  HEAP32[$pys_decoded_len_ >> 2] = $ch_pos_1;
 }
 __ZN10ime_pinyin12MatrixSearch16get_spl_start_idEv($this);
 $spl_id_num_ = $this + 732 | 0;
 if ((HEAP32[$spl_id_num_ >> 2] | 0) >>> 0 > 9) {
  $py_len_addr_124 = $_py_len;
  do {
   $py_len_addr_124 = $py_len_addr_124 - 1 | 0;
   __ZN10ime_pinyin12MatrixSearch12reset_searchEjbbb($this, $py_len_addr_124, 0, 0, 0) | 0;
   HEAP8[$this + 32 + $py_len_addr_124 | 0] = 0;
   __ZN10ime_pinyin12MatrixSearch16get_spl_start_idEv($this);
  } while ((HEAP32[$spl_id_num_ >> 2] | 0) >>> 0 > 9);
 }
 __ZN10ime_pinyin12MatrixSearch18prepare_candidatesEv($this);
 $retval_0 = $ch_pos_1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch12reset_searchEjbbb($this, $ch_pos, $clear_fixed_this_step, $clear_dmi_this_step, $clear_mtrx_this_step) {
 $this = $this | 0;
 $ch_pos = $ch_pos | 0;
 $clear_fixed_this_step = $clear_fixed_this_step | 0;
 $clear_dmi_this_step = $clear_dmi_this_step | 0;
 $clear_mtrx_this_step = $clear_mtrx_this_step | 0;
 var $pys_decoded_len_ = 0, $cmp6 = 0, $3 = 0, $add = 0, $10 = 0, $dict_handles_to_clear_1 = 0, $16 = 0, $conv40 = 0, $20 = 0, $sub = 0, $matrix_54 = 0, $24 = 0, $31 = 0, $34 = 0, $sub85 = 0, $matrix_86 = 0, $39 = 0, $43 = 0, $fixed_hzs_ = 0, $fixed_ch_pos_0_ph = 0, $matrix_130 = 0, $50 = 0, $fixed_ch_pos_0 = 0, $cmp133 = 0, $fixed_lmas_ = 0, $52 = 0, $conv141114 = 0, $54 = 0, $inc = 0, $conv141 = 0, $conv141_lcssa = 0, $56 = 0, $conv157110 = 0, $58 = 0, $59 = 0, $inc162 = 0, $conv157 = 0, $61 = 0, $_lcssa = 0, $conv157_lcssa = 0, $cmp177 = 0, $or_cond85 = 0, $62 = 0, $dict_handles_to_clear174_0 = 0, $add200 = 0, $69 = 0, $dict_handles_to_clear174_1 = 0, $75 = 0, $conv224 = 0, $79 = 0, $sub241 = 0, $83 = 0, $90 = 0, $93 = 0, $sub276 = 0, $98 = 0, $102 = 0, $conv306105 = 0, $conv306108 = 0, $re_pos_0107 = 0, $inc311 = 0, $conv306 = 0, $arrayidx317 = 0, $sublma_num = 0, $length366 = 0, $conv321104 = 0, $subpos_0103 = 0, $108 = 0, $add329 = 0, $arrayidx332 = 0, $109 = 0, $splpos_0100 = 0, $conv334101 = 0, $dmi_c_phrase_ = 0, $length386 = 0, $c_py_pos_0 = 0, $116 = 0, $idxprom420 = 0, $120 = 0, $retval_0 = 0, label = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $pys_decoded_len_ = $this + 72 | 0;
 if ((HEAP32[$pys_decoded_len_ >> 2] | 0) >>> 0 < $ch_pos >>> 0 | $ch_pos >>> 0 > 39) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $cmp6 = ($ch_pos | 0) == 0;
 if ($cmp6) {
  __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) | 0;
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 do {
  if ($clear_dmi_this_step) {
   $3 = HEAP32[$this + 96 >> 2] | 0;
   if ((HEAP16[$3 + ($ch_pos * 12 | 0) + 6 >> 1] & 32767) == 0) {
    HEAP32[$pys_decoded_len_ >> 2] = $ch_pos;
    label = 1059;
    break;
   } else {
    $dict_handles_to_clear_1 = (HEAP32[$this + 88 >> 2] | 0) + ((HEAPU16[$3 + ($ch_pos * 12 | 0) + 2 >> 1] | 0) * 12 | 0) | 0;
    label = 1055;
    break;
   }
  } else {
   if ((HEAP32[$pys_decoded_len_ >> 2] | 0) >>> 0 <= $ch_pos >>> 0 | $clear_dmi_this_step) {
    HEAP32[$pys_decoded_len_ >> 2] = $ch_pos;
    label = 1060;
    break;
   }
   $add = $ch_pos + 1 | 0;
   $10 = HEAP32[$this + 96 >> 2] | 0;
   if ((HEAP16[$10 + ($add * 12 | 0) + 6 >> 1] & 32767) == 0) {
    label = 1058;
    break;
   }
   $dict_handles_to_clear_1 = (HEAP32[$this + 88 >> 2] | 0) + ((HEAPU16[$10 + ($add * 12 | 0) + 2 >> 1] | 0) * 12 | 0) | 0;
   label = 1055;
  }
 } while (0);
 do {
  if ((label | 0) == 1055) {
   if (($dict_handles_to_clear_1 | 0) == 0) {
    label = 1058;
    break;
   }
   $16 = HEAP32[$this + 12 >> 2] | 0;
   $conv40 = $ch_pos & 65535;
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[$16 >> 2] | 0) + 20 >> 2] & 15]($16, $conv40, HEAP16[$dict_handles_to_clear_1 >> 1] | 0);
   $20 = HEAP32[$this + 16 >> 2] | 0;
   if (($20 | 0) == 0) {
    label = 1058;
    break;
   }
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[$20 >> 2] | 0) + 20 >> 2] & 15]($20, $conv40, HEAP16[$dict_handles_to_clear_1 + 2 >> 1] | 0);
   label = 1058;
  }
 } while (0);
 if ((label | 0) == 1058) {
  HEAP32[$pys_decoded_len_ >> 2] = $ch_pos;
  if ($clear_dmi_this_step) {
   label = 1059;
  } else {
   label = 1060;
  }
 }
 if ((label | 0) == 1059) {
  $sub = $ch_pos - 1 | 0;
  $matrix_54 = $this + 96 | 0;
  $24 = HEAP32[$matrix_54 >> 2] | 0;
  HEAP16[$this + 92 >> 1] = (HEAP16[$24 + ($sub * 12 | 0) + 6 >> 1] & 32767) + (HEAP16[$24 + ($sub * 12 | 0) + 2 >> 1] | 0) & 65535;
  $31 = (HEAP32[$matrix_54 >> 2] | 0) + ($ch_pos * 12 | 0) + 6 | 0;
  HEAP16[$31 >> 1] = HEAP16[$31 >> 1] & -32768;
 } else if ((label | 0) == 1060) {
  $34 = HEAP32[$this + 96 >> 2] | 0;
  HEAP16[$this + 92 >> 1] = (HEAP16[$34 + ($ch_pos * 12 | 0) + 6 >> 1] & 32767) + (HEAP16[$34 + ($ch_pos * 12 | 0) + 2 >> 1] | 0) & 65535;
 }
 if ($clear_mtrx_this_step) {
  $sub85 = $ch_pos - 1 | 0;
  $matrix_86 = $this + 96 | 0;
  $39 = HEAP32[$matrix_86 >> 2] | 0;
  HEAP16[$this + 84 >> 1] = (HEAP16[$39 + ($sub85 * 12 | 0) + 4 >> 1] | 0) + (HEAP16[$39 + ($sub85 * 12 | 0) >> 1] | 0) & 65535;
  HEAP16[(HEAP32[$matrix_86 >> 2] | 0) + ($ch_pos * 12 | 0) + 4 >> 1] = 0;
 } else {
  $43 = HEAP32[$this + 96 >> 2] | 0;
  HEAP16[$this + 84 >> 1] = (HEAP16[$43 + ($ch_pos * 12 | 0) + 4 >> 1] | 0) + (HEAP16[$43 + ($ch_pos * 12 | 0) >> 1] | 0) & 65535;
 }
 $fixed_hzs_ = $this + 896 | 0;
 if ((HEAP32[$fixed_hzs_ >> 2] | 0) == 0) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 do {
  if ((HEAP32[$this + 196 >> 2] | 0) == 16777215) {
   if ((HEAPU16[$this + 736 + ((HEAPU16[$this + 724 >> 1] | 0) << 1) >> 1] | 0) >>> 0 <= $ch_pos >>> 0) {
    break;
   }
   if ((HEAP32[$fixed_hzs_ >> 2] | 0) == 0) {
    $retval_0 = 1;
    return $retval_0 | 0;
   }
   $arrayidx317 = $this + 196 | 0;
   if ((HEAP32[$arrayidx317 >> 2] | 0) != 16777215) {
    $retval_0 = 1;
    return $retval_0 | 0;
   }
   $sublma_num = $this + 720 | 0;
   if ((HEAP32[$sublma_num >> 2] | 0) != 0) {
    $length366 = $this + 724 | 0;
    $subpos_0103 = 0;
    $conv321104 = 0;
    do {
     $108 = HEAP16[$this + 640 + ($conv321104 << 1) >> 1] | 0;
     $add329 = $conv321104 + 1 | 0;
     $arrayidx332 = $this + 640 + ($add329 << 1) | 0;
     $109 = HEAP16[$arrayidx332 >> 1] | 0;
     if (($108 & 65535) < ($109 & 65535)) {
      $splpos_0100 = $108;
      do {
       $conv334101 = $splpos_0100 & 65535;
       do {
        if ((HEAPU16[$this + 480 + ($conv334101 << 1) >> 1] | 0) >>> 0 <= $ch_pos >>> 0) {
         if ((HEAPU16[$this + 480 + ($conv334101 + 1 << 1) >> 1] | 0) >>> 0 <= $ch_pos >>> 0) {
          break;
         }
         HEAP16[$this + 560 + ($conv334101 << 1) >> 1] = 0;
         HEAP16[$arrayidx332 >> 1] = $splpos_0100;
         HEAP32[$sublma_num >> 2] = $add329;
         HEAP16[$length366 >> 1] = $splpos_0100;
         if ($splpos_0100 << 16 >> 16 != $108 << 16 >> 16) {
          break;
         }
         HEAP32[$sublma_num >> 2] = $conv321104;
        }
       } while (0);
       $splpos_0100 = $splpos_0100 + 1 & 65535;
      } while (($splpos_0100 & 65535) < ($109 & 65535));
     }
     $subpos_0103 = $subpos_0103 + 1 & 65535;
     $conv321104 = $subpos_0103 & 65535;
    } while ($conv321104 >>> 0 < (HEAP32[$sublma_num >> 2] | 0) >>> 0);
   }
   __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) | 0;
   $dmi_c_phrase_ = $this + 728 | 0;
   HEAP8[$dmi_c_phrase_] = 1;
   $length386 = $this + 724 | 0;
   $c_py_pos_0 = 0;
   while (1) {
    if (($c_py_pos_0 & 65535) >= (HEAPU16[$this + 736 + ((HEAPU16[$length386 >> 1] | 0) << 1) >> 1] | 0)) {
     break;
    }
    if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, HEAP8[($c_py_pos_0 & 65535) + ($this + 32) | 0] | 0) | 0) {
     $c_py_pos_0 = $c_py_pos_0 + 1 & 65535;
    } else {
     label = 1112;
     break;
    }
   }
   if ((label | 0) == 1112) {
    ___assert_func(1184, 393, 7224, 1632);
    return 0;
   }
   HEAP8[$dmi_c_phrase_] = 0;
   HEAP32[$this + 112 >> 2] = 1;
   HEAP32[$this + 356 >> 2] = 1;
   HEAP8[$this + 360 | 0] = 0;
   $116 = HEAP16[$length386 >> 1] | 0;
   HEAP32[$fixed_hzs_ >> 2] = $116 & 65535;
   HEAP16[$this + 118 >> 1] = $116;
   HEAP32[$arrayidx317 >> 2] = 16777215;
   $idxprom420 = HEAPU16[$this + 736 + (HEAP32[$fixed_hzs_ >> 2] << 1) >> 1] | 0;
   $120 = HEAP32[$this + 96 >> 2] | 0;
   HEAP32[$120 + ($idxprom420 * 12 | 0) + 8 >> 2] = (HEAP32[$this + 80 >> 2] | 0) + ((HEAPU16[$120 + ($idxprom420 * 12 | 0) >> 1] | 0) << 4);
   $retval_0 = 1;
   return $retval_0 | 0;
  }
 } while (0);
 if ($clear_fixed_this_step) {
  $fixed_ch_pos_0_ph = $cmp6 ? 0 : $ch_pos - 1 | 0;
 } else {
  $fixed_ch_pos_0_ph = $ch_pos;
 }
 $matrix_130 = $this + 96 | 0;
 $50 = HEAP32[$matrix_130 >> 2] | 0;
 $fixed_ch_pos_0 = $fixed_ch_pos_0_ph;
 while (1) {
  $cmp133 = ($fixed_ch_pos_0 | 0) == 0;
  if ((HEAP32[$50 + ($fixed_ch_pos_0 * 12 | 0) + 8 >> 2] | 0) != 0 | $cmp133) {
   break;
  } else {
   $fixed_ch_pos_0 = $fixed_ch_pos_0 - 1 | 0;
  }
 }
 $fixed_lmas_ = $this + 356 | 0;
 HEAP32[$fixed_lmas_ >> 2] = 0;
 HEAP32[$fixed_hzs_ >> 2] = 0;
 do {
  if (!$cmp133) {
   $52 = HEAP32[$fixed_hzs_ >> 2] | 0;
   $conv141114 = HEAPU16[$this + 736 + ($52 << 1) >> 1] | 0;
   if ($conv141114 >>> 0 < $fixed_ch_pos_0 >>> 0) {
    $54 = $52;
    while (1) {
     $inc = $54 + 1 | 0;
     HEAP32[$fixed_hzs_ >> 2] = $inc;
     $conv141 = HEAPU16[$this + 736 + ($inc << 1) >> 1] | 0;
     if ($conv141 >>> 0 < $fixed_ch_pos_0 >>> 0) {
      $54 = $inc;
     } else {
      $conv141_lcssa = $conv141;
      break;
     }
    }
   } else {
    $conv141_lcssa = $conv141114;
   }
   if (($conv141_lcssa | 0) != ($fixed_ch_pos_0 | 0)) {
    ___assert_func(1184, 308, 7224, 3480);
    return 0;
   }
   $56 = HEAP32[$fixed_lmas_ >> 2] | 0;
   $conv157110 = HEAPU16[$this + 116 + ($56 << 1) >> 1] | 0;
   $58 = HEAP32[$fixed_hzs_ >> 2] | 0;
   if ($conv157110 >>> 0 < $58 >>> 0) {
    $59 = $56;
    while (1) {
     $inc162 = $59 + 1 | 0;
     HEAP32[$fixed_lmas_ >> 2] = $inc162;
     $conv157 = HEAPU16[$this + 116 + ($inc162 << 1) >> 1] | 0;
     $61 = HEAP32[$fixed_hzs_ >> 2] | 0;
     if ($conv157 >>> 0 < $61 >>> 0) {
      $59 = $inc162;
     } else {
      $conv157_lcssa = $conv157;
      $_lcssa = $61;
      break;
     }
    }
   } else {
    $conv157_lcssa = $conv157110;
    $_lcssa = $58;
   }
   if (($conv157_lcssa | 0) == ($_lcssa | 0)) {
    break;
   }
   ___assert_func(1184, 312, 7224, 2456);
   return 0;
  }
 } while (0);
 $cmp177 = ($fixed_ch_pos_0 | 0) == ($ch_pos | 0);
 $or_cond85 = $cmp177 & $clear_dmi_this_step;
 do {
  if ($or_cond85) {
   $62 = HEAP32[$matrix_130 >> 2] | 0;
   if ((HEAP16[$62 + ($fixed_ch_pos_0 * 12 | 0) + 6 >> 1] & 32767) == 0) {
    $dict_handles_to_clear174_0 = 0;
    break;
   }
   $dict_handles_to_clear174_0 = (HEAP32[$this + 88 >> 2] | 0) + ((HEAPU16[$62 + ($fixed_ch_pos_0 * 12 | 0) + 2 >> 1] | 0) * 12 | 0) | 0;
  } else {
   $dict_handles_to_clear174_0 = 0;
  }
 } while (0);
 do {
  if ((HEAP32[$pys_decoded_len_ >> 2] | 0) >>> 0 <= $fixed_ch_pos_0 >>> 0 | $clear_dmi_this_step) {
   $dict_handles_to_clear174_1 = $dict_handles_to_clear174_0;
   label = 1086;
  } else {
   $add200 = $fixed_ch_pos_0 + 1 | 0;
   $69 = HEAP32[$matrix_130 >> 2] | 0;
   if ((HEAP16[$69 + ($add200 * 12 | 0) + 6 >> 1] & 32767) == 0) {
    break;
   }
   $dict_handles_to_clear174_1 = (HEAP32[$this + 88 >> 2] | 0) + ((HEAPU16[$69 + ($add200 * 12 | 0) + 2 >> 1] | 0) * 12 | 0) | 0;
   label = 1086;
  }
 } while (0);
 do {
  if ((label | 0) == 1086) {
   if (($dict_handles_to_clear174_1 | 0) == 0) {
    break;
   }
   $75 = HEAP32[$this + 12 >> 2] | 0;
   $conv224 = $fixed_ch_pos_0 & 65535;
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[$75 >> 2] | 0) + 20 >> 2] & 15]($75, $conv224, HEAP16[$dict_handles_to_clear174_1 >> 1] | 0);
   $79 = HEAP32[$this + 16 >> 2] | 0;
   if (($79 | 0) == 0) {
    break;
   }
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[$79 >> 2] | 0) + 20 >> 2] & 15]($79, $conv224, HEAP16[$dict_handles_to_clear174_1 + 2 >> 1] | 0);
  }
 } while (0);
 HEAP32[$pys_decoded_len_ >> 2] = $fixed_ch_pos_0;
 if ($or_cond85) {
  $sub241 = $fixed_ch_pos_0 - 1 | 0;
  $83 = HEAP32[$matrix_130 >> 2] | 0;
  HEAP16[$this + 92 >> 1] = (HEAP16[$83 + ($sub241 * 12 | 0) + 6 >> 1] & 32767) + (HEAP16[$83 + ($sub241 * 12 | 0) + 2 >> 1] | 0) & 65535;
  $90 = (HEAP32[$matrix_130 >> 2] | 0) + ($fixed_ch_pos_0 * 12 | 0) + 6 | 0;
  HEAP16[$90 >> 1] = HEAP16[$90 >> 1] & -32768;
 } else {
  $93 = HEAP32[$matrix_130 >> 2] | 0;
  HEAP16[$this + 92 >> 1] = (HEAP16[$93 + ($fixed_ch_pos_0 * 12 | 0) + 6 >> 1] & 32767) + (HEAP16[$93 + ($fixed_ch_pos_0 * 12 | 0) + 2 >> 1] | 0) & 65535;
 }
 if ($cmp177 & $clear_mtrx_this_step) {
  $sub276 = $fixed_ch_pos_0 - 1 | 0;
  $98 = HEAP32[$matrix_130 >> 2] | 0;
  HEAP16[$this + 84 >> 1] = (HEAP16[$98 + ($sub276 * 12 | 0) + 4 >> 1] | 0) + (HEAP16[$98 + ($sub276 * 12 | 0) >> 1] | 0) & 65535;
  HEAP16[(HEAP32[$matrix_130 >> 2] | 0) + ($fixed_ch_pos_0 * 12 | 0) + 4 >> 1] = 0;
 } else {
  $102 = HEAP32[$matrix_130 >> 2] | 0;
  HEAP16[$this + 84 >> 1] = (HEAP16[$102 + ($fixed_ch_pos_0 * 12 | 0) + 4 >> 1] | 0) + (HEAP16[$102 + ($fixed_ch_pos_0 * 12 | 0) >> 1] | 0) & 65535;
 }
 $conv306105 = $fixed_ch_pos_0 & 65535;
 if ($conv306105 >>> 0 >= $ch_pos >>> 0) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $re_pos_0107 = $fixed_ch_pos_0 & 65535;
 $conv306108 = $conv306105;
 while (1) {
  __ZN10ime_pinyin12MatrixSearch8add_charEc($this, HEAP8[$this + 32 + $conv306108 | 0] | 0) | 0;
  $inc311 = $re_pos_0107 + 1 & 65535;
  $conv306 = $inc311 & 65535;
  if ($conv306 >>> 0 < $ch_pos >>> 0) {
   $re_pos_0107 = $inc311;
   $conv306108 = $conv306;
  } else {
   $retval_0 = 1;
   break;
  }
 }
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch18prepare_candidatesEv($this) {
 $this = $this | 0;
 var $sent_len = 0, $fixed_hzs_ = 0, $sub = 0, $lma_size_max_0 = 0, $call = 0, $2 = 0, $lpi_total_ = 0, $lpi_num_full_match_013 = 0, $pfullsent_112 = 0, $lma_size_011 = 0, $4 = 0, $cmp22 = 0, $call23 = 0, $pfullsent_2 = 0, $lpi_num_full_match_1 = 0, $dec = 0, $lpi_num_full_match_0_lcssa = 0, $7 = 0, $8 = 0, $sub38 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 $sent_len = sp + 24 | 0;
 $fixed_hzs_ = $this + 896 | 0;
 $sub = (HEAP32[$this + 732 >> 2] | 0) - (HEAP32[$fixed_hzs_ >> 2] | 0) | 0;
 $lma_size_max_0 = $sub >>> 0 < 8 ? $sub & 65535 : 8;
 $call = __ZN10ime_pinyin12MatrixSearch14get_candidate0EPtjS1_b($this, sp | 0, 9, $sent_len, 1) | 0;
 $2 = HEAP16[$sent_len >> 1] | 0;
 $lpi_total_ = $this + 12500 | 0;
 HEAP32[$lpi_total_ >> 2] = 0;
 if ($lma_size_max_0 << 16 >> 16 == 0) {
  $lpi_num_full_match_0_lcssa = 0;
  $7 = $this + 900 + ($lpi_num_full_match_0_lcssa << 3) | 0;
  $8 = HEAP32[$lpi_total_ >> 2] | 0;
  $sub38 = $8 - $lpi_num_full_match_0_lcssa | 0;
  __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($7, $sub38, 8, 20);
  STACKTOP = sp;
  return;
 }
 $lma_size_011 = $lma_size_max_0;
 $pfullsent_112 = ($2 & 65535) > 8 ? 0 : $call;
 $lpi_num_full_match_013 = 0;
 while (1) {
  $4 = HEAP32[$lpi_total_ >> 2] | 0;
  $cmp22 = $lma_size_011 << 16 >> 16 == $lma_size_max_0 << 16 >> 16;
  $call23 = __ZN10ime_pinyin12MatrixSearch8get_lpisEPKtjPNS_10LmaPsbItemEjS2_b($this, $this + 816 + (HEAP32[$fixed_hzs_ >> 2] << 1) | 0, $lma_size_011 & 65535, $this + 900 + ($4 << 3) | 0, 1450 - $4 | 0, $pfullsent_112, $cmp22) | 0;
  if (($call23 | 0) == 0) {
   $pfullsent_2 = $pfullsent_112;
  } else {
   HEAP32[$lpi_total_ >> 2] = (HEAP32[$lpi_total_ >> 2] | 0) + $call23;
   $pfullsent_2 = 0;
  }
  if ($cmp22) {
   $lpi_num_full_match_1 = HEAP32[$lpi_total_ >> 2] | 0;
  } else {
   $lpi_num_full_match_1 = $lpi_num_full_match_013;
  }
  $dec = $lma_size_011 - 1 & 65535;
  if ($dec << 16 >> 16 == 0) {
   $lpi_num_full_match_0_lcssa = $lpi_num_full_match_1;
   break;
  } else {
   $lma_size_011 = $dec;
   $pfullsent_112 = $pfullsent_2;
   $lpi_num_full_match_013 = $lpi_num_full_match_1;
  }
 }
 $7 = $this + 900 + ($lpi_num_full_match_0_lcssa << 3) | 0;
 $8 = HEAP32[$lpi_total_ >> 2] | 0;
 $sub38 = $8 - $lpi_num_full_match_0_lcssa | 0;
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($7, $sub38, 8, 20);
 STACKTOP = sp;
 return;
}
function __ZN10ime_pinyin12MatrixSearch16get_spl_start_idEv($this) {
 $this = $this | 0;
 var $lma_id_num_ = 0, $spl_id_num_ = 0, $pys_decoded_len_ = 0, $2 = 0, $matrix_ = 0, $fixed_lmas_ = 0, $fixed_hzs_ = 0, $mtrx_nd_pool_ = 0, $add_ptr = 0, $dmi_pool_ = 0, $dmi_pool_41 = 0, $mtrx_nd_093 = 0, $12 = 0, $15 = 0, $phitmp = 0, $step37 = 0, $conv3491_in = 0, $conv3491 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $pos_087 = 0, $sub83 = 0, $add84 = 0, $43 = 0, $44 = 0, $arrayidx96 = 0, $xor55 = 0, $arrayidx108 = 0, $arrayidx134 = 0, $xor13658 = 0, $arrayidx147 = 0, $65 = 0, $66 = 0, $_lcssa = 0, $pos264_066 = 0, $67 = 0, $68 = 0, $69 = 0, $pos166_078 = 0, $sub181 = 0, $add188 = 0, $70 = 0, $71 = 0, $arrayidx200 = 0, $xor20252 = 0, $arrayidx213 = 0, $arrayidx238 = 0, $xor239 = 0, $arrayidx248 = 0, $92 = 0, $pos264_069 = 0, $pos264_0_in68 = 0, $93 = 0, $arrayidx279 = 0, $94 = 0, $storemerge = 0, $pos264_0 = 0, $98 = 0, $pos311_0 = 0, label = 0;
 $lma_id_num_ = $this + 112 | 0;
 HEAP32[$lma_id_num_ >> 2] = 0;
 HEAP16[$this + 116 >> 1] = 0;
 $spl_id_num_ = $this + 732 | 0;
 HEAP32[$spl_id_num_ >> 2] = 0;
 HEAP16[$this + 736 >> 1] = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  return;
 }
 $pys_decoded_len_ = $this + 72 | 0;
 $2 = HEAP32[$pys_decoded_len_ >> 2] | 0;
 if (($2 | 0) == 0) {
  return;
 }
 $matrix_ = $this + 96 | 0;
 if ((HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ($2 * 12 | 0) + 4 >> 1] | 0) == 0) {
  return;
 }
 $fixed_lmas_ = $this + 356 | 0;
 HEAP32[$lma_id_num_ >> 2] = HEAP32[$fixed_lmas_ >> 2];
 $fixed_hzs_ = $this + 896 | 0;
 HEAP32[$spl_id_num_ >> 2] = HEAP32[$fixed_hzs_ >> 2];
 $mtrx_nd_pool_ = $this + 80 | 0;
 $add_ptr = (HEAP32[$mtrx_nd_pool_ >> 2] | 0) + (HEAPU16[(HEAP32[$matrix_ >> 2] | 0) + ((HEAP32[$pys_decoded_len_ >> 2] | 0) * 12 | 0) >> 1] << 4) | 0;
 L1417 : do {
  if (($add_ptr | 0) != (HEAP32[$mtrx_nd_pool_ >> 2] | 0)) {
   $dmi_pool_ = $this + 88 | 0;
   $dmi_pool_41 = $this + 88 | 0;
   $mtrx_nd_093 = $add_ptr;
   do {
    $12 = HEAP32[$fixed_hzs_ >> 2] | 0;
    if (($12 | 0) != 0) {
     if ((HEAPU16[$mtrx_nd_093 + 14 >> 1] | 0) <= (HEAPU16[$this + 736 + ($12 << 1) >> 1] | 0)) {
      break L1417;
     }
    }
    $15 = HEAP16[$mtrx_nd_093 + 12 >> 1] | 0;
    if ($15 << 16 >> 16 != -1) {
     $phitmp = (HEAPU8[(HEAP32[$dmi_pool_ >> 2] | 0) + (($15 & 65535) * 12 | 0) + 9 | 0] | 0) >>> 1 & 255;
     $step37 = $mtrx_nd_093 + 14 | 0;
     $conv3491_in = $15;
     do {
      $conv3491 = $conv3491_in & 65535;
      HEAP16[$this + 736 + ((HEAP32[$spl_id_num_ >> 2] | 0) + 1 << 1) >> 1] = ((HEAP16[$step37 >> 1] | 0) - $phitmp & 65535) + ((HEAPU8[(HEAP32[$dmi_pool_41 >> 2] | 0) + ($conv3491 * 12 | 0) + 9 | 0] | 0) >>> 1 & 255) & 65535;
      HEAP16[$this + 816 + (HEAP32[$spl_id_num_ >> 2] << 1) >> 1] = HEAP16[(HEAP32[$dmi_pool_41 >> 2] | 0) + ($conv3491 * 12 | 0) + 6 >> 1] | 0;
      HEAP32[$spl_id_num_ >> 2] = (HEAP32[$spl_id_num_ >> 2] | 0) + 1;
      $conv3491_in = HEAP16[(HEAP32[$dmi_pool_41 >> 2] | 0) + ($conv3491 * 12 | 0) + 4 >> 1] | 0;
     } while ($conv3491_in << 16 >> 16 != -1);
    }
    HEAP16[$this + 116 + ((HEAP32[$lma_id_num_ >> 2] | 0) + 1 << 1) >> 1] = HEAP32[$spl_id_num_ >> 2] & 65535;
    HEAP32[$this + 196 + (HEAP32[$lma_id_num_ >> 2] << 2) >> 2] = HEAP32[$mtrx_nd_093 >> 2];
    HEAP32[$lma_id_num_ >> 2] = (HEAP32[$lma_id_num_ >> 2] | 0) + 1;
    $mtrx_nd_093 = HEAP32[$mtrx_nd_093 + 8 >> 2] | 0;
   } while (($mtrx_nd_093 | 0) != (HEAP32[$mtrx_nd_pool_ >> 2] | 0));
  }
 } while (0);
 $39 = HEAP32[$fixed_hzs_ >> 2] | 0;
 $40 = HEAP32[$spl_id_num_ >> 2] | 0;
 if ($39 >>> 0 < (((1 - $39 + $40 | 0) >>> 1) + $39 | 0) >>> 0) {
  $pos_087 = $39;
  $42 = $39;
  $41 = $40;
  while (1) {
   $sub83 = $42 - $pos_087 + $41 | 0;
   $add84 = $pos_087 + 1 | 0;
   if (($sub83 | 0) != ($add84 | 0)) {
    $arrayidx96 = $this + 736 + ($add84 << 1) | 0;
    $xor55 = HEAP16[$arrayidx96 >> 1] ^ HEAP16[$this + 736 + ($sub83 << 1) >> 1];
    HEAP16[$arrayidx96 >> 1] = $xor55;
    $arrayidx108 = $this + 736 + ((HEAP32[$spl_id_num_ >> 2] | 0) - $pos_087 + (HEAP32[$fixed_hzs_ >> 2] | 0) << 1) | 0;
    HEAP16[$arrayidx108 >> 1] = HEAP16[$arrayidx108 >> 1] ^ $xor55;
    HEAP16[$arrayidx96 >> 1] = HEAP16[$arrayidx96 >> 1] ^ HEAP16[$this + 736 + ((HEAP32[$spl_id_num_ >> 2] | 0) - $pos_087 + (HEAP32[$fixed_hzs_ >> 2] | 0) << 1) >> 1];
    $arrayidx134 = $this + 816 + ($pos_087 << 1) | 0;
    $xor13658 = HEAP16[$arrayidx134 >> 1] ^ HEAP16[$this + 816 + ((HEAP32[$spl_id_num_ >> 2] | 0) + ~$pos_087 + (HEAP32[$fixed_hzs_ >> 2] | 0) << 1) >> 1];
    HEAP16[$arrayidx134 >> 1] = $xor13658;
    $arrayidx147 = $this + 816 + ((HEAP32[$spl_id_num_ >> 2] | 0) + ~$pos_087 + (HEAP32[$fixed_hzs_ >> 2] | 0) << 1) | 0;
    HEAP16[$arrayidx147 >> 1] = HEAP16[$arrayidx147 >> 1] ^ $xor13658;
    HEAP16[$arrayidx134 >> 1] = HEAP16[$arrayidx134 >> 1] ^ HEAP16[$this + 816 + ((HEAP32[$spl_id_num_ >> 2] | 0) + ~$pos_087 + (HEAP32[$fixed_hzs_ >> 2] | 0) << 1) >> 1];
   }
   $43 = HEAP32[$fixed_hzs_ >> 2] | 0;
   $44 = HEAP32[$spl_id_num_ >> 2] | 0;
   if ($add84 >>> 0 < (((1 - $43 + $44 | 0) >>> 1) + $43 | 0) >>> 0) {
    $pos_087 = $add84;
    $42 = $43;
    $41 = $44;
   } else {
    break;
   }
  }
 }
 $65 = HEAP32[$fixed_lmas_ >> 2] | 0;
 $66 = HEAP32[$lma_id_num_ >> 2] | 0;
 L1437 : do {
  if ($65 >>> 0 < (((1 - $65 + $66 | 0) >>> 1) + $65 | 0) >>> 0) {
   $pos166_078 = $65;
   $69 = $65;
   $68 = $66;
   while (1) {
    $sub181 = $69 - $pos166_078 + $68 | 0;
    if (($sub181 - 1 | 0) >>> 0 < $pos166_078 >>> 0) {
     break;
    }
    $add188 = $pos166_078 + 1 | 0;
    if ($sub181 >>> 0 > $add188 >>> 0) {
     $arrayidx200 = $this + 116 + ($add188 << 1) | 0;
     $xor20252 = HEAP16[$arrayidx200 >> 1] ^ HEAP16[$this + 116 + ($69 - $pos166_078 + $68 << 1) >> 1];
     HEAP16[$arrayidx200 >> 1] = $xor20252;
     $arrayidx213 = $this + 116 + ((HEAP32[$lma_id_num_ >> 2] | 0) - $pos166_078 + (HEAP32[$fixed_lmas_ >> 2] | 0) << 1) | 0;
     HEAP16[$arrayidx213 >> 1] = HEAP16[$arrayidx213 >> 1] ^ $xor20252;
     HEAP16[$arrayidx200 >> 1] = HEAP16[$arrayidx200 >> 1] ^ HEAP16[$this + 116 + ((HEAP32[$lma_id_num_ >> 2] | 0) - $pos166_078 + (HEAP32[$fixed_lmas_ >> 2] | 0) << 1) >> 1];
     $arrayidx238 = $this + 196 + ($pos166_078 << 2) | 0;
     $xor239 = HEAP32[$arrayidx238 >> 2] ^ HEAP32[$this + 196 + ((HEAP32[$lma_id_num_ >> 2] | 0) + ~$pos166_078 + (HEAP32[$fixed_lmas_ >> 2] | 0) << 2) >> 2];
     HEAP32[$arrayidx238 >> 2] = $xor239;
     $arrayidx248 = $this + 196 + ((HEAP32[$lma_id_num_ >> 2] | 0) + ~$pos166_078 + (HEAP32[$fixed_lmas_ >> 2] | 0) << 2) | 0;
     HEAP32[$arrayidx248 >> 2] = HEAP32[$arrayidx248 >> 2] ^ $xor239;
     HEAP32[$arrayidx238 >> 2] = HEAP32[$arrayidx238 >> 2] ^ HEAP32[$this + 196 + ((HEAP32[$lma_id_num_ >> 2] | 0) + ~$pos166_078 + (HEAP32[$fixed_lmas_ >> 2] | 0) << 2) >> 2];
    }
    $70 = HEAP32[$fixed_lmas_ >> 2] | 0;
    $71 = HEAP32[$lma_id_num_ >> 2] | 0;
    if ($add188 >>> 0 < (((1 - $70 + $71 | 0) >>> 1) + $70 | 0) >>> 0) {
     $pos166_078 = $add188;
     $69 = $70;
     $68 = $71;
    } else {
     $_lcssa = $70;
     break L1437;
    }
   }
   ___assert_func(1184, 1360, 7e3, 2592);
  } else {
   $_lcssa = $65;
  }
 } while (0);
 $pos264_066 = $_lcssa + 1 | 0;
 $67 = HEAP32[$lma_id_num_ >> 2] | 0;
 if ($pos264_066 >>> 0 <= $67 >>> 0) {
  $pos264_0_in68 = $_lcssa;
  $pos264_069 = $pos264_066;
  $92 = $67;
  while (1) {
   $93 = HEAP16[$this + 116 + ($pos264_0_in68 << 1) >> 1] | 0;
   $arrayidx279 = $this + 116 + ($pos264_069 << 1) | 0;
   $94 = HEAP16[$arrayidx279 >> 1] | 0;
   if ($pos264_069 >>> 0 < $92 >>> 0) {
    $storemerge = ($94 + $93 & 65535) - (HEAP16[$this + 116 + ($pos264_0_in68 + 2 << 1) >> 1] | 0) & 65535;
   } else {
    $storemerge = ($94 + $93 & 65535) - (HEAP16[$this + 116 + (HEAP32[$fixed_lmas_ >> 2] << 1) >> 1] | 0) & 65535;
   }
   HEAP16[$arrayidx279 >> 1] = $storemerge;
   $pos264_0 = $pos264_069 + 1 | 0;
   $98 = HEAP32[$lma_id_num_ >> 2] | 0;
   if ($pos264_0 >>> 0 > $98 >>> 0) {
    break;
   } else {
    $pos264_0_in68 = $pos264_069;
    $pos264_069 = $pos264_0;
    $92 = $98;
   }
  }
 }
 HEAP32[$fixed_hzs_ >> 2] = 0;
 $pos311_0 = HEAP32[$spl_id_num_ >> 2] | 0;
 while (1) {
  if (($pos311_0 | 0) == 0) {
   label = 1169;
   break;
  }
  if ((HEAP32[(HEAP32[$matrix_ >> 2] | 0) + ((HEAPU16[$this + 736 + ($pos311_0 << 1) >> 1] | 0) * 12 | 0) + 8 >> 2] | 0) == 0) {
   $pos311_0 = $pos311_0 - 1 | 0;
  } else {
   break;
  }
 }
 if ((label | 0) == 1169) {
  return;
 }
 HEAP32[$fixed_hzs_ >> 2] = $pos311_0;
 return;
}
function __ZN10ime_pinyin12MatrixSearch9delsearchEjbb($this, $pos, $is_pos_in_splid, $clear_fixed_this_step) {
 $this = $this | 0;
 $pos = $pos | 0;
 $is_pos_in_splid = $is_pos_in_splid | 0;
 $clear_fixed_this_step = $clear_fixed_this_step | 0;
 var $pys_decoded_len_ = 0, $2 = 0, $reset_pos_0 = 0, $4 = 0, $fixed_lmas_ = 0, $7 = 0, $sublma_num = 0, $dec = 0, $16 = 0, $arrayidx58 = 0, $conv62 = 0, $sub = 0, $conv69 = 0, $conv84 = 0, $sub85 = 0, $reset_pos_1 = 0, $length94 = 0, $dmi_c_phrase_ = 0, $c_py_pos_0 = 0, $conv110 = 0, $29 = 0, $fixed_hzs_ = 0, $idxprom139 = 0, $33 = 0, $reset_pos_131 = 0, $reset_pos_2 = 0, $35 = 0, $retval_0 = 0, label = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $pys_decoded_len_ = $this + 72 | 0;
 $2 = HEAP32[$pys_decoded_len_ >> 2] | 0;
 if ($2 >>> 0 <= $pos >>> 0) {
  __ZN10ime_pinyin12MatrixSearch10del_in_pysEjj($this, $pos, 1);
  $reset_pos_0 = HEAP32[$pys_decoded_len_ >> 2] | 0;
  while (1) {
   $4 = HEAP8[$this + 32 + $reset_pos_0 | 0] | 0;
   if ($4 << 24 >> 24 == 0) {
    break;
   }
   if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, $4) | 0) {
    $reset_pos_0 = $reset_pos_0 + 1 | 0;
   } else {
    label = 1175;
    break;
   }
  }
  if ((label | 0) == 1175) {
   HEAP32[$pys_decoded_len_ >> 2] = $reset_pos_0;
  }
  __ZN10ime_pinyin12MatrixSearch16get_spl_start_idEv($this);
  __ZN10ime_pinyin12MatrixSearch18prepare_candidatesEv($this);
  $retval_0 = HEAP32[$pys_decoded_len_ >> 2] | 0;
  return $retval_0 | 0;
 }
 do {
  if ($is_pos_in_splid) {
   if ((HEAP32[$this + 732 >> 2] | 0) >>> 0 <= $pos >>> 0) {
    $retval_0 = $2;
    return $retval_0 | 0;
   }
   $arrayidx58 = $this + 736 + ($pos + 1 << 1) | 0;
   $conv62 = HEAPU16[$this + 736 + ($pos << 1) >> 1] | 0;
   $sub = (HEAPU16[$arrayidx58 >> 1] | 0) - $conv62 | 0;
   __ZN10ime_pinyin12MatrixSearch10del_in_pysEjj($this, $conv62, $sub);
   $conv69 = HEAPU16[$this + 116 + (HEAP32[$this + 356 >> 2] << 1) >> 1] | 0;
   if ($conv69 >>> 0 <= $pos >>> 0) {
    $reset_pos_131 = (HEAPU16[$arrayidx58 >> 1] | 0) - $sub | 0;
    label = 1198;
    break;
   }
   $conv84 = HEAPU16[$this + 736 + ($conv69 << 1) >> 1] | 0;
   $sub85 = $conv84 - $sub | 0;
   if (($conv84 | 0) == ($sub | 0)) {
    $reset_pos_1 = $sub85;
    label = 1189;
    break;
   }
   __ZN10ime_pinyin12MatrixSearch16merge_fixed_lmasEj($this, $pos);
   $reset_pos_1 = $sub85;
   label = 1189;
  } else {
   $fixed_lmas_ = $this + 356 | 0;
   $7 = HEAP32[$fixed_lmas_ >> 2] | 0;
   do {
    if (($7 | 0) != 0) {
     if ((HEAPU16[$this + 736 + (HEAPU16[$this + 116 + ($7 << 1) >> 1] << 1) >> 1] | 0) >>> 0 <= $pos >>> 0) {
      break;
     }
     $retval_0 = HEAP32[$pys_decoded_len_ >> 2] | 0;
     return $retval_0 | 0;
    }
   } while (0);
   __ZN10ime_pinyin12MatrixSearch10del_in_pysEjj($this, $pos, 1);
   if ((HEAPU16[$this + 736 + (HEAPU16[$this + 116 + (HEAP32[$fixed_lmas_ >> 2] << 1) >> 1] << 1) >> 1] | 0) != ($pos | 0)) {
    $reset_pos_131 = $pos;
    label = 1198;
    break;
   }
   if ((HEAP32[$this + 196 >> 2] | 0) != 16777215 | $clear_fixed_this_step ^ 1) {
    $reset_pos_131 = $pos;
    label = 1198;
    break;
   }
   $sublma_num = $this + 720 | 0;
   $dec = (HEAP32[$sublma_num >> 2] | 0) - 1 | 0;
   HEAP32[$sublma_num >> 2] = $dec;
   $16 = HEAP16[$this + 640 + ($dec << 1) >> 1] | 0;
   HEAP16[$this + 724 >> 1] = $16;
   $reset_pos_1 = HEAPU16[$this + 736 + (($16 & 65535) << 1) >> 1] | 0;
   label = 1189;
  }
 } while (0);
 do {
  if ((label | 0) == 1189) {
   if (($reset_pos_1 | 0) == 0) {
    $reset_pos_131 = 0;
    label = 1198;
    break;
   }
   $length94 = $this + 724 | 0;
   if ((HEAP16[$length94 >> 1] | 0) == 0) {
    ___assert_func(1184, 552, 6584, 1360);
    return 0;
   }
   if (($reset_pos_1 | 0) != (HEAPU16[$this + 480 + (HEAPU16[$this + 640 + (HEAP32[$this + 720 >> 2] << 1) >> 1] << 1) >> 1] | 0)) {
    ___assert_func(1184, 552, 6584, 1360);
    return 0;
   }
   __ZN10ime_pinyin12MatrixSearch13reset_search0Ev($this) | 0;
   $dmi_c_phrase_ = $this + 728 | 0;
   HEAP8[$dmi_c_phrase_] = 1;
   $c_py_pos_0 = 0;
   while (1) {
    $conv110 = $c_py_pos_0 & 65535;
    if ($conv110 >>> 0 >= $reset_pos_1 >>> 0) {
     label = 1197;
     break;
    }
    if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, HEAP8[$this + 32 + $conv110 | 0] | 0) | 0) {
     $c_py_pos_0 = $c_py_pos_0 + 1 & 65535;
    } else {
     label = 1196;
     break;
    }
   }
   if ((label | 0) == 1196) {
    ___assert_func(1184, 563, 6584, 1632);
    return 0;
   } else if ((label | 0) == 1197) {
    HEAP8[$dmi_c_phrase_] = 0;
    HEAP32[$this + 112 >> 2] = 1;
    HEAP32[$this + 356 >> 2] = 1;
    HEAP8[$this + 360 | 0] = 0;
    $29 = HEAP16[$length94 >> 1] | 0;
    $fixed_hzs_ = $this + 896 | 0;
    HEAP32[$fixed_hzs_ >> 2] = $29 & 65535;
    HEAP16[$this + 118 >> 1] = $29;
    HEAP32[$this + 196 >> 2] = 16777215;
    $idxprom139 = HEAPU16[$this + 736 + (HEAP32[$fixed_hzs_ >> 2] << 1) >> 1] | 0;
    $33 = HEAP32[$this + 96 >> 2] | 0;
    HEAP32[$33 + ($idxprom139 * 12 | 0) + 8 >> 2] = (HEAP32[$this + 80 >> 2] | 0) + (HEAPU16[$33 + ($idxprom139 * 12 | 0) >> 1] << 4);
    $reset_pos_2 = $reset_pos_1;
    break;
   }
  }
 } while (0);
 if ((label | 0) == 1198) {
  __ZN10ime_pinyin12MatrixSearch12reset_searchEjbbb($this, $reset_pos_131, $clear_fixed_this_step, 0, 0) | 0;
  $reset_pos_2 = $reset_pos_131;
 }
 while (1) {
  $35 = HEAP8[$this + 32 + $reset_pos_2 | 0] | 0;
  if ($35 << 24 >> 24 == 0) {
   break;
  }
  if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, $35) | 0) {
   $reset_pos_2 = $reset_pos_2 + 1 | 0;
  } else {
   label = 1201;
   break;
  }
 }
 if ((label | 0) == 1201) {
  HEAP32[$pys_decoded_len_ >> 2] = $reset_pos_2;
 }
 __ZN10ime_pinyin12MatrixSearch16get_spl_start_idEv($this);
 __ZN10ime_pinyin12MatrixSearch18prepare_candidatesEv($this);
 $retval_0 = HEAP32[$pys_decoded_len_ >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch17get_candidate_numEv($this) {
 $this = $this | 0;
 var $2 = 0, $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $2 = HEAP32[$this + 72 >> 2] | 0;
 if (($2 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP16[(HEAP32[$this + 96 >> 2] | 0) + ($2 * 12 | 0) + 4 >> 1] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = (HEAP32[$this + 12500 >> 2] | 0) + 1 | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch13get_candidateEjPtj($this, $cand_id, $cand_str, $max_len) {
 $this = $this | 0;
 $cand_id = $cand_id | 0;
 $cand_str = $cand_str | 0;
 $max_len = $max_len | 0;
 var $s = 0, $dec = 0, $5 = 0, $conv = 0, $s_len_0 = 0, $conv24 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 24 | 0;
 $s = sp | 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 72 >> 2] | 0) == 0 | ($cand_str | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if (($cand_id | 0) == 0) {
  $retval_0 = __ZN10ime_pinyin12MatrixSearch14get_candidate0EPtjS1_b($this, $cand_str, $max_len, 0, 0) | 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 12500 >> 2] | 0) == 0) {
  $retval_0 = __ZN10ime_pinyin12MatrixSearch14get_candidate0EPtjS1_b($this, $cand_str, $max_len, 0, 0) | 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $dec = $cand_id - 1 | 0;
 $5 = HEAP32[$this + 900 + ($dec << 3) >> 2] | 0;
 $conv = $5 >>> 24 & 15;
 if (($conv & 65535) > 1) {
  $s_len_0 = __ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, $5 & 16777215, $s | 0, 9) | 0;
 } else {
  HEAP16[$s >> 1] = HEAP16[$this + 900 + ($dec << 3) + 6 >> 1] | 0;
  HEAP16[$s + 2 >> 1] = 0;
  $s_len_0 = $conv;
 }
 $conv24 = $s_len_0 & 65535;
 if (!($s_len_0 << 16 >> 16 != 0 & $conv24 >>> 0 < $max_len >>> 0)) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _utf16_strncpy($cand_str, $s | 0, $conv24) | 0;
 HEAP16[$cand_str + ($conv24 << 1) >> 1] = 0;
 $retval_0 = $cand_str;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch14get_candidate0EPtjS1_b($this, $cand_str, $max_len, $retstr_len, $only_unfixed) {
 $this = $this | 0;
 $cand_str = $cand_str | 0;
 $max_len = $max_len | 0;
 $retstr_len = $retstr_len | 0;
 $only_unfixed = $only_unfixed | 0;
 var $idxs = 0, $str = 0, $0 = 0, $1 = 0, $add_ptr = 0, $id_num_0_lcssa = 0, $arraydecay = 0, $fixed_hzs_ = 0, $fixed_hzs_33 = 0, $mtrx_nd_035 = 0, $id_num_034 = 0, $inc = 0, $6 = 0, $id_num_1 = 0, $ret_pos_0 = 0, $dec = 0, $7 = 0, $call = 0, $conv15 = 0, $sub23 = 0, $add_ptr29 = 0, $9 = 0, $add_ptr38 = 0, $ret_pos_1 = 0, $cmp57 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 184 | 0;
 $idxs = sp | 0;
 $str = sp + 160 | 0;
 $0 = HEAP32[$this + 72 >> 2] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $1 = HEAP32[$this + 96 >> 2] | 0;
 if ((HEAP16[$1 + ($0 * 12 | 0) + 4 >> 1] | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $add_ptr = (HEAP32[$this + 80 >> 2] | 0) + (HEAPU16[$1 + ($0 * 12 | 0) >> 1] << 4) | 0;
 if (($add_ptr | 0) == 0) {
  $id_num_0_lcssa = 0;
 } else {
  $id_num_034 = 0;
  $mtrx_nd_035 = $add_ptr;
  while (1) {
   HEAP32[$idxs + ($id_num_034 << 2) >> 2] = HEAP32[$mtrx_nd_035 >> 2];
   $inc = $id_num_034 + 1 | 0;
   $6 = HEAP32[$mtrx_nd_035 + 8 >> 2] | 0;
   if (($6 | 0) == 0) {
    $id_num_0_lcssa = $inc;
    break;
   } else {
    $id_num_034 = $inc;
    $mtrx_nd_035 = $6;
   }
  }
 }
 $arraydecay = $str | 0;
 $fixed_hzs_ = $this + 896 | 0;
 $fixed_hzs_33 = $this + 896 | 0;
 $ret_pos_0 = 0;
 $id_num_1 = $id_num_0_lcssa;
 L1561 : while (1) {
  $dec = $id_num_1 - 1 | 0;
  $7 = HEAP32[$idxs + ($dec << 2) >> 2] | 0;
  if (($7 | 0) == 0) {
   $ret_pos_1 = $ret_pos_0;
  } else {
   $call = __ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, $7, $arraydecay, 9) | 0;
   $conv15 = $call & 65535;
   if ($call << 16 >> 16 == 0) {
    $retval_0 = 0;
    label = 1263;
    break;
   }
   $sub23 = $max_len - $ret_pos_0 | 0;
   do {
    if ($only_unfixed) {
     if (((HEAP32[$fixed_hzs_ >> 2] | 0) + $sub23 | 0) >>> 0 <= $conv15 >>> 0) {
      $retval_0 = 0;
      label = 1264;
      break L1561;
     }
     $9 = HEAP32[$fixed_hzs_33 >> 2] | 0;
     if ($ret_pos_0 >>> 0 < $9 >>> 0) {
      break;
     }
     $add_ptr38 = $cand_str + ($ret_pos_0 - $9 << 1) | 0;
     _utf16_strncpy($add_ptr38, $arraydecay, $conv15) | 0;
    } else {
     if ($sub23 >>> 0 <= $conv15 >>> 0) {
      $retval_0 = 0;
      label = 1265;
      break L1561;
     }
     $add_ptr29 = $cand_str + ($ret_pos_0 << 1) | 0;
     _utf16_strncpy($add_ptr29, $arraydecay, $conv15) | 0;
    }
   } while (0);
   $ret_pos_1 = $conv15 + $ret_pos_0 | 0;
  }
  if (($dec | 0) == 0) {
   label = 1253;
   break;
  } else {
   $ret_pos_0 = $ret_pos_1;
   $id_num_1 = $dec;
  }
 }
 if ((label | 0) == 1263) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 1264) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 1265) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 1253) {
  $cmp57 = ($retstr_len | 0) != 0;
  if ($only_unfixed) {
   if ($cmp57) {
    HEAP16[$retstr_len >> 1] = $ret_pos_1 - (HEAP32[$this + 896 >> 2] | 0) & 65535;
   }
   HEAP16[$cand_str + ($ret_pos_1 - (HEAP32[$this + 896 >> 2] | 0) << 1) >> 1] = 0;
   $retval_0 = $cand_str;
   STACKTOP = sp;
   return $retval_0 | 0;
  } else {
   if ($cmp57) {
    HEAP16[$retstr_len >> 1] = $ret_pos_1 & 65535;
   }
   HEAP16[$cand_str + ($ret_pos_1 << 1) >> 1] = 0;
   $retval_0 = $cand_str;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 }
 return 0;
}
function __ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, $id_lemma, $str_buf, $str_max) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $str_buf = $str_buf | 0;
 $str_max = $str_max | 0;
 var $0 = 0, $3 = 0, $7 = 0, $sub = 0, $str_len_0 = 0, $arraydecay = 0, $conv28 = 0, $retval_0 = 0;
 if (__ZN10ime_pinyin15is_system_lemmaEj($id_lemma) | 0) {
  $0 = HEAP32[$this + 12 >> 2] | 0;
  $retval_0 = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$0 >> 2] | 0) + 32 >> 2] & 31]($0, $id_lemma, $str_buf, $str_max) | 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin13is_user_lemmaEj($id_lemma) | 0)) {
  if (($str_max & 65535) < 2 | (__ZN10ime_pinyin18is_composing_lemmaEj($id_lemma) | 0) ^ 1) {
   $retval_0 = 0;
   return $retval_0 | 0;
  }
  $7 = HEAP16[$this + 640 + (HEAP32[$this + 720 >> 2] << 1) >> 1] | 0;
  $sub = ($str_max & 65535) - 1 | 0;
  $str_len_0 = ($7 & 65535 | 0) > ($sub | 0) ? $sub & 65535 : $7;
  $arraydecay = $this + 560 | 0;
  $conv28 = $str_len_0 & 65535;
  _utf16_strncpy($str_buf, $arraydecay, $conv28) | 0;
  HEAP16[$str_buf + ($conv28 << 1) >> 1] = 0;
  $retval_0 = $str_len_0;
  return $retval_0 | 0;
 }
 $3 = HEAP32[$this + 16 >> 2] | 0;
 if (($3 | 0) == 0) {
  HEAP16[$str_buf >> 1] = 0;
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $retval_0 = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$3 >> 2] | 0) + 32 >> 2] & 31]($3, $id_lemma, $str_buf, $str_max) | 0;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12MatrixSearch16update_dict_freqEv($this) {
 $this = $this | 0;
 var $0 = 0, $call = 0, $3 = 0;
 $0 = HEAP32[$this + 16 >> 2] | 0;
 if (($0 | 0) == 0) {
  return;
 }
 $call = FUNCTION_TABLE_ii[HEAP32[(HEAP32[$0 >> 2] | 0) + 68 >> 2] & 31]($0) | 0;
 $3 = HEAP32[$this + 12 >> 2] | 0;
 FUNCTION_TABLE_vii[HEAP32[(HEAP32[$3 >> 2] | 0) + 72 >> 2] & 15]($3, $call);
 return;
}
function __ZN10ime_pinyin12MatrixSearch16get_lemma_splidsEjPttb($this, $id_lemma, $splids, $splids_max, $arg_valid) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $splids = $splids | 0;
 $splids_max = $splids_max | 0;
 $arg_valid = $arg_valid | 0;
 var $spl_trie_ = 0, $splid_num_0 = 0, $splid_num_1 = 0, $2 = 0, $5 = 0, $length = 0, $spl_trie_45 = 0, $pos_0 = 0, $conv34 = 0, $10 = 0, $retval_0 = 0, label = 0;
 do {
  if ($arg_valid) {
   $spl_trie_ = $this + 4 | 0;
   $splid_num_0 = 0;
   while (1) {
    if (($splid_num_0 & 65535) >= ($splids_max & 65535)) {
     break;
    }
    if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$splids + (($splid_num_0 & 65535) << 1) >> 1] | 0) | 0) {
     break;
    } else {
     $splid_num_0 = $splid_num_0 + 1 & 65535;
    }
   }
   if ($splid_num_0 << 16 >> 16 == $splids_max << 16 >> 16) {
    $retval_0 = $splid_num_0;
   } else {
    $splid_num_1 = $splid_num_0;
    break;
   }
   return $retval_0 | 0;
  } else {
   $splid_num_1 = 0;
  }
 } while (0);
 if (__ZN10ime_pinyin15is_system_lemmaEj($id_lemma) | 0) {
  $2 = HEAP32[$this + 12 >> 2] | 0;
  $retval_0 = FUNCTION_TABLE_iiiiii[HEAP32[(HEAP32[$2 >> 2] | 0) + 36 >> 2] & 15]($2, $id_lemma, $splids, $splids_max, $arg_valid) | 0;
  return $retval_0 | 0;
 }
 if (__ZN10ime_pinyin13is_user_lemmaEj($id_lemma) | 0) {
  $5 = HEAP32[$this + 16 >> 2] | 0;
  if (($5 | 0) == 0) {
   $retval_0 = 0;
   return $retval_0 | 0;
  }
  $retval_0 = FUNCTION_TABLE_iiiiii[HEAP32[(HEAP32[$5 >> 2] | 0) + 36 >> 2] & 15]($5, $id_lemma, $splids, $splids_max, $arg_valid) | 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin18is_composing_lemmaEj($id_lemma) | 0)) {
  $retval_0 = $splid_num_1;
  return $retval_0 | 0;
 }
 $length = $this + 724 | 0;
 if ((HEAPU16[$length >> 1] | 0) > ($splids_max & 65535)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spl_trie_45 = $this + 4 | 0;
 $pos_0 = 0;
 while (1) {
  $conv34 = $pos_0 & 65535;
  if (($pos_0 & 65535) >= (HEAPU16[$length >> 1] | 0)) {
   $retval_0 = $splid_num_1;
   label = 1310;
   break;
  }
  $10 = HEAP16[$this + 400 + ($conv34 << 1) >> 1] | 0;
  HEAP16[$splids + ($conv34 << 1) >> 1] = $10;
  if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$spl_trie_45 >> 2] | 0, $10) | 0) {
   $retval_0 = 0;
   label = 1305;
   break;
  } else {
   $pos_0 = $pos_0 + 1 & 65535;
  }
 }
 if ((label | 0) == 1310) {
  return $retval_0 | 0;
 } else if ((label | 0) == 1305) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12MatrixSearch15debug_print_dmiEtt($this, $dmi_pos, $nest_level) {
 $this = $this | 0;
 $dmi_pos = $dmi_pos | 0;
 $nest_level = $nest_level | 0;
 var $conv = 0, $1 = 0, $cmp5 = 0, $2 = 0, $conv22 = 0, $call24 = 0, $spl_id = 0, $call25 = 0, $conv27 = 0, sp = 0;
 sp = STACKTOP;
 $conv = $dmi_pos & 65535;
 if ((HEAPU16[$this + 92 >> 1] | 0) <= ($dmi_pos & 65535)) {
  STACKTOP = sp;
  return;
 }
 $1 = HEAP32[$this + 88 >> 2] | 0;
 $cmp5 = $nest_level << 16 >> 16 == 1;
 if ($cmp5) {
  _printf(768, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $conv, tempInt) | 0) | 0;
 }
 $2 = $1 + ($conv * 12 | 0) + 8 | 0;
 if ((HEAP8[$2] & 126) > 1) {
  __ZN10ime_pinyin12MatrixSearch15debug_print_dmiEtt($this, HEAP16[$1 + ($conv * 12 | 0) + 4 >> 1] | 0, $nest_level + 1 & 65535);
 }
 _printf(616, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = HEAP8[$2] & 127, tempInt) | 0) | 0;
 $conv22 = HEAPU16[$1 + ($conv * 12 | 0) + 2 >> 1] | 0;
 _printf(440, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = HEAPU16[$1 + ($conv * 12 | 0) >> 1] | 0, HEAP32[tempInt + 8 >> 2] = $conv22, tempInt) | 0) | 0;
 $call24 = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $spl_id = $1 + ($conv * 12 | 0) + 6 | 0;
 $call25 = __ZN10ime_pinyin12SpellingTrie16get_spelling_strEt($call24, HEAP16[$spl_id >> 1] | 0) | 0;
 $conv27 = HEAPU16[$spl_id >> 1] | 0;
 _printf(4288, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $call25, HEAP32[tempInt + 8 >> 2] = $conv27, tempInt) | 0) | 0;
 _printf(4064, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = (HEAPU8[$1 + ($conv * 12 | 0) + 9 | 0] | 0) >>> 1 & 255, tempInt) | 0) | 0;
 if (!$cmp5) {
  STACKTOP = sp;
  return;
 }
 _printf(3864, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $conv, tempInt) | 0) | 0;
 STACKTOP = sp;
 return;
}
function __ZN10ime_pinyin12MatrixSearch25try_add_cand0_to_userdictEv($this) {
 $this = $this | 0;
 var $call = 0, $fixed_lmas_ = 0, $conv27 = 0, $modified_0_off026 = 0, $pos_025 = 0, $lma_id_from_024 = 0, $cmp9_not = 0, $lma_id_from_1 = 0, $modified_1_off0 = 0, $_modified_1_off0 = 0, $inc = 0, $conv = 0, $conv_lcssa = 0, $modified_0_off0_lcssa = 0, $pos_0_lcssa = 0, $lma_id_from_0_lcssa = 0;
 $call = __ZN10ime_pinyin12MatrixSearch17get_candidate_numEv($this) | 0;
 if (!((HEAP32[$this + 896 >> 2] | 0) != 0 & ($call | 0) == 1)) {
  return 1;
 }
 $fixed_lmas_ = $this + 356 | 0;
 if ((HEAP32[$fixed_lmas_ >> 2] | 0) == 0) {
  $lma_id_from_0_lcssa = 0;
  $pos_0_lcssa = 0;
  $modified_0_off0_lcssa = 1;
  $conv_lcssa = 0;
 } else {
  $lma_id_from_024 = 0;
  $pos_025 = 0;
  $modified_0_off026 = 0;
  $conv27 = 0;
  while (1) {
   $cmp9_not = ((HEAPU16[$this + 116 + ($conv27 + 1 << 1) >> 1] | 0) - (HEAPU16[$this + 116 + (($lma_id_from_024 & 65535) << 1) >> 1] | 0) | 0) < 9;
   if ($cmp9_not | $modified_0_off026 ^ 1) {
    $modified_1_off0 = $cmp9_not & $modified_0_off026;
    $lma_id_from_1 = $cmp9_not ? $lma_id_from_024 : $pos_025;
   } else {
    __ZN10ime_pinyin12MatrixSearch19add_lma_to_userdictEttf($this, $lma_id_from_024, $pos_025, 0.0) | 0;
    $modified_1_off0 = 0;
    $lma_id_from_1 = $pos_025;
   }
   $_modified_1_off0 = (HEAP8[$this + 360 + $conv27 | 0] | 0) == 0 | $modified_1_off0;
   $inc = $pos_025 + 1 & 65535;
   $conv = $inc & 65535;
   if ($conv >>> 0 < (HEAP32[$fixed_lmas_ >> 2] | 0) >>> 0) {
    $lma_id_from_024 = $lma_id_from_1;
    $pos_025 = $inc;
    $modified_0_off026 = $_modified_1_off0;
    $conv27 = $conv;
   } else {
    break;
   }
  }
  $lma_id_from_0_lcssa = $lma_id_from_1;
  $pos_0_lcssa = $inc;
  $modified_0_off0_lcssa = $_modified_1_off0 ^ 1;
  $conv_lcssa = $conv;
 }
 if (((HEAPU16[$this + 116 + ($conv_lcssa << 1) >> 1] | 0) - (HEAPU16[$this + 116 + (($lma_id_from_0_lcssa & 65535) << 1) >> 1] | 0) | 0) < 2 | $modified_0_off0_lcssa) {
  return 1;
 }
 __ZN10ime_pinyin12MatrixSearch19add_lma_to_userdictEttf($this, $lma_id_from_0_lcssa, $pos_0_lcssa, 0.0) | 0;
 return 1;
}
function __ZN10ime_pinyin12MatrixSearch16merge_fixed_lmasEj($this, $del_spl_pos) {
 $this = $this | 0;
 $del_spl_pos = $del_spl_pos | 0;
 var $fixed_lmas_ = 0, $spl_id_num_ = 0, $sub = 0, $spl_start_ = 0, $sub549 = 0, $pos_073 = 0, $add9 = 0, $8 = 0, $9 = 0, $mul = 0, $11 = 0, $12 = 0, $mul32 = 0, $sublma_num137 = 0, $bp_0 = 0, $sublma_num45 = 0, $conv4964 = 0, $conv54 = 0, $add56 = 0, $arrayidx88 = 0, $conv4968 = 0, $phrase_len_067 = 0, $pos47_066 = 0, $arrayidx53 = 0, $19 = 0, $arrayidx60 = 0, $call = 0, $add112 = 0, $inc115 = 0, $conv49 = 0, $phrase_len_0_lcssa = 0, $conv13571 = 0, $pos133_070 = 0, $arrayidx143 = 0, $31 = 0, $phrase_len_1 = 0, $sublma_num180 = 0, $add189 = 0, $conv17861 = 0, $pos176_060 = 0, $length197 = 0, $conv20353 = 0, $pos201_052 = 0, $del_a_sub_0_off051 = 0, $arrayidx212 = 0, $42 = 0, $43 = 0, label = 0;
 $fixed_lmas_ = $this + 356 | 0;
 if ((HEAP32[$fixed_lmas_ >> 2] | 0) == 0) {
  return;
 }
 $spl_id_num_ = $this + 732 | 0;
 $sub = (HEAP32[$spl_id_num_ >> 2] | 0) - 1 | 0;
 HEAP32[$spl_id_num_ >> 2] = $sub;
 $spl_start_ = $this + 736 | 0;
 L1678 : do {
  if ($sub >>> 0 >= $del_spl_pos >>> 0) {
   $sub549 = (HEAP16[$this + 736 + ($del_spl_pos << 1) >> 1] | 0) - (HEAP16[$this + 736 + ($del_spl_pos + 1 << 1) >> 1] | 0) & 65535;
   $pos_073 = $del_spl_pos;
   while (1) {
    $add9 = $pos_073 + 1 | 0;
    HEAP16[$this + 736 + ($pos_073 << 1) >> 1] = $sub549 + (HEAP16[$this + 736 + ($add9 << 1) >> 1] | 0) & 65535;
    if (($pos_073 | 0) == (HEAP32[$spl_id_num_ >> 2] | 0)) {
     break L1678;
    }
    HEAP16[$this + 816 + ($pos_073 << 1) >> 1] = HEAP16[$this + 816 + ($add9 << 1) >> 1] | 0;
    if ($add9 >>> 0 > (HEAP32[$spl_id_num_ >> 2] | 0) >>> 0) {
     break;
    } else {
     $pos_073 = $add9;
    }
   }
  }
 } while (0);
 $8 = $this + 400 | 0;
 $9 = $this + 816 | 0;
 $mul = HEAP32[$spl_id_num_ >> 2] << 1;
 _memcpy($8 | 0, $9 | 0, $mul) | 0;
 $11 = $this + 480 | 0;
 $12 = $spl_start_;
 $mul32 = (HEAP32[$spl_id_num_ >> 2] << 1) + 2 | 0;
 _memcpy($11 | 0, $12 | 0, $mul32) | 0;
 do {
  if ((HEAP32[$fixed_lmas_ >> 2] | 0) >>> 0 > 1) {
   label = 1342;
  } else {
   if ((HEAP32[$this + 196 >> 2] | 0) != 16777215) {
    label = 1342;
    break;
   }
   $sublma_num137 = $this + 720 | 0;
   $pos133_070 = 0;
   $conv13571 = 0;
   do {
    $arrayidx143 = $this + 640 + ($conv13571 << 1) | 0;
    $31 = HEAP16[$arrayidx143 >> 1] | 0;
    if (($31 & 65535) >>> 0 > $del_spl_pos >>> 0) {
     HEAP16[$arrayidx143 >> 1] = $31 - 1 & 65535;
    }
    $pos133_070 = $pos133_070 + 1 & 65535;
    $conv13571 = $pos133_070 & 65535;
   } while ($conv13571 >>> 0 <= (HEAP32[$sublma_num137 >> 2] | 0) >>> 0);
   $phrase_len_1 = HEAP16[$this + 724 >> 1] | 0;
  }
 } while (0);
 do {
  if ((label | 0) == 1342) {
   if ((HEAP32[$this + 196 >> 2] | 0) == 16777215) {
    $bp_0 = 1;
   } else {
    HEAP32[$this + 720 >> 2] = 0;
    $bp_0 = 0;
   }
   $sublma_num45 = $this + 720 | 0;
   $conv4964 = $bp_0 & 65535;
   L1698 : do {
    if ($conv4964 >>> 0 > (HEAP32[$fixed_lmas_ >> 2] | 0) >>> 0) {
     $phrase_len_0_lcssa = 0;
    } else {
     $conv54 = HEAP32[$sublma_num45 >> 2] & 65535;
     $add56 = $conv54 - ($bp_0 & 65535) | 0;
     $arrayidx88 = $this + 640 + ($conv54 << 1) | 0;
     $pos47_066 = $bp_0;
     $phrase_len_067 = 0;
     $conv4968 = $conv4964;
     while (1) {
      $arrayidx53 = $this + 116 + ($conv4968 << 1) | 0;
      $19 = HEAP16[$arrayidx53 >> 1] | 0;
      $arrayidx60 = $this + 640 + ($add56 + $conv4968 << 1) | 0;
      HEAP16[$arrayidx60 >> 1] = $19;
      if ((HEAPU16[$arrayidx53 >> 1] | 0) >>> 0 > $del_spl_pos >>> 0) {
       HEAP16[$arrayidx60 >> 1] = $19 - 1 & 65535;
      }
      if (($conv4968 | 0) == (HEAP32[$fixed_lmas_ >> 2] | 0)) {
       $phrase_len_0_lcssa = $phrase_len_067;
       break L1698;
      }
      $call = __ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, HEAP32[$this + 196 + ($conv4968 << 2) >> 2] | 0, $this + 560 + ((HEAPU16[$arrayidx88 >> 1] | 0) + ($phrase_len_067 & 65535) << 1) | 0, 40 - $phrase_len_067 & 65535) | 0;
      if (($call & 65535 | 0) != ((HEAPU16[$this + 116 + ($conv4968 + 1 << 1) >> 1] | 0) - (HEAPU16[$arrayidx53 >> 1] | 0) | 0)) {
       break;
      }
      $add112 = $call + $phrase_len_067 & 65535;
      $inc115 = $pos47_066 + 1 & 65535;
      $conv49 = $inc115 & 65535;
      if ($conv49 >>> 0 > (HEAP32[$fixed_lmas_ >> 2] | 0) >>> 0) {
       $phrase_len_0_lcssa = $add112;
       break L1698;
      } else {
       $pos47_066 = $inc115;
       $phrase_len_067 = $add112;
       $conv4968 = $conv49;
      }
     }
     ___assert_func(1184, 1245, 6944, 2984);
    }
   } while (0);
   if ($phrase_len_0_lcssa << 16 >> 16 == (HEAP16[$this + 116 + (HEAP32[$fixed_lmas_ >> 2] << 1) >> 1] | 0)) {
    HEAP16[$this + 724 >> 1] = $phrase_len_0_lcssa;
    HEAP32[$sublma_num45 >> 2] = (HEAP32[$fixed_lmas_ >> 2] | 0) - ($bp_0 & 65535) + (HEAP32[$sublma_num45 >> 2] | 0);
    $phrase_len_1 = $phrase_len_0_lcssa;
    break;
   } else {
    ___assert_func(1184, 1248, 6944, 2848);
   }
  }
 } while (0);
 if (($phrase_len_1 << 16 >> 16 | 0) == 0) {
  ___assert_func(1184, 1260, 6944, 2736);
 } else if (($phrase_len_1 << 16 >> 16 | 0) == 1) {
  HEAP32[$fixed_lmas_ >> 2] = 0;
  return;
 } else {
  $sublma_num180 = $this + 720 | 0;
  if ((HEAPU16[$this + 640 + (HEAP32[$sublma_num180 >> 2] << 1) >> 1] | 0) != ($del_spl_pos | 0)) {
   $add189 = $del_spl_pos + 1 | 0;
   $pos176_060 = 0;
   $conv17861 = 0;
   do {
    HEAP16[$this + 560 + ($conv17861 + $del_spl_pos << 1) >> 1] = HEAP16[$this + 560 + ($add189 + $conv17861 << 1) >> 1] | 0;
    $pos176_060 = $pos176_060 + 1 & 65535;
    $conv17861 = $pos176_060 & 65535;
   } while ($conv17861 >>> 0 < ((HEAPU16[$this + 640 + (HEAP32[$sublma_num180 >> 2] << 1) >> 1] | 0) - $del_spl_pos | 0) >>> 0);
  }
  $length197 = $this + 724 | 0;
  HEAP16[$length197 >> 1] = (HEAP16[$length197 >> 1] | 0) - 1 & 65535;
  if ((HEAP32[$sublma_num180 >> 2] | 0) == 0) {
   return;
  } else {
   $del_a_sub_0_off051 = 0;
   $pos201_052 = 1;
   $conv20353 = 1;
  }
  do {
   $arrayidx212 = $this + 640 + ($conv20353 - 1 << 1) | 0;
   $42 = HEAP16[$this + 640 + ($conv20353 << 1) >> 1] | 0;
   $del_a_sub_0_off051 = (HEAP16[$arrayidx212 >> 1] | 0) == $42 << 16 >> 16 | $del_a_sub_0_off051;
   if ($del_a_sub_0_off051) {
    HEAP16[$arrayidx212 >> 1] = $42;
   }
   $pos201_052 = $pos201_052 + 1 & 65535;
   $conv20353 = $pos201_052 & 65535;
   $43 = HEAP32[$sublma_num180 >> 2] | 0;
  } while ($conv20353 >>> 0 <= $43 >>> 0);
  if (!$del_a_sub_0_off051) {
   return;
  }
  HEAP32[$sublma_num180 >> 2] = $43 - 1;
  return;
 }
}
function __ZN10ime_pinyin12MatrixSearch19add_lma_to_userdictEttf($this, $lma_fr, $lma_to, $score) {
 $this = $this | 0;
 $lma_fr = $lma_fr | 0;
 $lma_to = $lma_to | 0;
 $score = +$score;
 var $word_str = 0, $spl_ids = 0, $user_dict_ = 0, $spl_id_fr_027 = 0, $pos_026 = 0, $conv428 = 0, $1 = 0, $2 = 0, $4 = 0, $6 = 0, $sub18 = 0, $conv20 = 0, $add_ptr = 0, $add50 = 0, $inc = 0, $spl_id_fr_0_lcssa30 = 0, $7 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 40 | 0;
 $word_str = sp | 0;
 $spl_ids = sp + 24 | 0;
 if ((($lma_to & 65535) - ($lma_fr & 65535) | 0) < 2) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $user_dict_ = $this + 16 | 0;
 if ((HEAP32[$user_dict_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 do {
  if (($lma_fr & 65535) < ($lma_to & 65535)) {
   $pos_026 = $lma_fr;
   $spl_id_fr_027 = 0;
   while (1) {
    $conv428 = $pos_026 & 65535;
    $1 = HEAP32[$this + 196 + ($conv428 << 2) >> 2] | 0;
    if (__ZN10ime_pinyin13is_user_lemmaEj($1) | 0) {
     $2 = HEAP32[$user_dict_ >> 2] | 0;
     $4 = HEAP32[(HEAP32[$2 >> 2] | 0) + 48 >> 2] | 0;
     FUNCTION_TABLE_iiiii[$4 & 31]($2, $1, 1, 1) | 0;
    }
    $6 = HEAP16[$this + 116 + ($conv428 << 1) >> 1] | 0;
    $sub18 = (HEAP16[$this + 116 + ($conv428 + 1 << 1) >> 1] | 0) - $6 & 65535;
    $conv20 = $spl_id_fr_027 & 65535;
    $add_ptr = $spl_ids + ($conv20 << 1) | 0;
    _utf16_strncpy($add_ptr, $this + 816 + (($6 & 65535) << 1) | 0, $sub18 & 65535) | 0;
    if ((__ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, $1, $word_str + ($conv20 << 1) | 0, 9 - $spl_id_fr_027 & 65535) | 0) << 16 >> 16 != $sub18 << 16 >> 16) {
     label = 1383;
     break;
    }
    if ((__ZN10ime_pinyin12MatrixSearch16get_lemma_splidsEjPttb($this, $1, $add_ptr, $sub18, 1) | 0) << 16 >> 16 != $sub18 << 16 >> 16) {
     $retval_0 = 0;
     label = 1393;
     break;
    }
    $add50 = $sub18 + $spl_id_fr_027 & 65535;
    $inc = $pos_026 + 1 & 65535;
    if (($inc & 65535) < ($lma_to & 65535)) {
     $pos_026 = $inc;
     $spl_id_fr_027 = $add50;
    } else {
     label = 1386;
     break;
    }
   }
   if ((label | 0) == 1386) {
    if (($add50 & 65535) < 9) {
     $spl_id_fr_0_lcssa30 = $add50;
     break;
    }
    ___assert_func(1184, 682, 6808, 944);
    return 0;
   } else if ((label | 0) == 1383) {
    ___assert_func(1184, 672, 6808, 1136);
    return 0;
   } else if ((label | 0) == 1393) {
    STACKTOP = sp;
    return $retval_0 | 0;
   }
  } else {
   $spl_id_fr_0_lcssa30 = 0;
  }
 } while (0);
 $7 = HEAP32[$user_dict_ >> 2] | 0;
 $retval_0 = (FUNCTION_TABLE_iiiiii[HEAP32[(HEAP32[$7 >> 2] | 0) + 44 >> 2] & 15]($7, $word_str | 0, $spl_ids | 0, $spl_id_fr_0_lcssa30, 1) | 0) != 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch9match_dmiEjPtt($this, $step_to, $spl_ids, $spl_id_num) {
 $this = $this | 0;
 $step_to = $step_to | 0;
 $spl_ids = $spl_ids | 0;
 $spl_id_num = $spl_id_num | 0;
 var $matrix_ = 0, $5 = 0, $dmi_pool_ = 0, $9 = 0, $conv19 = 0, $cmp2614 = 0, $sub = 0, $10 = 0, $dmi_pos_022 = 0, $add_ptr_sum = 0, $spl_pos_016 = 0, $dmi_015 = 0, $inc = 0, $inc49 = 0, $20 = 0, $retval_0 = 0, label = 0;
 if ((HEAP32[$this + 72 >> 2] | 0) >>> 0 < $step_to >>> 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $matrix_ = $this + 96 | 0;
 if ((HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ($step_to * 12 | 0) + 6 >> 1] & 32767) == 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $5 = HEAP32[$matrix_ >> 2] | 0;
 if ((HEAP16[$5 + ($step_to * 12 | 0) + 6 >> 1] & 32767) == 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $dmi_pool_ = $this + 88 | 0;
 $9 = HEAP32[$dmi_pool_ >> 2] | 0;
 $conv19 = $spl_id_num & 65535;
 $cmp2614 = $spl_id_num << 16 >> 16 == 0;
 $sub = $conv19 - 1 | 0;
 $dmi_pos_022 = 0;
 $10 = $5;
 L1767 : while (1) {
  $add_ptr_sum = (HEAPU16[$10 + ($step_to * 12 | 0) + 2 >> 1] | 0) + ($dmi_pos_022 & 65535) | 0;
  L1769 : do {
   if ((HEAP8[$9 + ($add_ptr_sum * 12 | 0) + 8 | 0] & 127 | 0) == ($conv19 | 0)) {
    if ($cmp2614) {
     break L1767;
    }
    $dmi_015 = $9 + ($add_ptr_sum * 12 | 0) | 0;
    $spl_pos_016 = 0;
    while (1) {
     if ((HEAP16[$spl_ids + ($sub - ($spl_pos_016 & 65535) << 1) >> 1] | 0) != (HEAP16[$dmi_015 + 6 >> 1] | 0)) {
      break L1769;
     }
     $inc = $spl_pos_016 + 1 & 65535;
     if (($inc & 65535) < ($spl_id_num & 65535)) {
      $dmi_015 = (HEAP32[$dmi_pool_ >> 2] | 0) + ((HEAPU16[$dmi_015 + 4 >> 1] | 0) * 12 | 0) | 0;
      $spl_pos_016 = $inc;
     } else {
      break L1767;
     }
    }
   }
  } while (0);
  $inc49 = $dmi_pos_022 + 1 & 65535;
  $20 = HEAP32[$matrix_ >> 2] | 0;
  if (($inc49 & 65535) < (HEAP16[$20 + ($step_to * 12 | 0) + 6 >> 1] & 32767)) {
   $dmi_pos_022 = $inc49;
   $10 = $20;
  } else {
   $retval_0 = -1;
   label = 1410;
   break;
  }
 }
 if ((label | 0) == 1410) {
  return $retval_0 | 0;
 }
 $retval_0 = (HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ($step_to * 12 | 0) + 2 >> 1] | 0) + $dmi_pos_022 & 65535;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch12get_fixedlenEv($this) {
 $this = $this | 0;
 var $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 72 >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP32[$this + 896 >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch8fill_dmiEPNS_13DictMatchInfoEPtttthbhh($this, $dmi, $handles, $dmi_fr, $spl_id, $node_num, $dict_level, $splid_end_split, $splstr_len, $all_full_id) {
 $this = $this | 0;
 $dmi = $dmi | 0;
 $handles = $handles | 0;
 $dmi_fr = $dmi_fr | 0;
 $spl_id = $spl_id | 0;
 $node_num = $node_num | 0;
 $dict_level = $dict_level | 0;
 $splid_end_split = $splid_end_split | 0;
 $splstr_len = $splstr_len | 0;
 $all_full_id = $all_full_id | 0;
 var $2 = 0, $9 = 0;
 HEAP16[$dmi >> 1] = HEAP16[$handles >> 1] | 0;
 HEAP16[$dmi + 2 >> 1] = HEAP16[$handles + 2 >> 1] | 0;
 HEAP16[$dmi + 4 >> 1] = $dmi_fr;
 HEAP16[$dmi + 6 >> 1] = $spl_id;
 $2 = $dmi + 8 | 0;
 HEAP8[$2] = HEAP8[$2] & -128 | $dict_level & 127;
 HEAP8[$dmi + 9 | 0] = $splstr_len << 1 | $splid_end_split & 1;
 $9 = $dmi + 10 | 0;
 HEAP8[$9] = HEAP8[$9] & -2 | $all_full_id & 1;
 HEAP8[$2] = HEAP8[$2] & 127;
 return;
}
function __ZN10ime_pinyin12MatrixSearch16prepare_add_charEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 var $pys_decoded_len_ = 0, $dmi_pool_used_ = 0, $inc = 0, $5 = 0, $retval_0 = 0;
 $pys_decoded_len_ = $this + 72 | 0;
 if ((HEAP32[$pys_decoded_len_ >> 2] | 0) >>> 0 > 38) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin14SpellingParser17is_valid_to_parseEc(HEAP32[$this + 20 >> 2] | 0, $ch) | 0 | $ch << 24 >> 24 == 39)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $dmi_pool_used_ = $this + 92 | 0;
 if ((HEAPU16[$dmi_pool_used_ >> 1] | 0) > 799) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP8[(HEAP32[$pys_decoded_len_ >> 2] | 0) + ($this + 32) | 0] = $ch;
 $inc = (HEAP32[$pys_decoded_len_ >> 2] | 0) + 1 | 0;
 HEAP32[$pys_decoded_len_ >> 2] = $inc;
 $5 = HEAP32[$this + 96 >> 2] | 0;
 HEAP16[$5 + ($inc * 12 | 0) >> 1] = HEAP16[$this + 84 >> 1] | 0;
 HEAP16[$5 + ($inc * 12 | 0) + 4 >> 1] = 0;
 HEAP16[$5 + ($inc * 12 | 0) + 2 >> 1] = HEAP16[$dmi_pool_used_ >> 1] | 0;
 HEAP16[$5 + ($inc * 12 | 0) + 6 >> 1] = 0;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch11is_split_atEt($this, $pos) {
 $this = $this | 0;
 $pos = $pos | 0;
 return (__ZN10ime_pinyin14SpellingParser17is_valid_to_parseEc(HEAP32[$this + 20 >> 2] | 0, HEAP8[($pos & 65535) - 1 + ($this + 32) | 0] | 0) | 0) ^ 1 | 0;
}
function __ZN10ime_pinyin12MatrixSearch6chooseEj($this, $cand_id) {
 $this = $this | 0;
 $cand_id = $cand_id | 0;
 var $lpi_item26 = 0, $lpi_item26_sub = 0, $tmpcast = 0, $pys_decoded_len_ = 0, $3 = 0, $idxprom = 0, $6 = 0, $fixed_lmas_ = 0, $8 = 0, $lma_id_num_ = 0, $9 = 0, $pos_028 = 0, $inc = 0, $10 = 0, $_lcssa = 0, $arrayidx19 = 0, $13 = 0, $15 = 0, $16 = 0, $dec = 0, $19 = 0, $bf_clear = 0, $20 = 0, $bf_clear43 = 0, $22 = 0, $24 = 0, $fixed_hzs_56 = 0, $25 = 0, $26 = 0, $conv63 = 0, $28 = 0, $matrix_66 = 0, $call72 = 0, $38 = 0, $40 = 0, $fixed_lmas_101 = 0, $43 = 0, $46 = 0, $step_to_0 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $lpi_item26 = sp | 0;
 $lpi_item26_sub = $lpi_item26 | 0;
 $tmpcast = $lpi_item26;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $pys_decoded_len_ = $this + 72 | 0;
 if ((HEAP32[$pys_decoded_len_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if (($cand_id | 0) == 0) {
  $3 = HEAP32[$this + 732 >> 2] | 0;
  HEAP32[$this + 896 >> 2] = $3;
  $idxprom = HEAPU16[$this + 736 + ($3 << 1) >> 1] | 0;
  $6 = HEAP32[$this + 96 >> 2] | 0;
  HEAP32[$6 + ($idxprom * 12 | 0) + 8 >> 2] = (HEAP32[$this + 80 >> 2] | 0) + ((HEAPU16[$6 + ($idxprom * 12 | 0) >> 1] | 0) << 4);
  $fixed_lmas_ = $this + 356 | 0;
  $8 = HEAP32[$fixed_lmas_ >> 2] | 0;
  $lma_id_num_ = $this + 112 | 0;
  $9 = HEAP32[$lma_id_num_ >> 2] | 0;
  if ($8 >>> 0 < $9 >>> 0) {
   $pos_028 = $8;
   while (1) {
    HEAP8[$this + 360 + $pos_028 | 0] = 1;
    $inc = $pos_028 + 1 | 0;
    $10 = HEAP32[$lma_id_num_ >> 2] | 0;
    if ($inc >>> 0 < $10 >>> 0) {
     $pos_028 = $inc;
    } else {
     $_lcssa = $10;
     break;
    }
   }
  } else {
   $_lcssa = $9;
  }
  HEAP32[$fixed_lmas_ >> 2] = $_lcssa;
  HEAP32[$this + 12500 >> 2] = 0;
  do {
   if ((HEAP32[$lma_id_num_ >> 2] | 0) == 1) {
    $arrayidx19 = $this + 196 | 0;
    if (!(__ZN10ime_pinyin13is_user_lemmaEj(HEAP32[$arrayidx19 >> 2] | 0) | 0)) {
     break;
    }
    $13 = HEAP32[$this + 16 >> 2] | 0;
    if (($13 | 0) == 0) {
     break;
    }
    $15 = HEAP32[(HEAP32[$13 >> 2] | 0) + 48 >> 2] | 0;
    $16 = HEAP32[$arrayidx19 >> 2] | 0;
    FUNCTION_TABLE_iiiii[$15 & 31]($13, $16, 1, 1) | 0;
   } else {
    if ((HEAP32[$this + 16 >> 2] | 0) == 0) {
     break;
    }
    __ZN10ime_pinyin12MatrixSearch25try_add_cand0_to_userdictEv($this) | 0;
   }
  } while (0);
  __ZN10ime_pinyin12MatrixSearch16update_dict_freqEv($this);
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $dec = $cand_id - 1 | 0;
 $19 = HEAP32[$this + 900 + ($dec << 3) >> 2] | 0;
 $bf_clear = $19 & 16777215;
 $20 = HEAP16[$this + 900 + ($dec << 3) + 4 >> 1] | 0;
 $bf_clear43 = $19 >>> 24 & 15;
 if (($bf_clear43 | 0) == 0) {
  ___assert_func(1184, 819, 6760, 3664);
  return 0;
 }
 if (__ZN10ime_pinyin13is_user_lemmaEj($bf_clear) | 0) {
  $22 = HEAP32[$this + 16 >> 2] | 0;
  if (($22 | 0) != 0) {
   $24 = HEAP32[(HEAP32[$22 >> 2] | 0) + 48 >> 2] | 0;
   FUNCTION_TABLE_iiiii[$24 & 31]($22, $bf_clear, 1, 1) | 0;
  }
  __ZN10ime_pinyin12MatrixSearch16update_dict_freqEv($this);
 }
 $fixed_hzs_56 = $this + 896 | 0;
 $25 = HEAP32[$fixed_hzs_56 >> 2] | 0;
 $26 = HEAP16[$this + 736 + ($25 << 1) >> 1] | 0;
 $conv63 = HEAPU16[$this + 736 + ($25 + $bf_clear43 << 1) >> 1] | 0;
 $28 = HEAP32[$pys_decoded_len_ >> 2] | 0;
 __ZN10ime_pinyin12MatrixSearch12reset_searchEjbbb($this, $conv63, 0, 0, 1) | 0;
 $matrix_66 = $this + 96 | 0;
 HEAP16[(HEAP32[$matrix_66 >> 2] | 0) + ($conv63 * 12 | 0) + 4 >> 1] = 0;
 HEAP16[$lpi_item26 + 4 >> 1] = $20;
 HEAP32[$lpi_item26_sub >> 2] = HEAP32[$lpi_item26_sub >> 2] & -16777216 | $bf_clear;
 $call72 = __ZN10ime_pinyin12MatrixSearch9match_dmiEjPtt($this, $conv63, $this + 816 + (HEAP32[$fixed_hzs_56 >> 2] << 1) | 0, $bf_clear43 & 65535) | 0;
 if ($call72 << 16 >> 16 == -1) {
  ___assert_func(1184, 851, 6760, 3552);
  return 0;
 }
 __ZN10ime_pinyin12MatrixSearch14extend_mtrx_ndEPNS_10MatrixNodeEPNS_10LmaPsbItemEjtj($this, HEAP32[(HEAP32[$matrix_66 >> 2] | 0) + (($26 & 65535) * 12 | 0) + 8 >> 2] | 0, $tmpcast, 1, $call72, $conv63) | 0;
 $38 = HEAP32[$matrix_66 >> 2] | 0;
 HEAP32[$38 + ($conv63 * 12 | 0) + 8 >> 2] = (HEAP32[$this + 80 >> 2] | 0) + ((HEAPU16[$38 + ($conv63 * 12 | 0) >> 1] | 0) << 4);
 $40 = HEAP32[$matrix_66 >> 2] | 0;
 HEAP16[$this + 84 >> 1] = (HEAP16[$40 + ($conv63 * 12 | 0) + 4 >> 1] | 0) + (HEAP16[$40 + ($conv63 * 12 | 0) >> 1] | 0) & 65535;
 $fixed_lmas_101 = $this + 356 | 0;
 $43 = HEAP32[$fixed_lmas_101 >> 2] | 0;
 HEAP8[$this + 360 + $43 | 0] = ($bf_clear | 0) == (HEAP32[$this + 196 + ($43 << 2) >> 2] | 0) | 0;
 HEAP32[$this + 196 + (HEAP32[$fixed_lmas_101 >> 2] << 2) >> 2] = $bf_clear;
 $46 = HEAP32[$fixed_lmas_101 >> 2] | 0;
 HEAP16[$this + 116 + ($46 + 1 << 1) >> 1] = (HEAPU16[$this + 116 + ($46 << 1) >> 1] | 0) + $bf_clear43 & 65535;
 HEAP32[$fixed_lmas_101 >> 2] = (HEAP32[$fixed_lmas_101 >> 2] | 0) + 1;
 HEAP32[$fixed_hzs_56 >> 2] = (HEAP32[$fixed_hzs_56 >> 2] | 0) + $bf_clear43;
 $step_to_0 = $conv63;
 while (1) {
  if (($step_to_0 | 0) == ($28 | 0)) {
   break;
  }
  if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, HEAP8[$this + 32 + $step_to_0 | 0] | 0) | 0) {
   $step_to_0 = $step_to_0 + 1 | 0;
  } else {
   label = 1452;
   break;
  }
 }
 if ((label | 0) == 1452) {
  ___assert_func(1184, 871, 6760, 3432);
  return 0;
 }
 do {
  if ((HEAP32[$fixed_hzs_56 >> 2] | 0) >>> 0 < (HEAP32[$this + 732 >> 2] | 0) >>> 0) {
   __ZN10ime_pinyin12MatrixSearch18prepare_candidatesEv($this);
  } else {
   HEAP32[$this + 12500 >> 2] = 0;
   if ((HEAP32[$this + 16 >> 2] | 0) == 0) {
    break;
   }
   __ZN10ime_pinyin12MatrixSearch25try_add_cand0_to_userdictEv($this) | 0;
  }
 } while (0);
 $retval_0 = __ZN10ime_pinyin12MatrixSearch17get_candidate_numEv($this) | 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch14extend_mtrx_ndEPNS_10MatrixNodeEPNS_10LmaPsbItemEjtj($this, $mtrx_nd, $lpi_items, $lpi_num, $dmi_fr, $res_row) {
 $this = $this | 0;
 $mtrx_nd = $mtrx_nd | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_num = $lpi_num | 0;
 $dmi_fr = $dmi_fr | 0;
 $res_row = $res_row | 0;
 var $matrix_ = 0, $lpi_num_addr_0 = 0, $3 = 0, $conv12 = 0, $add_ptr = 0, $score14 = 0, $conv50 = 0, $sub_ptr_rhs_cast = 0, $score20 = 0, $pos_039 = 0, $arrayidx15 = 0, $add = 0.0, $10 = 0, $conv28 = 0, $add_ptr_sum = 0, $add_ptr29 = 0, $replace_0_off036 = 0, $mtrx_nd_res_035 = 0, $add_ptr31 = 0, $12 = 0, $13 = 0, $mtrx_nd_res_0_lcssa45 = 0, $mtrx_nd_res_0_lcssa43 = 0, $mtrx_nd_num54 = 0, $19 = 0, $retval_0 = 0, label = 0;
 if (($mtrx_nd | 0) == 0) {
  ___assert_func(1184, 1589, 7112, 2360);
  return 0;
 }
 $matrix_ = $this + 96 | 0;
 HEAP32[(HEAP32[$matrix_ >> 2] | 0) + ($res_row * 12 | 0) + 8 >> 2] = 0;
 if ((HEAPU16[$this + 84 >> 1] | 0) > 194) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lpi_num_addr_0 = (HEAP16[$mtrx_nd + 14 >> 1] | 0) == 0 & $lpi_num >>> 0 > 5 ? 5 : $lpi_num;
 $3 = HEAP32[$this + 80 >> 2] | 0;
 $conv12 = HEAPU16[(HEAP32[$matrix_ >> 2] | 0) + ($res_row * 12 | 0) >> 1] | 0;
 $add_ptr = $3 + ($conv12 << 4) | 0;
 L1854 : do {
  if (($lpi_num_addr_0 | 0) != 0) {
   $score14 = $mtrx_nd + 4 | 0;
   $conv50 = $res_row & 65535;
   $sub_ptr_rhs_cast = $add_ptr;
   $score20 = $3 + ($conv12 << 4) + 4 | 0;
   $pos_039 = 0;
   do {
    $arrayidx15 = $lpi_items + ($pos_039 << 3) | 0;
    $add = +HEAPF32[$score14 >> 2] + +(HEAPU16[$lpi_items + ($pos_039 << 3) + 4 >> 1] | 0);
    if (($pos_039 | 0) != 0) {
     if ($add + -8.0e3 > +HEAPF32[$score20 >> 2]) {
      break L1854;
     }
    }
    $10 = HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ($res_row * 12 | 0) + 4 >> 1] | 0;
    $conv28 = $10 & 65535;
    $add_ptr_sum = $conv28 + $conv12 | 0;
    $add_ptr29 = $3 + ($add_ptr_sum << 4) | 0;
    L1861 : do {
     if (($add_ptr_sum | 0) > ($conv12 | 0)) {
      $mtrx_nd_res_035 = $add_ptr29;
      $replace_0_off036 = 0;
      while (1) {
       $add_ptr31 = $mtrx_nd_res_035 - 16 | 0;
       if ($add >= +HEAPF32[$mtrx_nd_res_035 - 16 + 4 >> 2]) {
        break;
       }
       if ($mtrx_nd_res_035 - $sub_ptr_rhs_cast >> 4 >>> 0 < 5) {
        $12 = $mtrx_nd_res_035;
        $13 = $add_ptr31;
        HEAP32[$12 >> 2] = HEAP32[$13 >> 2];
        HEAP32[$12 + 4 >> 2] = HEAP32[$13 + 4 >> 2];
        HEAP32[$12 + 8 >> 2] = HEAP32[$13 + 8 >> 2];
        HEAP32[$12 + 12 >> 2] = HEAP32[$13 + 12 >> 2];
       }
       if ($add_ptr31 >>> 0 > $add_ptr >>> 0) {
        $mtrx_nd_res_035 = $add_ptr31;
        $replace_0_off036 = 1;
       } else {
        $mtrx_nd_res_0_lcssa43 = $add_ptr31;
        label = 1478;
        break L1861;
       }
      }
      if ($replace_0_off036) {
       $mtrx_nd_res_0_lcssa43 = $mtrx_nd_res_035;
       label = 1478;
      } else {
       $mtrx_nd_res_0_lcssa45 = $mtrx_nd_res_035;
       label = 1476;
      }
     } else {
      $mtrx_nd_res_0_lcssa45 = $add_ptr29;
      label = 1476;
     }
    } while (0);
    do {
     if ((label | 0) == 1476) {
      label = 0;
      if (($10 & 65535) >= 5) {
       break;
      }
      if (((HEAPU16[(HEAP32[$matrix_ >> 2] | 0) + ($res_row * 12 | 0) >> 1] | 0) + $conv28 | 0) >>> 0 < 200) {
       $mtrx_nd_res_0_lcssa43 = $mtrx_nd_res_0_lcssa45;
       label = 1478;
      }
     }
    } while (0);
    do {
     if ((label | 0) == 1478) {
      label = 0;
      HEAP32[$mtrx_nd_res_0_lcssa43 >> 2] = HEAP32[$arrayidx15 >> 2] & 16777215;
      HEAPF32[$mtrx_nd_res_0_lcssa43 + 4 >> 2] = $add;
      HEAP32[$mtrx_nd_res_0_lcssa43 + 8 >> 2] = $mtrx_nd;
      HEAP16[$mtrx_nd_res_0_lcssa43 + 12 >> 1] = $dmi_fr;
      HEAP16[$mtrx_nd_res_0_lcssa43 + 14 >> 1] = $conv50;
      $mtrx_nd_num54 = (HEAP32[$matrix_ >> 2] | 0) + ($res_row * 12 | 0) + 4 | 0;
      $19 = HEAP16[$mtrx_nd_num54 >> 1] | 0;
      if (($19 & 65535) >= 5) {
       break;
      }
      HEAP16[$mtrx_nd_num54 >> 1] = $19 + 1 & 65535;
     }
    } while (0);
    $pos_039 = $pos_039 + 1 | 0;
   } while ($pos_039 >>> 0 < $lpi_num_addr_0 >>> 0);
  }
 } while (0);
 $retval_0 = HEAPU16[(HEAP32[$matrix_ >> 2] | 0) + ($res_row * 12 | 0) + 4 >> 1] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch18cancel_last_choiceEv($this) {
 $this = $this | 0;
 var $fixed_hzs_ = 0, $3 = 0, $6 = 0, $8 = 0, $conv7 = 0, $storemerge = 0, $step_start_0 = 0, $13 = 0, $retval_0 = 0, label = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 72 >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $fixed_hzs_ = $this + 896 | 0;
 $3 = HEAP32[$fixed_hzs_ >> 2] | 0;
 do {
  if (($3 | 0) != 0) {
   $6 = HEAP32[(HEAP32[$this + 96 >> 2] | 0) + ((HEAPU16[$this + 736 + ($3 << 1) >> 1] | 0) * 12 | 0) + 8 >> 2] | 0;
   if (($6 | 0) == 0) {
    ___assert_func(1184, 895, 6888, 3280);
    return 0;
   }
   $8 = HEAP16[(HEAP32[$6 + 8 >> 2] | 0) + 14 >> 1] | 0;
   $conv7 = $8 & 65535;
   if ($8 << 16 >> 16 == 0) {
    $storemerge = 0;
   } else {
    $storemerge = $3 - (HEAP8[(HEAP32[$this + 88 >> 2] | 0) + ((HEAPU16[$6 + 12 >> 1] | 0) * 12 | 0) + 8 | 0] & 127) | 0;
   }
   HEAP32[$fixed_hzs_ >> 2] = $storemerge;
   __ZN10ime_pinyin12MatrixSearch12reset_searchEjbbb($this, $conv7, 0, 0, 0) | 0;
   $step_start_0 = $conv7;
   while (1) {
    $13 = HEAP8[$this + 32 + $step_start_0 | 0] | 0;
    if ($13 << 24 >> 24 == 0) {
     label = 1496;
     break;
    }
    if (__ZN10ime_pinyin12MatrixSearch8add_charEc($this, $13) | 0) {
     $step_start_0 = $step_start_0 + 1 | 0;
    } else {
     label = 1495;
     break;
    }
   }
   if ((label | 0) == 1495) {
    ___assert_func(1184, 910, 6888, 3432);
    return 0;
   } else if ((label | 0) == 1496) {
    __ZN10ime_pinyin12MatrixSearch18prepare_candidatesEv($this);
    break;
   }
  }
 } while (0);
 $retval_0 = __ZN10ime_pinyin12MatrixSearch17get_candidate_numEv($this) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch15add_char_qwertyEv($this) {
 $this = $this | 0;
 var $is_pre = 0, $pys_decoded_len_ = 0, $matrix_ = 0, $fixed_hzs_ = 0, $dmi_c_phrase_ = 0, $spl_parser_ = 0, $dmi_pool_ = 0, $dep_68 = 0, $spl_trie_ = 0, $dep_74 = 0, $spl_trie_194 = 0, $lpi_total_ = 0, $mtrx_nd_pool_ = 0, $arraydecay290 = 0, $dmi_pool_used_292 = 0, $dmi_c_phrase_217 = 0, $dmi_pool_used_236 = 0, $dmi_pool_used_ = 0, $dmi_c_phrase_147 = 0, $dep_ = 0, $dmi_c_phrase_116 = 0, $xi_an_enabled_ = 0, $conv117 = 0, $spl_matched_0_off0116 = 0, $longest_ext_0115 = 0, $ext_len_0112 = 0, $2 = 0, $11 = 0, $sub24 = 0, $conv25 = 0, $conv30 = 0, $call = 0, $spl_matched_0_off0_ = 0, $call54 = 0, $21 = 0, $22 = 0, $conv6096 = 0, $add72101 = 0, $frombool191 = 0, $add72107 = 0, $conv60106 = 0, $dmi_pos_0105 = 0, $longest_ext_1104 = 0, $26 = 0, $add_ptr77 = 0, $27 = 0, $dmi_0 = 0, $dep_77 = 0, $46 = 0, $bf_clear145 = 0, $49 = 0, $conv146 = 0, $d_081 = 0, $prev_ids_num_080 = 0, $dec = 0, $52 = 0, $add_ptr171 = 0, $prev_ids_num_1 = 0, $cmp14272 = 0, $dep_71 = 0, $56 = 0, $call200 = 0, $call212 = 0, $73 = 0, $79 = 0, $80 = 0, $88 = 0, $conv257 = 0, $fr_row_0 = 0, $idxprom269 = 0, $95 = 0, $96 = 0, $conv27482 = 0, $conv27491 = 0, $mtrx_nd_pos_090 = 0, $longest_ext_289 = 0, $ext_len_0_longest_ext_2 = 0, $inc = 0, $conv274 = 0, $102 = 0, $longest_ext_4 = 0, $inc305 = 0, $conv60 = 0, $105 = 0, $add72 = 0, $longest_ext_5 = 0, $spl_matched_2_off0 = 0, $dec308 = 0, $spl_matched_0_off0_lcssa = 0, $mtrx_nd_pool_used_ = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $is_pre = sp | 0;
 $pys_decoded_len_ = $this + 72 | 0;
 $matrix_ = $this + 96 | 0;
 HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ((HEAP32[$pys_decoded_len_ >> 2] | 0) * 12 | 0) + 4 >> 1] = 0;
 $fixed_hzs_ = $this + 896 | 0;
 $dmi_c_phrase_ = $this + 728 | 0;
 $spl_parser_ = $this + 20 | 0;
 $dmi_pool_ = $this + 88 | 0;
 $dep_68 = $this + 100 | 0;
 $spl_trie_ = $this + 4 | 0;
 $dep_74 = $this + 100 | 0;
 $spl_trie_194 = $this + 4 | 0;
 $lpi_total_ = $this + 12500 | 0;
 $mtrx_nd_pool_ = $this + 80 | 0;
 $arraydecay290 = $this + 900 | 0;
 $dmi_pool_used_292 = $this + 92 | 0;
 $dmi_c_phrase_217 = $this + 728 | 0;
 $dmi_pool_used_236 = $this + 92 | 0;
 $dmi_pool_used_ = $this + 92 | 0;
 $dmi_c_phrase_147 = $this + 728 | 0;
 $dep_ = $this + 100 | 0;
 $dmi_c_phrase_116 = $this + 728 | 0;
 $xi_an_enabled_ = $this + 8 | 0;
 $ext_len_0112 = 7;
 $longest_ext_0115 = 0;
 $spl_matched_0_off0116 = 0;
 $conv117 = 7;
 L1902 : while (1) {
  $2 = HEAP32[$pys_decoded_len_ >> 2] | 0;
  L1904 : do {
   if ($conv117 >>> 0 > ($2 - (HEAPU16[$this + 736 + (HEAP32[$fixed_hzs_ >> 2] << 1) >> 1] | 0) | 0) >>> 0) {
    $spl_matched_2_off0 = $spl_matched_0_off0116;
    $longest_ext_5 = $longest_ext_0115;
   } else {
    do {
     if (!(($ext_len_0112 & 65535) < 2 | $longest_ext_0115 << 16 >> 16 == 0)) {
      if ((HEAP16[(HEAP32[$matrix_ >> 2] | 0) + (($2 - $conv117 | 0) * 12 | 0) + 6 >> 1] | 0) <= -1) {
       break;
      }
      if ((HEAP8[$xi_an_enabled_] & 1) == 0) {
       $spl_matched_0_off0_lcssa = $spl_matched_0_off0116;
       label = 1550;
       break L1902;
      } else {
       $spl_matched_2_off0 = $spl_matched_0_off0116;
       $longest_ext_5 = $longest_ext_0115;
       break L1904;
      }
     }
    } while (0);
    $11 = HEAP32[$pys_decoded_len_ >> 2] | 0;
    $sub24 = $11 - $conv117 | 0;
    $conv25 = $sub24 & 65535;
    $conv30 = $sub24 & 65535;
    if ((HEAPU16[$this + 736 + (HEAP32[$fixed_hzs_ >> 2] << 1) >> 1] | 0) >>> 0 > $conv30 >>> 0) {
     $spl_matched_2_off0 = $spl_matched_0_off0116;
     $longest_ext_5 = $longest_ext_0115;
     break;
    }
    if ((HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ($conv30 * 12 | 0) + 4 >> 1] | 0) == 0) {
     if ((HEAP8[$dmi_c_phrase_] & 1) == 0) {
      $spl_matched_2_off0 = $spl_matched_0_off0116;
      $longest_ext_5 = $longest_ext_0115;
      break;
     }
    }
    HEAP8[$is_pre] = 0;
    $call = __ZN10ime_pinyin14SpellingParser16get_splid_by_strEPKctPb(HEAP32[$spl_parser_ >> 2] | 0, $this + 32 + $conv30 | 0, $ext_len_0112, $is_pre) | 0;
    $spl_matched_0_off0_ = $spl_matched_0_off0116 | (HEAP8[$is_pre] & 1) != 0;
    if ($call << 16 >> 16 == 0) {
     $spl_matched_2_off0 = $spl_matched_0_off0_;
     $longest_ext_5 = $longest_ext_0115;
     break;
    }
    $call54 = __ZN10ime_pinyin12MatrixSearch11is_split_atEt($this, $11 & 65535) | 0;
    $21 = HEAP32[$matrix_ >> 2] | 0;
    $22 = HEAP16[$21 + ($conv30 * 12 | 0) + 2 >> 1] | 0;
    $conv6096 = $22 & 65535;
    $add72101 = (HEAP16[$21 + ($conv30 * 12 | 0) + 6 >> 1] & 32767) + ($22 & 65535) | 0;
    if (($conv6096 | 0) >= ($add72101 + 1 | 0)) {
     $spl_matched_2_off0 = $spl_matched_0_off0_;
     $longest_ext_5 = $longest_ext_0115;
     break;
    }
    $frombool191 = $call54 & 1;
    $longest_ext_1104 = $longest_ext_0115;
    $dmi_pos_0105 = $22;
    $conv60106 = $conv6096;
    $add72107 = $add72101;
    while (1) {
     $26 = HEAP32[$dmi_pool_ >> 2] | 0;
     $add_ptr77 = $26 + ($conv60106 * 12 | 0) | 0;
     do {
      if (($conv60106 | 0) == ($add72107 | 0)) {
       $dmi_0 = 0;
       label = 1518;
      } else {
       $27 = HEAP32[$fixed_hzs_ >> 2] | 0;
       if (($27 | 0) != 0) {
        if (((HEAP32[$pys_decoded_len_ >> 2] | 0) - $conv117 - ((HEAPU8[$26 + ($conv60106 * 12 | 0) + 9 | 0] | 0) >>> 1 & 255) | 0) >>> 0 < (HEAPU16[$this + 736 + ($27 << 1) >> 1] | 0) >>> 0) {
         $longest_ext_4 = $longest_ext_1104;
         break;
        }
       }
       if ((HEAP8[$26 + ($conv60106 * 12 | 0) + 8 | 0] | 0) >= 0) {
        $dmi_0 = $add_ptr77;
        label = 1518;
        break;
       }
       if ((HEAP8[$dmi_c_phrase_116] & 1) == 0) {
        $longest_ext_4 = $longest_ext_1104;
       } else {
        $dmi_0 = $add_ptr77;
        label = 1518;
       }
      }
     } while (0);
     L1924 : do {
      if ((label | 0) == 1518) {
       label = 0;
       do {
        if (($longest_ext_1104 & 65535) > ($ext_len_0112 & 65535)) {
         if (($dmi_0 | 0) == 0) {
          if ((HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ($conv30 * 12 | 0) + 6 >> 1] | 0) > -1) {
           $longest_ext_4 = $longest_ext_1104;
           break L1924;
          }
          HEAP16[(HEAP32[$dep_68 >> 2] | 0) + 80 >> 1] = 0;
          $dep_71 = $dep_68;
          $cmp14272 = 1;
          break;
         } else {
          if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$dmi_0 + 6 >> 1] | 0) | 0) {
           $longest_ext_4 = $longest_ext_1104;
           break L1924;
          }
          HEAP16[(HEAP32[$dep_74 >> 2] | 0) + 80 >> 1] = 0;
          $dep_77 = $dep_74;
          label = 1525;
          break;
         }
        } else {
         HEAP16[(HEAP32[$dep_ >> 2] | 0) + 80 >> 1] = 0;
         if (($dmi_0 | 0) == 0) {
          $dep_71 = $dep_;
          $cmp14272 = 1;
         } else {
          $dep_77 = $dep_;
          label = 1525;
         }
        }
       } while (0);
       if ((label | 0) == 1525) {
        label = 0;
        $46 = $dmi_0 + 8 | 0;
        $bf_clear145 = HEAP8[$46] & 127;
        $49 = HEAP8[$dmi_c_phrase_147] & 1;
        if ($49 << 24 >> 24 == 0 & ($bf_clear145 & 255) > 7) {
         $longest_ext_4 = $longest_ext_1104;
         break;
        }
        $conv146 = $bf_clear145 & 255;
        if ($49 << 24 >> 24 != 0 & ($bf_clear145 & 255) > 39) {
         $longest_ext_4 = $longest_ext_1104;
         break;
        }
        L1938 : do {
         if (($dmi_0 | 0) == 0) {
          $prev_ids_num_1 = $conv146;
         } else {
          $prev_ids_num_080 = $conv146;
          $d_081 = $dmi_0;
          while (1) {
           $dec = $prev_ids_num_080 - 1 & 65535;
           HEAP16[(HEAP32[$dep_77 >> 2] | 0) + (($dec & 65535) << 1) >> 1] = HEAP16[$d_081 + 6 >> 1] | 0;
           $52 = HEAP16[$d_081 + 4 >> 1] | 0;
           if ($52 << 16 >> 16 == -1) {
            $prev_ids_num_1 = $dec;
            break L1938;
           }
           $add_ptr171 = (HEAP32[$dmi_pool_ >> 2] | 0) + (($52 & 65535) * 12 | 0) | 0;
           if (($add_ptr171 | 0) == 0) {
            $prev_ids_num_1 = $dec;
            break;
           } else {
            $prev_ids_num_080 = $dec;
            $d_081 = $add_ptr171;
           }
          }
         }
        } while (0);
        if ($prev_ids_num_1 << 16 >> 16 != 0) {
         label = 1531;
         break L1902;
        }
        HEAP16[(HEAP32[$dep_77 >> 2] | 0) + 80 >> 1] = HEAP8[$46] & 127;
        $dep_71 = $dep_77;
        $cmp14272 = 0;
       }
       $56 = HEAP32[$dep_71 >> 2] | 0;
       HEAP16[$56 + (HEAPU16[$56 + 80 >> 1] << 1) >> 1] = $call;
       HEAP16[(HEAP32[$dep_71 >> 2] | 0) + 82 >> 1] = $ext_len_0112;
       HEAP8[(HEAP32[$dep_71 >> 2] | 0) + 86 | 0] = $frombool191;
       HEAP16[(HEAP32[$dep_71 >> 2] | 0) + 90 >> 1] = 1;
       HEAP16[(HEAP32[$dep_71 >> 2] | 0) + 88 >> 1] = $call;
       if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$spl_trie_194 >> 2] | 0, $call) | 0) {
        $call200 = __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt(HEAP32[$spl_trie_194 >> 2] | 0, $call, (HEAP32[$dep_71 >> 2] | 0) + 88 | 0) | 0;
        HEAP16[(HEAP32[$dep_71 >> 2] | 0) + 90 >> 1] = $call200;
        if ((HEAP16[(HEAP32[$dep_71 >> 2] | 0) + 90 >> 1] | 0) == 0) {
         label = 1535;
         break L1902;
        }
       }
       $call212 = __ZN10ime_pinyin12MatrixSearch10extend_dmiEPNS_11DictExtParaEPNS_13DictMatchInfoE($this, HEAP32[$dep_71 >> 2] | 0, $dmi_0) | 0;
       do {
        if (($call212 & 65535 | 0) != 0) {
         if ((HEAP8[$dmi_c_phrase_217] & 1) != 0) {
          $73 = (HEAP32[$dmi_pool_ >> 2] | 0) + ((HEAPU16[$dmi_pool_used_ >> 1] | 0) * 12 | 0) + 8 | 0;
          HEAP8[$73] = HEAP8[$73] | -128;
         }
         $79 = (HEAP32[$matrix_ >> 2] | 0) + ((HEAP32[$pys_decoded_len_ >> 2] | 0) * 12 | 0) + 6 | 0;
         $80 = HEAP16[$79 >> 1] | 0;
         HEAP16[$79 >> 1] = ($80 & 65535) + $call212 & 32767 | $80 & -32768;
         HEAP16[$dmi_pool_used_236 >> 1] = (HEAPU16[$dmi_pool_used_236 >> 1] | 0) + $call212 & 65535;
         if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$spl_trie_194 >> 2] | 0, $call) | 0) {
          break;
         }
         $88 = (HEAP32[$matrix_ >> 2] | 0) + ((HEAP32[$pys_decoded_len_ >> 2] | 0) * 12 | 0) + 6 | 0;
         HEAP16[$88 >> 1] = HEAP16[$88 >> 1] | -32768;
        }
       } while (0);
       if ((HEAP32[$lpi_total_ >> 2] | 0) == 0) {
        $longest_ext_4 = $longest_ext_1104;
        break;
       }
       if ($cmp14272) {
        $fr_row_0 = $conv25;
       } else {
        $conv257 = (HEAPU8[$dmi_0 + 9 | 0] | 0) >>> 1 & 255;
        if ($conv30 >>> 0 < $conv257 >>> 0) {
         label = 1544;
         break L1902;
        }
        $fr_row_0 = $sub24 - $conv257 & 65535;
       }
       $idxprom269 = $fr_row_0 & 65535;
       $95 = HEAP32[$matrix_ >> 2] | 0;
       $96 = HEAP16[$95 + ($idxprom269 * 12 | 0) >> 1] | 0;
       $conv27482 = $96 & 65535;
       if (($conv27482 | 0) < ((HEAPU16[$95 + ($idxprom269 * 12 | 0) + 4 >> 1] | 0) + ($96 & 65535) | 0)) {
        $longest_ext_289 = $longest_ext_1104;
        $mtrx_nd_pos_090 = $96;
        $conv27491 = $conv27482;
       } else {
        $longest_ext_4 = $longest_ext_1104;
        break;
       }
       while (1) {
        __ZN10ime_pinyin12MatrixSearch14extend_mtrx_ndEPNS_10MatrixNodeEPNS_10LmaPsbItemEjtj($this, (HEAP32[$mtrx_nd_pool_ >> 2] | 0) + ($conv27491 << 4) | 0, $arraydecay290, HEAP32[$lpi_total_ >> 2] | 0, (HEAPU16[$dmi_pool_used_292 >> 1] | 0) - $call212 & 65535, HEAP32[$pys_decoded_len_ >> 2] | 0) | 0;
        $ext_len_0_longest_ext_2 = $longest_ext_289 << 16 >> 16 == 0 ? $ext_len_0112 : $longest_ext_289;
        $inc = $mtrx_nd_pos_090 + 1 & 65535;
        $conv274 = $inc & 65535;
        $102 = HEAP32[$matrix_ >> 2] | 0;
        if (($conv274 | 0) < ((HEAPU16[$102 + ($idxprom269 * 12 | 0) + 4 >> 1] | 0) + (HEAPU16[$102 + ($idxprom269 * 12 | 0) >> 1] | 0) | 0)) {
         $longest_ext_289 = $ext_len_0_longest_ext_2;
         $mtrx_nd_pos_090 = $inc;
         $conv27491 = $conv274;
        } else {
         $longest_ext_4 = $ext_len_0_longest_ext_2;
         break;
        }
       }
      }
     } while (0);
     $inc305 = $dmi_pos_0105 + 1 & 65535;
     $conv60 = $inc305 & 65535;
     $105 = HEAP32[$matrix_ >> 2] | 0;
     $add72 = (HEAP16[$105 + ($conv30 * 12 | 0) + 6 >> 1] & 32767) + (HEAPU16[$105 + ($conv30 * 12 | 0) + 2 >> 1] | 0) | 0;
     if (($conv60 | 0) < ($add72 + 1 | 0)) {
      $longest_ext_1104 = $longest_ext_4;
      $dmi_pos_0105 = $inc305;
      $conv60106 = $conv60;
      $add72107 = $add72;
     } else {
      $spl_matched_2_off0 = $spl_matched_0_off0_;
      $longest_ext_5 = $longest_ext_4;
      break;
     }
    }
   }
  } while (0);
  $dec308 = $ext_len_0112 - 1 & 65535;
  if ($dec308 << 16 >> 16 == 0) {
   $spl_matched_0_off0_lcssa = $spl_matched_2_off0;
   label = 1550;
   break;
  } else {
   $ext_len_0112 = $dec308;
   $longest_ext_0115 = $longest_ext_5;
   $spl_matched_0_off0116 = $spl_matched_2_off0;
   $conv117 = $dec308 & 65535;
  }
 }
 if ((label | 0) == 1535) {
  ___assert_func(1184, 1082, 7056, 3088);
  return 0;
 } else if ((label | 0) == 1531) {
  ___assert_func(1184, 1070, 7056, 3176);
  return 0;
 } else if ((label | 0) == 1550) {
  $mtrx_nd_pool_used_ = $this + 84 | 0;
  HEAP16[$mtrx_nd_pool_used_ >> 1] = (HEAP16[$mtrx_nd_pool_used_ >> 1] | 0) + (HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ((HEAP32[$pys_decoded_len_ >> 2] | 0) * 12 | 0) + 4 >> 1] | 0) & 65535;
  if ((HEAP8[$this + 728 | 0] & 1) != 0) {
   $retval_0 = 1;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
  $retval_0 = $spl_matched_0_off0_lcssa | (HEAP16[(HEAP32[$matrix_ >> 2] | 0) + ((HEAP32[$pys_decoded_len_ >> 2] | 0) * 12 | 0) + 4 >> 1] | 0) != 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 1544) {
  ___assert_func(1184, 1106, 7056, 3056);
  return 0;
 }
 return 0;
}
function __ZN10ime_pinyin12MatrixSearch10extend_dmiEPNS_11DictExtParaEPNS_13DictMatchInfoE($this, $dep, $dmi_s) {
 $this = $this | 0;
 $dep = $dep | 0;
 $dmi_s = $dmi_s | 0;
 var $lpi_num = 0, $handles = 0, $dmi_pool_used_ = 0, $call4 = 0, $splids_extended = 0, $3 = 0, $4 = 0, $cached_0_off0 = 0, $lpi_total_ = 0, $from_h_sroa_1_0 = 0, $from_h_sroa_0_0 = 0, $arrayidx23 = 0, $arrayidx24 = 0, $cmp28 = 0, $8 = 0, $call31 = 0, $12 = 0, $15 = 0, $call55 = 0, $20 = 0, $21 = 0, $add_ptr79 = 0, $tobool83 = 0, $conv84 = 0, $add91 = 0, $tobool94 = 0, $add100 = 0, $cond107_off0 = 0, $ret_val_0 = 0, $38 = 0, $arraydecay118 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $lpi_num = sp | 0;
 $handles = sp + 8 | 0;
 $dmi_pool_used_ = $this + 92 | 0;
 if ((HEAPU16[$dmi_pool_used_ >> 1] | 0) > 799) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if ((HEAP8[$this + 728 | 0] & 1) != 0) {
  $retval_0 = __ZN10ime_pinyin12MatrixSearch12extend_dmi_cEPNS_11DictExtParaEPNS_13DictMatchInfoE($this, $dep, $dmi_s) | 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $call4 = __ZN10ime_pinyin8LpiCache12get_instanceEv() | 0;
 $splids_extended = $dep + 80 | 0;
 $3 = HEAP16[$splids_extended >> 1] | 0;
 $4 = HEAP16[$dep + (($3 & 65535) << 1) >> 1] | 0;
 if ($3 << 16 >> 16 == 0) {
  $cached_0_off0 = __ZN10ime_pinyin8LpiCache9is_cachedEt($call4, $4) | 0;
 } else {
  $cached_0_off0 = 0;
 }
 $lpi_total_ = $this + 12500 | 0;
 HEAP32[$lpi_total_ >> 2] = 0;
 if ((HEAP16[$splids_extended >> 1] | 0) == 0) {
  $from_h_sroa_0_0 = 0;
  $from_h_sroa_1_0 = 0;
 } else {
  $from_h_sroa_0_0 = HEAP16[$dmi_s >> 1] | 0;
  $from_h_sroa_1_0 = HEAP16[$dmi_s + 2 >> 1] | 0;
 }
 HEAP32[$lpi_num >> 2] = 0;
 $arrayidx23 = $handles + 2 | 0;
 HEAP16[$arrayidx23 >> 1] = 0;
 $arrayidx24 = $handles | 0;
 HEAP16[$arrayidx24 >> 1] = 0;
 $cmp28 = ($dmi_s | 0) == 0;
 do {
  if ($from_h_sroa_0_0 << 16 >> 16 != 0 | $cmp28) {
   $8 = HEAP32[$this + 12 >> 2] | 0;
   $call31 = FUNCTION_TABLE_iiiiiii[HEAP32[(HEAP32[$8 >> 2] | 0) + 24 >> 2] & 15]($8, $from_h_sroa_0_0, $dep, $this + 900 | 0, 1450, $lpi_num) | 0;
   HEAP16[$arrayidx24 >> 1] = $call31;
   if ($call31 << 16 >> 16 == 0) {
    break;
   }
   HEAP32[$lpi_total_ >> 2] = HEAP32[$lpi_num >> 2];
  }
 } while (0);
 $12 = HEAP32[$this + 16 >> 2] | 0;
 do {
  if (($12 | 0) != 0) {
   if (!($from_h_sroa_1_0 << 16 >> 16 != 0 | $cmp28)) {
    break;
   }
   $15 = HEAP32[$lpi_total_ >> 2] | 0;
   $call55 = FUNCTION_TABLE_iiiiiii[HEAP32[(HEAP32[$12 >> 2] | 0) + 24 >> 2] & 15]($12, $from_h_sroa_1_0, $dep, $this + 900 + ($15 << 3) | 0, 1450 - $15 | 0, $lpi_num) | 0;
   HEAP16[$arrayidx23 >> 1] = $call55;
   if ($call55 << 16 >> 16 == 0) {
    break;
   }
   HEAP32[$lpi_total_ >> 2] = (HEAP32[$lpi_total_ >> 2] | 0) + (HEAP32[$lpi_num >> 2] | 0);
  }
 } while (0);
 if ((HEAP16[$arrayidx24 >> 1] | 0) == 0) {
  if ((HEAP16[$arrayidx23 >> 1] | 0) == 0) {
   $ret_val_0 = 0;
  } else {
   label = 1571;
  }
 } else {
  label = 1571;
 }
 do {
  if ((label | 0) == 1571) {
   $20 = HEAP16[$dmi_pool_used_ >> 1] | 0;
   if (($20 & 65535) > 799) {
    $retval_0 = 0;
    STACKTOP = sp;
    return $retval_0 | 0;
   }
   $21 = HEAP32[$this + 88 >> 2] | 0;
   $add_ptr79 = $21 + (($20 & 65535) * 12 | 0) | 0;
   if ($cmp28) {
    $tobool83 = (HEAP8[$dep + 86 | 0] & 1) != 0;
    $conv84 = HEAP16[$dep + 82 >> 1] & 255;
    __ZN10ime_pinyin12MatrixSearch8fill_dmiEPNS_13DictMatchInfoEPtttthbhh(0, $add_ptr79, $arrayidx24, -1, $4, 0, 1, $tobool83, $conv84, (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$this + 4 >> 2] | 0, $4) | 0) & 1 ^ 1);
    $ret_val_0 = 1;
    break;
   }
   $add91 = (HEAP8[$dmi_s + 8 | 0] & 127) + 1 & 255;
   $tobool94 = (HEAP8[$dep + 86 | 0] & 1) != 0;
   $add100 = (HEAP16[$dep + 82 >> 1] & 255) + ((HEAPU8[$dmi_s + 9 | 0] | 0) >>> 1) & 255;
   if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$this + 4 >> 2] | 0, $4) | 0) {
    $cond107_off0 = 0;
   } else {
    $cond107_off0 = HEAP8[$dmi_s + 10 | 0] & 1;
   }
   __ZN10ime_pinyin12MatrixSearch8fill_dmiEPNS_13DictMatchInfoEPtttthbhh(0, $add_ptr79, $arrayidx24, (($dmi_s - $21 | 0) / 12 | 0) & 65535, $4, 0, $add91, $tobool94, $add100, $cond107_off0);
   $ret_val_0 = 1;
  }
 } while (0);
 if ($cached_0_off0) {
  if (!(__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$this + 4 >> 2] | 0, $4) | 0)) {
   ___assert_func(1184, 1545, 7376, 2520);
   return 0;
  }
  HEAP32[$lpi_total_ >> 2] = __ZN10ime_pinyin8LpiCache9get_cacheEtPNS_10LmaPsbItemEj($call4, $4, $this + 900 | 0, 1450) | 0;
  $retval_0 = $ret_val_0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $38 = HEAP32[$lpi_total_ >> 2] | 0;
 if (($38 | 0) == 0) {
  $retval_0 = $ret_val_0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $arraydecay118 = $this + 900 | 0;
 __ZN10ime_pinyin12MatrixSearch20QsortLmaPsbItemByPsbEPNS_10LmaPsbItemEj(0, $arraydecay118, $38);
 if (!$cmp28) {
  $retval_0 = $ret_val_0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if (!(__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$this + 4 >> 2] | 0, $4) | 0)) {
  $retval_0 = $ret_val_0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP32[$lpi_total_ >> 2] = __ZN10ime_pinyin8LpiCache9put_cacheEtPNS_10LmaPsbItemEj($call4, $4, $arraydecay118, HEAP32[$lpi_total_ >> 2] | 0) | 0;
 $retval_0 = $ret_val_0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin7compareEPKvS1_($a, $b) {
 $a = $a | 0;
 $b = $b | 0;
 return (HEAP32[$a >> 2] | 0) - (HEAP32[$b >> 2] | 0) | 0;
}
function __ZN10ime_pinyin11comp_doubleEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0.0, $3 = 0.0, $retval_0 = 0;
 $1 = +HEAPF64[$p1 >> 3];
 $3 = +HEAPF64[$p2 >> 3];
 if ($1 < $3) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $retval_0 = $1 > $3 | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch9get_pystrEPj($this, $decoded_len) {
 $this = $this | 0;
 $decoded_len = $decoded_len | 0;
 var $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0 | ($decoded_len | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP32[$decoded_len >> 2] = HEAP32[$this + 72 >> 2];
 $retval_0 = $this + 32 | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch20QsortLmaPsbItemByPsbEPNS_10LmaPsbItemEj($this, $lma_buf, $num) {
 $this = $this | 0;
 $lma_buf = $lma_buf | 0;
 $num = $num | 0;
 var $0$0 = 0, $call = 0, $4 = 0, $pos_023 = 0, $6$0 = 0, $call3 = 0, $10 = 0, $11 = 0, $mul = 0, $index_021 = 0, $15 = 0, $16 = 0, $17$1 = 0;
 $0$0 = _llvm_umul_with_overflow_i32($num | 0, 4) | 0;
 $call = __Znaj(tempRet0 ? -1 : $0$0) | 0;
 $4 = $call;
 if (($num | 0) != 0) {
  $pos_023 = 0;
  do {
   HEAP32[$4 + ($pos_023 << 2) >> 2] = (HEAPU16[$lma_buf + ($pos_023 << 3) + 4 >> 1] | 0) << 15 | $pos_023;
   $pos_023 = $pos_023 + 1 | 0;
  } while ($pos_023 >>> 0 < $num >>> 0);
 }
 _qsort2($call | 0, $num | 0, 4, 36);
 $6$0 = _llvm_umul_with_overflow_i32($num | 0, 8) | 0;
 $call3 = __Znaj(tempRet0 ? -1 : $6$0) | 0;
 $10 = $call3;
 $11 = $lma_buf | 0;
 $mul = $num << 3;
 _memcpy($call3 | 0, $11 | 0, $mul) | 0;
 if (($num | 0) != 0) {
  $index_021 = 0;
  do {
   $15 = $10 + ((HEAP32[$4 + ($index_021 << 2) >> 2] & 32767) << 3) | 0;
   $16 = $lma_buf + ($index_021 << 3) | 0;
   $17$1 = HEAP32[$15 + 4 >> 2] | 0;
   HEAP32[$16 >> 2] = HEAP32[$15 >> 2];
   HEAP32[$16 + 4 >> 2] = $17$1;
   $index_021 = $index_021 + 1 | 0;
  } while ($index_021 >>> 0 < $num >>> 0);
 }
 if (($call | 0) != 0) {
  __ZdaPv($call);
 }
 if (($call3 | 0) == 0) {
  return;
 }
 __ZdaPv($call3);
 return;
}
function __ZN10ime_pinyin12MatrixSearch22QsortLmaPsbItemByHanziEPNS_10LmaPsbItemEj($this, $lma_buf, $num) {
 $this = $this | 0;
 $lma_buf = $lma_buf | 0;
 $num = $num | 0;
 var $0$0 = 0, $call = 0, $4 = 0, $pos_023 = 0, $6$0 = 0, $call3 = 0, $10 = 0, $11 = 0, $mul = 0, $index_021 = 0, $15 = 0, $16 = 0, $17$1 = 0;
 $0$0 = _llvm_umul_with_overflow_i32($num | 0, 4) | 0;
 $call = __Znaj(tempRet0 ? -1 : $0$0) | 0;
 $4 = $call;
 if (($num | 0) != 0) {
  $pos_023 = 0;
  do {
   HEAP32[$4 + ($pos_023 << 2) >> 2] = ((HEAPU16[$lma_buf + ($pos_023 << 3) + 6 >> 1] | 0) << 15) + $pos_023;
   $pos_023 = $pos_023 + 1 | 0;
  } while ($pos_023 >>> 0 < $num >>> 0);
 }
 _qsort2($call | 0, $num | 0, 4, 36);
 $6$0 = _llvm_umul_with_overflow_i32($num | 0, 8) | 0;
 $call3 = __Znaj(tempRet0 ? -1 : $6$0) | 0;
 $10 = $call3;
 $11 = $lma_buf | 0;
 $mul = $num << 3;
 _memcpy($call3 | 0, $11 | 0, $mul) | 0;
 if (($num | 0) != 0) {
  $index_021 = 0;
  do {
   $15 = $10 + ((HEAP32[$4 + ($index_021 << 2) >> 2] & 32767) << 3) | 0;
   $16 = $lma_buf + ($index_021 << 3) | 0;
   $17$1 = HEAP32[$15 + 4 >> 2] | 0;
   HEAP32[$16 >> 2] = HEAP32[$15 >> 2];
   HEAP32[$16 + 4 >> 2] = $17$1;
   $index_021 = $index_021 + 1 | 0;
  } while ($index_021 >>> 0 < $num >>> 0);
 }
 if (($call | 0) != 0) {
  __ZdaPv($call);
 }
 if (($call3 | 0) == 0) {
  return;
 }
 __ZdaPv($call3);
 return;
}
function __ZN10ime_pinyin12MatrixSearch13get_spl_startERPKt($this, $spl_start) {
 $this = $this | 0;
 $spl_start = $spl_start | 0;
 __ZN10ime_pinyin12MatrixSearch16get_spl_start_idEv($this);
 HEAP32[$spl_start >> 2] = $this + 736;
 return HEAP32[$this + 732 >> 2] | 0;
}
function __ZN10ime_pinyin12MatrixSearch13inner_predictEPKttPA8_tj($this, $fixed_buf, $fixed_len, $predict_buf, $buf_len) {
 $this = $this | 0;
 $fixed_buf = $fixed_buf | 0;
 $fixed_len = $fixed_len | 0;
 $predict_buf = $predict_buf | 0;
 $buf_len = $buf_len | 0;
 var $npre_items_ = 0, $npre_items_len_ = 0, $conv = 0, $cmp4 = 0, $dict_trie_24 = 0, $user_dict_ = 0, $dict_trie_ = 0, $dict_trie_17 = 0, $len_051 = 0, $res_total_050 = 0, $sub = 0, $nlen_0 = 0, $nearest_n_word_0_off0 = 0, $res_total_1 = 0, $sub23 = 0, $8 = 0, $add_ptr28 = 0, $conv29 = 0, $call32 = 0, $12 = 0, $add_ptr44_sum = 0, $res_this_0 = 0, $add51 = 0, $dec = 0, $res_total_0_lcssa = 0, $call55 = 0, $buf_len_call55 = 0, $i_048 = 0;
 $npre_items_ = $this + 104 | 0;
 $npre_items_len_ = $this + 108 | 0;
 _memset(HEAP32[$npre_items_ >> 2] | 0, 0, (HEAP32[$npre_items_len_ >> 2] | 0) * 20 | 0 | 0);
 $conv = $fixed_len & 65535;
 if ($fixed_len << 16 >> 16 == 0) {
  $res_total_0_lcssa = 0;
 } else {
  $cmp4 = ($fixed_len & 65535) > 1;
  $dict_trie_24 = $this + 12 | 0;
  $user_dict_ = $this + 16 | 0;
  $dict_trie_ = $this + 12 | 0;
  $dict_trie_17 = $this + 12 | 0;
  $res_total_050 = 0;
  $len_051 = $conv;
  while (1) {
   $sub = (HEAP32[$npre_items_len_ >> 2] | 0) - $res_total_050 | 0;
   if ($cmp4 & ($len_051 | 0) == 1 & ($res_total_050 | 0) == 0) {
    $nlen_0 = 2;
    while (1) {
     if ($nlen_0 >>> 0 > $conv >>> 0) {
      $nearest_n_word_0_off0 = 0;
      break;
     }
     if ((__ZN10ime_pinyin8DictTrie12get_lemma_idEPKtt(HEAP32[$dict_trie_ >> 2] | 0, $fixed_buf + ($conv - $nlen_0 << 1) | 0, $nlen_0 & 65535) | 0) == 0) {
      $nlen_0 = $nlen_0 + 1 | 0;
     } else {
      $nearest_n_word_0_off0 = $len_051;
      break;
     }
    }
    $res_total_1 = (__ZN10ime_pinyin8DictTrie16predict_top_lmasEjPNS_12NPredictItemEjj(HEAP32[$dict_trie_17 >> 2] | 0, $nearest_n_word_0_off0, (HEAP32[$npre_items_ >> 2] | 0) + ($res_total_050 * 20 | 0) | 0, $sub, $res_total_050) | 0) + $res_total_050 | 0;
   } else {
    $res_total_1 = $res_total_050;
   }
   $sub23 = (HEAP32[$npre_items_len_ >> 2] | 0) - $res_total_1 | 0;
   $8 = HEAP32[$dict_trie_24 >> 2] | 0;
   $add_ptr28 = $fixed_buf + ($conv - $len_051 << 1) | 0;
   $conv29 = $len_051 & 65535;
   $call32 = FUNCTION_TABLE_iiiiiii[HEAP32[(HEAP32[$8 >> 2] | 0) + 40 >> 2] & 15]($8, $add_ptr28, $conv29, (HEAP32[$npre_items_ >> 2] | 0) + ($res_total_1 * 20 | 0) | 0, $sub23, $res_total_1) | 0;
   $12 = HEAP32[$user_dict_ >> 2] | 0;
   if (($12 | 0) == 0) {
    $res_this_0 = $call32;
   } else {
    $add_ptr44_sum = $call32 + $res_total_1 | 0;
    $res_this_0 = (FUNCTION_TABLE_iiiiiii[HEAP32[(HEAP32[$12 >> 2] | 0) + 40 >> 2] & 15]($12, $add_ptr28, $conv29, (HEAP32[$npre_items_ >> 2] | 0) + ($add_ptr44_sum * 20 | 0) | 0, $sub23 - $call32 | 0, $add_ptr44_sum) | 0) + $call32 | 0;
   }
   $add51 = $res_this_0 + $res_total_1 | 0;
   $dec = $len_051 - 1 | 0;
   if (($dec | 0) == 0) {
    $res_total_0_lcssa = $add51;
    break;
   } else {
    $res_total_050 = $add51;
    $len_051 = $dec;
   }
  }
 }
 $call55 = __ZN10ime_pinyin21remove_duplicate_npreEPNS_12NPredictItemEj(HEAP32[$npre_items_ >> 2] | 0, $res_total_0_lcssa) | 0;
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E(HEAP32[$npre_items_ >> 2] | 0, $call55, 20, 4);
 $buf_len_call55 = $call55 >>> 0 > $buf_len >>> 0 ? $buf_len : $call55;
 if (($buf_len_call55 | 0) == 0) {
  return $buf_len_call55 | 0;
 } else {
  $i_048 = 0;
 }
 do {
  _utf16_strncpy($predict_buf + ($i_048 << 4) | 0, (HEAP32[$npre_items_ >> 2] | 0) + ($i_048 * 20 | 0) + 4 | 0, 7) | 0;
  HEAP16[$predict_buf + ($i_048 << 4) + 14 >> 1] = 0;
  $i_048 = $i_048 + 1 | 0;
 } while ($i_048 >>> 0 < $buf_len_call55 >>> 0);
 return $buf_len_call55 | 0;
}
function __ZN10ime_pinyin12MatrixSearch12get_predictsEPKtPA8_tj($this, $fixed_buf, $predict_buf, $buf_len) {
 $this = $this | 0;
 $fixed_buf = $fixed_buf | 0;
 $predict_buf = $predict_buf | 0;
 $buf_len = $buf_len | 0;
 var $call = 0, $retval_0 = 0;
 $call = _utf16_strlen($fixed_buf) | 0;
 if (($call | 0) == 0 | $call >>> 0 > 7 | ($buf_len | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12MatrixSearch13inner_predictEPKttPA8_tj($this, $fixed_buf, $call & 65535, $predict_buf, $buf_len) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin15qsearch_nearestEPddii($code_book, $freq, $start, $end) {
 $code_book = $code_book | 0;
 $freq = +$freq;
 $start = $start | 0;
 $end = $end | 0;
 var $end_tr23 = 0, $start_tr22 = 0, $call = 0.0, $div = 0, $cmp11 = 0, $start_tr_div = 0, $div_end_tr = 0, $retval_0 = 0, label = 0;
 if (($start | 0) == ($end | 0)) {
  $retval_0 = $start;
  return $retval_0 | 0;
 } else {
  $start_tr22 = $start;
  $end_tr23 = $end;
 }
 while (1) {
  if (($start_tr22 + 1 | 0) == ($end_tr23 | 0)) {
   break;
  }
  $div = ($end_tr23 + $start_tr22 | 0) / 2 | 0;
  $cmp11 = +HEAPF64[$code_book + ($div << 3) >> 3] > $freq;
  $start_tr_div = $cmp11 ? $start_tr22 : $div;
  $div_end_tr = $cmp11 ? $div : $end_tr23;
  if (($start_tr_div | 0) == ($div_end_tr | 0)) {
   $retval_0 = $start_tr_div;
   label = 1654;
   break;
  } else {
   $start_tr22 = $start_tr_div;
   $end_tr23 = $div_end_tr;
  }
 }
 if ((label | 0) == 1654) {
  return $retval_0 | 0;
 }
 $call = +__ZN10ime_pinyin8distanceEdd($freq, +HEAPF64[$code_book + ($end_tr23 << 3) >> 3]);
 $retval_0 = $call > +__ZN10ime_pinyin8distanceEdd($freq, +HEAPF64[$code_book + ($start_tr22 << 3) >> 3]) ? $start_tr22 : $end_tr23;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8distanceEdd($freq, $code) {
 $freq = +$freq;
 $code = +$code;
 var $call = 0.0;
 $call = +Math_log(+$freq);
 return +(+Math_abs(+($call - +Math_log(+$code))) * $freq);
}
function __ZN10ime_pinyin15update_code_idxEPdjS0_Ph($freqs, $num, $code_book, $code_idx) {
 $freqs = $freqs | 0;
 $num = $num | 0;
 $code_book = $code_book | 0;
 $code_idx = $code_idx | 0;
 var $changed_010 = 0, $pos_09 = 0, $conv = 0, $arrayidx2 = 0, $changed_0_inc = 0, $inc6 = 0, $changed_0_lcssa = 0;
 if (($num | 0) == 0) {
  $changed_0_lcssa = 0;
  return $changed_0_lcssa | 0;
 } else {
  $pos_09 = 0;
  $changed_010 = 0;
 }
 while (1) {
  $conv = (__ZN10ime_pinyin15qsearch_nearestEPddii($code_book, +HEAPF64[$freqs + ($pos_09 << 3) >> 3], 0, 255) | 0) & 255;
  $arrayidx2 = $code_idx + $pos_09 | 0;
  $changed_0_inc = ((HEAP8[$arrayidx2] | 0) != $conv << 24 >> 24) + $changed_010 | 0;
  HEAP8[$arrayidx2] = $conv;
  $inc6 = $pos_09 + 1 | 0;
  if ($inc6 >>> 0 < $num >>> 0) {
   $pos_09 = $inc6;
   $changed_010 = $changed_0_inc;
  } else {
   $changed_0_lcssa = $changed_0_inc;
   break;
  }
 }
 return $changed_0_lcssa | 0;
}
function __ZN10ime_pinyin13iterate_codesEPdjS0_Ph($freqs, $num, $code_book, $code_idx) {
 $freqs = $freqs | 0;
 $num = $num | 0;
 $code_book = $code_book | 0;
 $code_idx = $code_idx | 0;
 var $delta_last_0 = 0.0, $iter_num_0 = 0, $call1 = 0.0, $call3 = 0.0, label = 0;
 $iter_num_0 = 1;
 $delta_last_0 = 0.0;
 while (1) {
  __ZN10ime_pinyin15update_code_idxEPdjS0_Ph($freqs, $num, $code_book, $code_idx) | 0;
  $call1 = +__ZN10ime_pinyin18recalculate_kernelEPdjS0_Ph($freqs, $num, $code_book, $code_idx);
  if ($iter_num_0 >>> 0 > 1) {
   if ($call1 == 0.0) {
    label = 1668;
    break;
   }
   $call3 = +Math_abs(+($delta_last_0 - $call1));
   if ($call3 / +Math_abs(+$call1) < 1.0e-9) {
    label = 1667;
    break;
   }
  }
  $iter_num_0 = $iter_num_0 + 1 | 0;
  $delta_last_0 = $call1;
 }
 if ((label | 0) == 1668) {
  return;
 } else if ((label | 0) == 1667) {
  return;
 }
}
function __ZN10ime_pinyin5NGramC2Ev($this) {
 $this = $this | 0;
 HEAP8[$this | 0] = 0;
 HEAP32[$this + 4 >> 2] = 0;
 _memset($this + 12 | 0, 0, 16);
 return;
}
function __ZN10ime_pinyin12MatrixSearch8get_lpisEPKtjPNS_10LmaPsbItemEjS2_b($this, $splid_str, $splid_str_len, $lma_buf, $max_lma_buf, $pfullsent, $sort_by_psb) {
 $this = $this | 0;
 $splid_str = $splid_str | 0;
 $splid_str_len = $splid_str_len | 0;
 $lma_buf = $lma_buf | 0;
 $max_lma_buf = $max_lma_buf | 0;
 $pfullsent = $pfullsent | 0;
 $sort_by_psb = $sort_by_psb | 0;
 var $hanzis = 0, $0 = 0, $conv = 0, $call = 0, $3 = 0, $num2_0 = 0, $add = 0, $arraydecay83 = 0, $add_ptr15 = 0, $6 = 0, $div = 0, $div_add = 0, $pos_0105 = 0, $arrayidx22 = 0, $8 = 0, $9 = 0, $10$1 = 0, $cmp61 = 0, $pos26_0102 = 0, $remain_num_0101 = 0, $sub34 = 0, $18 = 0, $19 = 0, $20$1 = 0, $23 = 0, $24 = 0, $25$1 = 0, $remain_num_1 = 0, $inc75 = 0, $pos77_0115 = 0, $cmp149 = 0, $arrayidx151 = 0, $cmp106 = 0, $arrayidx108 = 0, $pos91_0111 = 0, $remain_num90_0110 = 0, $hanzi98 = 0, $29 = 0, $sub100 = 0, $sub133 = 0, $39 = 0, $40 = 0, $41$1 = 0, $47 = 0, $48 = 0, $49$1 = 0, $remain_num90_1 = 0, $inc167 = 0, $num_1 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $hanzis = sp | 0;
 if ($splid_str_len >>> 0 > 8) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $0 = HEAP32[$this + 12 >> 2] | 0;
 $conv = $splid_str_len & 65535;
 $call = FUNCTION_TABLE_iiiiii[HEAP32[(HEAP32[$0 >> 2] | 0) + 28 >> 2] & 15]($0, $splid_str, $conv, $lma_buf, $max_lma_buf) | 0;
 $3 = HEAP32[$this + 16 >> 2] | 0;
 if (($3 | 0) == 0) {
  $num2_0 = 0;
 } else {
  $num2_0 = FUNCTION_TABLE_iiiiii[HEAP32[(HEAP32[$3 >> 2] | 0) + 28 >> 2] & 15]($3, $splid_str, $conv, $lma_buf + ($call << 3) | 0, $max_lma_buf - $call | 0) | 0;
 }
 $add = $num2_0 + $call | 0;
 if (($add | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 L2134 : do {
  if ($splid_str_len >>> 0 > 1) {
   $add_ptr15 = $lma_buf + ($add << 3) | 0;
   $6 = $add_ptr15;
   $div = ($max_lma_buf - $add << 3 >>> 0) / 28 | 0;
   if ($div >>> 0 <= $add >>> 0) {
    ___assert_func(1184, 1760, 6648, 2304);
    return 0;
   }
   $div_add = $add >>> 0 > $div >>> 0 ? $div : $add;
   if (($div_add | 0) == 0) {
    __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($add_ptr15 | 0, $div_add, 28, 26);
    $num_1 = 0;
    break;
   } else {
    $pos_0105 = 0;
   }
   do {
    $arrayidx22 = $lma_buf + ($pos_0105 << 3) | 0;
    $8 = $arrayidx22;
    $9 = $6 + ($pos_0105 * 28 | 0) | 0;
    $10$1 = HEAP32[$8 + 4 >> 2] | 0;
    HEAP32[$9 >> 2] = HEAP32[$8 >> 2];
    HEAP32[$9 + 4 >> 2] = $10$1;
    __ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, HEAP32[$arrayidx22 >> 2] & 16777215, $6 + ($pos_0105 * 28 | 0) + 8 | 0, 9) | 0;
    $pos_0105 = $pos_0105 + 1 | 0;
   } while ($pos_0105 >>> 0 < $div_add >>> 0);
   __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($add_ptr15 | 0, $div_add, 28, 26);
   if (($div_add | 0) == 0) {
    $num_1 = 0;
    break;
   }
   $cmp61 = ($pfullsent | 0) == 0;
   $remain_num_0101 = 0;
   $pos26_0102 = 0;
   L2145 : while (1) {
    do {
     if (($pos26_0102 | 0) == 0) {
      label = 1691;
     } else {
      $sub34 = $pos26_0102 - 1 | 0;
      if ((_utf16_strcmp($6 + ($pos26_0102 * 28 | 0) + 8 | 0, $6 + ($sub34 * 28 | 0) + 8 | 0) | 0) != 0) {
       label = 1691;
       break;
      }
      if ((HEAPU16[$6 + ($pos26_0102 * 28 | 0) + 4 >> 1] | 0) >= (HEAPU16[$6 + ($sub34 * 28 | 0) + 4 >> 1] | 0)) {
       $remain_num_1 = $remain_num_0101;
       break;
      }
      if (($remain_num_0101 | 0) == 0) {
       break L2145;
      }
      $18 = $6 + ($pos26_0102 * 28 | 0) | 0;
      $19 = $lma_buf + ($remain_num_0101 - 1 << 3) | 0;
      $20$1 = HEAP32[$18 + 4 >> 2] | 0;
      HEAP32[$19 >> 2] = HEAP32[$18 >> 2];
      HEAP32[$19 + 4 >> 2] = $20$1;
      $remain_num_1 = $remain_num_0101;
     }
    } while (0);
    do {
     if ((label | 0) == 1691) {
      label = 0;
      if (!$cmp61) {
       if ((_utf16_strcmp($6 + ($pos26_0102 * 28 | 0) + 8 | 0, $pfullsent) | 0) == 0) {
        $remain_num_1 = $remain_num_0101;
        break;
       }
      }
      $23 = $6 + ($pos26_0102 * 28 | 0) | 0;
      $24 = $lma_buf + ($remain_num_0101 << 3) | 0;
      $25$1 = HEAP32[$23 + 4 >> 2] | 0;
      HEAP32[$24 >> 2] = HEAP32[$23 >> 2];
      HEAP32[$24 + 4 >> 2] = $25$1;
      $remain_num_1 = $remain_num_0101 + 1 | 0;
     }
    } while (0);
    $inc75 = $pos26_0102 + 1 | 0;
    if ($inc75 >>> 0 < $div_add >>> 0) {
     $remain_num_0101 = $remain_num_1;
     $pos26_0102 = $inc75;
    } else {
     $num_1 = $remain_num_1;
     break L2134;
    }
   }
   ___assert_func(1184, 1775, 6648, 2248);
   return 0;
  } else {
   if (($add | 0) == 0) {
    __ZN10ime_pinyin12MatrixSearch22QsortLmaPsbItemByHanziEPNS_10LmaPsbItemEj(0, $lma_buf, $add);
    $num_1 = 0;
    break;
   }
   $arraydecay83 = $hanzis | 0;
   $pos77_0115 = 0;
   do {
    __ZN10ime_pinyin12MatrixSearch13get_lemma_strEjPtt($this, HEAP32[$lma_buf + ($pos77_0115 << 3) >> 2] & 16777215, $arraydecay83, 2) | 0;
    HEAP16[$lma_buf + ($pos77_0115 << 3) + 6 >> 1] = HEAP16[$arraydecay83 >> 1] | 0;
    $pos77_0115 = $pos77_0115 + 1 | 0;
   } while ($pos77_0115 >>> 0 < $add >>> 0);
   __ZN10ime_pinyin12MatrixSearch22QsortLmaPsbItemByHanziEPNS_10LmaPsbItemEj(0, $lma_buf, $add);
   if (($add | 0) == 0) {
    $num_1 = 0;
    break;
   }
   $cmp149 = ($pfullsent | 0) == 0;
   $arrayidx151 = $pfullsent + 2 | 0;
   $cmp106 = ($pfullsent | 0) == 0;
   $arrayidx108 = $pfullsent + 2 | 0;
   $remain_num90_0110 = 0;
   $pos91_0111 = 0;
   L2167 : while (1) {
    L2169 : do {
     if (($pos91_0111 | 0) == 0) {
      label = 1709;
     } else {
      $hanzi98 = $lma_buf + ($pos91_0111 << 3) + 6 | 0;
      $29 = HEAP16[$hanzi98 >> 1] | 0;
      $sub100 = $pos91_0111 - 1 | 0;
      if ($29 << 16 >> 16 != (HEAP16[$lma_buf + ($sub100 << 3) + 6 >> 1] | 0)) {
       label = 1709;
       break;
      }
      do {
       if (!$cmp106) {
        if ((HEAP16[$arrayidx108 >> 1] | 0) != 0) {
         break;
        }
        if ($29 << 16 >> 16 == (HEAP16[$pfullsent >> 1] | 0)) {
         $remain_num90_1 = $remain_num90_0110;
         break L2169;
        }
       }
      } while (0);
      if ((HEAPU16[$lma_buf + ($pos91_0111 << 3) + 4 >> 1] | 0) >= (HEAPU16[$lma_buf + ($sub100 << 3) + 4 >> 1] | 0)) {
       $remain_num90_1 = $remain_num90_0110;
       break;
      }
      if (($remain_num90_0110 | 0) == 0) {
       label = 1705;
       break L2167;
      }
      $sub133 = $remain_num90_0110 - 1 | 0;
      if ((HEAP16[$lma_buf + ($sub133 << 3) + 6 >> 1] | 0) != (HEAP16[$hanzi98 >> 1] | 0)) {
       label = 1707;
       break L2167;
      }
      $39 = $lma_buf + ($pos91_0111 << 3) | 0;
      $40 = $lma_buf + ($sub133 << 3) | 0;
      $41$1 = HEAP32[$39 + 4 >> 2] | 0;
      HEAP32[$40 >> 2] = HEAP32[$39 >> 2];
      HEAP32[$40 + 4 >> 2] = $41$1;
      $remain_num90_1 = $remain_num90_0110;
     }
    } while (0);
    L2179 : do {
     if ((label | 0) == 1709) {
      label = 0;
      do {
       if (!$cmp149) {
        if ((HEAP16[$arrayidx151 >> 1] | 0) != 0) {
         break;
        }
        if ((HEAP16[$lma_buf + ($pos91_0111 << 3) + 6 >> 1] | 0) == (HEAP16[$pfullsent >> 1] | 0)) {
         $remain_num90_1 = $remain_num90_0110;
         break L2179;
        }
       }
      } while (0);
      $47 = $lma_buf + ($pos91_0111 << 3) | 0;
      $48 = $lma_buf + ($remain_num90_0110 << 3) | 0;
      $49$1 = HEAP32[$47 + 4 >> 2] | 0;
      HEAP32[$48 >> 2] = HEAP32[$47 >> 2];
      HEAP32[$48 + 4 >> 2] = $49$1;
      $remain_num90_1 = $remain_num90_0110 + 1 | 0;
     }
    } while (0);
    $inc167 = $pos91_0111 + 1 | 0;
    if ($inc167 >>> 0 < $add >>> 0) {
     $remain_num90_0110 = $remain_num90_1;
     $pos91_0111 = $inc167;
    } else {
     $num_1 = $remain_num90_1;
     break L2134;
    }
   }
   if ((label | 0) == 1705) {
    ___assert_func(1184, 1811, 6648, 2248);
    return 0;
   } else if ((label | 0) == 1707) {
    ___assert_func(1184, 1812, 6648, 2144);
    return 0;
   }
  }
 } while (0);
 if (!$sort_by_psb) {
  $retval_0 = $num_1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin12MatrixSearch20QsortLmaPsbItemByPsbEPNS_10LmaPsbItemEj(0, $lma_buf, $num_1);
 $retval_0 = $num_1;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12MatrixSearch12extend_dmi_cEPNS_11DictExtParaEPNS_13DictMatchInfoE($this, $dep, $dmi_s) {
 $this = $this | 0;
 $dep = $dep | 0;
 $dmi_s = $dmi_s | 0;
 var $lpi_total_ = 0, $2 = 0, $conv = 0, $length = 0, $4 = 0, $6 = 0, $add_ptr = 0, $arraydecay = 0, $tobool13 = 0, $conv14 = 0, $add = 0, $tobool22 = 0, $add28 = 0, $cond38_off0 = 0, $25 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $lpi_total_ = $this + 12500 | 0;
 HEAP32[$lpi_total_ >> 2] = 0;
 if ((HEAP8[$this + 728 | 0] & 1) == 0) {
  ___assert_func(1184, 1556, 7296, 2440);
  return 0;
 }
 $2 = HEAP16[$dep + 80 >> 1] | 0;
 $conv = $2 & 65535;
 $length = $this + 724 | 0;
 if (($2 & 65535) >= (HEAPU16[$length >> 1] | 0)) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $4 = HEAP16[$dep + ($conv << 1) >> 1] | 0;
 if ($4 << 16 >> 16 != (HEAP16[$this + 400 + ($conv << 1) >> 1] | 0)) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $6 = HEAP32[$this + 88 >> 2] | 0;
 $add_ptr = $6 + ((HEAPU16[$this + 92 >> 1] | 0) * 12 | 0) | 0;
 $arraydecay = sp | 0;
 if (($dmi_s | 0) == 0) {
  $tobool13 = (HEAP8[$dep + 86 | 0] & 1) != 0;
  $conv14 = HEAP16[$dep + 82 >> 1] & 255;
  __ZN10ime_pinyin12MatrixSearch8fill_dmiEPNS_13DictMatchInfoEPtttthbhh(0, $add_ptr, $arraydecay, -1, $4, 0, 1, $tobool13, $conv14, (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$this + 4 >> 2] | 0, $4) | 0) & 1 ^ 1);
 } else {
  $add = (HEAP8[$dmi_s + 8 | 0] & 127) + 1 & 255;
  $tobool22 = (HEAP8[$dep + 86 | 0] & 1) != 0;
  $add28 = (HEAP16[$dep + 82 >> 1] & 255) + ((HEAPU8[$dmi_s + 9 | 0] | 0) >>> 1) & 255;
  if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt(HEAP32[$this + 4 >> 2] | 0, $4) | 0) {
   $cond38_off0 = 0;
  } else {
   $cond38_off0 = HEAP8[$dmi_s + 10 | 0] & 1;
  }
  __ZN10ime_pinyin12MatrixSearch8fill_dmiEPNS_13DictMatchInfoEPtttthbhh(0, $add_ptr, $arraydecay, (($dmi_s - $6 | 0) / 12 | 0) & 65535, $4, 0, $add, $tobool22, $add28, $cond38_off0);
 }
 if (($conv | 0) != ((HEAPU16[$length >> 1] | 0) - 1 | 0)) {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $25 = $this + 900 | 0;
 HEAP32[$25 >> 2] = HEAP32[$25 >> 2] | 16777215;
 HEAP16[$this + 904 >> 1] = 0;
 HEAP32[$lpi_total_ >> 2] = 1;
 $retval_0 = 1;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin18recalculate_kernelEPdjS0_Ph($freqs, $num, $code_book, $code_idx) {
 $freqs = $freqs | 0;
 $num = $num | 0;
 $code_book = $code_book | 0;
 $code_idx = $code_idx | 0;
 var $call = 0, $0 = 0, $tobool = 0, $call1 = 0, $1 = 0, $tobool2 = 0, $ret_0_lcssa = 0.0, $pos_029 = 0, $ret_028 = 0.0, $2 = 0.0, $arrayidx6 = 0, $idxprom = 0, $add = 0.0, $arrayidx12 = 0, $arrayidx16 = 0, $inc = 0, $code_026 = 0, $8 = 0, label = 0;
 $call = __Znaj(1024) | 0;
 $0 = $call;
 $tobool = ($call | 0) == 0;
 if ($tobool) {
  ___assert_func(4024, 79, 6240, 4232);
  return 0.0;
 }
 _memset($call | 0, 0, 1024);
 $call1 = __Znaj(2048) | 0;
 $1 = $call1;
 $tobool2 = ($call1 | 0) == 0;
 if ($tobool2) {
  ___assert_func(4024, 83, 6240, 2920);
  return 0.0;
 }
 _memset($call1 | 0, 0, 2048);
 if (($num | 0) == 0) {
  $ret_0_lcssa = 0.0;
 } else {
  $ret_028 = 0.0;
  $pos_029 = 0;
  while (1) {
   $2 = +HEAPF64[$freqs + ($pos_029 << 3) >> 3];
   $arrayidx6 = $code_idx + $pos_029 | 0;
   $idxprom = HEAPU8[$arrayidx6] | 0;
   $add = $ret_028 + +__ZN10ime_pinyin8distanceEdd($2, +HEAPF64[$code_book + ($idxprom << 3) >> 3]);
   $arrayidx12 = $1 + ($idxprom << 3) | 0;
   HEAPF64[$arrayidx12 >> 3] = $2 + +HEAPF64[$arrayidx12 >> 3];
   $arrayidx16 = $0 + ((HEAPU8[$arrayidx6] | 0) << 2) | 0;
   HEAP32[$arrayidx16 >> 2] = (HEAP32[$arrayidx16 >> 2] | 0) + 1;
   $inc = $pos_029 + 1 | 0;
   if ($inc >>> 0 < $num >>> 0) {
    $ret_028 = $add;
    $pos_029 = $inc;
   } else {
    $ret_0_lcssa = $add;
    break;
   }
  }
 }
 $code_026 = 0;
 do {
  $8 = HEAP32[$0 + ($code_026 << 2) >> 2] | 0;
  if (($8 | 0) == 0) {
   label = 1745;
   break;
  }
  HEAPF64[$code_book + ($code_026 << 3) >> 3] = +HEAPF64[$1 + ($code_026 << 3) >> 3] / +($8 >>> 0 >>> 0);
  $code_026 = $code_026 + 1 | 0;
 } while ($code_026 >>> 0 < 256);
 if ((label | 0) == 1745) {
  ___assert_func(4024, 94, 6240, 2008);
  return 0.0;
 }
 if (!$tobool) {
  __ZdaPv($call);
 }
 if ($tobool2) {
  return +$ret_0_lcssa;
 }
 __ZdaPv($call1);
 return +$ret_0_lcssa;
}
function __ZN10ime_pinyin15is_system_lemmaEj($lma_id) {
 $lma_id = $lma_id | 0;
 return $lma_id >>> 0 < 500001 & ($lma_id | 0) != 0 | 0;
}
function __ZN10ime_pinyin13is_user_lemmaEj($lma_id) {
 $lma_id = $lma_id | 0;
 return ($lma_id - 500001 | 0) >>> 0 < 1e5 | 0;
}
function __ZN10ime_pinyin18is_composing_lemmaEj($lma_id) {
 $lma_id = $lma_id | 0;
 return ($lma_id | 0) == 16777215 | 0;
}
function __ZN10ime_pinyin15align_to_size_tEj($size) {
 $size = $size | 0;
 return $size + 3 & -4 | 0;
}
function __ZN10ime_pinyin15cmp_lpi_with_idEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $bf_clear = 0, $bf_clear1 = 0, $retval_0 = 0;
 $bf_clear = HEAP32[$p1 >> 2] & 16777215;
 $bf_clear1 = HEAP32[$p2 >> 2] & 16777215;
 if ($bf_clear >>> 0 < $bf_clear1 >>> 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $retval_0 = $bf_clear >>> 0 > $bf_clear1 >>> 0 | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_1EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $retval_0 = 0;
 $1 = HEAP16[$p1 >> 1] | 0;
 $3 = HEAP16[$p2 >> 1] | 0;
 if (($1 & 65535) < ($3 & 65535)) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $retval_0 = ($1 & 65535) > ($3 & 65535) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin17cmp_npre_by_scoreEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $0 = 0.0, $1 = 0.0, $retval_0 = 0;
 $0 = +HEAPF32[$p1 >> 2];
 $1 = +HEAPF32[$p2 >> 2];
 if ($0 > $1) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $retval_0 = ($0 < $1) << 31 >> 31;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin5NGram11get_uni_psbEj($this, $lma_id) {
 $this = $this | 0;
 $lma_id = $lma_id | 0;
 return +(+((HEAPU16[(HEAP32[$this + 20 >> 2] | 0) + ((HEAPU8[(HEAP32[$this + 24 >> 2] | 0) + $lma_id | 0] | 0) << 1) >> 1] | 0) >>> 0) + +HEAPF32[$this + 12 >> 2]);
}
function __ZN10ime_pinyin16cmp_lpi_with_psbEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $retval_0 = 0;
 $1 = HEAP16[$p1 + 4 >> 1] | 0;
 $3 = HEAP16[$p2 + 4 >> 1] | 0;
 if (($1 & 65535) > ($3 & 65535)) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $retval_0 = (($1 & 65535) < ($3 & 65535)) << 31 >> 31;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin24cmp_lpi_with_unified_psbEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $mul = 0, $mul4 = 0, $retval_0 = 0;
 $mul = Math_imul((HEAP32[$p2 >> 2] | 0) >>> 24 & 15, HEAPU16[$p1 + 4 >> 1] | 0) | 0;
 $mul4 = Math_imul((HEAP32[$p1 >> 2] | 0) >>> 24 & 15, HEAPU16[$p2 + 4 >> 1] | 0) | 0;
 if ($mul >>> 0 < $mul4 >>> 0) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $retval_0 = $mul >>> 0 > $mul4 >>> 0 | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin18cmp_lpi_with_hanziEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $retval_0 = 0;
 $1 = HEAP16[$p1 + 6 >> 1] | 0;
 $3 = HEAP16[$p2 + 6 >> 1] | 0;
 if (($1 & 65535) < ($3 & 65535)) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 $retval_0 = ($1 & 65535) > ($3 & 65535) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin24cmp_npre_by_hislen_scoreEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $1 = 0, $3 = 0, $4 = 0.0, $5 = 0.0, $retval_0 = 0;
 $1 = HEAP16[$p1 + 18 >> 1] | 0;
 $3 = HEAP16[$p2 + 18 >> 1] | 0;
 do {
  if (($1 & 65535) < ($3 & 65535)) {
   $retval_0 = 1;
  } else {
   if (($1 & 65535) > ($3 & 65535)) {
    $retval_0 = -1;
    break;
   }
   $4 = +HEAPF32[$p1 >> 2];
   $5 = +HEAPF32[$p2 >> 2];
   if ($4 > $5) {
    $retval_0 = 1;
    break;
   }
   $retval_0 = ($4 < $5) << 31 >> 31;
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin5NGramD2Ev($this) {
 $this = $this | 0;
 var $0 = 0, $1 = 0, $3 = 0;
 $0 = HEAP32[$this + 24 >> 2] | 0;
 if (($0 | 0) != 0) {
  _free($0);
 }
 $1 = HEAP32[$this + 16 >> 2] | 0;
 if (($1 | 0) != 0) {
  _free($1);
 }
 $3 = HEAP32[$this + 20 >> 2] | 0;
 if (($3 | 0) == 0) {
  return;
 }
 _free($3);
 return;
}
function __ZN10ime_pinyin5NGram12get_instanceEv() {
 var $1 = 0;
 if ((HEAP32[11854] | 0) == 0) {
  $1 = __Znwj(28) | 0;
  __ZN10ime_pinyin5NGramC2Ev($1);
  HEAP32[11854] = $1;
 }
 return HEAP32[11854] | 0;
}
function __ZN10ime_pinyin5NGram10save_ngramEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $idx_num_ = 0, $freq_codes_ = 0, $lma_freq_idx_ = 0, $call20 = 0, $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0 | ($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $idx_num_ = $this + 4 | 0;
 if ((HEAP32[$idx_num_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $freq_codes_ = $this + 20 | 0;
 if ((HEAP32[$freq_codes_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_freq_idx_ = $this + 24 | 0;
 if ((HEAP32[$lma_freq_idx_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($idx_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite(HEAP32[$freq_codes_ >> 2] | 0, 2, 256, $fp | 0) | 0) != 256) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call20 = _fwrite(HEAP32[$lma_freq_idx_ >> 2] | 0, 1, HEAP32[$idx_num_ >> 2] | 0, $fp | 0) | 0;
 $retval_0 = ($call20 | 0) == (HEAP32[$idx_num_ >> 2] | 0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin5NGram10load_ngramEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $initialized_ = 0, $idx_num_ = 0, $lma_freq_idx_ = 0, $1 = 0, $freq_codes_ = 0, $2 = 0, $call16 = 0, $call31 = 0, $retval_0 = 0;
 if (($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $initialized_ = $this | 0;
 HEAP8[$initialized_] = 0;
 $idx_num_ = $this + 4 | 0;
 if ((_fread($idx_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $lma_freq_idx_ = $this + 24 | 0;
 $1 = HEAP32[$lma_freq_idx_ >> 2] | 0;
 if (($1 | 0) != 0) {
  _free($1);
 }
 $freq_codes_ = $this + 20 | 0;
 $2 = HEAP32[$freq_codes_ >> 2] | 0;
 if (($2 | 0) != 0) {
  _free($2);
 }
 HEAP32[$lma_freq_idx_ >> 2] = _malloc(HEAP32[$idx_num_ >> 2] | 0) | 0;
 $call16 = _malloc(512) | 0;
 HEAP32[$freq_codes_ >> 2] = $call16;
 if ((HEAP32[$lma_freq_idx_ >> 2] | 0) == 0 | ($call16 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fread($call16 | 0, 2, 256, $fp | 0) | 0) != 256) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call31 = _fread(HEAP32[$lma_freq_idx_ >> 2] | 0, 1, HEAP32[$idx_num_ >> 2] | 0, $fp | 0) | 0;
 if (($call31 | 0) != (HEAP32[$idx_num_ >> 2] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP8[$initialized_] = 1;
 HEAP32[$this + 8 >> 2] = 0;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin5NGram23set_total_freq_none_sysEj($this, $freq_none_sys) {
 $this = $this | 0;
 $freq_none_sys = $freq_none_sys | 0;
 HEAP32[$this + 8 >> 2] = $freq_none_sys;
 if (($freq_none_sys | 0) == 0) {
  HEAPF32[$this + 12 >> 2] = 0.0;
  return;
 } else {
  HEAPF32[$this + 12 >> 2] = +Math_log(+(1.0e8 / +(($freq_none_sys + 1e8 | 0) >>> 0 >>> 0))) * -800.0;
  return;
 }
}
function __ZN10ime_pinyin5NGram20convert_psb_to_scoreEd($psb) {
 $psb = +$psb;
 var $conv = 0.0;
 $conv = +Math_log(+$psb) * -800.0;
 return +($conv > 16383.0 ? 16383.0 : $conv);
}
function __ZN10ime_pinyin17cmp_lpsi_with_strEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strcmp($p1 + 8 | 0, $p2 + 8 | 0) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_2EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 2) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_3EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 3) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_4EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 4) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_5EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 5) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_6EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 6) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_7EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 7) | 0;
}
function __ZN10ime_pinyin12cmp_hanzis_8EPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _utf16_strncmp($p1, $p2, 8) | 0;
}
function __ZN10ime_pinyin23cmp_npre_by_hanzi_scoreEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $call = 0, $0 = 0.0, $1 = 0.0, $retval_0 = 0;
 $call = _utf16_strncmp($p1 + 4 | 0, $p2 + 4 | 0, 7) | 0;
 if (($call | 0) != 0) {
  $retval_0 = $call;
  return $retval_0 | 0;
 }
 $0 = +HEAPF32[$p1 >> 2];
 $1 = +HEAPF32[$p2 >> 2];
 if ($0 > $1) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $retval_0 = ($0 < $1) << 31 >> 31;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin21remove_duplicate_npreEPNS_12NPredictItemEj($npre_items, $npre_num) {
 $npre_items = $npre_items | 0;
 $npre_num = $npre_num | 0;
 var $pos_018 = 0, $remain_num_017 = 0, $arrayidx = 0, $1 = 0, $2 = 0, $remain_num_1 = 0, $inc14 = 0, $retval_0 = 0;
 if (($npre_items | 0) == 0 | ($npre_num | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($npre_items, $npre_num, 20, 16);
 if ($npre_num >>> 0 > 1) {
  $remain_num_017 = 1;
  $pos_018 = 1;
 } else {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 while (1) {
  $arrayidx = $npre_items + ($pos_018 * 20 | 0) | 0;
  if ((_utf16_strncmp($npre_items + ($pos_018 * 20 | 0) + 4 | 0, $npre_items + (($remain_num_017 - 1 | 0) * 20 | 0) + 4 | 0, 7) | 0) == 0) {
   $remain_num_1 = $remain_num_017;
  } else {
   if (($remain_num_017 | 0) != ($pos_018 | 0)) {
    $1 = $npre_items + ($remain_num_017 * 20 | 0) | 0;
    $2 = $arrayidx;
    HEAP32[$1 >> 2] = HEAP32[$2 >> 2];
    HEAP32[$1 + 4 >> 2] = HEAP32[$2 + 4 >> 2];
    HEAP32[$1 + 8 >> 2] = HEAP32[$2 + 8 >> 2];
    HEAP32[$1 + 12 >> 2] = HEAP32[$2 + 12 >> 2];
    HEAP32[$1 + 16 >> 2] = HEAP32[$2 + 16 >> 2];
   }
   $remain_num_1 = $remain_num_017 + 1 | 0;
  }
  $inc14 = $pos_018 + 1 | 0;
  if ($inc14 >>> 0 < $npre_num >>> 0) {
   $remain_num_017 = $remain_num_1;
   $pos_018 = $inc14;
  } else {
   $retval_0 = $remain_num_1;
   break;
  }
 }
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11compare_splEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 return _strcmp($p1 | 0, $p2 | 0) | 0;
}
function __ZN10ime_pinyin12SpellingTrieC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 0;
 HEAP32[$this + 4 >> 2] = 0;
 HEAP32[$this + 8 >> 2] = 0;
 HEAP32[$this + 20 >> 2] = 0;
 _memset($this + 36 | 0, 0, 20);
 HEAP32[11856] = 0;
 HEAP32[$this + 24 >> 2] = 0;
 HEAP32[$this + 280 >> 2] = 0;
 __ZN10ime_pinyin12SpellingTrie14szm_enable_shmEb($this, 1);
 __ZN10ime_pinyin12SpellingTrie13szm_enable_ymEb($this, 1);
 HEAP32[$this + 284 >> 2] = 0;
 return;
}
function __ZN10ime_pinyin12SpellingTrie14szm_enable_shmEb($this, $enable) {
 $this = $this | 0;
 $enable = $enable | 0;
 var $conv10 = 0, $ch_09 = 0, $arrayidx = 0, $inc = 0, $conv1113 = 0, $ch9_012 = 0, $arrayidx18 = 0, $inc26 = 0;
 if ($enable) {
  $ch_09 = 65;
  $conv10 = 65;
  while (1) {
   if (__ZNK10ime_pinyin12SpellingTrie15is_shengmu_charEc(0, $ch_09) | 0) {
    $arrayidx = 10952 + ($conv10 - 65) | 0;
    HEAP8[$arrayidx] = HEAP8[$arrayidx] | 4;
   }
   $inc = $ch_09 + 1 & 255;
   if ($inc << 24 >> 24 < 91) {
    $ch_09 = $inc;
    $conv10 = $inc << 24 >> 24;
   } else {
    break;
   }
  }
  return;
 } else {
  $ch9_012 = 65;
  $conv1113 = 65;
  while (1) {
   if (__ZNK10ime_pinyin12SpellingTrie15is_shengmu_charEc(0, $ch9_012) | 0) {
    $arrayidx18 = 10952 + ($conv1113 - 65) | 0;
    HEAP8[$arrayidx18] = HEAP8[$arrayidx18] & -5;
   }
   $inc26 = $ch9_012 + 1 & 255;
   if ($inc26 << 24 >> 24 < 91) {
    $ch9_012 = $inc26;
    $conv1113 = $inc26 << 24 >> 24;
   } else {
    break;
   }
  }
  return;
 }
}
function __ZN10ime_pinyin12SpellingTrie13szm_enable_ymEb($this, $enable) {
 $this = $this | 0;
 $enable = $enable | 0;
 var $conv10 = 0, $ch_09 = 0, $arrayidx = 0, $inc = 0, $conv1113 = 0, $ch9_012 = 0, $arrayidx18 = 0, $inc26 = 0;
 if ($enable) {
  $ch_09 = 65;
  $conv10 = 65;
  while (1) {
   if (__ZNK10ime_pinyin12SpellingTrie13is_yunmu_charEc(0, $ch_09) | 0) {
    $arrayidx = 10952 + ($conv10 - 65) | 0;
    HEAP8[$arrayidx] = HEAP8[$arrayidx] | 4;
   }
   $inc = $ch_09 + 1 & 255;
   if ($inc << 24 >> 24 < 91) {
    $ch_09 = $inc;
    $conv10 = $inc << 24 >> 24;
   } else {
    break;
   }
  }
  return;
 } else {
  $ch9_012 = 65;
  $conv1113 = 65;
  while (1) {
   if (__ZNK10ime_pinyin12SpellingTrie13is_yunmu_charEc(0, $ch9_012) | 0) {
    $arrayidx18 = 10952 + ($conv1113 - 65) | 0;
    HEAP8[$arrayidx18] = HEAP8[$arrayidx18] & -5;
   }
   $inc26 = $ch9_012 + 1 & 255;
   if ($inc26 << 24 >> 24 < 91) {
    $ch9_012 = $inc26;
    $conv1113 = $inc26 << 24 >> 24;
   } else {
    break;
   }
  }
  return;
 }
}
function __ZN10ime_pinyin5NGram13build_unigramEPNS_10LemmaEntryEjj($this, $lemma_arr, $lemma_num, $next_idx_unused) {
 $this = $this | 0;
 $lemma_arr = $lemma_arr | 0;
 $lemma_num = $lemma_num | 0;
 $next_idx_unused = $next_idx_unused | 0;
 var $0$0 = 0, $call = 0, $4 = 0, $cmp5 = 0, $total_freq_078 = 0.0, $idx_now_077 = 0, $pos_076 = 0, $5 = 0, $inc = 0, $6 = 0.0, $storemerge = 0.0, $idx_now_1 = 0, $total_freq_1 = 0.0, $inc26 = 0, $total_freq_0_lcssa = 0.0, $idx_now_0_lcssa = 0, $add27 = 0, $idx_num_ = 0, $pos33_072 = 0, $arrayidx38 = 0, $div = 0.0, $freq_codes_df_ = 0, $10 = 0, $call55 = 0, $11 = 0, $12 = 0, $freq_codes_ = 0, $14 = 0, $call65 = 0, $15 = 0, $16 = 0, $code_pos_069 = 0, $freq_pos_068 = 0, $inc99 = 0, $freq_pos_1_ph = 0, $arrayidx78 = 0, $20 = 0.0, $i_0 = 0, $lma_freq_idx_ = 0, $25 = 0, $call105 = 0, $27 = 0, $code_pos116_066 = 0, $conv126 = 0, $retval_0 = 0;
 if (($lemma_arr | 0) == 0 | ($lemma_num | 0) == 0 | $next_idx_unused >>> 0 < 2) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $0$0 = _llvm_umul_with_overflow_i32($next_idx_unused | 0, 8) | 0;
 $call = __Znaj(tempRet0 ? -1 : $0$0) | 0;
 $4 = $call;
 $cmp5 = ($call | 0) == 0;
 if ($cmp5) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAPF64[$4 >> 3] = .3;
 L2413 : do {
  if (($lemma_num | 0) == 0) {
   $idx_now_0_lcssa = 0;
   $total_freq_0_lcssa = .3;
  } else {
   $pos_076 = 0;
   $idx_now_077 = 0;
   $total_freq_078 = .3;
   while (1) {
    $5 = HEAP32[$lemma_arr + ($pos_076 * 124 | 0) + 4 >> 2] | 0;
    if (($5 | 0) == ($idx_now_077 | 0)) {
     $total_freq_1 = $total_freq_078;
     $idx_now_1 = $idx_now_077;
    } else {
     $inc = $idx_now_077 + 1 | 0;
     if (($5 | 0) != ($inc | 0)) {
      break;
     }
     $6 = +HEAPF32[$lemma_arr + ($pos_076 * 124 | 0) + 120 >> 2];
     $storemerge = $6 > 0.0 ? $6 : .3;
     HEAPF64[$4 + ($inc << 3) >> 3] = $storemerge;
     $total_freq_1 = $total_freq_078 + $storemerge;
     $idx_now_1 = $inc;
    }
    $inc26 = $pos_076 + 1 | 0;
    if ($inc26 >>> 0 < $lemma_num >>> 0) {
     $pos_076 = $inc26;
     $idx_now_077 = $idx_now_1;
     $total_freq_078 = $total_freq_1;
    } else {
     $idx_now_0_lcssa = $idx_now_1;
     $total_freq_0_lcssa = $total_freq_1;
     break L2413;
    }
   }
   ___assert_func(4024, 262, 6152, 1576);
   return 0;
  }
 } while (0);
 $add27 = $idx_now_0_lcssa + 1 | 0;
 $idx_num_ = $this + 4 | 0;
 HEAP32[$idx_num_ >> 2] = $add27;
 if (($add27 | 0) != ($next_idx_unused | 0)) {
  ___assert_func(4024, 273, 6152, 1312);
  return 0;
 }
 L2425 : do {
  if ((HEAP32[$idx_num_ >> 2] | 0) != 0) {
   $pos33_072 = 0;
   while (1) {
    $arrayidx38 = $4 + ($pos33_072 << 3) | 0;
    $div = +HEAPF64[$arrayidx38 >> 3] / $total_freq_0_lcssa;
    HEAPF64[$arrayidx38 >> 3] = $div;
    if ($div <= 0.0) {
     break;
    }
    $pos33_072 = $pos33_072 + 1 | 0;
    if ($pos33_072 >>> 0 >= (HEAP32[$idx_num_ >> 2] | 0) >>> 0) {
     break L2425;
    }
   }
   ___assert_func(4024, 277, 6152, 1080);
   return 0;
  }
 } while (0);
 $freq_codes_df_ = $this + 16 | 0;
 $10 = HEAP32[$freq_codes_df_ >> 2] | 0;
 do {
  if (($10 | 0) == 0) {
   $call55 = __Znaj(2048) | 0;
   $11 = $call55;
   HEAP32[$freq_codes_df_ >> 2] = $11;
   if (($call55 | 0) != 0) {
    $12 = $11;
    break;
   }
   ___assert_func(4024, 285, 6152, 904);
   return 0;
  } else {
   $12 = $10;
  }
 } while (0);
 _memset($12 | 0, 0, 2048);
 $freq_codes_ = $this + 20 | 0;
 $14 = HEAP32[$freq_codes_ >> 2] | 0;
 do {
  if (($14 | 0) == 0) {
   $call65 = __Znaj(512) | 0;
   $15 = $call65;
   HEAP32[$freq_codes_ >> 2] = $15;
   if (($call65 | 0) != 0) {
    $16 = $15;
    break;
   }
   ___assert_func(4024, 290, 6152, 736);
   return 0;
  } else {
   $16 = $14;
  }
 } while (0);
 _memset($16 | 0, 0, 512);
 $freq_pos_068 = 0;
 $code_pos_069 = 0;
 while (1) {
  $freq_pos_1_ph = $freq_pos_068;
  L2441 : while (1) {
   $arrayidx78 = $4 + ($freq_pos_1_ph << 3) | 0;
   $20 = +HEAPF64[$arrayidx78 >> 3];
   $i_0 = 0;
   while (1) {
    if ($i_0 >>> 0 >= $code_pos_069 >>> 0) {
     break L2441;
    }
    if (+HEAPF64[(HEAP32[$freq_codes_df_ >> 2] | 0) + ($i_0 << 3) >> 3] == $20) {
     break;
    } else {
     $i_0 = $i_0 + 1 | 0;
    }
   }
   $freq_pos_1_ph = $freq_pos_1_ph + 1 | 0;
  }
  HEAPF64[(HEAP32[$freq_codes_df_ >> 2] | 0) + ($code_pos_069 << 3) >> 3] = +HEAPF64[$arrayidx78 >> 3];
  $inc99 = $code_pos_069 + 1 | 0;
  if ($inc99 >>> 0 < 256) {
   $freq_pos_068 = $freq_pos_1_ph + 1 | 0;
   $code_pos_069 = $inc99;
  } else {
   break;
  }
 }
 __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E(HEAP32[$freq_codes_df_ >> 2] | 0, 256, 8, 2);
 $lma_freq_idx_ = $this + 24 | 0;
 $25 = HEAP32[$lma_freq_idx_ >> 2] | 0;
 do {
  if (($25 | 0) == 0) {
   $call105 = __Znaj(HEAP32[$idx_num_ >> 2] | 0) | 0;
   HEAP32[$lma_freq_idx_ >> 2] = $call105;
   if (($call105 | 0) != 0) {
    $27 = $call105;
    break;
   }
   ___assert_func(4024, 317, 6152, 584);
   return 0;
  } else {
   $27 = $25;
  }
 } while (0);
 __ZN10ime_pinyin13iterate_codesEPdjS0_Ph($4, HEAP32[$idx_num_ >> 2] | 0, HEAP32[$freq_codes_df_ >> 2] | 0, $27);
 if ($cmp5) {
  $code_pos116_066 = 0;
 } else {
  __ZdaPv($call);
  $code_pos116_066 = 0;
 }
 do {
  $conv126 = ~~+__ZN10ime_pinyin5NGram20convert_psb_to_scoreEd(+HEAPF64[(HEAP32[$freq_codes_df_ >> 2] | 0) + ($code_pos116_066 << 3) >> 3]);
  HEAP16[(HEAP32[$freq_codes_ >> 2] | 0) + ($code_pos116_066 << 1) >> 1] = $conv126;
  $code_pos116_066 = $code_pos116_066 + 1 | 0;
 } while ($code_pos116_066 >>> 0 < 256);
 HEAP8[$this | 0] = 1;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie10is_half_idEt($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 return ($splid & 65535) < 30 & $splid << 16 >> 16 != 0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie14szm_is_enabledEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 return (HEAP8[10952 + (($ch << 24 >> 24) - 65) | 0] & 4) != 0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie13is_yunmu_charEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 return (HEAP8[10952 + (($ch << 24 >> 24) - 65) | 0] & 2) != 0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie10is_full_idEt($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 if (($splid & 65535) < 30) {
  return 0;
 } else {
  return ($splid & 65535) >>> 0 < ((HEAP32[$this + 8 >> 2] | 0) + 30 | 0) >>> 0 | 0;
 }
 return 0;
}
function __ZNK10ime_pinyin12SpellingTrie12full_to_halfEt($this, $full_id) {
 $this = $this | 0;
 $full_id = $full_id | 0;
 var $conv = 0, $retval_0 = 0;
 if ((HEAP32[$this + 44 >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $conv = $full_id & 65535;
 if (($full_id & 65535) < 30) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ($conv >>> 0 > ((HEAP32[$this + 8 >> 2] | 0) + 30 | 0) >>> 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP16[(HEAP32[$this + 280 >> 2] | 0) + ($conv - 30 << 1) >> 1] | 0;
 return $retval_0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie16is_half_id_yunmuEt($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 var $conv = 0, $retval_0 = 0;
 $conv = $splid & 65535;
 if ($splid << 16 >> 16 == 0 | ($splid & 65535) > 29) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((538968080 >>> ($conv >>> 0) & 1 | 0) != 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = (HEAP8[10952 + ((HEAP8[10920 + $conv | 0] | 0) - 65) | 0] & 2) != 0;
 return $retval_0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie15is_shengmu_charEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 return (HEAP8[10952 + (($ch << 24 >> 24) - 65) | 0] & 1) != 0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie14is_szm_enabledEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 return (HEAP8[10952 + (($ch << 24 >> 24) - 65) | 0] & 4) != 0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie13half2full_numEt($this, $half_id) {
 $this = $this | 0;
 $half_id = $half_id | 0;
 var $retval_0 = 0;
 if ((HEAP32[$this + 44 >> 2] | 0) == 0 | ($half_id & 65535) > 29) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP16[$this + 220 + (($half_id & 65535) << 1) >> 1] | 0;
 return $retval_0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt($this, $half_id, $spl_id_start) {
 $this = $this | 0;
 $half_id = $half_id | 0;
 $spl_id_start = $spl_id_start | 0;
 var $conv = 0, $retval_0 = 0;
 do {
  if (($spl_id_start | 0) == 0) {
   $retval_0 = 0;
  } else {
   if ((HEAP32[$this + 44 >> 2] | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   $conv = $half_id & 65535;
   if (($half_id & 65535) > 29) {
    $retval_0 = 0;
    break;
   }
   HEAP16[$spl_id_start >> 1] = HEAP16[$this + 160 + ($conv << 1) >> 1] | 0;
   $retval_0 = HEAP16[$this + 220 + ($conv << 1) >> 1] | 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrieD2Ev($this) {
 $this = $this | 0;
 var $0 = 0, $1 = 0, $2 = 0, $4 = 0, $root_ = 0, $5 = 0, $6 = 0, $8 = 0, $10 = 0, $12 = 0, $16 = 0, $17 = 0;
 $0 = HEAP32[$this >> 2] | 0;
 if (($0 | 0) != 0) {
  __ZdaPv($0);
 }
 $1 = HEAP32[$this + 36 >> 2] | 0;
 if (($1 | 0) != 0) {
  __ZdaPv($1);
 }
 $2 = HEAP32[$this + 40 >> 2] | 0;
 if (($2 | 0) != 0) {
  __ZdaPv($2);
 }
 $4 = HEAP32[$this + 20 >> 2] | 0;
 if (($4 | 0) != 0) {
  __ZdaPv($4);
 }
 $root_ = $this + 44 | 0;
 $5 = HEAP32[$root_ >> 2] | 0;
 do {
  if (($5 | 0) != 0) {
   __ZN10ime_pinyin12SpellingTrie13free_son_trieEPNS_12SpellingNodeE($this, $5);
   $6 = HEAP32[$root_ >> 2] | 0;
   if (($6 | 0) == 0) {
    break;
   }
   __ZdlPv($6);
  }
 } while (0);
 $8 = HEAP32[$this + 48 >> 2] | 0;
 if (($8 | 0) != 0) {
  __ZdaPv($8);
 }
 $10 = HEAP32[$this + 52 >> 2] | 0;
 if (($10 | 0) != 0) {
  __ZdaPv($10);
 }
 $12 = HEAP32[11856] | 0;
 if (($12 | 0) != 0) {
  __ZN10ime_pinyin12SpellingTrieD2Ev($12);
  __ZdlPv($12);
  HEAP32[11856] = 0;
 }
 $16 = HEAP32[$this + 24 >> 2] | 0;
 if (($16 | 0) != 0) {
  __ZdaPv($16);
 }
 $17 = HEAP32[$this + 280 >> 2] | 0;
 if (($17 | 0) == 0) {
  return;
 }
 __ZdaPv($17);
 return;
}
function __ZN10ime_pinyin12SpellingTrie13free_son_trieEPNS_12SpellingNodeE($this, $node) {
 $this = $this | 0;
 $node = $node | 0;
 var $1 = 0, $first_son = 0, $3 = 0, $4 = 0, $pos_08 = 0, $inc = 0, $7 = 0, $_lcssa = 0;
 if (($node | 0) == 0) {
  return;
 }
 $1 = $node + 4 | 0;
 $first_son = $node | 0;
 $3 = HEAP32[$first_son >> 2] | 0;
 if ((HEAPU16[$1 >> 1] | 0) > 2047) {
  $pos_08 = 0;
  $4 = $3;
  while (1) {
   __ZN10ime_pinyin12SpellingTrie13free_son_trieEPNS_12SpellingNodeE($this, $4 + ($pos_08 << 3) | 0);
   $inc = $pos_08 + 1 | 0;
   $7 = HEAP32[$first_son >> 2] | 0;
   if ($inc >>> 0 < ((HEAPU16[$1 >> 1] | 0) >>> 11 & 65535) >>> 0) {
    $pos_08 = $inc;
    $4 = $7;
   } else {
    $_lcssa = $7;
    break;
   }
  }
 } else {
  $_lcssa = $3;
 }
 if (($_lcssa | 0) == 0) {
  return;
 }
 __ZdaPv($_lcssa);
 return;
}
function __ZNK10ime_pinyin12SpellingTrie20half_full_compatibleEtt($this, $half_id, $full_id) {
 $this = $this | 0;
 $half_id = $half_id | 0;
 $full_id = $full_id | 0;
 var $call = 0, $retval_0 = 0;
 $call = __ZNK10ime_pinyin12SpellingTrie12full_to_halfEt($this, $full_id) | 0;
 if ($call << 16 >> 16 == $half_id << 16 >> 16) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $retval_0 = (HEAP8[10920 + ($call & 65535) | 0] & -33) << 24 >> 24 == (HEAP8[10920 + ($half_id & 65535) | 0] | 0);
 return $retval_0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie11is_szm_charEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 var $0 = 0;
 if (__ZNK10ime_pinyin12SpellingTrie15is_shengmu_charEc(0, $ch) | 0) {
  $0 = 1;
  return $0 | 0;
 }
 $0 = __ZNK10ime_pinyin12SpellingTrie13is_yunmu_charEc(0, $ch) | 0;
 return $0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie14get_cpinstanceEv() {
 return __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
}
function __ZN10ime_pinyin12SpellingTrie12get_instanceEv() {
 var $1 = 0;
 if ((HEAP32[11856] | 0) == 0) {
  $1 = __Znwj(288) | 0;
  __ZN10ime_pinyin12SpellingTrieC2Ev($1);
  HEAP32[11856] = $1;
 }
 return HEAP32[11856] | 0;
}
function __ZN10ime_pinyin12SpellingTrie9constructEPKcjjfh($this, $spelling_arr, $item_size, $item_num, $score_amplifier, $average_score) {
 $this = $this | 0;
 $spelling_arr = $spelling_arr | 0;
 $item_size = $item_size | 0;
 $item_num = $item_num | 0;
 $score_amplifier = +$score_amplifier;
 $average_score = $average_score | 0;
 var $h2f_start_ = 0, $spelling_buf_ = 0, $1 = 0, $mul = 0, $call = 0, $spelling_size_ = 0, $spelling_num_ = 0, $average_score_ = 0, $splstr_queried_ = 0, $2 = 0, $call26 = 0, $splstr16_queried_ = 0, $4 = 0, $7$0 = 0, $call40 = 0, $call49 = 0, $16 = 0, $root_ = 0, $call51 = 0, $18 = 0, $dumb_node_ = 0, $call55 = 0, $22 = 0, $splitter_node_ = 0, $call62 = 0, $retval_0 = 0;
 if (($spelling_arr | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $h2f_start_ = $this + 160 | 0;
 $spelling_buf_ = $this | 0;
 _memset($h2f_start_ | 0, 0, 120);
 $1 = HEAP32[$spelling_buf_ >> 2] | 0;
 do {
  if (($1 | 0) != ($spelling_arr | 0)) {
   if (($1 | 0) != 0) {
    __ZdaPv($1);
   }
   $mul = Math_imul($item_num, $item_size) | 0;
   $call = __Znaj($mul) | 0;
   HEAP32[$spelling_buf_ >> 2] = $call;
   if (($call | 0) == 0) {
    $retval_0 = 0;
    return $retval_0 | 0;
   } else {
    _memcpy($call | 0, $spelling_arr | 0, $mul) | 0;
    break;
   }
  }
 } while (0);
 $spelling_size_ = $this + 4 | 0;
 HEAP32[$spelling_size_ >> 2] = $item_size;
 $spelling_num_ = $this + 8 | 0;
 HEAP32[$spelling_num_ >> 2] = $item_num;
 HEAPF32[$this + 12 >> 2] = $score_amplifier;
 $average_score_ = $this + 16 | 0;
 HEAP8[$average_score_] = $average_score;
 $splstr_queried_ = $this + 36 | 0;
 $2 = HEAP32[$splstr_queried_ >> 2] | 0;
 if (($2 | 0) != 0) {
  __ZdaPv($2);
 }
 $call26 = __Znaj(HEAP32[$spelling_size_ >> 2] | 0) | 0;
 HEAP32[$splstr_queried_ >> 2] = $call26;
 if (($call26 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $splstr16_queried_ = $this + 40 | 0;
 $4 = HEAP32[$splstr16_queried_ >> 2] | 0;
 if (($4 | 0) != 0) {
  __ZdaPv($4);
 }
 $7$0 = _llvm_umul_with_overflow_i32(HEAP32[$spelling_size_ >> 2] | 0, 2) | 0;
 $call40 = __Znaj(tempRet0 ? -1 : $7$0) | 0;
 HEAP32[$splstr16_queried_ >> 2] = $call40;
 if (($call40 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 _qsort(HEAP32[$spelling_buf_ >> 2] | 0, HEAP32[$spelling_num_ >> 2] | 0, HEAP32[$spelling_size_ >> 2] | 0, 44);
 HEAP32[$this + 284 >> 2] = 1;
 $call49 = __Znwj(8) | 0;
 $16 = $call49;
 $root_ = $this + 44 | 0;
 HEAP32[$root_ >> 2] = $call49;
 HEAP32[$16 >> 2] = 0;
 HEAP32[$16 + 4 >> 2] = 0;
 $call51 = __Znwj(8) | 0;
 $18 = $call51;
 $dumb_node_ = $this + 48 | 0;
 HEAP32[$dumb_node_ >> 2] = $call51;
 HEAP32[$18 >> 2] = 0;
 HEAP32[$18 + 4 >> 2] = 0;
 HEAP8[(HEAP32[$dumb_node_ >> 2] | 0) + 7 | 0] = HEAP8[$average_score_] | 0;
 $call55 = __Znwj(8) | 0;
 $22 = $call55;
 $splitter_node_ = $this + 52 | 0;
 HEAP32[$splitter_node_ >> 2] = $call55;
 HEAP32[$22 >> 2] = 0;
 HEAP32[$22 + 4 >> 2] = 0;
 HEAP8[(HEAP32[$splitter_node_ >> 2] | 0) + 7 | 0] = HEAP8[$average_score_] | 0;
 _memset($this + 56 | 0, 0, 104);
 $call62 = __ZN10ime_pinyin12SpellingTrie26construct_spellings_subsetEjjjPNS_12SpellingNodeE($this, 0, HEAP32[$spelling_num_ >> 2] | 0, 0, HEAP32[$root_ >> 2] | 0) | 0;
 HEAP32[HEAP32[$root_ >> 2] >> 2] = $call62;
 HEAP8[(HEAP32[$root_ >> 2] | 0) + 7 | 0] = 0;
 if ((HEAP32[HEAP32[$root_ >> 2] >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP16[$this + 220 >> 1] = 0;
 HEAP16[$h2f_start_ >> 1] = 0;
 if (!(__ZN10ime_pinyin12SpellingTrie9build_f2hEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12SpellingTrie13build_ym_infoEv($this) | 0;
 return $retval_0 | 0;
}
function __ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 var $0 = 0, $conv = 0, $1 = 0, $retval_0 = 0;
 do {
  if (($splid | 0) == 0) {
   $retval_0 = 0;
  } else {
   $0 = HEAP16[$splid >> 1] | 0;
   $conv = $0 & 65535;
   if ($0 << 16 >> 16 == 0) {
    $retval_0 = 0;
    break;
   }
   if (($0 & 65535) > 29) {
    $retval_0 = 1;
    break;
   }
   $1 = HEAP8[10920 + $conv | 0] | 0;
   if ((538968080 >>> ($conv >>> 0) & 1 | 0) != 0) {
    $retval_0 = 1;
    break;
   }
   if (__ZNK10ime_pinyin12SpellingTrie14szm_is_enabledEc(0, $1) | 0) {
    $retval_0 = 1;
    break;
   }
   if (!(__ZNK10ime_pinyin12SpellingTrie13is_yunmu_charEc(0, $1) | 0)) {
    $retval_0 = 0;
    break;
   }
   if ((HEAP16[$this + 220 + ($conv << 1) >> 1] | 0) == 0) {
    ___assert_func(3400, 128, 4448, 4088);
    return 0;
   } else {
    HEAP16[$splid >> 1] = HEAP16[$this + 160 + ($conv << 1) >> 1] | 0;
    $retval_0 = 1;
    break;
   }
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc($ch) {
 $ch = $ch | 0;
 if (($ch - 97 & 255) < 26) {
  return 1;
 } else {
  return ($ch - 65 & 255) < 26 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12SpellingTrie9build_f2hEv($this) {
 $this = $this | 0;
 var $f2h_ = 0, $0 = 0, $3$0 = 0, $call = 0, $conv15 = 0, $hid_014 = 0, $arrayidx = 0, $8 = 0, $conv107 = 0, $arrayidx16 = 0, $conv1013 = 0, $fid_012 = 0, $inc24 = 0, $retval_0 = 0;
 $f2h_ = $this + 280 | 0;
 $0 = HEAP32[$f2h_ >> 2] | 0;
 if (($0 | 0) != 0) {
  __ZdaPv($0);
 }
 $3$0 = _llvm_umul_with_overflow_i32(HEAP32[$this + 8 >> 2] | 0, 2) | 0;
 $call = __Znaj(tempRet0 ? -1 : $3$0) | 0;
 HEAP32[$f2h_ >> 2] = $call;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $hid_014 = 0;
  $conv15 = 0;
 }
 while (1) {
  $arrayidx = $this + 160 + ($conv15 << 1) | 0;
  $8 = HEAP16[$arrayidx >> 1] | 0;
  $conv107 = $8 & 65535;
  $arrayidx16 = $this + 220 + ($conv15 << 1) | 0;
  if (($conv107 | 0) < ((HEAPU16[$arrayidx16 >> 1] | 0) + ($8 & 65535) | 0)) {
   $fid_012 = $8;
   $conv1013 = $conv107;
   do {
    HEAP16[(HEAP32[$f2h_ >> 2] | 0) + ($conv1013 - 30 << 1) >> 1] = $hid_014;
    $fid_012 = $fid_012 + 1 & 65535;
    $conv1013 = $fid_012 & 65535;
   } while (($conv1013 | 0) < ((HEAPU16[$arrayidx16 >> 1] | 0) + (HEAPU16[$arrayidx >> 1] | 0) | 0));
  }
  $inc24 = $hid_014 + 1 & 65535;
  if (($inc24 & 65535) < 30) {
   $hid_014 = $inc24;
   $conv15 = $inc24 & 65535;
  } else {
   $retval_0 = 1;
   break;
  }
 }
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie10get_ym_strEPKc($this, $spl_str) {
 $this = $this | 0;
 $spl_str = $spl_str | 0;
 var $0 = 0, $add_ptr8 = 0, $spl_str_addr_0 = 0;
 $0 = HEAP8[$spl_str] | 0;
 if (!(__ZNK10ime_pinyin12SpellingTrie15is_shengmu_charEc(0, $0) | 0)) {
  $spl_str_addr_0 = $spl_str;
  return $spl_str_addr_0 | 0;
 }
 if (($0 << 24 >> 24 | 0) == 90 | ($0 << 24 >> 24 | 0) == 67 | ($0 << 24 >> 24 | 0) == 83) {
  $add_ptr8 = $spl_str + 1 | 0;
  return ((HEAP8[$add_ptr8] | 0) == 104 ? $spl_str + 2 | 0 : $add_ptr8) | 0;
 }
 $spl_str_addr_0 = $spl_str + 1 | 0;
 return $spl_str_addr_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie16get_spelling_strEt($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 var $splstr_queried_ = 0, $1 = 0, $2 = 0, $3 = 0, $add_ptr = 0, $4 = 0, $5 = 0, $dec_splid = 0, $splid_addr_1_off0 = 0, $12 = 0, sp = 0;
 sp = STACKTOP;
 $splstr_queried_ = $this + 36 | 0;
 HEAP8[HEAP32[$splstr_queried_ >> 2] | 0] = 0;
 if (($splid & 65535) > 29) {
  $1 = HEAP32[$splstr_queried_ >> 2] | 0;
  $2 = HEAP32[$this + 4 >> 2] | 0;
  $3 = HEAP32[$this >> 2] | 0;
  $add_ptr = $3 + (Math_imul($2, $splid - 30 & 65535) | 0) | 0;
  _snprintf($1 | 0, $2 | 0, 896, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $add_ptr, tempInt) | 0) | 0;
  $12 = HEAP32[$splstr_queried_ >> 2] | 0;
  STACKTOP = sp;
  return $12 | 0;
 }
 if (($splid << 16 >> 16 | 0) == 4) {
  $4 = HEAP32[$splstr_queried_ >> 2] | 0;
  $5 = HEAP32[$this + 4 >> 2] | 0;
  _snprintf($4 | 0, $5 | 0, 896, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = 728, tempInt) | 0) | 0;
  $12 = HEAP32[$splstr_queried_ >> 2] | 0;
  STACKTOP = sp;
  return $12 | 0;
 } else if (($splid << 16 >> 16 | 0) == 21) {
  _snprintf(HEAP32[$splstr_queried_ >> 2] | 0, HEAP32[$this + 4 >> 2] | 0, 896, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = 576, tempInt) | 0) | 0;
  $12 = HEAP32[$splstr_queried_ >> 2] | 0;
  STACKTOP = sp;
  return $12 | 0;
 } else if (($splid << 16 >> 16 | 0) == 29) {
  _snprintf(HEAP32[$splstr_queried_ >> 2] | 0, HEAP32[$this + 4 >> 2] | 0, 896, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = 4368, tempInt) | 0) | 0;
  $12 = HEAP32[$splstr_queried_ >> 2] | 0;
  STACKTOP = sp;
  return $12 | 0;
 } else {
  $dec_splid = ((($splid & 65535) > 3) << 31 >> 31) + $splid & 65535;
  if (($dec_splid & 65535) > 19) {
   $splid_addr_1_off0 = $dec_splid + 255 & 255;
  } else {
   $splid_addr_1_off0 = $dec_splid & 255;
  }
  HEAP8[HEAP32[$splstr_queried_ >> 2] | 0] = $splid_addr_1_off0 + 64 & 255;
  HEAP8[(HEAP32[$splstr_queried_ >> 2] | 0) + 1 | 0] = 0;
  $12 = HEAP32[$splstr_queried_ >> 2] | 0;
  STACKTOP = sp;
  return $12 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12SpellingTrie9get_ym_idEPKc($this, $ym_str) {
 $this = $this | 0;
 $ym_str = $ym_str | 0;
 var $ym_buf_ = 0, $1 = 0, $ym_size_ = 0, $pos_0 = 0, $conv = 0, $2 = 0, $add = 0, $retval_0 = 0, label = 0;
 if (($ym_str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $ym_buf_ = $this + 24 | 0;
 if ((HEAP32[$ym_buf_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $1 = HEAP32[$this + 32 >> 2] | 0;
 $ym_size_ = $this + 28 | 0;
 $pos_0 = 0;
 while (1) {
  $conv = $pos_0 & 255;
  if ($conv >>> 0 >= $1 >>> 0) {
   $retval_0 = 0;
   label = 2089;
   break;
  }
  $2 = HEAP32[$ym_buf_ >> 2] | 0;
  $add = $pos_0 + 1 & 255;
  if ((_strcmp($2 + (Math_imul(HEAP32[$ym_size_ >> 2] | 0, $conv) | 0) | 0, $ym_str | 0) | 0) == 0) {
   $retval_0 = $add;
   label = 2087;
   break;
  } else {
   $pos_0 = $add;
  }
 }
 if ((label | 0) == 2089) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2087) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12SpellingTrie13save_spl_trieEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $spelling_buf_ = 0, $spelling_size_ = 0, $spelling_num_ = 0, $call21 = 0, $retval_0 = 0;
 if (($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_buf_ = $this | 0;
 if ((HEAP32[$spelling_buf_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_size_ = $this + 4 | 0;
 if ((_fwrite($spelling_size_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_num_ = $this + 8 | 0;
 if ((_fwrite($spelling_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($this + 12 | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($this + 16 | 0, 1, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call21 = _fwrite(HEAP32[$spelling_buf_ >> 2] | 0, HEAP32[$spelling_size_ >> 2] | 0, HEAP32[$spelling_num_ >> 2] | 0, $fp | 0) | 0;
 $retval_0 = ($call21 | 0) == (HEAP32[$spelling_num_ >> 2] | 0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie26construct_spellings_subsetEjjjPNS_12SpellingNodeE($this, $item_start, $item_end, $level, $parent) {
 $this = $this | 0;
 $item_start = $item_start | 0;
 $item_end = $item_end | 0;
 $level = $level | 0;
 $parent = $parent | 0;
 var $spelling_size_ = 0, $0 = 0, $spelling_buf_ = 0, $1 = 0, $2 = 0, $add = 0, $3 = 0, $4 = 0, $num_of_son_0216 = 0, $char_for_node_0215 = 0, $i_0214 = 0, $5 = 0, $num_of_son_0_inc = 0, $inc23 = 0, $num_of_son_0_lcssa = 0, $conv25 = 0, $node_num_ = 0, $umul_with_overflow = 0, $call = 0, $7 = 0, $8 = 0, $mul31 = 0, $add_ptr32 = 0, $10 = 0, $add34 = 0, $cmp37 = 0, $cmp61 = 0, $cmp149 = 0, $min_son_score_0207 = 0, $spelling_last_start_0206 = 0, $char_for_node_2205 = 0, $son_pos_0201 = 0, $i40_0197 = 0, $item_start_next_0194 = 0, $spelling_endable_1_off0193 = 0, $12 = 0, $mul48 = 0, $add_ptr49 = 0, $14 = 0, $conv57 = 0, $add_ptr60 = 0, $16 = 0, $arrayidx71 = 0, $20 = 0, $21 = 0, $cmp81 = 0, $23 = 0, $score = 0, $27 = 0, $_min_son_score_0 = 0, $29 = 0, $bf_value140_pn = 0, $32 = 0, $cmp164 = 0, $part_id_0174 = 0, $34 = 0, $idxprom188 = 0, $spelling_endable_3_off0 = 0, $item_start_next_1 = 0, $son_pos_1 = 0, $char_for_node_3 = 0, $spelling_last_start_1 = 0, $min_son_score_2 = 0, $inc217 = 0, $min_son_score_0_lcssa = 0, $spelling_last_start_0_lcssa = 0, $char_for_node_2_lcssa = 0, $son_pos_0_lcssa = 0, $item_start_next_0_lcssa = 0, $spelling_endable_1_off0_lcssa = 0, $add_ptr220 = 0, $cmp222 = 0, $44 = 0, $arrayidx237 = 0, $48 = 0, $49 = 0, $cmp248 = 0, $51 = 0, $score264 = 0, $55 = 0, $_min_son_score_0166 = 0, $57 = 0, $bf_value318_pn = 0, $60 = 0, $cmp346 = 0, $part_id336_0180 = 0, $62 = 0, $idxprom370 = 0, $71 = 0, $retval_0 = 0, label = 0;
 $spelling_size_ = $this + 4 | 0;
 $0 = HEAP32[$spelling_size_ >> 2] | 0;
 if ($item_end >>> 0 <= $item_start >>> 0 | $0 >>> 0 <= $level >>> 0 | ($parent | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_buf_ = $this | 0;
 $1 = HEAP32[$spelling_buf_ >> 2] | 0;
 $2 = HEAP8[$1 + ((Math_imul($0, $item_start) | 0) + $level) | 0] | 0;
 if ($2 << 24 >> 24 <= 64) {
  ___assert_func(3400, 439, 6400, 1496);
  return 0;
 }
 if (!($2 << 24 >> 24 < 91 | $2 << 24 >> 24 == 104)) {
  ___assert_func(3400, 439, 6400, 1496);
  return 0;
 }
 $add = $item_start + 1 | 0;
 if ($add >>> 0 < $item_end >>> 0) {
  $3 = HEAP32[$spelling_buf_ >> 2] | 0;
  $4 = HEAP32[$spelling_size_ >> 2] | 0;
  $i_0214 = $add;
  $char_for_node_0215 = $2;
  $num_of_son_0216 = 0;
  while (1) {
   $5 = HEAP8[$3 + ((Math_imul($4, $i_0214) | 0) + $level) | 0] | 0;
   $num_of_son_0_inc = ($5 << 24 >> 24 != $char_for_node_0215 << 24 >> 24) + $num_of_son_0216 & 65535;
   $inc23 = $i_0214 + 1 | 0;
   if ($inc23 >>> 0 < $item_end >>> 0) {
    $i_0214 = $inc23;
    $char_for_node_0215 = $5;
    $num_of_son_0216 = $num_of_son_0_inc;
   } else {
    break;
   }
  }
  $num_of_son_0_lcssa = $num_of_son_0_inc + 1 & 65535;
 } else {
  $num_of_son_0_lcssa = 1;
 }
 $conv25 = $num_of_son_0_lcssa & 65535;
 $node_num_ = $this + 284 | 0;
 HEAP32[$node_num_ >> 2] = (HEAP32[$node_num_ >> 2] | 0) + $conv25;
 $umul_with_overflow = $conv25 << 3;
 $call = __Znaj($umul_with_overflow) | 0;
 $7 = $call;
 _memset($call | 0, 0, $umul_with_overflow | 0);
 $8 = HEAP32[$spelling_buf_ >> 2] | 0;
 $mul31 = Math_imul(HEAP32[$spelling_size_ >> 2] | 0, $item_start) | 0;
 $add_ptr32 = $8 + $mul31 | 0;
 $10 = HEAP8[$8 + ($mul31 + $level) | 0] | 0;
 $add34 = $level + 1 | 0;
 $cmp37 = (HEAP8[$8 + ($mul31 + $add34) | 0] | 0) == 0;
 L2694 : do {
  if ($add >>> 0 < $item_end >>> 0) {
   $cmp61 = ($level | 0) == 0;
   $cmp149 = ($level | 0) == 1;
   $spelling_endable_1_off0193 = $cmp37;
   $item_start_next_0194 = $item_start;
   $i40_0197 = $add;
   $son_pos_0201 = 0;
   $char_for_node_2205 = $10;
   $spelling_last_start_0206 = $add_ptr32;
   $min_son_score_0207 = -1;
   while (1) {
    $12 = HEAP32[$spelling_buf_ >> 2] | 0;
    $mul48 = Math_imul(HEAP32[$spelling_size_ >> 2] | 0, $i40_0197) | 0;
    $add_ptr49 = $12 + $mul48 | 0;
    $14 = HEAP8[$12 + ($mul48 + $level) | 0] | 0;
    if (!(__ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc($14) | 0)) {
     break;
    }
    $conv57 = $char_for_node_2205 << 24 >> 24;
    if ($14 << 24 >> 24 == $char_for_node_2205 << 24 >> 24) {
     $min_son_score_2 = $min_son_score_0207;
     $spelling_last_start_1 = $spelling_last_start_0206;
     $char_for_node_3 = $char_for_node_2205;
     $son_pos_1 = $son_pos_0201;
     $item_start_next_1 = $item_start_next_0194;
     $spelling_endable_3_off0 = $spelling_endable_1_off0193;
    } else {
     $add_ptr60 = $7 + ($son_pos_0201 << 3) | 0;
     HEAP8[$7 + ($son_pos_0201 << 3) + 6 | 0] = $char_for_node_2205;
     if ($cmp61) {
      HEAP32[$this + 56 + ($conv57 - 65 << 2) >> 2] = $add_ptr60;
     }
     if ($spelling_endable_1_off0193) {
      $16 = $7 + ($son_pos_0201 << 3) + 4 | 0;
      HEAP16[$16 >> 1] = HEAP16[$16 >> 1] & -2048 | $item_start_next_0194 + 30 & 2047;
     }
     $arrayidx71 = $spelling_last_start_0206 + $add34 | 0;
     $20 = HEAP8[$arrayidx71] | 0;
     do {
      if ($20 << 24 >> 24 == 0) {
       if (($i40_0197 - $item_start_next_0194 | 0) >>> 0 > 1) {
        $21 = HEAP8[$arrayidx71] | 0;
        label = 2126;
        break;
       } else {
        HEAP32[$add_ptr60 >> 2] = 0;
        HEAP8[$7 + ($son_pos_0201 << 3) + 7 | 0] = HEAP8[$spelling_last_start_0206 + ((HEAP32[$spelling_size_ >> 2] | 0) - 1) | 0] | 0;
        break;
       }
      } else {
       $21 = $20;
       label = 2126;
      }
     } while (0);
     do {
      if ((label | 0) == 2126) {
       label = 0;
       $cmp81 = $21 << 24 >> 24 == 0;
       HEAP32[$add_ptr60 >> 2] = __ZN10ime_pinyin12SpellingTrie26construct_spellings_subsetEjjjPNS_12SpellingNodeE($this, ($cmp81 & 1) + $item_start_next_0194 | 0, $i40_0197, $add34, $add_ptr60) | 0;
       if (!$cmp81) {
        break;
       }
       $23 = HEAP8[$spelling_last_start_0206 + ((HEAP32[$spelling_size_ >> 2] | 0) - 1) | 0] | 0;
       $score = $7 + ($son_pos_0201 << 3) + 7 | 0;
       if (($23 & 255) >= (HEAPU8[$score] | 0)) {
        break;
       }
       HEAP8[$score] = $23;
      }
     } while (0);
     $27 = HEAP8[$7 + ($son_pos_0201 << 3) + 7 | 0] | 0;
     $_min_son_score_0 = ($27 & 255) < ($min_son_score_0207 & 255) ? $27 : $min_son_score_0207;
     do {
      if ($cmp61) {
       if (!(__ZNK10ime_pinyin12SpellingTrie11is_szm_charEc(0, $char_for_node_2205) | 0)) {
        break;
       }
       $29 = $7 + ($son_pos_0201 << 3) + 4 | 0;
       $bf_value140_pn = (($conv57 + 1984 & 65535) + ($char_for_node_2205 << 24 >> 24 > 67) & 65535) + ($char_for_node_2205 << 24 >> 24 > 83) & 2047;
       HEAP16[$29 >> 1] = HEAP16[$29 >> 1] & -2048 | $bf_value140_pn;
       HEAP16[$this + 220 + (($bf_value140_pn & 65535) << 1) >> 1] = $i40_0197 - $item_start_next_0194 & 65535;
       label = 2138;
      } else {
       if (!($cmp149 & $char_for_node_2205 << 24 >> 24 == 104)) {
        break;
       }
       $32 = HEAP8[$spelling_last_start_0206] | 0;
       if (($32 << 24 >> 24 | 0) == 83) {
        $part_id_0174 = 21;
       } else if (($32 << 24 >> 24 | 0) == 67) {
        $part_id_0174 = 4;
       } else {
        $cmp164 = $32 << 24 >> 24 == 90;
        if ($cmp164) {
         $part_id_0174 = $cmp164 ? 29 : 0;
        } else {
         break;
        }
       }
       $34 = $7 + ($son_pos_0201 << 3) + 4 | 0;
       HEAP16[$34 >> 1] = HEAP16[$34 >> 1] & -2048 | $part_id_0174;
       HEAP16[$this + 220 + (($part_id_0174 & 65535) << 1) >> 1] = $i40_0197 - $item_start_next_0194 & 65535;
       label = 2138;
      }
     } while (0);
     do {
      if ((label | 0) == 2138) {
       label = 0;
       $idxprom188 = HEAP16[$7 + ($son_pos_0201 << 3) + 4 >> 1] & 2047;
       if ((HEAP16[$this + 220 + ($idxprom188 << 1) >> 1] | 0) == 0) {
        HEAP16[$this + 160 + ($idxprom188 << 1) >> 1] = 0;
        break;
       } else {
        HEAP16[$this + 160 + ($idxprom188 << 1) >> 1] = $item_start_next_0194 + 30 & 65535;
        break;
       }
      }
     } while (0);
     $min_son_score_2 = $_min_son_score_0;
     $spelling_last_start_1 = $add_ptr49;
     $char_for_node_3 = $14;
     $son_pos_1 = $son_pos_0201 + 1 | 0;
     $item_start_next_1 = $i40_0197;
     $spelling_endable_3_off0 = (HEAP8[$12 + ($mul48 + $add34) | 0] | 0) == 0;
    }
    $inc217 = $i40_0197 + 1 | 0;
    if ($inc217 >>> 0 < $item_end >>> 0) {
     $spelling_endable_1_off0193 = $spelling_endable_3_off0;
     $item_start_next_0194 = $item_start_next_1;
     $i40_0197 = $inc217;
     $son_pos_0201 = $son_pos_1;
     $char_for_node_2205 = $char_for_node_3;
     $spelling_last_start_0206 = $spelling_last_start_1;
     $min_son_score_0207 = $min_son_score_2;
    } else {
     $spelling_endable_1_off0_lcssa = $spelling_endable_3_off0;
     $item_start_next_0_lcssa = $item_start_next_1;
     $son_pos_0_lcssa = $son_pos_1;
     $char_for_node_2_lcssa = $char_for_node_3;
     $spelling_last_start_0_lcssa = $spelling_last_start_1;
     $min_son_score_0_lcssa = $min_son_score_2;
     break L2694;
    }
   }
   ___assert_func(3400, 474, 6400, 1280);
   return 0;
  } else {
   $spelling_endable_1_off0_lcssa = $cmp37;
   $item_start_next_0_lcssa = $item_start;
   $son_pos_0_lcssa = 0;
   $char_for_node_2_lcssa = $10;
   $spelling_last_start_0_lcssa = $add_ptr32;
   $min_son_score_0_lcssa = -1;
  }
 } while (0);
 $add_ptr220 = $7 + ($son_pos_0_lcssa << 3) | 0;
 HEAP8[$7 + ($son_pos_0_lcssa << 3) + 6 | 0] = $char_for_node_2_lcssa;
 $cmp222 = ($level | 0) == 0;
 if ($cmp222) {
  HEAP32[$this + 56 + (($char_for_node_2_lcssa << 24 >> 24) - 65 << 2) >> 2] = $add_ptr220;
 }
 if ($spelling_endable_1_off0_lcssa) {
  $44 = $7 + ($son_pos_0_lcssa << 3) + 4 | 0;
  HEAP16[$44 >> 1] = HEAP16[$44 >> 1] & -2048 | $item_start_next_0_lcssa + 30 & 2047;
 }
 $arrayidx237 = $spelling_last_start_0_lcssa + $add34 | 0;
 $48 = HEAP8[$arrayidx237] | 0;
 do {
  if ($48 << 24 >> 24 == 0) {
   if (($item_end - $item_start_next_0_lcssa | 0) >>> 0 > 1) {
    $49 = HEAP8[$arrayidx237] | 0;
    label = 2150;
    break;
   } else {
    HEAP32[$add_ptr220 >> 2] = 0;
    HEAP8[$7 + ($son_pos_0_lcssa << 3) + 7 | 0] = HEAP8[$spelling_last_start_0_lcssa + ((HEAP32[$spelling_size_ >> 2] | 0) - 1) | 0] | 0;
    break;
   }
  } else {
   $49 = $48;
   label = 2150;
  }
 } while (0);
 do {
  if ((label | 0) == 2150) {
   $cmp248 = $49 << 24 >> 24 == 0;
   HEAP32[$add_ptr220 >> 2] = __ZN10ime_pinyin12SpellingTrie26construct_spellings_subsetEjjjPNS_12SpellingNodeE($this, ($cmp248 & 1) + $item_start_next_0_lcssa | 0, $item_end, $add34, $add_ptr220) | 0;
   if (!$cmp248) {
    break;
   }
   $51 = HEAP8[$spelling_last_start_0_lcssa + ((HEAP32[$spelling_size_ >> 2] | 0) - 1) | 0] | 0;
   $score264 = $7 + ($son_pos_0_lcssa << 3) + 7 | 0;
   if (($51 & 255) >= (HEAPU8[$score264] | 0)) {
    break;
   }
   HEAP8[$score264] = $51;
  }
 } while (0);
 $55 = HEAP8[$7 + ($son_pos_0_lcssa << 3) + 7 | 0] | 0;
 $_min_son_score_0166 = ($55 & 255) < ($min_son_score_0_lcssa & 255) ? $55 : $min_son_score_0_lcssa;
 if (($son_pos_0_lcssa + 1 | 0) != ($conv25 | 0)) {
  ___assert_func(3400, 598, 6400, 1048);
  return 0;
 }
 do {
  if ($cmp222) {
   if (!(__ZNK10ime_pinyin12SpellingTrie14szm_is_enabledEc(0, $char_for_node_2_lcssa) | 0)) {
    break;
   }
   $57 = $7 + ($son_pos_0_lcssa << 3) + 4 | 0;
   $bf_value318_pn = (($char_for_node_2_lcssa << 24 >> 24 > 67 ? 1985 : 1984) + ($char_for_node_2_lcssa << 24 >> 24) & 65535) + ($char_for_node_2_lcssa << 24 >> 24 > 83) & 2047;
   HEAP16[$57 >> 1] = HEAP16[$57 >> 1] & -2048 | $bf_value318_pn;
   HEAP16[$this + 220 + (($bf_value318_pn & 65535) << 1) >> 1] = $item_end - $item_start_next_0_lcssa & 65535;
   label = 2164;
  } else {
   if (!(($level | 0) == 1 & $char_for_node_2_lcssa << 24 >> 24 == 104)) {
    break;
   }
   $60 = HEAP8[$spelling_last_start_0_lcssa] | 0;
   if (($60 << 24 >> 24 | 0) == 67) {
    $part_id336_0180 = 4;
   } else if (($60 << 24 >> 24 | 0) == 83) {
    $part_id336_0180 = 21;
   } else {
    $cmp346 = $60 << 24 >> 24 == 90;
    if ($cmp346) {
     $part_id336_0180 = $cmp346 ? 29 : 0;
    } else {
     break;
    }
   }
   $62 = $7 + ($son_pos_0_lcssa << 3) + 4 | 0;
   HEAP16[$62 >> 1] = HEAP16[$62 >> 1] & -2048 | $part_id336_0180;
   HEAP16[$this + 220 + (($part_id336_0180 & 65535) << 1) >> 1] = $item_end - $item_start_next_0_lcssa & 65535;
   label = 2164;
  }
 } while (0);
 do {
  if ((label | 0) == 2164) {
   $idxprom370 = HEAP16[$7 + ($son_pos_0_lcssa << 3) + 4 >> 1] & 2047;
   if ((HEAP16[$this + 220 + ($idxprom370 << 1) >> 1] | 0) == 0) {
    HEAP16[$this + 160 + ($idxprom370 << 1) >> 1] = 0;
    break;
   } else {
    HEAP16[$this + 160 + ($idxprom370 << 1) >> 1] = $item_start_next_0_lcssa + 30 & 65535;
    break;
   }
  }
 } while (0);
 $71 = $parent + 4 | 0;
 HEAP16[$71 >> 1] = HEAP16[$71 >> 1] & 2047 | $num_of_son_0_lcssa << 11;
 HEAP8[$parent + 7 | 0] = $_min_son_score_0166;
 $retval_0 = $7;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie13build_ym_infoEv($this) {
 $this = $this | 0;
 var $ym_item_size = 0, $ym_num = 0, $call = 0, $0 = 0, $spelling_num_ = 0, $spelling_buf_ = 0, $spelling_size_ = 0, $conv25 = 0, $pos_024 = 0, $5 = 0, $call4 = 0, $call13 = 0, $ym_buf_ = 0, $9 = 0, $call19 = 0, $mul32 = 0, $spl_ym_ids_ = 0, $19 = 0, $call46 = 0, $conv5720 = 0, $id_019 = 0, $call63 = 0, $call68 = 0, $inc81 = 0, $conv57 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $ym_item_size = sp | 0;
 $ym_num = sp + 8 | 0;
 $call = __Znwj(56) | 0;
 $0 = $call;
 __ZN10ime_pinyin13SpellingTableC2Ev($0);
 if (!(__ZN10ime_pinyin13SpellingTable10init_tableEjjb($0, 5, 128, 0) | 0)) {
  ___assert_func(3400, 372, 6536, 2888);
  return 0;
 }
 $spelling_num_ = $this + 8 | 0;
 L2775 : do {
  if ((HEAP32[$spelling_num_ >> 2] | 0) != 0) {
   $spelling_buf_ = $this | 0;
   $spelling_size_ = $this + 4 | 0;
   $pos_024 = 0;
   $conv25 = 0;
   while (1) {
    $5 = HEAP32[$spelling_buf_ >> 2] | 0;
    $call4 = __ZN10ime_pinyin12SpellingTrie10get_ym_strEPKc(0, $5 + (Math_imul(HEAP32[$spelling_size_ >> 2] | 0, $conv25) | 0) | 0) | 0;
    if ((HEAP8[$call4] | 0) != 0) {
     if (!(__ZN10ime_pinyin13SpellingTable12put_spellingEPKcd($0, $call4, 0.0) | 0)) {
      break;
     }
    }
    $pos_024 = $pos_024 + 1 & 65535;
    $conv25 = $pos_024 & 65535;
    if ($conv25 >>> 0 >= (HEAP32[$spelling_num_ >> 2] | 0) >>> 0) {
     break L2775;
    }
   }
   ___assert_func(3400, 379, 6536, 2888);
   return 0;
  }
 } while (0);
 $call13 = __ZN10ime_pinyin13SpellingTable7arrangeEPjS1_($0, $ym_item_size, $ym_num) | 0;
 $ym_buf_ = $this + 24 | 0;
 $9 = HEAP32[$ym_buf_ >> 2] | 0;
 if (($9 | 0) != 0) {
  __ZdaPv($9);
 }
 $call19 = __Znaj(Math_imul(HEAP32[$ym_num >> 2] | 0, HEAP32[$ym_item_size >> 2] | 0) | 0) | 0;
 HEAP32[$ym_buf_ >> 2] = $call19;
 if (($call19 | 0) == 0) {
  if (($call | 0) == 0) {
   $retval_0 = 0;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
  __ZN10ime_pinyin13SpellingTableD2Ev($0);
  __ZdlPv($call);
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $mul32 = Math_imul(HEAP32[$ym_num >> 2] | 0, HEAP32[$ym_item_size >> 2] | 0) | 0;
 _memcpy($call19 | 0, $call13 | 0, $mul32) | 0;
 HEAP32[$this + 28 >> 2] = HEAP32[$ym_item_size >> 2];
 HEAP32[$this + 32 >> 2] = HEAP32[$ym_num >> 2];
 if (($call | 0) != 0) {
  __ZN10ime_pinyin13SpellingTableD2Ev($0);
  __ZdlPv($call);
 }
 $spl_ym_ids_ = $this + 20 | 0;
 $19 = HEAP32[$spl_ym_ids_ >> 2] | 0;
 if (($19 | 0) != 0) {
  __ZdlPv($19);
 }
 $call46 = __Znaj((HEAP32[$spelling_num_ >> 2] | 0) + 30 | 0) | 0;
 HEAP32[$spl_ym_ids_ >> 2] = $call46;
 if (($call46 | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _memset($call46 | 0, 0, (HEAP32[$spelling_num_ >> 2] | 0) + 30 | 0);
 if (((HEAP32[$spelling_num_ >> 2] | 0) + 30 | 0) >>> 0 > 1) {
  $id_019 = 1;
  $conv5720 = 1;
 } else {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 while (1) {
  $call63 = __ZN10ime_pinyin12SpellingTrie10get_ym_strEPKc(0, __ZN10ime_pinyin12SpellingTrie16get_spelling_strEt($this, $id_019) | 0) | 0;
  if ((HEAP8[$call63] | 0) == 0) {
   HEAP8[(HEAP32[$spl_ym_ids_ >> 2] | 0) + $conv5720 | 0] = 0;
  } else {
   $call68 = __ZN10ime_pinyin12SpellingTrie9get_ym_idEPKc($this, $call63) | 0;
   HEAP8[(HEAP32[$spl_ym_ids_ >> 2] | 0) + $conv5720 | 0] = $call68;
   if ($call68 << 24 >> 24 == 0) {
    label = 2200;
    break;
   }
  }
  $inc81 = $id_019 + 1 & 65535;
  $conv57 = $inc81 & 65535;
  if ($conv57 >>> 0 < ((HEAP32[$spelling_num_ >> 2] | 0) + 30 | 0) >>> 0) {
   $id_019 = $inc81;
   $conv5720 = $conv57;
  } else {
   $retval_0 = 1;
   label = 2207;
   break;
  }
 }
 if ((label | 0) == 2207) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2200) {
  ___assert_func(3400, 418, 6536, 1992);
  return 0;
 }
 return 0;
}
function __ZN10ime_pinyin4SyncD2Ev($this) {
 $this = $this | 0;
 return;
}
function __ZN10ime_pinyin12SpellingTrie16get_spelling_numEv($this) {
 $this = $this | 0;
 return HEAP32[$this + 8 >> 2] | 0;
}
function __ZN10ime_pinyin12SpellingTrie18get_spelling_str16Et($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 var $splstr16_queried_ = 0, $spelling_size_ = 0, $1 = 0, $conv5 = 0, $spelling_buf_ = 0, $2 = 0, $pos_014 = 0, $add = 0, $dec_splid = 0, $18 = 0;
 $splstr16_queried_ = $this + 40 | 0;
 HEAP16[HEAP32[$splstr16_queried_ >> 2] >> 1] = 0;
 if (($splid & 65535) > 29) {
  $spelling_size_ = $this + 4 | 0;
  $1 = HEAP32[$spelling_size_ >> 2] | 0;
  if (($1 | 0) == 0) {
   $18 = HEAP32[$splstr16_queried_ >> 2] | 0;
   return $18 | 0;
  }
  $conv5 = $splid - 30 & 65535;
  $spelling_buf_ = $this | 0;
  $pos_014 = 0;
  $2 = $1;
  do {
   $add = (Math_imul($2, $conv5) | 0) + $pos_014 | 0;
   HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + ($pos_014 << 1) >> 1] = HEAP8[(HEAP32[$spelling_buf_ >> 2] | 0) + $add | 0] | 0;
   $pos_014 = $pos_014 + 1 | 0;
   $2 = HEAP32[$spelling_size_ >> 2] | 0;
  } while ($pos_014 >>> 0 < $2 >>> 0);
  $18 = HEAP32[$splstr16_queried_ >> 2] | 0;
  return $18 | 0;
 }
 if (($splid << 16 >> 16 | 0) == 21) {
  HEAP16[HEAP32[$splstr16_queried_ >> 2] >> 1] = 83;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 2 >> 1] = 104;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 4 >> 1] = 0;
  $18 = HEAP32[$splstr16_queried_ >> 2] | 0;
  return $18 | 0;
 } else if (($splid << 16 >> 16 | 0) == 29) {
  HEAP16[HEAP32[$splstr16_queried_ >> 2] >> 1] = 90;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 2 >> 1] = 104;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 4 >> 1] = 0;
  $18 = HEAP32[$splstr16_queried_ >> 2] | 0;
  return $18 | 0;
 } else if (($splid << 16 >> 16 | 0) == 4) {
  HEAP16[HEAP32[$splstr16_queried_ >> 2] >> 1] = 67;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 2 >> 1] = 104;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 4 >> 1] = 0;
  $18 = HEAP32[$splstr16_queried_ >> 2] | 0;
  return $18 | 0;
 } else {
  $dec_splid = ((($splid & 65535) > 3) << 31 >> 31) + $splid & 65535;
  HEAP16[HEAP32[$splstr16_queried_ >> 2] >> 1] = ($dec_splid + 64 & 65535) + ((($dec_splid & 65535) > 19) << 31 >> 31) & 65535;
  HEAP16[(HEAP32[$splstr16_queried_ >> 2] | 0) + 2 >> 1] = 0;
  $18 = HEAP32[$splstr16_queried_ >> 2] | 0;
  return $18 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin12SpellingTrie18get_spelling_str16EtPtj($this, $splid, $splstr16, $splstr16_len) {
 $this = $this | 0;
 $splid = $splid | 0;
 $splstr16 = $splstr16 | 0;
 $splstr16_len = $splstr16_len | 0;
 var $conv8 = 0, $spelling_size_ = 0, $spelling_buf_ = 0, $pos_0 = 0, $add = 0, $2 = 0, $dec_splid = 0, $retval_0 = 0, label = 0;
 if (($splstr16 | 0) == 0 | $splstr16_len >>> 0 < 7) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (($splid & 65535) > 29) {
  $conv8 = $splid - 30 & 65535;
  $spelling_size_ = $this + 4 | 0;
  $spelling_buf_ = $this | 0;
  $pos_0 = 0;
  while (1) {
   if ($pos_0 >>> 0 >= 7) {
    $retval_0 = 0;
    label = 2239;
    break;
   }
   $add = (Math_imul(HEAP32[$spelling_size_ >> 2] | 0, $conv8) | 0) + $pos_0 | 0;
   $2 = HEAP8[(HEAP32[$spelling_buf_ >> 2] | 0) + $add | 0] | 0;
   HEAP16[$splstr16 + ($pos_0 << 1) >> 1] = $2 << 24 >> 24;
   if ($2 << 24 >> 24 == 0) {
    $retval_0 = $pos_0;
    label = 2245;
    break;
   } else {
    $pos_0 = $pos_0 + 1 | 0;
   }
  }
  if ((label | 0) == 2245) {
   return $retval_0 | 0;
  } else if ((label | 0) == 2239) {
   return $retval_0 | 0;
  }
 }
 if (($splid << 16 >> 16 | 0) == 29) {
  HEAP16[$splstr16 >> 1] = 90;
  HEAP16[$splstr16 + 2 >> 1] = 104;
  HEAP16[$splstr16 + 4 >> 1] = 0;
  $retval_0 = 2;
  return $retval_0 | 0;
 } else if (($splid << 16 >> 16 | 0) == 21) {
  HEAP16[$splstr16 >> 1] = 83;
  HEAP16[$splstr16 + 2 >> 1] = 104;
  HEAP16[$splstr16 + 4 >> 1] = 0;
  $retval_0 = 2;
  return $retval_0 | 0;
 } else if (($splid << 16 >> 16 | 0) == 4) {
  HEAP16[$splstr16 >> 1] = 67;
  HEAP16[$splstr16 + 2 >> 1] = 104;
  HEAP16[$splstr16 + 4 >> 1] = 0;
  $retval_0 = 2;
  return $retval_0 | 0;
 } else {
  $dec_splid = ((($splid & 65535) > 3) << 31 >> 31) + $splid & 65535;
  HEAP16[$splstr16 >> 1] = ($dec_splid + 64 & 65535) + ((($dec_splid & 65535) > 19) << 31 >> 31) & 65535;
  HEAP16[$splstr16 + 2 >> 1] = 0;
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin4SyncC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 0;
 HEAP32[$this + 4 >> 2] = 0;
 HEAP32[$this + 8 >> 2] = 0;
 return;
}
function __ZN10ime_pinyin4Sync18get_last_got_countEv($this) {
 $this = $this | 0;
 return HEAP32[$this + 8 >> 2] | 0;
}
function _utf16_strtok($utf16_str, $token_size, $utf16_str_next) {
 $utf16_str = $utf16_str | 0;
 $token_size = $token_size | 0;
 $utf16_str_next = $utf16_str_next | 0;
 var $pos_0 = 0, $arrayidx = 0, $0 = 0, $pos_1 = 0, $arrayidx_sum = 0, $arrayidx13 = 0, $1 = 0, $retval_0 = 0, label = 0;
 if (($utf16_str | 0) == 0 | ($token_size | 0) == 0 | ($utf16_str_next | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $pos_0 = 0;
 }
 while (1) {
  $arrayidx = $utf16_str + ($pos_0 << 1) | 0;
  $0 = HEAP16[$arrayidx >> 1] | 0;
  if (!(($0 << 16 >> 16 | 0) == 32 | ($0 << 16 >> 16 | 0) == 10 | ($0 << 16 >> 16 | 0) == 9)) {
   $pos_1 = 0;
   break;
  }
  $pos_0 = $pos_0 + 1 | 0;
 }
 while (1) {
  $arrayidx_sum = $pos_1 + $pos_0 | 0;
  $arrayidx13 = $utf16_str + ($arrayidx_sum << 1) | 0;
  $1 = HEAP16[$arrayidx13 >> 1] | 0;
  if (($1 << 16 >> 16 | 0) == 9 | ($1 << 16 >> 16 | 0) == 10 | ($1 << 16 >> 16 | 0) == 32) {
   label = 2254;
   break;
  } else if (($1 << 16 >> 16 | 0) == 0) {
   label = 2253;
   break;
  }
  $pos_1 = $pos_1 + 1 | 0;
 }
 do {
  if ((label | 0) == 2254) {
   HEAP32[$utf16_str_next >> 2] = $utf16_str + ($arrayidx_sum + 1 << 1);
  } else if ((label | 0) == 2253) {
   HEAP32[$utf16_str_next >> 2] = 0;
   if (($pos_1 | 0) == 0) {
    $retval_0 = 0;
   } else {
    break;
   }
   return $retval_0 | 0;
  }
 } while (0);
 HEAP16[$arrayidx13 >> 1] = 0;
 HEAP32[$token_size >> 2] = $pos_1;
 $retval_0 = $arrayidx;
 return $retval_0 | 0;
}
function _utf16_atoi($utf16_str) {
 $utf16_str = $utf16_str | 0;
 var $cmp1 = 0, $_ = 0, $_10 = 0, $1 = 0, $3 = 0, $pos_014 = 0, $value_013 = 0, $add = 0, $inc12 = 0, $4 = 0, $value_0_lcssa = 0, $retval_0 = 0;
 if (($utf16_str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $cmp1 = (HEAP16[$utf16_str >> 1] | 0) == 45;
 $_ = $cmp1 ? -1 : 1;
 $_10 = $cmp1 & 1;
 $1 = HEAP16[$utf16_str + ($_10 << 1) >> 1] | 0;
 if (($1 - 48 & 65535) < 10) {
  $value_013 = 0;
  $pos_014 = $_10;
  $3 = $1;
  while (1) {
   $add = ($value_013 * 10 | 0) - 48 + ($3 & 65535) | 0;
   $inc12 = $pos_014 + 1 | 0;
   $4 = HEAP16[$utf16_str + ($inc12 << 1) >> 1] | 0;
   if (($4 - 48 & 65535) < 10) {
    $value_013 = $add;
    $pos_014 = $inc12;
    $3 = $4;
   } else {
    $value_0_lcssa = $add;
    break;
   }
  }
 } else {
  $value_0_lcssa = 0;
 }
 $retval_0 = Math_imul($value_0_lcssa, $_) | 0;
 return $retval_0 | 0;
}
function _utf16_strlen($utf16_str) {
 $utf16_str = $utf16_str | 0;
 var $size_0 = 0, $retval_0 = 0;
 if (($utf16_str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $size_0 = 0;
 }
 while (1) {
  if ((HEAP16[$utf16_str + ($size_0 << 1) >> 1] | 0) == 0) {
   $retval_0 = $size_0;
   break;
  } else {
   $size_0 = $size_0 + 1 | 0;
  }
 }
 return $retval_0 | 0;
}
function _utf16_strcpy_tochar($dst, $src) {
 $dst = $dst | 0;
 $src = $src | 0;
 var $0 = 0, $cp_010 = 0, $src_addr_09 = 0, $incdec_ptr = 0, $incdec_ptr4 = 0, $1 = 0, $retval_0 = 0;
 if (($src | 0) == 0 | ($dst | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $0 = HEAP16[$src >> 1] | 0;
 HEAP8[$dst] = $0 & 255;
 if ($0 << 16 >> 16 == 0) {
  $retval_0 = $dst;
  return $retval_0 | 0;
 } else {
  $src_addr_09 = $src;
  $cp_010 = $dst;
 }
 while (1) {
  $incdec_ptr = $cp_010 + 1 | 0;
  $incdec_ptr4 = $src_addr_09 + 2 | 0;
  $1 = HEAP16[$incdec_ptr4 >> 1] | 0;
  HEAP8[$incdec_ptr] = $1 & 255;
  if ($1 << 16 >> 16 == 0) {
   $retval_0 = $dst;
   break;
  } else {
   $src_addr_09 = $incdec_ptr4;
   $cp_010 = $incdec_ptr;
  }
 }
 return $retval_0 | 0;
}
function _utf16_strcmp($str1, $str2) {
 $str1 = $str1 | 0;
 $str2 = $str2 | 0;
 var $pos_0 = 0, $0 = 0, $1 = 0;
 $pos_0 = 0;
 while (1) {
  $0 = HEAP16[$str1 + ($pos_0 << 1) >> 1] | 0;
  $1 = HEAP16[$str2 + ($pos_0 << 1) >> 1] | 0;
  if ($0 << 16 >> 16 == $1 << 16 >> 16 & $0 << 16 >> 16 != 0) {
   $pos_0 = $pos_0 + 1 | 0;
  } else {
   break;
  }
 }
 return ($0 & 65535) - ($1 & 65535) | 0;
}
function _utf16_strncmp($str1, $str2, $size) {
 $str1 = $str1 | 0;
 $str2 = $str2 | 0;
 $size = $size | 0;
 var $pos_0 = 0, $0 = 0, $retval_0 = 0;
 $pos_0 = 0;
 while (1) {
  if ($pos_0 >>> 0 >= $size >>> 0) {
   break;
  }
  $0 = HEAP16[$str1 + ($pos_0 << 1) >> 1] | 0;
  if ($0 << 16 >> 16 == (HEAP16[$str2 + ($pos_0 << 1) >> 1] | 0) & $0 << 16 >> 16 != 0) {
   $pos_0 = $pos_0 + 1 | 0;
  } else {
   break;
  }
 }
 if (($pos_0 | 0) == ($size | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = (HEAPU16[$str1 + ($pos_0 << 1) >> 1] | 0) - (HEAPU16[$str2 + ($pos_0 << 1) >> 1] | 0) | 0;
 return $retval_0 | 0;
}
function _utf16_strcpy($dst, $src) {
 $dst = $dst | 0;
 $src = $src | 0;
 var $0 = 0, $cp_09 = 0, $src_addr_08 = 0, $incdec_ptr = 0, $incdec_ptr3 = 0, $1 = 0, $retval_0 = 0;
 if (($src | 0) == 0 | ($dst | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $0 = HEAP16[$src >> 1] | 0;
 HEAP16[$dst >> 1] = $0;
 if ($0 << 16 >> 16 == 0) {
  $retval_0 = $dst;
  return $retval_0 | 0;
 } else {
  $src_addr_08 = $src;
  $cp_09 = $dst;
 }
 while (1) {
  $incdec_ptr = $cp_09 + 2 | 0;
  $incdec_ptr3 = $src_addr_08 + 2 | 0;
  $1 = HEAP16[$incdec_ptr3 >> 1] | 0;
  HEAP16[$incdec_ptr >> 1] = $1;
  if ($1 << 16 >> 16 == 0) {
   $retval_0 = $dst;
   break;
  } else {
   $src_addr_08 = $incdec_ptr3;
   $cp_09 = $incdec_ptr;
  }
 }
 return $retval_0 | 0;
}
function _utf16_strncpy($dst, $src, $size) {
 $dst = $dst | 0;
 $src = $src | 0;
 $size = $size | 0;
 var $src_addr_0 = 0, $size_addr_0 = 0, $cp_0 = 0, $0 = 0, $retval_0 = 0;
 L2923 : do {
  if (($src | 0) == 0 | ($dst | 0) == 0 | ($size | 0) == 0) {
   $retval_0 = 0;
  } else {
   if (($src | 0) == ($dst | 0)) {
    $retval_0 = $dst;
    break;
   }
   if ($dst >>> 0 < $src >>> 0) {
    $cp_0 = $dst;
    $size_addr_0 = $size;
    $src_addr_0 = $src;
   } else {
    if ($dst >>> 0 <= $src >>> 0) {
     $retval_0 = $dst;
     break;
    }
    if (($src + ($size << 1) | 0) >>> 0 > $dst >>> 0) {
     $retval_0 = $dst;
     break;
    } else {
     $cp_0 = $dst;
     $size_addr_0 = $size;
     $src_addr_0 = $src;
    }
   }
   while (1) {
    if (($size_addr_0 | 0) == 0) {
     $retval_0 = $dst;
     break L2923;
    }
    $0 = HEAP16[$src_addr_0 >> 1] | 0;
    HEAP16[$cp_0 >> 1] = $0;
    if ($0 << 16 >> 16 == 0) {
     $retval_0 = $dst;
     break;
    } else {
     $cp_0 = $cp_0 + 2 | 0;
     $size_addr_0 = $size_addr_0 - 1 | 0;
     $src_addr_0 = $src_addr_0 + 2 | 0;
    }
   }
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie13load_spl_trieEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $spelling_size_ = 0, $spelling_num_ = 0, $score_amplifier_ = 0, $average_score_ = 0, $spelling_buf_ = 0, $3 = 0, $call23 = 0, $call33 = 0, $8 = 0, $retval_0 = 0;
 if (($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_size_ = $this + 4 | 0;
 if ((_fread($spelling_size_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_num_ = $this + 8 | 0;
 if ((_fread($spelling_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $score_amplifier_ = $this + 12 | 0;
 if ((_fread($score_amplifier_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $average_score_ = $this + 16 | 0;
 if ((_fread($average_score_ | 0, 1, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_buf_ = $this | 0;
 $3 = HEAP32[$spelling_buf_ >> 2] | 0;
 if (($3 | 0) != 0) {
  __ZdaPv($3);
 }
 $call23 = __Znaj(Math_imul(HEAP32[$spelling_num_ >> 2] | 0, HEAP32[$spelling_size_ >> 2] | 0) | 0) | 0;
 HEAP32[$spelling_buf_ >> 2] = $call23;
 if (($call23 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call33 = _fread($call23 | 0, HEAP32[$spelling_size_ >> 2] | 0, HEAP32[$spelling_num_ >> 2] | 0, $fp | 0) | 0;
 $8 = HEAP32[$spelling_num_ >> 2] | 0;
 if (($call33 | 0) != ($8 | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin12SpellingTrie9constructEPKcjjfh($this, HEAP32[$spelling_buf_ >> 2] | 0, HEAP32[$spelling_size_ >> 2] | 0, $8, +HEAPF32[$score_amplifier_ >> 2], HEAP8[$average_score_] | 0) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin4Sync5beginEPKc($this, $filename) {
 $this = $this | 0;
 $filename = $filename | 0;
 var $userdict_ = 0, $call = 0, $dictfile_ = 0, $call9 = 0, $1 = 0, $call19 = 0, $7 = 0, $retval_0 = 0;
 $userdict_ = $this | 0;
 if ((HEAP32[$userdict_ >> 2] | 0) != 0) {
  __ZN10ime_pinyin4Sync6finishEv($this);
 }
 if (($filename | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call = _strdup($filename | 0) | 0;
 $dictfile_ = $this + 4 | 0;
 HEAP32[$dictfile_ >> 2] = $call;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call9 = __Znwj(1132) | 0;
 $1 = $call9;
 __ZN10ime_pinyin8UserDictC2Ev($1);
 HEAP32[$userdict_ >> 2] = $1;
 if (($call9 | 0) == 0) {
  _free(HEAP32[$dictfile_ >> 2] | 0);
  HEAP32[$dictfile_ >> 2] = 0;
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call19 = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$call9 >> 2] | 0) + 8 >> 2] & 31]($1, HEAP32[$dictfile_ >> 2] | 0, 500001, 6e5) | 0;
 $7 = HEAP32[$userdict_ >> 2] | 0;
 if ($call19) {
  __ZN10ime_pinyin8UserDict9set_limitEjjj($7, 5e3, 2e5, 20);
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 if (($7 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[$7 >> 2] | 0) + 4 >> 2] & 127]($7);
 }
 HEAP32[$userdict_ >> 2] = 0;
 _free(HEAP32[$dictfile_ >> 2] | 0);
 HEAP32[$dictfile_ >> 2] = 0;
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin4Sync6finishEv($this) {
 $this = $this | 0;
 var $userdict_ = 0, $0 = 0, $3 = 0, $dictfile_ = 0;
 $userdict_ = $this | 0;
 $0 = HEAP32[$userdict_ >> 2] | 0;
 if (($0 | 0) == 0) {
  return;
 }
 FUNCTION_TABLE_ii[HEAP32[(HEAP32[$0 >> 2] | 0) + 12 >> 2] & 31]($0) | 0;
 $3 = HEAP32[$userdict_ >> 2] | 0;
 if (($3 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[$3 >> 2] | 0) + 4 >> 2] & 127]($3);
 }
 HEAP32[$userdict_ >> 2] = 0;
 $dictfile_ = $this + 4 | 0;
 _free(HEAP32[$dictfile_ >> 2] | 0);
 HEAP32[$dictfile_ >> 2] = 0;
 HEAP32[$this + 8 >> 2] = 0;
 return;
}
function __ZN10ime_pinyin4Sync10put_lemmasEPti($this, $lemmas, $len) {
 $this = $this | 0;
 $lemmas = $lemmas | 0;
 $len = $len | 0;
 return __ZN10ime_pinyin8UserDict38put_lemmas_no_sync_from_utf16le_stringEPti(HEAP32[$this >> 2] | 0, $lemmas, $len) | 0;
}
function __ZN10ime_pinyin4Sync10get_lemmasEPti($this, $str, $size) {
 $this = $this | 0;
 $str = $str | 0;
 $size = $size | 0;
 return __ZN10ime_pinyin8UserDict48get_sync_lemmas_in_utf16le_string_from_beginningEPtiPi(HEAP32[$this >> 2] | 0, $str, $size, $this + 8 | 0) | 0;
}
function __ZN10ime_pinyin4Sync15get_total_countEv($this) {
 $this = $this | 0;
 return __ZN10ime_pinyin8UserDict14get_sync_countEv(HEAP32[$this >> 2] | 0) | 0;
}
function __ZN10ime_pinyin4Sync14clear_last_gotEv($this) {
 $this = $this | 0;
 var $last_count_ = 0, $0 = 0;
 $last_count_ = $this + 8 | 0;
 $0 = HEAP32[$last_count_ >> 2] | 0;
 if (($0 | 0) < 0) {
  return;
 }
 __ZN10ime_pinyin8UserDict17clear_sync_lemmasEjj(HEAP32[$this >> 2] | 0, 0, $0);
 HEAP32[$last_count_ >> 2] = 0;
 return;
}
function __ZN10ime_pinyin4Sync12get_capacityEv($this) {
 $this = $this | 0;
 var $stat = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 $stat = sp | 0;
 __ZN10ime_pinyin8UserDict5stateEPNS0_12UserDictStatE(HEAP32[$this >> 2] | 0, $stat) | 0;
 STACKTOP = sp;
 return (HEAP32[$stat + 52 >> 2] | 0) - (HEAP32[$stat + 28 >> 2] | 0) | 0;
}
function _utf16_atof($utf16_str) {
 $utf16_str = $utf16_str | 0;
 var $arraydecay = 0, $retval_0 = 0.0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 256 | 0;
 if ((_utf16_strlen($utf16_str) | 0) >>> 0 > 255) {
  $retval_0 = 0.0;
  STACKTOP = sp;
  return +$retval_0;
 }
 $arraydecay = sp | 0;
 _utf16_strcpy_tochar($arraydecay, $utf16_str) | 0;
 $retval_0 = +_atof($arraydecay);
 STACKTOP = sp;
 return +$retval_0;
}
function __ZN10ime_pinyin8DictListC2Ev($this) {
 $this = $this | 0;
 HEAP8[$this | 0] = 0;
 _memset($this + 8 | 0, 0, 16);
 HEAP32[$this + 4 >> 2] = __ZN10ime_pinyin12SpellingTrie14get_cpinstanceEv() | 0;
 HEAP32[$this + 96 >> 2] = 14;
 HEAP32[$this + 100 >> 2] = 18;
 HEAP32[$this + 104 >> 2] = 10;
 HEAP32[$this + 108 >> 2] = 12;
 HEAP32[$this + 112 >> 2] = 8;
 HEAP32[$this + 116 >> 2] = 32;
 HEAP32[$this + 120 >> 2] = 46;
 HEAP32[$this + 124 >> 2] = 38;
 return;
}
function __ZN10ime_pinyin8DictListD2Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin8DictList13free_resourceEv($this);
 return;
}
function __ZN10ime_pinyin8DictList13free_resourceEv($this) {
 $this = $this | 0;
 var $buf_ = 0, $0 = 0, $scis_hz_ = 0, $2 = 0, $scis_splid_ = 0, $4 = 0;
 $buf_ = $this + 20 | 0;
 $0 = HEAP32[$buf_ >> 2] | 0;
 if (($0 | 0) != 0) {
  _free($0);
 }
 HEAP32[$buf_ >> 2] = 0;
 $scis_hz_ = $this + 12 | 0;
 $2 = HEAP32[$scis_hz_ >> 2] | 0;
 if (($2 | 0) != 0) {
  _free($2);
 }
 HEAP32[$scis_hz_ >> 2] = 0;
 $scis_splid_ = $this + 16 | 0;
 $4 = HEAP32[$scis_splid_ >> 2] | 0;
 if (($4 | 0) == 0) {
  HEAP32[$scis_splid_ >> 2] = 0;
  return;
 }
 _free($4 | 0);
 HEAP32[$scis_splid_ >> 2] = 0;
 return;
}
function __ZN10ime_pinyin8DictList14alloc_resourceEjj($this, $buf_size, $scis_num) {
 $this = $this | 0;
 $buf_size = $buf_size | 0;
 $scis_num = $scis_num | 0;
 var $call = 0, $scis_num_ = 0, $call5 = 0, $call12 = 0, $retval_0 = 0;
 $call = _malloc($buf_size << 1) | 0;
 HEAP32[$this + 20 >> 2] = $call;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $scis_num_ = $this + 8 | 0;
 HEAP32[$scis_num_ >> 2] = $scis_num;
 $call5 = _malloc($scis_num << 1) | 0;
 HEAP32[$this + 12 >> 2] = $call5;
 if (($call5 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call12 = _malloc(HEAP32[$scis_num_ >> 2] << 1) | 0;
 HEAP32[$this + 16 >> 2] = $call12;
 $retval_0 = ($call12 | 0) != 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictList9init_listEPKNS_14SingleCharItemEjPKNS_10LemmaEntryEj($this, $scis, $scis_num, $lemma_arr, $lemma_num) {
 $this = $this | 0;
 $scis = $scis | 0;
 $scis_num = $scis_num | 0;
 $lemma_arr = $lemma_arr | 0;
 $lemma_num = $lemma_num | 0;
 var $initialized_ = 0, $0 = 0, $call = 0, $retval_0 = 0;
 if (($scis | 0) == 0 | ($scis_num | 0) == 0 | ($lemma_arr | 0) == 0 | ($lemma_num | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $initialized_ = $this | 0;
 HEAP8[$initialized_] = 0;
 $0 = HEAP32[$this + 20 >> 2] | 0;
 if (($0 | 0) != 0) {
  _free($0);
 }
 $call = __ZN10ime_pinyin8DictList14calculate_sizeEPKNS_10LemmaEntryEj($this, $lemma_arr, $lemma_num) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8DictList14alloc_resourceEjj($this, $call, $scis_num) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin8DictList9fill_scisEPKNS_14SingleCharItemEj($this, $scis, $scis_num);
 __ZN10ime_pinyin8DictList9fill_listEPKNS_10LemmaEntryEj($this, $lemma_arr, $lemma_num);
 HEAP8[$initialized_] = 1;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictList13get_lemma_strEjPtt($this, $id_lemma, $str_buf, $str_max) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $str_buf = $str_buf | 0;
 $str_max = $str_max | 0;
 var $sub = 0, $3 = 0, $_lcssa = 0, $add_lcssa29 = 0, $i_024_lcssa28 = 0, $conv625_lcssa27 = 0, $5 = 0, $6 = 0, $add_ptr_sum = 0, $conv3221 = 0, $len_020 = 0, $inc = 0, $retval_0 = 0, $8 = 0, $10 = 0, $12 = 0, $14 = 0, $16 = 0, $18 = 0, $20 = 0, label = 0;
 if ((HEAP8[$this | 0] & 1) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 92 >> 2] | 0) >>> 0 <= $id_lemma >>> 0 | ($str_buf | 0) == 0 | ($str_max & 65535) < 2) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $sub = ($str_max & 65535) - 1 | 0;
 if (($sub | 0) < 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $3 = HEAP32[$this + 60 >> 2] | 0;
 if ($3 >>> 0 > $id_lemma >>> 0) {
  label = 2401;
 } else {
  if ((HEAP32[$this + 64 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
   $conv625_lcssa27 = 0;
   $i_024_lcssa28 = 0;
   $add_lcssa29 = 1;
   $_lcssa = $3;
  } else {
   label = 2401;
  }
 }
 do {
  if ((label | 0) == 2401) {
   if (($sub | 0) < 2) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $8 = HEAP32[$this + 64 >> 2] | 0;
   if ($8 >>> 0 <= $id_lemma >>> 0) {
    if ((HEAP32[$this + 68 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
     $conv625_lcssa27 = 1;
     $i_024_lcssa28 = 1;
     $add_lcssa29 = 2;
     $_lcssa = $8;
     break;
    }
   }
   if (($sub | 0) < 3) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $10 = HEAP32[$this + 68 >> 2] | 0;
   if ($10 >>> 0 <= $id_lemma >>> 0) {
    if ((HEAP32[$this + 72 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
     $conv625_lcssa27 = 2;
     $i_024_lcssa28 = 2;
     $add_lcssa29 = 3;
     $_lcssa = $10;
     break;
    }
   }
   if (($sub | 0) < 4) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $12 = HEAP32[$this + 72 >> 2] | 0;
   if ($12 >>> 0 <= $id_lemma >>> 0) {
    if ((HEAP32[$this + 76 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
     $conv625_lcssa27 = 3;
     $i_024_lcssa28 = 3;
     $add_lcssa29 = 4;
     $_lcssa = $12;
     break;
    }
   }
   if (($sub | 0) < 5) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $14 = HEAP32[$this + 76 >> 2] | 0;
   if ($14 >>> 0 <= $id_lemma >>> 0) {
    if ((HEAP32[$this + 80 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
     $conv625_lcssa27 = 4;
     $i_024_lcssa28 = 4;
     $add_lcssa29 = 5;
     $_lcssa = $14;
     break;
    }
   }
   if (($sub | 0) < 6) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $16 = HEAP32[$this + 80 >> 2] | 0;
   if ($16 >>> 0 <= $id_lemma >>> 0) {
    if ((HEAP32[$this + 84 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
     $conv625_lcssa27 = 5;
     $i_024_lcssa28 = 5;
     $add_lcssa29 = 6;
     $_lcssa = $16;
     break;
    }
   }
   if (($sub | 0) < 7) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $18 = HEAP32[$this + 84 >> 2] | 0;
   if ($18 >>> 0 <= $id_lemma >>> 0) {
    if ((HEAP32[$this + 88 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
     $conv625_lcssa27 = 6;
     $i_024_lcssa28 = 6;
     $add_lcssa29 = 7;
     $_lcssa = $18;
     break;
    }
   }
   if (($sub | 0) < 8) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   $20 = HEAP32[$this + 88 >> 2] | 0;
   if ($20 >>> 0 > $id_lemma >>> 0) {
    $retval_0 = 0;
    return $retval_0 | 0;
   }
   if ((HEAP32[$this + 92 >> 2] | 0) >>> 0 > $id_lemma >>> 0) {
    $conv625_lcssa27 = 7;
    $i_024_lcssa28 = 7;
    $add_lcssa29 = 8;
    $_lcssa = $20;
    break;
   } else {
    $retval_0 = 0;
   }
   return $retval_0 | 0;
  }
 } while (0);
 $5 = HEAP32[$this + 20 >> 2] | 0;
 $6 = HEAP32[$this + 24 + ($conv625_lcssa27 << 2) >> 2] | 0;
 $add_ptr_sum = $6 + (Math_imul($id_lemma - $_lcssa | 0, $add_lcssa29) | 0) | 0;
 $len_020 = 0;
 $conv3221 = 0;
 while (1) {
  HEAP16[$str_buf + ($conv3221 << 1) >> 1] = HEAP16[$5 + ($add_ptr_sum + $conv3221 << 1) >> 1] | 0;
  $inc = $len_020 + 1 & 65535;
  if (($inc & 65535) > ($i_024_lcssa28 & 65535)) {
   break;
  } else {
   $len_020 = $inc;
   $conv3221 = $inc & 65535;
  }
 }
 HEAP16[$str_buf + ($add_lcssa29 << 1) >> 1] = 0;
 $retval_0 = $add_lcssa29 & 65535;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictList21find_pos2_startedbyhzEt($this, $hz_char) {
 $this = $this | 0;
 $hz_char = $hz_char | 0;
 var $hz_char_addr = 0, $buf_ = 0, $arrayidx = 0, $2 = 0, $call = 0, $add_ptr9 = 0, $found_2w_0 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $hz_char_addr = sp | 0;
 HEAP16[$hz_char_addr >> 1] = $hz_char;
 $buf_ = $this + 20 | 0;
 $arrayidx = $this + 28 | 0;
 $2 = HEAP32[$arrayidx >> 2] | 0;
 $call = __ZN10ime_pinyin9mybsearchEPKvS1_jjPFiS1_S1_E($hz_char_addr, (HEAP32[$buf_ >> 2] | 0) + ($2 << 1) | 0, ((HEAP32[$this + 32 >> 2] | 0) - $2 | 0) >>> 1, 4, 14) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $add_ptr9 = (HEAP32[$buf_ >> 2] | 0) + (HEAP32[$arrayidx >> 2] << 1) | 0;
 $found_2w_0 = $call;
 while (1) {
  if ($found_2w_0 >>> 0 <= $add_ptr9 >>> 0) {
   $retval_0 = $found_2w_0;
   label = 2442;
   break;
  }
  if ((HEAP16[$found_2w_0 >> 1] | 0) == (HEAP16[$found_2w_0 - 2 >> 1] | 0)) {
   $found_2w_0 = $found_2w_0 - 4 | 0;
  } else {
   $retval_0 = $found_2w_0;
   label = 2441;
   break;
  }
 }
 if ((label | 0) == 2442) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2441) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictList21find_pos_startedbyhzsEPKtjPFiPKvS4_E($this, $last_hzs, $word_len, $cmp_func) {
 $this = $this | 0;
 $last_hzs = $last_hzs | 0;
 $word_len = $word_len | 0;
 $cmp_func = $cmp_func | 0;
 var $buf_ = 0, $arrayidx = 0, $2 = 0, $call = 0, $idx_neg = 0, $found_w_0 = 0, $add_ptr14 = 0, $retval_0 = 0, label = 0;
 $buf_ = $this + 20 | 0;
 $arrayidx = $this + 24 + ($word_len - 1 << 2) | 0;
 $2 = HEAP32[$arrayidx >> 2] | 0;
 $call = __ZN10ime_pinyin9mybsearchEPKvS1_jjPFiS1_S1_E($last_hzs, (HEAP32[$buf_ >> 2] | 0) + ($2 << 1) | 0, (((HEAP32[$this + 24 + ($word_len << 2) >> 2] | 0) - $2 | 0) >>> 0) / ($word_len >>> 0) | 0, $word_len << 1, $cmp_func) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $idx_neg = -$word_len | 0;
 $found_w_0 = $call;
 while (1) {
  if ($found_w_0 >>> 0 <= ((HEAP32[$buf_ >> 2] | 0) + (HEAP32[$arrayidx >> 2] << 1) | 0) >>> 0) {
   $retval_0 = $found_w_0;
   label = 2450;
   break;
  }
  $add_ptr14 = $found_w_0 + ($idx_neg << 1) | 0;
  if ((FUNCTION_TABLE_iii[$cmp_func & 63]($found_w_0, $add_ptr14) | 0) == 0) {
   $found_w_0 = $add_ptr14;
  } else {
   $retval_0 = $found_w_0;
   label = 2449;
   break;
  }
 }
 if ((label | 0) == 2450) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2449) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictList14calculate_sizeEPKNS_10LemmaEntryEj($this, $lemma_arr, $lemma_num) {
 $this = $this | 0;
 $lemma_arr = $lemma_arr | 0;
 $lemma_num = $lemma_num | 0;
 var $idx_by_hz = 0, $arrayidx9 = 0, $arrayidx10 = 0, $list_size_0_lcssa63 = 0, $id_num_0_lcssa62 = 0, $last_hz_len_0_lcssa61 = 0, $arrayidx56 = 0, $arrayidx58 = 0, $last_hz_len_052 = 0, $i_051 = 0, $id_num_050 = 0, $list_size_049 = 0, $0 = 0, $conv = 0, $inc = 0, $sub = 0, $len_038 = 0, $sub26 = 0, $inc40 = 0, $list_size_1 = 0, $id_num_1 = 0, $last_hz_len_1 = 0, $inc47 = 0, $i49_036 = 0, $inc66 = 0, $arrayidx69 = 0, $4 = 0, label = 0;
 do {
  if (($lemma_num | 0) == 0) {
   $last_hz_len_0_lcssa61 = 0;
   $id_num_0_lcssa62 = 0;
   $list_size_0_lcssa63 = 0;
  } else {
   $idx_by_hz = $lemma_arr + 4 | 0;
   $arrayidx9 = $this + 24 | 0;
   $arrayidx10 = $this + 60 | 0;
   $list_size_049 = 0;
   $id_num_050 = 0;
   $i_051 = 0;
   $last_hz_len_052 = 0;
   L3124 : while (1) {
    $0 = HEAP8[$lemma_arr + ($i_051 * 124 | 0) + 116 | 0] | 0;
    $conv = $0 & 255;
    do {
     if (($i_051 | 0) == 0) {
      if ($0 << 24 >> 24 == 0) {
       label = 2458;
       break L3124;
      }
      if ((HEAP32[$idx_by_hz >> 2] | 0) != 1) {
       label = 2460;
       break L3124;
      }
      $inc = $id_num_050 + 1 | 0;
      HEAP32[$arrayidx9 >> 2] = 0;
      HEAP32[$arrayidx10 >> 2] = $inc;
      $last_hz_len_1 = 1;
      $id_num_1 = $inc;
      $list_size_1 = $list_size_049 + 1 | 0;
     } else {
      if ($conv >>> 0 < $last_hz_len_052 >>> 0) {
       label = 2463;
       break L3124;
      }
      if (($conv | 0) == ($last_hz_len_052 | 0)) {
       $last_hz_len_1 = $last_hz_len_052;
       $id_num_1 = $id_num_050 + 1 | 0;
       $list_size_1 = $conv + $list_size_049 | 0;
       break;
      }
      $sub = $conv - 1 | 0;
      if ($last_hz_len_052 >>> 0 < $sub >>> 0) {
       $len_038 = $last_hz_len_052;
       do {
        $sub26 = $len_038 - 1 | 0;
        HEAP32[$this + 24 + ($len_038 << 2) >> 2] = HEAP32[$this + 24 + ($sub26 << 2) >> 2];
        HEAP32[$this + 60 + ($len_038 << 2) >> 2] = HEAP32[$this + 60 + ($sub26 << 2) >> 2];
        $len_038 = $len_038 + 1 | 0;
       } while ($len_038 >>> 0 < $sub >>> 0);
      }
      HEAP32[$this + 24 + ($sub << 2) >> 2] = $list_size_049;
      $inc40 = $id_num_050 + 1 | 0;
      HEAP32[$this + 60 + ($sub << 2) >> 2] = $inc40;
      $last_hz_len_1 = $conv;
      $id_num_1 = $inc40;
      $list_size_1 = $conv + $list_size_049 | 0;
     }
    } while (0);
    $inc47 = $i_051 + 1 | 0;
    if ($inc47 >>> 0 < $lemma_num >>> 0) {
     $list_size_049 = $list_size_1;
     $id_num_050 = $id_num_1;
     $i_051 = $inc47;
     $last_hz_len_052 = $last_hz_len_1;
    } else {
     label = 2454;
     break;
    }
   }
   if ((label | 0) == 2458) {
    ___assert_func(2896, 122, 5992, 4008);
    return 0;
   } else if ((label | 0) == 2454) {
    if ($last_hz_len_1 >>> 0 < 9) {
     $last_hz_len_0_lcssa61 = $last_hz_len_1;
     $id_num_0_lcssa62 = $id_num_1;
     $list_size_0_lcssa63 = $list_size_1;
     break;
    }
    $arrayidx69 = $this + 56 | 0;
    $4 = HEAP32[$arrayidx69 >> 2] | 0;
    return $4 | 0;
   } else if ((label | 0) == 2460) {
    ___assert_func(2896, 123, 5992, 2800);
    return 0;
   } else if ((label | 0) == 2463) {
    ___assert_func(2896, 134, 5992, 1904);
    return 0;
   }
  }
 } while (0);
 $arrayidx56 = $this + 24 | 0;
 $arrayidx58 = $this + 60 | 0;
 $i49_036 = $last_hz_len_0_lcssa61;
 while (1) {
  if (($i49_036 | 0) == 0) {
   HEAP32[$arrayidx56 >> 2] = 0;
   HEAP32[$arrayidx58 >> 2] = 1;
   $i49_036 = $i49_036 + 1 | 0;
   continue;
  } else {
   HEAP32[$this + 24 + ($i49_036 << 2) >> 2] = $list_size_0_lcssa63;
   HEAP32[$this + 60 + ($i49_036 << 2) >> 2] = $id_num_0_lcssa62;
   $inc66 = $i49_036 + 1 | 0;
   if ($inc66 >>> 0 < 9) {
    $i49_036 = $inc66;
    continue;
   } else {
    break;
   }
  }
 }
 $arrayidx69 = $this + 56 | 0;
 $4 = HEAP32[$arrayidx69 >> 2] | 0;
 return $4 | 0;
}
function __ZN10ime_pinyin8DictList9fill_scisEPKNS_14SingleCharItemEj($this, $scis, $scis_num) {
 $this = $this | 0;
 $scis = $scis | 0;
 $scis_num = $scis_num | 0;
 var $scis_num_ = 0, $scis_hz_ = 0, $scis_splid_ = 0, $pos_08 = 0;
 $scis_num_ = $this + 8 | 0;
 if ((HEAP32[$scis_num_ >> 2] | 0) != ($scis_num | 0)) {
  ___assert_func(2896, 170, 5504, 1472);
 }
 if ((HEAP32[$scis_num_ >> 2] | 0) == 0) {
  return;
 }
 $scis_hz_ = $this + 12 | 0;
 $scis_splid_ = $this + 16 | 0;
 $pos_08 = 0;
 do {
  HEAP16[(HEAP32[$scis_hz_ >> 2] | 0) + ($pos_08 << 1) >> 1] = HEAP16[$scis + ($pos_08 << 3) + 4 >> 1] | 0;
  HEAP16[(HEAP32[$scis_splid_ >> 2] | 0) + ($pos_08 << 1) >> 1] = HEAP16[$scis + ($pos_08 << 3) + 6 >> 1] | 0;
  $pos_08 = $pos_08 + 1 | 0;
 } while ($pos_08 >>> 0 < (HEAP32[$scis_num_ >> 2] | 0) >>> 0);
 return;
}
function __ZN10ime_pinyin8DictList9fill_listEPKNS_10LemmaEntryEj($this, $lemma_arr, $lemma_num) {
 $this = $this | 0;
 $lemma_arr = $lemma_arr | 0;
 $lemma_num = $lemma_num | 0;
 var $buf_ = 0, $hz_str_len = 0, $conv5 = 0, $i_016 = 0, $current_pos_014 = 0, $hz_str_len11 = 0, $inc17 = 0, $add = 0, $id_num_0_lcssa = 0, $current_pos_0_lcssa = 0;
 $buf_ = $this + 20 | 0;
 $hz_str_len = $lemma_arr + 116 | 0;
 _utf16_strncpy(HEAP32[$buf_ >> 2] | 0, $lemma_arr + 8 | 0, HEAPU8[$hz_str_len] | 0) | 0;
 $conv5 = HEAPU8[$hz_str_len] | 0;
 if ($lemma_num >>> 0 > 1) {
  $current_pos_014 = $conv5;
  $i_016 = 1;
  while (1) {
   $hz_str_len11 = $lemma_arr + ($i_016 * 124 | 0) + 116 | 0;
   _utf16_strncpy((HEAP32[$buf_ >> 2] | 0) + ($current_pos_014 << 1) | 0, $lemma_arr + ($i_016 * 124 | 0) + 8 | 0, HEAPU8[$hz_str_len11] | 0) | 0;
   $inc17 = $i_016 + 1 | 0;
   $add = (HEAPU8[$hz_str_len11] | 0) + $current_pos_014 | 0;
   if ($inc17 >>> 0 < $lemma_num >>> 0) {
    $current_pos_014 = $add;
    $i_016 = $inc17;
   } else {
    $current_pos_0_lcssa = $add;
    $id_num_0_lcssa = $lemma_num;
    break;
   }
  }
 } else {
  $current_pos_0_lcssa = $conv5;
  $id_num_0_lcssa = 1;
 }
 if (($current_pos_0_lcssa | 0) != (HEAP32[$this + 56 >> 2] | 0)) {
  ___assert_func(2896, 196, 5592, 1232);
 }
 if (($id_num_0_lcssa | 0) == (HEAP32[$this + 92 >> 2] | 0)) {
  return;
 } else {
  ___assert_func(2896, 197, 5592, 1008);
 }
}
function __ZN10ime_pinyin8DictList7predictEPKttPNS_12NPredictItemEjj($this, $last_hzs, $hzs_len, $npre_items, $npre_max, $b4_used) {
 $this = $this | 0;
 $last_hzs = $last_hzs | 0;
 $hzs_len = $hzs_len | 0;
 $npre_items = $npre_items | 0;
 $npre_max = $npre_max | 0;
 $b4_used = $b4_used | 0;
 var $conv = 0, $0 = 0, $call = 0, $sub7 = 0, $buf_ = 0, $1 = 0, $conv557 = 0, $item_num_056 = 0, $pre_len_055 = 0, $conv12 = 0, $call13 = 0, $arrayidx15 = 0, $sub29 = 0, $arrayidx31 = 0, $arrayidx36 = 0, $w_buf_052 = 0, $item_num_151 = 0, $add_ptr21 = 0, $inc = 0, $add_ptr42 = 0, $item_num_2 = 0, $inc43 = 0, $conv5 = 0, $i_048 = 0, $new_num_047 = 0, $arraydecay55 = 0, $e_pos_0 = 0, $11 = 0, $12 = 0, $new_num_1 = 0, $inc70 = 0, $new_num_0_lcssa = 0, label = 0;
 $conv = $hzs_len & 65535;
 if (($hzs_len & 65535) > 7 | $hzs_len << 16 >> 16 == 0) {
  ___assert_func(2896, 236, 5672, 848);
  return 0;
 }
 $0 = HEAP32[$this + 96 + ($conv - 1 << 2) >> 2] | 0;
 $call = __ZN10ime_pinyin5NGram12get_instanceEv() | 0;
 $sub7 = 8 - $conv | 0;
 if ($hzs_len << 16 >> 16 == 8) {
  $new_num_0_lcssa = 0;
  return $new_num_0_lcssa | 0;
 }
 $buf_ = $this + 20 | 0;
 $1 = $last_hzs;
 $pre_len_055 = 1;
 $item_num_056 = 0;
 $conv557 = 1;
 while (1) {
  $conv12 = $pre_len_055 + $hzs_len & 65535;
  $call13 = __ZN10ime_pinyin8DictList21find_pos_startedbyhzsEPKtjPFiPKvS4_E($this, $last_hzs, $conv12, $0) | 0;
  L3183 : do {
   if (($call13 | 0) == 0) {
    $item_num_2 = $item_num_056;
   } else {
    $arrayidx15 = $this + 24 + ($conv12 << 2) | 0;
    if ($call13 >>> 0 >= ((HEAP32[$buf_ >> 2] | 0) + (HEAP32[$arrayidx15 >> 2] << 1) | 0) >>> 0) {
     $item_num_2 = $item_num_056;
     break;
    }
    $sub29 = $conv12 - 1 | 0;
    $arrayidx31 = $this + 24 + ($sub29 << 2) | 0;
    $arrayidx36 = $this + 60 + ($sub29 << 2) | 0;
    $item_num_151 = $item_num_056;
    $w_buf_052 = $call13;
    while (1) {
     if (!((FUNCTION_TABLE_iii[$0 & 63]($w_buf_052, $1) | 0) == 0 & $item_num_151 >>> 0 < $npre_max >>> 0)) {
      $item_num_2 = $item_num_151;
      break L3183;
     }
     $add_ptr21 = $npre_items + ($item_num_151 * 20 | 0) | 0;
     _memset($add_ptr21 | 0, 0, 20);
     _utf16_strncpy($npre_items + ($item_num_151 * 20 | 0) + 4 | 0, $w_buf_052 + ($conv << 1) | 0, $conv557) | 0;
     HEAPF32[$add_ptr21 >> 2] = +__ZN10ime_pinyin5NGram11get_uni_psbEj($call, (HEAP32[$arrayidx36 >> 2] | 0) + (((($w_buf_052 - (HEAP32[$buf_ >> 2] | 0) >> 1) - (HEAP32[$arrayidx31 >> 2] | 0) | 0) >>> 0) / ($conv12 >>> 0) | 0) | 0);
     HEAP16[$npre_items + ($item_num_151 * 20 | 0) + 18 >> 1] = $hzs_len;
     $inc = $item_num_151 + 1 | 0;
     $add_ptr42 = $w_buf_052 + ($conv12 << 1) | 0;
     if ($add_ptr42 >>> 0 < ((HEAP32[$buf_ >> 2] | 0) + (HEAP32[$arrayidx15 >> 2] << 1) | 0) >>> 0) {
      $item_num_151 = $inc;
      $w_buf_052 = $add_ptr42;
     } else {
      $item_num_2 = $inc;
      break;
     }
    }
   }
  } while (0);
  $inc43 = $pre_len_055 + 1 & 65535;
  $conv5 = $inc43 & 65535;
  if ($conv5 >>> 0 > $sub7 >>> 0) {
   break;
  } else {
   $pre_len_055 = $inc43;
   $item_num_056 = $item_num_2;
   $conv557 = $conv5;
  }
 }
 if (($item_num_2 | 0) == 0) {
  $new_num_0_lcssa = 0;
  return $new_num_0_lcssa | 0;
 } else {
  $new_num_047 = 0;
  $i_048 = 0;
 }
 while (1) {
  $arraydecay55 = $npre_items + ($i_048 * 20 | 0) + 4 | 0;
  $e_pos_0 = 1;
  while (1) {
   if ($e_pos_0 >>> 0 > $b4_used >>> 0) {
    label = 2505;
    break;
   }
   if ((_utf16_strncmp($npre_items + ((-$e_pos_0 | 0) * 20 | 0) + 4 | 0, $arraydecay55, 7) | 0) == 0) {
    $new_num_1 = $new_num_047;
    break;
   } else {
    $e_pos_0 = $e_pos_0 + 1 | 0;
   }
  }
  if ((label | 0) == 2505) {
   label = 0;
   $11 = $npre_items + ($new_num_047 * 20 | 0) | 0;
   $12 = $npre_items + ($i_048 * 20 | 0) | 0;
   HEAP32[$11 >> 2] = HEAP32[$12 >> 2];
   HEAP32[$11 + 4 >> 2] = HEAP32[$12 + 4 >> 2];
   HEAP32[$11 + 8 >> 2] = HEAP32[$12 + 8 >> 2];
   HEAP32[$11 + 12 >> 2] = HEAP32[$12 + 12 >> 2];
   HEAP32[$11 + 16 >> 2] = HEAP32[$12 + 16 >> 2];
   $new_num_1 = $new_num_047 + 1 | 0;
  }
  $inc70 = $i_048 + 1 | 0;
  if ($inc70 >>> 0 < $item_num_2 >>> 0) {
   $new_num_047 = $new_num_1;
   $i_048 = $inc70;
  } else {
   $new_num_0_lcssa = $new_num_1;
   break;
  }
 }
 return $new_num_0_lcssa | 0;
}
function __ZN10ime_pinyin8DictList20get_splids_for_hanziEttPtt($this, $hanzi, $half_splid, $splids, $max_splids) {
 $this = $this | 0;
 $hanzi = $hanzi | 0;
 $half_splid = $half_splid | 0;
 $splids = $splids | 0;
 $max_splids = $max_splids | 0;
 var $hanzi_addr = 0, $scis_hz_ = 0, $scis_num_ = 0, $call = 0, $4 = 0, $7 = 0, $8 = 0, $hz_found_0 = 0, $add_ptr = 0, $10 = 0, $12 = 0, $cmp23 = 0, $scis_splid_ = 0, $13 = 0, $hz_f_033 = 0, $strict_0_off032 = 0, $strict_0_off0_lcssa = 0, $15 = 0, $cmp48 = 0, $conv68 = 0, $scis_splid_74 = 0, $scis_splid_52 = 0, $spl_trie_ = 0, $scis_splid_62 = 0, $strict_1_off0 = 0, $incdec_ptr27 = 0, $20 = 0, $22 = 0, $hz_found_129 = 0, $found_num_028 = 0, $sub_ptr_div4523 = 0, $conv67 = 0, $found_num_1 = 0, $incdec_ptr80 = 0, $37 = 0, $found_num_0_lcssa = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $hanzi_addr = sp | 0;
 HEAP16[$hanzi_addr >> 1] = $hanzi;
 $scis_hz_ = $this + 12 | 0;
 $scis_num_ = $this + 8 | 0;
 $call = __ZN10ime_pinyin9mybsearchEPKvS1_jjPFiS1_S1_E($hanzi_addr, HEAP32[$scis_hz_ >> 2] | 0, HEAP32[$scis_num_ >> 2] | 0, 2, 14) | 0;
 $4 = $call;
 if (($call | 0) == 0) {
  ___assert_func(2896, 314, 5768, 688);
  return 0;
 }
 if ((HEAP16[$hanzi_addr >> 1] | 0) != (HEAP16[$4 >> 1] | 0)) {
  ___assert_func(2896, 314, 5768, 688);
  return 0;
 }
 $7 = HEAP32[$scis_hz_ >> 2] | 0;
 $8 = HEAP16[$hanzi_addr >> 1] | 0;
 $hz_found_0 = $4;
 while (1) {
  if ($hz_found_0 >>> 0 <= $7 >>> 0) {
   break;
  }
  $add_ptr = $hz_found_0 - 2 | 0;
  if ($8 << 16 >> 16 == (HEAP16[$add_ptr >> 1] | 0)) {
   $hz_found_0 = $add_ptr;
  } else {
   break;
  }
 }
 $10 = HEAP32[$scis_hz_ >> 2] | 0;
 L3213 : do {
  if ($hz_found_0 >>> 0 < ($10 + (HEAP32[$scis_num_ >> 2] << 1) | 0) >>> 0) {
   $12 = HEAP16[$hanzi_addr >> 1] | 0;
   $cmp23 = $half_splid << 16 >> 16 == 0;
   $scis_splid_ = $this + 16 | 0;
   $strict_0_off032 = 0;
   $hz_f_033 = $hz_found_0;
   $13 = $10;
   while (1) {
    if ($12 << 16 >> 16 != (HEAP16[$hz_f_033 >> 1] | 0)) {
     $strict_0_off0_lcssa = $strict_0_off032;
     break L3213;
    }
    if ($cmp23) {
     label = 2524;
    } else {
     if ((HEAP16[(HEAP32[$scis_splid_ >> 2] | 0) + ((($hz_f_033 - $13 | 0) >>> 1 & 65535) << 1) >> 1] & 31) == $half_splid << 16 >> 16) {
      label = 2524;
     } else {
      $strict_1_off0 = $strict_0_off032;
     }
    }
    if ((label | 0) == 2524) {
     label = 0;
     $strict_1_off0 = 1;
    }
    $incdec_ptr27 = $hz_f_033 + 2 | 0;
    $20 = HEAP32[$scis_hz_ >> 2] | 0;
    if ($incdec_ptr27 >>> 0 < ($20 + (HEAP32[$scis_num_ >> 2] << 1) | 0) >>> 0) {
     $strict_0_off032 = $strict_1_off0;
     $hz_f_033 = $incdec_ptr27;
     $13 = $20;
    } else {
     $strict_0_off0_lcssa = $strict_1_off0;
     break;
    }
   }
  } else {
   $strict_0_off0_lcssa = 0;
  }
 } while (0);
 $15 = HEAP32[$scis_hz_ >> 2] | 0;
 if ($hz_found_0 >>> 0 >= ($15 + (HEAP32[$scis_num_ >> 2] << 1) | 0) >>> 0) {
  $found_num_0_lcssa = 0;
  STACKTOP = sp;
  return $found_num_0_lcssa | 0;
 }
 $cmp48 = $half_splid << 16 >> 16 == 0;
 $conv68 = $max_splids & 65535;
 $scis_splid_74 = $this + 16 | 0;
 $scis_splid_52 = $this + 16 | 0;
 $spl_trie_ = $this + 4 | 0;
 $scis_splid_62 = $this + 16 | 0;
 $found_num_028 = 0;
 $hz_found_129 = $hz_found_0;
 $22 = $15;
 while (1) {
  if ((HEAP16[$hanzi_addr >> 1] | 0) != (HEAP16[$hz_found_129 >> 1] | 0)) {
   $found_num_0_lcssa = $found_num_028;
   label = 2540;
   break;
  }
  $sub_ptr_div4523 = ($hz_found_129 - $22 | 0) >>> 1;
  do {
   if ($cmp48) {
    label = 2531;
   } else {
    if ($strict_0_off0_lcssa) {
     if ((HEAP16[(HEAP32[$scis_splid_52 >> 2] | 0) + (($sub_ptr_div4523 & 65535) << 1) >> 1] & 31) == $half_splid << 16 >> 16) {
      label = 2531;
      break;
     } else {
      $found_num_1 = $found_num_028;
      break;
     }
    } else {
     if (__ZNK10ime_pinyin12SpellingTrie20half_full_compatibleEtt(HEAP32[$spl_trie_ >> 2] | 0, $half_splid, (HEAPU16[(HEAP32[$scis_splid_62 >> 2] | 0) + (($sub_ptr_div4523 & 65535) << 1) >> 1] | 0) >>> 5) | 0) {
      label = 2531;
      break;
     } else {
      $found_num_1 = $found_num_028;
      break;
     }
    }
   }
  } while (0);
  if ((label | 0) == 2531) {
   label = 0;
   $conv67 = $found_num_028 & 65535;
   if (($conv67 + 1 | 0) >>> 0 >= $conv68 >>> 0) {
    label = 2532;
    break;
   }
   HEAP16[$splids + ($conv67 << 1) >> 1] = (HEAPU16[(HEAP32[$scis_splid_74 >> 2] | 0) + (($sub_ptr_div4523 & 65535) << 1) >> 1] | 0) >>> 5;
   $found_num_1 = $found_num_028 + 1 & 65535;
  }
  $incdec_ptr80 = $hz_found_129 + 2 | 0;
  $37 = HEAP32[$scis_hz_ >> 2] | 0;
  if ($incdec_ptr80 >>> 0 < ($37 + (HEAP32[$scis_num_ >> 2] << 1) | 0) >>> 0) {
   $found_num_028 = $found_num_1;
   $hz_found_129 = $incdec_ptr80;
   $22 = $37;
  } else {
   $found_num_0_lcssa = $found_num_1;
   label = 2538;
   break;
  }
 }
 if ((label | 0) == 2538) {
  STACKTOP = sp;
  return $found_num_0_lcssa | 0;
 } else if ((label | 0) == 2540) {
  STACKTOP = sp;
  return $found_num_0_lcssa | 0;
 } else if ((label | 0) == 2532) {
  ___assert_func(2896, 338, 5768, 544);
  return 0;
 }
 return 0;
}
function __ZN10ime_pinyin8DictList12get_lemma_idEPKtt($this, $str, $str_len) {
 $this = $this | 0;
 $str = $str | 0;
 $str_len = $str_len | 0;
 var $conv = 0, $sub = 0, $call = 0, $1 = 0, $sub_ptr_div = 0, $2 = 0, $retval_0 = 0;
 if (($str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $conv = $str_len & 65535;
 if (($str_len & 65535) > 8) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $sub = $conv - 1 | 0;
 $call = __ZN10ime_pinyin8DictList21find_pos_startedbyhzsEPKtjPFiPKvS4_E($this, $str, $conv, HEAP32[$this + 96 + ($sub << 2) >> 2] | 0) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $1 = HEAP32[$this + 20 >> 2] | 0;
 if ($call >>> 0 <= $1 >>> 0) {
  ___assert_func(2896, 356, 6080, 4352);
  return 0;
 }
 $sub_ptr_div = $call - $1 >> 1;
 $2 = HEAP32[$this + 24 + ($sub << 2) >> 2] | 0;
 if ($sub_ptr_div >>> 0 < $2 >>> 0) {
  ___assert_func(2896, 357, 6080, 4168);
  return 0;
 }
 $retval_0 = ((($sub_ptr_div - $2 | 0) >>> 0) / ($conv >>> 0) | 0) + (HEAP32[$this + 60 + ($sub << 2) >> 2] | 0) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictList17convert_to_hanzisEPtt($this, $str, $str_len) {
 $this = $this | 0;
 $str = $str | 0;
 $str_len = $str_len | 0;
 var $scis_hz_ = 0, $str_pos_07 = 0, $arrayidx = 0;
 if (($str | 0) == 0) {
  ___assert_func(2896, 364, 5928, 3992);
 }
 if ($str_len << 16 >> 16 == 0) {
  return;
 }
 $scis_hz_ = $this + 12 | 0;
 $str_pos_07 = 0;
 do {
  $arrayidx = $str + (($str_pos_07 & 65535) << 1) | 0;
  HEAP16[$arrayidx >> 1] = HEAP16[(HEAP32[$scis_hz_ >> 2] | 0) + ((HEAPU16[$arrayidx >> 1] | 0) << 1) >> 1] | 0;
  $str_pos_07 = $str_pos_07 + 1 & 65535;
 } while (($str_pos_07 & 65535) < ($str_len & 65535));
 return;
}
function __ZN10ime_pinyin8DictList19convert_to_scis_idsEPtt($this, $str, $str_len) {
 $this = $this | 0;
 $str = $str | 0;
 $str_len = $str_len | 0;
 var $str_pos_05 = 0;
 if (($str | 0) == 0) {
  ___assert_func(2896, 372, 5856, 3992);
 }
 if ($str_len << 16 >> 16 == 0) {
  return;
 } else {
  $str_pos_05 = 0;
 }
 do {
  HEAP16[$str + (($str_pos_05 & 65535) << 1) >> 1] = 256;
  $str_pos_05 = $str_pos_05 + 1 & 65535;
 } while (($str_pos_05 & 65535) < ($str_len & 65535));
 return;
}
function __ZN10ime_pinyin8LpiCache9is_cachedEt($this, $splid) {
 $this = $this | 0;
 $splid = $splid | 0;
 var $retval_0 = 0;
 if (($splid & 65535) > 29) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = (HEAP16[(HEAP32[$this + 4 >> 2] | 0) + (($splid & 65535) << 1) >> 1] | 0) != 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8LpiCache9put_cacheEtPNS_10LmaPsbItemEj($this, $splid, $lpi_items, $lpi_num) {
 $this = $this | 0;
 $splid = $splid | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_num = $lpi_num | 0;
 var $conv2_ = 0, $0 = 0, $conv3 = 0, $mul = 0, $conv411 = 0, $pos_010 = 0, $3 = 0, $4 = 0, $5$1 = 0, $inc = 0;
 $conv2_ = $lpi_num >>> 0 < 15 ? $lpi_num & 65535 : 15;
 $0 = HEAP32[$this >> 2] | 0;
 $conv3 = $splid & 65535;
 $mul = $conv3 * 15 | 0;
 if ($conv2_ << 16 >> 16 != 0) {
  $pos_010 = 0;
  $conv411 = 0;
  while (1) {
   $3 = $lpi_items + ($conv411 << 3) | 0;
   $4 = $0 + ($conv411 + $mul << 3) | 0;
   $5$1 = HEAP32[$3 + 4 >> 2] | 0;
   HEAP32[$4 >> 2] = HEAP32[$3 >> 2];
   HEAP32[$4 + 4 >> 2] = $5$1;
   $inc = $pos_010 + 1 & 65535;
   if (($inc & 65535) < ($conv2_ & 65535)) {
    $pos_010 = $inc;
    $conv411 = $inc & 65535;
   } else {
    break;
   }
  }
 }
 HEAP16[(HEAP32[$this + 4 >> 2] | 0) + ($conv3 << 1) >> 1] = $conv2_;
 return $conv2_ & 65535 | 0;
}
function __ZN10ime_pinyin8LpiCache9get_cacheEtPNS_10LmaPsbItemEj($this, $splid, $lpi_items, $lpi_max) {
 $this = $this | 0;
 $splid = $splid | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 var $idxprom = 0, $conv = 0, $conv_lpi_max = 0, $2 = 0, $mul = 0, $conv710 = 0, $pos_09 = 0, $5 = 0, $6 = 0, $7$1 = 0;
 $idxprom = $splid & 65535;
 $conv = HEAPU16[(HEAP32[$this + 4 >> 2] | 0) + ($idxprom << 1) >> 1] | 0;
 $conv_lpi_max = $conv >>> 0 < $lpi_max >>> 0 ? $conv : $lpi_max;
 $2 = HEAP32[$this >> 2] | 0;
 $mul = $idxprom * 15 | 0;
 if (($conv_lpi_max | 0) == 0) {
  return $conv_lpi_max | 0;
 } else {
  $pos_09 = 0;
  $conv710 = 0;
 }
 do {
  $5 = $2 + ($conv710 + $mul << 3) | 0;
  $6 = $lpi_items + ($conv710 << 3) | 0;
  $7$1 = HEAP32[$5 + 4 >> 2] | 0;
  HEAP32[$6 >> 2] = HEAP32[$5 >> 2];
  HEAP32[$6 + 4 >> 2] = $7$1;
  $pos_09 = $pos_09 + 1 & 65535;
  $conv710 = $pos_09 & 65535;
 } while ($conv710 >>> 0 < $conv_lpi_max >>> 0);
 return $conv_lpi_max | 0;
}
function __ZN10ime_pinyin13SpellingTableC2Ev($this) {
 $this = $this | 0;
 HEAP8[$this | 0] = 0;
 HEAP32[$this + 8 >> 2] = 0;
 HEAP32[$this + 12 >> 2] = 0;
 HEAP32[$this + 32 >> 2] = 0;
 HEAPF64[$this + 24 >> 3] = 0.0;
 HEAP8[$this + 49 | 0] = 1;
 return;
}
function __ZN10ime_pinyin13SpellingTable12get_hash_posEPKc($this, $spelling_str) {
 $this = $this | 0;
 $spelling_str = $spelling_str | 0;
 var $spelling_size_ = 0, $pos_09 = 0, $hash_pos_08 = 0, $1 = 0, $add = 0, $inc = 0, $hash_pos_0_lcssa = 0;
 $spelling_size_ = $this + 16 | 0;
 L3297 : do {
  if ((HEAP32[$spelling_size_ >> 2] | 0) == 0) {
   $hash_pos_0_lcssa = 0;
  } else {
   $hash_pos_08 = 0;
   $pos_09 = 0;
   while (1) {
    $1 = HEAP8[$spelling_str + $pos_09 | 0] | 0;
    if ($1 << 24 >> 24 == 0) {
     $hash_pos_0_lcssa = $hash_pos_08;
     break L3297;
    }
    $add = ($1 << 24 >> 24) + $hash_pos_08 | 0;
    $inc = $pos_09 + 1 | 0;
    if ($inc >>> 0 < (HEAP32[$spelling_size_ >> 2] | 0) >>> 0) {
     $hash_pos_08 = $add;
     $pos_09 = $inc;
    } else {
     $hash_pos_0_lcssa = $add;
     break;
    }
   }
  }
 } while (0);
 return ($hash_pos_0_lcssa >>> 0) % ((HEAP32[$this + 4 >> 2] | 0) >>> 0) | 0 | 0;
}
function __ZN10ime_pinyin13SpellingTable13hash_pos_nextEj($this, $hash_pos) {
 $this = $this | 0;
 $hash_pos = $hash_pos | 0;
 return (($hash_pos + 123 | 0) >>> 0) % ((HEAP32[$this + 4 >> 2] | 0) >>> 0) | 0 | 0;
}
function __ZN10ime_pinyin13SpellingTable19get_score_amplifierEv($this) {
 $this = $this | 0;
 return +(+HEAPF64[$this + 40 >> 3]);
}
function __ZN10ime_pinyin13SpellingTable17get_average_scoreEv($this) {
 $this = $this | 0;
 return HEAP8[$this + 48 | 0] | 0;
}
function __ZN10ime_pinyin8DictList9save_listEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $buf_ = 0, $arrayidx = 0, $scis_hz_ = 0, $scis_splid_ = 0, $scis_num_ = 0, $call29 = 0, $13 = 0, $call36 = 0, $call44 = 0, $retval_0 = 0;
 if ((HEAP8[$this | 0] & 1) == 0 | ($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $buf_ = $this + 20 | 0;
 if ((HEAP32[$buf_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $arrayidx = $this + 56 | 0;
 if ((HEAP32[$arrayidx >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $scis_hz_ = $this + 12 | 0;
 if ((HEAP32[$scis_hz_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $scis_splid_ = $this + 16 | 0;
 if ((HEAP32[$scis_splid_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $scis_num_ = $this + 8 | 0;
 if ((HEAP32[$scis_num_ >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($scis_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($this + 24 | 0, 4, 9, $fp | 0) | 0) != 9) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fwrite($this + 60 | 0, 4, 9, $fp | 0) | 0) != 9) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call29 = _fwrite(HEAP32[$scis_hz_ >> 2] | 0, 2, HEAP32[$scis_num_ >> 2] | 0, $fp | 0) | 0;
 $13 = HEAP32[$scis_num_ >> 2] | 0;
 if (($call29 | 0) != ($13 | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call36 = _fwrite(HEAP32[$scis_splid_ >> 2] | 0, 2, $13 | 0, $fp | 0) | 0;
 if (($call36 | 0) != (HEAP32[$scis_num_ >> 2] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call44 = _fwrite(HEAP32[$buf_ >> 2] | 0, 2, HEAP32[$arrayidx >> 2] | 0, $fp | 0) | 0;
 $retval_0 = ($call44 | 0) == (HEAP32[$arrayidx >> 2] | 0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8DictList9load_listEP7__sFILE($this, $fp) {
 $this = $this | 0;
 $fp = $fp | 0;
 var $initialized_ = 0, $scis_num_ = 0, $arrayidx = 0, $call20 = 0, $8 = 0, $call26 = 0, $call33 = 0, $retval_0 = 0;
 if (($fp | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $initialized_ = $this | 0;
 HEAP8[$initialized_] = 0;
 $scis_num_ = $this + 8 | 0;
 if ((_fread($scis_num_ | 0, 4, 1, $fp | 0) | 0) != 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fread($this + 24 | 0, 4, 9, $fp | 0) | 0) != 9) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((_fread($this + 60 | 0, 4, 9, $fp | 0) | 0) != 9) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin8DictList13free_resourceEv($this);
 $arrayidx = $this + 56 | 0;
 if (!(__ZN10ime_pinyin8DictList14alloc_resourceEjj($this, HEAP32[$arrayidx >> 2] | 0, HEAP32[$scis_num_ >> 2] | 0) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call20 = _fread(HEAP32[$this + 12 >> 2] | 0, 2, HEAP32[$scis_num_ >> 2] | 0, $fp | 0) | 0;
 $8 = HEAP32[$scis_num_ >> 2] | 0;
 if (($call20 | 0) != ($8 | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call26 = _fread(HEAP32[$this + 16 >> 2] | 0, 2, $8 | 0, $fp | 0) | 0;
 if (($call26 | 0) != (HEAP32[$scis_num_ >> 2] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call33 = _fread(HEAP32[$this + 20 >> 2] | 0, 2, HEAP32[$arrayidx >> 2] | 0, $fp | 0) | 0;
 if (($call33 | 0) != (HEAP32[$arrayidx >> 2] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP8[$initialized_] = 1;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8LpiCacheD2Ev($this) {
 $this = $this | 0;
 var $0 = 0, $2 = 0;
 $0 = HEAP32[$this >> 2] | 0;
 if (($0 | 0) != 0) {
  __ZdaPv($0 | 0);
 }
 $2 = HEAP32[$this + 4 >> 2] | 0;
 if (($2 | 0) == 0) {
  return;
 }
 __ZdaPv($2);
 return;
}
function __ZN10ime_pinyin7myqsortEPvjjPFiPKvS2_E($p, $n, $es, $cmp) {
 $p = $p | 0;
 $n = $n | 0;
 $es = $es | 0;
 $cmp = $cmp | 0;
 _qsort($p | 0, $n | 0, $es | 0, $cmp | 0);
 return;
}
function __ZN10ime_pinyin9mybsearchEPKvS1_jjPFiS1_S1_E($k, $b, $n, $es, $cmp) {
 $k = $k | 0;
 $b = $b | 0;
 $n = $n | 0;
 $es = $es | 0;
 $cmp = $cmp | 0;
 return _bsearch($k | 0, $b | 0, $n | 0, $es | 0, $cmp | 0) | 0;
}
function __ZN10ime_pinyin18compare_raw_spl_ebEPKvS1_($p1, $p2) {
 $p1 = $p1 | 0;
 $p2 = $p2 | 0;
 var $retval_0 = 0;
 do {
  if ((HEAP8[$p1] | 0) == 0) {
   $retval_0 = 1;
  } else {
   if ((HEAP8[$p2] | 0) == 0) {
    $retval_0 = -1;
    break;
   }
   $retval_0 = _strcmp($p1 | 0, $p2 | 0) | 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12get_odd_nextEj($value) {
 $value = $value | 0;
 var $v_next_0 = 0, $add = 0, $v_dv_0 = 0;
 $v_next_0 = $value;
 L3382 : while (1) {
  $add = ~~+Math_sqrt(+(+($v_next_0 >>> 0 >>> 0))) + 1 | 0;
  $v_dv_0 = 2;
  while (1) {
   if ($v_dv_0 >>> 0 >= $add >>> 0) {
    break L3382;
   }
   if ((($v_next_0 >>> 0) % ($v_dv_0 >>> 0) | 0 | 0) == 0) {
    break;
   } else {
    $v_dv_0 = $v_dv_0 + 1 | 0;
   }
  }
  $v_next_0 = $v_next_0 + 1 | 0;
 }
 return $v_next_0 | 0;
}
function __ZN10ime_pinyin13SpellingTableD2Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin13SpellingTable13free_resourceEv($this);
 return;
}
function __ZN10ime_pinyin13SpellingTable13free_resourceEv($this) {
 $this = $this | 0;
 var $raw_spellings_ = 0, $0 = 0, $spelling_buf_ = 0, $2 = 0;
 $raw_spellings_ = $this + 8 | 0;
 $0 = HEAP32[$raw_spellings_ >> 2] | 0;
 if (($0 | 0) != 0) {
  __ZdaPv($0 | 0);
 }
 HEAP32[$raw_spellings_ >> 2] = 0;
 $spelling_buf_ = $this + 12 | 0;
 $2 = HEAP32[$spelling_buf_ >> 2] | 0;
 if (($2 | 0) == 0) {
  HEAP32[$spelling_buf_ >> 2] = 0;
  return;
 }
 __ZdaPv($2);
 HEAP32[$spelling_buf_ >> 2] = 0;
 return;
}
function __ZN10ime_pinyin13SpellingTable10init_tableEjjb($this, $pure_spl_size, $spl_max_num, $need_score) {
 $this = $this | 0;
 $pure_spl_size = $pure_spl_size | 0;
 $spl_max_num = $spl_max_num | 0;
 $need_score = $need_score | 0;
 var $spelling_size_ = 0, $spelling_max_num_ = 0, $1$0 = 0, $raw_spellings_ = 0, $call13 = 0, $spelling_buf_ = 0, $8 = 0, $11 = 0, $retval_0 = 0;
 if (($pure_spl_size | 0) == 0 | ($spl_max_num | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP8[$this | 0] = $need_score & 1;
 __ZN10ime_pinyin13SpellingTable13free_resourceEv($this);
 $spelling_size_ = $this + 16 | 0;
 HEAP32[$spelling_size_ >> 2] = ($need_score ? 2 : 1) + $pure_spl_size;
 $spelling_max_num_ = $this + 4 | 0;
 HEAP32[$spelling_max_num_ >> 2] = __ZN10ime_pinyin12get_odd_nextEj($spl_max_num) | 0;
 HEAP32[$this + 32 >> 2] = 0;
 $1$0 = _llvm_umul_with_overflow_i32(HEAP32[$spelling_max_num_ >> 2] | 0, 16) | 0;
 $raw_spellings_ = $this + 8 | 0;
 HEAP32[$raw_spellings_ >> 2] = __Znaj(tempRet0 ? -1 : $1$0) | 0;
 $call13 = __Znaj(Math_imul(HEAP32[$spelling_size_ >> 2] | 0, HEAP32[$spelling_max_num_ >> 2] | 0) | 0) | 0;
 $spelling_buf_ = $this + 12 | 0;
 HEAP32[$spelling_buf_ >> 2] = $call13;
 $8 = HEAP32[$raw_spellings_ >> 2] | 0;
 if (($8 | 0) == 0 | ($call13 | 0) == 0) {
  __ZN10ime_pinyin13SpellingTable13free_resourceEv($this);
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  _memset($8 | 0, 0, HEAP32[$spelling_max_num_ >> 2] << 4 | 0);
  $11 = HEAP32[$spelling_buf_ >> 2] | 0;
  _memset($11 | 0, 0, Math_imul(HEAP32[$spelling_size_ >> 2] | 0, HEAP32[$spelling_max_num_ >> 2] | 0) | 0);
  HEAP8[$this + 49 | 0] = 0;
  HEAPF64[$this + 24 >> 3] = 0.0;
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin13SpellingTable12put_spellingEPKcd($this, $spelling_str, $freq) {
 $this = $this | 0;
 $spelling_str = $spelling_str | 0;
 $freq = +$freq;
 var $pos_0 = 0, $total_freq_ = 0, $call6 = 0, $spelling_size_ = 0, $raw_spellings_ = 0, $5 = 0, $7 = 0, $sub28 = 0, $freq20 = 0, $hash_pos_0 = 0, $arraydecay26 = 0, $freq34 = 0, $freq45 = 0, $arraydecay50 = 0, $sub52 = 0, $spelling_num_ = 0, $call62 = 0, $retval_0 = 0, label = 0;
 if ((HEAP8[$this + 49 | 0] & 1) != 0 | ($spelling_str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $pos_0 = 0;
 }
 while (1) {
  if ($pos_0 >>> 0 >= 3) {
   break;
  }
  if ((_strcmp($spelling_str | 0, 10896 + ($pos_0 * 7 | 0) | 0) | 0) == 0) {
   $retval_0 = 0;
   label = 2683;
   break;
  } else {
   $pos_0 = $pos_0 + 1 | 0;
  }
 }
 if ((label | 0) == 2683) {
  return $retval_0 | 0;
 }
 $total_freq_ = $this + 24 | 0;
 HEAPF64[$total_freq_ >> 3] = +HEAPF64[$total_freq_ >> 3] + $freq;
 $call6 = __ZN10ime_pinyin13SpellingTable12get_hash_posEPKc($this, $spelling_str) | 0;
 $spelling_size_ = $this + 16 | 0;
 $raw_spellings_ = $this + 8 | 0;
 HEAP8[(HEAP32[$spelling_size_ >> 2] | 0) - 1 + ((HEAP32[$raw_spellings_ >> 2] | 0) + ($call6 << 4)) | 0] = 0;
 $5 = HEAP32[$raw_spellings_ >> 2] | 0;
 if ((_strncmp($5 + ($call6 << 4) | 0, $spelling_str | 0, (HEAP32[$spelling_size_ >> 2] | 0) - 1 | 0) | 0) == 0) {
  $freq20 = $5 + ($call6 << 4) + 8 | 0;
  HEAPF64[$freq20 >> 3] = +HEAPF64[$freq20 >> 3] + $freq;
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $7 = HEAP32[$raw_spellings_ >> 2] | 0;
 $sub28 = (HEAP32[$spelling_size_ >> 2] | 0) - 1 | 0;
 $hash_pos_0 = $call6;
 while (1) {
  $arraydecay26 = $7 + ($hash_pos_0 << 4) | 0;
  if ((_strncmp($arraydecay26 | 0, $spelling_str | 0, $sub28 | 0) | 0) == 0) {
   label = 2676;
   break;
  }
  if ((HEAP8[$arraydecay26] | 0) == 0) {
   label = 2678;
   break;
  }
  $call62 = __ZN10ime_pinyin13SpellingTable13hash_pos_nextEj($this, $hash_pos_0) | 0;
  if (($call6 | 0) == ($call62 | 0)) {
   $retval_0 = 0;
   label = 2685;
   break;
  } else {
   $hash_pos_0 = $call62;
  }
 }
 if ((label | 0) == 2678) {
  $freq45 = $7 + ($hash_pos_0 << 4) + 8 | 0;
  HEAPF64[$freq45 >> 3] = +HEAPF64[$freq45 >> 3] + $freq;
  $arraydecay50 = (HEAP32[$raw_spellings_ >> 2] | 0) + ($hash_pos_0 << 4) | 0;
  $sub52 = (HEAP32[$spelling_size_ >> 2] | 0) - 1 | 0;
  _strncpy($arraydecay50 | 0, $spelling_str | 0, $sub52 | 0) | 0;
  HEAP8[(HEAP32[$spelling_size_ >> 2] | 0) - 1 + ((HEAP32[$raw_spellings_ >> 2] | 0) + ($hash_pos_0 << 4)) | 0] = 0;
  $spelling_num_ = $this + 32 | 0;
  HEAP32[$spelling_num_ >> 2] = (HEAP32[$spelling_num_ >> 2] | 0) + 1;
  $retval_0 = 1;
  return $retval_0 | 0;
 } else if ((label | 0) == 2685) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2676) {
  $freq34 = $7 + ($hash_pos_0 << 4) + 8 | 0;
  HEAPF64[$freq34 >> 3] = +HEAPF64[$freq34 >> 3] + $freq;
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin13SpellingTable7containEPKc($this, $spelling_str) {
 $this = $this | 0;
 $spelling_str = $spelling_str | 0;
 var $call = 0, $raw_spellings_ = 0, $arrayidx4 = 0, $spelling_size_ = 0, $hash_pos_0 = 0, $call15 = 0, $arrayidx22 = 0, $retval_0 = 0, label = 0;
 if (($spelling_str | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP32[$this + 12 >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if ((HEAP8[$this + 49 | 0] & 1) != 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin13SpellingTable12get_hash_posEPKc($this, $spelling_str) | 0;
 $raw_spellings_ = $this + 8 | 0;
 $arrayidx4 = (HEAP32[$raw_spellings_ >> 2] | 0) + ($call << 4) | 0;
 if ((HEAP8[$arrayidx4] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_size_ = $this + 16 | 0;
 if ((_strncmp($arrayidx4 | 0, $spelling_str | 0, (HEAP32[$spelling_size_ >> 2] | 0) - 1 | 0) | 0) == 0) {
  $retval_0 = 1;
  return $retval_0 | 0;
 } else {
  $hash_pos_0 = $call;
 }
 while (1) {
  $call15 = __ZN10ime_pinyin13SpellingTable13hash_pos_nextEj($this, $hash_pos_0) | 0;
  if (($call | 0) == ($call15 | 0)) {
   $retval_0 = 0;
   label = 2701;
   break;
  }
  $arrayidx22 = (HEAP32[$raw_spellings_ >> 2] | 0) + ($call15 << 4) | 0;
  if ((HEAP8[$arrayidx22] | 0) == 0) {
   $retval_0 = 0;
   label = 2698;
   break;
  }
  if ((_strncmp($arrayidx22 | 0, $spelling_str | 0, (HEAP32[$spelling_size_ >> 2] | 0) - 1 | 0) | 0) == 0) {
   $retval_0 = 1;
   label = 2702;
   break;
  } else {
   $hash_pos_0 = $call15;
  }
 }
 if ((label | 0) == 2698) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2701) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2702) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin14SpellingParserC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = __ZN10ime_pinyin12SpellingTrie14get_cpinstanceEv() | 0;
 return;
}
function __ZN10ime_pinyin14SpellingParser17is_valid_to_parseEc($this, $ch) {
 $this = $this | 0;
 $ch = $ch | 0;
 return __ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc($ch) | 0;
}
function __ZN10ime_pinyin8LpiCacheC2Ev($this) {
 $this = $this | 0;
 var $lpi_cache_ = 0, $call2 = 0, $lpi_cache_len_ = 0, $id_03 = 0;
 $lpi_cache_ = $this | 0;
 HEAP32[$lpi_cache_ >> 2] = __Znaj(3600) | 0;
 $call2 = __Znaj(60) | 0;
 $lpi_cache_len_ = $this + 4 | 0;
 HEAP32[$lpi_cache_len_ >> 2] = $call2;
 if ((HEAP32[$lpi_cache_ >> 2] | 0) == 0) {
  ___assert_func(2496, 27, 4560, 3920);
 }
 if (($call2 | 0) == 0) {
  ___assert_func(2496, 28, 4560, 2776);
 } else {
  $id_03 = 0;
 }
 do {
  HEAP16[(HEAP32[$lpi_cache_len_ >> 2] | 0) + (($id_03 & 65535) << 1) >> 1] = 0;
  $id_03 = $id_03 + 1 & 65535;
 } while (($id_03 & 65535) < 30);
 return;
}
function __ZN10ime_pinyin8LpiCache12get_instanceEv() {
 var $call = 0, $1 = 0, $3 = 0;
 if ((HEAP32[11852] | 0) != 0) {
  $3 = HEAP32[11852] | 0;
  return $3 | 0;
 }
 $call = __Znwj(8) | 0;
 $1 = $call;
 __ZN10ime_pinyin8LpiCacheC2Ev($1);
 HEAP32[11852] = $1;
 if (($call | 0) == 0) {
  ___assert_func(2496, 44, 4600, 1864);
  return 0;
 } else {
  $3 = HEAP32[11852] | 0;
  return $3 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin13SpellingTable7arrangeEPjS1_($this, $item_size, $spl_num) {
 $this = $this | 0;
 $item_size = $item_size | 0;
 $spl_num = $spl_num | 0;
 var $raw_spellings_ = 0, $0 = 0, $spelling_buf_ = 0, $spelling_num_ = 0, $spelling_size_ = 0, $pos_040 = 0, $5 = 0, $6 = 0, $add_ptr = 0, $need_score_ = 0, $total_freq_ = 0, $pos13_036 = 0, $min_score_035 = 0.0, $freq = 0, $17 = 0, $19 = 0.0, $min_score_1 = 0.0, $inc49 = 0, $min_score_0_lcssa = 0.0, $score_amplifier_ = 0, $spelling_size_70 = 0, $pos54_031 = 0, $average_score_030 = 0.0, $call62 = 0.0, $mul64 = 0.0, $add = 0.0, $25 = 0, $26 = 0, $inc76 = 0, $28 = 0, $_lcssa = 0, $average_score_0_lcssa = 0.0, $div80 = 0.0, $retval_0 = 0;
 $raw_spellings_ = $this + 8 | 0;
 $0 = HEAP32[$raw_spellings_ >> 2] | 0;
 if (($0 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $spelling_buf_ = $this + 12 | 0;
 if ((HEAP32[$spelling_buf_ >> 2] | 0) == 0 | ($item_size | 0) == 0 | ($spl_num | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 _qsort($0 | 0, HEAP32[$this + 4 >> 2] | 0, 16, 40);
 $spelling_num_ = $this + 32 | 0;
 if ((HEAP32[$spelling_num_ >> 2] | 0) != 0) {
  $spelling_size_ = $this + 16 | 0;
  $pos_040 = 0;
  do {
   $5 = HEAP32[$spelling_buf_ >> 2] | 0;
   $6 = HEAP32[$spelling_size_ >> 2] | 0;
   $add_ptr = $5 + (Math_imul($6, $pos_040) | 0) | 0;
   _strncpy($add_ptr | 0, (HEAP32[$raw_spellings_ >> 2] | 0) + ($pos_040 << 4) | 0, $6 | 0) | 0;
   $pos_040 = $pos_040 + 1 | 0;
  } while ($pos_040 >>> 0 < (HEAP32[$spelling_num_ >> 2] | 0) >>> 0);
 }
 $need_score_ = $this | 0;
 do {
  if ((HEAP8[$need_score_] & 1) != 0) {
   if ((HEAP32[$spelling_num_ >> 2] | 0) == 0) {
    $min_score_0_lcssa = 0.0;
   } else {
    $total_freq_ = $this + 24 | 0;
    $min_score_035 = 0.0;
    $pos13_036 = 0;
    while (1) {
     $freq = (HEAP32[$raw_spellings_ >> 2] | 0) + ($pos13_036 << 4) + 8 | 0;
     HEAPF64[$freq >> 3] = +HEAPF64[$freq >> 3] / +HEAPF64[$total_freq_ >> 3];
     do {
      if ((HEAP8[$need_score_] & 1) == 0) {
       $min_score_1 = $min_score_035;
      } else {
       $17 = HEAP32[$raw_spellings_ >> 2] | 0;
       if (($pos13_036 | 0) == 0) {
        $min_score_1 = +HEAPF64[$17 + 8 >> 3];
        break;
       }
       $19 = +HEAPF64[$17 + ($pos13_036 << 4) + 8 >> 3];
       if ($19 >= $min_score_035) {
        $min_score_1 = $min_score_035;
        break;
       }
       $min_score_1 = $19;
      }
     } while (0);
     $inc49 = $pos13_036 + 1 | 0;
     if ($inc49 >>> 0 < (HEAP32[$spelling_num_ >> 2] | 0) >>> 0) {
      $min_score_035 = $min_score_1;
      $pos13_036 = $inc49;
     } else {
      $min_score_0_lcssa = $min_score_1;
      break;
     }
    }
   }
   $score_amplifier_ = $this + 40 | 0;
   HEAPF64[$score_amplifier_ >> 3] = 255.0 / +Math_log(+$min_score_0_lcssa);
   L3498 : do {
    if ((HEAP32[$spelling_num_ >> 2] | 0) == 0) {
     $average_score_0_lcssa = 0.0;
     $_lcssa = 0;
    } else {
     $spelling_size_70 = $this + 16 | 0;
     $average_score_030 = 0.0;
     $pos54_031 = 0;
     while (1) {
      $call62 = +Math_log(+(+HEAPF64[(HEAP32[$raw_spellings_ >> 2] | 0) + ($pos54_031 << 4) + 8 >> 3]));
      $mul64 = $call62 * +HEAPF64[$score_amplifier_ >> 3];
      if ($mul64 < 0.0) {
       break;
      }
      $add = $average_score_030 + $mul64;
      $25 = HEAP32[$spelling_buf_ >> 2] | 0;
      $26 = HEAP32[$spelling_size_70 >> 2] | 0;
      HEAP8[$25 + ($26 - 1 + (Math_imul($26, $pos54_031) | 0)) | 0] = $mul64 > 255.0 ? -1 : ~~$mul64;
      $inc76 = $pos54_031 + 1 | 0;
      $28 = HEAP32[$spelling_num_ >> 2] | 0;
      if ($inc76 >>> 0 < $28 >>> 0) {
       $average_score_030 = $add;
       $pos54_031 = $inc76;
      } else {
       $average_score_0_lcssa = $add;
       $_lcssa = $28;
       break L3498;
      }
     }
     ___assert_func(2376, 272, 6328, 3848);
     return 0;
    }
   } while (0);
   $div80 = $average_score_0_lcssa / +($_lcssa >>> 0 >>> 0);
   if ($div80 > 255.0) {
    ___assert_func(2376, 290, 6328, 2752);
    return 0;
   } else {
    HEAP8[$this + 48 | 0] = ~~$div80;
    break;
   }
  }
 } while (0);
 HEAP32[$item_size >> 2] = HEAP32[$this + 16 >> 2];
 HEAP32[$spl_num >> 2] = HEAP32[$spelling_num_ >> 2];
 HEAP8[$this + 49 | 0] = 1;
 $retval_0 = HEAP32[$spelling_buf_ >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin12SpellingTrie16is_same_spl_charEcc($ch1, $ch2) {
 $ch1 = $ch1 | 0;
 $ch2 = $ch2 | 0;
 var $conv = 0, $conv1 = 0, $0 = 0;
 $conv = $ch1 << 24 >> 24;
 $conv1 = $ch2 << 24 >> 24;
 if ($ch1 << 24 >> 24 == $ch2 << 24 >> 24) {
  $0 = 1;
  return $0 | 0;
 }
 if (($conv - $conv1 | 0) == 32) {
  $0 = 1;
  return $0 | 0;
 }
 $0 = ($conv1 - $conv | 0) == 32;
 return $0 | 0;
}
function __ZN10ime_pinyin14SpellingParser14splstr_to_idxsEPKctPtS3_tRb($this, $splstr, $str_len, $spl_idx, $start_pos, $max_size, $last_is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $spl_idx = $spl_idx | 0;
 $start_pos = $start_pos | 0;
 $max_size = $max_size | 0;
 $last_is_pre = $last_is_pre | 0;
 var $id_this = 0, $id_this75 = 0, $id_this99 = 0, $spl_trie_ = 0, $2 = 0, $cmp8 = 0, $idx_num_0_ph = 0, $last_is_splitter_0_off0_ph = 0, $str_pos_0_ph = 0, $node_this_0_ph = 0, $arrayidx41 = 0, $last_is_splitter_0_off0_ph60_ph = 0, $str_pos_0_ph61_ph = 0, $node_this_0_ph62_ph = 0, $4 = 0, $str_pos_0_ph6183 = 0, $last_is_splitter_0_off0_ph6082 = 0, $str_pos_071 = 0, $5 = 0, $inc = 0, $inc23 = 0, $inc37 = 0, $conv48 = 0, $13 = 0, $conv65 = 0, $i_0 = 0, $found_son_0 = 0, $inc83 = 0, $idx_num_0_ph_be = 0, $last_is_splitter_0_off0_ph_be = 0, $str_pos_0_ph_be = 0, $last_is_splitter_0_off0_ph6076 = 0, $str_pos_0_lcssa = 0, $inc107 = 0, $idx_num_1 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 24 | 0;
 $id_this = sp | 0;
 $id_this75 = sp + 8 | 0;
 $id_this99 = sp + 16 | 0;
 if (($splstr | 0) == 0 | $max_size << 16 >> 16 == 0 | $str_len << 16 >> 16 == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc(HEAP8[$splstr] | 0) | 0)) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP8[$last_is_pre] = 0;
 $spl_trie_ = $this | 0;
 $2 = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 44 >> 2] | 0;
 $cmp8 = ($start_pos | 0) != 0;
 if ($cmp8) {
  HEAP16[$start_pos >> 1] = 0;
  $node_this_0_ph = $2;
  $str_pos_0_ph = 0;
  $last_is_splitter_0_off0_ph = 0;
  $idx_num_0_ph = 0;
 } else {
  $node_this_0_ph = $2;
  $str_pos_0_ph = 0;
  $last_is_splitter_0_off0_ph = 0;
  $idx_num_0_ph = 0;
 }
 L3527 : while (1) {
  $arrayidx41 = $start_pos + (($idx_num_0_ph & 65535) << 1) | 0;
  $node_this_0_ph62_ph = $node_this_0_ph;
  $str_pos_0_ph61_ph = $str_pos_0_ph;
  $last_is_splitter_0_off0_ph60_ph = $last_is_splitter_0_off0_ph;
  L3529 : while (1) {
   if (($str_pos_0_ph61_ph & 65535) >= ($str_len & 65535)) {
    $str_pos_0_lcssa = $str_pos_0_ph61_ph;
    $last_is_splitter_0_off0_ph6076 = $last_is_splitter_0_off0_ph60_ph;
    label = 2785;
    break L3527;
   }
   $4 = $node_this_0_ph62_ph + 4 | 0;
   $last_is_splitter_0_off0_ph6082 = $last_is_splitter_0_off0_ph60_ph;
   $str_pos_0_ph6183 = $str_pos_0_ph61_ph;
   L3532 : while (1) {
    $str_pos_071 = $str_pos_0_ph6183;
    while (1) {
     $5 = HEAP8[$splstr + ($str_pos_071 & 65535) | 0] | 0;
     if (__ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc($5) | 0) {
      break L3532;
     }
     HEAP16[$id_this >> 1] = HEAP16[$4 >> 1] & 2047;
     if (__ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt(HEAP32[$spl_trie_ >> 2] | 0, $id_this) | 0) {
      label = 2765;
      break L3529;
     }
     if (!$last_is_splitter_0_off0_ph6082) {
      $retval_0 = $idx_num_0_ph;
      label = 2796;
      break L3527;
     }
     $inc37 = $str_pos_071 + 1 & 65535;
     if (!$cmp8) {
      break;
     }
     HEAP16[$arrayidx41 >> 1] = $inc37;
     if (($inc37 & 65535) < ($str_len & 65535)) {
      $str_pos_071 = $inc37;
     } else {
      $str_pos_0_lcssa = $inc37;
      $last_is_splitter_0_off0_ph6076 = $last_is_splitter_0_off0_ph6082;
      label = 2785;
      break L3527;
     }
    }
    if (($inc37 & 65535) < ($str_len & 65535)) {
     $last_is_splitter_0_off0_ph6082 = 1;
     $str_pos_0_ph6183 = $inc37;
    } else {
     $str_pos_0_lcssa = $inc37;
     $last_is_splitter_0_off0_ph6076 = 1;
     label = 2785;
     break L3527;
    }
   }
   do {
    if ($str_pos_071 << 16 >> 16 == 0) {
     $conv48 = $5 << 24 >> 24;
     if ($5 << 24 >> 24 > 96) {
      $found_son_0 = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 56 + ($conv48 - 97 << 2) >> 2] | 0;
      break;
     } else {
      $found_son_0 = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 56 + ($conv48 - 65 << 2) >> 2] | 0;
      break;
     }
    } else {
     $13 = HEAP32[$node_this_0_ph62_ph >> 2] | 0;
     $conv65 = (HEAPU16[$node_this_0_ph62_ph + 4 >> 1] | 0) >>> 11 & 65535;
     $i_0 = 0;
     while (1) {
      if (($i_0 | 0) >= ($conv65 | 0)) {
       label = 2780;
       break L3529;
      }
      if (__ZN10ime_pinyin12SpellingTrie16is_same_spl_charEcc(HEAP8[$13 + ($i_0 << 3) + 6 | 0] | 0, $5) | 0) {
       break;
      } else {
       $i_0 = $i_0 + 1 | 0;
      }
     }
     $found_son_0 = $13 + ($i_0 << 3) | 0;
    }
   } while (0);
   if (($found_son_0 | 0) == 0) {
    label = 2780;
    break;
   } else {
    $node_this_0_ph62_ph = $found_son_0;
    $str_pos_0_ph61_ph = $str_pos_071 + 1 & 65535;
    $last_is_splitter_0_off0_ph60_ph = 0;
   }
  }
  if ((label | 0) == 2780) {
   label = 0;
   HEAP16[$id_this75 >> 1] = HEAP16[$node_this_0_ph62_ph + 4 >> 1] & 2047;
   if (!(__ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt(HEAP32[$spl_trie_ >> 2] | 0, $id_this75) | 0)) {
    $retval_0 = $idx_num_0_ph;
    label = 2793;
    break;
   }
   HEAP16[$spl_idx + (($idx_num_0_ph & 65535) << 1) >> 1] = HEAP16[$id_this75 >> 1] | 0;
   $inc83 = $idx_num_0_ph + 1 & 65535;
   if ($cmp8) {
    HEAP16[$start_pos + (($inc83 & 65535) << 1) >> 1] = $str_pos_071;
   }
   if (($inc83 & 65535) < ($max_size & 65535)) {
    $str_pos_0_ph_be = $str_pos_071;
    $last_is_splitter_0_off0_ph_be = 0;
    $idx_num_0_ph_be = $inc83;
   } else {
    $retval_0 = $inc83;
    label = 2791;
    break;
   }
  } else if ((label | 0) == 2765) {
   label = 0;
   HEAP16[$spl_idx + (($idx_num_0_ph & 65535) << 1) >> 1] = HEAP16[$id_this >> 1] | 0;
   $inc = $idx_num_0_ph + 1 & 65535;
   $inc23 = $str_pos_071 + 1 & 65535;
   if ($cmp8) {
    HEAP16[$start_pos + (($inc & 65535) << 1) >> 1] = $inc23;
   }
   if (($inc & 65535) < ($max_size & 65535)) {
    $str_pos_0_ph_be = $inc23;
    $last_is_splitter_0_off0_ph_be = 1;
    $idx_num_0_ph_be = $inc;
   } else {
    $retval_0 = $inc;
    label = 2795;
    break;
   }
  }
  $node_this_0_ph = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 44 >> 2] | 0;
  $str_pos_0_ph = $str_pos_0_ph_be;
  $last_is_splitter_0_off0_ph = $last_is_splitter_0_off0_ph_be;
  $idx_num_0_ph = $idx_num_0_ph_be;
 }
 if ((label | 0) == 2785) {
  HEAP16[$id_this99 >> 1] = HEAP16[$node_this_0_ph62_ph + 4 >> 1] & 2047;
  do {
   if (__ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt(HEAP32[$spl_trie_ >> 2] | 0, $id_this99) | 0) {
    HEAP16[$spl_idx + (($idx_num_0_ph & 65535) << 1) >> 1] = HEAP16[$id_this99 >> 1] | 0;
    $inc107 = $idx_num_0_ph + 1 & 65535;
    if (!$cmp8) {
     $idx_num_1 = $inc107;
     break;
    }
    HEAP16[$start_pos + (($inc107 & 65535) << 1) >> 1] = $str_pos_0_lcssa;
    $idx_num_1 = $inc107;
   } else {
    $idx_num_1 = $idx_num_0_ph;
   }
  } while (0);
  HEAP8[$last_is_pre] = $last_is_splitter_0_off0_ph6076 & 1 ^ 1;
  $retval_0 = $idx_num_1;
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2791) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2793) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2795) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2796) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin14SpellingParser16splstr_to_idxs_fEPKctPtS3_tRb($this, $splstr, $str_len, $spl_idx, $start_pos, $max_size, $last_is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $spl_idx = $spl_idx | 0;
 $start_pos = $start_pos | 0;
 $max_size = $max_size | 0;
 $last_is_pre = $last_is_pre | 0;
 var $call = 0, $spl_trie_ = 0, $sub = 0, $conv14 = 0, $pos_013 = 0, $arrayidx = 0, $2 = 0, $3 = 0, $inc = 0;
 $call = __ZN10ime_pinyin14SpellingParser14splstr_to_idxsEPKctPtS3_tRb($this, $splstr, $str_len, $spl_idx, $start_pos, $max_size, $last_is_pre) | 0;
 if ($call << 16 >> 16 == 0) {
  return $call | 0;
 }
 $spl_trie_ = $this | 0;
 $sub = ($call & 65535) - 1 | 0;
 $pos_013 = 0;
 $conv14 = 0;
 while (1) {
  $arrayidx = $spl_idx + ($conv14 << 1) | 0;
  do {
   if (__ZNK10ime_pinyin12SpellingTrie16is_half_id_yunmuEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$arrayidx >> 1] | 0) | 0) {
    $2 = HEAP32[$spl_trie_ >> 2] | 0;
    $3 = HEAP16[$arrayidx >> 1] | 0;
    __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt($2, $3, $arrayidx) | 0;
    if (($conv14 | 0) != ($sub | 0)) {
     break;
    }
    HEAP8[$last_is_pre] = 0;
   }
  } while (0);
  $inc = $pos_013 + 1 & 65535;
  if (($inc & 65535) < ($call & 65535)) {
   $pos_013 = $inc;
   $conv14 = $inc & 65535;
  } else {
   break;
  }
 }
 return $call | 0;
}
function __ZN10ime_pinyin14SpellingParser16splstr16_to_idxsEPKttPtS3_tRb($this, $splstr, $str_len, $spl_idx, $start_pos, $max_size, $last_is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $spl_idx = $spl_idx | 0;
 $start_pos = $start_pos | 0;
 $max_size = $max_size | 0;
 $last_is_pre = $last_is_pre | 0;
 var $id_this = 0, $id_this78 = 0, $id_this102 = 0, $spl_trie_ = 0, $2 = 0, $cmp9 = 0, $idx_num_0_ph = 0, $last_is_splitter_0_off0_ph = 0, $str_pos_0_ph = 0, $node_this_0_ph = 0, $arrayidx43 = 0, $last_is_splitter_0_off0_ph60_ph = 0, $str_pos_0_ph61_ph = 0, $node_this_0_ph62_ph = 0, $4 = 0, $str_pos_0_ph6186 = 0, $last_is_splitter_0_off0_ph6085 = 0, $str_pos_074 = 0, $5 = 0, $conv17 = 0, $inc = 0, $inc25 = 0, $inc39 = 0, $conv50 = 0, $13 = 0, $conv67 = 0, $i_0 = 0, $found_son_0 = 0, $inc86 = 0, $idx_num_0_ph_be = 0, $last_is_splitter_0_off0_ph_be = 0, $str_pos_0_ph_be = 0, $last_is_splitter_0_off0_ph6079 = 0, $str_pos_0_lcssa = 0, $inc110 = 0, $idx_num_1 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 24 | 0;
 $id_this = sp | 0;
 $id_this78 = sp + 8 | 0;
 $id_this102 = sp + 16 | 0;
 if (($splstr | 0) == 0 | $max_size << 16 >> 16 == 0 | $str_len << 16 >> 16 == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc(HEAP16[$splstr >> 1] & 255) | 0)) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP8[$last_is_pre] = 0;
 $spl_trie_ = $this | 0;
 $2 = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 44 >> 2] | 0;
 $cmp9 = ($start_pos | 0) != 0;
 if ($cmp9) {
  HEAP16[$start_pos >> 1] = 0;
  $node_this_0_ph = $2;
  $str_pos_0_ph = 0;
  $last_is_splitter_0_off0_ph = 0;
  $idx_num_0_ph = 0;
 } else {
  $node_this_0_ph = $2;
  $str_pos_0_ph = 0;
  $last_is_splitter_0_off0_ph = 0;
  $idx_num_0_ph = 0;
 }
 L3595 : while (1) {
  $arrayidx43 = $start_pos + (($idx_num_0_ph & 65535) << 1) | 0;
  $node_this_0_ph62_ph = $node_this_0_ph;
  $str_pos_0_ph61_ph = $str_pos_0_ph;
  $last_is_splitter_0_off0_ph60_ph = $last_is_splitter_0_off0_ph;
  L3597 : while (1) {
   if (($str_pos_0_ph61_ph & 65535) >= ($str_len & 65535)) {
    $str_pos_0_lcssa = $str_pos_0_ph61_ph;
    $last_is_splitter_0_off0_ph6079 = $last_is_splitter_0_off0_ph60_ph;
    label = 2837;
    break L3595;
   }
   $4 = $node_this_0_ph62_ph + 4 | 0;
   $last_is_splitter_0_off0_ph6085 = $last_is_splitter_0_off0_ph60_ph;
   $str_pos_0_ph6186 = $str_pos_0_ph61_ph;
   L3600 : while (1) {
    $str_pos_074 = $str_pos_0_ph6186;
    while (1) {
     $5 = HEAP16[$splstr + (($str_pos_074 & 65535) << 1) >> 1] | 0;
     $conv17 = $5 & 255;
     if (__ZN10ime_pinyin12SpellingTrie17is_valid_spl_charEc($conv17) | 0) {
      break L3600;
     }
     HEAP16[$id_this >> 1] = HEAP16[$4 >> 1] & 2047;
     if (__ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt(HEAP32[$spl_trie_ >> 2] | 0, $id_this) | 0) {
      label = 2817;
      break L3597;
     }
     if (!$last_is_splitter_0_off0_ph6085) {
      $retval_0 = $idx_num_0_ph;
      label = 2846;
      break L3595;
     }
     $inc39 = $str_pos_074 + 1 & 65535;
     if (!$cmp9) {
      break;
     }
     HEAP16[$arrayidx43 >> 1] = $inc39;
     if (($inc39 & 65535) < ($str_len & 65535)) {
      $str_pos_074 = $inc39;
     } else {
      $str_pos_0_lcssa = $inc39;
      $last_is_splitter_0_off0_ph6079 = $last_is_splitter_0_off0_ph6085;
      label = 2837;
      break L3595;
     }
    }
    if (($inc39 & 65535) < ($str_len & 65535)) {
     $last_is_splitter_0_off0_ph6085 = 1;
     $str_pos_0_ph6186 = $inc39;
    } else {
     $str_pos_0_lcssa = $inc39;
     $last_is_splitter_0_off0_ph6079 = 1;
     label = 2837;
     break L3595;
    }
   }
   do {
    if ($str_pos_074 << 16 >> 16 == 0) {
     $conv50 = $5 & 65535;
     if (($5 & 65535) > 96) {
      $found_son_0 = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 56 + ($conv50 - 97 << 2) >> 2] | 0;
      break;
     } else {
      $found_son_0 = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 56 + ($conv50 - 65 << 2) >> 2] | 0;
      break;
     }
    } else {
     $13 = HEAP32[$node_this_0_ph62_ph >> 2] | 0;
     $conv67 = (HEAPU16[$node_this_0_ph62_ph + 4 >> 1] | 0) >>> 11 & 65535;
     $i_0 = 0;
     while (1) {
      if (($i_0 | 0) >= ($conv67 | 0)) {
       label = 2832;
       break L3597;
      }
      if (__ZN10ime_pinyin12SpellingTrie16is_same_spl_charEcc(HEAP8[$13 + ($i_0 << 3) + 6 | 0] | 0, $conv17) | 0) {
       break;
      } else {
       $i_0 = $i_0 + 1 | 0;
      }
     }
     $found_son_0 = $13 + ($i_0 << 3) | 0;
    }
   } while (0);
   if (($found_son_0 | 0) == 0) {
    label = 2832;
    break;
   } else {
    $node_this_0_ph62_ph = $found_son_0;
    $str_pos_0_ph61_ph = $str_pos_074 + 1 & 65535;
    $last_is_splitter_0_off0_ph60_ph = 0;
   }
  }
  if ((label | 0) == 2832) {
   label = 0;
   HEAP16[$id_this78 >> 1] = HEAP16[$node_this_0_ph62_ph + 4 >> 1] & 2047;
   if (!(__ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt(HEAP32[$spl_trie_ >> 2] | 0, $id_this78) | 0)) {
    $retval_0 = $idx_num_0_ph;
    label = 2844;
    break;
   }
   HEAP16[$spl_idx + (($idx_num_0_ph & 65535) << 1) >> 1] = HEAP16[$id_this78 >> 1] | 0;
   $inc86 = $idx_num_0_ph + 1 & 65535;
   if ($cmp9) {
    HEAP16[$start_pos + (($inc86 & 65535) << 1) >> 1] = $str_pos_074;
   }
   if (($inc86 & 65535) < ($max_size & 65535)) {
    $str_pos_0_ph_be = $str_pos_074;
    $last_is_splitter_0_off0_ph_be = 0;
    $idx_num_0_ph_be = $inc86;
   } else {
    $retval_0 = $inc86;
    label = 2843;
    break;
   }
  } else if ((label | 0) == 2817) {
   label = 0;
   HEAP16[$spl_idx + (($idx_num_0_ph & 65535) << 1) >> 1] = HEAP16[$id_this >> 1] | 0;
   $inc = $idx_num_0_ph + 1 & 65535;
   $inc25 = $str_pos_074 + 1 & 65535;
   if ($cmp9) {
    HEAP16[$start_pos + (($inc & 65535) << 1) >> 1] = $inc25;
   }
   if (($inc & 65535) < ($max_size & 65535)) {
    $str_pos_0_ph_be = $inc25;
    $last_is_splitter_0_off0_ph_be = 1;
    $idx_num_0_ph_be = $inc;
   } else {
    $retval_0 = $inc;
    label = 2845;
    break;
   }
  }
  $node_this_0_ph = HEAP32[(HEAP32[$spl_trie_ >> 2] | 0) + 44 >> 2] | 0;
  $str_pos_0_ph = $str_pos_0_ph_be;
  $last_is_splitter_0_off0_ph = $last_is_splitter_0_off0_ph_be;
  $idx_num_0_ph = $idx_num_0_ph_be;
 }
 if ((label | 0) == 2837) {
  HEAP16[$id_this102 >> 1] = HEAP16[$node_this_0_ph62_ph + 4 >> 1] & 2047;
  do {
   if (__ZNK10ime_pinyin12SpellingTrie18if_valid_id_updateEPt(HEAP32[$spl_trie_ >> 2] | 0, $id_this102) | 0) {
    HEAP16[$spl_idx + (($idx_num_0_ph & 65535) << 1) >> 1] = HEAP16[$id_this102 >> 1] | 0;
    $inc110 = $idx_num_0_ph + 1 & 65535;
    if (!$cmp9) {
     $idx_num_1 = $inc110;
     break;
    }
    HEAP16[$start_pos + (($inc110 & 65535) << 1) >> 1] = $str_pos_0_lcssa;
    $idx_num_1 = $inc110;
   } else {
    $idx_num_1 = $idx_num_0_ph;
   }
  } while (0);
  HEAP8[$last_is_pre] = $last_is_splitter_0_off0_ph6079 & 1 ^ 1;
  $retval_0 = $idx_num_1;
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2843) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2844) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2845) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 2846) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin14SpellingParser18splstr16_to_idxs_fEPKttPtS3_tRb($this, $splstr, $str_len, $spl_idx, $start_pos, $max_size, $last_is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $spl_idx = $spl_idx | 0;
 $start_pos = $start_pos | 0;
 $max_size = $max_size | 0;
 $last_is_pre = $last_is_pre | 0;
 var $call = 0, $spl_trie_ = 0, $sub = 0, $conv14 = 0, $pos_013 = 0, $arrayidx = 0, $2 = 0, $3 = 0, $inc = 0;
 $call = __ZN10ime_pinyin14SpellingParser16splstr16_to_idxsEPKttPtS3_tRb($this, $splstr, $str_len, $spl_idx, $start_pos, $max_size, $last_is_pre) | 0;
 if ($call << 16 >> 16 == 0) {
  return $call | 0;
 }
 $spl_trie_ = $this | 0;
 $sub = ($call & 65535) - 1 | 0;
 $pos_013 = 0;
 $conv14 = 0;
 while (1) {
  $arrayidx = $spl_idx + ($conv14 << 1) | 0;
  do {
   if (__ZNK10ime_pinyin12SpellingTrie16is_half_id_yunmuEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$arrayidx >> 1] | 0) | 0) {
    $2 = HEAP32[$spl_trie_ >> 2] | 0;
    $3 = HEAP16[$arrayidx >> 1] | 0;
    __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt($2, $3, $arrayidx) | 0;
    if (($conv14 | 0) != ($sub | 0)) {
     break;
    }
    HEAP8[$last_is_pre] = 0;
   }
  } while (0);
  $inc = $pos_013 + 1 & 65535;
  if (($inc & 65535) < ($call & 65535)) {
   $pos_013 = $inc;
   $conv14 = $inc & 65535;
  } else {
   break;
  }
 }
 return $call | 0;
}
function __ZN10ime_pinyin14SpellingParser16get_splid_by_strEPKctPb($this, $splstr, $str_len, $is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $is_pre = $is_pre | 0;
 var $start_pos = 0, $arraydecay = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $start_pos = sp + 8 | 0;
 if (($is_pre | 0) == 0) {
  STACKTOP = sp;
  return 0;
 }
 $arraydecay = sp | 0;
 if ((__ZN10ime_pinyin14SpellingParser14splstr_to_idxsEPKctPtS3_tRb($this, $splstr, $str_len, $arraydecay, $start_pos | 0, 2, $is_pre) | 0) << 16 >> 16 == 1) {
  STACKTOP = sp;
  return ((HEAP16[$start_pos + 2 >> 1] | 0) == $str_len << 16 >> 16 ? HEAP16[$arraydecay >> 1] | 0 : 0) | 0;
 } else {
  STACKTOP = sp;
  return 0;
 }
 return 0;
}
function __ZN10ime_pinyin14SpellingParser18get_splid_by_str_fEPKctPb($this, $splstr, $str_len, $is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $is_pre = $is_pre | 0;
 var $start_pos = 0, $arraydecay = 0, $spl_trie_ = 0, $3 = 0, $4 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $start_pos = sp + 8 | 0;
 if (($is_pre | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $arraydecay = sp | 0;
 if ((__ZN10ime_pinyin14SpellingParser14splstr_to_idxsEPKctPtS3_tRb($this, $splstr, $str_len, $arraydecay, $start_pos | 0, 2, $is_pre) | 0) << 16 >> 16 != 1) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if ((HEAP16[$start_pos + 2 >> 1] | 0) != $str_len << 16 >> 16) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $spl_trie_ = $this | 0;
 if (__ZNK10ime_pinyin12SpellingTrie16is_half_id_yunmuEt(HEAP32[$spl_trie_ >> 2] | 0, HEAP16[$arraydecay >> 1] | 0) | 0) {
  $3 = HEAP32[$spl_trie_ >> 2] | 0;
  $4 = HEAP16[$arraydecay >> 1] | 0;
  __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt($3, $4, $arraydecay) | 0;
  HEAP8[$is_pre] = 0;
 }
 $retval_0 = HEAP16[$arraydecay >> 1] | 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin14SpellingParser19get_splids_parallelEPKctPttRtRb($this, $splstr, $str_len, $splidx, $max_size, $full_id_num, $is_pre) {
 $this = $this | 0;
 $splstr = $splstr | 0;
 $str_len = $str_len | 0;
 $splidx = $splidx | 0;
 $max_size = $max_size | 0;
 $full_id_num = $full_id_num | 0;
 $is_pre = $is_pre | 0;
 var $1 = 0, $retval_0 = 0;
 do {
  if ($max_size << 16 >> 16 == 0) {
   $retval_0 = 0;
  } else {
   if (!(__ZN10ime_pinyin14SpellingParser17is_valid_to_parseEc(0, HEAP8[$splstr] | 0) | 0)) {
    $retval_0 = 0;
    break;
   }
   HEAP16[$splidx >> 1] = __ZN10ime_pinyin14SpellingParser16get_splid_by_strEPKctPb($this, $splstr, $str_len, $is_pre) | 0;
   HEAP16[$full_id_num >> 1] = 0;
   $1 = HEAP16[$splidx >> 1] | 0;
   if ($1 << 16 >> 16 == 0) {
    $retval_0 = 0;
    break;
   }
   if (($1 & 65535) <= 29) {
    $retval_0 = 1;
    break;
   }
   HEAP16[$full_id_num >> 1] = 1;
   $retval_0 = 1;
  }
 } while (0);
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDictC2Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin12AtomDictBaseC2Ev($this | 0);
 HEAP32[$this >> 2] = 8176;
 _memset($this + 8 | 0, 0, 100);
 __ZN10ime_pinyin8UserDict10cache_initEv($this);
 return;
}
function __ZN10ime_pinyin8UserDict10cache_initEv($this) {
 $this = $this | 0;
 __ZN10ime_pinyin8UserDict11reset_cacheEv($this);
 __ZN10ime_pinyin8UserDict16reset_miss_cacheEv($this);
 return;
}
function __ZN10ime_pinyin8UserDictD0Ev($this) {
 $this = $this | 0;
 __ZN10ime_pinyin8UserDictD2Ev($this);
 __ZdlPv($this);
 return;
}
function __ZN10ime_pinyin8UserDictD2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8176;
 FUNCTION_TABLE_ii[HEAP32[(HEAP32[$this >> 2] | 0) + 12 >> 2] & 31]($this) | 0;
 return;
}
function __ZN10ime_pinyin8UserDict9load_dictEPKcjj($this, $file_name, $start_id, $end_id) {
 $this = $this | 0;
 $file_name = $file_name | 0;
 $start_id = $start_id | 0;
 $end_id = $end_id | 0;
 var $call = 0, $dict_file_ = 0, $start_id_ = 0, $load_time_ = 0, $retval_0 = 0, label = 0;
 $call = _strdup($file_name | 0) | 0;
 $dict_file_ = $this + 64 | 0;
 HEAP32[$dict_file_ >> 2] = $call;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $start_id_ = $this + 16 | 0;
 HEAP32[$start_id_ >> 2] = $start_id;
 if (__ZN10ime_pinyin8UserDict8validateEPKc($this, $file_name) | 0) {
  label = 2890;
 } else {
  if (__ZN10ime_pinyin8UserDict5resetEPKc(0, $file_name) | 0) {
   label = 2890;
  }
 }
 do {
  if ((label | 0) == 2890) {
   if (!(__ZN10ime_pinyin8UserDict4loadEPKcj($this, $file_name, $start_id) | 0)) {
    break;
   }
   HEAP32[$this + 104 >> 2] = 1;
   $load_time_ = $this + 8 | 0;
   _gettimeofday($load_time_ | 0, 0) | 0;
   $retval_0 = 1;
   return $retval_0 | 0;
  }
 } while (0);
 _free(HEAP32[$dict_file_ >> 2] | 0);
 HEAP32[$start_id_ >> 2] = 0;
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict8validateEPKc($this, $file) {
 $this = $this | 0;
 $file = $file | 0;
 var $version = 0, $dict_info = 0, $call = 0, $call6 = 0, $cmp14 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 $version = sp | 0;
 $dict_info = sp + 8 | 0;
 $call = _fopen($file | 0, 3840) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 do {
  if ((_fseek($call | 0, 0, 2) | 0) == 0) {
   $call6 = _ftell($call | 0) | 0;
   if ($call6 >>> 0 < 40) {
    break;
   }
   if ((_fseek($call | 0, 0, 0) | 0) != 0) {
    break;
   }
   $cmp14 = (_fread($version | 0, 1, 4, $call | 0) | 0) >>> 0 > 3;
   if (!($cmp14 & (HEAP32[$version >> 2] | 0) == 18015e4)) {
    break;
   }
   if ((_fseek($call | 0, -36 | 0, 2) | 0) != 0) {
    break;
   }
   if ((_fread($dict_info | 0, 1, 36, $call | 0) | 0) != 36) {
    break;
   }
   if (($call6 | 0) != (__ZN10ime_pinyin8UserDict18get_dict_file_sizeEPNS0_12UserDictInfoE(0, $dict_info) | 0)) {
    break;
   }
   _fclose($call | 0) | 0;
   $retval_0 = 1;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 } while (0);
 _fclose($call | 0) | 0;
 $retval_0 = 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict5resetEPKc($this, $file) {
 $this = $this | 0;
 $file = $file | 0;
 var $version = 0, $call = 0, $call2 = 0, $1 = 0, $cmp = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 $version = sp | 0;
 $call = _fopen($file | 0, 2200) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP32[$version >> 2] = 18015e4;
 $call2 = _fwrite($version | 0, 1, 4, $call | 0) | 0;
 $1 = sp + 8 | 0;
 _memset($1 | 0, 0, 36);
 $cmp = ((_fwrite($1 | 0, 1, 36, $call | 0) | 0) + $call2 | 0) == 40;
 _fclose($call | 0) | 0;
 if ($cmp) {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _unlink($file | 0) | 0;
 $retval_0 = 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict16reset_milestonesEtt($this, $from_step, $from_handle) {
 $this = $this | 0;
 $from_step = $from_step | 0;
 $from_handle = $from_handle | 0;
 return;
}
function __ZN10ime_pinyin8UserDict16number_of_lemmasEv($this) {
 $this = $this | 0;
 return HEAP32[$this + 80 >> 2] | 0;
}
function __ZN10ime_pinyin8UserDict14is_valid_stateEv($this) {
 $this = $this | 0;
 return (HEAP32[$this + 104 >> 2] | 0) != 0 | 0;
}
function __ZN10ime_pinyin8UserDict18is_prefix_spell_idEPKttPKNS0_18UserDictSearchableE($this, $fullids, $fulllen, $searchable) {
 $this = $this | 0;
 $fullids = $fullids | 0;
 $fulllen = $fulllen | 0;
 $searchable = $searchable | 0;
 var $splids_len = 0, $conv4 = 0, $i_0 = 0, $2 = 0, $3 = 0, $retval_0 = 0, label = 0;
 $splids_len = $searchable | 0;
 if ((HEAPU16[$splids_len >> 1] | 0) > ($fulllen & 65535)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $conv4 = HEAPU16[$splids_len >> 1] | 0;
 $i_0 = 0;
 while (1) {
  if ($i_0 >>> 0 >= $conv4 >>> 0) {
   $retval_0 = 1;
   label = 2928;
   break;
  }
  $2 = HEAP16[$searchable + 2 + ($i_0 << 1) >> 1] | 0;
  $3 = HEAP16[$fullids + ($i_0 << 1) >> 1] | 0;
  if (($3 & 65535) < ($2 & 65535)) {
   $retval_0 = 0;
   label = 2929;
   break;
  }
  if (($3 & 65535 | 0) < ((HEAPU16[$searchable + 18 + ($i_0 << 1) >> 1] | 0) + ($2 & 65535) | 0)) {
   $i_0 = $i_0 + 1 | 0;
  } else {
   $retval_0 = 0;
   label = 2927;
   break;
  }
 }
 if ((label | 0) == 2928) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2927) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2929) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict14equal_spell_idEPKttPKNS0_18UserDictSearchableE($this, $fullids, $fulllen, $searchable) {
 $this = $this | 0;
 $fullids = $fullids | 0;
 $fulllen = $fulllen | 0;
 $searchable = $searchable | 0;
 var $conv = 0, $i_0 = 0, $1 = 0, $2 = 0, $retval_0 = 0, label = 0;
 $conv = $fulllen & 65535;
 if ((HEAP16[$searchable >> 1] | 0) == $fulllen << 16 >> 16) {
  $i_0 = 0;
 } else {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 while (1) {
  if ($i_0 >>> 0 >= $conv >>> 0) {
   $retval_0 = 1;
   label = 2936;
   break;
  }
  $1 = HEAP16[$searchable + 2 + ($i_0 << 1) >> 1] | 0;
  $2 = HEAP16[$fullids + ($i_0 << 1) >> 1] | 0;
  if (($2 & 65535) < ($1 & 65535)) {
   $retval_0 = 0;
   label = 2939;
   break;
  }
  if (($2 & 65535 | 0) < ((HEAPU16[$searchable + 18 + ($i_0 << 1) >> 1] | 0) + ($1 & 65535) | 0)) {
   $i_0 = $i_0 + 1 | 0;
  } else {
   $retval_0 = 0;
   label = 2938;
   break;
  }
 }
 if ((label | 0) == 2938) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2936) {
  return $retval_0 | 0;
 } else if ((label | 0) == 2939) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $offset) {
 $this = $this | 0;
 $offset = $offset | 0;
 return HEAP8[(HEAP32[$this + 24 >> 2] | 0) + (($offset & 2147483647) + 1) | 0] | 0;
}
function __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $offset) {
 $this = $this | 0;
 $offset = $offset | 0;
 return (HEAP32[$this + 24 >> 2] | 0) + (($offset & 2147483647) + 2) | 0;
}
function __ZN10ime_pinyin8UserDict4loadEPKcj($this, $file, $start_id) {
 $this = $this | 0;
 $file = $file | 0;
 $start_id = $start_id | 0;
 var $dict_info = 0, $call = 0, $0 = 0, $lemma_size = 0, $call9 = 0, $lemma_count = 0, $call14 = 0, $3 = 0, $call21 = 0, $5 = 0, $sync_count = 0, $call27 = 0, $7 = 0, $call34 = 0, $9 = 0, $call41 = 0, $11 = 0, $call48 = 0, $13 = 0, $15 = 0, $readed_0148 = 0, $add64 = 0, $readed_0_lcssa = 0, $shl70 = 0, $readed_1146 = 0, $shl91 = 0, $readed_2143 = 0, $readed_3140 = 0, $shl131 = 0, $21 = 0, $23 = 0, $readed_4137 = 0, $i_0135 = 0, $25 = 0, $syncs_0 = 0, $scores_0 = 0, $ids_0 = 0, $offsets_by_id_0 = 0, $predicts_0112 = 0, $offsets_by_id_0111 = 0, $ids_0110 = 0, $scores_0109 = 0, $syncs_0108 = 0, $predicts_0103 = 0, $offsets_by_id_0102 = 0, $ids_0101 = 0, $scores_0100 = 0, $syncs_099 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 40 | 0;
 $dict_info = sp | 0;
 $call = _fopen($file | 0, 3840) | 0;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 do {
  if ((_fseek($call | 0, -36 | 0, 2) | 0) == 0) {
   $0 = $dict_info;
   if ((_fread($0 | 0, 1, 36, $call | 0) | 0) != 36) {
    break;
   }
   $lemma_size = $dict_info + 16 | 0;
   $call9 = _malloc((HEAP32[$lemma_size >> 2] | 0) + 1088 | 0) | 0;
   if (($call9 | 0) == 0) {
    break;
   }
   $lemma_count = $dict_info + 12 | 0;
   $call14 = _malloc((HEAP32[$lemma_count >> 2] << 2) + 128 | 0) | 0;
   $3 = $call14;
   if (($call14 | 0) == 0) {
    $syncs_0108 = 0;
    $scores_0109 = 0;
    $ids_0110 = 0;
    $offsets_by_id_0111 = 0;
    $predicts_0112 = 0;
    label = 2980;
   } else {
    $call21 = _malloc((HEAP32[$lemma_count >> 2] << 2) + 128 | 0) | 0;
    $5 = $call21;
    L3760 : do {
     if (($call21 | 0) == 0) {
      $offsets_by_id_0 = 0;
      $ids_0 = 0;
      $scores_0 = 0;
      $syncs_0 = 0;
     } else {
      $sync_count = $dict_info + 28 | 0;
      $call27 = _malloc((HEAP32[$sync_count >> 2] << 2) + 128 | 0) | 0;
      $7 = $call27;
      if (($call27 | 0) == 0) {
       $offsets_by_id_0 = 0;
       $ids_0 = 0;
       $scores_0 = 0;
       $syncs_0 = $7;
       break;
      }
      $call34 = _malloc((HEAP32[$lemma_count >> 2] << 2) + 128 | 0) | 0;
      $9 = $call34;
      if (($call34 | 0) == 0) {
       $offsets_by_id_0 = 0;
       $ids_0 = 0;
       $scores_0 = $9;
       $syncs_0 = $7;
       break;
      }
      $call41 = _malloc((HEAP32[$lemma_count >> 2] << 2) + 128 | 0) | 0;
      $11 = $call41;
      if (($call41 | 0) == 0) {
       $offsets_by_id_0 = 0;
       $ids_0 = $11;
       $scores_0 = $9;
       $syncs_0 = $7;
       break;
      }
      $call48 = _malloc((HEAP32[$lemma_count >> 2] << 2) + 128 | 0) | 0;
      $13 = $call48;
      if (($call48 | 0) == 0) {
       $offsets_by_id_0 = $13;
       $ids_0 = $11;
       $scores_0 = $9;
       $syncs_0 = $7;
       break;
      }
      if ((_fseek($call | 0, 4, 0) | 0) != 0) {
       $offsets_by_id_0 = $13;
       $ids_0 = $11;
       $scores_0 = $9;
       $syncs_0 = $7;
       break;
      }
      L3767 : do {
       if ((HEAP32[$lemma_size >> 2] | 0) == 0) {
        $readed_0_lcssa = 0;
       } else {
        $15 = HEAP32[$lemma_size >> 2] | 0;
        $readed_0148 = 0;
        while (1) {
         if ((_ferror($call | 0) | 0) != 0) {
          $readed_0_lcssa = $readed_0148;
          break L3767;
         }
         if ((_feof($call | 0) | 0) != 0) {
          $readed_0_lcssa = $readed_0148;
          break L3767;
         }
         $add64 = (_fread($call9 + $readed_0148 | 0, 1, $15 - $readed_0148 | 0, $call | 0) | 0) + $readed_0148 | 0;
         if ($add64 >>> 0 < $15 >>> 0) {
          $readed_0148 = $add64;
         } else {
          $readed_0_lcssa = $add64;
          break;
         }
        }
       }
      } while (0);
      if ($readed_0_lcssa >>> 0 < (HEAP32[$lemma_size >> 2] | 0) >>> 0) {
       $offsets_by_id_0 = $13;
       $ids_0 = $11;
       $scores_0 = $9;
       $syncs_0 = $7;
       break;
      }
      $shl70 = HEAP32[$lemma_count >> 2] << 2;
      if (($shl70 | 0) != 0) {
       $readed_1146 = 0;
       do {
        if ((_ferror($call | 0) | 0) != 0) {
         $offsets_by_id_0 = $13;
         $ids_0 = $11;
         $scores_0 = $9;
         $syncs_0 = $7;
         break L3760;
        }
        if ((_feof($call | 0) | 0) != 0) {
         $offsets_by_id_0 = $13;
         $ids_0 = $11;
         $scores_0 = $9;
         $syncs_0 = $7;
         break L3760;
        }
        $readed_1146 = (_fread($call14 + $readed_1146 | 0, 1, $shl70 - $readed_1146 | 0, $call | 0) | 0) + $readed_1146 | 0;
       } while ($readed_1146 >>> 0 < $shl70 >>> 0);
      }
      $shl91 = HEAP32[$lemma_count >> 2] << 2;
      do {
       if (($shl91 | 0) != 0) {
        $readed_2143 = 0;
        do {
         if ((_ferror($call | 0) | 0) != 0) {
          $offsets_by_id_0 = $13;
          $ids_0 = $11;
          $scores_0 = $9;
          $syncs_0 = $7;
          break L3760;
         }
         if ((_feof($call | 0) | 0) != 0) {
          $offsets_by_id_0 = $13;
          $ids_0 = $11;
          $scores_0 = $9;
          $syncs_0 = $7;
          break L3760;
         }
         $readed_2143 = (_fread($call21 + $readed_2143 | 0, 1, $shl91 - $readed_2143 | 0, $call | 0) | 0) + $readed_2143 | 0;
        } while ($readed_2143 >>> 0 < $shl91 >>> 0);
        if (($shl91 | 0) == 0) {
         break;
        } else {
         $readed_3140 = 0;
        }
        do {
         if ((_ferror($call | 0) | 0) != 0) {
          $offsets_by_id_0 = $13;
          $ids_0 = $11;
          $scores_0 = $9;
          $syncs_0 = $7;
          break L3760;
         }
         if ((_feof($call | 0) | 0) != 0) {
          $offsets_by_id_0 = $13;
          $ids_0 = $11;
          $scores_0 = $9;
          $syncs_0 = $7;
          break L3760;
         }
         $readed_3140 = (_fread($call34 + $readed_3140 | 0, 1, $shl91 - $readed_3140 | 0, $call | 0) | 0) + $readed_3140 | 0;
        } while ($readed_3140 >>> 0 < $shl91 >>> 0);
       }
      } while (0);
      $shl131 = HEAP32[$sync_count >> 2] << 2;
      if (($shl131 | 0) != 0) {
       $readed_4137 = 0;
       do {
        if ((_ferror($call | 0) | 0) != 0) {
         $offsets_by_id_0 = $13;
         $ids_0 = $11;
         $scores_0 = $9;
         $syncs_0 = $7;
         break L3760;
        }
        if ((_feof($call | 0) | 0) != 0) {
         $offsets_by_id_0 = $13;
         $ids_0 = $11;
         $scores_0 = $9;
         $syncs_0 = $7;
         break L3760;
        }
        $readed_4137 = (_fread($call27 + $readed_4137 | 0, 1, $shl131 - $readed_4137 | 0, $call | 0) | 0) + $readed_4137 | 0;
       } while ($readed_4137 >>> 0 < $shl131 >>> 0);
      }
      if ((HEAP32[$lemma_count >> 2] | 0) != 0) {
       $21 = HEAP32[$lemma_count >> 2] | 0;
       $23 = $21 >>> 0 > 1 ? $21 << 2 : 4;
       _memcpy($call48 | 0, $call14 | 0, $23) | 0;
       $i_0135 = 0;
       do {
        HEAP32[$11 + ($i_0135 << 2) >> 2] = $i_0135 + $start_id;
        $i_0135 = $i_0135 + 1 | 0;
       } while ($i_0135 >>> 0 < $21 >>> 0);
      }
      HEAP32[$this + 24 >> 2] = $call9;
      HEAP32[$this + 28 >> 2] = $3;
      HEAP32[$this + 44 >> 2] = $7;
      HEAP32[$this + 48 >> 2] = (HEAP32[$sync_count >> 2] | 0) + 32;
      HEAP32[$this + 52 >> 2] = $13;
      HEAP32[$this + 32 >> 2] = $9;
      HEAP32[$this + 36 >> 2] = $11;
      HEAP32[$this + 40 >> 2] = $5;
      HEAP32[$this + 56 >> 2] = 32;
      HEAP32[$this + 60 >> 2] = 1088;
      $25 = $this + 68 | 0;
      _memcpy($25 | 0, $0 | 0, 36) | 0;
      HEAP32[$this + 104 >> 2] = 1;
      _fclose($call | 0) | 0;
      $retval_0 = 1;
      STACKTOP = sp;
      return $retval_0 | 0;
     }
    } while (0);
    if (($call9 | 0) == 0) {
     $syncs_099 = $syncs_0;
     $scores_0100 = $scores_0;
     $ids_0101 = $ids_0;
     $offsets_by_id_0102 = $offsets_by_id_0;
     $predicts_0103 = $5;
    } else {
     $syncs_0108 = $syncs_0;
     $scores_0109 = $scores_0;
     $ids_0110 = $ids_0;
     $offsets_by_id_0111 = $offsets_by_id_0;
     $predicts_0112 = $5;
     label = 2980;
    }
   }
   if ((label | 0) == 2980) {
    _free($call9);
    $syncs_099 = $syncs_0108;
    $scores_0100 = $scores_0109;
    $ids_0101 = $ids_0110;
    $offsets_by_id_0102 = $offsets_by_id_0111;
    $predicts_0103 = $predicts_0112;
   }
   if (($call14 | 0) != 0) {
    _free($call14);
   }
   if (($syncs_099 | 0) != 0) {
    _free($syncs_099);
   }
   if (($scores_0100 | 0) != 0) {
    _free($scores_0100);
   }
   if (($ids_0101 | 0) != 0) {
    _free($ids_0101);
   }
   if (($offsets_by_id_0102 | 0) != 0) {
    _free($offsets_by_id_0102);
   }
   if (($predicts_0103 | 0) == 0) {
    break;
   }
   _free($predicts_0103);
  }
 } while (0);
 _fclose($call | 0) | 0;
 $retval_0 = 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict10close_dictEv($this) {
 $this = $this | 0;
 var $0 = 0, $1 = 0, $2 = 0, label = 0;
 $0 = HEAP32[$this + 104 >> 2] | 0;
 if (($0 | 0) == 0) {
  return 1;
 } else if (($0 | 0) != 1) {
  label = 2999;
 }
 do {
  if ((label | 0) == 2999) {
   $1 = HEAP32[$this + 8 >> 2] | 0;
   $2 = HEAP32[11850] | 0;
   if (($1 | 0) <= ($2 | 0)) {
    if (($1 | 0) != ($2 | 0)) {
     break;
    }
    if ((HEAP32[$this + 12 >> 2] | 0) <= (HEAP32[11851] | 0)) {
     break;
    }
   }
   __ZN10ime_pinyin8UserDict10write_backEv($this);
   _gettimeofday(47400, 0) | 0;
  }
 } while (0);
 _free(HEAP32[$this + 64 >> 2] | 0);
 _free(HEAP32[$this + 24 >> 2] | 0);
 _free(HEAP32[$this + 28 >> 2] | 0);
 _free(HEAP32[$this + 52 >> 2] | 0);
 _free(HEAP32[$this + 32 >> 2] | 0);
 _free(HEAP32[$this + 36 >> 2] | 0);
 _free(HEAP32[$this + 40 >> 2] | 0);
 _memset($this + 20 | 0, 0, 88);
 return 1;
}
function __ZN10ime_pinyin8UserDict10write_backEv($this) {
 $this = $this | 0;
 var $state_ = 0, $call = 0, $2 = 0, sp = 0;
 sp = STACKTOP;
 $state_ = $this + 104 | 0;
 if ((HEAP32[$state_ >> 2] | 0) >>> 0 < 2) {
  STACKTOP = sp;
  return;
 }
 $call = _open(HEAP32[$this + 64 >> 2] | 0, 1, (tempInt = STACKTOP, STACKTOP = STACKTOP + 1 | 0, STACKTOP = STACKTOP + 7 >> 3 << 3, HEAP32[tempInt >> 2] = 0, tempInt) | 0) | 0;
 if (($call | 0) == -1) {
  STACKTOP = sp;
  return;
 }
 $2 = HEAP32[$state_ >> 2] | 0;
 if (($2 | 0) == 4) {
  __ZN10ime_pinyin8UserDict17write_back_offsetEi($this, $call);
 } else if (($2 | 0) == 2) {
  __ZN10ime_pinyin8UserDict15write_back_syncEi($this, $call);
 } else if (($2 | 0) == 3) {
  __ZN10ime_pinyin8UserDict16write_back_scoreEi($this, $call);
 } else if (($2 | 0) == 6) {
  __ZN10ime_pinyin8UserDict14write_back_allEi($this, $call);
 } else if (($2 | 0) == 5) {
  __ZN10ime_pinyin8UserDict16write_back_lemmaEi($this, $call);
 }
 _ftruncate($call | 0, _lseek($call | 0, 0, 1) | 0) | 0;
 _close($call | 0) | 0;
 HEAP32[$state_ >> 2] = 1;
 STACKTOP = sp;
 return;
}
function __ZN10ime_pinyin8UserDict11extend_dictEtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj($this, $from_handle, $dep, $lpi_items, $lpi_max, $lpi_num) {
 $this = $this | 0;
 $from_handle = $from_handle | 0;
 $dep = $dep | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $lpi_num = $lpi_num | 0;
 var $need_extend = 0, $call4 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $need_extend = sp | 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP8[$need_extend] = 0;
 $call4 = __ZN10ime_pinyin8UserDict9_get_lpisEPKttPNS_10LmaPsbItemEjPb($this, $dep | 0, (HEAP16[$dep + 80 >> 1] | 0) + 1 & 65535, $lpi_items, $lpi_max, $need_extend) | 0;
 HEAP32[$lpi_num >> 2] = $call4;
 if (($call4 | 0) != 0) {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP8[$need_extend] & 1;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict9_get_lpisEPKttPNS_10LmaPsbItemEjPb($this, $splid_str, $splid_str_len, $lpi_items, $lpi_max, $need_extend) {
 $this = $this | 0;
 $splid_str = $splid_str | 0;
 $splid_str_len = $splid_str_len | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 $need_extend = $need_extend | 0;
 var $searchable = 0, $start = 0, $count = 0, $tmp_extend_need_extend = 0, $0 = 0, $1 = 0, $6 = 0, $call15 = 0, $7 = 0, $call19 = 0, $middle_0 = 0, $max_off_0 = 0, $offsets_ = 0, $scores_ = 0, $ids_ = 0, $middle_1 = 0, $10 = 0, $call37 = 0, $call38 = 0, $fuzzy_break_1_off0 = 0, $conv50 = 0, $prefix_break_1_off0 = 0, $17 = 0, $lpi_current_1 = 0, $middle_1_ph = 0, $lpi_current_0_ph = 0, $fuzzy_break_0_off0_ph = 0, $prefix_break_0_off0_ph = 0, $cmp31 = 0, $23 = 0, $sub = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 72 | 0;
 $searchable = sp + 8 | 0;
 $start = sp + 56 | 0;
 $count = sp + 64 | 0;
 $tmp_extend_need_extend = ($need_extend | 0) == 0 ? sp | 0 : $need_extend;
 HEAP8[$tmp_extend_need_extend] = 0;
 if (($lpi_max | 0) == 0 | (__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0) ^ 1) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $0 = HEAP32[$this + 8 >> 2] | 0;
 $1 = HEAP32[11850] | 0;
 do {
  if (($0 | 0) < ($1 | 0)) {
   label = 3031;
  } else {
   if (($0 | 0) != ($1 | 0)) {
    break;
   }
   if ((HEAP32[$this + 12 >> 2] | 0) < (HEAP32[11851] | 0)) {
    label = 3031;
   }
  }
 } while (0);
 if ((label | 0) == 3031) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[$this >> 2] | 0) + 76 >> 2] & 127]($this);
 }
 __ZN10ime_pinyin8UserDict14prepare_locateEPNS0_18UserDictSearchableEPKtt(0, $searchable, $splid_str, $splid_str_len);
 $6 = HEAP32[$this + 80 >> 2] | 0;
 $call15 = __ZN10ime_pinyin8UserDict9cache_hitEPNS0_18UserDictSearchableEPjS3_($this, $searchable, $start, $count) | 0;
 if ($call15) {
  $7 = HEAP32[$start >> 2] | 0;
  $max_off_0 = (HEAP32[$count >> 2] | 0) + $7 | 0;
  $middle_0 = $7;
 } else {
  $call19 = __ZN10ime_pinyin8UserDict23locate_first_in_offsetsEPKNS0_18UserDictSearchableE($this, $searchable) | 0;
  HEAP32[$start >> 2] = $call19;
  $max_off_0 = $6;
  $middle_0 = $call19;
 }
 if (($middle_0 | 0) == -1) {
  if ($call15) {
   $retval_0 = 0;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
  __ZN10ime_pinyin8UserDict10cache_pushENS0_17UserDictCacheTypeEPNS0_18UserDictSearchableEjj($this, 1, $searchable, 0, 0);
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $offsets_ = $this + 28 | 0;
 $scores_ = $this + 32 | 0;
 $ids_ = $this + 36 | 0;
 $prefix_break_0_off0_ph = 0;
 $fuzzy_break_0_off0_ph = 0;
 $lpi_current_0_ph = 0;
 $middle_1_ph = $middle_0;
 L3881 : while (1) {
  $cmp31 = $lpi_current_0_ph >>> 0 < $lpi_max >>> 0;
  $middle_1 = $middle_1_ph;
  while (1) {
   if (!($cmp31 & (($middle_1 >>> 0 >= $max_off_0 >>> 0 | $fuzzy_break_0_off0_ph | $prefix_break_0_off0_ph) ^ 1))) {
    break L3881;
   }
   $10 = HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($middle_1 << 2) >> 2] | 0;
   if (($10 | 0) < 0) {
    $middle_1 = $middle_1 + 1 | 0;
   } else {
    break;
   }
  }
  $call37 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $10) | 0;
  $call38 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $10) | 0;
  if ($call15) {
   $fuzzy_break_1_off0 = $fuzzy_break_0_off0_ph;
  } else {
   $fuzzy_break_1_off0 = $fuzzy_break_0_off0_ph | (__ZN10ime_pinyin8UserDict22fuzzy_compare_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call38, $call37 & 255, $searchable) | 0) != 0;
  }
  do {
   if ($prefix_break_0_off0_ph) {
    $prefix_break_1_off0 = 1;
   } else {
    $conv50 = $call37 & 255;
    if ((__ZN10ime_pinyin8UserDict24is_fuzzy_prefix_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call38, $conv50, $searchable) | 0) == 0) {
     $prefix_break_1_off0 = 1;
     break;
    }
    if ((HEAP8[$tmp_extend_need_extend] & 1) != 0) {
     $prefix_break_1_off0 = $prefix_break_0_off0_ph;
     break;
    }
    if (!(__ZN10ime_pinyin8UserDict18is_prefix_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call38, $conv50, $searchable) | 0)) {
     $prefix_break_1_off0 = $prefix_break_0_off0_ph;
     break;
    }
    HEAP8[$tmp_extend_need_extend] = 1;
    $prefix_break_1_off0 = $prefix_break_0_off0_ph;
   }
  } while (0);
  if (__ZN10ime_pinyin8UserDict14equal_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call38, $call37 & 255, $searchable) | 0) {
   HEAP16[$lpi_items + ($lpi_current_0_ph << 3) + 4 >> 1] = __ZN10ime_pinyin8UserDict15translate_scoreEi($this, HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($middle_1 << 2) >> 2] | 0) | 0;
   $17 = $lpi_items + ($lpi_current_0_ph << 3) | 0;
   HEAP32[$17 >> 2] = HEAP32[(HEAP32[$ids_ >> 2] | 0) + ($middle_1 << 2) >> 2] & 16777215 | ($call37 & 255) << 24 & 251658240 | HEAP32[$17 >> 2] & -268435456;
   $lpi_current_1 = $lpi_current_0_ph + 1 | 0;
  } else {
   $lpi_current_1 = $lpi_current_0_ph;
  }
  $prefix_break_0_off0_ph = $prefix_break_1_off0;
  $fuzzy_break_0_off0_ph = $fuzzy_break_1_off0;
  $lpi_current_0_ph = $lpi_current_1;
  $middle_1_ph = $middle_1 + 1 | 0;
 }
 if ($call15) {
  $retval_0 = $lpi_current_0_ph;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $23 = HEAP32[$start >> 2] | 0;
 $sub = $middle_1 - $23 | 0;
 HEAP32[$count >> 2] = $sub;
 __ZN10ime_pinyin8UserDict10cache_pushENS0_17UserDictCacheTypeEPNS0_18UserDictSearchableEjj($this, 0, $searchable, $23, $sub);
 $retval_0 = $lpi_current_0_ph;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict24is_fuzzy_prefix_spell_idEPKttPKNS0_18UserDictSearchableE($this, $id1, $len1, $searchable) {
 $this = $this | 0;
 $id1 = $id1 | 0;
 $len1 = $len1 | 0;
 $searchable = $searchable | 0;
 var $splids_len = 0, $call = 0, $i_0 = 0, $3 = 0, $conv9 = 0, $retval_0 = 0, label = 0;
 $splids_len = $searchable | 0;
 if ((HEAPU16[$splids_len >> 1] | 0) > ($len1 & 65535)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $i_0 = 0;
 while (1) {
  if ($i_0 >>> 0 >= (HEAPU16[$splids_len >> 1] | 0) >>> 0) {
   $retval_0 = 1;
   label = 3067;
   break;
  }
  $3 = HEAP8[__ZN10ime_pinyin12SpellingTrie16get_spelling_strEt($call, HEAP16[$id1 + ($i_0 << 1) >> 1] | 0) | 0] | 0;
  $conv9 = $i_0 << 3 & 24;
  if (($3 << 24 >> 24 | 0) == ((HEAP32[$searchable + 36 + ($i_0 >>> 2 << 2) >> 2] & 255 << $conv9) >>> ($conv9 >>> 0) << 24 >> 24 | 0)) {
   $i_0 = $i_0 + 1 | 0;
  } else {
   $retval_0 = 0;
   label = 3065;
   break;
  }
 }
 if ((label | 0) == 3065) {
  return $retval_0 | 0;
 } else if ((label | 0) == 3067) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict22fuzzy_compare_spell_idEPKttPKNS0_18UserDictSearchableE($this, $id1, $len1, $searchable) {
 $this = $this | 0;
 $id1 = $id1 | 0;
 $len1 = $len1 | 0;
 $searchable = $searchable | 0;
 var $conv = 0, $0 = 0, $call = 0, $i_0 = 0, $2 = 0, $conv14 = 0, $conv17 = 0, $conv18 = 0, $retval_0 = 0, label = 0;
 $conv = $len1 & 65535;
 $0 = HEAP16[$searchable >> 1] | 0;
 if (($0 & 65535) > ($len1 & 65535)) {
  $retval_0 = -1;
  return $retval_0 | 0;
 }
 if (($0 & 65535) < ($len1 & 65535)) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 $call = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $i_0 = 0;
 while (1) {
  if ($i_0 >>> 0 >= $conv >>> 0) {
   $retval_0 = 0;
   label = 3076;
   break;
  }
  $2 = HEAP8[__ZN10ime_pinyin12SpellingTrie16get_spelling_strEt($call, HEAP16[$id1 + ($i_0 << 1) >> 1] | 0) | 0] | 0;
  $conv14 = $i_0 << 3 & 24;
  $conv17 = $2 << 24 >> 24;
  $conv18 = (HEAP32[$searchable + 36 + ($i_0 >>> 2 << 2) >> 2] & 255 << $conv14) >>> ($conv14 >>> 0) << 24 >> 24;
  if (($conv17 | 0) == ($conv18 | 0)) {
   $i_0 = $i_0 + 1 | 0;
  } else {
   break;
  }
 }
 if ((label | 0) == 3076) {
  return $retval_0 | 0;
 }
 $retval_0 = ($conv17 | 0) > ($conv18 | 0) ? 1 : -1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict23locate_first_in_offsetsEPKNS0_18UserDictSearchableE($this, $searchable) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 var $offsets_ = 0, $first_prefix_0_ph = 0, $end_0_ph_in = 0, $begin_0_ph = 0, $end_0_ph = 0, $first_prefix_0 = 0, $begin_0 = 0, $shr = 0, $2 = 0, $call = 0, $call2 = 0, $conv = 0, $call4 = 0, $first_prefix_0_shr = 0;
 $offsets_ = $this + 28 | 0;
 $begin_0_ph = 0;
 $end_0_ph_in = HEAP32[$this + 80 >> 2] | 0;
 $first_prefix_0_ph = -1;
 L3929 : while (1) {
  $end_0_ph = $end_0_ph_in - 1 | 0;
  $begin_0 = $begin_0_ph;
  $first_prefix_0 = $first_prefix_0_ph;
  while (1) {
   if (($begin_0 | 0) > ($end_0_ph | 0)) {
    break L3929;
   }
   $shr = $begin_0 + $end_0_ph >> 1;
   $2 = HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($shr << 2) >> 2] | 0;
   $call = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
   $call2 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $2) | 0;
   $conv = $call & 255;
   $call4 = __ZN10ime_pinyin8UserDict22fuzzy_compare_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call2, $conv, $searchable) | 0;
   $first_prefix_0_shr = (__ZN10ime_pinyin8UserDict24is_fuzzy_prefix_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call2, $conv, $searchable) | 0) == 0 ? $first_prefix_0 : $shr;
   if (($call4 | 0) < 0) {
    $begin_0 = $shr + 1 | 0;
    $first_prefix_0 = $first_prefix_0_shr;
   } else {
    $begin_0_ph = $begin_0;
    $end_0_ph_in = $shr;
    $first_prefix_0_ph = $first_prefix_0_shr;
    continue L3929;
   }
  }
 }
 return $first_prefix_0 | 0;
}
function __ZN10ime_pinyin8UserDict14prepare_locateEPNS0_18UserDictSearchableEPKtt($this, $searchable, $splid_str, $splid_str_len) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 $splid_str = $splid_str | 0;
 $splid_str_len = $splid_str_len | 0;
 var $0 = 0, $call = 0, $conv = 0, $i_025 = 0, $arrayidx = 0, $shl = 0, $arrayidx16 = 0;
 HEAP16[$searchable >> 1] = $splid_str_len;
 $0 = $searchable + 36 | 0;
 HEAP32[$0 >> 2] = 0;
 HEAP32[$0 + 4 >> 2] = 0;
 $call = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 $conv = $splid_str_len & 65535;
 if ($splid_str_len << 16 >> 16 == 0) {
  return;
 } else {
  $i_025 = 0;
 }
 do {
  $arrayidx = $splid_str + ($i_025 << 1) | 0;
  if (__ZNK10ime_pinyin12SpellingTrie10is_half_idEt($call, HEAP16[$arrayidx >> 1] | 0) | 0) {
   HEAP16[$searchable + 18 + ($i_025 << 1) >> 1] = __ZNK10ime_pinyin12SpellingTrie12half_to_fullEtPt($call, HEAP16[$arrayidx >> 1] | 0, $searchable + 2 + ($i_025 << 1) | 0) | 0;
  } else {
   HEAP16[$searchable + 18 + ($i_025 << 1) >> 1] = 1;
   HEAP16[$searchable + 2 + ($i_025 << 1) >> 1] = HEAP16[$arrayidx >> 1] | 0;
  }
  $shl = (HEAPU8[__ZN10ime_pinyin12SpellingTrie16get_spelling_strEt($call, HEAP16[$arrayidx >> 1] | 0) | 0] | 0) << ($i_025 << 3 & 24);
  $arrayidx16 = $searchable + 36 + ($i_025 >>> 2 << 2) | 0;
  HEAP32[$arrayidx16 >> 2] = $shl | HEAP32[$arrayidx16 >> 2];
  $i_025 = $i_025 + 1 | 0;
 } while ($i_025 >>> 0 < $conv >>> 0);
 return;
}
function __ZN10ime_pinyin8UserDict8get_lpisEPKttPNS_10LmaPsbItemEj($this, $splid_str, $splid_str_len, $lpi_items, $lpi_max) {
 $this = $this | 0;
 $splid_str = $splid_str | 0;
 $splid_str_len = $splid_str_len | 0;
 $lpi_items = $lpi_items | 0;
 $lpi_max = $lpi_max | 0;
 return __ZN10ime_pinyin8UserDict9_get_lpisEPKttPNS_10LmaPsbItemEjPb($this, $splid_str, $splid_str_len, $lpi_items, $lpi_max, 0) | 0;
}
function __ZN10ime_pinyin8UserDict10load_cacheEPNS0_18UserDictSearchableEPjS3_($this, $searchable, $offset, $length) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 $offset = $offset | 0;
 $length = $length | 0;
 var $sub = 0, $1 = 0, $tail = 0, $i_0 = 0, $idxprom8 = 0, $j_0 = 0, $conv5 = 0, $inc20 = 0, $sub25_inc20 = 0, $retval_0 = 0, label = 0;
 $sub = (HEAPU16[$searchable >> 1] | 0) - 1 | 0;
 $1 = HEAP16[$this + 588 + ($sub * 68 | 0) + 64 >> 1] | 0;
 $tail = $this + 588 + ($sub * 68 | 0) + 66 | 0;
 if ($1 << 16 >> 16 == (HEAP16[$tail >> 1] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $i_0 = $1;
 }
 L3949 : while (1) {
  $idxprom8 = $i_0 & 65535;
  $j_0 = 0;
  while (1) {
   $conv5 = $j_0 & 65535;
   if (($j_0 & 65535) >= 2) {
    break L3949;
   }
   if ((HEAP32[$this + 588 + ($sub * 68 | 0) + ($idxprom8 << 3) + ($conv5 << 2) >> 2] | 0) == (HEAP32[$searchable + 36 + ($conv5 << 2) >> 2] | 0)) {
    $j_0 = $j_0 + 1 & 65535;
   } else {
    break;
   }
  }
  $inc20 = $i_0 + 1 & 65535;
  $sub25_inc20 = ($inc20 & 65535) > 3 ? $i_0 - 3 & 65535 : $inc20;
  if ($sub25_inc20 << 16 >> 16 == (HEAP16[$tail >> 1] | 0)) {
   $retval_0 = 0;
   label = 3100;
   break;
  } else {
   $i_0 = $sub25_inc20;
  }
 }
 if ((label | 0) == 3100) {
  return $retval_0 | 0;
 }
 HEAP32[$offset >> 2] = HEAP32[$this + 588 + ($sub * 68 | 0) + 32 + ($idxprom8 << 2) >> 2];
 HEAP32[$length >> 2] = HEAP32[$this + 588 + ($sub * 68 | 0) + 48 + ($idxprom8 << 2) >> 2];
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict27remove_lemma_from_sync_listEj($this, $offset) {
 $this = $this | 0;
 $offset = $offset | 0;
 var $syncs_ = 0, $sync_count = 0, $0 = 0, $i_0 = 0, $5 = 0, $6 = 0;
 $syncs_ = $this + 44 | 0;
 $sync_count = $this + 96 | 0;
 $0 = HEAP32[$sync_count >> 2] | 0;
 $i_0 = 0;
 while (1) {
  if ($i_0 >>> 0 >= $0 >>> 0) {
   break;
  }
  if (((HEAP32[(HEAP32[$syncs_ >> 2] | 0) + ($i_0 << 2) >> 2] ^ $offset) & 2147483647 | 0) == 0) {
   break;
  } else {
   $i_0 = $i_0 + 1 | 0;
  }
 }
 $5 = HEAP32[$sync_count >> 2] | 0;
 if ($i_0 >>> 0 >= $5 >>> 0) {
  return;
 }
 $6 = HEAP32[$this + 44 >> 2] | 0;
 HEAP32[$6 + ($i_0 << 2) >> 2] = HEAP32[$6 + ($5 - 1 << 2) >> 2];
 HEAP32[$sync_count >> 2] = (HEAP32[$sync_count >> 2] | 0) - 1;
 return;
}
function __ZN10ime_pinyin8UserDict30remove_lemma_from_predict_listEj($this, $offset) {
 $this = $this | 0;
 $offset = $offset | 0;
 var $0 = 0, $predicts_ = 0, $i_0 = 0, $arrayidx = 0, $2 = 0, label = 0;
 $0 = HEAP32[$this + 80 >> 2] | 0;
 $predicts_ = $this + 40 | 0;
 $i_0 = 0;
 while (1) {
  if ($i_0 >>> 0 >= $0 >>> 0) {
   label = 3117;
   break;
  }
  $arrayidx = (HEAP32[$predicts_ >> 2] | 0) + ($i_0 << 2) | 0;
  $2 = HEAP32[$arrayidx >> 2] | 0;
  if ((($2 ^ $offset) & 2147483647 | 0) == 0) {
   break;
  } else {
   $i_0 = $i_0 + 1 | 0;
  }
 }
 if ((label | 0) == 3117) {
  return;
 }
 HEAP32[$arrayidx >> 2] = $2 | -2147483648;
 return;
}
function __ZN10ime_pinyin8UserDict18get_dict_file_sizeEPNS0_12UserDictInfoE($this, $info) {
 $this = $this | 0;
 $info = $info | 0;
 var $1 = 0;
 $1 = HEAP32[$info + 12 >> 2] | 0;
 return (HEAP32[$info + 16 >> 2] | 0) + 40 + ($1 << 3) + ((HEAP32[$info + 28 >> 2] | 0) + $1 << 2) | 0;
}
function __ZN10ime_pinyin8UserDict9cache_hitEPNS0_18UserDictSearchableEPjS3_($this, $searchable, $offset, $length) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 $offset = $offset | 0;
 $length = $length | 0;
 var $retval_0 = 0;
 if (__ZN10ime_pinyin8UserDict15load_miss_cacheEPNS0_18UserDictSearchableE($this, $searchable) | 0) {
  HEAP32[$offset >> 2] = 0;
  HEAP32[$length >> 2] = 0;
  $retval_0 = 1;
  return $retval_0 | 0;
 } else {
  $retval_0 = __ZN10ime_pinyin8UserDict10load_cacheEPNS0_18UserDictSearchableEPjS3_($this, $searchable, $offset, $length) | 0;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict10cache_pushENS0_17UserDictCacheTypeEPNS0_18UserDictSearchableEjj($this, $type, $searchable, $offset, $length) {
 $this = $this | 0;
 $type = $type | 0;
 $searchable = $searchable | 0;
 $offset = $offset | 0;
 $length = $length | 0;
 if (($type | 0) == 0) {
  __ZN10ime_pinyin8UserDict10save_cacheEPNS0_18UserDictSearchableEjj($this, $searchable, $offset, $length);
  return;
 } else if (($type | 0) == 1) {
  __ZN10ime_pinyin8UserDict15save_miss_cacheEPNS0_18UserDictSearchableE($this, $searchable);
  return;
 } else {
  return;
 }
}
function __ZN10ime_pinyin8UserDict15translate_scoreEi($this, $raw_score) {
 $this = $this | 0;
 $raw_score = $raw_score | 0;
 var $call = 0, $0 = 0, $sub$0 = 0, $div$0 = 0, $sub4$0 = 0, $conv5 = 0;
 $call = __ZN10ime_pinyin8UserDict18extract_score_freqEi(0, $raw_score) | 0;
 $0 = HEAP32[$this + 8 >> 2] | 0;
 $sub$0 = _i64Add($0, ($0 | 0) < 0 ? -1 : 0, -1229904e3, -1) | 0;
 $div$0 = ___udivdi3($sub$0, tempRet0, 604800, 0) | 0;
 $sub4$0 = _i64Subtract($div$0 & 65535, tempRet0 & 0, $raw_score >>> 16, 0) | 0;
 $conv5 = $sub4$0;
 return ~~(+Math_log(+(+($call >>> 0 >>> 0) * (($conv5 | 0) > 4 ? 16.0 : +(80 - ($conv5 << 4) | 0)) / +(((HEAP32[$this + 4 >> 2] | 0) + (HEAP32[$this + 100 >> 2] | 0) | 0) >>> 0 >>> 0))) * -800.0) | 0;
}
function __ZN10ime_pinyin8UserDict13get_lemma_strEjPtt($this, $id_lemma, $str_buf, $str_max) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $str_buf = $str_buf | 0;
 $str_max = $str_max | 0;
 var $2 = 0, $call7 = 0, $call8 = 0, $sub11 = 0, $cond_off0 = 0, $conv17 = 0, $3 = 0, $4 = 0, $i_012 = 0, $i_0_lcssa = 0, $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $id_lemma) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $2 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($id_lemma - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
 $call7 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
 $call8 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0;
 $sub11 = ($str_max & 65535) - 1 | 0;
 $cond_off0 = ($call7 & 255 | 0) < ($sub11 | 0) ? $call7 & 255 : $sub11 & 65535;
 $conv17 = $cond_off0 & 65535;
 if ($cond_off0 << 16 >> 16 == 0) {
  $i_0_lcssa = 0;
 } else {
  $3 = $cond_off0 & 65535;
  $4 = $3 >>> 0 > 1;
  $i_012 = 0;
  do {
   HEAP16[$str_buf + ($i_012 << 1) >> 1] = HEAP16[$call8 + ($i_012 << 1) >> 1] | 0;
   $i_012 = $i_012 + 1 | 0;
  } while (($i_012 | 0) < ($conv17 | 0));
  $i_0_lcssa = $4 ? $3 : 1;
 }
 HEAP16[$str_buf + ($i_0_lcssa << 1) >> 1] = 0;
 $retval_0 = $cond_off0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $id) {
 $this = $this | 0;
 $id = $id | 0;
 var $retval_0 = 0;
 do {
  if ((HEAP32[$this + 16 >> 2] | 0) >>> 0 <= $id >>> 0) {
   if ((__ZN10ime_pinyin8UserDict16get_max_lemma_idEv($this) | 0) >>> 0 < $id >>> 0) {
    break;
   } else {
    $retval_0 = 1;
   }
   return $retval_0 | 0;
  }
 } while (0);
 $retval_0 = 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $offset) {
 $this = $this | 0;
 $offset = $offset | 0;
 var $and = 0, $call = 0;
 $and = $offset & 2147483647;
 $call = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $and) | 0;
 return (HEAP32[$this + 24 >> 2] | 0) + ($and + 2 + (($call & 255) << 1)) | 0;
}
function __ZN10ime_pinyin8UserDict16get_lemma_splidsEjPttb($this, $id_lemma, $splids, $splids_max, $arg_valid) {
 $this = $this | 0;
 $id_lemma = $id_lemma | 0;
 $splids = $splids | 0;
 $splids_max = $splids_max | 0;
 $arg_valid = $arg_valid | 0;
 var $2 = 0, $call2 = 0, $call3 = 0, $conv6 = 0, $conv4 = 0, $5 = 0, $8 = 0, $umax = 0, $i_010 = 0, $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $id_lemma) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $2 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($id_lemma - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
 $call2 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
 $call3 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $2) | 0;
 $conv6 = $splids_max & 65535;
 $conv4 = $call2 & 255;
 if (!($call2 << 24 >> 24 != 0 & $splids_max << 16 >> 16 != 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $5 = ($call2 & 255) > 1 ? -($call2 & 255) | 0 : -1;
 $8 = ($splids_max & 65535) > 1 ? -($splids_max & 65535) | 0 : -1;
 $umax = $5 >>> 0 > $8 >>> 0 ? $5 : $8;
 $i_010 = 0;
 do {
  HEAP16[$splids + ($i_010 << 1) >> 1] = HEAP16[$call3 + ($i_010 << 1) >> 1] | 0;
  $i_010 = $i_010 + 1 | 0;
 } while (($i_010 | 0) < ($conv4 | 0) & ($i_010 | 0) < ($conv6 | 0));
 $retval_0 = -$umax & 65535;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict7predictEPKttPNS_12NPredictItemEjj($this, $last_hzs, $hzs_len, $npre_items, $npre_max, $b4_used) {
 $this = $this | 0;
 $last_hzs = $last_hzs | 0;
 $hzs_len = $hzs_len | 0;
 $npre_items = $npre_items | 0;
 $npre_max = $npre_max | 0;
 $b4_used = $b4_used | 0;
 var $sub = 0, $conv = 0, $call = 0, $predicts_ = 0, $1 = 0, $shl = 0, $2 = 0, $new_added_0_ph42 = 0, $j_0_ph41 = 0, $3 = 0, $j_034 = 0, $4 = 0, $j_0_be = 0, $call5 = 0, $conv6 = 0, $call7 = 0, $call8 = 0, $sub25 = 0, $7 = 0, $8 = 0, $inc40 = 0, $inc42 = 0, $retval_0 = 0, label = 0;
 $sub = (HEAP32[$this + 80 >> 2] | 0) - 1 | 0;
 $conv = $hzs_len & 65535;
 $call = __ZN10ime_pinyin8UserDict24locate_first_in_predictsEPKti($this, $last_hzs, $conv) | 0;
 if (($call | 0) == -1 | ($call | 0) > ($sub | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $predicts_ = $this + 40 | 0;
 $1 = $last_hzs;
 $shl = $conv << 1;
 $2 = $this;
 $j_0_ph41 = $call;
 $new_added_0_ph42 = 0;
 L4027 : while (1) {
  $3 = HEAP32[$predicts_ >> 2] | 0;
  $j_034 = $j_0_ph41;
  while (1) {
   $4 = HEAP32[$3 + ($j_034 << 2) >> 2] | 0;
   if (($4 | 0) >= 0) {
    $call5 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $4) | 0;
    $conv6 = $call5 << 24 >> 24;
    $call7 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $4) | 0;
    $call8 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $4) | 0;
    if ($conv6 >>> 0 > $conv >>> 0) {
     break;
    }
   }
   $j_0_be = $j_034 + 1 | 0;
   if (($j_0_be | 0) > ($sub | 0)) {
    $retval_0 = $new_added_0_ph42;
    label = 3171;
    break L4027;
   } else {
    $j_034 = $j_0_be;
   }
  }
  if (!((_memcmp($call7 | 0, $1 | 0, $shl | 0) | 0) == 0 & $new_added_0_ph42 >>> 0 < $npre_max >>> 0)) {
   $retval_0 = $new_added_0_ph42;
   label = 3174;
   break;
  }
  $sub25 = (($call5 & 255) < 7 ? $conv6 << 1 : 14) - $shl | 0;
  HEAP16[$npre_items + ($new_added_0_ph42 * 20 | 0) + 18 >> 1] = $hzs_len;
  HEAPF32[$npre_items + ($new_added_0_ph42 * 20 | 0) >> 2] = +(((FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$2 >> 2] | 0) + 60 >> 2] & 31]($this, $call7, $call8, $call5 << 24 >> 24) | 0) & 65535) >>> 0);
  $7 = $npre_items + ($new_added_0_ph42 * 20 | 0) + 4 | 0;
  $8 = $call7 + ($conv << 1) | 0;
  _memcpy($7 | 0, $8 | 0, $sub25) | 0;
  if ($sub25 >>> 0 < 14) {
   HEAP16[$npre_items + ($new_added_0_ph42 * 20 | 0) + 4 + ($sub25 >>> 1 << 1) >> 1] = 0;
  }
  $inc40 = $new_added_0_ph42 + 1 | 0;
  $inc42 = $j_034 + 1 | 0;
  if (($inc42 | 0) > ($sub | 0)) {
   $retval_0 = $inc40;
   label = 3173;
   break;
  } else {
   $j_0_ph41 = $inc42;
   $new_added_0_ph42 = $inc40;
  }
 }
 if ((label | 0) == 3171) {
  return $retval_0 | 0;
 } else if ((label | 0) == 3173) {
  return $retval_0 | 0;
 } else if ((label | 0) == 3174) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict24locate_first_in_predictsEPKti($this, $words, $lemma_len) {
 $this = $this | 0;
 $words = $words | 0;
 $lemma_len = $lemma_len | 0;
 var $sub = 0, $1 = 0, $begin_0_ph51 = 0, $end_0_ph50 = 0, $last_matched_0_ph49 = 0, $begin_046 = 0, $last_matched_045 = 0, $shr = 0, $2 = 0, $call = 0, $call2 = 0, $conv = 0, $cmp3 = 0, $conv_lemma_len = 0, $k_0 = 0, $3 = 0, $4 = 0, $last_matched_0_shr = 0, $last_matched_228 = 0, $add37 = 0, $last_matched_231 = 0, $sub41 = 0, $last_matched_0_lcssa = 0, label = 0;
 $sub = (HEAP32[$this + 80 >> 2] | 0) - 1 | 0;
 if (($sub | 0) < 0) {
  $last_matched_0_lcssa = -1;
  return $last_matched_0_lcssa | 0;
 }
 $1 = HEAP32[$this + 28 >> 2] | 0;
 $last_matched_0_ph49 = -1;
 $end_0_ph50 = $sub;
 $begin_0_ph51 = 0;
 L4047 : while (1) {
  $last_matched_045 = $last_matched_0_ph49;
  $begin_046 = $begin_0_ph51;
  L4049 : while (1) {
   $shr = $begin_046 + $end_0_ph50 >> 1;
   $2 = HEAP32[$1 + ($shr << 2) >> 2] | 0;
   $call = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
   $call2 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0;
   $conv = $call & 255;
   $cmp3 = ($conv | 0) < ($lemma_len | 0);
   $conv_lemma_len = $cmp3 ? $conv : $lemma_len;
   $k_0 = 0;
   while (1) {
    if ($k_0 >>> 0 >= $conv_lemma_len >>> 0) {
     label = 3182;
     break;
    }
    $3 = HEAP16[$call2 + ($k_0 << 1) >> 1] | 0;
    $4 = HEAP16[$words + ($k_0 << 1) >> 1] | 0;
    if (($3 & 65535) < ($4 & 65535)) {
     $last_matched_228 = $last_matched_045;
     break;
    }
    if (($3 & 65535) > ($4 & 65535)) {
     $last_matched_231 = $last_matched_045;
     break L4049;
    } else {
     $k_0 = $k_0 + 1 | 0;
    }
   }
   if ((label | 0) == 3182) {
    label = 0;
    $last_matched_0_shr = $cmp3 ? $last_matched_045 : $shr;
    if ($cmp3) {
     $last_matched_228 = $last_matched_0_shr;
    } else {
     $last_matched_231 = $last_matched_0_shr;
     break;
    }
   }
   $add37 = $shr + 1 | 0;
   if (($add37 | 0) > ($end_0_ph50 | 0)) {
    $last_matched_0_lcssa = $last_matched_228;
    label = 3186;
    break L4047;
   } else {
    $last_matched_045 = $last_matched_228;
    $begin_046 = $add37;
   }
  }
  $sub41 = $shr - 1 | 0;
  if (($begin_046 | 0) > ($sub41 | 0)) {
   $last_matched_0_lcssa = $last_matched_231;
   label = 3188;
   break;
  } else {
   $last_matched_0_ph49 = $last_matched_231;
   $end_0_ph50 = $sub41;
   $begin_0_ph51 = $begin_046;
  }
 }
 if ((label | 0) == 3188) {
  return $last_matched_0_lcssa | 0;
 } else if ((label | 0) == 3186) {
  return $last_matched_0_lcssa | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, $lemma_str, $splid_str, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splid_str = $splid_str | 0;
 $lemma_len = $lemma_len | 0;
 var $searchable = 0, $start = 0, $count = 0, $0 = 0, $call = 0, $1 = 0, $call2 = 0, $off_0 = 0, $max_off_0 = 0, $offsets_ = 0, $conv19 = 0, $off_123 = 0, $4 = 0, $off_1_be = 0, $call9 = 0, $call18 = 0, $i_0 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 $searchable = sp | 0;
 $start = sp + 48 | 0;
 $count = sp + 56 | 0;
 $0 = HEAP32[$this + 80 >> 2] | 0;
 __ZN10ime_pinyin8UserDict14prepare_locateEPNS0_18UserDictSearchableEPKtt(0, $searchable, $splid_str, $lemma_len);
 $call = __ZN10ime_pinyin8UserDict10load_cacheEPNS0_18UserDictSearchableEPjS3_($this, $searchable, $start, $count) | 0;
 if ($call) {
  $1 = HEAP32[$start >> 2] | 0;
  $max_off_0 = (HEAP32[$count >> 2] | 0) + $1 | 0;
  $off_0 = $1;
 } else {
  $call2 = __ZN10ime_pinyin8UserDict23locate_first_in_offsetsEPKNS0_18UserDictSearchableE($this, $searchable) | 0;
  HEAP32[$start >> 2] = $call2;
  $max_off_0 = $0;
  $off_0 = $call2;
 }
 if (!(($off_0 | 0) != -1 & ($off_0 | 0) < ($max_off_0 | 0))) {
  $retval_0 = -1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $offsets_ = $this + 28 | 0;
 $conv19 = $lemma_len & 65535;
 $off_123 = $off_0;
 L4070 : while (1) {
  $4 = HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($off_123 << 2) >> 2] | 0;
  do {
   if (($4 | 0) >= 0) {
    $call9 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $4) | 0;
    if (!$call) {
     if ((__ZN10ime_pinyin8UserDict22fuzzy_compare_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call9, $lemma_len, $searchable) | 0) != 0) {
      $retval_0 = -1;
      label = 3204;
      break L4070;
     }
    }
    if (!(__ZN10ime_pinyin8UserDict14equal_spell_idEPKttPKNS0_18UserDictSearchableE(0, $call9, $lemma_len, $searchable) | 0)) {
     break;
    }
    $call18 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $4) | 0;
    $i_0 = 0;
    while (1) {
     if ($i_0 >>> 0 >= $conv19 >>> 0) {
      $retval_0 = $off_123;
      label = 3206;
      break L4070;
     }
     if ((HEAP16[$call18 + ($i_0 << 1) >> 1] | 0) == (HEAP16[$lemma_str + ($i_0 << 1) >> 1] | 0)) {
      $i_0 = $i_0 + 1 | 0;
     } else {
      break;
     }
    }
   }
  } while (0);
  $off_1_be = $off_123 + 1 | 0;
  if (($off_1_be | 0) < ($max_off_0 | 0)) {
   $off_123 = $off_1_be;
  } else {
   $retval_0 = -1;
   label = 3205;
   break;
  }
 }
 if ((label | 0) == 3204) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 3205) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 3206) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict34locate_where_to_insert_in_predictsEPKti($this, $words, $lemma_len) {
 $this = $this | 0;
 $words = $words | 0;
 $lemma_len = $lemma_len | 0;
 var $sub = 0, $1 = 0, $begin_0_ph50 = 0, $end_0_ph49 = 0, $last_matched_0_ph48 = 0, $begin_045 = 0, $last_matched_044 = 0, $shr = 0, $2 = 0, $call = 0, $call2 = 0, $conv = 0, $cmp3 = 0, $conv_lemma_len = 0, $k_0 = 0, $3 = 0, $4 = 0, $add33 = 0, $cmp5_130 = 0, $sub37 = 0, $last_matched_0_lcssa = 0, label = 0;
 $sub = (HEAP32[$this + 80 >> 2] | 0) - 1 | 0;
 if (($sub | 0) < 0) {
  $last_matched_0_lcssa = $sub;
  return $last_matched_0_lcssa | 0;
 }
 $1 = HEAP32[$this + 28 >> 2] | 0;
 $last_matched_0_ph48 = $sub;
 $end_0_ph49 = $sub;
 $begin_0_ph50 = 0;
 L4090 : while (1) {
  $last_matched_044 = $last_matched_0_ph48;
  $begin_045 = $begin_0_ph50;
  L4092 : while (1) {
   $shr = $begin_045 + $end_0_ph49 >> 1;
   $2 = HEAP32[$1 + ($shr << 2) >> 2] | 0;
   $call = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
   $call2 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0;
   $conv = $call & 255;
   $cmp3 = ($conv | 0) < ($lemma_len | 0);
   $conv_lemma_len = $cmp3 ? $conv : $lemma_len;
   $k_0 = 0;
   while (1) {
    if ($k_0 >>> 0 >= $conv_lemma_len >>> 0) {
     label = 3214;
     break;
    }
    $3 = HEAP16[$call2 + ($k_0 << 1) >> 1] | 0;
    $4 = HEAP16[$words + ($k_0 << 1) >> 1] | 0;
    if (($3 & 65535) < ($4 & 65535)) {
     break;
    }
    if (($3 & 65535) > ($4 & 65535)) {
     $cmp5_130 = $last_matched_044;
     break L4092;
    } else {
     $k_0 = $k_0 + 1 | 0;
    }
   }
   if ((label | 0) == 3214) {
    label = 0;
    if (!$cmp3) {
     label = 3215;
     break;
    }
   }
   $add33 = $shr + 1 | 0;
   if (($add33 | 0) > ($end_0_ph49 | 0)) {
    $last_matched_0_lcssa = $shr;
    label = 3219;
    break L4090;
   } else {
    $last_matched_044 = $shr;
    $begin_045 = $add33;
   }
  }
  if ((label | 0) == 3215) {
   label = 0;
   $cmp5_130 = ($conv | 0) > ($lemma_len | 0) ? $last_matched_044 : $shr;
  }
  $sub37 = $shr - 1 | 0;
  if (($begin_045 | 0) > ($sub37 | 0)) {
   $last_matched_0_lcssa = $cmp5_130;
   label = 3220;
   break;
  } else {
   $last_matched_0_ph48 = $cmp5_130;
   $end_0_ph49 = $sub37;
   $begin_0_ph50 = $begin_045;
  }
 }
 if ((label | 0) == 3219) {
  return $last_matched_0_lcssa | 0;
 } else if ((label | 0) == 3220) {
  return $last_matched_0_lcssa | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict12get_lemma_idEPtS1_t($this, $lemma_str, $splids, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 var $call = 0, $retval_0 = 0;
 $call = __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, $lemma_str, $splids, $lemma_len) | 0;
 if (($call | 0) == -1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP32[(HEAP32[$this + 36 >> 2] | 0) + ($call << 2) >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict15get_lemma_scoreEj($this, $lemma_id) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 var $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $lemma_id) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin8UserDict15translate_scoreEi($this, __ZN10ime_pinyin8UserDict16_get_lemma_scoreEj($this, $lemma_id) | 0) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict16_get_lemma_scoreEj($this, $lemma_id) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 var $2 = 0, $call7 = 0, $call9 = 0, $call12 = 0, $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $lemma_id) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $2 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($lemma_id - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
 $call7 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
 $call9 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $2) | 0;
 $call12 = __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0, $call9, $call7 << 24 >> 24) | 0;
 if (($call12 | 0) == -1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP32[(HEAP32[$this + 32 >> 2] | 0) + ($call12 << 2) >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict15get_lemma_scoreEPtS1_t($this, $lemma_str, $splids, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 var $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZN10ime_pinyin8UserDict15translate_scoreEi($this, __ZN10ime_pinyin8UserDict16_get_lemma_scoreEPtS1_t($this, $lemma_str, $splids, $lemma_len) | 0) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict16_get_lemma_scoreEPtS1_t($this, $lemma_str, $splids, $lemma_len) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 var $call2 = 0, $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call2 = __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, $lemma_str, $splids, $lemma_len) | 0;
 if (($call2 | 0) == -1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP32[(HEAP32[$this + 32 >> 2] | 0) + ($call2 << 2) >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict28remove_lemma_by_offset_indexEi($this, $offset_index) {
 $this = $this | 0;
 $offset_index = $offset_index | 0;
 var $arrayidx = 0, $1 = 0, $conv6 = 0, $free_count = 0, $free_size = 0, $state_ = 0, $retval_0 = 0;
 if (($offset_index | 0) == -1 | (__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0) ^ 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $arrayidx = (HEAP32[$this + 28 >> 2] | 0) + ($offset_index << 2) | 0;
 $1 = HEAP32[$arrayidx >> 2] | 0;
 $conv6 = (__ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $1) | 0) << 24 >> 24;
 HEAP32[$arrayidx >> 2] = $1 | -2147483648;
 __ZN10ime_pinyin8UserDict27remove_lemma_from_sync_listEj($this, $1);
 __ZN10ime_pinyin8UserDict30remove_lemma_from_predict_listEj($this, $1);
 $free_count = $this + 88 | 0;
 HEAP32[$free_count >> 2] = (HEAP32[$free_count >> 2] | 0) + 1;
 $free_size = $this + 92 | 0;
 HEAP32[$free_size >> 2] = (HEAP32[$free_size >> 2] | 0) + ($conv6 << 2 | 2);
 $state_ = $this + 104 | 0;
 if ((HEAP32[$state_ >> 2] | 0) >= 4) {
  $retval_0 = 1;
  return $retval_0 | 0;
 }
 HEAP32[$state_ >> 2] = 4;
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict12remove_lemmaEj($this, $lemma_id) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 var $2 = 0, $call7 = 0, $call9 = 0, $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $lemma_id) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $2 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($lemma_id - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
 $call7 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
 $call9 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $2) | 0;
 $retval_0 = __ZN10ime_pinyin8UserDict28remove_lemma_by_offset_indexEi($this, __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0, $call9, $call7 << 24 >> 24) | 0) | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict11flush_cacheEv($this) {
 $this = $this | 0;
 var $0 = 0, $call = 0;
 $0 = HEAP32[$this + 16 >> 2] | 0;
 $call = _strdup(HEAP32[$this + 64 >> 2] | 0) | 0;
 if (($call | 0) == 0) {
  return;
 }
 FUNCTION_TABLE_ii[HEAP32[(HEAP32[$this >> 2] | 0) + 12 >> 2] & 31]($this) | 0;
 FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[$this >> 2] | 0) + 8 >> 2] & 31]($this, $call, $0, 6e5) | 0;
 _free($call);
 __ZN10ime_pinyin8UserDict10cache_initEv($this);
 return;
}
function __ZN10ime_pinyin8UserDict14write_back_allEi($this, $fd) {
 $this = $this | 0;
 $fd = $fd | 0;
 var $lemma_count = 0;
 if ((_lseek($fd | 0, 4, 0) | 0) == -1) {
  return;
 }
 _write($fd | 0, HEAP32[$this + 24 >> 2] | 0, HEAP32[$this + 84 >> 2] | 0) | 0;
 $lemma_count = $this + 80 | 0;
 _write($fd | 0, HEAP32[$this + 28 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 40 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 32 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 44 >> 2] | 0, HEAP32[$this + 96 >> 2] << 2 | 0) | 0;
 _write($fd | 0, $this + 68 | 0, 36) | 0;
 return;
}
function __ZN10ime_pinyin8UserDict16write_back_lemmaEi($this, $fd) {
 $this = $this | 0;
 $fd = $fd | 0;
 var $sub = 0, $lemma_size = 0, $lemma_count = 0;
 if ((_lseek($fd | 0, 4, 0) | 0) == -1) {
  return;
 }
 $sub = 1088 - (HEAP32[$this + 60 >> 2] | 0) | 0;
 $lemma_size = $this + 84 | 0;
 if ((_lseek($fd | 0, (HEAP32[$lemma_size >> 2] | 0) - $sub | 0, 1) | 0) == -1) {
  return;
 }
 _write($fd | 0, (HEAP32[$this + 24 >> 2] | 0) + ((HEAP32[$lemma_size >> 2] | 0) - $sub) | 0, $sub | 0) | 0;
 $lemma_count = $this + 80 | 0;
 _write($fd | 0, HEAP32[$this + 28 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 40 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 32 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 44 >> 2] | 0, HEAP32[$this + 96 >> 2] << 2 | 0) | 0;
 _write($fd | 0, $this + 68 | 0, 36) | 0;
 return;
}
function __ZN10ime_pinyin8UserDict10save_cacheEPNS0_18UserDictSearchableEjj($this, $searchable, $offset, $length) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 $offset = $offset | 0;
 $length = $length | 0;
 var $sub = 0, $tail = 0, $1 = 0, $idxprom = 0, $inc13 = 0, $sub17_inc13 = 0, $head = 0, $4 = 0, $inc24 = 0;
 $sub = (HEAPU16[$searchable >> 1] | 0) - 1 | 0;
 $tail = $this + 588 + ($sub * 68 | 0) + 66 | 0;
 $1 = HEAP16[$tail >> 1] | 0;
 $idxprom = $1 & 65535;
 HEAP32[$this + 588 + ($sub * 68 | 0) + 32 + ($idxprom << 2) >> 2] = $offset;
 HEAP32[$this + 588 + ($sub * 68 | 0) + 48 + ($idxprom << 2) >> 2] = $length;
 HEAP32[$this + 588 + ($sub * 68 | 0) + ($idxprom << 3) >> 2] = HEAP32[$searchable + 36 >> 2];
 HEAP32[$this + 588 + ($sub * 68 | 0) + ($idxprom << 3) + 4 >> 2] = HEAP32[$searchable + 40 >> 2];
 $inc13 = $1 + 1 & 65535;
 $sub17_inc13 = ($inc13 & 65535) > 3 ? $1 - 3 & 65535 : $inc13;
 $head = $this + 588 + ($sub * 68 | 0) + 64 | 0;
 $4 = HEAP16[$head >> 1] | 0;
 if ($sub17_inc13 << 16 >> 16 != $4 << 16 >> 16) {
  HEAP16[$tail >> 1] = $sub17_inc13;
  return;
 }
 $inc24 = $4 + 1 & 65535;
 HEAP16[$head >> 1] = $inc24;
 if (($inc24 & 65535) <= 3) {
  HEAP16[$tail >> 1] = $sub17_inc13;
  return;
 }
 HEAP16[$head >> 1] = $4 - 3 & 65535;
 HEAP16[$tail >> 1] = $sub17_inc13;
 return;
}
function __ZN10ime_pinyin8UserDict15load_miss_cacheEPNS0_18UserDictSearchableE($this, $searchable) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 var $sub = 0, $1 = 0, $tail = 0, $i_0 = 0, $idxprom8 = 0, $j_0 = 0, $conv5 = 0, $inc20 = 0, $sub25_inc20 = 0, $retval_0 = 0, label = 0;
 $sub = (HEAPU16[$searchable >> 1] | 0) - 1 | 0;
 $1 = HEAP16[$this + 108 + ($sub * 60 | 0) + 56 >> 1] | 0;
 $tail = $this + 108 + ($sub * 60 | 0) + 58 | 0;
 if ($1 << 16 >> 16 == (HEAP16[$tail >> 1] | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 } else {
  $i_0 = $1;
 }
 L4189 : while (1) {
  $idxprom8 = $i_0 & 65535;
  $j_0 = 0;
  while (1) {
   $conv5 = $j_0 & 65535;
   if (($j_0 & 65535) >= 2) {
    $retval_0 = 1;
    label = 3300;
    break L4189;
   }
   if ((HEAP32[$this + 108 + ($sub * 60 | 0) + ($idxprom8 << 3) + ($conv5 << 2) >> 2] | 0) == (HEAP32[$searchable + 36 + ($conv5 << 2) >> 2] | 0)) {
    $j_0 = $j_0 + 1 & 65535;
   } else {
    break;
   }
  }
  $inc20 = $i_0 + 1 & 65535;
  $sub25_inc20 = ($inc20 & 65535) > 6 ? $i_0 - 6 & 65535 : $inc20;
  if ($sub25_inc20 << 16 >> 16 == (HEAP16[$tail >> 1] | 0)) {
   $retval_0 = 0;
   label = 3299;
   break;
  } else {
   $i_0 = $sub25_inc20;
  }
 }
 if ((label | 0) == 3300) {
  return $retval_0 | 0;
 } else if ((label | 0) == 3299) {
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict15save_miss_cacheEPNS0_18UserDictSearchableE($this, $searchable) {
 $this = $this | 0;
 $searchable = $searchable | 0;
 var $sub = 0, $tail = 0, $1 = 0, $idxprom6 = 0, $inc9 = 0, $sub13_inc9 = 0, $head = 0, $4 = 0, $inc20 = 0;
 $sub = (HEAPU16[$searchable >> 1] | 0) - 1 | 0;
 $tail = $this + 108 + ($sub * 60 | 0) + 58 | 0;
 $1 = HEAP16[$tail >> 1] | 0;
 $idxprom6 = $1 & 65535;
 HEAP32[$this + 108 + ($sub * 60 | 0) + ($idxprom6 << 3) >> 2] = HEAP32[$searchable + 36 >> 2];
 HEAP32[$this + 108 + ($sub * 60 | 0) + ($idxprom6 << 3) + 4 >> 2] = HEAP32[$searchable + 40 >> 2];
 $inc9 = $1 + 1 & 65535;
 $sub13_inc9 = ($inc9 & 65535) > 6 ? $1 - 6 & 65535 : $inc9;
 $head = $this + 108 + ($sub * 60 | 0) + 56 | 0;
 $4 = HEAP16[$head >> 1] | 0;
 if ($sub13_inc9 << 16 >> 16 != $4 << 16 >> 16) {
  HEAP16[$tail >> 1] = $sub13_inc9;
  return;
 }
 $inc20 = $4 + 1 & 65535;
 HEAP16[$head >> 1] = $inc20;
 if (($inc20 & 65535) <= 6) {
  HEAP16[$tail >> 1] = $sub13_inc9;
  return;
 }
 HEAP16[$head >> 1] = $4 - 6 & 65535;
 HEAP16[$tail >> 1] = $sub13_inc9;
 return;
}
function __ZN10ime_pinyin8UserDict14set_lemma_flagEjh($this, $offset, $flag) {
 $this = $this | 0;
 $offset = $offset | 0;
 $flag = $flag | 0;
 var $arrayidx = 0;
 $arrayidx = (HEAP32[$this + 24 >> 2] | 0) + ($offset & 2147483647) | 0;
 HEAP8[$arrayidx] = HEAP8[$arrayidx] | $flag;
 return;
}
function __ZN10ime_pinyin8UserDict14get_lemma_flagEj($this, $offset) {
 $this = $this | 0;
 $offset = $offset | 0;
 return HEAP8[(HEAP32[$this + 24 >> 2] | 0) + ($offset & 2147483647) | 0] | 0;
}
function __ZN10ime_pinyin8UserDict17write_back_offsetEi($this, $fd) {
 $this = $this | 0;
 $fd = $fd | 0;
 var $lemma_count = 0;
 if ((_lseek($fd | 0, (HEAP32[$this + 84 >> 2] | 0) + 4 | 0, 0) | 0) == -1) {
  return;
 }
 $lemma_count = $this + 80 | 0;
 _write($fd | 0, HEAP32[$this + 28 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 40 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 32 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 44 >> 2] | 0, HEAP32[$this + 96 >> 2] << 2 | 0) | 0;
 _write($fd | 0, $this + 68 | 0, 36) | 0;
 return;
}
function __ZN10ime_pinyin8UserDict16write_back_scoreEi($this, $fd) {
 $this = $this | 0;
 $fd = $fd | 0;
 var $lemma_count = 0;
 $lemma_count = $this + 80 | 0;
 if ((_lseek($fd | 0, (HEAP32[$this + 84 >> 2] | 0) + 4 + (HEAP32[$lemma_count >> 2] << 3) | 0, 0) | 0) == -1) {
  return;
 }
 _write($fd | 0, HEAP32[$this + 32 >> 2] | 0, HEAP32[$lemma_count >> 2] << 2 | 0) | 0;
 _write($fd | 0, HEAP32[$this + 44 >> 2] | 0, HEAP32[$this + 96 >> 2] << 2 | 0) | 0;
 _write($fd | 0, $this + 68 | 0, 36) | 0;
 return;
}
function __ZN10ime_pinyin8UserDict15write_back_syncEi($this, $fd) {
 $this = $this | 0;
 $fd = $fd | 0;
 if ((_lseek($fd | 0, (HEAP32[$this + 84 >> 2] | 0) + 4 + ((HEAP32[$this + 80 >> 2] | 0) * 12 | 0) | 0, 0) | 0) == -1) {
  return;
 }
 _write($fd | 0, HEAP32[$this + 44 >> 2] | 0, HEAP32[$this + 96 >> 2] << 2 | 0) | 0;
 _write($fd | 0, $this + 68 | 0, 36) | 0;
 return;
}
function __ZN10ime_pinyin8UserDict11reset_cacheEv($this) {
 $this = $this | 0;
 _memset($this + 588 | 0, 0, 544);
 return;
}
function __ZN10ime_pinyin8UserDict16reset_miss_cacheEv($this) {
 $this = $this | 0;
 _memset($this + 108 | 0, 0, 480);
 return;
}
function __ZN10ime_pinyin8UserDict10defragmentEv($this) {
 $this = $this | 0;
 var $lemma_count = 0, $offsets_ = 0, $scores_ = 0, $ids_ = 0, $first_freed_0142 = 0, $1 = 0, $2 = 0, $predicts_ = 0, $first_freed_1 = 0, $5 = 0, $add = 0, $9 = 0, $10 = 0, $first_inuse_0136 = 0, $inc29 = 0, $13 = 0, $first_inuse_0_lcssa = 0, $14 = 0, $15 = 0, $arrayidx37 = 0, $16 = 0, $19 = 0, $arrayidx44 = 0, $20 = 0, $23 = 0, $arrayidx52 = 0, $24 = 0, $27 = 0, $first_freed_2132 = 0, $28 = 0, $first_freed_3 = 0, $add83 = 0, $32 = 0, $first_inuse_1 = 0, $36 = 0, $arrayidx105 = 0, $37 = 0, $first_freed_4 = 0, $lemma_size = 0, $41 = 0, $lemma_size_left_ = 0, $add121 = 0, $lemma_count_left_ = 0, $add125 = 0, $dst_0130 = 0, $lemmas_ = 0, $sync_count = 0, $syncs_ = 0, $offsets_201 = 0, $ids_214 = 0, $start_id_ = 0, $offsets_by_id_ = 0, $predicts_219 = 0, $add141 = 0, $end_0126 = 0, $dst_1125 = 0, $add154 = 0, $add154_pn = 0, $call160 = 0, $mul174 = 0, $add171 = 0, $add176 = 0, $end_1114 = 0, $add191 = 0, $end_1_lcssa = 0, $44 = 0, $sub196 = 0, $sub20898 = 0, $sub22797 = 0, $j_0116 = 0, $arrayidx202 = 0, $47 = 0, $arrayidx220 = 0, $55 = 0, $sub24696 = 0, $j234_0118 = 0, $arrayidx239 = 0, $59 = 0, $add255 = 0, $dst_1122 = 0, $start_id_275 = 0, $ids_277 = 0, $offsets_279 = 0, $offsets_by_id_281 = 0, $i_0106 = 0, label = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  return;
 }
 $lemma_count = $this + 80 | 0;
 L4229 : do {
  if ((HEAP32[$lemma_count >> 2] | 0) == 0) {
   $first_freed_4 = 0;
  } else {
   $offsets_ = $this + 28 | 0;
   $scores_ = $this + 32 | 0;
   $ids_ = $this + 36 | 0;
   $first_freed_0142 = 0;
   while (1) {
    $1 = HEAP32[$offsets_ >> 2] | 0;
    $first_freed_1 = $first_freed_0142;
    while (1) {
     if ((HEAP32[$1 + ($first_freed_1 << 2) >> 2] | 0) <= -1) {
      break;
     }
     if ($first_freed_1 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
      $first_freed_1 = $first_freed_1 + 1 | 0;
     } else {
      break;
     }
    }
    $5 = HEAP32[$lemma_count >> 2] | 0;
    if ($first_freed_1 >>> 0 >= $5 >>> 0) {
     $2 = $5;
     break;
    }
    __ZN10ime_pinyin8UserDict14set_lemma_flagEjh($this, HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($first_freed_1 << 2) >> 2] | 0, 1);
    $add = $first_freed_1 + 1 | 0;
    $9 = HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($add << 2) >> 2] | 0;
    L4238 : do {
     if (($9 | 0) < 0) {
      $first_inuse_0136 = $add;
      $10 = $9;
      while (1) {
       if ($first_inuse_0136 >>> 0 >= (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
        $first_inuse_0_lcssa = $first_inuse_0136;
        break L4238;
       }
       __ZN10ime_pinyin8UserDict14set_lemma_flagEjh($this, $10, 1);
       $inc29 = $first_inuse_0136 + 1 | 0;
       $13 = HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($inc29 << 2) >> 2] | 0;
       if (($13 | 0) < 0) {
        $first_inuse_0136 = $inc29;
        $10 = $13;
       } else {
        $first_inuse_0_lcssa = $inc29;
        break;
       }
      }
     } else {
      $first_inuse_0_lcssa = $add;
     }
    } while (0);
    $14 = HEAP32[$lemma_count >> 2] | 0;
    if ($first_inuse_0_lcssa >>> 0 >= $14 >>> 0) {
     $2 = $14;
     break;
    }
    $15 = HEAP32[$offsets_ >> 2] | 0;
    $arrayidx37 = $15 + ($first_inuse_0_lcssa << 2) | 0;
    $16 = HEAP32[$arrayidx37 >> 2] | 0;
    HEAP32[$arrayidx37 >> 2] = HEAP32[$15 + ($first_freed_1 << 2) >> 2];
    HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($first_freed_1 << 2) >> 2] = $16;
    $19 = HEAP32[$scores_ >> 2] | 0;
    $arrayidx44 = $19 + ($first_inuse_0_lcssa << 2) | 0;
    $20 = HEAP32[$arrayidx44 >> 2] | 0;
    HEAP32[$arrayidx44 >> 2] = HEAP32[$19 + ($first_freed_1 << 2) >> 2];
    HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($first_freed_1 << 2) >> 2] = $20;
    $23 = HEAP32[$ids_ >> 2] | 0;
    $arrayidx52 = $23 + ($first_inuse_0_lcssa << 2) | 0;
    $24 = HEAP32[$arrayidx52 >> 2] | 0;
    HEAP32[$arrayidx52 >> 2] = HEAP32[$23 + ($first_freed_1 << 2) >> 2];
    HEAP32[(HEAP32[$ids_ >> 2] | 0) + ($first_freed_1 << 2) >> 2] = $24;
    $27 = HEAP32[$lemma_count >> 2] | 0;
    if ($add >>> 0 < $27 >>> 0) {
     $first_freed_0142 = $add;
    } else {
     $2 = $27;
     break;
    }
   }
   if (($2 | 0) == 0) {
    $first_freed_4 = 0;
    break;
   }
   $predicts_ = $this + 40 | 0;
   $first_freed_2132 = 0;
   while (1) {
    $28 = HEAP32[$predicts_ >> 2] | 0;
    $first_freed_3 = $first_freed_2132;
    while (1) {
     if ((HEAP32[$28 + ($first_freed_3 << 2) >> 2] | 0) <= -1) {
      break;
     }
     if ($first_freed_3 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
      $first_freed_3 = $first_freed_3 + 1 | 0;
     } else {
      break;
     }
    }
    if ($first_freed_3 >>> 0 >= (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
     $first_freed_4 = $first_freed_3;
     break L4229;
    }
    $add83 = $first_freed_3 + 1 | 0;
    $32 = HEAP32[$predicts_ >> 2] | 0;
    $first_inuse_1 = $add83;
    while (1) {
     if ((HEAP32[$32 + ($first_inuse_1 << 2) >> 2] | 0) >= 0) {
      break;
     }
     if ($first_inuse_1 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
      $first_inuse_1 = $first_inuse_1 + 1 | 0;
     } else {
      break;
     }
    }
    if ($first_inuse_1 >>> 0 >= (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
     $first_freed_4 = $first_freed_3;
     break L4229;
    }
    $36 = HEAP32[$predicts_ >> 2] | 0;
    $arrayidx105 = $36 + ($first_inuse_1 << 2) | 0;
    $37 = HEAP32[$arrayidx105 >> 2] | 0;
    HEAP32[$arrayidx105 >> 2] = HEAP32[$36 + ($first_freed_3 << 2) >> 2];
    HEAP32[(HEAP32[$predicts_ >> 2] | 0) + ($first_freed_3 << 2) >> 2] = $37;
    if ($add83 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
     $first_freed_2132 = $add83;
    } else {
     $first_freed_4 = $add83;
     break;
    }
   }
  }
 } while (0);
 HEAP32[$lemma_count >> 2] = $first_freed_4;
 $lemma_size = $this + 84 | 0;
 $41 = HEAP32[$lemma_size >> 2] | 0;
 $lemma_size_left_ = $this + 60 | 0;
 $add121 = (HEAP32[$lemma_size_left_ >> 2] | 0) + $41 | 0;
 $lemma_count_left_ = $this + 56 | 0;
 $add125 = (HEAP32[$lemma_count_left_ >> 2] | 0) + $first_freed_4 | 0;
 if (($41 | 0) == 0) {
  return;
 } else {
  $dst_0130 = 0;
 }
 while (1) {
  if (((__ZN10ime_pinyin8UserDict14get_lemma_flagEj($this, $dst_0130) | 0) & 1) != 0) {
   break;
  }
  $add141 = (((__ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $dst_0130) | 0) & 255) << 2 | 2) + $dst_0130 | 0;
  if ($add141 >>> 0 < $41 >>> 0) {
   $dst_0130 = $add141;
  } else {
   label = 3380;
   break;
  }
 }
 if ((label | 0) == 3380) {
  return;
 }
 L4267 : do {
  if ($dst_0130 >>> 0 < $41 >>> 0) {
   $lemmas_ = $this + 24 | 0;
   $sync_count = $this + 96 | 0;
   $syncs_ = $this + 44 | 0;
   $offsets_201 = $this + 28 | 0;
   $ids_214 = $this + 36 | 0;
   $start_id_ = $this + 16 | 0;
   $offsets_by_id_ = $this + 52 | 0;
   $predicts_219 = $this + 40 | 0;
   $dst_1125 = $dst_0130;
   $end_0126 = $dst_0130;
   while (1) {
    $add154 = $end_0126 + 2 + ((__ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $end_0126) | 0) << 24 >> 24 << 2) | 0;
    if ($add154 >>> 0 < $41 >>> 0) {
     $add154_pn = $add154;
    } else {
     $dst_1122 = $dst_1125;
     break L4267;
    }
    while (1) {
     $call160 = __ZN10ime_pinyin8UserDict14get_lemma_flagEj($this, $add154_pn) | 0;
     $mul174 = ((__ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $add154_pn) | 0) & 255) << 2;
     if (($call160 & 1) == 0) {
      break;
     }
     $add171 = ($mul174 | 2) + $add154_pn | 0;
     if ($add171 >>> 0 < $41 >>> 0) {
      $add154_pn = $add171;
     } else {
      $dst_1122 = $dst_1125;
      break L4267;
     }
    }
    $add176 = $add154_pn + 2 + $mul174 | 0;
    L4275 : do {
     if ($add176 >>> 0 < $41 >>> 0) {
      $end_1114 = $add176;
      while (1) {
       if (((__ZN10ime_pinyin8UserDict14get_lemma_flagEj($this, $end_1114) | 0) & 1) != 0) {
        $end_1_lcssa = $end_1114;
        break L4275;
       }
       $add191 = (((__ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $end_1114) | 0) & 255) << 2 | 2) + $end_1114 | 0;
       if ($add191 >>> 0 < $41 >>> 0) {
        $end_1114 = $add191;
       } else {
        $end_1_lcssa = $add191;
        break;
       }
      }
     } else {
      $end_1_lcssa = $add176;
     }
    } while (0);
    $44 = HEAP32[$lemmas_ >> 2] | 0;
    $sub196 = $end_1_lcssa - $add154_pn | 0;
    _memmove($44 + $dst_1125 | 0, $44 + $add154_pn | 0, $sub196 | 0);
    if ((HEAP32[$lemma_count >> 2] | 0) != 0) {
     $sub20898 = $dst_1125 - $add154_pn | 0;
     $sub22797 = $dst_1125 - $add154_pn | 0;
     $j_0116 = 0;
     do {
      $arrayidx202 = (HEAP32[$offsets_201 >> 2] | 0) + ($j_0116 << 2) | 0;
      $47 = HEAP32[$arrayidx202 >> 2] | 0;
      if ($47 >>> 0 >= $add154_pn >>> 0 & $47 >>> 0 < $end_1_lcssa >>> 0) {
       HEAP32[$arrayidx202 >> 2] = $sub20898 + $47;
       HEAP32[(HEAP32[$offsets_by_id_ >> 2] | 0) + ((HEAP32[(HEAP32[$ids_214 >> 2] | 0) + ($j_0116 << 2) >> 2] | 0) - (HEAP32[$start_id_ >> 2] | 0) << 2) >> 2] = HEAP32[(HEAP32[$offsets_201 >> 2] | 0) + ($j_0116 << 2) >> 2];
      }
      $arrayidx220 = (HEAP32[$predicts_219 >> 2] | 0) + ($j_0116 << 2) | 0;
      $55 = HEAP32[$arrayidx220 >> 2] | 0;
      if ($55 >>> 0 >= $add154_pn >>> 0 & $55 >>> 0 < $end_1_lcssa >>> 0) {
       HEAP32[$arrayidx220 >> 2] = $sub22797 + $55;
      }
      $j_0116 = $j_0116 + 1 | 0;
     } while ($j_0116 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0);
    }
    if ((HEAP32[$sync_count >> 2] | 0) != 0) {
     $sub24696 = $dst_1125 - $add154_pn | 0;
     $j234_0118 = 0;
     do {
      $arrayidx239 = (HEAP32[$syncs_ >> 2] | 0) + ($j234_0118 << 2) | 0;
      $59 = HEAP32[$arrayidx239 >> 2] | 0;
      if ($59 >>> 0 >= $add154_pn >>> 0 & $59 >>> 0 < $end_1_lcssa >>> 0) {
       HEAP32[$arrayidx239 >> 2] = $sub24696 + $59;
      }
      $j234_0118 = $j234_0118 + 1 | 0;
     } while ($j234_0118 >>> 0 < (HEAP32[$sync_count >> 2] | 0) >>> 0);
    }
    $add255 = $sub196 + $dst_1125 | 0;
    if ($end_1_lcssa >>> 0 < $41 >>> 0) {
     $dst_1125 = $add255;
     $end_0126 = $end_1_lcssa;
    } else {
     $dst_1122 = $add255;
     break;
    }
   }
  } else {
   $dst_1122 = $dst_0130;
  }
 } while (0);
 HEAP32[$this + 88 >> 2] = 0;
 HEAP32[$this + 92 >> 2] = 0;
 HEAP32[$lemma_size >> 2] = $dst_1122;
 HEAP32[$lemma_size_left_ >> 2] = $add121 - $dst_1122;
 HEAP32[$lemma_count_left_ >> 2] = $add125 - (HEAP32[$lemma_count >> 2] | 0);
 if ((HEAP32[$lemma_count >> 2] | 0) != 0) {
  $start_id_275 = $this + 16 | 0;
  $ids_277 = $this + 36 | 0;
  $offsets_279 = $this + 28 | 0;
  $offsets_by_id_281 = $this + 52 | 0;
  $i_0106 = 0;
  do {
   HEAP32[(HEAP32[$ids_277 >> 2] | 0) + ($i_0106 << 2) >> 2] = (HEAP32[$start_id_275 >> 2] | 0) + $i_0106;
   HEAP32[(HEAP32[$offsets_by_id_281 >> 2] | 0) + ($i_0106 << 2) >> 2] = HEAP32[(HEAP32[$offsets_279 >> 2] | 0) + ($i_0106 << 2) >> 2];
   $i_0106 = $i_0106 + 1 | 0;
  } while ($i_0106 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0);
 }
 HEAP32[$this + 104 >> 2] = 6;
 return;
}
function __ZN10ime_pinyin8UserDict17clear_sync_lemmasEjj($this, $start, $end) {
 $this = $this | 0;
 $start = $start | 0;
 $end = $end | 0;
 var $sync_count = 0, $0 = 0, $_end = 0, $1 = 0, $state_ = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  return;
 }
 $sync_count = $this + 96 | 0;
 $0 = HEAP32[$sync_count >> 2] | 0;
 $_end = $0 >>> 0 < $end >>> 0 ? $0 : $end;
 $1 = HEAP32[$this + 44 >> 2] | 0;
 _memmove($1 + ($start << 2) | 0, $1 + ($_end << 2) | 0, $0 - $_end << 2 | 0);
 HEAP32[$sync_count >> 2] = $start - $_end + (HEAP32[$sync_count >> 2] | 0);
 $state_ = $this + 104 | 0;
 if ((HEAP32[$state_ >> 2] | 0) >= 2) {
  return;
 }
 HEAP32[$state_ >> 2] = 2;
 return;
}
function __ZN10ime_pinyin8UserDict14get_sync_countEv($this) {
 $this = $this | 0;
 var $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = HEAP32[$this + 96 >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict17put_lemma_no_syncEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $lmt$0, $lmt$1) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 $count = $count | 0;
 $lmt$0 = $lmt$0 | 0;
 $lmt$1 = $lmt$1 | 0;
 var $lemma_size = 0, $syncs_ = 0, $0 = 0, $call4 = 0, $limit_lemma_size = 0, $add3 = 0, $1 = 0, $2 = 0, $4 = 0, $7 = 0, $call = 0, $call_lcssa = 0, label = 0;
 $lemma_size = $this + 84 | 0;
 $syncs_ = $this + 44 | 0;
 $0 = HEAP32[$syncs_ >> 2] | 0;
 HEAP32[$syncs_ >> 2] = 0;
 $call4 = __ZN10ime_pinyin8UserDict10_put_lemmaEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $lmt$0, $lmt$1) | 0;
 HEAP32[$syncs_ >> 2] = $0;
 if (($call4 | 0) != 0) {
  $call_lcssa = $call4;
  return $call_lcssa | 0;
 }
 $limit_lemma_size = $this + 76 | 0;
 $add3 = ($lemma_len & 65535) << 2 | 2;
 $1 = $this;
 $2 = HEAP32[$this + 72 >> 2] | 0;
 if (($2 | 0) == 0) {
  label = 3399;
 } else {
  if ((HEAP32[$this + 80 >> 2] | 0) >>> 0 < $2 >>> 0) {
   label = 3399;
  }
 }
 do {
  if ((label | 0) == 3399) {
   $4 = HEAP32[$limit_lemma_size >> 2] | 0;
   if (($4 | 0) == 0) {
    $call_lcssa = $call4;
    return $call_lcssa | 0;
   }
   if (((HEAP32[$lemma_size >> 2] | 0) + $add3 | 0) >>> 0 > $4 >>> 0) {
    break;
   } else {
    $call_lcssa = $call4;
   }
   return $call_lcssa | 0;
  }
 } while (0);
 __ZN10ime_pinyin8UserDict7reclaimEv($this);
 __ZN10ime_pinyin8UserDict10defragmentEv($this);
 FUNCTION_TABLE_vi[HEAP32[(HEAP32[$1 >> 2] | 0) + 76 >> 2] & 127]($this);
 $7 = HEAP32[$syncs_ >> 2] | 0;
 HEAP32[$syncs_ >> 2] = 0;
 $call = __ZN10ime_pinyin8UserDict10_put_lemmaEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $lmt$0, $lmt$1) | 0;
 HEAP32[$syncs_ >> 2] = $7;
 $call_lcssa = $call;
 return $call_lcssa | 0;
}
function __ZN10ime_pinyin8UserDict10_put_lemmaEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $lmt$0, $lmt$1) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 $count = $count | 0;
 $lmt$0 = $lmt$0 | 0;
 $lmt$1 = $lmt$1 | 0;
 var $call2 = 0, $conv5 = 0, $scores_ = 0, $total_nfreq = 0, $call7 = 0, $state_ = 0, $7 = 0, $9 = 0, $call41 = 0, $retval_0 = 0, label = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call2 = __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, $lemma_str, $splids, $lemma_len) | 0;
 if (($call2 | 0) != -1) {
  $conv5 = $count & 65535;
  $scores_ = $this + 32 | 0;
  $total_nfreq = $this + 100 | 0;
  HEAP32[$total_nfreq >> 2] = $conv5 - (HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($call2 << 2) >> 2] | 0) + (HEAP32[$total_nfreq >> 2] | 0);
  $call7 = __ZN10ime_pinyin8UserDict11build_scoreEyi(0, $lmt$0, $lmt$1, $conv5) | 0;
  HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($call2 << 2) >> 2] = $call7;
  $state_ = $this + 104 | 0;
  if ((HEAP32[$state_ >> 2] | 0) < 3) {
   HEAP32[$state_ >> 2] = 3;
  }
  $retval_0 = HEAP32[(HEAP32[$this + 36 >> 2] | 0) + ($call2 << 2) >> 2] | 0;
  return $retval_0 | 0;
 }
 $7 = HEAP32[$this + 72 >> 2] | 0;
 do {
  if (($7 | 0) != 0) {
   if ((HEAP32[$this + 80 >> 2] | 0) >>> 0 < $7 >>> 0) {
    break;
   } else {
    $retval_0 = 0;
   }
   return $retval_0 | 0;
  }
 } while (0);
 $9 = HEAP32[$this + 76 >> 2] | 0;
 do {
  if (($9 | 0) != 0) {
   if (((HEAP32[$this + 84 >> 2] | 0) + (($lemma_len & 65535) << 2 | 2) | 0) >>> 0 > $9 >>> 0) {
    $retval_0 = 0;
   } else {
    break;
   }
   return $retval_0 | 0;
  }
 } while (0);
 if ((HEAP32[$this + 56 >> 2] | 0) == 0) {
  label = 3418;
 } else {
  if ((HEAP32[$this + 60 >> 2] | 0) >>> 0 < (($lemma_len & 65535) << 2 | 2) >>> 0) {
   label = 3418;
  }
 }
 if ((label | 0) == 3418) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[$this >> 2] | 0) + 76 >> 2] & 127]($this);
 }
 $call41 = __ZN10ime_pinyin8UserDict14append_a_lemmaEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $lmt$0, $lmt$1) | 0;
 if ((HEAP32[$this + 44 >> 2] | 0) == 0 | ($call41 | 0) == 0) {
  $retval_0 = $call41;
  return $retval_0 | 0;
 }
 __ZN10ime_pinyin8UserDict20queue_lemma_for_syncEj($this, $call41);
 $retval_0 = $call41;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict18extract_score_freqEi($this, $raw_score) {
 $this = $this | 0;
 $raw_score = $raw_score | 0;
 return $raw_score & 65535 | 0;
}
function __ZN10ime_pinyin8UserDict17extract_score_lmtEi($this, $raw_score) {
 $this = $this | 0;
 $raw_score = $raw_score | 0;
 var $mul$0 = 0, $add$0 = 0;
 $mul$0 = ___muldi3($raw_score >>> 16, 0, 604800, 0) | 0;
 $add$0 = _i64Add($mul$0, tempRet0, 1229904e3, 0) | 0;
 return (tempRet0 = tempRet0, $add$0) | 0;
}
function __ZN10ime_pinyin8UserDict11build_scoreEyi($this, $lmt$0, $lmt$1, $freq) {
 $this = $this | 0;
 $lmt$0 = $lmt$0 | 0;
 $lmt$1 = $lmt$1 | 0;
 $freq = $freq | 0;
 var $sub$0 = 0, $div$0 = 0;
 $sub$0 = _i64Add($lmt$0, $lmt$1, -1229904e3, -1) | 0;
 $div$0 = ___udivdi3($sub$0, tempRet0, 604800, 0) | 0;
 return $div$0 << 16 | $freq & 65535 | 0;
}
function __ZN10ime_pinyin8UserDict13utf16le_atollEPti($this, $s, $len) {
 $this = $this | 0;
 $s = $s | 0;
 $len = $len | 0;
 var $add_ptr = 0, $0 = 0, $s_addr_0_ph = 0, $flag_0_ph$0 = 0, $flag_0_ph$1 = 0, $1 = 0, $3 = 0, $ret_018$0 = 0, $ret_018$1 = 0, $s_addr_017 = 0, $mul$0 = 0, $mul$1 = 0, $add$0 = 0, $sub$0 = 0, $add16$0 = 0, $add16$1 = 0, $incdec_ptr17 = 0, $4 = 0, $ret_0_lcssa$0 = 0, $ret_0_lcssa$1 = 0, $mul19$0 = 0, $retval_0$0 = 0, $retval_0$1 = 0;
 if (($len | 0) < 1) {
  $retval_0$1 = 0;
  $retval_0$0 = 0;
  return (tempRet0 = $retval_0$1, $retval_0$0) | 0;
 }
 $add_ptr = $s + ($len << 1) | 0;
 $0 = HEAP16[$s >> 1] | 0;
 if (($0 << 16 >> 16 | 0) == 43) {
  $flag_0_ph$1 = 0;
  $flag_0_ph$0 = 1;
  $s_addr_0_ph = $s + 2 | 0;
 } else if (($0 << 16 >> 16 | 0) == 45) {
  $flag_0_ph$1 = -1;
  $flag_0_ph$0 = -1;
  $s_addr_0_ph = $s + 2 | 0;
 } else {
  $flag_0_ph$1 = 0;
  $flag_0_ph$0 = 1;
  $s_addr_0_ph = $s;
 }
 $1 = HEAP16[$s_addr_0_ph >> 1] | 0;
 if (($1 - 48 & 65535) < 10 & $s_addr_0_ph >>> 0 < $add_ptr >>> 0) {
  $s_addr_017 = $s_addr_0_ph;
  $ret_018$1 = 0;
  $ret_018$0 = 0;
  $3 = $1;
  while (1) {
   $mul$0 = ___muldi3($ret_018$0, $ret_018$1, 10, 0) | 0;
   $mul$1 = tempRet0;
   $add$0 = _i64Add($ret_018$0, $ret_018$1, -48, -1) | 0;
   $sub$0 = _i64Add($add$0, tempRet0, $mul$0, $mul$1) | 0;
   $add16$0 = _i64Add($sub$0, tempRet0, $3 & 65535, 0) | 0;
   $add16$1 = tempRet0;
   $incdec_ptr17 = $s_addr_017 + 2 | 0;
   $4 = HEAP16[$incdec_ptr17 >> 1] | 0;
   if (($4 - 48 & 65535) < 10 & $incdec_ptr17 >>> 0 < $add_ptr >>> 0) {
    $s_addr_017 = $incdec_ptr17;
    $ret_018$1 = $add16$1;
    $ret_018$0 = $add16$0;
    $3 = $4;
   } else {
    $ret_0_lcssa$1 = $add16$1;
    $ret_0_lcssa$0 = $add16$0;
    break;
   }
  }
 } else {
  $ret_0_lcssa$1 = 0;
  $ret_0_lcssa$0 = 0;
 }
 $mul19$0 = ___muldi3($flag_0_ph$0, $flag_0_ph$1, $ret_0_lcssa$0, $ret_0_lcssa$1) | 0;
 $retval_0$1 = tempRet0;
 $retval_0$0 = $mul19$0;
 return (tempRet0 = $retval_0$1, $retval_0$0) | 0;
}
function __ZN10ime_pinyin8UserDict13utf16le_lltoaExPti($this, $v$0, $v$1, $s, $size) {
 $this = $this | 0;
 $v$0 = $v$0 | 0;
 $v$1 = $v$1 | 0;
 $s = $s | 0;
 $size = $size | 0;
 var $add_ptr = 0, $$etemp$0$1 = 0, $mul$0 = 0, $s_addr_0 = 0, $v_addr_0$0 = 0, $v_addr_0$1 = 0, $ret_len_0 = 0, $ret_len_127 = 0, $v_addr_126$0 = 0, $v_addr_126$1 = 0, $s_addr_125 = 0, $rem$0 = 0, $add$0 = 0, $incdec_ptr7 = 0, $div$0 = 0, $div$1 = 0, $inc8 = 0, $v_addr_126_off$0 = 0, $v_addr_126_off$1 = 0, $$etemp$7$1 = 0, $ret_len_1_lcssa = 0, $v_addr_1_lcssa$0 = 0, $v_addr_1_lcssa$1 = 0, $s_addr_1_lcssa = 0, $s_addr_219 = 0, $s_addr_222 = 0, $b_021 = 0, $incdec_ptr16 = 0, $s_addr_2 = 0, $retval_0 = 0;
 if (($s | 0) == 0 | ($size | 0) < 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $add_ptr = $s + ($size << 1) | 0;
 $$etemp$0$1 = 0;
 if (($v$1 | 0) < ($$etemp$0$1 | 0) | ($v$1 | 0) == ($$etemp$0$1 | 0) & $v$0 >>> 0 < 0 >>> 0) {
  HEAP16[$s >> 1] = 45;
  $mul$0 = _i64Subtract(0, 0, $v$0, $v$1) | 0;
  $ret_len_0 = 1;
  $v_addr_0$1 = tempRet0;
  $v_addr_0$0 = $mul$0;
  $s_addr_0 = $s + 2 | 0;
 } else {
  $ret_len_0 = 0;
  $v_addr_0$1 = $v$1;
  $v_addr_0$0 = $v$0;
  $s_addr_0 = $s;
 }
 if ($s_addr_0 >>> 0 < $add_ptr >>> 0 & (($v_addr_0$0 | 0) != 0 | ($v_addr_0$1 | 0) != 0)) {
  $s_addr_125 = $s_addr_0;
  $v_addr_126$1 = $v_addr_0$1;
  $v_addr_126$0 = $v_addr_0$0;
  $ret_len_127 = $ret_len_0;
  while (1) {
   $rem$0 = ___remdi3($v_addr_126$0, $v_addr_126$1, 10, 0) | 0;
   $add$0 = _i64Add($rem$0, tempRet0, 48, 0) | 0;
   $incdec_ptr7 = $s_addr_125 + 2 | 0;
   HEAP16[$s_addr_125 >> 1] = $add$0 & 65535;
   $div$0 = ___divdi3($v_addr_126$0, $v_addr_126$1, 10, 0) | 0;
   $div$1 = tempRet0;
   $inc8 = $ret_len_127 + 1 | 0;
   $v_addr_126_off$0 = _i64Add($v_addr_126$0, $v_addr_126$1, 9, 0) | 0;
   $v_addr_126_off$1 = tempRet0;
   $$etemp$7$1 = 0;
   if ($incdec_ptr7 >>> 0 < $add_ptr >>> 0 & ($v_addr_126_off$1 >>> 0 > $$etemp$7$1 >>> 0 | $v_addr_126_off$1 >>> 0 == $$etemp$7$1 >>> 0 & $v_addr_126_off$0 >>> 0 > 18 >>> 0)) {
    $s_addr_125 = $incdec_ptr7;
    $v_addr_126$1 = $div$1;
    $v_addr_126$0 = $div$0;
    $ret_len_127 = $inc8;
   } else {
    $s_addr_1_lcssa = $incdec_ptr7;
    $v_addr_1_lcssa$1 = $div$1;
    $v_addr_1_lcssa$0 = $div$0;
    $ret_len_1_lcssa = $inc8;
    break;
   }
  }
 } else {
  $s_addr_1_lcssa = $s_addr_0;
  $v_addr_1_lcssa$1 = $v_addr_0$1;
  $v_addr_1_lcssa$0 = $v_addr_0$0;
  $ret_len_1_lcssa = $ret_len_0;
 }
 if (!(($v_addr_1_lcssa$0 | 0) == 0 & ($v_addr_1_lcssa$1 | 0) == 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $s_addr_219 = $s_addr_1_lcssa - 2 | 0;
 if ($s_addr_0 >>> 0 < $s_addr_219 >>> 0) {
  $b_021 = $s_addr_0;
  $s_addr_222 = $s_addr_219;
 } else {
  $retval_0 = $ret_len_1_lcssa;
  return $retval_0 | 0;
 }
 while (1) {
  HEAP16[$b_021 >> 1] = HEAP16[$s_addr_222 >> 1] | 0;
  $incdec_ptr16 = $b_021 + 2 | 0;
  $s_addr_2 = $s_addr_222 - 2 | 0;
  if ($incdec_ptr16 >>> 0 < $s_addr_2 >>> 0) {
   $b_021 = $incdec_ptr16;
   $s_addr_222 = $s_addr_2;
  } else {
   $retval_0 = $ret_len_1_lcssa;
   break;
  }
 }
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict9set_limitEjjj($this, $max_lemma_count, $max_lemma_size, $reclaim_ratio) {
 $this = $this | 0;
 $max_lemma_count = $max_lemma_count | 0;
 $max_lemma_size = $max_lemma_size | 0;
 $reclaim_ratio = $reclaim_ratio | 0;
 HEAP32[$this + 72 >> 2] = $max_lemma_count;
 HEAP32[$this + 76 >> 2] = $max_lemma_size;
 HEAP32[$this + 68 >> 2] = $reclaim_ratio >>> 0 > 100 ? 100 : $reclaim_ratio;
 return;
}
function __ZN10ime_pinyin8UserDict4swapEPNS0_23UserDictScoreOffsetPairEii($this, $sop, $i, $j) {
 $this = $this | 0;
 $sop = $sop | 0;
 $i = $i | 0;
 $j = $j | 0;
 var $score = 0, $0 = 0, $offset_index = 0, $1 = 0, $score4 = 0, $offset_index8 = 0;
 $score = $sop + ($i << 3) | 0;
 $0 = HEAP32[$score >> 2] | 0;
 $offset_index = $sop + ($i << 3) + 4 | 0;
 $1 = HEAP32[$offset_index >> 2] | 0;
 $score4 = $sop + ($j << 3) | 0;
 HEAP32[$score >> 2] = HEAP32[$score4 >> 2];
 $offset_index8 = $sop + ($j << 3) + 4 | 0;
 HEAP32[$offset_index >> 2] = HEAP32[$offset_index8 >> 2];
 HEAP32[$score4 >> 2] = $0;
 HEAP32[$offset_index8 >> 2] = $1;
 return;
}
function __ZN10ime_pinyin8UserDict38put_lemmas_no_sync_from_utf16le_stringEPti($this, $lemmas, $len) {
 $this = $this | 0;
 $lemmas = $lemmas | 0;
 $len = $len | 0;
 var $is_pre = 0, $call = 0, $0 = 0, $sub_ptr_rhs_cast = 0, $arraydecay = 0, $sub_ptr_lhs_cast57 = 0, $newly_added_056 = 0, $p_055 = 0, $2 = 0, $3 = 0, $p_149 = 0, $splid_len_048 = 0, $inc_splid_len_0 = 0, $incdec_ptr = 0, $4 = 0, $p_1_lcssa = 0, $splid_len_0_lcssa = 0, $inc14 = 0, $sub_ptr_lhs_cast15 = 0, $incdec_ptr35 = 0, $p_2 = 0, $incdec_ptr56 = 0, $p_3 = 0, $call74$0 = 0, $incdec_ptr76 = 0, $p_4 = 0, $call94$0 = 0, $inc99 = 0, $incdec_ptr100 = 0, $sub_ptr_lhs_cast = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 24 | 0;
 $is_pre = sp + 16 | 0;
 $call = __Znwj(4) | 0;
 $0 = $call;
 __ZN10ime_pinyin14SpellingParserC2Ev($0);
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $sub_ptr_rhs_cast = $lemmas;
 if (($len | 0) <= 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $arraydecay = sp | 0;
 $p_055 = $lemmas;
 $newly_added_056 = 0;
 $sub_ptr_lhs_cast57 = $lemmas;
 while (1) {
  $2 = HEAP16[$p_055 >> 1] | 0;
  L4408 : do {
   if ($2 << 16 >> 16 == 44) {
    $splid_len_0_lcssa = 0;
    $p_1_lcssa = $p_055;
   } else {
    $splid_len_048 = 0;
    $p_149 = $p_055;
    $3 = $2;
    while (1) {
     if (($p_149 - $sub_ptr_rhs_cast >> 1 | 0) >= ($len | 0)) {
      $splid_len_0_lcssa = $splid_len_048;
      $p_1_lcssa = $p_149;
      break L4408;
     }
     $inc_splid_len_0 = ($3 << 16 >> 16 == 32) + $splid_len_048 | 0;
     $incdec_ptr = $p_149 + 2 | 0;
     $4 = HEAP16[$incdec_ptr >> 1] | 0;
     if ($4 << 16 >> 16 == 44) {
      $splid_len_0_lcssa = $inc_splid_len_0;
      $p_1_lcssa = $incdec_ptr;
      break;
     } else {
      $splid_len_048 = $inc_splid_len_0;
      $p_149 = $incdec_ptr;
      $3 = $4;
     }
    }
   }
  } while (0);
  $inc14 = $splid_len_0_lcssa + 1 | 0;
  $sub_ptr_lhs_cast15 = $p_1_lcssa;
  if (($sub_ptr_lhs_cast15 - $sub_ptr_rhs_cast >> 1 | 0) == ($len | 0) | $inc14 >>> 0 > 8) {
   $retval_0 = $newly_added_056;
   label = 3483;
   break;
  }
  if (((__ZN10ime_pinyin14SpellingParser18splstr16_to_idxs_fEPKttPtS3_tRb($0, $p_055, ($sub_ptr_lhs_cast15 - $sub_ptr_lhs_cast57 | 0) >>> 1 & 65535, $arraydecay, 0, 8, $is_pre) | 0) & 65535 | 0) != ($inc14 | 0)) {
   $retval_0 = $newly_added_056;
   label = 3479;
   break;
  }
  $incdec_ptr35 = $p_1_lcssa + 2 | 0;
  $p_2 = $incdec_ptr35;
  while (1) {
   if ((HEAP16[$p_2 >> 1] | 0) == 44) {
    break;
   }
   if (($p_2 - $sub_ptr_rhs_cast >> 1 | 0) < ($len | 0)) {
    $p_2 = $p_2 + 2 | 0;
   } else {
    break;
   }
  }
  if (($p_2 - $incdec_ptr35 >> 1 | 0) != ($inc14 | 0)) {
   $retval_0 = $newly_added_056;
   label = 3482;
   break;
  }
  $incdec_ptr56 = $p_2 + 2 | 0;
  $p_3 = $incdec_ptr56;
  while (1) {
   if ((HEAP16[$p_3 >> 1] | 0) == 44) {
    break;
   }
   if (($p_3 - $sub_ptr_rhs_cast >> 1 | 0) < ($len | 0)) {
    $p_3 = $p_3 + 2 | 0;
   } else {
    break;
   }
  }
  $call74$0 = __ZN10ime_pinyin8UserDict13utf16le_atollEPti(0, $incdec_ptr56, $p_3 - $incdec_ptr56 >> 1) | 0;
  $incdec_ptr76 = $p_3 + 2 | 0;
  $p_4 = $incdec_ptr76;
  while (1) {
   if ((HEAP16[$p_4 >> 1] | 0) == 59) {
    break;
   }
   if (($p_4 - $sub_ptr_rhs_cast >> 1 | 0) < ($len | 0)) {
    $p_4 = $p_4 + 2 | 0;
   } else {
    break;
   }
  }
  $call94$0 = __ZN10ime_pinyin8UserDict13utf16le_atollEPti(0, $incdec_ptr76, $p_4 - $incdec_ptr76 >> 1) | 0;
  __ZN10ime_pinyin8UserDict17put_lemma_no_syncEPtS1_tty($this, $incdec_ptr35, $arraydecay, $inc14 & 65535, $call74$0 & 65535, $call94$0, tempRet0) | 0;
  $inc99 = $newly_added_056 + 1 | 0;
  $incdec_ptr100 = $p_4 + 2 | 0;
  $sub_ptr_lhs_cast = $incdec_ptr100;
  if (($sub_ptr_lhs_cast - $sub_ptr_rhs_cast >> 1 | 0) < ($len | 0)) {
   $p_055 = $incdec_ptr100;
   $newly_added_056 = $inc99;
   $sub_ptr_lhs_cast57 = $sub_ptr_lhs_cast;
  } else {
   $retval_0 = $inc99;
   label = 3478;
   break;
  }
 }
 if ((label | 0) == 3482) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 3483) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 3478) {
  STACKTOP = sp;
  return $retval_0 | 0;
 } else if ((label | 0) == 3479) {
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 return 0;
}
function __ZN10ime_pinyin8UserDict48get_sync_lemmas_in_utf16le_string_from_beginningEPtiPi($this, $str, $size, $count) {
 $this = $this | 0;
 $str = $str | 0;
 $size = $size | 0;
 $count = $count | 0;
 var $call2 = 0, $sync_count = 0, $syncs_ = 0, $len_045 = 0, $left_len_044 = 0, $i_043 = 0, $2 = 0, $call6 = 0, $conv7 = 0, $call8 = 0, $call9 = 0, $call11 = 0, $j_034 = 0, $4 = 0, $call16 = 0, $5 = 0, $add_ptr = 0, $inc = 0, $j_1 = 0, $6 = 0, $incdec_ptr26 = 0, $7 = 0, $cmp3536 = 0, $8 = 0, $j_238 = 0, $9 = 0, $inc42 = 0, $10 = 0, $cmp35 = 0, $cmp35_lcssa = 0, $_lcssa = 0, $j_2_lcssa = 0, $conv54$0 = 0, $11 = 0, $call58 = 0, $12 = 0, $add_ptr62 = 0, $call68$0 = 0, $13 = 0, $call72 = 0, $14 = 0, $add_ptr76 = 0, $sub_ptr_sub82 = 0, $sub_ptr_div83 = 0, $16 = 0, $left_len_1 = 0, $len_1 = 0, $inc90 = 0, $len_0_lcssa = 0, $state_ = 0, $retval_0 = 0;
 HEAP32[$count >> 2] = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $call2 = __ZN10ime_pinyin12SpellingTrie12get_instanceEv() | 0;
 if (($call2 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $sync_count = $this + 96 | 0;
 if ((HEAP32[$sync_count >> 2] | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $syncs_ = $this + 44 | 0;
 $i_043 = 0;
 $left_len_044 = $size;
 $len_045 = 0;
 L4443 : while (1) {
  $2 = HEAP32[(HEAP32[$syncs_ >> 2] | 0) + ($i_043 << 2) >> 2] | 0;
  $call6 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
  $conv7 = $call6 << 24 >> 24;
  $call8 = __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $2) | 0;
  $call9 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0;
  $call11 = __ZN10ime_pinyin8UserDict16_get_lemma_scoreEPtS1_t($this, $call9, $call8, $call6 << 24 >> 24) | 0;
  HEAP32[2002] = 46880;
  L4445 : do {
   if ($call6 << 24 >> 24 == 0) {
    $j_1 = 0;
   } else {
    $j_034 = 0;
    while (1) {
     $4 = HEAP32[2002] | 0;
     $call16 = __ZN10ime_pinyin12SpellingTrie18get_spelling_str16EtPtj($call2, HEAP16[$call8 + ($j_034 << 1) >> 1] | 0, $4, 47904 - $4 >> 1) | 0;
     if (($call16 | 0) < 1) {
      $j_1 = $j_034;
      break L4445;
     }
     $5 = HEAP32[2002] | 0;
     $add_ptr = $5 + ($call16 << 1) | 0;
     HEAP32[2002] = $add_ptr;
     if ($add_ptr >>> 0 >= 47902 >>> 0) {
      $j_1 = 0;
      break L4445;
     }
     HEAP32[2002] = $5 + ($call16 + 1 << 1);
     HEAP16[$add_ptr >> 1] = 32;
     $inc = $j_034 + 1 | 0;
     if ($inc >>> 0 < $conv7 >>> 0) {
      $j_034 = $inc;
     } else {
      $j_1 = $inc;
      break;
     }
    }
   }
  } while (0);
  do {
   if ($j_1 >>> 0 < $conv7 >>> 0) {
    $len_1 = $len_045;
    $left_len_1 = $left_len_044;
   } else {
    $6 = HEAP32[2002] | 0;
    $incdec_ptr26 = $6 - 2 | 0;
    HEAP32[2002] = $incdec_ptr26;
    if ($incdec_ptr26 >>> 0 >= 47902 >>> 0) {
     $len_1 = $len_045;
     $left_len_1 = $left_len_044;
     break;
    }
    HEAP32[2002] = $6;
    HEAP16[$incdec_ptr26 >> 1] = 44;
    $7 = HEAP32[2002] | 0;
    $cmp3536 = $7 >>> 0 < 47902 >>> 0;
    if ($call6 << 24 >> 24 != 0 & $cmp3536) {
     $j_238 = 0;
     $8 = $7;
     while (1) {
      $9 = HEAP16[$call9 + ($j_238 << 1) >> 1] | 0;
      HEAP32[2002] = $8 + 2;
      HEAP16[$8 >> 1] = $9;
      $inc42 = $j_238 + 1 | 0;
      $10 = HEAP32[2002] | 0;
      $cmp35 = $10 >>> 0 < 47902 >>> 0;
      if ($inc42 >>> 0 < $conv7 >>> 0 & $cmp35) {
       $j_238 = $inc42;
       $8 = $10;
      } else {
       $j_2_lcssa = $inc42;
       $_lcssa = $10;
       $cmp35_lcssa = $cmp35;
       break;
      }
     }
    } else {
     $j_2_lcssa = 0;
     $_lcssa = $7;
     $cmp35_lcssa = $cmp3536;
    }
    if (!($j_2_lcssa >>> 0 >= $conv7 >>> 0 & $cmp35_lcssa)) {
     $len_1 = $len_045;
     $left_len_1 = $left_len_044;
     break;
    }
    HEAP32[2002] = $_lcssa + 2;
    HEAP16[$_lcssa >> 1] = 44;
    $conv54$0 = __ZN10ime_pinyin8UserDict18extract_score_freqEi(0, $call11) | 0;
    $11 = HEAP32[2002] | 0;
    $call58 = __ZN10ime_pinyin8UserDict13utf16le_lltoaExPti(0, $conv54$0, 0, $11, 47904 - $11 >> 1) | 0;
    if (($call58 | 0) < 1) {
     $len_1 = $len_045;
     $left_len_1 = $left_len_044;
     break;
    }
    $12 = HEAP32[2002] | 0;
    $add_ptr62 = $12 + ($call58 << 1) | 0;
    HEAP32[2002] = $add_ptr62;
    if ($add_ptr62 >>> 0 >= 47902 >>> 0) {
     $len_1 = $len_045;
     $left_len_1 = $left_len_044;
     break;
    }
    HEAP32[2002] = $12 + ($call58 + 1 << 1);
    HEAP16[$add_ptr62 >> 1] = 44;
    $call68$0 = __ZN10ime_pinyin8UserDict17extract_score_lmtEi(0, $call11) | 0;
    $13 = HEAP32[2002] | 0;
    $call72 = __ZN10ime_pinyin8UserDict13utf16le_lltoaExPti(0, $call68$0, tempRet0, $13, 47904 - $13 >> 1) | 0;
    if (($call72 | 0) < 1) {
     $len_1 = $len_045;
     $left_len_1 = $left_len_044;
     break;
    }
    $14 = HEAP32[2002] | 0;
    $add_ptr76 = $14 + ($call72 << 1) | 0;
    HEAP32[2002] = $add_ptr76;
    if ($add_ptr76 >>> 0 >= 47902 >>> 0) {
     $len_1 = $len_045;
     $left_len_1 = $left_len_044;
     break;
    }
    HEAP32[2002] = $14 + ($call72 + 1 << 1);
    HEAP16[$add_ptr76 >> 1] = 59;
    $sub_ptr_sub82 = (HEAP32[2002] | 0) - 46880 | 0;
    $sub_ptr_div83 = $sub_ptr_sub82 >> 1;
    if (($sub_ptr_div83 | 0) > ($left_len_044 | 0)) {
     $len_0_lcssa = $len_045;
     break L4443;
    }
    $16 = $str + ($len_045 << 1) | 0;
    _memcpy($16 | 0, 46880, $sub_ptr_sub82) | 0;
    HEAP32[$count >> 2] = (HEAP32[$count >> 2] | 0) + 1;
    $len_1 = $sub_ptr_div83 + $len_045 | 0;
    $left_len_1 = $left_len_044 - $sub_ptr_div83 | 0;
   }
  } while (0);
  $inc90 = $i_043 + 1 | 0;
  if ($inc90 >>> 0 < (HEAP32[$sync_count >> 2] | 0) >>> 0) {
   $i_043 = $inc90;
   $left_len_044 = $left_len_1;
   $len_045 = $len_1;
  } else {
   $len_0_lcssa = $len_1;
   break;
  }
 }
 if (($len_0_lcssa | 0) <= 0) {
  $retval_0 = $len_0_lcssa;
  return $retval_0 | 0;
 }
 $state_ = $this + 104 | 0;
 if ((HEAP32[$state_ >> 2] | 0) >= 2) {
  $retval_0 = $len_0_lcssa;
  return $retval_0 | 0;
 }
 HEAP32[$state_ >> 2] = 2;
 $retval_0 = $len_0_lcssa;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict5stateEPNS0_12UserDictStatE($this, $stat) {
 $this = $this | 0;
 $stat = $stat | 0;
 var $dict_info_ = 0, $retval_0 = 0;
 if (($stat | 0) == 0 | (__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0) ^ 1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 HEAP32[$stat >> 2] = HEAP32[$this + 20 >> 2];
 HEAP32[$stat + 4 >> 2] = HEAP32[$this + 64 >> 2];
 HEAP32[$stat + 8 >> 2] = HEAP32[$this + 8 >> 2];
 HEAP32[$stat + 12 >> 2] = HEAP32[$this + 12 >> 2];
 HEAP32[$stat + 16 >> 2] = HEAP32[11850];
 HEAP32[$stat + 20 >> 2] = HEAP32[11851];
 $dict_info_ = $this + 68 | 0;
 HEAP32[$stat + 24 >> 2] = __ZN10ime_pinyin8UserDict18get_dict_file_sizeEPNS0_12UserDictInfoE(0, $dict_info_) | 0;
 HEAP32[$stat + 28 >> 2] = HEAP32[$this + 80 >> 2];
 HEAP32[$stat + 32 >> 2] = HEAP32[$this + 84 >> 2];
 HEAP32[$stat + 36 >> 2] = HEAP32[$this + 88 >> 2];
 HEAP32[$stat + 40 >> 2] = HEAP32[$this + 92 >> 2];
 HEAP32[$stat + 44 >> 2] = HEAP32[$this + 96 >> 2];
 HEAP32[$stat + 52 >> 2] = HEAP32[$this + 72 >> 2];
 HEAP32[$stat + 56 >> 2] = HEAP32[$this + 76 >> 2];
 HEAP32[$stat + 48 >> 2] = HEAP32[$dict_info_ >> 2];
 $retval_0 = 1;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict10shift_downEPNS0_23UserDictScoreOffsetPairEii($this, $sop, $i, $n) {
 $this = $this | 0;
 $sop = $sop | 0;
 $i = $i | 0;
 $n = $n | 0;
 var $par_038 = 0, $add36 = 0, $add2 = 0, $cmp4 = 0, $score = 0, $0 = 0, $par_0_be = 0, $score15 = 0, $4 = 0, label = 0;
 if (($i | 0) < ($n | 0)) {
  $par_038 = $i;
 } else {
  return;
 }
 L4481 : while (1) {
  $add36 = $par_038 << 1 | 1;
  $add2 = $add36 + 1 | 0;
  $cmp4 = ($add2 | 0) < ($n | 0);
  if (!(($add36 | 0) < ($n | 0) | $cmp4)) {
   label = 3532;
   break;
  }
  $score = $sop + ($add36 << 3) | 0;
  $0 = HEAP32[$score >> 2] | 0;
  L4484 : do {
   if ($cmp4) {
    $score15 = $sop + ($add2 << 3) | 0;
    do {
     if (($0 | 0) > (HEAP32[$score15 >> 2] | 0)) {
      if (($0 | 0) <= (HEAP32[$sop + ($par_038 << 3) >> 2] | 0)) {
       break;
      }
      __ZN10ime_pinyin8UserDict4swapEPNS0_23UserDictScoreOffsetPairEii(0, $sop, $add36, $par_038);
      $par_0_be = $add36;
      break L4484;
     }
    } while (0);
    $4 = HEAP32[$score15 >> 2] | 0;
    if (($4 | 0) <= (HEAP32[$score >> 2] | 0)) {
     label = 3536;
     break L4481;
    }
    if (($4 | 0) <= (HEAP32[$sop + ($par_038 << 3) >> 2] | 0)) {
     label = 3537;
     break L4481;
    }
    __ZN10ime_pinyin8UserDict4swapEPNS0_23UserDictScoreOffsetPairEii(0, $sop, $add2, $par_038);
    $par_0_be = $add2;
   } else {
    if (($0 | 0) <= (HEAP32[$sop + ($par_038 << 3) >> 2] | 0)) {
     label = 3534;
     break L4481;
    }
    __ZN10ime_pinyin8UserDict4swapEPNS0_23UserDictScoreOffsetPairEii(0, $sop, $add36, $par_038);
    $par_0_be = $add36;
   }
  } while (0);
  if (($par_0_be | 0) < ($n | 0)) {
   $par_038 = $par_0_be;
  } else {
   label = 3533;
   break;
  }
 }
 if ((label | 0) == 3536) {
  return;
 } else if ((label | 0) == 3537) {
  return;
 } else if ((label | 0) == 3532) {
  return;
 } else if ((label | 0) == 3533) {
  return;
 } else if ((label | 0) == 3534) {
  return;
 }
}
function __ZN10ime_pinyin8UserDict9put_lemmaEPtS1_tt($this, $lemma_str, $splids, $lemma_len, $count) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 $count = $count | 0;
 var $call = 0;
 $call = _time(0) | 0;
 return __ZN10ime_pinyin8UserDict10_put_lemmaEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $call, ($call | 0) < 0 ? -1 : 0) | 0;
}
function __ZN10ime_pinyin8UserDict7reclaimEv($this) {
 $this = $this | 0;
 var $0 = 0, $lemma_count = 0, $mul = 0, $div = 0, $call7 = 0, $2 = 0, $4 = 0, $i_036 = 0, $scores_28 = 0, $score31 = 0, $7 = 0, $i14_034 = 0, $i21_033 = 0, $10 = 0, $i42_031 = 0, $state_ = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  return;
 }
 $0 = HEAP32[$this + 68 >> 2] | 0;
 if (($0 | 0) == 0) {
  return;
 } else if (($0 | 0) == 100) {
  ___assert_func(2712, 1958, 4520, 1856);
 } else {
  $lemma_count = $this + 80 | 0;
  $mul = Math_imul(HEAP32[$lemma_count >> 2] | 0, $0) | 0;
  $div = ($mul >>> 0) / 100 | 0;
  $call7 = _malloc($div << 3) | 0;
  $2 = $call7;
  if (($call7 | 0) == 0) {
   return;
  }
  if ($mul >>> 0 > 99) {
   $4 = HEAP32[$this + 32 >> 2] | 0;
   $i_036 = 0;
   do {
    HEAP32[$2 + ($i_036 << 3) >> 2] = HEAP32[$4 + ($i_036 << 2) >> 2];
    HEAP32[$2 + ($i_036 << 3) + 4 >> 2] = $i_036;
    $i_036 = $i_036 + 1 | 0;
   } while (($i_036 | 0) < ($div | 0));
  }
  $i14_034 = ($div + 1 | 0) >>> 1;
  while (1) {
   __ZN10ime_pinyin8UserDict10shift_downEPNS0_23UserDictScoreOffsetPairEii($this, $2, $i14_034, $div);
   if (($i14_034 | 0) > 0) {
    $i14_034 = $i14_034 - 1 | 0;
   } else {
    break;
   }
  }
  if ($div >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0) {
   $scores_28 = $this + 32 | 0;
   $score31 = $call7;
   $7 = $call7 + 4 | 0;
   $i21_033 = $div;
   do {
    $10 = HEAP32[(HEAP32[$scores_28 >> 2] | 0) + ($i21_033 << 2) >> 2] | 0;
    if (($10 | 0) < (HEAP32[$score31 >> 2] | 0)) {
     HEAP32[$score31 >> 2] = $10;
     HEAP32[$7 >> 2] = $i21_033;
     __ZN10ime_pinyin8UserDict10shift_downEPNS0_23UserDictScoreOffsetPairEii($this, $2, 0, $div);
    }
    $i21_033 = $i21_033 + 1 | 0;
   } while ($i21_033 >>> 0 < (HEAP32[$lemma_count >> 2] | 0) >>> 0);
  }
  do {
   if ($mul >>> 0 > 99) {
    $i42_031 = 0;
    do {
     __ZN10ime_pinyin8UserDict28remove_lemma_by_offset_indexEi($this, HEAP32[$2 + ($i42_031 << 3) + 4 >> 2] | 0) | 0;
     $i42_031 = $i42_031 + 1 | 0;
    } while (($i42_031 | 0) < ($div | 0));
    if ($mul >>> 0 <= 99) {
     break;
    }
    $state_ = $this + 104 | 0;
    if ((HEAP32[$state_ >> 2] | 0) >= 4) {
     break;
    }
    HEAP32[$state_ >> 2] = 4;
   }
  } while (0);
  _free($call7);
  return;
 }
}
function __ZN10ime_pinyin8UserDict21get_total_lemma_countEv($this) {
 $this = $this | 0;
 return HEAP32[$this + 100 >> 2] | 0;
}
function __ZN10ime_pinyin8UserDict31set_total_lemma_count_of_othersEj($this, $count) {
 $this = $this | 0;
 $count = $count | 0;
 HEAP32[$this + 4 >> 2] = $count;
 return;
}
function __ZN10ime_pinyin8UserDict16get_max_lemma_idEv($this) {
 $this = $this | 0;
 return (HEAP32[$this + 16 >> 2] | 0) - 1 + (HEAP32[$this + 80 >> 2] | 0) | 0;
}
function __ZN10ime_pinyin8UserDict14append_a_lemmaEPtS1_tty($this, $lemma_str, $splids, $lemma_len, $count, $lmt$0, $lmt$1) {
 $this = $this | 0;
 $lemma_str = $lemma_str | 0;
 $splids = $splids | 0;
 $lemma_len = $lemma_len | 0;
 $count = $count | 0;
 $lmt$0 = $lmt$0 | 0;
 $lmt$1 = $lmt$1 | 0;
 var $searchable = 0, $add = 0, $lemma_size = 0, $0 = 0, $lemmas_ = 0, $conv5 = 0, $add8 = 0, $add16 = 0, $i_063 = 0, $shl = 0, $lemma_count = 0, $9 = 0, $offsets_ = 0, $conv23 = 0, $call24 = 0, $scores_ = 0, $ids_ = 0, $predicts_ = 0, $add3461 = 0, $lemma_count_left_ = 0, $lemma_size_left_ = 0, $i42_0 = 0, $21 = 0, $call46 = 0, $22 = 0, $23 = 0, $add_ptr_sum = 0, $shl64 = 0, $27 = 0, $28 = 0, $32 = 0, $33 = 0, $37 = 0, $38 = 0, $call94 = 0, $state_ = 0, $total_nfreq = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 $searchable = sp | 0;
 $add = (__ZN10ime_pinyin8UserDict16get_max_lemma_idEv($this) | 0) + 1 | 0;
 $lemma_size = $this + 84 | 0;
 $0 = HEAP32[$lemma_size >> 2] | 0;
 if (($0 | 0) < 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $lemmas_ = $this + 24 | 0;
 HEAP8[(HEAP32[$lemmas_ >> 2] | 0) + $0 | 0] = 0;
 HEAP8[(HEAP32[$lemmas_ >> 2] | 0) + ($0 + 1) | 0] = $lemma_len & 255;
 $conv5 = $lemma_len & 65535;
 if ($lemma_len << 16 >> 16 != 0) {
  $add8 = $0 + 2 | 0;
  $add16 = $add8 + ($conv5 << 1) | 0;
  $i_063 = 0;
  do {
   $shl = $i_063 << 1;
   HEAP16[(HEAP32[$lemmas_ >> 2] | 0) + ($shl + $add8) >> 1] = HEAP16[$splids + ($i_063 << 1) >> 1] | 0;
   HEAP16[(HEAP32[$lemmas_ >> 2] | 0) + ($add16 + $shl) >> 1] = HEAP16[$lemma_str + ($i_063 << 1) >> 1] | 0;
   $i_063 = $i_063 + 1 | 0;
  } while ($i_063 >>> 0 < $conv5 >>> 0);
 }
 $lemma_count = $this + 80 | 0;
 $9 = HEAP32[$lemma_count >> 2] | 0;
 $offsets_ = $this + 28 | 0;
 HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($9 << 2) >> 2] = $0;
 $conv23 = $count & 65535;
 $call24 = __ZN10ime_pinyin8UserDict11build_scoreEyi(0, $lmt$0, $lmt$1, $conv23) | 0;
 $scores_ = $this + 32 | 0;
 HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($9 << 2) >> 2] = $call24;
 $ids_ = $this + 36 | 0;
 HEAP32[(HEAP32[$ids_ >> 2] | 0) + ($9 << 2) >> 2] = $add;
 $predicts_ = $this + 40 | 0;
 HEAP32[(HEAP32[$predicts_ >> 2] | 0) + ($9 << 2) >> 2] = $0;
 HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($add - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] = $0;
 HEAP32[$lemma_count >> 2] = (HEAP32[$lemma_count >> 2] | 0) + 1;
 $add3461 = $conv5 << 2 | 2;
 HEAP32[$lemma_size >> 2] = (HEAP32[$lemma_size >> 2] | 0) + $add3461;
 $lemma_count_left_ = $this + 56 | 0;
 HEAP32[$lemma_count_left_ >> 2] = (HEAP32[$lemma_count_left_ >> 2] | 0) - 1;
 $lemma_size_left_ = $this + 60 | 0;
 HEAP32[$lemma_size_left_ >> 2] = (HEAP32[$lemma_size_left_ >> 2] | 0) - $add3461;
 __ZN10ime_pinyin8UserDict14prepare_locateEPNS0_18UserDictSearchableEPKtt(0, $searchable, $splids, $lemma_len);
 $i42_0 = 0;
 while (1) {
  if ($i42_0 >>> 0 >= $9 >>> 0) {
   break;
  }
  $21 = HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($i42_0 << 2) >> 2] | 0;
  $call46 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $21) | 0;
  if ((__ZN10ime_pinyin8UserDict22fuzzy_compare_spell_idEPKttPKNS0_18UserDictSearchableE(0, __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $21) | 0, $call46 << 24 >> 24, $searchable) | 0) > -1) {
   break;
  } else {
   $i42_0 = $i42_0 + 1 | 0;
  }
 }
 if (($i42_0 | 0) != ($9 | 0)) {
  $22 = HEAP32[$offsets_ >> 2] | 0;
  $23 = HEAP32[$22 + ($9 << 2) >> 2] | 0;
  $add_ptr_sum = $i42_0 + 1 | 0;
  $shl64 = $9 - $i42_0 << 2;
  _memmove($22 + ($add_ptr_sum << 2) | 0, $22 + ($i42_0 << 2) | 0, $shl64 | 0);
  HEAP32[(HEAP32[$offsets_ >> 2] | 0) + ($i42_0 << 2) >> 2] = $23;
  $27 = HEAP32[$scores_ >> 2] | 0;
  $28 = HEAP32[$27 + ($9 << 2) >> 2] | 0;
  _memmove($27 + ($add_ptr_sum << 2) | 0, $27 + ($i42_0 << 2) | 0, $shl64 | 0);
  HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($i42_0 << 2) >> 2] = $28;
  $32 = HEAP32[$ids_ >> 2] | 0;
  $33 = HEAP32[$32 + ($9 << 2) >> 2] | 0;
  _memmove($32 + ($add_ptr_sum << 2) | 0, $32 + ($i42_0 << 2) | 0, $shl64 | 0);
  HEAP32[(HEAP32[$ids_ >> 2] | 0) + ($i42_0 << 2) >> 2] = $33;
 }
 $37 = HEAP32[$predicts_ >> 2] | 0;
 $38 = HEAP32[$37 + ($9 << 2) >> 2] | 0;
 $call94 = __ZN10ime_pinyin8UserDict34locate_where_to_insert_in_predictsEPKti($this, __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $38) | 0, $conv5) | 0;
 if (($call94 | 0) != ($9 | 0)) {
  _memmove($37 + ($call94 + 1 << 2) | 0, $37 + ($call94 << 2) | 0, $9 - $call94 << 2 | 0);
  HEAP32[(HEAP32[$predicts_ >> 2] | 0) + ($call94 << 2) >> 2] = $38;
 }
 $state_ = $this + 104 | 0;
 if ((HEAP32[$state_ >> 2] | 0) < 5) {
  HEAP32[$state_ >> 2] = 5;
 }
 __ZN10ime_pinyin8UserDict10cache_initEv($this);
 $total_nfreq = $this + 100 | 0;
 HEAP32[$total_nfreq >> 2] = (HEAP32[$total_nfreq >> 2] | 0) + $conv23;
 $retval_0 = $add;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin8UserDict20queue_lemma_for_syncEj($this, $id) {
 $this = $this | 0;
 $id = $id | 0;
 var $sync_count = 0, $0 = 0, $sync_count_size_ = 0, $1 = 0, $4 = 0, $syncs_5 = 0, $call = 0, $12 = 0, $13 = 0;
 $sync_count = $this + 96 | 0;
 $0 = HEAP32[$sync_count >> 2] | 0;
 $sync_count_size_ = $this + 48 | 0;
 $1 = HEAP32[$sync_count_size_ >> 2] | 0;
 if ($0 >>> 0 < $1 >>> 0) {
  $4 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($id - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
  HEAP32[$sync_count >> 2] = $0 + 1;
  HEAP32[(HEAP32[$this + 44 >> 2] | 0) + ($0 << 2) >> 2] = $4;
  return;
 }
 $syncs_5 = $this + 44 | 0;
 $call = _realloc(HEAP32[$syncs_5 >> 2] | 0, ($1 << 2) + 128 | 0) | 0;
 if (($call | 0) == 0) {
  return;
 }
 HEAP32[$sync_count_size_ >> 2] = (HEAP32[$sync_count_size_ >> 2] | 0) + 32;
 HEAP32[$syncs_5 >> 2] = $call;
 $12 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($id - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
 $13 = HEAP32[$sync_count >> 2] | 0;
 HEAP32[$sync_count >> 2] = $13 + 1;
 HEAP32[(HEAP32[$syncs_5 >> 2] | 0) + ($13 << 2) >> 2] = $12;
 return;
}
function __ZN10ime_pinyin8UserDict12update_lemmaEjsb($this, $lemma_id, $delta_count, $selected) {
 $this = $this | 0;
 $lemma_id = $lemma_id | 0;
 $delta_count = $delta_count | 0;
 $selected = $selected | 0;
 var $2 = 0, $call7 = 0, $call8 = 0, $call11 = 0, $scores_ = 0, $4 = 0, $call15 = 0, $call16$0 = 0, $call16$1 = 0, $delta_count_addr_0 = 0, $conv26 = 0, $total_nfreq = 0, $call31 = 0, $lmt_0$0 = 0, $lmt_0$1 = 0, $call34 = 0, $state_ = 0, $ids_ = 0, $retval_0 = 0;
 if (!(__ZN10ime_pinyin8UserDict14is_valid_stateEv($this) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 if (!(__ZN10ime_pinyin8UserDict17is_valid_lemma_idEj($this, $lemma_id) | 0)) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $2 = HEAP32[(HEAP32[$this + 52 >> 2] | 0) + ($lemma_id - (HEAP32[$this + 16 >> 2] | 0) << 2) >> 2] | 0;
 $call7 = __ZN10ime_pinyin8UserDict15get_lemma_ncharEj($this, $2) | 0;
 $call8 = __ZN10ime_pinyin8UserDict14get_lemma_wordEj($this, $2) | 0;
 $call11 = __ZN10ime_pinyin8UserDict17locate_in_offsetsEPtS1_t($this, $call8, __ZN10ime_pinyin8UserDict19get_lemma_spell_idsEj($this, $2) | 0, $call7 & 255) | 0;
 if (($call11 | 0) == -1) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $scores_ = $this + 32 | 0;
 $4 = HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($call11 << 2) >> 2] | 0;
 $call15 = __ZN10ime_pinyin8UserDict18extract_score_freqEi(0, $4) | 0;
 $call16$0 = __ZN10ime_pinyin8UserDict17extract_score_lmtEi(0, $4) | 0;
 $call16$1 = tempRet0;
 if (($call15 + ($delta_count << 16 >> 16) | 0) > 65535 | $delta_count << 16 >> 16 < 0) {
  $delta_count_addr_0 = 65535 - $call15 & 65535;
 } else {
  $delta_count_addr_0 = $delta_count;
 }
 $conv26 = $delta_count_addr_0 << 16 >> 16;
 $total_nfreq = $this + 100 | 0;
 HEAP32[$total_nfreq >> 2] = (HEAP32[$total_nfreq >> 2] | 0) + $conv26;
 if ($selected) {
  $call31 = _time(0) | 0;
  $lmt_0$1 = ($call31 | 0) < 0 ? -1 : 0;
  $lmt_0$0 = $call31;
 } else {
  $lmt_0$1 = $call16$1;
  $lmt_0$0 = $call16$0;
 }
 $call34 = __ZN10ime_pinyin8UserDict11build_scoreEyi(0, $lmt_0$0, $lmt_0$1, $conv26 + $call15 | 0) | 0;
 HEAP32[(HEAP32[$scores_ >> 2] | 0) + ($call11 << 2) >> 2] = $call34;
 $state_ = $this + 104 | 0;
 if ((HEAP32[$state_ >> 2] | 0) < 3) {
  HEAP32[$state_ >> 2] = 3;
 }
 $ids_ = $this + 36 | 0;
 __ZN10ime_pinyin8UserDict20queue_lemma_for_syncEj($this, HEAP32[(HEAP32[$ids_ >> 2] | 0) + ($call11 << 2) >> 2] | 0);
 $retval_0 = HEAP32[(HEAP32[$ids_ >> 2] | 0) + ($call11 << 2) >> 2] | 0;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11Utf16ReaderC2Ev($this) {
 $this = $this | 0;
 _memset($this | 0, 0, 20);
 return;
}
function __ZN10ime_pinyin11Utf16ReaderD2Ev($this) {
 $this = $this | 0;
 var $0 = 0, $1 = 0;
 $0 = HEAP32[$this >> 2] | 0;
 if (($0 | 0) != 0) {
  _fclose($0 | 0) | 0;
 }
 $1 = HEAP32[$this + 4 >> 2] | 0;
 if (($1 | 0) == 0) {
  return;
 }
 __ZdaPv($1);
 return;
}
function __ZN10ime_pinyin11Utf16Reader4openEPKcj($this, $filename, $buffer_len) {
 $this = $this | 0;
 $filename = $filename | 0;
 $buffer_len = $buffer_len | 0;
 var $header = 0, $buffer_len_addr_0 = 0, $buffer_total_len_ = 0, $buffer_ = 0, $0 = 0, $3$0 = 0, $call = 0, $call18 = 0, $fp_ = 0, $cmp24 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $header = sp | 0;
 if (($filename | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if ($buffer_len >>> 0 < 128) {
  $buffer_len_addr_0 = 128;
 } else {
  $buffer_len_addr_0 = $buffer_len >>> 0 > 65535 ? 65535 : $buffer_len;
 }
 $buffer_total_len_ = $this + 8 | 0;
 HEAP32[$buffer_total_len_ >> 2] = $buffer_len_addr_0;
 $buffer_ = $this + 4 | 0;
 $0 = HEAP32[$buffer_ >> 2] | 0;
 if (($0 | 0) != 0) {
  __ZdaPv($0);
 }
 $3$0 = _llvm_umul_with_overflow_i32(HEAP32[$buffer_total_len_ >> 2] | 0, 2) | 0;
 $call = __Znaj(tempRet0 ? -1 : $3$0) | 0;
 HEAP32[$buffer_ >> 2] = $call;
 if (($call | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $call18 = _fopen($filename | 0, 2072) | 0;
 $fp_ = $this | 0;
 HEAP32[$fp_ >> 2] = $call18;
 if (($call18 | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $cmp24 = (_fread($header | 0, 2, 1, $call18 | 0) | 0) == 1;
 if ($cmp24 & (HEAP16[$header >> 1] | 0) == -257) {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _fclose(HEAP32[$fp_ >> 2] | 0) | 0;
 HEAP32[$fp_ >> 2] = 0;
 $retval_0 = 0;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZN10ime_pinyin11Utf16Reader8readlineEPtj($this, $read_buf, $max_len) {
 $this = $this | 0;
 $read_buf = $read_buf | 0;
 $max_len = $max_len | 0;
 var $fp_ = 0, $buffer_valid_len_ = 0, $buffer_next_pos_ = 0, $buffer_ = 0, $buffer_total_len_ = 0, $sub = 0, $buffer_next_pos_21 = 0, $buffer_22 = 0, $1 = 0, $ret_len_0 = 0, $call = 0, $i_032 = 0, $8 = 0, $add26 = 0, $arrayidx30 = 0, $inc = 0, $buffer_next_pos_40 = 0, $inc59 = 0, $14 = 0, $_lcssa = 0, $retval_0 = 0, label = 0;
 $fp_ = $this | 0;
 if ((HEAP32[$fp_ >> 2] | 0) == 0 | ($read_buf | 0) == 0 | ($max_len | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $buffer_valid_len_ = $this + 16 | 0;
 $buffer_next_pos_ = $this + 12 | 0;
 $buffer_ = $this + 4 | 0;
 $buffer_total_len_ = $this + 8 | 0;
 $sub = $max_len - 1 | 0;
 $buffer_next_pos_21 = $this + 12 | 0;
 $buffer_22 = $this + 4 | 0;
 $ret_len_0 = 0;
 $1 = (HEAP32[$buffer_valid_len_ >> 2] | 0) == 0;
 L4625 : while (1) {
  if ($1) {
   HEAP32[$buffer_next_pos_ >> 2] = 0;
   $call = _fread(HEAP32[$buffer_ >> 2] | 0, 2, HEAP32[$buffer_total_len_ >> 2] | 0, HEAP32[$fp_ >> 2] | 0) | 0;
   HEAP32[$buffer_valid_len_ >> 2] = $call;
   if (($call | 0) == 0) {
    label = 3635;
    break;
   } else {
    $i_032 = 0;
    label = 3637;
   }
  } else {
   if ((HEAP32[$buffer_valid_len_ >> 2] | 0) == 0) {
    $_lcssa = 0;
   } else {
    $i_032 = 0;
    label = 3637;
   }
  }
  if ((label | 0) == 3637) {
   while (1) {
    label = 0;
    if (($i_032 | 0) == ($sub | 0)) {
     break L4625;
    }
    $8 = HEAP16[(HEAP32[$buffer_22 >> 2] | 0) + ((HEAP32[$buffer_next_pos_21 >> 2] | 0) + $i_032 << 1) >> 1] | 0;
    if ($8 << 16 >> 16 == 10) {
     break L4625;
    }
    HEAP16[$read_buf + ($i_032 + $ret_len_0 << 1) >> 1] = $8;
    $inc59 = $i_032 + 1 | 0;
    $14 = HEAP32[$buffer_valid_len_ >> 2] | 0;
    if ($inc59 >>> 0 < $14 >>> 0) {
     $i_032 = $inc59;
     label = 3637;
    } else {
     $_lcssa = $14;
     break;
    }
   }
  }
  HEAP32[$buffer_valid_len_ >> 2] = 0;
  $ret_len_0 = $_lcssa + $ret_len_0 | 0;
  $1 = 1;
 }
 if ((label | 0) == 3635) {
  if (($ret_len_0 | 0) == 0) {
   $retval_0 = 0;
   return $retval_0 | 0;
  }
  HEAP16[$read_buf + ($ret_len_0 << 1) >> 1] = 0;
  $retval_0 = $read_buf;
  return $retval_0 | 0;
 }
 $add26 = $i_032 + $ret_len_0 | 0;
 do {
  if (($add26 | 0) == 0) {
   label = 3642;
  } else {
   $arrayidx30 = $read_buf + ($add26 - 1 << 1) | 0;
   if ((HEAP16[$arrayidx30 >> 1] | 0) != 13) {
    label = 3642;
    break;
   }
   HEAP16[$arrayidx30 >> 1] = 0;
  }
 } while (0);
 if ((label | 0) == 3642) {
  HEAP16[$read_buf + ($add26 << 1) >> 1] = 0;
 }
 $inc = $i_032 + 1 | 0;
 $buffer_next_pos_40 = $this + 12 | 0;
 HEAP32[$buffer_next_pos_40 >> 2] = (HEAP32[$buffer_next_pos_40 >> 2] | 0) + $inc;
 HEAP32[$buffer_valid_len_ >> 2] = (HEAP32[$buffer_valid_len_ >> 2] | 0) - $inc;
 if ((HEAP32[$buffer_next_pos_40 >> 2] | 0) != (HEAP32[$this + 8 >> 2] | 0)) {
  $retval_0 = $read_buf;
  return $retval_0 | 0;
 }
 HEAP32[$buffer_next_pos_40 >> 2] = 0;
 HEAP32[$buffer_valid_len_ >> 2] = 0;
 $retval_0 = $read_buf;
 return $retval_0 | 0;
}
function __ZNSt9type_infoD2Ev($this) {
 $this = $this | 0;
 return;
}
function __ZNSt8bad_castD2Ev($this) {
 $this = $this | 0;
 return;
}
function __ZNKSt8bad_cast4whatEv($this) {
 $this = $this | 0;
 return 1888 | 0;
}
function __ZNSt10bad_typeidD2Ev($this) {
 $this = $this | 0;
 return;
}
function __ZNKSt10bad_typeid4whatEv($this) {
 $this = $this | 0;
 return 3800 | 0;
}
function __ZNK10__cxxabiv116__shim_type_info5noop1Ev($this) {
 $this = $this | 0;
 return;
}
function __ZNK10__cxxabiv116__shim_type_info5noop2Ev($this) {
 $this = $this | 0;
 return;
}
function _ConvertUTF32toUTF16($sourceStart, $sourceEnd, $targetStart, $targetEnd, $flags) {
 $sourceStart = $sourceStart | 0;
 $sourceEnd = $sourceEnd | 0;
 $targetStart = $targetStart | 0;
 $targetEnd = $targetEnd | 0;
 $flags = $flags | 0;
 var $0 = 0, $1 = 0, $cmp7 = 0, $cmp18 = 0, $target_0_ph39 = 0, $source_0_ph38 = 0, $result_0_ph37 = 0, $target_027 = 0, $source_026 = 0, $incdec_ptr = 0, $2 = 0, $add_ptr = 0, $sub = 0, $target_0_be = 0, $target_0_lcssa = 0, $source_0_lcssa = 0, $result_1 = 0;
 $0 = HEAP32[$sourceStart >> 2] | 0;
 $1 = HEAP32[$targetStart >> 2] | 0;
 L8 : do {
  if ($0 >>> 0 < $sourceEnd >>> 0) {
   $cmp7 = ($flags | 0) == 0;
   $cmp18 = ($flags | 0) == 0;
   $result_0_ph37 = 0;
   $source_0_ph38 = $0;
   $target_0_ph39 = $1;
   while (1) {
    $source_026 = $source_0_ph38;
    $target_027 = $target_0_ph39;
    L12 : while (1) {
     if ($target_027 >>> 0 >= $targetEnd >>> 0) {
      $result_1 = 2;
      $source_0_lcssa = $source_026;
      $target_0_lcssa = $target_027;
      break L8;
     }
     $incdec_ptr = $source_026 + 4 | 0;
     $2 = HEAP32[$source_026 >> 2] | 0;
     do {
      if ($2 >>> 0 < 65536) {
       if (($2 - 55296 | 0) >>> 0 >= 2048) {
        HEAP16[$target_027 >> 1] = $2 & 65535;
        $target_0_be = $target_027 + 2 | 0;
        break;
       }
       if ($cmp7) {
        $result_1 = 3;
        $source_0_lcssa = $source_026;
        $target_0_lcssa = $target_027;
        break L8;
       }
       HEAP16[$target_027 >> 1] = -3;
       $target_0_be = $target_027 + 2 | 0;
      } else {
       if ($2 >>> 0 > 1114111) {
        if ($cmp18) {
         break L12;
        }
        HEAP16[$target_027 >> 1] = -3;
        $target_0_be = $target_027 + 2 | 0;
        break;
       } else {
        $add_ptr = $target_027 + 2 | 0;
        if ($add_ptr >>> 0 >= $targetEnd >>> 0) {
         $result_1 = 2;
         $source_0_lcssa = $source_026;
         $target_0_lcssa = $target_027;
         break L8;
        }
        $sub = $2 - 65536 | 0;
        HEAP16[$target_027 >> 1] = ($sub >>> 10) + 55296 & 65535;
        HEAP16[$add_ptr >> 1] = ($sub & 1023 | 56320) & 65535;
        $target_0_be = $target_027 + 4 | 0;
        break;
       }
      }
     } while (0);
     if ($incdec_ptr >>> 0 < $sourceEnd >>> 0) {
      $source_026 = $incdec_ptr;
      $target_027 = $target_0_be;
     } else {
      $result_1 = $result_0_ph37;
      $source_0_lcssa = $incdec_ptr;
      $target_0_lcssa = $target_0_be;
      break L8;
     }
    }
    if ($incdec_ptr >>> 0 < $sourceEnd >>> 0) {
     $result_0_ph37 = 3;
     $source_0_ph38 = $incdec_ptr;
     $target_0_ph39 = $target_027;
    } else {
     $result_1 = 3;
     $source_0_lcssa = $incdec_ptr;
     $target_0_lcssa = $target_027;
     break;
    }
   }
  } else {
   $result_1 = 0;
   $source_0_lcssa = $0;
   $target_0_lcssa = $1;
  }
 } while (0);
 HEAP32[$sourceStart >> 2] = $source_0_lcssa;
 HEAP32[$targetStart >> 2] = $target_0_lcssa;
 return $result_1 | 0;
}
function _ConvertUTF16toUTF32($sourceStart, $sourceEnd, $targetStart, $targetEnd, $flags) {
 $sourceStart = $sourceStart | 0;
 $sourceEnd = $sourceEnd | 0;
 $targetStart = $targetStart | 0;
 $targetEnd = $targetEnd | 0;
 $flags = $flags | 0;
 var $0 = 0, $1 = 0, $cmp13 = 0, $cmp21 = 0, $source_028 = 0, $target_027 = 0, $incdec_ptr = 0, $2 = 0, $conv = 0, $4 = 0, $ch_0 = 0, $source_1 = 0, $incdec_ptr34 = 0, $source_0_lcssa = 0, $target_0_lcssa = 0, $result_0 = 0;
 $0 = HEAP32[$sourceStart >> 2] | 0;
 $1 = HEAP32[$targetStart >> 2] | 0;
 L31 : do {
  if ($0 >>> 0 < $sourceEnd >>> 0) {
   $cmp13 = ($flags | 0) == 0;
   $cmp21 = ($flags | 0) == 0;
   $target_027 = $1;
   $source_028 = $0;
   while (1) {
    $incdec_ptr = $source_028 + 2 | 0;
    $2 = HEAP16[$source_028 >> 1] | 0;
    $conv = $2 & 65535;
    do {
     if (($2 + 10240 & 65535) < 1024) {
      if ($incdec_ptr >>> 0 >= $sourceEnd >>> 0) {
       $result_0 = 1;
       $target_0_lcssa = $target_027;
       $source_0_lcssa = $source_028;
       break L31;
      }
      $4 = HEAP16[$incdec_ptr >> 1] | 0;
      if (($4 + 9216 & 65535) < 1024) {
       $source_1 = $source_028 + 4 | 0;
       $ch_0 = ($conv << 10) - 56613888 + ($4 & 65535) | 0;
       break;
      } else {
       if ($cmp13) {
        $result_0 = 3;
        $target_0_lcssa = $target_027;
        $source_0_lcssa = $source_028;
        break L31;
       } else {
        $source_1 = $incdec_ptr;
        $ch_0 = $conv;
        break;
       }
      }
     } else {
      if (!$cmp21) {
       $source_1 = $incdec_ptr;
       $ch_0 = $conv;
       break;
      }
      if (($2 + 9216 & 65535) < 1024) {
       $result_0 = 3;
       $target_0_lcssa = $target_027;
       $source_0_lcssa = $source_028;
       break L31;
      } else {
       $source_1 = $incdec_ptr;
       $ch_0 = $conv;
      }
     }
    } while (0);
    if ($target_027 >>> 0 >= $targetEnd >>> 0) {
     $result_0 = 2;
     $target_0_lcssa = $target_027;
     $source_0_lcssa = $source_028;
     break L31;
    }
    $incdec_ptr34 = $target_027 + 4 | 0;
    HEAP32[$target_027 >> 2] = $ch_0;
    if ($source_1 >>> 0 < $sourceEnd >>> 0) {
     $target_027 = $incdec_ptr34;
     $source_028 = $source_1;
    } else {
     $result_0 = 0;
     $target_0_lcssa = $incdec_ptr34;
     $source_0_lcssa = $source_1;
     break;
    }
   }
  } else {
   $result_0 = 0;
   $target_0_lcssa = $1;
   $source_0_lcssa = $0;
  }
 } while (0);
 HEAP32[$sourceStart >> 2] = $source_0_lcssa;
 HEAP32[$targetStart >> 2] = $target_0_lcssa;
 return $result_0 | 0;
}
function _ConvertUTF16toUTF8($sourceStart, $sourceEnd, $targetStart, $targetEnd, $flags) {
 $sourceStart = $sourceStart | 0;
 $sourceEnd = $sourceEnd | 0;
 $targetStart = $targetStart | 0;
 $targetEnd = $targetEnd | 0;
 $flags = $flags | 0;
 var $0 = 0, $1 = 0, $cmp13 = 0, $cmp21 = 0, $source_049 = 0, $target_048 = 0, $incdec_ptr = 0, $2 = 0, $conv = 0, $4 = 0, $ch_0 = 0, $source_1 = 0, $cmp40 = 0, $bytesToWrite_0 = 0, $ch_1 = 0, $add_ptr = 0, $incdec_ptr55 = 0, $ch_2 = 0, $target_1 = 0, $incdec_ptr60 = 0, $ch_3 = 0, $target_2 = 0, $incdec_ptr66 = 0, $ch_4 = 0, $target_3 = 0, $incdec_ptr72 = 0, $target_4 = 0, $add_ptr74 = 0, $source_0_lcssa = 0, $target_0_lcssa = 0, $result_0 = 0, label = 0;
 $0 = HEAP32[$sourceStart >> 2] | 0;
 $1 = HEAP32[$targetStart >> 2] | 0;
 L47 : do {
  if ($0 >>> 0 < $sourceEnd >>> 0) {
   $cmp13 = ($flags | 0) == 0;
   $cmp21 = ($flags | 0) == 0;
   $target_048 = $1;
   $source_049 = $0;
   while (1) {
    $incdec_ptr = $source_049 + 2 | 0;
    $2 = HEAP16[$source_049 >> 1] | 0;
    $conv = $2 & 65535;
    do {
     if (($2 + 10240 & 65535) < 1024) {
      if ($incdec_ptr >>> 0 >= $sourceEnd >>> 0) {
       $result_0 = 1;
       $target_0_lcssa = $target_048;
       $source_0_lcssa = $source_049;
       break L47;
      }
      $4 = HEAP16[$incdec_ptr >> 1] | 0;
      if (($4 + 9216 & 65535) < 1024) {
       $source_1 = $source_049 + 4 | 0;
       $ch_0 = ($conv << 10) - 56613888 + ($4 & 65535) | 0;
       break;
      } else {
       if ($cmp13) {
        $result_0 = 3;
        $target_0_lcssa = $target_048;
        $source_0_lcssa = $source_049;
        break L47;
       } else {
        $source_1 = $incdec_ptr;
        $ch_0 = $conv;
        break;
       }
      }
     } else {
      if (!$cmp21) {
       $source_1 = $incdec_ptr;
       $ch_0 = $conv;
       break;
      }
      if (($2 + 9216 & 65535) < 1024) {
       $result_0 = 3;
       $target_0_lcssa = $target_048;
       $source_0_lcssa = $source_049;
       break L47;
      } else {
       $source_1 = $incdec_ptr;
       $ch_0 = $conv;
      }
     }
    } while (0);
    do {
     if ($ch_0 >>> 0 < 128) {
      $ch_1 = $ch_0;
      $bytesToWrite_0 = 1;
     } else {
      if ($ch_0 >>> 0 < 2048) {
       $ch_1 = $ch_0;
       $bytesToWrite_0 = 2;
       break;
      }
      if ($ch_0 >>> 0 < 65536) {
       $ch_1 = $ch_0;
       $bytesToWrite_0 = 3;
       break;
      }
      $cmp40 = $ch_0 >>> 0 < 1114112;
      $ch_1 = $cmp40 ? $ch_0 : 65533;
      $bytesToWrite_0 = $cmp40 ? 4 : 3;
     }
    } while (0);
    $add_ptr = $target_048 + $bytesToWrite_0 | 0;
    if ($add_ptr >>> 0 > $targetEnd >>> 0) {
     $result_0 = 2;
     $target_0_lcssa = $target_048;
     $source_0_lcssa = $source_049;
     break L47;
    }
    if (($bytesToWrite_0 | 0) == 4) {
     $incdec_ptr55 = $target_048 + ($bytesToWrite_0 - 1) | 0;
     HEAP8[$incdec_ptr55] = ($ch_1 & 63 | 128) & 255;
     $target_1 = $incdec_ptr55;
     $ch_2 = $ch_1 >>> 6;
     label = 53;
    } else if (($bytesToWrite_0 | 0) == 3) {
     $target_1 = $add_ptr;
     $ch_2 = $ch_1;
     label = 53;
    } else if (($bytesToWrite_0 | 0) == 2) {
     $target_2 = $add_ptr;
     $ch_3 = $ch_1;
     label = 54;
    } else if (($bytesToWrite_0 | 0) == 1) {
     $target_3 = $add_ptr;
     $ch_4 = $ch_1;
     label = 55;
    } else {
     $target_4 = $add_ptr;
    }
    if ((label | 0) == 53) {
     label = 0;
     $incdec_ptr60 = $target_1 - 1 | 0;
     HEAP8[$incdec_ptr60] = ($ch_2 & 63 | 128) & 255;
     $target_2 = $incdec_ptr60;
     $ch_3 = $ch_2 >>> 6;
     label = 54;
    }
    if ((label | 0) == 54) {
     label = 0;
     $incdec_ptr66 = $target_2 - 1 | 0;
     HEAP8[$incdec_ptr66] = ($ch_3 & 63 | 128) & 255;
     $target_3 = $incdec_ptr66;
     $ch_4 = $ch_3 >>> 6;
     label = 55;
    }
    if ((label | 0) == 55) {
     label = 0;
     $incdec_ptr72 = $target_3 - 1 | 0;
     HEAP8[$incdec_ptr72] = (HEAPU8[11264 + $bytesToWrite_0 | 0] | 0 | $ch_4) & 255;
     $target_4 = $incdec_ptr72;
    }
    $add_ptr74 = $target_4 + $bytesToWrite_0 | 0;
    if ($source_1 >>> 0 < $sourceEnd >>> 0) {
     $target_048 = $add_ptr74;
     $source_049 = $source_1;
    } else {
     $result_0 = 0;
     $target_0_lcssa = $add_ptr74;
     $source_0_lcssa = $source_1;
     break;
    }
   }
  } else {
   $result_0 = 0;
   $target_0_lcssa = $1;
   $source_0_lcssa = $0;
  }
 } while (0);
 HEAP32[$sourceStart >> 2] = $source_0_lcssa;
 HEAP32[$targetStart >> 2] = $target_0_lcssa;
 return $result_0 | 0;
}
function __ZL11isLegalUTF8PKhi($source, $length) {
 $source = $source | 0;
 $length = $length | 0;
 var $add_ptr = 0, $incdec_ptr = 0, $0 = 0, $srcptr_0 = 0, $incdec_ptr4 = 0, $1 = 0, $srcptr_1 = 0, $2 = 0, $conv18 = 0, $4 = 0, $retval_0 = 0, label = 0;
 $add_ptr = $source + $length | 0;
 if (($length | 0) == 4) {
  $incdec_ptr = $source + ($length - 1) | 0;
  $0 = HEAP8[$incdec_ptr] | 0;
  if ($0 << 24 >> 24 > -1 | ($0 & 255) > 191) {
   $retval_0 = 0;
  } else {
   $srcptr_0 = $incdec_ptr;
   label = 60;
  }
 } else if (($length | 0) == 3) {
  $srcptr_0 = $add_ptr;
  label = 60;
 } else if (($length | 0) == 2) {
  $srcptr_1 = $add_ptr;
  label = 61;
 } else if (($length | 0) == 1) {
  label = 68;
 } else {
  $retval_0 = 0;
 }
 if ((label | 0) == 60) {
  $incdec_ptr4 = $srcptr_0 - 1 | 0;
  $1 = HEAP8[$incdec_ptr4] | 0;
  if ($1 << 24 >> 24 > -1 | ($1 & 255) > 191) {
   $retval_0 = 0;
  } else {
   $srcptr_1 = $incdec_ptr4;
   label = 61;
  }
 }
 do {
  if ((label | 0) == 61) {
   $2 = HEAP8[$srcptr_1 - 1 | 0] | 0;
   if (($2 & 255) > 191) {
    $retval_0 = 0;
    break;
   }
   $conv18 = HEAPU8[$source] | 0;
   if (($conv18 | 0) == 224) {
    if (($2 & 255) < 160) {
     $retval_0 = 0;
     break;
    } else {
     label = 68;
     break;
    }
   } else if (($conv18 | 0) == 237) {
    if (($2 & 255) > 159) {
     $retval_0 = 0;
     break;
    } else {
     label = 68;
     break;
    }
   } else if (($conv18 | 0) == 240) {
    if (($2 & 255) < 144) {
     $retval_0 = 0;
     break;
    } else {
     label = 68;
     break;
    }
   } else if (($conv18 | 0) == 244) {
    if (($2 & 255) > 143) {
     $retval_0 = 0;
     break;
    } else {
     label = 68;
     break;
    }
   } else {
    if ($2 << 24 >> 24 > -1) {
     $retval_0 = 0;
     break;
    } else {
     label = 68;
     break;
    }
   }
  }
 } while (0);
 do {
  if ((label | 0) == 68) {
   $4 = HEAP8[$source] | 0;
   if ($4 << 24 >> 24 < 0 & ($4 & 255) < 194) {
    $retval_0 = 0;
    break;
   }
   $retval_0 = ($4 & 255) < 245 | 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function _ConvertUTF32toUTF8($sourceStart, $sourceEnd, $targetStart, $targetEnd, $flags) {
 $sourceStart = $sourceStart | 0;
 $sourceEnd = $sourceEnd | 0;
 $targetStart = $targetStart | 0;
 $targetEnd = $targetEnd | 0;
 $flags = $flags | 0;
 var $0 = 0, $1 = 0, $cmp1 = 0, $result_036 = 0, $source_035 = 0, $target_034 = 0, $incdec_ptr = 0, $2 = 0, $cmp15 = 0, $ch_0 = 0, $bytesToWrite_0 = 0, $result_1 = 0, $add_ptr = 0, $incdec_ptr30 = 0, $target_1 = 0, $ch_1 = 0, $incdec_ptr35 = 0, $target_2 = 0, $ch_2 = 0, $incdec_ptr41 = 0, $target_3 = 0, $ch_3 = 0, $incdec_ptr47 = 0, $target_4 = 0, $add_ptr49 = 0, $source_0_lcssa = 0, $target_0_lcssa = 0, $result_2 = 0, label = 0;
 $0 = HEAP32[$sourceStart >> 2] | 0;
 $1 = HEAP32[$targetStart >> 2] | 0;
 L95 : do {
  if ($0 >>> 0 < $sourceEnd >>> 0) {
   $cmp1 = ($flags | 0) == 0;
   $target_034 = $1;
   $source_035 = $0;
   $result_036 = 0;
   while (1) {
    $incdec_ptr = $source_035 + 4 | 0;
    $2 = HEAP32[$source_035 >> 2] | 0;
    if ($cmp1) {
     if (($2 - 55296 | 0) >>> 0 < 2048) {
      $result_2 = 3;
      $target_0_lcssa = $target_034;
      $source_0_lcssa = $source_035;
      break L95;
     }
    }
    do {
     if ($2 >>> 0 < 128) {
      $result_1 = $result_036;
      $bytesToWrite_0 = 1;
      $ch_0 = $2;
     } else {
      if ($2 >>> 0 < 2048) {
       $result_1 = $result_036;
       $bytesToWrite_0 = 2;
       $ch_0 = $2;
       break;
      }
      if ($2 >>> 0 < 65536) {
       $result_1 = $result_036;
       $bytesToWrite_0 = 3;
       $ch_0 = $2;
       break;
      }
      $cmp15 = $2 >>> 0 < 1114112;
      $result_1 = $cmp15 ? $result_036 : 3;
      $bytesToWrite_0 = $cmp15 ? 4 : 3;
      $ch_0 = $cmp15 ? $2 : 65533;
     }
    } while (0);
    $add_ptr = $target_034 + $bytesToWrite_0 | 0;
    if ($add_ptr >>> 0 > $targetEnd >>> 0) {
     $result_2 = 2;
     $target_0_lcssa = $target_034;
     $source_0_lcssa = $source_035;
     break L95;
    }
    if (($bytesToWrite_0 | 0) == 4) {
     $incdec_ptr30 = $target_034 + ($bytesToWrite_0 - 1) | 0;
     HEAP8[$incdec_ptr30] = ($ch_0 & 63 | 128) & 255;
     $ch_1 = $ch_0 >>> 6;
     $target_1 = $incdec_ptr30;
     label = 82;
    } else if (($bytesToWrite_0 | 0) == 3) {
     $ch_1 = $ch_0;
     $target_1 = $add_ptr;
     label = 82;
    } else if (($bytesToWrite_0 | 0) == 2) {
     $ch_2 = $ch_0;
     $target_2 = $add_ptr;
     label = 83;
    } else if (($bytesToWrite_0 | 0) == 1) {
     $ch_3 = $ch_0;
     $target_3 = $add_ptr;
     label = 84;
    } else {
     $target_4 = $add_ptr;
    }
    if ((label | 0) == 82) {
     label = 0;
     $incdec_ptr35 = $target_1 - 1 | 0;
     HEAP8[$incdec_ptr35] = ($ch_1 & 63 | 128) & 255;
     $ch_2 = $ch_1 >>> 6;
     $target_2 = $incdec_ptr35;
     label = 83;
    }
    if ((label | 0) == 83) {
     label = 0;
     $incdec_ptr41 = $target_2 - 1 | 0;
     HEAP8[$incdec_ptr41] = ($ch_2 & 63 | 128) & 255;
     $ch_3 = $ch_2 >>> 6;
     $target_3 = $incdec_ptr41;
     label = 84;
    }
    if ((label | 0) == 84) {
     label = 0;
     $incdec_ptr47 = $target_3 - 1 | 0;
     HEAP8[$incdec_ptr47] = (HEAPU8[11264 + $bytesToWrite_0 | 0] | 0 | $ch_3) & 255;
     $target_4 = $incdec_ptr47;
    }
    $add_ptr49 = $target_4 + $bytesToWrite_0 | 0;
    if ($incdec_ptr >>> 0 < $sourceEnd >>> 0) {
     $target_034 = $add_ptr49;
     $source_035 = $incdec_ptr;
     $result_036 = $result_1;
    } else {
     $result_2 = $result_1;
     $target_0_lcssa = $add_ptr49;
     $source_0_lcssa = $incdec_ptr;
     break;
    }
   }
  } else {
   $result_2 = 0;
   $target_0_lcssa = $1;
   $source_0_lcssa = $0;
  }
 } while (0);
 HEAP32[$sourceStart >> 2] = $source_0_lcssa;
 HEAP32[$targetStart >> 2] = $target_0_lcssa;
 return $result_2 | 0;
}
function __ZNSt8bad_castC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8080;
 return;
}
function __ZNSt10bad_typeidC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8144;
 return;
}
function __ZN10ime_pinyin11Utf16Reader5closeEv($this) {
 $this = $this | 0;
 var $fp_ = 0, $0 = 0, $buffer_ = 0, $1 = 0;
 $fp_ = $this | 0;
 $0 = HEAP32[$fp_ >> 2] | 0;
 if (($0 | 0) != 0) {
  _fclose($0 | 0) | 0;
 }
 HEAP32[$fp_ >> 2] = 0;
 $buffer_ = $this + 4 | 0;
 $1 = HEAP32[$buffer_ >> 2] | 0;
 if (($1 | 0) == 0) {
  HEAP32[$buffer_ >> 2] = 0;
  return 1;
 }
 __ZdaPv($1);
 HEAP32[$buffer_ >> 2] = 0;
 return 1;
}
function _isLegalUTF8Sequence($source, $sourceEnd) {
 $source = $source | 0;
 $sourceEnd = $sourceEnd | 0;
 var $add = 0, $retval_0 = 0;
 $add = (HEAP8[10984 + (HEAPU8[$source] | 0) | 0] | 0) + 1 | 0;
 if (($source + $add | 0) >>> 0 > $sourceEnd >>> 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $retval_0 = __ZL11isLegalUTF8PKhi($source, $add) | 0;
 return $retval_0 | 0;
}
function _ConvertUTF8toUTF16($sourceStart, $sourceEnd, $targetStart, $targetEnd, $flags) {
 $sourceStart = $sourceStart | 0;
 $sourceEnd = $sourceEnd | 0;
 $targetStart = $targetStart | 0;
 $targetEnd = $targetEnd | 0;
 $flags = $flags | 0;
 var $0 = 0, $1 = 0, $cmp46 = 0, $cmp61 = 0, $target_070 = 0, $source_069 = 0, $idxprom = 0, $conv1 = 0, $source_1 = 0, $ch_0 = 0, $source_2 = 0, $ch_1 = 0, $source_3 = 0, $ch_2 = 0, $source_4 = 0, $ch_3 = 0, $source_5 = 0, $ch_4 = 0, $source_6 = 0, $ch_5 = 0, $sub = 0, $target_0_be = 0, $add_ptr71 = 0, $sub79 = 0, $target_061 = 0, $source_7 = 0, $result_0 = 0, label = 0;
 $0 = HEAP32[$sourceStart >> 2] | 0;
 $1 = HEAP32[$targetStart >> 2] | 0;
 L134 : do {
  if ($0 >>> 0 < $sourceEnd >>> 0) {
   $cmp46 = ($flags | 0) == 0;
   $cmp61 = ($flags | 0) == 0;
   $source_069 = $0;
   $target_070 = $1;
   L136 : while (1) {
    $idxprom = HEAPU8[$source_069] | 0;
    $conv1 = HEAP8[10984 + $idxprom | 0] & 65535;
    if (($source_069 + $conv1 | 0) >>> 0 >= $sourceEnd >>> 0) {
     $result_0 = 1;
     $source_7 = $source_069;
     $target_061 = $target_070;
     break L134;
    }
    if ((__ZL11isLegalUTF8PKhi($source_069, $conv1 + 1 | 0) | 0) << 24 >> 24 == 0) {
     $result_0 = 3;
     $source_7 = $source_069;
     $target_061 = $target_070;
     break L134;
    }
    if (($conv1 | 0) == 5) {
     $ch_0 = $idxprom << 6;
     $source_1 = $source_069 + 1 | 0;
     label = 107;
    } else if (($conv1 | 0) == 4) {
     $ch_0 = 0;
     $source_1 = $source_069;
     label = 107;
    } else if (($conv1 | 0) == 3) {
     $ch_1 = 0;
     $source_2 = $source_069;
     label = 108;
    } else if (($conv1 | 0) == 2) {
     $ch_2 = 0;
     $source_3 = $source_069;
     label = 109;
    } else if (($conv1 | 0) == 1) {
     $ch_3 = 0;
     $source_4 = $source_069;
     label = 110;
    } else if (($conv1 | 0) == 0) {
     $ch_4 = 0;
     $source_5 = $source_069;
     label = 111;
    } else {
     $ch_5 = 0;
     $source_6 = $source_069;
    }
    if ((label | 0) == 107) {
     label = 0;
     $ch_1 = (HEAPU8[$source_1] | 0) + $ch_0 << 6;
     $source_2 = $source_1 + 1 | 0;
     label = 108;
    }
    if ((label | 0) == 108) {
     label = 0;
     $ch_2 = (HEAPU8[$source_2] | 0) + $ch_1 << 6;
     $source_3 = $source_2 + 1 | 0;
     label = 109;
    }
    if ((label | 0) == 109) {
     label = 0;
     $ch_3 = (HEAPU8[$source_3] | 0) + $ch_2 << 6;
     $source_4 = $source_3 + 1 | 0;
     label = 110;
    }
    if ((label | 0) == 110) {
     label = 0;
     $ch_4 = (HEAPU8[$source_4] | 0) + $ch_3 << 6;
     $source_5 = $source_4 + 1 | 0;
     label = 111;
    }
    if ((label | 0) == 111) {
     label = 0;
     $ch_5 = (HEAPU8[$source_5] | 0) + $ch_4 | 0;
     $source_6 = $source_5 + 1 | 0;
    }
    $sub = $ch_5 - (HEAP32[11240 + ($conv1 << 2) >> 2] | 0) | 0;
    if ($target_070 >>> 0 >= $targetEnd >>> 0) {
     label = 113;
     break;
    }
    do {
     if ($sub >>> 0 < 65536) {
      if (($sub - 55296 | 0) >>> 0 >= 2048) {
       HEAP16[$target_070 >> 1] = $sub & 65535;
       $target_0_be = $target_070 + 2 | 0;
       break;
      }
      if ($cmp46) {
       label = 117;
       break L136;
      }
      HEAP16[$target_070 >> 1] = -3;
      $target_0_be = $target_070 + 2 | 0;
     } else {
      if ($sub >>> 0 > 1114111) {
       if ($cmp61) {
        label = 122;
        break L136;
       }
       HEAP16[$target_070 >> 1] = -3;
       $target_0_be = $target_070 + 2 | 0;
       break;
      } else {
       $add_ptr71 = $target_070 + 2 | 0;
       if ($add_ptr71 >>> 0 >= $targetEnd >>> 0) {
        label = 126;
        break L136;
       }
       $sub79 = $sub - 65536 | 0;
       HEAP16[$target_070 >> 1] = ($sub79 >>> 10) + 55296 & 65535;
       HEAP16[$add_ptr71 >> 1] = ($sub79 & 1023 | 56320) & 65535;
       $target_0_be = $target_070 + 4 | 0;
       break;
      }
     }
    } while (0);
    if ($source_6 >>> 0 < $sourceEnd >>> 0) {
     $source_069 = $source_6;
     $target_070 = $target_0_be;
    } else {
     $result_0 = 0;
     $source_7 = $source_6;
     $target_061 = $target_0_be;
     break L134;
    }
   }
   if ((label | 0) == 113) {
    $result_0 = 2;
    $source_7 = $source_6 + ~$conv1 | 0;
    $target_061 = $target_070;
    break;
   } else if ((label | 0) == 117) {
    $result_0 = 3;
    $source_7 = $source_6 + ~$conv1 | 0;
    $target_061 = $target_070;
    break;
   } else if ((label | 0) == 122) {
    $result_0 = 3;
    $source_7 = $source_6 + ~$conv1 | 0;
    $target_061 = $target_070;
    break;
   } else if ((label | 0) == 126) {
    $result_0 = 2;
    $source_7 = $source_6 + ~$conv1 | 0;
    $target_061 = $target_070;
    break;
   }
  } else {
   $result_0 = 0;
   $source_7 = $0;
   $target_061 = $1;
  }
 } while (0);
 HEAP32[$sourceStart >> 2] = $source_7;
 HEAP32[$targetStart >> 2] = $target_061;
 return $result_0 | 0;
}
function _ConvertUTF8toUTF32($sourceStart, $sourceEnd, $targetStart, $targetEnd, $flags) {
 $sourceStart = $sourceStart | 0;
 $sourceEnd = $sourceEnd | 0;
 $targetStart = $targetStart | 0;
 $targetEnd = $targetEnd | 0;
 $flags = $flags | 0;
 var $0 = 0, $1 = 0, $result_0_ph71 = 0, $target_0_ph70 = 0, $source_0_ph69 = 0, $target_053 = 0, $source_052 = 0, $idxprom = 0, $conv1 = 0, $source_1 = 0, $ch_0 = 0, $source_2 = 0, $ch_1 = 0, $source_3 = 0, $ch_2 = 0, $source_4 = 0, $ch_3 = 0, $source_5 = 0, $ch_4 = 0, $source_6 = 0, $ch_5 = 0, $sub = 0, $_not = 0, $target_0_be = 0, $incdec_ptr58 = 0, $target_046 = 0, $source_7 = 0, $result_1 = 0, label = 0;
 $0 = HEAP32[$sourceStart >> 2] | 0;
 $1 = HEAP32[$targetStart >> 2] | 0;
 L174 : do {
  if ($0 >>> 0 < $sourceEnd >>> 0) {
   $source_0_ph69 = $0;
   $target_0_ph70 = $1;
   $result_0_ph71 = 0;
   L176 : while (1) {
    $source_052 = $source_0_ph69;
    $target_053 = $target_0_ph70;
    while (1) {
     $idxprom = HEAPU8[$source_052] | 0;
     $conv1 = HEAP8[10984 + $idxprom | 0] & 65535;
     if (($source_052 + $conv1 | 0) >>> 0 >= $sourceEnd >>> 0) {
      $result_1 = 1;
      $source_7 = $source_052;
      $target_046 = $target_053;
      break L174;
     }
     if ((__ZL11isLegalUTF8PKhi($source_052, $conv1 + 1 | 0) | 0) << 24 >> 24 == 0) {
      $result_1 = 3;
      $source_7 = $source_052;
      $target_046 = $target_053;
      break L174;
     }
     if (($conv1 | 0) == 5) {
      $ch_0 = $idxprom << 6;
      $source_1 = $source_052 + 1 | 0;
      label = 136;
     } else if (($conv1 | 0) == 4) {
      $ch_0 = 0;
      $source_1 = $source_052;
      label = 136;
     } else if (($conv1 | 0) == 3) {
      $ch_1 = 0;
      $source_2 = $source_052;
      label = 137;
     } else if (($conv1 | 0) == 2) {
      $ch_2 = 0;
      $source_3 = $source_052;
      label = 138;
     } else if (($conv1 | 0) == 1) {
      $ch_3 = 0;
      $source_4 = $source_052;
      label = 139;
     } else if (($conv1 | 0) == 0) {
      $ch_4 = 0;
      $source_5 = $source_052;
      label = 140;
     } else {
      $ch_5 = 0;
      $source_6 = $source_052;
     }
     if ((label | 0) == 136) {
      label = 0;
      $ch_1 = (HEAPU8[$source_1] | 0) + $ch_0 << 6;
      $source_2 = $source_1 + 1 | 0;
      label = 137;
     }
     if ((label | 0) == 137) {
      label = 0;
      $ch_2 = (HEAPU8[$source_2] | 0) + $ch_1 << 6;
      $source_3 = $source_2 + 1 | 0;
      label = 138;
     }
     if ((label | 0) == 138) {
      label = 0;
      $ch_3 = (HEAPU8[$source_3] | 0) + $ch_2 << 6;
      $source_4 = $source_3 + 1 | 0;
      label = 139;
     }
     if ((label | 0) == 139) {
      label = 0;
      $ch_4 = (HEAPU8[$source_4] | 0) + $ch_3 << 6;
      $source_5 = $source_4 + 1 | 0;
      label = 140;
     }
     if ((label | 0) == 140) {
      label = 0;
      $ch_5 = (HEAPU8[$source_5] | 0) + $ch_4 | 0;
      $source_6 = $source_5 + 1 | 0;
     }
     $sub = $ch_5 - (HEAP32[11240 + ($conv1 << 2) >> 2] | 0) | 0;
     if ($target_053 >>> 0 >= $targetEnd >>> 0) {
      label = 142;
      break L176;
     }
     if ($sub >>> 0 >= 1114112) {
      break;
     }
     $_not = ($sub - 55296 | 0) >>> 0 > 2047;
     if (!($_not | ($flags | 0) != 0)) {
      label = 145;
      break L176;
     }
     $target_0_be = $target_053 + 4 | 0;
     HEAP32[$target_053 >> 2] = $_not ? $sub : 65533;
     if ($source_6 >>> 0 < $sourceEnd >>> 0) {
      $source_052 = $source_6;
      $target_053 = $target_0_be;
     } else {
      $result_1 = $result_0_ph71;
      $source_7 = $source_6;
      $target_046 = $target_0_be;
      break L174;
     }
    }
    $incdec_ptr58 = $target_053 + 4 | 0;
    HEAP32[$target_053 >> 2] = 65533;
    if ($source_6 >>> 0 < $sourceEnd >>> 0) {
     $source_0_ph69 = $source_6;
     $target_0_ph70 = $incdec_ptr58;
     $result_0_ph71 = 3;
    } else {
     $result_1 = 3;
     $source_7 = $source_6;
     $target_046 = $incdec_ptr58;
     break L174;
    }
   }
   if ((label | 0) == 142) {
    $result_1 = 2;
    $source_7 = $source_6 + ~$conv1 | 0;
    $target_046 = $target_053;
    break;
   } else if ((label | 0) == 145) {
    $result_1 = 3;
    $source_7 = $source_6 + ~$conv1 | 0;
    $target_046 = $target_053;
    break;
   }
  } else {
   $result_1 = 0;
   $source_7 = $0;
   $target_046 = $1;
  }
 } while (0);
 HEAP32[$sourceStart >> 2] = $source_7;
 HEAP32[$targetStart >> 2] = $target_046;
 return $result_1 | 0;
}
function __ZNSt9type_infoD0Ev($this) {
 $this = $this | 0;
 __ZdlPv($this);
 return;
}
function __ZNSt8bad_castD0Ev($this) {
 $this = $this | 0;
 __ZdlPv($this);
 return;
}
function __ZNSt10bad_typeidD0Ev($this) {
 $this = $this | 0;
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv116__shim_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv116__shim_type_infoD2Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 return;
}
function __ZN10__cxxabiv123__fundamental_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv117__array_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv120__function_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv116__enum_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZNK10__cxxabiv117__array_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $0, $1) {
 $this = $this | 0;
 $0 = $0 | 0;
 $1 = $1 | 0;
 return 0;
}
function __ZNK10__cxxabiv120__function_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $0, $1) {
 $this = $this | 0;
 $0 = $0 | 0;
 $1 = $1 | 0;
 return 0;
}
function __ZNK10__cxxabiv123__fundamental_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $thrown_type, $0) {
 $this = $this | 0;
 $thrown_type = $thrown_type | 0;
 $0 = $0 | 0;
 return ($this | 0) == ($thrown_type | 0) | 0;
}
function __ZNK10__cxxabiv116__enum_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $thrown_type, $0) {
 $this = $this | 0;
 $thrown_type = $thrown_type | 0;
 $0 = $0 | 0;
 return ($this | 0) == ($thrown_type | 0) | 0;
}
function __ZNK10__cxxabiv117__class_type_info24process_found_base_classEPNS_19__dynamic_cast_infoEPvi($this, $info, $adjustedPtr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $adjustedPtr = $adjustedPtr | 0;
 $path_below = $path_below | 0;
 var $dst_ptr_leading_to_static_ptr = 0, $0 = 0, $path_dst_ptr_to_static_ptr6 = 0, $number_to_static_ptr11 = 0;
 $dst_ptr_leading_to_static_ptr = $info + 16 | 0;
 $0 = HEAP32[$dst_ptr_leading_to_static_ptr >> 2] | 0;
 if (($0 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr >> 2] = $adjustedPtr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  return;
 }
 if (($0 | 0) != ($adjustedPtr | 0)) {
  $number_to_static_ptr11 = $info + 36 | 0;
  HEAP32[$number_to_static_ptr11 >> 2] = (HEAP32[$number_to_static_ptr11 >> 2] | 0) + 1;
  HEAP32[$info + 24 >> 2] = 2;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr6 = $info + 24 | 0;
 if ((HEAP32[$path_dst_ptr_to_static_ptr6 >> 2] | 0) != 2) {
  return;
 }
 HEAP32[$path_dst_ptr_to_static_ptr6 >> 2] = $path_below;
 return;
}
function __ZNK10__cxxabiv117__class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi($this, $info, $adjustedPtr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $adjustedPtr = $adjustedPtr | 0;
 $path_below = $path_below | 0;
 var $dst_ptr_leading_to_static_ptr_i = 0, $1 = 0, $path_dst_ptr_to_static_ptr6_i = 0, $number_to_static_ptr11_i = 0;
 if ((HEAP32[$info + 8 >> 2] | 0) != ($this | 0)) {
  return;
 }
 $dst_ptr_leading_to_static_ptr_i = $info + 16 | 0;
 $1 = HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] | 0;
 if (($1 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] = $adjustedPtr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  return;
 }
 if (($1 | 0) != ($adjustedPtr | 0)) {
  $number_to_static_ptr11_i = $info + 36 | 0;
  HEAP32[$number_to_static_ptr11_i >> 2] = (HEAP32[$number_to_static_ptr11_i >> 2] | 0) + 1;
  HEAP32[$info + 24 >> 2] = 2;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr6_i = $info + 24 | 0;
 if ((HEAP32[$path_dst_ptr_to_static_ptr6_i >> 2] | 0) != 2) {
  return;
 }
 HEAP32[$path_dst_ptr_to_static_ptr6_i >> 2] = $path_below;
 return;
}
function __ZNK10__cxxabiv117__pbase_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $thrown_type, $0) {
 $this = $this | 0;
 $thrown_type = $thrown_type | 0;
 $0 = $0 | 0;
 var $2 = 0;
 $2 = $thrown_type | 0;
 return ($this | 0) == ($2 | 0) | ($2 | 0) == 10880 | 0;
}
function __ZNK10__cxxabiv117__class_type_info29process_static_type_above_dstEPNS_19__dynamic_cast_infoEPKvS4_i($this, $info, $dst_ptr, $current_ptr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $dst_ptr = $dst_ptr | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 var $dst_ptr_leading_to_static_ptr = 0, $1 = 0, $path_dst_ptr_to_static_ptr12 = 0, $3 = 0, $4 = 0, $number_to_static_ptr26 = 0;
 HEAP8[$info + 53 | 0] = 1;
 if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
  return;
 }
 HEAP8[$info + 52 | 0] = 1;
 $dst_ptr_leading_to_static_ptr = $info + 16 | 0;
 $1 = HEAP32[$dst_ptr_leading_to_static_ptr >> 2] | 0;
 if (($1 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr >> 2] = $dst_ptr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($path_below | 0) == 1)) {
   return;
  }
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 if (($1 | 0) != ($dst_ptr | 0)) {
  $number_to_static_ptr26 = $info + 36 | 0;
  HEAP32[$number_to_static_ptr26 >> 2] = (HEAP32[$number_to_static_ptr26 >> 2] | 0) + 1;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr12 = $info + 24 | 0;
 $3 = HEAP32[$path_dst_ptr_to_static_ptr12 >> 2] | 0;
 if (($3 | 0) == 2) {
  HEAP32[$path_dst_ptr_to_static_ptr12 >> 2] = $path_below;
  $4 = $path_below;
 } else {
  $4 = $3;
 }
 if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($4 | 0) == 1)) {
  return;
 }
 HEAP8[$info + 54 | 0] = 1;
 return;
}
function __ZNK10__cxxabiv117__class_type_info29process_static_type_below_dstEPNS_19__dynamic_cast_infoEPKvi($this, $info, $current_ptr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 var $path_dynamic_ptr_to_static_ptr = 0;
 if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
  return;
 }
 $path_dynamic_ptr_to_static_ptr = $info + 28 | 0;
 if ((HEAP32[$path_dynamic_ptr_to_static_ptr >> 2] | 0) == 1) {
  return;
 }
 HEAP32[$path_dynamic_ptr_to_static_ptr >> 2] = $path_below;
 return;
}
function __ZN10__cxxabiv117__class_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv120__si_class_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv121__vmi_class_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv117__pbase_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv119__pointer_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZN10__cxxabiv129__pointer_to_member_type_infoD0Ev($this) {
 $this = $this | 0;
 __ZNSt9type_infoD2Ev($this | 0);
 __ZdlPv($this);
 return;
}
function __ZNK10__cxxabiv117__class_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $thrown_type, $adjustedPtr) {
 $this = $this | 0;
 $thrown_type = $thrown_type | 0;
 $adjustedPtr = $adjustedPtr | 0;
 var $info = 0, $4 = 0, $5 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 56 | 0;
 $info = sp | 0;
 if (($this | 0) == ($thrown_type | 0)) {
  $retval_0 = 1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 if (($thrown_type | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $4 = ___dynamic_cast($thrown_type, 10840, 10808, -1) | 0;
 $5 = $4;
 if (($4 | 0) == 0) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 _memset($info | 0, 0, 56);
 HEAP32[$info >> 2] = $5;
 HEAP32[$info + 8 >> 2] = $this;
 HEAP32[$info + 12 >> 2] = -1;
 HEAP32[$info + 48 >> 2] = 1;
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[$4 >> 2] | 0) + 28 >> 2] & 7]($5, $info, HEAP32[$adjustedPtr >> 2] | 0, 1);
 if ((HEAP32[$info + 24 >> 2] | 0) != 1) {
  $retval_0 = 0;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 HEAP32[$adjustedPtr >> 2] = HEAP32[$info + 16 >> 2];
 $retval_0 = 1;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __ZNK10__cxxabiv120__si_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi($this, $info, $adjustedPtr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $adjustedPtr = $adjustedPtr | 0;
 $path_below = $path_below | 0;
 var $dst_ptr_leading_to_static_ptr_i = 0, $3 = 0, $path_dst_ptr_to_static_ptr6_i = 0, $number_to_static_ptr11_i = 0, $6 = 0;
 if (($this | 0) != (HEAP32[$info + 8 >> 2] | 0)) {
  $6 = HEAP32[$this + 8 >> 2] | 0;
  FUNCTION_TABLE_viiii[HEAP32[(HEAP32[$6 >> 2] | 0) + 28 >> 2] & 7]($6, $info, $adjustedPtr, $path_below);
  return;
 }
 $dst_ptr_leading_to_static_ptr_i = $info + 16 | 0;
 $3 = HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] | 0;
 if (($3 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] = $adjustedPtr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  return;
 }
 if (($3 | 0) != ($adjustedPtr | 0)) {
  $number_to_static_ptr11_i = $info + 36 | 0;
  HEAP32[$number_to_static_ptr11_i >> 2] = (HEAP32[$number_to_static_ptr11_i >> 2] | 0) + 1;
  HEAP32[$info + 24 >> 2] = 2;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr6_i = $info + 24 | 0;
 if ((HEAP32[$path_dst_ptr_to_static_ptr6_i >> 2] | 0) != 2) {
  return;
 }
 HEAP32[$path_dst_ptr_to_static_ptr6_i >> 2] = $path_below;
 return;
}
function __ZNK10__cxxabiv122__base_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi($this, $info, $adjustedPtr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $adjustedPtr = $adjustedPtr | 0;
 $path_below = $path_below | 0;
 var $0 = 0, $shr = 0, $offset_to_base_0 = 0, $5 = 0;
 $0 = HEAP32[$this + 4 >> 2] | 0;
 $shr = $0 >> 8;
 if (($0 & 1 | 0) == 0) {
  $offset_to_base_0 = $shr;
 } else {
  $offset_to_base_0 = HEAP32[(HEAP32[$adjustedPtr >> 2] | 0) + $shr >> 2] | 0;
 }
 $5 = HEAP32[$this >> 2] | 0;
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[$5 >> 2] | 0) + 28 >> 2] & 7]($5, $info, $adjustedPtr + $offset_to_base_0 | 0, ($0 & 2 | 0) != 0 ? $path_below : 2);
 return;
}
function __ZNK10__cxxabiv121__vmi_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi($this, $info, $adjustedPtr, $path_below) {
 $this = $this | 0;
 $info = $info | 0;
 $adjustedPtr = $adjustedPtr | 0;
 $path_below = $path_below | 0;
 var $dst_ptr_leading_to_static_ptr_i = 0, $3 = 0, $path_dst_ptr_to_static_ptr6_i = 0, $number_to_static_ptr11_i = 0, $6 = 0, $add_ptr = 0, $7 = 0, $shr_i16 = 0, $offset_to_base_0_i21 = 0, $12 = 0, $search_done = 0, $15 = 0, $p_0 = 0, $16 = 0, $shr_i = 0, $offset_to_base_0_i = 0, $20 = 0, $incdec_ptr6 = 0, label = 0;
 if (($this | 0) == (HEAP32[$info + 8 >> 2] | 0)) {
  $dst_ptr_leading_to_static_ptr_i = $info + 16 | 0;
  $3 = HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] | 0;
  if (($3 | 0) == 0) {
   HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] = $adjustedPtr;
   HEAP32[$info + 24 >> 2] = $path_below;
   HEAP32[$info + 36 >> 2] = 1;
   return;
  }
  if (($3 | 0) != ($adjustedPtr | 0)) {
   $number_to_static_ptr11_i = $info + 36 | 0;
   HEAP32[$number_to_static_ptr11_i >> 2] = (HEAP32[$number_to_static_ptr11_i >> 2] | 0) + 1;
   HEAP32[$info + 24 >> 2] = 2;
   HEAP8[$info + 54 | 0] = 1;
   return;
  }
  $path_dst_ptr_to_static_ptr6_i = $info + 24 | 0;
  if ((HEAP32[$path_dst_ptr_to_static_ptr6_i >> 2] | 0) != 2) {
   return;
  }
  HEAP32[$path_dst_ptr_to_static_ptr6_i >> 2] = $path_below;
  return;
 }
 $6 = HEAP32[$this + 12 >> 2] | 0;
 $add_ptr = $this + 16 + ($6 << 3) | 0;
 $7 = HEAP32[$this + 20 >> 2] | 0;
 $shr_i16 = $7 >> 8;
 if (($7 & 1 | 0) == 0) {
  $offset_to_base_0_i21 = $shr_i16;
 } else {
  $offset_to_base_0_i21 = HEAP32[(HEAP32[$adjustedPtr >> 2] | 0) + $shr_i16 >> 2] | 0;
 }
 $12 = HEAP32[$this + 16 >> 2] | 0;
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[$12 >> 2] | 0) + 28 >> 2] & 7]($12, $info, $adjustedPtr + $offset_to_base_0_i21 | 0, ($7 & 2 | 0) != 0 ? $path_below : 2);
 if (($6 | 0) <= 1) {
  return;
 }
 $search_done = $info + 54 | 0;
 $15 = $adjustedPtr;
 $p_0 = $this + 24 | 0;
 while (1) {
  $16 = HEAP32[$p_0 + 4 >> 2] | 0;
  $shr_i = $16 >> 8;
  if (($16 & 1 | 0) == 0) {
   $offset_to_base_0_i = $shr_i;
  } else {
   $offset_to_base_0_i = HEAP32[(HEAP32[$15 >> 2] | 0) + $shr_i >> 2] | 0;
  }
  $20 = HEAP32[$p_0 >> 2] | 0;
  FUNCTION_TABLE_viiii[HEAP32[(HEAP32[$20 >> 2] | 0) + 28 >> 2] & 7]($20, $info, $adjustedPtr + $offset_to_base_0_i | 0, ($16 & 2 | 0) != 0 ? $path_below : 2);
  if ((HEAP8[$search_done] & 1) != 0) {
   label = 266;
   break;
  }
  $incdec_ptr6 = $p_0 + 8 | 0;
  if ($incdec_ptr6 >>> 0 < $add_ptr >>> 0) {
   $p_0 = $incdec_ptr6;
  } else {
   label = 267;
   break;
  }
 }
 if ((label | 0) == 266) {
  return;
 } else if ((label | 0) == 267) {
  return;
 }
}
function __ZNK10__cxxabiv119__pointer_type_info9can_catchEPKNS_16__shim_type_infoERPv($this, $thrown_type, $adjustedPtr) {
 $this = $this | 0;
 $thrown_type = $thrown_type | 0;
 $adjustedPtr = $adjustedPtr | 0;
 var $info = 0, $4 = 0, $7 = 0, $11 = 0, $13 = 0, $17 = 0, $19 = 0, $22 = 0, $23 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 56 | 0;
 $info = sp | 0;
 HEAP32[$adjustedPtr >> 2] = HEAP32[HEAP32[$adjustedPtr >> 2] >> 2];
 $4 = $thrown_type | 0;
 do {
  if (($this | 0) == ($4 | 0) | ($4 | 0) == 10880) {
   $retval_0 = 1;
  } else {
   if (($thrown_type | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   $7 = ___dynamic_cast($thrown_type, 10840, 10776, -1) | 0;
   if (($7 | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   if ((HEAP32[$7 + 8 >> 2] & ~HEAP32[$this + 8 >> 2] | 0) != 0) {
    $retval_0 = 0;
    break;
   }
   $11 = HEAP32[$this + 12 >> 2] | 0;
   $13 = $7 + 12 | 0;
   if (($11 | 0) == (HEAP32[$13 >> 2] | 0) | ($11 | 0) == 9912) {
    $retval_0 = 1;
    break;
   }
   if (($11 | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   $17 = ___dynamic_cast($11, 10840, 10808, -1) | 0;
   if (($17 | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   $19 = HEAP32[$13 >> 2] | 0;
   if (($19 | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   $22 = ___dynamic_cast($19, 10840, 10808, -1) | 0;
   $23 = $22;
   if (($22 | 0) == 0) {
    $retval_0 = 0;
    break;
   }
   _memset($info | 0, 0, 56);
   HEAP32[$info >> 2] = $23;
   HEAP32[$info + 8 >> 2] = $17;
   HEAP32[$info + 12 >> 2] = -1;
   HEAP32[$info + 48 >> 2] = 1;
   FUNCTION_TABLE_viiii[HEAP32[(HEAP32[$22 >> 2] | 0) + 28 >> 2] & 7]($23, $info, HEAP32[$adjustedPtr >> 2] | 0, 1);
   if ((HEAP32[$info + 24 >> 2] | 0) != 1) {
    $retval_0 = 0;
    break;
   }
   HEAP32[$adjustedPtr >> 2] = HEAP32[$info + 16 >> 2];
   $retval_0 = 1;
  }
 } while (0);
 STACKTOP = sp;
 return $retval_0 | 0;
}
function ___dynamic_cast($static_ptr, $static_type, $dst_type, $src2dst_offset) {
 $static_ptr = $static_ptr | 0;
 $static_type = $static_type | 0;
 $dst_type = $dst_type | 0;
 $src2dst_offset = $src2dst_offset | 0;
 var $info = 0, $1 = 0, $add_ptr = 0, $4 = 0, $5 = 0, $dst_ptr_leading_to_static_ptr = 0, $dst_ptr_not_leading_to_static_ptr = 0, $path_dst_ptr_to_static_ptr = 0, $path_dynamic_ptr_to_static_ptr = 0, $path_dynamic_ptr_to_dst_ptr = 0, $number_to_dst_ptr = 0, $14 = 0, $dst_ptr_0 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 56 | 0;
 $info = sp | 0;
 $1 = HEAP32[$static_ptr >> 2] | 0;
 $add_ptr = $static_ptr + (HEAP32[$1 - 8 >> 2] | 0) | 0;
 $4 = HEAP32[$1 - 4 >> 2] | 0;
 $5 = $4;
 HEAP32[$info >> 2] = $dst_type;
 HEAP32[$info + 4 >> 2] = $static_ptr;
 HEAP32[$info + 8 >> 2] = $static_type;
 HEAP32[$info + 12 >> 2] = $src2dst_offset;
 $dst_ptr_leading_to_static_ptr = $info + 16 | 0;
 $dst_ptr_not_leading_to_static_ptr = $info + 20 | 0;
 $path_dst_ptr_to_static_ptr = $info + 24 | 0;
 $path_dynamic_ptr_to_static_ptr = $info + 28 | 0;
 $path_dynamic_ptr_to_dst_ptr = $info + 32 | 0;
 $number_to_dst_ptr = $info + 40 | 0;
 _memset($dst_ptr_leading_to_static_ptr | 0, 0, 39);
 if (($4 | 0) == ($dst_type | 0)) {
  HEAP32[$info + 48 >> 2] = 1;
  FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$4 >> 2] | 0) + 20 >> 2] & 7]($5, $info, $add_ptr, $add_ptr, 1, 0);
  STACKTOP = sp;
  return ((HEAP32[$path_dst_ptr_to_static_ptr >> 2] | 0) == 1 ? $add_ptr : 0) | 0;
 }
 FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$4 >> 2] | 0) + 24 >> 2] & 7]($5, $info, $add_ptr, 1, 0);
 $14 = HEAP32[$info + 36 >> 2] | 0;
 if (($14 | 0) == 0) {
  if ((HEAP32[$number_to_dst_ptr >> 2] | 0) != 1) {
   $dst_ptr_0 = 0;
   STACKTOP = sp;
   return $dst_ptr_0 | 0;
  }
  if ((HEAP32[$path_dynamic_ptr_to_static_ptr >> 2] | 0) != 1) {
   $dst_ptr_0 = 0;
   STACKTOP = sp;
   return $dst_ptr_0 | 0;
  }
  $dst_ptr_0 = (HEAP32[$path_dynamic_ptr_to_dst_ptr >> 2] | 0) == 1 ? HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] | 0 : 0;
  STACKTOP = sp;
  return $dst_ptr_0 | 0;
 } else if (($14 | 0) == 1) {
  do {
   if ((HEAP32[$path_dst_ptr_to_static_ptr >> 2] | 0) != 1) {
    if ((HEAP32[$number_to_dst_ptr >> 2] | 0) != 0) {
     $dst_ptr_0 = 0;
     STACKTOP = sp;
     return $dst_ptr_0 | 0;
    }
    if ((HEAP32[$path_dynamic_ptr_to_static_ptr >> 2] | 0) != 1) {
     $dst_ptr_0 = 0;
     STACKTOP = sp;
     return $dst_ptr_0 | 0;
    }
    if ((HEAP32[$path_dynamic_ptr_to_dst_ptr >> 2] | 0) == 1) {
     break;
    } else {
     $dst_ptr_0 = 0;
    }
    STACKTOP = sp;
    return $dst_ptr_0 | 0;
   }
  } while (0);
  $dst_ptr_0 = HEAP32[$dst_ptr_leading_to_static_ptr >> 2] | 0;
  STACKTOP = sp;
  return $dst_ptr_0 | 0;
 } else {
  $dst_ptr_0 = 0;
  STACKTOP = sp;
  return $dst_ptr_0 | 0;
 }
 return 0;
}
function __ZNK10__cxxabiv117__class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib($this, $info, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $path_dynamic_ptr_to_static_ptr_i = 0, $dst_ptr_not_leading_to_static_ptr = 0, $number_to_dst_ptr = 0;
 if ((HEAP32[$info + 8 >> 2] | 0) == ($this | 0)) {
  if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
   return;
  }
  $path_dynamic_ptr_to_static_ptr_i = $info + 28 | 0;
  if ((HEAP32[$path_dynamic_ptr_to_static_ptr_i >> 2] | 0) == 1) {
   return;
  }
  HEAP32[$path_dynamic_ptr_to_static_ptr_i >> 2] = $path_below;
  return;
 }
 if ((HEAP32[$info >> 2] | 0) != ($this | 0)) {
  return;
 }
 do {
  if ((HEAP32[$info + 16 >> 2] | 0) != ($current_ptr | 0)) {
   $dst_ptr_not_leading_to_static_ptr = $info + 20 | 0;
   if ((HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] | 0) == ($current_ptr | 0)) {
    break;
   }
   HEAP32[$info + 32 >> 2] = $path_below;
   HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] = $current_ptr;
   $number_to_dst_ptr = $info + 40 | 0;
   HEAP32[$number_to_dst_ptr >> 2] = (HEAP32[$number_to_dst_ptr >> 2] | 0) + 1;
   do {
    if ((HEAP32[$info + 36 >> 2] | 0) == 1) {
     if ((HEAP32[$info + 24 >> 2] | 0) != 2) {
      break;
     }
     HEAP8[$info + 54 | 0] = 1;
    }
   } while (0);
   HEAP32[$info + 44 >> 2] = 4;
   return;
  }
 } while (0);
 if (($path_below | 0) != 1) {
  return;
 }
 HEAP32[$info + 32 >> 2] = 1;
 return;
}
function __ZNK10__cxxabiv121__vmi_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib($this, $info, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $0 = 0, $path_dynamic_ptr_to_static_ptr_i = 0, $dst_ptr_not_leading_to_static_ptr = 0, $is_dst_type_derived_from_static_type = 0, $10 = 0, $add_ptr = 0, $found_our_static_ptr = 0, $found_any_static_type = 0, $search_done = 0, $__flags34 = 0, $path_dst_ptr_to_static_ptr = 0, $11 = 0, $is_dst_type_derived_from_static_type13_0_off0140 = 0, $p_0139 = 0, $does_dst_type_point_to_our_static_type_0_off0138 = 0, $12 = 0, $shr_i107 = 0, $offset_to_base_0_i112 = 0, $16 = 0, $does_dst_type_point_to_our_static_type_1_off0 = 0, $is_dst_type_derived_from_static_type13_1_off0 = 0, $incdec_ptr = 0, $does_dst_type_point_to_our_static_type_0_off0_lcssa = 0, $is_dst_type_derived_from_static_type13_2_off0 = 0, $is_dst_type_derived_from_static_type13_2_off0146 = 0, $number_to_dst_ptr = 0, $is_dst_type_derived_from_static_type13_2_off0147 = 0, $33 = 0, $add_ptr64 = 0, $34 = 0, $shr_i121 = 0, $offset_to_base_0_i126 = 0, $39 = 0, $incdec_ptr69 = 0, $42 = 0, $number_to_static_ptr76 = 0, $search_done79 = 0, $44 = 0, $p65_0 = 0, $47 = 0, $shr_i92 = 0, $offset_to_base_0_i97 = 0, $51 = 0, $incdec_ptr84 = 0, $path_dst_ptr_to_static_ptr99 = 0, $search_done92 = 0, $54 = 0, $search_done110 = 0, $55 = 0, $p65_1 = 0, $60 = 0, $shr_i76 = 0, $offset_to_base_0_i81 = 0, $64 = 0, $incdec_ptr105 = 0, $p65_2 = 0, $70 = 0, $shr_i = 0, $offset_to_base_0_i = 0, $74 = 0, $incdec_ptr120 = 0, label = 0;
 $0 = $this | 0;
 if (($0 | 0) == (HEAP32[$info + 8 >> 2] | 0)) {
  if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
   return;
  }
  $path_dynamic_ptr_to_static_ptr_i = $info + 28 | 0;
  if ((HEAP32[$path_dynamic_ptr_to_static_ptr_i >> 2] | 0) == 1) {
   return;
  }
  HEAP32[$path_dynamic_ptr_to_static_ptr_i >> 2] = $path_below;
  return;
 }
 if (($0 | 0) == (HEAP32[$info >> 2] | 0)) {
  do {
   if ((HEAP32[$info + 16 >> 2] | 0) != ($current_ptr | 0)) {
    $dst_ptr_not_leading_to_static_ptr = $info + 20 | 0;
    if ((HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] | 0) == ($current_ptr | 0)) {
     break;
    }
    HEAP32[$info + 32 >> 2] = $path_below;
    $is_dst_type_derived_from_static_type = $info + 44 | 0;
    if ((HEAP32[$is_dst_type_derived_from_static_type >> 2] | 0) == 4) {
     return;
    }
    $10 = HEAP32[$this + 12 >> 2] | 0;
    $add_ptr = $this + 16 + ($10 << 3) | 0;
    L433 : do {
     if (($10 | 0) > 0) {
      $found_our_static_ptr = $info + 52 | 0;
      $found_any_static_type = $info + 53 | 0;
      $search_done = $info + 54 | 0;
      $__flags34 = $this + 8 | 0;
      $path_dst_ptr_to_static_ptr = $info + 24 | 0;
      $11 = $current_ptr;
      $does_dst_type_point_to_our_static_type_0_off0138 = 0;
      $p_0139 = $this + 16 | 0;
      $is_dst_type_derived_from_static_type13_0_off0140 = 0;
      L435 : while (1) {
       HEAP8[$found_our_static_ptr] = 0;
       HEAP8[$found_any_static_type] = 0;
       $12 = HEAP32[$p_0139 + 4 >> 2] | 0;
       $shr_i107 = $12 >> 8;
       if (($12 & 1 | 0) == 0) {
        $offset_to_base_0_i112 = $shr_i107;
       } else {
        $offset_to_base_0_i112 = HEAP32[(HEAP32[$11 >> 2] | 0) + $shr_i107 >> 2] | 0;
       }
       $16 = HEAP32[$p_0139 >> 2] | 0;
       FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$16 >> 2] | 0) + 20 >> 2] & 7]($16, $info, $current_ptr, $current_ptr + $offset_to_base_0_i112 | 0, 2 - ($12 >>> 1 & 1) | 0, $use_strcmp);
       if ((HEAP8[$search_done] & 1) != 0) {
        $is_dst_type_derived_from_static_type13_2_off0 = $is_dst_type_derived_from_static_type13_0_off0140;
        $does_dst_type_point_to_our_static_type_0_off0_lcssa = $does_dst_type_point_to_our_static_type_0_off0138;
        break;
       }
       do {
        if ((HEAP8[$found_any_static_type] & 1) == 0) {
         $is_dst_type_derived_from_static_type13_1_off0 = $is_dst_type_derived_from_static_type13_0_off0140;
         $does_dst_type_point_to_our_static_type_1_off0 = $does_dst_type_point_to_our_static_type_0_off0138;
        } else {
         if ((HEAP8[$found_our_static_ptr] & 1) == 0) {
          if ((HEAP32[$__flags34 >> 2] & 1 | 0) == 0) {
           $is_dst_type_derived_from_static_type13_2_off0 = 1;
           $does_dst_type_point_to_our_static_type_0_off0_lcssa = $does_dst_type_point_to_our_static_type_0_off0138;
           break L435;
          } else {
           $is_dst_type_derived_from_static_type13_1_off0 = 1;
           $does_dst_type_point_to_our_static_type_1_off0 = $does_dst_type_point_to_our_static_type_0_off0138;
           break;
          }
         }
         if ((HEAP32[$path_dst_ptr_to_static_ptr >> 2] | 0) == 1) {
          label = 347;
          break L433;
         }
         if ((HEAP32[$__flags34 >> 2] & 2 | 0) == 0) {
          label = 347;
          break L433;
         } else {
          $is_dst_type_derived_from_static_type13_1_off0 = 1;
          $does_dst_type_point_to_our_static_type_1_off0 = 1;
         }
        }
       } while (0);
       $incdec_ptr = $p_0139 + 8 | 0;
       if ($incdec_ptr >>> 0 < $add_ptr >>> 0) {
        $does_dst_type_point_to_our_static_type_0_off0138 = $does_dst_type_point_to_our_static_type_1_off0;
        $p_0139 = $incdec_ptr;
        $is_dst_type_derived_from_static_type13_0_off0140 = $is_dst_type_derived_from_static_type13_1_off0;
       } else {
        $is_dst_type_derived_from_static_type13_2_off0 = $is_dst_type_derived_from_static_type13_1_off0;
        $does_dst_type_point_to_our_static_type_0_off0_lcssa = $does_dst_type_point_to_our_static_type_1_off0;
        break;
       }
      }
      if ($does_dst_type_point_to_our_static_type_0_off0_lcssa) {
       $is_dst_type_derived_from_static_type13_2_off0147 = $is_dst_type_derived_from_static_type13_2_off0;
       label = 346;
      } else {
       $is_dst_type_derived_from_static_type13_2_off0146 = $is_dst_type_derived_from_static_type13_2_off0;
       label = 343;
      }
     } else {
      $is_dst_type_derived_from_static_type13_2_off0146 = 0;
      label = 343;
     }
    } while (0);
    do {
     if ((label | 0) == 343) {
      HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] = $current_ptr;
      $number_to_dst_ptr = $info + 40 | 0;
      HEAP32[$number_to_dst_ptr >> 2] = (HEAP32[$number_to_dst_ptr >> 2] | 0) + 1;
      if ((HEAP32[$info + 36 >> 2] | 0) != 1) {
       $is_dst_type_derived_from_static_type13_2_off0147 = $is_dst_type_derived_from_static_type13_2_off0146;
       label = 346;
       break;
      }
      if ((HEAP32[$info + 24 >> 2] | 0) != 2) {
       $is_dst_type_derived_from_static_type13_2_off0147 = $is_dst_type_derived_from_static_type13_2_off0146;
       label = 346;
       break;
      }
      HEAP8[$info + 54 | 0] = 1;
      if ($is_dst_type_derived_from_static_type13_2_off0146) {
       label = 347;
      } else {
       label = 348;
      }
     }
    } while (0);
    if ((label | 0) == 346) {
     if ($is_dst_type_derived_from_static_type13_2_off0147) {
      label = 347;
     } else {
      label = 348;
     }
    }
    if ((label | 0) == 347) {
     HEAP32[$is_dst_type_derived_from_static_type >> 2] = 3;
     return;
    } else if ((label | 0) == 348) {
     HEAP32[$is_dst_type_derived_from_static_type >> 2] = 4;
     return;
    }
   }
  } while (0);
  if (($path_below | 0) != 1) {
   return;
  }
  HEAP32[$info + 32 >> 2] = 1;
  return;
 }
 $33 = HEAP32[$this + 12 >> 2] | 0;
 $add_ptr64 = $this + 16 + ($33 << 3) | 0;
 $34 = HEAP32[$this + 20 >> 2] | 0;
 $shr_i121 = $34 >> 8;
 if (($34 & 1 | 0) == 0) {
  $offset_to_base_0_i126 = $shr_i121;
 } else {
  $offset_to_base_0_i126 = HEAP32[(HEAP32[$current_ptr >> 2] | 0) + $shr_i121 >> 2] | 0;
 }
 $39 = HEAP32[$this + 16 >> 2] | 0;
 FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$39 >> 2] | 0) + 24 >> 2] & 7]($39, $info, $current_ptr + $offset_to_base_0_i126 | 0, ($34 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
 $incdec_ptr69 = $this + 24 | 0;
 if (($33 | 0) <= 1) {
  return;
 }
 $42 = HEAP32[$this + 8 >> 2] | 0;
 do {
  if (($42 & 2 | 0) == 0) {
   $number_to_static_ptr76 = $info + 36 | 0;
   if ((HEAP32[$number_to_static_ptr76 >> 2] | 0) == 1) {
    break;
   }
   if (($42 & 1 | 0) == 0) {
    $search_done110 = $info + 54 | 0;
    $55 = $current_ptr;
    $p65_2 = $incdec_ptr69;
    while (1) {
     if ((HEAP8[$search_done110] & 1) != 0) {
      label = 388;
      break;
     }
     if ((HEAP32[$number_to_static_ptr76 >> 2] | 0) == 1) {
      label = 389;
      break;
     }
     $70 = HEAP32[$p65_2 + 4 >> 2] | 0;
     $shr_i = $70 >> 8;
     if (($70 & 1 | 0) == 0) {
      $offset_to_base_0_i = $shr_i;
     } else {
      $offset_to_base_0_i = HEAP32[(HEAP32[$55 >> 2] | 0) + $shr_i >> 2] | 0;
     }
     $74 = HEAP32[$p65_2 >> 2] | 0;
     FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$74 >> 2] | 0) + 24 >> 2] & 7]($74, $info, $current_ptr + $offset_to_base_0_i | 0, ($70 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
     $incdec_ptr120 = $p65_2 + 8 | 0;
     if ($incdec_ptr120 >>> 0 < $add_ptr64 >>> 0) {
      $p65_2 = $incdec_ptr120;
     } else {
      label = 390;
      break;
     }
    }
    if ((label | 0) == 388) {
     return;
    } else if ((label | 0) == 389) {
     return;
    } else if ((label | 0) == 390) {
     return;
    }
   }
   $path_dst_ptr_to_static_ptr99 = $info + 24 | 0;
   $search_done92 = $info + 54 | 0;
   $54 = $current_ptr;
   $p65_1 = $incdec_ptr69;
   while (1) {
    if ((HEAP8[$search_done92] & 1) != 0) {
     label = 385;
     break;
    }
    if ((HEAP32[$number_to_static_ptr76 >> 2] | 0) == 1) {
     if ((HEAP32[$path_dst_ptr_to_static_ptr99 >> 2] | 0) == 1) {
      label = 386;
      break;
     }
    }
    $60 = HEAP32[$p65_1 + 4 >> 2] | 0;
    $shr_i76 = $60 >> 8;
    if (($60 & 1 | 0) == 0) {
     $offset_to_base_0_i81 = $shr_i76;
    } else {
     $offset_to_base_0_i81 = HEAP32[(HEAP32[$54 >> 2] | 0) + $shr_i76 >> 2] | 0;
    }
    $64 = HEAP32[$p65_1 >> 2] | 0;
    FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$64 >> 2] | 0) + 24 >> 2] & 7]($64, $info, $current_ptr + $offset_to_base_0_i81 | 0, ($60 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
    $incdec_ptr105 = $p65_1 + 8 | 0;
    if ($incdec_ptr105 >>> 0 < $add_ptr64 >>> 0) {
     $p65_1 = $incdec_ptr105;
    } else {
     label = 387;
     break;
    }
   }
   if ((label | 0) == 385) {
    return;
   } else if ((label | 0) == 386) {
    return;
   } else if ((label | 0) == 387) {
    return;
   }
  }
 } while (0);
 $search_done79 = $info + 54 | 0;
 $44 = $current_ptr;
 $p65_0 = $incdec_ptr69;
 while (1) {
  if ((HEAP8[$search_done79] & 1) != 0) {
   label = 383;
   break;
  }
  $47 = HEAP32[$p65_0 + 4 >> 2] | 0;
  $shr_i92 = $47 >> 8;
  if (($47 & 1 | 0) == 0) {
   $offset_to_base_0_i97 = $shr_i92;
  } else {
   $offset_to_base_0_i97 = HEAP32[(HEAP32[$44 >> 2] | 0) + $shr_i92 >> 2] | 0;
  }
  $51 = HEAP32[$p65_0 >> 2] | 0;
  FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$51 >> 2] | 0) + 24 >> 2] & 7]($51, $info, $current_ptr + $offset_to_base_0_i97 | 0, ($47 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
  $incdec_ptr84 = $p65_0 + 8 | 0;
  if ($incdec_ptr84 >>> 0 < $add_ptr64 >>> 0) {
   $p65_0 = $incdec_ptr84;
  } else {
   label = 384;
   break;
  }
 }
 if ((label | 0) == 383) {
  return;
 } else if ((label | 0) == 384) {
  return;
 }
}
function __ZNK10__cxxabiv122__base_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib($this, $info, $dst_ptr, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $dst_ptr = $dst_ptr | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $0 = 0, $shr = 0, $offset_to_base_0 = 0, $5 = 0;
 $0 = HEAP32[$this + 4 >> 2] | 0;
 $shr = $0 >> 8;
 if (($0 & 1 | 0) == 0) {
  $offset_to_base_0 = $shr;
 } else {
  $offset_to_base_0 = HEAP32[(HEAP32[$current_ptr >> 2] | 0) + $shr >> 2] | 0;
 }
 $5 = HEAP32[$this >> 2] | 0;
 FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$5 >> 2] | 0) + 20 >> 2] & 7]($5, $info, $dst_ptr, $current_ptr + $offset_to_base_0 | 0, ($0 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
 return;
}
function __ZNK10__cxxabiv122__base_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib($this, $info, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $0 = 0, $shr = 0, $offset_to_base_0 = 0, $5 = 0;
 $0 = HEAP32[$this + 4 >> 2] | 0;
 $shr = $0 >> 8;
 if (($0 & 1 | 0) == 0) {
  $offset_to_base_0 = $shr;
 } else {
  $offset_to_base_0 = HEAP32[(HEAP32[$current_ptr >> 2] | 0) + $shr >> 2] | 0;
 }
 $5 = HEAP32[$this >> 2] | 0;
 FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$5 >> 2] | 0) + 24 >> 2] & 7]($5, $info, $current_ptr + $offset_to_base_0 | 0, ($0 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
 return;
}
function __ZNK10__cxxabiv120__si_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib($this, $info, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $0 = 0, $path_dynamic_ptr_to_static_ptr_i = 0, $dst_ptr_not_leading_to_static_ptr = 0, $is_dst_type_derived_from_static_type = 0, $found_our_static_ptr = 0, $found_any_static_type = 0, $10 = 0, $is_dst_type_derived_from_static_type13_0_off034 = 0, $number_to_dst_ptr = 0, $20 = 0, label = 0;
 $0 = $this | 0;
 if (($0 | 0) == (HEAP32[$info + 8 >> 2] | 0)) {
  if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
   return;
  }
  $path_dynamic_ptr_to_static_ptr_i = $info + 28 | 0;
  if ((HEAP32[$path_dynamic_ptr_to_static_ptr_i >> 2] | 0) == 1) {
   return;
  }
  HEAP32[$path_dynamic_ptr_to_static_ptr_i >> 2] = $path_below;
  return;
 }
 if (($0 | 0) != (HEAP32[$info >> 2] | 0)) {
  $20 = HEAP32[$this + 8 >> 2] | 0;
  FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[$20 >> 2] | 0) + 24 >> 2] & 7]($20, $info, $current_ptr, $path_below, $use_strcmp);
  return;
 }
 do {
  if ((HEAP32[$info + 16 >> 2] | 0) != ($current_ptr | 0)) {
   $dst_ptr_not_leading_to_static_ptr = $info + 20 | 0;
   if ((HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] | 0) == ($current_ptr | 0)) {
    break;
   }
   HEAP32[$info + 32 >> 2] = $path_below;
   $is_dst_type_derived_from_static_type = $info + 44 | 0;
   if ((HEAP32[$is_dst_type_derived_from_static_type >> 2] | 0) == 4) {
    return;
   }
   $found_our_static_ptr = $info + 52 | 0;
   HEAP8[$found_our_static_ptr] = 0;
   $found_any_static_type = $info + 53 | 0;
   HEAP8[$found_any_static_type] = 0;
   $10 = HEAP32[$this + 8 >> 2] | 0;
   FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$10 >> 2] | 0) + 20 >> 2] & 7]($10, $info, $current_ptr, $current_ptr, 1, $use_strcmp);
   if ((HEAP8[$found_any_static_type] & 1) == 0) {
    $is_dst_type_derived_from_static_type13_0_off034 = 0;
    label = 409;
   } else {
    if ((HEAP8[$found_our_static_ptr] & 1) == 0) {
     $is_dst_type_derived_from_static_type13_0_off034 = 1;
     label = 409;
    }
   }
   L543 : do {
    if ((label | 0) == 409) {
     HEAP32[$dst_ptr_not_leading_to_static_ptr >> 2] = $current_ptr;
     $number_to_dst_ptr = $info + 40 | 0;
     HEAP32[$number_to_dst_ptr >> 2] = (HEAP32[$number_to_dst_ptr >> 2] | 0) + 1;
     do {
      if ((HEAP32[$info + 36 >> 2] | 0) == 1) {
       if ((HEAP32[$info + 24 >> 2] | 0) != 2) {
        label = 412;
        break;
       }
       HEAP8[$info + 54 | 0] = 1;
       if ($is_dst_type_derived_from_static_type13_0_off034) {
        break L543;
       }
      } else {
       label = 412;
      }
     } while (0);
     if ((label | 0) == 412) {
      if ($is_dst_type_derived_from_static_type13_0_off034) {
       break;
      }
     }
     HEAP32[$is_dst_type_derived_from_static_type >> 2] = 4;
     return;
    }
   } while (0);
   HEAP32[$is_dst_type_derived_from_static_type >> 2] = 3;
   return;
  }
 } while (0);
 if (($path_below | 0) != 1) {
  return;
 }
 HEAP32[$info + 32 >> 2] = 1;
 return;
}
function __ZNK10__cxxabiv121__vmi_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib($this, $info, $dst_ptr, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $dst_ptr = $dst_ptr | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $dst_ptr_leading_to_static_ptr_i = 0, $4 = 0, $path_dst_ptr_to_static_ptr12_i = 0, $6 = 0, $7 = 0, $number_to_static_ptr26_i = 0, $found_our_static_ptr2 = 0, $11 = 0, $found_any_static_type5 = 0, $13 = 0, $14 = 0, $add_ptr = 0, $15 = 0, $shr_i30 = 0, $offset_to_base_0_i35 = 0, $20 = 0, $path_dst_ptr_to_static_ptr = 0, $__flags = 0, $search_done = 0, $23 = 0, $p_0 = 0, $33 = 0, $shr_i = 0, $offset_to_base_0_i = 0, $37 = 0;
 if (($this | 0) != (HEAP32[$info + 8 >> 2] | 0)) {
  $found_our_static_ptr2 = $info + 52 | 0;
  $11 = HEAP8[$found_our_static_ptr2] & 1;
  $found_any_static_type5 = $info + 53 | 0;
  $13 = HEAP8[$found_any_static_type5] & 1;
  $14 = HEAP32[$this + 12 >> 2] | 0;
  $add_ptr = $this + 16 + ($14 << 3) | 0;
  HEAP8[$found_our_static_ptr2] = 0;
  HEAP8[$found_any_static_type5] = 0;
  $15 = HEAP32[$this + 20 >> 2] | 0;
  $shr_i30 = $15 >> 8;
  if (($15 & 1 | 0) == 0) {
   $offset_to_base_0_i35 = $shr_i30;
  } else {
   $offset_to_base_0_i35 = HEAP32[(HEAP32[$current_ptr >> 2] | 0) + $shr_i30 >> 2] | 0;
  }
  $20 = HEAP32[$this + 16 >> 2] | 0;
  FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$20 >> 2] | 0) + 20 >> 2] & 7]($20, $info, $dst_ptr, $current_ptr + $offset_to_base_0_i35 | 0, ($15 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
  L565 : do {
   if (($14 | 0) > 1) {
    $path_dst_ptr_to_static_ptr = $info + 24 | 0;
    $__flags = $this + 8 | 0;
    $search_done = $info + 54 | 0;
    $23 = $current_ptr;
    $p_0 = $this + 24 | 0;
    do {
     if ((HEAP8[$search_done] & 1) != 0) {
      break L565;
     }
     do {
      if ((HEAP8[$found_our_static_ptr2] & 1) == 0) {
       if ((HEAP8[$found_any_static_type5] & 1) == 0) {
        break;
       }
       if ((HEAP32[$__flags >> 2] & 1 | 0) == 0) {
        break L565;
       }
      } else {
       if ((HEAP32[$path_dst_ptr_to_static_ptr >> 2] | 0) == 1) {
        break L565;
       }
       if ((HEAP32[$__flags >> 2] & 2 | 0) == 0) {
        break L565;
       }
      }
     } while (0);
     HEAP8[$found_our_static_ptr2] = 0;
     HEAP8[$found_any_static_type5] = 0;
     $33 = HEAP32[$p_0 + 4 >> 2] | 0;
     $shr_i = $33 >> 8;
     if (($33 & 1 | 0) == 0) {
      $offset_to_base_0_i = $shr_i;
     } else {
      $offset_to_base_0_i = HEAP32[(HEAP32[$23 >> 2] | 0) + $shr_i >> 2] | 0;
     }
     $37 = HEAP32[$p_0 >> 2] | 0;
     FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$37 >> 2] | 0) + 20 >> 2] & 7]($37, $info, $dst_ptr, $current_ptr + $offset_to_base_0_i | 0, ($33 & 2 | 0) != 0 ? $path_below : 2, $use_strcmp);
     $p_0 = $p_0 + 8 | 0;
    } while ($p_0 >>> 0 < $add_ptr >>> 0);
   }
  } while (0);
  HEAP8[$found_our_static_ptr2] = $11;
  HEAP8[$found_any_static_type5] = $13;
  return;
 }
 HEAP8[$info + 53 | 0] = 1;
 if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
  return;
 }
 HEAP8[$info + 52 | 0] = 1;
 $dst_ptr_leading_to_static_ptr_i = $info + 16 | 0;
 $4 = HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] | 0;
 if (($4 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] = $dst_ptr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($path_below | 0) == 1)) {
   return;
  }
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 if (($4 | 0) != ($dst_ptr | 0)) {
  $number_to_static_ptr26_i = $info + 36 | 0;
  HEAP32[$number_to_static_ptr26_i >> 2] = (HEAP32[$number_to_static_ptr26_i >> 2] | 0) + 1;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr12_i = $info + 24 | 0;
 $6 = HEAP32[$path_dst_ptr_to_static_ptr12_i >> 2] | 0;
 if (($6 | 0) == 2) {
  HEAP32[$path_dst_ptr_to_static_ptr12_i >> 2] = $path_below;
  $7 = $path_below;
 } else {
  $7 = $6;
 }
 if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($7 | 0) == 1)) {
  return;
 }
 HEAP8[$info + 54 | 0] = 1;
 return;
}
function __ZNK10__cxxabiv120__si_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib($this, $info, $dst_ptr, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $dst_ptr = $dst_ptr | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $dst_ptr_leading_to_static_ptr_i = 0, $4 = 0, $path_dst_ptr_to_static_ptr12_i = 0, $6 = 0, $7 = 0, $number_to_static_ptr26_i = 0, $10 = 0;
 if (($this | 0) != (HEAP32[$info + 8 >> 2] | 0)) {
  $10 = HEAP32[$this + 8 >> 2] | 0;
  FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[$10 >> 2] | 0) + 20 >> 2] & 7]($10, $info, $dst_ptr, $current_ptr, $path_below, $use_strcmp);
  return;
 }
 HEAP8[$info + 53 | 0] = 1;
 if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
  return;
 }
 HEAP8[$info + 52 | 0] = 1;
 $dst_ptr_leading_to_static_ptr_i = $info + 16 | 0;
 $4 = HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] | 0;
 if (($4 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] = $dst_ptr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($path_below | 0) == 1)) {
   return;
  }
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 if (($4 | 0) != ($dst_ptr | 0)) {
  $number_to_static_ptr26_i = $info + 36 | 0;
  HEAP32[$number_to_static_ptr26_i >> 2] = (HEAP32[$number_to_static_ptr26_i >> 2] | 0) + 1;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr12_i = $info + 24 | 0;
 $6 = HEAP32[$path_dst_ptr_to_static_ptr12_i >> 2] | 0;
 if (($6 | 0) == 2) {
  HEAP32[$path_dst_ptr_to_static_ptr12_i >> 2] = $path_below;
  $7 = $path_below;
 } else {
  $7 = $6;
 }
 if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($7 | 0) == 1)) {
  return;
 }
 HEAP8[$info + 54 | 0] = 1;
 return;
}
function __ZNK10__cxxabiv117__class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib($this, $info, $dst_ptr, $current_ptr, $path_below, $use_strcmp) {
 $this = $this | 0;
 $info = $info | 0;
 $dst_ptr = $dst_ptr | 0;
 $current_ptr = $current_ptr | 0;
 $path_below = $path_below | 0;
 $use_strcmp = $use_strcmp | 0;
 var $dst_ptr_leading_to_static_ptr_i = 0, $2 = 0, $path_dst_ptr_to_static_ptr12_i = 0, $4 = 0, $5 = 0, $number_to_static_ptr26_i = 0;
 if ((HEAP32[$info + 8 >> 2] | 0) != ($this | 0)) {
  return;
 }
 HEAP8[$info + 53 | 0] = 1;
 if ((HEAP32[$info + 4 >> 2] | 0) != ($current_ptr | 0)) {
  return;
 }
 HEAP8[$info + 52 | 0] = 1;
 $dst_ptr_leading_to_static_ptr_i = $info + 16 | 0;
 $2 = HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] | 0;
 if (($2 | 0) == 0) {
  HEAP32[$dst_ptr_leading_to_static_ptr_i >> 2] = $dst_ptr;
  HEAP32[$info + 24 >> 2] = $path_below;
  HEAP32[$info + 36 >> 2] = 1;
  if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($path_below | 0) == 1)) {
   return;
  }
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 if (($2 | 0) != ($dst_ptr | 0)) {
  $number_to_static_ptr26_i = $info + 36 | 0;
  HEAP32[$number_to_static_ptr26_i >> 2] = (HEAP32[$number_to_static_ptr26_i >> 2] | 0) + 1;
  HEAP8[$info + 54 | 0] = 1;
  return;
 }
 $path_dst_ptr_to_static_ptr12_i = $info + 24 | 0;
 $4 = HEAP32[$path_dst_ptr_to_static_ptr12_i >> 2] | 0;
 if (($4 | 0) == 2) {
  HEAP32[$path_dst_ptr_to_static_ptr12_i >> 2] = $path_below;
  $5 = $path_below;
 } else {
  $5 = $4;
 }
 if (!((HEAP32[$info + 48 >> 2] | 0) == 1 & ($5 | 0) == 1)) {
  return;
 }
 HEAP8[$info + 54 | 0] = 1;
 return;
}
function _malloc($bytes) {
 $bytes = $bytes | 0;
 var $cond = 0, $shr = 0, $0 = 0, $shr3 = 0, $add8 = 0, $shl = 0, $1 = 0, $2 = 0, $3 = 0, $fd9 = 0, $4 = 0, $bk = 0, $shl22 = 0, $9 = 0, $shl37 = 0, $and41 = 0, $sub44 = 0, $and46 = 0, $shr47 = 0, $and49 = 0, $shr51 = 0, $and53 = 0, $shr55 = 0, $and57 = 0, $shr59 = 0, $and61 = 0, $add64 = 0, $shl65 = 0, $13 = 0, $14 = 0, $15 = 0, $fd69 = 0, $16 = 0, $bk78 = 0, $shl90 = 0, $sub91 = 0, $20 = 0, $21 = 0, $23 = 0, $24 = 0, $shr101 = 0, $shl102 = 0, $25 = 0, $26 = 0, $shl105 = 0, $27 = 0, $28 = 0, $_pre_phi = 0, $F104_0 = 0, $32 = 0, $sub2_i = 0, $and3_i = 0, $shr4_i = 0, $and6_i = 0, $shr7_i = 0, $and9_i = 0, $shr11_i = 0, $and13_i = 0, $shr15_i = 0, $and17_i = 0, $33 = 0, $rsize_0_i = 0, $v_0_i = 0, $t_0_i = 0, $35 = 0, $36 = 0, $cond7_i = 0, $sub31_i = 0, $cmp32_i = 0, $38 = 0, $39 = 0, $add_ptr_i = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $bk47_i = 0, $fd50_i = 0, $arrayidx61_i = 0, $47 = 0, $arrayidx65_i = 0, $48 = 0, $RP_0_i = 0, $R_0_i = 0, $arrayidx71_i = 0, $49 = 0, $arrayidx75_i = 0, $50 = 0, $R_1_i = 0, $index_i = 0, $arrayidx94_i = 0, $arrayidx113_i = 0, $61 = 0, $64 = 0, $add177_i = 0, $67 = 0, $70 = 0, $71 = 0, $shr194_i = 0, $shl195_i = 0, $72 = 0, $73 = 0, $shl198_i = 0, $74 = 0, $75 = 0, $_pre_phi_i = 0, $F197_0_i = 0, $add_ptr225_i = 0, $add143 = 0, $and144 = 0, $79 = 0, $sub_i107 = 0, $shr_i108 = 0, $and_i112 = 0, $shl_i113 = 0, $and8_i = 0, $shl9_i = 0, $and12_i = 0, $add17_i = 0, $idx_0_i = 0, $80 = 0, $cond_i = 0, $rst_0_i = 0, $sizebits_0_i = 0, $t_0_i121 = 0, $rsize_0_i122 = 0, $v_0_i123 = 0, $and32_i = 0, $sub33_i = 0, $rsize_1_i = 0, $v_1_i = 0, $82 = 0, $83 = 0, $rst_1_i = 0, $t_1_i = 0, $rsize_2_i = 0, $v_2_i = 0, $shl59_i = 0, $and63_i = 0, $sub69_i = 0, $and72_i = 0, $shr74_i = 0, $and76_i = 0, $shr78_i = 0, $and80_i = 0, $shr82_i = 0, $and84_i = 0, $shr86_i = 0, $and88_i = 0, $t_2_ph_i = 0, $v_326_i = 0, $rsize_325_i = 0, $t_224_i = 0, $sub100_i = 0, $cmp101_i = 0, $sub100_rsize_3_i = 0, $t_2_v_3_i = 0, $86 = 0, $87 = 0, $v_3_lcssa_i = 0, $rsize_3_lcssa_i = 0, $89 = 0, $90 = 0, $add_ptr_i128 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $bk135_i = 0, $fd138_i = 0, $arrayidx150_i = 0, $98 = 0, $arrayidx154_i133 = 0, $99 = 0, $RP_0_i136 = 0, $R_0_i137 = 0, $arrayidx160_i = 0, $100 = 0, $arrayidx164_i = 0, $101 = 0, $R_1_i139 = 0, $index_i140 = 0, $arrayidx183_i = 0, $arrayidx203_i = 0, $112 = 0, $115 = 0, $add267_i = 0, $118 = 0, $shr282_i = 0, $shl287_i = 0, $121 = 0, $122 = 0, $shl290_i = 0, $123 = 0, $124 = 0, $_pre_phi_i147 = 0, $F289_0_i = 0, $129 = 0, $shr317_i = 0, $and330_i = 0, $shl332_i = 0, $and335_i = 0, $shl337_i = 0, $and340_i = 0, $add345_i = 0, $I315_0_i = 0, $arrayidx354_i = 0, $132 = 0, $shl361_i = 0, $cond382_i = 0, $T_0_i = 0, $K372_0_i = 0, $arrayidx393_i = 0, $139 = 0, $fd412_i = 0, $145 = 0, $147 = 0, $add_ptr436_i = 0, $nb_0 = 0, $153 = 0, $sub159 = 0, $154 = 0, $155 = 0, $159 = 0, $162 = 0, $sub187 = 0, $163 = 0, $164 = 0, $call_i_i = 0, $add_i149 = 0, $169 = 0, $sub_i150 = 0, $add9_i = 0, $neg_i151 = 0, $and11_i = 0, $170 = 0, $171 = 0, $add17_i152 = 0, $173 = 0, $174 = 0, $sp_0_i_i = 0, $base_i_i = 0, $175 = 0, $size_i_i = 0, $177 = 0, $call34_i = 0, $178 = 0, $179 = 0, $sub38_i = 0, $ssize_0_i = 0, $180 = 0, $add51_i = 0, $181 = 0, $call65_i = 0, $cmp66_i160 = 0, $and77_i = 0, $call80_i = 0, $cmp82_i = 0, $ssize_1_i = 0, $br_0_i = 0, $tsize_0_i = 0, $tbase_0_i = 0, $sub109_i = 0, $185 = 0, $and101_i = 0, $ssize_2_i = 0, $tsize_0758385_i = 0, $tsize_1_i = 0, $call128_i = 0, $call129_i = 0, $sub_ptr_sub_i = 0, $cmp138_i166 = 0, $call128_tbase_1_i = 0, $tbase_292_i = 0, $tsize_291_i = 0, $add147_i = 0, $189 = 0, $190 = 0, $i_02_i_i = 0, $shl_i_i = 0, $192 = 0, $195 = 0, $cond_i_i = 0, $sub5_i_i = 0, $sp_0105_i = 0, $201 = 0, $size185_i = 0, $202 = 0, $203 = 0, $205 = 0, $206 = 0, $add212_i = 0, $208 = 0, $209 = 0, $cond_i28_i = 0, $sub5_i30_i = 0, $add_ptr224_i = 0, $sp_1101_i = 0, $base223_i = 0, $217 = 0, $size242_i = 0, $220 = 0, $cond_i43_i = 0, $222 = 0, $cond15_i_i = 0, $add_ptr16_i_i = 0, $224 = 0, $add_ptr4_sum_i50_i = 0, $add_ptr17_i_i = 0, $225 = 0, $sub18_i_i = 0, $add_i_i = 0, $add26_i_i = 0, $add_ptr16_sum_i_i = 0, $234 = 0, $and37_i_i = 0, $shr_i55_i = 0, $236 = 0, $238 = 0, $239 = 0, $fd59_i_i = 0, $fd68_pre_phi_i_i = 0, $247 = 0, $249 = 0, $251 = 0, $253 = 0, $bk82_i_i = 0, $fd85_i_i = 0, $add_ptr16_sum56_i_i = 0, $258 = 0, $259 = 0, $arrayidx99_i_i = 0, $260 = 0, $RP_0_i_i = 0, $R_0_i_i = 0, $arrayidx103_i_i = 0, $261 = 0, $arrayidx107_i_i = 0, $262 = 0, $R_1_i_i = 0, $265 = 0, $arrayidx123_i_i = 0, $arrayidx143_i_i = 0, $add_ptr16_sum2728_i_i = 0, $275 = 0, $279 = 0, $qsize_0_i_i = 0, $oldfirst_0_i_i = 0, $head208_i_i = 0, $shr214_i_i = 0, $shl221_i_i = 0, $285 = 0, $286 = 0, $shl226_i_i = 0, $287 = 0, $288 = 0, $_pre_phi_i68_i = 0, $F224_0_i_i = 0, $293 = 0, $shr253_i_i = 0, $and264_i_i = 0, $shl265_i_i = 0, $and268_i_i = 0, $shl270_i_i = 0, $and273_i_i = 0, $add278_i_i = 0, $I252_0_i_i = 0, $arrayidx287_i_i = 0, $296 = 0, $shl294_i_i = 0, $cond315_i_i = 0, $T_0_i69_i = 0, $K305_0_i_i = 0, $arrayidx325_i_i = 0, $303 = 0, $fd344_i_i = 0, $309 = 0, $311 = 0, $316 = 0, $sp_0_i_i_i = 0, $317 = 0, $318 = 0, $add_ptr_i_i_i = 0, $320 = 0, $cond_i18_i = 0, $add_ptr7_i_i = 0, $cond13_i_i = 0, $add_ptr14_i_i = 0, $323 = 0, $cond_i_i_i = 0, $sub5_i_i_i = 0, $330 = 0, $add_ptr2416_i_i = 0, $332 = 0, $sub_ptr_sub_i_i = 0, $335 = 0, $shr_i_i = 0, $shl_i21_i = 0, $337 = 0, $338 = 0, $shl39_i_i = 0, $339 = 0, $340 = 0, $_pre_phi_i_i = 0, $F_0_i_i = 0, $343 = 0, $shr58_i_i = 0, $and69_i_i = 0, $shl70_i_i = 0, $and73_i_i = 0, $shl75_i_i = 0, $and78_i_i = 0, $add83_i_i = 0, $I57_0_i_i = 0, $arrayidx91_i_i = 0, $345 = 0, $shl95_i_i = 0, $cond115_i_i = 0, $T_0_i_i = 0, $K105_0_i_i = 0, $arrayidx126_i_i = 0, $348 = 0, $fd145_i_i = 0, $351 = 0, $353 = 0, $355 = 0, $sub253_i = 0, $356 = 0, $357 = 0, $mem_0 = 0, label = 0;
 do {
  if ($bytes >>> 0 < 245) {
   if ($bytes >>> 0 < 11) {
    $cond = 16;
   } else {
    $cond = $bytes + 11 & -8;
   }
   $shr = $cond >>> 3;
   $0 = HEAP32[11602] | 0;
   $shr3 = $0 >>> ($shr >>> 0);
   if (($shr3 & 3 | 0) != 0) {
    $add8 = ($shr3 & 1 ^ 1) + $shr | 0;
    $shl = $add8 << 1;
    $1 = 46448 + ($shl << 2) | 0;
    $2 = 46448 + ($shl + 2 << 2) | 0;
    $3 = HEAP32[$2 >> 2] | 0;
    $fd9 = $3 + 8 | 0;
    $4 = HEAP32[$fd9 >> 2] | 0;
    do {
     if (($1 | 0) == ($4 | 0)) {
      HEAP32[11602] = $0 & ~(1 << $add8);
     } else {
      if ($4 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
       _abort();
       return 0;
      }
      $bk = $4 + 12 | 0;
      if ((HEAP32[$bk >> 2] | 0) == ($3 | 0)) {
       HEAP32[$bk >> 2] = $1;
       HEAP32[$2 >> 2] = $4;
       break;
      } else {
       _abort();
       return 0;
      }
     }
    } while (0);
    $shl22 = $add8 << 3;
    HEAP32[$3 + 4 >> 2] = $shl22 | 3;
    $9 = $3 + ($shl22 | 4) | 0;
    HEAP32[$9 >> 2] = HEAP32[$9 >> 2] | 1;
    $mem_0 = $fd9;
    return $mem_0 | 0;
   }
   if ($cond >>> 0 <= (HEAP32[11604] | 0) >>> 0) {
    $nb_0 = $cond;
    break;
   }
   if (($shr3 | 0) != 0) {
    $shl37 = 2 << $shr;
    $and41 = $shr3 << $shr & ($shl37 | -$shl37);
    $sub44 = ($and41 & -$and41) - 1 | 0;
    $and46 = $sub44 >>> 12 & 16;
    $shr47 = $sub44 >>> ($and46 >>> 0);
    $and49 = $shr47 >>> 5 & 8;
    $shr51 = $shr47 >>> ($and49 >>> 0);
    $and53 = $shr51 >>> 2 & 4;
    $shr55 = $shr51 >>> ($and53 >>> 0);
    $and57 = $shr55 >>> 1 & 2;
    $shr59 = $shr55 >>> ($and57 >>> 0);
    $and61 = $shr59 >>> 1 & 1;
    $add64 = ($and49 | $and46 | $and53 | $and57 | $and61) + ($shr59 >>> ($and61 >>> 0)) | 0;
    $shl65 = $add64 << 1;
    $13 = 46448 + ($shl65 << 2) | 0;
    $14 = 46448 + ($shl65 + 2 << 2) | 0;
    $15 = HEAP32[$14 >> 2] | 0;
    $fd69 = $15 + 8 | 0;
    $16 = HEAP32[$fd69 >> 2] | 0;
    do {
     if (($13 | 0) == ($16 | 0)) {
      HEAP32[11602] = $0 & ~(1 << $add64);
     } else {
      if ($16 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
       _abort();
       return 0;
      }
      $bk78 = $16 + 12 | 0;
      if ((HEAP32[$bk78 >> 2] | 0) == ($15 | 0)) {
       HEAP32[$bk78 >> 2] = $13;
       HEAP32[$14 >> 2] = $16;
       break;
      } else {
       _abort();
       return 0;
      }
     }
    } while (0);
    $shl90 = $add64 << 3;
    $sub91 = $shl90 - $cond | 0;
    HEAP32[$15 + 4 >> 2] = $cond | 3;
    $20 = $15;
    $21 = $20 + $cond | 0;
    HEAP32[$20 + ($cond | 4) >> 2] = $sub91 | 1;
    HEAP32[$20 + $shl90 >> 2] = $sub91;
    $23 = HEAP32[11604] | 0;
    if (($23 | 0) != 0) {
     $24 = HEAP32[11607] | 0;
     $shr101 = $23 >>> 3;
     $shl102 = $shr101 << 1;
     $25 = 46448 + ($shl102 << 2) | 0;
     $26 = HEAP32[11602] | 0;
     $shl105 = 1 << $shr101;
     do {
      if (($26 & $shl105 | 0) == 0) {
       HEAP32[11602] = $26 | $shl105;
       $F104_0 = $25;
       $_pre_phi = 46448 + ($shl102 + 2 << 2) | 0;
      } else {
       $27 = 46448 + ($shl102 + 2 << 2) | 0;
       $28 = HEAP32[$27 >> 2] | 0;
       if ($28 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
        $F104_0 = $28;
        $_pre_phi = $27;
        break;
       }
       _abort();
       return 0;
      }
     } while (0);
     HEAP32[$_pre_phi >> 2] = $24;
     HEAP32[$F104_0 + 12 >> 2] = $24;
     HEAP32[$24 + 8 >> 2] = $F104_0;
     HEAP32[$24 + 12 >> 2] = $25;
    }
    HEAP32[11604] = $sub91;
    HEAP32[11607] = $21;
    $mem_0 = $fd69;
    return $mem_0 | 0;
   }
   $32 = HEAP32[11603] | 0;
   if (($32 | 0) == 0) {
    $nb_0 = $cond;
    break;
   }
   $sub2_i = ($32 & -$32) - 1 | 0;
   $and3_i = $sub2_i >>> 12 & 16;
   $shr4_i = $sub2_i >>> ($and3_i >>> 0);
   $and6_i = $shr4_i >>> 5 & 8;
   $shr7_i = $shr4_i >>> ($and6_i >>> 0);
   $and9_i = $shr7_i >>> 2 & 4;
   $shr11_i = $shr7_i >>> ($and9_i >>> 0);
   $and13_i = $shr11_i >>> 1 & 2;
   $shr15_i = $shr11_i >>> ($and13_i >>> 0);
   $and17_i = $shr15_i >>> 1 & 1;
   $33 = HEAP32[46712 + (($and6_i | $and3_i | $and9_i | $and13_i | $and17_i) + ($shr15_i >>> ($and17_i >>> 0)) << 2) >> 2] | 0;
   $t_0_i = $33;
   $v_0_i = $33;
   $rsize_0_i = (HEAP32[$33 + 4 >> 2] & -8) - $cond | 0;
   while (1) {
    $35 = HEAP32[$t_0_i + 16 >> 2] | 0;
    if (($35 | 0) == 0) {
     $36 = HEAP32[$t_0_i + 20 >> 2] | 0;
     if (($36 | 0) == 0) {
      break;
     } else {
      $cond7_i = $36;
     }
    } else {
     $cond7_i = $35;
    }
    $sub31_i = (HEAP32[$cond7_i + 4 >> 2] & -8) - $cond | 0;
    $cmp32_i = $sub31_i >>> 0 < $rsize_0_i >>> 0;
    $t_0_i = $cond7_i;
    $v_0_i = $cmp32_i ? $cond7_i : $v_0_i;
    $rsize_0_i = $cmp32_i ? $sub31_i : $rsize_0_i;
   }
   $38 = $v_0_i;
   $39 = HEAP32[11606] | 0;
   if ($38 >>> 0 < $39 >>> 0) {
    _abort();
    return 0;
   }
   $add_ptr_i = $38 + $cond | 0;
   $40 = $add_ptr_i;
   if ($38 >>> 0 >= $add_ptr_i >>> 0) {
    _abort();
    return 0;
   }
   $41 = HEAP32[$v_0_i + 24 >> 2] | 0;
   $42 = HEAP32[$v_0_i + 12 >> 2] | 0;
   do {
    if (($42 | 0) == ($v_0_i | 0)) {
     $arrayidx61_i = $v_0_i + 20 | 0;
     $47 = HEAP32[$arrayidx61_i >> 2] | 0;
     if (($47 | 0) == 0) {
      $arrayidx65_i = $v_0_i + 16 | 0;
      $48 = HEAP32[$arrayidx65_i >> 2] | 0;
      if (($48 | 0) == 0) {
       $R_1_i = 0;
       break;
      } else {
       $R_0_i = $48;
       $RP_0_i = $arrayidx65_i;
      }
     } else {
      $R_0_i = $47;
      $RP_0_i = $arrayidx61_i;
     }
     while (1) {
      $arrayidx71_i = $R_0_i + 20 | 0;
      $49 = HEAP32[$arrayidx71_i >> 2] | 0;
      if (($49 | 0) != 0) {
       $R_0_i = $49;
       $RP_0_i = $arrayidx71_i;
       continue;
      }
      $arrayidx75_i = $R_0_i + 16 | 0;
      $50 = HEAP32[$arrayidx75_i >> 2] | 0;
      if (($50 | 0) == 0) {
       break;
      } else {
       $R_0_i = $50;
       $RP_0_i = $arrayidx75_i;
      }
     }
     if ($RP_0_i >>> 0 < $39 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$RP_0_i >> 2] = 0;
      $R_1_i = $R_0_i;
      break;
     }
    } else {
     $43 = HEAP32[$v_0_i + 8 >> 2] | 0;
     if ($43 >>> 0 < $39 >>> 0) {
      _abort();
      return 0;
     }
     $bk47_i = $43 + 12 | 0;
     if ((HEAP32[$bk47_i >> 2] | 0) != ($v_0_i | 0)) {
      _abort();
      return 0;
     }
     $fd50_i = $42 + 8 | 0;
     if ((HEAP32[$fd50_i >> 2] | 0) == ($v_0_i | 0)) {
      HEAP32[$bk47_i >> 2] = $42;
      HEAP32[$fd50_i >> 2] = $43;
      $R_1_i = $42;
      break;
     } else {
      _abort();
      return 0;
     }
    }
   } while (0);
   L732 : do {
    if (($41 | 0) != 0) {
     $index_i = $v_0_i + 28 | 0;
     $arrayidx94_i = 46712 + (HEAP32[$index_i >> 2] << 2) | 0;
     do {
      if (($v_0_i | 0) == (HEAP32[$arrayidx94_i >> 2] | 0)) {
       HEAP32[$arrayidx94_i >> 2] = $R_1_i;
       if (($R_1_i | 0) != 0) {
        break;
       }
       HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$index_i >> 2]);
       break L732;
      } else {
       if ($41 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
        return 0;
       }
       $arrayidx113_i = $41 + 16 | 0;
       if ((HEAP32[$arrayidx113_i >> 2] | 0) == ($v_0_i | 0)) {
        HEAP32[$arrayidx113_i >> 2] = $R_1_i;
       } else {
        HEAP32[$41 + 20 >> 2] = $R_1_i;
       }
       if (($R_1_i | 0) == 0) {
        break L732;
       }
      }
     } while (0);
     if ($R_1_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
      return 0;
     }
     HEAP32[$R_1_i + 24 >> 2] = $41;
     $61 = HEAP32[$v_0_i + 16 >> 2] | 0;
     do {
      if (($61 | 0) != 0) {
       if ($61 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
        return 0;
       } else {
        HEAP32[$R_1_i + 16 >> 2] = $61;
        HEAP32[$61 + 24 >> 2] = $R_1_i;
        break;
       }
      }
     } while (0);
     $64 = HEAP32[$v_0_i + 20 >> 2] | 0;
     if (($64 | 0) == 0) {
      break;
     }
     if ($64 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$R_1_i + 20 >> 2] = $64;
      HEAP32[$64 + 24 >> 2] = $R_1_i;
      break;
     }
    }
   } while (0);
   if ($rsize_0_i >>> 0 < 16) {
    $add177_i = $rsize_0_i + $cond | 0;
    HEAP32[$v_0_i + 4 >> 2] = $add177_i | 3;
    $67 = $38 + ($add177_i + 4) | 0;
    HEAP32[$67 >> 2] = HEAP32[$67 >> 2] | 1;
   } else {
    HEAP32[$v_0_i + 4 >> 2] = $cond | 3;
    HEAP32[$38 + ($cond | 4) >> 2] = $rsize_0_i | 1;
    HEAP32[$38 + ($rsize_0_i + $cond) >> 2] = $rsize_0_i;
    $70 = HEAP32[11604] | 0;
    if (($70 | 0) != 0) {
     $71 = HEAP32[11607] | 0;
     $shr194_i = $70 >>> 3;
     $shl195_i = $shr194_i << 1;
     $72 = 46448 + ($shl195_i << 2) | 0;
     $73 = HEAP32[11602] | 0;
     $shl198_i = 1 << $shr194_i;
     do {
      if (($73 & $shl198_i | 0) == 0) {
       HEAP32[11602] = $73 | $shl198_i;
       $F197_0_i = $72;
       $_pre_phi_i = 46448 + ($shl195_i + 2 << 2) | 0;
      } else {
       $74 = 46448 + ($shl195_i + 2 << 2) | 0;
       $75 = HEAP32[$74 >> 2] | 0;
       if ($75 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
        $F197_0_i = $75;
        $_pre_phi_i = $74;
        break;
       }
       _abort();
       return 0;
      }
     } while (0);
     HEAP32[$_pre_phi_i >> 2] = $71;
     HEAP32[$F197_0_i + 12 >> 2] = $71;
     HEAP32[$71 + 8 >> 2] = $F197_0_i;
     HEAP32[$71 + 12 >> 2] = $72;
    }
    HEAP32[11604] = $rsize_0_i;
    HEAP32[11607] = $40;
   }
   $add_ptr225_i = $v_0_i + 8 | 0;
   if (($add_ptr225_i | 0) == 0) {
    $nb_0 = $cond;
    break;
   } else {
    $mem_0 = $add_ptr225_i;
   }
   return $mem_0 | 0;
  } else {
   if ($bytes >>> 0 > 4294967231) {
    $nb_0 = -1;
    break;
   }
   $add143 = $bytes + 11 | 0;
   $and144 = $add143 & -8;
   $79 = HEAP32[11603] | 0;
   if (($79 | 0) == 0) {
    $nb_0 = $and144;
    break;
   }
   $sub_i107 = -$and144 | 0;
   $shr_i108 = $add143 >>> 8;
   do {
    if (($shr_i108 | 0) == 0) {
     $idx_0_i = 0;
    } else {
     if ($and144 >>> 0 > 16777215) {
      $idx_0_i = 31;
      break;
     }
     $and_i112 = ($shr_i108 + 1048320 | 0) >>> 16 & 8;
     $shl_i113 = $shr_i108 << $and_i112;
     $and8_i = ($shl_i113 + 520192 | 0) >>> 16 & 4;
     $shl9_i = $shl_i113 << $and8_i;
     $and12_i = ($shl9_i + 245760 | 0) >>> 16 & 2;
     $add17_i = 14 - ($and8_i | $and_i112 | $and12_i) + ($shl9_i << $and12_i >>> 15) | 0;
     $idx_0_i = $and144 >>> (($add17_i + 7 | 0) >>> 0) & 1 | $add17_i << 1;
    }
   } while (0);
   $80 = HEAP32[46712 + ($idx_0_i << 2) >> 2] | 0;
   L780 : do {
    if (($80 | 0) == 0) {
     $v_2_i = 0;
     $rsize_2_i = $sub_i107;
     $t_1_i = 0;
    } else {
     if (($idx_0_i | 0) == 31) {
      $cond_i = 0;
     } else {
      $cond_i = 25 - ($idx_0_i >>> 1) | 0;
     }
     $v_0_i123 = 0;
     $rsize_0_i122 = $sub_i107;
     $t_0_i121 = $80;
     $sizebits_0_i = $and144 << $cond_i;
     $rst_0_i = 0;
     while (1) {
      $and32_i = HEAP32[$t_0_i121 + 4 >> 2] & -8;
      $sub33_i = $and32_i - $and144 | 0;
      if ($sub33_i >>> 0 < $rsize_0_i122 >>> 0) {
       if (($and32_i | 0) == ($and144 | 0)) {
        $v_2_i = $t_0_i121;
        $rsize_2_i = $sub33_i;
        $t_1_i = $t_0_i121;
        break L780;
       } else {
        $v_1_i = $t_0_i121;
        $rsize_1_i = $sub33_i;
       }
      } else {
       $v_1_i = $v_0_i123;
       $rsize_1_i = $rsize_0_i122;
      }
      $82 = HEAP32[$t_0_i121 + 20 >> 2] | 0;
      $83 = HEAP32[$t_0_i121 + 16 + ($sizebits_0_i >>> 31 << 2) >> 2] | 0;
      $rst_1_i = ($82 | 0) == 0 | ($82 | 0) == ($83 | 0) ? $rst_0_i : $82;
      if (($83 | 0) == 0) {
       $v_2_i = $v_1_i;
       $rsize_2_i = $rsize_1_i;
       $t_1_i = $rst_1_i;
       break;
      } else {
       $v_0_i123 = $v_1_i;
       $rsize_0_i122 = $rsize_1_i;
       $t_0_i121 = $83;
       $sizebits_0_i = $sizebits_0_i << 1;
       $rst_0_i = $rst_1_i;
      }
     }
    }
   } while (0);
   if (($t_1_i | 0) == 0 & ($v_2_i | 0) == 0) {
    $shl59_i = 2 << $idx_0_i;
    $and63_i = $79 & ($shl59_i | -$shl59_i);
    if (($and63_i | 0) == 0) {
     $nb_0 = $and144;
     break;
    }
    $sub69_i = ($and63_i & -$and63_i) - 1 | 0;
    $and72_i = $sub69_i >>> 12 & 16;
    $shr74_i = $sub69_i >>> ($and72_i >>> 0);
    $and76_i = $shr74_i >>> 5 & 8;
    $shr78_i = $shr74_i >>> ($and76_i >>> 0);
    $and80_i = $shr78_i >>> 2 & 4;
    $shr82_i = $shr78_i >>> ($and80_i >>> 0);
    $and84_i = $shr82_i >>> 1 & 2;
    $shr86_i = $shr82_i >>> ($and84_i >>> 0);
    $and88_i = $shr86_i >>> 1 & 1;
    $t_2_ph_i = HEAP32[46712 + (($and76_i | $and72_i | $and80_i | $and84_i | $and88_i) + ($shr86_i >>> ($and88_i >>> 0)) << 2) >> 2] | 0;
   } else {
    $t_2_ph_i = $t_1_i;
   }
   if (($t_2_ph_i | 0) == 0) {
    $rsize_3_lcssa_i = $rsize_2_i;
    $v_3_lcssa_i = $v_2_i;
   } else {
    $t_224_i = $t_2_ph_i;
    $rsize_325_i = $rsize_2_i;
    $v_326_i = $v_2_i;
    while (1) {
     $sub100_i = (HEAP32[$t_224_i + 4 >> 2] & -8) - $and144 | 0;
     $cmp101_i = $sub100_i >>> 0 < $rsize_325_i >>> 0;
     $sub100_rsize_3_i = $cmp101_i ? $sub100_i : $rsize_325_i;
     $t_2_v_3_i = $cmp101_i ? $t_224_i : $v_326_i;
     $86 = HEAP32[$t_224_i + 16 >> 2] | 0;
     if (($86 | 0) != 0) {
      $t_224_i = $86;
      $rsize_325_i = $sub100_rsize_3_i;
      $v_326_i = $t_2_v_3_i;
      continue;
     }
     $87 = HEAP32[$t_224_i + 20 >> 2] | 0;
     if (($87 | 0) == 0) {
      $rsize_3_lcssa_i = $sub100_rsize_3_i;
      $v_3_lcssa_i = $t_2_v_3_i;
      break;
     } else {
      $t_224_i = $87;
      $rsize_325_i = $sub100_rsize_3_i;
      $v_326_i = $t_2_v_3_i;
     }
    }
   }
   if (($v_3_lcssa_i | 0) == 0) {
    $nb_0 = $and144;
    break;
   }
   if ($rsize_3_lcssa_i >>> 0 >= ((HEAP32[11604] | 0) - $and144 | 0) >>> 0) {
    $nb_0 = $and144;
    break;
   }
   $89 = $v_3_lcssa_i;
   $90 = HEAP32[11606] | 0;
   if ($89 >>> 0 < $90 >>> 0) {
    _abort();
    return 0;
   }
   $add_ptr_i128 = $89 + $and144 | 0;
   $91 = $add_ptr_i128;
   if ($89 >>> 0 >= $add_ptr_i128 >>> 0) {
    _abort();
    return 0;
   }
   $92 = HEAP32[$v_3_lcssa_i + 24 >> 2] | 0;
   $93 = HEAP32[$v_3_lcssa_i + 12 >> 2] | 0;
   do {
    if (($93 | 0) == ($v_3_lcssa_i | 0)) {
     $arrayidx150_i = $v_3_lcssa_i + 20 | 0;
     $98 = HEAP32[$arrayidx150_i >> 2] | 0;
     if (($98 | 0) == 0) {
      $arrayidx154_i133 = $v_3_lcssa_i + 16 | 0;
      $99 = HEAP32[$arrayidx154_i133 >> 2] | 0;
      if (($99 | 0) == 0) {
       $R_1_i139 = 0;
       break;
      } else {
       $R_0_i137 = $99;
       $RP_0_i136 = $arrayidx154_i133;
      }
     } else {
      $R_0_i137 = $98;
      $RP_0_i136 = $arrayidx150_i;
     }
     while (1) {
      $arrayidx160_i = $R_0_i137 + 20 | 0;
      $100 = HEAP32[$arrayidx160_i >> 2] | 0;
      if (($100 | 0) != 0) {
       $R_0_i137 = $100;
       $RP_0_i136 = $arrayidx160_i;
       continue;
      }
      $arrayidx164_i = $R_0_i137 + 16 | 0;
      $101 = HEAP32[$arrayidx164_i >> 2] | 0;
      if (($101 | 0) == 0) {
       break;
      } else {
       $R_0_i137 = $101;
       $RP_0_i136 = $arrayidx164_i;
      }
     }
     if ($RP_0_i136 >>> 0 < $90 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$RP_0_i136 >> 2] = 0;
      $R_1_i139 = $R_0_i137;
      break;
     }
    } else {
     $94 = HEAP32[$v_3_lcssa_i + 8 >> 2] | 0;
     if ($94 >>> 0 < $90 >>> 0) {
      _abort();
      return 0;
     }
     $bk135_i = $94 + 12 | 0;
     if ((HEAP32[$bk135_i >> 2] | 0) != ($v_3_lcssa_i | 0)) {
      _abort();
      return 0;
     }
     $fd138_i = $93 + 8 | 0;
     if ((HEAP32[$fd138_i >> 2] | 0) == ($v_3_lcssa_i | 0)) {
      HEAP32[$bk135_i >> 2] = $93;
      HEAP32[$fd138_i >> 2] = $94;
      $R_1_i139 = $93;
      break;
     } else {
      _abort();
      return 0;
     }
    }
   } while (0);
   L830 : do {
    if (($92 | 0) != 0) {
     $index_i140 = $v_3_lcssa_i + 28 | 0;
     $arrayidx183_i = 46712 + (HEAP32[$index_i140 >> 2] << 2) | 0;
     do {
      if (($v_3_lcssa_i | 0) == (HEAP32[$arrayidx183_i >> 2] | 0)) {
       HEAP32[$arrayidx183_i >> 2] = $R_1_i139;
       if (($R_1_i139 | 0) != 0) {
        break;
       }
       HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$index_i140 >> 2]);
       break L830;
      } else {
       if ($92 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
        return 0;
       }
       $arrayidx203_i = $92 + 16 | 0;
       if ((HEAP32[$arrayidx203_i >> 2] | 0) == ($v_3_lcssa_i | 0)) {
        HEAP32[$arrayidx203_i >> 2] = $R_1_i139;
       } else {
        HEAP32[$92 + 20 >> 2] = $R_1_i139;
       }
       if (($R_1_i139 | 0) == 0) {
        break L830;
       }
      }
     } while (0);
     if ($R_1_i139 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
      return 0;
     }
     HEAP32[$R_1_i139 + 24 >> 2] = $92;
     $112 = HEAP32[$v_3_lcssa_i + 16 >> 2] | 0;
     do {
      if (($112 | 0) != 0) {
       if ($112 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
        return 0;
       } else {
        HEAP32[$R_1_i139 + 16 >> 2] = $112;
        HEAP32[$112 + 24 >> 2] = $R_1_i139;
        break;
       }
      }
     } while (0);
     $115 = HEAP32[$v_3_lcssa_i + 20 >> 2] | 0;
     if (($115 | 0) == 0) {
      break;
     }
     if ($115 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$R_1_i139 + 20 >> 2] = $115;
      HEAP32[$115 + 24 >> 2] = $R_1_i139;
      break;
     }
    }
   } while (0);
   do {
    if ($rsize_3_lcssa_i >>> 0 < 16) {
     $add267_i = $rsize_3_lcssa_i + $and144 | 0;
     HEAP32[$v_3_lcssa_i + 4 >> 2] = $add267_i | 3;
     $118 = $89 + ($add267_i + 4) | 0;
     HEAP32[$118 >> 2] = HEAP32[$118 >> 2] | 1;
    } else {
     HEAP32[$v_3_lcssa_i + 4 >> 2] = $and144 | 3;
     HEAP32[$89 + ($and144 | 4) >> 2] = $rsize_3_lcssa_i | 1;
     HEAP32[$89 + ($rsize_3_lcssa_i + $and144) >> 2] = $rsize_3_lcssa_i;
     $shr282_i = $rsize_3_lcssa_i >>> 3;
     if ($rsize_3_lcssa_i >>> 0 < 256) {
      $shl287_i = $shr282_i << 1;
      $121 = 46448 + ($shl287_i << 2) | 0;
      $122 = HEAP32[11602] | 0;
      $shl290_i = 1 << $shr282_i;
      do {
       if (($122 & $shl290_i | 0) == 0) {
        HEAP32[11602] = $122 | $shl290_i;
        $F289_0_i = $121;
        $_pre_phi_i147 = 46448 + ($shl287_i + 2 << 2) | 0;
       } else {
        $123 = 46448 + ($shl287_i + 2 << 2) | 0;
        $124 = HEAP32[$123 >> 2] | 0;
        if ($124 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
         $F289_0_i = $124;
         $_pre_phi_i147 = $123;
         break;
        }
        _abort();
        return 0;
       }
      } while (0);
      HEAP32[$_pre_phi_i147 >> 2] = $91;
      HEAP32[$F289_0_i + 12 >> 2] = $91;
      HEAP32[$89 + ($and144 + 8) >> 2] = $F289_0_i;
      HEAP32[$89 + ($and144 + 12) >> 2] = $121;
      break;
     }
     $129 = $add_ptr_i128;
     $shr317_i = $rsize_3_lcssa_i >>> 8;
     do {
      if (($shr317_i | 0) == 0) {
       $I315_0_i = 0;
      } else {
       if ($rsize_3_lcssa_i >>> 0 > 16777215) {
        $I315_0_i = 31;
        break;
       }
       $and330_i = ($shr317_i + 1048320 | 0) >>> 16 & 8;
       $shl332_i = $shr317_i << $and330_i;
       $and335_i = ($shl332_i + 520192 | 0) >>> 16 & 4;
       $shl337_i = $shl332_i << $and335_i;
       $and340_i = ($shl337_i + 245760 | 0) >>> 16 & 2;
       $add345_i = 14 - ($and335_i | $and330_i | $and340_i) + ($shl337_i << $and340_i >>> 15) | 0;
       $I315_0_i = $rsize_3_lcssa_i >>> (($add345_i + 7 | 0) >>> 0) & 1 | $add345_i << 1;
      }
     } while (0);
     $arrayidx354_i = 46712 + ($I315_0_i << 2) | 0;
     HEAP32[$89 + ($and144 + 28) >> 2] = $I315_0_i;
     HEAP32[$89 + ($and144 + 20) >> 2] = 0;
     HEAP32[$89 + ($and144 + 16) >> 2] = 0;
     $132 = HEAP32[11603] | 0;
     $shl361_i = 1 << $I315_0_i;
     if (($132 & $shl361_i | 0) == 0) {
      HEAP32[11603] = $132 | $shl361_i;
      HEAP32[$arrayidx354_i >> 2] = $129;
      HEAP32[$89 + ($and144 + 24) >> 2] = $arrayidx354_i;
      HEAP32[$89 + ($and144 + 12) >> 2] = $129;
      HEAP32[$89 + ($and144 + 8) >> 2] = $129;
      break;
     }
     if (($I315_0_i | 0) == 31) {
      $cond382_i = 0;
     } else {
      $cond382_i = 25 - ($I315_0_i >>> 1) | 0;
     }
     $K372_0_i = $rsize_3_lcssa_i << $cond382_i;
     $T_0_i = HEAP32[$arrayidx354_i >> 2] | 0;
     while (1) {
      if ((HEAP32[$T_0_i + 4 >> 2] & -8 | 0) == ($rsize_3_lcssa_i | 0)) {
       break;
      }
      $arrayidx393_i = $T_0_i + 16 + ($K372_0_i >>> 31 << 2) | 0;
      $139 = HEAP32[$arrayidx393_i >> 2] | 0;
      if (($139 | 0) == 0) {
       label = 648;
       break;
      } else {
       $K372_0_i = $K372_0_i << 1;
       $T_0_i = $139;
      }
     }
     if ((label | 0) == 648) {
      if ($arrayidx393_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
       _abort();
       return 0;
      } else {
       HEAP32[$arrayidx393_i >> 2] = $129;
       HEAP32[$89 + ($and144 + 24) >> 2] = $T_0_i;
       HEAP32[$89 + ($and144 + 12) >> 2] = $129;
       HEAP32[$89 + ($and144 + 8) >> 2] = $129;
       break;
      }
     }
     $fd412_i = $T_0_i + 8 | 0;
     $145 = HEAP32[$fd412_i >> 2] | 0;
     $147 = HEAP32[11606] | 0;
     if ($T_0_i >>> 0 < $147 >>> 0) {
      _abort();
      return 0;
     }
     if ($145 >>> 0 < $147 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$145 + 12 >> 2] = $129;
      HEAP32[$fd412_i >> 2] = $129;
      HEAP32[$89 + ($and144 + 8) >> 2] = $145;
      HEAP32[$89 + ($and144 + 12) >> 2] = $T_0_i;
      HEAP32[$89 + ($and144 + 24) >> 2] = 0;
      break;
     }
    }
   } while (0);
   $add_ptr436_i = $v_3_lcssa_i + 8 | 0;
   if (($add_ptr436_i | 0) == 0) {
    $nb_0 = $and144;
    break;
   } else {
    $mem_0 = $add_ptr436_i;
   }
   return $mem_0 | 0;
  }
 } while (0);
 $153 = HEAP32[11604] | 0;
 if ($nb_0 >>> 0 <= $153 >>> 0) {
  $sub159 = $153 - $nb_0 | 0;
  $154 = HEAP32[11607] | 0;
  if ($sub159 >>> 0 > 15) {
   $155 = $154;
   HEAP32[11607] = $155 + $nb_0;
   HEAP32[11604] = $sub159;
   HEAP32[$155 + ($nb_0 + 4) >> 2] = $sub159 | 1;
   HEAP32[$155 + $153 >> 2] = $sub159;
   HEAP32[$154 + 4 >> 2] = $nb_0 | 3;
  } else {
   HEAP32[11604] = 0;
   HEAP32[11607] = 0;
   HEAP32[$154 + 4 >> 2] = $153 | 3;
   $159 = $154 + ($153 + 4) | 0;
   HEAP32[$159 >> 2] = HEAP32[$159 >> 2] | 1;
  }
  $mem_0 = $154 + 8 | 0;
  return $mem_0 | 0;
 }
 $162 = HEAP32[11605] | 0;
 if ($nb_0 >>> 0 < $162 >>> 0) {
  $sub187 = $162 - $nb_0 | 0;
  HEAP32[11605] = $sub187;
  $163 = HEAP32[11608] | 0;
  $164 = $163;
  HEAP32[11608] = $164 + $nb_0;
  HEAP32[$164 + ($nb_0 + 4) >> 2] = $sub187 | 1;
  HEAP32[$163 + 4 >> 2] = $nb_0 | 3;
  $mem_0 = $163 + 8 | 0;
  return $mem_0 | 0;
 }
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i_i = _sysconf(8) | 0;
   if (($call_i_i - 1 & $call_i_i | 0) == 0) {
    HEAP32[10826] = $call_i_i;
    HEAP32[10825] = $call_i_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
    return 0;
   }
  }
 } while (0);
 $add_i149 = $nb_0 + 48 | 0;
 $169 = HEAP32[10826] | 0;
 $sub_i150 = $nb_0 + 47 | 0;
 $add9_i = $169 + $sub_i150 | 0;
 $neg_i151 = -$169 | 0;
 $and11_i = $add9_i & $neg_i151;
 if ($and11_i >>> 0 <= $nb_0 >>> 0) {
  $mem_0 = 0;
  return $mem_0 | 0;
 }
 $170 = HEAP32[11712] | 0;
 do {
  if (($170 | 0) != 0) {
   $171 = HEAP32[11710] | 0;
   $add17_i152 = $171 + $and11_i | 0;
   if ($add17_i152 >>> 0 <= $171 >>> 0 | $add17_i152 >>> 0 > $170 >>> 0) {
    $mem_0 = 0;
   } else {
    break;
   }
   return $mem_0 | 0;
  }
 } while (0);
 L922 : do {
  if ((HEAP32[11713] & 4 | 0) == 0) {
   $173 = HEAP32[11608] | 0;
   L924 : do {
    if (($173 | 0) == 0) {
     label = 678;
    } else {
     $174 = $173;
     $sp_0_i_i = 46856;
     while (1) {
      $base_i_i = $sp_0_i_i | 0;
      $175 = HEAP32[$base_i_i >> 2] | 0;
      if ($175 >>> 0 <= $174 >>> 0) {
       $size_i_i = $sp_0_i_i + 4 | 0;
       if (($175 + (HEAP32[$size_i_i >> 2] | 0) | 0) >>> 0 > $174 >>> 0) {
        break;
       }
      }
      $177 = HEAP32[$sp_0_i_i + 8 >> 2] | 0;
      if (($177 | 0) == 0) {
       label = 678;
       break L924;
      } else {
       $sp_0_i_i = $177;
      }
     }
     if (($sp_0_i_i | 0) == 0) {
      label = 678;
      break;
     }
     $and77_i = $add9_i - (HEAP32[11605] | 0) & $neg_i151;
     if ($and77_i >>> 0 >= 2147483647) {
      $tsize_0758385_i = 0;
      break;
     }
     $call80_i = _sbrk($and77_i | 0) | 0;
     $cmp82_i = ($call80_i | 0) == ((HEAP32[$base_i_i >> 2] | 0) + (HEAP32[$size_i_i >> 2] | 0) | 0);
     $tbase_0_i = $cmp82_i ? $call80_i : -1;
     $tsize_0_i = $cmp82_i ? $and77_i : 0;
     $br_0_i = $call80_i;
     $ssize_1_i = $and77_i;
     label = 687;
    }
   } while (0);
   do {
    if ((label | 0) == 678) {
     $call34_i = _sbrk(0) | 0;
     if (($call34_i | 0) == -1) {
      $tsize_0758385_i = 0;
      break;
     }
     $178 = $call34_i;
     $179 = HEAP32[10825] | 0;
     $sub38_i = $179 - 1 | 0;
     if (($sub38_i & $178 | 0) == 0) {
      $ssize_0_i = $and11_i;
     } else {
      $ssize_0_i = $and11_i - $178 + ($sub38_i + $178 & -$179) | 0;
     }
     $180 = HEAP32[11710] | 0;
     $add51_i = $180 + $ssize_0_i | 0;
     if (!($ssize_0_i >>> 0 > $nb_0 >>> 0 & $ssize_0_i >>> 0 < 2147483647)) {
      $tsize_0758385_i = 0;
      break;
     }
     $181 = HEAP32[11712] | 0;
     if (($181 | 0) != 0) {
      if ($add51_i >>> 0 <= $180 >>> 0 | $add51_i >>> 0 > $181 >>> 0) {
       $tsize_0758385_i = 0;
       break;
      }
     }
     $call65_i = _sbrk($ssize_0_i | 0) | 0;
     $cmp66_i160 = ($call65_i | 0) == ($call34_i | 0);
     $tbase_0_i = $cmp66_i160 ? $call34_i : -1;
     $tsize_0_i = $cmp66_i160 ? $ssize_0_i : 0;
     $br_0_i = $call65_i;
     $ssize_1_i = $ssize_0_i;
     label = 687;
    }
   } while (0);
   L944 : do {
    if ((label | 0) == 687) {
     $sub109_i = -$ssize_1_i | 0;
     if (($tbase_0_i | 0) != -1) {
      $tsize_291_i = $tsize_0_i;
      $tbase_292_i = $tbase_0_i;
      label = 698;
      break L922;
     }
     do {
      if (($br_0_i | 0) != -1 & $ssize_1_i >>> 0 < 2147483647 & $ssize_1_i >>> 0 < $add_i149 >>> 0) {
       $185 = HEAP32[10826] | 0;
       $and101_i = $sub_i150 - $ssize_1_i + $185 & -$185;
       if ($and101_i >>> 0 >= 2147483647) {
        $ssize_2_i = $ssize_1_i;
        break;
       }
       if ((_sbrk($and101_i | 0) | 0) == -1) {
        _sbrk($sub109_i | 0) | 0;
        $tsize_0758385_i = $tsize_0_i;
        break L944;
       } else {
        $ssize_2_i = $and101_i + $ssize_1_i | 0;
        break;
       }
      } else {
       $ssize_2_i = $ssize_1_i;
      }
     } while (0);
     if (($br_0_i | 0) == -1) {
      $tsize_0758385_i = $tsize_0_i;
     } else {
      $tsize_291_i = $ssize_2_i;
      $tbase_292_i = $br_0_i;
      label = 698;
      break L922;
     }
    }
   } while (0);
   HEAP32[11713] = HEAP32[11713] | 4;
   $tsize_1_i = $tsize_0758385_i;
   label = 695;
  } else {
   $tsize_1_i = 0;
   label = 695;
  }
 } while (0);
 do {
  if ((label | 0) == 695) {
   if ($and11_i >>> 0 >= 2147483647) {
    break;
   }
   $call128_i = _sbrk($and11_i | 0) | 0;
   $call129_i = _sbrk(0) | 0;
   if (!(($call129_i | 0) != -1 & ($call128_i | 0) != -1 & $call128_i >>> 0 < $call129_i >>> 0)) {
    break;
   }
   $sub_ptr_sub_i = $call129_i - $call128_i | 0;
   $cmp138_i166 = $sub_ptr_sub_i >>> 0 > ($nb_0 + 40 | 0) >>> 0;
   $call128_tbase_1_i = $cmp138_i166 ? $call128_i : -1;
   if (($call128_tbase_1_i | 0) != -1) {
    $tsize_291_i = $cmp138_i166 ? $sub_ptr_sub_i : $tsize_1_i;
    $tbase_292_i = $call128_tbase_1_i;
    label = 698;
   }
  }
 } while (0);
 do {
  if ((label | 0) == 698) {
   $add147_i = (HEAP32[11710] | 0) + $tsize_291_i | 0;
   HEAP32[11710] = $add147_i;
   if ($add147_i >>> 0 > (HEAP32[11711] | 0) >>> 0) {
    HEAP32[11711] = $add147_i;
   }
   $189 = HEAP32[11608] | 0;
   L964 : do {
    if (($189 | 0) == 0) {
     $190 = HEAP32[11606] | 0;
     if (($190 | 0) == 0 | $tbase_292_i >>> 0 < $190 >>> 0) {
      HEAP32[11606] = $tbase_292_i;
     }
     HEAP32[11714] = $tbase_292_i;
     HEAP32[11715] = $tsize_291_i;
     HEAP32[11717] = 0;
     HEAP32[11611] = HEAP32[10824];
     HEAP32[11610] = -1;
     $i_02_i_i = 0;
     do {
      $shl_i_i = $i_02_i_i << 1;
      $192 = 46448 + ($shl_i_i << 2) | 0;
      HEAP32[46448 + ($shl_i_i + 3 << 2) >> 2] = $192;
      HEAP32[46448 + ($shl_i_i + 2 << 2) >> 2] = $192;
      $i_02_i_i = $i_02_i_i + 1 | 0;
     } while ($i_02_i_i >>> 0 < 32);
     $195 = $tbase_292_i + 8 | 0;
     if (($195 & 7 | 0) == 0) {
      $cond_i_i = 0;
     } else {
      $cond_i_i = -$195 & 7;
     }
     $sub5_i_i = $tsize_291_i - 40 - $cond_i_i | 0;
     HEAP32[11608] = $tbase_292_i + $cond_i_i;
     HEAP32[11605] = $sub5_i_i;
     HEAP32[$tbase_292_i + ($cond_i_i + 4) >> 2] = $sub5_i_i | 1;
     HEAP32[$tbase_292_i + ($tsize_291_i - 36) >> 2] = 40;
     HEAP32[11609] = HEAP32[10828];
    } else {
     $sp_0105_i = 46856;
     while (1) {
      $201 = HEAP32[$sp_0105_i >> 2] | 0;
      $size185_i = $sp_0105_i + 4 | 0;
      $202 = HEAP32[$size185_i >> 2] | 0;
      if (($tbase_292_i | 0) == ($201 + $202 | 0)) {
       label = 710;
       break;
      }
      $203 = HEAP32[$sp_0105_i + 8 >> 2] | 0;
      if (($203 | 0) == 0) {
       break;
      } else {
       $sp_0105_i = $203;
      }
     }
     do {
      if ((label | 0) == 710) {
       if ((HEAP32[$sp_0105_i + 12 >> 2] & 8 | 0) != 0) {
        break;
       }
       $205 = $189;
       if (!($205 >>> 0 >= $201 >>> 0 & $205 >>> 0 < $tbase_292_i >>> 0)) {
        break;
       }
       HEAP32[$size185_i >> 2] = $202 + $tsize_291_i;
       $206 = HEAP32[11608] | 0;
       $add212_i = (HEAP32[11605] | 0) + $tsize_291_i | 0;
       $208 = $206;
       $209 = $206 + 8 | 0;
       if (($209 & 7 | 0) == 0) {
        $cond_i28_i = 0;
       } else {
        $cond_i28_i = -$209 & 7;
       }
       $sub5_i30_i = $add212_i - $cond_i28_i | 0;
       HEAP32[11608] = $208 + $cond_i28_i;
       HEAP32[11605] = $sub5_i30_i;
       HEAP32[$208 + ($cond_i28_i + 4) >> 2] = $sub5_i30_i | 1;
       HEAP32[$208 + ($add212_i + 4) >> 2] = 40;
       HEAP32[11609] = HEAP32[10828];
       break L964;
      }
     } while (0);
     if ($tbase_292_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      HEAP32[11606] = $tbase_292_i;
     }
     $add_ptr224_i = $tbase_292_i + $tsize_291_i | 0;
     $sp_1101_i = 46856;
     while (1) {
      $base223_i = $sp_1101_i | 0;
      if ((HEAP32[$base223_i >> 2] | 0) == ($add_ptr224_i | 0)) {
       label = 720;
       break;
      }
      $217 = HEAP32[$sp_1101_i + 8 >> 2] | 0;
      if (($217 | 0) == 0) {
       break;
      } else {
       $sp_1101_i = $217;
      }
     }
     do {
      if ((label | 0) == 720) {
       if ((HEAP32[$sp_1101_i + 12 >> 2] & 8 | 0) != 0) {
        break;
       }
       HEAP32[$base223_i >> 2] = $tbase_292_i;
       $size242_i = $sp_1101_i + 4 | 0;
       HEAP32[$size242_i >> 2] = (HEAP32[$size242_i >> 2] | 0) + $tsize_291_i;
       $220 = $tbase_292_i + 8 | 0;
       if (($220 & 7 | 0) == 0) {
        $cond_i43_i = 0;
       } else {
        $cond_i43_i = -$220 & 7;
       }
       $222 = $tbase_292_i + ($tsize_291_i + 8) | 0;
       if (($222 & 7 | 0) == 0) {
        $cond15_i_i = 0;
       } else {
        $cond15_i_i = -$222 & 7;
       }
       $add_ptr16_i_i = $tbase_292_i + ($cond15_i_i + $tsize_291_i) | 0;
       $224 = $add_ptr16_i_i;
       $add_ptr4_sum_i50_i = $cond_i43_i + $nb_0 | 0;
       $add_ptr17_i_i = $tbase_292_i + $add_ptr4_sum_i50_i | 0;
       $225 = $add_ptr17_i_i;
       $sub18_i_i = $add_ptr16_i_i - ($tbase_292_i + $cond_i43_i) - $nb_0 | 0;
       HEAP32[$tbase_292_i + ($cond_i43_i + 4) >> 2] = $nb_0 | 3;
       do {
        if (($224 | 0) == (HEAP32[11608] | 0)) {
         $add_i_i = (HEAP32[11605] | 0) + $sub18_i_i | 0;
         HEAP32[11605] = $add_i_i;
         HEAP32[11608] = $225;
         HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 4) >> 2] = $add_i_i | 1;
        } else {
         if (($224 | 0) == (HEAP32[11607] | 0)) {
          $add26_i_i = (HEAP32[11604] | 0) + $sub18_i_i | 0;
          HEAP32[11604] = $add26_i_i;
          HEAP32[11607] = $225;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 4) >> 2] = $add26_i_i | 1;
          HEAP32[$tbase_292_i + ($add26_i_i + $add_ptr4_sum_i50_i) >> 2] = $add26_i_i;
          break;
         }
         $add_ptr16_sum_i_i = $tsize_291_i + 4 | 0;
         $234 = HEAP32[$tbase_292_i + ($add_ptr16_sum_i_i + $cond15_i_i) >> 2] | 0;
         if (($234 & 3 | 0) == 1) {
          $and37_i_i = $234 & -8;
          $shr_i55_i = $234 >>> 3;
          L1009 : do {
           if ($234 >>> 0 < 256) {
            $236 = HEAP32[$tbase_292_i + (($cond15_i_i | 8) + $tsize_291_i) >> 2] | 0;
            $238 = HEAP32[$tbase_292_i + ($tsize_291_i + 12 + $cond15_i_i) >> 2] | 0;
            $239 = 46448 + ($shr_i55_i << 1 << 2) | 0;
            do {
             if (($236 | 0) != ($239 | 0)) {
              if ($236 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
               _abort();
               return 0;
              }
              if ((HEAP32[$236 + 12 >> 2] | 0) == ($224 | 0)) {
               break;
              }
              _abort();
              return 0;
             }
            } while (0);
            if (($238 | 0) == ($236 | 0)) {
             HEAP32[11602] = HEAP32[11602] & ~(1 << $shr_i55_i);
             break;
            }
            do {
             if (($238 | 0) == ($239 | 0)) {
              $fd68_pre_phi_i_i = $238 + 8 | 0;
             } else {
              if ($238 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
               _abort();
               return 0;
              }
              $fd59_i_i = $238 + 8 | 0;
              if ((HEAP32[$fd59_i_i >> 2] | 0) == ($224 | 0)) {
               $fd68_pre_phi_i_i = $fd59_i_i;
               break;
              }
              _abort();
              return 0;
             }
            } while (0);
            HEAP32[$236 + 12 >> 2] = $238;
            HEAP32[$fd68_pre_phi_i_i >> 2] = $236;
           } else {
            $247 = $add_ptr16_i_i;
            $249 = HEAP32[$tbase_292_i + (($cond15_i_i | 24) + $tsize_291_i) >> 2] | 0;
            $251 = HEAP32[$tbase_292_i + ($tsize_291_i + 12 + $cond15_i_i) >> 2] | 0;
            do {
             if (($251 | 0) == ($247 | 0)) {
              $add_ptr16_sum56_i_i = $cond15_i_i | 16;
              $258 = $tbase_292_i + ($add_ptr16_sum_i_i + $add_ptr16_sum56_i_i) | 0;
              $259 = HEAP32[$258 >> 2] | 0;
              if (($259 | 0) == 0) {
               $arrayidx99_i_i = $tbase_292_i + ($add_ptr16_sum56_i_i + $tsize_291_i) | 0;
               $260 = HEAP32[$arrayidx99_i_i >> 2] | 0;
               if (($260 | 0) == 0) {
                $R_1_i_i = 0;
                break;
               } else {
                $R_0_i_i = $260;
                $RP_0_i_i = $arrayidx99_i_i;
               }
              } else {
               $R_0_i_i = $259;
               $RP_0_i_i = $258;
              }
              while (1) {
               $arrayidx103_i_i = $R_0_i_i + 20 | 0;
               $261 = HEAP32[$arrayidx103_i_i >> 2] | 0;
               if (($261 | 0) != 0) {
                $R_0_i_i = $261;
                $RP_0_i_i = $arrayidx103_i_i;
                continue;
               }
               $arrayidx107_i_i = $R_0_i_i + 16 | 0;
               $262 = HEAP32[$arrayidx107_i_i >> 2] | 0;
               if (($262 | 0) == 0) {
                break;
               } else {
                $R_0_i_i = $262;
                $RP_0_i_i = $arrayidx107_i_i;
               }
              }
              if ($RP_0_i_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
               _abort();
               return 0;
              } else {
               HEAP32[$RP_0_i_i >> 2] = 0;
               $R_1_i_i = $R_0_i_i;
               break;
              }
             } else {
              $253 = HEAP32[$tbase_292_i + (($cond15_i_i | 8) + $tsize_291_i) >> 2] | 0;
              if ($253 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
               _abort();
               return 0;
              }
              $bk82_i_i = $253 + 12 | 0;
              if ((HEAP32[$bk82_i_i >> 2] | 0) != ($247 | 0)) {
               _abort();
               return 0;
              }
              $fd85_i_i = $251 + 8 | 0;
              if ((HEAP32[$fd85_i_i >> 2] | 0) == ($247 | 0)) {
               HEAP32[$bk82_i_i >> 2] = $251;
               HEAP32[$fd85_i_i >> 2] = $253;
               $R_1_i_i = $251;
               break;
              } else {
               _abort();
               return 0;
              }
             }
            } while (0);
            if (($249 | 0) == 0) {
             break;
            }
            $265 = $tbase_292_i + ($tsize_291_i + 28 + $cond15_i_i) | 0;
            $arrayidx123_i_i = 46712 + (HEAP32[$265 >> 2] << 2) | 0;
            do {
             if (($247 | 0) == (HEAP32[$arrayidx123_i_i >> 2] | 0)) {
              HEAP32[$arrayidx123_i_i >> 2] = $R_1_i_i;
              if (($R_1_i_i | 0) != 0) {
               break;
              }
              HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$265 >> 2]);
              break L1009;
             } else {
              if ($249 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
               _abort();
               return 0;
              }
              $arrayidx143_i_i = $249 + 16 | 0;
              if ((HEAP32[$arrayidx143_i_i >> 2] | 0) == ($247 | 0)) {
               HEAP32[$arrayidx143_i_i >> 2] = $R_1_i_i;
              } else {
               HEAP32[$249 + 20 >> 2] = $R_1_i_i;
              }
              if (($R_1_i_i | 0) == 0) {
               break L1009;
              }
             }
            } while (0);
            if ($R_1_i_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
             _abort();
             return 0;
            }
            HEAP32[$R_1_i_i + 24 >> 2] = $249;
            $add_ptr16_sum2728_i_i = $cond15_i_i | 16;
            $275 = HEAP32[$tbase_292_i + ($add_ptr16_sum2728_i_i + $tsize_291_i) >> 2] | 0;
            do {
             if (($275 | 0) != 0) {
              if ($275 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
               _abort();
               return 0;
              } else {
               HEAP32[$R_1_i_i + 16 >> 2] = $275;
               HEAP32[$275 + 24 >> 2] = $R_1_i_i;
               break;
              }
             }
            } while (0);
            $279 = HEAP32[$tbase_292_i + ($add_ptr16_sum_i_i + $add_ptr16_sum2728_i_i) >> 2] | 0;
            if (($279 | 0) == 0) {
             break;
            }
            if ($279 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
             _abort();
             return 0;
            } else {
             HEAP32[$R_1_i_i + 20 >> 2] = $279;
             HEAP32[$279 + 24 >> 2] = $R_1_i_i;
             break;
            }
           }
          } while (0);
          $oldfirst_0_i_i = $tbase_292_i + (($and37_i_i | $cond15_i_i) + $tsize_291_i) | 0;
          $qsize_0_i_i = $and37_i_i + $sub18_i_i | 0;
         } else {
          $oldfirst_0_i_i = $224;
          $qsize_0_i_i = $sub18_i_i;
         }
         $head208_i_i = $oldfirst_0_i_i + 4 | 0;
         HEAP32[$head208_i_i >> 2] = HEAP32[$head208_i_i >> 2] & -2;
         HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 4) >> 2] = $qsize_0_i_i | 1;
         HEAP32[$tbase_292_i + ($qsize_0_i_i + $add_ptr4_sum_i50_i) >> 2] = $qsize_0_i_i;
         $shr214_i_i = $qsize_0_i_i >>> 3;
         if ($qsize_0_i_i >>> 0 < 256) {
          $shl221_i_i = $shr214_i_i << 1;
          $285 = 46448 + ($shl221_i_i << 2) | 0;
          $286 = HEAP32[11602] | 0;
          $shl226_i_i = 1 << $shr214_i_i;
          do {
           if (($286 & $shl226_i_i | 0) == 0) {
            HEAP32[11602] = $286 | $shl226_i_i;
            $F224_0_i_i = $285;
            $_pre_phi_i68_i = 46448 + ($shl221_i_i + 2 << 2) | 0;
           } else {
            $287 = 46448 + ($shl221_i_i + 2 << 2) | 0;
            $288 = HEAP32[$287 >> 2] | 0;
            if ($288 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
             $F224_0_i_i = $288;
             $_pre_phi_i68_i = $287;
             break;
            }
            _abort();
            return 0;
           }
          } while (0);
          HEAP32[$_pre_phi_i68_i >> 2] = $225;
          HEAP32[$F224_0_i_i + 12 >> 2] = $225;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 8) >> 2] = $F224_0_i_i;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 12) >> 2] = $285;
          break;
         }
         $293 = $add_ptr17_i_i;
         $shr253_i_i = $qsize_0_i_i >>> 8;
         do {
          if (($shr253_i_i | 0) == 0) {
           $I252_0_i_i = 0;
          } else {
           if ($qsize_0_i_i >>> 0 > 16777215) {
            $I252_0_i_i = 31;
            break;
           }
           $and264_i_i = ($shr253_i_i + 1048320 | 0) >>> 16 & 8;
           $shl265_i_i = $shr253_i_i << $and264_i_i;
           $and268_i_i = ($shl265_i_i + 520192 | 0) >>> 16 & 4;
           $shl270_i_i = $shl265_i_i << $and268_i_i;
           $and273_i_i = ($shl270_i_i + 245760 | 0) >>> 16 & 2;
           $add278_i_i = 14 - ($and268_i_i | $and264_i_i | $and273_i_i) + ($shl270_i_i << $and273_i_i >>> 15) | 0;
           $I252_0_i_i = $qsize_0_i_i >>> (($add278_i_i + 7 | 0) >>> 0) & 1 | $add278_i_i << 1;
          }
         } while (0);
         $arrayidx287_i_i = 46712 + ($I252_0_i_i << 2) | 0;
         HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 28) >> 2] = $I252_0_i_i;
         HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 20) >> 2] = 0;
         HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 16) >> 2] = 0;
         $296 = HEAP32[11603] | 0;
         $shl294_i_i = 1 << $I252_0_i_i;
         if (($296 & $shl294_i_i | 0) == 0) {
          HEAP32[11603] = $296 | $shl294_i_i;
          HEAP32[$arrayidx287_i_i >> 2] = $293;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 24) >> 2] = $arrayidx287_i_i;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 12) >> 2] = $293;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 8) >> 2] = $293;
          break;
         }
         if (($I252_0_i_i | 0) == 31) {
          $cond315_i_i = 0;
         } else {
          $cond315_i_i = 25 - ($I252_0_i_i >>> 1) | 0;
         }
         $K305_0_i_i = $qsize_0_i_i << $cond315_i_i;
         $T_0_i69_i = HEAP32[$arrayidx287_i_i >> 2] | 0;
         while (1) {
          if ((HEAP32[$T_0_i69_i + 4 >> 2] & -8 | 0) == ($qsize_0_i_i | 0)) {
           break;
          }
          $arrayidx325_i_i = $T_0_i69_i + 16 + ($K305_0_i_i >>> 31 << 2) | 0;
          $303 = HEAP32[$arrayidx325_i_i >> 2] | 0;
          if (($303 | 0) == 0) {
           label = 793;
           break;
          } else {
           $K305_0_i_i = $K305_0_i_i << 1;
           $T_0_i69_i = $303;
          }
         }
         if ((label | 0) == 793) {
          if ($arrayidx325_i_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
           _abort();
           return 0;
          } else {
           HEAP32[$arrayidx325_i_i >> 2] = $293;
           HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 24) >> 2] = $T_0_i69_i;
           HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 12) >> 2] = $293;
           HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 8) >> 2] = $293;
           break;
          }
         }
         $fd344_i_i = $T_0_i69_i + 8 | 0;
         $309 = HEAP32[$fd344_i_i >> 2] | 0;
         $311 = HEAP32[11606] | 0;
         if ($T_0_i69_i >>> 0 < $311 >>> 0) {
          _abort();
          return 0;
         }
         if ($309 >>> 0 < $311 >>> 0) {
          _abort();
          return 0;
         } else {
          HEAP32[$309 + 12 >> 2] = $293;
          HEAP32[$fd344_i_i >> 2] = $293;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 8) >> 2] = $309;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 12) >> 2] = $T_0_i69_i;
          HEAP32[$tbase_292_i + ($add_ptr4_sum_i50_i + 24) >> 2] = 0;
          break;
         }
        }
       } while (0);
       $mem_0 = $tbase_292_i + ($cond_i43_i | 8) | 0;
       return $mem_0 | 0;
      }
     } while (0);
     $316 = $189;
     $sp_0_i_i_i = 46856;
     while (1) {
      $317 = HEAP32[$sp_0_i_i_i >> 2] | 0;
      if ($317 >>> 0 <= $316 >>> 0) {
       $318 = HEAP32[$sp_0_i_i_i + 4 >> 2] | 0;
       $add_ptr_i_i_i = $317 + $318 | 0;
       if ($add_ptr_i_i_i >>> 0 > $316 >>> 0) {
        break;
       }
      }
      $sp_0_i_i_i = HEAP32[$sp_0_i_i_i + 8 >> 2] | 0;
     }
     $320 = $317 + ($318 - 39) | 0;
     if (($320 & 7 | 0) == 0) {
      $cond_i18_i = 0;
     } else {
      $cond_i18_i = -$320 & 7;
     }
     $add_ptr7_i_i = $317 + ($318 - 47 + $cond_i18_i) | 0;
     $cond13_i_i = $add_ptr7_i_i >>> 0 < ($189 + 16 | 0) >>> 0 ? $316 : $add_ptr7_i_i;
     $add_ptr14_i_i = $cond13_i_i + 8 | 0;
     $323 = $tbase_292_i + 8 | 0;
     if (($323 & 7 | 0) == 0) {
      $cond_i_i_i = 0;
     } else {
      $cond_i_i_i = -$323 & 7;
     }
     $sub5_i_i_i = $tsize_291_i - 40 - $cond_i_i_i | 0;
     HEAP32[11608] = $tbase_292_i + $cond_i_i_i;
     HEAP32[11605] = $sub5_i_i_i;
     HEAP32[$tbase_292_i + ($cond_i_i_i + 4) >> 2] = $sub5_i_i_i | 1;
     HEAP32[$tbase_292_i + ($tsize_291_i - 36) >> 2] = 40;
     HEAP32[11609] = HEAP32[10828];
     HEAP32[$cond13_i_i + 4 >> 2] = 27;
     HEAP32[$add_ptr14_i_i >> 2] = HEAP32[11714];
     HEAP32[$add_ptr14_i_i + 4 >> 2] = HEAP32[46860 >> 2];
     HEAP32[$add_ptr14_i_i + 8 >> 2] = HEAP32[46864 >> 2];
     HEAP32[$add_ptr14_i_i + 12 >> 2] = HEAP32[46868 >> 2];
     HEAP32[11714] = $tbase_292_i;
     HEAP32[11715] = $tsize_291_i;
     HEAP32[11717] = 0;
     HEAP32[11716] = $add_ptr14_i_i;
     $330 = $cond13_i_i + 28 | 0;
     HEAP32[$330 >> 2] = 7;
     if (($cond13_i_i + 32 | 0) >>> 0 < $add_ptr_i_i_i >>> 0) {
      $add_ptr2416_i_i = $330;
      while (1) {
       $332 = $add_ptr2416_i_i + 4 | 0;
       HEAP32[$332 >> 2] = 7;
       if (($add_ptr2416_i_i + 8 | 0) >>> 0 < $add_ptr_i_i_i >>> 0) {
        $add_ptr2416_i_i = $332;
       } else {
        break;
       }
      }
     }
     if (($cond13_i_i | 0) == ($316 | 0)) {
      break;
     }
     $sub_ptr_sub_i_i = $cond13_i_i - $189 | 0;
     $335 = $316 + ($sub_ptr_sub_i_i + 4) | 0;
     HEAP32[$335 >> 2] = HEAP32[$335 >> 2] & -2;
     HEAP32[$189 + 4 >> 2] = $sub_ptr_sub_i_i | 1;
     HEAP32[$316 + $sub_ptr_sub_i_i >> 2] = $sub_ptr_sub_i_i;
     $shr_i_i = $sub_ptr_sub_i_i >>> 3;
     if ($sub_ptr_sub_i_i >>> 0 < 256) {
      $shl_i21_i = $shr_i_i << 1;
      $337 = 46448 + ($shl_i21_i << 2) | 0;
      $338 = HEAP32[11602] | 0;
      $shl39_i_i = 1 << $shr_i_i;
      do {
       if (($338 & $shl39_i_i | 0) == 0) {
        HEAP32[11602] = $338 | $shl39_i_i;
        $F_0_i_i = $337;
        $_pre_phi_i_i = 46448 + ($shl_i21_i + 2 << 2) | 0;
       } else {
        $339 = 46448 + ($shl_i21_i + 2 << 2) | 0;
        $340 = HEAP32[$339 >> 2] | 0;
        if ($340 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
         $F_0_i_i = $340;
         $_pre_phi_i_i = $339;
         break;
        }
        _abort();
        return 0;
       }
      } while (0);
      HEAP32[$_pre_phi_i_i >> 2] = $189;
      HEAP32[$F_0_i_i + 12 >> 2] = $189;
      HEAP32[$189 + 8 >> 2] = $F_0_i_i;
      HEAP32[$189 + 12 >> 2] = $337;
      break;
     }
     $343 = $189;
     $shr58_i_i = $sub_ptr_sub_i_i >>> 8;
     do {
      if (($shr58_i_i | 0) == 0) {
       $I57_0_i_i = 0;
      } else {
       if ($sub_ptr_sub_i_i >>> 0 > 16777215) {
        $I57_0_i_i = 31;
        break;
       }
       $and69_i_i = ($shr58_i_i + 1048320 | 0) >>> 16 & 8;
       $shl70_i_i = $shr58_i_i << $and69_i_i;
       $and73_i_i = ($shl70_i_i + 520192 | 0) >>> 16 & 4;
       $shl75_i_i = $shl70_i_i << $and73_i_i;
       $and78_i_i = ($shl75_i_i + 245760 | 0) >>> 16 & 2;
       $add83_i_i = 14 - ($and73_i_i | $and69_i_i | $and78_i_i) + ($shl75_i_i << $and78_i_i >>> 15) | 0;
       $I57_0_i_i = $sub_ptr_sub_i_i >>> (($add83_i_i + 7 | 0) >>> 0) & 1 | $add83_i_i << 1;
      }
     } while (0);
     $arrayidx91_i_i = 46712 + ($I57_0_i_i << 2) | 0;
     HEAP32[$189 + 28 >> 2] = $I57_0_i_i;
     HEAP32[$189 + 20 >> 2] = 0;
     HEAP32[$189 + 16 >> 2] = 0;
     $345 = HEAP32[11603] | 0;
     $shl95_i_i = 1 << $I57_0_i_i;
     if (($345 & $shl95_i_i | 0) == 0) {
      HEAP32[11603] = $345 | $shl95_i_i;
      HEAP32[$arrayidx91_i_i >> 2] = $343;
      HEAP32[$189 + 24 >> 2] = $arrayidx91_i_i;
      HEAP32[$189 + 12 >> 2] = $189;
      HEAP32[$189 + 8 >> 2] = $189;
      break;
     }
     if (($I57_0_i_i | 0) == 31) {
      $cond115_i_i = 0;
     } else {
      $cond115_i_i = 25 - ($I57_0_i_i >>> 1) | 0;
     }
     $K105_0_i_i = $sub_ptr_sub_i_i << $cond115_i_i;
     $T_0_i_i = HEAP32[$arrayidx91_i_i >> 2] | 0;
     while (1) {
      if ((HEAP32[$T_0_i_i + 4 >> 2] & -8 | 0) == ($sub_ptr_sub_i_i | 0)) {
       break;
      }
      $arrayidx126_i_i = $T_0_i_i + 16 + ($K105_0_i_i >>> 31 << 2) | 0;
      $348 = HEAP32[$arrayidx126_i_i >> 2] | 0;
      if (($348 | 0) == 0) {
       label = 828;
       break;
      } else {
       $K105_0_i_i = $K105_0_i_i << 1;
       $T_0_i_i = $348;
      }
     }
     if ((label | 0) == 828) {
      if ($arrayidx126_i_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
       _abort();
       return 0;
      } else {
       HEAP32[$arrayidx126_i_i >> 2] = $343;
       HEAP32[$189 + 24 >> 2] = $T_0_i_i;
       HEAP32[$189 + 12 >> 2] = $189;
       HEAP32[$189 + 8 >> 2] = $189;
       break;
      }
     }
     $fd145_i_i = $T_0_i_i + 8 | 0;
     $351 = HEAP32[$fd145_i_i >> 2] | 0;
     $353 = HEAP32[11606] | 0;
     if ($T_0_i_i >>> 0 < $353 >>> 0) {
      _abort();
      return 0;
     }
     if ($351 >>> 0 < $353 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$351 + 12 >> 2] = $343;
      HEAP32[$fd145_i_i >> 2] = $343;
      HEAP32[$189 + 8 >> 2] = $351;
      HEAP32[$189 + 12 >> 2] = $T_0_i_i;
      HEAP32[$189 + 24 >> 2] = 0;
      break;
     }
    }
   } while (0);
   $355 = HEAP32[11605] | 0;
   if ($355 >>> 0 <= $nb_0 >>> 0) {
    break;
   }
   $sub253_i = $355 - $nb_0 | 0;
   HEAP32[11605] = $sub253_i;
   $356 = HEAP32[11608] | 0;
   $357 = $356;
   HEAP32[11608] = $357 + $nb_0;
   HEAP32[$357 + ($nb_0 + 4) >> 2] = $sub253_i | 1;
   HEAP32[$356 + 4 >> 2] = $nb_0 | 3;
   $mem_0 = $356 + 8 | 0;
   return $mem_0 | 0;
  }
 } while (0);
 HEAP32[(___errno_location() | 0) >> 2] = 12;
 $mem_0 = 0;
 return $mem_0 | 0;
}
function _free($mem) {
 $mem = $mem | 0;
 var $add_ptr = 0, $0 = 0, $1 = 0, $3 = 0, $and = 0, $and5 = 0, $add_ptr6 = 0, $4 = 0, $5 = 0, $add_ptr_sum232 = 0, $add_ptr16 = 0, $6 = 0, $add17 = 0, $shr = 0, $9 = 0, $11 = 0, $12 = 0, $fd56 = 0, $fd67_pre_phi = 0, $18 = 0, $20 = 0, $22 = 0, $24 = 0, $bk82 = 0, $fd86 = 0, $28 = 0, $29 = 0, $arrayidx103 = 0, $30 = 0, $RP_0 = 0, $R_0 = 0, $arrayidx108 = 0, $31 = 0, $arrayidx113 = 0, $32 = 0, $R_1 = 0, $34 = 0, $arrayidx130 = 0, $arrayidx149 = 0, $44 = 0, $48 = 0, $51 = 0, $psize_0 = 0, $p_0 = 0, $55 = 0, $56 = 0, $57 = 0, $add243 = 0, $add258 = 0, $add266 = 0, $shr267 = 0, $66 = 0, $68 = 0, $69 = 0, $fd310 = 0, $fd321_pre_phi = 0, $77 = 0, $79 = 0, $81 = 0, $83 = 0, $bk342 = 0, $fd346 = 0, $88 = 0, $89 = 0, $arrayidx366 = 0, $90 = 0, $RP359_0 = 0, $R331_0 = 0, $arrayidx373 = 0, $91 = 0, $arrayidx378 = 0, $92 = 0, $R331_1 = 0, $95 = 0, $arrayidx399 = 0, $arrayidx418 = 0, $105 = 0, $109 = 0, $psize_1 = 0, $shr497 = 0, $shl504 = 0, $113 = 0, $114 = 0, $shl507 = 0, $115 = 0, $116 = 0, $_pre_phi = 0, $F506_0 = 0, $119 = 0, $shr531 = 0, $and541 = 0, $shl542 = 0, $and545 = 0, $shl547 = 0, $and550 = 0, $add555 = 0, $I530_0 = 0, $arrayidx563 = 0, $121 = 0, $shl569 = 0, $cond = 0, $T_0 = 0, $K579_0 = 0, $arrayidx595 = 0, $124 = 0, $fd613 = 0, $127 = 0, $129 = 0, $dec = 0, $sp_0_in_i = 0, $sp_0_i = 0, label = 0;
 if (($mem | 0) == 0) {
  return;
 }
 $add_ptr = $mem - 8 | 0;
 $0 = $add_ptr;
 $1 = HEAP32[11606] | 0;
 if ($add_ptr >>> 0 < $1 >>> 0) {
  _abort();
 }
 $3 = HEAP32[$mem - 4 >> 2] | 0;
 $and = $3 & 3;
 if (($and | 0) == 1) {
  _abort();
 }
 $and5 = $3 & -8;
 $add_ptr6 = $mem + ($and5 - 8) | 0;
 $4 = $add_ptr6;
 L1181 : do {
  if (($3 & 1 | 0) == 0) {
   $5 = HEAP32[$add_ptr >> 2] | 0;
   if (($and | 0) == 0) {
    return;
   }
   $add_ptr_sum232 = -8 - $5 | 0;
   $add_ptr16 = $mem + $add_ptr_sum232 | 0;
   $6 = $add_ptr16;
   $add17 = $5 + $and5 | 0;
   if ($add_ptr16 >>> 0 < $1 >>> 0) {
    _abort();
   }
   if (($6 | 0) == (HEAP32[11607] | 0)) {
    $51 = $mem + ($and5 - 4) | 0;
    if ((HEAP32[$51 >> 2] & 3 | 0) != 3) {
     $p_0 = $6;
     $psize_0 = $add17;
     break;
    }
    HEAP32[11604] = $add17;
    HEAP32[$51 >> 2] = HEAP32[$51 >> 2] & -2;
    HEAP32[$mem + ($add_ptr_sum232 + 4) >> 2] = $add17 | 1;
    HEAP32[$add_ptr6 >> 2] = $add17;
    return;
   }
   $shr = $5 >>> 3;
   if ($5 >>> 0 < 256) {
    $9 = HEAP32[$mem + ($add_ptr_sum232 + 8) >> 2] | 0;
    $11 = HEAP32[$mem + ($add_ptr_sum232 + 12) >> 2] | 0;
    $12 = 46448 + ($shr << 1 << 2) | 0;
    do {
     if (($9 | 0) != ($12 | 0)) {
      if ($9 >>> 0 < $1 >>> 0) {
       _abort();
      }
      if ((HEAP32[$9 + 12 >> 2] | 0) == ($6 | 0)) {
       break;
      }
      _abort();
     }
    } while (0);
    if (($11 | 0) == ($9 | 0)) {
     HEAP32[11602] = HEAP32[11602] & ~(1 << $shr);
     $p_0 = $6;
     $psize_0 = $add17;
     break;
    }
    do {
     if (($11 | 0) == ($12 | 0)) {
      $fd67_pre_phi = $11 + 8 | 0;
     } else {
      if ($11 >>> 0 < $1 >>> 0) {
       _abort();
      }
      $fd56 = $11 + 8 | 0;
      if ((HEAP32[$fd56 >> 2] | 0) == ($6 | 0)) {
       $fd67_pre_phi = $fd56;
       break;
      }
      _abort();
     }
    } while (0);
    HEAP32[$9 + 12 >> 2] = $11;
    HEAP32[$fd67_pre_phi >> 2] = $9;
    $p_0 = $6;
    $psize_0 = $add17;
    break;
   }
   $18 = $add_ptr16;
   $20 = HEAP32[$mem + ($add_ptr_sum232 + 24) >> 2] | 0;
   $22 = HEAP32[$mem + ($add_ptr_sum232 + 12) >> 2] | 0;
   do {
    if (($22 | 0) == ($18 | 0)) {
     $28 = $mem + ($add_ptr_sum232 + 20) | 0;
     $29 = HEAP32[$28 >> 2] | 0;
     if (($29 | 0) == 0) {
      $arrayidx103 = $mem + ($add_ptr_sum232 + 16) | 0;
      $30 = HEAP32[$arrayidx103 >> 2] | 0;
      if (($30 | 0) == 0) {
       $R_1 = 0;
       break;
      } else {
       $R_0 = $30;
       $RP_0 = $arrayidx103;
      }
     } else {
      $R_0 = $29;
      $RP_0 = $28;
     }
     while (1) {
      $arrayidx108 = $R_0 + 20 | 0;
      $31 = HEAP32[$arrayidx108 >> 2] | 0;
      if (($31 | 0) != 0) {
       $R_0 = $31;
       $RP_0 = $arrayidx108;
       continue;
      }
      $arrayidx113 = $R_0 + 16 | 0;
      $32 = HEAP32[$arrayidx113 >> 2] | 0;
      if (($32 | 0) == 0) {
       break;
      } else {
       $R_0 = $32;
       $RP_0 = $arrayidx113;
      }
     }
     if ($RP_0 >>> 0 < $1 >>> 0) {
      _abort();
     } else {
      HEAP32[$RP_0 >> 2] = 0;
      $R_1 = $R_0;
      break;
     }
    } else {
     $24 = HEAP32[$mem + ($add_ptr_sum232 + 8) >> 2] | 0;
     if ($24 >>> 0 < $1 >>> 0) {
      _abort();
     }
     $bk82 = $24 + 12 | 0;
     if ((HEAP32[$bk82 >> 2] | 0) != ($18 | 0)) {
      _abort();
     }
     $fd86 = $22 + 8 | 0;
     if ((HEAP32[$fd86 >> 2] | 0) == ($18 | 0)) {
      HEAP32[$bk82 >> 2] = $22;
      HEAP32[$fd86 >> 2] = $24;
      $R_1 = $22;
      break;
     } else {
      _abort();
     }
    }
   } while (0);
   if (($20 | 0) == 0) {
    $p_0 = $6;
    $psize_0 = $add17;
    break;
   }
   $34 = $mem + ($add_ptr_sum232 + 28) | 0;
   $arrayidx130 = 46712 + (HEAP32[$34 >> 2] << 2) | 0;
   do {
    if (($18 | 0) == (HEAP32[$arrayidx130 >> 2] | 0)) {
     HEAP32[$arrayidx130 >> 2] = $R_1;
     if (($R_1 | 0) != 0) {
      break;
     }
     HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$34 >> 2]);
     $p_0 = $6;
     $psize_0 = $add17;
     break L1181;
    } else {
     if ($20 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     }
     $arrayidx149 = $20 + 16 | 0;
     if ((HEAP32[$arrayidx149 >> 2] | 0) == ($18 | 0)) {
      HEAP32[$arrayidx149 >> 2] = $R_1;
     } else {
      HEAP32[$20 + 20 >> 2] = $R_1;
     }
     if (($R_1 | 0) == 0) {
      $p_0 = $6;
      $psize_0 = $add17;
      break L1181;
     }
    }
   } while (0);
   if ($R_1 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
    _abort();
   }
   HEAP32[$R_1 + 24 >> 2] = $20;
   $44 = HEAP32[$mem + ($add_ptr_sum232 + 16) >> 2] | 0;
   do {
    if (($44 | 0) != 0) {
     if ($44 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[$R_1 + 16 >> 2] = $44;
      HEAP32[$44 + 24 >> 2] = $R_1;
      break;
     }
    }
   } while (0);
   $48 = HEAP32[$mem + ($add_ptr_sum232 + 20) >> 2] | 0;
   if (($48 | 0) == 0) {
    $p_0 = $6;
    $psize_0 = $add17;
    break;
   }
   if ($48 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
    _abort();
   } else {
    HEAP32[$R_1 + 20 >> 2] = $48;
    HEAP32[$48 + 24 >> 2] = $R_1;
    $p_0 = $6;
    $psize_0 = $add17;
    break;
   }
  } else {
   $p_0 = $0;
   $psize_0 = $and5;
  }
 } while (0);
 $55 = $p_0;
 if ($55 >>> 0 >= $add_ptr6 >>> 0) {
  _abort();
 }
 $56 = $mem + ($and5 - 4) | 0;
 $57 = HEAP32[$56 >> 2] | 0;
 if (($57 & 1 | 0) == 0) {
  _abort();
 }
 do {
  if (($57 & 2 | 0) == 0) {
   if (($4 | 0) == (HEAP32[11608] | 0)) {
    $add243 = (HEAP32[11605] | 0) + $psize_0 | 0;
    HEAP32[11605] = $add243;
    HEAP32[11608] = $p_0;
    HEAP32[$p_0 + 4 >> 2] = $add243 | 1;
    if (($p_0 | 0) == (HEAP32[11607] | 0)) {
     HEAP32[11607] = 0;
     HEAP32[11604] = 0;
    }
    if ($add243 >>> 0 <= (HEAP32[11609] | 0) >>> 0) {
     return;
    }
    _sys_trim(0) | 0;
    return;
   }
   if (($4 | 0) == (HEAP32[11607] | 0)) {
    $add258 = (HEAP32[11604] | 0) + $psize_0 | 0;
    HEAP32[11604] = $add258;
    HEAP32[11607] = $p_0;
    HEAP32[$p_0 + 4 >> 2] = $add258 | 1;
    HEAP32[$55 + $add258 >> 2] = $add258;
    return;
   }
   $add266 = ($57 & -8) + $psize_0 | 0;
   $shr267 = $57 >>> 3;
   L1287 : do {
    if ($57 >>> 0 < 256) {
     $66 = HEAP32[$mem + $and5 >> 2] | 0;
     $68 = HEAP32[$mem + ($and5 | 4) >> 2] | 0;
     $69 = 46448 + ($shr267 << 1 << 2) | 0;
     do {
      if (($66 | 0) != ($69 | 0)) {
       if ($66 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       }
       if ((HEAP32[$66 + 12 >> 2] | 0) == ($4 | 0)) {
        break;
       }
       _abort();
      }
     } while (0);
     if (($68 | 0) == ($66 | 0)) {
      HEAP32[11602] = HEAP32[11602] & ~(1 << $shr267);
      break;
     }
     do {
      if (($68 | 0) == ($69 | 0)) {
       $fd321_pre_phi = $68 + 8 | 0;
      } else {
       if ($68 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       }
       $fd310 = $68 + 8 | 0;
       if ((HEAP32[$fd310 >> 2] | 0) == ($4 | 0)) {
        $fd321_pre_phi = $fd310;
        break;
       }
       _abort();
      }
     } while (0);
     HEAP32[$66 + 12 >> 2] = $68;
     HEAP32[$fd321_pre_phi >> 2] = $66;
    } else {
     $77 = $add_ptr6;
     $79 = HEAP32[$mem + ($and5 + 16) >> 2] | 0;
     $81 = HEAP32[$mem + ($and5 | 4) >> 2] | 0;
     do {
      if (($81 | 0) == ($77 | 0)) {
       $88 = $mem + ($and5 + 12) | 0;
       $89 = HEAP32[$88 >> 2] | 0;
       if (($89 | 0) == 0) {
        $arrayidx366 = $mem + ($and5 + 8) | 0;
        $90 = HEAP32[$arrayidx366 >> 2] | 0;
        if (($90 | 0) == 0) {
         $R331_1 = 0;
         break;
        } else {
         $R331_0 = $90;
         $RP359_0 = $arrayidx366;
        }
       } else {
        $R331_0 = $89;
        $RP359_0 = $88;
       }
       while (1) {
        $arrayidx373 = $R331_0 + 20 | 0;
        $91 = HEAP32[$arrayidx373 >> 2] | 0;
        if (($91 | 0) != 0) {
         $R331_0 = $91;
         $RP359_0 = $arrayidx373;
         continue;
        }
        $arrayidx378 = $R331_0 + 16 | 0;
        $92 = HEAP32[$arrayidx378 >> 2] | 0;
        if (($92 | 0) == 0) {
         break;
        } else {
         $R331_0 = $92;
         $RP359_0 = $arrayidx378;
        }
       }
       if ($RP359_0 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[$RP359_0 >> 2] = 0;
        $R331_1 = $R331_0;
        break;
       }
      } else {
       $83 = HEAP32[$mem + $and5 >> 2] | 0;
       if ($83 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       }
       $bk342 = $83 + 12 | 0;
       if ((HEAP32[$bk342 >> 2] | 0) != ($77 | 0)) {
        _abort();
       }
       $fd346 = $81 + 8 | 0;
       if ((HEAP32[$fd346 >> 2] | 0) == ($77 | 0)) {
        HEAP32[$bk342 >> 2] = $81;
        HEAP32[$fd346 >> 2] = $83;
        $R331_1 = $81;
        break;
       } else {
        _abort();
       }
      }
     } while (0);
     if (($79 | 0) == 0) {
      break;
     }
     $95 = $mem + ($and5 + 20) | 0;
     $arrayidx399 = 46712 + (HEAP32[$95 >> 2] << 2) | 0;
     do {
      if (($77 | 0) == (HEAP32[$arrayidx399 >> 2] | 0)) {
       HEAP32[$arrayidx399 >> 2] = $R331_1;
       if (($R331_1 | 0) != 0) {
        break;
       }
       HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$95 >> 2]);
       break L1287;
      } else {
       if ($79 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       }
       $arrayidx418 = $79 + 16 | 0;
       if ((HEAP32[$arrayidx418 >> 2] | 0) == ($77 | 0)) {
        HEAP32[$arrayidx418 >> 2] = $R331_1;
       } else {
        HEAP32[$79 + 20 >> 2] = $R331_1;
       }
       if (($R331_1 | 0) == 0) {
        break L1287;
       }
      }
     } while (0);
     if ($R331_1 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     }
     HEAP32[$R331_1 + 24 >> 2] = $79;
     $105 = HEAP32[$mem + ($and5 + 8) >> 2] | 0;
     do {
      if (($105 | 0) != 0) {
       if ($105 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[$R331_1 + 16 >> 2] = $105;
        HEAP32[$105 + 24 >> 2] = $R331_1;
        break;
       }
      }
     } while (0);
     $109 = HEAP32[$mem + ($and5 + 12) >> 2] | 0;
     if (($109 | 0) == 0) {
      break;
     }
     if ($109 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[$R331_1 + 20 >> 2] = $109;
      HEAP32[$109 + 24 >> 2] = $R331_1;
      break;
     }
    }
   } while (0);
   HEAP32[$p_0 + 4 >> 2] = $add266 | 1;
   HEAP32[$55 + $add266 >> 2] = $add266;
   if (($p_0 | 0) != (HEAP32[11607] | 0)) {
    $psize_1 = $add266;
    break;
   }
   HEAP32[11604] = $add266;
   return;
  } else {
   HEAP32[$56 >> 2] = $57 & -2;
   HEAP32[$p_0 + 4 >> 2] = $psize_0 | 1;
   HEAP32[$55 + $psize_0 >> 2] = $psize_0;
   $psize_1 = $psize_0;
  }
 } while (0);
 $shr497 = $psize_1 >>> 3;
 if ($psize_1 >>> 0 < 256) {
  $shl504 = $shr497 << 1;
  $113 = 46448 + ($shl504 << 2) | 0;
  $114 = HEAP32[11602] | 0;
  $shl507 = 1 << $shr497;
  do {
   if (($114 & $shl507 | 0) == 0) {
    HEAP32[11602] = $114 | $shl507;
    $F506_0 = $113;
    $_pre_phi = 46448 + ($shl504 + 2 << 2) | 0;
   } else {
    $115 = 46448 + ($shl504 + 2 << 2) | 0;
    $116 = HEAP32[$115 >> 2] | 0;
    if ($116 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
     $F506_0 = $116;
     $_pre_phi = $115;
     break;
    }
    _abort();
   }
  } while (0);
  HEAP32[$_pre_phi >> 2] = $p_0;
  HEAP32[$F506_0 + 12 >> 2] = $p_0;
  HEAP32[$p_0 + 8 >> 2] = $F506_0;
  HEAP32[$p_0 + 12 >> 2] = $113;
  return;
 }
 $119 = $p_0;
 $shr531 = $psize_1 >>> 8;
 do {
  if (($shr531 | 0) == 0) {
   $I530_0 = 0;
  } else {
   if ($psize_1 >>> 0 > 16777215) {
    $I530_0 = 31;
    break;
   }
   $and541 = ($shr531 + 1048320 | 0) >>> 16 & 8;
   $shl542 = $shr531 << $and541;
   $and545 = ($shl542 + 520192 | 0) >>> 16 & 4;
   $shl547 = $shl542 << $and545;
   $and550 = ($shl547 + 245760 | 0) >>> 16 & 2;
   $add555 = 14 - ($and545 | $and541 | $and550) + ($shl547 << $and550 >>> 15) | 0;
   $I530_0 = $psize_1 >>> (($add555 + 7 | 0) >>> 0) & 1 | $add555 << 1;
  }
 } while (0);
 $arrayidx563 = 46712 + ($I530_0 << 2) | 0;
 HEAP32[$p_0 + 28 >> 2] = $I530_0;
 HEAP32[$p_0 + 20 >> 2] = 0;
 HEAP32[$p_0 + 16 >> 2] = 0;
 $121 = HEAP32[11603] | 0;
 $shl569 = 1 << $I530_0;
 do {
  if (($121 & $shl569 | 0) == 0) {
   HEAP32[11603] = $121 | $shl569;
   HEAP32[$arrayidx563 >> 2] = $119;
   HEAP32[$p_0 + 24 >> 2] = $arrayidx563;
   HEAP32[$p_0 + 12 >> 2] = $p_0;
   HEAP32[$p_0 + 8 >> 2] = $p_0;
  } else {
   if (($I530_0 | 0) == 31) {
    $cond = 0;
   } else {
    $cond = 25 - ($I530_0 >>> 1) | 0;
   }
   $K579_0 = $psize_1 << $cond;
   $T_0 = HEAP32[$arrayidx563 >> 2] | 0;
   while (1) {
    if ((HEAP32[$T_0 + 4 >> 2] & -8 | 0) == ($psize_1 | 0)) {
     break;
    }
    $arrayidx595 = $T_0 + 16 + ($K579_0 >>> 31 << 2) | 0;
    $124 = HEAP32[$arrayidx595 >> 2] | 0;
    if (($124 | 0) == 0) {
     label = 1007;
     break;
    } else {
     $K579_0 = $K579_0 << 1;
     $T_0 = $124;
    }
   }
   if ((label | 0) == 1007) {
    if ($arrayidx595 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
     _abort();
    } else {
     HEAP32[$arrayidx595 >> 2] = $119;
     HEAP32[$p_0 + 24 >> 2] = $T_0;
     HEAP32[$p_0 + 12 >> 2] = $p_0;
     HEAP32[$p_0 + 8 >> 2] = $p_0;
     break;
    }
   }
   $fd613 = $T_0 + 8 | 0;
   $127 = HEAP32[$fd613 >> 2] | 0;
   $129 = HEAP32[11606] | 0;
   if ($T_0 >>> 0 < $129 >>> 0) {
    _abort();
   }
   if ($127 >>> 0 < $129 >>> 0) {
    _abort();
   } else {
    HEAP32[$127 + 12 >> 2] = $119;
    HEAP32[$fd613 >> 2] = $119;
    HEAP32[$p_0 + 8 >> 2] = $127;
    HEAP32[$p_0 + 12 >> 2] = $T_0;
    HEAP32[$p_0 + 24 >> 2] = 0;
    break;
   }
  }
 } while (0);
 $dec = (HEAP32[11610] | 0) - 1 | 0;
 HEAP32[11610] = $dec;
 if (($dec | 0) == 0) {
  $sp_0_in_i = 46864;
 } else {
  return;
 }
 while (1) {
  $sp_0_i = HEAP32[$sp_0_in_i >> 2] | 0;
  if (($sp_0_i | 0) == 0) {
   break;
  } else {
   $sp_0_in_i = $sp_0_i + 8 | 0;
  }
 }
 HEAP32[11610] = -1;
 return;
}
function _calloc($n_elements, $elem_size) {
 $n_elements = $n_elements | 0;
 $elem_size = $elem_size | 0;
 var $mul = 0, $req_0 = 0, $call = 0;
 do {
  if (($n_elements | 0) == 0) {
   $req_0 = 0;
  } else {
   $mul = Math_imul($elem_size, $n_elements) | 0;
   if (($elem_size | $n_elements) >>> 0 <= 65535) {
    $req_0 = $mul;
    break;
   }
   $req_0 = (($mul >>> 0) / ($n_elements >>> 0) | 0 | 0) == ($elem_size | 0) ? $mul : -1;
  }
 } while (0);
 $call = _malloc($req_0) | 0;
 if (($call | 0) == 0) {
  return $call | 0;
 }
 if ((HEAP32[$call - 4 >> 2] & 3 | 0) == 0) {
  return $call | 0;
 }
 _memset($call | 0, 0, $req_0 | 0);
 return $call | 0;
}
function _realloc($oldmem, $bytes) {
 $oldmem = $oldmem | 0;
 $bytes = $bytes | 0;
 var $cond = 0, $call7 = 0, $call12 = 0, $3 = 0, $sub = 0, $cond24 = 0, $mem_0 = 0;
 if (($oldmem | 0) == 0) {
  $mem_0 = _malloc($bytes) | 0;
  return $mem_0 | 0;
 }
 if ($bytes >>> 0 > 4294967231) {
  HEAP32[(___errno_location() | 0) >> 2] = 12;
  $mem_0 = 0;
  return $mem_0 | 0;
 }
 if ($bytes >>> 0 < 11) {
  $cond = 16;
 } else {
  $cond = $bytes + 11 & -8;
 }
 $call7 = _try_realloc_chunk($oldmem - 8 | 0, $cond) | 0;
 if (($call7 | 0) != 0) {
  $mem_0 = $call7 + 8 | 0;
  return $mem_0 | 0;
 }
 $call12 = _malloc($bytes) | 0;
 if (($call12 | 0) == 0) {
  $mem_0 = 0;
  return $mem_0 | 0;
 }
 $3 = HEAP32[$oldmem - 4 >> 2] | 0;
 $sub = ($3 & -8) - (($3 & 3 | 0) == 0 ? 8 : 4) | 0;
 $cond24 = $sub >>> 0 < $bytes >>> 0 ? $sub : $bytes;
 _memcpy($call12 | 0, $oldmem | 0, $cond24) | 0;
 _free($oldmem);
 $mem_0 = $call12;
 return $mem_0 | 0;
}
function _realloc_in_place($oldmem, $bytes) {
 $oldmem = $oldmem | 0;
 $bytes = $bytes | 0;
 var $cond = 0, $0 = 0;
 if (($oldmem | 0) == 0) {
  return 0;
 }
 if ($bytes >>> 0 > 4294967231) {
  HEAP32[(___errno_location() | 0) >> 2] = 12;
  return 0;
 }
 if ($bytes >>> 0 < 11) {
  $cond = 16;
 } else {
  $cond = $bytes + 11 & -8;
 }
 $0 = $oldmem - 8 | 0;
 return ((_try_realloc_chunk($0, $cond) | 0) == ($0 | 0) ? $oldmem : 0) | 0;
}
function _memalign($alignment, $bytes) {
 $alignment = $alignment | 0;
 $bytes = $bytes | 0;
 var $retval_0 = 0;
 if ($alignment >>> 0 < 9) {
  $retval_0 = _malloc($bytes) | 0;
  return $retval_0 | 0;
 } else {
  $retval_0 = _internal_memalign($alignment, $bytes) | 0;
  return $retval_0 | 0;
 }
 return 0;
}
function _sys_trim($pad) {
 $pad = $pad | 0;
 var $call_i = 0, $1 = 0, $2 = 0, $3 = 0, $mul = 0, $4 = 0, $sp_0_i = 0, $5 = 0, $7 = 0, $retval_0_i = 0, $call20 = 0, $size = 0, $call24 = 0, $call25 = 0, $sub_ptr_sub = 0, $13 = 0, $sub41 = 0, $15 = 0, $16 = 0, $cond_i = 0, $sub5_i = 0, $released_2 = 0;
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i = _sysconf(8) | 0;
   if (($call_i - 1 & $call_i | 0) == 0) {
    HEAP32[10826] = $call_i;
    HEAP32[10825] = $call_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
    return 0;
   }
  }
 } while (0);
 if ($pad >>> 0 >= 4294967232) {
  $released_2 = 0;
  return $released_2 | 0;
 }
 $1 = HEAP32[11608] | 0;
 if (($1 | 0) == 0) {
  $released_2 = 0;
  return $released_2 | 0;
 }
 $2 = HEAP32[11605] | 0;
 do {
  if ($2 >>> 0 > ($pad + 40 | 0) >>> 0) {
   $3 = HEAP32[10826] | 0;
   $mul = Math_imul((((-40 - $pad - 1 + $2 + $3 | 0) >>> 0) / ($3 >>> 0) | 0) - 1 | 0, $3) | 0;
   $4 = $1;
   $sp_0_i = 46856;
   while (1) {
    $5 = HEAP32[$sp_0_i >> 2] | 0;
    if ($5 >>> 0 <= $4 >>> 0) {
     if (($5 + (HEAP32[$sp_0_i + 4 >> 2] | 0) | 0) >>> 0 > $4 >>> 0) {
      $retval_0_i = $sp_0_i;
      break;
     }
    }
    $7 = HEAP32[$sp_0_i + 8 >> 2] | 0;
    if (($7 | 0) == 0) {
     $retval_0_i = 0;
     break;
    } else {
     $sp_0_i = $7;
    }
   }
   if ((HEAP32[$retval_0_i + 12 >> 2] & 8 | 0) != 0) {
    break;
   }
   $call20 = _sbrk(0) | 0;
   $size = $retval_0_i + 4 | 0;
   if (($call20 | 0) != ((HEAP32[$retval_0_i >> 2] | 0) + (HEAP32[$size >> 2] | 0) | 0)) {
    break;
   }
   $call24 = _sbrk(-($mul >>> 0 > 2147483646 ? -2147483648 - $3 | 0 : $mul) | 0) | 0;
   $call25 = _sbrk(0) | 0;
   if (!(($call24 | 0) != -1 & $call25 >>> 0 < $call20 >>> 0)) {
    break;
   }
   $sub_ptr_sub = $call20 - $call25 | 0;
   if (($call20 | 0) == ($call25 | 0)) {
    break;
   }
   HEAP32[$size >> 2] = (HEAP32[$size >> 2] | 0) - $sub_ptr_sub;
   HEAP32[11710] = (HEAP32[11710] | 0) - $sub_ptr_sub;
   $13 = HEAP32[11608] | 0;
   $sub41 = (HEAP32[11605] | 0) - $sub_ptr_sub | 0;
   $15 = $13;
   $16 = $13 + 8 | 0;
   if (($16 & 7 | 0) == 0) {
    $cond_i = 0;
   } else {
    $cond_i = -$16 & 7;
   }
   $sub5_i = $sub41 - $cond_i | 0;
   HEAP32[11608] = $15 + $cond_i;
   HEAP32[11605] = $sub5_i;
   HEAP32[$15 + ($cond_i + 4) >> 2] = $sub5_i | 1;
   HEAP32[$15 + ($sub41 + 4) >> 2] = 40;
   HEAP32[11609] = HEAP32[10828];
   $released_2 = ($call20 | 0) != ($call25 | 0) | 0;
   return $released_2 | 0;
  }
 } while (0);
 if ((HEAP32[11605] | 0) >>> 0 <= (HEAP32[11609] | 0) >>> 0) {
  $released_2 = 0;
  return $released_2 | 0;
 }
 HEAP32[11609] = -1;
 $released_2 = 0;
 return $released_2 | 0;
}
function _try_realloc_chunk($p, $nb) {
 $p = $p | 0;
 $nb = $nb | 0;
 var $head = 0, $0 = 0, $and = 0, $1 = 0, $add_ptr = 0, $2 = 0, $3 = 0, $and2 = 0, $4 = 0, $5 = 0, $sub = 0, $add = 0, $sub40 = 0, $add58 = 0, $sub62 = 0, $18 = 0, $20 = 0, $storemerge18 = 0, $storemerge = 0, $add105 = 0, $sub110 = 0, $shr = 0, $23 = 0, $25 = 0, $26 = 0, $fd138 = 0, $fd148_pre_phi = 0, $32 = 0, $34 = 0, $36 = 0, $38 = 0, $bk164 = 0, $fd167 = 0, $42 = 0, $43 = 0, $arrayidx182 = 0, $44 = 0, $RP_0 = 0, $R_0 = 0, $arrayidx186 = 0, $45 = 0, $arrayidx190 = 0, $46 = 0, $R_1 = 0, $48 = 0, $arrayidx206 = 0, $arrayidx226 = 0, $58 = 0, $62 = 0, $66 = 0, $71 = 0, $newp_0 = 0;
 $head = $p + 4 | 0;
 $0 = HEAP32[$head >> 2] | 0;
 $and = $0 & -8;
 $1 = $p;
 $add_ptr = $1 + $and | 0;
 $2 = $add_ptr;
 $3 = HEAP32[11606] | 0;
 if ($1 >>> 0 < $3 >>> 0) {
  _abort();
  return 0;
 }
 $and2 = $0 & 3;
 if (!(($and2 | 0) != 1 & $1 >>> 0 < $add_ptr >>> 0)) {
  _abort();
  return 0;
 }
 $4 = $1 + ($and | 4) | 0;
 $5 = HEAP32[$4 >> 2] | 0;
 if (($5 & 1 | 0) == 0) {
  _abort();
  return 0;
 }
 if (($and2 | 0) == 0) {
  if ($nb >>> 0 < 256) {
   $newp_0 = 0;
   return $newp_0 | 0;
  }
  do {
   if ($and >>> 0 >= ($nb + 4 | 0) >>> 0) {
    if (($and - $nb | 0) >>> 0 > HEAP32[10826] << 1 >>> 0) {
     break;
    } else {
     $newp_0 = $p;
    }
    return $newp_0 | 0;
   }
  } while (0);
  $newp_0 = 0;
  return $newp_0 | 0;
 }
 if ($and >>> 0 >= $nb >>> 0) {
  $sub = $and - $nb | 0;
  if ($sub >>> 0 <= 15) {
   $newp_0 = $p;
   return $newp_0 | 0;
  }
  HEAP32[$head >> 2] = $0 & 1 | $nb | 2;
  HEAP32[$1 + ($nb + 4) >> 2] = $sub | 3;
  HEAP32[$4 >> 2] = HEAP32[$4 >> 2] | 1;
  _dispose_chunk($1 + $nb | 0, $sub);
  $newp_0 = $p;
  return $newp_0 | 0;
 }
 if (($2 | 0) == (HEAP32[11608] | 0)) {
  $add = (HEAP32[11605] | 0) + $and | 0;
  if ($add >>> 0 <= $nb >>> 0) {
   $newp_0 = 0;
   return $newp_0 | 0;
  }
  $sub40 = $add - $nb | 0;
  HEAP32[$head >> 2] = $0 & 1 | $nb | 2;
  HEAP32[$1 + ($nb + 4) >> 2] = $sub40 | 1;
  HEAP32[11608] = $1 + $nb;
  HEAP32[11605] = $sub40;
  $newp_0 = $p;
  return $newp_0 | 0;
 }
 if (($2 | 0) == (HEAP32[11607] | 0)) {
  $add58 = (HEAP32[11604] | 0) + $and | 0;
  if ($add58 >>> 0 < $nb >>> 0) {
   $newp_0 = 0;
   return $newp_0 | 0;
  }
  $sub62 = $add58 - $nb | 0;
  if ($sub62 >>> 0 > 15) {
   HEAP32[$head >> 2] = $0 & 1 | $nb | 2;
   HEAP32[$1 + ($nb + 4) >> 2] = $sub62 | 1;
   HEAP32[$1 + $add58 >> 2] = $sub62;
   $18 = $1 + ($add58 + 4) | 0;
   HEAP32[$18 >> 2] = HEAP32[$18 >> 2] & -2;
   $storemerge = $1 + $nb | 0;
   $storemerge18 = $sub62;
  } else {
   HEAP32[$head >> 2] = $0 & 1 | $add58 | 2;
   $20 = $1 + ($add58 + 4) | 0;
   HEAP32[$20 >> 2] = HEAP32[$20 >> 2] | 1;
   $storemerge = 0;
   $storemerge18 = 0;
  }
  HEAP32[11604] = $storemerge18;
  HEAP32[11607] = $storemerge;
  $newp_0 = $p;
  return $newp_0 | 0;
 }
 if (($5 & 2 | 0) != 0) {
  $newp_0 = 0;
  return $newp_0 | 0;
 }
 $add105 = ($5 & -8) + $and | 0;
 if ($add105 >>> 0 < $nb >>> 0) {
  $newp_0 = 0;
  return $newp_0 | 0;
 }
 $sub110 = $add105 - $nb | 0;
 $shr = $5 >>> 3;
 L1536 : do {
  if ($5 >>> 0 < 256) {
   $23 = HEAP32[$1 + ($and + 8) >> 2] | 0;
   $25 = HEAP32[$1 + ($and + 12) >> 2] | 0;
   $26 = 46448 + ($shr << 1 << 2) | 0;
   do {
    if (($23 | 0) != ($26 | 0)) {
     if ($23 >>> 0 < $3 >>> 0) {
      _abort();
      return 0;
     }
     if ((HEAP32[$23 + 12 >> 2] | 0) == ($2 | 0)) {
      break;
     }
     _abort();
     return 0;
    }
   } while (0);
   if (($25 | 0) == ($23 | 0)) {
    HEAP32[11602] = HEAP32[11602] & ~(1 << $shr);
    break;
   }
   do {
    if (($25 | 0) == ($26 | 0)) {
     $fd148_pre_phi = $25 + 8 | 0;
    } else {
     if ($25 >>> 0 < $3 >>> 0) {
      _abort();
      return 0;
     }
     $fd138 = $25 + 8 | 0;
     if ((HEAP32[$fd138 >> 2] | 0) == ($2 | 0)) {
      $fd148_pre_phi = $fd138;
      break;
     }
     _abort();
     return 0;
    }
   } while (0);
   HEAP32[$23 + 12 >> 2] = $25;
   HEAP32[$fd148_pre_phi >> 2] = $23;
  } else {
   $32 = $add_ptr;
   $34 = HEAP32[$1 + ($and + 24) >> 2] | 0;
   $36 = HEAP32[$1 + ($and + 12) >> 2] | 0;
   do {
    if (($36 | 0) == ($32 | 0)) {
     $42 = $1 + ($and + 20) | 0;
     $43 = HEAP32[$42 >> 2] | 0;
     if (($43 | 0) == 0) {
      $arrayidx182 = $1 + ($and + 16) | 0;
      $44 = HEAP32[$arrayidx182 >> 2] | 0;
      if (($44 | 0) == 0) {
       $R_1 = 0;
       break;
      } else {
       $R_0 = $44;
       $RP_0 = $arrayidx182;
      }
     } else {
      $R_0 = $43;
      $RP_0 = $42;
     }
     while (1) {
      $arrayidx186 = $R_0 + 20 | 0;
      $45 = HEAP32[$arrayidx186 >> 2] | 0;
      if (($45 | 0) != 0) {
       $R_0 = $45;
       $RP_0 = $arrayidx186;
       continue;
      }
      $arrayidx190 = $R_0 + 16 | 0;
      $46 = HEAP32[$arrayidx190 >> 2] | 0;
      if (($46 | 0) == 0) {
       break;
      } else {
       $R_0 = $46;
       $RP_0 = $arrayidx190;
      }
     }
     if ($RP_0 >>> 0 < $3 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$RP_0 >> 2] = 0;
      $R_1 = $R_0;
      break;
     }
    } else {
     $38 = HEAP32[$1 + ($and + 8) >> 2] | 0;
     if ($38 >>> 0 < $3 >>> 0) {
      _abort();
      return 0;
     }
     $bk164 = $38 + 12 | 0;
     if ((HEAP32[$bk164 >> 2] | 0) != ($32 | 0)) {
      _abort();
      return 0;
     }
     $fd167 = $36 + 8 | 0;
     if ((HEAP32[$fd167 >> 2] | 0) == ($32 | 0)) {
      HEAP32[$bk164 >> 2] = $36;
      HEAP32[$fd167 >> 2] = $38;
      $R_1 = $36;
      break;
     } else {
      _abort();
      return 0;
     }
    }
   } while (0);
   if (($34 | 0) == 0) {
    break;
   }
   $48 = $1 + ($and + 28) | 0;
   $arrayidx206 = 46712 + (HEAP32[$48 >> 2] << 2) | 0;
   do {
    if (($32 | 0) == (HEAP32[$arrayidx206 >> 2] | 0)) {
     HEAP32[$arrayidx206 >> 2] = $R_1;
     if (($R_1 | 0) != 0) {
      break;
     }
     HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$48 >> 2]);
     break L1536;
    } else {
     if ($34 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
      return 0;
     }
     $arrayidx226 = $34 + 16 | 0;
     if ((HEAP32[$arrayidx226 >> 2] | 0) == ($32 | 0)) {
      HEAP32[$arrayidx226 >> 2] = $R_1;
     } else {
      HEAP32[$34 + 20 >> 2] = $R_1;
     }
     if (($R_1 | 0) == 0) {
      break L1536;
     }
    }
   } while (0);
   if ($R_1 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
    _abort();
    return 0;
   }
   HEAP32[$R_1 + 24 >> 2] = $34;
   $58 = HEAP32[$1 + ($and + 16) >> 2] | 0;
   do {
    if (($58 | 0) != 0) {
     if ($58 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[$R_1 + 16 >> 2] = $58;
      HEAP32[$58 + 24 >> 2] = $R_1;
      break;
     }
    }
   } while (0);
   $62 = HEAP32[$1 + ($and + 20) >> 2] | 0;
   if (($62 | 0) == 0) {
    break;
   }
   if ($62 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
    _abort();
    return 0;
   } else {
    HEAP32[$R_1 + 20 >> 2] = $62;
    HEAP32[$62 + 24 >> 2] = $R_1;
    break;
   }
  }
 } while (0);
 if ($sub110 >>> 0 < 16) {
  HEAP32[$head >> 2] = $add105 | HEAP32[$head >> 2] & 1 | 2;
  $66 = $1 + ($add105 | 4) | 0;
  HEAP32[$66 >> 2] = HEAP32[$66 >> 2] | 1;
  $newp_0 = $p;
  return $newp_0 | 0;
 } else {
  HEAP32[$head >> 2] = HEAP32[$head >> 2] & 1 | $nb | 2;
  HEAP32[$1 + ($nb + 4) >> 2] = $sub110 | 3;
  $71 = $1 + ($add105 | 4) | 0;
  HEAP32[$71 >> 2] = HEAP32[$71 >> 2] | 1;
  _dispose_chunk($1 + $nb | 0, $sub110);
  $newp_0 = $p;
  return $newp_0 | 0;
 }
 return 0;
}
function _malloc_footprint() {
 return HEAP32[11710] | 0;
}
function _malloc_max_footprint() {
 return HEAP32[11711] | 0;
}
function _malloc_footprint_limit() {
 var $0 = 0;
 $0 = HEAP32[11712] | 0;
 return (($0 | 0) == 0 ? -1 : $0) | 0;
}
function _malloc_set_footprint_limit($bytes) {
 $bytes = $bytes | 0;
 var $0 = 0, $result_0 = 0;
 if (($bytes | 0) == -1) {
  $result_0 = 0;
 } else {
  $0 = HEAP32[10826] | 0;
  $result_0 = $bytes - 1 + $0 & -$0;
 }
 HEAP32[11712] = $result_0;
 return $result_0 | 0;
}
function _internal_memalign($alignment, $bytes) {
 $alignment = $alignment | 0;
 $bytes = $bytes | 0;
 var $_alignment = 0, $a_0 = 0, $alignment_addr_1 = 0, $cond = 0, $call17 = 0, $add_ptr = 0, $0 = 0, $sub20 = 0, $3 = 0, $add_ptr28 = 0, $sub_ptr_rhs_cast = 0, $cond34 = 0, $4 = 0, $sub_ptr_sub37 = 0, $5 = 0, $6 = 0, $sub39 = 0, $9 = 0, $11 = 0, $14 = 0, $p_0 = 0, $head65 = 0, $16 = 0, $and70 = 0, $sub74 = 0, $17 = 0, $20 = 0, $mem_0 = 0;
 $_alignment = $alignment >>> 0 < 16 ? 16 : $alignment;
 if (($_alignment - 1 & $_alignment | 0) == 0) {
  $alignment_addr_1 = $_alignment;
 } else {
  $a_0 = 16;
  while (1) {
   if ($a_0 >>> 0 < $_alignment >>> 0) {
    $a_0 = $a_0 << 1;
   } else {
    $alignment_addr_1 = $a_0;
    break;
   }
  }
 }
 if ((-64 - $alignment_addr_1 | 0) >>> 0 <= $bytes >>> 0) {
  HEAP32[(___errno_location() | 0) >> 2] = 12;
  $mem_0 = 0;
  return $mem_0 | 0;
 }
 if ($bytes >>> 0 < 11) {
  $cond = 16;
 } else {
  $cond = $bytes + 11 & -8;
 }
 $call17 = _malloc($alignment_addr_1 + 12 + $cond | 0) | 0;
 if (($call17 | 0) == 0) {
  $mem_0 = 0;
  return $mem_0 | 0;
 }
 $add_ptr = $call17 - 8 | 0;
 $0 = $add_ptr;
 $sub20 = $alignment_addr_1 - 1 | 0;
 do {
  if (($call17 & $sub20 | 0) == 0) {
   $p_0 = $0;
  } else {
   $3 = $call17 + $sub20 & -$alignment_addr_1;
   $add_ptr28 = $3 - 8 | 0;
   $sub_ptr_rhs_cast = $add_ptr;
   if (($add_ptr28 - $sub_ptr_rhs_cast | 0) >>> 0 > 15) {
    $cond34 = $add_ptr28;
   } else {
    $cond34 = $3 + ($alignment_addr_1 - 8) | 0;
   }
   $4 = $cond34;
   $sub_ptr_sub37 = $cond34 - $sub_ptr_rhs_cast | 0;
   $5 = $call17 - 4 | 0;
   $6 = HEAP32[$5 >> 2] | 0;
   $sub39 = ($6 & -8) - $sub_ptr_sub37 | 0;
   if (($6 & 3 | 0) == 0) {
    HEAP32[$cond34 >> 2] = (HEAP32[$add_ptr >> 2] | 0) + $sub_ptr_sub37;
    HEAP32[$cond34 + 4 >> 2] = $sub39;
    $p_0 = $4;
    break;
   } else {
    $9 = $cond34 + 4 | 0;
    HEAP32[$9 >> 2] = $sub39 | HEAP32[$9 >> 2] & 1 | 2;
    $11 = $cond34 + ($sub39 + 4) | 0;
    HEAP32[$11 >> 2] = HEAP32[$11 >> 2] | 1;
    HEAP32[$5 >> 2] = $sub_ptr_sub37 | HEAP32[$5 >> 2] & 1 | 2;
    $14 = $call17 + ($sub_ptr_sub37 - 4) | 0;
    HEAP32[$14 >> 2] = HEAP32[$14 >> 2] | 1;
    _dispose_chunk($0, $sub_ptr_sub37);
    $p_0 = $4;
    break;
   }
  }
 } while (0);
 $head65 = $p_0 + 4 | 0;
 $16 = HEAP32[$head65 >> 2] | 0;
 do {
  if (($16 & 3 | 0) != 0) {
   $and70 = $16 & -8;
   if ($and70 >>> 0 <= ($cond + 16 | 0) >>> 0) {
    break;
   }
   $sub74 = $and70 - $cond | 0;
   $17 = $p_0;
   HEAP32[$head65 >> 2] = $cond | $16 & 1 | 2;
   HEAP32[$17 + ($cond | 4) >> 2] = $sub74 | 3;
   $20 = $17 + ($and70 | 4) | 0;
   HEAP32[$20 >> 2] = HEAP32[$20 >> 2] | 1;
   _dispose_chunk($17 + $cond | 0, $sub74);
  }
 } while (0);
 $mem_0 = $p_0 + 8 | 0;
 return $mem_0 | 0;
}
function _posix_memalign($pp, $alignment, $bytes) {
 $pp = $pp | 0;
 $alignment = $alignment | 0;
 $bytes = $bytes | 0;
 var $div = 0, $mem_0 = 0, $retval_0 = 0, label = 0;
 do {
  if (($alignment | 0) == 8) {
   $mem_0 = _malloc($bytes) | 0;
   label = 1246;
  } else {
   $div = $alignment >>> 2;
   if (($alignment & 3 | 0) != 0 | ($div | 0) == 0) {
    $retval_0 = 22;
    break;
   }
   if (($div + 1073741823 & $div | 0) != 0) {
    $retval_0 = 22;
    break;
   }
   if ((-64 - $alignment | 0) >>> 0 < $bytes >>> 0) {
    $retval_0 = 12;
    break;
   }
   $mem_0 = _internal_memalign($alignment >>> 0 < 16 ? 16 : $alignment, $bytes) | 0;
   label = 1246;
  }
 } while (0);
 do {
  if ((label | 0) == 1246) {
   if (($mem_0 | 0) == 0) {
    $retval_0 = 12;
    break;
   }
   HEAP32[$pp >> 2] = $mem_0;
   $retval_0 = 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function _independent_calloc($n_elements, $elem_size, $chunks) {
 $n_elements = $n_elements | 0;
 $elem_size = $elem_size | 0;
 $chunks = $chunks | 0;
 var $sz = 0, $call = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $sz = sp | 0;
 HEAP32[$sz >> 2] = $elem_size;
 $call = _ialloc($n_elements, $sz, 3, $chunks) | 0;
 STACKTOP = sp;
 return $call | 0;
}
function _independent_comalloc($n_elements, $sizes, $chunks) {
 $n_elements = $n_elements | 0;
 $sizes = $sizes | 0;
 $chunks = $chunks | 0;
 return _ialloc($n_elements, $sizes, 0, $chunks) | 0;
}
function _valloc($bytes) {
 $bytes = $bytes | 0;
 var $call_i = 0, $1 = 0, $call1 = 0;
 if ((HEAP32[10824] | 0) != 0) {
  $1 = HEAP32[10825] | 0;
  $call1 = _memalign($1, $bytes) | 0;
  return $call1 | 0;
 }
 $call_i = _sysconf(8) | 0;
 if (($call_i - 1 & $call_i | 0) != 0) {
  _abort();
  return 0;
 }
 HEAP32[10826] = $call_i;
 HEAP32[10825] = $call_i;
 HEAP32[10827] = -1;
 HEAP32[10828] = 2097152;
 HEAP32[10829] = 0;
 HEAP32[11713] = 0;
 HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
 $1 = HEAP32[10825] | 0;
 $call1 = _memalign($1, $bytes) | 0;
 return $call1 | 0;
}
function _pvalloc($bytes) {
 $bytes = $bytes | 0;
 var $call_i = 0, $1 = 0;
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i = _sysconf(8) | 0;
   if (($call_i - 1 & $call_i | 0) == 0) {
    HEAP32[10826] = $call_i;
    HEAP32[10825] = $call_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
    return 0;
   }
  }
 } while (0);
 $1 = HEAP32[10825] | 0;
 return _memalign($1, $bytes - 1 + $1 & -$1) | 0;
}
function _ialloc($n_elements, $sizes, $opts, $chunks) {
 $n_elements = $n_elements | 0;
 $sizes = $sizes | 0;
 $opts = $opts | 0;
 $chunks = $chunks | 0;
 var $call_i = 0, $cmp2 = 0, $mul = 0, $array_size_0 = 0, $marray_0 = 0, $2 = 0, $cond22 = 0, $i_09 = 0, $contents_size_08 = 0, $3 = 0, $cond34 = 0, $add35 = 0, $inc = 0, $contents_size_1 = 0, $element_size_0 = 0, $call39 = 0, $add_ptr = 0, $and47 = 0, $remainder_size_0 = 0, $marray_1 = 0, $sub65 = 0, $i_15_us = 0, $remainder_size_14_us = 0, $p_0_in3_us = 0, $8 = 0, $size_0_us = 0, $sub82_us = 0, $add_ptr86_us = 0, $inc93_us = 0, $i_15 = 0, $remainder_size_14 = 0, $p_0_in3 = 0, $sub82 = 0, $add_ptr86 = 0, $inc93 = 0, $remainder_size_1_lcssa = 0, $p_0_in_lcssa = 0, $retval_0 = 0;
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i = _sysconf(8) | 0;
   if (($call_i - 1 & $call_i | 0) == 0) {
    HEAP32[10826] = $call_i;
    HEAP32[10825] = $call_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
    return 0;
   }
  }
 } while (0);
 $cmp2 = ($n_elements | 0) == 0;
 do {
  if (($chunks | 0) == 0) {
   if ($cmp2) {
    $retval_0 = _malloc(0) | 0;
    return $retval_0 | 0;
   } else {
    $mul = $n_elements << 2;
    if ($mul >>> 0 < 11) {
     $marray_0 = 0;
     $array_size_0 = 16;
     break;
    }
    $marray_0 = 0;
    $array_size_0 = $mul + 11 & -8;
    break;
   }
  } else {
   if ($cmp2) {
    $retval_0 = $chunks;
   } else {
    $marray_0 = $chunks;
    $array_size_0 = 0;
    break;
   }
   return $retval_0 | 0;
  }
 } while (0);
 do {
  if (($opts & 1 | 0) == 0) {
   if ($cmp2) {
    $element_size_0 = 0;
    $contents_size_1 = 0;
    break;
   } else {
    $contents_size_08 = 0;
    $i_09 = 0;
   }
   while (1) {
    $3 = HEAP32[$sizes + ($i_09 << 2) >> 2] | 0;
    if ($3 >>> 0 < 11) {
     $cond34 = 16;
    } else {
     $cond34 = $3 + 11 & -8;
    }
    $add35 = $cond34 + $contents_size_08 | 0;
    $inc = $i_09 + 1 | 0;
    if (($inc | 0) == ($n_elements | 0)) {
     $element_size_0 = 0;
     $contents_size_1 = $add35;
     break;
    } else {
     $contents_size_08 = $add35;
     $i_09 = $inc;
    }
   }
  } else {
   $2 = HEAP32[$sizes >> 2] | 0;
   if ($2 >>> 0 < 11) {
    $cond22 = 16;
   } else {
    $cond22 = $2 + 11 & -8;
   }
   $element_size_0 = $cond22;
   $contents_size_1 = Math_imul($cond22, $n_elements) | 0;
  }
 } while (0);
 $call39 = _malloc($array_size_0 - 4 + $contents_size_1 | 0) | 0;
 if (($call39 | 0) == 0) {
  $retval_0 = 0;
  return $retval_0 | 0;
 }
 $add_ptr = $call39 - 8 | 0;
 $and47 = HEAP32[$call39 - 4 >> 2] & -8;
 if (($opts & 2 | 0) != 0) {
  _memset($call39 | 0, 0, -4 - $array_size_0 + $and47 | 0);
 }
 if (($marray_0 | 0) == 0) {
  HEAP32[$call39 + ($contents_size_1 - 4) >> 2] = $and47 - $contents_size_1 | 3;
  $marray_1 = $call39 + $contents_size_1 | 0;
  $remainder_size_0 = $contents_size_1;
 } else {
  $marray_1 = $marray_0;
  $remainder_size_0 = $and47;
 }
 HEAP32[$marray_1 >> 2] = $call39;
 $sub65 = $n_elements - 1 | 0;
 L1713 : do {
  if (($sub65 | 0) == 0) {
   $p_0_in_lcssa = $add_ptr;
   $remainder_size_1_lcssa = $remainder_size_0;
  } else {
   if (($element_size_0 | 0) == 0) {
    $p_0_in3_us = $add_ptr;
    $remainder_size_14_us = $remainder_size_0;
    $i_15_us = 0;
   } else {
    $p_0_in3 = $add_ptr;
    $remainder_size_14 = $remainder_size_0;
    $i_15 = 0;
    while (1) {
     $sub82 = $remainder_size_14 - $element_size_0 | 0;
     HEAP32[$p_0_in3 + 4 >> 2] = $element_size_0 | 3;
     $add_ptr86 = $p_0_in3 + $element_size_0 | 0;
     $inc93 = $i_15 + 1 | 0;
     HEAP32[$marray_1 + ($inc93 << 2) >> 2] = $p_0_in3 + ($element_size_0 + 8);
     if (($inc93 | 0) == ($sub65 | 0)) {
      $p_0_in_lcssa = $add_ptr86;
      $remainder_size_1_lcssa = $sub82;
      break L1713;
     } else {
      $p_0_in3 = $add_ptr86;
      $remainder_size_14 = $sub82;
      $i_15 = $inc93;
     }
    }
   }
   while (1) {
    $8 = HEAP32[$sizes + ($i_15_us << 2) >> 2] | 0;
    if ($8 >>> 0 < 11) {
     $size_0_us = 16;
    } else {
     $size_0_us = $8 + 11 & -8;
    }
    $sub82_us = $remainder_size_14_us - $size_0_us | 0;
    HEAP32[$p_0_in3_us + 4 >> 2] = $size_0_us | 3;
    $add_ptr86_us = $p_0_in3_us + $size_0_us | 0;
    $inc93_us = $i_15_us + 1 | 0;
    HEAP32[$marray_1 + ($inc93_us << 2) >> 2] = $p_0_in3_us + ($size_0_us + 8);
    if (($inc93_us | 0) == ($sub65 | 0)) {
     $p_0_in_lcssa = $add_ptr86_us;
     $remainder_size_1_lcssa = $sub82_us;
     break;
    } else {
     $p_0_in3_us = $add_ptr86_us;
     $remainder_size_14_us = $sub82_us;
     $i_15_us = $inc93_us;
    }
   }
  }
 } while (0);
 HEAP32[$p_0_in_lcssa + 4 >> 2] = $remainder_size_1_lcssa | 3;
 $retval_0 = $marray_1;
 return $retval_0 | 0;
}
function _bulk_free($array, $nelem) {
 $array = $array | 0;
 $nelem = $nelem | 0;
 var $arrayidx_i = 0, $a_07_i = 0, $0 = 0, $add_ptr_i = 0, $1 = 0, $2 = 0, $and_i = 0, $5 = 0, $add_ptr7_i = 0, $add_ptr_sum_i = 0, $add_i = 0, $9 = 0, $incdec_ptr_pre_phi_i = 0, label = 0;
 $arrayidx_i = $array + ($nelem << 2) | 0;
 L1726 : do {
  if (($nelem | 0) != 0) {
   $a_07_i = $array;
   L1727 : while (1) {
    $0 = HEAP32[$a_07_i >> 2] | 0;
    L1729 : do {
     if (($0 | 0) == 0) {
      $incdec_ptr_pre_phi_i = $a_07_i + 4 | 0;
     } else {
      $add_ptr_i = $0 - 8 | 0;
      $1 = $add_ptr_i;
      $2 = $0 - 4 | 0;
      $and_i = HEAP32[$2 >> 2] & -8;
      HEAP32[$a_07_i >> 2] = 0;
      if ($add_ptr_i >>> 0 < (HEAP32[11606] | 0) >>> 0) {
       label = 1312;
       break L1727;
      }
      $5 = HEAP32[$2 >> 2] | 0;
      if (($5 & 3 | 0) == 1) {
       label = 1313;
       break L1727;
      }
      $add_ptr7_i = $a_07_i + 4 | 0;
      $add_ptr_sum_i = $5 - 8 & -8;
      do {
       if (($add_ptr7_i | 0) != ($arrayidx_i | 0)) {
        if ((HEAP32[$add_ptr7_i >> 2] | 0) != ($0 + ($add_ptr_sum_i + 8) | 0)) {
         break;
        }
        $add_i = (HEAP32[$0 + ($add_ptr_sum_i | 4) >> 2] & -8) + $and_i | 0;
        HEAP32[$2 >> 2] = $5 & 1 | $add_i | 2;
        $9 = $0 + ($add_i - 4) | 0;
        HEAP32[$9 >> 2] = HEAP32[$9 >> 2] | 1;
        HEAP32[$add_ptr7_i >> 2] = $0;
        $incdec_ptr_pre_phi_i = $add_ptr7_i;
        break L1729;
       }
      } while (0);
      _dispose_chunk($1, $and_i);
      $incdec_ptr_pre_phi_i = $add_ptr7_i;
     }
    } while (0);
    if (($incdec_ptr_pre_phi_i | 0) == ($arrayidx_i | 0)) {
     break L1726;
    } else {
     $a_07_i = $incdec_ptr_pre_phi_i;
    }
   }
   if ((label | 0) == 1312) {
    _abort();
    return 0;
   } else if ((label | 0) == 1313) {
    _abort();
    return 0;
   }
  }
 } while (0);
 if ((HEAP32[11605] | 0) >>> 0 <= (HEAP32[11609] | 0) >>> 0) {
  return 0;
 }
 _sys_trim(0) | 0;
 return 0;
}
function _malloc_trim($pad) {
 $pad = $pad | 0;
 var $call_i = 0, $call1 = 0;
 if ((HEAP32[10824] | 0) != 0) {
  $call1 = _sys_trim($pad) | 0;
  return $call1 | 0;
 }
 $call_i = _sysconf(8) | 0;
 if (($call_i - 1 & $call_i | 0) != 0) {
  _abort();
  return 0;
 }
 HEAP32[10826] = $call_i;
 HEAP32[10825] = $call_i;
 HEAP32[10827] = -1;
 HEAP32[10828] = 2097152;
 HEAP32[10829] = 0;
 HEAP32[11713] = 0;
 HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
 $call1 = _sys_trim($pad) | 0;
 return $call1 | 0;
}
function _mallinfo($agg_result) {
 $agg_result = $agg_result | 0;
 var $call_i_i = 0, $1 = 0, $2 = 0, $add_i = 0, $s_011_i = 0, $sum_010_i = 0, $mfree_09_i = 0, $nfree_08_i = 0, $3 = 0, $4 = 0, $cond_i = 0, $add_ptr14_i = 0, $q_0_in5_i = 0, $sum_14_i = 0, $mfree_13_i = 0, $nfree_12_i = 0, $8 = 0, $and22_i = 0, $add23_i = 0, $nfree_2_i = 0, $mfree_2_i = 0, $add_ptr31_i = 0, $sum_1_lcssa_i = 0, $mfree_1_lcssa_i = 0, $nfree_1_lcssa_i = 0, $9 = 0, $10 = 0, $nm_sroa_7_0_i = 0, $nm_sroa_6_0_i = 0, $nm_sroa_4_0_i = 0, $nm_sroa_3_0_i = 0, $nm_sroa_1_0_i = 0, $nm_sroa_0_0_i = 0, $nm_sroa_8_0_i = 0, $12 = 0;
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i_i = _sysconf(8) | 0;
   if (($call_i_i - 1 & $call_i_i | 0) == 0) {
    HEAP32[10826] = $call_i_i;
    HEAP32[10825] = $call_i_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
   }
  }
 } while (0);
 $1 = HEAP32[11608] | 0;
 if (($1 | 0) == 0) {
  $nm_sroa_8_0_i = 0;
  $nm_sroa_0_0_i = 0;
  $nm_sroa_1_0_i = 0;
  $nm_sroa_3_0_i = 0;
  $nm_sroa_4_0_i = 0;
  $nm_sroa_6_0_i = 0;
  $nm_sroa_7_0_i = 0;
 } else {
  $2 = HEAP32[11605] | 0;
  $add_i = $2 + 40 | 0;
  $nfree_08_i = 1;
  $mfree_09_i = $add_i;
  $sum_010_i = $add_i;
  $s_011_i = 46856;
  while (1) {
   $3 = HEAP32[$s_011_i >> 2] | 0;
   $4 = $3 + 8 | 0;
   if (($4 & 7 | 0) == 0) {
    $cond_i = 0;
   } else {
    $cond_i = -$4 & 7;
   }
   $add_ptr14_i = $3 + (HEAP32[$s_011_i + 4 >> 2] | 0) | 0;
   $nfree_12_i = $nfree_08_i;
   $mfree_13_i = $mfree_09_i;
   $sum_14_i = $sum_010_i;
   $q_0_in5_i = $3 + $cond_i | 0;
   while (1) {
    if ($q_0_in5_i >>> 0 >= $add_ptr14_i >>> 0 | ($q_0_in5_i | 0) == ($1 | 0)) {
     $nfree_1_lcssa_i = $nfree_12_i;
     $mfree_1_lcssa_i = $mfree_13_i;
     $sum_1_lcssa_i = $sum_14_i;
     break;
    }
    $8 = HEAP32[$q_0_in5_i + 4 >> 2] | 0;
    if (($8 | 0) == 7) {
     $nfree_1_lcssa_i = $nfree_12_i;
     $mfree_1_lcssa_i = $mfree_13_i;
     $sum_1_lcssa_i = $sum_14_i;
     break;
    }
    $and22_i = $8 & -8;
    $add23_i = $and22_i + $sum_14_i | 0;
    if (($8 & 3 | 0) == 1) {
     $mfree_2_i = $and22_i + $mfree_13_i | 0;
     $nfree_2_i = $nfree_12_i + 1 | 0;
    } else {
     $mfree_2_i = $mfree_13_i;
     $nfree_2_i = $nfree_12_i;
    }
    $add_ptr31_i = $q_0_in5_i + $and22_i | 0;
    if ($add_ptr31_i >>> 0 < $3 >>> 0) {
     $nfree_1_lcssa_i = $nfree_2_i;
     $mfree_1_lcssa_i = $mfree_2_i;
     $sum_1_lcssa_i = $add23_i;
     break;
    } else {
     $nfree_12_i = $nfree_2_i;
     $mfree_13_i = $mfree_2_i;
     $sum_14_i = $add23_i;
     $q_0_in5_i = $add_ptr31_i;
    }
   }
   $9 = HEAP32[$s_011_i + 8 >> 2] | 0;
   if (($9 | 0) == 0) {
    break;
   } else {
    $nfree_08_i = $nfree_1_lcssa_i;
    $mfree_09_i = $mfree_1_lcssa_i;
    $sum_010_i = $sum_1_lcssa_i;
    $s_011_i = $9;
   }
  }
  $10 = HEAP32[11710] | 0;
  $nm_sroa_8_0_i = $2;
  $nm_sroa_0_0_i = $sum_1_lcssa_i;
  $nm_sroa_1_0_i = $nfree_1_lcssa_i;
  $nm_sroa_3_0_i = $10 - $sum_1_lcssa_i | 0;
  $nm_sroa_4_0_i = HEAP32[11711] | 0;
  $nm_sroa_6_0_i = $10 - $mfree_1_lcssa_i | 0;
  $nm_sroa_7_0_i = $mfree_1_lcssa_i;
 }
 HEAP32[$agg_result >> 2] = $nm_sroa_0_0_i;
 HEAP32[$agg_result + 4 >> 2] = $nm_sroa_1_0_i;
 $12 = $agg_result + 8 | 0;
 HEAP32[$12 >> 2] = 0;
 HEAP32[$12 + 4 >> 2] = 0;
 HEAP32[$agg_result + 16 >> 2] = $nm_sroa_3_0_i;
 HEAP32[$agg_result + 20 >> 2] = $nm_sroa_4_0_i;
 HEAP32[$agg_result + 24 >> 2] = 0;
 HEAP32[$agg_result + 28 >> 2] = $nm_sroa_6_0_i;
 HEAP32[$agg_result + 32 >> 2] = $nm_sroa_7_0_i;
 HEAP32[$agg_result + 36 >> 2] = $nm_sroa_8_0_i;
 return;
}
function _malloc_stats() {
 var $call_i_i = 0, $1 = 0, $2 = 0, $3 = 0, $s_05_i = 0, $used_04_i = 0, $5 = 0, $6 = 0, $cond_i = 0, $add_ptr15_i = 0, $q_0_in3_i = 0, $used_12_i = 0, $10 = 0, $and27_i = 0, $used_2_i = 0, $add_ptr31_i = 0, $used_1_lcssa_i = 0, $11 = 0, $maxfp_0_i = 0, $fp_0_i = 0, $used_3_i = 0, sp = 0;
 sp = STACKTOP;
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i_i = _sysconf(8) | 0;
   if (($call_i_i - 1 & $call_i_i | 0) == 0) {
    HEAP32[10826] = $call_i_i;
    HEAP32[10825] = $call_i_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
   }
  }
 } while (0);
 $1 = HEAP32[11608] | 0;
 if (($1 | 0) == 0) {
  $used_3_i = 0;
  $fp_0_i = 0;
  $maxfp_0_i = 0;
 } else {
  $2 = HEAP32[11711] | 0;
  $3 = HEAP32[11710] | 0;
  $used_04_i = $3 - 40 - (HEAP32[11605] | 0) | 0;
  $s_05_i = 46856;
  while (1) {
   $5 = HEAP32[$s_05_i >> 2] | 0;
   $6 = $5 + 8 | 0;
   if (($6 & 7 | 0) == 0) {
    $cond_i = 0;
   } else {
    $cond_i = -$6 & 7;
   }
   $add_ptr15_i = $5 + (HEAP32[$s_05_i + 4 >> 2] | 0) | 0;
   $used_12_i = $used_04_i;
   $q_0_in3_i = $5 + $cond_i | 0;
   while (1) {
    if ($q_0_in3_i >>> 0 >= $add_ptr15_i >>> 0 | ($q_0_in3_i | 0) == ($1 | 0)) {
     $used_1_lcssa_i = $used_12_i;
     break;
    }
    $10 = HEAP32[$q_0_in3_i + 4 >> 2] | 0;
    if (($10 | 0) == 7) {
     $used_1_lcssa_i = $used_12_i;
     break;
    }
    $and27_i = $10 & -8;
    $used_2_i = $used_12_i - (($10 & 3 | 0) == 1 ? $and27_i : 0) | 0;
    $add_ptr31_i = $q_0_in3_i + $and27_i | 0;
    if ($add_ptr31_i >>> 0 < $5 >>> 0) {
     $used_1_lcssa_i = $used_2_i;
     break;
    } else {
     $used_12_i = $used_2_i;
     $q_0_in3_i = $add_ptr31_i;
    }
   }
   $11 = HEAP32[$s_05_i + 8 >> 2] | 0;
   if (($11 | 0) == 0) {
    $used_3_i = $used_1_lcssa_i;
    $fp_0_i = $3;
    $maxfp_0_i = $2;
    break;
   } else {
    $used_04_i = $used_1_lcssa_i;
    $s_05_i = $11;
   }
  }
 }
 _fprintf(HEAP32[_stderr >> 2] | 0, 1768, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $maxfp_0_i, tempInt) | 0) | 0;
 _fprintf(HEAP32[_stderr >> 2] | 0, 3768, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $fp_0_i, tempInt) | 0) | 0;
 _fprintf(HEAP32[_stderr >> 2] | 0, 2680, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $used_3_i, tempInt) | 0) | 0;
 STACKTOP = sp;
 return;
}
function _malloc_usable_size($mem) {
 $mem = $mem | 0;
 var $1 = 0, $and = 0, $retval_0 = 0;
 do {
  if (($mem | 0) == 0) {
   $retval_0 = 0;
  } else {
   $1 = HEAP32[$mem - 4 >> 2] | 0;
   $and = $1 & 3;
   if (($and | 0) == 1) {
    $retval_0 = 0;
    break;
   }
   $retval_0 = ($1 & -8) - (($and | 0) == 0 ? 8 : 4) | 0;
  }
 } while (0);
 return $retval_0 | 0;
}
function _mallopt($param_number, $value) {
 $param_number = $param_number | 0;
 $value = $value | 0;
 var $call_i_i = 0, $retval_0_i = 0;
 do {
  if ((HEAP32[10824] | 0) == 0) {
   $call_i_i = _sysconf(8) | 0;
   if (($call_i_i - 1 & $call_i_i | 0) == 0) {
    HEAP32[10826] = $call_i_i;
    HEAP32[10825] = $call_i_i;
    HEAP32[10827] = -1;
    HEAP32[10828] = 2097152;
    HEAP32[10829] = 0;
    HEAP32[11713] = 0;
    HEAP32[10824] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
    return 0;
   }
  }
 } while (0);
 if (($param_number | 0) == (-1 | 0)) {
  HEAP32[10828] = $value;
  $retval_0_i = 1;
  return $retval_0_i | 0;
 } else if (($param_number | 0) == (-2 | 0)) {
  if ((HEAP32[10825] | 0) >>> 0 > $value >>> 0) {
   $retval_0_i = 0;
   return $retval_0_i | 0;
  }
  if (($value - 1 & $value | 0) != 0) {
   $retval_0_i = 0;
   return $retval_0_i | 0;
  }
  HEAP32[10826] = $value;
  $retval_0_i = 1;
  return $retval_0_i | 0;
 } else if (($param_number | 0) == (-3 | 0)) {
  HEAP32[10827] = $value;
  $retval_0_i = 1;
  return $retval_0_i | 0;
 } else {
  $retval_0_i = 0;
  return $retval_0_i | 0;
 }
 return 0;
}
function __ZSt15get_new_handlerv() {
 return (tempValue = HEAP32[11858] | 0, HEAP32[11858] = tempValue + 0, tempValue) | 0;
}
function _dispose_chunk($p, $psize) {
 $p = $p | 0;
 $psize = $psize | 0;
 var $0 = 0, $add_ptr = 0, $1 = 0, $2 = 0, $3 = 0, $add_ptr5 = 0, $4 = 0, $add6 = 0, $5 = 0, $shr = 0, $8 = 0, $10 = 0, $11 = 0, $fd43 = 0, $fd53_pre_phi = 0, $17 = 0, $19 = 0, $21 = 0, $23 = 0, $bk70 = 0, $fd74 = 0, $add_ptr5_sum24 = 0, $27 = 0, $28 = 0, $arrayidx90 = 0, $29 = 0, $RP_0 = 0, $R_0 = 0, $arrayidx95 = 0, $30 = 0, $arrayidx100 = 0, $31 = 0, $R_1 = 0, $33 = 0, $arrayidx118 = 0, $arrayidx138 = 0, $add_ptr5_sum26 = 0, $43 = 0, $47 = 0, $50 = 0, $psize_addr_0 = 0, $p_addr_0 = 0, $54 = 0, $55 = 0, $56 = 0, $add229 = 0, $add246 = 0, $add255 = 0, $shr256 = 0, $64 = 0, $66 = 0, $67 = 0, $fd304 = 0, $fd315_pre_phi = 0, $73 = 0, $75 = 0, $77 = 0, $79 = 0, $bk337 = 0, $fd341 = 0, $83 = 0, $84 = 0, $arrayidx361 = 0, $85 = 0, $RP354_0 = 0, $R325_0 = 0, $arrayidx368 = 0, $86 = 0, $arrayidx373 = 0, $87 = 0, $R325_1 = 0, $89 = 0, $arrayidx396 = 0, $arrayidx417 = 0, $99 = 0, $103 = 0, $psize_addr_1 = 0, $shr501 = 0, $shl508 = 0, $109 = 0, $110 = 0, $shl513 = 0, $111 = 0, $112 = 0, $_pre_phi = 0, $F511_0 = 0, $115 = 0, $shr540 = 0, $and550 = 0, $shl551 = 0, $and554 = 0, $shl556 = 0, $and559 = 0, $add564 = 0, $I539_0 = 0, $arrayidx573 = 0, $117 = 0, $shl580 = 0, $cond = 0, $T_0 = 0, $K591_0 = 0, $arrayidx607 = 0, $120 = 0, $fd626 = 0, $123 = 0, $125 = 0, label = 0;
 $0 = $p;
 $add_ptr = $0 + $psize | 0;
 $1 = $add_ptr;
 $2 = HEAP32[$p + 4 >> 2] | 0;
 L1827 : do {
  if (($2 & 1 | 0) == 0) {
   $3 = HEAP32[$p >> 2] | 0;
   if (($2 & 3 | 0) == 0) {
    return;
   }
   $add_ptr5 = $0 + (-$3 | 0) | 0;
   $4 = $add_ptr5;
   $add6 = $3 + $psize | 0;
   $5 = HEAP32[11606] | 0;
   if ($add_ptr5 >>> 0 < $5 >>> 0) {
    _abort();
   }
   if (($4 | 0) == (HEAP32[11607] | 0)) {
    $50 = $0 + ($psize + 4) | 0;
    if ((HEAP32[$50 >> 2] & 3 | 0) != 3) {
     $p_addr_0 = $4;
     $psize_addr_0 = $add6;
     break;
    }
    HEAP32[11604] = $add6;
    HEAP32[$50 >> 2] = HEAP32[$50 >> 2] & -2;
    HEAP32[$0 + (4 - $3) >> 2] = $add6 | 1;
    HEAP32[$add_ptr >> 2] = $add6;
    return;
   }
   $shr = $3 >>> 3;
   if ($3 >>> 0 < 256) {
    $8 = HEAP32[$0 + (8 - $3) >> 2] | 0;
    $10 = HEAP32[$0 + (12 - $3) >> 2] | 0;
    $11 = 46448 + ($shr << 1 << 2) | 0;
    do {
     if (($8 | 0) != ($11 | 0)) {
      if ($8 >>> 0 < $5 >>> 0) {
       _abort();
      }
      if ((HEAP32[$8 + 12 >> 2] | 0) == ($4 | 0)) {
       break;
      }
      _abort();
     }
    } while (0);
    if (($10 | 0) == ($8 | 0)) {
     HEAP32[11602] = HEAP32[11602] & ~(1 << $shr);
     $p_addr_0 = $4;
     $psize_addr_0 = $add6;
     break;
    }
    do {
     if (($10 | 0) == ($11 | 0)) {
      $fd53_pre_phi = $10 + 8 | 0;
     } else {
      if ($10 >>> 0 < $5 >>> 0) {
       _abort();
      }
      $fd43 = $10 + 8 | 0;
      if ((HEAP32[$fd43 >> 2] | 0) == ($4 | 0)) {
       $fd53_pre_phi = $fd43;
       break;
      }
      _abort();
     }
    } while (0);
    HEAP32[$8 + 12 >> 2] = $10;
    HEAP32[$fd53_pre_phi >> 2] = $8;
    $p_addr_0 = $4;
    $psize_addr_0 = $add6;
    break;
   }
   $17 = $add_ptr5;
   $19 = HEAP32[$0 + (24 - $3) >> 2] | 0;
   $21 = HEAP32[$0 + (12 - $3) >> 2] | 0;
   do {
    if (($21 | 0) == ($17 | 0)) {
     $add_ptr5_sum24 = 16 - $3 | 0;
     $27 = $0 + ($add_ptr5_sum24 + 4) | 0;
     $28 = HEAP32[$27 >> 2] | 0;
     if (($28 | 0) == 0) {
      $arrayidx90 = $0 + $add_ptr5_sum24 | 0;
      $29 = HEAP32[$arrayidx90 >> 2] | 0;
      if (($29 | 0) == 0) {
       $R_1 = 0;
       break;
      } else {
       $R_0 = $29;
       $RP_0 = $arrayidx90;
      }
     } else {
      $R_0 = $28;
      $RP_0 = $27;
     }
     while (1) {
      $arrayidx95 = $R_0 + 20 | 0;
      $30 = HEAP32[$arrayidx95 >> 2] | 0;
      if (($30 | 0) != 0) {
       $R_0 = $30;
       $RP_0 = $arrayidx95;
       continue;
      }
      $arrayidx100 = $R_0 + 16 | 0;
      $31 = HEAP32[$arrayidx100 >> 2] | 0;
      if (($31 | 0) == 0) {
       break;
      } else {
       $R_0 = $31;
       $RP_0 = $arrayidx100;
      }
     }
     if ($RP_0 >>> 0 < $5 >>> 0) {
      _abort();
     } else {
      HEAP32[$RP_0 >> 2] = 0;
      $R_1 = $R_0;
      break;
     }
    } else {
     $23 = HEAP32[$0 + (8 - $3) >> 2] | 0;
     if ($23 >>> 0 < $5 >>> 0) {
      _abort();
     }
     $bk70 = $23 + 12 | 0;
     if ((HEAP32[$bk70 >> 2] | 0) != ($17 | 0)) {
      _abort();
     }
     $fd74 = $21 + 8 | 0;
     if ((HEAP32[$fd74 >> 2] | 0) == ($17 | 0)) {
      HEAP32[$bk70 >> 2] = $21;
      HEAP32[$fd74 >> 2] = $23;
      $R_1 = $21;
      break;
     } else {
      _abort();
     }
    }
   } while (0);
   if (($19 | 0) == 0) {
    $p_addr_0 = $4;
    $psize_addr_0 = $add6;
    break;
   }
   $33 = $0 + (28 - $3) | 0;
   $arrayidx118 = 46712 + (HEAP32[$33 >> 2] << 2) | 0;
   do {
    if (($17 | 0) == (HEAP32[$arrayidx118 >> 2] | 0)) {
     HEAP32[$arrayidx118 >> 2] = $R_1;
     if (($R_1 | 0) != 0) {
      break;
     }
     HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$33 >> 2]);
     $p_addr_0 = $4;
     $psize_addr_0 = $add6;
     break L1827;
    } else {
     if ($19 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     }
     $arrayidx138 = $19 + 16 | 0;
     if ((HEAP32[$arrayidx138 >> 2] | 0) == ($17 | 0)) {
      HEAP32[$arrayidx138 >> 2] = $R_1;
     } else {
      HEAP32[$19 + 20 >> 2] = $R_1;
     }
     if (($R_1 | 0) == 0) {
      $p_addr_0 = $4;
      $psize_addr_0 = $add6;
      break L1827;
     }
    }
   } while (0);
   if ($R_1 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
    _abort();
   }
   HEAP32[$R_1 + 24 >> 2] = $19;
   $add_ptr5_sum26 = 16 - $3 | 0;
   $43 = HEAP32[$0 + $add_ptr5_sum26 >> 2] | 0;
   do {
    if (($43 | 0) != 0) {
     if ($43 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[$R_1 + 16 >> 2] = $43;
      HEAP32[$43 + 24 >> 2] = $R_1;
      break;
     }
    }
   } while (0);
   $47 = HEAP32[$0 + ($add_ptr5_sum26 + 4) >> 2] | 0;
   if (($47 | 0) == 0) {
    $p_addr_0 = $4;
    $psize_addr_0 = $add6;
    break;
   }
   if ($47 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
    _abort();
   } else {
    HEAP32[$R_1 + 20 >> 2] = $47;
    HEAP32[$47 + 24 >> 2] = $R_1;
    $p_addr_0 = $4;
    $psize_addr_0 = $add6;
    break;
   }
  } else {
   $p_addr_0 = $p;
   $psize_addr_0 = $psize;
  }
 } while (0);
 $54 = HEAP32[11606] | 0;
 if ($add_ptr >>> 0 < $54 >>> 0) {
  _abort();
 }
 $55 = $0 + ($psize + 4) | 0;
 $56 = HEAP32[$55 >> 2] | 0;
 do {
  if (($56 & 2 | 0) == 0) {
   if (($1 | 0) == (HEAP32[11608] | 0)) {
    $add229 = (HEAP32[11605] | 0) + $psize_addr_0 | 0;
    HEAP32[11605] = $add229;
    HEAP32[11608] = $p_addr_0;
    HEAP32[$p_addr_0 + 4 >> 2] = $add229 | 1;
    if (($p_addr_0 | 0) != (HEAP32[11607] | 0)) {
     return;
    }
    HEAP32[11607] = 0;
    HEAP32[11604] = 0;
    return;
   }
   if (($1 | 0) == (HEAP32[11607] | 0)) {
    $add246 = (HEAP32[11604] | 0) + $psize_addr_0 | 0;
    HEAP32[11604] = $add246;
    HEAP32[11607] = $p_addr_0;
    HEAP32[$p_addr_0 + 4 >> 2] = $add246 | 1;
    HEAP32[$p_addr_0 + $add246 >> 2] = $add246;
    return;
   }
   $add255 = ($56 & -8) + $psize_addr_0 | 0;
   $shr256 = $56 >>> 3;
   L1926 : do {
    if ($56 >>> 0 < 256) {
     $64 = HEAP32[$0 + ($psize + 8) >> 2] | 0;
     $66 = HEAP32[$0 + ($psize + 12) >> 2] | 0;
     $67 = 46448 + ($shr256 << 1 << 2) | 0;
     do {
      if (($64 | 0) != ($67 | 0)) {
       if ($64 >>> 0 < $54 >>> 0) {
        _abort();
       }
       if ((HEAP32[$64 + 12 >> 2] | 0) == ($1 | 0)) {
        break;
       }
       _abort();
      }
     } while (0);
     if (($66 | 0) == ($64 | 0)) {
      HEAP32[11602] = HEAP32[11602] & ~(1 << $shr256);
      break;
     }
     do {
      if (($66 | 0) == ($67 | 0)) {
       $fd315_pre_phi = $66 + 8 | 0;
      } else {
       if ($66 >>> 0 < $54 >>> 0) {
        _abort();
       }
       $fd304 = $66 + 8 | 0;
       if ((HEAP32[$fd304 >> 2] | 0) == ($1 | 0)) {
        $fd315_pre_phi = $fd304;
        break;
       }
       _abort();
      }
     } while (0);
     HEAP32[$64 + 12 >> 2] = $66;
     HEAP32[$fd315_pre_phi >> 2] = $64;
    } else {
     $73 = $add_ptr;
     $75 = HEAP32[$0 + ($psize + 24) >> 2] | 0;
     $77 = HEAP32[$0 + ($psize + 12) >> 2] | 0;
     do {
      if (($77 | 0) == ($73 | 0)) {
       $83 = $0 + ($psize + 20) | 0;
       $84 = HEAP32[$83 >> 2] | 0;
       if (($84 | 0) == 0) {
        $arrayidx361 = $0 + ($psize + 16) | 0;
        $85 = HEAP32[$arrayidx361 >> 2] | 0;
        if (($85 | 0) == 0) {
         $R325_1 = 0;
         break;
        } else {
         $R325_0 = $85;
         $RP354_0 = $arrayidx361;
        }
       } else {
        $R325_0 = $84;
        $RP354_0 = $83;
       }
       while (1) {
        $arrayidx368 = $R325_0 + 20 | 0;
        $86 = HEAP32[$arrayidx368 >> 2] | 0;
        if (($86 | 0) != 0) {
         $R325_0 = $86;
         $RP354_0 = $arrayidx368;
         continue;
        }
        $arrayidx373 = $R325_0 + 16 | 0;
        $87 = HEAP32[$arrayidx373 >> 2] | 0;
        if (($87 | 0) == 0) {
         break;
        } else {
         $R325_0 = $87;
         $RP354_0 = $arrayidx373;
        }
       }
       if ($RP354_0 >>> 0 < $54 >>> 0) {
        _abort();
       } else {
        HEAP32[$RP354_0 >> 2] = 0;
        $R325_1 = $R325_0;
        break;
       }
      } else {
       $79 = HEAP32[$0 + ($psize + 8) >> 2] | 0;
       if ($79 >>> 0 < $54 >>> 0) {
        _abort();
       }
       $bk337 = $79 + 12 | 0;
       if ((HEAP32[$bk337 >> 2] | 0) != ($73 | 0)) {
        _abort();
       }
       $fd341 = $77 + 8 | 0;
       if ((HEAP32[$fd341 >> 2] | 0) == ($73 | 0)) {
        HEAP32[$bk337 >> 2] = $77;
        HEAP32[$fd341 >> 2] = $79;
        $R325_1 = $77;
        break;
       } else {
        _abort();
       }
      }
     } while (0);
     if (($75 | 0) == 0) {
      break;
     }
     $89 = $0 + ($psize + 28) | 0;
     $arrayidx396 = 46712 + (HEAP32[$89 >> 2] << 2) | 0;
     do {
      if (($73 | 0) == (HEAP32[$arrayidx396 >> 2] | 0)) {
       HEAP32[$arrayidx396 >> 2] = $R325_1;
       if (($R325_1 | 0) != 0) {
        break;
       }
       HEAP32[11603] = HEAP32[11603] & ~(1 << HEAP32[$89 >> 2]);
       break L1926;
      } else {
       if ($75 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       }
       $arrayidx417 = $75 + 16 | 0;
       if ((HEAP32[$arrayidx417 >> 2] | 0) == ($73 | 0)) {
        HEAP32[$arrayidx417 >> 2] = $R325_1;
       } else {
        HEAP32[$75 + 20 >> 2] = $R325_1;
       }
       if (($R325_1 | 0) == 0) {
        break L1926;
       }
      }
     } while (0);
     if ($R325_1 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     }
     HEAP32[$R325_1 + 24 >> 2] = $75;
     $99 = HEAP32[$0 + ($psize + 16) >> 2] | 0;
     do {
      if (($99 | 0) != 0) {
       if ($99 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[$R325_1 + 16 >> 2] = $99;
        HEAP32[$99 + 24 >> 2] = $R325_1;
        break;
       }
      }
     } while (0);
     $103 = HEAP32[$0 + ($psize + 20) >> 2] | 0;
     if (($103 | 0) == 0) {
      break;
     }
     if ($103 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[$R325_1 + 20 >> 2] = $103;
      HEAP32[$103 + 24 >> 2] = $R325_1;
      break;
     }
    }
   } while (0);
   HEAP32[$p_addr_0 + 4 >> 2] = $add255 | 1;
   HEAP32[$p_addr_0 + $add255 >> 2] = $add255;
   if (($p_addr_0 | 0) != (HEAP32[11607] | 0)) {
    $psize_addr_1 = $add255;
    break;
   }
   HEAP32[11604] = $add255;
   return;
  } else {
   HEAP32[$55 >> 2] = $56 & -2;
   HEAP32[$p_addr_0 + 4 >> 2] = $psize_addr_0 | 1;
   HEAP32[$p_addr_0 + $psize_addr_0 >> 2] = $psize_addr_0;
   $psize_addr_1 = $psize_addr_0;
  }
 } while (0);
 $shr501 = $psize_addr_1 >>> 3;
 if ($psize_addr_1 >>> 0 < 256) {
  $shl508 = $shr501 << 1;
  $109 = 46448 + ($shl508 << 2) | 0;
  $110 = HEAP32[11602] | 0;
  $shl513 = 1 << $shr501;
  do {
   if (($110 & $shl513 | 0) == 0) {
    HEAP32[11602] = $110 | $shl513;
    $F511_0 = $109;
    $_pre_phi = 46448 + ($shl508 + 2 << 2) | 0;
   } else {
    $111 = 46448 + ($shl508 + 2 << 2) | 0;
    $112 = HEAP32[$111 >> 2] | 0;
    if ($112 >>> 0 >= (HEAP32[11606] | 0) >>> 0) {
     $F511_0 = $112;
     $_pre_phi = $111;
     break;
    }
    _abort();
   }
  } while (0);
  HEAP32[$_pre_phi >> 2] = $p_addr_0;
  HEAP32[$F511_0 + 12 >> 2] = $p_addr_0;
  HEAP32[$p_addr_0 + 8 >> 2] = $F511_0;
  HEAP32[$p_addr_0 + 12 >> 2] = $109;
  return;
 }
 $115 = $p_addr_0;
 $shr540 = $psize_addr_1 >>> 8;
 do {
  if (($shr540 | 0) == 0) {
   $I539_0 = 0;
  } else {
   if ($psize_addr_1 >>> 0 > 16777215) {
    $I539_0 = 31;
    break;
   }
   $and550 = ($shr540 + 1048320 | 0) >>> 16 & 8;
   $shl551 = $shr540 << $and550;
   $and554 = ($shl551 + 520192 | 0) >>> 16 & 4;
   $shl556 = $shl551 << $and554;
   $and559 = ($shl556 + 245760 | 0) >>> 16 & 2;
   $add564 = 14 - ($and554 | $and550 | $and559) + ($shl556 << $and559 >>> 15) | 0;
   $I539_0 = $psize_addr_1 >>> (($add564 + 7 | 0) >>> 0) & 1 | $add564 << 1;
  }
 } while (0);
 $arrayidx573 = 46712 + ($I539_0 << 2) | 0;
 HEAP32[$p_addr_0 + 28 >> 2] = $I539_0;
 HEAP32[$p_addr_0 + 20 >> 2] = 0;
 HEAP32[$p_addr_0 + 16 >> 2] = 0;
 $117 = HEAP32[11603] | 0;
 $shl580 = 1 << $I539_0;
 if (($117 & $shl580 | 0) == 0) {
  HEAP32[11603] = $117 | $shl580;
  HEAP32[$arrayidx573 >> 2] = $115;
  HEAP32[$p_addr_0 + 24 >> 2] = $arrayidx573;
  HEAP32[$p_addr_0 + 12 >> 2] = $p_addr_0;
  HEAP32[$p_addr_0 + 8 >> 2] = $p_addr_0;
  return;
 }
 if (($I539_0 | 0) == 31) {
  $cond = 0;
 } else {
  $cond = 25 - ($I539_0 >>> 1) | 0;
 }
 $K591_0 = $psize_addr_1 << $cond;
 $T_0 = HEAP32[$arrayidx573 >> 2] | 0;
 while (1) {
  if ((HEAP32[$T_0 + 4 >> 2] & -8 | 0) == ($psize_addr_1 | 0)) {
   break;
  }
  $arrayidx607 = $T_0 + 16 + ($K591_0 >>> 31 << 2) | 0;
  $120 = HEAP32[$arrayidx607 >> 2] | 0;
  if (($120 | 0) == 0) {
   label = 1501;
   break;
  } else {
   $K591_0 = $K591_0 << 1;
   $T_0 = $120;
  }
 }
 if ((label | 0) == 1501) {
  if ($arrayidx607 >>> 0 < (HEAP32[11606] | 0) >>> 0) {
   _abort();
  }
  HEAP32[$arrayidx607 >> 2] = $115;
  HEAP32[$p_addr_0 + 24 >> 2] = $T_0;
  HEAP32[$p_addr_0 + 12 >> 2] = $p_addr_0;
  HEAP32[$p_addr_0 + 8 >> 2] = $p_addr_0;
  return;
 }
 $fd626 = $T_0 + 8 | 0;
 $123 = HEAP32[$fd626 >> 2] | 0;
 $125 = HEAP32[11606] | 0;
 if ($T_0 >>> 0 < $125 >>> 0) {
  _abort();
 }
 if ($123 >>> 0 < $125 >>> 0) {
  _abort();
 }
 HEAP32[$123 + 12 >> 2] = $115;
 HEAP32[$fd626 >> 2] = $115;
 HEAP32[$p_addr_0 + 8 >> 2] = $123;
 HEAP32[$p_addr_0 + 12 >> 2] = $T_0;
 HEAP32[$p_addr_0 + 24 >> 2] = 0;
 return;
}
function __Znwj($size) {
 $size = $size | 0;
 var $_size = 0, $call = 0, $0 = 0, $exception = 0, label = 0;
 $_size = ($size | 0) == 0 ? 1 : $size;
 while (1) {
  $call = _malloc($_size) | 0;
  if (($call | 0) != 0) {
   label = 1545;
   break;
  }
  $0 = (tempValue = HEAP32[11858] | 0, HEAP32[11858] = tempValue + 0, tempValue);
  if (($0 | 0) == 0) {
   break;
  }
  FUNCTION_TABLE_v[$0 & 3]();
 }
 if ((label | 0) == 1545) {
  return $call | 0;
 }
 $exception = ___cxa_allocate_exception(4) | 0;
 HEAP32[$exception >> 2] = 8048;
 ___cxa_throw($exception | 0, 9944, 38);
 return 0;
}
function __ZNSt9bad_allocD2Ev($this) {
 $this = $this | 0;
 return;
}
function __ZNKSt9bad_alloc4whatEv($this) {
 $this = $this | 0;
 return 1752 | 0;
}
function __ZNKSt20bad_array_new_length4whatEv($this) {
 $this = $this | 0;
 return 3616 | 0;
}
function __ZSt15set_new_handlerPFvvE($handler) {
 $handler = $handler | 0;
 return (tempValue = HEAP32[11858] | 0, HEAP32[11858] = $handler, tempValue) | 0;
}
function __ZNSt9bad_allocC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8048;
 return;
}
function __ZNSt20bad_array_new_lengthC2Ev($this) {
 $this = $this | 0;
 HEAP32[$this >> 2] = 8112;
 return;
}
function __ZdlPv($ptr) {
 $ptr = $ptr | 0;
 if (($ptr | 0) == 0) {
  return;
 }
 _free($ptr);
 return;
}
function __ZdlPvRKSt9nothrow_t($ptr, $0) {
 $ptr = $ptr | 0;
 $0 = $0 | 0;
 __ZdlPv($ptr);
 return;
}
function __ZdaPv($ptr) {
 $ptr = $ptr | 0;
 __ZdlPv($ptr);
 return;
}
function __ZdaPvRKSt9nothrow_t($ptr, $0) {
 $ptr = $ptr | 0;
 $0 = $0 | 0;
 __ZdaPv($ptr);
 return;
}
function __ZNSt9bad_allocD0Ev($this) {
 $this = $this | 0;
 __ZdlPv($this);
 return;
}
function __ZNSt20bad_array_new_lengthD0Ev($this) {
 $this = $this | 0;
 __ZdlPv($this);
 return;
}
function _getopt($nargc, $nargv, $options) {
 $nargc = $nargc | 0;
 $nargv = $nargv | 0;
 $options = $options | 0;
 return _getopt_internal($nargc, $nargv, $options, 0, 0, 0) | 0;
}
function _getopt_internal($nargc, $nargv, $options, $long_options, $idx, $flags) {
 $nargc = $nargc | 0;
 $nargv = $nargv | 0;
 $options = $options | 0;
 $long_options = $long_options | 0;
 $idx = $idx | 0;
 $flags = $flags | 0;
 var $0 = 0, $_pre137 = 0, $1 = 0, $2 = 0, $3 = 0, $conv = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $and_flags = 0, $flags_addr_0146 = 0, $flags_addr_0147 = 0, $options_addr_0 = 0, $_pr = 0, $8 = 0, $9 = 0, $10 = 0, $12 = 0, $13 = 0, $14 = 0, $sub_i = 0, $sub1_i = 0, $rem_i_i = 0, $c_07_i_i = 0, $b_addr_06_i_i = 0, $rem1_i_i = 0, $b_addr_0_lcssa_i_i = 0, $div_i = 0, $15 = 0, $16 = 0, $pos_023_us_i = 0, $j_022_us_i = 0, $pos_1_us_i = 0, $arrayidx_us_i = 0, $17 = 0, $inc_us_i = 0, $i_025_us_i = 0, $add_us_i = 0, $arrayidx9_us_i = 0, $18 = 0, $19 = 0, $20 = 0, $arrayidx = 0, $21 = 0, $arrayidx54 = 0, $23 = 0, $25 = 0, $26 = 0, $sub_i56 = 0, $sub1_i57 = 0, $rem_i_i58 = 0, $c_07_i_i60 = 0, $b_addr_06_i_i61 = 0, $rem1_i_i62 = 0, $b_addr_0_lcssa_i_i65 = 0, $div_i67 = 0, $27 = 0, $28 = 0, $pos_023_us_i75 = 0, $j_022_us_i76 = 0, $pos_1_us_i79 = 0, $arrayidx_us_i80 = 0, $29 = 0, $inc_us_i81 = 0, $i_025_us_i84 = 0, $add_us_i85 = 0, $arrayidx9_us_i86 = 0, $_pr_pre_pre = 0, $30 = 0, $31 = 0, $32 = 0, $_pr_pre = 0, $33 = 0, $inc82 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $inc106 = 0, $sub_i90 = 0, $sub1_i91 = 0, $rem_i_i92 = 0, $c_07_i_i94 = 0, $b_addr_06_i_i95 = 0, $rem1_i_i96 = 0, $b_addr_0_lcssa_i_i99 = 0, $div_i101 = 0, $40 = 0, $41 = 0, $pos_023_us_i109 = 0, $j_022_us_i110 = 0, $pos_1_us_i113 = 0, $arrayidx_us_i114 = 0, $42 = 0, $inc_us_i115 = 0, $i_025_us_i118 = 0, $add_us_i119 = 0, $arrayidx9_us_i120 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $cmp115 = 0, $49 = 0, $short_too_0 = 0, $call146 = 0, $50 = 0, $incdec_ptr152 = 0, $51 = 0, $conv153 = 0, $call164 = 0, $56 = 0, $inc202 = 0, $call220 = 0, $inc240 = 0, $retval_0 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 if (($options | 0) == 0) {
  $retval_0 = -1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 $0 = HEAP32[70] | 0;
 if (($0 | 0) == 0) {
  HEAP32[10820] = 1;
  HEAP32[70] = 1;
  $3 = 1;
  $2 = 1;
  label = 1569;
 } else {
  $_pre137 = HEAP32[10820] | 0;
  $1 = HEAP32[100] | 0;
  if (($1 | 0) == -1 | ($_pre137 | 0) != 0) {
   $3 = $_pre137;
   $2 = $0;
   label = 1569;
  } else {
   $6 = $1;
   $5 = $_pre137;
   $4 = $0;
  }
 }
 if ((label | 0) == 1569) {
  $conv = (_getenv(1216) | 0) != 0 | 0;
  HEAP32[100] = $conv;
  $6 = $conv;
  $5 = $3;
  $4 = $2;
 }
 $7 = HEAP8[$options] | 0;
 if ($7 << 24 >> 24 == 45) {
  $flags_addr_0146 = $flags | 2;
  label = 1573;
 } else {
  $and_flags = ($6 | 0) != 0 | $7 << 24 >> 24 == 43 ? $flags & -2 : $flags;
  if ($7 << 24 >> 24 == 43) {
   $flags_addr_0146 = $and_flags;
   label = 1573;
  } else {
   $options_addr_0 = $options;
   $flags_addr_0147 = $and_flags;
  }
 }
 if ((label | 0) == 1573) {
  $options_addr_0 = $options + 1 | 0;
  $flags_addr_0147 = $flags_addr_0146;
 }
 HEAP32[10822] = 0;
 if (($5 | 0) == 0) {
  $9 = $4;
  label = 1577;
 } else {
  HEAP32[76] = -1;
  HEAP32[74] = -1;
  $8 = $4;
  $_pr = $5;
  label = 1576;
 }
 while (1) {
  if ((label | 0) == 1576) {
   label = 0;
   if (($_pr | 0) == 0) {
    $9 = $8;
    label = 1577;
    continue;
   } else {
    $12 = $8;
   }
  } else if ((label | 0) == 1577) {
   label = 0;
   $10 = HEAP32[66] | 0;
   if ((HEAP8[$10] | 0) == 0) {
    $12 = $9;
   } else {
    $47 = $10;
    $46 = $9;
    break;
   }
  }
  HEAP32[10820] = 0;
  if (($12 | 0) >= ($nargc | 0)) {
   label = 1579;
   break;
  }
  $arrayidx = $nargv + ($12 << 2) | 0;
  $21 = HEAP32[$arrayidx >> 2] | 0;
  HEAP32[66] = $21;
  if ((HEAP8[$21] | 0) == 45) {
   $arrayidx54 = $21 + 1 | 0;
   $23 = HEAP8[$arrayidx54] | 0;
   if ($23 << 24 >> 24 != 0) {
    label = 1611;
    break;
   }
   if ((_strchr($options_addr_0 | 0, 45) | 0) != 0) {
    label = 1611;
    break;
   }
  }
  HEAP32[66] = 46400;
  if (($flags_addr_0147 & 2 | 0) != 0) {
   label = 1596;
   break;
  }
  if (($flags_addr_0147 & 1 | 0) == 0) {
   $retval_0 = -1;
   label = 1681;
   break;
  }
  $25 = HEAP32[74] | 0;
  do {
   if (($25 | 0) == -1) {
    HEAP32[74] = $12;
    $33 = $12;
    $_pr_pre = 0;
   } else {
    $26 = HEAP32[76] | 0;
    if (($26 | 0) == -1) {
     $33 = $12;
     $_pr_pre = 0;
     break;
    }
    $sub_i56 = $26 - $25 | 0;
    $sub1_i57 = $12 - $26 | 0;
    $rem_i_i58 = ($sub_i56 | 0) % ($sub1_i57 | 0) | 0;
    if (($rem_i_i58 | 0) == 0) {
     $b_addr_0_lcssa_i_i65 = $sub1_i57;
    } else {
     $b_addr_06_i_i61 = $sub1_i57;
     $c_07_i_i60 = $rem_i_i58;
     while (1) {
      $rem1_i_i62 = ($b_addr_06_i_i61 | 0) % ($c_07_i_i60 | 0) | 0;
      if (($rem1_i_i62 | 0) == 0) {
       $b_addr_0_lcssa_i_i65 = $c_07_i_i60;
       break;
      } else {
       $b_addr_06_i_i61 = $c_07_i_i60;
       $c_07_i_i60 = $rem1_i_i62;
      }
     }
    }
    $div_i67 = ($12 - $25 | 0) / ($b_addr_0_lcssa_i_i65 | 0) | 0;
    do {
     if (($b_addr_0_lcssa_i_i65 | 0) > 0) {
      $27 = -$sub_i56 | 0;
      if (($div_i67 | 0) > 0) {
       $i_025_us_i84 = 0;
      } else {
       $32 = $12;
       $31 = $26;
       $30 = $25;
       $_pr_pre_pre = 0;
       break;
      }
      do {
       $add_us_i85 = $i_025_us_i84 + $26 | 0;
       $arrayidx9_us_i86 = $nargv + ($add_us_i85 << 2) | 0;
       $j_022_us_i76 = 0;
       $pos_023_us_i75 = $add_us_i85;
       $28 = HEAP32[$arrayidx9_us_i86 >> 2] | 0;
       while (1) {
        $pos_1_us_i79 = (($pos_023_us_i75 | 0) < ($26 | 0) ? $sub1_i57 : $27) + $pos_023_us_i75 | 0;
        $arrayidx_us_i80 = $nargv + ($pos_1_us_i79 << 2) | 0;
        $29 = HEAP32[$arrayidx_us_i80 >> 2] | 0;
        HEAP32[$arrayidx_us_i80 >> 2] = $28;
        HEAP32[$arrayidx9_us_i86 >> 2] = $29;
        $inc_us_i81 = $j_022_us_i76 + 1 | 0;
        if (($inc_us_i81 | 0) < ($div_i67 | 0)) {
         $j_022_us_i76 = $inc_us_i81;
         $pos_023_us_i75 = $pos_1_us_i79;
         $28 = $29;
        } else {
         break;
        }
       }
       $i_025_us_i84 = $i_025_us_i84 + 1 | 0;
      } while (($i_025_us_i84 | 0) < ($b_addr_0_lcssa_i_i65 | 0));
      $32 = HEAP32[70] | 0;
      $31 = HEAP32[76] | 0;
      $30 = HEAP32[74] | 0;
      $_pr_pre_pre = HEAP32[10820] | 0;
     } else {
      $32 = $12;
      $31 = $26;
      $30 = $25;
      $_pr_pre_pre = 0;
     }
    } while (0);
    HEAP32[74] = $32 - $31 + $30;
    HEAP32[76] = -1;
    $33 = $32;
    $_pr_pre = $_pr_pre_pre;
   }
  } while (0);
  $inc82 = $33 + 1 | 0;
  HEAP32[70] = $inc82;
  $8 = $inc82;
  $_pr = $_pr_pre;
  label = 1576;
 }
 do {
  if ((label | 0) == 1579) {
   HEAP32[66] = 46400;
   $13 = HEAP32[76] | 0;
   $14 = HEAP32[74] | 0;
   do {
    if (($13 | 0) == -1) {
     if (($14 | 0) == -1) {
      break;
     }
     HEAP32[70] = $14;
    } else {
     $sub_i = $13 - $14 | 0;
     $sub1_i = $12 - $13 | 0;
     $rem_i_i = ($sub_i | 0) % ($sub1_i | 0) | 0;
     if (($rem_i_i | 0) == 0) {
      $b_addr_0_lcssa_i_i = $sub1_i;
     } else {
      $b_addr_06_i_i = $sub1_i;
      $c_07_i_i = $rem_i_i;
      while (1) {
       $rem1_i_i = ($b_addr_06_i_i | 0) % ($c_07_i_i | 0) | 0;
       if (($rem1_i_i | 0) == 0) {
        $b_addr_0_lcssa_i_i = $c_07_i_i;
        break;
       } else {
        $b_addr_06_i_i = $c_07_i_i;
        $c_07_i_i = $rem1_i_i;
       }
      }
     }
     $div_i = ($12 - $14 | 0) / ($b_addr_0_lcssa_i_i | 0) | 0;
     do {
      if (($b_addr_0_lcssa_i_i | 0) > 0) {
       $15 = -$sub_i | 0;
       if (($div_i | 0) > 0) {
        $i_025_us_i = 0;
       } else {
        $20 = $13;
        $19 = $14;
        $18 = $12;
        break;
       }
       do {
        $add_us_i = $i_025_us_i + $13 | 0;
        $arrayidx9_us_i = $nargv + ($add_us_i << 2) | 0;
        $j_022_us_i = 0;
        $pos_023_us_i = $add_us_i;
        $16 = HEAP32[$arrayidx9_us_i >> 2] | 0;
        while (1) {
         $pos_1_us_i = (($pos_023_us_i | 0) < ($13 | 0) ? $sub1_i : $15) + $pos_023_us_i | 0;
         $arrayidx_us_i = $nargv + ($pos_1_us_i << 2) | 0;
         $17 = HEAP32[$arrayidx_us_i >> 2] | 0;
         HEAP32[$arrayidx_us_i >> 2] = $16;
         HEAP32[$arrayidx9_us_i >> 2] = $17;
         $inc_us_i = $j_022_us_i + 1 | 0;
         if (($inc_us_i | 0) < ($div_i | 0)) {
          $j_022_us_i = $inc_us_i;
          $pos_023_us_i = $pos_1_us_i;
          $16 = $17;
         } else {
          break;
         }
        }
        $i_025_us_i = $i_025_us_i + 1 | 0;
       } while (($i_025_us_i | 0) < ($b_addr_0_lcssa_i_i | 0));
       $20 = HEAP32[76] | 0;
       $19 = HEAP32[74] | 0;
       $18 = HEAP32[70] | 0;
      } else {
       $20 = $13;
       $19 = $14;
       $18 = $12;
      }
     } while (0);
     HEAP32[70] = $19 - $20 + $18;
    }
   } while (0);
   HEAP32[76] = -1;
   HEAP32[74] = -1;
   $retval_0 = -1;
   STACKTOP = sp;
   return $retval_0 | 0;
  } else if ((label | 0) == 1611) {
   $34 = HEAP32[74] | 0;
   $35 = HEAP32[76] | 0;
   if (($34 | 0) != -1 & ($35 | 0) == -1) {
    HEAP32[76] = $12;
    $37 = HEAP8[$arrayidx54] | 0;
    $36 = $12;
   } else {
    $37 = $23;
    $36 = $35;
   }
   if ($37 << 24 >> 24 == 0) {
    $47 = $21;
    $46 = $12;
    break;
   }
   HEAP32[66] = $arrayidx54;
   if ((HEAP8[$arrayidx54] | 0) != 45) {
    $47 = $arrayidx54;
    $46 = $12;
    break;
   }
   if ((HEAP8[$21 + 2 | 0] | 0) != 0) {
    $47 = $arrayidx54;
    $46 = $12;
    break;
   }
   $inc106 = $12 + 1 | 0;
   HEAP32[70] = $inc106;
   HEAP32[66] = 46400;
   if (($36 | 0) != -1) {
    $sub_i90 = $36 - $34 | 0;
    $sub1_i91 = $inc106 - $36 | 0;
    $rem_i_i92 = ($sub_i90 | 0) % ($sub1_i91 | 0) | 0;
    if (($rem_i_i92 | 0) == 0) {
     $b_addr_0_lcssa_i_i99 = $sub1_i91;
    } else {
     $b_addr_06_i_i95 = $sub1_i91;
     $c_07_i_i94 = $rem_i_i92;
     while (1) {
      $rem1_i_i96 = ($b_addr_06_i_i95 | 0) % ($c_07_i_i94 | 0) | 0;
      if (($rem1_i_i96 | 0) == 0) {
       $b_addr_0_lcssa_i_i99 = $c_07_i_i94;
       break;
      } else {
       $b_addr_06_i_i95 = $c_07_i_i94;
       $c_07_i_i94 = $rem1_i_i96;
      }
     }
    }
    $div_i101 = ($inc106 - $34 | 0) / ($b_addr_0_lcssa_i_i99 | 0) | 0;
    do {
     if (($b_addr_0_lcssa_i_i99 | 0) > 0) {
      $40 = -$sub_i90 | 0;
      if (($div_i101 | 0) > 0) {
       $i_025_us_i118 = 0;
      } else {
       $45 = $36;
       $44 = $34;
       $43 = $inc106;
       break;
      }
      do {
       $add_us_i119 = $i_025_us_i118 + $36 | 0;
       $arrayidx9_us_i120 = $nargv + ($add_us_i119 << 2) | 0;
       $j_022_us_i110 = 0;
       $pos_023_us_i109 = $add_us_i119;
       $41 = HEAP32[$arrayidx9_us_i120 >> 2] | 0;
       while (1) {
        $pos_1_us_i113 = (($pos_023_us_i109 | 0) < ($36 | 0) ? $sub1_i91 : $40) + $pos_023_us_i109 | 0;
        $arrayidx_us_i114 = $nargv + ($pos_1_us_i113 << 2) | 0;
        $42 = HEAP32[$arrayidx_us_i114 >> 2] | 0;
        HEAP32[$arrayidx_us_i114 >> 2] = $41;
        HEAP32[$arrayidx9_us_i120 >> 2] = $42;
        $inc_us_i115 = $j_022_us_i110 + 1 | 0;
        if (($inc_us_i115 | 0) < ($div_i101 | 0)) {
         $j_022_us_i110 = $inc_us_i115;
         $pos_023_us_i109 = $pos_1_us_i113;
         $41 = $42;
        } else {
         break;
        }
       }
       $i_025_us_i118 = $i_025_us_i118 + 1 | 0;
      } while (($i_025_us_i118 | 0) < ($b_addr_0_lcssa_i_i99 | 0));
      $45 = HEAP32[76] | 0;
      $44 = HEAP32[74] | 0;
      $43 = HEAP32[70] | 0;
     } else {
      $45 = $36;
      $44 = $34;
      $43 = $inc106;
     }
    } while (0);
    HEAP32[70] = $44 - $45 + $43;
   }
   HEAP32[76] = -1;
   HEAP32[74] = -1;
   $retval_0 = -1;
   STACKTOP = sp;
   return $retval_0 | 0;
  } else if ((label | 0) == 1596) {
   HEAP32[70] = $12 + 1;
   HEAP32[10822] = HEAP32[$arrayidx >> 2];
   $retval_0 = 1;
   STACKTOP = sp;
   return $retval_0 | 0;
  } else if ((label | 0) == 1681) {
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 } while (0);
 $cmp115 = ($long_options | 0) != 0;
 L2160 : do {
  if ($cmp115) {
   if (($47 | 0) == (HEAP32[$nargv + ($46 << 2) >> 2] | 0)) {
    $50 = $47;
    break;
   }
   $49 = HEAP8[$47] | 0;
   do {
    if ($49 << 24 >> 24 == 45) {
     HEAP32[66] = $47 + 1;
     $short_too_0 = 0;
    } else {
     if (($flags_addr_0147 & 4 | 0) == 0) {
      $50 = $47;
      break L2160;
     }
     if ($49 << 24 >> 24 == 58) {
      $short_too_0 = 0;
      break;
     }
     $short_too_0 = (_strchr($options_addr_0 | 0, $49 << 24 >> 24 | 0) | 0) != 0 | 0;
    }
   } while (0);
   $call146 = _parse_long_options($nargv, $options_addr_0, $long_options, $idx, $short_too_0) | 0;
   if (($call146 | 0) == -1) {
    $50 = HEAP32[66] | 0;
    break;
   }
   HEAP32[66] = 46400;
   $retval_0 = $call146;
   STACKTOP = sp;
   return $retval_0 | 0;
  } else {
   $50 = $47;
  }
 } while (0);
 $incdec_ptr152 = $50 + 1 | 0;
 HEAP32[66] = $incdec_ptr152;
 $51 = HEAP8[$50] | 0;
 $conv153 = $51 << 24 >> 24;
 if (($51 << 24 >> 24 | 0) == 58) {
  label = 1642;
 } else if (($51 << 24 >> 24 | 0) == 45) {
  if ((HEAP8[$incdec_ptr152] | 0) == 0) {
   label = 1639;
  }
 } else {
  label = 1639;
 }
 do {
  if ((label | 0) == 1639) {
   $call164 = _strchr($options_addr_0 | 0, $conv153 | 0) | 0;
   if (($call164 | 0) == 0) {
    if ($51 << 24 >> 24 != 45) {
     label = 1642;
     break;
    }
    if ((HEAP8[$incdec_ptr152] | 0) == 0) {
     $retval_0 = -1;
    } else {
     break;
    }
    STACKTOP = sp;
    return $retval_0 | 0;
   }
   $56 = HEAP8[$call164 + 1 | 0] | 0;
   if ($cmp115 & $51 << 24 >> 24 == 87 & $56 << 24 >> 24 == 59) {
    do {
     if ((HEAP8[$incdec_ptr152] | 0) == 0) {
      $inc202 = (HEAP32[70] | 0) + 1 | 0;
      HEAP32[70] = $inc202;
      if (($inc202 | 0) < ($nargc | 0)) {
       HEAP32[66] = HEAP32[$nargv + ($inc202 << 2) >> 2];
       break;
      }
      HEAP32[66] = 46400;
      do {
       if ((HEAP32[72] | 0) != 0) {
        if ((HEAP8[$options_addr_0] | 0) == 58) {
         break;
        }
        __warnx(152, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $conv153, tempInt) | 0);
       }
      } while (0);
      HEAP32[68] = $conv153;
      $retval_0 = (HEAP8[$options_addr_0] | 0) == 58 ? 58 : 63;
      STACKTOP = sp;
      return $retval_0 | 0;
     }
    } while (0);
    $call220 = _parse_long_options($nargv, $options_addr_0, $long_options, $idx, 0) | 0;
    HEAP32[66] = 46400;
    $retval_0 = $call220;
    STACKTOP = sp;
    return $retval_0 | 0;
   }
   if ($56 << 24 >> 24 != 58) {
    if ((HEAP8[$incdec_ptr152] | 0) != 0) {
     $retval_0 = $conv153;
     STACKTOP = sp;
     return $retval_0 | 0;
    }
    HEAP32[70] = (HEAP32[70] | 0) + 1;
    $retval_0 = $conv153;
    STACKTOP = sp;
    return $retval_0 | 0;
   }
   HEAP32[10822] = 0;
   do {
    if ((HEAP8[$incdec_ptr152] | 0) == 0) {
     if ((HEAP8[$call164 + 2 | 0] | 0) == 58) {
      break;
     }
     $inc240 = (HEAP32[70] | 0) + 1 | 0;
     HEAP32[70] = $inc240;
     if (($inc240 | 0) < ($nargc | 0)) {
      HEAP32[10822] = HEAP32[$nargv + ($inc240 << 2) >> 2];
      break;
     }
     HEAP32[66] = 46400;
     do {
      if ((HEAP32[72] | 0) != 0) {
       if ((HEAP8[$options_addr_0] | 0) == 58) {
        break;
       }
       __warnx(152, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $conv153, tempInt) | 0);
      }
     } while (0);
     HEAP32[68] = $conv153;
     $retval_0 = (HEAP8[$options_addr_0] | 0) == 58 ? 58 : 63;
     STACKTOP = sp;
     return $retval_0 | 0;
    } else {
     HEAP32[10822] = $incdec_ptr152;
    }
   } while (0);
   HEAP32[66] = 46400;
   HEAP32[70] = (HEAP32[70] | 0) + 1;
   $retval_0 = $conv153;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 } while (0);
 do {
  if ((label | 0) == 1642) {
   if ((HEAP8[$incdec_ptr152] | 0) != 0) {
    break;
   }
   HEAP32[70] = (HEAP32[70] | 0) + 1;
  }
 } while (0);
 do {
  if ((HEAP32[72] | 0) != 0) {
   if ((HEAP8[$options_addr_0] | 0) == 58) {
    break;
   }
   __warnx(376, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $conv153, tempInt) | 0);
  }
 } while (0);
 HEAP32[68] = $conv153;
 $retval_0 = 63;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function _getopt_long($nargc, $nargv, $options, $long_options, $idx) {
 $nargc = $nargc | 0;
 $nargv = $nargv | 0;
 $options = $options | 0;
 $long_options = $long_options | 0;
 $idx = $idx | 0;
 return _getopt_internal($nargc, $nargv, $options, $long_options, $idx, 1) | 0;
}
function _getopt_long_only($nargc, $nargv, $options, $long_options, $idx) {
 $nargc = $nargc | 0;
 $nargv = $nargv | 0;
 $options = $options | 0;
 $long_options = $long_options | 0;
 $idx = $idx | 0;
 return _getopt_internal($nargc, $nargv, $options, $long_options, $idx, 5) | 0;
}
function __ZnwjRKSt9nothrow_t($size, $0) {
 $size = $size | 0;
 $0 = $0 | 0;
 return __Znwj($size) | 0;
}
function __Znaj($size) {
 $size = $size | 0;
 return __Znwj($size) | 0;
}
function __ZnajRKSt9nothrow_t($size, $0) {
 $size = $size | 0;
 $0 = $0 | 0;
 return __Znaj($size) | 0;
}
function __ZSt17__throw_bad_allocv() {
 var $exception = 0;
 $exception = ___cxa_allocate_exception(4) | 0;
 HEAP32[$exception >> 2] = 8048;
 ___cxa_throw($exception | 0, 9944, 38);
}
function _parse_long_options($nargv, $options, $long_options, $idx, $short_too) {
 $nargv = $nargv | 0;
 $options = $options | 0;
 $long_options = $long_options | 0;
 $idx = $idx | 0;
 $short_too = $short_too | 0;
 var $0 = 0, $1 = 0, $inc = 0, $call = 0, $has_equal_0 = 0, $current_argv_len_0 = 0, $2 = 0, $3 = 0, $i_061_us = 0, $5 = 0, $match_062 = 0, $i_061 = 0, $match_1 = 0, $inc28 = 0, $8 = 0, $match_2 = 0, $has_arg = 0, $9 = 0, $tobool36 = 0, $storemerge56 = 0, $storemerge = 0, $26 = 0, $27 = 0, $retval_0 = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[66] | 0;
 $1 = HEAP32[70] | 0;
 $inc = $1 + 1 | 0;
 HEAP32[70] = $inc;
 $call = _strchr($0 | 0, 61) | 0;
 if (($call | 0) == 0) {
  $current_argv_len_0 = _strlen($0 | 0) | 0;
  $has_equal_0 = 0;
 } else {
  $current_argv_len_0 = $call - $0 | 0;
  $has_equal_0 = $call + 1 | 0;
 }
 $2 = HEAP32[$long_options >> 2] | 0;
 L2242 : do {
  if (($2 | 0) != 0) {
   L2244 : do {
    if (($short_too | 0) != 0 & ($current_argv_len_0 | 0) == 1) {
     $i_061_us = 0;
     $3 = $2;
     while (1) {
      if ((HEAP8[$0] | 0) == (HEAP8[$3] | 0)) {
       if ((_strlen($3 | 0) | 0) == 1) {
        $match_2 = $i_061_us;
        break L2244;
       }
      }
      $i_061_us = $i_061_us + 1 | 0;
      $3 = HEAP32[$long_options + ($i_061_us << 4) >> 2] | 0;
      if (($3 | 0) == 0) {
       break L2242;
      }
     }
    } else {
     $i_061 = 0;
     $match_062 = -1;
     $5 = $2;
     while (1) {
      if ((_strncmp($0 | 0, $5 | 0, $current_argv_len_0 | 0) | 0) == 0) {
       if ((_strlen($5 | 0) | 0) == ($current_argv_len_0 | 0)) {
        $match_2 = $i_061;
        break L2244;
       }
       if (($match_062 | 0) == -1) {
        $match_1 = $i_061;
       } else {
        break;
       }
      } else {
       $match_1 = $match_062;
      }
      $inc28 = $i_061 + 1 | 0;
      $8 = HEAP32[$long_options + ($inc28 << 4) >> 2] | 0;
      if (($8 | 0) == 0) {
       $match_2 = $match_1;
       break L2244;
      } else {
       $i_061 = $inc28;
       $match_062 = $match_1;
       $5 = $8;
      }
     }
     do {
      if ((HEAP32[72] | 0) != 0) {
       if ((HEAP8[$options] | 0) == 58) {
        break;
       }
       __warnx(408, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $current_argv_len_0, HEAP32[tempInt + 8 >> 2] = $0, tempInt) | 0);
      }
     } while (0);
     HEAP32[68] = 0;
     $retval_0 = 63;
     STACKTOP = sp;
     return $retval_0 | 0;
    }
   } while (0);
   if (($match_2 | 0) == -1) {
    break;
   }
   $has_arg = $long_options + ($match_2 << 4) + 4 | 0;
   $9 = HEAP32[$has_arg >> 2] | 0;
   $tobool36 = ($has_equal_0 | 0) == 0;
   if (!(($9 | 0) != 0 | $tobool36)) {
    do {
     if ((HEAP32[72] | 0) != 0) {
      if ((HEAP8[$options] | 0) == 58) {
       break;
      }
      __warnx(312, (tempInt = STACKTOP, STACKTOP = STACKTOP + 16 | 0, HEAP32[tempInt >> 2] = $current_argv_len_0, HEAP32[tempInt + 8 >> 2] = $0, tempInt) | 0);
     }
    } while (0);
    if ((HEAP32[$long_options + ($match_2 << 4) + 8 >> 2] | 0) == 0) {
     $storemerge56 = HEAP32[$long_options + ($match_2 << 4) + 12 >> 2] | 0;
    } else {
     $storemerge56 = 0;
    }
    HEAP32[68] = $storemerge56;
    $retval_0 = (HEAP8[$options] | 0) == 58 ? 58 : 63;
    STACKTOP = sp;
    return $retval_0 | 0;
   }
   do {
    if (($9 - 1 | 0) >>> 0 < 2) {
     if (!$tobool36) {
      HEAP32[10822] = $has_equal_0;
      break;
     }
     if (($9 | 0) != 1) {
      break;
     }
     HEAP32[70] = $1 + 2;
     HEAP32[10822] = HEAP32[$nargv + ($inc << 2) >> 2];
    }
   } while (0);
   if (!((HEAP32[$has_arg >> 2] | 0) == 1 & (HEAP32[10822] | 0) == 0)) {
    if (($idx | 0) != 0) {
     HEAP32[$idx >> 2] = $match_2;
    }
    $26 = HEAP32[$long_options + ($match_2 << 4) + 8 >> 2] | 0;
    $27 = HEAP32[$long_options + ($match_2 << 4) + 12 >> 2] | 0;
    if (($26 | 0) == 0) {
     $retval_0 = $27;
     STACKTOP = sp;
     return $retval_0 | 0;
    }
    HEAP32[$26 >> 2] = $27;
    $retval_0 = 0;
    STACKTOP = sp;
    return $retval_0 | 0;
   }
   do {
    if ((HEAP32[72] | 0) != 0) {
     if ((HEAP8[$options] | 0) == 58) {
      break;
     }
     __warnx(112, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $0, tempInt) | 0);
    }
   } while (0);
   if ((HEAP32[$long_options + ($match_2 << 4) + 8 >> 2] | 0) == 0) {
    $storemerge = HEAP32[$long_options + ($match_2 << 4) + 12 >> 2] | 0;
   } else {
    $storemerge = 0;
   }
   HEAP32[68] = $storemerge;
   HEAP32[70] = (HEAP32[70] | 0) - 1;
   $retval_0 = (HEAP8[$options] | 0) == 58 ? 58 : 63;
   STACKTOP = sp;
   return $retval_0 | 0;
  }
 } while (0);
 if (($short_too | 0) != 0) {
  HEAP32[70] = $1;
  $retval_0 = -1;
  STACKTOP = sp;
  return $retval_0 | 0;
 }
 do {
  if ((HEAP32[72] | 0) != 0) {
   if ((HEAP8[$options] | 0) == 58) {
    break;
   }
   __warnx(352, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $0, tempInt) | 0);
  }
 } while (0);
 HEAP32[68] = 0;
 $retval_0 = 63;
 STACKTOP = sp;
 return $retval_0 | 0;
}
function __warn($fmt, varrp) {
 $fmt = $fmt | 0;
 varrp = varrp | 0;
 var $ap = 0, $arraydecay1 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $ap = sp | 0;
 $arraydecay1 = $ap;
 HEAP32[$arraydecay1 >> 2] = varrp;
 HEAP32[$arraydecay1 + 4 >> 2] = 0;
 __vwarn($fmt, $ap | 0);
 STACKTOP = sp;
 return;
}
function __warnx($fmt, varrp) {
 $fmt = $fmt | 0;
 varrp = varrp | 0;
 var $ap = 0, $arraydecay1 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $ap = sp | 0;
 $arraydecay1 = $ap;
 HEAP32[$arraydecay1 >> 2] = varrp;
 HEAP32[$arraydecay1 + 4 >> 2] = 0;
 __vwarnx($fmt, $ap | 0);
 STACKTOP = sp;
 return;
}
function __vwarn($fmt, $ap) {
 $fmt = $fmt | 0;
 $ap = $ap | 0;
 var $0 = 0, $2 = 0, $3 = 0, $4 = 0, $6 = 0, $call4 = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[(___errno_location() | 0) >> 2] | 0;
 $2 = HEAP32[___progname >> 2] | 0;
 _fprintf(HEAP32[_stderr >> 2] | 0, 3136, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $2, tempInt) | 0) | 0;
 if (($fmt | 0) != 0) {
  $3 = HEAP32[_stderr >> 2] | 0;
  _vfprintf($3 | 0, $fmt | 0, $ap | 0) | 0;
  $4 = HEAP32[_stderr >> 2] | 0;
  _fwrite(4056, 2, 1, $4 | 0) | 0;
 }
 $6 = HEAP32[_stderr >> 2] | 0;
 $call4 = _strerror($0 | 0) | 0;
 _fprintf($6 | 0, 2832, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $call4, tempInt) | 0) | 0;
 STACKTOP = sp;
 return;
}
function __vwarnx($fmt, $ap) {
 $fmt = $fmt | 0;
 $ap = $ap | 0;
 var $1 = 0, $2 = 0, sp = 0;
 sp = STACKTOP;
 $1 = HEAP32[___progname >> 2] | 0;
 _fprintf(HEAP32[_stderr >> 2] | 0, 2672, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $1, tempInt) | 0) | 0;
 if (($fmt | 0) != 0) {
  $2 = HEAP32[_stderr >> 2] | 0;
  _vfprintf($2 | 0, $fmt | 0, $ap | 0) | 0;
 }
 _fputc(10, HEAP32[_stderr >> 2] | 0) | 0;
 STACKTOP = sp;
 return;
}
function _strtod($string, $endPtr) {
 $string = $string | 0;
 $endPtr = $endPtr | 0;
 var $p_0 = 0, $add_ptr = 0, $1 = 0, $sign_0 = 0, $p_2 = 0, $p_3 = 0, $mantSize_0 = 0, $decPt_0 = 0, $2 = 0, $decPt_1 = 0, $add_ptr22 = 0, $cmp23 = 0, $mantSize_1 = 0, $cmp28 = 0, $fracExp_0 = 0, $mantSize_2 = 0, $p_4_lcssa91 = 0, $mantSize_3_lcssa90 = 0, $frac1_0_lcssa89 = 0.0, $frac1_081 = 0, $mantSize_380 = 0, $p_479 = 0, $4 = 0, $add_ptr43 = 0, $p_5 = 0, $c_0_in = 0, $add51 = 0, $sub53 = 0, $frac2_076 = 0, $mantSize_475 = 0, $p_674 = 0, $6 = 0, $add_ptr60 = 0, $p_7 = 0, $c_1_in = 0, $add69 = 0, $sub71 = 0, $frac1_0_lcssa88 = 0.0, $frac2_0_lcssa = 0.0, $add76 = 0.0, $add_ptr86 = 0, $8 = 0, $expSign_0_ph = 0, $p_9_ph = 0, $9 = 0, $10 = 0, $exp_070 = 0, $p_969 = 0, $add108 = 0, $add_ptr109 = 0, $11 = 0, $expSign_1 = 0, $p_10 = 0, $exp_1 = 0, $exp_2 = 0, $exp_3 = 0, $exp_565 = 0, $d_064 = 0, $dblExp_063 = 0.0, $dblExp_1 = 0.0, $shr = 0, $dblExp_0_lcssa = 0.0, $fraction_0 = 0.0, $p_11 = 0, $retval_0 = 0.0, label = 0;
 $p_0 = $string;
 while (1) {
  $add_ptr = $p_0 + 1 | 0;
  if ((_isspace(HEAP8[$p_0] | 0) | 0) == 0) {
   break;
  } else {
   $p_0 = $add_ptr;
  }
 }
 $1 = HEAP8[$p_0] | 0;
 if (($1 << 24 >> 24 | 0) == 45) {
  $p_2 = $add_ptr;
  $sign_0 = 1;
 } else if (($1 << 24 >> 24 | 0) == 43) {
  $p_2 = $add_ptr;
  $sign_0 = 0;
 } else {
  $p_2 = $p_0;
  $sign_0 = 0;
 }
 $decPt_0 = -1;
 $mantSize_0 = 0;
 $p_3 = $p_2;
 while (1) {
  $2 = HEAP8[$p_3] | 0;
  if ((($2 << 24 >> 24) - 48 | 0) >>> 0 < 10) {
   $decPt_1 = $decPt_0;
  } else {
   if ($2 << 24 >> 24 != 46 | ($decPt_0 | 0) > -1) {
    break;
   } else {
    $decPt_1 = $mantSize_0;
   }
  }
  $decPt_0 = $decPt_1;
  $mantSize_0 = $mantSize_0 + 1 | 0;
  $p_3 = $p_3 + 1 | 0;
 }
 $add_ptr22 = $p_3 + (-$mantSize_0 | 0) | 0;
 $cmp23 = ($decPt_0 | 0) < 0;
 $mantSize_1 = (($cmp23 ^ 1) << 31 >> 31) + $mantSize_0 | 0;
 $cmp28 = ($mantSize_1 | 0) > 18;
 $fracExp_0 = ($cmp28 ? -18 : -$mantSize_1 | 0) + ($cmp23 ? $mantSize_0 : $decPt_0) | 0;
 $mantSize_2 = $cmp28 ? 18 : $mantSize_1;
 do {
  if (($mantSize_2 | 0) == 0) {
   $p_11 = $string;
   $fraction_0 = 0.0;
  } else {
   if (($mantSize_2 | 0) > 9) {
    $p_479 = $add_ptr22;
    $mantSize_380 = $mantSize_2;
    $frac1_081 = 0;
    while (1) {
     $4 = HEAP8[$p_479] | 0;
     $add_ptr43 = $p_479 + 1 | 0;
     if ($4 << 24 >> 24 == 46) {
      $c_0_in = HEAP8[$add_ptr43] | 0;
      $p_5 = $p_479 + 2 | 0;
     } else {
      $c_0_in = $4;
      $p_5 = $add_ptr43;
     }
     $add51 = ($frac1_081 * 10 | 0) - 48 + ($c_0_in << 24 >> 24) | 0;
     $sub53 = $mantSize_380 - 1 | 0;
     if (($sub53 | 0) > 9) {
      $p_479 = $p_5;
      $mantSize_380 = $sub53;
      $frac1_081 = $add51;
     } else {
      break;
     }
    }
    $frac1_0_lcssa89 = +($add51 | 0) * 1.0e9;
    $mantSize_3_lcssa90 = 9;
    $p_4_lcssa91 = $p_5;
    label = 1776;
   } else {
    if (($mantSize_2 | 0) > 0) {
     $frac1_0_lcssa89 = 0.0;
     $mantSize_3_lcssa90 = $mantSize_2;
     $p_4_lcssa91 = $add_ptr22;
     label = 1776;
    } else {
     $frac2_0_lcssa = 0.0;
     $frac1_0_lcssa88 = 0.0;
    }
   }
   if ((label | 0) == 1776) {
    $p_674 = $p_4_lcssa91;
    $mantSize_475 = $mantSize_3_lcssa90;
    $frac2_076 = 0;
    while (1) {
     $6 = HEAP8[$p_674] | 0;
     $add_ptr60 = $p_674 + 1 | 0;
     if ($6 << 24 >> 24 == 46) {
      $c_1_in = HEAP8[$add_ptr60] | 0;
      $p_7 = $p_674 + 2 | 0;
     } else {
      $c_1_in = $6;
      $p_7 = $add_ptr60;
     }
     $add69 = ($frac2_076 * 10 | 0) - 48 + ($c_1_in << 24 >> 24) | 0;
     $sub71 = $mantSize_475 - 1 | 0;
     if (($sub71 | 0) > 0) {
      $p_674 = $p_7;
      $mantSize_475 = $sub71;
      $frac2_076 = $add69;
     } else {
      break;
     }
    }
    $frac2_0_lcssa = +($add69 | 0);
    $frac1_0_lcssa88 = $frac1_0_lcssa89;
   }
   $add76 = $frac1_0_lcssa88 + $frac2_0_lcssa;
   do {
    if (($2 << 24 >> 24 | 0) == 69 | ($2 << 24 >> 24 | 0) == 101) {
     $add_ptr86 = $p_3 + 1 | 0;
     $8 = HEAP8[$add_ptr86] | 0;
     if (($8 << 24 >> 24 | 0) == 43) {
      $p_9_ph = $p_3 + 2 | 0;
      $expSign_0_ph = 0;
     } else if (($8 << 24 >> 24 | 0) == 45) {
      $p_9_ph = $p_3 + 2 | 0;
      $expSign_0_ph = 1;
     } else {
      $p_9_ph = $add_ptr86;
      $expSign_0_ph = 0;
     }
     $9 = HEAP8[$p_9_ph] | 0;
     if ((($9 << 24 >> 24) - 48 | 0) >>> 0 < 10) {
      $p_969 = $p_9_ph;
      $exp_070 = 0;
      $10 = $9;
     } else {
      $exp_1 = 0;
      $p_10 = $p_9_ph;
      $expSign_1 = $expSign_0_ph;
      break;
     }
     while (1) {
      $add108 = ($exp_070 * 10 | 0) - 48 + ($10 << 24 >> 24) | 0;
      $add_ptr109 = $p_969 + 1 | 0;
      $11 = HEAP8[$add_ptr109] | 0;
      if ((($11 << 24 >> 24) - 48 | 0) >>> 0 < 10) {
       $p_969 = $add_ptr109;
       $exp_070 = $add108;
       $10 = $11;
      } else {
       $exp_1 = $add108;
       $p_10 = $add_ptr109;
       $expSign_1 = $expSign_0_ph;
       break;
      }
     }
    } else {
     $exp_1 = 0;
     $p_10 = $p_3;
     $expSign_1 = 0;
    }
   } while (0);
   $exp_2 = $fracExp_0 + (($expSign_1 | 0) == 0 ? $exp_1 : -$exp_1 | 0) | 0;
   $exp_3 = ($exp_2 | 0) < 0 ? -$exp_2 | 0 : $exp_2;
   if (($exp_3 | 0) > 511) {
    HEAP32[(___errno_location() | 0) >> 2] = 34;
    $dblExp_063 = 1.0;
    $d_064 = 192;
    $exp_565 = 511;
    label = 1793;
   } else {
    if (($exp_3 | 0) == 0) {
     $dblExp_0_lcssa = 1.0;
    } else {
     $dblExp_063 = 1.0;
     $d_064 = 192;
     $exp_565 = $exp_3;
     label = 1793;
    }
   }
   if ((label | 0) == 1793) {
    while (1) {
     label = 0;
     if (($exp_565 & 1 | 0) == 0) {
      $dblExp_1 = $dblExp_063;
     } else {
      $dblExp_1 = $dblExp_063 * +HEAPF64[$d_064 >> 3];
     }
     $shr = $exp_565 >> 1;
     if (($shr | 0) == 0) {
      $dblExp_0_lcssa = $dblExp_1;
      break;
     } else {
      $dblExp_063 = $dblExp_1;
      $d_064 = $d_064 + 8 | 0;
      $exp_565 = $shr;
      label = 1793;
     }
    }
   }
   if (($exp_2 | 0) > -1) {
    $p_11 = $p_10;
    $fraction_0 = $add76 * $dblExp_0_lcssa;
    break;
   } else {
    $p_11 = $p_10;
    $fraction_0 = $add76 / $dblExp_0_lcssa;
    break;
   }
  }
 } while (0);
 if (($endPtr | 0) != 0) {
  HEAP32[$endPtr >> 2] = $p_11;
 }
 if (($sign_0 | 0) == 0) {
  $retval_0 = $fraction_0;
  return +$retval_0;
 }
 $retval_0 = -0.0 - $fraction_0;
 return +$retval_0;
}
function _strtold($nptr, $endptr) {
 $nptr = $nptr | 0;
 $endptr = $endptr | 0;
 return +(+_strtod($nptr, $endptr));
}
function _strtof($nptr, $endptr) {
 $nptr = $nptr | 0;
 $endptr = $endptr | 0;
 return +(+_strtod($nptr, $endptr));
}
function _strtod_l($nptr, $endptr, $loc) {
 $nptr = $nptr | 0;
 $endptr = $endptr | 0;
 $loc = $loc | 0;
 return +(+_strtod($nptr, $endptr));
}
function _strtold_l($nptr, $endptr, $loc) {
 $nptr = $nptr | 0;
 $endptr = $endptr | 0;
 $loc = $loc | 0;
 return +(+_strtod($nptr, $endptr));
}
function _atof($str) {
 $str = $str | 0;
 return +(+_strtod($str, 0));
}
function __err($eval, $fmt, varrp) {
 $eval = $eval | 0;
 $fmt = $fmt | 0;
 varrp = varrp | 0;
 var $ap = 0, $arraydecay1 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $ap = sp | 0;
 $arraydecay1 = $ap;
 HEAP32[$arraydecay1 >> 2] = varrp;
 HEAP32[$arraydecay1 + 4 >> 2] = 0;
 __verr($eval, $fmt, $ap | 0);
}
function __errx($eval, $fmt, varrp) {
 $eval = $eval | 0;
 $fmt = $fmt | 0;
 varrp = varrp | 0;
 var $ap = 0, $arraydecay1 = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 $ap = sp | 0;
 $arraydecay1 = $ap;
 HEAP32[$arraydecay1 >> 2] = varrp;
 HEAP32[$arraydecay1 + 4 >> 2] = 0;
 __verrx($eval, $fmt, $ap | 0);
}
function __verr($eval, $fmt, $ap) {
 $eval = $eval | 0;
 $fmt = $fmt | 0;
 $ap = $ap | 0;
 var $0 = 0, $2 = 0, $3 = 0, $4 = 0, $6 = 0, $call4 = 0;
 $0 = HEAP32[(___errno_location() | 0) >> 2] | 0;
 $2 = HEAP32[___progname >> 2] | 0;
 _fprintf(HEAP32[_stderr >> 2] | 0, 536, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $2, tempInt) | 0) | 0;
 if (($fmt | 0) != 0) {
  $3 = HEAP32[_stderr >> 2] | 0;
  _vfprintf($3 | 0, $fmt | 0, $ap | 0) | 0;
  $4 = HEAP32[_stderr >> 2] | 0;
  _fwrite(4248, 2, 1, $4 | 0) | 0;
 }
 $6 = HEAP32[_stderr >> 2] | 0;
 $call4 = _strerror($0 | 0) | 0;
 _fprintf($6 | 0, 2928, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $call4, tempInt) | 0) | 0;
 _exit($eval | 0);
}
function __verrx($eval, $fmt, $ap) {
 $eval = $eval | 0;
 $fmt = $fmt | 0;
 $ap = $ap | 0;
 var $1 = 0, $2 = 0;
 $1 = HEAP32[___progname >> 2] | 0;
 _fprintf(HEAP32[_stderr >> 2] | 0, 3520, (tempInt = STACKTOP, STACKTOP = STACKTOP + 8 | 0, HEAP32[tempInt >> 2] = $1, tempInt) | 0) | 0;
 if (($fmt | 0) != 0) {
  $2 = HEAP32[_stderr >> 2] | 0;
  _vfprintf($2 | 0, $fmt | 0, $ap | 0) | 0;
 }
 _fputc(10, HEAP32[_stderr >> 2] | 0) | 0;
 _exit($eval | 0);
}
function _strcpy(pdest, psrc) {
 pdest = pdest | 0;
 psrc = psrc | 0;
 var i = 0;
 do {
  HEAP8[pdest + i | 0] = HEAP8[psrc + i | 0];
  i = i + 1 | 0;
 } while (HEAP8[psrc + (i - 1) | 0] | 0);
 return pdest | 0;
}
function _memset(ptr, value, num) {
 ptr = ptr | 0;
 value = value | 0;
 num = num | 0;
 var stop = 0, value4 = 0, stop4 = 0, unaligned = 0;
 stop = ptr + num | 0;
 if ((num | 0) >= 20) {
  value = value & 255;
  unaligned = ptr & 3;
  value4 = value | value << 8 | value << 16 | value << 24;
  stop4 = stop & ~3;
  if (unaligned) {
   unaligned = ptr + 4 - unaligned | 0;
   while ((ptr | 0) < (unaligned | 0)) {
    HEAP8[ptr] = value;
    ptr = ptr + 1 | 0;
   }
  }
  while ((ptr | 0) < (stop4 | 0)) {
   HEAP32[ptr >> 2] = value4;
   ptr = ptr + 4 | 0;
  }
 }
 while ((ptr | 0) < (stop | 0)) {
  HEAP8[ptr] = value;
  ptr = ptr + 1 | 0;
 }
}
function _memcpy(dest, src, num) {
 dest = dest | 0;
 src = src | 0;
 num = num | 0;
 var ret = 0;
 ret = dest | 0;
 if ((dest & 3) == (src & 3)) {
  while (dest & 3) {
   if ((num | 0) == 0) return ret | 0;
   HEAP8[dest] = HEAP8[src] | 0;
   dest = dest + 1 | 0;
   src = src + 1 | 0;
   num = num - 1 | 0;
  }
  while ((num | 0) >= 4) {
   HEAP32[dest >> 2] = HEAP32[src >> 2];
   dest = dest + 4 | 0;
   src = src + 4 | 0;
   num = num - 4 | 0;
  }
 }
 while ((num | 0) > 0) {
  HEAP8[dest] = HEAP8[src] | 0;
  dest = dest + 1 | 0;
  src = src + 1 | 0;
  num = num - 1 | 0;
 }
 return ret | 0;
}
function _strlen(ptr) {
 ptr = ptr | 0;
 var curr = 0;
 curr = ptr;
 while (HEAP8[curr] | 0) {
  curr = curr + 1 | 0;
 }
 return curr - ptr | 0;
}
function _strncpy(pdest, psrc, num) {
 pdest = pdest | 0;
 psrc = psrc | 0;
 num = num | 0;
 var padding = 0, i = 0;
 while ((i | 0) < (num | 0)) {
  HEAP8[pdest + i | 0] = padding ? 0 : HEAP8[psrc + i | 0] | 0;
  padding = padding ? 1 : (HEAP8[psrc + i | 0] | 0) == 0;
  i = i + 1 | 0;
 }
 return pdest | 0;
}
function _memcmp(p1, p2, num) {
 p1 = p1 | 0;
 p2 = p2 | 0;
 num = num | 0;
 var i = 0, v1 = 0, v2 = 0;
 while ((i | 0) < (num | 0)) {
  v1 = HEAPU8[p1 + i | 0] | 0;
  v2 = HEAPU8[p2 + i | 0] | 0;
  if ((v1 | 0) != (v2 | 0)) return ((v1 | 0) > (v2 | 0) ? 1 : -1) | 0;
  i = i + 1 | 0;
 }
 return 0;
}
function _memmove(dest, src, num) {
 dest = dest | 0;
 src = src | 0;
 num = num | 0;
 if ((src | 0) < (dest | 0) & (dest | 0) < (src + num | 0)) {
  src = src + num | 0;
  dest = dest + num | 0;
  while ((num | 0) > 0) {
   dest = dest - 1 | 0;
   src = src - 1 | 0;
   num = num - 1 | 0;
   HEAP8[dest] = HEAP8[src] | 0;
  }
 } else {
  _memcpy(dest, src, num) | 0;
 }
}
function _i64Add(a, b, c, d) {
 a = a | 0;
 b = b | 0;
 c = c | 0;
 d = d | 0;
 var l = 0;
 l = a + c >>> 0;
 return (tempRet0 = b + d + (l >>> 0 < a >>> 0 | 0) >>> 0, l | 0) | 0;
}
function _i64Subtract(a, b, c, d) {
 a = a | 0;
 b = b | 0;
 c = c | 0;
 d = d | 0;
 var h = 0;
 h = b - d >>> 0;
 h = b - d - (c >>> 0 > a >>> 0 | 0) >>> 0;
 return (tempRet0 = h, a - c >>> 0 | 0) | 0;
}
function _bitshift64Shl(low, high, bits) {
 low = low | 0;
 high = high | 0;
 bits = bits | 0;
 if ((bits | 0) < 32) {
  tempRet0 = high << bits | (low & (1 << bits) - 1 << 32 - bits) >>> 32 - bits;
  return low << bits;
 }
 tempRet0 = low << bits - 32;
 return 0;
}
function _bitshift64Lshr(low, high, bits) {
 low = low | 0;
 high = high | 0;
 bits = bits | 0;
 if ((bits | 0) < 32) {
  tempRet0 = high >>> bits;
  return low >>> bits | (high & (1 << bits) - 1) << 32 - bits;
 }
 tempRet0 = 0;
 return high >>> bits - 32 | 0;
}
function _bitshift64Ashr(low, high, bits) {
 low = low | 0;
 high = high | 0;
 bits = bits | 0;
 if ((bits | 0) < 32) {
  tempRet0 = high >> bits;
  return low >>> bits | (high & (1 << bits) - 1) << 32 - bits;
 }
 tempRet0 = (high | 0) < 0 ? -1 : 0;
 return high >> bits - 32 | 0;
}
function _llvm_ctlz_i32(x) {
 x = x | 0;
 var ret = 0;
 ret = HEAP8[ctlz_i8 + (x >>> 24) | 0] | 0;
 if ((ret | 0) < 8) return ret | 0;
 ret = HEAP8[ctlz_i8 + (x >> 16 & 255) | 0] | 0;
 if ((ret | 0) < 8) return ret + 8 | 0;
 ret = HEAP8[ctlz_i8 + (x >> 8 & 255) | 0] | 0;
 if ((ret | 0) < 8) return ret + 16 | 0;
 return (HEAP8[ctlz_i8 + (x & 255) | 0] | 0) + 24 | 0;
}
function _llvm_cttz_i32(x) {
 x = x | 0;
 var ret = 0;
 ret = HEAP8[cttz_i8 + (x & 255) | 0] | 0;
 if ((ret | 0) < 8) return ret | 0;
 ret = HEAP8[cttz_i8 + (x >> 8 & 255) | 0] | 0;
 if ((ret | 0) < 8) return ret + 8 | 0;
 ret = HEAP8[cttz_i8 + (x >> 16 & 255) | 0] | 0;
 if ((ret | 0) < 8) return ret + 16 | 0;
 return (HEAP8[cttz_i8 + (x >>> 24) | 0] | 0) + 24 | 0;
}
function ___muldsi3($a, $b) {
 $a = $a | 0;
 $b = $b | 0;
 var $1 = 0, $2 = 0, $3 = 0, $6 = 0, $8 = 0, $11 = 0, $12 = 0;
 $1 = $a & 65535;
 $2 = $b & 65535;
 $3 = Math_imul($2, $1) | 0;
 $6 = $a >>> 16;
 $8 = ($3 >>> 16) + (Math_imul($2, $6) | 0) | 0;
 $11 = $b >>> 16;
 $12 = Math_imul($11, $1) | 0;
 return (tempRet0 = ($8 >>> 16) + (Math_imul($11, $6) | 0) + ((($8 & 65535) + $12 | 0) >>> 16) | 0, $8 + $12 << 16 | $3 & 65535 | 0) | 0;
}
function ___divdi3($a$0, $a$1, $b$0, $b$1) {
 $a$0 = $a$0 | 0;
 $a$1 = $a$1 | 0;
 $b$0 = $b$0 | 0;
 $b$1 = $b$1 | 0;
 var $1$0 = 0, $1$1 = 0, $2$0 = 0, $2$1 = 0, $4$0 = 0, $4$1 = 0, $7$0 = 0, $7$1 = 0, $10$0 = 0;
 $1$0 = $a$1 >> 31 | (($a$1 | 0) < 0 ? -1 : 0) << 1;
 $1$1 = (($a$1 | 0) < 0 ? -1 : 0) >> 31 | (($a$1 | 0) < 0 ? -1 : 0) << 1;
 $2$0 = $b$1 >> 31 | (($b$1 | 0) < 0 ? -1 : 0) << 1;
 $2$1 = (($b$1 | 0) < 0 ? -1 : 0) >> 31 | (($b$1 | 0) < 0 ? -1 : 0) << 1;
 $4$0 = _i64Subtract($1$0 ^ $a$0, $1$1 ^ $a$1, $1$0, $1$1) | 0;
 $4$1 = tempRet0;
 $7$0 = $2$0 ^ $1$0;
 $7$1 = $2$1 ^ $1$1;
 $10$0 = _i64Subtract((___udivmoddi4($4$0, $4$1, _i64Subtract($2$0 ^ $b$0, $2$1 ^ $b$1, $2$0, $2$1) | 0, tempRet0, 0) | 0) ^ $7$0, tempRet0 ^ $7$1, $7$0, $7$1) | 0;
 return (tempRet0 = tempRet0, $10$0) | 0;
}
function ___remdi3($a$0, $a$1, $b$0, $b$1) {
 $a$0 = $a$0 | 0;
 $a$1 = $a$1 | 0;
 $b$0 = $b$0 | 0;
 $b$1 = $b$1 | 0;
 var $rem = 0, $1$0 = 0, $1$1 = 0, $2$0 = 0, $2$1 = 0, $4$0 = 0, $4$1 = 0, $6$0 = 0, $10$0 = 0, $10$1 = 0, __stackBase__ = 0;
 __stackBase__ = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $rem = __stackBase__ | 0;
 $1$0 = $a$1 >> 31 | (($a$1 | 0) < 0 ? -1 : 0) << 1;
 $1$1 = (($a$1 | 0) < 0 ? -1 : 0) >> 31 | (($a$1 | 0) < 0 ? -1 : 0) << 1;
 $2$0 = $b$1 >> 31 | (($b$1 | 0) < 0 ? -1 : 0) << 1;
 $2$1 = (($b$1 | 0) < 0 ? -1 : 0) >> 31 | (($b$1 | 0) < 0 ? -1 : 0) << 1;
 $4$0 = _i64Subtract($1$0 ^ $a$0, $1$1 ^ $a$1, $1$0, $1$1) | 0;
 $4$1 = tempRet0;
 $6$0 = _i64Subtract($2$0 ^ $b$0, $2$1 ^ $b$1, $2$0, $2$1) | 0;
 ___udivmoddi4($4$0, $4$1, $6$0, tempRet0, $rem) | 0;
 $10$0 = _i64Subtract(HEAP32[$rem >> 2] ^ $1$0, HEAP32[$rem + 4 >> 2] ^ $1$1, $1$0, $1$1) | 0;
 $10$1 = tempRet0;
 STACKTOP = __stackBase__;
 return (tempRet0 = $10$1, $10$0) | 0;
}
function ___muldi3($a$0, $a$1, $b$0, $b$1) {
 $a$0 = $a$0 | 0;
 $a$1 = $a$1 | 0;
 $b$0 = $b$0 | 0;
 $b$1 = $b$1 | 0;
 var $x_sroa_0_0_extract_trunc = 0, $y_sroa_0_0_extract_trunc = 0, $1$0 = 0, $1$1 = 0;
 $x_sroa_0_0_extract_trunc = $a$0;
 $y_sroa_0_0_extract_trunc = $b$0;
 $1$0 = ___muldsi3($x_sroa_0_0_extract_trunc, $y_sroa_0_0_extract_trunc) | 0;
 $1$1 = tempRet0;
 return (tempRet0 = (Math_imul($a$1, $y_sroa_0_0_extract_trunc) | 0) + (Math_imul($b$1, $x_sroa_0_0_extract_trunc) | 0) + $1$1 | $1$1 & 0, $1$0 | 0 | 0) | 0;
}
function ___udivdi3($a$0, $a$1, $b$0, $b$1) {
 $a$0 = $a$0 | 0;
 $a$1 = $a$1 | 0;
 $b$0 = $b$0 | 0;
 $b$1 = $b$1 | 0;
 var $1$0 = 0;
 $1$0 = ___udivmoddi4($a$0, $a$1, $b$0, $b$1, 0) | 0;
 return (tempRet0 = tempRet0, $1$0) | 0;
}
function ___uremdi3($a$0, $a$1, $b$0, $b$1) {
 $a$0 = $a$0 | 0;
 $a$1 = $a$1 | 0;
 $b$0 = $b$0 | 0;
 $b$1 = $b$1 | 0;
 var $rem = 0, __stackBase__ = 0;
 __stackBase__ = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 $rem = __stackBase__ | 0;
 ___udivmoddi4($a$0, $a$1, $b$0, $b$1, $rem) | 0;
 STACKTOP = __stackBase__;
 return (tempRet0 = HEAP32[$rem + 4 >> 2] | 0, HEAP32[$rem >> 2] | 0) | 0;
}
function ___udivmoddi4($a$0, $a$1, $b$0, $b$1, $rem) {
 $a$0 = $a$0 | 0;
 $a$1 = $a$1 | 0;
 $b$0 = $b$0 | 0;
 $b$1 = $b$1 | 0;
 $rem = $rem | 0;
 var $n_sroa_0_0_extract_trunc = 0, $n_sroa_1_4_extract_shift$0 = 0, $n_sroa_1_4_extract_trunc = 0, $d_sroa_0_0_extract_trunc = 0, $d_sroa_1_4_extract_shift$0 = 0, $d_sroa_1_4_extract_trunc = 0, $4 = 0, $17 = 0, $37 = 0, $51 = 0, $57 = 0, $58 = 0, $66 = 0, $78 = 0, $88 = 0, $89 = 0, $91 = 0, $92 = 0, $95 = 0, $105 = 0, $119 = 0, $125 = 0, $126 = 0, $130 = 0, $q_sroa_1_1_ph = 0, $q_sroa_0_1_ph = 0, $r_sroa_1_1_ph = 0, $r_sroa_0_1_ph = 0, $sr_1_ph = 0, $d_sroa_0_0_insert_insert99$0 = 0, $d_sroa_0_0_insert_insert99$1 = 0, $137$0 = 0, $137$1 = 0, $carry_0203 = 0, $sr_1202 = 0, $r_sroa_0_1201 = 0, $r_sroa_1_1200 = 0, $q_sroa_0_1199 = 0, $q_sroa_1_1198 = 0, $147 = 0, $149 = 0, $r_sroa_0_0_insert_insert42$0 = 0, $r_sroa_0_0_insert_insert42$1 = 0, $150$1 = 0, $151$0 = 0, $152 = 0, $r_sroa_0_0_extract_trunc = 0, $r_sroa_1_4_extract_trunc = 0, $155 = 0, $carry_0_lcssa$0 = 0, $carry_0_lcssa$1 = 0, $r_sroa_0_1_lcssa = 0, $r_sroa_1_1_lcssa = 0, $q_sroa_0_1_lcssa = 0, $q_sroa_1_1_lcssa = 0, $q_sroa_0_0_insert_ext75$0 = 0, $q_sroa_0_0_insert_ext75$1 = 0, $_0$0 = 0, $_0$1 = 0;
 $n_sroa_0_0_extract_trunc = $a$0;
 $n_sroa_1_4_extract_shift$0 = $a$1;
 $n_sroa_1_4_extract_trunc = $n_sroa_1_4_extract_shift$0;
 $d_sroa_0_0_extract_trunc = $b$0;
 $d_sroa_1_4_extract_shift$0 = $b$1;
 $d_sroa_1_4_extract_trunc = $d_sroa_1_4_extract_shift$0;
 if (($n_sroa_1_4_extract_trunc | 0) == 0) {
  $4 = ($rem | 0) != 0;
  if (($d_sroa_1_4_extract_trunc | 0) == 0) {
   if ($4) {
    HEAP32[$rem >> 2] = ($n_sroa_0_0_extract_trunc >>> 0) % ($d_sroa_0_0_extract_trunc >>> 0);
    HEAP32[$rem + 4 >> 2] = 0;
   }
   $_0$1 = 0;
   $_0$0 = ($n_sroa_0_0_extract_trunc >>> 0) / ($d_sroa_0_0_extract_trunc >>> 0) >>> 0;
   return (tempRet0 = $_0$1, $_0$0) | 0;
  } else {
   if (!$4) {
    $_0$1 = 0;
    $_0$0 = 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
   HEAP32[$rem >> 2] = $a$0 | 0;
   HEAP32[$rem + 4 >> 2] = $a$1 & 0;
   $_0$1 = 0;
   $_0$0 = 0;
   return (tempRet0 = $_0$1, $_0$0) | 0;
  }
 }
 $17 = ($d_sroa_1_4_extract_trunc | 0) == 0;
 do {
  if (($d_sroa_0_0_extract_trunc | 0) == 0) {
   if ($17) {
    if (($rem | 0) != 0) {
     HEAP32[$rem >> 2] = ($n_sroa_1_4_extract_trunc >>> 0) % ($d_sroa_0_0_extract_trunc >>> 0);
     HEAP32[$rem + 4 >> 2] = 0;
    }
    $_0$1 = 0;
    $_0$0 = ($n_sroa_1_4_extract_trunc >>> 0) / ($d_sroa_0_0_extract_trunc >>> 0) >>> 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
   if (($n_sroa_0_0_extract_trunc | 0) == 0) {
    if (($rem | 0) != 0) {
     HEAP32[$rem >> 2] = 0;
     HEAP32[$rem + 4 >> 2] = ($n_sroa_1_4_extract_trunc >>> 0) % ($d_sroa_1_4_extract_trunc >>> 0);
    }
    $_0$1 = 0;
    $_0$0 = ($n_sroa_1_4_extract_trunc >>> 0) / ($d_sroa_1_4_extract_trunc >>> 0) >>> 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
   $37 = $d_sroa_1_4_extract_trunc - 1 | 0;
   if (($37 & $d_sroa_1_4_extract_trunc | 0) == 0) {
    if (($rem | 0) != 0) {
     HEAP32[$rem >> 2] = $a$0 | 0;
     HEAP32[$rem + 4 >> 2] = $37 & $n_sroa_1_4_extract_trunc | $a$1 & 0;
    }
    $_0$1 = 0;
    $_0$0 = $n_sroa_1_4_extract_trunc >>> ((_llvm_cttz_i32($d_sroa_1_4_extract_trunc | 0) | 0) >>> 0);
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
   $51 = (_llvm_ctlz_i32($d_sroa_1_4_extract_trunc | 0) | 0) - (_llvm_ctlz_i32($n_sroa_1_4_extract_trunc | 0) | 0) | 0;
   if ($51 >>> 0 <= 30) {
    $57 = $51 + 1 | 0;
    $58 = 31 - $51 | 0;
    $sr_1_ph = $57;
    $r_sroa_0_1_ph = $n_sroa_1_4_extract_trunc << $58 | $n_sroa_0_0_extract_trunc >>> ($57 >>> 0);
    $r_sroa_1_1_ph = $n_sroa_1_4_extract_trunc >>> ($57 >>> 0);
    $q_sroa_0_1_ph = 0;
    $q_sroa_1_1_ph = $n_sroa_0_0_extract_trunc << $58;
    break;
   }
   if (($rem | 0) == 0) {
    $_0$1 = 0;
    $_0$0 = 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
   HEAP32[$rem >> 2] = $a$0 | 0;
   HEAP32[$rem + 4 >> 2] = $n_sroa_1_4_extract_shift$0 | $a$1 & 0;
   $_0$1 = 0;
   $_0$0 = 0;
   return (tempRet0 = $_0$1, $_0$0) | 0;
  } else {
   if (!$17) {
    $119 = (_llvm_ctlz_i32($d_sroa_1_4_extract_trunc | 0) | 0) - (_llvm_ctlz_i32($n_sroa_1_4_extract_trunc | 0) | 0) | 0;
    if ($119 >>> 0 <= 31) {
     $125 = $119 + 1 | 0;
     $126 = 31 - $119 | 0;
     $130 = $119 - 31 >> 31;
     $sr_1_ph = $125;
     $r_sroa_0_1_ph = $n_sroa_0_0_extract_trunc >>> ($125 >>> 0) & $130 | $n_sroa_1_4_extract_trunc << $126;
     $r_sroa_1_1_ph = $n_sroa_1_4_extract_trunc >>> ($125 >>> 0) & $130;
     $q_sroa_0_1_ph = 0;
     $q_sroa_1_1_ph = $n_sroa_0_0_extract_trunc << $126;
     break;
    }
    if (($rem | 0) == 0) {
     $_0$1 = 0;
     $_0$0 = 0;
     return (tempRet0 = $_0$1, $_0$0) | 0;
    }
    HEAP32[$rem >> 2] = $a$0 | 0;
    HEAP32[$rem + 4 >> 2] = $n_sroa_1_4_extract_shift$0 | $a$1 & 0;
    $_0$1 = 0;
    $_0$0 = 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
   $66 = $d_sroa_0_0_extract_trunc - 1 | 0;
   if (($66 & $d_sroa_0_0_extract_trunc | 0) != 0) {
    $88 = (_llvm_ctlz_i32($d_sroa_0_0_extract_trunc | 0) | 0) + 33 - (_llvm_ctlz_i32($n_sroa_1_4_extract_trunc | 0) | 0) | 0;
    $89 = 64 - $88 | 0;
    $91 = 32 - $88 | 0;
    $92 = $91 >> 31;
    $95 = $88 - 32 | 0;
    $105 = $95 >> 31;
    $sr_1_ph = $88;
    $r_sroa_0_1_ph = $91 - 1 >> 31 & $n_sroa_1_4_extract_trunc >>> ($95 >>> 0) | ($n_sroa_1_4_extract_trunc << $91 | $n_sroa_0_0_extract_trunc >>> ($88 >>> 0)) & $105;
    $r_sroa_1_1_ph = $105 & $n_sroa_1_4_extract_trunc >>> ($88 >>> 0);
    $q_sroa_0_1_ph = $n_sroa_0_0_extract_trunc << $89 & $92;
    $q_sroa_1_1_ph = ($n_sroa_1_4_extract_trunc << $89 | $n_sroa_0_0_extract_trunc >>> ($95 >>> 0)) & $92 | $n_sroa_0_0_extract_trunc << $91 & $88 - 33 >> 31;
    break;
   }
   if (($rem | 0) != 0) {
    HEAP32[$rem >> 2] = $66 & $n_sroa_0_0_extract_trunc;
    HEAP32[$rem + 4 >> 2] = 0;
   }
   if (($d_sroa_0_0_extract_trunc | 0) == 1) {
    $_0$1 = $n_sroa_1_4_extract_shift$0 | $a$1 & 0;
    $_0$0 = $a$0 | 0 | 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   } else {
    $78 = _llvm_cttz_i32($d_sroa_0_0_extract_trunc | 0) | 0;
    $_0$1 = $n_sroa_1_4_extract_trunc >>> ($78 >>> 0) | 0;
    $_0$0 = $n_sroa_1_4_extract_trunc << 32 - $78 | $n_sroa_0_0_extract_trunc >>> ($78 >>> 0) | 0;
    return (tempRet0 = $_0$1, $_0$0) | 0;
   }
  }
 } while (0);
 if (($sr_1_ph | 0) == 0) {
  $q_sroa_1_1_lcssa = $q_sroa_1_1_ph;
  $q_sroa_0_1_lcssa = $q_sroa_0_1_ph;
  $r_sroa_1_1_lcssa = $r_sroa_1_1_ph;
  $r_sroa_0_1_lcssa = $r_sroa_0_1_ph;
  $carry_0_lcssa$1 = 0;
  $carry_0_lcssa$0 = 0;
 } else {
  $d_sroa_0_0_insert_insert99$0 = $b$0 | 0 | 0;
  $d_sroa_0_0_insert_insert99$1 = $d_sroa_1_4_extract_shift$0 | $b$1 & 0;
  $137$0 = _i64Add($d_sroa_0_0_insert_insert99$0, $d_sroa_0_0_insert_insert99$1, -1, -1) | 0;
  $137$1 = tempRet0;
  $q_sroa_1_1198 = $q_sroa_1_1_ph;
  $q_sroa_0_1199 = $q_sroa_0_1_ph;
  $r_sroa_1_1200 = $r_sroa_1_1_ph;
  $r_sroa_0_1201 = $r_sroa_0_1_ph;
  $sr_1202 = $sr_1_ph;
  $carry_0203 = 0;
  while (1) {
   $147 = $q_sroa_0_1199 >>> 31 | $q_sroa_1_1198 << 1;
   $149 = $carry_0203 | $q_sroa_0_1199 << 1;
   $r_sroa_0_0_insert_insert42$0 = $r_sroa_0_1201 << 1 | $q_sroa_1_1198 >>> 31 | 0;
   $r_sroa_0_0_insert_insert42$1 = $r_sroa_0_1201 >>> 31 | $r_sroa_1_1200 << 1 | 0;
   _i64Subtract($137$0, $137$1, $r_sroa_0_0_insert_insert42$0, $r_sroa_0_0_insert_insert42$1) | 0;
   $150$1 = tempRet0;
   $151$0 = $150$1 >> 31 | (($150$1 | 0) < 0 ? -1 : 0) << 1;
   $152 = $151$0 & 1;
   $r_sroa_0_0_extract_trunc = _i64Subtract($r_sroa_0_0_insert_insert42$0, $r_sroa_0_0_insert_insert42$1, $151$0 & $d_sroa_0_0_insert_insert99$0, ((($150$1 | 0) < 0 ? -1 : 0) >> 31 | (($150$1 | 0) < 0 ? -1 : 0) << 1) & $d_sroa_0_0_insert_insert99$1) | 0;
   $r_sroa_1_4_extract_trunc = tempRet0;
   $155 = $sr_1202 - 1 | 0;
   if (($155 | 0) == 0) {
    break;
   } else {
    $q_sroa_1_1198 = $147;
    $q_sroa_0_1199 = $149;
    $r_sroa_1_1200 = $r_sroa_1_4_extract_trunc;
    $r_sroa_0_1201 = $r_sroa_0_0_extract_trunc;
    $sr_1202 = $155;
    $carry_0203 = $152;
   }
  }
  $q_sroa_1_1_lcssa = $147;
  $q_sroa_0_1_lcssa = $149;
  $r_sroa_1_1_lcssa = $r_sroa_1_4_extract_trunc;
  $r_sroa_0_1_lcssa = $r_sroa_0_0_extract_trunc;
  $carry_0_lcssa$1 = 0;
  $carry_0_lcssa$0 = $152;
 }
 $q_sroa_0_0_insert_ext75$0 = $q_sroa_0_1_lcssa;
 $q_sroa_0_0_insert_ext75$1 = 0;
 if (($rem | 0) != 0) {
  HEAP32[$rem >> 2] = $r_sroa_0_1_lcssa;
  HEAP32[$rem + 4 >> 2] = $r_sroa_1_1_lcssa;
 }
 $_0$1 = ($q_sroa_0_0_insert_ext75$0 | 0) >>> 31 | ($q_sroa_1_1_lcssa | $q_sroa_0_0_insert_ext75$1) << 1 | ($q_sroa_0_0_insert_ext75$1 << 1 | $q_sroa_0_0_insert_ext75$0 >>> 31) & 0 | $carry_0_lcssa$1;
 $_0$0 = ($q_sroa_0_0_insert_ext75$0 << 1 | 0 >>> 31) & -2 | $carry_0_lcssa$0;
 return (tempRet0 = $_0$1, $_0$0) | 0;
}
function ___cxa_pure_virtual__wrapper() {
 ___cxa_pure_virtual();
}
function dynCall_viiiii(index, a1, a2, a3, a4, a5) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 a4 = a4 | 0;
 a5 = a5 | 0;
 FUNCTION_TABLE_viiiii[index & 7](a1 | 0, a2 | 0, a3 | 0, a4 | 0, a5 | 0);
}
function dynCall_vi(index, a1) {
 index = index | 0;
 a1 = a1 | 0;
 FUNCTION_TABLE_vi[index & 127](a1 | 0);
}
function dynCall_vii(index, a1, a2) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 FUNCTION_TABLE_vii[index & 15](a1 | 0, a2 | 0);
}
function dynCall_iiiiiii(index, a1, a2, a3, a4, a5, a6) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 a4 = a4 | 0;
 a5 = a5 | 0;
 a6 = a6 | 0;
 return FUNCTION_TABLE_iiiiiii[index & 15](a1 | 0, a2 | 0, a3 | 0, a4 | 0, a5 | 0, a6 | 0) | 0;
}
function dynCall_iiiii(index, a1, a2, a3, a4) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 a4 = a4 | 0;
 return FUNCTION_TABLE_iiiii[index & 31](a1 | 0, a2 | 0, a3 | 0, a4 | 0) | 0;
}
function dynCall_ii(index, a1) {
 index = index | 0;
 a1 = a1 | 0;
 return FUNCTION_TABLE_ii[index & 31](a1 | 0) | 0;
}
function dynCall_iiii(index, a1, a2, a3) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 return FUNCTION_TABLE_iiii[index & 15](a1 | 0, a2 | 0, a3 | 0) | 0;
}
function dynCall_viii(index, a1, a2, a3) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 FUNCTION_TABLE_viii[index & 15](a1 | 0, a2 | 0, a3 | 0);
}
function dynCall_v(index) {
 index = index | 0;
 FUNCTION_TABLE_v[index & 3]();
}
function dynCall_viiiiii(index, a1, a2, a3, a4, a5, a6) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 a4 = a4 | 0;
 a5 = a5 | 0;
 a6 = a6 | 0;
 FUNCTION_TABLE_viiiiii[index & 7](a1 | 0, a2 | 0, a3 | 0, a4 | 0, a5 | 0, a6 | 0);
}
function dynCall_iii(index, a1, a2) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 return FUNCTION_TABLE_iii[index & 63](a1 | 0, a2 | 0) | 0;
}
function dynCall_iiiiii(index, a1, a2, a3, a4, a5) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 a4 = a4 | 0;
 a5 = a5 | 0;
 return FUNCTION_TABLE_iiiiii[index & 15](a1 | 0, a2 | 0, a3 | 0, a4 | 0, a5 | 0) | 0;
}
function dynCall_viiii(index, a1, a2, a3, a4) {
 index = index | 0;
 a1 = a1 | 0;
 a2 = a2 | 0;
 a3 = a3 | 0;
 a4 = a4 | 0;
 FUNCTION_TABLE_viiii[index & 7](a1 | 0, a2 | 0, a3 | 0, a4 | 0);
}
function b0(p0, p1, p2, p3, p4) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 p3 = p3 | 0;
 p4 = p4 | 0;
 abort(0);
}
function b1(p0) {
 p0 = p0 | 0;
 abort(1);
}
function b2(p0, p1) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 abort(2);
}
function b3(p0, p1, p2, p3, p4, p5) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 p3 = p3 | 0;
 p4 = p4 | 0;
 p5 = p5 | 0;
 abort(3);
 return 0;
}
function b4(p0, p1, p2, p3) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 p3 = p3 | 0;
 abort(4);
 return 0;
}
function b5(p0) {
 p0 = p0 | 0;
 abort(5);
 return 0;
}
function b6(p0, p1, p2) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 abort(6);
 return 0;
}
function b7(p0, p1, p2) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 abort(7);
}
function b8() {
 abort(8);
}
function b9(p0, p1, p2, p3, p4, p5) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 p3 = p3 | 0;
 p4 = p4 | 0;
 p5 = p5 | 0;
 abort(9);
}
function b10(p0, p1) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 abort(10);
 return 0;
}
function b11(p0, p1, p2, p3, p4) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 p3 = p3 | 0;
 p4 = p4 | 0;
 abort(11);
 return 0;
}
function b12(p0, p1, p2, p3) {
 p0 = p0 | 0;
 p1 = p1 | 0;
 p2 = p2 | 0;
 p3 = p3 | 0;
 abort(12);
}
// EMSCRIPTEN_END_FUNCS
  var FUNCTION_TABLE_viiiii = [b0,b0,__ZNK10__cxxabiv120__si_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib,b0,__ZNK10__cxxabiv121__vmi_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib,b0,__ZNK10__cxxabiv117__class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib,b0];
  var FUNCTION_TABLE_vi = [b1,b1,__ZN10ime_pinyin8UserDictD0Ev,b1,__ZN10ime_pinyin5NGramD2Ev,b1,__ZNSt9bad_allocC2Ev,b1,__ZNSt9type_infoD0Ev,b1,__ZN10ime_pinyin11Utf16ReaderD2Ev
  ,b1,__ZN10ime_pinyin8DictTrieD0Ev,b1,__ZN10ime_pinyin4SyncC2Ev,b1,__ZN10ime_pinyin8LpiCacheC2Ev,b1,__ZN10ime_pinyin8DictTrie11flush_cacheEv,b1,__ZN10__cxxabiv117__array_type_infoD0Ev
  ,b1,__ZNK10__cxxabiv116__shim_type_info5noop2Ev,b1,__ZN10__cxxabiv123__fundamental_type_infoD0Ev,b1,__ZNSt10bad_typeidD2Ev,b1,__ZN10ime_pinyin8DictTrieC2Ev,b1,__ZN10ime_pinyin8UserDictD2Ev
  ,b1,__ZN10ime_pinyin13SpellingTableC2Ev,b1,__ZN10ime_pinyin12AtomDictBaseD0Ev,b1,__ZN10ime_pinyin8UserDictC2Ev,b1,__ZNSt9bad_allocD2Ev,b1,__ZN10ime_pinyin12SpellingTrieD2Ev
  ,b1,__ZN10ime_pinyin11DictBuilderC2Ev,b1,__ZNSt10bad_typeidC2Ev,b1,__ZN10__cxxabiv120__function_type_infoD0Ev,b1,__ZN10ime_pinyin8UserDict11flush_cacheEv,b1,__ZNSt8bad_castD0Ev
  ,b1,__ZN10ime_pinyin12SpellingTrieC2Ev,b1,__ZNSt20bad_array_new_lengthC2Ev,b1,__ZN10ime_pinyin11DictBuilderD2Ev,b1,__ZN10ime_pinyin4SyncD2Ev,b1,__ZN10__cxxabiv129__pointer_to_member_type_infoD0Ev
  ,b1,__ZNSt9type_infoD2Ev,b1,__ZN10ime_pinyin8LpiCacheD2Ev,b1,__ZN10ime_pinyin12MatrixSearchD2Ev,b1,__ZN10ime_pinyin8DictTrieD2Ev,b1,__ZN10__cxxabiv117__pbase_type_infoD0Ev
  ,b1,__ZN10__cxxabiv116__shim_type_infoD0Ev,b1,__ZN10ime_pinyin12AtomDictBaseD1Ev,b1,__ZN10ime_pinyin8DictListC2Ev,b1,__ZNSt10bad_typeidD0Ev,b1,__ZN10ime_pinyin5NGramC2Ev
  ,b1,__ZNSt20bad_array_new_lengthD0Ev,b1,__ZNSt9bad_allocD0Ev,b1,__ZN10__cxxabiv117__class_type_infoD0Ev,b1,__ZN10__cxxabiv116__shim_type_infoD2Ev,b1,__ZN10ime_pinyin8DictListD2Ev
  ,b1,__ZNSt8bad_castC2Ev,b1,__ZNK10__cxxabiv116__shim_type_info5noop1Ev,b1,__ZN10__cxxabiv119__pointer_type_infoD0Ev,b1,__ZNSt8bad_castD2Ev,b1,__ZN10__cxxabiv116__enum_type_infoD0Ev
  ,b1,__ZN10ime_pinyin13SpellingTableD2Ev,b1,__ZN10ime_pinyin14SpellingParserC2Ev,b1,__ZN10__cxxabiv121__vmi_class_type_infoD0Ev,b1,__ZN10__cxxabiv120__si_class_type_infoD0Ev,b1,__ZN10ime_pinyin12MatrixSearchC2Ev,b1,__ZN10ime_pinyin11Utf16ReaderC2Ev,b1,b1,b1,b1,b1,b1,b1,b1,b1,b1,b1,b1,b1,b1,b1];
  var FUNCTION_TABLE_vii = [b2,b2,__vwarnx,b2,__warnx,b2,__warn,b2,__ZN10ime_pinyin8DictTrie31set_total_lemma_count_of_othersEj,b2,__ZN10ime_pinyin8UserDict31set_total_lemma_count_of_othersEj,b2,__vwarn,b2,b2,b2];
  var FUNCTION_TABLE_iiiiiii = [b3,b3,__ZN10ime_pinyin8UserDict11extend_dictEtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj,b3,__ZN10ime_pinyin8DictTrie11extend_dictEtPKNS_11DictExtParaEPNS_10LmaPsbItemEjPj,b3,__ZN10ime_pinyin8DictTrie7predictEPKttPNS_12NPredictItemEjj,b3,__ZN10ime_pinyin8UserDict7predictEPKttPNS_12NPredictItemEjj,b3,b3,b3,b3,b3,b3,b3];
  var FUNCTION_TABLE_iiiii = [b4,b4,__ZN10ime_pinyin8UserDict9load_dictEPKcjj,b4,__ZN10ime_pinyin8DictTrie15get_lemma_scoreEPtS1_t,b4,__ZN10ime_pinyin8UserDict12update_lemmaEjsb,b4,__ZN10ime_pinyin8UserDict12get_lemma_idEPtS1_t,b4,__ZN10ime_pinyin8DictTrie12get_lemma_idEPtS1_t
  ,b4,__ZN10ime_pinyin8DictTrie9load_dictEPKcjj,b4,__ZN10ime_pinyin8DictTrie13get_lemma_strEjPtt,b4,__ZN10ime_pinyin8UserDict15get_lemma_scoreEPtS1_t,b4,__ZN10ime_pinyin8DictTrie12update_lemmaEjsb,b4,__ZN10ime_pinyin8UserDict13get_lemma_strEjPtt,b4,b4,b4,b4,b4,b4,b4,b4,b4,b4,b4];
  var FUNCTION_TABLE_ii = [b5,b5,__ZNKSt9bad_alloc4whatEv,b5,__ZNKSt8bad_cast4whatEv,b5,__ZN10ime_pinyin8DictTrie21get_total_lemma_countEv,b5,__ZN10ime_pinyin8DictTrie10close_dictEv,b5,__ZNKSt20bad_array_new_length4whatEv
  ,b5,__ZN10ime_pinyin8UserDict16number_of_lemmasEv,b5,__ZN10ime_pinyin8UserDict10close_dictEv,b5,__ZN10ime_pinyin8UserDict21get_total_lemma_countEv,b5,__ZN10ime_pinyin8DictTrie16number_of_lemmasEv,b5,__ZNKSt10bad_typeid4whatEv,b5,b5,b5,b5,b5,b5,b5,b5,b5,b5,b5];
  var FUNCTION_TABLE_iiii = [b6,b6,__ZNK10__cxxabiv117__array_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6,__ZNK10__cxxabiv123__fundamental_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6,__ZNK10__cxxabiv116__enum_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6,__ZNK10__cxxabiv120__function_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6,__ZNK10__cxxabiv117__class_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6,__ZNK10__cxxabiv119__pointer_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6,__ZNK10__cxxabiv117__pbase_type_info9can_catchEPKNS_16__shim_type_infoERPv,b6];
  var FUNCTION_TABLE_viii = [b7,b7,__ZN10ime_pinyin8UserDict16reset_milestonesEtt,b7,__err,b7,__verr,b7,__verrx,b7,__ZN10ime_pinyin8DictTrie16reset_milestonesEtt,b7,__errx,b7,b7,b7];
  var FUNCTION_TABLE_v = [b8,b8,___cxa_pure_virtual__wrapper,b8];
  var FUNCTION_TABLE_viiiiii = [b9,b9,__ZNK10__cxxabiv117__class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib,b9,__ZNK10__cxxabiv121__vmi_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib,b9,__ZNK10__cxxabiv120__si_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib,b9];
  var FUNCTION_TABLE_iii = [b10,b10,__ZN10ime_pinyin11comp_doubleEPKvS1_,b10,__ZN10ime_pinyin24cmp_npre_by_hislen_scoreEPKvS1_,b10,__ZN10ime_pinyin10compare_pyEPKvS1_,b10,__ZN10ime_pinyin12cmp_hanzis_5EPKvS1_,b10,__ZN10ime_pinyin12cmp_hanzis_3EPKvS1_
  ,b10,__ZN10ime_pinyin12cmp_hanzis_4EPKvS1_,b10,__ZN10ime_pinyin12cmp_hanzis_1EPKvS1_,b10,__ZN10ime_pinyin23cmp_npre_by_hanzi_scoreEPKvS1_,b10,__ZN10ime_pinyin12cmp_hanzis_2EPKvS1_,b10,__ZN10ime_pinyin24cmp_lpi_with_unified_psbEPKvS1_
  ,b10,__ZN10ime_pinyin19cmp_lemma_entry_hzsEPKvS1_,b10,__ZN10ime_pinyin14compare_char16EPKvS1_,b10,__ZN10ime_pinyin17cmp_lpsi_with_strEPKvS1_,b10,__ZN10ime_pinyin8DictTrie12remove_lemmaEj,b10,__ZN10ime_pinyin8UserDict15get_lemma_scoreEj
  ,b10,__ZN10ime_pinyin12cmp_hanzis_6EPKvS1_,b10,__ZN10ime_pinyin17cmp_scis_hz_splidEPKvS1_,b10,__ZN10ime_pinyin7compareEPKvS1_,b10,__ZN10ime_pinyin12cmp_hanzis_8EPKvS1_,b10,__ZN10ime_pinyin18compare_raw_spl_ebEPKvS1_
  ,b10,__ZN10ime_pinyin8DictTrie15get_lemma_scoreEj,b10,__ZN10ime_pinyin11compare_splEPKvS1_,b10,__ZN10ime_pinyin12cmp_hanzis_7EPKvS1_,b10,__ZN10ime_pinyin8UserDict12remove_lemmaEj,b10,__ZN10ime_pinyin22cmp_scis_hz_splid_freqEPKvS1_,b10,b10,b10,b10,b10,b10,b10,b10,b10,b10,b10,b10,b10];
  var FUNCTION_TABLE_iiiiii = [b11,b11,__ZN10ime_pinyin8UserDict9put_lemmaEPtS1_tt,b11,__ZN10ime_pinyin8UserDict16get_lemma_splidsEjPttb,b11,__ZN10ime_pinyin8DictTrie8get_lpisEPKttPNS_10LmaPsbItemEj,b11,__ZN10ime_pinyin8DictTrie9put_lemmaEPtS1_tt,b11,__ZN10ime_pinyin8UserDict8get_lpisEPKttPNS_10LmaPsbItemEj,b11,__ZN10ime_pinyin8DictTrie16get_lemma_splidsEjPttb,b11,b11,b11];
  var FUNCTION_TABLE_viiii = [b12,b12,__ZNK10__cxxabiv117__class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi,b12,__ZNK10__cxxabiv120__si_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi,b12,__ZNK10__cxxabiv121__vmi_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi,b12];
  return { _im_enable_ym_as_szm: _im_enable_ym_as_szm, _strlen: _strlen, _im_reset_search: _im_reset_search, _im_flush_cache: _im_flush_cache, _im_get_candidate_char: _im_get_candidate_char, _realloc: _realloc, _im_get_spl_start: _im_get_spl_start, _im_close_decoder: _im_close_decoder, _toUTF8: _toUTF8, _im_open_decoder_fd: _im_open_decoder_fd, _strncpy: _strncpy, _im_get_spl_start_at: _im_get_spl_start_at, _im_get_fixed_len: _im_get_fixed_len, _im_cancel_last_choice: _im_cancel_last_choice, _memset: _memset, _im_search: _im_search, _memcpy: _memcpy, _calloc: _calloc, _im_choose: _im_choose, _im_set_max_lens: _im_set_max_lens, _im_get_predict_at: _im_get_predict_at, _im_get_candidate: _im_get_candidate, _im_enable_shm_as_szm: _im_enable_shm_as_szm, _im_get_sps_str: _im_get_sps_str, _memcmp: _memcmp, _im_get_predicts: _im_get_predicts, _free: _free, _im_open_decoder: _im_open_decoder, _memmove: _memmove, _malloc: _malloc, _im_get_predicts_utf8: _im_get_predicts_utf8, _im_delsearch: _im_delsearch, _strcpy: _strcpy, runPostSets: runPostSets, stackAlloc: stackAlloc, stackSave: stackSave, stackRestore: stackRestore, setThrew: setThrew, setTempRet0: setTempRet0, setTempRet1: setTempRet1, setTempRet2: setTempRet2, setTempRet3: setTempRet3, setTempRet4: setTempRet4, setTempRet5: setTempRet5, setTempRet6: setTempRet6, setTempRet7: setTempRet7, setTempRet8: setTempRet8, setTempRet9: setTempRet9, dynCall_viiiii: dynCall_viiiii, dynCall_vi: dynCall_vi, dynCall_vii: dynCall_vii, dynCall_iiiiiii: dynCall_iiiiiii, dynCall_iiiii: dynCall_iiiii, dynCall_ii: dynCall_ii, dynCall_iiii: dynCall_iiii, dynCall_viii: dynCall_viii, dynCall_v: dynCall_v, dynCall_viiiiii: dynCall_viiiiii, dynCall_iii: dynCall_iii, dynCall_iiiiii: dynCall_iiiiii, dynCall_viiii: dynCall_viiii };
})
// EMSCRIPTEN_END_ASM
({ "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array }, { "abort": abort, "assert": assert, "asmPrintInt": asmPrintInt, "asmPrintFloat": asmPrintFloat, "min": Math_min, "invoke_viiiii": invoke_viiiii, "invoke_vi": invoke_vi, "invoke_vii": invoke_vii, "invoke_iiiiiii": invoke_iiiiiii, "invoke_iiiii": invoke_iiiii, "invoke_ii": invoke_ii, "invoke_iiii": invoke_iiii, "invoke_viii": invoke_viii, "invoke_v": invoke_v, "invoke_viiiiii": invoke_viiiiii, "invoke_iii": invoke_iii, "invoke_iiiiii": invoke_iiiiii, "invoke_viiii": invoke_viiii, "_strncmp": _strncmp, "_lseek": _lseek, "___cxa_call_unexpected": ___cxa_call_unexpected, "_snprintf": _snprintf, "___cxa_free_exception": ___cxa_free_exception, "___cxa_throw": ___cxa_throw, "_fread": _fread, "_fclose": _fclose, "_strerror": _strerror, "___cxa_pure_virtual": ___cxa_pure_virtual, "_fprintf": _fprintf, "_sqrt": _sqrt, "_llvm_va_end": _llvm_va_end, "_pread": _pread, "_close": _close, "_feof": _feof, "_fopen": _fopen, "_open": _open, "_strchr": _strchr, "_fputc": _fputc, "___buildEnvironment": ___buildEnvironment, "_log": _log, "_puts": _puts, "_abort": _abort, "___setErrNo": ___setErrNo, "_recv": _recv, "_fseek": _fseek, "_qsort": _qsort, "_qsort2": _qsort2, "_send": _send, "_write": _write, "_fputs": _fputs, "_ftell": _ftell, "_llvm_umul_with_overflow_i32": _llvm_umul_with_overflow_i32, "_exit": _exit, "___cxa_find_matching_catch": ___cxa_find_matching_catch, "_strdup": _strdup, "___cxa_allocate_exception": ___cxa_allocate_exception, "_ferror": _ferror, "_printf": _printf, "_sysconf": _sysconf, "_sbrk": _sbrk, "_truncate": _truncate, "_read": _read, "___cxa_is_number_type": ___cxa_is_number_type, "__reallyNegative": __reallyNegative, "_time": _time, "__formatString": __formatString, "___cxa_does_inherit": ___cxa_does_inherit, "_getenv": _getenv, "__ZSt9terminatev": __ZSt9terminatev, "_gettimeofday": _gettimeofday, "_llvm_eh_exception": _llvm_eh_exception, "_vfprintf": _vfprintf, "___cxa_begin_catch": ___cxa_begin_catch, "_unlink": _unlink, "___assert_func": ___assert_func, "__ZSt18uncaught_exceptionv": __ZSt18uncaught_exceptionv, "_pwrite": _pwrite, "_putchar": _putchar, "_fabs": _fabs, "_fsync": _fsync, "_strerror_r": _strerror_r, "___errno_location": ___errno_location, "___gxx_personality_v0": ___gxx_personality_v0, "_isspace": _isspace, "_fdopen": _fdopen, "_bsearch": _bsearch, "_fwrite": _fwrite, "_ftruncate": _ftruncate, "__exit": __exit, "___resumeException": ___resumeException, "_strcmp": _strcmp, "___cxa_end_catch": ___cxa_end_catch, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "cttz_i8": cttz_i8, "ctlz_i8": ctlz_i8, "NaN": NaN, "Infinity": Infinity, "__ZTIy": __ZTIy, "__ZTIx": __ZTIx, "__ZTIt": __ZTIt, "__ZTIs": __ZTIs, "__ZTIm": __ZTIm, "__ZTIl": __ZTIl, "__ZTIi": __ZTIi, "__ZTIh": __ZTIh, "__ZTIj": __ZTIj, "__ZTIe": __ZTIe, "__ZTId": __ZTId, "__ZTVN10__cxxabiv117__class_type_infoE": __ZTVN10__cxxabiv117__class_type_infoE, "__ZTIf": __ZTIf, "__ZTIa": __ZTIa, "__ZTIc": __ZTIc, "__ZTVN10__cxxabiv120__si_class_type_infoE": __ZTVN10__cxxabiv120__si_class_type_infoE, "_stderr": _stderr, "___progname": ___progname, "__ZTVN10__cxxabiv119__pointer_type_infoE": __ZTVN10__cxxabiv119__pointer_type_infoE }, buffer);
var _im_enable_ym_as_szm = Module["_im_enable_ym_as_szm"] = asm["_im_enable_ym_as_szm"];
var _strlen = Module["_strlen"] = asm["_strlen"];
var _im_reset_search = Module["_im_reset_search"] = asm["_im_reset_search"];
var _im_flush_cache = Module["_im_flush_cache"] = asm["_im_flush_cache"];
var _im_get_candidate_char = Module["_im_get_candidate_char"] = asm["_im_get_candidate_char"];
var _realloc = Module["_realloc"] = asm["_realloc"];
var _im_get_spl_start = Module["_im_get_spl_start"] = asm["_im_get_spl_start"];
var _im_close_decoder = Module["_im_close_decoder"] = asm["_im_close_decoder"];
var _toUTF8 = Module["_toUTF8"] = asm["_toUTF8"];
var _im_open_decoder_fd = Module["_im_open_decoder_fd"] = asm["_im_open_decoder_fd"];
var _strncpy = Module["_strncpy"] = asm["_strncpy"];
var _im_get_spl_start_at = Module["_im_get_spl_start_at"] = asm["_im_get_spl_start_at"];
var _im_get_fixed_len = Module["_im_get_fixed_len"] = asm["_im_get_fixed_len"];
var _im_cancel_last_choice = Module["_im_cancel_last_choice"] = asm["_im_cancel_last_choice"];
var _memset = Module["_memset"] = asm["_memset"];
var _im_search = Module["_im_search"] = asm["_im_search"];
var _memcpy = Module["_memcpy"] = asm["_memcpy"];
var _calloc = Module["_calloc"] = asm["_calloc"];
var _im_choose = Module["_im_choose"] = asm["_im_choose"];
var _im_set_max_lens = Module["_im_set_max_lens"] = asm["_im_set_max_lens"];
var _im_get_predict_at = Module["_im_get_predict_at"] = asm["_im_get_predict_at"];
var _im_get_candidate = Module["_im_get_candidate"] = asm["_im_get_candidate"];
var _im_enable_shm_as_szm = Module["_im_enable_shm_as_szm"] = asm["_im_enable_shm_as_szm"];
var _im_get_sps_str = Module["_im_get_sps_str"] = asm["_im_get_sps_str"];
var _memcmp = Module["_memcmp"] = asm["_memcmp"];
var _im_get_predicts = Module["_im_get_predicts"] = asm["_im_get_predicts"];
var _free = Module["_free"] = asm["_free"];
var _im_open_decoder = Module["_im_open_decoder"] = asm["_im_open_decoder"];
var _memmove = Module["_memmove"] = asm["_memmove"];
var _malloc = Module["_malloc"] = asm["_malloc"];
var _im_get_predicts_utf8 = Module["_im_get_predicts_utf8"] = asm["_im_get_predicts_utf8"];
var _im_delsearch = Module["_im_delsearch"] = asm["_im_delsearch"];
var _strcpy = Module["_strcpy"] = asm["_strcpy"];
var runPostSets = Module["runPostSets"] = asm["runPostSets"];
var dynCall_viiiii = Module["dynCall_viiiii"] = asm["dynCall_viiiii"];
var dynCall_vi = Module["dynCall_vi"] = asm["dynCall_vi"];
var dynCall_vii = Module["dynCall_vii"] = asm["dynCall_vii"];
var dynCall_iiiiiii = Module["dynCall_iiiiiii"] = asm["dynCall_iiiiiii"];
var dynCall_iiiii = Module["dynCall_iiiii"] = asm["dynCall_iiiii"];
var dynCall_ii = Module["dynCall_ii"] = asm["dynCall_ii"];
var dynCall_iiii = Module["dynCall_iiii"] = asm["dynCall_iiii"];
var dynCall_viii = Module["dynCall_viii"] = asm["dynCall_viii"];
var dynCall_v = Module["dynCall_v"] = asm["dynCall_v"];
var dynCall_viiiiii = Module["dynCall_viiiiii"] = asm["dynCall_viiiiii"];
var dynCall_iii = Module["dynCall_iii"] = asm["dynCall_iii"];
var dynCall_iiiiii = Module["dynCall_iiiiii"] = asm["dynCall_iiiiii"];
var dynCall_viiii = Module["dynCall_viiii"] = asm["dynCall_viiii"];
Runtime.stackAlloc = function(size) { return asm['stackAlloc'](size) };
Runtime.stackSave = function() { return asm['stackSave']() };
Runtime.stackRestore = function(top) { asm['stackRestore'](top) };
// TODO: strip out parts of this we do not need
//======= begin closure i64 code =======
// Copyright 2009 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * @fileoverview Defines a Long class for representing a 64-bit two's-complement
 * integer value, which faithfully simulates the behavior of a Java "long". This
 * implementation is derived from LongLib in GWT.
 *
 */
var i64Math = (function() { // Emscripten wrapper
  var goog = { math: {} };
  /**
   * Constructs a 64-bit two's-complement integer, given its low and high 32-bit
   * values as *signed* integers.  See the from* functions below for more
   * convenient ways of constructing Longs.
   *
   * The internal representation of a long is the two given signed, 32-bit values.
   * We use 32-bit pieces because these are the size of integers on which
   * Javascript performs bit-operations.  For operations like addition and
   * multiplication, we split each number into 16-bit pieces, which can easily be
   * multiplied within Javascript's floating-point representation without overflow
   * or change in sign.
   *
   * In the algorithms below, we frequently reduce the negative case to the
   * positive case by negating the input(s) and then post-processing the result.
   * Note that we must ALWAYS check specially whether those values are MIN_VALUE
   * (-2^63) because -MIN_VALUE == MIN_VALUE (since 2^63 cannot be represented as
   * a positive number, it overflows back into a negative).  Not handling this
   * case would often result in infinite recursion.
   *
   * @param {number} low  The low (signed) 32 bits of the long.
   * @param {number} high  The high (signed) 32 bits of the long.
   * @constructor
   */
  goog.math.Long = function(low, high) {
    /**
     * @type {number}
     * @private
     */
    this.low_ = low | 0;  // force into 32 signed bits.
    /**
     * @type {number}
     * @private
     */
    this.high_ = high | 0;  // force into 32 signed bits.
  };
  // NOTE: Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the
  // from* methods on which they depend.
  /**
   * A cache of the Long representations of small integer values.
   * @type {!Object}
   * @private
   */
  goog.math.Long.IntCache_ = {};
  /**
   * Returns a Long representing the given (32-bit) integer value.
   * @param {number} value The 32-bit integer in question.
   * @return {!goog.math.Long} The corresponding Long value.
   */
  goog.math.Long.fromInt = function(value) {
    if (-128 <= value && value < 128) {
      var cachedObj = goog.math.Long.IntCache_[value];
      if (cachedObj) {
        return cachedObj;
      }
    }
    var obj = new goog.math.Long(value | 0, value < 0 ? -1 : 0);
    if (-128 <= value && value < 128) {
      goog.math.Long.IntCache_[value] = obj;
    }
    return obj;
  };
  /**
   * Returns a Long representing the given value, provided that it is a finite
   * number.  Otherwise, zero is returned.
   * @param {number} value The number in question.
   * @return {!goog.math.Long} The corresponding Long value.
   */
  goog.math.Long.fromNumber = function(value) {
    if (isNaN(value) || !isFinite(value)) {
      return goog.math.Long.ZERO;
    } else if (value <= -goog.math.Long.TWO_PWR_63_DBL_) {
      return goog.math.Long.MIN_VALUE;
    } else if (value + 1 >= goog.math.Long.TWO_PWR_63_DBL_) {
      return goog.math.Long.MAX_VALUE;
    } else if (value < 0) {
      return goog.math.Long.fromNumber(-value).negate();
    } else {
      return new goog.math.Long(
          (value % goog.math.Long.TWO_PWR_32_DBL_) | 0,
          (value / goog.math.Long.TWO_PWR_32_DBL_) | 0);
    }
  };
  /**
   * Returns a Long representing the 64-bit integer that comes by concatenating
   * the given high and low bits.  Each is assumed to use 32 bits.
   * @param {number} lowBits The low 32-bits.
   * @param {number} highBits The high 32-bits.
   * @return {!goog.math.Long} The corresponding Long value.
   */
  goog.math.Long.fromBits = function(lowBits, highBits) {
    return new goog.math.Long(lowBits, highBits);
  };
  /**
   * Returns a Long representation of the given string, written using the given
   * radix.
   * @param {string} str The textual representation of the Long.
   * @param {number=} opt_radix The radix in which the text is written.
   * @return {!goog.math.Long} The corresponding Long value.
   */
  goog.math.Long.fromString = function(str, opt_radix) {
    if (str.length == 0) {
      throw Error('number format error: empty string');
    }
    var radix = opt_radix || 10;
    if (radix < 2 || 36 < radix) {
      throw Error('radix out of range: ' + radix);
    }
    if (str.charAt(0) == '-') {
      return goog.math.Long.fromString(str.substring(1), radix).negate();
    } else if (str.indexOf('-') >= 0) {
      throw Error('number format error: interior "-" character: ' + str);
    }
    // Do several (8) digits each time through the loop, so as to
    // minimize the calls to the very expensive emulated div.
    var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 8));
    var result = goog.math.Long.ZERO;
    for (var i = 0; i < str.length; i += 8) {
      var size = Math.min(8, str.length - i);
      var value = parseInt(str.substring(i, i + size), radix);
      if (size < 8) {
        var power = goog.math.Long.fromNumber(Math.pow(radix, size));
        result = result.multiply(power).add(goog.math.Long.fromNumber(value));
      } else {
        result = result.multiply(radixToPower);
        result = result.add(goog.math.Long.fromNumber(value));
      }
    }
    return result;
  };
  // NOTE: the compiler should inline these constant values below and then remove
  // these variables, so there should be no runtime penalty for these.
  /**
   * Number used repeated below in calculations.  This must appear before the
   * first call to any from* function below.
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_16_DBL_ = 1 << 16;
  /**
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_24_DBL_ = 1 << 24;
  /**
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_32_DBL_ =
      goog.math.Long.TWO_PWR_16_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;
  /**
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_31_DBL_ =
      goog.math.Long.TWO_PWR_32_DBL_ / 2;
  /**
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_48_DBL_ =
      goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;
  /**
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_64_DBL_ =
      goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_32_DBL_;
  /**
   * @type {number}
   * @private
   */
  goog.math.Long.TWO_PWR_63_DBL_ =
      goog.math.Long.TWO_PWR_64_DBL_ / 2;
  /** @type {!goog.math.Long} */
  goog.math.Long.ZERO = goog.math.Long.fromInt(0);
  /** @type {!goog.math.Long} */
  goog.math.Long.ONE = goog.math.Long.fromInt(1);
  /** @type {!goog.math.Long} */
  goog.math.Long.NEG_ONE = goog.math.Long.fromInt(-1);
  /** @type {!goog.math.Long} */
  goog.math.Long.MAX_VALUE =
      goog.math.Long.fromBits(0xFFFFFFFF | 0, 0x7FFFFFFF | 0);
  /** @type {!goog.math.Long} */
  goog.math.Long.MIN_VALUE = goog.math.Long.fromBits(0, 0x80000000 | 0);
  /**
   * @type {!goog.math.Long}
   * @private
   */
  goog.math.Long.TWO_PWR_24_ = goog.math.Long.fromInt(1 << 24);
  /** @return {number} The value, assuming it is a 32-bit integer. */
  goog.math.Long.prototype.toInt = function() {
    return this.low_;
  };
  /** @return {number} The closest floating-point representation to this value. */
  goog.math.Long.prototype.toNumber = function() {
    return this.high_ * goog.math.Long.TWO_PWR_32_DBL_ +
           this.getLowBitsUnsigned();
  };
  /**
   * @param {number=} opt_radix The radix in which the text should be written.
   * @return {string} The textual representation of this value.
   */
  goog.math.Long.prototype.toString = function(opt_radix) {
    var radix = opt_radix || 10;
    if (radix < 2 || 36 < radix) {
      throw Error('radix out of range: ' + radix);
    }
    if (this.isZero()) {
      return '0';
    }
    if (this.isNegative()) {
      if (this.equals(goog.math.Long.MIN_VALUE)) {
        // We need to change the Long value before it can be negated, so we remove
        // the bottom-most digit in this base and then recurse to do the rest.
        var radixLong = goog.math.Long.fromNumber(radix);
        var div = this.div(radixLong);
        var rem = div.multiply(radixLong).subtract(this);
        return div.toString(radix) + rem.toInt().toString(radix);
      } else {
        return '-' + this.negate().toString(radix);
      }
    }
    // Do several (6) digits each time through the loop, so as to
    // minimize the calls to the very expensive emulated div.
    var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 6));
    var rem = this;
    var result = '';
    while (true) {
      var remDiv = rem.div(radixToPower);
      var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt();
      var digits = intval.toString(radix);
      rem = remDiv;
      if (rem.isZero()) {
        return digits + result;
      } else {
        while (digits.length < 6) {
          digits = '0' + digits;
        }
        result = '' + digits + result;
      }
    }
  };
  /** @return {number} The high 32-bits as a signed value. */
  goog.math.Long.prototype.getHighBits = function() {
    return this.high_;
  };
  /** @return {number} The low 32-bits as a signed value. */
  goog.math.Long.prototype.getLowBits = function() {
    return this.low_;
  };
  /** @return {number} The low 32-bits as an unsigned value. */
  goog.math.Long.prototype.getLowBitsUnsigned = function() {
    return (this.low_ >= 0) ?
        this.low_ : goog.math.Long.TWO_PWR_32_DBL_ + this.low_;
  };
  /**
   * @return {number} Returns the number of bits needed to represent the absolute
   *     value of this Long.
   */
  goog.math.Long.prototype.getNumBitsAbs = function() {
    if (this.isNegative()) {
      if (this.equals(goog.math.Long.MIN_VALUE)) {
        return 64;
      } else {
        return this.negate().getNumBitsAbs();
      }
    } else {
      var val = this.high_ != 0 ? this.high_ : this.low_;
      for (var bit = 31; bit > 0; bit--) {
        if ((val & (1 << bit)) != 0) {
          break;
        }
      }
      return this.high_ != 0 ? bit + 33 : bit + 1;
    }
  };
  /** @return {boolean} Whether this value is zero. */
  goog.math.Long.prototype.isZero = function() {
    return this.high_ == 0 && this.low_ == 0;
  };
  /** @return {boolean} Whether this value is negative. */
  goog.math.Long.prototype.isNegative = function() {
    return this.high_ < 0;
  };
  /** @return {boolean} Whether this value is odd. */
  goog.math.Long.prototype.isOdd = function() {
    return (this.low_ & 1) == 1;
  };
  /**
   * @param {goog.math.Long} other Long to compare against.
   * @return {boolean} Whether this Long equals the other.
   */
  goog.math.Long.prototype.equals = function(other) {
    return (this.high_ == other.high_) && (this.low_ == other.low_);
  };
  /**
   * @param {goog.math.Long} other Long to compare against.
   * @return {boolean} Whether this Long does not equal the other.
   */
  goog.math.Long.prototype.notEquals = function(other) {
    return (this.high_ != other.high_) || (this.low_ != other.low_);
  };
  /**
   * @param {goog.math.Long} other Long to compare against.
   * @return {boolean} Whether this Long is less than the other.
   */
  goog.math.Long.prototype.lessThan = function(other) {
    return this.compare(other) < 0;
  };
  /**
   * @param {goog.math.Long} other Long to compare against.
   * @return {boolean} Whether this Long is less than or equal to the other.
   */
  goog.math.Long.prototype.lessThanOrEqual = function(other) {
    return this.compare(other) <= 0;
  };
  /**
   * @param {goog.math.Long} other Long to compare against.
   * @return {boolean} Whether this Long is greater than the other.
   */
  goog.math.Long.prototype.greaterThan = function(other) {
    return this.compare(other) > 0;
  };
  /**
   * @param {goog.math.Long} other Long to compare against.
   * @return {boolean} Whether this Long is greater than or equal to the other.
   */
  goog.math.Long.prototype.greaterThanOrEqual = function(other) {
    return this.compare(other) >= 0;
  };
  /**
   * Compares this Long with the given one.
   * @param {goog.math.Long} other Long to compare against.
   * @return {number} 0 if they are the same, 1 if the this is greater, and -1
   *     if the given one is greater.
   */
  goog.math.Long.prototype.compare = function(other) {
    if (this.equals(other)) {
      return 0;
    }
    var thisNeg = this.isNegative();
    var otherNeg = other.isNegative();
    if (thisNeg && !otherNeg) {
      return -1;
    }
    if (!thisNeg && otherNeg) {
      return 1;
    }
    // at this point, the signs are the same, so subtraction will not overflow
    if (this.subtract(other).isNegative()) {
      return -1;
    } else {
      return 1;
    }
  };
  /** @return {!goog.math.Long} The negation of this value. */
  goog.math.Long.prototype.negate = function() {
    if (this.equals(goog.math.Long.MIN_VALUE)) {
      return goog.math.Long.MIN_VALUE;
    } else {
      return this.not().add(goog.math.Long.ONE);
    }
  };
  /**
   * Returns the sum of this and the given Long.
   * @param {goog.math.Long} other Long to add to this one.
   * @return {!goog.math.Long} The sum of this and the given Long.
   */
  goog.math.Long.prototype.add = function(other) {
    // Divide each number into 4 chunks of 16 bits, and then sum the chunks.
    var a48 = this.high_ >>> 16;
    var a32 = this.high_ & 0xFFFF;
    var a16 = this.low_ >>> 16;
    var a00 = this.low_ & 0xFFFF;
    var b48 = other.high_ >>> 16;
    var b32 = other.high_ & 0xFFFF;
    var b16 = other.low_ >>> 16;
    var b00 = other.low_ & 0xFFFF;
    var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
    c00 += a00 + b00;
    c16 += c00 >>> 16;
    c00 &= 0xFFFF;
    c16 += a16 + b16;
    c32 += c16 >>> 16;
    c16 &= 0xFFFF;
    c32 += a32 + b32;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c48 += a48 + b48;
    c48 &= 0xFFFF;
    return goog.math.Long.fromBits((c16 << 16) | c00, (c48 << 16) | c32);
  };
  /**
   * Returns the difference of this and the given Long.
   * @param {goog.math.Long} other Long to subtract from this.
   * @return {!goog.math.Long} The difference of this and the given Long.
   */
  goog.math.Long.prototype.subtract = function(other) {
    return this.add(other.negate());
  };
  /**
   * Returns the product of this and the given long.
   * @param {goog.math.Long} other Long to multiply with this.
   * @return {!goog.math.Long} The product of this and the other.
   */
  goog.math.Long.prototype.multiply = function(other) {
    if (this.isZero()) {
      return goog.math.Long.ZERO;
    } else if (other.isZero()) {
      return goog.math.Long.ZERO;
    }
    if (this.equals(goog.math.Long.MIN_VALUE)) {
      return other.isOdd() ? goog.math.Long.MIN_VALUE : goog.math.Long.ZERO;
    } else if (other.equals(goog.math.Long.MIN_VALUE)) {
      return this.isOdd() ? goog.math.Long.MIN_VALUE : goog.math.Long.ZERO;
    }
    if (this.isNegative()) {
      if (other.isNegative()) {
        return this.negate().multiply(other.negate());
      } else {
        return this.negate().multiply(other).negate();
      }
    } else if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
    // If both longs are small, use float multiplication
    if (this.lessThan(goog.math.Long.TWO_PWR_24_) &&
        other.lessThan(goog.math.Long.TWO_PWR_24_)) {
      return goog.math.Long.fromNumber(this.toNumber() * other.toNumber());
    }
    // Divide each long into 4 chunks of 16 bits, and then add up 4x4 products.
    // We can skip products that would overflow.
    var a48 = this.high_ >>> 16;
    var a32 = this.high_ & 0xFFFF;
    var a16 = this.low_ >>> 16;
    var a00 = this.low_ & 0xFFFF;
    var b48 = other.high_ >>> 16;
    var b32 = other.high_ & 0xFFFF;
    var b16 = other.low_ >>> 16;
    var b00 = other.low_ & 0xFFFF;
    var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
    c00 += a00 * b00;
    c16 += c00 >>> 16;
    c00 &= 0xFFFF;
    c16 += a16 * b00;
    c32 += c16 >>> 16;
    c16 &= 0xFFFF;
    c16 += a00 * b16;
    c32 += c16 >>> 16;
    c16 &= 0xFFFF;
    c32 += a32 * b00;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c32 += a16 * b16;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c32 += a00 * b32;
    c48 += c32 >>> 16;
    c32 &= 0xFFFF;
    c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
    c48 &= 0xFFFF;
    return goog.math.Long.fromBits((c16 << 16) | c00, (c48 << 16) | c32);
  };
  /**
   * Returns this Long divided by the given one.
   * @param {goog.math.Long} other Long by which to divide.
   * @return {!goog.math.Long} This Long divided by the given one.
   */
  goog.math.Long.prototype.div = function(other) {
    if (other.isZero()) {
      throw Error('division by zero');
    } else if (this.isZero()) {
      return goog.math.Long.ZERO;
    }
    if (this.equals(goog.math.Long.MIN_VALUE)) {
      if (other.equals(goog.math.Long.ONE) ||
          other.equals(goog.math.Long.NEG_ONE)) {
        return goog.math.Long.MIN_VALUE;  // recall that -MIN_VALUE == MIN_VALUE
      } else if (other.equals(goog.math.Long.MIN_VALUE)) {
        return goog.math.Long.ONE;
      } else {
        // At this point, we have |other| >= 2, so |this/other| < |MIN_VALUE|.
        var halfThis = this.shiftRight(1);
        var approx = halfThis.div(other).shiftLeft(1);
        if (approx.equals(goog.math.Long.ZERO)) {
          return other.isNegative() ? goog.math.Long.ONE : goog.math.Long.NEG_ONE;
        } else {
          var rem = this.subtract(other.multiply(approx));
          var result = approx.add(rem.div(other));
          return result;
        }
      }
    } else if (other.equals(goog.math.Long.MIN_VALUE)) {
      return goog.math.Long.ZERO;
    }
    if (this.isNegative()) {
      if (other.isNegative()) {
        return this.negate().div(other.negate());
      } else {
        return this.negate().div(other).negate();
      }
    } else if (other.isNegative()) {
      return this.div(other.negate()).negate();
    }
    // Repeat the following until the remainder is less than other:  find a
    // floating-point that approximates remainder / other *from below*, add this
    // into the result, and subtract it from the remainder.  It is critical that
    // the approximate value is less than or equal to the real value so that the
    // remainder never becomes negative.
    var res = goog.math.Long.ZERO;
    var rem = this;
    while (rem.greaterThanOrEqual(other)) {
      // Approximate the result of division. This may be a little greater or
      // smaller than the actual value.
      var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
      // We will tweak the approximate result by changing it in the 48-th digit or
      // the smallest non-fractional digit, whichever is larger.
      var log2 = Math.ceil(Math.log(approx) / Math.LN2);
      var delta = (log2 <= 48) ? 1 : Math.pow(2, log2 - 48);
      // Decrease the approximation until it is smaller than the remainder.  Note
      // that if it is too large, the product overflows and is negative.
      var approxRes = goog.math.Long.fromNumber(approx);
      var approxRem = approxRes.multiply(other);
      while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
        approx -= delta;
        approxRes = goog.math.Long.fromNumber(approx);
        approxRem = approxRes.multiply(other);
      }
      // We know the answer can't be zero... and actually, zero would cause
      // infinite recursion since we would make no progress.
      if (approxRes.isZero()) {
        approxRes = goog.math.Long.ONE;
      }
      res = res.add(approxRes);
      rem = rem.subtract(approxRem);
    }
    return res;
  };
  /**
   * Returns this Long modulo the given one.
   * @param {goog.math.Long} other Long by which to mod.
   * @return {!goog.math.Long} This Long modulo the given one.
   */
  goog.math.Long.prototype.modulo = function(other) {
    return this.subtract(this.div(other).multiply(other));
  };
  /** @return {!goog.math.Long} The bitwise-NOT of this value. */
  goog.math.Long.prototype.not = function() {
    return goog.math.Long.fromBits(~this.low_, ~this.high_);
  };
  /**
   * Returns the bitwise-AND of this Long and the given one.
   * @param {goog.math.Long} other The Long with which to AND.
   * @return {!goog.math.Long} The bitwise-AND of this and the other.
   */
  goog.math.Long.prototype.and = function(other) {
    return goog.math.Long.fromBits(this.low_ & other.low_,
                                   this.high_ & other.high_);
  };
  /**
   * Returns the bitwise-OR of this Long and the given one.
   * @param {goog.math.Long} other The Long with which to OR.
   * @return {!goog.math.Long} The bitwise-OR of this and the other.
   */
  goog.math.Long.prototype.or = function(other) {
    return goog.math.Long.fromBits(this.low_ | other.low_,
                                   this.high_ | other.high_);
  };
  /**
   * Returns the bitwise-XOR of this Long and the given one.
   * @param {goog.math.Long} other The Long with which to XOR.
   * @return {!goog.math.Long} The bitwise-XOR of this and the other.
   */
  goog.math.Long.prototype.xor = function(other) {
    return goog.math.Long.fromBits(this.low_ ^ other.low_,
                                   this.high_ ^ other.high_);
  };
  /**
   * Returns this Long with bits shifted to the left by the given amount.
   * @param {number} numBits The number of bits by which to shift.
   * @return {!goog.math.Long} This shifted to the left by the given amount.
   */
  goog.math.Long.prototype.shiftLeft = function(numBits) {
    numBits &= 63;
    if (numBits == 0) {
      return this;
    } else {
      var low = this.low_;
      if (numBits < 32) {
        var high = this.high_;
        return goog.math.Long.fromBits(
            low << numBits,
            (high << numBits) | (low >>> (32 - numBits)));
      } else {
        return goog.math.Long.fromBits(0, low << (numBits - 32));
      }
    }
  };
  /**
   * Returns this Long with bits shifted to the right by the given amount.
   * @param {number} numBits The number of bits by which to shift.
   * @return {!goog.math.Long} This shifted to the right by the given amount.
   */
  goog.math.Long.prototype.shiftRight = function(numBits) {
    numBits &= 63;
    if (numBits == 0) {
      return this;
    } else {
      var high = this.high_;
      if (numBits < 32) {
        var low = this.low_;
        return goog.math.Long.fromBits(
            (low >>> numBits) | (high << (32 - numBits)),
            high >> numBits);
      } else {
        return goog.math.Long.fromBits(
            high >> (numBits - 32),
            high >= 0 ? 0 : -1);
      }
    }
  };
  /**
   * Returns this Long with bits shifted to the right by the given amount, with
   * the new top bits matching the current sign bit.
   * @param {number} numBits The number of bits by which to shift.
   * @return {!goog.math.Long} This shifted to the right by the given amount, with
   *     zeros placed into the new leading bits.
   */
  goog.math.Long.prototype.shiftRightUnsigned = function(numBits) {
    numBits &= 63;
    if (numBits == 0) {
      return this;
    } else {
      var high = this.high_;
      if (numBits < 32) {
        var low = this.low_;
        return goog.math.Long.fromBits(
            (low >>> numBits) | (high << (32 - numBits)),
            high >>> numBits);
      } else if (numBits == 32) {
        return goog.math.Long.fromBits(high, 0);
      } else {
        return goog.math.Long.fromBits(high >>> (numBits - 32), 0);
      }
    }
  };
  //======= begin jsbn =======
  var navigator = { appName: 'Modern Browser' }; // polyfill a little
  // Copyright (c) 2005  Tom Wu
  // All Rights Reserved.
  // http://www-cs-students.stanford.edu/~tjw/jsbn/
  /*
   * Copyright (c) 2003-2005  Tom Wu
   * All Rights Reserved.
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
   * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
   *
   * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
   * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
   * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
   * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISIN