;(function(window,undefined){'use strict';function L10nError(message,id,loc){this.name='L10nError';this.message=message;this.id=id;this.loc=loc;}
L10nError.prototype=Object.create(Error.prototype);L10nError.prototype.constructor=L10nError;var io={_load:function(type,url,callback,sync){var xhr=new XMLHttpRequest();var needParse;if(xhr.overrideMimeType){xhr.overrideMimeType(type);}
xhr.open('GET',url,!sync);if(type==='application/json'){if(sync){needParse=true;}else{xhr.responseType='json';}}
xhr.addEventListener('load',function io_onload(e){if(e.target.status===200||e.target.status===0){var res=e.target.response||e.target.responseText;callback(null,needParse?JSON.parse(res):res);}else{callback(new L10nError('Not found: '+url));}});xhr.addEventListener('error',callback);xhr.addEventListener('timeout',callback);try{xhr.send(null);}catch(e){callback(new L10nError('Not found: '+url));}},load:function(url,callback,sync){return io._load('text/plain',url,callback,sync);},loadJSON:function(url,callback,sync){return io._load('application/json',url,callback,sync);}};function EventEmitter(){}
EventEmitter.prototype.emit=function ee_emit(){if(!this._listeners){return;}
var args=Array.prototype.slice.call(arguments);var type=args.shift();if(!this._listeners[type]){return;}
var typeListeners=this._listeners[type].slice();for(var i=0;i<typeListeners.length;i++){typeListeners[i].apply(this,args);}};EventEmitter.prototype.addEventListener=function ee_add(type,listener){if(!this._listeners){this._listeners={};}
if(!(type in this._listeners)){this._listeners[type]=[];}
this._listeners[type].push(listener);};EventEmitter.prototype.removeEventListener=function ee_rm(type,listener){if(!this._listeners){return;}
var typeListeners=this._listeners[type];var pos=typeListeners.indexOf(listener);if(pos===-1){return;}
typeListeners.splice(pos,1);};function getPluralRule(lang){var locales2rules={'af':3,'ak':4,'am':4,'ar':1,'asa':3,'az':0,'be':11,'bem':3,'bez':3,'bg':3,'bh':4,'bm':0,'bn':3,'bo':0,'br':20,'brx':3,'bs':11,'ca':3,'cgg':3,'chr':3,'cs':12,'cy':17,'da':3,'de':3,'dv':3,'dz':0,'ee':3,'el':3,'en':3,'eo':3,'es':3,'et':3,'eu':3,'fa':0,'ff':5,'fi':3,'fil':4,'fo':3,'fr':5,'fur':3,'fy':3,'ga':8,'gd':24,'gl':3,'gsw':3,'gu':3,'guw':4,'gv':23,'ha':3,'haw':3,'he':2,'hi':4,'hr':11,'hu':0,'id':0,'ig':0,'ii':0,'is':3,'it':3,'iu':7,'ja':0,'jmc':3,'jv':0,'ka':0,'kab':5,'kaj':3,'kcg':3,'kde':0,'kea':0,'kk':3,'kl':3,'km':0,'kn':0,'ko':0,'ksb':3,'ksh':21,'ku':3,'kw':7,'lag':18,'lb':3,'lg':3,'ln':4,'lo':0,'lt':10,'lv':6,'mas':3,'mg':4,'mk':16,'ml':3,'mn':3,'mo':9,'mr':3,'ms':0,'mt':15,'my':0,'nah':3,'naq':7,'nb':3,'nd':3,'ne':3,'nl':3,'nn':3,'no':3,'nr':3,'nso':4,'ny':3,'nyn':3,'om':3,'or':3,'pa':3,'pap':3,'pl':13,'ps':3,'pt':3,'rm':3,'ro':9,'rof':3,'ru':11,'rwk':3,'sah':0,'saq':3,'se':7,'seh':3,'ses':0,'sg':0,'sh':11,'shi':19,'sk':12,'sl':14,'sma':7,'smi':7,'smj':7,'smn':7,'sms':7,'sn':3,'so':3,'sq':3,'sr':11,'ss':3,'ssy':3,'st':3,'sv':3,'sw':3,'syr':3,'ta':3,'te':3,'teo':3,'th':0,'ti':4,'tig':3,'tk':3,'tl':4,'tn':3,'to':0,'tr':0,'ts':3,'tzm':22,'uk':11,'ur':3,'ve':3,'vi':0,'vun':3,'wa':4,'wae':3,'wo':0,'xh':3,'xog':3,'yo':0,'zh':0,'zu':3};function isIn(n,list){return list.indexOf(n)!==-1;}
function isBetween(n,start,end){return typeof n===typeof start&&start<=n&&n<=end;}
var pluralRules={'0':function(){return'other';},'1':function(n){if((isBetween((n%100),3,10))){return'few';}
if(n===0){return'zero';}
if((isBetween((n%100),11,99))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'2':function(n){if(n!==0&&(n%10)===0){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'3':function(n){if(n===1){return'one';}
return'other';},'4':function(n){if((isBetween(n,0,1))){return'one';}
return'other';},'5':function(n){if((isBetween(n,0,2))&&n!==2){return'one';}
return'other';},'6':function(n){if(n===0){return'zero';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'7':function(n){if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'8':function(n){if((isBetween(n,3,6))){return'few';}
if((isBetween(n,7,10))){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'9':function(n){if(n===0||n!==1&&(isBetween((n%100),1,19))){return'few';}
if(n===1){return'one';}
return'other';},'10':function(n){if((isBetween((n%10),2,9))&&!(isBetween((n%100),11,19))){return'few';}
if((n%10)===1&&!(isBetween((n%100),11,19))){return'one';}
return'other';},'11':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if((n%10)===0||(isBetween((n%10),5,9))||(isBetween((n%100),11,14))){return'many';}
if((n%10)===1&&(n%100)!==11){return'one';}
return'other';},'12':function(n){if((isBetween(n,2,4))){return'few';}
if(n===1){return'one';}
return'other';},'13':function(n){if((isBetween((n%10),2,4))&&!(isBetween((n%100),12,14))){return'few';}
if(n!==1&&(isBetween((n%10),0,1))||(isBetween((n%10),5,9))||(isBetween((n%100),12,14))){return'many';}
if(n===1){return'one';}
return'other';},'14':function(n){if((isBetween((n%100),3,4))){return'few';}
if((n%100)===2){return'two';}
if((n%100)===1){return'one';}
return'other';},'15':function(n){if(n===0||(isBetween((n%100),2,10))){return'few';}
if((isBetween((n%100),11,19))){return'many';}
if(n===1){return'one';}
return'other';},'16':function(n){if((n%10)===1&&n!==11){return'one';}
return'other';},'17':function(n){if(n===3){return'few';}
if(n===0){return'zero';}
if(n===6){return'many';}
if(n===2){return'two';}
if(n===1){return'one';}
return'other';},'18':function(n){if(n===0){return'zero';}
if((isBetween(n,0,2))&&n!==0&&n!==2){return'one';}
return'other';},'19':function(n){if((isBetween(n,2,10))){return'few';}
if((isBetween(n,0,1))){return'one';}
return'other';},'20':function(n){if((isBetween((n%10),3,4)||((n%10)===9))&&!(isBetween((n%100),10,19)||isBetween((n%100),70,79)||isBetween((n%100),90,99))){return'few';}
if((n%1000000)===0&&n!==0){return'many';}
if((n%10)===2&&!isIn((n%100),[12,72,92])){return'two';}
if((n%10)===1&&!isIn((n%100),[11,71,91])){return'one';}
return'other';},'21':function(n){if(n===0){return'zero';}
if(n===1){return'one';}
return'other';},'22':function(n){if((isBetween(n,0,1))||(isBetween(n,11,99))){return'one';}
return'other';},'23':function(n){if((isBetween((n%10),1,2))||(n%20)===0){return'one';}
return'other';},'24':function(n){if((isBetween(n,3,10)||isBetween(n,13,19))){return'few';}
if(isIn(n,[2,12])){return'two';}
if(isIn(n,[1,11])){return'one';}
return'other';}};var index=locales2rules[lang.replace(/-.*$/,'')];if(!(index in pluralRules)){return function(){return'other';};}
return pluralRules[index];}
var MAX_PLACEABLES=100;var PropertiesParser={patterns:null,entryIds:null,init:function(){this.patterns={comment:/^\s*#|^\s*$/,entity:/^([^=\s]+)\s*=\s*(.*)$/,multiline:/[^\\]\\$/,index:/\{\[\s*(\w+)(?:\(([^\)]*)\))?\s*\]\}/i,unicode:/\\u([0-9a-fA-F]{1,4})/g,entries:/[^\r\n]+/g,controlChars:/\\([\\\n\r\t\b\f\{\}\"\'])/g,placeables:/\{\{\s*([^\s]*?)\s*\}\}/,};},parse:function(ctx,source){if(!this.patterns){this.init();}
var ast=[];this.entryIds=Object.create(null);var entries=source.match(this.patterns.entries);if(!entries){return ast;}
for(var i=0;i<entries.length;i++){var line=entries[i];if(this.patterns.comment.test(line)){continue;}
while(this.patterns.multiline.test(line)&&i<entries.length){line=line.slice(0,-1)+entries[++i].trim();}
var entityMatch=line.match(this.patterns.entity);if(entityMatch){try{this.parseEntity(entityMatch[1],entityMatch[2],ast);}catch(e){if(ctx){ctx._emitter.emit('parseerror',e);}else{throw e;}}}}
return ast;},parseEntity:function(id,value,ast){var name,key;var pos=id.indexOf('[');if(pos!==-1){name=id.substr(0,pos);key=id.substring(pos+1,id.length-1);}else{name=id;key=null;}
var nameElements=name.split('.');if(nameElements.length>2){throw new L10nError('Error in ID: "'+name+'".'+' Nested attributes are not supported.');}
var attr;if(nameElements.length>1){name=nameElements[0];attr=nameElements[1];if(attr[0]==='$'){throw new L10nError('Attribute can\'t start with "$"',id);}}else{attr=null;}
this.setEntityValue(name,attr,key,this.unescapeString(value),ast);},setEntityValue:function(id,attr,key,rawValue,ast){var pos,v;var value=rawValue.indexOf('{{')>-1?this.parseString(rawValue):rawValue;if(rawValue.indexOf('<')>-1||rawValue.indexOf('&')>-1){value={$o:value};}
if(attr){pos=this.entryIds[id];if(pos===undefined){v={$i:id};if(key){v[attr]={};v[attr][key]=value;}else{v[attr]=value;}
ast.push(v);this.entryIds[id]=ast.length-1;return;}
if(key){if(typeof(ast[pos][attr])==='string'){ast[pos][attr]={$x:this.parseIndex(ast[pos][attr]),$v:{}};}
ast[pos][attr].$v[key]=value;return;}
ast[pos][attr]=value;return;}
if(key){pos=this.entryIds[id];if(pos===undefined){v={};v[key]=value;ast.push({$i:id,$v:v});this.entryIds[id]=ast.length-1;return;}
if(typeof(ast[pos].$v)==='string'){ast[pos].$x=this.parseIndex(ast[pos].$v);ast[pos].$v={};}
ast[pos].$v[key]=value;return;}
ast.push({$i:id,$v:value});this.entryIds[id]=ast.length-1;},parseString:function(str){var chunks=str.split(this.patterns.placeables);var complexStr=[];var len=chunks.length;var placeablesCount=(len-1)/2;if(placeablesCount>=MAX_PLACEABLES){throw new L10nError('Too many placeables ('+placeablesCount+', max allowed is '+MAX_PLACEABLES+')');}
for(var i=0;i<chunks.length;i++){if(chunks[i].length===0){continue;}
if(i%2===1){complexStr.push({t:'idOrVar',v:chunks[i]});}else{complexStr.push(chunks[i]);}}
return complexStr;},unescapeString:function(str){if(str.lastIndexOf('\\')!==-1){str=str.replace(this.patterns.controlChars,'$1');}
return str.replace(this.patterns.unicode,function(match,token){return unescape('%u'+'0000'.slice(token.length)+token);});},parseIndex:function(str){var match=str.match(this.patterns.index);if(!match){throw new L10nError('Malformed index');}
if(match[2]){return[{t:'idOrVar',v:match[1]},match[2]];}else{return[{t:'idOrVar',v:match[1]}];}}};var KNOWN_MACROS=['plural'];var MAX_PLACEABLE_LENGTH=2500;var rePlaceables=/\{\{\s*(.+?)\s*\}\}/g;var nonLatin1=/[^\x01-\xFF]/;var FSI='\u2068';var PDI='\u2069';function createEntry(node,env){var keys=Object.keys(node);if(typeof node.$v==='string'&&keys.length===2){return node.$v;}
var attrs;for(var i=0,key;key=keys[i];i++){if(key[0]==='$'){continue;}
if(!attrs){attrs=Object.create(null);}
attrs[key]=createAttribute(node[key],env,node.$i+'.'+key);}
return{id:node.$i,value:node.$v!==undefined?node.$v:null,index:node.$x||null,attrs:attrs||null,env:env,dirty:false};}
function createAttribute(node,env,id){if(typeof node==='string'){return node;}
return{id:id,value:node.$v||(node!==undefined?node:null),index:node.$x||null,env:env,dirty:false};}
function format(args,entity){var locals={overlay:false};if(typeof entity==='string'){return[locals,entity];}
if(entity.dirty){throw new L10nError('Cyclic reference detected: '+entity.id);}
entity.dirty=true;var rv;try{rv=resolveValue(locals,args,entity.env,entity.value,entity.index);}finally{entity.dirty=false;}
return rv;}
function resolveIdentifier(args,env,id){if(KNOWN_MACROS.indexOf(id)>-1){return[{},env['__'+id]];}
if(args&&args.hasOwnProperty(id)){if(typeof args[id]==='string'||(typeof args[id]==='number'&&!isNaN(args[id]))){return[{},args[id]];}else{throw new L10nError('Arg must be a string or a number: '+id);}}
if(id in env&&id!=='__proto__'){return format(args,env[id]);}
throw new L10nError('Unknown reference: '+id);}
function subPlaceable(locals,args,env,id){var res;try{res=resolveIdentifier(args,env,id);}catch(err){return[{error:err},'{{ '+id+' }}'];}
var value=res[1];if(typeof value==='number'){return res;}
if(typeof value==='string'){if(value.length>=MAX_PLACEABLE_LENGTH){throw new L10nError('Too many characters in placeable ('+
value.length+', max allowed is '+
MAX_PLACEABLE_LENGTH+')');}
if(locals.contextIsNonLatin1||value.match(nonLatin1)){res[1]=FSI+value+PDI;}
return res;}
return[{},'{{ '+id+' }}'];}
function interpolate(locals,args,env,arr){return arr.reduce(function(prev,cur){if(typeof cur==='string'){return[prev[0],prev[1]+cur];}else if(cur.t==='idOrVar'){var placeable=subPlaceable(locals,args,env,cur.v);if(placeable[0].overlay){prev[0].overlay=true;}
return[prev[0],prev[1]+placeable[1]];}},[locals,'']);}
function resolveSelector(args,env,expr,index){var selectorName=index[0].v;var selector=resolveIdentifier(args,env,selectorName)[1];if(typeof selector!=='function'){return selector;}
var argValue=index[1]?resolveIdentifier(args,env,index[1])[1]:undefined;if(selector===env.__plural){if(argValue===0&&'zero'in expr){return'zero';}
if(argValue===1&&'one'in expr){return'one';}
if(argValue===2&&'two'in expr){return'two';}}
return selector(argValue);}
function resolveValue(locals,args,env,expr,index){if(!expr){return[locals,expr];}
if(expr.$o){expr=expr.$o;locals.overlay=true;}
if(typeof expr==='string'||typeof expr==='boolean'||typeof expr==='number'){return[locals,expr];}
if(Array.isArray(expr)){locals.contextIsNonLatin1=expr.some(function($_){return typeof($_)==='string'&&$_.match(nonLatin1);});return interpolate(locals,args,env,expr);}
if(index){var selector=resolveSelector(args,env,expr,index);if(expr.hasOwnProperty(selector)){return resolveValue(locals,args,env,expr[selector]);}}
if('other'in expr){return resolveValue(locals,args,env,expr.other);}
throw new L10nError('Unresolvable value');}
var Resolver={createEntry:createEntry,format:format,rePlaceables:rePlaceables};function walkContent(node,fn){if(typeof node==='string'){return fn(node);}
if(node.t==='idOrVar'){return node;}
var rv=Array.isArray(node)?[]:{};var keys=Object.keys(node);for(var i=0,key;key=keys[i];i++){if(key==='$i'||key==='$x'){rv[key]=node[key];}else{rv[key]=walkContent(node[key],fn);}}
return rv;}
var reAlphas=/[a-zA-Z]/g;var reVowels=/[aeiouAEIOU]/g;var ACCENTED_MAP='\u0226\u0181\u0187\u1E12\u1E16\u0191\u0193\u0126\u012A'+'\u0134\u0136\u013F\u1E3E\u0220\u01FE\u01A4\u024A\u0158'+'\u015E\u0166\u016C\u1E7C\u1E86\u1E8A\u1E8E\u1E90'+'[\\]^_`'+'\u0227\u0180\u0188\u1E13\u1E17\u0192\u0260\u0127\u012B'+'\u0135\u0137\u0140\u1E3F\u019E\u01FF\u01A5\u024B\u0159'+'\u015F\u0167\u016D\u1E7D\u1E87\u1E8B\u1E8F\u1E91';var FLIPPED_MAP='\u2200\u0510\u2183p\u018E\u025F\u05E4HI\u017F'+'\u04FC\u02E5WNO\u0500\xD2\u1D1AS\u22A5\u2229\u0245'+'\uFF2DX\u028EZ'+'[\\]\u1D65_,'+'\u0250q\u0254p\u01DD\u025F\u0183\u0265\u0131\u027E'+'\u029E\u0285\u026Fuodb\u0279s\u0287n\u028C\u028Dx\u028Ez';function makeLonger(val){return val.replace(reVowels,function(match){return match+match.toLowerCase();});}
function makeAccented(map,val){return val.replace(reAlphas,function(match){return map.charAt(match.charCodeAt(0)-65);});}
var reWords=/[^\W0-9_]+/g;function makeRTL(val){return val.replace(reWords,function(match){return'\u202e'+match+'\u202c';});}
var reExcluded=/(%[EO]?\w|\{\s*.+?\s*\})/;function mapContent(fn,val){if(!val){return val;}
var parts=val.split(reExcluded);var modified=parts.map(function(part){if(reExcluded.test(part)){return part;}
return fn(part);});return modified.join('');}
function Pseudo(id,name,charMap,modFn){this.id=id;this.translate=mapContent.bind(null,function(val){return makeAccented(charMap,modFn(val));});this.name=this.translate(name);}
var PSEUDO_STRATEGIES={'qps-ploc':new Pseudo('qps-ploc','Accented English',ACCENTED_MAP,makeLonger),'qps-plocm':new Pseudo('qps-plocm','Mirrored English',FLIPPED_MAP,makeRTL)};function Locale(id,ctx){this.id=id;this.ctx=ctx;this.isReady=false;this.isPseudo=PSEUDO_STRATEGIES.hasOwnProperty(id);this.entries=Object.create(null);this.entries.__plural=getPluralRule(this.isPseudo?this.ctx.defaultLocale:id);}
var bindingsIO={extra:function(id,ver,path,type,callback,errback,sync){if(type==='properties'){type='text';}
navigator.mozApps.getLocalizationResource(id,ver,path,type).then(callback.bind(null,null),errback);},app:function(id,ver,path,type,callback,errback,sync){switch(type){case'properties':io.load(path,callback,sync);break;case'json':io.loadJSON(path,callback,sync);break;}},};Locale.prototype.build=function L_build(callback){var sync=!callback;var ctx=this.ctx;var self=this;var l10nLoads=ctx.resLinks.length;function onL10nLoaded(err){if(err){ctx._emitter.emit('fetcherror',err);}
if(--l10nLoads<=0){self.isReady=true;if(callback){callback();}}}
if(l10nLoads===0){onL10nLoaded();return;}
function onJSONLoaded(err,json){if(!err&&json){self.addAST(json);}
onL10nLoaded(err);}
function onPropLoaded(err,source){if(!err&&source){var ast=PropertiesParser.parse(ctx,source);self.addAST(ast);}
onL10nLoaded(err);}
var idToFetch=this.isPseudo?ctx.defaultLocale:this.id;var source=navigator.mozL10n._config.localeSources[this.id]||'app';var appVersion=navigator.mozL10n._config.appVersion;for(var i=0;i<ctx.resLinks.length;i++){var resLink=decodeURI(ctx.resLinks[i]);var path=resLink.replace('{locale}',idToFetch);var type=path.substr(path.lastIndexOf('.')+1);var cb;switch(type){case'json':cb=onJSONLoaded;break;case'properties':cb=onPropLoaded;break;}
bindingsIO[source](this.id,appVersion,path,type,cb,onL10nLoaded,sync);}};function createPseudoEntry(node,entries){return Resolver.createEntry(walkContent(node,PSEUDO_STRATEGIES[this.id].translate),entries);}
Locale.prototype.addAST=function(ast){var createEntry=this.isPseudo?createPseudoEntry.bind(this):Resolver.createEntry;for(var i=0;i<ast.length;i++){this.entries[ast[i].$i]=createEntry(ast[i],this.entries);}};function Context(id){this.id=id;this.isReady=false;this.isLoading=false;this.defaultLocale='en-US';this.availableLocales=[];this.supportedLocales=[];this.resLinks=[];this.locales={};this._emitter=new EventEmitter();this._ready=new Promise(this.once.bind(this));}
function reportMissing(id,err){this._emitter.emit('notfounderror',err);return id;}
function getWithFallback(id){var cur=0;var loc;var locale;while(loc=this.supportedLocales[cur]){locale=this.getLocale(loc);if(!locale.isReady){locale.build(null);}
var entry=locale.entries[id];if(entry===undefined){cur++;reportMissing.call(this,id,new L10nError('"'+id+'"'+' not found in '+loc+' in '+this.id,id,loc));continue;}
return entry;}
throw new L10nError('"'+id+'"'+' missing from all supported locales in '+this.id,id);}
function formatTuple(args,entity){try{return Resolver.format(args,entity);}catch(err){this._emitter.emit('resolveerror',err);var locals={error:err};return[locals,entity.id];}}
function formatValue(args,entity){if(typeof entity==='string'){return entity;}
return formatTuple.call(this,args,entity)[1];}
function formatEntity(args,entity){var rv=formatTuple.call(this,args,entity);var locals=rv[0];var value=rv[1];var formatted={value:value,attrs:null,overlay:locals.overlay};if(entity.attrs){formatted.attrs=Object.create(null);}
for(var key in entity.attrs){formatted.attrs[key]=formatValue.call(this,args,entity.attrs[key]);}
return formatted;}
function formatAsync(fn,id,args){return this._ready.then(getWithFallback.bind(this,id)).then(fn.bind(this,args),reportMissing.bind(this,id));}
Context.prototype.formatValue=function(id,args){return formatAsync.call(this,formatValue,id,args);};Context.prototype.formatEntity=function(id,args){return formatAsync.call(this,formatEntity,id,args);};function legacyGet(fn,id,args){if(!this.isReady){throw new L10nError('Context not ready');}
var entry;try{entry=getWithFallback.call(this,id);}catch(err){if(err.loc){throw err;}
reportMissing.call(this,id,err);return'';}
return fn.call(this,args,entry);}
Context.prototype.get=function(id,args){return legacyGet.call(this,formatValue,id,args);};Context.prototype.getEntity=function(id,args){return legacyGet.call(this,formatEntity,id,args);};Context.prototype.getLocale=function getLocale(code){var locales=this.locales;if(locales[code]){return locales[code];}
return locales[code]=new Locale(code,this);};function negotiate(available,requested,defaultLocale){if(available.indexOf(requested[0])===-1||requested[0]===defaultLocale){return[defaultLocale];}else{return[requested[0],defaultLocale];}}
function freeze(supported){var locale=this.getLocale(supported[0]);if(locale.isReady){setReady.call(this,supported);}else{locale.build(setReady.bind(this,supported));}}
function setReady(supported){this.supportedLocales=supported;this.isReady=true;this._emitter.emit('ready');}
Context.prototype.registerLocales=function(defLocale,available){if(defLocale){this.defaultLocale=defLocale;}
this.availableLocales=[this.defaultLocale];if(available){for(var i=0,loc;loc=available[i];i++){if(this.availableLocales.indexOf(loc)===-1){this.availableLocales.push(loc);}}}};Context.prototype.requestLocales=function requestLocales(){if(this.isLoading&&!this.isReady){throw new L10nError('Context not ready');}
this.isLoading=true;var requested=Array.prototype.slice.call(arguments);if(requested.length===0){throw new L10nError('No locales requested');}
var reqPseudo=requested.filter(function(loc){return loc in PSEUDO_STRATEGIES;});var supported=negotiate(this.availableLocales.concat(reqPseudo),requested,this.defaultLocale);freeze.call(this,supported);};Context.prototype.addEventListener=function(type,listener){this._emitter.addEventListener(type,listener);};Context.prototype.removeEventListener=function(type,listener){this._emitter.removeEventListener(type,listener);};Context.prototype.ready=function(callback){if(this.isReady){setTimeout(callback);}
this.addEventListener('ready',callback);};Context.prototype.once=function(callback){if(this.isReady){setTimeout(callback);return;}
var callAndRemove=(function(){this.removeEventListener('ready',callAndRemove);callback();}).bind(this);this.addEventListener('ready',callAndRemove);};var allowed={elements:['a','em','strong','small','s','cite','q','dfn','abbr','data','time','code','var','samp','kbd','sub','sup','i','b','u','mark','ruby','rt','rp','bdi','bdo','span','br','wbr'],attributes:{global:['title','aria-label','aria-valuetext','aria-moz-hint'],a:['download'],area:['download','alt'],input:['alt','placeholder'],menuitem:['label'],menu:['label'],optgroup:['label'],option:['label'],track:['label'],img:['alt'],textarea:['placeholder'],th:['abbr']}};var DEBUG=false;var isPretranslated=false;var rtlList=['ar','he','fa','ps','qps-plocm','ur'];var nodeObserver=null;var pendingElements=null;var moConfig={attributes:true,characterData:false,childList:true,subtree:true,attributeFilter:['data-l10n-id','data-l10n-args']};navigator.mozL10n={ctx:new Context(window.document?document.URL:null),get:function get(id,ctxdata){return navigator.mozL10n.ctx.get(id,ctxdata);},formatValue:function(id,ctxdata){return navigator.mozL10n.ctx.formatValue(id,ctxdata);},formatEntity:function(id,ctxdata){return navigator.mozL10n.ctx.formatEntity(id,ctxdata);},translateFragment:function(fragment){return translateFragment.call(navigator.mozL10n,fragment);},setAttributes:setL10nAttributes,getAttributes:getL10nAttributes,ready:function ready(callback){return navigator.mozL10n.ctx.ready(callback);},once:function once(callback){return navigator.mozL10n.ctx.once(callback);},get readyState(){return navigator.mozL10n.ctx.isReady?'complete':'loading';},language:{set code(lang){navigator.mozL10n.ctx.requestLocales(lang);},get code(){return navigator.mozL10n.ctx.supportedLocales[0];},get direction(){return getDirection(navigator.mozL10n.ctx.supportedLocales[0]);}},qps:PSEUDO_STRATEGIES,_config:{appVersion:null,localeSources:Object.create(null),},_getInternalAPI:function(){return{Error:L10nError,Context:Context,Locale:Locale,Resolver:Resolver,getPluralRule:getPluralRule,rePlaceables:rePlaceables,translateDocument:translateDocument,onMetaInjected:onMetaInjected,PropertiesParser:PropertiesParser,walkContent:walkContent,buildLocaleList:buildLocaleList};}};navigator.mozL10n.ctx.ready(onReady.bind(navigator.mozL10n));navigator.mozL10n.ctx.addEventListener('notfounderror',function reportMissingEntity(e){if(DEBUG||e.loc==='en-US'){console.warn(e.toString());}});if(DEBUG){navigator.mozL10n.ctx.addEventListener('fetcherror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('parseerror',console.error.bind(console));navigator.mozL10n.ctx.addEventListener('resolveerror',console.error.bind(console));}
function getDirection(lang){return(rtlList.indexOf(lang)>=0)?'rtl':'ltr';}
var readyStates={'loading':0,'interactive':1,'complete':2};function waitFor(state,callback){state=readyStates[state];if(readyStates[document.readyState]>=state){callback();return;}
document.addEventListener('readystatechange',function l10n_onrsc(){if(readyStates[document.readyState]>=state){document.removeEventListener('readystatechange',l10n_onrsc);callback();}});}
if(window.document){isPretranslated=!PSEUDO_STRATEGIES.hasOwnProperty(navigator.language)&&(document.documentElement.lang===navigator.language);var pretranslate=document.documentElement.dataset.noCompleteBug?true:!isPretranslated;waitFor('interactive',init.bind(navigator.mozL10n,pretranslate));}
function initObserver(){nodeObserver=new MutationObserver(onMutations.bind(navigator.mozL10n));nodeObserver.observe(document,moConfig);}
function init(pretranslate){if(pretranslate){initResources.call(navigator.mozL10n);}else{initObserver();window.setTimeout(initResources.bind(navigator.mozL10n));}}
function initResources(){var meta={};var nodes=document.head.querySelectorAll('link[rel="localization"],'+'meta[name="availableLanguages"],'+'meta[name="defaultLanguage"],'+'meta[name="appVersion"],'+'script[type="application/l10n"]');for(var i=0,node;node=nodes[i];i++){var type=node.getAttribute('rel')||node.nodeName.toLowerCase();switch(type){case'localization':this.ctx.resLinks.push(node.getAttribute('href'));break;case'meta':onMetaInjected.call(this,node,meta);break;case'script':onScriptInjected.call(this,node);break;}}
var additionalLanguagesPromise;if(navigator.mozApps&&navigator.mozApps.getAdditionalLanguages){additionalLanguagesPromise=navigator.mozApps.getAdditionalLanguages().catch(function(e){console.error('Error while loading getAdditionalLanguages',e);});document.addEventListener('additionallanguageschange',function(evt){registerLocales.call(this,meta,evt.detail);}.bind(this));}else{additionalLanguagesPromise=Promise.resolve();}
additionalLanguagesPromise.then(function(extraLangs){registerLocales.call(this,meta,extraLangs);initLocale.call(this);}.bind(this));}
function registerLocales(meta,extraLangs){var locales=buildLocaleList.call(this,meta,extraLangs);navigator.mozL10n._config.localeSources=locales[1];this.ctx.registerLocales(locales[0],Object.keys(locales[1]));}
function getMatchingLangpack(appVersion,langpacks){for(var i=0,langpack;(langpack=langpacks[i]);i++){if(langpack.target===appVersion){return langpack;}}
return null;}
function buildLocaleList(meta,extraLangs){var loc,lp;var localeSources=Object.create(null);var defaultLocale=meta.defaultLocale||this.ctx.defaultLocale;if(meta.availableLanguages){for(loc in meta.availableLanguages){localeSources[loc]='app';}}
if(extraLangs){for(loc in extraLangs){lp=getMatchingLangpack(this._config.appVersion,extraLangs[loc]);if(!lp){continue;}
if(!(loc in localeSources)||!meta.availableLanguages[loc]||parseInt(lp.revision)>meta.availableLanguages[loc]){localeSources[loc]='extra';}}}
if(!(defaultLocale in localeSources)){localeSources[defaultLocale]='app';}
return[defaultLocale,localeSources];}
function splitAvailableLanguagesString(str){var langs={};str.split(',').forEach(function(lang){lang=lang.trim().split(':');langs[lang[0]]=parseInt(lang[1]);});return langs;}
function onMetaInjected(node,meta){switch(node.getAttribute('name')){case'availableLanguages':meta.availableLanguages=splitAvailableLanguagesString(node.getAttribute('content'));break;case'defaultLanguage':meta.defaultLanguage=node.getAttribute('content');break;case'appVersion':navigator.mozL10n._config.appVersion=node.getAttribute('content');break;}}
function onScriptInjected(node){var lang=node.getAttribute('lang');var locale=this.ctx.getLocale(lang);locale.addAST(JSON.parse(node.textContent));}
function initLocale(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);window.addEventListener('languagechange',function l10n_langchange(){this.ctx.requestLocales.apply(this.ctx,navigator.languages||[navigator.language]);}.bind(this));}
function localizeMutations(mutations){var mutation;var targets=new Set();for(var i=0;i<mutations.length;i++){mutation=mutations[i];if(mutation.type==='childList'){var addedNode;for(var j=0;j<mutation.addedNodes.length;j++){addedNode=mutation.addedNodes[j];if(addedNode.nodeType!==Node.ELEMENT_NODE){continue;}
targets.add(addedNode);}}
if(mutation.type==='attributes'){targets.add(mutation.target);}}
targets.forEach(function(target){if(target.childElementCount){translateFragment.call(this,target);}else if(target.hasAttribute('data-l10n-id')){translateElement.call(this,target);}},this);}
function onMutations(mutations,self){self.disconnect();localizeMutations.call(this,mutations);self.observe(document,moConfig);}
function onReady(){if(!isPretranslated){translateDocument.call(this);}
isPretranslated=false;if(pendingElements){for(var i=0,element;element=pendingElements[i];i++){translateElement.call(this,element);}
pendingElements=null;}
if(!nodeObserver){initObserver();}
fireLocalizedEvent.call(this);}
function fireLocalizedEvent(){var event=new CustomEvent('localized',{'bubbles':false,'cancelable':false,'detail':{'language':this.ctx.supportedLocales[0]}});window.dispatchEvent(event);}
function translateDocument(){document.documentElement.lang=this.language.code;document.documentElement.dir=this.language.direction;translateFragment.call(this,document.documentElement);}
function translateFragment(element){if(element.hasAttribute('data-l10n-id')){translateElement.call(this,element);}
var nodes=getTranslatableChildren(element);for(var i=0;i<nodes.length;i++){translateElement.call(this,nodes[i]);}}
function setL10nAttributes(element,id,args){element.setAttribute('data-l10n-id',id);if(args){element.setAttribute('data-l10n-args',JSON.stringify(args));}}
function getL10nAttributes(element){return{id:element.getAttribute('data-l10n-id'),args:JSON.parse(element.getAttribute('data-l10n-args'))};}
function getTranslatableChildren(element){return element?element.querySelectorAll('*[data-l10n-id]'):[];}
function camelCaseToDashed(string){if(string==='ariaValueText'){return'aria-valuetext';}
return string.replace(/[A-Z]/g,function(match){return'-'+match.toLowerCase();}).replace(/^-/,'');}
function translateElement(element){if(!this.ctx.isReady){if(!pendingElements){pendingElements=[];}
pendingElements.push(element);return;}
var l10n=getL10nAttributes(element);if(!l10n.id){return false;}
var entity=this.ctx.getEntity(l10n.id,l10n.args);if(typeof entity.value==='string'){if(!entity.overlay){element.textContent=entity.value;}else{var translation=element.ownerDocument.createElement('template');translation.innerHTML=entity.value;overlayElement(element,translation.content);}}
for(var key in entity.attrs){if(key==='innerHTML'){element.innerHTML=entity.attrs[key];continue;}
var attrName=camelCaseToDashed(key);if(isAttrAllowed({name:attrName},element)){element.setAttribute(attrName,entity.attrs[key]);}}}
function overlayElement(sourceElement,translationElement){var result=translationElement.ownerDocument.createDocumentFragment();var k,attr;var childElement;while((childElement=translationElement.childNodes[0])){translationElement.removeChild(childElement);if(childElement.nodeType===Node.TEXT_NODE){result.appendChild(childElement);continue;}
var index=getIndexOfType(childElement);var sourceChild=getNthElementOfType(sourceElement,childElement,index);if(sourceChild){overlayElement(sourceChild,childElement);result.appendChild(sourceChild);continue;}
if(isElementAllowed(childElement)){const sanitizedChild=childElement.ownerDocument.createElement(childElement.nodeName);overlayElement(sanitizedChild,childElement);result.appendChild(sanitizedChild);continue;}
result.appendChild(document.createTextNode(childElement.textContent));}
sourceElement.textContent='';sourceElement.appendChild(result);if(translationElement.attributes){for(k=0,attr;(attr=translationElement.attributes[k]);k++){if(isAttrAllowed(attr,sourceElement)){sourceElement.setAttribute(attr.name,attr.value);}}}}
function isElementAllowed(element){return allowed.elements.indexOf(element.tagName.toLowerCase())!==-1;}
function isAttrAllowed(attr,element){var attrName=attr.name.toLowerCase();var tagName=element.tagName.toLowerCase();if(allowed.attributes.global.indexOf(attrName)!==-1){return true;}
if(!allowed.attributes[tagName]){return false;}
if(allowed.attributes[tagName].indexOf(attrName)!==-1){return true;}
if(tagName==='input'&&attrName==='value'){var type=element.type.toLowerCase();if(type==='submit'||type==='button'||type==='reset'){return true;}}
return false;}
function getNthElementOfType(context,element,index){var nthOfType=0;for(var i=0,child;child=context.children[i];i++){if(child.nodeType===Node.ELEMENT_NODE&&child.tagName===element.tagName){if(nthOfType===index){return child;}
nthOfType++;}}
return null;}
function getIndexOfType(element){var index=0;var child;while((child=element.previousElementSibling)){if(child.tagName===element.tagName){index++;}}
return index;}})(this);;'use strict';var LazyLoader=(function(){function LazyLoader(){this._loaded={};this._isLoading={};}
LazyLoader.prototype={_js:function(file,callback){var script=document.createElement('script');script.src=file;script.async=false;script.addEventListener('load',callback);document.head.appendChild(script);this._isLoading[file]=script;},_css:function(file,callback){var style=document.createElement('link');style.type='text/css';style.rel='stylesheet';style.href=file;document.head.appendChild(style);callback();},_html:function(domNode,callback){if(domNode.getAttribute('is')){this.load(['/shared/js/html_imports.js'],function(){HtmlImports.populate(callback);}.bind(this));return;}
for(var i=0;i<domNode.childNodes.length;i++){if(domNode.childNodes[i].nodeType==document.COMMENT_NODE){domNode.innerHTML=domNode.childNodes[i].nodeValue;break;}}
window.dispatchEvent(new CustomEvent('lazyload',{detail:domNode}));callback();},getJSON:function(file,mozSystem){return new Promise(function(resolve,reject){var xhr;if(mozSystem){xhr=new XMLHttpRequest({mozSystem:true});}else{xhr=new XMLHttpRequest();}
xhr.open('GET',file,true);xhr.responseType='json';xhr.onerror=function(error){reject(error);};xhr.onload=function(){if(xhr.response!==null){resolve(xhr.response);}else{reject(new Error('No valid JSON object was found ('+
xhr.status+' '+xhr.statusText+')'));}};xhr.send();});},load:function(files,callback){var deferred={};deferred.promise=new Promise(resolve=>{deferred.resolve=resolve;});if(!Array.isArray(files)){files=[files];}
var loadsRemaining=files.length,self=this;function perFileCallback(file){if(self._isLoading[file]){delete self._isLoading[file];}
self._loaded[file]=true;if(--loadsRemaining===0){deferred.resolve();if(callback){callback();}}}
for(var i=0;i<files.length;i++){var file=files[i];if(this._loaded[file.id||file]){perFileCallback(file);}else if(this._isLoading[file]){this._isLoading[file].addEventListener('load',perFileCallback.bind(null,file));}else{var method,idx;if(typeof file==='string'){method=file.match(/\.([^.]+)$/)[1];idx=file;}else{method='html';idx=file.id;}
this['_'+method](file,perFileCallback.bind(null,idx));}}
return deferred.promise;}};return new LazyLoader();}());;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;var DateHelper={todayStarted:function dh_todayStarted(){var now=(new Date()).valueOf();return this.getMidnight(now);},yesterdayStarted:function dh_yesterdayStarted(){var now=(new Date()).valueOf();var dayAgo=now-86400000;return this.getMidnight(dayAgo);},thisWeekStarted:function dh_thisWeekStarted(){var now=new Date();var dayOfTheWeek=now.getDay();var firstDay=new Date(now.getFullYear(),now.getMonth(),now.getDate()-dayOfTheWeek);return this.getMidnight(firstDay);},thisMonthStarted:function dh_thisMonthStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),now.getMonth(),1).valueOf());return firstDay;},lastSixMonthsStarted:function dh_lastSixMonthsStarted(){var now=new Date().valueOf();var sixMonthsAgo=now-2629743830*6;return sixMonthsAgo;},thisYearStarted:function dh_thisYearStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),0).valueOf());return firstDay;},getMidnight:function dh_getMidnight(timestamp){var day=new Date(timestamp);var midnight=(new Date(day.getFullYear(),day.getMonth(),day.getDate(),0).valueOf());return midnight;}};var NumberHelper={zfill:function nh_zfill(string,len){var s=string;while(s.length<len)s='0'+s;return s;}};var HtmlHelper={createHighlightHTML:function ut_createHighlightHTML(text,searchRegExp){if(!searchRegExp){return this.escapeHTML(text);}
searchRegExp=new RegExp(searchRegExp,'gi');var sliceStrs=text.split(searchRegExp);var patterns=text.match(searchRegExp);if(!patterns){return this.escapeHTML(text);}
var str='';for(var i=0;i<patterns.length;i++){str=str+
this.escapeHTML(sliceStrs[i])+'<span class="highlight">'+
this.escapeHTML(patterns[i])+'</span>';}
str+=this.escapeHTML(sliceStrs.pop());return str;},escapeHTML:function ut_escapeHTML(str,escapeQuotes){var span=document.createElement('span');span.textContent=str;span.innerHTML=span.innerHTML.replace(/\s/g,'&nbsp;');if(escapeQuotes)
return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return span.innerHTML;},importElements:function importElements(context){var ids=[].slice.call(arguments,1);ids.forEach(function(id){context[StringHelper.camelCase(id)]=document.getElementById(id);});}};var StringHelper={fromUTF8:function ut_fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;},camelCase:function ut_camelCase(str){var rdashes=/-(.)/g;return str.replace(rdashes,function replacer(str,p1){return p1.toUpperCase();});}};;'use strict';var SettingsListener={_timer:null,_lock:null,_observers:[],getSettingsLock:function sl_getSettingsLock(){if(this._lock&&!this._lock.closed){return this._lock;}
var settings=window.navigator.mozSettings;return(this._lock=settings.createLock());},observe:function sl_observe(name,defaultValue,callback){var settings=window.navigator.mozSettings;if(!settings){window.setTimeout(function(){callback(defaultValue);});return;}
var req;try{req=this.getSettingsLock().get(name);}catch(e){console.warn('Stale lock in settings_listener.js.','See https://bugzilla.mozilla.org/show_bug.cgi?id=793239');this._lock=null;req=this.getSettingsLock().get(name);}
req.addEventListener('success',(function onsuccess(){callback(typeof(req.result[name])!='undefined'?req.result[name]:defaultValue);}));var settingChanged=function settingChanged(evt){callback(evt.settingValue);};settings.addObserver(name,settingChanged);this._observers.push({name:name,callback:callback,observer:settingChanged});},unobserve:function sl_unobserve(name,callback){var settings=window.navigator.mozSettings;var that=this;this._observers.forEach(function(value,index){if(value.name===name&&value.callback===callback){settings.removeObserver(name,value.observer);that._observers.splice(index,1);}});}};;'use strict';var Format={padLeft:function(input,len,padWith){padWith=padWith||' ';var pad=len-(input+'').length;while(--pad>-1){input=padWith+input;}
return input;}};;'use strict';(function(exports){var VERSION=3;var SEARCH_CACHE_KEY='search.cache';var SEARCH_PROVIDER_KEY='search.provider';var DEFAULT_PROVIDERS_URL='/shared/js/search_providers.json';var provider=null;var providers={};var defaultEngine=null;var updatedFun;var readyPromise;var resolver;function extend(dest,source){for(var k in source){if(source.hasOwnProperty(k)){var value=source[k];if(dest.hasOwnProperty(k)&&typeof dest[k]==='object'&&typeof value==='object'){extend(dest[k],value);}else{dest[k]=value;}}}
return dest;}
function resolveUrl(urlConf){var params=Object.keys(urlConf.params).map(function(k){return k+'='+urlConf.params[k];}).join('&');return urlConf.url+(params?'?'+params:'');}
function loadProviderConfig(){LazyLoader.getJSON(DEFAULT_PROVIDERS_URL).then(result=>{var conns=navigator.mozMobileConnections||[];var mccs=Array.prototype.slice.call(conns).map(function(conn){if(conn.voice&&conn.voice.network){return Format.padLeft(conn.voice.network.mcc,3,'0')+'-'+
Format.padLeft(conn.voice.network.mnc,3,'0');}});var engines=SearchProvider.pickEngines(result,mccs,result.partner_code||null,navigator.language);defaultEngine=engines.defaultEngine;providers=engines.providers;var cache={};cache[SEARCH_CACHE_KEY]={};cache[SEARCH_CACHE_KEY].defaultEngine=defaultEngine;cache[SEARCH_CACHE_KEY].providers=providers;cache[SEARCH_CACHE_KEY].version=VERSION;navigator.mozSettings.createLock().set(cache);providersLoaded();});}
function providersLoaded(){SettingsListener.observe(SEARCH_PROVIDER_KEY,false,value=>{if(value===false||!(value in providers)){provider=defaultEngine;}else{provider=value;}
if(resolver&&isReady()){resolver();resolver=null;}
if(updatedFun){updatedFun();}});}
function isReady(){return provider!==null&&Object.keys(providers).length;}
var SearchProvider=function(key){if(!provider||!(key in providers[provider])){return false;}
return providers[provider][key];};SearchProvider.providerUpdated=function(cb){updatedFun=cb;};SearchProvider.setProvider=function(value){if(!(value in providers)){return false;}
var setting={};setting[SEARCH_PROVIDER_KEY]=value;navigator.mozSettings.createLock().set(setting);};SearchProvider.selected=function(){return provider;};SearchProvider.providers=function(){return providers;};SearchProvider.pickEngines=function(config,sims,partnerCode,locale){config=JSON.parse(JSON.stringify(config));var engine=config.defaultEngines;var usersConfig={defaultEngine:null,providers:{}};if(partnerCode in config.partnerConfig&&locale in config.partnerConfig[partnerCode]){engine=config.partnerConfig[partnerCode][locale];}
sims.forEach(function(sim){if(sim in config.simConfigs&&locale in config.simConfigs[sim]){engine=config.simConfigs[sim][locale];}});usersConfig.defaultEngine=engine.defaultEngine;Object.keys(engine.providers).forEach(function(provider){var obj=config.search_providers[provider];if(locale in config.locales&&provider in config.locales[locale]){obj=extend(obj,config.locales[locale][provider]);}
obj=extend(obj,engine.providers[provider]);usersConfig.providers[provider]={'title':obj.title,'searchUrl':resolveUrl(obj.search),'suggestUrl':resolveUrl(obj.suggest)};});return usersConfig;};SearchProvider.ready=function(){if(readyPromise){return readyPromise;}
var req=navigator.mozSettings.createLock().get(SEARCH_CACHE_KEY);req.onsuccess=function(){if(SEARCH_CACHE_KEY in req.result&&req.result[SEARCH_CACHE_KEY].version===VERSION){defaultEngine=req.result[SEARCH_CACHE_KEY].defaultEngine;providers=req.result[SEARCH_CACHE_KEY].providers;providersLoaded();}else{loadProviderConfig();}};readyPromise=new Promise(resolve=>{resolver=resolve;});return readyPromise;};exports.SearchProvider=SearchProvider;})(window);;(function(exports){'use strict';exports.ComponentUtils={style:function(baseUrl){var style=document.createElement('style');var url=baseUrl+'style.css';var self=this;style.setAttribute('scoped','');style.innerHTML='@import url('+url+');';this.appendChild(style);this.style.visibility='hidden';style.addEventListener('load',function(){if(self.shadowRoot){self.shadowRoot.appendChild(style.cloneNode(true));}
self.style.visibility='';});}};}(window));;'use strict';window.GaiaButtons=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaButtonsBaseurl||'/shared/elements/gaia_buttons/';proto.createdCallback=function(){ComponentUtils.style.call(this,baseurl);};return document.registerElement('gaia-buttons',{prototype:proto});})(window);;'use strict';window.GaiaConfirm=(function(win){var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaConfirmBaseurl||'/shared/elements/gaia_confirm/';var EATEN_EVENTS=['touchmove'];function eatEvent(unless,event){if(unless&&unless.indexOf(event.target)!==-1){return;}
event.preventDefault();event.stopImmediatePropagation();}
proto.createdCallback=function(){var shadow=this.createShadowRoot();this._template=template.content.cloneNode(true);shadow.appendChild(this._template);ComponentUtils.style.call(this,baseurl);var confirm=this.querySelector('gaia-buttons .confirm');var cancel=this.querySelector('gaia-buttons .cancel');var allowedTargets=[confirm,cancel].filter(function(element){return!!element;});EATEN_EVENTS.forEach(function(type){this.addEventListener(type,(event)=>{eatEvent(allowedTargets,event);});},this);if(confirm){confirm.addEventListener('click',(e)=>{eatEvent(null,e);this.dispatchEvent(new CustomEvent('confirm'));});}
if(cancel){cancel.addEventListener('click',(e)=>{eatEvent(null,e);this.dispatchEvent(new CustomEvent('cancel'));});}};var template=document.createElement('template');template.innerHTML=`<form role="dialog" class="confirm">
      <section>
        <content select="h1"></content>
        <content select="p"></content>
      </section>
      <content select="gaia-buttons">
      </content>
    </form>`;return document.registerElement('gaia-confirm',{prototype:proto});})(window);;'use strict';(function(exports){var datastore;var DATASTORE_NAME='vertical_preferences_store';var readyState;var listeners=Object.create(null);function init(){return new Promise(function doInit(resolve,reject){if(readyState==='initialized'){resolve();return;}
if(readyState==='initializing'){document.addEventListener('vps-initialized',function oninitalized(){document.removeEventListener('vps-initialized',oninitalized);resolve();});return;}
readyState='initializing';if(!navigator.getDataStores){console.error('Preferences store: DataStore API is not working');reject({name:'NO_DATASTORE'});readyState='failed';return;}
navigator.getDataStores(DATASTORE_NAME).then(function(ds){if(ds.length<1){console.error('Preferences store: Cannot get access to the Store');reject({name:'NO_ACCESS_TO_DATASTORE'});readyState='failed';return;}
datastore=ds[0];datastore.addEventListener('change',onchangeHandler);readyState='initialized';document.dispatchEvent(new CustomEvent('vps-initialized'));resolve();},reject);});}
function onchangeHandler(event){var operation=event.operation;var callbacks=listeners[operation];callbacks&&callbacks.forEach(function iterCallback(callback){datastore.get(event.id).then(function got(result){callback.method.call(callback.context||this,{type:operation,target:{name:event.id,value:result}});});});}
function addEventListener(type,callback){var context;if(!(type in listeners)){listeners[type]=[];}
var cb=callback;if(typeof cb==='object'){context=cb;cb=cb.handleEvent;}
if(cb){listeners[type].push({method:cb,context:context});init();}}
function removeEventListener(type,callback){if(!(type in listeners)){return false;}
var callbacks=listeners[type];var length=callbacks.length;for(var i=0;i<length;i++){var thisCallback=callback;if(typeof thisCallback==='object'){thisCallback=callback.handleEvent;}
if(callbacks[i]&&callbacks[i].method===thisCallback){callbacks.splice(i,1);return true;}}
return false;}
function get(id){return new Promise(function doGet(resolve,reject){init().then(function onInitialized(){datastore.get(id).then(resolve,reject);},reject);});}
function put(id,value){return new Promise(function doAdd(resolve,reject){init().then(function onInitialized(){datastore.put(value,id).then(function success(){resolve();},reject);},reject);});}
exports.verticalPreferences={get:get,put:put,addEventListener:addEventListener,removeEventListener:removeEventListener};}(window));;(function(exports){'use strict';var resources=['/shared/js/component_utils.js','/shared/elements/gaia_buttons/script.js','/shared/elements/gaia_confirm/script.js','/shared/elements/gaia_menu/script.js'];function ConfirmDialogHelper(config){this.config=config;}
ConfirmDialogHelper.prototype={show:function(parent){LazyLoader.load(resources,this._show.bind(this,parent));},_show:function(parent){var config=this.config;var wrapper=document.createElement('div');var cancelButton=config.cancel?'<button class="cancel" type="button"></button>':'';wrapper.innerHTML='<gaia-confirm>'+'<h1></h1>'+'<p></p>'+'<gaia-buttons skin="dark">'+
cancelButton+'<button class="confirm" type="button"></button>'+'</gaia-buttons>'+'</gaia-confirm>';var element=wrapper.firstElementChild;this.element=element;element.dataset.type=config.type;element.addEventListener('confirm',this);element.addEventListener('cancel',this);window.addEventListener('hashchange',this);var title=element.querySelector('h1');var body=element.querySelector('p');var cancel=element.querySelector('.cancel');var confirm=element.querySelector('.confirm');var setL10nAttributes=function(element,options){if('string'===typeof options){navigator.mozL10n.setAttributes(element,options);}
if(options.id){navigator.mozL10n.setAttributes(element,options.id,options.args);}};setL10nAttributes(title,config.title);setL10nAttributes(body,config.body);setL10nAttributes(confirm,config.confirm.title);if(config.cancel){setL10nAttributes(cancel,config.cancel.title);}
if(config.confirm.type){confirm.classList.add(config.confirm.type);}
document.activeElement.blur();element.setAttribute('hidden','');parent.appendChild(element);window.requestAnimationFrame(()=>{window.requestAnimationFrame(()=>{element.removeAttribute('hidden');window.dispatchEvent(new CustomEvent('gaia-confirm-open'));});});},destroy:function(){if(!this.element){return;}
window.removeEventListener('hashchange',this);this.element.addEventListener('transitionend',function removeAfterHide(e){if(e.target!==this.element){return;}
this.element.parentNode.removeChild(this.element);this.element=null;window.dispatchEvent(new CustomEvent('gaia-confirm-close'));}.bind(this));this.element.setAttribute('hidden','');},handleEvent:function(e){this.destroy();switch(e.type){case'hashchange':break;case'confirm':var confirm=this.config.confirm.cb;confirm&&confirm();break;case'cancel':var cancel=this.config.cancel.cb;cancel&&cancel();break;}}};window.ConfirmDialogHelper=ConfirmDialogHelper;}(window));;'use strict';(function(exports){const APP_LAUNCH_TIMEOUT=3000;function GridView(config){this.config=config;this.clickIcon=this.clickIcon.bind(this);this.onVisibilityChange=this.onVisibilityChange.bind(this);this.onCollectionLaunch=this.onCollectionLaunch.bind(this);this.onCollectionClose=this.onCollectionClose.bind(this);if(config.features.zoom){this.zoom=new GridZoom(this);}
this.layout=new GridLayout(this);if(config.element.hasAttribute('cols')){this.layout.cols=parseInt(config.element.getAttribute('cols'),10);}
this.start();}
GridView.prototype={icons:{},items:[],get element(){return this.config.element;},set cols(value){this.layout.cols=value;},_launchingApp:false,_collectionOpen:false,add:function(item,insertTo,expandGroup){if(!item){return;}
if(item.identifier){if(this.icons[item.identifier]){console.log('Error, duplicate identifier: ',item.identifier,new Error().stack);return;}
this.icons[item.identifier]=item;}else if(item.detail.type!=='divider'&&item.detail.type!=='placeholder'){console.log('Error, could not load identifier for object: ',JSON.stringify(item.detail));return;}
if(!isNaN(parseFloat(insertTo))&&isFinite(insertTo)){this.items.splice(insertTo,0,item);}else{insertTo=this.items.length;this.items.push(item);}
if(expandGroup){for(var i=insertTo+1,iLen=this.items.length;i<iLen;i++){var divider=this.items[i];if(divider.detail.type==='divider'){if(divider.detail.collapsed){divider.expand();}
break;}}}},getNearestItemIndex:function(x,y,isRow){var foundIndex=null;var leastDistance=null;var itemMiddleOffset=this.layout.gridItemWidth/2;for(var i=0,iLen=this.items.length;i<iLen;i++){var item=this.items[i];if(!item.isDraggable()){continue;}
if(this.config.features.disableSections&&item.detail.type==='divider'){continue;}
if(item.detail.type!=='divider'&&item.element.classList.contains('collapsed')){continue;}
var middleX=item.x+itemMiddleOffset;var middleY=item.y+item.pixelHeight/2;var xDistance=(isRow||item.detail.type==='divider')?0:x-middleX;var yDistance=y-middleY;var distance=Math.sqrt(xDistance*xDistance+
yDistance*yDistance);if(leastDistance===null||distance<leastDistance){leastDistance=distance;foundIndex=i;}}
return foundIndex;},start:function(){this.element.addEventListener('click',this.clickIcon);this.element.addEventListener('collection-launch',this.onCollectionLaunch);this.element.addEventListener('collection-close',this.onCollectionClose);window.addEventListener('visibilitychange',this.onVisibilityChange);},stop:function(){this.element.removeEventListener('click',this.clickIcon);this.element.removeEventListener('collection-launch',this.onCollectionLaunch);this.element.removeEventListener('collection-close',this.onCollectionClose);window.removeEventListener('visibilitychange',this.onVisibilityChange);},findItemFromElement:function(element,excludeCollapsedIcons){while(element&&element.parentNode!==this.element){element=element.parentNode;}
if(!element){return null;}
var i,iLen=this.items.length;var identifier=element.dataset.identifier;var icon=this.icons[identifier];if(!icon){for(i=0;i<iLen;i++){if(this.items[i].element===element){icon=this.items[i];break;}}}
if(icon&&excludeCollapsedIcons){if(icon.detail.type!=='divider'&&icon.detail.type!=='placeholder'&&icon.element.classList.contains('collapsed')){for(i=icon.detail.index+1;i<iLen;i++){if(this.items[i].detail.type==='divider'){return this.items[i];}}
console.warn('Collapsed icon found with no group');icon=null;}}
return icon;},onVisibilityChange:function(){this._launchingApp=false;},onCollectionLaunch:function(){this._collectionOpen=true;},onCollectionClose:function(){this._collectionOpen=false;},clickIcon:function(e){e.preventDefault();var inEditMode=this.dragdrop&&this.dragdrop.inEditMode;var action='launch';if(e.target.classList.contains('remove')){action='remove';}
var icon=this.findItemFromElement(e.target);if(!icon){return;}
if(action==='launch'){if(inEditMode&&e.target.classList.contains('icon')){if(!icon.isEditable()){return;}
action='edit';}else{if(!icon[action]){return;}
icon.element.classList.add('launching');var returnTimeout=500;setTimeout(function stateReturn(){if(icon.element){icon.element.classList.remove('launching');}},returnTimeout);}}
if((icon.detail.type==='app'||icon.detail.type==='bookmark')&&this._launchingApp){return;}
if((icon.detail.type==='app'&&icon.appState==='ready')||icon.detail.type==='bookmark'){this._launchingApp=true;if(this._launchingTimeout){window.clearTimeout(this._launchingTimeout);this._launchingTimeout=null;}
this._launchingTimeout=window.setTimeout(function(){this._launchingTimeout=null;this._launchingApp=false;}.bind(this),APP_LAUNCH_TIMEOUT);}
icon[action](e.target);},cleanItems:function(skipDivider){var appCount=0;var toRemove=[];this.items.forEach(function(item,idx){if(item instanceof GaiaGrid.Divider){if(appCount===0){toRemove.push(idx);}
appCount=0;}else{appCount++;}},this);toRemove.reverse();toRemove.forEach(function(idx){var removed=this.items.splice(idx,1)[0];removed.remove();},this);if(skipDivider){return;}
var lastItem=this.items[this.items.length-1];if(!lastItem||!(lastItem instanceof GaiaGrid.Divider)){this.items.push(new GaiaGrid.Divider());}},removeAllPlaceholders:function(){var toSplice=[];var previousItem;this.items.forEach(function(item,idx){if(item instanceof GaiaGrid.Placeholder){if((!previousItem||(previousItem&&previousItem instanceof GaiaGrid.Divider))&&this.dragdrop&&this.dragdrop.inDragAction){return;}
toSplice.push(idx);}
previousItem=item;},this);toSplice.reverse().forEach(function(idx){this.items.splice(idx,1)[0].remove();},this);},clear:function(){for(var i=0,iLen=this.items.length;i<iLen;i++){var item=this.items[i];if(item.element){this.element.removeChild(item.element);item.element=null;item.lastX=null;item.lastY=null;item.lastScale=null;}}
this.items=[];this.icons={};},createPlaceholders:function(coordinates,idx,count){var isRTL=(document.documentElement.dir==='rtl');for(var i=0;i<count;i++){var item=new GaiaGrid.Placeholder();this.items.splice(idx+i,0,item);item.setPosition(idx+i);var xPosition=(coordinates[0]+i)*this.layout.gridItemWidth;if(isRTL){xPosition=(this.layout.constraintSize-this.layout.gridItemWidth)-
xPosition;}
item.setCoordinates(xPosition,this.layout.offsetY);item.render();}},render:function(options){var self=this;options=options||{};this.removeAllPlaceholders();this.cleanItems(options.skipDivider);var oldHeight=this.layout.offsetY;this.layout.offsetY=0;var x=0;var y=0;function step(item){var pixelHeight=item.pixelHeight;self.layout.stepYAxis(pixelHeight);x=0;y++;}
var pendingCachedIcons=0;var onCachedIconRendered=()=>{if(--pendingCachedIcons<=0){this.element.removeEventListener('cached-icon-rendered',onCachedIconRendered);this.element.dispatchEvent(new CustomEvent('cached-icons-rendered'));}};this.element.addEventListener('cached-icon-rendered',onCachedIconRendered);var nextDivider=null;var oddDivider=true;var isRTL=(document.documentElement.dir==='rtl');for(var idx=0;idx<=this.items.length-1;idx++){var item=this.items[idx];if(options.rerender&&item.element){this.element.removeChild(item.element);item.element=null;}
if(item.detail.type==='divider'){nextDivider=null;}else{if(!nextDivider){for(var i=idx+1;i<this.items.length;i++){if(this.items[i].detail.type==='divider'){nextDivider=this.items[i];oddDivider=!oddDivider;break;}}
if(nextDivider&&!nextDivider.detail.collapsed){this.layout.offsetY+=nextDivider.headerHeight;}}
if(nextDivider&&nextDivider.detail.collapsed){item.setPosition(idx);continue;}}
if(x>0&&item.gridWidth>1&&x+item.gridWidth>=this.layout.cols){var remaining=this.layout.cols-x;this.createPlaceholders([x,y],idx,remaining);idx+=remaining;item=this.items[idx];var lastItemInRow=this.items[idx-1];step(lastItemInRow);}
item.setPosition(idx);if(!options.skipItems){item.hasCachedIcon&&++pendingCachedIcons;var xPosition=x*this.layout.gridItemWidth;if(isRTL){xPosition=(this.layout.constraintSize-this.layout.gridItemWidth)-
xPosition;}
item.setCoordinates(xPosition,this.layout.offsetY);if(!item.active){item.render();}
if(item.detail.type==='divider'){if(oddDivider){item.element.classList.add('odd');}else{item.element.classList.remove('odd');}}}
x+=item.gridWidth;if(x>=this.layout.cols){step(item);}}
if(this.layout.offsetY!=oldHeight){if(this.dragdrop&&this.dragdrop.inDragAction){this.layout.offsetY=oldHeight;}else{this.element.dispatchEvent(new CustomEvent('gaiagrid-resize',{detail:this.layout.offsetY}));}}
this.element.setAttribute('cols',this.layout.cols);pendingCachedIcons===0&&onCachedIconRendered();this.loadDragDrop();},loadDragDrop:function(){if(!this.dragdrop&&this.config.features.dragdrop){LazyLoader.load('shared/elements/gaia_grid/js/grid_dragdrop.js',()=>{if(this.dragdrop){return;}
this.dragdrop=new GridDragDrop(this);});}}};exports.GridView=GridView;}(window));;'use strict';(function(exports){const SHADOW_BLUR=1;const SHADOW_OFFSET_Y=1;const SHADOW_OFFSET_X=1;const SHADOW_COLOR='rgba(0, 0, 0, 0.2)';const DEFAULT_BACKGROUND_COLOR='rgb(228, 234, 238)';const UNSCALED_CANVAS_PADDING=2;const CANVAS_PADDING=UNSCALED_CANVAS_PADDING*devicePixelRatio;function IconRenderer(icon){this._icon=icon;}
IconRenderer.TYPE={CLIP:'clip',FAVICON:'favicon',STANDARD:'standard',};IconRenderer.prototype={unscaledCanvasPadding:UNSCALED_CANVAS_PADDING*2,get _maxSize(){return this._icon.grid.layout.gridMaxIconSize;},_createCanvas:function(){var canvas=document.createElement('canvas');canvas.width=this._maxSize+(CANVAS_PADDING*2);canvas.height=this._maxSize+(CANVAS_PADDING*2);return canvas;},_decorateShadowCanvas:function(canvas){var ctx=canvas.getContext('2d',{willReadFrequently:true});ctx.shadowColor=SHADOW_COLOR;ctx.shadowBlur=SHADOW_BLUR;ctx.shadowOffsetY=SHADOW_OFFSET_Y;ctx.shadowOffsetX=SHADOW_OFFSET_X;return ctx;},clip:function(img){return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);var clipCanvas=this._createCanvas();var clipCtx=clipCanvas.getContext('2d',{willReadFrequently:true});clipCtx.beginPath();clipCtx.arc(clipCanvas.width/2,clipCanvas.height/2,clipCanvas.height/2,0,2*Math.PI);clipCtx.clip();clipCtx.drawImage(img,0,0,clipCanvas.width,clipCanvas.height);shadowCtx.drawImage(clipCanvas,CANVAS_PADDING,CANVAS_PADDING,this._maxSize,this._maxSize);shadowCanvas.toBlob(resolve);});},favicon:function(img){if(img.width>this._icon.grid.layout.gridIconSize/2){return this.clip(img);}
return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);var iconWidth;var iconHeight;shadowCtx.beginPath();shadowCtx.arc(shadowCanvas.width/2,shadowCanvas.height/2,shadowCanvas.height/2-CANVAS_PADDING,0,2*Math.PI,false);shadowCtx.fillStyle=DEFAULT_BACKGROUND_COLOR;shadowCtx.fill();iconWidth=iconHeight=this._maxSize*0.55;shadowCtx.shadowBlur=0;shadowCtx.shadowOffsetY=0;shadowCtx.mozImageSmoothingEnabled=false;shadowCtx.drawImage(img,(shadowCanvas.width-iconWidth)/2,(shadowCanvas.height-iconHeight)/2,iconWidth,iconHeight);shadowCanvas.toBlob(resolve);});},standard:function(img){return new Promise((resolve)=>{var shadowCanvas=this._createCanvas();var shadowCtx=this._decorateShadowCanvas(shadowCanvas);shadowCtx.drawImage(img,CANVAS_PADDING,CANVAS_PADDING,this._maxSize,this._maxSize);shadowCanvas.toBlob(resolve);});}};exports.GridIconRenderer=IconRenderer;}(window));;'use strict';(function(exports){const maxIconsPerRow=4;const iconScaleFactorMaxIconsPerRow=5;const minIconsPerRow=3;const iconScaleFactorMinIconsPerRow=3.8;const distanceBetweenIconsWithMinIconsPerRow=36;const distanceBetweenIconsWithMaxIconsPerRow=38;const eachTextRowHeight=20;var constraintSize;function GridLayout(gridView){this.gridView=gridView;if(window.verticalPreferences){verticalPreferences.get('grid.cols').then(value=>{this.cols=value;this.onReady();},this.onReady);verticalPreferences.addEventListener('updated',this);}else{this.onReady();}}
GridLayout.prototype={minIconsPerRow:minIconsPerRow,maxIconsPerRow:maxIconsPerRow,_cols:minIconsPerRow,_offsetY:0,_percent:1,_dividerLineHeight:0,get percent(){return this._percent;},get cols(){return this._cols;},set cols(value){if(!value||value===this._cols){return;}
if(window.verticalPreferences){verticalPreferences.put('grid.cols',value);}
this._offsetY=0;this._percent=value==minIconsPerRow?1:minIconsPerRow/maxIconsPerRow;this._cols=value;},get constraintSize(){if(!constraintSize){this.calculateSize();}
return constraintSize;},get gridItemHeight(){var height=this.gridIconSize+
(this._cols===minIconsPerRow?distanceBetweenIconsWithMinIconsPerRow:distanceBetweenIconsWithMaxIconsPerRow);var defaultTextRows=2;var definedRows=parseInt(this.gridView.element.getAttribute('text-rows'),10);if(definedRows>defaultTextRows){height+=(definedRows-defaultTextRows)*eachTextRowHeight;}
return height;},get gridItemWidth(){return this.constraintSize/this._cols;},get gridMaxIconSize(){var baseSize=(this.constraintSize/iconScaleFactorMinIconsPerRow);return baseSize*devicePixelRatio;},get gridIconSize(){var numCols=this._cols;var size=this.constraintSize/numCols;if(numCols===minIconsPerRow){size=this.constraintSize/iconScaleFactorMinIconsPerRow;}else if(numCols===maxIconsPerRow){size=this.constraintSize/iconScaleFactorMaxIconsPerRow;}
return Math.floor(size);},get offsetY(){return this._offsetY;},set offsetY(value){this._offsetY=value;},stepYAxis:function(value){this._offsetY+=value;},handleEvent:function(e){switch(e.type){case'updated':var prop=e.target;if(prop.name==='grid.cols'){this.cols=parseInt(prop.value,10);this.gridView.render();}
break;}},calculateSize:function(){constraintSize=Math.min(window.screen.width,window.screen.height);},onReady:function(){window.dispatchEvent(new CustomEvent('gaiagrid-layout-ready'));}};exports.GridLayout=GridLayout;}(window));;'use strict';(function(exports){const pinchThreshold=Math.round(window.innerWidth/12);function GridZoom(gridView){this.gridView=gridView;this.touches=0;this.zoomStartTouches=[];this.zoomStartDistance=0;this.container=document.getElementById('zoom');this.arrows=this.container.querySelector('.arrows');this.curtain=this.container.querySelector('.curtain');this.indicator=this.container.querySelector('.indicator');this.start();window.addEventListener('gaiagrid-dragdrop-begin',this.stop.bind(this));window.addEventListener('gaiagrid-dragdrop-finish',this.start.bind(this));}
GridZoom.prototype={start:function(){window.addEventListener('touchstart',this);},stop:function(){window.removeEventListener('touchstart',this);},_attachGestureListeners:function(){window.addEventListener('touchmove',this);window.addEventListener('touchend',this);},_stopGestureListeners:function(){window.removeEventListener('touchmove',this);window.removeEventListener('touchend',this);},_resetState:function(){this.zoomInProgress=false;this.container.hidden=true;this.indicator.classList.remove('active');this.arrows.classList.remove('zooming','grow','shrink');this.arrows.style.transform='';},handleEvent:function(e){if(e.type==='touchend'&&this.zoomStartTouches){if(!this.zoomInProgress){this._resetState();}
this._stopGestureListeners();return;}
if(!e.touches||e.touches.length!==2){return;}
var touches=[e.touches[0],e.touches[1]].sort(function(a,b){return a.pageX-b.pageX;});var touchDistance=Math.sqrt((touches[0].pageX-touches[1].pageX)*(touches[0].pageX-touches[1].pageX)+
(touches[0].pageY-touches[1].pageY)*(touches[0].pageY-touches[1].pageY));var layout=this.gridView.layout;switch(e.type){case'touchstart':this.container.hidden=false;this.zoomStartTouches=touches;this.zoomStartDistance=touchDistance;if(layout.cols<layout.maxIconsPerRow){this.arrows.classList.add('grow');}else{this.arrows.classList.add('shrink');}
this.indicator.dataset.cols=layout.cols;this._attachGestureListeners();break;case'touchmove':if(layout.cols<layout.maxIconsPerRow&&touchDistance<this.zoomStartDistance&&Math.abs(touchDistance-this.zoomStartDistance)>pinchThreshold){this.gridView.cols=layout.maxIconsPerRow;this.zoomInProgress=true;}else if(layout.cols>layout.minIconsPerRow&&touchDistance>this.zoomStartDistance&&Math.abs(touchDistance-this.zoomStartDistance)>pinchThreshold){this.gridView.cols=layout.minIconsPerRow;this.zoomInProgress=true;}else{return;}
this._stopGestureListeners();var ontransitionend=function(){this.arrows.removeEventListener('transitionend',ontransitionend);this.indicator.classList.add('active');this.gridView.render();var zoomHideTime=400;setTimeout(this._resetState.bind(this),zoomHideTime);}.bind(this);this.arrows.addEventListener('transitionend',ontransitionend);this.indicator.dataset.cols=layout.cols;this.arrows.classList.add('zooming');document.body.clientHeight;var scaleTransform='scale(1)';if(this.zoomInProgress&&touchDistance<this.zoomStartDistance){scaleTransform='scale(0.4)';}
this.arrows.style.transform=scaleTransform;break;}}};exports.GridZoom=GridZoom;}(window));;window.GaiaGrid=(function(win){'use strict';var proto=Object.create(HTMLElement.prototype);var baseurl=window.GaiaGridBaseurl||'/shared/elements/gaia_grid/';proto.createdCallback=function(){var shadow=this.createShadowRoot();this._template=template.content.cloneNode(true);this._styleHack();this._grid=new GridView({element:this,features:{dragdrop:this.getAttribute('dragdrop')!==null,zoom:this.getAttribute('zoom')!==null,disableSections:this.getAttribute('disable-sections')!==null}});shadow.appendChild(this._template);};proto.add=function(){this._grid.add.apply(this._grid,arguments);};proto.clear=function(){this._grid.clear.apply(this._grid,arguments);};proto.render=function(){this._grid.layout.calculateSize();this._grid.render.apply(this._grid,arguments);};proto.start=function(){this._grid.start.apply(this._grid,arguments);};proto.stop=function(){this._grid.stop.apply(this._grid,arguments);};proto.getIcons=function(){return this._grid.icons;};proto.getItems=function(){return this._grid.items;};proto.getIcon=function(identifier){return this._grid.icons[identifier];};proto.removeIconByIdentifier=function(identifier){delete this._grid.icons[identifier];};proto.removeItemByIndex=function(itemIndex){this._grid.items.splice(itemIndex,1);};proto.popDivider=function(){var items=this._grid.items;if(items.length&&items[items.length-1].detail.type==='divider'){return items.pop();}
return null;};proto.appendItem=function(item){var items=this._grid.items;var lastIndex=items.length-1;if(items[lastIndex].detail.type==='divider'){this.add(item,lastIndex);}else{this.add(item);}};proto.appendItemToExpandedGroup=function(item){var items=this._grid.items;var lastIndex=items.length-1;if(items[lastIndex].detail.type==='divider'&&items[lastIndex].detail.collapsed){items[lastIndex].expand();}
this.appendItem(item);};proto.setEditHeaderElement=function(element){if(this._grid.dragdrop){this._grid.dragdrop.editHeaderElement=element;}};Object.defineProperty(proto,'maxIconSize',{get:function(){return this._grid.layout.gridMaxIconSize;}});proto.getIndexLastIcon=function(){var items=this._grid.items;for(var i=this._grid.items.length-1;i>=0;i--){if(items[i]instanceof GaiaGrid.Mozapp){return i;}}};proto.removeNonVisualElements=function(){var nonVisualElements=[GaiaGrid.Placeholder];function isNonVisual(elem){var retVal=false;for(var i=0,iLen=nonVisualElements.length;i<iLen&&!retVal;i++){retVal=elem instanceof nonVisualElements[i];}
return retVal;}
var i=0;var iLen=this._grid.items.length;while(i<iLen){this._grid.items[i].detail.index=i;if(isNonVisual(this._grid.items[i])){this._grid.items.splice(i,1);iLen-=1;}else{i+=1;}}};proto.moveTo=function(orig,dst){this._grid.items.splice(dst,0,this._grid.items.splice(orig,1)[0]);};proto._styleHack=function(){var style=this._template.querySelector('style');this.appendChild(style.cloneNode(true));};var stylesheet=baseurl+'style.css';var template=document.createElement('template');template.innerHTML=`<style scoped>
    @import url(${stylesheet});</style>
    <content></content>`;return document.registerElement('gaia-grid',{prototype:proto});})(window);;'use strict';(function(exports){const ICON_BLOB_DECORATED_EVENT='iconblobdecorated';const ICON_BLOB_ERROR_EVENT='gaiagrid-iconbloberror';const FETCH_XHR_TIMEOUT=10000;function fetchBlob(uri){return new Promise(function(accept,reject){var xhr=new XMLHttpRequest({mozAnon:true,mozSystem:true});xhr.open('GET',uri,true);xhr.responseType='blob';xhr.timeout=FETCH_XHR_TIMEOUT;xhr.send();xhr.onload=function(){var status=xhr.status;if(status!==0&&status!==200){reject(new Error('Got HTTP status '+status+' trying to load '+uri));return;}
accept(xhr.response);};xhr.onerror=xhr.ontimeout=function(){reject(new Error('Error while HTTP GET: ',uri));};});}
function GridItem(){this.detail={};}
GridItem.prototype={x:0,y:0,pixelHeight:0,gridWidth:1,scale:1,persistToDB:true,lastX:null,lastY:null,lastScale:null,get hasCachedIcon(){return this.detail&&this.detail.decoratedIconBlob;},renderer:GridIconRenderer.TYPE.STANDARD,iconState:'none',get defaultIcon(){return'/shared/elements/gaia_grid/images/default_icon.png';},get grid(){return document.getElementsByTagName('gaia-grid')[0]._grid;},isRemovable:function(){return false;},isEditable:function(){return false;},isDraggable:function(){return true;},isIconFromOrigin:function(){return this.icon.startsWith('http')||this.icon.startsWith('app:');},setPosition:function(position){this.detail.index=position;},setCoordinates:function(x,y){this.x=x;this.y=y;},requestAttention:function(){var rect={x:this.x,y:this.y,width:this.gridWidth*this.grid.layout.gridItemWidth,height:this.pixelHeight};this.grid.element.dispatchEvent(new CustomEvent('gaiagrid-attention',{detail:rect}));},closestIconFromList:function(choices){if(!choices){return this.defaultIcon;}
var list=Object.keys(choices).map(function(size){return size;}).sort(function(a,b){return b-a;});var length=list.length;if(length===0){return this.defaultIcon;}
var maxSize=this.grid.layout.gridMaxIconSize;var accurateSize=list[0];for(var i=0;i<length;i++){var size=list[i];if(size<maxSize){break;}
accurateSize=size;}
var icon=choices[accurateSize];if(!UrlHelper.hasScheme(icon)){icon=this.app.origin+icon;}
return icon;},renderIconFromSrc:function(url){var background=new Image();background.src=url;background.onload=this._decorateIcon.bind(this,background);},renderIconFromBlob:function(blob){var background=new Image();background.src=URL.createObjectURL(blob);background.onload=()=>{this._decorateIcon(background);URL.revokeObjectURL(background.src);};background.onerror=()=>{URL.revokeObjectURL(background.src);if(this.hasCachedIcon){this._stampElementWithIcon('blobcache');this._displayDecoratedIcon(this.detail.decoratedIconBlob,true);return;}
this.renderIconFromSrc(this.defaultIcon);this._stampElementWithIcon(this.defaultIcon);};},_decorateIcon:function(img){var strategy=this.detail.renderer||this.renderer;this.rendererInstance=new GridIconRenderer(this);this.rendererInstance[strategy](img).then(this._displayDecoratedIcon.bind(this));},_displayDecoratedIcon:function(blob,isCachedIcon){if(!this.element){return;}
var style=this.element.style;if(!style.backgroundSize){style.height=this.grid.layout.gridItemHeight+'px';var backgroundHeight=((this.grid.layout.gridIconSize*(1/this.grid.layout.percent))+
GridIconRenderer.prototype.unscaledCanvasPadding);if(this.grid.layout.gridItemHeight>backgroundHeight){style.backgroundSize=backgroundHeight+'px';}else{style.backgroundSize=style.height;}}
if(isCachedIcon){var url=URL.createObjectURL(blob);style.backgroundImage='url('+url+')';this.element.dataset.backgroundImage=url;var img=new Image();img.onload=img.onerror=()=>{this.grid.element.dispatchEvent(new CustomEvent('cached-icon-rendered'));};img.src=url;return;}
this._compareBlobs(blob,this.detail.decoratedIconBlob).then((equal)=>{if(equal){return;}
style.backgroundImage='url('+URL.createObjectURL(blob)+')';this.detail.decoratedIconBlob=blob;this.grid.element.dispatchEvent(new CustomEvent(ICON_BLOB_DECORATED_EVENT,{detail:this}));var bgImg=this.element.dataset.backgroundImage;bgImg&&URL.revokeObjectURL(bgImg);});},_compareBlobs:function(blob1,blob2){return new Promise(function(resolve){if(!blob1||!blob2||blob1.type!==blob2.type||blob1.size!==blob2.size){resolve(false);return;}
var startBytes=127;var bytesHash=16;var reader=new FileReader();reader.onloadend=function(){var result1=reader.result;reader=new FileReader();reader.onloadend=reader.onerror=function(){resolve(result1===reader.result);};reader.readAsDataURL(blob2.slice(startBytes,startBytes+bytesHash));};reader.onerror=function(){resolve(false);};reader.readAsDataURL(blob1.slice(startBytes,startBytes+bytesHash));});},fetchIconBlob:function(){return fetchBlob(this.icon);},_stampElementWithIcon:function(uri){if(!this.element||uri.startsWith('data:')){return;}
if(uri.length>255){uri=uri.slice(0,255);}
this.element.dataset.testIcon=uri;},renderIcon:function(renderCachedIcon){var icon=this.icon;this.iconState='pending';if(renderCachedIcon&&this.hasCachedIcon){this._displayDecoratedIcon(this.detail.decoratedIconBlob,true);var resolveIcon=()=>{this.grid.element.removeEventListener('cached-icons-rendered',resolveIcon);this.doRenderIcon(icon);};this.grid.element.addEventListener('cached-icons-rendered',resolveIcon);}else{this.doRenderIcon(icon);}},doRenderIcon:function(icon){if(!this.isIconFromOrigin()){this._stampElementWithIcon(icon);this.renderIconFromSrc(icon);this.iconState='success';return Promise.resolve();}
var eventTarget=this.grid.element;var blobNotFound=()=>{this.iconState='error';if(!this.hasCachedIcon){this.renderIconFromSrc(this.defaultIcon);this._stampElementWithIcon(this.defaultIcon);}else{this._stampElementWithIcon('blobcache');}
eventTarget.dispatchEvent(new CustomEvent(ICON_BLOB_ERROR_EVENT,{detail:this}));};return this.fetchIconBlob().then((blob)=>{if(!blob){return blobNotFound();}
this.renderIconFromBlob(blob);this.iconState='success';this._stampElementWithIcon(icon);}).catch((err)=>{blobNotFound();});},removeFromGrid:function(){var idx=this.grid.items.indexOf(this);if(idx===-1){console.error('Attempting to remove self before item has been added!');return;}
this.grid.items.splice(idx,1);delete this.grid.icons[this.identifier];if(this.element){this.element.parentNode.removeChild(this.element);}
this.grid.render({from:idx-1});},remove:function(){this.grid.element.dispatchEvent(new CustomEvent('removeitem',{detail:this}));},render:function(){var scale=this.grid.layout.percent*this.scale;if(!this.element){var tile=document.createElement('div');tile.className='icon';tile.dataset.identifier=this.identifier;tile.dataset.isDraggable=this.isDraggable();tile.setAttribute('role','link');tile.style.width=(this.grid.layout.constraintSize/3)+'px';var nameContainerEl=document.createElement('p');nameContainerEl.style.marginTop=((this.grid.layout.gridIconSize*(1/this.grid.layout.percent))+
(GridIconRenderer.prototype.unscaledCanvasPadding/2))+'px';tile.appendChild(nameContainerEl);var nameEl=document.createElement('span');nameEl.className='title';nameEl.setAttribute('dir','auto');nameContainerEl.appendChild(nameEl);if(this.isRemovable()){var removeEl=document.createElement('span');removeEl.className='remove';tile.appendChild(removeEl);}
this.element=tile;this.updateTitle();this.renderIcon(true);this.grid.element.appendChild(tile);}
this.transform(this.x,this.y,scale);},transform:function(x,y,scale,element){scale=scale||1;if(!element){if(x===this.lastX&&y===this.lastY&&scale===this.lastScale){return;}
element=this.element;this.lastX=x;this.lastY=y;this.lastScale=scale;}
element.style.transform='translate('+x+'px,'+y+'px) scale('+scale+')';},setActive:function(active){if(active){this.element.classList.add('active');this.active=true;}else{this.element.classList.remove('active');this.active=false;}},updateTitle:function(){if(!this.element){return;}
var nameEl=this.element.querySelector('.title');if(this.asyncName){this.asyncName().then(function(name){nameEl.textContent=name;});}else{nameEl.textContent=this.name;}},updateFromDatastore:function(record){var iconChanged=record.icon!==this.icon;var nameChanged=record.name!==this.name;var type=this.detail.type;var lastIcon=this.icon;record.type=type;this.detail=record;if(nameChanged){this.updateTitle();}
if(iconChanged&&record.icon){this.renderIcon();}else if(!record.icon){this.detail.icon=lastIcon;}}};exports.GaiaGrid.GridItem=GridItem;}(window));;'use strict';(function(exports){const TYPE='bookmark';function Bookmark(record,features){this.detail=record;this.features=features||{};this.detail.type=TYPE;}
Bookmark.prototype={__proto__:GaiaGrid.GridItem.prototype,renderer:GridIconRenderer.TYPE.FAVICON,get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){return this.detail.name;},get icon(){return this.detail.icon||this.defaultIcon;},get identifier(){return this.detail.id;},update:GaiaGrid.GridItem.prototype.updateFromDatastore,isEditable:function(){return this.features&&this.features.isEditable!==false;},isRemovable:function(){return this.features&&this.features.isRemovable!==false;},isDraggable:function(){return this.features&&this.features.isDraggable!==false;},render:function(){GaiaGrid.GridItem.prototype.render.call(this);this.element.classList.add('bookmark');if(this.isEditable()){this.element.classList.add('editable');}},launch:function(){var features={name:this.name,icon:this.icon,remote:true};var url=this.detail.url;if(this.features.search){features.searchName=this.name;features.searchUrl=url;}
window.open(url,'_blank',Object.keys(features).map(function eachFeature(key){return encodeURIComponent(key)+'='+
encodeURIComponent(features[key]);}).join(','));},edit:function(){new MozActivity({name:'save-bookmark',data:{type:'url',url:this.detail.id}});}};exports.GaiaGrid.Bookmark=Bookmark;}(window));;'use strict';(function(exports){const TYPE='marketplace-app';function MarketPlaceApp(record){this.detail=record;this.detail.type=TYPE;}
MarketPlaceApp.prototype={__proto__:GaiaGrid.Bookmark.prototype,renderer:GridIconRenderer.TYPE.STANDARD,get icon(){var icon=this._accurateIcon;if(!icon){icon=this._accurateIcon=this.closestIconFromList(this.detail.icons);}
return icon;},launch:function(){new MozActivity({name:'marketplace-app',data:{slug:this.detail.slug}});},};exports.GaiaGrid.MarketPlaceApp=MarketPlaceApp;}(window));;'use strict';(function(exports){const l10nKey='collection-categoryId-';var _=navigator.mozL10n.get;function Collection(collection,entryPoint){this.collection=collection;this.detail={type:'collection',name:collection.name,id:collection.id,categoryId:collection.categoryId,cName:collection.cName,query:collection.query,icon:collection.icon,pinned:collection.pinned,decoratedIconBlob:collection.decoratedIconBlob,nonTranslatable:collection.nonTranslatable};window.addEventListener('localized',this.updateTitle.bind(this));}
Collection.prototype={__proto__:GaiaGrid.GridItem.prototype,renderer:GridIconRenderer.TYPE.CLIP,get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){if(this.detail.nonTranslatable){return this.detail.name;}
return _(l10nKey+this.detail.categoryId)||this.detail.name;},get icon(){return this.detail.icon||this.defaultIcon;},get identifier(){return this.detail.id;},update:GaiaGrid.GridItem.prototype.updateFromDatastore,render:function(){var setClassName=!this.element;GaiaGrid.GridItem.prototype.render.call(this);if(setClassName){this.element.classList.add('collection');this.isEditable()&&this.element.classList.add('editable');}},isEditable:function(){return true;},isRemovable:function(){return true;},launch:function(){this.grid.element.dispatchEvent(new CustomEvent('collection-launch'));var activity=new MozActivity({name:'view-collection',data:this.detail});activity.onsuccess=activity.onerror=()=>{this.grid.element.dispatchEvent(new CustomEvent('collection-close'));};},edit:function(){new MozActivity({name:'update-collection',data:this.detail});}};exports.GaiaGrid.Collection=Collection;}(window));;'use strict';(function(exports){function Divider(){this.detail={type:'divider',index:0};}
Divider.prototype={__proto__:GaiaGrid.GridItem.prototype,x:0,y:0,headerHeight:0,get pixelHeight(){return(this.grid.layout.cols>3)?50:60;},gridWidth:4,scale:1,render:function(){if(!this.element){var divider=this.element=document.createElement('section');divider.className='divider';var span=document.createElement('span');span.className='spacer';divider.appendChild(span);this.grid.element.appendChild(divider);}
this.element.style.transform='translate(0 ,'+this.y+'px)';},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}},isDraggable:function(){return false;}};exports.GaiaGrid.Divider=Divider;}(window));;'use strict';(function(exports){const IDENTIFIER_SEP='-';var MOZAPP_EVENTS=['downloadsuccess','downloaderror','downloadavailable','downloadapplied','progress'];var APP_LOADING='loading';var APP_ERROR='error';var APP_UNRECOVERABLE='unrecoverable';var APP_PAUSED='paused';var APP_READY='ready';function localizeString(str){var userLang=document.documentElement.lang;if(navigator.mozL10n&&userLang in navigator.mozL10n.qps){return navigator.mozL10n.qps[userLang].translate(str);}
return str;}
function Mozapp(app,entryPoint,details){this.app=app;this.entryPoint=entryPoint;this.detail={type:'app',manifestURL:app.manifestURL,entryPoint:entryPoint,index:0,decoratedIconBlob:details&&details.decoratedIconBlob};MOZAPP_EVENTS.forEach(function(type){this.app['on'+type]=this.handleEvent.bind(this);},this);this.setAppState(this._determineState(app));}
Mozapp.HIDDEN_ROLES=['system','input','homescreen','search','addon','langpack'];Mozapp.prototype={__proto__:GaiaGrid.GridItem.prototype,_isHiddenRole:function(){var manifest=this.app.manifest;if(!manifest||!manifest.role){return null;}
return Mozapp.HIDDEN_ROLES.indexOf(manifest.role)!==-1;},_determineState:function(app){if(app.installState==='pending'&&!app.downloadAvailable&&!app.readyToApplyDownload){return APP_UNRECOVERABLE;}
if(app.downloading){return APP_LOADING;}
if(app.downloadError&&app.downloadError.name){if(app.downloadError.name==='DOWNLOAD_CANCELED'){return APP_PAUSED;}
return APP_ERROR;}
if(app.installState==='pending'){return APP_PAUSED;}
return APP_READY;},handleEvent:function(event){switch(event.type){case'progress':case'downloaderror':case'downloadsuccess':this.setAppState(this._determineState(this.app));break;case'downloadapplied':if(this._isHiddenRole()){console.warn('Removing hidden app from the grid',this.name);return this.removeFromGrid();}
delete this._accurateIcon;this.setAppState(this._determineState(this.app));this.renderIcon();window.dispatchEvent(new CustomEvent('downloadapplied',{detail:{id:this.app.manifestURL}}));break;}},get pixelHeight(){return this.grid.layout.gridItemHeight;},gridWidth:1,get name(){var userLang=document.documentElement.lang;if(navigator.mozL10n&&userLang in navigator.mozL10n.qps){return navigator.mozL10n.qps[userLang].translate(this.descriptor.short_name||this.descriptor.name);}
var locales=this.descriptor.locales;var localized=locales&&locales[userLang]&&(locales[userLang].short_name||locales[userLang].name);return localized||this.descriptor.short_name||this.descriptor.name;},asyncName:function(){var userLang=document.documentElement.lang;var ep=this.entryPoint||undefined;return this.app.getLocalizedValue('short_name',userLang,ep).then(shortName=>localizeString(shortName),this.app.getLocalizedValue.bind(this.app,'name',userLang,ep)).then(name=>localizeString(name),()=>this.name);},get icon(){var icon=this._accurateIcon;if(!icon){icon=this._accurateIcon=this.closestIconFromList(this.descriptor.icons);}
return icon;},get descriptor(){var manifest=this.app.manifest||this.app.updateManifest;if(this.entryPoint&&manifest.entry_points&&manifest.entry_points[this.entryPoint]){return manifest.entry_points[this.entryPoint];}
return manifest;},identifierSeparator:IDENTIFIER_SEP,get identifier(){var identifier=[this.app.manifestURL];if(this.entryPoint){identifier.push(this.entryPoint);}
return identifier.join(IDENTIFIER_SEP);},isRemovable:function(){return this.app.removable;},unrecoverableError:function(){navigator.mozApps.mgmt.uninstall(this.app);},cancel:function(){var dialog=new ConfirmDialogHelper({type:'pause',title:{id:'gaia-grid-stop-download-title',args:{name:this.name}},body:'gaia-grid-stop-download-body',cancel:{title:'gaia-grid-cancel'},confirm:{title:'gaia-grid-stop-download-action',type:'danger',cb:()=>this.app.cancelDownload()}});dialog.show(document.body);},resume:function(){var dialog=new ConfirmDialogHelper({type:'resume',title:'gaia-grid-resume-download-title',body:{id:'gaia-grid-resume-download-body',args:{name:this.name}},cancel:{title:'gaia-grid-cancel'},confirm:{title:'gaia-grid-resume-download-action',cb:()=>{this.setAppState(APP_LOADING);this.app.download();}}});dialog.show(document.body);},setAppState:function(state){this.appState=state;if(this.element){this.element.dataset.appState=state;}},render:function(){var needsStateSet=!this.element;GaiaGrid.GridItem.prototype.render.apply(this,arguments);if(needsStateSet){this.setAppState(this.appState);}},launch:function(){var app=this.app;switch(this._determineState(app)){case APP_UNRECOVERABLE:return this.unrecoverableError();case APP_ERROR:case APP_PAUSED:return this.resume();case APP_LOADING:return this.cancel();}
var appContext=app.manifestURL.replace('app://','').replace('/manifest.webapp','');window.performance.mark('appLaunch@'+appContext);if(this.entryPoint){return app.launch(this.entryPoint);}
return app.launch();}};exports.GaiaGrid.Mozapp=Mozapp;}(window));;'use strict';(function(exports){function Placeholder(){this.detail={type:'placeholder',index:0};}
Placeholder.prototype={__proto__:GaiaGrid.GridItem.prototype,get pixelHeight(){return this.grid.layout.gridItemHeight;},createsGroupOnDrop:false,gridWidth:1,persistToDB:false,get name(){return'';},render:function(){if(!this.element){var tile=document.createElement('div');tile.className='icon placeholder';tile.style.height=this.pixelHeight+'px';this.element=tile;this.grid.element.appendChild(tile);}
this.transform(this.x,this.y,this.grid.layout.percent);},remove:function(){if(this.element){this.element.parentNode.removeChild(this.element);}}};exports.GaiaGrid.Placeholder=Placeholder;}(window));;this.asyncStorage=(function(){'use strict';var DBNAME='asyncStorage';var DBVERSION=1;var STORENAME='keyvaluepairs';var db=null;function withDatabase(f){if(db){f();}else{var openreq=indexedDB.open(DBNAME,DBVERSION);openreq.onerror=function withStoreOnError(){console.error('asyncStorage: can\'t open database:',openreq.error.name);};openreq.onupgradeneeded=function withStoreOnUpgradeNeeded(){openreq.result.createObjectStore(STORENAME);};openreq.onsuccess=function withStoreOnSuccess(){db=openreq.result;f();};}}
function withStore(type,callback,oncomplete){withDatabase(function(){var transaction=db.transaction(STORENAME,type);if(oncomplete){transaction.oncomplete=oncomplete;}
callback(transaction.objectStore(STORENAME));});}
function getItem(key,callback){var req;withStore('readonly',function getItemBody(store){req=store.get(key);req.onerror=function getItemOnError(){console.error('Error in asyncStorage.getItem(): ',req.error.name);};},function onComplete(){var value=req.result;if(value===undefined){value=null;}
callback(value);});}
function setItem(key,value,callback){withStore('readwrite',function setItemBody(store){var req=store.put(value,key);req.onerror=function setItemOnError(){console.error('Error in asyncStorage.setItem(): ',req.error.name);};},callback);}
function removeItem(key,callback){withStore('readwrite',function removeItemBody(store){var req=store.delete(key);req.onerror=function removeItemOnError(){console.error('Error in asyncStorage.removeItem(): ',req.error.name);};},callback);}
function clear(callback){withStore('readwrite',function clearBody(store){var req=store.clear();req.onerror=function clearOnError(){console.error('Error in asyncStorage.clear(): ',req.error.name);};},callback);}
function length(callback){var req;withStore('readonly',function lengthBody(store){req=store.count();req.onerror=function lengthOnError(){console.error('Error in asyncStorage.length(): ',req.error.name);};},function onComplete(){callback(req.result);});}
function key(n,callback){if(n<0){callback(null);return;}
var req;withStore('readonly',function keyBody(store){var advanced=false;req=store.openCursor();req.onsuccess=function keyOnSuccess(){var cursor=req.result;if(!cursor){return;}
if(n===0||advanced){return;}
advanced=true;cursor.advance(n);};req.onerror=function keyOnError(){console.error('Error in asyncStorage.key(): ',req.error.name);};},function onComplete(){var cursor=req.result;callback(cursor?cursor.key:null);});}
return{getItem:getItem,setItem:setItem,removeItem:removeItem,clear:clear,length:length,key:key};}());;'use strict';var rscheme=/^(?:[a-z\u00a1-\uffff0-9-+]+)(?::(?:\/\/)?)/i;var UrlHelper={a:null,getUrlFromInput:function urlHelper_getUrlFromInput(input){this.a=this.a||document.createElement('a');this.a.href=input;return this.a.href;},_getScheme:function(input){return(rscheme.exec(input)||[])[0];},hasScheme:function(input){return!!this._getScheme(input);},isURL:function urlHelper_isURL(input){return!UrlHelper.isNotURL(input);},isNotURL:function urlHelper_isNotURL(input){var case1Reg=/^(\?)|(\?.+\s)/;var case2Reg=/[\?\.\s\:]/;var case3Reg=/^(data|view-source)\:/;var str=input.trim();if(case1Reg.test(str)||!case2Reg.test(str)||this._getScheme(str)===str){return true;}
if(case3Reg.test(str)){return false;}
if(!this.hasScheme(str)){str='http://'+str;}
if(!this.urlValidate){this.urlValidate=document.createElement('input');this.urlValidate.setAttribute('type','url');}
this.urlValidate.setAttribute('value',str);return!this.urlValidate.validity.valid;}};;var DateHelper={todayStarted:function dh_todayStarted(){var now=(new Date()).valueOf();return this.getMidnight(now);},yesterdayStarted:function dh_yesterdayStarted(){var now=(new Date()).valueOf();var dayAgo=now-86400000;return this.getMidnight(dayAgo);},thisWeekStarted:function dh_thisWeekStarted(){var now=new Date();var dayOfTheWeek=now.getDay();var firstDay=new Date(now.getFullYear(),now.getMonth(),now.getDate()-dayOfTheWeek);return this.getMidnight(firstDay);},thisMonthStarted:function dh_thisMonthStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),now.getMonth(),1).valueOf());return firstDay;},lastSixMonthsStarted:function dh_lastSixMonthsStarted(){var now=new Date().valueOf();var sixMonthsAgo=now-2629743830*6;return sixMonthsAgo;},thisYearStarted:function dh_thisYearStarted(){var now=new Date();var firstDay=(new Date(now.getFullYear(),0).valueOf());return firstDay;},getMidnight:function dh_getMidnight(timestamp){var day=new Date(timestamp);var midnight=(new Date(day.getFullYear(),day.getMonth(),day.getDate(),0).valueOf());return midnight;}};var NumberHelper={zfill:function nh_zfill(string,len){var s=string;while(s.length<len)s='0'+s;return s;}};var HtmlHelper={createHighlightHTML:function ut_createHighlightHTML(text,searchRegExp){if(!searchRegExp){return this.escapeHTML(text);}
searchRegExp=new RegExp(searchRegExp,'gi');var sliceStrs=text.split(searchRegExp);var patterns=text.match(searchRegExp);if(!patterns){return this.escapeHTML(text);}
var str='';for(var i=0;i<patterns.length;i++){str=str+
this.escapeHTML(sliceStrs[i])+'<span class="highlight">'+
this.escapeHTML(patterns[i])+'</span>';}
str+=this.escapeHTML(sliceStrs.pop());return str;},escapeHTML:function ut_escapeHTML(str,escapeQuotes){var span=document.createElement('span');span.textContent=str;span.innerHTML=span.innerHTML.replace(/\s/g,'&nbsp;');if(escapeQuotes)
return span.innerHTML.replace(/"/g,'&quot;').replace(/'/g,'&#x27;');return span.innerHTML;},importElements:function importElements(context){var ids=[].slice.call(arguments,1);ids.forEach(function(id){context[StringHelper.camelCase(id)]=document.getElementById(id);});}};var StringHelper={fromUTF8:function ut_fromUTF8(str){var buf=new Uint8Array(str.length);for(var i=0;i<str.length;i++){buf[i]=str.charCodeAt(i);}
return buf;},camelCase:function ut_camelCase(str){var rdashes=/-(.)/g;return str.replace(rdashes,function replacer(str,p1){return p1.toUpperCase();});}};;'use strict';(function(exports){const MIN_SEGMENT_SIGNIFICANT_LENGTH=6;function SearchDedupe(){}
SearchDedupe.prototype={exactResults:{},fuzzyResults:{},dedupeNullList:['mobile','touch'],reduce:function(results,strategy){var validResults=[];var exactDedupeIdCache=[];var fuzzyDedupeIdCache=[];results.forEach(function eachResult(result){var found=false;var dedupeId=result.dedupeId.toLowerCase();var host;try{host=new URL(dedupeId).host;}catch(e){host=dedupeId;}
var fuzzyDedupeIds=[host,dedupeId];var hostParts=host.split('.');for(var i in hostParts){var part=hostParts[i];if(part.length>MIN_SEGMENT_SIGNIFICANT_LENGTH&&this.dedupeNullList.indexOf(part)===-1){fuzzyDedupeIds.push(part);}}
if(strategy=='exact'){dedupeId=dedupeId.replace(/(\?.*)/g,'');if(this.exactResults[dedupeId]){found=true;}}else{fuzzyDedupeIds.forEach(function eachFuzzy(eachId){for(var i in this.fuzzyResults){if(i.indexOf(eachId)!==-1){found=true;}}},this);}
exactDedupeIdCache.push(dedupeId);fuzzyDedupeIdCache=fuzzyDedupeIdCache.concat(fuzzyDedupeIds);if(!found){validResults.push(result);}},this);exactDedupeIdCache.forEach(function eachFuzzy(eachId){this.exactResults[eachId]=true;},this);fuzzyDedupeIdCache.forEach(function eachFuzzy(eachId){this.fuzzyResults[eachId]=true;},this);return validResults;},reset:function(){this.exactResults={};this.fuzzyResults={};}};exports.SearchDedupe=SearchDedupe;}(window));;(function(exports){'use strict';var DB_NAME='places_idb_store';var DB_VERSION=2;var PLACES_STORE='places';var VISITS_STORE='visits';function PlacesIdbStore(){}
PlacesIdbStore.prototype={db:null,latestRevision:null,init:function(){var self=this;return new Promise(function(resolve,reject){var req=window.indexedDB.open(DB_NAME,DB_VERSION);req.onupgradeneeded=self.upgradeSchema;req.onsuccess=function(e){self.db=e.target.result;asyncStorage.getItem('latest-revision',function(value){self.latestRevision=value||0;resolve();});};});},upgradeSchema:function(e){var db=e.target.result;var fromVersion=e.oldVersion;if(fromVersion<1){var places=db.createObjectStore(PLACES_STORE,{keyPath:'url'});places.createIndex('frecency','frecency',{unique:false});places.createIndex('visited','visited',{unique:false});}
if(fromVersion<2){asyncStorage.removeItem('latest-revision');var visits=db.createObjectStore(VISITS_STORE,{keyPath:'date'});visits.createIndex('date','date',{unique:true});}},add:function(id,data,rev){return new Promise((resolve,reject)=>{var txn=this.db.transaction([PLACES_STORE,VISITS_STORE],'readwrite');txn.objectStore(PLACES_STORE).put(data);if(!data.visits){data.visits=[data.visited];}
var visitsStore=txn.objectStore(VISITS_STORE);data.visits.forEach(function(date){visitsStore.put({date:date,url:data.url,title:data.title,icons:data.icons});});txn.oncomplete=this.saveAndResolve(rev,resolve);});},addPlace:function(place){return new Promise((resolve,reject)=>{var txn=this.db.transaction([PLACES_STORE],'readwrite');txn.objectStore(PLACES_STORE).put(place);txn.oncomplete=resolve;});},remove:function(id,rev){return new Promise((resolve,reject)=>{var txn=this.db.transaction([PLACES_STORE],'readwrite');txn.objectStore(PLACES_STORE).remove(id);txn.oncomplete=this.saveAndResolve(rev,resolve);});},clear:function(rev){return new Promise((resolve,reject)=>{var stores=[VISITS_STORE,PLACES_STORE];var txn=this.db.transaction(stores,'readwrite');txn.objectStore(PLACES_STORE).clear();txn.objectStore(VISITS_STORE).clear();txn.oncomplete=this.saveAndResolve(rev,resolve);});},saveAndResolve:function(rev,resolve){return function(){asyncStorage.setItem('latest-revision',rev);resolve();};},readStore:function(store,index,limit,done,filter){var results=[];var txn=this.db.transaction(store,'readonly');var oStore=txn.objectStore(store);oStore.index(index).openCursor(null,'prev').onsuccess=function(event){var cursor=event.target.result;if(cursor){if(!filter||filter(cursor.value)){results.push(cursor.value);}
if(results.length<limit){cursor.continue();}}};txn.oncomplete=function(){done(results);};},read:function(index,limit,done,filter){this.readStore(PLACES_STORE,index,limit,done,filter);},readVisits:function(limit,done,filter){this.readStore(VISITS_STORE,'date',limit,done,filter);}};exports.PlacesIdbStore=PlacesIdbStore;})(window);;(function syncStore(exports){'use strict';function onChange(evt){var self=this;doSync(this).then(function(){if(typeof self.onChangeFN==='function'){self.onChangeFN(self,evt);}});}
function ensureDS(SDS){if(SDS.store!==null){return Promise.resolve(SDS.store);}
return new Promise(function(resolve,reject){navigator.getDataStores(SDS.STORE_NAME).then(function(stores){if(!Array.isArray(stores)||stores.length<1){reject('Could not find store '+SDS.STORE_NAME);return;}
SDS.store=stores[0];SDS.store.addEventListener('change',onChange.bind(SDS));resolve(SDS);});});}
function doSync(SDS){if(SDS.syncInProgress){return Promise.reject('Sync in progress');}
SDS.syncInProgress=true;if(SDS.store===null){return Promise.reject('Store not initialised');}
return new Promise(function(resolve,reject){var cursor=SDS.store.sync(SDS.lastRevision);function resolveCursor(task){SDS.lastRevision=task.revisionId;switch(task.operation){case'update':case'add':var data=task.data;if(SDS.keyField in data&&!SDS.filterFN(data)){var key=data[SDS.keyField];SDS.persistStore.add(key,data,SDS.store.revisionId);}
break;case'clear':SDS.persistStore.clear(SDS.store.revisionId);break;case'remove':var id=task.target.id;SDS.persistStore.remove(id,SDS.store.revisionId);break;case'done':SDS.syncInProgress=false;resolve();return;}
cursor.next().then(resolveCursor);}
cursor.next().then(resolveCursor);});}
function SyncDataStore(name,persist,key){this.STORE_NAME=name;this.store=null;this.synced=false;this.lastRevision=0;this.keyField=key||'id';this.onChangeFN=null;this.syncInProgress=false;this.persistStore=persist;this.filterFN=function(){return false;};}
SyncDataStore.prototype={sync:function(revisionId){this.lastRevision=revisionId||this.lastRevision;return ensureDS(this).then(doSync);},set onChange(onChange){this.onChangeFN=onChange.bind(this);},set filter(fn){this.filterFN=fn;}};function InMemoryStore(){this.results={};}
InMemoryStore.prototype={add:function(id,data){this.results[id]=data;},update:function(id,data){this.results[id]=data;},clear:function(){this.results={};},remove:function(id){delete this.results[id];}};exports.SyncDataStore=SyncDataStore;exports.InMemoryStore=InMemoryStore;})(window);;'use strict';(function IconsHelper(exports){function getIcon(uri,iconSize,placeObj){var icon;if(placeObj&&placeObj.icons){icon=getBestIcon(placeObj.icons,iconSize);}
if(!icon){var a=document.createElement('a');a.href=uri;icon=a.origin+'/favicon.ico';}
return new Promise(resolve=>{resolve(icon);});}
function getBestIcon(icons,iconSize){if(!icons){return null;}
var options=getSizes(icons);var sizes=Object.keys(options).sort(function(a,b){return a-b;});if(sizes.length===0){var iconStrings=Object.keys(icons);return iconStrings.length>0?iconStrings[0]:null;}
var preferredSize=getPreferredSize(sizes,iconSize);var icon=options[preferredSize];if(icon.rel==='apple-touch-icon'){var iconsUrl='https://developer.mozilla.org/en-US/'+'Apps/Build/Icon_implementation_for_apps#General_icons_for_web_apps';console.warn('Warning: The apple-touch icons are being used '+'as a fallback only. They will be deprecated in '+'the future. See '+iconsUrl);}
return icon.uri;}
function getSizes(icons){var sizes={};var uris=Object.keys(icons);uris.forEach(function(uri){var uriSizes=icons[uri].sizes.join(' ').split(' ');uriSizes.forEach(function(size){var sizeValue=guessSize(size);if(!sizeValue){return;}
sizes[sizeValue]={uri:uri,rel:icons[uri].rel};});});return sizes;}
function getPreferredSize(sizes,iconSize){var targeted=iconSize?parseInt(iconSize):0;if(targeted===0){targeted=window.devicePixelRatio>1?142:84;}
var selected=-1;var length=sizes.length;for(var i=0;i<length&&selected<targeted;i++){selected=sizes[i];}
return selected;}
function guessSize(size){var xIndex=size.indexOf('x');if(!xIndex){return null;}
return size.substr(0,xIndex);}
exports.IconsHelper={getIcon:getIcon,getBestIcon:getBestIcon,getSizes:getSizes};})(window);;'use strict';(function(exports){function MetricsHelper(){this._portMetrics=null;this._initialized=false;}
MetricsHelper.prototype={init:function(){var self=this;navigator.mozApps.getSelf().onsuccess=function(){var app=this.result;app.connect('app-metrics').then(function onConnAccepted(ports){if(ports.length>0){self._portMetrics=ports[0];self._initialized=true;}},function onConnectionRejected(reason){console.log('Error connecting: '+reason+'\n');});};},report:function(action,data){if(this._initialized){this._portMetrics.postMessage({'action':action,'data':data});}}};exports.MetricsHelper=MetricsHelper;})(window);;'use strict';(function(exports){function Contextmenu(){this.menu=document.getElementById('contextmenu');this.grid=document.getElementById('icons');this.bookmarkButton=this.menu.querySelector('#add-to-homescreen');this.grid.addEventListener('contextmenu',this);this.bookmarkButton.addEventListener('click',this);}
Contextmenu.prototype={icon:null,handleEvent:function(e){switch(e.type){case'contextmenu':var identifier=e.target.dataset.identifier;var icon=this.grid.getIcon(identifier);if(!icon||icon.detail.type!=='bookmark'){return;}
var url=icon.detail.url;if(Bookmarks.get(url)){return;}
e.target.setAttribute('contextmenu','contextmenu');this.grid.stop();setTimeout(()=>{e.target.removeAttribute('contextmenu');this.grid.start();});this.icon=icon;break;case'click':var iconUrl=this.icon.detail.iconUrl||this.icon.icon;new MozActivity({name:'save-bookmark',data:{type:'url',url:this.icon.detail.url,name:this.icon.name,icon:iconUrl}});break;}}};exports.Contextmenu=Contextmenu;}(window));;(function(){'use strict';var SEARCH_DELAY=500;var MAX_GRID_SIZE=4;window.Search={_port:null,providers:{},gridCount:0,searchResults:document.getElementById('search-results'),offlineMessage:document.getElementById('offline-message'),suggestionsWrapper:document.getElementById('suggestions-wrapper'),grid:document.getElementById('icons'),gridWrapper:document.getElementById('icons-wrapper'),suggestionsEnabled:false,suggestionNotice:document.getElementById('suggestions-notice-wrapper'),get settingsLink(){return document.getElementById('settings-link');},toShowNotice:null,NOTICE_KEY:'notice-shown',init:function(){this.dedupe=new SearchDedupe();this.metrics=new MetricsHelper();this.metrics.init();var self=this;navigator.mozApps.getSelf().onsuccess=function(){var app=this.result;app.connect('search-results').then(function onConnAccepted(ports){ports.forEach(function(port){self._port=port;});setConnectionHandler();},function onConnectionRejected(reason){console.log('Error connecting: '+reason+'\n');});};function setConnectionHandler(){navigator.mozSetMessageHandler('connection',function(connectionRequest){var keyword=connectionRequest.keyword;var port=connectionRequest.port;if(keyword==='search'){port.onmessage=self.dispatchMessage.bind(self);port.start();}});initializeProviders();}
function initializeProviders(){for(var i in self.providers){self.providers[i].init(self);}}
var enabledKey='search.suggestions.enabled';SettingsListener.observe(enabledKey,true,function(enabled){this.suggestionsEnabled=enabled;}.bind(this));this.initNotice();this.initConnectivityCheck();if('geolocation'in navigator){navigator.geolocation.getCurrentPosition(function(){});}
this.contextmenu=new Contextmenu();window.addEventListener('resize',this.resize);window.addEventListener('scroll',this.onScroll);},resize:function(){if(this.grid&&this.grid.render){this.grid.render({rerender:true,skipDivider:true});}},onScroll:function(){window.focus();},provider:function(provider){if(!(provider.name in this.providers)){this.providers[provider.name]=provider;}},dispatchMessage:function(msg){if(typeof this[msg.data.action]==='function'){this[msg.data.action](msg);}},change:function(msg){clearTimeout(this.changeTimeout);this.showSearchResults();var input=msg.data.input;var providers=this.providers;this.changeTimeout=setTimeout(()=>{this.clear();this.dedupe.reset();Object.keys(providers).forEach((providerKey)=>{var provider=providers[providerKey];var preventRemoteFetch=UrlHelper.isURL(input)||msg.data.isPrivateBrowser||!this.suggestionsEnabled;if(provider.remote&&preventRemoteFetch){return;}
if(provider.name==='Suggestions'){var toShow=input.length>2&&this.toShowNotice&&this.suggestionsEnabled&&this.suggestionNotice.hidden&&navigator.onLine;if(toShow){this.suggestionNotice.hidden=false;}}
provider.search(input,preventRemoteFetch).then((results)=>{this.collect(provider,results);});});},SEARCH_DELAY);},initNotice:function(){var confirm=document.getElementById('suggestions-notice-confirm');confirm.addEventListener('click',this.discardNotice.bind(this,true));var settingsLink=this.settingsLink;if(settingsLink){settingsLink.addEventListener('click',this.openSettings.bind(this));}
asyncStorage.getItem(this.NOTICE_KEY,function(value){if(this.toShowNotice===null){this.toShowNotice=!value;}}.bind(this));},openSettings:function(){this.discardNotice();new MozActivity({name:'configure',data:{target:'device',section:'search'}});},discardNotice:function(focus){this.suggestionNotice.hidden=true;this.toShowNotice=false;asyncStorage.setItem(this.NOTICE_KEY,true);if(focus){this._port.postMessage({'action':'focus'});}},expandSearch:function(query){this.clear();this.providers.WebResults.fullscreen(query);},collect:function(provider,results){if(provider.dedupes){results=this.dedupe.reduce(results,provider.dedupeStrategy);}
if(provider.isGridProvider&&(results.length+this.gridCount)>MAX_GRID_SIZE){var spaces=MAX_GRID_SIZE-this.gridCount;if(spaces<1){this.abort();return;}
results.splice(spaces,(results.length-spaces));}
if(provider.isGridProvider){this.gridCount+=results.length;}
this.gridWrapper.classList.toggle('hidden',!this.gridCount);provider.render(results);},submit:function(msg){this.discardNotice();var input=msg.data.input;if(UrlHelper.isNotURL(input)){this.metrics.report('websearch',SearchProvider('title'));var url=SearchProvider('searchUrl').replace('{searchTerms}',encodeURIComponent(input));this.navigate(url);return;}
var hasScheme=UrlHelper.hasScheme(input);if(!hasScheme){input='http://'+input;}
this.navigate(input);},clear:function(msg){this.abort();for(var i in this.providers){this.providers[i].clear();}
this.gridCount=0;this.suggestionNotice.hidden=true;},showSearchResults:function(){if(this.searchResults){this.searchResults.classList.remove('hidden');}},abort:function(){clearTimeout(this.changeTimeout);for(var i in this.providers){this.providers[i].abort();}},close:function(){this.abort();this._port.postMessage({'action':'hide'});},navigate:function(url){window.open(url,'_blank','remote=true');},setInput:function(input){this._port.postMessage({'action':'input','input':input});this.expandSearch(input);},initConnectivityCheck:function(){var self=this;function onConnectivityChange(){if(navigator.onLine){self.searchResults.classList.remove('offline');}else{self.searchResults.classList.add('offline');}}
this.offlineMessage.addEventListener('click',function(){var activity=new window.MozActivity({name:'configure',data:{target:'device',section:'root',filterBy:'connectivity'}});activity.onsuccess=function(){};});window.addEventListener('offline',onConnectivityChange);window.addEventListener('online',onConnectivityChange);onConnectivityChange();}};window.addEventListener('load',Search.init.bind(Search));})();;'use strict';function Provider(){}
Provider.prototype={name:'Provider',dedupes:false,init:function(searchObj){this.searchObj=searchObj;this.container=document.getElementById(this.name.toLowerCase());this.container.addEventListener('click',this.click.bind(this));},clear:function(){this.container.innerHTML='';},click:function(){},abort:function(){if(this.request&&this.request.abort){this.request.abort();}},updateIcon:function(config,iconWrapper){var iconDom=iconWrapper.querySelector('img');IconsHelper.getIcon(config.dataset.url,null,config).then((icon)=>{if(icon&&iconDom){iconDom.onload=function(){iconWrapper.classList.remove('empty');iconDom.style.display='block';};iconDom.src=icon;}});},buildResultsDom:function(results){var frag=document.createDocumentFragment();results.forEach(function(config,index){var result=document.createElement('div');var iconWrapper=document.createElement('div');var icon=document.createElement('img');var description=document.createElement('div');var title=document.createElement('span');var meta=document.createElement('small');result.classList.add('result');iconWrapper.classList.add('icon');description.classList.add('description');title.classList.add('title');meta.classList.add('meta');for(var i in config.dataset){result.dataset[i]=config.dataset[i];}
if(config.title){title.setAttribute('dir','auto');title.textContent=config.title;}else{title.setAttribute('dir','ltr');title.textContent=config.url;}
if(config.meta){meta.textContent=config.meta;if(config.description){meta.id=this.name+'-description-'+index;meta.setAttribute('aria-label',config.description);result.setAttribute('aria-describedby',meta.id);}}
icon.setAttribute('role','presentation');if(config.icon){icon.src=window.URL.createObjectURL(config.icon);}else{iconWrapper.classList.add('empty');}
result.setAttribute('role','link');result.setAttribute('aria-label',config.label||config.title);description.appendChild(title);description.appendChild(meta);iconWrapper.appendChild(icon);result.appendChild(iconWrapper);result.appendChild(description);frag.appendChild(result);if(!config.icon){this.updateIcon(config,iconWrapper);}},this);return frag;},render:function(results){var dom=this.buildResultsDom(results);this.container.appendChild(dom);if(this.header){results.length?this.header.classList.remove('hidden'):this.header.classList.add('hidden');}}};;'use strict';function DataGridProvider(){}
DataGridProvider.prototype={__proto__:Provider.prototype,name:'DataGridProvider',isGridProvider:true,init:function(){this.grid=document.getElementById('icons');},clear:function(){this.grid.clear();},render:function(results){results.forEach(function(config,index){this.grid.add(config.data);},this);this.grid.render({skipDivider:true});}};;(function(){'use strict';const NUM_DISPLAY=4;var apiUrl=null;function Marketplace(){}
Marketplace.prototype={__proto__:DataGridProvider.prototype,name:'Marketplace',dedupes:true,dedupeStrategy:'exact',remote:true,init:function(){DataGridProvider.prototype.init.apply(this,arguments);var urlKey='search.marketplace.url';var req=navigator.mozSettings.createLock().get(urlKey);req.onsuccess=function(){if(req.result[urlKey]){apiUrl=req.result[urlKey].replace('{limit}',NUM_DISPLAY).replace('{lang}',document.documentElement.lang);}};},search:function(input){return new Promise((resolve,reject)=>{this.abort();if(!input||!apiUrl){return reject();}
var req=new XMLHttpRequest();req.open('GET',apiUrl.replace('{q}',encodeURIComponent(input)),true);req.onload=(function onload(){var results=JSON.parse(req.responseText);if(!results.length){return;}
var length=Math.min(NUM_DISPLAY,results.length);var formatted=[];for(var i=0;i<length;i++){var app=results[i];formatted.push({dedupeId:app.manifest_url,data:new GaiaGrid.MarketPlaceApp({id:app.manifest_url,name:navigator.mozL10n.get('install-marketplace-title',{title:app.name}),icons:app.icons,slug:app.slug})});}
resolve(formatted);}).bind(this);req.onerror=function onerror(){console.log('Marketplace error.');reject();};req.ontimeout=function ontimeout(){console.log('Marketplace timeout.');reject();};req.send();this.request=req;});}};Search.provider(new Marketplace());}());;(function(){'use strict';var suggestionsWrapper=document.getElementById('suggestions-wrapper');var suggestionsProvider=document.getElementById('suggestions-provider');var suggestionsSelect=document.getElementById('suggestions-select');function providerUpdated(){navigator.mozL10n.setAttributes(suggestionsProvider,'search-header',{provider:SearchProvider('title').toUpperCase()});var providers=SearchProvider.providers();var selectFragment=document.createDocumentFragment();var optionNode=document.createElement('option');Object.keys(providers).forEach(provider=>{var option=optionNode.cloneNode();option.value=provider;option.text=providers[provider].title;if(provider===SearchProvider.selected()){option.selected=true;}
selectFragment.appendChild(option);});suggestionsSelect.innerHTML='';suggestionsSelect.appendChild(selectFragment);}
function encodeTerms(str,search){return str.replace('{searchTerms}',encodeURIComponent(search));}
function Suggestions(){}
Suggestions.prototype={__proto__:Provider.prototype,name:'Suggestions',currentSearch:null,init:function(){this.metrics=new MetricsHelper();this.metrics.init();Provider.prototype.init.apply(this,arguments);suggestionsSelect.addEventListener('change',function(e){SearchProvider.setProvider(e.target.value);});SearchProvider.ready().then(()=>{providerUpdated();SearchProvider.providerUpdated(()=>{providerUpdated();this.redoSearch();});});},redoSearch:function(){if(!this.currentSearch){return;}
this.search(this.currentSearch).then(results=>{this.render(results);});},click:function(e){this.metrics.report('websearch',SearchProvider('title'));var suggestion=e.target.dataset.suggestion;var url=encodeTerms(SearchProvider('searchUrl'),suggestion);Search.navigate(url);},search:function(input,preventRemote){this.currentSearch=preventRemote?null:input;this.render([input]);if(!navigator.onLine||preventRemote){return Promise.resolve([input]);}
suggestionsWrapper.dataset.loading=true;return SearchProvider.ready().then(()=>{return new Promise((resolve,reject)=>{var url=encodeTerms(SearchProvider('suggestUrl'),input);LazyLoader.getJSON(url,true).then(result=>{var results=result[1];results.unshift(input);resolve(results);});});});},render:function(items){var ul=document.createElement('ul');ul.setAttribute('role','listbox');items.forEach(function each(item){var li=document.createElement('li');li.dataset.suggestion=li.textContent=item;li.setAttribute('role','option');ul.appendChild(li);});suggestionsWrapper.dataset.loading=false;this.container.innerHTML='';if(ul.childNodes.length){this.container.appendChild(ul);}},clear:function(){Provider.prototype.clear.apply(this,arguments);this.currentSearch=null;}};Search.provider(new Suggestions());}());;(function(exports){'use strict';var STORE_NAME='bookmarks_store';function formatBookmark(bookmark){return{data:new GaiaGrid.Bookmark({id:bookmark.url,name:bookmark.name||bookmark.url,url:bookmark.url,icon:bookmark.icon})};}
function Bookmarks(){}
Bookmarks.prototype={__proto__:DataGridProvider.prototype,name:'Bookmarks',init:function(){DataGridProvider.prototype.init.apply(this,arguments);this.persistStore=new InMemoryStore();this.syncStore=new SyncDataStore(STORE_NAME,this.persistStore,'url');return this.syncStore.sync();},get:function(url){var results=this.persistStore.results;for(var idx in results){var item=results[idx];if(item.url===url){return formatBookmark(item);}}
return null;},search:function(filter){var self=this;return new Promise(function(resolve,reject){var renderResults=[];filter=filter.toLowerCase();for(var elem in self.persistStore.results){var bookmark=self.persistStore.results[elem];var name=('name'in bookmark)&&bookmark.name.toLowerCase();if((!bookmark.url||bookmark.url.indexOf(filter)==-1)&&(!name||name.indexOf(filter)==-1)){continue;}
renderResults.push(formatBookmark(bookmark));}
resolve(renderResults);});}};exports.Bookmarks=new Bookmarks();Search.provider(exports.Bookmarks);}(window));;(function(exports){'use strict';var _=navigator.mozL10n.get;var MAX_AWESOME_RESULTS=4;var MAX_HISTORY_RESULTS=20;var MAX_TOPSITES_RESULTS=6;var STORE_NAME='places';var topSitesWrapper=document.getElementById('top-sites');var historyWrapper=document.getElementById('history');if(topSitesWrapper&&historyWrapper){topSitesWrapper.addEventListener('click',itemClicked);historyWrapper.addEventListener('click',itemClicked);}
var cachedLink=document.createElement('a');function parseUrl(url){cachedLink.href=url;return cachedLink;}
var icons={};var iconUrls={};function getIcon(place){if(place.url in icons&&icons[place.url]){return icons[place.url];}
IconsHelper.getIcon(place.url,null,place).then(icon=>{saveIcon(place.url,icon);});return false;}
function saveIcon(key,url){if(key in icons){return;}
icons[key]=null;iconUrls[key]=url;fetchIcon(url,function(err,icon){if(!err){icons[key]=icon;}});}
function fetchIcon(uri,callback){var xhr=new XMLHttpRequest({mozSystem:true});xhr.open('GET',uri,true);xhr.responseType='blob';xhr.addEventListener('load',function(){if(!(xhr.status===200||xhr.status===0)){return callback(new Error('error_downloading'));}
var blob=xhr.response;if(blob.size>this.MAX_ICON_SIZE){return callback(new Error('image_to_large'));}
var img=document.createElement('img');img.src=window.URL.createObjectURL(blob);img.onload=function(){window.URL.revokeObjectURL(img.src);if(img.naturalWidth<=0){return callback(new Error('Cannot load image'));}
callback(null,blob);};img.onerror=function(){window.URL.revokeObjectURL(img.src);return callback(new Error('Cannot load image'));};});xhr.onerror=function(err){return callback(new Error('Cannot load uri'));};xhr.send();}
function itemClicked(e){if(e.target.dataset.url){Search.navigate(e.target.dataset.url);}}
var listTemplate=createList();function createList(){var list=document.createElement('ul');list.setAttribute('role','listbox');return list;}
function incrementHistoryThreshold(timestamp,currentThreshold,thresholds){var newThreshold=currentThreshold+=1;if(timestamp<thresholds[newThreshold]){return incrementHistoryThreshold(timestamp,newThreshold,thresholds);}
return newThreshold;}
function drawHistoryHeading(parent,threshold,timestamp){var LABELS=['future','today','yesterday','last-7-days','this-month','last-6-months','older-than-6-months'];var text='';if(threshold==5&&timestamp){var date=new Date(timestamp);var now=new Date();text=_('month-'+date.getMonth());if(date.getFullYear()!=now.getFullYear()){text+=' '+date.getFullYear();}}else{text=_(LABELS[threshold]);}
var h3=document.createElement('h3');var textNode=document.createTextNode(text);var ul=listTemplate.cloneNode(true);h3.appendChild(textNode);parent.appendChild(h3);parent.appendChild(ul);}
function updateIcon(visit,iconWrapper){var iconDom=iconWrapper.querySelector('img');IconsHelper.getIcon(visit.url,null,visit).then((icon)=>{if(icon&&iconDom){iconDom.onload=function(){iconWrapper.classList.remove('empty');iconDom.style.display='block';};iconDom.src=icon;}});}
function buildHistory(visits){var thresholds=[Date.now(),DateHelper.todayStarted(),DateHelper.yesterdayStarted(),DateHelper.thisWeekStarted(),DateHelper.thisMonthStarted(),DateHelper.lastSixMonthsStarted(),0];var threshold=0;var month=null;var year=null;var fragment=document.createDocumentFragment();visits.forEach(function(visit){if(visit.date>0&&visit.date<thresholds[threshold]){threshold=incrementHistoryThreshold(visit.date,threshold,thresholds);if(threshold!=5){drawHistoryHeading(fragment,threshold);}}
if(threshold===5){var timestampDate=new Date(visit.date);if(timestampDate.getMonth()!=month||timestampDate.getFullYear()!=year){month=timestampDate.getMonth();year=timestampDate.getFullYear();drawHistoryHeading(fragment,threshold,visit.date);}}
visit.meta=visit.url;visit.dataset={url:visit.url};var dom=exports.Places.buildResultsDom([visit]);var iconDom=dom.querySelector('.icon');fragment.appendChild(dom);updateIcon(visit,iconDom);});return fragment;}
function showStartPage(){if(!topSitesWrapper||!historyWrapper){return;}
var store=exports.Places.persistStore;var urls=[];store.readVisits(MAX_HISTORY_RESULTS,function(results){var docFragment=buildHistory(results);historyWrapper.innerHTML='';historyWrapper.appendChild(docFragment);},function filter(visit){var isStored=visit.url in urls;urls[visit.url]=true;return!isStored;});store.read('frecency',MAX_TOPSITES_RESULTS,function(results){var docFragment=document.createDocumentFragment();results.forEach(function(x){docFragment.appendChild(formatTopResult(x));});topSitesWrapper.innerHTML='';topSitesWrapper.appendChild(docFragment);});}
function formatTopResult(result){var div=document.createElement('div');var span=document.createElement('span');if(result.title){span.setAttribute('dir','auto');span.textContent=result.title;}else{span.setAttribute('dir','ltr');span.textContent=result.url;}
div.dataset.url=result.url;div.classList.add('top-site');div.appendChild(span);div.setAttribute('role','link');if(result.screenshot||result.tile){var img=result.screenshot||result.tile;var imgUrl=(typeof img==='string')?img:URL.createObjectURL(img);div.style.backgroundImage='url('+imgUrl+')';}
return div;}
function matchesFilter(value,filter){return!filter||(value&&value.match(new RegExp(filter,'i'))!==null);}
function formatPlace(placeObj,filter){var result={'title':placeObj.title,'meta':placeObj.url,'icon':getIcon(placeObj),'dataset':{'url':placeObj.url},'label':placeObj.title};return result;}
function Places(){}
Places.prototype={__proto__:Provider.prototype,name:'Places',click:itemClicked,init:function(){if(!topSitesWrapper||!historyWrapper){this.header=document.getElementById(this.name.toLowerCase()+'-header');this.container=document.getElementById(this.name.toLowerCase());this.container.addEventListener('click',this.click.bind(this));}
this.persistStore=new PlacesIdbStore();this.persistStore.init().then(()=>{this.syncStore=new SyncDataStore(STORE_NAME,this.persistStore,'url');this.syncStore.filter=function(place){return place.url.startsWith('app://')||place.url==='about:blank';};this.syncStore.onChange=function(){showStartPage();};var rev=this.persistStore.latestRevision||0;return this.syncStore.sync(rev).then(()=>{return new Promise(resolve=>{function done(){showStartPage();resolve();}
asyncStorage.getItem('have-preloaded-sites',(havePreloaded)=>{if(!havePreloaded){this.preloadTopSites().then(()=>{asyncStorage.setItem('have-preloaded-sites',true);done();});}else{done();}});});});});},saveSites:function(sites){return Promise.all(sites.map(site=>{site.frecency=-2;return this.persistStore.addPlace(site);}));},preloadTopSites:function(){return LazyLoader.getJSON('/js/inittopsites.json').then(sites=>{return this.saveSites(sites);});},search:function(filter){return new Promise((resolve,reject)=>{var matchedOrigins={};this.persistStore.read('frecency',MAX_AWESOME_RESULTS,(results)=>{resolve(results.map(function(result){return formatPlace(result,filter);}));},function filterFun(result){if(result.frecency<=0){return false;}
var url=parseUrl(result.url);var matches=!(url.hostname in matchedOrigins)&&(matchesFilter(result.title,filter)||matchesFilter(result.url,filter));if(matches){matchedOrigins[url.hostname]=true;}
return matches;});});}};exports.Places=new Places();Search.provider(exports.Places);}(window));;(function(){'use strict';function LocalApps(){this.apps={};this.appListing=[];this.blacklist;var mozApps=navigator.mozApps.mgmt;mozApps.oninstall=e=>{var app=e.application;var processApp=()=>{this.apps[app.manifestURL]=app;this.createAppListing();};if(app.downloading){app.ondownloadapplied=processApp;}else{processApp();}};mozApps.onuninstall=e=>{delete this.apps[e.application.manifestURL];this.createAppListing();};mozApps.getAll().onsuccess=e=>{e.target.result.forEach(app=>{this.apps[app.manifestURL]=app;});this.createBlacklist().then(()=>{this.createAppListing();});};}
LocalApps.prototype={__proto__:DataGridProvider.prototype,name:'LocalApps',dedupes:true,dedupeStrategy:'exact',createBlacklist:function(){return new Promise((resolve,reject)=>{var self=this;var key='app.launch_path.blacklist';var req=navigator.mozSettings.createLock().get(key);req.onsuccess=function onsuccess(){self.blacklist=req.result[key]||[];resolve();};});},createAppListing:function(){var appListing=[];var blacklist=this.blacklist;var manifestURLs=Object.keys(this.apps);manifestURLs.forEach(function eachManifest(manifestURL){var app=this.apps[manifestURL];var manifest=app.manifest||app.updateManifest;var HIDDEN_ROLES=['system','input','homescreen','search','theme','addon','langpack'];if(HIDDEN_ROLES.indexOf(manifest.role)!==-1){return;}
var entryPoints=manifest.entry_points;if(entryPoints){for(var i in entryPoints){var entry=entryPoints[i];entry.entryPoint=i;entry.manifestURL=app.manifestURL;appListing.push(entry);}}else{manifest.manifestURL=app.manifestURL;appListing.push(manifest);}
if(blacklist){blacklist.forEach(function(blackentry){for(var i in appListing){var app=appListing[i];if(app.launch_path===blackentry){appListing.splice(i,1);}}});}},this);this.appListing=appListing;},removeAppListing:function(app){for(var i in this.appListing){var manifest=this.appListing[i];if(manifest.manifestURL===app.manifestURL){this.appListing.splice(i,1);}}},search:function(input){return new Promise((resolve,reject)=>{var results=this.find(input);var formatted=[];results.forEach(function eachResult(result){formatted.push({dedupeId:result.app.manifestURL,data:new GaiaGrid.Mozapp(result.app,result.entryPoint)});},this);resolve(formatted);});},matches:function(manifest,query){query=query.toLowerCase();var shortName=manifest.short_name||'';var userLang=document.documentElement.lang;var locales=manifest.locales;var localized=locales&&locales[userLang]&&locales[userLang].name;localized=localized||'';return shortName.toLowerCase().indexOf(query)!=-1||manifest.name.toLowerCase().indexOf(query)!=-1||localized.toLowerCase().indexOf(query)!=-1;},find:function(query){var results=[];this.appListing.forEach(function(manifest){if(this.matches(manifest,query)){results.push({app:this.apps[manifest.manifestURL],entryPoint:manifest.entryPoint});}},this);return results;}};Search.provider(new LocalApps());}());