// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Tirhuta`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.1.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x011480, 0x0114C7],
    [0x0114D0, 0x0114D9]
  ]
});
testPropertyEscapes(
  /^\p{Script=Tirhuta}+$/u,
  matchSymbols,
  "\\p{Script=Tirhuta}"
);
testPropertyEscapes(
  /^\p{Script=Tirh}+$/u,
  matchSymbols,
  "\\p{Script=Tirh}"
);
testPropertyEscapes(
  /^\p{sc=Tirhuta}+$/u,
  matchSymbols,
  "\\p{sc=Tirhuta}"
);
testPropertyEscapes(
  /^\p{sc=Tirh}+$/u,
  matchSymbols,
  "\\p{sc=Tirh}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01147F],
    [0x0114C8, 0x0114CF],
    [0x0114DA, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Tirhuta}+$/u,
  nonMatchSymbols,
  "\\P{Script=Tirhuta}"
);
testPropertyEscapes(
  /^\P{Script=Tirh}+$/u,
  nonMatchSymbols,
  "\\P{Script=Tirh}"
);
testPropertyEscapes(
  /^\P{sc=Tirhuta}+$/u,
  nonMatchSymbols,
  "\\P{sc=Tirhuta}"
);
testPropertyEscapes(
  /^\P{sc=Tirh}+$/u,
  nonMatchSymbols,
  "\\P{sc=Tirh}"
);

reportCompare(0, 0);
