/* THIS FILE IS AUTOGENERATED FROM InputMethod.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_InputMethodBinding_h
#define mozilla_dom_InputMethodBinding_h

#include "InputMethodBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/DOMEventTargetHelper.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

struct CompositionClauseParameters;
struct CompositionClauseParametersAtoms;
class EventHandlerNonNull;
class MozInputContext;
struct MozInputContextAtoms;
struct MozInputContextChoicesInfo;
struct MozInputContextChoicesInfoAtoms;
class MozInputContextFocusEventDetail;
struct MozInputContextFocusEventDetailAtoms;
class MozInputContextSelectionChangeEventDetail;
struct MozInputContextSelectionChangeEventDetailAtoms;
class MozInputContextSurroundingTextChangeEventDetail;
struct MozInputContextSurroundingTextChangeEventDetailAtoms;
class MozInputMethod;
struct MozInputMethodAtoms;
struct MozInputMethodChoiceDict;
struct MozInputMethodChoiceDictAtoms;
struct MozInputMethodInputManifest;
struct MozInputMethodInputManifestAtoms;
struct MozInputMethodKeyboardEventDict;
struct MozInputMethodKeyboardEventDictAtoms;
struct MozInputMethodKeyboardEventDictBaseAtoms;
class MozInputMethodManager;
struct MozInputMethodManagerAtoms;
struct MozInputMethodRequiredKeyboardEventDict;
struct MozInputMethodRequiredKeyboardEventDictAtoms;
class MozInputMethodRequiredKeyboardEventDictOrLong;
class MozInputRegistryEventDetail;
struct MozInputRegistryEventDetailAtoms;
struct NativePropertyHooks;
class OwningMozInputMethodRequiredKeyboardEventDictOrLong;
class Promise;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CompositionClauseSelectionType : uint32_t {
  Raw_input,
  Selected_raw_text,
  Converted_text,
  Selected_converted_text,
  EndGuard_
};

namespace CompositionClauseSelectionTypeValues {
extern const EnumEntry strings[5];
} // namespace CompositionClauseSelectionTypeValues

bool
ToJSValue(JSContext* aCx, CompositionClauseSelectionType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class MozInputMethodInputContextTypes : uint32_t {
  Input,
  Textarea,
  Contenteditable,
  Select,
  EndGuard_
};

namespace MozInputMethodInputContextTypesValues {
extern const EnumEntry strings[5];
} // namespace MozInputMethodInputContextTypesValues

bool
ToJSValue(JSContext* aCx, MozInputMethodInputContextTypes aArgument, JS::MutableHandle<JS::Value> aValue);


enum class MozInputMethodInputContextInputTypes : uint32_t {
  Text,
  Search,
  Textarea,
  Number,
  Tel,
  Url,
  Email,
  Password,
  Datetime,
  Date,
  Month,
  Week,
  Time,
  Datetime_local,
  Color,
  Select_one,
  Select_multiple,
  EndGuard_
};

namespace MozInputMethodInputContextInputTypesValues {
extern const EnumEntry strings[18];
} // namespace MozInputMethodInputContextInputTypesValues

bool
ToJSValue(JSContext* aCx, MozInputMethodInputContextInputTypes aArgument, JS::MutableHandle<JS::Value> aValue);


struct CompositionClauseParameters : public DictionaryBase
{
  Optional<int32_t> mLength;
  CompositionClauseSelectionType mSelectionType;

  CompositionClauseParameters();

  explicit inline CompositionClauseParameters(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline CompositionClauseParameters(const CompositionClauseParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const CompositionClauseParameters& aOther);

private:
  static bool
  InitIds(JSContext* cx, CompositionClauseParametersAtoms* atomsCache);
};

namespace binding_detail {
struct FastCompositionClauseParameters : public CompositionClauseParameters
{
  inline FastCompositionClauseParameters()
    : CompositionClauseParameters(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MozInputMethodChoiceDict : public DictionaryBase
{
  Optional<bool> mDisabled;
  Optional<bool> mGroup;
  Optional<Nullable<bool>> mInGroup;
  Optional<Nullable<int32_t>> mOptionIndex;
  Optional<Nullable<bool>> mSelected;
  Optional<nsString> mText;

  MozInputMethodChoiceDict();

  explicit inline MozInputMethodChoiceDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozInputMethodChoiceDict(const MozInputMethodChoiceDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MozInputMethodChoiceDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodChoiceDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozInputMethodChoiceDict : public MozInputMethodChoiceDict
{
  inline FastMozInputMethodChoiceDict()
    : MozInputMethodChoiceDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MozInputMethodInputManifest : public DictionaryBase
{
  Optional<nsString> mDescription;
  nsString mLaunch_path;
  nsString mName;
  Optional<Sequence<MozInputMethodInputContextInputTypes>> mTypes;

  MozInputMethodInputManifest();

  explicit inline MozInputMethodInputManifest(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozInputMethodInputManifest(const MozInputMethodInputManifest& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MozInputMethodInputManifest& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodInputManifestAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozInputMethodInputManifest : public MozInputMethodInputManifest
{
  inline FastMozInputMethodInputManifest()
    : MozInputMethodInputManifest(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MozInputMethodKeyboardEventDictBase : public DictionaryBase
{
  nsString mCode;
  Optional<Nullable<int32_t>> mKeyCode;
  bool mPrintable;
  bool mRepeat;

  MozInputMethodKeyboardEventDictBase();

  explicit inline MozInputMethodKeyboardEventDictBase(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozInputMethodKeyboardEventDictBase(const MozInputMethodKeyboardEventDictBase& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MozInputMethodKeyboardEventDictBase& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodKeyboardEventDictBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozInputMethodKeyboardEventDictBase : public MozInputMethodKeyboardEventDictBase
{
  inline FastMozInputMethodKeyboardEventDictBase()
    : MozInputMethodKeyboardEventDictBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MozInputContextChoicesInfo : public DictionaryBase
{
  Optional<Sequence<MozInputMethodChoiceDict>> mChoices;
  Optional<bool> mMultiple;

  MozInputContextChoicesInfo();

  explicit inline MozInputContextChoicesInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozInputContextChoicesInfo(const MozInputContextChoicesInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MozInputContextChoicesInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozInputContextChoicesInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozInputContextChoicesInfo : public MozInputContextChoicesInfo
{
  inline FastMozInputContextChoicesInfo()
    : MozInputContextChoicesInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MozInputMethodKeyboardEventDict : public MozInputMethodKeyboardEventDictBase
{
  Optional<nsString> mKey;

  MozInputMethodKeyboardEventDict();

  explicit inline MozInputMethodKeyboardEventDict(const FastDictionaryInitializer& )
    : MozInputMethodKeyboardEventDictBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozInputMethodKeyboardEventDict(const MozInputMethodKeyboardEventDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MozInputMethodKeyboardEventDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodKeyboardEventDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozInputMethodKeyboardEventDict : public MozInputMethodKeyboardEventDict
{
  inline FastMozInputMethodKeyboardEventDict()
    : MozInputMethodKeyboardEventDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MozInputMethodRequiredKeyboardEventDict : public MozInputMethodKeyboardEventDictBase
{
  nsString mKey;

  MozInputMethodRequiredKeyboardEventDict();

  explicit inline MozInputMethodRequiredKeyboardEventDict(const FastDictionaryInitializer& )
    : MozInputMethodKeyboardEventDictBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MozInputMethodRequiredKeyboardEventDict(const MozInputMethodRequiredKeyboardEventDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const MozInputMethodRequiredKeyboardEventDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodRequiredKeyboardEventDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozInputMethodRequiredKeyboardEventDict : public MozInputMethodRequiredKeyboardEventDict
{
  inline FastMozInputMethodRequiredKeyboardEventDict()
    : MozInputMethodRequiredKeyboardEventDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class MozInputMethodRequiredKeyboardEventDictOrLong
{
  friend class MozInputMethodRequiredKeyboardEventDictOrLongArgument;
  enum Type
  {
    eUninitialized,
    eMozInputMethodRequiredKeyboardEventDict,
    eLong
  };

  union Value
  {
    UnionMember<binding_detail::FastMozInputMethodRequiredKeyboardEventDict > mMozInputMethodRequiredKeyboardEventDict;
    UnionMember<int32_t > mLong;

  };

  Type mType;
  Value mValue;

  MozInputMethodRequiredKeyboardEventDictOrLong(const MozInputMethodRequiredKeyboardEventDictOrLong&) = delete;
  void operator=(const MozInputMethodRequiredKeyboardEventDictOrLong) = delete;
public:
  explicit inline MozInputMethodRequiredKeyboardEventDictOrLong()
    : mType(eUninitialized)
  {
  }

  inline ~MozInputMethodRequiredKeyboardEventDictOrLong()
  {
    Uninit();
  }

  inline binding_detail::FastMozInputMethodRequiredKeyboardEventDict&
  RawSetAsMozInputMethodRequiredKeyboardEventDict()
  {
    if (mType == eMozInputMethodRequiredKeyboardEventDict) {
      return mValue.mMozInputMethodRequiredKeyboardEventDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMozInputMethodRequiredKeyboardEventDict;
    return mValue.mMozInputMethodRequiredKeyboardEventDict.SetValue();
  }

  inline binding_detail::FastMozInputMethodRequiredKeyboardEventDict&
  SetAsMozInputMethodRequiredKeyboardEventDict()
  {
    if (mType == eMozInputMethodRequiredKeyboardEventDict) {
      return mValue.mMozInputMethodRequiredKeyboardEventDict.Value();
    }
    Uninit();
    mType = eMozInputMethodRequiredKeyboardEventDict;
    return mValue.mMozInputMethodRequiredKeyboardEventDict.SetValue();
  }

  inline bool
  IsMozInputMethodRequiredKeyboardEventDict() const
  {
    return mType == eMozInputMethodRequiredKeyboardEventDict;
  }

  inline binding_detail::FastMozInputMethodRequiredKeyboardEventDict&
  GetAsMozInputMethodRequiredKeyboardEventDict()
  {
    MOZ_ASSERT(IsMozInputMethodRequiredKeyboardEventDict(), "Wrong type!");
    return mValue.mMozInputMethodRequiredKeyboardEventDict.Value();
  }

  inline const MozInputMethodRequiredKeyboardEventDict&
  GetAsMozInputMethodRequiredKeyboardEventDict() const
  {
    MOZ_ASSERT(IsMozInputMethodRequiredKeyboardEventDict(), "Wrong type!");
    return mValue.mMozInputMethodRequiredKeyboardEventDict.Value();
  }

  inline int32_t&
  RawSetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline int32_t&
  SetAsLong()
  {
    if (mType == eLong) {
      return mValue.mLong.Value();
    }
    Uninit();
    mType = eLong;
    return mValue.mLong.SetValue();
  }

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t
  GetAsLong() const
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eMozInputMethodRequiredKeyboardEventDict: {
        DestroyMozInputMethodRequiredKeyboardEventDict();
        break;
      }
      case eLong: {
        DestroyLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyMozInputMethodRequiredKeyboardEventDict()
  {
    MOZ_ASSERT(IsMozInputMethodRequiredKeyboardEventDict(), "Wrong type!");
    mValue.mMozInputMethodRequiredKeyboardEventDict.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    mValue.mLong.Destroy();
    mType = eUninitialized;
  }
};


class OwningMozInputMethodRequiredKeyboardEventDictOrLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningMozInputMethodRequiredKeyboardEventDictOrLong& aUnion);
  enum Type
  {
    eUninitialized,
    eMozInputMethodRequiredKeyboardEventDict,
    eLong
  };

  union Value
  {
    UnionMember<MozInputMethodRequiredKeyboardEventDict > mMozInputMethodRequiredKeyboardEventDict;
    UnionMember<int32_t > mLong;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningMozInputMethodRequiredKeyboardEventDictOrLong()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningMozInputMethodRequiredKeyboardEventDictOrLong(const OwningMozInputMethodRequiredKeyboardEventDictOrLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningMozInputMethodRequiredKeyboardEventDictOrLong()
  {
    Uninit();
  }

  MozInputMethodRequiredKeyboardEventDict&
  RawSetAsMozInputMethodRequiredKeyboardEventDict();

  MozInputMethodRequiredKeyboardEventDict&
  SetAsMozInputMethodRequiredKeyboardEventDict();

  bool
  TrySetToMozInputMethodRequiredKeyboardEventDict(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsMozInputMethodRequiredKeyboardEventDict() const
  {
    return mType == eMozInputMethodRequiredKeyboardEventDict;
  }

  inline MozInputMethodRequiredKeyboardEventDict&
  GetAsMozInputMethodRequiredKeyboardEventDict()
  {
    MOZ_ASSERT(IsMozInputMethodRequiredKeyboardEventDict(), "Wrong type!");
    return mValue.mMozInputMethodRequiredKeyboardEventDict.Value();
  }

  inline MozInputMethodRequiredKeyboardEventDict const &
  GetAsMozInputMethodRequiredKeyboardEventDict() const
  {
    MOZ_ASSERT(IsMozInputMethodRequiredKeyboardEventDict(), "Wrong type!");
    return mValue.mMozInputMethodRequiredKeyboardEventDict.Value();
  }

  int32_t&
  RawSetAsLong();

  int32_t&
  SetAsLong();

  bool
  TrySetToLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsLong() const
  {
    return mType == eLong;
  }

  inline int32_t&
  GetAsLong()
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  inline int32_t const &
  GetAsLong() const
  {
    MOZ_ASSERT(IsLong(), "Wrong type!");
    return mValue.mLong.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningMozInputMethodRequiredKeyboardEventDictOrLong& aOther);

private:
  void
  DestroyMozInputMethodRequiredKeyboardEventDict();

  void
  DestroyLong();
};


namespace MozInputContextBinding {

  typedef mozilla::dom::MozInputContext NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputContext* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputContextBinding



namespace MozInputContextFocusEventDetailBinding {

  typedef mozilla::dom::MozInputContextFocusEventDetail NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputContextFocusEventDetail* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedChoicesValue(mozilla::dom::MozInputContextFocusEventDetail* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputContextFocusEventDetailBinding



namespace MozInputContextSelectionChangeEventDetailBinding {

  typedef mozilla::dom::MozInputContextSelectionChangeEventDetail NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputContextSelectionChangeEventDetail* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputContextSelectionChangeEventDetailBinding



namespace MozInputContextSurroundingTextChangeEventDetailBinding {

  typedef mozilla::dom::MozInputContextSurroundingTextChangeEventDetail NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputContextSurroundingTextChangeEventDetail* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputContextSurroundingTextChangeEventDetailBinding



namespace MozInputMethodBinding {

  typedef mozilla::dom::MozInputMethod NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputMethod* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputMethodBinding



namespace MozInputMethodManagerBinding {

  typedef mozilla::dom::MozInputMethodManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputMethodManager* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputMethodManagerBinding



namespace MozInputRegistryEventDetailBinding {

  typedef mozilla::dom::MozInputRegistryEventDetail NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozInputRegistryEventDetail* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedInputManifestValue(mozilla::dom::MozInputRegistryEventDetail* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace MozInputRegistryEventDetailBinding



class MozInputContextJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputContextJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> GetText(const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetSelectionRange(int32_t start, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> ReplaceSurroundingText(const nsAString& text, const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> DeleteSurroundingText(int32_t offset, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SendKey(const MozInputMethodRequiredKeyboardEventDictOrLong& dictOrKeyCode, const Optional<int32_t>& charCode, const Optional<int32_t>& modifiers, const Optional<bool>& repeat, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Keydown(const MozInputMethodRequiredKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Keyup(const MozInputMethodRequiredKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> SetComposition(const nsAString& text, const Optional<int32_t>& cursor, const Optional<Sequence<CompositionClauseParameters>>& clauses, const MozInputMethodKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> EndComposition(const Optional<nsAString>& text, const MozInputMethodKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputContextJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  Nullable<MozInputMethodInputContextTypes> GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<MozInputMethodInputContextInputTypes> GetInputType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInputMode(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLang(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionStart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionEnd(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetText(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetTextBeforeCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetTextAfterCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnselectionchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsurroundingtextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnselectionchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnsurroundingtextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputContextAtoms* atomsCache);
};


class MozInputContext final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputContext, mozilla::DOMEventTargetHelper)

private:
  RefPtr<MozInputContextJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputContext(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputContext();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  Nullable<MozInputMethodInputContextTypes> GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  Nullable<MozInputMethodInputContextInputTypes> GetInputType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInputMode(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetLang(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetText(const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionStart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  int32_t GetSelectionEnd(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetText(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetTextBeforeCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetTextAfterCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetSelectionRange(int32_t start, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnselectionchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnselectionchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> ReplaceSurroundingText(const nsAString& text, const Optional<int32_t>& offset, const Optional<int32_t>& length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> DeleteSurroundingText(int32_t offset, int32_t length, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnsurroundingtextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnsurroundingtextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SendKey(const MozInputMethodRequiredKeyboardEventDictOrLong& dictOrKeyCode, const Optional<int32_t>& charCode, const Optional<int32_t>& modifiers, const Optional<bool>& repeat, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Keydown(const MozInputMethodRequiredKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Keyup(const MozInputMethodRequiredKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> SetComposition(const nsAString& text, const Optional<int32_t>& cursor, const Optional<Sequence<CompositionClauseParameters>>& clauses, const MozInputMethodKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> EndComposition(const Optional<nsAString>& text, const MozInputMethodKeyboardEventDict& dict, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputContextFocusEventDetailJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputContextFocusEventDetailJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  inline bool
  operator==(const MozInputContextFocusEventDetailJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  MozInputMethodInputContextTypes GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  MozInputMethodInputContextInputTypes GetInputType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetValue(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetChoices(Nullable<MozInputContextChoicesInfo>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetMin(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetMax(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputContextFocusEventDetailAtoms* atomsCache);
};


class MozInputContextFocusEventDetail final : public nsSupportsWeakReference,
                                              public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozInputContextFocusEventDetail)

private:
  RefPtr<MozInputContextFocusEventDetailJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputContextFocusEventDetail(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputContextFocusEventDetail();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  MozInputMethodInputContextTypes GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  MozInputMethodInputContextInputTypes GetInputType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetValue(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetChoices(Nullable<MozInputContextChoicesInfo>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetMin(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetMax(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputContextSelectionChangeEventDetailJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputContextSelectionChangeEventDetailJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  inline bool
  operator==(const MozInputContextSelectionChangeEventDetailJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  bool GetOwnAction(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionStart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  int32_t GetSelectionEnd(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputContextSelectionChangeEventDetailAtoms* atomsCache);
};


class MozInputContextSelectionChangeEventDetail final : public nsSupportsWeakReference,
                                                        public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozInputContextSelectionChangeEventDetail)

private:
  RefPtr<MozInputContextSelectionChangeEventDetailJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputContextSelectionChangeEventDetail(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputContextSelectionChangeEventDetail();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  bool GetOwnAction(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  int32_t GetSelectionStart(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  int32_t GetSelectionEnd(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputContextSurroundingTextChangeEventDetailJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputContextSurroundingTextChangeEventDetailJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  inline bool
  operator==(const MozInputContextSurroundingTextChangeEventDetailJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  bool GetOwnAction(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetText(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetTextBeforeCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetTextAfterCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputContextSurroundingTextChangeEventDetailAtoms* atomsCache);
};


class MozInputContextSurroundingTextChangeEventDetail final : public nsSupportsWeakReference,
                                                              public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozInputContextSurroundingTextChangeEventDetail)

private:
  RefPtr<MozInputContextSurroundingTextChangeEventDetailJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputContextSurroundingTextChangeEventDetail(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputContextSurroundingTextChangeEventDetail();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  bool GetOwnAction(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetText(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetTextBeforeCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetTextAfterCursor(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputMethodJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputMethodJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  void SetActive(bool isActive, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> AddInput(const nsAString& inputId, const MozInputMethodInputManifest& inputManifest, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> RemoveInput(const nsAString& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveFocus(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetValue(const nsAString& value, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOption(int32_t index, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOptions(const Sequence<int32_t>& indexes, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputMethodJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<MozInputMethodManager> GetMgmt(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOninputcontextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<MozInputContext> GetInputcontext(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOninputcontextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodAtoms* atomsCache);
};


class MozInputMethod final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputMethod, mozilla::DOMEventTargetHelper)

private:
  RefPtr<MozInputMethodJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputMethod(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputMethod();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  void SetActive(bool isActive, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<MozInputMethodManager> GetMgmt(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  already_AddRefed<EventHandlerNonNull> GetOninputcontextchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOninputcontextchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<MozInputContext> GetInputcontext(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> AddInput(const nsAString& inputId, const MozInputMethodInputManifest& inputManifest, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> RemoveInput(const nsAString& id, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveFocus(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetValue(const nsAString& value, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOption(int32_t index, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSelectedOptions(const Sequence<int32_t>& indexes, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputMethodManagerJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputMethodManagerJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  void ShowAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool SupportsSwitching(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Hide(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSupportsSwitchingTypes(const Sequence<MozInputMethodInputContextInputTypes>& types, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputMethodManagerJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<EventHandlerNonNull> GetOninputcontextfocus(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOninputcontextblur(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnshowallrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnextrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddinputrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremoveinputrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOninputcontextfocus(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOninputcontextblur(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnshowallrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnnextrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnaddinputrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOnremoveinputrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputMethodManagerAtoms* atomsCache);
};


class MozInputMethodManager final : public mozilla::DOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(MozInputMethodManager, mozilla::DOMEventTargetHelper)

private:
  RefPtr<MozInputMethodManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputMethodManager(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputMethodManager();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  void ShowAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Next(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool SupportsSwitching(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Hide(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSupportsSwitchingTypes(const Sequence<MozInputMethodInputContextInputTypes>& types, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOninputcontextfocus(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOninputcontextfocus(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOninputcontextblur(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOninputcontextblur(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnshowallrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnshowallrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnnextrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnnextrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnaddinputrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnaddinputrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOnremoveinputrequest(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOnremoveinputrequest(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class MozInputRegistryEventDetailJSImpl : public CallbackInterface
{
public:
  explicit inline MozInputRegistryEventDetailJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  void WaitUntil(Promise& p, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozInputRegistryEventDetailJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetManifestURL(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInputId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetInputManifest(Nullable<MozInputMethodInputManifest>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozInputRegistryEventDetailAtoms* atomsCache);
};


class MozInputRegistryEventDetail final : public nsSupportsWeakReference,
                                          public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(MozInputRegistryEventDetail)

private:
  RefPtr<MozInputRegistryEventDetailJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  MozInputRegistryEventDetail(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~MozInputRegistryEventDetail();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  void GetManifestURL(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInputId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetInputManifest(Nullable<MozInputMethodInputManifest>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void WaitUntil(Promise& p, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_InputMethodBinding_h
