/* THIS FILE IS AUTOGENERATED FROM Performance.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_PerformanceBinding_h
#define mozilla_dom_PerformanceBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

class nsGlobalWindow;
class nsPerformance;
struct nsPerformanceAtoms;

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OwningWindowOrWorkerOrSharedWorkerOrServiceWorker;
class ProtoAndIfaceCache;

namespace workers {

class Performance;
struct PerformanceAtoms;
class ServiceWorker;
class SharedWorker;
class WorkerPrivate;

} // namespace workers

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningWindowOrWorkerOrSharedWorkerOrServiceWorker& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningWindowOrWorkerOrSharedWorkerOrServiceWorker& aUnion);


class WindowOrWorkerOrSharedWorkerOrServiceWorker
{
  friend class WindowOrWorkerOrSharedWorkerOrServiceWorkerArgument;
  enum Type
  {
    eUninitialized,
    eWindow,
    eWorker,
    eSharedWorker,
    eServiceWorker
  };

  union Value
  {
    UnionMember<NonNull<nsGlobalWindow> > mWindow;
    UnionMember<NonNull<mozilla::dom::workers::WorkerPrivate> > mWorker;
    UnionMember<NonNull<mozilla::dom::workers::SharedWorker> > mSharedWorker;
    UnionMember<NonNull<mozilla::dom::workers::ServiceWorker> > mServiceWorker;

  };

  Type mType;
  Value mValue;

  WindowOrWorkerOrSharedWorkerOrServiceWorker(const WindowOrWorkerOrSharedWorkerOrServiceWorker&) = delete;
  void operator=(const WindowOrWorkerOrSharedWorkerOrServiceWorker) = delete;
public:
  explicit inline WindowOrWorkerOrSharedWorkerOrServiceWorker()
    : mType(eUninitialized)
  {
  }

  inline ~WindowOrWorkerOrSharedWorkerOrServiceWorker()
  {
    Uninit();
  }

  inline NonNull<nsGlobalWindow>&
  RawSetAsWindow()
  {
    if (mType == eWindow) {
      return mValue.mWindow.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWindow;
    return mValue.mWindow.SetValue();
  }

  inline NonNull<nsGlobalWindow>&
  SetAsWindow()
  {
    if (mType == eWindow) {
      return mValue.mWindow.Value();
    }
    Uninit();
    mType = eWindow;
    return mValue.mWindow.SetValue();
  }

  inline bool
  IsWindow() const
  {
    return mType == eWindow;
  }

  inline NonNull<nsGlobalWindow>&
  GetAsWindow()
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  inline nsGlobalWindow&
  GetAsWindow() const
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  inline NonNull<mozilla::dom::workers::WorkerPrivate>&
  RawSetAsWorker()
  {
    if (mType == eWorker) {
      return mValue.mWorker.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWorker;
    return mValue.mWorker.SetValue();
  }

  inline NonNull<mozilla::dom::workers::WorkerPrivate>&
  SetAsWorker()
  {
    if (mType == eWorker) {
      return mValue.mWorker.Value();
    }
    Uninit();
    mType = eWorker;
    return mValue.mWorker.SetValue();
  }

  inline bool
  IsWorker() const
  {
    return mType == eWorker;
  }

  inline NonNull<mozilla::dom::workers::WorkerPrivate>&
  GetAsWorker()
  {
    MOZ_ASSERT(IsWorker(), "Wrong type!");
    return mValue.mWorker.Value();
  }

  inline mozilla::dom::workers::WorkerPrivate&
  GetAsWorker() const
  {
    MOZ_ASSERT(IsWorker(), "Wrong type!");
    return mValue.mWorker.Value();
  }

  inline NonNull<mozilla::dom::workers::SharedWorker>&
  RawSetAsSharedWorker()
  {
    if (mType == eSharedWorker) {
      return mValue.mSharedWorker.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eSharedWorker;
    return mValue.mSharedWorker.SetValue();
  }

  inline NonNull<mozilla::dom::workers::SharedWorker>&
  SetAsSharedWorker()
  {
    if (mType == eSharedWorker) {
      return mValue.mSharedWorker.Value();
    }
    Uninit();
    mType = eSharedWorker;
    return mValue.mSharedWorker.SetValue();
  }

  inline bool
  IsSharedWorker() const
  {
    return mType == eSharedWorker;
  }

  inline NonNull<mozilla::dom::workers::SharedWorker>&
  GetAsSharedWorker()
  {
    MOZ_ASSERT(IsSharedWorker(), "Wrong type!");
    return mValue.mSharedWorker.Value();
  }

  inline mozilla::dom::workers::SharedWorker&
  GetAsSharedWorker() const
  {
    MOZ_ASSERT(IsSharedWorker(), "Wrong type!");
    return mValue.mSharedWorker.Value();
  }

  inline NonNull<mozilla::dom::workers::ServiceWorker>&
  RawSetAsServiceWorker()
  {
    if (mType == eServiceWorker) {
      return mValue.mServiceWorker.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eServiceWorker;
    return mValue.mServiceWorker.SetValue();
  }

  inline NonNull<mozilla::dom::workers::ServiceWorker>&
  SetAsServiceWorker()
  {
    if (mType == eServiceWorker) {
      return mValue.mServiceWorker.Value();
    }
    Uninit();
    mType = eServiceWorker;
    return mValue.mServiceWorker.SetValue();
  }

  inline bool
  IsServiceWorker() const
  {
    return mType == eServiceWorker;
  }

  inline NonNull<mozilla::dom::workers::ServiceWorker>&
  GetAsServiceWorker()
  {
    MOZ_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline mozilla::dom::workers::ServiceWorker&
  GetAsServiceWorker() const
  {
    MOZ_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eWindow: {
        DestroyWindow();
        break;
      }
      case eWorker: {
        DestroyWorker();
        break;
      }
      case eSharedWorker: {
        DestroySharedWorker();
        break;
      }
      case eServiceWorker: {
        DestroyServiceWorker();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyWindow()
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    mValue.mWindow.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyWorker()
  {
    MOZ_ASSERT(IsWorker(), "Wrong type!");
    mValue.mWorker.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroySharedWorker()
  {
    MOZ_ASSERT(IsSharedWorker(), "Wrong type!");
    mValue.mSharedWorker.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyServiceWorker()
  {
    MOZ_ASSERT(IsServiceWorker(), "Wrong type!");
    mValue.mServiceWorker.Destroy();
    mType = eUninitialized;
  }
};


class OwningWindowOrWorkerOrSharedWorkerOrServiceWorker : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningWindowOrWorkerOrSharedWorkerOrServiceWorker& aUnion);
  enum Type
  {
    eUninitialized,
    eWindow,
    eWorker,
    eSharedWorker,
    eServiceWorker
  };

  union Value
  {
    UnionMember<OwningNonNull<nsGlobalWindow> > mWindow;
    UnionMember<OwningNonNull<mozilla::dom::workers::WorkerPrivate> > mWorker;
    UnionMember<OwningNonNull<mozilla::dom::workers::SharedWorker> > mSharedWorker;
    UnionMember<OwningNonNull<mozilla::dom::workers::ServiceWorker> > mServiceWorker;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningWindowOrWorkerOrSharedWorkerOrServiceWorker()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningWindowOrWorkerOrSharedWorkerOrServiceWorker(const OwningWindowOrWorkerOrSharedWorkerOrServiceWorker& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningWindowOrWorkerOrSharedWorkerOrServiceWorker()
  {
    Uninit();
  }

  OwningNonNull<nsGlobalWindow>&
  RawSetAsWindow();

  OwningNonNull<nsGlobalWindow>&
  SetAsWindow();

  bool
  TrySetToWindow(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsWindow() const
  {
    return mType == eWindow;
  }

  inline OwningNonNull<nsGlobalWindow>&
  GetAsWindow()
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  inline OwningNonNull<nsGlobalWindow> const &
  GetAsWindow() const
  {
    MOZ_ASSERT(IsWindow(), "Wrong type!");
    return mValue.mWindow.Value();
  }

  OwningNonNull<mozilla::dom::workers::WorkerPrivate>&
  RawSetAsWorker();

  OwningNonNull<mozilla::dom::workers::WorkerPrivate>&
  SetAsWorker();

  bool
  TrySetToWorker(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsWorker() const
  {
    return mType == eWorker;
  }

  inline OwningNonNull<mozilla::dom::workers::WorkerPrivate>&
  GetAsWorker()
  {
    MOZ_ASSERT(IsWorker(), "Wrong type!");
    return mValue.mWorker.Value();
  }

  inline OwningNonNull<mozilla::dom::workers::WorkerPrivate> const &
  GetAsWorker() const
  {
    MOZ_ASSERT(IsWorker(), "Wrong type!");
    return mValue.mWorker.Value();
  }

  OwningNonNull<mozilla::dom::workers::SharedWorker>&
  RawSetAsSharedWorker();

  OwningNonNull<mozilla::dom::workers::SharedWorker>&
  SetAsSharedWorker();

  bool
  TrySetToSharedWorker(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsSharedWorker() const
  {
    return mType == eSharedWorker;
  }

  inline OwningNonNull<mozilla::dom::workers::SharedWorker>&
  GetAsSharedWorker()
  {
    MOZ_ASSERT(IsSharedWorker(), "Wrong type!");
    return mValue.mSharedWorker.Value();
  }

  inline OwningNonNull<mozilla::dom::workers::SharedWorker> const &
  GetAsSharedWorker() const
  {
    MOZ_ASSERT(IsSharedWorker(), "Wrong type!");
    return mValue.mSharedWorker.Value();
  }

  OwningNonNull<mozilla::dom::workers::ServiceWorker>&
  RawSetAsServiceWorker();

  OwningNonNull<mozilla::dom::workers::ServiceWorker>&
  SetAsServiceWorker();

  bool
  TrySetToServiceWorker(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsServiceWorker() const
  {
    return mType == eServiceWorker;
  }

  inline OwningNonNull<mozilla::dom::workers::ServiceWorker>&
  GetAsServiceWorker()
  {
    MOZ_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline OwningNonNull<mozilla::dom::workers::ServiceWorker> const &
  GetAsServiceWorker() const
  {
    MOZ_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningWindowOrWorkerOrSharedWorkerOrServiceWorker& aOther);

private:
  void
  DestroyWindow();

  void
  DestroyWorker();

  void
  DestroySharedWorker();

  void
  DestroyServiceWorker();
};


namespace PerformanceBinding {

  typedef nsPerformance NativeType;

  bool
  JsonifyAttributes(JSContext* aCx, JS::Handle<JSObject*> obj, nsPerformance* self, JS::Rooted<JSObject*>& aResult);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, nsPerformance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace PerformanceBinding



namespace PerformanceBinding_workers {

  typedef mozilla::dom::workers::Performance NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::workers::Performance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace PerformanceBinding_workers



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PerformanceBinding_h
