
/* -*- Mode: C++; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * Derived from the Unicode Character Database by genUnicodePropertyData.pl
 *
 * For Unicode terms of use, see http://www.unicode.org/terms_of_use.html
 */

/*
 * Created on Thu Nov 26 21:24:13 2015 from UCD data files with version info:
 *

# Date: 2015-06-16, 20:24:00 GMT [KW]
#
# Unicode Character Database
# Copyright (c) 1991-2015 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
#
# For documentation, see the following:
# NamesList.html
# UAX #38, "Unicode Han Database (Unihan)"
# UAX #44, "Unicode Character Database."
#
# The UAXes can be accessed at http://www.unicode.org/versions/Unicode8.0.0/

This directory contains the final data files
for the Unicode Character Database, for Version 8.0.0 of the Unicode
Standard.


# Scripts-8.0.0.txt
# Date: 2015-03-11, 22:29:42 GMT [MD]

# BidiMirroring-8.0.0.txt
# Date: 2015-01-20, 18:30:00 GMT [KW, LI]

# BidiBrackets-8.0.0.txt
# Date: 2015-01-20, 19:00:00 GMT [AG, LI, KW]

# HangulSyllableType-8.0.0.txt
# Date: 2014-12-16, 23:07:45 GMT [MD]

# File: xidmodifications.txt
# Version: 8.0.0
# Generated: 2015-05-17, 03:09:04 GMT

#
# Unihan_Variants.txt
# Date: 2015-04-30 18:38:20 GMT [JHJ]

# VerticalOrientation-13.txt
# Date: 2014-09-03, 17:30:00 GMT [EM, KI, LI]

 *
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */

#ifndef NS_UNICODE_SCRIPT_CODES
#define NS_UNICODE_SCRIPT_CODES

#pragma pack(1)

#if !ENABLE_INTL_API

struct nsCharProps1 {
  unsigned char mMirrorOffsetIndex:5;
  unsigned char mHangulType:3;
  unsigned char mCombiningClass:8;
};

#endif

#if ENABLE_INTL_API

struct nsCharProps2 {
  unsigned char mPairedBracketType:2;
  unsigned char mVertOrient:2;
  unsigned char mXidmod:4;
};

#endif

#if !ENABLE_INTL_API

struct nsCharProps2 {
  unsigned char mScriptCode:8;
  unsigned char mPairedBracketType:3; // only 2 bits actually needed
  unsigned char mCategory:5;
  unsigned char mBidiCategory:5;
  unsigned char mXidmod:4;
  signed char   mNumericValue:5;
  unsigned char mVertOrient:2;
};

#endif

#pragma pack()

enum {
  MOZ_SCRIPT_COMMON = 0,
  MOZ_SCRIPT_INHERITED = 1,
  MOZ_SCRIPT_ARABIC = 2,
  MOZ_SCRIPT_ARMENIAN = 3,
  MOZ_SCRIPT_BENGALI = 4,
  MOZ_SCRIPT_BOPOMOFO = 5,
  MOZ_SCRIPT_CHEROKEE = 6,
  MOZ_SCRIPT_COPTIC = 7,
  MOZ_SCRIPT_CYRILLIC = 8,
  MOZ_SCRIPT_DESERET = 9,
  MOZ_SCRIPT_DEVANAGARI = 10,
  MOZ_SCRIPT_ETHIOPIC = 11,
  MOZ_SCRIPT_GEORGIAN = 12,
  MOZ_SCRIPT_GOTHIC = 13,
  MOZ_SCRIPT_GREEK = 14,
  MOZ_SCRIPT_GUJARATI = 15,
  MOZ_SCRIPT_GURMUKHI = 16,
  MOZ_SCRIPT_HAN = 17,
  MOZ_SCRIPT_HANGUL = 18,
  MOZ_SCRIPT_HEBREW = 19,
  MOZ_SCRIPT_HIRAGANA = 20,
  MOZ_SCRIPT_KANNADA = 21,
  MOZ_SCRIPT_KATAKANA = 22,
  MOZ_SCRIPT_KHMER = 23,
  MOZ_SCRIPT_LAO = 24,
  MOZ_SCRIPT_LATIN = 25,
  MOZ_SCRIPT_MALAYALAM = 26,
  MOZ_SCRIPT_MONGOLIAN = 27,
  MOZ_SCRIPT_MYANMAR = 28,
  MOZ_SCRIPT_OGHAM = 29,
  MOZ_SCRIPT_OLD_ITALIC = 30,
  MOZ_SCRIPT_ORIYA = 31,
  MOZ_SCRIPT_RUNIC = 32,
  MOZ_SCRIPT_SINHALA = 33,
  MOZ_SCRIPT_SYRIAC = 34,
  MOZ_SCRIPT_TAMIL = 35,
  MOZ_SCRIPT_TELUGU = 36,
  MOZ_SCRIPT_THAANA = 37,
  MOZ_SCRIPT_THAI = 38,
  MOZ_SCRIPT_TIBETAN = 39,
  MOZ_SCRIPT_CANADIAN_ABORIGINAL = 40,
  MOZ_SCRIPT_YI = 41,
  MOZ_SCRIPT_TAGALOG = 42,
  MOZ_SCRIPT_HANUNOO = 43,
  MOZ_SCRIPT_BUHID = 44,
  MOZ_SCRIPT_TAGBANWA = 45,
  MOZ_SCRIPT_BRAILLE = 46,
  MOZ_SCRIPT_CYPRIOT = 47,
  MOZ_SCRIPT_LIMBU = 48,
  MOZ_SCRIPT_LINEAR_B = 49,
  MOZ_SCRIPT_OSMANYA = 50,
  MOZ_SCRIPT_SHAVIAN = 51,
  MOZ_SCRIPT_TAI_LE = 52,
  MOZ_SCRIPT_UGARITIC = 53,
  MOZ_SCRIPT_KATAKANA_OR_HIRAGANA = 54,
  MOZ_SCRIPT_BUGINESE = 55,
  MOZ_SCRIPT_GLAGOLITIC = 56,
  MOZ_SCRIPT_KHAROSHTHI = 57,
  MOZ_SCRIPT_SYLOTI_NAGRI = 58,
  MOZ_SCRIPT_NEW_TAI_LUE = 59,
  MOZ_SCRIPT_TIFINAGH = 60,
  MOZ_SCRIPT_OLD_PERSIAN = 61,
  MOZ_SCRIPT_BALINESE = 62,
  MOZ_SCRIPT_BATAK = 63,
  MOZ_SCRIPT_BLISSYMBOLS = 64,
  MOZ_SCRIPT_BRAHMI = 65,
  MOZ_SCRIPT_CHAM = 66,
  MOZ_SCRIPT_CIRTH = 67,
  MOZ_SCRIPT_OLD_CHURCH_SLAVONIC_CYRILLIC = 68,
  MOZ_SCRIPT_DEMOTIC_EGYPTIAN = 69,
  MOZ_SCRIPT_HIERATIC_EGYPTIAN = 70,
  MOZ_SCRIPT_EGYPTIAN_HIEROGLYPHS = 71,
  MOZ_SCRIPT_KHUTSURI = 72,
  MOZ_SCRIPT_SIMPLIFIED_HAN = 73,
  MOZ_SCRIPT_TRADITIONAL_HAN = 74,
  MOZ_SCRIPT_PAHAWH_HMONG = 75,
  MOZ_SCRIPT_OLD_HUNGARIAN = 76,
  MOZ_SCRIPT_HARAPPAN_INDUS = 77,
  MOZ_SCRIPT_JAVANESE = 78,
  MOZ_SCRIPT_KAYAH_LI = 79,
  MOZ_SCRIPT_LATIN_FRAKTUR = 80,
  MOZ_SCRIPT_LATIN_GAELIC = 81,
  MOZ_SCRIPT_LEPCHA = 82,
  MOZ_SCRIPT_LINEAR_A = 83,
  MOZ_SCRIPT_MANDAIC = 84,
  MOZ_SCRIPT_MAYAN_HIEROGLYPHS = 85,
  MOZ_SCRIPT_MEROITIC_HIEROGLYPHS = 86,
  MOZ_SCRIPT_NKO = 87,
  MOZ_SCRIPT_OLD_TURKIC = 88,
  MOZ_SCRIPT_OLD_PERMIC = 89,
  MOZ_SCRIPT_PHAGS_PA = 90,
  MOZ_SCRIPT_PHOENICIAN = 91,
  MOZ_SCRIPT_MIAO = 92,
  MOZ_SCRIPT_RONGORONGO = 93,
  MOZ_SCRIPT_SARATI = 94,
  MOZ_SCRIPT_ESTRANGELO_SYRIAC = 95,
  MOZ_SCRIPT_WESTERN_SYRIAC = 96,
  MOZ_SCRIPT_EASTERN_SYRIAC = 97,
  MOZ_SCRIPT_TENGWAR = 98,
  MOZ_SCRIPT_VAI = 99,
  MOZ_SCRIPT_VISIBLE_SPEECH = 100,
  MOZ_SCRIPT_CUNEIFORM = 101,
  MOZ_SCRIPT_UNWRITTEN_LANGUAGES = 102,
  MOZ_SCRIPT_UNKNOWN = 103,
  MOZ_SCRIPT_CARIAN = 104,
  MOZ_SCRIPT_JAPANESE = 105,
  MOZ_SCRIPT_TAI_THAM = 106,
  MOZ_SCRIPT_LYCIAN = 107,
  MOZ_SCRIPT_LYDIAN = 108,
  MOZ_SCRIPT_OL_CHIKI = 109,
  MOZ_SCRIPT_REJANG = 110,
  MOZ_SCRIPT_SAURASHTRA = 111,
  MOZ_SCRIPT_SIGNWRITING = 112,
  MOZ_SCRIPT_SUNDANESE = 113,
  MOZ_SCRIPT_MOON = 114,
  MOZ_SCRIPT_MEETEI_MAYEK = 115,
  MOZ_SCRIPT_IMPERIAL_ARAMAIC = 116,
  MOZ_SCRIPT_AVESTAN = 117,
  MOZ_SCRIPT_CHAKMA = 118,
  MOZ_SCRIPT_KOREAN = 119,
  MOZ_SCRIPT_KAITHI = 120,
  MOZ_SCRIPT_MANICHAEAN = 121,
  MOZ_SCRIPT_INSCRIPTIONAL_PAHLAVI = 122,
  MOZ_SCRIPT_PSALTER_PAHLAVI = 123,
  MOZ_SCRIPT_BOOK_PAHLAVI = 124,
  MOZ_SCRIPT_INSCRIPTIONAL_PARTHIAN = 125,
  MOZ_SCRIPT_SAMARITAN = 126,
  MOZ_SCRIPT_TAI_VIET = 127,
  MOZ_SCRIPT_MATHEMATICAL_NOTATION = 128,
  MOZ_SCRIPT_SYMBOLS = 129,
  MOZ_SCRIPT_BAMUM = 130,
  MOZ_SCRIPT_LISU = 131,
  MOZ_SCRIPT_NAKHI_GEBA = 132,
  MOZ_SCRIPT_OLD_SOUTH_ARABIAN = 133,
  MOZ_SCRIPT_BASSA_VAH = 134,
  MOZ_SCRIPT_DUPLOYAN = 135,
  MOZ_SCRIPT_ELBASAN = 136,
  MOZ_SCRIPT_GRANTHA = 137,
  MOZ_SCRIPT_KPELLE = 138,
  MOZ_SCRIPT_LOMA = 139,
  MOZ_SCRIPT_MENDE_KIKAKUI = 140,
  MOZ_SCRIPT_MEROITIC_CURSIVE = 141,
  MOZ_SCRIPT_OLD_NORTH_ARABIAN = 142,
  MOZ_SCRIPT_NABATAEAN = 143,
  MOZ_SCRIPT_PALMYRENE = 144,
  MOZ_SCRIPT_KHUDAWADI = 145,
  MOZ_SCRIPT_WARANG_CITI = 146,
  MOZ_SCRIPT_AFAKA = 147,
  MOZ_SCRIPT_JURCHEN = 148,
  MOZ_SCRIPT_MRO = 149,
  MOZ_SCRIPT_NUSHU = 150,
  MOZ_SCRIPT_SHARADA = 151,
  MOZ_SCRIPT_SORA_SOMPENG = 152,
  MOZ_SCRIPT_TAKRI = 153,
  MOZ_SCRIPT_TANGUT = 154,
  MOZ_SCRIPT_WOLEAI = 155,
  MOZ_SCRIPT_ANATOLIAN_HIEROGLYPHS = 156,
  MOZ_SCRIPT_KHOJKI = 157,
  MOZ_SCRIPT_TIRHUTA = 158,
  MOZ_SCRIPT_CAUCASIAN_ALBANIAN = 159,
  MOZ_SCRIPT_MAHAJANI = 160,
  MOZ_SCRIPT_AHOM = 161,
  MOZ_SCRIPT_HATRAN = 162,
  MOZ_SCRIPT_MODI = 163,
  MOZ_SCRIPT_MULTANI = 164,
  MOZ_SCRIPT_PAU_CIN_HAU = 165,
  MOZ_SCRIPT_SIDDHAM = 166,

  MOZ_NUM_SCRIPT_CODES = 167,

  MOZ_SCRIPT_INVALID = -1
};

#endif
/*
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */
