// Script from security/manager/tools/crtshToIdentifyingStruct/crtshToIdentifyingStruct.py
// Invocation: ../manager/tools/crtshToIdentifyingStruct/crtshToIdentifyingStruct.py -dn -listname RootSymantecDNs 12729019 8983600 12726040 8983601 8984570 68409 26682

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 1 Public Primary Certification Authority - G4
// SHA256 Fingerprint: 36:3F:3C:84:9E:AB:03:B0:A2:A0:F6:36:D7:B8:6D:04
//                     D3:AC:7F:CF:E2:6A:0A:91:21:AB:97:95:F6:E1:76:DF
// https://crt.sh/?id=12729019 (crt.sh ID=12729019)
static const uint8_t CASymantecClass1PublicPrimaryCertificationAuthorityG4DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x34,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 1 Public Primary Certification Authority - G6
// SHA256 Fingerprint: 9D:19:0B:2E:31:45:66:68:5B:E8:A8:89:E2:7A:A8:C7
//                     D7:AE:1D:8A:AD:DB:A3:C1:EC:F9:D2:48:63:CD:34:B9
// https://crt.sh/?id=8983600 (crt.sh ID=8983600)
static const uint8_t CASymantecClass1PublicPrimaryCertificationAuthorityG6DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x36,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 2 Public Primary Certification Authority - G4
// SHA256 Fingerprint: FE:86:3D:08:22:FE:7A:23:53:FA:48:4D:59:24:E8:75
//                     65:6D:3D:C9:FB:58:77:1F:6F:61:6F:9D:57:1B:C5:92
// https://crt.sh/?id=12726040 (crt.sh ID=12726040)
static const uint8_t CASymantecClass2PublicPrimaryCertificationAuthorityG4DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x34,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 2 Public Primary Certification Authority - G6
// SHA256 Fingerprint: CB:62:7D:18:B5:8A:D5:6D:DE:33:1A:30:45:6B:C6:5C
//                     60:1A:4E:9B:18:DE:DC:EA:08:E7:DA:AA:07:81:5F:F0
// https://crt.sh/?id=8983601 (crt.sh ID=8983601)
static const uint8_t CASymantecClass2PublicPrimaryCertificationAuthorityG6DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x36,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 1 Public Primary Certification Authority - G3
// SHA256 Fingerprint: CB:B5:AF:18:5E:94:2A:24:02:F9:EA:CB:C0:ED:5B:B8
//                     76:EE:A3:C1:22:36:23:D0:04:47:E4:F3:BA:55:4B:65
// https://crt.sh/?id=8984570 (crt.sh ID=8984570)
static const uint8_t CAVeriSignClass1PublicPrimaryCertificationAuthorityG3DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
  0x39, 0x39, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 2 Public Primary Certification Authority - G3
// SHA256 Fingerprint: 92:A9:D9:83:3F:E1:94:4D:B3:66:E8:BF:AE:7A:95:B6
//                     48:0C:2D:6C:6C:2A:1B:E6:5D:42:36:B6:08:FC:A1:BB
// https://crt.sh/?id=68409 (crt.sh ID=68409)
static const uint8_t CAVeriSignClass2PublicPrimaryCertificationAuthorityG3DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
  0x39, 0x39, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G3
// SHA256 Fingerprint: EB:04:CF:5E:B1:F3:9A:FA:76:2F:2B:B1:20:F2:96:CB
//                     A5:20:C1:B9:7D:B1:58:95:65:B8:1C:B9:A1:7B:72:44
// https://crt.sh/?id=26682 (crt.sh ID=26682)
static const uint8_t CAVeriSignClass3PublicPrimaryCertificationAuthorityG3DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
  0x39, 0x39, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

static const DataAndLength RootSymantecDNs[]= {
  { CASymantecClass1PublicPrimaryCertificationAuthorityG4DN,
    sizeof(CASymantecClass1PublicPrimaryCertificationAuthorityG4DN) },
  { CASymantecClass1PublicPrimaryCertificationAuthorityG6DN,
    sizeof(CASymantecClass1PublicPrimaryCertificationAuthorityG6DN) },
  { CASymantecClass2PublicPrimaryCertificationAuthorityG4DN,
    sizeof(CASymantecClass2PublicPrimaryCertificationAuthorityG4DN) },
  { CASymantecClass2PublicPrimaryCertificationAuthorityG6DN,
    sizeof(CASymantecClass2PublicPrimaryCertificationAuthorityG6DN) },
  { CAVeriSignClass1PublicPrimaryCertificationAuthorityG3DN,
    sizeof(CAVeriSignClass1PublicPrimaryCertificationAuthorityG3DN) },
  { CAVeriSignClass2PublicPrimaryCertificationAuthorityG3DN,
    sizeof(CAVeriSignClass2PublicPrimaryCertificationAuthorityG3DN) },
  { CAVeriSignClass3PublicPrimaryCertificationAuthorityG3DN,
    sizeof(CAVeriSignClass3PublicPrimaryCertificationAuthorityG3DN) },
};
