# coding=utf-8
#####################################################
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT #
#####################################################
# noqa: E128,E201
from ...aio.asyncclient import AsyncBaseClient
from ...aio.asyncclient import createApiClient
from ...aio.asyncclient import config
from ...aio.asyncclient import createTemporaryCredentials
from ...aio.asyncclient import createSession
_defaultConfig = config


class PurgeCache(AsyncBaseClient):
    """
    The purge-cache service is responsible for tracking cache-purge requests.

    User create purge requests for specific caches on specific workers, and
    these requests are timestamped.  Workers consult the service before
    starting a new task, and purge any caches older than the timestamp.
    """

    classOptions = {
    }
    serviceName = 'purge-cache'
    apiVersion = 'v1'

    async def ping(self, *args, **kwargs):
        """
        Ping Server

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["ping"], *args, **kwargs)

    async def lbheartbeat(self, *args, **kwargs):
        """
        Load Balancer Heartbeat

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["lbheartbeat"], *args, **kwargs)

    async def version(self, *args, **kwargs):
        """
        Taskcluster Version

        Respond with the JSON version object.
        https://github.com/mozilla-services/Dockerflow/blob/main/docs/version_object.md

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["version"], *args, **kwargs)

    async def purgeCache(self, *args, **kwargs):
        """
        Purge Worker Cache

        Publish a request to purge caches named `cacheName` with
        on `workerPoolId` workers.

        If such a request already exists, its `before` timestamp is updated to
        the current time.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["purgeCache"], *args, **kwargs)

    async def allPurgeRequests(self, *args, **kwargs):
        """
        All Open Purge Requests

        View all active purge requests.

        This is useful mostly for administors to view
        the set of open purge requests. It should not
        be used by workers. They should use the purgeRequests
        endpoint that is specific to their workerType and
        provisionerId.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["allPurgeRequests"], *args, **kwargs)

    async def purgeRequests(self, *args, **kwargs):
        """
        Open Purge Requests for a worker pool

        List the caches for this `workerPoolId` that should to be
        purged if they are from before the time given in the response.

        This is intended to be used by workers to determine which caches to purge.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["purgeRequests"], *args, **kwargs)

    async def heartbeat(self, *args, **kwargs):
        """
        Heartbeat

        Respond with a service heartbeat.

        This endpoint is used to check on backing services this service
        depends on.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["heartbeat"], *args, **kwargs)

    funcinfo = {
        "allPurgeRequests": {
            'args': [],
            'method': 'get',
            'name': 'allPurgeRequests',
            'output': 'v1/all-purge-cache-request-list.json#',
            'query': ['continuationToken', 'limit'],
            'route': '/purge-cache/list',
            'stability': 'stable',
        },
        "heartbeat": {
            'args': [],
            'method': 'get',
            'name': 'heartbeat',
            'route': '/__heartbeat__',
            'stability': 'stable',
        },
        "lbheartbeat": {
            'args': [],
            'method': 'get',
            'name': 'lbheartbeat',
            'route': '/__lbheartbeat__',
            'stability': 'stable',
        },
        "ping": {
            'args': [],
            'method': 'get',
            'name': 'ping',
            'route': '/ping',
            'stability': 'stable',
        },
        "purgeCache": {
            'args': ['workerPoolId'],
            'input': 'v1/purge-cache-request.json#',
            'method': 'post',
            'name': 'purgeCache',
            'route': '/purge-cache/<workerPoolId>',
            'stability': 'stable',
        },
        "purgeRequests": {
            'args': ['workerPoolId'],
            'method': 'get',
            'name': 'purgeRequests',
            'output': 'v1/purge-cache-request-list.json#',
            'query': ['since'],
            'route': '/purge-cache/<workerPoolId>',
            'stability': 'stable',
        },
        "version": {
            'args': [],
            'method': 'get',
            'name': 'version',
            'route': '/__version__',
            'stability': 'stable',
        },
    }


__all__ = ['createTemporaryCredentials', 'config', '_defaultConfig', 'createApiClient', 'createSession', 'PurgeCache']
