/* THIS FILE IS AUTOGENERATED FROM GeometryUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_GeometryUtilsBinding_h
#define mozilla_dom_GeometryUtilsBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

class nsIDocument;

namespace mozilla {
namespace dom {

struct BoxQuadOptionsAtoms;
struct ConvertCoordinateOptionsAtoms;
class Element;
struct NativePropertyHooks;
class OwningTextOrElementOrDocument;
class ProtoAndIfaceCache;
class Text;
class TextOrElementOrDocument;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CSSBoxType : uint32_t {
  Margin,
  Border,
  Padding,
  Content,
  EndGuard_
};

namespace CSSBoxTypeValues {
extern const EnumEntry strings[5];
} // namespace CSSBoxTypeValues

bool
ToJSValue(JSContext* aCx, CSSBoxType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTextOrElementOrDocument& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningTextOrElementOrDocument& aUnion);


struct ConvertCoordinateOptions : public DictionaryBase
{
  CSSBoxType mFromBox;
  CSSBoxType mToBox;

  ConvertCoordinateOptions();

  explicit inline ConvertCoordinateOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ConvertCoordinateOptions(const ConvertCoordinateOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ConvertCoordinateOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ConvertCoordinateOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastConvertCoordinateOptions : public ConvertCoordinateOptions
{
  inline FastConvertCoordinateOptions()
    : ConvertCoordinateOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TextOrElementOrDocument
{
  friend class TextOrElementOrDocumentArgument;
  enum Type
  {
    eUninitialized,
    eText,
    eElement,
    eDocument
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::Text> > mText;
    UnionMember<NonNull<mozilla::dom::Element> > mElement;
    UnionMember<NonNull<nsIDocument> > mDocument;

  };

  Type mType;
  Value mValue;

  TextOrElementOrDocument(const TextOrElementOrDocument&) = delete;
  void operator=(const TextOrElementOrDocument) = delete;
public:
  explicit inline TextOrElementOrDocument()
    : mType(eUninitialized)
  {
  }

  inline ~TextOrElementOrDocument()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Text>&
  RawSetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eText;
    return mValue.mText.SetValue();
  }

  inline NonNull<mozilla::dom::Text>&
  SetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    Uninit();
    mType = eText;
    return mValue.mText.SetValue();
  }

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline NonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline mozilla::dom::Text&
  GetAsText() const
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline NonNull<nsIDocument>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline NonNull<nsIDocument>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<nsIDocument>&
  GetAsDocument()
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline nsIDocument&
  GetAsDocument() const
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eText: {
        DestroyText();
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyText()
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    mValue.mText.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyDocument()
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }
};


class OwningTextOrElementOrDocument : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTextOrElementOrDocument& aUnion);
  enum Type
  {
    eUninitialized,
    eText,
    eElement,
    eDocument
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Text> > mText;
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;
    UnionMember<OwningNonNull<nsIDocument> > mDocument;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningTextOrElementOrDocument()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningTextOrElementOrDocument(const OwningTextOrElementOrDocument& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTextOrElementOrDocument()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Text>&
  RawSetAsText();

  OwningNonNull<mozilla::dom::Text>&
  SetAsText();

  bool
  TrySetToText(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline OwningNonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline OwningNonNull<mozilla::dom::Text> const &
  GetAsText() const
  {
    MOZ_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  bool
  TrySetToElement(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  OwningNonNull<nsIDocument>&
  RawSetAsDocument();

  OwningNonNull<nsIDocument>&
  SetAsDocument();

  bool
  TrySetToDocument(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<nsIDocument>&
  GetAsDocument()
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<nsIDocument> const &
  GetAsDocument() const
  {
    MOZ_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningTextOrElementOrDocument& aOther);

private:
  void
  DestroyText();

  void
  DestroyElement();

  void
  DestroyDocument();
};


struct BoxQuadOptions : public DictionaryBase
{
  CSSBoxType mBox;
  Optional<OwningTextOrElementOrDocument> mRelativeTo;

  BoxQuadOptions();

  explicit inline BoxQuadOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BoxQuadOptions(const BoxQuadOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const BoxQuadOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, BoxQuadOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBoxQuadOptions : public BoxQuadOptions
{
  inline FastBoxQuadOptions()
    : BoxQuadOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_GeometryUtilsBinding_h
