/* THIS FILE IS AUTOGENERATED FROM MediaQueryList.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaQueryListBinding_h
#define mozilla_dom_MediaQueryListBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

class MediaQueryList;
struct MediaQueryListAtoms;
class MediaQueryListListener;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

class MediaQueryListListener : public CallbackFunction
{
public:
  explicit inline MediaQueryListListener(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MediaQueryListListener(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MediaQueryListListener(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MediaQueryListListener(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, MediaQueryList& list, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "MediaQueryListListener";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, list, aRv);
  }

  inline void
  Call(MediaQueryList& list, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "MediaQueryListListener";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, list, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, MediaQueryList& list, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, list, rv, aExecutionReason);
  }

  inline void
  Call(MediaQueryList& list, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(list, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const MediaQueryListListener& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, MediaQueryList& list, ErrorResult& aRv);
};


namespace binding_detail {
class FastMediaQueryListListener : public MediaQueryListListener
{
public:
  explicit inline FastMediaQueryListListener(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : MediaQueryListListener(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    MediaQueryListListener::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    MediaQueryListListener::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace MediaQueryListBinding {

  typedef mozilla::dom::MediaQueryList NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaQueryList* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaQueryListBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MediaQueryListBinding_h
