# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate.helpers import MESSAGE_REFERENCE, EXTERNAL_ARGUMENT
from fluent.migrate import COPY, CONCAT, REPLACE

# Custom extension of the CONCAT migration tailored to concat
# two strings separated by a placeable.
class CONCAT_BEFORE_AFTER(CONCAT):
    def __call__(self, ctx):
        assert len(self.elements) == 3
        pattern_before, placeable, pattern_after = self.elements
        elem_before = pattern_before.elements[0]
        elem_after = pattern_after.elements[0]

        if isinstance(elem_before, FTL.TextElement) and elem_before.value[-1] != " ":
            elem_before.value += " "
        if isinstance(elem_after, FTL.TextElement) and elem_after.value[0] != " ":
            elem_after.value = " " + elem_after.value
        return super(CONCAT_BEFORE_AFTER, self).__call__(ctx)

def migrate(ctx):
    """Bug 1445694 - Migrate Preferences::Sync to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/branding/sync-brand.ftl',
        'browser/browser/branding/sync-brand.ftl',
        [
            FTL.Term(
                id=FTL.Identifier('-fxaccount-brand-name'),
                value=COPY(
                    'browser/chrome/browser/syncBrand.dtd',
                    'syncBrand.fxAccount.label'
                )
            ),
        ]
    )

    ctx.add_transforms(
        'browser/browser/preferences/preferences.ftl',
        'browser/browser/preferences/preferences.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('sync-signedout-caption'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'signedOut.caption',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedout-description'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'signedOut.description',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedout-account-title'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'signedOut.accountBox.title',
                    {
                        '&syncBrand.fxAccount.label;': MESSAGE_REFERENCE('-fxaccount-brand-name')
                    },
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedout-account-create'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'signedOut.accountBox.create2',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'signedOut.accountBox.create2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedout-account-signin'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'signedOut.accountBox.signin2',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'signedOut.accountBox.signin2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-profile-picture'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'profilePicture.tooltip',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-disconnect'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'disconnect3.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'disconnect3.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-manage-account'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'verifiedManage.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'verifiedManage.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedin-unverified'),
                value=CONCAT_BEFORE_AFTER(
                    COPY(
                        'browser/chrome/browser/preferences/sync.dtd',
                        'signedInUnverified.beforename.label',
                    ),
                    EXTERNAL_ARGUMENT('email'),
                    COPY(
                        'browser/chrome/browser/preferences/sync.dtd',
                        'signedInUnverified.aftername.label',
                    ),
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedin-login-failure'),
                value=CONCAT_BEFORE_AFTER(
                    COPY(
                        'browser/chrome/browser/preferences/sync.dtd',
                        'signedInLoginFailure.beforename.label',
                    ),
                    EXTERNAL_ARGUMENT('email'),
                    COPY(
                        'browser/chrome/browser/preferences/sync.dtd',
                        'signedInLoginFailure.aftername.label',
                    ),
                )
            ),
            FTL.Message(
                id=FTL.Identifier('sync-resend-verification'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'resendVerification.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'resendVerification.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-remove-account'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'removeAccount.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'removeAccount.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-sign-in'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'signIn.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'signIn.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedin-settings-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'signedIn.settings.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-signedin-settings-desc'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'signedIn.settings.description',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-bookmarks'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.bookmarks.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.bookmarks.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-history'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.history.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.history.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-tabs'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.tabs.label2',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.tabs.title',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.tabs.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-logins'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.logins.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.logins.title',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.logins.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-addresses'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.addresses.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.addresses.title',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.addresses.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-creditcards'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.creditcards.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.creditcards.title',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.creditcards.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-addons'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.addons.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.addons.title',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.addons.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-engine-prefs'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        FTL.Pattern([
                            FTL.Placeable(FTL.SelectExpression(
                                expression=FTL.CallExpression(
                                    callee=FTL.Function('PLATFORM')
                                ),
                                variants=[
                                    FTL.Variant(
                                        key=FTL.VariantName('windows'),
                                        default=False,
                                        value=COPY(
                                            'browser/chrome/browser/preferences/sync.dtd',
                                            'engine.prefsWin.label'
                                        )
                                    ),
                                    FTL.Variant(
                                        key=FTL.VariantName('other'),
                                        default=True,
                                        value=COPY(
                                            'browser/chrome/browser/preferences/sync.dtd',
                                            'engine.prefs.label'
                                        )
                                    )
                                ]
                            )),
                        ]),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('tooltiptext'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.prefs.title'
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'engine.prefs.accesskey'
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-device-name-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'fxaSyncDeviceName.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-device-name-change'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'changeSyncDeviceName2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'changeSyncDeviceName2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-device-name-cancel'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'cancelChangeSyncDeviceName.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'cancelChangeSyncDeviceName.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-device-name-save'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'saveChangeSyncDeviceName.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/sync.dtd',
                            'saveChangeSyncDeviceName.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sync-mobilepromo-single'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'mobilepromo.singledevice',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-mobilepromo-multi'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'mobilepromo.multidevice',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-tos-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'prefs.tosLink.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sync-fxa-privacy-notice'),
                value=COPY(
                    'browser/chrome/browser/preferences/sync.dtd',
                    'fxaPrivacyNotice.link.label',
                ),
            ),
        ]
    )
